#!/bin/csh
#PBS -N AnStat_gnssrobndropp1d_BinValAxisStatsComposite
#PBS -A nmmm0015
#PBS -q casper@casper-pbs
#PBS -l select=1:ncpus=1:mpiprocs=1:mem=12GB
#PBS -l walltime=00:50:00
#PBS -m ae
#PBS -k eod
#PBS -o log.job.out
#PBS -e log.job.err

date

#
# set environment:
# ================
source /etc/profile.d/z00_modules.csh
setenv HDF5_DISABLE_VERSION_CHECK 1
setenv NUMEXPR_MAX_THREADS 1

setenv pySourceDir /glade/derecho/scratch/jwittig/repos-s/mpas-jedi-cron/graphics

# Pass referenceType as environment variable
setenv REFERENCE_TYPE GFS

echo "REFERENCE_TYPE is set to $REFERENCE_TYPE"

set mainScript = AnalyzeStats
ln -sf ${pySourceDir}/${mainScript}.py ./

#
# make plots:
# ===========
module purge
#module load python
#source /glade/u/apps/ch/opt/usr/bin/npl/ncar_pylib.csh default
#module load ncarenv/1.3
#module load gnu/10.1.0
#module load ncarcompilers/0.5.0
#module load netcdf/4.8.1
module load conda/latest
conda activate npl-2023a
setenv PYTHONDONTWRITEBYTECODE 1 # avoid __pycache__ creation
module list

set success = 1
set try = 0
while ($success != 0 && $try < 5)
  @ try++
  echo "try=$try"

  python ${mainScript}.py -n 1 -r 128 -d gnssrobndropp1d -app variational -nout 0 -a BinValAxisStatsComposite  -c 2025-06-22-4wks -e 2025-06-22-4wks:jwittig_3denvar-60-iter_O120km_VarBC.2025-06-22-4wks_cron,2025-06-29-4wks:jwittig_3denvar-60-iter_O120km_VarBC.2025-06-29-4wks_cron -p obs -t omb/oma -l 20180512T18 >& an.log
  grep 'TypeError: super() takes at least 1 argument (0 given)' an.log
  if ( $status == 0 ) then
    sleep 2
    deactivate
    module purge
    #module load python
    module load conda/latest
    conda activate npl-2023a
    module list
    #source /glade/u/apps/ch/opt/usr/bin/npl/ncar_pylib.csh default
  else
    set success = 0
  endif
end

grep 'Finished main() successfully' an.log
if ( $status != 0 ) then
  touch ./FAIL
  exit 1
endif

rm ./*.py

date

exit
