#########################################################
# Problem 2: 
#     Compare statistical downscaling methods. 
#########################################################

# If continuing from "1_ExploreData.R", then working directory should already be
# set and data should
# already be loaded & dates fixed with lubridate. However, we redo this here
# so that this exercise is also stand-alone. 
# In RStudio navigation bar (at top left of screen): "Session" -> "Set Working Directory" -> "To source file location"
obs <- read.table("bldrsubset.txt", header = T)
library(lubridate) # library that makes dates and times easier. #install.packages("lubridate") 
obs$date <- ymd(obs$date) 

##########################
# MOS lab: Start with Temperature
##########################

# Here we will compare MOS change factor, bias correction,
# and empirical CDF (distribution mapping) techniques 
# for Temp and Precip using observed data and the model data
# (control and future) you created in Day 1.

# Read in the model control and future data
# Read in control data for the grid point over Boulder for a run from 1990-2000
# Note: you made this file in yesterday's lab! 
control <- read.table("t2_precip_rtty_1990.txt", header = F, col.names=c("Year", "Month", "Day", "Tmax_C","Pcp_mm"))
class(control)
dim(control)

# Read in the model data for the grid point over Boulder for a run from 2020-2030
future <- read.table("t2_precip_rtty_2020.txt", header = F, col.names=c("Year", "Month", "Day", "Tmax_C","Pcp_mm"))
class(future)
dim(future)
head(future)
summary(future)

# Obs data needs to match the years of the control
obs2 <- subset(obs, year(obs$date) >= 1990 & year(obs$date) <= 2000)
unique(year(obs2$date))

# To simplify = just look at one month at a time, so add a month column
obs2$month = month(obs2$date)

#########################
# Pick a month, and look at model versus observed 
#########################
zmonth = 7 # you can pick any month (1-12 is jan - dec)

# Subset data by month. 
vari.obs = subset(obs2, obs2$month==zmonth, select = TxC)
vari.con = subset(control, Month==zmonth, select = Tmax_C)
vari.fut = subset(future, Month==zmonth, select=Tmax_C)

# Make matrices (instead of data frames) to simplify plotting and basic operations later
vari.obs = as.matrix(vari.obs)
vari.con = as.matrix(vari.con)
vari.fut = as.matrix(vari.fut)

####################################################################
# Make PDFs of the observed, control model data, and future model data
####################################################################
#install.packages("sm") # Only need to install once.
library(sm) # Need to install every time. 
n_xeval = 100
R1 = range(vari.obs, vari.con, vari.fut) # Find range for x-axis
R1
my_xeval =seq(floor(R1[1]), ceiling(R1[2]+3),length=n_xeval ) # Create a sequence of values where the pdfs will be evaluated. Add more to x-axis, since temps increase in future
my_pdf1 = sm.density(vari.obs, eval.points = my_xeval, display = "none")$estimate  # Need sm package for this; library(sm)
my_pdf2 = sm.density(vari.con, eval.points = my_xeval, display = "none")$estimate  
my_pdf3 = sm.density(vari.fut, eval.points = my_xeval, display = "none")$estimate  
# So that we have an appropriate y-range.
ylim_range = range(my_pdf1, my_pdf2, my_pdf3) # Find range for y-axis
ylim_range
plot(my_xeval, my_pdf1, xlim = c(floor(R1[1]), ceiling(R1[2]+3)), type="l", xlab = "Daily Temp", ylab="PDF", lwd = 2, ylim=c(0,max(ylim_range)))
lines(my_xeval, my_pdf2, col="green", lwd = 2)
lines(my_xeval, my_pdf3, col="green", lty =2, lwd = 2)
legend("topleft", c("Observed", "Model Control", "Model Future"), lty = c(1,1,2), col=c("black", "green", "green"), bty="n")

#Your turn 1. What do you notice about each method? 
#Specifically, compare: (i) observed vs model control, 
#                       (ii) model control versus model future, 

###########################################################################
# Step 1: For TEMPERATURE: Use MOS approaches of (i) "delta method"/"change factor", 
#         (ii) "bias correction"/"direct approach", (ii) "Quantile Mapping" 
#         to compare how temperature will change in the future
###########################################################################

##########
# Step 1a. MOS method 1: Calculate delta/change factor
##########

changeFactor = mean(vari.fut) - mean(vari.con) # Difference between average future/modeled temp and average observed temp
changeFactor

vari.CF = vari.obs + changeFactor # Add delta to observed
my_pdf4 = sm.density(vari.CF, eval.points = my_xeval, display = "none")$estimate 
lines(my_xeval, my_pdf4, col="black", lwd=2, lty =2)

################
# Step 1b. MOS method 2: Calculate "bias correction"
################

biasCorrection = mean(vari.obs) - mean(vari.con) # Difference between average observed temp and average control/modeled temp
biasCorrection

variBC = vari.fut + biasCorrection
my_pdf5 = sm.density(variBC, eval.points = my_xeval, display = "none")$estimate 
lines(my_xeval, my_pdf5, col="red", lwd = 2, lty =2)
legend("topleft", c("Observed", "Model Control", "Model Future", "Future CF", "Future BC"), lty = c(1,1,2,2,2), col=c("black", "green", "green", "black", "red"), bty="n")

################
# Step 1c. MOS method 3: Calculate simplist form of "quantile mapping"
################
### ECDF (Empirical CDF matching): make the empirical CDFs match, 
### point-by-point.
# Note: Observed, control, and future data must have same # of points

# First sort the data
variSort = sort(vari.obs)
vari.con.sort = sort(vari.con)

# Calculate the bias point-by-point and add to each future point
ecdfMatching = sort(vari.obs) - sort(vari.con)
range(ecdfMatching) # Fine for Temp example, but may want to look at this with precip - can't divide by zero (precip)
ecdfMatching[is.nan(ecdfMatching)] <-0 # Makes no difference for temp, but will for precip!
variMatching = sort(vari.fut) + ecdfMatching

my_pdf6 = sm.density(variMatching, eval.points = my_xeval, display = "none")$estimate 
lines(my_xeval, my_pdf6, col="purple", lwd = 2, lty =1)
legend("topleft", c("Observed", "Model Control", "Model Future", "Future CF", "Future BC", "Future QM"), lty = c(1,1,2,2,2), col=c("black", "green", "green", "black", "red", "purple"), bty="n")

#Write figure to file:
ext ="png"
fig_name = paste("TMP_MOS_fig", ext, sep=".") # Name file. Will write to working directory unless otherwise specified
dev.print(png,file = fig_name,width = 800, height = 600) #Copies figure that has been made
# Extra 1: Write a pdf file Look at help(device). Hint: make ext = "pdf"
#ext ="pdf"
#fig_name = paste("TMP_MOS_fig", ext, sep=".") # Name file. Will write to working directory unless otherwise specified
#pdf(fig_name, width=7.5, height=4.5, paper="special", onefile=TRUE) # Start writing the pdf plot 
#plot(my_xeval, my_pdf1, ylim=c(0, y.max), type="l", xlab = "PDSI", ylab="PDF", lwd = 2) # Make the plot
#dev.off() # Need to close the pdf file. 
#Look at help(dev.print) and help(device) to see other graphic devices in R
#If using ggplot2 library, try ggsave()

# Use the R commands "mean" and "sd" on the data. 
means = c(mean(vari.obs), mean(vari.con), mean(vari.fut), mean(vari.CF), mean(variBC), mean(variMatching))
stds = c(sd(vari.obs), sd(vari.con), sd(vari.fut), sd(vari.CF), sd(variBC), sd(variMatching))
lbs = c("Obs", "Mod Cntrl", "Mod Fut", "Fut CF", "Fut BC", "Fut QM")
rbind(lbs, round(means,1), round(stds,2))
MOS_factors = c(round(changeFactor,1), round(biasCorrection,2), round(mean(ecdfMatching),2))
labs=c("CF/Delta", "BC/Direct", "QM/average")
rbind(labs, MOS_factors)
#Your Turn 2. Look at the above output, what do you notice about each method? 
#Specifically, compare: (i) observed vs model control, 
#                       (ii) model control versus model future, 
#                       (iii) Model future versus Future CF versus Future BC versus Future QM?  


##################
# Your turn 3: Repeat for precipitation
# Hints: Copy and paste temperature code (from line 49 to here), 
#        Change TxC to Pmm
#        Look at your notes to see the difference in downscaling equations for temp vs precip.
#        Answer the questions based on the graphs you produce, and check your answer on the website
##################

