#########################################################
# Problem 3: Fit Stationary GEV to Block Maxima. 
#########################################################

# If continuing from Problems 1 and/or 2, then working directory should already be
# set and data should
# already be loaded & dates fixed with lubridate. However, we redo this here
# so that this exercise is also stand-alone. 
# In RStudio navigation bar (at top left of screen): "Session" -> "Set Working Directory" -> "To source file location"
# Read in the data (again)
obs <- read.table("bldrsubset.txt", header = T)
library(lubridate) # library that makes dates and times easier. #install.packages("lubridate") 
obs$date <- ymd(obs$date) # Use lubridate to convert to date format
obs$Year = year(obs$date) # Add a Year column - we wil need this for block maxima, as blocks will be years
summary(obs)

# 2014 is not a full time block! Need to remove, be sure to always check your data!
max(obs$date, na.rm=T)
obs=subset(obs, Year<2014)
summary(obs)

# Note: Can't fit GEV with NAs, need to remove. 
# Remove any rows where the precip, which is column 1, is an na. 
Pmmobs = obs[complete.cases(obs[ , 1]),]

library(extRemes) # Need to load library for extRemes

# Plot all the daily data by year. 
plot(Pmm~Year, data = Pmmobs, t="p", col="blue", ylab="Daily PCP (mm)")
plot(Pmm~Year, data = Pmmobs, t="h", col="blue", ylab="Daily PCP (mm)")

# Extract the block maxima by year. 
bp.amax <- blockmaxxer(Pmmobs, blocks = Pmmobs$Year,
                       which = "Pmm")
points(bp.amax$Year, bp.amax$Pmm, col="red", pch=19)

plot(bp.amax$Year, bp.amax$Pmm, type="l", xlab = "Year", ylab="Max Pmm")

fit0 <- fevd(Pmm, data=bp.amax)
# Check the validity of the fit
plot(fit0, "qq2")
plot(fit0, "rl", main="Boulder estimated probability")
plot(fit0, "density")
ci(fit0, type="parameter")
ci(fit0, return.period = c(2,20,100))

# Your Turn 1: Look at the diagnostic plots, from above, or all using plot(fit0). What do you notice about the fit?
# Your Turn 2: Look at the shape parameter, what kind of a tail does the shape parameter suggest? 
# Your Turn 3: Repeat for precipitation, but remove 2013. How does the fit and shape change? 
#              Hint for Your Turn 3: copy and paste above code, but change obs=subset(obs, Year<2013). Then reanswer the above questions
# Your Turn 4: Repeat for temperature. Remember that 2014 should still be removed.
#             Hint for your Turn 4: # When you remove the NAs, remember that temp is column 2: shortobs = obs[complete.cases(obs[ , 2]),]
#             Then answer the questions for temperature (Your Turn 1 and 2 for temp)
#             Check your answers in the website document