#########################################################
# Problem 4: Fit nonstationary GEV to block maxima and test significance. 
#########################################################

# If continuing from Problems 1-3, then working directory should already be
# set and data should
# already be loaded & dates fixed with lubridate. However, we redo this here
# so that this exercise is also stand-alone. 
# In RStudio navigation bar (at top left of screen): "Session" -> "Set Working Directory" -> "To source file location"
# Read in the data (again)
library(extRemes) # Need to load library for extRemes
obs <- read.table("bldrsubset.txt", header = T)
library(lubridate) # library that makes dates and times easier. #install.packages("lubridate") 
obs$date <- ymd(obs$date) # Use lubridate to convert to date format
obs$Year = year(obs$date) # Add a Year column - we wil need this for block maxima, as blocks will be years
summary(obs)
# 2014 is not a full time block! Need to remove, be sure to always check your data!
max(obs$date, na.rm=T)
obs=subset(obs, Year<2014)
summary(obs)

# Note: Can't fit GEV with NAs, need to remove. 
# Remove any rows where the temp, which is column 2, is an na. 
shortobs = obs[complete.cases(obs[ , 2]),]
# Extract the block maxima by year. 
bp.amax <- blockmaxxer(shortobs, blocks = shortobs$Year,
                       which = "TxC")
plot(bp.amax$Year, bp.amax$TxC, type="l", xlab = "Year", ylab="Max TxC")


fit0 <- fevd(TxC, data=bp.amax)

# Add a location covariate
fit1 <-fevd(TxC, data=bp.amax, location.fun = ~Year)
plot(fit1, "qq2")
plot(fit1, "rl", rperiods = c(10, 50, 100))

# Use the likelihood ratio test to see if adding a covariate improves the fit
lr.test(fit0, fit1) # If p-value <0.05, we reject the Null. Models are sig diff (adding covariate improves fit). 

# Compare the AIC's, lower is better
round(summary(fit0, silent=TRUE)$AIC,1)
round(summary(fit1, silent=TRUE)$AIC,1)

# In addition to the location funtion, add a scale function covariate. Try time also
fit2 <-fevd(TxC, data=bp.amax, location.fun = ~Year, scale.fun = ~Year)

# Your turn 1. Does adding a temporal trend to the scale estimate statistical significant? 
# Hint: try lr.test().  You can also look at the AIC value.

# # Your turn 2. Repeat for precipitation or move on to Problem 5. 
# Hint, precip is column 1: shortobs = obs[complete.cases(obs[ , 1]),]
# and for the blockmaxxer command: which = "Pmm"
