
;   Example script to produce plots for a WRF real-data run,
;   with the ARW coordinate dynamics option.

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
;load "./WRFUserARW.ncl"

begin
;   
; The WRF ARW input files  
; This needs to have a ".nc" appended, so just do it.
  a = addfile("/mmmtmp/wrfrt/wrfout_d01_2008-03-11_00:00:00.nc","r")


; We generate plots, but what kind do we prefer?
  type = "x11"
; type = "pdf"
; type = "ps"
; type = "ncgm"


; We know the data ia big, so we will increase the workstation space
  wks = gsn_open_wks(type,"olr")


; Set some Basic Plot Information
; We would like to switch off the Initial Time and Footer info on the plot
; We also do not want titles on the color label bar
  res = True
  res@MainTitle                   = "WRF"
  res@InitTime                    = False
  res@Footer                      = False

  pltres = True
  pltres1 = True
  pltres1@FramePlot = False
  mpres = True
  mpres1 = True

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file
  print("Working on OLR")

; Keep this for Valid time on the plot
  res@TimeLabel = times(0)

; We are interested in a zoomed area with the SW corner at 20N;85W,  
; and the NE corner at 37N;40W
; So get the XY points of these points
  lats = (/  25.0,  47.0 /)
  lons = (/ -120.0, -100.0 /)
  loc = wrf_user_latlon_to_ij(a, lats, lons)
 
; loc(;,0) is south-north (y) and loc(:,1) is west-east (x)
  y_start = loc(0,0)
  y_end = loc(1,0)
  x_start = loc(0,1)
  x_end = loc(1,1)

  mpres1@ZoomIn = True
  mpres1@Xstart = x_start
  mpres1@Ystart = y_start
  mpres1@Xend = x_end
  mpres1@Yend = y_end


; Change color map to something that has a grey scale
  gsn_define_colormap(wks,"wxpEnIR")

  olr = wrf_user_getvar(a,"OLR",8)
  olr_zoom = olr(y_start:y_end,x_start:x_end)

  opts = res                         
  opts@FieldTitle = "OLR"
  opts@cnFillOn = True  
  ;opts@lbTitleOn                   = False
  opts@ContourParameters = (/ 100., 340., 20./)
  opts@gsnSpreadColorStart = 51 
  contour  = wrf_contour(a,wks,olr,opts)
  contourZ = wrf_contour(a,wks,olr_zoom,opts)

; Plot OLR in grey scale for the full domain
  plot = wrf_map_overlays(a,wks,(/contour/),pltres,mpres)

; Do it again, but do not advance the frame, so we can plot
; a box on the output
  plot = wrf_map_overlays(a,wks,(/contour/),pltres1,mpres)
        lnres = True
        lnres@gsLineColor = "NavyBlue"
        lnres@gsLineThicknessF = 3.0

        gsn_polyline(wks,plot,(/lons(0),lons(1)/),(/lats(0),lats(0)/),lnres)
        gsn_polyline(wks,plot,(/lons(0),lons(1)/),(/lats(1),lats(1)/),lnres)
        gsn_polyline(wks,plot,(/lons(0),lons(0)/),(/lats(0),lats(1)/),lnres)
        gsn_polyline(wks,plot,(/lons(1),lons(1)/),(/lats(0),lats(1)/),lnres)

        frame(wks)  ; Now that we are done drawing, draw the frame

; Now zoom into the box area and plot OLR just for this area
  plot = wrf_map_overlays(a,wks,(/contourZ/),pltres,mpres1)
  delete(opts)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

end
