
;   Example script to show how one will overlay text/symbols and lines on a plot

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
;load "./WRFUserARW.ncl"

begin
;
; The WRF ARW input file.  
; This needs to have a ".nc" appended, so just do it.
  a = addfile("./wrfout_d01_2000-01-24_12:00:00.nc","r")


; We generate plots, but what kind do we prefer?
  type = "x11"
; type = "pdf"
; type = "ps"
; type = "ncgm"
  wks = gsn_open_wks(type,"plt_Overlay")
  gsn_define_colormap(wks,"BlAqGrYeOrReVi200")  ; overwrite the .hluresfile color map


; Set some basic resources
  res = True
  res@MainTitle = "REAL-TIME WRF"

  pltres = True
  mpres = True


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; What times and how many time steps are in the data set?
  times  = wrf_user_list_times(a)  ; get times in the file
  ntimes = dimsizes(times)         ; number of times in the file

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  do it = 0,0                      ; TIME LOOP

    print("Working on time: " + times(it) )
    res@TimeLabel = times(it)   ; Set Valid time to use on plots

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

    sst = wrf_user_getvar(a,"SST",it) 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ; Plotting options for SST                
      opts = res                          
      opts@cnFillOn           = True  
      opts@gsnSpreadColorEnd  = -27  
      contour  = wrf_contour(a,wks,sst,opts)


    ; MAKE PLOT                                       
      pltres@FramePlot = False  ; do not frame plot - will do this manually later
      plot = wrf_map_overlays(a,wks,(/contour/),pltres,mpres) 
          pmres = True
          pmres@gsMarkerColor = "Black"
          pmres@gsMarkerIndex = 16
          pmres@gsMarkerSizeF = 0.01
          gsn_polymarker(wks,plot,-80.0,30.0,pmres)
          gsn_polymarker(wks,plot,-70.0,40.0,pmres)
          lnres = True
          lnres@gsLineThicknessF = 3.0
          gsn_polyline(wks,plot,(/-80.0,-70.0/),(/30.0,40.0/),lnres)
          txres = True
          txres@txFont        = "helvetica-bold"
          txres@txFontColor   = "Black"
          txres@txFontHeightF = 0.01
          txres@txJust        = "TopLeft"
          gsn_text(wks,plot,"Mark 1",-79.6,30.0,txres)
          gsn_text(wks,plot,"Mark 2",-69.6,40.0,txres)

          frame(wks)  ; Now that we are done drawing, draw the frame

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  end do        ; END OF TIME LOOP

end
