!WRF:DRIVER_LAYER:MAIN
!
!#define FAILURE_CASE

PROGRAM ndown_em

   USE module_machine
   USE module_domain
!   USE module_integrate
   USE module_driver_constants
   USE module_configure
   USE module_io_domain
   USE module_utility

   USE module_timing
   USE module_wrf_error

   USE module_dm


   IMPLICIT NONE
 ! interface
   INTERFACE
     ! mediation-supplied
     SUBROUTINE med_read_wrf_chem_bioemiss ( grid , config_flags)
       USE module_domain
       TYPE (domain) grid
       TYPE (grid_config_rec_type) config_flags
     END SUBROUTINE med_read_wrf_chem_bioemiss

     SUBROUTINE init_domain_constants_em_ptr ( parent , nest )
       USE module_domain
       USE module_configure
       TYPE(domain), POINTER  :: parent , nest
     END SUBROUTINE init_domain_constants_em_ptr

   END INTERFACE

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!new for bc
   INTEGER :: ids , ide , jds , jde , kds , kde
   INTEGER :: ims , ime , jms , jme , kms , kme
   INTEGER :: ips , ipe , jps , jpe , kps , kpe
   INTEGER :: its , ite , jts , jte , kts , kte
   INTEGER :: ijds , ijde , spec_bdy_width
   INTEGER :: i , j , k , nvchem
   INTEGER :: time_loop_max , time_loop
   INTEGER :: total_time_sec , file_counter
   INTEGER :: julyr , julday , iswater , map_proj
   INTEGER :: icnt

   REAL    :: dt , new_bdy_frq
   REAL    :: gmt , cen_lat , cen_lon , dx , dy , truelat1 , truelat2 , moad_cen_lat , stand_lon

   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: ubdy3dtemp1 , vbdy3dtemp1 , tbdy3dtemp1 , pbdy3dtemp1 , qbdy3dtemp1
   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: mbdy2dtemp1
   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: ubdy3dtemp2 , vbdy3dtemp2 , tbdy3dtemp2 , pbdy3dtemp2 , qbdy3dtemp2
   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: mbdy2dtemp2
   REAL , DIMENSION(:,:,:) , ALLOCATABLE :: cbdy3dtemp1 , cbdy3dtemp2 
   REAL , DIMENSION(:,:,:,:) , ALLOCATABLE :: cbdy3dtemp0

   CHARACTER(LEN=19) :: start_date_char , current_date_char , end_date_char
   CHARACTER(LEN=19) :: stopTimeStr

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   INTEGER :: num_veg_cat , num_soil_top_cat , num_soil_bot_cat

   REAL    :: time
   INTEGER :: rc

   INTEGER :: loop , levels_to_process
   INTEGER , PARAMETER :: max_sanity_file_loop = 100

   TYPE (domain) , POINTER :: keep_grid, grid_ptr, null_domain, parent_grid , nested_grid, grid
   TYPE (domain)           :: dummy
   TYPE (grid_config_rec_type)              :: config_flags
   INTEGER                 :: number_at_same_level
   INTEGER                 :: time_step_begin_restart

   INTEGER :: max_dom , domain_id , fid , fido, fidb , oid , idum1 , idum2 , ierr
   INTEGER :: status_next_var
   INTEGER :: debug_level
   LOGICAL :: input_from_file , need_new_file
   CHARACTER (LEN=19) :: date_string

   INTEGER                 :: nbytes
   INTEGER, PARAMETER      :: configbuflen = 4* CONFIG_BUF_LEN
   INTEGER                 :: configbuf( configbuflen )
   LOGICAL , EXTERNAL      :: wrf_dm_on_monitor

   INTEGER                 :: idsi
   CHARACTER (LEN=80)      :: inpname , outname , bdyname
   CHARACTER (LEN=80)      :: si_inpname
character *19 :: temp19
character *24 :: temp24 , temp24b
character(len=24) :: start_date_hold

   CHARACTER (LEN=80)      :: message
   CHARACTER, DIMENSION(80) :: fname_to_c
integer :: ii

   !  Interface block for routine that passes pointers and needs to know that they
   !  are receiving pointers.

   INTERFACE

      SUBROUTINE med_interp_domain ( parent_grid , nested_grid )
         USE module_domain
         USE module_configure
         TYPE(domain), POINTER :: parent_grid , nested_grid
      END SUBROUTINE med_interp_domain

      SUBROUTINE Setup_Timekeeping( parent_grid )
         USE module_domain
         TYPE(domain), POINTER :: parent_grid
      END SUBROUTINE Setup_Timekeeping

   END INTERFACE

   !  Define the name of this program (program_name defined in module_domain)

   program_name = "NDOWN_RESTART  PREPROCESSOR"

   CALL disable_quilting

   !  Initialize the modules used by the WRF system.  Many of the CALLs made from the
   !  init_modules routine are NO-OPs.  Typical initializations are: the size of a 
   !  REAL, setting the file handles to a pre-use value, defining moisture and 
   !  chemistry indices, etc.

   CALL init_modules(1)   ! Phase 1 returns after MPI_INIT() (if it is called)
   CALL WRFU_Initialize( defaultCalendar=WRFU_CAL_GREGORIAN, rc=rc )
   CALL init_modules(2)   ! Phase 2 resumes after MPI_INIT() (if it is called)

   !  Get the NAMELIST data.  This is handled in the initial_config routine.  All of the
   !  NAMELIST input variables are assigned to the model_config_rec structure.  Below,
   !  note for parallel processing, only the monitor processor handles the raw Fortran
   !  I/O, and then broadcasts the info to each of the other nodes.

   IF ( wrf_dm_on_monitor() ) THEN
     CALL initial_config
   ENDIF
   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )
   CALL wrf_dm_initialize

   !  And here is an instance of using the information in the NAMELIST.  

   CALL nl_get_debug_level ( 1, debug_level )
   CALL set_wrf_debug_level ( debug_level )

   !  Allocated and configure the mother domain.  Since we are in the nesting down
   !  mode, we know a) we got a nest, and b) we only got 1 nest.

   NULLIFY( null_domain )

   CALL       wrf_message ( program_name )
   CALL       wrf_debug ( 100 , 'ndown_em: calling alloc_and_configure_domain coarse ' )
   CALL alloc_and_configure_domain ( domain_id  = 1 ,                  &
                                     grid       = head_grid ,          &
                                     parent     = null_domain ,        &
                                     kid        = -1                   )

   parent_grid => head_grid

   !  Set up time initializations.

   CALL Setup_Timekeeping ( parent_grid )

   CALL domain_clock_set( parent_grid, &
                          time_step_seconds=model_config_rec%interval_seconds )
   CALL       wrf_debug ( 100 , 'ndown_em: calling model_to_grid_config_rec ' )
   CALL model_to_grid_config_rec ( parent_grid%id , model_config_rec , config_flags )
   CALL       wrf_debug ( 100 , 'ndown_em: calling set_scalar_indices_from_config ' )
   CALL set_scalar_indices_from_config ( parent_grid%id , idum1, idum2 )

   !  Initialize the I/O for WRF.

   CALL       wrf_debug ( 100 , 'ndown_em: calling init_wrfio' )
   CALL init_wrfio

   !  Some of the configuration values may have been modified from the initial READ
   !  of the NAMELIST, so we re-broadcast the configuration records.

   CALL get_config_as_buffer( configbuf, configbuflen, nbytes )
   CALL wrf_dm_bcast_bytes( configbuf, nbytes )
   CALL set_config_as_buffer( configbuf, configbuflen )

   !  We need to current and starting dates for the output files.  The times need to be incremented
   !  so that the lateral BC files are not overwritten.

   WRITE ( start_date_char , FMT = '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)' ) &
           model_config_rec%start_year  (parent_grid%id) , &
           model_config_rec%start_month (parent_grid%id) , &
           model_config_rec%start_day   (parent_grid%id) , &
           model_config_rec%start_hour  (parent_grid%id) , &
           model_config_rec%start_minute(parent_grid%id) , &
           model_config_rec%start_second(parent_grid%id) 

   WRITE (   end_date_char , FMT = '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)' ) &
           model_config_rec%  end_year  (parent_grid%id) , &
           model_config_rec%  end_month (parent_grid%id) , &
           model_config_rec%  end_day   (parent_grid%id) , &
           model_config_rec%  end_hour  (parent_grid%id) , &
           model_config_rec%  end_minute(parent_grid%id) , &
           model_config_rec%  end_second(parent_grid%id) 

   !  Override stop time with value computed above.
   CALL domain_clock_set( parent_grid, stop_timestr=end_date_char )

   CALL geth_idts ( end_date_char , start_date_char , total_time_sec ) 

   new_bdy_frq = model_config_rec%interval_seconds
   time_loop_max = total_time_sec / model_config_rec%interval_seconds + 1

   start_date        = start_date_char // '.0000' 
   current_date      = start_date_char // '.0000' 
   start_date_hold   = start_date_char // '.0000'
   current_date_char = start_date_char

   !  Get a list of available file names to try.  This fills up the eligible_file_name
   !  array with number_of_eligible_files entries.  This routine issues a nonstandard
   !  call (system).

   file_counter = 1
   need_new_file = .FALSE.
   !  Open the input data (wrfrst_d01_xxxxxx) for reading.

write(0,*)'Setting parent_grid clock ',current_date(1:19)
   CALL domain_clock_set( parent_grid, &
                          current_timestr=current_date(1:19) )

#ifndef FAILURE_CASE
   CALL construct_filename2a( inpname , 'wrfrst_d<domain>_<date>' , 1 , 2 , current_date_char )

#ifdef RAW_MPI_IO_INPUT
   DO i = 1, len(TRIM(inpname))
       fname_to_c(i) = inpname(i:i)
   ENDDO
   grid => parent_grid
write(0,*)__FILE__,__LINE__,'opening ',trim(inpname)
   CALL mpi_raw_io_open( local_communicator, fname_to_c, len(TRIM(outname)), 1, RWORDSIZE, &
        grid%sd31,grid%ed31,grid%sd33,grid%ed33,grid%sd32,grid%ed32, &
        grid%sm31,grid%em31,grid%sm33,grid%em33,grid%sm32,grid%em32, &
        grid%sp31,grid%ep31,grid%sp33,grid%ep33,grid%sp32,grid%ep32 )
write(0,*)__FILE__,__LINE__,'done opening ',trim(inpname)
   fido = 1
   ierr = 0
# include "raw_restart_in.inc"
write(0,*)__FILE__,__LINE__,'done inpputting restart',trim(inpname)
   CALL mpi_raw_io_close()
write(0,*)__FILE__,__LINE__,'done closing rawio',trim(inpname)
#else
   CALL open_r_dataset     ( fid, inpname , parent_grid , config_flags , "DATASET=RESTART", ierr )
   IF ( ierr .NE. 0 ) THEN
      WRITE( wrf_err_message , * ) 'program ndown: error opening ',TRIM(inpname), &
                                                  ' for reading ierr=',ierr
      CALL WRF_ERROR_FATAL ( wrf_err_message )
   ENDIF
   CALL wrf_debug          ( 100 , 'wrf: calling input_restart' )
write(0,*)__FILE__,__LINE__,'calling input restart'
   CALL input_restart      ( fid , parent_grid , config_flags, ierr )
write(0,*)__FILE__,__LINE__,'done input restart'
   CALL wrf_debug          ( 100 , 'wrf: back from input_restart' )

   !  Get the coarse grid info for later transfer to the fine grid domain.

   CALL wrf_get_dom_ti_integer ( fid , 'MAP_PROJ' , map_proj , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'DX'  , dx  , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'DY'  , dy  , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'CEN_LAT' , cen_lat , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'CEN_LON' , cen_lon , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'TRUELAT1' , truelat1 , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'TRUELAT2' , truelat2 , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'MOAD_CEN_LAT' , moad_cen_lat , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_real    ( fid , 'STAND_LON' , stand_lon , 1 , icnt , ierr ) 
   CALL wrf_get_dom_ti_integer ( fid , 'ISWATER' , iswater , 1 , icnt , ierr ) 

   IF ( wrf_dm_on_monitor() ) THEN

        write(0,*)'MAP_PROJ' , map_proj 
        write(0,*)'DX'  , dx  
        write(0,*)'DY'  , dy  
        write(0,*)'CEN_LAT' , cen_lat 
        write(0,*)'CEN_LON' , cen_lon 
        write(0,*)'TRUELAT1' , truelat1 
        write(0,*)'TRUELAT2' , truelat2 
        write(0,*)'MOAD_CEN_LAT' , moad_cen_lat 
        write(0,*)'STAND_LON' , stand_lon 
        write(0,*)'ISWATER' , iswater 
	
   ENDIF

write(0,*)__FILE__,__LINE__,'calling close_dataset'
   CALL close_dataset      ( fid  , config_flags , "DATASET=RESTART" )
write(0,*)__FILE__,__LINE__,'back from close_dataset'
#endif
#endif

#if 0
   outname="foodle_12"
   DO i = 1, len(TRIM(outname))
       fname_to_c(i) = outname(i:i)
   ENDDO
   grid => parent_grid
   CALL mpi_raw_io_open( local_communicator, fname_to_c, len(TRIM(outname)), 0, RWORDSIZE, &
        grid%sd31,grid%ed31,grid%sd33,grid%ed33,grid%sd32,grid%ed32, &
        grid%sm31,grid%em31,grid%sm33,grid%em33,grid%sm32,grid%em32, &
        grid%sp31,grid%ep31,grid%sp33,grid%ep33,grid%sp32,grid%ep32 )
   fido = 1
   ierr = 0
# include "raw_restart_out.inc"
   CALL mpi_raw_io_close()
   goto 2020
#endif


   !  First time in, do this: allocate sapce for the fine grid, get the config flags, open the 
   !  wrfinput and wrfbdy files.  This COULD be done outside the time loop, I think, so check it
   !  out and move it up if you can.

   CALL       wrf_message ( program_name )
   CALL       wrf_debug ( 100 , 'wrf: calling alloc_and_configure_domain fine ' )
write(0,*)__FILE__,__LINE__,'allocating nest'
   CALL alloc_and_configure_domain ( domain_id  = 2 ,                  &
                                     grid       = nested_grid ,        &
                                     parent     = parent_grid ,        &
                                     kid        = 1                   )
   
   CALL       wrf_debug ( 100 , 'wrf: calling model_to_grid_config_rec ' )
   CALL model_to_grid_config_rec ( nested_grid%id , model_config_rec , config_flags )
   CALL       wrf_debug ( 100 , 'wrf: calling set_scalar_indices_from_config ' )
   CALL set_scalar_indices_from_config ( nested_grid%id , idum1, idum2 )

   !  Set up time initializations for the fine grid.

write(0,*)__FILE__,__LINE__,'setup timekeeping for nest'
   CALL Setup_Timekeeping ( nested_grid )
   ! Strictly speaking, nest stop time should come from model_config_rec...  
   CALL domain_clock_get( parent_grid, stop_timestr=stopTimeStr )

   CALL domain_clock_set( nested_grid,                        &
                          current_timestr=current_date(1:19), &
                          stop_timestr=stopTimeStr ,          &
                          time_step_seconds=                  &
                            model_config_rec%interval_seconds )

   !  Generate an output file from this program, which will be an input file to WRF.

   CALL nl_set_bdyfrq ( nested_grid%id , new_bdy_frq )
   config_flags%bdyfrq = new_bdy_frq

   !  Initialize constants and 1d arrays in fine grid from the parent.

write(0,*)__FILE__,__LINE__,'init_domain_constants'
   CALL init_domain_constants_em_ptr ( parent_grid , nested_grid ) 

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   

   !  Various sizes that we need to be concerned about.

   ids = nested_grid%sd31
   ide = nested_grid%ed31
   kds = nested_grid%sd32
   kde = nested_grid%ed32
   jds = nested_grid%sd33
   jde = nested_grid%ed33

   ims = nested_grid%sm31
   ime = nested_grid%em31
   kms = nested_grid%sm32
   kme = nested_grid%em32
   jms = nested_grid%sm33
   jme = nested_grid%em33

   ips = nested_grid%sp31
   ipe = nested_grid%ep31
   kps = nested_grid%sp32
   kpe = nested_grid%ep32
   jps = nested_grid%sp33
   jpe = nested_grid%ep33

   ijds = MIN ( ids , jds )
   ijde = MAX ( ide , jde )

   print *, ids , ide , jds , jde , kds , kde
   print *, ims , ime , jms , jme , kms , kme
   print *, ips , ipe , jps , jpe , kps , kpe
   print *, ijds , ijde

   spec_bdy_width = model_config_rec%spec_bdy_width
   print *,'spec_bdy_width=',spec_bdy_width

   CALL domain_clock_set( nested_grid,                        &
                          current_timestr=current_date(1:19), &
                          time_step_seconds=                  &
                            model_config_rec%interval_seconds )

   !  Do the horizontal interpolation.

   nested_grid%imask_nostag = 1
   nested_grid%imask_xstag = 1
   nested_grid%imask_ystag = 1
   nested_grid%imask_xystag = 1
#ifndef FAILURE_CASE
write(0,*)__FILE__,__LINE__,'calling med_interp_domain'
   CALL med_interp_domain ( parent_grid , nested_grid )
write(0,*)__FILE__,__LINE__,'back from med_interp_domain'
#endif
   nested_grid%ht_int = nested_grid%ht

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   !  Different things happen during the different time loops:
   !      first loop - write wrfinput file, close data set, copy files to holder arrays
   !      middle loops - diff 3d/2d arrays, compute and output bc
   !      last loop - diff 3d/2d arrays, compute and output bc, write wrfbdy file, close wrfbdy file


   !  Set the time info.

write(0,*)'setting current_date on nest = ',__FILE__,__LINE__,current_date
   CALL domain_clock_set( nested_grid, &
                                current_timestr=current_date(1:19) )

   !  Output the first time period of the data.

write(0,*)'current_date_char used to open nested restart file = ',__FILE__,__LINE__,current_date
   CALL wrf_debug          ( 100 , 'ndown_em main: calling open_w_dataset for wrf restart' )
   CALL construct_filename2a( outname , 'wrfrst_d<domain>_<date>' , 2 , 2 , current_date_char )

!************
#ifdef RAW_MPI_IO_OUTPUT
   DO i = 1, len(TRIM(outname))
       fname_to_c(i) = outname(i:i)
   ENDDO
   grid => nested_grid
write(0,*)__FILE__,__LINE__,'opening ',trim(outname)
   CALL mpi_raw_io_open( local_communicator, fname_to_c, len(TRIM(outname)), 0, RWORDSIZE, &
        grid%sd31,grid%ed31,grid%sd33,grid%ed33,grid%sd32,grid%ed32, &
        grid%sm31,grid%em31,grid%sm33,grid%em33,grid%sm32,grid%em32, &
        grid%sp31,grid%ep31,grid%sp33,grid%ep33,grid%sp32,grid%ep32 )
write(0,*)__FILE__,__LINE__,'done opening ',trim(outname)
   fido = 1
   ierr = 0
# include "raw_restart_out.inc"
write(0,*)__FILE__,__LINE__,'done outputting restart',trim(outname)
   CALL mpi_raw_io_close()
write(0,*)__FILE__,__LINE__,'done closing rawio',trim(outname)
#else
!************

   CALL open_w_dataset     ( fido, TRIM(outname) , nested_grid , config_flags , output_restart , "DATASET=RESTART", ierr )
   IF ( ierr .NE. 0 ) THEN
      WRITE( wrf_err_message , FMT='(A,A,A,I8)' ) 'program ndown: error opening ',TRIM(outname),' for reading ierr=',ierr
      CALL WRF_ERROR_FATAL ( wrf_err_message )
   ENDIF
   CALL output_restart ( fido , nested_grid , config_flags , ierr )
write(0,*)' after output_restart of nested_grid ierr = ', ierr,' fido = ',fido

   !  Close the input (wrfout_d01_000000, for example) file.  That's right, the 
   !  input is an output file.  Who'd've thunk.
   
   CALL close_dataset      ( fido , config_flags , "DATASET=RESTART" )
#endif

2020 continue
   CALL wrf_debug ( 0 , 'SUCCESS COMPLETE NDOWN_EM' )

   CALL model_to_grid_config_rec ( parent_grid%id , model_config_rec , config_flags )
write(0,*)__FILE__,__LINE__,'med_shutdown_io'
   CALL med_shutdown_io ( parent_grid , config_flags )

write(0,*)__FILE__,__LINE__,'wrf_shutdown'
   CALL wrf_shutdown

write(0,*)__FILE__,__LINE__,'WRFU_Finalize'
   CALL WRFU_Finalize( rc=rc )
write(0,*)__FILE__,__LINE__,'Out'

END PROGRAM ndown_em


SUBROUTINE init_domain_constants_em_ptr ( parent , nest ) 
   USE module_domain
   USE module_configure
   IMPLICIT NONE
   TYPE(domain), POINTER  :: parent , nest
   INTERFACE 
   SUBROUTINE init_domain_constants_em ( parent , nest )
      USE module_domain
      USE module_configure
      TYPE(domain)  :: parent , nest
   END SUBROUTINE init_domain_constants_em
   END INTERFACE 
   CALL init_domain_constants_em ( parent , nest )
END SUBROUTINE init_domain_constants_em_ptr

LOGICAL FUNCTION em_cd_feedback_mask( pig, ips_save, ipe_save , pjg, jps_save, jpe_save, xstag, ystag )
   USE module_configure
   IMPLICIT NONE
   INTEGER, INTENT(IN) :: pig, ips_save, ipe_save , pjg, jps_save, jpe_save
   LOGICAL, INTENT(IN) :: xstag, ystag
                                      
   INTEGER ioff, joff, spec_zone      

   CALL nl_get_spec_zone( 1, spec_zone )
   ioff = 0 ; joff = 0             
   IF ( xstag  ) ioff = 1          
   IF ( ystag  ) joff = 1
   
   em_cd_feedback_mask = ( pig .ge. ips_save+spec_zone        .and.      &
                           pjg .ge. jps_save+spec_zone        .and.      &
                           pig .le. ipe_save-spec_zone  +ioff .and.      &
                           pjg .le. jpe_save-spec_zone  +joff           )
                             
                             
END FUNCTION em_cd_feedback_mask

SUBROUTINE init_domain_constants_em ( parent , nest )
   USE module_domain
   USE module_configure
   IMPLICIT NONE
   TYPE(domain)  :: parent , nest

   INTEGER iswater , map_proj, julyr, julday
   REAL    cen_lat, cen_lon, truelat1 , truelat2 , gmt , moad_cen_lat , stand_lon
   CHARACTER (LEN=4) :: char_junk

! single-value constants

   nest%p_top   = parent%p_top
   nest%cfn     = parent%cfn
   nest%cfn1    = parent%cfn1
   nest%rdx     = 1./nest%dx
   nest%rdy     = 1./nest%dy
!  nest%dts     = nest%dt/float(nest%time_step_sound)
   nest%dtseps  = parent%dtseps  ! used in height model only?
   nest%resm    = parent%resm    ! used in height model only?
   nest%zetatop = parent%zetatop ! used in height model only?
   nest%cf1     = parent%cf1
   nest%cf2     = parent%cf2
   nest%cf3     = parent%cf3
   nest%gmt     = parent%gmt
   nest%julyr   = parent%julyr
   nest%julday  = parent%julday

   CALL nl_get_mminlu ( 1,char_junk(1:4) )
   CALL nl_get_iswater (1, iswater )
   CALL nl_get_truelat1 ( 1 , truelat1 )
   CALL nl_get_truelat2 ( 1 , truelat2 )
   CALL nl_get_moad_cen_lat ( 1 , moad_cen_lat )
   CALL nl_get_stand_lon ( 1 , stand_lon )
   CALL nl_get_map_proj ( 1 , map_proj )
   CALL nl_get_gmt ( 1 , gmt)
   CALL nl_get_julyr ( 1 , julyr)
   CALL nl_get_julday ( 1 , julday)
   IF ( nest%id .NE. 1 ) THEN
     CALL nl_set_gmt (nest%id, gmt)
     CALL nl_set_julyr (nest%id, julyr)
     CALL nl_set_julday (nest%id, julday)
     CALL nl_set_iswater (nest%id, iswater )
     CALL nl_set_truelat1 ( nest%id , truelat1 )
     CALL nl_set_truelat2 ( nest%id , truelat2 )
     CALL nl_set_moad_cen_lat ( nest%id , moad_cen_lat )
     CALL nl_set_stand_lon ( nest%id , stand_lon )
     CALL nl_set_map_proj ( nest%id , map_proj )
   END IF
   nest%gmt     = gmt 
   nest%julday  = julday
   nest%julyr   = julyr
   nest%iswater = iswater
   nest%cen_lat = cen_lat
   nest%cen_lon = cen_lon
   nest%truelat1= truelat1
   nest%truelat2= truelat2
   nest%moad_cen_lat= moad_cen_lat
   nest%stand_lon= stand_lon
   nest%map_proj= map_proj

   nest%step_number  = parent%step_number

! 1D constants (Z)

   nest%em_fnm    = parent%em_fnm
   nest%em_fnp    = parent%em_fnp
   nest%em_rdnw   = parent%em_rdnw
   nest%em_rdn    = parent%em_rdn
   nest%em_dnw    = parent%em_dnw
   nest%em_dn     = parent%em_dn
   nest%em_znu    = parent%em_znu
   nest%em_znw    = parent%em_znw
   nest%em_t_base = parent%em_t_base

END SUBROUTINE init_domain_constants_em

SUBROUTINE start_domain_em 
write(0,*)' start_domain_em stub -- should never be called '
END SUBROUTINE start_domain_em

SUBROUTINE init_modules_em
END SUBROUTINE init_modules_em

