!NRL: $Id: mcel_grid.F,v 1.1.2.4 2003/07/02 22:05:05 dykes Exp $
!NRL: $Name:  $
************************************************************************
      subroutine mcel_grid (mcelio, nx, ny, xoffset, yoffset, 
     &           deltax, deltay, depths, xgrid, ygrid, projt1)
************************************************************************
#ifdef API
      implicit none
#endif

      include 'MCEL.inc'
      include 'mcel_swan.inc'

      integer ierr, ndim(2)
      real*8 origin(2), dxm(2)
      real    xgrid(nx, ny), ygrid(nx, ny)
      real    newdepths(nx, ny), depths(*)
      integer mask(nx, ny)
      character*72 projt1

#ifdef API
      INCLUDE 'swcomm1.inc'
      INCLUDE 'swcomm2.inc'
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
      include 'coupling_api.inc'
      include 'wrf_io_flags.h'
      CHARACTER*256  tstr, sysdepinfo
      CHARACTER*256  dimnames(3)
      INTEGER, DIMENSION(3) :: DomainStart, DomainEnd
      INTEGER, DIMENSION(3) :: MemoryStart, MemoryEnd
      INTEGER, DIMENSION(3) ::  PatchStart,  PatchEnd
      INTEGER  ix, iy
#endif

************************************************************************
      entry mcel_grid1 (mcelio, nx, ny, xoffset, yoffset,
     &           deltax, deltay, depths)
************************************************************************


#ifdef API

        write(0,*)'mcel_grid 1'
       sysdepinfo = 'LANDMASK_I=MASK'
       write(tstr,'(f15.8)')deltax
       sysdepinfo = trim(sysdepinfo) // ',MCEL_DELTA_X=' // trim(tstr)
       write(tstr,'(f15.8)')deltay
       sysdepinfo = trim(sysdepinfo) // ',MCEL_DELTA_Y=' // trim(tstr)
       write(tstr,'(f15.8)')xoffset
       sysdepinfo = trim(sysdepinfo) // ',MCEL_ORIGIN_X=' // trim(tstr)
       write(tstr,'(f15.8)')yoffset
       sysdepinfo = trim(sysdepinfo) // ',MCEL_ORIGIN_Y=' // trim(tstr)

        write(*,*)'mcel_grid 2'
       DomainStart(1) = 1 ; DomainEnd(1) = MXC
       MemoryStart(1) = 1 ; MemoryEnd(1) = MXC
        PatchStart(1) = 1 ;  PatchEnd(1) = MXC
       DomainStart(2) = 1 ; DomainEnd(2) = MYC
       MemoryStart(2) = 1 ; MemoryEnd(2) = MYC
        PatchStart(2) = 1 ;  PatchEnd(2) = MYC
       DomainStart(3) = 1 ; DomainEnd(3) = 1
       MemoryStart(3) = 1 ; MemoryEnd(3) = 1
        PatchStart(3) = 1 ;  PatchEnd(3) = 1
       write(*,*)'MXC ',MXC, ' MYC ', MYC
       write(*,*)'DomainStart ',DomainStart
       write(*,*)'MemoryStart ',MemoryStart
       write(*,*)'PatchStart ',PatchStart
       write(*,*)'DomainEnd ',DomainEnd
       write(*,*)'MemoryEnd ',MemoryEnd
       write(*,*)'PatchEnd ',PatchEnd
       DimNames(1) = ' ' ; DimNames(2) = ' ' ; DimNames(3) = ' '
       if ( mcelio .EQ. 0 ) then
        write(0,*)'mcel_grid 3 mcelio ', mcelio
        CALL ext_mcel_open_for_write_begin ( 'SWANOUT'           ,
     +                                       idum , idum      ,
     +                                       sysdepinfo    ,
     +                                       api_grids(mcelio)     ,
     +                                       ierr               )

!these are training writes
           if (OVSVTY(IVTYPE) .lt. 3) then
         write(0,*)'mcel_grid: training ext_mcel_write_field: ',
     +             OVSNAM(IVTYPE)
             CALL ext_mcel_write_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   OVSNAM(IVTYPE),          ! VarName
     &                                   idum,                    ! DUMMY Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
           else
         write(0,*)'mcel_grid: training ext_mcel_write_field: ',
     +             'U'//OVSNAM(IVTYPE)
             CALL ext_mcel_write_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'U'//OVSNAM(IVTYPE),     ! VarName
     &                                   idum,                    ! Dummy Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
         write(0,*)'mcel_grid: training ext_mcel_write_field: ',
     +             'V'//OVSNAM(IVTYPE)
             CALL ext_mcel_write_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'V'//OVSNAM(IVTYPE),     ! VarName
     &                                   idum,                    ! Dummy Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )

           endif
       else
        write(0,*)'mcel_grid 4 mcelio ', mcelio
        sysdepinfo = trim(sysdepinfo) // ',FILTER_HANDLE=SWANIN'
        write(0,*)'      sysdepinfo   ', trim(sysdepinfo) 
        CALL ext_mcel_open_for_read_begin ( 'interpolation.ior'   ,
     +                                       idum , idum      ,
     +                                       sysdepinfo    ,
     +                                       api_grids(mcelio)     ,
     +                                       ierr               )
! training reads
        write(0,*)'mcel_grid 5'
             CALL ext_mcel_read_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'U10',                   ! VarName
     &                                   idum,                    ! Dummy Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
        write(0,*)'mcel_grid 6'
            CALL ext_mcel_read_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'V10',                   ! VarName
     &                                   idum,                    ! Dummy Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
        write(0,*)'mcel_grid 7', mcelio, api_grids(mcelio)

        endif

       if ( mcelio .EQ. 0 ) then
         ! Set grid mask (0:land ; 1:water)
         mask = 0
         do ix = 1, nx
           do iy = 1, ny
             xp = xgrid(ix, iy)
             yp = ygrid(ix, iy)
             newdepths(ix, iy) = SVALQI (xp, yp, 1, depths ,1 ,ix ,iy)
           end do
         end do
         where (newdepths .ge. 1.) mask = 1

        write(0,*)'mcel_grid 8'
             CALL ext_mcel_write_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'MASK',                  ! VarName
     &                                   mask,                    ! Dummy Field
     &                                   WRF_INTEGER,             ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
        write(0,*)'mcel_grid 9'
           CALL ext_mcel_open_for_write_commit (api_grids(mcelio),ierr)
        write(0,*)'mcel_grid 10'
       else
        write(0,*)'mcel_grid 12',nx,ny
             CALL ext_mcel_read_field ( api_grids(mcelio),
     &                                   '1999-11-09_12:00:00',   ! dummy date
     &                                   'MASK',                  ! VarName
     &                                   mask,                    ! Dummy Field
     &                                   WRF_INTEGER,             ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
           CALL ext_mcel_open_for_read_commit (api_grids(mcelio),ierr)
        write(0,*)'mcel_grid 13'
       endif


#else
      ! Create a new grid
      call NewGrid (id_grid(mcelio), 2, MCEL_GRIDTYPE_REGULAR,
     &     MCEL_GRIDCENT_NODAL, MCEL_GRIDCOORD_LATLONG, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error creating new grid', mcelio
      else
        write (*, '(a25,i5)') 'mcel_grid: new grid set:', mcelio
      endif
      ! Set grid dimensions
      ndim(1) = nx
      ndim(2) = ny
      call SetSize (id_grid(mcelio), ndim, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting ndim'
      else
        write (*, '(a20,i5,i5)') 'mcel_grid: dims set:', ndim
      endif

      ! Set grid origin
      origin(1) = xoffset
      origin(2) = yoffset
      call SetOrigin (id_grid(mcelio), origin, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting origin'
      else
        write (*, '(a22, f8.2, f8.2)') 'mcel_grid: origin set:', origin
      endif

      ! Set grids cell sizes
      dxm(1) = deltax
      dxm(2) = deltay
      call SetDX (id_grid(mcelio), dxm, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting grid dx'
      else
        write (*, '(a25,f8.2,f8.2)') 'mcel_grid: dx and dy set:', dxm
      endif

      if (mcelio >= 1) then
         ! Create a new interpolation object from the farm
         call NewFilter (id_interp(mcelio), "relfile:interpolation.ior",
     &      "Recv side interpolation", ierr)
         if (ierr.ne.0) then
            print *, 'mcel_grid: failed creating interpolation filter'
         end if

         ! Link output grid and interpolation program
         call SetOutputGrid (id_interp(mcelio), id_grid(mcelio), ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error linking grid and interp filter'
         else
           print *, 'mcel_grid: grid set for getting from MCEL'
         end if
      else
         ! Set grid mask (0:land ; 1:water)
         mask = 0
         do ix = 1, nx 
           do iy = 1, ny
             xp = xgrid(ix, iy)
             yp = ygrid(ix, iy)
             newdepths(ix, iy) = SVALQI (xp, yp, 1, depths ,1 ,ix ,iy)
           end do
         end do
         where (newdepths .ge. 1.) mask = 1
  
         call SetMask (id_grid(mcelio), mask, ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error setting grid mask'
         endif

         ! Set a new program
         call NewProgram (id_program, 'SWAN'//projt1, ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error setting new program'
         else
           print*, 'mcel_grid: setting new program, ', 'SWAN'//projt1
         end if

         ! Link grid and program
         call SetGrid (id_program, id_grid(mcelio), ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error linking grid and program'
         else
           print *, 'mcel_grid: grid set for putting into MCEL'
         end if
      end if
#endif
   
      return
      end
