!NRL: $Id: ocpdpn.F,v 1.1.1.2 2003/03/28 15:35:32 dykes Stab $
!NRL: $Name:  $
C
C     Dynamic data pool management routines
C
C     DPBLDP
C     DPINQA
C     DPADDP
C     DPINQP
C     IADRS
C     DPEXPR
C     DPMAXR
C     DPMINR
C     DPSHFT
C     DPCHEK
C     DPGETI
C     DPGETR
C     DPPUTR
C     COPYCH
C     OCREAL
C     OCINTG
C
************************************************************************
*                                                                      *
      SUBROUTINE DPBLDP (ARRAY, LENARR, LENPNM, LENADT, IERR)             30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
C  2. PURPOSE
C
C     Build a pool structure into an ARRAY
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array into which pointer structure is to be
C                       built
C     LENARR : input    length of the array ARRAY, if input value
C                       is negative, it is assumed that the array
C                       already contains the proper length
C     LENPNM : input    length provided for names of pointers
C     LENADT : input    length provided for additional data in
C                       the pointer
C     IERR    int    input    if =0: standard message, if =-1, no message,
C                             if <-1: more complete message               30.81
C                    output   0=no errors, otherwise: >0                  30.81
C                             9=end-of-file                               30.81
C
      INTEGER   ARRAY(*), LENARR, LENPNM, LENADT,                         30.72
     &          IERR                                                      30.81
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPLARR : location where to find length of the available array
C     DPLOCP : location where to find number of occupied places
C     DPNPNS : location where to find number of pointers
C     DPLPNM : location where to find length of the pointer name
C     DPLPNT : location where to find length of the whole pointer
C     DPADAT : location where to find length of additional pointer data
C     DPLGDA : length of the general data in an array with pool structure
C
C     Pool general data
C
      INTEGER   DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT,                   30.72
     &          DPADAT, DPLGDA
C
C     IENT : number of entries into this subroutine
C     JJ   : counter
C
      INTEGER   IENT, JJ
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C       --
C
C 10. ERROR MESSAGES
C
C     101 : not enough space in array
C     111 : pointer name already exists
C
C 11. REMARKS
C
C     General data in a pool are the following:
C     Available length, Occupied length, Number of pointers,
C     Length of pointer names, total length of a pointer,
C     Length of additional data in a pointer
C
C     OPMNLI : number of characters that can be stored in one integer number
C     OPMLFC : largest allowed integer character (ASCII) code + 1
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT,                  30.06
     &           DPADAT, DPLGDA
      DATA       DPLARR/1/, DPLOCP/2/, DPNPNS/3/, DPLPNM/4/, DPLPNT/5/,   30.06
     &           DPADAT/6/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPBLDP')
*
      IF (LENARR .GT. 0) THEN
        ARRAY(DPLARR) = LENARR
      ELSE
        LENARR = ARRAY(DPLARR)
      ENDIF
*
*     DPLGDA is the number of general data in a pool structure
*
      IF (DPLGDA .GT. LENARR) THEN
        IERR = 101                                                        30.81
        CALL MSGERR (3, 'array is not long enough')
        RETURN
      ENDIF
      ARRAY(DPLOCP) = DPLGDA
      ARRAY(DPNPNS) = 0
      ARRAY(DPLPNM) = LENPNM
      ARRAY(DPLPNT) = 2 + LENPNM + LENADT
      ARRAY(DPADAT) = LENADT
      IF (ITEST.GE.150) WRITE (PRTEST, 12) (ARRAY(JJ), JJ=1,12)
  12  FORMAT (' Test DPBLDP ', 12I8)
      IERR = 0                                                            30.81
      RETURN
**    end of subroutine DPBLDP  **
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPINQA (ARRAY, LENARR, LENOCP, NUMPNS,
     &                   LENPNM, LENADT, IERR)                            30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
C  2. PURPOSE
C
C     provide information about the base pointer of an array              30.80
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     LENARR : output   length of the array ARRAY
C     LENOCP : output   number of occupied places in the array
C     NUMPNS : output   number of pointers in the array
C     LENPNM : output   length provided for names of pointers
C     LENADT : output   length provided for additional data in
C            :          the pointer
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C
      INTEGER   ARRAY(*), LENARR, LENOCP, NUMPNS, LENPNM, LENADT,         30.72
     &          IERR                                                      30.81
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPLARR : location where to find length of the available array
C     DPLOCP : location where to find number of occupied places
C     DPNPNS : location where to find number of pointers
C     DPLPNM : location where to find length of the pointer name
C     DPLPNT : location where to find length of the whole pointer
C     DPADAT : location where to find length of additional pointer data
C     DPLGDA : length of the general data in an array with pool structure
C
C     Pool general data
C
      INTEGER   DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT,                   30.72
     &          DPADAT
 
C     II     : counter
C     IENT   : number of entries into this subroutine
C
      INTEGER   II
      INTEGER   IENT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C       --
C
C 10. ERROR MESSAGES
C
C     105 : incorrect pool structure
C
C 11. REMARKS
C
C     General data in a pool are the following:
C     Available length, Occupied length, Number of pointers,
C     Length of pointer names, total length of a pointer,
C     Length of additional data in a pointer
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       Obtain length of array, number of occupied places,
C       number of pointers, length of each pointer, and number
C       of additional data from base pointer
C       If number of occupied places > length of array
C          or total length of pointers > number of occupied places
C       Then write error message
C            set error status
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT,                  30.06
     &           DPADAT
      DATA       DPLARR/1/, DPLOCP/2/, DPNPNS/3/, DPLPNM/4/, DPLPNT/5/,   30.06
     &           DPADAT/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPINQA')
*
      LENARR = ARRAY(DPLARR)
      LENOCP = ARRAY(DPLOCP)
      NUMPNS = ARRAY(DPNPNS)
      LENPNM = ARRAY(DPLPNM)
      LENADT = ARRAY(DPADAT)
      IF (LENOCP.GT.LENARR .OR. NUMPNS*ARRAY(DPLPNT).GT.LENOCP) THEN
        CALL MSGERR (3, 'incorrect pool structure')
        WRITE (PRTEST, 12) LENARR, LENOCP, NUMPNS,
     &                     LENPNM, LENADT, IERR                           30.81
        IERR = 105                                                        30.81
        IF (ITEST.GE.100) THEN
          WRITE (PRTEST,14) (ARRAY(II), II=1,ITEST-90)
  14      FORMAT (10(1X,I7))
        ENDIF
      ELSE
        IERR = 0                                                          30.81
      ENDIF
      IF (ITEST.GE.220) WRITE (PRTEST, 12) LENARR, LENOCP, NUMPNS,
     &                   LENPNM, LENADT, IERR                             30.81
  12  FORMAT (' Exit DPINQA: lenarr,occpl,numpns,lenpnm,lenadt,status',
     &        6I8)
      RETURN
**    end of subroutine DPINQA  **
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPADDP (ARRAY, PNAME, PINDEX, PTYPE, PADRES, IERR)     30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     40.03: Nico Booij
C
C  1. UPDATES
C
C     ver 30.01
C     30.02         : meaning of STATUS on input modified
C     30.03         : 5th argument was PADATA, is modified into PADRES
C                     there was inconsistency with usage in SWAN
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Removed STOP statement
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Feb. 00: local copy of pointer name used in error message
C
C  2. PURPOSE
C
C     Adding a new pointer
C
C  3. METHOD
C
C     If the name of the pointer is not yet present, all data in array
C     ARRAY after the names and pointers of the existing pointsets
C     are moved LENPNT places and the free places are filled with the new
C     name, the pointer to the start of the record and the recordlength.
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C     PADRES : output   location in ARRAY where to find first data
C     PINDEX : output   index of the new pointer
C     PTYPE  : input    type of the data referenced by the new pointer
C                       S: single precision data, P: pointers
C                       of the record referenced by pointer
C
      INTEGER   ARRAY(*), PINDEX, PADRES, INSTAT,                         30.72
     &          IERR                                                      30.81
C
C     PNAME  : input    name of the new pointer
C
      CHARACTER PNAME*(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     JJ     : counter
C     LENPNM : length of a pointer name
C     LENREC : length of a record (subarray)
C     LINSRT : insert location
C     NSTAT  : ??
C     NEWLEN : new length of subarray
C     OLDLEN : old length of subarray
C
      INTEGER   IENT, JJ, LENPNM, LENREC, LINSRT,
     &          NSTAT, NEWLEN, OLDLEN
C
C     DPLARR : location where to find length of the available array
C     DPLOCP : location where to find number of occupied places
C     DPNPNS : location where to find number of pointers
C     DPLPNM : location where to find length of the pointer name
C     DPLPNT : location where to find length of the whole pointer
C     DPADAT : location where to find length of additional pointer data
C     DPLGDA : length of the general data in an array with pool structure
C
C     Pool general data
C
      INTEGER   DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT, DPLGDA            30.72
C
C     PTYPE  : pointer type (P=points to subarray of pointers,
C                            S=points to subarray of num. data)
C     PTYPX  : aux. pointer type
C     PNAME_L : local copy of PNAME      (modification needed for Linux)  40.03
C
      CHARACTER PTYPE *1, PTYPX *1, PNAME_L *16                           40.03
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DPSHFT and COPYCH (Ocean Pack)
C
C     STPNOW : logical function, if True program must terminate
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C       --
C
C 10. ERROR MESSAGES
C
C     101 : not enough space in array
C     111 : pointer name already exists
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       If pointer name is not blank
C       Then Call DPINQP to find corresponding pointer index
C            If index > 0
C            Then message: Pointer name already exists
C       Else Make index = 0
C       ----------------------------------------------------------------
C       Check if enough space is available
C       Shift data beyond the pointer
C       Insert new pointer data
C       Update general pool data
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE       DPLARR, DPLOCP, DPNPNS, DPLPNM, DPLPNT,                  30.06
     &           DPLGDA
      DATA       DPLARR/1/, DPLOCP/2/, DPNPNS/3/, DPLPNM/4/, DPLPNT/5/,   30.06
     &           DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPADDP')
*
      INSTAT = IERR                                                       30.81
      IF (ITEST.GE.140) WRITE (PRTEST, 8) PNAME, PTYPE
   8  FORMAT (' Entry DPADDP ', A, 1X, A)
      IF (PNAME .NE. '    ') THEN
C
C       find out whether the pointer name already exists
C
        IERR   = 0                                                        30.81
        PINDEX = 0
        CALL DPINQP (ARRAY, PNAME, PINDEX, PTYPX, PADRES, LENREC,
     &               IERR)                                                30.81
        IF (IERR.NE.0 .AND. IERR.NE.112 .AND. IERR.NE.120) THEN           30.81
          WRITE (PRINTF, 11) IERR                                         30.81
  11      FORMAT (' Error from DPINQP ', I4)
          RETURN
        ENDIF
        IF (PINDEX.NE.0) THEN
          IF (INSTAT.LT.-1 .OR. PTYPE.NE.PTYPX) THEN
            PNAME_L = PNAME                                               40.03
            CALL MSGERR (2, 'pointer already exists: '//PNAME_L)          40.03
            WRITE (PRINTF, 12) PNAME, PINDEX, PTYPX
  12        FORMAT (' ->  name=', A, ' index=', I3, ' type=', A1)
            IERR   = 111                                                  30.81
          ENDIF
          RETURN
        ENDIF
      ELSE
C
C       no pointer name, add nameless pointer
C
        PINDEX = 0
      ENDIF
C
C     check available space in the array
C
      OLDLEN = ARRAY(DPLOCP)
      PADRES = OLDLEN + ARRAY(DPLPNT) + 1
      IF (PTYPE .EQ. 'P') THEN
        NEWLEN = PADRES + DPLGDA + 1
      ELSE
        NEWLEN = PADRES + 1
      ENDIF
      IF (NEWLEN .GT. ARRAY(DPLARR)) THEN
         IERR   = 101                                                     30.81
         IF (INSTAT.EQ.-3) THEN
            CALL MSGERR (2, 'array is too small for new pointer')
            RETURN
         ELSE
            CALL MSGERR (4, 'array is too small for new pointer')
         ENDIF
      ENDIF
C
C     shift the data to make room for the new pointer
C
      LINSRT = DPLGDA + 1 + ARRAY(DPLPNT) * ARRAY(DPNPNS)
      NSTAT  = 0
      CALL DPSHFT (ARRAY, LINSRT, ARRAY(DPLPNT), NSTAT)
      IF (STPNOW()) RETURN                                                34.01
      IF (NSTAT .NE. 0) THEN
        IERR   = NSTAT                                                    30.81
        RETURN
      ENDIF
*
*     add new pointer
*
      ARRAY(LINSRT)   = PADRES
      ARRAY(LINSRT+1) = ICHAR(PTYPE)
      LENPNM = ARRAY(DPLPNM)
      IF (LENPNM .GT. 0)
     &   CALL COPYCH (PNAME, 'T', ARRAY(LINSRT+2), LENPNM, IERR)          30.81
C
C     update general data of the pool
C
      PINDEX          = ARRAY(DPNPNS) + 1
      ARRAY(DPNPNS)   = PINDEX
      ARRAY(DPLOCP)   = NEWLEN
C
C     make new (empty) record
C
      IF (PTYPE .EQ. 'P') THEN
C
C       make default pool structure in the new record
C
        NSTAT = 0
        CALL DPBLDP (ARRAY(PADRES), DPLGDA, 0, 0, NSTAT)
        IERR   = NSTAT                                                    30.81
      ELSE
C
C       add (empty) data record
C
        ARRAY(PADRES) = 0
      ENDIF
      ARRAY(NEWLEN)   = PINDEX
      IF (ITEST.GE.180) WRITE (PRTEST, 32) (ARRAY(JJ), JJ=1,DPLGDA),
     &   (ARRAY(JJ), JJ=LINSRT, LINSRT+10)
  32  FORMAT (' Test DPADDP ', 6I8, /, 12X, 11I8)
C
      IF (IERR.LE.0) IERR = 0                                             30.81
      RETURN
**    end of subroutine DPADDP  **
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPINQP (ARRAY, PNAME, PINDEX, PTYPE, PADRES, LENREC,
     &                   IERR)                                            30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     40.03: Nico Booij
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     30.81, Jan. 99: Replaced variable FROM by FROM_ and TO by TO_ (because
C                     FROM and TO are reserved words)
C     40.03, Feb. 00: local copy of pointer name used in error message
C
C  2. PURPOSE
C
C     Provide the index of a pointer given by name, as well as the
C     address and length of the associated record
C
C  3. METHOD
C
C     If the name of the pointer is not yet present, index and address
C     will both be made 0.
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : input    index of a pointer given by its name
C            : output   index of a pointer
C     PADRES : output   location in ARRAY where to find first data
C                       of the record referenced by pointer
C     LENREC : output   length of the record referenced by pointer
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C                                                                         30.81
      INTEGER   ARRAY(*), PINDEX, PADRES, IERR, LENREC                    30.81
C
C     PNAME  : input    name of a pointer
C              output   pointer name of a pointer given by index
C     PTYPE  : output   type of data in record referenced by pointer
C
      CHARACTER PNAME *(*), PTYPE *1
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : number of entries into this subroutine
C     II     : counter
C     INSTAT : initial status
C     LENARR : length of the array ARRAY, if input value is negative,
C              it is assumed that the array already contains the proper
C              length
C     LENADT : length provided for additional data in the pointer
C     LENPNM : length of a pointer name
C     LENPNT : length of pointer
C     LL     : ??
C     NUMPNS : number of pointers in the array
C
      INTEGER   IENT, INSTAT, II, LENARR, LENADT, LENOCP, LENPNM,
     +          LENPNT, LL,NUMPNS
C
C     DPLGDA : length of the general data in an array with pool structure
C     DPLPNM : location where to find length of the pointer name
C     DPLPNT : location where to find length of the whole pointer
C     DPNPNS : location where to find number of pointers
C
C     Pool general data
C
      INTEGER   DPLGDA, DPLPNM, DPLPNT, DPNPNS                            30.72
C
C     FROM_   : conversion direction, value F
C     PNAMEX  : aux. pointer name
C     PNAME_L : local copy of PNAME      (modification needed for Linux)  40.03
C
      CHARACTER FROM_ , PNAMEX *80, PNAME_L *16                           40.03
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     COPYCH (Ocean Pack)
C
C  9. SUBROUTINES CALLING
C
C     DPADDP
C
C 10. ERROR MESSAGES
C
C     112 : pointer name not found
C     113 : no pointer names are known in the array
C     114 : Pointer name nor index given
C     115 : Pointer index out of range
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE DPNPNS, DPLPNM, DPLPNT, DPLGDA, FROM_                          30.81
      DATA IENT /0/
      DATA DPNPNS/3/, DPLPNM/4/, DPLPNT/5/, DPLGDA/6/
      DATA FROM_/'F'/                                                     30.81
      CALL STRACE (IENT,'DPINQP')
C
      INSTAT = IERR                                                       30.81
      CALL DPINQA (ARRAY, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &              IERR)                                                 30.81
      IF (IERR.NE.0) RETURN                                               30.81
      IF (NUMPNS .EQ. 0) THEN
        IF (INSTAT.LT.-1 .OR. ITEST.GT.0) THEN
          CALL MSGERR (0, 'number of pointers in array is 0')
        ENDIF
        IERR = 120                                                        30.81
        RETURN
      ENDIF
      IF (PNAME .NE. '    ') THEN
        PINDEX = 0
        IF (LENPNM .GT. 0) THEN
          LENPNT = ARRAY(DPLPNT)
          DO 40 II = 1, NUMPNS
            IERR = 0                                                      30.81
            CALL COPYCH (PNAMEX, FROM_,                                   30.81
     &                   ARRAY(DPLGDA+(II-1)*LENPNT+3), LENPNM,
     &                   IERR)                                            30.81
            LL = LEN(PNAME)
            IF (PNAME.EQ.PNAMEX(1:LL) .AND. PNAMEX(LL+1:80).EQ.'   ')
     &      THEN
              PINDEX = II
              GOTO 70
            ENDIF
  40      CONTINUE
          IF (IERR.LT.0) THEN                                             30.81
            PNAME_L = PNAME                                               40.03
            CALL MSGERR (0,
     &       'pointer name not found: '//PNAME_L)                         40.03
          ENDIF
          IERR   = 112                                                    30.81
          RETURN
        ELSE
          CALL MSGERR (3, 'array does not contain pointer names')
          IERR   = 113                                                     30.81
          RETURN
        ENDIF
      ELSE
        IF (PINDEX.EQ.0) THEN
          IF (IERR.LT.0 .OR. ITEST.GT.0) THEN                             30.81
            CALL MSGERR (2, 'Pointer name nor index given')
          ENDIF
          IERR   = 114                                                     30.81
          PADRES = 0
          RETURN
        ELSE IF (PINDEX.LT.0 .OR. PINDEX.GT.ARRAY(DPNPNS)) THEN
          IF (INSTAT.NE.-1 .OR. ITEST.GT.0) THEN
            CALL MSGERR (2, 'Pointer index out of range')
          ENDIF
          IERR   = 115                                                     30.81
          PADRES = 0
          RETURN
        ELSE
          LENPNM = ARRAY(DPLPNM)
          IF (LENPNM .GT. 0) THEN
            LENPNT = ARRAY(DPLPNT)
*           provide pointer name
            CALL COPYCH (PNAME, FROM_,                                    30.81
     &                   ARRAY(DPLGDA+(PINDEX-1)*LENPNT+3),LENPNM,
     &                   IERR)                                            30.81
          ENDIF
        ENDIF
      ENDIF
C
  70  LENPNT = ARRAY(DPLPNT)
      PADRES = ARRAY(DPLGDA+(PINDEX-1)*LENPNT+1)
      LENREC = ARRAY(PADRES)
      PTYPE  = CHAR(ARRAY(DPLGDA+(PINDEX-1)*LENPNT+2))
      IF (IERR.LE.0) IERR = 0                                             30.81
      IF (ITEST.GE.250) WRITE (PRTEST, 74) PNAME, PINDEX,
     &                   PTYPE, PADRES, LENREC, IERR                      30.81
  74  FORMAT (' Exit DPINQP: pname,index,type,adres,lenrec,status ',
     &        A, I5, 1X, A1, 3I8)
      RETURN
**    end of subroutine DPINQP  **
      END
************************************************************************
*                                                                      *
      INTEGER FUNCTION IADRS (ARRAY, PINDEX)                              30.72
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
C  2. PURPOSE
C
C     Provide the address of a record in a pool.
C
C  3. METHOD
C
C     If the name of the pointer is not yet present, index and address
C     will both be made 0.
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : input    index of a point
C
      INTEGER   ARRAY(*), PINDEX                                         30.72
C
C  5. PARAMETER VARIABLES
C
C     DPADDP :
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     IERR   : error status: 0=no error, 9=end-of-file
C     LENADT : length provided for additional data in the pointer
C     LENARR : length of the array ARRAY
C     LENPNM : length provided for names of pointers
C     LENPNT : total length of a pointer
C     LENOCP : number of occupied places in the array
C     NUMPNS : number of pointers in the array
C
      INTEGER   IENT, IERR, LENADT, LENARR, LENPNM, LENPNT, LENOCP,
     &          NUMPNS
C
C     DPLGDA : length of the general data in an array with pool structure
C     DPLPNT : location where to find length of the whole pointer
C     DPNPNS : location where to find number of pointers
C
C     Pool general data
C
      INTEGER   DPLGDA, DPLPNT,  DPNPNS                                   30.72
C
C     PTYPE  : type of data in record referenced by pointer
C
      CHARACTER PTYPE *1
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     COPYCH (Ocean Pack)
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C     115 : Pointer index out of range
C     120 : no pointers in the array
C
C 11. REMARKS
C
C     Usage in calling program:
C             CALL SUBR (ARRAY(IADRS(ARRAY,JARR)), ....)
C     Usage in subroutine:
C             SUBROUTINE SUBR (REC, ...)
C             INTEGER REC(*)
C     or:     REAL REC(*)
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPNPNS, DPLPNT, DPLGDA
      DATA       DPNPNS/3/, DPLPNT/5/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'IADRS')
*
*      IF (ITEST.GE.80) WRITE (PRTEST, 3) PINDEX, (ARRAY(JJ), JJ=1, 10)
*   3  FORMAT (' Entry IADRS ', 11I10)
*
      IF (PINDEX.LE.0) THEN
        CALL MSGERR (2, 'Pointer index out of range')
        IERR  = 115                                                       30.81
        IADRS = 0
        RETURN
      ENDIF
*
      IERR = 0                                                            30.81
      CALL DPINQA (ARRAY, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &              IERR)                                                 30.81
      IF (NUMPNS .EQ. 0) THEN
        CALL MSGERR (2, 'number of pointers in array is 0')
                IERR  =120                                                        30.81
        IADRS = 0
        RETURN
      ENDIF
*
      IF (PINDEX.GT.ARRAY(DPNPNS)) THEN
        CALL MSGERR (2, 'Pointer index out of range')
        IERR  = 115                                                       30.81
        IADRS = 0
        RETURN
      ENDIF
*
      LENPNT = ARRAY(DPLPNT)
      IADRS  = ARRAY(DPLGDA+(PINDEX-1)*LENPNT+1)
      PTYPE  = CHAR(ARRAY(DPLGDA+(PINDEX-1)*LENPNT+2))
      IF (PTYPE.EQ.'P') THEN
        IADRS = IADRS
      ELSE
        IADRS = IADRS + 1
      ENDIF
      RETURN
**    end of subroutine IADRS  **
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPSHFT (ARRAY, LINSRT, MSHIF, IERR)                    30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Removed STOP statement
C     40.03, Feb. 00: dynamic pool structure is printed if Itest>=10
C                     to speed up debugging
C     40.13, Dec. 00: RETURN added after Call MSGERR(4,..)
C                     to prevent Coredump on Unix systems
C     40.13, Jan. 01: message "expansion error" added
C
C  2. PURPOSE
C
C     Adding MSHIF empty places (MSHIF > 0) or deleting -MSHIF places
C     (MSHIF < 0) after ILOX in array IOUTD
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     IERR   : output   error status: 0=no error, 9=end-of-file
C     LINSRT : input    first element that is moved
C     MSHIF  : input    number of places to be added after LINSRT
C
      INTEGER   ARRAY(*), IERR, LINSRT, MSHIF                             30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     I      : counter
C     IPOINT : pointer address
C     IENT   : Number of entries into this subroutine
C     INSTAT : initial status
C     J      : counter
C     JJ     : counter
C     JLAST  : previous location of data
C     LENARR : length of the array ARRAY
C     LENREC : length of the record referenced by pointer
C     MS2    : negative shift
C     NEWLEN : new length of subarray
C     OLDLEN : old length of subarray
C     PADRES : location in ARRAY where to find first data
C              of the record referenced by pointer
C
      INTEGER   I, IPOINT, IENT, INSTAT, J, JJ, JLAST, LENARR, LENREC,
     +          MS2, NEWLEN, OLDLEN, PADRES
 
C
C     DPLARR : location where to find length of the available array
C     DPLOCP : location where to find number of occupied places
C     DPNPNS : location where to find number of pointers
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C
C     Pool general data
C
      INTEGER   DPLARR, DPLOCP, DPNPNS, DPLPNT, DPLGDA                    30.81
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     ADPOOL (Ocean Pack)
C
C  9. SUBROUTINES CALLING
C
C     DPEXPR : subroutine which expands a subarray (record)
C
C 10. ERROR MESSAGES
C
C       ---
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       If MSHIF = 0 then
C           Return
C       ----------------------------------------------------------------
C       If MSHIF > 0 (expanding the array) then
C           If the new number of occupied places is larger than total
C             length of array IOUTD then
C               Call ADPOOL to enlarge array IOUTD
C           ------------------------------------------------------------
C           Move all elements after place ILOX MSHIF places backwards
C           Give first MSHIF elements after ILOX value 0 (zero)
C           For every output pointset do
C               If data start after ILOX (IPOINT>ILOX) or data start at
C                 ILOX and recordlength is not 0, then
C                     Adjust pointer to start of data
C           ------------------------------------------------------------
C       Else (MSHIF < 0, deleting part of the array)
C           Compute first and last element to be shifted (JJ1, JJ2 resp.)
C           Move all elements after ILOX+MSHIF MSHIF places forward
C           For every output pointset do
C               If data start after ILOX then
C                   If data start before ILOX+MSHIF then
C                       Print an error message
C                   Else
C                       Adjust pointer to start of data of pointset
C       ----------------------------------------------------------------
C       Update number of occupied places in array IOUTD
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPLARR, DPLOCP, DPNPNS, DPLPNT, DPLGDA
      DATA       DPLARR/1/, DPLOCP/2/, DPNPNS/3/, DPLPNT/5/,
     &           DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPSHFT')
*
*     check available space in the array
*
      INSTAT = IERR                                                       30.81
      OLDLEN = ARRAY(DPLOCP)
      NEWLEN = OLDLEN + MSHIF
*     temporary
*     IF (ITEST.GE.180) WRITE (PRTEST, 4)
*    &    OLDLEN, MSHIF, LINSRT, ARRAY(DPLARR)
*  4  FORMAT (' entry DPSHFT: oldlen,shift,insrt,arrlen ', 4I10)
*
      IF (MSHIF .EQ. 0) RETURN
*
*     ***** positive shift *****
*
      IF (MSHIF .GT. 0) THEN
        IF (NEWLEN .GT. ARRAY(DPLARR)) THEN
          IERR = 101                                                          30.81
          IF (INSTAT.EQ.-3) THEN
            CALL MSGERR (2, 'array is too small')
            WRITE (PRINTF, 8) NEWLEN, ARRAY(DPLARR)                       30.11
   8        FORMAT (' requested:', I10, '  available:', I10)              30.11
            RETURN
          ELSE
            WRITE (PRINTF, 8) NEWLEN, ARRAY(DPLARR)                       30.11
            IF (ITEST.GE.10) THEN                                         40.03
              IERR = -2                                                   40.03
              CALL DPCHEK (ARRAY, IERR)                                   40.03
            ENDIF
            CALL MSGERR (4, 'array is too small')
            RETURN                                                        40.13
          ENDIF
        ENDIF
C
        IF (OLDLEN .GE. LINSRT) THEN
          DO 10 I = OLDLEN, LINSRT, -1
            ARRAY(I+MSHIF) = ARRAY(I)
   10     CONTINUE
        ELSE IF (LINSRT.EQ.OLDLEN+1) THEN
C         insert location at end of array, no data are moved
          CONTINUE
        ELSE
          CALL MSGERR (3, 'insert location outside array (DPSHFT)')
          WRITE (PRTEST, 14) OLDLEN, MSHIF, LINSRT, ARRAY(DPLARR)
   14     FORMAT (' -> oldlen,shift,insrt,arrlen', 4(1X,I12))             40.13
          IERR = 117                                                          30.81
          RETURN
        ENDIF
C
C       fill new space with 0
C
        JLAST = LINSRT+MSHIF-1
        DO 20 JJ = LINSRT, JLAST
          ARRAY(JJ) = 0
  20    CONTINUE
      ELSE
C
C       ***** negative shift *****
C
        MS2 = -MSHIF
C
        IF (OLDLEN .GE. LINSRT) THEN
          IF (LINSRT-MS2.LT.1 .OR. OLDLEN.GT.ARRAY(DPLARR)) THEN          40.13
            CALL MSGERR (4, 'expansion error (subr DPSHFT)')              40.13
            WRITE (PRTEST, 14) OLDLEN, MSHIF, LINSRT, ARRAY(DPLARR)       40.13
            IERR = 117                                                    40.13
            RETURN                                                        40.13
          ENDIF                                                           40.13
          DO 70 J = LINSRT, OLDLEN
            ARRAY(J-MS2) = ARRAY(J)
  70      CONTINUE
        ELSE
          CALL MSGERR (3, 'insert location outside array (DPSHFT)')
          WRITE (PRTEST, 14) OLDLEN, MSHIF, LINSRT, ARRAY(DPLARR)
          IERR = 117                                                      30.81
          RETURN
        ENDIF
      ENDIF
C
C       ***** adjust pointers *****
C
      LENARR = ARRAY(DPLARR)
      DO 80 J = 1, ARRAY(DPNPNS)
        IPOINT = DPLGDA+(J-1)*ARRAY(DPLPNT)+1
        IF (IPOINT.LT.1 .OR. IPOINT.GT.LENARR)
     &  WRITE (PRINTF, 72) IPOINT, LENARR
  72    FORMAT (' Error DPSHFT, pointer: ', I10, ' size: ', I10)
        PADRES = ARRAY(IPOINT)
        IF (PADRES.LT.1 .OR. PADRES.GT.LENARR)
     &  WRITE (PRINTF, 74) IPOINT, PADRES, LENARR
  74    FORMAT (' Error DPSHFT, pointer: ', I10, ' address: ', I10,
     &          ' size: ', I10)
        LENREC = ARRAY(PADRES)
        IF (PADRES.GE.LINSRT) THEN
          ARRAY(IPOINT) = PADRES + MSHIF
        ELSE IF (PADRES+LENREC+1.GE.LINSRT) THEN
          ARRAY(PADRES) = LENREC + MSHIF
        ENDIF
        IF (ITEST.GE.220) THEN
          PADRES = ARRAY(IPOINT)                                          40.00
          LENREC = ARRAY(PADRES)                                          40.00
          WRITE (PRTEST, 76) IPOINT, PADRES, LENREC
  76      FORMAT (' end DPSHFT: pointer: ', I10, ' address: ', I10,
     &          ' lenrec: ', I10)
        ENDIF
  80  CONTINUE
*
  90  ARRAY(DPLOCP) = OLDLEN + MSHIF
*
      RETURN
**    end of subroutine DPSHFT   **
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPEXPR (ARRAY, PINDEX, NEWSIZ, PADRES, IERR)             30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. PURPOSE
C
C     Make record nr. PINDEX the length NEWSIZ, if data type is real/int
C     return rcord address PADRES
C     NOTE: If record data type is Pointer, pool structure is possibly
C     destroyed if record is reduced in length.
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o     array in which pointer structure exists
C     IERR   : output  error status: 0=no error, 9=end-of-file            30.81
C     NEWSIZ : input   new size of record referenced by pointer
C     PADRES : output  location in ARRAY where to find first data
C                      of the record referenced by pointer
C     PINDEX : input   index of a pointer
C
      INTEGER   ARRAY(*), IERR, NEWSIZ, PADRES, PINDEX                    30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     II     : counter
C     OLDSIZ : old size of record referenced by pointer
C     MSHIF  : number of places to be added after LINSRT
C     LINSRT : insert location
C     IPOINT : location of data
C     IERR1  : status used as input to subroutine called
C
      INTEGER   IENT, II, OLDSIZ, MSHIF, LINSRT, IPOINT, IERR1
C
C     Pool general data                                                   30.72
C
C     DPLPNT  : location where to find length of the whole pointer
C     DPLGDA  : length of the general data in an array with pool structure
C
      INTEGER   DPLPNT, DPLGDA
C
C     DTYPE   : data type
C     PTYPE   : type of data in record referenced by pointer
C
      CHARACTER DPTYPE *1, PTYPE *1
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DPSHFT (HISWA/SER)
C
C     STPNOW  :
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C     SWREAD and SPROUT (both HISWA/SWREAD)
C
C 10. ERROR MESSAGES
C
C       ---
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE       DPLPNT, DPLGDA
      DATA       DPLPNT/5/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPEXPR')
*
      IF (PINDEX.LE.0) THEN
        CALL MSGERR (3, 'Index not positive (DPEXPR)')
        WRITE (PRINTF, 5) PINDEX, NEWSIZ, PADRES
   5    FORMAT (' -> ', 3I10)
      ENDIF
      IPOINT = DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+1
      PADRES = ARRAY(IPOINT)
      OLDSIZ = ARRAY(PADRES)
      MSHIF  = NEWSIZ - OLDSIZ
      LINSRT = PADRES + OLDSIZ + 1
      IF (ITEST.GE.140) THEN
        IERR1 = 0
        CALL DPCHEK (ARRAY, IERR1)
        IF (IERR1.GT.0) WRITE (PRTEST, 3) (ARRAY(II), II=1, 20)
   3    FORMAT (' pool:', 10(1X,I9), /, 6X, 10(1X,I9))
      ENDIF
      IF (ITEST.GE.180) WRITE (PRTEST, 4) PINDEX, IPOINT, PADRES,
     &        OLDSIZ, NEWSIZ, MSHIF
    4 FORMAT (' test DPEXPR indx, point, adres, oldsiz, newsiz, shift',
     &        1X, 8I8)
      PTYPE = DPTYPE(ARRAY,PINDEX)
      IF (PTYPE.EQ.'P' .AND. MSHIF.LT.0 .AND. ITEST.GE.50)
     & CALL MSGERR (1, 'reduction of record may destroy pool structure')
C
      CALL DPSHFT (ARRAY, LINSRT, MSHIF, IERR)                            30.81
      IF (STPNOW()) RETURN                                                34.01
*     IF (ITEST.GE.100) THEN
*       WRITE (PRTEST,14) (ARRAY(II), II=1,ITEST)
*     ENDIF
      IF (ITEST.GE.40) THEN
        IERR1 = 0
        IF (ITEST.GE.160) IERR1 = -2                                      30.80
        CALL DPCHEK (ARRAY, IERR1)
        IF (IERR1.GT.0) WRITE (PRTEST, 3) (ARRAY(II), II=1, ITEST)
      ENDIF
*
      RETURN
* * end of subroutine DPEXPR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPMAXR (ARRAY, PINDEX, NEWSIZ, PADRES, IERR)             30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. PURPOSE
C
C     Make record nr. PINDEX as long as possible; the length of the
C     record is returned in NEWSIZ; if data type is real/int
C     return rcord address PADRES
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : input    index of a pointer
C     NEWSIZ : output   new size of record referenced by pointer
C     PADRES : output   location in ARRAY where to find first data
C                       of the record referenced by pointer
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C
      INTEGER   ARRAY(*), PINDEX, PADRES, NEWSIZ, IERR                    30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     IPOINT : location of data
C     LENADT : Length provided for additional data in the pointer
C     LENARR : length of the array ARRAY, if input value is negative,
C              it is assumed that the array already contains the
C              proper length
C     LENOCP : number of occupied places in the array
C     LENPNM : length of pointer name
C     NUMPNS : number of pointers in the array
C
      INTEGER   IENT, IPOINT,LENADT, LENARR, LENOCP, LENPNM, NUMPNS
C
C     Pool general data
C
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C     OLDSIZ : old size of record referenced by pointer
C     MSHIF  : number of places to be added after LINSRT
C
      INTEGER   DPLPNT, DPLGDA, OLDSIZ, MSHIF                             30.72
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DPEXPR (Ocean Pack)
C
C     STPNOW : ??
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C       ---
C
C 10. ERROR MESSAGES
C
C       ---
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPLPNT, DPLGDA
      DATA       DPLPNT/5/, DPLGDA/6/
C
      DATA IENT /0/
      CALL STRACE (IENT,'DPMAXR')
C
 
      IPOINT = DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+1
      PADRES = ARRAY(IPOINT)
      OLDSIZ = ARRAY(PADRES)
      CALL DPINQA (ARRAY, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &             IERR)                                                  30.81
      MSHIF  = LENARR - LENOCP
      NEWSIZ = OLDSIZ + MSHIF
C
      CALL DPEXPR (ARRAY, PINDEX, NEWSIZ, PADRES, IERR)                   30.81
      IF (STPNOW()) RETURN                                                34.01
C
      RETURN
* * end of subroutine DPMAXR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPMINR (ARRAY, PINDEX, NEWSIZ, PADRES, IERR)             30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. PURPOSE
C
C     Make record nr. PINDEX the length NEWSIZ, if data type is real/int
C     return rcord address PADRES
C     NOTE: If record data type is Pointer, pool structure is possibly
C     destroyed if record is reduced in length.
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     IERR   : output   error status: 0=no error, 9=end-of-file     30.81
C     NEWSIZ : output   new size of record referenced by pointer
C     PADRES : output   location in ARRAY where to find first data
C     PINDEX : input    index of a pointer
C                       of the record referenced by pointer
C
      INTEGER   ARRAY(*), PINDEX, PADRES, NEWSIZ,                         30.72
     &          IERR                                                      30.81
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     IPOINT : location of data
C     LENADT : length provided for additional data in the pointer
C     LENARR : length of the array ARRAY, if input value is negative,
C              it is assumed that the array already contains the
C              proper length
C     LENPNM : length of pointer name
C     LENOCP : number of occupied places in the array
C     NUMPNS : number of pointers in the array
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C
      INTEGER   IENT, IPOINT, LENADT, LENARR, LENPNM, LENOCP, NUMPNS,
     &          DPLPNT, DPLGDA                                            30.72
C
C     DPTYPE :
C
      CHARACTER DPTYPE *1
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DPSHFT (HISWA/SER)
C
C     STPNOW : ??
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C     SWREAD and SPROUT (both HISWA/SWREAD)
C
C 10. ERROR MESSAGES
C
C       ---
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE       DPLPNT, DPLGDA, IENT
      DATA       DPLPNT/5/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPMINR')
*
      IPOINT = DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+1
      PADRES = ARRAY(IPOINT)
      IF (DPTYPE(ARRAY,PINDEX) .NE. 'P') THEN
        CALL MSGERR (2,'usage of DPMINR only allowed for type P')
        RETURN
      ENDIF
C
      CALL DPINQA(ARRAY(PADRES), LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &            IERR)                                                   30.81
C     make new size of the referenced array equal to the number of
C     occupied places:
      IF (LENARR.GT.LENOCP) THEN
        NEWSIZ = LENOCP
        CALL DPEXPR (ARRAY, PINDEX, NEWSIZ, PADRES, IERR)                 30.81
        IF (STPNOW()) RETURN                                              34.01
      ENDIF
C
      RETURN
* * end of subroutine DPMINR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPCHEK (ARRAY, IERR)                                     30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.81: Annette Kieftenburg
C     30.72: IJsbrand Haagsma
!     40.14: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
!     40.14, June 01: Variable NWSTAT initialized
C
C  2. PURPOSE
C
C     check data integrity in the pool
C     and display pool structure.
C     pool cycles have to remain intact
C     pointer index -> record address -> record length -> end of record
C     at end of record pointer index must be found
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C
C     Pool general data
C
      INTEGER   ARRAY(*), IERR
C
C  5. PARAMETER VARIABLES
C
C     NLEVEL : maximum number of levels in the array
C
      INTEGER NLEVEL
C
      PARAMETER (NLEVEL=10)
C
C  6. LOCAL VARIABLES
C
C     DPLOCP : location where to find number of occupied places
C     DPLGDA : length of the general data in an array with pool structure
C     ICHEK  : check value at end of data in subarray, must be equal to
C              sequence number of the subarray
C     IENT   : Number of entries into this subroutine
C     IERR1  : status used as input to subroutine called
C     II     : ??
C     IPNSL  : pointer index treated on level
C     LEVEL  : ??
C     LENADT : length provided for additional data in the pointer
C     LENARR : length of the array ARRAY, if input value is negative,
C              it is assumed that the array already contains the
C              proper length
C     LENOCP : number of occupied places in the array
C     LENREC : length of a record (subarray)
C     LPNSL  : length of pointer name on level
C     NPNSL  : number of pointers on level
!     NWSTAT : new status of error code                                   40.14
C     PADRES : location in ARRAY where to find first data
C              of the record referenced by pointer
C     PRVEND : location of end of previous subarray
C     STRTAR : start address of array on level
C
      INTEGER   DPLOCP, DPLGDA,                                           30.72
     &          ICHEK, IENT, IERR1, II, IPNSL(NLEVEL), LEVEL, LENADT,
     &          LENARR(NLEVEL), LENOCP, LENREC, LPNSL(NLEVEL),
     &          NPNSL(NLEVEL), NWSTAT, PADRES,
     &          PRVEND(NLEVEL),STRTAR(NLEVEL)
C
C     OCREAL : gives real representation of number declared integer
C
      REAL      OCREAL
C
C     STRING : a character string
C     PNAME  : name of the new pointer
C     PTYPE  : type of data in record referenced by pointer
C
      CHARACTER *40 STRING
      CHARACTER *16 PNAME
      CHARACTER *1  PTYPE
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C       ---
C
C  9. SUBROUTINES CALLING
C
C       ---
C
C 10. ERROR MESSAGES
C
C     121: pool cycle error
C     122: records not contiguous
C     123: length of array not same as end of last record
C     124: length of record illegal (<0 or too big)
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C     ----------------------------------------------------------------
C     Level=1
C     Name='base'
C     find from base pointer: number of pointers, length of pointer name
C     store these in array NPNSL(Level) and LPNSL(Level)
C     write 2*(level-1) blanks, Name, 'P', NPNSL(level)
C     Make IPNSL(level)=0
C     Repeat
C       Repeat
C          Make IPNSL(level)=IPNSL(level)+1
C          If IPNSL(level)>NPNSL(Level)
C          Then Exit from repeat
C          ---------------------------------------
C          find for pointer: type, number of data ref.,
C                            length of pointer name
C          store these in array NPNSL(Level) and LPNSL(Level)
C          write 2*(level-1) blanks, Name, type, NPNSL(level)
C          If type='P'
C          Then  Make level=level+1
C                find from base pointer: number of pointers,
C                                        length of pointer name
C                store these in array NPNSL(Level) and LPNSL(Level)
C                Make IPNSL(level)=0
C          Else  Exit from repeat
C       -------------------------------------------------
C       level=level-1
C       If level=0
C       Then exit
C     ---------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPLOCP, DPLGDA
      DATA       DPLOCP/2/, DPLGDA/6/
      DATA IENT /0/, NPNSL /NLEVEL*0/, LPNSL/NLEVEL*0/, LENARR/NLEVEL*0/
      CALL STRACE (IENT,'DPCHEK')
*
      LEVEL = 1
      IERR1 = 0
      NWSTAT = 0                                                          40.14
      CALL DPINQA (ARRAY, LENARR(LEVEL), LENOCP, NPNSL(LEVEL),
     &             LPNSL(LEVEL), LENADT, IERR1)
      IPNSL(1)  = 0
      STRTAR(1) = 0
      STRING='Base Pointer'
      IF (IERR.LE.-2) WRITE (PRINTF, 10) STRING, 'P', NPNSL(1)            30.81
  10  FORMAT (1X, A40, A1, 2X, I10)
*
  20  IPNSL(LEVEL)=IPNSL(LEVEL)+1
      IF (IPNSL(LEVEL) .GT. NPNSL(LEVEL)) GOTO 70
      IERR1  = -1
      PNAME = ' '
      CALL DPINQP (ARRAY(STRTAR(LEVEL)+1), PNAME, IPNSL(LEVEL),
     &             PTYPE, PADRES, LENREC, IERR1)
      STRING = ' '
      IF (PNAME.EQ.' ') PNAME = '----'
      STRING (2*LEVEL+1:2*LEVEL+16) = PNAME
      IF (IERR.LE.-2) WRITE (PRINTF, 10) STRING, PTYPE, LENREC            30.81
*
      IF (LENREC.LT.0 .OR. LENREC.GT.LENARR(LEVEL)) THEN
        NWSTAT = 124
        WRITE (PRINTF, 34) PNAME, LEVEL, IPNSL(LEVEL), PADRES, LENREC,
     &  OCREAL(LENREC)
  34    FORMAT (' Illegal record length ', A16, I2, I6, 2(1X,I10),
     &  1X, E12.4)
        GOTO 20
      ENDIF
*
      IF (IPNSL(LEVEL).GT.1) THEN
         IF (PADRES .NE. PRVEND(LEVEL)+1) THEN
            NWSTAT = 122
            IF (IERR.NE.-1) WRITE (PRINTF, 45) LEVEL, PNAME,              30.81
     &              IPNSL(LEVEL), STRTAR(LEVEL), PADRES, PRVEND(LEVEL),
     &              (ARRAY(STRTAR(LEVEL)+II), II=1,DPLGDA)
  45        FORMAT (' Records not contiguous: ',
     &              'pointer,index,adres,prvend', I2, 1X, A16, 3I8,
     &              /, 2X, 8I8)
         ENDIF
      ENDIF
      PRVEND(LEVEL) = PADRES+LENREC+1
      ICHEK  = ARRAY(STRTAR(LEVEL)+PRVEND(LEVEL))
      IF (ICHEK .NE. IPNSL(LEVEL)) THEN
         NWSTAT = 121
         IF (IERR.NE.-1) WRITE (PRINTF, 65) LEVEL, PNAME,               30.81
     &               IPNSL(LEVEL), STRTAR(LEVEL), PADRES, LENREC,
     &               ICHEK, (ARRAY(STRTAR(LEVEL)+II), II=1,DPLGDA)
  65     FORMAT (' Pool cycle error, level=', I3, ' pointer name=',
     &           A16, ' seq.num=', I6, ' start of data=', I8,
     &           ' address=', I8, ' rec.len=', I8, ' check=', I8,
     &           /,' base pointer ', 6I8)
      ENDIF
*
      IF (PTYPE.EQ.'P') THEN
        LEVEL=LEVEL+1
        IF (LEVEL.GT.NLEVEL) THEN
          LEVEL = LEVEL - 1
          GOTO 20
        ENDIF
        IERR1 = -1
        STRTAR(LEVEL) = STRTAR(LEVEL-1) + PADRES-1
        CALL DPINQA (ARRAY(STRTAR(LEVEL)+1), LENARR(LEVEL), LENOCP,
     &              NPNSL(LEVEL), LPNSL(LEVEL), LENADT, IERR1)
        IPNSL(LEVEL) = 0
      ENDIF
      GOTO 20
C
  70  IF (IPNSL(LEVEL).GT.1) THEN
        IF (PRVEND(LEVEL) .NE. ARRAY(STRTAR(LEVEL)+DPLOCP)) THEN
          NWSTAT = 123
          IF (IERR.NE.-1) WRITE (PRINTF, 77) LEVEL, PNAME,                30.81
     &             IPNSL(LEVEL), STRTAR(LEVEL), PADRES, LENREC,
     &             PRVEND(LEVEL), (ARRAY(STRTAR(LEVEL)+II), II=1,DPLGDA)
  77      FORMAT (' End of array is not end of last record',
     &           I8, 1X, A16, 5I8, 2X, 8I8)
        ENDIF
      ENDIF
*
      LEVEL = LEVEL - 1
      IF (LEVEL.GT.0) GOTO 20
*
      IERR = NWSTAT                                                       30.81
      RETURN
*     end of subroutine DPCHEK
      END
************************************************************************
*                                                                      *
      CHARACTER *1 FUNCTION DPTYPE (ARRAY, PINDEX)
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C
C  2. PURPOSE
C
C     Provide type of data in record with PINDEX
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : output   index of the new pointer
C
      INTEGER   ARRAY(*), PINDEX                                         30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C     IENT   : Number of entries into this subroutine
C
      INTEGER   DPLPNT, DPLGDA                                           30.72
      INTEGER   IENT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE       DPLPNT, DPLGDA
      DATA       DPLPNT/5/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPTYPE')
*
      DPTYPE = CHAR (ARRAY(DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+2))
*
      RETURN
* * end of subroutine DPTYPE *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPDELP (ARRAY, PINDEX, IERR)                             30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. PURPOSE
C
C     Deleting both pointer (with index PINDEX) and its associated record
C     from array ARRAY
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : output   index of the pointer
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C
      INTEGER   ARRAY(*), PINDEX,                                         30.72
     &          IERR                                                      30.81
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPNPNS : location where to find number of pointers
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C     IENT   : Number of entries into this subroutine
C     IPOINT : location of data
C     JJ     : counter
C     LENREC : length of a record (subarray)
C     LINSRT : insert location
C     NEWSTA : new status
C     PADRES : location in ARRAY where to find first data
C              of the record referenced by pointer
C
      INTEGER   DPNPNS, DPLPNT, DPLGDA,                                    30.72
     &          IENT, IPOINT, JJ, LENREC, LINSRT, NEWSTA, PADRES
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DPSHFT and DPEXPR (both Ocean Pack)
C
C     STPNOW : ??
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C       ---
C
C 10. ERROR MESSAGES
C
C       ---
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       Call DPEXPR to delete data in record
C       Determine last element before name to be deleted
C       Update the total number of output pointsets
C       Call DPSHFT to delete  the concerning name of the pointset
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPNPNS, DPLPNT, DPLGDA
      DATA       DPNPNS/3/, DPLPNT/5/, DPLGDA/6/
      DATA IENT /0/
      CALL STRACE (IENT,'DPDELP')
*
      IF (PINDEX .LE. ARRAY(DPNPNS)) THEN
        NEWSTA = 0
        CALL DPEXPR (ARRAY, PINDEX, 0, PADRES, NEWSTA)
        IF (STPNOW()) RETURN                                              34.01
        LINSRT = DPLGDA + 1 + ARRAY(DPLPNT) * PINDEX
        CALL DPSHFT (ARRAY, LINSRT, -ARRAY(DPLPNT), NEWSTA)
        IF (STPNOW()) RETURN                                              34.01
*       adjust pool cycles
        DO 20 JJ = PINDEX+1, ARRAY(DPNPNS)
          IPOINT = DPLGDA+(JJ-1)*ARRAY(DPLPNT)+1
          PADRES = ARRAY(IPOINT)
          LENREC = ARRAY(PADRES)
          ARRAY(PADRES+LENREC+1) = JJ-1
  20    CONTINUE
        ARRAY(DPNPNS) = ARRAY(DPNPNS)-1
      ELSE
        IF (IERR.EQ.0)                                                    30.81
     &  CALL MSGERR (2, 'attempt to delete pointer outside array')
        NEWSTA = 106
      ENDIF
C
      IERR = NEWSTA                                                       30.81
      RETURN
* * end of subroutine DPDELP *
      END
************************************************************************
*                                                                      *
      INTEGER FUNCTION DPGETI (ARRAY, PINDEX, PPLACE, IERR, MOVE)       30.72 30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
C  2. PURPOSE
C
C     Giving the integer value of element PPLACE of record number
C     PINDEX in array
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : output   index of the pointer
C     PPLACE : input    number of element in record
C     IERR   : output   error status: 0=no error, 9=end-of-file   30.81
C
      INTEGER   ARRAY (*), PINDEX, PPLACE,                               30.72
     &          IERR                                                     30.81
C
C     MOVE   : input    if MOVE=UP, PPLACE is increased by 1
C
      CHARACTER *1 MOVE
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPNPNS : location where to find number of pointers
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C     IENT   : Number of entries into this subroutine
C     NUMPNS : number of pointers in the array
C     LENREC : length of a record (subarray)
C     PADRES : location in ARRAY where to find first data
C              of the record referenced by pointer
C
      INTEGER   DPNPNS, DPLPNT, DPLGDA,                                   30.72
     &          IENT, NUMPNS, LENREC, PADRES
C
C     UP     : value 'U', meaning index PPLACE must increase 1 after operation
C
      CHARACTER UP
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     none
C
C  9. SUBROUTINES CALLING
C
C       ---
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C       ---
C
C 12. STRUCTURE
C
C       ----------------------------------------------------------------
C       Read total number of records in array ARRAY
C       If index PINDEX is out of range, then
C           Print an error message
C       Else
C           Determine address of record and recordlength
C           If required element of data is out of range, then
C               Print an error message
C           Else
C               Assign to DPGETI the value of element PPLACE
C               in record number PINDEX
C       ----------------------------------------------------------------
C       If argument MOVE has the value UP
C       Then increase value of PPLACE by 1
C       ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPNPNS, DPLPNT, DPLGDA, UP
      DATA       DPNPNS/3/, DPLPNT/5/, DPLGDA/6/
      DATA       UP/'U'/
      DATA IENT /0/
      IF (LTRACE) CALL STRACE (IENT,'DPGETI')
*
      NUMPNS = ARRAY(DPNPNS)
      IF (PINDEX.LT.1 .OR. PINDEX.GT.NUMPNS) THEN
        IERR = 115                                                        30.81
        WRITE (PRINTF, 6010) PINDEX, NUMPNS
 6010   FORMAT (' Error DPGETI: PINDEX = ', I8, ' NUMPNS = ', I8)
        DPGETI = 0
      ELSE
        PADRES = ARRAY(DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+1)
        LENREC = ARRAY(PADRES)
        IF (PPLACE.LT.1 .OR. PPLACE.GT.LENREC) THEN
          IERR = 116                                                      30.81
          WRITE (PRINTF, 6020) PPLACE, LENREC
 6020     FORMAT (' Error DPGETI: PPLACE = ', I8, ' LENREC = ', I8)
          DPGETI = 0
        ELSE
          DPGETI = ARRAY(PADRES+PPLACE)
        ENDIF
      ENDIF
*
      IF (MOVE.EQ.UP) PPLACE = PPLACE + 1
*
      RETURN
* * end of subroutine DPGETI *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPGETR (ARRAY, PINDEX, PPLACE, RV, IERR, MOVE)           30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
C  2. PURPOSE
C
C     Giving the integer value of element PPLACE of record number
C     PINDEX in array
C
C  3. METHOD
C
C       ---
C
C  4. ARGUMENT VARIABLES
C
C     ARRAY  : i/o      array in which pointer structure exists
C     PINDEX : output   index of the pointer
C     PPLACE : input    number of element in record
C                       record in ARRAY
C                       NOTE: this argument is declared INTEGER
C                       inside this subroutine
C     IERR   : output   error status: 0=no error, 9=end-of-file           30.81
C
      INTEGER   ARRAY (*), PINDEX, PPLACE,                                30.72
     &          IERR                                                      30.81
C
C     RV     : output   real variable to be given value from
C
      REAL      RV
C
C     MOVE   : input    if MOVE=UP, PPLACE is increased by 1
C
      CHARACTER *1 MOVE
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     DPNPNS : location where to find number of pointers
C     DPLPNT : location where to find length of the whole pointer
C     DPLGDA : length of the general data in an array with pool structure
C     IENT   : Number of entries into this subroutine
C     LENREC : length of a record (subarray)
C     NUMPNS : number of pointers in the array
C     PADRES : location in ARRAY where to find first data
C              of the record referenced by pointer
C
      INTEGER   DPNPNS, DPLPNT, DPLGDA                                   30.72
      INTEGER   IENT, LENREC, NUMPNS, PADRES
C
C     UP     :
C
      CHARACTER UP
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     none
C
C  9. SUBROUTINES CALLING
C
C     ---
C
C 10. ERROR MESSAGES
C
C     If PINDEX or PPLACE is out of range an error message is printed
C
C 11. REMARKS
C
C     ---
C
C 12. STRUCTURE
C
C     ----------------------------------------------------------------
C     Read total number of records in array ARRAY
C     If index PINDEX is out of range, then
C         Print an error message
C     Else
C         Determine address of record and recordlength
C         If required element of data is out of range, then
C             Print an error message
C         Else
C             Assign to RV the value of element PPLACE
C             in record number PINDEX
C     ----------------------------------------------------------------
C     If argument MOVE has the value UP
C     Then increase value of PPLACE by 1
C     ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      SAVE       DPNPNS, DPLPNT, DPLGDA, UP
      DATA       DPNPNS/3/, DPLPNT/5/, DPLGDA/6/
      DATA       UP/'U'/
      DATA IENT /0/
      IF (LTRACE) CALL STRACE (IENT,'DPGETR')
*
      NUMPNS = ARRAY(DPNPNS)
      IF (PINDEX.LT.1 .OR. PINDEX.GT.NUMPNS) THEN
        IERR = 115                                                        30.81
        WRITE (PRINTF, 6010) PINDEX, NUMPNS
 6010   FORMAT (' Error DPGETR: PINDEX = ', I8, ' NUMPNS = ', I8)
        RV = 0
      ELSE
        PADRES = ARRAY(DPLGDA+(PINDEX-1)*ARRAY(DPLPNT)+1)
        LENREC = ARRAY(PADRES)
        IF (PPLACE.LT.1 .OR. PPLACE.GT.LENREC) THEN
          IERR = 116                                                      30.81
          WRITE (PRINTF, 6020) PPLACE, LENREC
 6020     FORMAT (' Error DPGETR: PPLACE = ', I8, ' LENREC = ', I8)
          RV = 0
        ELSE
          RV = ARRAY(PADRES+PPLACE)
        ENDIF
      ENDIF
*
      IF (MOVE.EQ.UP) PPLACE = PPLACE + 1
*
      RETURN
* * end of subroutine DPGETR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DPPUTR (ARRAY, PPLACE, RV)
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C
C  2. PURPOSE
C
C     Put a real value into an integer array
C     ARRAY is declared here as REAL, it is INTEGER in the calling program
C
C  3. METHOD
C
C     ---
C
C  4. ARGUMENT VARIABLES
C
C     PPLACE : input    number of element in array
C
      INTEGER   PPLACE                                                    30.72
C
C     ARRAY  : i/o      array
C     RV     : output   real variable to be put into ARRAY
C
      REAL      ARRAY(*), RV
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   :   number of entries into this subroutine
C
      INTEGER   IENT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     none
C
C  9. SUBROUTINES CALLING
C
C     ---
C
C 10. ERROR MESSAGES
C
C     If PINDEX or PPLACE is out of range an error message is printed
C
C 11. REMARKS
C
C     ---
C
C 12. STRUCTURE
C
C     ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'DPPUTR')
*
      ARRAY(PPLACE) = RV
      RETURN
* * end of subroutine DPPUTR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE COPYCH (STRING, MOVE, IARRAY, LENARR, IERR)              30.81
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     40.03: Nico Booij
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     30.81, Jan. 99: Replaced variable FROM by FROM_ and TO by TO_ (because
C                     FROM and TO are reserved words)
C     40.03, Nov. 99: LENS2 removed from WRITE statement (value not yet known)
C
C  2. PURPOSE
C
C     copy a string into an integer array or vice-versa
C     MOVE (TO_ or FROM_) indicates copying direction                     30.81
C
C  3. METHOD
C
C     ---
C
C  4. ARGUMENT VARIABLES
C
C     IARRAY : output   an integer array
C     LENARR : input    length of array IARRAY
C     IERR   : output   error status: 0=no error, 9=end-of-file            30.81
C
      INTEGER   IARRAY(*), LENARR, IENT,                                30.72
     &          IERR                                                    30.81
C
C     STRING : i/o      a character string
C     MOVE   : input    if MOVE=TO_, STRING is copied to IARRAY   30.81
C                               if MOVE=FROM_, STRING is copied from IARRAY   30.81
C
      CHARACTER MOVE *1, STRING *(*)
C
C  5. PARAMETER VARIABLES
C
C     OPMLFC : largest allowed integer character (ASCII) code + 1
C     OPMNLI : number of characters that can be stored in one integer number
C
      INTEGER   OPMLFC, OPMNLI                                            30.72
C
      PARAMETER (OPMNLI=4, OPMLFC=128)
C
C  6. LOCAL VARIABLES
C
C     IC     : counter
C     IENT   : number of entries into this subroutine
C     II     : counter
C     LENS1  : length of a string
C     LENS2  : length of a string
C     LL     : integer representation of a character
C     MC1    : integer converted to/from character
C     MCHAR  : integer converted to/from character
C     MM     : aux. number
C     NSL    : position of character in string
C
      INTEGER   IC, II, LENS1, LENS2, LL, MC1, MCHAR, MM, NSL
C
C     CC     : a single character
C     CHAR   : intrinsic character function, translates integer to character
C     FROM_  : 'F'
C     TO_    : 'T'
C
      CHARACTER CC, TO_, FROM_                                            30.81
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     CHAR, ICHAR (intrinsic functions)
C
C  9. SUBROUTINES CALLING
C
C     ---
C
C 10. ERROR MESSAGES
C
C     If PINDEX or PPLACE is out of range an error message is printed
C
C 11. REMARKS
C
C     ---
C
C 12. STRUCTURE
C
C     ----------------------------------------------------------------
C     ----------------------------------------------------------------
C
C 13. SOURCE TEXT
C
      SAVE        IENT, TO_, FROM_                                        30.81
      DATA        IENT /0/, TO_ /'T'/, FROM_ /'F'/                        30.81
      CALL STRACE (IENT,'COPYCH')
C
      LENS1 = LEN(STRING)
      IF (LENARR.GT.360) THEN
        CALL MSGERR (2, 'extremely long string in COPYCH')
        WRITE (PRTEST, *) ' test COPYCH  ',
     &          MOVE, LENARR, LENS1, ' ', STRING(1:80)                    40.03
        LENARR = 360
      ENDIF
      LENS2 = LENARR*OPMNLI
C
      IF (MOVE .EQ. TO_) THEN                                             30.81
        NSL = 0
        DO 60 II = 1, LENARR
          MCHAR = 0
          DO 40 IC = 1, OPMNLI
            NSL = NSL + 1
            IF (NSL .LE. LENS1) THEN
              CC = STRING(NSL:NSL)
            ELSE
              CC = ' '
            ENDIF
            LL = ICHAR(CC)
            IF (LL.GE.OPMLFC) THEN
              IERR = 803                                                  30.81
              WRITE (PRTEST, 33) CC
  33          FORMAT (' character cannot be copied: ', A1)
              LL = ICHAR ('?')
            ENDIF
            MCHAR = OPMLFC*MCHAR + LL
C            IF (ITEST.GE.250) WRITE (PRTEST, *) NSL, CC, LL
  40      CONTINUE
          IARRAY(II) = MCHAR
  60    CONTINUE
        IF (LENS1.GT.LENS2) THEN
          DO 70 II = LENS1+1, LENS2
            IF (STRING(II:II) .NE. ' ') THEN
              IERR = 801                                                  30.81
              CALL MSGERR(1, 'string longer than capacity of array')
              IF (ITEST.GE.50) WRITE (PRTEST, *) ' test COPYCH  ',
     &               MOVE, LENARR, LENS1, LENS2, ' ', STRING(1:80)
              GOTO 165
            ENDIF
  70      CONTINUE
        ENDIF
      ELSE IF (MOVE .EQ. FROM_) THEN                                      30.81
C
C       character string copied from an array
C
C       first the string is filled with blanks
        STRING = '    '
        NSL = 0
        DO 160 II = 1, LENARR
          MC1 = IARRAY(II)
          DO 140 IC = 1, OPMNLI
            MM  = OPMLFC ** (OPMNLI-IC)
            LL  = MC1 / MM
            NSL = NSL + 1
            IF (NSL .LE. LENS1) THEN
              STRING(NSL:NSL) = CHAR(LL)
            ELSE
              IF (CHAR(LL) .NE. ' ') THEN
                IF (IERR.NE.802)                                          30.81
     &          CALL MSGERR(1, 'string shorter than capacity of array')
                IF (ITEST.GE.50) WRITE (PRTEST, *) ' test COPYCH  ',
     &               MOVE, LENARR, LENS1, LENS2, ' ', STRING
                IERR = 802                                                30.81
                GOTO 165
              ENDIF
            ENDIF
            MC1 = MC1 - LL * MM
*           IF (ITEST.GE.250) WRITE (PRTEST, *) NSL, LL, STRING(NSL:NSL)
 140      CONTINUE
          IF (MC1.NE.0) WRITE (PRINTF, *) ' Error COPYCH'
 160    CONTINUE
      ELSE
        CALL MSGERR (2, 'error COPYCH, argument MOVE')
      ENDIF
 165  IF (ITEST.GE.230) WRITE (PRTEST, 167) LENS1, STRING, MOVE,
     &         (IARRAY(II), II=1,LENARR)
 167  FORMAT (' exit COPYCH ', I3, 1X, A20, 1X, A1, 4(1X,I12))
      RETURN
**    end of subroutine COPYCH   **
      END
************************************************************************
*                                                                      *
      REAL FUNCTION OCREAL (IVALUE)
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C
C  2. PURPOSE
C
C     Deliver a real value stored in an integer array
C
C  3. METHOD
C
C     usage of EQUIVALENCE statement
C
C  4. ARGUMENT VARIABLES
C
C     IVALUE : input    an integer value
C
      INTEGER, INTENT(IN) :: IVALUE                                       30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IV    : real number stored in integer array
C     RV    : real number
C
      INTEGER ::  IV
C
      REAL    ::  RV
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      EQUIVALENCE (IV,RV)
 
      IV     = IVALUE
      OCREAL = RV
 
      RETURN
 
      END FUNCTION OCREAL
************************************************************************
*                                                                      *
      INTEGER FUNCTION OCINTG (RVALUE)                                    30.72
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     ver 30.01
C
C  2. PURPOSE
C
C     Deliver a integer value stored as real
C
C  3. METHOD
C
C     usage of EQUIVALENCE statement
C
C  4. ARGUMENT VARIABLES
C
C     RVALUE : input    an integer value
C
      INTEGER   RVALUE                                                    30.72
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C       --
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      OCINTG = RVALUE
      RETURN
**    end of subroutine OCINTG   **
      END
