!NRL: $Id: ocpids.F,v 1.1.1.2 2003/03/28 15:35:32 dykes Stab $
!NRL: $Name:  $
!     Last change:  NB   04 Jan 2001   12:00 pm
*
*          OCEAN PACK - Installation dependent subroutines
*
      MODULE OCP_PLOTDATA                                                 40.13
!       40.13, Jan. 01: new module
        INTEGER, PARAMETER :: LENPLT=1000                                 40.13
        CHARACTER (LEN=LENPLT) :: PLTLIN                                  40.13
      END MODULE OCP_PLOTDATA                                             40.13
******************************************************************
*                                                                *
      SUBROUTINE OCPINI (INIFIL, LREAD, INERR)
*                                                                *
******************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C     30.82: IJsbrand Haagsma
C     34.01: IJsbrand Haagsma
C     40.00, 40.03: Nico Booij
C
C  1. Updates
C
C     10.02, July 94: New argument INIFIL
C                     Check on validity period now uses OCDTIM
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.82, Nov. 98: Introduced recordlength of 1000 for file PRINT to
C                     avoid error-messages on the Cray-J90 and SGI Origin 200
C     34.01, Feb. 99: Changed STOP statements for MSGERR(4,'message')
C                     calls
C     34.01, Feb. 99: Opens a file 'screen' when unitnr in swaninit<>6
C     40.00, Feb. 99: Directory separation characters included in init file
C                     these characters are used in subr FOR
C     40.03, May  00: backslash replaced by CHAR(92) because of problems on Linux
C
C  2. Purpose
C
C     subroutine initialises a number of common variables
C     opens standard input and output files, if necessary
C
C  4. Argument variables
C
C     INERR : output     Number of the initialisation error
C
      INTEGER INERR
C
C     INIFIL  inp  char  name of initialisation file
C     LREAD   inp  log   if True: command input file must be opened
C                        and command reading must be initialised
C
C
C
      PARAMETER  (NPLOPS=2)
      LOGICAL    LREAD, FILEXI
      CHARACTER  INPFIL *40, OUTFIL *40, INIFIL *(*), TSTFIL *40,
     &           PLTOPT *4, PLTOPS(NPLOPS) *4, TIMSTR *24
      INTEGER    PRCTIM(6), INIVER, INIVEF
      SAVE PLTOPS
      DATA PRCTIM /0,0,0,0,0,0/, PLTOPS /'OPPL', 'HPGL'/
*
*     version of initialisation file                                      10.16
      INIVER = 2                                                          40.00
      INIVEF = -1                                                         40.00
      INERR  = 0                                                          34.01
*
*     see whether initialisation file exists
*
      INQUIRE (FILE=INIFIL, EXIST=FILEXI)
      IF (FILEXI) THEN
*
*       read initialisation file
*
        OPEN (11, FILE=INIFIL, STATUS='OLD', ERR=950)
        READ (11, *, ERR=930, END=930) INIVEF                             10.16
        IF (INIVEF.GT.INIVER .OR. INIVEF.LE.0) GOTO 935                   40.00
        READ (11, 120, ERR=930, END=930) INST
        READ (11, *,   ERR=930, END=930) INPUTF
        READ (11, 120, ERR=930, END=930) INPFIL
        READ (11, *,   ERR=930, END=930) PRINTF
        READ (11, 120, ERR=930, END=930) OUTFIL
        READ (11, *,   ERR=930, END=930) PRTEST
        READ (11, 120, ERR=930, END=930) TSTFIL
        READ (11, *,   ERR=930, END=930) SCREEN
        READ (11, *,   ERR=930, END=930) IUNMAX
        READ (11, 130, ERR=930, END=930) COMID
        READ (11, 130, ERR=930, END=930) TABC
        IF (INIVEF.GE.2) THEN                                             40.00
          READ (11, 130, ERR=930, END=930) DIRCH1
          READ (11, 130, ERR=930, END=930) DIRCH2
        ELSE
C         char(92)   replaces '\'   (modification necessary for Linux)
          DIRCH1 = CHAR(92)                                               40.03
          DIRCH2 = CHAR(92)                                               40.03
        ENDIF
        READ (11, 140, ERR=930, END=930) PLTOPT
        READ (11, *,   ERR=930, END=930) NPLP
        READ (11, *,   ERR=930, END=930) (PLPARM(II),II=1,NPLP)
        READ (11, *,   ERR=930, END=930) PFROPT
        READ (11, *,   ERR=930, END=930) ITMOPT
*110    FORMAT (I5)
 120    FORMAT (A40)
 130    FORMAT (A1)
 140    FORMAT (A4)
        CLOSE (11)
        IPLOPT = 0
        DO 150 IPP = 1, NPLOPS
          IF (PLTOPS(IPP).EQ.PLTOPT) IPLOPT = IPP
 150    CONTINUE
        IF (IPLOPT.EQ.0) THEN
          PRINT *, ' Illegal plotting option in init. file: ', PLTOPT
          IPLOPT = 1
        ENDIF
      ELSE
*
*       REFERENCE NUMBERS AND NAMES OF STANDARD FILES
*
        INPUTF = 3
        INPFIL = 'INPUT'
        PRINTF = 4
        OUTFIL = 'PRINT'
*       unit ref. numbers for output to screen and to separate
*       test print file:
        PRTEST = PRINTF
        TSTFIL = '    '
        SCREEN = 6
        IUNMAX = 99
*       TABC is the Tab character (interpreted as blank in command reading)
        TABC   = CHAR(9)
*       COMID is the comment identifier (usually $)
        COMID  = '$'
C       DIRCH1 is directory separation character as appears in input file
C       DIRCH2 is directory separation character replacing DIRCH1         40.00
        DIRCH1 =  CHAR(92)                                                40.03
        DIRCH2 =  CHAR(92)                                                40.03
*       INST = name of institute, max. 40 characters
        INST = 'Delft University of Technology'
*       plotting option
        IPLOPT = 2
*       first two values in PLPARM: size of plotting window
        NPLP = 6
        PLPARM(1) = 18.
        PLPARM(2) = 26.
        PLPARM(3) = 402.
        PLPARM(4) = 0.
        PLPARM(5) = 0.
        PLPARM(6) = 0.
        PFROPT = 2
        ITMOPT = 1
*
*       Case IPLOPT=2, suggested defaults are:
*       NPLP:   6
*       PLPARM: 18., 26., 402., 0., 0., 0.
*
      ENDIF
      IF (INIVEF.LT.INIVER) THEN
*
*       write initialisation file
*
        OPEN  (12, FILE=INIFIL, STATUS='UNKNOWN', FORM='FORMATTED',       40.00
     &           ERR=950)
        WRITE (12, 210) INIVER, 'version of initialisation file'          10.16
        WRITE (12, 220) INST,   'name of institute'
        WRITE (12, 210) INPUTF, 'command file ref. number'
        WRITE (12, 220) INPFIL, 'command file name'
        WRITE (12, 210) PRINTF, 'print file ref. number'
        WRITE (12, 220) OUTFIL, 'print file name'
        WRITE (12, 210) PRTEST, 'test file ref. number'
        WRITE (12, 220) TSTFIL, 'test file name'
        WRITE (12, 210) SCREEN, 'screen ref. number'
        WRITE (12, 210) IUNMAX, 'highest file ref. number'
        WRITE (12, 230) COMID,  'comment identifier'
        WRITE (12, 230) TABC,   'TAB character'
        WRITE (12, 230) DIRCH1, 'dir sep char in input file'
        WRITE (12, 230) DIRCH2, 'dir sep char replacing previous one'     40.00
        WRITE (12, 240) PLTOPS(IPLOPT),
     &                  'plotting option (OPPL, HPGL etc.)'
        WRITE (12, 210) NPLP, 'number of plotting parameters'
        WRITE (12, 250) (PLPARM(II), II=1,NPLP)
        WRITE (12, 210) PFROPT, 'default plotting frame option'
        WRITE (12, 210) ITMOPT, 'default time coding option'
        CLOSE (12)
  210   FORMAT (I5, T41, A)
  220   FORMAT (A40, A)
  230   FORMAT (A1, T41, A)
  240   FORMAT (A4, T41, A)
  250   FORMAT (6(1X,F10.4))
      ENDIF
*
      IUNMIN = 0
      FUNLO = 21
      FUNHI = IUNMAX
*     max. size of area available for plotting isolines and vector fields
*     Note: 0.12*XASM is needed for the caption
      IF (PFROPT.EQ.1) THEN
        XASM = PLPARM(1)
        YASM = PLPARM(2) - 0.1*XASM
      ELSE
        XASM = PLPARM(1)
        YASM = PLPARM(2) - 0.12*XASM
      ENDIF
*
      CALL OCDTIM (PRCTIM)
*
*     initialise command reader
*
      IF (OUTFIL.NE.'    ') THEN
*       WRITE (*,*) ' Open print file ', PRINTF, OUTFIL
        OPEN (UNIT=PRINTF, FILE=OUTFIL, STATUS='UNKNOWN',
     &    FORM='FORMATTED',                                               30.82
C/Cray     &    RECL=2000,                                                      30.82
C/SGI     &    RECL=2000,                                                      30.82
     &    ERR=920)                                                        30.82
*       WRITE (*,*) ' Print file opened ', PRINTF, OUTFIL
        CALL DTTIST (ITMOPT, TIMSTR, PRCTIM)
        WRITE (PRINTF, 12) TIMSTR
   12   FORMAT ('1',//,20X, 'Execution started on ',A, //)
      ENDIF
      IF (PRTEST.NE.PRINTF) OPEN (UNIT=PRTEST, FILE=TSTFIL, ERR=922)
      IF (SCREEN.NE.6) OPEN(UNIT=SCREEN, FILE='screen',ERR=960)           34.01
      IF (LREAD) THEN
        IF (INPFIL.NE.'    ')
     &  OPEN (UNIT=INPUTF, FILE=INPFIL, STATUS='OLD', ERR=910)
        CALL RDINIT
      ENDIF
C
      RETURN
C
  910 CALL MSGERR(4,'Input file missing')                                 34.01
      RETURN                                                              34.01
C
  920 INERR=920                                                           34.01
      RETURN                                                              34.01
C
  922 CALL MSGERR(4,'Cannot open test file: '//TSTFIL)                    34.01
      RETURN
C
  930 INERR=930                                                           34.01
      RETURN                                                              34.01
C
  935 INERR=935                                                           34.01
      RETURN                                                              34.01
C
  950 INERR=950                                                           34.01
      RETURN                                                              34.01
C
  960 CALL MSGERR(4,'Error opening output file: sreen')                   34.01
      RETURN                                                              34.01
C
      END
******************************************************************
*                                                                *
      SUBROUTINE OCDTIM (PRCTIM)
*                                                                *
******************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. Authors
C
C     30.07
C     30.70: Nico Booij
C     30.82: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     30.07, Oct. 95: option DEC added
C     30.70, Sep. 97: adaptation in view of year 2000
C     30.82, Mar. 99: Adapted to Fortran 90 standard
C     40.02, Sep. 00: Removed all platform dependent Fortran 77 statements
*
*  2. PURPOSE
*
*       get time of processing, using processor dependent routines
*
*  3. PARAMETER LIST
*
*       PRCTIM  outp   int   time array: elements: year, month, day,
*                            hour, minute, second
*
*  4. SUBROUTINES USED
*
*       GETDAT, GETTIM or other
*
*  5. ERROR MESSAGES
*
*       ----
*
*  6. REMARKS
*
*       This function uses a processor dependent subroutines (GETDAT,
*       GETTIM), therefore adaptations are necessary when compiled
*       at a different computer system environment.
*
*  7. STRUCTURE
*
*       ---------------------------------------------------------
*       Call DATE and TIME routines (system dependent)
*       decode YEAR, MONTH and DAY
*       assemble DATE string
*       decode HOUR, MINUTE, SECOND
*       assemble TIME string
*       ---------------------------------------------------------
*
*  8. SOURCE TEXT
*
      INTEGER PRCTIM(6)
C
C     Call DATE and TIME routines
C
C     --------Fortran 90 date-time routines --------
C
      CHARACTER TIMSTR *24, CDUMMY *5                                     30.82
      INTEGER   IDUMMY(8)                                                 30.82
C
      CALL DATE_AND_TIME (TIMSTR(1:8), TIMSTR(10:20), CDUMMY, IDUMMY)     30.70
      CALL DTSTTI (1, TIMSTR, PRCTIM)                                     30.70
 
      RETURN
 
      END SUBROUTINE OCDTIM
******************************************************************
*                                                                *
      SUBROUTINE DTSTTI (IOPT, TIMSTR, DTTIME)
*                                                                *
******************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*     Updates
*
*       ver 30.70, Sep 1997 by N.Booij: adaptation in view year 2000
*
*     Function:
*
*       transform time string into integer time array
*
*     Argument list:
*
*       IOPT    input  int   option number
*                            1: ISO notation   19870530.153000
*                            2: (HP compiler): 30-May-87 15:30:00
*                            3: (old Lahey)    05/30/87 15:30:00          30.70
*                            4:                         15:30:00
*                            5:                87/05/30 15:30:00
*                            6: WAM            8705301530
*
*       TIMSTR  input  char  time string
*       DTTIME  outp   int   time array: elements: year, month, day,
*                            hour, minute, second
*
*    Remarks:
*     Options can be added by the user
*     existing options should not be changed
*
*     Source:
*
      INTEGER    IOPT, DTTIME(6)
      CHARACTER  TIMSTR *24, MONC(12) *3, MONCI *3
      DATA MONC /'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL',
     &           'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
*
      IF (IOPT.EQ.1) THEN
        READ (TIMSTR, '(I4,I2,I2,1X,3I2)', ERR=98) (DTTIME(II), II=1,6)
      ELSE IF (IOPT.EQ.2) THEN
        READ (TIMSTR, '(I2,1X,A3,1X,I2,3(1X,I2))', ERR=98)
     &  DTTIME(3), MONCI, DTTIME(1), (DTTIME(II), II=4,6)
        IF (DTTIME(1).LT.10) THEN                                         30.70
          DTTIME(1) = 2000 + DTTIME(1)                                    30.70
        ELSE
          DTTIME(1) = 1900 + DTTIME(1)
        ENDIF
        DTTIME(2) = 0
        DO 20 IMM = 1, 12                                                  !!
          CALL UPCASE (MONCI)
          IF (MONCI.NE.MONC(IMM)) GOTO 20
          DTTIME(2) = IMM
          GOTO 90
  20    CONTINUE                                                           !!
        CALL MSGERR (2, 'incorrect month string: '//MONCI)                40.00
      ELSE IF (IOPT.EQ.3) THEN
        READ (TIMSTR, '(I2,5(1X,I2))', ERR=98)
     &  DTTIME(2), DTTIME(3), DTTIME(1), (DTTIME(II), II=4,6)
        IF (DTTIME(1).LT.10) THEN                                         30.70
          DTTIME(1) = 2000 + DTTIME(1)                                    30.70
        ELSE
          DTTIME(1) = 1900 + DTTIME(1)
        ENDIF
      ELSE IF (IOPT.EQ.4) THEN
        READ (TIMSTR, '(I2,2(1X,I2))', ERR=98) (DTTIME(II), II=4,6)
        DO 40 II = 1, 3
          DTTIME(II) = 0
  40    CONTINUE
      ELSE IF (IOPT.EQ.5) THEN                                            30.11
        READ (TIMSTR, '(I2,5(1X,I2))', ERR=98) (DTTIME(II), II=1,6)       30.11
        IF (DTTIME(1).LT.10) THEN                                         30.70
          DTTIME(1) = 2000 + DTTIME(1)                                    30.70
        ELSE
          DTTIME(1) = 1900 + DTTIME(1)
        ENDIF
      ELSE IF (IOPT.EQ.6) THEN                                            30.11
        READ (TIMSTR, '(5I2)', ERR=98) (DTTIME(II), II=1,5)
        DTTIME(6) = 0.
        IF (DTTIME(1).LT.10) THEN                                         30.70
          DTTIME(1) = 2000 + DTTIME(1)                                    30.70
        ELSE
          DTTIME(1) = 1900 + DTTIME(1)
        ENDIF
      ELSE
        CALL MSGERR (2, 'wrong time coding option in subroutine DTSTTI')
      ENDIF
  90  RETURN
  98  CALL MSGERR (2, 'time string unreadable: '//TIMSTR)
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE DTTIST (IOPT, TIMSTR, DTTIME)
*                                                                *
******************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*     Updates
*
*       ver 30.70, Sep 1997 by N.Booij: adaptation in view year 2000
*
*     Function:
*
*       transform integer time array into time string
*
*     Argument list:
*
*       IOPT    input  int   option number (see subr. DTSTTI)
*       TIMSTR  outp   char  time string
*       DTTIME  input  int   time array: elements: year, month, day,
*                            hour, minute, second
*
*     Source:
*
      INTEGER    IOPT, DTTIME(6)
      CHARACTER  TIMSTR *24, MONC(12) *3
      DATA MONC /'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
     &           'Aug', 'Sep', 'Oct', 'Nov', 'Dec'/
*
      TIMSTR = '    '
      IF (IOPT.EQ.1) THEN
        WRITE (TIMSTR, 12) (DTTIME(II), II=1,6)
  12    FORMAT (I4,I2,I2,'.',3I2)
        LTS = 15
      ELSE IF (IOPT.EQ.2) THEN
        IF (DTTIME(1).GE.2000) THEN                                       30.70
          DTTIME(1) = DTTIME(1) - 2000                                    30.70
        ELSE
          DTTIME(1) = DTTIME(1) - 1900                                    30.70
        ENDIF
        WRITE (TIMSTR, 22) DTTIME(3), MONC(DTTIME(2)), DTTIME(1),         30.70
     &  (DTTIME(II), II=4,6)
  22    FORMAT (I2,'-',A3,'-',I2,'.',I2,':',I2,':',I2)
        LTS = 18
      ELSE IF (IOPT.EQ.3) THEN
        IF (DTTIME(1).GE.2000) THEN                                       30.70
          DTTIME(1) = DTTIME(1) - 2000                                    30.70
        ELSE
          DTTIME(1) = DTTIME(1) - 1900                                    30.70
        ENDIF
        WRITE (TIMSTR, 32)
     &  DTTIME(2), DTTIME(3), DTTIME(1), (DTTIME(II), II=4,6)             30.70
  32    FORMAT (I2,'/',I2,'/',I2,'.',I2,':',I2,':',I2)
        LTS = 17
      ELSE IF (IOPT.EQ.4) THEN
        WRITE (TIMSTR, 42) (DTTIME(II), II=4,6)
  42    FORMAT (I2,':',I2,':',I2)
        LTS = 8
      ELSE IF (IOPT.EQ.5) THEN                                            30.11
        IF (DTTIME(1).GE.2000) THEN                                       30.70
          DTTIME(1) = DTTIME(1) - 2000                                    30.70
        ELSE
          DTTIME(1) = DTTIME(1) - 1900                                    30.70
        ENDIF
        WRITE (TIMSTR, 52) (DTTIME(II), II= 1,6)                          30.70
  52    FORMAT (I2,'/',I2,'/',I2,'.',I2,':',I2,':',I2)
        LTS = 17
      ELSE IF (IOPT.EQ.6) THEN                                            30.11
        IF (DTTIME(1).GE.2000) THEN                                       30.70
          DTTIME(1) = DTTIME(1) - 2000                                    30.70
        ELSE
          DTTIME(1) = DTTIME(1) - 1900                                    30.70
        ENDIF
        WRITE (TIMSTR, 62) (DTTIME(II), II=1,5)                           30.70
  62    FORMAT (5I2)
        LTS = 10
      ELSE
        CALL MSGERR (2, 'wrong time coding option in subroutine DTTIST')
      ENDIF
*
      DO 94 IC = 1, LTS
        IF (TIMSTR(IC:IC).EQ.' ') TIMSTR(IC:IC) = '0'
  94  CONTINUE
*
      RETURN
      END
*******************************************************************
*
*            TRANSFERABLE VERSION OF THE PLOT ROUTINES
*
*     THESE PRODUCE NUMERICAL OUTPUT TO A PLOT FILE,
*     WHICH IS USED TO PRODUCE A FIGURE LATER ON,
*     USUALLY BY MEANS OF AN INTERACTIVE PROGRAM.
*
*     THE FIRST LINE OF AN OUTPUT UNIT IS A LINE CONTAINING
*     ONE INTEGERE NUMBER AND TWO REAL NUMBERS.
*     THE FIRST NUMBER IS THE PLOT CODE:
*     900   INITIALIZATION OF THE PLOT FILE
*     901   FIGURE INITIALIZATION
*     902   USE NEW PEN
*       0   MOVE PEN TO A CERTAIN POINT (PEN UP)
*       1   PLOT OF A STRAIGHT LINE TO A CERTAIN POINT
*     100   PLOTTING OF SINGLE (CENTERED) SYMBOL
*     101   PLOT A LINE TO A POINT AND PLOT A SYMBOL THERE
*     200   PLOTTING OF A CHARACTER STRING OR A NUMBER
*     999   TERMINATION OF A FIGURE
******************************************************************
*                                                                *
      SUBROUTINE OPFRAM (FROPT, PTITL)
*                                                                *
******************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     10.05, July 94: Subroutine OCPKAD is renamed OPFRAM
C                     moved to OCPIDS.FTN (basic plotting routines);
C                     new argument: frame option FROPTNew argument INIFIL
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. Purpose
C
C     Plots the edge of the figure and the captions
C
C  4. Argument variables
C
C     FROPT   inp  int   frame option: 0=no frame, 1=simple frame,
C                        2=DUT frame
C     PTITL   inp  char  figure title
C
C  7. Common blocks used
C
C     FILENM  i/o  char  filename of plotfile
C     XASL    inp  real  size on paper of geographic area in x-direction
C     YASL    inp  real  size on paper of geographic area in y-direction
C     SYMSIZ  out  real  size of symbols on plot
C     XPLO    out  real  lowest x on paper of geographic area
C     XPHI    out  real  highest x on paper of geographic area
C     YPLO    out  real  lowest y on paper of geographic area
C     YPHI    out  real  highest y on paper of geographic area
C     SUBLNS  out  int   number of lines in caption for scales etc.
C     XPSUB   out  real  array   position of one line of caption
C     YPSUB   out  real  array   ,,
C
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
C
      INTEGER   FROPT
      CHARACTER PTITL *(*)
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPFRAM')
*
*     Plot initialisation
*
      CALL OPINIT (XASM, YASM)
      IF (STPNOW()) RETURN                                                34.01
*
*     Plot frame of figure and text
*
*         plot heading
*
*     SYMSIZ: size of symbols on plot
      IF (XASM.LT.1.E-4) THEN
        WRITE (PRINTF, *) ' size of paper not given'
        SYMSIZ = 0.2
      ELSE
        SYMSIZ = XASM / 60.
      ENDIF
*
      IF (FROPT.EQ.1) THEN
*
*       simple frame
*
        XPLO = 0.5 * (XASM-XASL)
        XPHI = 0.5 * (XASM+XASL)
        YPLO = 0.1 * XASM
        YPHI = YPLO + YASL
        SUBLNS = 3
        DO 10 II = 1, SUBLNS
          XPSUB(II) = (SUBLNS-II) * XASM / 3.
          YPSUB(II) = 0.
  10    CONTINUE
        CALL OPPLOT (XPLO, YPLO, 'UP')
        CALL OPPLOT (XPHI, YPLO, 'DOWN')
        CALL OPPLOT (XPHI, YPHI, 'DOWN')
        CALL OPPLOT (XPLO, YPHI, 'DOWN')
        CALL OPPLOT (XPLO, YPLO, 'DOWN')
      ELSE IF (FROPT.EQ.2) THEN
        XPLO = 0.5 * (XASM-XASL)
        XPHI = 0.5 * (XASM+XASL)
*       YPLO = 0.116667 * XASL            replaced ver 30.20 (Swan)
        YPLO = 0.15 * XASL
        YPHI = YPLO + YASL
*        SYMSIZ = XASL / 60.
        SUBLNS = 4
        DO 20 II = 1, SUBLNS
          XPSUB(II) = XPLO + 41. * SYMSIZ
          YPSUB(II) = (2.*II-1.) * SYMSIZ
  20    CONTINUE
        CALL OPPLOT (XPLO, YPLO, 'UP')
        CALL OPPLOT (XPHI, YPLO, 'DOWN')
        CALL OPPLOT (XPHI, YPHI, 'DOWN')
        CALL OPPLOT (XPLO, YPHI, 'DOWN')
        CALL OPPLOT (XPLO, YPLO, 'DOWN')
        CALL OPPLOT (XPLO, 0.,   'DOWN')
        CALL OPPLOT (XPHI, 0.,   'DOWN')
        CALL OPPLOT (XPHI, YPLO, 'DOWN')
        XT = XPLO + 40.*SYMSIZ                                            30.20
        CALL OPPLOT (XT, YPLO, 'UP')
        CALL OPPLOT (XT, 0.,   'DOWN')
*
        XT = XPLO + 2.*SYMSIZ                                             30.20
        YT = 3.2*SYMSIZ
        CALL OPTEXT (XT, YT, 1.8*SYMSIZ, PROJID, 0., 16)
        XT = XPLO + 30.8*SYMSIZ                                           30.20
        CALL OPTEXT (XT, YT, 1.8*SYMSIZ, PROJNR, 0., 4)
        XT = XPLO + 2.*SYMSIZ                                             30.20
        YT = SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, PTITL, 0., 36)
      ENDIF
*
      IF (ITEST.GE.20) THEN
        WRITE (PRINTF, 75) FILENM, XASL, YASL, XPLO, XPHI, YPLO, YPHI
  75    FORMAT (' Test OPFRAM: ', A, 6E12.4)
      ENDIF
*
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE OPINIT (XFLEN, YFLEN)
*                                                                *
******************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     34.01: Jeroen Adema
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: PLINIT -> OPINIT
C                     coordinate x is horizontal to the right,
C                     and y is vertical from bottom to top
C     30.70, Nov. 97: writing HP instruction changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     34.01, Feb. 99: Introducing STPNOW
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     subr. starts the plotting of a figure
C     opens the plot file, if necessary
C
C  4. Argument variables
C
C     XFLEN   in  real  length of figure in x-direction
C     YFLEN   in  real  length of figure in y-direction
C
C  7. Common blocks used
C
C     FILENM  in  char  filename of plotfile
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
C 13. Source
C
      PARAMETER (NPLF=20)                                                 40.00
      INTEGER   IUNPLF(NPLF)
      LOGICAL   FILEXI
*
      SAVE IENT, NPLOT, IUNPLF
      DATA IENT /0/, NPLOT /0/
      CALL STRACE (IENT, 'OPINIT')
*
      IUPLF=0
      INQUIRE (FILE=FILENM,OPENED=FILEXI,NUMBER=IUPLF)
*
      IF (ITEST.GE.100) WRITE (PRINTF,6000) IUPLF, FILENM
 6000 FORMAT (' plotfile:', I3, '  filename: ',A36)
*
      IF (.NOT.FILEXI) THEN
        IUPLF  = 0                                                        30.51
        IOSTAT = -1
        CALL FOR (IUPLF, FILENM, 'UF', IOSTAT)
        IF (STPNOW()) RETURN                                              34.01
        NPLOT = NPLOT+1
        IF (NPLOT.GT.NPLF) CALL MSGERR(4, 'too many plot files')          40.00
        IUNPLF(NPLOT) = IUPLF
        IF (IPLOPT.EQ.1) THEN
*         write to plot file: 900, and two plot parameters
          WRITE (IUPLF, 5) 900, XASM, YASM
   5      FORMAT (2X, I6, 2(2X, F12.4))
        ELSE IF (IPLOPT.EQ.2) THEN
*
*         HPGL plot code
*         in array PLPARM he following data are found:
*         PLPARM(1,2) = maximum size available for plotting
*         PLPARM(3)   = number of plotting units per cm, default: 402.
*         PLPARM(4,5) = margins in x and y, default: 0.
*         PLPARM(6)   = orientation: 0 no rot., 1: rotate 90 degr.
*                       default: 1
*
*         write plot initialization
          WRITE (IUPLF, 6) 'IN;'
          WRITE (IUPLF, 6) 'DF;'
          WRITE (IUPLF, 6) 'VS10;'
          WRITE (IUPLF, 6) 'SP1;'
   6      FORMAT (1X, A)
          PLTLIN = '    '                                                 40.13
        ENDIF
      ELSE
        DO 20 IPLOT = 1, NPLOT
          IF (IUPLF.EQ.IUNPLF(IPLOT)) GOTO 21
  20    CONTINUE
        CALL MSGERR (2, 'File is not a known plotfile')
        IUPLF = IUNPLF(1)
  21    IF (IPLOPT.EQ.2) THEN
          WRITE (IUPLF, 6) 'PG;'
          WRITE (IUPLF, 6) 'DF;'
          WRITE (IUPLF, 6) 'VS10;'
          WRITE (IUPLF, 6) 'SP1;'
          WRITE (IUPLF, 6) 'PA;'
        ENDIF
      ENDIF
*
*     Initialize a figure
*
      IF (IPLOPT.EQ.1) THEN
        WRITE (IUPLF, 5) 901, XFLEN, YFLEN
      ENDIF
      PLFACT = 1.
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPTEXT (XT, YT, SYMS, STRNG, ANGL, NC)
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: PLTEXT -> OPTEXT
C     30.70, Nov. 97: writing HP instruction changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     OPTEXT plots a string
C
C  4. Argument variables
C
C     XT, YT  real inp   place where first character is plotted
C     SYMS    real inp   size of symbols on plot
C     STRNG   char inp   character string to be plotted
C     ANGL    real inp   angle under which the string is plotted
C     NC      int  inp   number of characters in string
C
      REAL       XT, YT, SYMS, ANGL
      CHARACTER  STRNG *(*)
      INTEGER    NC, IC, NK
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPTEXT')
*
      IF (IPLOPT.EQ.2) THEN                                               40.13
        IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                  40.13
          WRITE (IUPLF, 6) TRIM(PLTLIN)                                   40.13
          PLTLIN = '    '
   6      FORMAT (1X, A)
        ENDIF
      ENDIF                                                               40.13
      NK = 0
      DO 10 IC = NC, 1, -1
        IF (STRNG(IC:IC) .NE. ' ') THEN
           NK = IC
           GOTO 11
        ENDIF
  10  CONTINUE
  11  IF (NK .GT. 0) THEN
        IF (IPLOPT.EQ.1) THEN
          WRITE (IUPLF, 15) 200, XT*PLFACT, YT*PLFACT
  15      FORMAT (2X, I6, 2(2X, F12.4))
          WRITE (IUPLF, 15) NK, SYMS*PLFACT, ANGL
          WRITE (IUPLF, 16) STRNG
  16      FORMAT (A)
        ELSE IF (IPLOPT.EQ.2) THEN
          CALL CMTOPL (XT*PLFACT, YT*PLFACT, IX, IY)
          WRITE (IUPLF, 40) 'PU' , IX , IY , ';'
          WRITE (IUPLF, 41) 'SI', 0.68*SYMS*PLFACT , SYMS*PLFACT, ';'
          ARAD = 3.14159265*(PLPARM(6)/2. + ANGL/180.)
          CA = COS(ARAD)
          SA = SIN(ARAD)
          WRITE (IUPLF, 40)
     &       'DI', NINT(100.*CA), NINT(100.*SA), ';'
          WRITE (IUPLF, 43) 'LB', STRNG(1:NC), CHAR(3)
  40      FORMAT (1X, A, 2I6, A1)                                         30.70
  41      FORMAT (1X, A, 2F6.2, A1)                                       30.70
  43      FORMAT (1X, A, A, A1)                                           30.70
        ENDIF
      ENDIF
      RETURN
*     end of subroutine OPTEXT
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPMARK (XT, YT, SYMS, ISYM, UPDOWN)
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: PLMARK -> OPMARK
C     30.70, Nov. 97: writing HP instruction changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     OPMARK plots a single (centered) symbol
C
C  4. Argument variables
C
C     XT, YT  real inp   place where first character is plotted
C     SYMS    real inp   size of symbols on plot
C     ISYM    int  inp   indicator of symbol to be plotted
C                        symbol is centered at (XT,YT)
C     UPDOWN  int  inp   'UP':   pen moves to (XT,YT) with pen up
C                        'DOWN': pen moves to (XT,YT) with pen down
C
      REAL       XT, YT, SYMS
      INTEGER    ISYM
      CHARACTER  UPDOWN *(*)
      CHARACTER  PLKAR(9) *1
      SAVE IENT, PLKAR
      DATA PLKAR /'+','O','*','X','#','H','I','Z','N'/
      DATA IENT /0/
      CALL STRACE (IENT, 'OPMARK')
*
*     Output to plot file:
*     100: move with pen up, 101: move with pen down
*
      IF (IPLOPT.EQ.2) THEN                                               40.13
        IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                  40.13
          WRITE (IUPLF, 6) TRIM(PLTLIN)                                   40.13
          PLTLIN = '    '
   6      FORMAT (1X, A)
        ENDIF
      ENDIF                                                               40.13
      IF (IPLOPT.EQ.1) THEN
        IF (UPDOWN.EQ.'UP') THEN
          WRITE (IUPLF, 5) 100, XT*PLFACT, YT*PLFACT
        ELSE
          WRITE (IUPLF, 5) 101, XT*PLFACT, YT*PLFACT
        ENDIF
   5    FORMAT (2X, I6, 2(2X, F12.4))
        WRITE (IUPLF, 5) ISYM, SYMS*PLFACT
      ELSE IF (IPLOPT.EQ.2) THEN
        CALL CMTOPL (XT*PLFACT, YT*PLFACT, IX, IY)
        WRITE (IUPLF, 40) 'SI', SYMS*PLFACT, SYMS*PLFACT, ';'
        WRITE (IUPLF, 41) 'SM', PLKAR(ISYM), ';'
        IF (UPDOWN.EQ.'UP') THEN
          WRITE (IUPLF, 42) 'PU', IX, IY
          WRITE (IUPLF, 43) 'SM;'
        ELSE
          WRITE (IUPLF, 42) 'PD', IX, IY
          WRITE (IUPLF, 43) 'SM;'
        ENDIF
  40    FORMAT (1X, A, 2F6.2, A1)                                         30.70
  41    FORMAT (1X, A, A1, A1)                                            30.70
  42    FORMAT (1X, A, I6, ',', I6, A1)                                   30.70
  43    FORMAT (1X, A)                                                    30.70
      ENDIF
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPFACT (FF)
*                                                                  *
********************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                               30.74
 
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  Updates:
*     July 1994, ver. 10.03: Basic plotting routines renamed: FACTOR -> OPFACT
*
*  Function:
*     Plot coordinates are multiplied by factor FF
*
      REAL  FF
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPFACT')
*
      PLFACT = PLFACT * FF
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPPLOT (XT, YT, UPDOWN)
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: PLOT -> OPPLOT
C     30.70, Nov. 97: writing HP instructions changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     OPPLOT moves the pen to location (XT,YT)
C     UPDOWN='UP': move with pen up, UPDOWN='DOWN': move with pen down
C
      REAL       XT, YT
      CHARACTER  UPDOWN *(*)
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPPLOT')
*
*     Output to plot file:
*     0: move with pen up, 1: move with pen down
*
      IF (IPLOPT.EQ.1) THEN
        IF (UPDOWN.EQ.'UP') THEN
          WRITE (IUPLF, 5) 0, XT*PLFACT, YT*PLFACT
        ELSE
          WRITE (IUPLF, 5) 1, XT*PLFACT, YT*PLFACT
        ENDIF
   5    FORMAT (2X, I6, 2(2X, F12.4))
      ELSE IF (IPLOPT.EQ.2) THEN
        CALL CMTOPL (XT*PLFACT, YT*PLFACT, IX, IY)
        IF (UPDOWN.EQ.'UP') THEN
          IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                40.13
            WRITE (IUPLF, 6) TRIM(PLTLIN)                                 40.13
            PLTLIN = '    '                                               40.13
          ENDIF                                                           40.13
          WRITE (IUPLF, 6) 'PU' , IX , IY , ';'
        ELSE
          LL = LEN(TRIM(PLTLIN))                                          40.13
          IF (LL.GT.LENPLT-20) THEN                                       40.13
!           plot line is full; write to plot file and make empty          40.13
            WRITE (IUPLF, 6) TRIM(PLTLIN)                                 40.13
            PLTLIN = '    '
            LL = 0
          ENDIF
          IF (LL.EQ.0) THEN                                               40.13
!           empty plot line; write PD and point coordinates               40.13
            WRITE (PLTLIN, 8) 'PD' , IX , IY                              40.13
   8        FORMAT (A, 2(1X, I6))
          ELSE
!           add point coordinates to plot line                            40.13
            WRITE (PLTLIN(LL+1:LL+20), 9) IX , IY                         40.13
   9        FORMAT (2(1X, I6))
          ENDIF                                                           40.13
        ENDIF
   6    FORMAT (1X, A, I6, ',', I6, A1)                                   30.70
      ENDIF
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPENDF
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: LASPLO -> OPENDF
C     30.70, Nov. 97: writing HP instructions changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     OPENDF terminates a picture
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPENDF')
*
*     Output to plot file:
*
      IF (IPLOPT.EQ.1) THEN
        WRITE (IUPLF, 5) 999, 0., 0.
   5    FORMAT (2X, I6, 2(2X, F12.4))
      ELSE IF (IPLOPT.EQ.2) THEN
        IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                  40.13
          WRITE (IUPLF, 6) TRIM(PLTLIN)                                   40.13
          PLTLIN = '    '                                                 40.13
        ENDIF                                                             40.13
        WRITE (IUPLF, 6) 'PU 0,0;'
        WRITE (IUPLF, 6) 'SP0;'
   6    FORMAT (1X, A)                                                    30.70
      ENDIF
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPNPEN (IPEN)
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: NEWPEN -> OPNPEN
C     30.70, Nov. 97: writing HP instructions changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     A new plotting pen (with different color) is put on
C
C  4. Argument variables
C
C     IPEN  int,input    number of the new pen
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPNPEN')
*
      IF (IPLOPT.EQ.1) THEN
        WRITE (IUPLF, 5) 902, 0., 0.
        WRITE (IUPLF, 5) IPEN
   5    FORMAT (2X, I6, 2(2X, F12.4))
      ELSE IF (IPLOPT.EQ.2) THEN
        IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                  40.13
          WRITE (IUPLF, 6) TRIM(PLTLIN)                                   40.13
          PLTLIN = '    '                                                 40.13
        ENDIF                                                             40.13
        WRITE (IUPLF, 6) 'SP', IPEN, ';'
   6    FORMAT (1X, A, I2, A1)                                            30.70
      ENDIF
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPTYPE (LNT, DASHL)
*                                                                  *
********************************************************************
C
      USE OCP_PLOTDATA                                                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.74: IJsbrand Haagsma (Include version)
C     40.13: Nico Booij
C
C  1. Updates
C
C     10.03, July 94: Basic plotting routines renamed: LNTYPE -> OPTYPE
C     30.70, Nov. 97: writing HP instructions changed + formats changed
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.13, Jan. 01: introducing PLTLIN (for continuous line plotting)
C
C  2. Purpose
C
C     A new line type is going to be plotted
C
C  4. Argument variables
C
C     LNT    int  input    line type: 1-6 dashed, 10: continuous
C     DASHL  real input    dash length
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPTYPE')
*
      IF (IUPLF.GT.0) THEN
        IF (IPLOPT.EQ.1) THEN
          WRITE (IUPLF, 5) 903, 0., 0.
          WRITE (IUPLF, 5) LNT, DASHL
   5      FORMAT (2X, I6, 2(2X, F12.4))
        ELSE IF (IPLOPT.EQ.2) THEN
          IF (LEN(TRIM(PLTLIN)).GT.0) THEN                                40.13
            WRITE (IUPLF, 6) TRIM(PLTLIN)                                 40.13
            PLTLIN = '    '                                               40.13
          ENDIF                                                           40.13
          IF (LNT.GE.0 .AND. LNT.LT.7) THEN
            WRITE (IUPLF, 6) 'LT', LNT, DASHL/0.3, ';'
   6        FORMAT (1X, A, I1, ',', F6.3, A1)                             30.70
          ELSE
            WRITE (IUPLF, 6) 'LT;'                                        30.70
          ENDIF
        ENDIF
      ENDIF
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE CMTOPL (XP, YP, IX, IY)
*                                                                *
******************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C
C  1. Updates
C
C     10.03, July 94: this subroutine is added in view of HPGL code
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C
C  2. Purpose
C
C     converts paper coordinates (XP,YP ,in cm)
C     to (HP) plot units (integer numbers IX,IY)
C
C  4. Argument variables
C
C     LNT    int  input    line type: 1-6 dashed, 10: continuous
C     DASHL  real input    dash length
C
C  7. Common blocks used
C
C     PLPARM(3)  conversion factor; default 402.
C     PLPARM(4)  plotting margin horizontal
C     PLPARM(5)  plotting margin vertical
C     PLPARM(6)  rotation
C
      REAL     XP, YP
      INTEGER  IX, IY
      IF (ABS(PLPARM(6)).LE.0.1) THEN
        IX = NINT (PLPARM(3)*(XP+PLPARM(4)))
        IY = NINT (PLPARM(3)*(YP+PLPARM(5)))
      ELSE
        IX = NINT (PLPARM(3)*(PLPARM(4)-YP))
        IY = NINT (PLPARM(3)*(XP+PLPARM(5)))
      ENDIF
      RETURN
      END
