!NRL: $Id: ocpmix.F,v 1.3.2.2 2003/07/01 15:57:04 dykes Exp $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000   12:57 pm
C     Ocean Pack miscellaneous routines
C
C     real function DTTIME
C     subroutine    DTINTI
C     subroutine    DTRETI
C     char function DTTIWR
C/TempC     VALIDV
C     REPARM
C     INAR2D
C     STRACE
C     MSGERR
C     TABHED
C     FOR
C     logical function EQREAL  Checks whether REAL1 is appr.              30.72
C                                equal to REAL2                           30.72
C     LSPLIT             splits an input line into data items             40.00
C     BUGFIX                                                              40.03
C
********************************************************************
*                                                                  *
      REAL FUNCTION DTTIME (INTTIM)
*                                                                  *
********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C
C  1. Updates
C
C      9705, May  97: month number is checked
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C
C  2. Purpose
C
C     DTTIME gives time in seconds from a reference day
C            it also initialises the reference day
C
C  3. Method
C
C     every fourth year is a leap-year, but not the century-years, however
C     also leap-years are: year 0, 1000, 2000 etc.
C     1 jan of year 0 is daynumber 1.
C
C  4. Argument variables
C
C     INTTIM(1): year
C           (2): month
C           (3): day
C           (4): hour
C           (5): minute
C           (6): second
C
      INTEGER INTTIM(6)                                                   30.74
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IDYMON : number of days of each month (February counts as 28 days)
C     IYEAR  : number of years after substacking the centuries
C     IYRM1  : ??
C     IDNOW  : ??
C     I      : ??
C     II     : ??
C
      INTEGER IDYMON(12), IYEAR, IYRM1, IDNOW, I, II
C
C     LEAPYR : Whether year in INTTIM(1) is a leapyear
C     LOGREF : ??
C
      LOGICAL LEAPYR, LOGREF
C
C  7. Common blocks used
C
C     REFDAY  day number of the reference day; the reference time is 0:00
C            of the reference day; the first day entered is used as
C             reference day.
C
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE LOGREF, IDYMON
      DATA IDYMON /31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31/
      DATA LOGREF /.FALSE./
*
      IYEAR = INTTIM(1)
      IYRM1 = IYEAR-1
      LEAPYR=(MOD(IYEAR,4).EQ.0.AND.MOD(IYEAR,100).NE.0).OR.
     +        MOD(IYEAR,1000).EQ.0
      IDNOW=0
      IF (INTTIM(2).GT.12) THEN                                           9705
        WRITE (PRINTF, 8) INTTIM(2), (INTTIM(II), II=1,6)                 9705
   8    FORMAT (' erroneous month ', I2, ' in date/time ', 6I4)           9705
      ELSE IF (INTTIM(2).GT.1) THEN                                       9705
        DO 10 I = 1,INTTIM(2)-1
          IDNOW=IDNOW+IDYMON(I)
  10    CONTINUE
      ENDIF                                                               9705
      IDNOW=IDNOW+INTTIM(3)
      IF (LEAPYR.AND.INTTIM(2).GT.2) IDNOW=IDNOW+1
      IDNOW = IDNOW + IYEAR*365 + IYRM1/4 - IYRM1/100 + IYRM1/1000 + 1
      IF (IYEAR.EQ.0) IDNOW=IDNOW-1
      IF (.NOT.LOGREF) THEN
        REFDAY = IDNOW
        LOGREF = .TRUE.
        DTTIME = 0.
      ELSE
        DTTIME = REAL(IDNOW-REFDAY) * 24.*3600.
      ENDIF
      DTTIME = DTTIME + 3600.*REAL(INTTIM(4)) + 60.*REAL(INTTIM(5)) +
     &                  REAL(INTTIM(6))
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE DTINTI (TIMESC, INTTIM)
*                                                                  *
********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C     30.70: Nico Booij (small change)
C
C  1. Updates
C
C      9705, May  97: month number is checked
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.70, Jan. 98: small change in interpretation of time in sec
C
C  2. Purpose
C
C     DTINTI calculates integer time array INTTIM from time in seconds
C            from given reference day REFDAY
C
C  3. Method
C
C     every fourth year is a leap-year, but not the century-years, however
C     also leap-years are: year 0, 1000, 2000 etc.
C     1 jan of year 0 is daynumber 1.
C
C  4. Argument variables
C
C     INTTIM(1): year
C           (2): month
C           (3): day
C           (4): hour
C           (5): minute
C           (6): second
C
      INTEGER INTTIM(6)
C
C     TIMESC : input  time in seconds from given reference day REFDAY
C
      REAL TIMESC
C
C  5. PARAMETER VARIABLES
C
C     IDAYYR : number of days in 'normal' year (no leap-year)
C     IDYCEN : number of days in a century
C     IDYMIL : number of days in a millenium (1000 years)
C     IFOUR  : number of days in 4 year with 1 leap-year
C
      INTEGER IDAYYR, IDYCEN, IDYMIL, IFOUR
C
      PARAMETER (IDAYYR = 365)
      PARAMETER (IDYMIL = IDAYYR*1000+1000/4-1000/100+1)
      PARAMETER (IDYCEN = IDAYYR*100+100/4-1)
      PARAMETER (IFOUR  = 4*IDAYYR+1)
C
C  6. LOCAL VARIABLES
C
C     I4     : number of blocks of four years after subtraction of the
C              millenia and the centuries
C     ICEN   : number of centuries after subtracking the millenia
C     IDYMN  : day of the month
C     IDYMON : number of days of each month (February counts as 28 days)
C     IDYNOW : local daynumber
C     IMIL   : number of millenia in julday-1 days
C     IMN    : month counter
C     IYR    : remaining number of years
C     IYEAR  : number of years after substacking the centuries
C     NDAY   : number of days since reference day
C     NOWDAY : reference day
C
      INTEGER I4, ICEN, IDYMN, IDYMON(12), IDYNOW, IMIL, IMN, IYR, IYEAR
     +, NDAY, NOWDAY
C
C     TT     : time in seconds since begin of the same day
C
      REAL    TT
C
C     LEAPYR : logical for yes or no leap-year
C
      LOGICAL LEAPYR
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IDYMON
      DATA IDYMON /31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31/
C
      NDAY = INT((TIMESC+0.4)/(24*3600))                                  30.70
  10  TT   = TIMESC - REAL(NDAY)*24.*3600.
      IF (TT.LT.-0.4) THEN                                                30.70
        NDAY = NDAY - 1
        GOTO 10
      ENDIF
      NOWDAY = REFDAY + NDAY
C
C        get year
C
      IDYNOW = NOWDAY-1
      IMIL   = IDYNOW/IDYMIL
      IDYNOW = IDYNOW-IMIL*IDYMIL
      ICEN   = (IDYNOW-(IDYCEN+1))/IDYCEN+1
      IF (IDYNOW-(IDYCEN+1).LT.0) ICEN=0
      IF (ICEN.EQ.0) THEN
        I4     = IDYNOW/IFOUR
        IDYNOW = IDYNOW-I4*IFOUR
      ELSE
        IDYNOW = IDYNOW-(IDYCEN+1)-(ICEN-1)*IDYCEN
        I4     = (IDYNOW-(IFOUR-1))/IFOUR+1
        IF(IDYNOW-(IFOUR-1).LT.0) I4=0
        IF(I4.GT.0) IDYNOW=IDYNOW-(IFOUR-1)-(I4-1)*IFOUR
      END IF
      IYR   = (IDYNOW-(IDAYYR+1))/IDAYYR+1
      IF(IDYNOW-(IDAYYR+1).LT.0) IYR=0
      IYEAR = 1000*IMIL + 100*ICEN + 4*I4 + IYR
*
*        get month and day
*
      LEAPYR = (MOD(IYEAR,4).EQ.0.AND.MOD(IYEAR,100).NE.0).OR.
     +          MOD(IYEAR,1000).EQ.0
      IF (IYR.GT.0) IDYNOW=IDYNOW-(IDAYYR+1)-(IYR-1)*IDAYYR
      IDYNOW = IDYNOW+1
      DO 30 IMN = 1, 12
        IDYMN=IDYMON(IMN)
        IF(LEAPYR.AND.IMN.EQ.2) IDYMN=IDYMN+1
        IF(IDYNOW.LE.IDYMN) GOTO 40
        IDYNOW=IDYNOW-IDYMN
  30  CONTINUE
  40  INTTIM(2) = IMN
      INTTIM(3) = IDYNOW
      INTTIM(1) = IYEAR
*
*        get time of day
*
      INTTIM(4) = INT(TT/3600.)
      TT        = TT - 3600.*REAL(INTTIM(4))
      INTTIM(5) = INT(TT/60.)
      TT        = TT - 60.*REAL(INTTIM(5))
      INTTIM(6) = INT(TT)
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE DTRETI (TSTRNG, IOPT, TIMESC)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IOPT   : input    option number
C
      INTEGER IOPT
C
C     TIMESC : output   time in seconds from given reference day REFDAY
C
      REAL    TIMESC
C
C     TSTRNG : input    time string
C
      CHARACTER  TSTRNG *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     ITIME  : ??
C
      INTEGER ITIME(6)
C
C     DTTIME : Gives time in seconds from a reference day it also initialises the
C              reference day
C
      REAL    DTTIME
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DTSTTI   (installation dependent subroutines)
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      CALL DTSTTI (IOPT, TSTRNG, ITIME)
      TIMESC = DTTIME (ITIME)
      RETURN
      END
******************************************************************
*                                                                *
      CHARACTER *18 FUNCTION DTTIWR (IOPT, TIMESC)                        30.00
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     40.02: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.05: New subroutine
C     40.02, Oct. 00: Made length of TSTRNG equal to TIMESTR
C
C  2. PURPOSE
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IOPT   : input    time coding option number
C
      INTEGER    IOPT
C
C     TIMESC : output   time in seconds from given reference day REFDAY
C
      REAL       TIMESC
C
C     TSTRNG : input    time string
C
      CHARACTER (LEN=24) :: TSTRNG                                        40.02
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLESC
C
      INTEGER    ITIME(6)
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     DTTIST   (installation dependent subroutines)
C     DTINTI   (misc. routines)
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C                                              30.00
      CALL DTINTI (TIMESC, ITIME)
      CALL DTTIST (IOPT, TSTRNG, ITIME)
      DTTIWR = TSTRNG(1:18)                                               40.02
      RETURN
      END
C/Temp******************************************************************
C/Temp*                                                                *
C/Temp      SUBROUTINE VALIDV (MONVAL)
C/Temp*                                                                *
C/Temp******************************************************************
C/Temp
C/Temp      INCLUDE 'ocpcomm1.inc'                                              30.74
C/Temp      INCLUDE 'ocpcomm2.inc'                                              30.74
C/Temp      INCLUDE 'ocpcomm3.inc'                                              30.74
C/Temp      INCLUDE 'ocpcomm4.inc'                                              30.74
C/Temp
C/Temp##COPYRIGHT
C/Temp##DISCLAIMER
C/Temp*
C/Temp*     Updates
C/Temp*
C/Temp*     Argument list:
C/Temp*
C/Temp*       MONVAL  input  int   last month of validity
C/Temp*
C/Temp*     Subroutine used:
C/Temp*
C/Temp*     From common:
C/Temp*
C/Temp*       VERNUM  input  real  version number
C/Temp*
C/Temp*     Source:
C/Temp*
C/Temp      INTEGER    MONNOW, MONVAL, PRCTIM(6)
C/Temp*
C/Temp      IF (MONVAL.GT.0) THEN
C/Temp        CALL OCDTIM (PRCTIM)
C/Temp*       Validity period is checked (MONVAL is last month of period)
C/Temp        MONNOW = PRCTIM(1)*100 + PRCTIM(2)
C/Temp        IF (MONNOW .GT. MONVAL .OR. MONNOW .LT. 199701) THEN
C/Temp           WRITE(PRINTF,6050)
C/Temp           WRITE(PRINTF,6100) VERNUM
C/Temp           WRITE(SCREEN,6060)
C/Temp           WRITE(SCREEN,6100) VERNUM
C/Temp           WRITE(SCREEN,6060)
C/Temp 6050      FORMAT(' ** TERMINATING ERROR: ')
C/Temp 6060      FORMAT( ////////)
C/Temp 6100      FORMAT(' Version ', F6.2, '  VALIDITY EXPIRED', //,
C/Temp     &             ' Contact Dr. N. Booij for a new version', /,
C/Temp     &             ' Address: Delft University of Technology', /,
C/Temp     &             '          Faculty of Civil Engineering', /,
C/Temp     &             ' P.O. Box 5048 ', /,
C/Temp     &             ' 2600 GA  Delft, The Netherlands ')
C/Temp           STOP
C/Temp        ENDIF
C/Temp      ENDIF
C/Temp      RETURN
C/Temp      END
******************************************************************
*                                                                *
      SUBROUTINE REPARM (NDSL, NDSD, IDLA, IDFM, RFORM,                   40.00
     &                   NHEDF, LOGT, NHEDT, LOGC, NHEDC)                 40.00
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C     30.80: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     40.00: Nico Booij (modifications)
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     30.10, Dec. 95: [fac] is read before 'fname' in view of later
C                     reading of tables; argument VFAC removed
C                     arguments LOGT, NHEDT, LOGC, NHEDC added
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.00, Jan. 98: SWAN specific statements modified; argument list
C                     changed
C     30.82, Sep. 98: Added type specification for HEDLIN
C     30.80, Dec. 98: Initialisation of NHEDT and NHEDC
C     34.01, Feb. 99: Introducing STPNOW
C     40.02, Sep. 00: Replaced computed GOTO by CASE construct
C     40.03, Jul. 00: TRIM used to improve readability of message
C
C  2. Purpose
C
C     reads parameters for reading an array from users input
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IDFM   : output   format index
C     IDLA   : output   lay-out indicator
C     NDSD   : ??       unit number of the file from which to read the dataset
C     NDSL   : ??       unit number of the file containing the list of filenames
C     NHEDF  : output   number of heading lines in the file (once in each file)
C     NHEDT  : output   number of heading lines in the file before reading
C                       each time level
C     NHEDC  : output   number of heading lines in the file before each array
C                       or vector component
C
      INTEGER   IDFM, IDLA,  NDSL, NDSD, NHEDF, NHEDT, NHEDC
C
C     LOGT   : input    if True field is time-dependent
C     LOGC   : input    if True more than one component is read from file
C
      LOGICAL   LOGT, LOGC
C
C     RFORM  : output   reading format
C
      CHARACTER RFORM *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C
C     IENT   : Number of entries into this subroutine
C     IH     : ??
C     IOSTAT : input   0 : Full messages printed
C                      -1: Only error messages printed
C                      -2: No messages printed
C              output  error indicator
C
      INTEGER   IENT, IH, IOSTAT
C
C     HEDLIN : Content of a header line
C     KEYWIS : ??
C
      LOGICAL   KEYWIS, BNEW
C
C     OLDFIL : ??
C
      CHARACTER HEDLIN*80, OLDFIL *36
C                                                                         30.82
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
      LOGICAL   STPNOW                                                    34.01
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE  IENT, OLDFIL
      DATA  IENT /0/
      DATA  OLDFIL /'                                    '/
      CALL STRACE (IENT, 'REPARM')
C
      CALL INKEYW ('STA', '   ')
      IF (KEYWIS('SERI')) THEN
        CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
C       open namelist file and read first datafile name
        CALL FOR (NDSL, FILENM, 'OF', IOSTAT)                             40.00
        IF (STPNOW()) RETURN                                              34.01
        READ(NDSL, '(A36)') FILENM
      ELSE
        CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')                         40.00
      ENDIF
C
      IF (FILENM.NE.OLDFIL) THEN
        BNEW = .TRUE.
        NDSD = 0
        IDLA = 1
        IDFM = 0
        RFORM = ' '
        NHEDF = 0
        OLDFIL = FILENM
      ELSE
        BNEW = .FALSE.
      ENDIF
C
      CALL INKEYW ('STA', ' ')
      IF (BNEW) THEN
*       read lay-out indicator
        CALL ININTG ('IDLA', IDLA, 'UNC', 1)
*       names changed and order changed, ver 30.20 (Swan)
        CALL ININTG ('NHEDF', NHEDF, 'UNC', 0)                            30.20
        NHEDT = 0                                                         30.80
        IF (LOGT) THEN
          CALL ININTG ('NHEDT', NHEDT, 'UNC', 0)                          30.21
        ENDIF
        NHEDC = 0                                                         30.80
        IF (LOGC) THEN
          CALL ININTG ('NHEDVEC', NHEDC, 'UNC', 0)                        30.20
        ENDIF
        CALL INKEYW ('STA', 'FREE')                                       30.06
        IDFM = 2
        IF (KEYWIS('FRE')) THEN
          IDFM = 0
        ELSE IF (KEYWIS('UNF')) THEN
          IDFM = -1
        ELSE IF (KEYWIS('FOR')) THEN
*         formatted read
          CALL ININTG ('IDFM', IDFM, 'NSKP', 2)
          SELECT CASE(IDFM)                                               40.02
          CASE(1)                                                         40.02
            RFORM = '(10X,12F5.0)'                                        40.02
          CASE(2)                                                         40.02
            CALL INCSTR ('FORM', RFORM, 'REQ', ' ')                       40.02
          CASE(5)                                                         40.02
            RFORM = '(16F5.0)'                                            40.02
          CASE(6)                                                         40.02
            RFORM = '(12F6.0)'                                            40.02
          CASE(8)                                                         40.02
            RFORM = '(10F8.0)'                                            40.02
          CASE DEFAULT                                                    40.02
            CALL MSGERR (2, 'illegal format number')                      40.02
            WRITE (PRINTF, 50) IDFM                                       40.02
  50        FORMAT (' -> ', I6)                                           40.02
          END SELECT                                                      40.02
        ELSE
          CALL WRNKEY                                                     30.06
          IDFM = 0
        ENDIF
*       --------------------------------------------------------
*                          open the file
*       --------------------------------------------------------

        IF (IDFM.NE.-1) THEN
          IOSTAT = 0
          CALL FOR (NDSD, FILENM, 'OF', IOSTAT)                           40.00
          IF (STPNOW()) RETURN                                            34.01
          IF (NHEDF.GT.0) THEN                                            40.00
            WRITE (PRINTF, '(A,A,A)') ' **  Heading lines file ',
     &      TRIM(FILENM), ' **'                                           40.03
            DO IH=1, NHEDF
              READ (NDSD, '(A80)') HEDLIN
              WRITE (PRINTF, '(A4,A80)') ' -> ', HEDLIN                   40.00
            ENDDO
          ENDIF
        ELSE
          IOSTAT = 0
          CALL FOR (NDSD, FILENM, 'OU', IOSTAT)                           40.00
          IF (STPNOW()) RETURN                                            34.01
          DO IH=1, NHEDF
            READ (NDSD)                                                   40.00
          ENDDO
        ENDIF
      ENDIF
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE INAR2D (ARR, MXA, MYA, NDSL, NDSD, IDFM, RFORM,          40.00
     &  IDLA, VFAC, NHED, NHEDF)                                          40.00
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.82: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
C     40.13: Nico Booij
C
C  1. Updates
C
C     01.05, Feb. 90: Before reading values in the array are divided by VFAC,
C                     in order to retain correct values for points where no
C                     value was given
C     01.06, Apr. 91: i/o status is printed if read error occurs
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.72, Sept 97: Corrected reading of heading lines for SERIES of files
C                     in dynamic mode
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.00, July 98: SWAN specific statements modified
C                     unformatted read: heading lines also read unformatted
C                     distinction between NDSD (data file) and NDSL (file list)
C     30.82, Sep. 98: Added INQUIRE statement to produce correct file name in
C                     case of a read error
C     34.01, Feb. 99: Introducing STPNOW
C     40.02, Sep. 00: Replaced computed GOTO with CASE construct
C     40.02, Sep. 00: Replaced reserved words IOSTAT with IOERR and STATUS with IERR
C     40.03, Jul. 00: END= added to READ statement for correct reading of series
C                     of files
C     40.03, Jul. 00: TRIM used to improve readability of message
C     40.13, Apr. 01: END=930 added in READ statement; corresponding error message added
C
C  2. Purpose
C
C     Reads a 2d array from dataset
C     is used to read e.g. bathymetry, one component of wind velocity
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IDFM   : input    format index
C     IDLAM  : input    lay-out indicator
C     MXA    : input    number of points along x-side of grid
C     MYA    : input    number of points along y-side of grid
C     NDSD   : input    unit number of the file from which to read the dataset
C     NDSL   : input    unit number of the file containing the list of filenames
C     NHEDF  : input    number of heading lines in the file (first lines).
C     NHEDL  : input    number of heading lines in the file
C                       before each array
C
      INTEGER   IDFM, IDLA, MXA, MYA, NDSD, NDSL, NHED, NHEDF
C
C     ARR    : input    results appear in this array
C     RFORM  : input    format used in reading data (char. string)
C     VFAC   : input    factor by which data must be multiplied.
C
      REAL      ARR(MXA,MYA), VFAC
C
      CHARACTER RFORM *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IERR   : ??
C     IENT   : number of entries into this subroutine
C     IOERR  : input   0 : Full messages printed
C                      -1: Only error messages printed
C                      -2: No messages printed
C              output  error indicator
C     IH     : ??
C     IX     : ??
C     IY     : ??
C     NUMFIL : ??
C
      INTEGER   IERR, IENT, IOERR, IH, IX, IY, NUMFIL                     40.02
C
C     HEDLIN : Content of a header line
C
      CHARACTER HEDLIN *80
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
      LOGICAL STPNOW                                                      34.01
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'INAR2D')
C
 999  IF (NDSD.LT.0) RETURN                                               40.00
C     no reading from file due to open error
C
C     *** NUMFIL is the number of that is open in one time step  **
      NUMFIL = 0                                                          30.00
      IF (ITEST.GE.100) THEN
        WRITE (PRINTF, 12) MXA, MYA, NDSD, IDFM, RFORM,                   40.00
     &  IDLA, VFAC, NHED
  12    FORMAT (' * TEST INAR2D *', 4I4, 1X, A16, I3, 1X, E12.4, I3)
      ENDIF
C
C     Read heading lines, and print the same:
C
  11  IF (NHED.GT.0) THEN
        IF (IDFM.LT.0) THEN                                               40.00
          IF (ITEST.GE.30)
     &             WRITE (PRINTF, '(I3,A)') NHED, ' Heading lines'        40.00
          DO 28 IH=1, NHED
            READ (NDSD, END=910)                                          40.03
  28      CONTINUE
        ELSE
          DO 30 IH=1, NHED
            READ (NDSD, '(A80)', end=910) HEDLIN                          40.03
            IF (IH.EQ.1) WRITE (PRINTF, '(A)') ' **  Heading lines  **'
            WRITE (PRINTF, '(A4,A80)') ' -> ', HEDLIN
  30      CONTINUE
        ENDIF
      ENDIF
C
C     divide existing values in the array by VFAC
C
      DO 39 IY = 1, MYA                                                   30.72
        DO 38 IX = 1, MXA
          ARR(IX,IY) = ARR(IX,IY) / VFAC
  38    CONTINUE                                                          30.72
  39  CONTINUE                                                            30.72
C
C     start reading of 2D-array
C
      IF (IDFM.EQ.0) THEN
C       free format read
        SELECT CASE(IDLA)                                                 40.02
        CASE(1)                                                           40.02
	print*,"case1"
          DO IY=MYA, 1, -1                                                40.02
            READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                 40.02
     &      (ARR(IX,IY), IX=1,MXA)                                        40.02
          ENDDO                                                           40.02
	print*,"done with case 1"
        CASE(2)                                                           40.02
	print*,"case2"
          READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &               ((ARR(IX,IY), IX=1,MXA), IY=MYA,1,-1)                40.02
        CASE(3)                                                           40.02
	print*,"case3"
          DO IY=1, MYA                                                    40.02
            READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                 40.02
     &               (ARR(IX,IY), IX=1,MXA)                               40.02
          ENDDO                                                           40.02
        CASE(4)                                                           40.02
	print*,"case4"
          READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &              ((ARR(IX,IY), IX=1,MXA), IY=1,MYA)                    40.02
        CASE(5)                                                           40.02
	print*,"case5"
          DO IX=1, MXA                                                    40.02
            READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                 40.02
     &               (ARR(IX,IY), IY=1,MYA)                               40.02
          ENDDO                                                           40.02
        CASE(6)                                                           40.02
	print*,"case6"
          READ (NDSD, *, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &               ((ARR(IX,IY), IY=1,MYA), IX=1,MXA)                   40.02
        END SELECT                                                        40.02
      ELSE IF (IDFM.GT.0) THEN
*       read with fixed format
        SELECT CASE (IDLA)                                                40.02
        CASE(1)                                                           40.02
	print*,"case1f"
          DO IY=MYA, 1, -1                                                40.02
            READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)             40.02
     &      (ARR(IX,IY), IX=1,MXA)                                        40.02
          ENDDO                                                           40.02
        CASE(2)                                                           40.02
	print*,"case2f"
          READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)               40.02
     &    ((ARR(IX,IY), IX=1,MXA), IY=MYA,1,-1)                           40.02
        CASE(3)                                                           40.02
	print*,"case3f"
          DO IY=1, MYA                                                    40.02
            READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)             40.02
     &      (ARR(IX,IY), IX=1,MXA)                                        40.02
          ENDDO                                                           40.02
        CASE(4)                                                           40.02
	print*,"case4f"
          READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)               40.02
     &    ((ARR(IX,IY), IX=1,MXA), IY=1,MYA)                              40.02
        CASE(5)                                                           40.02
	print*,"case5f"
          DO IX=1, MXA                                                    40.02
            READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)             40.02
     &      (ARR(IX,IY), IY=1,MYA)                                        40.02
          ENDDO                                                           40.02
        CASE(6)                                                           40.02
	print*,"case6f"
          READ (NDSD, RFORM, END=910, ERR=920, IOSTAT=IERR)               40.02
     &    ((ARR(IX,IY), IY=1,MYA), IX=1,MXA)                              40.02
        END SELECT                                                        40.02
      ELSE
*       unformatted read
        SELECT CASE(IDLA)
        CASE(1)
          DO IY=MYA, 1, -1                                               40.02
            READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &      (ARR(IX,IY), IX=1,MXA)                                       40.02
          ENDDO                                                          40.02
        CASE(2)                                                          40.02
          READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                     40.02
     &    ((ARR(IX,IY), IX=1,MXA), IY=MYA,1,-1)                          40.02
        CASE(3)                                                          40.02
          DO IY=1, MYA                                                   40.02
            READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &      (ARR(IX,IY), IX=1,MXA)                                       40.02
          ENDDO                                                          40.02
        CASE(4)                                                          40.02
          READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                     40.02
     &    ((ARR(IX,IY), IX=1,MXA), IY=1,MYA)                             40.02
        CASE(5)                                                          40.02
          DO IX=1, MXA                                                   40.02
            READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                   40.02
     &      (ARR(IX,IY), IY=1,MYA)                                       40.02
          ENDDO                                                          40.02
        CASE(6)                                                          40.02
          READ (NDSD, END=910, ERR=920, IOSTAT=IERR)                     40.02
     &    ((ARR(IX,IY), IY=1,MYA), IX=1,MXA)                             40.02
        END SELECT                                                       40.02
      ENDIF
      GOTO 900                                                           40.02
*
*     *** End of data file, in case SERIES next file is opened
*     *** unit = NDSD is closed before the next one is opened
*
 910  CONTINUE
	print*,"conting"
      CLOSE(NDSD)
      NUMFIL = NUMFIL + 1
	print*,"numfil",numfil
      IF (NUMFIL .GE. 2) GO TO 911
      IF (NDSL.GT.0) THEN
        READ (NDSL, '(A)', END=930) FILENM                                40.13
        IF (IDFM.NE.-1) THEN
          IOERR = 0
          CALL FOR (NDSD, FILENM, 'OF', IOERR)                            40.02
          IF (STPNOW()) RETURN                                            34.01
        ELSE
          IOERR = 0
          CALL FOR (NDSD, FILENM, 'OU', IOERR)                            40.02
          IF (STPNOW()) RETURN                                            34.01
        ENDIF
*
*       Read heading lines, and print these:
*                                                                         30.72
  2     IF (NHEDF.GT.0) THEN                                              30.72
          IF (IDFM.LT.0) THEN                                             40.00
            IF (ITEST.GE.30) WRITE (PRINTF, '(I3,A,A)') NHEDF,
     &            ' Heading lines at begin of file ', TRIM(FILENM)        40.03
            DO 828 IH=1, NHEDF                                            40.00
              READ (NDSD)                                                 40.00
 828        CONTINUE
          ELSE                                                            40.00
            WRITE (PRINTF, '(A,A,A)') ' **  Heading lines file ',
     &      TRIM(FILENM), ' **'                                           40.03
            DO 830 IH=1, NHEDF                                            30.72
              READ (NDSD, '(A80)') HEDLIN                                 30.72
              WRITE (PRINTF, '(A4,A80)') ' -> ', HEDLIN                   30.72
 830        CONTINUE                                                      30.72
          ENDIF                                                           40.00
        ENDIF                                                             30.72
        GO TO 11
      ENDIF
C
C     error message when end of file is encountered
C
 911  INQUIRE (UNIT=NDSD, NAME=FILENM)
	print*,"Here",ix,iy,mxa,mya,ndsl
      CALL MSGERR (2, 'Unexpected end of file while reading '//FILENM)    40.00
      NDSD = 0                                                            40.00
      IDLA = -1
C     Value of IDLA=-1 signals end of file to calling program
C
      GOTO 900
C
 920  INQUIRE (UNIT=NDSD, NAME=FILENM)                                    30.82
	print*,"Error is",ierr
      CALL MSGERR (2, 'Error while reading file '//FILENM)                40.00
      WRITE (PRINTF, 922) IERR                                            40.02
 922  FORMAT (' i/o status ', I6)                                         40.00
      IDLA = -2                                                           40.00
C     Value of IDLA=-2 signals read error to calling program
C
C     Multiply all values in the array by VFAC
C
 900  DO 909 IY = 1, MYA                                                  30.72
        DO 908 IX = 1, MXA
          ARR(IX,IY) = ARR(IX,IY) * VFAC
 908    CONTINUE                                                          30.72
 909  CONTINUE                                                            30.72
*
 990  IF (ITEST.GE.100 .OR. IDLA.LT.0) THEN
        DO 996 IY=MYA, 1, -1
          WRITE (PRINTF, 994) (ARR(IX,IY), IX=1,MXA)
 994      FORMAT ((1X, 10E12.4))
 996    CONTINUE
      ENDIF
      RETURN
 
!     No more files in NDSL:
 930  INQUIRE (UNIT=NDSL, NAME=FILENM)                                    40.13
      CALL MSGERR (2, 'Series of input files ended in '//FILENM)          40.13
      RETURN                                                              40.13
 
      END subroutine INAR2D
******************************************************************
*                                                                *
      SUBROUTINE STRACE (IENT, SUBNAM)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
 
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C     This subroutine produces depending on the value of 'ITRACE'
C     a message containing the name 'SUBNAM'. the purpose of this
C     action is to detect the entry of a subroutine.
C
C  3. METHOD
C
C     the first executable statement of subroutine 'AAA' has to
C     be : CALL STRACE(IENT,'AAA')
C     further is necessary : DATA IENT/0/
C     IF ITRACE=0, no message
C     IF ITRACE>0, a message is printed up to ITRACE times
C
C  4. ARGUMENT VARIABLES
C
C     IENT   :  i/o    Number of entries into the calling subroutine
C
      INTEGER IENT
C
C     SUBNAM :  inp    name of the calling subroutine.
C
      CHARACTER SUBNAM *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C                                                                         NRL
!$    LOGICAL,EXTERNAL :: OMP_IN_PARALLEL                                 NRL
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      IF (ITRACE.EQ.0) RETURN
      IF (IENT.GT.ITRACE) RETURN
!$    IF (OMP_IN_PARALLEL()) THEN                                         NRL
!$OMP MASTER                                                              NRL
!$      IENT=IENT+1                                                       NRL
!$      WRITE (PRTEST, 10) SUBNAM                                         NRL
!$      IF (SCREEN.NE.PRINTF) WRITE (SCREEN, 10) SUBNAM                   NRL
!$OMP END MASTER                                                          NRL
!$    ELSE                                                                NRL
        IENT=IENT+1                                                       NRL
        WRITE (PRTEST, 10) SUBNAM                                         NRL
        IF (SCREEN.NE.PRINTF) WRITE (SCREEN, 10) SUBNAM                   NRL
!$    ENDIF                                                               NRL
  10    FORMAT (' ++ trace subr: ',A)
      RETURN
*  *  END OF SUBR. STRACE  *
      END
******************************************************************
*                                                                *
      SUBROUTINE MSGERR (LEV,STRING)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
C
C  1. UPDATES
C
C     40.03, Aug. 00: variable ERRFNM introduced in order to get correct
C                     message on UNIX system
C     40.02, Sep. 00: Removed STOP statement
c
C  2. PURPOSE
C
C     Error messages are produced by subroutine MSGERR. if necessary
C     the value of LEVERR is increased.
C     In case of a high error level an error message file is opened
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     LEV    : indicates how severe the present error is
C     STRING : contents of the present error message
C
      INTEGER   LEV
C
      CHARACTER STRING*(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IERR   : if non-zero error message file was already opened unsuccessfully
C     IERRF  : unit reference number of the error message file
C
      INTEGER, SAVE :: IERR=0, IERRF=0                                    40.03
C
C     ERRM   : error message prefix
C
      CHARACTER (LEN=17) :: ERRM                                          40.03
C
C     ERRFNM : name of error message file
C
      CHARACTER (LEN=LENFNM), SAVE :: ERRFNM = 'Errfile'                  NRL 40.03
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     ---
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
C
      IF (LEV.GT.LEVERR) LEVERR=LEV
      IF (LEV.EQ.0) THEN
        ERRM = 'Message          '
      ELSE IF (LEV.EQ.1) THEN
        ERRM = 'Warning          '
      ELSE IF (LEV.EQ.2) THEN
        ERRM = 'Error            '
      ELSE IF (LEV.EQ.3) THEN
        ERRM = 'Severe error     '
      ELSE
        ERRM = 'Terminating error'
      ENDIF
      WRITE (PRINTF,12) ERRM, STRING
  12  FORMAT (' ** ', A, ': ',A)
      IF (LEV.GT.MAXERR) THEN
        IF (IERRF.EQ.0) THEN
          IF (IERR.NE.0) RETURN
          CALL FOR (IERRF, ERRFNM, 'UF', IERR)                            40.03
        ENDIF
        WRITE (IERRF,14) ERRM, STRING
  14    FORMAT (A, ': ',A)
      ENDIF
C
      RETURN
C
      END SUBROUTINE MSGERR
C
******************************************************************
*                                                                *
      LOGICAL FUNCTION STPNOW()                                             30.82
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.82, Feb. 99: IJsbrand Haagsma
C
C  1. Updates
C
C     30.82: New function
C
C  2. Purpose
C
C     Function determines wheter the SWAN program should be stopped
C     due to a terminating error
C
C  3. Method
C
C     Compares two common variables (the maximum allowable error-level,
C     MAXERR and the actual error-level: LEVERR).
C
C  4. ARGUMENT VARIABLES
C
C  5. PARAMETER VARIABLES
C
C  6. Local variables
C
C     IENT  : Number of entries into this subroutine
C
      INTEGER IENT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE  IENT
      DATA  IENT /0/
      CALL  STRACE (IENT,'STPNOW')
C
      IF (LEVERR .GE. 4) THEN
        STPNOW = .TRUE.
      ELSE
        STPNOW = .FALSE.
      END IF
      IF (MAXERR.EQ.-1) STPNOW = .FALSE.
C
      RETURN
C
      END
******************************************************************
*                                                                *
      SUBROUTINE TABHED (PROGNM, LPR)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     40.13: Nico Booij
C
C  1. UPDATES
C
C     40.13, Jan. 01: VERTXT replaces VERNUM
C
C  2. PURPOSE
C
C     prints the table heading, containing:
C     run description, 3 lines
C     name of institute, program name,
C     project name, run id.
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     LPR    : input    unit ref. nr. for output
C
      INTEGER LPR
C
C     PROGNM : input    program name
C
      CHARACTER PROGNM *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      WRITE (LPR, 10) PROJT1, INST
      WRITE (LPR, 20) PROJT2, PROGNM, VERTXT                              40.13
      WRITE (LPR, 30) PROJT3, PROJID, PROJNR
      WRITE (LPR, 40)
  10  FORMAT ('1', A72, ' | ', A40)
  20  FORMAT (1X,  A72, ' | ', A, '  version: ', A)                       40.13
  30  FORMAT (1X,  A72, ' | ', A16, 1X, A4)
  40  FORMAT (' --------------------------------------------------',
     &  '---------------------------------------------------------')
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE FOR (IUNIT, DDNAME, SF, IOSTAT)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.13: Nico Booij
C     30.70: Nico Booij
C     30.82: IJsbrand Haagsma
C     34.01: IJsbrand Haagsma
C     40.00, 40.03: Nico Booij
C
C  1. Updates
C
C     30.13, Jan. 96: new structure
C     30.70, Feb. 98: terminating error if input file does not exist
C     30.82, Nov. 98: Introduced recordlength of 1000 for new files to
C                     avoid errors on the Cray-J90
C     34.01, Feb. 99: STOP statement removed
C     40.00, Feb. 99: DIRCH2 replaces DIRCH1 in filenames
C     40.03, May  00: modification for Linux: local copy of filename
C
C  1. PURPOSE
C
C     General open file routine.
C
C  2. METHOD
C
C     FORTRAN 77 OPEN option.
C                INQUIRE
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C       IUNIT   int     input   =0 : get free unit number
C                               >0 : fixed unit number
C                       output  allocated unit number
C       DDNAME  char    input   ddname/filename string (empty if IUNIT>0)
C       SF      char*2  input   file qualifiers
C                               1st char: O(ld),N(ew),S(cratch),U(nknown)
C                               2nd char: F(ormatted),U(nformatted)
C       IOSTAT  int     input   0 : Full messages printed
C                               -1: Only error messages printed
C                               -2: No messages printed
C                       output  error indicator
C
      INTEGER   IUNIT, IOSTAT
      CHARACTER DDNAME*(LENFNM), SF*2                                     40.03
C
C  5. PARAMETER VAR. (CONSTANTS)
C
C     Error codes:
C
C       IOSTAT = IESUCC No errors
C       IOSTAT > 0      I/O error
C       IOSTAT = IENUNF No free unit number found
C       IOSTAT = IEUNBD Specified unit number out of bounds
C       IOSTAT = IENODD No filename supplied with IUNIT=0
C       IOSTAT = IEDDNM Incorrect filename supplied with IUNIT>0
C       IOSTAT = IEEXST Specified unit number does not exist
C       IOSTAT = IEOPEN Specified unit number already opened
C       IOSTAT = IESTAT Error in file qualifiers
C       IOSTAT = IENSCR Named scratch file
C       IOSTAT = IENSIO No specified I/O error
C
      INTEGER  IESUCC, IENUNF, IEUNBD, IENODD,
     &         IEDDNM, IEEXST, IEOPEN, IESTAT, IENSCR
      PARAMETER (IESUCC=  0,IENUNF= -1,IEUNBD= -2,IENODD= -3,
     &           IEDDNM= -4,IEEXST= -5,IEOPEN= -6,IESTAT= -7,
     &           IENSCR=-12)
C
C     EMPTY    blank string
C
      CHARACTER  EMPTY*(*)
      PARAMETER (EMPTY= '        ')
C
C  6. LOCAL VARIABLES
C
C     IENT      number of entries into this subroutine
C     IFO       format index
C     IFUN      free unit number
C     II        counter
C     IOSTTM    aux. error index
C     IS        file status index
C     IUTTM     aux. unit number
C
      INTEGER   IENT, IFO, IFUN, II, IOSTTM, IS, IUTTM
C
C     EXIST     if true, file exists
C     OPENED    if true, file is opened
C
      LOGICAL   EXIST, OPENED
C
C     S
C     F
C     FILTTM   auxiliary
C     FISTAT   file status, values: OLD, NEW, UNKNOWN
C     FORM     formatting, values: FORMATTED, UNFORMATTED
C     DDNAME_L local copy of DDNAME                                       40.03
C
      CHARACTER S, F, FILTTM *(LENFNM), DDNAME_L *(LENFNM)                40.03
      CHARACTER *11 FISTAT(4),FORM(2)
C
C  4. SUBROUTINES USED
C
C
C  5. ERROR MESSAGES
C
C       and error messages added using MSGERR
C
C
C  6. REMARKS
C
C       Free unit number search interval: FUNLO<=IUNIT<=FUNHI
C       FUNLO, FUNHI, IUNMIN and IUNMAX were initialized by OCPINI,
C       they are transmitted via common /REFNRS/
C
C  7. STRUCTURE
C
C       ----------------------------------------------------------------
C       Check file qualifiers
C       ----------------------------------------------------------------
C       If IUNIT = 0
C       Then If DDNAME = ' '
C            Then error message
C            Else Inquire to find if file exists and is opened,
C                 and if so, to find correct unit number
C                 If file is not opened
C                 Then get a free unit number, assign value to IUNIT
C                      open the file
C                 Else assign correct unit number to IUNIT
C       Else Inquire to find if file exists and is opened,
C                   and if so, to find correct filename
C            If file with unit nr IUNIT is already open
C            Then If filename does not correspond to DDNAME
C                 Then Close file with old filename and unit IUNIT
C                      Open file with new filename DDNAME and unit IUNIT
C            Else If DDNAME is not empty
C                 Then Open file with new filename DDNAME and unit IUNIT
C                 Else Open file with unit IUNIT
C       ----------------------------------------------------------------
C
C  8. SOURCE TEXT
C
      SAVE      IENT, IFUN
*
      DATA FISTAT(1),FISTAT(2) / 'OLD','NEW'/
     1     FISTAT(3),FISTAT(4) / 'SCRATCH','UNKNOWN'/
     2     FORM(1),FORM(2) / 'FORMATTED','UNFORMATTED'/
*
      DATA IENT /0/, IFUN /0/
      CALL STRACE (IENT, 'FOR')
*
      IF (ITEST.GE.80) WRITE (PRTEST, 2) IUNIT, DDNAME, SF, IOSTAT
   2  FORMAT (' Entry FOR: ', I3, 1X, A36, A2, I7)
      DDNAME_L = DDNAME                                                   40.03
*
*     check file qualifiers
*
      IF ((IUNIT.NE.0) .AND.
     &   ((IUNIT .LT. IUNMIN) .OR. (IUNIT .GT. IUNMAX))) THEN
        IF (IOSTAT.GT.-2) CALL MSGERR (3, 'Unit number out of range')
        IOSTAT= IEUNBD
        RETURN
      END IF
*
      S   = SF(1:1)
      F   = SF(2:2)
      IS  = INDEX('ONSU',S)
      IFO = INDEX('FU',F)
      IF ((IS .EQ. 0) .OR. (IFO .EQ. 0)) THEN
        IF (IOSTAT.GT.-2) CALL MSGERR (3,'Error in file qualifiers')
        IOSTAT= IESTAT
        RETURN
      END IF
*
      IF ((S.EQ.'S').AND.(DDNAME.NE.EMPTY)) THEN
        IF (IOSTAT.GT.-2) CALL MSGERR (3, 'Named scratch file')
        IOSTAT= IENSCR
        RETURN
      END IF
*
      IF (DDNAME.NE.EMPTY) THEN                                           40.00
*       directory separation character is replaced in filenames           40.00
        DO II = 1, LEN(DDNAME)
          IF (DDNAME(II:II).EQ.DIRCH1) DDNAME(II:II) = DIRCH2             40.00
        ENDDO
      ENDIF
*
      IF (IUNIT .EQ. 0) THEN
         IF (DDNAME.EQ.EMPTY) THEN
            IF (IOSTAT.GT.-1) CALL MSGERR (3, 'No filename given')
            IOSTAT= IENODD
            RETURN
         ELSE
*           Was the file opened already ?
            INQUIRE (FILE=DDNAME, IOSTAT=IOSTTM, EXIST=EXIST,
     &      OPENED=OPENED, NUMBER=IUTTM)
            IF (IOSTTM .NE. IESUCC) THEN
               IF (IOSTAT.GT.-1) CALL MSGERR (2,
     &               'Inquire failed, filename: '//DDNAME_L)              40.03
               IOSTAT = IOSTTM
               RETURN
            ENDIF
*           If file does not exist, print term. error
            IF (IS.EQ.1 .AND. .NOT. EXIST) THEN                           30.70
               CALL MSGERR (4,
     &         'File cannot be opened/does not exist: '//DDNAME_L)        40.03
               IOSTAT = IEEXST
            END IF
            IF (OPENED) THEN
               IF (IOSTAT.GT.-1)
     &         CALL MSGERR (2, 'File is already opened: '//DDNAME_L)      40.03
               IOSTAT = IEOPEN
               IUNIT = IUTTM
               RETURN
            ENDIF
*           Assign free unit number
            IF (IFUN.EQ.0) THEN
               IFUN = FUNLO
            ELSE
               IFUN = IFUN + 1
            ENDIF
            IUNIT = IFUN
            IF (IUNIT .GT. FUNHI) THEN
               IF (IOSTAT.GT.-2) CALL MSGERR (3, 'All free units used')
               IOSTAT= IENUNF
            ENDIF
         END IF
         OPEN (UNIT=IUNIT,ERR=999,IOSTAT=IOSTTM,FILE=DDNAME,              30.82
C/Cray     &         RECL=1000,                                                 30.82
C/SGI     &         RECL=1000,                                                 30.82
     &         STATUS=FISTAT(IS),ACCESS='SEQUENTIAL',FORM=FORM(IFO))      30.82
      ELSE
         INQUIRE (UNIT=IUNIT, NAME=FILTTM, IOSTAT=IOSTTM,
     &            EXIST=EXIST, OPENED=OPENED)
         IF (IOSTTM .NE. IESUCC) THEN
            IF (IOSTAT.GT.-1) CALL MSGERR (2,
     &            'Inquire failed, filename: '//FILTTM)
            IOSTAT = IOSTTM
            RETURN
         ENDIF
         IF (OPENED) THEN
            IF (IOSTAT.GT.-1) THEN
              CALL MSGERR (1,
     &                   'File is already opened, filename: '//FILTTM)
            ENDIF
            IF (FILTTM.NE.DDNAME .AND. FILTTM.NE.EMPTY) THEN
              IF (IOSTAT.GT.-2) THEN
                WRITE (PRINTF, '(A, I4, 6A)') ' unit', IUNIT,
     &                 ' filenames: ', FILTTM, ' and: ', DDNAME
                CALL MSGERR (2, 'filename and unit number inconsistent')
              ENDIF
              IOSTAT = IEDDNM
*             close old file and open new one with given filename
              CLOSE (IUNIT)
              OPEN (UNIT=IUNIT,ERR=999,IOSTAT=IOSTTM,STATUS=FISTAT(IS),
C/Cray     &         RECL=1000,                                                 30.82
C/SGI     &         RECL=1000,                                                 30.82
     &              FILE=DDNAME,ACCESS='SEQUENTIAL',FORM=FORM(IFO))
              IF (IOSTTM.NE.IESUCC) IOSTAT = IOSTTM
              GOTO 80
            ENDIF
            IOSTAT = IEOPEN
            RETURN
         END IF
         IF (DDNAME.NE.EMPTY) THEN
            OPEN (UNIT=IUNIT,ERR=999,IOSTAT=IOSTTM,STATUS=FISTAT(IS),
C/Cray     &         RECL=1000,                                                 30.82
C/SGI     &         RECL=1000,                                                 30.82
     &      FILE=DDNAME,ACCESS='SEQUENTIAL',FORM=FORM(IFO))
         ELSE
            OPEN (UNIT=IUNIT,ERR=999,IOSTAT=IOSTTM,STATUS=FISTAT(IS),
C/Cray     &         RECL=1000,                                                 30.82
C/SGI     &         RECL=1000,                                                 30.82
     &      ACCESS='SEQUENTIAL',FORM=FORM(IFO))
         END IF
      END IF
      HIOPEN = IFUN
  80  IF (ITEST.GE.30) WRITE (PRINTF, 82) IUNIT, DDNAME, SF
  82  FORMAT (' File opened: ', I6, 2X, A36, 2X, A2)
      RETURN
*
*     in case file cannot be opened:
*
 999  IF (IOSTAT.GT.-2) THEN
        CALL MSGERR (3, 'File open failed, filename: '//DDNAME_L)         40.03
        WRITE (PRINTF,15) DDNAME, IOSTTM, SF
  15    FORMAT (' File -> ', A36, 2X, ' IOSTAT=', I6, 4X, A2)
      ENDIF
      IUNIT = -1
      IOSTAT= IOSTTM
      RETURN
*  *  end of subroutine  FOR  *
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION EQREAL (REAL1, REAL2 )                             30.72
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C  0. Authors
C
C     30.72 IJsbrand Haagsma
C     30.60 Nico Booij
C     40.04 Annette Kieftenburg
C
C  1. Updates
C
C     30.72, Oct. 97: Changed from EXCYES to make floating point point comparisons
C     30.60, July 97: new subroutine (EXCYES)
C     40.04, Aug. 00: introduced EPSILON and TINY
C
C  2. Purpose
C
C     to determine whether a value (usually a value read from file)
C     is an exception value or not
C     Later (30.72) used to make comparisons of floating points within reasonable bounds
C
C  3. Method (updated...)
C
C     Checks whether ABS(REAL1-REAL2) .LE. TINY(REAL1) or whether this        40.04
C     difference is .LE. then EPS (= EPSILON(REAL1)*ABS(REAL1-REAL2) )        40.04
C
C  4. Argument variables
C
C     REAL1  : input    value that is to be tested
C     REAL2  : input    given exception value
C
      REAL      REAL1, REAL2
C
C  5. Parameter variables
C
C  6. Local variables
C
C     EPS    : Small number (related to REAL1 and its difference with REAL2)
C     IENT   : Number of entries into this subroutine
C
      REAL      EPS
      INTEGER   IENT
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SWREAD
C     SWDIM
C     SIRAY
C     SWBOUN
C     SWODDC
C     SWOEXD
C     SWOEXA
C     SWOEXF
C     SWPLOT
C     SWSPEC
C     ISOLIN
C     SNYPT2
C     INCTIM
C     INDBLE
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'EQREAL')
      EQREAL = .FALSE.
C
      EPS = EPSILON(REAL1)*ABS(REAL1-REAL2)                                  40.04
      IF (EPS ==0) EPS = TINY(REAL1)                                         40.04
      IF (ABS(REAL1-REAL2) .GT. TINY(REAL1)) THEN                            40.04
        IF (ABS(REAL1-REAL2) .LT. EPS) EQREAL = .TRUE.                       40.04
      ELSE                                                                   40.04
        EQREAL = .TRUE.                                                      40.04
      ENDIF                                                                  40.04
      RETURN
C     end of subroutine EQREAL
      END
********************************************************************
*                                                                  *
      SUBROUTINE LSPLIT(RELINE, DATITM, NUMITM)
*                                                                  *
********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     40.00, 40.03: Nico Booij
C
C  1. UPDATES
C
C     40.00, Jan. 98: New subroutine for SWAN
C     40.03, Jun. 00: declaration updated, TRIM added for readability
C                     test output added
C
C  2. PURPOSE
C
C     a line read from a file is separated into single data items
C     each data item is found in a string DATITM
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     NUMITM : input    max number of data items in array
C
      INTEGER, INTENT(IN) :: NUMITM                                        40.03
C
C     DATITM : output   array of data items
C     RELINE : input    string (read from an input file)
C
      CHARACTER (LEN=*), INTENT(OUT) :: DATITM(NUMITM)                     40.03
      CHARACTER (LEN=*), INTENT(IN) ::  RELINE                             40.03
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     CRL    : a character of the input line RELINE
C     QUOTE  : ' i.e. string delimiter
C
      CHARACTER QUOTE *1, CRL *1
C
C     ICR1   : ??
C     IENT   : Number of entries into this subroutine
C     ILL    : sequence number of character being processed
C     IITM   : counter of data items
C     LENLIN : lenght of an input line
C     RITM   : type of data, 0: empty string, 2: string enclosed
C              in quotes, 1: other
C
      INTEGER   ICR1, IENT, ILL, IITM, LENLIN, RITM
C
C     LCHSTR : if True, program is reading a string (enclosed in quotes)
C
      LOGICAL   LCHSTR
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C     ------
C
C  9. SUBROUTINES CALLING
C
C     SWBOUN
C
C 10. ERROR MESSAGES
C
C     Too many data items on input line
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE      IENT, QUOTE
      DATA      IENT /0/, QUOTE /''''/
      CALL STRACE (IENT, 'LSPLIT')
C
      LENLIN = LEN(RELINE)
      LCHSTR = .FALSE.
      DO IITM = 1, NUMITM
        DATITM(IITM) = '    '
      ENDDO
      IF (ITEST.GE.150) WRITE (PRTEST,*) ' test LSPLIT ', RELINE
C
C     free format: separate the line into data items
C     blanks and commas serve as separation between data items
C     DATITM is string containing one data item
C
      IITM = 0
      RITM = 0
      DO 170 ILL = 1, LENLIN
         CRL = RELINE(ILL:ILL)
         IF (LCHSTR) THEN
C           reading a character string enclosed in quotes
            IF (CRL.EQ.QUOTE) THEN
C              closing quote
               LCHSTR = .FALSE.
               RITM   = 2
               IF (IITM.GT.NUMITM) THEN
                 CALL MSGERR (2, 'too many items on input line')
                 WRITE (PRINTF, *) ' -> ', TRIM(RELINE)
               ENDIF
               DATITM(IITM) = RELINE (ICR1:ILL-1)
            ENDIF
         ELSE
            IF (CRL.EQ.',') THEN
               IF (RITM.EQ.0) THEN
C                 empty item
                  IITM = IITM + 1
                  IF (IITM.GT.NUMITM) THEN
                    CALL MSGERR (2, 'too many items on input line')
                    WRITE (PRINTF, *) ' -> ', TRIM(RELINE)                40.03
                  ENDIF
                  DATITM(IITM) = '    '
               ELSE
                  IF (RITM.EQ.1) DATITM(IITM) = RELINE(ICR1:ILL)
                  RITM = 0
               ENDIF
            ELSE IF (CRL.EQ.' ' .OR. CRL.EQ.TABC) THEN
               IF (RITM.EQ.1) THEN
                  IF (IITM.GT.NUMITM) THEN
                    CALL MSGERR (2, 'too many items on input line')
                    WRITE (PRINTF, *) ' -> ', TRIM(RELINE)                40.03
                  ENDIF
                  DATITM(IITM) = RELINE(ICR1:ILL)
                  RITM = 2
               ENDIF
            ELSE
               IF (RITM.NE.1) THEN
                  IITM = IITM + 1
                  IF (IITM.GT.NUMITM) THEN
                    CALL MSGERR (2, 'too many items on input line')
                    WRITE (PRINTF, *) ' -> ', TRIM(RELINE)                40.03
                  ENDIF
                  IF (CRL.EQ.QUOTE) THEN
                     ICR1 = ILL+1
                     LCHSTR = .TRUE.
                  ELSE
                     ICR1 = ILL
                     RITM = 1
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
         IF (ITEST.GE.250) WRITE (PRTEST, 165) CRL, RITM,
     &                IITM, ICR1
 165     FORMAT (' test LSPLIT ', A1, 3I3, 2X, A20)
 170  CONTINUE
      IF (ITEST.GE.130) THEN                                              40.03
        DO IITM = 1, NUMITM
          WRITE (PRTEST, 810) IITM, DATITM(IITM)
 810      FORMAT (' LSPLIT data item ', I2, ' is: ', A)
        ENDDO
      ENDIF
      RETURN
      END
************************************************************************
*                                                                      *
      SUBROUTINE BUGFIX (FIXABC)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm2.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.03  Nico Booij
C
C  1. UPDATE
C
C     40.03, May  00: new subroutine
C
C  2. PURPOSE
C
C     Adding one character to the version character string
C
C  3. METHOD
C
C
C  4. Argument variables
C
C       FIXABC  char   input    character indicating a bugfix
 
      CHARACTER (LEN=1), INTENT(IN) :: FIXABC
C
C  5. Parameter variables
C
C  6. Local variables
C
C       IC      counter of characters
C
      INTEGER   IC
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       for characters in VERTXT starting at end, do
C           if character is not blank
C           then replace previous character by FIXABC
C       ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE      IENT
      DATA      IENT/0/
      CALL STRACE (IENT, 'BUGFIX')
C
      DO IC = LEN(VERTXT), 1, -1
        IF (VERTXT(IC:IC) .NE. ' ') THEN
          VERTXT(IC+1:IC+1) = FIXABC
          GOTO 80
        ENDIF
      ENDDO
  80  RETURN
*     end of subroutine BUGFIX
      END
