!NRL: $Id: swancom2.F,v 1.2.2.1 2003/03/31 18:49:16 campbell Exp $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000   11:37 am
C
C     SWAN/COMPU      file 2 of 6
C
C     PROGRAM SWANCOM2.FOR
C
C     This file SWANCOM2 of the main program SWAN
C     include the next subroutines (mainly subroutines for
C     the source terms for dissipation and some general stuff ) :
C
C     DISSIPATION SOURCE TERMS :
C
C     SBOT    (Bottom friction )
C     FRABRE  (Fraction of breaking waves)
C     SSURF   (Wave breaking: Battjes and Janssen (1978) )
C     SWCAP   (White capping: five formulations )                         40.02
C     BRKPAR  (wave breaking criterion according to Nelson (1987)
C     CNTAIL  (contributions to the spectrum of the high frequency tail)
C     PLTSRC  (store the values for plot of the source terms and spec.)
C
C****************************************************************
C
      SUBROUTINE SBOT (MDC     ,MSC     ,ICMAX   ,ICUR    ,IBOT    ,
     &                 GRAV    ,ABRBOT  ,DEP2    ,ECOS    ,ESIN    ,
     &                 IMATDA  ,KWAVE   ,SPCSIG  ,UBOT    ,UX2     ,      30.72
     &                 UY2     ,PBOT    ,MBOT    ,IDCMIN  ,IDCMAX  ,
     &                 PLBTFR  ,ISSTOP  ,DISSC1  ,VARFR   , FRCOEF ,
     &                 KCGRD   ,MCGRD
     &                              )
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     20.68: Nico Booij
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     20.68, Jan. 96: subroutine restructured variable friction coefficient
C                     introduced Putnam model replaced by Collins
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     Computation of the source terms due to bottom friction
C
C  3. Method
C
C     In SWAN several bottom dissipation models are computed, i.e.:
C
C     IBOT = 1   Jonswap bottom friction model
C     IBOT = 2   Collins bottom friction model
C     IBOT = 3   Madsen bottom friction model (see Tolman)
C
C     Both methods are implemented in SWAN and the user has to make
C     a choice in the input file.
C
C     1. Jonswap model:
C     -----------------
C
C     The bottom interaction term SEbf(s,d) is supposed to take the
C     Jonswap form (Hasselman et al. 1973):
C                         2
C                    sigma  E(s,d)
C     SEbf = -GAMMA ----------------
C                         2     2
C                        g  sinh  (kD)
C                                                                 2 -3
C     where GAMMA is the decay parameter ,(default GAMMA = 0.067 M s  ).
C     In the Jonswap form the current velocities are not taken into
C     account.
C
C     2. COLLINS model:
C     -----------------
C
C     The energy dissipation due to bottom friction is modelled
C     according the quadratic friction law:
C                    2
C      SE = Tau * |U|
C
C      which for a spectrum can be written as:
C                          2
C                     sigma
C      SE(s,d)= - ---------------- * (Cfw.Ub + Cfc.Uc) * E(s,d)
C                       2
C                 g sinh (K(s) * D)
C
C     Ub is the velocity due to the wave at the bottom
C
C     The current velocity is Uc
C
C     2. MADSEN formulation:
C     ----------------------
C
C     The bottom dissipation aplying Madsen formulation is as
C     follows:
C
C                          fw [n - 1/2] UBR E(s,d)
C     [1]    Sdsb(s,d) = -  ------------------------
C                                      D
C
C     in which :
C                            2
C                           s * D
C     [1a]   (n - 1/2) = -------------
C                                2
C                        2 g sinh (kD)
C
C     UBOT(IX,IY) is computed in the subroutine SDISPA. The friction
C     factor fw is estimated using the formulation of Jonsson (1963,
C     1966a):
C
C                1                1                        Ab,r
C     [2]     -------- + log  { ---------- } = mf + log  { ----- }
C            4 sqrt(fw)     10  4 sqrt(fw)             10   Kn
C
C     with:
C
C               2        //      1
C     [3]   Ab,r  = 2 * // -------------- E(s,d) ds dd
C                      //      2
C                          sinh (kD)
C
C     with: Ab,r is the representative near bottom excursion
C                amplitude
C           Kn   equivalent roughness
C           mf   constant ( mf = -0.08) (determined by Jonsson
C                                        and Carlssen 1976 )
C
C     [2] is only valid for Ab,r/Kn larger than approximately 1.
C     For smaller values a constant value of fw is used (fw = 0.3
C     for Ab,r/Kn < 1.57 )
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     INTEGERS :
C     --------
C
C     IX          Counter of gridpoints in x-direction
C     IY          Counter of gridpoints in y-direction
C     IS          Counter of relative frequency band
C     ID          Counter of the spectral direction
C     IBOT        Indicator if bottomfriction is on
C     ICUR        Indicator if a current is present
C     ICMAX       Maximum counter for the points of the molecul
C     ITER        Number of iteration i.e. number of full sweeps
C     MBOT        Maximum array size for the array PBOT
C     MXC         Maximum counter of gridppoints in x-direction
C     MYC         Maximum counter of gridppoints in y-direction
C     MSC         Maximum counter of relative frequency
C     MDC         Maximum counter of directional distribution
C     ISSTOP      Maximum counter of wave component in frequency
C                 space that is propagated
C
C     REALS:
C     ---------
C
C     ABRBOT      Near bottom excursion amplitude
C     DD          Spectral direction band width
C     DS          Width of the frequency band
C     FW          Friction factor
C     GRAV        Gravitational acceleration
C     KD          Wavenumber * Depth
C     SBOTEO      Sourceterm for the bottomfriction to be stored
C                 in the array IMATDA
C     CURR        Main current velocity
C     UC          Absolute value of the current
C
C     one and more dimensional arrays:
C     ---------------------------------
C
C     DEP2      2D    Depth
C     ESIN      1D    Sin per spectral direction (id)
C     ECOS      1D    Cos per spectral direction (id)
C     IMATDA    2D    Coefficients of diagonal of matrix
C     KWAVE     2D    Wavenumber function of frequency and IC
C     PBOT      1D    Coefficient for bottomfriction models
C     UBOT      2D    Near bottom velocity as function of X,Y
C     UX2       2D    Current velocity in y direction as function of X,Y
C     UY2       2D    Current velocity in y direction as function of X,Y
C     DISSC1    2D    Dissipation coefficient, fun of sigma and theta
C     FRCOEF    2D    Spatially variable friction coefficient             20.68
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SOURCE
C
C 10. Error Messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ------------------------------------------------------------
C     Compute CFBOT according to friction model
C     For every spectral frequency do
C         compute SBOTEO = CFBOT * (sigma/sinh(kd))**2
C         For every spectral direction do
C             add SBOTEO to matrix (IMATDA)
C     -------------------------------------------------------------
C
C 13. Source text
C
      INTEGER  ICUR   ,IBOT   ,ID     ,MDC    ,IS     ,
     &         MSC    ,ICMAX  ,MBOT   ,ISSTOP ,MCGRD                      30.21
*
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     XDUM   ,GRAV   ,KD     ,SBOTEO ,CFBOT  ,
     &         CFW    ,FW     ,CURR   ,UC     ,ABRBOT ,
     &         ADUM   ,CDUM   ,DDUM
*
      LOGICAL  VARFR
*
      REAL     DEP2(MCGRD)               ,
     &         ECOS(MDC)                 ,
     &         ESIN(MDC)                 ,
     &         IMATDA(MDC,MSC)           ,
     &         KWAVE(MSC,ICMAX)          ,
     &         PBOT(MBOT)                ,
     &         PLBTFR(MDC,MSC,NPTST)     ,                                40.00
     &         UBOT(MCGRD)               ,
     &         UX2(MCGRD)                ,
     &         UY2(MCGRD)                ,
     &         DISSC1(MDC,MSC)           ,
     &         FRCOEF(MCGRD)                                              20.68
C
      INTEGER  IDCMIN(MSC)                  ,
     &         IDCMAX(MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SBOT')
*
      IF ( IBOT .GE. 1 .AND. DEP2(KCGRD(1)) .GT. 0.) THEN
        IF (IBOT.EQ.1) THEN
*
*         *** Jonswap model ***
*
*         PBOT(3) = GAMMA (a) in the Jonswap equation,
*
          CFBOT = PBOT(3) / GRAV**2
        ELSE IF (IBOT.EQ.2) THEN
*
*         *** Collins model ***
*
*         PBOT(2) = [cfw]
*
          IF (VARFR) THEN                                                 20.68
            CFW = FRCOEF(KCGRD(1))
          ELSE
            CFW = PBOT(2)
          ENDIF
          CFBOT = CFW * UBOT(KCGRD(1)) / GRAV
        ELSE IF (IBOT.EQ.3) THEN
*
*             *** Madsen model ***
*
          IF (VARFR) THEN                                                 20.68
            AKN = FRCOEF(KCGRD(1))
          ELSE
            AKN = PBOT(5)
          ENDIF
*
*           *** PBOT(4) = Mf                      ***
*           *** AKN = PBOT(5) = [kn]  (roughness) ***
*
          IF ( (ABRBOT / AKN ) .GT. 1.57 ) THEN
            XDUM = PBOT(4) + LOG10 ( ABRBOT / AKN )
*
*               *** solving the implicit equation using a Newton ***
*               *** Rapshon iteration proces : a + log a = b     ***
*               *** the start value for ADUM = 0.3 because 0.3626 ***
*               *** is the minimum value of ADUM with b=-0.08.    ***
*
            ADUM = 0.3
            DO 28 J = 1, 50
              CDUM  = ADUM
              DDUM  = ( ADUM + LOG10(ADUM) - XDUM ) /
     &                                          ( 1.+ ( 1. / ADUM) )
              ADUM  = ADUM - DDUM
              IF ( ABS(CDUM - ADUM) .LT. 1.E-4 ) GOTO 29
  28        CONTINUE
            WRITE(*,*) ' error in iteration fw: Madsen formulation'
  29        CONTINUE
*                                                 1               1
*               *** computation of FW -->  A = ----- --> FW = -----
*                                              4 uFW          16 A**2
            FW = 1. / (16. * ADUM**2)
          ELSE
            FW = 0.3
          ENDIF
          CFBOT =  UBOT(KCGRD(1)) * FW / (SQRT(2.) * GRAV)
        ENDIF
*
*       *** test output ***
*
        IF (TESTFL .AND. ITEST.GE.60) THEN
          WRITE (PRTEST, 910) IBOT, KCGRD(1), DEP2(KCGRD(1)), CFBOT
 910      FORMAT (' SBOT :IBOT INDX DEP CFBOT:', 2I5, 2E12.4)
        END IF
*
        DO 700 IS = 1, ISSTOP
          KD      = KWAVE(IS,1) * DEP2(KCGRD(1))
          IF ( KD .LT. 10. ) THEN
            SBOTEO =  CFBOT * (SPCSIG(IS) / SINH(KD)) **2                 30.72
*
            DO 690 IDDUM = IDCMIN(IS) , IDCMAX(IS)
              ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
*
              IF (IBOT.EQ.2 .AND. ICUR.EQ.1 .AND. PBOT(1).GT.0.) THEN
*               additional dissipation due to current, seldom used
                CURR = UX2(KCGRD(1))*ECOS(ID) + UY2(KCGRD(1))*ESIN(ID)
                UC   = ABS(CURR)
*               PBOT(1) = [cfc]
                SBOTEO = SBOTEO + PBOT(1) * UC *
     &                         (SPCSIG(IS) / SINH(KD)) **2                30.72
              END IF
*
*             *** store the results in the array IMATDA             ***
*             *** if testfl store results in array for isoline plot ***
*
              IMATDA(ID,IS) = IMATDA(ID,IS) + SBOTEO
              IF (TESTFL) PLBTFR(ID,IS,IPTST) = -1.* SBOTEO               40.00
              DISSC1(ID,IS) = DISSC1(ID,IS) + SBOTEO
 690        CONTINUE
          END IF
 700    CONTINUE
*
      ENDIF
*
*     End of subroutine SBOT
      RETURN
      END
*
*
C****************************************************************
C
      SUBROUTINE FRABRE (HM    ,ETOT  ,QBLOC)
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     1. UPDATE
C
C        ---
C
C     2. PURPOSE
C
C        to compute the fraction of breaking waves in point ix,iy
C        of the computational grid
C
C     3. METHOD
C
C        The fraction of breaking waves in a point ix,iy is given by
C        the implicit relation:
C
C        1 - Qb        ETOT
C        ------ = -8 * -----
C        ln Qb         HM**2
C
C        from which Qb can be found by solving the equation:
C
C                         ETOT
C        F = 1 - Qb + 8 * ----  * ln(Qb) = 0.
C                           2
C                         HM
C
C        The following appproximation is applied (Dingemans 1983):
C
C                       2  1/2
C        b = ( 8 ETOT/HM  )
C
C                       2
C     |   Qo = ( 2b -1 )                          0.5 < b < 1
C  (4)|
C     |   Qo = 0.                                   b < 0.5
C
C     |   Qb = 0.                                   b < 0.3
C     |
C     |                                   2
C     |               2  Qo - exp((Qo-1)/b )
C  (5)|   Qb = Qo  - b   ------------------       0.3 < b < 0.9
C     |                   2               2
C     |                  b  - exp((Qo-1)/b )
C     |
C     |   Qb = Qo                                 0.9 < b < 1.0
C
C        The parameters ETOT and HM are determined in the subroutine
C        SDISPA
C
C     4. PARAMETERLIST
C
C        REALS:
C        ---------
C        B     Dummy variable
C        ETOT  Total energy per spatioal gridpoint
C        QO    First estiamte of the fraction of breaking waves
C        QBLOC Second iteration of the fraction of breaking waves
C        HM    Maximum wave height
C        Z     Dummy variable
C
C     5. SUBROUTINES CALLING
C
C        SDISPA
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   Read the total wave energy ETOT and the maximum waveheight HM
C     If HM > 0. and ETOT > 0., then
C       Compute factor b according to equation (3)
C     Else
C       b = 0
C     ------------------------------------------------------------
C     Compute first estimate Qo according to equation (4)
C     Compute Qb according to equation (5)
C   ------------------------------------------------------------
C   End of FRABRE
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      REAL     HM    ,ETOT  ,B     ,QO    ,Z     ,QBLOC
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'FRABRE')
C
      IF ( (HM .GT. 0.) .AND. (ETOT .GE. 0.) ) THEN
        B = SQRT(8. * ETOT / (HM*HM) )
      ELSE
        B = 0.0
      END IF
C
      IF ( B .LE. 0.5 ) THEN
        QO = 0.
      ELSE IF ( B .LE. 1.0 ) THEN
        QO = (2.*B - 1.)**2
      END IF
C
      IF ( B .LE. 0.3 ) THEN
        QBLOC = 0.0
      ELSE IF ( B .LT. 0.9 ) THEN
C
C       *** second iteration to find Qb ***
C
        Z  = EXP((QO-1.)/B**2)
        QBLOC = QO - B**2 * (QO-Z)/(B**2-Z)
      ELSE IF ( B .LE. 1.0 ) THEN
        QBLOC = QO
      ELSE
        QBLOC = 1.0
      END IF
C
C     *** test; remove on vector computer ***
C
      IF ( TESTFL .AND. ITEST .GE. 110 ) THEN
        WRITE (PRINTF,6020) ETOT, HM, B, QBLOC
 6020   FORMAT (' FRABRE: ETOT  HM  B  QB     : ',4E12.4)
      END IF
C
C     End of subroutine FRABRE
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE FRABRE2 (HM    ,ETOT  ,QBLOC)                            30.77
C
C****************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm4.inc'
      INCLUDE 'ocpcomm4.inc'
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.77: Annette Kieftenburg
C
C  1. Updates
C
C     30.77, Sep 1998: FRABRE2 is an update of FRABRE: the discontinuity at
C                      B = 0.9 in FRABRE has been removed and the discontinuity
C                      at B = 0.3 is changed in a discontinuity at B = 0.2
C                      for which QBLOC = 1.E-9
C
C  2. Purpose
C
C     to compute the fraction of breaking waves in point ix,iy
C     of the computational grid
C
C  3. Method (updated...)
C
C      The fraction of breaking waves in a point ix,iy is given by
C      the implicit relation:
C
C        1 - Qb        ETOT
C        ------ = -8 * -----
C        ln Qb         HM**2
C
C        from which Qb can be found by solving the equation:
C
C                         ETOT
C        F = 1 - Qb + 8 * ----  * ln(Qb) = 0.
C                           2
C                         HM
C
C        The following appproximation is applied:
C
C                            2
C  (1)|   B = sqrt( 8 ETOT/HM )
C
C
C     |   Qo = 0.                                      B <= 0.5
C  (2)|                 2
C     |   Qo = ( 2B -1 )                         0.5 < B <= 1
C
C
C     applying the Newton-Raphson procedure (for 0.2<B<1.0):
C
C     |   Qb = 0.                                      B <= 0.2
C     |
C     |                                   2
C     |               2  Qo - exp((Qo-1)/B )
C  (3)|   Qb = Qo  - B   ------------------      0.2 < B <  1.0
C     |                   2               2
C     |                  B  - exp((Qo-1)/B )
C     |
C     |
C     |   Qb = 1.                                      B >= 1.0
C     |
C
C     Here the parameters ETOT and HM are determined in the subroutine
C     SDISPA
C
C  4. Argument variables
C
C     ETOT    input  total energy per spatioal gridpoint
C     HM      input  maximum wave height
C     QBLOC   output second iteration of the fraction of breaking waves
C
      REAL    ETOT,  HM,  QBLOC
C
C  5. Parameter variables
C
C  6. Local variables
C
C     B       dummy variable
C     B2      dummy variable: B**2
C     IENT    number of entries
C     QO      first estimate of the fraction of breaking waves
C     Z       dummy variable
C
      INTEGER IENT
      REAL    B,  B2,  QO,  Z
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SDISPA
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C   ------------------------------------------------------------
C   Read the total wave energy ETOT and the maximum waveheight HM
C     If HM > 0. and ETOT > 0., then
C       Compute factor B according to equation (1)
C     Else
C       B = 0
C     ------------------------------------------------------------
C     Compute first estimate Qo according to equation (2)
C     Compute Qb according to equation (3)
C   ------------------------------------------------------------
C   End of FRABRE2
C   ------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'FRABRE2')
C
      IF ( (HM .GT. 0.) .AND. (ETOT .GE. 0.) ) THEN
        B = SQRT(8. * ETOT / (HM*HM) )
      ELSE
        B = 0.0
      END IF
C
      IF ( B .LE. 0.5 ) THEN
        QO = 0.
      ELSE IF ( B .LE. 1.0 ) THEN
        QO = (2.*B - 1.)**2
      END IF
C
      IF ( B .LE. 0.2 ) THEN
        QBLOC = 0.0
      ELSE IF ( B .LT. 1.0 ) THEN
C
C       *** second iteration to find Qb ***
C
        B2 = B*B
        Z  = EXP((QO-1.)/B2)
        QBLOC = QO - B2 * (QO-Z)/(B2-Z)
      ELSE
        QBLOC = 1.0
      END IF
C
C     *** test; remove on vector computer ***
C
      IF ( TESTFL .AND. ITEST .GE. 110 ) THEN
        WRITE (PRINTF,6120) ETOT, HM, B, QBLOC
 6120   FORMAT (' FRABRE2: ETOT  HM  B  QB     : ',4E12.4)
      END IF
C
C     End of subroutine FRABRE2
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SSURF (ETOT    ,HM               ,                       30.81
     &                  QB      ,SMEBRK  ,AC2     ,IMATRA  ,              30.81
     &                  IMATDA  ,IDCMIN  ,IDCMAX  ,PLWBRK  ,              30.81
     &                  ISSTOP  ,DISSC0  ,DISSC1                          30.81 30.21
     &                                                              )
C
C****************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'                                               30.81
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C  0. Authors
C
C     30.62: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     40.13: Nico Booij
C
C  1. Updates
C
C     30.62, Aug. 97: Prevented a possible division by zero
C     30.82, Sep. 98: Changed indices of PLWBRK-array declaration
C     30.82, Oct. 98: Made subroutine intrinsic DOUBLE PRECISION
C     30.81, Sep. 99: Argumentlist reduced
C     40.13, Jan. 01: PLWBRK corrected (dissipation test output)
C
C  2. Purpose
C
C     Computation of the source term due to wave breaking.
C     White capping is not taken into account
C
C  3. Method
C
C     The source term for surf breaking is implemented following
C     the approach of Battjes/Jansen (1978) for the energy dissipation:
C
C             Alpha      -     2                  -   SMEBRK
C     Dtot =  ----  Qb * f * Hm              with f = ------
C              4                                      2 * Pi
C
C     Now the source term is:
C
C                      SIGMA * AC2(ID,IS,IX,IY)
C     Sbr =  - Dtot *  ------------------------  =
C                              Etot
C
C
C              Alpha * SMEBRK * Qb * Hm * Hm    SIGMA * AC2(ID,IS,IX,IY)
C         =  - ------------------------------ * -------------------------
C                       8 * Pi                            Etot
C
C
C         =  WS * SIGMA * AC2(ID,IS,IX,IY)   =  WS * E
C
C
C     With:
C
C     Alpha = PSURF(1)                            ;
C
C                   SMEBRK Qb
C     WS    = Alpha ------ --                     ;
C                     Pi   BB
C                        2
C     BB    = 8 Etot / Hm  = - (1 - Qb) / ln (Qb) ;
C
C
C     The local maximum wave height Hm is computed in subroutine SSDIPA.
C     The fraction of breaking waves Qb is calculated in the subroutine FRABRE2
C
C     The new value for the dissipation is computed implicitely using
C     the last computed value for the action density Nold (at the spatial
C     gridpoint under consideration).
C
C     Sbr = WS * N
C
C         = Sbr_new + (d Sbr/d N) (Nnew - Nold)
C
C         = WS * Nnew + SbrD * (Nnew - Nold)
C
C         = (WS + SbrD)* Nnew - SbrD * Nold
C
C         = SURFA1 * Nnew - SURFA0 * Nold
C
C     In order to do this we need the derivative
C     of the source term Sbr to the action density N
C
C             d Sbr     d WS
C     SbrD =  -----  =  ---- * N + WS
C             d N       d N
C
C     Since BB and SMEBRK * N are proportional
C
C     d Sbr     d WS                   SMEBRK  (d Qb/ d BB) *BB - Qb
C     -----  =  ---- * BB + WS = Alpha ------  --------------------- * BB + WS =
C     d N       d BB                     Pi           sqr(BB)
C
C
C           SMEBRK d Qb
C     Alpha ------ ----
C            Pi    d BB
C
C     With:
C
C     d Qb         1
C     ---- = -------------                 ;
C     d BB   (d BB / d Qb)
C
C                      2
C     d Qb           ln (Qb)
C     ---- = ---------------------------
C     d BB   ln (Qb) + (1 - Qb) (1 / Qb)
C
C            Qb (1 - Qb)
C          = ------------                  ;
C            BB (BB - Qb)
C
C  4. Argument variables
C
C     AC2     input :   Action density array
C     DISSC0  output:
C     DISSC1  output:
C     ETOT    input :   Total energy per spatial gridpoint
C     HM      input :   Maximum wave height
C     ICMAX   input :   Maximum number of elements in KCGRD array
C     IDCMIN  input :   Minimum number for counter IDDUM
C     IDCMAX  input :   Maximum number for counter IDDUM
C     IMATDA  output:   Coefficient of diagonal matrix (2D)
C     IMATRA  output:   Coefficient of righthandside of matrix
C     ISSTOP  input :   Maximum for counter IS
C     PLWBRK  output:
C     QB      input :   Fraction of breaking waves
C     SMEBRK  input :   Mean frequency according to first order moment
C
      INTEGER        ISSTOP,
     &         IDCMIN(MSC), IDCMAX(MSC)
C
      REAL     AC2(MDC,MSC,MCGRD)   ,
     &         DISSC0(MDC,MSC)      ,
     &         DISSC1(MDC,MSC)      ,
     &         IMATDA(MDC,MSC)      ,
     &         IMATRA(MDC,MSC)      ,
     &         PLWBRK(MDC,MSC,NPTST)                                      40.00
C
      REAL     ETOT,  HM,  QB, SMEBRK                                     30.81
C
C  5. Parameter variables
C
C  6. Local variables
C     BB      Rate between the total energy and the energy
C             according to the maximum wave height HM
C     DIS0    Dummy variable
C     FRDEP   Frequency dependent function
C     ID      Counter for directional steps
C     IDDUM   Counter
C     IENT    Number of entries
C     IS      Counter for frequency steps
C     NORM    Normalization factor for frequency dependent function
C     RES     Dummy variable
C     RESD    Dummy variable
C     SURFA0  Coefficient for old source term in matrix equation
C             (i.e. SURFA0 * Nold = right hand side of matrix equation)
C     SURFA1  Coefficient for new source term in matrix equation
C     WS      Wavebreaking source term coefficient = DTOT/ETOT
C     SbrD    Derivative of source term for surf breaking (Sbr) to action density
C
      INTEGER ID,      IDDUM,   IENT,   IS
C
      DOUBLE PRECISION BB,      DIS0,    SbrD,
     &                 SURFA0,  SURFA1,  WS
C
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SOURCE
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ------------------------------------------------------------
C     Get HM, QB and ETOT from the subroutine SDISPA
C     For spectral direction IS and ID do,
C       get the mean energy frequency average over the full spectrum
C       If ETOT > 0 then
C         compute source term for energy dissipation SURFA0 and SURFA1
C       Else
C         source term for wave breaking is 0.
C       End if
C       ----------------------------------------------------------
C       Compute source terms for energy averaged frequency
C       Store results in the arrays IMATDA and IMATRA
C     ------------------------------------------------------------
C     End of SSURF
C     -------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SSURF')
C
C     ALFA = PSURF(1)   <default = 1.0>
C
      BB = 8. * DBLE(ETOT) / ( DBLE(HM)**2 )                              30.82
      SURFA0 = 0.
      SURFA1 = 0.
      IF (REAL(BB) .GT. 0. .AND.                                          30.82
     &    REAL(ABS(BB - DBLE(QB))) .GT. 0.) THEN                          30.82
        IF ( BB .LT. 1. ) THEN
          WS  = ( DBLE(PSURF(1)) / DBLE(PI)) *                            30.82
     &            DBLE(QB) * DBLE(SMEBRK) / BB                            30.82
          SbrD = WS * (1. - DBLE(QB)) / (BB - DBLE(QB))                   30.82 40.00
        ELSE
          WS  = ( DBLE(PSURF(1)) / DBLE(PI)) * DBLE(SMEBRK)               30.82
          SbrD = 0.
        END IF
        SURFA0 = SbrD
        SURFA1 = WS + SbrD
      ELSE
        SURFA0 = 0.
        SURFA1 = 0.
      END IF
C
C     *** store the results for surf wave breaking  ***
C     *** in the matrices IMATDA and IMATRA         ***
C
      DO 101 IS = 1, ISSTOP
        DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IMATDA(ID,IS) = IMATDA(ID,IS) + REAL(SURFA1)                    30.82
          DIS0 = SURFA0 * DBLE(AC2(ID,IS,KCGRD(1)))                       30.82
          IMATRA(ID,IS) = IMATRA(ID,IS) + REAL(DIS0)                      30.82
          IF (TESTFL) PLWBRK(ID,IS,IPTST) = REAL(SURFA0-SURFA1)           40.13
          DISSC0(ID,IS) = DISSC0(ID,IS) - REAL(DIS0)                      30.82
          DISSC1(ID,IS) = DISSC1(ID,IS) + REAL(SURFA1)                    30.82
 100    CONTINUE
 101  CONTINUE
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 110 ) THEN
        WRITE(PRINTF,6021) SURFA1,SURFA0
 6021   FORMAT (' SSURF : SURFA1 SURFA0     :',2D12.4)
        WRITE(PRINTF,6020) HM, QB, ETOT, SMEBRK
 6020   FORMAT ('       : HM QB ETOT SMEBRK :',4E12.4)
      END IF
C
C
C     end of the subroutine SSURF
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SWCAP  (SPCDIR  ,SPCSIG  ,KWAVE   ,AC2     ,             40.02
     &                   IDCMIN  ,IDCMAX  ,ISSTOP  ,                      40.02
     &                   ETOT    ,IMATDA  ,IMATRA  ,PLWCAP  ,             40.02
     &                   DEP2    ,DISSIP  ,DISIMP  )                      40.12
C
C****************************************************************
C
      USE M_WCAP
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
      INCLUDE 'ocpcomm4.inc'
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.02: IJsbrand Haagsma
C     40.12: IJsbrand Haagsma
C
C  1. Updates
C
C     40.02, Jan. 00: New, based on the old SWCAP1-5 subroutines
C     40.12, Nov. 00: Added WCAP to dissipation output (bug fix)
C
C  2. Purpose
C
C     Calculates the dissipation due to whitecapping
C
C  3. Method
C
C     Whitecapping dissipation is formulated as follows:
C
C     S_wc(sig,th) = - C_wc E(sig,th)
C
C     where the coefficient C_wc has three basic forms:
C
C     C_wc1 = C_K  sig~ (k/k~): According to Komen (generalised)
C     C_wc2 = C_BJ sig~ (k/k~): According to Battjes-Janssen (modified)
C     C_wc3 = C_LH            : According to Longuet Higgins (1969)
C
C     In these formulations C_K is defined as (Komen; 1994 p. 145):
C
C                                       n1           n2
C     C_K = C1 [(1-delta) + delta (k/k~)  ] (S~/S_PM)
C
C     where C1, delta, n1 and n2 can be varied
C
C
C     C_BJ is defined as:
C
C                    2
C            alpha Hm Qb
C     C_BJ = -----------
C              8 Pi m0
C
C     where alpha can be varied.
C
C     for Hrms > Hm the formulation changes in a limit to (Hrms->Hm; Qb->1):
C
C            alpha
C     C_BJ = -----
C             Pi
C
C     and C_LH is defined as (Komen; 1994 p. 151-152):
C
C                            4   2                        2
C     C_LH = C3 Sqrt[(m0 sig0 )/g ] exp(A) sig0 (sig/sig0)
C
C     where
C                    2    2         4                2       2
C     A = -1/8 [1-eps ] [g /(m0 sig0 )]  with  [1-eps ] = [m2 ] / [m0 m4]
C
C     and C3 can be varied
C
C
C     In these equations the variables have the following meaning:
C
C     Hm   : Maximum wave height
C     Hrms : Root mean square of the wave heights
C     eps^2: Measure for the spectral bandwidth
C     m0   : Total wave energy density (=ETOT)
C     m2   : Second moment of the variance spectrum (=ETOT2)
C     m4   : Fourth moment of the variance spectrum (=ETOT4)
C     k    : Wave number (=KWAVE(IS,1))
C     k~   : Mean wave number
C     Qb   : Fraction of breaking waves
C     sig  : Frequency (=SPCSIG(IS))
C     sig0 : Average zero crossing frequency
C     sig~ : Mean frequency
C     S~   : Overall steepness (STP_OV)
C     S_PM : Overall steepness for a Pierson-Moskowitz spectrum
C     th   : direction theta (=SPCDIR(ID))
C
C  4. Argument variables
C
C     AC2   : Action density
C     ACTOT : Total action density per gridpoint
C     DEP2  : Array containing water-depth
C     DISSIP: Array containing dissipation
C     DISIMP: Array containing implicit part of the dissipation
C     ETOT  : Total wave energy density
C     IDCMIN: Counter that indicates the minimum direction that is propagated in the sweep
C     IDCMAX: Counter that indicates the maximum direction that is propagated in the sweep
C     IMATDA: The values at the diagonal of the matrix that is solved numerically
C     IMATRA: The values at the right-hand side of the equation that is solved numerically
C     ISSTOP: Maxmum counter in freuqency space that is propagated within a sweep ??
C     KWAVE : Wavenumber
C     PLWCAP: Array containing the whitecapping source term for test-output
C     SPCDIR: (*,1); spectral directions (radians)
C             (*,2); cosine of spectral directions
C             (*,3); sine of spectral directions
C             (*,4); cosine^2 of spectral directions
C             (*,5); cosine*sine of spectral directions
C             (*,6); sine^2 of spectral directions
C     SPCSIG: Relative frequencies in computational domain in sigma-space
C
      INTEGER, INTENT(IN)  :: ISSTOP, IDCMIN(MSC), IDCMAX(MSC)
C
      REAL, INTENT(IN)     :: AC2(MDC,MSC,MCGRD), DEP2(MCGRD)
      REAL, INTENT(IN)     :: ETOT
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL, INTENT(IN)     :: KWAVE(MSC,MICMAX)                           40.22
      REAL, INTENT(IN)     :: SPCDIR(MDC,6), SPCSIG(MSC)
      REAL, INTENT(OUT)    :: PLWCAP(MDC,MSC,NPTST)
      REAL, INTENT(IN OUT) :: IMATDA(MDC,MSC), IMATRA(MDC,MSC)
      REAL, INTENT(IN OUT) :: DISSIP(MDC,MSC), DISIMP(MDC,MSC)            40.12
C
C  6. Local variables
C
C     A     : Exponential term in the Longuet Higgins expression
C     C_BJ  : Whitecapping coefficient according to Battjes-Janssen
C     C_K   : Whitecapping coefficient according to Komen
C     C_LH  : Whitecapping coefficient according to Longuet Higgins
C     HM    : Maximum waveheight as used in the Battjes-Janssen expression
C     HRMS  : Significant wave height, based on total energy
C     ID    : Counter in directional space
C     IDDUM : Counter in directional space withing sweep limits
C     IENT  : Number of entries in this subroutine
C     IS    : Counter in frequency space
C     N1    : Exponent for the wavenumber term in the Komen expression
C     N2    : Exponent for the steepness term in the Komen expression
C     QB_WC : The fraction of whitecapping waves in the Battjes-Janssen expression
C     SIG0  : Average zero-crossing frequency used in the Longuet Higgins expression
CWCAPC     STP_COR:Correction factor for the steepness in case of short waves riding on long waves
CWCAPC             Longuet-Higgins and Stewart (JFM, 1960)
C     STP_OV: Overall steepness
C     STP_PM: Overall steepness for a Pierson-Moskowitz spectrum
CWCAPC     STP_SWELL:
C     WCAP  : Whitecapping source-term
C     WCIMPL: Implicit part of the whitecapping source-term
C
      INTEGER, SAVE     :: IENT = 0
      INTEGER           :: ID, IDDUM, IS
C
      REAL              :: A, C_BJ, HM, HRMS, N1, N2
      REAL              :: QB_WC, SIG0, STP_OV, STP_PM
CWCAP      REAL STP_COR, STP_SWELL
C
      REAL, ALLOCATABLE :: C_K(:), C_LH(:), WCAP(:), WCIMPL(:)
C
C     5. SUBROUTINES CALLING
C
C        ---
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        alpha : PWCAP( 7)
C        C1    : PWCAP( 1)
C        C3    : PWCAP( 5)
C        delta : PWCAP(10)
C
C     9. STRUCTURE
C
C     ------------------------------------------------------------
C     Initialisation
C     ------------------------------------------------------------
C     Calculate needed parameters
C     ------------------------------------------------------------
C     If IWCAP = 1, 2, or 5; Calculate C_K
C     If IWCAP = 4 or 5; Calcualte C_BJ
C     If IWCAP = 3; Calculate C_LH
C     ------------------------------------------------------------
C     For frequency dependent part of the spectrum
C       Calculate dissipation term due to whitecapping
C     ------------------------------------------------------------
C     For the whole frequency domain
C       Fill the matrices and PLWCAP-array
C     ------------------------------------------------------------
C     End of SWCAP
C     ------------------------------------------------------------
C
C 13. Source text
C
      IF (LTRACE) CALL STRACE (IENT,'WCAP')
C
      IF (IWCAP.GE.6) THEN
C
C Error message
C
        CALL MSGERR(4,'Value for IWCAP should be less than 6!')
        RETURN
      END IF
C
C Initialisation
C
      IF (ETOT.LE.0.) RETURN
      IF (ETOT2.LE.0.) RETURN
      IF (ETOT4.LE.0.) RETURN
      IF (ACTOT.LE.0.) RETURN
      IF (EDRKTOT.LE.0.) RETURN
C
      ALLOCATE (C_K(MSC), C_LH(MSC), WCAP(MSC), WCIMPL(MSC))
      WCIMPL(1:MSC) = 0.
C
C Calculate coefficients
C
      IF ((IWCAP.EQ.1).OR.
     &    (IWCAP.EQ.2).OR.
     &    (IWCAP.EQ.5).OR.
     &    (IWCAP.EQ.6)    ) THEN
C
C Calculate C_K
C
        STP_OV = KM_WAM * SQRT(ETOT)
CWCAP        STP_SWELL = K_SWELL * SQRT(ETOT_SWELL)
CWCAP        STP_COR= (1 + K_SWELL *  SQRT(ETOT_SWELL) *
CWCAP     &                  (0.75 * (COSH(K_SWELL * DEP2(KCGRD(1)))/
CWCAP     &                           SINH(K_SWELL * DEP2(KCGRD(1))) ) +
CWCAP     &                   0.25 *  TANH(K_SWELL * DEP2(KCGRD(1)))  )) /
CWCAP     &           (1 - K_SWELL *  SQRT(ETOT_SWELL) *
CWCAP     &                  (COSH(K_SWELL * DEP2(KCGRD(1)))/
CWCAP     &                   SINH(K_SWELL * DEP2(KCGRD(1))) ) )
        STP_PM = SQRT(PWCAP(2))
        N1     = PWCAP(11)
        N2     = 2. * PWCAP(9)
        C_K(:) = PWCAP(1) * (1. - PWCAP(10) +
     &           PWCAP(10) * (KWAVE(:,1) / KM_WAM)**N1) *
     &           (STP_OV / STP_PM)**N2
CWCAP        IF (IWCAP.EQ.6) STP_OV = STP_SWELL
CWCAP        DO IS=1, IS_SPLIT
CWCAP          C_K(IS) = PWCAP(1) * (1. - PWCAP(10) +
CWCAP     &               PWCAP(10) * (KWAVE(IS,1) / KM_WAM)**N1) *
CWCAP     &              (STP_OV / STP_PM)**N2
CWCAP        END DO
CWCAP        IF (IWCAP.EQ.6) STP_OV = STP_COR * KM_WAM * SQRT(ETOT)
CWCAP        DO IS=IS_SPLIT+1, MSC
CWCAP          C_K(IS) = PWCAP(1) * (1. - PWCAP(10) +
CWCAP     &               PWCAP(10) * (KWAVE(IS,1) / KM_WAM)**N1) *
CWCAP     &              (STP_OV / STP_PM)**N2
CWCAP        END DO
C
      ENDIF
C
      IF ((IWCAP.EQ.4).OR.
     &    (IWCAP.EQ.5)    ) THEN
C
C Calculate values for Hm and Qb
C
        HRMS   = SQRT(8. * ETOT)
        IF (IWCAP.EQ.4) HM = PWCAP(6) / KM01
        IF (IWCAP.EQ.5) HM = PWCAP(6) / (PWCAP(8) * KM_WAM)
        CALL FRABRE2(HM, ETOT, QB_WC)
C
C Calculate C_BJ
C
        IF (HRMS.GE.HM) THEN
          C_BJ = PWCAP(7)  /  PI
        ELSE IF (HRMS.GT.0.) THEN
          C_BJ = (PWCAP(7) *  HM**2 * QB_WC) / (PI * HRMS**2)
        ELSE
          C_BJ = 0.
        END IF
      ENDIF
C
      IF (IWCAP.EQ.3) THEN
C
C Calculate C_LH
C
        SIG0 = SQRT(ETOT2 / ETOT)
C
C       A = -(1./8.)*(ETOT2**2/(ETOT*ETOT4))*(GRAV**2/(ETOT*SIG0**4))
C       rewrite to prevent underflow
C
        A = -(1./8.) * GRAV**2 / ETOT4
        DO IS=1, ISSTOP
C          C_LH(IS) = PWCAP(5) * SQRT((ETOT * SIG0**4) / GRAV**2) *
C     &               EXP(A) * SIG0 * (SPCSIG(IS) / SIG0)**2
C          rewrite to prevent underflow:
C
          C_LH(IS) = PWCAP(5) * EXP(A) * SQRT(ETOT2) * SPCSIG(IS)**2 /
     &               GRAV
        END DO
      END IF
C
C Calculate the whitecapping source term WCAP(IS)
C
      DO IS=1, ISSTOP
        IF ((IWCAP.EQ.1).OR.
     &      (IWCAP.EQ.2).OR.
     &     ((IWCAP.EQ.5).AND.(C_BJ.LE.C_K(IS)))) THEN
          WCAP(IS) = C_K(IS) * SIGM_10 * (KWAVE(IS,1) / KM_WAM)
        ELSE IF (IWCAP.EQ.3) THEN
          WCAP(IS) = C_LH(IS)
        ELSE IF ((IWCAP.EQ.4).OR.
     &     ((IWCAP.EQ.5).AND.(C_BJ.GE.C_K(IS)))) THEN
          IF (IWCAP.EQ.4) WCAP(IS) = C_BJ*SIGM01 *(KWAVE(IS,1)/KM01  )
          IF (IWCAP.EQ.5) WCAP(IS) = C_BJ*SIGM_10*(KWAVE(IS,1)/KM_WAM)
C
C Calculate a term that is added to both sides of the equation to compensate
C for the strong non-linearity in the fraction of breaking waves Qb
C
          IF (HRMS.LT.HM) THEN
            WCIMPL(IS) = WCAP(IS) * ((1.-QB_WC)/((HRMS**2/HM**2)-QB_WC))
            WCAP(IS)   = WCAP(IS) + WCIMPL(IS)
          END IF
        ELSE
          CALL MSGERR(2,'Whitecapping is inactive')
          WRITE (PRINTF,*) 'Occurs in gridpoint: ', KCGRD(1)
        END IF
      END DO
C
C Fill the diagonal of the matrix and the PLWCAP-array
C
      DO IS=1, ISSTOP
C
C       Only fill the values for the current sweep
C
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD(IDDUM - 1 + MDC, MDC) + 1
          IMATDA(ID,IS) = IMATDA(ID,IS) + WCAP(IS)
          DISSIP(ID,IS) = DISSIP(ID,IS) + WCAP(IS)                        40.12
          IF (TESTFL) PLWCAP(ID,IS,IPTST) = -1.*(WCAP(IS)-WCIMPL(IS))
        END DO
      END DO
C
C Add the implicit part to the right-hand side
C
      IF ((IWCAP.EQ.4).OR.
     &    (IWCAP.EQ.5)) THEN
        DO IS=1, ISSTOP
C
C       Only fill the values for the current sweep
C
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD(IDDUM - 1 + MDC, MDC) + 1
            IMATRA(ID,IS) = IMATRA(ID,IS) +
     &                      WCIMPL(IS) * AC2(ID,IS,KCGRD(1))
            DISIMP(ID,IS) = DISIMP(ID,IS) +                               40.12
     &                      WCIMPL(IS) * AC2(ID,IS,KCGRD(1))              40.12
          END DO
        END DO
      END IF
C
      DEALLOCATE (C_K, C_LH, WCAP, WCIMPL)
C
      RETURN
      END SUBROUTINE SWCAP
C****************************************************************
C
      SUBROUTINE BRKPAR (BRCOEF  ,ECOS    ,ESIN    ,AC2     ,             40.22
     &                   SPCSIG  ,DEP2    ,RDX     ,RDY     )             30.72
C
C****************************************************************
C
      IMPLICIT NONE                                                       40.22
      INCLUDE 'swcomm3.inc'                                               40.22
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
!     40.22: Nico Booij
C
C  1. Updates
C
C            Jan. 97: New subroutine (Roeland Ris)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.02, Oct. 00: KWAVE removed
!     40.22, Oct. 01: PSURF(2) is kept constant, BRCOEF added as argument
C
C  2. Purpose
C
C     Determine the bottom slope in upwave direction and calculate
C     the slope dependent breaking parameter according to Nelson (1987)
C     Note that Nelson (1987) is used here since in Nelson (1994a,1994b)
C     an error is present in the equation.
C
C  3. Method
C
C     The breaker parameter is given by:
C
C     Hm / d =  0.55 + 0.88 exp ( -0.012 * cot beta)
C
C     with beta the angle the bed makes with the horizontal. This
C     above equation is only valid for positive slopes (Negative
C     slopes were not considered by Nelson. For very steep slopes
C     (>0.05 say) a very large breaker parameter is obtained (>>1).
C
C     To ensure wave breaking in laboratory cases (with very steep
C     slopes an upper limit of 0.81 (which corresponds to a bottom
C     slope of 0.01) is imposed on the model of Nelson.
C
C     For negative bottom slopes (not considered by Nelson) a value
C     op 0.73 is imposed (which is the average value in Table 2 of
C     Battjes and Janssen (1978).
C
C  4. Argument variables
C
      REAL, INTENT(OUT) :: BRCOEF    ! variable breaker coefficient       40.22
 
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL, INTENT(IN)  :: SPCSIG(MSC)                                    30.72
      REAL, INTENT(IN)  :: AC2(MDC,MSC,MCGRD)  ! action densities         40.22
      REAL, INTENT(IN)  :: ECOS(MDC), ESIN(MDC)  ! Cos and Sin of Theta   40.22
      REAL, INTENT(IN)  :: DEP2(MCGRD)         ! depths at grid points    40.22
!     RDX, RDY:  coefficients to obtain spatial derivatives               40.22
      REAL, INTENT(IN)  :: RDX(2), RDY(2)
C
C        INTEGERS :
C        ----------
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MCGRD       Maximum counter in geographical space
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C        KCGRD       Grid counter in central gridpoint (geo. space)
C
C
C        REALS:
C        ------
C        ETOTS       Total wave energy density in a particular
C                    direction (energy in tail neglected)
C        BRKVAR      Breaking coefficient
C        DIRDEG      Mean propagation direction of wave energy in
C                    degrees
C        DIRRAD      Mean propagation direction of wave energy in
C                    radians
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2         Action density
C        ECOS/ESIN   Cos. , sin of angle
C        DEP2        Depth
C        PSURF       Coefficients for breaking module
C
C     5. SUBROUTINES CALLING
C
C        SDISPA
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C     ------------------------------------------------------------
C     Calculate total energy per direction for all frequencies
C       determine action density per direction weighted with cos/sin
C       determine mean propagation direction of energy
C     ------------------------------------------------------------
C     calculate the depth derivative in the mean wave direction
C      according to dd/ds (see also subroutine SPROSD)
C     calculate the slope dependend breaking coefficient
C     ------------------------------------------------------------
C     End of NELSON
C     -------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER :: ID    ,IS      ! counters                                40.22
C
C
      REAL  :: ETOTS ,EEX   ,EEY   ,
     &         EAD   ,SIGMA1,COSDIR,SINDIR,DDDX  ,                        40.22
     &         DDDY  ,DDDS  ,DETOT                                        40.22
C
      INTEGER, SAVE :: IENT=0
      IF (LTRACE) CALL STRACE (IENT,'BRKPAR')
C
C     *** determine the average wave direction ***
C
      EEX   = 0.
      EEY   = 0.
      ETOTS = 0.
      DO ID = 1, MDC
        EAD = 0.
        DO IS = 1, MSC
          SIGMA1 = SPCSIG(IS)                                             30.72
          DETOT  = SIGMA1**2 * AC2(ID,IS,KCGRD(1))
          EAD    = EAD + DETOT
        ENDDO
        ETOTS = ETOTS + EAD
        EEX   = EEX + EAD * ECOS(ID)
        EEY   = EEY + EAD * ESIN(ID)
      ENDDO
C
      IF ( ETOTS .GT. 0.) THEN
        COSDIR = EEX / ETOTS
        SINDIR = EEY / ETOTS
      ELSE
        COSDIR = 1.
        SINDIR = 0.
      ENDIF
C
C     *** Determine bottom slope in average wave propagation direction ***
C
      DDDX =  RDX(1) * (DEP2(KCGRD(1)) - DEP2(KCGRD(2)))
     &      + RDX(2) * (DEP2(KCGRD(1)) - DEP2(KCGRD(3)))
      DDDY =  RDY(1) * (DEP2(KCGRD(1)) - DEP2(KCGRD(2)))
     &      + RDY(2) * (DEP2(KCGRD(1)) - DEP2(KCGRD(3)))
C
      DDDS = -1. * ( DDDX * COSDIR + DDDY * SINDIR )
C
C     *** calculate breaking coefficient according to Nelson (1987) ***
C
      IF ( DDDS .GE. 0. ) THEN
        DDDS   = MAX ( 1.E-6 , DDDS)
        BRCOEF = PSURF(4) + PSURF(7) * EXP ( -PSURF(8) / DDDS )           40.22
        BRCOEF = MIN ( PSURF(5) , BRCOEF )                                40.22
      ELSE
        BRCOEF = PSURF(6)                                                 40.22
      ENDIF
C
!      PSURF(2) = BRKVAR                              deleted             40.22
!      PSURF(2) is no longer used to transmit br. coefficient             40.22
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 40 ) THEN
        WRITE(PRINTF,600) KCGRD(1), ATAN2(SINDIR,COSDIR)*180./PI,
     &                    DEP2(KCGRD(1)), DDDS, BRCOEF                    40.22
 600    FORMAT (' BRKPAR: point nr, dir, depth, slope, br.coeff:',
     &          I4,4(1X,E12.4))
      END IF
C
      RETURN
      END subroutine BRKPAR
C
C********************************************************************
C
      SUBROUTINE PLTSRC (PLWNDA        ,PLWNDB        ,
     &                   PLWCAP        ,PLBTFR        ,
     &                   PLWBRK        ,PLNL4S        ,
     &                   PLNL4D        ,PLTRI         ,
     &                   AC2           ,SPCSIG        ,                   40.00
     &                   DEP2          ,XYTST         ,
     &                                  KGRPNT        )                   40.00
C
C****************************************************************
C
      INCLUDE 'swcomm1.inc'                                               40.00
      INCLUDE 'swcomm2.inc'                                               40.00
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     1. UPDATE
C
C        40.00, Sep. 98: subroutine modified for new spectral file def.
C        40.00, Apr. 99: factor 2*PI added in 1d spectra
C
C     2. PURPOSE
C
C        store the source terms for the TESTFL gridpoint in a file
C
C     3. METHOD
C
C        ----
C
C     4. PARAMETERLIST
C
C        INTEGER
C        -------
C        MXC,MYC  Maximum counters in geographical space
C
C        REAL
C        ----
C
C        ARRAYS
C        -------
C        PLWNDA   2D    SWINEA
C        PLWNDB   2D    SWINEB
C        PLWCAP   2D    SWCAPE
C        PLBTFR   2D    SWBOTE
C        PLWBRK   2D    SWSURF
C        PLNL4    2D    SWNL
C        PLTRI    2D    TRIADS
C
C     5. subroutines calling
C
C
C     6. subroutines used
C
C        WRSPEC
C
C     7. error messages
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   ----------------------------------------------------------------
C   If Mode Timedep is active
C   Then write time
C   Else write iteration
C   ----------------------------------------------------------------
C   For all test points do
C       If IFS1D > 0
C       Then For all spectral frequencies do
C                integrate action and source terms over direction
C                write action and source terms to file IFS1D
C       ------------------------------------------------------------
C       If IFS2D > 0
C       Then write action densities and source terms to file IFS2D
C       ------------------------------------------------------------
C       Set source terms equal to 0
C   ----------------------------------------------------------------
C
C     10. SOURCE
C
      INTEGER     IS    ,ID
C
C     SIGACT      product of sigma and action density, i.e. energy density
C     WCAP        integral of whitecapping dissipation
C
      REAL        WCAP  ,BTFR  ,WBRK  ,NL4   ,FAC   ,SIGACT,
     &            NL4S  ,NL4D  ,TRIA  ,ENERGY,ENRSIG
C
      INTEGER     XYTST(2*NPTST),KGRPNT(MXC,MYC)                          30.21
C
C
      REAL        AC2(MDC,MSC,MCGRD)          ,
     &            SPCSIG(MSC)                 ,                           40.00
     &            PLWNDA(MDC,MSC,NPTST)       ,
     &            PLWNDB(MDC,MSC,NPTST)       ,
     &            PLWCAP(MDC,MSC,NPTST)       ,
     &            PLBTFR(MDC,MSC,NPTST)       ,
     &            PLWBRK(MDC,MSC,NPTST)       ,
     &            PLNL4S(MDC,MSC,NPTST)       ,
     &            PLNL4D(MDC,MSC,NPTST)       ,
     &            PLTRI(MDC,MSC,NPTST)        ,
     &            DEP2(MCGRD)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'PLTSRC')
C
C     *** compute the 1D spectra ***
C
      DO 300 IPTST = 1, NPTST
        LXDMP = XYTST(2*IPTST-1)
        LYDMP = XYTST(2*IPTST)
        INDX  = KGRPNT(LXDMP,LYDMP)
        IF (IFPAR.GT.0) THEN
C
C         *** for the output we first integrate over all ***
C         *** frequencies and directions                 ***              40.00
C
          ENERGY = 0.
          ENRSIG = 0.
          SWND = 0.
          WCAP = 0.
          BTFR = 0.
          WBRK = 0.
          NL4  = 0.
          TRIA = 0.
          DO 60 IS = 1, MSC
            DO 50 ID = 1, MDC
C
C             *** ENERGY density ***
C
              SIG2AC = SPCSIG(IS)**2 * AC2(ID,IS,INDX)
              ENERGY = ENERGY + SIG2AC                                    40.00
              ENRSIG = ENRSIG + SPCSIG(IS) * SIG2AC                       40.00
C
C             *** wind input ***
C
              SWND = SWND + SPCSIG(IS)**2 * PLWNDA(ID,IS,IPTST) +
     &                 PLWNDB(ID,IS,IPTST) * SIG2AC                       40.00
C
C             *** dissipation processes ***
C
              WCAP = WCAP + PLWCAP(ID,IS,IPTST) * SIG2AC                  40.00
              BTFR = BTFR + PLBTFR(ID,IS,IPTST) * SIG2AC
              WBRK = WBRK + PLWBRK(ID,IS,IPTST) * SIG2AC
C
C             *** nonlinear interactions ***
C
              TRIA = TRIA + ABS(PLTRI(ID,IS,IPTST) * SPCSIG(IS))          40.00
C
C
              IF ( IQUAD .EQ. 1) THEN
                NL4  = NL4  + ABS(PLNL4D(ID,IS,IPTST) * SIG2AC +
     &                            PLNL4S(ID,IS,IPTST) * SPCSIG(IS))       40.00
              ELSE
                NL4  = NL4  + ABS(PLNL4S(ID,IS,IPTST) * SPCSIG(IS))       40.00
              END IF
C
  50        CONTINUE
  60      CONTINUE
C
          IF (ENERGY.GT.0.) THEN                                          40.00
            ENERGY = ENERGY * FRINTF * DDIR
            ENRSIG = ENRSIG * FRINTF * DDIR
            SWND   = SWND   * FRINTF * DDIR
            WCAP   = WCAP   * FRINTF * DDIR
            BTFR   = BTFR   * FRINTF * DDIR
            WBRK   = WBRK   * FRINTF * DDIR
            TRIA   = TRIA   * FRINTF * DDIR
            NL4    = NL4    * FRINTF * DDIR
C
            WRITE (IFPAR, 70) 4.*SQRT(ENERGY), PI2*ENERGY/ENRSIG,
     &                          SWND, WCAP, BTFR, WBRK, TRIA, NL4         40.00
  70        FORMAT(8(1X,E12.4))
          ELSE
            WRITE (IFPAR, 70) OVEXCV(10), OVEXCV(42), OVEXCV(7),
     &          OVEXCV(7), OVEXCV(7), OVEXCV(7), OVEXCV(7), OVEXCV(7)     40.00
          ENDIF
        ENDIF
C
        IF (IFS1D.GT.0) THEN
          IF (DEP2(INDX).LE.0.) THEN
            WRITE (IFS1D, 80) 'NODATA'                                    40.00
          ELSE
            WRITE (IFS1D, 80) 'Test point ', IPTST                        40.00
  80        FORMAT (A, I6)                                                40.00
C
C         *** for the output of parameters we integrate over ***
C         *** the whole spectrum                             ***
C
            DO 160 IS = 1, MSC
              SWND = 0.
              WCAP = 0.
              BTFR = 0.
              WBRK = 0.
              NL4S = 0.
              NL4D = 0.
              TRIA = 0.
              ENERGY = 0.
              DO 150 ID = 1, MDC
                SIGACT = SPCSIG(IS) * AC2(ID,IS,INDX)
C
C               *** wind input ***
C
                SWND = SWND + PLWNDA(ID,IS,IPTST) * SPCSIG(IS) +
     &                        PLWNDB(ID,IS,IPTST) * SIGACT                40.00
C
C               *** dissipation processes ***
C
                WCAP = WCAP + PLWCAP(ID,IS,IPTST) * SIGACT                40.00
                BTFR = BTFR + PLBTFR(ID,IS,IPTST) * SIGACT                40.00
                WBRK = WBRK + PLWBRK(ID,IS,IPTST) * SIGACT                40.00
C
C               *** nonlinear interactions ***
C
                TRIA = TRIA + PLTRI(ID,IS,IPTST) * SPCSIG(IS)             40.00
C
                NL4S = NL4S + PLNL4S(ID,IS,IPTST) * SPCSIG(IS)            40.00
C
                IF ( IQUAD .EQ. 1) THEN
                  NL4D = NL4D + PLNL4D(ID,IS,IPTST) * SIGACT              40.00
                END IF
C
C               *** energy density ***
C
                ENERGY = ENERGY + SIGACT                                  40.00
 
 150          CONTINUE
              NL4 = NL4S + NL4D
C             factor 2*PI introduced to account for density per Hz        40.00
C             instead of per rad/s.
C             factor DDIR is due to integration over directions
              FAC = PI2 * DDIR
              WRITE (IFS1D,170) ENERGY*FAC, SWND*FAC, WCAP*FAC,           40.00
     &                          BTFR*FAC, WBRK*FAC, TRIA*FAC, NL4*FAC     40.00
 170          FORMAT(8(1X,E12.4))                                         40.00
 160        CONTINUE
          ENDIF
        ENDIF
C
C       output of 2D distributions of source terms
C
        IF (IFS2D.GT.0) THEN
          IF (DEP2(INDX).LE.0.) THEN
            DO LOOP = 1, 7
              WRITE (IFS2D, 80) 'NODATA'                                  40.03
            ENDDO
          ELSE
            DO IS = 1, MSC
              DO ID = 1, MDC
                SIGACT = SPCSIG(IS) * AC2(ID,IS,INDX)
                PLWNDA(ID,IS,IPTST) = PLWNDA(ID,IS,IPTST) * SPCSIG(IS)    40.00
     &                              + PLWNDB(ID,IS,IPTST) * SIGACT
                PLWCAP(ID,IS,IPTST) = PLWCAP(ID,IS,IPTST) * SIGACT
                PLBTFR(ID,IS,IPTST) = PLBTFR(ID,IS,IPTST) * SIGACT
                PLWBRK(ID,IS,IPTST) = PLWBRK(ID,IS,IPTST) * SIGACT
                PLNL4S(ID,IS,IPTST) = PLNL4S(ID,IS,IPTST) * SPCSIG(IS)
     &                              + PLNL4D(ID,IS,IPTST) * SIGACT
C               PLWNDB is used temporarily for energy density             40.00
                PLWNDB(ID,IS,IPTST) = SIGACT
              ENDDO
            ENDDO
            CALL WRSPEC (IFS2D, PLWNDB(1,1,IPTST))                        40.00
            CALL WRSPEC (IFS2D, PLWNDA(1,1,IPTST))
            CALL WRSPEC (IFS2D, PLWCAP(1,1,IPTST))
            CALL WRSPEC (IFS2D, PLBTFR(1,1,IPTST))
            CALL WRSPEC (IFS2D, PLWBRK(1,1,IPTST))
            CALL WRSPEC (IFS2D, PLTRI(1,1,IPTST))
            CALL WRSPEC (IFS2D, PLNL4S(1,1,IPTST))
          ENDIF
        ENDIF
C
C       *** set arrays zero: ***
C
        DO 200 IS = 1, MSC
          DO 100 ID = 1, MDC
            PLWNDA(ID,IS,IPTST) = 0.
            PLWNDB(ID,IS,IPTST) = 0.
            PLWCAP(ID,IS,IPTST) = 0.
            PLBTFR(ID,IS,IPTST) = 0.
            PLWBRK(ID,IS,IPTST) = 0.
            PLTRI(ID,IS,IPTST)  = 0.
            PLNL4S(ID,IS,IPTST) = 0.
            PLNL4D(ID,IS,IPTST) = 0.
 100      CONTINUE
 200    CONTINUE
C
 300  CONTINUE
C
      RETURN
C     end of subroutine PLTSRC
      END
