!NRL: $Id: swancom5.F,v 1.3.2.1 2003/03/31 18:49:23 campbell Exp $
!NRL: $Name:  $
C     Last change:  YGH   4 Oct 2000    3:55 pm
C
C     SWAN/COMPU    file 5 of 6
C
C
C     PROGRAM SWANCOM5.FOR
C
C     This file SWANCOM5 of the main program SWAN
C     includes the next subroutines (mainly subroutines for
C     the propagation in x,y,s,d space and parameters ) :
C
C
C     SWPSEL  ( determine spectral counters in presence
C               or absence of a current)
C     SPROXY  ( compute spatial propagation velocities CAX, CAY )
C     SPROSD  ( compute spectral propagation velocities CAS, CAD )
!     DSPHER  ( compute Ctheta for propagation over the globe )           33.09
C     STRSXY  ( compute derivative in space and time )
!     SORDUP  ( compute spatial derivatives with 2d order scheme )        33.10
!     SANDL   ( compute spatial derivatives with S&L scheme )             33.08
C     STRSSI  ( compute derivative in s-space implicit scheme )
C     STRSSB  ( compute derivative in s-space explicit scheme and
C               remove (or dissipate bin's that are blocked)
C     STRSS1  ( compute derivative in s-space according to TOLMAN ->
C               this subroutine is not activated in SWAN since it is
C               based on a nonstationary model (limiting with dt))
C     STRSD   ( compute derivative in d-space implicit )
C     SWAPAR  ( compute wave parameters k, cgo, cg )
C     SPREDT  ( calculate action density in central point:first guess)
C     SOLDIF  (solve the matrix in frequency space for each direction
C              --> adding diffusion to the frequency spectrum in case
C                  of wave blocking
C     ADDDIS  (adds leak and dissipation to arrays in COMPDA, after
C              action densities have been computed)
C
C******************************************************************
C
       SUBROUTINE SWPSEL(SWPDIR    ,           IDCMIN    ,                40.00
     &                   IDCMAX    ,SECTOR    ,CAX       ,
     &                   CAY       ,ANYBIN    ,
     &                              ISCMIN    ,
     &                   ISCMAX    ,IDTOT     ,ISTOT     ,
     &                   IDDLOW    ,IDDTOP    ,ISSTOP    ,
     &                   DEP2      ,UX2       ,UY2       ,
     &                   SPCDIR    ,           XCGRID    ,
     &                   YCGRID    ,RDX       ,RDY       ,
     &                   KSX       ,KSY       ,KGRPNT                     40.13 30.21
     &                                                    )
C
C******************************************************************
C
      INCLUDE 'swcomm1.inc'                                               40.13
      INCLUDE 'swcomm2.inc'                                               33.09
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     30.82: IJsbrand Haagsma
C     33.09, 40.00, 40.13: Nico Booij
C
C  1. Updates
C
C     20.44, Sep. 96: Subroutine completely reorganised subroutine has new name
C                     instead of COUNT
C     32.02, Feb. 98: Introduced 1D-version
C     40.00, July 98: common swcomm3 introduced, argument list changed
C     30.82, Oct. 98: Updated description of several variables
C     33.09         : spherical ccordinates introduced
C                     repeating x-axis introduced
C     40.03, Nov. 99: error messages (see formats 555 and 556) corrected
C     40.13, Mar. 01: argument KGRPNT added in view of debug output
C                     error severity changed for "blocked" points
C                     "blocked" points written to error points file
C                     comments added
C                     minimal value of ISSTOP is 4 (in view of CGSTAB solver)
C     40.13, July 01: values of DX2 and DY2 corrected in repeating coordinates
C
C  2. PURPOSE
C
C     compute the frequency dependent counters in a situation
C     with a current and without a current.
C     The counters are only computed for the gridpoint
C     considered. This means IC = 1 (see loop with CALL for ICCODE
C     fucntion)
C
C  3. METHOD
C
C     In absence of a current the fully 360 degrees sector is
C     subdivided in 4 sectors of 90 degrees each.
C
C     In presence of a current this is not the case anymore. The
C     counters if directional space are frequency dependent. It is
C     first determined which bins have to taken into account for
C     a particular sweep (unconditionalyy stable for a specific
C     sector). To which sector a bin belongs is determined by its
C     propagation velocity Cx and Cy.
C
C     For the first sweep.....
C     All the bins with a positive propagation velocity Cx and Cy
C     have to taken into account for the first sweep.
C     For one particular frequency:
C
C
C                           #
C                        -  #  +     +
C                    -      #              +     CAX, CAY > 0
C               -           #      |
C                    iddmax # ..*..*..*          +
C            -              #\.....|.....*
C                          *#  \...|.......*       +
C          -                #    \.|........
C                       --*-#------O--------*--     +
C                           #      | \......
C          -               *#      |   \...*        +
C     # # # # # # # # # # # # # # # # # #\# # # # # # # # #
C                           #  *   *   *  iddmin
C           -               #      |               -
C                           #
C                           #                    -
C              -            #
C                                            -
C                  -                       -
C                          -     -   -
C
C
C     as can be seen from the figure, the minimum and maximum
C     counter are determined by the vectorsum of the its group-
C     velocity and its current velocity. Especially the higher
C     frequencies are modified by the current. The lower frequencies
C     (due to the larger propagation velocity) are less modified
C     by a current.
C
C     In general 4 cases can occur:
C
C     SWEEP 1:
C                                              ..*..
C                                           *.........*
C                                         |. ............      |   *..*
C            |              |            *|    ..o.......*     | *......*
C            |             *|*            |...... .......      | *......*
C            |           *  |..*          |*...     ....*      |   *..*
C       -----|-----    -*---|---*-   -----|--*-------*--    ---|-------------
C            |           *  |  *          |      *             |
C       * *  |             *|*            |#                   |
C     *     *|              |             |                    |
C       * *
C
C     SECTOR = 0        SECTOR = 2        SECTOR = 4       SECTOR = 1
C
C
C     The integer array SECTOR denotes which case is present for
C     a certain frequency:
C
C     0  : no bins belongs to first sweep, no sector lies within the
C          first sweep
C     2  : circle has 2 intersections with sector boundary
C     4  : circle has 4 intersections with sector boundary
C     1  : full circle lies within the first quadrant, all directions
C          have to taken into account
C
C     Furthermore it is detemined whether a certain BIN lies within
C     a specific quadrant. This is denoted by a logical array ANYBIN
C     In case of SECTOR = 4 this array is used to clear the rows
C     in the matrix IMATDA, IMATRA, IMATLA, IMATUA, which do not
C     belong to the first (or other ) sweep.
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C     XCGRID: Coordinates of computational grid in x-direction            30.82
C     YCGRID: Coordinates of computational grid in y-direction            30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.82
C
C     INTEGERS:
C     --------------------------------------------------------------
C     IXCGRD(1)                Counter of gridpoints in x-direction
C     IYCGRD(1)                Counter of gridpoints in y-direction
C     IS                Counter of relative frequency band
C     ID                Counter of directional distribution
C     ICUR              Indicator for current
C     ICMAX             Indicator for nearby nodes
C     MSC               Maximum counter of relative frequency in
C                       computational model
C     MDC               Maximum counter of directional distribution in
C                       computational model (2PI / DD + 1)
C     IDTOT             Maximum value between the lowest and highest
C                       counter in directional space
C     ISTOT             Maximum value between the lowest and highest
C                       counter in frequency space
C
C     FULCIR   logical: if true, computation on a full circle
C
C
C     REALS:
C     --------------------------------------------------------------
C     DD       input    Width of directional band
C
C     array's
C     -------
C
C     CAX     3D  propagation velocity
C     CAY     3D  propagation velocity
C     IDCMIN  1D  minimum frequency dependent counter (INTEGER)
C     IDCMAX  1D  maximum frequency dependent counter (INTEGER)
C     ISCMIN  1D  minimum counter in frequency space
C     ISCMAX  1D  maximum counter in frequency space
C     SECTOR  1D  Counter for number enclosed sectors (INTEGER)
C     ANYBIN  2D  Is a certain bin enclosed in a sweep (LOGICAL)
C     SPCDIR  1D  spectral directions                                     20.44
C     RDX,RDY 1D  array  containing spatial derivative coeff
!
      INTEGER, INTENT(IN)  :: KGRPNT(1:MXC,1:MYC)  ! grid addresses       40.13
C
C  6. Local variables
C
C     VIRT  : To define virtual point for 1D mode                         32.02
C
      REAL    VIRT                                                        32.02
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SWANCOMP
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------
C     If current is on AND the current velocity is not equal zero then
C         compute for every frequency for every sweep the minimum
C         and maximum counters.
C         The minimum counter denotes the conversion from -- to ++
C         The maximum counter denotes the conversion from ++ to --
C
C         ++++++++++ ---------- +++++++++
C                 IDCMAX      IDCMIN
C
C         --------- ++++++++++ ----------
C                IDCMIN      IDCMAX
C
C     else if current is off or Ux=0 m/s and Uy = 0 m/s.
C         Without currents the counters are constant during the
C         computation, i.e., 4 sectors of 90 degrees
C     --------------------------------------------------------
C     End of SWPSEL
C     --------------------------------------------------------
C
C 13. Source text
C
      INTEGER   IS    ,ID    ,                     SWPDIR,                40.00
     &                 IDSUM ,IDCLOW,IDCHGH,
     &          IDTOT ,ISTOT ,
     &          IDDLOW,IDDTOP,ISSLOW,ISSTOP
C
      REAL      CAXMID,CAYMID                                             40.00
C
      INTEGER   IDCMIN(MSC)     ,
     &          IDCMAX(MSC)     ,
     &          ISCMIN(MDC)     ,
     &          ISCMAX(MDC)     ,
     &          SECTOR(MSC)
C
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  ::  CAX(MDC,MSC,MICMAX)                                       40.22
      REAL  ::  CAY(MDC,MSC,MICMAX)                                       40.22
      REAL  ::  DEP2(MCGRD)         ,
     &          UX2(MCGRD)          ,
     &          UY2(MCGRD)          ,
     &          RDX(2)              ,
     &          RDY(2)
C
      LOGICAL   ANYBIN(MDC,MSC)     ,
     &          LOWEST, LOWBIN, HGHBIN
C
      SAVE IENT
      DATA IENT/0/
         CALL STRACE (IENT,'SWPSEL')
C
C     *** initialize array's in theta direction ***
C
      DO 50 IS = 1, MSC
        IDCMIN(IS) = 0
        IDCMAX(IS) = 0
        SECTOR(IS) = 0
        DO 49 ID = 1, MDC
          ANYBIN(ID,IS) = .FALSE.
 49     CONTINUE
 50   CONTINUE
C
C     *** initialize arrays in frequency direction ***
C
      DO 48 ID = 1, MDC
        ISCMIN(ID) = 1
        ISCMAX(ID) = 1
 48   CONTINUE
C
C     *** set variables ***
C
      IDTOT = 1
      ISTOT = 1
C
*
*     ***________________________ VERSION 30.21 __________________________
*     ***  Computation of quantities between neighbouring grid points***
      IF (ITEST .GE. 200 .AND. SWPDIR .EQ. 1 .AND.
     &    IXCGRD(1) .EQ. 2 .AND. IYCGRD(1) .EQ. 2)  THEN
        WRITE(PRINTF,185) IXCGRD(1) ,IYCGRD(1)
 185    FORMAT(1X,'Coordinates of computational grid points',/,
     &            '        in subroutine SWPSEL (pivoting; ',2I5,') ')
        DO J = 1, MYC
          DO I = 1, MXC
            WRITE (PRTEST,305) I, J, XCGRID(I,J), YCGRID(I,J)
 305        FORMAT (2(2X,I5),2(2X,E12.4))
          ENDDO
        ENDDO
      ENDIF
C
      IF (KREPTX.GT.0) THEN                                               33.09
!       repeating x-axis (only regular grids)
        IF (SWPDIR.EQ.1 .OR. SWPDIR.EQ.4) THEN
          DX1 = DX * COSPC                                                33.09
          DY1 = DX * SINPC                                                33.09
        ELSE
          DX1 = -DX * COSPC                                               33.09
          DY1 = -DX * SINPC                                               33.09
        ENDIF
        IF (ONED) THEN                                                    33.09
          VIRT = 1.E6                                                     33.09
          IF ( SWPDIR .EQ. 1 .OR. SWPDIR .EQ. 3 ) THEN                    33.09
            DX2 = -VIRT * DY1                                             33.09
            DY2 =  VIRT * DX1                                             33.09
          ELSE                                                            33.09
            DX2 =  VIRT * DY1                                             33.09
            DY2 = -VIRT * DX1                                             33.09
          ENDIF                                                           33.09
        ELSE                                                              33.09
          IF (SWPDIR.LE.2) THEN                                           40.13
            DX2 = - DY * SINPC                                            40.13
            DY2 = DY * COSPC                                              40.13
          ELSE                                                            40.13
            DX2 = DY * SINPC                                              40.13
            DY2 = - DY * COSPC                                            40.13
          ENDIF                                                           40.13
        ENDIF                                                             33.09
      ELSE                                                                33.09
 
        DX1 = XCGRID(IXCGRD(1),IYCGRD(1)) - XCGRID(IXCGRD(2),IYCGRD(2))
        DY1 = YCGRID(IXCGRD(1),IYCGRD(1)) - YCGRID(IXCGRD(2),IYCGRD(2))
        IF  ( ONED ) THEN                                                 32.02
 
!         *** Inclusion of virtual point ***                              32.02
 
          VIRT = 1.E6                                                     32.02
          IF ( SWPDIR .EQ. 1 .OR. SWPDIR .EQ. 3 ) THEN                    32.02
            DX2 = -VIRT * DY1                                             32.02
            DY2 =  VIRT * DX1                                             32.02
          ELSE IF ( SWPDIR .EQ. 2 .OR. SWPDIR .EQ. 4 ) THEN               32.02
            DX2 =  VIRT * DY1                                             32.02
            DY2 = -VIRT * DX1                                             32.02
          ENDIF                                                           32.02
        ELSE                                                              32.02
          DX2 = XCGRID(IXCGRD(1),IYCGRD(1))-XCGRID(IXCGRD(3),IYCGRD(3))
          DY2 = YCGRID(IXCGRD(1),IYCGRD(1))-YCGRID(IXCGRD(3),IYCGRD(3))
        ENDIF                                                             32.02
      ENDIF                                                               33.09
C
      DET    =  DY2*DX1 - DY1*DX2
      RDX(1) =  DY2/DET
      RDY(1) = -DX2/DET
      RDX(2) = -DY1/DET
      RDY(2) =  DX1/DET
!
!     in case of spherical coordinates determine cos of latitude
!     note: latitude is in degrees
!
      IF (KSPHER.GT.0) THEN
        DO IC = 1, ICMAX
          COSLAT(IC) =
     &    COS(DEGRAD*(YCGRID(IXCGRD(IC),IYCGRD(IC))+YOFFS))               33.09
        ENDDO
        DO IXY = 1, 2
          RDY(IXY) = RDY(IXY) / LENDEG                                    33.09
          RDX(IXY) = RDX(IXY) / (COSLAT(1) * LENDEG)                      33.09
        ENDDO
      ENDIF
C
      IF (TESTFL .AND. ITEST .GE. 30) THEN
        WRITE(PRINTF,186)
 186    FORMAT(' ...POINTS IN STENCIL IN SUBROUTINE SWPSEL...',
     &  /,'Point: IC,  Ix,  Iy, INDEX,        Xc,        Yc')
        DO IC = 1, 3
          WRITE(PRINTF,187) IC, IXCGRD(IC), IYCGRD(IC), KCGRD(IC),
     &    XCGRID(IXCGRD(IC),IYCGRD(IC)),YCGRID(IXCGRD(IC),IYCGRD(IC))
 187      FORMAT(3(1X,I4),3X,I5,5X,F10.2,4X,F10.2)
        ENDDO
        WRITE(PRINTF,188) DET,RDX(1),RDX(2),RDY(1),RDY(2)
 188    FORMAT('  DET,       RDX1,      RDX2,      RDY1,     RDY2',/,
     &  5(E10.4,1X))
      ENDIF
*___________________________________________________________________
*
*     *** For curvilinear version we do not distinguish if    ***
*     *** there is current or not, to know if certain bin     ***
*     *** belongs to certain sweep              VER. 30.21    ***
C
C       *** calculate minimum and maximum counters in theta space ***
C       *** if a current is present: IDCMIN and IDCMAX            ***
C
*
************************************************************************
*         determine for each bin whether it is in the sweep considered *
************************************************************************
*       *** DO LOOP totally organizated for curvilinear 30.21***
 
      ISSLOW = 9999                                                       40.13
      ISSTOP = -9999                                                      40.13
 
      DO 500 IS = 1, MSC
        IDCLOW  = 0
        IDCHGH  = 0
        IDSUM   = 0
        DO ID = 1, MDC
          IF (IS .EQ. 1 .OR. ICUR .GT. 0) THEN
            CAXMID = CAX(ID,IS,1)*RDX(1) + CAY(ID,IS,1)*RDY(1)
            CAYMID = CAX(ID,IS,1)*RDX(2) + CAY(ID,IS,1)*RDY(2)
            IF (CAXMID .GE. 0. .AND. CAYMID .GE. 0.) THEN
              ANYBIN(ID,IS) = .TRUE.
              IDSUM = IDSUM + 1
              ISSLOW = MIN(IS,ISSLOW)                                     40.13
              ISSTOP = MAX(IS,ISSTOP)                                     40.13
            ENDIF
            IF (TESTFL .AND. ITEST .GE. 190)                              40.00
     &      WRITE(PRINTF,333) IS,ID,CAXMID,CAYMID,ANYBIN(ID,IS)
 333        FORMAT( ' IS ID CXM CYM ANYBIN :',2(1X,I4),2(1X,E11.4),L2)
          ELSE
!           no current: if bin IS=1 is in sweep, all with same ID are     40.13
            ANYBIN(ID,IS) = ANYBIN(ID,1)
            IF (ANYBIN(ID,1)) THEN
              IDSUM = IDSUM + 1
              ISSTOP = MAX(IS,ISSTOP)                                     40.13
            ENDIF
          ENDIF
        ENDDO
*
*       determine boundaries of sector
*
        DO 400 ID = 1, MDC
          LOWBIN = .FALSE.
          HGHBIN = .FALSE.
          IF (ANYBIN(ID,IS)) THEN
!           check if this active bin is a lower Theta-boundary            40.13
            IF ( ID .EQ. 1 ) THEN
              IF (FULCIR) THEN
                IF (.NOT.ANYBIN(MDC,IS)) LOWBIN = .TRUE.                  40.00
              ELSE
                LOWBIN = .TRUE.                                           40.00
              ENDIF
            ELSE
              IF (.NOT.ANYBIN(ID-1,IS)) LOWBIN = .TRUE.
            ENDIF
!           check if this active bin is a higher Theta-boundary           40.13
            IF ( ID .EQ. MDC ) THEN
              IF (FULCIR) THEN
                IF (.NOT.ANYBIN(1,IS)) HGHBIN = .TRUE.                    40.00
              ELSE
                HGHBIN = .TRUE.                                           40.00
              ENDIF
            ELSE
              IF (.NOT.ANYBIN(ID+1,IS)) HGHBIN = .TRUE.
            ENDIF
          END IF
          IF (LOWBIN) THEN
            SECTOR(IS) = SECTOR(IS) + 1
            IDCLOW = ID
          ENDIF
          IF (HGHBIN) THEN
            SECTOR(IS) = SECTOR(IS) + 1
            IDCHGH = ID
          ENDIF
 400    CONTINUE
*       check value of SECTOR
        IF (SECTOR(IS).EQ.1 .OR. SECTOR(IS).EQ.3) WRITE (PRTEST, 410)
     &          SWPDIR, IS, SECTOR(IS), IDSUM, IDCLOW, IDCHGH
 410    FORMAT (' error SWPSEL directions ', 6I6)
*        *** set the minimum and maximum counters for a sweep ***
*
        IF ( IDSUM .EQ. MDC ) THEN
          IF (FULCIR .AND. SECTOR(IS).NE.0) WRITE (PRTEST, 410)
     &          SWPDIR, IS, SECTOR(IS), IDSUM, IDCLOW, IDCHGH
          IDCMIN(IS) = 1
          IDCMAX(IS) = MDC
          SECTOR(IS) = 1
        ELSE IF ( IDSUM .EQ. 0 ) THEN
!         for this IS there are no active bins
          IF (SECTOR(IS).NE.0) WRITE (PRTEST, 410) SWPDIR, IS,
     &          SECTOR(IS), IDSUM, IDCLOW, IDCHGH
!         new values assigned because old ones cause problems in SWSNL2   40.13
          IDCMIN(IS) = 9                                                  40.13
          IDCMAX(IS) = -9                                                 40.13
          SECTOR(IS) = 0
        ELSE
          IF ( IDCLOW .GT. IDCHGH ) IDCLOW = IDCLOW - MDC
          IDCMIN(IS) = IDCLOW
          IDCMAX(IS) = IDCHGH
        END IF
C
C       *** if 4 sectors are present then set counters ***
C
        IF ( SECTOR(IS) .GT. 2 ) THEN                                     10/MAR
          IDCMIN(IS) = 1
          IDCMAX(IS) = MDC
        END IF
C
 500  CONTINUE
C
C     *** calculate minimum and maximum counters in frequency ***
C     *** space if a current is present: ISCMIN and ISCMAX    ***
C
      IDDLOW = 9999
      IDDTOP = -9999
      DO IS = 1 , MSC
        IF ( SECTOR(IS) .GT. 0 ) THEN
          IDDLOW = MIN ( IDDLOW , IDCMIN(IS) )
          IDDTOP = MAX ( IDDTOP , IDCMAX(IS) )
        END IF
      ENDDO
C
C     *** Determine counters for a certain sweep ***
C
      DO 530 IDDUM = IDDLOW, IDDTOP
        ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        LOWEST = .TRUE.
        DO 430 IS = 1, MSC
          IF (ANYBIN(ID,IS)) THEN
            IF ( LOWEST ) THEN
              ISCLOW = IS
              LOWEST = .FALSE.
            ENDIF
            ISCHGH = IS
          END IF
 430    CONTINUE
*
*       *** set the minimum and maximum counters in arrays ***
*
        IF (.NOT.LOWEST) THEN
          ISCMIN(ID) = ISCLOW
          ISCMAX(ID) = ISCHGH
          IF (ISCMIN(ID).LT.ISSLOW) WRITE (PRINTF,*)
     &    ' error SWPSEL, ISSLOW=', ISSLOW, 'ISCMIN=', ISCMIN(ID),
     &    ' for ID=', ID
          IF (ISCMAX(ID).GT.ISSTOP) WRITE (PRINTF,*)
     &    ' error SWPSEL, ISSTOP=', ISSTOP, 'ISCMAX=', ISCMAX(ID),
     &    ' for ID=', ID
        ELSE
C         *** no frequencies fall within the sweep ***
          ISCMIN(ID) = 0
          ISCMAX(ID) = 0
        ENDIF
C
 530  CONTINUE
C
C     *** calculate the maximum number of counters in both ***
C     *** directional space and frequency space            ***
C
      IF (IDDLOW.NE.9999) THEN
        IF (IDDTOP.EQ.-9999) WRITE (PRTEST, 545) IDDLOW, IDDTOP
 545    FORMAT (' error SWPSEL min & max dir ', 5I7)
        IDTOT = ( IDDTOP - IDDLOW ) + 1
*       in view of CGSTAB solver IDTOT must be >= 3:
        IF (ICUR .EQ. 1) THEN
          IF (IDTOT.LT.3) THEN
            IDDTOP = IDDTOP + 1
            IF (IDTOT.EQ.1) IDDLOW = IDDLOW - 1
            IDTOT = 3
          ENDIF
        ENDIF
      ELSE
        IF (IDDTOP.NE.-9999) WRITE (PRTEST, 545) IDDLOW, IDDTOP
        IDTOT = 0
      ENDIF
C
      IF (ISSLOW.NE.9999) THEN
        IF (ITEST.GE.20) THEN                                             40.13
          IF (ISSLOW.NE.1 .OR. ISSTOP.EQ.-9999)
     &    WRITE (PRTEST, 555) IXCGRD(1)-1, IYCGRD(1)-1, ISSLOW, ISSTOP    40.13
 555      FORMAT (' error SWPSEL in:', 2I5,',  min & max freq ', 5I7)     40.13
        ENDIF                                                             40.13
        ISSLOW = 1
!       minimal value of ISSTOP is 4 (or MDC if MDC<4)                    40.13
        IF (ICUR.GT.0) ISSTOP = MAX(MIN(4,MSC),ISSTOP)                    40.13
        ISTOT = ( ISSTOP - ISSLOW ) + 1
      ELSE
        IF (ISSTOP.NE.-9999) WRITE (PRTEST, 555) IXCGRD(1)-1,
     &              IYCGRD(1)-1, ISSLOW, ISSTOP
        ISTOT = 0
        IF (IDTOT.NE.0) WRITE (PRTEST, 556) IXCGRD(1)-1,
     &              IYCGRD(1)-1, ISSLOW, ISSTOP, IDDLOW, IDDTOP           40.03
 556    FORMAT (' error SWPSEL in:', 2I5,'  min&max freq&dir ', 5I7)      40.03
      ENDIF
C
C     *** check if IDTOT is less then MDC ***
C
      IF ( IDTOT .GT. MDC ) THEN
        IDDLOW = 1
        IDDTOP = MDC
        IDTOT  = MDC
      END IF
C
C     *** check if the lowest frequency is not blocked !    ***
C     *** this can occur in real cases if the depth is very ***
C     *** small and the current velocity is large           ***
C     *** the propagation velocity Cg = sqrt (gd) < U       ***
C
C
      IF (ICUR .EQ. 1 .AND. FULCIR .AND.
     &    ISSLOW.NE.1 .AND. ISSLOW.NE.9999) THEN                          40.13
!       error severity changed from 3 to 2                                40.13
        CALL MSGERR (2,'The lowest freq. is blocked')                     40.13
        write (printf, 612) ' at point:', ixcgrd(1)-1, iycgrd(1)-1,       40.13
     &      ' dep=', dep2(kcgrd(1)),
     &      '  U=', ux2(kcgrd(1)), uy2(kcgrd(1))
 612    format (A, 2I4, A, F6.2, A, 2F6.2)                                40.13
        IF (ITEST.GE.10) THEN
          write (printf, 614) ' spectral limits:', istot, isslow,
     &    isstop, idtot, iddlow, iddtop
 614      format (A, 6I8)
          write (printf, 616) ' sweep=', swpdir,
     &    ', interpolation coeff.:', rdx(1), rdy(1), rdx(2), rdy(2)
 616      format (A, I1, A, 2(1X, 2E12.4))
          IF (ITEST.GE.60) THEN
            if (ixcgrd(1).gt.1 .and. ixcgrd(1).lt.mxc .and.
     &          iycgrd(1).gt.1 .and. iycgrd(1).lt.myc) then
              write (printf, *) ' surrounding points'
              do iy=-1,1
                write (printf, 621)
     &          (kgrpnt(ixcgrd(1)+ix,iycgrd(1)+iy), ix=-1,1),
     &          (dep2(kgrpnt(ixcgrd(1)+ix,iycgrd(1)+iy)), ix=-1,1),
     &          (ux2(kgrpnt(ixcgrd(1)+ix,iycgrd(1)+iy)), ix=-1,1),
     &          (uy2(kgrpnt(ixcgrd(1)+ix,iycgrd(1)+iy)), ix=-1,1)         40.13
 621            format (1x, 3i6, 3(' | ', 3f9.2))
              enddo
            endif
          ENDIF
        endif
!       write this point to ERRPTS file (BLOCKed option)                  40.13
        IF (ERRPTS.GT.0) WRITE(ERRPTS,7002) IXCGRD(1), IYCGRD(1), 3       40.13
 7002   FORMAT (I4, 1X, I4, 1X, I2)                                       40.13
        IC = 1
        GROUP = SQRT ( GRAV * DEP2(KCGRD(IC)) )
        UABS  = SQRT ( UX2(KCGRD(IC))**2 + UY2(KCGRD(IC))**2 )
        IF ( UABS .GT. GROUP ) THEN
          WRITE(PRINTF,1002) IXCGRD(IC)-1, IYCGRD(1)-1, UABS, GROUP       40.13
 1002     FORMAT(' warning, at point:',2I4,' |U|=',F8.2,' > Cg=',F8.2)    40.13
        ENDIF
      ENDIF
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 30 ) THEN
        IC = 1                                                            40.00
        WRITE (PRTEST,6020) KCGRD(IC),SWPDIR,ICUR
 6020   FORMAT (' subr SWPSEL: Point  SWPDIR ICUR :',3I5 )                40.00
        WRITE (PRTEST,6220) IDDLOW, IDDTOP ,ISSLOW, ISSTOP
 6220   FORMAT ('      IDDLOW IDDTOP ISSLOW ISSTOP:',4I4 )
        WRITE (PRTEST,6320) IDTOT , ISTOT
 6320   FORMAT ('      IDTOT ISTOT                :',4I4 )
        IF (ITEST.GE.120) THEN                                            40.00
          WRITE(PRTEST,*) ' Counters in directional space '
          WRITE(PRTEST,*) '       IS     IDCMIN  IDCMAX  SECTOR'          40.00
          DO IS = ISSLOW, ISSTOP
            WRITE(PRTEST,509) IS, IDCMIN(IS), IDCMAX(IS) , SECTOR(IS)
 509        FORMAT(2X,I5,3X,3I8)
          ENDDO
          WRITE(PRTEST,*) ' Counters in frequency space '
          WRITE(PRTEST,*) '       ID     ISCMIN  ISCMAX  THETA'
          DO IDDUM = IDDTOP, IDDLOW, -1
            ID = MOD ( IDDUM - 1 + MDC, MDC) + 1
            THDIR = SPCDIR(ID,1) * 180. / PI
            WRITE(PRTEST,519) ID, ISCMIN(ID), ISCMAX(ID), THDIR
 519        FORMAT(2X,I5,3X,2I8,3X,F8.2)
          ENDDO
          WRITE(PRTEST,*)
        ENDIF                                                             40.00
        IF (IDTOT.GT.0) THEN
          IF (ITEST.GE.90) THEN                                           40.00
            WRITE(PRTEST,122) IDDLOW, IDDTOP
 122        FORMAT (' Active bins in spectral space -> ID: ',
     &              I3,' to ',I3)
            DO IDDUM = IDDTOP+1, IDDLOW-1, -1
              ID = MOD ( IDDUM - 1 + MDC, MDC) + 1
              WRITE(PRTEST,124)
     &            ID, (ANYBIN(ID,IS),IS=ISSLOW, MIN(ISSTOP,25))           40.00
 124          FORMAT(I4,25L3)
            ENDDO
            WRITE(PRTEST,125)(IS, IS=ISSLOW+4, MIN(ISSTOP,25), 5 )
 125        FORMAT(6X,'1',9X,5(I3,12X))
            WRITE(PRTEST,*)
          ENDIF                                                           40.00
        ELSE
          WRITE(PRTEST,123) SWPDIR
 123      FORMAT (' No active bins in sweep', I2)
        ENDIF
        IF ( ICUR .EQ. 0 ) THEN
          WRITE (PRTEST,615) IDDLOW, IDDTOP
 615      FORMAT (' SWPSEL: IDDLOW IDDTOP  :',5(1X,I3))
        END IF
      END IF
C
C     End of the subroutine SWPSEL
C
      RETURN
      END
C
C
C****************************************************************
C
      SUBROUTINE SPROXY (            ICMAX      ,MSC        ,
     &                   MDC        ,ICUR       ,CAX        ,
     &                   CAY        ,CGO        ,ECOS       ,
     &                   ESIN       ,UX2        ,UY2        ,
     &                   SWPDIR     ,KCGRD      ,MCGRD                    30.21
     &                                                      )
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     1. UPDATE
C
C        40.13, Oct. 01: loop over IC now inside this subroutine
C
C     2. PURPOSE
C
C        computes the propagation velocities of energy in X-, Y-
C        -space, i.e., CAX, CAY, in the presence or absence of
C        currents, for the action balance equation.
C
C        The propagation velocities are computed for the fully 360
C        degrees sector.
C
C     3. METHOD
C
C        The next equation are calculated:
C
C              @X     _
C        CAX = -- = n C cos (id) + Ux  = CGO cos(id) + Ux
C              @T
C
C              @Y     _
C        CAY = -- = n C sin(id)  + Uy  = CGO sin(id) + Uy
C              @T
C                                                         _
C     4. PARAMETERLIST
C
C        IC       Dummy variable: ICode gridpoint:
C                 IC = 1  Top or Bottom gridpoint
C                 IC = 2  Left or Right gridpoint
C                 IC = 3  Central gridpoint
C                Whether which value IC has, depends of the sweep
C                If necessary ic can be enlarged by increasing
C                the array size of ICMAX
C        IX      Counter of gridpoints in x-direction
C        IY      Counter of gridpoints in y-direction
C        IS      Counter of relative frequency band
C        ID      Counter of directional distribution
C        ICUR    Indicator for current
C        ICMAX   Maximum array size for the points of the molecul
C        MXC     Maximum counter of gridppoints in x-direction
C        MYC     Maximum counter of gridppoints in y-direction
C        MSC     Maximum counter of relative frequency
C        MDC     Maximum counter of spectral directions
C
C        REAL:
C        ----
C        COEF    auxiliary coefficient
C        VLSINH  value of the SINH for a certain value of 2KD
C
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        CAX    3D    Wave transport velocity in x-dirction, function of
C                     (ID,IS,IC)
C        CAY    3D    Wave transport velocity in y-dirction, function of
C                     (ID,IS,IC)
C        CGO    2D    group velocity
C        DEP2   2D    (Nonstationary case) depth as function of X and Y
C                     at time T+DIT
C        ECOS   1D    Represent the values of cos(d) of each spectral
C                     direction
C        ESIN   1D    Represent the values of sin(d) of each spectral
C                     direction
C        KWAVE  2D    wavenumber as function of the relative frequency S
C        UX2    2D    X-component of current velocity of X and Y at
C                     time T+1
C        UY2    2D    Y-component of current velocity of X and Y at
C                     time T+1
C
C     5. SUBROUTINES CALLING
C
C        ---
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C     9. STRUCTURE
C
C       ******************************************************************
C       *  attention! in the action balance equation the term            *
C       *  dx                                                            *
C       *  AA = CGO + U = CX  with x, CGO, U and CX vectors              *
C       *  dt                                                            *
C       *  is in the literature the term dx/dt often indicated           *
C       *  with CX and CY in the action balance equation.                *
C       *  In this program we use:    CAX = CGO + U                      *
C       ******************************************************************
C
C   ------------------------------------------------------------
C   If depth is negative ( DEP(IX,IY) <= 0), then,
C     For every point in S and D-direction do,
C       Give propagation velocities default values :
C       CAX(ID,IS,IC)     = 0.   {propagation velocity of energy in X-dir.}
C       CAY(ID,IS,IC)     = 0.   {propagation velocity of energy in Y-dir.}
C     ---------------------------------------------------------
C   Else if current is on (ICUR > 0) then,
C     For every point in S and D-direction do,  {using the output of SWAPAR}
C       S = logaritmic distributed via LOGSIG
C       Compute propagation velocity in X-direction:
C
C               1    K(IS,IC)DEP2(IX,IY)      S cos(D)
C       CAX = ( - + ------------------------) --------- + UX2(IX,IY)
C               2   sinh 2K(IS,IC)DEP2(IX,IY) |K(IS,IC)|
C
C       ------------------------------------------------------
C       Compute propagation velocity in Y-direction:
C
C               1    K(IS,IC)DEP2(IX,IY)      S sin(D)
C       CAY = ( - + ------------------------) -------- + UY2(IX,IY)
C               2   sinh 2K(IS,IC)DEP2(IX,IY) |K(IS,IC)|
C
C       ------------------------------------------------------
C   Else if current is not on (ICUR = 0)
C     For every point in S and D-direction do
C       S = logaritmic distributed via LOGSIG
C       Compute propagation velocity in X-direction:
C
C               1    K(IS,IC)DEP2(IX,IY)        S cos(D)
C       CAX = ( - + ------------------------) ----------
C               2   sinh 2K(IS,IC)DEP2(IX,IY)  |K(IS,IC)|
C
C       ------------------------------------------------------
C       Compute propagation velocity in Y-direction:
C
C               1    K(IS,IC)DEP2(IX,IY)        S sin(D)
C       CAY = ( - + ------------------------) ----------
C               2   sinh 2K(IS,IC)DEP2(IX,IY)  |K(IS,IC)|
C
C     ----------------------------------------------------------
C   End IF
C   ------------------------------------------------------------
C   End of SPROXY
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IC    ,IS    ,ID    ,MSC    ,
     &         MDC   ,ICMAX ,ICUR  ,SWPDIR ,MCGRD                         30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     CAX(MDC,MSC,ICMAX)          ,
     &         CAY(MDC,MSC,ICMAX)          ,
     &         CGO(MSC,ICMAX)              ,
     &         ECOS(MDC)                   ,
     &         ESIN(MDC)                   ,
     &         UX2(MCGRD)                ,
     &         UY2(MCGRD)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SPROXY')
C
      IF (TESTFL .AND. ITEST .GE. 5 ) WRITE (PRTEST,2)SWPDIR,KCGRD(1)
    2 FORMAT (' Start SPROXY ', 4I5)
C
      DO IC = 1, ICMAX                                                    40.13
        IF ( KCGRD(IC) .LE. 1 ) THEN                                        30.21
          CAX(:,:,IC) = 0.                                                40.13
          CAY(:,:,IC) = 0.                                                40.13
        ELSE
C
          IF (ICUR .EQ. 1)  THEN                                          40.13
C
C       *** current is on ***
C
            DO 60 ID = 1, MDC
              CAX(ID,:,IC) = CGO(:,IC) * ECOS(ID) + UX2(KCGRD(IC))
              CAY(ID,:,IC) = CGO(:,IC) * ESIN(ID) + UY2(KCGRD(IC))
 60         CONTINUE
C
          ELSE
C
C       *** no current ***
C
            DO 80 ID = 1 , MDC
              CAX(ID,:,IC) = CGO(:,IC) * ECOS(ID)                            40.13
              CAY(ID,:,IC) = CGO(:,IC) * ESIN(ID)                            40.13
 80         CONTINUE
          ENDIF
        ENDIF
C
C       *** test output ***
C
        IF ( IC .EQ. 1 .AND. TESTFL .AND. ITEST .GE. 120 ) THEN
          DO IP = 1, ICMAX
            WRITE(PRINTF,6018) IP,KCGRD(IP),
     &                         UX2(KCGRD(IP)),UY2(KCGRD(IP))
          ENDDO
 6018     FORMAT(' SPROXY: IC INDEX UX2 UY2       :', 2I5,
     &           '  UX,UY:', 2(1X,E12.4))
          IF (ITEST.GE.220) THEN                                            40.00
            DO 6002 IS = 1, MSC
              DO 6001 ID = 1, MDC
                WRITE(PRINTF,6020) IS, ID,
     &               (CAX(ID,IS,IP), CAY(ID,IS,IP), IP=1,ICMAX)           40.00
 6020           FORMAT(' IS ID <CAX CAY>:',2I4,10(1X,2E11.4))
 6001         CONTINUE
 6002       CONTINUE
          ENDIF                                                           40.00
        ENDIF
      ENDDO            ! end loop over IC
C
      RETURN
      END subroutine SPROXY
C
C****************************************************************
C
      SUBROUTINE SPROSD (SPCSIG     ,KWAVE      ,CAS        ,             40.03
     &                   CAD        ,CGO        ,                         30.80
     &                   DEP2       ,DEP1       ,ECOS       ,
     &                   ESIN       ,UX2        ,UY2        ,
     &                   SWPDIR     ,IDCMIN     ,IDCMAX     ,
     &                   COSCOS     ,SINSIN     ,SINCOS     ,             30.80
     &                   RDX        ,RDY        ,                         30.80
     &                   CAX        ,CAY        ,ANYBIN     ,             30.80
     &                   KGRPNT     ,XCGRID     ,YCGRID                   30.80
     &                                                      )
C
C****************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm2.inc'                                               30.80
      INCLUDE 'swcomm3.inc'                                               30.80
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'timecomm.inc'                                              40.03
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.80: Nico Booij
C     40.03: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.14: Annette Kieftenburg
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.80, Nov. 98: Provision for limitation on Ctheta (refraction)
C     30.80, Aug. 99: SWCOMM3.INC included
C     30.80, Sep. 99: SWCOMM2.INC included, limitation modified
C     40.03, Dec. 99: for directions outside the current sweep the depth and
C                     current gradients are computed using the gradient at the
C                     proper side of the grid point.
C                     argument KGRPNT added.
C                     argument IC removed (is always 1)
C                     argument DT removed, TIMECOMM.INC included
C                     code completely revised
C     40.02, Jan. 00: Introduction limiter dependent on Cx, Cy, Dx and Dy
C     40.02, Sep. 00: Corrected order of handling sweeps
C     40.02, Sep. 00: Limiter on refraction only activated when IREFR=-1
C     40.14, Nov. 00: Land points exluded (bug fix)
C
C  2. Purpose
C
C     computes the propagation velocities of energy in S- and
C     D-space, i.e., CAS, CAD, in the presence or absence of
C     currents, for the action balance equation.
C
C  3. Method
C
C     The next equation are solved numerically
C
C           @S   @S   @D   _     @D   @D          _   @U
C     CAS = -- = -- [ -- + U . ( -- + --) ] - CGO K . --
C           @T   @D   @T         @X   @Y              @s
C
C           with:   @S       KS
C                   -- =  ---------
C                   @D    sinh(2KD)
C
C           @D      S      @D         @D           @Ux   @Uy
C     CAD = -- = ------- [ --sin(D) - --cos(D)] + [--- - ---] *
C           @T  sinh(2KD)  @X         @Y            @X   @Y
C
C                        @Uy               @Ux
C     * sin(D)cos(D) +   ---sin(D)sin(D) - ---cos(D)cos(D)
C                        @X                @Y
C
C     @D/@x appr by:   RDX(1) * (DEP(KCGRD(1)) - DEP(KCGRD(2)))
C                    + RDX(2) * (DEP(KCGRD(1)) - DEP(KCGRD(3)))
C     @D/@y appr by:   RDY(1) * (DEP(KCGRD(1)) - DEP(KCGRD(2)))
C                    + RDY(2) * (DEP(KCGRD(1)) - DEP(KCGRD(3)))
C     etc.
C
C     the limitation procedure is described in the system documentation.
C
C  4. Argument variables
C
C     IDCMAX: upper theta-boundary of current sweep
C     IDCMIN: lower theta-boundary of current sweep (function of Sigma)
C     KGRPNT: grid point addresses                                        40.03
C     SWPDIR: current sweep direction
C
      INTEGER, INTENT(IN) :: IDCMIN(MSC), IDCMAX(MSC)
      INTEGER, INTENT(IN) :: KGRPNT(MXC,MYC)                              40.03
      INTEGER, INTENT(IN) :: SWPDIR
C
C     CAS   : Wave transport velocity in S-direction, function of (ID,IS,IC)
C     CAD   : Wave transport velocity in D-dirctiion, function of (ID,IS,IC)
C     CAX   : Wave transport velocity in X-direction, function of (ID,IS,IC)
C     CAY   : Wave transport velocity in Y-direction, function of (ID,IS,IC)
C     CGO   : Group velocity as function of X and Y and sigma in the
C             direction of wave propagation in absence of currents
C     DEP1  : Depth as function of X and Y at time T
C     DEP2  : (Nonstationary case) depth as function of X and Y at time T+1
C     ECOS  : Represent the values of cos(d) of each spectral direction
C     ESIN  : Represent the values of sin(d) of each spectral direction
C     KWAVE : wavenumber as function of the relative frequency sigma
C     SPCSIG: Relative frequencies in computational domain in sigma-space
C     UX2   : X-component of current velocity of X and Y at time T+1
C     UY2   : Y-component of current velocity of X and Y at time T+1
C     XCGRID: x-coordinate of comput. grid points
C     YCGRID: y-coordinate of comput. grid points
C
      REAL  :: SPCSIG(MSC)                                                30.72
      REAL  :: XCGRID(MXC,MYC), YCGRID(MXC,MYC)                           30.80
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAS(MDC,MSC,MICMAX)                                        40.22
      REAL  :: CAD(MDC,MSC,MICMAX)                                        40.22
      REAL  :: CAX(MDC,MSC,MICMAX)                                        30.80 40.22
      REAL  :: CAY(MDC,MSC,MICMAX)                                        30.80 40.22
      REAL  :: CGO(MSC,MICMAX)                                            40.22
      REAL  :: DEP2(MCGRD)                 ,
     &         DEP1(MCGRD)                 ,
     &         ECOS(MDC)                   ,
     &         ESIN(MDC)                   ,
     &         COSCOS(MDC)                 ,
     &         SINSIN(MDC)                 ,
     &         SINCOS(MDC)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: KWAVE(MSC,MICMAX)                                          40.22
      REAL  :: UX2(MCGRD)                  ,
     &         UY2(MCGRD)                  ,
     &         RDX(2)                      ,
     &         RDY(2)
C
C        logical:
C
C        ANYBIN    i  if True component (ID,IS) is updated                30.80
C
      LOGICAL ANYBIN(MDC,MSC)                                             30.80
C
C
C     variables from common
C
C        ICUR    Indicator for current
C        ICMAX   Maximum array size for the points of the molecul
C        NSTATC  Indicator if computation is stationair
C        MXC     Maximum counter of gridppoints in x-direction
C        MYC     Maximum counter of gridppoints in y-direction
C        MSC     Maximum counter of relative frequency
C        MDC     Maximum counter of spectral directions
C
C        DYNDEP  if True depths vary with time
C
C        DT      Time step
C        RDTIM   1/DT                                                     30.80
C        PNUMS   array of numerical coefficients; used here:              30.80
C                PNUMS(17), coeff. for limitation of Ctheta               30.80
C
C     local variables
C
C        IX1,IX2,IX3   Counter of gridpoints in x-direction
C        IY1,IY2,IY3   Counter of gridpoints in y-direction
C        IS            Counter of relative frequency band
C        ID, ID1, ID2  Counter of directions
C        IDDUM         aux. counter of directions
C        II            counter
C        ISWEEP        sweep index: 2=current sweep, 1 and 3=neighbouring sweeps
C        ISWP  : Couner for sweeps                                        40.02
C        KCG1          grid address of the active grid point
C        KCG2, KCG3    grid addresses of two neighbouring grid points
C        SWPNGB        neighbouring sweep direction
C
      INTEGER  IENT  ,IS    ,ID    ,II    ,                               30.80
     &         SWPNGB,IDDUM ,ID1   ,ID2   ,                               30.80
     &         KCG1  ,KCG2  ,KCG3  ,ISWEEP                                30.80
      INTEGER  IX1, IY1, IX2, IY2, IX3, IY3                               40.03
      INTEGER :: ISWP                                                     40.02
C
C     logical local variables
C
C        VALSWP        if true this sweep is valid (all corner points exist)
C
      LOGICAL    VALSWP                                                   40.03
C
C     real local variables
C
C        KD1           wavenumber * depth
C        COEF          aux. quantity
C        VLSINH        sinh of KD1
C        RDXL, RDYL    interpolation factors (see RDX and RDY in common)
C        CAST..        aux. quantities to compute Csigma
C        CADT..        aux. quantities to compute Ctheta
C        DPDX, DPDY    depth gradient
C        DUXDX,DUXDY,DUYDX,DUYDY  current velocity gradients
C
      REAL     VLSINH ,KD1   ,COEF
      REAL     RDXL(2),RDYL(2),XC1   ,YC1    ,DET    ,
     &         DX2    ,DY2    ,DX3   ,DY3
      REAL     DPDX   ,DPDY   ,DUXDX ,DUXDY ,DUYDX ,DUYDY
      REAL     CAST1    ,CAST2    ,CAST3(3) ,CAST4(3) ,                   40.03
     &         CAST5    ,CAST6(3) ,CAST7(3) ,CAST8(3) ,CAST9(3) ,
     &         CADT1    ,CADT2(3) ,CADT3(3) ,
     &         CADT4(3) ,CADT5(3) ,CADT6(3) ,CADT7(3)
      REAL  :: DLOC1, DLOC2, DLOC3
C     local depths corrected in view of stability                         40.02
C
C  5. Parameter variable
C
C     SWP_ARRAY: Array containint the order of sweep handling
C
      INTEGER, PARAMETER :: SWP_ARRAY(1:3) = (/2,1,3/)
C
C     5. SUBROUTINES CALLING
C
C        ---
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C       propagation velocity in sigma-direction:
C
C                              K(IS,IC)S            DEP2(IX,IY)-DEP1(IX,IY)
C       CAS(ID,IS,IC) = ------------------------- [ ----------------------- +
C                       sinh 2K(IS,IC)DEP2(IX,IY)            DT
C
C                           (DEP2(IX,IY) - DEP2(IX+KSX,IY)
C              + UX2(IX,IY) ------------------------------ +
C                                        DDX
C
C                           (DEP2(IX,IY) - DEP2(IX,IY+KSY)
C              + UY2(IX,IY) ------------------------------ ] - CGO(IS,IC) *
C                                        DDY
C
C                          UX2(IX,IY)-UX2(IX+KSX,IY)
C         *  [   K(IS,IC) --------------------------- cos**2(D) +
C                                    DDX
C
C                          UX2(IX,IY)-UX2(IX,IY+KSY)
C              + K(IS,IC) -------------------------- cos(D)sin(D) +
C                                    DDY
C
C                          UY2(IX,IY)-UY2(IX+KSX,IY)
C              + K(IS,IC) -------------------------- sin(D)cos(D) +
C                                    DDX
C
C                          UY2(IX,IY)-UY2(IX,IY+KSY)
C              + K(IS,IC) -------------------------- sin**2(D)        ]
C                                    DDY
C
C       -----------------------------------------------------
C       propagation velocity in theta-direction:
C
C       CAD(ID,IS,IC) =
C
C                     S                   DEP2(IX,IY)-DEP2(IX+KSX,IY)
C           ------------------------- * [ --------------------------sin(D) -
C           sinh 2K(IS,IC)DEP2(IX,IY)               DDX
C
C            (DEP2(IX,IY) - DEP2(IX,IY+KSY)
C           ------------------------------- cos(D) ]  +
C                        DDY
C
C        UX2(IX,IY)-UX2(IX+KSX,IY)   UY2(IX,IY)-UY2(IX,IY+KSY)
C    [  -------------------------- - ------------------------- ] sin(D)cos(D)+
C                 DDX                         DDY
C
C          UY2(IX,IY)-UY2(IX+KSX,IY)
C       + --------------------------- sin**2(D) -
C                   DDX
C
C          UX2(IX,IY)-UX2(IX,IY+KSY)
C         --------------------------- cos**2(D)
C                   DDY
C
C
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For current sweep and two adjacent sweeps do
C       determine interpolation factors RDXL and RDYL
C       determine depth and current gradients
C   ------------------------------------------------------------
C   For each frequency do
C       determine auxiliary quantities depending on sigma
C       For each direction in the sweep and two neighbouring
C           directions do
C           If IREFR=-1
C           Then compute reduction factor for contribution due
C                to depth gradient
C           ----------------------------------------------------
C           determine sweep in which this direction is located
C           using gradients of the proper sweep determine
C           Csigma (CAS) and Ctheta (CAD)
C   ------------------------------------------------------------
C   If ITFRE=0
C   Then make values of CAS=0
C   ------------------------------------------------------------
C   If IREFR=0
C   Then make values of CAD=0
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SPROSD')
C
      CAST1 = 0.
      CAST2 = 0.
      CAST5 = 0.
      CADT1 = 0.
      IX1   = IXCGRD(1)
      IY1   = IYCGRD(1)
      KCG1  = KCGRD(1)
      XC1   = XCGRID(IX1,IY1)
      YC1   = YCGRID(IX1,IY1)
      DLOC1 = DEP2(KCG1)
C
C     *** test output ***
C
      IF (TESTFL .AND. ITEST .GE. 100 ) THEN
        WRITE(PRINTF, 211) IX1-1, IY1-1, XC1+XOFFS, YC1+YOFFS, DLOC1
 211    FORMAT(' test SPROSD, location:',2I5,2e12.4,', depth:',F9.2)
      ENDIF
C
      DO ISWP = 1, 3                                                      40.02
        ISWEEP = SWP_ARRAY(ISWP)                                          40.02
C
C       *** prepare depth and current gradient for current sweep and ***
C       *** two adjacent sweeps                                      ***
C
        CAST3(ISWEEP)  = 0.
        CAST4(ISWEEP)  = 0.
        CAST6(ISWEEP)  = 0.
        CAST7(ISWEEP)  = 0.
        CAST8(ISWEEP)  = 0.
        CAST9(ISWEEP)  = 0.
C
C       *** set the propagation dummy terms CADT 0 ***
C
        CADT2(ISWEEP) = 0.
        CADT3(ISWEEP) = 0.
        CADT4(ISWEEP) = 0.
        CADT5(ISWEEP) = 0.
        CADT6(ISWEEP) = 0.
        CADT7(ISWEEP) = 0.
        VALSWP = .TRUE.
C
        IF (ISWEEP.EQ.2) THEN
          KCG2 = KCGRD(2)
          KCG3 = KCGRD(3)
          IX2  = IXCGRD(2)
          IY2  = IYCGRD(2)
          IX3  = IXCGRD(3)
          IY3  = IYCGRD(3)
          SWPNGB = SWPDIR
          DO II = 1, 2
            RDXL(II) = RDX(II)
            RDYL(II) = RDY(II)
          ENDDO
C         Refraction and frequency shift are not defined for points
C         neighbouring to landpoints
          IF ( (KCG1.EQ.1).OR.(DEP2(KCG1).LE.DEPMIN).OR.                  30.82
     &         (KCG2.EQ.1).OR.(DEP2(KCG2).LE.DEPMIN).OR.                  30.82
     &         (KCG3.EQ.1).OR.(DEP2(KCG3).LE.DEPMIN) ) THEN               30.82
            DO IS = 1, MSC
              DO ID = 1, MDC
                CAS(ID,IS,1) = 0.
                CAD(ID,IS,1) = 0.
              ENDDO
            ENDDO
            GOTO 900
          ENDIF
        ELSE
C         determine neighbouring sweep
          IF (ISWEEP.EQ.1) THEN
            SWPNGB = SWPDIR-1
            IF (SWPNGB.EQ.0) SWPNGB = 4
          ELSE
            SWPNGB = SWPDIR+1
            IF (SWPNGB.EQ.5) SWPNGB = 1
          ENDIF
C
C         determine neighbouring grid points according to sweep
C
          IF (SWPNGB.EQ.1) THEN
            IF (KREPTX.EQ.0) THEN                                         33.09
              IF (IX1.EQ.1) VALSWP = .FALSE.
            ENDIF                                                         33.09
            IF (.NOT.ONED .AND. IY1.EQ.1) VALSWP = .FALSE.
            IX2 = IX1 - 1
            IY2 = IY1
            IX3 = IX1
            IY3 = IY1 - 1
          ELSE IF (SWPNGB.EQ.2) THEN
            IF (KREPTX.EQ.0) THEN                                         33.09
              IF (IX1.EQ.MXC) VALSWP = .FALSE.
            ENDIF                                                         33.09
            IF (.NOT.ONED .AND. IY1.EQ.1) VALSWP = .FALSE.
            IX2 = IX1 + 1
            IY2 = IY1
            IX3 = IX1
            IY3 = IY1 - 1
          ELSE IF (SWPNGB.EQ.3) THEN
            IF (KREPTX.EQ.0) THEN                                         33.09
              IF (IX1.EQ.MXC) VALSWP = .FALSE.
            ENDIF                                                         33.09
            IF (.NOT.ONED .AND. IY1.EQ.MYC) VALSWP = .FALSE.
            IX2 = IX1 + 1
            IY2 = IY1
            IX3 = IX1
            IY3 = IY1 + 1
          ELSE IF (SWPNGB.EQ.4) THEN
            IF (KREPTX.EQ.0) THEN                                         33.09
              IF (IX1.EQ.1) VALSWP = .FALSE.
            ENDIF                                                         33.09
            IF (.NOT.ONED .AND. IY1.EQ.MYC) VALSWP = .FALSE.
            IX2 = IX1 - 1
            IY2 = IY1
            IX3 = IX1
            IY3 = IY1 + 1
          ENDIF
          IF (KREPTX.GT.0) THEN                                           33.09
            IF (IX2.LE.0)   IX2 = IX2 + MXC                               33.09
            IF (IX2.GT.MXC) IX2 = IX2 - MXC                               33.09
          ENDIF
C
C         determine interpolation coeffcients (RDXL, RDYL)
C
          IF (VALSWP) THEN
            KCG2 = KGRPNT(IX2,IY2)
            IF (KCG2.LE.1 .OR. DEP2(KCG2).LE.DEPMIN) VALSWP = .FALSE.         40.14
            IF (KREPTX.GT.0) THEN                                         33.09
              DX2 = DX * COSPC                                            33.09
              DY2 = -DX * SINPC                                           33.09
            ELSE
              DX2 = XC1 - XCGRID(IX2,IY2)
              DY2 = YC1 - YCGRID(IX2,IY2)
            ENDIF
            IF (KSPHER.GT.0) THEN
              DX2 = DX2 * LENDEG * COSLAT(1)
              DY2 = DY2 * LENDEG
            ENDIF
            IF (ONED) THEN
              KCG3 = KCG1
              DET     =  DX2**2 + DY2**2
              RDXL(1) =  DX2/DET
              RDYL(1) =  DY2/DET
              RDXL(2) =  0.
              RDYL(2) =  0.
            ELSE
              KCG3 = KGRPNT(IX3,IY3)
              IF (KCG3.LE.1 .OR. DEP2(KCG3).LE.DEPMIN) VALSWP = .FALSE.   40.14
              DX3 = XC1 - XCGRID(IX3,IY3)
              DY3 = YC1 - YCGRID(IX3,IY3)
              IF (KSPHER.GT.0) THEN
                DX3 = DX3 * LENDEG * COSLAT(1)
                DY3 = DY3 * LENDEG
              ENDIF
              DET     =  DY3*DX2 - DY2*DX3
              RDXL(1) =  DY3/DET
              RDYL(1) = -DX3/DET
              RDXL(2) = -DY2/DET
              RDYL(2) =  DX2/DET
            ENDIF
          ENDIF
        ENDIF
C
C       *** compute the derivatives of the depth and the current velocity ***
C
        IF (VALSWP) THEN
 
          IF (IREFR.EQ.-1) THEN                                           40.02
 
!           limitation of depths in neighbouring grid points
 
            DLOC2 = MIN (DEP2(KCG2), PNUMS(17)*DLOC1)
            DLOC3 = MIN (DEP2(KCG3), PNUMS(17)*DLOC1)
          ELSE                                                            40.02
 
!           no limitation                                                 40.02
 
            DLOC2 = DEP2(KCG2)                                            40.02
            DLOC3 = DEP2(KCG3)                                            40.02
          END IF                                                          40.02
 
!         *** @D/@X ***
          DPDX = RDXL(1) * (DLOC1-DLOC2) + RDXL(2) * (DLOC1-DLOC3)
 
!         *** @D/@Y ***
          DPDY = RDYL(1) * (DLOC1-DLOC2) + RDYL(2) * (DLOC1-DLOC3)
C
          CADT2(ISWEEP) = DPDX                                            30.21
          CADT3(ISWEEP) = DPDY                                            30.21
C
          IF ( ICUR .EQ. 1 ) THEN
C           *** current is on ***
C
C           *** @Ux/@X ***
            DUXDX =  RDXL(1) * (UX2(KCG1) - UX2(KCG2))
     &             + RDXL(2) * (UX2(KCG1) - UX2(KCG3))
C
C           *** @Ux/@Y ***
            DUXDY =  RDYL(1) * (UX2(KCG1) - UX2(KCG2))
     &             + RDYL(2) * (UX2(KCG1) - UX2(KCG3))
C
C           *** @Uy/@X ***
            DUYDX =  RDXL(1) * (UY2(KCG1) - UY2(KCG2))
     &             + RDXL(2) * (UY2(KCG1) - UY2(KCG3))
C
C           *** @Uy/@Y ***
            DUYDY =  RDYL(1) * (UY2(KCG1) - UY2(KCG2))
     &             + RDYL(2) * (UY2(KCG1) - UY2(KCG3))
 
            CAST3(ISWEEP) = UX2(KCG1) * DPDX
            CAST4(ISWEEP) = UY2(KCG1) * DPDY
          ELSE
            DUXDX = 0.
            DUXDY = 0.
            DUYDX = 0.
            DUYDY = 0.
            CAST3(ISWEEP) = 0.
            CAST4(ISWEEP) = 0.
          ENDIF
C
          CAST6(ISWEEP) = DUXDX
          CAST7(ISWEEP) = DUXDY
          CAST8(ISWEEP) = DUYDX
          CAST9(ISWEEP) = DUYDY
C
C         *** coefficients for CAD -> function of IX and IY only ***
C
          CADT2(ISWEEP) = DPDX
          CADT3(ISWEEP) = DPDY
          CADT4(ISWEEP) = DUXDX
          CADT5(ISWEEP) = DUYDY
          CADT6(ISWEEP) = DUYDX
          CADT7(ISWEEP) = DUXDY
C
        ELSE
C         if gradients cannot be determined because one grid point is missing,
C         use gradient computed for the central sweep
          CAST3(ISWEEP) = CAST3(2)
          CAST4(ISWEEP) = CAST4(2)
          CAST6(ISWEEP) = CAST6(2)
          CAST7(ISWEEP) = CAST7(2)
          CAST8(ISWEEP) = CAST8(2)
          CAST9(ISWEEP) = CAST9(2)
          CADT2(ISWEEP) = CADT2(2)
          CADT3(ISWEEP) = CADT3(2)
          CADT4(ISWEEP) = CADT4(2)
          CADT5(ISWEEP) = CADT5(2)
          CADT6(ISWEEP) = CADT6(2)
          CADT7(ISWEEP) = CADT7(2)
        ENDIF
C
C       *** test output ***
C
        IF (TESTFL .AND. ITEST .GE. 100 ) THEN
          WRITE(PRINTF, 411) SWPNGB, IX2-1, IY2-1, DLOC2,
     &                               IX3-1, IY3-1, DLOC3
 411      FORMAT(' sweep, depths:', I2, 2(I6,I4,F9.2))
          IF (ICUR .EQ. 1) THEN
            WRITE(PRINTF, 412) UX2(KCG1),UX2(KCG2),UX2(KCG3),
     &                         UY2(KCG1),UY2(KCG2),UY2(KCG3)
 412        FORMAT(10X, 'UX:',3(1X,F8.3),/, 10X, 'UY:',3(1X,F8.3))
          ENDIF
          WRITE(PRINTF, 413) RDXL(1),RDXL(2),RDYL(1),RDYL(2)
 413      FORMAT(10X, 'RDX etc.:',4(1X,E12.4))
          WRITE(PRINTF, 414) DPDX,  DPDY
 414      FORMAT(10x, 'DPDX,DPDY:',2(1X,E12.4))
        ENDIF
      ENDDO
C
C     *** coefficients for CAS -> function of IX and IY only ***
C
      IF ( NSTATC.EQ.0 .OR. .NOT.DYNDEP) THEN                             40.00
C       *** stationary calculation ***
        CAST2 = 0.
      ELSE
C       nonstationary depth, CAST2 is @D/@t
        CAST2 = ( DLOC1 - DEP1(KCG1) ) * RDTIM
      END IF
C
      DO 70 IS = 1, MSC
        KD1 = KWAVE(IS,1) * DLOC1
        IF ( KD1 .GT. 30.0 ) KD1 = 30.
        VLSINH = SINH (2.* KD1 )
        COEF   = SPCSIG(IS) / VLSINH                                      30.72
C
C       *** coefficients for CAS -> function of IS only ***
C
        CAST1 = KWAVE(IS,1) * COEF
        CAST5 = CGO(IS,1) * KWAVE(IS,1)
C
C       *** coefficients for CAD -> function of IS only ***
C
        CADT1 =  COEF
C
C       loop over spectral directions
C
        DO 60 IDDUM = IDCMIN(IS)-1, IDCMAX(IS)+1                          40.03
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF (IDDUM.EQ.IDCMIN(IS)-1) THEN
C           direction is in the lower adjacent sweep
            ISWEEP = 1
          ELSE IF (IDDUM.EQ.IDCMAX(IS)+1) THEN
C           direction is in the upper adjacent sweep
            ISWEEP = 3
          ELSE
C           direction is in the current sweep
            ISWEEP = 2
          ENDIF
C
C             *** computation of CAS ***
          IF (ICUR .EQ. 0) THEN
            CAS(ID,IS,1) = CAST1 * CAST2
C
            CAD(ID,IS,1) = CADT1 * ( ESIN(ID) * CADT2(ISWEEP) -
     &                               ECOS(ID) * CADT3(ISWEEP) )
          ELSE
            CAS(ID,IS,1)= CAST1 *
     &           (CAST2 + CAST3(ISWEEP) + CAST4(ISWEEP)) -
     &            CAST5 *
     &           (COSCOS(ID) * CAST6(ISWEEP) +
     &            SINCOS(ID) * (CAST7(ISWEEP) + CAST8(ISWEEP)) +
     &            SINSIN(ID) * CAST9(ISWEEP) )
C
C           *** computation of CAD ***
C
            CAD(ID,IS,1) =
     &          CADT1 * (ESIN(ID) * CADT2(ISWEEP) -
     &                   ECOS(ID) * CADT3(ISWEEP)) +
     &          SINCOS(ID) * (CADT4(ISWEEP) - CADT5(ISWEEP)) +
     &          SINSIN(ID) *  CADT6(ISWEEP) -
     &          COSCOS(ID) *  CADT7(ISWEEP)
          ENDIF
C
 60     CONTINUE
 70   CONTINUE
C
C     *** for most cases CAs and CAD will be activated. Therefore ***
C     *** for IREFR is set 0 (CAD = 0) or ITFRE = 0 (CAS = 0 ) we ***
C     *** have put the IF statement outside the internal loop     ***
C     *** above                                                   ***
C
 10   IF (ITFRE .EQ. 0) THEN
        DO IS = 1, MSC
          DO ID = 1, MDC
            CAS(ID,IS,1) = 0.0
          ENDDO
        ENDDO
      ENDIF
C
      IF (IREFR .EQ. 0) THEN
        DO IS = 1, MSC
          DO ID = 1, MDC
            CAD(ID,IS,1) = 0.0
          ENDDO
        ENDDO
      ENDIF
C
C     *** test output ***
C
      IF (TESTFL .AND. ITEST.GE.140) THEN                                 40.00
        IF (DYNDEP .OR. ICUR.GT.0) THEN
          WRITE(PRINTF, *) ' IS ID1 ID2        values of CAS'             40.00
          DO 602 IS = 1, MSC
            ID1 = IDCMIN(IS)-1
            ID2 = IDCMAX(IS)+1
            WRITE(PRINTF, 619) IS, ID1, ID2,                              40.00
     &            (CAS(MOD(IDDUM-1+MDC,MDC)+1, IS, 1), IDDUM=ID1,ID2)     40.00
 619        FORMAT(3I4, 2X, 600E12.4)                                     40.00
 602      CONTINUE
        ENDIF
        WRITE(PRINTF, *) ' IS ID1 ID2        values of CAD'               40.00
        DO 604 IS = 1, MSC
          ID1 = IDCMIN(IS)-1
          ID2 = IDCMAX(IS)+1
          WRITE(PRINTF,619) IS, ID1, ID2,                                 40.00
     &          (CAD(MOD(IDDUM-1+MDC,MDC)+1, IS, 1), IDDUM=ID1,ID2)       40.00
 604   CONTINUE
      ENDIF                                                               40.00
C
C     end of the subroutine SPROSD
 900  RETURN
      END
!****************************************************************
!
      SUBROUTINE DSPHER (CAD, CG, ANYBIN, YCGRID, ECOS)                   33.09 NB!
!
!****************************************************************
!
      IMPLICIT NONE
!
      INCLUDE 'swcomm2.inc'
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
      INCLUDE 'ocpcomm4.inc'
!
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
!
!  0. Authors
!
!     33.09: Nico Booij
!
!  1. Updates
!
!     33.09, Aug. 99: new subroutine
!
!  2. Purpose
!
!     computes the propagation velocities of energy in Theta-
!     space, i.e., CAD, due to use of spherical coordinates
!
!  3. Method
!
!     References:
!     W. E. Rogers, J. M. Kaihatu, H. A. H. Petit, N. Booij and L. H. Holthuijsen,
!     "Multiple-scale Propagation in a Third-Generation Wind Wave Model"
!     in preparation
!
!             Cg Cos(theta) Tan(latitude)
!     CAD = - ---------------------------
!                    Rearth
!
!
!  4. Argument variables
!
!        one and more dimensional arrays:
!        ---------------------------------
!
!     i  ANYBIN 2D    if True the spectral component (ID,IS) is to be
!                     computed
!
      LOGICAL  ANYBIN(MDC,MSC)
!
!     o  CAD    3D    Wave transport velocity in D-dirction, function of
!                     (ID,IS,IC)
!     i  CG     3D    Group velocity as function of Sigma and Theta in the
!                     direction of wave propagation in absence of currents
!     i  YCGRID 2D    Y-coordinate (latitude) for each geographic grid point
!     i  ECOS   1D    Represent the values of Cos(Theta) of each spectral
!                     direction
!
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAD(MDC,MSC,MICMAX)                                        40.22
      REAL  :: CG(MDC,MSC,MICMAX)                                         40.22
      REAL  :: YCGRID(MXC,MYC)
      REAL  :: ECOS(MDC)
!
!
!  4. Local variables
!
!        IX, IY       grid indices
!        ID, IS       spectral indices
!
      INTEGER :: IS    ,ID     ,IX    ,IY
!
!        TANLAT       tan of latitude
!        CTTMP        temp. value used to compute contribution to Ctheta
!
      REAL     TANLAT, CTTMP
!
!     5. SUBROUTINES CALLING
!
!        ACTION
!
!     6. SUBROUTINES USED
!
!        ---
!
!     7. ERROR MESSAGES
!
!        ---
!
!     8. REMARKS
!
!     9. STRUCTURE
!
!        ------------------------------------------------------------
!        Calculate tan of latitude (TANLAT)
!        Then For every spectral direction do
!                 calculate Cspher
!                 For every spectral frequency do
!                     add Cspher to value of CAD
!        ------------------------------------------------------------
!
!     10. SOURCE
!
!************************************************************************
!
      INTEGER, SAVE :: IENT=0
      IF (LTRACE) CALL STRACE (IENT,'DSPHER')
!
!     *** TANLAT is Tan of Latitude
!
      IX     = IXCGRD(1)
      IY     = IYCGRD(1)
      TANLAT = TAN(DEGRAD*(YCGRID(IX,IY)+YOFFS))
!
      DO ID = 1, MDC
        CTTMP = ECOS(ID) * TANLAT / REARTH
        DO IS = 1, MSC
          CAD(ID,IS,1) = CAD(ID,IS,1) - CG(ID,IS,1) * CTTMP
        ENDDO
      ENDDO
!
!     end of the subroutine DSPHER
      RETURN
      END
!
*****************************************************************
*
      SUBROUTINE STRSXY (         ISSTOP  ,IDCMIN  ,IDCMAX  ,CAX     ,
     &                   CAY     ,AC2     ,AC1     ,IMATRA  ,IMATDA  ,
     &                            RDX     ,RDY     ,                      33.09
     &                   OBREDF         )
*
*****************************************************************
C
      INCLUDE 'swcomm2.inc'                                               33.09
      INCLUDE 'swcomm3.inc'                                               33.09
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*     0. AUTHORS
*
*        30.72: IJsbrand Haagsma
!        33.08: W. Erick Rogers (a few changes related to the S&L scheme)
!        33.09: Nico Booij (changes related to spherical coordinates)
*
*     1. UPDATE
*
*        30.72, Oct. 97: changed floating point comparison to avoid equality
*                        comparisons
*        new subroutine replacing STRSX and STRSY
*        time derivative is included here
!        33.08, July 98: STRSXY must use the rolled back AC when S&L is used
!                        elsewhere in the domain.
!        33.09, June 99: commons swcomm2 and swcomm3 introduced, argument list
!                        modified; introduction of spherical coordinates
*
*     2. PURPOSE
*
*        computation of space derivative of action transport
*
*     3. METHOD
*
*        Compute the derivative in x-direction:
*        The nearby points are indicated with the index IC (see
*        FUNCTION ICODE(_,_) ):
*        Central grid point     : IC = 1, grid index KCGRD(1)
*        Point in X-direction   : IC = 2, grid index KCGRD(2)
*        Point in Y-direction   : IC = 3, grid index KCGRD(3)
*
*        @[CAX AC2]
*        --------- =
*            @x
*
*      RDX(1) *
*      [CAX(ID,IS,1).AC2(ID,IS,KCGRD(1)) - CAX(ID,IS,2).AC2(ID,IS,KCGRD(2))]
*   +  RDX(2) *
*      [CAX(ID,IS,1).AC2(ID,IS,KCGRD(1)) - CAX(ID,IS,3).AC2(ID,IS,KCGRD(3))]
*
*        @[CAY AC2]
*        --------- =
*            @y
*
*      RDY(1) *
*      [CAY(ID,IS,1).AC2(ID,IS,KCGRD(1)) - CAY(ID,IS,2).AC2(ID,IS,KCGRD(2))]
*   +  RDY(2) *
*      [CAY(ID,IS,1).AC2(ID,IS,KCGRD(1)) - CAY(ID,IS,3).AC2(ID,IS,KCGRD(3))]
*
*        in diagonal matrix: 1/DT + (RDX(1)+RDX(2)) * CAX(ID,IS,1)
*                                 + (RDY(1)+RDY(2)) * CAY(ID,IS,1)
*        in r.h.s.: AC2/DT + RDX(1) * CAX(ID,IS,2).AC2(ID,IS,KCGRD(2))
*                          + RDX(2) * CAX(ID,IS,3).AC2(ID,IS,KCGRD(3))
*                          + RDY(1) * CAY(ID,IS,2).AC2(ID,IS,KCGRD(2))
*                          + RDY(2) * CAY(ID,IS,3).AC2(ID,IS,KCGRD(3))
*
*     4. PARAMETERLIST
*
*        KCGRD   int, i     Point index for grid points in comp molecule  30.40
*                           array of length ICMAX
*        MDC     int, i     Maximum counter of directional distribution
*        MSC     int, i     Maximum counter of relative frequency
*        MCGRD   int, i     Maximum counter of gridpoints in space        30.40
*        ICMAX   int, i     Maximum counter for the points of the molecule
*        ISSTOP  int, i     highest spectral frequency counter in the sweep
*        IDCMIN  int, i     minimum value of direction counter in this sweep
*        IDCMAX  int, i     maximum value of direction counter in this sweep
*        CAX     rea, i     3D array    propagation velocity in x
*        CAY     rea, i     3D array    propagation velocity in y
*        AC2     rea, i     array  spectral action density, function of
*                           x, y, theta, sigma
*        IMATDA  rea, i/o   array  Coefficients of diagonal of matrix
*        IMATRA  rea, i/o   array  Coefficients of right hand side of matrix
*        OBREDF  rea, i     action reduction factors, function of freq and
*                           direction
*        RDX,RDY 1D   i     array  containing spatial derivative coeff
*        NUMOBS  int, i     number of obstacles in comp grid
*
*     5. SUBROUTINES CALLING
*
*        ACTION
*
*     6. SUBROUTINES USED
*
*        ---
*
*     7. ERROR MESSAGES
*
*        ---
*
*     8. REMARKS
*
*     9. STRUCTURE
*
*   ------------------------------------------------------------
*   For every spectral bin do
*       If bin is in present sweep
*       Then If LOBST
*            Then For IC = 2 to ICMAX do
*                     multiply contribution from upwave point
*                     with reduction factor
*            ---------------------------------------------------
*            Compute the derivative in x-direction
*            Compute the derivative in y-direction
*            If computation is nonstationary
*            Then compute the derivative in t-direction
*            ---------------------------------------------------
*            Store the terms in arrays IMATRA and IMATDA
*   ------------------------------------------------------------
*
      INTEGER  IS      ,ID      ,                                         33.09
     &         IDDUM   ,ISSTOP                                            33.09
C
      REAL     FXY1 ,FXY2
C
      REAL  :: AC1(MDC,MSC,MCGRD) ,AC2(MDC,MSC,MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAX(MDC,MSC,MICMAX) ,CAY(MDC,MSC,MICMAX)                   40.22
      REAL  :: IMATRA(MDC,MSC)    ,IMATDA(MDC,MSC)            ,
     &         RDX(2)             ,RDY(2)                     ,
     &         TRSCF(3)            ,                                      33.09
     &         OBREDF(MDC,MSC,2)                                         040697
C
      INTEGER  IDCMIN(MSC)                ,
     &         IDCMAX(MSC)                                                33.09
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRSXY')
C
      IF (TESTFL .AND. ITEST .GE. 120) THEN
        WRITE(PRINTF,*) ' Initial matrix coefficients at STRSXY : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
          ENDDO
        ENDDO
      END IF
*
      DO 200 IS = 1, ISSTOP
*       test output     ver 30.50
*
        IND2 = KCGRD(2)                                                   23/MAY
        IND3 = KCGRD(3)                                                   23/MAY
*
*
        DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
*         test output     ver 30.50
*
          IF (NUMOBS .GT. 0) THEN
            TCF1 = OBREDF(ID,IS,1)                                         040697
            TCF2 = OBREDF(ID,IS,2)                                         040697
            IF (TESTFL .AND. ITEST.GE.80) THEN                            40.01
              WRITE(PRINTF,10) KCGRD(1),ID,IS,TCF1,TCF2
 10           FORMAT(' STRSXY obst ',3(1X,I5),2(1X,E10.4))
            ENDIF
          ELSE
            TCF1 = 1.
            TCF2 = 1.
          ENDIF
*
          FXY1 = 0.
          FXY2 = 0.
*
          FXY1 =   (RDX(1)+RDX(2)) * CAX(ID,IS,1)
     &           + (RDY(1)+RDY(2)) * CAY(ID,IS,1)
*
          IF (KSPHER.EQ.0) THEN                                           33.09
*
          FXY2 =  RDX(1) * CAX(ID,IS,2)* TCF1 * AC2(ID,IS,IND2)
     &          + RDX(2) * CAX(ID,IS,3)* TCF2 * AC2(ID,IS,IND3)
     &          + RDY(1) * CAY(ID,IS,2)* TCF1 * AC2(ID,IS,IND2)
     &          + RDY(2) * CAY(ID,IS,3)* TCF2 * AC2(ID,IS,IND3)
          ELSE                                                            33.09
!           spherical coordinates                                         33.09
!
            TRSCF(2) = TCF1
            TRSCF(3) = TCF2
            DO IC = 2, 3
              FXY2 = FXY2 +
     &              RDX(IC-1) * CAX(ID,IS,IC) * TRSCF(IC) *
     &              AC2(ID,IS,KCGRD(IC))
     &            + RDY(IC-1) * CAY(ID,IS,IC) * TRSCF(IC) *
     &              AC2(ID,IS,KCGRD(IC)) * COSLAT(IC) / COSLAT(1)
            ENDDO
          ENDIF
C
C         *** the term FXY2 is known, store in IMATRA ***
C         *** the term FXY1 is unknown, store in IMATDA ***
C
 
!old          IF(STELLING)THEN                                                 33.08
          IF (PROPSC.EQ.3) THEN                                            33.08
 
!            if we are using the S&L scheme elsewhere in the domain,       33.08
!            we do the rollback regardless of itermx.                      33.08
             ACOLD = AC1(ID,IS,KCGRD(1))                                   33.08
!            we also want to include dt terms in stationary mode calcs     33.08
             IMATRA(ID,IS) = IMATRA(ID,IS) + FXY2 + ACOLD*RDTIM            33.08
             IMATDA(ID,IS) = IMATDA(ID,IS) + FXY1 + RDTIM                  33.08
 
          ELSE       ! BSBT scheme only                                    33.08
          IF (NSTATC.EQ.1) THEN                                            40.00
            IF (ITERMX.EQ.1) THEN
              ACOLD = AC2(ID,IS,KCGRD(1))
            ELSE
              ACOLD = AC1(ID,IS,KCGRD(1))
            ENDIF
            IMATRA(ID,IS) = IMATRA(ID,IS) + FXY2 + ACOLD*RDTIM            33.09
            IMATDA(ID,IS) = IMATDA(ID,IS) + FXY1 + RDTIM                  33.09
          ELSE
            IMATRA(ID,IS) = IMATRA(ID,IS) + FXY2
            IMATDA(ID,IS) = IMATDA(ID,IS) + FXY1
          ENDIF
          ENDIF                                                           33.08
C
C         *** test output ***
C
          IF ( ITEST .GE. 150 .AND. TESTFL ) THEN
            IF (NSTATC.EQ.1) THEN                                          40.00
              WRITE(PRINTF,6021) ID, FXY1, FXY2, ACOLD
 6021         FORMAT (' - ID FXY1 FXY2 ACOLD:', I4, 3(1X,E12.4))
            ELSE
              WRITE(PRINTF,6022) ID, FXY1, FXY2
 6022         FORMAT (' - ID FXY1 FXY2:', I4, 2(1X,E12.4))
            ENDIF
          ENDIF
C
 100    CONTINUE
 200  CONTINUE
C
      IF (TESTFL .AND. ITEST .GE. 100) THEN
        WRITE(PRINTF,*) '  matrix coefficients at STRSXY : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
2102        FORMAT(3I3,2E12.4)
          ENDDO
        ENDDO
      END IF
C     End of subroutine STRSXY
      RETURN
      END
!****************************************************************
!
      SUBROUTINE SORDUP (         ISSTOP  ,IDCMIN  ,IDCMAX  ,CAX     ,
     &                   CAY     ,AC2     ,IMATRA  ,IMATDA  ,
     &                            RDX     ,RDY     )                      33.10
!
!****************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
!
      IMPLICIT NONE                                                       33.10
!
      INCLUDE 'swcomm3.inc'                                               33.10
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
!
!
!     0. AUTHORS
!
!        33.10: Nico Booij and Erick Rogers (changes related to the SORDUP scheme)
!        33.09: Nico Booij (changes related to spherical coordinates)
!
!     1. UPDATE
!
!        33.10, Jan. 2000: subroutine SORDUP created. It is a modified STRSXY.
!               Feb. 2000: implemented option for using a non-zero value for "THETAK"
!
!     2. PURPOSE
!
!        Purpose is to compute the space derivative of action transport using
!        the SORDUP scheme.
!        This is for stationary calcs only (no time derivative).
!        Henri Petit (Delft Hydraulics) suggested that we implement a modified
!                form of the scheme, in which the model user has the option
!                for using a non-zero value for "THETAK" as a means to
!                eliminate wiggles.
!        To summarize:
!        With THETAK=0, the scheme is 2nd order accurate.
!        With THETAK=0, the scheme reduces to the "best" approximation of
!             d/dx which can be determined using Taylor Series for the
!             stencil (ix),(ix-1),(ix-2):
!                         3/2*mu*phi(ix)-2*mu*phi(ix-1)+1/2*mu*phi(ix-2)
!        With a non-zero THETAK, the scheme is only first order accurate,
!             and is only approximately mass conserving (mass balance error
!             is slight).
!        With a negative THETAK, the scheme has positive diffusion.
!             This makes the scheme something of a hybrid between the BSBT
!             scheme (of the original SWAN) and the second order scheme
!             (THETAK=0). The only reason to intentionally introduce diffusion
!             is in case of wiggles. Wiggles will, for the most part, only
!             occur when spatial gradients are very severe, so using a
!             negative THETAK is generally not necessary.
!             Using a THETAK of -0.1 for case-set of severe gradients, I
!             found diffusion to be about midway between that of the BSBT
!             scheme and that of the second order (THETAK=0) scheme.
!             For this case-set, wiggles are seen in the second order scheme
!             solution, and are virtually eliminated with the (THETAK=-0.1)
!             scheme.
!             Henri has shown that the scheme with small negative THETAK is
!             very likely to be unconditionally stable.
!             Larger |THETAK| ==> more diffusion
!        With a positive THETAK, the scheme is unconditionally unstable.
!             This instability is generally not noticeable, but since there
!             is not a good reason for using positive THETAK, if this
!             option is chosen, a warning or error message will be given.
!
!     3. METHOD
!
!     References:
!     W. E. Rogers, J. M. Kaihatu, H. A. H. Petit, N. Booij and L. H. Holthuijsen,
!     "Multiple-scale Propagation in a Third-Generation Wind Wave Model"
!     in preparation
!
!        Compute the derivative in x-direction:
!        The nearby points are indicated by KCGRD
!        KCGRD(1) :   IX  ,IY
!        KCGRD(2) :   IX-1,IY
!        KCGRD(3) :   IX  ,IY-1
!        KCGRD(4) :   IX-2,IY
!        KCGRD(5) :   IX  ,IY-2
!
!        For the case of THETAK=0, the scheme is:
!
!        @[CAX AC2]
!        --------- =
!            @x
!
!        [1.5*CAX(ID,IS,1)*AC2(ID,IS,KCGRD(1))-2.0*CAX(ID,IS,2)*AC2(ID,IS,KCGRD(2))
!        +0.5*CAX(ID,IS,4)*AC2(ID,IS,KCGRD(4))]/DX
!
!        @[CAY AC2]
!        --------- =
!            @y
!
!        [1.5*CAY(ID,IS,1)*AC2(ID,IS,KCGRD(1))-2.0*CAY(ID,IS,3)*AC2(ID,IS,KCGRD(3))
!        +0.5*CAY(ID,IS,5)*AC2(ID,IS,KCGRD(5))]/DY
!
!        ADD TO DIAGONAL:
!        +1.5*CAX(ID,IS,1)/DX+1.5*CAY(ID,IS,1)/DY
!        ADD TO RHS:
!        +[2.0*CAX(ID,IS,2)*AC2(ID,IS,KCGRD(2)-0.5*CAX(ID,IS,4)*AC2(ID,IS,KCGRD(4)]/DX
!        +[2.0*CAY(ID,IS,3)*AC2(ID,IS,KCGRD(3)-0.5*CAY(ID,IS,5)*AC2(ID,IS,KCGRD(5)]/DY
!
!     4. PARAMETERLIST
!
!        KCGRD   int, i     Point index for grid points in comp molecule  30.40
!                           array of length ICMAX
!        MDC     int, i     Maximum counter of directional distribution
!        MSC     int, i     Maximum counter of relative frequency
!        MCGRD   int, i     Maximum counter of gridpoints in space        30.40
!        ICMAX   int, i     Maximum counter for the points of the molecule
!        ISSTOP  int, i     highest spectral frequency counter in the sweep
!        IDCMIN  int, i     minimum value of direction counter in this sweep
!        IDCMAX  int, i     maximum value of direction counter in this sweep
!        CAX     rea, i     3D array    propagation velocity in x
!        CAY     rea, i     3D array    propagation velocity in y
!        AC2     rea, i     array  spectral action density, function of
!                           x, y, theta, sigma
!        IMATDA  rea, i/o   array  Coefficients of diagonal of matrix
!        IMATRA  rea, i/o   array  Coefficients of right hand side of matrix
!        RDX,RDY 1D   i     array  containing spatial derivative coeff
!        THETAK  rea  i     value for theta to be used in scheme (default
!                           is zero)
!
!     5. SUBROUTINES CALLING
!
!        ACTION
!
!     6. SUBROUTINES USED
!
!        ---
!
!     7. ERROR MESSAGES
!
!        ---
!
!     8. REMARKS
!
!     9. STRUCTURE
!
!   ------------------------------------------------------------
!   For every spectral bin do
!       If bin is in present sweep
!            ---------------------------------------------------
!            Compute the derivative in x-direction
!            Compute the derivative in y-direction
!            If computation is nonstationary
!            Then compute the derivative in t-direction
!            ---------------------------------------------------
!            Store the terms in arrays IMATRA and IMATDA
!   ------------------------------------------------------------
!
 
 
      INTEGER  IS,ID,IDDUM,ISSTOP                                         33.10
     &         ,IND2,IND3,IND4,IND5                                       33.10
!
      REAL  :: FXY1 ,FXY2
!
      REAL  :: AC2(MDC,MSC,MCGRD)                                         33.10
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAX(MDC,MSC,MICMAX) ,CAY(MDC,MSC,MICMAX)                   40.22
      REAL  :: IMATRA(MDC,MSC)    ,IMATDA(MDC,MSC)            ,
     &         RDX(2)             ,RDY(2)
     &         ,THETAK,XMU(5),YMU(5),XYMU(5)                              33.10
 
      INTEGER  IDCMIN(MSC), IDCMAX(MSC), IENT, IXY                        33.10
      LOGICAL  XNUM                                                       33.10
 
!
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SORDUP')
!
      IF(NSTATC.EQ.1)THEN                                                 33.10
         CALL MSGERR (4, 'SORDUP scheme is for stationary mode only.')    33.10
      END IF                                                              33.10
      IF (TESTFL .AND. ITEST .GE. 120) THEN
        WRITE(PRINTF,*) ' Initial matrix coefficients at SORDUP : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
          ENDDO
        ENDDO
      END IF
 
!     Initialize XYMU to zero to ensure good data for default THETAK=0    40.22
      XYMU=0.                                                             40.22
!
      DO 200 IS = 1, ISSTOP
!       test output     ver 30.50
!
        IND2 = KCGRD(2)
        IND3 = KCGRD(3)
        IND4 = KCGRD(4)                                                   33.10
        IND5 = KCGRD(5)                                                   33.10
!
        THETAK = -PNUMS(26)
!
        DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
!
!         find Courant number values: XMU, YMU, XYMU.                     33.10
!         depending on relative size of XMU and YMU, XYMU is defined as   33.10
!         XYMU=XMU/YMU or XYMU=YMU/XMU .                                  33.10
!         I want to use a consistent definition of XYMU for the entire    33.10
!         stencil, so I base it on relative size of XMU and YMU at the    33.10
!         (IX,IY) point, not at individual points in the stencil.         33.10
!         This creates the slight possibility that we will have           33.10
!         a zero in the denominator                                       33.10
!         because of RDX and RDY, XMU and YMU are always positive.        33.10
          DO IXY=1,5                                                      33.10
             XMU(IXY) = RDX(1)*CAX(ID,IS,IXY) + RDY(1)*CAY(ID,IS,IXY)     33.10
             YMU(IXY) = RDX(2)*CAX(ID,IS,IXY) + RDY(2)*CAY(ID,IS,IXY)     33.10
          END DO                                                          33.10
          IF(YMU(1).GT.XMU(1))THEN                                        33.10
!            propagation mainly from grid point 3
             XNUM=.TRUE.                                                  33.10
          ELSE                                                            33.10
!            propagation mainly from grid point 2
             XNUM=.FALSE.                                                 33.10
          END IF                                                          33.10
          IF(THETAK.NE.0)THEN ! XYMU is only necessary when THETAK.NE.0   33.10
            DO IXY=1,5                                                    33.10
              IF(XNUM)THEN                                                33.10
                IF(YMU(IXY).LT.1.E-5)THEN ! this should occur very rarely 33.10
                  CALL MSGERR (4, 'Denominator ~ zero in SORDUP')         33.10
                END IF                                                    33.10
                XYMU(IXY)=XMU(IXY)/YMU(IXY)                               33.10
              ELSE                                                        33.10
                IF(XMU(IXY).LT.1.E-5)THEN ! this should occur very rarely 33.10
                  CALL MSGERR (4, 'Denominator ~ zero in SORDUP')         33.10
                END IF                                                    33.10
                XYMU(IXY)=YMU(IXY)/XMU(IXY)                               33.10
              END IF                                                      33.10
            END DO                                                        33.10
          END IF                                                          33.10
 
!         now calculate diagonal and rhs                                  33.10
 
          IF(XNUM)THEN                                                    33.10
 
            FXY1 = XMU(1)*(1.5+0.5*THETAK*XYMU(1))                        33.10
     &           + YMU(1)*(1.5+0.5*THETAK)                                33.10
 
            IF (KSPHER.EQ.0) THEN                                         33.08
!             Cartesian coordinates
 
!             the known, rhs part                                         33.08
 
              FXY2 = AC2(ID,IS,IND2) * XMU(2)*(THETAK*XYMU(2)+2.0)        33.10
     &              -AC2(ID,IS,IND4) * 0.5*XMU(4)*(THETAK*XYMU(4)+1.0)    33.10
     &              +AC2(ID,IS,IND3) * YMU(3)*(THETAK+2.0)                33.10
     &              -AC2(ID,IS,IND5) * 0.5*YMU(5)*(THETAK+1.0)            33.10
            ELSE                                                          33.10
!             Spherical coordinates
!
              FXY2 =
     &        AC2(ID,IS,IND2) * CAX(ID,IS,2) * RDX(1) *
     &             (2.0 + THETAK*XYMU(2))
     &       -AC2(ID,IS,IND4) * CAX(ID,IS,4) * RDX(1) *
     &             (0.5 + 0.5*THETAK*XYMU(4))
     &       +AC2(ID,IS,IND3) * CAX(ID,IS,3) * RDX(2) *
     &             (2.0 + THETAK)
     &       -AC2(ID,IS,IND5) * CAX(ID,IS,5) * RDX(2) *
     &             (0.5 + 0.5*THETAK)
     &      +(AC2(ID,IS,IND2) * CAY(ID,IS,2) * RDY(1) * COSLAT(2) *
     &             (2.0 + THETAK*XYMU(2))
     &       -AC2(ID,IS,IND4) * CAY(ID,IS,4) * RDY(1) * COSLAT(4) *
     &             (0.5 + 0.5*THETAK*XYMU(4))
     &       +AC2(ID,IS,IND3) * CAY(ID,IS,3) * RDY(2) * COSLAT(3) *
     &             (2.0 + THETAK)
     &       -AC2(ID,IS,IND5) * CAY(ID,IS,5) * RDY(2) * COSLAT(5) *
     &             (0.5 + 0.5*THETAK) ) / COSLAT(1)
            ENDIF
 
          ELSE      ! switch 2<==>3, 4<==>5, and YMU<==>XMU               33.10
 
            FXY1 = YMU(1)*(1.5+0.5*THETAK*XYMU(1))                        33.10
     &           + XMU(1)*(1.5+0.5*THETAK)                                33.10
            IF (KSPHER.EQ.0) THEN                                         33.08
!             Cartesian coordinates
 
!             the known, rhs part                                         33.08
 
              FXY2 = AC2(ID,IS,IND3) * YMU(3)*(THETAK*XYMU(3)+2.0)        33.10
     &              -AC2(ID,IS,IND5) * 0.5*YMU(5)*(THETAK*XYMU(5)+1.0)    33.10
     &              +AC2(ID,IS,IND2) * XMU(2)*(THETAK+2.0)                33.10
     &              -AC2(ID,IS,IND4) * 0.5*XMU(4)*(THETAK+1.0)            33.10
            ELSE
!             Spherical coordinates
 
              FXY2 =
     &        AC2(ID,IS,IND2) * CAX(ID,IS,2) * RDX(1) *
     &             (2.0 + THETAK)
     &       -AC2(ID,IS,IND4) * CAX(ID,IS,4) * RDX(1) *
     &             (0.5 + 0.5*THETAK)
     &       +AC2(ID,IS,IND3) * CAX(ID,IS,3) * RDX(2) *
     &             (2.0 + THETAK*XYMU(3))
     &       -AC2(ID,IS,IND5) * CAX(ID,IS,5) * RDX(2) *
     &             (0.5 + 0.5*THETAK*XYMU(5))
     &      +(AC2(ID,IS,IND2) * CAY(ID,IS,2) * RDY(1) * COSLAT(2) *
     &             (2.0 + THETAK)
     &       -AC2(ID,IS,IND4) * CAY(ID,IS,4) * RDY(1) * COSLAT(4) *
     &             (0.5 + 0.5*THETAK)
     &       +AC2(ID,IS,IND3) * CAY(ID,IS,3) * RDY(2) * COSLAT(3) *
     &             (2.0 + THETAK*XYMU(3))
     &       -AC2(ID,IS,IND5) * CAY(ID,IS,5) * RDY(2) * COSLAT(5) *
     &             (0.5 + 0.5*THETAK*XYMU(5)) ) / COSLAT(1)
            ENDIF
          END IF
 
          IF (TESTFL .AND. ITEST.GE.120) WRITE (PRTEST, 28) ID, IS,
     &    CAX(ID,IS,2), CAY(ID,IS,2), AC2(ID,IS,IND2),
     &    CAX(ID,IS,3), CAY(ID,IS,3), AC2(ID,IS,IND3)
 28       FORMAT (2I3, 6(1X,E12.4))
!
!         *** the term FXY2 is known, store in IMATRA ***
!         *** the term FXY1 is unknown, store in IMATDA ***
!
          IMATRA(ID,IS) = IMATRA(ID,IS) + FXY2
          IMATDA(ID,IS) = IMATDA(ID,IS) + FXY1
!
!         *** test output ***
!
          IF ( ITEST .GE. 150 .AND. TESTFL ) THEN
              WRITE(PRINTF,6022) ID, FXY1, FXY2
 6022         FORMAT (' - ID FXY1 FXY2:', I4, 2(1X,E12.4))
          ENDIF
!
 100    CONTINUE
 200  CONTINUE
!
      IF (TESTFL .AND. ITEST .GE. 100) THEN
        WRITE(PRINTF,*) '  matrix coefficients at SORDUP : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
 2102       FORMAT(3I3,2E12.4)
          ENDDO
        ENDDO
      END IF
!     End of subroutine SORDUP
      RETURN
      END
!****************************************************************
!
      SUBROUTINE SANDL ( ISSTOP  ,IDCMIN  ,IDCMAX  ,CGO     ,CAX     ,    33.08
     &                   CAY     ,AC2     ,AC1     ,IMATRA  ,IMATDA  ,
     &                   RDX     ,RDY     ,CAX1    ,CAY1    ,SPCDIR)      33.08
!
!****************************************************************
      IMPLICIT NONE                                                       33.08
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
!
!     0. AUTHORS
!
!        33.08: W. Erick Rogers
!        33.09: Nico Booij
!        40.02: IJsbrand Haagsma
!
!     1. UPDATE
!
!        33.08, July 98: SANDL: New subroutine using a Stelling and Leenderste
!                        SANDL: scheme (Qo=0,Q1=1/6) is created.
!        33.09, Aug. 99: extension with spherical coordinates
!        40.02, Aug. 00: Avoide more than 19 continuatino lines
!
!     2. PURPOSE
!
!        computation of space derivative of action transport
!
!     3. METHOD
!
!        References:
!        W.E. Rogers,  J.M. Kaihatu, N. Booij and L.H. Holthuijsen,
!        "Improving the numerics of a third-generation wave action
!        model", Naval Research Laboratory, NRL/FR/7320-99-9695, 79p.
!
!        computational stencil:                                           40.03
!
!                              4
!                             X
!                             |
!               8    6    2   |1    5
!              X----X----X----X----X
!                        |    |
!                        |    |3
!                        X----X
!                      10     |
!                             |7
!                             X
!                             |
!                             |9
!                             X
!
!        Compute the derivative in x-direction:
!        The nearby points are indicated with the index IC (see
!        above scheme):
!        Central grid point     : IC = 1, grid index KCGRD(1)
!        Point in X-direction   : IC = 2, grid index KCGRD(2)
!        Point in Y-direction   : IC = 3, grid index KCGRD(3)
!
!        @[CAX AC2]
!        --------- =
!            @x
 
!       (1/4DX)*(CAX1(KCGRD(5))*AC1(KCGRD(5))-CAX1(KCGRD(2))*AC1(KCGRD(2)))          33.08
!       +(1/12DX)*( 10*CAX(KCGRD(1))*AC2(KCGRD(1))-15*CAX(KCGRD(2))*AC2(KCGRD(2))    33.08
!       +6*CAX(KCGRD(6))*AC2(KCGRD(6))-1*CAX(KCGRD(8))*AC2(KCGRD(8)) )               33.08
 
 
!        @[CAY AC2]
!        --------- =
!            @y
 
!       (1/4DY)*(CAY1(KCGRD(4))*AC1(KCGRD(4))-CAY1(KCGRD(3))*AC1(KCGRD(3)))          33.08
!       +(1/12DY)*( 10*CAY(KCGRD(1))*AC2(KCGRD(1))-15*CAY(KCGRD(3))*AC2(KCGRD(3))    33.08
!       +6*CAY(KCGRD(7))*AC2(KCGRD(7))-1*CAY(KCGRD(9))*AC2(KCGRD(9)) )               33.08
 
!        in diagonal matrix: 1/DT + (5./6.)*(RDX(1)+RDX(2)) * CAX(ID,IS,1)           33.08
!                                 + (5./6.)*(RDY(1)+RDY(2)) * CAY(ID,IS,1)           33.08
 
!        in r.h.s.: AC1/DT + RDX(1)*CAX(ID,IS,2)*AC2(ID,IS,KCGRD(2))                 33.08
!                  +(5./4.) *RDY(2)*CAY(ID,IS,3)*AC2(ID,IS,KCGRD(3))                 33.08
!                  -(1./2.) *RDX(1)*CAX(ID,IS,6)*AC2(ID,IS,KCGRD(6))                 33.08
!                  -(1./2.) *RDY(2)*CAY(ID,IS,7)*AC2(ID,IS,KCGRD(7))                 33.08
!                  +(1./12.)*RDX(1)*CAX(ID,IS,8)*AC2(ID,IS,KCGRD(8))                 33.08
!                  +(1./12.)*RDY(2)*CAY(ID,IS,9)*AC2(ID,IS,KCGRD(9))                 33.08
!                  +(0.25*RDX(1))*(CAX1(ID,IS,2)*AC1(ID,IS,KCGRD(2))                 33.08
!                  -               CAX1(ID,IS,5)*AC1(ID,IS,KCGRD(5)))                33.08
!                  +(0.25*RDY(2))*(CAY1(ID,IS,3)*AC1(ID,IS,KCGRD(3))                 33.08
!                  -               CAY1(ID,IS,4)*AC1(ID,IS,KCGRD(4)))                33.08
!
!        To produce anisotrophic diffusion, we add to the r.h.s.:
!
!                  +RDX**2                                                           33.08
!                    *(+DXX(1)*(AC1(ID,IS,IND5)-AC1(ID,IS,IND1))                     33.08
!                      -DXX(2)*(AC1(ID,IS,IND1)-AC1(ID,IS,IND2)))                    33.08
!                  +RDY**2                                                           33.08
!                    *(+DYY(1)*(AC1(ID,IS,IND4)-AC1(ID,IS,IND1))                     33.08
!                      -DYY(3)*(AC1(ID,IS,IND1)-AC1(ID,IS,IND3)))                    33.08
!                  +(2.*DXY(1)*RDX*RDY)                                              33.08
!                           *(+AC1(ID,IS,IND1)-AC1(ID,IS,IND2)                       33.08
!                             -AC1(ID,IS,IND3)+AC1(ID,IS,IND10))                     33.08
!
!                  Where DXX, DYY, and DXY are diffusion coefficients.               33.08
!
!
!     4. PARAMETERLIST
!
!        ISSTOP  int, i     highest spectral frequency counter in the sweep
!        IDCMIN  int, i     minimum value of direction counter in this sweep
!        IDCMAX  int, i     maximum value of direction counter in this sweep
!        CGO     rea, i     2D array    group velocity                    33.08
!        CAX     rea, i     3D array    propagation velocity in x  new time level
!        CAY     rea, i     3D array    propagation velocity in y
!        CAX1    rea, i     3D array    propagation velocity in x  old time level
!        CAY1    rea, i     3D array    propagation velocity in y
!        AC2     rea, i     array  spectral action density, function of
!                           x, y, theta, sigma
!        IMATDA  rea, i/o   array  Coefficients of diagonal of matrix
!        IMATRA  rea, i/o   array  Coefficients of right hand side of matrix
!        RDX,RDY 1D   i     array  containing spatial derivative coeff
!
!     5. SUBROUTINES CALLING
!
!        ACTION
!
!     6. Local variables
!
!     6. SUBROUTINES USED
!
!        ---
!
!     7. ERROR MESSAGES
!
!        ---
!
!     8. REMARKS
!
!     9. STRUCTURE
!
!   ------------------------------------------------------------
!   For every spectral bin do
!       If bin is in present sweep
!       Then If LOBST
!            Then For IC = 2 to ICMAX do
!                     multiply contribution from upwave point
!                     with reduction factor
!            ---------------------------------------------------
!            Compute the derivative in x-direction
!            Compute the derivative in y-direction
!            If computation is nonstationary
!            Then compute the derivative in t-direction
!            ---------------------------------------------------
!            Store the terms in arrays IMATRA and IMATDA
!   ------------------------------------------------------------
!
      INCLUDE 'swcomm2.inc'
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
      INCLUDE 'ocpcomm4.inc'
!
      INTEGER  IS      ,ID      ,IDDUM   ,ISSTOP  ,IC    ,
     &         IND1,IND2,IND3,IND4,IND5,IND6,IND7,IND8,IND9,IND10         33.08
!
      REAL     FXY1 ,FXY2, ACOLD,                                         33.08
     &         DSS, DNN, D11AC, D12AC, D22AC                              33.08
!
      REAL  :: AC1(MDC,MSC,MCGRD) ,AC2(MDC,MSC,MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CGO(MSC,MICMAX)                                            33.08 40.22
      REAL  :: CAX(MDC,MSC,MICMAX) ,CAY(MDC,MSC,MICMAX)                   40.22
      REAL  :: IMATRA(MDC,MSC)    ,IMATDA(MDC,MSC)
      REAL  :: RDX(2)             ,RDY(2)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAX1(MDC,MSC,MICMAX),CAY1(MDC,MSC,MICMAX)                  33.08 40.22
      REAL  :: DCG, SPCDIR(MDC,6), DXX, DYY, DXY                          33.08
!
      INTEGER :: IDCMIN(MSC), IDCMAX(MSC)
!
      INTEGER, SAVE :: IENT=0
      IF (LTRACE) CALL STRACE (IENT,'SANDL')
!
      IF (TESTFL .AND. ITEST .GE. 120) THEN
        WRITE(PRINTF,*) ' Initial matrix coefficients at SANDL : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
          ENDDO
        ENDDO
      END IF
 
      IND1 = KCGRD(1)                                                     33.08
      IND2 = KCGRD(2)
      IND3 = KCGRD(3)
      IND4 = KCGRD(4)                                                     33.08
      IND5 = KCGRD(5)                                                     33.08
      IND6 = KCGRD(6)                                                     33.08
      IND7 = KCGRD(7)                                                     33.08
      IND8 = KCGRD(8)                                                     33.08
      IND9 = KCGRD(9)                                                     33.08
      IND10 = KCGRD(10)                                                   33.08
 
      IF (TESTFL .AND. KSPHER.GT.0 .AND. ITEST.GE.60) THEN
         WRITE (PRTEST, 92) (COSLAT(IC), IC=1, 10)
  92     FORMAT (' Cos(Lat) ',10(1X,F7.4))
      ENDIF
      IF (WAVAGE.GT.0. .AND. ITEST.GE.120 .AND. TESTFL) THEN
        WRITE (PRTEST, *) '  ID  IS  DSS    DNN   ',
     &  '  DXX   DXY   DYY    D11AC   D12AC   D22AC'
      ENDIF
!
      DO 200 IS = 1, ISSTOP
 
        DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
 
          IF (WAVAGE.GT.0.) THEN                                          33.08
!           calculate DSS,DXX,DXY for the central grid point (IC=1)       33.08
!           we need DCG first. we calculate DCG (delta of Cg)             33.08
            IC = 1                                                        33.08
            IF (IS.EQ.1) THEN                                             33.08
              DCG = ABS(CGO(IS+1,IC)-CGO(IS,IC))                          33.08
 
            ELSE IF (IS.EQ.ISSTOP) THEN                                   33.08
              DCG = ABS(CGO(IS,IC)-CGO(IS-1,IC))                          33.08
 
            ELSE                                                          33.08
              DCG = 0.5 * ABS(CGO(IS+1,IC)-CGO(IS-1,IC))                  33.08
            END IF                                                        33.08
!           we obtain DSS etc. by using the wave age                      33.08
            DSS = DCG**2*WAVAGE/12.                                       33.08
            DNN = (CGO(IS,IC)*DDIR)**2 * WAVAGE/12.                       33.08
!           we obtain DXX etc. by multiplication with Cos(theta)^2 etc.   33.08
            DXX = DSS*SPCDIR(ID,4) + DNN*SPCDIR(ID,6)                     33.08
            DYY = DSS*SPCDIR(ID,6) + DNN*SPCDIR(ID,4)                     33.08
            DXY = (DSS-DNN)*SPCDIR(ID,5)                                  33.08
          END IF                                                          33.08
 
!         the unknown, diagonal part:                                     33.08
 
          FXY1 = 0.83333*(RDX(1)+RDX(2)) * CAX(ID,IS,1)                   33.08
     &         + 0.83333*(RDY(1)+RDY(2)) * CAY(ID,IS,1)                   33.08
          IF (KSPHER.EQ.0) THEN                                           33.08
!           Cartesian coordinates
 
!           the known, rhs part                                           33.08
 
!
!         To avoid violation of the ANSI standard this statement is split 40.02
!
            FXY2 =                                                        40.02
     &        +1.25   * RDX(1) * CAX(ID,IS,2) * AC2(ID,IS,IND2)           33.08
     &        +1.25   * RDY(1) * CAY(ID,IS,2) * AC2(ID,IS,IND2)           33.08
     &        +1.25   * RDX(2) * CAX(ID,IS,3) * AC2(ID,IS,IND3)           33.08
     &        +1.25   * RDY(2) * CAY(ID,IS,3) * AC2(ID,IS,IND3)           33.08
     &        -0.5    * RDX(1) * CAX(ID,IS,6) * AC2(ID,IS,IND6)           33.08
     &        -0.5    * RDY(1) * CAY(ID,IS,6) * AC2(ID,IS,IND6)           33.08
     &        -0.5    * RDX(2) * CAX(ID,IS,7) * AC2(ID,IS,IND7)           33.08
     &        -0.5    * RDY(2) * CAY(ID,IS,7) * AC2(ID,IS,IND7)           33.08
     &        +0.08333* RDX(1) * CAX(ID,IS,8) * AC2(ID,IS,IND8)           33.08
     &        +0.08333* RDY(1) * CAY(ID,IS,8) * AC2(ID,IS,IND8)           33.08
     &        +0.08333* RDX(2) * CAX(ID,IS,9) * AC2(ID,IS,IND9)           33.08
     &        +0.08333* RDY(2) * CAY(ID,IS,9) * AC2(ID,IS,IND9)           33.08
            FXY2 = FXY2 + (                                               40.02
     &        +(0.25*RDX(1)) * (CAX1(ID,IS,2) * AC1(ID,IS,IND2)           33.08
     &        -                 CAX1(ID,IS,5) * AC1(ID,IS,IND5))          33.08
     &        +(0.25*RDY(1)) * (CAY1(ID,IS,2) * AC1(ID,IS,IND2)           33.08
     &        -                 CAY1(ID,IS,5) * AC1(ID,IS,IND5))          33.08
     &        +(0.25*RDX(2)) * (CAX1(ID,IS,3) * AC1(ID,IS,IND3)           33.08
     &        -                 CAX1(ID,IS,4) * AC1(ID,IS,IND4))          33.08
     &        +(0.25*RDY(2)) * (CAY1(ID,IS,3) * AC1(ID,IS,IND3)           33.08
     &        -                 CAY1(ID,IS,4) * AC1(ID,IS,IND4)) )        33.08
          ELSE                                                            33.09
!           spherical coordinates
 
            FXY2 =
     &         1.25   * RDX(1)*CAX(ID,IS,2)*AC2(ID,IS,IND2)               33.09
     &        +1.25   * RDX(2)*CAX(ID,IS,3)*AC2(ID,IS,IND3)               33.09
     &        -0.5    * RDX(1)*CAX(ID,IS,6)*AC2(ID,IS,IND6)               33.09
     &        -0.5    * RDX(2)*CAX(ID,IS,7)*AC2(ID,IS,IND7)               33.09
     &        +0.08333* RDX(1)*CAX(ID,IS,8)*AC2(ID,IS,IND8)               33.09
     &        +0.08333* RDX(2)*CAX(ID,IS,9)*AC2(ID,IS,IND9)               33.09
     &        +(0.25*RDX(1))*(CAX1(ID,IS,2)*AC1(ID,IS,IND2)               33.09
     &        -               CAX1(ID,IS,5)*AC1(ID,IS,IND5))              33.09
     &        +(0.25*RDX(2))*(CAX1(ID,IS,3)*AC1(ID,IS,IND3)               33.09
     &        -               CAX1(ID,IS,4)*AC1(ID,IS,IND4))              33.09
            FXY2 = FXY2 + (
     &        +1.25   * RDY(1)*CAY(ID,IS,2)*AC2(ID,IS,IND2)*COSLAT(2)     33.09
     &        +1.25   * RDY(2)*CAY(ID,IS,3)*AC2(ID,IS,IND3)*COSLAT(3)     33.09
     &        -0.5    * RDY(1)*CAY(ID,IS,6)*AC2(ID,IS,IND6)*COSLAT(6)     33.09
     &        -0.5    * RDY(2)*CAY(ID,IS,7)*AC2(ID,IS,IND7)*COSLAT(7)     33.09
     &        +0.08333* RDY(1)*CAY(ID,IS,8)*AC2(ID,IS,IND8)*COSLAT(8)     33.09
     &        +0.08333* RDY(2)*CAY(ID,IS,9)*AC2(ID,IS,IND9)*COSLAT(9)     33.09
     &        +(0.25*RDY(1))*(CAY1(ID,IS,2)*AC1(ID,IS,IND2)*COSLAT(2)     33.09
     &        -               CAY1(ID,IS,5)*AC1(ID,IS,IND5)*COSLAT(5))    33.09
     &        +(0.25*RDY(2))*(CAY1(ID,IS,3)*AC1(ID,IS,IND3)*COSLAT(3)     33.09
     &        -               CAY1(ID,IS,4)*AC1(ID,IS,IND4)*COSLAT(4))    33.09
     &        ) / COSLAT(1)                                               33.09
          ENDIF                                                           33.09
 
          IF (WAVAGE.GT.0.0) THEN      ! add the anti-GSE stuff           33.08
            D11AC = AC1(ID,IS,IND5) - 2.*AC1(ID,IS,IND1) +                33.08
     &              AC1(ID,IS,IND2)                                       33.08
            D12AC = AC1(ID,IS,IND1) - AC1(ID,IS,IND2) -                   33.08
     &              AC1(ID,IS,IND3) + AC1(ID,IS,IND10)                    33.08
            D22AC = AC1(ID,IS,IND4) - 2.*AC1(ID,IS,IND1) +                33.08
     &              AC1(ID,IS,IND3)                                       33.08
            FXY2 = FXY2 +                                                 33.08
     &          DXX * (RDX(1)*RDX(1)*D11AC + 2.*RDX(1)*RDX(2)*D12AC +     33.08
     &                 RDX(2)*RDX(2)*D22AC) +                             33.08
     &          2.*DXY * (RDX(1)*RDY(1)*D11AC + RDX(2)*RDY(2)*D22AC +     33.08
     &                (RDX(1)*RDY(2)+RDX(2)*RDY(1))*D12AC) +              33.08
     &          DYY * (RDY(1)*RDY(1)*D11AC + 2.*RDY(1)*RDY(2)*D12AC +     33.08
     &                 RDY(2)*RDY(2)*D22AC)                               33.08
            IF (ITEST.GE.120 .AND. TESTFL) WRITE (PRTEST, 6014)
     &      ID, IS, DSS, DNN, DXX, DXY, DYY, D11AC, D12AC, D22AC
 6014       FORMAT (1X, 2I4, 1X, 2E12.4, 1X, 3E12.4, 1X, 4E12.4)
          END IF                                                          33.08
!
!         *** the term FXY2 is known, store in IMATRA ***
!         *** the term FXY1 is unknown, store in IMATDA ***
 
!         for the S&L scheme, we do the rollback                          33.08
!         regardless of itermx.                                           33.08
          ACOLD = AC1(ID,IS,KCGRD(1))                                     33.08
 
!         note that we include dt terms in stationary mode calcs          33.08
          IMATRA(ID,IS) = IMATRA(ID,IS) + FXY2 + ACOLD*RDTIM              33.08
          IMATDA(ID,IS) = IMATDA(ID,IS) + FXY1 + RDTIM                    33.08
!
!         *** test output ***
!
          IF ( ITEST .GE. 150 .AND. TESTFL ) THEN
              WRITE(PRINTF,6021) ID, FXY1, FXY2, ACOLD
 6021         FORMAT (' - ID FXY1 FXY2 ACOLD:', I4, 3(1X,E12.4))
          ENDIF
!
 100    CONTINUE
 200  CONTINUE
!
      IF (TESTFL .AND. ITEST .GE. 100) THEN
        WRITE(PRINTF,*) '  matrix coefficients at SANDL : '
        WRITE(PRINTF,*)
     & 'IS ID IDDUM     IMATDA    IMATRA'
        DO IS = 1, ISSTOP
          DO IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE(PRINTF,2102) IS,IDDUM,ID,
     &                 IMATDA(ID,IS), IMATRA(ID,IS)
 2102       FORMAT(3I3,2E12.4)
          ENDDO
        ENDDO
      END IF
!     End of subroutine SANDL
      RETURN
      END
!
C****************************************************************
C
      SUBROUTINE STRSSI(MSC     ,MDC     ,ICMAX   ,PNUMS   ,SPCSIG  ,     30.72
     &                  CAS     ,IMAT5L  ,IMATDA  ,IMAT6U  ,ANYBIN  ,
     &                  IMATRA  ,AC2     ,ISCMIN  ,ISCMAX  ,IDDLOW  ,
     &                  IDDTOP  ,KCGRD   ,MCGRD                     )     30.21
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     comp. of @[CAS AC2]/@S initial & boundary : IMPLICIT SCHEME
C
C  3. Method
C
C     Compute the derivative in S-direction only n the central
C     gridpoint considered:
C                             Central grid point     : IC = 1
C
C     Depending on the parameter PNUMS(7) either a central difference
C     scheme (PNUMS(7) = 0) or an upstream scheme (PNUMS(7) = 1) is
C     used. Points 1, 2 and 3 are three consecutive points on the
C     T-axis. 2 is the central point for which @(C*A)/@SIGMA and
C     @(C*W*A)/@SIGMA is computed.
C
C               1       2       3
C            ---O-------O-------O--- > SIGMA
C
C
C     PNUMS() = 0.  central difference scheme
C     PNUMS() = 1.  upwind scheme
C
C     @[CAS AC2]
C     ----------  =
C        @S
C
C     CAS(ID,IS+1,1) AC2(ID,IS+1,IX,IY) - CAS(ID,IS-1,1) AC2(ID,IS-1,IX,IY)
C     --------------------------------------------------------------------
C                                      2 DS
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IC          Dummy variable: ICode gridpoint:
C                      IC = 1  Top or Bottom gridpoint
C                      IC = 2  Left or Right gridpoint
C                      IC = 3  Central gridpoint
C                    Whether which value IC has, depends of the sweep
C                    If necessary IC can be enlarged by increasing
C                    the array size of ICMAX
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        ICMAX       Maximum counter for the points of the molecul
C        MXC         Maximum counter of gridpoints in x-direction
C        MYC         Maximum counter of gridpoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C                    one sweep
C
C
C        REALS:
C        ---------
C
C        DD          Width of spectral direction band
C        PNH         Equal to (1/2)*DD
C        PI          (3,14)
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        CAS     3D  Wave transport velocity in S-dirction, function of
C                    (ID,IS,IC)
C        IMATDA  2D  Coefficients of diagonal of matrix
C        IMAT5L  2D  Coefficients of lower diagonal of matrix
C        IMAT6U  2D  Coefficients of upper diagonal of matrix
C        ISCMIN  1D  Minimum counter in frequency space per direction
C        ISCMIN  1D  Maximum counter in frequency space per direction
C
C     5. SUBROUTINES CALLING
C
C        ACTION
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   -----------------------------------------------------------
C   For every S and D-direction in direction of sweep do
C     Compute the derivative in S-direction:
C     ---------------------------------------------------------
C     Store the results of the transport terms in the
C     arrays IMATDA, IMAT5L, IMAT6U
C   -------------------------------------------------------------
C   End of STRSSI
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C****************************************************************
C
      INTEGER  IS      ,ID      ,MSC     ,MDC     ,ICMAX   ,IDDLOW  ,
     &         IDDTOP  ,IDDUM   ,MCGRD                                    30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     DS      ,PNH     ,PN1     ,PN2     ,C1      ,C2      ,
     &         C3      ,A1      ,A3      ,PCD1    ,PCD2    ,RHS12   ,
     &         RHS23   ,DIAG12  ,DIAG23
C
      LOGICAL  BIN1    ,BIN3
C
      REAL     AC2(MDC,MSC,MCGRD)         ,
     &         CAS(MDC,MSC,ICMAX)         ,
     &         IMAT5L(MDC,MSC)            ,
     &         IMATDA(MDC,MSC)            ,
     &         IMAT6U(MDC,MSC)            ,
     &         IMATRA(MDC,MSC)            ,
     &         PNUMS(*)
C
      INTEGER  ISCMIN(MDC)                ,
     &         ISCMAX(MDC)
C
      LOGICAL  ANYBIN(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRSSI')
C
      DO 500 IDDUM = IDDLOW, IDDTOP
        ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        IF (ISCMIN(ID).EQ.0) GOTO 500
        DO 400 IS = ISCMIN(ID), ISCMAX(ID)
          A1 = 0.
          A3 = 0.
          C2 = CAS(ID,IS,1)
          IF ( IS .EQ. 1 ) THEN
            C1   = 0.
            A1   = 0.
            BIN1 = .FALSE.
            C3   = CAS(ID,IS+1,1)
            BIN3 = ANYBIN(ID,IS+1)
            IF (.NOT.BIN3) A3 = AC2(ID,IS+1,KCGRD(1))                     30.21
            DS   = SPCSIG(IS+1) - SPCSIG(IS)                              30.72
          ELSE IF ( IS .EQ. MSC ) THEN
            C1   = CAS(ID,IS-1,1)
            BIN1 = ANYBIN(ID,IS-1)
            IF (.NOT.BIN1) A1 = AC2(ID,IS-1,KCGRD(1))                     30.21
            C3   = C2
            A3   = 0.
            BIN3 = .FALSE.
            DS   = SPCSIG(IS) - SPCSIG(IS-1)                              30.72
          ELSE
            C1   = CAS(ID,IS-1,1)
            C3   = CAS(ID,IS+1,1)
            BIN1 = ANYBIN(ID,IS-1)
            BIN3 = ANYBIN(ID,IS+1)
            IF (.NOT.BIN1) A1 = AC2(ID,IS-1,KCGRD(1))                     30.21
            IF (.NOT.BIN3) A3 = AC2(ID,IS+1,KCGRD(1))                     30.21
            DS   = 0.5 * ( SPCSIG(IS+1) - SPCSIG(IS-1) )                  30.72
          END IF
C
          PNH = 1. / (2. * DS)
          PN1 =  (1. - PNUMS(7) ) * PNH
          PN2 =  (1. + PNUMS(7) ) * PNH
C
C         *** fill the lower diagonal and the diagonal ***
C
          IF ( C1 .GT. 1.E-8 .AND. C2 .GT. 1.E-8 ) THEN
            PCD1 = PN2 * C1
            PCD2 = PN1 * C2
          ELSE IF ( C1 .LT. -1.E-8 .AND. C2 .LT. -1.E-8 ) THEN
            PCD1 = PN1 * C1
            PCD2 = PN2 * C2
          ELSE
            PCD1 = PNH * C1
            PCD2 = PNH * C2
          END IF
*
          RHS12 = 0.
          IF ( IS .EQ. 1 .AND. C2.LT.0.) THEN
*           fully upwind approximation at the boundary of the directional
*           sector
            DIAG12 = - PCD1 - PCD2
          ELSE
            DIAG12 = - PCD2
            IF (BIN1) THEN
              IMAT5L(ID,IS) = IMAT5L(ID,IS) - PCD1
            ELSE
              RHS12 = PCD1 * A1
            ENDIF
          ENDIF
*
          IF ( C2 .GT. 1.E-8 .AND. C3 .GT. 1.E-8 ) THEN
            PCD2 = PN2 * C2
            PCD3 = PN1 * C3
          ELSE IF ( C2 .LT. -1.E-8 .AND. C3 .LT. -1.E-8 ) THEN
            PCD2 = PN1 * C2
            PCD3 = PN2 * C3
          ELSE
            PCD2 = PNH * C2
            PCD3 = PNH * C3
          END IF
*
          RHS23 = 0.
          IF (IS .EQ. MSC .AND. C2.GT.0.) THEN
*           full upwind approximation at the boundary
            DIAG23 = PCD2 + PCD3
          ELSE
            DIAG23 = PCD2
            IF (BIN3) THEN
              IMAT6U(ID,IS) = IMAT6U(ID,IS) + PCD3
            ELSE
              RHS23 = - PCD3 * A3
            ENDIF
          ENDIF
          IMATDA(ID,IS) = IMATDA(ID,IS) + DIAG12 + DIAG23
          IMATRA(ID,IS) = IMATRA(ID,IS) + RHS12 + RHS23
400     CONTINUE
500   CONTINUE
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 35 ) THEN
        WRITE(PRINTF,111) KCGRD(1), IDDLOW, IDDTOP
 111    FORMAT(' STRSSI: POINT IDDLOW IDDTOP  :',3I5)
        WRITE(PRINTF,131) PNUMS(7)
 131    FORMAT(' STRSSI: CSS                  :',2E12.4)
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) ' matrix coefficients in STRSSI'
        WRITE(PRINTF,*)
        WRITE(PRINTF,*)
     & '   IS   ID    IMAT5L       IMATDA       IMAT6U    IMATRA    CAS'
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF (ISCMIN(ID).GT.0) THEN
            DO IS = ISCMIN(ID), ISCMAX(ID)
              WRITE(PRINTF,2101) IS, ID, IMAT5L(ID,IS),IMATDA(ID,IS),
     &                         IMAT6U(ID,IS),IMATRA(ID,IS),CAS(ID,IS,1)
2101          FORMAT(1X,2I4,4X,4E12.4,E10.2)
            ENDDO
          ENDIF
        ENDDO
      END IF
C
C     End of subroutine STRSSI
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE STRSSB (MDC     ,MSC     ,ICMAX   ,IDDLOW  ,IDDTOP  ,
     &                   IDCMIN  ,IDCMAX  ,ISSTOP  ,CAX     ,CAY     ,
     &                   CAS     ,AC2     ,SPCSIG  ,IMATRA  ,PNUMS   ,    30.72
     &                   ANYBLK  ,KCGRD   ,MCGRD   ,RDX     ,RDY     )    30.21
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     comp. of @[CAS AC2]/@S initial & boundary with an explicit
C     scheme. The energy near the blocking point is removed
C     from the spectrum based on a CFL criterion
C
C     The frequencies beyond ISSTOP are blocked in a 1-D situation
C     For a 2-D case the situation is somewhat more complicated (
C     see below)
C
C
C        ^  |                       1-D case
C     E()|  |          *            ========
C           |        *   *
C           |              *
C           |       *        *      / blocking frequency
C           |                .... /
C           |      *         ....| *
C           |        SWEEP 1 ....| o o *
C           |     *          ....| o o o o o*
C          0---------------------|-----------|---------
C           0                  ISSTOP       MSC   --> s
C
C                           -|---|-
C                              ^
C                              |---- CFL > 0.5sqrt(2) -> ANYBLK = true
C
C
C               ANYBIN = TRUE     ANYBIN = FALSE
C           |--------------------|-----------|
C
C
C  3. Method
C
C     Compute the derivative in s-direction:
C     The nearby points are indicated with the index IC (see
C     FUNCTION ICODE(_,_):
C     Central grid point     : IC = 1
C     Point in X-direction   : IC = 2
C     Point in Y-direction   : IC = 3
C
C     @[CAS AC2]
C     --------- =
C        @S
C
C     CAS*AC2(ID,IS) - CAS*AC2(ID,IS-1)     F(IS+0.5) - F(IS-0.5)
C     ---------------------------------- = -----------------------
C                   DS                                DS
C
C                  /  CAS(IS+0.5) * AC2(IS+1)    IF CAS(IS+0.5) < 0
C     F(IS+0.5) =  |
C                  \  CAS(IS+0.5) * AC2(IS)      IF CAS(IS+0.5) > 0
C
C                  /  CAS(IS-0.5) * AC2(IS-1)    IF CAS(IS-0.5) > 0
C     F(IS-0.5) =  |
C                  \  CAS(IS-0.5) * AC2(IS)      IF CAS(IS-0.5) < 0
C
C     WITH:
C           CAS(IS+0.5) = ( CAS(IS+1) + CAS(IS) ) / 2.
C
C           CAS(IS-0.5) = ( CAS(IS) + CAS(IS-1) ) / 2.
C
C     ------------------------------------------------------------
C     Courant-Friedlich-Levich criterion :
C
C                  | Cs |
C                  | -- |
C                  | ds |         <
C               ---------------   =  0.5 * sqrt(2.0)
C      CFL  =  | Cx |   | Cy |
C              | -- | + | -- |
C                 | dx |   | dy |
C
C     For a bin in which the CFL criterion is larger two
C     ways are possible:
C
C            1)  Cs can be limited
C            2)  Action in bin can be set equal zero
C
C     --------------------------------------------------------------
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IC          Dummy variable: ICode gridpoint:
C                      IC = 1  Top or Bottom gridpoint
C                      IC = 2  Left or Right gridpoint
C                      IC = 3  Central gridpoint
C                    Whether which value IC has, depends of the sweep
C                    If necessary IC can be enlarged by increasing
C                    the array size of ICMAX
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        ICMAX       Maximum counter for the points of the molecul
C        MXC         Maximum counter of gridpoints in x-direction
C        MYC         Maximum counter of gridpoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C        ISSTOP      Maximum frequency counter for wave components
C                    that are propagated within a sweep
C        IDDLOW      Minimum direction that is propagated within a
C                    sweep
C        IDDTOP      Idem maximum
C
C        REALS:
C        ---------
C
C        FSA_        Dummy variable
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        AC2     4D  Action density as function of D,S,X,Y at time T
C        CAS     3D  Wave transport velocity in S-dirction, function of
C                    (ID,IS,IC)
C        CAX, CAY    Propagation velocities in x-y space
C        IMATRA  2D  Coefficients of right hand side of matrix
C        ISCMIN  1D  Diractional dependent counter
C        ISCMIN  1D  Directional dependent counter
C        ANYBLK  2D  Determines if a bin is BLOCKED by a counter current
C                    based on a CFL criterion
C
C     5. SUBROUTINES CALLING
C
C        ACTION
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every S and D-direction in direction of sweep do,
C     Determine if CFL criterion is satisfied
C     Compute the derivative in s-direction:
C     ---------------------------------------------------------
C     Compute transportation terms
C     Store the terms in the array IMATRA
C   -------------------------------------------------------------
C   End of STRSSB
C   -------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS      ,ID      ,MSC    ,MDC     ,ICMAX   ,ISSTOP  ,
     &         IDDLOW  ,IDDTOP  ,IDDUM  ,MCGRD                            30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     FSA     ,FLEFT   ,FRGHT   ,DS      ,CFLMAX  ,CFLCEN  ,
     &         CAXCEN  ,CAYCEN  ,CASCEN  ,TX      ,TY      ,TS      ,
     &         CASL    ,CASR
C
      REAL     CAS(MDC,MSC,ICMAX)       ,
     &         CAX(MDC,MSC,ICMAX)       ,
     &         CAY(MDC,MSC,ICMAX)       ,
     &         AC2(MDC,MSC,MCGRD)       ,
     &         IMATRA(MDC,MSC)          ,
     &         PNUMS(*)                 ,
     &         RDX(2)                   ,
     &         RDY(2)
C
      INTEGER  IDCMIN(MSC)              ,
     &         IDCMAX(MSC)
C
      LOGICAL  ANYBLK(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRSSB')
C
C     *** initialization of array and CFLMAX value ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          ANYBLK(ID,IS) = .FALSE.
        ENDDO
      ENDDO
      CFLMAX = PNUMS(19)
C
      DO IS = 1, ISSTOP
        IF ( IS .EQ. 1 ) THEN
          DS = SPCSIG(IS+1) - SPCSIG(IS)                                  30.72
        ELSE IF ( IS .EQ. MSC ) THEN
          DS = SPCSIG(IS) - SPCSIG(IS-1)                                  30.72
        ELSE
          DS = 0.5 * ( SPCSIG(IS+1) - SPCSIG(IS-1) )                      30.72
        END IF
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          CAXCEN = ABS ( CAX(ID,IS,1) )
          CAYCEN = ABS ( CAY(ID,IS,1) )
          CASCEN = ABS ( CAS(ID,IS,1) )
C
          TX     = RDX(1) * CAXCEN + RDX(2) * CAXCEN
          TY     = RDY(1) * CAYCEN + RDY(2) * CAYCEN
C
          TS     = CASCEN / DS
          CFLCEN = TS / MAX( 1.E-20 , ( TX + TY ) )
          FRGHT = 0.
          FLEFT = 0.
C
C         *** check if a bin can be propagated or if it is blocked ***
C
          IF ( CFLCEN .GT. CFLMAX ) THEN
C
C           *** de-activate bin in solver by ANYBLK ***
C
            ANYBLK(ID,IS) = .TRUE.
C
          ELSE
C
C           *** calculate transport in frequency space ***
C
            IF ( IS .EQ. 1 ) THEN
C             *** for first point an upwind scheme is used ***
              CASR  = 0.5 * ( CAS(ID,IS,1) + CAS(ID,IS+1,1) )
              IF ( CASR .LT. 0. ) THEN
                FRGHT = CASR * AC2(ID,IS+1,KCGRD(1))                      30.21
              ELSE
                FRGHT = CASR * AC2(ID,IS,KCGRD(1))                        30.21
              END IF
              FLEFT = 0.
            ELSE IF ( IS .EQ. MSC ) THEN
C             *** for the last discrete pointin frequency space ***
C             *** an upwind scheme is used                      ***
              CASL = CAS(ID,IS-1,1)
              CASR = CAS(ID,IS,1  )
              IF ( CASL .LT. 0. ) THEN
                FLEFT = CASL * AC2(ID,IS,KCGRD(1))                        30.21
              ELSE
                FLEFT = CASL * AC2(ID,IS-1,KCGRD(1))                      30.21
              END IF
              IF ( CASR .LT. 0. ) THEN
C               *** assumption has been made that the flux is ***
C               *** zero for the bin beyond MSC               ***
                FRGHT = 0.
              ELSE
                FRGHT = CASR * AC2(ID,IS,KCGRD(1))                        30.21
              END IF
            ELSE
C             *** point in frequency range ***
              CASL  = 0.5 * ( CAS(ID,IS,1) + CAS(ID,IS-1,1) )
              CASR  = 0.5 * ( CAS(ID,IS,1) + CAS(ID,IS+1,1) )
              IF ( CASL .LT. 0. ) THEN
                FLEFT = CASL * AC2(ID,IS,KCGRD(1))                        30.21
              ELSE
                FLEFT = CASL * AC2(ID,IS-1,KCGRD(1))                      30.21
              END IF
              IF ( CASR .LT. 0. ) THEN
                FRGHT = CASR * AC2(ID,IS+1,KCGRD(1))                      30.21
              ELSE
                FRGHT = CASR * AC2(ID,IS,KCGRD(1))                        30.21
              END IF
            END IF
C
            FSA  = ( FRGHT - FLEFT ) / DS
C
C           *** all the terms are known, store in IMATRA ***
C
            IMATRA(ID,IS) = IMATRA(ID,IS) - FSA
          ENDIF
C
C         *** test output ***
 
          IF ( ITEST .GE. 50 .AND. TESTFL ) THEN
            WRITE(PRINTF,670) IS,ID,FRGHT,FLEFT,CFLCEN,ANYBLK(ID,IS)
 670        FORMAT(' STRSSB: FR FL CFLC ANYBLK:',2I3,3E12.4,L3)
          END IF
 
C
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF ( ITEST .GE. 50 .AND. TESTFL ) THEN
        WRITE(PRINTF,200) MDC,MSC,MCGRD
 200    FORMAT(' BLOCKB : MDC MSC MCGRD    : ',3I5)
        WRITE(PRINTF,300) KCGRD(1), ISSTOP, CFLMAX
 300    FORMAT(' BLOCKB : POINT ISSTOP CFLMAX: ',2I5,F8.4)
        WRITE(PRINTF,400) IDDLOW, IDDTOP
 400    FORMAT (' Active bins within a sweep  -> ID: ',I3,' to ',I3)
        WRITE(PRINTF,*)
        WRITE(PRINTF,*)(' Propagation of bin if blocking can occur')
        WRITE(PRINTF,*)('   1) No blocking of bin -> ANYBLK = .F.')
        WRITE(PRINTF,*)('   2) Blocking of bin    -> ANYBLK = .T.')
        WRITE(PRINTF,*)
        DO IDDUM = IDDTOP+1, IDDLOW-1, -1
          ID = MOD ( IDDUM - 1 + MDC, MDC) + 1
            WRITE(PRINTF,500) ID, (ANYBLK(ID,IS),IS=1,MIN(ISSTOP,25))
 500        FORMAT(I4,25L3)
        ENDDO
        WRITE(PRINTF,600)(IS, IS=1+4, MIN(ISSTOP,25), 5 )
 600    FORMAT(6X,'1',9X,5(I3,12X))
        WRITE(PRINTF,*)
C
      ENDIF
C
C     End of subroutine STRSSB
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE STRSS1 (ICMAX   ,SECTOR  ,MSC     ,MDC     ,IDCMIN  ,
     &                   IDCMAX  ,CAS     ,AC2     ,IMATRA  ,SPCSIG  ,    30.72
     &                   CAX     ,CAY     ,PNUMS   ,KCGRD   ,MCGRD   ,
     &                   RDX     ,RDY                                )    30.21
C
C****************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     comp. of @[CAS AC2]/@S initial & boundary : TOLMAN METHOD
C
C  3. Method
C
C     Compute the derivative in s-direction:
C     The nearby points are indicated with the index IC (see
C     FUNCTION ICODE(_,_):
C     Central grid point     : IC = 1
C     Point in X-direction   : IC = 2
C     Point in Y-direction   : IC = 3
C
C     @[CAS AC2]
C     --------- =
C         @S
C
C     CAS*AC2(ID,IS) - CAS*AC2(ID,IS-1)     F(IS+0.5) - F(IS-0.5)
C     ---------------------------------- = -----------------------
C                   DS                                DS
C
C     FLR = F(IS+0.5) = 0.5 ( CAS(IS)*AC2(IS) + CAS(IS+1)*AC2(IS+1) )
C     FLL = F(IS-0.5) = 0.5 ( CAS(IS)*AC2(IS) + CAS(IS-1)*AC2(IS-1) )
C
C     IF FLR is < 0 then -FRL
C               > 0 then +FRL
C
C        limit the flux:
C        FLUXMAX = MIN ( AC2 * DS / DT , FLRR )
C
C        FLL is > 0 then +FLL
C               < 0 then -FLL
C
C        limit the flux:
C        FLUXMAX = MIN ( AC2 * DS / DT , FLLL )
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IC          Dummy variable: ICode gridpoint:
C                      IC = 1  Top or Bottom gridpoint
C                      IC = 2  Left or Right gridpoint
C                      IC = 3  Central gridpoint
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        ICMAX       Maximum counter for the points of the molecul
C        MXC         Maximum counter of gridpoints in x-direction
C        MYC         Maximum counter of gridpoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        AC2     4D  Action density as function of D,S,X,Y at time T
C        CAS     3D  Wave transport velocity in S-dirction, function of
C                    (ID,IS,IC)
C        IMATRA  2D  Coefficients of right hand side of matrix
C        IDCMIN  1D  frequency dependent counter
C        IDCMIN  1D  frequency dependent counter
C        SECTOR  1D  Counter for number enclosed sectors
C
C     5. SUBROUTINES CALLING
C
C        ACTION
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every S and D-direction in direction of sweep do,
C     Compute the derivative in s-direction:
C     ---------------------------------------------------------
C     Compute transportation terms
C     Store the terms in the array IMATRA
C   -------------------------------------------------------------
C   End of STRSS1
C   -------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS      ,ID      ,MSC     ,MDC     ,ICMAX    ,MCGRD        30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     FSA     ,FLEFT   ,FRGHT   ,DS      ,DXDY
C
      REAL     CAS(MDC,MSC,ICMAX)       ,
     &         CAX(MDC,MSC,ICMAX)       ,
     &         CAY(MDC,MSC,ICMAX)       ,
     &         AC2(MDC,MSC,MCGRD)       ,
     &         IMATRA(MDC,MSC)          ,
     &         PNUMS(*)                 ,
     &         RDX(2)                   ,
     &         RDY(2)
C
      INTEGER  IDCMIN(MSC)              ,
     &         IDCMAX(MSC)              ,
     &         SECTOR(MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRSS1')
C
      DO 200 IS = 1, MSC
        IF ( SECTOR(IS) .GT. 0 ) THEN
          DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IF ( IS .EQ. 1) THEN
C             *** for the first point an upwind scheme is used ***
C             *** the term F(ID,IS-0.5) is equal zero assuming ***
C             *** that the action is zero at a node left from  ***
C             *** IS = 1                                       ***
C
              DS = SPCSIG(IS+1) - SPCSIG(IS)                              30.72
              FLUXR  = 0.5 * ( CAS(ID,IS,1)    * AC2(ID,IS,KCGRD(1)) +
     &                         CAS(ID,IS+1,1)  * AC2(ID,IS+1,KCGRD(1)) )
              FLUXRR = ABS ( FLUXR )
C
              IF ( FLUXR .LT. 0. ) THEN
              DXCAX =ABS (RDX(1)*CAX(ID,IS+1,1) + RDX(2)*CAX(ID,IS+1,1))  30.21
              DYCAY =ABS (RDY(1)*CAY(ID,IS+1,1) + RDY(2)*CAY(ID,IS+1,1))  30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS+1,KCGRD(1)) * DS * DXDY
                FRGHT  = -1. * MIN( AUX1 , FLUXRR )
              ELSE
              DXCAX =ABS (RDX(1)*CAX(ID,IS,1) + RDX(2)*CAX(ID,IS,1))      30.21
              DYCAY =ABS (RDY(1)*CAY(ID,IS,1) + RDY(2)*CAY(ID,IS,1))      30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS,KCGRD(1)) * DS * DXDY
                FRGHT  = MIN( AUX1, FLUXRR )
              END IF
              FLEFT  = 0.
C
            ELSE IF ( IS .EQ. MSC ) THEN
 
C             *** for the last point an upwind scheme is used  ***
C             *** the term F(ID,IS+0.5) is equal zero          ***
C             *** THIS PART HAS TO BE MODIFIED ??????????????  ***
C             *** IN CASE THE CUTOFF FREQUENCY IS NOT EQUAL TO ***
C             *** MSC                                          ***
C
              DS = SPCSIG(IS) - SPCSIG(IS-1)                              30.72
              FLUXL  = 0.5 * ( CAS(ID,IS,1)    * AC2(ID,IS,KCGRD(1)) +
     &                         CAS(ID,IS-1,1)  * AC2(ID,IS-1,KCGRD(1)) )
              FLUXLL = ABS ( FLUXL )
              IF ( FLUXL .LT. 0. ) THEN
                DXCAX = ABS (RDX(1)*CAX(ID,IS,1) + RDX(2)*CAX(ID,IS,1))   30.21
                DYCAY = ABS (RDY(1)*CAY(ID,IS,1) + RDY(2)*CAY(ID,IS,1))   30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS,KCGRD(1)) * DS * DXDY
                FLEFT  = -1. * MIN( AUX1 , FLUXLL )
              ELSE
                DXCAX =
     &               ABS (RDX(1)*CAX(ID,IS-1,1) + RDX(2)*CAX(ID,IS-1,1))  30.21
                DYCAY =
     &               ABS (RDY(1)*CAY(ID,IS-1,1) + RDY(2)*CAY(ID,IS-1,1))  30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS-1,KCGRD(1)) * DS * DXDY
                FLEFT  = MIN( AUX1 , FLUXLL )
              END IF
              FRGHT = 0.
            ELSE
C
              DS = 0.5 * ( SPCSIG(IS+1) - SPCSIG(IS-1) )                  30.72
C
C             *** average propagatuion velocity and flux in the ***
C             *** two cross sections adjacent the node IS       ***
C
              FLUXL  = 0.5 * ( CAS(ID,IS,1)    * AC2(ID,IS,KCGRD(1)) +
     &                         CAS(ID,IS-1,1)  * AC2(ID,IS-1,KCGRD(1)) )
              FLUXR  = 0.5 * ( CAS(ID,IS,1)    * AC2(ID,IS,KCGRD(1)) +
     &                         CAS(ID,IS+1,1)  * AC2(ID,IS+1,KCGRD(1)) )
              FLUXLL = ABS ( FLUXL )
              FLUXRR = ABS ( FLUXR )
              IF ( FLUXL .LT. 0. ) THEN
                DXCAX =ABS (RDX(1)*CAX(ID,IS,1) + RDX(2)*CAX(ID,IS,1))    30.21
                DYCAY =ABS (RDY(1)*CAY(ID,IS,1) + RDY(2)*CAY(ID,IS,1))    30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS,KCGRD(1)) * DS * DXDY
                FLEFT  = -1. * MIN( AUX1 , FLUXLL )
              ELSE
              DXCAX =ABS (RDX(1)*CAX(ID,IS-1,1) + RDX(2)*CAX(ID,IS-1,1))  30.21
              DYCAY =ABS (RDY(1)*CAY(ID,IS-1,1) + RDY(2)*CAY(ID,IS-1,1))  30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS-1,KCGRD(1)) * DS * DXDY
                FLEFT  = MIN( AUX1 , FLUXLL )
              END IF
C
              IF ( FLUXR .LT. 0. ) THEN
              DXCAX =ABS (RDX(1)*CAX(ID,IS+1,1) + RDX(2)*CAX(ID,IS+1,1))  30.21
              DYCAY =ABS (RDY(1)*CAY(ID,IS+1,1) + RDY(2)*CAY(ID,IS+1,1))  30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS+1,KCGRD(1)) * DS * DXDY
                FRGHT  = -1. * MIN( AUX1 , FLUXRR )
              ELSE
              DXCAX =ABS (RDX(1)*CAX(ID,IS,1) + RDX(2)*CAX(ID,IS,1))      30.21
              DYCAY =ABS (RDY(1)*CAY(ID,IS,1) + RDY(2)*CAY(ID,IS,1))      30.21
                DXDY   = MAX ( DXCAX ,DYCAY )
                AUX1   = AC2(ID,IS,KCGRD(1)) * DS * DXDY
                FRGHT  = MIN( AUX1, FLUXRR )
              END IF
            END IF
C
            FSA  = ( FRGHT - FLEFT ) / DS
C
C           *** all the terms are known, store in IMATRA ***
C
            IMATRA(ID,IS) = IMATRA(ID,IS) - FSA
C
C           *** test remove on vector computer ***
C
*C/V            IF ( ITEST .GE. 30 .AND. TESTFL ) THEN
*C/V              CFLX =  ABS(CAS(ID,IS,1) * DX / ( CAX(ID,IS,1) * DS ))
*C/V              CFLY =  ABS(CAS(ID,IS,1) * DY / ( CAY(ID,IS,1) * DS ))
*C/V              WRITE(PRINTF,6125) IX ,IY ,IS ,ID ,SECTOR(IS) ,PNUMS(5)
*C/V 6125         FORMAT(' STRSS1 : IX IY IS ID SECT TOL :',5I3,F8.3)
*C/V              WRITE(PRINTF,6122) CAS(ID,IS,1),CFLX, CFLY
*C/V 6122         FORMAT(' STRSS1 : CAS CFLX CFLY        :',3E12.4)
*C/V            END IF
C
 100      CONTINUE
        END IF
 200  CONTINUE
C
C     End of subroutine STRSS1
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE STRSD (MSC     ,MDC     ,ICMAX   ,DD      ,IDCMIN  ,
     &                  IDCMAX  ,CAD     ,IMATLA  ,IMATDA  ,IMATUA  ,
     &                  IMATRA  ,AC2     ,PNUMS   ,ISSTOP  ,FULCIR  ,
     &                  ANYBIN  ,LEAKC1  ,KCGRD   ,MCGRD            )     30.21
 
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     1. UPDATE
C
C        ---
C
C     2. PURPOSE
C
C        comp. of @[CAD AC2]/@D initial & boundary
C
C     3. METHOD
C
C        Compute the derivative in D-direction only n the central
C        gridpoint considered:
C                                Central grid point     : IC = 1
C
C       Depending on the parameter PNUMS(6) either a central difference
C       scheme (PNUMS(6) = 0) or an upstream scheme (PNUMS(6) = 1) is
C       used. Points 1, 2 and 3 are three consecutive points on the
C       T-axis. 2 is the central point for which @(C*A)/@THETA and
C       @(C*W*A)/@THETA is computed.
C
C                 1       2       3
C              ---O-------O-------O--- > THETA
C
C
C        PNUMS() = 0.  central difference scheme
C        PNUMS() = 1.  upwind scheme
C
C        @[CAD AC2]
C        ----------  =
C           @D
C
C        CAD(ID+1,IS,1) AC2(ID+1,IS,IX,IY) - CAD(ID-1,IS,1) AC2(ID-1,IS,IX,IY)
C        --------------------------------------------------------------------
C                                         2*DD
C
C     4. PARAMETERLIST
C
C        IC          Dummy variable: ICode gridpoint:
C                      IC = 1  Top or Bottom gridpoint
C                      IC = 2  Left or Right gridpoint
C                      IC = 3  Central gridpoint
C                    Whether which value IC has, depends of the sweep
C                    If necessary IC can be enlarged by increasing
C                    the array size of ICMAX
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        ICMAX       Maximum counter for the points of the molecul
C        MXC         Maximum counter of gridpoints in x-direction
C        MYC         Maximum counter of gridpoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
*        FULCIR      logical: if true, computation on a full circle
C
C        REALS:
C        ---------
C
C        DD          Width of spectral direction band
C        PNH         Equal to (1/2)*DD
C        PI          (3,14)
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        CAD     3D  Wave transport velocity in S-dirction, function of
C                    (ID,IS,IC)
C        IMATDA  2D  Coefficients of diagonal of matrix
C        IMATLA  2D  Coefficients of lower diagonal of matrix
C        IMATUA  2D  Coefficients of upper diagonal of matrix
C        IDCMIN  1D  frequency dependent counter
C        IDCMIN  1D  frequency dependent counter
*        ANYBIN  2D  see subr SWPSEL
*        LEAKC1  2D  leak coefficient
C
C     5. SUBROUTINES CALLING
C
C        ACTION
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   -----------------------------------------------------------
C   For every S and D-direction in direction of sweep do
C     Compute the derivative in D-direction:
C     ---------------------------------------------------------
C     Store the results of the transport terms in the
C     arrays IMATDA, IMATLA, IMATUA
C   -------------------------------------------------------------
C   End of STRSD
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C****************************************************************
C
      LOGICAL  FULCIR, BIN1, BIN2, BIN3
*
      INTEGER  IS    ,ID    ,MSC   ,MDC   ,ICMAX ,IIDM  ,IIDP  ,
     &         ISSTOP,IDDUM ,MCGRD                                        30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     DD    ,PNH   ,PN1   ,PN2
C
      REAL     AC2(MDC,MSC,MCGRD)         ,                               30.21
     &         CAD(MDC,MSC,ICMAX)         ,
     &         IMATLA(MDC,MSC)            ,
     &         IMATDA(MDC,MSC)            ,
     &         IMATUA(MDC,MSC)            ,
     &         IMATRA(MDC,MSC)            ,
     &         LEAKC1(MDC,MSC)            ,
     &         PNUMS(*)
C
      INTEGER  IDCMIN(MSC)                ,
     &         IDCMAX(MSC)
C
      LOGICAL  ANYBIN(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRSD')
C
      PNH = 1. / (2. * DD)
      PN1 =  (1. - PNUMS(6) ) * PNH
      PN2 =  (1. + PNUMS(6) ) * PNH
C
      DO 200 IS = 1, ISSTOP
*VDIR NODEP(IMATDA)
*VDIR NODEP(IMATRA)
*VDIR NODEP(IMATLA)
*VDIR NODEP(IMATUA)
*VDIR NODEP(LEAKC1)
        DO 100 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD (IDDUM-1+MDC, MDC) + 1
          C2 = CAD(ID,IS,1)
          BIN2 = ANYBIN(ID,IS)
          IF (BIN2) THEN
            IF (FULCIR .OR. ID.GT.1) THEN
              IIDM = MOD (IDDUM-2+MDC, MDC) + 1
              C1   = CAD(IIDM,IS,1)
              BIN1 = ANYBIN(IIDM,IS)
              IF (.NOT.BIN1) A1 = AC2(IIDM,IS,KCGRD(1))
            ELSE
              IIDM = 0
              C1   = C2
              BIN1 = .FALSE.
              A1   = 0.
            ENDIF
            IF (FULCIR .OR. ID.LT.MDC) THEN
              IIDP = MOD (IDDUM+MDC, MDC) + 1
              C3   = CAD(IIDP,IS,1)
              BIN3 = ANYBIN(IIDP,IS)
              IF (.NOT.BIN3) A3 = AC2(IIDP,IS,KCGRD(1))                   30.21
            ELSE
              IIDP = 0
              C3   = C2
              BIN3 = .FALSE.
              A3   = 0.
            ENDIF
C
C           *** fill the lower diagonal and the diagonal ***
C
            IF ( C1 .GT. 1.E-8 .AND. C2 .GT. 1.E-8 ) THEN
              PCD1 = PN2 * C1
              PCD2 = PN1 * C2
            ELSE IF ( C1 .LT. -1.E-8 .AND. C2 .LT. -1.E-8 ) THEN
              PCD1 = PN1 * C1
              PCD2 = PN2 * C2
            ELSE
              PCD1 = PNH * C1
              PCD2 = PNH * C2
            END IF
*
            RHS12 = 0.
            IF (IIDM.EQ.0 .AND. C2.LT.0.) THEN
*             fully upwind approximation at the boundary of the directional
*             sector
              DIAG12 = - PCD1 - PCD2
              LEAKC1(ID,IS) = -C2
            ELSE
              DIAG12 = - PCD2
              IF (BIN1) THEN
                IMATLA(ID,IS) = IMATLA(ID,IS) - PCD1
              ELSE
                RHS12 = PCD1 * A1
              ENDIF
            ENDIF
*
            IF ( C2 .GT. 1.E-8 .AND. C3 .GT. 1.E-8 ) THEN
              PCD2 = PN2 * C2
              PCD3 = PN1 * C3
            ELSE IF ( C2 .LT. -1.E-8 .AND. C3 .LT. -1.E-8 ) THEN
              PCD2 = PN1 * C2
              PCD3 = PN2 * C3
            ELSE
              PCD2 = PNH * C2
              PCD3 = PNH * C3
            END IF
*
            RHS23 = 0.
            IF (IIDP.EQ.0 .AND. C2.GT.0.) THEN
*             full upwind approximation at the boundary
              DIAG23 = PCD2 + PCD3
              LEAKC1(ID,IS) = C2
            ELSE
              DIAG23 = PCD2
              IF (BIN3) THEN
                IMATUA(ID,IS) = IMATUA(ID,IS) + PCD3
              ELSE
                RHS23 = - PCD3 * A3
              ENDIF
            ENDIF
            IMATDA(ID,IS) = IMATDA(ID,IS) + DIAG12 + DIAG23
            IMATRA(ID,IS) = IMATRA(ID,IS) + RHS12 + RHS23
          ENDIF
*
 100    CONTINUE
 200  CONTINUE
C
C     *** test output
C
      IF ( ITEST .GE. 80 .AND. TESTFL ) THEN
        WRITE(PRINTF,5001) FULCIR
5001    FORMAT (' FULL CIRCLE                   ',L4)
        WRITE(PRINTF,6021) KCGRD(1), ISSTOP, PNUMS(6)                     30.21
6021    FORMAT (' STRSD :POINT ISTOP CDD      :',2I5,E12.4)
        WRITE(PRINTF,5021) PN1, PN2, PNH ,DD
5021    FORMAT (' STRSD : PN1 PN2 PNH DD      :',4E12.4)
      END IF
C
C     End of subroutine STRSD
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SPREDT (SWPDIR     ,AC2        ,CAX       ,
     &                   CAY        ,IDCMIN     ,IDCMAX    ,
     &                   ISSTOP     ,ANYBIN     ,
     &                   RDX        ,RDY        ,OBREDF      )            40.00
C
C****************************************************************
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
!     0. Authors
 
!     40.00, 40.13: Nico Booij
 
C     1. UPDATE
C
C        40.00, Aug 98: introduction of obstacle reduction factor to
C                       obtain correct initialisation
C                       argument list changed, swcomm3 added
!        40.13, Aug 01: modification of action densities is skipped
!                       in case of Mode Noupdate
C
C     2. PURPOSE
C
C        to predict the action density depending of the sweep
C        direction. A good prediction is necessary for a first
C        accurate prediction of the action density to compute
C        the dissipation of energy. To compute the energy dissipation
C        a prediction is needed at time T.
C
C     3. METHOD
C
C
C          [RDX1*CAX + RDY1*CAY]*N(i-1,j) + [RDX2*CAX + RDY2*CAY]*N(i,j-1)
C N(i,j) = ---------------------------------------------------------------
C                      (RDX1+RDX2) * CAX  +  (RDY1+RDY2) * CAY
C
C     4. PARAMETERLIST
C
C       INTEGERS:
C       ---------
C       IC           Dummy variable: ICode gridpoint:
C                    IC = 1  Top or Bottom gridpoint
C                    IC = 2  Left or Right gridpoint
C                    IC = 3  Central gridpoint
C                    Whether which value IC has, depends of the sweep
C                    If necessary ic can be enlarged by increasing
C                    the array size of ICMAX
C       IX           Counter of gridpoints in x-direction
C       IY           Counter of gridpoints in y-direction
C       IS           Counter of relative frequency band
C       ID           Counter of directional distribution
C       ICMAX        Maximum array size for the points of the molecul
C       MXC          Maximum counter of gridppoints in x-direction
C       MYC          Maximum counter of gridppoints in y-direction
C       MSC          Maximum counter of relative frequency
C       MDC          Maximum counter of directional distribution
C       KSX          Dummy variable to get the right sign in the
C                    numerical difference scheme in X-direction
C                    depending of the sweep direction, KSX = -1 or +1
C       KSY          Dummy variable to get the right sign in the
C                    numerical difference scheme in Y-direction
C                    depending of the sweep direction, KSY = -1 or +1
C       SWPDIR       Sweep direction (..) (identical at the description
C                    of the direction the wind is blowing)
C
C       REALS:
C       ------
C
C       DX           Length of spatial cell in X-direction
C       DY           Length of spatial cell in Y-direction
C       ALEN         Part of side length of an angle side
C       BLEN         Part of side length of an angle side
C       LDIAG        Length of the diagonal of grid cel
C       ALPHA        angle of propagation velocity
C       BETA         angle between DX end DY
C       GAMMA        PI - alpha - beta
C       PI           3,14.......
C       FAC_A        Factor representing the influence of the action-
C                    density depening of the propagation velocity
C       FAC_B        Factor representing the influence of the action-
C                    density depening of the propagation velocity
C
C       REAL arrays:
C       -------------
C
C       AC2    4D    Action density as function of D,S,X,Y at time T
C       CAX    3D    Wave transport velocity in x-direction, function of
C                    (ID,IS,IC)
C       CAY    3D    Wave transport velocity in y-direction, function of
C                    (ID,IS,IC)
C       IDCMIN 1D    frequency dependent counters in case of a current
C       IDCMAX 1D    frequency dependent counters in case of a current
C       ANYBIN 2D    Determines if a bin fall within a sweep
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every sweep direction do,
C     For every point in S and D direction in sweep direction do,
C       predict values for action density at new point from values
C       of neighbour gridpoints taking into account spectral propagation
C       direction (with currents !!) and the boundary conditions.
C       --------------------------------------------------------
C       If wave action AC2 is negative, then
C         Give wave action initial value 1.E-10
C     ---------------------------------------------------------
C   End of SPREDT
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS    ,ID    ,
     &         SWPDIR,IDDUM ,ISSTOP                                       40.00
C
      REAL     FAC_A ,FAC_B
C
      REAL  :: AC2(MDC,MSC,MCGRD)                                         30.21
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAX(MDC,MSC,MICMAX)                                        40.22
      REAL  :: CAY(MDC,MSC,MICMAX)                                        40.22
      REAL  :: RDX(2) ,  RDY(2)         ,                                 30.21
     &         OBREDF(MDC,MSC,2)                                          40.00
C
      INTEGER  IDCMIN(MSC)              ,
     &         IDCMAX(MSC)
C
      LOGICAL  ANYBIN(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SPREDT')
C
C     *** When a current is present the propagation direction of the ***
C     *** energy is not equal to the direction normal to the crest   ***
C     *** of the waves. The dependent variables are CAX and CAY.     ***
C     *** Because the current is already discount in these variables ***
C     *** in the subroutine SPROSD, the subroutine SPREDT is valid   ***
C     *** for the case with or without currents !                    ***
C
C
C     *** for the four sweeps  ***           10/FEB
C
        DO 200 IS = 1, ISSTOP
          DO 190 IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IF ( ANYBIN(ID,IS) ) THEN
C
*             *** Computation of weighting coef WEIG1 AND WEIG2***
C
              CDEN = RDX(1) * CAX(ID,IS,1) + RDY(1) * CAY(ID,IS,1)
              CNUM =  (RDX(1) + RDX(2)) * CAX(ID,IS,1)
     &              + (RDY(1) + RDY(2)) * CAY(ID,IS,1)
              WEIG1 = CDEN/CNUM
              WEIG2 = 1. - WEIG1
C
              IF (NUMOBS .GT. 0) THEN
                TCF1 = OBREDF(ID,IS,1)                                    40.00
                TCF2 = OBREDF(ID,IS,2)                                    40.00
              ELSE
                TCF1 = 1.
                TCF2 = 1.
              ENDIF
              FAC_A = TCF1 * WEIG1 * AC2(ID,IS,KCGRD(2))                  40.00
              FAC_B = TCF2 * WEIG2 * AC2(ID,IS,KCGRD(3))                  40.00
C
              IF (ACUPDA)                                                 40.13
     &        AC2(ID,IS,KCGRD(1)) = MAX ( 0. , (FAC_A + FAC_B))           30.21
            END IF
 190      CONTINUE
 200    CONTINUE
C
C     *** test remove on vector computer ***
C
      IF ( ITEST .GE. 140 .AND. TESTFL ) THEN
        WRITE(PRINTF,6019) KCGRD(1), SWPDIR
 6019   FORMAT(' PREDT : POINT INDX  SWPDIR         :',2I5)
        DO 610 IS = 1, ISSTOP
          DO 600 IDDUM = IDCMIN(IS)-1, IDCMAX(IS)+1
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            WRITE (PRINTF,6020) IS, ID, AC2(ID,IS,KCGRD(1)),
     &                          AC2(ID,IS,KCGRD(2)),
     &                          AC2(ID,IS,KCGRD(3)),
     &                          ANYBIN(ID,IS)
 6020       FORMAT ('       : IS ID AC2 AC2(2) AC2(3) ANYBIN   :',
     &              2I5,3(E12.4),L4)
 600      CONTINUE
 610    CONTINUE
      END IF
C
C     End of the subroutine SPREDT
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SWAPAR (               MSC           ,                   40.13
     &                   MDC           ,ICMAX         ,
     &                   CG            ,ICUR          ,
     &                   GRAV          ,DEP2          ,
     &                   KWAVE         ,CGO           ,
     &                   ECOS          ,ESIN          ,
     &                   UX2           ,UY2           ,
     &                   SPCSIG        ,KCGRD         ,                   30.72
     &                   MCGRD         ,DEPMIN                                  30.21
     &                                                )
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
!     40.13: Nico Booij
C
C  1. Updates
C
C     20.96, Jan. 96: Computation of CGO etc. taken out of ID loop
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
C     30.82, July 99: Corrected argumentlist KSCIP1
!     40.13, Oct. 01: single call to KSCIP1 instead of loop over call
!                     N and ND declared as arrays
!                     loop over IC now inside routine SWAPAR
C
C  2. Purpose
C
C     computes the wave parameters K, CGO, CG in the nearby
C     points, depending of the sweep direction.
C     The nearby points are indicated with the index IC (see
C     FUNCTION ICODE(_,_)
C
C  3. Method
C
C     Compute wave number K, group velocity CGO by linear
C     interpolation from 1-dimensional tables.
C     The wave number K(IS,iC) is computed with the dispersion relation:
C
C     S = GRAV K(IS,IC)tanh(K(IS,IC)DEP(IX,IY))
C
C     where S = is logaritmic distributed via LOGSIG
C
C     The group velocity CGO in the case without current is equal to
C
C                    1       K(IS,IC)DEP(IX,IY)          S
C     CGO(IS,IC) = ( - + --------------------------) -----------
C                    2   2 sinh 2K(IS,IC)DEP(IX,IY)  |k(IS,IC)|
C
C     The group velocity CG in the direction of the wave propagation
C     in case with a current is equal to:
C
C                     1      K(IS,IC)DEP(IX,IY)        S
C     CG(ID,IS,IC)= ( - + -----------------------) --------- +
C                     2  sinh 2K(IS,IC)DEP(IX,IY)  |k(IS,IC)|
C
C                     + (UX2(IX,IY)cos(D) + UY2(IX,IY)sin(D))
C
C     where:
C
C     DIR = ID * DD
C
C     In absense of a current the group velocity CG is equal to
C     the group velocity CGO
C
C     CG(ID,IS,IC) = CGO(IS,IC)
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        INTEGERS:
C        ---------
C
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        ICUR        Indicator for current
C        ICMAX       Maximum array size for the points of the molecul
C        INPS        Dummy variable
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C        NSMIN       Minimum number of values in the arrays KTAB1D and
C                    CGTAB1D
C        NSMAX       Maximum number of values in the arrays KTAB1D and
C                    CGTAB1D
C
C        REALS:
C        ---------
C
C        CGOND       Non dimensional wave number in absence of
C                    currents
C        DINV        Equal to 1/depth
C        DSND        Non dimensional width of frequency band
C        FAC         Dummy variable for the linear interpolation
C        GRAV        Gravitational acceleration
C        KND         Non dimensional wave number
C        ROOTDG      Depth devided by the gravitational accerelation
C        RPDS        Reciproce value of the variable  DSND
C        SFAC        Dummy variable for the linear interpolation
C        SGD         Group velocity at extreemly shallow water ugd
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        CGO       2D    Group velocity as function of X and Y and S in the
C                        direction of wave propagation in absence of currents
C        CG        3D    Group velocity as function of X, Y and S and D in the
C                        direction of wave propagation in presence of currents
C        DEP1      2D    Depth as function of X and Y at time T
C        ECOS      1D    Represent the values of cos(d) of each spectral
C                        direction
C        ESIN      1D    Represent the values of sin(d) of each spectral
C                        direction
C        KWAVE      2D    wavenumber as function of the relative frequency S
C        UX2       2D    X-component of current velocity of X and Y at
C                        time T+1
C        UY2       2D    Y-component of current velocity of X and Y at
C                        time T+1
C        KTAB1D    2D    Table with the values to compute the non
C                        dimensional wavenumber by linear interpolation
C        CGTB1D    2D    Table with the values to compute the non
C                        dimensional group velocity in absence of
C                        currents by linear interpolation
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   If depth is negative ( D(IX,IY) <= 0), then,
C     For every point in S and D-direction do,
C       Give wave parameters default values :
C       CGO(IS,IC)  =  0.    ,  {group velocity in absence of a current}
C       CG(ID,IS,IC)=  0.    ,  {Cgo in dir. of wave prop. with currents}
C         K(IS,IC)    = -1.    ,                             {wave number}
C     ---------------------------------------------------------
C   Else
C         Then for every IS do
C           call kscip1 to compute wave number and group velocity
C         ------------------------------------------------------
C         If current is on (ICUR > 1) then,
C           Compute group velocity in direction of wave propagation
C           with the current component in the direction of the wave
C           propagation
C         else
C           group velocity CG is equal to group velocity
C           without currents CGO
C         end if
C     ----------------------------------------------------------
C   end if
C   ------------------------------------------------------------
C   End of SWAPAR
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
C        IC          Dummy variable: ICode gridpoint:
C                      IC = 1  Top or Bottom gridpoint
C                      IC = 2  Left or Right gridpoint
C                      IC = 3  Central gridpoint
C                    Whether which value IC has, depends of the sweep
C                    If necessary IC can be enlarged by increasing
C                    the array size of ICMAX
      INTEGER      IC    ,IS    ,ID    ,ICUR  ,
     &             ICMAX ,MSC   ,MDC   ,MCGRD
C
      INTEGER      KCGRD(ICMAX)
      REAL         GRAV
      REAL              :: N(1:MSC), ND(1:MSC)                            NRL
C
C
      REAL         DEP2(MCGRD)        ,
     &             KWAVE(MSC,ICMAX)     ,
     &             CGO(MSC,ICMAX)       ,
     &             CG(MDC,MSC,ICMAX)    ,
     &             ECOS(MDC)            ,
     &             ESIN(MDC)            ,
     &             UX2(MCGRD)           ,
     &             UY2(MCGRD)
C
C
      INTEGER, SAVE :: IENT=0
      IF (LTRACE) CALL STRACE (IENT,'SWAPAR')
C
      DO IC = 1, ICMAX                                                    40.13
        INDX  = KCGRD(IC)
        DEPLOC = DEP2(INDX)
        IF ( DEPLOC .LE. DEPMIN) THEN
C         *** depth is negative ***
          KWAVE(:,IC) = -1.                                               40.13
          CGO(:,IC)   = 0.                                                40.13
          CG(:,:,IC) = 0.                                                 40.13
        ELSE
C       *** call kscip1 to compute KWAVE, and CGO ***
          CALL KSCIP1 (MSC, SPCSIG, DEPLOC, KWAVE(:,IC) ,
     &                 CGO(:,IC), N, ND)                                  40.13
          DO 70 ID = 1, MDC
            CG(ID,:,IC) = CGO(:,IC)                                       40.13
 70       CONTINUE
C
C         *** compute the group velocity in presence of current
C
          IF (ICUR .GE. 1) THEN
            DO 180 IS = 1, MSC
              DO 170 ID = 1, MDC
                CG(ID,IS,IC) = CGO(IS,IC) + UX2(KCGRD(IC))*ECOS(ID) +
     &                         UY2(KCGRD(IC))*ESIN(ID)
 170          CONTINUE
 180        CONTINUE
          ENDIF
CPAC
        ENDIF
C
        IF ( TESTFL .AND. IC .EQ. 1 .AND. ITEST.GE. 100 ) THEN
          WRITE(PRINTF,6021) UX2(KCGRD(IC)),UY2(KCGRD(IC)),
     &                       DEP2(KCGRD(IC))
 6021     FORMAT(' SWAPAR :           UX2 UY2 DEP :',3E12.4, /,
     &           '   IS          K           CGO              CG :')      40.00
          DO 105 IS = 1, MSC
            WRITE(PRINTF,6019) IS, KWAVE(IS,IC), CGO(IS,IC),              40.00
     &                         (CG(ID,IS,IC), ID=1, MIN(10,MDC))          40.00
 6019       FORMAT(I4, 2E12.4, 2X, 10E12.4)                               40.00
 105      CONTINUE
        END IF
      ENDDO                                                               40.13
C
C     end of subroutine SWAPAR
      RETURN
      END
C
C*******************************************************************
C
      SUBROUTINE SOLDIF (MSC         ,MDC        ,
     &                   DIFLOW      ,DIFUPP     ,
     &                   DIFDIG      ,DIFRHV     ,
     &                   AC2         ,AC2OLD     ,
     &                   PWTAIL      ,SPCSIG     ,                        30.72
     &                   KCGRD       ,MCGRD      ,
     &                   ICMAX                   )                        30.21
C
C*******************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     SUBROUTINE to solve the matrix which is filled in the
C     subroutine FILTIMP to add some diffusion to the frequency
C     space. The solutions give the values for the
C     wave action for every frequency and every direction.
C     The matrices are solved by using the Thomas sweep algorithm
C     in the frequency direction only
C
C  3. Method
C
C     solver for tridiagonal matrix:
C
C                         /   \
C       / 2  3          \ |   |
C       | 1  2  3       | |   |
C       |    1  2  3    | | b | =  RHV
C       |       1  2  3 | |   |
C       \          1  2 / |   |
C                         \   /
C
C
C     In the last frequency bin the energy density level can increase
C     when some diffusion is added to the spectrum. This implies,
C     however that also the energy in the spectral tail increases.
C     Energy is then not any more conserved.
C     Therefore, we calcultate first the total energy in the spectrum
C     Then we add some diffusion to the model. We then calculate
C     with the new eenrgy is the last frequency bin the totatl energy.
C     is this is larger (due to the increased influence of the tail)
C     then the new energy in the last frequency bin is calculated
C     according to:
C
C          ( Etot - Espec - 0.5 * ds * AC@(MSC-1)
C     N  = --------------------------------------
C             ( 0.5 * ds  +  Ctail )
C
C     in which Ctail is a coefficient that is a measure for the C
C     total energy in the tail (see subroutine CNTAIL).
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        J           Dummy counter
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C
C        SP          Dummy variable
C        TEMP        Dummy variable
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C        DIFDIG    2D    Coefficients of diagonal of matrix
C        DIFLOW    2D    Coefficients of lower diagonal of matrix
C        DIFUPP    2D    Coefficients of upper diagonal of matrix
C        DIFRHV    2D    Coefficients of right hand side of matrix
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   Set all the values in the arrays 0
C   Do for each direction
C     Do for each frequency
C       Solve the matrix and compute the new action density in
C       a spectral bin after adding some diffusion in frequency space
C   ------------------------------------------------------------
C   End of SOLDIF
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS    ,ID    ,MDC   ,MSC   ,J      ,MCGRD ,ICMAX           30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     SP    ,TEMP
C
      REAL     AC2(MDC,MSC,MCGRD)           ,                             30.21
     &         AC2OLD(MDC,MSC)              ,
     &         DIFLOW(MDC,MSC)              ,
     &         DIFDIG(MDC,MSC)              ,
     &         DIFUPP(MDC,MSC)              ,
     &         DIFRHV(MDC,MSC)              ,
     &         PWTAIL(*)
C
      INTEGER, SAVE :: IENT=0
      IF (LTRACE) CALL STRACE (IENT,'SOLDIF')
C     *** set all the coefficients in the arrays 0 ***
C
      DO 1220 ID = 1, MDC
        DO 1210 IS = 1, MSC
          AC2OLD(ID,IS) = 0.
 1210   CONTINUE
 1220 CONTINUE
C
C     *** calculate total action in spectrum per direction ***
C     *** coefficient PWTAIL(3) = 5.                       ***
C
      AUXINV = SPCSIG(MSC) / ( -1. * PWTAIL(3) + 1. )                     30.72
      DO 1650 ID = 1, MDC
        AUXS3   = 0.
        AUXHFR  = -1. * AC2(ID,MSC,KCGRD(1)) * AUXINV
        DO 1640 IS = 2, MSC
          AUXDS  = SPCSIG(IS) - SPCSIG(IS-1)                              30.72
          AUXS1  = 0.5 * ( AC2(ID,IS,KCGRD(1)) + AC2(ID,IS-1,KCGRD(1)) )
          AUXS3  = AUXS3 + AUXDS * AUXS1
 1640   CONTINUE
        AC2OLD(ID,MSC) = AUXS3 + AUXHFR
        AUXHFR         = 0.
 1650 CONTINUE
C
C     *** start proces of elimination ***
C
      DO 180 ID = 1, MDC
C
C       *** elimination of the lower diagonal of the first matrix ***
C
        DO 100 IS = 2 , MSC
          SP = DIFDIG(ID,IS-1)
          IF ( ABS(SP) .LE. 1.E-20 ) THEN
            TEMP = DIFLOW(ID,IS) / SIGN( 1.E-20 , SP)
          ELSE
            TEMP = DIFLOW(ID,IS) / SP
          END IF
          DIFDIG(ID,IS)  = DIFDIG(ID,IS)  - TEMP * DIFUPP(ID,IS-1)
          DIFRHV(ID,IS)  = DIFRHV(ID,IS)  - TEMP * DIFRHV(ID,IS-1)
 100    CONTINUE
C
C       *** solving of the linear equations for the wave action ***
C
        SP = DIFDIG(ID,MSC)
        IF ( ABS(SP) .LE. 1.E-20 ) THEN
          TEMP = SIGN (1.E-20 , SP)
        ELSE
          TEMP = SP
        END IF
C
C       *** wave action for MSC ***
C
        AC2(ID,MSC,KCGRD(1)) = DIFRHV(ID,MSC) / TEMP
C
        DO 150 J = 1, (MSC - 1)
          IS = MSC - J
          SP = DIFDIG(ID,IS)
          IF ( ABS(SP) .LE. 1.E-20 ) THEN
            TEMP = SIGN (1.E-20 , SP)
          ELSE
            TEMP = SP
          END IF
          AC2(ID,IS,KCGRD(1)) = ( DIFRHV(ID,IS) - DIFUPP(ID,IS) *
     &                      AC2(ID,IS+1,KCGRD(1)) ) / TEMP
 150    CONTINUE
C
C       *** extra information about SOLDIF ***
 
        IF ( ITEST .GE. 70 .AND. TESTFL ) THEN
          WRITE(PRINTF,*)' Subroutine SOLDIF : POINT ID ',KCGRD(1),ID
          WRITE(PRINTF,*) ' matrix coefficients after pivoting '
          WRITE(PRINTF,*)
          WRITE(PRINTF,*)
     &  'IS      DIFLOW      DIFDIG      DIFUPP      DIFRHV'
          DO 2100 IS = 1, MSC
            WRITE(PRINTF,2101) IS, DIFLOW(ID,IS),DIFDIG(ID,IS),
     &                             DIFUPP(ID,IS),DIFRHV(ID,IS)
2101        FORMAT(I3,4E12.4)
2100      CONTINUE
          WRITE(PRINTF,*)
          DO 2010 IS = 1, MSC
            WRITE(PRINTF,6010)ID,IS,AC2OLD(ID,IS),AC2(ID,IS,KCGRD(1))
 6010       FORMAT(' ID IS AC2OLD AC2NEW  :',2I5,1X,2E12.4)
 2010     CONTINUE
          WRITE(PRINTF,*)
        END IF
C
 180  CONTINUE
C
C     *** calculate new energy in spectrum per direction ***
C     *** and if necessary, recalculate the AC2(MSC)     ***
C
      DO 1850 ID = 1, MDC
        AUXS3   = 0.
        AUXHFR  = -1. * AUXINV
        DO 1840 IS = 2, (MSC-1)
          AUXDS  = SPCSIG(IS) - SPCSIG(IS-1)                              30.72
          AUXS1  = 0.5 * ( AC2(ID,IS,KCGRD(1)) + AC2(ID,IS-1,KCGRD(1)) )
          AUXS3  = AUXS3 + AUXDS * AUXS1
 1840   CONTINUE
        AUXDS1 = SPCSIG(MSC) - SPCSIG(MSC-1)                              30.72
        AUXAC2 = AC2(ID,MSC-1,KCGRD(1))
        AUXNEW = ( AC2OLD(ID,MSC) - AUXS3 - 0.5 * AUXDS1 * AUXAC2  ) /
     &                        ( 0.5 * AUXDS1 + AUXHFR)
        AC2(ID,MSC,KCGRD(1)) = AUXNEW
        IF ( AC2(ID,MSC,KCGRD(1)) .LT. 0. ) AC2(ID,MSC,KCGRD(1)) = 0.
 1850 CONTINUE
C
C     *** set all the coefficients in the arrays 0 ***
C
      DO 220 ID = 1, MDC
        DO 210 IS = 1, MSC
          AC2OLD(ID,IS) = 0.
          DIFLOW(ID,IS) = 0.
          DIFDIG(ID,IS) = 0.
          DIFUPP(ID,IS) = 0.
          DIFRHV(ID,IS) = 0.
 210    CONTINUE
 220  CONTINUE
C
C     End of the subroutine SOLDIF
C
      RETURN
      END
C*******************************************************************
C
      SUBROUTINE ADDDIS (MSC        ,MDC        ,
     &                   DDIR       ,FRINTF     ,
     &                   DISSXY     ,LEAKXY     ,
     &                   AC2        ,ANYBIN     ,
     &                   DISC0      ,DISC1      ,
     &                   LEAKC1     ,SPCSIG     ,                         30.72
     &                   KCGRD      ,MCGRD      ,
     &                   ICMAX                                            30.21
     &                                         )
C
C*******************************************************************
C
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     20.53, Aug. 95: New subroutine
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     Adds dissipation and leak
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     IX          Counter of gridpoints in x-direction
C     IY          Counter of gridpoints in y-direction
C     MXC         Maximum counter of gridppoints in x-direction
C     MYC         Maximum counter of gridppoints in y-direction
C     MSC         Maximum counter of relative frequency
C     MDC         Maximum counter of directional distribution
C
C     REALS:
C     ---------
C
C     SP          Dummy variable
C     TEMP        Dummy variable
C
C     one and more dimensional arrays:
C     ---------------------------------
C     AC2       4D    Action density as function of D,S,X,Y and T
C
C  9. Subroutines calling
C
C     SWOMPU
C
C  8. Subroutines used
C
C     ---
C
C  7. Error messages
C
C     ---
C
C  8. Remarks
C
C     DISSXY and LEAKXY are dissipation and leak integrated over the
C     spectrum for each point in the computational grid
C     DISSC0 and DISSC1 give the dissipation distributed over the
C     spectral space in one point of the computational grid
C
C  9. Structure
C
C     -------------------------------------------------------------
C     -------------------------------------------------------------
C
C 13. Source text
C
      INTEGER  MSC     ,MDC     ,MCGRD   ,ICMAX                           30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     DISSXY(MCGRD)    ,LEAKXY(MCGRD)      ,DDIR            ,    30.21
     &         FRINTF           ,DISC0(MDC,MSC)     ,DISC1(MDC,MSC)  ,
     &         LEAKC1(MDC,MSC)  ,AC2(MDC,MSC,MCGRD)                       30.21
C
      LOGICAL  ANYBIN(MDC,MSC)
      INTEGER, SAVE :: IENT=0
      CALL STRACE (IENT, 'ADDDIS')
*
      DO 100 ISC = 1, MSC
        DSDD = DDIR * FRINTF * SPCSIG(ISC)**2
        DO 90 IDC = 1, MDC
          IF (ANYBIN(IDC,ISC)) THEN
            DISSXY(KCGRD(1)) = DISSXY(KCGRD(1)) + DSDD*(DISC0(IDC,ISC) +
     &                      DISC1(IDC,ISC) * AC2(IDC,ISC,KCGRD(1)))
            LEAKXY(KCGRD(1)) = LEAKXY(KCGRD(1)) + DSDD *
     &                      LEAKC1(IDC,ISC) * AC2(IDC,ISC,KCGRD(1))
          ENDIF
  90    CONTINUE
 100  CONTINUE
      RETURN
      END
C
