!NRL: $Id: swanout1.F,v 1.2 2003/03/28 15:36:46 dykes Stab $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000    1:28 pm
*
*     SWAN/OUTPUT       file 1 of 3
*
*  Contents of this file:
*     SWOUTP
*     SWORDC
*     SWODDC
*     SWOEXC
*     SWOEXD
*     SWIPOL
*     SWOEXA
*     SWOINA
*     SWOEXF
*
*     main output routine and computation of output quantities
*
************************************************************************
*                                                                      *
      SUBROUTINE SWOUTP (OUTDA           ,ROUTDA  ,                       30.90
     &                   LOUTDA          ,AC2     ,                       30.90
     &                   SPCSIG          ,SPCDIR  ,                       30.72
     &                   COMPDA          ,XYTST   ,
     &                   KGRPNT          ,XCGRID  ,                       30.72
     &                   YCGRID          ,KGRBND  )                       40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.81: Annette  Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     34.01: Jeroen Adema
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     10.10, Aug. 94: computation of force is added (subr. SWOEXF)
C                     arrays NE and NED added
C     30.72, Oct. 97: changed floating point comparison to avoid equality
C                     comparisons
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, June 98: argument KGRBND added, call SWPLOT and SWOEXC
C                     modified
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     40.00, Jan. 99: argument RTYPE added in call SWODDC
C     34.01, Feb. 99: Introducing STPNOW
C     40.02, Oct. 00: Made TYPE of several equivalenced arrays correct
C     40.02, Oct. 00: Modified argument list of SWPLOT to avoid int/real conflict
C
C  2. Purpose
C
C     Processing of the output requests
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C i   ROUTDA: Real EQUIVALENCE of OUTDA                                   30.90
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    ROUTDA(*)                                                   30.90
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C i   LOUTDA: Logical EQUIVALENCE of OUTDA                                30.90
C
      LOGICAL LOUTDA(*)                                                   30.90
C
C     OUTDA   int arr  input  array containing output data, requests etc.
C     AC2     real arr input  action density in all computational points
C     SPCDIR  real arr input  spectral directions, cosines and sines
C     UX2     real arr input  current velocity x-comp.
C     UY2     real arr input  current velocity y-comp.
C     UBOT    real arr input  orbital velocities at bottom
C     WX2     real arr input  wind velocity x-comp.
C     WY2     real arr input  wind velocity y-comp.
C
C  8. Subroutines used
C
C     SWBLOK
C     SWTABP
C     SWPLOT
C     SWSPEC
C     FOR
C     COPYCH (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     MAIN program
C
C 10. Error messages
C
C     If an output request is of an unknown type, an error message
C     is printed.
C
C 11. Remarks
C
C     Data:
C
C     output requests are encoded in array OUTREQ; these are set by
C     commands PLOT, TABLE, BLOCK etc. (see subr SWREOQ in file SWANPRE2)
C     each output request refers to one set of output locations,
C     and to one or more output quantities.
C     1st value in OUTREQ: time of next output, 2nd value: interval between
C     outputs, 3d value: type of output request RTYPE (encoded as integer),
C     4&5: PSNAME (name of point set),
C     6: file unit number, 7..10: output filename,
C     other: dependent on type of output.
C
C     data on output locations are in array OUTDA; these are set by
C     commands FRAME, POINTS, CURVE etc. (see subr SWREPS in file SWANPRE2)
C     each set is characterized by its name (SNAME in the code)
C     STYPE is the type of set (i.e. 'F' for Frame etc.)
C
C     properties of output quantities are in arrays OVSNAM, OVLNAM,
C     OVUNIT, OVSVTY etc.; these are set in subr SWINIT (file SWANMAIN)
C     each output quantity is assigned a fixed number; i.e. 1=Xp, 2=Yp,
C     7=Dissip, 10=Hs, 11=Tm01 etc.
C     subr SVARTP determines the above number from the name of the
C     quantity as it appears in the user command; this is compared with
C     OVKEYW.
C
C     Procedure:
C
C     After the coordinates of all output locations have been determined,
C     values of all output quantities are calculated, and written into
C     2d array VOQ (one or two columns for each output quantity, one line
C     for each location). array VOQR shows with quantity is written in
C     each column.
C     After array VOQ is filled, the actual output starts; which subroutine
C     is called depends on RTYPE (see structure scheme below).
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     For all output requests do
C         Call SWORDC (analyzes output req.; gives name of output
C                      point set, type of output RTYPE
C                      and number of quantities per point)
C         Call SWODDC (analyzes output data; gives number of output
C                      points)
C         ------------------------------------------------------------
C         Call DPEXPR to enlarge pool arrays to required length           40.00
C         ------------------------------------------------------------
C         Call SWOEXC (compute coordinates of output points)
C         Call SWOEXD (compute depth, current vel. dissipation etc.)
C         Call SWOEXA (compute action density and related quant.)
C         Call SWOEXF (compute wave-driven force)
C         ------------------------------------------------------------
C         If RTYPE = 'BLKP', 'BLKD' or 'BLKL' then
C                     call SWBLOK for block output
C         If RTYPE = 'TABP' or 'TABD' then call SWTABP for output in
C                     table
C         If RTYPE = 'PLOT' then call SWPLOT for plot output
C         If RTYPE = 'SPEC' then call SWSPEC for spectral output
C     ----------------------------------------------------------------
C     If program is run in stationary mode                                40.00
C     Then Close all opened files                                         40.00
C     ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER   OUTDA(*)       ,VOQR(NMOVAR)   ,BKC           ,
     &          XYTST(*)       ,KGRPNT(MXC,MYC),IERR          ,           30.81 30.21
     &          KGRBND(*)                                                 40.00
C
      REAL      AC2(MDC,MSC,MCGRD) ,
     &          COMPDA(MCGRD,MCMVAR)
C
      LOGICAL   OQPROC(NMOVAR)  , LOGACT                                  30.00
      CHARACTER RTYPE *4, STYPE *1, PNAME *8, PTYPE *1
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWOUTP')
*
*     processing of output requests
*
      IF (ITEST.GE.100 ) WRITE (PRINTF, 7)
     &     (OUTDA(II), II=1, 200)
   7  FORMAT (' Entry SWOUTP:', /, (1X,20I6))
*
      IF (NPTST.GT.0) CALL AC2TST (XYTST, AC2 ,KGRPNT)                    30.21
*
*     find necessary arrays from the dynamic data pool
*
      IERR = -1                                                           30.81 40.00
      IF (ITEST.GE.100) IERR = -3                                         30.81 40.00
      CALL DPCHEK (OUTDA, IERR)                                           30.81
C     array containing (encoded) output requests
      PNAME = 'REQ'
      CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IOUTOQ,
     &             LENREC, IERR)                                          30.81
      CALL DPCHEK (OUTDA(IOUTOQ), IERR)                                   30.81
      CALL DPINQA (OUTDA(IOUTOQ), LENARR, LENOCP, MOUTR, LENPNM,
     &             LENADT, IERR)                                          30.81
C     array containing parameters of output point sets (frames etc.)
      PNAME = 'PSET'
      CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IOUTPS,
     &             LENREC, IERR)                                          30.81
      CALL DPCHEK (OUTDA(IOUTPS), IERR)                                   30.81
C
      IF (MOUTR.EQ.0) THEN
        CALL MSGERR (2, 'no output requested')
        RETURN
      ENDIF
      IF (ITEST.GE.10) WRITE (PRINTF, 12) MOUTR
  12  FORMAT (1X, I3, ' output requests')
*
*     Repeat for all output requests:
*
      DO 70 IRQ = 1, MOUTR
*
*       ***** processing of output instructions *****
*
        IF (SCREEN.NE.PRINTF) WRITE (SCREEN, 15) IRQ
  15    FORMAT ('+SWAN is processing output request ', I2)                30.00
        IF (ITEST.GE.10) WRITE(PRINTF,16) IRQ
  16    FORMAT (' SWAN is processing output request ', I2)
        IERR = 0
        PNAME = '    '
        CALL DPINQP (OUTDA(IOUTOQ), PNAME, IRQ, PTYPE, IPLRQ,
     &               LENREC, IERR)                                        30.81
*
        BKC   = 0
        NVOQP = 0
C
C       call SWORDC to analyse output request encoded in array OUTREQ
C       result: RTYPE (type of request), SNAME (name of output point set),
C       NVOQP (number of output quantities)
C
        CALL SWORDC (OUTDA(IOUTOQ+IPLRQ),ROUTDA(IOUTOQ+IPLRQ), RTYPE,     30.90
     &               SNAME, NVOQP, OQPROC, BKC, VOQR,
     &               LOGACT)                                              30.00
        IF (.NOT.LOGACT) GOTO 70                                          30.00
*
        IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
          IERR = 0                                                        30.81
          CALL DPCHEK (OUTDA, IERR)                                       30.81
        ENDIF
*
*       get MIP (number of output points)
*
        IDXPS = 0
        IERR = 0                                                          30.81
        CALL DPINQP (OUTDA(IOUTPS), SNAME, IDXPS, PTYPE, IPLPS,
     &               LENREC, IERR)                                        30.81
        IF (IDXPS.EQ.0) THEN                                              30.00
          CALL MSGERR (3, 'Output requested for non-existing points')     10.21
          WRITE (PRINTF, 18) SNAME, IERR, IDXPS                           30.81 30.00
  18      FORMAT (' Point set: ', A, ', error status:', 2I4)              30.00
          GOTO 68                                                         40.00
        ENDIF
*
        IF (ITEST.GE.80 .OR. IOUTES .GE. 10)
     &  WRITE (PRTEST, 22) IRQ, NVOQP, RTYPE, SNAME,
     &  MIP, IDXPS, IPLPS, IVOQ
  22    FORMAT (' Test SWOUTP ', 2I6, 2X, A4, 2X, A16, 4I6)
C
C       call SWODDC to analyse output data; results: STYPE (type of output
C       point set), MIP (number of output locations) etc.
C
        CALL SWODDC (OUTDA(IOUTPS+IPLPS), SNAME, STYPE, MIP, MXK,
     &               MYK, XNLEN, YNLEN, MXN, MYN, XPCN, YPCN, ALPCN,
     &               XCGRID,YCGRID,RTYPE)                                 40.00
*
*       assign memory to array VOQ (contains output quantities for all
*                                   output points)
        IERR = 0
        PNAME = 'VOQ'
        CALL DPINQP (OUTDA, PNAME, JVOQ, PTYPE, IVOQ,
     &               LENREC, IERR)
        IF (JVOQ.LE.0) WRITE (PRINTF, *) ' err exp VOQ '                  40.00
*
        CALL DPEXPR (OUTDA, JVOQ, MIP*NVOQP, IVOQ, IERR)
        IF (STPNOW()) RETURN                                              34.01
*
C       call SWOEXC to calculate quantities dependent only on coordinates
C
        CALL SWOEXC (OUTDA(IOUTPS+IPLPS) ,STYPE               ,
     &               MIP                 ,ROUTDA(IVOQ+1)      ,           30.90
     &               ROUTDA(IVOQ+1+MIP)  ,ROUTDA(IVOQ+1+2*MIP),           30.90
     &               ROUTDA(IVOQ+1+3*MIP),KGRPNT              ,           30.90
     &               XCGRID              ,YCGRID              ,           30.21
     &               KGRBND                                   )           40.00
        IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
          IERR = 0                                                        30.81
          CALL DPCHEK (OUTDA, IERR)                                       30.81
        ENDIF
C
C       call SWOEXD to interpolate quantities which are computed during the
C       Swan computation, such as Qb, Dissipation, Ursell etc.
C
        CALL SWOEXD (OQPROC, MIP, ROUTDA(IVOQ+1+2*MIP),                   30.90
     &               ROUTDA(IVOQ+1+3*MIP), VOQR, ROUTDA(IVOQ+1),          30.90
     &               COMPDA, KGRPNT)
        IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
          IERR = 0                                                        30.81
          CALL DPCHEK (OUTDA, IERR)                                       30.81
        ENDIF
        IF (BKC .GT. 0) THEN
*
*         assign memory to array ACLOC (contains spectrum for one output point)
*
          IERR = 0                                                        30.81
          PNAME = 'ACLOC'
          CALL DPINQP (OUTDA, PNAME, JACLOC, PTYPE, IACLOC,
     &                 LENREC, IERR)                                      30.81
          IF (JACLOC.LE.0) WRITE (PRINTF, *) ' err exp ACLOC'             40.00
          CALL DPEXPR (OUTDA, JACLOC, MSC*MDC, IACLOC, IERR)              30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0                                                        30.81
          PNAME = 'KNUM'
          CALL DPINQP (OUTDA, PNAME, JKNUM, PTYPE, IKNUM, LENREC,
     &                 IERR)                                              30.81
          IF (JKNUM.LE.0) WRITE (PRINTF, *) ' err exp KNUM'               40.00
          CALL DPEXPR (OUTDA, JKNUM, MSC, IKNUM, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0                                                        30.81
          PNAME = 'CG'
          CALL DPINQP (OUTDA, PNAME, JCG, PTYPE, ICG, LENREC,
     &                 IERR)                                              30.81
          IF (JCG.LE.0) WRITE (PRINTF, *) ' err exp CG'                   40.00
          CALL DPEXPR (OUTDA, JCG, MSC, ICG, IERR)                        30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0                                                        30.81
          PNAME = 'NE'                                                    10.10
          CALL DPINQP (OUTDA, PNAME, JNE, PTYPE, INE, LENREC,
     &                 IERR)                                              30.81
          IF (JNE.LE.0) WRITE (PRINTF, *) ' err exp NE'                   40.00
          CALL DPEXPR (OUTDA, JNE, MSC, INE, IERR)                        30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0                                                        30.81
          PNAME = 'NED'                                                   10.10
          CALL DPINQP (OUTDA, PNAME, JNED, PTYPE, INED, LENREC,
     &                 IERR)                                              30.81
          IF (JNED.LE.0) WRITE (PRINTF, *) ' err exp NED'                 40.00
          CALL DPEXPR (OUTDA, JNED, MSC, INED, IERR)                      30.81
          IF (STPNOW()) RETURN                                            34.01
*
*         call SWOEXA to compute quantities for which spectrum is needed
*         (except Force, see further down)
*
          CALL SWOEXA (OQPROC              ,BKC                 ,
     &                 MIP                 ,ROUTDA(IVOQ+1+2*MIP),         30.90
     &                 ROUTDA(IVOQ+1+3*MIP),VOQR                ,         30.90
     &                 ROUTDA(IVOQ+1)      ,AC2                 ,         30.90
     &                 ROUTDA(IACLOC+1)    ,SPCSIG              ,         30.90
     &                 ROUTDA(IKNUM+1)     ,ROUTDA(ICG+1)       ,         30.90
     &                 SPCDIR              ,ROUTDA(INE+1)       ,         30.90
     &                 ROUTDA(INED+1)      ,KGRPNT              ,         30.90
     &                 COMPDA(1,JDP2)                           )
 
C
          IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
            IERR = 0                                                      30.81
            CALL DPCHEK (OUTDA, IERR)                                     30.81
          ENDIF
*
*         call SWOEXF to compute wave-driven force
*
          IF (OQPROC(20))                                                 40.13
     &      CALL SWOEXF (MIP                 ,ROUTDA(IVOQ+1+2*MIP) ,      30.90
     &                   ROUTDA(IVOQ+1+3*MIP),VOQR                 ,      30.90
     &                   ROUTDA(IVOQ+1)      ,AC2                  ,      30.90
     &                   COMPDA(1,JDP2)      ,SPCSIG               ,      30.72
     &                   ROUTDA(IKNUM+1)     ,ROUTDA(ICG+1)        ,      30.90
     &                   SPCDIR              ,ROUTDA(INE+1)        ,      30.90
     &                   ROUTDA(INED+1)      ,KGRPNT               ,      30.90
     &                   XCGRID              ,YCGRID                      30.72
     &                                                             )
C
          IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
            IERR = 0                                                       30.81
            CALL DPCHEK (OUTDA, IERR)                                      30.81
          ENDIF
        ENDIF
*
        IF (ITEST.GE.100 ) THEN
          WRITE (PRTEST, 23) (VOQR(II), II=1, NMOVAR)
  23      FORMAT (' arrays VOQR and VOQ:', 30I3)
          DO 25 IP=1, MIN(MIP,20)
            WRITE (PRTEST, 24) (OCREAL(OUTDA(IVOQ+IP+(JJ-1)*MIP)),
     &                          JJ=1, NVOQP)
  24        FORMAT (12(1X,E10.4))
  25      CONTINUE
        ENDIF
*
*       ***** block output *****
        IF (RTYPE(1:3) .EQ. 'BLK') THEN
          CALL SWBLOK (RTYPE, OUTDA(IOUTOQ+IPLRQ), SNAME, MXK, MYK,
     &                 VOQR, ROUTDA(IVOQ+1)                               40.02
     &                                                            )
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
*
*       ***** table output *****
        IF (RTYPE(1:3) .EQ. 'TAB') THEN
          CALL SWTABP (RTYPE, OUTDA(IOUTOQ+IPLRQ), SNAME, MIP,
     &                 VOQR, ROUTDA(IVOQ+1)                               40.02
     &                                                        )
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
*
*       ***** plot output *****
        IF (RTYPE.EQ.'PLOT' .OR. RTYPE.EQ.'PLOS') THEN
          PNAME = 'PLA'
          CALL DPINQP (OUTDA, PNAME, JPLAC, PTYPE, IPLAC, LENREC,
     &                 IERR)                                              30.81
          PNAME = 'LIN'
          CALL DPINQP (OUTDA, PNAME, JLINS, PTYPE, ILINS, LENREC,
     &                 IERR)                                              30.81
          PNAME = 'PSET'
          CALL DPINQP (OUTDA, PNAME, JPSET, PTYPE, IPSET, LENREC,
     &                 IERR)                                              30.81
          CALL SWPLOT (OUTDA(IOUTOQ+IPLRQ), MXK, MYK, SNAME,
     &                 VOQR, ROUTDA(IVOQ+1), ROUTDA(IOUTOQ+IPLRQ),        40.02
     &                 OUTDA(IPLAC), ROUTDA(IPLAC),                       40.02
     &                 OUTDA(ILINS), ROUTDA(ILINS),                       40.02
     &                 OUTDA(IPSET), ROUTDA(IPSET),                       40.02
     &                 XCGRID ,YCGRID ,KGRPNT, KGRBND, OUTDA(IVOQ+1))     40.02
          IF (STPNOW()) RETURN                                            34.01
          IF (RTYPE.EQ.'PLOS') THEN
            IERR = 0                                                      30.81
            CALL DPINQP (OUTDA, 'ACLOC', JACLOC, PTYPE, IACLOC, LENREC,
     &                 IERR)                                              30.81
            IERR = 0                                                      30.81
            CALL DPINQP (OUTDA, 'KNUM', JKNUM, PTYPE, IKNUM, LENREC,
     &                 IERR)                                              30.81
            IERR = 0                                                      30.81
            CALL DPINQP (OUTDA, 'CG', JCG, PTYPE, ICG, LENREC,
     &                 IERR)                                              30.81
            IERR = 0                                                      30.81
            CALL DPINQP (OUTDA, 'NE', JNE, PTYPE, INE,  LENREC,
     &                 IERR)                                              30.81
            IERR = 0                                                      30.81
            CALL DPINQP (OUTDA, 'NED', JNED, PTYPE, INED,LENREC,
     &                 IERR)                                              30.81
            CALL SWSTAR (OUTDA(IOUTOQ+IPLRQ), MXK, MYK,
     &           VOQR, ROUTDA(IVOQ+1), ROUTDA(IOUTOQ+IPLRQ),              40.02
     &           KGRPNT, SPCSIG, SPCDIR,                                  30.72
     &           AC2,
     &           ROUTDA(IADRS(OUTDA,JACLOC)),                             40.02
     &           ROUTDA(IADRS(OUTDA,JKNUM)),                              40.02
     &           ROUTDA(IADRS(OUTDA,JCG)),                                40.02
     &           ROUTDA(IADRS(OUTDA,JNE)),                                40.02
     &           ROUTDA(IADRS(OUTDA,JNED))                  )             40.02
          ENDIF
*
*         ***** termination of plot *****
          CALL OPENDF
*
          GOTO 68                                                         40.00
        ENDIF
*
*----------------------------------------------------------------
*       ***** plot output for computational grid ver. 30.21*****
        IF (RTYPE .EQ. 'PCGR') THEN
          PNAME = 'PLA'
          CALL DPINQP (OUTDA, PNAME, JPLAC, PTYPE, IPLAC, LENREC,
     &                 IERR)                                              30.81
          PNAME = 'CGRD'
          CALL DPINQP (OUTDA, PNAME, JLINS, PTYPE, ILINS, LENREC,
     &                 IERR)                                              30.81
          PNAME = 'PSET'
          CALL DPINQP (OUTDA, PNAME, JPSET, PTYPE, IPSET, LENREC,
     &                 IERR)                                              30.81
 
          CALL SWPLOT (OUTDA(IOUTOQ+IPLRQ), MXK, MYK, SNAME,
     &                 VOQR, ROUTDA(IVOQ+1), ROUTDA(IOUTOQ+IPLRQ),        40.02
     &                 OUTDA(IPLAC), ROUTDA(IPLAC),                       40.02
     &                 OUTDA(ILINS), ROUTDA(ILINS),                       40.02
     &                 OUTDA(IPSET), ROUTDA(IPSET),                       40.02
     &                 XCGRID ,YCGRID ,KGRPNT, KGRBND, OUTDA(IVOQ+1))     40.02
          IF (STPNOW()) RETURN                                            34.01
          PNAME = 'LIN'
          CALL DPINQP (OUTDA, PNAME, JLINS, PTYPE, ILINS, LENREC,
     &                 IERR)                                              30.81
C
          CALL SWPLOT (OUTDA(IOUTOQ+IPLRQ), MXK, MYK, SNAME,
     &                 VOQR, ROUTDA(IVOQ+1), ROUTDA(IOUTOQ+IPLRQ),        40.02
     &                 OUTDA(IPLAC), ROUTDA(IPLAC),                       40.02
     &                 OUTDA(ILINS), ROUTDA(ILINS),                       40.02
     &                 OUTDA(IPSET), ROUTDA(IPSET),                       40.02
     &                 XCGRID ,YCGRID ,KGRPNT, KGRBND, OUTDA(IVOQ+1))     40.02
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
C----------------------------------------------------------------
C
C       ***** plot problem points *****
        IF (RTYPE .EQ. 'PLPR') THEN
          CALL SPLOER (OUTDA(IOUTOQ+IPLRQ), XCGRID, YCGRID)               30.72
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
C
C       ***** plot spectral distribution ****
        IF (RTYPE(1:3) .EQ. 'PLS') THEN                                   20.41
          IERR = 0
          PNAME = 'AUX1'
          CALL DPINQP (OUTDA, PNAME, JAUX1, PTYPE, IAUX1,
     &                 LENREC, IERR)
          IF (JAUX1.LE.0) WRITE (PRINTF, *) ' err exp AUX1'               40.00
          CALL DPEXPR (OUTDA, JAUX1, MSC*(MDC+1), IAUX1, IERR)
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0
          PNAME = 'AUX2'
          CALL DPINQP (OUTDA, PNAME, JAUX2, PTYPE, IAUX2,
     &                 LENREC, IERR)
          IF (JAUX2.LE.0) WRITE (PRINTF, *) ' err exp AUX2'               40.00
          CALL DPEXPR (OUTDA, JAUX2, MSC*(MDC+1), IAUX2, IERR)
          IF (STPNOW()) RETURN                                            34.01
          PNAME = 'REQ'
          CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IOUTOQ, LENREC,
     &                 IERR)                                              30.81
          PNAME = '    '
          CALL DPINQP (OUTDA(IOUTOQ), PNAME, IRQ, PTYPE, IPLRQ, LENREC,
     &                 IERR)                                              30.81
          PNAME = 'VOQ'
          CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IVOQ, LENREC, IERR)     30.81
C
          CALL SWPLSP (RTYPE        ,OUTDA(IOUTOQ+IPLRQ)             ,
     &          ROUTDA(IOUTOQ+IPLRQ),MIP             ,AC2            ,    30.90
     &          ROUTDA(IAUX1+1)     ,ROUTDA(IAUX2+1) ,LOUTDA(IAUX2+1),    30.90
     &          ROUTDA(IVOQ+1)      ,VOQR            ,SPCSIG         ,    30.90
     &          SPCDIR              ,KGRPNT          ,COMPDA(1,JDP2) )    40.00
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
*
*       ***** spectral output *****
        IF (RTYPE(1:2) .EQ. 'SP') THEN                                    20.28
          IERR = 0
          PNAME = 'AUX1'
          CALL DPINQP (OUTDA, PNAME, JAUX1, PTYPE, IAUX1,
     &                 LENREC, IERR)
          IF (RTYPE(4:4).EQ.'C') THEN
            CALL DPEXPR (OUTDA, JAUX1, MSC*MDC, IAUX1, IERR)
            IF (STPNOW()) RETURN                                          34.01
          ELSE
            CALL DPEXPR (OUTDA, JAUX1, 3*MSC, IAUX1, IERR)                40.00
            IF (STPNOW()) RETURN                                          34.01
          ENDIF
          CALL SWSPEC (RTYPE, OUTDA(IOUTOQ+IPLRQ), MIP, VOQR,             20.28
     &                 ROUTDA(IVOQ+1), AC2, ROUTDA(IAUX1+1), SPCSIG,      40.02
     &                 SPCDIR, COMPDA(1,JDP2), KGRPNT)                    40.00
          IF (STPNOW()) RETURN                                            34.01
          IF (ITEST.GE.10 .OR. IOUTES .GE. 10) THEN
            IERR = -1                                                     30.81
            CALL DPCHEK (OUTDA, IERR)                                     30.81
          ENDIF
          CALL DPEXPR (OUTDA, JAUX1, 0, IAUX1, IERR)
          IF (STPNOW()) RETURN                                            34.01
          GOTO 68                                                         40.00
        ENDIF
*
  60    WRITE (PRINTF, 62) IRQ, NVOQP, RTYPE, SNAME, MIP, IDXPS
  62    FORMAT (' Error in output request ', 2I6, 2X, A4, 2X, A16, 2I6)
*
  68    CALL DPEXPR (OUTDA, JVOQ, 0, IVOQ, IERR)                          40.00
        IF (STPNOW()) RETURN                                              34.01
        PNAME = 'ACLOC'
        CALL DPINQP (OUTDA, PNAME, JACLOC, PTYPE, IACLOC, LENREC,
     &                IERR)                                               30.81
        CALL DPEXPR (OUTDA, JACLOC, 0, IACLOC, IERR)                      40.00
        IF (STPNOW()) RETURN                                              34.01
        PNAME = 'AUX1'
        CALL DPINQP (OUTDA, PNAME, JAUX1, PTYPE, IAUX1,
     &               LENREC, IERR)
        CALL DPEXPR (OUTDA, JAUX1, 0, IAUX1, IERR)                        40.00
        IF (STPNOW()) RETURN                                              34.01
        PNAME = 'AUX2'
        CALL DPINQP (OUTDA, PNAME, JAUX2, PTYPE, IAUX2,
     &               LENREC, IERR)
        CALL DPEXPR (OUTDA, JAUX2, 0, IAUX2, IERR)                        40.00
        IF (STPNOW()) RETURN                                              34.01
  70  CONTINUE
*
*       Termination
*
*     ***** close all opened files *****
      IF (NSTATM.EQ.0) THEN                                               40.00
  80    DO 100 IREF = FUNLO, HIOPEN
          CLOSE (IREF)
  100   CONTINUE
      ENDIF
  200 RETURN
* * end of subroutine SWOUTP *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWORDC (OUTI, OUTR, RTYPE, PSNAME, NVOQP, OQPROC, BKC,
     &                   VOQR, LOGACT)                                    30.00
*                                                                      *
************************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.61: Roberto Padilla
C     30.74: IJsbrand Haagsma (Include version)
C     30.81: Annette Kieftenburg
C
C  1. Update
C
C     10.33, Jan. 95: computation of wind added in polar plot
C     30.61, Summ 97: give values for array VOQR when OQPROC = .TRUE.
C                     in case of 'nest'
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM
C                     is a reserved word)
C
C  2. Purpose
C
C     Decodes output requests
C
C  3. Method
C
C     ---
C
C  4. Argument list
C
C     OUTR    Real   input    Code for one output request
C     RTYPE   Char   outp     type of output
C     PSNAME  Char   outp     name of output point set referred to
C     NVOQP   Int    outp     number of data per output point
C     OQPROC  logic  outp     whether or not an output quantity  must
C                             be processed
C     VOQR    Int ar outp     place of each output quantity
C                             (subscript: IVTYP)
C
C  8. Subroutines used
C
C     SPSET
C     SUVIPL
C     SBLKPT
C     SCUNIT
C     SFLFUN (all SWAN/OUTP)
C     TABHED
C     MSGERR
C     COPYCH
C     FOR
C     ADPOOL (all Ocean Pack)
C
C  9. Subroutines calling
C
C     SWOUTP (SWAN/OUTP)
C
C 10. Error messages
C
C     If the point set is not of the type frame, an error message
C     is printed and control returns to subroutine OUTPUT
C
C 11. Remarks
C
C     output interval negative means that output is made only at end
C     of computation                                                      40.00
C
C 12. Structure
C
C     -----------------------------------------------------------------   40.00
C     If dynamic mode
C     Then determine TNEXT (time of next requested output)
C          determine DIF (interval between end time and present time)
C          If DIF is less than half time step and output interval is
C               negative
C          Then enable output (by making LOGACT = true)
C          Else If time of computation >= TNEXT and output interval is
C               positive
C          Then enable output
C          Else disable output (by making LOGACT = false)
C               Return
C          ------------------------------------------------------------   40.00
C     Else enable output
C     -----------------------------------------------------------------   40.00
C     Set all OQPROC = false (if OQPROC is true corresponding quantity
C                             must be computed)
C     Make OQPROC true for quantities Xp, Yp, Xc and Yc
C     Set all values of VOQR = 0 (VOQR indicates where value of a
C                                 quantity is stored in array VOQ)
C     Make VOQR nonzero for quantities Xp, Yp, Xc and Yc
C     Assign value to NVAR depending on type of output request
C     If polar plot of spectrum is requested
C     Then enable output of Hs etc.
C     -----------------------------------------------------------------   40.00
C
C 13. Source text
C
      INTEGER    VOQR(*), OUTI(*), BKC                                    30.00
      REAL       OUTR(*)                                                  30.00
      LOGICAL    OQPROC(NMOVAR), LOGACT                                   30.00
      CHARACTER  PSNAME *(*), RTYPE *(*), FROM_                           30.81
      SAVE IENT
      DATA IENT /0/, FROM_ /'F'/                                          30.81
      CALL STRACE (IENT, 'SWORDC')
*
*     check time of output action:                                        30.00
      IF (NSTATM.EQ.1) THEN                                                    40.00
*       check time of output action:                                      40.00
*       DIF  in case that timco is not a fraction of the
*       computational period and the user do not ask for a periodic plots
        DIF = TFINC - TIMCO
        TNEXT = OUTR(1)
        IF (ITEST.GE.60) WRITE (PRTEST, *) ' output times ', TNEXT,
     &        OUTR(2), DT, TFINC, TIMCO
        IF (ABS(DIF).LT.0.5*DT .AND. OUTR(2).LT.0.) THEN                  40.00
          OUTR(1) = TIMCO
          LOGACT = .TRUE.
        ELSE IF (OUTR(2).GT.0. .AND. TIMCO.GE.TNEXT) THEN                 40.00
          OUTR(1) = TIMCO + OUTR(2)                                       40.00
          LOGACT = .TRUE.
        ELSE
          LOGACT = .FALSE.
          RETURN
        ENDIF
      ELSE
        LOGACT = .TRUE.                                                   30.00
      ENDIF                                                               30.00
*
*     action is taken, proceed with analysing output request
*
      IERR = -1
      CALL COPYCH (RTYPE, FROM_, OUTI(3), 1, IERR)                        30.81 30.00
      CALL COPYCH (PSNAME, FROM_, OUTI(4), 2, IERR)                       30.81 30.00
*
*     Ivtype 1 and 2 are Xp and Yp
*
      OQPROC(1) = .TRUE.
      VOQR(1)   = 1
      OQPROC(2) = .TRUE.
      VOQR(2)   = 2
*
*     clear VOQR and OQPROC from old information
*
      DO 10 IVT = 3, NMOVAR
        VOQR(IVT)   = 0
        OQPROC(IVT) = .FALSE.
  10  CONTINUE
*
*     Ivtype 24 and 25 are Xc and Yc
*
      OQPROC(24) = .TRUE.
      VOQR(24)   = 3
      OQPROC(25) = .TRUE.
      VOQR(25)   = 4
      NVOQP = 4
*
      NVAR = 0
      IF (ITEST.GE.100 ) WRITE (PRTEST, 12)
     &(OUTI(JJ), JJ=1,40)                                                 30.00
  12  FORMAT (' test SWORDC, array OUTI:',/, (20(1X,I5)))
      IF (RTYPE(1:3) .EQ. 'BLK') THEN
        NVAR  = OUTI(18)                                                  30.00
      ELSE IF (RTYPE(1:3) .EQ. 'TAB') THEN
        NVAR  = OUTI(17)                                                  30.00
      ELSE IF (RTYPE(1:3).EQ.'PLO') THEN
        IVTYPE = OUTI(28)                                                 30.00
        IF (IVTYPE.NE.0) NVAR=1
        IVTYPE = OUTI(35)                                                 30.00
        IF (IVTYPE.NE.0) NVAR=NVAR+1
      ELSE IF (RTYPE .EQ. 'NEST') THEN                                    31.02
        NVAR = OUTI(30)                                                   31.02
      ENDIF
*
      DO 20 IVAR = 1, NVAR
         IF (RTYPE(1:3) .EQ. 'BLK') THEN
            IVTYPE = OUTI(2*IVAR+17)                                      30.00
         ELSE IF (RTYPE(1:3) .EQ. 'TAB') THEN
            IVTYPE = OUTI(IVAR+17)                                        30.00
         ELSE IF (RTYPE(1:3) .EQ. 'PLO') THEN
            IVTYPE = OUTI(28)                                             30.00
*           if isoline plot is requested, a row is reserved for
*           auxiliary variable (Ivtype 23)
            IF (IVTYPE.GT.0 .AND. IVAR.EQ.1) THEN
               NVOQP = NVOQP+1
               OQPROC(23) = .TRUE.
               VOQR(23) = NVOQP
            ENDIF
            IF (IVTYPE.EQ.0 .OR. IVAR.EQ.2) IVTYPE = OUTI(35)             30.00
         ELSE IF (RTYPE .EQ. 'NEST') THEN
            IVTYPE = OUTI(31)                                             31.02
         ENDIF
*
         IF (IVTYPE.LT.1 .OR. IVTYPE.GT.NMOVAR) THEN
           CALL MSGERR (2, 'wrong value for IVTYPE')
           WRITE (PRINTF, 17) RTYPE, PSNAME, IVTYPE, NVAR
  17       FORMAT (' type, points, var: ', A4, 2X, A8, 2X, 2I8)
           GOTO 20
         ENDIF
*
         IF (OVSVTY(IVTYPE).LE.2 .AND. .NOT.OQPROC(IVTYPE)) THEN
*           output quantity is a scalar
            NVOQP = NVOQP + 1
            VOQR(IVTYPE) = NVOQP
         ELSE IF (OVSVTY(IVTYPE).EQ.3 .AND. .NOT.OQPROC(IVTYPE)) THEN
*           output quantity is a vector
            NVOQP = NVOQP + 2
            VOQR(IVTYPE) = NVOQP-1
         ENDIF
         OQPROC(IVTYPE) = .TRUE.
         IF (ITEST.GE.80 .OR. IOUTES .GE. 20) WRITE (PRTEST, 22)
     &   IVAR, IVTYPE, VOQR(IVTYPE)                                       10.09
  22     FORMAT (' SWORDC, output quantity:', 3I6)
*
*        for spectral width add Tm02 as output quantity                   20.61
*
         IF (IVTYPE.EQ.33) THEN
           IF (.NOT.OQPROC(32)) THEN
             NVOQP = NVOQP + 1
             VOQR(32) = NVOQP
             OQPROC(32) = .TRUE.
           ENDIF
         ENDIF
*
*        for some quantities compute action densities
*
         IF (IVTYPE.EQ.10 .OR. IVTYPE.EQ.11 .OR. IVTYPE.EQ.12 .OR.
     &       IVTYPE.EQ.13 .OR. IVTYPE.EQ.14 .OR. IVTYPE.EQ.16 .OR.
     &       IVTYPE.EQ.21 .OR. IVTYPE.EQ.22 .OR. IVTYPE.EQ.43   )         40.00
     &   BKC = MAX (1, BKC)
*
*        for some quantities also compute Depth, current, K and Cg
*
         IF (IVTYPE.EQ.15 .OR. IVTYPE.EQ.17 .OR. IVTYPE.EQ.18 .OR.
     &       IVTYPE.EQ.19 .OR. IVTYPE.EQ.20 .OR. IVTYPE.EQ.28 .OR.        10.10
     &       IVTYPE.EQ.32 .OR. IVTYPE.EQ.33 .OR. IVTYPE.EQ.42      )      40.00
     &   BKC = 2
*
         IF (IVTYPE.EQ.11 .AND. ICUR.GT.0) BKC = 2                        20.36
         IF (BKC.GT.0) THEN
*           depth must be computed
            IF (.NOT.OQPROC(4)) THEN
               NVOQP = NVOQP + 1
               VOQR(4) = NVOQP
               OQPROC(4)=.TRUE.
            ENDIF
*           current velocity must be computed
            IF (.NOT.OQPROC(5) .AND. ICUR.GT.0) THEN
               NVOQP = NVOQP + 2
               VOQR(5) = NVOQP-1
               OQPROC(5)=.TRUE.
            ENDIF
         ENDIF
  20  CONTINUE
*
*     in case of polar plot of spectrum Hs etc. will be computed and printed
*
      IF (RTYPE(1:3).EQ.'PLS') THEN                                       20.41
        OQPROC(4)  = .TRUE.
        VOQR(4)    = NVOQP+1
        OQPROC(10) = .TRUE.
        VOQR(10)   = NVOQP+2
        OQPROC(28) = .TRUE.
        VOQR(28)   = NVOQP+3
        OQPROC(12) = .TRUE.
        VOQR(12)   = NVOQP+4
        OQPROC(13) = .TRUE.
        VOQR(13)   = NVOQP+5
        OQPROC(16) = .TRUE.
        VOQR(16)   = NVOQP+6
        OQPROC(26) = .TRUE.                                               10.33
        VOQR(26)   = NVOQP+7                                              10.33
        NVOQP      = NVOQP+8                                              10.33
        BKC        = 1
        IF (ICUR.GT.0) THEN
          BKC = 2
          OQPROC(5) = .TRUE.
          VOQR(5)   = NVOQP+1
          NVOQP     = NVOQP+2
        ENDIF
      ENDIF
*
*     in case of print of spectrum Ux and Uy have to be computed          20.28
*
      IF (     RTYPE(1:2) .EQ. 'SP' .OR. RTYPE.EQ.'PLOS'
     &    .OR. RTYPE(1:2) .EQ. 'NE') THEN                                 30.61
        OQPROC(4)  = .TRUE.
        VOQR(4)    = NVOQP+1
        NVOQP      = NVOQP+1
        BKC        = 1
        IF (ICUR.GT.0) THEN
          BKC = 2
          OQPROC(5) = .TRUE.
          VOQR(5)   = NVOQP+1
          NVOQP     = NVOQP+2
        ELSE
          IF (RTYPE.EQ.'PLOS') BKC = 2
        ENDIF
      ENDIF                                                               20.28
*
      RETURN
**    end of subroutine SWORDC   **
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWODDC (OUTPS, PSNAME, PSTYPE, MIP, MXK, MYK,
     &                   XNLEN, YNLEN, MXN, MYN, XPCN, YPCN, ALPCN,
     &                   XCGRID,YCGRID,RTYPE)                             40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. Authors
*
*     30.72: IJsbrand Haagsma
*
*  1. Updates
*
*            Oct. 95: New subroutine
*     30.72, Sept 97: Replaced DO-block with one CONTINUE to DO-block with
*                     two CONTINUE's
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, Jan. 99: argument RTYPE added, computation of ALCQ changed if
C                     output type (indicated by RTYPE) is PLOT
*
*  2. Purpose
*
*     Decodes output point set data
*
*  3. Method
*
*     ---
*
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
*
*  OUTPS       Int    input   array containing output data
*  PSNAME      Char   input   name of output point set referred to
*  PSTYPE      Char   input   type of output point set
*  MIP         Int    outp    number of output points
*  MXK         Int    outp    number of output points in X-direction (Frame)
*  MYK         Int    outp    number of output points in Y-direction (Frame)
*  XNLEN,YNLEN real   outp    (X,Y)lenght of the nested grid
*  MXN, MYN    int    outp    number of meshes in X, Y direction for
*                             the nested grid
*  XPCN, YPCN  real   outp    location of the origin of the nested grid
*  ALPCN       real   outp    angle of the nested grid with the positive
*                             x-axis, counterclockwise measured
*  RTYPE       char   input   indicates type of output; "PLOT" means that
*                             a spatial plot is made
      CHARACTER  RTYPE *(*)
*
*  5. SUBROUTINES CALLING
*
*       SWOUTP (SWAN/OUTP)
*
*  6. SUBROUTINES USED
*
*       OCREAL to retrieve a real value from an array which is            40.00
*              declared integer
*
*  7. ERROR MESSAGES
*
*       If the point set is not of a known type an error message          40.00
*       is printed and control returns to subroutine SWOUTP
*       If the point set is not of the type frame or ngrid an error message
*       is printed and control returns to subroutine SWOUTP
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Depending on type of set of output points                         40.00
*       determine name, type and number of output points of
*       the output point set
*       ----------------------------------------------------------------
*
      INTEGER    OUTPS(*)
      CHARACTER  PSNAME *(*), PSTYPE *1
      LOGICAL    EQREAL
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWODDC')
*
*
      ALPQ  = 0.
      COSPQ = 1.
      SINPQ = 0.
*     ALCQ  = ALPC           removed 30.50: U and V now in user coordinates
      ALCQ  = 0.
      COSCQ = COS(ALCQ)
      SINCQ = SIN(ALCQ)
*
      PSTYPE = CHAR(OUTPS(1))
*
      IF (PSTYPE.EQ.'F') THEN
        MXK  = OUTPS(7)
        MYK  = OUTPS(8)
        MIP  = MXK * MYK
        XPQ  = OCREAL(OUTPS(4))
        YPQ  = OCREAL(OUTPS(5))
        ALPQ = OCREAL(OUTPS(6))
        COSPQ = COS(ALPQ)
        SINPQ = SIN(ALPQ)
        XQP   = -XPQ*COSPQ - YPQ*SINPQ
        YQP   =  XPQ*SINPQ - YPQ*COSPQ
*       ALCQ  = ALPC-ALPQ    removed 30.50: U and V now in user coordinates
        IF (RTYPE(1:3).EQ.'PLO') THEN                                     40.00
*         in plots directions and components must always be taken
*         w.r.t. frame coordinate system
          ALCQ = -ALPQ                                                    40.00
*         Note: with Nautical convention directions are transformed;
*         they are transformed back in subroutine SWPLOT
        ELSE
          IF (EQREAL(OUTPAR(4),1.)) THEN                                  40.00
*           directions will be w.r.t. frame coordinate system
            ALCQ = -ALPQ
          ELSE
*           directions will be w.r.t. user coordinate system (default)    40.00
            ALCQ = 0.                                                     40.00
          ENDIF                                                           40.00
        ENDIF                                                             40.00
        COSCQ = COS(ALCQ)
        SINCQ = SIN(ALCQ)
        DXK   = OCREAL(OUTPS(2)) / FLOAT(MXK-1)
        HORSC = OCREAL(OUTPS(9)) / OCREAL(OUTPS(2))
        IF(MYK .GT. 1) THEN                                               NRL
          DYK   = OCREAL(OUTPS(3)) / FLOAT(MYK-1)                         NRL
          VRTSC = OCREAL(OUTPS(10))/ OCREAL(OUTPS(3))                     NRL
        ELSE                                                              NRL
          DYK   = 0                                                       NRL
          VRTSC = 0                                                       NRL
        ENDIF                                                             NRL
      ELSE IF (PSTYPE.EQ.'H') THEN                                        30.21
        MXK  = OUTPS(7)
        MYK  = OUTPS(8)
        MIP  = MXK * MYK
        ALPQ = OCREAL(OUTPS(6))
        COSPQ = COS(ALPQ)
        SINPQ = SIN(ALPQ)
        XCMAX = OCREAL(OUTPS(2))
        YCMAX = OCREAL(OUTPS(3))
        XCMIN = OCREAL(OUTPS(4))
        YCMIN = OCREAL(OUTPS(5))
*       CALL EVALF (XCMIN+1. ,YCMIN+1. ,XPMIN ,YPMIN, XCGRID,YCGRID)
*       CALL EVALF (XCMAX+1. ,YCMAX+1. ,XPMAX ,YPMAX, XCGRID,YCGRID)
*       *** Find XQLEN and YQLEN taken the extreme points    ***
*       *** that belongs to the frame                        ***
        XPMIN =  1.E09
        YPMIN =  1.E09
        XPMAX = -1.E09
        YPMAX = -1.E09
C
        DO 61 IX = INT(XCMIN+1.), INT(XCMAX+1.)                           30.72
          DO 60 IY = INT(YCMIN+1.), INT(YCMAX+1.)
            IF (XCGRID(IX,IY) .LT. XPMIN) XPMIN = XCGRID(IX,IY)           30.72
            IF (YCGRID(IX,IY) .LT. YPMIN) YPMIN = YCGRID(IX,IY)           30.72
            IF (XCGRID(IX,IY) .GT. XPMAX) XPMAX = XCGRID(IX,IY)           30.72
            IF (YCGRID(IX,IY) .GT. YPMAX) YPMAX = YCGRID(IX,IY)           30.72
 60       CONTINUE                                                        30.72
 61     CONTINUE                                                          30.72
        XPQ   = XPMIN
        YPQ   = YPMIN
        XQP   = -XPQ
        YQP   = -YPQ
        ALCQ  = 0.
        COSCQ = COS(ALCQ)
        SINCQ = SIN(ALCQ)
        DXK   = (XPMAX - XPMIN)/ FLOAT(MXK-1)
        HORSC = OCREAL(OUTPS(9)) / (XPMAX - XPMIN)
        IF(MYK .GT. 1) THEN                                               NRL
          DYK   = (YPMAX - YPMIN) / FLOAT(MYK-1)                          NRL
          VRTSC = OCREAL(OUTPS(10))/ (YPMAX - YPMIN)                      NRL
        ELSE                                                              NRL
          DYK   = 0                                                       NRL
          VRTSC = 0                                                       NRL
        ENDIF                                                             NRL
*            ENDIF
        XNLEN = 0.
        YNLEN = 0.
        MXN   = 0
        MYN   = 0
        XPCN  = 0.
        YPCN  = 0.
        ALPCN = 0.
        IF (IOUTES .GE. 20) THEN
          WRITE(PRINTF, 11) MXK ,MYK , XQP ,YQP , DXK ,DYK ,HORSC ,VRTSC
 11       FORMAT ('SWODDC :',/,'     MXK ,MYK , XQP     ,YQP       ,DXK'
     &          ,'        ,DYK     ,HORSC'
     &          ,'    ,VRTSC',/,2(1X,I5), 6(1X,E9.3))
          IF (PSTYPE .EQ. 'H') WRITE(PRINTF, 12)XCMIN,XCMAX,YCMIN,YCMAX,
     &      OCREAL(OUTPS(9)),OCREAL(OUTPS(10)),XPMAX ,XPMIN
 12         FORMAT(' XCMIN   ,XCMAX    ,YCMIN    ,YCMAX    ,OUTPS(9)  ',
     &      'OUTPS(10) ,XPMAX    ,XPMIN :',/,8(1X,E9.3))
        ENDIF
      ELSE IF (PSTYPE.EQ.'C' .OR. PSTYPE.EQ.'P') THEN
        MXK = 0
        MYK = 0
        MIP = OUTPS(2)
        XNLEN = 0.
        YNLEN = 0.
        MXN   = 0
        MYN   = 0
        XPCN  = 0.
        YPCN  = 0.
        ALPCN = 0.
*
      ELSE IF (PSTYPE.EQ.'N') THEN
*       nested grid                                                       40.00
        MXK = 0
        MYK = 0
        MIP = OUTPS(2)
        XNLEN = OCREAL(OUTPS(2*MIP+3))
        YNLEN = OCREAL(OUTPS(2*MIP+4))
        MXN   = OUTPS(2*MIP+5)
        MYN   = OUTPS(2*MIP+6)
        XPCN  = OCREAL(OUTPS(2*MIP+7))
        YPCN  = OCREAL(OUTPS(2*MIP+8))
        ALPCN = OCREAL(OUTPS(2*MIP+9))
*
      ELSE
        WRITE (PRTEST, 83) (OUTPS(JJ), JJ=1,12)
  83    FORMAT (' error SWODDC ', 12I10)
      ENDIF
*
      IF (ITEST.GE.100 .OR. IOUTES .GE. 30) THEN
        WRITE (PRTEST, 91) PSNAME, PSTYPE, MIP
  91    FORMAT (' Exit SWODDC  ', A16, 2X, A1, 3I6)
        IF (PSTYPE.EQ.'F' .OR. PSTYPE .EQ. 'H') WRITE (PRTEST, 92)
     &     MXK, MYK, ALPQ, DXK, DYK, HORSC, VRTSC
  92    FORMAT ('SWODDC : MXK, MYK,   ALPQ,   DXK,     DYK,',
     &          '      HORSC,       VRTSC',/,
     &  6X, 2I5, 6(1X,E9.3))
      ENDIF
*
      RETURN
**    end of subroutine SWODDC   **
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWOEXC (OUTPS      ,PSTYPE     ,
     &                    MIP       ,XP         ,
     &                    YP        ,XC         ,
     &                    YC        ,KGRPNT     ,
     &                    XCGRID    ,YCGRID     ,                         30.21
     &                    KGRBND                )                         40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               40.13
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde (1D version)
C     40.00, 40.13: Nico Booij
C     40.02: IJsbrand Haagsma
C
C  1. Update
C
C     30.72, Sept 97: placed a missing comma in FORMAT statement
C     30.72, Sept 97: Replaced DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     32.02, Feb. 98: Introduced 1D version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, June 98: argument KGRBND added, call CVMESH modified
C     40.02, Oct. 00: Gave KGRBND array dimension
!     40.13, Aug. 01: repeating grid (KREPTX>0) XC modified
!                     swcomm4.inc reactivated
C
C  2. Purpose
C
C     Calculates computational grid coordinates of the output points
C
C  3. Method
C
C       ---
C
C  4. Argument variables
C
      INTEGER, INTENT(INOUT) :: KGRBND(*)                                 40.02
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C     OUTPS   Int    input    array containing output data
C     PSTYPE  Char   input    type of output point set
C     MIP     Int    input    number of output points
C     XP, YP  real   outp     user coordinates of output point
C     XC, YC  real   outp     comp. grid coordinates
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     OUTPUT (SWAN/OUTP)
C
C 11. Remarks
C
C       ---
C
C 13. Source text
C
      REAL       XC(*), YC(*), XP(*), YP(*)
      INTEGER    OUTPS(*)
      CHARACTER  PSTYPE *(*)
      INTEGER     KGRPNT(MXC,MYC)                                         30.21
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWOEXC')
*
      IF (PSTYPE.EQ.'F') THEN
        MXQ   = OUTPS(7)
        MYQ   = OUTPS(8)
        ALPQ  = OCREAL(OUTPS(6))
        COSPQ = COS(ALPQ)
        SINPQ = SIN(ALPQ)
        XPQ   = OCREAL(OUTPS(4))
        YPQ   = OCREAL(OUTPS(5))
        XQLEN = OCREAL(OUTPS(2))
        YQLEN = OCREAL(OUTPS(3))
        XQP   = -XPQ*COSPQ - YPQ*SINPQ
        YQP   =  XPQ*SINPQ - YPQ*COSPQ
        IF (MXQ.GT.1) THEN
          DXQ = XQLEN/(MXQ-1)
        ELSE
          DXQ = 0.01
        ENDIF
        IF (MYQ.GT.1) THEN
          DYQ = YQLEN/(MYQ-1)
        ELSE
          DYQ = 0.01
        ENDIF
        IP    = 0
        DO  11  IYQ = 1, MYQ                                              30.72
          YY  = (IYQ-1)*DYQ
          XP1 = XPQ - YY*SINPQ
          YP1 = YPQ + YY*COSPQ
          DO  10  IXQ = 1, MXQ
            XX = (IXQ-1)*DXQ
            IP = IP+1
            XP(IP) = XP1 + XX*COSPQ
            YP(IP) = YP1 + XX*SINPQ
   10     CONTINUE                                                        30.72
   11   CONTINUE                                                          30.72
      ELSE IF (PSTYPE .EQ. 'H') THEN                                      30.21
        XCMAX = OCREAL(OUTPS(2))
        YCMAX = OCREAL(OUTPS(3))
        XCMIN = OCREAL(OUTPS(4))
        YCMIN = OCREAL(OUTPS(5))
        MXQ   = OUTPS(7)
        MYQ   = OUTPS(8)
        ALPQ  = OCREAL(OUTPS(6))
        COSPQ = COS(ALPQ)
        SINPQ = SIN(ALPQ)
        DCXQ  = (XCMAX - XCMIN)/(MXQ-1)
        DCYQ  = (YCMAX - YCMIN)/(MYQ-1)
        XC(1) = XCMIN
        YC(1) = YCMIN
*       *** Find XQLEN and YQLEN taken the extreme points    ***
*       *** that belongs to the frame                        ***
        XPMIN =  1.E09
        YPMIN =  1.E09
        XPMAX = -1.E09
        YPMAX = -1.E09
*
        DO 61 IX = INT(XCMIN+1.), INT(XCMAX+1.)                           30.72
          DO 60 IY = INT(YCMIN+1.), INT(YCMAX+1.)
            IF (KGRPNT(IX,IY).GT.1) THEN                                  40.00
              IF (XCGRID(IX,IY) .LT. XPMIN) XPMIN = XCGRID(IX,IY)         30.72
              IF (YCGRID(IX,IY) .LT. YPMIN) YPMIN = YCGRID(IX,IY)         30.72
              IF (XCGRID(IX,IY) .GT. XPMAX) XPMAX = XCGRID(IX,IY)         30.72
              IF (YCGRID(IX,IY) .GT. YPMAX) YPMAX = YCGRID(IX,IY)         30.72
            ENDIF                                                         40.00
 60       CONTINUE                                                        30.72
 61     CONTINUE                                                          30.72
        XPQ   = XPMIN
        YPQ   = YPMIN
        XQP   = 0.
        YQP   = 0.
        XQLEN = XPMAX - XPMIN
        YQLEN = YPMAX - YPMIN
        DXQ = (XQLEN)/(MXQ-1)
        DYQ = (YQLEN)/(MYQ-1)
        IF (ITEST.GE. 120 ) THEN
          WRITE(PRINTF,64) XQLEN ,YQLEN ,MXQ ,MYQ ,
     &                     DCXQ  ,DCYQ ,XC(1) ,YC(1),DXQ ,DYQ
 64       FORMAT (' SWOEXC FRAME DATA :',/,' XQLEN      ,YQLEN      ',    30.72
     &            ',MXQ ,MYQ , DCXQ    ,DCYQ     ,XC(1)    ,YC(1)',
     &            '    ,DXQ       ,DYQ',/,1X,
     &    2(1X,E9.3),2(1X,I4),2X,6(1X,E9.3))
          WRITE(PRINTF,65)XCMIN,XCMAX,YCMIN,YCMAX,
     &                    XPMIN,XPMAX,YPMIN,YPMAX
 65       FORMAT('XCMIN        ,XCMAX  ,YCMIN     ,YCMAX    ,XPMIN',
     &           '   ,XPMAX     ,YPMIN    ,YPMAX   ',/,8(1X,E9.3),/)
        ENDIF
        YY    = YC(1) - DCYQ
        IP    = 0
        DO 15 IYQ = 1 ,MYQ
          XX = XC(1) - DCXQ
          YY = YY    + DCYQ
          DO 16 IXQ = 1 ,MXQ
            IP = IP + 1
            XX = XX + DCXQ
            XC(IP) = XX
            YC(IP) = YY
            IF (KGRPNT(NINT(XX)+1,NINT(YY)+1) .GT. 1) THEN                40.00
              CALL EVALF (XC(IP)+1. ,YC(IP)+1. ,XPP ,YPP, XCGRID,YCGRID)  30.72
              XP(IP) = XPP
              YP(IP) = YPP
            ELSE
              XP(IP) = OVEXCV(1)
              YP(IP) = OVEXCV(2)
            ENDIF
            IF (ITEST.GE.200) WRITE(PRTEST,63)
     &      XP(IP), YP(IP), XC(IP), YC(IP)
 16       CONTINUE
 15     CONTINUE
        RETURN
      ELSE IF (PSTYPE.EQ.'C' .OR. PSTYPE.EQ.'P' .OR. PSTYPE.EQ.'N') THEN  20.6x
        DO 50 IP = 1, MIP
          XP(IP) = OCREAL(OUTPS(2*IP+1))
          YP(IP) = OCREAL(OUTPS(2*IP+2))
 50     CONTINUE
      ENDIF
C
*     transform to computational grid
*
      IF (ITEST.GE. 150 .AND. OPTG .EQ. 1)
     &  WRITE (PRTEST, 62) XCP, YCP, COSPC, SINPC, DX, DY
  62  FORMAT (' SWOEXC, transf. coeff.:', 8(1X,E12.4))
*     *** The transformation to computational grid depends ***
*     *** on the grid type: regular(1) , curvilinear(3)    ***
      DO 70 IP=1, MIP
        IF (OPTG .EQ. 1) THEN                                             30.2x
          XC(IP) = (XCP + XP(IP)*COSPC + YP(IP)*SINPC) / DX
!         repeating grid: XC is shifted to be between 0 and MXC           40.13
          IF (KREPTX.GT.0) XC(IP) = MODULO (XC(IP), REAL(MXC))            40.13
          IF (ONED) THEN                                                  32.02
            YC(IP) = 0                                                    32.02
          ELSE                                                            32.02
            YC(IP) = (YCP - XP(IP)*SINPC + YP(IP)*COSPC) / DY
          ENDIF                                                           32.02
        ELSE
          XPA = XP(IP)
          YPA = YP(IP)
          CALL CVMESH (XPA, YPA, XCA, YCA, KGRPNT, XCGRID ,YCGRID,        30.21
     &                 KGRBND)                                            40.00
          XC(IP) = XCA
          YC(IP) = YCA
        ENDIF
        IF (ITEST.GE.250 ) WRITE(PRTEST,63)XP(IP) ,
     &  YP(IP) ,XC(IP) ,YC(IP)
  70  CONTINUE
  63  FORMAT (' SWOEXC, PROBLEM  COORD:', 2(1X,F10.2),/,
     &        '         COMPUT   COORD:', 2(1X,F10.2))
*
      RETURN
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWOEXD (OQPROC, MIP, XC, YC, VOQR, VOQ, COMPDA ,KGRPNT)  30.21
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'timecomm.inc'                                              40.00
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde (1D version)
C     31.02: Nico Booij
C
C  1. Updates
C
C     10.07, July 94, error in current velocity repaired, wind velocity added
C     30.72, Oct. 97: logical function EQREAL introduced for floating point
C                     comparisons
C     32.02, Feb. 98: Introduced 1D version
C     31.02, Sep. 97: computation of Setup, and computation of Force
C                     from setup computation
C     40.00, June 98: Tsec added
C     33.09, Mar. 00: in case of spherical coordinates, distance in m is
C                     calculated from coordinates in degrees
C
C  2. Purpose
C
C     Calculates  Dist, Depth, Ux, Uy, ..
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     OQPROC  logic  input    y/n process outp quantities
C     PSNAME  Char   input    name of output point set referred to
C     MIP     Int    input    number of output points
C     XP, YP  real   outp     user coordinates of output point
C     XC, YC  real   outp     comp. grid coordinates
C     WX2, WY2  real   input    wind components
C
C  9. Subroutines calling
C
C     SWOUTP (SWAN/OUTPUT)
C
C  8. Subroutines used
C
C     SWIPOL
C
C 11. Remarks
C
C       ---
C
C 13. Source text
C
      REAL       XC(*), YC(*), VOQ(MIP,*), COMPDA(MCGRD,MCMVAR)
      INTEGER    VOQR(*), KGRPNT(MXC,MYC)
      LOGICAL    OQPROC(*), EQREAL                                        30.72
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWOEXD')
*
      IF (ITEST.GE. 100 .OR. IOUTES .GE. 10) WRITE (PRTEST, 10)
     &(OQPROC(JJ), JJ=1,10), OQPROC(26), MIP
  10  FORMAT (' Entry SWOEXD ', 11L2, I8)
      IVXP   = 1
      IVYP   = 2
*
*       distance
*
 110  IF (OQPROC(3)) THEN
        IVDIST = VOQR(3)
        DO IP = 1, MIP
          IF (IP.EQ.1) THEN
            RDIST = 0.
          ELSE
            RDX = VOQ(IP,IVXP) - VOQ(IP-1,IVXP)
            RDY = VOQ(IP,IVYP) - VOQ(IP-1,IVYP)
            IF (KSPHER.GT.0) THEN                                         33.09
*             spherical coordinates: distance is expressed in m
              RDX = RDX * LENDEG *
     &        COS(DEGRAD*(YOFFS+0.5*(VOQ(IP,IVYP)+VOQ(IP-1,IVYP))))       33.09
              RDY = RDY * LENDEG
            ENDIF
            RDIST = RDIST + SQRT(RDX*RDX+RDY*RDY)
          ENDIF
          VOQ(IP,IVDIST) = RDIST
        ENDDO
      ENDIF
*
*     correct problem coordinates with offset values
*
      DO IP=1, MIP
        XP1 = VOQ(IP,IVXP)
        IF (.NOT.EQREAL(XP1,OVEXCV(1)))                                   40.00
     &        VOQ(IP,IVXP) = XP1 + XOFFS
        YP1 = VOQ(IP,IVYP)
        IF (.NOT.EQREAL(YP1,OVEXCV(2)))                                   40.00
     &        VOQ(IP,IVYP) = YP1 + YOFFS
      ENDDO
*
*       depth
*
 120  IF (OQPROC(4)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 4,
     &  VOQR(4), JDP2
 121    FORMAT (' SWOEXD, type:', 4I3)
        CALL SWIPOL (COMPDA(1,JDP2), OVEXCV(4), XC, YC, MIP,
     &               VOQ(1,VOQR(4)) ,KGRPNT, COMPDA(1,JDP2))
      ENDIF
*
*       current velocity
*
 130  IF (OQPROC(5)) THEN
        JVQX = VOQR(5)
        JVQY = JVQX+1
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 5,
     &  VOQR(5), JVX2
        IF (ICUR.EQ.1) THEN
          CALL SWIPOL (COMPDA(1,JVX2), OVEXCV(5), XC, YC, MIP,
     &                 VOQ(1,JVQX) ,KGRPNT, COMPDA(1,JDP2))               30.21
          CALL SWIPOL (COMPDA(1,JVY2), OVEXCV(5), XC, YC, MIP,
     &                 VOQ(1,JVQY) ,KGRPNT, COMPDA(1,JDP2))               30.21
          DO IP = 1, MIP
            UXLOC = VOQ(IP,JVQX)
            UYLOC = VOQ(IP,JVQY)
            VOQ(IP,JVQX) = COSCQ*UXLOC - SINCQ*UYLOC
            VOQ(IP,JVQY) = SINCQ*UXLOC + COSCQ*UYLOC
          ENDDO                                                           10.07
        ELSE
          DO IP = 1, MIP                                                  20.85
            VOQ(IP,JVQX) = 0.
            VOQ(IP,JVQY) = 0.
          ENDDO
        ENDIF
      ENDIF
*
*       Ubot, Urms
*
 140  IF (OQPROC(6)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 6,
     &  VOQR(6)
        CALL SWIPOL (COMPDA(1,JUBOT), OVEXCV(6), XC, YC, MIP,
     &               VOQ(1,VOQR(6)) ,KGRPNT, COMPDA(1,JDP2))              30.21
        KK = VOQR(6)
        RR = SQRT(2.)
        DO IP = 1, MIP
          UBLOC = VOQ(IP,KK)
          IF (.NOT.EQREAL(UBLOC,OVEXCV(6))) VOQ(IP,KK) = RR * UBLOC       30.72
        ENDDO
      ENDIF
*                            Urms
      IF (OQPROC(34)) THEN                                                20.67
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 34,
     &  VOQR(34)
        CALL SWIPOL (COMPDA(1,JUBOT), OVEXCV(34), XC, YC, MIP,
     &               VOQ(1,VOQR(34)) ,KGRPNT, COMPDA(1,JDP2))             30.21
      ENDIF
*
*       dissipation
*
 150  IF (OQPROC(7)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 7,
     &  VOQR(7)
        CALL SWIPOL (COMPDA(1,JDISS), OVEXCV(7), XC, YC, MIP,
     &               VOQ(1,VOQR(7)) ,KGRPNT, COMPDA(1,JDP2))              30.21
        IF (INRHOG.EQ.1) THEN
          DO 152 IP = 1, MIP
            F1 = VOQ(IP,VOQR(7))
            IF (.NOT.EQREAL(F1,OVEXCV(7))) VOQ(IP,VOQR(7))=F1*RHO*GRAV    30.72
 152      CONTINUE
        ENDIF
      ENDIF
*
*       Qb
*
 160  IF (OQPROC(8)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 8,
     &  VOQR(8)
*       CALL SWIPOL (QB, OVEXCV(8), XC, YC, MIP, VOQ(1,VOQR(8)))
        CALL SWIPOL (COMPDA(1,JQB), OVEXCV(8), XC, YC, MIP,
     &               VOQ(1,VOQR(8)) ,KGRPNT, COMPDA(1,JDP2))              30.21
      ENDIF
*
*       wind velocity                                                     10.07
*
 170  IF (OQPROC(26)) THEN
        JVQX = VOQR(26)
        JVQY = JVQX+1
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 26,
     &  VOQR(26)
        IF (VARWI) THEN
          CALL SWIPOL (COMPDA(1,JWX2), OVEXCV(26), XC, YC, MIP,
     &                 VOQ(1,JVQX) ,KGRPNT, COMPDA(1,JDP2))
          CALL SWIPOL (COMPDA(1,JWY2), OVEXCV(26), XC, YC, MIP,
     &                 VOQ(1,JVQY) ,KGRPNT, COMPDA(1,JDP2))               30.21
          DO IP = 1, MIP
            UXLOC = VOQ(IP,JVQX)
            UYLOC = VOQ(IP,JVQY)
            VOQ(IP,JVQX) = COSCQ*UXLOC - SINCQ*UYLOC
            VOQ(IP,JVQY) = SINCQ*UXLOC + COSCQ*UYLOC
          ENDDO
        ELSE
          DO IP = 1, MIP
            VOQ(IP,JVQX) = U10*COS(WDIP-ALPQ)                             10.36
            VOQ(IP,JVQY) = U10*SIN(WDIP-ALPQ)                             10.36
          ENDDO
        ENDIF
      ENDIF
*
*       diff. in Hs between iterations                                    20.52
*
 180  IF (OQPROC(30)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 30,
     &  VOQR(30), JDHS
        CALL SWIPOL (COMPDA(1,JDHS), OVEXCV(30), XC, YC, MIP,
     &               VOQ(1,VOQR(30)) ,KGRPNT, COMPDA(1,JDP2))             30.21
      ENDIF
*
*       diff. in Tm between iterations                                    20.52
*
 190  IF (OQPROC(31)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 31,
     &  VOQR(31), JDHS
        CALL SWIPOL (COMPDA(1,JDTM), OVEXCV(31), XC, YC, MIP,
     &               VOQ(1,VOQR(31)) ,KGRPNT, COMPDA(1,JDP2))             30.21
      ENDIF
*
*       Leak
*
 200  IF (OQPROC(9)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 9,
     &  VOQR(9), JLEAK
        CALL SWIPOL (COMPDA(1,JLEAK), OVEXCV(9), XC, YC, MIP,
     &               VOQ(1,VOQR(9)) ,KGRPNT, COMPDA(1,JDP2))              30.21
        IF (INRHOG.EQ.1) THEN
          DO 202 IP = 1, MIP
            F1 = VOQ(IP,VOQR(9))
            IF (.NOT.EQREAL(F1,OVEXCV(9))) VOQ(IP,VOQR(9))=F1*RHO*GRAV    30.72
 202      CONTINUE
        ENDIF
      ENDIF
*
*       Ufric
*
      IF (OQPROC(35)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 35,
     &  VOQR(35), JUSTAR
        IF (JUSTAR.GT.1) THEN
          CALL SWIPOL (COMPDA(1,JUSTAR), OVEXCV(35), XC, YC, MIP,
     &               VOQ(1,VOQR(35)) ,KGRPNT, COMPDA(1,JDP2))             30.22
        ELSE
          DO IP = 1, MIP                                                  31.02
            VOQ(IP,VOQR(35)) = OVEXCV(35)                                 31.02
          ENDDO                                                           31.02
        ENDIF
      ENDIF
*
*       Zelen
*
      IF (OQPROC(36)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 36,
     &  VOQR(36), JZEL
        IF (JZEL.GT.1) THEN
          CALL SWIPOL (COMPDA(1,JZEL), OVEXCV(36), XC, YC, MIP,
     &               VOQ(1,VOQR(36)) ,KGRPNT, COMPDA(1,JDP2))             30.22
        ELSE
          DO IP = 1, MIP                                                  31.02
            VOQ(IP,VOQR(36)) = OVEXCV(36)                                 31.02
          ENDDO                                                           31.02
        ENDIF
      ENDIF
*
*       TauW
*
      IF (OQPROC(37)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 37,
     &  VOQR(37), JTAUW
        IF (JTAUW.GT.1) THEN
          CALL SWIPOL (COMPDA(1,JTAUW), OVEXCV(37), XC, YC, MIP,
     &               VOQ(1,VOQR(37)) ,KGRPNT, COMPDA(1,JDP2))             30.22
        ELSE
          DO IP = 1, MIP                                                  31.02
            VOQ(IP,VOQR(37)) = OVEXCV(37)                                 31.02
          ENDDO                                                           31.02
        ENDIF
      ENDIF
*
*       Cdrag
*
      IF (OQPROC(38)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 20) WRITE (PRTEST, 121) 38,
     &  VOQR(38), JCDRAG
        IF (JCDRAG.GT.1) THEN
          CALL SWIPOL (COMPDA(1,JCDRAG), OVEXCV(38), XC, YC, MIP,
     &               VOQ(1,VOQR(38)) ,KGRPNT, COMPDA(1,JDP2))             30.22
        ELSE
          DO IP = 1, MIP                                                  31.02
            VOQ(IP,VOQR(38)) = OVEXCV(38)                                 31.02
          ENDDO                                                           31.02
        ENDIF
      ENDIF
C
C     *** wave-induced setup ***                                          32.02
C
      IF (OQPROC(39)) THEN                                                32.02
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 39,      32.02
     &  VOQR(39), JSETUP                                                  32.02
        IF (LSETUP.GT.0) THEN                                             32.02
          CALL SWIPOL (COMPDA(1,JSETUP), OVEXCV(39), XC, YC, MIP,         32.02
     &                 VOQ(1,VOQR(39)) ,KGRPNT, COMPDA(1,JDP2))           32.02
        ELSE                                                              32.02
          DO IP = 1, MIP                                                  32.02
            VOQ(IP,VOQR(39)) = 0.                                         32.02
          ENDDO                                                           32.02
        ENDIF                                                             32.02
      ENDIF                                                               32.02
*
*     wave-driven force (as computed during setup computation)            31.02
*
      IF (OQPROC(20) .AND. LSETUP.GT.0 .AND. (.NOT.ONED)) THEN            31.04
        JVQX = VOQR(20)
        JVQY = JVQX+1
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 20,
     &  VOQR(20), JWFRCX
        CALL SWIPOL (COMPDA(1,JWFRCX), OVEXCV(20), XC, YC, MIP,
     &               VOQ(1,JVQX) ,KGRPNT, COMPDA(1,JDP2))                 31.02
        CALL SWIPOL (COMPDA(1,JWFRCY), OVEXCV(20), XC, YC, MIP,
     &               VOQ(1,JVQY) ,KGRPNT, COMPDA(1,JDP2))                 31.02
        DO IP = 1, MIP
          UXLOC = VOQ(IP,JVQX)
          UYLOC = VOQ(IP,JVQY)
          IF (EQREAL(UXLOC,OVEXCV(20)) .AND. EQREAL(UYLOC,OVEXCV(20)))    31.04
     &    THEN
            VOQ(IP,JVQX) = OVEXCV(20)                                     31.04
            VOQ(IP,JVQY) = OVEXCV(20)                                     31.04
          ELSE
            VOQ(IP,JVQX) = RHO * GRAV * (COSCQ*UXLOC - SINCQ*UYLOC)       31.04
            VOQ(IP,JVQY) = RHO * GRAV * (SINCQ*UXLOC + COSCQ*UYLOC)       31.04
          ENDIF
        ENDDO
      ENDIF
*
*       Ursell
*
      IF (OQPROC(45)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 45,      40.03
     &  VOQR(45)
        CALL SWIPOL (COMPDA(1,JURSEL), OVEXCV(45), XC, YC, MIP,
     &               VOQ(1,VOQR(45)) ,KGRPNT, COMPDA(1,JDP2))             40.03
      ENDIF
*
*       Air-Sea temperature difference
*
      IF (OQPROC(46)) THEN
        IF (ITEST.GE.50 .OR. IOUTES .GE. 10) WRITE (PRTEST, 121) 46,      40.03
     &  VOQR(46)
        CALL SWIPOL (COMPDA(1,JASTD2), OVEXCV(46), XC, YC, MIP,
     &               VOQ(1,VOQR(46)) ,KGRPNT, COMPDA(1,JDP2))             40.03
      ENDIF
C
C       Tsec
C
      IF (OQPROC(41)) THEN
        DO IP = 1, MIP
          VOQ(IP,VOQR(41)) = TIMCO - OUTPAR(1)                            40.00
        ENDDO
      ENDIF
C
      RETURN
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWIPOL (FINP, EXCVAL, XC, YC, MIP, FOUTP ,KGRPNT, DEP2)  40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               40.13
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
!     40.13: Nico Booij
!
*  1. UPDATE
*
*     40.00, July 98: no interpolation if one or more corners are dry
*                     argument DEP2 added
*                     margin around comp. grid introduced
!     40.13, Aug. 01: provision for repeating grid
!                     swcomm4.inc reactivated
*
*  2. PURPOSE
*
*       Interpolate the function FINP to the point given by computational
*       grid coordinates XC and YC; result appears in array FOUTP
*
*  3. METHOD
*
*       This subroutine computes the contributions from surrounding
*       points to the function value in an output point. The points used
*       are indicated in the sketch below.
*
*                                                            Y
*           +-------------------------------------------------->
*           |
*           |       .       .       .       .       .       .
*           |
*           |
*           |
*           |       .       .       *       *       .       .
*           |
*           |
*           |                         o
*           |       .       .       *       *       .       .
*           |
*           |
*           |
*           |       .       .       .       .       .       .
*           |
*           |
*           |
*         X |       .       .       .       .       .       .
*           |
*           V
*
*                 *   point of the computational grid contributing
*                       to output point (o)
*                 .   other grid points
*
*  4. PARAMETERLIST
*
*       FINP    real a input    array of function values defined on the
*                               computational grid
*       EXCVAL  real   input    exception value (assigned if point is outside
*                               computational grid)
*       XC, YC  real a input    array containing computational grid coordinates
*                               of output points
*       MIP     INT    input    number of output points
*       FOUTP   real a output   array of interpolated values for the output
*                               points
*
*  5. SUBROUTINES CALLING
*
*       SWOEXD
*
*  6. SUBROUTINES USED
*
*       ---
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       IINTPC=1: bilinear interpolation
*       IINTPC=2: higher order interpolation using functions G1 and G2
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       For every output point do
*           If the output point is near line XCL then
*               Determine points contributing to the output point
*               Compute contribution to the projection of the output
*                 point on line XCL
*               Compute multiplication factor for interpolation in X-
*                 direction
*               Compute contribution for the output point
*               Add result to value of variable for the output point in
*                 array IFOP
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      REAL FINP(MCGRD), FOUTP(MIP), XC(MIP), YC(MIP), DEP2(MCGRD)         40.00
      LOGICAL OUTSID
      INTEGER  KGRPNT(MXC,MYC)                                            30.21
*
      SAVE IENT
      DATA IENT /0/
      IF (LTRACE) CALL  STRACE (IENT, 'SWIPOL')
*
        IF (ITEST.GE.150) WRITE (PRTEST, 61)                             060997
  61    FORMAT ('   XC    , YC  ,',
     &  '   JX1, JY1, JX2,  JY2  SX1,  SY1, FOUTP(IP),',
     &  '    INDX1  INDX2  INDX3  INDX4')
*
      DO 100 IP=1,MIP
        IF (XC(IP) .LE. -0.5 .OR. YC(IP) .LE. -0.5) THEN                  40.00
          FOUTP(IP) = EXCVAL
          JX1   = 0
          JY1   = 0
          JX2   = 0
          JY2   = 0
          SX1   = 0.
          SX2   = 0.
          INDX1 = 0
          INDX2 = 0
          INDX3 = 0
          INDX4 = 0
          GOTO 80
        ENDIF                                                             30.21
        OUTSID = .FALSE.
        FOUTP(IP) = 0.
        JX1 = INT(XC(IP)+3.) - 2
        JX2 = JX1 + 1
        SX2 = XC(IP) + 1. - FLOAT(JX1)
        SX1 = 1. - SX2
        IF (JX1.LT.0)   OUTSID = .TRUE.
        IF (KREPTX .EQ. 0) THEN                                           40.13
          IF (JX1.GT.MXC) OUTSID = .TRUE.
          IF (JX1.EQ.MXC) JX2 = MXC
          IF (JX1.EQ.0)   JX1 = 1
        ELSE                                                              40.13
          JX1 = 1 + MODULO (JX1-1,MXC)                                    40.13
          JX2 = 1 + MODULO (JX2-1,MXC)                                    40.13
        ENDIF                                                             40.13
        JY1 = INT(YC(IP)+3.) - 2
        JY2 = JY1 + 1
        SY2 = YC(IP) + 1. - FLOAT(JY1)
        SY1 = 1. - SY2
        IF (JY1.LT.0)   OUTSID = .TRUE.
        IF (JY1.GT.MYC) OUTSID = .TRUE.
        IF (JY1.EQ.MYC) JY2 = MYC
        IF (JY1.EQ.0)   JY1 = 1
        IF (OUTSID) THEN
          FOUTP(IP) = EXCVAL
        ELSE
          INDX1 = KGRPNT(JX1,JY1)                                         30.21
          WW1 = SX1*SY1
          IF (DEP2(INDX1).LE.DEPMIN .AND. WW1.GT.0.01) OUTSID = .TRUE.    40.00
          INDX2 = KGRPNT(JX2,JY1)                                         30.21
          WW2 = SX2*SY1
          IF (DEP2(INDX2).LE.DEPMIN .AND. WW2.GT.0.01) OUTSID = .TRUE.    40.00
          INDX3 = KGRPNT(JX1,JY2)                                         30.21
          WW3 = SX1*SY2
          IF (DEP2(INDX3).LE.DEPMIN .AND. WW3.GT.0.01) OUTSID = .TRUE.    40.00
          INDX4 = KGRPNT(JX2,JY2)                                         30.21
          WW4 = SX2*SY2
          IF (DEP2(INDX4).LE.DEPMIN .AND. WW4.GT.0.01) OUTSID = .TRUE.    40.00
          IF (OUTSID) THEN
            FOUTP(IP) = EXCVAL
          ELSE
            FOUTP(IP) = WW1*FINP(INDX1) + WW2*FINP(INDX2)                 30.21
     &                + WW3*FINP(INDX3) + WW4*FINP(INDX4)                 30.21
          ENDIF
        ENDIF
  80    IF (ITEST.GE.150) WRITE (PRTEST, 82)
     &  XC(IP) , YC(IP) ,JX1, JY1, JX2,JY2,SX1, SY1, FOUTP(IP),INDX1 ,
     &  INDX2 ,INDX3 ,INDX4
  82    FORMAT (2(F7.1,1X),4I5, 2(1X,F5.2),1X,E10.4,3X,4(2X,I5))
 100  CONTINUE
*
      RETURN
* * end of subroutine SWIPOL *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWOEXA (OQPROC     ,BKC        ,
     &                   MIP        ,XC         ,
     &                   YC         ,VOQR       ,
     &                   VOQ        ,AC2        ,
     &                   ACLOC      ,SPCSIG     ,                         30.72
     &                   WK         ,CG         ,
     &                   SPCDIR     ,NE         ,
     &                   NED        ,KGRPNT     ,
     &                   DEPXY                  )                         30.50
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70, 40.13: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     32.01: Roeland Ris & Cor van der Schelde
C
C  1. Updates
C
C     10.09, Aug. 94: relative and absolute period distinguished
C                     NVOTP increased and type 28 added
C     10.10, Aug. 94: arrays ECOS, ESIN, NE and NED added to arg. list
C     10.22, Sep. 94: condition for tail changed from MSC.GE.3 to MSC.GT.3
C     20.59, Sep. 95: average wave number can be determined with
C                     other powers of k (i.e. OUTPAR(3))
C     20.61, Sep. 95: Tm02 and FWID added; computation of average period
C                     also changed
C     30.72, Oct. 97: logical function EQREAL introduced for floating point
C                     comparisons
C     32.01, Jan. 98: Nautical convention introduced (project h3268)
C     30.70, Feb. 98: ALCQ ignored if nautical direction is requested
C                     computation of kappa corrected (power of Sigma)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
!     40.13, Aug. 01: provision for repeating grid (KREPTX>0)
C
C  2. Purpose
C
C     calculates quantities for which the spectral action density is
C     necessary
C
C  3. Method
C
C       ---
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
C
C     OQPROC  logic  input    processing of output quantities
C     MIP     Int    input    number of output points
C     XC, YC  real   input    comp. grid coordinates
C     VOQR    int a  input    location in VOQ of a certain outp quant.
C     VOQ     real a outp     values of output quantities
C     AC2     real a input    action densities
C     WK      real a local    wavenumber in output point
C     CG      real a local    group velocity in output point
C     NE      real a local    ratio of group and phase velocity
C     NED     real a local    derivative of NE with respect to depth
C     DEPXY   real a input    depth in points of computational grid
C
C     Local Variables
C
C     IVOTP   type indicators of output quantities processed by this subr.
C             used for assignment of exception values
C
C  8. Subroutines used
C
C     DEGCNV: Transforms dir. from nautical to cartesian or vice versa    32.01
C     ANGDEG: Transforms degrees to radians                               32.01
C     SWOINA: interpolates 2D action density spectrum
C
C  9. Subroutines calling
C
C     OUTPUT (SWAN/OUTP)
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     For all output points do
C         interpolate action density to the output point
C         If processing of the quantity is requested
C         Then compute wave height, period etc.
C         ------------------------------------------------------------
C         If computation of Cg and K is necessary
C         Then get depth from array VOQ
C              Call KSCIP1 (computes Cg and K)
C         ------------------------------------------------------------
C         If processing of the quantity is requested
C         Then compute energy transport, wavelength etc.
C     ----------------------------------------------------------------
C
C 13. Source text
C
      PARAMETER  (NVOTP=16)                                               40.00
      REAL       XC(MIP)        ,YC(MIP)       ,AC2(MDC,MSC,MCGRD),
     &           VOQ(MIP,*)     ,
     &           WK(*)          ,
     &           CG(*)          ,ACLOC(MDC,MSC),
     &           NE(*)          ,NED(*)        ,DEPXY(MCGRD)
     &
*
      INTEGER    VOQR(*)        ,BKC           ,IVOTP(NVOTP)      ,
     &           KGRPNT(MXC,MYC)                                          30.21
*
      LOGICAL    OQPROC(*), EQREAL                                        30.72
      SAVE IENT, IVOTP
      DATA IENT /0/
      DATA IVOTP /10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 28, 32, 33,     20.61
     &            42, 43, 44/                                             40.00
      CALL STRACE (IENT, 'SWOEXA')
*
*     loop over all output points
*
      DO 800 IP=1,MIP
        DEP = VOQ(IP,VOQR(4))
*
*       assign exception value if depth is negative or point is outside grid
*
        IF (DEP.LE.0.)                    GOTO 700
        IF (EQREAL(DEP,OVEXCV(4)))        GOTO 700                        30.72
        IF (KREPTX.EQ.0) THEN                                             40.13
!         non-repeating grid                                              40.13
          IF (XC(IP) .LT. -0.01)            GOTO 700
          IF (XC(IP) .GT. REAL(MXC-1)+0.01) GOTO 700
        ENDIF                                                             40.13
        IF (YC(IP) .LT. -0.01)            GOTO 700
        IF (YC(IP) .GT. REAL(MYC-1)+0.01) GOTO 700
*
*       first the action density spectrum is interpolated
*
        CALL SWOINA (XC(IP), YC(IP), AC2, ACLOC, KGRPNT, DEPXY)           30.50
*
*       Coefficients for high frequency tail
*
        EFTAIL = 1. / (PWTAIL(1) - 1.)
*
*       significant wave height
*
        IVTYPE = 10
        IF (OQPROC(IVTYPE)) THEN
          ETOT = 0.
          DO 210 ID=1, MDC
            DO 207 IS=2,MSC
              DS=SPCSIG(IS)-SPCSIG(IS-1)                                  30.72
              EAD = 0.5*(SPCSIG(IS)*ACLOC(ID,IS)+                         30.72
     &                   SPCSIG(IS-1)*ACLOC(ID,IS-1))*DS*DDIR             30.72
              ETOT = ETOT + EAD
  207       CONTINUE
            IF (MSC .GT. 3) THEN                                          10.20
*             contribution of tail to total energy density
              EHFR = ACLOC(ID,MSC) * SPCSIG(MSC)                          30.72
              ETOT = ETOT + DDIR * EHFR * SPCSIG(MSC) * EFTAIL            30.72
            ENDIF
  210     CONTINUE
          IF (ETOT .GE. 0.) THEN                                          30.00
            VOQ(IP,VOQR(IVTYPE)) = 4.*SQRT(ETOT)
          ELSE
*            VOQ(IP,VOQR(IVTYPE)) = 0.
            VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
          ENDIF
          IF (ITEST.GE.100) THEN                                          40.00
            WRITE(PRINTF, 222) IP, OVSNAM(IVTYPE), VOQ(IP,VOQR(IVTYPE))   40.00
          ENDIF
        ENDIF
*
*       swell wave height
*
        IVTYPE = 44
        IF (OQPROC(IVTYPE)) THEN
          ETOT = 0.
          FSWELL = PI2 * OUTPAR(5)
          DO IS = 2, MSC
            DS = SPCSIG(IS)-SPCSIG(IS-1)
            IF (SPCSIG(IS).LT.FSWELL) THEN
              CIA = 0.5 * SPCSIG(IS-1) * DS * DDIR
              CIB = 0.5 * SPCSIG(IS) * DS * DDIR
            ELSE
              DSSW = FSWELL-SPCSIG(IS-1)
              CIB = 0.5 * FSWELL * DDIR * DSSW**2 / DS
              CIA = SPCSIG(IS-1) * DSSW * DDIR - CIB
            ENDIF
            DO ID = 1, MDC
              EAD = CIA * ACLOC(ID,IS-1) + CIB * ACLOC(ID,IS)
              ETOT = ETOT + EAD
            ENDDO
            IF (SPCSIG(IS) .GT. FSWELL) GOTO 228
          ENDDO
 228      IF (ETOT .GE. 0.) THEN                                          30.00
            VOQ(IP,VOQR(IVTYPE)) = 4.*SQRT(ETOT)
          ELSE
            VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
          ENDIF
          IF (ITEST.GE.100) THEN                                          40.00
            WRITE(PRINTF, 222) IP, OVSNAM(IVTYPE), VOQ(IP,VOQR(IVTYPE))   40.00
 222        FORMAT(' SWOEXA: POINT ', I5, 2X, A, 1X, E12.4)
          ENDIF
        ENDIF
*       WRITE (PRTEST,*) ' computation sign. wave height completed'
*
*       average relative period                              modified 10.09
*
        IVTYP1 = 28
        IVTYP2 = 11
        IF (OQPROC(IVTYP1) .OR. (ICUR.EQ.0.AND.OQPROC(IVTYP2))) THEN
           APTOT = 0.
           EPTOT = 0.
           DO 220 ID=1, MDC
              DO 217 IS=1,MSC
                SIG2P = SPCSIG(IS) ** 2                                   40.00
                APTOT = APTOT + SIG2P * ACLOC(ID,IS)                      10.30
                EPTOT = EPTOT + SPCSIG(IS) * SIG2P * ACLOC(ID,IS)         30.72
 217          CONTINUE
 220        CONTINUE
            APTOT = APTOT * FRINTF
            EPTOT = EPTOT * FRINTF
            IF (MSC .GT. 3) THEN                                          10.20
              PPTAIL = PWTAIL(1) - 1.                                     40.00
              APTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.61
              PPTAIL = PWTAIL(1) - 2.                                     40.00
              EPTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.61
              DO ID = 1, MDC
*               contribution of tail to total energy density
                AHFR = SIG2P * ACLOC(ID,MSC)                              10.30
                APTOT = APTOT + APTAIL * AHFR
                EHFR = SPCSIG(MSC) * AHFR                                 30.72
                EPTOT = EPTOT + EPTAIL * EHFR
              ENDDO
           ENDIF
           IF (EPTOT.GT.0.) THEN
             TPER = 2.*PI * APTOT / EPTOT
             IF (OQPROC(IVTYP1))
     &              VOQ(IP,VOQR(IVTYP1)) = TPER
             IF (OQPROC(IVTYP2))
     &              VOQ(IP,VOQR(IVTYP2)) = TPER
           ELSE
             IF (OQPROC(IVTYP1))
     &             VOQ(IP,VOQR(IVTYP1)) = OVEXCV(IVTYP1)
             IF (OQPROC(IVTYP2))
     &             VOQ(IP,VOQR(IVTYP2)) = OVEXCV(IVTYP2)
           ENDIF
        ENDIF
*
*       average relative period                              modified 10.09
*
        IVTYP1 = 43                                                       40.00
        IVTYP2 = 42                                                       40.00
        IF (OQPROC(IVTYP1) .OR. (ICUR.EQ.0.AND.OQPROC(IVTYP2))) THEN
           APTOT = 0.
           EPTOT = 0.
           DO ID=1, MDC
              DO IS=1,MSC
                SIG2P = SPCSIG(IS) ** (OUTPAR(2)+1.)                      40.00
                APTOT = APTOT + SIG2P * ACLOC(ID,IS)                      10.30
                EPTOT = EPTOT + SPCSIG(IS) * SIG2P * ACLOC(ID,IS)         30.72
              ENDDO
            ENDDO
            APTOT = APTOT * FRINTF
            EPTOT = EPTOT * FRINTF
            IF (MSC .GT. 3) THEN                                          10.20
              PPTAIL = PWTAIL(1) - OUTPAR(2)                              40.00
              APTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.61
              PPTAIL = PWTAIL(1) - OUTPAR(2) - 1.                         40.00
              EPTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.61
              DO ID = 1, MDC
*               contribution of tail to total energy density
                AHFR = SIG2P * ACLOC(ID,MSC)                              10.30
                APTOT = APTOT + APTAIL * AHFR
                EHFR = SPCSIG(MSC) * AHFR                                 30.72
                EPTOT = EPTOT + EPTAIL * EHFR
              ENDDO
           ENDIF
           IF (EPTOT.GT.0.) THEN
             TPER = 2.*PI * APTOT / EPTOT
             IF (OQPROC(IVTYP1))
     &              VOQ(IP,VOQR(IVTYP1)) = TPER
             IF (OQPROC(IVTYP2))
     &              VOQ(IP,VOQR(IVTYP2)) = TPER
           ELSE
             IF (OQPROC(IVTYP1))
     &             VOQ(IP,VOQR(IVTYP1)) = OVEXCV(IVTYP1)
             IF (OQPROC(IVTYP2))
     &             VOQ(IP,VOQR(IVTYP2)) = OVEXCV(IVTYP2)
           ENDIF
        ENDIF
*
*       peak period
*
        IVTYPE = 12
        IF (OQPROC(IVTYPE)) THEN
           EMAX = 0.
           ISIGM = -1
           DO IS = 1, MSC
              ETD = 0.
              DO ID = 1, MDC
                ETD = ETD + SPCSIG(IS)*ACLOC(ID,IS)*DDIR                  30.72
              ENDDO
              IF (ETD.GT.EMAX) THEN
                EMAX  = ETD
                ISIGM = IS
              ENDIF
           ENDDO
           IF (ISIGM.GT.0) THEN
             VOQ(IP,VOQR(IVTYPE)) = 2.*PI/SPCSIG(ISIGM)                   30.72
           ELSE
             VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*
*       peak direction
*
        IVTYPE = 14
        IF (OQPROC(IVTYPE)) THEN
           EMAX = 0.
           IDIRM = -1
           DO ID = 1, MDC
              ETF = 0.
              DO IS = 2, MSC
                DS = SPCSIG(IS)-SPCSIG(IS-1)                              30.72
                E1 = SPCSIG(IS-1)*ACLOC(ID,IS-1)                          30.72
                E2 = SPCSIG(IS)*ACLOC(ID,IS)                              30.72
                ETF = ETF + DS * (E1+E2)
              ENDDO
              IF (ETF.GT.EMAX) THEN
                EMAX  = ETF
                IDIRM = ID
              ENDIF
           ENDDO
           IF (IDIRM.GT.0) THEN
C
C            *** Convert (if necessary) from nautical degrees ***         32.01
C            *** to cartesian degrees                         ***         32.01
C
             IF (BNAUT) THEN                                              30.70
               VOQ(IP,VOQR(IVTYPE)) = ANGDEG( SPCDIR(IDIRM,1) )           32.01
             ELSE
               VOQ(IP,VOQR(IVTYPE)) = ANGDEG( (ALCQ + SPCDIR(IDIRM,1)) )  32.01
             ENDIF
             VOQ(IP,VOQR(IVTYPE)) = DEGCNV( VOQ(IP,VOQR(IVTYPE)) )        32.01
C
           ELSE
             VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*
*       mean direction and directional spread
*
        IVTYP1 = 13
        IVTYP2 = 16
        IF (OQPROC(IVTYP1) .OR. OQPROC(IVTYP2)) THEN
           ETOT = 0.
           EEX  = 0.
           EEY  = 0.
           DO 240 ID=1, MDC
              EAD = 0.
              DO 237 IS=2,MSC
                DS=SPCSIG(IS)-SPCSIG(IS-1)                                30.72
                EDI = 0.5*(SPCSIG(IS)*ACLOC(ID,IS)+                       30.72
     &                     SPCSIG(IS-1)*ACLOC(ID,IS-1))*DS                30.72
                EAD = EAD + EDI
  237         CONTINUE
              IF (MSC .GT. 3) THEN                                        10.20
*               contribution of tail to total energy density
                EHFR = ACLOC(ID,MSC) * SPCSIG(MSC)                        30.72
                EAD = EAD + EHFR * SPCSIG(MSC) * EFTAIL                   30.72
              ENDIF
              EAD = EAD * DDIR
              ETOT = ETOT + EAD
              EEX  = EEX + EAD * SPCDIR(ID,2)
              EEY  = EEY + EAD * SPCDIR(ID,3)
  240      CONTINUE
           IF (OQPROC(IVTYP1)) THEN
             IF (ETOT.GT.0.) THEN
               IF (BNAUT) THEN                                            30.70
                 DIRDEG = ATAN2(EEY,EEX) * 180./PI                        10.15
               ELSE
                 DIRDEG = (ALCQ + ATAN2(EEY,EEX)) * 180./PI               10.15
               ENDIF
               IF (DIRDEG.LT.0.) DIRDEG = DIRDEG + 360.                   10.15
C
C              *** Convert (if necessary) from nautical degrees ***       32.01
C              *** to carthesian degrees                        ***       32.01
C
               VOQ(IP,VOQR(IVTYP1)) = DEGCNV( DIRDEG )                    32.01
C
             ELSE
               VOQ(IP,VOQR(IVTYP1)) = OVEXCV(IVTYP1)
             ENDIF
           ENDIF
           IF (OQPROC(IVTYP2)) THEN
             IF (ETOT.GT.0.) THEN
               FF = MIN (1., SQRT(EEX*EEX+EEY*EEY)/ETOT)
               VOQ(IP,VOQR(IVTYP2)) = SQRT(2.-2.*FF) *180./PI
             ELSE
               VOQ(IP,VOQR(IVTYP2)) = OVEXCV(IVTYP2)
             ENDIF
           ENDIF
        ENDIF
*
        IF (BKC.EQ.1) GOTO 800
*
*       compute k and Cg
*
        DEPLOC = VOQ(IP,VOQR(4))
        CALL KSCIP1 (MSC, SPCSIG, DEPLOC, WK, CG, NE, NED)                30.81 30.72
        IF (ITEST.GE.100 .OR. IOUTES .GE. 20) THEN
          WRITE (PRTEST, *) ' Depth: ', DEPLOC
          DO 870 ISC = 1, MIN(MSC,20)
             WRITE (PRTEST, 860) ISC, SPCSIG(ISC), WK(ISC), CG(ISC)       30.72
 860         FORMAT (' i, SPCSIG, sigma, k, cg ', I2, 3(1X, E12.4))
 870      CONTINUE
        ENDIF
*
*       transport direction, and transport vector
*
        IVTYP1 = 15
        IVTYP2 = 19
        IF (OQPROC(IVTYP1) .OR. OQPROC(IVTYP2)) THEN
           CEX = 0.
           CEY = 0.
           ETOT = 0.
           IF (ICUR.EQ.0) THEN
             UXLOC = 0.
             UYLOC = 0.
           ELSE
             UXLOC = VOQ(IP,VOQR(5))
             UYLOC = VOQ(IP,VOQR(5)+1)
           ENDIF
           DO 310 ISIGM = 1, MSC
             IF (ISIGM.EQ.1) THEN
               DSIG = 0.5 * (SPCSIG(2) - SPCSIG(1))                       30.72
             ELSE IF (ISIGM.EQ.MSC) THEN
               DSIG = 0.5 * (SPCSIG(MSC) - SPCSIG(MSC-1))                 30.72
             ELSE
               DSIG = 0.5 * (SPCSIG(ISIGM+1) - SPCSIG(ISIGM-1))           30.72
             ENDIF
             SIG2 = SPCSIG(ISIGM)                                         30.72
             CS   = CG(ISIGM)*SIG2
             DO 307 ID=1,MDC
                CGE = DSIG * CS * ACLOC(ID,ISIGM)
                CEX = CEX + CGE * SPCDIR(ID,2)
                CEY = CEY + CGE * SPCDIR(ID,3)
                IF (ICUR.EQ.1) THEN
                  ETOT = ETOT + DSIG * SIG2 * ACLOC(ID,ISIGM)
                ENDIF
  307        CONTINUE
  310      CONTINUE
           IF (ICUR.EQ.1) THEN
              CEX = CEX + ETOT * UXLOC
              CEY = CEY + ETOT * UYLOC
           ENDIF
*
           IF (OQPROC(IVTYP1)) THEN
              IF (CEX.EQ.0. .AND. CEY.EQ.0.) THEN
                VOQ(IP,VOQR(IVTYP1)) = OVEXCV(IVTYP1)
              ELSE
                IF (BNAUT) THEN                                           30.70
                  DIRDEG = ATAN2(CEY,CEX) * 180./PI                       10.15
                ELSE
                  DIRDEG = (ALCQ + ATAN2(CEY,CEX)) * 180./PI              10.15
                ENDIF
                IF (DIRDEG.LT.0.) DIRDEG = DIRDEG + 360.                  10.15
C
C               *** Convert (if necessary) from nautical degrees ***      32.01
C               *** to carthesian degrees                        ***      32.01
C
                VOQ(IP,VOQR(IVTYP1)) = DEGCNV( DIRDEG )                   32.01
C
              ENDIF
           ENDIF
           IF (OQPROC(IVTYP2)) THEN
              SX = CEX * DDIR
              SY = CEY * DDIR
              IF (INRHOG.EQ.1) THEN
                SX = SX * RHO * GRAV
                SY = SY * RHO * GRAV
              ENDIF
              VOQ(IP,VOQR(IVTYP2))   = COSCQ*SX - SINCQ*SY
              VOQ(IP,VOQR(IVTYP2)+1) = SINCQ*SX + COSCQ*SY
           ENDIF
        ENDIF
*
*       average wave length, and steepness
*
        IVTYP1 = 17
        IVTYP2 = 18
        IF (OQPROC(IVTYP1) .OR. OQPROC(IVTYP2)) THEN
           ETOT  = 0.
           EKTOT = 0.
*          new integration method involving FRINTF                        20.59
           DO IS=1, MSC
              SIG2 = (SPCSIG(IS))**2                                      30.72
              SKK  = SIG2 * (WK(IS))**OUTPAR(3)                           40.00
              DO ID=1,MDC
                ETOT  = ETOT + SIG2 * ACLOC(ID,IS)                        20.59
                EKTOT = EKTOT + SKK * ACLOC(ID,IS)                        20.59
              ENDDO
           ENDDO
           ETOT  = FRINTF * ETOT
           EKTOT = FRINTF * EKTOT
           IF (MSC .GT. 3) THEN                                           10.20
*             contribution of tail to total energy density
              PPTAIL = PWTAIL(1) - 1.                                     20.59
              CETAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.59
              PPTAIL = PWTAIL(1) - 1. - 2.*OUTPAR(3)                      40.00
              IF (PPTAIL.LE.0.) THEN
                CALL MSGERR (2,'error tail computation')
                GOTO 480
              ENDIF
              CKTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.59
              DO ID=1,MDC
                ETOT   = ETOT + CETAIL * SIG2 * ACLOC(ID,MSC)             20.59
                EKTOT  = EKTOT + CKTAIL * SKK * ACLOC(ID,MSC)             20.59
              ENDDO
 480          CONTINUE
           ENDIF
*          IF (ITEST.GE.80) WRITE (PRTEST, 482) ETOT, EKTOT, OUTPAR(3),   40.00
*    &                      CETAIL, CKTAIL, 4.*SQRT(ETOT*DDIR)
*482       FORMAT (' computation average k ', 6(1X,F8.3))
           IF (ETOT.LE.0.) THEN
             IF (OQPROC(IVTYP1)) VOQ(IP,VOQR(IVTYP1)) = OVEXCV(IVTYP1)
             IF (OQPROC(IVTYP2)) VOQ(IP,VOQR(IVTYP2)) = OVEXCV(IVTYP2)
           ELSE
             WLMEAN = PI2 * (ETOT / EKTOT) ** (1./OUTPAR(3))              40.00
             IF (OQPROC(IVTYP1))
     &           VOQ(IP,VOQR(IVTYP1)) = WLMEAN
             IF (OQPROC(IVTYP2))
     &           VOQ(IP,VOQR(IVTYP2)) = 4.* SQRT(ETOT*DDIR) / WLMEAN
           ENDIF
        ENDIF
*
*       average absolute period Tm01                                      40.00
*
        IVTYPE = 11
        IF (ICUR.GT.0 .AND. OQPROC(IVTYPE)) THEN
           ETOT = 0.
           EFTOT = 0.
           UXLOC = VOQ(IP,VOQR(5))
           UYLOC = VOQ(IP,VOQR(5)+1)
           PPTAIL = PWTAIL(1) - 1.                                        40.00
           ETAIL  = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           PPTAIL = PWTAIL(1) - 2.                                        40.00
           EFTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           DO ID=1, MDC
              THETA = SPCDIR(ID,1) + ALCQ                                 20.43
              UXD = UXLOC*COS(THETA) + UYLOC*SIN(THETA)
              DO IS = 1, MSC
                OMEG = SPCSIG(IS) + WK(IS) * UXD                          30.72
                EADD = FRINTF * SPCSIG(IS)**2 * ACLOC(ID,IS)              40.00
                ETOT = ETOT + EADD
                EFTOT = EFTOT + EADD * OMEG                               20.66
              ENDDO
              IF (MSC .GT. 3) THEN                                        10.20
*               contribution of tail to total energy density
                EADD = SPCSIG(MSC)**2 * ACLOC(ID,MSC)                     40.00
                ETOT = ETOT + ETAIL * EADD
                EFTOT = EFTOT + EFTAIL * OMEG * EADD
              ENDIF
           ENDDO
           IF (EFTOT.GT.0.) THEN
              TPER = 2.*PI * ETOT / EFTOT
              VOQ(IP,VOQR(IVTYPE)) = TPER
           ELSE
              VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*       IF (ITEST.GE.100) WRITE (PRTEST, 623) ETOT, ATOT, TPER,
*    &                     OQPROC(IVTYPE), VOQR(IVTYPE), IVTYPE
*623    FORMAT (' aper ', 3(1X,E12.4), 2X,L1, 2I4)
*
*       average absolute period (case with current)                       10.09
*
        IVTYPE = 42                                                       40.00
        IF (ICUR.GT.0 .AND. OQPROC(IVTYPE)) THEN
           ETOT = 0.
           EFTOT = 0.
           UXLOC = VOQ(IP,VOQR(5))
           UYLOC = VOQ(IP,VOQR(5)+1)
           PPTAIL = PWTAIL(1) - OUTPAR(2)                                 40.00
           ETAIL  = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           PPTAIL = PWTAIL(1) - OUTPAR(2) - 1.                            40.00
           EFTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           DO ID=1, MDC
              THETA = SPCDIR(ID,1) + ALCQ                                 20.43
              UXD = UXLOC*COS(THETA) + UYLOC*SIN(THETA)
              DO IS = 1, MSC
                OMEG = SPCSIG(IS) + WK(IS) * UXD                           10.30
                OMEG1P = OMEG ** (OUTPAR(2)-1.)                              10.30
                EADD = OMEG1P * FRINTF * SPCSIG(IS)**2 * ACLOC(ID,IS)      20.66
                ETOT = ETOT + EADD
                EFTOT = EFTOT + EADD * OMEG                               20.66
              ENDDO
              IF (MSC .GT. 3) THEN                                        10.20
*               contribution of tail to total energy density
                EADD = OMEG1P * SPCSIG(MSC)**2 * ACLOC(ID,MSC)
                ETOT = ETOT + ETAIL * EADD
                EFTOT = EFTOT + EFTAIL * OMEG * EADD
              ENDIF
           ENDDO
           IF (EFTOT.GT.0.) THEN
              TPER = 2.*PI * ETOT / EFTOT
              VOQ(IP,VOQR(IVTYPE)) = TPER
           ELSE
              VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*
*       zero-crossing period Tm02                                         20.61
*
        IVTYPE = 32                                                       20.61
        IF (OQPROC(IVTYPE)) THEN
           ETOT  = 0.
           EFTOT = 0.
           IF (ICUR.GT.0) THEN
             UXLOC = VOQ(IP,VOQR(5))
             UYLOC = VOQ(IP,VOQR(5)+1)
           ENDIF
           PPTAIL = PWTAIL(1) - 1.                                        20.61
           ETAIL  = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           PPTAIL = PWTAIL(1) - 3.                                        20.61
           EFTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))           20.61
           DO ID=1, MDC
              IF (ICUR.GT.0) THEN
                THETA = SPCDIR(ID,1) + ALCQ
                UXD   = UXLOC*COS(THETA) + UYLOC*SIN(THETA)
              ENDIF
              DO IS=1,MSC
                EADD  = SPCSIG(IS)**2 * ACLOC(ID,IS) * FRINTF             30.72
                IF (ICUR.GT.0) THEN
                  OMEG  = SPCSIG(IS) + WK(IS) * UXD                       30.72
                  OMEG2 = OMEG**2
                ELSE
                  OMEG2 = SPCSIG(IS)**2                                   30.72
                ENDIF
                ETOT  = ETOT + EADD                                       20.61
                EFTOT = EFTOT + EADD * OMEG2                              20.61
              ENDDO
              IF (MSC .GT. 3) THEN
*               contribution of tail to total energy density
                EADD  = SPCSIG(MSC)**2 * ACLOC(ID,MSC)                    30.72
                ETOT  = ETOT  + ETAIL * EADD                              20.61
                EFTOT = EFTOT + EFTAIL * OMEG2 * EADD                     20.61
              ENDIF
           ENDDO
           IF (EFTOT.GT.0.) THEN
              VOQ(IP,VOQR(IVTYPE)) = 2.*PI * SQRT(ETOT/EFTOT)             20.61
           ELSE
              VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*
*       frequency spectral width (kappa)                                  20.61
*
        IVTYPE = 33                                                       20.61
        IF (OQPROC(IVTYPE)) THEN
           TM02 = VOQ(IP,VOQR(32))
           ETOT  = 0.
           ECTOT = 0.
           ESTOT = 0.
           IF (ICUR.GT.0) THEN
             UXLOC = VOQ(IP,VOQR(5))
             UYLOC = VOQ(IP,VOQR(5)+1)
           ENDIF
           PPTAIL = PWTAIL(1) - 1.
           ECTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))
           DO  ID=1, MDC
             IF (ICUR.GT.0) THEN
               THETA = SPCDIR(ID,1) + ALCQ
               UXD   = UXLOC*COS(THETA) + UYLOC*SIN(THETA)                20.66
             ENDIF
             DO  IS = 1, MSC
               SIG = SPCSIG(IS)                                           30.72
               IF (ICUR.GT.0) THEN
                 OMEG = SIG + WK(IS) * UXD                                20.66
               ELSE
                 OMEG = SIG
               ENDIF
               FND = OMEG * TM02
               COSFND = COS(FND)
               SINFND = SIN(FND)
               EADD   = SIG**2 * ACLOC(ID,IS) * FRINTF                    30.70
               ETOT  = ETOT  + EADD
               ECTOT = ECTOT + COSFND * EADD                              20.66
               ESTOT = ESTOT + SINFND * EADD                              20.66
             ENDDO
             IF (MSC .GT. 3) THEN
*              contribution of tail to total energy density
               EADD  = ECTAIL * SIG**2 * ACLOC(ID,MSC)                    30.70
               ETOT  = ETOT  + EADD
               ECTOT = ECTOT + COSFND * EADD                              20.66
               ESTOT = ESTOT + SINFND * EADD                              20.66
             ENDIF
           ENDDO
           IF (ETOT.GT.0.) THEN
              VOQ(IP,VOQR(IVTYPE)) =
     &                       SQRT(ECTOT*ECTOT+ESTOT*ESTOT) / ETOT
           ELSE
              VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
           ENDIF
        ENDIF
*
        GOTO 800
*
*       points on land: assign exception value
*
 700    DO 730 II = 1, NVOTP
          IVTYPE = IVOTP(II)
          IF (OQPROC(IVTYPE)) THEN
            VOQ(IP,VOQR(IVTYPE)) = OVEXCV(IVTYPE)
            IF (OVSVTY(IVTYPE).EQ.3) THEN
              VOQ(IP,VOQR(IVTYPE)+1) = OVEXCV(IVTYPE)
            ENDIF
          ENDIF
 730    CONTINUE
*
 800  CONTINUE
*
      RETURN
*     end of subroutine SWOEXA
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWOINA (XC, YC, AC2, ACLOC ,KGRPNT, DEPXY)               30.50
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               40.13
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. AUTHORS
*
*     30.72: IJsbrand Haagsma
!     40.13: Nico Booij
*
*  1. Update
*
*     10.10, Aug. 94: separated from subr. SWOEXA
*     30.50,        : If depth on one of the corners is negative value 0
*                     is returned
*     30.72, Sept 97: Replaced DO-block with one CONTINUE to DO-block with
*                     two CONTINUE's
!     40.13, Aug. 01: provision for repeating grid (KREPTX>0)
*
*  2. Purpose
*
*       interpolates local action density ACLOC from array AC2
*
*  4. Argument list
*
*       XC, YC  real   input    comp. grid coordinates
*       AC2     real a input    action densities
*       ACLOC   real a outp     local action density spectrum
*
*  5. SUBROUTINES CALLING
*
*       SWOEXA (SWAN/OUTP)
*
* 10. SOURCE TEXT
*
      REAL     XC, YC, AC2(MDC,MSC,MCGRD), ACLOC(MDC, MSC),               30.21
     &         DEPXY(MCGRD)
C
      INTEGER  KGRPNT(MXC,MYC)                                            30.21
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWOINA')
*
      JX1 = INT(XC+3.) - 2
      JX2 = JX1+1
      SX2 = XC + 1. - FLOAT(JX1)
      SX1 = 1. - SX2
      IF (KREPTX .EQ. 0) THEN                                            40.13
        IF (SX1.LT.0.01 .OR. JX1.EQ.0)   THEN
          SX1 = 0.
          SX2 = 1.
        ENDIF
        IF (SX2.LT.0.01 .OR. JX1.EQ.MXC) THEN
          SX2 = 0.
          SX1 = 1.
        ENDIF
      ELSE                                                               40.13
!       repeating grid                                                   40.13
        JX1 = 1 + MODULO (JX1-1, MXC)                                    40.13
        JX2 = 1 + MODULO (JX2-1, MXC)                                    40.13
      ENDIF                                                              40.13
*
      JY1 = INT(YC+3.) - 2
      JY2 = JY1+1
      SY2 = YC + 1. - FLOAT(JY1)
      SY1 = 1. - SY2
      IF (SY1.LT.0.01 .OR. JY1.EQ.0) THEN
        SY1 = 0.
        SY2 = 1.
      ENDIF
      IF (SY2.LT.0.01 .OR. JY1.EQ.MYC) THEN
        SY2 = 0.
        SY1 = 1.
      ENDIF
*
      IF (ITEST.GE. 150) WRITE (PRTEST, 88) JX1,
     &JX2, JY1, JY2 ,SX1, SX2, SY1, SY2, XC ,YC
  88  FORMAT ('      -------------------SWOINA -------------------  ',/,
     &      '  JX1,JX2,JY1,JY2,  SX1,  SX2,  SY1, SY2,     XC,    YC',/,
     &         4I4,1X, 4(F5.2,1X),2(F8.2,1X))
*
*      *** Using indirect addressing for AC2   ***
*
      DO 91 ISIGM = 1, MSC                                                30.72
        DO 90 ID  = 1, MDC
          ACLOC(ID,ISIGM) = 0.
  90    CONTINUE                                                          30.72
  91  CONTINUE                                                            30.72
C
      IF (SX1.GT.0. .AND. SY1.GT.0.) THEN
        IND1 = KGRPNT(JX1,JY1)                                            30.21
        IF (ITEST.GE. 150) WRITE (PRTEST, 115) IND1,DEPXY(IND1)           26/MAR
 115    FORMAT( ' SWOINA :  POINT   DEPTH  ',I5,E11.4)
        IF (DEPXY(IND1) .LE. DEPMIN) GOTO 890                             40.00
        RFAC = SX1*SY1
        DO 111 ISIGM = 1, MSC                                             30.72
          DO 110 ID  = 1, MDC
            ACLOC(ID,ISIGM) = RFAC * AC2(ID,ISIGM,IND1)
 110      CONTINUE                                                        30.72
 111    CONTINUE                                                          30.72
      ENDIF
*
      IF (SX2.GT.0. .AND. SY1.GT.0.) THEN
        IND2 = KGRPNT(JX2,JY1)                                            30.21
        IF (ITEST.GE. 150) WRITE (PRTEST, 115) IND2,DEPXY(IND2)           26/MAR
        IF (DEPXY(IND2) .LE. DEPMIN) GOTO 890                             40.00
        RFAC = SX2*SY1
        DO 121 ISIGM = 1, MSC                                             30.72
          DO 120 ID = 1, MDC
            ACLOC(ID,ISIGM) = ACLOC(ID,ISIGM) +
     &                        RFAC*AC2(ID,ISIGM,IND2)                     30.21
 120      CONTINUE                                                        30.72
 121    CONTINUE                                                          30.72
      ENDIF
*
      IF (SX2.GT.0. .AND. SY2.GT.0.) THEN
        IND4 = KGRPNT(JX2,JY2)                                            30.21
        IF (ITEST.GE. 150) WRITE (PRTEST, 115) IND4,DEPXY(IND4)           26/MAR
        IF (DEPXY(IND4) .LE. DEPMIN) GOTO 890                             40.00
        RFAC = SX2*SY2
        DO 131 ISIGM = 1, MSC                                             30.72
          DO 130 ID = 1, MDC
            ACLOC(ID,ISIGM) = ACLOC(ID,ISIGM) +
     &                        RFAC*AC2(ID,ISIGM,IND4)
 130      CONTINUE                                                        30.72
 131    CONTINUE                                                          30.72
      ENDIF
*
      IF (SX1.GT.0. .AND. SY2.GT.0.) THEN
        IND3 = KGRPNT(JX1,JY2)                                            30.21
        IF (ITEST.GE. 150) WRITE (PRTEST, 115) IND3,DEPXY(IND3)           26/MAR
        IF (DEPXY(IND3) .LE. DEPMIN) GOTO 890                             40.00
        RFAC = SX1*SY2
        DO 141 ISIGM = 1, MSC                                             30.72
          DO 140 ID = 1, MDC
            ACLOC(ID,ISIGM) = ACLOC(ID,ISIGM) +
     &                        RFAC*AC2(ID,ISIGM,IND3)
 140      CONTINUE                                                        30.72
 141    CONTINUE                                                          30.72
      ENDIF
*
      IF (ITEST .GE. 200) THEN
          WRITE (PRTEST,*) 'AC2 '
        DO 166 ISIGM = 1, MSC
          WRITE (PRTEST, 168) (ACLOC(ID,ISIGM), ID=1,MIN(16,MDC))
 168      FORMAT (1X,16E8.3)
 166    CONTINUE
*       WRITE (PRTEST, 169) (SPCSIG(IS), IS=1, MIN(16,MSC))
*169    FORMAT (' frequencies', /, 1X, 16F7.2)
      ENDIF
      GOTO 900
 890  DO 892 ISIGM = 1, MSC
        DO 891 ID  = 1, MDC                                               30.72
          ACLOC(ID,ISIGM) = 0.
 891    CONTINUE                                                          30.72
 892  CONTINUE
 900  RETURN
*     end of subroutine SWOINA
      END
C
C***********************************************************************
C                                                                      *
      SUBROUTINE SWOEXF (MIP      ,XC       ,YC       ,VOQR     ,
     &                   VOQ      ,AC2      ,DEP2     ,SPCSIG   ,         30.72
     &                   WK       ,CG       ,SPCDIR   ,NE       ,
     &                   NED      ,KGRPNT   ,XCGRID   ,YCGRID             30.72
     &                                                          )
C                                                                      *
C***********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE                                                       30.81
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               40.13
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.80, 40.13: Nico Booij
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.55, Mar. 97: Procedure updated for curvilinear coordinates basics is
C                     described in SWANDOC.WP5 comp. grid point coordinates are
C                     new arguments
C     30.72, Oct. 97: Logical function EQREAL introduced for floating point
C                     comparisons
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.80, Apr. 98: Provision for 1D computation
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
C     30.81, Dec. 98: Implicit none added, force for point surrounded by
C                     dry points set to 0.
!     40.13, Aug. 01: provision for repeating grid (KREPTX>0)
!                     spherical coordinates taken into account
!                     swcomm2.inc reactivated
C
C  2. Purpose
C
C     Calculates wave-driven force (output quantity IVTYPE=20)
C
C  3. Method
C
C     Radiation stresses are defined as:
C                     /
C     Sxx = rho grav | ((N cos^2(theta) + N - 1/2) sig Ac) d sig d theta
C                   /
C                     /
C     Sxy = rho grav | (N sin(theta) cos(theta) sig Ac) d sig d theta
C                   /
C                     /
C     Syy = rho grav | ((N sin^2(theta) + N - 1/2) sig Ac) d sig d theta
C                   /
C
C     The force in x-direction and y-direction are:
C
C     Fx = - (@Sxx/@x + @Sxy/@y)
C     Fy = - (@Sxy/@x + @Syy/@y)
C
C     where @ denotes the partial derivative.
C
C     The value of N and its derivative w.rt. the depth are calculated
C     in the KSCIP1 subroutine.
C
C     First the gradients with respect to i and j (comp. grid counters)
C     are computed, then these are transformed into gradients in (x,y)
C
C  4. Argument variables
C
C     AC2     input  action density
C     CG      local  group velocity in output point
C     DEP2    input  depth at comp. grid points
C     KGRPNT  input  index for indirect adressing
C     MIP     input  number of output points
C     NE      local  ratio of group and phase velocity
C     NED     local  derivative of NE with respect to depth
C     SPCDIR  input  (*,1); spectral directions (radians)                 30.82
C                    (*,2); cosine of spectral directions                 30.82
C                    (*,3); sine of spectral directions                   30.82
C                    (*,4); cosine^2 of spectral directions               30.82
C                    (*,5); cosine*sine of spectral directions            30.82
C                    (*,6); sine^2 of spectral directions                 30.82
C     SPCSIG  input  relative frequencies in computational domain in
C                    sigma-space                                          30.72
C     XC, YC  input  comp. grid coordinates of output point
C     XCGRID  input  coordinates of computational grid in x-direction     30.72
C     YCGRID  input  coordinates of computational grid in y-direction     30.72
C     VOQR    input  location in VOQ of a certain outp quant.
C     VOQ     output values of output quantities
C     WK      local  wavenumber in output point
C
      INTEGER MIP, VOQR(*) ,KGRPNT(MXC,MYC)                               30.21
      REAL    AC2(MDC,MSC,MCGRD), CG(*), DEP2(MCGRD), NE(*), NED(*)
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XC(MIP), YC(MIP)
      REAL    XCGRID(MXC,MYC), YCGRID(MXC,MYC)                            30.72
      REAL    VOQ(MIP,*), WK(*)
      LOGICAL    EQREAL                                                   30.72
C
C  5. Parameter variables
C
C     ---
C
C  6. Local variables
C
C     ACWAVE       Action density in output point
C     ACWI, ACWJ   dAC/dI and dAC/dJ
C     ACWX         X-gradient of local action density
C     ACWY         Y-gradient of local action density
C     DDET         determinant
C     DDI, DDJ     dDEP/dI and dDEP/dJ
C     DDX, DDY     spatial depth gradients
C     DIX, DIY     coefficients for transformation from I-gradient
C                  to (X,Y)-gradients
C     DJX, DJY     coefficients for transformation from J-gradient
C                  to (X,Y)-gradients
C     DS2
C     DXI, DXJ     dX/dI and dX/dJ
C     DYI, DYJ     dY/dI and dY/dJ
C     DEP          depth
C     DEPLOC       local depth
C     FX, FY       (preliminary) forces in X-, and Y-direction
C     FXADD, FYADD Cumulated forces/(RHO*GRAV) per frequency and directi-
C                  onal step in X-, and Y-direction
C     ID           counter for steps in direction
C     IENT         number of entries
C     IND1, IND2,
C     IND3, IND4,
C     IND5, IND6,
C     IND7, IND8,
C     IND9         indirect adresses
C     IP           counter
C     IS           counter for sigma
C     IVTYPE
C     JX           counter in X-direction
C     JXLO, JXUP   lower resp. upper gridpoint number of point under consideration
C                  in X-direction
C     JY           counter in Y-direction
C     JYLO, JYUP   lower resp. upper gridpoint number of point under consideration
C                  in Y-direction
C     NAX, NAY     derivative of N * Ac.dens. = N * E / Sigma, w.r.t. X
C                  or Y, respectively.
C     ONX, ONY     Indicates whether or not a output point lies on a
C                  computational point or not
C     RRDI,RRDJ    multiplication factor: 0.5 in case of two-sided or 1 in case
C                  of one-sided differential
C     SIG          dummy variable
C     SXLO, SXUP   weight coefficients for the lower and upper x-level of the
C                  point under consideration, respectively.
C     SYLO, SYUP   weight coefficients for the lower and upper y-level of the
C                  point under consideration, respectively.
C
      REAL        ACWAV, ACWI, ACWJ, ACWX, ACWY, DDET, DDI, DDJ, DDX,
     &            DDY, DIX, DIY,DJX, DJY, DS2, DXI, DXJ, DYI, DYJ, DEP,
     &            DEPLOC, FX,FY, FXADD, FYADD, NAX, NAY, RRDI, RRDJ,
     &            SIG, SXLO, SXUP, SYLO, SYUP
      INTEGER     ID, IENT, IND1, IND2, IND3, IND4, IND5, IND6, IND7,
     &            IND8, IND9, IP, IS, IVTYPE, JX, JXLO, JXUP, JY,
     &            JYLO, JYUP
      LOGICAL     ONX, ONY
C
C  7. Common Blocks used
C
C     ---
C
C  8. Subroutines used
C
C     STRACE
C     KSCIP1      calculates WK, CG, N and ND
C
C  9. Subroutines calling
C
C     SWOUTP (SWAN/OUTP)
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     -In determining derivatives one-sided differences are used at
C      border meshes; for output points inside a mesh derivative
C      over one step is taken; for output points on a computational
C      grid point a central derivative is taken
C     -A marigin of 0.01 m is taken outside the computational grid.
C     -The range of the counter runs from 1 to MXC; the range of XC(IP) runs
C      from 0 to MXC-1!
C
C  Counter: 1          2          JX        JX+1      JX+2       MXC-1       MXC
C
C         |=|----------|-- -- -- -|--------|=|=|--------|-- -- -- -|----------|=|
C
C  XC:      0          1                     JX                  MXC-2      MXC-1
C
C
C     -Order in which they are treated:
C
C         |=|----------|          |--------|=|=|--------|          |----------|=|
C Order:         A                     B     C      D                    E
C
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     For all output points do
C         Initialize both force components as 0
C         Determine neighbouring points to be used for gradients in
C         X and Y
C         Call KSCIP1 (determine derivative of N with respect to depth)
C         For all spectral components do
C             determine derivative of nE with respect to X
C             determine derivative of nE with respect to Y
C             calculate contribution to force components
C     ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'SWOEXF')
C
      IVTYPE = 20
C
C     loop over all output points
C
      DO 800 IP=1,MIP
        DEP = VOQ(IP,VOQR(4))
        IF (DEP.LE.0.)                  GOTO 700
        IF (EQREAL(DEP,OVEXCV(4)))      GOTO 700                          30.72
        IF (KREPTX .EQ. 0) THEN                                           40.13
          IF (XC(IP).LT.-0.01)            GOTO 700
          IF (XC(IP).GT.REAL(MXC-1)+0.01) GOTO 700
        ENDIF                                                             40.13
        IF (YC(IP).LT.-0.01)            GOTO 700
        IF (YC(IP).GT.REAL(MYC-1)+0.01) GOTO 700
C
C       first the action density spectrum is interpolated
C
        FX  = 0.
        FY  = 0.
        JX  = NINT(XC(IP))
        RRDI = 1.
        ONX = .FALSE.
        IF (KREPTX.EQ.0 .AND. JX.EQ.0) THEN                               40.13
          JXLO = 1
          JXUP = 2
          JX   = 1
          SXUP = XC(IP)
          SXLO = 1.-SXUP
        ELSE IF (KREPTX.EQ.0 .AND. JX.EQ.MXC-1) THEN                      40.13
          JXLO = MXC-1
          JXUP = MXC
          SXLO = REAL(MXC-1)-XC(IP)
          SXUP = 1.-SXLO
          JX   = JX+1                                                     30.81
        ELSE IF (XC(IP).LT.REAL(JX)-0.01) THEN
          JXLO = JX
          JXUP = JX+1
          SXLO = REAL(JX)-XC(IP)
          SXUP = 1.-SXLO
          JX   = JX+1                                                     30.81
        ELSE IF (XC(IP).GT.REAL(JX)+0.01) THEN
          JXLO = JX+1
          JXUP = JX+2
          SXUP = XC(IP)-REAL(JX)
          SXLO = 1.-SXUP
          JX   = JX+1                                                     30.81
        ELSE
          JXLO = JX
          JXUP = JX+2
          RRDI = 0.5
          JX   = JX+1
          ONX  = .TRUE.
        ENDIF
        IF (KREPTX .GT. 0) THEN                                           40.13
          JX   = 1 + MODULO (JX-1, MXC)                                   40.13
          JXLO = 1 + MODULO (JXLO-1, MXC)                                 40.13
          JXUP = 1 + MODULO (JXUP-1, MXC)                                 40.13
        ENDIF                                                             40.13
        IF (ONED) THEN                                                    30.80
          JYLO = 1                                                        30.80
          JYUP = 1                                                        30.80
          JY   = 1                                                        30.80
          RRDJ = 0.                                                       30.80
          ONY  = .TRUE.                                                   30.80
        ELSE                                                              30.80
          JY   = NINT(YC(IP))
          RRDJ = 1.
          ONY  = .FALSE.
          IF (JY.EQ.0) THEN
            JYLO = 1
            JYUP = 2
            JY   = 1
            SYUP = YC(IP)
            SYLO = 1.-SYUP
          ELSE IF (JY.EQ.MYC-1) THEN
            JYLO = MYC-1
            JYUP = MYC
            SYLO = REAL(MYC-1)-YC(IP)
            SYUP = 1.-SYLO
            JY   = JY+1                                                   30.81
          ELSE IF (YC(IP).LT.REAL(JY)-0.01) THEN
            JYLO = JY
            JYUP = JY+1
            SYLO = REAL(JY)-YC(IP)
            SYUP = 1.-SYLO
            JY   = JY+1                                                   30.81
          ELSE IF (YC(IP).GT.REAL(JY)+0.01) THEN
            JYLO = JY+1
            JYUP = JY+2
            SYUP = YC(IP)-REAL(JY)
            SYLO = 1.-SYUP
            JY   = JY+1                                                   30.81
          ELSE
            JYLO = JY
            JYUP = JY+2
            RRDJ = 0.5
            JY  = JY+1
            ONY = .TRUE.
          ENDIF
        ENDIF                                                             30.80
C
C       *** Using indirect addressing for arrays AC2 and DEP2 ***
        IND1 = KGRPNT(JXLO,JYLO)                                          30.21
        IND2 = KGRPNT(JXUP,JYLO)                                          30.21
        IND3 = KGRPNT(JXUP,JYUP)                                          30.21
        IND4 = KGRPNT(JXLO,JYUP)                                          30.21
        IND5 = KGRPNT(JXLO,JY  )                                          30.21
        IND6 = KGRPNT(JXUP,JY  )                                          30.21
        IND7 = KGRPNT(JX  ,JYLO)                                          30.21
        IND8 = KGRPNT(JX  ,JYUP)                                          30.21
        IND9 = KGRPNT(JX  ,JY  )                                          30.21
        IF (ONY) THEN                                                     40.00
          IF (DEP2(IND5).LE.DEPMIN) GOTO 700
          IF (DEP2(IND6).LE.DEPMIN) GOTO 700
        ELSE
          IF (DEP2(IND1).LE.DEPMIN) GOTO 700
          IF (DEP2(IND2).LE.DEPMIN) GOTO 700
          IF (DEP2(IND3).LE.DEPMIN) GOTO 700
          IF (DEP2(IND4).LE.DEPMIN) GOTO 700
        ENDIF
        IF (ONX) THEN                                                     40.00
          IF (DEP2(IND7).LE.DEPMIN) GOTO 700
          IF (DEP2(IND8).LE.DEPMIN) GOTO 700
        ELSE
          IF (DEP2(IND1).LE.DEPMIN) GOTO 700
          IF (DEP2(IND2).LE.DEPMIN) GOTO 700
          IF (DEP2(IND3).LE.DEPMIN) GOTO 700
          IF (DEP2(IND4).LE.DEPMIN) GOTO 700
        ENDIF
C
C       determine depth and (x,y) derivatives w.r.t. i and j
C
        IF (ONY) THEN
          DDI = RRDI * (DEP2(IND6)-DEP2(IND5))
          DXI = RRDI * (XCGRID(JXUP,JY)-XCGRID(JXLO,JY))                  30.72
          DYI = RRDI * (YCGRID(JXUP,JY)-YCGRID(JXLO,JY))                  30.72
        ELSE
          DDI = RRDI * (SYUP*(DEP2(IND3)-DEP2(IND4)) +
     &                  SYLO*(DEP2(IND2)-DEP2(IND1)))
          DXI = RRDI * (SYUP*(XCGRID(JXUP,JYUP)-XCGRID(JXLO,JYUP)) +      30.72
     &                  SYLO*(XCGRID(JXUP,JYLO)-XCGRID(JXLO,JYLO)))       30.72
          DYI = RRDI * (SYUP*(YCGRID(JXUP,JYUP)-YCGRID(JXLO,JYUP)) +      30.72
     &                  SYLO*(YCGRID(JXUP,JYLO)-YCGRID(JXLO,JYLO)))       30.72
        ENDIF
        IF (ONX) THEN
          DDJ = RRDJ * (DEP2(IND8)-DEP2(IND7))
          DXJ = RRDJ * (XCGRID(JX,JYUP)-XCGRID(JX,JYLO))                  30.72
          DYJ = RRDJ * (YCGRID(JX,JYUP)-YCGRID(JX,JYLO))                  30.72
        ELSE
          DDJ = RRDJ * (SXUP*(DEP2(IND3)-DEP2(IND2)) +
     &                  SXLO*(DEP2(IND4)-DEP2(IND1)))
          DXJ = RRDJ * (SXUP*(XCGRID(JXUP,JYUP)-XCGRID(JXUP,JYLO)) +      30.72
     &                  SXLO*(XCGRID(JXLO,JYUP)-XCGRID(JXLO,JYLO)))       30.72
          DYJ = RRDJ * (SXUP*(YCGRID(JXUP,JYUP)-YCGRID(JXUP,JYLO)) +      30.72
     &                  SXLO*(YCGRID(JXLO,JYUP)-YCGRID(JXLO,JYLO)))       30.72
        ENDIF
        IF (KSPHER.GT.0) THEN                                             40.13
!         spherical coordinates are used; first compute cos(latitude)     40.13
          COSLAT(1) = COS(YOFFS+YCGRID(JX,JY))                            40.13
!         LENDEG is the length of one degree N-S                          40.13
          DXI = DXI * LENDEG * COSLAT(1)                                  40.13
          DYI = DYI * LENDEG                                              40.13
          DXJ = DXJ * LENDEG * COSLAT(1)                                  40.13
          DYJ = DYJ * LENDEG                                              40.13
        ENDIF                                                             40.13
C
C       coefficients from transformation from (i,j)-gradients to (x,y)-gradients
C
        IF (JXUP.EQ.JXLO .AND. JYUP.EQ.JYLO) THEN                         30.81
C         point surrounded by dry points                                  30.81
          DIX  = 0.                                                       30.81
          DIY  = 0.                                                       30.81
          DJX  = 0.                                                       30.81
          DJY  = 0.                                                       30.81
        ELSE IF (JXUP.EQ.JXLO) THEN                                       30.80
C         no forces in i-direction                                        30.81
          DS2  = DXJ**2 + DYJ**2                                          30.80
          DIX  = 0.                                                       30.80
          DIY  = 0.                                                       30.80
          DJX  = DXJ/DS2                                                  30.80
          DJY  = DYJ/DS2                                                  30.80
        ELSE IF (JYUP.EQ.JYLO) THEN                                       30.80
C         no forces in j-direction                                        30.81
          DS2  = DXI**2 + DYI**2                                          30.80
          DIX  = DXI/DS2                                                  30.80
          DIY  = DYI/DS2                                                  30.80
          DJX  = 0.                                                       30.80
          DJY  = 0.                                                       30.80
        ELSE                                                              30.80
C         coefficients for transformation from                            30.81
C         (i,j)-gradients to (x,y)-gradients                              30.81
          DDET = DXI*DYJ - DXJ*DYI
          DIX  =  DYJ / DDET
          DIY  = -DXJ / DDET
          DJX  = -DYI / DDET
          DJY  =  DXI / DDET
        ENDIF                                                             30.80
C       spatial depth gradients:
        DDX  = DDI*DIX + DDJ*DJX
        DDY  = DDI*DIY + DDJ*DJY
C
        IF (ITEST.GE.80 .OR. IOUTES .GE. 20) WRITE (PRTEST, 88) IP,
     &  JXLO, JXUP, JYLO, JYUP ,SXLO, SXUP, SYLO, SYUP,
     &  DIX, DIY, DJX, DJY                                                30.80
  88    FORMAT (' SWOEXF ', 5I6, 2X, 4F7.4, 2X, 4E12.4)                   30.80
C
C       compute NE and NED
C
        DEPLOC = VOQ(IP,VOQR(4))
        CALL KSCIP1 (MSC, SPCSIG, DEPLOC, WK, CG, NE, NED)                30.81 30.72
        IF (ITEST.GE.100 .OR. IOUTES .GE. 20) THEN
          WRITE (PRTEST, 98)  DEPLOC, DDX, DDY
  98      FORMAT (' depth & gradient ', 4(1X,F9.4))
          DO 100 IS = 1, MIN(MSC,20)
             WRITE (PRTEST, 99) IS, SPCSIG(IS), NE(IS),                   30.72
     &                          NED(IS)
  99         FORMAT (' i, SPCSIG, N, Nd ', I2, 3(1X, E12.4))              30.72
 100      CONTINUE
        ENDIF
C
        DO 300 ID  = 1, MDC
          DO 290 IS = 1, MSC                                              30.81 18/MAR
            SIG = SPCSIG(IS)                                              30.72
C
C           ACWAV is local action density
C
            IF (ONX.AND.ONY) THEN
               ACWAV = AC2(ID,IS,IND9)
            ELSE IF (ONX) THEN
               ACWAV = SYLO * AC2(ID,IS,IND7) +
     &                 SYUP * AC2(ID,IS,IND8)
            ELSE IF (ONY) THEN
               ACWAV = SXLO * AC2(ID,IS,IND5) +
     &                 SXUP * AC2(ID,IS,IND6)
            ELSE
               ACWAV = SXLO * (SYLO * AC2(ID,IS,IND1) +
     &                         SYUP * AC2(ID,IS,IND4)) +
     &                 SXUP * (SYLO * AC2(ID,IS,IND2) +
     &                         SYUP * AC2(ID,IS,IND3))
            ENDIF
C
C           ACWX is X-gradient of local action density, ACWY is Y-gradient
C
            IF (ONY) THEN
               ACWI = RRDI * (AC2(ID,IS,IND6) -
     &                        AC2(ID,IS,IND5))
            ELSE
               ACWI = RRDI * (SYLO * (AC2(ID,IS,IND2) -
     &                                AC2(ID,IS,IND1)) +
     &                        SYUP * (AC2(ID,IS,IND3) -
     &                                AC2(ID,IS,IND4)))
            ENDIF
            IF (ONX) THEN
               ACWJ = RRDJ * (AC2(ID,IS,IND8) -
     &                        AC2(ID,IS,IND7))
            ELSE
               ACWJ = RRDJ * (SXLO * (AC2(ID,IS,IND4) -
     &                                AC2(ID,IS,IND1)) +
     &                        SXUP * (AC2(ID,IS,IND3) -
     &                                AC2(ID,IS,IND2)))
            ENDIF
C
C           spatial action density gradients:                             30.55
            ACWX = ACWI*DIX + ACWJ*DJX
            ACWY = ACWI*DIY + ACWJ*DJY
C
C           NAX is the derivative of N * Ac.dens.  w.r.t. X
C           So NAX = @(N*Ac)/@X =Ac*@N/@X +N*@Ac/@X
C
C           where @ denotes the partial derivative.
C
C           Further note that that @N/@X = @N/@Depth * @Depth/@X
C                                        = NED * DDX
C
C           Anologously for NAY.
C
            NAX = NE(IS) * ACWX + NED(IS) * DDX * ACWAV
            NAY = NE(IS) * ACWY + NED(IS) * DDY * ACWAV
            FXADD = - ( (SPCDIR(ID,4) + 1.) * NAX - 0.5 * ACWX +          20.44
     &                   SPCDIR(ID,5) * NAY ) * SIG
            FYADD = - ( (SPCDIR(ID,6) + 1.) * NAY - 0.5 * ACWY +          20.44
     &                   SPCDIR(ID,5) * NAX ) * SIG
C
C           integration
C
            FX = FX + SIG * FXADD                                         20.35
            FY = FY + SIG * FYADD                                         20.35
 290      CONTINUE
 300    CONTINUE
C
        FX = RHO * GRAV * FX * DDIR * FRINTF                              20.77
        FY = RHO * GRAV * FY * DDIR * FRINTF                              20.77
        VOQ(IP,VOQR(IVTYPE))   = (COSCQ*FX - SINCQ*FY)
        VOQ(IP,VOQR(IVTYPE)+1) = (SINCQ*FX + COSCQ*FY)
        GOTO 800
C
C       points on land: assign exception value
C
 700    VOQ(IP,VOQR(IVTYPE))   = OVEXCV(IVTYPE)
        VOQ(IP,VOQR(IVTYPE)+1) = OVEXCV(IVTYPE)
C
 800  CONTINUE
C
      RETURN
C     end of subroutine SWOEXF
      END
