!NRL: $Id: swanout2.F,v 1.2.2.1 2003/03/28 17:16:52 dykes Exp $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000    1:58 pm
*
*     SWAN/OUTPUT       file 2 of 3
*
*  Contents of this file:
*     SWBLOK
*     SBLKPT
*     SBLPST
*     SWTABP
*     SWPLOT
*     SWSTAR
*     SPLOER
*     PLOTCG
*     SUHEAD
*     SWSPEC
*     SWCMSP
*
************************************************************************
*                                                                      *
      SUBROUTINE SWBLOK (RTYPE, OREQ, PSNAME, MXK, MYK, VOQR, VOQ)
*                                                                      *
************************************************************************
C
      USE OUTP_DATA                                                       40.13
 
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
!MCEL+ J Dykes 15 Oct 2002 SWBLOK: include
      INCLUDE 'mcel_swan.inc'
!MCEL-
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C     40.03: Nico Booij
C
C  1. UPDATE
C
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is
C                     a reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Nov. 99: NVAR in write statement replaced by OREQ(18)
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
*
*  2. PURPOSE
*
*       Preparing output in the form of a block that is printed by
*         subroutine SBLKPT
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       RTYPE   ch*4   input    type of output request:
*                               'BLKP' for output on paper,
*                               'BLKD' and 'BLKL' for output to datafile
*       OREQ    int    input    array containing current output request
*       PSNAME  ch*8   input    name of outpu frame
*       MXK     int    input    number of grid points in x-direction
*       MYK     int    input    number of grid points in y-direction
*       VOQR
*       VOQ
*
*  5. SUBROUTINES CALLING
*
*       SWOUTP (SWAN/OUTP)
*
*  6. SUBROUTINES USED
*
*       SBLKPT, SCUNIT, SFLFUN (all SWAN/OUTP), TABHED,
*       MSGERR, COPYCH, FOR, Ocean Pack dynamic pool routines
*
      LOGICAL STPNOW                                                      34.01
C
*  7. ERROR MESSAGES
*
*       If the point set is not of the type frame, an error message
*       is printed and control returns to subroutine OUTPUT
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       If output is on paper then
*           Call TABHED to print heading
*       Else
*           Call FOR to open file
*       ----------------------------------------------------------------
*       For each required variable do
*           Determine type of variable and factor of multiplication
*           Call SBLKPT to write block output to printer or datafile
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*                                                                             30.81
      CHARACTER (LEN=8) :: PSNAME       ! name of output locations        40.13
      CHARACTER (LEN=4) :: RTYPE        ! output type                     40.13
      INTEGER   OREQ(*), VOQR(*), IPD
      REAL      VOQ(MXK*MYK,*)
 
      INTEGER, SAVE :: IENT=0                                             40.13
      IF (LTRACE) CALL STRACE (IENT,'SWBLOK')
*
*     **** obtain destination and number of variables from array OUTR ***
      NREF = OREQ(6)                                                      30.00
      IF (RTYPE .EQ. 'BLKP') THEN
*       printer type output with header
        IPD   = 1
        IF (NREF.EQ.PRINTF) CALL TABHED ('SWAN', PRINTF)                  30.20
      ELSE IF (RTYPE .EQ. 'BLKD') THEN
*       output to datafile without header
        IPD = 2
      ELSE
        IPD = 3
      ENDIF
      IF (ITEST.GE.90) WRITE (PRTEST, 21)  RTYPE,NREF, OREQ(18)           40.03
  21  FORMAT (' Test SWBLOK: RTYPE NREF NVAR ',A4,2(1X,I6))
      IF (NREF.EQ.0) THEN
        FILENM = OUTP_FILES(OREQ(7))                                      40.13
        IOSTAT = -1                                                       20.75
        CALL FOR (NREF, FILENM, 'UF', IOSTAT)
        IF (STPNOW()) RETURN                                              34.01
        OREQ(6) = NREF                                                    30.00
      ENDIF
      IDLA = OREQ(17)                                                     30.00
      NVAR = OREQ(18)                                                     30.00
*
      IF (ITEST.GE.90) WRITE (PRTEST, 22)  NREF, FILENM
  22  FORMAT (' Test SWBLOK: NREF FILENM  ', I6, A40)
*
      DO  800  JVAR=1,NVAR
        IVTYPE = OREQ(2*JVAR+17)                                          30.00
        DFAC   = OCREAL(OREQ(2*JVAR+18))                                  30.00
*
        IF (IPD.EQ.1) THEN
          IF (DFAC.LE.0.) THEN
*           determine default factor for print output
            IF (OVHEXP(IVTYPE) .LT. 0.5E10) THEN
              IFAC = INT (10.+LOG10(OVHEXP(IVTYPE))) - 13                 30.20
            ELSE
              IF (OVSVTY(IVTYPE).EQ.1) THEN
                FMAX = 1.E-8
                DO 10 IP = 1, MXK*MYK
                  FTIP = ABS(VOQ(IP,VOQR(IVTYPE)))
                  FMAX = MAX (FMAX, FTIP)
  10            CONTINUE
              ELSE IF (OVSVTY(IVTYPE).EQ.2) THEN
                FMAX = 1000.
              ELSE IF (OVSVTY(IVTYPE).EQ.3) THEN
                FMAX = 1.E-8
                DO 11 IP = 1, MXK*MYK
                  FTIP1 = ABS(VOQ(IP,VOQR(IVTYPE)))
                  FTIP2 = ABS(VOQ(IP,VOQR(IVTYPE)+1))
                  FMAX  = MAX (FMAX, FTIP1, FTIP2)
  11            CONTINUE
              ENDIF
              IFAC = INT (10.+LOG10(FMAX)) - 13
            ENDIF
            DFAC = 10.**IFAC
          ENDIF
        ELSE
          IF (DFAC.LE.0.) DFAC = 1.
        ENDIF
*
        IF (ITEST .GE. 80) WRITE(PRTEST, 6020) JVAR, IVTYPE, DFAC,
     &    COSCQ, SINCQ
 6020   FORMAT(' Test SWBLOK: jvar, ivtype, dfac, coscq, sincq',
     &          2I10,3E12.5)
*
!MCEL+ J Dykes 15 Oct 2002 SWBLOK: put fields with mcel_put
         if (mcel_put_tag(IVTYPE) == 1) then
            if (OVSVTY(IVTYPE) .lt. 3) then
               call mcel_put (VOQ(1, VOQR(IVTYPE)), IVTYPE,
     &            OVSNAM(IVTYPE))
            else
               call mcel_put (VOQ(1, VOQR(IVTYPE)), IVTYPE, 
     &            'U'//OVSNAM(IVTYPE))
               call mcel_put (VOQ(1, VOQR(IVTYPE)+1), IVTYPE,
     &            'V'//OVSNAM(IVTYPE))
            end if
         else
!MCEL-
        IF (OVSVTY(IVTYPE) .LT. 3) THEN
*                      scalar quantities
          CALL SBLKPT(IPD, NREF, DFAC, PSNAME, OVUNIT(IVTYPE),
     &    MXK, MYK, IDLA, OVLNAM(IVTYPE), VOQ(1,VOQR(IVTYPE)))
        ELSE
*                     vectorial quantities
          CALL SBLKPT(IPD, NREF, DFAC, PSNAME, OVUNIT(IVTYPE),
     &    MXK, MYK, IDLA, OVLNAM(IVTYPE)//'X-comp', VOQ(1,VOQR(IVTYPE)))
          CALL SBLKPT(IPD, NREF, DFAC, PSNAME, OVUNIT(IVTYPE),
     &    MXK, MYK, IDLA, OVLNAM(IVTYPE)//'Y-comp',
     &    VOQ(1,VOQR(IVTYPE)+1))
        ENDIF
!MCEL  J Dykes 15 Oct 2002
         end if
!MCEL-
*
  800 CONTINUE
      IF (IPD.EQ.1) WRITE (PRINTF, 6030)
 6030 FORMAT (///)
*
      RETURN
* * end of subroutine SWBLOK *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SBLKPT (IPD, NREF, DFAC, PSNAME, QUNIT,
     &                    MXK, MYK, IDLA, STRING, OQVALS)
*                                                                      *
************************************************************************
 
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'timecomm.inc'                                              30.74
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.82: IJsbrand Haagsma
!     40.13: Nico Booij
C
C  1. Updates
C
C     00.00, Mar. 87: subroutine heading added, some variable names
C                     line numbers changed, layout modified
C     00.04, Feb. 90: lay-out of output changed according to IDLA=1
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.82, Nov. 98: Corrected syntax format statement
!     40.13, July 01: variable formats introduced, using module OUTP_DATA
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
C
C  2. Purpose
C
C     Writing the block output either on paper or to datafile
C
C  3. Method
C
C     ---
C
C  4. PARAMETERLIST
C
C     IPD     INT    input    switch for printing on paper (IPD=1)
C                             or writing to datafile (IPD = 2 or 3)
C     NREF    INT    input    unit reference number of output file
C     DFAC    REAL   input    multiplication factor of block output
C     IVTYPE  INT    input    type of the output quantity
C                             Note: IVTYPE=0 for Y-component of a
C                             vectorial quantity
C     PSNAME  CH*8   input    name of output point set (frame)
C     QUNIT   CH*6   input    physical unit (dimension) of variable
C     MXK     int    input    number of points in x-direction of frame
C     MYK     int    input    number of points in y-direction of frame
C     IDLA    INT    input    controls lay-out of output (see user manual)
C     STRING  CH*(*) input    description of output variable
C
C  8. Subroutines used
C
C       ---
C
C  9. Subroutines calling
C
C       SWBLOK (SWAN/OUTP)
C
C 10. Error messages
C
C       ---
C
C 11. Remarks
C
C       ---
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       If IPD = 1 (output on paper) then
C           If DFAC < 0 (DFAC not given by the user) then
C               Compute maximum value of output variable
C               Compute multiplication factor DFAC
C           ------------------------------------------------------------
C           Print block heading
C           For each IX of the output frame do
C               Print IX and for every IY the value of the outputvariable
C           ------------------------------------------------------------
C       Else
C           If DFAC < 0 then DFAC = 1.
C           Write output variable line by line to datafile
C       ----------------------------------------------------------------
C
C 13. Source text
C
 
      CHARACTER (LEN=20) :: WFORM1 = '(A1, 2X, 151(I6))'                  40.13
      CHARACTER (LEN=20) :: WFORM2 = '(1X,I3,1X, 151(F6.0))'              40.13
      CHARACTER (LEN=20) :: WFORM3 = '(5X, 151(F6.0))'                    40.13
 
      CHARACTER PSNAME*8, STRING*(*), QUNIT*(*)                           40.00
      REAL      DFAC, OQVALS(*)
      INTEGER   NREF, MXK, MYK, IPD
      LOGICAL   BPRN
      SAVE IENT
      DATA IENT /0/
      IF (LTRACE) CALL STRACE (IENT,'SBLKPT')
*
      IF (ITEST.GE.150) WRITE (PRTEST, 10) NREF,IPD,MXK,MYK
  10  FORMAT (' SBLKPT', 4(I6))                                           30.82
*
*
*     divide all output values by the given factor (DFAC)
*
      IF (ABS(DFAC-1.) .GT. 0.001) THEN
        RPDFAC=1./DFAC
        DO 15 IP = 1, MXK*MYK
           OQVALS(IP) = OQVALS(IP)*RPDFAC
   15   CONTINUE
      ENDIF
*
*
*      IFF = VOQR(IVTYPE)
*
      IF (IPD.EQ.1) THEN
*
*       ***** output on paper *****
*
        WRITE (NREF, 20) OUT_COMMENT                                      40.13
        WRITE (NREF, 20) OUT_COMMENT                                      40.13
  20    FORMAT (A)
        WRITE (NREF, 22) OUT_COMMENT, PROJNR, PSNAME, STRING,             40.13
     &                   DFAC, QUNIT                                      40.13
  22    FORMAT (A,' Run:', A4, '  Frame:  ',A8,' **  ',A,', Unit:',       40.13
     &          E12.4, 1X, A)                                             40.13
        IF (NSTATM .GT. 0) THEN
          WRITE (NREF, 24) OUT_COMMENT, CHTIME                            40.13
  24      FORMAT (A,' Time:', A)                                          40.13
        ELSE
          WRITE (NREF, 20) OUT_COMMENT                                    40.13
        ENDIF                                                             40.13
        WRITE (NREF, 20) OUT_COMMENT                                      40.13
 
        ISP = 151                                                         30.21
        DO  31  IXP1 = 1, MXK, ISP                                        30.72
          IXP2 = IXP1+ISP-1
          IF (IXP2.GT.MXK) IXP2=MXK
 
          WRITE (WFORM1(14:14), '(I1)') DEC_BLOCK                         40.13
          WRITE (WFORM2(11:11), '(I1)') DEC_BLOCK                         40.13
          WRITE (WFORM3(17:17), '(I1)') DEC_BLOCK                         40.13
          IF (ITEST.GE.80) WRITE (PRTEST, 25) WFORM1, WFORM2, WFORM3      40.13
  25      FORMAT (' SBLKPT Formats: ', A, /, 17X, A, /, 17X, A)           40.13
 
          WRITE (NREF, 26) OUT_COMMENT                                    40.13
  26      FORMAT (A1,'         X --->')                                   40.13
          WRITE (NREF, 20) OUT_COMMENT                                    40.13
          WRITE (NREF, WFORM1) OUT_COMMENT, (II-1,II=IXP1,IXP2)           40.13
          WRITE (NREF, 99030) OUT_COMMENT                                 40.13
99030     FORMAT (A1, 'Y')                                                40.13
 
          BPRN = .TRUE.
          DO 30 IYK = MYK, 1, -1
            IP = (IYK-1)*MXK
            IF (BPRN) THEN
              WRITE (NREF, WFORM2) IYK-1,
     &        (OQVALS(IP+IXK), IXK=IXP1,IXP2)
            ELSE
              WRITE (NREF, WFORM3)
     &        (OQVALS(IP+IXK), IXK=IXP1,IXP2)
            ENDIF
*!!            BPRN = .NOT. BPRN
   30     CONTINUE                                                        30.72
   31   CONTINUE                                                          30.72
      ELSE
*
*       ***** output to datafile *****
*
        ISP=6
        IF (IDLA.EQ.4) THEN
          WRITE (NREF, FLT_BLOCK) (OQVALS(IP), IP=1, MXK*MYK)             40.13
        ELSE
          DO 50 IYK = 1, MYK                                              13/FEB
            IF (IDLA.EQ.3) THEN
              IP = (IYK-1)*MXK
            ELSE
              IP = (MYK-IYK)*MXK
            ENDIF
            WRITE (NREF, FLT_BLOCK) (OQVALS(IP+IXK), IXK=1,MXK)           40.13
   50     CONTINUE
        ENDIF
      ENDIF
*
      RETURN
* * end of subroutine SBLKPT *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWTABP (RTYPE, OREQ, PSNAME, MIP, VOQR, VOQ)
*                                                                      *
************************************************************************
 
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'timecomm.inc'                                              30.74
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.62: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.80: Nico Booij
C     30.81:  Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     32.01: Roeland Ris & Cor van der Schelde
C     34.01: Jeroen Adema
C     40.00: Nico Booij (Non-stationary boundary conditions)
C     40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     30.50, Sep. 96: option TABI (indexed file) added
C     30.62, Jul. 97: corrected initialisation of table output
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.01, Jan. 98: Extended initialisation of NUMDEC for SETUP
C     30.80, Apr. 98: number of decimals for setup from 2 to 3
C     40.00, June 98: severely revised
C     30.82, Oct. 98: Header information is now also printed in PRINT file
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is
C                     a reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Mar. 00: number of decimals (NUMDEC) is made larger
C     40.13, Jan. 01: program version now written into table heading
C            Mar. 01: XOFFS and YOFFS were incorrectly added to coordinates
C                     (they are already included in VOQ values)
!     40.13, July 01: variable formats introduced, using module OUTP_DATA
!                     comment sign in front of heading lines
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
C
C  2. Purpose
C
C     Printing of output in the form of a table for any type of
C     output point set
C
C  3. Method
C
C     A table is made in which for each point the required output
C     variables are printed in the order given by the user. If more
C     variables are required than one line can contain, writing is
C     continued on the next line before output for the next point is
C     started.
C
C  4. Argument variables
C
C     PSNAME
C i   RTYPE : Type of output request
C             ='TABD'; Output to datafile (no header information)
C             ='TABI'; Indexed output for table in ArcView format
C             ='TABP'; Output to paper (with header information)
C             ='TABS';
C             ='TABT';
C
      CHARACTER RTYPE*4, PSNAME*8
C
C     OREQ
C     MIP
C     VOQR
C
      INTEGER   MIP, OREQ(*), VOQR(*)
C
C     VOQ
C
      REAL      VOQ(MIP,*)
C
C  5. Parameter variables
C
C     MXOUTL
C
      INTEGER MXOUTL
C
      PARAMETER (MXOUTL=360)
C
C  6. Local variables
C
C     NUMDEC
C
      INTEGER NUMDEC
C
C  8. Subroutines used
C
C     SUHEAD (all SWAN/OUTP)
C     COPYCH
C     FOR
C     TABHED (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     OUTPUT (SWAN/OUTP)
C
C 10. ERROR MESSAGES
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       If unit ref. number = 0
C       Then Read filename from array IOUTR
C            Call FOR to open datafile
C            If Rtype = 'TABP' or 'TABI'
C            Then Print heading for required table
C       ----------------------------------------------------------------
C       If Rtype = 'TABS'
C       Then write time into file
C       ----------------------------------------------------------------
C       Make Output line blank
C       Make Linkar = 1
C       If Rtype = 'TABI'
C       Then write index into output line
C            update Linkar
C       ----------------------------------------------------------------
C       For every output point do
C           For all output quantities do
C               Get value fro array VOQ
C               If output quantity is TIME
C               Then make Format='(A18)'
C                    write time into output line
C                    make lfield = 18
C               Else if Rtype = 'TABD'
C                    Then Format = '(E12.4)'
C                         make lfield = 12
C                    Else Format = '(F11.X)'
C                         make lfield = 11
C                         determine number of decimals and write into
C                         Format
C                    ---------------------------------------------------
C                    Write value into output line according to Format
C               --------------------------------------------------------
C               Make Linkar = Linkar + lfield + 1
C           ------------------------------------------------------------
C           Write Output line to file
C       ----------------------------------------------------------------
C
C 13. Source text
C
      CHARACTER FSTR *15                                                  NRL
      CHARACTER OUTLIN *(MXOUTL)
      CHARACTER (LEN=8) :: CRFORM = '(2F12.2)'                            40.03
 
      INTEGER, SAVE :: IENT=0                                             40.13
      IF (LTRACE) CALL STRACE(IENT,'SWTABP')
*
      NREF = OREQ(6)                                                      30.00
      NVAR = OREQ(17)                                                     30.00
C
C     Header information is printed once for each data file and for
C     each entry in this routine when the table is written to the PRINT file
C
      IF (NREF .EQ. 0 .OR. NREF.EQ.PRINTF) THEN                           30.82
        IF (NREF.EQ.0) THEN                                               30.82
          FILENM = OUTP_FILES(OREQ(7))                                    40.13
          IOSTAT = -1                                                     20.75
          CALL FOR (NREF, FILENM, 'UF', IOSTAT)
          IF (STPNOW()) RETURN                                            34.01
          OREQ(6) = NREF                                                  30.00
        END IF                                                            30.82
        IF (RTYPE .NE. 'TABD') THEN
          OUTLIN = '    '
*
*         write heading into file
*
          IF (RTYPE.EQ.'TABP' .OR. RTYPE.EQ.'TABI') THEN
            WRITE (NREF, 20) OUT_COMMENT                                  40.13
            WRITE (NREF, 20) OUT_COMMENT                                  40.13
  20        FORMAT (A)
            WRITE (NREF, 43) OUT_COMMENT, PROJNR, PSNAME, TRIM(VERTXT)    40.13
  43        FORMAT (A1, ' Run:', A4,'  Table:',A8, 10X,                   40.13
     &      'SWAN version:', A)                                           40.13
            WRITE (NREF, 20) OUT_COMMENT                                  40.13
*           write (short) names of output quantities
            IF (RTYPE.EQ.'TABI') THEN
              OUTLIN(1:9) = OUT_COMMENT // '        '                     40.13
              LINKAR = 9
            ELSE
              OUTLIN(1:1) = OUT_COMMENT                                   40.13
              LINKAR = 2                                                  40.13
            ENDIF
            DO  JVAR = 1, NVAR
              IVTYPE = OREQ(17+JVAR)
              IF (IVTYPE.EQ.40) THEN
                LFIELD = 18
              ELSE
                LFIELD = 11
              ENDIF
              IF (OVSVTY(IVTYPE).LE.2) THEN
                OUTLIN(LINKAR:LINKAR+LFIELD) =
     &                '     '//OVSNAM(IVTYPE)//'              '
              ELSE
                OUTLIN(LINKAR:LINKAR+LFIELD) =
     &                '   X-'//OVSNAM(IVTYPE)//'              '
                LINKAR = LINKAR+LFIELD+1
                OUTLIN(LINKAR:LINKAR+LFIELD) =
     &                '   Y-'//OVSNAM(IVTYPE)//'              '
              ENDIF
              LINKAR = LINKAR+LFIELD+1
            ENDDO
            WRITE (NREF, '(A)') OUTLIN(1:LINKAR-1)
*           write units of output quantities
            OUTLIN = '    '
            IF (RTYPE.EQ.'TABI') THEN
              OUTLIN(1:9) = OUT_COMMENT // '        '                     40.13
              LINKAR = 9
            ELSE
              OUTLIN(1:1) = OUT_COMMENT                                   40.13
              LINKAR = 2                                                  40.13
            ENDIF
            DO  JVAR = 1, NVAR
              IVTYPE = OREQ(17+JVAR)
              IF (IVTYPE.EQ.40) THEN
                LFIELD = 18
              ELSE
                LFIELD = 11
              ENDIF
              DO ISTR = LEN(OVUNIT(IVTYPE)), 1, -1
                IF (OVUNIT(IVTYPE)(ISTR:ISTR) .NE. ' ') THEN
                  LSTR = ISTR
                  GOTO 51
                ENDIF
              ENDDO
              LSTR = 1
  51          OUTLIN(LINKAR:LINKAR+LFIELD) =
     &                '     ['//OVUNIT(IVTYPE)(1:LSTR)//']            '
              IF (OVSVTY(IVTYPE).GT.2) THEN
                LINKAR = LINKAR+LFIELD+1
                OUTLIN(LINKAR:LINKAR+LFIELD) =
     &                '     ['//OVUNIT(IVTYPE)(1:LSTR)//']            '
              ENDIF
              LINKAR = LINKAR+LFIELD+1
            ENDDO
            WRITE (NREF, '(A)') OUTLIN(1:LINKAR-1)
            WRITE (NREF, 20) OUT_COMMENT                                  40.13
          ELSE IF (RTYPE.EQ.'TABT' .OR. RTYPE.EQ.'TABS') THEN
            WRITE (NREF, 101) 1
 101        FORMAT ('SWAN', I4, T41, 'Swan standard file, version')
            WRITE (NREF, 111) OUT_COMMENT, VERTXT                         40.13
 111        FORMAT (A1, '   Data produced by SWAN version ', A)           40.13
            WRITE (NREF, 113) OUT_COMMENT, PROJID, PROJNR                 40.13
 113        FORMAT (A1, '   Project: ', A, ';  run number: ', A)          40.13
 102        FORMAT (A, T41, A)
 103        FORMAT (I6, T41, A)
            IF (RTYPE.EQ.'TABT') THEN
              WRITE (NREF,102) 'TABLE'
            ELSE
              IF (NSTATM.EQ.1) THEN
                WRITE (NREF, 102) 'TIME', 'time-dependent data'
                WRITE (NREF, 103) ITMOPT, 'time coding option'
              ENDIF
              IF (KSPHER.EQ.0) THEN                                       33.09
                WRITE (NREF, 102) 'LOCATIONS', 'locations in x-y-space'
                CRFORM = '(2F12.2)'                                       40.03
              ELSE                                                        33.09
                WRITE (NREF, 102) 'LONLAT',
     &                    'locations in spherical coordinates'            33.09
                CRFORM = '(2F12.6)'                                       40.13
              ENDIF                                                       33.09
              WRITE (NREF, 103) MIP, 'number of locations'
              DO 110 IP = 1, MIP
                WRITE (NREF, FMT=CRFORM)                                  40.03
     &                DBLE(VOQ(IP,VOQR(1))), DBLE(VOQ(IP,VOQR(2)))        40.13
 110          CONTINUE
            ENDIF
            WRITE (NREF, 102) 'QUANT', 'description of quantities'
            NKOLS = NVAR
            DO  JVAR = 1, NVAR
              IVTYPE = OREQ(17+JVAR)
              IF (OVSVTY(IVTYPE).GT.2) NKOLS = NKOLS + 1
            ENDDO
            WRITE (NREF, 103) NKOLS, 'number of quantities in table'
            DO  JVAR = 1, NVAR
              IVTYPE = OREQ(17+JVAR)
              IF (OVSVTY(IVTYPE).LE.2) THEN
                WRITE (NREF, 102) OVSNAM(IVTYPE), OVLNAM(IVTYPE)
                WRITE (NREF, 102) OVUNIT(IVTYPE), 'unit'
                WRITE (NREF, 104) OVEXCV(IVTYPE), 'exception value'
 104            FORMAT (E14.4, T41, A)
              ELSE
                WRITE (NREF, 102) 'X-'//OVSNAM(IVTYPE), OVLNAM(IVTYPE)
                WRITE (NREF, 102) OVUNIT(IVTYPE), 'unit'
                WRITE (NREF, 104) OVEXCV(IVTYPE), 'exception value'
                WRITE (NREF, 102) 'Y-'//OVSNAM(IVTYPE)
                WRITE (NREF, 102) OVUNIT(IVTYPE), 'unit'
                WRITE (NREF, 104) OVEXCV(IVTYPE), 'exception value'
              ENDIF
            ENDDO
          ENDIF
        ENDIF
      ENDIF
*
*     ***** printing of the table *****
*
      IF (RTYPE.EQ.'TABS') THEN
        IF (NSTATM.EQ.1) WRITE (NREF, 102) CHTIME, 'date-time'
      ENDIF
      DO 70 IP = 1, MIP
        LINKAR = 1
        OUTLIN = '    '
        IF (RTYPE.EQ.'TABI') THEN
*         write point sequence number as first column
          WRITE (OUTLIN(1:8), '(I8)') IP
          LINKAR = 9
          OUTLIN(LINKAR:LINKAR) = ' '
        ENDIF
        DO 60 JVAR = 1, NVAR
          IVTYPE = OREQ(17+JVAR)                                          30.00
          IF (IVTYPE.EQ.40) THEN                                          40.00
!           For time 18 characters are needed
            FSTR = '(A18)'
            LFIELD = 18
            OUTLIN(LINKAR:LINKAR+LFIELD-1) = CHTIME
          ELSE
            IF (RTYPE.EQ.'TABD') THEN
              FSTR = FLT_TABLE                                            40.13
              LFIELD = FLD_TABLE                                          40.13
            ELSE
              FSTR = '(F11.X)'
              LFIELD = 11
*             NUMDEC is number of decimals in the table for each output quantity
              NUMDEC = MAX (0, 6-NINT(LOG10(ABS(OVHEXP(IVTYPE)))))        40.03
              IF (NUMDEC.GT.9) NUMDEC = 9                                 40.00
              WRITE (FSTR(6:6), '(I1)') NUMDEC                            40.00
            ENDIF
*           write value into OUTLIN
            WRITE (OUTLIN(LINKAR:LINKAR+LFIELD-1), FSTR)
     &             VOQ(IP,VOQR(IVTYPE))
            IF (OVSVTY(IVTYPE).EQ.3) THEN
              LINKAR = LINKAR + LFIELD + 1
*             write second component of a vectorial quantity
              WRITE (OUTLIN(LINKAR:LINKAR+LFIELD-1), FSTR)
     &               VOQ(IP,VOQR(IVTYPE)+1)
            ENDIF
          ENDIF
          LINKAR = LINKAR + LFIELD + 1
          OUTLIN(LINKAR-1:LINKAR) = '  '
  60    CONTINUE
        WRITE (NREF, '(A)') OUTLIN(1:LINKAR-1)
  70  CONTINUE
*
      RETURN
* * end of subroutine SWTABP *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PLOTCG (IXMAX  ,IYMAX  ,IXMIN  ,IYMIN  ,LINCOL ,
     &                   CX    ,CY    ,KGRPNT)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
C     40.02: IJsbrand Haagsma
C
*  1. UPDATE
*
C     40.02, Oct 00: Corrected type in call OPTYPE
*
*  2. PURPOSE
*
*       Plotting the computational grid
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       IXMAX    int   input   max X for which comp. grid is to be plotted
*       IYMAX    int   input   max Y for which comp. grid is to be plotted
*       IXMIN    int   input   min X for which comp. grid is to be plotted
*       IYMIN    int   input   min Y for which comp. grid is to be plotted
*       LINCOL   int   input   line color (pen number) used for plotting
*       CX, CY   real  input   corrdinates of computational grid points
*       KGRPNT   int   input   array grid point indices
*
*  5. SUBROUTINES CALLING
*
*      SWPLOT
*
*  6. SUBROUTINES USED
*
*       PLOTU (all HISWA/SER) and MSGERR (Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER  KGRPNT(MXC,MYC)
      REAL     CX(MXC,MYC) ,CY(MXC,MYC)
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'PLOTCG')
C
      CALL OPTYPE(10, 1.)                                                 40.02
      CALL OPNPEN(LINCOL)
      LINX = IXMAX - IXMIN
      LINY = IYMAX - IYMIN
      JUMPX = LINX/20
      JUMPY = LINY/20
      IF (JUMPX .LT. 1) JUMPX = 1
      IF (JUMPY .LT. 1) JUMPY = 1
      JUMPX = 1
      JUMPY = 1
      IF (ITEST .GE. 150 .OR. IOUTES .GE. 10) THEN
        WRITE(PRINTF,30) IXMIN,IXMAX,IYMIN,IYMAX,JUMPX,JUMPY
      ENDIF
 30   FORMAT (' IN PLOTCG : ',/,
     & 'IXMIN,IXMAX,IYMIN,IYMAX,JUMPX,JUMPY',/,6(1X,I5))
 35   FORMAT('IX,IY,XP,YP,KGRPNT :',2(1X,I5),2(1X,F10.2),1X,I5)
C
      DO 10 IY = IYMIN, IYMAX ,JUMPY
        DO 15 IX = IXMIN ,IXMAX ,JUMPX
          XP = CX(IX,IY)
          YP = CY(IX,IY)
          IF (IOUTES .GE. 50) WRITE(PRINTF,35)
     &      IX ,IY ,XP ,YP ,KGRPNT(IX,IY)
          IF (KGRPNT(IX,IY) .EQ. 1 .OR. IX .EQ. IXMIN) THEN
            CALL PLOTU(XP ,YP ,'UP')
          ELSE IF (IX .GT. IXMIN .AND. KGRPNT(IX-1,IY) .EQ. 1) THEN
            CALL PLOTU(XP ,YP ,'UP')
          ELSE
            CALL PLOTU(XP ,YP ,'DOWN')
          ENDIF
 15     CONTINUE
 10   CONTINUE
      DO 20 IX = IXMIN ,IXMAX ,JUMPX
        DO 25 IY = IYMIN ,IYMAX ,JUMPY
          XP = CX(IX,IY)
          YP = CY(IX,IY)
          IF (KGRPNT(IX,IY) .EQ. 1 .OR. IY .EQ. IYMIN) THEN
            CALL PLOTU(XP ,YP ,'UP')
          ELSE IF (IY .GT. IYMIN .AND. KGRPNT(IX,IY-1) .EQ. 1) THEN
            CALL PLOTU(XP ,YP ,'UP')
          ELSE
            CALL PLOTU(XP ,YP ,'DOWN')
          ENDIF
 25     CONTINUE
 20   CONTINUE
      RETURN
      END
************************************************************************
*                                                                      *
      CHARACTER *8 FUNCTION SUHEAD (QUNIT)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  1. UPDATE
*
*        3 JAN 1990 : 0.0, first draft
*
*  2. PURPOSE
*
*       Preparation of unit for the table print output
*       in the form:   [unit]
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       QUNIT   CH*(*) input    unit of the variable to be printed
*                               in the table headings
*
*  5. SUBROUTINES CALLING
*
*       SWTABP (SWAN/OUTP)
*
*  6. SUBROUTINES USED
*
*       none
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ---
*
* 10. SOURCE TEXT
*
      CHARACTER QUNIT *(*), TEXT1 *6, TEXT2 *8
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SUHEAD')
*
      TEXT2 = '        '
*      L = LEN (QUNIT)
*      IF (L.EQ.0 .OR. L.GT.6) THEN
*        IF (ITEST.GE.10) WRITE(PRINTF,9910) L
* 9910   FORMAT(' ** Error SUHEAD, length of unit in heading =', i2,
*     &        ' out of range')
*      ENDIF
      TEXT1 = QUNIT(1:6)
C     determine the position of the last non-blank character
      DO 10 I = 6,1,-1
        IF (TEXT1(I:I).NE.' ') GOTO 20
 10   CONTINUE
 20   IEND = I
      IF (IEND.EQ.0) THEN
        TEXT1 = '-'
        IEND = 1
      ENDIF
C     shift the unit-string one position to the right
      DO 30 I=1,IEND
        J = I+1
        TEXT2(J:J) = TEXT1(I:I)
 30   CONTINUE
C     enclose the unit by brackets
      TEXT2(1:1) = '['
      TEXT2(IEND+2:IEND+2) = ']'
      SUHEAD = TEXT2
*
 100  RETURN
*     end of subroutine SUHEAD
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWPLOT (OREQ, MXK, MYK, PPNAME, VOQR, VOQ, ORER ,        30.21
     &                   PLACES, PLACER, CLINES, CLINER, PSDATA  ,        40.02
     &                   OUTPR , XCGRID, YCGRID,                          40.02
     &                   KGRPNT, KGRBND, I_VOQ                       )    40.02
*                                                                      *
************************************************************************
C
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm1.inc'                                              30.74
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.81: Annette Kieftenburg
C     32.01: Roeland Ris & Cor van der Schelde
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
C
C  1. Updates
C
C     00.00, Mar. 87: heading added, general overhaul
C     00.01, Dec. 89: call of subr. OCPISO made conditional
C     30.60, May  97: modif data for PLOTCG
C     30.72, Oct. 97: logical function EQREAL introduced for floating point
C                     comparisons
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.01, Jan. 98: Introduced nautical convention (project h3268)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, June 98: argument KGRBND added, call CVMESH modified
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is
C                     a reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Aug. 00: format for plotting coordinates is modified
C     40.02, Sep. 00: Introduced several real equivalents of arrays
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
C
C  2. Purpose
C
C     Preparing to plotting contourlines and vector patterns
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     CLINER: Real equivalence of CLINES                                  40.02
C     I_VOQ : Integer equivalence of VOQ                                  40.02
C     OUTPR : Real equivalence of PSDATA                                  40.02
C     PLACER: Real equivalence of PLACES                                  40.02
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      INTEGER          :: I_VOQ(MXK*MYK,*)                                40.02
 
      REAL             :: CLINER(*), OUTPR(*), PLACER(*)                  40.02
      REAL, INTENT(IN) :: XCGRID(MXC,MYC), YCGRID(MXC,MYC)                30.72
C
C     OREQ      int  inp   array containing output requests
C     MXK, MYK  int  inp   number of grid points of output frame
C     PPNAME    int  inp   output frame
C     VOQR      int  inp   gives location in array VOQ where to find a var.
C     VOQ       real inp   values of variables for all output points
C     PLACES    int  inp   data on town and region names
C     CLINES    int  inp   data on (coast)lines
C     PSDATA    int  inp   data on output point sets
C
C  8. Subroutines used
C
C     DEGCNV: Transforms dir. from nautical to cartesian or vice versa    32.01
C     ANGDEG: Transforms degrees to radians                               32.01
C     ANGRAD: Transforms radians to degrees                               32.01
C     SCUNIT (all SWAN/OUTP)
C     PNAMES
C     PCOAST (both SWAN/SER)
C     MSGERR
C     ADPOOL
C     OPFRAM
C     OCPSCH
C     OCPSUB
C     OCPISO
C     OCPVEC
C     LASPLO (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     OUTPUT (SWAN/OUTP)
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Obtain plot title from array IOUTR
C     Call ADPOOL to enlarge arrays IXP and IYP
C     Compute user coordinates of all output points
C     Call OPFRAM to plot window and plot title
C     Call OCPSCH to determine length scale
C     Call OCPSUB to plot length scale of the plot
C     Determine the type of variable IVTYPE for the contour plot
C     If IVTYPE is not 0 then
C         Determine for the contour plot the interval of the contour-
C           lines and the minimum and maximum function values
C         Call ADPOOL to enlarge array IAUX1
C         For all output points do
C             Compute the required output variable and store in IAUX1
C         ------------------------------------------------------------
C         If interval between the contourlines is not given, then
C             Compute minimum and maximum function value and interval
C               between contourlines
C             Call OCPSCH to determine the contourline interval from
C               minimum and maximum function values
C         ------------------------------------------------------------
C         Call SCUNIT to determine dimension of the variable
C         Call OCPSUB to write interval of contourlines in plot
C         Call ADPOOL to enlage array IAUX2
C         Call OCPISO to make contourplot of the variable
C         Call ADPOOL to reduce auxilliary arrays IAUX1, IAUX2,
C                                                 IAUX3, IAUX4
C     ----------------------------------------------------------------
C     Determine variable for vector plot: IVTYPE
C     If OVSVTY(IVTYPE) = 3 (vector variables), then
C         Read scale of vectors USC and distance between vectors IDIST
C         Call ADPOOL to enlarge auxilliary arrays IAUX1 and IAUX2
C         For every output point do
C             Compute components of required output variable and store
C               in arrays IAUX1 and IAUX2
C         ------------------------------------------------------------
C         If IVTYPE = 17 (direction of energy transport), then
C             Compute the vector scale according the mesh of the frame
C         ------------------------------------------------------------
C         Else
C             If USC = 0 (vector scale is not given by user), then
C                 Compute maximum vector length
C                 Call OCPSCH to determine the vectorscale
C                 Call SCUNIT to determine the dimension of variable
C                 Call OCPSUB to draw vector scale in the plot
C         ------------------------------------------------------------
C         Call OCPVEC to make the vector plot of the variable
C         Call ADPOOL to reduce arrays IAUX1 and IAUX2
C     ----------------------------------------------------------------
C     If IPLAC = 1, then
C         Call PNAMES to plot names of places and/or regions
C     ----------------------------------------------------------------
C     If ILINS = 1, then
C         Call PCOAST to plot lines defined by the user
C     ----------------------------------------------------------------
C     Call LASPLO to terminate plot output
C     Call ADPOOL to reduce arrays IFOP and INF
C     ----------------------------------------------------------------
C
C 13. Source text
C
      REAL      VOQ(MXK*MYK,*) ,
     &          ORER(*)
      INTEGER   VOQR(*), OREQ(*), CLINES(*), PLACES(*), PSDATA(*),
     &          FROPT ,KGRPNT(MXC,MYC), KGRBND(*)                         40.00
      CHARACTER PTI *36, PPNAME *8, PSNAME *8, CPOS *4, FROM_, STRNG *10  30.81 30.50
      CHARACTER (LEN=7) :: CRFORM = '(F10.0)'  ! format for coordinates   40.03
      LOGICAL   EQREAL                                                    30.72
      DIMENSION IDUMMY(1)
      SAVE IENT, FROM_                                                    30.81
      DATA IENT /0/, FROM_ /'F'/                                          30.81
      IF (LTRACE) CALL STRACE (IENT,'SWPLOT')
*
      IF (ITEST .GE. 100 .OR. IOUTES .GE. 5) THEN
        WRITE(PRINTF,20) OREQ(28), OREQ(32) , OREQ(35), OREQ(36),
     &  OREQ(37), OREQ(40),
     &  ORER(41), ORER(42), ORER(43), ORER(44), OREQ(45)
 20     FORMAT ('SWPLOT : OREQ(28) ,OREQ(32) ,OREQ(35) ,OREQ(36)',
     &                  ' ,OREQ(37) ,OREQ(40),ORER(41)',
     &                  ' ,ORER(42) ,ORER(43) ,ORER(44),OREQ(45)',
     &                   /, 3X, 6(6X,I4), 4(1X,F9.2), 3X, I3)
      ENDIF
*
      IF (ITEST.GT.0) CALL TABHED ('SWAN', PRINTF)
*
      MIP   = MXK*MYK
*
*     ***** obtain name of plotfile *****
      IERR = -1
      FILENM = OUTP_FILES(OREQ(7))                                        40.13
*     ***** obtain plot title from array *****
      CALL COPYCH (PTI, FROM_, OREQ(18), 10, IERR)                        30.81 30.00
*
      IF (ITEST.GE. 50 .OR. IOUTES .GE. 10) WRITE (PRINTF,62)
     &                                      PTI, FILENM, PPNAME
  62  FORMAT (//,' Isoline and vector plot',/, ' title: ', A36,
     &  /, ' filenm:',A36, ' frame:', A8)
*
*     ***** start of plot output, window and title are drawn *****
*
*     if necessary keep margin to plot coordinates                        30.50
*
      ICOORD = OREQ(32)
      PMARG  = ORER(33)
      SYMSZ  = PMARG / 7.
      XASL = HORSC*XQLEN + PMARG
      YASL = VRTSC*YQLEN + PMARG
      FROPT = PFROPT
      CALL OPFRAM (FROPT, PTI)
      IF (STPNOW()) RETURN                                                34.01
      IF (ICOORD.GT.0) THEN
        XPLO = XPLO+PMARG
        YPLO = YPLO+PMARG
        CALL OPPLOT(XPLO,YPHI,'UP')
        CALL OPPLOT(XPLO,YPLO,'DOWN')
        CALL OPPLOT(XPHI,YPLO,'DOWN')
        DDC1 = (XQLEN+YQLEN) / 8.
*       make DDC2 a rounded value of DDC1
        IF (ABS(DDC1) .LT. 1.E-6) THEN
          CALL MSGERR (2, 'Frame length unknown; plot no coordinates')    40.03
          DDC2 = 1.
        ELSE
          CALL OCPSCH (DDC1, DDC2)
        ENDIF
        IF (DDC2.LT.0.1) THEN
          CRFORM = '(F10.3)'                                              40.03
        ELSE IF (DDC2.LT.1.0) THEN
          CRFORM = '(F10.2)'                                              40.03
        ELSE
          CRFORM = '(F10.0)'
        ENDIF
*       plot X-coordinates
        ICD1 = NINT ((XPQ+XOFFS)/DDC2)
        IF ((ICD1+0.001)*DDC2-XOFFS .LT. XPQ) ICD1=ICD1+1
        ICD2 = NINT ((XPQ+XQLEN+XOFFS)/DDC2)
        IF ((ICD2-0.001)*DDC2-XOFFS .GT. XPQ+XQLEN) ICD2=ICD2-1
        DO IX = ICD1, ICD2
          XT = XPLO + HORSC * (IX*DDC2-XPQ-XOFFS)
          YT = YPLO
          CALL OPPLOT (XT, YT, 'UP')
          YT = YPLO - 0.5 * SYMSZ
          CALL OPPLOT (XT, YT, 'DOWN')
          WRITE (STRNG, FMT=CRFORM) IX*DDC2                               40.03
          CALL OPTEXT (XT - 5.66*SYMSZ, YT - 7.1*SYMSZ, SYMSZ,
     &                 STRNG(1:9), 45., 9)
        ENDDO
*       plot Y-coordinates
        ICD1 = NINT ((YPQ+YOFFS)/DDC2)
        IF ((ICD1+0.001)*DDC2-YOFFS .LT. YPQ) ICD1=ICD1+1
        ICD2 = NINT ((YPQ+YQLEN+YOFFS)/DDC2)
        IF ((ICD2-0.001)*DDC2-YOFFS .GT. YPQ+YQLEN) ICD2=ICD2-1
        DO IY = ICD1, ICD2
          YT = YPLO + VRTSC * (IY*DDC2-YPQ-YOFFS)
          XT = XPLO
          CALL OPPLOT (XT, YT, 'UP')
          XT = XPLO - 0.5 * SYMSZ
          CALL OPPLOT (XT, YT, 'DOWN')
          WRITE (STRNG, FMT=CRFORM) IY*DDC2                               40.03
          CALL OPTEXT (XT - 6.33*SYMSZ, YT - 6.36*SYMSZ, SYMSZ,
     &                 STRNG(1:9), 45., 9)
        ENDDO
      ENDIF
      if (abs(symsiz) .lt. 1.e-6) then
        write (printf, *) ' symsiz unknown'
        symsiz = 0.25
      endif
      CALL OCPSCH (4.*SYMSIZ/HORSC, RLL)
      CALL OCPSUB ('LENS', HORSC, RLL, OVUNIT(1))                         40.03
      IF (ITEST.GE. 80 .OR. IOUTES .GE. 10) WRITE (PRTEST, 12)
     &                 XQP, YQP, XQLEN ,YQLEN ,
     &                 ALPQ/DEGRAD, HORSC, RLL ,XASL ,YASL
  12  FORMAT (' SWPLOT:',/,'         XQP,      YQP,     XQLEN ,',
     &        '    YQLEN      ,ALPQ/DEGRAD   HORSC,      RLL ,',
     &        '        XASL,       YASL ',/,1X,9E12.4)
*
*     *** computational grid plot ***   VERSION 30.21
      IVTYPE = OREQ(40)
      IF (IVTYPE .NE. 0) THEN
        WRITE (PRTEST,*) ' SWPLOT : plotting comput. grid'
C
        IF (IVTYPE .EQ. 3) THEN
          XMAX   = ORER(41)
          YMAX   = ORER(42)
          XMIN   = ORER(43)
          YMIN   = ORER(44)
          LINCOL = OREQ(45)
          IXMAX   = INT(XMAX + 1.)                                        30.60
          IYMAX   = INT(YMAX + 1.)                                        30.60
          IXMIN   = INT(XMIN + 1.)                                        30.60
          IYMIN   = INT(YMIN + 1.)                                        30.60
        ELSE IF (IVTYPE .EQ. 1) THEN
          XLEK   = ORER(41)
          YLEK   = ORER(42)
          XORK   = ORER(43)
          YORK   = ORER(44)
          XPMX   = XORK + XLEK
          YPMX   = YORK + YLEK
          LINCOL = OREQ(45)
*           *** If computational grid is regular ***
            CALL CVMESH (XPMX           ,YPMX           ,XMAX ,
     &                   YMAX           ,KGRPNT         ,XCGRID  ,
     &                   YCGRID         ,KGRBND                 )         40.00
            CALL CVMESH (XORK           ,YORK           ,XMIN ,
     &                   YMIN           ,KGRPNT         ,XCGRID  ,
     &                   YCGRID         ,KGRBND                 )         40.00
          IXMAX   = MXC                                                   30.60
          IYMAX   = MYC                                                   30.60
          IXMIN   = 1                                                     30.60
          IYMIN   = 1                                                     30.60
        ENDIF
C
        CALL PLOTCG(IXMAX  ,IYMAX  ,IXMIN ,IYMIN  ,LINCOL ,
     &              XCGRID ,YCGRID ,KGRPNT)                               30.72
      ENDIF
*
*     ***** contour plot *****
      IVTYPE = OREQ(28)                                                   30.00
      IF (IVTYPE .NE. 0) THEN
        FSTEP =  OCREAL(OREQ(29))                                         30.00
        FMIN  =  OCREAL(OREQ(30))                                         30.00
        FMAX  =  OCREAL(OREQ(31))                                         30.00
*
        IF (FSTEP.LE.0.) THEN
          RR = 0.
          RMIN = 1.E10
          RMAX = -1.E10
          DO 40 IP = 1, MIP
            RR   = VOQ(IP,VOQR(IVTYPE))
            IF (.NOT.EQREAL(RR,OVEXCV(IVTYPE))) THEN                      30.72
              RMIN = MIN(RMIN,RR)
              RMAX = MAX(RMAX,RR)
            ENDIF
   40     CONTINUE
          RMAX = MIN (OVHEXP(IVTYPE), RMAX)
          RMIN = MAX (OVLEXP(IVTYPE), RMIN)
          RSTEP = MAX (0.1*(RMAX-RMIN),
     &            0.001*(OVHEXP(IVTYPE)-OVLEXP(IVTYPE)))
          IF (ABS(RSTEP).LT.1.E-8) THEN
            WRITE (PRTEST, 43) OVSNAM(IVTYPE), RMIN, RMAX
  43        FORMAT (' Zero step ', A4, 2X, 2E12.4)
            FSTEP = 1.
          ELSE
            CALL OCPSCH (RSTEP, FSTEP)
          ENDIF
          IF (FMAX .GT. 1.E10) FMAX = FSTEP*(INT(RMAX/FSTEP)+1)
          IF (FMIN .GT. 1.E10) FMIN = FSTEP*(INT(RMIN/FSTEP)-1)
        ENDIF
*
*       ***** test *****
        IF (ITEST .GE. 50 .OR. IOUTES .GE. 5) THEN
          WRITE (PRTEST, 6030) PPNAME, IVTYPE, RMIN, RMAX, RSTEP, FSTEP,
     &      FMIN, FMAX
 6030     FORMAT (/,' SWPLOT, contour plot for :',/,'PPNAME, IVTYPE,',
     &              '   RMIN,       RMAX,       RSTEP,       FSTEP,',
     &              '    FMIN,       FMAX',/, A8, I6, 10E12.4)
        ENDIF
*
        CALL OCPSUB ('DELT', CF, FSTEP, OVUNIT(IVTYPE))
        IF (IVTYPE .EQ. 4) THEN
          CPOS = BLANK
        ELSE
          CPOS = 'POS'
        ENDIF
        IF (FSTEP.GT.1.E-10) THEN
          CALL OCPISO (CPOS, 0, 0, IDUMMY(1), VOQ(1,VOQR(IVTYPE)),
     &                 FMIN, FSTEP, FMAX, CF, I_VOQ(1,VOQR(23)))          40.02
        ENDIF
*
      ENDIF
      IF (OREQ(34).EQ.1) THEN
*
*       ***** vector plot *****
        IVTYPE = OREQ(35)                                                 30.50
        IF (IVTYPE.EQ.0) CALL MSGERR (2, 'illegal vector type')
        IF (ITEST.GE.60 .OR. IOUTES .GE. 10) WRITE (PRTEST, 233)
     &             IVTYPE, VOQR(IVTYPE), OVSVTY(IVTYPE), OREQ(37)         30.00
 233    FORMAT (' vector plot, type: ', 7I8)
        IFF    = VOQR(IVTYPE)
        IF (OVSVTY(IVTYPE) .LE. 3) THEN
          USC   = ORER(36)                                                30.50
          IDIST = OREQ(37)                                                30.50
*
*         ***** computation of vector components *****
          IF (OVSVTY(IVTYPE) .EQ. 2) THEN
*
*           ***** computation of vector scale *****
            USCALE = 0.6 * IDIST * MIN (HORSC*DXK, VRTSC*DYK)             33.09
            IF (USC .LT. 0.) THEN
              USC = USCALE
            ELSE
              USC = USC * USCALE
            ENDIF
          ELSE
            IF (USC.LE.0.) THEN
              VXMAX = 1.E-10
              VYMAX = 1.E-10
              DO 60 IP=1, MIP
                VXMAX = MAX (VXMAX, ABS(VOQ(IP,IFF)))                     10.14
                VYMAX = MAX (VYMAX, ABS(VOQ(IP,IFF+1)))                   10.14
   60         CONTINUE
              USCALE = MIN (IDIST*HORSC*DXK/VXMAX,
     &                      IDIST*VRTSC*DYK/VYMAX)                        33.09
              CALL OCPSCH (USCALE, USC)
            ENDIF
            CALL OCPSUB ('AROW', USC, QR, OVUNIT(IVTYPE))
          ENDIF
*
*         ***** test *****
          IF (ITEST .GE. 50 .OR. IOUTES .GE. 10) THEN
            WRITE (PRTEST, 6040) PPNAME, IVTYPE, VXMAX, VYMAX, USCALE,
     &                           USC, COSCQ, SINCQ
 6040       FORMAT (' SWPLOT, vector plot for  ', A8, ' type ', I6, /,
     &               9X, 10E12.4)
          ENDIF
*
*          SYMSIZ = 0.02     deleted, function unclear
*
*          DO 100 IY = 2, MYK-1, IDIST                modified
          DO 100 IY = 1+IDIST, MYK-IDIST, IDIST                           30.50
            KJ = (IY-1)*MXK
            YT = YPLO + (IY-1)*DYQ * VRTSC
            IF (YT.GT.YPLO .AND. YT.LT.YPHI) THEN
              DO 90 IX = 1+IDIST, MXK-IDIST, IDIST
                IP = KJ + IX
                XT = XPLO + (IX-1)*DXQ * HORSC
                IF (XT.LE.XPLO .OR. XT.GE.XPHI) GOTO 90
                IF (OVSVTY(IVTYPE).EQ.2) THEN
                  FF = VOQ(IP,IFF)
                  IF (FF.GT.-.9E10 .AND.                                  30.72
     &                .NOT.EQREAL(FF,OVEXCV(IVTYPE))) THEN                30.72
                    IF (BNAUT) THEN                                       40.00
C                     Introduce nautical convention
                      ANGL = (180.+DNORTH-FF) * PI/180. - ALPQ            40.00
                    ELSE                                                  40.00
                      ANGL = FF * PI /180.
                    ENDIF                                                 40.00
                    VX = USC * COS(ANGL)
                    VY = USC * SIN(ANGL)
                    VV = 1.
                  ELSE
                    VV = 0.
                  ENDIF
                ELSE
                  VX = USC * VOQ(IP,IFF)
                  VY = USC * VOQ(IP,IFF+1)
                  VV = ABS(VX) + ABS(VY)
                ENDIF
                IF (VV.GT.0.01) THEN
C                 plot small circle at origin of vector
                  CALL PLOTP (XT, YT, 'UP')
                  CALL PLOTP (XT, YT, 'DOWN')
C/D                  CALL PSYM (XT, YT, 0.05*VV, 1, 'DOWN')
                  XQ = XT + VX
                  YQ = YT + VY
C                 plot vector
                  CALL PLOTP (XQ, YQ, 'DOWN')
C                 plot arrowhead
                  XS = XQ - .15*VX + .07*VY
                  YS = YQ - .15*VY - .07*VX
                  CALL PLOTP (XS, YS, 'DOWN')
                  XS = XQ - .15*VX - .07*VY
                  YS = YQ - .15*VY + .07*VX
                  CALL PLOTP (XS, YS, 'DOWN')
                  CALL PLOTP (XQ, YQ, 'DOWN')
                ENDIF
                IF (ITEST.GE.130 .OR. IOUTES .GE. 20)
     &                WRITE (PRTEST, 88) IX, IY,
     &                VOQ(IP,IFF), VV, VX, VY, XT, YT
  88            FORMAT (' vector ', 2I4, 6(1X,E12.4))
  90          CONTINUE
            ENDIF
 100      CONTINUE
*          CALL OCPVEC (USC, POOL(IAUX1+1), POOL(IAUX2+1), BLANK,
*     &      0, IDUMMY(1), IDIST)
*
        ENDIF
 
      ENDIF
C
*     ***** plot names and lines if requested *****
      IF (ITEST.GE.60 .OR. IOUTES .GE. 10) WRITE (PRTEST, 333)
     &    OREQ(46), OREQ(47), OREQ(48)                                    30.00
 333  FORMAT (' additional plot, types: ', 3I8)
      IF (OREQ(46).GE.1) THEN                                             30.00
*       plot site names
        CALL OPNPEN (OREQ(46))                                            30.00
        CALL PNAMES (PLACES, PLACER)                                      40.02
        CALL OPNPEN (1)
      ENDIF
      IF (OREQ(47).GE.1) THEN                                             30.00
*       plot coastlines
        CALL OPNPEN (OREQ(47))                                            30.00
        CALL PCOAST (CLINES, CLINER)                                      40.02
        CALL OPNPEN (1)
      ENDIF
      IF (OREQ(48).GE.1) THEN                                             30.00
*       plot output locations
        IERR = 0
        CALL COPYCH (PSNAME, FROM_, OREQ(49), 2, IERR)                    30.81 30.00
        CALL OPNPEN (OREQ(48))                                            30.00
        CALL PLOSIT (PSDATA, OUTPR, PSNAME)                               40.02
        CALL OPNPEN (1)
      ENDIF
*
*     ***** To plot the date in case of nonstationary run ***** VER. 30.01
      IF (NSTATM.EQ.1) CALL OCPSUB ('TIME', 0., TIMCO, '   ')                  30.00
*
      RETURN
* * end of subroutine SWPLOT *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWSTAR (OREQ, MXK, MYK, VOQR, VOQ, ORER, KGRPNT,         30.21
     &                   SPCSIG, SPCDIR, AC2, ACLOC, WAVN, CG, NE,        30.72
     &                   NED                                     )        30.50
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     40.04: Annette Kieftenburg
C     40.13: Nico Booij
C
*  1. Updates
*
*            Nov. 96: New subroutine partly borrowed from Hiswa
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
C     40.04, June 00: Angle of starplot corrected with ALCQ
C     40.13, Mar. 01: auto scaling did not work; corrected
C                     structure scheme corrected
*
*  2. Purpose
*
*     Plotting directional distribution of action transport
*
*  3. Method
*
*     ---
*
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
 
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
*
*       OREQ      int  inp   array containing output requests
*       MXK, MYK  int  inp   number of grid points of output frame
*       VOQR      int  inp   gives location in array VOQ where to find a var.
*       VOQ       real inp   values of variables for all output points
*       AC2       real inp   action densities
*       ACLOC     real local spectral action densities in output point
*       WAVN      real local wave numbers
*       CG        real local energy prop. vel.
*       NE        real local unused
*       NED       real local unused
*
*  5. SUBROUTINES CALLING
*
*       OUTPUT (SWAN/OUTP)
*
*  6. SUBROUTINES USED
*
*       SCUNIT (all SWAN/OUTP), PNAMES, PCOAST
*       (both SWAN/SER) MSGERR, ADPOOL, OPFRAM, OCPSCH, OCPSUB, OCPISO,
*       OCPVEC and LASPLO (all Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
 
!     ----------------------------------------------------------------
!     Obtain plot parameters from array OREQ
!     if vector scale is not set
!     then make MLOOP=2
!     else MLOOP=1
!     ----------------------------------------------------------------
!     for LOOP = 1 to MLOOP do
!         for all output points do
!             Determine local depth
!             Interpolate action density spectrum
!             determine action transport vector
!             if LOOP=MLOOP
!             then multiply transport vector by scale
!                  plot vector
!             else make Vmax = Max of Vmax and vector length
!         ------------------------------------------------------------
!         If LOOP < MLOOP
!         then determine vector scale
!     ----------------------------------------------------------------
 
* 10. SOURCE TEXT
 
      REAL      VOQ(MXK*MYK,*),
     &          ORER(*),
     &          AC2(MDC,MSC,MCGRD),
     &          ACLOC(MDC,MSC), WAVN(*), CG(*), NE(*), NED(*)             090697
      REAL      VXR, VYR                                                  40.04
      INTEGER   VOQR(*), OREQ(*), KGRPNT(MXC,MYC)
      SAVE IENT
      DATA IENT /0/
      IF (LTRACE) CALL STRACE (IENT,'SWSTAR')
*
*     STAR plot
      IVTYPE = OREQ(35)                                                   30.50
      IF (IVTYPE.NE.19) CALL MSGERR (2, 'illegal vector type')
      USC   = ORER(36)
      IDIST = OREQ(37)
      IBUND = OREQ(38)
      IFR   = OREQ(39)
      IF (IFR.EQ.0) THEN
        ISM1 = 1
        ISM2 = MSC
      ELSE
        ISM1 = IFR
        ISM2 = IFR
      ENDIF
      IF (ITEST.GE.80) WRITE (PRTEST, 14) USC, IDIST, IBUND
  14  FORMAT (' entry SWSTAR, scale, dist, bund ', F12.5, 2I3)
      IF (IBUND.EQ.0) IBUND = 1
*
      IF (USC.LE.0.) THEN                                                 40.13
        USC = -1.                                                         40.13
        VMAX = 0.                                                         40.13
        MLOOP = 2                                                         40.13
!       first loop determines scale, second does actual plotting          40.13
      ELSE                                                                40.13
        MLOOP = 1                                                         40.13
!       scale is set; only one loop is needed                             40.13
      ENDIF                                                               40.13
      DO LOOP = 1, MLOOP                                                  40.13
        DO 200 IY = 1+IDIST/2, MYK-IDIST/2, IDIST                         30.50
          KJ = (IY-1)*MXK
          YT = YPLO + (IY-1)*DYQ * VRTSC
          IF (YT.GT.YPLO .AND. YT.LT.YPHI) THEN
            DO 190 IX = 1+IDIST/2, MXK-IDIST/2, IDIST
              IP = KJ + IX
              XT = XPLO + (IX-1)*DXQ * HORSC
              IF (XT.LE.XPLO .OR. XT.GE.XPHI) GOTO 190
              DEPLOC = VOQ(IP,VOQR(4))
              IF (DEPLOC.LT.0.) GOTO 190
              XCOMP  = VOQ(IP,VOQR(24))
              YCOMP  = VOQ(IP,VOQR(25))
*
*             the action density spectrum is interpolated
*
              JX1 = INT(XCOMP+3.) - 2
              IF (JX1.LT.0)   GOTO 190
              IF (JX1.GT.MXC) GOTO 190
              JX2 = JX1+1
              SX2 = XCOMP + 1. - JX1
              SX1 = 1. - SX2
              IF (SX1.LT.0.01 .OR. JX1.EQ.0)   THEN
                SX1 = 0.
                SX2 = 1.
              ENDIF
              IF (SX2.LT.0.01 .OR. JX1.EQ.MXC) THEN
                SX2 = 0.
                SX1 = 1.
              ENDIF
*
              JY1 = INT(YCOMP+3.) - 2
              IF (JY1.LT.0)   GOTO 190
              IF (JY1.GT.MYC) GOTO 190
              JY2 = JY1+1
              SY2 = YCOMP + 1. - JY1
              SY1 = 1. - SY2
              IF (SY1.LT.0.01 .OR. JY1.EQ.0) THEN
                SY1 = 0.
                SY2 = 1.
              ENDIF
              IF (SY2.LT.0.01 .OR. JY1.EQ.MYC) THEN
                SY2 = 0.
                SY1 = 1.
              ENDIF
*
              RF11 = SX1*SY1
              RF12 = SX1*SY2
              RF21 = SX2*SY1
              RF22 = SX2*SY2
              IF (RF11.GT.1.E-8) IND11 = KGRPNT(JX1,JY1)
              IF (RF12.GT.1.E-8) IND12 = KGRPNT(JX1,JY2)
              IF (RF21.GT.1.E-8) IND21 = KGRPNT(JX2,JY1)
              IF (RF22.GT.1.E-8) IND22 = KGRPNT(JX2,JY2)
*
              IF (ITEST.GE. 100 .OR. IOUTES .GE. 30) THEN
                WRITE (PRTEST, 69) XCOMP ,YCOMP,
     &                             IND11, IND12, IND21, IND22
  69    FORMAT (' test SWSTAR, Xc, Yc, Index: ', 2(F5.2,1X), 4I6)
                WRITE (PRTEST, 70) RF11 ,RF12 ,RF21 ,RF22
  70    FORMAT (' interpol. coeff.:', 4(1X,E8.3))
              ENDIF
*
              IF (IND11.LE.1 .AND. RF11.GT.0.001) GOTO 190
              IF (IND12.LE.1 .AND. RF12.GT.0.001) GOTO 190
              IF (IND21.LE.1 .AND. RF21.GT.0.001) GOTO 190
              IF (IND22.LE.1 .AND. RF22.GT.0.001) GOTO 190
*
              DO 110 ID = 1, MDC
                DO 100 ISIGM = ISM1, ISM2
*
*                 interpolate local action density
*
                  ACLL = 0.
                  IF (RF11.GT.1.E-6) THEN
                    ACLL = RF11      * AC2(ID,ISIGM,IND11)
                  ENDIF
                  IF (RF12.GT.1.E-6) THEN
                    ACLL = ACLL+RF12 * AC2(ID,ISIGM,IND12)
                  ENDIF
                  IF (RF21.GT.1.E-6) THEN
                    ACLL = ACLL+RF21 * AC2(ID,ISIGM,IND21)
                  ENDIF
                  IF (RF22.GT.1.E-6) THEN
                    ACLL = ACLL+RF22 * AC2(ID,ISIGM,IND22)
                  ENDIF
                  ACLOC(ID,ISIGM) = ACLL
 100            CONTINUE
 110          CONTINUE
*
              IF (ICUR.GT.0) THEN
                UXLOC  = VOQ(IP,VOQR(5))
                UYLOC  = VOQ(IP,VOQR(5)+1)
              ELSE
                UXLOC  = 0.
                UYLOC  = 0.
              ENDIF
*
*             determine Cg:
              CALL KSCIP1 (MSC, SPCSIG, DEPLOC, WAVN, CG, NE, NED)        30.81
              IF (ITEST.GE.120) WRITE (PRTEST, 122) (CG(IS), IS=1,MSC)
 122          FORMAT (' values of Cg:', 5(1X,E12.4), /, 6(1X,E12.4))
*
              DO 180  IDIRB = 1, MDC, IBUND
                ACTX = 0.
                ACTY = 0.
                DO 170 ISIGM = ISM1, ISM2
                  DO 160 IDIR = IDIRB, IDIRB+IBUND-1
                    ACTX = ACTX + SPCSIG(ISIGM) * ACLOC(IDIR,ISIGM) *     30.72
     &                          (CG(ISIGM)*SPCDIR(IDIR,2)+UXLOC)
                    ACTY = ACTY + SPCSIG(ISIGM) * ACLOC(IDIR,ISIGM) *     30.72
     &                          (CG(ISIGM)*SPCDIR(IDIR,3)+UYLOC)
 160              CONTINUE
 170            CONTINUE
*
                VX  = USC * ACTX * FRINTF / REAL(IBUND)
                VY  = USC * ACTY * FRINTF / REAL(IBUND)
                VV = SQRT(VX**2 + VY**2)
                IF (LOOP.EQ.MLOOP) THEN
C                 Correct the angle of the starplot to ALCQ
                  VXR = VX*COS(ALCQ) - VY*SIN(ALCQ)                       40.04
                  VYR = VX*SIN(ALCQ) + VY*COS(ALCQ)                       40.04
C
                  IF (VV.GT.0.01) THEN
                    CALL PLOTP (XT, YT, 'UP')
                    XQ = XT + VXR                                         40.04
                    YQ = YT + VYR                                         40.04
C                   plot vector
                    CALL PLOTP (XQ, YQ, 'DOWN')
                  ENDIF
                ELSE                                                      40.13
!                 determine longest vector                                40.13
                  VMAX = MAX (VMAX,VV)                                    40.13
                ENDIF                                                     40.13
 180          CONTINUE
 190        CONTINUE
          ENDIF
 200    CONTINUE
        IF (LOOP.LT.MLOOP) THEN                                           40.13
!         determine scale
          USC = 1.2 * IDIST * MIN(HORSC*DXQ,VRTSC*DYQ) / VMAX             40.13
        ENDIF                                                             40.13
      ENDDO                                                               40.13
 
      RETURN
* * end of subroutine SWSTAR *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SPLOER (OREQ, XCGRID, YCGRID)                            30.72
*                                                                      *
************************************************************************
C
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'timecomm.inc'                                              40.13
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     34.01: Jeroen Adema
C     40.13: Nico Booij
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is
C                     a reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.13, Mar. 01: fixes to get PLOT .. PROB running
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
C
*  2. Purpose
*
*     Drawing a plot with the locations of error points
*
*  3. Method
*
*     ---
*
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
*
*  5. SUBROUTINES CALLING
*
*       OUTPUT (SWAN/OUTP)
*
*  8. SUBROUTINES USED
*
*       INFRAM (SWAN/SER), INREAL, MSGERR,
*       KEYWIS and OPMARK (all Ocean Pack)
*
      LOGICAL STPNOW                                                      34.01
C
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       rewind file 'ERRPTS'                                              40.13
*       read keyword
*       For every point in file 'ERRPTS' do
*           read coordinates and error code
*           If error code is according to request
*           Then plot symbol at location of the point
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      LOGICAL   INFRAM
      INTEGER   OREQ(*), FROPT
      CHARACTER PTI*36, FROM_                                             30.81
      SAVE IENT, FROM_                                                    30.81
      DATA IENT /0/, FROM_ /'F'/                                          30.81
      CALL STRACE (IENT,'SPLOER')
*
      REWIND (ERRPTS)                                                     40.13
*
*     ***** start of plot output, window and title are drawn *****
*     ***** obtain name of plotfile *****
      IERR = -1
      FILENM = OUTP_FILES(OREQ(7))                                        40.13
      IF (ITEST.GE.100 .OR. IOUTES .GE. 30) WRITE (PRINTF,6015) FILENM
 6015 FORMAT (' Filenm:',A36)
*     ***** obtain plot title from array *****
      CALL COPYCH (PTI, FROM_, OREQ(18), 10, IERR)                        30.81 30.00
      PMARG = 0.        ! remove this statement when coordinates can be plotted
      XASL = HORSC*XQLEN + PMARG                                          40.13
      YASL = VRTSC*YQLEN + PMARG                                          40.13
      FROPT = PFROPT
      CALL OPFRAM (FROPT, PTI)
      IF (STPNOW()) RETURN                                                34.01
      CALL OCPSCH (4.*SYMSIZ/HORSC, RLL)
      CALL OCPSUB ('LENS', HORSC, RLL, UL)
*     ***** To plot the date in case of nonstationary run *****      VER. 40.13
      IF (NSTATM.EQ.1) CALL OCPSUB ('TIME', 0., TIMCO, '   ')             40.13
*
*     type of error investigated:
*
      ICD   = OREQ(28)                                                    30.00
      SYMSZ = OCREAL(OREQ(29))                                            30.00
*
*     read coordinates of error points, and plot
*
 100  READ (ERRPTS, *, END=900, ERR=820) IX, IY, ICP
      IF (ICD.EQ.0 .OR. ICP.EQ.ICD) THEN
        XP = XCGRID(IX,IY)                                                30.72
        YP = YCGRID(IX,IY)                                                30.72
*       plot symbol at the location
        XPA = (XQP + COSPQ*XP + SINPQ*YP)
        YPA = (YQP - SINPQ*XP + COSPQ*YP)
        IF (INFRAM(XPA, YPA)) THEN
          XPA = XPLO + HORSC * XPA                                         40.13
          YPA = YPLO + VRTSC * YPA                                         40.13
*
          IF (ITEST.GE.160 .OR. IOUTES .GE. 40) THEN
            WRITE (PRINTF, 6030) XP+XOFFS, YP+YOFFS, XPA, YPA
 6030       FORMAT (' Test SPLOER ', 4E12.4)
          ENDIF
*
*          CALL OPMARK (YASL-YPA, PMR+XPA, SYMSZ, ICP, 'UP')
          CALL OPMARK (XPA, YPA, SYMSZ, ICP, 'UP')
        ENDIF
      ENDIF
*
      GOTO 100
*
*
 820  CALL MSGERR (2, 'Error in file ERRPTS')
*
 900  CALL OPENDF
 910  CONTINUE
      RETURN
* * end of subroutine SPLOER *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWSPEC (RTYPE, OREQ, MIP, VOQR, VOQ, AC2, ACLOC,         20.28
     &                   SPCSIG, SPCDIR, DEP2, KGRPNT)                    30.72
*                                                                      *
************************************************************************
C
      USE OUTP_DATA                                                       40.13
 
!     ocpcomm2.inc is now accessed via USE OUTP_DATA                      40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     32.01: Roeland Ris & Cor van der Schelde
C     34.01: Jeroen Adema
C     40.00, 40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     20.28         : completely new version
C     20.43         : arguments ECOS and ESIN replaced by SPCDIR
C     32.01, Jan. 98: Introduced nautical convention (project h3268)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is
C                     a reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.00, Aug. 99: new file structure introduced
C     40.03, May  00: correct time coding option written to heading of file
C            Oct. 00: write 'LOCATION' in upper case
C     40.13, Mar. 01: format for writing coordinates different for Cartesian
C                     and spherical coordinates
!     40.13, Oct. 01: longer output filenames now obtained from array
!                     OUTP_FILES (in module OUTP_DATA)
C
C  2. Purpose
C
C     Printing of action density spectrum in the form of a table
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C     RTYPE   ch*4   input    type of output request: 'SPEC' for 2-D spectral
C                             output, 'SPE1' for 1-D freq. spectrum
C     OREQ    int    input    array containing output request data
C                             of request currently being processed
C     MIP     int    input    number of output points in set PSNAME
C     ACLOC   real   local    case SPEC: 2-D spectrum at one output location
C                             case SPE1: 1-D spectra at output locations
C     AK      real   input    wavenumber array at output location
C     UX, UY  real   input    current velocities at output location
C
C  8. Subroutines used
C
C     DEGCNV: Transforms dir. from nautical to cartesian or vice versa    32.01
C     ANGDEG: Transforms degrees to radians                               32.01
C     SWCMSP
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWOUTP (SWAN/OUTP)
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C       ---
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       get NREF from array OREQ  (output requests)
C       if NREF = 0
C       then open output file
C            write heading into the file                                  40.00
C       ----------------------------------------------------------------
C
C 13. Source text
C
      CHARACTER (LEN=*) :: RTYPE                                              30.81 40.13
      CHARACTER (LEN=8) :: CRFORM = '(2F12.2)'                            40.13
      INTEGER       :: OREQ(*), VOQR(*), OTYPE, KGRPNT(MXC,MYC)           40.13
      INTEGER, SAVE :: IVERF = 1                                          40.13
      REAL      VOQ(MIP,*), AC2(MDC,MSC,MCGRD),
     &          ACLOC(*), DEP2(MCGRD)                                     40.00
      LOGICAL   EQREAL
 
      INTEGER, SAVE :: IENT=0                                             40.13
      IF (LTRACE) CALL STRACE(IENT,'SWSPEC')
*
      NREF = OREQ(6)                                                      30.00
      IF (INRHOG.EQ.1) THEN
        OFAC = RHO * GRAV                                                 30.20
      ELSE
        OFAC = 1.
      ENDIF
*
      IF (NREF .EQ. 0) THEN
        IERR = -1
        FILENM = OUTP_FILES(OREQ(7))                                      40.13
        IOSTAT = -1                                                       20.75
        CALL FOR (NREF, FILENM, 'UF', IOSTAT)
        IF (STPNOW()) RETURN                                              34.01
        OREQ(6) = NREF                                                    30.00
*       IF (IOSTAT.NE.0) WRITE (PRINTF, 6020) FILENM, IOSTAT
*6020   FORMAT (' Open error: ', A36, I6)
*       write heading into the file                                       40.00
*       write keyword SWAN and version number
        WRITE (NREF, 101) IVERF
 101    FORMAT ('SWAN', I4, T41, 'Swan standard spectral file, version')  40.00
        WRITE (NREF, 111) VERTXT                                          40.03
 111    FORMAT ('$   Data produced by SWAN version ', A)                  40.03
        WRITE (NREF, 113) PROJID, PROJNR
 113    FORMAT ('$   Project: ', A, ';  run number: ', A)
        IF (NSTATM.EQ.1) THEN
          WRITE (NREF, 102) 'TIME', 'time-dependent data'
 102      FORMAT (A, T41, A)                                              40.00
          WRITE (NREF, 103) ITMOPT, 'time coding option'                  40.03
 103      FORMAT (I6, T41, A)                                             40.00
        ENDIF
        IF (KSPHER.EQ.0) THEN                                             33.09 NB!
          WRITE (NREF, 102) 'LOCATIONS', 'locations in x-y-space'
          CRFORM = '(2F12.2)'                                             40.13
        ELSE                                                              33.09 NB!
          WRITE (NREF, 102) 'LONLAT',
     &                    'locations in spherical coordinates'            33.09 nb!
          CRFORM = '(2F12.6)'                                             40.13
        ENDIF                                                             33.09 NB!
        WRITE (NREF, 103) MIP, 'number of locations'
        DO 110 IP = 1, MIP
          WRITE (NREF, FMT=CRFORM) DBLE(VOQ(IP,VOQR(1))),                 40.13
     &                             DBLE(VOQ(IP,VOQR(2)))                  40.13
 110    CONTINUE
        IF (RTYPE(3:3) .EQ. 'R') THEN
          WRITE (NREF, 102) 'RFREQ', 'relative frequencies in Hz'         40.00
        ELSE
          WRITE (NREF, 102) 'AFREQ', 'absolute frequencies in Hz'         40.00
        ENDIF
        WRITE (NREF, 103) MSC, 'number of frequencies'                    40.00
        DO 120 IS = 1, MSC
          WRITE (NREF, 114) SPCSIG(IS)/PI2
 114      FORMAT (F10.4)
 120    CONTINUE
        IF (RTYPE(4:4).EQ.'C') THEN
*         full 2-D spectrum
          IF (BNAUT) THEN
            WRITE (NREF, 102) 'NDIR',
     &                        'spectral nautical directions in degr'      40.00
          ELSE
            WRITE (NREF, 102) 'CDIR',
     &                        'spectral Cartesian directions in degr'     40.00
          ENDIF
          WRITE (NREF, 103) MDC, 'number of directions'
          DO 130 ID = 1, MDC
            IF (BNAUT) THEN
              WRITE (NREF, 124) 180. + DNORTH - SPCDIR(ID,1)*180./PI
            ELSE
              WRITE (NREF, 124) SPCDIR(ID,1)*180./PI
            ENDIF
 124        FORMAT (F10.4)
 130      CONTINUE
          WRITE (NREF, 132) 1
 132      FORMAT ('QUANT', /, I6, T41, 'number of quantities in table')   40.00
          IF (INRHOG.EQ.1) THEN
            WRITE (NREF, 102) 'EnDens',
     &                        'energy densities in J/m2/Hz/degr'          40.00
            WRITE (NREF, 102) 'J/m2/Hz/degr', 'unit'
            WRITE (NREF, 104) OVEXCV(22), 'exception value'               40.00
 104        FORMAT (E14.4, T41, A)
          ELSE
            WRITE (NREF, 102) 'VaDens',
     &                        'variance densities in m2/Hz/degr'          40.00
            WRITE (NREF, 102) 'm2/Hz/degr', 'unit'
            WRITE (NREF, 104) OVEXCV(22), 'exception value'               40.00
          ENDIF
        ELSE
*         1-D spectrum
          WRITE (NREF, 132) 3
          IF (INRHOG.EQ.1) THEN
            WRITE (NREF, 102) 'EnDens',  'energy densities in J/m2/Hz'
            WRITE (NREF, 102) 'J/m2/Hz', 'unit'
            WRITE (NREF, 104) OVEXCV(22), 'exception value'               40.00
          ELSE
            WRITE (NREF, 102) 'VaDens', 'variance densities in m2/Hz'
            WRITE (NREF, 102) 'm2/Hz',  'unit'
            WRITE (NREF, 104) OVEXCV(22), 'exception value'               40.00
          ENDIF
          IF (BNAUT) THEN
            WRITE (NREF, 102) 'NDIR',
     &                        'average nautical direction in degr'
          ELSE
            WRITE (NREF, 102) 'CDIR',
     &                        'average Cartesian direction in degr'
          ENDIF
          WRITE (NREF, 102) OVUNIT(13), 'unit'                            40.00
          WRITE (NREF, 104) OVEXCV(13), 'exception value'                 40.00
          WRITE (NREF, 102) 'DSPRDEGR', OVLNAM(16)                        40.00
          WRITE (NREF, 102) OVUNIT(16), 'unit'                            40.00
          WRITE (NREF, 104) OVEXCV(16), 'exception value'                 40.00
        ENDIF
      ENDIF
*
*     writing of heading is completed, write time if nonstationary
*
      IF (NSTATM.EQ.1) THEN
        WRITE (NREF, 202) CHTIME                                          40.00
 202    FORMAT (A18, T41, 'date and time')
      ENDIF
*
      IF (RTYPE(4:4).EQ.'C') THEN
        IF (RTYPE.EQ.'SPEC') THEN
          OTYPE = -2
        ELSE
          OTYPE = 2
        ENDIF
      ELSE
        IF (RTYPE.EQ.'SPE1') THEN
          OTYPE = -1
        ELSE
          OTYPE = 1
        ENDIF
      ENDIF
*
      DO 290 IP = 1, MIP
        XC   = VOQ(IP,VOQR(24))
        YC   = VOQ(IP,VOQR(25))
        DEP = VOQ(IP,VOQR(4))
        IF (DEP.LE.0. .OR. EQREAL(DEP,OVEXCV(4))) THEN
          WRITE (NREF, 220) 'NODATA'                                      40.00
 220      FORMAT (A6)
          GOTO 290
        ENDIF
        IF (ICUR.GT.0) THEN
          UX = VOQ(IP,VOQR(5))
          UY = VOQ(IP,VOQR(5)+1)
        ELSE
          UX = 0.
          UY = 0.
        ENDIF
*
        CALL SWCMSP (OTYPE       ,XC         ,YC          ,               40.00
     &               AC2         ,ACLOC      ,SPCSIG      ,
     &               DEP         ,DEP2       ,UX          ,               40.00
     &               UY          ,SPCDIR(1,2) ,SPCDIR(1,3),
     &               OFAC        ,KGRPNT     ,IERR        )               40.00
*
        IF (IERR.GT.0) THEN
          WRITE (NREF, 220) 'NODATA'
        ELSE
          IF (ABS(OTYPE).EQ.2) THEN
C           write 2d spectrum
            CALL WRSPEC (NREF, ACLOC)
          ELSE
C           write 1d spectrum
            WRITE (NREF, 115) IP
 115        FORMAT ('LOCATION', I4)                                       40.03
            DO IFR = 1, MSC
*             write frequency spectra to file
              WRITE (NREF, 116) (ACLOC(IFR+JJ*MSC), JJ=0,2)               40.00
 116          FORMAT (E12.4, 2F7.1)
            ENDDO
          ENDIF
        ENDIF
 290  CONTINUE
*
*
      RETURN
* * end of subroutine SWSPEC *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWCMSP (OTYPE     ,XC        ,YC        ,                40.00
     &                   AC2       ,ACLOC     ,SPCSIG    ,
     &                   DEP       ,DEP2      ,UX        ,                40.00
     &                   UY        ,ECOS      ,ESIN      ,
     &                   OFAC      ,KGRPNT    ,IERR      )                30.21
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     40.00: Nico Booij
C
C  1. Updates
C
C     20.xx         : New subroutine
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.81, Nov. 98: Adjustment for 1-D case of new boundary conditions
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
C     40.00, Jan. 98: number of output points is always 1
C                     subr produces 3 parameters in case 1D
C                     in 2D cases, loops over ID and ISIGM swapped
C                     interpolation changed: if a corner of the mesh is dry,
C                     exception values are written
C                     argument DEP2 added
C     30.82, Apr. 99: Conversion from m^2/rad/s to m^2/Hz correctly implemented
C     30.82, July 99: Corrected argumentlist KSCIP1
C
*  2. Purpose
*
*     Computation of energy density spectrum 1-D or 2-D
*
*  3. Method
*
*     Energy is assumed to be distributed evenly over the interval
*     from Sigma/Frinth to Sigma*Frinth
*     This energy is tranferred to the Omega axis; it is determined
*     how much energy is to be assigned to each interval
*
*     Bilinear interpolation within a mesh of the computational grid
*     to obtain action density in an output location.
*     To transform from relative to absolute frequency, an interval in
*     sigma-space is partitioned, the energy in a submesh is determined
*     and transferred to omega-space where it is added to the energy for
*     a grid step; to obtain energy density this value is divided
*     by the length of the interval.
*     To obtain frequency spectra (1-D) energy density is integrated
*     over theta (spectral direction)
*
C  4. Argument variables
C
C     SPCSIG: input  Relative frequencies in computational domain in      30.72
C                    sigma-space                                          30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
*
*       OTYPE   int    input    type of spectrum wanted: 2 or -2 for 2-D
*                               spectrum, 1 or -1 for 1-D freq. spectrum
*                               positive: relative freq, negative: abs. fr.
*       OREQ    int    input    array containing output request data
*                               of request currently being processed
*       MPP     int    input    number of output points in set PSNAME
*       XC, YC  real   input    coordinates of output location(s)
*       ACLOC   real   local    |OTYPE|=2: 2-D spectrum at one output location
*                               |OTYPE|=1: 1-D spectra at output locations
*       DEP     real   input    depths at output location
*       UX, UY  real   input    current velocities at output location
*       ECOS  real   input    cosines of spectral directions
*       ESIN  real   input    sines of spectral directions
*       OFAC    real   input    output factor (if INRHOG=1, equal to Rho*Grav)
*
*  5. SUBROUTINES CALLING
*
*       SWSPEC (SWAN/OUTP)
*
*  6. SUBROUTINES USED
*
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
C
      INTEGER   OTYPE           ,KGRPNT(MXC,MYC)                          30.21
      REAL      XC, YC, UX, UY, DEP, DEP2(MCGRD), AC2(MDC,MSC,MCGRD),     40.00
     &          ACLOC(*)        ,ECOS(MDC)         ,ESIN(MDC)             40.00
      REAL      CG(1), K1(1), K2(1), N(1), ND(1), SIG1(1), SIG2(1)        30.82
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE(IENT,'SWCMSP')
*
*     make initial value of energy density 0
*
      IF (ABS(OTYPE).EQ.1) THEN
*       1-D spectra
        DO II = 1, 3*MSC                                                  40.00
          ACLOC(II) = 0.
        ENDDO
      ELSE
*       2-D spectra
        DO II = 1, MDC*MSC
          ACLOC(II) = 0.
        ENDDO
      ENDIF
*
*     ***** determine energy densities *****
*
      IF (DEP.LE.0.) GOTO 800
*
*     the action density spectrum is interpolated, determine interpolation coeff
*
      JX1 = NINT(XC-0.5) + 1                                              33.09
      IF (KREPTX.EQ.0) THEN                                               33.09
        IF (JX1.LT.0) THEN
          GOTO 800
        ELSE IF (JX1.GT.MXC) THEN
          GOTO 800
        ELSE IF (JX1.EQ.0) THEN
          IF (XC.GT.-0.01) THEN
            JX1 = 1
            JX2 = 2
            SX1 = 1.
            SX2 = 0.
          ELSE
            GOTO 800
          ENDIF
        ELSE IF (JX1.EQ.MXC) THEN
          IF (XC.LT.REAL(MXC-1)+0.01) THEN
            JX1 = MXC-1
            JX2 = MXC
            SX1 = 0.
            SX2 = 1.
          ELSE
            GOTO 800
          ENDIF
        ELSE
          JX2 = JX1+1
          SX2 = XC + 1. - FLOAT(JX1)
          SX1 = 1. - SX2
          IF (SX1.LT.0.01) THEN
            SX1 = 0.
            SX2 = 1.
          ENDIF
          IF (SX2.LT.0.01) THEN
            SX2 = 0.
            SX1 = 1.
          ENDIF
        ENDIF
      ELSE
        JX2 = JX1+1
        SX2 = XC + 1. - FLOAT(JX1)
        SX1 = 1. - SX2
        JX1 = MOD(MXC+JX1-1,MXC) + 1                                      33.09
        JX2 = MOD(MXC+JX2-1,MXC) + 1                                      33.09
      ENDIF                                                               33.09
*
      IF (.NOT. ONED) THEN                                                30.81
        JY1 = INT(YC+3.) - 2
        IF (JY1.LT.0) THEN
          GOTO 800
        ELSE IF (JY1.GT.MYC) THEN
          GOTO 800
        ELSE IF (JY1.EQ.0) THEN
          IF (YC.GT.-0.01) THEN
            JY1 = 1
            JY2 = 2
            SY1 = 1.
            SY2 = 0.
          ELSE
            GOTO 800
          ENDIF
        ELSE IF (JY1.EQ.MYC) THEN
          IF (YC.LT.REAL(MYC-1)+0.01) THEN
            JY1 = MYC-1
            JY2 = MYC
            SY1 = 0.
            SY2 = 1.
          ELSE
            GOTO 800
          ENDIF
        ELSE
          JY2 = JY1+1
          SY2 = YC + 1. - FLOAT(JY1)
          SY1 = 1. - SY2
          IF (SY1.LT.0.01) THEN
            SY1 = 0.
            SY2 = 1.
          ENDIF
          IF (SY2.LT.0.01) THEN
            SY2 = 0.
            SY1 = 1.
          ENDIF
        ENDIF
      ELSE                                                                30.81
        JY1 = 1                                                           30.81
        JY2 = 1                                                           30.81
        SY1 = 1.                                                          30.81
C       SY2 = 1. - SY1  so:                                               30.81
        SY2 = 0.                                                          30.81
      END IF                                                              30.81
 
*
*     *** Using indirect addressing kgrpnt instead x and y ***
*         *** KGRPNT(JX1,JY1) instead  (JX1,JY1)
*         *** KGRPNT(JX1,JY2) instead  (JX1,JY2) ETC.
      IND11 = KGRPNT(JX1,JY1)
      IND12 = KGRPNT(JX1,JY2)
      IND21 = KGRPNT(JX2,JY1)
      IND22 = KGRPNT(JX2,JY2)
      IF (IND11.LE.0 .OR. IND11.GT.MCGRD) WRITE (PRINTF, *)
     &      ' error SWCMSP ', JX1, JY1, IND11, MCGRD
      IF (IND12.LE.0 .OR. IND12.GT.MCGRD) WRITE (PRINTF, *)
     &      ' error SWCMSP ', JX1, JY2, IND11, MCGRD
      IF (IND21.LE.0 .OR. IND21.GT.MCGRD) WRITE (PRINTF, *)
     &      ' error SWCMSP ', JX2, JY1, IND11, MCGRD
      IF (IND22.LE.0 .OR. IND22.GT.MCGRD) WRITE (PRINTF, *)
     &      ' error SWCMSP ', JX2, JY2, IND11, MCGRD
      RF11 = SX1*SY1
      RF12 = SX1*SY2
      RF21 = SX2*SY1
      RF22 = SX2*SY2
      IF (DEP2(IND11).LE.DEPMIN .AND. RF11.GT.0.01) GOTO 800              40.00
      IF (DEP2(IND12).LE.DEPMIN .AND. RF12.GT.0.01) GOTO 800              40.00
      IF (DEP2(IND21).LE.DEPMIN .AND. RF21.GT.0.01) GOTO 800              40.00
      IF (DEP2(IND22).LE.DEPMIN .AND. RF22.GT.0.01) GOTO 800              40.00
*
      IF (ITEST.GE. 250 .OR. IOUTES .GE. 30) THEN
        WRITE (PRTEST, 69) JX1, JX2, JY1, JY2,
     &          SX1, SX2, SY1, SY2, XC ,YC
        WRITE (PRTEST, 70) IND11, IND12, IND21, IND22,
     &          RF11 ,RF12 ,RF21 ,RF22
  69    FORMAT ('   -------------------SWCMSP -------------------',/,
     &     ' JX1,JX2,JY1,JY2,  SX1,  SX2,  SY1, SY2,     XC,      YC',/,
     &           4I4,1X, 4(F5.2,1X),2(F8.2,1X))
  70    FORMAT(12X, 'IND11..22       RF11    RF12    RF21    RF22 ',
     &         /, 4I6, 2X, 4F8.4)
      ENDIF
*
      DO 110 ID = 1, MDC
        IF (ICUR.GT.0 .AND. OTYPE.LT.0) THEN
          UDIR = UX * ECOS(ID) + UY * ESIN(ID)
        ENDIF
        DO 100 ISIGM = 1, MSC
*
*         interpolate local action density
*
          ACLL = 0.
C
          IF (RF11.GT.1.E-10) THEN
            ACLL =        RF11 * AC2(ID,ISIGM,IND11)
          ENDIF
          IF (RF12.GT.1.E-10) THEN
            ACLL = ACLL + RF12 * AC2(ID,ISIGM,IND12)
          ENDIF
          IF (RF21.GT.1.E-10) THEN
            ACLL = ACLL + RF21 * AC2(ID,ISIGM,IND21)
          ENDIF
          IF (RF22.GT.1.E-10) THEN
            ACLL = ACLL + RF22 * AC2(ID,ISIGM,IND22)
          ENDIF
*         energy density interpolated in space:
          ECLL = OFAC * ACLL * SPCSIG(ISIGM)                              40.00
*
          IF (ICUR.EQ.0 .OR. OTYPE.GT.0
     &                                    ) THEN
*
*           spectrum as function of relative frequency (SPCSIG)
*
            IF (ABS(OTYPE).EQ.2) THEN
               ACLOC(ID+(ISIGM-1)*MDC) = ECLL                             40.00
            ELSE
*             1-D spectrum of rel. frequency
              ECLL = ECLL * DDIR                                          40.00
              ACLOC(ISIGM) = ACLOC(ISIGM) + ECLL
              ACLOC(ISIGM+  MSC) = ACLOC(ISIGM+  MSC) + ECLL * ECOS(ID)
              ACLOC(ISIGM+2*MSC) = ACLOC(ISIGM+2*MSC) + ECLL * ESIN(ID)
              IF (ITEST.GE.250 .OR. IOUTES .GE. 40) WRITE (PRTEST, 83)
     &           ISIGM, ECLL, (ACLOC(ISIGM+JJ*MSC),JJ=0,2)
 83           FORMAT (' Test SWCMSP ', I6, 4(1X,E12.4))
            ENDIF
          ELSE
*
*           spectrum as function of absolute frequency (OMEGA)
*           WK is wavenumber
*           energy density is assumed constant over the interval from
*           SIG1 to SIG2
*
            SIG1(1)  = SPCSIG(ISIGM) / FRINTH                             30.82
            CALL KSCIP1 (1, SIG1, DEP, K1, CG, N, ND)                     30.82
            OMEG1 = SIG1(1) + K1(1) * UDIR                                30.82
            SIG2(1)  = SPCSIG(ISIGM) * FRINTH                             30.82
            CALL KSCIP1 (1, SIG2, DEP, K2, CG, N, ND)                     30.82
            OMEG2 = SIG2(1) + K2(1) * UDIR                                30.82
            DSIG  = FRINTF * SPCSIG(ISIGM)
*
*           EE is energy density in Omega:
*
            EE    = ECLL * DSIG / ABS(OMEG2-OMEG1)
            IF (ITEST.GE.250 .OR. IOUTES .GE. 40) WRITE (PRTEST, 86)
     &          ID, ISIGM, SIG1(1), K1(1), OMEG1, SIG2(1), K2(1), OMEG2   30.82
  86        FORMAT (' Test SWCMSP/86 ', 2I6, 8(1X,E12.4))
*
*           assign the energy to omega interval
*
            IF (OMEG1.GT.OMEG2) THEN
*             swap the two values
              RR    = OMEG2
              OMEG2 = OMEG1
              OMEG1 = RR
            ENDIF
            DO 90 IOM = 1, MSC
              OMEGA = SPCSIG(IOM) / FRINTH
              OMEGB = SPCSIG(IOM) * FRINTH
              IF (OMEG1.LT.OMEGB) THEN
                RLOW = MAX (OMEG1,OMEGA)
              ELSE
                GOTO 90
              ENDIF
              IF (OMEG2.GT.OMEGA) THEN
                RUPP = MIN (OMEG2,OMEGB)
              ELSE
                GOTO 90
              ENDIF
              IF (RUPP.LT.RLOW) THEN
                WRITE (PRINTF, 88) ISIGM, IOM, OMEG1, OMEG2,
     &                             OMEGA, OMEGB, RUPP, RLOW
  88            FORMAT (' error SWCMSP:', 2I4, 8(1X,E12.4))
              ELSE
                IF (OTYPE.EQ.-2) THEN
                  ACLOC(ID+(IOM-1)*MDC) =
     &               ACLOC(ID+(IOM-1)*MDC) + EE * (RUPP - RLOW)           40.00
                ELSE
                  EADD = EE * DDIR * (RUPP - RLOW)                        40.00
                  ACLOC(IOM) = ACLOC(IOM) + EADD
                  ACLOC(IOM+  MSC) = ACLOC(IOM+  MSC) + EADD * ECOS(ID)
                  ACLOC(IOM+2*MSC) = ACLOC(IOM+2*MSC) + EADD * ESIN(ID)
                ENDIF
              ENDIF
  90        CONTINUE
          ENDIF
 100    CONTINUE
        IF (OTYPE.EQ.-2 .AND. ICUR.GT.0) THEN                             40.00
          DO 150 IOM = 1, MSC
            DOMEG = FRINTF * SPCSIG(IOM)
            ACLOC(ID+(IOM-1)*MDC) =
     &             ACLOC(ID+(IOM-1)*MDC) / DOMEG                          40.00
            IF (ITEST.GE.250 .OR. IOUTES .GE. 40) WRITE (PRTEST, 135)
     &        ID, IOM, ACLOC(ID+(IOM-1)*MDC), DOMEG                       40.00
 135        FORMAT (' Test SWCMSP ', 2I6, 4(1X,E12.4))
 150      CONTINUE
        ENDIF
 110  CONTINUE
      IF (ABS(OTYPE).EQ.1) THEN
*       1-D spectrum
        IF (ICUR.GT.0 .AND. OTYPE.EQ.-1) THEN
          DO 250 IOM = 1, MSC
            DOMEG = FRINTF * SPCSIG(IOM)
            DO 249 JJ = 0, 2
              ACLOC(IOM+JJ*MSC) = ACLOC(IOM+JJ*MSC) / DOMEG
 249        CONTINUE
 250      CONTINUE
        ENDIF
        DO 270 IOM = 1, MSC
          IF (ACLOC(IOM).GT.0.) THEN
            EX = ACLOC(IOM+MSC) / ACLOC(IOM)
            EY = ACLOC(IOM+2*MSC) / ACLOC(IOM)
            ACLOC(IOM+MSC) = DEGCNV (ATAN2(EY,EX) * 180./PI)
            FF = MIN (1.,SQRT(EX**2+EY**2))
            ACLOC(IOM+2*MSC) = SQRT(2.-2.*FF)*180./PI
C
C           To convert ACLOC from m^2/rad/s to m^2/Hz (1D spectrum)
C
            ACLOC(IOM) = ACLOC(IOM) * PI2                                 40.00
C
          ELSE
C           exception values for DIR and DSPR
            ACLOC(IOM+MSC) = OVEXCV(13)
            ACLOC(IOM+2*MSC) = OVEXCV(16)
          ENDIF
 270    CONTINUE
      ENDIF
C
 190  IERR = 0
      GOTO 900
*
*     point is outside grid
 800  IERR = 1
*
 900  CONTINUE
      RETURN
* * end of subroutine SWCMSP *
      END
