!NRL: $Id: swanser.F,v 1.2 2003/03/28 15:43:15 dykes Stab $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000    4:17 pm
*
*     SWAN - SERVICE ROUTINES
*
*  Contents of this file
*
*     READXY
*     REFIXY
*     INFRAM
*     PCOAST
*     PLOTU
*     PNAMES
*     PLNAME
*     PLOSIT
*     DISTR
*     KSCIP1
*     AC2TST
*     CVCHEK                                                              30.60
*     CVMESH                                                              30.60
*     NEWTON                                                              30.60
*     EVALF                                                               30.60
*     SWOBST                                                              30.60
C     TCROSS2                                                             40.04
*     SWTRCF
*     SSHAPE                                                              40.00
*     SINTRP                                                              40.00
*     HSOBND                                                              32.01
*     CHGBAS                                                              40.00
*     GAMMA                                                               40.00
*     WRSPEC                                                              40.00
C
C  functions:
C  ----------
C  DEGCNV  (converts from cartesian convention to nautical and            32.01
C           vice versa)                                                   32.01
C  ANGRAD  (converts radians to degrees)                                  32.01
C  ANGDEG  (converts degrees to radians)                                  32.01
C
C  subroutines:
C  ------------
C  HSIBND  (Hs is calculated at those side where a boundary condition     32.01
C           is provided and directly after the 'BOUNDARY' command         32.01
C           and subsequently stored in array HSI)                         32.01
C  HSOBND  (Hs is calculated after a SWAN computation at all sides.       32.01
C           The calculated wave height from SWAN is then compared with    32.01
C           the wave heigth as provided by the user (HSIBND)              32.01
C  SPCVAR  (A variable boundary condition is read along a side of the     32.01
C           computational grid)                                           32.01
C  SPCRD   (Read an input file with 1D- or 2D- spectra)                   32.01
C  INTSPEC (interpolate in geographical and directional space along       32.01
C           a boundary side when two- or more wave spectra are provided)  32.01
C  ROTSPEC (rotate spectra at boundary for interpolation procedure in     32.01
C           directional space)                                            32.01
C  STRSPEC (strech spectrum at boundary for interpolation procedure in    32.01
C           frequency space)                                              32.01
C  SETUPP  (Compute the wave-induced setup for a one-dimensional and a    32.01
C           two-dimensional run. Note that the one-dimensional mode of    32.01
C           swan has been coded in this project (H3268)                   32.01
C  SETUP2D (Computation of SETUP, the change of waterlevel by waves.      31.03
C           A Poisson equation is solved in general coordinates           31.03
C
*
************************************************************************
*                                                                      *
      SUBROUTINE READXY (NAMX, NAMY, XX, YY, KONT, XSTA, YSTA)
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
*
*       Nov. 1996               offset values are added to standard values
*                               because they will be subtracted later
*
*  2. PURPOSE
*
*       Read x and y, initialize offset values XOFFS and YOFFS
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       NAMX, NAMY   inp char    names of the two coordinates as given in
*                                the user manual
*       XX, YY       out real    values of x and y taking into account offset
*       KONT         inp char    what to be done if values are missing
*                                see doc. of INDBLE (Ocean Pack doc.)
*       XSTA, YSTA   inp real    standard values of x and y
*
*  5. SUBROUTINES CALLING
*
*
*
*  6. SUBROUTINES USED
*
*       INDBLE (Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Read x and y in double prec.
*       If this is first couple of values
*       Then assign values to XOFFS and YOFFS
*            make LXOFFS True
*       ---------------------------------------------------------------
*       make XX and YY equal to x and y taking into account offset
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      DOUBLE PRECISION XTMP, YTMP
      CHARACTER  NAMX *(*), NAMY *(*), KONT *(*)
      SAVE  IENT
      DATA  IENT /0/
      CALL  STRACE (IENT,'READXY')
*
      CALL INDBLE (NAMX, XTMP, KONT, DBLE(XSTA)+DBLE(XOFFS))
      CALL INDBLE (NAMY, YTMP, KONT, DBLE(YSTA)+DBLE(YOFFS))
      IF (.NOT.LXOFFS) THEN
        XOFFS = REAL(XTMP)
        YOFFS = REAL(YTMP)
        LXOFFS = .TRUE.
      ENDIF
      XX = REAL(XTMP-DBLE(XOFFS))
      YY = REAL(YTMP-DBLE(YOFFS))
*
      RETURN
* * end of subroutine READXY  *
      END
************************************************************************
*                                                                      *
      SUBROUTINE REFIXY (NDS, XX, YY, IERR)
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
*
*       first version: 10.18 (Sept 1994)
*
*  2. PURPOSE
*
*       initialize offset values XOFFS and YOFFS, and shift XX and YY
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       NDS          in  int     file reference number
*       XX, YY       out real    values of x and y taking into account offset
*       IERR         out int     error indicator: IERR=0: no error, =-1: end-
*                                of-file, =-2: read error
*
*  5. SUBROUTINES CALLING
*
*
*
*  6. SUBROUTINES USED
*
*       ---
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       If this is first couple of values
*       Then assign values to XOFFS and YOFFS
*            make LXOFFS True
*       ---------------------------------------------------------------
*       make XX and YY equal to x and y taking into account offset
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      DOUBLE PRECISION XTMP, YTMP
      REAL             XX, YY
      SAVE  IENT
      DATA  IENT /0/
      CALL  STRACE (IENT,'REFIXY')
*
      READ (NDS, *, END=10, ERR=20) XTMP, YTMP
      IF (.NOT.LXOFFS) THEN
        XOFFS = REAL(XTMP)
        YOFFS = REAL(YTMP)
        LXOFFS = .TRUE.
      ENDIF
      XX = REAL(XTMP-DBLE(XOFFS))
      YY = REAL(YTMP-DBLE(YOFFS))
*
      IERR = 0
      RETURN
*     end of file
  10  IERR = -1
      RETURN
*     read error
  20  IERR = -2
      RETURN
* * end of subroutine REFIXY  *
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION  INFRAM (XQQ, YQQ)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
*
*  1. UPDATE
*
!     40.22: John Cazes and Tim Campbell
*
*  2. PURPOSE
*
*       Checking whether a point given in frame coordinates is located
*       in the plotting frame (INFRAM = .TRUE.) or not (INFRAM = .FALSE.)
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       XQQ     REAL   input    X-coordinate (output grid) of the point
*       YQQ     REAL   input    Y-coordinate (output grid) of the point
*
*  5. SUBROUTINES CALLING
*
*       SPLSIT, PLNAME
*
*  6. SUBROUTINES USED
*
*       none
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Give INFRAM initial value true
*       IF XQQ < 0, XQQ > XQLEN, YQQ < 0 OR YQQ > YQLEN, THEN
*           INFRAM = false
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'INFRAM')
*
      INFRAM = .TRUE.
      IF (XQQ .LT.    0.) INFRAM = .FALSE.
      IF (XQQ .GT. XQLEN) INFRAM = .FALSE.
      IF (YQQ .LT.    0.) INFRAM = .FALSE.
      IF (YQQ .GT. YQLEN) INFRAM = .FALSE.
*
      RETURN
* * end of function INFRAM *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PCOAST (CLINES, CLINER)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.81:  Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
C
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
*  2. PURPOSE
*
*       Plotting of lines defined by the command LINE
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       CLINES     int   input   line parameters
*       CLINER     real  input   line parameters
*
*  5. SUBROUTINES CALLING
*
*       PLOTX (HISWA/SWREAD) and ISOVEC (HISWA/OUTP)
*
*  6. SUBROUTINES USED
*
*       PLOTU (all HISWA/SER) and MSGERR (Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Read number of lines from array CLINES
*       For every line do
*           Read number of points of the line and line type
*           For every point of the line do
*               Call get coordinates of the point
*               If it is the first point, then
*                   Call PLOTU to move the pen to start of line
*               Else
*                   Call PLOTU to draw line segment
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER  CLINES(*), IERR                                            40.00
      REAL     CLINER(*)
      CHARACTER PTYPE *1                                                  30.51
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'PCOAST')
*
*
*     ***** locate pointset containing place names *****
      CALL DPINQA (CLINES, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &             IERR)                                                  30.81
      IF (NUMPNS .GT. 0) THEN
*       NUMPNS is the number of lines
        DO  20 JJ = 1, NUMPNS
          CALL DPINQP (CLINES, ' ', JJ, PTYPE, INX, LENREC,
     &                 IERR)                                              30.81
          MCLP   = CLINES(INX+1)
          LINTYP = CLINES(INX+2)
          PATLEN = CLINER(INX+3)
          CALL OPTYPE (LINTYP, PATLEN)
          LINCOL = CLINES(INX+4)
          CALL OPNPEN (LINCOL)
          DO 10 JP = 1, MCLP
            XP = CLINER(INX+2*JP+3)
            YP = CLINER(INX+2*JP+4)
            IF (JP.EQ.1) THEN
              CALL  PLOTU (XP, YP, 'UP')
            ELSE
              CALL  PLOTU (XP, YP, 'DOWN')
            ENDIF
   10     CONTINUE
   20   CONTINUE
      ENDIF
*
      RETURN
* * end of subroutine PCOAST *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PLOTU (XX, YY, UPDOWN)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
*
*
*  2. PURPOSE
*
*       Moving the pen to a point given in problem coordinates with pen
*       up (moving the pen) or with pen down (drawing a line segment)
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       XX      REAL   input    X-coordinate of the point
*       YY      REAL   input    Y-coordinate of the point
*       UPDOWN  CH*(*) input    indicating whether the pen must be UP or
*                                DOWN when moving to the point
*
*  5. SUBROUTINES CALLING
*
*       SPLSIT (HISWA/SWREAD) and PCOAST (HISWA/SER)
*
*  6. SUBROUTINES USED
*
*       PLOTF (Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Compute frame coordinates from problem coordinates
*       Call PLOTF to move the pen or draw the line segment
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      CHARACTER  UPDOWN *(*)
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'PLOTU')
*
*     transform from problem to frame coordinates
*
      XHLP = (XQP + COSPQ*XX + SINPQ*YY)
      YHLP = (YQP - SINPQ*XX + COSPQ*YY)
      IF (ITEST.GE.120) WRITE (PRTEST, 10) UPDOWN,
     &                  XX+XOFFS, YY+YOFFS, XHLP, YHLP
  10  FORMAT (' test PLOTU ', A4, 4(1X, E12.4))
      CALL PLOTF (XHLP, YHLP, UPDOWN)
*
      RETURN
* * end of subroutine PLOTU *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PNAMES (PLACES, PLACER)
*                                                                      *
************************************************************************
C
CDEl      INCLUDE 'ocpcomm3.inc'                                              40.04 30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
C     30.81: Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
C
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
*
*  2. PURPOSE
*
*       Plotting the names of places and regions defined with the
*       command PLACE
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       PLACES  int  arr  input   array containing places and their locations
*       PLACER  real arr  input   array containing places and their locations
*
*  5. SUBROUTINES CALLING
*
*       PLOTX (HISWA/SWREAD) and ISOVEC (HISWA/OUTP)
*
*  6. SUBROUTINES USED
*
*       PLNAME (both HISWA/SER), MSGERR and COPYCH (both Ocean
*       Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Read pointer to output data and number of names for plotting
*       For every name do
*           Call COPYCH to determine name of the place or region
*           Read coordinates, size of characters and type of name
*           Call PLNAME to plot the name
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER    PLACES(*), IERR                                          30.81
      REAL       PLACER(*)
      CHARACTER  PNAME *16, PTYPE *1                                      30.51
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE(IENT,'PNAMES')
*
*     ***** locate pointset containing place names *****
      IERR = 0                                                            30.81
      CALL DPINQA (PLACES, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &             IERR)                                                  30.81
      IF (NUMPNS .GT. 0) THEN
        DO  10 JJ = 1, NUMPNS
          PNAME = '    '
          IERR = 0                                                        30.81
          CALL DPINQP (PLACES, PNAME, JJ, PTYPE, INX, LENREC,
     &                  IERR)                                             30.81
          XP   = PLACER(INX+1)
          YP   = PLACER(INX+2)
          SIZE = PLACER(INX+3)
          ISIT = PLACES(INX+4)
          IF (ITEST .GE. 110) THEN
            WRITE (PRINTF, 6) PNAME, XP+XOFFS, YP+YOFFS, SIZE, ISIT
   6        FORMAT (' Test PNAMES ', A16, 3E12.4, I2)
          ENDIF
          CALL  PLNAME (PNAME,16,XP,YP,ISIT,SIZE)
  10    CONTINUE
      ENDIF
*
      RETURN
* * end of subroutine PNAMES *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PLNAME (PNAME, NSYM, XPP, YPP, ISIT, SYMSZ)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
*
*
*  2. PURPOSE
*
*       Writing the name of a place or region in a plot
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       PNAME   CH*(*) input    name of town or region to be plotted
*       NSYM    INT    input    number of characters of the name
*       XPP     REAL   input    X-coordinate of the reference point in
*                               the problem grid
*       YPP     REAL   input    Y-coordinate of the reference point in
*                               the problem grid
*       ISIT    INT    input    type of name (0 or 1: the name is plotted
*                               right of the reference point with (1) or
*                               without (0) a mark at the point, 2: the
*                               reference point is at the middle of the
*                               name (region))
*       SYMSZ   REAL   input    size of the characters in the plot (cm)
*
*  5. SUBROUTINES CALLING
*
*       SPLSIT (HISWA/SWREAD) and PNAMES (HISWA/SER)
*
*  6. SUBROUTINES USED
*
*       INFRAM (HISWA/SER), OPMARK and OPTEXT (both Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Compute frame coordinates of the reference point
*       If the point is in the output frame, then
*           Determine the number of characters of the name to be plotted
*           Compute size of the name in the plot (cm) and the location
*             of the reference point in the plot (in cm)
*           If ISIT = 1 (place name with mark), then
*               Call OPMARK to plot a mark at the location of the point
*               Shift reference point of name according size of mark
*           Elseif ISIT = 2 (name of region), then
*               Shift reference point of name to center
*           ------------------------------------------------------------
*           Check if the complete name is in the plotting window and
*             shift name if necessary
*           If size of name is bigger than size of frame (IERR=1), then
*               Call MSGERR to generate a warning
*           Else
*               Call OPTEXT to write the name in the plot
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      LOGICAL INFRAM
      CHARACTER  PNAME *(*)
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLNAME')
*
*     transform to output frame coordinates
*
      XQ = XQP + COSPQ*XPP + SINPQ*YPP
      YQ = YQP - SINPQ*XPP + COSPQ*YPP
      IF (INFRAM(XQ, YQ) ) THEN
        DO  10  JJ=1,NSYM
          LENS = NSYM+1-JJ
          IF (PNAME(LENS:LENS).NE.' ') GOTO 20
   10   CONTINUE
   20   XNM = LENS*SYMSZ
        YNM = SYMSZ
*       ***** determine the location of the name *****
        X1 = HORSC*XQ
        Y1 = VRTSC*YQ
        IF (ISIT.EQ.1) THEN
          CALL OPMARK (XPLO+X1, YPLO+Y1, 0.6*SYMSIZ, 1, 'UP')
          X1 = X1 + 0.35*SYMSIZ
          Y1 = Y1 + 0.3*SYMSIZ
        ELSE IF (ISIT.EQ.2) THEN
          X1 = X1 - 0.5*XNM
          Y1 = Y1 - 0.5*YNM
        ENDIF
        X2 = X1+XNM
        Y2 = Y1+YNM
*       ***** shift the name if necessary *****
        IERR = 0
        IF (X1 .LT. 0.) THEN
          X1 = 0.
          X2 = XNM
        ENDIF
        IF (Y1 .LT. 0.) THEN
          Y1 = 0.
          Y2 = YNM
        ENDIF
        IF (X2 .GT. XASL) THEN
          X1 = X1-(X2-XASL)
          IF (X1 .LT. 0.) IERR = 1
        ENDIF
        IF (Y2.GT.YASL) THEN
          Y1 = Y1-YNM
          IF (Y1.LT.0.) IERR = 1
        ENDIF
        IF (IERR.EQ.1) THEN
          WRITE (PRINTF, 6010) PNAME, XNM, YNM, XASL, YASL
 6010     FORMAT (' NAME TOO BIG FOR PLOTTING', A16,
     &            ', NAME SIZE: ', 2F6.2, ' PLOTSIZE: ', 2F6.2)
        ELSE
          CALL PLOTP (XPLO+X1, YPLO+Y1, 'UP')
          CALL OPTEXT (XPLO+X1, YPLO+Y1, SYMSZ, PNAME, 0., LENS)
        ENDIF
*
        IF (ITEST .GE. 110) THEN
          WRITE (PRINTF, 6020) PNAME, XPP+XOFFS, YPP+YOFFS, XQ, YQ,
     &                         X1, Y1, XNM, YNM
 6020     FORMAT (' Test PLNAME ', A16, 8E12.4)
        ENDIF
*
      ENDIF
*
      RETURN
* * end of subroutine PLNAME *
      END
************************************************************************
*                                                                      *
      SUBROUTINE PLOSIT (OUTPS, OUTPR, PSNAME)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.81: Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
*  1. UPDATE
C
C     01 Apr 1994   : introduced in SWAN
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C
*  2. PURPOSE
*
*       Drawing a plot with the location of the output pointsets
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       OUTPS   int  inp  array containing data on output point sets
*       OUTPR   real inp  array containing data on output point sets
*       SNAME   char inp  name of plot frame
*       PSNAME  char inp  name of one output point set to be plotted
*                         if blank, all point sets will be plotted
*
*  5. SUBROUTINES CALLING
*
*       SWPLOT
*
*  6. SUBROUTINES USED
*
*       PLNAME, PLOTU, INFRAM, COPYCH, OPMARK (all Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       If PSNAME is '    '
*       Then make IREC1 = 1
*            make IREC2 = number of existing point sets
*       Else find record number IREC corresponding to PSNAME
*            make IREC1 = IREC
*            make IREC2 = IREC
*       ----------------------------------------------------------------
*       For IREC from IREC1 to IREC2 do
*           Read name of the pointset PSNAME
*           If the pointset is not the plotting frame or the sets of
*                places or lines and the recordlength > 0
*           Then Determine pointer to pointset data
*               Read type of pointset from array OUTDA
*               If type of pointset is F (frame), then
*                   Read dimension and orientation of the frame
*                   Call PLNAME to draw the name of the frame
*                   Call PLOTU to draw the sides of the frame
*               --------------------------------------------------------
*               If the type of pointset is C (curve), then
*                   Read number of curves from array IOUTD
*                   For every curve do
*                       Read number of points of the curve
*                       For every point of the curve do
*                           Read coordinates of the point
*                           If it is the first point of the curve, then
*                               If it is the first curve, then
*                                   Call PLNAME to plot name of pointset
*                               ----------------------------------------
*                               Call PLOTU to move pen to start of curve
*                           Else
*                               Call PLOTU to draw line segment
*               --------------------------------------------------------
*               If type of pointset is P (points), then
*                   Read total number of points
*                   For every point do
*                       Read problem coordinates
*                       Compute frame coordinates
*                       If the point is in the frame, then
*                           If it is the first point, then
*                               Call PLNAME to plot name of the pointset
*                           --------------------------------------------
*                           Call OPMARK to plot the point
*               --------------------------------------------------------
*               If the type of pointset is R (ray), then
*                   Read the number of rays
*                   For the first and last ray do
*                       Read coordinates of end points
*                       If it is the first ray, then
*                           Call PLNAME to plot the pointset name
*                       ------------------------------------------------
*                       Call PLOTU to move pen to start of ray
*                       Call PLOTU to draw the ray
*               --------------------------------------------------------
*               If type of pointset is G (grid), then
*                   Read dimension and orientation of the grid
*                   Call PLNAME to draw the name of the grid
*                   Call PLOTU to draw the sides of the grid
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER   OUTPS(*), IERR                                                30.81
      REAL      OUTPR(*)
      LOGICAL   INFRAM, GIVEN
      CHARACTER PSNAME *8, PSTYPE *1, PTYPE *1
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLOSIT')
*
      SYMSIZ = 0.28
      IF (PSNAME .EQ. '    ') THEN
        CALL DPINQA (OUTPS, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &               IERR)                                                30.81
        IF (NUMPNS.EQ.0) THEN
          CALL MSGERR (2, 'No output points found')
          RETURN
        ENDIF
        IREC1 = 1
        IREC2 = NUMPNS
        GIVEN = .FALSE.
      ELSE
        IREC = 0
        CALL DPINQP (OUTPS, PSNAME, IREC, PTYPE, IOUTF, LENREC,
     &               IERR)                                                30.81
        IF (IREC.EQ.0) THEN
          WRITE (PRINTF, 15) PSNAME
  15      FORMAT (' non-existing point set: ', A8)
          RETURN
        ENDIF
        IREC1 = IREC
        IREC2 = IREC
        GIVEN = .TRUE.
      ENDIF
*
      DO 100 IREC = IREC1, IREC2
        IF (.NOT.GIVEN) THEN
*         find name of point set for IREC
          IERR = 0                                                         30.81
          PSNAME = '    '
          CALL DPINQP (OUTPS, PSNAME, IREC, PTYPE, IOUTF, LENREC,
     &                 IERR)                                              30.81
        ENDIF
*
        IF (ITEST .GE. 60) THEN
          WRITE (PRINTF, 21) IREC, PSNAME, LENREC, SNAME
  21      FORMAT (' Test PLOSIT ',I2, 1X, A, I6, 2X, A8)
        ENDIF
*
        IF (PSNAME.NE.SNAME .AND. LENREC.NE.0) THEN
*
*         ***** determine type of output pointset *****
          PSTYPE = CHAR (OUTPS(IOUTF+1))
          IF (ITEST .GE. 60) THEN
            WRITE (PRINTF, 23) IREC, PSNAME, PSTYPE
  23        FORMAT (' Test PLOSIT ',I2, 1X, A, 2X, A1)
          ENDIF
*
*         ***** type FRAME *****
          IF (PSTYPE .EQ. 'F') THEN
            XKLEN = OUTPR(IOUTF+2)
            YKLEN = OUTPR(IOUTF+3)
            XPK   = OUTPR(IOUTF+4)
            YPK   = OUTPR(IOUTF+5)
            ALPK  = OUTPR(IOUTF+6)
            COSA  = COS(ALPK)
            SINA  = SIN(ALPK)
            CALL  PLNAME (PSNAME, 8, XPK, YPK, 0, SYMSIZ)
            CALL  PLOTU (XPK, YPK, 'UP')
            CALL  PLOTU (XPK+XKLEN*COSA, YPK+XKLEN*SINA, 'DOWN')
            CALL  PLOTU (XPK+XKLEN*COSA-YKLEN*SINA,
     &                  YPK+XKLEN*SINA+YKLEN*COSA, 'DOWN')
            CALL  PLOTU (XPK-YKLEN*SINA, YPK+YKLEN*COSA, 'DOWN')
            CALL  PLOTU (XPK, YPK, 'DOWN')
            GOTO 100
          ENDIF
*
*         ***** type CURVE *****
          IF (PSTYPE .EQ. 'C') THEN
            MIP = OUTPS(IOUTF+2)
            DO  40  IP = 1, MIP
              XP = OUTPR(IOUTF+2*IP+1)
              YP = OUTPR(IOUTF+2*IP+2)
              IF (IP .EQ. 1) THEN
                CALL PLNAME (PSNAME,8,XP,YP,0,SYMSIZ)
                CALL PLOTU (XP, YP, 'UP')
              ELSE
                CALL PLOTU (XP, YP, 'DOWN')
              ENDIF
  40        CONTINUE
            GOTO 100
          ENDIF
*
*       ***** type POINTS *****
          IF (PSTYPE .EQ. 'P') THEN
            MIP = OUTPS(IOUTF+2)
            DO  50  IP = 1, MIP
              XP  = OUTPR(IOUTF+2*IP+1)
              YP  = OUTPR(IOUTF+2*IP+2)
              XPA = XQP + COSPQ*XP + SINPQ*YP
              YPA = YQP - SINPQ*XP + COSPQ*YP
              IF (INFRAM(XPA, YPA)) THEN
                XPA = HORSC * XPA
                YPA = VRTSC * YPA
*
                IF (IP.EQ.1) CALL PLNAME (PSNAME, 8, XP, YP, 0, SYMSIZ)
                CALL OPMARK (XPLO+XPA, YPLO+YPA, SYMSIZ, 3, 'UP')
              ENDIF
              IF (ITEST.GE.120) THEN
                WRITE (PRINTF, 46) PSTYPE, IP, XP+XOFFS, YP+YOFFS,
     &                             XPA, YPA
  46            FORMAT (' Test PLOSIT ', A1, I6, 4E12.4)
              ENDIF
  50        CONTINUE
            GOTO 100
          ENDIF
*
*         ***** type NESTED GRID *****                                    20.76
          IF (PSTYPE .EQ. 'N') THEN                                       20.76
            MIP   = OUTPS(IOUTF+2)
            XKLEN = OUTPR(IOUTF+2*MIP+3)
            YKLEN = OUTPR(IOUTF+2*MIP+4)
            XPK   = OUTPR(IOUTF+2*MIP+7)
            YPK   = OUTPR(IOUTF+2*MIP+8)
            ALPK  = OUTPR(IOUTF+2*MIP+9)
            COSA  = COS(ALPK)
            SINA  = SIN(ALPK)
            IF (ITEST.GE.60) WRITE (PRTEST, 64) MIP, XKLEN, YKLEN,
     &                  XPK+XOFFS, YPK+YOFFS, ALPK*180./PI
  64        FORMAT (' Nested grid:', I4, 6F9.2)
            CALL  PLNAME (PSNAME, 8, XPK, YPK, 0, SYMSIZ)
            CALL  PLOTU (XPK, YPK, 'UP')
            CALL  PLOTU (XPK+XKLEN*COSA, YPK+XKLEN*SINA, 'DOWN')
            CALL  PLOTU (XPK+XKLEN*COSA-YKLEN*SINA,
     &                  YPK+XKLEN*SINA+YKLEN*COSA, 'DOWN')
            CALL  PLOTU (XPK-YKLEN*SINA, YPK+YKLEN*COSA, 'DOWN')
            CALL  PLOTU (XPK, YPK, 'DOWN')
            GOTO 100
          ENDIF
        ENDIF
  100 CONTINUE
*
      RETURN
* * end of subroutine PLOSIT *
      END
************************************************************************
*                                                                      *
      SUBROUTINE DISTR (CDIR, DIR, COEF, SPCDIR)                          20.43
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C
C  0. Authors
C
C     30.82: IJsbrand Haagsma
!     40.22: John Cazes and Tim Campbell
C
*  1. Updates
*
*      0.1 , Jul. 87: Standard heading added
*      0.2 , Dec. 89: Value for energy outside of the sector changed
*                     from 0. to 1.E-6
*            Oct. 90: Value for energy outside the sector changed to 1.E-10
*                     logical BDIR introduced to take care for case where
*                     none of the values is positive
C     30.82, Oct. 98: Updated description of several variables
*
*  2. PURPOSE
*
*       Computation of the distribution of the wave energy over the
*       sectors, according to the given directional spread.
*
*  3. METHOD
*
*       ---
*
*  4. Argument variables
*
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
C
*       CDIR    REAL   output   array containing the coefficients of
*                               (energy) distribution
*       DIR     REAL   input    main wave direction, in radians
*       COEF    REAL   input    coefficient of the directional distri-
*                               bution (cos**COEF)
*
*  5. SUBROUTINES CALLING
*
*       REINVA (HISWA/SWREAD), STARTB and SWIND (both HISWA/COMPU)
*
*  6. SUBROUTINES USED
*
*       none
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       For every direction of the grid do
*           If the direction deviates less than PI/2 from the main wave
*            direction, then
*               Compute the coefficient cos**n
*           Else
*               Coefficient is 1.E-10
*       -----------------------------------------------------------------
*       If any of the directions deviated less than PI/2
*       Then Compute the total of the coefficients
*            For every direction of the grid do
*                Divide the fraction of the distribution by the total
*       -----------------------------------------------------------------
*
C 13. Source text
C
      LOGICAL BDIR
      REAL CDIR(*)
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT, 'DISTR')
*
      SOMC = 0.
      BDIR = .FALSE.
      DO 10 ID0 = 1, MDC
        TETA = SPCDIR(ID0,1)
        ACOS = COS(TETA-DIR)
        IF (ACOS .GT. 0.) THEN
          BDIR = .TRUE.
          CDIR(ID0) = MAX (ACOS**COEF, 1.E-10)
          SOMC = SOMC + CDIR(ID0)
        ELSE
          CDIR(ID0) = 1.E-10
        ENDIF
  10  CONTINUE
      IF (BDIR) THEN
        CNORM = 1./(SOMC*DDIR)
        DO 20 ID0 = 1, MDC
          CDIR(ID0) = CDIR(ID0) * CNORM
  20    CONTINUE
      ENDIF
*
*     ***** test *****
*      IF(TESTFL .AND. ITEST .GE. 200)
       IF( ITEST .GE. 200)
     &WRITE(PRINTF,6010) CNORM,(CDIR(JJ) , JJ=1,MDC)
 6010   FORMAT (' Test DISTR',F10.3/(10E12.4))
*
      RETURN
* * end of subroutine DISTR *
      END
C***********************************************************************
C                                                                      *
      SUBROUTINE KSCIP1 (MMT, SIG, D, K, CG, N, ND)
C                                                                      *
C***********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C  0. Authors
C
C     30.81:  Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     Aug. 94, ver. 10.10: arguments N and ND added
C     Dec. 98, ND corrected, argument list adjusted and IMPLICIT NONE added
C
C  2. Purpose
C
C     Interpolation of the wave number, group velocity and N from a
C     table, and calculation of the derivative of N w.r.t. depth (=ND)
C
C  3. Method
C
C     --
C
C  4. Argument variables
C
C     MMT     input    number of points in freq. for which
C
      INTEGER   MMT
C
C     CG      output   group velocity
C     D       input    local depth
C     K       output   wave number
C     N       output   ratio of group and phase velocity
C     ND      output   derivative of N with respect to D
C                      computation must be done
C     SIG     input    rel. frequency for which wave parameters
C                      must be determined
C
      REAL      CG(MMT), D,
     &          K(MMT), N(MMT), ND(MMT), SIG(MMT)
C
C  5. Parameter variables
C
C     NWMAX
C     NWMIN
C
      INTEGER   NWMAX, NWMIN
      PARAMETER (NWMIN = 0, NWMAX = 25)
C
C     DWND
C     RPDW
C
      REAL      DSND, RPDW
      PARAMETER (DSND = 0.1, RPDW=1./DSND)
C
C  6. Local variables
C
C     CGND      dimensionless group velocity
C     CGTB1D    coefficients for calculating group velocity
C     DIFN      dummy variable
C     FAC       factor used for interpolation of tables
C     IENT      number of entries
C     INPW      integer part of WND*RPDW (used for coefficient tables)
C     IS        counter in frequency (sigma-space)
C     KND       dimensionless wave number
C     KTAB1D    coefficients for calculating wave number
C     NTAB1D    coefficients for calculating ratio of group and phase
C               velocity
C     ROOTDG    square root of D/GRAV
C     WFAC      =WND*RPDW
C     WGD       square root of GRAV*D
C     SND       dimensionless frequency
C     WND2      = WND*WND
C
      INTEGER   IENT, INPW, IS
      REAL      CGND, CGTB1D(NWMIN:NWMAX),
     &          DIFN,                                                      30.81
     &          FAC, KND, KTAB1D(NWMIN:NWMAX),
     &          NTAB1D(NWMIN:NWMAX), ROOTDG, SND, WFAC, WGD,
     &          SND2                                                       30.81
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     SWOEXA, SWOEXF (Swan/Output)
C
C 10. Error messages
C
C     --
C
C 11. Remarks
C
C     --
C
C 12. Structure
C
C     -----------------------------------------------------------------
C      Compute non-dimensional frequency WND
C      IF WND >= 2.5, then
C        Compute wave number K, group velocity CGO, ratio of group
C        and phase velocity N and its derivative ND according to
C        deep water theory
C      ELSE IF WND =< 1.e-6
C        Compute wave number K, group velocity CGO, ratio of group
C        and phase velocity N and its derivative ND
C        according to extremely shallow water
C      ELSE
C        Compute wave number K, group velocity CGO and the ratio of
C        group and phase velocity N by interpolation from 1-dimensio-
C        nal tables. Compute the derivative of N w.r.t. D = ND.
C     -----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT /0/
      DATA KTAB1D/0., 0.10016680, 0.20134288, 0.30457264, 0.41096926,
     &    0.52175194, 0.63846463, 0.76255310, 0.89595461, 1.04083824,
     &    1.19967842, 1.37519836, 1.57023048, 1.78743458, 2.02877331,
     &    2.29598522, 2.58901024, 2.90728855, 3.24976063, 3.61523247,
     &    4.00267029, 4.41130257, 4.84030056, 5.29013348, 5.76005936,
     &    6.25002289/
      DATA CGTB1D/1., 0.99501032, 0.98015553, 0.95579094, 0.92251045,
     &    0.88116169, 0.83277500, 0.77876240, 0.72069371, 0.66038823,
     &    0.59983897, 0.54110348, 0.48613495, 0.43655658, 0.39344674,
     &    0.35705268, 0.32704252, 0.30251282, 0.28235823, 0.26552880,
     &    0.25116783, 0.23864383, 0.22752625, 0.21749985, 0.20837778,
     &    0.20001733/
      DATA NTAB1D/1., 0.9966699 , 0.9867362 , 0.9703590 , 0.9478084 ,
     &    0.9194954 , 0.8861622 , 0.8483538 , 0.8071360 , 0.7637302 ,
     &    0.7196137 , 0.6764768 , 0.6361198 , 0.6002431 , 0.5701529 ,
     &    0.5465249 , 0.5291977 , 0.5173482 , 0.5097758 , 0.5052359 ,
     &    0.5026709 , 0.5013000 , 0.5005887 , 0.5002621 , 0.5001116 ,
     &    0.500045/
      IF (LTRACE) CALL STRACE (IENT, 'KSCIP1')
C
      ROOTDG = SQRT(D/GRAV)                                               30.81
      WGD    = ROOTDG*GRAV                                                30.81
      DO 200 IS = 1, MMT
C       WND is dimensionless frequency
        SND = SIG(IS) * ROOTDG
        IF (SND .GE. 2.5) THEN
C     ******* deep water *******
          K(IS)  = SIG(IS) * SIG(IS) / GRAV                                   30.81
          CG(IS) = 0.5 * GRAV / SIG(IS)                                     30.81
          N(IS)  = 0.5
          ND(IS) = 0.
        ELSE IF (SND.LT.1.E-6) THEN
C     *** very shallow water ***                                          30.81
          K(IS)  = SND/D                                                  30.81
          CG(IS) = WGD
          N(IS)  = 1.
          ND(IS) = 0.
        ELSE
          WFAC = SND * RPDW
          INPW = INT(WFAC)
          FAC  = WFAC - FLOAT(INPW)
            KND  = (1.-FAC)*KTAB1D(INPW) + FAC*KTAB1D(INPW+1)
            CGND = (1.-FAC)*CGTB1D(INPW) + FAC*CGTB1D(INPW+1)
            N(IS)  = (1.-FAC)*NTAB1D(INPW) + FAC*NTAB1D(INPW+1)
          K(IS)  = KND/D                                                  30.81
          CG(IS) = CGND * WGD
C
C         Analytical solution:                                            30.81
C           ND(IS) = K(IS)/SINH(2*K(IS)*D)*(1 - KD2/TANH(2*K(IS)*D))      30.81
C                  = (d N / d WND) * (d WND / d D)                        30.81
C                                                                         30.81
          SND2 = SND*SND                                                  30.81
            DIFN = (NTAB1D(INPW+1) - NTAB1D(INPW)) / DSND                 30.81
          ND(IS) = DIFN*0.5*(D*K(IS)*K(IS) + SND2*(1.-SND2)/D)/SND        30.81
        ENDIF
  200 CONTINUE
C
      RETURN
C     end of subroutine KSCIP1 *
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE AC2TST (XYTST, AC2,KGRPNT)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C     0. Authors
C
C
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*
*
      INTEGER   XYTST(*) ,KGRPNT(MXC,MYC)
      REAL      AC2(MDC,MSC,MCGRD)                                        30.21
*.................................................................
      IF ( ITEST .GE. 100 .AND. TESTFL) THEN
        DO II = 1, NPTST
          IX = XYTST(2*II-1)
          IY = XYTST(2*II)
          INDEX = KGRPNT(IX,IY)
          WRITE (PRINTF, 618) IX , IY-1, KGRPNT(IX,IY)
 618      FORMAT(/,'Spectrum for test point(index):', 2I5,2X,'(',I5,')')
          DO ID = 1, MDC
            WRITE (PRINTF, 619) (AC2(ID,IS,INDEX), IS=1,MIN(10,MSC))      30.21
 619        FORMAT (10(1X,E12.4))
          ENDDO
        ENDDO
      ENDIF
      RETURN
      END
C****************************************************************
C
      SUBROUTINE CVCHEK (KGRPNT, XCGRID, YCGRID)                          30.72
C
C****************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     40.13: Nico Booij
C
C  1. Updates
C
C            May  96: New subroutine
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.13, Mar. 01: messages corrected and extended
C
C  2. Purpose
C
C     Checks whether the given curvilinear grid is correct
C     also set the value of CVLEFT.
C
C  3. Method
C
C     Going around a mesh in the same direction the interior
C     of the mesh must be always in the same side if the
C     coordinates are correct
C
C  4. Argument variables
C
C     KGRPNT: input  Array of indirect addressing
C
      INTEGER KGRPNT(MXC,MYC)                                             30.72
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C
C     5. SUBROUTINES CALLING
C
C        SWRBC
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
*     FIRST = True
*     For ix=1 to MXC-1 do
*         For iy=1 to MYC-1 do
*             Inmesh = True
*             For iside=1 to 4 do
*                 Case iside=
*                 1: K1 = KGRPNT(ix,iy), K2 = KGRPNT(ix+1,iy),
*                    K3 = KGRPNT(ix+1,iy+1)
*                 2: K1 = KGRPNT(ix+1,iy), K2 = KGRPNT(ix+1,iy+1),
*                    K3 = KGRPNT(ix,iy+1)
*                 3: K1 = KGRPNT(ix+1,iy+1), K2 = KGRPNT(ix,iy+1),
*                    K3 = KGRPNT(ix,iy)
*                 4: K1 = KGRPNT(ix,iy+1), K2 = KGRPNT(ix,iy),
*                    K3 = KGRPNT(ix+1,iy)
*                 ---------------------------------------------------
*                 If K1>1 and K2>1 and K3>1
*                 Then Det = (xpg(K3)-xpg(K1))*(ypg(K2)-ypg(K1)) -
*                            (ypg(K3)-ypg(K1))*(xpg(K2)-xpg(K1))
*                      If FIRST
*                      Then Make FIRST = False
*                           If Det>0
*                           Then Make CVleft = False
*                           Else Make CVleft = True
*                      ----------------------------------------------
*                      If ((CVleft and Det<0) or (not CVleft and Det>0))
*                      Then Write error message with IX, IY, ISIDE
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C****************************************************************
C
C
      LOGICAL  FIRST
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'CVCHEK')
*
*     test output
*
      IF (ITEST .GE. 150 .OR. INTES .GE. 30) THEN
        WRITE(PRINTF,186)
 186    FORMAT(/,' ... Subroutine CVCHEK...',
     &  /,2X,'POINT( IX, IY),  INDEX,      COORDX,       COORDY')
        ICON = 0
        DO 5 IIY = 1, MYC
          DO 6 IIX = 1, MXC
            ICON = ICON + 1
            WRITE(PRINTF,7)IIX-1,IIY-1,KGRPNT(IIX,IIY),
     &      XCGRID(IIX,IIY)+XOFFS, YCGRID(IIX,IIY)+YOFFS                  30.72 40.13
 6        CONTINUE
 5      CONTINUE
      ENDIF
 7    FORMAT(4X,I5,1X,I5,3X,I4,5X,F10.2,4X,F10.2)
C
      FIRST = .TRUE.
C
      DO 10 IX = 1,MXC-1
        DO 15 IY = 1,MYC-1
          DO 20 ISIDE = 1,4
            IF (ISIDE .EQ. 1) THEN
              IX1 = IX                                                    40.13
              IY1 = IY                                                    40.13
              IX2 = IX+1                                                  40.13
              IY2 = IY                                                    40.13
              IX3 = IX+1                                                  40.13
              IY3 = IY+1                                                  40.13
            ELSE IF (ISIDE .EQ. 2) THEN
              IX1 = IX+1                                                  40.13
              IY1 = IY                                                    40.13
              IX2 = IX+1                                                  40.13
              IY2 = IY+1                                                  40.13
              IX3 = IX                                                    40.13
              IY3 = IY+1                                                  40.13
            ELSE IF (ISIDE .EQ. 3) THEN
              IX1 = IX+1                                                  40.13
              IY1 = IY+1                                                  40.13
              IX2 = IX                                                    40.13
              IY2 = IY+1                                                  40.13
              IX3 = IX                                                    40.13
              IY3 = IY                                                    40.13
            ELSE IF (ISIDE .EQ. 4) THEN
              IX1 = IX                                                    40.13
              IY1 = IY+1                                                  40.13
              IX2 = IX                                                    40.13
              IY2 = IY                                                    40.13
              IX3 = IX+1                                                  40.13
              IY3 = IY                                                    40.13
            ENDIF
            K1  = KGRPNT(IX1,IY1)                                         40.13
            XC1 = XCGRID(IX1,IY1)                                         40.13 30.72
            YC1 = YCGRID(IX1,IY1)                                         40.13 30.72
            K2  = KGRPNT(IX2,IY2)                                         40.13
            XC2 = XCGRID(IX2,IY2)                                         40.13 30.72
            YC2 = YCGRID(IX2,IY2)                                         40.13 30.72
            K3  = KGRPNT(IX3,IY3)                                         40.13
            XC3 = XCGRID(IX3,IY3)                                         30.72
            YC3 = YCGRID(IX3,IY3)                                         30.72
            DET   = 0.
            IF (K1 .GE. 2 .AND. K2 .GE. 2 .AND. K3 .GE. 2) THEN
              DET = ((XC3 - XC1) * (YC2 - YC1)) -
     &              ((YC3 - YC1) * (XC2 - XC1))
              IF (DET .EQ. 0.) THEN
!               three grid points on one line                             40.13
                CALL MSGERR (2,'3 comp. grid points on one line')         40.13
                WRITE (PRINTF, 112)
     &               IX1-1, IY1-1, XC1+XOFFS, YC1+YOFFS,                  40.13
     &               IX2-1, IY2-1, XC2+XOFFS, YC2+YOFFS,                  40.13
     &               IX3-1, IY3-1, XC3+XOFFS, YC3+YOFFS                   40.13
 112            FORMAT (3(1X, 2I3, 2(1X, F14.4)))                         40.13
              ENDIF
C
              IF (FIRST) THEN
                FIRST = .FALSE.
                IF (DET .GT. 0.) THEN
                  CVLEFT = .FALSE.
                ELSE
                  CVLEFT = .TRUE.
                ENDIF
              ENDIF
              IF (     (      CVLEFT .AND. DET .GT. 0.)
     &            .OR. (.NOT. CVLEFT .AND. DET .LT. 0.)) THEN
!               crossing grid lines in a mesh                             40.13
                CALL MSGERR (2,'Grid angle <0 or >180 degrees')           40.13
                WRITE (PRINTF, 112)
     &               IX1-1, IY1-1, XC1+XOFFS, YC1+YOFFS,                  40.13
     &               IX2-1, IY2-1, XC2+XOFFS, YC2+YOFFS,                  40.13
     &               IX3-1, IY3-1, XC3+XOFFS, YC3+YOFFS                   40.13
              ENDIF
            ENDIF
 20       CONTINUE
 15     CONTINUE
 10   CONTINUE
      RETURN
*     *** end of subroutine CVCHEK ***
      END
************************************************************************
*                                                                      *
      SUBROUTINE CVMESH (XP, YP, XC, YC, KGRPNT, XCGRID ,YCGRID,
     &                   KGRBND)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     40.00, 40.13: Nico Booij
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     30.21, Jun. 96: New for curvilinear version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, May  98: procedure for points outside grid accelerated
C     40.00, Feb  99: procedure extended for 1D case
C                     XOFFS and YOFFS added in write statements
C     40.02, Mar. 00: Fixed bug that placed dry testpoints outside computational grid
C     40.13, Mar. 01: message "CVMESH 2nd attempt .." suppressed
C
*  2. Purpose
*
*     procedure to find location in curvilinear grid for a point
*     given in problem coordinates
*
*  3. Method
*
*     First attempt: Use Newton-Raphson method to find XC and YC
*     (Note: in the program XC and YC indicate the mesh and position in
*     the mesh) in a few steps; this may be most efficient if a series of
*     points is processed, because the previous point provides a good
*     first estimate.
*
*     The procedure may fail for one reason:
*     a) the number of iterations is larger than a previously set limit,
*        say 10.
*
*     If the Newton-Raphson procedure fails, a second attempt:
*     Scan all meshes of the grid to find whether XP,YP is inside the mesh.
*     A point is assumed to be inside a mesh if it is on the
*     interior side for all 4 sides of the mesh. Here we use common variable
*     CVLEFT (logical): if True interior of the mesh is always on the left
*     going along the mesh in the order: (ix,iy), (ix+1,iy), (ix+1,iy+1),
*     (ix,iy+1), (ix,iy). If it is False the interior is always on the right.
*     Whether a point  is on the left or on the right of a line from  to
*     can be decided by looking at the sign of the determinant.
*       If the point is inside of any mesh of the computational grid then
*     newton-raphson procedure is used again with the pivoting point like
*     first guess.
*
C  4. Argument variables
C
C     XCGRID  input  Coordinates of computational grid in x-direction     30.72
C     YCGRID  input  Coordinates of computational grid in y-direction     30.72
C     XP, YP  input  a point given in problem coordinates
C     XC, YC  outp   same point in computational grid coordinates
C
      REAL     XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                        30.72
      REAL     XP, YP, XC, YC
C
C     KGRPNT   input   array(MXC,MYC)  grid numbers
C                      if KGRPNT <= 1, point is not in comp. grid.
C     KGRBND   input   lists all boundary grid points consecutively
C
      INTEGER  KGRPNT(MXC,MYC), KGRBND(*)                                 40.00
C
C     Local variables
C
C     MXITNR   number of iterations in Newton-Raphson procedure
C     IX, IY   counter of computational grid point
C     K1       address of grid point
C     IXMIN    counter of grid point closest to (XP,YP)
C     IYMIN    counter of grid point closest to (XP,YP)
C     IBND     counter of boundary grid points
C
      INTEGER       :: IX, IY, K1, IXMIN, IYMIN, IBND
      INTEGER, SAVE :: MXITNR = 0
      INTEGER, SAVE :: IENT = 0
C
C     INMESH   if True, point (XP,YP) is inside the computational grid
C     FINDXY   if True, Newton-Raphson propcedure succeeded
C
      LOGICAL  INMESH ,FINDXY
C
C     XCSAVE   XC computed for previous point, used as first guess
C     YCSAVE   YC computed for previous point, used as first guess
C     XPC1     user coordinate of a computational grid point
C     YPC1     user coordinate of a computational grid point
C     XC0      grid coordinate of grid point closest to (XP,YP)
C     YC0      grid coordinate of grid point closest to (XP,YP)
C
      REAL       :: XPC1, YPC1, XC0, YC0
      REAL, SAVE :: XCSAVE, YCSAVE
C
C  5. SUBROUTINES CALLING
C
C     SINCMP
C
C  6. SUBROUTINES USED
C
C       NEWTON
C
C  7. ERROR MESSAGES
C
C       ---
C
C  8. REMARKS
C
C       XCSAVE and YCSAVE are used as first guess of XC and YC
C       values are declared SAVE
C
C  9. STRUCTURE
C
C     --------------------------------------------------------------
C     Make XC=XCSAVE and YC=YCSAVE
C     Determine XC and YC FROM XP AND YP using a Newton-Raphson iteration
C     If (XC and YC were found) then
C       Procedure is ready; Return values of XC and YC
C       Make XCSAVE=XC and YCSAVE=YC
C       return
C     else
C     ---------------------------------------------------------------------
C     For ix=1 to MXC-1 do
C         For iy=1 to MYC-1 do
C             Inmesh = True
C             For iside=1 to 4 do
C                 Case iside=
C                 1: K1 = KGRPNT(ix,iy), K2 = KGRPNT(ix+1,iy)
C                 2: K1 = KGRPNT(ix+1,iy), K2 = KGRPNT(ix+1,iy+1)
C                 3: K1 = KGRPNT(ix+1,iy+1), K2 = KGRPNT(ix,iy+1)
C                 4: K1 = KGRPNT(ix,iy+1), K2 = KGRPNT(ix,iy)
C                 ----------------------------------------------------------
C                 If K1>0 and K2>0
C                 Then Det = (xp-xpg(K1))*(ypg(K2)-ypg(K1)) -
C                            (yp-ypg(K1))*(xpg(K2)-xpg(K1))
C                      If ((CVleft and Det>0) or (not CVleft and Det<0))
C                      Then Make Inmesh = False
C                      Else  Inmesh = true and XC = IX and YC = IY
C                 Else Make Inmesh = False
C             --------------------------------------------------------
C             If Inmesh
C             Then Determine XC and YC using one Newton-Raphson iteration
C                  step
C                  Procedure is ready; Return values of XC and YC
C                  Make XCSAVE=XC and YCSAVE=YC
C     ---------------------------------------------------------------------
C     No mesh is found: Make XC and YC = exception value for XC
C     Return values of XC and YC
C     ---------------------------------------------------------------------
C
C****************************************************************
C
C
      IF (LTRACE) CALL STRACE (IENT,'CVMESH')
C
      IF (ONED) THEN
        CALL NEWT1D  (XP, YP, XCGRID, YCGRID, KGRPNT,                     40.00
     &                MXITNR ,XC ,YC ,FINDXY)
        IF (.NOT.FINDXY) THEN
          XC = -99.
          YC = -99.
          IF (ITEST .GE. 150 .OR. INTES .GE. 20) THEN
            WRITE(PRINTF, 85) XP+XOFFS, YP+YOFFS                          40.00
          ENDIF
        ENDIF
      ELSE
*       two-dimensional computation
        IF (XCSAVE .LE. MXC .AND. XCSAVE .GE. 0. .OR.
     &      YCSAVE .LE. MYC .AND. YCSAVE .GE. 0.) THEN
          XC     = XCSAVE
          YC     = YCSAVE
*         *** First attempt, to find XC ,YC with Newton-Raphson method**
          MXITNR = 5
          CALL NEWTON  (XP, YP, XCGRID, YCGRID, KGRPNT,                   40.00
     &                  MXITNR ,XC ,YC ,FINDXY, KGRBND)                   40.02
          IF ((ITEST .GE. 150 .OR. INTES .GE. 20) .AND. FINDXY) THEN      40.02
            WRITE(PRINTF,25) XP+XOFFS ,YP+YOFFS ,XC ,YC                   40.03
          ENDIF
 25       FORMAT (' CVMESH: (XP,YP)=','(',E9.2,',',E9.2,
     &            '), (XC,YC)=','(',F9.2,',',F9.2,')')
C
          IF (FINDXY) GO TO 80
        ENDIF
*
        IF (INMESH (XP, YP, XCGRID ,YCGRID, KGRBND)) THEN
*         select grid point closest to (XP,YP)
          DISMIN = 1.E20
          DO 50 IX = 1,MXC
            DO 40 IY = 1,MYC
              K1  = KGRPNT(IX,IY)
              IF (K1.GT.1) THEN
                XPC1 = XCGRID(IX,IY)
                YPC1 = YCGRID(IX,IY)
                DISXY = SQRT ((XP-XPC1)**2 + (YP-YPC1)**2)
                IF (DISXY .LT. DISMIN) THEN
                  IXMIN  = IX
                  IYMIN  = IY
                  DISMIN = DISXY
                ENDIF
              ENDIF
  40        CONTINUE
  50      CONTINUE
*         second attempt using closest grid point as first guess
          MXITNR = 20
          XC0 = REAL(IXMIN)
          YC0 = REAL(IYMIN)
!         ITEST condition changed from 20 to 120                          40.13
          IF (ITEST.GE.120) WRITE (PRTEST, 55) XP+XOFFS ,YP+YOFFS ,       40.13
     &          XC0-1. ,YC0-1.
  55      FORMAT (' CVMESH 2nd attempt, (XP,YP)=','(',E9.2,',',E9.2,
     &          '), (XC,YC)=','(',F9.2,',',F9.2,')')
          DO KORNER = 1, 4
            IF (KORNER.EQ.1) THEN
              XC = XC0 + 0.2
              YC = YC0 + 0.2
            ELSE IF (KORNER.EQ.2) THEN
              XC = XC0 - 0.2
              YC = YC0 + 0.2
            ELSE IF (KORNER.EQ.3) THEN
              XC = XC0 - 0.2
              YC = YC0 - 0.2
            ELSE
              XC = XC0 + 0.2
              YC = YC0 - 0.2
            ENDIF
            CALL NEWTON  (XP, YP, XCGRID, YCGRID, KGRPNT,                 40.00
     &                    MXITNR ,XC ,YC ,FINDXY, KGRBND)                 40.02
            IF (FINDXY) THEN
              IF (ITEST .GE. 150 .OR. INTES .GE. 20) THEN
                WRITE(PRINTF,25) XP+XOFFS ,YP+YOFFS ,XC ,YC               40.00
              ENDIF
              GOTO 80
            ENDIF
          ENDDO
          WRITE (PRINTF, 75) XP+XOFFS, YP+YOFFS, MXITNR                   40.00
  75      FORMAT (' search of grid coordinates fails for:', 2F10.2,
     &            ' in', I3, ' iterations')
        ELSE
*         scan boundary to see whether the point is close to the boundary
          IX2 = 0
          DO IBND = 1, NGRBND
            IX1 = IX2
            IY1 = IY2
            XP1 = XP2
            YP1 = YP2
            IX2 = KGRBND(2*IBND-1)
            IY2 = KGRBND(2*IBND)
            IF (IX2.GT.0) THEN
              XP2 = XCGRID(IX2,IY2)
              YP2 = YCGRID(IX2,IY2)
              IF (IX1.GT.0) THEN
*               determine relative distance from boundary section
                SLEN2  = (XP2-XP1)**2 + (YP2-YP1)**2
                RELDIS = ((XP-XP1)*(YP2-YP1)-(YP-YP1)*(XP2-XP1)) / SLEN2
                IF (ABS(RELDIS).LT.0.2) THEN
C                 determine location on the boundary section
                  RELLOC = ((XP-XP1)*(XP2-XP1)+(YP-YP1)*(YP2-YP1)) /
     &                      SLEN2
                  IF (RELLOC.GE.0. .AND. RELLOC.LE.1.) THEN
                    XC = FLOAT(IX1) + RELLOC * FLOAT(IX2-IX1) - 1.
                    YC = FLOAT(IY1) + RELLOC * FLOAT(IY2-IY1) - 1.
                    IF (ITEST .GE. 150 .OR. INTES .GE. 20) THEN
                      WRITE(PRINTF, 65) XP+XOFFS, YP+YOFFS, XC, YC        40.00
  65                  FORMAT (' CVMESH: (XP,YP)=','(',E9.2,',',E9.2,
     &                        ') is on the boundary, (XC,YC)=(',
     &                        F9.2,',',F9.2,')')
                    ENDIF
                    GOTO 80
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDDO
          XC = -99.
          YC = -99.
          IF (ITEST .GE. 150 .OR. INTES .GE. 20) THEN
            WRITE(PRINTF, 85) XP+XOFFS, YP+YOFFS                          40.00
  85        FORMAT (' CVMESH: (XP,YP)=','(',E9.2,',',E9.2,
     &              ') is outside grid')
          ENDIF
        ENDIF
      ENDIF                                                               40.00
  80  XCSAVE = XC
      YCSAVE = YC
      RETURN
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION INMESH (XP, YP, XCGRID ,YCGRID, KGRBND)
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm2.inc'                                               40.03
      INCLUDE 'swcomm3.inc'
      INCLUDE 'ocpcomm4.inc'                                              40.03
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     Nico Booij
C
C  1. Updates
C
C       New function for curvilinear version (ver. 40.00). May '98
C       40.03, Dec 99: test output added; commons swcomm2 and ocpcomm4 added
C
C  2. Purpose
C
C       procedure to find whether a given location is
C       in the (curvilinear) computational grid
C
C  3. Method  suggested by Gerbrant van Vledder
C
C       draw a line from the point (XP,YP) in vertical direction
C       determine the number of crossings with the boundary of the
C       grid; if this number is even the point is outside
C
C  4. Argument variables
C
C
C     KGRBND   int  input   array containing boundary grid points
C
      INTEGER  KGRBND(*)
C
C     XP, YP    real, input   a point given in problem coordinates
C     XCGRID    real, input   array(IX,IY) x-coordinate of a grid point
C     YCGRID    real, input   array(IX,IY) y-coordinate of a grid point
C
      REAL     XCGRID(MXC,MYC) ,YCGRID(MXC,MYC),
     &         XP, YP
C
C  5. Parameter variables
C
C  6. Local variables
C
C     NUMCRS   number of crossings with boundary outline
C
      INTEGER  NUMCRS, IX1, IX2, IY2
      REAL     XP1, XP2, YP1, YP2, YPS
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C       CVMESH
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C     --------------------------------------------------------------
C     numcros = 0
C     For all sections of the boundary do
C         determine coordinates of end points (XP1,YP1) and (XP2,YP2)
C         If (XP1<XP and XP2>XP) or (XP1>XP and XP2<XP)
C         then If not (YP1<YP and YP2<YP)
C                   if YPS>YP
C                   then numcros = numcros + 1
C     ---------------------------------------------------------------
C     If numcros is even
C     Then Inmesh = False
C     Else Inmesh = True
C     ---------------------------------------------------------------
C
C 13. Source text
C
      SAVE     IENT
      DATA     IENT/0/
      CALL STRACE (IENT,'INMESH')
*
      IF (XP.LT.XCGMIN .OR. XP.GT.XCGMAX .OR.
     &    YP.LT.YCGMIN .OR. YP.GT.YCGMAX) THEN
        IF (ITEST.GE.70) WRITE (PRTEST, 22) XP+XOFFS, YP+YOFFS,           40.03
     &    XCGMIN+XOFFS, XCGMAX+XOFFS, YCGMIN+YOFFS, YCGMAX+YOFFS
  22    FORMAT (1X, 2E12.4, ' is outside region ', 4E12.4)
        INMESH = .FALSE.
        GOTO 90
      ENDIF
*
      IF (NGRBND.LE.0) THEN
        CALL MSGERR (3, 'grid outline not yet determined')
        RETURN
      ENDIF
C
      NUMCRS = 0
      IX2 = 0
C     loop over the boundary of the computational grid
      DO IBND = 1, NGRBND
        IX1 = IX2
        XP1 = XP2
        YP1 = YP2
        IX2 = KGRBND(2*IBND-1)
        IY2 = KGRBND(2*IBND)
        IF (IX2.GT.0) THEN
          XP2 = XCGRID(IX2,IY2)
          YP2 = YCGRID(IX2,IY2)
          IF (ITEST.GE.180) WRITE (PRTEST, 28) XP2+XOFFS,                 40.03
     &    YP2+YOFFS
  28      FORMAT (' boundary point ', 2E12.4)
          IF (IX1.GT.0) THEN
            IF (((XP1.GT.XP).AND.(XP2.LT.XP)).OR.
     &          ((XP1.LT.XP).AND.(XP2.GT.XP))) THEN
              IF (YP1.GT.YP .OR. YP2.GT.YP) THEN
C               determine y-coordinate of crossing point
                YPS = YP1 + (XP-XP1) * (YP2-YP1) / (XP2-XP1)
                IF (YPS.GT.YP) THEN
                  NUMCRS = NUMCRS + 1
                  IF (ITEST.GE.70) WRITE (PRTEST, 32) NUMCRS,             40.03
     &            XP+XOFFS, YP+YOFFS, YPS+YOFFS                           40.03
  32              FORMAT (' crossing ', I1, ' point ', 3E12.4)
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
C     point is inside the grid is number of crossings is odd
      IF (MOD(NUMCRS,2) .EQ. 1) THEN
        INMESH = .TRUE.
      ELSE
        INMESH = .FALSE.
      ENDIF
  90  RETURN
      END
************************************************************************
*                                                                      *
      SUBROUTINE NEWTON (XP, YP, XCGRID, YCGRID, KGRPNT,                  40.00
     &                   MXITNR, XC, YC, FIND, KGRBND)                    40.02
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.80: Nico Booij
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.21, Jun. 96: New for curvilinear version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     30.80, Oct. 98: computation of update of XC,YC modified to avoid
C                     division by 0
C
*  2. Purpose
*
*     Solve eqs. and find a point  (XC,YC) in a curvilinear grid (compt.
*     grid) for a given point (XP ,YP) in a cartesian grid (problem coord).
C
*  3. Method
*
*     In this subroutine the next equations are solved :
*
*                  @XP             @XP
*     XP(xc,yc) +  --- * @XC   +   --- * @YC  - XP(x,y) = 0
*                  @XC             @YC
*
*                  @YP             @YP
*     YP(xc,yc) +  --- * @XC   +    --- * @YC  - YP(x,y) = 0
*                  @XC             @YC
*
*     In the subroutine, next notation is used for the previous eqs.
*     XVC       + DXDXC * DXC   + DXDYC * DYC - XP  = 0.
*     YVC       + DYDXC * DXC   + DYDYC * DYC - YP  = 0.
*
*
C  4. Argument variables
C
C i   KGRBND: Grid adresses of the boundary points                        40.02
C i   KGRPNT: Grid adresses                                               40.00
C i   MXITNR: Maximum number of iterations                                30.82
C
      INTEGER KGRBND(*), KGRPNT(MXC,MYC), MXITNR                          40.02
C
C   o XC    : X-coordinate in computational coordinates                   30.82
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   XP    : X-coordinate in problem coordinates                         30.82
C   o YC    : Y-coordinate in computational coordinates                   30.82
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C i   YP    : Y-coordinate in problem coordinates                         30.82
C
      REAL    XC, XCGRID(MXC,MYC), XP                                     30.82
      REAL    YC, YCGRID(MXC,MYC), YP                                     30.82
C
C   o FIND  : Whether XC and YC are found                                 30.82
C
      LOGICAL FIND                                                        30.82
C
*  6. SUBROUTINES USED
*
C     STRACE
C
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       -----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER, SAVE :: IENT = 0
      REAL, SAVE    :: TOLDC = 0.001
      IF (LTRACE) CALL STRACE (IENT,'NEWTON')
C
      DXC    = 1000.
      DYC    = 1000.
      TOLDC  = 0.001
      FIND   = .FALSE.
C
      IF (ITEST .GE. 200) THEN
        WRITE(PRINTF,*) ' Coordinates in subroutine NEWTON '
        DO J = 1, MYC
          DO I = 1, MXC
            WRITE(PRINTF,30) I ,J ,XCGRID(I,J) ,YCGRID(I,J)               30.72
          ENDDO
        ENDDO
      ENDIF
 30   FORMAT(2(2X,I5),2(2X,E12.4))
C
      DO 14 K = 1 ,MXITNR
*       *** If the guess point (XC,YC) is outside of compt. ***
*       *** grid, put that point in the closest boundary    ***
        IF (XC .LT. 1. ) XC = 1.
        IF (YC .LT. 1. ) YC = 1.
        IF (XC .GT. MXC) XC = FLOAT(MXC)
        IF (YC .GT. MYC) YC = FLOAT(MYC)
        I1   = INT(XC)                                                    40.00
        J1   = INT(YC)
        IF (I1 .EQ. MXC) I1 = I1 - 1
        IF (J1 .EQ. MYC) J1 = J1 - 1
        I2  = I1 + 1
        J2  = J1 + 1
        FJ1 = FLOAT(J1)
        FI1 = FLOAT(I1)
        FJ2 = FLOAT(J2)
        FI2 = FLOAT(I2)
        IF (KGRPNT(I1,J1).LE.1 .OR. KGRPNT(I2,J1).LE.1 .OR.               40.00
     &      KGRPNT(I1,J2).LE.1 .OR. KGRPNT(I2,J2).LE.1) THEN              40.00
          FIND = .FALSE.
          RETURN                                                          40.00
        ENDIF
C
        XVC   = (YC-FJ1)*((XC-FI1)*XCGRID(I2,J2)  +
     &                    (FI2-XC)*XCGRID(I1,J2)) +
     &          (FJ2-YC)*((XC-FI1)*XCGRID(I2,J1)  +
     &                    (FI2-XC)*XCGRID(I1,J1))
        YVC   = (YC-FJ1)*((XC-FI1)*YCGRID(I2,J2)  +
     &                    (FI2-XC)*YCGRID(I1,J2)) +
     &          (FJ2-YC)*((XC-FI1)*YCGRID(I2,J1)  +
     &                    (FI2-XC)*YCGRID(I1,J1))
        DXDXC = (YC -FJ1)*(XCGRID(I2,J2) - XCGRID(I1,J2)) +
     &          (FJ2-YC )*(XCGRID(I2,J1) - XCGRID(I1,J1))
        DXDYC = (XC -FI1)*(XCGRID(I2,J2) - XCGRID(I2,J1)) +
     &          (FI2-XC )*(XCGRID(I1,J2) - XCGRID(I1,J1))
        DYDXC = (YC -FJ1)*(YCGRID(I2,J2) - YCGRID(I1,J2)) +
     &          (FJ2-YC )*(YCGRID(I2,J1) - YCGRID(I1,J1))
        DYDYC = (XC -FI1)*(YCGRID(I2,J2) - YCGRID(I2,J1)) +
     &          (FI2-XC )*(YCGRID(I1,J2) - YCGRID(I1,J1))
C
        IF (ITEST .GE. 150)
     &    WRITE(PRINTF,35) K, XC-1., YC-1., XP, YP, XVC, YVC              40.00
 35     FORMAT(' NEWTON  iter=', I2, ' (XC,YC)=', 2(1X,F10.2),/,          40.00
     &         ' (XP,YP)=', 2(1X,F10.2),
     &         '  X,Y(XC,YC) = ', 2(1X,F10.2))
        IF (ITEST .GE. 180) WRITE(PRINTF,36)
     &     XCGRID(I1,J1), XCGRID(I1,J2), XCGRID(I2,J1), XCGRID(I2,J2),
     &     YCGRID(I1,J1), YCGRID(I1,J2), YCGRID(I2,J1), YCGRID(I2,J2),
     &                     DXDXC, DXDYC, DYDXC, DYDYC                     40.00
 36     FORMAT(' NEWTON grid coord:', 8(1x, F10.0), /
     &         '        deriv=', 4(1X,F10.2))                             40.00
C
*       *** If the accuracy is reached stop the iteration,  ***
        IF (ABS(DXC) .LE. TOLDC .AND. ABS(DYC) .LE. TOLDC) THEN
C
          FIND = .TRUE.
          XC = XC -1.
          YC = YC -1.
          RETURN
        ENDIF
C
*       *** the derivated terms of the eqs. are evaluated and  ***
*       *** the eqs. are solved                                ***
        DDEN = DXDXC*DYDYC - DYDXC*DXDYC                                  30.80
        DXP  = XP - XVC                                                   30.80
        DYP  = YP - YVC                                                   30.80
        DXC  =  (DYDYC*DXP - DXDYC*DYP) / DDEN                            30.80
        DYC  = (-DYDXC*DXP + DXDXC*DYP) / DDEN                            30.80
C
        XC = XC + DXC
        YC = YC + DYC
C
        IF (ITEST .GE. 120 .OR. INTES .GE. 50 .OR. IOUTES .GE. 50)
     &    WRITE(PRINTF,42) DXC, DYC, XC-1., YC-1.                         40.00
 42     FORMAT(' (DXC,DYC)=', 2(1X,F10.2), ' (XC,YC)=', 2(1X,F10.2))      40.00
C
 14   CONTINUE
      RETURN
*     *** end of subroutine NEWTON ***
      END
************************************************************************
*                                                                      *
      SUBROUTINE NEWT1D (XP, YP, XCGRID, YCGRID, KGRPNT,                  40.00
     &                   MXITNR, XC, YC, FIND)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     40.00, 40.13: Nico Booij
C
C  1. Updates
C
C     40.00, Feb. 99: New (adaptation from subr NEWTON for 1D case)
C     40.13, Feb. 01: DX and DY renamed to DELX and DELY (DX and DY are
C                     common var.); error in expression for RS corrected
C                     PRINTF replaced by PRTEST in test output
C
*  2. Purpose
*
*     Solve eqs. and find a point  (XC,YC) in a curvilinear 1D grid (compt.
*     grid) for a given point (XP ,YP) in a cartesian grid (problem coord).
C
*  3. Method
*
*     In this subroutine the step on the computational grid is selected
*     for which
*
*           (X-X1).(X2-X1)
*     0 <= --------------- <= 1
*          (X2-X1).(X2-X1)
*
*     where X, X1 and X2 are vectors; X corresponds to (Xp,Yp)
*     X1 and X2 are two neighbouring grid points
*
C  4. Argument variables
C
C i   KGRPNT: Grid adresses                                               40.00
C i   MXITNR: Maximum number of iterations                                30.82
C
      INTEGER KGRPNT(MXC,MYC), MXITNR                                     40.00
C
C   o XC    : X-coordinate in computational coordinates                   30.82
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   XP    : X-coordinate in problem coordinates                         30.82
C   o YC    : Y-coordinate in computational coordinates                   30.82
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C i   YP    : Y-coordinate in problem coordinates                         30.82
C
      REAL    XC, XCGRID(MXC,MYC), XP                                     30.82
      REAL    YC, YCGRID(MXC,MYC), YP                                     30.82
C
C   o FIND  : Whether XC and YC are found                                 30.82
C
      LOGICAL FIND                                                        30.82
C
*     Local variables:
 
      REAL :: DELX, DELY   ! grid line                                    40.13
!
*  6. SUBROUTINES USED
*
*       ---
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       -----------------------------------------------------------------
C
C 13. Source text
C
      SAVE     IENT
      DATA     IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'NEWT1D')
C
      IF (ITEST .GE. 120) THEN                                            40.13
        WRITE(PRTEST,*) ' Coordinates in subroutine NEWT1D '              40.13
        DO I = 1, MXC
          WRITE(PRTEST,30) I, XCGRID(I,1)+XOFFS ,YCGRID(I,1)+YOFFS        40.13
        ENDDO
      ENDIF
 30   FORMAT(2X,I5,2(2X,E12.4))
C
      FIND = .FALSE.
      DO 40 IX = 2 ,MXC
        IF (KGRPNT(IX-1,1).GT.1) THEN
          X1 = XCGRID(IX-1,1)
          Y1 = YCGRID(IX-1,1)
        ELSE
          GOTO 40
        ENDIF
        IF (KGRPNT(IX,1).GT.1) THEN
          X2 = XCGRID(IX,1)
          Y2 = YCGRID(IX,1)
        ELSE
          GOTO 40
        ENDIF
*       both ends of the step are valid grid points
*       now verify whether projection of (Xp,Yp) is within the step
        DELX = X2 - X1                                                    40.13
        DELY = Y2 - Y1                                                    40.13
        RS = ((XP - X1) * DELX + (YP - Y1) * DELY) /                      40.13
     &              (DELX * DELX + DELY * DELY)                           40.13
        IF (RS.GE.0. .AND. RS.LE.1.) THEN
          FIND = .TRUE.
          XC = REAL(IX-2) + RS                                            40.00
          YC = 0.
          GOTO 50
        ENDIF
  40  CONTINUE
  50  RETURN
*     *** end of subroutine NEWT1D ***
      END
************************************************************************
*                                                                      *
      SUBROUTINE EVALF (XC ,YC ,XVC ,YVC ,XCGRID ,YCGRID)                 30.72
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.21, Jun. 96: New for curvilinear version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
*  2. Purpose
*
*     Evaluate the coordinates (in problem coordinates) of point (XC,YC)
*     given in compuational coordinates.
*
*  3. Method
*
*     Bilinear interpolation
*
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
*
*       XC, YC      real, outp    point in computational grid coordinates
*       XVC, YCV    real, OUTP    same point  but in problem coordinates
*
*  6. SUBROUTINES USED
*
*       none
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       -----------------------------------------------------------------
*
* 10. SOURCE TEXT
C
      SAVE     IENT
      DATA     IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'EVALF')
C
      I  = INT(XC)
      J  = INT(YC)
C
*     *** If the guess point (XC,YC) is in the boundary   ***
*     *** where I = MXC or/and J = MYC the interpolation  ***
*     *** is done in the mesh with pivoting point         ***
*     *** (MXC-1, J) or/and (I,MYC-1)                     ***
C
      IF (I .EQ. MXC) I = I - 1
      IF (J .EQ. MYC) J = J - 1
      T = XC - FLOAT(I)
      U = YC - FLOAT(J)
*     *** For x-coord. ***
      P1 = XCGRID(I,J)                                                    30.72
      P2 = XCGRID(I+1,J)                                                  30.72
      P3 = XCGRID(I+1,J+1)                                                30.72
      P4 = XCGRID(I,J+1)                                                  30.72
      XVC = (1.-T)*(1.-U)*P1+T*(1.-U)*P2+T*U*P3+(1.-T)*U*P4
*     *** For y-coord. ***
      P1 = YCGRID(I,J)                                                    30.72
      P2 = YCGRID(I+1,J)                                                  30.72
      P3 = YCGRID(I+1,J+1)                                                30.72
      P4 = YCGRID(I,J+1)                                                  30.72
      YVC = (1.-T)*(1.-U)*P1+T*(1.-U)*P2+T*U*P3+(1.-T)*U*P4
      RETURN
*     *** end of subroutine EVALF ***
      END
*
************************************************************************
*                                                                      *
      SUBROUTINE SWOBST (OBSTA, XCGRID, YCGRID, KGRPNT, CROSS)            30.70
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE                                                        40.04
C
      INCLUDE 'ocpcomm4.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                                30.74
C
C  0. Authors
C
C     30.70
C     30.72  IJsbrand Haagsma
C     30.74  IJsbrand Haagsma
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C     30.70, Feb. 98: check if neighbouring point is a true grid point
C                     loop over grid points moved from calling routine into this
C                     argument list changed
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.04, Nov. 99: IMPLICIT NONE added, header updated
C                   : Removed include files that are not used
C
C  2. Purpose
C
C     Reads from the pool array all the data required to find
C     obstacles and use subroutine TCROSS2 to find them.                  40.04
C
C  3. Method
C
C  4. Argument variables
C
C     CROSS   output Array which contains 0's if there is no
C                    obstacle crossing
C                    if an obstacle is crossing between the
C                    central point and its neighbour CROSS is equal
C                    to the number of the obstacle
C     KGRPNT  input  Indirect addressing for computational grid points
C     OBSTA   input  Array of obstacle parameters
C     XCGRID  input  Coordinates of computational grid in x-direction     30.72
C     YCGRID  input  Coordinates of computational grid in y-direction     30.72
C
      INTEGER OBSTA(*), KGRPNT(MXC,MYC), CROSS(2,MCGRD)
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ICC     index
C     ICGRD   index
C     IENT    number of entries of this subroutine
C     IERR    error status: 0=no error, 9=end-of-file
C     INX     location in array (OBSTA) where to find the first data
C             of the record referenced by pointer
C     ILINK   indicates which link is analyzed: 1 -> neighbour in x
C                                               2 -> neighbour in y
C     IX      counter of gridpoints in x-direction
C     IY      counter of gridpoints in y-direction
C     JJ      counter for number of obstacles
C     JP      counter for number of corner points of obstacles
C     LENADT  length provided for additional data in the pointer
C     LENARR  length of the array OBSTA
C     LENOCP  number of occupied places in the array (OBSTA)
C     LENPNM  length provided for names of pointers
C     LENREC  length of the record referenced by pointer
C     NMOBPL  number of pointers in OBSTA array
C     NUMCOR  number of corner points of obstacle
C     OCREAL  delivers a real value stored in an integer array
C     PTYPE
C     X1, Y1  user coordinates of one end of grid link
C     X2, Y2  user coordinates of other end of grid link
C     X3, Y3  user coordinates of one end of obstacle side
C     X4, Y4  user coordinates of other end of obstacle side
C
      INTEGER    ICC, ICGRD, IENT, IERR, INX, ILINK, IX, IY, JJ, JP
      INTEGER    LENADT, LENARR, LENOCP, LENPNM, LENREC, NMOBPL, NUMCOR
      REAL       OCREAL, X1, X2, X3, X4, Y1, Y2, Y3, Y4
      CHARACTER  PTYPE*1
      LOGICAL    XONOBST                                                  40.04
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     Function TCROSS2                                                    40.04
C     STRACE
C
      LOGICAL   TCROSS2                                                   40.04
C
C  9. Subroutines calling
C
C     SWPREP
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C       ----------------------------------------------------------------
C       Read number of obstacles from array OBSTA
C       For every obstacle do
C           Read number of corners of the obstacle
C           For every corner of the obstacle do
C               For every grid point do
C                   CALL FUNCTION TCROSS2 to search if there is crossing  40.04
C                   point                                                 40.04
C                   between the line of two points of the stencil and the
C                   line of the corners of the obstacle.
C                   If there is crossing point then
C                   then CROSS(link,kcgrd) = number of the crossing obstacle
C                   else CROSS(link,kcgrd) = 0
C       ----------------------------------------------------------------
C
C 13. Source text
C ======================================================================
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWOBST')
*
*
*     ***   Get grid point numbers for points in comput stencil   ***
*
*     ***** Inquire the number of pointers in array OBSTA *****
      IERR = 0
C
      CALL DPINQA (OBSTA, LENARR, LENOCP, NMOBPL, LENPNM, LENADT, IERR)
      IF (IERR.NE.0) WRITE (PRTEST, *)
     &  ' Error calling INQA from SWOBST ', IERR, LENARR,
     &  LENOCP, NMOBPL, LENPNM
      IF (NMOBPL .NE. NUMOBS) THEN
        CALL MSGERR (2,' Number of obstacles not equal to ')
        CALL MSGERR (2,' number of pointers for obstacles ')
        WRITE (PRINTF,70) NUMOBS, NMOBPL
 70     FORMAT(' Num of obstac: ', I5,3X,' num of pointers: ',I5)
      ENDIF
C
      IF (NUMOBS .GT. 0) THEN
*       NUMOBS is the number of obstacles ***
        DO 120 JJ = 1, NUMOBS
          IERR = 0
          CALL DPINQP (OBSTA, ' ', JJ, PTYPE, INX, LENREC, IERR)
          IF (IERR.NE.0) WRITE (PRTEST, *)
     &    ' Error calling INQP from SWOBST ', IERR, JJ, PTYPE, INX,
     &    LENREC
C         number of corner points of the obstacle
          NUMCOR = OBSTA(INX+1)
          IF (ITEST.GE. 120) THEN
            WRITE(PRINTF,50) JJ, NUMCOR
 50         FORMAT( ' Obstacle number : ', I4,'  has ',I4,' corners')
          ENDIF
*         *** X1 X2 X3 ETC. are the coordinates of point according ***
*         *** with the scheme in the subroutine TCROSS2 header     ***   40.04
          X3 = OCREAL(OBSTA(INX+2*1+11))                                 020697
          Y3 = OCREAL(OBSTA(INX+2*1+12))                                 020697
          IF (ITEST.GE. 120)  WRITE(PRINTF,30) 1,X3,Y3
          DO 110 JP = 2, NUMCOR
            X4 = OCREAL(OBSTA(INX+2*JP+11))                              020697
            Y4 = OCREAL(OBSTA(INX+2*JP+12))                              020697
            IF (ITEST.GE. 120) WRITE(PRINTF,30) JP,X4,Y4
  30        FORMAT(' Corner number:', I4,'    XP: ',E10.4,' YP: ',E11.4)
            DO 100 IX = 1, MXC
              DO 90 IY = 1, MYC
                ICC = KGRPNT(IX,IY)
                IF (ICC .GT. 1) THEN
                  X1 = XCGRID(IX,IY)                                      30.72
                  Y1 = YCGRID(IX,IY)                                      30.72
*
*                 *** "ILINK" indicates which link is analyzed. Initial  ***
*                 *** neighbour in x , second link with neighbouring in y***
                  DO 80 ILINK = 1, 2
                    IF (ILINK.EQ.1 .AND. IX.GT.1) THEN
                      X2    = XCGRID(IX-1,IY)                             30.72
                      Y2    = YCGRID(IX-1,IY)                             30.72
                      ICGRD = KGRPNT(IX-1,IY)                             30.70
                    ELSE IF (ILINK.EQ.2 .AND. IY.GT.1) THEN
                      X2    = XCGRID(IX,IY-1)                             30.72
                      Y2    = YCGRID(IX,IY-1)                             30.72
                      ICGRD = KGRPNT(IX,IY-1)                             30.70
                    ELSE
                      ICGRD = 0
                    ENDIF
                    IF (ICGRD.GT.1) THEN                                  30.70
*
*                     *** All links are analyzed in each point otherwise the   ***
*                     *** boundaries can be excluded                           ***
*
                      IF (TCROSS2(X1, X2, X3, X4, Y1, Y2, Y3, Y4,         40.04
     &                           XONOBST)) THEN                           40.04
                        CROSS(ILINK,ICC) = JJ
                      ENDIF
                    ENDIF
  80              CONTINUE
                ENDIF
  90          CONTINUE
 100        CONTINUE
            X3 = X4
            Y3 = Y4
 110      CONTINUE
 120    CONTINUE
      ENDIF
*
      RETURN
* * end of subroutine SWOBST *
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION TCROSS (X1, X2, X3, X4, Y1, Y2, Y3, Y4)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE                                                        40.04
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C  0. Authors
C
C     40.00  Gerbrant van Vledder
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C       30.70, Feb 98: argument list simplified
C                      subroutine changed into logical function
C       40.00, Aug 98: division by zero prevented
C       40.04, Nov 99: method corrected, IMPLICIT NONE added
C                    : removed include files that are not used
C
C  2. Purpose
C
C       Find if there is an obstacle crossing the stencil in used
C
C  3. Method
C
C     For the next situation (A, B and C are the points in the stencil,
C     D and E  are corners of the obstacle
C
C
C      obstacle --> D(X3,Y3)
C                    *
C                     *
C                      *
C        (X2,Y2)        * (XC,YC)
C            B-----------@--------------------------A (X1,Y1)
C                        ^*                         /
C                   _____| *                       /
C                  |        *                     /
C                  |         *                   /
C         crossing point      *                 /
C                              *               /
C                               E             /
C                              (X4,Y4)       /
C                                           C
C
C
C       The crossing point (@) should be found solving the next eqs.
C       for LMBD and MIU.
C
C       | XC |    | X1 |           | X2 - X1 |
C       |    | =  |    | +  LMBD * |         |
C       | YC |    | Y1 |           | Y2 - Y1 |
C
C
C       | XC |    | X3 |           | X4 - X3 |                            40.04
C       |    | =  |    | +  MIU  * |         |
C       | YC |    | Y3 |           | Y4 - Y3 |                            40.04
C
C
C     If solution exist and (0 <= LMBD <= 1 and 0 <= MIU <= 1)            40.04
C     there is an obstacle crossing the stencil
C
C  4. Argument variables
C
C     X1, Y1  inp    user coordinates of one end of grid link
C     X2, Y2  inp    user coordinates of other end of grid link
C     X3, Y3  inp    user coordinates of one end of obstacle side
C     X4, Y4  inp    user coordinates of other end of obstacle side
C
      REAL       X1, X2, X3, X4, Y1, Y2, Y3, Y4
C
C  5. Parameter variables
C
C  6. Local variables
C
C     A,B,C,D    dummy variables
C     DIV1       denominator of value of LMBD (or MIU)
C     E,F        dummy variables
C     IENT       number of entries of function TCROSS
C     LMBD       coefficient in vector equation for stencil points (or obstacle)
C     MIU        coefficient in vector equation for obstacle (or stencil points)
C
      INTEGER    IENT
      REAL       A, B, C, D, DIV1, E, F, LMBD, MIU
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SWOBST
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C     Calculate MIU and LMBD
C     If 0 <= MIU, LMBD <= 1                                              40.04
C     Then TCROSS is .True.
C     Else TCROSS is .False.
C
C 13. Source text
C ======================================================================
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'TCROSS')
C
      A    = X2 - X1
C     A not equal to zero
      IF (A .NE. 0.) THEN
        B    = X4 - X3
        C    = X3 - X1
        D    = Y2 - Y1
        E    = Y4 - Y3
        F    = Y3 - Y1
      ELSE
C       exchange MIU and LMBD                                             40.04
        A    = X4 - X3
        B    = X2 - X1
        C    = X1 - X3
        D    = Y4 - Y3
        E    = Y2 - Y1
        F    = Y1 - Y3
      ENDIF
      DIV1 = ((A*E) - (D*B))                                              40.00
C
C     DIV1 = 0 means that obstacle is parallel to line through            40.04
C     stencil points, or (X3,Y3) = (X4,Y4);                               40.04
C     A = 0 means trivial set of equations X4= X3 and X2 =X1              40.04
C
      IF (DIV1.EQ.0. .OR. A.EQ.0.) THEN                                   40.00
        MIU = -1.                                                         40.00
        LMBD = -1.                                                        40.04
      ELSE                                                                40.00
        MIU  = ((D*C) - (A*F)) / DIV1
        LMBD = (C + (B*MIU)) / A
      END IF                                                              40.00
C
      IF (MIU  .GE. 0. .AND. MIU  .LE. 1. .AND.                           40.04
     &    LMBD .GE. 0. .AND. LMBD .LE. 1.) THEN                           40.04
 
*
*       *** test output ***
        IF (ITEST .GE. 120) THEN
          WRITE(PRINTF,70)X1,Y1,X2,Y2,X3,Y3,X4,Y4
  70      FORMAT(' Obstacle crossing  :',/,
     &    ' Coordinates of comp grid points and corners of obstacle:',/,
     &    ' P1(',E10.4,',',E10.4,')',' P2(',E10.4,',',E10.4,')',/,
     &    ' P3(',E10.4,',',E10.4,')',' P4(',E10.4,',',E10.4,')')
        ENDIF
C
        TCROSS = .TRUE.
      ELSE
        TCROSS = .FALSE.
      ENDIF
*
C     End of subroutine TCROSS
      RETURN
      END
C
************************************************************************
*                                                                      *
      LOGICAL FUNCTION TCROSS2(X1, X2, X3, X4, Y1, Y2, Y3, Y4, X1ONOBST)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE                                                       40.04
C
      INCLUDE 'ocpcomm4.inc'
C
C  0. Authors
C
C     40.00  Gerbrant van Vledder
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C       30.70, Feb 98: argument list simplified
C                      subroutine changed into logical function
C       40.00, Aug 98: division by zero prevented
C       40.04, Aug 99: method corrected, IMPLICIT NONE added, XCONOBST added,
C                      introduced TINY and EPSILON (instead of comparing to 0)
C                      replaced 0 < LMBD,MIU by  0 <= LMBD,MIU
C                      XCONOBST added to argument list
C
C  2. Purpose
C
C       Find if there is an obstacle crossing the stencil in used
C
C  3. Method
C
C     For the next situation (A, B and C are the points in the stencil,
C     D and E  are corners of the obstacle
C
C
C      obstacle --> D(X3,Y3)
C                    *
C                     *
C                      *
C        (X2,Y2)        * (XC,YC)
C            B-----------@--------------------------A (X1,Y1)
C                        ^*                         /
C                   _____| *                       /
C                  |        *                     /
C                  |         *                   /
C         crossing point      *                 /
C                              *               /
C                               E             /
C                              (X4,Y4)       /
C                                           C
C
C
C       The crossing point (@) should be found solving the next eqs.
C       for LMBD and MIU.
C
C       | XC |    | X1 |           | X2 - X1 |
C       |    | =  |    | +  LMBD * |         |
C       | YC |    | Y1 |           | Y2 - Y1 |
C
C
C       | XC |    | X3 |           | X4 - X3 |                            40.04
C       |    | =  |    | +  MIU  * |         |
C       | YC |    | Y3 |           | Y4 - Y3 |                            40.04
C
C
C     If solution exist and (0 <= LMBD <= 1 and 0 <= MIU <= 1)            40.04
C     there is an obstacle crossing the stencil
C
C  4. Argument variables
C
C     X1, Y1  inp    user coordinates of one end of grid link
C     X2, Y2  inp    user coordinates of other end of grid link
C     X3, Y3  inp    user coordinates of one end of obstacle side
C     X4, Y4  inp    user coordinates of other end of obstacle side
C     X1ONOBST outp   boolean which tells whether (X1,Y1) is on obstacle
C
      REAL       EPS, X1, X2, X3, X4, Y1, Y2, Y3, Y4
      LOGICAL    X1ONOBST
C
C  5. Parameter variables
C
C  6. Local variables
C
C     A,B,C,D    dummy variables
C     DIV1       denominator of value of LMBD (or MIU)
C     E,F        dummy variables
C     IENT       number of entries of function TCROSS2
C     LMBD       coefficient in vector equation for stencil points (or obstacle)
C     MIU        coefficient in vector equation for obstacle (or stencil points)
C
      INTEGER    IENT
      REAL       A, B, C, D, DIV1, E, F, LMBD, MIU
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SWOBST
C     SWTRCF
C     OBSTMOVE
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C     Calculate MIU and LMBD
C     If 0 <= MIU, LMBD <= 1                                              40.04
C     Then TCROSS2 is .True.
C     Else TCROSS2 is .False.
C
C 13. Source text
C ======================================================================
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'TCROSS2')
C
      EPS = EPSILON(X1)*SQRT((X2-X1)*(X2-X1)+(Y2-Y1)*(Y2-Y1))             40.04
      IF (EPS ==0) EPS = TINY(X1)                                         40.04
      A    = X2 - X1
C     A not equal to zero
      IF (ABS(A) .GT. TINY(X1)) THEN                                      40.04
        B    = X4 - X3
        C    = X3 - X1
        D    = Y2 - Y1
        E    = Y4 - Y3
        F    = Y3 - Y1
      ELSE
C       exchange MIU and LMBD                                             40.04
        A    = X4 - X3
        B    = X2 - X1
        C    = X1 - X3
        D    = Y4 - Y3
        E    = Y2 - Y1
        F    = Y1 - Y3
      ENDIF
      DIV1 = ((A*E) - (D*B))                                              40.00
C
C     DIV1 = 0 means that obstacle is parallel to line through            40.04
C     stencil points, or (X3,Y3) = (X4,Y4);                               40.04
C     A = 0 means trivial set of equations X4= X3 and X2 =X1              40.04
C
      IF ((ABS(DIV1).LE.TINY(X1)) .OR.                                    40.04
     &    (ABS(A).LE.TINY(X1))) THEN                                      40.04
        MIU = -1.                                                         40.00
        LMBD = -1.                                                        40.04
      ELSE                                                                40.00
        MIU  = ((D*C) - (A*F)) / DIV1
        LMBD = (C + (B*MIU)) / A
      END IF                                                              40.00
C
      IF (MIU  .GE. 0. .AND. MIU  .LE. 1. .AND.                           40.04
     &    LMBD .GE. 0. .AND. LMBD .LE. 1.) THEN                           40.04
C
C       Only (X1,Y1) is checked, because of otherwise possible double     40.04
C       counting                                                          40.04
        IF ((LMBD.LE.EPS .AND. ABS(X2-X1).GT.EPS).OR.                     40.04
     &      (MIU .LE.EPS .AND. ABS(X2-X1).LE.EPS))THEN                    40.04
          X1ONOBST = .TRUE.                                               40.04
        ELSE                                                              40.04
          X1ONOBST = .FALSE.                                              40.04
        ENDIF                                                             40.04
*
*       *** test output ***
        IF (ITEST .GE. 120) THEN
          WRITE(PRINTF,70)X1,Y1,X2,Y2,X3,Y3,X4,Y4
  70      FORMAT(' Obstacle crossing  :',/,
     &    ' Coordinates of comp grid points and corners of obstacle:',/,
     &    ' P1(',E10.4,',',E10.4,')',' P2(',E10.4,',',E10.4,')',/,
     &    ' P3(',E10.4,',',E10.4,')',' P4(',E10.4,',',E10.4,')')
        ENDIF
C
        TCROSS2 = .TRUE.
      ELSE
        TCROSS2 = .FALSE.
      ENDIF
C
C     End of subroutine TCROSS2
      RETURN
      END
C
************************************************************************
*                                                                      *
      RECURSIVE SUBROUTINE OBSTMOVE (OBSTA, XCGRID, YCGRID, KGRPNT)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'
      INCLUDE 'swcomm3.inc'
C
C
C  0. Authors
C
C     40.09  Annette Kieftenburg
C
C  1. Updates
C
C     40.09, July 00: new subroutine
C
C  2. Purpose
C
C     Move OBSTACLE points (X3,Y3) and (X4,Y4) a bit if computational gridcell
C     (X1,Y1) is on the OBSTACLE line piece.
C
C  3. Method
C
C     Add EPS*(dY,-dX) to OBSTACLE line piece coordinates so that movement of
C     these OBSTACLE points is perpendicular to the direction
C
C  4. Argument variables
C
C     KGRPNT  input  Indirect addressing for computational grid points
C     OBSTA   input  Array of obstacle parameters
C     XCGRID  input  Coordinates of computational grid in x-direction
C     YCGRID  input  Coordinates of computational grid in y-direction
C
      INTEGER OBSTA(*), KGRPNT(MXC,MYC)
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)
C
C  5. Parameter variables
C
C  6. Local variables
C
C     DISTA    distance between (X1,Y1) and (X2A,Y2A)
C     DISTB    distance between (X1,Y1) and (X2 ,Y2 )
C     DXA, DYA difference X1 - X2A respectively Y1 - Y2A
C     DXB, DYB difference X2 - X1 respectively Y2 - Y1
C     DXO, DYO difference X4 - X3 respectively Y4 - Y3
C     DXYO     distance between (X3,Y3) and (X4,Y4)
C     EPS      multiplication factor
C     ICC     index
C     ICGRD   index
C     IENT    number of entries of this subroutine
C     IERR    error status: 0=no error, 9=end-of-file
C     ILINK   indicates which link is analyzed: 1 -> neighbour in x
C                                               2 -> neighbour in y
C     INX     location in array (OBSTA) where to find the first data
C             of the record referenced by pointer
C     IX      counter of gridpoints in x-direction
C     IY      counter of gridpoints in y-direction
C     JJ      counter for number of obstacles
C     JP      counter for number of corner points of obstacles
C     LENADT  length provided for additional data in the pointer
C     LENARR  length of the array OBSTA
C     LENOCP  number of occupied places in the array (OBSTA)
C     LENPNM  length provided for names of pointers
C     LENREC  length of the record referenced by pointer
C     MOVED    boolean which tells whether OBSTACLE has been moved
C     NMOBPL  number of pointers in OBSTA array
C     NUMCOR  number of corner points of obstacle
C     OCREAL  delivers a real value stored in an integer array
C     PTYPE
C     X1, Y1   computational grid coordinates of one end of grid link
C     X2, Y2   computational grid coordinates of other end of grid link
C              i.e. neighbouring point of X1,Y1 associated with linknumber
C     X2A,Y2A  other neighbouring point of X1,Y1 associated with other
C              linknumber, or if invalid: = X2,Y2
C     X3, Y3   user coordinates of one end of obstacle side
C     X4, Y4   user coordinates of other end of obstacle side
C     XCONOBST boolean variable which tells whether XC in on OBSTACLE
C              line piece
C     XYEPS    displacement factor relative to local computational grid
C
      INTEGER    ICC, ICGRD, IENT, IERR, INX, ILINK, IX, IY, JJ, JP
      INTEGER    LENADT, LENARR, LENOCP, LENPNM, LENREC, NMOBPL, NUMCOR
      REAL       DISTA, DISTB, DXA, DXB, DYA, DYB,
     &           DXO, DXYO, DYO, EPS, OCREAL, X1, X2, X2A, X3, X4,
     &           XYEPS, Y1, Y2, Y2A, Y3, Y4
      CHARACTER  PTYPE*1
      LOGICAL    MOVED, XCONOBST
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     STRACE
C     Function TCROSS2 indicates whether there is an obstacle crossing the used
C                      stencil or not
C     MSGERR
C
      LOGICAL    TCROSS2
C
C  9. Subroutines calling
C
C     SWPREP
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C       ----------------------------------------------------------------
C       Read number of obstacles from array OBSTA
C       For every obstacle do
C           Read number of corners of the obstacle
C           For every corner of the obstacle do
C               For every grid point do
C                   CALL FUNCTION TCROSS2 to search if there is crossing point
C                   between the line of two points of the stencil and the
C                   line of the corners of the obstacle.
C                   If there is crossing point then
C                     If there computational gridpoint is on the obstacle
C                     then move corner points of obstacle perpendicular
C                     to obstacle with factor
C                     (XYEPS*DYO/DXYO,-XYEPS*DXO/DXYO)
C                     Moved = .True.
C                   If Moved then call OBSTMOVE again to check whether
C                   there are still computational grid points on OBSTACLE
C       ----------------------------------------------------------------
C
C 13. Source text
C ======================================================================
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'OBSTMOVE')
      IERR = 0
      MOVED = .FALSE.
      EPS =1.E-2
      CALL DPINQA (OBSTA, LENARR, LENOCP, NMOBPL, LENPNM, LENADT, IERR)
      IF (IERR.NE.0) WRITE (PRTEST, *)
     &  ' Error calling INQA from OBSTMOVE ', IERR, LENARR,
     &  LENOCP, NMOBPL, LENPNM
      IF (NMOBPL .NE. NUMOBS) THEN
        CALL MSGERR (2,' Number of obstacles not equal to ')
        CALL MSGERR (2,' number of pointers for obstacles ')
        WRITE (PRINTF,70) NUMOBS, NMOBPL
 70     FORMAT(' Num of obstac: ', I5,3X,' num of pointers: ',I5)
      ENDIF
C
      IF (NUMOBS .GT. 0) THEN
        DO JJ = 1, NUMOBS
          IERR = 0
          CALL DPINQP (OBSTA, ' ', JJ, PTYPE, INX, LENREC, IERR)
          IF (IERR.NE.0) WRITE (PRTEST, *)
     &    ' Error calling INQP from OBSTMOVE ', IERR, JJ, PTYPE, INX,
     &    LENREC
C         number of corner points of the obstacle
          NUMCOR = OBSTA(INX+1)
          IF (ITEST.GE. 120) THEN
            WRITE(PRINTF,50) JJ, NUMCOR
 50         FORMAT( ' Obstacle number : ', I4,'  has ',I4,' corners')
          ENDIF
*         *** X1 X2 X3 ETC. are the coordinates of point according ***
*         *** with the scheme in the subroutine TCROSS2 header      ***
          X3 = OCREAL(OBSTA(INX+2*1+11))
          Y3 = OCREAL(OBSTA(INX+2*1+12))
          DO JP = 2, NUMCOR
            X4 = OCREAL(OBSTA(INX+2*JP+11))
            Y4 = OCREAL(OBSTA(INX+2*JP+12))
            IF (ITEST.GE. 120) WRITE(PRINTF,30) JP,X4,Y4
  30        FORMAT(' Corner number:', I4,'    XP: ',E10.4,' YP: ',E11.4)
            DO IX = 1, MXC
              DO IY = 1, MYC
                ICC = KGRPNT(IX,IY)
                IF (ICC .GT. 1) THEN
                  X1 = XCGRID(IX,IY)
                  Y1 = YCGRID(IX,IY)
*
*                 *** "ILINK" indicates which link is analyzed. Initial  ***
*                 *** neighbour in x , second link with neighbouring in y***
                  DO ILINK = 1, 2
                    IF (ILINK.EQ.1 .AND. IX.GT.1) THEN
                      X2    = XCGRID(IX-1,IY)
                      Y2    = YCGRID(IX-1,IY)
                      IF (IY.GT.1) THEN
                        X2A    = XCGRID(IX,IY-1)
                        Y2A    = YCGRID(IX,IY-1)
                      ELSE
                        X2A    = X2
                        Y2A    = Y2
                      ENDIF
                      ICGRD = KGRPNT(IX-1,IY)
                    ELSE IF (ILINK.EQ.2 .AND. IY.GT.1) THEN
                      X2    = XCGRID(IX,IY-1)
                      Y2    = YCGRID(IX,IY-1)
                      IF (IX.GT.1) THEN
                       X2A    = XCGRID(IX-1,IY)
                       Y2A    = YCGRID(IX-1,IY)
                      ELSE
                       X2A    = X2
                       Y2A    = Y2
                      ENDIF
                      ICGRD = KGRPNT(IX,IY-1)
                    ELSE
                     ICGRD = 0
                    ENDIF
                    IF (ICGRD.GT.1) THEN
*
*                     *** All links are analyzed in each point otherwise the   ***
*                     *** boundaries can be excluded                           ***
*
                      IF (TCROSS2(X1,X2,X3,X4,Y1,Y2,Y3,Y4,XCONOBST))THEN
                        IF (XCONOBST) THEN
                        DXA=(X1-X2A)
                        DYA=(Y1-Y2A)
                        DXB=(X2-X1)
                        DYB=(Y2-Y1)
                        DISTA=SQRT(DXA*DXA+DYA*DYA)
                        DISTB=SQRT(DXB*DXB+DYB*DYB)
                        XYEPS = EPS*MIN(DISTA,DISTB)
                        DXO = X4-X3
                        DYO = Y4-Y3
                        DXYO = SQRT(DXO*DXO+DYO*DYO)
C                       -DXO/DXYO and DYO/DXYO are used (instead of -DXO
C                       and DYO) because otherwise displacement is dependent
C                       on length of OBSTACLE line piece
                        CALL DPPUTR (OBSTA,INX+2*(JP-1)+11,
     &                                     X3+XYEPS*DYO/DXYO)
                        CALL DPPUTR (OBSTA,INX+2*(JP-1)+12,
     &                                     Y3-XYEPS*DXO/DXYO)
                        CALL DPPUTR (OBSTA,INX+2*JP+11,
     &                                     X4+XYEPS*DYO/DXYO)
                        CALL DPPUTR (OBSTA,INX+2*JP+12,
     &                                     Y4-XYEPS*DXO/DXYO)
                        CALL MSGERR (1, 'Obstacle points moved')
                        WRITE(PRINTF, 17) X3, Y3, X4, Y4,
     &                        X3+XYEPS*DYO/DXYO, Y3-XYEPS*DXO/DXYO,
     &                        X4+XYEPS*DYO/DXYO, Y4-XYEPS*DXO/DXYO,X1,Y1
  17                    FORMAT ('OBSTACLE POINTS (', F11.2, ',',  F11.2,
     &                         '), and (', F11.2,',',  F11.2,'),',
     &                         'moved to: (',  F11.2,',',
     &                         F11.2,'), and (', F11.2,',', F11.2,
     &                         '), because OBSTACLE line piece ',
     &                         'was on computational grid point (',
     &                         F11.2,',', F11.2,').')
                        X3 = X3 + XYEPS * DYO/DXYO
                        Y3 = Y3 - XYEPS * DXO/DXYO
                        X4 = X4 + XYEPS * DYO/DXYO
                        Y4 = Y4 - XYEPS * DXO/DXYO
                        MOVED = .TRUE.
                        ENDIF
                      ENDIF
                    ENDIF
                  END DO
                ENDIF
              END DO
            END DO
            X3 = X4
            Y3 = Y4
          END DO
        END DO
      ENDIF
      IF (MOVED) CALL OBSTMOVE(OBSTA, XCGRID, YCGRID, KGRPNT)
      RETURN
C * end of subroutine OBSTMOVE *
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE SWTRCF (OBSTA, CROSS, WLEV2, CHS,                        40.00
     &                   LINK, OBREDF                                     40.03
     &                  ,AC2,    IMATRA, KGRPNT, XCGRID,                  40.09
     &                   YCGRID, CAX,    CAY,    RDX,    RDY,    ANYBIN)  40.09
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE                                                       40.09
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C  0. Authors
C
C     30.70
C     40.03  Nico Booij
C     40.09  Annette Kieftenburg
C     40.14  Annette Kieftenburg
!     40.18  Annette Kieftenburg
C
C  1. Updates
C
C     30.70, Feb. 98: water level (WLEV2) replaced depth
C                     incident wave height introduced using argument
C                     CHS (sign. wave height in whole comput. grid)
C     40.03, Jul. 00: LINK1 and LINK2 in argumentlist replaced by LINK
C     40.09, Nov. 99: IMPLICIT NONE added, Method corrected
C                     Reflection option for obstacle added
C     40.14, Dec. 00: Reflection call corrected: reduced to neighbouring
C                     linepiece of obstacle (bug fix 40.11D)
C            Jan. 01: Constant waterlevel taken into account as well (bug fix 40.11E)
!     40.18, Apr. 01: Scattered reflection against obstacles added        40.18
C
C  2. Purpose
C
C      take the value of transmission coefficient from the pool given
C      by the user in case  obstacle TRANSMISSION
C      or
C      compute the transmision coeficient in case obstacle DAM
C      based on Goda (1967) [from Seelig (1979)].
C      if reflections are turned on, calculate sourceterm in              40.09
C      subroutine REFLECT                                                 40.09
C
C  3. Method
C
C     Calculate transmission coefficient based on Goda (1967)             40.09
C     from Seelig (1979)                                                  40.09
C     Kt = 0.5*(1-sin {pi/(2*alpha)*(WATHIG/Hi +beta)})
C     where
C     Kt         transmission coefficient
C
C     alpha,beta coefficients dependent on structure of obstacle
C                and waves
C     WATHIG     = F = h-d is the freeboard of the dam, where h is the    40.09
C                crest level of the dam above the reference level and d   40.09
C                is the mean water level (relative to reference level)    40.09
C     Hi         incident (significant) wave height                       40.09
C                                                                         40.09
C     If reflection are switched on and obstacle is not exactly on line   40.09
C     of two neighbouring gridpoints, calculate reflections.              40.09
C
C  4. Argument variables
C
C     AC2      input     Action density array                             40.09
C     ANYBIN   input     Set a particular bin TRUE or FALSE depending on  40.09
C                        SECTOR                                           40.09
C     CAX      input     Propagation velocity                             40.09
C     CAY      input     Propagation velocity                             40.09
C     CHS      input     Hs in all computational grid points
C     CROSS    input..   Array which contains 0's if there is no
C                        obstacle crossing
C                        if an obstacle is crossing between the
C                        central point and its neighbour CROSS is equal
C                        to the number of the obstacle
C     IMATRA   inp/outp  Coefficients of right hand side of matrix        40.09
C                        equation                                         40.09
C     KCGRD    input     Grid address of points of computational stencil
C     LINK     input     indicates whether link in stencil                40.03
C                        crosses an obstacle                              40.03
C     OBREDF   output    Array of action density reduction coefficients
C                        (reduction at the obstacle)
C     OBSTA    input     Array containing obstacle data
C     RDX,RDY  input     Array containing spatial derivative coefficients 40.09
C     WLEV2    input     Water level in grid points
C
      INTEGER  CROSS(2,MCGRD), OBSTA(*)                                   40.00
      INTEGER  KGRPNT(MXC,MYC)
      INTEGER  LINK(2)                                                    40.03
      REAL     CHS(MCGRD), OBREDF(MDC,MSC,2), WLEV2(MCGRD)                30.70
      REAL     :: AC2(MDC,MSC,MCGRD)                                      40.09 40.22
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL     :: CAX(MDC,MSC,MICMAX), CAY(MDC,MSC,MICMAX)                40.09 40.22
      REAL     :: IMATRA(MDC,MSC), RDX(2), RDY(2)                         40.09 40.22
      LOGICAL  :: ANYBIN(MDC,MSC)                                         40.09
C
C  5. Parameter variables
C
C  6. Local variables
C
C     AC2REF   reflected action density spectrum
C     ALOW     Lower limit for FVH
C     BUPL     Upper limit for FVH
C     FVH      WATHIG/Hsin (= F/Hi in formulation of Goda/Seelig
C              (1967/1979))
C     HGT      elevation of top of obstacle above reference level
C     HSIN     significant wave height in whole computational grid
C     ID       counter in directional space
C     IENT     number of entries of this subroutine
C     IERR     error status: 0=no error, 9=end-of-file
C     INX      location in array (OBSTA) where to find the first data
C              of the record referenced by pointer
C     IS       counter in frequency space
C     ITRAS    indicates kind of obstacle: 0 -> transm
C                                          1 -> dam
C     JP       counter for number of corner points of obstacles
C     LENREC   length of the record referenced by pointer
C     LOOP     indicates which link is analyzed: 1 -> neighbour in x
C                                                2 -> neighbour in y
!     LREFDIFF inp  Indicates whether reflected energy should be          40.18
!                   reflected (1) or not (0)                              40.18
C     NMPO     link number
C     NUMCOR   number of corner points of obstacle
C     OBET     user defined coefficient (beta) in formulation of
C              Goda/Seelig (1967/1979)
C     OBHKT    transmission coefficient according to Goda/Seelig (1967/1979)
C     OCREAL   delivers a real value stored in an integer array
C     OGAM     user defined coefficient (alpha) in formulation of
C              Goda/Seelig (1967/1979)
!     POWN     inp  User defined power of redistribution function         40.18
C     PTYPE
C     REFLCOEF reflection coefficient in terms of action density
C     SQRTREF  dummy variable
C     SQRTTRC  dummy variable
C     TRCOEF   transmission coefficient in terms of action density
C              (user defined or calculated (in terms of waveheigth))
C     X1, Y1   user coordinates of one end of grid link
C     X2, Y2   user coordinates of other end of grid link
C     X3, Y3   user coordinates of one end of obstacle side
C     X4, Y4   user coordinates of other end of obstacle side
C     XCGRID   Coordinates of computational grid in x-direction
C     XONOBST  Indicates whether computational point (X1,Y1) is on        40.14
C              obstacle                                                   40.14
C     YCGRID   Coordinates of computational grid in y-direction
C     WATHIG   freeboard of the dam (= HGT-waterlevel)
C
      INTEGER    ID, IENT, IERR, INX, ITRAS, IS, JP, LENREC, LOOP,
     &           NUMCOR, NMPO
      REAL       ALOW, BUPL, FVH, HGT, HSIN, OBET, OBHKT, OCREAL,
     &           POWN, OGAM, LREFDIFF, REFLCOEF,                          40.18 40.09
     &           TRCOEF, X1, X2, X3, X4, Y1, Y2, Y3, Y4, WATHIG
      REAL       AC2REF(MDC,MSC), SQRTREF, SQRTTRC                        40.09
      LOGICAL    EXC, XGTL, XONOBST                                       40.14
      CHARACTER  PTYPE*1
      REAL       ICGRD, XCGRID(MXC,MYC), YCGRID(MXC,MYC)
      INTEGER    ICC
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     OBSTLINE
C     REFLECT
C     Function TCROSS2                                                    40.14
C
      LOGICAL TCROSS2                                                     40.14
C
C  9. Subroutines calling
C
C     ACTION
C     SWOMPU                                                              30.70
C
C 10. Error messages
C
C 11. Remarks
C
C     Here the formulation of the transmission coefficients concerns the  40.09
C     ratio of action densities!                                          40.09
C
C 12. Structure
C
C     calculate transmission coefficients                                 40.09
C     if activated: calculate reflection source terms (if computational   40.09
C                   point not exactly on linepiece of obstacle)           40.09
C
C 13. Source text
C ======================================================================
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWTRCF')
*
      DO 30 LOOP = 1 ,2
        TRCOEF = 1.
        NMPO = LINK(LOOP)
        HSIN = CHS(KCGRD(LOOP+1))                                         40.03
        IF (NMPO .EQ. 0) GO TO 40
        IERR = 0
        CALL DPINQP (OBSTA, ' ', NMPO, PTYPE, INX, LENREC, IERR)
        IF (IERR .NE. 0) WRITE(PRINTF,12) KCGRD(1), NMPO
  12    FORMAT(' error calling DPINQP from SWTRCF: KCGRD(1) , NMPO  = ',
     &  2(1X,I5))
        ITRAS  = OBSTA(INX+2)
        IF (ITRAS .EQ. 0) THEN
C         User defined transmission coefficient concerns ratio of         40.09
C         waveheights, so:                                                40.09
          SQRTTRC = OCREAL(OBSTA(INX+3))                                  40.09
          TRCOEF = SQRTTRC * SQRTTRC                                      40.09
C
        ELSE IF (ITRAS .EQ. 1) THEN
          HGT    =  OCREAL(OBSTA(INX+3))
          OGAM   =  OCREAL(OBSTA(INX+4))
          OBET   =  OCREAL(OBSTA(INX+5))
C         level of dam above the water:
          WATHIG =  HGT - WLEV2(KCGRD(1)) - WLEV                          40.14 30.70
          IF (HSIN .LT. 0.1E-4) HSIN = 0.1E-4
*
*         *** Here the transmission coeff. is that of Goda and Seelig ***
          FVH  = WATHIG/HSIN
          ALOW = -OBET-OGAM                                               40.09
          BUPL = OGAM-OBET
C
          IF (FVH.LT.ALOW ) FVH = ALOW
          IF (FVH.GT.BUPL ) FVH = BUPL
          OBHKT = 0.5*(1.0-SIN(PI*(FVH+OBET)/(2.0*OGAM)))
          IF (TESTFL) WRITE (PRTEST, 20) IXCGRD(1)-1, IYCGRD(1)-1,        40.01
     &           LOOP, HGT, WATHIG, HSIN, OBHKT                           40.01
  20      FORMAT (' test SWTRCF ', 2X, 3I5, ' dam level=', F6.2,
     &            ' depth=', F6.2, ' Hs=', F6.2, ' transm=', F6.3)        40.01
          IF (TESTFL .AND. ITEST.GE.140) WRITE (PRTEST, 22)
     &           OGAM, OBET, ALOW, BUPL, FVH                              40.01
  22      FORMAT (8X, 6E12.4)                                             40.01
C
C         Formulation of Goda/Seelig concerns ratio of waveheights.       40.09
C         Here we use action density so:                                  40.09
          TRCOEF = OBHKT*OBHKT
        ENDIF
C
C     *** REFLECTION ****
C     *** X1 X2 X3 ETC. are the coordinates of point according ***
C     *** with the scheme in the function TCROSS2 header       ***        40.04
        IF (OCREAL(OBSTA(INX+6)).GT. 0.) THEN                             40.09
C         Reflections are activated                                       40.09
          SQRTREF = OCREAL(OBSTA(INX+7))                                  40.09
          REFLCOEF = SQRTREF * SQRTREF                                    40.09
          LREFDIFF = OCREAL(OBSTA(INX+8))                                 40.18
          POWN  = OCREAL(OBSTA(INX+9))                                    40.18
          X3 = OCREAL(OBSTA(INX+2*1+11))                                  40.09
          Y3 = OCREAL(OBSTA(INX+2*1+12))                                  40.09
          NUMCOR = OBSTA(INX+1)                                           40.09
          DO JP = 2, NUMCOR                                               40.09
            X4 = OCREAL(OBSTA(INX+2*JP+11))                               40.09
            Y4 = OCREAL(OBSTA(INX+2*JP+12))                               40.09
            ICC = KCGRD(1)                                                40.09
            IF (ICC .GT. 1) THEN                                          40.09
              X1 = XCGRID(IXCGRD(1),IYCGRD(1))                            40.09
              Y1 = YCGRID(IXCGRD(1),IYCGRD(1))                            40.09
C                                                                         40.09
              ICGRD = 0                                                   40.09
              IF (KGRPNT(IXCGRD(LOOP+1),IYCGRD(LOOP+1)).GT.1) THEN        40.09
                X2    = XCGRID(IXCGRD(LOOP+1),IYCGRD(LOOP+1))             40.09
                Y2    = YCGRID(IXCGRD(LOOP+1),IYCGRD(LOOP+1))             40.09
                ICGRD = KCGRD(LOOP+1)                                     40.09
 
 
                IF (ICGRD.GT.1) THEN                                      40.09
                  IF (TCROSS2(X1, X2, X3, X4, Y1, Y2, Y3, Y4,             40.14
     &                        XONOBST)) THEN                              40.14
                    CALL OBSTLINE(X1,Y1,X2,Y2,X3,Y3,X4,Y4,XGTL,EXC)       40.09
                    CALL REFLECT(AC2, AC2REF, IMATRA, X1, Y1, X2, Y2,     40.09
     &                         X3, Y3, X4, Y4, XGTL, EXC, CAX,            40.09
     &                         CAY, RDX, RDY, LOOP, TRCOEF,               40.09
     &                         REFLCOEF, LREFDIFF, POWN, ANYBIN)          40.18 40.09
                  ENDIF                                                   40.14
                ENDIF                                                     40.09
              ENDIF                                                       40.09
            ENDIF                                                         40.09
            X3 = X4                                                       40.09
            Y3 = Y4                                                       40.09
          END DO                                                          40.09
        END IF
C
        IF (ITEST .GE. 120)  WRITE (PRTEST,10)
     &  IXCGRD(1)-1, IYCGRD(1)-1, NMPO, TRCOEF
  10    FORMAT(' SWTRCF: Point=', 2I5, ' NMPO  = ', I5, ' transm ',       40.03
     &  F8.3)                                                             40.03
  40    DO IS = 1, MSC                                                   040697
          DO ID = 1, MDC
            OBREDF(ID,IS,LOOP) = TRCOEF
          ENDDO
        ENDDO
  30  CONTINUE
      RETURN
C     * end of SUBROUTINE SWTRCF
      END
C
************************************************************************  40.09
*                                                                      *  40.09
      SUBROUTINE OBSTLINE (X1, Y1, X2, Y2, X3, Y3, X4, Y4, XGTL, EXC)     40.09
*                                                                      *  40.09
************************************************************************  40.09
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE                                                       40.09
C                                                                         40.09
      INCLUDE 'ocpcomm4.inc'                                              40.09
C                                                                         40.09
C  0. Authors                                                             40.09
C                                                                         40.09
C     40.09  Annette Kieftenburg                                          40.09
C                                                                         40.09
C  1. Updates                                                             40.09
C                                                                         40.09
C     40.09, Dec 99: Function created                                     40.09
C                                                                         40.09
C  2. Purpose                                                             40.09
C                                                                         40.09
C     Find out whether vector (X1,Y1) lies 'above' the line piece         40.09
C     through (X3,Y3) and (X4,Y4)                                         40.09
C                                                                         40.09
C  3. Method                                                              40.09
C                                                                         40.09
C     Calculate coefficients a and b in equation Y = A*X +B               40.09
C     Check whether Y1 is greater than A*X1 + B                           40.09
C     Then XGTL is true (else false)                                      40.09
C                                                                         40.09
C  4. Argument variables                                                  40.09
C                                                                         40.09
C     X1, Y1  inp    user coordinates of one end of grid link             40.09
C     X3, Y3  inp    user coordinates of one end of obstacle side         40.09
C     X4, Y4  inp    user coordinates of other end of obstacle side       40.09
C     EXC     outp   indicates whether X4 = X3, which results in 'excep-  40.09
C                    tional' situation (line parallel to y-axis)          40.09
C     XGTL    outp   indicates whether (X1,Y1) is situated 'above'        40.09
C                    linepiece (X3,Y3) (X4,Y4)                            40.09
C                                                                         40.09
      REAL       X1, X2, X3, X4, Y1, Y2, Y3, Y4                           40.09
      LOGICAL    XGTL, EXC                                                40.09
C                                                                         40.09
C  5. Parameter variables                                                 40.09
C                                                                         40.09
C  6. Local variables                                                     40.09
C                                                                         40.09
C     A,B        dummy variables                                          40.09
C     IENT       number of entries of subroutine OBSTLINE                 40.09
C     EPS        small real                                               40.09
C     RES        residual                                                 40.09
C                                                                         40.09
      INTEGER    IENT                                                     40.09
      REAL A, B, RES, EPS                                                 40.09
C                                                                         40.09
C  7. Common Blocks used                                                  40.09
C                                                                         40.09
C  8. Subroutines used                                                    40.09
C                                                                         40.09
C  9. Subroutines calling                                                 40.09
C                                                                         40.09
C     SWTRCF                                                              40.09
C                                                                         40.09
C 10. Error messages                                                      40.09
C                                                                         40.09
C 11. Remarks                                                             40.09
C                                                                         40.09
C 12. Structure                                                           40.09
C                                                                         40.09
C     If .NOT. (denominator of A = denominator of B = 0)                  40.09
C              (i.e. parallel to y-axis)                                  40.09
C     Then                                                                40.09
C       Calculate coefficients A and B in y = Ax + B                      40.09
C       EXC is .False.                                                    40.09
C       RESidual  = Y1 - (A*X1+B)                                         40.09
C       If RESidual <= Eps                                                40.09
C       If Residual > 0                                                   40.09
C       Then XGTL is .True.                                               40.09
C       Else XGTL is .False.                                              40.09
C     Else                                                                40.09
C       EXC is .True.                                                     40.09
C                                                                         40.09
C 13. Source text                                                         40.09
C ======================================================================  40.09
      SAVE IENT                                                           40.09
      DATA IENT/0/                                                        40.09
      IF (LTRACE) CALL STRACE (IENT,'OBSTLINE')                           40.09
C                                                                         40.09
      EPS = EPSILON(X1)*SQRT((X2-X1)*(X2-X1)+(Y2-Y1)*(Y2-Y1))             40.09
      IF (EPS ==0) EPS = TINY(X1)                                         40.09
      XGTL= .FALSE.                                                       40.09
C                                                                         40.09
      IF ( .NOT.( ABS(X4-X3).LE.EPS ) )THEN                               40.09
        A = (Y4-Y3)/(X4-X3)                                               40.09
        B = (X4*Y3-Y4*X3)/(X4-X3)                                         40.09
        EXC = .FALSE.                                                     40.09
C                                                                         40.09
        RES = Y1 - (A*X1+B)                                               40.09
        IF ( RES .GE. 0. ) THEN                                           40.09
          XGTL = .TRUE.                                                   40.09
        ELSE                                                              40.09
          XGTL = .FALSE.                                                  40.09
        ENDIF                                                             40.09
C                                                                         40.09
      ELSE                                                                40.09
        A = -9999.                                                        40.09
        B = -9999.                                                        40.09
        EXC = .TRUE.                                                      40.09
      END IF                                                              40.09
C                                                                         40.09
      RETURN                                                              40.09
C     End of subroutine OBSTLINE                                          40.09
      END                                                                 40.09
C
C************************************************************************ 40.09
C                                                                       * 40.09
      SUBROUTINE REFLECT (AC2, AC2REF, IMATRA, X1, Y1, X2, Y2, X3, Y3,    40.09
     &                    X4, Y4, XGTL, EXC, CAX, CAY, RDX, RDY,          40.09
     &                    LOOP, TRCOEF, REF0, LREFDIFF, POWN, ANYBIN)     40.18 40.09
C                                                                       * 40.09
C************************************************************************ 40.09
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
!                                                                         40.09
      IMPLICIT NONE                                                       40.09
!                                                                         40.09
      INCLUDE 'swcomm3.inc'                                               40.09
      INCLUDE 'ocpcomm4.inc'                                              40.18
!  0. Authors                                                             40.09
!                                                                         40.09
!     40.09  Annette Kieftenburg                                          40.09
!     40.18  Annette Kieftenburg                                          40.09
!                                                                         40.09
!  1. Updates                                                             40.09
!                                                                         40.09
!     40.09, Nov. 99: Subroutine created                                  40.09
!     40.18, Apr. 01: Scattered reflection against obstables added        40.18
!                                                                         40.09
!  2. Purpose                                                             40.09
!                                                                         40.09
!     Computation of REFLECTIONS near obstacles                           40.09
!                                                                         40.09
!  3. Method                                                              40.09
!                                                                         40.09
!     Determine the angle of the obstacle,                                40.09
!     Determine the angles between which reflections should be taken      40.09
!     into account                                                        40.09
!     Determine redistribution function                                   40.18
!     Determine reflected action density (corrected for angle obstacle    40.09
!     and if option is on: redistribute energy)                           40.18
!     Add reflected spectrum to right hand side of matrix equation        40.09
!                                                                         40.09
!  4. Modules used                                                        40.18
!                                                                         40.18
!     --                                                                  40.18
!                                                                         40.18
!  5. Argument variables                                                  40.09
!                                                                         40.09
!     AC2      inp  Nonstationary case) action density as function        40.09
!                   of D,S,X,Y at time T+DT                               40.09
!     AC2REF   outp (Nonstationary case) reflected action density         40.09
!                   as function of D,S,X,Y at time T+DT                   40.09
!     CAX      inp  Propagation velocity                                  40.09
!     CAY      inp  Propagation velocity                                  40.09
!     EXC      inp  Indicates whether X4 = X3, which results in exception 40.09
!                   situation (line parallel to y-axis)                   40.09
!     IMATRA   i/o  Right hand side of matrix equation                    40.09
!     LOOP     inp  Indicates which link is analyzed: 1 -> neighbour in x 40.09
!                                                     2 -> neighbour in y 40.09
!     LREFDIFF inp  Indicates whether reflected energy should be          40.18
!                   reflected (1) or not (0)                              40.18
!     POWN     inp  User defined power of redistribution function         40.18
!     REF0     inp  User defined reflection coefficient                   40.18
!                   w.r.t. waveheight (0<=REF0<=1)                        40.18
!     TRCOEF   inp  User defined transmission coefficient                 40.09
!     RDX,RDY  inp  Array containing spatial derivative coefficients      40.09
!     XGTL     inp  Indicates whether (X1,Y1) is situated 'above'         40.09
!                   linepiece (X3,Y3) (X4,Y4)                             40.09
!     X1, Y1   inp  Coordinates of computational grid point under         40.09
!                   consideration                                         40.09
!     X2, Y2   inp  Coordinates of computational grid point neighbour     40.09
!     X3, Y3   inp  User coordinates of one end of obstacle side          40.09
!     X4, Y4   inp  User coordinates of other end of obstacle side        40.09
!                                                                         40.09
      REAL       :: AC2(MDC,MSC,MCGRD), AC2REF(MDC,MSC)                   40.18
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL       :: CAX(MDC,MSC,MICMAX), CAY(MDC,MSC,MICMAX)              40.18 40.22
      REAL       :: IMATRA(MDC,MSC)                                       40.18
      REAL       :: RDX(2), RDY(2)                                        40.18
      REAL       :: REF0, TRCOEF                                          40.18
      REAL       :: X1, X2, X3, X4, Y1, Y2, Y3, Y4                        40.18
      LOGICAL    :: EXC, XGTL, ANYBIN(MDC,MSC)                            40.18
      INTEGER    :: LOOP                                                  40.18
      REAL       :: POWN, LREFDIFF                                        40.18
!                                                                         40.18
      INTENT (IN)     AC2, CAX, CAY, RDX, RDY, REF0, TRCOEF, X1, X2,      40.18
     &                X3, X4, Y1, Y2, Y3, Y4, EXC, XGTL, ANYBIN, LOOP,    40.18
     &                POWN, LREFDIFF                                      40.18
      INTENT (IN OUT) AC2REF, IMATRA                                      40.18
!                                                                         40.09
!  6. Parameter variables                                                 40.09
!                                                                         40.09
!     EPS2    constant used for redistribution function                   40.18
!                                                                         40.18
      REAL    :: EPS2                                                     40.18
!                                                                         40.18
!  7. Local variables                                                     40.09
!                                                                         40.09
!     AC2NEW  new action density spectrum (after optional redistribution) 40.18
!     AC2RED  redistributed action density spectrum                       40.18
!     BETA    direction of obstacle                                       40.09
!     CORID   correction integer for angle of reflected wave              40.09
!     C1      counter for mirrored spectrum                               40.09
!     C2,C3   counters for mirrored spectrum (for obstacle with possitive 40.09
!             resp. negative angle)                                       40.09
!     dBETA   'residual' of (integer) correction CORID,                   40.09
!             used as weight factor                                       40.09
!     DELTA   direction of line piece (X1,Y1) (X4,Y4)                     40.09
!     DUMD    dummy variable for nearest integer for angle delta          40.09
!     DUMG    dummy variable for nearest integer for angle delta          40.09
!     DUMN1   dummy variable                                              40.18
!     DUMN2   dummy variable                                              40.18
!     EPS     gridsize dependent dummy (small) variable                   40.18
!     GAMMA_  direction of line piece (X1,Y1) (X3,Y3)                     40.09
!     ID,IS   counters for directions and frequencies                     40.09
!     IDD,IDG nearest integer for angle DELTA resp. GAMMA                 40.09
!     IDJ     counter for directions                                      40.18
!     IDMAX   maximum of IDG,IDD                                          40.09
!     IDMIN   minimum of IDG,IDD                                          40.09
!     IDR     counter for directions                                      40.18
!     IDRJ    counter for directions                                      40.18
!     IENT    number of entries of this subroutine                        40.09
!     MAXID   absolute maximum for counter (ID) for width                 40.18
!     MMRW    maximum or minimum counter for P                            40.18
!                         (modulus of reflected width with minus sign)    40.18
!     NORM    norm used to normalize redistribution function P            40.18
!     P       normalized redistribution function                          40.18
!     PMRW    maximum or minimum counter for P                            40.18
!                         (modulus of reflected width with minus sign)    40.18
!     R       reflection coefficient matrix                               40.09
!     REDANG  angle used in redistribution function to avoid that the re- 40.18
!             distributed REFLECTED energy directed TOWARDS the obstacle  40.18
!     SUMP    total sum of redistribution function P                      40.18
!     WIDTH   counter used to determine width of redistribution function  40.18
!     WRES    resulting width of redistribution function P                40.18
!                                                                         40.09
      REAL    :: AC2NEW(MDC,MSC)                                          40.18
      REAL    :: AC2RED(MDC,MDC,MSC)                                      40.18
      REAL    :: BETA, dBETA, DELTA                                       40.09
      REAL    :: DUMN1, DUMN2                                             40.18
      REAL    :: EPS, GAMMA_                                              40.09
      REAL    :: NORM, P(MDC,MDC)                                         40.18
      REAL    :: R(MDC,MSC)                                               40.09
      REAL    :: REDANG, SUMP                                             40.18
      INTEGER :: C1, C2, C3, CORID, DUMD, DUMG, ID, IDD, IDG, IDMAX       40.09
      INTEGER :: IDMIN                                                    40.09
      INTEGER :: IDJ, IDR, IDRJ, MAXID, MMRW, PMRW, WIDTH, WRES           40.18
      INTEGER :: IENT, IS                                                 40.09
      LOGICAL :: STPNOW                                                   40.09
!                                                                         40.18
!  8. Subroutines used                                                    40.09
!                                                                         40.18
!     GAMMLN  natural logaritm of the (standard) GAMMA function           40.18
!                                                                         40.18
      REAL    :: GAMMLN                                                   40.18
!                                                                         40.09
!  9. Subroutines calling                                                 40.09
!                                                                         40.09
!     SWTRCF                                                              40.09
!                                                                         40.09
! 10. Error messages                                                      40.09
!                                                                         40.09
!     if obstacle linepiece is of length < EPS                            40.09
!                                                                         40.09
! 11. Remarks                                                             40.09
!                                                                         40.09
!    -In case the obstacle cuts exactly through computational grid point, 40.09
!     the obstacle should be moved a bit with subroutine OBSTMOVE.        40.09
!    -The order of magnitude of the obstacle linepiece is assumed to be   40.09
!     'long enough' compared to grid resolution (> 0.5*sqrt(dx^2+dy^2))   40.09
!     (if this restriction is violated, the reflections due to an obsta-  40.09
!     cle of one straight line can be very different from a similar line  40.09
!     consisting of several pieces (because only the directions of the    40.09
!     spectrum that are directed towards the obstacle linepiece are       40.09
!     reflected).                                                         40.09
!    -There should be only one intersection per computational gridcell.   40.09
!     Therefore it is better to avoid sharp edges in obstacles.           40.18
!                                                                         40.09
! 12. Structure                                                           40.09
!                                                                         40.09
!     Determine angle of obstacle, Beta                                   40.09
!       If Beta < - PI/2 then Beta + PI                                   40.09
!       If Beta >   PI/2 then Beta - PI                                   40.09
!     Calculate correction on counter for direction CORID and weight      40.09
!     factor dBeta                                                        40.09
!     Determine maximum and minimum angle for which reflection should     40.09
!     be taken into account                                               40.09
!                                                                         40.18
!     In option is on: determine redistribution function                  40.18
!                      determine redistibuted action density spectrum     40.18
!                      (first cut off directions, then redistribute)      40.18
!     Else cut off directions not pointing towards obstacle               40.18
!                                                                         40.18
!     Determine reflected action density                                  40.09
!     by reversing counter and correcting the angle with 2*Beta           40.09
!     i.e. correct counter by NINT(2*Beta) and take weighted average      40.09
!                                                                         40.09
!     Add reflected spectrum to right hand side of matrix equation        40.09
!                                                                         40.09
! 13. Source text                                                         40.09
!                                                                         40.18
      SAVE     IENT                                                       40.09
      DATA     IENT /0/                                                   40.09
      CALL STRACE (IENT, 'REFLECT')                                       40.09
!                                                                         40.09
!     initialization                                                      40.09
      DO IS = 1, MSC                                                      40.09
        DO ID = 1, MDC                                                    40.09
          R(ID,IS) = 0.                                                   40.09
          AC2REF(ID,IS) = 0.                                              40.09
          AC2NEW(ID,IS) = 0.                                              40.18
          DO IDJ = 1, MDC                                                 40.18
            AC2RED(ID,IDJ,IS) = 0.                                        40.18
          END DO                                                          40.18
        END DO                                                            40.09
      END DO                                                              40.09
!                                                                         40.09
      EPS = EPSILON(X1)*SQRT((X2-X1)*(X2-X1)+(Y2-Y1)*(Y2-Y1))             40.09
      IF (EPS ==0) EPS = TINY(X1)                                         40.09
!                                                                         40.09
!     Determine angle of obstacle BETA, and related                       40.09
!                                                                         40.09
      IF (.NOT. ((ABS(Y4-Y3).LE.EPS) .AND. (ABS(X4-X3).LE.EPS)) ) THEN    40.09
        BETA = ATAN2((Y4-Y3),(X4-X3))                                     40.09
      ELSE                                                                40.09
        CALL MSGERR (3, 'Obstacle contains line piece of length 0!')      40.09
      END IF                                                              40.09
      IF (BETA.LE.-PI/2.) THEN                                            40.09
        BETA = BETA + PI                                                  40.09
      ELSE IF (BETA.GT.PI/2.) THEN                                        40.09
        BETA = BETA - PI                                                  40.09
      END IF                                                              40.09
!                                                                         40.09
      CORID = NINT(2.*BETA/DDIR)                                          40.09
      dBETA = (2.*BETA)/DDIR-CORID                                        40.09
!                                                                         40.09
!     Wave components that are directed to obstacle are lying between     40.09
!     GAMMA_ and DELTA.                                                   40.09
!     In case MDC is odd and the absolute angle (DELTA or GAMMA_) is      40.09
!     larger then PI/2 a trick is used to find the correct  nearest       40.09
!     integer.                                                            40.09
!                                                                         40.09
        GAMMA_ = ATAN2((Y3-Y1),(X3-X1))                                   40.09
        IF ( (MOD(MDC,2).EQ.0) .OR.                                       40.09
     &     ((MOD(MDC,2).EQ.1).AND.(ABS(GAMMA_).LT.PI/2.)) ) THEN          40.09
          DUMG = NINT(GAMMA_/DDIR)                                        40.09
        ELSE                                                              40.09
          DUMG = SIGN(1.,GAMMA_)*(MDC+1)/2 -                              40.09
     &           NINT((SIGN(1.,GAMMA_)*PI-GAMMA_)/DDIR)                   40.09
        ENDIF                                                             40.09
!                                                                         40.09
        IF (DUMG.GT.0) THEN                                               40.09
          IDG = DUMG                                                      40.09
        ELSE                                                              40.09
          IF (DUMG.NE.0) THEN                                             40.09
            IDG = MDC+DUMG+1                                              40.09
          ELSE                                                            40.09
            IF (GAMMA_.LE.0.) THEN                                        40.09
              IDG = MDC                                                   40.09
            ELSE                                                          40.09
              IDG= 1                                                      40.09
            ENDIF                                                         40.09
          ENDIF                                                           40.09
        ENDIF                                                             40.09
!                                                                         40.09
        DELTA = ATAN2((Y4-Y1),(X4-X1))                                    40.09
        IF ( (MOD(MDC,2).EQ.0) .OR.                                       40.09
     &     ((MOD(MDC,2).EQ.1).AND.(ABS(DELTA).LT.PI/2.)) ) THEN           40.09
          DUMD = NINT(DELTA/DDIR)                                         40.09
        ELSE                                                              40.09
          DUMD = SIGN(1.,DELTA)*(MDC+1)/2 -                               40.09
     &           NINT((SIGN(1.,DELTA)*PI-DELTA)/DDIR)                     40.09
        ENDIF                                                             40.09
!                                                                         40.09
        IF (DUMD.GT.0) THEN                                               40.09
          IDD = DUMD                                                      40.09
        ELSE                                                              40.09
          IF (DUMD.NE.0) THEN                                             40.09
            IDD = MDC+DUMD+1                                              40.09
          ELSE                                                            40.09
            IF (DELTA.LE.0.) THEN                                         40.09
              IDD = MDC                                                   40.09
            ELSE                                                          40.09
              IDD= 1                                                      40.09
            ENDIF                                                         40.09
          ENDIF                                                           40.09
        ENDIF                                                             40.09
!                                                                         40.09
      IF (IDG .GE. IDD) THEN                                              40.09
        IDMIN =IDD                                                        40.09
        IDMAX =IDG                                                        40.09
      ELSE                                                                40.09
        IDMIN =IDG                                                        40.09
        IDMAX =IDD                                                        40.09
      ENDIF                                                               40.09
!                                                                         40.09
!     For those directions that are pointed towards the obstacle the      40.09
!     reflection coefficients have a certain value. For the other         40.09
!     directions it is set to zero.                                       40.09
!                                                                         40.09
      IF (IDMAX .NE. IDMIN) THEN                                          40.09
        IF ( ( (EXC .AND. X3.GT.X1)  .OR.                                 40.18 40.09
     &         (.NOT.XGTL .AND. BETA.LE.0.).OR.                           40.09
     &         (XGTL .AND. BETA.GT.0.) )                                  40.09
     &       .AND.                                                        40.09
     &       ( (GAMMA_*DELTA.LT.0.) .OR.                                  40.09
     &       (GAMMA_*DELTA.EQ.0. .AND.(GAMMA_.GT.0. .OR. DELTA.GT.0.)) )  40.09
     &     ) THEN                                                         40.09
!                                                                         40.09
          DO IS = 1, MSC                                                  40.09
            DO ID = 1, MDC                                                40.09
              IF ((ID.GE.IDMAX).OR.(ID.LE.IDMIN)) THEN                    40.09
                R(ID,IS) = REF0*(1. - TRCOEF)                             40.09
              ELSE                                                        40.09
                R(ID,IS) = 0.                                             40.09
              END IF                                                      40.09
            END DO                                                        40.09
          END DO                                                          40.09
        ELSE                                                              40.09
          DO IS = 1, MSC                                                  40.09
            DO ID = 1, MDC                                                40.09
              IF ((ID.GE.IDMIN).AND.(ID.LE.IDMAX)) THEN                   40.09
                R(ID,IS) = REF0*(1. - TRCOEF)                             40.09
              ELSE                                                        40.09
                R(ID,IS) = 0.                                             40.09
              END IF                                                      40.09
            END DO                                                        40.09
          END DO                                                          40.09
        END IF                                                            40.09
      ELSE                                                                40.09
        DO IS = 1, MSC                                                    40.09
            R(IDMIN,IS) = REF0*(1.-TRCOEF)                                40.09
        END DO                                                            40.09
      END IF                                                              40.09
!                                                                         40.18
!     Determine the width of the redistribution function                  40.18
      IF (LREFDIFF.EQ.1.) THEN                                            40.18
        MAXID  = INT(MDC/4)                                               40.18
        WIDTH = 0                                                         40.18
        EPS2  = 0.01                                                      40.18
        DO ID = 1, MAXID                                                  40.18
          IF ((COS(ID*DDIR)**POWN).GE.EPS2 ) THEN                         40.18
            WIDTH = WIDTH +1                                              40.18
          END IF                                                          40.18
        END DO                                                            40.18
        WRES = WIDTH                                                      40.18
!                                                                         40.18
!       Initialize redistribution function                                40.18
!                                                                         40.18
        IF (WRES > 0) THEN                                                40.18
          DUMN1 = (1+POWN)/2.                                             40.18
          DUMN2 = 1+POWN/2.                                               40.18
          NORM = SQRT(PI)*EXP(GAMMLN(DUMN1)-GAMMLN(DUMN2))                40.18
          DO IDRJ = 1, MDC                                                40.18
            DO IDR = 1, MDC                                               40.18
              P(IDR,IDRJ) = 0.                                            40.18
            END DO                                                        40.18
          END DO                                                          40.18
!                                                                         40.18
!         Determine maximum and minimum counters of redistribution        40.18
!         function and the function itself                                40.18
          DO IDR = 1, MDC                                                 40.18
            MMRW = MOD(IDR-WRES,MDC)                                      40.18
            PMRW = MOD(IDR+WRES,MDC)                                      40.18
            SUMP = 0                                                      40.18
            IF (MMRW <= 0) MMRW = MMRW + MDC                              40.18
            IF (PMRW <= 0) PMRW = PMRW + MDC                              40.18
            IF (PMRW <= MMRW) THEN                                        40.18
              IF (PMRW.NE.1) THEN                                         40.18
                DO IDRJ = 1,PMRW-1                                        40.18
                  P(IDR,IDRJ) = DDIR*(COS((IDR-IDRJ)*DDIR)**POWN)/NORM    40.18
                  SUMP = SUMP + P(IDR,IDRJ)                               40.18
                END DO                                                    40.18
              ENDIF                                                       40.18
              IF (MMRW.NE.MDC) THEN                                       40.18
                DO IDRJ = MMRW+1,MDC                                      40.18
                  P(IDR,IDRJ) = DDIR*(COS((IDR-IDRJ)*DDIR)**POWN)/NORM    40.18
                  SUMP = SUMP + P(IDR,IDRJ)                               40.18
               END DO                                                     40.18
              ENDIF                                                       40.18
              P(IDR,MMRW) =(1.-SUMP)/2.                                   40.18
              P(IDR,PMRW) =(1.-SUMP)/2.                                   40.18
            ELSE                                                          40.18
              IF (MMRW.NE.MDC .AND. PMRW.NE.1) THEN                       40.18
                DO IDRJ = MMRW+1,PMRW-1                                   40.18
                  P(IDR,IDRJ) = DDIR*(COS((IDR-IDRJ)*DDIR)**POWN)/NORM    40.18
                  SUMP = SUMP + P(IDR,IDRJ)                               40.18
                END DO                                                    40.18
              ENDIF                                                       40.18
              P(IDR,MMRW) =(1.-SUMP)/2.                                   40.18
              P(IDR,PMRW) =(1.-SUMP)/2.                                   40.18
            ENDIF                                                         40.18
          END DO                                                          40.18
        ENDIF                                                             40.18
      ENDIF                                                               40.18
!                                                                         40.18
!     To avoid that the redistributed REFLECTed action density is         40.18
!     directed TOWARDS the obstacle, those directions are exluded.        40.18
      DO IDR = 1, MDC                                                     40.18
        DO IDJ = 1, MDC                                                   40.18
          REDANG = (IDJ-1)*DDIR + 0.5*DDIR                                40.18
          IF ((.NOT.XGTL .AND. BETA.LE.0.).OR.                            40.18
     &       (XGTL .AND. BETA.GT.0.) ) THEN                               40.18
            IF ((BETA .LE. REDANG) .AND. (REDANG .LE. BETA+PI)) THEN      40.18
              P(IDR,IDJ) = 0                                              40.18
            ENDIF                                                         40.18
          ELSE                                                            40.18
            IF ((REDANG .LE. BETA) .OR. (REDANG .GE. BETA+PI)) THEN       40.18
              P(IDR,IDJ) = 0                                              40.18
            ENDIF                                                         40.18
          ENDIF                                                           40.18
        END DO                                                            40.18
      END DO                                                              40.18
!                                                                         40.18
      IF ((LREFDIFF.EQ.1.) .AND. (WRES > 0)) THEN                         40.18
!     If reflectionis not specular                                        40.18
!     Determine redistributed action density spectrum per direction,      40.18
!     cutting of directions not directed towards the obstacle             40.18
          DO IS = 1, MSC                                                  40.18
            DO IDR = 1, MDC                                               40.18
              DO IDJ = 1, MDC                                             40.18
                AC2RED(IDR,IDJ,IS) = AC2(IDR,IS,KCGRD(1))*R(IDR,IS)       40.18
     &                                          *P(IDR,IDJ)               40.18
              END DO                                                      40.18
            END DO                                                        40.18
          END DO                                                          40.18
!         Sum for all components IDR to determine new action density      40.18
!         in component IDJ                                                40.18
          DO IS = 1, MSC                                                  40.18
            DO IDJ = 1, MDC                                               40.18
              AC2NEW(IDJ,IS) =0                                           40.18
              DO IDR = 1, MDC                                             40.18
                AC2NEW(IDJ,IS) = AC2NEW(IDJ,IS)+AC2RED(IDR,IDJ,IS)        40.18
              END DO                                                      40.18
            END DO                                                        40.18
          END DO                                                          40.18
      ELSE                                                                40.18
!       Else determine 'new action density' to be used for reflection by  40.18
!       only cutting of directions that are not directed towards the      40.18
!       obstacle                                                          40.18
        DO IS = 1, MSC                                                    40.18
          DO ID = 1, MDC                                                  40.18
            AC2NEW(ID,IS) = AC2(ID,IS,KCGRD(1))*R(ID,IS)                  40.18
          END DO                                                          40.18
        END DO                                                            40.18
      ENDIF                                                               40.18
!                                                                         40.09
!     Determine reflected action denstity spectrum by reversing and       40.09
!     correcting for obstacle angle in this counter (use C1), take        40.09
!     weighted average using dBETA and neighbour in theta direction (C2   40.09
!     for positive BETA or C3 for negative BETA)                          40.09
!     Add reflected spectrum to right hand side of matrix equation        40.09
!     (for every (ID,IS)).                                                40.18
!                                                                         40.09
      DO IS = 1, MSC                                                      40.09
        DO ID = 1, MDC                                                    40.09
          IF (ANYBIN(ID,IS)) THEN                                         40.09
            C1 = MOD((MDC-ID+1+CORID),MDC)                                40.09
            IF (C1.LE.0) C1 = C1+MDC                                      40.09
!                                                                         40.09
            IF (BETA .LT. 0.) THEN                                        40.09
              C2 = MOD((MDC-ID+1+CORID+1),MDC)                            40.09
              IF (C2.LE.0) C2 = C2+MDC                                    40.09
              IF (dBETA .GE. 0.) THEN                                     40.09
                AC2REF(ID,IS) =                                           40.09
     &            (RDX(LOOP)*CAX(ID,IS,1) + RDY(LOOP)*CAY(ID,IS,1))       40.09
     &            * ( (1.-dBETA)*AC2NEW(C1,IS)                            40.18
     &            + dBETA*AC2NEW(C2,IS))                                  40.18
              ELSE                                                        40.09
                AC2REF(ID,IS) =                                           40.09
     &            (RDX(LOOP)*CAX(ID,IS,1) + RDY(LOOP)*CAY(ID,IS,1))       40.09
     &             * ( (1.+dBETA)*AC2NEW(C1,IS)                           40.18
     &             - dBETA*AC2NEW(C2,IS))                                 40.18
              ENDIF                                                       40.09
              IMATRA(ID,IS) = IMATRA(ID,IS) + AC2REF(ID,IS)               40.09
            ELSE                                                          40.09
              C3 = MOD((MDC-ID+1+CORID-1),MDC)                            40.09
              IF (C3.LE.0) C3 = C3+MDC                                    40.09
              IF (dBETA .GE. 0.) THEN                                     40.09
                AC2REF(ID,IS) =                                           40.09
     &            (RDX(LOOP)*CAX(ID,IS,1) + RDY(LOOP)*CAY(ID,IS,1))       40.09
     &            * ( (1.-dBETA)*AC2NEW(C1,IS)                            40.18
     &            + dBETA*AC2NEW(C3,IS))                                  40.18
              ELSE                                                        40.09
                AC2REF(ID,IS) =                                           40.09
     &            (RDX(LOOP)*CAX(ID,IS,1) + RDY(LOOP)*CAY(ID,IS,1))       40.09
     &             * ( (1.+dBETA)*AC2NEW(C1,IS)                           40.18
     &             - dBETA*AC2NEW(C3,IS))                                 40.18
              ENDIF                                                       40.09
              IMATRA(ID,IS) = IMATRA(ID,IS) + AC2REF(ID,IS)               40.09
            END IF                                                        40.09
          END IF                                                          40.09
        END DO                                                            40.09
      END DO                                                              40.09
!                                                                         40.18
      IF (STPNOW()) RETURN                                                40.09
      RETURN                                                              40.09
!     End of subroutine REFLECT                                           40.09
      END                                                                 40.09
!
************************************************************************
*                                                                      *
      SUBROUTINE SSHAPE (ACLOC, SPCSIG, SPCDIR, FSHAPL, DSHAPL)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C            Roeland Ris
C            Roberto Padilla
C     30.73: Nico Booij
C     30.80: Nico Booij
C     30.82: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C            Dec. 92: new for SWAN
C            Dec. 96: option MEAN freq. introduced see LOGPM
C     30.73, Nov. 97: revised in view of new boundary treatment
C     30.82, Sep. 98: Added error message in case of non-convergence
C     30.80, Oct. 98: correction suggested by Mauro Sclavo, and renames
C                     computation of tail added to improve accuracy
C     30.82, Oct. 98: Updated description of several variables
C     40.02, Oct. 00: Modified test write statement to avoid division by MS=0
C
C  2. Purpose
C
C     Calculating of energy density at boundary point (x,y,sigma,theta)
C
C  3. Method (updated...)
C
C     see: M. Yamaguchi: Approximate expressions for integral properties
C          of the JONSWAP spectrum; Proc. JSCE, No. 345/II-1, pp. 149-152,
C          1984.
C
C     computation of mean period: see Swan system documentation
C
C  4. Argument variables
C
C   o ACLOC : Energy density at a point in space
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C
      REAL    ACLOC(MDC,MSC)
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
C
C i   DSHAPL: Directional distribution
C i   FSHAPL: Shape of spectrum:
C             =1; Pierson-Moskowitz spectrum
C             =2; Jonswap spectrum
C             =3; bin
C             =4; Gauss curve
C             (if >0: period is interpreted as peak per.
C              if <0: period is interpreted as mean per.)
C
      INTEGER FSHAPL, DSHAPL                                              40.00
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ID       counter of directions
C     IS       counter of frequencies
C     LSHAPE   absolute value of FSHAPL
C
      INTEGER  ID, IS, LSHAPE
C
C     PKPER    peak period                                                30.80
C     APSHAP   aux. var. used in computation of spectrum
C     AUX1     aux. variable
C     AUX2          ,,
C     AUX3          ,,
C     COEFF    coefficient for behaviour around the peak (Jonswap)
C     CPSHAP   aux. var. used in computation of spectrum
C     CTOT     total energy
C     CTOTT    total energy (used for comparison)
C     DIFPER   aux. var. used to select bin closest to given frequency
C     MPER
C     MS       power in directional distribution
C     RA       action density
C     SALPHA
C     SF       frequency (Hz)
C     SF4      SF**4
C     SF5      SF**5
C     FPK      frequency corresponding to peak period (1/PKPER)           30.80
C     FPK4     FPK**4
C     SYF      peakedness parameter
C
      REAL     APSHAP, AUX1, AUX2, AUX3
      REAL     COEFF ,SYF   ,MPER  ,CTOT  ,CTOTT,PKPER  ,DIFPER
      REAL     MS
      REAL     RA    ,SALPHA,SF   ,SF4   ,SF5   ,FPK   ,FPK4
C
C     LOGPM    indicates whether peak or mean frequency is used
C     DVERIF   logical used in verification of incident direction
C
      LOGICAL  LOGPM, DVERIF                                              40.00
C
C  7. Common Blocks used
C
C     PSHAPE   coefficients of spectral distribution (see remarks)
C     SPPARM   array containing integral wave parameters (see remarks)
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C 10. Error messages
C
C 11. Remarks
C
C     PSHAPE(1): SY0, peak enhancement factor (gamma) in Jonswap spectrum
C     PSHAPE(2): spectral width in case of Gauss spectrum in rad/s
C
C     SPPARM    real     input    incident wave parameters (Hs, Period,
C                                 direction, Ms (dir. spread))
C     SPPARM(1): Hs, sign. wave height
C     SPPARM(2): Wave period given by the user (either peak or mean)      30.80
C     SPPARM(3): average direction
C     SPPARM(4): directional spread
C
C     ---------------------------------------------------------------------
C
C     In the case of a JONSWAP spectrum the initial conditions are given by
C                   _               _       _       _       _
C                  |       _   _ -4  |     |       | S - S   |
C             2    |      |  S  |    |     |       |      p  |
C          a g     |      |  _  |    |  exp|-1/2 * |________ |* 2/pi COS(T-T  )
C E(S,D )= ___  exp|-5/4 *|  S  |    | G   |       | e * S   |              wi
C      wa    5     |      |   p |    |     |_      |_     p _|
C           S      |      |_   _|    |
C                  |_               _|
C
C   where
C         S   : rel. frequency
C
C         D   : Dir. of wave component
C          wa
C
C         a   : equili. range const. (Phillips' constant)
C         g   : gravity aceleration
C
C         S   : Peak frequency
C          p
C
C         G   : Peak enhancement factor
C         e   : Peak width
C
C         T   : local wind direction
C          wi
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       case shape
C       =1:   calculate value of Pierson-Moskowitz spectrum
C       =2:   calculate value of Jonswap spectrum
C       else: Give error message because of wrong shape
C       ----------------------------------------------------------------
C       if LOGPM is True
C       then calculate average period
C            if it differs from given average period
C            then recalculate peak period
C                 restart procedure to compute spectral shape
C       ----------------------------------------------------------------
C       for all spectral bins do
C            multiply all action densities by directional distribution
C       ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE     IENT
      DATA     IENT/0/
      CALL STRACE(IENT,'SSHAPE')
C
      IF (ITEST.GE.80) WRITE (PRTEST, 8) FSHAPL, DSHAPL,
     &      (SPPARM(JJ), JJ = 1,4)
   8  FORMAT (' entry SSHAPE ', 2I3, 4E12.4)
      IF (FSHAPL.LT.0) THEN
        LSHAPE = - FSHAPL
        LOGPM  = .FALSE.
      ELSE
        LSHAPE = FSHAPL
        LOGPM  = .TRUE.
      ENDIF
C
      PKPER = SPPARM(2)
      ITPER = 0
      IF (LSHAPE.EQ.3) THEN
C       select bin closest to given period
        DIFPER = 1.E10
        DO IS = 1, MSC
          IF (ABS(PKPER - PI2/SPCSIG(IS)) .LT. DIFPER) THEN
            ISP = IS
            DIFPER = ABS(PKPER - PI2/SPCSIG(IS))
          ENDIF
        ENDDO
      ENDIF
C
C     compute spectral shape using peak period PKPER                      30.80
C
 100  FPK  = (1./PKPER)                                                   30.80
      FPK4 = FPK**4
      IF (LSHAPE.EQ.1) THEN
        SALPHA = ((SPPARM(1) ** 2) * (FPK4)) * 5. / 16.
      ELSE IF (LSHAPE.EQ.2) THEN
C       *** SALPHA = alpha*(grav**2)/(2.*pi)**4)
        SALPHA = (SPPARM(1)**2 * FPK4) /
     &             ((0.06533*(PSHAPE(1)**0.8015)+0.13467)*16.)
      ENDIF
*
      CTOTT = 0.
      DO 300 IS = 1, MSC                                                  30.80
*
        IF (LSHAPE.EQ.1) THEN
*         *** LSHAPE = 1 : Pierson and Moskowitz ***
          SF = SPCSIG(IS) / PI2
          SF4 = SF**4
          SF5 = SF**5
          RA = (SALPHA/SF5)*EXP(-(5.*FPK4)/(4.*SF4))/(PI2*SPCSIG(IS))
          ACLOC(MDC,IS) = RA
        ELSE IF (LSHAPE.EQ.2) THEN
*         *** LSHAPE = 2 : JONSWAP ***
          SF = SPCSIG(IS)/(PI2)
          SF4 = SF**4
          SF5 = SF**5
          CPSHAP = 1.25 * FPK4 / SF4
          IF (CPSHAP.GT.10.) THEN                                         30.50
            RA = 0.
          ELSE
            RA = (SALPHA/SF5) * EXP(-CPSHAP)
          ENDIF
          IF (SF .LT. FPK) THEN
            COEFF = 0.07
          ELSE
            COEFF = 0.09
          ENDIF
          APSHAP =  0.5 * ((SF-FPK) / (COEFF*FPK)) **2
          IF (APSHAP.GT.10.) THEN                                         30.50
            SYF = 1.
          ELSE
            PPSHAP = EXP(-APSHAP)
            SYF = PSHAPE(1)**PPSHAP
          ENDIF
          RA = SYF*RA/(SPCSIG(IS)*PI2)
          ACLOC(MDC,IS) = RA
          IF (ITEST.GE.120) WRITE (PRTEST, 112)
     &                 SF, SALPHA, CPSHAP, APSHAP, SYF, RA
 112      FORMAT (' SSHAPE freq. ', 8E12.4)
        ELSE IF (LSHAPE.EQ.3) THEN
C
C         *** all energy concentrated in one BIN ***
C
          IF (IS.EQ.ISP) THEN
            ACLOC(MDC,IS) = ( SPPARM(1)**2 ) /
     &                     ( 16. * SPCSIG(IS)**2 * FRINTF )
          ELSE
            ACLOC(MDC,IS) = 0.
          ENDIF
        ELSE IF (LSHAPE.EQ.4) THEN
C
C         *** energy Gaussian distributed (wave-current tests) ***
C
          AUX1 = SPPARM(1)**2 / ( 16.* SQRT (PI2) * PSHAPE(2))
          AUX2 = ( SPCSIG(IS) - ( PI2 / PKPER ) )**2
          AUX3 = 2. * PSHAPE(2)**2
          RA = AUX1 * EXP ( -1. * AUX2 / AUX3 ) / SPCSIG(IS)
          ACLOC(MDC,IS) = RA
        ELSE
          IF (IS.EQ.1) THEN
            CALL MSGERR (2,'Wrong type for frequency shape')
            WRITE (PRINTF, *) ' -> ', FSHAPL, LSHAPE
          ENDIF
        ENDIF
        IF (ITEST.GE.10)
     &        CTOTT = CTOTT + FRINTF * ACLOC(MDC,IS) * SPCSIG(IS)**2
 300  CONTINUE
      IF (ITEST.GE.10) THEN
        IF (SPPARM(1).GT.0.01) THEN
          HSTMP = 4. * SQRT(CTOTT)
          IF (ABS(HSTMP-SPPARM(1)) .GT. 0.1*SPPARM(1))
     &    WRITE (PRINTF, 303) SPPARM(1), HSTMP
 303      FORMAT (' SSHAPE, deviation in Hs, should be ', F8.3,
     &            ', calculated ', F8.3)
        ENDIF
      ENDIF
*
*       if mean frequency was given recalculate PKPER and start anew
*
      IF (.NOT.LOGPM .AND. ITPER.LT.10) THEN
        ITPER = ITPER + 1
*       calculate average frequency
        AM0 = 0.
        AM1 = 0.
        DO IS = 1, MSC
          AS2 = ACLOC(MDC,IS) * (SPCSIG(IS))**2
          AS3 = AS2 * SPCSIG(IS)
          AM0 = AM0 + AS2
          AM1 = AM1 + AS3
        ENDDO
*       contribution of tail to total energy density
        PPTAIL = PWTAIL(1) - 1.                                           30.80
        APTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))              30.80
        AM0 = AM0 * FRINTF + APTAIL * AS2                                 30.80
        PPTAIL = PWTAIL(1) - 2.                                           30.80
        EPTAIL = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))              30.80
        AM1 = AM1 * FRINTF + EPTAIL * AS3                                 30.80
C       Mean period:
        MPER = PI2 * AM0 / AM1
        IF (ITEST.GE.80) WRITE (PRTEST, 72) ITPER, SPPARM(2), MPER,
     &          PKPER
  72    FORMAT (' SSHAPE iter=', I2, '  period values:', 3F7.2)
        IF (ABS(MPER-SPPARM(2)) .GT. 0.01*SPPARM(2)) THEN
C         modification suggested by Mauro Sclavo
          PKPER = (SPPARM(2) / MPER) * PKPER                              30.80
          GOTO 100
        ENDIF
      ENDIF
C
      IF (ITPER.GE.10) THEN
        CALL MSGERR(3, 'No convergence calculating the spectrum')         30.82
        CALL MSGERR(3, 'at the boundary using parametric bound. cond.')   30.82
      ENDIF
*
*       now introduce distribution over directions
*
      ADIR = PI * DEGCNV(SPPARM(3)) / 180.                                40.00
      IF (DSHAPL.EQ.1) THEN
        DSPR = PI * SPPARM(4) / 180.
        MS = MAX (DSPR**(-2) - 2., 1.)
      ELSE
        MS = SPPARM(4)
      ENDIF
      IF (MS.LT.12.) THEN
        CTOT = (2.**MS) * (GAMMA(0.5*MS+1.))**2 / (PI * GAMMA(MS+1.))
      ELSE
        CTOT =  SQRT (0.5*MS/PI) / (1. - 0.25/MS)
      ENDIF
      IF (ITEST.GE.100) THEN
        ESOM = 0.
        DO IS = 1, MSC
          ESOM = ESOM + FRINTF * SPCSIG(IS)**2 * ACLOC(MDC,IS)
        ENDDO
        WRITE (PRTEST, *) ' SSHAPE dir ', 4.*SQRT(ABS(ESOM)),
     &        SPPARM(1), CTOT, MS, GAMMA(0.5*MS+1.), GAMMA(MS+1.),
     &        CTOT                                                        40.02
      ENDIF
      DVERIF = .FALSE.
      CTOTT = 0.
      DO ID = 1, MDC
        ACOS = COS(SPCDIR(ID,1) - ADIR)
        IF (ACOS .GT. 0.) THEN
          CDIR = CTOT * MAX (ACOS**MS, 1.E-10)
          IF (.NOT.FULCIR) THEN
            IF (ACOS .GE. COS(DDIR)) DVERIF = .TRUE.
          ENDIF
        ELSE
          CDIR = 0.
        ENDIF
        IF (ITEST.GE.10) CTOTT = CTOTT + CDIR * DDIR
        IF (ITEST.GE.100) WRITE (PRTEST, 360) ID,SPCDIR(ID,1),CDIR
 360    FORMAT (' ID Spcdir Cdir: ',I3,3(1X,E10.4))
        DO IS = 1, MSC
          ACLOC(ID,IS) = CDIR * ACLOC(MDC,IS)
        ENDDO
      ENDDO
      IF (ITEST.GE.10) THEN
        IF (ABS(CTOTT-1.) .GT. 0.1) WRITE (PRINTF, 363) CTOTT
 363    FORMAT (' SSHAPE, integral of Cdir is not 1, but:', F6.3)
      ENDIF
      IF (.NOT.FULCIR .AND. .NOT.DVERIF)
     &   CALL MSGERR (1, 'incident direction is outside sector')
*
      RETURN
*
* End of subroutine SSHAPE
      END
********************************************************************
*                                                                  *
      SUBROUTINE SINTRP (W1, W2, FL1, FL2, FL, SPCDIR, SPCSIG)
*                                                                  *
********************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  Weimin Luo, Roeland Ris, Nico Booij            |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.73: Nico Booij
C     30.82: IJsbrand Haagsma
C     40.00: Nico Booij
C
C  1. Updates
C
C     30.01, Jan. 96: New subroutine for SWAN Ver. 30.01
C     30.73, Nov. 97: revised
C     40.00, Apr. 98: procedure to maintain peakedness introduced
C     30.82, Oct. 98: Update description of several variables
C     30.82, Oct. 98: Made arguments in ATAN2 double precision to prevent
C                     underflows
C
C  2. Purpose
C
C     interpolation of spectra
C
C  3. Method (updated...)
C
C     linear interpolation with peakedness maintained
C     interpolated average direction and frequency are determined
C     average direction and frequency of interpolated spectrum are determ.
C     shifts in frequency and direction are determined from spectrum 1 and
C     2 to the interpolated spectrum
C     bilinear interpolation in spectral space is used to calculate
C     contributions from spectrum 1 and 2.
C     in full circle cases interpolation crosses the boundary 0-360 degr.
C
C  4. Argument variables
C
C   o FL    : Interpolated spectrum.
C i   FL1   : Input spectrum 1.
C i   FL2   : Input spectrum 2.
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C i   W1    : Weighting coefficient for spectrum 1.
C i   W2    : Weighting coefficient for spectrum 2.
C
      REAL    FL1(MDC,MSC), FL2(MDC,MSC), FL(MDC, MSC)
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
      REAL    W1, W2
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ID       counter of directions
C     IS       counter of frequencies
C
      INTEGER  ID, IS
C
C     DOADD    indicates whether or not values have to be added
C
      LOGICAL  DOADD
C
C     ATOT1    integral over spectrum 1
C     ATOT2    integral over spectrum 2
C     AXTOT1   integral over x-component of spectrum 1
C     AXTOT2   integral over x-component of spectrum 2
C     AYTOT1   integral over y-component of spectrum 1
C     AYTOT2   integral over y-component of spectrum 2
C     ASTOT1   integral over Sigma * spectrum 1
C     ASTOT2   integral over Sigma * spectrum 2
C     ASIG1    average Sigma of spectrum 1
C     ASIG2    average Sigma of spectrum 2
C     DELD1    difference in direction between spectrum 1 and
C              the interpolated spectrum in number of directional steps
C     DELD2    same for spectrum 2
C     DELSG1   shift in frequency between spectrum 1 and interpolated
C              spectrum in number of frequency steps
C     DELSG2   same for spectrum 2
C
      REAL     ATOT1,  ATOT2,  AXTOT1, AXTOT2, AYTOT1, AYTOT2,
     &         ASTOT1, ASTOT2
      REAL     ASIG1,  ASIG2
      REAL     DELD1,  DELD2,  DELSG1, DELSG2
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C      SNEXTI, RBFILE
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C      -----------------------------------------------------------------
C      If W1 close to 1
C      Then copy FL from FL1
C      Else If W2 close to 1
C           Then copy FL from FL2
C           Else determine total energy in FL1 and FL2
C                If energy of FL1 = 0
C                Then make FL = W2 * FL2
C                Else If energy of FL2 = 0
C                     Then make FL = W1 * FL1
C                     Else determine average direction of FL1 and FL2
C                          make ADIR = W1 * ADIR1 + W2 * ADIR2
C                          determine average frequency of FL1 and FL2
C                          make ASIG = W1 * ASIG1 + W2 * ASIG2
C                          determine directional shift from FL1
C                          determine directional shift from FL2
C                          determine frequency shift from FL1
C                          determine frequency shift from FL2
C                          For all spectral components do
C                              compose FL from components of FL1 and FL2
C      -----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SINTRP')
C
C     interpolation of spectra
C     ------------------------
C
      IF (W1.GT.0.99) THEN
        DO 101 ID=1,MDC
          DO 102 IS=1,MSC
            FL(ID,IS) = FL1(ID,IS)
 102      CONTINUE
 101    CONTINUE
      ELSE IF (W1.LT.0.01) THEN
        DO 201 ID=1,MDC
          DO 202 IS=1,MSC
            FL(ID,IS) = FL2(ID,IS)
 202      CONTINUE
 201    CONTINUE
      ELSE
        ATOT1  = 0.
        ATOT2  = 0.
        AXTOT1 = 0.
        AXTOT2 = 0.
        AYTOT1 = 0.
        AYTOT2 = 0.
        ASTOT1 = 0.
        ASTOT2 = 0.
        DO 301 ID=1,MDC
          DO 302 IS=1,MSC
            ATOT1  = ATOT1  + FL1(ID,IS)
            AXTOT1 = AXTOT1 + FL1(ID,IS) * SPCDIR(ID,2)
            AYTOT1 = AYTOT1 + FL1(ID,IS) * SPCDIR(ID,3)
            ASTOT1 = ASTOT1 + FL1(ID,IS) * SPCSIG(IS)
            ATOT2  = ATOT2  + FL2(ID,IS)
            AXTOT2 = AXTOT2 + FL2(ID,IS) * SPCDIR(ID,2)
            AYTOT2 = AYTOT2 + FL2(ID,IS) * SPCDIR(ID,3)
            ASTOT2 = ASTOT2 + FL2(ID,IS) * SPCSIG(IS)
 302      CONTINUE
 301    CONTINUE
        IF (ATOT1.LT.1.E-9) THEN
          DO 401 ID=1,MDC
            DO 402 IS=1,MSC
              FL(ID,IS) = W2*FL2(ID,IS)
 402        CONTINUE
 401      CONTINUE
        ELSE IF (ATOT2.LT.1.E-9) THEN
          DO 501 ID=1,MDC
            DO 502 IS=1,MSC
              FL(ID,IS) = W1*FL1(ID,IS)
 502        CONTINUE
 501      CONTINUE
        ELSE
*         determine interpolation factors in Theta space
          AXTOT  = W1 * AXTOT1 + W2 * AXTOT2
          AYTOT  = W1 * AYTOT1 + W2 * AYTOT2
          IF (ITEST.GE.80) THEN
            WRITE (PRTEST, 509)  ATOT1, ATOT2,                            40.02
     &            AXTOT, AXTOT1, AXTOT2, AYTOT, AYTOT1, AYTOT2
 509        FORMAT (' SINTRP factors ', 8E11.4, /, 15X, 4F7.3)
          ENDIF
*         DELD1 is the difference in direction between spectrum 1 and
*         the interpolated spectrum in number of directional steps
          DELD1  = REAL(ATAN2(DBLE(AXTOT*AYTOT1 - AYTOT*AXTOT1),          30.82
     &                        DBLE(AXTOT*AXTOT1 + AYTOT*AYTOT1))) / DDIR  30.82
*         DELD2 is the difference between spectrum 2 and
*         the interpolated spectrum
          DELD2  = REAL(ATAN2(DBLE(AXTOT*AYTOT2 - AYTOT*AXTOT2),          30.82
     &                        DBLE(AXTOT*AXTOT2 + AYTOT*AYTOT2))) / DDIR  30.82
          IDD1A  = NINT(DELD1)
          RDD1B  = DELD1 - REAL(IDD1A)
          IF (RDD1B .LT. 0.) THEN
            IDD1A = IDD1A - 1
            RDD1B = RDD1B + 1.
          ENDIF
          IDD1B  = IDD1A + 1
          RDD1B  = W1 * RDD1B
          RDD1A  = W1 - RDD1B
          IDD2A  = NINT(DELD2)
          RDD2B  = DELD2 - REAL(IDD2A)
          IF (RDD2B .LT. 0.) THEN
            IDD2A = IDD2A - 1
            RDD2B = RDD2B + 1.
          ENDIF
          IDD2B  = IDD2A + 1
          RDD2B  = W2 * RDD2B
          RDD2A  = W2 - RDD2B
*
*         determine interpolation factors in Sigma space
          ASIG1  = ASTOT1 / ATOT1
          ASIG2  = ASTOT2 / ATOT2
          ATOT   = W1 * ATOT1  + W2 * ATOT2
          ASTOT  = W1 * ASTOT1 + W2 * ASTOT2
          ASIG   = ASTOT / ATOT
*
*         DELSG1 is shift in frequency between spectrum 1 and interpolated
*         spectrum in number of frequency steps
          DELSG1 = ALOG (ASIG1 / ASIG) / FRINTF
          IDS1A  = NINT(DELSG1)
          RDS1B  = DELSG1 - REAL(IDS1A)
          IF (RDS1B .LT. 0.) THEN
            IDS1A = IDS1A - 1
            RDS1B = RDS1B + 1.
          ENDIF
          IDS1B  = IDS1A + 1
          RDS1A  = 1. - RDS1B
*
*         DELSG2 is shift in frequency between spectrum 2 and interpolated
*         spectrum in number of frequency steps
          DELSG2 = ALOG (ASIG2 / ASIG) / FRINTF
          IDS2A  = NINT(DELSG2)
          RDS2B  = DELSG2 - REAL(IDS2A)
          IF (RDS2B .LT. 0.) THEN
            IDS2A = IDS2A - 1
            RDS2B = RDS2B + 1.
          ENDIF
          IDS2B  = IDS2A + 1
          RDS2A  = 1. - RDS2B
*         test output
          IF (ITEST.GE.80) THEN
            WRITE (PRTEST, 510) ATOT, ATOT1, ATOT2,
     &            AXTOT, AXTOT1, AXTOT2, AYTOT, AYTOT1, AYTOT2,
     &            DELD1, DELD2, DELSG1, DELSG2
 510        FORMAT (' SINTRP factors ', 9E11.4, /, 15X, 4F7.3)
            WRITE (PRTEST, 512) IDS1A, RDS1A, IDS1B, RDS1B,
     &            IDS2A, RDS2A, IDS2B, RDS2B,
     &            IDD1A, RDD1A, IDD1B, RDD1B,
     &            IDD2A, RDD2A, IDD2B, RDD2B
 512        FORMAT (' SINTRP ', 8(I2, F7.3))
          ENDIF
*
          DO 601 ID=1,MDC
            DO 602 IS=1,MSC
              FL(ID,IS) = 0.
 602        CONTINUE
 601      CONTINUE
          DO 611 ID=1,MDC
            DOADD = .TRUE.
            ID1A = ID + IDD1A
            IF (FULCIR) THEN
              IF (ID1A.LT.1)   ID1A = ID1A + MDC
              IF (ID1A.GT.MDC) ID1A = ID1A - MDC
            ELSE
              IF (ID1A.LT.1)   DOADD = .FALSE.
              IF (ID1A.GT.MDC) DOADD = .FALSE.
            ENDIF
            IF (DOADD) THEN
              DO 612 IS = MAX(1,1-IDS1A), MIN(MSC,MSC-IDS1A)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD1A * RDS1A * FL1(ID1A,IS+IDS1A)
 612          CONTINUE
              DO 613 IS = MAX(1,1-IDS1B), MIN(MSC,MSC-IDS1B)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD1A * RDS1B * FL1(ID1A,IS+IDS1B)
 613          CONTINUE
            ENDIF
 611      CONTINUE
          DO 621 ID=1,MDC
            DOADD = .TRUE.
            ID1B = ID + IDD1B
            IF (FULCIR) THEN
              IF (ID1B.LT.1)   ID1B = ID1B + MDC
              IF (ID1B.GT.MDC) ID1B = ID1B - MDC
            ELSE
              IF (ID1B.LT.1)   DOADD = .FALSE.
              IF (ID1B.GT.MDC) DOADD = .FALSE.
            ENDIF
            IF (DOADD) THEN
              DO 622 IS = MAX(1,1-IDS1A), MIN(MSC,MSC-IDS1A)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD1B * RDS1A * FL1(ID1B,IS+IDS1A)
 622          CONTINUE
              DO 623 IS = MAX(1,1-IDS1B), MIN(MSC,MSC-IDS1B)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD1B * RDS1B * FL1(ID1B,IS+IDS1B)
 623          CONTINUE
            ENDIF
 621      CONTINUE
          DO 631 ID=1,MDC
            DOADD = .TRUE.
            ID2A = ID + IDD2A
            IF (FULCIR) THEN
              IF (ID2A.LT.1)   ID2A = ID2A + MDC
              IF (ID2A.GT.MDC) ID2A = ID2A - MDC
            ELSE
              IF (ID2A.LT.1)   DOADD = .FALSE.
              IF (ID2A.GT.MDC) DOADD = .FALSE.
            ENDIF
            IF (DOADD) THEN
              DO 632 IS = MAX(1,1-IDS2A), MIN(MSC,MSC-IDS2A)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD2A * RDS2A * FL2(ID2A,IS+IDS2A)
 632          CONTINUE
              DO 633 IS = MAX(1,1-IDS2B), MIN(MSC,MSC-IDS2B)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD2A * RDS2B * FL2(ID2A,IS+IDS2B)
 633          CONTINUE
            ENDIF
 631      CONTINUE
          DO 641 ID=1,MDC
            DOADD = .TRUE.
            ID2B = ID + IDD2B
            IF (FULCIR) THEN
              IF (ID2B.LT.1)   ID2B = ID2B + MDC
              IF (ID2B.GT.MDC) ID2B = ID2B - MDC
            ELSE
              IF (ID2B.LT.1)   DOADD = .FALSE.
              IF (ID2B.GT.MDC) DOADD = .FALSE.
            ENDIF
            IF (DOADD) THEN
              DO 642 IS = MAX(1,1-IDS2A), MIN(MSC,MSC-IDS2A)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD2B * RDS2A * FL2(ID2B,IS+IDS2A)
 642          CONTINUE
              DO 643 IS = MAX(1,1-IDS2B), MIN(MSC,MSC-IDS2B)
                FL(ID,IS) = FL(ID,IS) +
     &                      RDD2B * RDS2B * FL2(ID2B,IS+IDS2B)
 643          CONTINUE
            ENDIF
 641      CONTINUE
        ENDIF
      ENDIF
*
*     Test output
      IF (ITEST.GE.80) THEN
        A1 = 0.
        A2 = 0.
        AA = 0.
        DO 801 ID=1,MDC
          DO 802 IS=1,MSC
            A1 = MAX(A1,FL1(ID,IS))
            A2 = MAX(A2,FL2(ID,IS))
            AA = MAX(AA,FL(ID,IS))
 802      CONTINUE
 801    CONTINUE
        WRITE (PRTEST, *) ' SINTRP, maxima ', A1, A2, AA
      ENDIF
*
      RETURN
*  end of subroutine of SINTRP
      END
C***********************************************************************
C                                                                      *
      REAL FUNCTION DEGCNV (DEGREE)
C                                                                      *
C***********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. UPDATE
C
C       SEP 1997: New for SWAN 32.01
C                 Cor van der Schelde - Delft Hydraulics
C       30.70, Feb. 98: test output suppressed (causes problem if subr
C                       is used during output
C
C  2. PURPOSE
C
C       Transform degrees from nautical to carthesian or vice versa.
C
C  3. METHOD
C
C       DEGCNV = 180 + dnorth - degree
C
C  4. PARAMETERLIST
C
C       DEGCNV      direction in carthesian or nautical degrees.
C       DEGREE      direction in nautical or carthesian degrees.
C
C  5. SUBROUTINES CALLING
C
C       ---
C
C  6. SUBROUTINES USED
C
C       NONE
C
C  7. ERROR MESSAGES
C
C       NONE
C
C  8. REMARKS
C
C           Nautical convention           Cartesian convention
C
C                    0                             90
C                    |                              |
C                    |                              |
C                    |                              |
C                    |                              |
C        270 --------+-------- 90       180 --------+-------- 0
C                    |                              |
C                    |                              |
C                    |                              |
C                    |                              |
C                   180                            270
C
C  9. STRUCTURE
C
C     ---------------------------------
C     IF (NAUTICAL DEGREES) THEN
C       CONVERT DEGREES
C     IF (DEGREES > 360 OR < 0) THEN
C       CORRECT DEGREES WITHIN 0 - 360
C     ---------------------------------
C
C 10. SOURCE TEXT
C
C***********************************************************************
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE(IENT,'DEGCNV')
C
      IF ( BNAUT ) THEN
        DEGCNV = 180. + DNORTH - DEGREE
      ELSE
        DEGCNV = DEGREE
      ENDIF
C
      IF (DEGCNV .GE. 360.) THEN
        DEGCNV = MOD (DEGCNV, 360.)
      ELSE IF (DEGCNV .LT. 0.) THEN
        DEGCNV = MOD (DEGCNV, 360.) + 360.
      ELSE
C       DEGCNV between 0 and 360; do nothing
      ENDIF
C
C
C     *** end of subroutine DEGCNV ***
C
      RETURN
      END
C
C***********************************************************************
C                                                                      *
      REAL FUNCTION ANGRAD (DEGREE)
C                                                                      *
C***********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. UPDATE
C
C       SEP 1997: New for SWAN 32.01
C                 Cor van der Schelde - Delft Hydraulics
C       30.70, Feb. 98: test output suppressed (causes problem if subr
C                       is used during output
C
C  2. PURPOSE
C
C       Transform degrees to radians
C
C  3. METHOD
C
C       ANGRAD = DEGREE * PI / 180
C
C  4. PARAMETERLIST
C
C       ANGRAD      radians
C       DEGREE      degrees
C
C  5. SUBROUTINES CALLING
C
C       ---
C
C  6. SUBROUTINES USED
C
C       NONE
C
C  7. ERROR MESSAGES
C
C       NONE
C
C  8. REMARKS
C
C       NONE
C
C  9. STRUCTURE
C
C     ---------------------------------
C     ANGLE[radian] = ANGLE[degrees} * PI / 180
C     ---------------------------------
C
C 10. SOURCE TEXT
C
C***********************************************************************
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE(IENT,'ANGRAD')
C
      ANGRAD = DEGREE * PI / 180.
C
C
C     *** end of subroutine ANGRAD ***
C
      RETURN
      END
C
C***********************************************************************
C                                                                      *
      REAL FUNCTION ANGDEG (RADIAN)
C                                                                      *
C***********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. UPDATE
C
C       SEP 1997: New for SWAN 32.01
C                 Cor van der Schelde - Delft Hydraulics
C       30.70, Feb. 98: test output suppressed (causes problem if subr
C                       is used during output
C
C  2. PURPOSE
C
C       Transform radians to degrees
C
C  3. METHOD
C
C       ANGDEG = RADIAN * 180 / PI
C
C  4. PARAMETERLIST
C
C       RADIAN      radians
C       ANGDEG      degrees
C
C  5. SUBROUTINES CALLING
C
C       ---
C
C  6. SUBROUTINES USED
C
C       NONE
C
C  7. ERROR MESSAGES
C
C       NONE
C
C  8. REMARKS
C
C       NONE
C
C  9. STRUCTURE
C
C     ---------------------------------
C     ANGLE[degrees] = ANGLE[radians} * 180 / PI
C     ---------------------------------
C
C 10. SOURCE TEXT
C
C***********************************************************************
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE(IENT,'ANGDEG')
C
      ANGDEG = RADIAN * 180. / PI
C
C
C     *** end of subroutine ANGDEG ***
C
      RETURN
      END
C
C***********************************************************************
C                                                                      *
      SUBROUTINE HSOBND (AC2   ,SPCSIG,HSIBC ,KGRPNT)                     40.00
C                                                                      *
C***********************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     32.01: Roeland Ris
C     30.70: Nico Booij
C     40.00: Nico Booij
C
C  1. Updates
C
C     32.01, Sep. 97: new for SWAN
C     30.72, Jan. 98: Changed number of elements for HSI to MCGRD
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: structure scheme corrected
C     40.00, Mar. 98: integration method changed (as in SNEXTI)
C                     structure corrected
C
C  2. Purpose
C
C     Compare computed significant wave height with the value of
C     the significant wave height as predescribed by the user. If
C     the values differ more than e.g. 10 % give an error message
C     and the gridpoints where the error has been located
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: input  Relative frequencies in computational domain in      30.72
C                    sigma-space                                          30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C       REALS:
C       ------
C       AC2        action density
C       HSI        significant wave height at boundary (using SWAN
C                  resolution (has thus not to be equal to the WAVEC
C                  significant wave height )
C       ETOT       total energy in a gridpoint
C       DS         increment in frequency space
C       DDIR       increment in directional space
C       HSC        computed wave height after SWAN computation
C       EFTAIL     contribution of tail to spectrum
C
C       INTEGERS:
C       ---------
C       KGRPNT     values of grid indices
C
C  5. SUBROUTINES CALLING
C
C       ---
C
C  6. SUBROUTINES USED
C
C       TRACE
C
C  7. ERROR MESSAGES
C
C       NONE
C
C  8. REMARKS
C
C       NONE
C
C  9. STRUCTURE
C
C     ------------------------------------------------------------------
C     for all computational grid points do                                30.70
C         if HSI is non-zero
C         then compute Hs from action density array
C              if relative difference is large than HSRERR
C              then write error message
C    -------------------------------------------------------------------
C
C 10. SOURCE TEXT
C
C***********************************************************************
C
      REAL      AC2(MDC,MSC,MCGRD) ,HSIBC(MCGRD)                          30.72
C
      REAL      ETOT  ,HSC                                                40.00
C
      INTEGER   ID    ,IS     ,IX     ,IY    ,INDX
C
      LOGICAL   HSRR
C
      INTEGER   KGRPNT(MXC,MYC)
C
      SAVE IENT, HSRR
      DATA IENT/0/, HSRR/.TRUE./
      CALL STRACE (IENT, 'HSOBND')
C
C     *** initializing ***
C
      HSRR = .TRUE.                                                       40.03
C
      DO IY = MYC, 1, -1
        DO IX = 1, MXC
          INDX = KGRPNT(IX,IY)
          IF ( HSIBC(INDX) .GT. 1.E-25 ) THEN
C           *** compute Hs for boundary point (without tail) ***
            ETOT  = 0.
            DO ID = 1, MDC
              DO IS = 1, MSC                                              40.00
                ETOT = ETOT + SPCSIG(IS)**2 * AC2(ID,IS,INDX)             40.00
              ENDDO
            ENDDO
            IF (ETOT .GT. 1.E-8) THEN
              HSC = 4. * SQRT(ETOT*FRINTF*DDIR)
            ELSE
              HSC = 0.
            ENDIF
            HSREL = (HSIBC(INDX) - HSC) / HSIBC(INDX)                     40.00
            IF (HSREL .GT. HSRERR) THEN
              IF ( HSRR ) THEN
                WRITE (PRINTF,*) ' ** WARNING : ',
     &             'Differences in wave height at the boundary'
                WRITE (PRINTF,802) HSRERR
 802            FORMAT (' Relative difference between input and ',
     &          'computation >= ', F6.2)
                WRITE (PRINTF,*) '                        Hs[m]',
     &                           '      Hs[m]      Hs[-]'
                WRITE (PRINTF,*) '    ix    iy  index   (input)',
     &                           ' (computed) (relative)'
                WRITE (PRINTF,*) ' ----------------------------',
     &                           '----------------------'
                HSRR = .FALSE.
              ENDIF
              WRITE (PRINTF,'(3(1x,I5),3(1x,F10.2))')
     &                       IX, IY, INDX, HSIBC(INDX), HSC, HSREL
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      WRITE(PRINTF,*)
C
      IF ( ITEST .GE. 150 ) THEN
        WRITE(PRINTF,*) 'Values of wave height at boundary (HSOBND)'
        WRITE(PRINTF,*) '------------------------------------------'
        DO IY = MYC, 1, -1
          WRITE (PRINTF,'(13F8.3)') ( HSIBC(KGRPNT(IX,IY)), IX=1 , MXC)
        ENDDO
      ENDIF
C
C     *** end of subroutine HSOBND ***
C
      RETURN
      END
C
*********************************************************************
*                                                                   *
      SUBROUTINE SETUPP (KGRPNT, MSTPDA, SETPDA, AC2, DEP2, DEPSAV,
     &                   SETUP2, WFORCX, WFORCY, XCGRID, YCGRID,
     &                   SPCSIG, SPCDIR, ITSW, ITER, UPPERI, LOPERI)      30.82
*                                                                   *
*********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     31.03: Annette Kieftenburg
C     31.04: Nico Booij
C     32.01: Roeland Ris
C     32.03: IJsbrand Haagsma
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     32.01, Sept 97: New Subroutine
C     32.03, Feb. 98: Comma added in FORMAT to prevent compilation error
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: transformation of radiation stress in 1D case
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Dec. 98: Argument list KSCIP1 adjusted
C     34.01, Feb. 99: Introducing STPNOW
C     30.82, July 99: Corrected argumentlist SETUPP and SETUP2D
C     30.82, July 99: Corrected argumentlist KSCIP1
C
C  2. Purpose
C
C     Computes the forces/(RHO*GRAV) responsible for the SETUP
C     and adds the SETUP to the depth
C
C  3. Method
C
C     The wave-induced setup is calculated for the one-dimensional
C     mode of SWAN using the following equation:
C
C        d Sxx                d eta
C        ----- +  ( d + eta ) ----- = 0
C         d x                  d x
C
C     This equation is numerically integrated in this subroutine
C     using an explicit numerical scheme in geograhical space.
C
C  4. Argument variables
C
C     AC2       input  (Nonstationary case) action density                31.03
C                                  as function of D,S,X,Y at time T+DT    31.03
C     DEPSAV    input    depth following from bottom and water level
C     DEP2      i/o      total depth, including SETUP
C                        on entry: includes previous estimate of SETUP
C                        on exit:  includes new estimate of SETUP
C     ITER      input    iteration counter
C     KGRPNT    input    indirect addresses for grid points
C     LOPERI                                                              30.82
C     MSTPDA    input    number of (aux.) data per grid point
C                            value is set at 10 in swancom1.ftn
C     SETPDA    i/o      (aux.) data for computation of Setup
C                        1: Depth, 2: (previous estimate of) Setup,
C                        3: x-comp of force, 4: y-comp of force,
C                        5: rad. stress comp. RSxx, 6: RSxy,
C                        7: RSyy
C                        SETPDA(*,*,5..MSTPDA) is used as work array
C     SETUP2    output   SETUP in grid points, using indirect addresses
C     SPCDIR    input    (*,1); spectral directions (radians)             30.82
C                        (*,2); cosine of spectral directions             30.82
C                        (*,3); sine of spectral directions               30.82
C                        (*,4); cosine^2 of spectral directions           30.82
C                        (*,5); cosine*sine of spectral directions        30.82
C                        (*,6); sine^2 of spectral directions             30.82
C     SPCSIG    input    Relative frequencies in computational domain     30.72
C                        in sigma-space                                   30.72
C     UPPERI                                                              30.82
C     WFORCX    output   Force x-component
C     WFORCY    output   Force y-component
C     XCGRID    input    Coordinates of computational grid in x-direction 30.72
C     YCGRID    input    Coordinates of computational grid in y-direction 30.72
C
      INTEGER ITER, ITSW, MSTPDA, KGRPNT(MXC,MYC)
C
      REAL    AC2(MDC,MSC,MCGRD)
      REAL    DEP2(MCGRD)
      REAL    DEPSAV(MCGRD)
      REAL    LOPERI(*)                                                   30.82
      REAL    SETPDA(MXC,MYC,MSTPDA)
      REAL    SETUP2(MCGRD)
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    UPPERI(*)                                                   30.82
      REAL    XCGRID(MXC,MYC), YCGRID(MXC,MYC)                            30.72
      REAL    WFORCX(MCGRD)  , WFORCY(MCGRD)                              31.04
C
C  5. Parameter variables
C
C  6. Local variables
C
C     CG          group velocity
C     CK          CGO*KWAVE
C     DDET        determinant
C     DEPMAX      maximum depth
C     DEPLOC      local depth
C     DIX         di/dx
C     DIY         di/dy
C     DJX         dj/dx
C     DJY         dj/dy
C     DP1         depth in point i in 1-D case
C     DP2         depth in point i+1 in 1-D case
C     DS2         square of mesh length in x- or y-direction
C     DXI         dx/di
C     DXJ         dx/dj
C     DYI         dy/di
C     DYJ         dy/dj
C     ELOC        local energy
C     ETA1        setup in  point i in 1-D case
C     ETA2        setup in  point i+1 in 1-D case
C     ID          counter in directional space
C     IDPMXX      identifier for x-coordinate of location with maximum depth
C     IDPMXY      identifier for y-coordinate of location with maximum depth
C     IENT        number of entries
C     INDX        address of grid point
C     INDXL       address of neighbouring grid point
C     IS          counter in frequency space
C     IX          counter in x-direction
C     IXLO        counter in x-direction for neighbouring grid point
C     IXUP        counter in x-direction for neighbouring grid point
C     IY          counter in y-direction
C     IYLO        counter in y-direction for neighbouring grid point
C     IYUP        counter in y-direction for neighbouring grid point
C     K           wavenumber
C     LINK        counter for neighbouring grid points
C     N           CGroup/CPhase
C     ND          derivative of N with respect to depth
C     NEIGHB      boolean variable indicating whether neighbouring point is wet
C     RRDI        1/number of steps in i-direction
C     RRDJ        1/number of steps in j-direction
C     RSXX        xx-component of the radiation stress
C     RSXXI       derivative of RSXX in i-direction
C     RSXXJ       derivative of RSXX in j-direction
C     RSXY        xy-component of the radiation stress
C     RSXYI       derivative of RSXY in i-direction
C     RSXYJ       derivative of RSXY in j-direction
C     RSYY        yy-component of the radiation stress
C     RSYYI       derivative of RSYY in i-direction
C     RSYYJ       derivative of RSYY in j-direction
C     S_UPCOR     total setupcorrection factor (user defined and S_UPDP)
C     S_UPDP      setup at location with maximum depth, before correction
C     SIG         dummy variable for frequency
C     SXX1        radiation stress in  point i in 1-D case
C     SXX2        radiation stress in  point i+1 in 1-D case
C
      INTEGER  IDPMXX, IDPMXY,                                            31.03
     &         ID, IENT, INDX, INDXL, IS, IX,
     &         IXLO, IXUP, IY, IYLO, IYUP, LINK
C
      REAL     CK, DDET, DEPLOC, DEPMAX, DIX, DIY, DJX, DJY,              31.04
     &         DP1, DP2, DS2, DXI, DXJ, DYI, DYJ, ELOC, ETA1, ETA2,
     &         RRDI, RRDJ, RSXX,  RSXXI, RSXXJ, RSXY,
     &         RSXYI, RSXYJ, RSYY, RSYYI, RSYYJ,
     &         S_UPCOR,                                                   30.82
     &         S_UPDP,                                                    31.03
     &         SXX1  ,SXX2
      REAL     CG(1), K(1), N(1), ND(1), SIG(1)                           30.82
C
      LOGICAL  NEIGHB
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     STRACE
C     KSCIP1      Calculates KWAVE, CGO
C     SETUP2D     Computation of SETUP, the change of waterlevel by waves.
C                 A Poisson equation is solved in general coordinates
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWCOMPU
C
C 10. Error messages
C
C     If setup is unequal to zero in dry point
C
C 11. Remarks
C
C 12. Structure
C
C     ---------------------------------------------------------
C     For all grid points do
C         If depth > DEPMIN
C         Then Integrate over spectrum to find RSxx, RSxy, RSyy
C     ---------------------------------------------------------
C     If one-dimensional mode of SWAN
C     Then Calculate Setup in all grid points
C     Else Call SETUP2 to compute setup in all grid points
C     ---------------------------------------------------------
C     S_updp is setup in (first) deepest point
C     Add user defined correction to setup                                30.82
C     For all grid points do
C         If dep2 > DEPMIN
C            copy Setup - S_upcor to SETUP2
C         If dep2 > DEPMIN
C            compute new value for DEP2
C     ---------------------------------------------------------
C     For all grid points do
C         If depth < DEPMIN
C         Then If water level + setup in neighbouring point above
C                   bottom level in this point
C              Then make depth equal to neighbouring water level
C                   + SETUP - bottom level in point itself
C     ---------------------------------------------------------
C
C 13. Source text
C
C***********************************************************************
 
      SAVE     IENT
      DATA     IENT /0/
      CALL STRACE (IENT, 'SETUPP')
C
      DEPMAX = 0.                                                         31.03
      IDPMXX = 0                                                          31.03
      IDPMXY = 0                                                          31.03
C                                                                         31.03
C     Initializing SETPDA, WFORCX and WFORCY arrays                       31.03
C                                                                         31.03
      DO IY = 1, MYC                                                      31.03
        DO IX = 1, MXC                                                    31.03
          INDX = KGRPNT(IX,IY)
          SETPDA(IX,IY,1) = -9.                                           31.03
          SETPDA(IX,IY,2) = 0.                                            31.03
          SETPDA(IX,IY,3) = 0.                                            31.03
          SETPDA(IX,IY,4) = 0.                                            31.03
          SETPDA(IX,IY,5) = 0.                                            31.03
          SETPDA(IX,IY,6) = 0.                                            31.03
          SETPDA(IX,IY,7) = 0.                                            31.03
          WFORCX(INDX) = 0.                                               31.03
          WFORCY(INDX) = 0.                                               31.03
         ENDDO                                                            31.03
      ENDDO                                                               31.03
C
      DO IY = 1, MYC
        DO IX = 1, MXC
          INDX = KGRPNT(IX,IY)
          IF (INDX.GT.1) THEN
            IF (DEP2(INDX).GT.DEPMIN) THEN
C
C             In dry points, even after inundation, setup = 0,            31.03
C             so there is no need to set SETPDA to the last estimate.     31.03
C
              SETPDA(IX,IY,1) = DEP2(INDX)                                31.03
              SETPDA(IX,IY,2) = SETUP2(INDX)                              31.03
C                                                                         31.03
C             Seek deepest point.                                         31.03
C                                                                         31.03
              IF (DEPSAV(INDX).GT.DEPMAX) THEN                            31.03
                DEPMAX = DEPSAV(INDX)                                     31.03
                IDPMXX = IX                                               31.03
                IDPMXY = IY                                               31.03
              ENDIF                                                       31.03
C
C             compute radiation stress components RSXX, RSXY and RSYY
C
              RSXX = 0.
              RSXY = 0.
              RSYY = 0.
              DEPLOC = SETPDA(IX,IY,1)                                    31.03
              DO IS = 1, MSC
                SIG(1) = SPCSIG(IS)                                       30.82
                CALL KSCIP1 (1,SIG,DEPLOC,K,CG,N,ND)                      30.82
                CK = CG(1) * K(1)                                         30.82
                DO ID = 1, MDC
                  ELOC = SIG(1) * AC2(ID,IS,INDX)                         30.82
C                                  -                                      31.03
C                                  |{cos(Theta)}^2         for i = 4      31.03
C                 SPCDIR(ID,i) is <| sin(Theta)cos(Theta)  for i = 5      31.03
C                                  |{sin(Theta)}^2         for i = 6      31.03
C                                  -                                      31.03
C                                                                         31.03
                  RSXX = RSXX + (CK*SPCDIR(ID,4)+CK - SIG(1)/2.) * ELOC   30.82
                  RSXY = RSXY + CK*SPCDIR(ID,5) * ELOC                    31.03
                  RSYY = RSYY + (CK*SPCDIR(ID,6)+CK - SIG(1)/2.) * ELOC   30.82
                ENDDO
              ENDDO
C
C             store radiation stress components in array SETPDA
C
C             DDIR   is width of directional band
C             FRINTF is frequency integration factor df/f
C
              IF (ONED) THEN                                              30.70
C               transform to computational direction
                SETPDA(IX,IY,5) = DDIR * FRINTF *                         31.04
     &                           ((COSPC*RSXX + SINPC*RSXY) * COSPC +     30.70
     &                            (COSPC*RSXY + SINPC*RSYY) * SINPC)      30.70
              ELSE                                                        30.70
                SETPDA(IX,IY,5) = RSXX * DDIR * FRINTF
                SETPDA(IX,IY,6) = RSXY * DDIR * FRINTF
                SETPDA(IX,IY,7) = RSYY * DDIR * FRINTF
              ENDIF                                                       30.70
            ENDIF                                                         31.03
          ENDIF
        ENDDO
      ENDDO
C
C
      IF ( ONED ) THEN
C
C       *** compute on the basis of the radiation stresses the setup ***
C       *** output is new setup = SETPDA(1,1,2)
C
        DO IY = 1, MYC
C         *** boundary condition ***
          SETPDA(1,IY,2) = 0.
          ETA2 = 0.
          DO IX = 1, MXC-1
            DP2  = SETPDA(IX+1,IY,1)
            IF ( DP2 .GT. 0. ) THEN
              DP1  = SETPDA(IX  ,IY,1)
              ETA1 = SETPDA(IX  ,IY,2)
              SXX1 = SETPDA(IX  ,IY,5)                                    31.04
              SXX2 = SETPDA(IX+1,IY,5)                                    31.04
              ETA2 = ETA1 + ( SXX1 - SXX2 ) / ( 0.5 * ( DP2 + DP1 ) )
              SETPDA(IX+1,IY,2) = ETA2
            ENDIF
          ENDDO
        ENDDO
C
      ELSE
C
C       compute forces by taking derivative of radiation stress
C
        DO IY = 1, MYC
          DO IX = 1, MXC
            INDX = KGRPNT(IX,IY)                                          31.03
            DEPLOC = SETPDA(IX,IY,1)
            IF (DEPLOC.LE.DEPMIN
     +          .OR. INDX.EQ.1) THEN
              GOTO 700
            ENDIF
            IF (IX.EQ.1) THEN
              IXLO = 1
              IXUP = 2
            ELSE IF (IX.EQ.MXC) THEN
              IXLO = MXC-1
              IXUP = MXC
            ELSE
              IXLO = IX-1
              IXUP = IX+1
            ENDIF
            IF (SETPDA(IXLO,IY,1).LE.DEPMIN) IXLO = IX                    31.03
            IF (SETPDA(IXUP,IY,1).LE.DEPMIN) IXUP = IX                    31.03
            IF (IXLO.EQ.IXUP) THEN
              RRDI = 1e-20
            ELSE
              RRDI = 1. / REAL(IXUP-IXLO)
            ENDIF
            IF (IY.EQ.1) THEN                                             31.03
              IYLO = 1
              IYUP = 2
            ELSE IF (IY.EQ.MYC) THEN
              IYLO = MYC-1
              IYUP = MYC
            ELSE
              IYLO = IY-1
              IYUP = IY+1
            ENDIF
            IF (SETPDA(IX,IYLO,1).LE.DEPMIN) IYLO = IY                    31.03
            IF (SETPDA(IX,IYUP,1).LE.DEPMIN) IYUP = IY                    31.03
            IF (IYLO.EQ.IYUP) THEN
              RRDJ = 1e-20
            ELSE
              RRDJ = 1. / REAL(IYUP-IYLO)
            ENDIF
C
C           determine (x,y) derivatives w.r.t. i and j
C
            DXI = RRDI * (XCGRID(IXUP,IY)-XCGRID(IXLO,IY))
            DYI = RRDI * (YCGRID(IXUP,IY)-YCGRID(IXLO,IY))
            DXJ = RRDJ * (XCGRID(IX,IYUP)-XCGRID(IX,IYLO))
            DYJ = RRDJ * (YCGRID(IX,IYUP)-YCGRID(IX,IYLO))
C
            RSXXI = RRDI * (SETPDA(IXUP,IY,5)-SETPDA(IXLO,IY,5))
            RSXXJ = RRDJ * (SETPDA(IX,IYUP,5)-SETPDA(IX,IYLO,5))          31.03
            RSXYI = RRDI * (SETPDA(IXUP,IY,6)-SETPDA(IXLO,IY,6))
            RSXYJ = RRDJ * (SETPDA(IX,IYUP,6)-SETPDA(IX,IYLO,6))          31.03
            RSYYI = RRDI * (SETPDA(IXUP,IY,7)-SETPDA(IXLO,IY,7))
            RSYYJ = RRDJ * (SETPDA(IX,IYUP,7)-SETPDA(IX,IYLO,7))          31.03
C
            IF (IXLO.EQ.IXUP.AND.IYLO.EQ.IYUP) THEN                       31.03
C             point surrounded by dry points                              31.03
              DIX  = 0.                                                   31.04
              DIY  = 0.                                                   31.04
              DJX  = 0.                                                   31.04
              DJY  = 0.                                                   31.04
            ELSE IF (IXLO.EQ.IXUP) THEN                                   31.03
C             no forces in i-direction                                    31.03
              DS2  = DXJ**2 + DYJ**2                                      31.04
              DIX  = 0.                                                   31.04
              DIY  = 0.                                                   31.04
              DJX  = DXJ/DS2                                              31.04
              DJY  = DYJ/DS2                                              31.04
            ELSE IF (IYLO.EQ.IYUP) THEN                                   31.03
C             no forces in j-direction                                    31.03
              DS2  = DXI**2 + DYI**2                                      31.04
              DIX  = DXI/DS2                                              31.04
              DIY  = DYI/DS2                                              31.04
              DJX  = 0.                                                   31.04
              DJY  = 0.                                                   31.04
            ELSE                                                          31.03
C             coefficients for transformation from
C             (i,j)-gradients to (x,y)-gradients
              DDET = DXI*DYJ - DXJ*DYI
              DIX  =  DYJ / DDET
              DIY  = -DXJ / DDET
              DJX  = -DYI / DDET
              DJY  =  DXI / DDET
            ENDIF                                                         31.04
C
C           force: spatial gradients of rad. stress
            SETPDA(IX,IY,3) =
     &             -(RSXXI*DIX + RSXXJ*DJX + RSXYI*DIY + RSXYJ*DJY)       31.03
            SETPDA(IX,IY,4) =
     &             -(RSXYI*DIX + RSXYJ*DJX + RSYYI*DIY + RSYYJ*DJY)       31.03
C
C           store force values in array for output                        31.04
            WFORCX(INDX) = SETPDA(IX,IY,3)
            WFORCY(INDX) = SETPDA(IX,IY,4)
C
 700      CONTINUE
          ENDDO                                                               31.03
        ENDDO
C
C       call Setup2d to compute SETUP
C
C       no nesting:  LSETUP = 1
C       nesting:     LSETUP = 2
C
         CALL SETUP2D (XCGRID, YCGRID, SETPDA(1,1,3),SETPDA(1,1,4),
     &                 SETPDA(1,1,1),SETPDA(1,1,2), UPPERI, LOPERI,       30.82
     &                 MSTPDA-4, SETPDA(1,1,5), ITSW, ITER)               31.04
         IF (STPNOW()) RETURN                                             34.01
      ENDIF
C
      IF (LSETUP.EQ.1) THEN                                               31.04
C       Set setup to 0 for deepest point. (This is allowed because the    31.03
C       solution of a Poisson equation + constant is again a solution of  31.03
C       the same Poisson equation)                                        31.03
        S_UPDP = SETPDA(IDPMXX, IDPMXY,2)                                 31.03
        S_UPCOR = S_UPDP - PSETUP(2)                                      30.82
        DO IY = 1, MYC                                                    31.03
          DO IX = 1, MXC                                                  31.03
             INDX = KGRPNT(IX,IY)                                         31.03
             IF (INDX.GT.1) THEN                                          31.03
               IF (DEP2(INDX).GT.DEPMIN) THEN                             31.03
                 SETUP2(INDX) = SETPDA(IX,IY,2) - S_UPCOR                 30.82
               ELSE
                 SETUP2(INDX) = SETPDA(IX,IY,2)                           31.03
                 IF (ABS(SETUP2(INDX)).GE.1e-7) THEN                      31.03
                   WRITE (PRINTF,*) 'Setup =', SETUP2(INDX),              31.03
     &              'in dry point (', IX,',', IY,') !'                    31.03
                 ENDIF                                                    31.03
               END IF                                                     31.03
             END IF                                                       31.03
          ENDDO                                                           31.03
        ENDDO                                                             31.03
      ENDIF                                                               31.04
C
C     include computed SETUP in depth
C
      DO IY = 1, MYC
        DO IX = 1, MXC
          INDX = KGRPNT(IX,IY)
          IF (INDX.GT.1) THEN
              DEP2(INDX) = DEPSAV(INDX) + SETUP2(INDX)
          ENDIF
        ENDDO
      ENDDO
C
C     check whether dry points should be inundated
C
      DO IY = 1, MYC
        DO IX = 1, MXC
          INDX = KGRPNT(IX,IY)
C         Note:    KGRPNT(.,.) = 1 means a permanently dry point!         31.03
          IF (INDX.GT.1) THEN
            IF (DEP2(INDX).LE.DEPMIN) THEN
              DO LINK = 1, 4
                NEIGHB = .TRUE.
                IF (LINK.EQ.1) THEN
                  IF (IX.EQ.1) THEN
                    NEIGHB = .FALSE.
                  ELSE
                    INDXL = KGRPNT(IX-1,IY)
                    IF (INDXL.LE.1) NEIGHB = .FALSE.
                  ENDIF
                ELSE IF (LINK.EQ.2) THEN
                  IF (IY.EQ.1) THEN
                    NEIGHB = .FALSE.
                  ELSE
                    INDXL = KGRPNT(IX,IY-1)
                    IF (INDXL.LE.1) NEIGHB = .FALSE.
                  ENDIF
                ELSE IF (LINK.EQ.3) THEN
                  IF (IX.EQ.MXC) THEN
                    NEIGHB = .FALSE.
                  ELSE
                    INDXL = KGRPNT(IX+1,IY)
                    IF (INDXL.LE.1) NEIGHB = .FALSE.
                  ENDIF
                ELSE IF (LINK.EQ.4) THEN
                  IF (IY.EQ.MYC) THEN
                    NEIGHB = .FALSE.
                  ELSE
                    INDXL = KGRPNT(IX,IY+1)
                    IF (INDXL.LE.1) NEIGHB = .FALSE.
                  ENDIF
                ENDIF
                IF (NEIGHB) THEN                                          31.03
                  IF (DEPSAV(INDX) + SETUP2(INDXL) .GT. DEPMIN) THEN      31.03
                    SETUP2(INDX) = SETUP2(INDXL)                          31.03
                    DEP2(INDX) = DEPSAV(INDX) + SETUP2(INDXL)             31.03
                  ENDIF                                                   31.03
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C
      RETURN
C     end of subroutine SETUPP
      END
C
C************************************************************************
C                                                                       *
      SUBROUTINE SETUP2D ( XCGRID, YCGRID, WFRCX, WFRCY, DEPTH,           31.03
     +                     SETUP, UPPERI, LOPERI,                         30.82
     +                     NWKARR, WKARR, ITSW, ITER)                     31.03
C                                                                       *
C************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C  0. Authors
C
C     31.03  Annette Kieftenburg
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     34.01, Feb. 99: Introducing STPNOW
C     30.82, July 99: Corrected argumentlist SETUP2D and SWSOLV
C
C  2. Purpose
C
C     Computation of SETUP, the change of waterlevel by waves.
C     A Poisson equation is solved in general coordinates
C
C  3. Method
C
C  4. Argument variables
C
C     DEPTH     input   Depth
C     ITER      input   Iteration number
C     LOPERI                                                              30.82
C     NWKARR    input   Dimension for work array
C     SETUP     output  Unknown set-up; to be computed indirect addressed
C     UPPERI                                                              30.82
C     WFRCX     input   force x-component
C     WFRCY     input   force y-component
C     WKARR             work array
C     XCGRID    input   x-coordinates
C     YCGRID    input   y-coordinates
C
      INTEGER  ITER, ITSW, NWKARR                                         31.03
      REAL DEPTH(1:MXC,1:MYC),                                            31.03
     +     LOPERI(*),                                                     30.82
     +     SETUP(1:MXC,1:MYC),                                            31.03
     +     UPPERI(*),                                                     30.82
     +     WFRCX(1:MXC,1:MYC),                                            31.03
     +     WFRCY(1:MXC,1:MYC),                                            31.03
     +     WKARR(1:MXC*MYC*NWKARR),
     +     XCGRID(1:MXC,1:MYC),                                           31.03
     +     YCGRID(1:MXC,1:MYC)                                            31.03
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ALPHAD    Direction index of integration.
C     I         General loop variable
C     IENT      Number of entries
C     IPCTC     Starting address of array CTC    in work array WKARR
C     IPCVA     Starting address of array CVA    in work array WKARR
C     IPCVC     Starting address of array CVC    in work array WKARR
C     IPDTSUM   Starting address of array DTSUM  in work array WKARR
C     IPJCTA    Starting address of array JCTA   in work array WKARR
C     IPMATRIX  Starting address of array MATRIX in work array WKARR
C     IPRHSIDE  Starting address of array RHSIDE in work array WKARR
C     NPOINT    Number of points MXC*MYC
C
      INTEGER ALPHAD, I, IENT, IPCTC, IPCVA, IPCVC,  IPDTSUM, IPJCTA,
     +        IPMATRIX, IPRHSIDE, NPOINT
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     SWCOVA2D  Computes covariant base vectors in integration points
C               two-dimensional case
C     SWJCTA2D  Computes the Jacobian of the transformation, sqrt(g),
C               * contra variant base vectors in
C               integration point two-dimensional case
C     SWTRAD2D  Computes contribution of diffusion term in R2 for
C               a transport equation per integration point
C               Compute righthandside
C     SWDISDT2  Distributes diffusion term for tranport equation in R2
C     SWESSBC   Puts essential boundary conditions in matrix
C     SWSOLV    Solves system of equations
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SETUPP    Computes the forces/(RHO*GRAV) responsible for the SETUP  31.03
C               and adds the SETUP to the depth                           31.03
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C ======================================================================
      SAVE     IENT
      DATA     IENT /0/
      CALL STRACE (IENT, 'SETUP2D')
C
      NPOINT   = MXC*MYC
      IPMATRIX = 1
      IPRHSIDE = IPMATRIX + NPOINT*9
      IPCVA    = IPRHSIDE + NPOINT
      IPJCTA   = IPCVA    + NPOINT*8
      IPCVC    = IPJCTA   + NPOINT*4
      IPCTC    = IPCVC    + NPOINT*4
      IPDTSUM  = IPCTC    + NPOINT*4
C
C     --- covariant base vectors
C
      CALL SWCOVA2D( MXC, MYC, XCGRID, YCGRID, WKARR(IPCVA) )
C
C     --- jacobian times contravariant base vectors
C
      CALL SWJCTA2D( MXC, MYC, WKARR(IPCVA), WKARR(IPJCTA)  )
C
C     --- initialize  matrix and righthandside
 
      DO I = 1, 9*NPOINT
          WKARR(IPMATRIX-1+I) = 0E0
      END DO
      DO I = 1, NPOINT
          WKARR(IPRHSIDE-1+I) = 0E0
      END DO
C
C     --- initialize  matrix and righthandside
 
      DO I = 1, 9*NPOINT
          WKARR(IPMATRIX-1+I) = 0E0
      END DO
      DO I = 1, NPOINT
          WKARR(IPRHSIDE-1+I) = 0E0
      END DO
C
C     --- build matrix and righthandside
C
      DO ALPHAD = 1,2
C
         CALL SWTRAD2D( MXC, MYC, WFRCX, WFRCY,                           31.04
     +                  DEPMIN, ALPHAD, DEPTH,                            31.04
     +                  WKARR(IPCVA), WKARR(IPJCTA),WKARR(IPCVC),
     +                  WKARR(IPCTC), WKARR(IPDTSUM),
     +                  WKARR(IPRHSIDE) )
C
         CALL SWDISDT2( MXC, MYC, DEPTH, DEPMIN, ALPHAD,                  31.04
     +                  WKARR(IPMATRIX), WKARR(IPDTSUM) )
C
      END DO
C
C     --- essential boundary conditions
C
      IF ( LSETUP .EQ. 2) THEN
C
         CALL SWESSBC(MXC, MYC, WKARR(IPMATRIX), WKARR(IPRHSIDE),
     +                SETUP )                                             31.04
C
      END IF
C
C     --- solve system of equations  {WKARR(IPCVA) is used as work array}
C
      CALL SWSOLV ( WKARR(IPMATRIX), WKARR(IPRHSIDE), SETUP,              31.04
     +              NPOINT, WKARR(IPCVA),                                 31.04
     +              NWKARR-11, ITSW, ITER,
     +              UPPERI, LOPERI)                                       30.82
      IF (STPNOW()) RETURN                                                34.01
      RETURN                                                              31.04
      END
C
******************************************************************
*                                                                *
      subroutine chgbas (X1, X2, PERIOD, Y1, Y2, N1, N2,
     &                   ITEST, PRTEST)
*                                                                *
******************************************************************
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  G. van Vledder, N. Booij                       |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. Update history
*
*       ver 20.48: also accomodates periodic variables such as directions
*
*  1. Purpose
*
*       change x-basis of a discretized y-function
*
*  2. Method
*
*     A piecewise constant representation of the functions is assumed
*
*     first boundaries of a cell in X1 are determined
*     then it is determined whether there are overlaps with cells
*     in X2. if so Y1*common length is added to Y2
*     Finally Y2 values are divided by cell lengths
*
*  3. Parameter list
*
*     Name    I/O  Type  Description
*
*     X1       i    ra   x-coordinates of input grid
*     X2       i    ra   x-coordinates of output grid
*     PERIOD   i    r    period, i.e. x-axis is periodic if period>0
*                        e.g. spectral directions
*     Y1       i    ra   function values of input grid
*     Y2       o    ra   function values of output grid
*     N1       i    i    number of x-values of input grid
*     N2       i    i    number of x-values of output grid
*
*  4. Subroutines used
*
*     ---
*
*  5. Error messages
*
*  6. Remarks
*
*       Cell boundaries in X1 are: X1A and X1B
*       X2 is assumed to be monotonically increasing; this is checked
*       X1 is assumed to be monotonous but not necessarily increasing
*
*  7. Structure
*
*       ------------------------------------------------------------------
*       Make all values of Y2 = 0
*       For each cell in X1 do
*           determine boundaries of cell in X1
*           --------------------------------------------------------------
*           For each cell in X2 do
*               determine overlap with cell in X1; limits: RLOW and RUPP
*               add to Y2: Y1 * length of overlapping interval
*       ------------------------------------------------------------------
*       For each cell in X2 do
*           divide Y2 value by cell length
*       ------------------------------------------------------------------
*
*  8. Source text
*
      INTEGER  I1, I2, N1, N2, ITEST, PRTEST
      REAL     X1(N1), Y1(N1), X2(N2), Y2(N2), PERIOD
      REAL     X1A, X1B, X2A, X2B, RLOW, RUPP
      LOGICAL  TWICE
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'CHGBAS')
*
*     initialize output data
*
      DO I2 = 1, N2
        Y2(I2) = 0.
      ENDDO
      DO I2 = 2, N2
        IF (X2(I2).LE.X2(I2-1))
     &    CALL MSGERR (2, 'subr. CHGBAS: values of X2 not increasing')
      ENDDO
*     boundaries of the range in X2
      X2LO  = 1.5 * X2(1)  - 0.5 * X2(2)
      X2HI  = 1.5 * X2(N2) - 0.5 * X2(N2-1)
      TWICE = .FALSE.
*
*     loop over cells in X1
*
      DO 300 I1 = 1, N1
        IF (ABS(Y1(I1)) .LT. 1.E-20) GOTO 300
*
*       determine cell boundaries in X1
*
        IF (I1.EQ.1) THEN
          X1A = 1.5 * X1(1) - 0.5 * X1(2)
        ELSE
          X1A = 0.5 * (X1(I1) + X1(I1-1))
        ENDIF
 
        IF (I1.EQ.N1) THEN
          X1B = 1.5 * X1(N1) - 0.5 * X1(N1-1)
        ELSE
          X1B = 0.5 * (X1(I1) + X1(I1+1))
        ENDIF
*
*       swap X1A and X1B if X1A > X1B
*
        IF (X1A.GT.X1B) THEN
          RR  = X1A
          X1A = X1B
          X1B = RR
        ENDIF
 
        IF (PERIOD.LE.0.) THEN
          IF (X1A.GT.X2HI) GOTO 300
          IF (X1B.LT.X2LO) GOTO 300
        ELSE
*         X is periodic; move interval in X1 if necessary
          TWICE = .FALSE.
          IADD = 0
  60      IF (X1A.GT.X2HI) THEN
            X1A = X1A - PERIOD
            X1B = X1B - PERIOD
            IADD = IADD + 1
            IF (IADD.GT.99)
     &         CALL MSGERR (2, 'endless loop in CHGBAS')
            GOTO 60
          ENDIF
  70      IF (X1B.LT.X2LO) THEN
            X1A = X1A + PERIOD
            X1B = X1B + PERIOD
            IADD = IADD + 1
            IF (IADD.GT.99)
     &           CALL MSGERR (2, 'endless loop in CHGBAS')
            GOTO 70
          ENDIF
          IF (X1A.GT.X2HI) GOTO 300
          IF (X1A.LT.X2LO .AND. X1A+PERIOD.LT.X2HI) TWICE = .TRUE.
        ENDIF
*
*       loop over cells in X2
*
 100    DO 200 I2 = 1, N2
 
          IF (I2.EQ.1) THEN
            X2A = X2LO
          ELSE
            X2A = 0.5 * (X2(I2) + X2(I2-1))
          ENDIF
 
          IF (I2.EQ.N2) THEN
            X2B = X2HI
          ELSE
            X2B = 0.5 * (X2(I2) + X2(I2+1))
          ENDIF
*
*         (RLOW,RUPP) is overlapping interval of (X1A,X1B) and (X2A,X2B)
*
          IF (X1A.LT.X2B) THEN
            RLOW = MAX (X1A, X2A)
          ELSE
            GOTO 200
          ENDIF
 
          IF (X1B.GT.X2A) THEN
            RUPP = MIN (X1B, X2B)
          ELSE
            GOTO 200
          ENDIF
 
          IF (RUPP.LT.RLOW) THEN
            CALL MSGERR (3, 'interpolation error')
            WRITE (PRTEST, 140) I1, X1A, X1B, I2, X2A, X2B
 140        FORMAT (' I, XA, XB ', 2(I3, 2(1X,E12.4)))
          ELSE
            Y2(I2) = Y2(I2) + Y1(I1) * (RUPP-RLOW)
          ENDIF
 200    CONTINUE
*
*       Cell in X1 covers both ends of sector boundary
        IF (TWICE) THEN
          X1A = X1A + PERIOD
          X1B = X1B + PERIOD
          TWICE = .FALSE.
          GOTO 100
        ENDIF
 300  CONTINUE
*
      DO I2 = 1, N2
        IF (I2.EQ.1) THEN
          CELLEN = X2(2) - X2(1)
        ELSE IF (I2.EQ.N2) THEN
          CELLEN = X2(N2) - X2(N2-1)
        ELSE
          CELLEN = 0.5 * (X2(I2+1) - X2(I2-1))
        ENDIF
*       divide Y2 by cell length
        Y2(I2) = Y2(I2) / CELLEN
      ENDDO
      IF (ITEST.GE.160) THEN
        WRITE (PRTEST, 84) N1, N2
  84    FORMAT (' test CHGBAS ', 2I5)
        WRITE (PRTEST, 85) (X1(II), II = 1, N1)
        WRITE (PRTEST, 85) (Y1(II), II = 1, N1)
        WRITE (PRTEST, 85) (X2(II), II = 1, N2)
        WRITE (PRTEST, 85) (Y2(II), II = 1, N2)
  85    FORMAT (10 (1X,E10.3))
      ENDIF
*
      RETURN
      END
*
*********************************************************************
*                                                                   *
      REAL FUNCTION GAMMA(XX)
*                                                                   *
*********************************************************************
*
*   Updates
*     ver 30.70, Oct 1997 by N.Booij: new subroutine
*
*   Purpose
*     Compute the transcendental function Gamma
*
*   Subroutines used
*     GAMMLN  (Numerical Recipes)
*
      REAL XX, YY, ABIG                                                   40.00
      SAVE IENT, ABIG
      DATA IENT /0/, ABIG /30./
      CALL STRACE (IENT, 'GAMMA')
      YY = GAMMLN(XX)
      IF (YY.GT.ABIG) YY = ABIG
      IF (YY.LT.-ABIG) YY = -ABIG
      GAMMA = EXP(YY)
      RETURN
      END
*********************************************************************
*                                                                   *
      FUNCTION GAMMLN(XX)
*                                                                   *
*********************************************************************
*
*   Method:
*     function is copied from: Press et al., "Numerical Recipes"
*
      DOUBLE PRECISION  COF(6),STP,HALF,ONE,FPF,X,TMP,SER
      DATA COF,STP/76.18009173D0,-86.50532033D0,24.01409822D0,
     *    -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/
      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/
      X=XX-ONE
      TMP=X+FPF
      TMP=(X+HALF)*LOG(TMP)-TMP
      SER=ONE
      DO 11 J=1,6
        X=X+ONE
        SER=SER+COF(J)/X
11    CONTINUE
      GAMMLN=TMP+LOG(STP*SER)
      RETURN
      END
************************************************************************
*                                                                      *
      SUBROUTINE WRSPEC (NREF, ACLOC)
*                                                                      *
************************************************************************
 
      USE OUTP_DATA                                                       40.13
 
      IMPLICIT NONE                                                       40.13
 
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.00, 40.13: Nico Booij
C
C  1. UPDATE
C
C     new subroutine, update 40.00
C     40.03, Mar. 00: precision increased; 2 decimals more in output table
!     40.13, July 01: variable format using module OUTP_DATA
C
C  2. PURPOSE
C
C     Writing of action density spectrum in Swan standard format
C
C  3. METHOD
C
C
C  4. Argument variables
C
C       NREF    int    input    unit ref. number of output file
C       ACLOC   real   local    2-D spectrum or source term at one
C                               output location
 
      INTEGER, INTENT(IN) :: NREF
      REAL, INTENT(IN)    :: ACLOC(1:MDC,1:MSC)
 
C  5. Parameter variables
C
C  6. Local variables
C
C       ID      counter of spectral directions
C       IS      counter of spectral frequencies
C
      INTEGER :: ID, IS
C
C       EFAC    multiplication factor written to file
C
      REAL    :: EFAC
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SWOUTP (SWAN/OUTP)
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       determine maximum value of ACLOC
C       if maximum = 0
C       then write 'ZERO' to file
C       else write 'FACTOR'
C            determine multiplication factor, write this to file
C            write values of ACLOC/factor to file
C       ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER, SAVE :: IENT = 0                                           40.13
      IF (LTRACE) CALL STRACE (IENT, 'WRSPEC')
C
C     first determine maximum energy density
      EFAC = 0.
      DO ID = 1, MDC
        DO IS = 1, MSC
          IF (ACLOC(ID,IS).GE.0.) THEN
            EFAC = MAX (EFAC, ACLOC(ID,IS))
          ELSE
            EFAC = MAX (EFAC, 10.*ABS(ACLOC(ID,IS)))
          ENDIF
        ENDDO
      ENDDO
      IF (EFAC .LE. 1.E-10) THEN
        WRITE (NREF, 12) 'ZERO'                                           40.00
  12    FORMAT (A4)
      ELSE
        EFAC = 1.01 * EFAC * 10.**(-DEC_SPEC)                             40.13
*       factor PI/180 introduced to account for change from rad to degr
*       factor 2*PI to account for transition from rad/s to Hz
        WRITE (NREF, 95) EFAC * 2. * PI**2 / 180.
  95    FORMAT ('FACTOR', /, E18.8)                                       40.13
        DO IS = 1, MSC
*         write spectral energy densities to file
          WRITE (NREF, FIX_SPEC) (NINT(ACLOC(ID,IS)/EFAC), ID=1,MDC)      40.13
        ENDDO
      ENDIF
      RETURN
*     end of subroutine WRSPEC
      END
