!NRL: $Id: swcomm1.inc,v 1.1.1.1 2003/03/28 15:34:04 dykes Stab $
!NRL: $Name:  $
C                 SWAN COMMON BLOCKS, file 1 of 4
C
C     Contents of this file
C
C     COMMON / SWNAME / *** names and other character data
C     COMMON / SWUITV / *** information for output
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72 IJsbrand G. Haagsma
C     32.01 Roeland Ris & Cor van der Schelde
C     40.00 Nico Booij
C
C  1. Updates
C
C     30.72, Sept 97: Created from the old swancomm.ftn file
C     32.01, Jan. 98: NMOVAR increased by 1 for wave-setup
C     40.00, Apr. 98: variable OVKEYW added for all quantities
C                     NMOVAR increased
C                     quantities TSEC and TIME added
C                     array OUTPAR added
C                     char. string CHTIME added
C     40.03, May  00: output variables URSELL, ASTD added
C
C  2. Purpose
C
C     Common variables used by the subroutines in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C        [???] default value
C
C NMOVAR [ 46] maximum number of output variables                         40.03
C MOUTPA [  5] number of output parameters
C
      INTEGER             NMOVAR, MOUTPA                                  40.00
      PARAMETER           (NMOVAR = 46, MOUTPA=5)                         40.03
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWNAME /  *** names and other character data ***
C
C     Common variables
C
C        [???????] default value, [CALCULAT] is calculated
C
C CHTIME [ '    '] character string representation of date-time of computation 40.00
C FNEST [CALCULAT] BCF (=BLANK), name of nest file
C OVKEYW(NMOVAR)   keyword identifying output quantity in a SWAN command  40.00
C  ( 1) [    'XP']
C  ( 2) [    'YP']
C  ( 3) [  'DIST']
C  ( 4) [   'DEP']
C  ( 5) [   'VEL']
C  ( 6) [  'UBOT']
C  ( 7) [  'DISS']
C  ( 8) [    'QB']
C  ( 9) [   'LEA']
C  (10) [    'HS']
C  (11) [  'TM01']
C  (12) [   'RTP']
C  (13) [   'DIR']
C  (14) [   'PDI']
C  (15) [   'TDI']
C  (16) [  'DSPR']
C  (17) [  'WLEN']
C  (18) [  'STEE']
C  (19) [   'TRA']
C  (20) [   'FOR']
C  (21) ['      ']
C  (22) ['      ']
C  (23) ['      ']
C  (24) [    'XC']
C  (25) [    'YC']
C  (26) [  'WIND']
C  (27) [   'FRC']
C  (28) [ 'RTM01']
C  (29) ['      ']
C  (30) [   'DHS']
C  (31) ['DRTM01']
C  (32) [  'TM02']
C  (33) [  'FSPR']
C  (34) [  'URMS']
C  (35) [  'UFRI']
C  (36) [  'ZLEN']
C  (37) [  'TAUW']
C  (38) [ 'CDRAG']
C  (39) [ 'SETUP']                                                        40.00
C  (40) [  'TIME']                                                        40.00
C  (41) [  'TSEC']                                                        40.00
C OVSNAM(NMOVAR)   short name of output quantity
C  ( 1) [    'Xp']
C  ( 2) [    'Yp']
C  ( 3) [  'Dist']
C  ( 4) [ 'Depth']
C  ( 5) [   'Vel']
C  ( 6) [  'Ubot']
C  ( 7) ['Dissip']
C  ( 8) [    'Qb']
C  ( 9) [  'Leak']
C  (10) [    'Hs']
C  (11) [  'Tm01']
C  (12) [ 'Tpeak']
C  (13) [   'Dir']
C  (14) [ 'PkDir']
C  (15) [  'TDir']
C  (16) [  'Dspr']
C  (17) [  'Wlen']
C  (18) ['Steepn']
C  (19) ['Transp']
C  (20) ['WForce']
C  (21) ['AcDens']
C  (22) ['EnDens']
C  (23) [   'Aux']
C  (24) [    'Xc']
C  (25) [    'Yc']
C  (26) [ 'Windv']
C  (27) ['FrCoef']
C  (28) [ 'RTm01']
C  (29) ['EnDens']
C  (30) [   'dHs']
C  (31) [   'dTm']
C  (32) [  'Tm02']
C  (33) [  'FSpr']
C  (34) [  'Urms']
C  (35) [ 'Ufric']
C  (36) [  'Zlen']
C  (37) [  'TauW']
C  (38) [ 'Cdrag']
C  (39) [ 'Setup']
C  (40) [  'Time']                                                        40.00
C  (41) [  'Tsec']                                                        40.00
C OVLNAM(NMOVAR)   long name of output quantity
C  ( 1) [                        'X user coordinate']
C  ( 2) [                        'Y user coordinate']
C  ( 3) [              'distance along output curve']
C  ( 4) [                                    'Depth']
C  ( 5) [                         'Current velocity']
C  ( 6) [           'Orbital velocity at the bottom']
C  ( 7) [                       'Energy dissipation']
C  ( 8) [                  'Fraction breaking waves']
C  ( 9) [     'Energy leak over spectral boundaries']
C  (10) [                  'Significant wave height']
C  (11) [             'Average absolute wave period']
C  (12) [                              'Peak period']
C  (13) [                   'Average wave direction']
C  (14) [    'direction of the peak of the spectrum']
C  (15) [        'direction of the energy transport']
C  (16) [                    'directional spreading']
C  (17) [                      'Average wave length']
C  (18) [                           'Wave steepness']
C  (19) [                    'Wave energy transport']
C  (20) [       'Wave driven force per unit surface']
C  (21) [                  'spectral action density']
C  (22) [                  'spectral energy density']
C  (23) [                       'auxiliary variable']
C  (24) [          'X computational grid coordinate']
C  (25) [          'Y computational grid coordinate']
C  (26) [    'Wind velocity at 10 m above sea level']
C  (27) [              'Bottom friction coefficient']
C  (28) [             'Average relative wave period']
C  (29) [ 'energy density integrated over direction']
C  (30) [      'difference in Hs between iterations']
C  (31) [      'difference in Tm between iterations']
C  (32) [                     'Zero-crossing period']
C  (33) [         'Frequency spectral width (Kappa)']
C  (34) [    'RMS of orbital velocity at the bottom']
C  (35) [                        'Friction velocity']
C  (40) [                                'Date-time']                     40.00
C  (41) [      'Time in seconds from reference time']                     40.00
C  (36) ['Zero velocity thickness of boundary layer']
C  (37) [                                     '    ']
C  (38) [                         'Drag coefficient']
C  (39) [                       'Setup due to waves']
C OVUNIT(NMOVAR)   unit of of output quantity
C  ( 1) [CALCULAT] =UL
C  ( 2) [CALCULAT] =UL
C  ( 3) [CALCULAT] =UL
C  ( 4) [CALCULAT] =UH
C  ( 5) [CALCULAT] =UV
C  ( 6) [CALCULAT] =UV
C  ( 7) [  'm2/s'] change to UDL ???, changed to 'W/m2', if INRHOG=1
C  ( 8) [     ' ']
C  ( 9) [  'm2/s'] change to UDL ???, changed to 'W/m2', if INRHOG=1
C  (10) [CALCULAT] =UH
C  (11) [CALCULAT] =UT
C  (12) [CALCULAT] =UT
C  (13) [CALCULAT] =UDI
C  (14) [CALCULAT] =UDI
C  (15) [CALCULAT] =UDI
C  (16) [CALCULAT] =UDI
C  (17) [CALCULAT] =UL
C  (18) [     ' ']
C  (19) [   'm2s'] changed to 'W/m' (=UP), if INRHOG=1
C  (20) [CALCULAT] =UF
C  (21) [   'm2s'] changed to 'Js/m2', if INRHOG=1
C  (22) [    'm2'] changed to 'J/m2', if INRHOG=1
C  (23) [     ' ']
C  (24) [     ' ']
C  (25) [     ' ']
C  (26) [CALCULAT] =UV
C  (27) [     ' ']
C  (28) [CALCULAT] =UT
C  (29) [    'm2'] changed to 'J/m2', if INRHOG=1
C  (30) [CALCULAT] =UH
C  (31) [CALCULAT] =UT
C  (32) [CALCULAT] =UT
C  (33) [     ' ']
C  (34) [CALCULAT] =UV
C  (35) [CALCULAT] =UV
C  (36) [CALCULAT] =UL
C  (37) [     ' ']
C  (38) [     ' ']
C  (39) [     'm']
C  (40) [     ' ']                                                        40.00
C  (41) [     's']                                                        40.00
C SNAME [        ] name of output point set
C UAP   [  'W/m2'] unit of dissipation
C UD    [        ] not used
C UDI   [  'degr'] unit of direction
C UDL   [  'm2/s'] unit of dissipation
C UET   [  'm3/s'] unit of energy transport, and wave force
C UF    [  'N/m2'] unit of pressure or shear stress (force per area)
C UH    [     'm'] unit of vertical length
C UL    [     'm'] unit of horizontal length
C UP    [   'W/m'] unit of energy flux density
C UST   [ 'm2/s2'] not used
C UT    [   'sec'] unit of time (change to s ???)
C UV    [   'm/s'] unit of velocity
C
      CHARACTER*20        CHTIME                                          40.00
      CHARACTER*36        FBCL,        FBCR,        FNEST
      CHARACTER*8         OVKEYW(NMOVAR)                                  40.00
      CHARACTER*40        OVLNAM(NMOVAR)
      CHARACTER*6         OVSNAM(NMOVAR)
      CHARACTER*16        OVUNIT(NMOVAR)
      CHARACTER*8         SNAME
      CHARACTER*6         UAP,         UD,          UDI,         UDL
      CHARACTER*6         UET,         UF,          UH,          UL
      CHARACTER*6         UP,          UST,         UT,          UV
C
      COMMON / SWNAME /   FNEST,       FBCL,        FBCR,        SNAME
      COMMON / SWNAME /   OVKEYW                                          40.00
      COMMON / SWNAME /   OVSNAM,      OVLNAM,      OVUNIT,      UH
      COMMON / SWNAME /   UV,          UT,          UL,          UET
      COMMON / SWNAME /   UDI,         UST,         UF,          UP
      COMMON / SWNAME /   UAP,         UDL,         UD,          CHTIME   40.00
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWUITV /  *** information for output ***
C
C     Common variables
C
C        [???] default value
C
C ERRPTS [   ]   unit ref. number of file containing coord. of "problem points"
C                =16, unit reference number of the file
C INRHOG [  0]   indicates the choice for output based on "variance" or "true energy"
C                =0, output based on variance
C                =1, output based on true energy
C IUBOTR [  0]   set to 1, when IVTYPE=6 or 18
C MXOUTAR[  0]   calculates maximum memory needed for the output routines
C OVSVTY(NMOVAR) type of the output variable
C                =1, scalar
C                =2, angle
C                =3, vector
C                =4, tensor
C                =5, fully spectral quantity
C                =6, directional spectral quantity
C  ( 1)  [  1]   Xp
C  ( 2)  [  1]   Yp
C  ( 3)  [  1]   Dist
C  ( 4)  [  1]   Depth
C  ( 5)  [  3]   Vel
C  ( 6)  [  1]   Ubot
C  ( 7)  [  1]   Dissip
C  ( 8)  [  1]   Qb
C  ( 9)  [  1]   Leak
C  (10)  [  1]   Hs
C  (11)  [  1]   Tm01
C  (12)  [  1]   Tpeak
C  (13)  [  2]   Dir
C  (14)  [  2]   PkDir
C  (15)  [  2]   TDir
C  (16)  [  1]   Dspr
C  (17)  [  1]   Wlen
C  (18)  [  1]   Steepn
C  (19)  [  3]   Transp
C  (20)  [  3]   WForce
C  (21)  [  5]   AcDens
C  (22)  [  5]   EnDens
C  (23)  [  1]   Aux
C  (24)  [  1]   Xc
C  (25)  [  1]   Yc
C  (26)  [  3]   Windv
C  (27)  [  1]   FrCoef
C  (28)  [  1]   RTm01
C  (29)  [  5]   EnDens
C  (30)  [  1]   dHs
C  (31)  [  1]   dTm
C  (32)  [  1]   Tm02
C  (33)  [  1]   FSpr
C  (34)  [  1]   Urms
C  (35)  [  1]   Ufric
C  (36)  [  1]   Zlen
C  (37)  [  1]   TauW
C  (38)  [  1]   Cdrag
C  (39)  [  1]   Setup
C SPCPOW [  1]   power in expression for computation of average frequency
C                =power; set by command SET ... [power] ... (not documented)
C
      INTEGER             ERRPTS
      INTEGER             INRHOG,      IUBOTR,      MXOUTAR
      INTEGER             OVSVTY(NMOVAR),           SPCPOW
C
C
C        [???????] default value, [CALCULAT] is calculated
C
C AKPOWR [       ] power in expression for computation of average wave number
C                  =kpower; set by command SET ... [kpower] ... (not documented)
C ALCQ   [       ] angle between x-axes of computational grid and output frame
C ALPQ   [       ] angle between x-axes of user coord. system and output frame
C COSCQ  [       ] cos of ALCQ
C COSPQ  [       ] cos of ALPQ
C DXK    [       ] mesh size of output frame
C DYK    [       ] mesh size of output frame
C OVEXCV(NMOVAR)   exception value for output quantity
C  ( 1)  [ -1.E10] Xp
C  ( 2)  [ -1.E10] Yp
C  ( 3)  [  -999.] Dist
C  ( 4)  [  -1.E5] Depth
C  ( 5)  [     0.] Vel
C  ( 6)  [   -10.] Ubot
C  ( 7)  [   -10.] Dissip
C  ( 8)  [    -1.] Qb
C  ( 9)  [   -10.] Leak
C  (10)  [   -10.] Hs
C  (11)  [   -10.] Tm01
C  (12)  [   -10.] Tpeak
C  (13)  [  -999.] Dir
C  (14)  [  -999.] PkDir
C  (15)  [  -999.] TDir
C  (16)  [   -10.] Dspr
C  (17)  [   -10.] Wlen
C  (18)  [    -1.] Steepn
C  (19)  [     0.] Transp
C  (20)  [     0.] WForce
C  (21)  [  -100.] AcDens
C  (22)  [  -100.] EnDens
C  (23)  [ -1.E10] Aux
C  (24)  [ -1.E10] Xc
C  (25)  [ -1.E10] Yc
C  (26)  [     0.] Windv
C  (27)  [    -1.] FrCoef
C  (28)  [   -10.] RTm01
C  (29)  [  -100.] EnDens
C  (30)  [   -10.] dHs
C  (31)  [   -10.] dTm
C  (32)  [   -10.] Tm02
C  (33)  [    -1.] FSpr
C  (34)  [   -10.] Urms
C  (35)  [   -10.] Ufric
C  (36)  [    -1.] Zlen
C  (37)  [   -10.] TauW
C  (38)  [    -1.] Cdrag
C  (39)  [    -9.] Setup
C OVLEXP(NMOVAR)   lower expected limit of output quantity
C  ( 1)  [ -1.E10] Xp
C  ( 2)  [ -1.E10] Yp
C  ( 3)  [     0.] Dist
C  ( 4)  [  -100.] Depth
C  ( 5)  [    -2.] Vel
C  ( 6)  [     0.] Ubot
C  ( 7)  [     0.] Dissip
C  ( 8)  [     0.] Qb
C  ( 9)  [     0.] Leak
C  (10)  [     0.] Hs
C  (11)  [     0.] Tm01
C  (12)  [     0.] Tpeak
C  (13)  [     0.] Dir
C  (14)  [     0.] PkDir
C  (15)  [     0.] TDir
C  (16)  [     0.] Dspr
C  (17)  [     0.] Wlen
C  (18)  [     0.] Steepn
C  (19)  [   -10.] Transp
C  (20)  [   -10.] WForce
C  (21)  [     0.] AcDens
C  (22)  [     0.] EnDens
C  (23)  [ -1.E10] Aux
C  (24)  [  -100.] Xc
C  (25)  [  -100.] Yc
C  (26)  [   -50.] Windv
C  (27)  [     0.] FrCoef
C  (28)  [     0.] RTm01
C  (29)  [     0.] EnDens
C  (30)  [     0.] dHs
C  (31)  [     0.] dTm
C  (32)  [     0.] Tm02
C  (33)  [     0.] FSpr
C  (34)  [     0.] Urms
C  (35)  [     0.] Ufric
C  (36)  [     0.] Zlen
C  (37)  [     0.] TauW
C  (38)  [     0.] Cdrag
C  (39)  [    -1.] Setup
C OVLLIM(NMOVAR)   lower limit of validity of output quantity
C  ( 1)  [ -1.E10] Xp
C  ( 2)  [ -1.E10] Yp
C  ( 3)  [     0.] Dist
C  ( 4)  [  -1.E4] Depth
C  ( 5)  [  -100.] Vel
C  ( 6)  [     0.] Ubot
C  ( 7)  [     0.] Dissip
C  ( 8)  [     0.] Qb
C  ( 9)  [     0.] Leak
C  (10)  [     0.] Hs
C  (11)  [     0.] Tm01
C  (12)  [     0.] Tpeak
C  (13)  [     0.] Dir
C  (14)  [     0.] PkDir
C  (15)  [     0.] TDir
C  (16)  [     0.] Dspr
C  (17)  [     0.] Wlen
C  (18)  [     0.] Steepn
C  (19)  [  -100.] Transp
C  (20)  [  -1.E5] WForce
C  (21)  [     0.] AcDens
C  (22)  [     0.] EnDens
C  (23)  [ -1.E10] Aux
C  (24)  [ -1000.] Xc
C  (25)  [ -1000.] Yc
C  (26)  [  -100.] Windv
C  (27)  [     0.] FrCoef
C  (28)  [     0.] RTm01
C  (29)  [     0.] EnDens
C  (30)  [     0.] dHs
C  (31)  [     0.] dTm
C  (32)  [     0.] Tm02
C  (33)  [     0.] FSpr
C  (34)  [     0.] Urms
C  (35)  [     0.] Ufric
C  (36)  [     0.] Zlen
C  (37)  [     0.] TauW
C  (38)  [     0.] Cdrag
C  (39)  [    -1.] Setup
C OVHEXP(NMOVAR)   upper expected limit of output quantity
C  ( 1)  [  1.E10] Xp
C  ( 2)  [  1.E10] Yp
C  ( 3)  [  1.E10] Dist
C  ( 4)  [   100.] Depth
C  ( 5)  [     2.] Vel
C  ( 6)  [     1.] Ubot
C  ( 7)  [   100.] Dissip
C  ( 8)  [   100.] Qb
C  ( 9)  [   100.] Leak
C  (10)  [    10.] Hs
C  (11)  [   100.] Tm01
C  (12)  [   100.] Tpeak
C  (13)  [   360.] Dir
C  (14)  [   360.] PkDir
C  (15)  [   360.] TDir
C  (16)  [    60.] Dspr
C  (17)  [   200.] Wlen
C  (18)  [    0.1] Steepn
C  (19)  [    10.] Transp
C  (20)  [    10.] WForce
C  (21)  [   100.] AcDens
C  (22)  [   100.] EnDens
C  (23)  [  1.E10] Aux
C  (24)  [   100.] Xc
C  (25)  [   100.] Yc
C  (26)  [    50.] Windv
C  (27)  [     1.] FrCoef
C  (28)  [   100.] RTm01
C  (29)  [   100.] EnDens
C  (30)  [     1.] dHs
C  (31)  [     2.] dTm
C  (32)  [   100.] Tm02
C  (33)  [     1.] FSpr
C  (34)  [     1.] Urms
C  (35)  [     1.] Ufric
C  (36)  [     1.] Zlen
C  (37)  [     1.] TauW
C  (38)  [     1.] Cdrag
C  (39)  [     1.] Setup
C OVULIM(NMOVAR)   upper limit of validity
C  ( 1)  [  1.E10] Xp
C  ( 2)  [  1.E10] Yp
C  ( 3)  [  1.E10] Dist
C  ( 4)  [   1.E4] Depth
C  ( 5)  [   100.] Vel
C  ( 6)  [    10.] Ubot
C  ( 7)  [  1000.] Dissip
C  ( 8)  [     1.] Qb
C  ( 9)  [  1000.] Leak
C  (10)  [   100.] Hs
C  (11)  [  1000.] Tm01
C  (12)  [  1000.] Tpeak
C  (13)  [   360.] Dir
C  (14)  [   360.] PkDir
C  (15)  [   360.] TDir
C  (16)  [   360.] Dspr
C  (17)  [  1000.] Wlen
C  (18)  [     1.] Steepn
C  (19)  [   100.] Transp
C  (20)  [   1.E5] WForce
C  (21)  [  1000.] AcDens
C  (22)  [  1000.] EnDens
C  (23)  [  1.E10] Aux
C  (24)  [  1000.] Xc
C  (25)  [  1000.] Yc
C  (26)  [   100.] Windv
C  (27)  [     1.] FrCoef
C  (28)  [  1000.] RTm01
C  (29)  [  1000.] EnDens
C  (30)  [   100.] dHs
C  (31)  [   100.] dTm
C  (32)  [  1000.] Tm02
C  (33)  [     1.] FSpr
C  (34)  [    10.] Urms
C  (35)  [    10.] Ufric
C  (36)  [     1.] Zlen
C  (37)  [    10.] TauW
C  (38)  [     1.] Cdrag
C  (39)  [     1.] Setup
C SINCQ  [       ] sin of ALCQ
C SINPQ  [       ] sin of ALPQ
C XQLEN  [       ] length of x-side of output frame
C XQP    [       ] x-coordinate (user coord.) of origin of output frame
C YQLEN  [       ] length of y-side of output frame
C YQP    [       ] y-coordinate (user coord.) of origin of output frame
C
      REAL                AKPOWR,      ALCQ,        ALPQ,        COSCQ
      REAL                COSPQ,       DXK,         DYK
      REAL                OVEXCV(NMOVAR),           OVLEXP(NMOVAR)
      REAL                OVLLIM(NMOVAR),           OVHEXP(NMOVAR)
      REAL                OVULIM(NMOVAR),           SINCQ,       SINPQ
      REAL                XPQ,         XQLEN,       XQP,         YPQ
      REAL                YQLEN,       YQP,         OUTPAR(MOUTPA)        40.00
C
      COMMON / SWUITV /   ALCQ,        COSCQ,       SINCQ,       IUBOTR
      COMMON / SWUITV /   INRHOG,      ERRPTS,      DXK,         DYK
      COMMON / SWUITV /   ALPQ,        COSPQ,       SINPQ,       XQP
      COMMON / SWUITV /   YQP,         XQLEN,       YQLEN,       OVSVTY
      COMMON / SWUITV /   OVLLIM,      OVULIM,      OVLEXP,      OVHEXP
      COMMON / SWUITV /   OVEXCV,      SPCPOW,      AKPOWR,      MXOUTAR
      COMMON / SWUITV /   XPQ,         YPQ,         OUTPAR                40.00
C
