!NRL: $Id: mcel_filt.F,v 1.1.2.2 2003/06/27 22:22:25 dykes Exp $
!NRL: $Name:  $
************************************************************************
      subroutine mcel_filt (var, mcelio)
************************************************************************

      include 'MCEL.inc'
      include 'mcel_swan.inc'

      character*(*) var
      character*80 var_name
      if (var .eq. 'uwind' ) var_name = 'U10'
      if (var .eq. 'vwind' ) var_name = 'V10'
      ! Set the source for density to the main server
      nvar = 1
      call AddSources (id_interp(mcelio), MCEL_SERVER, var_name, 
     $   nvar,MCEL_DATATYPE_REAL, ierr)
      if (ierr.eq.0) then
         print *, 'mcel_filt: adding source for ', var, mcelio
      else
         print *, 'mcel_filt: failed adding source for ', var
      endif

      ! Set the name of the output var density
      call AddOutputs (id_interp(mcelio), var_name, nvar, 
     &   MCEL_DATATYPE_REAL,ierr)
      if (ierr == 0) then
         print*, 'mcel_filt: adding outputs: ', var
      else
         print*, 'mcel_filt: failed adding outputs: ', var
      end if

      ! Finish up adding the filters
      call FinalizeFilters (id_interp(mcelio), ierr)
      if (ierr.eq.0) then
         print *, 'mcel_filt: finalizing filter'
      else
         print *, 'mcel_filt: failed finalizing filter'
      end if

      return
      end
