!NRL: $Id: mcel_grid.F,v 1.1.2.4 2003/07/02 22:05:05 dykes Exp $
!NRL: $Name:  $
************************************************************************
      subroutine mcel_grid (mcelio, nx, ny, xoffset, yoffset, 
     &           deltax, deltay, depths, xgrid, ygrid, projt1)
************************************************************************

      include 'MCEL.inc'
      include 'mcel_swan.inc'

      integer ierr, ndim(2)
      real*8 origin(2), dxm(2)
      real    xgrid(nx, ny), ygrid(nx, ny)
      real    newdepths(nx, ny), depths(*)
      integer mask(nx, ny)
      character*72 projt1

      ! Create a new grid
      call NewGrid (id_grid(mcelio), 2, MCEL_GRIDTYPE_REGULAR,
     &     MCEL_GRIDCENT_NODAL, MCEL_GRIDCOORD_LATLONG, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error creating new grid', mcelio
      else
        write (*, '(a25,i5)') 'mcel_grid: new grid set:', mcelio
      endif

      ! Set grid dimensions
      ndim(1) = nx
      ndim(2) = ny
      call SetSize (id_grid(mcelio), ndim, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting ndim'
      else
        write (*, '(a20,i5,i5)') 'mcel_grid: dims set:', ndim
      endif

      ! Set grid origin
      origin(1) = xoffset
      origin(2) = yoffset
      call SetOrigin (id_grid(mcelio), origin, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting origin'
      else
        write (*, '(a22, f8.2, f8.2)') 'mcel_grid: origin set:', origin
      endif

      ! Set grids cell sizes
      dxm(1) = deltax
      dxm(2) = deltay
      call SetDX (id_grid(mcelio), dxm, ierr)
      if (ierr.ne.0) then
        print *, 'mcel_grid: error setting grid dx'
      else
        write (*, '(a25,f8.2,f8.2)') 'mcel_grid: dx and dy set:', dxm
      endif

      if (mcelio >= 1) then
         ! Create a new interpolation object from the farm
         call NewFilter (id_interp(mcelio), "relfile:interpolation.ior",
     &      "Recv side interpolation", ierr)
         if (ierr.ne.0) then
            print *, 'mcel_grid: failed creating interpolation filter'
         end if

         ! Link output grid and interpolation program
         call SetOutputGrid (id_interp(mcelio), id_grid(mcelio), ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error linking grid and interp filter'
         else
           print *, 'mcel_grid: grid set for getting from MCEL'
         end if
      else
         ! Set grid mask (0:land ; 1:water)
         mask = 0
         do ix = 1, nx 
           do iy = 1, ny
             xp = xgrid(ix, iy)
             yp = ygrid(ix, iy)
             newdepths(ix, iy) = SVALQI (xp, yp, 1, depths ,1 ,ix ,iy)
           end do
         end do
         where (newdepths .ge. 1.) mask = 1
  
         call SetMask (id_grid(mcelio), mask, ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error setting grid mask'
         endif

         ! Set a new program
         call NewProgram (id_program, 'SWAN'//projt1, ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error setting new program'
         else
           print*, 'mcel_grid: setting new program, ', 'SWAN'//projt1
         end if

         ! Link grid and program
         call SetGrid (id_program, id_grid(mcelio), ierr)
         if (ierr.ne.0) then
           print *, 'mcel_grid: error linking grid and program'
         else
           print *, 'mcel_grid: grid set for putting into MCEL'
         end if
      end if
   
      return
      end
