!NRL: $Id: ocpcomm1.inc,v 1.1.1.1 2003/03/28 15:34:04 dykes Stab $
!NRL: $Name:  $
C              OCEAN PACK COMMON BLOCKS, file 1 of 4
C
C     Contents of this file
C
C     COMMON / LEESDA / *** char. data used by the command reading system
C     COMMON / LEESDN / *** num. data used by the command reading system
C     COMMON / REFTIM / *** Origin for day and time
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72 IJsbrand G. Haagsma
C
C  1. Updates
C
C     30.72, Sept 97: Created from the old ocpcomm.ftn file
C     40.00, Apr. 99: introduced constant LINELN
C
C  2. Purpose
C
C     Common variables used by the Ocean Pack Service Routines and in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C     --
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C  LINELN [ 120]  max length of input lines (in command file)                40.00
C
      INTEGER    LINELN
      PARAMETER  (LINELN=120)
C
C  COMMON / LEESDA / *** char. data used by the command reading system ***
C
C     Common variables
C
C        [??????] default value
C
C BLANK  ['    '] blank string
C COMID  [   '$'] character which distinguishes comments in the command input
C ELTEXT [      ] contents of the last string read by reading system
C ELTYPE [      ] type of the element last read by reading system
C                 ='CHAR'; last read data element is the string in ELTEXT
C                 ='EMPT;  empty data field
C                 ='EOF';  end of file has been reached
C                 ='EOR';  end of repeat has been reached
C                 ='ERR';  incorrect data field was encountered
C                 ='INT';  last read data element is the integer in ELINT
C                 ='KEY';  last read data element is the keyword in KEYWRD
C                 ='OTHR'; other
C                 ='REAL'; last read data element is the real in ELREAL
C                 ='USED'; last read data element is processed, new can be read
C KAART  [      ] contents of the input line last read by reading system
C KAR    [      ] character last read by reading system
C                 =COMID; begin or end of comment
C                 =TABC; data element separation mark
C                 =' '; data element separation mark
C                 ='&'; continuation mark
C                 ='('; begin of data group
C                 ='*'; repetition mark
C                 =','; data element seperation mark (only for numbers)
C                 ='/'; end of repetition mark
C                 =':'; assignment mark
C                 =';'; end of record or input line
C                 ='='; assignment mark
C                 ='@'; end of file mark
C                 ='_'; continuation mark
C                 other: letter or digit to be processed by reading system
C KEYWRD [      ] contents of the last keyword read by reading system
C TABC   [CALCUL] =CHAR(9); tabular character
C
      CHARACTER*4         BLANK
      CHARACTER           COMID
      CHARACTER*(LINELN)  ELTEXT
      CHARACTER*4         ELTYPE
      CHARACTER*(LINELN)  KAART
      CHARACTER           KAR
      CHARACTER*8         KEYWRD
      CHARACTER           TABC
C
      COMMON / LEESDA /   ELTYPE,      ELTEXT,      KAART,       KAR
      COMMON / LEESDA /   KEYWRD,      BLANK,       TABC,        COMID
C
C-------------------------------------------------------------------------------
C
C  COMMON / LEESDN / *** num. data used by the command reading system ***
C
C     Common variables
C
C        [??????] default value
C
C ELREAL [      ] last element read from user command, when real or double
C
      DOUBLE PRECISION    ELREAL
C
C ELINT  [      ] last element read from user command, when integer
C KARNR  [      ] position on the input line of character last processed
C                 by the reading system,
C                 =0; no characters read yet
C                 =81; next input line has to be read to the common KAART first
C LENCST [      ] length of the string stored in ELTEXT
C
      INTEGER             ELINT,       KARNR,       LENCST
C
C CHGVAL [      ] whether last read value is different from a given value for
C                 subroutines INREAL, ININTG, INCSTR, INCTIM
C
      LOGICAL             CHGVAL
C
      COMMON / LEESDN /   ELREAL,      ELINT,       KARNR,       CHGVAL
      COMMON / LEESDN /   LENCST
C
C-------------------------------------------------------------------------------
C
C     COMMON / REFTIM /  *** Origin for day and time
C
C     Common variables
C
C           [????] default value
C
C REFDAY    [    ] Day number of the reference day. The first day entered is used
C                  as reference day, the reference time is 0:00 of the reference day.
C
      INTEGER             REFDAY
C
      COMMON / REFTIM /   REFDAY
C
