!NRL: $Id: ocplot.F,v 1.1.1.1 2003/03/28 15:34:04 dykes Stab $
!NRL: $Name:  $
C     Last change:  YGH  21 Sep 2000    2:01 pm
C                   OCEAN PACK PLOT ROUTINES
C
C  Contents of this file:
C
C     OCPSUB (CQUAN, QSCA, QR, QUNIT)
C     OCPISO (CPOS, IBX, IBY, PSTAT, F,
C     ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
C     OCPVEC (VSCA, VVX, VVY, STAG, IBD, PSTAT, IDIST)
C     OCPSCH (SLM, RSC)
C     PLOTF  (XF, YF, UPDOWN)
C     PSYM   (XF, YF, SYMS, ISYM, UPDOWN)
C     entry  PLOTP
C     SNYPT1 (X1,Y1, X2,Y2, XS,YS)
C     SNYPT2 (X1,Y1, X2,Y2, XS1,YS1, XS2,YS2, NSNYPT)
C     OPNUMB
C     OPSYMB
C
******************************************************************
*                                                                *
      SUBROUTINE OCPSUB (CQUAN, QSCA, QR, QUNIT)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C     30.70, Jan. 1998: location for plotting time corrected
C
C  2. PURPOSE
C
C     plots part of the legend under a figure
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     CQUAN  : input  one of several cases:
C                     'DELT': function increment is plotted
C                     'LENS': a length scale is plotted
C                     'AROW': a vector scale is plotted
C                     other: the text CQUAN is plotted
C     QSCA   : i/o    length of length or vector scale
C              input  if CQUAN='LENS' or 'AROW'
C              output if CQUAN='DELT'
C     QR     : i/o    number to be plotted
C              output if CQUAN='LENS' or 'AROW'
C              input  if CQUAN='DELT'
C     QUNIT  : input  unit of the plotted quantity
C
      REAL        QR, QSCA
C
      CHARACTER   CQUAN *(*), QUNIT *(*)
C
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     INTEGER INTTIM(6), OPTTIM  removed for version 30.00
C
C     &          DATES*18, DTTIWR *18                                      30.00
C              , TSTRNG *18         removed for ver. 30.00
C
C     IENT   : Number of entries into this subroutine
C     KEXP   : ??
C
      INTEGER   IENT, KEXP
C
C     RF     : ??
C     XT     : ??
C     YT     : ??
C     W1     : ??
C
      REAL      RF, XT, YT, W1
C
C     DATES  : ??
C     DTTIWR : ??
C
      CHARACTER DATES*18, DTTIWR*18
C
C  7. COMMON BLOCKS USED
C
C     XASL, YASL  inp  real   lengths of the plot
C     PMR         inp  real   plot margin
C     SYMSIZ      inp  real   size of the symbols
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OCPSUB')
      IF (SUBLNS.LE.0) THEN
        IF (ITEST.GE.50) WRITE (PRINTF, 10) SUBLNS
  10    FORMAT (' No room for legend, OCPSUB, IPL=', I6)
        RETURN
      ENDIF
C
      IF (CQUAN.EQ.'LENS') THEN
C
C           PLOT LENGTH SCALE
C
        XT  = XPSUB(SUBLNS) + 7.* SYMSIZ
        YT  = YPSUB(SUBLNS)
        CALL OCPSCH (4.*SYMSIZ/QSCA, QR)
        IF (QR.GT.10.) THEN
          CALL OPNUMB (XT, YT, SYMSIZ, QR, 0., -1)
        ELSE
          CALL OPNUMB (XT, YT, SYMSIZ, QR, 0., 2)
        ENDIF
        XT = XPSUB(SUBLNS) + 13.*SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, QUNIT, 0., 6)
        XT = XPSUB(SUBLNS)
        YT = YPSUB(SUBLNS) + SYMSIZ
        CALL OPPLOT (XT, YT, 'UP')
        YT = YPSUB(SUBLNS)
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YPSUB(SUBLNS) + 0.5*SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
        XT = XT + QR * QSCA
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YPSUB(SUBLNS) + SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YPSUB(SUBLNS)
        CALL OPPLOT (XT, YT, 'DOWN')
      ELSE IF (CQUAN.EQ.'AROW') THEN
C
C            PLOT VECTOR SCALE
C
        XT = XPSUB(SUBLNS) + 7.*SYMSIZ
        YT = YPSUB(SUBLNS)
        CALL OCPSCH (4.*SYMSIZ/QSCA, QR)
        IF (QR.GT.10.) THEN
          CALL OPNUMB (XT, YT, SYMSIZ, QR, 0., -1)
        ELSE
          CALL OPNUMB (XT, YT, SYMSIZ, QR, 0., 3)
        ENDIF
        XT = XPSUB(SUBLNS) + 13.*SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, QUNIT, 0., 6)
        XT = XPSUB(SUBLNS)
        YT = YPSUB(SUBLNS) + SYMSIZ
        CALL OPPLOT (XT, YT, 'UP')
        YT = YPSUB(SUBLNS)
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YPSUB(SUBLNS) + 0.5*SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
        W1 = QR * QSCA
        XT = XT + W1
        CALL OPPLOT (XT, YT, 'DOWN')
        XT = XT - .15*W1
        YT = YT - .07*W1
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YT + .14*W1
        CALL OPPLOT (XT, YT, 'DOWN')
        XT = XPSUB(SUBLNS) + W1
        YT = YPSUB(SUBLNS) + 0.5*SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
      ELSE IF (CQUAN.EQ.'DELT') THEN
C
C       plot function increment
C
        XT = XPSUB(SUBLNS)
        YT = YPSUB(SUBLNS)
        CALL OPPLOT (XT, YT, 'UP')
        YT = YPSUB(SUBLNS) + SYMSIZ
        XT = XT + 0.5*SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
        YT = YPSUB(SUBLNS)
        XT = XT + 0.5*SYMSIZ
        CALL OPPLOT (XT, YT, 'DOWN')
        XT = XPSUB(SUBLNS)
        CALL OPPLOT (XT, YT, 'DOWN')
C
C       QR   is given increment
C       QSCA is calculated factor for numbers appearing in plot
C
        DO 190 KEXP = 10, -10, -1
          RF = 10.**KEXP
          IF (QR .GE. 0.999*RF) GOTO 195
 190    CONTINUE
 195    QSCA = RF
C
        XT = XPSUB(SUBLNS) + 3.*SYMSIZ
        IF (QR/QSCA.GT.10.) THEN
          CALL OPNUMB (XT, YT, SYMSIZ, QR/QSCA, 0., -1)
        ELSE
          CALL OPNUMB (XT, YT, SYMSIZ, QR/QSCA, 0., 2)
        ENDIF
        XT = XPSUB(SUBLNS) + 7.1*SYMSIZ
        CALL OPTEXT (XT, YT, 0.8*SYMSIZ, 'x', 0., 1)
        XT = XPSUB(SUBLNS) + 8.*SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, '10', 0., 2)
        XT = XPSUB(SUBLNS) + 10.*SYMSIZ
        YT = YPSUB(SUBLNS) + 0.3*SYMSIZ
        CALL OPNUMB (XT, YT, 0.7*SYMSIZ, FLOAT(KEXP), 0., -1)
        YT = YPSUB(SUBLNS)
        XT = XPSUB(SUBLNS) + 13.*SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, QUNIT, 0., 6)
      ELSE IF (CQUAN.EQ.'TIME') THEN
C
C       plot time
C
        XT = XPSUB(SUBLNS)                                                30.70
        YT = YPSUB(SUBLNS)
        DATES = DTTIWR(ITMOPT, QR)                                        30.00
        IF (ITMOPT .EQ. 1) DATES(1:18) = DATES(1:15)//'   '               30.00
        IF (ITMOPT .EQ. 3) DATES(1:18) = DATES(1:17)//' '                 30.00
        CALL OPTEXT (XT, YT, SYMSIZ, DATES, 0., 18)                       30.00
      ELSE
*
*       plot CQUAN (text), QR (number), QUNIT (unit string)
*
        XT = XPSUB(SUBLNS)
        YT = YPSUB(SUBLNS)
        CALL OPTEXT (XT, YT, SYMSIZ, CQUAN, 0., 4)
        XT = XPSUB(SUBLNS) + 6.*SYMSIZ
        CALL OPNUMB (XT, YT, SYMSIZ, QR, 0., -1)
        XT = XPSUB(SUBLNS) + 13. * SYMSIZ
        CALL OPTEXT (XT, YT, SYMSIZ, QUNIT, 0., 6)
      ENDIF
*
*     decrease SUBLNS to be ready for next line
*
      SUBLNS = SUBLNS - 1
      IF (ITEST.GE.100) WRITE (PRINTF, 15)
     &       SUBLNS, CQUAN, QSCA, QR, QUNIT
  15  FORMAT (' TEST OCPSUB', I6, 1X, A, 2E12.4, A)
      RETURN
      END
****************************************************************
*                                                              *
      SUBROUTINE OCPISO (CPOS, IBX, IBY, PSTAT, F,
     &   FMIN, FSTEP, FMAX, CF, START)
*                                                              *
****************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C
C  2. PURPOSE
C
C     OCPISO organises the plotting of contour lines
C     procedure consists of the following parts:
C        determine gradients in points where F>0
C        extrapolate where F=0 (if CPOS='POS')
C        start contour lines from boundary points
C        start contour lines from interior points
C
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IBX    : input    test for x-connection between
C                       neighbouring points; IBX=0: no test
C     IBY    : input    test for y-connection between
C                       neighbouring points; IBY=0: no test
C     PSTAT  : input    status in points of grid:
C     point status is encoded in array PSTAT as follows:
C     index  IM = IXQ + (IYQ-1)*MXQ  denotes point (IXQ,IYQ)
C     if IBX and IBY are 0, it is assumed that all connections exist.
C     otherwise:
C     if IAND(PSTAT(IM),IBX) = 0, then connection between points
C     (IXQ,IYQ) and (IXQ+1,IYQ) is absent.
C     if IAND(PSTAT(IM),IBY) = 0, then connection between points
C     (IXQ,IYQ) and (IXQ,IYQ+1) is absent.
C
C     START  : in/out   array, for each mesh indicates:
C                       0: contour line went through this mesh
C                       1: new contour line can start in this mesh
C
      INTEGER    IBX, IBY, PSTAT(*), START(*)
C
C     CF     : input    function values appearing on plot are
C                       divided by cf
C     F      : input    values of function to be contoured
C     FMAX   : input    highest contour value
C     FMIN   : input    lowest contour value
C     FSTEP  : input    contour function interval
C
      REAL       CF, F, FMAX, FMIN, FSTEP
C
C     CPOS   : input    CPOS='POS' means that F>=0
C
      CHARACTER  CPOS *(*)
C
      DIMENSION  F(*)
C
C  5. PARAMETER VARIABLES
C
C
C  6. LOCAL VARIABLES
C
C     IDIR0  : initial direction of contour line
C              IDIR0=1: -45 <= direction <= 45 degr.
C                    2: 45 <= direction <= 135 degr.
C                    3: 135 <= direction <= 215 degr.
C                    4: 215 <= direction <= 305 degr.
C     IENT   : Number of entries into this subroutine
C     IM     : grid counter: IM = IXQ + (IYQ-1)*MXQ
C     IXQ    : grid counter in x-direction
C     IYQ    : grid counter in y-direction
C
      INTEGER   IDIR0, IENT, IM, IXQ, IYQ
C
C     F1     : aux. value
C     F2     : aux. value
C     CVAL   : value of function on contour line
C     SRX0   : start point in the mesh, 0 <= SRX0 <= 1.
C     SRY0   : start point in the mesh, 0 <= SRY0 <= 1.
C
      REAL      F1, F2, CVAL, SRX0, SRY0
C
C     BPV    : ??
C     BPOS   : logical, indicates whether function F is always positive,
C              derived from CPOS
C     BPOST  : indicates whether posting of function
C              value is to be done
C
      LOGICAL   BPV, BPOS, BPOST
C
C     ERRC   : error condition code.
C
      CHARACTER ERRC *4
C
C  7. COMMON BLOCKS USED
C
C     MXQ    : input    number of grid points in x-direction
C     MYQ    : input    number of grid points in y-direction
C     DXQ    : input    mesh size in x-direction
C     DYQ    : input    mesh size in y-direction
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA  IENT/0/
      CALL STRACE (IENT, 'OCPISO')
C
      IF (CPOS.EQ.'POS') THEN
        BPOS = .TRUE.
      ELSE
        BPOS = .FALSE.
      ENDIF
C---------------------------------------------------------------
C     second stage: extrapolation (if CPOS='POS')
C
      IF (BPOS) THEN
        DO 401 IXQ=1, MXQ                                                 30.72
          DO 400 IYQ=1, MYQ
            IM = IXQ + (IYQ-1)*MXQ
            F1 = F(IM)
            IF (F1.LE.0.) THEN
              F(IM) = -FSTEP
            ENDIF
 400      CONTINUE                                                        30.72
 401    CONTINUE                                                          30.72
      ENDIF
      IF (ITEST.GE.200) THEN
        DO 430  IYQ=MYQ, 1, -1
          WRITE (PRINTF, 410) IYQ
 410      FORMAT (' TEST OCPISO/400, IY=', I4)
          WRITE (PRINTF, 420) (F((IYQ-1)*MXQ+IXQ), IXQ=1,MXQ)
 420      FORMAT (10(1X,E12.4))
 430    CONTINUE
      ENDIF
C--------------------------------------------------------------
C     preparation is finished now,
C     plotting of contour lines can start
C     first for all meshes START(IM) is made 1
C
      IF (BPOS .AND. FMIN.LT.0.) FMIN = 0.
      CVAL = FMIN
      BPV = .TRUE.
 480  IF (ITEST.GE.120) WRITE (PRINTF, 485) CVAL, BPV
 485  FORMAT (' OCPISO/480 ', E12.4, L2)
      DO 500 IM = 1, MXQ*MYQ
        START(IM) = 1
 500  CONTINUE
C
C     check edge of region whether there are start points of
C     contours.
C     upward crosings are searched, going clockwise around the grid.
C                    ..................
C                    ..................
C                    ---+-------+------
C                       +       -         + MEANS F > CVAL
C                                         -       F < CVAL
*      YF0 = 0.              unused
      IYQ = 1
      DO 550 IXQ = 1, MXQ-1
        IM = IXQ
        IF (START(IM).LE.0) GOTO 550
        F1 = F(IM)
        F2 = F(IM+1)
        IF (ITEST.GE.210) WRITE (PRINTF, 525) IXQ, IYQ, IM, F1, F2
 525    FORMAT (' OCPISO/SCAN ', 3I6, 2E12.4, L2)
        IF (F1.GT.CVAL .AND. F2.LE.CVAL) THEN
          SRX0 = (F1-CVAL) / (F1-F2)
          START(IM) = 0
          IDIR0 = 2
          BPOST = BPV
          CALL ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &      IXQ, IYQ, SRX0, 0., START, PSTAT, IBX, IBY, ERRC)
        ENDIF
 550  CONTINUE
C
*      YF0 = (MYQ-1)*DYQ             unused
      IYQ = MYQ-1
      DO 600 IXQ = 1, MXQ-1
        IM = IXQ + (IYQ-1)*MXQ
        IF (START(IM).LE.0) GOTO 600
        F1 = F(IM+MXQ)
        F2 = F(IM+MXQ+1)
        IF (ITEST.GE.210) WRITE (PRINTF, 525) IXQ, IYQ, IM, F1, F2
        IF (F1.LE.CVAL .AND. F2.GT.CVAL) THEN
          SRX0 = (F1-CVAL) / (F1-F2)
          START(IM) = 0
          IDIR0 = 4
          BPOST = BPV
          CALL ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &      IXQ, IYQ, SRX0, 1., START, PSTAT, IBX, IBY, ERRC)
        ENDIF
 600  CONTINUE
C
*      XF0 = 0.        unused
      IXQ = 1
      DO 650 IYQ = 1, MYQ-1
        IM = IXQ+(IYQ-1)*MXQ
        IF (START(IM).LE.0) GOTO 650
        F1 = F(IM)
        F2 = F(IM+MXQ)
        IF (ITEST.GE.210) WRITE (PRINTF, 525) IXQ, IYQ, IM, F1, F2
        IF (F1.LE.CVAL .AND. F2.GT.CVAL) THEN
          SRY0 = (F1-CVAL) / (F1-F2)
          START(IM) = 0
          IDIR0 = 1
          BPOST = BPV
          CALL ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &      IXQ, IYQ, 0., SRY0, START, PSTAT, IBX, IBY, ERRC)
        ENDIF
 650  CONTINUE
C
*      XF0 = (MXQ-1)*DXQ           unused
      IXQ = MXQ-1
      DO 700 IYQ = 1, MYQ-1
        IM = IXQ + (IYQ-1)*MXQ
        IF (START(IM).LE.0) GOTO 700
        F1 = F(IM+1)
        F2 = F(IM+MXQ+1)
        IF (ITEST.GE.210) WRITE (PRINTF, 525) IXQ, IYQ, IM, F1, F2
        IF (F1.GT.CVAL .AND. F2.LE.CVAL) THEN
          SRY0 = (F1-CVAL) / (F1-F2)
          START(IM) = 0
          IDIR0 = 3
          BPOST = BPV
          CALL ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &      IXQ, IYQ, 1., SRY0, START, PSTAT, IBX, IBY, ERRC)
        ENDIF
 700  CONTINUE
C
C     interior of the region is scanned for start points
C
      DO 801 IYQ = 2, MYQ-1                                               30.72
        DO 800 IXQ = 1, MXQ-1
          IM = IXQ + (IYQ-1)*MXQ
          IF (START(IM).LE.0) GOTO 800
          F1 = F(IM)
          F2 = F(IM+1)
          IF (ITEST.GE.210) WRITE (PRINTF, 525) IXQ, IYQ, IM, F1, F2
          IF (F1.LE.CVAL .AND. F2.GT.CVAL) THEN
            SRX0 = (F1-CVAL) / (F1-F2)
            START(IM) = 0
            IDIR0 = 4
            BPOST = BPV
            IF (ITEST.GE.160) WRITE (PRINTF, 777) IXQ, IYQ, IM,
     &      IDIR0, BPOST, SRX0, F1, F2
 777        FORMAT (' OCPISO/START ',4I6, L2, 4E12.4)
            CALL ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &      IXQ, IYQ-1, SRX0, 1., START, PSTAT, IBX, IBY, ERRC)
            IF (ERRC.NE.'CLOS' .AND. ITEST.GT.0)
     &      CALL MSGERR (2, 'Isoline contour is not closed')
            GOTO 800
          ENDIF
 800    CONTINUE                                                          30.72
 801  CONTINUE                                                            30.72
C
C     increase contouring value
C
      CVAL = CVAL + FSTEP
      BPV = .NOT. BPV
      IF (CVAL .LE. FMAX) GOTO 480
 900  RETURN
      END
*********************************************************************
*                                                                   *
      SUBROUTINE ISOLIN (F, CVAL, FSTEP, CF, BPOST, IDIR0,
     &  IX0, IY0, SRX0, SRY0, START, PSTAT, IBX, IBY, ERRC)
*                                                                   *
*********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.60 Nico Booij
C     30.72 Nico Booij
C     40.02 IJsbrand Haagsma
C
C  1. UPDATES
C
C     01.01, Nov. 91: Number of calls PLOTF ( , ,'UP') suppressed
C                     by introducing logical var. UPLAST
C     30.60, Aug. 97: Modified a IF statement that caused problems on
C                     a Silicon Graphics machine. (PSTAT out of bounds)
C     30.72, Oct. 97: Introduced logical function EQREAL for floating point
C                     comparisons
C     40.02, Sep. 00: Replaced computed GOTO by CASE construct
C
C  2. PURPOSE
C
C     ISOLIN computes one contour line, starting from a given
C     point in a given mesh.
C
C  3. METHOD
C
C     modify IDIR (contour direction) if necessary
C     determine line on which next contour point is searched
C     determine first guess of new point
C     call search to determine new contour point,
C     if new point is on edge of mesh, move to new mesh.
C
C
C  4. ARGUMENT VARIABLES
C
C     IBX    : input    test for x-connection between
C                       neighbouring points; IBX=0: no test
C     IBY    : input    test for y-connection between
C                       neighbouring points; IBY=0: no test
C     IDIR0  : input    initial direction of contour line
C                       IDIR0=1: -45 <= direction <= 45 degr.
C                             2: 45 <= direction <= 135 degr.
C                             3: 135 <= direction <= 215 degr.
C                             4: 215 <= direction <= 305 degr.
C     IX0    : input    integer x-coordinate of starting mesh
C     IY0    : intut    integer y-coordinate of starting mesh
C     PSTAT  : input    status in points of grid
C     START  : input    indicates whether a new contour line may
C                       start in given mesh.
C
      INTEGER   IBX, IBY, IDIR0, IX0, IY0, PSTAT(*), START(*)
C
C     CF     : input    function values are divided by CF
C     CVAL   : input    value of function on contour line
C     F      : input    values of function to be contoured
C     FSTEP  : input    contour line interval
C     SRX0   : input    start point in the mesh, 0 <= SRX0 <= 1.
C     SRY0   : INPUT    start point in the mesh, 0 <= SRY0 <= 1.
C
      REAL      CF, CVAL, F, FSTEP, SRX0, SRY0
C
C     BPOST  : input    indicates whether posting of function
C                       value is to be done
C
      LOGICAL   BPOST                                                     30.72
C
C     ERRC   : output   error condition code.
C
      CHARACTER ERRC *(*)
C
      DIMENSION F(*)
C
C  6. LOCAL VARIABLES
C
C     ZFUN   : FUNCTION         COMPUTES VALUE OF THE FUNCTION IN
C                              A POINT OF THE MESH
C
C     IDIR   : ??
C     IDIR2  : ??
C     IENT   : Number of entries into this subroutine
C     II     : ??
C     IM     : ??
C     IN     : ??
C     IX     : ??
C     IY     : ??
C     IX2    : ??
C     IY2    : ??
C     NULP   : ??
C
      INTEGER   IDIR, IDIR2, IENT, II, IM, IN(4), IX, IY, IX2, IY2,
     &          NULP
C
C     AFY    : ??
C     AFX    : ??
C     ANGL   : ??
C     CPX    : ??
C     CPY    : ??
C     FCN    : ??
C     GRADF  : ??
C     SLC    : ??
C     SLCP   : ??
C     SN     : ??
C     SOMF   : ??
C     SPOST  : ??
C     SRX    : ??
C     SRY    : ??
C     SRX2   : ??
C     SRY2   : ??
C     XPOST  : ??
C     XF, YF : input    window coordinates
C     XP     : ??
C     YP     : ??
C     YPOST  : ??
C     XP1    : ??
C     YP1    : ??
C
      REAL      AFY, AFX, ANGL, CPX, CPY, FCN, GRADF, SLC, SLCP,
     &          SN, SOMF, SPOST, SRX, SRY, SRX2, SRY2, XPOST, XF, YF,
     &          XP, YP, YPOST, XP1, YP1
C
C     EQREAL : ??
C     LPOST  : ??
C     MSBLNK : ??
C     UPLAST : ??
C
      LOGICAL   EQREAL, LPOST, MSBLNK, UPLAST
C
      DIMENSION FCN(4), SN(4)
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'ISOLIN')
*
*     test output
*
      IF (ITEST.GE.80) WRITE (PRTEST, 6) DXQ, DYQ, HORSC, VRTSC
   6  FORMAT (' entry ISOLIN ', 4(1X, E12.4))
      SRX = SRX0
      SRY = SRY0
      IX = IX0
      IY = IY0
      IM = IX + (IY-1)*MXQ
      IDIR = IDIR0
      LPOST = .FALSE.
      SPOST = 100.
*     starting point of isoline
      XP1 = (IX-1+SRX)*DXQ
      YP1 = (IY-1+SRY)*DYQ
*     CALL PLOTF (XP1, YP1, 'UP')
      UPLAST = .TRUE.
C
C               modify search direction if necessary
C     if IDIR=1, first crossing is on the left side, IDIR=2, first
C     crossing is on the lower side, etc.
C     the sides of the mesh are searched for other crossings, going
C     counterclockwise around the mesh.
C     only upward crossings are considered so contours are drawn always
C     with the same orientation.
C                      4         3
C                       o-------o                 crossing
C                       |       |                 on side
C             IDIR=1 --->       |                 II=1          |
C                       |       |                               |
C                       O-------O                      O--------O
C                      1         2                     -        +
C
  10  IM = IX + (IY-1)*MXQ
      SELECT CASE(IDIR)                                                  40.02
      CASE(1)                                                            40.02
        FCN(1) = F(IM)                                                   40.02
        FCN(2) = F(IM+1)                                                 40.02
        FCN(3) = F(IM+1+MXQ)                                             40.02
        FCN(4) = F(IM+MXQ)                                               40.02
      CASE(2)                                                            40.02
        FCN(1) = F(IM+1)                                                 40.02
        FCN(2) = F(IM+1+MXQ)                                             40.02
        FCN(3) = F(IM+MXQ)                                               40.02
        FCN(4) = F(IM)                                                   40.02
      CASE(3)                                                            40.02
        FCN(1) = F(IM+1+MXQ)                                             40.02
        FCN(2) = F(IM+MXQ)                                               40.02
        FCN(3) = F(IM)                                                   40.02
        FCN(4) = F(IM+1)                                                 40.02
      CASE(4)                                                            40.02
        FCN(1) = F(IM+MXQ)                                               40.02
        FCN(2) = F(IM)                                                   40.02
        FCN(3) = F(IM+1)                                                 40.02
        FCN(4) = F(IM+1+MXQ)                                             40.02
      END SELECT                                                         40.02
      NULP = 0                                                           40.02
      DO 170 II = 1, 3
        IF (FCN(II).LE.CVAL .AND. FCN(II+1).GT.CVAL) THEN
          NULP = NULP + 1
          SN(NULP) = (FCN(II)-CVAL) / (FCN(II)-FCN(II+1))
          IN(NULP) = II
        ENDIF
 170  CONTINUE
      IF (ITEST.GE.280) WRITE (PRINTF, 177) IX, IY,
     &  NULP, IN(NULP), (FCN(II),II=1,4)
 177  FORMAT (' ISOLIN/170', 4I6, 4E12.4)
      IF (NULP.LE.0) THEN
        ERRC = 'NOCR'
        GOTO 800
      ENDIF
      IF (NULP.GT.2) THEN
        ERRC = 'MACR'
        GOTO 800
      ENDIF
      IF (NULP.EQ.2) THEN
        SOMF = 0.
        DO 180 II = 1, 4
          SOMF = SOMF + FCN(II)
 180    CONTINUE
        IF (SOMF .GT. 4.*CVAL) THEN
          NULP = 1
        ELSE
          NULP = 2
        ENDIF
      ENDIF
      IF (IN(NULP).EQ.1) THEN
        IDIR2 = IDIR-1
        IF (IDIR2.EQ.0) IDIR2 = 4
      ELSE IF (IN(NULP).EQ.3) THEN
        IDIR2 = IDIR+1
        IF (IDIR2.EQ.5) IDIR2=1
      ELSE
        IDIR2 = IDIR
      ENDIF
C
C     NEW CONTOUR POINT IS NOW DETERMINED
      SELECT CASE(IDIR2)                                                40.02
      CASE(1)                                                           40.02
        SRX2 = 1.                                                       40.02
        SRY2 = SN(NULP)                                                 40.02
      CASE(2)                                                           40.02
        SRX2 = 1.-SN(NULP)                                              40.02
        SRY2 = 1.                                                       40.02
      CASE(3)                                                           40.02
        SRX2 = 0.                                                       40.02
        SRY2 = 1.-SN(NULP)                                              40.02
      CASE(4)                                                           40.02
        SRX2 = SN(NULP)                                                 40.02
        SRY2 = 0.                                                       40.02
      END SELECT                                                        40.02
      IF (ITEST.GE.280) WRITE (PRINTF, 251) IX, IY, SRX2, SRY2, NULP,
     & IN(NULP), IDIR2
 251  FORMAT (' TEST ISOLIN/250', 2I6, 2F6.3, 3I6)
      IF (ITEST.GE.300) WRITE (PRINTF, 252) (FCN(II), II=1,4)
 252  FORMAT (1X, 10E12.4)
C     see whether this mesh is a blanking mesh or not
        MSBLNK = .FALSE.
        START(IM) = START(IM) - 1
        IF (START(IM) .LT. -4) THEN
          ERRC = 'REPX'
          GOTO 800
        ENDIF
*
* Changed the following to avoid that PSTAT gets out of bounds
*
        IF (IBX.NE.0) THEN                                                30.60
          IF (IAND(PSTAT(IM+MXQ),IBX).EQ.0) MSBLNK = .TRUE.               30.60
          IF (IAND(PSTAT(IM),IBX).EQ.0) MSBLNK = .TRUE.                   30.60
        ENDIF                                                             30.60
        IF (IBY.NE.0) THEN                                                30.60
          IF (IAND(PSTAT(IM+1),IBY).EQ.0) MSBLNK = .TRUE.                 30.60
          IF (IAND(PSTAT(IM),IBY).EQ.0) MSBLNK = .TRUE.                   30.60
        ENDIF                                                             30.60
C     plot new point
      XP = (IX-1+SRX2)*DXQ
      YP = (IY-1+SRY2)*DYQ
      IF (MSBLNK) THEN
*       CALL PLOTF (XP, YP, 'UP')
        UPLAST = .TRUE.
      ELSE
        IF (UPLAST) THEN
          CALL PLOTF (XP1, YP1, 'UP')
          UPLAST = .FALSE.
        ENDIF
        CALL PLOTF (XP, YP, 'DOWN')
C       determine whether posting of function value is to be carried out
        IF (BPOST) THEN
         IF (.NOT.EQREAL(XP,XP1)) THEN                                   30.72
          SLC = (YP-YP1) / (XP-XP1)
          IF (ITEST.GE.300) WRITE (PRINTF, 275) XP, YP, SLC,
     &    SYMSIZ, HORSC                                                  10.25
 275      FORMAT (' ISOLIN/POST ', 8E12.4)
          IF (ABS(F(IM+1)-F(IM)) + ABS(F(IM+MXQ+1)-F(IM+MXQ))
     &    .LT. FSTEP*DXQ*HORSC/SYMSIZ .AND.                              10.25
     &    ABS(F(IM+MXQ)-F(IM)) + ABS(F(IM+MXQ+1)-F(IM+1))
     &    .LT. FSTEP*DYQ*HORSC/SYMSIZ) THEN
            IF (ABS(SLC) .LT. SPOST) THEN
              XPOST = 0.5 * (XP+XP1)
              YPOST = 0.5 * (YP+YP1)
              SLCP = SLC
              LPOST = .TRUE.
              SPOST = ABS(SLC)
            ENDIF
          ENDIF
         ENDIF
        ENDIF
      ENDIF
C
C     go to next mesh
      SELECT CASE(IDIR2)                                                  40.02
      CASE(1)                                                             40.02
        IX2 = IX + 1                                                      40.02
        IF (IX2.GE.MXQ) GOTO 700                                          40.02
        IY2 = IY                                                          40.02
        SRX2 = 0.                                                         40.02
      CASE(2)                                                             40.02
        IY2 = IY + 1                                                      40.02
        IF (IY2.GE.MYQ) GOTO 700                                          40.02
        IX2 = IX                                                          40.02
        SRY2 = 0.                                                         40.02
      CASE(3)                                                             40.02
        IX2 = IX - 1                                                      40.02
        IF (IX2.LE.0) GOTO 700                                            40.02
        IY2 = IY                                                          40.02
        SRX2 = 1.                                                         40.02
      CASE(4)                                                             40.02
        IY2 = IY - 1                                                      40.02
        IF (IY2.LE.0) GOTO 700                                            40.02
        IX2 = IX                                                          40.02
        SRY2 = 1.                                                         40.02
C       check whether point is the same as start point                    40.02
        IF (IDIR0.EQ.4) THEN                                              40.02
          IF (EQREAL(SRY0,1.) .AND. (IY2.EQ.IY0)) THEN                    40.02
            IF (ABS(FLOAT(IX2-IX0)+SRX2-SRX0) .LT. 1.E-3) THEN            40.02
              ERRC = 'CLOS'                                               40.02
              GOTO 800                                                    40.02
            ENDIF                                                         40.02
          ENDIF                                                           40.02
        ENDIF                                                             40.02
C
      END SELECT                                                          40.02
C
      IX = IX2
      IY = IY2
      SRX = SRX2
      SRY = SRY2
      XP1 = XP
      YP1 = YP
      IDIR = IDIR2
      IM = IX + (IY-1)*MXQ
      GOTO 10
C
C     contour line is finished
 700  ERRC = 'OK'
      GOTO 800
C
C     plot number near the iso-line at (XPOST,YPOST)
 800  IF (LPOST) THEN
        XF = XPLO + HORSC * (XPOST-XFLO)                                 10.25
        YF = YPLO + HORSC * (YPOST-YFLO)                                 10.25
        IF (ITEST.GE.240) WRITE (PRINTF, 810) XF, YF
 810    FORMAT (' ISOLIN/POST ', 8E12.4)
        IF (XF.GT.2.*SYMSIZ .AND. XASL-XF.GT.2.*SYMSIZ .AND.
     &      YF.GT.2.*SYMSIZ .AND. YASL-YF.GT.2.*SYMSIZ) THEN
          GRADF = SQRT(1. + SLCP*SLCP)
          AFY = SLCP/GRADF
          AFX = 1./GRADF
          ANGL = ATAN(SLCP)*57.29578
          IF (LEFT) THEN
            CPX = SYMSIZ*(-0.15*AFY - AFX)
            CPY = SYMSIZ*(0.15*AFX - AFY)
            CALL OPNUMB (XF+CPX, YF+CPY, SYMSIZ, CVAL/CF, ANGL, -1)
          ELSE
            CPX = SYMSIZ*(-0.15*AFY + AFX)
            CPY = SYMSIZ*(0.15*AFX + AFY)
            CALL OPNUMB (XASL-XF-CPX, YF+CPY, SYMSIZ,
     &                                         CVAL/CF, -ANGL, -1)
          ENDIF
          IF (ITEST.GE.140) WRITE (PRINTF, 810) XF, YF, AFX, AFY,
     &    CPX, CPY, SYMSIZ, ANGL
          BPOST = .FALSE.
        ENDIF
      ENDIF
      IF (ERRC.NE.'OK' .AND. ERRC.NE.'CLOS') THEN
        IF (ITEST.GT.0) WRITE (PRINTF, 820) ERRC, IX, IY, IDIR,
     &  SRX, SRY, LPOST, BPOST
 820    FORMAT (' EXIT ISOLIN ', A, 3I6, 2E12.4, 4L2)
      ENDIF
      RETURN
C
C     end of subr. ISOLIN
      END
******************************************************************
*                                                                *
      SUBROUTINE  OCPVEC (VSCA, VVX, VVY, STAG, IBD, PSTAT, IDIST)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C     plots  a vector field
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     IBD    : input    if non-zero: tests with PSTAT whether depth is
C                       positive
C     PSTAT  : input    encodes status in points of the grid.
C     IDIST  : input    number of meshes between vector origins
C
      INTEGER   IBD, IDIST, PSTAT(*)
C
C     VSCA   : input    vector scale
C     VVX    : input    array containing x-components of vector
C     VVY    : input    array containing y-components of vector
C
      REAL      VSCA, VVX, VVY
C
C     PSTAG  : ??
C     PMS    : ??
C
      LOGICAL   PSTAG, PMS
C
C     STAG   : input    STAG='STAG': staggered grid,
C                       other: non-staggered grid
C
      CHARACTER STAG *4
C
      DIMENSION VVX(*), VVY(*)
C
C  5. PARAMETER VARIABLES
C
C     PARAMETERS:
C
C  6. LOCAL VARIABLES
C
C     HORSC  : input    length scale
C     PMR    : input    plot margin
C     XASL   : input    size of figure in x-direction
C     YASL   : input    size of figure in y-direction
C
C     IENT   : Number of entries into this subroutine
C     IX     : ??
C     IY     : ??
C     KJ     : ??
C     KP     : ??
C
      INTEGER   IENT, IX, IY, KJ, KP
C
C     VV     : ??
C     VX     : ??
C     VY     : ??
C     XQ     : ??
C     XS     : ??
C     YS     : ??
C     XT, YT : place where first character is plotted
C
      REAL      VV, VX, VY, XQ, YQ, XS, YS, XT, YT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OCPVEC')
      IF (STAG.EQ.'STAG') THEN
        PSTAG = .TRUE.
      ELSE
        PSTAG = .FALSE.
      ENDIF
C
      DO 100 IY = 1+IDIST, MYQ-IDIST, IDIST
        KJ = (IY-1)*MXQ
        YT = (IY-1)*DYQ * HORSC
        IF (YT.GT.0. .AND. YT.LT.YASL) THEN
          DO 90 IX = 1+IDIST, MXQ-IDIST, IDIST
            KP = KJ + IX
            PMS = .TRUE.
            IF (IBD.NE.0) THEN
              IF (IAND(IBD, PSTAT(KP)) .EQ. 0) PMS = .FALSE.
            ENDIF
            IF (PMS) THEN
              XT = (IX-1)*DXQ * HORSC
              IF (XT.LE.0. .OR. XT.GE.XASL) GOTO 90
              IF (PSTAG) THEN
                VX = 0.5 * (VVX(KP) + VVX(KP-1))
                VY = 0.5 * (VVY(KP) + VVY(KP-MXQ))
              ELSE
                VX = VVX(KP)
                VY = VVY(KP)
              ENDIF
              VX = VX*VSCA
              VY = VY*VSCA
              VV = ABS(VX) + ABS(VY)
              IF (ITEST.GE.220) WRITE (PRINTF, 75) XT, YT, VX, VY
  75          FORMAT (' TEST OCPVEC ', 4E12.4)
              IF (VV.GT.0.01) THEN
C               plot small circle at origin of vector
                CALL PLOTP (XT, YT, 'UP')
                CALL PLOTP (XT, YT, 'DOWN')
C/D                 CALL PSYM (XT, YT, 0.05*VV, 1, 'DOWN')
                XQ = XT + VX
                YQ = YT + VY
C               plot vector
                CALL PLOTP (XQ, YQ, 'DOWN')
C               plot arrowhead
                XS = XQ - .15*VX + .07*VY
                YS = YQ - .15*VY - .07*VX
                CALL PLOTP (XS, YS, 'DOWN')
                XS = XQ - .15*VX - .07*VY
                YS = YQ - .15*VY + .07*VX
                CALL PLOTP (XS, YS, 'DOWN')
                CALL PLOTP (XQ, YQ, 'DOWN')
              ENDIF
            ENDIF
  90      CONTINUE
        ENDIF
 100  CONTINUE
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE OCPSCH (SLM, RSC)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C     the subroutine determines a scale factor for a plot,
C     the resulting scale RSC must be smaller than SLM,
C     and it must be a number of the form 10**N, 2*10**N,
C     or 5*10**N.
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     SLM    : input    maximum size of scale factor
C     RSC    : output   chosen scale factor
C
      REAL      RSC, SLM
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     K      : aux. number
C
      INTEGER   IENT, K
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA  IENT /0/
      CALL STRACE (IENT, 'OCPSCH')
      IF (SLM .LT. 1.E-10) THEN
        WRITE (PRINTF, 10) SLM
  10    FORMAT (' ** ZERO LENGTH FOR SCALE:', E12.4)
        RETURN
      ENDIF
      RSC = 1.E8
  20  IF (RSC.LE.SLM) GOTO 30
      RSC = 0.1 * RSC
      GOTO 20
  30  K = 1
      IF (2.*RSC .LE. SLM) K = 2
      IF (5.*RSC .LE. SLM) K = 5
      RSC = K * RSC
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE  PLOTF (XF, YF, UPDOWN)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C     PLOTF plots a point given in window (physical) coordinates
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     XF, YF : input    window coordinates
C     UPDOWN : input    pen up or down when moving to the point
C
      REAL       XF, YF
C
      CHARACTER  UPDOWN *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C
      INTEGER    IENT
C
C     XL     : paper coordinate
C     YL     : paper coordinate
C
      REAL       XL, YL
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA  IENT /0/
      CALL  STRACE (IENT, 'PLOTF')
      XL = HORSC*(XF-XFLO)
      YL = VRTSC*(YF-YFLO)
      CALL PLOTP (XPLO+XL, YPLO+YL, UPDOWN)
      RETURN
      END
******************************************************************
*                                                                *
      SUBROUTINE  PSYM (XF, YF, SYMS, ISYM, UPDOWN)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C   Dec. 1990: pen is always moved to indicated location (case 'UP')
C              also if (XLAST,YLAST) seems to indicate that pen is
C              already there
C
C  2. PURPOSE
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     XF, YF : input    place whereto pen must move and where
C                       symbol must appear
C                       in paper coordinates (cm)
C     SYMS   : input   size of symbols on plot (cm)
C     ISYM   : input   symbol indicator
C     UPDOWN : input   pen up or down when moving to the point
C
      REAL      XF, YF, SYMS
      INTEGER   ISYM
      CHARACTER UPDOWN *(*)
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : number of entries into this subroutine
C     INSYM  : local value of ISYM
C     INFRAM : if True the point is inside the border
C     INLAST : if True the previous point is inside the border
C     NSNYPT : number of crossing points with border
C     XLAST  : previous pen position
C     YLAST  : previous pen position
C     XS1    : X of crossing point with border
C     YS1    : Y of crossing point with border
C     XS2    : X of crossing point with border
C     YS2    : Y of crossing point with border
C
      INTEGER   IENT, INSYM, NSNYPT
      REAL      XLAST, YLAST, XS1, YS1, XS2, YS2
      LOGICAL   INFRAM, INLAST
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT, INLAST, XLAST, YLAST
      DATA IENT/0/, XLAST/0./, YLAST/-1000./, INLAST/.FALSE./
      CALL STRACE (IENT, 'PSYM')
C
      INSYM = ISYM
      GOTO 20
C................................................................*
C                                                                *
      ENTRY PLOTP (XF, YF, UPDOWN)
C................................................................*
      CALL  STRACE (IENT, 'PLOTP')
      INSYM = -1
C
C     (XLAST, YLAST): coord. of the begin point of the segment
C     (XF, YF):       coord. of the end point of the segment
C
  20  IF (XF.GE.XPLO .AND. XF.LE.XPHI .AND. YF.GE.YPLO .AND. YF.LE.YPHI)
     &  THEN
        INFRAM = .TRUE.
      ELSE
        INFRAM = .FALSE.
      ENDIF
      IF (UPDOWN.EQ.'UP') THEN
        IF (INFRAM) THEN
          CALL OPPLOT (XF, YF, 'UP')
        ENDIF
      ELSE
        IF (INFRAM) THEN
          IF (INLAST) THEN
C           both ends of the line segment inside the frame:
            CALL OPPLOT (XF, YF, 'DOWN')
          ELSE
C           one end of line segment inside, one end outside the frame:
            CALL SNYPT1 (XF,YF,XLAST,YLAST,XS1,YS1)
            CALL OPPLOT (XS1, YS1, 'UP')
            CALL OPPLOT (XF, YF, 'DOWN')
          ENDIF
        ELSE
          IF (INLAST) THEN
C           one end of line segment inside, one end outside the frame:
            CALL SNYPT1 (XLAST,YLAST, XF,YF, XS1,YS1)
            CALL OPPLOT (XS1, YS1, 'DOWN')
          ELSE
C           both ends of the line segment outside the frame:
            CALL SNYPT2 (XF,YF, XLAST,YLAST, XS1,YS1, XS2,YS2, NSNYPT)
            IF (NSNYPT.EQ.2) THEN
              CALL OPPLOT (XS1, YS1, 'UP')
              CALL OPPLOT (XS2, YS2, 'DOWN')
            ENDIF
          ENDIF
        ENDIF
      ENDIF
C     PLOT SYMBOL IF INSYM>=0
      IF (INFRAM .AND. INSYM.GE.0) THEN
        IF (LEFT) THEN
*         CALL OPMARK (XF, YF, SYMS, INSYM, 'DOWN')
          CALL OPSYMB (XF, YF, SYMS, INSYM, 0., 'DOWN')
        ELSE
*         CALL OPMARK (XASL-XF, YF, SYMS, INSYM, 'DOWN')
          CALL OPSYMB (XASL-XF, YF, SYMS, INSYM, 0., 'DOWN')
        ENDIF
      ENDIF
      IF (ITEST.GE.160) WRITE (PRINTF,89) XLAST, YLAST, XF, YF,
     &  INLAST, INFRAM, INSYM
  89  FORMAT (' Test PLOTP/PSYM ',4F10.2, L4, L4, I4)
      XLAST = XF
      YLAST = YF
      INLAST = INFRAM
      RETURN
C  *  end of subr. PLOTP/PSYM *
      END
******************************************************************
*                                                                *
      SUBROUTINE  SNYPT1 (X1,Y1, X2,Y2, XS,YS)
*                                                                *
******************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C  2. PURPOSE
C
C     determines the crossing point of a line segment with the
C     edge of the frame; (XS,YS) is the crossing point in paper
C     coord. (cm)
C     the end points of the line segment are (X1,Y1) and (X2,Y2).
C     it is assumed that (X1,Y1) is inside the frame, and
C     (X2,Y2) outside.
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     X1     : X of begin point
C     Y1     : Y of begin point
C     X2     : X of end point
C     Y2     : Y of end point
C     XS     : X of crossing
C     YS     : Y of crossing
C
      REAL      X1, Y1, X2, Y2, XS, YS
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C
      INTEGER   IENT
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SNYPT1')
C
      IF (X2.GE.XPLO) GOTO 30
      XS = XPLO
      YS = Y2 + (Y1-Y2)*(XS-X2)/(X1-X2)
      IF ((YS.GE.YPLO).AND.(YS.LE.YPHI)) GOTO 90
  30  IF (X2.LE.XPHI) GOTO 40
      XS = XPHI
      YS = Y2 + (Y1-Y2)*(XS-X2)/(X1-X2)
      IF ((YS.GE.YPLO).AND.(YS.LE.YPHI)) GOTO 90
  40  IF (Y2.GE.YPLO) GOTO 50
      YS = YPLO
      XS = X2 + (X1-X2)*(YS-Y2)/(Y1-Y2)
      IF ((XS.GE.XPLO).AND.(XS.LE.XPHI)) GOTO 90
  50  IF (Y2.LE.YPHI) GOTO 60
      YS = YPHI
      XS = X2 + (X1-X2)*(YS-Y2)/(Y1-Y2)
      IF ((XS.GE.XPLO).AND.(XS.LE.XPHI)) GOTO 90
  60  WRITE (PRINTF,61) X1, Y1, X2, Y2, XS, YS
  61  FORMAT (' Error subr. SNYPT1, no crossing found ',
     &  /, 6 E12.4)
  90  RETURN
C     end of subroutine SNYPT1
      END
******************************************************************
*                                                                *
      SUBROUTINE SNYPT2 (X1,Y1, X2,Y2, XS1,YS1, XS2,YS2, NSNYPT)          40.02
*                                                                *
******************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
C
C  1. UPDATES
C
C     30.72, Oct. 97: Introduced logical function EQREAL for floating point
C                     comparisons
C     40.02, Sep. 00: Rewritten to avoid computed goto's
C
C  2. Purpose
C
C     Determines the number of crossing points and their coordinates of a
C     line segment with the plotting frame. Both ends of the line segment
C     should be outside the plotting frame.
C
C  3. Method
C
C     First check wether the line segment lies fully right, left, top or bottom
C     of the plotting frame. When this is not the case it looks for possible cross-
C     sections with all four sides of the plotting frame.
C
C  4. Modules or Common Blocks used
C
      IMPLICIT NONE
C
C     OUTPDA : data for output, mainly plotting
C
      INCLUDE 'ocpcomm3.inc'
C
C  5. Argument variables
C
C     NSNYPT : Total number of crossing points
C
      INTEGER, INTENT(OUT) ::   NSNYPT
C
C     XS1    : X-coordinate of first cross-section
C     XS2    : X-coordinate of second cross-section
C     X1     : X-coordinate of begin line segment
C     X2     : X-coordinate of end line segment
C     YS1    : Y-coordinate of first cross-section
C     YS2    : Y-coordinate of second cross-section
C     Y1     : Y-coordinate of begin line segment
C     Y2     : Y-coordinate of end line segment
C
      REAL, INTENT(IN)     ::   X1 ,Y1 , X2 ,Y2
      REAL, INTENT(OUT)    ::   XS1 ,YS1 , XS2, YS2
C
C  6. Parameter variables (Constants)
C
C     --
C
C  7. Local variables
C
C     IENT   : Number of entries into this subroutine
C     ISNYPT : Number of crossing points found
C
      INTEGER, SAVE        ::  IENT   = 0
      INTEGER              ::  ISNYPT
C
C     X      : Array with X-coordinates of cross-sections found
C     XS     : X-coordinate of guess for cross-section
C     Y      : Array with X-coordinates of cross-sections found
C     YS     : Y-coordinate of guess for cross-section
C
      REAL                 ::  XS, YS
      REAL                 ::  X(2), Y(2)
C
C  8. Subroutines used
C
C     EQREAL : Function to determine wheter two floats are equal.
C     STRACE : Traces number of entries for debugging purposes
C
      LOGICAL              ::  EQREAL
C
C  9. Subroutines calling
C
C     PSYM   : ...
C
C 10. Error Messages
C
C     --
C
C 11. Remarks
C
C     --
C
C 12. Structure
C
C     If line segment is fully outside plotting frame Then Return
C     For all sides
C       If cross-section found Then
C         Increase number of cross-section
C         Store coordinates
C     Store coordinates in argument variables
C
C 13. Source text:
C
      CALL STRACE (IENT,'SNYPT2')
C
C     Initialise the number of crossings found:
C
      ISNYPT = 0
      NSNYPT = 0
C
C     Check whether begin and end of the line segment lie fully left, right,
C     up or under the plotting frame:
C
      IF ((X1.LT.XPLO).AND.(X2.LT.XPLO)) RETURN
      IF ((X1.GT.XPHI).AND.(X2.GT.XPHI)) RETURN
      IF ((Y1.LT.YPLO).AND.(Y2.LT.YPLO)) RETURN
      IF ((Y1.GT.YPHI).AND.(Y2.GT.YPHI)) RETURN
C
      IF (.NOT.EQREAL(Y1,Y2)) THEN
C
C       Check on bottom side
C
        YS = YPLO
        XS = X2 + (X1-X2)*(YS-Y2)/(Y1-Y2)
        IF ((XS.GE.XPLO).AND.(XS.LE.XPHI)) THEN
          ISNYPT    = ISNYPT + 1
          X(ISNYPT) = XS
          Y(ISNYPT) = YS
        ENDIF
C
C       Check on top side
C
        YS = YPHI
        XS = X2 + (X1-X2)*(YS-Y2)/(Y1-Y2)
        IF ((XS.GE.XPLO).AND.(XS.LE.XPHI)) THEN
          ISNYPT    = ISNYPT + 1
          X(ISNYPT) = XS
          Y(ISNYPT) = YS
        ENDIF
      ENDIF
C
      IF (.NOT.EQREAL(X1,X2)) THEN
C
C       Check on left side
C
        XS = XPLO
        YS = Y2 + (Y1-Y2)*(XS-X2)/(X1-X2)
        IF ((YS.GE.YPLO).AND.(YS.LE.YPHI)) THEN
          ISNYPT    = ISNYPT + 1
          X(ISNYPT) = XS
          Y(ISNYPT) = YS
        ENDIF
C
C       Check on right side
C
        XS = XPHI
        YS = Y2 + (Y1-Y2)*(XS-X2)/(X1-X2)
        IF ((YS.GE.YPLO).AND.(YS.LE.YPHI)) THEN
          ISNYPT    = ISNYPT + 1
          X(ISNYPT) = XS
          Y(ISNYPT) = YS
        ENDIF
      ENDIF
C
C     Store correct values in argument variables
C
      NSNYPT = ISNYPT
      XS1    = X(1)
      YS1    = Y(1)
      XS2    = X(2)
      YS2    = Y(2)
C
      RETURN
C
      END SUBROUTINE SNYPT2
********************************************************************
*                                                                  *
      SUBROUTINE OPNUMB (XT, YT, SYMS, REVAL, ANGL, NDEC)
*                                                                  *
********************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C  1. UPDATES
C
C     10.04, July 94: Subroutine is renamed OPNUMB and moved to
C                     file OCPLOT.FTN
C
C  2. PURPOSE
C
C     OPNUMB plots a real number
C     the number is converted to a string and then written to file
C     using subroutine OPTEXT
C
C  3. METHOD
C
C  4. ARGUMENT VARIABLES
C
C     XT, YT : input    place where first character is plotted
C     SYMS   : input    size of symbols on plot
C     REVAL  : input    real number to be plotted
C     ANGL   : input    angle under which the number is plotted
 
C
      REAL      XT, YT, SYMS, ANGL, REVAL
C
C     STRNG  : char. string into which value of REVAL is written
C
      CHARACTER *10 STRNG
C
C     NDEC   : input    number of decimals
C
      INTEGER   NDEC
C
C  5. PARAMETER VARIABLES
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     ND1    : ??
C
      INTEGER   IENT, ND1
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'OPNUMB')
C
      IF (REVAL.GE.1.E6 .OR. REVAL.LE.-1.E5) THEN
         ND1 = 7
         WRITE (STRNG, '(F8.0)') REVAL
      ELSE IF (REVAL.GE.1.E5 .OR. REVAL.LE.-1.E4) THEN
         ND1 = 6
         WRITE (STRNG, '(F8.1)') REVAL
      ELSE IF (REVAL.GE.10000. .OR. REVAL.LE.-1000.) THEN
         ND1 = 5
         WRITE (STRNG, '(F8.2)') REVAL
      ELSE IF (REVAL.GE.1000. .OR. REVAL.LE.-100.) THEN
         ND1 = 4
         WRITE (STRNG, '(F8.3)') REVAL
      ELSE IF (REVAL.GE.100. .OR. REVAL.LE.-10.) THEN
             ND1 = 3
         WRITE (STRNG, '(F8.4)') REVAL
      ELSE IF (REVAL.GE.10. .OR. REVAL.LT.-1.E-5) THEN
             ND1 = 2
         WRITE (STRNG, '(F8.5)') REVAL
      ELSE IF (REVAL.GE.1.E-5) THEN
             ND1 = 1
         WRITE (STRNG, '(F8.6)') REVAL
      ELSE
             ND1 = 1
         WRITE (STRNG, '(E8.2)') REVAL
      ENDIF
      IF (STRNG(1:2).EQ.' .') STRNG(1:2) = '0.'
      IF (STRNG(1:3).EQ.' -.') STRNG(1:3) = '-0.'
      CALL OPTEXT (XT, YT, SYMS, STRNG, ANGL, ND1+NDEC+1)
      RETURN
      END
********************************************************************
*                                                                  *
      SUBROUTINE OPSYMB (XT, YT, SYMS, ISYM, ANGLE, UPDOWN)
*                                                                  *
********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.74: IJsbrand Haagsma (Include version)
C
C  1. Updates
C
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C
C  2. Purpose
C
C     OPSYMB plots a single (centered and oriented) symbol
C
C
C  4. ARGUMENT VARIABLES
C
C     ISYM   : input    indicator of symbol to be plotted
C                       symbol is centered at (XT,YT)
C
      INTEGER    ISYM
C
C     SYMS   : input    size of symbols on plot
C     XT, YT : input    place where first character is plotted
C     ANGLE  : input    angle under which the symbol must be plotted
C
      REAL       XT, YT, SYMS, ANGLE
C
C     UPDOWN : input    'UP':   pen moves to (XT,YT) with pen up
C                       'DOWN': pen moves to (XT,YT) with pen down
C
      CHARACTER  UPDOWN *(*)
C
C  5. PARAMETER VARIABLES
C
C     MXSYM  : ??
C     NSYMS  : ??
C
      INTEGER    MXSYM, NSYMS
C
      PARAMETER  (NSYMS=14, MXSYM=78)
C
C  6. LOCAL VARIABLES
C
C     IENT   : Number of entries into this subroutine
C     ISP    : ??
C     NSE    : ??
C     NSB    : ??
C
      INTEGER    IENT, ISP, NSE(NSYMS), NSB(NSYMS)
C
C     COSA   : ??
C     PI     : ??
C     SINA   : ??
C     XP     : ??
C     YP     : ??
C     XSYM   : ??
C     YSYM   : ??
C
      REAL       COSA, PI, SINA, XP, YP, XSYM(MXSYM), YSYM(MXSYM)
C
C  7. COMMON BLOCKS USED
C
C  8. SUBROUTINE USED
C
C  9. SUBROUTINES CALLING
C
C 10. ERROR MESSAGES
C
C 11. REMARKS
C
C 12. STRUCTURE
C
C 13. SOURCE TEXT
C
      SAVE IENT, PI, NSB, NSE, XSYM, YSYM
C
C     the arrays XSYM and YSYM provide relative coordinates for the symbol
C     data for symbol ISYM start at NSB(ISYM) and end at NSE(ISYM)
C     symbols are: +,O,*,X, triangle down, triangle up, diabolo vert,
C     diabolo hor, diabolo obl 1, diabolo obl 2, thick dot,
C
      DATA PI    /3.1415926536/
      DATA NSB   /1, 7,  16, 22, 27, 31, 35, 40, 45, 50, 55,
     &            64, 69, 71/
      DATA NSE   /6, 15, 21, 26, 30, 34, 39, 44, 49, 54, 63,
     &            68, 70, 78/
      DATA XSYM  /0., 0., 0.5, -0.5, 0., 0.,
     &            0., -0.28, -0.4, -0.28, 0., 0.28, 0.4, 0.28, 0.,
     &            0., -0.3, 0.48, -0.48, 0.3, 0.,
     &            0.35, -0.35, 0., -0.35, 0.35,
     &            0., 0.43, -0.43, 0.,
     &            0., 0.43, -0.43, 0.,
     &            0.35, -0.35, 0.35, -0.35, 0.35,
     &            0.35, 0.35, -0.35, -0.35, 0.35,
     &            0., 0., -0.5, 0.5, 0.,
     &            0., 0., 0.5, -0.5, 0.,
     &            0., 0., -0.2, 0.2, 0., 0., 0.2, -0.2, 0.,
     &            0., -0.5, 0., 0.5, 0.,
     &            -0.5, 0.5,
     &            -0.45, -0.48, -0.48, -0.45, 0.5, 0.45, 0.45, 0.5/
      DATA YSYM  /0.5, 0., 0., 0., 0., -0.5,
     &            0.4, 0.28, 0., -0.28, -0.4, -0.28, 0., 0.28, 0.4,
     &            0.5, -0.4, 0.15, 0.15, -0.4, 0.4,
     &            0.35, -0.35, 0., 0.35, -0.35,
     &            -0.5, 0.25, 0.25, -0.5,
     &            0.5, -0.25, -0.25, 0.5,
     &            0.35, 0.35, -0.35, -0.35, 0.35,
     &            0.35, -0.35, 0.35, -0.35, 0.35,
     &            0.5, -0.5, 0., 0., 0.5,
     &            0.5, -0.5, 0., 0., 0.5,
     &            0.2, -0.2, 0., 0., 0.2, -0.2, 0., 0., 0.2,
     &            0.05, 0., -0.05, 0., 0.05,
     &            0., 0.,
     &            0., 0.02, -0.02, 0., 0., 0.03, -0.03, 0./
      DATA IENT /0/
      CALL STRACE (IENT, 'OPSYMB')
*
      IF (ISYM.LT.1 .OR. ISYM.GT.NSYMS) THEN
        WRITE (PRINTF, 10) ISYM
  10    FORMAT (' subr OPSYMB, symbol nr out of range:', I5)
        RETURN
      ENDIF
      COSA = COS(PI*ANGLE/180.)
      SINA = SIN(PI*ANGLE/180.)
      IF (UPDOWN.EQ.'DOWN') THEN
        CALL OPPLOT (XT, YT, 'DOWN')
      ENDIF
      CALL OPTYPE (10, 1.)
      DO 30 ISP = NSB(ISYM), NSE(ISYM)
        XP = XT + SYMS * (COSA * XSYM(ISP) - SINA * YSYM(ISP))
        YP = YT + SYMS * (SINA * XSYM(ISP) + COSA * YSYM(ISP))
        IF (ISP.EQ.NSB(ISYM)) THEN
          CALL OPPLOT (XP, YP, 'UP')
        ELSE
          CALL OPPLOT (XP, YP, 'DOWN')
        ENDIF
  30  CONTINUE
      IF (UPDOWN.EQ.'DOWN') THEN
        CALL OPPLOT (XT, YT, 'UP')
      ENDIF
C
      RETURN
C     end of subroutine OPSYMB
      END
