!NRL: $Id: swancom3.F,v 1.3.2.1 2003/03/31 18:49:19 campbell Exp $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000   11:45 am
C
C     SWAN/COMPU   file 3 of 6
C
C     PROGRAM SWANCOM3.FOR
C
C     This file SWANCOM3 of the main program SWAN program
C     includes the next subroutines (mainly subroutines for
C     the source terms for generation of wave energy ) :
C
C     WNDPAR  (DOLPHIN-B formulations for the SWAN model for a
C             first- or a second generation first guess of the spectrum)
C     WINDP1 (computation of variables derived from the wind such as
C             mean wind velocity, mean wind direction, minimum counter
C             for the wind, maximum counter for the wind, wind friction
C             velocity and the Pierson Moskowitz frequency )
C     WINDP2 (computation of wind sea energy spectrum necessary for
C             the second generation wind growth model)
C     WINDP3 (limit the energy spectrum in the case of a first or
C             second generation wind growth model)
C     SWIND0 (linear input term Cavaleri and Malanotte Rizolli (1981)
C     SWIND3 (third generation wind growth model (Snyder et al. 1981;
C             Komen et al., 1984)
C     SWIND4 (third generation wind growth model (Janssen, 1989,1991)
C     SWIND5 (third generation wind growth model according to the
C             expression of Yan (1987) (especially derived for a
C             frequency range that extend to the high frequencies
C
C****************************************************************
C
      SUBROUTINE WNDPAR (ISSTOP,IDWMIN,IDWMAX,IDCMIN,IDCMAX,              32.06
     &                   DEP2  ,WIND10,                                   32.06
     &                   THETAW,AC2   ,KWAVE ,IMATRA,IMATDA,              32.06
     &                   SPCSIG,CGO   ,ALIMW ,GROWW ,ETOTW ,              32.06
     &                   PLWNDA,PLWNDB,SPCDIR,ITER            )           32.06
C
C****************************************************************
C
      IMPLICIT NONE                                                       30.82
C
      INCLUDE 'swcomm3.inc'                                               32.06
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.75: IJsbrand Haagsma (bug fix)
C     30.82: IJsbrand Haagsma
C     32.06: Roeland Ris
C     40.00: Nico Booij (Nonstationary boundary conditions)
C
C  1. Updates
C
C            Jan. 97: New subroutine (Roeland Ris)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: argument list of WINDP2 changed
C     30.75, Mar. 98: Set FPM=SIGPKD, due to change in argument list of WINDP2
C     40.00, July 98: argument list of WINDP2 changed
C     30.82, Oct. 98: Updated description of several variables
C     30.82, Apr. 99: Dimensioning KCGRD corrected
C     32.06, June 99: Reformulated directional spreading for first guess
C     30.82, June 99: Implicit none added; all variables declared
C
C  2. Purpose
C
C     Computation of the wind input source term with formulations
C     of a first-generation model (constant porportionality coefficient)
C     and a second-generation model (proportionality coefficient depends
C     on the energy in the wind sea part of the spectrum). The
C     expressions are from Holthuijsen and de Boer (1988) and from
C     the DOLPHIN-B model (Holthuijsen and Booij). During the
C     implementation of the terms modifications to the code have been
C     made after personal communications with Holthuijsen and Booij.
C
C  3. Method
C
C     The source term of the following nature:
C
C     S = A + B E          for E < Elim   | t - tw | < pi/2
C
C         (Elim-E)
C     S = --------         for E > Elim   | t - tw | < pi/2
C            TAU
C
C     S = 0                for E > Elim   | t - tw | > pi/2
C
C     in which the terms A and B are:
C
C         [cf10]          2        2        2              4
C     A = ------ pi (1./g)  [rhoaw]  [cdrag]  (U cos(t-tw))
C          2 pi
C
C     and:
C                              U cos(t-tw)              s
C     B = 5 [cf20] [rhoaw] f { ----------- -  [cf30] } ----
C                                  Cph                 2 pi
C
C     The coefficient TAU in the relaxation model is given by:
C                           2
C                   / 2 pi \      g
C     TAU = [cf40] | -----  | ------------
C                   \  s    /  U cos(d-dw)
C
C     The limiting spectrum is given by:
C
C                    -3
C             ALPHA K                 s   -4    2     2
C     Elim = ----------- exp ( -5/4 (----)   ) --- cos ( t - tw )
C             2  Cg                  spm        pi
C
C     in which:
C
C        ALPHA   wind sea and/or depth dependent proportionality
C                coefficient which controls the energy scale of the
C                limiting spectrum.
C              * In the first-generation model ALPHA is a constant
C                equal to 0.0081 (fully developed)
C              * In the second-generation model ALPHA depends on the
C                energy in the wind sea part of the spectrum. ALPHA
C                is calculated here by:
C                                                [cf60]
C                            ALPHA = [cf50] * Edml
C
C        spm     adapted Pierson-Moskowitz (1964) peak frequency
C
C     The total non-dimensional energy in the wind sea part of the
C     spectrum is calculated by (see subroutine WINDP2):
C
C                   2
C               grav  * ETOTW
C       Edml =  -------------
C                       4
C                 wind10
C
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C  6. Local variables
C
C     IENT  : Number of entries into this subroutine
C
      INTEGER IENT
C
      REAL  :: FPM    ! Pierson-Moskowitz frequency
      REAL  :: SWIND_EXP, SWIND_IMP    ! explicit and implicit part of wind source
C
C        INTEGERS:
C        ---------
C        IDWMIN      Minimum counter for spectral wind direction
C        IDWMAX      Maximum counter for spectral wind direction
C        IX          Counter of gridpoint in x-direction
C        IY          Counter of gridpoint in y-direction
C        IS          Counter of frequency bin
C        ISSTOP      Countrer for the maximum frequency of all directions
C        IDDUM       Dummy counter
C        ID          Counter of directional distribution
C        IDWMIN/IDWMAX  Minimum / maximum counter in wind sector (180 degrees)
C
C        REALS:
C        ---------
C        ALPM        Coefficient for overshoot at deep water
C        ALPMD       Coefficient for overshoot corrected for shallow
C                    water using expression of Bretschnieder (1973)
C        ALIMW       limiting spectrum in terms of action density
C        ARG1, ARG2  Exponent
C        CDRAG       Wind drag coefficient
C        DND         Nondimensional depth
C        DTHETA      Difference in rad between wave and wind direction
C        EDML        Dimensionless energy
C        ETOTW       Total energy of the wind sea part of the spectrum
C        RHOAW       Density of air devided by the density of water
C        SIGPK       Peak frequency in terms of rad /s
C        SIGPKD      Adapted peak frequency for shallow water
C        TAU         Variable for the wind growth equation
C        THETA       Spectral direction
C        THETAW      Mean direction of the relative wind vector
C        TWOPI       Two times pi
C        WIND10      Velocity of the relative wind vector
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C        ALIMW     2D    Limiting action density spectrum
C        DEP2      1D    Depth
C        CGO       2D    Group velocity
C        KWAVE     2D    Wave number
C        LOGSIG    1D    Logaritmic distribution of frequency
C        IMATRA    2D    Coefficients of right hand side of vector
C        IMATDA    2D    Coefficients of the diagonal
C        PLWNDA    3D    Values of source term for test point
C        PLWNDB    3D    Values of source term for test point
C        SPCDIR    1D    Spectral direction of wave component
C        IDCMIN    1D    Minimum counter
C        IDCMAX    1D    Maximum counter in directional space
C        GROWW     2D    Aux. array to determine whether there are
C                        wave generation conditions
C
C        PWIND(1)  = CF10     188.0
C        PWIND(2)  = CF20     0.59
C        PWIND(3)  = CF30     0.12
C        PWIND(4)  = CF40     250.0
C        PWIND(5)  = CF50     0.0023
C        PWIND(6)  = CF60    -0.2233
C        PWIND(7)  = CF70     0.       (not used)
C        PWIND(8)  = CF80    -0.56     (not used)
C        PWIND(9)  = RHOAW    0.00125  (density air / density water)
C        PWIND(10) = EDMLPM   0.0036   (limit energy Pierson Moskowitz)
C        PWIND(11) = CDRAG    0.0012   (drag coefficient)
C        PWIND(12) = UMIN     1.0      (minimum wind velocity)
C        PWIND(13) = PMLM     0.13     (  )
C
C     5. SUBROUTINES CALLING
C
C        SOURCE
C
C     6. SUBROUTINES USED
C
C        WINDP2     (compute the total energy in the wind sea part of
C                     the spectrum). Subroutine WINDP2 is called in
C                     SWANCOM1 in subroutine SOURCE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   --------------------------------------------------------------
C   Calculate the adapted peak frequency
C   --------------------------------------------------------------
C   If first-generation model
C     alpha is constant
c   else
C     Calculate energy in wind sea part of spectrum ETOTW
C     Calculate alpha on the basis of ETOTW
C   end
C   --------------------------------------------------------------
C   Take depth effects into account for alpha
C   --------------------------------------------------------------
C   For each frequency and direction
C     compute limiting spectrum and determine whether there is
C     grow or decay
C   end
C   --------------------------------------------------------------
C   Do for each frequency and direction
C     If wind-wave generation conditions are present
C       calculate A + B E
C     else if energy is larger than limiting spectrum
C       calculate dissipation rate with relaxation model
C     endif
C   enddo
C   --------------------------------------------------------------
C   Store results in matrix (IMATRA or IMATDA)
C   --------------------------------------------------------------
C   End of the subroutine WNDPAR
C   --------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER  IS    ,ID    ,ITER  ,
     &         IDWMIN,IDWMAX,IDDUM ,ISSTOP
C
      REAL     WIND10,THETA ,THETAW,EDML  ,ARG1  ,ARG2  ,
     &         ALPM  ,ALPMD ,TEMP1 ,TEMP2 ,FACTA ,FACTB ,
     &         ADUM  ,BDUM  ,CINV  ,SIGTPI,SIGMA ,TWOPI ,TAUINV,
     &         SIGPK ,SIGPKD,DND   ,ETOTW ,ALIM1D,
     &         DIRDIS,AC2CEN,DTHETA
C
      REAL  :: AC2(MDC,MSC,MCGRD)
      REAL  :: ALIMW(MDC,MSC)
      REAL  :: IMATDA(MDC,MSC), IMATRA(MDC,MSC)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: KWAVE(MSC,MICMAX)                                          40.22
      REAL  :: PLWNDA(MDC,MSC,NPTST)                                      40.00
      REAL  :: PLWNDB(MDC,MSC,NPTST)
      REAL  :: DEP2(MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CGO(MSC,MICMAX)                                            40.22
C
      INTEGER  IDCMIN(MSC)           ,
     &         IDCMAX(MSC)
C
      LOGICAL  GROWW(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'WNDPAR')
C
C     *** initialization of arrays ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          GROWW(ID,IS) = .FALSE.
          ALIMW(ID,IS) = 0.
        ENDDO
      ENDDO
C
C     *** calculate the adapted shallow water peak frequency         ***
C     *** according to Bretschneider (1973) using the nondimensional ***
C     *** depth DND                                                  ***
C
      TWOPI  = 2. * PI
      DND    = MIN( 50. , GRAV * DEP2(KCGRD(1)) / WIND10**2 )
      SIGPK  = TWOPI * 0.13 * GRAV / WIND10
      SIGPKD = SIGPK / TANH(0.833*DND**0.375)
      FPM    = SIGPKD                                                     30.75
C
      IF ( IWIND .EQ. 1 ) THEN
C
C       *** first generation model ***
C
        ALPM = 0.0081
C
      ELSE IF (IWIND .EQ. 2 ) THEN
C
C       *** second generation model ***
C
C       *** Determine the proportionality constant alpha on the basis ***
C       *** of the total energy in the wind sea part of the spectrum  ***
C       *** output of subroutine (WINDP2) is ETOTW                    ***
C
        CALL WINDP2 (IDWMIN  ,IDWMAX  ,SIGPKD  ,FPM     ,
     &               ETOTW   ,
     &               AC2     ,SPCSIG  ,         WIND10               )    40.00
 
        EDML = MIN ( PWIND(10) , (GRAV**2 * ETOTW) / WIND10**4 )
        EDML = MAX ( 1.E-25 , EDML )
C
        ARG1 = ABS(PWIND(6))
        ALPM = MAX( 0.0081, (PWIND(5) * (1./EDML)**ARG1) )
C
      ENDIF
C
C     *** Take into account depth effects for proportionality ***
C     *** constant alpha through the nondimensional depth DND ***
C
      ALPMD  = 0.0081 + ( 0.013 - 0.0081 ) * EXP ( -1. * DND )
      ALPM   = MIN ( 0.155  ,  MAX ( ALPMD , ALPM ) )
C
C     *** Calculate the limiting spectrum in terms of action density   ***
C     *** for the wind sea part (centered around the local wind        ***
C     *** direction). For conversion of f^-5 --> k^-3 and coefficients ***
C     *** see Kitaigorodskii et al. 1975                               ***
C
      DO IS = 1, ISSTOP
        TEMP1  = ALPM / ( 2. * KWAVE(IS,1)**3 * CGO(IS,1) )
        ARG2   = MIN ( 2. , SIGPKD / SPCSIG(IS) )                         30.72
        TEMP2  = EXP ( (-5./4.) * ARG2**4 )
        ALIM1D = TEMP1 * TEMP2 / SPCSIG(IS)                               30.72
        DO IDDUM = IDWMIN, IDWMAX
          ID     = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          THETA  = SPCDIR(ID,1)                                           30.82
C
C     For better convergence the first guess of the directional spreading 32.06
C     is modified in third generation mode. The new formulation better    32.06
C     fits the directional spreading of the deep water growth curves.     32.06
C
          IF ((ITER.EQ.1).AND.(IGEN.EQ.3)) THEN                           32.06
            DIRDIS = 0.434917 * (MAX(0., COS(THETA - THETAW)))**0.6       32.06
          ELSE                                                            32.06
            DIRDIS = (2./PI) * COS(THETA - THETAW)**2
          END IF                                                          32.06
C
          ALIMW(ID,IS) = ALIM1D * DIRDIS
          AC2CEN       = AC2(ID,IS,KCGRD(1))
          IF ( AC2CEN .LE. ALIMW(ID,IS) ) THEN
            GROWW(ID,IS) = .TRUE.
          ELSE
            GROWW(ID,IS) = .FALSE.
          ENDIF
        ENDDO
C       *** test output ***
        IF ( TESTFL .AND. ITEST .GE. 10 ) THEN
          WRITE(PRINTF,2002) IS, SPCSIG(IS), KWAVE(IS,1), CGO(IS,1)       30.72
 2002     FORMAT(' WNDPAR: IS SPCSIG KWAVE CGO :',I3,3E12.4)              30.72
          WRITE(PRINTF,2003) TEMP1, TEMP2, ARG2
 2003     FORMAT(' WNDPAR: TEMP1 TEMP2 ARG2    :',3X,3E12.4)
        END IF
      ENDDO
C
C     *** Calculate the wind input (linear term A and exponential  ***
C     *** term B) in wave generating conditions or disspation term ***
C     *** if energy in bin is larger than limiting spectrum        ***
C
C
      FACTA = PWIND(1) * PI * PWIND(9)**2 * PWIND(11)**2 / GRAV**2
C
      DO IS = 1, ISSTOP
        SIGMA   = SPCSIG(IS)                                              30.72
        SIGTPI  = SIGMA * TWOPI
        CINV    = KWAVE(IS,1) / SIGMA
        FACTB = PWIND(2) * PWIND(9) * SIGMA / TWOPI                       34.00
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID     = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          DTHETA = SPCDIR(ID,1) - THETAW                                  30.82
          AC2CEN = AC2(ID,IS,KCGRD(1))
C
          SWIND_EXP = 0.                                                  40.13
          SWIND_IMP = 0.                                                  40.13
 
          IF ( GROWW(ID,IS) ) THEN
C           *** term A ***
            IF ( SIGMA .GE. ( 0.7 * SIGPKD ) ) THEN
              ADUM = FACTA * (WIND10 * COS(DTHETA))**4
              ADUM = MAX ( 0. , ADUM / SIGTPI )
            ELSE
              ADUM = 0.
            END IF
C           *** term B; Note that BDUM is multiplied with a factor 5 ***
C           *** as in the DOLPHIN-B model                            ***
C
            BDUM = MAX( 0., ((WIND10 * CINV) * COS(DTHETA)-PWIND(3)))
            BDUM = FACTB * BDUM * 5.
            SWIND_EXP = ADUM + BDUM * AC2CEN                              40.13
C
          ELSE IF ( .NOT. GROWW(ID,IS) .AND. AC2CEN .GT. 0. ) THEN
C
C           *** for no energy dissipation outside the wind field     ***
C           *** TAUINV is set equal zero (as in the DOLPHIN-B model) ***
C
            IF ( COS ( DTHETA ) .LT. 0. ) THEN
              TAUINV = 0.
            ELSE
              TAUINV = ( SIGMA**2 * WIND10 * ABS(COS(DTHETA)) ) /
     &                 ( PWIND(4) * GRAV * TWOPI**2 )
            ENDIF
            SWIND_EXP = TAUINV * ALIMW(ID,IS)
            SWIND_IMP = -TAUINV
            ADUM = ALIMW(ID,IS)
            BDUM = TAUINV
          END IF
C
C         *** store results in IMATDA and IMATRA ***
C
          IMATRA(ID,IS) = IMATRA(ID,IS) + SWIND_EXP
          IMATDA(ID,IS) = IMATDA(ID,IS) - SWIND_IMP
          IF (TESTFL) PLWNDA(ID,IS,IPTST) = SWIND_EXP                     40.13
          IF (TESTFL) PLWNDB(ID,IS,IPTST) = SWIND_IMP                     40.13
C
C
C         *** test output ***
C
!         Value of ITEST changed from 10 to 110 to reduce test output     40.13
          IF ( TESTFL .AND. ITEST .GE. 110 ) THEN                        40.13
            WRITE(PRINTF,2004) IS, ID, GROWW(ID,IS), ADUM, BDUM           40.13
 2004       FORMAT(' WNDPAR: IS ID GROWW ADUM BDUM     :',                40.13
     &             2I3,2X,L1,2X,2E12.4)
          END IF
        ENDDO
      ENDDO
C
C     *** test output ***
C
!     Value of ITEST changed from 10 to 60 to reduce test output          40.13
      IF ( TESTFL .AND. ITEST .GE. 60 ) THEN                              40.13
        WRITE(PRINTF,*)
        WRITE(PRINTF,6051) IDWMIN, IDWMAX
 6051   FORMAT(' WNDPAR : IDWMIN IDWMAX     :',2I5)
        WRITE(PRINTF,6052) THETAW,WIND10,SIGPK,SIGPKD
 6052   FORMAT(' WNDPAR : Tw U10 Spk Spk,d   :',4E12.4)
        WRITE(PRINTF,7050) ETOTW, EDML, ALPM, ALPMD
 7050   FORMAT(' WNDPAR: ETOW EDML ALPM ALPMD:',4E12.4)
      ENDIF
C
      RETURN
C     end of subroutine WNDPAR
      END
C
C****************************************************************
C
      SUBROUTINE WINDP1 (WIND10     ,THETAW     ,
     &                   IDWMIN     ,IDWMAX     ,
     &                   FPM        ,UFRIC      ,
     &                   WX2        ,WY2        ,
     &                   ANYWND     ,SPCDIR     ,                         40.00
     &                   UX2        ,UY2        ,SPCSIG     )             30.70
C
C****************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.82: IJsbrand Haagsma
C     32.06: Roeland Ris
C     40.00: Nico Booij (Nonstationary boundary conditions)
C
C  1. Updates
C
C     20.64,        : limited sector is now taken into account
C                     argument SPCDIR is added
C     30.70, Feb. 98: relative wind velocity is determined
C                     arguments UX2, UY2, SPCSIG added
C                     full common introduced
C     40.00, July 98: argument list changed: KCGRD removed
C     30.82, Oct. 98: Updated description of several variables
C     32.06, June 99: Reformulation of wind speed in terms of friction
C                     velocity for first and second generation
C
C  2. Purpose
C
C        Computation of parameters derived from the wind for several
C        subroutines such as :
C                              SWIND1, SWIND2 SWIND3
C                              CUTOFF
C
C        Output of this subroutine :
C
C        WIND10 , THETAW, IDWMIN, IDWMAX , UFRIC, FPM
C
C     3. METHOD
C
C     a. For SWIND1 and SWIND2 :
C
C        SIGMA_FPM = 0.13 * GRAV * 2 * PI / WIND10
C
C     b. For SWIND3 (wind input accodring to Snyder (1981) ***
C
C       - wind friction velocity according to Wu (1982):
C           *                                                -3
C         U  =  UFRIC = wind10 sqrt( (0.8 + 0.065 wind10 ) 10  )
C
C     c. For SWIND4 (wind input according to Janssen 1991)
C
C       - wind friction velocity:
C
C          UFRIC = sqrt ( CDRAG) * U10
C
C          for U10 < 7.5 m/s  ->  CDRAG = 1.2873.e-3
C
C          else wind friction velocity according to Wu (1982):
C
C         *                                                -3
C         U  =  UFRIC = wind10 sqrt( (0.8 + 0.065 wind10 ) 10  )
C
C     d.
C        The Pierson Moskowitz radian frequency for a fully developed
C        sea state spectrum for all third generation wind input
C        models is equal to:
C
C                        grav
C        SIGMA_FPM  =  ---------
C                      28 UFRIC
C        -----------------------------------------------------------
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
C
C        IDWMIN           Minimum counter for spectral wind direction
C        IDWMAX           Maximum counter for spectral wind direction
C        IX               Counter of gridpoints in x-direction
C        IY               Counter of gridpoints in y-direction
C        MXC              Maximum counter of gridppoints in x-direction
C        MYC              Maximum counter of gridppoints in y-direction
C        KCGRD   int, i   Point index for grid point                      30.21
C        MCGRD   int, i   Maximum counter of gridpoints in space          30.21
C        ICMAX   int, i   Maximum counter for the points of the molecule  30.21
C
C        REALS:
C        ---------
C
C        PI          (3,14)
C        GRAV        Gravitational acceleration
C        THETAW      Mean direction of the relative wind vector
C        WIND10      Velocity of the relative wind vector
C        U10         wind velocity from SWANPREn
C        WDIC        mean wind direction from SWANPREn
C        FPM         PM frequency
C        UFRIC       Wind firction velocity
C
C        one and more dimensional arrays:
C        ---------------------------------
C        WX2,WY2     2D   Wind velocity array relative to a current
C        PWIND       1D   coefficients for wind expressions
C        ANYWND      1D   Indicator if wind input has to be taken into
C                         account for a bin
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C     ------------------------------------------------------------
C     If constant wind then
C       set parameters WIND10 and WDIC equal U10 and WDIC
C     else compute
C       wind velocity and mean wind direction
C     ----------------------------------------------------------
C     compute the minimum and maximum counters for wind source term
C     for which the wid input is active
C     compute the Pierson Moskowitz frequency for IWIND = 1, 2
C     compute the wind friction velocity and PM freq. for IWIND = 3
C     ------------------------------------------------------------
C     End of the subroutine WINDP1
C     ------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER      IDWMIN ,IDWMAX                                         30.70
C
      REAL         WIND10 ,THETAW ,                                       30.70
     &             UFRIC  ,FPM    ,CDRAG  ,SDMEAN                         30.70
C
      REAL         WX2(MCGRD)   ,
     &             WY2(MCGRD)   ,
     &             UX2(MCGRD)   ,                                         30.70
     &             UY2(MCGRD)                                             30.70
C
      LOGICAL      ANYWND(MDC)
C
      REAL         AWX, AWY, RWX, RWY                                     30.70
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'WINDP1')
C
C     compute absolute wind velocity                                      30.70
      IF (VARWI) THEN
        AWX = WX2(KCGRD(1))
        AWY = WY2(KCGRD(1))
      ELSE
        AWX = U10 * COS(WDIC)
        AWY = U10 * SIN(WDIC)
      ENDIF
C     compute relative wind velocity                                      30.70
      IF (ICUR.EQ.0) THEN
        RWX = AWX
        RWY = AWY
      ELSE
        RWX = AWX - UX2(KCGRD(1))
        RWY = AWY - UY2(KCGRD(1))
      ENDIF
C     compute absolute value of relative wind velocity                    30.70
      WIND10 = SQRT(RWX**2+RWY**2)
      IF (WIND10.GT.0.) THEN
        THETAW = ATAN2 (RWY,RWX)
        THETAW = MOD ( (THETAW + PI2) , PI2 )
      ELSE
        THETAW = 0.
      ENDIF
C
C     *** compute the minimum and maximum counter for the active  ***
C     *** wind field :                                            ***
C     ***                                   .                     ***
C     *** IDWMAX =135 degrees             .<--mean wind direction ***
C     ***              \ o o o | o o o  .     (THETAW)            ***
C     ***                \ o o | o o  .  o                        ***
C     ***                  \ o | o  .  o o                        ***
C     ***                    \ |  .  o o o                        ***
C     ***      ----------------\--------------------              ***
C     ***                      | \ o o o o                        ***
C     ***                      |   \ o o o                        ***
C     ***                      |     \ o o                        ***
C     ***                             IDWMIN = 325 degrees        ***
C     ***                                                         ***
C
*     move ThetaW to the right interval, shifting + or - 2*PI             20.64
      SDMEAN = 0.5 * (SPCDIR(1,1) + SPCDIR(MDC,1))                        30.82
      IF (THETAW .LT. SDMEAN - PI) THETAW = THETAW + 2.*PI
      IF (THETAW .GT. SDMEAN + PI) THETAW = THETAW - 2.*PI
*
      IF ( (THETAW - 0.5 * PI) .LE. SPCDIR(1,1) ) THEN                    30.82
        IF ( (THETAW + 1.5 * PI) .GE. SPCDIR(MDC,1) ) THEN
          IDWMIN = 1
        ELSE
          IDWMIN = NINT ( (THETAW + 1.5*PI - SPCDIR(1,1)) / DDIR ) + 1    30.82
        ENDIF
      ELSE
        IDWMIN = NINT ( (THETAW - 0.5*PI - SPCDIR(1,1)) / DDIR ) + 1      30.82
      END IF
*
      IF ( (THETAW + 0.5 * PI) .GE. SPCDIR(MDC,1) ) THEN                  30.82
        IF ( (THETAW - 1.5 * PI) .LE. SPCDIR(1,1) ) THEN                  30.82
          IDWMAX = MDC
        ELSE
          IDWMAX = NINT ( (THETAW - 1.5 * PI - SPCDIR(1,1)) / DDIR ) + 1  30.82
        ENDIF
      ELSE
        IDWMAX = NINT ( (THETAW + 0.5 * PI - SPCDIR(1,1)) / DDIR ) + 1    30.82
      ENDIF
C
      IF ( IDWMIN .GT. IDWMAX) IDWMAX = MDC + IDWMAX
*
*  old code (before 20.64):
*      IF ( (THETAW - ( PI / 2. ) ) .LE. 0. ) THEN
*        IDWMIN = NINT ( (THETAW + ( (3. * PI) / 2. ) ) / DDIR ) + 1
*        IF ( IDWMIN .EQ. (MDC+1) ) IDWMIN = 1
*      ELSE
*        IDWMIN = NINT ( (THETAW - ( PI / 2. ) ) / DDIR ) + 1
*      END IF
*C
*      IF ( (THETAW + (PI / 2. )) .GE. ( 2. * PI) ) THEN
*        IDWMAX = NINT ( (THETAW - ( (3. * PI) / 2. ) ) / DDIR )
*      ELSE
*        IDWMAX = NINT ( (THETAW + ( PI / 2. ) ) / DDIR )
*        IF ( IDWMAX .EQ. (MDC+1) ) IDWMAX = IDWMAX - 1
*      END IF
*C
*      IF ( IDWMIN .GT. IDWMAX) IDWMAX = MDC + IDWMAX
C
C     *** determine for which bin the wind input is active ***
C     *** initialize array for active wind input           ***
C
      DO ID = 1, MDC
        ANYWND(ID) = .FALSE.
      ENDDO
C
      IF ( TESTFL .AND. ITEST .GE. 30 ) THEN
          WRITE(PRINTF,500) IDWMIN, IDWMAX
 500      FORMAT(' WINDP1: IDWMIN IDWMAX :',2I15)
      ENDIF
C
      DO IDDUM = IDWMIN , IDWMAX
        ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
        ANYWND(ID) = .TRUE.
C
        IF ( TESTFL .AND. ITEST .GE. 40 ) THEN
          WRITE(PRINTF,400) IDDUM, ID, ANYWND(ID)
 400      FORMAT(' WINDP1: IDDUM ID ANYWND :',2I5,L4)
        ENDIF
C
      ENDDO
C
C     *** compute the Pierson Moskowitz frequency ***
C
      IF ( IWIND .EQ. 1 .OR. IWIND .EQ. 2 ) THEN
C
C       *** first and second generation wind wave model ***
C
        IF ( WIND10 .LT. PWIND(12) ) WIND10 = PWIND(12)
        FPM = 2. * PI * PWIND(13) * GRAV / WIND10
C
C       *** determine U friction in case predictor is obtained ***
C       *** with second genaration wave model                  ***
C
        IF ( WIND10 .GT. 7.5 ) THEN
          UFRIC = WIND10 * SQRT (( 0.8 + 0.065 * WIND10 ) * 0.001 )
        ELSE
          CDRAG = 0.0012873
          UFRIC = SQRT ( CDRAG ) * WIND10
        ENDIF
C
C     Reformulation of the wind speed in terms of friction velocity.      32.06
C     This formulation is based on Bouws (1986) and described in Delft    32.06
C     Hydraulics report H3515 (1999)                                      32.06
C
        WIND10 = WIND10 * SQRT(((0.8 + 0.065 * WIND10) * 0.001) /         32.06
     &                         ((0.8 + 0.065 * 15.   ) * 0.001))          32.06
C
      ELSE IF (IWIND .GE. 3 ) THEN
C
C       *** Calculate the wind friction velocity  ***
C       *** according to Wu (1982)                ***
C
        IF ( WIND10 .GT. 7.5 ) THEN
          UFRIC = WIND10 * SQRT (( 0.8 + 0.065 * WIND10 ) * 0.001 )
        ELSE
          CDRAG = 0.0012873
          UFRIC = SQRT ( CDRAG ) * WIND10
        ENDIF
C
C       *** Wind friction velocity and PM-frequency ***
C
        UFRIC = MAX ( 1.E-15 , UFRIC)
        FPM =  GRAV / ( 28.0 * UFRIC )
      ENDIF
CC
CC      *** deleted 20.64 ***
CC
CC      ELSE IF (IWIND .EQ. 4) THEN
CC
CC       *** wind input term according to Janssen (1991) ***
CC
CC        IF ( WIND10 .GT. 7.5 ) THEN
CC          UFRIC = WIND10 * SQRT (( 0.8 + 0.065 * WIND10 ) * 0.001 )
CC        ELSE
CC          CDRAG = 0.0012873
CC          UFRIC = SQRT ( CDRAG ) * WIND10
CC        ENDIF
CC
CC        UFRIC = MAX ( 1.E-15 , UFRIC )
CC        FPM =  GRAV / ( 28.0 * UFRIC )
CC
CC      END IF
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 50 ) THEN
        WRITE(PRINTF,6050) KCGRD(1), MDC, MCGRD, IWIND                    30.21
 6050   FORMAT(' WINDP1:INDEX MDC MCGRD IWND:',4I5)
        WRITE(PRINTF,6052) THETAW,WIND10,WDIC,U10
 6052   FORMAT('       : THAW WIND10 WDIC U10 :',4E12.4)
        WRITE(PRINTF,6054) GRAV, PI, DDIR, VARWI
 6054   FORMAT('       : GRAV PI DDIR VARWI     :',3E12.4,L6)
        WRITE(PRINTF,6056) IDWMIN,IDWMAX,FPM, UFRIC
 6056   FORMAT('       : IDWMIN IDWMAX FPM UFR:',2I4,2E12.4)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     end of subroutine WINDP1
      END
C
C****************************************************************
C
      SUBROUTINE WINDP2 (IDWMIN  ,IDWMAX  ,SIGPKD  ,FPM     ,
     &                   ETOTW   ,
     &                   AC2     ,SPCSIG  ,                               40.00
     &                   WIND10                                      )    30.70
C
C****************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.70: Nico Booij
C
C  1. Updates
C
C     20.72, Jan. 96: Integration modified, using FRINTF, FRINTH
C                     and PWTAIL(6)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: full common introduced, argument list changed
C                     ISFPM changed (in case of very high value of FPM)
C     40.00, July 98: argument list changed: KCGRD removed
C
C  2. Purpose
C
C     Computation of wind sea energy spectrum for the second
C     generation wind growth model. Output of the subroutine
C     is ETOTW (total wind sea energy spectrum)
C
C  3. Method
C
C     Compute the wind sea energy spectrum : ETOTW
C
C             +90  inf
C             |   |
C     ETOTW = |   |        E(s,d) ds dd
C            -90  0.7*FPM
C
C     Compute the total energy density ETOTW for F > 0.7 FPM
C
C          ^  |
C       E()|  |          *
C             |        *   *
C             |              *
C             |       *      | *      / ETOTW(e)
C             |              | o  * /
C             |      *       | o o/o *
C             |              | o o o o o *
C             |     *        | o o o o o o o o*
C            0---------------|---------------------------
C             0          0.7*FPM              SIGMA --> s
C
C                   SIGMA MAX
C                  |
C      ETOTW(d) =  |  E(s,d)ds      ISFPM = FPM
C                 0.7 FPM
C
C      and over the interval +/- 90 degrees (according to
C      the mean wind direction as computed in WINDP1 )
C
C            IDWMAX = "135"
C               o
C      ETOTW =  o  ETOTW(d)dd
C
C         IDWMIN ="325"
C
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        ISFPM       Counter in point just for the Pierson Moskowitz
C                    frequency
C        IDWMIN      Minimum counter for spectral wind direction
C        IDWMAX      Maximum counter for spectral wind direction
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C
C        DAC2        Difference in action density between two neighbour
C                    points (IS and IS+1)
C        DD          Directional band width
C        DSIG        Distance between FPM and next frequency
C        DUM_DS      Distance betwee the relative frequency and the
C                    next frequency value : LOGSIG(IS+1) - FPM
C        ETOT_       Dummy variables to compute the total energy
C        ETOTW       Total energy density over the sea spectrum, i.e.
C                    a > apm and a 180 degrees spectral interval
C        CNETOT      contribution of high frequency tail over the
C                    full spectrum
C        FPM         Pierson Moskowitz frequency
C        SIGFAC      Relative difference between two frequencies
C        THETAW      Mean direction of the relative wind vector
C        WIND10      Velocity of the relative wind vector
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU, SOURCE
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C     ------------------------------------------------------------
C     Determine the counter for the FPM frequency
C     integrate the wind sea energy spectrum
C     add the energy of the high frequency tail to the spectrum
C     ------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
C
      INTEGER  IDWMIN  ,IDWMAX  ,
     &         IDDUM   ,ID      ,IS      ,ISFPM
C
      REAL     ETOTW   ,FPM     ,SIG     ,ATOTD
 
      REAL     AC2(MDC,MSC,MCGRD)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'WINDP2')
C
C     *** compute wind sea energy spectrum for IS > 0.7 FPM       ***
C     *** minimum FPM is equal : 2 * pi * 0.13 * grav / pwind(12) ***
C     *** is equal 8 rad/s = 1.27 Hz                              ***
C
      ISFPM = MSC                                                         30.70
      FACINT = 0.                                                         30.70
      DO IS = 1, MSC
        SIG = SPCSIG(IS)                                                  30.72
        IF (FRINTH * SIG .GT. (0.7 * FPM) ) THEN
          ISFPM =  IS
          FACINT = (FRINTH - 0.7*FPM/SIG) / (FRINTH - 1./FRINTH)
          GOTO 11
        END IF
      ENDDO
 11   CONTINUE
C
C     *** calculate the energy in the wind sea part of the spectrum ***
C     *** from ISFPM.                                               ***
C
      ETOTW = 0.
      DO IS = ISFPM, MSC
        SIG = SPCSIG(IS)                                                  30.72
        ATOTD = 0.
        DO IDDUM = IDWMIN, IDWMAX
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          ATOTD = ATOTD + AC2(ID,IS,KCGRD(1))                             30.21
        ENDDO
        IF (IS.EQ.ISFPM) THEN
          ETOTW = ETOTW + FACINT * FRINTF * SIG**2 * DDIR * ATOTD
        ELSE
          ETOTW = ETOTW + FRINTF * SIG**2 * DDIR * ATOTD
        ENDIF
      ENDDO
*     add high-frequency tail:
      ETOTW = ETOTW + PWTAIL(6) * SIG**2 * DDIR * ATOTD
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 70 ) THEN
        WRITE(PRINTF,*)
        WRITE(PRINTF,6050) IWIND,IDWMIN,IDWMAX, ISFPM, ETOTW
 6050   FORMAT(' WINDP2: IWND IDWMIN IDWMAX ISFPM ETOTW:',4I6,1X,E12.4)
      END IF
C
      RETURN
C     end of subroutine WINDP2
      END
C
C********************************************************************
C
      SUBROUTINE WINDP3 (MDC     ,MSC     ,ISSTOP  ,ALIMW   ,AC2     ,
     &                   GROWW   ,IDCMIN  ,IDCMAX  ,KCGRD   ,MCGRD   ,
     &                   ICMAX                                       )    30.21
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     1. UPDATE
C
C        ---
C
C     2. PURPOSE
C
C        Reduce the energy density in spectral direction direct after
C        solving the tri-diagonal matrix if the energy density level is
C        larger then the upper bound limit given by a Pierson Moskowitz
C        spectrum. This is only carried out if a particular wave
C        component is 'growing'.
C
C        If the energy density in a bin is larger than the upper bound
C        limit (for instance when crossing wind seas are present) then
C        the energy density level is a lower limit.
C
C     3. METHOD
C
C        The upper bound limit is given by:
C
C                       2                  -4
C               ALPHA  g              sigma     2     2
C    A(s,t) = ----------- exp ( -5/4 (----)   ) --- cos ( d - dw )
C               sigma^6                FPM       pi
C
C         in which ALPHA is wind sea dependent (see subroutine
C         SWIND2) :
C
C                      /                                 C60   \
C                     |                / E_windsea g^2 \        |
C         ALPHA = MIN | 0.0081 ,  C50 |  ------------   |       |
C                      \               \    U_10^4     /        /
C
C
C     4. PARAMETERLIST
C
C        INTEGERS :
C        ----------
C        IX IY            Grid point in geographical space
C        MDC ,MSC         Counters in spectral space
C        ISSTOP           Maximum frequency that fall within a sweep
C
C        ARRAYS:
C        -------
C        AC2      4D      Action density as funciton of x,y,s,t
C        ALIMW    2D      Contains the action density upper bound
C                         limit regardind spectral action density per
C                         spectral bin (A(s,t))
C        GROWW    2D      Logical array which determines is there is
C                         a) generation  ( E < E_lim -> .TRUE.  ) or
C                         b) dissipation ( E > E_lim -> .FALSE. )
C        IDCMIN   1D      Frequency dependent minimum counter
C        IDCMAX   1D      Frequency dependent minimum counter
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every spectral bin
C     If wave input for a bin is true (GROWW(ID,IS) = .TRUE.) and
C        if wave action is larger then maximum then reduce
C        wave action to limit its value to upper boundary limit
C     else if no growth (see subroutine SWIND1 and SWIND2), check
C       if the energy density level in the wind sea part
C       of the spectrum is lower than upper bound limit. If so
C       set energy level equal to upper bound limit
C     endif
C   ------------------------------------------------------------
C   End of the subroutine WINDP3
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER     IS      ,MDC     ,MSC     ,ID      ,ISSTOP  ,IDDUM   ,
     &            MCGRD   ,ICMAX                                          30.21
C
      INTEGER     IDCMIN(MSC)       ,
     &            IDCMAX(MSC)       ,
     &            KCGRD(ICMAX)                                            30.21
C
      REAL        AC2CEN
C
      REAL        AC2(MDC,MSC,MCGRD)    ,
     &            ALIMW(MDC,MSC)
C
      LOGICAL     GROWW(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'WINDP3')
C
C     *** limit the action density spectrum ***
C
      DO IS = 1, ISSTOP
        DO IDDUM = IDCMIN(IS) , IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          AC2CEN = AC2(ID,IS,KCGRD(1))
          IF ( GROWW(ID,IS) .AND. AC2CEN .GT. ALIMW(ID,IS) )
     &      AC2(ID,IS,KCGRD(1)) = ALIMW(ID,IS)
          IF ( .NOT. GROWW(ID,IS) .AND. AC2CEN .LT. ALIMW(ID,IS) )
     &      AC2(ID,IS,KCGRD(1)) = ALIMW(ID,IS)
C
          IF (TESTFL .AND. ITEST .GE. 50) THEN
             WRITE(PRINTF,300) IS,ID,GROWW(ID,IS),AC2CEN,ALIMW(ID,IS)
 300         FORMAT(' WINDP3 : IS ID GROWW AC2CEN ALIM:',2I4,L4,2E12.4)
          END IF
C
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (TESTFL .AND. ITEST .GE. 50) THEN
        WRITE(PRINTF,4000) KCGRD(1),ISSTOP,MSC,MDC,MCGRD
 4000   FORMAT(' WINDP3 : POINT ISSTOP MSC MDC MCGRD :',5I5)
      END IF
C
      RETURN
C     end of subroutine WINDP3
      END
C
C****************************************************************
C
      SUBROUTINE SWIND0 (MDC     ,MSC     ,IDCMIN  ,IDCMAX  ,ISSTOP  ,
     &                   SPCSIG  ,THETAW  ,GRAV    ,PI      ,ANYWND  ,    30.72
     &                   UFRIC   ,FPM     ,PLWNDA  ,IMATRA  ,SPCDIR  ,
     &                   KCGRD   ,ICMAX   ,PWIND                     )    7/MAR
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C
C  2. PURPOSE
C
C     Computation of the source term for the wind input for a
C     third generation wind growth model:
C
C     1)  Linear wind input term according to Cavaleri and
C         Malanotte-Rizzoli (1981)
C
C  3. METHOD
C
C     To ensure wave growth when no wave energy is present in the
C     numerical model a linear growth term is used (see
C     Cavaleri and Malanotte-Rizzoli 1981). Contributions for
C     frequencies lower then FPM have been eliminated buy aa filter :
C
C                  -3
C            1.5*10      *                       4      sigma -4
C  A = Sin = ------- { U  max[0, (cos(d - dw )] } exp{-(-----)  } / Jac
C               2                                        FPM
C              g
C
C        With Jac = Jacobian =  2 pi sigma
C
C        The Pierson Moskowitz radian frequency for a fully developed
C        sea state spectrum is as follows (computed in WINDP2 :
C
C                1       g
C        FPM  = ---- ---------  * 2 pi
C               2 pi  28 UFRIC
C
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IDWMIN      Minimum counter for spectral wind direction
C        IDWMAX      Maximum counter for spectral wind direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C        FPM         Pierson Moskowitz frequecy (WAM)
C        GRAV        Gravitatiuonal acceleration
C        SWINEO      Coefficient stored in IMATDA
C        THETA       Spectral direction
C        THETAW      Mean direction of the relative wind vector
C        UFRIC       Wind friction velocity
C
C        one and more dimensional arrays:
C        ---------------------------------
C        IMATRA    2D    Coefficients of right hand side of matrix
C        ANYWND    1D    Determines the number of directional bins
C                        that fall within the wind sea part of the
C                        spectrum ( thetaw +- 90 degrees)
C        IDCMIN    1D    Frequency dependent counter
C        IDCMAX    1D    Frequency dependent counter
C
C     5. SUBROUTINES CALLING
C
C        SOURCE
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every spectral bin that faal witin the sweep considered:
C     compute the source term Sinl and store the results in array
C   --------------------------------------------------------------
C   End of the subroutine SWIND0
C   --------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER  IDDUM   ,ID      ,MDC     ,MSC     ,IS      ,
     &         ISSTOP  ,ICMAX                                             30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     FPM     ,GRAV    ,UFRIC   ,THETA   ,THETAW  ,
     &         SWINEA  ,PI      ,SIGMA   ,TEMP1   ,TEMP2   ,
     &         TEMP3   ,FILTER
C
      REAL    IMATRA(MDC,MSC)      ,
     &        PLWNDA(MDC,MSC,NPTST),                                      40.00
     &        PWIND(*)                                                    7/MAR
C
      INTEGER IDCMIN(MSC)          ,
     &        IDCMAX(MSC)
C
      LOGICAL ANYWND(MDC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWIND0')
C
C     *** calculate linear wind input term ***
C
      FPM =  GRAV / ( 28.0 * UFRIC )
      TEMP1 = PWIND(31) / ( GRAV**2 * 2. * PI )                           7/MAR
      DO IS = 1, ISSTOP
        SIGMA  = SPCSIG(IS)                                               30.72
C
C       ****            ARGU   =  FPM / SIGMA                     ***
C       **** the value of ARGU was change for MIN () because for  ***
C       **** values of fpm/sigma too small could be some problems ***
C       **** with some computers to handle small numbers          ***
        ARGU   = MIN (2., FPM / SIGMA)                                    30.00
        FILTER = EXP ( - ARGU**4 )                                        20.87
        TEMP2  = TEMP1 / SIGMA
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          IF ( ANYWND(ID) .AND. SIGMA .GE. (0.7 * FPM) ) THEN
            THETA  = SPCDIR(ID,1)                                         30.82
            TEMP3  = ( UFRIC *  MAX( 0. , COS( THETA - THETAW )))**4
            SWINEA = MAX( 0. , TEMP2 * TEMP3 * FILTER )
            IMATRA(ID,IS) = IMATRA(ID,IS) + SWINEA
            IF(TESTFL) PLWNDA(ID,IS,IPTST) = SWINEA                       40.00
C
C           *** test output ***
C
            IF (ITEST .GE. 80 .AND. TESTFL )
     &      WRITE (PRTEST, 333) ID, IS, FILTER, SWINEA
 333        FORMAT (' ID IS FILTER  WIND SOURCE (IMATRA)',
     &               2I4, 1X, 2(1X,E11.4))
          END IF
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST.GE. 60.AND.TESTFL) THEN
        WRITE(PRINTF,400) KCGRD(1), THETAW*180./PI
 400    FORMAT(' SWIND0: POINT  THETAW       :',I5,E12.4)
        WRITE(PRINTF,500) TEMP1, FPM, UFRIC
 500    FORMAT(' SWIND0: TEMP1 FPM UFRC     :',3E12.4)
        WRITE(PRINTF,*)
        IF (ITEST.GE. 120.AND.TESTFL) THEN                                 24/MAR
          DO IS = 1, ISSTOP
            DO IDDUM = IDCMIN(IS), IDCMAX(IS)
              ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
              WRITE(PRINTF,100) IS,ID,ANYWND(ID)
 100          FORMAT(' IS ID ANYWND : ', 2I5,1X,L2)
            ENDDO
          ENDDO
        ENDIF
      END IF
C
      RETURN
C     end of subroutine SWIND0
      END
C
C****************************************************************
C
      SUBROUTINE SWIND3 (MDC     ,MSC     ,SPCSIG  ,THETAW  ,IMATDA  ,    30.72
     &                   PWIND   ,MWIND   ,KWAVE   ,IMATRA  ,PI      ,
     &                   IDCMIN  ,IDCMAX  ,AC2     ,ICMAX   ,UFRIC   ,
     &                   FPM     ,PLWNDB  ,ISSTOP  ,SPCDIR  ,ANYWND  ,
     &                   KCGRD   ,MCGRD                              )    30.21
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C
C  2. PURPOSE
C
C     Computation of the source term for the wind input for a
C     third generation wind growth model:
C
C     1)  Exponential input term, (Snyder et al. 1981, which
C         expression has been modified by Komen et al. 1984).
C
C         This input term should be comninated with the dissipation
C         term of Komen et al. (1984)
C
C  3. METHOD
C
C     The exponential term used is taken from Snyder et al. (1981)
C     and Komen et al. (1984):
C
C     Sin (s,d) =  B*E(s,d)
C        e                             *
C                                 28 U cos( d - dw )
C     B = max(0. , (0.25 rhoaw( -------------------  -1 ) )) sigma
C                                   sigma / kwave
C
C     with :
C
C        *                                                -3
C      U  =  UFRIC = wind10 sqrt( (0.8 + 0.065 wind10 ) 10  )
C
C     UFRIC is computed in WINDP2.
C
C
C     The Pierson Moskowitz radian frequency for a fully developed
C     sea state spectrum is as follows (computed in WINDP2 :
C
C             1       g
C     FPM  = ---- ---------  * 2 pi
C            2 pi  28 UFRIC
C
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C        FPM         Pierson Moskowitz frequecy (WAM)
C        THETA       Spectral direction
C        THETAW      Mean direction of the relative wind vector
C        UFRIC       Wind friction velocity
C
C        one and more dimensional arrays:
C        ---------------------------------
C        KWAVE     2D    Wavenumber
C        LOGSIG    1D    Logaritmic distribution of frequency
C        IMATRA    2D    Coefficients of right hand side of matrix
C        IMATDA    2D    Coefficients of diagonal of matrix
C        PWIND     1D    Wind coefficients
C        IDCMIN    1D    Frequency dependent counter
C        IDCMAX    1D    Frequency dependent counter
C        ANYWND    1D    Wind input for bin considered
C
C     5. SUBROUTINES CALLING
C
C        SOURCE
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every spectral bin that fall in teh sweep considered
C     compute the source term and store the results in IMATRA
C   --------------------------------------------------------------
C   End of the subroutine SWIND3
C   --------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER  IDDUM ,ID    ,MDC   ,MSC   ,ICMAX ,IS    ,MWIND ,
     &         ISSTOP,MCGRD
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     FPM   ,UFRIC ,THETA ,THETAW,SIGMA ,PI    ,SWINEB,TEMP1,
     &         TEMP2 ,TEMP3 ,CINV
C
      REAL    AC2(MDC,MSC,MCGRD)   ,
     &        IMATDA(MDC,MSC)      ,
     &        IMATRA(MDC,MSC)      ,
     &        KWAVE(MSC,ICMAX)     ,
     &        PWIND(MWIND)         ,
     &        PLWNDB(MDC,MSC,NPTST)                                       40.00
C
      INTEGER IDCMIN(MSC)          ,
     &        IDCMAX(MSC)
C
      LOGICAL  ANYWND(MDC)
C
C/T      LOGICAL  IMP_EXP
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWIND3')
C
      TEMP1 = 0.25 * PWIND(9)
      TEMP2 = 28.0 * UFRIC
      DO IS = 1, ISSTOP
        SIGMA = SPCSIG(IS)                                                30.72
        CINV  = KWAVE(IS,1) / SIGMA
        TEMP3 = TEMP2 * CINV
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          IF ( ANYWND(ID) ) THEN
            THETA  = SPCDIR(ID,1)                                         30.82
            SWINEB = TEMP1 * ( TEMP3 * COS(THETA-THETAW) - 1.0 )
            SWINEB = MAX ( 0. , SWINEB * SIGMA )
C
C/TC           *** an fully explicit computation is favourable ***
C/TC           *** when integrating the wind input source term ***
C/TC
C/T            IMP_EXP = .FALSE.
C/T            IF ( IMP_EXP) THEN
C/T              IMATDA(ID,IS) = IMATDA(ID,IS) - SWINEB
C/T              IMATRA(ID,IS) = IMATRA(ID,IS) + SWINEA
C/T            ELSE
C/T
            IMATRA(ID,IS) = IMATRA(ID,IS) + SWINEB * AC2(ID,IS,KCGRD(1))
            IF (TESTFL) PLWNDB(ID,IS,IPTST) = SWINEB                      40.00
C
C/T            END IF
C
          END IF
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST.GE. 80.AND.TESTFL) THEN                                   40.00
        WRITE(PRTEST,6000) KCGRD(1), THETAW*180./PI
 6000   FORMAT(' SWIND3: POINT  THETAW        :',I5,E12.4)
        WRITE(PRTEST,6100) TEMP1, FPM, UFRIC
 6100   FORMAT(' SWIND3: TEMP1 FPM UFRC     :',3E12.4, /,
     &         '  IS ID1 ID2       Wind source term')
        DO IS = 1, MSC
          WRITE(PRTEST,6200) IS, IDCMIN(IS), IDCMAX(IS),
     &    (PLWNDB(ID,IS,IPTST), ID=IDCMIN(IS), IDCMAX(IS))
 6200     FORMAT(3I4, 600e12.4)
        ENDDO
        WRITE(PRTEST,*)
      END IF
C
      RETURN
C     end of subroutine SWIND3
      END
C
C****************************************************************
C
      SUBROUTINE SWIND4 (MDC     ,MSC     ,ICMAX   ,IDWMIN  ,IDWMAX  ,
     &                   SPCSIG  ,WIND10  ,THETAW  ,PWIND   ,XIS     ,    30.72
     &                   MWIND   ,DD      ,KWAVE   ,GRAV    ,IMATRA  ,
     &                   PI      ,IDCMIN  ,IDCMAX  ,AC2     ,UFRIC   ,
     &                   PLWNDB  ,ISSTOP  ,ITER    ,USTAR   ,ZELEN   ,
     &                   SPCDIR  ,ANYWND  ,NSTATC  ,IT      ,PRECOR  ,    40.00
     &                   KCGRD   ,MCGRD                               )   40.02
C
C******************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     40.02, Oct. 00: References to CDRAGP and TAUWP removed
C
C  2. Purpose
C
C     Computation of the source term for the wind input for a
C     third generation wind growth model:
C
C     1)  Computation of the exponential input term based on a
C         quasi linear theory developped by Janssen (1989, 1991).
C         This formulation should be used in combination with the
C         whitecapping dissipation source term according to
C         Janssen (1991) and Mastenbroek et al. (1993)
C
C  3. Method
C
C     The exponential term for the wind input used is taken
C     from Janssen (1991):
C
C     Sin (s,d) =  B*E(s,d)
C        e
C                                        *
C                               / kwave U  \    2
C     B = max(0. , (beta rhoaw | --------- | cos( d - dw ) sigma))
C                               \ sigma   /
C
C     The friction velocity is a fucntion of the roughness
C     length Ze. A first gues for U* is given by Wu (1982),
C     which is computed in subroutine WINDP2.
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IDWMIN      Minimum counter for spectral wind direction
C        IDWMAX      Maximum counter for spectral wind direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C        DD          Directional band width
C        GRAV          Gravitatiuonal acceleration
C        SWINEO      Coefficient stored in IMATDA
C        THETA       Spectral direction
C        THETAW      Mean direction of the relative wind vector
C        WIND10      Velocity of the relative wind vector
C        UFRIC       Wind friction velocity
C
C        one and more dimensional arrays:
C        ---------------------------------
C        KWAVE     2D    Wavenumber
C        IMATRA    2D    Coefficients of right hand side of matrix
C        IMATDA    2D    Coefficients of diagonal of matrix
C        PWIND     1D    Wind coefficients
C        IDCMIN    1D    Frequency dependent counter
C        IDCMAX    1D    Frequency dependent counter
C        USTAR     2D    Friction velocity at previous iteration level
C        ZELEN     2D    Roughness length at previous iteration level
C        ANYWND    1D    Determine if wind input is active for bin
C
C        PWIND(9)  1D    Rho air / rho water
C        ------------
C        PWIND(14) 1D    alfa (which is tuned at 0.01)
C        PWIND(15) 1D    Kappa ( 0.41)
C        PWIND(16) 1D    Rho air
C        PWIND(17) 1D    Rho water
C
C
C     5. SUBROUTINES CALLING
C
C        SOURCE
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For
C   --------------------------------------------------------------
C   End of the subroutine SWIND4
C   --------------------------------------------------------------
C
C     10. SOURCE
C
C
C***********************************************************************
C
      INTEGER  IDWMAX  ,IDWMIN  ,IDDUM   ,ID      ,MDC     ,
     &         MSC     ,ISSTOP  ,ICMAX   ,IS      ,MWIND   ,
     &         MCGRD   ,NSTATC                                            40.00
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     GRAV   ,THETA  ,THETAW ,DD     ,SWINEB ,PI     ,WIND10 ,
     &         ZO     ,ZE     ,BETA1  ,BETA2  ,UFRIC  ,UFRIC2 ,DS     ,
     &         ZARG   ,ZLOG1  ,ZLOG2  ,ZCN1   ,ZCN2   ,ZCN    ,XIS    ,
     &         SIGMA  ,SIGMA1 ,SIGMA2 ,WAVEN  ,WAVEN1 ,WAVEN2 ,TAUW   ,
     &         TAUTOT ,TAUDIR ,COS1   ,COS2   ,CW1    ,RHOA   ,RHOW   ,
     &         RHOAW  ,ALPHA  ,XKAPPA ,F1     ,TAUWX  ,TAUWY  ,SE1    ,
     &         SE2    ,SINWAV ,COSWAV
C
      REAL    AC2(MDC,MSC,MCGRD)   ,                                      30.21
     &        IMATRA(MDC,MSC)      ,
     &        KWAVE(MSC,ICMAX)     ,
     &        PWIND(MWIND)         ,
     &        PLWNDB(MDC,MSC,NPTST),
     &        USTAR(MCGRD)         ,
     &        ZELEN(MCGRD)
C
      INTEGER IDCMIN(MSC)          ,
     &        IDCMAX(MSC)
C
      LOGICAL ANYWND(MDC), PRECOR                                         40.00
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWIND4')
C
C
C     *** initialization ***
C
      ALPHA  = PWIND(14)
      XKAPPA = PWIND(15)
      RHOA   = PWIND(16)
      RHOW   = PWIND(17)
      RHOAW  = RHOA / RHOW
      ZTEN   = 10.
      RATIO  = 0.75
      BETAMX = 1.2
      F1     = BETAMX / XKAPPA**2
C
C
      IF ( NSTATC.EQ.1 .AND. .NOT.PRECOR .AND. IT.EQ.1 ) THEN              40.00
C
C        *** nonstationary and no first guess and only and only      ***
C        *** for the first time step (the number of iterations       ***
C        *** however still can increase per time step (ITERSTA= 2,3) **
C
        ZO     = ALPHA * UFRIC * UFRIC / GRAV
        ZE     = ZO / SQRT( 1. - RATIO )
        USTAR(KCGRD(1)) = UFRIC                                           30.21
        ZELEN(KCGRD(1)) = ZE                                              30.21
*    WRITE(PRINTF,*) ' ENTERING 1'
      ELSE IF ( NSTATC.EQ.0 .AND. .NOT. PRECOR .AND. ITER .EQ. 1 ) THEN    40.00
 
C        *** stationary and no first guess and only and only  ***
C        *** for the first iteration ime step                 ***
C        *** This corresponds to ordinairy calculation without***
C        *** any first guess possibilities                    ***
C
        ZO     = ALPHA * UFRIC * UFRIC / GRAV
        ZE     = ZO / SQRT( 1. - RATIO )
        USTAR(KCGRD(1)) = UFRIC                                           30.21
        ZELEN(KCGRD(1)) = ZE                                              30.21
      ELSE IF ( NSTATC.EQ.0 .AND. PRECOR .AND. ITER .EQ. 2 ) THEN          40.00
C
C
C        *** stationary and a first guess (this subroutine is never ***
C        *** excecuted anyway, this subroutine in entered after 1   ***
C        *** iteration) and thus calculate ZO and ZE as a first     ***
C        *** prediction only and only in the second sweep           ***
C
        ZO     = ALPHA * UFRIC * UFRIC / GRAV
        ZE     = ZO / SQRT( 1. - RATIO )
        USTAR(KCGRD(1)) = UFRIC
        ZELEN(KCGRD(1)) = ZE
*    WRITE(PRINTF,*) ' ENTERING 3'
      ELSE
*    WRITE(PRINTF,*) ' ENTERING 4'
C--->
C       *** calculate wave stress using the value of the  ***
C       *** velocity U* and roughness length Ze from the  ***
C       *** previous iteration                            ***
C
        UFRIC = USTAR(KCGRD(1))
        ZE    = ZELEN(KCGRD(1))
C
        TAUW   = 0.
        TAUWX  = 0.
        TAUWY  = 0.
        TXHFR  = 0.
        TYHFR  = 0.
C
C       *** use old friction velocity to calculate wave stress ***
C
        UFRIC2 = UFRIC * UFRIC
C
        DO IS = 1, MSC-1
          SIGMA1 = SPCSIG(IS)                                             30.72
          SIGMA2 = SPCSIG(IS+1)                                           30.72
          WAVEN1 = KWAVE(IS,1)
          WAVEN2 = KWAVE(IS+1,1)
          DS     = SIGMA2 - SIGMA1
          CW1    = SIGMA1 / WAVEN1
          CW2    = SIGMA2 / WAVEN2
          ZCN1   = ALOG ( GRAV * ZE / CW1**2 )
          ZCN2   = ALOG ( GRAV * ZE / CW2**2 )
          DO IDDUM = IDWMIN, IDWMAX
            ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
            THETA  = SPCDIR(ID,1)                                         30.82
            SINWAV = SIN(THETA)
            COSWAV = COS(THETA)
            COS1   = MAX ( 0. , COS(THETA-THETAW) )
            COS2   = COS1 * COS1
            BETA1  = 0.
            BETA2  = 0.
C
C           *** Miles constant Beta ***
C
            IF ( COS1 .GT. 0.01 ) THEN
              ZARG1 = XKAPPA * CW1 / ( UFRIC * COS1 )
              ZARG2 = XKAPPA * CW2 / ( UFRIC * COS1 )
              ZLOG1 = ZCN1 + ZARG1
              ZLOG2 = ZCN2 + ZARG2
              IF ( ZLOG1 .LT. 0. ) BETA1 = F1 * EXP (ZLOG1) * ZLOG1**4
              IF ( ZLOG2 .LT. 0. ) BETA2 = F1 * EXP (ZLOG2) * ZLOG2**4
            ENDIF
C
C           *** calculate wave stress by integrating input source ***
C           *** term in x- and y direction respectively           ***
C
            SE1 = WAVEN1**2 * BETA1 * SIGMA1 * AC2(ID,IS  ,KCGRD(1))
            SE2 = WAVEN2**2 * BETA2 * SIGMA2 * AC2(ID,IS+1,KCGRD(1))
C
            TAUWX = TAUWX + 0.5 * ( SE1 + SE2 ) * DS * COSWAV * COS2
            TAUWY = TAUWY + 0.5 * ( SE1 + SE2 ) * DS * SINWAV * COS2
C
C           *** test output ***
C
            IF (ITEST.GE. 40 .AND. TESTFL) THEN
              WRITE(PRINTF,105) IS, ID, UFRIC, ZE
  105         FORMAT(' SW4: IS ID UFRIC ZE     :',2I4,2E12.4)
              WRITE(PRINTF,106) ZLOG1, ZLOG2, BETA1, BETA2
  106         FORMAT(' SW4: ZOLG1-2 BETA1 BETA2:',4E12.4)
              IF (ABS(TAUWX).GT.0. .OR. ABS(TAUWY).GT.0.) THEN            NRL
                TAUDIR = ATAN2 ( TAUWX, TAUWY )                           NRL
              ELSE                                                        NRL
                TAUDIR = 0.                                               NRL
              ENDIF                                                       NRL
              TAUDIR = MOD ( (TAUDIR + 2. * PI) , (2. * PI) )             NRL
              WRITE(PRINTF,107) TAUWX, TAUWY, TAUDIR*180./PI
  107         FORMAT(' SW4: TAUWX TAUWY TAUDIR :',3E12.4)
            ENDIF
C
          ENDDO
        ENDDO
C
C       *** determine effect of high frequency tail to wave stress ***
C       *** assuming deep water conditions                         ***
C
        GAMHF =  XKAPPA * GRAV / UFRIC
        SIGMAX = SPCSIG(MSC)                                              30.72
        SIGHF1 = SIGMAX
        DO J=1, 50
          SIGHF2 = XIS * SIGHF1
          DS     = SIGHF2 - SIGHF1
          ZCNHF1 = ALOG ( ZE * SIGHF1**2 / GRAV )
          ZCNHF2 = ALOG ( ZE * SIGHF2**2 / GRAV )
          AUX    = 0.0
          DO IDDUM = IDWMIN, IDWMAX
            ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
            THETA  = SPCDIR(ID,1)                                         30.82
            SINWAV = SIN(THETA)
            COSWAV = COS(THETA)
            COS1   = MAX ( 0. , COS(THETA-THETAW) )
            COS2   = COS1 * COS1
            BETA1  = 0.0
            BETA2  = 0.0
C
            IF ( COS1 .GT. 0.01 ) THEN
C             *** beta is independent of direction ! ***
              ZAHF1 = GAMHF / SIGHF1
              ZAHF2 = GAMHF / SIGHF2
              ZLOG1 = ZCNHF1 + ZAHF1
              ZLOG2 = ZCNHF2 + ZAHF2
              IF ( ZLOG1 .LT. 0. ) BETA1 = F1 * EXP (ZLOG1) * ZLOG1**4
              IF ( ZLOG2 .LT. 0. ) BETA2 = F1 * EXP (ZLOG2) * ZLOG2**4
              AUX = AUX + BETA1 + BETA2
            ENDIF
C
C           *** calculate contribution of high frequency tail to ***
C           *** wave stress by integrating input source term in  ***
C           *** x- and y direction respectively                  ***
C
            FACHFR = SIGMAX**6 * AC2(ID,MSC,KCGRD(1)) * COS2 / GRAV**2    30.21
 
            SE1 = FACHFR * BETA1 / SIGHF1
            SE2 = FACHFR * BETA2 / SIGHF2
C
            TXHFR = TXHFR + 0.5 * ( SE1 + SE2 ) * DS * COSWAV
            TYHFR = TYHFR + 0.5 * ( SE1 + SE2 ) * DS * SINWAV
C
C           *** if coeffcient BETA = 0. for a frequency over ***
C           *** all directions is zero skip loop             ***
C
            IF ( AUX .EQ. 0. ) GOTO 5000
C
          ENDDO
C
          IF (ITEST.GE. 45 ) THEN
            WRITE(PRINTF,407) XIS, SIGHF1, SIGHF2, J
  407       FORMAT(' SW4: XIS SIGHF1 SIGHF2 J :',3E12.4,I4)
            WRITE(PRINTF,437) TXHFR, TYHFR, BETA1, BETA2
  437       FORMAT(' SW4: TXHFR TYHFR BETA1,2 :',4E12.4)
          ENDIF
C
          SIGHF1 = SIGHF2
        ENDDO
 5000   CONTINUE
C
        IF ( ITEST .GE. 45 ) THEN
          WRITE(PRINTF,321) TAUWX, TAUWY, TXHFR, TYHFR
 321      FORMAT(' SW4: Twx Twy Thfx Thfy:',4E12.4)
        ENDIF
C
        TAUTOT = RHOA * UFRIC2
C       *** wave stress ***
        TAUWX  = TAUWX + TXHFR
        TAUWY  = TAUWY + TYHFR
        IF (ABS(TAUWX).GT.0. .OR. ABS(TAUWY).GT.0.) THEN
          TAUDIR = ATAN2 ( TAUWX, TAUWY )
        ELSE
          TAUDIR = 0.
        ENDIF
        TAUDIR = MOD ( (TAUDIR + 2. * PI) , (2. * PI) )
        TAUW   = RHOA * UFRIC2 * DD * SQRT ( TAUWX**2 + TAUWY**2 )
        TAUW   = MIN ( TAUW , 0.999 * TAUTOT )
C
        IF ( ITEST .GE. 45 ) THEN
          RATIO = TAUW / TAUTOT
          WRITE(PRINTF,301) TAUW, TAUTOT, RATIO, KCGRD(1)                 30.21
 301      FORMAT(' SW4: Tauw Taut  ratio :',3E12.4,' in ',I5)
        ENDIF
C
        DO II = 1, 20
C         *** start iteration process ***
          FA = SQRT ( 1. - TAUW / TAUTOT )
          FB = ZTEN * RHOA * GRAV / ALPHA
          FC = FA * ( FB / TAUTOT  - 1. )
          FD = SQRT ( TAUTOT )
          FE = ALOG ( FC + 1. )
C
C         *** calculate function value and derivative in ***
C         *** numerical point considered                 ***
C
          FCEN = FD * FE - SQRT(RHOA) * WIND10 * XKAPPA
          FF1  = 0.5 * FE / FD
          FF2  = 0.5 * TAUW * FC / FA**2 - FA * FB
          FF3  = TAUTOT**1.5 * ( FC + 1. )
          DCEN = FF1 + FF2 / FF3
C
C         *** new total stress ***
C
          TAUNEW = TAUTOT - FCEN / DCEN
C
          IF ( ITEST .GT. 30 .AND. TESTFL ) THEN
            WRITE(PRINTF,440) TAUTOT, TAUNEW, FCEN, DCEN, II
 440        FORMAT(' SW4: Tt Tnew Fcn DFcn II:',4E12.4,I2)
            WRITE(PRINTF,450) FA, FB, FC, FD
 450        FORMAT(' SW4: FA FB FC FD        :',4E12.4)
            WRITE(PRINTF,460) FE, FF1, FF2, FF3
 460        FORMAT(' SW4: FE FF1 FF2 FF3     :',4E12.4)
          ENDIF
C
          IF ( TAUNEW .LE. TAUW ) TAUNEW = .5 * (TAUTOT + TAUW)           20.81
          IF ( ABS ( TAUNEW - TAUTOT ) .LE. 1.E-5 ) GOTO 3000
C
          TAUTOT = TAUNEW
        ENDDO
 3000   CONTINUE
C
        UFRIC  = SQRT ( TAUTOT / RHOA )
C
        IF ( ITEST .GE. 20 .AND. TESTFL ) THEN
          WRITE(PRINTF,200) KCGRD(1)
 200      FORMAT(' SW4: Values after Newton-Raphson in point:',I5)
          WRITE(PRINTF,206) TAUW, TAUTOT, TAUW/TAUTOT, UFRIC
 206      FORMAT(' SW4: Tauw Taut rat Us :',4E12.4)
          WRITE(PRINTF,*)
        ENDIF
C
        ZO     = ALPHA * UFRIC * UFRIC / GRAV
        ZE     = ZO / SQRT ( 1. - TAUW / TAUTOT )
C
        USTAR(KCGRD(1)) = UFRIC
        ZELEN(KCGRD(1)) = ZE
C
      ENDIF
C
C ----->
C
C     *** calculate critical height and Miles parameter and  ***
C     *** calculate input source term B for with the updated ***
C     *** values of UFRIC and ZE                             ***
C
      UFRIC2 = UFRIC * UFRIC
C
      DO IS = 1, ISSTOP
        SIGMA  = SPCSIG(IS)                                               30.72
        WAVEN  = KWAVE(IS,1)
        CW1    = SIGMA / WAVEN
        ZCN    = ALOG ( GRAV * ZE / CW1**2 )
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          IF ( ANYWND(ID) )  THEN
            THETA  = SPCDIR(ID,1)                                         30.82
            COS1   = MAX ( 0. , COS(THETA-THETAW) )
            COS2   = COS1 * COS1
            XFAC2  = ( UFRIC / CW1 )**2
            BETA   = 0.
            IF ( COS1 .GT. 0.01 ) THEN
              ZARG = XKAPPA * CW1 / ( UFRIC * COS1 )
              ZLOG = ZCN + ZARG
              IF ( ZLOG .LT. 0. ) BETA = F1 * EXP (ZLOG) * ZLOG**4
            ENDIF
C
C           *** compute the factor B and store result in array ***
C
            SWINEB = RHOAW * BETA * XFAC2 * COS2 * SIGMA
            IMATRA(ID,IS) = IMATRA(ID,IS) + SWINEB * AC2(ID,IS,KCGRD(1))  30.21
            IF (TESTFL) PLWNDB(ID,IS,IPTST) = SWINEB                      40.00
C
C           *** test output ***
C
            IF (ITEST.GE. 30 .AND. TESTFL) THEN
              WRITE(PRINTF,101) ZARG,ZLOG,ID,IS
  101         FORMAT(' SW4: ZARG ZLOG ID IS  :',2E12.4,' in',2I3)
              WRITE(PRINTF,102) COS1, COS2, XFAC2, BETA
  102         FORMAT(' SW4: COS1/2 XFAC BETA :',4E12.4)
            ENDIF
 
          ENDIF
        ENDDO
C
       IF (ITEST.GE. 20 .AND. TESTFL) THEN
          WRITE(PRINTF,1102)  SIGMA, WAVEN, CW1, ZCN
 1102     FORMAT(' SW4: SIG WAV CW1 ZCN :',4E12.4)
        ENDIF
      ENDDO
C
C     *** test output ***
C
      IF (ITEST.GE. 20.AND.TESTFL) THEN
        WRITE(PRINTF,9001) KCGRD(1), IDWMIN, IDWMAX
 9001   FORMAT(' SW4: POINT IDWMIN IDWMAX :',3I5)
        WRITE(PRINTF,6053) WIND10,UFRIC,THETAW*180./PI
 6053   FORMAT(' SW4: WIND10 UFRIC THETAW :',3E12.4)
        WRITE(PRINTF,7136) PWIND(9), PWIND(16), PWIND(17)
 7136   FORMAT(' SW4: RHOAW  RHOA  RHOW   :',3E12.4)
        WRITE(PRINTF,7126) PWIND(14), PWIND(15), ZTEN
 7126   FORMAT(' SW4: ALPHA XKAPPA ZTEN   :',3E12.4)
 
      END IF
C
      RETURN
C     end of subroutine SWIND4
      END
C
C****************************************************************
C
      SUBROUTINE SWIND5 (MDC     ,MSC     ,SPCSIG  ,THETAW  ,ISSTOP  ,    30.72
     &                   UFRIC   ,KWAVE   ,IMATRA  ,PI      ,IDCMIN  ,
     &                   IDCMAX  ,AC2     ,ICMAX   ,ANYWND  ,PLWNDB  ,
     &                   SPCDIR  ,KCGRD   ,MCGRD                     )    30.21
C
C****************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C
C 2. Purpose
C
C     Computation of the source term for the wind input for a
C     third generation wind growth model:
C
C     The exponential input term is according to Yan (1987). This
C     input term is valid for the higher frequency part of the
C     spectrum (strongly forced wave components). The expression
C     reduces to teh Snyder 91982) expression form for spectral
C     wave components with weak wind forcing and to the Plant (1982)
C     form for more strongly froced wave components:
C
C  3. Method
C
C     The expression reads -->   with  X = Ustar / C
C
C            / /      2                      \
C     Sin = | | 0.04 X + 0.00544 X + 0.000055 | * cos (theta)
C            \ \                             /
C                       \
C              - 0.00031 | sigma * AC2(d,s,x,y)
C                       /
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C        FPM         Pierson Moskowitz frequecy (WAM)
C        THETA       Spectral direction
C        THETAW      Mean direction of the relative wind vector
C        UFRIC       Wind friction velocity
C
C        one and more dimensional arrays:
C        ---------------------------------
C        KWAVE     2D    Wavenumber
C        IMATRA    2D    Coefficients of right hand side of matrix
C        IMATDA    2D    Coefficients of diagonal of matrix
C        IDCMIN    1D    Frequency dependent counter
C        IDCMAX    1D    Frequency dependent counter
C        ANYWND    1D    Wind input for bin considered
C
C     5. SUBROUTINES CALLING
C
C        SOURCE
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   For every spectral bin that fall within a sweep considered
C     compute the source term and store the results in IMATRA
C   --------------------------------------------------------------
C   End of the subroutine SWIND5
C   --------------------------------------------------------------
C
C     10. SOURCE
C
C***********************************************************************
C
      INTEGER  IDDUM  ,ID     ,MDC    ,MSC    ,ICMAX  ,IS     ,
     &         ISSTOP ,MCGRD                                              30.21
C
      INTEGER  KCGRD(ICMAX)                                               30.21
C
      REAL     UFRIC  ,THETA  ,THETAW ,SIGMA  ,PI     ,SWINEB ,
     &         USTAC1 ,USTAC2 ,COF1   ,COF2   ,COF3   ,COF4
C
      REAL    AC2(MDC,MSC,MCGRD)   ,
     &        IMATRA(MDC,MSC)      ,
     &        KWAVE(MSC,ICMAX)     ,
     &        PLWNDB(MDC,MSC,NPTST)
C
      INTEGER IDCMIN(MSC)          ,
     &        IDCMAX(MSC)
C
      LOGICAL  ANYWND(MDC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWIND5')
C
C     *** input accodring to Yan (1987) ***
C
      COF1 = 0.04
      COF2 = 0.00544
      COF3 = 0.000055
      COF4 = 0.00031
      DO IS = 1, ISSTOP
        SIGMA  = SPCSIG(IS)
        USTAC1 = ( UFRIC * KWAVE(IS,1) ) / SIGMA
        USTAC2 = USTAC1 * USTAC1
        TEMP3  = ( COF1 * USTAC2 + COF2 * USTAC1 + COF3)
        DO IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC, MDC ) + 1
          IF ( ANYWND(ID) ) THEN
            THETA  = SPCDIR(ID,1)                                         30.82
            SWINEB = TEMP3 * COS(THETA-THETAW) - COF4
            SWINEB = MAX ( 0. , SWINEB * SIGMA )
            IMATRA(ID,IS) = IMATRA(ID,IS) + SWINEB * AC2(ID,IS,KCGRD(1))
            IF (TESTFL) PLWNDB(ID,IS,IPTST) = SWINEB                      40.00
          END IF
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST.GE. 60.AND.TESTFL) THEN
        WRITE(PRINTF,6000) KCGRD(1), THETAW*180./PI, UFRIC
 6000   FORMAT(' SWIND5: POINT THETAW UFRIC  :',I5,2E12.4)
        WRITE(PRINTF,6100) COF1, COF2, COF3, COF4
 6100   FORMAT(' SWIND5: COF1 COF2 COF3 COF4 :',4E12.4)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     end of subroutine SWIND5
      END
C
