!NRL: $Id: swancomi.F,v 1.1.1.2 2003/03/28 15:35:33 dykes Stab $
!NRL: $Name:  $
C     Last change:  YGH  15 Sep 2000    1:41 pm
C
C     SWAN/COMPU   file 6 of 6
C
C     PROGRAM SWANCOMI.FOR
C
C     This file SWANCOMI of the main program SWAN
C     include the subroutines for solving the band matrix.
C
C     Subroutines in this file are:
C
C     CGSTAB   Solve an unsymmetric system of linear equations
C              by the Bi-CGSTAB method. The subroutine contains
C              a number of preconditioners.
C     DAXPY    ?
C     DCOPY    ?
C     DIAG     Makes a diagonal scaling of the matrix in case of
C              a momentum equations, a transport equation, or a
C              pressure equation.
C     DIAGMU   Multiplication of x with the diagonal matrix given in
C              prec. The array prec sould be filled by subroutine
C              diag.f
C     DINVL3   Multiplication of x by L, the preconditioning matrix
C              given in prec.
C     DINVU3   Multiplication of x by U, the preconditioning matrix
C              given in prec.
C     DMLU3    Calculates an upper triangular matrix U and a lower
C              triangular matrix L, which form an incomplete
C              decomposition of A.
C     DRUMA1   determine the right Hand vector b
C     ISSOLV   The subroutine issolv is used to solve an unsymmetric
C              system of equations of the shape A x = f.
C     MKPREC   The subroutine mkprec is used to build a preconditioner.
C     PREVC    Prevc multiplies the vector x with a preconditioner.
C     PRIRES   This is an output subroutine. It prints the norm of
C              the residual
C     SWCOVA2D Compute covariant base vectors in integration points       31.03
C              two-dimensional case                                       31.03
C     SWDISDT2 Distribute diffusion term for tranport equation in R2      31.03
C     SWESSBC  Puts essential boundary conditions in matrix               31.03
C     SWJCTA2D Compute sqrt(g) x contra variant base vectors in           31.03
C              integration point two-dimensional case                     31.03
C     SWTRAD2D Compute contribution of diffusion term in R2 for a         31.03
C              transport equation per integration point                   31.03
C              Compute righthandside                                      31.03
C     SWSOLV   Prepare for ISSOLV                                         31.03
C     VULMAT   Academic test for solver
C     VULMT1   Fills matrix with coefficents of SWAN
C
C
C*******************************************************************
C
      subroutine CGSTAB(n,amat,rhsd,usol,eps1,eps2,itmax,
     1               res,p,rbar,t,s,v,work,icontr,
     2               infmat ,prec, nprec, ndim, nconct,
     3               upperi, loperi, NSTATC, ITSW, ITERSW)                30.72
C
C********************************************************************
c
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C      1.0 : Kees Vuik
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
!     40.14: Annette Kieftenburg
C
C  1. Updates
C
C      1.0 , Mar. 94: New subroutine
C     30.72, Feb. 98: Forced at least one iteration of the CGSTAB solver
C     30.82, Sep. 98: Work with double precision to avoid underflows
C     30.82, Jul. 99: Set OMEGA to 1.0 in case of division by 0.
C     40.02, Sep. 00: Modified function DDOT
!     40.14, Mar. 01: Code adjusted to avoid no convergence problem
!                   : (by Kees Vuik)
C
C  4. Argument variables
C
C     ITERSW: input  Iteration counter for SWAN
C     ITSW  : input  Time step counter for SWAN
C     NSTATC: input  Indicates stationarity:
C                    =0; stationary computation
C                    =1; nonstationary computation
C
      INTEGER ITERSW, ITSW, NSTATC
C
c ******************************************************************
c
c                       DESCRIPTION
c
c     Solve an unsymmetric system of linear equations by the Bi-CGSTAB
c     method. The subroutine contains a number of preconditioners.
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     preconditioning
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c
c     amat    i   Matrix from the equations to be solved.
c
c     eps1    i   Determine the accuracy of the final approximation. The
c     eps2    i   termination criterion is based upon
c                    ||b-Ax || <  eps1 + eps2 * (b-Ax ) .
c                          k                         0
c
c     icontr i/o  Integer array in which information about the solution
c                 process must be given by the user. On output information
c                 about the solution process is provided. ICONTR must be
c                 filled as follows:
c
c             1 i Parameter controlling the preconditioning. Possible
c                 values are:
c                  0: No preconditioning.
c                  1: Diagonal preconditioner.
c                 -1: Diagonal postconditioner.
c                  2: ILUD preconditioner, with Eisenstat implemen-
c                     tation.
c                 -2: ILUD postconditioner.
c                  3: ILU preconditioner.
c                 -3: ILU postconditioner.
c
c             2 i Control parameter indicating the amount of output
c                 required. Possible values:
c                 <0: No output.
c                  1: Only fatal errors will be printed.
c                  2: Additional information about the iteration is printed.
c                  3: Gives a maximal amount of output concerning the
c                     iteration process.
c
c             3 o At output an error indication is stored. Possible values:
c                 0: No fatal errors.
c                 3: The number of iterations exceeds itmax.
c                 4: Rnorm is less than roundoff error
c
c             4 o Contains at output the actual number of iterations
c                 performed.
c
c             5 i Parameter indicating the file number to which output
c                  should be written.
c
c             6 i Parameter controlling the size of the Krylov-subspaces,
c                 thus determining the restarts of the iteration process.
c                 Only used by GMRES like methods.
c                 Possible values are:
c                 0: Restarts after at most 200 iterations are determined
c                    by the subroutine itself.
c                 1..200: The iterations restart after ICONTR(6) iterations,
c                    with the latest iterate as new starting vector.
c
c
c     infmat  i   Integer array with information of the matrix structure,
c                 to be used in matrix-vector multiplication subroutine.
c
c     itmax   i   The maximum number of iterations to be performed.
c
c     n       i   The number of rows in the matrix A.
c
c     nconct  i   Maximal number of connections in one row of the matrix.
c
c     ndim    i   Integer indicating the amount of unknowns in every grid-
c                 point. In the momentum equations ndim = 2 or 3, whereas
c                 in the pressure and transport equations ndim = 1.
c
c     nprec   i   Number of diagonals which are used in the precond-
c                 itioning.
c
c     p           Work array to store the direction vector.
c
c     prec    i   Array which contains part of the preconditioning matrix
c
c     rbar        Work array to store the quasi-residual vector.
c
c     res     o   Array containing the residual vector.
c
c     rhsd    i   Vector containing the right-hand side vector of the
c                 system of equations.
c
c     s           Work array to store an auxiliary vector.
c
c     t           Work array to store an auxiliary vector.
c
c     usol   i/o  Solution vector of length n. On input the array should
c                 contain a starting vector. At output the array contains
c                 the last iterate, which is an approximation to the
c                 solution of the system.
c
c     v           Work array to store an auxiliary vector.
c
c     work        Work array to store an auxiliary vector. The array
c                 work(.,3) contains the update of the solution usol
c                 during an iteration. If postconditioning is used,
c                 it is first adapted before it is added to usol.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     alpha    Factor alpha in the CGSTAB-process { (rbar,r ) / (rbar,Ap) }.
c                                                          i
c     beta     Factor beta in the CGSTAB-process { ((rbar,r ) / (rbar,r   ))*
c              (alpha/omega) }.
c
c     eps      Required accuracy (including relative and absolute error).
c
c     isqrn    The largest integer smaller than sqrt(n).
c
c     istar    Starting number for iteration
c
c     iter     The current iteration number.
c
c     j        Counting variable.
c                                                       i
c     omega    Factor omega in the CGSTAB-process { (t,s) / (t,t) }.
c
c     rferr    Maximal accuracy possible for this matrix, due to round-off.
c
c     rho      Inner product of M  r and rbar at the previous iteration step
c              (where M stands for the preconditioning matrix).
c
c     rhosta   Rho at the new iteration step.
c
c     rnorm    Norm of the residual vector.
c
c     sigma    Factor sigma in the CGSTAB-process (inner product of rbar
c              and Ap).
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c     daxpy    Computes a vector + a constant * other vector. This
c              is a BLAS routine.
c
c     dcopy    Copy a vector to another vector. This is a BLAS
c              routine.
c
c     ddot     Computes an inner product. This is a BLAS routine.
c
c     dinvl    Computes the multiplication of the inverse of a lower
c              triangular matrix, stored in arrays prec and amat,
c              and a vector.
c
c     dinvu    Computes the multiplication of the inverse of a upper
c              triangular matrix, stored in arrays prec and amat,
c              and a vector.
c
c
c     dnrm2    Calculates the 2-norm of a given vector. This is
c              a BLAS routine.
c
c     mtvc1    Computes the product of the sparse matrix, stored in AMAT,
c              and a vector.
c
c     prevc    Computes the product of the preconditioner, stored in
c              amat and prec.
c
c     prires   Provides information about the solution process; the amount
c              of output is determined by the value of ICONTR(5).
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     The subroutine Bi-CGSTAB is used to solve an unsymmetric system
c     of linear equations of the shape A.x = f. To obtain a solution
c     either the Bi-CGSTAB method is used, or the preconditioned
c     Bi-CGSTAB method, possibly combined with the Eisenstat implementation.
c
c     Input:
c
c     The elements ICONTR(1:2), ICONTR(5), EPS1, EPS2, ITMAX must have got
c     a value, and the arrays AMAT, RHSD, USOL and in case of preconditioning
c     PREMAT must have been filled by the calling program.
c
c     Output:
c
c     The elements ICONTR(3:4) contain information about the iteration
c     process, the calculated solution vector is stored in USOL, and the
c     corresponding residual vector in RES.
c
c     References:
c
c     H.A. van der Vorst,
c     Bi-CGSTAB: A fast and smoothly converging variant of Bi-CG for the
c     solution of nonsymmetric linear systems,
c     SIAM J. Sci. Stat. Comp., 13, (1992), pp. 631-644.
c
c ==================================================================
c
c     Parameters:
C
      integer          n,itmax,icontr(9), infmat(*),
     1                 nprec, ndim, nconct
      REAL  amat(n,*),rhsd(n),usol(n),eps1,eps2,
     1                 res(n),p(n),rbar(n),t(n),s(n),v(n),
     2                 prec(n,*),work(n,*), upperi(*), loperi(*)
c
c     Local parameters
c
      integer j,isqrn,iter,istar
C
      DOUBLE PRECISION ALPHA, BETA, BNORM, DDOT, DNRM2, EPS, OMEGA        30.82
      DOUBLE PRECISION RFERR, RHO, RHOSTA, RNORM, SIGMA                   30.82
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'cgstab')
c
c **  Set some constants.
c
c      on real underflow ignore
c
      bnorm = dnrm2(n,rhsd,1)
c
      icontr(4) = 0
      rferr = DBLE(n)                                                     30.82
      rferr = sqrt ( rferr )
      isqrn  = nint( rferr )
      rferr  = 0.0
      rho = 1.0
      istar = 1
      beta = 0.0
      alpha = 1.0
      omega = 1.0
c
c     if icontr(1) equals 2 then the linear system is scaled by a diagonal
c     matrix, such that diag(L)=diag(U)=D=I.
c
      if(icontr(1).eq.2) then
         do j = 1, n
            rhsd(j) = rhsd(j)*prec(j,1)
         enddo
      endif
      if(abs(icontr(1)).ge.2) then
           rnorm = dnrm2(n,rhsd,1)*1D-34                                  30.82
           if(rnorm.gt.0.) then
             do j = 1, n
                usol(j) = REAL(DBLE(usol(j)) + rnorm)                     30.82
             enddo
           endif
      endif
C
c     the update solution is set equal to zero
c
      do j = 1, n
         work(j,3) = 0.0
      enddo
c
c **  Compute initial residual vector, quasi-residual vector
c **  and required accuracy.
c
100   continue
      call dcopy(n,work(1,3),1,work(1,2),1)
      if(icontr(1).lt.0) then
         call prevc(n,work(1,2),work(1,3),amat,ndim,
     1              nconct,prec,nprec,infmat,icontr(1))
      endif
C
c     solution usol is adapted
c
      call daxpy(n,1.0, work(1,3),1,usol,1)
c
c     the update solution is set equal to zero
c
      do j = 1, n
         work(j,3) = 0.0
      enddo
c
c     calculation of residual
c
      call druma1( usol, t, amat, n, nconct, infmat,
     1             upperi, loperi)
      do j = 1,n
         work(j,1) = rhsd(j) - t(j)
      enddo
      if(icontr(1).eq.2) then
c         call dinvl(work,res,amat,n/ndim,ndim,
c     1              nconct,prec,nprec,infmat)
      else
         if(icontr(1).gt.0) then
            call prevc(n,work,res,amat,ndim,nconct,
     1                 prec,nprec,infmat,icontr(1))
         else
            call dcopy(n,work,1,res,1)
         endif
      endif
c
c     calculation of rbar
c
      call dcopy(n,res,1,rbar,1)
      rnorm = dnrm2(n,res,1)
      if (istar.eq.1) then
         eps = DBLE(eps1) + rnorm * DBLE(eps2) + bnorm * DBLE(eps2)       30.82
      endif
C
C Make sure that at least one iteration is performed unless rnorm = 0     30.72
C
      if(rnorm .le. eps) then
        IF (NSTATC.GT.0) THEN                                             30.72
C
C Dynamic mode:                                                           30.72
C
C If in the first time-step and first iteration and first cgstab-         30.72
C iteration, then skip the goto 500 statement and perform an iteration    30.72
C
          IF ((ITSW.GT.1).OR.(ITERSW.GT.1).OR.(ICONTR(4).GT.0)) THEN      30.72
            icontr(3)=0
            goto 500
          END IF                                                          30.72
        ELSE                                                              30.72
C
C Stationary mode:                                                        30.72
C
C If in the first iteration and first cgstab-iteration, then skip the     30.72
C goto 500 statement and perform an iteration                             30.72
C
          IF ((ITERSW.GT.1).OR.(ICONTR(4).GT.0)) THEN                     30.72
            icontr(3)=0
            goto 500
          END IF                                                          30.72
        END IF                                                            30.72
        IF (REAL(RNORM).EQ.0.) GOTO 500                                   30.72
      endif
C
      IF ( TESTFL .AND. ITEST .GT. 75 ) THEN
        WRITE(PRTEST,*)
        WRITE(PRTEST,*)
        WRITE(PRTEST,*) ' values before entering iteration loop'
        WRITE(PRTEST,7050) ITER, ISTAR, ITMAX
 7050   FORMAT(' ++1 : ITER ISTAR ITMAX     :',3I5)
        WRITE(PRTEST,7060) RNORM, RFERR                                   30.82
 7060   FORMAT(' ++1 : RNORM RFERR          :',2D12.5)                    30.82
        WRITE(PRTEST,7070) EPS, EPS1, EPS2                                30.82
 7070   FORMAT(' ++1 : EPS, EPS1, EPS2      :',1D12.5, 2E12.5)            30.82
       ENDIF
C
c **  Iteration loop.
c
      do iter = istar,itmax
c
c **     Check for convergence.
c
         if (rnorm .le. eps) then
*           IF ( ITEST .GT. 25 ) WRITE(PRTEST,*) ' rnorm le eps'           30.50
C
C Make sure that at least one iteration is performed                      30.72
C
           IF (NSTATC.GT.0) THEN                                          30.72
C
C Dynamic mode:                                                           30.72
C
C If in the first time-step and first iteration and first cgstab-         30.72
C iteration, then skip the goto 100 statement and perform an iteration    30.72
C
             IF ((ITSW.GT.1).OR.(ITERSW.GT.1).OR.(ICONTR(4).GT.0)) THEN   30.72
               istar = iter
               goto 100
             END IF                                                       30.72
           ELSE                                                           30.72
C
C Stationary mode:                                                        30.72
C
C If in the first iteration and first cgstab-iteration, then skip the     30.72
C goto 100 statement and perform an iteration                             30.72
C
             IF ((ITERSW.GT.1).OR.(ICONTR(4).GT.0)) THEN                  30.72
               istar = iter
               goto 100
             END IF                                                       30.72
           ENDIF                                                          30.72
         end if
c
c **     Check for maximal accuracy possible due to round-off errors.
c **     If rho is smaller, then continuation is useless.
c
         if (rnorm .lt. rferr) then
            icontr(3)=4
            IF (TESTFL .AND. ITEST .GT. 75) WRITE(PRTEST,7075)
     &      ' ++2 : rnorm=', RNORM, ' < rferr=', RFERR                    30.50
7075        FORMAT(2D12.5)                                                30.82
            goto 400                                                      40.14
         end if
C
c **     Print intermediate results and set iteration level.
c
         call prires(' ISCGSTAB ',rnorm,icontr,.false.)
         icontr(4) = iter
c
c **     Compute rhosta
c
         call dcopy(n,res,1,s,1)
         RHOSTA = DDOT(RBAR, S, N)                                        40.02
c
         if ( abs(rhosta).lt. 1.D-30*abs(rho) .and.                       30.82
     &        iter .gt. 1 ) then
c         *  rhostar too small, restart process
            istar = iter
C
*           CALL MSGERR(3,' ERROR: rhostar too small ')          removed  30.50
            IF ( ITEST .GT. 75 .AND. TESTFL) THEN                         30.82
             WRITE(PRTEST,*) ' rhostar too small'                         30.82
             WRITE(PRTEST,7080) RHOSTA, RHO, BETA, ISTAR                  30.82
7080         FORMAT(' ++3 : RHOSTA RHO BETA ISTAR:',3D12.5,I4)            30.82
            ENDIF                                                         30.82
c
            go to 100
         end if
C
c **     Compute the direction vector p.
c
         if (iter .eq. 1) then
            call dcopy(n,s,1,p,1)
         else
            beta = (rhosta / rho) * (alpha/omega)
            do j = 1,n
               p(j) = REAL(DBLE(res(j)) +
     &                     beta * (DBLE(p(j)) - omega * DBLE(v(j))))      30.82
            enddo
         endif
c
         rho = rhosta
C
        IF ( TESTFL .AND. ITEST .GT. 75 ) THEN                            30.82
          WRITE(PRTEST,7090) RHOSTA, RHO, BETA, ITER                      30.82
7090      FORMAT(' ++4 : RHOSTA RHO BETA ITER:',3D12.5,2I4)               30.82
        ENDIF                                                             30.82
c
c **     Compute (preconditioned) Ap, store in v.
c
         if(icontr(1).gt.0) then
           call druma1( p, work, amat, n, nconct, infmat,
     1             upperi, loperi)
           call prevc(n,work,v,amat,ndim,nconct,
     1                prec,nprec,infmat,icontr(1))
         else
           call prevc(n,p,work,amat,ndim,nconct,
     1                prec,nprec,infmat,icontr(1))
           call druma1( work, v, amat, n, nconct, infmat,
     1             upperi, loperi)
         endif
c
c **     Compute sigma and terminate if less than zero.
c
         SIGMA = DDOT(RBAR, V, N)                                         40.02
         if (sigma .eq. 0.0) then
            icontr(3)=2
           IF ( ITEST .GT. 75 .AND. TESTFL) THEN                          30.82
             WRITE(PRTEST,7190) SIGMA, ICONTR(3)                          30.82
7190         FORMAT(' ++5 : SIGMA ICONTR(3)      :',1D12.5,I4)            30.82
           ENDIF                                                          30.82
            goto 400                                                      40.14
         end if
C
c **     Update the vectors s.
c
         alpha = rho / sigma
         do j = 1,n
            s(j) = REAL(DBLE(res(j)) - alpha * DBLE(v(j)))                30.82
         enddo
C
c
c **     Compute As and store in t.
c
         if(icontr(1).gt.0) then
           call druma1( s, work, amat, n, nconct, infmat,
     1             upperi, loperi)
           call prevc(n,work,t,amat,ndim,nconct,
     1                prec,nprec,infmat,icontr(1))
         else
            call prevc(n,s,work,amat,ndim,nconct,
     1                prec,nprec,infmat,icontr(1))
            call druma1( work, t, amat, n, nconct, infmat,
     1             upperi, loperi)
         endif
C
c **     Compute omega
c
         IF (DNRM2(n,t,1)**2.EQ.0.0) THEN                                 30.82
           OMEGA = 1.0                                                    30.82
         ELSE                                                             30.82
           OMEGA = DDOT(T,S,N)/(dnrm2(n,t,1)**2)                          40.02
         END IF                                                           30.82
C
c **     Update solution and residual, and compute norm.
c
         do j = 1,n
            work(j,3)= REAL(DBLE(work(j,3)) + alpha * DBLE(p(j)) +        30.82
     &                      omega * DBLE(s(j)))                           30.82
            res(j) = REAL(DBLE(s(j)) - omega * DBLE(t(j)))                30.82
C
           IF ( TESTFL .AND. ITEST .GT. 200 ) THEN                        30.82
             WRITE(PRTEST,7191) J, RES(J), S(J), T(J)                     30.82
7191         FORMAT(' ++6 : J, RES(J), S(J), T(J):',I4,1E12.5,2D12.5)     30.82
           ENDIF                                                          30.82
C
         enddo
C
         rnorm = dnrm2(n,res,1)                                           30.82
C
         IF ( TESTFL .AND. ITEST .GT. 75 ) THEN                           30.82
           WRITE(PRTEST,7192) RNORM                                       30.82
7192       FORMAT(' ++7 : RNORM',1D12.5)                                  30.82
         ENDIF                                                            30.82
c
c **     Adapt each sqrt(n) times rferr for accuracy check.
c **     Compute actual residual and subtract the computed RES. The
c **     vector t is now an indication of the possible accuracy.
C
         if (mod(iter,isqrn) .eq. 0) then
            call dcopy(n,work(1,3),1,work(1,2),1)
            if(icontr(1).lt.0) then
               call prevc(n,work(1,2),work(1,3),amat,ndim,
     1                    nconct,prec,nprec,infmat,icontr(1))
            endif
            call daxpy(n,1.0,work(1,3),1,usol,1)
            do j = 1, n
               work(j,3) = 0.0
            enddo
             call druma1( usol, t, amat, n, nconct, infmat,
     1             upperi, loperi)
            do j = 1,n
               work(j,1) = t(j) - rhsd(j)
            enddo
            if(icontr(1).eq.2) then
c               call dinvl(work,t,amat,n/ndim,ndim,
c     1                    nconct,prec,nprec,infmat)
            else
               if(icontr(1).gt.0) then
                  call prevc(n,work,t,amat,ndim,nconct,
     1                       prec,nprec,infmat,icontr(1))
               else
                  call dcopy(n,work,1,t,1)
               endif
            endif
            do j = 1,n
               t(j) = t(j) + res(j)
            enddo
            rferr = DBLE(iter)                                            30.82
            rferr = exp(0.5 * (rferr/DBLE(n)) ** 2) * dnrm2(n,t,1)        30.82
         end if
C
         IF ( TESTFL .AND. ITEST .GT. 75 ) THEN                           30.82
           WRITE(PRTEST,7181) ITER, ISTAR, ITMAX                          30.82
           WRITE(PRTEST,7180) ALPHA, OMEGA, RNORM, RFERR                  30.82
           WRITE(PRTEST,*) ' return to iter '                             30.82
7181       FORMAT(' ++8 : ITER ISTAR ITMAX        :',3I5)                 30.82
7180       FORMAT(' ++8 : ALPHA OMEGA RNORM RFERR :',4D12.5)              30.82
         ENDIF                                                            30.82
C
      enddo
C
c **  The iteration process terminates because the maximum number of
c **  iterations is reached. Set error indicator.
C
      icontr(3)=3
c                                                                         40.14
c     The solution vector is adapted when an error has occured            40.14
c                                                                         40.14
400   continue                                                            40.14
      call dcopy(n,work(1,3),1,work(1,2),1)                               40.14
      if(icontr(1).lt.0) then                                             40.14
         call prevc(n,work(1,2),work(1,3),amat,ndim,                      40.14
     1              nconct,prec,nprec,infmat,icontr(1))                   40.14
      endif                                                               40.14
C                                                                         40.14
c     solution usol is adapted                                            40.14
c                                                                         40.14
      call daxpy(n,1.0, work(1,3),1,usol,1)                               40.14
c
c **  Normal termination of the iteration process.
c
 500  continue
      call prires('ISCGSTAB ',rnorm,icontr,.true.)
      call druma1( usol, t, amat, n, nconct, infmat,
     1             upperi, loperi)
      do j = 1,n
         res(j) = rhsd(j) - t(j)
      enddo
      rnorm = dnrm2(n,res,1)
C
      return
      end
*********************************************************************
*                                                                   *
      subroutine daxpy(n, da, dx, incx, dy, incy)
*                                                                   *
*********************************************************************
C
      implicit REAL  (a-h,o-z)
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  Zdenek                                     |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C      1.1 : Zdenek
C     30.82: IJsbrand Haagsma
C
C  1. Updates
c
c      1.1 , Aug. 91: no dimension, cdc, ce
C     30.82, Mar. 99: Replaced artithmic if
c
c
c     overwrite double precision dy with double precision da*dx + dy.
c     for i = 0 to n-1, replace  dy(ly+i*incy) with da*dx(lx+i*incx) +
c       dy(ly+i*incy), where lx = 1 if incx .ge. 0, else lx = (-incx)*n,
c       and ly is defined in a similar way using incy.
c
c
      REAL  dx(*), dy(*)
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'daxpy')
c
      if (n.le.0 .or. da.eq.0.0) return
      if (incx.eq.incy) THEN                                              30.82
        if (incx-1.LT.0) GOTO 10                                          30.82
        if (incx-1.EQ.0) GOTO 30                                          30.82
        if (incx-1.GT.0) GOTO 70                                          30.82
      ENDIF
   10 continue
c
c        code for nonequal or nonpositive increments.
c
      ix = 1
      iy = 1
      if (incx.lt.0) ix = (-n+1)*incx + 1
      if (incy.lt.0) iy = (-n+1)*incy + 1
      do 20 i=1,n
         dy(iy) = dy(iy) + da*dx(ix)
         ix = ix + incx
         iy = iy + incy
   20 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop so remaining vector length is a multiple of 4.
c
   30 m = mod(n,4)
      if (m.eq.0) go to 50
      do 40 i=1,m
         dy(i) = dy(i) + da*dx(i)
   40 continue
      if (n.lt.4) return
   50 mp1 = m + 1
      do 60 i=mp1,n,4
         dy(i) = dy(i) + da*dx(i)
         dy(i+1) = dy(i+1) + da*dx(i+1)
         dy(i+2) = dy(i+2) + da*dx(i+2)
         dy(i+3) = dy(i+3) + da*dx(i+3)
   60 continue
      return
c
c        code for equal, positive, nonunit increments.
c
   70 continue
      ns = n*incx
      do 80 i=1,ns,incx
         dy(i) = da*dx(i) + dy(i)
   80 continue
      return
      end
********************************************************************
*                                                                  *
      subroutine dcopy(n, dx, incx, dy, incy)
*                                                                  *
********************************************************************
C
      implicit REAL  (a-h,o-z)
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  Zdenek                                     |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C      1.1 : Zdenek
C     30.82: IJsbrand Haagsma
C
C  1. Updates
c
c      1.1 , Aug. 91: no dimension, cdc, ce
C     30.82, Mar. 99: Replaced artithmic if
c
c     copy double precision dx to double precision dy.
c     for i = 0 to n-1, copy dx(lx+i*incx) to dy(ly+i*incy),
c     where lx = 1 if incx .ge. 0, else lx = (-incx)*n, and ly is
c     defined in a similar way using incy.
c
c
      REAL  dx(*), dy(*)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'dcopy')
c
      if (n.le.0) return
      if (incx.eq.incy) THEN                                              30.82
        if (incx-1.LT.0) GOTO 10                                          30.82
        if (incx-1.EQ.0) GOTO 30                                          30.82
        if (incx-1.GT.0) GOTO 70                                          30.82
      ENDIF
   10 continue
c
c        code for unequal or nonpositive increments.
c
      ix = 1
      iy = 1
      if (incx.lt.0) ix = (-n+1)*incx + 1
      if (incy.lt.0) iy = (-n+1)*incy + 1
      do 20 i=1,n
         dy(iy) = dx(ix)
         ix = ix + incx
         iy = iy + incy
   20 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop so remaining vector length is a multiple of 7.
c
   30 m = mod(n,7)
      if (m.eq.0) go to 50
      do 40 i=1,m
         dy(i) = dx(i)
   40 continue
      if (n.lt.7) return
   50 mp1 = m + 1
      do 60 i=mp1,n,7
         dy(i) = dx(i)
         dy(i+1) = dx(i+1)
         dy(i+2) = dx(i+2)
         dy(i+3) = dx(i+3)
         dy(i+4) = dx(i+4)
         dy(i+5) = dx(i+5)
         dy(i+6) = dx(i+6)
   60 continue
      return
c
c        code for equal, positive, nonunit increments.
c
   70 continue
      ns = n*incx
      do 80 i=1,ns,incx
         dy(i) = dx(i)
   80 continue
      return
      end
**********************************************************************
*                                                                    *
      DOUBLE PRECISION FUNCTION DDOT(DX, DY, N)                          40.02
*                                                                    *
**********************************************************************
!
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
!
!  0. Authors
!
!     40.02: IJsbrand Haagsma
!
!  1. Updates
!
!     40.02, Sep. 00: New subroutine to replace old one.
!
!  2. Purpose
!
!     Calculates dot product of two vectors of equal length
!
!  3. Method
!
!     Convert vectors to double precision, multiply elements and sum
!
!  4. Modules used
!
!     --
!
      IMPLICIT NONE
!
!  5. Argument variables
!
!     DX    : First vector in dot product
!     DY    : Second vector in dot product
!     N     : Vector length
!
      INTEGER, INTENT(IN) :: N
!
      REAL, INTENT(IN)    :: DX(N), DY(N)
!
!  6. Parameter variables (Constants)
!
!     --
!
!  7. Local variables
!
!     IENT  : Number of entries into this subroutine
!
      INTEGER, SAVE       :: IENT = 0
!
!  8. Subroutines used
!
!     STRACE: Tracing routine for debugging
!
!  9. Subroutines calling
!
!     CGSTAB: Solves an unsymmetric system of linear equations by the Bi-CGSTAB method.
!
! 10. Error messages
!
!     --
!
! 11. Remarks
!
!     --
!
! 12. Structure
!
!     Make DX and DY double precision
!     Multiply DX and DY
!     Sum all elements of result
!
! 13. Source text
!
      CALL STRACE(IENT,'DDOT')
!
      DDOT = SUM(DBLE(DX) * DBLE(DY))
!
      RETURN
!
      END FUNCTION DDOT
********************************************************************
*                                                                  *
      subroutine diag(amat,n,ndimso,nconct,prec,nprec,infmat)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.3      date 18-11-1992  all the element of prec are filled
c                      also in the virtual points
c     version 1.2      date 04-08-1992  Zdenek:  ndimso instead of ndim
c     version 1.1      date 07-05-1992
c     developed at     Convex, HP700
c
c
c ******************************************************************
c
c                       DESCRIPTION
c
c      Makes a diagonal scaling of the matrix in case of a momentum
c      equations, a transport equation, or a pressure equation.
c
c
c ******************************************************************
c
c                       KEYWORDS
c
c      linear_solver
c      diagonal
c      preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c      amat     i   the coefficient matrix for the momentum equations
c                   or an equation similar to the pressure equation.
c
c      infmat   i   If infmat is 1 we use the momentum equations,
c                   whereas if infmat is larger than or equal to 4
c                   we use equations with a structure similar to the
c                   pressure equation.
c
c      n        i   number of unknowns in the solution vector.
c
c      nconct   i   number of connections in one row of the matrix
c
c      ndimso   i   integer indicating the dimension of the space in
c                   which the problem must be solved (ndimso = 1 or ndim).
c
c      nprec    i   number of diagonals, which are used in the pre-
c                   conditioning. In this subroutine nprec = 1.
c
c      prec     o   the preconditioning matrix.
c
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c      i            loop counter
c
c      j            loop counter
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     To obtain a diagonal scaling of the matrix. This is done for
c     the momentum and pressure equation. The inverse of the main
c     diagonal is stored in the array prec. For transport equations
c     we use the same structure as the pressure equation.
c
c ==================================================================
c
c     input/output parameters
c
      integer          infmat,n,ndimso,nconct,nprec
      REAL  amat(1:n,1:ndimso,1:nconct),
     1                 prec(1:n,1:ndimso,1:nprec)
c
c
c     local parameters
      integer i,j
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'diag')
c
      do j = 1, ndimso
         do i = 1, n
            if(amat(i,j,1).eq.0.0) then
               prec(i,j,1) = 0.0
            else
               prec(i,j,1) = 1.0/amat(i,j,1)
            endif
         enddo
      enddo
      return
      end
********************************************************************
*                                                                  *
      subroutine diagmu(n,x,b,prec,nprec)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.0      date 14-05-1992
c     developed at     Convex, HP700
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     Multiplication of x with the diagonal matrix given in prec.
c
c     The array prec sould be filled by subroutine diag.f
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     diagonal
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c     b      o  the resulting vector after multiplication.
c
c     n      i  number of unknowns in the solution vector.
c
c     nprec  i  number of diagonals, which are used in the pre-
c               conditioning. In this subroutine nprec = 1.
c
c     prec   i  the diagonal preconditioning matrix.
c
c     x      i  the original vector.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     i      loop counter.
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     Multiplication of x with the diagonal matrix given in prec.
c     The result is given in b.
c
c ==================================================================
c
c     Parameters
c
      integer          n,nprec
      REAL  prec(1:n,1:nprec),x(n),b(n)
c
c     local parameters
c
      integer i
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'diagmu')
c
      do i = 1, n
         b(i) = x(i)*prec(i,1)
      enddo
      return
      end
********************************************************************
*                                                                  *
      subroutine dinvl3(x,b,matrix,n,ndim,nconct,
     1                  prec,nprec,infmat)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.2      date 01-06-1992
c     developed at     Convex, HP700
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     Multiplication of x by L, the preconditioning matrix given in
c     prec.
c
c     In this case we obtain:
c                 -1
c            b = L  x.
c
c     The array prec should be filled by dmlu3.f. This subroutine
c     contains compiler directives to run in vector speed on the
c     Convex.
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     ilu
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c
c     b       o  the result vector, which contains:
c                         -1
c                    b = L  x.
c
c     infmat  i  if infmat(1) is 1 we use the momentum equations,
c                whereas if infmat(1) is larger than or equal to 4
c                we use equations, with a structure similar to the
c                pressure equations.
c
c     matrix  i  the coefficient matrix for the momentum or
c                an equation similar to the pressure equation.
c
c     n       i  number of unknowns in the solution vector.
c
c     nconct  i  number of connections in one row of the matrix
c
c     ndim    i  integer indicating the dimension of the space in
c                which the problem must be solved (ndim = 2 or 3).
c
c     nprec   i  number of diagonals, which are used in the pre-
c                conditioning. In this subroutine nprec = nconct.
c
c     prec    i  the preconditioning matrix.
c
c     x       i  the original vector.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     i       loop counter.
c
c     ii      loop counter.
c
c     j       loop counter.
c
c     jjmax   loop bound.
c
c     jjmin   loop bound.
c
c     nx      number of points in the x-direction.
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     Multiplication of x with L preconditioning matrix given
c     in matrix and prec. In this case we obtain:
c                 -1
c            b = L  x.
c
c     The arrays prec and matrix should be filled by subroutine dmlu3.f
c
c     **************************************************************
c
c     Change1 15-02-1991 C. Vuik.
c
c     The reason of this change is to solve the lower triangular system
c     in vector speed.
c
c     Literature : High performance preconditioning.
c                  H. A. van der Vorst.
c                  SIAM. J. Sci. Stat. Comput. 10 pp.1174-1185 (1989).
c
c     Implementation : Compare subroutine precd in the program ictest
c                      written by H. A. van der Vorst.
c
c     Remark     : In this version the virtual points along the bound-
c                  ary are made zero. Thereafter the loop only runs
c                  over the non-boundary points.
c
c     **************************************************************
c
c     Change2 01-06-1992 C. Vuik
c
c     The virtual points are removed.
c
c     **************************************************************
c
c     Remark
c
c     - at this moment only infmat(1).ge.4 is allowed.
c
c     **************************************************************
c
c ==================================================================
c
c     Parameters
c
      integer          infmat(*),n,ndim,nconct,nprec
      REAL  matrix(1:n,1:ndim,1:nconct),
     1                 prec(1:n,1:ndim,1:nprec),
     2                 x(n,ndim),b(n,ndim)
c
c     local parameters
c
C      integer i,j,ii,nx,jjmin,jjmax
      integer nx
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'dinvl3')
c
      nx = infmat(2)+1
c                             -1
c     The multiplication b = L  x
c
c     First we fill the points on the lower horizontal boundary.
c
      b(1,1) = x(1,1)
      do i = 2, nx
         b(i,1) = x(i,1)-prec(i,1,5)*b(i-1,1)
      enddo
      i = nx+1
      b(i,1) = x(i,1)-prec(i,1,4)*b(2,1)
     1               -prec(i,1,3)*b(1,1)
      i = nx+2
      b(i,1) = x(i,1)-prec(i,1,5)*b(i-1,1)
     1               -prec(i,1,4)*b(3,1)
     2               -prec(i,1,3)*b(2,1)
     3               -prec(i,1,2)*b(1,1)
c
c     change1
c
       do i = nx+3, n
            b(i,1) = x(i,1)-prec(i,1,5)*b(i-1   ,1)
     1                  -prec(i,1,4)*b(i-nx+1,1)
     2                  -prec(i,1,3)*b(i-nx  ,1)
     3                  -prec(i,1,2)*b(i-nx-1,1)
      end do
      end
********************************************************************
*                                                                  *
      subroutine dinvu3(x,b,matrix,n,ndimso,nconct,
     1                  prec,nprec,infmat)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.3      date 04-08-1992  Zdenek: ndimso instead of ndim
c     version 1.2      date 01-06-1992
c     developed at     Convex, HP700
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     Multiplication of x by U, the preconditioning matrix given in
c     prec.
c
c     In this case we obtain:
c                 -1
c            b = U  x.
c
c     The array prec should be filled by dmlu3.f. This subroutine
c     contains compiler directives to run in vector speed on the
c     Convex.
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     ilu
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c     b       o  the result vector, which contains:
c                     -1
c                b = U  x.
c
c     infmat  i  if infmat(1) is 1 we use the momentum equations,
c                whereas if infmat(1) is larger than or equal to 4
c                we use equations, with a structure similar to the
c                pressure equation.
c
c     matrix  i  the coefficient matrix for the momentum or
c                an equation similar to the pressure equation.
c
c     n       i  number of unknowns in the solution vector.
c
c     nconct  i  number of connections in one row of the matrix
c
c     ndimso  i  integer indicating the dimension of the space in
c                which the problem must be solved (ndimso = 1 or ndim).
c
c     nprec   i  number of diagonals, which are used in the pre-
c                conditioning. In this subroutine nprec = nconct.
c
c     prec    i  the preconditioning matrix.
c
c     x       i  the original vector.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     i       loop counter.
c
c     ii      loop counter.
c
c     j       loop counter.
c
c     jjmax   loop bound.
c
c     jjmin   loop bound.
c
c     nx      number of points in the x-direction.
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     Multiplication of x with ILU preconditioning matrix given
c     in matrix and prec. In this case we obtain:
c                 -1
c            b = U  x.
c
c     The arrays prec and matrix should be filled by subroutine dmlu3.f
c
c     **************************************************************
c
c     Change1 15-02-1991 C. Vuik.
c
c     The reason of this change is to solve the upper triangular system
c     in vector speed.
c
c     Literature : High performance preconditioning.
c                  H. A. van der Vorst.
c                  SIAM. J. Sci. Stat. Comput. 10 pp. 1174-1185 (1989)
c
c     Implementation : Compare subroutine precd in the program ictest
c                      written by H. A. van der Vorst.
c
c     Remark     : In this version the virtual points along the boundary
c                  are made zero. Thereafter the loop only runs over
c                  the non-boundary points.
c
c     **************************************************************
c
c     Change2 01-06-1992 C. Vuik.
c
c     The virtual points are removed.
c
c     **************************************************************
c
c     Remark
c
c     - at this moment only infmat(1).ge.4 is allowed.
c
c ==================================================================
c
c     Parameters
c
      integer          infmat(*),n,ndimso,nconct,nprec
      REAL  matrix(1:n,1:ndimso,1:nconct),
     1                 prec(1:n,1:ndimso,1:nprec),
     2                 x(n,ndimso),b(n,ndimso)
c
c     local parameters
c
C      integer i,j,ii,nx,jjmin,jjmax
      integer i,nx
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'dinvu3')
c
      nx = infmat(2)+1
c                             -1
c     The multiplication b = U  x
c
c     First we fill the points on the upper horizontal boundary.
c
      b(n,ndimso) = x(n,ndimso)*prec(n,ndimso,1)
      do i = 2, nx-1
c
c       wijziging
c
c       Het statement wat hier weg gecommentarieerd staat is het foute
c       statement: prec(i,ndimso,1) moet prec(n+1-i,ndimso,1) zijn
c
c           b(n+1-i,ndimso) = (x(n+1-i,ndimso)
c       1                   -prec(n+1-i,ndimso,6)*b(n+2-i,ndimso))
c       2                   *prec(i,ndimso,1)
c
c       Hieronder het goede statement
c
        b(n+1-i,ndimso) = (x(n+1-i,ndimso)
     1                    -prec(n+1-i,ndimso,6)*b(n+2-i,ndimso))
     2                    *prec(n+1-i,ndimso,1)
c
      enddo
      i = n-nx+1
            b(i,ndimso) = (x(i,ndimso)-prec(i,ndimso,6)*b(i+1,ndimso)
     1                  -prec(i,ndimso,7)*b(i+nx-1,ndimso))
     4                  *prec(i,ndimso,1)
      i = n-nx
            b(i,ndimso) = (x(i,ndimso)-prec(i,ndimso,6)*b(i+1,ndimso)
     1                  -prec(i,ndimso,7)*b(i+nx-1,ndimso)
     2                  -prec(i,ndimso,8)*b(i+nx  ,ndimso))
     4                  *prec(i,ndimso,1)
         do i = n-nx-1, 1, -1
            b(i,ndimso) = (x(i,ndimso)-prec(i,ndimso,6)*b(i+1,ndimso)
     1                  -prec(i,ndimso,7)*b(i+nx-1,ndimso)
     2                  -prec(i,ndimso,8)*b(i+nx  ,ndimso)
     3                  -prec(i,ndimso,9)*b(i+nx+1,ndimso))
     4                  *prec(i,ndimso,1)
         enddo
      end
********************************************************************
*                                                                  *
      subroutine dmlu3(matrix,n,ndim,nconct,prec,nprec,infmat)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.1      date 01-06-1992
c     developed at     Convex, HP700
C     31.03  Annette Kieftenburg
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     Calculates an upper triangular matrix U and a lower triangular
c     matrix L, which form an incomplete decomposition of A.
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     ilu
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c     infmat  i  if infmat(1) is 1 we use the momentum equations,
c                whereas if infmat(1) is larger than or equal to 4
c                we use equations with a structure similar to the
c                pressure equation. infmat(2) is the number of
c                discretization points in the x-direction.
c
c     matrix  i  the coefficient matrix for the momentum equations
c                or an equation similar to the pressure equation.
c
c     n       i  number of unknowns in the solution vector.
c
c     nconct  i  number of connections in one row of the matrix
c
c     ndim    i  integer indicating the dimension of the space in
c                which the problem must be solved (ndim = 2 or 3).
c
c     nprec   i  number of diagonals, which are used in the pre-
c                conditioning. In this subroutine nprec = nconct.
c
c     prec    o  the preconditioning matrix.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     a       this parameter is used to make a combination of ILU
c             and MILU preconditioning.
c
c     i       loop counter.
c
c     n1      n1 is needed to describe the matrix elements.
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     This subroutine calculates an upper triangular matrix U and a lower
c     triangular matrix L, These matrices form an incomplete decomposition
c     for the matrix A using the following rules:
c
c            A = L U - R,
c
c     (a) diag(L) = I,
c
c     (b) The nonzero pattern of L and U are equal to the nonzero pattern
c         of A,
c
c     (c) If a(i,j) # 0 then L*U(i,j) = a(i,j)
c
c     The off-diagonal elements of U are stored in prec(1:n,1:ndim,6:9),
c     whereas inverse(diag(U)) is stored in prec(1:n,1:ndim,1).
c     The off-diagonal elements of L are stored in prec(1:n,1:ndim,2:5),
c
c     **************************************************************
c
c     Remarks
c
c     There are two difficulties to obtain the incomplete decomposition
c
c     - firstly, since the index of the matrix element can be less than
c       1 we discriminate 9 different situations:(n1 = ni+3)
c              i = 1,
c              i = 2,...,n1-1
c              i = n1,
c              i = n1+1,
c              i = n1+2,...,n-n1-2,
c              i = n-n1-1
c              i = n-n1
c              i = n-n1+1,...,n-1
c              i = n
c
c     - secondly, it is known that in the virtual cells the corresponding
c       row and collumn in the matrix consists of zero elements. So it is
c       possible that d(i) = 0. To circumvent this possibility we imple-
c       ment the following check:
c          if(a(i,1).eq.0) then prec(i,1) = 1 else ...
c
c ==================================================================
c
c     Parameters
c
      integer          infmat(*),n,ndim,nconct,nprec
      REAL  matrix(1:n,1:ndim,1:nconct),
     1                 prec(1:n,1:ndim,1:nprec)
c
c     local parameters
c
      integer          i,n1
      REAL  a
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'dmlu3')
c
c     The parameter a contains the value of alpha used in the RILU(alpha)
c     preconditioner. It appears that a good choice for the poisson
c     equation (infmat(1) = 5) is:
c        alpha = 0     for LSETUP=1, and
c        alpha = 0.975 for LSETUP=2.
c
      a = 0.975
      if (infmat(1).EQ.5) then                                            31.03
         LSETUP = infmat(8)                                               31.03
         if ( LSETUP.EQ.1 ) then                                          31.03
            a = 0.0e0
         else
            a = 0.975e0
         end if
      end if
      n1 = infmat(2)+1
c
c     Compute the incomplete decomposition such that the part
c     prec(i,1,*) is filled
c
c     i = 1
c
      i = 1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
         prec(i,1,7) = matrix(i,1,7)
         prec(i,1,8) = matrix(i,1,8)
         prec(i,1,9) = matrix(i,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*matrix(i+1   ,1,5)
         prec(i+n1-1,1,4) = prec(i,1,1)*matrix(i+n1-1,1,4)
         prec(i+n1  ,1,3) = prec(i,1,1)*matrix(i+n1  ,1,3)
         prec(i+n1+1,1,2) = prec(i,1,1)*matrix(i+n1+1,1,2)
c
c     i = 2, n1-1
c
      do i = 2, n1-1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.
         else
            prec(i,1,1) = matrix(i,1,1)
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
         prec(i,1,8) = matrix(i,1,8)-prec(i,1,5)*prec(i-1,1,9)
         prec(i,1,9) = matrix(i,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*matrix(i+1   ,1,5)
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
         prec(i+n1  ,1,3) = prec(i,1,1)*(matrix(i+n1  ,1,3)
     1                      -prec(i+n1  ,1,2)*prec(i-1,1,6))
         prec(i+n1+1,1,2) = prec(i,1,1)*matrix(i+n1+1,1,2)
      end do
c
c     i = n1
c
      i = n1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
         prec(i,1,8) = matrix(i,1,8)-prec(i,1,5)*prec(i-1,1,9)
         prec(i,1,9) = matrix(i,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
         prec(i+n1  ,1,3) = prec(i,1,1)*(matrix(i+n1  ,1,3)
     1                      -prec(i+n1  ,1,2)*prec(i-1,1,6))
         prec(i+n1+1,1,2) = prec(i,1,1)*matrix(i+n1+1,1,2)
c
c     i = n1+1
c
      i = n1+1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
     1                 -prec(i,1,3)*prec(i-n1  ,1,9)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
         prec(i,1,8) = matrix(i,1,8)-prec(i,1,5)*prec(i-1,1,9)
         prec(i,1,9) = matrix(i,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     1                      -prec(i+1,1,2)*prec(i-n1  ,1,8)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
         prec(i+n1  ,1,3) = prec(i,1,1)*(matrix(i+n1  ,1,3)
     1                      -prec(i+n1  ,1,2)*prec(i-1,1,6))
         prec(i+n1+1,1,2) = prec(i,1,1)*matrix(i+n1+1,1,2)
c
c     i = n1+2, n-n1-1
c
      do i = n1+2, n-n1-1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     1                    -prec(i,1,2)*(prec(i-n1-1,1,9)
     1                    +a*prec(i-n1-1,1,7))
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
     1                 -prec(i,1,3)*prec(i-n1  ,1,9)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
         prec(i,1,8) = matrix(i,1,8)-prec(i,1,5)*prec(i-1,1,9)
         prec(i,1,9) = matrix(i,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     1                      -prec(i+1,1,2)*prec(i-n1  ,1,8)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
         prec(i+n1  ,1,3) = prec(i,1,1)*(matrix(i+n1  ,1,3)
     1                      -prec(i+n1  ,1,2)*prec(i-1,1,6))
         prec(i+n1+1,1,2) = prec(i,1,1)*matrix(i+n1+1,1,2)
      end do
c
c     i = n-n1
c
      i = n-n1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     1                    -prec(i,1,2)*(prec(i-n1-1,1,9)
     1                    +a*prec(i-n1-1,1,7))
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
     1                 -prec(i,1,3)*prec(i-n1  ,1,9)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
         prec(i,1,8) = matrix(i,1,8)-prec(i,1,5)*prec(i-1,1,9)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     1                      -prec(i+1,1,2)*prec(i-n1  ,1,8)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
         prec(i+n1  ,1,3) = prec(i,1,1)*(matrix(i+n1  ,1,3)
     1                      -prec(i+n1  ,1,2)*prec(i-1,1,6))
c
c
c     i = n-n1+1
c
      i = n-n1+1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     1                    -prec(i,1,2)*(prec(i-n1-1,1,9)
     1                    +a*prec(i-n1-1,1,7))
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
         prec(i,1,6) = matrix(i,1,6)
     1                 -prec(i,1,3)*prec(i-n1  ,1,9)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
         prec(i,1,7) = matrix(i,1,7)-prec(i,1,5)*prec(i-1,1,8)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     1                      -prec(i+1,1,2)*prec(i-n1  ,1,8)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
         prec(i+n1-1,1,4) = prec(i,1,1)*(matrix(i+n1-1,1,4)
     1                      -prec(i+n1-1,1,3)*prec(i-1,1,6))
c
c
c     i = n-n1+2, n-1
c
      do i = n-n1+2, n-1
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     1                    -prec(i,1,2)*(prec(i-n1-1,1,9)
     1                    +a*prec(i-n1-1,1,7))
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
            prec(i,1,6) = matrix(i,1,6)
     1                 -prec(i,1,3)*prec(i-n1  ,1,9)
     2                 -prec(i,1,4)*prec(i-n1+1,1,8)
c
c     the matrix L
c
         prec(i+1   ,1,5) = prec(i,1,1)*(matrix(i+1   ,1,5)
     1                      -prec(i+1,1,2)*prec(i-n1  ,1,8)
     2                      -prec(i+1,1,3)*prec(i-n1+1,1,7))
      end do
c
c
c     i = n
c
      i = n
c
c     the matrix U
c
         if(matrix(i,1,1).eq.0) then
            prec(i,1,1) = 1.0
         else
            prec(i,1,1) = matrix(i,1,1)
     1                    -prec(i,1,2)*(prec(i-n1-1,1,9)
     1                    +a*prec(i-n1-1,1,7))
     2                    -prec(i,1,3)*prec(i-n1  ,1,8)
     3                    -prec(i,1,4)*(prec(i-n1+1,1,7)
     3                    +a*prec(i-n1+1,1,6)+a*prec(i-n1+1,1,9))
     4                    -prec(i,1,5)*(prec(i-1   ,1,6)
     4                    +a*prec(i-1   ,1,7))
            prec(i,1,1) = 1.0/prec(i,1,1)
         end if
      return
      end
************************************************************************
*                                                                      *
      DOUBLE PRECISION FUNCTION DNRM2(N, DX, INCX)                        30.82
*                                                                      *
************************************************************************
C
      IMPLICIT NONE
C
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  Zdenek                                     |
*   --|-----------------------------------------------------------|--
*
C
C  0. Authors
C
C      1.0 : C.L. Lawson
C      1.1 : Zdenek
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C      1.0 , Jan. 78: New FUNCTION
C      1.1 , Aug. 91: No dimension: CDC, CE
C     30.82, Sep. 98: To avoid errors using the Cray-cf90 compiler
C                     deleted obsolescent fortran90 (assigned goto)
C     30.82, Sep. 98: Works with double precision to avoid underflows
C
C  2. Purpose
C
C     Calculates the Euclidean norm of a vector DX() of length N
C
C  3. Method
C
c        version 1.1    date   22-08-91 (Zdenek: no dimension, cdc, ce)
c
c     euclidean norm of the n-vector stored in dx() with storage
c     increment incx .
c     if    n .le. 0 return with result = 0.
c     if n .ge. 1 then incx must be .ge. 1
c
c           c.l.lawson, 1978 jan 08
c
c     four phase method     using two built-in constants that are
c     hopefully applicable to all machines.
c         cutlo = maximum of  sqrt(u/eps)  over all known machines.
c         cuthi = minimum of  sqrt(v)      over all known machines.
c     where
c         eps = smallest no. such that eps + 1. .gt. 1.
c         u   = smallest positive no.   (underflow limit)
c         v   = largest  no.            (overflow  limit)
c
c     brief outline of algorithm..
c
c     phase 1    scans zero components.
c     move to phase 2 when a component is nonzero and .le. cutlo
c     move to phase 3 when a component is .gt. cutlo
c     move to phase 4 when a component is .ge. cuthi/m
c     where m = n for x() real and m = 2*n for complex.
c
c     values for cutlo and cuthi..
c     from the environmental parameters listed in the imsl converter
c     document the limiting values are as follows..
c     cutlo, s.p.   u/eps = 2**(-102) for  honeywell.  close seconds are
c                   univac and dec at 2**(-103)
c                   thus cutlo = 2**(-51) = 4.44089e-16
c     cuthi, s.p.   v = 2**127 for univac, honeywell, and dec.
c                   thus cuthi = 2**(63.5) = 1.30438e19
c     cutlo, d.p.   u/eps = 2**(-67) for honeywell and dec.
c                   thus cutlo = 2**(-33.5) = 8.23181d-11
c     cuthi, d.p.   same as s.p.  cuthi = 1.30438d19
c     data cutlo, cuthi / 8.232d-11,  1.304d19 /
c     data cutlo, cuthi / 4.441e-16,  1.304e19 /
C
C  4. Argument variables
C
C     N     : Length of the vector in DX()
C     INCX  : Stride of the vector stored in DX()
C
      INTEGER N, INCX
C
C     DX    : Array containing the vector
C
      REAL DX(*)
C
C  6. Local variables
C
C     CUTHI :
C     CUTLO :
C     ONE   : the double precision number 1
C     SUM   :
C     SZERO : the single precision number 0
C     XMAX  :
C     ZERO  : the double precision number 0
C
      DOUBLE PRECISION  ONE, SUM, XMAX, ZERO                              30.82
      REAL   CUTHI, CUTLO, HITEST, SZERO                                  30.82
C
      data cutlo, cuthi /8.232e-11,1.304e19/
      data zero, one /0.0,1.0/
      DATA SZERO /0.0/                                                   30.82
C
C     I
C     J
C     NEXT
C     NN
C
      INTEGER I, J, NEXT, NN
C
c     on real underflow ignore
C
      if (n.gt.0) go to 10
      dnrm2 = zero
      go to 140
c
   10 NEXT = 30                                                           30.82
      sum = zero
      nn = n*incx
c                                                 begin main loop
      i = 1
   20 IF (NEXT.EQ.30) GOTO 30                                             30.82
      IF (NEXT.EQ.40) GOTO 40                                             30.82
      IF (NEXT.EQ.70) GOTO 70                                             30.82
      IF (NEXT.EQ.80) GOTO 80                                             30.82
   30 if (abs(dx(i)).gt.cutlo) go to 110
      NEXT = 40                                                           30.82
      xmax = zero
c
c                        phase 1.  sum is zero
c
   40 if (abs(dx(i)).gt.szero) go to 41                                   30.82
      GOTO 130                                                            30.82
   41 continue                                                            30.82
      if (abs(dx(i)).gt.cutlo) go to 110
c
c                                prepare for phase 2.
      NEXT = 70                                                           30.82
      go to 60
c
c                                prepare for phase 4.
c
   50 i = j
      NEXT = 80
      sum = (sum/DBLE(dx(i)))/DBLE(dx(i))                                 30.82
   60 xmax = DBLE(abs(dx(i)))                                             30.82
      go to 90
c
c                   phase 2.  sum is small.
c                             scale to avoid destructive underflow.
c
   70 if (abs(dx(i)).gt.cutlo) go to 100
c
c                     common code for phases 2 and 4.
c                     in phase 4 sum is large.  scale to avoid overflow.
c
   80 if (abs(dx(i)).le.REAL(xmax)) go to 90                              30.82
      sum = one + sum*(xmax/DBLE(dx(i)))**2                               30.82
      xmax = DBLE(abs(dx(i)))                                             30.82
      go to 130
c
   90 sum = sum + (DBLE(dx(i))/xmax)**2                                   30.82
      go to 130
c
c
c                  prepare for phase 3.
c
  100 sum = (sum*xmax)*xmax
c
c
c     for real or d.p. set hitest = cuthi/n
c     for complex      set hitest = cuthi/(2*n)
c
  110 hitest = cuthi/REAL(n)                                              30.82
c
c                   phase 3.  sum is mid-range.  no scaling.
c
      do 120 j=i,nn,incx
         if (abs(dx(j)).ge.hitest) go to 50
         sum = sum + DBLE(dx(j))**2                                       30.82
  120 continue
      dnrm2 = sqrt(sum)
      go to 140
c
  130 continue
      i = i + incx
      if (i.le.nn) go to 20
c
c              end of main loop.
c
c              compute square root and adjust for scaling.
c
      dnrm2 = xmax*sqrt(sum)
  140 continue
c     on real underflow abort
      return
C
C     End of function DNRM2
C
      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine druma1(x,b,matrix,n,nconct,infmat,
     1                  upperi, loperi)
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C  0. Authors
C
C      1.0 : Kees Vuik
C     30.72: IJsbrand Haagsma
C     31.04: Nico Booij
C
C  1. Updates
C
C      1.0 , Jan. 78: New subroutine
C     31.04, Apr. 98: procedure not done for setup, only propagation
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
c
      integer          infmat(*),n,nconct
      REAL  matrix(1:n,1:nconct),
     1                 x(n),b(n), upperi(*), loperi(*)
      integer i,ni,n1
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'druma1')
c
C
      ni = infmat(2)
      n1 = ni+1
      i = 1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)+
     +          matrix(i,9)*x(i+n1+1)
      do i = 2, n1-1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)+
     +          matrix(i,9)*x(i+n1+1)
      end do
      i = n1
*
*                 temporary test
*
      if (i.lt.2 .or. (i+1).gt.n .or. (i+n1+1).gt.n)
     &             write (prtest,14) i, n1, n
  14  format (' error druma1 ', 6i6)
*
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)+
     +          matrix(i,9)*x(i+n1+1)
      i = n1+1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)+
     +          matrix(i,9)*x(i+n1+1)
      do i = n1+2, n-n1-1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,2)*x(i-n1-1)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)+
     +          matrix(i,9)*x(i+n1+1)
      end do
      i = n-n1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,2)*x(i-n1-1)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)+
     +          matrix(i,8)*x(i+n1)
      i = n-n1+1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,2)*x(i-n1-1)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)+
     +          matrix(i,7)*x(i+n1-1)
      do i = n-n1+2, n-1
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,2)*x(i-n1-1)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)+
     +          matrix(i,6)*x(i+1)
      end do
      i = n
         b(i) = matrix(i,1)*x(i)+
     +          matrix(i,2)*x(i-n1-1)+
     +          matrix(i,3)*x(i-n1)+
     +          matrix(i,4)*x(i-n1+1)+
     +          matrix(i,5)*x(i-1)
C
C     now the periodic part is taken into account (full circle case)
C     The test if ( infmat(1).EQ.4 ) is added when the poisson equation
C     to compute the SETUP was included by Kees Vuik at 31-10-1997.
C     infmat(1) = 4 represents the original equation (wave propagation)
C     infmat(1) = 5 represents the poisson equation (setup)
C
      if ( infmat(1).EQ.4 ) then                                          31.01
         do i = 1, n1
            b(i) = b(i)+upperi(i)*x(n-n1+i)
            b(n-n1+i) = b(n-n1+i)+loperi(i)*x(i)
         end do
      end if                                                              31.01
      return
      end
C************************************************************************
C                                                                       *
      SUBROUTINE ISSOLV(IINSOL  ,RINSOL  ,MATRIX  ,RHSIDE   ,SOLUT    ,
     &                  NUSOL   ,NCONCT  ,INFMAT  ,WORK     ,NWORK    ,
     &                  PRECON  ,NPREC   ,UPPERI  ,LOPERI   ,INOCNV   ,
     &                  ITSW    ,ITERSW  )                                30.72
C                                                                       *
C************************************************************************
c
      INCLUDE 'swcomm1.inc'                                               30.80
      INCLUDE 'swcomm3.inc'                                               30.80
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C   --|-----------------------------------------------------------|--
C     | Delft University of Technology                            |
C     | Faculty of Applied Mathematics and Informatics            |
C     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
C     |                                                           |
C     | Programmer  :  C. Vuik                                    |
C     | developed at:  Toshiba PC, Convec, HP700                  |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.80: Nico Booij
C     30.82: IJsbrand Haagsma
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     30.72, Nov. 97: Moved ERRPTS to other type declarations
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Feb. 98: Modified argument list for update CGSTAB solver
C     34.01, Feb. 99: Changed STOP statements in a MSGERR(4,'message')
C                     calls
C     34.01, Feb. 99: Introducing STPNOW
C     30.80, July 99: KCGRD, ICMAX, ERRPTS, IX, IY, NSTATC removed from argument list
C                     swcomm1 and swcomm3 now included;
C                     error messages modified
C     30.82, Sep. 99: Modified messages in case of non-convergence
C
C  2. Purpose
c
c     The subroutine issolv is used to solve an unsymmetric system
c     of equations of the shape A x = f.
c
C  3. Method
C
C     Keywords:
C     linear_solver, preconditioning
c
c     At present the following solution methods are available:
c     CGSTAB and the Bi-CGSTAB method.
c
C  4. Argument variables
C
C     ITERSW: input  Iteration counter for SWAN
C     ITSW  : input  Time step counter for SWAN
C     NSTATC: input  Indicates stationarity:
C                    =0; stationary computation
C                    =1; nonstationary computation
C
      INTEGER ITERSW, ITSW
C
c     iinsol   i   reserved
c     infmat   i   reserved
c     matrix   i   reserved
c     nprec    i   reserved
c     nusol    i   reserved
c     nwork    i   reserved
c     precon  i/o  reserved
c     rhside   i   reserved
c     rinsol   i   reserved
c     solut    o   reserved
c     work     o   reserved
C
C  5. Parameter variables
C
C     ---
C
C  6. Local variables
c
c     conv     Logical variable indicating acquired convergence.
c     dt       Timestep.
c     eps1     Required absolute accuracy.
c     eps2     Required reduction of the initial residual.
c     eps3     Required relative error of the solution.
c     i        Local counting variable
c     icontr   Array containing information for the called subroutines.
c     iprint   File number to which output should be written.
c     ipstrt   Used in the call of isextr
c     irrind   Variable indicating possible failures.
c     istop    Variable indicating whether the process must stop.
c     itmax    Maximal number of iteration to be performed.
c     iwarn    Variable indicating whether output must be given.
c     lwork    Extra work space needed for matrix vector multiplication
c     method   Variable determining the method to be used.
c     name     Name of calling subroutine for error messages
c     nconct   number of connections in one row of the matrix.
c     ndim     Dimension of spacec
c     ndimso   number of unknowns per one gridpoint,
c              ndimso = ndim for the momentum equations,
c              ndimso = 1    for all other equations.
c     ni       number of gridpoints in x-direction.
c     nusol2   number of scalar unkowns for the solvers:
c              nusol2 = nusol*ndim   for momentum equation
c                     = nusol        for other equations
c              nusol2 = nusol*ndimso  for any equation
c     rho      Specific mass.
C
C     TSTFLO:
C
      LOGICAL TSTFLO
c
C  7. Common Blocks used
C
C     ---
c
C  8. Subroutines used
c
c     CGSTAB Computes the solution of an unsymmetric system of linear
c            equations. This is the Bi-CGSTAB method.
c     MKPREC Builds the preconditioner and if iinsol(2).eq.2 then
c            mkprec scales the matrix too.
c
      LOGICAL STPNOW                                                      34.01
C
C 10. Error messages
c
c     128 :  Nwork is too small.
c     129 :  This preconditioning is not allowed in this subroutine.
c            (Default values and user values are filled by ISSP06)
c     130 :  No convergence occured in the linear solver.
c
C 12. Structure
c
c     We start with a call to isextr, which initializes the starting
c     vector in work(1:nusol). If we use GMRES and iinsol(2).ne.0
c     then a call of mkprec builds a preconditioner. In the pressure
c     equation this should be done only the first time. Thereafter
c     the system of equations is solved. Finally if the iterative
c     method has converged the solution is copied from work(1:nusol)
c     into solut by a call of isputs.
c
c     Input:
c     The elements IINSOL(1:8,11:14), and RINSOL(1:7) must have got a value,
c     and the arrays GMAT, MATRIX, RHSIDE, INFMAT must have been filled.
c     The parameters ndefgd,nwork, must have an approptiate
c     value.
c
c     Output:
c     The elements IINSOL(9:10) provide information about the solution
c     process. The calculated solution vector is delivered in SOLUT. Additional
c     information, which is meant for research purposes only, might be
c     contained in the array WORK. The parameter nprec and the array
c     precon are filled. If iinsol(2).eq.2 then the matrix is scaled.
c
c     The routines ISEXTR and ISPUTS must be provided by the user.
c
C 13. Source text
C
      integer iinsol(*), nusol ,
     1        infmat(*), nwork, nprec, i   , INOCNV                       30.80
C
C
      REAL    matrix(*), rhside(*),
     1        precon(*), work(nwork), rinsol(*),
     2        solut(*) , upperi(*), loperi(*)
c
c     Local parameters:
c
      integer method, irrind, iprint, itmax, istop, iwarn, nusol2,
     1        icontr(9), lwork,ndim,ndimso,nconct,ni
c     integer ipstrt
      logical conv
C      REAL  eps1, eps2, eps3,rho,dt
      REAL  eps1, eps2
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'issolv')
c
c     *  fill ndim, ndimso, nusol2
C
      if ( infmat(4) .eq. 0 ) then
        ndim = 2
      else
        ndim = 3
      endif
c
      if ( infmat(1) .eq. 1 ) then
         ndimso = ndim
      else
         ndimso = 1
      end if
c
      nusol2 = nusol * ndimso
c
c     **  Initialization of constants.
c
      do i=1, 9
         icontr(i) = 0
      enddo
      iprint    = iinsol(8)
      itmax     = iinsol(6)
      eps1      = rinsol(1)
      eps2      = rinsol(2)
C      eps3      = rinsol(5)
      icontr(1) = iinsol(2)
      icontr(2) = iinsol(3)
      icontr(5) = iprint
      istop     = iinsol(5)
      iwarn     = iinsol(3)
      ni        = infmat(2)
      irrind = 0
      conv = .false.
      method = iinsol(7)
c
c     Preconditioning is allowed at this moment, abs(iconrt(1))
c     should be <= 2 for the momentum equations,
c               <= 3 for the other equations.
c     Moreover, in 3D case abs(icontr(1)) should be
c               <= 2 for the momentum equations,
c               <= 2 for the other equations.
c
      if (infmat(1).eq.1.and.(abs(icontr(1)).gt.2)
     1    .or.abs(icontr(1)).gt.3
     2    .or.ndim.eq.3.and.abs(icontr(1)).gt.2) then
         if (iwarn .ge. 0) then
           IF (INFMAT(1).EQ.4) THEN
             write (PRTEST,4000) ixcgrd(1)-1, iycgrd(1)-1
 4000        format(
     &       ' Error: preconditioner does not exist for grid point ',
     &       2I5)
             CALL MSGERR(4,'preconditioner does not exist')               34.01
           ELSE
             CALL MSGERR(4,'preconditioner for setup does not exist')     30.80
           ENDIF
         endif
         irrind = 1
         icontr(3) = 1
         goto 999
      end if
c
c     If ni = 2 then the ILU-preconditioning applied to the
c     pressure equations can give breakdown, because the
c     pressure equation is singular and for ni = 2 ILU is
c     equal to the LU-decomposition. In such a case we make
c     icontr(1) = -2.
c
      if (infmat(1).eq.4.and.abs(icontr(1)).eq.3
     1   .and.ni.eq.2) icontr(1) = -2
      call mkprec(matrix,nusol2,ndimso,nconct,precon,nprec,
     1            infmat,icontr(1))
      IF (STPNOW()) RETURN                                                34.01
      if (method .eq. 4 .and. iinsol(13).eq.0 ) then
c
c     Solve using Bi-CGSTAB.
c
         lwork = 10 * nusol2
         if (nwork .lt. lwork) then
            if (iwarn .ge. 0) then
              IF (INFMAT(1).EQ.4) THEN
                write (PRTEST,4010) ixcgrd(1)-1, iycgrd(1)-1              30.80
 4010           format(
     &          ' Error: insufficient memory for grid point ', 2I5)       30.80
                CALL MSGERR(4,'memory is too small for CGStab solver')    30.80
              ELSE
                CALL MSGERR(4,'memory is too small for CGStab solver')    30.80
              ENDIF
            endif
            icontr(3) = 2
         else
C
            tstflo = testfl                                               30.82
            testfl = .true.                                               30.82
            call cgstab(nusol2, matrix, rhside, solut, eps1,
     1         eps2, itmax, work(nusol2+1), work(2*nusol2+1),
     2         work(3*nusol2+1), work(4*nusol2+1), work(5*nusol2+1),
     3         work(6*nusol2+1), work(7*nusol2+1), icontr, infmat,
     4         precon, nprec, ndimso, nconct,upperi, loperi,              30.72
     5         NSTATC, ITSW, ITERSW)                                      30.72
            testfl = tstflo                                               30.82
         end if
      end if
c
c     end solve using Bi-CGSTAB.
c
 999  continue
c
c     Check for normal termination.
c
      irrind = irrind + icontr(3)
      if (icontr(3) .eq. 0) conv = .true.
      iinsol(9) = irrind
c
c     Copy solution from work(1:nusol2)
c     into it position in the second half of the space solut(*),
c     in case of convergence.
C
C     Initialisation of flag CSETUP
C
      CSETUP = .TRUE.
C
      if (conv) then
         iinsol(9)  = 0
         iinsol(10) = icontr(4)
      else
         IF (INFMAT(1).EQ.4) THEN                                         30.82
C
C        No convergence in spectral plane
C
           INOCNV = INOCNV + 1                                            30.82
           IF (ERRPTS.GT.0) WRITE(ERRPTS,7002) IXCGRD(1), IYCGRD(1), 2    30.80
 7002      FORMAT (I4, 1X, I4, 1X, I2)
           if ((istop .eq. 0).AND.(ITEST.GT.30)) then                     30.82
             WRITE (PRTEST,7005) IXCGRD(1)-1, IYCGRD(1)-1                 30.80
 7005        FORMAT(' No CGStab conv. in gridpoint (', 2I5,
     &       '); -> continue process')                                    40.00
           end if
         ELSE
C
C        No convergence for setup
C
           CSETUP = .FALSE.                                               30.82
           if ((istop .eq. 0).AND.(ITEST.GT.30)) then                     30.82
             WRITE (PRTEST,7007)                                          30.80
 7007        FORMAT(' No CGStab conv. in comp. of setup')                 30.80
           ENDIF
         ENDIF
      end if
C
      end
********************************************************************
*                                                                  *
      subroutine mkprec(matrix,nusol,ndimso,nconct,precon,
     2           nprec,infmat,mkind)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
C  0. Authors
C
C     34.01: IJsbrand Haagsma
C
C  1. Updates
C
C     34.01, Feb. 99: Changed STOP statement in a MSGERR(4,'message')
C                     call
c
C
c     programmer       Kees Vuik
c     version 1.2      date 24-11-1992  Kees V. dmlu works if ndim = 3.
c     version 1.1      date 04-08-1992  Zdenek:  ndimso instead of ndim
c     version 1.0      date 12-05-1992
c     developed at     Convex/HP700
c
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     The subroutine mkprec is used to build a preconditioner.
c
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c     infmat  i   Array which describes the structure of matrix.
c
c     matrix i/o  Double precision array in which the matrix of the
c                 linear system of equations is stored. In the case
c                 of mkind = 2 the matrix is scaled.
c
c     mkind   i   The kind of the preconditioner required.
c
c     nconct  i   The number of non-zero diagonals of MATRIX.
c
c     ndimso   i   The dimension of the space for the solver:
c                 ( ndimso = 1     for noncoupled equations,
c                   ndimso > 1     for coupled equations )
c
c     nprec   o   Maximum number of diagonals in PRECON.
c
c     nusol   i   The length of the solution vector.
c
c     precon  o   Double precision array in which a preconditioning
c                 matrix might be stored, of length NPREC * NUSOL. It is
c                 assumed that PRECON has a similar structure as MATRIX.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     ndim        Dimension of space.
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c     diag        builds the diagonal preconditioner.
c
c     dmlu        builds the ILUD preconditioner and scales the
c                 matrix for ndim = 2.
c
c     dmlu2       builds the ILUD preconditioner for ndim = 2.
c
c     dmlu3       builds the ILU preconditioner.
c
c     tmlu        builds the ILUD preconditioner for ndim = 3.
c
c     tmlu2       builds the ILUD preconditioner for ndim = 3.
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c ==================================================================
c
c     Parameters:
c
      integer          nusol,ndimso,nconct,nprec,infmat(*),mkind
      REAL  matrix(*), precon(*)
c
c     Local parameters:
c
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'mkprec')
c
      if(abs(mkind).eq.1) then
c
c        *** build the diagonal scaling preconditioning matrix
c
         nprec = 1
         call diag(matrix,nusol/ndimso,ndimso,nconct,
     1             precon,nprec,infmat(1))
c
c        *** end of the diagonal scaling
c
      endif
      if(abs(mkind).eq.2) then
        CALL MSGERR(4,'This precondioner does not exits')                 34.01
      endif
      if(abs(mkind).eq.3.and.infmat(1).ge.4) then
c
c     *** build an incomplete LU decomposition of A such that
c         the sparseness pattern of L and U is the same as A.
c
         nprec = nconct
         call dmlu3(matrix,nusol/ndimso,ndimso,nconct,
     1              precon,nprec,infmat)
c
c        *** end of the ILU3 decomposition
c
      endif
      end
********************************************************************
*                                                                  *
      subroutine prevc(n,x,b,matrix,ndim,nconct,precon,
     1           nprec,infmat,mkind)
*                                                                  *
********************************************************************
c
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
c
c     programmer       Kees Vuik
c     version 1.1      date 19-05-1992
c     developed at     Convex,HP700
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     Prevc multiplies the vector x with a preconditioner.
c
c ******************************************************************
c
c                       KEYWORDS
c
c     linear_solver
c     preconditioner
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
c
c     b       o   The output vector which is the preconditioner times
c                 the vector x.
c
c     infmat  i   Array which describes the structure of the matrix.
c
c     matrix  i   Double precision array in which the matrix of the
c                 linear system of equations is stored.
c
c     mkind   i   The kind of the preconditioner required.
c
c     n       i   The length of the solution vector.
c
c     nconct  i   The number of non-zero diagonals of MATRIX.
c
c     ndim    i   The dimension of the space (ndim =2 or 3).
c
c     nprec   i   Maximum number of diagonals in PRECON.
c
c     precon  i   Double precision array in which a preconditioning
c                 matrix might be stored, of length NPREC * NUSOL. It is
c                 assumed that PRECON has a similar structure as MATRIX.
c
c     x       i   The input vector.
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c     i       loop counter
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c     dcopy       Copy a vector in another vector.
c
c     diagmu      Computes the multiplication of a diagonal preconditioner
c                 stored in array precon and a vector.
c
c     dinvl       Computes the multiplication of the inverse of a lower
c                 triangular matrix stored in arrays matrix and precon
c                 and a vector. Precon should be filled by dmlu.f.
c
c     dinvl2      Computes the multiplication of the inverse of a lower
c                 triangular matrix stored in arrays matrix and precon
c                 and a vector. Precon should be filled by dmlu2.f.
c
c     dinvl3      Computes the multiplication of the inverse of a lower
c                 triangular matrix stored in array precon and a vector.
c                 Precon should be filled by dmlu3.f.
c
c     dinvu       Computes the multiplication of the inverse of an upper
c                 triangular matrix stored in arrays matrix and precon
c                 and a vector. Precon should be filled by dmlu.f.
c
c     dinvu2      Computes the multiplication of the inverse of an upper
c                 triangular matrix stored in arrays matrix and precon
c                 and a vector. Precon should be filled by dmlu2.f.
c
c     dinvu3      Computes the multiplication of the inverse of an upper
c                 triangular matrix stored in array precon and a vector.
c                 Precon should be filled by dmlu3.f.
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c     The subroutine prevc is used to multiply x with a preconditioner
c     and store the result in b. The choice of the preconditioner is
c     given by mkind.
c
c ==================================================================
c
c     Parameters:
c
      integer          n,ndim,nconct,nprec,infmat(*),mkind
C     INTEGER   I
      REAL  x(*),b(*),matrix(*), precon(*)
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'prevc')
c
      if(mkind.eq.0) then
c
c     *** no preconditioner is used
c
         call dcopy(n,x,1,b,1)
      endif
      if(abs(mkind).eq.1) then
c
c     *** use a diagonal scaling preconditioning matrix
c
         call diagmu(n,x,b,precon,nprec)
      endif
      if(abs(mkind).eq.3.and.infmat(1).ge.4) then
c
c     *** use an incomplete LU decomposition of A such that
c         the sparseness pattern of L and U is the same as A.
c
         call dinvl3(x,b,matrix,n/ndim,ndim,
     1               nconct,precon,nprec,infmat)
         call dinvu3(b,b,matrix,n/ndim,ndim,
     1               nconct,precon,nprec,infmat)
      endif
      return
      end
********************************************************************
*                                                                  *
      subroutine prires(text,rnorm,icontr,final)
*                                                                  *
********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
c
C  0. Authors
C
C      1.0 : Kees Vuik
C     30.82: IJsbrand Haagsma
C     40.13: Nico Booij
C
C  1. Updates
C
C     30.82, Sep. 98: Work with double precision to avoid underflows
C     30.82, Aug. 99: Explenation of error codes
C     40.13, Mar. 01: error messages reorganized
c
c     programmer
c     version          date
c
c
c ******************************************************************
c
c                       DESCRIPTION
c
c     This is an output subroutine. It prints the norm of the residual
c
c ******************************************************************
c
c                       KEYWORDS
c
c
c ******************************************************************
c
c                       INPUT / OUTPUT   PARAMETERS
c
C deleted by Ris (02-95):  implicit none
C
c
c ******************************************************************
c
c                       COMMON BLOCKS
c
c
c ******************************************************************
c
c                       LOCAL PARAMETERS
c
c ******************************************************************
c
c                       SUBROUTINES CALLED
c
c ******************************************************************
c
c                       I/O
c
c ******************************************************************
c
c                       ERROR MESSAGES
c
c ******************************************************************
c
c                       PSEUDO CODE
c
c ==================================================================
      character *(*) text
      integer icontr(9)
      logical final
      DOUBLE PRECISION  rnorm                                             30.82
      integer iter,iprint,ierr
c     integer  iout
c
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'prires')
C
      iter = icontr(4)
      iprint = icontr(2)
      ierr = icontr(3)
c      iout=icontr(5)
 
C
      if (iter .eq. 0) then
C         if (iprint .gt. 0) write(iout,100) text
C         if (iprint .eq. 1) write(iout,110) rnorm
C         if (iprint .ge. 2) write(iout,120)
        if (iprint .gt. 0) write(PRTEST,100) text
        if (iprint .eq. 1) write(PRTEST,110) rnorm
        if (iprint .ge. 2) write(PRTEST,120)
 100    format(//,' Output of subroutine ', a,// )
 110    format(' The 2-norm of the initial residual is:',D12.6)           30.82
 120    format(' Iteration number  residual' //)
      end if
      if (iprint .ge. 2) write(PRTEST,130) iter,rnorm
 130  format(i10,D15.2)                                                   30.82
c
      if (final) then
        if (iprint .ge. 0) then
          if (ierr .eq. 3) then                                           40.13
!           convergence error
            write(PRTEST,140) text,iter,ixcgrd(1)-1, iycgrd(1)-1          40.13
 140        format(1x,a,' No convergence in ',i5,' iterations ',          40.13
     &             'at point:',2i5)                                       40.13
          endif                                                           40.13
          IF (IERR.EQ.4) WRITE(PRTEST,144)                                30.82
 144        FORMAT(' Rnorm is less than roundoff error')                  30.82
        end if
        if (iprint .ge. 1) write(PRTEST,150) text,iter,rnorm
 150    format(' The number of executed iterations in ',a,
     1         ' is ',i5,/ ' The 2-norm of the residual is ',D12.6)       30.82
      end if
      return
      end
C
*********************************************************************
*                                                                   *
      subroutine vulmat ( n, nconct, a, infmat, upperi, loperi )
*                                                                   *
*********************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     | Delft University of Technology                            |
*     | Faculty of Applied Mathematics and Informatics            |
*     | P.O. Box 356,   2600 AJ  Delft, the Netherlands           |
*     |                                                           |
*     | Programmer  :  C. Vuik                                    |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      integer n, nconct, infmat(*), i, nx, n1
      REAL  a(n, nconct), upperi(*), loperi(*)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'VULMAT')
C
      nx = infmat(2)
      n1 = nx+1
      do i = 1, n
         a(i,1) = 4.0
      enddo
      do i = 1, n-1
         a(i+1,5) = -1.0
         a(i  ,6) = -1.0
      enddo
      do i = 1, n-n1
         a(i+n1,3) = -1.0
         a(i   ,8) = -1.0
      enddo
      do i = 1, n1
         upperi(i) = -0.5
         loperi(i) = -0.5
      end do
C
      IF ( TESTFL .AND. ITEST .GE. 120) THEN
        WRITE(PRTEST,*) ' subroutine vulmat '
        WRITE(PRTEST,123) NX, N1 , N
 123    FORMAT(' VULMAT : NX  N1  NTOT  :',3I4)
        WRITE(PRTEST,*)
     & '  NPP     (3)      (5)      (1)      (6)      (8) '
        DO IPP = 1 , N
            WRITE(PRTEST,3351) IPP, A(IPP,3),A(IPP,5), A(IPP,1),
     &                         A(IPP,6),A(IPP,8)
3351          FORMAT(I3,5E10.2)
        ENDDO
      ENDIF
      end
************************************************************************
*                                                                      *
      SUBROUTINE VULMT1  (NTOT    ,BAND    ,UPPERI  ,LOPERI  ,RHV     ,
     &                    IMATRA  ,IMATLA  ,IMATDA  ,IMATUA  ,IMAT5L  ,
     &                    IMAT6U  ,SECTOR  ,MDC     ,MSC     ,IDDLOW  ,
     &                    IDDTOP  ,ISSTOP  ,IDCMIN  ,IDCMAX  ,ANYBIN  ,
     &                    IDTOT   ,KCGRD   ,ICMAX                     )   30.21
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      INTEGER  IS      ,ID      ,MDC     ,MSC     ,NTOT    ,IDDLOW  ,
     &         IDDTOP  ,ISSTOP  ,IDDT    ,IDDL    ,NPP     ,IDSWAN  ,
     &         IDBAND  ,IDTOT   ,ICMAX                                    30.21
C
      INTEGER  SECTOR(MSC)      ,
     &         IDCMIN(MSC)      ,
     &         IDCMAX(MSC)      ,
     &         KCGRD(ICMAX)                                               30.21
C
      REAL     IMATRA(MDC,MSC)              ,
     &         IMATLA(MDC,MSC)              ,
     &         IMATDA(MDC,MSC)              ,
     &         IMATUA(MDC,MSC)              ,
     &         IMAT5L(MDC,MSC)              ,
     &         IMAT6U(MDC,MSC)              ,
     &         BAND(NTOT,9)                 ,
     &         RHV(NTOT)                    ,
     &         UPPERI(*)                    ,
     &         LOPERI(*)
C
      LOGICAL  ANYBIN(MDC,MSC)     ,
     &         PERIOD
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'VULMT1')
C
C     *** The first dimension of array , WORK, PRECON should be > N
C     *** The dimension of EXACT, RHV, SOLUT should be > N
C     *** The dimension of UPPERI, LOPERI should be > MSC
C
C     *** fill coefficients in diagonal matrix , RHV and SOLUT  ***
C
      DO IDDUM = IDDLOW, IDDTOP
C       *** counter for SWAN arrays ***
        IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
C       *** counter for arrays of solver ***
        IDBAND = MOD ( IDDUM - IDDLOW , MDC ) + 1
        DO IS = 1, ISSTOP
          NPP = (IDBAND - 1) * ISSTOP + IS
          IF (NPP.LT.1 .OR. NPP.GT.NTOT .OR. IDSWAN.LT.1 .OR.
     &         IDSWAN.GT.MDC .OR. IS.GT.MSC) WRITE (PRTEST,14)
     &         NPP, NTOT, IDBAND, IDSWAN, IDDLOW, IDDTOP, IS, ISSTOP
  14      FORMAT (' error VULMT1 ', 8I6)
          BAND(NPP,1)  = IMATDA(IDSWAN,IS)
          RHV(NPP)     = IMATRA(IDSWAN,IS)
        ENDDO
      ENDDO
C
C     *** fill lower and upper diagonal ( IMAT5L and IMAT6U )       ***
C     *** containing the coefficients of propagation in freq. space ***
C
      DO IDDUM = IDDLOW, IDDTOP
        IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
        DO IS = 1, ISSTOP
          NPP = (IDBAND - 1) * ISSTOP + IS
          BAND( NPP , 5 )  = IMAT5L(IDSWAN,IS)
          BAND( NPP , 6 )  = IMAT6U(IDSWAN,IS)
        ENDDO
      ENDDO
C
C     *** fill lower and upper diagonal: IMATLA(3) and IMATDA (8) ***
C     *** containing the coefficients propagation in theta space  ***
C
      DO IS = 1, ISSTOP
        PERIOD = .FALSE.
        IF ( SECTOR(IS) .EQ. 2 ) THEN
C
C         *** check is domain in directional space is periodic ***
C
          IF ( ANYBIN(1,IS) .AND. ANYBIN(MDC,IS) .AND.
     &         IDTOT .EQ. MDC ) PERIOD = .TRUE.
C
          DO IDDUM = IDDLOW, IDDTOP
            IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
            IDDL   =  MOD ( IDCMIN(IS) - 1 + MDC , MDC ) + 1
            IDDT   =  MOD ( IDCMAX(IS) - 1 + MDC , MDC ) + 1
            NPP = (IDBAND - 1) * ISSTOP + IS
            IF ( IDSWAN .EQ. MDC .AND. PERIOD ) THEN
              BAND(NPP , 3 )  = IMATLA(IDSWAN , IS)
              LOPERI(IS)      = IMATUA(IDSWAN , IS)
            ELSE IF ( IDSWAN .EQ. 1 .AND. PERIOD ) THEN
              BAND(NPP , 8 )  = IMATUA(IDSWAN , IS)
              UPPERI(IS)      = IMATLA(IDSWAN , IS)
            ELSE IF ( IDSWAN .EQ. IDDL ) THEN
              BAND(NPP , 8 )  = IMATUA(IDSWAN , IS)
            ELSE IF ( IDSWAN .EQ. IDDT ) THEN
              BAND(NPP , 3 )  = IMATLA(IDSWAN , IS)
            ELSE
              BAND(NPP , 3 )  = IMATLA(IDSWAN , IS)
              BAND(NPP , 8 )  = IMATUA(IDSWAN , IS)
            ENDIF
          ENDDO
        ELSE IF ( SECTOR(IS) .EQ. 1 .OR. SECTOR(IS) .EQ. 4 ) THEN
C
C         *** minimum counter = 1, maximum counter = MDC ***
C
          IF ( IDDLOW .NE. 1 .OR. IDDTOP .NE. MDC ) THEN
            WRITE(PRTEST,*) 'Error in VULMT1', IS, SECTOR(IS),            20.44
     &                      IDDLOW, IDDTOP                                20.44
          ENDIF
          DO IDDUM = IDDLOW, IDDTOP
            IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
            NPP = (IDBAND - 1) * ISSTOP + IS
            IF ( IDDUM .EQ. IDDLOW ) THEN
*             BAND(NPP , 8 )  = IMATUA(IDDUM , IS)             replaced
*             UPPERI(IS)      = IMATLA(IDDUM , IS)
              BAND(NPP , 8 )  = IMATUA(IDSWAN, IS)                        20.44
              UPPERI(IS)      = IMATLA(IDSWAN, IS)                        20.44
            ELSE IF ( IDDUM .EQ. IDDTOP) THEN
*             BAND(NPP , 3 )  = IMATLA(IDDUM , IS)             replaced
*             LOPERI(IS)      = IMATUA(IDDUM , IS)
              BAND(NPP , 3 )  = IMATLA(IDSWAN, IS)                        20.44
              LOPERI(IS)      = IMATUA(IDSWAN, IS)                        20.44
            ELSE
*             BAND(NPP , 3 )  = IMATLA(IDDUM , IS)             replaced
*             BAND(NPP , 8 )  = IMATUA(IDDUM , IS)
              BAND(NPP , 3 )  = IMATLA(IDSWAN, IS)                        20.44
              BAND(NPP , 8 )  = IMATUA(IDSWAN, IS)                        20.44
            ENDIF
          ENDDO
        ENDIF
C
C       *** test output ***
C
        IF ( TESTFL .AND. ITEST .GE. 120) THEN
          WRITE(PRTEST,*)
          WRITE(PRTEST,1056) IS, IDCMIN(IS), IDCMAX(IS), IDDLOW,
     &                       IDDTOP
 1056     FORMAT(' VULMT1: IS IDCMIN IDCMAX IDDLOW IDDTOP:',5I4)
          WRITE(PRTEST,1058) IDDL, IDDT, SECTOR(IS),IDTOT
 1058     FORMAT(' VULMT1: IDDL IDDT SECTOR IDTOT        :',4I4)
          WRITE(PRTEST,1059) ANYBIN(2,IS),ANYBIN(1,IS),
     &                       ANYBIN(MDC,IS),PERIOD
 1059     FORMAT(' VULMT1: ANYBIN  2   1   MDC  PERIOD   :',4L3)
          WRITE(PRTEST,1060) ANYBIN(1,IS),ANYBIN(MDC,IS),
     &                       ANYBIN(MDC-1,IS),PERIOD
 1060     FORMAT(' VULMT1: ANYBIN  1  MDC   MDC-1  PERIOD:',4L3)
        ENDIF
C
      ENDDO
C
C     *** information about SWAN matrices and SOLBAND matrices ***
C
      IF ( TESTFL .AND. ITEST .GE. 120) THEN
        WRITE(PRTEST,*)
        WRITE(PRTEST,*) '  Subroutine VULMT1'
        WRITE(PRTEST,*)
        WRITE(PRTEST,111) KCGRD(1),MDC, MSC                               30.21
 111    FORMAT(' VULMT1 : POINT MDC MSC              :',3I5)
        WRITE(PRTEST,211) IDDLOW, IDDTOP, ISSTOP
 211    FORMAT(' VULMT1 : IDDLOW IDDTOP ISSTOP       :',3I4)
        WRITE(PRTEST,*)
        WRITE(PRTEST,*) ' matrix coefficients in SWAN  '
        WRITE(PRTEST,*)
        WRITE(PRTEST,*)
     & 'IS ID IDB  IMATLA   IMATDA   IMATUA    IMATRA   IMAT5L   IMAT6U'
        DO IDDUM = IDDLOW, IDDTOP
          ID     = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
           DO IS = 1, ISSTOP
            WRITE(PRTEST,2101) IS, ID , IDBAND, IMATLA(ID,IS),
     &                         IMATDA(ID,IS), IMATUA(ID,IS),
     &                         IMATRA(ID,IS), IMAT5L(ID,IS),
     &                         IMAT6U(ID,IS)
2101        FORMAT(3I3,6E10.2)
          ENDDO
          WRITE(PRTEST,*)
        ENDDO
        WRITE(PRTEST,*)
        WRITE(PRTEST,*) ' matrix coefficients for CGSTAB solver'
        WRITE(PRTEST,*)
        WRITE(PRTEST,*)
     & 'IS ID IDB     (3)     (5)       (1)      (6)      (8)      RHV'
        DO IDDUM = IDDLOW, IDDTOP
          IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
          DO IS = 1, ISSTOP
            IPP = ( IDBAND - 1 ) * ISSTOP + IS
            WRITE(PRTEST,3101) IS ,IDSWAN ,IDBAND, BAND(IPP,3),
     &                        BAND(IPP,5), BAND(IPP,1), BAND(IPP,6),
     &                        BAND(IPP,8), RHV(IPP)
3101        FORMAT(3I3,6E10.2)
          ENDDO
          WRITE(PRTEST,*)
        ENDDO
        WRITE(PRTEST,*)'IS ID      LPER     UPER '
        DO IDDUM = IDDLOW, IDDTOP
          IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
          IF ( IDSWAN .EQ. 1  .OR. IDSWAN .EQ. MDC ) THEN
            DO IS = 1, ISSTOP
              IPP = ( IDBAND - 1 ) * ISSTOP + IS
              WRITE(PRTEST,3141) IS ,IDSWAN , LOPERI(IS),
     &                           UPPERI(IS)
3141          FORMAT(2I3,2E10.2)
            ENDDO
          END IF
        ENDDO
      END IF
C
      RETURN
      END
C
C**********************************************************************
C*                                                                    *
      SUBROUTINE SWCOVA2D ( MXC, MYC, XCG, YCG, CVA )
C*                                                                    *
C**********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     31.00  Kees Kassels
C     31.03  Annette Kieftenburg
C
C  1. Updates
C
C  version 1.0    date 09-09-1997
C
C  2. Purpose
C
C    Compute covariant base vectors in integration points
C    two-dimensional case
C
C  3. Method
C
C     The covariant basis vectors are given by:
C      alpha                    beta
C     a       = dx       / d xsi       = cva ( i, j, alpha, beta, k )
C      (beta)     alpha
C
C     i,j refers to the cell index and k (pnttyp) to the position of the point
C     in a cell
C
C     To evaluate the base vectors a central difference formula is applied
C
C     This leads to:
C
C     pnttype                 d/dksi1                  d/dksi2
C
C        1             x(i+1,j)-x(i,j)            (x(i+1,j+1)-x(i+1,j-1))/4+
C                                                 (x(i,j+1)-x(i,j-1))/4
C        2         (x(i+1,j+1)-x(i-1,j+1))/4+      x(i,j+1)-x(i,j)
C                    (x(i+1,j)-x(i-1,j))/4
C
C
C      *-----------*
C      |           |
C      2           |
C      |           |
C      |           |
C      *--- 1------*
C
C
C  4. Argument variables
C
C     CVA       o    Array containing the covariant basis vectors
C                    in 2D we have
C                                                 l
C                    cva(i,j,l,alpha,p) contains a        in cell i,j in
C                                                 (alpha)       point type p
C     MXC       i    Number of points in the x-direction
C     MYC       i    Number of points in the y-direction
C     XCG       i    x-coordinates
C     YCG       i    y-coordinates
C
      IMPLICIT NONE
      INTEGER MXC, MYC
      REAL    XCG(1:MXC,1:MYC),                                           31.03
     +        YCG(1:MXC,1:MYC),
     +        CVA(1:MXC,1:MYC,1:2,1:2,1:2)
C
C  5. Parameter variables
C
C  6. Local variables
C
C     I         General loop variable
C     J         General loop variable
C
      INTEGER I, J
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C **********************************************************************
C                       KEYWORDS
C    base_vectors
C    interpolation
C
C **********************************************************************
C
C     --- pnttype = 1:    x(i+1,j)-x(i,j)
C                        (x(i+1,j+1)-x(i+1,j-1))/4+(x(i,j+1)-x(i,j-1))/4
C
C         --- whole area
C
      DO J = 1, MYC
         DO I = 1, MXC-1
            CVA(I,J,1,1,1) = XCG(I+1,J)-XCG(I,J)
            CVA(I,J,2,1,1) = YCG(I+1,J)-YCG(I,J)
         END DO
      END DO
C
C     --- inner area
C
      DO J = 2, MYC-1
         DO I = 1, MXC-1
            CVA(I,J,1,2,1) = 0.25E0 * ( XCG(I+1,J+1)-XCG(I+1,J-1)+
     +                                  XCG(I  ,J+1)-XCG(I  ,J-1) )
            CVA(I,J,2,2,1) = 0.25E0 * ( YCG(I+1,J+1)-YCG(I+1,J-1)+
     +                                  YCG(I  ,J+1)-YCG(I  ,J-1) )
         END DO
      END DO
C
C     --- lower boundary
C
      J = 1
      DO I = 1, MXC-1
         CVA(I,J,1,2,1) = 0.25E0 * ( XCG(I+1,J+1)-
     +                              (2E0*XCG(I+1,J)-XCG(I+1,J+1)) +
     +                               XCG(I  ,J+1)-
     +                              (2E0*XCG(I  ,J)-XCG(I  ,J+1)) )
         CVA(I,J,2,2,1) = 0.25E0 * ( YCG(I+1,J+1)-
     +                              (2E0*YCG(I+1,J)-YCG(I+1,J+1)) +
     +                               YCG(I  ,J+1)-
     +                              (2E0*YCG(I  ,J)-YCG(I  ,J+1)) )
      END DO
C
C     --- upper boundary
C
      J = MYC
      DO I = 1, MXC-1
         CVA(I,J,1,2,1) = 0.25E0 * ((2E0*XCG(I+1,J)-XCG(I+1,J-1)) -
     +                               XCG(I+1,J-1)                 +
     +                              (2E0*XCG(I  ,J)-XCG(I  ,J-1)) -
     +                               XCG(I  ,J-1) )
         CVA(I,J,2,2,1) = 0.25E0 * ((2E0*YCG(I+1,J)-YCG(I+1,J-1)) -
     +                               YCG(I+1,J-1)                 +
     +                              (2E0*YCG(I  ,J)-YCG(I  ,J-1)) -
     +                               YCG(I  ,J-1) )
      END DO
C
C     --- pnttype = 2:  (x(i+1,j+1)-x(i-1,j+1))/4+(x(i+1,j)-x(i-1,j))/4
C                        x(i,j+1)-x(i,j)
C
C         --- whole area
C
      DO J = 1, MYC-1
         DO I = 1, MXC
            CVA(I,J,1,2,2) = XCG(I,J+1)-XCG(I,J)
            CVA(I,J,2,2,2) = YCG(I,J+1)-YCG(I,J)
         END DO
      END DO
C
C     --- inner area
C
      DO J = 1, MYC-1
         DO I = 2, MXC-1
            CVA(I,J,1,1,2) = 0.25E0 * ( XCG(I+1,J+1)-XCG(I-1,J+1)+
     +                                  XCG(I+1,J  )-XCG(I-1,J  ) )
            CVA(I,J,2,1,2) = 0.25E0 * ( YCG(I+1,J+1)-YCG(I-1,J+1)+
     +                                  YCG(I+1,J  )-YCG(I-1,J  ) )
         END DO
      END DO
C
C     --- left boundary
C
      I = 1
      DO J = 1, MYC-1
         CVA(I,J,1,1,2) = 0.25E0 * ( XCG(I+1,J+1)-
     +                              (2E0*XCG(I,J+1)-XCG(I+1,J+1)) +
     +                               XCG(I+1,J  )-
     +                              (2E0*XCG(I  ,J)-XCG(I+1,J  )) )
         CVA(I,J,2,1,2) = 0.25E0 * ( YCG(I+1,J+1)-
     +                              (2E0*YCG(I,J+1)-YCG(I+1,J+1)) +
     +                               YCG(I+1,J  )-
     +                              (2E0*YCG(I  ,J)-YCG(I+1,J  )) )
      END DO
C
C     --- right boundary
C
      I = MXC
      DO J = 1, MYC-1
         CVA(I,J,1,1,2) = 0.25E0 * ((2E0*XCG(I,J+1)-XCG(I-1,J+1)) -
     +                               XCG(I-1,J+1)                 +
     +                              (2E0*XCG(I  ,J)-XCG(I-1,J  )) -
     +                               XCG(I-1,J  ) )
         CVA(I,J,2,1,2) = 0.25E0 * ((2E0*YCG(I,J+1)-YCG(I-1,J+1)) -
     +                               YCG(I-1,J+1)                 +
     +                              (2E0*YCG(I  ,J)-YCG(I-1,J  )) -
     +                               YCG(I-1,J  ) )
      END DO
C
      END
C
C**********************************************************************
C*                                                                    *
      SUBROUTINE SWJCTA2D ( MXC, MYC, CVA, JCTA )
C*                                                                    *
C**********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     31.00  Kees Kassels
C     31.03  Annette Kieftenburg
C
C  1. Updates
C
C     version 1.0    date 10-09-1997
C
C  2. Purpose
C
C    Compute sqrt(g) x contra variant base vectors in integration point
C    two-dimensional case
C
C  3. Method
C
C     sqrt(g) x contravariant base vector in 2D is given by:
C
C              (1)     2                    (2)      2
C     sqrt(g) a     = a            sqrt(g) a     = -a
C              1       (2)                  1        (1)
C
C              (1)     1                    (2)      1
C     sqrt(g) a     =-a            sqrt(g) a     =  a
C              2       (2)                  2        (1)
C
C  4. Argument variables
C
C     cva       i    Array containing the covariant basis vectors
C                    in 2D we have
C                                                 l
C                    cva(i,j,l,alpha,p) contains a        in cell i,j in
C                                                 (alpha)       point type p
C     jcta      o    Jacobian times contravariant basis vectors
C                    in point pnttyp=1 base vector 1
C                    in point pnttyp=2 base vector 2
C     MXC       i    Number of points in the x-direction
C     MYC       i    Number of points in the y-direction
C
      IMPLICIT NONE
      INTEGER MXC, MYC
      REAL    CVA(1:MXC,1:MYC,2,2,2)                                      31.03
      REAL   JCTA(1:MXC,1:MYC,2,2)                                        31.03
C
C  5. Parameter variables
C
C  6. Local variables
C
C     I         General loop variable
C     J         General loop variable
      INTEGER I, J
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C **********************************************************************
C
C                       KEYWORDS
C
C    base_vectors
C    interpolation
C **********************************************************************
C
C     --- alphad = 1, means pointtype = 1, contravariant base vector 1
C
      DO J = 1, MYC
         DO I = 1, MXC-1
            JCTA(I,J,1,1) = CVA(I,J,2,2,1)
            JCTA(I,J,2,1) = -CVA(I,J,1,2,1)
         END DO
      END DO
C
C     --- alphad = 2, means pointtype = 2, contravariant base vector 2
C
      DO J = 1, MYC-1
         DO I = 1, MXC
            JCTA(I,J,1,2) = -CVA(I,J,2,1,2)
            JCTA(I,J,2,2) = CVA(I,J,1,1,2)
         END DO
      END DO
C
      END
C
C **********************************************************************
C                                                                      *
      SUBROUTINE SWTRAD2D ( MXC, MYC, WFRCX, WFRCY, DEPMIN,               31.03
     +                      ALPHAD, DEPTH, CVA, JCTA, CVC, CTC,           31.03
     +                      DTSUM, RHSIDE)
C                                                                      *
C **********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     31.03  Annette Kieftenburg
C
C  1. Updates
C
C     --
C
C  2. Purpose
C
C     Compute contribution of diffusion term in R2 for a transport equation
C     per integration point
C     Compute righthandside
C
C  3. Method (updated...)
C
C      The diffusion terms in the WesBeek discretization are given by
C
C
C                   (a)  (b)     |+e(a)/2
C          sqrt(g) a   .C    T,  |
C                  -    -      b |-e(a)/2
C
C             (b)
C      where C    are the so-called WesBeek vectors defined in the following
C            -
C      way:
C
C      In principle, we want to approximate, for example, the following
C      diffusion term
C
C                (1)    _
C       sqrt(g) a   . k VT  in point (i+1/2,j)
C               -
C            _          1       2                          (1)
C      where VT = (dT/dx , dT/dx  ) and note that sqrt(g) a
C                                                         -
C                          1
C      is continue along xi  = constant.
C
C
C        |(i+1,j)         _        _
C      T |           = S  VT dx =  VT|           . S  dx
C        |(i,j)               -       (i+1/2,j)        -
C
C      (note: S is denoted as a integral!)
C
C      The last integral can be approximated as follows:
C
C
C
C      C    = S  dx  =   a     |
C      -(1)       -      -(1)    (i,j)
C
C      In order to find one more equation, another integration path has
C      to be taken. With this, we can calculate the other covariant WesBeek
C      vector. These are:
C
C
C
C      C    =    a                +  a             +
C      -(2)      -(2) |  (i,j-1 )    -(2) | (i,j )
C
C
C                a                +   a
C                -(2) | (i+1,j-1)     -(2) |(i+1,j)
C
C                                 _
C      Solving two equations for  VT results in
C
C       _                 (a)
C       VT|            = C    T   |
C          (i+1/2,j)     -     ,a  (i+1/2,j)
C                                                  (a)
C      Finally, the contravariant WesBeek vectors C    can be computed
C                                                 -
C      with the following formulae
C
C
C       (1)    1    2       1   T       (2)    1     2     1    T
C      C     = - ( C    , -C   )     C     =  - ( -C   ,  C   )
C      -       C    (2)     (2)      -               (1)    (1)
C
C
C                2    1        2    1
C      with C = C    C     -  C    C
C                (1)   (2)     (1)  (2)
C
C
C  4. Argument variables
C
C     ALPHAD    i    Direction index of integration.
C     CTC       i    Work array containing the contravariant WESBEEK vectors
C     CVA       o    Array containing the covariant basis vectors
C                    in 2D we have
C                                                 l
C                    CVA(i,j,l,alpha,p) contains a        in cell i,j in
C                                                 (alpha)       point type p
C     CVC       i    Work array containing the covariant WESBEEK vectors
C     DEPMIN    i    Minimum depth
C     DEPTH     i    depth direct addressed                               31.03
C     DTSUM     o    Derivative contributions to the matrix
C     JCTA      i    Jacobian times contravariant basis vectors
C                    in point pnttyp=1 base vector 1
C                    in point pnttyp=2 base vector 2
C     MXC       i    Number of points in the x-direction
C     MYC       i    Number of points in the y-direction
C     RHSIDE    o    Righthandside
C     WFRCX     i    force x-component direct addressed                   31.03
C     WFRCY     i    force y-component direct addressed                   31.03
C
      IMPLICIT NONE
      INTEGER ALPHAD, MXC, MYC                                            31.03
      REAL   CTC(1:MXC, 1:MYC,2,2),
     +       CVA(1:MXC, 1:MYC,2,2,2),
     +       CVC(1:MXC, 1:MYC,2,2),
     +    DEPMIN,                                                         31.03
     +     DEPTH(1:MXC, 1:MYC),                                           31.03
     +     DTSUM(1:MXC, 1:MYC,2),
     +      JCTA(1:MXC, 1:MYC,2,2),
     +    RHSIDE(1:MXC, 1:MYC),
     +     WFRCX(1:MXC, 1:MYC),                                           31.03
     +     WFRCY(1:MXC, 1:MYC)                                            31.03
 
C
C  5. Parameter variables
C
C  6. Local variables
C
C     BETAD     Direction index, usually the direction perpendicular to the
C               integration direction of the boundary integral.
C               For example betad in local point (1,0) is 1 and in (0,1): 2
C     DET       Determinant
C     DX        Point location in cell relative to local
C               coordinates with (0,0) and (2,2) or
C               (0,0,0) and (2,2,2) as opposite cell corners
C     FACT1     Help factor for computing integration path
C     FACT2     Help factor for computing integration path
C     FACT3     Help factor for computing integration path
C     FACT4     Help factor for computing integration path
C     FACTOR    Help factor
C     GAMMAD    Direction index
C     I         General loop variable
C     IP        Local counting variable i-direction
C     IPAREA    Area of integration points where a contribution to
C               the matrix is to be calculated
C     IP1       Shift for boundaries 1 and 2
C     IP2       Shift for boundaries 3 and 4
C     JP        Local counting variable j-direction
C
      INTEGER BETAD, DX(2,2), GAMMAD, I, IP, IPAREA(2,2),
     +        IP1, IP2, JP
      REAL    DET, FACTOR, FACT1, FACT2, FACT3, FACT4                     31.03
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C                       KEYWORDS
C
C     coefficients
C     discretization
C     transport_matrix
C **********************************************************************
C
C     --- Wesbeek discretization
C
      IF ( ALPHAD.EQ.1 ) THEN
         IPAREA(1,1) = 1
         IPAREA(2,1) = MXC-1
         IPAREA(1,2) = 1
         IPAREA(2,2) = MYC
      ELSE
         IPAREA(1,1) = 1
         IPAREA(2,1) = MXC
         IPAREA(1,2) = 1
         IPAREA(2,2) = MYC-1
      END IF
C
      DX(1,1)      =  0
      DX(1,2)      =  0
      DX(1,ALPHAD) =  1
C
      DO BETAD = 1, 2
         DO GAMMAD = 1, 2
            DX(2,1)      =  0
            DX(2,2)      =  0
            DX(2,GAMMAD) =  1
C
C           --- INNER AREA
C
            IF ( GAMMAD.EQ.ALPHAD ) THEN
C
               DO JP = IPAREA(1,2), IPAREA(2,2)
                  DO IP = IPAREA(1,1), IPAREA(2,1)
                     CVC(IP,JP,BETAD,GAMMAD) =
     +                            CVA(IP,JP,BETAD,GAMMAD,ALPHAD)
                  END DO
               END DO
C
            ELSE
C
            IP1 = 0
            IP2 = 0
            IF ( ALPHAD.EQ.1 ) THEN
               IP1 = 1
            ELSE
               IP2 = 1
            END IF
C
               DO JP = IPAREA(1,2)+IP1, IPAREA(2,2)-IP1
                  DO IP = IPAREA(1,1)+IP2, IPAREA(2,1)-IP2
C
                     FACT1 = 1E0
                     FACT2 = 1E0
                     FACT3 = 1E0
                     FACT4 = 1E0
                     IF(DEPTH(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT1 = 0E0
                     IF(DEPTH(IP+DX(1,1)+DX(2,1),JP+DX(1,2)+DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT2 = 0E0
                     IF(DEPTH(IP        -DX(2,1),JP        -DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT3 = 0E0
                     IF(DEPTH(IP        +DX(2,1),JP        +DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
C
     +               FACT4 = 0E0
C
                     CVC(IP,JP,BETAD,GAMMAD) =
     +            FACT1*CVA(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2),
     +                  BETAD,GAMMAD,3-ALPHAD)
     +
     +           +FACT2*CVA(IP+DX(1,1)        ,JP+DX(1,2)        ,
     +                  BETAD,GAMMAD,3-ALPHAD)
     +
     +           +FACT3*CVA(IP        -DX(2,1),JP        -DX(2,2),
     +                  BETAD,GAMMAD,3-ALPHAD)
     +
     +           +FACT4*CVA(IP,JP,BETAD,GAMMAD,3-ALPHAD)
C
                  END DO
               END DO
C
            END IF
C
C           --- BOUNDARY ONE
C               --- at the boundary we deal with half a cell : fact=5e-1
C
            IF ( ALPHAD.EQ.2 ) THEN
C
               IF ( GAMMAD.NE.ALPHAD ) THEN
C
                  IP = 1
                  DO JP = 1, MYC-1
                     FACT2 = 2E0
                     FACT4 = 2E0
                     IF(
     +               DEPTH(IP+DX(1,1)+DX(2,1),JP+DX(1,2)+DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT2 = 0E0
                     IF(
     +               DEPTH(IP        +DX(2,1),JP        +DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT4 = 0E0
C
                     CVC(IP,JP,BETAD,GAMMAD) =
     +           +FACT2*CVA(IP+DX(1,1)        ,JP+DX(1,2)        ,
     +                  BETAD,GAMMAD,3-ALPHAD)
     +
     +           +FACT4*CVA(IP,JP,BETAD,GAMMAD,3-ALPHAD)
                  END DO
C
               END IF
C
            END IF
C
C           --- BOUNDARY TWO
C
            IF ( ALPHAD.EQ.2 ) THEN
C
               IF ( GAMMAD.NE.ALPHAD ) THEN
C
                  IP = MXC
                  DO JP = 1, MYC-1
                     FACT1 = 2E0
                     FACT3 = 2E0
                     IF(
     +               DEPTH(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT1 = 0E0
                     IF(
     +               DEPTH(IP        -DX(2,1),JP        -DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT3 = 0E0
C
                     CVC(IP,JP,BETAD,GAMMAD) =
     +            FACT1*CVA(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2),
     +                  BETAD,GAMMAD,3-ALPHAD)
C
     +           +FACT3*CVA(IP        -DX(2,1),JP        -DX(2,2),
     +                  BETAD,GAMMAD,3-ALPHAD)
                   END DO
C
               END IF
C
            END IF
C
C           --- BOUNDARY THREE
C
            IF ( ALPHAD.EQ.1 ) THEN
C
               IF ( GAMMAD.NE.ALPHAD ) THEN
C
                  JP = 1
                  DO IP = 1, MXC-1
                     FACT2 = 2E0
                     FACT4 = 2E0
                     IF(
     +               DEPTH(IP+DX(1,1)+DX(2,1),JP+DX(1,2)+DX(2,2))
     +                    .LT.DEPMIN)                                       31.03
     +               FACT2 = 0E0
                     IF(
     +               DEPTH(IP        +DX(2,1),JP        +DX(2,2))
     +                    .LT.DEPMIN)                                       31.03
     +               FACT4 = 0E0
C
                     CVC(IP,JP,BETAD,GAMMAD) =
     +            FACT2*CVA(IP+DX(1,1)        ,JP+DX(1,2)        ,
     +                  BETAD,GAMMAD,3-ALPHAD)
     +
     +           +FACT4*CVA(IP,JP,BETAD,GAMMAD,3-ALPHAD)
                 END DO
C
               END IF
C
            END IF
C
C           --- BOUNDARY FOUR
C
            IF ( ALPHAD.EQ.1 ) THEN
C
               IF ( GAMMAD.NE.ALPHAD ) THEN
C
                  JP = MYC
                  DO IP = 1, MXC-1
                     FACT1 = 2E0
                     FACT3 = 2E0
                     IF(
     +               DEPTH(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT1 = 0E0
                     IF(
     +               DEPTH(IP        -DX(2,1),JP        -DX(2,2))
     +                  .LT.DEPMIN)                                       31.03
     +               FACT3 = 0E0
C
                        CVC(IP,JP,BETAD,GAMMAD) =
     +            FACT1*CVA(IP+DX(1,1)-DX(2,1),JP+DX(1,2)-DX(2,2),
     +                     BETAD,GAMMAD,3-ALPHAD)
     +           +FACT3*CVA(IP        -DX(2,1),JP        -DX(2,2),
     +                     BETAD,GAMMAD,3-ALPHAD)
                   END DO
C
               END IF
C
            END IF
C
         END DO
      END DO
C
C     --- Determine contravariant WESBEEK vectors
C
      DO JP=IPAREA(1,2), IPAREA(2,2)
         DO IP=IPAREA(1,1), IPAREA(2,1)
C
            IF ( DEPTH(IP,JP).LT.DEPMIN .OR.                              31.03
     +           DEPTH(IP+DX(1,1),JP+DX(1,2)).LT.DEPMIN) THEN             31.03
C
C           --- non existent neighbour, no contribution from this
C               integration point, making ctc = 0e0, which gives
C               also dtsum = 0e0
C
               CTC(IP,JP,1,1) =  0E0
               CTC(IP,JP,2,1) =  0E0
               CTC(IP,JP,1,2) =  0E0
               CTC(IP,JP,2,2) =  0E0
C
            ELSE
C
C           --- First, calculate determinant ...
C
               DET = CVC(IP,JP,1,1)*CVC(IP,JP,2,2) -
     +               CVC(IP,JP,2,1)*CVC(IP,JP,1,2)
C
C              --- THEN contravariant WESBEEK vectors
C
               IF ( DET .LE. 0) THEN
 
                  CTC(IP,JP,1,1) =  0E0
                  CTC(IP,JP,2,1) =  0E0
                  CTC(IP,JP,1,2) =  0E0
                  CTC(IP,JP,2,2) =  0E0
               ELSE
                  CTC(IP,JP,1,1) =  CVC(IP,JP,2,2)/DET
                  CTC(IP,JP,2,1) = -CVC(IP,JP,1,2)/DET
                  CTC(IP,JP,1,2) = -CVC(IP,JP,2,1)/DET
                  CTC(IP,JP,2,2) =  CVC(IP,JP,1,1)/DET
               END IF
C
            END IF
C
         END DO
      END DO
C
C     --- initialize DTSUM
C
      DO I = 1, 2
         DO JP = IPAREA(1,2), IPAREA(2,2)
            DO IP = IPAREA(1,1), IPAREA(2,1)
               DTSUM(IP,JP,I) = 0E0
            END DO
         END DO
      END DO
C
      DO BETAD = 1, 2
C
         DO JP = IPAREA(1,2), IPAREA(2,2)
            DO IP = IPAREA(1,1), IPAREA(2,1)
C
               DO I = 1, 2
                  DTSUM(IP,JP,BETAD) = DTSUM(IP,JP,BETAD) -
     +                                 5E-1*(DEPTH(IP,JP) +
     +                                 DEPTH(IP+DX(1,1),JP+DX(1,2)) ) *   31.03
     +                                 CTC(IP,JP,I,BETAD)*
     +                                 JCTA(IP,JP,I,ALPHAD)
               END DO
C
            END DO
         END DO
C
      END DO
C
C     --- righthandside inner area
C
      IP1 = 0
      IP2 = 0
      IF ( ALPHAD.EQ.1 ) THEN
         IP1 = 1
      ELSE
         IP2 = 1
      END IF
C
      DO JP = IPAREA(1,2)+IP1, IPAREA(2,2)-IP1
         DO IP = IPAREA(1,1)+IP2, IPAREA(2,1)-IP2
C
            IF ( DEPTH(IP,JP).LT.DEPMIN .OR.                              31.03
     +           DEPTH(IP+DX(1,1),JP+DX(1,2)).LT.DEPMIN ) THEN            31.03
C
C           --- non existent neighbour, no contribution from this
C               integration point
C
               FACTOR = 0E0
            ELSE
               FACTOR = 5E-1*(-WFRCX(IP,JP) -                             31.03 -
     +                        WFRCX(IP+DX(1,1),JP+DX(1,2)) ) *            31.03 -
     +                        JCTA(IP,JP,1,ALPHAD) +
     +                  5E-1*(-WFRCY(IP,JP) -                             31.03 -
     +                        WFRCY(IP+DX(1,1),JP+DX(1,2)) ) *            31.03 -
     +                        JCTA(IP,JP,2,ALPHAD)
 
            END IF
            RHSIDE(IP,JP) = RHSIDE(IP,JP) + FACTOR
            RHSIDE(IP+DX(1,1),JP+DX(1,2)) =
     +         RHSIDE(IP+DX(1,1),JP+DX(1,2)) - FACTOR
         END DO
      END DO
C
 
C     --- righthandside  boundary : values * 5e-1, because of half cells
C
       IF ( ALPHAD .EQ. 1) THEN
C
        DO JP = 1, MYC, MYC-1
           DO IP = 1, MXC-1
 
              IF ( DEPTH(IP,JP).LT.DEPMIN .OR.                            31.03
     +             DEPTH(IP+DX(1,1),JP+DX(1,2)).LT.DEPMIN ) THEN          31.03
C
C             --- non existent neighbour, no contribution from this
C                 integration point
C
                 FACTOR = 0E0
              ELSE
                 FACTOR = 25E-2*(-WFRCX(IP,JP) -                          31.03 -
     +                           WFRCX(IP+DX(1,1),JP+DX(1,2)) ) *         31.03 -
     +                           JCTA(IP,JP,1,ALPHAD) +
     +                    25E-2*(-WFRCY(IP,JP) -                          31.03 -
     +                           WFRCY(IP+DX(1,1),JP+DX(1,2)) ) *         31.03 -
     +                           JCTA(IP,JP,2,ALPHAD)
              END IF
C
              RHSIDE(IP,JP) = RHSIDE(IP,JP) + FACTOR
              RHSIDE(IP+DX(1,1),JP+DX(1,2)) =
     +           RHSIDE(IP+DX(1,1),JP+DX(1,2)) - FACTOR
            END DO
        END DO
 
       ELSE
C
         DO JP = 1, MYC-1
            DO IP = 1, MXC, MXC-1
 
               IF ( DEPTH(IP,JP).LT.DEPMIN .OR.                           31.03
     +              DEPTH(IP+DX(1,1),JP+DX(1,2)).LT.DEPMIN) THEN          31.03
C
C             --- non existent neighbour, no contribution from this
C                 integration point
C
                  FACTOR = 0E0
               ELSE
                  FACTOR = 25E-2*(-WFRCX(IP,JP) -                         31.03 -
     +                           WFRCX(IP+DX(1,1),JP+DX(1,2)) ) *         31.03 -
     +                           JCTA(IP,JP,1,ALPHAD) +
     +                     25E-2*(-WFRCY(IP,JP) -                         31.03 -
     +                           WFRCY(IP+DX(1,1),JP+DX(1,2)) ) *         31.03 -
     +                           JCTA(IP,JP,2,ALPHAD)
               END IF
               RHSIDE(IP,JP) = RHSIDE(IP,JP) + FACTOR
               RHSIDE(IP+DX(1,1),JP+DX(1,2)) =
     +            RHSIDE(IP+DX(1,1),JP+DX(1,2)) - FACTOR
             END DO
         END DO
      END IF
C
      END
C
C**********************************************************************
C*                                                                    *
      SUBROUTINE SWDISDT2 ( MXC, MYC, DEPTH, DEPMIN, ALPHAD, MATRIX,
     +                      DTSUM )                                       31.03
C*                                                                    *
C**********************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     31.00  Kees Kassels
C     31.03  Annette Kieftenburg
C
C  1. Updates
C
C     version 1.0    date   26-08-1997
C
C  2. Purpose
C
C     Distribute diffusion term for tranport equation in R2
C
C  3. Method
C
C    In DTSUM the contribution to the matrix is stored per
C    integration point. Take for example integration point IP.
C    The value dtsum(i,j,1) has to be given
C    to the matrix points 1 and 2. The value dtsum(i,j,2) has to be given
C    to the matrix points 3, 4, 5 and 6.
C    The value per integration point is used for two cells at the same
C    time, for the left cell with A  + SIG, for the rigth cell
C    with A  - SIG.
C
C                         4           3
C            *-----------*-----------*
C            |           |           |
C            |       _ _ |_ _  _ _ _ |
C            |      |    |    |      |
C            |      |    |2   |      |1
C            *------|----*--- IP-----*
C            |      |    |    |      |
C            |      |_ __|__ _|_ _ _ |
C            |           |           |
C            |           |6          |5
C            *-----------*-----------*
C
C
C    As the unknowns per cell are numbered as follows
C
C             7           8           9
C            *-----------*-----------*
C            |           |           |
C            |       _ _ |_ _  _ _ _ |
C            |      |    |    |      |
C            |5     |    |1   |      |6
C            *------|----*--- IP-----*
C            |      |    |    |      |
C            |      |_ __|__ _|_ _ _ |
C            |           |           |
C            |2          |3          |4
C            *-----------*-----------*
C
C    the contribution for the left cell are going to the points
C    1, 6, 3, 4, 8, 9
C    for the rigth cell
C    5, 1, 2, 3, 6, 8
C
C
C
C  4. Argument variables
C
C     ALPHAD    i    Direction index of integration.
C     DTSUM     i    Derivative contributions to the matrix
C     MATRIX   i/o   Matrix
C     MXC       i    Number of points in the x-direction
C     MYC       i    Number of points in the y-direction
C     DEPMIN    i    Minimum possible depth                               31.03
C
      INTEGER ALPHAD, MXC, MYC
      REAL    DEPMIN,                                                     31.03
     +        DEPTH(1:MXC,1:MYC),                                         31.03
     +        MATRIX(1:MXC,1:MYC,1:9),                                    31.03
     +        DTSUM(1:MXC,1:MYC,1:2)                                      31.03
C
C  5. Parameter variables
C
C  6. Local variables
C
C     BETAD     Direction index, usually the direction perpendicular to the
C               integration direction of the boundary integral.
C               For example betad in local point (1,0) is 1 and in (0,1): 2
C     IP        Local counting variable i-direction
C     ISHIFT    Shift in i-direction
C     JP        Local counting variable j-direction
C     MCT       Integer matrix information
C     OFSTNR    Offset diagonal number of matrix element that
C               corresponds to the current point of the interpolation
C               or extrapolation formula
C     SIG       sign for multiplication (1 or -1)
C
      INTEGER ishift, ip, jp, betad, sig, ofstnr(6), mct(-1:1,-1:1)
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C **********************************************************************
C                       KEYWORDS
C
C     discretization
C     transport_matrix
C **********************************************************************
C
C                       DATA STATEMENTS
C
      DATA MCT / 2, 3, 4,
     +           5, 1, 6,
     +           7, 8, 9 /
C **********************************************************************
C
      BETAD = 3-ALPHAD
C
      IF ( ALPHAD.EQ.1) THEN
C
C     --- integration point 1
C
         DO JP = 1, MYC
            DO IP = 1,MXC-1
               DO ISHIFT = 0, 1
C
                  OFSTNR(1) = MCT(ISHIFT  , 0)
                  OFSTNR(2) = MCT(ISHIFT-1, 0)
                  OFSTNR(3) = MCT(ISHIFT  , 1)
                  OFSTNR(4) = MCT(ISHIFT-1, 1)
                  OFSTNR(5) = MCT(ISHIFT  ,-1)
                  OFSTNR(6) = MCT(ISHIFT-1,-1)
C
C                 --- boundaries, one side approximation
C
C                     --- lower boundary
C
                  IF ( JP.EQ.1) THEN
                    OFSTNR(5) = OFSTNR(1)
                    OFSTNR(6) = OFSTNR(2)
                  END IF
C
C                 --- upper boundary
C
                  IF ( JP.EQ.MYC) THEN
                    OFSTNR(3) = OFSTNR(1)
                    OFSTNR(4) = OFSTNR(2)
                  END IF
C
C                 --- non existent neighbours
C
                  IF ( JP.LT.MYC ) THEN
                     IF ( DEPTH(IP  ,JP+1).LT.DEPMIN)                     31.03
     +                  OFSTNR(4) = OFSTNR(2)
                     IF ( DEPTH(IP+1,JP+1).LT.DEPMIN)                     31.03
     +                  OFSTNR(3) = OFSTNR(1)
                  END IF
                  IF ( JP.GT.1 ) THEN
                     IF ( DEPTH(IP  ,JP-1).LT.DEPMIN)                     31.03
     +                  OFSTNR(6) = OFSTNR(2)
                     IF ( DEPTH(IP+1,JP-1).LT.DEPMIN)                     31.03
     +                  OFSTNR(5) = OFSTNR(1)
                  END IF
C
                  SIG = -1+2*ISHIFT
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(1))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(1))
     +                                      + SIG * DTSUM(IP,JP,ALPHAD)
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(2))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(2))
     +                                      - SIG * DTSUM(IP,JP,ALPHAD)
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(3))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(3))
     +                                      + SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(4))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(4))
     +                                      + SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(5))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(5))
     +                                      - SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(6))=
     +                                  MATRIX(IP+1-ISHIFT,JP,OFSTNR(6))
     +                                      - SIG * DTSUM(IP,JP,BETAD)
               END DO
            END DO
         END DO
C
      ELSE
C
C     --- integration point 2
C
         DO JP = 1, MYC-1
            DO IP = 1,MXC
               DO ISHIFT = 0, 1
C
                  OFSTNR(1) = MCT( 0,ISHIFT  )
                  OFSTNR(2) = MCT( 0,ISHIFT-1)
                  OFSTNR(3) = MCT( 1,ISHIFT  )
                  OFSTNR(4) = MCT( 1,ISHIFT-1)
                  OFSTNR(5) = MCT(-1,ISHIFT  )
                  OFSTNR(6) = MCT(-1,ISHIFT-1)
C
C                 --- boundaries, one side approximation
C
C                     --- left boundary
C
                  IF ( IP.EQ.1) THEN
                    OFSTNR(5) = OFSTNR(1)
                    OFSTNR(6) = OFSTNR(2)
                  END IF
C
C                 --- right boundary
C
                  IF ( IP.EQ.MXC) THEN
                    OFSTNR(3) = OFSTNR(1)
                    OFSTNR(4) = OFSTNR(2)
                  END IF
C
C                 --- non existent neighbours
C
                  IF ( IP.LT.MXC ) THEN
                     IF ( DEPTH(IP+1,JP  ).LT.DEPMIN)                     31.03
     +                  OFSTNR(4) = OFSTNR(2)
                     IF ( DEPTH(IP+1,JP+1).LT.DEPMIN)                     31.03
     +                  OFSTNR(3) = OFSTNR(1)
                  END IF
                  IF ( IP.GT.1 ) THEN
                     IF ( DEPTH(IP-1,JP  ).LT.DEPMIN)                     31.03
     +                  OFSTNR(6) = OFSTNR(2)
                     IF ( DEPTH(IP-1,JP+1).LT.DEPMIN)                     31.03
     +                  OFSTNR(5) = OFSTNR(1)
                  END IF
C
                  SIG = -1+2*ISHIFT
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(1))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(1))
     +                                      + SIG * DTSUM(IP,JP,ALPHAD)
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(2))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(2))
     +                                      - SIG * DTSUM(IP,JP,ALPHAD)
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(3))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(3))
     +                                      + SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(4))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(4))
     +                                      + SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(5))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(5))
     +                                      - SIG * DTSUM(IP,JP,BETAD)
                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(6))=
     +                                  MATRIX(IP,JP+1-ISHIFT,OFSTNR(6))
     +                                      - SIG * DTSUM(IP,JP,BETAD)
               END DO
            END DO
         END DO
C
      END IF
C
      END
C
C**********************************************************************
C                                                                     *
      SUBROUTINE SWESSBC ( MXC, MYC, MATRIX, RHSIDE, SETUP)               31.03
C                                                                     *
C**********************************************************************
C
      IMPLICIT NONE
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     31.00  Kees Kassels
C     31.03  Annette Kieftenburg
C
C  1. Updates
C
C     version 1.0    date 11-09-1997
C
C  2. Purpose
C
C     Puts essential boundary conditions in matrix
C
C  3. Method (updated...)
C
C  4. Argument variables
C
C     MXC       i    Number of points in the x-direction
C     MYC       i    Number of points in the y-direction
C     MATRIX    i/o  Matrix
C     RHSIDE    i/o  Righthandside
C     SETUP     i    Unknown to be computed direct addressed
C
      INTEGER MXC, MYC
      REAL    MATRIX(1:MXC,1:MYC,1:9),
     +        RHSIDE(1:MXC,1:MYC),
     +        SETUP (1:MXC,1:MYC)                                         31.03
C
C  5. Parameter variables
C
C  6. Local variables
C
C     I         General loop variable
C     J         General loop variable
C     K         General loop variable
C
      INTEGER I, J, K
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C **********************************************************************
C
C     --- boundary 1 and 2
C
      DO J = 1,MYC
        DO I = 1,MXC,MXC-1
           DO K = 2, 9
               MATRIX(I,J,K) = 0E0
           END DO
           MATRIX(I,J,1) = 1E0
           RHSIDE(I,J) = SETUP(I,J)
        END DO
      END DO
C
C      --- boundary 3 and 4
C
      DO J = 1,MYC,MYC-1
         DO I = 1,MXC
            DO K = 2, 9
               MATRIX(I,J,K) = 0E0
            END DO
            MATRIX(I,J,1) = 1E0
            RHSIDE(I,J) = SETUP(I,J)
         END DO
      END DO
C
      END
C
C ********************************************************************
C                                                                    *
      SUBROUTINE SWSOLV ( MATRIX, RHSIDE, SETUP, NPOINT,
     +                    WORK, NWORK, ITSW, ITER,
     +                    UPPERI, LOPERI)
C                                                                    *
C ********************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
C
C  0. Authors
C
C      1.0 : Kees Vuik
C     30.82: IJsbrand Haagsma
C     31.03: Annette Kieftenburg
C     34.01: Jeroen Adema
C     30.80: Nico Booij
C
C  1. Updates
C
C     version 1.0    date 12-09-97
C     34.01, Feb. 99: Introducing STPNOW
C     30.82, July 99: Corrected argumentlist SWSOLV
C     30.80, July 99: call of ISSOLV modified
C     30.82, Aug. 99: gets the information now from PNUMS file
C
C  2. Purpose
C
C     Prepare for ISSOLV
C
C  3. Method
C
C  4. Argument variables
C
C     ITER      input    Iteration number for SWAN
C     ITSW      input    Time step number
C     LOPERI             only relevant for computation in periodic domain 30.80
C     MATRIX    input    Matrix
C     NPOINT    input    Number of points MXC*MYC
C     NWORK     input    Dimension for work array
C     RHSIDE    input    Righthandside
C     SETUP     i/o      Unknown to be computed direct addressed
C     UPPERI             only relevant for computation in periodic domain 30.80
C     WORK               work array
C
      INTEGER  ITER,ITSW, NPOINT, NWORK                                   31.03
C
      REAL     LOPERI(*), MATRIX(*), RHSIDE(*), SETUP(*), UPPERI(*)       30.82
      REAL     WORK(*)                                                    31.03
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ERRPTS
C     I         General loop variable
C     IINSOL    Integer information for the solver
C     INFMAT    Integer information for the matrix
C     INOCNV
C     NCONCT    Number of connections in a row of the matrix
C     NPREC     Number of diagonals used in the preconditioner
C     RINSOL    Real information for the solver
C
      REAL      RINSOL(7)                                                 31.03
      INTEGER   INFMAT(10), IINSOL(14), I, NPREC, NCONCT
      INTEGER   INOCNV
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     ISSOLV   The subroutine ISSOLV is used to solve an unsymmetric
C              system of equations of the shape A x = f.
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SETUP2D   Computation of SETUP, the change of waterlevel by waves.
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C 13. Source text
C
C ********************************************************************
C
C     initialization
C
      INOCNV = 0
C
      DO I = 1, 14
         IINSOL(I) = 0
      ENDDO
      DO I = 1, 7
         RINSOL(I) = 0.
      ENDDO
C
      NPREC     = 9
      NCONCT    = 9
C
C     INFMAT(1) = 4 represents the original equation (in spectral domain)
C     INFMAT(1) = 5 represents the Poisson equation (to determine setup)  30.80
C
      INFMAT(1) = 5
C
      INFMAT(2) = MXC-1
      INFMAT(3) = MYC-1
      INFMAT(4) = 0
      INFMAT(5) = NPOINT
      INFMAT(6) = 9
C
C     INFMAT(8) contains LSETUP. This is used in DMLU3 to fill the
C     value of alpha for the RILU(alpha) preconditioner
C
      INFMAT(8) = LSETUP
C
C     input for the solver which should not be changed
C
      IINSOL(1) = 1
      IINSOL(4) = 0
      IINSOL(5) = 0
      IINSOL(7) = 4
      IINSOL(8) = 6
C
C     input for the solver which may be changed
C
C     IINSOL(2) determines the preconditioner
C     Possible values
C       0   no preconditioner
C      -1   diagonal preconditioner
C      -3   ILU preconditioner (in general the best choice)
C
      IINSOL(2) = INT(PNUMS(22))                                          30.82
C
C     IINSOL(3) control parameter for the amount of output
C     Possible values:
C             <0  : No output.
C              0  : Only fatal errors will be printed.
C              1  : Additional information about the iteration
C                   is printed.
C              2  : Gives a maximal amount of output
C                   concerning the iteration process.
C
      IINSOL(3) = INT(PNUMS(24))                                          30.82
C
C     IINSOL(6) Maximal number of iterations to be performed
C               in each of the solution methods.
C
      IINSOL(6) = INT(PNUMS(25))                                          30.82
C
C     RINSOL(2) required accuracy, the iterative method stops
C               if ||r ||  < RINSOL(2) * ||r ||
C                     k  2                  0  2
C
      RINSOL(2) = PNUMS(23)                                                   30.82
C
      CALL ISSOLV(IINSOL, RINSOL, MATRIX, RHSIDE, SETUP,
     +            NPOINT, NCONCT, INFMAT,
     +            WORK(NPREC*NPOINT+1), (NWORK-NPREC)*NPOINT,
     +            WORK,   NPREC,
     +            UPPERI, LOPERI, INOCNV,
     +            ITSW,   ITER)
      IF (STPNOW()) RETURN                                                34.01
C
      END
 
