!NRL: $Id: swanmain.F,v 1.3.2.4 2003/07/02 22:05:05 dykes Exp $
!NRL: $Name:  $
C     Last change:  YGH  24 Oct 2000    5:16 pm
C
C
C     SWAN main program and miscellaneous routines
C
C     Contents of this file:
C
C     SWAN:   MAIN program; initializes data pool, makes commons empty
C     SWMAIN: Calling SWINIT, SWREAD, SWCOMP and SWOUTP,...
C     SWINIT: Initialisation of the dynamic data pool and assigning initial
C             values to the variables in the common blocks.
C     SBRTRF
C     SPRCON: Execution of some tests on the given model description
C     SWRBC
C     SVALQI
C     SINARR: Calculating of energy density at boundary point
C     SINUPT
C     SINBTG
C     SINCMP
C     ERRCHK
C     SNEXTI
C     RBFILE read boundary spectra from one file                          40.00
C     RESPEC read one 1-d OR 2-d boundary spectrum from file, and         40.00
C            transform to internal SWAN spectral resolution               40.00
C     FLFILE Update boundary conditions, update nonstationary input       40.00
C            fields                                                       40.00
C     SWCUCU
C     SWINCO
C     SWPREP: Computation of the transformation coefficients between the
C             different grids
C     WRTEST
C
************************************************************************
*                                                                      *
      PROGRAM SWAN
*                                                                      *
************************************************************************
C
      INCLUDE 'poolcomm.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     SWAN MAIN PROGRAM
C     ------------------------------------------------------------------
C     For description of 'SWAN' COMMON see program documentation
C     ------------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.90: IJsbrand Haagsma (Equivalence version)
C     32.01: Roeland Ris & Cor van der Schelde
C     34.01: Jeroen Adema
C
C  1. Updates
C
C            Jan. 94: transition from old pool to new pool structure
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.01, Jan. 98: Array WL initialised (project h3268)
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     34.01, Feb. 99: Introducing STPNOW
C
C  2. Purpose
C
C     MAIN program, initializes data pool, makes common areas empty
C
C  6. Local variables
C
C     INERR : Number of the initialisation error
C
      INTEGER INERR
C
C  8. Subroutines used
C
C
C 13. Source Code
C
C
C     MCINGR increased by NUMGRD for array EXCVAL                         30.60
C     NMOVAR increased by 1, MXAUX increased by 3, NWL introduced         32.01
C     MCDA increased by 2, MCNMS increased by 1                           32.01
C     MCDA decreaded by 1 (JCGOB removed)                                 30.72
C     MCDA increased by 1 (JAUXW4 added)                                  30.70
C     NKTST increased by 1 (UNDFLW added)                                 30.72
C     MCCOM increased by 1 (SPDIR2 added)                                 30.75
C     MCDA  increased by 2 (JWFRCX and JWFRCY added)                      31.04
C     MCNMS increased by MQUAD (PQUAD added)                              34.00
C     NKTST increased by 1 (IFPAR added)                                  40.00
C     IDYNWL etc. removed from SWGRID, DYNDEP added                       40.00
C     MCNMS increased by 1 (BRESCL added)                                 40.00
C     LNAMS increased by 2 (DIRCH1 and DIRCH2 added)                      40.00
C     NLSDA LINELN (max length of input lines) introduced                 40.00
C     MCNMS increased by 1 (IGEN added)                                   32.06
C     MCNMS increased by 1 (URSELL added)                                 30.80
C     MNUMS increased by 5 (accuracy criteria for setup)                  30.82
C     MSETUP introduced                                                   30.82
C     MCNMS increased by 1 (CSETUP added)                                 30.82
C     MCNMS increased by 1 (ACUPDA added)                                 40.07
C     MNUMS increased by 5 (num. diffusion for SORDUP scheme)             33.10
C     MCNMS decreased by 1 (URSELL removed)                               40.03
C     MCDA  increased by 1 (JURSEL added)                                 40.03
C     MCNMS increased by 2 (MXITST, MXITNS added)                         40.03
C     NMOVAR increased by 1 (output quant. ASTD added)                    40.03
C     NUMGRD increased by 1 (input field ASTD added)                      40.03
C     MCFP   increased by 1 (CASTD added)                                 40.03
C     MCDA   increased by 3 (ASTD added)                                  40.03
C     MCINGR increased by 1 (VARAST added)                                40.03
C     LNAMS  increased by 20 (VERTXT added)                               40.03
C     MCDA   decreased by 1 (JASTD1 removed)                              40.14
C
C     swanmaxc
C
      PARAMETER (NMOVAR=46, NUMGRD=10, MSURF=10, MBOT=10, MXAUX=8,        40.03
     &           LENFNM=80,                                               40.13
     &           MQUAD=10, MWCAP=15, MWIND=40, MTRIAD = 10, MNUMS=30,     40.07
     &           MSETUP=2,                                                30.82
     &           MSHAPE=5, MOUTPA=5, MICMAX=10, MSPPAR=5, LINELN=120)     40.00
      PARAMETER (LNAMS=334+3*LENFNM, NTSTD=5,                             40.13
     &           MCODA=36, NRFNS=12, NLSDA=19+2*LINELN, NLSDN=6,          40.00
     &           LHNAMS = 3*36 + 28 + 12*6 + NMOVAR*70,                   40.00
     &           MCINGR= 21+14*NUMGRD, MCCOM=43         , NKTST=13,       40.00 40.22
     &           MCNMS = MWCAP+MBOT+MTRIAD+MNUMS+MSURF+MWIND+MSHAPE+      40.00
     &                   MSETUP+MQUAD+MSPPAR+39,                          40.03
     &           MCUDA = 20+MOUTPA+NMOVAR*6, MCFP=18, MCDA=89+MXAUX)      40.03 40.22
C
      CHARACTER*1 C4                                                      40.00
      CHARACTER LSDA*1
      CHARACTER TIT*1
C
      COMMON  /NAMES/   C4(LNAMS)
      COMMON  /TESTDA/  OTSTD(NTSTD)
      COMMON  /OUTPDA/  ODA(MCODA)
      COMMON  /REFNRS/  IRFNS(NRFNS)
      COMMON  /LEESDA/  LSDA(NLSDA)
      COMMON  /LEESDN/  ILSDN(NLSDN)
      COMMON  /SWNAME/  TIT(LHNAMS)
      COMMON  /SWGRID/  BOTG(MCINGR)
      COMMON  /SWCOMG/  COMG(MCCOM)
      COMMON  /SWNUMS/  NMS(MCNMS)
      COMMON  /SWTEST/  OUT(NKTST)
      COMMON  /SWUITV/  UDA(MCUDA)
      COMMON  /SWFYSP/  FP(MCFP)
      COMMON  /COMPDA/  CDA(MCDA)
C
      POOL  = 0                                                           40.04
C
      INERR = 0
      IERR = -1
      LENARR = MXPOOL                                                     40.04
      CALL DPBLDP (POOL, LENARR, 2, 0, IERR)                              40.04
C
C Initialisation of common variables
C
      DO 11 II = 1, LNAMS
        C4(II) = '    '
  11  CONTINUE
      DO 12 II = 1, NTSTD
        OTSTD(II) = 0
  12  CONTINUE
      DO 13 II = 1, MCODA
        ODA(II) = 0
  13  CONTINUE
      DO 14 II = 1, NRFNS
        IRFNS(II) = 0
  14  CONTINUE
      DO 15 II = 1, NLSDA
        LSDA(II) = ' '
  15  CONTINUE
      DO 16 II = 1, NLSDN
        ILSDN(II) = 0
  16  CONTINUE
      DO 17 II = 1, LHNAMS
        TIT(II) = ' '
  17  CONTINUE
      DO 19 II = 1, MCINGR
        BOTG(II) = 0
  19  CONTINUE
      DO 20 II = 1, MCCOM
        COMG(II) = 0
  20  CONTINUE
      DO 21 II = 1, MCNMS
        NMS(II) = 0
  21  CONTINUE
      DO 23 II = 1, NKTST
        OUT(II) = 0
  23  CONTINUE
      DO 24 II = 1, MCUDA
        UDA(II) = 0
  24  CONTINUE
      DO 25 II = 1, MCFP
        FP(II) = 0
  25  CONTINUE
      DO 26 II = 1, MCDA
        CDA(II) = 0
  26  CONTINUE
C
C Call Main SUBROUTINE SWMAIN
C
      CALL SWMAIN (POOL,RPOOL,LPOOL,INERR)                                    34.01
C
      IF (INERR.GT.0) THEN
        IF (INERR.EQ.950) THEN
          WRITE(*,*) 'Error opening initialisation file '
        END IF
        IF (INERR.EQ.930) THEN
          WRITE(*,*) 'Error reading initialisation file '
        END IF
        IF (INERR.EQ.935) THEN
          WRITE(*,*) 'Incorrect version of initialisation file '
        END IF
        IF (INERR.EQ.920) THEN
          WRITE(*,*) 'Cannot open PRINT file '
        ENDIF
        STOP
      END IF
C
C --End of MAIN PROGRAM
C
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWMAIN (POOL, RPOOL, LPOOL, INERR)                       34.01
*                                                                      *
************************************************************************
C
C     Include common storage for action densities                         NRL
      USE M_ACDEN                                                         NRL
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              40.13
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
!MCEL+ J Dykes 15 Oct 2002 SWMAIN: includes
      INCLUDE 'MCEL.inc'
      INCLUDE 'mcel_swan.inc'
!MCEL-
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence verion)
C     32.01: Roeland Ris & Cor van der Schelde
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     34.01: IJsbrand Haagsma
C     40.00, 40.13: Nico Booij
C     34.01: Jeroen Adema
C     33.08: W. Erick Rogers
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C            10 FEB   Subroutine SWMAIN introduced
C     30.60, Aug. 97: argument list of ERRCHK changed
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.72, Nov. 97: declaration of ITERMX removed because it is a common
C                     variable, which is declared in the INCLUDE file
C     30.72, Nov. 97: PWTAIL(3) is made dependent on PWTAIL(1), also in the
C                     initialisation
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.01, Jan. 98: Nautical convention included (project h3268)
C     32.01, Jan. 98: Comparison of computed and prescribed significant
C                     wave height (project h3268)
C     32.02, Jan. 98: Introduction of 1D-version
C     30.72, Mar. 98: Added instruction to change [maxerr] in case of a
C                     terminating warning
C     40.00, Nov. 97: time step loop reorganized,
C                     argument list in call SNEXTI changed
C                     declaration of ITERMX removed
C                     argument added in call SWOUTP
C     30.82, Sep. 98: Added check on error level each time step to prevent
C                     continuation of computation
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     34.01, Feb. 99: Changed STOP statement in a jump to end of subroutine
C     34.01, Feb. 99: Close all files at end of this subroutine
C     34.01, Feb. 99: Introducing STPNOW
C     33.08, July 98: S&L scheme-related changes
!     40.13, July 01: coefficient PTRIAD(4) added
!                     make file 'norm_end' if program ends normally
!     40.22, Oct. 01: call SWCOMP changed in view of parallellization
C
C  2. Purpose
C
C     SWMAIN subroutine, calling SWINIT, SWREAD, SWCOMP and SWOUTP
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     INERR : Number of the initialisation error
C
      INTEGER INERR
C
C  6. Local variables
C
C     IUNIT : Counter for file unit numbers                               34.01
C
      INTEGER IUNIT                                                       34.01
C
C     LOPEN : Indicates whether a file is open                            34.01
C
      LOGICAL LOPEN                                                       34.01
C
C  8. Subroutines used
C
C     SWINIT, SWREAD, DPINQP, DPEXPR, SWPREP, ERRCHK, DPADDP, DPCHEK,
C     SWRBC,SINARR,SWINCO,SNEXTI,DPMAXR,SWCOMP,
C     HSOBND: Generates warning if comp. and prescr. Hs differ more than  32.01
C             a fraction HSRERR at the up-wave boundary                   32.01
C     DPMINR, SWOUTP
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     MAIN program SWAN
C
C 10. Error Messages
C
C     ---
C
C 11. Remarks
C
C     The description of the structure of this subroutine is very
C     short as most of the source code can easily be understood with
C     the aid of the command descriptions in the user manual and the
C     purpose of the subroutines from the system documentation.
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Call SWINIT to initialize various common data
C     Repeat                                                              40.00
C         Call SWREAD to read and process user commands
C         If last command was STOP
C         Then exit from repeat
C         -------------------------------------------------------------
C         Call SWPREP to check input and prepare computation
C         If nonstationary computation is to be made                      40.00
C         Then start time step loop at IT=0                               40.00
C         -------------------------------------------------------------
C         For requested number of time steps do                           40.00
C             Call SNEXTI to update boundary conditions and input fields  40.00
C             If IT=0                                                     40.00
C             Then Call SWINCO to calculate initial wave spectra          40.00
C             Else Call SWCOMP to calculate the wave field                40.00
C             ---------------------------------------------------------
C             Call SWOUTP to postprocess the results and create output
C             Update time
C     ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER   POOL(*)
      INTEGER   IERR, IADRS                                               40.00
      REAL      RPOOL(*)                                                  30.90
      LOGICAL   LPOOL(*)
      CHARACTER PTYPE, PNAME *8, COMPUT *4, DTTIWR*18                     40.00
!MCEL+ J Dykes 15 Oct 2002 SWMAIN: initialise tags
      IREG_MC = 0
      mcel_put_tag = 0
      mcel_get_tag = 0
!MCEL-

C
      MAXERR=1                                                            34.01
      CALL SWINIT (POOL,INERR)                                            34.01
      IF (INERR.GT.0) RETURN                                              34.01
      IF (STPNOW()) RETURN                                                34.01
C
      COMPUT = '    '
      DO LOOP = 1, 99
        CALL SWREAD (COMPUT, POOL, RPOOL)                                 30.90
        IF (STPNOW()) RETURN                                              34.01
C
        IF ( ITEST .GE. 100) THEN                                         32.01
          WRITE (PRTEST,*) ' BNAUT in SWMAIN after SWREAD = ',BNAUT       32.01
        ENDIF                                                             32.01
C
        IF (COMPUT.EQ.'STOP') THEN                                        40.13
          IUNIT = 0                                                       40.13
          IOSTAT = 0                                                      40.13
          FILENM = 'norm_end'                                             40.13
          CALL FOR (IUNIT, FILENM, 'UF', IOSTAT)                          40.13
          WRITE (IUNIT, *) ' Normal end of run ', PROJNR                  40.13
          GOTO 900                                                        40.13
        ENDIF                                                             40.13
C
C
C       ***** prepare computation and check the model description *****
C
        PNAME = 'OUTDA'
        CALL DPINQP (POOL, PNAME, JOUTDA, PTYPE, IOUTD,
     &               LENREC, IERR)
        IERR = 0
        PNAME = 'CROSS'
        IERR = -2
        CALL DPINQP (POOL, PNAME, JCROSS, PTYPE, ICROSS,
     &               LENREC, IERR)
        IF (NUMOBS .GT. 0) THEN
           CALL DPEXPR (POOL, JCROSS , 2*MCGRD, ICROSS  , IERR)
           IF (STPNOW()) RETURN                                           34.01
        ENDIF                                                             34.01
 
C       choose scheme for stationary or nonstationary computation
        IF (NSTATC.EQ.1) THEN                                             40.03
          PROPSC = PROPSN                                                 40.03
        ELSE
          PROPSC = PROPSS                                                 40.03
        ENDIF
C
        PNAME = 'OBSTACLE'
        IERR = 0
        CALL DPINQP (POOL, PNAME, JOBST, PTYPE, IOBST,
     &               LENREC, IERR)
C
C        POOL(IADRS(POOL,JOUTDA)) ---> OUTDA
C       RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C       RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C        POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C        POOL(IADRS(POOL,JOBST)) ----> OBSTA
C        POOL(IADRS(POOL,JCROSS)) ---> CROSS
C        POOL(IADRS(POOL,JGRBND) ----> KGRBND
C
        CALL SWPREP (POOL(IADRS(POOL,JOUTDA)),RPOOL(IADRS(POOL,JCOOX)) ,
     &              RPOOL(IADRS(POOL,JCOOY)),POOL(IADRS(POOL,JADDRS))  ,  30.90
     &              POOL(IADRS(POOL,JOBST)),POOL(IADRS(POOL,JCROSS))  ,
     &              POOL(IADRS(POOL,JGRBND)))                             40.00
C
C       *** check all possible flags and if necessary change ***
C       *** if option is not correct                         ***
C
        CALL ERRCHK (POOL)                                                40.00
        IF (STPNOW()) RETURN                                              34.01
C
C       *** initialisation of necessary grids for depth,      ***
C       *** current, wind and friction                        ***
C
C       *** MCGRD is the number of sea points in the comp. grid ***
C
        IERR = 0
        PNAME = 'COMPDA'                                                  20.39
        CALL DPADDP (POOL, PNAME, JCMPDA, 'S', ICMPDA, IERR)              20.39
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JCMPDA, MCMVAR*MCGRD, ICMPDA, IERR)            30.21
        IF (STPNOW()) RETURN                                              34.01
        IF (ITEST.GE.60) THEN
          IERR = -2
        ELSE
          IERR = 0
        ENDIF
        CALL DPCHEK (POOL, IERR)
C
C       RPOOL(IADRS(POOL,JCMPDA)) ---> COMPDA
C        POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C       RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C       RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C
        CALL SWRBC (POOL, RPOOL              ,RPOOL(IADRS(POOL,JCMPDA)),  30.90
     &              POOL(IADRS(POOL,JADDRS)) ,RPOOL(IADRS(POOL,JCOOX)) ,  30.90
     &              RPOOL(IADRS(POOL,JCOOY))                           )  30.90
C
C
        IF (ALLOCATED(AC1)) DEALLOCATE(AC1)                               NRL
        IF (NSTATM.EQ.1 .AND. MXITNS.GT.1                                 40.03
     &                 .OR. PROPSC.EQ.3                                   33.08
     &                                   ) THEN                           30.50
C         *** enlarge the pool to contain action densities at time T  ***
C       for the S&L scheme (PROPSC=3), we will need AC1 for all cases.    33.08
           ALLOCATE(AC1(MDC,MSC,MCGRD))                                   NRL
           AC1=0.                                                         NRL
        ELSE                                                              NRL
           ALLOCATE(AC1(0,0,0))                                           NRL
        ENDIF
 
        IERR = 0
        CALL DPCHEK (POOL, IERR)
C
C       ***** initialisation of arrays for computation
C
        CALL SINARR (POOL)
        IF (STPNOW()) RETURN                                              34.01
C
        IF (LEVERR.GT.MAXERR) THEN                                        40.00
          WRITE (PRINTF, 6010) LEVERR
          IF (LEVERR.LT.4) WRITE (PRINTF, 6011)                           30.72
 6010     FORMAT(' ** No start of computation because of error level:'
     &      ,I3)
 6011     FORMAT(' ** To ignore this error, change [maxerr] with the',    30.72
     &           ' SET command')                                          30.72
        ELSE
*
*
*
C
          IF (ITEST.GE.40) THEN                                           40.00
            IF (NSTATC.EQ.1) THEN                                         33.08
              WRITE (PRINTF, '(" Type of computation: dynamic")')         32.02
            ELSE                                                          32.02
              IF (ONED) THEN                                              32.02
                WRITE (PRINTF, '(" Type of computation: static 1-D")')    32.02
              ELSE                                                        32.02
                WRITE (PRINTF, '(" Type of computation: static 2-D")')    32.02
              ENDIF                                                       32.02
            ENDIF                                                         32.02
          ENDIF
C
          IF (NSTATC.EQ.1) THEN                                           40.00
            IT0 = 0                                                       40.00
            IF (ICOND.EQ.1) THEN                                          40.00
C             *** Compute default initial condition ***
C
C             RPOOL(IADRS(POOL,JCMPDA)) ---> COMPDA
C             RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C             RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C              POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C             RPOOL(IADRS(POOL,JSPDIR)) ---> SPCDIR
C             RPOOL(IADRS(POOL,JSIGMA)) ---> SPCSIG
C              POOL(IADRS(POOL,JXYTST)) ---> XYTST
C
              CALL SWINCO (                  AC2,                         30.90 NRL
     &                     RPOOL(IADRS(POOL,JCMPDA)),                     30.90
     &                     RPOOL(IADRS(POOL,JCOOX)) ,                     30.90
     &                     RPOOL(IADRS(POOL,JCOOY)) ,                     30.90
     &                      POOL(IADRS(POOL,JADDRS)),
     &                     RPOOL(IADRS(POOL,JSPDIR)),                     30.90
     &                     RPOOL(IADRS(POOL,JSIGMA)),                     30.90
     &                      POOL(IADRS(POOL,JXYTST)))                     30.70
C             reset ICOND to prevent second computation of initial condition
              ICOND = 0                                                   40.00
            ENDIF
          ELSE
            IT0 = 1
          ENDIF
          IF (PROPSC.EQ.1) THEN
            ICMAX = 3                                                     33.08
          ELSE IF (PROPSC.EQ.2) THEN
            ICMAX = 5                                                     33.08
          ELSE IF (PROPSC.EQ.3) THEN
            ICMAX = 10                                                    33.08
          ENDIF
C
C         loop over time steps                                            40.00
C
          DO 500 IT = IT0, MTC                                            40.00
C
            IF (LEVERR.GT.MAXERR) THEN                                    30.82
              WRITE (PRINTF, 6030) LEVERR                                 30.82
              IF (LEVERR.LT.4) WRITE (PRINTF, 6031)                       30.82
 6030         FORMAT(' ** No continuation of computation because ',       30.82
     &               'of error level:',I3)                                30.82
 6031         FORMAT(' ** To ignore this error, change [maxerr]',         30.82
     &               ' with the SET command')                             30.82
              GOTO 900                                                    30.82
            ENDIF                                                         30.82
C
C           update boundary conditions and input fields
C
C            POOL(IADRS(POOL,JBFILS)) ---> BFILES
C            POOL(IADRS(POOL,JBSLOC)) ---> BSPLOC
C            POOL(IADRS(POOL,JBSDIR)) ---> BSPDIR
C           RPOOL(IADRS(POOL,JBSDIR)) ---> RBSDIR
C            POOL(IADRS(POOL,JBSFRQ)) ---> BSPFRQ
C           RPOOL(IADRS(POOL,JBSFRQ)) ---> RBSFRQ
C            POOL(IADRS(POOL,JBSAUX)) ---> BSPAUX
C           RPOOL(IADRS(POOL,JBSAUX)) ---> RBSAUX
C           RPOOL(IADRS(POOL,JBSPEC)) ---> BSPECS
C            POOL(IADRS(POOL,JBGRID)) ---> BGRIDP
C           RPOOL(IADRS(POOL,JCMPDA)) ---> COMPDA
C           RPOOL(IADRS(POOL,JSIGMA)) ---> SPCSIG
C           RPOOL(IADRS(POOL,JSPDIR)) ---> SPCDIR
C           RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C           RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C            POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C            POOL(IADRS(POOL,JXYTST)) ---> XYTST
C
            CALL SNEXTI (POOL, RPOOL, POOL(IADRS(POOL,JBFILS)),           30.90
     &             POOL(IADRS(POOL,JBSLOC)), POOL(IADRS(POOL,JBSDIR)),
     &            RPOOL(IADRS(POOL,JBSDIR)), POOL(IADRS(POOL,JBSFRQ)),    30.90
     &            RPOOL(IADRS(POOL,JBSFRQ)), POOL(IADRS(POOL,JBSAUX)),    30.90
     &            RPOOL(IADRS(POOL,JBSAUX)),                              30.90
     &            RPOOL(IADRS(POOL,JBSPEC)), POOL(IADRS(POOL,JBGRID)),    30.90
     &            RPOOL(IADRS(POOL,JCMPDA)),                              30.90
     &                              AC1  ,                    AC2  ,      30.90 NRL
     &            RPOOL(IADRS(POOL,JSIGMA)),RPOOL(IADRS(POOL,JSPDIR)),    30.90
     &            RPOOL(IADRS(POOL,JCOOX)), RPOOL(IADRS(POOL,JCOOY)) ,    30.90
     &             POOL(IADRS(POOL,JADDRS)), POOL(IADRS(POOL,JXYTST)))
            IF (STPNOW()) RETURN                                          34.01
C
            IF (COMPUT.NE.'NOCO' .AND. IT.GT.0) THEN                      40.00
              IF (IT.EQ.1) THEN
!               Computational Work Area removed from dynamic data pool in 40.22 !NB
!               view of OpenMP. Subarrays of WAREA are transformed into   40.22
!               allocatable arrays (see subr. SWCOMP)                     40.22
                CALL DPCHEK (POOL, IERR)
              ENDIF
              SAVITE = ITEST                                              30.21
              IF (ICOTES .GT. ITEST) ITEST = ICOTES
C
C             RPOOL(IADRS(POOL,JCMPDA)) ---> COMPDA
C             RPOOL(IADRS(POOL,JSPDIR)) ---> SPCDIR
C             RPOOL(IADRS(POOL,JSIGMA)) ---> SPCSIG
C             RPOOL(IADRS(POOL,JTSTDA)) ---> SWTSDA
C              POOL(IADRS(POOL,JXYTST)) ---> XYTST
C              POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C             RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C             RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C              POOL(IADRS(POOL,JOBST)) ----> OBSTA
C              POOL(IADRS(POOL,JCROSS)) ---> CROSS
C
!             Computational Work Area removed from dynamic data pool in   40.22
!             view of OpenMP. Subarrays of WAREA are transformed into     40.22
!             allocatable arrays (see subr. SWCOMP)                       40.22
              CALL SWCOMP(      AC1          ,                            40.22 NRL
     &                          AC2          ,RPOOL(IADRS(POOL,JCMPDA)),  30.90 NRL
     &              RPOOL(IADRS(POOL,JSPDIR)),RPOOL(IADRS(POOL,JSIGMA)),  30.90
     &              RPOOL(IADRS(POOL,JTSTDA)), POOL(IADRS(POOL,JXYTST)),  30.90
     &              IT                       , POOL(IADRS(POOL,JADDRS)),  30.21
     &              RPOOL(IADRS(POOL,JCOOX)) ,RPOOL(IADRS(POOL,JCOOY)) ,  30.90
     &               POOL(IADRS(POOL,JOBST)) , POOL(IADRS(POOL,JCROSS)))  300597
              IF (STPNOW()) RETURN                                        34.01
C
C             *** check whether computed significant wave height at ***   32.01
C             *** boundary differs from predescribed value given in ***   32.01
C             *** boundary command values of incident HS are stored ***   32.01
C             *** in HSI                                            ***   32.01
C
              IF ( BNDCHK ) THEN                                          32.01
C
C               RPOOL(IADRS(POOL,JSIGMA)) --------------------> SPCSIG
C               RPOOL(IADRS(POOL,JCMPDA)+MCGRD*(JHSIBC-1)) ---> HSIBC
C                POOL(IADRS(POOL,JADDRS)) --------------------> KGRPNT
C
                CALL HSOBND (                  AC2      ,                 30.90 NRL
     &                       RPOOL(IADRS(POOL,JSIGMA))  ,                 30.90
     &                       RPOOL(IADRS(POOL,JCMPDA)+MCGRD*(JHSIBC-1)),  30.90
     &                        POOL(IADRS(POOL,JADDRS))  )                 32.01
              ENDIF                                                       32.01
C
              ITEST = SAVITE                                              30.21
              IERR = 0
              CALL DPCHEK (POOL, IERR)
            ENDIF
C
C
C           OUTDA contains work area for the output module; it is made as 40.00
C           large as expected to be necessary (MXOUTAR is expected size   40.00
C           necessary to produce output                                   40.00
C
            IF (IT.EQ.IT0) THEN                                           40.00
              CALL DPMINR (POOL, JOUTDA, LL, IOUTD, IERR)                 40.00
              IF (STPNOW()) RETURN                                        34.01
              CALL DPEXPR (POOL, JOUTDA, LL+1000+MXOUTAR, IOUTD, IERR)    40.00
              IF (STPNOW()) RETURN                                        34.01
              IF (ITEST.GE.10) THEN
                IERR = -2
              ELSE
                IERR = 0
              ENDIF
              CALL DPCHEK (POOL, IERR)
            ENDIF                                                         40.00
C
            SAVITE = ITEST                                                30.21
            IF (IOUTES .GT. ITEST) ITEST = IOUTES
C
C            POOL(IADRS(POOL,JOUTDA)) ---> OUTDA
C           RPOOL(IADRS(POOL,JOUTDA)) ---> ROUTDA
C           RPOOL(IADRS(POOL,JSIGMA)) ---> SPCSIG
C           RPOOL(IADRS(POOL,JSPDIR)) ---> SPCDIR
C           RPOOL(IADRS(POOL,JCMPDA)) ---> COMPDA
C            POOL(IADRS(POOL,JXYTST)) ---> XYTST
C            POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C           RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C           RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C            POOL(IADRS(POOL,JGRBND)) ---> KGRBND
C
            CALL SWOUTP (POOL(IADRS(POOL,JOUTDA)) ,
     &             RPOOL(IADRS(POOL,JOUTDA)) ,LPOOL(IADRS(POOL,JOUTDA)),  30.90
     &                               AC2     ,                            30.90 NRL
     &             RPOOL(IADRS(POOL,JSIGMA)) ,RPOOL(IADRS(POOL,JSPDIR)),  30.90
     &             RPOOL(IADRS(POOL,JCMPDA)) , POOL(IADRS(POOL,JXYTST)),  30.90
     &              POOL(IADRS(POOL,JADDRS)) ,RPOOL(IADRS(POOL,JCOOX)) ,  30.90
     &             RPOOL(IADRS(POOL,JCOOY))  , POOL(IADRS(POOL,JGRBND)))  30.90
            IF (STPNOW()) RETURN                                          34.01
C
            IF (ERRPTS.GT.0) REWIND(ERRPTS)                               30.50
            ITEST = SAVITE                                                30.21
C
C           update time
C
            IF (NSTATM.EQ.1) THEN                                         40.00
              IF (NSTATC.EQ.1 .AND. IT.LT.MTC) TIMCO = TIMCO + DT         40.00
              CHTIME = DTTIWR(ITMOPT, TIMCO)                              40.00
              IF (NSTATC.EQ.1) WRITE (PRINTF, 222) CHTIME, TIMCO          40.00
 222          FORMAT(' Time of computation ->  ',A,' in sec:', F9.0)      40.00
            ENDIF                                                         40.00
 500      CONTINUE
        ENDIF
      ENDDO
C
 900  DO IUNIT=1,HIOPEN                                                   34.01
        INQUIRE(UNIT=IUNIT,OPENED=LOPEN)                                  34.01
        IF (LOPEN) CLOSE(IUNIT)                                           34.01
      END DO                                                              34.01
C
      RETURN                                                              30.82
C     end of subroutine SWMAIN
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWINIT (POOL,INERR)                                      34.01
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'timecomm.inc'                                              40.00
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.62: IJsbrand Haagsma
C     30.72: IJsbrand Haagsma
C     30.80: Nico Booij
C     32.01: Roeland Ris & Cor van der Schelde
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     32.06: Roeland Ris
C     33.08: Nico Booij and Erick Rogers (changes re: the S&L scheme)
C     33.09: Nico Booij (changes re: spherical coordinates)
C     33.10: Nico Booij and Erick Rogers (changes re: the SORDUP scheme)
C     34.01: Jeroen Adema
C     40.00, 40.13: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.14: Annette Kieftenburg
C
C  1. Updates
C
C     10.09, Aug. 94: PER now absolute period, RPER relative period
C     10.10, Aug. 94: arrays NE and NED added (subarrays of OUTDA)
C     20.62, Oct. 95: argument of DPBLDP made variable
C     30.60, July 97: initialisation of array EXCVAL
C     30.60, Aug. 97: initialisation of MCGRD
C     30.62, Aug. 97: initialisation of PSURF(3) (gamd=1. for HISWA)
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.72, Nov. 97: updated units in OVUNIT
C     30.72, Jan. 98: made default values for quadruplets and PNUMS(20)
C                     (=GRWMX) according the command GEN3 KOM
C     32.01, Jan. 98: Initialised BNAUT, BNDCHK and HSRERR
C     32.02, Jan. 98: Initialised output variable 'Setup', LSETUP, JSETUP,
C                     JDPSAV and ONED
C     32.01, Jan. 98: added pointers in the POOL for auxiliary arrays
C                     JAUX(5:7)
C     30.72, Mar. 98: Initialisation for UNDFLW added
C     30.70, Mar. 98: pool array CROSS initialized as data array (not pointer)
C     40.00, June 98: data for nonstat. boundary conditions initialised
C                     STATUS is renamed IERR, because STATUS is reserved word
C            Feb. 99: IDYNCU etc. removed; DYNDEP initialized
C     30.80, Nov. 98: Provision for limitation on Ctheta (refraction)
C     34.01, Feb. 99: Introducing STPNOW
C     33.08, July 98: minor changes related to the S&L scheme
C     32.06, June 99: Initialisation of IGEN
C     30.82, July 99: Initialisation of ITERMX changed from 6 to 15
C     30.80, Aug. 99: Ursell number init. as 0.
C     30.82, Aug. 99: Assigned values to PNUMS(15) and PNUMS(16). They indicate the
C                     allowed global errors in the iteration procedure
C     30.82, Aug. 99: Initialisation of CSETUP
C     33.10, Jan. 00: minor changes related to the SORDUP scheme
C     40.02, Sep. 00: IREFR default set to 1 (no limiter activated)
C     40.14, Jan. 01: JASTD1 removed (is not used in COMPDA array)
C     40.13, Jan. 01: COSPG is initialized at 1. (corresponding to ALPG)
C                     NUMOBS initialized
C                     subarray sequence numbers in array COMPDA changed
C
C  2. Purpose
C
C     Initialisation of the dynamic data pool and assigning initial
C     values to the variables in the common blocks.
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     INERR : Number of the initialisation error
C
      INTEGER INERR
C
C  6. Local variables
C
C     PNAME : Name of the pointer added to the POOL array
C
      CHARACTER    PNAME*8
C
C  8. Subroutines used
C
C     DPADDP: Add a pointer for a variable to the POOL array
C     Ocean Pack dynamic pool routines
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWREAD
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Call OCPINI to initialize installation dependent constants
C     Call VERSION to get valid version number
C     Give unit references initial value
C     Write heading above echo of input
C     Call ADPOOL to enlarge poolarrays IOUTR and IOUTD
C     Call CHPOOL to check the pool structure
C     Give common variables initial value
C     ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER      POOL(*), IERR, LENARR                                  30.72
      CHARACTER    PTYPE *1
C
      VERTXT = BLANK                                                      40.03
      VERNUM = 40.20
      WRITE (VERTXT, '(F5.2)') VERNUM                                     40.03
!FIX      CALL BUGFIX ('A')
!FIX      CALL BUGFIX ('B')
!FIX      CALL BUGFIX ('C')
!FIX      CALL BUGFIX ('D')
!FIX      CALL BUGFIX ('E')
!FIX      CALL BUGFIX ('F')
C
      CALL OCPINI ('swaninit', .TRUE.,INERR)                              34.01
      IF (INERR.GT.0) RETURN                                              34.01
      IF (STPNOW()) RETURN                                                34.01
C
C/Temp      CALL VALIDV (199901)
C
      WRITE (PRINTF, 6010) VERTXT                                         40.03
 6010 FORMAT (/,20X,'---------------------------------------',
     +        /,20X,'                 SWAN',
     +        /,20X,'SIMULATION OF WAVES IN NEAR SHORE AREAS',
     +        /,20X,'         VERSION NUMBER ', A,                        40.03
     +        /,20X,'---------------------------------------',//)
C
C
C     ***** initialize the dynamic data pool *****
C
      IERR = 0
      PNAME = 'OUTDA'
*     write (printf, *) pname
      CALL DPADDP (POOL, PNAME, JOUTDA, 'P', IOUTD, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (POOL, JOUTDA, 25600, IOUTD, IERR)
      IF (STPNOW()) RETURN                                                34.01
      LENARR = -1                                                         20.62
      CALL DPBLDP (POOL(IOUTD), LENARR, 2, 0, IERR)                       20.62
*
      II = 0
      PNAME = 'PSET'
*     write (printf, *) pname
      CALL DPADDP (POOL(IOUTD), PNAME, II, 'P', JADR, IERR)               20.62
      IF (STPNOW()) RETURN                                                34.01
      CALL DPINQP (POOL(IOUTD), PNAME, II, PTYPE, IOUTPS,
     &             LENREC, IERR)
      LENARR = -1                                                         20.62
      CALL DPBLDP (POOL(IOUTD+IOUTPS-1), LENARR, 2, 0, IERR)              20.62
*
      II = 0
      PNAME = 'REQ'
*     write (printf, *) pname
      CALL DPADDP (POOL(IOUTD), PNAME,  II, 'P', JADR, IERR)              20.62
      IF (STPNOW()) RETURN                                                34.01
      CALL DPINQP (POOL(IOUTD), PNAME,  II, PTYPE, IOUTOQ,
     &             LENREC, IERR)
      LENARR = -1                                                         20.62
      CALL DPBLDP (POOL(IOUTD+IOUTOQ-1), LENARR, 0, 0, IERR)              20.62
*
      II = 0
      PNAME = 'LIN'
*     write (printf, *) pname
      CALL DPADDP (POOL(IOUTD), PNAME,  II, 'P', JADR, IERR)              20.62
      IF (STPNOW()) RETURN                                                34.01
      CALL DPINQP (POOL(IOUTD), PNAME,  II, PTYPE, IOUTLN,
     &             LENREC, IERR)
      LENARR = -1                                                         20.62
      CALL DPBLDP (POOL(IOUTD+IOUTLN-1), LENARR, 0, 0, IERR)              20.62
*
      II = 0
      PNAME = 'PLA'
*     write (printf, *) pname
      CALL DPADDP (POOL(IOUTD), PNAME,  II, 'P', JADR, IERR)              20.62
      IF (STPNOW()) RETURN                                                34.01
      CALL DPINQP (POOL(IOUTD), PNAME,  II, PTYPE, IOUTPL,
     &             LENREC, IERR)
      LENARR = -1                                                         20.62
      CALL DPBLDP (POOL(IOUTD+IOUTPL-1), LENARR, 4, 0, IERR)              20.62
*
      IERR = 0
      PNAME = 'VOQ'
*     write (printf, *) pname
      CALL DPADDP (POOL(IOUTD), PNAME, JVOQ, 'S', IVOQ, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'ACLOC'
      CALL DPADDP (POOL(IOUTD), PNAME, JACLOC, 'S', IACLOC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'KNUM'
      CALL DPADDP (POOL(IOUTD), PNAME, JKNUM, 'S', IKNUM, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'CG'
      CALL DPADDP (POOL(IOUTD), PNAME, JCG, 'S', ICG, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'NE'                                                        10.10
      CALL DPADDP (POOL(IOUTD), PNAME, JNE, 'S', INE, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'NED'                                                       10.10
      CALL DPADDP (POOL(IOUTD), PNAME, JNED, 'S', INED, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX1'
      CALL DPADDP (POOL(IOUTD), PNAME, INDX, 'S', IAUX1, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX2'
      CALL DPADDP (POOL(IOUTD), PNAME, INDX, 'S', IAUX2, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
      IERR = 0
      PNAME = 'SIG'
      CALL DPADDP (POOL, PNAME, JSIGMA, 'S', ISIG, IERR)                  40.03
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'SPCDIR'
      CALL DPADDP (POOL, PNAME, JSPDIR, 'S', ISPDIR, IERR)                20.43
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'DEB'
      CALL DPADDP (POOL, PNAME, JDEB, 'S', IDEB, IERR)                    40.03
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'XYTST'
      CALL DPADDP (POOL, PNAME, JXYTST, 'S', IXYTST, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
*
*
*
      PNAME = 'SWTSDA'
      CALL DPADDP (POOL, PNAME, JTSTDA, 'S', ITSTDA, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
C
      PNAME = 'ADDRS'
      CALL DPADDP (POOL, PNAME, JADDRS, 'S', IADDRS, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'COOX'
      CALL DPADDP (POOL, PNAME, JCOOX, 'S', ICOOX, IERR)                  40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'COOY'
      CALL DPADDP (POOL, PNAME, JCOOY, 'S', ICOOY, IERR)                  40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'CGRBND'
      CALL DPADDP (POOL, PNAME, JGRBND, 'S', IGRBND, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'BFILES'
      CALL DPADDP (POOL, PNAME, JBFILS, 'P', IBFILS, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BSPLOC'
      CALL DPADDP (POOL, PNAME, JBSLOC, 'P', IBSLOC, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BSPDIR'
      CALL DPADDP (POOL, PNAME, JBSDIR, 'P', IBSDIR, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BSPFRQ'
      CALL DPADDP (POOL, PNAME, JBSFRQ, 'P', IBSFRQ, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BSPAUX'
      CALL DPADDP (POOL, PNAME, JBSAUX, 'P', IBSAUX, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BSPECS'
      CALL DPADDP (POOL, PNAME, JBSPEC, 'S', IBSPEC, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'BGRIDP'
      CALL DPADDP (POOL, PNAME, JBGRID, 'S', IBGRID, IERR)                40.03
      IF (STPNOW()) RETURN                                                34.01
C
      PNAME = 'OBSTACLE'                                                  16/MAY
      CALL DPADDP (POOL, PNAME, JOBST, 'P', IOBST, IERR)                  16/MAY
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'CROSS'                                                     300597
      CALL DPADDP (POOL, PNAME, JCROSS, 'S', ICROSS, IERR)                30.70
      IF (STPNOW()) RETURN                                                34.01
*
      PNAME = 'AUX1'
      CALL DPADDP (POOL, PNAME, JAUX(1), 'S', IAUX1, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX2'
      CALL DPADDP (POOL, PNAME, JAUX(2), 'S', IAUX2, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX3'
      CALL DPADDP (POOL, PNAME, JAUX(3), 'S', IAUX1, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX4'
      CALL DPADDP (POOL, PNAME, JAUX(4), 'S', IAUX2, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX5'                                                      32.01
      CALL DPADDP (POOL, PNAME, JAUX(5), 'S', IAUX5, IERR)                32.01
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX6'                                                      32.01
      CALL DPADDP (POOL, PNAME, JAUX(6), 'S', IAUX6, IERR)                32.01
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'AUX7'                                                      32.01
      CALL DPADDP (POOL, PNAME, JAUX(7), 'S', IAUX7, IERR)                32.01
      IF (STPNOW()) RETURN                                                34.01
C
      IF (SCREEN.NE.PRINTF) WRITE (SCREEN,6020)
 6020 FORMAT (/, ' SWAN is preparing computation',/)
*
*     ***** initial values for common variables *****
*     ***** names *****
      PROJID = 'SWAN'
      PROJNR = BLANK
      PROJT1 = BLANK
      PROJT2 = BLANK
      PROJT3 = BLANK
      FNEST  = BLANK
      FBCR   = BLANK
      FBCL   = BLANK
      UH     = 'm'
      UV     = 'm/s'
      UT     = 'sec'
      UL     = 'm'
      UET    = 'm3/s'
      UDI    = 'degr'
      UST    = 'm2/s2'
      UF     = 'N/m2'
      UP     = 'W/m'
      UAP    = 'W/m2'
      UDL    = 'm2/s'
*     ***** physical parameters *****
      GRAV   = 9.81
      WLEV   = 0.
      CASTD  = 0.               ! const. air-sea temp diff                40.03
      PI     = 3.1415926536
      PI2    = 2.*PI
      UNDFLW = 1.E-15
      DNORTH = 90.                                                        30.72
      DEGRAD = PI/180.
      RHO    = 1025.
*     power of tail in spectrum, 1: E with f, 2: E with k,
*                                3: A with f, 4: A with k
      PWTAIL(1) = 4.
      PWTAIL(2) = 2.5
      PWTAIL(3) = PWTAIL(1)+1.                                            30.72
      PWTAIL(4) = 3.
*     ***** number of computational grid points ****                      30.60
      MCGRD = 1                                                           30.60
      NGRBND = 0                                                          40.00
*     time of computation                                                 40.00
      TIMCO = -1.E10                                                      40.00
      CHTIME = '    '                                                     40.00
*     boundary conditions                                                 40.00
      NBFILS = 0                                                          40.00
      NBSPEC = 0                                                          40.00
      NBGRPT = 0                                                          40.00
      FSHAPE = 2                                                          40.00
      DSHAPE = 2                                                          40.00
      PSHAPE(1) = 3.3                                                     40.00
      PSHAPE(2) = 0.1                                                     40.00
*     ***** input grids *****
      DO 80 IGRID = 1, NUMGRD
        XPG(IGRID)    = 0.
        YPG(IGRID)    = 0.
        ALPG(IGRID)   = 0.
        COSPG(IGRID)  = 1.                                                40.13
        SINPG(IGRID)  = 0.
        DXG(IGRID)    = 0.
        DYG(IGRID)    = 0.
        MXG(IGRID)    = 0
        MYG(IGRID)    = 0
        LEDS(IGRID)   = 0
        STAGX(IGRID)  = 0.                                                30.21
        STAGY(IGRID)  = 0.                                                30.21
        EXCFLD(IGRID) = -1.E20                                            30.60
        IFLDYN(IGRID) = 0                                                 40.00
        IFLTIM(IGRID) = -1.E20                                            40.00
  80  CONTINUE
*     ***** computational grid *****
      MXC    = 0
      MYC    = 0
      MSC    = 0
      MDC    = 0
      MTC    = 1
      ICOMP  = 1
      ALPC   = 0.
      FULCIR = .TRUE.
      SPDIR1 = 0.
*     number of points needed in computational stencil:
      ICMAX  = 3
*     ***** numerical scheme *****
      NCOR   = 1
      IWCAP  = 1                                                          21/MAY
      NSTATM = -1                                                         40.00
      NSTATC = -1                                                         40.00
      ITRIAD = 0
C
C Quadruplets are now default on, since GEN3 KOM is default and the command
C GEN3 KOM did set the quadruplet source terms on.
C
      IQUAD  = 2                                                          30.72
C
      IBOT   = 0
      ICMAX  = 3
C     initialise number of iterations stationary and nonstationary        40.03
      MXITST = 15                                                         40.03
      MXITNS = 1                                                          40.03
      ITERMX = MXITST                                                     40.03
      ICUR   = 0
      IDIF   = 0
      IINC   = 0
C
C     IREFR = -1: limiter on Ctheta activated                             30.80
C     IREFR =  1: No limiter on Ctheta                                    30.80
C     IREFR =  0: No refraction                                           30.80
C
      IREFR  = 1                                                          40.02
      ITFRE  = 1
      ISURF  = 1
      ITRSY  = 1
      IWIND  = 0
      IGEN   = 3                                                          32.06
      VARWI  = .FALSE.
      VARFR  = .FALSE.
      VARWLV = .FALSE.                                                    20.38
      VARAST = .FALSE.       ! True means spatially variable air-sea t.d. 40.03
      U10    = 0.
      WDIP   = 0.
      INRHOG = 0                                                          30.20
      DEPMIN = 0.05
      SY0    = 3.3
      SIGMAG = 0.1
      XOFFS  = 0.
      YOFFS  = 0.
      LXOFFS = .FALSE.
      NESRUN = 0                                                          30.00
      DYNDEP = .FALSE.                                                    40.00
      NWAMN = 0
      MXOUTAR = 0
*
*     *** Initial conditions ***
      ICOND = 0                                                          060697
C
C     *** Initial conditions for common SWANWL                  ***       32.02
C
      BNAUT  = .FALSE.                                                    32.01
      BNDCHK = .TRUE.                                                     32.01
      BRESCL = .TRUE.                                                     40.00
      ONED   = .FALSE.                                                    32.02
      ACUPDA = .TRUE.                                                     40.07
      HSRERR = 0.1                                                        32.01
C
C     higher order propagation and spherical coordinates                  33.08
C
      PROJ_METHOD = 0                                                     33.09
      PROPSS = 2                                                          33.08
      PROPSN = 3                                                          33.08
      PROPSC = 1                                                          33.08
      PROPSL = 1                                                          33.08
      WAVAGE = 0.                                                         33.08
      KSPHER = 0                                                          33.09
      KREPTX = 0                                                          33.09
      REARTH = 2.E7/PI                                                    33.09
      LENDEG = 2.E7/180.                                                  33.09
C
C     *** setup flag ***                                                  32.02
      LSETUP = 0                                                          32.02
C
C     *** flag for setup convergence                                      30.82
C
      CSETUP = .TRUE.                                                     30.82
C
C
C     PSETUP(1) is currently unused, but can be used as setup nesting flag
C     PSETUP(2) is the user defined correction for the level of the setup
C
      PSETUP(1) = 0.0                                                     30.82
      PSETUP(2) = 0.0                                                     30.82
C
C     *** ACCURACY criterion ***
C
C     *** relative error in significant wave height and mean period ***
      PNUMS(1)  = 0.02                                                    30.82
C     *** absolute error in significant wave heigth (m) ***
      PNUMS(2)  = 0.03
C     *** absolute error in mean wave period (s) ***
      PNUMS(3)  = 0.3
C     *** total number of wet gridpoints were accuarcy has ***
C     *** been reached                                     ***
      PNUMS(4)  = 98.00
C
C     *** DIFFUSION schemes ***
C
C     *** Numerical diffusion over theta ***
      PNUMS(6)  = 0.5                                                     20.78
C     *** Numerical diffusion over sigma ***
      PNUMS(7)  = 0.5                                                     20.78
C     *** Explicit or implicit scheme in frequency space ***
C     *** default = implicit : PNUMS(8) = 1              ***
      PNUMS(8) = 1.
C     *** diffusion coefficient for explicit scheme ***
      PNUMS(9) = 0.01
C
C     *** LINEAR CGSTAB SOLVER schemes  ***
C
C     *** PNUMS(10) : value for preconditioner CGSTAB solver   ***
C     ***   0   no preconditioner                              ***
C     ***  -1   diagonal preconditioner                        ***
C     ***  -3   ILU preconditioner (in general the best choice ***
C
C     *** Required accuracy, the iter. method stops           ***
C     ***                                                     ***
C     ***  || Ax-b ||  <   eps1 + eps2 * || Ax - b ||         ***
C     ***                                     o               ***
C     ***  eps1 = PNUMS(11)   eps2 = PNUMS(12)                ***
C
C     *** PNUMS(13) output for CGSTAB solver : possible values ***
C     ***     <0  : no output                                  ***
C     ***      0  : only fatal errors will be printed          ***
C     ***      1  : additional information about the iteration ***
C     ***           is printed                                 ***
C     ***      2  : gives a maximal amount of output           ***
C     ***           concerning the iteration process           ***
C
C     *** PNUMS(14) : maximal number of iteration to be performed ***
C     *** in each of the solution methods                         ***
C
      PNUMS(10) = -3.
      PNUMS(11) = 1.E-6
      PNUMS(12) = 1.E-4
      PNUMS(13) = 0.
      PNUMS(14) = 20.
C
C     For the setup seperate values can be used:
C
C     PNUMS(22)~PNUMS(10); PNUMS(23)~PNUMS(12); PNUMS(24)~PNUMS(13)
C     PNUMS(25)~PNUMS(14)
C
      PNUMS(22) = -3.                                                     30.82
      PNUMS(23) = 1.E-4                                                   30.82
      PNUMS(24) = 0.                                                      30.82
      PNUMS(25) = 20.                                                     30.82
C
C Maximum growth in spectral bin. Now has the value according to the default
C in the command GEN3 KOM
C
      PNUMS(20) = 0.1                                                     30.72
C
C     *** set the values of PNUMS that are not used equal 0. ***
C
      PNUMS(5)  = 0.
C
C     The allowed global errors in the iteration procedure:               30.82
C     PNUMS(15) for Hs and PNUMS(16) for Tm01                             30.82
C
      PNUMS(15) = 0.02                                                    30.82
      PNUMS(16) = 0.02                                                    30.82
C
C     coefficient for limitation of Ctheta                                30.80
C     default no limitation on refraction                                 40.02
C
      PNUMS(17) = -1.                                                     40.02
*
*     Limitation on Froude number; current velocity is reduced if greater
*     than Pnums(18)*Sqrt(grav*depth)
*
      PNUMS(18) = 0.8                                                     30.50
C
C     *** CFL criterion for ecplicit scheme in frequency space ***
C
      PNUMS(19) = 0.5 * sqrt (2.)
C
C     *** numerical diffusion coefficient in SORDUP scheme ***
C
      PNUMS(26) = 0.0                                                     33.10
C
C     *** (1) and (2): Komen et al. (1984) formulation ***
C
      PWCAP(1)  = 2.36E-5
      PWCAP(2)  = 3.02E-3
      PWCAP(9)  = 2.                                                      34.00
      PWCAP(10) = 0.                                                      34.00
      PWCAP(11) = 1.                                                      34.00
C
C     *** (3): Coefficient for Janssen(1989,1991) formulation ***
C     ** according to Komen et al. (1994) ***
C
      PWCAP(3)  = 4.5
      PWCAP(4)  = 0.5
C
C     *** (5): Coefficient for Longuet-Higgins ***
C
      PWCAP(5) = 1.
C
C     *** (6): ALPHA in Battjes/Janssen ***
C
      PWCAP(6) = 0.88
      PWCAP(7) = 1.
      PWCAP(8) = 0.75
C
*     PBOT(1)   = 0.005          modified
      PBOT(1)   = 0.0                                                     20.68
      PBOT(2)   = 0.015                                                   20.68
      PBOT(3)   = 0.067
      PBOT(4)   = -0.08
      PBOT(5)   = 0.05
*
      PSURF(1)  = 1.0
      PSURF(2)  = 0.73                                                    20.67
*
      PTRIAD(1)  = 0.1                                                    30.82
      PTRIAD(2)  = 2.2                                                    30.82
      PTRIAD(3)  = 0.1                                                    30.82
      PTRIAD(4)  = 0.2                                                    40.13
C
C     *** if the Lumped Triad Approximation of Eldeberky (1996) is used    rr
C     *** the coefficient for PTRIAD(1) should be set equal to 0.25          rr
C     **** moreover: the coefficient to calculate the maximum discrete      rr
C     *** is stored in PTRIAD (2)  --> value has to be 2.5                   rr
C     PTRIAD(1) = 0.25                                                       rr
C     PTRIAD(2) = 2.5                                                        rr
C
C     quadruplet interactions
      PQUAD(1) = 0.25                                                     34.00
      PQUAD(2) = 3.E7                                                     34.00
      PQUAD(3) = 5.5                                                      34.00
      PQUAD(4) = 0.833                                                    34.00
      PQUAD(5) = -1.25                                                    34.00
C
      PWIND(1)  = 188.0
      PWIND(2)  = 0.59
      PWIND(3)  = 0.12
      PWIND(4)  = 250.0
      PWIND(5)  = 0.0023
      PWIND(6)  = -0.223
      PWIND(7)  = 0.
      PWIND(8)  = -0.56
      PWIND(10) = 0.0036
      PWIND(11) = 0.00123
      PWIND(12) = 1.0
      PWIND(13) = 0.13
C     *** Janssen (1991) wave growth model ***
C     *** alpha ***
      PWIND(14) = 0.01
c      PWIND(14) = 0.0144
C     *** carnock: kappa ***
      PWIND(15) = 0.41
c     *** rho air ****
      PWIND(16) = 1.28
C     *** rho water ***
      PWIND(17) = RHO
      PWIND(9)  = PWIND(16) / RHO
*     Coefficient in front of A term in 3d gen. growth term
*     default is 0; can be made non-zero in command GEN3 or GROWTH
      PWIND(31) = 0.                                                      7/MAR
*
*     pointers in array COMPDA
      JDISS = 2
      JUBOT = 3
      JQB   = 4
      JSTP  = 5
      JDHS  = 6
      JDP1  = 7
      JDP2  = 8
      JVX1  = 9
      JVY1  = 10
      JVX2  = 11
      JVY2  = 12
      JVX3  = 13
      JVY3  = 14
      JDP3  = 15
      JWX2  = 16                                                          40.00
      JWY2  = 17                                                          40.00
      JWX3  = 18                                                          40.00
      JWY3  = 19                                                          40.00
      JDTM  = 20                                                          40.00
      JLEAK = 21                                                          40.00
      JWLV1 = 22                                                          40.00
      JWLV3 = 23                                                          40.00
      JWLV2 = 24                                                          40.00
      JHSIBC = 25                                                         40.00
      JHS    = 26                                                         40.13
      JURSEL = 27                                                         40.13
      MCMVAR = 27                                                         40.13
!     subarray sequence number 1 is used only for unused subarrays        40.13
      JFRC2 = 1                                                           40.00
      JFRC3 = 1                                                           40.00
      JUSTAR= 1                                                           30.22
      JZEL  = 1                                                           30.22
      JTAUW = 1                                                           30.22
      JCDRAG= 1                                                           30.22
*     added for air-sea temp. diff.:
      JASTD2= 1                                                           40.03
      JASTD3= 1                                                           40.03
C
C     *** added for wave setup ***                                        32.01
C
      JSETUP = 1                                                          32.02
      JDPSAV = 1                                                          32.02
      JWFRCX = 1                                                          31.02
      JWFRCY = 1                                                          31.02
C
*     ***** test output control *****
      ITEST  = 0
      INTES = 0                                                           30.50
      ICOTES = 0                                                          30.50
      IOUTES = 0                                                          30.50
      ITRACE = 0
      LTRACE = .FALSE.
      LEVERR = 0
      MAXERR = 1
      TESTFL = .FALSE.
      NPTST  = 0
      NPTSTA = 1
      LXDMP  = -1
      LYDMP  = 0
      NEGMES = 0
      MAXMES = 200
      SYMSIZ = 0.25                                                       17/FEB
      IFPAR = 0                                                           40.00
      IFS1D = 0                                                           40.00
      IFS2D = 0                                                           40.00
!     number of obstacles initialised at 0                                40.13
      NUMOBS = 0                                                          40.13
*     ***** output *****
      IUBOTR = 0
*     ***** plot output *****
      LEFT   = .TRUE.
C
      DO IVT = 1, NMOVAR
        OVKEYW(IVT) = 'XXXX'                                              40.00
      ENDDO
C
C     properties of output variables
C
      IVTYPE = 1
*     keyword used in SWAN command
      OVKEYW(IVTYPE)  = 'XP'                                              40.00
*     short name
      OVSNAM(IVTYPE)  = 'Xp'
*     long name
      OVLNAM(IVTYPE)  = 'X user coordinate'
*     unit name
      OVUNIT(IVTYPE)  = UL
*     type (scalar/vector etc.)
      OVSVTY(IVTYPE)  = 1
*     lower and upper limit
      OVLLIM(IVTYPE) = -1.E10
      OVULIM(IVTYPE) = 1.E10
*     lowest and highest expected value
      OVLEXP(IVTYPE) = -1.E10
      OVHEXP(IVTYPE) = 1.E10
*     exception value
      OVEXCV(IVTYPE) = -1.E10
*
      IVTYPE = 2
      OVKEYW(IVTYPE) = 'YP'                                               40.00
      OVSNAM(IVTYPE) = 'Yp'
      OVLNAM(IVTYPE) = 'Y user coordinate'
      OVUNIT(IVTYPE) = UL
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = -1.E10
      OVULIM(IVTYPE) = 1.E10
      OVLEXP(IVTYPE) = -1.E10
      OVHEXP(IVTYPE) = 1.E10
      OVEXCV(IVTYPE) = -1.E10
*
      IVTYPE = 3
      OVKEYW(IVTYPE) = 'DIST'                                             40.00
      OVSNAM(IVTYPE) = 'Dist'
      OVLNAM(IVTYPE) = 'distance along output curve'
      OVUNIT(IVTYPE) = UL
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.E10
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.E10
      OVEXCV(IVTYPE) = -99.
*
      IVTYPE = 4
      OVKEYW(IVTYPE) = 'DEP'                                              40.00
      OVSNAM(IVTYPE) = 'Depth'
      OVLNAM(IVTYPE) = 'Depth'
      OVUNIT(IVTYPE) = UH
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = -1.E4
      OVULIM(IVTYPE) = 1.E4
      OVLEXP(IVTYPE) = -100.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -99.
*
      IVTYPE = 5
      OVKEYW(IVTYPE) = 'VEL'                                              40.00
      OVSNAM(IVTYPE) = 'Vel'
      OVLNAM(IVTYPE) = 'Current velocity'
      OVUNIT(IVTYPE) = UV
      OVSVTY(IVTYPE) = 3
      OVLLIM(IVTYPE) = -100.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = -2.
      OVHEXP(IVTYPE) = 2.
      OVEXCV(IVTYPE) = 0.
*
      IVTYPE = 6
      OVKEYW(IVTYPE) = 'UBOT'                                             40.00
      OVSNAM(IVTYPE) = 'Ubot'
      OVLNAM(IVTYPE) = 'Orbital velocity at the bottom'
      OVUNIT(IVTYPE) = UV
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 10.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -10.
*
      IVTYPE = 7
      OVKEYW(IVTYPE) = 'DISS'                                             40.00
      OVSNAM(IVTYPE) = 'Dissip'
      OVLNAM(IVTYPE) = 'Energy dissipation'
      OVUNIT(IVTYPE) = 'm2/s'
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 8
      OVKEYW(IVTYPE) = 'QB'                                               40.00
      OVSNAM(IVTYPE) = 'Qb'
      OVLNAM(IVTYPE) = 'Fraction breaking waves'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -1.
*
      IVTYPE = 9
      OVKEYW(IVTYPE) = 'LEA'                                              40.00
      OVSNAM(IVTYPE) = 'Leak'
      OVLNAM(IVTYPE) = 'Energy leak over spectral boundaries'
      OVUNIT(IVTYPE) = 'm2/s'
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 10
      OVKEYW(IVTYPE) = 'HS'                                               40.00
      OVSNAM(IVTYPE) = 'Hsig'
      OVLNAM(IVTYPE) = 'Significant wave height'
      OVUNIT(IVTYPE) = UH
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 10.
      OVEXCV(IVTYPE) = -9.
*                                                        modified 10.09
      IVTYPE = 11
      OVKEYW(IVTYPE) = 'TM01'                                             40.00
      OVSNAM(IVTYPE) = 'Tm01'                                             20.81
      OVLNAM(IVTYPE) = 'Average absolute wave period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 12
      OVKEYW(IVTYPE) = 'RTP'                                              40.00
      OVSNAM(IVTYPE) = 'Tpeak'                                            20.81
      OVLNAM(IVTYPE) = 'Peak period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 13
      OVKEYW(IVTYPE) = 'DIR'                                              40.00
      OVSNAM(IVTYPE) = 'Dir'
      OVLNAM(IVTYPE) = 'Average wave direction'
      OVUNIT(IVTYPE) = UDI                                                30.72
      OVSVTY(IVTYPE) = 2
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 360.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 360.
      OVEXCV(IVTYPE) = -999.
*
      IVTYPE = 14
      OVKEYW(IVTYPE) = 'PDI'                                              40.00
      OVSNAM(IVTYPE) = 'PkDir'
      OVLNAM(IVTYPE) = 'direction of the peak of the spectrum'
      OVUNIT(IVTYPE) = UDI                                                30.72
      OVSVTY(IVTYPE) = 2
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 360.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 360.
      OVEXCV(IVTYPE) = -999.
*
      IVTYPE = 15
      OVKEYW(IVTYPE) = 'TDI'                                              40.00
      OVSNAM(IVTYPE) = 'TDir'
      OVLNAM(IVTYPE) = 'direction of the energy transport'
      OVUNIT(IVTYPE) = UDI                                                30.72
      OVSVTY(IVTYPE) = 2
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 360.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 360.
      OVEXCV(IVTYPE) = -999.
*
      IVTYPE = 16
      OVKEYW(IVTYPE) = 'DSPR'                                             40.00
      OVSNAM(IVTYPE) = 'Dspr'
      OVLNAM(IVTYPE) = 'directional spreading'
      OVUNIT(IVTYPE) = UDI                                                30.72
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 360.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 60.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 17
      OVKEYW(IVTYPE) = 'WLEN'                                             40.00
      OVSNAM(IVTYPE) = 'Wlen'
      OVLNAM(IVTYPE) = 'Average wave length'
      OVUNIT(IVTYPE) = UL
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 200.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 18
      OVKEYW(IVTYPE) = 'STEE'                                             40.00
      OVSNAM(IVTYPE) = 'Steepn'
      OVLNAM(IVTYPE) = 'Wave steepness'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 0.1
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 19
      OVKEYW(IVTYPE) = 'TRA'                                              40.00
      OVSNAM(IVTYPE) = 'Transp'
      OVLNAM(IVTYPE) = 'Wave energy transport'
      OVUNIT(IVTYPE) = 'm3/s'                                             40.00
      OVSVTY(IVTYPE) = 3
      OVLLIM(IVTYPE) = -100.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = -10.
      OVHEXP(IVTYPE) = 10.
      OVEXCV(IVTYPE) = 0.
*
      IVTYPE = 20
      OVKEYW(IVTYPE) = 'FOR'                                              40.00
      OVSNAM(IVTYPE) = 'WForce'
      OVLNAM(IVTYPE) = 'Wave driven force per unit surface'
      OVUNIT(IVTYPE) = UF                                                 30.72
      OVSVTY(IVTYPE) = 3
      OVLLIM(IVTYPE) = -1.E5
      OVULIM(IVTYPE) =  1.E5
      OVLEXP(IVTYPE) = -10.
      OVHEXP(IVTYPE) =  10.
      OVEXCV(IVTYPE) = 0.
*
      IVTYPE = 21
      OVKEYW(IVTYPE) = 'AAAA'                                             40.00
      OVSNAM(IVTYPE) = 'AcDens'
      OVLNAM(IVTYPE) = 'spectral action density'
      OVUNIT(IVTYPE) = 'm2s'
      OVSVTY(IVTYPE) = 5
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -99.
*
      IVTYPE = 22
      OVKEYW(IVTYPE) = 'EEEE'                                             40.00
      OVSNAM(IVTYPE) = 'EnDens'
      OVLNAM(IVTYPE) = 'spectral energy density'
      OVUNIT(IVTYPE) = 'm2'
      OVSVTY(IVTYPE) = 5
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -99.
*
      IVTYPE = 23
      OVKEYW(IVTYPE) = 'AAAA'                                             40.00
      OVSNAM(IVTYPE) = 'Aux'
      OVLNAM(IVTYPE) = 'auxiliary variable'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = -1.E10
      OVULIM(IVTYPE) = 1.E10
      OVLEXP(IVTYPE) = -1.E10
      OVHEXP(IVTYPE) = 1.E10
      OVEXCV(IVTYPE) = -1.E10
*
      IVTYPE = 24
      OVKEYW(IVTYPE) = 'XC'                                               40.00
      OVSNAM(IVTYPE) = 'Xc'
      OVLNAM(IVTYPE) = 'X computational grid coordinate'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 25
      OVKEYW(IVTYPE) = 'YC'                                               40.00
      OVSNAM(IVTYPE) = 'Yc'
      OVLNAM(IVTYPE) = 'Y computational grid coordinate'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 26
      OVKEYW(IVTYPE) = 'WIND'                                             40.00
      OVSNAM(IVTYPE) = 'Windv'
      OVLNAM(IVTYPE) = 'Wind velocity at 10 m above sea level'
      OVUNIT(IVTYPE) = UV                                                 30.72
      OVSVTY(IVTYPE) = 3
      OVLLIM(IVTYPE) = -100.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = -50.
      OVHEXP(IVTYPE) = 50.
      OVEXCV(IVTYPE) = 0.
*
      IVTYPE = 27
      OVKEYW(IVTYPE) = 'FRC'                                              40.00
      OVSNAM(IVTYPE) = 'FrCoef'
      OVLNAM(IVTYPE) = 'Bottom friction coefficient'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*                                                                     new 10.09
      IVTYPE = 28
      OVKEYW(IVTYPE) = 'RTM01'                                            40.00
      OVSNAM(IVTYPE) = 'RTm01'                                            20.81
      OVLNAM(IVTYPE) = 'Average relative wave period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 29                                                         20.28
      OVKEYW(IVTYPE) = 'EEEE'                                             40.00
      OVSNAM(IVTYPE) = 'EnDens'
      OVLNAM(IVTYPE) = 'energy density integrated over direction'         20.28
      OVUNIT(IVTYPE) = 'm2'
      OVSVTY(IVTYPE) = 5
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -99.
*
      IVTYPE = 30                                                         20.52
      OVKEYW(IVTYPE) = 'DHS'                                              40.00
      OVSNAM(IVTYPE) = 'dHs'
      OVLNAM(IVTYPE) = 'difference in Hs between iterations'
      OVUNIT(IVTYPE) = UH
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 31                                                         20.52
      OVKEYW(IVTYPE) = 'DRTM01'                                           40.00
      OVSNAM(IVTYPE) = 'dTm'
      OVLNAM(IVTYPE) = 'difference in Tm between iterations'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 2.
      OVEXCV(IVTYPE) = -9.
*                                                                         20.61
      IVTYPE = 32
      OVKEYW(IVTYPE) = 'TM02'                                             40.00
      OVSNAM(IVTYPE) = 'Tm02'
      OVLNAM(IVTYPE) = 'Zero-crossing period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*                                                                         20.61
      IVTYPE = 33
      OVKEYW(IVTYPE) = 'FSPR'                                             40.00
      OVSNAM(IVTYPE) = 'FSpr'                                             20.67
      OVLNAM(IVTYPE) = 'Frequency spectral width (Kappa)'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 34                                                         20.67
      OVKEYW(IVTYPE) = 'URMS'                                             40.00
      OVSNAM(IVTYPE) = 'Urms'
      OVLNAM(IVTYPE) = 'RMS of orbital velocity at the bottom'
      OVUNIT(IVTYPE) = UV
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 10.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 35                                                         30.22
      OVKEYW(IVTYPE) = 'UFRI'                                             40.00
      OVSNAM(IVTYPE) = 'Ufric'
      OVLNAM(IVTYPE) = 'Friction velocity'
      OVUNIT(IVTYPE) = UV
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 10.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 36                                                         30.22
      OVKEYW(IVTYPE) = 'ZLEN'                                             40.00
      OVSNAM(IVTYPE) = 'Zlen'
      OVLNAM(IVTYPE) = 'Zero velocity thickness of boundary layer'
      OVUNIT(IVTYPE) = UL
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 37                                                         30.22
      OVKEYW(IVTYPE) = 'TAUW'                                             40.00
      OVSNAM(IVTYPE) = 'TauW'
      OVLNAM(IVTYPE) = '    '
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 10.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 38                                                         30.22
      OVKEYW(IVTYPE) = 'CDRAG'                                            40.00
      OVSNAM(IVTYPE) = 'Cdrag'
      OVLNAM(IVTYPE) = 'Drag coefficient'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
C
C     *** wave-induced setup ***                                          32.02
C
      IVTYPE = 39                                                         32.02
      OVKEYW(IVTYPE) = 'SETUP'                                            40.00
      OVSNAM(IVTYPE) = 'Setup'                                            32.02
      OVLNAM(IVTYPE) = 'Setup due to waves'                               32.02
      OVUNIT(IVTYPE) = 'm'                                                32.02
      OVSVTY(IVTYPE) = 1                                                  32.02
      OVLLIM(IVTYPE) = -1.                                                32.02
      OVULIM(IVTYPE) = 1.                                                 32.02
      OVLEXP(IVTYPE) = -1.                                                32.02
      OVHEXP(IVTYPE) = 1.                                                 32.02
      OVEXCV(IVTYPE) = -9.                                                32.02
*
      IVTYPE = 40                                                         40.00
      OVKEYW(IVTYPE) = 'TIME'                                             40.00
      OVSNAM(IVTYPE) = 'Time'
      OVLNAM(IVTYPE) = 'Date-time'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -99999.
*
      IVTYPE = 41                                                         40.00
      OVKEYW(IVTYPE) = 'TSEC'                                             40.00
      OVSNAM(IVTYPE) = 'Tsec'
      OVLNAM(IVTYPE) = 'Time in seconds from reference time'
      OVUNIT(IVTYPE) = 's'
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 100000.
      OVLEXP(IVTYPE) = -100000.
      OVHEXP(IVTYPE) = 1000000.
      OVEXCV(IVTYPE) = -99999.
*                                                        new              40.00
      IVTYPE = 42
      OVKEYW(IVTYPE) = 'PER'                                              40.00
      OVSNAM(IVTYPE) = 'Period'                                           40.00
      OVLNAM(IVTYPE) = 'Average absolute wave period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*                                                        new              40.00
      IVTYPE = 43
      OVKEYW(IVTYPE) = 'RPER'                                             40.00
      OVSNAM(IVTYPE) = 'Period'                                           40.00
      OVLNAM(IVTYPE) = 'Average relative wave period'
      OVUNIT(IVTYPE) = UT
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1000.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 100.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 44                                                         40.00
      OVKEYW(IVTYPE) = 'HSWE'                                             40.00
      OVSNAM(IVTYPE) = 'Hswell'
      OVLNAM(IVTYPE) = 'Wave height of swell part'
      OVUNIT(IVTYPE) = UH
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 100.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 10.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 45
      OVKEYW(IVTYPE) = 'URSELL'                                           40.03
      OVSNAM(IVTYPE) = 'Ursell'
      OVLNAM(IVTYPE) = 'Ursell number'
      OVUNIT(IVTYPE) = ' '
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = 0.
      OVULIM(IVTYPE) = 1.
      OVLEXP(IVTYPE) = 0.
      OVHEXP(IVTYPE) = 1.
      OVEXCV(IVTYPE) = -9.
*
      IVTYPE = 46
      OVKEYW(IVTYPE) = 'ASTD'                                             40.03
      OVSNAM(IVTYPE) = 'ASTD'
      OVLNAM(IVTYPE) = 'Air-Sea temperature difference'
      OVUNIT(IVTYPE) = 'K'
      OVSVTY(IVTYPE) = 1
      OVLLIM(IVTYPE) = -50.
      OVULIM(IVTYPE) =  50.
      OVLEXP(IVTYPE) = -10.
      OVHEXP(IVTYPE) =  10.
      OVEXCV(IVTYPE) = -99.
*
*     various parameters for computation of output quantities             40.00
*
*     reference time for TSEC
      OUTPAR(1) = 0.
*     power in expression for PER and RPER
*     previous name: SPCPOW
      OUTPAR(2) = 1.
*     power in expression for WLEN
*     previous name: AKPOWR
      OUTPAR(3) = 1.
C     indicator for direction
C     =0: direction always w.r.t. user coordinates; =1: dir w.r.t. frame
      OUTPAR(4) = 0.
C     frequency limit for swell
      OUTPAR(5) = 0.1
C
      RETURN
* * end of subroutine SWINIT *
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE SWPREP (OUTDA ,XCGRID ,YCGRID ,KGRPNT , OBSTA, CROSS,    30.72
     &                   KGRBND)                                          40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.09: Annette Kieftenburg
C
C  1. Updates
C
C     20.70, Jan. 96: new name, SPRCON is now called from this subr
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Mar. 98: loop over grid points moved into subr SWOBST
C                     erroneous usage of SWPDIR removed
C                     close input files containing stationary input fields
C     30.82, Oct. 98: Added INTEGER declaration of array OBSTA(*)
C     40.00, Feb. 99: DYNDEP is made True, if depth or water level nonstationary
C     40.09, Aug. 00: If obstacle is on computational grid point it is moved a bit
C     40.02, Oct. 00: Array KGRBND now has a dimension
C     40.02, Oct. 00: Initialisation of IERR
C
*  2. Purpose
*
*     Computation of the transformation coefficients between the
*     different grids
*
*  3. Method
*
*     The following transformation coefficients are computed:
*       - XCP, YCP, ALCP; used for computing computational coordinates
*         (R) from problem coordinates (P)
*       - XBC, YBC, ALBC; used for computing bottom grid coordinates
*         (B) from computational grid coordinates (R)
*     These coefficients are computed from the common variables XPC,
*     YPC, ALPC, XPB, YPB and ALPB.
*
C  4. Argument variables
C
      INTEGER, INTENT(INOUT) :: KGRBND(*)                                 40.02
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
      INTEGER :: IERR = 0                                                 40.02
*
*  5. SUBROUTINES CALLING
*
*       SWREAD
*
*  6. SUBROUTINES USED
*
*       ODLOC (SWAN/SER)
C       OBSTMOVE
C       SWOBST                                                            40.09
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       Compute origin of computational grid in problem grid XPC, YPC
*       Compute origin of problem grid in computationl grid coordinates
*       Check input fields
*       Close files containing stationary input fields
*       Compute crossing of comp.grid lines with obstacles
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
      INTEGER   OUTDA(*) ,KGRPNT(MXC,MYC),
     &          CROSS(2,MCGRD), OBSTA(*)                                      30.82
C
C
      CHARACTER PNAME *8, PTYPE *1
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT, 'SWPREP')
*
*     coefficients for transformation from user coordinates to comp. coord.
*
      COSPC = COS(ALPC)
      SINPC = SIN(ALPC)
      XCP   = -XPC*COSPC - YPC*SINPC
      YCP   =  XPC*SINPC - YPC*COSPC
      ALCP  = -ALPC
*
*     wind direction w.r.t. computational grid
*
*     ALTMP = (WDIP - ALPC) / PI2              removed 30.50
      ALTMP = (WDIP) / PI2                                                13/JAN
      WDIC  = PI2 * (ALTMP - NINT(ALTMP))
*
      IF (MCGRD.LE.0) CALL MSGERR
     & (3, 'no valid comp. grid; check commands CGRID and READ BOTT')     30.50
*
      IF (LEDS(1).EQ.0) CALL MSGERR (3,'Bottom grid not defined')
      IF (LEDS(1).EQ.1) CALL MSGERR (3,'No bottom levels read')
      IF (MXC.EQ.0) CALL MSGERR (3,'Computational grid not defined')
      IF (IUBOTR.EQ.1 .AND. IBOT.EQ.0)
     &    CALL MSGERR (1,'Bottom friction not on, UBOT not computed')
*
      IF (LEDS(2).EQ.2) THEN
        IF (LEDS(3).NE.2)
     &  CALL MSGERR (3, 'VY not read, while VX is read')
*       ALBC  = ALPC - ALPG(2)
        ALBC  = - ALPG(2)
        COSVC = COS(ALBC)
        SINVC = SIN(ALBC)
      ENDIF
*
      IF (LEDS(4).EQ.2) VARFR = .TRUE.
*
      IF (LEDS(5).EQ.2) THEN
        IF (LEDS(6).NE.2)
     &  CALL MSGERR (3, 'WY not read, while WX is read')
        VARWI = .TRUE.
*       ALBC  = ALPC - ALPG(5)
        ALBC  = - ALPG(5)
        COSWC = COS(ALBC)
        SINWC = SIN(ALBC)
      ENDIF
*
      IF (LEDS(7).EQ.2) VARWLV = .TRUE.                                   20.38
*
      IF (IFLDYN(1).EQ.1 .OR. IFLDYN(7).EQ.1) DYNDEP = .TRUE.             40.00
*
*     close input files containing stationary input fields                40.00
*
      DO IFLD = 1, NUMGRD
        IF (IFLDYN(IFLD).EQ.0 .AND. IFLNDS(IFLD).NE.0) THEN               40.00
          CLOSE (IFLNDS(IFLD))
          IFLNDS(IFLD) = 0
        ENDIF
      ENDDO
*
*     computation of tail factors for moments of action spectrum
*     IP=0: action int. IP=1: energy int. IP=2: first moment of energy etc.
*
      DO IP = 0, 3
        PPTAIL = PWTAIL(1) - REAL(IP)
        PWTAIL(5+IP) = 1. / (PPTAIL * (1. + PPTAIL * (FRINTH-1.)))        20.71
      ENDDO
*
*     check location of output areas
*
      PNAME = 'PSET'
      CALL DPINQP (OUTDA, PNAME, JPSET, PTYPE, IOUTPS,
     &             LENREC, IERR)
      CALL SPRCON (OUTDA(IADRS(OUTDA,JPSET)), XCGRID, YCGRID, KGRPNT,     30.72
     &             KGRBND)
C
C     *** for the four sweeps find                           ***
C     *** obstacles crossing the points in the stencil       ***
C
      IF (NUMOBS .GT. 0 ) THEN
        DO INDX = 1, MCGRD                                               040697
          CROSS(1,INDX) = 0                                              040697
          CROSS(2,INDX) = 0                                              040697
        ENDDO                                                            040697
C
        CALL OBSTMOVE (OBSTA, XCGRID, YCGRID, KGRPNT)                     40.09
        CALL SWOBST (OBSTA, XCGRID, YCGRID, KGRPNT, CROSS)                30.7N
C
        IF (ITEST .GE. 120) THEN                                          060697
          WRITE(PRINTF,102)
 102      FORMAT('Links with obstacles crossing',/,
     &    '     COMP COORD           LINK         VALUE')
          DO IIYY =2,MYC
            DO IIXX = 2,MXC
            I1 = KGRPNT(IIXX,IIYY)
              DO I2 = 1,2
                IF (CROSS(I2,I1) .NE. 0)
     &          WRITE(PRINTF,101) IIXX,IIYY,I2,I1,CROSS(I2,I1)
 101            FORMAT(' POINT(',I4,',',I4,')',
     &          '  CROSS(',I3,',',I5,')  = ',I5)
              ENDDO
            ENDDO
          ENDDO
        ENDIF
      ENDIF
*
      RETURN
* * end of subroutine SWPREP *
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE SPRCON (OUTPS, XCGRID, YCGRID, KGRPNT, KGRBND)           40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. AUTHORS
C
C     30.72: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     32.03: Roeland Ris & Cor van der Schelde (1D-version)
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.72, Sept 97: Replaced DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     32.02, Jan. 98: Introduced 1D-version
C     32.03  Feb. 98: corrections processed
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.02, Feb. 00: Removed obsolescent DO-construct
C     40.02, Oct. 00: Avoided scalar/array conflict
C
C  2. Purpose
C
C     Execution of some tests on the given model description
C
C  3. Method
C
C     This subroutine carries out the following tests:
C     - check if bottom and computational grid are defined (if MODIF=0)
C     - check on the location of the corner points of the computational
C       grid
C     - check on the location of output point sets
C
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      INTEGER :: KGRBND(*)                                                40.02
C
      REAL    :: XCGRID(MXC,MYC), YCGRID(MXC,MYC)                         30.72
C
C     OUTDA   int.array  i/o   contains output data
C
C  6. Local variables
C
C     I, J    counters
C
      INTEGER I, J
C
C     XR      x (comp. grid coord.)
C     YR      y (comp. grid coord.)
C
      REAL    XR, YR
C
C  8. Subroutines used
C
C     COPYCH
C     MSGERR (both Ocean Pack)
C     SINBTG
C     SINUPT (both SWAN/SER)
C
C  9. Subroutines calling
C
C     SWREAD
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Check whether bottom grid and computational grid are defined
C     and if the bottom and current are read
C     For every corner point of the computational grid do
C         Compute problem grid coordinates
C         If corner point is outside bottom grid (SINBTG = false), then
C             Call MSGERR to generate a warning
C     If computational grid is rotating (ICOMP = 0), then
C         If the rotation point is out of the bottom grid, then
C             Call MSGERR to generate an error message
C     Else
C         Compute coordinates of the center of the computational grid
C         If the center is outside the bottom grid, then
C             Call MSGERR to generate an error message
C     Read number of output pointsets in array IOUTD
C     If number of pointsets is not 0, then
C         For every pointset do
C             Call COPYCH to read the name from IOUTD
C             If the pointset is not the bottom grid, comp. grid or set
C               of lines or places and recordlength > 0, then
C                 Read type of pointset
C                 If pointset is of type F (frame), then
C                     Check location of the cornerpoints in bottom grid
C                       and computational grid
C                 If pointset is of type C (curve), then
C                     Check locations of all end points of the curves
C                 If pointset is of type P (points), then
C                     Check location of all the points
C                 If pointset is of typr R (rays), then
C                     Check end points of first and last ray
C                 If pointset is of type G (grid), then
C                     Check location of the cornerpoints in bottom grid
C                       and computational grid
C     ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER  OUTPS(*)                                                   30.72
      INTEGER  KGRPNT(MXC,MYC), IERR                                      40.02
      LOGICAL  SINBTG
      CHARACTER STYPE *1, PTYPE *1
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'SPRCON')
C
C     ***** test location of computational grid *****
C
      IF (OPTG .EQ. 1) THEN                                               30.21
C
C       regular grid
C
        IF (ONED) THEN                                                    32.02
C
C         For 1D-version:
C         *** Check angles of bottom grid and computational grid ***      32.02
C
          IF ( ABS((ALPG(1) - ALPC)) .GT. 0.0017 ) THEN                   32.02
            CALL MSGERR( 2, ' Difference between angle of bottom grid'//  32.02
     &                      ' (alpinp) and computational grid (alpc)')    32.02
            CALL MSGERR( 2, ' greater than 0.1 degrees.')                 32.02
          ENDIF                                                           32.02
C
C         *** Check location of computational grid ***                    32.02
C
          DO  I=0,1                                                       30.72
            XR = I*XCLEN
            XP = XPC + XR*COSPC
            YP = YPC + XR*SINPC
            IF (.NOT.SINBTG(XP,YP) ) THEN
              CALL MSGERR(1,'Corner of comp grid outside bottom grid')
              WRITE (PRINTF, 6010) XP+XOFFS, YP+YOFFS
            ENDIF                                                         30.72
          ENDDO
        ELSE                                                              32.02
C
C         two-dimensional case
C
          DO 11 I=0,1                                                     30.72
            DO 10 J=0,1
              XR = I*XCLEN
              YR = J*YCLEN
              XP = XPC + XR*COSPC - YR*SINPC
              YP = YPC + XR*SINPC + YR*COSPC
              IF (.NOT.SINBTG(XP,YP) ) THEN
                CALL MSGERR(1,'Corner of comp grid outside bottom grid')
                WRITE (PRINTF, 6010) XP+XOFFS, YP+YOFFS
 6010           FORMAT (' Coordinates :',2F10.2)
              ENDIF                                                       30.72
   10       CONTINUE                                                      30.72
   11     CONTINUE
        ENDIF
C
        XR = 0.5*XCLEN
        YR = 0.5*YCLEN
        XP = XPC + XR*COSPC - YR*SINPC
        YP = YPC + XR*SINPC + YR*COSPC
        IF (.NOT. SINBTG(XP,YP) ) THEN
          CALL MSGERR (2,' Centre of comp. grid outside bottom grid')
        ENDIF
      ENDIF                                                               30.21
*
*     ***** test location of output pointsets *****
      IERR = 0
      CALL DPCHEK (OUTPS, IERR)
      CALL DPINQA (OUTPS, LENARR, LENOCP, MREC, LENPNM,
     &             LENADT, IERR)
      IF (MREC .GT. 0) THEN
        DO 100 IREC=1,MREC
*         find name of point set for record IREC:
          SNAME  = '    '
          IERR = 0
          CALL DPINQP (OUTPS, SNAME, IREC, PTYPE, IADRES,
     &                 LENREC, IERR)
          IF (ITEST.GE.80) WRITE (PRTEST, 12) IREC, SNAME, PTYPE
  12      FORMAT (' test SPRCON ', I2, 1X, A8, 2X, A1)
C
C         bottom grid is excluded from the test
          IF (SNAME.EQ.'BOTTGRID') GOTO 100
C
C         computational grid is excluded from the test
          IF (SNAME.EQ.'COMPGRID') GOTO 100
C
          IF (LENREC .EQ. 0) GOTO 100
          STYPE = CHAR(OUTPS(IADRES+1))
C                                                                         32.02
C         *** Check other output locations ***                            32.02
C                                                                         32.02
          IF (STYPE.EQ.'F' .AND. OPTG .EQ. 1) THEN
C
C           check the four corners of the frame
C
            XQLEN = OCREAL(OUTPS(IADRES+2))
            YQLEN = OCREAL(OUTPS(IADRES+3))
            XPQ   = OCREAL(OUTPS(IADRES+4))
            YPQ   = OCREAL(OUTPS(IADRES+5))
            ALPQ  = OCREAL(OUTPS(IADRES+6))
            COSPQ = COS(ALPQ)
            SINPQ = SIN(ALPQ)
            IF (ONED) THEN                                                32.02
              DO  I=0,1                                                   30.72
                XQ = I*XQLEN
                XP = XPQ + XQ*COSPQ
                YP = YPQ + XQ*SINPQ
                CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,       30.72
     &                         KGRBND)                                    40.00
              ENDDO                                                       30.72
            ELSE                                                          32.02
              DO 21 I=0,1                                                 30.72
                DO 20 J=0,1
                  XQ = I*XQLEN
                  YQ = J*YQLEN
                  XP = XPQ + XQ*COSPQ - YQ*SINPQ
                  YP = YPQ + XQ*SINPQ + YQ*COSPQ
                  CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,     30.72
     &                         KGRBND)                                    40.00
   20           CONTINUE                                                  30.72
   21         CONTINUE                                                    30.72
            ENDIF                                                         32.02
          ENDIF
C         --------------------------------------------------------------
          IF (STYPE .EQ. 'C') THEN
C
C           check first and last point of a curve
C
            MXK = OUTPS(IADRES+2)
            DO 30 IXK=1, MXK, MXK
              XP = OCREAL(OUTPS(IADRES+2*IXK+1))
              YP = OCREAL(OUTPS(IADRES+2*IXK+2))
              CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,         30.72
     &                     KGRBND)                                        40.00
   30       CONTINUE
          ENDIF
C         --------------------------------------------------------------
          IF (STYPE .EQ. 'P') THEN
C
C           check all individual output points
C
            MIP = OUTPS(IADRES+2)
            DO 40 IP=1,MIP
              XP = OCREAL(OUTPS(IADRES+2*IP+1))
              YP = OCREAL(OUTPS(IADRES+2*IP+2))
              CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,         30.72
     &                     KGRBND)                                        40.00
   40       CONTINUE
          ENDIF
C         --------------------------------------------------------------
          IF (STYPE .EQ. 'R') THEN
            MIP = OUTPS(IADRES+2)
            DO 50 IP=1,MIP, MIP
              XP = OCREAL(OUTPS(IADRES+4*IP-1))
              YP = OCREAL(OUTPS(IADRES+4*IP))
              XQ = OCREAL(OUTPS(IADRES+4*IP+1))
              YQ = OCREAL(OUTPS(IADRES+4*IP+2))
              CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,         30.72
     &                     KGRBND)                                        40.00
              CALL SINUPT (SNAME, XQ, YQ, XCGRID, YCGRID, KGRPNT,         30.72
     &                     KGRBND)                                        40.00
   50       CONTINUE
          ENDIF
*         --------------------------------------------------------------
**   stype = 'N'     VERSION 20.63
*
          IF (STYPE.EQ.'N') THEN
            MIP   = OUTPS(IADRES+2)
            XQLEN = OCREAL(OUTPS(IADRES+2*MIP+3))
            YQLEN = OCREAL(OUTPS(IADRES+2*MIP+4))
            XPQ   = OCREAL(OUTPS(IADRES+2*MIP+7))
            YPQ   = OCREAL(OUTPS(IADRES+2*MIP+8))
            ALPQ  = OCREAL(OUTPS(IADRES+2*MIP+9))
            COSPQ = COS(ALPQ)
            SINPQ = SIN(ALPQ)
            DO I=0,1                                                      40.02
              DO J=0,1                                                    40.02
                XQ = I*XQLEN
                YQ = J*YQLEN
                XP = XPQ + XQ*COSPQ - YQ*SINPQ
                YP = YPQ + XQ*SINPQ + YQ*COSPQ
                CALL SINUPT (SNAME, XP, YP, XCGRID, YCGRID, KGRPNT,       30.72
     &                       KGRBND)                                      40.00
              ENDDO                                                       40.02
            ENDDO                                                         40.02
          ENDIF
C
  100   CONTINUE
      ENDIF
C
      RETURN
C   * end of subroutine SPRCON *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWRBC (POOL   ,RPOOL, COMPDA, KGRPNT, XCGRID, YCGRID)    30.90
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     33.08: W. Erick Rogers
C
C  1. Updates
C
C     00.00, Nov. 86: existing version
C     00.01, Apr. 87: parameters added in call of subroutine SVALQI,
C                     some variable names changed (not common anymore)
C     30.60, Aug. 97: test on value of KGRPNT, skip part of code if
C                     KGRPNT(IX,IY)=1
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     32.01, Jan. 98: Initialise setup and saved depth for 1D-version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Mar. 98: proper water level stored in array COMPDA(*,JWLV2)
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Nov. 98: Now also interpolates curvilinear current input-fields
C                     (IGTYPE(2)=2)
C     40.00, Feb. 99: IDYNWI etc. replaced by IFLDYN(*)
C     33.08, July 98: minor changes related to the S&L scheme
C
C  2. Purpose
C
C     The depths and currents at a line in the computational grid are
C     determined and written to file with reference number NREF
C
C  3. Method
C
C     The depths and currents are computed by bilinear interpolation
C     and usually written to file INSTR.
C
C  4. Argument variables
C
C     KGRPNT
C     POOL
C
      INTEGER     POOL(*)                                                 30.72
      INTEGER     KGRPNT(MXC,MYC)                                         30.21
C
C     COMPDA
C     RPOOL                                                               30.90
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    COMPDA(MCGRD,MCMVAR)                                        30.21
      REAL    RPOOL(*)                                                    30.90
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C  6. Local variables
C
C     PTYPE*1
C     IERR
C
      CHARACTER   PTYPE *1
      INTEGER     IERR                                                  30.72
C
C  8. Subroutines used
C
C     ADPOOL (Ocean Pack)
C     SVALQI (SWAN/SER)
C
C  9. Subroutines calling
C
C     SWMAIN
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Call ADPOOL to enlarge poolarrays for depth and current
C     For every line IX of the computational grid do
C         For every point IY of this line do
C             Compute bottom grid coordinates as number of meshes
C             Call SVALQI to interpolate depth and current for the point
C             If current is on (ICUR = 1), then
C                 Compute current components relative to comp. grid
C             Else
C                 Current components are zero
C             --------------------------------------------------------
C             Store depth and current in poolarrays
C     ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SWRBC')
C
      IERR = 0
      CALL DPINQP (POOL, 'DEB', INDX, PTYPE, IDEB, LENR, IERR)
      IF (ICUR.EQ.1) THEN
        CALL DPINQP (POOL, 'UXB', INDX, PTYPE, IUXB, LENR, IERR)
        CALL DPINQP (POOL, 'UYB', INDX, PTYPE, IUYB, LENR, IERR)
      ENDIF
      IF (IFLDYN(2) .EQ. 1) THEN                                          40.00
        CALL DPINQP (POOL, 'UXB1', INDX, PTYPE, IUXB1, LENR, IERR)
        CALL DPINQP (POOL, 'UYB1', INDX, PTYPE, IUYB1, LENR, IERR)
        CALL DPINQP (POOL, 'UXB2', INDX, PTYPE, IUXB2, LENR, IERR)
        CALL DPINQP (POOL, 'UYB2', INDX, PTYPE, IUYB2, LENR, IERR)
      ENDIF
      IF (VARFR) THEN
        CALL DPINQP (POOL, 'FRI', INDX, PTYPE, IFRI, LENR, IERR)
      ENDIF
      IF (VARWI) THEN
        CALL DPINQP (POOL, 'WXI', INDX, PTYPE, IWXI, LENR, IERR)
        CALL DPINQP (POOL, 'WYI', INDX, PTYPE, IWYI, LENR, IERR)
      ENDIF
      IF (IFLDYN(5) .EQ. 1) THEN                                          40.00
        CALL DPINQP (POOL, 'WXI1', INDX, PTYPE, IWXI1, LENR, IERR)
        CALL DPINQP (POOL, 'WYI1', INDX, PTYPE, IWYI1, LENR, IERR)
        CALL DPINQP (POOL, 'WXI2', INDX, PTYPE, IWXI2, LENR, IERR)
        CALL DPINQP (POOL, 'WYI2', INDX, PTYPE, IWYI2, LENR, IERR)
      ENDIF
      IF (VARWLV) THEN
        CALL DPINQP (POOL, 'WLEV', INDX, PTYPE, IWLVI, LENR, IERR)      20.38
      ENDIF
      IF (IFLDYN(7) .EQ. 1) THEN                                          40.00
        CALL DPINQP (POOL, 'WLV1', INDX, PTYPE, IWLV1, LENR, IERR)
        CALL DPINQP (POOL, 'WLV2', INDX, PTYPE, IWLV2, LENR, IERR)
      ENDIF
      IF (VARAST) THEN
        CALL DPINQP (POOL, 'ASTD', INDX, PTYPE, IASTDI, LENR, IERR)       40.03
      ENDIF
*
      IF (ITEST .GE. 100 .OR. INTES .GE. 30) THEN
        WRITE(PRINTF,*) '  ', ICUR, IGTYPE(2)
        WRITE(PRINTF,*) '******** In subroutine SWRBC *******'            30.21
        IF (ICUR .EQ. 1 ) THEN
          WRITE(PRINTF,51)
        ELSE
          WRITE(PRINTF,50)
        ENDIF
      ENDIF
 50   FORMAT('P.index',5X,'coord.',14X,'depth')
 51   FORMAT('P.index',5X,'coord.',14X,'depth',13X,'UX',13X,'UY')
*
*     *** The arrays start to be filled in the second value ***
*     *** because in COMPDA(1,"variable"), is the default   ***
*     *** value for land points    version 30.21            ***
*
*     ***  Default values for land point  ***
      COMPDA(1,JDP2) = -1.                                                40.00
      IF (JDP1.GT.1) COMPDA(1,JDP1) = -1.                                 40.00
      IF (JDP3.GT.1) COMPDA(1,JDP3) = -1.                                 40.00
      IF (VARWLV) THEN
        COMPDA(1,JWLV2) = 0.                                              40.00
*       next two lines only for nonstat water level
        IF (JWLV1.GT.1) COMPDA(1,JWLV1) = 0.                              40.00
        IF (JWLV3.GT.1) COMPDA(1,JWLV3) = 0.                              40.00
      ENDIF
      IF (ICUR.GT.0) THEN
        COMPDA(1,JVX2) = 0.                                               40.00
        COMPDA(1,JVY2) = 0.                                               40.00
        IF (JVX1.GT.1) COMPDA(1,JVX1) = 0.                                40.00
        IF (JVY1.GT.1) COMPDA(1,JVY1) = 0.                                40.00
        IF (JVX3.GT.1) COMPDA(1,JVX3) = 0.                                40.00
        IF (JVY3.GT.1) COMPDA(1,JVY3) = 0.                                40.00
      ENDIF
      IF (VARFR) THEN
        COMPDA(1,JFRC2) = 0.                                              40.00
        COMPDA(1,JFRC3) = 0.                                              40.00
      ENDIF
      IF (VARWI) THEN
        COMPDA(1,JWX2) = 0.                                               40.00
        COMPDA(1,JWY2) = 0.                                               40.00
        IF (JWX3.GT.1) COMPDA(1,JWX3) = 0.                                40.00
        IF (JWY3.GT.1) COMPDA(1,JWY3) = 0.                                40.00
      ENDIF
      IF (VARAST) THEN
        COMPDA(1,JASTD2) = 0.                                             40.03
        COMPDA(1,JASTD3) = 0.                                             40.03
      ENDIF
C
      DO 20 IX = 1, MXC
        DO 10 IY = 1, MYC
          INDX = KGRPNT(IX,IY)
          IF (INDX.LE.0 .OR. INDX.GT.MCGRD) THEN                          30.60
            CALL MSGERR (3, 'Grid error in subr. SWRBC')                  30.60
            WRITE (PRINTF, 8) IX, IY, INDX, MCGRD                         30.60
   8        FORMAT (' IX, IY, INDX, MCGRD: ', 4I7)                        30.60
            GOTO 10                                                       30.60
          ENDIF                                                           30.60
          IF (INDX.EQ.1) GOTO 10                                          30.60
*
          XP = XCGRID(IX,IY)                                              30.72
          YP = YCGRID(IX,IY)                                              30.72
*
*         ***** compute depth and water level *****
*
          DEP = SVALQI (XP, YP, 1, RPOOL(IDEB+1), 1, IX, IY)              30.90
*
          IF (VARWLV) THEN                                                20.38
            WLVL = SVALQI (XP, YP, 7, RPOOL(IWLVI+1), 1 ,IX ,IY)          30.90
            COMPDA(INDX,JWLV2) = WLVL
            IF (JWLV1.GT.1) COMPDA(INDX,JWLV1) = WLVL                     40.00
            IF (JWLV3.GT.1) COMPDA(INDX,JWLV3) = WLVL                     40.00
            DEP = DEP + WLVL
          ENDIF
*         add constant water level
          DEPW = DEP + WLEV                                               30.70
          COMPDA(INDX,JDP2) = DEPW
*         ***In this step the water level at T+DT is copied to the  ***
*         ***water level at T (Only for first time computation)     ***
          IF (JDP1.GT.1) COMPDA(INDX,JDP1) = DEPW                         40.00
          IF (JDP3.GT.1) COMPDA(INDX,JDP3) = DEPW                         40.00
*
*         ***** compute current velocity *****
*
          IF (ICUR.EQ.1 .AND. IGTYPE(2) .GE. 1) THEN                      30.82
            IF (DEPW.GT.0.) THEN
              UU  = SVALQI (XP, YP, 2, RPOOL(IUXB+1), 0 ,IX ,IY)          30.90
              VV  = SVALQI (XP, YP, 3, RPOOL(IUYB+1), 0 ,IX ,IY)          30.90
              VTOT = SQRT (UU*UU + VV*VV)
              CGMAX = PNUMS(18)*SQRT(GRAV*DEPW)
              IF (VTOT .GT. CGMAX) THEN
                CGFACT = CGMAX / VTOT
                UU = UU * CGFACT
                VV = VV * CGFACT
                IF (ERRPTS.GT.0) THEN
                  WRITE (ERRPTS, 211) IX, IY, 1
 211              FORMAT (I4, 1X, I4, 1X, I2)
                ENDIF
              ENDIF
              COMPDA(INDX,JVX2) =  UU*COSVC + VV*SINVC
              COMPDA(INDX,JVY2) = -UU*SINVC + VV*COSVC
            ELSE
              COMPDA(INDX,JVX2) =  0.
              COMPDA(INDX,JVY2) =  0.
            ENDIF
            IF (JVX1.GT.1) COMPDA(INDX,JVX1) = COMPDA(INDX,JVX2)          40.00
            IF (JVY1.GT.1) COMPDA(INDX,JVY1) = COMPDA(INDX,JVY2)          40.00
            IF (JVX3.GT.1) COMPDA(INDX,JVX3) = COMPDA(INDX,JVX2)          40.00
            IF (JVY3.GT.1) COMPDA(INDX,JVY3) = COMPDA(INDX,JVY2)          40.00
          ENDIF
C
          IF (ITEST .GE. 100 .OR. INTES .GE. 30) THEN
            IF (ICUR .EQ. 1 ) THEN
              WRITE(PRINTF,31)KGRPNT(IX,IY),XP,YP,COMPDA(INDX,JDP2),
     &        COMPDA(INDX,JVX2),COMPDA(INDX,JVY2)
            ELSE
              WRITE(PRINTF,30)KGRPNT(IX,IY),XP,YP,COMPDA(INDX,JDP2)
            ENDIF
          ENDIF
 30       FORMAT(1X,I5,2X,3(E11.4,2X))
 31       FORMAT(1X,I5,2X,5(E11.4,2X))
C
C         ***** compute variable friction coefficient *****
C
          IF (VARFR) THEN
             FRI = SVALQI (XP, YP, 4, RPOOL(IFRI+1), 1 ,IX ,IY)           30.90
             COMPDA(INDX,JFRC2) = FRI                                     40.00
             COMPDA(INDX,JFRC3) = FRI                                     40.00
          ENDIF
*
*         ***** compute variable wind velocity *****
*
          IF (VARWI) THEN
             UU  = SVALQI (XP, YP, 5, RPOOL(IWXI+1), 0 ,IX ,IY)           30.90
             VV  = SVALQI (XP, YP, 6, RPOOL(IWYI+1), 0 ,IX ,IY)           30.90
             COMPDA(INDX,JWX2) =  UU*COSWC + VV*SINWC
             COMPDA(INDX,JWY2) = -UU*SINWC + VV*COSWC
            IF (JWX3.GT.1) COMPDA(INDX,JWX3) = COMPDA(INDX,JWX2)          40.00
            IF (JWY3.GT.1) COMPDA(INDX,JWY3) = COMPDA(INDX,JWY2)          40.00
          ENDIF
C
C     ***** compute variable air-sea temperature difference *****         40.03
C
          IF (VARAST) THEN
             ASTD = SVALQI (XP, YP, 4, RPOOL(IASTDI+1), 1 ,IX ,IY)        40.03
             COMPDA(INDX,JASTD2) = ASTD                                   40.03
             COMPDA(INDX,JASTD3) = ASTD                                   40.03
          ENDIF
*
   10   CONTINUE
   20 CONTINUE
C
C     *** initialise setup and saved depth ***                            32.02
C
      IF (LSETUP.GT.0) THEN                                               32.02
        DO INDX = 1, MCGRD                                                32.02
          COMPDA(INDX,JSETUP) =  0.                                       32.02
          COMPDA(INDX,JDPSAV) = COMPDA(INDX,JDP2)                         32.02
        ENDDO                                                             32.02
      ENDIF                                                               32.02
C
C
      RETURN
* * end of subroutine SWRBC *
      END
************************************************************************
*                                                                      *
      REAL FUNCTION SVALQI (XP, YP, IGRID, ARRINP, ZERO ,IXC ,IYC)        30.21
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     32.03: Nico Booij
C     40.04: Annette Kieftenburg
C
C  1. Updates
C
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.60, Aug. 97: inequalities changed in view of bug reported by
C                     Ralf Kaiser (GT -> GE and LT -> LE)
C     32.03, Feb. 98: option for 1-D computation introduced
C                     real equality changed into inequality
C     30.82, Apr. 98: Replace statement with division through DYG to avoid division
C                     through zero in case of 1D.
C     30.82, Nov. 98: Now takes care of interpolation near points that
C                     contain exception values
C     40.04, Aug. 00: Interpolation near points that contain exception values
C                     modified
C                   : Removed include files that are not used
C
C  2. Purpose
C
C     Determining the value of a quantity from an input grid
C     such as depth and the current velocity components
C     for point given in problem coordinates
C
C  3. Method (updated...)
C
C     The required values are computed by bilinear interpolation. The
C     coordinates are given in the bottom grid as the number of meshes
C     in X- and Y-direction, IB and JB respectively (both real).
C
C           YB|
C             |
C             |--------------- *                *
C             | A
c             | |SYB1
C             | V
C         IYB-|-------------------- o
C             |
C             |                     |
C         JB1-|--------------- *    |           *
C             |                     |
C             |                |    |    SXB1   |
C             |                |    |<--------->|
C             +----------------------------------------------->
C                              |    |                       XB
C                             IB1  IXB
C
C                   *  bottom grid points
C                   o  point for interpolation
C
C  4. Argument variables
C
C     IGRID    Grid indicator
C     IXC      Counter for X-coordinate in computational grid (used
C              in curvi-linear case)
C     IYC      Counter for Y-coordinate in computational grid (used
C              in curvi-linear case)
C     ZERO     If ZERO=0, then value outside the grid is zero, otherwise
C              the value is extrapolated
C
      INTEGER  IGRID, IXC, IYC, ZERO
C
C     ARRINP   Array holding the values at the input grid locations
C     SVALQI   Value of quantity in (XP,YP)
C     XP       X-coordinate in computational gridpoint
C     YP       Y-coordinate in computational gridpoint
C
      REAL     ARRINP(*), XP, YP
C
C  5. Parameter variables
C
C  6. Local variables
C
C     EQREAL   Boolean function which compares two REAL values
C     IB1      Grid counter in x-direction
C     IENT     Number of entries into this subroutine
C     II       Pointer number in ARRINP
C     INGRD    Boolean variable to determine whether point is in grid
C     IXB      Distance to origin in x-direction devided by meshsize
C              in y-direction
C     IYB      Distance to origin in y-direction devided by meshsize
C              in y-direction
C     JB1      Grid counter in y-direction
C     SUMWEXC  Sum of weight factors of points with exception value       40.04
C     SUMWREG  Sum of weight factors of points with regular   value       40.04
C     SXB1     First weight factor for distance in x-direction
C     SXB2     Second weight factor for distance in x-direction
C     SYB1     First weight factor for distance in y-direction
C     SYB2     Second weight factor for distance in y-direction
C     WF1      Weight factor of point ARRINP(II)                          40.04
C     WF2      Weight factor of point ARRINP(II+MXG(IGRID))               40.04
C     WF3      Weight factor of point ARRINP(II+1)                        40.04
C     WF4      Weight factor of point ARRINP(II+1+MXG(IGRID))             40.04
C
      INTEGER  IB1, IENT, II, JB1
      REAL     IXB, IYB, SXB1, SXB2, SYB1, SYB2
      REAL     SUMWEXC, SUMWREG, WF1, WF2, WF3, WF4                       40.04
      LOGICAL  INGRD
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     LOGICAL FUNCTION EQREAL: Checks whether two reals are equal within certain margins
C     STRACE: Traces the entry into subroutines (test purposes)
C
      LOGICAL  EQREAL
C
C  9. Subroutines calling
C
C     SWDIM
C     INTEGER FUNCTION SIRAY
C     SWRBC
C     SNEXTI
C     FLFILE
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C       ----------------------------------------------------------------
C       If the point is out of bottom grid in X-direction, then
C           Compute lines for interpolation and interpolation factors
C             such that the value at the side of the grid is taken
C       Else
C           Compute nearest line IX in the bottom grid and the interpo-
C             lation factor in X-direction
C       ----------------------------------------------------------------
C       If the point is out of bottom grid in Y-direction, then
C           Compute lines for interpolation and interpolation factors
C             such that the value at the side of the grid is taken
C       Else
C           Compute nearest line IY in the bottom grid and the interpo-
C             lation factor in Y-direction
C       ----------------------------------------------------------------
C       Compute pointer in arrays and interpolation factors in both
C       directions
C       Compute the depth to the reference level for the point
C       Add the water level to the depth
C       If depth > 0 and current is on, then
C           Interpolate X- and Y-component of current velocity
C       Else
C           Current components are zero
C       ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT                                                           30.72
      DATA IENT/0/
      CALL STRACE (IENT, 'SVALQI')
*
*     ***    Two different procedures in funcion of       ***
*     ***    grid type: regular or curvilinear (staggered)*** ver 30.21
*
      IF (IGTYPE(IGRID) .EQ. 1) THEN                                      30.21
C
C     Regular grid:
C
        IXB = ( (XP-XPG(IGRID))*COSPG(IGRID) +
     &          (YP-YPG(IGRID))*SINPG(IGRID) ) / DXG(IGRID)
*
        INGRD = .TRUE.
        IF (IXB .LE. 0.) THEN                                             30.60
          IB1   = 1
          SXB2  = 0.
          IF (IXB.LT.-0.1) INGRD = .FALSE.                                20.3x
        ELSE IF (IXB .GE. FLOAT(MXG(IGRID)-1)) THEN                       30.60
          IB1   = MXG(IGRID)-1
          SXB2  = 1.
          IF (IXB.GT.FLOAT(MXG(IGRID))-0.9) INGRD = .FALSE.               20.3x
        ELSE
          IB1   = INT(IXB)
          SXB2  = IXB-REAL(IB1)
          IB1   = IB1+1
        ENDIF
        IF (MYG(IGRID).GT.1) THEN                                         32.03
          IYB = (-(XP-XPG(IGRID))*SINPG(IGRID) +                          30.82
     &            (YP-YPG(IGRID))*COSPG(IGRID) ) / DYG(IGRID)             30.82
          IF (IYB .LE. 0.) THEN                                           30.60
            JB1   = 1
            SYB2  = 0.
            IF (IYB.LT.-0.1) INGRD = .FALSE.
          ELSE IF (IYB .GE. FLOAT(MYG(IGRID)-1)) THEN                     30.60
            JB1   = MYG(IGRID)-1
            SYB2  = 1.
            IF (IYB.GT.FLOAT(MYG(IGRID))-0.9) INGRD = .FALSE.
          ELSE
            JB1   = INT(IYB)
            SYB2  = IYB-REAL(JB1)
            JB1   = JB1+1
          ENDIF
        ENDIF                                                             32.03
C
C       evaluate SVALQI (2D-mode):
C
        IF (.NOT.INGRD .AND. ZERO.EQ.0) THEN
          SVALQI = 0.
        ELSE IF (MYG(IGRID).GT.1) THEN                                    32.03
          SXB1   = 1.- SXB2
          SYB1   = 1.- SYB2
          II     = IB1 + (JB1-1) * MXG(IGRID)
          WF1 = SXB1*SYB1                                                 40.04
          WF2 = SXB1*SYB2                                                 40.04
          WF3 = SXB2*SYB1                                                 40.04
          WF4 = SXB2*SYB2                                                 40.04
          SUMWEXC = 0.                                                    40.04
          IF  (EQREAL(ARRINP(II             ),EXCFLD(IGRID))) THEN        40.04
            SUMWEXC = SUMWEXC + WF1                                       40.04
            WF1 =0.                                                       40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+  MXG(IGRID)),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF2                                       40.04
            WF2=0.                                                        40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+1           ),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF3                                       40.04
            WF3=0.                                                        40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+1+MXG(IGRID)),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF4                                       40.04
            WF4=0.                                                        40.04
          ENDIF                                                           40.04
          SUMWREG = 1. -SUMWEXC                                           40.04
C
          IF (SUMWEXC.GE.SUMWREG)   THEN                                  40.04
            SVALQI = EXCFLD(IGRID)                                        40.04
          ELSE                                                            40.04
            SVALQI = ( WF1*ARRINP(II)   + WF2*ARRINP(II+MXG(IGRID))       40.04
     &               + WF3*ARRINP(II+1) + WF4*ARRINP(II+1+MXG(IGRID)) )   40.04
     &               / SUMWREG                                            40.04
          END IF                                                          40.04
        ELSE
C
C       evaluate SVALQI (1D-mode):
C
          SXB1 = 1. - SXB2                                                32.03
          IF (EQREAL(ARRINP(IB1  ),EXCFLD(IGRID)).OR.                     30.82
     &        EQREAL(ARRINP(IB1+1),EXCFLD(IGRID))    ) THEN               30.82
C
C           One of the cornerpoints contains an exception value thus:     30.82
C
            SVALQI = EXCFLD(IGRID)                                        30.82
          ELSE                                                            30.82
            SVALQI = SXB1*ARRINP(IB1)                                     32.03
     &             + SXB2*ARRINP(IB1+1)                                   32.03
          ENDIF                                                           30.82
        ENDIF
      ELSE IF (ABS(STAGX(IGRID)) .LT. 0.01 .AND.                          32.03
     &         ABS(STAGY(IGRID)) .LT. 0.01) THEN                          32.03
C
C     Curvi-linear and non-staggered input grid:                          32.03
C
        IB1   = IXC
        JB1   = IYC
        II     = IB1 + (JB1-1) * MXG(IGRID)
        SVALQI = ARRINP(II)
      ELSE
C
C     Curvi-linear and staggered input grid:                              32.03
C
        INGRD = .TRUE.
        IF (IXC .EQ. 1) THEN
          IB1   = 1
          SXB2  = 0.
          IF (STAGY(IGRID) .GT. 0.) INGRD = .FALSE.
        ELSE IF (IXC .GT. MXG(IGRID)-1) THEN
          IB1   = MXG(IGRID)-1
          SXB2  = 1.
          IF (STAGY(IGRID) .GT. 0.) INGRD = .FALSE.
        ELSE
          IB1   = IXC+1
          SXB2  = 1. - STAGX(IGRID)
        ENDIF
        IF (IYC .EQ. 1) THEN
          JB1   = 1
          SYB2  = 0.
          IF (STAGX(IGRID) .GT. 0.) INGRD = .FALSE.
        ELSE IF (IYC .GT. MYG(IGRID)-1) THEN
          JB1   = MYG(IGRID)-1
          SYB2  = 1.
          IF (STAGY(IGRID) .GT. 0.) INGRD = .FALSE.
        ELSE
          JB1   = IYC + 1
          SYB2  =1. - STAGY(IGRID)
        ENDIF
C
C       evaluate SVALQI (2D-mode):
C
        IF (.NOT.INGRD .AND. ZERO.EQ.0) THEN
          SVALQI = 0.
        ELSE
          SXB1   = STAGX(IGRID)
          SYB1   = STAGY(IGRID)
          II     = IB1 + (JB1-1) * MXG(IGRID)
          WF1 = SXB1*SYB1                                                 40.04
          WF2 = SXB1*SYB2                                                 40.04
          WF3 = SXB2*SYB1                                                 40.04
          WF4 = SXB2*SYB2                                                 40.04
          SUMWEXC = 0.                                                    40.04
          IF (EQREAL(ARRINP(II             ),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF1                                       40.04
            WF1 =0.                                                       40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+  MXG(IGRID)),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF2                                       40.04
            WF2=0.                                                        40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+1           ),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF3                                       40.04
            WF3=0.                                                        40.04
          ENDIF                                                           40.04
          IF (EQREAL(ARRINP(II+1+MXG(IGRID)),EXCFLD(IGRID))) THEN         40.04
            SUMWEXC = SUMWEXC + WF4                                       40.04
            WF4=0.                                                        40.04
          ENDIF                                                           40.04
          SUMWREG = 1. -SUMWEXC                                           40.04
C
          IF (SUMWEXC.GE.SUMWREG)   THEN                                  40.04
            SVALQI = EXCFLD(IGRID)                                        40.04
          ELSE                                                            40.04
            SVALQI = ( WF1*ARRINP(II)   + WF2*ARRINP(II+MXG(IGRID))       40.04
     &               + WF3*ARRINP(II+1) + WF4*ARRINP(II+1+MXG(IGRID)) )   40.04
     &               / SUMWREG                                            40.04
          END IF                                                          40.04
        ENDIF
      ENDIF
C
C     ***** test *****
      IF (ITEST .GE. 280)
C     &   WRITE(PRINTF, 6010) SVALQI,IGRID,XP,YP,IXB,IYB,II,ARRINP(II)
C 6010 FORMAT(' SVALQI  IGRID       XP      YP        IXB',
C     &       '       IYB  II  ARRINP(II)', /
C     &      ,E10.3,I3,1X,4E10.3,I4,E10.3)
     &   WRITE(PRINTF, 6010) XP, YP, IXB, IYB, SVALQI
 6010 FORMAT(' Test SVALQI:',5F10.3)
C
      RETURN
C     end of subroutine SVALQI
      END
************************************************************************
*                                                                      *
      SUBROUTINE SINARR (POOL)
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. AUTHORS
*
*       30.72: IJsbrand Haagsma
*       34.01: Jeroen Adema
C       40.04: Annette Kieftenburg
*
*  1. UPDATE
*
*              Dec. 92: new for SWAN
*       30.72, Sept 97: INTEGER*4 replaced by INTEGER
*       34.01, Feb. 99: Introducing STPNOW
*
*  2. PURPOSE
*
*       Calculating of energy density at boundary point (x,y,sigma,theta)
*
*
*  3. METHOD
*
*       ---
*
*  4. PARAMETERLIST
*
*       RA        REAL     output   energy density at point (x,y,sigma,theta)
*       SHAPE     INT      input    SHAPE of spectrum
*                                   SHAPE = 1 : Pierson-Moskowitz spectrum
*                                   SHAPE = 2 : Jonswap spectrum
*       SHS       REAL     input    Hs of wave
*       SPER      REAL     input    Period of wave
*       SDIR      REAL     input    multiplier for directional spread of
*                                   engery ( D(theta;f) )
*
*  5. SUBROUTINES CALLING
*
*       ---
*
*  6. SUBROUTINES USED
*
      LOGICAL STPNOW                                                      34.01
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ----------------------------------------------------------------
*       set arraysizes for computation and postprocessing
*       ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER      POOL(*), IERR                                        30.72
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SINARR')
*
C     The following array is for the plot of the source terms
C
      JPWNDA = 1
      JPWNDB = 2
      JPWCAP = 3
      JPBTFR = 4
      JPWBRK = 5
      JP4S   = 6
      JP4D   = 7
      JPTRI  = 8
      MTSVAR = 8
      IERR = 0
      CALL DPEXPR (POOL, JTSTDA, MTSVAR*NPTST*MDC*MSC, ITSTDA, IERR)      20.45
      IF (STPNOW()) RETURN                                                34.01
 
      RETURN
*     *** end of subroutine SINARR ***
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE SINUPT (PSNAME, XP, YP, XCGRID, YCGRID, KGRPNT, KGRBND)  40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     40.04: Annette Kieftenburg
C
C  1. Updates
C
*      0.0 , Mar. 87: Heading added, IF..GOTO.. changed into IF..THEN..
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, Feb. 99: test skipped for irregular bottom grid
*
*  2. Purpose
*
*     Checking whether the point XP, YP (given in problem coordinates)
*     of the output pointset SNAME is located in the computational grid
*     and bottom grid or not. If not, a warning is generated.
*
*  3. Method
*
*     ---
*
C  4. Argument variables
C
C     KGRPNT: input  Adresses of the computational grid points
C     KGRBND: input
C
      INTEGER KGRPNT(MXC,MYC), KGRBND(*)                                  40.00
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     XP    : input  X-coordinate of the point (problem coordinates)
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C     YP    : input  Y-coordinate of the point (problem coordinates)
C
      REAL    XP, YP
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C     PSNAME: input  Name of the output pointset (any type)
C
      CHARACTER PSNAME *(*)
*
*  5. SUBROUTINES CALLING
*
*     SPRCON (SWAN/SWREAD)
*
*  6. SUBROUTINES USED
*
*     SINBTG, SINCMP (both SWAN/SER) and MSGERR (Ocean Pack)
C
      LOGICAL SINBTG, SINCMP
*
*  7. ERROR MESSAGES
*
*     ---
*
*  8. REMARKS
*
*     ---
*
*  9. STRUCTURE
*
*     ----------------------------------------------------------------
*     If point (XP,YP) is not in the bottom grid (SINBTG = FALSE), then
*         Call MSGERR to generate a warning
*     If point (XP,YP) is not in the comp. grid (SINCMP = FALSE), then
*         Call MSGERR to generate a warning
*     ----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SINUPT')
*
      IF (IGTYPE(1) .EQ. 1) THEN                                          40.00
        IF (.NOT. SINBTG (XP,YP) ) THEN
          CALL MSGERR(1,'(corner)point outside bottom grid')
          WRITE (PRINTF, 6010) PSNAME, XP+XOFFS, YP+YOFFS
        ENDIF
      ENDIF                                                               40.00
      IF (.NOT.SINCMP (XP, YP, XCGRID, YCGRID, KGRPNT, KGRBND)) THEN      40.00
        CALL MSGERR(1,'(corner)point outside comp. grid')
        WRITE (PRINTF, 6010) PSNAME, XP+XOFFS, YP+YOFFS
      ENDIF
 6010 FORMAT('       Set of output locations: ',A8,
     &       '  coordinates:', 2F10.2)
*
      RETURN
C     end of subroutine SINUPT *
      END
C
************************************************************************
*                                                                      *
      LOGICAL FUNCTION SINBTG (XP, YP)
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm2.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C
C  1. Updates
C
C      0.0 , Mar. 87: name of function changed from INBODP into SINBTG
C     32.02, Jan. 98: Introduced 1D-version
C     40.00, Feb. 99: 1D procedure simplified, tolerance introduced
C
C  2. Purpose
C
C     Checking whether a point given in problem coordinates is in the
C     bottom grid (SINBTG = true) or not (SINBTG = false).
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     XP      REAL   input    X-coordinate (problem grid) of the point
C     YP      REAL   input    Y-coordinate (problem grid) of the point
C
C  6. Local variables
C
C     XB      x-coordinate (of bottom grid)
C     YB      y-coordinate (of bottom grid)
C     XLENB   length of bottom grid in x-direction (of bottom grid)
C     YLENB   length of bottom grid in y-direction (of bottom grid)
C     BTOL    tolerance length
C
      REAL    XB, YB, XLENB, YLENB, BTOL
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SPRCON (SWAN/MAIN)
C     SINUPT (SWAN/SER)
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     If the bottom grid is defined (DXB>0 and DYB>0), then
C         Compute coordinates XB,YB in the bottom grid
C         Give SINBTG initial value TRUE
C         If XB < 0, XB > X-length of grid, YB < 0 or YB > .. then
C            SINBTG is FALSE
C     ----------------------------------------------------------------
C
C 13. Source text
C
      DATA  IENT /0/
      CALL  STRACE (IENT,'SINBTG')
C
      XLENB = (MXG(1)-1)*DXG(1)
      YLENB = (MYG(1)-1)*DYG(1)
      BTOL  = 0.01 * (XLENB+YLENB)
C
C     ***** compute bottom grid coordinates from problem coordinates ****
C
      XB =  (XP-XPG(1))*COSPG(1) + (YP-YPG(1))*SINPG(1)
      YB = -(XP-XPG(1))*SINPG(1) + (YP-YPG(1))*COSPG(1)
C
C     ***** check location of point *****
      SINBTG = .TRUE.
      IF (XB .LT. -BTOL) SINBTG = .FALSE.
      IF (XB .GT. XLENB+BTOL) SINBTG = .FALSE.
      IF (YB .LT. -BTOL) SINBTG = .FALSE.
      IF (YB .GT. YLENB+BTOL) SINBTG = .FALSE.
C
      RETURN
C   * end of subroutine SINBTG *
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION SINCMP (XP, YP ,XCGRID ,YCGRID ,KGRPNT, KGRBND)    40.00
*                                                                      *
************************************************************************
C
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde
C     30.60, 40.00: Nico Booij
C     40.04: Annette Kieftenburg
C
C  1. Updates
C
C     00.00, Mar. 87: name changed from INREKP into SINCMP, heading added
C     30.60, Aug. 97: assignment of SINCMP moved
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     32.02, Jan. 98: Introduced 1D-version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, June 98: argument KGRBND added, call CVMESH modified
C            Febr 99: separate 1D code removed, margin introduced
C
C  2. Purpose
C
C     Checking whether a point given in problem coordinates is in the
C     computational grid (SINCMP = true) or not (SINCMP = false).
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     KGRPNT  input  grid point addresses
C     KGRBND  input  describes computational grid boundary                40.00
C
      INTEGER KGRPNT(MXC,MYC), KGRBND(*)                                  40.00
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     XP      REAL   input    X-coordinate (problem grid) of the point
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C     YP      REAL   input    Y-coordinate (problem grid) of the point
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
      REAL    XP,     YP
C
C  6. Local variables
C
C     CTOL    tolerance value (margin around comput. grid)                40.00
C
      REAL    CTOL
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SINUPT
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Compute coordinates XC,YC in the computational grid
C     Give SINCMP initial value TRUE
C     If XC < 0, XC > XCLEN, YC < 0 or YC > YCLEN, then
C         SINCMP = FALSE
C     ----------------------------------------------------------------
C
C 13. Source text
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SINCMP')
C
C     *** Different procedure depending on grid type **
      IF (OPTG .EQ. 1) THEN                                               30.21
C
C       regular grid: compute comp. coordinates from problem coordinates
C
        XC   =  (XP-XPC)*COSPC+(YP-YPC)*SINPC
        YC   = -(XP-XPC)*SINPC+(YP-YPC)*COSPC
C       XC and YC are in m
C
C       ***** check for location *****
        SINCMP = .TRUE.
        CTOL   = 0.01 * (XCLEN+YCLEN)                                     40.00
        IF (XC .LT. -CTOL) SINCMP = .FALSE.                               40.00
        IF (XC .GT. XCLEN+CTOL) SINCMP = .FALSE.                          40.00
        IF (YC .LT. -CTOL) SINCMP = .FALSE.                               40.00
        IF (YC .GT. YCLEN+CTOL) SINCMP = .FALSE.                          40.00
      ELSE
C
C       irregular grid
C
        CALL CVMESH (XP, YP, XC, YC, KGRPNT, XCGRID ,YCGRID, KGRBND)      40.00
C       XC and YC are nondimensional; equivalent to grid index
C
C       ***** check for location *****
        SINCMP = .TRUE.
        IF (XC .LT. -0.01) SINCMP = .FALSE.                               40.00
        IF (XC .GT. REAL(MXC-1)+0.01) SINCMP = .FALSE.                    40.00
        IF (YC .LT. -0.01) SINCMP = .FALSE.                               40.00
        IF (YC .GT. REAL(MYC-1)+0.01) SINCMP = .FALSE.                    40.00
      ENDIF
C
      RETURN
C   * end of subroutine SINCMP *
      END
************************************************************************
*                                                                      *
      SUBROUTINE WRTEST (NAME, NA, IARR, RARR)
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C
C  1. Updates
C
C
C  2. Purpose
C
C     ---
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     IARR(*)
C     NA
C     NAME*(*)
C     RARR(*)
C
      INTEGER   IARR(*), NA                                               30.72
      REAL      RARR(*)
      CHARACTER NAME *(*)
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     ---
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ---
C
C 13. Source text
C
      WRITE (PRINTF, 10) NAME, (IARR(II), II=1,NA)
  10  FORMAT (1X, A, 10(1X, I8))
      WRITE (PRINTF, 20) (RARR(II), II=1,NA)
  20  FORMAT (10(1X, E12.4))
      RETURN
* * end of subroutine WRTEST *
      END
C********************************************************************
C
      SUBROUTINE ERRCHK (POOL)                                            40.00
C
C****************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     33.08: Nico Booij and Erick Rogers (changes re: the S&L scheme)
C     33.10: Nico Booij and Erick Rogers (changes re: the SORDUP scheme)
C
C  1. Updates
C
C     30.60, Aug. 97: full common included, ICOND initialized (3d gen, nonstat)
C     30.60, Aug. 97: error message changed into warning
C     30.70, Oct. 97: ICOND made 1 only if it is 0
C     30.72, Feb. 98: Old messages deleted. Problems with quadruplets and
C                     SECTOR described. All change of options by this routine
C                     deleted
C     30.72, Mar. 98: Warning added for combination of no WIND and QUAD
C     30.72, Mar. 98: Added warning concerning TRIADS and MSC
C     40.00, Apr. 99: check whether size of pool is sufficient for computation
C                     and output
C
C  2. Purpose
C
C     Check all possible combinations of physical processes if
C     they are being activated and change value of settings if
C     necessary
C
C  3. Method
C
C     0      MESSAGE
C     1      WARNING
C     2      ERROR REPAIRABLE
C     3      SEVERE ERROR (calculation continues, however problems
C                          may arise)
C     4      TERMINATION ERROR (calculation is terminated )
C
C  4. Argument variables (updated 30.72)
C
C     POOL   dynamic data pool
C
      INTEGER   POOL(*)
C
C  8. Subroutines used
C
C     MSGERR : Handles error messeges according to severity
C
C  9. Subroutines calling
C
C     SWANCOM
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ------------------------------------------------------------
C     End of the subroutine ERRCHK
C     ------------------------------------------------------------
C
C 13. Source text
C
      LOGICAL  STPNOW                                                     40.00
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'ERRCHK')
C
C     -----------------------------------------------------------------
C
C     *** WARNINGS AND ERROR MESSAGES ***
C
C     -----------------------------------------------------------------
C
C     *** WAM cycle 3 physics ***
C
      IF  ( (IWIND .EQ. 3 .OR. IWIND .EQ. 5) .AND. IWCAP .NE. 1) THEN
        CALL MSGERR(1,'Activate whitecapping mechanism according to')
        CALL MSGERR(1,'Komen et al. (1984) for wind option G3/YAN')       20.74
      ENDIF
C
C     *** WAM cycle 4 physics ***
C
      IF  ( IWIND .EQ. 4 .AND. IWCAP .NE. 2) THEN
        CALL MSGERR(1,'Activate whitecapping mechanism according to')
        CALL MSGERR(1,'Janssen (1991) for wind option JANS        ')
      ENDIF
C
C     *** check numerical scheme in presence of a current ***
C
      IF ( ICUR .EQ. 1 .AND. PNUMS(6) .EQ. 0. ) THEN
        IF ( PNUMS(6) .EQ. 0. ) THEN
          CALL MSGERR(1,'In presence of a current it is recommended to')
          CALL MSGERR(1,'use an implicit upwind scheme in theta space ')
          CALL MSGERR(1,'-> set CDD = 1.')
          WRITE(PRINTF,*)
        ENDIF
        IF ( PNUMS(7) .EQ. 0. ) THEN
          CALL MSGERR(1,'In presence of a current it is recommended to')
          CALL MSGERR(1,'use an implicit upwind scheme in sigma space ')
          CALL MSGERR(1,'-> set CSS = 1.')
          WRITE(PRINTF,*)
        ENDIF
      END IF
C
C     check combination of REPeating option and grid type and dimension   33.09
C
      IF (KREPTX.GT.0) THEN                                               33.08
        IF (OPTG.GT.3)
     &  CALL MSGERR (3, 'Curvilinear grid cannot be REPeating')
        IF (PROPSC.EQ.1 .AND. MXC.LT.1)
     &  CALL MSGERR (3, 'MXC must be >=1 for REPeating option')
        IF (PROPSC.EQ.2 .AND. MXC.LT.2)                                   33.10
     &  CALL MSGERR (3, 'MXC must be >=2 for REPeating option')           33.10
        IF (PROPSC.EQ.3 .AND. MXC.LT.3)                                   33.09
     &  CALL MSGERR (3, 'MXC must be >=3 for REPeating option')           33.09
      ENDIF
      IF (PROPSC.EQ.2 .AND. NSTATC.GT.0) THEN                             33.10
        CALL MSGERR (3, 'SORDUP scheme only in stationary run')           33.10
      ENDIF
      IF (PROPSC.EQ.3 .AND. NSTATC.EQ.0) THEN                             33.08
        CALL MSGERR (3, 'STELLING scheme not in stationary run')          33.08
      ENDIF
C
C     Here the various problems with quadruplets are checked
C     The combination of quadruplets and sectors is an error in the calculation
C     of Quadruplets when the SECTOR option is used in the CGRID command. This
C     error should be corrected in the future
C
      IF (IWIND.EQ.3 .OR. IWIND.EQ.4) THEN                                30.60
        IF (IQUAD .EQ. 0) THEN
          CALL MSGERR(2,'Quadruplets should be activated when SWAN  ')    30.60
          CALL MSGERR(2,'is running in a third generation mode and  ')    30.60
          CALL MSGERR(2,'wind is present                            ')    30.60
        ENDIF
      ENDIF
C
      IF (IQUAD .GE. 1) THEN                                              30.72
C
       IF (.NOT. FULCIR) THEN                                             30.72
        IF ((SPDIR2-SPDIR1) .LT. (PI/12.)) THEN                           30.72
          CALL MSGERR(2,'A combination of using Quadruplets with a'    )  30.72
          CALL MSGERR(2,'sector of less than 30 degrees should be'     )  30.72
          CALL MSGERR(2,'avoided at all times, it is likely to produce')  30.72
          CALL MSGERR(2,'unreliable results and unexpected errors.'    )  30.72
          CALL MSGERR(2,'Refer to the manual (CGRID) for details'      )  30.72
        ELSE                                                              30.72
          CALL MSGERR(1,'It is not recommended to use Quadruplets'     )  30.72
          CALL MSGERR(1,'in combination with calculations on a sector.')  30.72
          CALL MSGERR(1,'Refer to the manual (CGRID) for details'      )  30.72
        END IF                                                            30.72
       END IF                                                             30.72
C
       IF (IWIND.EQ.0) THEN                                               30.72
         CALL MSGERR(2,'It is not recommended to use Quadruplets'     )   30.72
         CALL MSGERR(2,'in combination with zero wind conditions.'    )   30.72
       END IF                                                             30.72
C
       IF (MSC .EQ. 3 ) THEN
         CALL MSGERR(4,'Do not activate quadruplets for boundary ')
         CALL MSGERR(4,'option BIN -> use other option           ')
         WRITE(PRINTF,*)
       END IF
C
      END IF                                                              30.72
C
C     When using triads MSC must be less than 200!                        30.72
C
      IF ((ITRIAD.GT.0).AND.(MSC.GT.200)) THEN                            30.72
         CALL MSGERR(4,'When triads are active the number of     ')       30.72
         CALL MSGERR(4,'directions chosen in the CGRID command   ')       30.72
         CALL MSGERR(4,'must be less than 200                    ')       30.72
      END IF                                                              30.72
C
      IF ( ITEST .GE. 120 ) THEN
        WRITE(PRINTF,3000) IWIND ,IQUAD, ICUR, IWCAP, MSC
3000    FORMAT(' ERRCHK : IWIND QUAD CUR WCAP MSC   : ',5I4)
        IF (IWIND .GT. 0) THEN                                            24/MAR
          DO II = 1, MWIND
            WRITE(PRINTF,30) II,PWIND(II)
 30         FORMAT(' PWIND(',I2,') = ',E11.4)
          ENDDO
        ENDIF
      END IF
C
C     check size of pool
C
      IERR = 0
      CALL DPINQA (POOL, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &             IERR)
      IF (STPNOW()) RETURN
      IF (LENOCP+MXOUTAR .GT. LENARR) THEN
        CALL MSGERR (2,
     &      'pool is too small for computational and output data')        40.00
        IF (ITEST.GE.30)
     &  WRITE (PRINTF, 87) LENARR, LENOCP, MXOUTAR
  87    FORMAT (' Data pool size: ', I12, ',  occupied: ', I12,
     &          ',  output data:', I12)
      ENDIF
      RETURN
C     end of subroutine ERRCHK
      END
C*********************************************************************
C                                                                    *
      SUBROUTINE SNEXTI (POOL  , RPOOL , BFILES, BSPLOC, BSPDIR,          30.90
     &                   RBSDIR, BSPFRQ, RBSFRQ, BSPAUX, RBSAUX,          30.90
     &                   BSPECS, BGRIDP, COMPDA, AC1, AC2, SPCSIG,
     &                   SPCDIR, XCGRID, YCGRID, KGRPNT, XYTST)
C                                                                    *
C*********************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     40.00, 40.13: Nico Booij
C     34.01: Jeroen Adema
!     40.14: Annette Kieftenburg
C
C  1. Updates
C
C     30.60, Jun. 97: condition for ATAN2 corrected
C     30.70, Sept 97: reduction of current only if depth is positive
C     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.72, Oct. 97: changed floating point comparison to avoid equality
C                     comparisons
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.70, Jan. 98: VNAM6 (nonstat current) corrected
C     30.70, Feb. 98: argument AUXW4 added in call of WAM nesting
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: wind is no longer set to 0, id depth is negative
C     40.00, Nov. 97: complete revision of boundary value update
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description of several variables
C     34.01, Feb. 99: Introducing STPNOW
C     40.13, Mar. 01: Loop over INDX replaced by loop over IX, IY
!     40.14, June 01: Waterlevel updated in case set-up is on
C
C  2. Purpose
C
C     ---
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C i   BFILES: parameters for reading boundary files
C i   BGRIDP: data for interpolating to computational grid points
C i   BSPLOC: location where to put boundary values
C i   BSPDIR: spectral directions of boundary spectra
C i   BSPFRQ: spectral frequencies of boundary spectra
C i   KGRPNT: computational grid point addresses
C i   POOL  : data pool
C i   XYTST : test points
C
      INTEGER    BFILES(*), BSPLOC(*), BSPDIR(*), BSPFRQ(*), BGRIDP(*),
     &           BSPAUX(*), POOL(*), XYTST(*), KGRPNT(MXC,MYC)
C
C i   AC1   : action density spectra on old time level
C i   AC2   : action density spectra on new time level
C i   BSPECS: boundary spectra
C i   COMPDA: values on computational grid
C i   RBSAUX: auxiliary data for interpolation of spectra                 30.90
C i   RBSDIR: spectral directions of boundary spectra                     30.90
C i   RBSFRQ: spectral frequencies of boundary spectra                    30.90
C i   RPOOL : REAL equivalence of data pool                               30.90
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL     AC1(MDC,MSC,MCGRD)                                         40.00
      REAL     AC2(MDC,MSC,MCGRD)                                         30.21
      REAL     BSPECS(MDC,MSC,NBSPEC,2)                                   40.00
      REAL     COMPDA(MCGRD,MCMVAR)                                       30.72
      REAL     RPOOL(*)                                                   30.90
      REAL     RBSAUX(*)                                                  30.90
      REAL     RBSDIR(*)                                                  30.90
      REAL     RBSFRQ(*)                                                  30.90
      REAL     SPCDIR(MDC,6)                                              40.00
      REAL     SPCSIG(MSC)                                                30.01
      REAL     XCGRID(MXC,MYC), YCGRID(MXC,MYC)                           30.21
C
C     TIMCO ..... Time (date) of computation
C     TFINC ..... Final time (date) of computation
C     DT    ..... Increment time for computation
C     TIMCU ..... Date to read the next current file.
C     TIMFR .....        "              friction
C     TIMWI .....        "              wind
C     TIMWL .....        "              water level
C     WEI??#..... Weights for linear interpolation for
c                 (??=) CUR, FRC, WIN, WLV,
C                 (#=) 2 for field at Ti and 1 for field at Ti+1
C     VARWE?..... Variation of the WEI??? in each DT for C, F, W , L
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     ---
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     -------------------------------------------------------------
C     ------------------------------------------------------------
C
C 13. Source text
C
      CHARACTER   PTYPE*1                                                 30.74
      INTEGER     IERR
      REAL        TSTVAL(10)                                              40.00
      SAVE  IENT
      DATA  IENT/0/
      IF (LTRACE) CALL STRACE(IENT,'SNEXTI')
C
*
*     **   All action densities are shifted from array T+DT
*     **   to the array at time T
*
      IF (NSTATC.EQ.1) THEN                                               30.70
        IF (ITERMX.GT.1
     &       .OR. PROPSC.EQ.3                                              33.09
     &                                 ) THEN                             30.70
          DO 50 IXY = 1, MCGRD                                            30.21
            DO 55 ISS = 1, MSC
              DO 60 IDD = 1, MDC
                AC1(IDD,ISS,IXY) = AC2(IDD,ISS,IXY)                       30.21
 60           CONTINUE
 55         CONTINUE
 50       CONTINUE
        ENDIF                                                             40.00
      ENDIF
*
*     update boundary conditions
*
      IF (ITEST.GE.80) WRITE (PRTEST,*) ' number of boundary files ',
     &          NBFILS
      DO IBFILE = 1, NBFILS
*
*       read values from boundary file, and interpolate in time
*
        CALL RBFILE (SPCSIG, SPCDIR,
     &               BFILES(IADRS(BFILES,IBFILE)),
     &               BSPLOC(IADRS(BSPLOC,IBFILE)),
     &               BSPDIR(IADRS(BSPDIR,IBFILE)),
     &               RBSDIR(IADRS(BSPDIR,IBFILE)),                        30.90
     &               BSPFRQ(IADRS(BSPFRQ,IBFILE)),
     &               RBSFRQ(IADRS(BSPFRQ,IBFILE)), BSPECS,                30.90
     &               BSPAUX(IADRS(BSPAUX,IBFILE)),
     &               RBSAUX(IADRS(BSPAUX,IBFILE)), XYTST)                 30.90
        IF (STPNOW()) RETURN                                              34.01
      ENDDO
*
*     determine spectra on boundary points of grid
*
      IF (ITEST.GE.80) WRITE (PRTEST,*) ' number of boundary points ',
     &          NBGRPT
      DO IBGRID = 1, NBGRPT
        INDXGR = BGRIDP(6*IBGRID-5)
        IF (BGRIDP(6*IBGRID-4).EQ.1) THEN
*         obtain spectrum in boundary point from interpolation in space
          W1 = 0.001 * REAL(BGRIDP(6*IBGRID-3))
          K1 = BGRIDP(6*IBGRID-2)
          W2 = 1.-W1
          K2 = BGRIDP(6*IBGRID)
          CALL SINTRP (W1, W2, BSPECS(1,1,K1,1), BSPECS(1,1,K2,1),
     &                 AC2(1,1,INDXGR), SPCDIR, SPCSIG)
*         store Hs from boundary condition in array HSIBND
          ETOT = 0.
          DO IS = 1, MSC
            SIG2 = SPCSIG(IS) ** 2
            DO ID = 1, MDC
              ETOT = ETOT + SIG2 * AC2(ID,IS,INDXGR)
            ENDDO
          ENDDO
          IF (ETOT.GT.0.) THEN
            HS = 4. * SQRT(FRINTF*DDIR*ETOT)
          ELSE
            HS = 0.
          ENDIF
          COMPDA(INDXGR,JHSIBC) = HS
*
*         test output: parameters in test points on boundary
*
          IF (NPTST.GT.0) THEN
            DO IPTST = 1, NPTST
              IXP = XYTST(2*IPTST-1)
              IYP = XYTST(2*IPTST)
              IF (INDXGR.EQ.KGRPNT(IXP,IYP)) THEN
                WRITE (PRTEST,72) IBGRID, IXP-1, IYP-1, W1, K1, W2, K2
  72            FORMAT (' boundary point', 3I8, 2(F8.3, I4))
                AX = 0.
                AY = 0.
                ATOT = 0.
                ASTOT = 0.
                DO ID = 1, MDC
                  AADD = 0.
                  ASADD = 0.
                  DO IS = 1, MSC
                    SIG = SPCSIG(IS)
                    AA  = SIG*AC2(ID,IS,INDXGR)
                    AADD = AADD + AA
                    ASADD = ASADD + SIG*AA
                  ENDDO
                  AX = AX + AADD * SPCDIR(ID,2)
                  AY = AY + AADD * SPCDIR(ID,3)
                  ATOT = ATOT + AADD
                  ASTOT = ASTOT + ASADD
                ENDDO
                IF (ASTOT.GT.0.) THEN
                  HS = 4. * SQRT(FRINTF*DDIR*ASTOT)
                  APER = PI2 * ATOT / ASTOT
                  ADEG = 180./PI * ATAN2(AY,AX)
                ELSE
                  HS = 0.
                  APER = -999.
                  ADEG = -999.
                ENDIF
                WRITE (PRTEST, 74) HS, APER, ADEG
  74            FORMAT (' Hs, Per, Dir: ', 3E12.4)
              ENDIF
            ENDDO
          ENDIF
        ENDIF
      ENDDO
*
*     update input fields (wind, water level etc.)
*
*     fields 5 and 6: wind
      IF (IFLDYN(5) .EQ. 1) THEN
        CALL FLFILE ( 5, 6, 'WXI', 'WYI',
     &               0, JWX2, JWX3, 0, JWY2, JWY3,
     &               COSWC, SINWC, POOL, RPOOL,                           30.90
     &               COMPDA, XCGRID, YCGRID,
     &               KGRPNT, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IF (NPTST.GT.0) THEN
          WRITE (PRTEST, '(A)') ' wind from file in test points'
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JWX3)
          ENDDO
          WRITE (PRTEST, 122) ' X-comp: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JWY3)
          ENDDO
          WRITE (PRTEST, 122) ' Y-comp: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
 122      FORMAT (A, 10(1X,E11.4))
        ENDIF
      ENDIF
 
*     field 4: friction coeff.
      IF (IFLDYN(4) .EQ. 1) THEN
        CALL FLFILE ( 4, 0, 'FRI', '    ',
     &               0, JFRC2, JFRC3, 0, 0, 0,
     &               1., 0., POOL, RPOOL,                                 30.90
     &               COMPDA, XCGRID, YCGRID,
     &               KGRPNT, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IF (NPTST.GT.0) THEN
          WRITE (PRTEST, '(A)') ' fric coeff from file in test points'
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JFRC3)
          ENDDO
          WRITE (PRTEST, 122) 'friction: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
        ENDIF
      ENDIF
 
*     field 7: water level
      IF (IFLDYN(7) .EQ. 1) THEN
        CALL FLFILE ( 7, 0, 'WLEV', '    ',
     &               JWLV1, JWLV2, JWLV3, 0, 0, 0,
     &               1., 0., POOL, RPOOL,                                 30.90
     &               COMPDA, XCGRID, YCGRID,
     &               KGRPNT, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IERR = 0
        CALL DPINQP (POOL, 'DEB', INDX, PTYPE, IDEB, LENR, IERR)
*       Add bottom level to obtain depth
        DO 31 IX = 1, MXC
          DO 41 IY = 1, MYC
            INDX = KGRPNT(IX,IY)
            IF (INDX.GT.1) THEN
              XP = XCGRID(IX,IY)
              YP = YCGRID(IX,IY)
              DEP = SVALQI (XP, YP, 1, RPOOL(IDEB+1), 1 ,IX ,IY)              30.90
              COMPDA(INDX,JDP1) = COMPDA(INDX,JDP2)
              WLVL = COMPDA(INDX,JWLV2)
              DEPW = DEP + WLVL + WLEV
              COMPDA(INDX,JDP2) = DEPW
              IF (LSETUP.GT.0) THEN                                       40.14
                COMPDA(INDX,JDPSAV) = COMPDA(INDX,JDP2)                   40.14
              ENDIF                                                       40.14
            ENDIF
 41       CONTINUE
 31     CONTINUE
        IF (NPTST.GT.0) THEN
          WRITE (PRTEST, '(A)') ' water level from file in test points'
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JWLV3)
          ENDDO
          WRITE (PRTEST, 122) ' W-level: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
        ENDIF
      ENDIF
 
*     field 2 and 3: current velocity
      IF (IFLDYN(2) .EQ. 1) THEN
        CALL FLFILE ( 2, 3, 'UXB', 'UYB',
     &               JVX1, JVX2, JVX3, JVY1, JVY2, JVY3,
     &               COSVC, SINVC, POOL, RPOOL,                           30.90
     &               COMPDA, XCGRID, YCGRID,
     &               KGRPNT, IERR)
        IF (STPNOW()) RETURN                                              34.01
*       reduce current velocity if Froude number is larger than PNUMS(18)
        DO IX = 1, MXC                                                    40.13
          DO IY = 1, MYC                                                  40.13
            INDX = KGRPNT(IX,IY)                                          40.13
            IF (INDX.GT.1) THEN                                           40.13
              DEPW = COMPDA(INDX,JDP2)
              IF (DEPW.GT.0.) THEN
                UU = COMPDA(INDX,JVX2)
                VV = COMPDA(INDX,JVY2)
                VTOT = SQRT (UU*UU + VV*VV)
                CGMAX = PNUMS(18)*SQRT(GRAV*DEPW)
                IF (VTOT .GT. CGMAX) THEN
                  CGFACT = CGMAX / VTOT
                  COMPDA(INDX,JVX2) = UU * CGFACT
                  COMPDA(INDX,JVY2) = VV * CGFACT
!                 write IX,IY to error points file
                  IF (ERRPTS.GT.0) THEN
                    WRITE (ERRPTS, 211) IX, IY, 1
 211                FORMAT (I4, 1X, I4, 1X, I2)
                  ENDIF
                ENDIF
              ENDIF
            ENDIF                                                         40.13
          ENDDO                                                           40.13
        ENDDO                                                             40.13
        IF (NPTST.GT.0) THEN
          WRITE (PRTEST, '(A)') ' current vel from file in test points'
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JVX3)
          ENDDO
          WRITE (PRTEST, 122) ' X-comp: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
          DO IPTST = 1, MIN(10,NPTST)
            IXP = XYTST(2*IPTST-1)
            IYP = XYTST(2*IPTST)
            TSTVAL(IPTST) = COMPDA(KGRPNT(IXP,IYP),JVY3)
          ENDDO
          WRITE (PRTEST, 122) ' Y-comp: ',
     &          (TSTVAL(IPTST), IPTST=1,MIN(10,NPTST))
        ENDIF
      ENDIF
C
C     End of subroutine SNEXTI
C
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE RBFILE (SPCSIG, SPCDIR, BFILED, BSPLOC,
     &                   BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,                  30.90
     &                   BSPECS, BSPAUX, RBSAUX, XYTST )                  30.90
C
C****************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C  0. Authors
C
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
C     40.05: Ekaterini E. Kriezi
C
C  1. Updates
C
C     40.00, Nov. 97: new subroutine
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description of several variables
C     40.03, Nov. 99: after label 380 BFILED(15) is replaced by BFILED(14)
C            May  00: in calls of DTRETI now BFILED(6) is used as time option
C     40.05, Aug. 00: WW3 nesting and changes in the form of the code
C                     (use of f90 features), Revision of subroutine
C     40.02, Oct. 00: Avoided REWIND of uninitialised unit number NDSD
!     40.13, Apr. 01: GOTO 392 added for a single boundary file (case NDSL=0)
!     40.13, May  01: read heading lines in case of WAM free format file
!                     changed
C
C  2. Purpose
C
C     read boundary spectra from one file and aditional information of the
C     heading lines
C
C  3. Methode
C
C     read from boundary files, aditional information (like time),
C     form the head lines per time step, and the head lines per point  spectrum,
C     read the spectrum of the boundary file.
C     Transform to spectral resolution used in Swan to obtain boundary spectra.
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C
C     RBSAUX: Real EQUIVALENCE of BSPAUX
C     RBSDIR: Real EQUIVALENCE of BSPDIR
C     RBSFRQ: Real EQUIVALENCE of BSPFRQ
C
      REAL,   INTENT(IN)     ::  SPCDIR(MDC,6)                            30.82
      REAL,   INTENT(IN)     ::  SPCSIG(MSC)                              30.82
      REAL,   INTENT(INOUT)  ::  BSPECS(MDC,MSC,NBSPEC,2)
      REAL,   INTENT(INOUT)  ::  RBSAUX(*)                                30.90
      REAL,   INTENT(INOUT)  ::  RBSDIR(*)                                30.90
      REAL,   INTENT(INOUT)  ::  RBSFRQ(*)                                30.90
C
C     BSPAUX: Auxiliary array used for interpolation
C     BSPDIR: Spectral directions of input spectrum
C     BSPFRQ: Spectral frequencies of input spectrum
C
      INTEGER, INTENT(INOUT)  :: BSPAUX(*)
      INTEGER, INTENT(INOUT)  :: BSPDIR(*)
      INTEGER, INTENT(INOUT)  :: BSPFRQ(*)
C
C     BFILED  data concerning boundary condition files
C     BSPLOC  place in array BSPECS where to store interpolated spectra
C     XYTST   test points
C
      INTEGER, INTENT(INOUT)  ::  BFILED(*)
      INTEGER, INTENT(INOUT)  ::  BSPLOC(*)
      INTEGER, INTENT(IN)     ::  XYTST(*)
C
C  5. Paarmeter variables
C
C     --
C
C  6. Local variables
C
      INTEGER   IADRS, DORDER, NDSL, NDSD, IHD, IBOUNC, IBSPEC, IERR
      INTEGER   ID, IS, JJ, NANG, NFRE, COUNT_IT, IENT, II               40.05
      INTEGER   WWDATE, WWTIME                                           40.05
C
C     IADRS     function to find address of dynamic array in pool
C     DORDER    if <0, order of reading directions is reversed
C     NDSL      unit ref num for namelist file
C     NDSD      unit ref num for data file
C     IHD       counter for heading lines
C     IBOUNC    counter for boundary locations
C     IBSPEC    counter for spectra
C     ID        counter for directions
C     IS        counter for frequencies
C     JJ        counter
C     NANG      number of directions on file
C     NFRE      number of frequencies on file
C     COUNT_IT  counter of the time entering in the boundary file
C
C     WWDATE, WWTIME       time code in WaveWatch                         40.05
C
      REAL      TIMF1, TIMF2, UFAC, W1, BDEPTH, DUM_A, RFAC               40.05
      REAL      XLON, XLAT, XDATE, EMEAN, THQ, FMEAN, USNEW, THWNEW
C
C     TIMF1     time of reading old boundary condition
C     TIMF2     time of reading new boundary condition
C     UFAC      mult. factor
C     W1        weighting coefficient used in interpolation
C     XLON      logitude
C     XLAT      latitude
C     XDATE     date-time read from WAM file
C     EMEAN     coefficient read from WAM file, ignored
C     THQ       coefficient read from WAM file, ignored
C     FMEAN     coefficient read from WAM file, ignored
C     USNEW     coefficient read from WAM file, ignored
C     THWNEW    coefficient read from WAM file, ignored
C     DUM_A     dummy local varable (not used in any calculation)
C     BDEPTH    depth of the boundary points
C
      DOUBLE PRECISION DDATE
C     DDATE     date-time read from WAM file
C
      LOGICAL   NSTATF, UNFORM
C     NSTATF    if True time appears in bound. cond. file
C     UNFORM    if True reading is done unformatted
C
      CHARACTER BTYPE *4, HEDLIN *80, TIMSTR *20, CDATE *10,
     &          DATITM(5) *18, SWWDATE*15, PTNME*12
C     BTYPE     type of boundary condition
C     HEDLIN    heading line
C     TIMSTR    time string
C     CDATE     date-time read from file
C
C  7. Common Blocks and Modules
C
C
C  8. SUBROUTINES USED
C
C
C     COPYCH, DTRETI, LSPLIT, SSHAPE, RESPEC, MSGERR, SINTRP, IADRS
C
C  9. SUBROUTINES CALLING
C
C       SNEXTI
C
C  10. ERROR MESSAGES
C
C        ---
C
C  11. REMARKS
C
C
C  12. STRUCTURE
C
C       ---------------------------------------------------------
C       If file contains stationary wave data
C       Then If time2 < 0
C            Then Read boundary values from file
C                 Transform to spectral resolution used in Swan to
C                 obtain boundary spectra
C                 Make time2 = + Inf
C            ----------------------------------------------------
C       Else Make time1 = timco - DT
C            Repeat
C                 If timco > time2
C                 Then Exit from repeat
C                 -----------------------------------------------
C                 Make time1 = time2
C                 Make old field values = new values
C                 Read new values from file
C            ----------------------------------------------------
C            Interpolate in time between old and new values
C            to update old values
C            Transform to spectral resolution used in Swan to
C            obtain boundary spectra
C       ---------------------------------------------------------
C
C 13. SOURCE
C
C****************************************************************
C
C
      SAVE COUNT_IT                                                       NRL
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT, 'RBFILE')
C
C
C     if data file is exhausted, return
      IF (BFILED(1).EQ.-1) GOTO 900
      NSTATF = (BFILED(1) .GT. 0)
      IERR   = 0
      CALL COPYCH (BTYPE, 'F', BFILED(7), 1, IERR)
C
      IF (BTYPE.EQ.'WAMW' .OR. BTYPE.EQ.'WAMC') THEN
        UNFORM = .TRUE.
      ELSE
        UNFORM = .FALSE.
      ENDIF
C
      IF (BFILED(2).LT.0) COUNT_IT = 0                                    40.05
C
      DORDER = BFILED(9)
      TIMF1 = REAL(BFILED(2))
      TIMF2 = REAL(BFILED(3))
      IF (ITEST.GE.120) WRITE (PRINTF, 187) BFILED(1), BTYPE,
     &      TIMF1, TIMF2, TIMCO
 187  FORMAT (' Boundary', I2, 2X, A, ' times: ', 3F10.1)
C
C     if time > time of last set of spectra, read new spectra
C
C     While Loop named GLOOP
C
      GLOOP : DO                                                          40.05
C
        IF (TIMCO.GT.TIMF2)THEN                                           40.05
C
C     then read from boundary nesting files all the information
C     and the spectral
C
C     COUNT_IT : counter of the time which enter in a WW3  boundary file
C     and read spectral - used to calculate NHED (number of heading lines
C     per time) in WW3N case.
C
          COUNT_IT = COUNT_IT+1                                           40.05
          NDSL = BFILED(4)
          NDSD = BFILED(5)
C
C     in WW3  case rewind the boundary file
          IF(BTYPE.EQ.'WW3N') REWIND(NDSD)                                40.05
C
          TIMF1 = TIMF2
C
C         move new spectra to old for all boundary points
          DO IBOUNC = 1, BFILED(8)
            IBSPEC = BSPLOC(IBOUNC)
 
            DO ID = 1, MDC
              DO IS = 1, MSC
                BSPECS(ID,IS,IBSPEC,1) = BSPECS(ID,IS,IBSPEC,2)
              ENDDO
            ENDDO
 
            IF (ITEST.GE.80) WRITE (PRTEST, *) ' spectrum moved ',
     &         IBSPEC, TIMF1
          ENDDO
C
 210       CONTINUE
C
C     define the new  NHED in every time step for WW3 case
          IF (BTYPE.EQ.'WW3N') THEN
            BFILED(15) = BFILED(14)+(1+((BFILED(16)-1)+
     &                 CEILING((BFILED(12)* BFILED(10))/7.))*
     &                 BFILED(8))*(COUNT_IT-1)                            40.05
          ENDIF                                                           40.05
C
C     read heading lines per time step
C
C     HBFL is loop over the number of heading lines per time step
          HBFL : DO IHD = 1, BFILED(15)                                   40.05
            IF (UNFORM) THEN
              READ (NDSD, END=380, ERR=920)
            ELSEIF ((.NOT.UNFORM).AND.(BTYPE.EQ.'WW3N')) THEN             40.05
              READ (NDSD,*)                                               40.05
            ELSE                                                          40.05
              READ (NDSD, '(A)', END=380, ERR=920) HEDLIN
              IF (ITEST.GE.90) WRITE (PRINTF, 212) HEDLIN
 212          FORMAT (' heading line: ', A)
              IF (BTYPE.EQ.'SWNT') THEN
C               convert time string to time in seconds
                CALL DTRETI (HEDLIN(1:18), BFILED(6), TIMF2)              40.03
              ENDIF
            ENDIF
          ENDDO HBFL
C
          IF (.NOT.NSTATF) TIMF2 = 0.
          IF (ITEST.GE.60) WRITE (PRINTF, 214)
     &        TIMF1, TIMF2, TIMCO, BFILED(8), BFILED(15)
 214      FORMAT (' Boundary times ', 3F12.0, 2X, 4I4)
C
C         read aditional information from the headers and spectrum from
C         the nesting boundary files (for all the cases)
C
C
C       BP_LOOP loop over the boundary nesting points
          BP_LOOP : DO  IBOUNC = 1, BFILED(8)                             40.05
C
            IBSPEC = BSPLOC(IBOUNC)
C           division by 2*Pi to account for difference in definition of freq.
C           Hz to rad/s
            NANG  = BFILED(10)                                            40.00
C
C           calculate UFAC for the different nesting cases
            IF (BTYPE(1:3).EQ.'SWN' .AND. NANG.GT.0) THEN
C           in addition multiply by 180/Pi to account for directions in degr
C           instead of radians (Swan 2D spectral files)
              UFAC = 180./ (2.*PI**2)
            ELSE                                                          40.05
              UFAC = 1./ (2.*PI)
            ENDIF
C           divide by Rho*Grav if quantity on file is energy density
            IF ((BFILED(17).EQ.1))  UFAC = UFAC / (RHO*GRAV)
C
C           read information from  heading lines per spectrum
C
C          do loop over the numbers of the heading lines per spectrum
C
            DO IHD = 1, BFILED(16)
C
              IF (IBOUNC.EQ.1) THEN                                       40.03
C             for the first spectrum (first point), read time from
C             heading line                                                40.03
                IF (BTYPE.EQ.'WAMW') THEN                                 40.03
                  READ(NDSD, END=380, ERR=920) XLON, XLAT, CDATE,
     &               EMEAN, THQ, FMEAN, USNEW, THWNEW
                  TIMSTR = CDATE
C                 convert time string to time in seconds
                  CALL DTRETI (TIMSTR, BFILED(6), TIMF2)                  40.03 40.05
                ELSE IF (BTYPE.EQ.'WAMC') THEN
                  READ(NDSD, END=380, ERR=920) XLON, XLAT, XDATE,
     &                EMEAN, THQ, FMEAN, USNEW, THWNEW
                  WRITE (TIMSTR,'(F11.0,9X)') XDATE
C                 convert time string to time in seconds
                  CALL DTRETI (TIMSTR, BFILED(6), TIMF2)                  40.03 40.05
                ELSE IF (BTYPE.EQ.'WAMF') THEN
                  READ(NDSD,*, END=380, ERR=920) XLON, XLAT, DDATE,
     &              EMEAN, THQ, FMEAN, USNEW, THWNEW
                  WRITE (TIMSTR,'(F11.0,9X)') DDATE
C                 convert time string to time in seconds
                  CALL DTRETI (TIMSTR, BFILED(6), TIMF2)                  40.03 40.05
                ELSE IF (BTYPE.EQ.'WW3N') THEN                            40.05
C                  read from heading lines per spectrum , date ,time      40.05
                  IF(IHD.EQ.1) THEN                                       40.05
                    READ(NDSD,*, END=380, ERR=920) WWDATE, WWTIME         40.05
                    WRITE (TIMSTR, 118) WWDATE, WWTIME                    40.05
 118                FORMAT (I8,'.',I6)                                    40.05
C                    convert time string to time in seconds
                    CALL DTRETI (TIMSTR, BFILED(6), TIMF2)                40.05
                  ELSE                                                    40.05
C                   DUM_A dummy local varable used to read  formated files40.05
C                   this varible will be not used in any calculation      40.05
                    READ (NDSD,901) PTNME, DUM_A, DUM_A, BDEPTH,          40.05
     &                              DUM_A, DUM_A, DUM_A, DUM_A            40.05
                  ENDIF                                                   40.05
                ELSE                                                      40.05
C                 SWAN files                                              40.05
                  READ (NDSD, '(A)', END=380, ERR=920) HEDLIN             40.05
                  IF (ITEST.GE.100) WRITE (PRINTF, 212) HEDLIN            40.05
                ENDIF
              ELSE
                IF (UNFORM) THEN
                  READ (NDSD, END=380, ERR=920)
                ELSE IF (BTYPE.EQ.'WW3N') THEN                            40.13 40.05
C                 read from heading lines per spectrum depth of the       40.05
C                 boundary point                                          40.05
                  IF (IHD.GT.1) EXIT                                      40.05
C                 exit is used because  the header per spectrume in WW3   40.05
C                 for IBOUC>1 is one line                                 40.05
C                 DUM_A  is a dummy local parameter used in formated read 40.05
                  READ (NDSD,901) PTNME, DUM_A, DUM_A, BDEPTH,
     &                            DUM_A, DUM_A, DUM_A, DUM_A              40.05
                ELSE IF (BTYPE.EQ.'WAMF') THEN
!                 read HEDLIN replaced because data are sometimes written 40.13
!                 on two subsequent lines                                 40.13
                  READ(NDSD,*, END=380, ERR=920) XLON, XLAT, DDATE,       40.13
     &              EMEAN, THQ, FMEAN, USNEW, THWNEW
                ELSE
                  READ (NDSD, '(A)', END=380, ERR=920) HEDLIN
                  IF (ITEST.GE.100) WRITE (PRINTF, 212) HEDLIN
                ENDIF
              ENDIF
C
              IF (BTYPE(1:3).EQ.'SWN') THEN
C             SWAN nesting: take proper action if heading line contains ZERO or NODATA
                IF (HEDLIN(1:6).EQ.'NODATA' .OR. HEDLIN(1:4).EQ.'ZERO')
     &               THEN
                  DO IS = 1, MSC
                    DO ID = 1, MDC
                      BSPECS(ID,IS,IBSPEC,2) = 0.
                    ENDDO
                  ENDDO
C                 skip reading of values
                  CYCLE BP_LOOP                                           40.05
                ELSE IF (HEDLIN(1:6).EQ.'FACTOR') THEN
                  READ (NDSD, *) RFAC
                  UFAC = UFAC * RFAC
C                 multiply factor read from file by UFAC (factor following from
C                 type of file)
                ELSE
C                 note: in case of 1d spectra heading line can be ignored
                  IF (NANG.GT.0) THEN                                     40.00
                    CALL MSGERR (3,
     &                'incorrect code in b.c. file: '//HEDLIN(1:20))      40.00
                  ENDIF                                                   40.00
                ENDIF
              ENDIF
C           end loop over heading lines per spectrume
            ENDDO
C
C       test output: which spectrum is processed                          40.00
C
            IF (ITEST.GE.60) THEN
              INQUIRE (UNIT=NDSD, NAME=FILENM)                            40.00
              WRITE (PRTEST, 188) FILENM, CHTIME, IBOUNC, UFAC
 188          FORMAT
     &   (' read spectrum ', A, '; time=', A, ' nr=', I3, F9.3)           40.00
            ENDIF
C
C       start reading incoming wave data
C
            IF (BTYPE.EQ.'TPAR') THEN
              READ (NDSD, 222, END=380) HEDLIN
 222          FORMAT (A)
              CALL LSPLIT (HEDLIN, DATITM, 5)
              CALL DTRETI (DATITM(1), BFILED(6), TIMF2)                   40.03
              IF (ITEST.GE.60) WRITE (PRTEST, *) ' TPAR boundary ',
     &              TIMF2, (SPPARM(JJ), JJ=1,4)
              DO II = 1, 4
                READ (DATITM(II+1), '(G12.0)') SPPARM(II)
              ENDDO
              BFILED(3) = NINT(TIMF2)
              CALL SSHAPE (BSPECS(1,1,IBSPEC,2), SPCSIG, SPCDIR,
     &                 FSHAPE, DSHAPE)
            ELSE
C         other (spectral) boundary conditions
              NANG  = BFILED(10)
              NFRE  = BFILED(12)
CC
C         call RESPEC subroutine to read the spectum of the bound. files
C
C
             CALL RESPEC (BTYPE, NDSD, BFILED, UNFORM, DORDER,            40.00
     &           RBSAUX(IADRS(BSPAUX,1)), RBSAUX(IADRS(BSPAUX,2)),        30.90
     &           RBSAUX(IADRS(BSPAUX,3)), RBSAUX(IADRS(BSPAUX,4)),        30.90
     &           SPCSIG, SPCDIR, RBSFRQ, RBSDIR, BSPECS(1,1,IBSPEC,2),    30.90
     &           UFAC, IERR)
             IF (IERR.EQ.9) GOTO 380
            ENDIF
C
          END DO BP_LOOP                                                  40.05
C
          IF (ITEST.GE.60) WRITE (PRINTF, 287) BTYPE, TIMF2
 287      FORMAT
     &         (' Boundary data type ', A, ' processed, time: ', F10.1)
C
C        cycle back to will loop
          CYCLE GLOOP                                                     40.05
C
C         if there are no more data on a boundary data file
C         close this file, and see if there is a next one
C
 380      CLOSE(NDSD)
C         read filename of next boundary file and open them
          IF (NDSL.GT.0) THEN                                             40.05
            READ (NDSL, '(A)', END=390, ERR=930) FILENM
            IF (UNFORM) THEN
              OPEN (NDSD, FILE=FILENM, FORM='UNFORMATTED',
     &               STATUS='OLD', ERR=930)
C              read heading lines
              DO IHD = 1, BFILED(14)                                      40.03
                READ (NDSD, END=940, ERR=920)
              ENDDO
            ELSEIF ((.NOT.UNFORM).AND.(BTYPE.EQ.'WW3N')) THEN             40.05
C             if it is WW3 open the new file only
              OPEN (NDSD, FILE=FILENM, FORM='FORMATTED',                  40.05
     &               STATUS='OLD', ERR=930)                               40.05
              COUNT_IT = 1                                                40.05
            ELSE                                                          40.05
              OPEN (NDSD, FILE=FILENM, FORM='FORMATTED',
     &               STATUS='OLD', ERR=930)
              DO IHD = 1, BFILED(14)                                      40.03
C               read heading lines
                READ (NDSD, '(A)', END=940, ERR=920) HEDLIN
                IF (ITEST.GE.80) WRITE (PRINTF, 212) HEDLIN
              ENDDO
            ENDIF
C
C      go back to statement 210 to start again the procedure of reading
C      info and spectrum from the new boundary file
C
            GOTO 210
C
          ELSE
!           boundary data are read from a single file
            GOTO 392                                                      40.13
          ENDIF                                                           40.05
C         close file containing filenames
 390      CLOSE (NDSL)
C
          BFILED(5) = 0
C         write message and close file containing spectra
 392      CALL MSGERR (1, 'data on boundary file exhausted')
C
          BFILED(4) = 0
          BFILED(1) = -1
          TIMF2 = 999999999.
          CYCLE GLOOP                                                     40.05
C
C        (if necessary) data have been read from file, now interpolate in time
C
        ELSE                                                              40.05
C       if time < time of last set of spectra then Transform to spectral
C       resolution used in Swan to obtain boundary spectra
C
          W1 = (TIMF2-TIMCO) / (TIMF2-TIMF1)
          DO IBOUNC = 1, BFILED(8)
            IBSPEC = BSPLOC(IBOUNC)
            IF (IBOUNC.EQ.1 .AND. ITEST.GE.80) WRITE (PRTEST, 403)
     &           TIMCO, W1, TIMF1, TIMF2, IBSPEC
 403        FORMAT (' interp in time ', F14.1, F8.3, 2F14.1, I4)
C
C       interpolate spectra in time; result has to appear in BSPECS(..,1)
C       first interpolate to aux. array
C
            CALL SINTRP (W1, 1.-W1, BSPECS(1,1,IBSPEC,1),
     &               BSPECS(1,1,IBSPEC,2), RBSAUX(IADRS(BSPAUX,2)),       30.90
     &               SPCDIR, SPCSIG)
C       use SINTRP to copy contents of aux. array to BSPECS(..,1)
C
            CALL SINTRP (1., 0., RBSAUX(IADRS(BSPAUX,2)),                 30.90
     &               BSPECS(1,1,IBSPEC,2), BSPECS(1,1,IBSPEC,1),
     &               SPCDIR, SPCSIG)
          ENDDO
          BFILED(2) = NINT(TIMCO)
          BFILED(3) = NINT(TIMF2)
          EXIT GLOOP
C       end of time comparison
        ENDIF                                                             40.05
 
C     end of while loop
      END DO GLOOP                                                        40.05
C
C
 901  FORMAT (A12,2F7.2,F10.1,2(F7.2,F6.1))
C
 900  RETURN
C
 920  INQUIRE (UNIT=NDSD, NAME=FILENM)                                    40.00
      CALL MSGERR (4,
     &     'error reading data from boundary file '//FILENM)              40.00
      GOTO 900
 930  CALL MSGERR (4,
     &     'error opening boundary file '//FILENM)                        40.00
      GOTO 900
 940  INQUIRE (UNIT=NDSD, NAME=FILENM)                                    40.00
      CALL MSGERR (4,
     &     'unexpected end of file on boundary file '//FILENM)            40.00
      GOTO 900
C
C     End of subroutine RBFILE
C
      END
C****************************************************************
C
C
      SUBROUTINE RESPEC (BTYPE, NDSD, BFILED, UNFORM, DORDER,           40.00
     &                   BAUX1, BAUX2, BAUX3, BAUX4,                    40.05
     &                   SPCSIG, SPCDIR, BSPFRQ, BSPDIR, LSPEC, UFAC,
     &                   IERR)
C
C****************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C
C  0. Authors
C
C     30.81: Annette Kieftenburg
C     40.00, 40.13: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.05: Ekaterini E. Kriezi
C
C  1. Update
C
C     40.00, Nov. 98: new subroutine
C     30.81, Feb. 99: approximation for MS > 10 corrected
C     40.02, Feb. 00: initialisation of ISIGTA
C     40.05, Aug. 00: WW3 nesting and changes in the form of the code
C                     (use of f90 features), Revise vertion of subroutine
!     40.02, Sep. 00: Made BAUX0 allocatable
!     40.13, Apr. 01: message concerning ISIGTA removed
C
C  2. Purpose
C
C        read one 1-d OR 2-d boundary spectrum from file, and transform
C        to internal SWAN spectral resolution
C
C  3. Methode
C
C
C  4. Argument variables
C
C
      INTEGER, INTENT(INOUT)  :: BFILED(*)                                40.05
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C
      REAL,    INTENT(IN)     :: SPCDIR(MDC,6)                            30.82
      REAL,    INTENT(IN)     :: SPCSIG(MSC)                              30.82
      REAL,    INTENT(IN)     :: BSPDIR(*)
      REAL,    INTENT(IN)     :: BSPFRQ(*)
      REAL,    INTENT(INOUT)  :: BAUX1(BFILED(10),BFILED(12))             40.05
      REAL,    INTENT(INOUT)  :: BAUX2(MDC,BFILED(12))                    40.05
      REAL,    INTENT(INOUT)  :: BAUX3(*)
      REAL,    INTENT(INOUT)  :: BAUX4(*)
      REAL,    INTENT(INOUT)  :: LSPEC(MDC,MSC)
      REAL,    INTENT(IN)     :: UFAC                                     40.05
C
      INTEGER,  INTENT(IN) ::  NDSD                                       40.00
      INTEGER,  INTENT(IN) ::  DORDER                                     40.00
      INTEGER,  INTENT(INOUT) ::  IERR                                    40.00
C
      LOGICAL   UNFORM
C
      CHARACTER BTYPE *4
C
C     BTYPE    char  inp   type of input
C     NDSD     int   inp   unit ref. number of input file
C     BFILED   int   inp   options for reading boundary condition file    40.00
C     UNFORM   log   inp   if True, unformatted reading is called for
C     DORDER   int   inp   if <0, order of directions has to be reversed
C     NANG     int   inp   num of spectral direction of input spectrum
C     NFRE     int   inp   num of spectral frequencies of input spectrum
C     BAUX1    real   -    aux. array
C     BAUX2    real   -    aux. array
C     BAUX3    real   -    aux. array
C     BAUX4    real   -    aux. array
C     BSPFRQ   real  inp   spectral frequencies of input spectrum
C     BSPDIR   real  inp   spectral directions of input spectrum
C     LSPEC    real  out   interpolated spectrum
C     UFAC     real  inp   factor used to multiply data
C     IERR     int   out   error status, 0: no error, 9: end of file
C
C  5. Parameter variables
C
C  6. Local variables
C
C     IANG      counter of directions
C     IFRE      counter of frequencies
C     ID        counter of directions
C     IS        counter of frequencies
C     ISIGTA    the last frequency which is determined by interpolation
C
      INTEGER   IANG, IFRE, ID, IS, ISIGTA,IENT,NFRE,NANG
C
      REAL, ALLOCATABLE :: BAUX0(:,:)                                     40.05
      REAL      ETOT, ADEG, DD, ADIR, MS, CTOT, ACOS, CDIR
      REAL      DSUM, DSPR
C
C     ETOT      energy integrated over directions
C     ADEG      average direction in degr
C     DD        parameter for directional distribution
C     ADIR      average direction in rad
C     MS        power of Cos in directional distribution
C     CTOT      coefficient
C     DSPR      directional spread in rad
C     ACOS      cos of angle between direction and average dir.
C     CDIR      energy in one directional bin
C     BAUX0     auxxilary array for engry density
C
C  7. Common Blocls and Modules Used
C
C
C  8. Subroutines used
C
C       GAMMA
      REAL :: GAMMA                                                       40.03
C
C  9. Subroutines calling
C
C     RBFILE
C
C  10. Error messages
C
C        ---
C
C  11. Remarks
C
C
C  12. Structure
C
C       ---------------------------------------------------------
C       for all frequencies of input spectrum do
C           if NANG = 0
C           then read energy density, av. direction and dir. spread
C                determine directional distribution
C           else read spectral energy densities (1 .. NANG)
C                redistribute to get densities for Swan directions
C       ---------------------------------------------------------
C       for all spectral directions do
C           redistribute te get densities for Swan frequencies
C       ---------------------------------------------------------
C
C  13. Source text
C
C****************************************************************
C
C
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT, 'RESPEC')
C
C     read the values from array BFILED for the  number of
C     direction and frequencies
C
      NANG = BFILED(10)                                                   40.05
      NFRE = BFILED(12)                                                   40.05
      ALLOCATE (BAUX0(NFRE,NANG))                                         40.02
 
      IF (ITEST.GE.60) THEN
        INQUIRE (UNIT=NDSD, NAME=FILENM)                                  40.00
        WRITE (PRTEST, 7) FILENM, NANG, NFRE, UFAC, BFILED(18),           40.00
     &  BFILED(19), UNFORM
   7    FORMAT (' Entry RESPEC, reading file:', A, /, 6X,
     &  I3, ' angles ', I3, ' freqs; factor ',
     &  E12.4, ' dir.def:', I2, ' dir.spr.def:', I2, ' unform:', L2)      40.00
      ENDIF
C
C     Initialisation
C
      ISIGTA = MSC                                                        40.02
C
C     read spectral energy densities from b.c. file
      IF (NANG.EQ.0) THEN
C
C     one D spectral input                                                40.05
C
        DO  IFRE=1,NFRE                                                   40.05
C         1-D spectral input (only function of frequency)
          IF (IFRE.EQ.1) THEN
            READ (NDSD,*,END=940,ERR=920) ETOT, ADEG, DD
          ELSE
            READ (NDSD,*,END=930,ERR=920) ETOT, ADEG, DD
          ENDIF
C
          IF (BFILED(18).EQ.1) THEN                                       40.00
C           conversion from degrees to radians
            ADIR = PI * ADEG / 180.
          ELSE
C           conversion from Nautical to Cartesian conv.
            ADIR = PI * (180.+DNORTH-ADEG) / 180.
          ENDIF
C
          IF (BFILED(19).EQ.1) THEN                                       40.00
C           DSPR is directional spread in radians
            DSPR = PI * DD / 180.
            MS = MAX (DSPR**(-2) - 2., 1.)
          ELSE
            MS = DD
          ENDIF
C
          IF (ITEST.GE.80) WRITE (PRTEST, 12) IFRE, ETOT,                 40.00
     &          180.*ADIR/PI, MS
  12      FORMAT (' read freq ', I3, E10.3, '; Cart dir ',                40.00
     &          F7.1, '; Cos power ', F7.2)
C
C         generate distribution over directions
C
C         equations taken from Jahnke & Emde (chapter Factorial Function)
          IF (MS.GT.10.) THEN
            CTOT = SQRT(MS/(2.*PI)) * (1. + 0.25/MS)                      30.81 40.00
          ELSE
            CTOT = 2.**MS * (GAMMA(1.+0.5*MS))**2 / (PI * GAMMA(1.+MS))   40.00
          ENDIF
          DSUM = 0.
          DO ID = 1, MDC
            ACOS = COS(SPCDIR(ID,1) - ADIR)                               30.82
            IF (ACOS .GT. 0.) THEN
              CDIR = CTOT * MAX (ACOS**MS, 1.E-10)
            ELSE
              CDIR = 1.E-10
            ENDIF
            IF (ITEST.GE.20) DSUM = DSUM + CDIR * DDIR                    40.00
            BAUX2(ID,IFRE) = CDIR * ETOT
          ENDDO
          IF (ITEST.GE.20) THEN
            IF (ABS(DSUM-1.).GT.0.1) WRITE (PRTEST, 138) DSUM, CTOT, MS   40.00
 138        FORMAT (' integral over directions is ', F9.4,
     &              ' with CTOT=', F10.3,'; power=', F8.2)                40.00
          ENDIF
        END DO                                                            40.05
C
      ELSE
C
C   (2D)    fully spectral input
        IF (UNFORM) THEN
C         unformatted reading
          IF (DORDER.LT.0) THEN                                           NRL
            READ (NDSD,END=940,ERR=920)                                   NRL
     &             ((BAUX1(IANG,IFRE),IANG=NANG,1,-1),IFRE=1,1)           NRL
            READ (NDSD,END=930,ERR=920)                                   NRL
     &             ((BAUX1(IANG,IFRE),IANG=NANG,1,-1),IFRE=2,NFRE)        NRL
          ELSE                                                            NRL
            READ (NDSD,END=940,ERR=920)                                   NRL
     &             ((BAUX1(IANG,IFRE),IANG=1,NANG),IFRE=1,1)              NRL
            READ (NDSD,END=930,ERR=920)                                   NRL
     &             ((BAUX1(IANG,IFRE),IANG=1,NANG),IFRE=2,NFRE)           NRL
          ENDIF                                                           NRL
        ELSEIF ((.NOT.UNFORM).AND.(BTYPE.EQ.'WW3N')) THEN                 40.05
C
C         WW3 reading
C         BAUX0 local array to read the energy spectra from boundary files
C
          READ (NDSD,902,END=940,ERR=920)                                 40.15
     &      ((BAUX0(IFRE,IANG),IFRE=1,NFRE),IANG=1,NANG,1)                40.15
 902      FORMAT (7E11.3)                                                 40.15
C
C         energy (variance) density   from E(FRQ,TH) to  E(TH,FRQ)
C
          DO IANG = 1,NANG                                                40.05
            DO IFRE = 1,NFRE                                              40.05
              BAUX1(IANG,IFRE) = BAUX0(IFRE,IANG)                         40.05
            ENDDO                                                         40.05
          ENDDO                                                           40.05
        ELSE
C         format reading (except WW3)
          IF (DORDER.LT.0) THEN                                           NRL
            READ (NDSD,*,END=940,ERR=920)                                 NRL
     &             ((BAUX1(IANG,IFRE),IANG=NANG,1,-1),IFRE=1,1)           NRL
            READ (NDSD,*,END=930,ERR=920)                                 NRL
     &             ((BAUX1(IANG,IFRE),IANG=NANG,1,-1),IFRE=2,NFRE)        NRL
          ELSE                                                            NRL
            READ (NDSD,*,END=940,ERR=920)                                 NRL
     &             ((BAUX1(IANG,IFRE),IANG=1,NANG),IFRE=1,1)              NRL
            READ (NDSD,*,END=930,ERR=920)                                 NRL
     &             ((BAUX1(IANG,IFRE),IANG=1,NANG),IFRE=2,NFRE)           NRL
          ENDIF                                                           NRL
        ENDIF
C
        IF (ITEST.GE.120) THEN
          WRITE (PRINTF,*)' Spectra from file'
          DO IFRE = 1, NFRE
            WRITE (PRINTF,*) IFRE, (BAUX1(IANG,IFRE),IANG=1,NANG)
          ENDDO
        ENDIF
C
C         transform to spectral directions used in SWAN
C         results appears in array BAUX2(MDC,NFRE)
C
        DO IFRE = 1, NFRE                                                40.05
          CALL CHGBAS (BSPDIR, SPCDIR, PI2, BAUX1(1,IFRE),
     &                 BAUX2(1,IFRE), NANG, MDC, ITEST, PRTEST)
        END DO                                                           40.05
      ENDIF
C
C     interpolate energy densities to SWAN frequencies distribution
C
      IF (BSPFRQ(NFRE) .LT. SPCSIG(MSC)) THEN
        DO IS = MSC, 1, -1
          IF (SPCSIG(IS).LT.BSPFRQ(NFRE)) THEN
C           ISIGTA is the last frequency which is determined by interpolation
C           higher frequencies are determined by tail expression
            ISIGTA = IS
            EXIT                                                         40.05
          ENDIF
        ENDDO
      ELSE
        ISIGTA = MSC
      ENDIF
C
C
C     UFAC is the product of the multiplication factor read from file
C     and the factor to transform from energy/Hz to energy/(rad/s)
C     and from energy/degr to energy/rad (latter only for 2d spectra)    40.00
C
      DO  ID = 1,MDC                                                     40.05
        DO  IFRE = 1,NFRE                                                40.05
          BAUX3(IFRE) = UFAC * BAUX2(ID,IFRE)
        ENDDO                                                            40.05
 
C       interpolate over frequency keeping energy constant, output BAUX4(MSC)
        CALL CHGBAS (BSPFRQ, SPCSIG, 0., BAUX3, BAUX4, NFRE, MSC,
     &               ITEST, PRTEST)
        DO  IS=1,MSC                                                      40.05
          IF (IS.LE.ISIGTA) THEN
C
C           to convert energy density to action density
C
            LSPEC(ID,IS) = BAUX4(IS)/SPCSIG(IS)
          ELSE
C
C           add a tail when IS > ISIGTA
C
            LSPEC(ID,IS) = LSPEC(ID,ISIGTA) *
     &                 (SPCSIG(ISIGTA)/SPCSIG(IS))**(PWTAIL(1)+1)
          ENDIF
          IF (ITEST.GE.140) THEN
            WRITE (PRTEST, *) 'ID,IS,LSPEC(ID,IS)', ID,IS,LSPEC(ID,IS)
          ENDIF
        ENDDO                                                             40.05
      ENDDO                                                               40.05
C
      DEALLOCATE (BAUX0)                                                  40.02
 
 900  IERR = 0
      RETURN
 920  INQUIRE (UNIT=NDSD, NAME=FILENM)                                    40.00
      CALL MSGERR (2,
     &      'read error in boundary condition file '//FILENM)             40.00
 
 
      RETURN
 930  INQUIRE (UNIT=NDSD, NAME=FILENM)                                    40.00
      CALL MSGERR (2,
     &      'insufficient data in boundary condition file '//FILENM)      40.00
 
 940  IERR = 9
 
      RETURN
 
      END SUBROUTINE RESPEC
C**********************************************************************
C
      SUBROUTINE FLFILE (IGR1, IGR2,
     &                   VNAM1, VNAM2, JX1, JX2, JX3, JY1, JY2, JY3,
     &                   COSFC, SINFC, POOL, RPOOL, COMPDA,               30.90
     &                   XCGRID, YCGRID,
     &                   KGRPNT, IERR)
C
C**********************************************************************
      IMPLICIT NONE
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
!MCEL+ J Dykes 30 Dec 2002 FLFILE: include mcel_swan.inc
      include 'mcel_swan.inc'
!MCEL-
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
C     30.90: IJsbrand Haagsma (Equivalence version)
C     40.00: Nico Booij
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     40.00, Jan. 98: new subroutine replacing code in subr SNEXTI
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Aug. 00: condition added for calling INAR2D to prevent error
C                     in case command INP GRID is present and corresponding
C                     command READ is not.
C     40.02, Oct. 00: Avoided real/int conflict by replacing RPOOL for POOL in
C                     INAR2D
!     40.13, Mar. 01: misplaced error message moved to proper place
C
C  2. PURPOSE
C
C       Update boundary conditions, update nonstationary input fields
C
C  3. METHOD
C
C
C  4. Argument list
C
C     TIMR2    real i/o time of last reading of input field
C     INTRV    real  i  time interval between input fields
C     TMENDR   real  i  end time of input field
C     IGR1     int   i  location in array COMPDA for interpolated input field data (x-comp)
C     IGR2     int   i  location in array COMPDA for interpolated input field data (y-comp)
C                       for a scalar field IGR2=0
C     VNAM1    char  i  pointer name of pool array holding values read from file (x-comp)
C     VNAM2    char  i  pointer name of pool array holding values read from file (y-comp)
C                       for a scalar field VNAM2='   '
C     JX1      int   i  location in array COMPDA for interpolated input field data (x-comp)
C     JX2      int   i  location in array COMPDA for interpolated input field data (x-comp)
C     JX3      int   i  location in array COMPDA for interpolated input field data (x-comp)
C     JY1      int   i  location in array COMPDA for interpolated input field data (y-comp)
C     JY2      int   i  location in array COMPDA for interpolated input field data (y-comp)
C     JY3      int   i  location in array COMPDA for interpolated input field data (y-comp)
C     COSFC    real  i  cos of angle between input grid and computational grid
C     SINFC    real  i  sin of angle between input grid and computational grid
C     POOL           i  dynamic data pool
C     COMPDA   real i/o array holding values for computational grid points
C     XCGRID   real  i  x-coordinate of computational grid points
C     YCGRID   real  i  y-coordinate of computational grid points
C     KGRPNT   int   i  indirect addresses of computational grid points
C     NHDF     int   i  number of heading lines for a data file
C     NHDT     int   i  number of heading lines per time step
C     NHDC     int   i  number of heading lines before second component of vector field
C     IDLA     int   i  lay-out identifier for a data file
C     IDFM     int   i  format identifier for a data file
C     DFORM    char  i  format to read a data file
C     VFAC     real  i  multiplication factor applied to values from data file
C     IERR     int   o  error status: 0=no error, 9=end-of-file
C
C
C  5. SUBROUTINES CALLING
C
C     SNEXTI
C
C  6. SUBROUTINES USED
C
      LOGICAL STPNOW                                                      34.01
C
C  7. ERROR MESSAGES
C
C        ---
C
C  8. REMARKS
C
C
C  9. Structure
C
C     --------------------------------------------------------------
C     for all comp. grid points do
C         copy new values to old
C     --------------------------------------------------------------
C     repeat
C         if present time > time of last reading
C         then read new values from file
C              update time of last reading
C              interpolate values to computational grid
C         else exit from repeat
C     --------------------------------------------------------------
C     for all comp. grid points do
C         interpolate new values
C     --------------------------------------------------------------
C
C 10. SOURCE
C
C****************************************************************
C
      INTEGER    POOL(*), KGRPNT(MXC,MYC),
     &           IGR1, IGR2, JX1, JX2, JX3, JY1, JY2, JY3, IERR
*
      REAL       COMPDA(MCGRD,MCMVAR),
     &           RPOOL(*),
     &           XCGRID(MXC,MYC), YCGRID(MXC,MYC),
     &           COSFC, SINFC
      CHARACTER  VNAM1 *(*), VNAM2 *(*)
C
C     local variables
C
      INTEGER    IENT, INDX, IX, IY, IERRL, LENR, IFXI, IFYI
C     INDX       counter of comp. grid points
C     IX         index in x-dir of comput grid point
C     IY         index in y-dir of comput grid point
C     IERRL      indicates error in finding pool array data
C     LENR       length of a pool array
C     IFXI       location in pool of array of input values
C     IFYI       location in pool of array of input values
C                (2nd component of vectorial quantity)
C
      REAL       SVALQI
C     SVALQI     real function giving interpolated value of an input array
C
      REAL       TIMR1, XP, YP, UU, VV, VTOT, W1, W3,
     &           SIZE1, SIZE2, SIZE3
C     TIMR1      time of one but last input field
C     XP         x-coord of one comput grid point
C     YP         y-coord of one comput grid point
C     UU         x-component of vector, or scalar value
C     VV         y-component of vector
C     VTOT       length of vector
C     W1         weighting coeff for interpolation in time
C     W3         weighting coeff for interpolation in time
C     DIRE       direction of interpolated vector
C     SIZE1      length of vector at time TIMR1
C     SIZE2      length of vector at time TIMCO
C     SIZE3      length of vector at time TIMR2
C
C
      CHARACTER  PTYPE *1
C     PTYPE      type of an array in the data pool
C
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'FLFILE')
*
      IERR = 0
*
      IF (JX1.GT.1) THEN
        DO INDX = 2, MCGRD
          COMPDA(INDX,JX1)=COMPDA(INDX,JX2)
        ENDDO
      ENDIF
      IF (IGR2.GT.0 .AND. JY1.GT.1) THEN
        DO INDX = 2, MCGRD
          COMPDA(INDX,JY1)=COMPDA(INDX,JY2)
        ENDDO
      ENDIF
      TIMR1 = TIMCO - DT
*
 200  IF (TIMCO.LE.IFLTIM(IGR1)) GOTO 400
      TIMR1 = IFLTIM(IGR1)
      IFLTIM(IGR1) = IFLTIM(IGR1) + IFLINT(IGR1)
      IF (IFLTIM(IGR1) .GT. IFLEND(IGR1)) THEN
        IFLTIM(IGR1) = 1.E10
        IF (IGR2.GT.0) IFLTIM(IGR2) = IFLTIM(IGR1)
        GOTO 400
      ENDIF
      IF (IFLNDS(IGR1).GT.0) THEN                                         40.03
        IERRL = 0
        CALL DPINQP (POOL, VNAM1, INDX, PTYPE, IFXI, LENR, IERRL)
        IF (IERRL.NE.0) WRITE (PRTEST, *) ' not found:', VNAM1
!MCEL+ J Dykes 30 Dec 2002 FLFILE: call mcel_get
          if (mcel_get_tag(IGR1) == 1) then
             call mcel_get (RPOOL(IFXI+1), MXG(IGR1), MYG(IGR1), 
     &          IFLTIM(IGR1), mcel_get_name(IGR1), IGR1)
          else
!MCEL-
        CALL INAR2D(RPOOL(IFXI+1), MXG(IGR1), MYG(IGR1), IFLNDF(IGR1),    40.02
     &               IFLNDS(IGR1), IFLIFM(IGR1), IFLFRM(IGR1),
     &               IFLIDL(IGR1), IFLFAC(IGR1),
     &               IFLNHD(IGR1), IFLNHF(IGR1))
!MCEL
          end if
!MCEL-
        IF (STPNOW()) RETURN                                              34.01
        IF (IFLIDL(IGR1).LT.0) THEN
*         end of file was encountered
          IFLTIM(IGR1) = 1.E10
          IF (IGR2.GT.0) IFLTIM(IGR2) = IFLTIM(IGR1)
          GOTO 400
        ENDIF
      ELSE                                                                40.13
        IF (ITEST.GE.20) THEN                                             40.13
          CALL MSGERR (1,
     &    'no read of input field because unit nr=0')                     40.13
          WRITE (PRINTF, 208) IGR1, VNAM1
 208      FORMAT (' field nr.', I2, '; name:', A)
        ENDIF
      ENDIF                                                               40.03
      IF (IGR2.GT.0) THEN
        IFLTIM(IGR2) = IFLTIM(IGR1)
        IF (IFLNDS(IGR2).GT.0) THEN                                       40.03
          IERRL = 0
          CALL DPINQP (POOL, VNAM2, INDX, PTYPE, IFYI, LENR, IERRL)
          IF (IERRL.NE.0) WRITE (PRTEST, *) ' not found:', VNAM2
!MCEL+ J Dykes 30 Jan 2003 FLFILE: call mcel_get V-component
          if (mcel_get_tag(IGR2) == 1) then
             call mcel_get (RPOOL(IFYI+1), MXG(IGR2), MYG(IGR2), 
     &          IFLTIM(IGR2), mcel_get_name(IGR2), IGR1)
          else
!MCEL-
          CALL INAR2D(RPOOL(IFYI+1), MXG(IGR2), MYG(IGR2), IFLNDF(IGR2),  40.02
     &                 IFLNDS(IGR2), IFLIFM(IGR2), IFLFRM(IGR2),
     &                 IFLIDL(IGR2), IFLFAC(IGR2), IFLNHD(IGR2), 0)
!MCEL
          end if
!MCEL-
          IF (STPNOW()) RETURN                                            34.01
        ENDIF                                                             40.03
      ENDIF
*     Interpolation over the computational grid
      DO 230 IX = 1, MXC
        DO 240 IY = 1, MYC
          INDX = KGRPNT(IX,IY)
          IF (INDX.GT.1) THEN                                             40.00
            XP = XCGRID(IX,IY)
            YP = YCGRID(IX,IY)
            UU = SVALQI (XP, YP, IGR1, RPOOL(IFXI+1), 0, IX, IY)          30.90
            IF (IGR2.EQ.0) THEN
              COMPDA(INDX,JX3) = UU
            ELSE
              VV = SVALQI (XP, YP, IGR2, RPOOL(IFYI+1), 0, IX, IY)        30.90
              COMPDA(INDX,JX3) =  UU*COSFC + VV*SINFC
              COMPDA(INDX,JY3) = -UU*SINFC + VV*COSFC
            ENDIF
          ENDIF
 240    CONTINUE
 230  CONTINUE
      GOTO 200
*
*         Interpolation in time
*
 400  W3 = (TIMCO-TIMR1) / (IFLTIM(IGR1)-TIMR1)
      W1 = 1.-W3
      IF (ITEST.GE.60) WRITE(PRTEST,402) IGR1,
     &        TIMCO,IFLTIM(IGR1),W1,W3,JX1,JY1,JX2,JY2,JX3,JY3
 402  FORMAT (' input field', I2, ' interp at ', 2F9.0, 2F8.3, 6I3)
      DO 500 INDX = 2, MCGRD
        UU = W1 * COMPDA(INDX,JX2) + W3 * COMPDA(INDX,JX3)
        IF (IGR2.LE.0) THEN
          COMPDA(INDX,JX2) = UU
        ELSE
          VV = W1 * COMPDA(INDX,JY2) + W3 * COMPDA(INDX,JY3)
          VTOT = SQRT (UU*UU + VV*VV)
*
*         procedure to prevent loss of magnitude due to interpolation
*
          IF (VTOT.GT.0.) THEN
            SIZE1 = SQRT(COMPDA(INDX,JX2)**2 + COMPDA(INDX,JY2)**2)
            SIZE3 = SQRT(COMPDA(INDX,JX3)**2 + COMPDA(INDX,JY3)**2)
            SIZE2 = W1*SIZE1 + W3*SIZE3
*           SIZE2 is to be length of vector
            COMPDA(INDX,JX2) = SIZE2*UU/VTOT
            COMPDA(INDX,JY2) = SIZE2*VV/VTOT
          ELSE
            COMPDA(INDX,JX2) = UU
            COMPDA(INDX,JY2) = VV
          ENDIF
        ENDIF
 500  CONTINUE
      RETURN
*
C     End of subroutine FLFILE
*
      END
C************************************************************************
C                                                                       *
      SUBROUTINE SWCUCU (ITM, CUXC,CUYC, KGRPNT, XCGRID,YCGRID, COMPDA)   30.72
C                                                                       *
C************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C            May  96: New subroutine
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     TRANSFORM THE CURRENT COMPONENTS GIVEN IN A CURVILINEAR
C     GRID (E,n) TO COMPONENTS IN A RECTANGULAR GRID (X,Y),
C
C  3. Method
C
C     UXC, UYC : components in a curv. grid                               40.00
C     UXR, UYR : components in a rect. grid
C
C     DX1 = X(i+1,j) - X(i-1,j)   ;  DY1 = Y(i+1,j) - Y(i-1,j)
C     DX2 = X(i,j+1) - X(i,j-1)   ;  DY2 = Y(i,j+1) - Y(i,j-1)
C
C     The discharge through (DX1,DY1) is :                                40.00
C     UXC*|DX1^2+DY1^2| = UYR*DX1-UXR*DY1
C
C     and the discharge through (DX2,DY2) is :                            40.00
C     UYC*|DX2^2+DY2^2| = UYR*DX2-UXR*DY2
C
C     using those equation UXR and UYR can be determined
C
C
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C        ITM    INT/INPUT         : TO ALOCATE THE SUBARRAY IN ARRAY COMPDA.
C        CUXC   REAL(I,J)/INPUT   : COMP XI OF CURRENT IN CURV GRID
C        CUYC   REAL(I,J)/INPUT   : COMP ETA OF CURRENT IN CURV GRID
C        KGRPNT INT(I,J)/INPUT    : ARRAY OF INDIRECT ADDRESSING
C        COMPDA REAL(I,J,K)/OUTPUT: CURRENT IN COORD. (X,Y)
C
C     5. SUBROUTINES CALLING
C        SWRBC
C
C     6. SUBROUTINES USED
C
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C****************************************************************
      INTEGER  KGRPNT(MXC,MYC)
      REAL     COMPDA(MCGRD,MCMVAR),
     &         CUXC(MXC,MYC), CUYC(MXC,MYC)
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SWCUCU')
*
*     *** To choose the current at time T , T+INTECU and the        ***   40.00
*     *** interpolate field                                         ***
*
      IF (ITM .EQ. 1) THEN
        JJX = JVX1
        JJY = JVY1
      ELSE IF (ITM .EQ. 2) THEN
        JJX = JVX2
        JJY = JVY2
      ELSE IF (ITM .EQ. 3) THEN
        JJX = JVX3
        JJY = JVY3
      ENDIF
*
      IF (ITEST .GE. 0) THEN
        WRITE(PRINTF,*) '  '
        WRITE(PRINTF,*) '******** In subroutine SWCUCU *******'           30.21
        WRITE(PRINTF,50)
      ENDIF
 50   FORMAT('Grid point',5X,'coordinates',5X,'Xcgrid',5X,'Ycgrid',       40.00
     &       5X,'Ind.adres')
*
      DO 60 IX = 2, NINT(XPG(8))-1
        DO 70 IY = 2, NINT(XPG(9))-1
          IF (KGRPNT(IX,IY) .GT. 1) THEN
            INDX = KGRPNT(IX,IY)
            DX1 = XCGRID(IX+1,IY) - XCGRID(IX-1,IY)                       30.72
            DY1 = YCGRID(IX+1,IY) - YCGRID(IX-1,IY)                       30.72
            DX2 = XCGRID(IX,IY+1) - XCGRID(IX,IY-1)                       30.72
            DY2 = YCGRID(IX,IY+1) - YCGRID(IX,IY-1)                       30.72
            A   = CUYC(IX,IY)*(DX1*DX1 + DY1*DY1)
            B   = CUXC(IX,IY)*(DX2*DX2 + DY2*DY2)
            C   = A*DX2/DX1
            D   = DY1*DX2/DX1 - DY2
            UXR = (B - C)/D
            UYR = (A + UXR*DY1)/DX1
            COMPDA(INDX,JJX) = UXR
            COMPDA(INDX,JJY) = UYR
            IF (ITEST .GE. 0)
     &        WRITE(PRINTF,30)IX,IY,XCGRID(IX,IY),YCGRID(IX,IY),          30.72
     &                      UXR,UYR,KGRPNT(IX,IY)
 30         FORMAT(2(I3,1X),1X,4(F10.1,1X),5X,I5)
          ENDIF
 70     CONTINUE
 60   CONTINUE
*
C     End of subroutine SWCUCU
*
      RETURN
      END
C
************************************************************************
*                                                                      *
      SUBROUTINE SWINCO (AC2    ,COMPDA ,
     &                   XCGRID ,YCGRID ,                                 30.72
     &                   KGRPNT ,SPCDIR ,
     &                   SPCSIG ,XYTST   )                                30.72
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
*  0. Authors
*
*     30.60: Nico Booij
*     30.70: Nico Booij
*     30.72: IJsbrand Haagsma
*     30.80, 40.13: Nico Booij
C     30.82: IJsbrand Haagsma
*
*  1. Updates
*
*            June 97: new for SWAN
*     30.60, Aug. 97: for zero wind velocity no change in action density
*                     modification to make procedure work for uniform wind
*                     maximum set to dim.less fetch loops over IS and ID
*                     swapped for efficiency
*     30.70, Sep. 97: output for test point added, argument XYTST added
*     30.72, Sept 97: Replaced DO-block with one CONTINUE to DO-block with
*                     two CONTINUE's
*     30.70, Feb. 98: computation of initial values revised argument list added
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
*     30.80, Apr. 98: correction computation FDLSS
C     30.82, Apr. 98: Modified computation of FDLSS, FPDLSS, HSDLSS
C     30.82, Oct. 98: Updated description of several variables
*     40.13, Feb. 01: correction for 1D cases
*
*  2. Purpose
*
*     Imposing of wave initial conditions at a computational grid
*
*  3. Method
*
*     The initial conditions are given using the following equation       30.70
*     for dimensionless Hs as function of dimensionless fetch:            30.70
*
*     Hs = 0.00288 f**(0.45)                                              40.00
*     Tp = 0.46    f**(0.27)                                              40.00
*     average direction = wind direction
*     directional distribution: Cos**2
*
*     after computation of the integral parameters the subroutine SSHAPE  30.70
*     is used to compute the spectrum
*
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
*
*     AC2        real  i/o   action density spectra
*     COMPDA     real  inp   quantities in comp grid points
*     KGRPNT     real  inp   indirect addresses of comp grid points
*     XYTST      int   inp   test points
*
C  6. Local variables
C
C     FDLSS : Dimensionless fetch
C     TPDLSS: Dimensionless peak period
C     HSDLSS: Dimensionless significant wave height
C
      REAL    FDLSS,  TPDLSS, HSDLSS                                      30.80
C
*  5. SUBROUTINES CALLING
*
*       SWMAIN
*
*  6. SUBROUTINES USED
*
*       SSHAPE                                                            30.70
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*  9. STRUCTURE
*
*
* 10. SOURCE TEXT
*
      REAL     COMPDA(MCGRD,MCMVAR)
*
      REAL     AC2(MDC,MSC,MCGRD)
*
      INTEGER  KGRPNT(MXC,MYC), XYTST(*)                                  30.70
*
      LOGICAL  INTERN
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SWINCO')
*
*
*     *** Fetch Computation 'the mean delta' ***
      IF (KSPHER.EQ.0) THEN
        TLEN  = (XCLEN + YCLEN)/2.
      ELSE
        COSYG = COS (DEGRAD * (YOFFS + 0.5*(YCGMIN+YCGMAX)))              33.09
        TLEN  = LENDEG * (COSYG*XCLEN + YCLEN)/2.
      ENDIF
      TDXY  = FLOAT(MXC + MYC)/2.
*
      FETCH = TLEN/TDXY
      SY0   = 3.3                                                         30.70
      IF (ITEST.GE.60 .OR. NPTST.GT.0) WRITE (PRTEST, 62) FETCH           30.70
  62  FORMAT (' test SWINCO, fetch:', E12.4)                              30.70
*
      IF (ONED) THEN                                                      40.13
        IY1 = 1                                                           40.13
        IY2 = 1                                                           40.13
      ELSE                                                                40.13
        IY1 = 2                                                           40.13
        IY2 = MYC-1                                                       40.13
      ENDIF                                                               40.13
      DO IX = 2, MXC-1                                                    40.00
        DO IY = IY1, IY2                                                  40.13
C         check if the point is a true internal point                     40.00
          INTERN = .TRUE.
          INX = KGRPNT(IX-1,IY)                                           40.00
          IF (INX.LE.1) INTERN = .FALSE.                                  40.00
          INX = KGRPNT(IX+1,IY)                                           40.00
          IF (INX.LE.1) INTERN = .FALSE.                                  40.00
          IF (.NOT.ONED) THEN                                             40.13
            INX = KGRPNT(IX,IY-1)                                         40.00
            IF (INX.LE.1) INTERN = .FALSE.                                40.00
            INX = KGRPNT(IX,IY+1)                                         40.00
            IF (INX.LE.1) INTERN = .FALSE.                                40.00
          ENDIF                                                           40.13
          INX = KGRPNT(IX,IY)                                             30.70
          IF (INX.LE.1) INTERN = .FALSE.                                  40.00
          IF (INTERN) THEN                                                40.00
            TESTFL = .FALSE.                                              30.70
            DO IPTST = 1, NPTST                                           30.70
              IF (IX.EQ.XYTST(2*IPTST-1) .AND.                            30.70
     &            IY.EQ.XYTST(2*IPTST)) TESTFL = .TRUE.                   30.70
            ENDDO                                                         30.70
*
            IF (VARWI) THEN
              WX  = COMPDA(INX,JWX2)
              WY  = COMPDA(INX,JWY2)
*
*             *** Local wind  speed and direction ***
              WSLOC = SQRT(WX*WX + WY*WY)
              IF (WX .NE. 0. .OR. WY .NE. 0.) THEN
                WDLOC = ATAN2(WY,WX)
              ELSE
                WDLOC = 0.
              ENDIF
            ELSE
*             uniform wind field
              WSLOC = U10                                                 30.60
              WDLOC = WDIP                                                30.60
            ENDIF
*
            IF (WSLOC .GT. 1.E-10) THEN                                   30.60
C
C Dimensionless Hs and Tp calculated according to K.K. Kahma & C.J. Calkoen,
C (JPO, 1992) and Pierson Moscovitz for limit values.
C
C             calculate dimensionless fetch:
              FDLSS = GRAV * FETCH / (WSLOC*WSLOC)                        30.82
*
*             calculate dimensionless significant wave height:
              HSDLSS = MIN (0.21, 0.00288*FDLSS**0.45)                    40.00
              SPPARM(1) = HSDLSS * WSLOC**2 / GRAV                        40.00
*             calculate dimensionless peak period:
              TPDLSS = MIN (1./0.13, 0.46*FDLSS**0.27)                    40.00
              SPPARM(2) = WSLOC * TPDLSS / GRAV                           40.00
              SPPARM(3) = 180. * WDLOC / PI
              SPPARM(4) = 2.
              IF (TESTFL) WRITE (PRTEST, 65) XCGRID(IX,IY),               30.70
     &        YCGRID(IX,IY), FDLSS, (SPPARM(JJ), JJ = 1, 3)               30.70
  65          FORMAT (' test point ',6(1X,E12.4))                         30.70
            ELSE
              SPPARM(1) = 0.02
              SPPARM(2) = 1.
              SPPARM(3) = 0.
              SPPARM(4) = 0.
            ENDIF
            CALL SSHAPE (AC2(1,1,INX), SPCSIG, SPCDIR, 2, 2)               40.00
*
          ENDIF
        ENDDO
      ENDDO
*
      RETURN
* * end of subroutine SWINCO *
      END
