!NRL: $Id: swanpre2.F,v 1.2.2.2 2003/06/27 22:22:25 dykes Exp $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000    1:10 pm
C
C     SWAN/SWREAD  file 2 of 4
C
C  Contents of this file:
C     SPROUT: Reading and processing of the user output commands
C     SWREPS: Reading and processing of the commands defining output points
C     SWREOQ: Reading and processing of the output requests
C     SIRAY : Searching the first point on a ray where the depth is DP
C     SWNMPS
C     SVARTP
C     SWBOUN                                                              40.00
C     BCFILE                                                              40.00
C     BCWAMN                                                              40.00
C     BOUNPT                                                              40.00
C     RETSTP                                                              40.00
C
************************************************************************
*                                                                      *
      SUBROUTINE SPROUT (FOUND, OUTDA, ROUTDA, SPCSIG, XCGRID, YCGRID,    30.90
     &                   KGRPNT, BOTLEV, WATLEV)                          30.72
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     32.02: Roeland Ris & Cor van der Schelde (1D version)
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
C
C  1. Updates
C
C    100.04, Nov. 92: Filename of plotfile will be given by user
C     30.70, Nov. 97: Arguments BOTLEV and WATLEV added
C     32.02, Feb. 98: 1D version introduced
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Apr. 98: Removed reference to commons KAART and KAR
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     30.81, Jan. 99: Replaced variable FROM by FROM_ (because FROM is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Sep. 00: inconsistency with manual corrected
C     40.02, Oct. 00: Initialisation of IERR
C
C  2. Purpose
C
C     Reading and processing of the user output commands
C
C  3. Method
C
C     If the first characters of the last read command are equal to a
C     given string (KEYWIS ('STRING')), the keywords and varia-
C     bles of this command are further read and processed
C
C  4. Argument variables
C
C i   BOTLEV: Bottom levels                                               30.70
C     ROUTDA: Real EQUIVALENCE of OUTDA                                   30.90
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   WATLEV: Water levels                                                30.70
C     XCGRID: Coordinates of computational grid in x-direction            30.72
C     YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    BOTLEV(*)                                                   30.70
      REAL    ROUTDA(*)                                                   30.90
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    WATLEV(*)                                                   30.70
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C  6. Local variables
C
      INTEGER :: IERR = 0                                                 40.02
C
C  8. Subroutines used
C
C     SVARTP
C     SIRAY
C     SNEWUR
C     SADURI
C     SADURR
C     SODAPT
C     SODEXP
C     SODELP
C     SODELR (all SWAN/SWREAD)
C     ODLOC  (SWAN/SER)
C     NWLINE
C     INCSTR
C     ININTG
C     INKEYW
C     INREAL
C     KEYWIS
C     MSGERR
C     COPYCH (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWREAD
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------------
C             Most of the source code will be clear with the
C             aid of the user manual, the system documentation
C             and the additional comments in the source code.
C     ----------------------------------------------------------------
C
C 13. Source text
C
      LOGICAL   FOUND
      INTEGER   OUTDA(*) ,KGRPNT(MXC,MYC)                                 30.21
      CHARACTER PSNAME*16, PNAME*16, RTYPE*4, FROM_, PTYPE *1             30.81
      LOGICAL   KEYWIS
      SAVE IENT
      DATA IENT/0/, FROM_ /'F'/                                           30.81
      CALL STRACE (IENT,'SPROUT')
C
      FOUND = .FALSE.
C
C     definition of output point sets
C
      PNAME = 'PSET'
      CALL DPINQP (OUTDA, PNAME, JOUTPS, PTYPE, IOUTPS, LENREC,
     &             IERR)                                                  30.81
      CALL DPMAXR (OUTDA, JOUTPS, LLR, IOUTPS, IERR)                      30.81
      IF (STPNOW()) RETURN                                                34.01
      CALL SWREPS (FOUND, OUTDA(IOUTPS), ROUTDA(IOUTPS), XCGRID, YCGRID,  30.90
     &             BOTLEV, WATLEV)                                        30.70
      IF (STPNOW()) RETURN                                                34.01
      CALL DPMINR (OUTDA, JOUTPS, LLR, IOUTPS, IERR)                      30.81
      IF (STPNOW()) RETURN                                                34.01
      IF (FOUND) RETURN
C
C     output requests
C
      PNAME = 'REQ'
      CALL DPINQP (OUTDA, PNAME, JOUTOQ, PTYPE, IOUTOQ, LENREC,
     &             IERR)                                                  30.81
      CALL DPMAXR (OUTDA, JOUTOQ, LLR, IOUTOQ, IERR)                      30.81
      IF (STPNOW()) RETURN                                                34.01
      CALL SWREOQ (FOUND         ,OUTDA(IOUTOQ) ,ROUTDA(IOUTOQ) ,         30.90
     &             OUTDA(IOUTPS) ,ROUTDA(IOUTPS),SPCSIG          )        30.90
      IF (STPNOW()) RETURN                                                34.01
      CALL DPMINR (OUTDA, JOUTOQ, LLR, IOUTOQ, IERR)                       30.81
      IF (STPNOW()) RETURN                                                34.01
      IF (FOUND) RETURN
C
C     SIT     site names
C
      IF (KEYWIS('SIT') .OR. KEYWIS('PLA')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,                                                 32.02
     &    ' Illegal keyword (SIT) in combination with 1D-computation')    32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          IERR  = 0                                                       30.81
          PNAME = 'PLA'
          CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, ISPLA,LENREC,
     &                 IERR)                                              30.81
          IERR  = 0                                                       30.81
          CALL DPMAXR (OUTDA, INDX, LLR, ISPLA, IERR)                     30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR  = -1                                                      30.81
          CALL DPINQA (OUTDA(ISPLA), LENARR, LENOCP, NUMPNS, LENPNM,
     &                 LENADT, IERR)                                      30.81
   50     CALL NWLINE
          IF (STPNOW()) RETURN                                            34.01
          CALL INCSTR('PNAME',PNAME,'REP','XXXX')
          IF (PNAME(1:4) .NE. 'XXXX') THEN
*           ****  existing name?  ****
            IF (NUMPNS .GT. 0) THEN
          IERR  = 0                                                       30.81
                JJ = 0
                CALL DPINQP (OUTDA(ISPLA), PNAME, JJ, PTYPE,
     &                 INX, LENREC, IERR)                                 30.81
                IF (JJ.NE.0) THEN
                  WRITE (PRINTF, 53) PNAME
  53              FORMAT (' Name already exists: ', A16)
                  GOTO 50
                ENDIF
            ENDIF
C           ***** new name, add to the list *****
            IERR  = 0                                                     30.81
            IREC = 0
            CALL DPADDP (OUTDA(ISPLA), PNAME, IREC, 'S', INX, IERR)       30.81
            IF (STPNOW()) RETURN                                          34.01
            IERR  = 0                                                     30.81
            CALL DPEXPR (OUTDA(ISPLA), IREC, 4, INX, IERR)                30.81
            IF (STPNOW()) RETURN                                          34.01
            ILOCR  = ISPLA+INX-1
            NUMPNS = NUMPNS + 1
            CALL READXY ('XP', 'YP', ROUTDA(ILOCR+1),                     30.90
     &                         ROUTDA(ILOCR+2), 'REQ', 0., 0.)            30.90
            CALL INREAL ('SIZE', ROUTDA(ILOCR+3),'NSKP',0.28)             30.90
            CALL INKEYW ('REQ', ' ')
            IF (KEYWIS('REG')) THEN
              ISIT = 2
            ELSE
              CALL IGNORE ('TOWN')
              ISIT = 1
            ENDIF
            OUTDA(ILOCR+4) = ISIT
            GOTO 50
          ENDIF
           IERR  = 0                                                      30.81
               CALL DPMINR (OUTDA, INDX, LLR, ISPLA, IERR)                30.81
               IF (STPNOW()) RETURN                                       34.01
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
C
C     LIN   set of (shore)lines
C     MIP   is counter of points on a line
C
      IF (KEYWIS ('LIN')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (LIN) in combination with'//   32.02
     &                   ' 1D-computation')                               32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          IERR  = 0                                                       30.81
          PNAME = 'LIN'
          CALL DPINQP (OUTDA, PNAME, JSLIN, PTYPE, ISLIN, LENREC,
     &                 IERR)                                              30.81
          IERR  = 0                                                       30.81
          CALL DPMAXR (OUTDA, JSLIN, LLR, ISLIN, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          IREC = 0
          IERR  = 0                                                       30.81
          PNAME = '    '
          CALL DPADDP (OUTDA(ISLIN), PNAME, IREC, 'S', INX, IERR)         30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR  = 0                                                       30.81
          CALL DPMAXR (OUTDA(ISLIN), IREC, LLR, INX, IERR)                30.81
          IF (STPNOW()) RETURN                                            34.01
          ILOCR = ISLIN + INX - 1
          MIP  = 0
          OUTDA(ILOCR+1) = MIP
C         ***** type of line (continuous, dashed ...) *****
          CALL INKEYW ('STA', 'CON')
          IF (KEYWIS('DASH')) THEN
            CALL ININTG ('PAT', LINTYP, 'STA', 3)                         10.41
            CALL INREAL ('LEN', PATLEN, 'STA', 1.)
          ELSE
            CALL IGNORE ('CON')
            LINTYP = 10                                                   10.41
            PATLEN = 1.
          ENDIF
          OUTDA(ILOCR+2) = LINTYP
          ROUTDA(ILOCR+3) = PATLEN                                        30.90
          CALL INKEYW ('STA', ' ')
C         ****  color of the line (pen number)  ****                      40.00
          IF (KEYWIS ('COL')) THEN
            CALL ININTG ('IPEN', LINCOL, 'STA', 2)                        40.03
          ELSE
            LINCOL = 1
          ENDIF
          OUTDA(ILOCR+4) = LINCOL
*
*         ***** read coordinates of corner points *****
          DO 410 LOOP1 = 1, 9999
            CALL READXY ('XP', 'YP', XP, YP, 'REP', -1.E10, -1.E10)
            IF (XP.LT.-.9E10) GOTO 420
            MIP = MIP+1
            ROUTDA(ILOCR+2*MIP+3) = XP                                    30.90
            ROUTDA(ILOCR+2*MIP+4) = YP                                    30.90
 410      CONTINUE
*
*         ***** termination, store number of points *****
 420      OUTDA(ILOCR+1) = MIP
          IERR  = 0                                                       30.81
          CALL DPEXPR (OUTDA(ISLIN), IREC, 2*MIP+4, INX, IERR)            30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR  = 0                                                       30.81
          CALL DPMINR (OUTDA, JSLIN, LLR, ISLIN, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          IERR  = 0                                                       30.81
          CALL DPCHEK (OUTDA, IERR)                                       30.81
          IF (MIP.EQ.0) CALL MSGERR(1,'No points of the line found')
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
C
C     LIST    list output data
C
      IF (KEYWIS ('LIST')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (LIST) in combination'//       32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          PNAME = 'PSET'
          CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IOUTPS, LENREC,
     &                  IERR)                                             30.81
          CALL DPINQA (OUTDA(IOUTPS), LENARR, LENOCP, NUMPNS, LENPNM,
     &                 LENADT, IERR)                                      30.81
          WRITE (PRINTF, 455) 'PSET'
 455      FORMAT (1X, A4)
          DO 460 IPNS = 1, NUMPNS
            PSNAME = '    '
            CALL DPINQP (OUTDA(IOUTPS), PSNAME, IPNS, PTYPE, IPSDAT,
     &                   LENREC, IERR)                                    30.81
            WRITE (PRINTF, 458) IPNS, PSNAME, LENREC,
     &                   CHAR(OUTDA(IOUTPS+IPSDAT))
 458        FORMAT (5X, I3, ' name:', A8, ' rec.len:', I4, ' type:', A1)
 460      CONTINUE
          PNAME = 'REQ'
          CALL DPINQP (OUTDA, PNAME, INDX, PTYPE, IOUTRQ,
     &                   LENREC, IERR)                                    30.81
          CALL DPINQA (OUTDA(IOUTRQ), LENARR, LENOCP, NUMPNS, LENPNM,
     &                 LENADT, IERR)                                      30.81
          WRITE (PRINTF, 455) 'REQ'
          DO 470 IPNS = 1, NUMPNS
            PSNAME = '    '
          IERR  = 0                                                       30.81
            CALL DPINQP (OUTDA(IOUTRQ), PSNAME, IPNS, PTYPE, IRQDAT,
     &                 LENREC, IERR)                                      30.81
            CALL COPYCH (RTYPE, FROM_, OUTDA(IOUTRQ+IRQDAT+2), 1, IERR)   30.81
            CALL COPYCH (PSNAME, FROM_, OUTDA(IOUTRQ+IRQDAT+3),2, IERR)   30.81
            WRITE (PRINTF, 468) IPNS, RTYPE, PSNAME, LENREC
 468        FORMAT (5X, I3, ' type:', A4, ' psname:', A8,
     &              ' rec.len:',I4)
 470      CONTINUE
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     -------------------------------------------------------------------
*     ***** command name not found *****
      RETURN
*
 800  FOUND = .TRUE.
      RETURN
* * end of subroutine SPROUT *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWREPS (FOUND, OUTPS, OUTPR, XCGRID, YCGRID,             30.72
     &                   BOTLEV, WATLEV)                                  30.70
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70, 40.03, 40.13: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde (1D version)
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.70, Nov. 97: comm ISO, inquire pointer added to get correct value
C                     for IADRAY
C     30.70, Nov. 97: comm ISO, offset origin added in message concerning rays
C                     declaration INT SIRAY added
C     30.70, Nov. 97: arguments BOTLEV and WATLEV added
C     30.72, Feb. 98: Declaration of Argument variables updated
C     32.02, Feb. 98: 1D version introduced
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Apr. 98: removed reference to commons KAART and KAR
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.01, Sep. 99: XASM and YASM replace fixed numbers
C     33.09, Sep. 00: modifications in view of spherical coordinates
C     40.03, Sep. 00: inconsistency with manual corrected
!     40.13, Sep. 01: nesting in curvilinear grid: division by 0 prevented
C
C  2. PURPOSE
C
C     Reading and processing of the commands defining output points
C
C  4. Argument variables (updated 30.72)
C
C     OUTPS:  output array containing data on output point sets
C
      INTEGER   OUTPS(*)
C
C     BOTLEV: input  bottom levels                                        30.70
C     OUTPR:  output array containing data on output point sets
C                    EQUIV with array OUTPS
C     WATLEV: input  water levels                                         30.70
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL      OUTPR(*),  XCGRID(MXC,MYC),  YCGRID(MXC,MYC)              30.72
      REAL      BOTLEV(*), WATLEV(*)                                      30.70
C
C     FOUND : output  parameter indicating whether command
C                     being processed is found (value True)
C                     or not (False)
C
      LOGICAL   FOUND
C
C     Local variables
 
      REAL       :: YSCALE      ! length scale                            33.09
      REAL, SAVE :: COSYPS = 1. ! cos of latitude (1 in case of Cartesian coordinates)
 
C  8. Subroutines used
C
C     command reading routines and pool management routines
C     (all Ocean Pack)
 
      LOGICAL :: STPNOW                                                   34.01
      LOGICAL :: EQREAL ! if True the two (real) arguments are equal      33.09
 
C  9. Subroutines calling
C
C     SWROUT
C
C 10. Error messages
C
C     ---
C
C 13. Source text
C
      LOGICAL   PP                                                        30.72
      INTEGER   IERR, SIRAY                                               30.81 30.72
      CHARACTER PSNAME*16, STYPE*1, PTYPE *1 ,PRNAME*16                   30.21
      LOGICAL   KEYWIS, BOTDEP                                            30.70
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SWREPS')
*
*     ------------------------------------------------------------------
*     FRAME
      IF (KEYWIS ('FRA')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (FRA) in combination with'//   32.02
     &                   ' 1D-computation')                               32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
*         ver 30.20: names of input variables changed, order of data changed
          CALL INCSTR ('SNAME',PSNAME,'REQ',' ')
          IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
          IERR  = 0                                                       30.81
          IREC = 0
          CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)               30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL DPEXPR (OUTPS, IREC, 10, ILOCR, IERR)                      30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL READXY ('XPFR', 'YPFR', OUTPR(ILOCR+4),                    30.20
     &                 OUTPR(ILOCR+5), 'REQ', 0., 0.)
          CALL INREAL('ALPFR',ALPK,'REQ',0.)                              30.20
          IF (KSPHER.GT.0 .AND. .NOT.EQREAL(ALPK,0.)) CALL MSGERR (2,
     &          '[alpfr] must be 0 with spherical coordinates')           33.09
          CALL INREAL('XLENFR', OUTPR(ILOCR+2),'REQ',0.)                  30.20
          CALL INREAL('YLENFR', OUTPR(ILOCR+3),'REQ',0.)                  30.20
          OUTPR(ILOCR+6) = PI2 * (ALPK/360.-NINT(ALPK/360.))
*           ***** the user gives number of meshes along each side *****
*           ***** program uses the number of points               *****
          CALL ININTG ('MXFR',MXK,'STA',20)                               30.20
          CALL ININTG ('MYFR',MYK,'STA',20)                               30.20
          OUTPS(ILOCR+1) = ICHAR('F')                                     30.21
          XLENFR = OUTPR(ILOCR+2)
          YLENFR = OUTPR(ILOCR+3)
          OUTPS(ILOCR+7) = MXK+1
          OUTPS(ILOCR+8) = MYK+1
          CALL INREAL ('SCALE',YSCALE,'STA',-1.)                          33.09
          IF (PROJ_METHOD.EQ.1) THEN                                      33.09
            COSYPS = COS(DEGRAD*(YOFFS+OUTPR(ILOCR+5)+0.5*YLENFR))        33.09
          ENDIF
          IF (YSCALE .LE. 0.) THEN
            YSCALE = MIN (XASM/(XLENFR*COSYPS), YASM/YLENFR)              33.09
            IF (ITEST .GE. 10 .OR. INTES .GE. 5)
     &      WRITE(PRINTF, 6025) YSCALE
 6025       FORMAT(' Length scale = ',E12.4)
          ENDIF
          OUTPR(ILOCR+ 9) = COSYPS*XLENFR*YSCALE                          33.09
          OUTPR(ILOCR+10) = YLENFR*YSCALE
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*
*     ------------------------------------------------------------------
*     GROUP .. SUBGRID
      IF (KEYWIS('GROUP') .OR. KEYWIS ('SUBG')) THEN                      970221
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (GROUP) in combination'//      32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
*         mod 970221: GROUP is introduced as a new command instead of
*         an option SUBG within the Frame command
          CALL INCSTR ('SNAME',PSNAME,'REQ',' ')
          IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
          IERR  = 0                                                       30.81
          IREC = 0
          CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)               30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL DPEXPR (OUTPS, IREC, 10, ILOCR, IERR)                      30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL INKEYW ('STA', ' ')
          CALL IGNORE ('SUBG')                                            970221
          CALL ININTG ('IX1', IX1, 'REQ', 0)
          CALL ININTG ('IX2', IX2, 'REQ', 0)
          CALL ININTG ('IY1', IY1, 'REQ', 0)
          CALL ININTG ('IY2', IY2, 'REQ', 0)
          IF (     IX1 .LT. 0 .OR. IX2 .GT. MXC-1 .OR. IX1 .GE. IX2
     &       .OR. IY1 .LT. 0 .OR. IY2 .GT. MYC-1 .OR. IY1 .GE. IY2) THEN  17/FEB
            CALL MSGERR (3, 'Check corners of GROUP (SUBGRID) command')
            CALL MSGERR (3, ' .........the values shoul be.........')
            CALL MSGERR (3, 'ix1<ix2  and both between  0 and MXC')
            CALL MSGERR (3, 'iy1<iy2  and both between  0 and MYC')
          ENDIF
          IF (PROJ_METHOD.EQ.1) THEN                                      33.09
            COSYPS = COS(YOFFS+OUTPR(ILOCR+15)+0.5*YLENFR)                33.09
          ENDIF
*
          IF (OPTG .EQ. 3) THEN
*             *** If the comput grid is curvilinear then the next    ***
*             *** quantities are stored : 'H' ,FLOAT(IX2), FLOAT(IY2)***
*             *** FLOAT(IX1) ,FLOAT(IY1) , 0 ,MXK+1 ,MYK+1 ,         ***
*             *** XLENFR*XSCALE ,YLENFR*YSCALE                       ***
*              *** Here frame type H is introduce, means that regular***
*              *** frame is required from a curvilinear compt. grid  ***
            OUTPS(ILOCR+1) = ICHAR('H')                                   30.21
            XMIN =  1.E09
            YMIN =  1.E09
            XMAX = -1.E09
            YMAX = -1.E09
            DO 61 IX = IX1+1 ,IX2+1                                       30.72
              DO 60 IY = IY1+1 ,IY2+1
                IF (XCGRID(IX,IY) .LT. XMIN) XMIN = XCGRID(IX,IY)         30.72
                IF (YCGRID(IX,IY) .LT. YMIN) YMIN = YCGRID(IX,IY)         30.72
                IF (XCGRID(IX,IY) .GT. XMAX) XMAX = XCGRID(IX,IY)         30.72
                IF (YCGRID(IX,IY) .GT. YMAX) YMAX = YCGRID(IX,IY)         30.72
 60           CONTINUE                                                    30.72
 61         CONTINUE                                                      30.72
            XLENFR = XMAX - XMIN
            YLENFR = YMAX - YMIN
            MXK = IX2-IX1
            MYK = IY2-IY1
            OUTPR(ILOCR+2)  = FLOAT(IX2)
            OUTPR(ILOCR+3)  = FLOAT(IY2)
            OUTPR(ILOCR+4)  = FLOAT(IX1)
            OUTPR(ILOCR+5)  = FLOAT(IY1)
            OUTPR(ILOCR+6)  = 0.
            OUTPS(ILOCR+7) = MXK+1
            OUTPS(ILOCR+8) = MYK+1
            YSCALE = MIN (XASM/(XLENFR*COSYPS), YASM/YLENFR)              33.09
            OUTPR(ILOCR+ 9) = XLENFR*YSCALE*COSYPS                        33.09
            OUTPR(ILOCR+10) = YLENFR*YSCALE
          ELSE IF (OPTG .EQ. 1) THEN
            OUTPS(ILOCR+1) = ICHAR('F')                                   30.21
            IF (IX1.NE.IX2) THEN
              OUTPR(ILOCR+2) = (IX2-IX1)*DX
            ELSE
              OUTPR(ILOCR+2) = 0.01
            ENDIF
            IF (IY1.NE.IY2) THEN
              OUTPR(ILOCR+3) = (IY2-IY1)*DY
            ELSE
              OUTPR(ILOCR+3) = 0.01
            ENDIF
            XLENFR = OUTPR(ILOCR+2)
            YLENFR = OUTPR(ILOCR+3)
            OUTPR(ILOCR+4) = XPC + IX1*DX*COSPC - IY1*DY*SINPC
            OUTPR(ILOCR+5) = YPC + IX1*DX*SINPC + IY1*DY*COSPC
            OUTPR(ILOCR+6) = ALPC
            MXK = IX2-IX1
            MYK = IY2-IY1
            OUTPS(ILOCR+7) = MXK+1
            YSCALE = MIN (XASM/(XLENFR*COSYPS), YASM/YLENFR)              33.09
            OUTPR(ILOCR+ 9) = XLENFR*YSCALE*COSYPS                        33.09
            OUTPR(ILOCR+10) = YLENFR*YSCALE
            OUTPS(ILOCR+8) = MYK+1
            IF (ITEST .GE. 20 .OR. INTES .GE. 10)
     &        WRITE (PRINTF, 6020) (OUTPR(ILOCR+II), II=2,6)
 6020       FORMAT (' Subgrid parms.', 6(1X,E12.4))
          ENDIF
          GOTO 800
        ENDIF                                                             32.01
      ENDIF
*     ------------------------------------------------------------------
*     CURVE, MIP is number of point on a curve
      IF (KEYWIS ('CURV')) THEN
        CALL INCSTR('SNAME',PSNAME,'REQ',' ')
        IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
        IERR  = 0                                                         30.81
        IREC = 0
        CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)                 30.81
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMAXR (OUTPS, IREC, LLR2, ILOCR, IERR)                      30.81
        IF (STPNOW()) RETURN                                              34.01
        OUTPS(ILOCR+1) = ICHAR('C')
        MIP  = 0
        OUTPS(ILOCR+2) = MIP
*       ***** first point of a curve *****
   30   CALL NWLINE
        IF (STPNOW()) RETURN                                              34.01
        CALL READXY ('XP1', 'YP1', XP, YP, 'REQ', 0., 0.)
        OUTPR(ILOCR+3) = XP
        OUTPR(ILOCR+4) = YP
        MIP  = 1
*         ***** interval and next corner point *****
   33   CALL ININTG ('INT',INTV,'REP',-1)
        IF (INTV .NE. -1) THEN
          IF (INTV .LE. 0) THEN
             CALL MSGERR (2,'INT is negative or zero')
             INTV = 1
          ENDIF
          XP1 = XP
          YP1 = YP
          CALL READXY ('XP', 'YP', XP, YP, 'REQ', 0., 0.)                 40.03
          IF (ITEST .GE. 200 .OR. INTES .GE. 20) THEN                     30.21
            WRITE(PRINTF, 31) PSNAME
   31       FORMAT ('COORDINATES OF OUTPUT POINTS FOR CURVE  : ', A)
          ENDIF
          DO 36  JJ=1,INTV
            MIP = MIP+1
            OUTPR(ILOCR+2*MIP+1) = XP1+REAL(JJ)*(XP-XP1)/REAL(INTV)
            OUTPR(ILOCR+2*MIP+2) = YP1+REAL(JJ)*(YP-YP1)/REAL(INTV)
            DUMX = OUTPR(ILOCR+2*MIP+1)                                   30.21
            DUMY = OUTPR(ILOCR+2*MIP+2)                                   30.21
            IF (ITEST .GE. 200 .OR. INTES .GE. 50) THEN
              WRITE(PRINTF,32)MIP, DUMX, DUMY                             30.21
   32         FORMAT(' POINT(',I4,')','  (IX,IY) -> ',2F10.2)
            ENDIF
   36     CONTINUE
          GOTO 33
        ENDIF
*           ***** store number of points of the curve *****
        OUTPS(ILOCR+2) = MIP
        IF (MIP .EQ. 0) CALL MSGERR(1,'No output points found')
*       give the data record the proper dimensions
        CALL DPEXPR (OUTPS, IREC, 2*MIP+2, INX, IERR)                     30.81
        IF (STPNOW()) RETURN                                              34.01
        GOTO 800
      ENDIF
*     ------------------------------------------------------------------
*     POINTS     set of individual output points
      IF (KEYWIS ('POIN')) THEN
        CALL INCSTR('SNAME',PSNAME,'REQ',' ')
        IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
        IERR  = 0                                                         30.81
        IREC = 0
        CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)                 30.81
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMAXR (OUTPS, IREC, LLR, ILOCR, IERR)                       30.81
        IF (STPNOW()) RETURN                                              34.01
        OUTPS(ILOCR+1) = ICHAR('P')
        MIP  = 0
        OUTPS(ILOCR+2) = MIP
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('FILE')) THEN
          IOSTAT = 0
          NDS    = 0
          PP     = .TRUE.
          CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
          CALL FOR (NDS, FILENM, 'OF', IOSTAT)                            10.31
          IF (STPNOW()) RETURN                                            34.01
        ELSE
          PP = .FALSE.
        ENDIF
        DO LOOP1 = 1, 9999
          IF (PP) THEN
            IERR = 0                                                      10.18
            CALL REFIXY (NDS, XP, YP, IERR)                               10.18
            IF (IERR.EQ.-1) GOTO 47
            IF (IERR.EQ.-2) THEN
              CALL MSGERR (2, 'Error reading point coord. from file')
              GOTO 800
            ENDIF
          ELSE
            CALL READXY ('XP', 'YP', XP, YP, 'REP', -1.E10, -1.E10)
            IF (XP .LT. -0.9E10) GOTO 47
          ENDIF
          MIP = MIP+1
          OUTPR(ILOCR+2*MIP+1) = XP
          OUTPR(ILOCR+2*MIP+2) = YP
        ENDDO
*       ***** store number of output points *****
  47    OUTPS(ILOCR+2) = MIP
        IF (MIP .EQ. 0) CALL MSGERR (2, 'No output points found')         10.32
*       give the data record the proper dimensions
        CALL DPEXPR (OUTPS, IREC, 2*MIP+2, INX, IERR)                     30.81
        IF (STPNOW()) RETURN                                              34.01
        GOTO 800
      ENDIF
*     -------------------------------------------------------------------
*     RAY   set of rays
      IF (KEYWIS ('RAY'))  THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (RAY) in combination'//        32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          CALL INCSTR('RNAME',PSNAME,'REQ',' ')                           40.03
          IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
          IERR  = 0                                                       30.81
          IREC = 0
          CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)              30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL DPMAXR (OUTPS, IREC, LLR, ILOCR, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          OUTPS(ILOCR+1) = ICHAR('R')
          MIP  = 1
          OUTPS(ILOCR+2) = MIP
*         first ray
          CALL NWLINE
          IF (STPNOW()) RETURN                                            34.01
          CALL READXY ('XP1', 'YP1', XP, YP, 'REQ', 0., 0.)
          CALL READXY ('XQ1', 'YQ1', XQ, YQ, 'REQ', 0., 0.)
          OUTPR(ILOCR+3) = XP
          OUTPR(ILOCR+4) = YP
          OUTPR(ILOCR+5) = XQ
          OUTPR(ILOCR+6) = YQ
*         following rays
  110     CALL ININTG ('INT',INTD,'REP',-1)
          IF (INTD .NE. -1) THEN
            IF (INTD .LE. 0) THEN
              CALL MSGERR(2, 'INT negative or zero')
              INTD = 1
            ENDIF
            XP1 = XP
            YP1 = YP
            XQ1 = XQ
            YQ1 = YQ
            CALL READXY ('XP', 'YP', XP, YP, 'REQ', 0., 0.)
            CALL READXY ('XQ', 'YQ', XQ, YQ, 'REQ', 0., 0.)
            DO 115 JJ=1,INTD
              MIP = MIP+1
              II=ILOCR + 4*MIP + 2
              OUTPR(II-3) = XP1 + REAL(JJ)*(XP-XP1)/REAL(INTD)
              OUTPR(II-2) = YP1 + REAL(JJ)*(YP-YP1)/REAL(INTD)
              OUTPR(II-1) = XQ1 + REAL(JJ)*(XQ-XQ1)/REAL(INTD)
              OUTPR(II)   = YQ1 + REAL(JJ)*(YQ-YQ1)/REAL(INTD)
  115       CONTINUE
            GOTO 110
          ENDIF
*
*         ***** termination *****
          OUTPS(ILOCR+2) = MIP
          IF (MIP .EQ. 1) CALL MSGERR (1,'Only one ray is defined')
*         give the data record the proper dimensions
          CALL DPEXPR (OUTPS, IREC, 4*MIP+2, INX, IERR)                   30.81
          IF (STPNOW()) RETURN                                            34.01
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     -------------------------------------------------------------------
*     ISO     depth or bottom level contour line
      IF (KEYWIS ('ISO')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (ISO) in combination'//        32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          CALL INCSTR ('SNAME',PSNAME,'REQ',' ')
          IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
          CALL INCSTR ('RNAME', PRNAME, 'REQ', ' ')
          IF (LENCST.GT.8) CALL MSGERR (2, 'RNAME is too long')
          CALL INKEYW ('STA', 'DEP')
          IF (KEYWIS ('BOT')) THEN
            BOTDEP = .TRUE.                                               30.70
          ELSE
            CALL IGNORE ('DEP')
            BOTDEP = .FALSE.                                              30.70
            IF (DYNDEP) CALL MSGERR (2,'depths will vary with time')      40.00
          ENDIF
          CALL INREAL ('DEP',DP,'REP',-1.E10)
          CALL DPINQP (OUTPS, PRNAME, IRECR, PTYPE, IADRAY, LENREC,
     &                 IERR)                                              30.81
          IF (IRECR .EQ. 0) THEN
            CALL MSGERR(2,'Set of rays not defined')
            GOTO 800
          ELSE
            STYPE = CHAR(OUTPS(IADRAY+1))
            IF (STYPE .NE. 'R') THEN
              CALL MSGERR
     &          (2,'Ray name set assigned to set of output locations')
              GOTO 800
            ENDIF
          ENDIF
          MIPR = OUTPS(IADRAY+2)
          IERR  = 0                                                       30.81
          IREC = 0
          CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)               30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL DPMAXR (OUTPS, IREC, LLR2, ILOCR, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          OUTPS(ILOCR+1) = ICHAR('C')
          MIP  = 0
          OUTPS(ILOCR+2) = MIP
*         inquire pointer again in view of possible shift in the array    30.70
          CALL DPINQP (OUTPS, PRNAME, IRECR, PTYPE, IADRAY, LENREC,
     &                 IERR)                                              30.81
          DO 125 IK=1,MIPR
             ILOCRS = IADRAY + 4*IK - 2
             XP   = OUTPR(ILOCRS+1)
             YP   = OUTPR(ILOCRS+2)
             XQ   = OUTPR(ILOCRS+3)
             YQ   = OUTPR(ILOCRS+4)
             II   = SIRAY (DP, XP, YP, XQ, YQ, XX, YY, BOTDEP,            30.70
     &                     BOTLEV, WATLEV)                                30.70
             IF (II.EQ.0) THEN
                WRITE (PRINTF, 6120) DP, XP+XOFFS, YP+YOFFS,              30.70
     &                                   XQ+XOFFS, YQ+YOFFS               30.70
 6120           FORMAT(' No point with depth ',F5.2,
     &                 ' is found in ray :',4F10.2)
             ELSE
                MIP = MIP+1
                OUTPR(ILOCR+2*MIP+1) = XX
                OUTPR(ILOCR+2*MIP+2) = YY
             ENDIF
  125     CONTINUE
          IF (MIP.EQ.0) CALL MSGERR
     &               (2, 'No points with valid depth found')
*             ***** store number of points of the curve *****
          OUTPS(ILOCR+2) = MIP
*         give the data record the proper dimensions
          CALL DPEXPR (OUTPS, IREC, 2*MIP+2, INX, IERR)                   30.81
          IF (STPNOW()) RETURN                                            34.01
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     -------------------------------------------------------------------
*     NGRID   computational grid for nesting                              20.63
      IF (KEYWIS ('NGR')) THEN
C
C      ===============================================================
C
C       NGRid  'sname'  [xpn] [ypn] [alpn] [xlenn] [ylenn] [mxn] [myn]    40.00
C
C      ================================================================
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (NGR) in combination'//        32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
*         ver 30.20: names changed, order changed
          CALL INCSTR ('SNAME',PSNAME,'REQ',' ')
          IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
          IERR  = 0                                                       30.81
          IREC = 0
          CALL DPADDP (OUTPS, PSNAME, IREC, 'S', INX, IERR)               30.81
          IF (STPNOW()) RETURN                                            34.01
          CALL DPMAXR (OUTPS, IREC, LLR2, ILOCR, IERR)                    30.81
          IF (STPNOW()) RETURN                                            34.01
          OUTPS(ILOCR+1) = ICHAR('N')
          CALL READXY ('XPN', 'YPN', XPCN, YPCN , 'REQ', 0., 0.)          30.20
          CALL INREAL('ALPN',ALPCN,'REQ',0.)                              30.20
          CALL INREAL('XLENN',XNLEN,'REQ',0.)                             30.20
          CALL INREAL('YLENN',YNLEN,'REQ',0.)                             30.20
          ALTNP = ALPCN / 360.
          ANG = PI2 * (ALTNP - NINT(ALTNP))
*         estimate step size for output                                   40.00
          IF (OPTG.EQ.1) THEN                                             40.13
            COSA2 = (COS(ANG-ALPC))**2                                    40.00
            SINA2 = (SIN(ANG-ALPC))**2                                    40.00
            DXN = DX*COSA2 + DY*SINA2                                     40.00
            DYN = DX*SINA2 + DY*COSA2                                     40.00
          ELSE                                                            40.13
!           curvilinear grid, DXN and DYN are average step size           40.13
            DXN = (XCLEN+YCLEN)/REAL(MXC+MYC)                             40.13
            DYN = DXN                                                     40.13
          ENDIF                                                           40.13
          CALL ININTG ('MXN',MXN,'STA',MAX(1,NINT(XNLEN/DXN)))            40.00
          CALL ININTG ('MYN',MYN,'STA',MAX(1,NINT(YNLEN/DYN)))            40.00
          MIP = 0
          XF=XPCN
          YF=YPCN
*         *****   start to calculate the positions       ********
*         *****  of the boundary point in the four sides ********
          DO 50 I=1,4
            INTE=MXN
            ALON=XNLEN
            ANGLE=ANG+PI2*(90.*REAL(I-1))/360.
            IF (I .EQ. 2 .OR. I .EQ. 4) THEN
              INTE=MYN
              ALON=YNLEN
            ENDIF
            XI=XF
            YI=YF
            XF=XI+ALON*COS(ANGLE)
            YF=YI+ALON*SIN(ANGLE)
            DO 55 KK=1,INTE
              MIP=MIP+1
              OUTPR(ILOCR+2*MIP+1)=XI+REAL(KK)*(XF-XI)/REAL(INTE)
              OUTPR(ILOCR+2*MIP+2)=YI+REAL(KK)*(YF-YI)/REAL(INTE)
   55       CONTINUE
   50     CONTINUE
*             ***** store number of points of the curve *****
          OUTPS(ILOCR+2) = MIP
          OUTPR(ILOCR+2*MIP+3) = XNLEN
          OUTPR(ILOCR+2*MIP+4) = YNLEN
          OUTPS(ILOCR+2*MIP+5) = MXN
          OUTPS(ILOCR+2*MIP+6) = MYN
          OUTPR(ILOCR+2*MIP+7) = XPCN
          OUTPR(ILOCR+2*MIP+8) = YPCN
          OUTPR(ILOCR+2*MIP+9) = PI2 * (ALPCN/360.-NINT(ALPCN/360.))
          IF (MIP .EQ. 0) CALL MSGERR(1,'No output points found')
***     give the data record the proper dimensions
          CALL DPEXPR (OUTPS, IREC, 2*MIP+9, INX, IERR)                   30.81
          IF (STPNOW()) RETURN                                            34.01
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     ---------------------------------------------------------
*     command not found:
      RETURN
 800  FOUND = .TRUE.
      RETURN
**    end of subroutine SWREPS  **
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWREOQ (FOUND    ,OUTOQ    ,OUTOR    ,
     &                   OUTPS    ,OUTPR    ,SPCSIG             )         40.00
*                                                                      *
************************************************************************
C
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'ocpcomm1.inc'                                              30.74
!     ocpcomm2.inc now accessed via USE OUTP_DATA                         40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
!MCEL+ J Dykes 15 Nov 2002 SWREOQ: includes
      include 'MCEL.inc'
      include 'mcel_swan.inc'
!MCEL- J Dykes 15 Nov 2002
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     32.02: Roeland Ris & Cor van der Schelde (1D version)
C     34.01: Jeroen Adema
C     40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     30.50         : option COORD added in command PLOT
C                     option STAR  added in command PLOT
C     32.02, Feb. 98: 1D version introduced
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Apr. 98: removed reference to commons KAART and KAR
C     30.81, Nov. 98: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     30.81, Jan. 99: Replaced variable TO by TO_ (because TO is a reserved
C                     word)
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Nov. 99: in case SPEC2D the value of MXOUTAR is increased by
C                     6*MIP
C     40.03, Mar. 00: NQUA increased in case of Isoline plot
C            Sep. 00: inconsistency with manual corrected
C     40.13, Mar. 01: option BLOCKed added in plot of problem points
!            Aug. 01: array for NESTOUT request extended to 20 (in view of SETUP)
!     40.13, Oct. 01: filenames are stored in array OUTP_FILES
!                     not any more in array containing output request parameters
C
C  2. Purpose
C
C     Reading and processing of the output requests
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: input  Relative frequencies in computational domain in      30.72
C                    sigma-space                                          30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     FOUND : output parameter indicating whether command
C                    being processed is found (value True)
C                    or not (False)
C
      LOGICAL FOUND                                                       30.72
C
C  8. Subroutines used
C
C     command reading routines and pool management routines
C     (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SPROUT
C
C 10. Error messages
C
C       ---
C
C 13. Source text
C
      INTEGER   OUTOQ(*), OUTPS(*),
     &          IERR                                                      30.81
      REAL      OUTOR(*), OUTPR(*)                                        40.00
      CHARACTER PSNAME *16, PTI *36, STYPE *1, RTYPE *4, PNAME *8,
     &          PTYPE *1, TO_                                             30.81
      LOGICAL   KEYWIS, PLISO
      SAVE IENT
      DATA IENT/0/, TO_/'T'/                                               30.81
      CALL STRACE (IENT,'SWREOQ')
*
*     -------------------------------------------------------------------
*     BLO   block type output
      IF (KEYWIS ('BLO')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (BLO) in combination'//        32.02
     &                   ' with 1D-computation')                          32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          CALL SWNMPS (OUTPS, PSNAME, STYPE, MIP, IERR)
          IF (IERR.NE.0) GOTO 800
          IF (STYPE .NE. 'F' .AND. STYPE .NE. 'H') THEN                   30.21
            CALL MSGERR(2,'Set of output locations is not type frame')
            GOTO 800
          ENDIF
*
*         output frame exists
*
          IREC = 0
          IERR  = 0                                                       30.81
          PNAME = '    '
          CALL DPADDP (OUTOQ, PNAME, IREC, 'S', INX, IERR)                30.81
          IF (STPNOW()) RETURN                                            34.01
          IF (IREC .GT. MAX_OUTP_REQ) CALL MSGERR (2,                     40.13
     &    'too many output requests')                                     40.13
          IERR  = 0                                                       30.81
          CALL DPMAXR (OUTOQ, IREC, LLR, INX, IERR)                           30.81
          IF (STPNOW()) RETURN                                            34.01
 
          IDLAO = 1
*
          CALL INKEYW ('REQ',' ')
          IF (KEYWIS('NOHEAD') .OR. KEYWIS ('FIL')) THEN                  30.20
            CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
            DFAC = 1.
            CALL INKEYW ('STA', ' ')
            IF (KEYWIS('LONG')) THEN
!             option disabled                                             40.13
              CALL MSGERR (2, 'option LONG disabled; use OUTP OPT')       40.13
            ENDIF                                                         40.13
            RTYPE = 'BLKD'
          ELSE
            CALL IGNORE ('HEAD')                                          30.20
            CALL IGNORE ('PAP')
            DFAC = -1.
            CALL INCSTR ('FNAME', FILENM, 'STA', ' ')                     30.20
            RTYPE = 'BLKP'
          END IF
          IF (FILENM .EQ. ' ') THEN                                       24/FEB
            NREF = PRINTF
          ELSE
            NREF = 0
          ENDIF
          CALL INKEYW ('STA', ' ')
          IF (KEYWIS('LAY')) THEN
            CALL ININTG ('IDLA', IDLAO, 'REQ', 0)
            CALL INKEYW ('REQ', ' ')
            IF (IDLAO.NE.1 .AND. IDLAO.NE.3 .AND. IDLAO.NE.4)
     &        CALL MSGERR (2, 'Illegal value for IDLA')
          ENDIF
          OUTOR(INX+1) = -1.                                              30.00
          OUTOR(INX+2) = -1.                                              30.00
          IERR = 0
          CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                 30.81 30.00
          CALL COPYCH (PSNAME, TO_, OUTOQ(INX+4), 2, IERR)                30.81 30.00
          OUTOQ(INX+6) = NREF                                             30.00
          OUTOQ(INX+7) = IREC                                             40.13
          OUTP_FILES(IREC) = FILENM                                       40.13
          OUTOQ(INX+17) = IDLAO                                           30.00
          NVAR = 0
          OUTOQ(INX+18) = NVAR                                            30.00
          NQUA = 8                                                        40.00
*
*         read types of output quantities
*
  70      CALL SVARTP (IVTYPE)
          IF (IVTYPE .EQ. 98) GOTO 91                                     30.00
          IF (IVTYPE .NE. 99) THEN
             CALL INREAL ('UNIT', DFAC, 'STA', -1.)
             IF (OVSVTY(IVTYPE).EQ.5) THEN
               CALL MSGERR (2,
     &         'Type of output not allowed for this quantity')
               WRITE (PRINTF, *) ' -> ', OVSNAM(IVTYPE)
             ELSE IF (IVTYPE .GT. 0) THEN
                NVAR = NVAR+1
                OUTOQ(INX+2*NVAR+17) = IVTYPE                             30.00
                OUTOR(INX+2*NVAR+18) = DFAC                               30.00
                IF (IVTYPE.EQ.6) IUBOTR = 1
                IF (OVSVTY(IVTYPE).EQ.3) THEN
                  NQUA = NQUA + 2
                ELSE
                  NQUA = NQUA + 1
                ENDIF
             ENDIF
!MCEL+ J Dykes 15 Nov 2002 SWREOQ: adding variables
          if (FILENM .eq. 'MCEL' .and. IREG_MC .eq. 1) then
             if (OVSVTY(IVTYPE) .lt. 3) then
                call addvar (id_program, OVSNAM(IVTYPE),
     &             MCEL_DATATYPE_REAL, ierr)
             else
                call addvar (id_program, 'U'//OVSNAM(IVTYPE),
     &             MCEL_DATATYPE_REAL, ierr)
                call addvar (id_program, 'V'//OVSNAM(IVTYPE),
     &             MCEL_DATATYPE_REAL, ierr)
             end if
             mcel_put_tag(IVTYPE) = 1
             if (ierr.eq.0) then
                print *, 'swreoq: new variable added:', OVSNAM(IVTYPE)
             else
                print *, 'swreoq: error adding new variable'
             end if
          end if
!MCEL-
             GOTO 70
          ENDIF
*
 91       IF (IVTYPE .EQ. 98) THEN                                        30.00
            IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
            NSTATM = 1
            CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)         30.00
            CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                 30.00
          ENDIF
*
          OUTOQ(INX+18) = NVAR                                            30.00
          CALL DPEXPR (OUTOQ, IREC, 2*NVAR+18, INX, IERR)                 30.81 30.00
          IF (STPNOW()) RETURN                                            34.01
          MXOUTAR = MAX (MXOUTAR, MIP*NQUA+MSC*MDC+5*MSC+3*MDC)           40.00
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     -------------------------------------------------------------------
*     TABLE   output in the form of a table
      IF (KEYWIS ('TAB')) THEN
        CALL SWNMPS (OUTPS, PSNAME, STYPE, MIP, IERR)
        IF (IERR.NE.0) GOTO 800
*
*       output points exist
*
        IREC = 0
        PNAME = '    '
        CALL DPADDP (OUTOQ, PNAME, IREC, 'S', INX, IERR)                  30.81
        IF (STPNOW()) RETURN                                              34.01
        IF (IREC .GT. MAX_OUTP_REQ) CALL MSGERR (2,                       40.13
     &    'too many output requests')                                     40.13
        CALL DPMAXR (OUTOQ, IREC, LLR, INX, IERR)                         30.81
        IF (STPNOW()) RETURN                                              34.01
*
        CALL INKEYW ('STA','HEAD')                                        20.67
        IF (KEYWIS('NOHEAD') .OR. KEYWIS ('FIL')) THEN                    20.67
          RTYPE = 'TABD'
        ELSE IF (KEYWIS ('IND')) THEN                                     30.50
          RTYPE = 'TABI'
        ELSE IF (KEYWIS ('SWAN')) THEN                                    40.00
          RTYPE = 'TABS'
        ELSE IF (KEYWIS ('STAB')) THEN                                    40.00
          RTYPE = 'TABT'
        ELSE
          CALL IGNORE ('HEAD')                                            20.67
          CALL IGNORE ('PAP')
          RTYPE = 'TABP'
        END IF
        OUTOR(INX+1) = -1.                                                30.00
        OUTOR(INX+2) = -1.                                                30.00
        IERR = 0
        CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                   30.81 30.00
*       unit reference number NREF is 0, will be determined in output module
        CALL INCSTR ('FNAME', FILENM, 'STA', ' ')
        IF (FILENM .NE. '    ') THEN
          NREF = 0
        ELSE
          NREF = PRINTF
        ENDIF
        IERR = -1
        CALL COPYCH (PSNAME, TO_, OUTOQ(INX+4), 2, IERR)                  30.81 30.00
*       store filename in array
        OUTOQ(INX+6) = NREF                                               30.00
        OUTOQ(INX+7) = IREC                                               40.13
        OUTP_FILES(IREC) = FILENM                                         40.13
*
        NVAR = 0
        OUTOQ(INX+17) = NVAR                                              30.00
        NQUA = 8                                                          40.00
*       read types of variables to be printed in the table
   80   CALL SVARTP (IVTYPE)
        IF (IVTYPE .EQ. 98) GOTO 90                                       30.00
        IF (IVTYPE .NE. 99) THEN
          IF (OVSVTY(IVTYPE).EQ.5) THEN
            CALL MSGERR (2,
     &      'Type of output not allowed for this quantity')
            WRITE (PRINTF, *) ' -> ', OVSNAM(IVTYPE)
          ELSE IF (IVTYPE .GT. 0) THEN
            NVAR = NVAR+1
            OUTOQ(INX+17+NVAR) = IVTYPE                                   30.00
            IF (IVTYPE.EQ.18) IUBOTR = 1
            IF (OVSVTY(IVTYPE).EQ.3) THEN
              NQUA = NQUA + 2
            ELSE
              NQUA = NQUA + 1
            ENDIF
            CALL INKEYW ('STA', ' ')                                      40.00
            IF (KEYWIS('UNIT')) THEN
              CALL MSGERR (1, 'UNIT is ignored in this version')          40.00
            ENDIF
          ENDIF
          GOTO 80
        ENDIF
 90     IF (IVTYPE .EQ. 98) THEN                                          30.00
          IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
          NSTATM = 1
          CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)           30.00
          CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                   30.00
        ENDIF
        OUTOQ(INX+17) = NVAR                                              30.00
        CALL DPEXPR (OUTOQ, IREC, NVAR+17, INX, IERR)                   30.81 30.00
        IF (STPNOW()) RETURN                                              34.01
        MXOUTAR = MAX (MXOUTAR, MIP*NQUA+MSC*MDC+5*MSC+3*MDC)             40.00
        GOTO 800
      ENDIF
*     -------------------------------------------------------------------
*     PLOT    plot iso lines and/or vector fields
      IF (KEYWIS ('PLO')) THEN
        CALL SWNMPS (OUTPS, PSNAME, STYPE, MIP, IERR)
        IF (IERR.NE.0) GOTO 800
*
*       output frame exists
*
        IREC = 0
        PNAME = '    '
        CALL DPADDP (OUTOQ, PNAME, IREC, 'S', INX, IERR)                      30.81
        IF (STPNOW()) RETURN                                              34.01
        IF (IREC .GT. MAX_OUTP_REQ) CALL MSGERR (2,                       40.13
     &    'too many output requests')                                     40.13
        CALL DPMAXR (OUTOQ, IREC, LLR, INX, IERR)                             30.81
        IF (STPNOW()) RETURN                                              34.01
        OUTOR(INX+1) = -1.                                                30.00
        OUTOR(INX+2) = -1.                                                30.00
*
        RTYPE = 'PLOT'
        IERR = -1
        CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                   30.81 30.00
        CALL COPYCH (PSNAME, TO_, OUTOQ(INX+4), 2, IERR)                  30.81 30.00
*
*       make IUPLF 0 (=file unit number), will be determined in
*                       OCPIDS.FTN (OCEANPACK)
        OUTOQ(INX+6) = 0                                                  30.00
*       ***** read plot filename *****
        CALL INKEYW ('STA','  ')
        FILENM = '    '
        IF (KEYWIS('FI')) CALL INCSTR ('FNAME', FILENM, 'STA','    ')
        IF (FILENM(1:4) .EQ. '    ') THEN
          FILENM(1:3) = 'PLF'
          FILENM(4:7) = PROJNR
        ENDIF
        IF (ITEST.GE.100 .OR. INTES .GE. 20) THEN
          WRITE (PRINTF,6050) FILENM
 6050     FORMAT (' File: ',A36)
        ENDIF
        IERR = 0
        OUTOQ(INX+7) = IREC                                               40.13
        OUTP_FILES(IREC) = FILENM                                         40.13
*       Make NVAR=1 (only one output variable can be shown)
        NVAR=1
        OUTOQ(INX+17) = NVAR                                              30.00
*       ***** read plot title *****
        CALL INCSTR ('TITLE', PTI, 'STA', BLANK)
        IERR = -1
        CALL COPYCH (PTI, TO_, OUTOQ(INX+18), 10, IERR)                   30.81 30.00
*
        CALL INKEYW ('REQ',' ')
        IF (KEYWIS ('PROB')) THEN
*
*         points with numerical problems
*
          RTYPE = 'PLPR'
          IERR = -1
          CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                 30.81 30.00
*
          IF (STYPE .NE. 'F'
     &                                           ) CALL MSGERR            30.21
     &       (2, 'Set of output locations is not of type Frame')
          CALL INKEYW ('STA',' ')
          ICD = 0
          IF (KEYWIS('FROUD')) ICD = 1
          IF (KEYWIS('PCONV')) ICD = 2
          IF (KEYWIS('BLOCK')) ICD = 3                                    40.13
          OUTOQ(INX+28) = ICD                                             30.00
          CALL INREAL ('SYMSIZ', SYMSZ, 'STA', 0.18)
          OUTOR(INX+29) = SYMSZ                                           30.00
!         problem points will be written to file ERRPTS                   40.13
!         open file ERRPTS only of not yet opened                         40.13
          IF (ERRPTS.EQ.0) THEN                                           40.13
            ERRPTS = 16
            OPEN (ERRPTS, FILE='ERRPTS',
     &            STATUS='UNKNOWN', FORM='FORMATTED')
          ENDIF                                                           40.13
*         ***** plot names of places *****
          IF (KEYWIS ('SIT') .OR. KEYWIS ('PLA')) THEN
            CALL ININTG ('IPEN', IPEN, 'STA', 1)                          40.03
            CALL INKEYW ('STA',' ')
          ELSE
            IPEN = 0
          ENDIF
          OUTOQ(INX+30) = IPEN                                            30.00
*         ***** plot lines *****
          IF (KEYWIS ('LIN')) THEN
            CALL ININTG ('IPEN', IPEN, 'STA', 1)                          40.03
            CALL INKEYW ('STA',' ')
          ELSE
            IPEN = 0
          ENDIF
          OUTOQ(INX+31) = IPEN                                            30.00
*         ***** plot output locations *****
          IF (KEYWIS ('LOC')) THEN
            CALL INCSTR ('SNAME', PSNAME, 'STA', ' ')
            CALL ININTG ('IPEN', IPEN, 'STA', 1)                          40.03
          ELSE
            IPEN = 0
            PSNAME = '    '
          ENDIF
          OUTOQ(INX+32) = IPEN                                            30.00
          IERR = 0
          CALL COPYCH (PSNAME, TO_, OUTOQ(INX+33), 2, IERR)               30.81 30.00
          LENREC = 34                                                     30.00
*
           CALL INKEYW ('STA', '  ')
           IF (KEYWIS ('OUT')) THEN                                       40.03
             IF (NSTATM.EQ.0) CALL MSGERR (3,
     &       'time information not allowed in stationary mode')
             NSTATM = 1
             CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)        30.00
             CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                30.00
             IF (NSTATM.EQ.0) CALL MSGERR (2,
     &                  'time input not allowed in stationary mode')
           ENDIF
*
        ELSE IF (KEYWIS ('SPEC')) THEN
*
*       *** polar plot ***
*
           RTYPE = 'PLSP'
           IERR = -1
           CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                30.81 30.00
           CALL INKEYW ('STA', ' ')                                       20.26
           IF (KEYWIS('NONORM')) THEN                                     20.67
             NORMS2 = 0                                                   10.11
           ELSE
             CALL IGNORE ('NORM')                                         20.41
             NORMS2 = 2                                                   10.11
           ENDIF
           NHTS = 0
           DO 490 LOOP1 = 1, 999
              CALL INREAL ('CH', CH, 'STA', -1.)
              IF (CH.GT.0.) THEN
                NHTS  = LOOP1
                OUTOR(INX+32+LOOP1) = CH                                  30.00
              ELSE
                GOTO 491
              ENDIF
 490       CONTINUE
 491       IF (NHTS.EQ.0) THEN                                            10.11
             NHTS = 3
             OUTOR(INX+33) = 0.02                                         30.00
             OUTOR(INX+34) = 0.1                                          30.00
             OUTOR(INX+35) = 0.5                                          30.00
           ENDIF
           OUTOQ(INX+32) = NHTS                                           30.00
           CALL INKEYW ('STA', ' ')
           F0     = SPCSIG(1)                                             30.72
           FRMID  = -1.
           FRNORM = 0.5 * SPCSIG(MSC)                                     30.72
           IF (KEYWIS('FR')) THEN
              CALL INKEYW ('STA', ' ')
              IF (KEYWIS('NOR')) THEN                                     20.41
                NORMS2 = NORMS2 + 1
              ELSE
                CALL IGNORE ('ABS')
                CALL INREAL ('FMAX', FRNORM, 'STA',
     &                           0.5 * SPCSIG(MSC) / PI2)                 30.72
                FRNORM = PI2 * FRNORM                                     20.25
                CALL INREAL ('FMID', FRMID , 'STA', -1.)
                IF (FRMID.GT.0.) FRMID = PI2 * FRMID                      20.25
              ENDIF
           ENDIF
           CALL INKEYW ('STA', 'ABS')
           IF (KEYWIS('REL')) THEN                                        20.41
             RTYPE = 'PLSR'                                               20.41
             IERR = -1
             CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)              30.81 30.00
           ELSE
             CALL IGNORE ('ABS')                                          20.41
           ENDIF
           OUTOQ(INX+28) = NORMS2                                         30.00
           OUTOR(INX+29) = F0                                             30.00
           OUTOR(INX+30) = FRMID                                          30.00
           OUTOR(INX+31) = FRNORM                                         30.00
           LENREC = 32+NHTS                                               30.00
           CALL INKEYW ('STA', '  ')
           IF (KEYWIS ('OUT')) THEN                                       40.03
             IF (NSTATM.EQ.0) CALL MSGERR (3,
     &       'time information not allowed in stationary mode')
             NSTATM = 1
             CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)        30.00
             CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                30.00
             IF (NSTATM.EQ.0) CALL MSGERR (2,
     &                  'time input not allowed in stationary mode')
           ENDIF
           NQUA = 10
*
        ELSE
*
*         Isoline and/or vector plot
*
          IF (ONED) THEN
            CALL MSGERR (2,' Illegal keyword (PLO ... VEC or'//           32.02
     &                     ' PLO ... ISO) in combination'//               32.02
     &                     ' with 1D-computation')                        32.02
            GOTO 800                                                      32.02
          ELSE                                                            32.02
            IF (STYPE .NE. 'F'
     &                                             ) THEN                 30.21
              CALL MSGERR
     &        (2, 'Set of output locations is not of type Frame')
            ENDIF
*
*           option COORD                                        new   ver 30.50
*
            CALL INKEYW ('STA', ' ')
            IF (KEYWIS('COORD')) THEN
*             provide margin to plot coordinate values
              CALL INREAL ('MARG', PMARG, 'STA', 1.5)
              ICOORD = 1
*             check direction of frame; is provided by SWNMPS
              IF (ABS(ALPQ).GT.0.01) THEN
                CALL MSGERR (2,
     &                'direction of frame not 0, COORD not allowed')
                ICOORD = 0
                PMARG  = 0.
              ENDIF
            ELSE
              ICOORD = 0
              PMARG  = 0.
            ENDIF
            OUTOQ(INX+32) = ICOORD                                        30.50
            OUTOR(INX+33) = PMARG                                         30.50
*
            NQUA = 8                                                      40.00
            IF (KEYWIS ('ISO')) THEN
*             ***** read type of variable and iso plot parameters *****
              PLISO = .TRUE.
              CALL INKEYW ('REQ',' ')
              CALL SVARTP (IVTYPE)
              IF (IVTYPE.EQ.0 .OR. IVTYPE.GE.98) THEN
                CALL MSGERR (2, 'no quantity given')                      40.03
                GOTO 800
              ENDIF
              IF (OVSVTY(IVTYPE).GT.2) THEN
                CALL MSGERR (2,
     &            'Isoline plot not allowed for this quantity')
                GOTO 800
              ENDIF
              OUTOQ(INX+28) = IVTYPE                                      30.00
              IF (IVTYPE.EQ.18) IUBOTR = 1
              CALL INREAL ('STEP', FSTEP, 'STA', -1.)
              OUTOR(INX+29) = FSTEP                                       30.00
              IF (FSTEP.LE.0.) THEN
                CALL INREAL('MIN',FMIN,'STA',1.1E10)
                CALL INREAL('MAX',FMAX,'STA',1.1E10)
              ELSE
                CALL INREAL('MIN',FMIN,'STA',OVLEXP(IVTYPE))
                CALL INREAL('MAX',FMAX,'STA',
     &                    MAX(OVHEXP(IVTYPE),FMIN+10.*FSTEP))             40.00
              ENDIF
              OUTOR(INX+30) = FMIN                                        30.00
              OUTOR(INX+31) = FMAX                                        30.00
              CALL INKEYW ('STA',' ')
              NQUA = 9                                                    40.03
            ELSE
              PLISO = .FALSE.
            ENDIF
*
*           ***** read type of variable for vector plot *****
            IF (KEYWIS ('VEC')) THEN
*
              OUTOQ(INX+34) = 1                                           30.50
              CALL INKEYW ('REQ',' ')
              CALL SVARTP (IVTYPE)
              IF (IVTYPE.EQ.0 .OR. IVTYPE.GE.98) THEN
                CALL MSGERR (2, 'no vector quantity given')               40.03
                GOTO 800
              ENDIF
              IF (OVSVTY(IVTYPE).LE.1 .OR. OVSVTY(IVTYPE).GT.3) THEN      40.03
                CALL MSGERR (2,
     &            'Vector plot not allowed for this quantity')
                GOTO 800
              ENDIF
              OUTOQ(INX+35) = IVTYPE                                      30.50
*
              CALL INREAL ('SCALE',VSC,'STA',-1.)
              OUTOR(INX+36) = VSC                                         30.00
              IF (PLISO) THEN
                IDIST = 5
              ELSE
                IDIST = 1
              ENDIF
              CALL ININTG ('DIST', IDIST, 'UNC', 0)
              OUTOQ(INX+37) = IDIST                                       30.00
              CALL INKEYW ('STA',' ')
              NQUA = NQUA + 3
            ELSE IF (KEYWIS ('STAR')) THEN
*
              RTYPE = 'PLOS'
              IERR = -1
              CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)             30.81 30.50
              OUTOQ(INX+34) = 2                                           30.50
              IVTYPE = 19
              OUTOQ(INX+35) = IVTYPE                                      30.50
*
              CALL INREAL ('SCALE',VSC,'STA',-1.)
              OUTOR(INX+36) = VSC                                         30.50
              IF (PLISO) THEN
                IDIST = 5
              ELSE
                IDIST = 1
              ENDIF
              CALL ININTG ('DIST', IDIST, 'UNC', 0)
              OUTOQ(INX+37) = IDIST                                       30.51
              CALL ININTG ('BUNDLE', IBUND, 'STA', 1)
              OUTOQ(INX+38) = IBUND                                       30.51
              CALL ININTG ('IFREQ', IFR, 'STA', 0)
              OUTOQ(INX+39) = IFR                                         30.51
              CALL INKEYW ('STA',' ')
              NQUA = NQUA + 2*MDC/IBUND
            ELSE
              OUTOQ(INX+34) = 0
            ENDIF                                                         32.02
          ENDIF
*------------------ CURVILINEAR VERSION  30.21   --------------------
*       *** Code to read the command PLOTCGRID ***
*       *** In OUTOQ(INX+40) = 1 (0) :If plot is (not) required ***
*       ***    OUTOQ(INX+45) = IPEN                             ***
*       *** IF (OPTG = 1)                                       ***
*       *** In OUTOR(INX+41) = XLENK ; (INX+42) = YLENK         ***
*       *** In OUTOR(INX+43) = XPK   ; (INX+44) = YPK           ***
*       *** IF (OPTG = 3)                                       ***
*       *** In OUTOR(INX+41) = XMAX  ; (INX+42) = YMAX          ***
*       *** In OUTOR(INX+43) = XMIN  ; (INX+44) = YMIN          ***
*
          CALL INKEYW ('STA', ' ')                                        40.00
          IF (KEYWIS ('CMESH')) THEN
C
            IF (ONED) THEN                                                32.02
              CALL MSGERR (2,' Illegal keyword (PLO ... CMESH) in'//      32.02
     &                       ' combination with 1D-computation')          32.02
              GOTO 800                                                    32.02
            ELSE                                                          32.02
              IF(STYPE .EQ. 'F') OUTOQ(INX+40) = 1                        30.21
              IF(STYPE .EQ. 'H') OUTOQ(INX+40) = 3                        30.21
              CALL DPINQP (OUTPS, PSNAME, IRECPS, PTYPE, IADRES,          19/mar
     &                     LENREC, IERR)                                  30.50
              OUTOR(INX+41) = OCREAL(OUTPS(IADRES+2))
              OUTOR(INX+42) = OCREAL(OUTPS(IADRES+3))
              OUTOR(INX+43) = OCREAL(OUTPS(IADRES+4))
              OUTOR(INX+44) = OCREAL(OUTPS(IADRES+5))
              CALL ININTG ('IPEN', IPEN, 'STA', 1)                        40.03
              OUTOQ(INX+45) = IPEN                                        30.21
              CALL INKEYW ('STA',' ')
            ENDIF                                                         32.02
          ELSE
            OUTOQ(INX+40) = 0
          ENDIF
*         ***** plot names of places *****
          IF (KEYWIS ('SIT') .OR. KEYWIS ('PLA')) THEN
C
            IF (ONED) THEN                                                32.02
              CALL MSGERR (2,' Illegal keyword (PLO ... SIT) in'//        32.02
     &                       ' combination with 1D-computation')          32.02
              GOTO 800                                                    32.02
            ELSE                                                          32.02
              CALL ININTG ('IPEN', IPEN, 'STA', 1)                        40.03
              CALL INKEYW ('STA',' ')
            ENDIF                                                         32.02
          ELSE
            IPEN = 0
          ENDIF
          OUTOQ(INX+46) = IPEN                                            30.00
*         ***** plot lines *****
          IF (KEYWIS ('LIN')) THEN
C
            IF (ONED) THEN                                                32.02
              CALL MSGERR (2,' Illegal keyword (PLO ... LIN) in'//        32.02
     &                       ' combination with 1D-computation')          32.02
              GOTO 800                                                    32.02
            ELSE                                                          32.02
              CALL ININTG ('IPEN', IPEN, 'STA', 1)                        40.03
              CALL INKEYW ('STA',' ')
            ENDIF                                                         32.02
          ELSE
            IPEN = 0
          ENDIF
          OUTOQ(INX+47) = IPEN                                            30.00
*         ***** plot output locations *****
          IF (KEYWIS ('LOC')) THEN
C
            IF (ONED) THEN                                                32.02
              CALL MSGERR (2,' Illegal keyword (PLO ... LOC) in'//        32.02
     &                       ' combination with 1D-computation')          32.02
              GOTO 800                                                    32.02
            ELSE                                                          32.02
              CALL INCSTR ('SNAME', PSNAME, 'STA', ' ')
              CALL ININTG ('IPEN', IPEN, 'STA', 1)                        40.03
            ENDIF                                                         32.02
          ELSE
            IPEN = 0
            PSNAME = '    '
          ENDIF
          OUTOQ(INX+48) = IPEN                                            30.00
          IERR = 0
          CALL COPYCH (PSNAME, TO_, OUTOQ(INX+49), 2, IERR)               30.81 30.00
*
          CALL INKEYW ('STA', '  ')
          IF (KEYWIS ('OUT')) THEN                                        40.03
C
            IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
            NSTATM = 1
            CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)         30.00
            CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                 30.00
            IF (NSTATM.EQ.0) CALL MSGERR (2,
     &                  'time input not allowed in stationary mode')
          ENDIF
*
          LENREC = 50                                                     30.50
        ENDIF
        if (itest.ge.80) write (prtest, *) ' expand rec ', irec, lenrec
        CALL DPEXPR (OUTOQ, IREC, LENREC, INX, IERR)                      30.81
        IF (STPNOW()) RETURN                                              34.01
        MXOUTAR = MAX (MXOUTAR, MIP*NQUA+3*MSC*MDC+5*MSC+3*MDC)           40.00
        GOTO 800
      ENDIF
*     -------------------------------------------------------------------
*     SPEC   output of spectra
      IF (KEYWIS ('SPEC')) THEN
        CALL SWNMPS (OUTPS, PSNAME, STYPE, MIP, IERR)
        IF (IERR.NE.0) GOTO 800
*
*       output points exist
*
        IREC = 0
        PNAME = '    '
        CALL DPADDP (OUTOQ, PNAME, IREC, 'S', INX, IERR)                  30.81
        IF (STPNOW()) RETURN                                              34.01
        IF (IREC .GT. MAX_OUTP_REQ) CALL MSGERR (2,                       40.13
     &    'too many output requests')                                     40.13
        CALL DPEXPR (OUTOQ, IREC, 18, INX, IERR)                          30.81 30.00
        IF (STPNOW()) RETURN                                              34.01
*
        CALL INKEYW ('STA', 'SPEC2D')                                     20.67
        IF (KEYWIS ('FS1D') .OR. KEYWIS('SPEC1D')) THEN                   20.67
          RTYPE  = 'SPE1'                                                 20.28
          IVTYPE = 29                                                     20.28
          MXOUTAR = MAX (MXOUTAR, 2*MIP*MSC+MSC*MDC+5*MSC+3*MDC)          40.00
        ELSE
          CALL IGNORE ('SFD')                                             20.28
          CALL IGNORE ('SPEC2D')                                          20.67
          RTYPE  = 'SPEC'
          IVTYPE = 21
          MXOUTAR = MAX (MXOUTAR, 6*MIP+2*MSC*MDC+5*MSC+3*MDC)            40.03
        ENDIF
        CALL INKEYW ('STA', 'ABS')                                        40.03
        IF (KEYWIS ('REL')) THEN                                          40.03
          RTYPE(3:3)  = 'R'                                               20.28
        ELSE
          CALL IGNORE ('ABS')                                             40.03
        ENDIF
        OUTOR(INX+1) = -1.                                                30.00
        OUTOR(INX+2) = -1.                                                30.00
        IERR = -1
        CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                   30.81 30.00
        CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
        NREF = 0
        IERR = -1
        CALL COPYCH (PSNAME, TO_, OUTOQ(INX+4), 2, IERR)                  30.81 30.00
*       store filename in array
        OUTOQ(INX+6) = NREF                                               30.00
        OUTOQ(INX+7) = IREC                                               40.13
        OUTP_FILES(IREC) = FILENM                                         40.13
*
        NVAR = 1
        OUTOQ(INX+17) = NVAR                                              30.00
*       read types of variables to be printed in the table
        OUTOQ(INX+18) = IVTYPE                                            30.00
        CALL INKEYW ('STA', ' ')                                          30.00
        IF (KEYWIS ('OUT')) THEN                                          40.03
          IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
          NSTATM = 1
          CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)           30.00
          CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                   30.00
          IF (NSTATM.EQ.0) CALL MSGERR (2,
     &                  'time input not allowed in stationary mode')
        ENDIF
        GOTO 800
      END IF
*     -------------------------------------------------------------------
*     NEST   output for nesting of models                      VER.       20.63
      IF (KEYWIS ('NEST')) THEN                                           40.00
C
C      ======================================================================
C
C       NESTout  'sname'  'fname'  (SETup 'fname')            &
C
C                                              | -> Sec  |
C                OUTput  [tbegnst]  [deltnst] <     MIn   >
C                                              |    HR   |
C                                              |    DAy  |
C
C      =======================================================================
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (2,' Illegal keyword (NEST) in'//                   32.02
     &                   ' combination with 1D-computation')              32.02
          GOTO 800                                                        32.02
        ELSE                                                              32.02
          CALL SWNMPS (OUTPS, PSNAME, STYPE, MIP, IERR)
          IF (IERR.NE.0) GOTO 800
          IF (STYPE .NE. 'N') THEN
            CALL MSGERR(2,'Set of output locations is not correct type')
            GOTO 800
          ENDIF
*         output points exist
          IREC = 0
          PNAME = '    '
          CALL DPADDP (OUTOQ, PNAME, IREC, 'S', INX, IERR)                30.81
          IF (STPNOW()) RETURN                                            34.01
          IF (IREC .GT. MAX_OUTP_REQ) CALL MSGERR (2,                     40.13
     &    'too many output requests')                                     40.13
          CALL DPEXPR (OUTOQ, IREC, 20, INX, IERR)                        40.13 30.81 30.00
          IF (STPNOW()) RETURN                                            34.01
          OUTOR(INX+1) = -1.                                              30.00
          OUTOR(INX+2) = -1.                                              30.00
          RTYPE  = 'SPRC'                                                 40.00
          IVTYPE = 21
          IERR = -1
          CALL COPYCH (RTYPE, TO_, OUTOQ(INX+3), 1, IERR)                 30.81 30.00
          CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
          NREF = 0
          IERR = -1
          CALL COPYCH (PSNAME, TO_, OUTOQ(INX+4), 2, IERR)                30.81 30.00
*         store filename in array
          OUTOQ(INX+6) = NREF                                             30.00
          OUTOQ(INX+7) = IREC                                             40.13
          OUTP_FILES(IREC) = FILENM                                       40.13
          CALL INKEYW ('STA', ' ')                                        40.00
*         read types of variables to be printed in the table
          OUTOQ(INX+18) = IVTYPE                                          30.00
          IF (KEYWIS ('SET')) THEN                                        40.00
            IF (LSETUP.EQ.0) CALL MSGERR (2,
     &          'nesting of setup requires computation of setup')         40.00
*           include code for nesting setup
            NVAR = 2                                                      40.00
*           store variable type for setup (39)
            OUTOQ(INX+19) = 39                                            40.00
*           open file for output of setup on nested grid boundary
            CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')                     40.00
            NREF = 0
            IERR = 0
            CALL FOR (NREF, FILENM, 'UF', IERR)
            IF (STPNOW()) RETURN                                          34.01
            OUTOQ(INX+20) = NREF
            WRITE (NREF, 101) 1
 101        FORMAT ('SWAN', I4, T41,
     &      'Swan standard spectral file, version')                       40.00
            IF (NSTATM.EQ.1) THEN
              WRITE (NREF, 102) 'TIME', 'time-dependent data'
 102          FORMAT (A, T41, A)                                          40.00
              WRITE (NREF, 103) ITMOPT, 'time coding option'              40.03
 103          FORMAT (I6, T41, A)                                         40.00
            ENDIF
            WRITE (NREF, 102) 'LOCATIONS', 'locations in x-y-space'
            WRITE (NREF, 103) MIP, 'number of locations'
            PNAME = '    '
            CALL DPINQP (OUTPS, PNAME, IREC, PTYPE, ILOCR, LLR, IERR)     40.00
            DO 110 IP = 1, MIP
              WRITE (NREF, 106) DBLE(OUTPR(ILOCR+2*IP+1)) + DBLE(XOFFS),
     &                          DBLE(OUTPR(ILOCR+2*IP+2)) + DBLE(YOFFS)   40.00
 106          FORMAT (2F12.2)
 110        CONTINUE
            WRITE (NREF, 132) 1
 132        FORMAT ('QUANT', /, I6,T41,'number of quantities in table')   40.00
            WRITE (NREF, 102) 'Setup',    'setup due to waves'            40.00
            WRITE (NREF, 102) 'm',        'unit'
            WRITE (NREF, 102) OVEXCV(39), 'exception value'
          ELSE
            NVAR = 1
          ENDIF
          OUTOQ(INX+17) = NVAR                                            30.00
*
          CALL INKEYW ('STA', ' ')                                        30.00
          IF (KEYWIS ('OUT')) THEN                                        40.03
            IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
            NSTATM = 1
            CALL INCTIM (ITMOPT, 'TBEG', OUTOR(INX+1), 'REQ', 0.)         30.00
            CALL ININTV ('DELT', OUTOR(INX+2), 'REQ', 0.)                 30.00
            IF (NSTATM.EQ.0) CALL MSGERR (2,
     &                  'time input not allowed in stationary mode')
          ENDIF
*
          MXOUTAR = MAX (MXOUTAR, MIP*MSC*MDC+5*MSC+3*MDC)                40.00
          GOTO 800
        ENDIF                                                             32.02
      ENDIF
*     -------------------------------------------------------
*     command not found:
      RETURN
 800  FOUND = .TRUE.
      RETURN
**    end of subroutine SWREOQ  **
      END
************************************************************************
*                                                                      *
      INTEGER FUNCTION SIRAY (DP, XP1, YP1, XP2, YP2, XX, YY, BOTDEP,     30.70
     &                        BOTLEV, WATLEV)                             30.70
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
*
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. AUTHORS
*
*     30.72: IJsbrand Haagsma
*
*  1. UPDATE
*
*     00.00, Mar. 87: heading added, name of routine changed from
*                     IRAAI in SIRAY
*     30.72, Oct. 97: logical function EQREAL introduced for floating point
*                     comparisons
*     30.70, Nov. 97: changed into INTEGER function
*                     test output added
*                     arguments BOTDEP, BOTLEV, WATLEV added
*     40.03, Nov. 99: X2= etc. moved out of IF-ENDIF group
*
*  2. PURPOSE
*
*     Searching the first point on a ray where the depth is DP
*
*  3. METHOD
*
*     ---
*
*  4. PARAMETERLIST
*
*     DP      REAL   input    depth
*     XP1     REAL   input    X-coordinate start point of ray
*     YP1     REAL   input    Y-coordinate start point of ray
*     XP2     REAL   input    X-coordinate end point of ray
*     YP2     REAL   input    Y-coordinate end point of ray
*     XX      REAL   input    X-coordinate point with depth DP
*     YY      REAL   input    Y-coordinate point with depth DP
*
*  5. SUBROUTINES CALLING
*
*     SWREPS (SWAN/READ)
*
*  6. SUBROUTINES USED
*
*     SVALQI (SWAN/READ)
*
*  7. ERROR MESSAGES
*
*     ---
*
*  8. REMARKS
*
*     ---
*
*  9. STRUCTURE
*
*     ----------------------------------------------------------------
*     Give SIRAY initial value 0
*     Compute stepsize, raylength and number of steps along the ray
*     Compute bottom coordinates  of startpoint as number of meshes
*     Call SVALQI to interpolate depth in startpoint of ray
*     For every step along the ray do
*         Compute coordinates of the intermediate point in problem
*           grid and bottom grid
*         Call SVALQI to interpolate the depth for this point
*         If the required depth is in the interval, then
*             Compute coordinates of the point with depth DP
*             Set SIRAY 1
*         Else
*             Coordinates and depth at start of new interval are values
*               at end of old interval
*     ----------------------------------------------------------------
*  10. SOURCE TEXT
*
      LOGICAL   EQREAL, BOTDEP                                            30.72
      REAL      BOTLEV(*), WATLEV(*)                                      30.70
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SIRAY')
*
      SIRAY   = 0
      DIFDEP = 1e+10
      DSTEP  = MIN(DXG(1), DYG(1))
      RAYLEN = SQRT ((XP2-XP1)*(XP2-XP1) + (YP2-YP1)*(YP2-YP1))
      NSTEP  = 1 + INT(1.5*RAYLEN/DSTEP + 0.5)                            30.70
*
      DO 10 JJ = 0, NSTEP                                                 30.70
        X3  = XP1 + REAL(JJ)*(XP2-XP1)/REAL(NSTEP)
        Y3  = YP1 + REAL(JJ)*(YP2-YP1)/REAL(NSTEP)
        IF (BOTDEP) THEN
          D3   = SVALQI (X3, Y3, 1, BOTLEV, 1, 0, 0)                      30.70
        ELSE
          D3   = SVALQI (X3, Y3, 1, BOTLEV, 1, 0, 0) + WLEV               30.70
          IF (LEDS(7).GE.2)                                               30.70
     &    D3 = D3 + SVALQI (X3, Y3, 7, WATLEV, 1, 0, 0)                   30.70
        ENDIF
        IF (ITEST.GE.160) WRITE (PRTEST, 14) X3+XOFFS, Y3+YOFFS, D3       30.70
  14    FORMAT (' SIRAY, scan point', 2(1X,F8.0), 1X, F8.2)               30.70
        IF (ABS(D3-DP).LT.DIFDEP) THEN                                    10.20
          DIFDEP=ABS(D3-DP)                                               10.20
          JDMINMAX=JJ                                                     10.20
        ENDIF
        IF (JJ.GT.0) THEN
          IF ((DP-D2)*(DP-D3).LE.0) THEN                                  40.03
            IF (EQREAL(D2,D3)) THEN                                       30.72
              XX = X2
              YY = Y2
            ELSE
              XX = X2+(X3-X2)*(D2-DP)/(D2-D3)
              YY = Y2+(Y3-Y2)*(D2-DP)/(D2-D3)
            ENDIF
            SIRAY = 1
            GOTO 20
          ENDIF                                                           40.03
        ENDIF                                                             40.03
        X2 = X3
        Y2 = Y3
        D2 = D3
   10 CONTINUE
*
*     exact depth not found, take closest value:
*
      X3 = XP1 + REAL(JDMINMAX)*(XP2-XP1)/REAL(NSTEP)                     10.20
      Y3 = YP1 + REAL(JDMINMAX)*(YP2-YP1)/REAL(NSTEP)                     10.20
      XX = X3                                                             10.20
      YY = Y3                                                             10.20
*
  20  IF (ITEST.GE.140) WRITE (PRTEST, 24) XX+XOFFS, YY+YOFFS             30.70
  24  FORMAT (' SIRAY, result ', 2(1X,F8.0))                              30.70
      RETURN
* * end of function SIRAY *
      END
*************************************************************************
*                                                                       *
      SUBROUTINE SWNMPS (OUTPS, PSNAME, PSTYPE, MIP, IERR)
*                                                                       *
*************************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
*
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
*  1. UPDATE
*
*       Oct. 1996, ver. 30.50: new subr.
*
*  2. PURPOSE
*
*       Read name of set of output points; get type and number of
*       points in the set
*
*  3. METHOD
*
*
*  4. PARAMETERLIST
*
*       PSNAME   char   output   name
*       PSTYPE   char   output   type
*       MIP      int    output   number of points
*
*  5. SUBROUTINES CALLING
*
*       SPREOQ
*
*  6. SUBROUTINES USED
*
*       INCSTR (Ocean Pack)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*
* 10. SOURCE TEXT
*
      INTEGER   MIP, OUTPS(*)
      CHARACTER PSNAME *(*), PSTYPE *(*), PTYPE *1
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SWNMPS')
*
      IERR = 0
      CALL INCSTR ('SNAME', PSNAME, 'STA', 'BOTTGRID')
      IF (LENCST.GT.8) CALL MSGERR (2, 'SNAME is too long')
      CALL DPINQP (OUTPS, PSNAME, IREC, PTYPE, IADRES,
     &               LENREC, IERR)
      IF (IREC .EQ. 0) THEN
        CALL MSGERR(2, 'Set of output locations is not known')
        PSTYPE = ' '
        MIP   = 0
        IERR  = 1
      ELSE
        PSTYPE = CHAR(OUTPS(IADRES+1))
        IF (PSTYPE.EQ.'F' .OR. PSTYPE.EQ.'H') THEN
          MIP = OUTPS(IADRES+7) * OUTPS(IADRES+8)
*         get direction of frame in case of coordinates plotting
          ALPQ = OCREAL(OUTPS(IADRES+6))
        ELSE
          MIP = OUTPS(IADRES+2)
          ALPQ = 0.
        ENDIF
      ENDIF
 800  IF (ITEST.GE.100) WRITE (PRTEST, 802) PSNAME, PSTYPE, MIP
 802  FORMAT (' exit SWNMPS, name:', A8, ' type:', A1,
     &        '  num of p:', I5)
      RETURN
      END
*************************************************************************
*                                                                       *
      SUBROUTINE SVARTP (IVTYPE)
*                                                                       *
*************************************************************************
C
      INCLUDE 'swcomm1.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     32.02: Roeland Ris & Cor van der Schelde
C     40.03: Nico Booij
C     40.04: Annette Kieftenburg
C
C  1. Updates
C
C     10.09, Aug. 94: output quantity RPER added
C     20.61, Sep. 95: quantities TM02 and FWID added
C     20.67, Dec. 95: FWID renamed FSPR (freq. spread)
C     32.02, Feb. 98: 1D-version introduced
C     40.00, Apr. 98: subr simplified using new array OVKEYW
C     40.03, Sep. 00: inconsistency with manual corrected
C
C  2. Purpose
C
C     Converting keyword into integer
C
C  3. Method
C
C     This subroutine determines an integer value indicating the
C     required output variable from the keyword denoting the same
C     for storage in array with output requests.
C
C  4. PARAMETERLIST
C
C     IVTYPE  INT    output   type number output variable
C
C  5. Subroutines calling
C
C     SPROUT
C
C  6. Subroutines used
C
C     KEYWIS (Ocean Pack)
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     -----------------------------------------------------------------
C     If the keyword is equal to given string, then
C         IVTYPE is given integer value
C     -----------------------------------------------------------------
C
C 13. Source text
C
      LOGICAL KEYWIS
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SVARTP')
C
      IVTYPE  =  0
C
      CALL INKEYW ('STA', 'ZZZZ')
C     check if given keyword corresponds to output quantity
      DO IVT = NMOVAR, 1, -1
C       loop in reverse order to check more specific names first
C       e.g. HSWE before HS
        IF (KEYWIS (OVKEYW(IVT))) THEN                                    40.00
          IVTYPE = IVT                                                    40.00
          GOTO 40
        ENDIF
      ENDDO
*     aliases:
      IF (KEYWIS ('PPER')) IVTYPE = 12                                    40.00
      IF (KEYWIS ('RPER')) IVTYPE = 28                                    40.00
      IF (KEYWIS ( 'DTM')) IVTYPE = 31                                    40.00
      IF (KEYWIS ('FWID')) IVTYPE = 33                                    40.00
C     keyword OUTPUT means that output times will be entered              40.00
      IF (KEYWIS ('OUT')) IVTYPE = 98                                     40.03
C     keyword ZZZZ means end of list of output quantities                 40.00
      IF (KEYWIS ('ZZZZ')) IVTYPE = 99
C
      IF (IVTYPE .EQ. 0) CALL WRNKEY
C
  40  RETURN
C     end of subroutine SVARTP *
      END
*************************************************************************
*                                                                       *
      SUBROUTINE SWBOUN (BFILES, BSPLOC, RBSLOC, BSPDIR, RBSDIR, BSPFRQ,
     &                   RBSFRQ, BSPECS, MXSPEC, BGRIDP, BSPAUX, RBSAUX,
     &                   XCGRID, YCGRID, KGRPNT, SPCSIG,
     &                   SPCDIR, BCAUX,  XYTST,  KGRBND)                  40.00
*                                                                       *
*************************************************************************
C
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.73: Nico Booij
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
C     40.05: Ekaterini E. Kriezi
C
C  1. Updates
C
C     30.73, Nov. 97: New subroutine, replacing code in subr. SWREAD (file SWANPRE1)
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description several arrays
C     30.81, Nov. 98: Adjustment for 1-D case of new boundary conditions
C     34.01, Feb. 99: Introducing STPNOW
C     30.81, Apr. 99: Prefented negative powers for cosine directional spreading (DSPR);
C                     prefented DSPR > 360 and DSPR < 0 (Except for exception value).
C     30.82, July 99: Used EQREAL for real equality comparisons
C     40.05, Aug  00: WW3  boundary nesting command, in Swan nesting option
C                     adding of a new option (same as WW3 command)
C     40.03, Sep. 00: inconsistency with manual corrected
C     40.02, Oct. 00: WWIII added as keyword (will apear in the manual)
C
C  2. Purpuse
C
C       reading and processing BOUNDARY command
C
C  3. Methode
C
C
C  4. Argument variables
C
C i/o RBSAUX: Real EQUIVALENCE of BSPAUX                                  30.90
C i/o RBSDIR: spectral directions of input spectrum                       30.90
C i/o RBSFRQ: spectral frequencies of input spectrum                      30.90
C i/o RBSLOC: Real EQUIVALENCE of BSPLOC                                  30.90
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C i   XCGRID: Coordinates of computational grid in x-direction            30.82
C i   YCGRID: Coordinates of computational grid in y-direction            30.82
C
      REAL    RBSAUX(*)                                                   30.90
      REAL    RBSDIR(*)                                                   30.90
      REAL    RBSFRQ(*)                                                   30.90
      REAL    RBSLOC(*)                                                   30.90
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.82
C
C i/o BSPAUX: Auxiliary array used for interpolation                      30.90
C i/o BSPDIR: Integer EQUIVALENCE of RBSDIR                               30.90
C i/o BSPFRQ: Integer EQUIVALENCE of RBSFRQ                               30.90
C i/o BSPLOC: Place in array BSPECS where to store interpolated spectra   30.90
C
      INTEGER BSPAUX(*)                                                   30.90
      INTEGER BSPDIR(*)                                                   30.90
      INTEGER BSPFRQ(*)                                                   30.90
      INTEGER BSPLOC(*)                                                   30.90
C
C       BFILES  int   i/o    data concerning boundary condition files
C
C       BSPECS  real  i/o    array containing boundary spectra
C       MXSPEC  int   inp    num of spectra that BSPECS can contain
C       BGRIDP  int   i/o    data concerning boundary grid points
C       KGRPNT  int   inp    indirect addresses of grid points
C       BCAUX   real  i/o    auxiliary array used in this subroutine
C       XYTST   int   inp    ix, iy of test points
C
      INTEGER   BFILES(*), MXSPEC, BCAUX(*)
      INTEGER          BGRIDP(*), KGRPNT(MXC,MYC)
      INTEGER          XYTST(*),  KGRBND(*)
      REAL      BSPECS(MDC,MSC,MXSPEC,2)
C
C  5. Parameter variables
C
C
C  6. Local variables
C
      INTEGER   IENT,IERR ,IBFADR,KOUNTR,IX1,IY1,LOOP1,IX2,IY2
      INTEGER   MM,LOOP2,IX,IY,ISIDM,ISIDE,KC,KC2,KC1,IX3,IY3,MP
      INTEGER   IP,II,NBSPSS,NFSEQ,IKO,IKO2,IBSPC1,LOOP,IBSPC2
      INTEGER   IPINDX,IADRS
 
      REAL          CRDP, CRDM, SOMX, SOMY
      REAL      XP,YP,XC,YC,RR,DIRSI,COSDIR,SINDIR,DIRSID,DIRREF
      REAL      RLEN1,RDIST,RLEN2,XC1,YC1,XC2,YC2,W1
 
      LOGICAL   KEYWIS, LOCGRI, CCW, BPARF, BOUNPT,DONALL
 
      INTEGER   UPLO, NUMP
C
C  7. Common blocks and Modules used
C
C
C  8. Subroutines used
C
C       Ocean Pack command reading and data pool management routines
C       BOUNPT
C
      LOGICAL STPNOW                                                      34.01
      LOGICAL EQREAL
C
C  9. Subroutines calling
C
C       SWREAD
C
C  10. Error messageS
C
C
C  11. Remarks
C
C       data concerning boundary files are stored in array BFILES
C       see subr BCFILE for details
C
C  12. Structure
C
C       -----------------------------------------------------------------
C       Read keyword
C       Case keyword =
C       'SHAPE': Read spectral shape parameters
C       'WAMN': Read filename
C               Open WAM nesting file
C               Put file characteristics into array BFILES
C       'WW3N': Read filename
C               Open WW3 nesting file
C               Put file characteristics into array BFILES
C       'NEST': Read filename
C               Call BCFILE to obtain file characteristics
C       'SIDE': read side of boundary
C       'SEG':  read set of points on boundary of comp. grid
C               Read keyword
C               If keyword is 'UNIF'
C               Then Read keyword
C                    If keyword is 'PAR'
C                    Then read integral wave parameters
C                         Call SSHAPE to generate spectrum
C                         put spectrum into array BSPECS
C                    Else {keyword is 'FILE'}
C                         Read filename
C                         Call BCFILE to obtain file characteristics
C               Else {keyword is 'VAR'}
C                    Read keyword
C                    If keyword is 'PAR'
C                    Then Repeat until list is exhausted
C                             Read length and integral wave parameters
C                             Call SSHAPE to generate spectrum
C                             put spectrum into array BSPECS
C                    Else {keyword is 'FILE'}
C                         Repeat until list is exhausted
C                             Read filename
C                             Call BCFILE to obtain file characteristics
C       -----------------------------------------------------------------
C
C 13. Source text
 
 
 
      CHARACTER PNAME *8                                                  40.03
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT,'SWBOUN')
*
      CALL INKEYW ('REQ',' ')
      IF (KEYWIS ('SHAP')) THEN
*
*           specification of the spectral shape
*
* =========================================================================
*
*                      |  JONswap  [gamma]  |
*                      |                    |    | -> PEAK |
*  BOUNdspec  SHAPe   <   PM                 >  <           >   &
*                      |                    |    | MEAN    |
*                      |  GAUSs  [sigfr]    |
*
*
*                     | DEGRees   |
*             DSPR   <             >
*                     | -> POWer  |
*
* =========================================================================
*
        CALL INKEYW ('STA', 'JON')
        IF (KEYWIS ('JON')) THEN
          FSHAPE = 2
          CALL INREAL ('GAMMA', PSHAPE(1), 'STA', 3.3)                    40.00
        ELSE IF (KEYWIS ('BIN')) THEN
          FSHAPE = 3
        ELSE IF (KEYWIS ('PM')) THEN
          FSHAPE = 1
        ELSE IF (KEYWIS ('GAUS')) THEN
          FSHAPE = 4
          CALL INREAL ('SIGFR', SIGMAG, 'STA', 0.01)
*         convert from Hz to rad/s:
          PSHAPE(2) = PI2 * SIGMAG                                        40.00
        ENDIF
*       PEAK or MEAN frequency
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('MEAN')) THEN
          FSHAPE = -FSHAPE
        ELSE
          CALL IGNORE ('PEAK')
        ENDIF
*       directional distribution given by DEGR or by POWER
        CALL IGNORE ('DSPR')
        CALL INKEYW ('STA', 'POW')
        IF (KEYWIS('DEGR')) THEN
          DSHAPE = 1
        ELSE
          CALL IGNORE ('POW')
          DSHAPE = 2
        ENDIF
        IF (ITEST.GE.30) WRITE (PRINTF,6100) FSHAPE, DSHAPE
 6100   FORMAT (' Shape of inc. spectrum, Freq:', I2, ' ; Dir:', I2)
*
      ELSE IF (KEYWIS ('WAMN')) THEN
*
*       SWAN in WAM nesting                                               30.04
*
*      =======================================================================
*
*                                                   |-> CRAY |
*                                    | UNFormatted <          > |
*                                    |              | WKstat |  |
*                                    |                          |
*       BOUNdnest2  WAMNest 'fname' <                            > [xgc] [ygc]
*                                    |                          |
*                                    | FREE                     |
*
*      =======================================================================
*
        IF (MXC .LE. 0) THEN
          CALL MSGERR(3,
     &          ' Computational grid must be given previously')
          GOTO 900
        ENDIF
        IF (MCGRD .LE. 1) THEN
          CALL MSGERR(3,
     &          ' Read depth before entering boundary values')
          GOTO 900
        ENDIF
*
        NBFILS = NBFILS + 1
        IERR = 0
        PNAME = '    '
        CALL DPADDP (BFILES, PNAME, IPINDX, 'S', IBFADR, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BFILES')
        CALL DPEXPR (BFILES, NBFILS, 20, IBFADR, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL INCSTR ('FNAME',FILENM,'REQ', ' ')
        CALL BCWAMN (FILENM, 'NEST', BFILES(IADRS(BFILES,NBFILS)),
     &               BSPLOC, BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,              30.90
     &               BGRIDP, BSPAUX, RBSAUX,                              30.90
     &               XCGRID, YCGRID, KGRPNT, XYTST)
        IF (STPNOW()) RETURN                                              34.01
*
      ELSE IF (KEYWIS('WW3').OR.KEYWIS('WWIII')) THEN                     40.02
*
*       SWAN in WaveWatch nesting                                         40.05
*
*      =======================================================================
*                                 | -> CLOS |
*       BOUNdnest2  WWIII 'fname'  <          > [xgc] [ygc]               40.02
*                                 |  OPEN   |
*      =======================================================================
*
 
        IF (MXC .LE. 0) THEN
          CALL MSGERR(3,
     &          ' Computational grid must be given previously')
          GOTO 900
        ENDIF
        IF (MCGRD .LE. 1) THEN
          CALL MSGERR(3,
     &          ' Read depth before entering boundary values')
          GOTO 900
        ENDIF
*
        NBFILS = NBFILS + 1
        IERR = 0
        CALL DPADDP (BFILES, ' ', IPINDX, 'S', IBFADR, IERR)
        IF (STPNOW()) RETURN
        IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BFILES')
        CALL DPEXPR (BFILES, NBFILS, 20, IBFADR, IERR)
        IF (STPNOW()) RETURN
        CALL INCSTR ('FNAME',FILENM,'STA', 'nest.ww3')
 
*    if keyword is OPEN then
*      DONALL is TRUE  and the nesting boundary remain open
*    else(defaule case)
*      DONALL is FALSE boundary is close, it do interpolation betwen the last
*      and the first point
 
        CALL INKEYW ('STA', 'CLOS')                                       40.05
        IF (KEYWIS('OPEN')) THEN                                          40.05
        DONALL = .TRUE.                                                   40.05
        ELSE IF (KEYWIS('CLOS')) THEN                                     40.05
        DONALL = .FALSE.                                                  40.05
        ELSE                                                              40.05
          CALL WRNKEY                                                     40.05
        ENDIF                                                             40.05
        CALL BCWW3N (FILENM, 'NEST', BFILES(IADRS(BFILES,NBFILS)),        40.05
     &               BSPLOC, BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,              40.05
     &               BGRIDP, BSPAUX,                                      40.05
     &               XCGRID, YCGRID, KGRPNT, XYTST, KGRBND,DONALL)        40.05
        IF (STPNOW()) RETURN
*
      ELSE IF (KEYWIS ('NE')) THEN
*
*       Nesting SWAN model in larger SWAN model
* ==========================================
*                                | -> CLOS |                              40.05
*     BOUNdnest1  NEST 'fname'  <           >
*                                |  OPEN   |                              40.05
* ==========================================
 
        IF (MXC .LE. 0) THEN
          CALL MSGERR(3,
     &          ' Computational grid must be given previously')
          GOTO 900
        ENDIF
        IF (MCGRD .LE. 1) THEN
          CALL MSGERR(3,
     &          ' Read depth before entering boundary values')
          GOTO 900
        ENDIF
        NBFILS = NBFILS + 1
        IERR = 0
        PNAME = '    '
        CALL DPADDP (BFILES, PNAME, IPINDX, 'S', IBFADR, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BFILES')
        CALL DPEXPR (BFILES, NBFILS, 20, IBFADR, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL INCSTR ('FNAME',FILENM,'REQ', ' ')
 
*    if keyword is OPEN then
*      DONALL is TRUE  and the nesting boundary remain open
*    else(defaule case)
*      DONALL is FALSE boundary is close, it do interpolation betwen the last
*      and the first point
 
        CALL INKEYW ('STA', 'CLOS')                                       40.05
        IF (KEYWIS('OPEN')) THEN                                          40.05
        DONALL = .TRUE.                                                   40.05
        ELSE IF (KEYWIS('CLOS')) THEN                                     40.05
        DONALL = .FALSE.                                                  40.05
        ELSE                                                              40.05
          CALL WRNKEY                                                     40.05
        ENDIF                                                             40.05
 
 
        CALL BCFILE (FILENM, 'NEST', BFILES(IADRS(BFILES,NBFILS)),
     &               BSPLOC, BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,              30.90
     &               BGRIDP, BSPAUX,
     &               XCGRID, YCGRID, KGRPNT, XYTST,  KGRBND,
     &               DONALL)                                              40.05
 
        IF (STPNOW()) RETURN                                              34.01
*
      ELSE
*
*       parametric or file boundary condition
*
*      ======================================================================
*
*                             | North |
*                             | NW    |
*                             | West  |
*                             | SW    |   | -> CCW     |
*                 | -> SIDE  <  South  > <              >    |
*                 |           | SE    |   | CLOCKWise  |     |
*                 |           | East  |                      |
*                 |           | NE    |                      |
*       BOUNdary <                                            >    &
*                 |           | -> XY  <  [x]  [y]  >  |     |
*                 | SEGment  <                          >    |
*                             |    IJ  <  [i]  [j]  >  |
*
*
*                          |  PAR  [hs] [per] [dir] [dd]  |
*            |  UNIform   <                                >             |
*            |             |  FILE  'fname'  [seq]        |              |
*           <                                                             >
*            |             |  PAR  < [len] [hs] [per] [dir] [dd] >  |    |
*            |  VARiable  <                                          >   |
*                          |  FILE < [len] 'fname' [seq] >          |
*
*      ======================================================================
*
        IF (MXC .LE. 0) THEN
          CALL MSGERR(3,
     &          ' Computational grid must be given previously')
          GOTO 900
        ENDIF
        IF (MCGRD .LE. 1) THEN
          CALL MSGERR(3,
     &          ' Read depth before entering boundary values')
          GOTO 900
        ENDIF
*
*       first define side or segment
*
*       *** definition of boundary segment ***
*
        CALL INKEYW ('REQ',' ')
        IF (KEYWIS ('STAT')) THEN
          CALL MSGERR (1, 'keyword STAT ignored')
          CALL INKEYW ('REQ',' ')
        ENDIF
        KOUNTR = 0
        IF (KEYWIS ('SEG')) THEN
          IERR = 0
          CALL INKEYW ('STA','XY')
          IF (KEYWIS('XY') .OR. KEYWIS ('LOC')) THEN
            LOCGRI = .TRUE.
          ELSE IF (KEYWIS('IJ') .OR. KEYWIS ('GRI')) THEN
            LOCGRI = .FALSE.
          ELSE
            CALL WRNKEY
          ENDIF
*         loop over points describing the segment
          IX1 = 1
          IY1 = 1
          DO 41 LOOP1 = 1, 9999
            IF (LOCGRI) THEN
              CALL READXY ('XP','YP',XP,YP, 'REP', -1.E10, -1.E10)
              IF (XP.LT.-.9E10) GOTO 42
              CALL CVMESH (XP, YP, XC, YC, KGRPNT, XCGRID, YCGRID,
     &                     KGRBND)                                        40.00
              IX2 = NINT(XC) + 1
              IY2 = NINT(YC) + 1                                          40.00
              IF (.NOT.BOUNPT(IX2,IY2,KGRPNT)) THEN
                CALL MSGERR (2, 'invalid boundary point')
                WRITE (PRTEST, 38) XP+XOFFS, YP+YOFFS, XC, YC, IX2, IY2   40.00
  38            FORMAT (' segment point ', 2F10.2,
     &                  ' grid ', 2F6.2, 2I4)
              ENDIF
            ELSE
              CALL ININTG ('I' , IX2, 'REP', -1)                          40.03
              IF (IX2 .LT. 0) GOTO 42                                     40.00
              CALL ININTG ('J' , IY2, 'REQ',  0)                          40.03
              IX2 = IX2 + 1                                               40.00
              IY2 = IY2 + 1
            ENDIF
            IF (ITEST.GE.80) WRITE (PRTEST, 38) XCGRID(IX2,IY2)+XOFFS,    40.00
     &                YCGRID(IX2,IY2)+YOFFS, XC, YC, IX2-1, IY2-1         40.00
C
C           generate intermediate points on the segment
            IF (IX2 .GT. 0 .AND. IX2 .LE. MXC .AND.
     &          IY2 .GT. 0 .AND. IY2 .LE. MYC) THEN
              IF (LOOP1 .EQ. 1) THEN
                MM = 1
              ELSE
                MM = MAX (ABS(IX2-IX1), ABS(IY2-IY1))
              ENDIF
              DO LOOP2 = 1, MM
                RR = REAL(LOOP2) / REAL(MM)
C
                IF (.NOT. ONED) THEN                                      30.81
                  IX = IX1 + NINT(RR*REAL(IX2-IX1))
                  IY = IY1 + NINT(RR*REAL(IY2-IY1))
                ELSE                                                      30.81
                  IX = IX1 + NINT(RR*REAL(IX2-IX1))                       30.81
                  IY = IY1                                                30.81
                END IF                                                    30.81
C
                IF (ITEST.GE.80) WRITE (PRTEST, *) ' b. point ',
     &                RR, IX, IY
                IF (KGRPNT(IX,IY) .GT. 1) THEN
                  KOUNTR = KOUNTR + 1
                  BCAUX(2*KOUNTR)   = IX
                  BCAUX(2*KOUNTR+1) = IY
                ENDIF
              ENDDO
            ELSE
              CALL MSGERR (2, 'Boundary point outside comp. grid')
            ENDIF
            IX1 = IX2
            IY1 = IY2
 41       CONTINUE
*         *** termination, store number of points on segment     ***
*         ***       segments = number of points -1               ***
 42       BCAUX(1) = KOUNTR-1
          IF (KOUNTR.EQ.0)
     &        CALL MSGERR(1,'No points of the boundary found')
        ELSE
*         boundary condition on one side of the computational grid
          CALL IGNORE ('SIDE')
          CALL INKEYW ('REQ',' ')
*         *** specification of side for which boundary   ***
*         *** condition is given                         ***
          UPLO = 0
          IF (KEYWIS ('NW')) THEN
            DIRSI = 45.
          ELSE IF (KEYWIS ('SW')) THEN
            DIRSI = 135.
          ELSE IF (KEYWIS ('SE')) THEN
            DIRSI = -135.
          ELSE IF (KEYWIS ('NE')) THEN
            DIRSI = -45.
          ELSE IF (KEYWIS ('N')) THEN
            DIRSI = 0.
          ELSE IF (KEYWIS ('W')) THEN
            DIRSI = 90.
          ELSE IF (KEYWIS ('S')) THEN
            DIRSI = 180.
          ELSE IF (KEYWIS ('E')) THEN
            DIRSI = -90.
          ELSE IF (KEYWIS ('LO')) THEN
            UPLO = -1
          ELSE IF (KEYWIS ('UP')) THEN
            UPLO = 1
          ELSE
            CALL WRNKEY
          ENDIF
          IF (UPLO.NE.0) THEN
*           older, obsolete option
            CALL MSGERR (1, 'UPper and LOwer are becoming obsolete')
            CALL INKEYW ('REQ', ' ')
            IF (KEYWIS('Y')) THEN
              IF (UPLO.GT.0) THEN
                ISIDM = 3
                CCW = .FALSE.
              ELSE
                ISIDM = 1
                CCW = .TRUE.
              ENDIF
            ELSE
              CALL IGNORE ('X')
              IF (UPLO.GT.0) THEN
                ISIDM = 2
                CCW = .TRUE.
              ELSE
                ISIDM = 4
                CCW = .FALSE.
              ENDIF
            ENDIF
            CALL INKEYW ('STA', ' ')
            IF (KEYWIS ('JON')) THEN
              FSHAPE = 2
              CALL INREAL ('GAMMA', PSHAPE(1), 'STA', 3.3)
            ELSE IF (KEYWIS ('PM')) THEN
              FSHAPE = 1
            ELSE IF (KEYWIS ('GAUS')) THEN
              FSHAPE = 4
              CALL INREAL ('SIGFR', SIGMAG, 'STA', 0.01)
*             convert from Hz to rad/s:
              PSHAPE(2) = PI2 * SIGMAG
            ENDIF
            DSHAPE = 2
            GOTO 90
          ENDIF
*
*         select side in the chosen direction
*
          CRDM   = -1.E10
          ISIDM  = 0
          IF (ONED) THEN                                                  40.00
            COSDIR = COS(PI*(DNORTH+DIRSI)/180.)
            SINDIR = SIN(PI*(DNORTH+DIRSI)/180.)
            DO ISIDE = 1, 4
              SOMX = 0.
              SOMY = 0.
              NUMP = 0
              IF (ISIDE.EQ.2) THEN
                KC = KGRPNT(MXC,1)
                IF (KC.GT.1) THEN
                  SOMX = XCGRID(MXC,1)
                  SOMY = YCGRID(MXC,1)
                  NUMP = 1
                ENDIF
              ELSE IF (ISIDE.EQ.4) THEN
                KC = KGRPNT(1,1)
                IF (KC.GT.1) THEN
                  SOMX = XCGRID(1,1)
                  SOMY = YCGRID(1,1)
                  NUMP = 1
                ENDIF
              ENDIF
              IF (NUMP.GT.0) THEN
                CRDP = COSDIR*SOMX + SINDIR*SOMY
*               side with largest CRDP is the one selected
                IF (CRDP.GT.CRDM) THEN
                  CRDM = CRDP
                  ISIDM = ISIDE
                ENDIF
              ENDIF
            ENDDO
          ELSE                                                            40.00
            DO ISIDE = 1, 4
              SOMX = 0.
              SOMY = 0.
              NUMP = 0
              IF (ISIDE.EQ.1) THEN
                DO IX = 1, MXC
                  KC2 = KGRPNT(IX,1)
                  IF (IX.GT.1) THEN
                    IF (KC1.GT.1 .AND. KC2.GT.1) THEN                     40.00
*                     if both grid points at ends of a step are valid, then
*                     take DX and DY into account when determining direction
                      SOMX = SOMX + XCGRID(IX,1)-XCGRID(IX-1,1)
                      SOMY = SOMY + YCGRID(IX,1)-YCGRID(IX-1,1)
                      NUMP = NUMP + 1
                    ENDIF
                  ENDIF
                  KC1 = KC2                                               40.03
                ENDDO
              ELSE IF (ISIDE.EQ.2) THEN
                DO IY = 1, MYC
                  KC2 = KGRPNT(MXC,IY)
                  IF (IY.GT.1) THEN
                    IF (KC1.GT.1 .AND. KC2.GT.1) THEN                     40.00
                      SOMX = SOMX + XCGRID(MXC,IY)-XCGRID(MXC,IY-1)
                      SOMY = SOMY + YCGRID(MXC,IY)-YCGRID(MXC,IY-1)
                      NUMP = NUMP + 1
                    ENDIF
                  ENDIF
                  KC1 = KC2                                               40.03
                ENDDO
              ELSE IF (ISIDE.EQ.3) THEN                                   40.00
                DO IX = 1, MXC
                  KC2 = KGRPNT(IX,MYC)
                  IF (IX.GT.1) THEN
                    IF (KC1.GT.1 .AND. KC2.GT.1) THEN                     40.00
                      SOMX = SOMX + XCGRID(IX-1,1)-XCGRID(IX,1)
                      SOMY = SOMY + YCGRID(IX-1,1)-YCGRID(IX,1)
                      NUMP = NUMP + 1
                    ENDIF
                  ENDIF
                  KC1 = KC2                                               40.03
                ENDDO
              ELSE IF (ISIDE.EQ.4) THEN
                DO IY = 1, MYC
                  KC2 = KGRPNT(1,IY)
                  IF (IY.GT.1) THEN
                    IF (KC1.GT.1 .AND. KC2.GT.1) THEN                     40.00
                      SOMX = SOMX + XCGRID(1,IY-1)-XCGRID(1,IY)
                      SOMY = SOMY + YCGRID(1,IY-1)-YCGRID(1,IY)
                      NUMP = NUMP + 1
                    ENDIF
                  ENDIF
                  KC1 = KC2                                               40.03
                ENDDO
              ENDIF
              IF (NUMP.GT.0) THEN
                DIRSID = ATAN2(SOMY,SOMX)
                DIRREF = PI*(DNORTH+DIRSI)/180.
                IF (CVLEFT) THEN
                  CRDP = COS(DIRSID - 0.5*PI - DIRREF)
                ELSE
                  CRDP = COS(DIRSID + 0.5*PI - DIRREF)
                ENDIF
*               side with largest CRDP is the one selected
                IF (CRDP.GT.CRDM) THEN
                  CRDM = CRDP
                  ISIDM = ISIDE
                ENDIF
              ENDIF
            ENDDO
          ENDIF                                                           40.00
          IF (ISIDM.EQ.0) THEN
            CALL MSGERR (2, 'No open boundary found')
          ENDIF
*
*         go along boundary clockwise or counterclockwise (default)
          CALL INKEYW ('STA', 'CCW')
          IF (KEYWIS('CLOCKW')) THEN
            CCW = .FALSE.
          ELSE
            CALL IGNORE ('CCW')
            CCW = .TRUE.
          ENDIF
*
  90      IF (ISIDM.EQ.1) THEN
            IX1 = 1
            IY1 = 1
            IX2 = MXC
            IY2 = 1
          ELSE IF (ISIDM.EQ.2) THEN
            IX1 = MXC
            IY1 = 1
            IX2 = MXC
            IY2 = MYC
          ELSE IF (ISIDM.EQ.3) THEN
            IX1 = MXC
            IY1 = MYC
            IX2 = 1
            IY2 = MYC
          ELSE IF (ISIDM.EQ.4) THEN
            IX1 = 1
            IY1 = MYC
            IX2 = 1
            IY2 = 1
          ENDIF
          IF (.NOT.CCW .EQV. CVLEFT) THEN
*           swap end points
            IX3 = IX1
            IY3 = IY1
            IX1 = IX2
            IY1 = IY2
            IX2 = IX3
            IY2 = IY3
          ENDIF
          IF (ITEST.GE.50) WRITE (PRINTF, 112) ISIDM,
     &    IX1-1, IY1-1, XCGRID(IX1,IY1)+XOFFS, YCGRID(IX1,IY1)+YOFFS,     40.00
     &    IX2-1, IY2-1, XCGRID(IX2,IY2)+XOFFS, YCGRID(IX2,IY2)+YOFFS      40.00
 112      FORMAT (' Selected side:', I2, ' from ', 2I4, 2F9.0,            40.00
     &    ' to ', 2I4, 2F9.0)                                             40.00
          KOUNTR = 0
          MP = MAX(ABS(IX2-IX1),ABS(IY2-IY1))
          DO IP = 0, MP
            IF (MP.EQ.0) THEN                                             40.00
              RR = 0.
            ELSE
              RR = REAL(IP) / REAL(MP)
            ENDIF
            IX = IX1 + NINT(RR*REAL(IX2-IX1))
            IY = IY1 + NINT(RR*REAL(IY2-IY1))
            IF (KGRPNT(IX,IY) .GT. 1) THEN
              KOUNTR = KOUNTR + 1
              BCAUX(2*KOUNTR)   = IX
              BCAUX(2*KOUNTR+1) = IY
            ENDIF
          ENDDO
        ENDIF
*
*       *** boundary condition from file, 1-d or 2-d spectrum
*
        CALL INKEYW ('REQ',' ')
        IF (KEYWIS('UNIF') .OR. KEYWIS('CON') .OR. KEYWIS('PAR')) THEN
          CALL INKEYW('STA', 'PAR')
          IF (KEYWIS('PAR')) THEN
            CALL INREAL ('HS',  SPPARM(1), 'REQ', 0.)
            CALL INKEYW ('STA', ' ')
            IF (KEYWIS('MEAN')) THEN
              IF (FSHAPE.GT.0) FSHAPE = -FSHAPE
            ELSE IF (KEYWIS('PEAK')) THEN                                 40.00
              IF (FSHAPE.LT.0) FSHAPE = -FSHAPE
            ENDIF
            CALL INREAL ('PER', SPPARM(2), 'REQ', 0.)
            CALL INREAL ('DIR', SPPARM(3), 'REQ', 0.)
            IF (DSHAPE.EQ.1) THEN
              CALL INREAL ('DD',  SPPARM(4), 'STA', 30.)
              IF ((SPPARM(4).GT.360. .OR. SPPARM(4).LT. 0.).AND.          30.81
     &            .NOT.(EQREAL(SPPARM(4),OVEXCV(16)))) THEN               30.82
                CALL MSGERR (2,'Directional spreading is less than '//    30.81
     &                        '0 or larger than 360 degrees, and no '//   30.81
     &                        'exception value')                          30.81
              END IF                                                      30.81
            ELSE
              CALL INREAL ('DD',  SPPARM(4), 'STA', 2.)
              IF (SPPARM(4).LE. 0.) THEN                                  30.81
                CALL MSGERR (2,                                           30.81
     &          'Power of cosine is less or equal to zero')               30.81
              END IF                                                      30.81
              IF (SPPARM(4)*DDIR**2/2. .GT. 1.) THEN                      40.03
                CALL MSGERR (2,                                           40.03
     &          'distribution too narrow to be represented properly')     40.03
                WRITE (PRINTF, 142) SQRT(2./SPPARM(4))*180./PI            40.03
 142            FORMAT (' Advice: choose Dtheta < ', F8.3, ' degr')       40.03
              END IF                                                      40.03
            ENDIF
            NBSPEC = NBSPEC + 1
            IF (ITEST.GE.80) WRITE (PRTEST,*) ' bound. spectr.',
     &                   NBSPEC, (SPPARM(II), II=1,4)
            CALL SSHAPE (BSPECS(1,1,NBSPEC,1), SPCSIG, SPCDIR,
     &                   FSHAPE, DSHAPE)
            NBSPSS = NBSPEC
          ELSE IF (KEYWIS('FILE') .OR. KEYWIS('SPEC')) THEN
            CALL INCSTR ('FNAME',FILENM,'REQ', ' ')
*           generate new set of file data
            NBFILS = NBFILS + 1
            IERR = 0
            PNAME = '    '
            CALL DPADDP (BFILES, PNAME, IPINDX, 'S', IBFADR, IERR)
            IF (STPNOW()) RETURN                                          34.01
            IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BFILES')
            CALL DPEXPR (BFILES, NBFILS, 30, IBFADR, IERR)
            IF (STPNOW()) RETURN                                          34.01
            NBSPSS = NBSPEC
            CALL BCFILE (FILENM, 'PNTS', BFILES(IADRS(BFILES,NBFILS)),
     &                   BSPLOC, BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,          30.90
     &                   BGRIDP, BSPAUX,
     &                   XCGRID, YCGRID, KGRPNT, XYTST,  KGRBND,
     &                   DONALL)                                          40.05
            IF (STPNOW()) RETURN                                          34.01
            CALL ININTG('SEQ', NFSEQ, 'STA', 1)
            NBSPSS = NBSPSS + NFSEQ
          ENDIF
          DO IKO = 1, KOUNTR
            IX = BCAUX(2*IKO)
            IY = BCAUX(2*IKO+1)
            IKO2 = NBGRPT + IKO
            BGRIDP(6*IKO2-5) = KGRPNT(IX,IY)
            BGRIDP(6*IKO2-4) = 1
            BGRIDP(6*IKO2-3) = 1000
            BGRIDP(6*IKO2-2) = NBSPSS
            BGRIDP(6*IKO2-1) = 0
            BGRIDP(6*IKO2)   = 1
          ENDDO
          NBGRPT = NBGRPT + KOUNTR
        ELSE IF (KEYWIS('VAR')) THEN
          CALL INKEYW('STA', 'PAR')
          IF (KEYWIS('PAR')) THEN
            BPARF = .TRUE.
          ELSE IF (KEYWIS('FILE')) THEN
            BPARF = .FALSE.
          ENDIF
          RLEN1 = -1.E20
          IKO = 1
          RDIST = 0.
          IBSPC1 = 1
          DO LOOP = 1, 999
            IF (LOOP.EQ.1) THEN
              CALL INREAL('LEN', RLEN2, 'REQ', 0.)
            ELSE
              CALL INREAL('LEN', RLEN2, 'STA', 1.E20)
            ENDIF
            IF (RLEN2.LT.0.9E20) THEN
              IF (IKO.GT.KOUNTR) THEN
                CALL MSGERR(1,
     &          'Length of segment short, boundary values ignored')       40.00
                WRITE (PRINTF, 332) RDIST, RLEN2
 332            FORMAT (' segment length=', F9.2, '; [len]=', F9.2)
              ENDIF
              IF (BPARF) THEN
                CALL INREAL ('HS',  SPPARM(1), 'REQ', 0.)
                CALL INKEYW ('STA', ' ')
                IF (KEYWIS('MEAN')) THEN
                  IF (FSHAPE.GT.0) FSHAPE = -FSHAPE
                ELSE
                  CALL IGNORE ('PEAK')
                  IF (FSHAPE.LT.0) FSHAPE = -FSHAPE
                ENDIF
                CALL INREAL ('PER', SPPARM(2), 'REQ', 0.)
                CALL INREAL ('DIR', SPPARM(3), 'REQ', 0.)
                IF (DSHAPE.EQ.1) THEN
                  CALL INREAL ('DD',  SPPARM(4), 'STA', 30.)
                  IF ((SPPARM(4).GT.360. .OR. SPPARM(4).LT. 0.).AND.      30.81
     &                .NOT.(EQREAL(SPPARM(4),OVEXCV(16)))) THEN           30.82
                    CALL MSGERR (2,'Directional spreading is less ' //    30.81
     &                             'than 0 or larger than 360 '//         30.81
     &                             'degrees and no exception value')      30.81
                  END IF                                                  30.81
                ELSE
                  CALL INREAL ('DD',  SPPARM(4), 'STA', 2.)
                  IF (SPPARM(4).LE. 0.) THEN                              30.81
                    CALL MSGERR (2,'Power of cosine is less or equal '//  30.81
     &                             'to zero')                             30.81
                  END IF                                                  30.81
                ENDIF
                NBSPEC = NBSPEC + 1
                CALL SSHAPE (BSPECS(1,1,NBSPEC,1), SPCSIG, SPCDIR,
     &                       FSHAPE, DSHAPE)
                IBSPC2 = NBSPEC
              ELSE
                IF (LOOP.EQ.1) THEN
                  CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
                ELSE
                  CALL INCSTR ('FNAME', FILENM, 'STA', ' ')
                ENDIF
                IF (FILENM.NE.'    ') THEN
*                 generate new set of file data
                  NBFILS = NBFILS + 1
                  NBSPSS = NBSPEC
                  PNAME = '    '
                  CALL DPADDP (BFILES, PNAME, NBFILS, 'S', IBFADR, IERR)
                  IF (STPNOW()) RETURN                                    34.01
                  CALL DPEXPR (BFILES, NBFILS, 30, IBFADR, IERR)
                  IF (STPNOW()) RETURN                                    34.01
                  CALL BCFILE (FILENM, 'PNTS',
     &                         BFILES(IADRS(BFILES,NBFILS)),
     &                         BSPLOC, BSPDIR, RBSDIR, BSPFRQ, RBSFRQ,    30.90
     &                         BGRIDP, BSPAUX,
     &                         XCGRID, YCGRID, KGRPNT, XYTST,  KGRBND,
     &                         DONALL)                                    40.05
                  IF (STPNOW()) RETURN                                    34.01
                ENDIF
                CALL ININTG ('SEQ', NFSEQ, 'STA', 1)
                IBSPC2 = NBSPSS + NFSEQ
                IF (IBSPC2.GT.NBSPEC)
     &                CALL MSGERR (1,'too large value for SEQ')
              ENDIF
            ELSE
              IF (IKO.GT.KOUNTR) GOTO 360                                 40.00
            ENDIF
            DO LOOP2 = 1, 9999
              IX = BCAUX(2*IKO)
              IY = BCAUX(2*IKO+1)
              XC2 = XCGRID(IX,IY)
              YC2 = YCGRID(IX,IY)
              IF (LOOP2 .GT. 1) THEN
                RDIST = RDIST + SQRT ((XC2-XC1)**2 + (YC2-YC1)**2)
              ENDIF
              XC1 = XC2
              YC1 = YC2
              IF (RDIST.GT.RLEN2) GOTO 340
              IKO2 = NBGRPT + IKO
              BGRIDP(6*IKO2-5) = KGRPNT(IX,IY)
              BGRIDP(6*IKO2-4) = 1
              W1 = (RLEN2-RDIST)/(RLEN2-RLEN1)
              BGRIDP(6*IKO2-3) = NINT(1000.*W1)
              BGRIDP(6*IKO2-2) = IBSPC1
              BGRIDP(6*IKO2-1) = NINT(1000.*(1.-W1))
              BGRIDP(6*IKO2)   = IBSPC2
              IKO = IKO + 1
              IF (IKO.GT.KOUNTR) GOTO 340                                 40.00
            ENDDO
C           boundary values have been assigned, read new parameters
 340        IF (RLEN2.GT.0.9E20) GOTO 360                                 40.00
            RLEN1  = RLEN2
            IBSPC1 = IBSPC2
          ENDDO
C         update NBGRPT = number of boundary grid points
 360      NBGRPT = NBGRPT + KOUNTR                                        40.00
        ELSE
          CALL WRNKEY
        ENDIF
      ENDIF
 900  RETURN
      END
**********************************************************************
*                                                                    *
      SUBROUTINE BCFILE (FBCNAM, BCTYPE, BFILED, BSPLOC, BSPDIR,          30.90
     &                   RBSDIR,BSPFRQ, RBSFRQ, BGRIDP, BSPAUX,           30.90
     &                   XCGRID, YCGRID,    KGRPNT, XYTST,  KGRBND,
     &                   DONALL)                                          40.05
*                                                                    *
**********************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C
C
C  0. Authors
C
C     30.73: Nico Booij
C     30.90: IJsbrand Haagsma (Equivalence version)
C     34.01: Jeroen Adema
C     40.03, 40.13: Nico Booij
C     40.05: Ekaterini E. Kriezi
C
*  1. Updates
*
*     30.73, Dec. 97: New subroutine
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, June 00: function EQCSTR used to compare strings
C            July 00: option LONLAT for location coordinates introduced
C     40.05, Aug. 00: replace the source text related with the grid points
C                     interpolation coef. with a new subroutine BC_POINTS
C     40.13, Jan. 01: ! is now allowed as comment sign in a boundary file
C                     checking coordinates only for nesting situation
C                     remove declarations of unused variables
C
C  2. Purpuse
C
C       reads file data for boundary condition
C
C  3. Methode
C
C
C  4. Argument variables
C
C i/o RBSDIR: Real EQUIVALENCE of BSPDIR                                  30.90
C i/o RBSFRQ: Real EQUIVALENCE of BSPFRQ                                  30.90
C
      REAL RBSDIR(*)                                                      30.90
      REAL RBSFRQ(*)                                                      30.90
C
      REAL      XCGRID(MXC,MYC), YCGRID(MXC,MYC)
C
C i/o BSPDIR: spectral directions of input spectrum                       30.90
C i/o BSPFRQ: spectral frequencies of input spectrum                      30.90
C
      INTEGER BSPDIR(*)                                                   30.90
      INTEGER BSPFRQ(*)                                                   30.90
C
      INTEGER   BFILED(*), BSPAUX(*), KGRPNT(MXC,MYC), BGRIDP(*)
      INTEGER   BSPLOC(*), XYTST(*), KGRBND(*)
C
C       FBCNAM  char  inp    filename of boundary data file
C       BCTYPE  char  inp    if value is "NEST": nesting b.c.
C       BFILED  int   i/o    data concerning boundary condition files
C       BSPLOC  int   i/o    place in array BSPECS where to store
C                            interpolated spectra
C       BGRIDP  int   i/o    data concerning boundary grid points
C       BSPAUX  real  i/o    auxiliary array used for interpolation
C       XCGRID  real  inp    x-coordinate of computational grid points
C       YCGRID  real  inp    y-coordinate of computational grid points
C       KGRPNT  int   inp    indirect addresses of grid points
C       XYTST   int   inp    ix, iy of test points
C
C     DONALL: logic arguments declare if the nesting  boundary is open or close
C             it is defined by the users
C
      LOGICAL, INTENT(INOUT)  ::  DONALL                                  40.05
C
      CHARACTER FBCNAM *(*), BCTYPE *(*)
C
C  5. Parameter variables
C
C
C  6. Local variables
C
      INTEGER :: ISTATF, NDSL, NDSD, IOSTAT, IERR, NBOUNC, NANG, NFRE
      INTEGER :: IBOUNC, DORDER
      INTEGER :: IENT,IBSPLC,IPINDX,IBSPFR,IBSPDR,IAUXW,IOPTT
      INTEGER :: NHEDF, NHEDT, NHEDS, IFRE , IANG,IADRS
      INTEGER :: NQUANT, IQUANT, IBC, LL, II, NBGRPT_PREV,IIPT2
      REAL    :: XP, YP, XP2, YP2
      REAL    :: FREQHZ, DIRDEG, DIRRD1,DIRRAD
      CHARACTER BTYPE *4, HEDLIN *80, PNAME *8
C
C    NBGRPT_PREV is the prevous number of NBGRPT
C    IIPT2 counter use for the chekinf if there are grid points on nested boundary
C  7. Common Blocks and Modules used
C
C
C  8. Subroutines Used
C
C       Ocean Pack command reading and data pool management routines
C       BOUNPT
C       BC_POINTS : boundary points interpolation
C
      LOGICAL STPNOW, EQCSTR                                              40.03
C
C  9. Subroutines calling
C
C       SWREAD
C
C  10. Error messages
C
C
C  11. Remarks
C
C
C       This subroutine reads the heading of the file to determine locations
C       of boundary spectra, spectral frequencies and directions etc.
C       Reading and processing of spectral energy densities is done during
C       computation by subroutine RESPEC (file Swanmain.for)
C
C       data concerning boundary files are stored in array BFILED
C       there is a subarray for each file; it contains:
C       1.  status; 0: stationary, 1: nonstat, -1: exhausted
C       2.  time of boundary values read one before last
C       3.  time of boundary values read last
C       4.  NDSL: unit ref. num. of file containing filenames
C       5.  NDSD: unit ref. num. of file containing data
C       6.  time coding option for reading time from data file
C       8.  number of locations for which spectra are in the file
C       9.  order of reading directional information
C       10. number of spectral directions of spectra on file
C       12. number of spectral frequencies
C       14. number of heading lines per file
C       15. number of heading lines per time step
C       16. number of heading lines per spectrum
C       17. =1: energy dens., =2: variance density
C       18. =1: Cartesian direction, =2: Nautical dir.                    40.00
C       19. =1: direction spread in degr, =2: Power of Cos.               40.00
C
C
C  12. Structure
C
C       -----------------------------------------------------------------
C       Open boundary condition data file
C       Read type of file from first line of file
C       Case filetype is:
C       TPAR: make filetype TPAR
C       SWAN: make filetype SWAN
C             If b.c. type is NEST
C             Then calculate data on grid points calling BC_POINTS subroutine,
C             put into array BGRIDP
C             -----------------------------------------------------------
C             Read spectral directions from file into array BSPDIR
C             Read spectral frequencies from file into array BSPFRQ
C       -----------------------------------------------------------------
C       Put file characteristics into array BFILED
C       -----------------------------------------------------------------
C
C 13. Source text
C
 
      LOGICAL         CCOORD                                            40.03
 
 
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT, 'BCFILE')
*
      NDSL = 0
      IIPT2 = 0                                                           40.05
*     open data file
      NDSD = 0
      IOSTAT = 0
      CALL FOR (NDSD, FILENM, 'OF', IOSTAT)
      IF (STPNOW()) RETURN                                                34.01
*
*     generate pointers for data subarrays
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPLOC, PNAME, IPINDX, 'S', IBSPLC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPLOC')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPFRQ, PNAME, IPINDX, 'S', IBSPFR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPFRQ')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPDIR, PNAME, IPINDX, 'S', IBSPDR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPDIR')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPAUX, PNAME, IPINDX, 'P', IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPAUX')
      CALL DPEXPR (BSPAUX, NBFILS, 10*MSC*MDC, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
*     start reading from the data file
      READ (NDSD, '(A)') HEDLIN
      IF (EQCSTR(HEDLIN,'TPAR')) THEN                                     40.03
        BTYPE  = 'TPAR'
        ISTATF = 1
        IOPTT  = 1
        NBOUNC = 1
        NANG   = 0
        NFRE   = 0
        NHEDF  = 0
        NHEDT  = 0
        NHEDS  = 0
        DORDER = 0
*       Note: second subarray of BSPAUX needed for interpolation of spectra
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX, MSC*MDC,
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IF (NSTATM.EQ.0) CALL MSGERR (3,
     &      'time information not allowed in stationary mode')
        NSTATM = 1
      ELSE IF (EQCSTR(HEDLIN,'SWAN')) THEN                                40.03
        NHEDF  = 0
  10    READ (NDSD, '(A)') HEDLIN
        IF (ITEST.GE.60) WRITE (PRTEST,11) HEDLIN                         40.00
C       skip heading lines starting with comment sign ($ as in command file)
        IF (HEDLIN(1:1).EQ.COMID .OR. HEDLIN(1:1).EQ.'!') GOTO 10         40.13
        IF (EQCSTR(HEDLIN,'TIME')) THEN                                   40.03
          IF (NSTATM.EQ.0) CALL MSGERR (3,
     &    'nonstationary boundary condition not allowed '//
     &    'in stationary mode')
          NSTATM = 1
          ISTATF = 1
          BTYPE = 'SWNT'
          READ (NDSD, *) IOPTT
          READ (NDSD, '(A)') HEDLIN
          IF (ITEST.GE.60) WRITE (PRTEST,11) HEDLIN
  11      FORMAT (' heading line: ', A)
          NHEDF = 2
          NHEDT = 1
        ELSE
          ISTATF = 0
          BTYPE = 'SWNS'
          NHEDT  = 0
        ENDIF
*
*       read geographical locations
*
*       read number of boundary points
        CCOORD = .TRUE.                                                   40.03
        IF (EQCSTR(HEDLIN,'LOC')) THEN                                    40.03
          IF (BCTYPE.EQ.'NEST' .AND. KSPHER.EQ.1) CALL MSGERR (3,         40.13
     &    'Boundary locations are Cartesian, while comp. is spherical')   40.03
        ELSE IF (EQCSTR(HEDLIN,'LONLAT')) THEN                            40.03
          IF (BCTYPE.EQ.'NEST' .AND. KSPHER.EQ.0) CALL MSGERR (3,         40.13
     &    'Boundary locations are spherical, while comp. is Cartesian')   40.03
        ELSE
C         set CCOORD to False to indicate that no locations are defined   40.03
          CCOORD = .FALSE.                                                40.03
        ENDIF
        IF (CCOORD) THEN
          READ (NDSD, *) NBOUNC
 
          DO IBOUNC = 1, NBOUNC
            IERR = 0
            CALL REFIXY (NDSD, XP, YP, IERR)
            IF (ITEST.GE.80) THEN
              WRITE (PRTEST, *) ' B. spectrum ', IBOUNC, XP+XOFFS,
     &        YP+YOFFS, IERR                                              40.03
            ENDIF
*           in case of nesting coordinates on file are used to
*           determine interpolation coefficients
*           in other cases coordinates are ignored
            IF (BCTYPE .EQ. 'NEST') THEN
              XP2 = XP
              YP2 = YP
 
 
 
 
 
 
 
C
C  call subroutine BC_POINTS to interpolate the boundaries points to the grid
C  pionts of the swan-computational grid
C
              NBGRPT_PREV = NBGRPT                                        40.05
              CALL BC_POINTS ( BSPLOC, BGRIDP, BSPAUX, XCGRID, YCGRID,    40.05
     &                    KGRPNT, XYTST,  KGRBND,XP2,YP2,IBOUNC,          40.05
     &                    NBOUNC,DONALL)                                  40.05
C             check if the grid points are on nested boundary.
C             if not, stop the calculation and give an error message
              IF (NBGRPT.NE.NBGRPT_PREV) THEN                             40.05
                IIPT2 = IIPT2+1                                           40.05
              ENDIF                                                       40.05
            ENDIF
          ENDDO
C
          IF ((BCTYPE .EQ. 'NEST').AND. (IIPT2.EQ.0)) CALL MSGERR (2,
     &      'no grid points on nested boundary')                          40.05
C
          NHEDF = NHEDF + 2 + NBOUNC
          IF (ITEST.GE.60) WRITE (PRTEST,16) NBOUNC
  16      FORMAT (I6, ' boundary locations')
          READ (NDSD, '(A)') HEDLIN
          IF (ITEST.GE.60) WRITE (PRTEST,11) HEDLIN
        ELSE
          IF (BCTYPE .EQ. 'NEST') THEN
            CALL MSGERR (3, 'this file is not a true nesting file')
          ENDIF
          NBOUNC = 1
        ENDIF
*
*       read spectral resolution information
*
*       number of spectral frequencies
        IF (EQCSTR(HEDLIN(2:5),'FREQ')) THEN                              40.03
          READ (NDSD, *) NFRE
          IERR = 0
          CALL DPEXPR (BSPFRQ, NBFILS, NFRE, IBSPFR, IERR)
          IF (STPNOW()) RETURN                                            34.01
          DO IFRE = 1, NFRE
*           read frequency in Hz and convert to radians/sec
            READ (NDSD, *) FREQHZ
            RBSFRQ(IBSPFR+IFRE) = PI2 * FREQHZ                            30.90
          ENDDO
          READ (NDSD, '(A)') HEDLIN
          IF (ITEST.GE.60) WRITE (PRTEST,11) HEDLIN                       40.00
          NHEDF = NHEDF + 2 + NFRE
        ELSE
          NFRE = 0
          IF (BCTYPE.EQ.'NEST') THEN
            CALL MSGERR (3, 'file is not a true nesting file')
          ENDIF
        ENDIF
        IF (ITEST.GE.60) WRITE (PRTEST,19) NFRE                           40.00
  19    FORMAT (I6, ' boundary frequencies')
*       number of spectral directions
        IF (EQCSTR(HEDLIN(2:4),'DIR')) THEN                               40.03
          READ (NDSD, *) NANG
          IERR = 0
          CALL DPEXPR (BSPDIR, NBFILS, NANG, IBSPDR, IERR)
          IF (STPNOW()) RETURN                                            34.01
          DO IANG = 1, NANG
*           read direction in degr and convert to radians
            READ (NDSD, *) DIRDEG
            IF (EQCSTR(HEDLIN,'N')) THEN                                  40.03
              DIRDEG = 180. + DNORTH - DIRDEG
            ENDIF
            DIRRAD = DIRDEG * PI / 180.
*           reverse order if second direction is smaller than first
            IF (IANG.EQ.1) THEN
              DIRRD1 = DIRRAD
            ELSE IF (IANG.EQ.2) THEN
              IF (DIRRAD.LT.DIRRD1) THEN
                DORDER = -1
                RBSDIR(IBSPDR+NANG) = DIRRD1                              30.90
              ELSE
                DORDER = 1
              ENDIF
              DIRRD1 = DIRRAD
            ELSE
              IF (DORDER.LT.0.) THEN
                IF (DIRRAD.GT.DIRRD1) CALL MSGERR (3,
     &          'spectral directions in file not in right order')
              ELSE
                IF (DIRRAD.LT.DIRRD1) CALL MSGERR (3,
     &          'spectral directions in file not in right order')
              ENDIF
              DIRRD1 = DIRRAD
            ENDIF
            IF (DORDER.LT.0) THEN
              RBSDIR(IBSPDR+NANG+1-IANG) = DIRRAD                         30.90
            ELSE
              RBSDIR(IBSPDR+IANG) = DIRRAD                                30.90
            ENDIF
          ENDDO
          READ (NDSD, '(A)') HEDLIN
          IF (ITEST.GE.60) WRITE (PRTEST,11) HEDLIN
          NHEDF = NHEDF + 2 + NANG
          NHEDS = 1
        ELSE
          NANG   = 0
          NHEDS  = 1
          DORDER = 0
        ENDIF
        IF (ITEST.GE.60) WRITE (PRTEST,23) NANG                           40.00
  23    FORMAT (I6, ' boundary directions')
*
*       read quantities (name, unit, exc. value)
*
        IF (EQCSTR(HEDLIN,'QUANT')) THEN
          READ (NDSD, *) NQUANT
          IF (.NOT.((NQUANT.EQ.1 .AND. NANG.GT.0) .OR.
     &              (NQUANT.EQ.3 .AND. NANG.EQ.0))) THEN
            CALL MSGERR (2, 'incompatible data on b.c. file')
            WRITE (PRINTF, 31) NQUANT, NANG
  31        FORMAT (I3, ' quantities; ', I5, ' directions')
          ENDIF
          DO IQUANT = 1, NQUANT
            READ (NDSD, '(A)') HEDLIN
*           if first quantity is 'EnDens' divide by Rho*Grav
            IF (IQUANT.EQ.1) THEN
              IF ( EQCSTR(HEDLIN,'ENDENS')) THEN                          40.03
*               quantity on file is energy density
                BFILED(17) = 1
              ELSE IF ( EQCSTR(HEDLIN,'VADENS')) THEN                     40.03
*               quantity on file is variance density
                BFILED(17) = 2
              ELSE
                CALL MSGERR (2,
     &          'Incorrect quantity in b.c.file: ' // HEDLIN(1:10))       40.03
                BFILED(17) = 2
              ENDIF
            ELSE IF (IQUANT.EQ.2) THEN                                    40.00
*             if second quantity is 'NDIR' transform from Nautical to Cartesian dir.
              IF ( EQCSTR(HEDLIN,'NDIR')) THEN                            40.03
*               quantity on file is Nautical direction
                BFILED(18) = 2
              ELSE IF (EQCSTR(HEDLIN,'CDIR')) THEN                        40.03
*               quantity on file is Cartesian direction
                BFILED(18) = 1
              ELSE
                CALL MSGERR (2,
     &          'Incorrect quantity in b.c.file: ' // HEDLIN(1:10))       40.03
                BFILED(18) = 1
              ENDIF
            ELSE IF (IQUANT.EQ.3) THEN                                    40.00
*             if third quantity is 'DSPRP' or 'POWER' power is given,
*             otherwise calculate power from dir. spread in degrees
              IF (EQCSTR(HEDLIN,'DSPRP') .OR.
     &            EQCSTR(HEDLIN,'POWER')) THEN                            40.03
*               quantity on file is power of cos
                BFILED(19) = 2
              ELSE IF (EQCSTR(HEDLIN,'DSPR') .OR.
     &                 EQCSTR(HEDLIN,'DEGR')) THEN                        40.03
*               quantity on file is Directional spread in degr
                BFILED(19) = 1
              ELSE
                CALL MSGERR (2,
     &          'Incorrect quantity in b.c.file: ' // HEDLIN(1:10))       40.03
                BFILED(19) = 1
              ENDIF
            ENDIF
*           check Unit and ignore Exception value:
            READ (NDSD, '(A)') HEDLIN
            IF (IQUANT.EQ.3 .AND. EQCSTR(HEDLIN,'DEGR')) THEN
              IF (BFILED(19).NE.1) THEN
                CALL MSGERR (2, 'incompatible options in boundary file')
                BFILED(19) = 1
              ENDIF
            ENDIF
            READ (NDSD, '(A)') HEDLIN
          ENDDO
          NHEDF = NHEDF + 2 + 3*NQUANT
        ENDIF
        IF (ITEST.GE.60) WRITE (PRTEST,28) NQUANT                         40.00
  28    FORMAT (I6, ' quantities')
*
*       enlarge the pool to contain aux. array for spectral interpolation
*
        IERR = 0
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               NANG*NFRE, IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MDC*MAX(MSC,NFRE), IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        PNAME = '    '
        CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
        IF (STPNOW()) RETURN                                              34.01
      ELSE
        CALL MSGERR (3, 'unsupported boundary data file')
      ENDIF
*
*     enlarge the pool to contain boundary value arrays
*
      IERR = 0
      CALL DPEXPR (BSPLOC, NBFILS, NBOUNC, IBSPLC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      DO IBC = 1, NBOUNC
        BSPLOC(IBSPLC+IBC) = NBSPEC + IBC
      ENDDO
      NBSPEC = NBSPEC + NBOUNC
*
*     store file reading parameters in array BFILED
*
      BFILED(1)  = ISTATF
      BFILED(2)  = -999999999
      BFILED(3)  = -999999999
      BFILED(4)  = NDSL
      BFILED(5)  = NDSD
      BFILED(6)  = IOPTT
      CALL COPYCH (BTYPE, 'T', BFILED(7), 1, IERR)
      BFILED(8)  = NBOUNC
      BFILED(9)  = DORDER
      BFILED(10) = NANG
      BFILED(11) = 0
      BFILED(12) = NFRE
*     ordering of data on file
      BFILED(13) = 0
*     number of heading lines: per file, per time, per spectrum
      BFILED(14) = NHEDF
      BFILED(15) = NHEDT
      BFILED(16) = NHEDS
*
      CALL DPMINR (BSPAUX, NBFILS, LL, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
      IF (ITEST.GE.80) WRITE(PRINTF,81) NBFILS, NBSPEC,
     &      (BFILED(II), II=1,16)
  81  FORMAT (' array BFILED: ', 2I4, 2(/,8I10))
*
      RETURN
*     end of subroutine BCFILE
      END
**********************************************************************
*                                                                    *
      SUBROUTINE BCWAMN (FBCNAM, BCTYPE, BFILED, BSPLOC, BSPDIR, RBSDIR,  30.90
     &                   BSPFRQ, RBSFRQ, BGRIDP, BSPAUX, RBSAUX, XCGRID,  30.90
     &                   YCGRID, KGRPNT, XYTST)
*                                                                    *
**********************************************************************
 
      IMPLICIT NONE                                                       40.13
 
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
C     30.73: Nico Booij
C     30.90: IJsbrand Haagsma (Equivalence version)
C     34.01: Jeroen Adema
C     40.03: Nico Booij
!     40.13: N. Booij
C
*  1. Updates
*
*     30.73, Jan. 98: new subroutine, based on older version by Weimin Luo
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Nov. 99: THD (first spectral direction in radians) added in
C                     expression for RBSDIR (directions of boundary spectrum)
C     40.03, Aug. 00: correction WAM nest with spherical SWAN
!     40.13, May  01: order of boundary points in WAM nesting file differed
!                     from order assumed in SWAN
*
*  2. PURPOSE
*
*       reads file data for WAM nesting boundary condition
*
*  3. METHOD
*
*
*  4. Argument variables
C
C i/o RBSAUX: Real EQUIVALENCE of BSPAUX                                  30.90
C i/o RBSDIR: Real EQUIVALENCE of BSPDIR                                  30.90
C i/o RBSFRQ: Real EQUIVALENCE of BSPFRQ                                  30.90
C
      REAL RBSAUX(*)                                                      30.90
      REAL RBSDIR(*)                                                      30.90
      REAL RBSFRQ(*)                                                      30.90
C
C i/o BSPDIR: Spectral directions of input spectrum                       30.90
C i/o BSPFRQ: Spectral frequencies of input spectrum                      30.90
C i/o BSPAUX: Auxiliary array used for interpolation                      30.90
C
      INTEGER BSPAUX(*)                                                   30.90
      INTEGER BSPDIR(*)                                                   30.90
      INTEGER BSPFRQ(*)                                                   30.90
*
*       FBCNAM  char  inp    filename of boundary data file
*       BCTYPE  char  inp    if value is "NEST": nesting b.c.
*       BFILED  int   i/o    data concerning boundary condition files
*       BSPLOC  int   i/o    place in array BSPECS where to store
*                            interpolated spectra
*       BGRIDP  int   i/o    data concerning boundary grid points
*       XCGRID  real  inp    x-coordinate of computational grid points
*       YCGRID  real  inp    y-coordinate of computational grid points
*       KGRPNT  int   inp    indirect addresses of grid points
*       XYTST   int   inp    ix, iy of test points
*
*  5. SUBROUTINES CALLING
*
*       SWBOUN
*
*  6. SUBROUTINES USED
*
*       Ocean Pack command reading and data pool management routines
*
      LOGICAL :: STPNOW                                                   34.01
 
 
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       data concerning boundary files are stored in array BFILED
*       there is a subarray for each file; it contains:
*       1.  status; 0: stationary, 1: nonstat, -1: exhausted
*       2.  time of boundary values read one before last
*       3.  time of boundary values read last
*       4.  NDSL: unit ref. num. of file containing filenames
*       5.  NDSD: unit ref. num. of file containing data
*       6.  time coding option for reading time from data file
*       8.  number of locations for which spectra are in the file
*       9.  order of reading directional information
*       10. number of spectral directions of spectra on file
*       12. number of spectral frequencies
*       14. number of heading lines per file
*       15. number of heading lines per time step
*       16. number of heading lines per spectrum
*       17. =1: energy dens., =2: variance density
*
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       Open file containing filnames
*       Read data file name
*       Open boundary condition data file
*       Read number of b.points, frequencies and directions
*       Generate spectral directions from file into array BSPDIR
*       Generate spectral frequencies from file into array BSPFRQ
*       For all boundary spectra do
*           read location from data file
*           transform into local cartesian or spherical coordinates       40.13
!       -----------------------------------------------------------------
!       Determine spatial step size in WAM nesting file                   40.13
!       For all spatial points in WAM file do                             40.13
!           For all other spatial points in WAM file do                   40.13
!               If the two points are neighbours                          40.13
!               Then For all computational grid points on boundary do
*                        if point is located between nest file grid points
*                        calculate interpolation coefficients
*                        and put these into array BGRIDP
*       -----------------------------------------------------------------
*       Write file characteristics into array BFILED
*       -----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      REAL, PARAMETER :: DEQMET=40000000./360.  ! conversion degr to m    40.13
 
      INTEGER   BFILED(*), KGRPNT(MXC,MYC), BGRIDP(*), BSPLOC(*),
     &          XYTST(*)
      REAL      XCGRID(MXC,MYC), YCGRID(MXC,MYC)
      CHARACTER FBCNAM *(*), BCTYPE *(*)
C
C     local variables
C
      INTEGER   ISTATF, NDSL, NDSD, IOSTAT, IERR, NBOUNC, NANG, NFRE,
     &          IBOUNC, IX1, IY1, IX2, IY2, IXP, IYP, IP, MIP, INDXGR,
     &          DORDER, IOPTT, IPINDX
C     ISTATF    if >0 file contains nonstationary data
C     NDSL      unit ref num of namelist file
C     NDSD      unit ref num of data file
C     IOSTAT    io status
C     IERR      error status
C     NBOUNC    number of boundary locations
C     NANG      number of directions on file
C     NFRE      number of frequencies on file
C     IBOUNC    counter of boundary spectra
C     IX1
C     IY1
C     IX2
C     IY2
C     IXP
C     IYP
C     IP
C     MIP
C     INDXGR    counter of boundary grid points
C     DORDER    if <0 order of reading directions is reversed
C     IOPTT     time reading option
C     IPINDX    sequence number of a dynamic array
 
      INTEGER :: IIPT1=0, IIPT2=0
!     local and overall number of interpolated boundary grid points
 
      INTEGER :: IBSPLC, IBSPFR, IBSPDR, IAUXW                            40.13
      INTEGER :: NHEDF       ! number of heading lines at begin of file   40.13
      INTEGER :: NHEDT       ! number of heading lines per time step      40.13
      INTEGER :: NHEDS       ! number of heading lines                    40.13
      INTEGER :: IBC, IDW, ISW, IFRE, II, ISIDE, IHD    ! counters
      INTEGER :: IBNC1, IBNC2   ! counters of nesting points
      INTEGER :: IBSP1, IBSP2   ! counters of nesting points
      INTEGER :: LL
 
      REAL      XP, YP, XP1, YP1, XP2, YP2, RR, RX, RY, RL2,
     &          XANG, XFRE, THD, FR1, CO, XBOU, XDELC,
     &          XLON, XLAT, XDATE, EMEAN, THQ, FMEAN, USNEW, THWNEW
C     XP        problem coordinate of a comp. grid point on the boundary
C     YP        problem coordinate of a comp. grid point on the boundary
C     XP1       problem coordinate of a boundary location
C     YP1       problem coordinate of a boundary location
C     XP2       problem coordinate of a boundary location
C     YP2       problem coordinate of a boundary location
C     RR
C     RX        vector connecting two boundary locations
C     RY        vector connecting two boundary locations
C     RL2       length **2 of vector connecting two boundary locations
 
      DOUBLE PRECISION, ALLOCATABLE :: XPWAM(:), YPWAM(:)
      ! locations of nesting points                                       40.13
      DOUBLE PRECISION :: DXWAM, DYWAM   ! spatial step sizes in nesting file   40.13
      DOUBLE PRECISION :: DXTEST, DYTEST ! distance between two nesting points  40.13
      REAL :: DISXY          ! dim.less distance                          40.13
      REAL :: PHI            ! direction of vector (RX,RY)                40.13
      REAL :: DPHI           ! difference in direction                    40.13
      REAL :: EPS            ! tolerance                                  40.13
      REAL :: W2             ! interpolation coefficient                  40.13
 
 
      CHARACTER (LEN=4)  :: BTYPE     ! type of boundary cond.
      CHARACTER (LEN=10) :: CDATE     ! date-time
      CHARACTER (LEN=80) :: HEDLIN    ! heading line
      CHARACTER (LEN=8)  :: PNAME     ! pointer name (for dynamic data pool)
 
      DOUBLE PRECISION :: DDATE, XLON0, XLAT0
C     DDATE     date-time
C     XLON0     longitude of origin of computational grid
C     XLAT0     latitude of origin of computational grid
 
!     subroutines used
 
      INTEGER :: IADRS
      LOGICAL :: KEYWIS
 
 
      INTEGER, SAVE :: IENT = 0                                           40.13
      CALL STRACE (IENT, 'BCWAMN')
*
      ISTATF = 1
      IOPTT = 6
      NDSL = 0
*     open file with list of names
      CALL FOR (NDSL, FILENM,'OF',IOSTAT)
      IF (STPNOW()) RETURN                                                34.01
      READ (NDSL,'(A36)') FILENM
      CALL INKEYW ('REQ', ' ')
      IF (KEYWIS('FRE')) THEN
        BTYPE = 'WAMF'
      ELSE IF (KEYWIS('UNF')) THEN
        CALL INKEYW ('REQ', ' ')
        IF (KEYWIS('WK')) THEN
          BTYPE = 'WAMW'
        ELSE
          CALL IGNORE ('CRAY')
          BTYPE = 'WAMC'
        ENDIF
      ENDIF
*     open WAM data file
      NDSD=0
      IOSTAT = 0
      IF (BTYPE.EQ.'WAMF') THEN
        CALL FOR(NDSD,FILENM,'OF',IOSTAT)
        IF (STPNOW()) RETURN                                              34.01
      ELSE
        CALL FOR(NDSD,FILENM,'OU',IOSTAT)
        IF (STPNOW()) RETURN                                              34.01
      ENDIF
*
*     generate pointers for data subarrays
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPLOC, PNAME, IPINDX, 'S', IBSPLC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPLOC')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPFRQ, PNAME, IPINDX, 'S', IBSPFR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPFRQ')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPDIR, PNAME, IPINDX, 'S', IBSPDR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPDIR')
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPAUX, PNAME, IPINDX, 'P', IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPAUX')
      CALL DPEXPR (BSPAUX, NBFILS, 10*MSC*MDC, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
*     temporary increase of IAUXW in order to use BSPAUX
*     locally as aux. array
      IAUXW = IAUXW+8
*
*     read spherical coordinates of point corresponding to
*     [xpc], [ypc] in Cartesian coordinates
*     not necessary if SWAN uses spherical coordinates                    40.03
*     if not given first point in data file is assumed
      CALL INDBLE('XGC',XLON0,'STA',-999.D0)                              40.01
      CALL INDBLE('YGC',XLAT0,'STA',-999.D0)                              40.01
*
*     start reading from the data file
*
*
*     read resolution information from WAM input
*
      IF (BTYPE.EQ.'WAMF') THEN
        READ (NDSD,*) XANG, XFRE, THD, FR1, CO, XBOU, XDELC
      ELSE
*       Cray and workstation version
        READ (NDSD) XANG, XFRE, THD, FR1, CO, XBOU, XDELC
      ENDIF
*
*     number of WAM boundary points
      NBOUNC  = NINT(XBOU)
*     number of direction of WAM spectrum
      NANG = NINT(XANG)
      DORDER = -1
*     number of frequencies of WAM spectrum
      NFRE = NINT(XFRE)
*     number of heading lines: per file, per time, per spectrum
      NHEDF = 1
      NHEDT = 0
      NHEDS = 1
      IF (ITEST.GE.80) THEN
        WRITE(PRINTF,*) ' Number of frequencies in WAM:',NFRE
        WRITE(PRINTF,*) ' Number of directions in WAM:',NANG
        WRITE(PRINTF,*) ' Lowest frequency in WAM:',FR1
        WRITE(PRINTF,*) ' fi/fi-1 in WAM:',CO
      ENDIF
*
*     add to the pool the boundary value arrays ***
*
      IERR = 0
      CALL DPEXPR (BSPLOC, NBFILS, NBOUNC, IBSPLC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      DO IBC = 1, NBOUNC
        BSPLOC(IBSPLC+IBC) = NBSPEC + IBC
      ENDDO
*
*     convert WAM wave directions to SWAN convention
*     apparently WAM uses direction TO which waves propagate !!
*
      IERR = 0
      CALL DPEXPR (BSPDIR, NBFILS, NANG, IBSPDR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      DO  IDW = NANG,1,-1
        RBSDIR(IBSPDR+NANG-IDW+1) = DNORTH*DEGRAD -                       30.90
     &                 THD - REAL(IDW-1)*PI2/REAL(NANG)                   40.03
      ENDDO
      IF (ITEST.GE.50) WRITE (PRTEST,132) NANG,
     &          (RBSDIR(IBSPDR+IDW)*180./PI, IDW=1,NANG)                  30.90
 132  FORMAT (' WAMNEST dirs ', I3, (/, 20F6.0))
      IERR = 0
*
*     calculate WAM angular frequency array
*
      CALL DPEXPR (BSPFRQ, NBFILS, NFRE, IBSPFR, IERR)
      IF (STPNOW()) RETURN                                                34.01
      RBSFRQ(IBSPFR+1) = PI2*FR1                                          30.90
      DO  ISW = 2, NFRE
        RBSFRQ(IBSPFR+ISW) = CO * RBSFRQ(IBSPFR+ISW-1)                    30.90
      ENDDO
      IF (ITEST.GE.50) WRITE (PRTEST,133) NFRE,
     &          (RBSFRQ(IBSPFR+ISW)*180./PI, ISW=1,NFRE)                  30.90
 133  FORMAT (' WAMNEST freqs ', I3, (/, 20F6.2))
      IF (NBOUNC.EQ.1) CALL MSGERR (3,
     &     'WAM nest does not work with only one nesting point')          40.13
 
!     allocate arrays XPWAM and YPWAM
 
      ALLOCATE (XPWAM(1:NBOUNC), YPWAM(1:NBOUNC))                         40.13
 
*     read geographical locations and determine DXWAM and DYWAM           40.13
 
      IIPT2 = 0                                                           40.03
      DXWAM = 180.
      DYWAM = 180.
      DO IBOUNC = 1, NBOUNC
        IF (BTYPE.EQ.'WAMF') THEN
*         read boundary point coordinates from file
          READ(NDSD,*) XLON, XLAT, DDATE, EMEAN,
     &               THQ, FMEAN, USNEW, THWNEW
          IF (IBOUNC.EQ.1 .AND. ITEST.GE.80) WRITE (PRTEST, *)            40.13
     &          ' WAMNEST starting time ', DDATE                          40.13
*         read spectral densities but ignore them for the moment
          DO IFRE=1,NFRE
            READ(NDSD,*) (RBSAUX(IAUXW+II), II=1,NANG)                    30.90
          ENDDO
        ELSE IF (BTYPE.EQ.'WAMC') THEN
*         read boundary point coordinates from file
          READ(NDSD) XLON, XLAT, XDATE, EMEAN,
     &               THQ, FMEAN, USNEW, THWNEW
          IF (IBOUNC.EQ.1 .AND. ITEST.GE.80) WRITE (PRTEST, *)            40.13
     &          ' WAMNEST starting time ', XDATE                          40.13
*         read spectral densities but ignore them for the moment
          READ(NDSD) (RBSAUX(IAUXW+II), II=1,NANG*NFRE)                   30.90
        ELSE
*         read boundary point coordinates from file
          READ(NDSD) XLON, XLAT, CDATE, EMEAN, THQ, FMEAN, USNEW, THWNEW
          IF (IBOUNC.EQ.1 .AND. ITEST.GE.80) WRITE (PRTEST, *)            40.13
     &          ' WAMNEST starting time ', CDATE                          40.13
*         read spectral densities but ignore them for the moment
          READ(NDSD) (RBSAUX(IAUXW+II), II=1,NANG*NFRE)                   30.90
        ENDIF
        IF (ITEST.GE.50) WRITE (PRINTF, 178) IBOUNC, XLON, XLAT           40.13
 178    FORMAT (' boundary spectrum ', I3, ' at ', 2F12.4)                40.13
        XPWAM(IBOUNC) = XLON                                              40.13
        YPWAM(IBOUNC) = XLAT                                              40.13
!       determine DXWAM and DYWAM                                         40.13
        IF (IBOUNC.GT.1) THEN                                             40.13
          IF (ABS(XPWAM(IBOUNC)-XPWAM(IBOUNC-1)).GT.1.E-6)                40.13
     &    DXWAM = MIN (DXWAM, ABS(XPWAM(IBOUNC)-XPWAM(IBOUNC-1)))         40.13
          IF (ABS(YPWAM(IBOUNC)-YPWAM(IBOUNC-1)).GT.1.E-6)                40.13
     &    DYWAM = MIN (DYWAM, ABS(YPWAM(IBOUNC)-YPWAM(IBOUNC-1)))         40.13
        ENDIF
        IF (KSPHER.EQ.0) THEN                                             33.09
*         determine lower left corner of WAM nesting grid if not given by the user
          IF (IBOUNC.EQ.1) THEN
            IF (XLON0.LT.-900.) THEN
              XLON0 = XLON
              XLAT0 = XLAT
            ENDIF
          ENDIF
        ENDIF
      ENDDO                                                               40.13
      IF (ITEST.GE.50) WRITE (PRINTF, 182) DXWAM, DYWAM                   40.13
 182  FORMAT (' WAM step sizes: ', 2F12.4)                                40.13
      EPS = 0.01 * MIN(DXWAM,DYWAM)                                       40.13
 
!     determine interpolation coefficients for all couples of             40.13
!     neighbouring WAM nest points                                        40.13
 
      DO IBNC1 = 1, NBOUNC
 160    DO IBNC2 = IBNC1+1, NBOUNC                                        40.13
          DXTEST = ABS(XPWAM(IBNC1)-XPWAM(IBNC2))                         40.13
          DYTEST = ABS(YPWAM(IBNC1)-YPWAM(IBNC2))                         40.13
          IF ((DXTEST.LT.EPS .AND. ABS(DYTEST-DYWAM).LT.EPS) .OR.         40.13
     &        (DYTEST.LT.EPS .AND. ABS(DXTEST-DXWAM).LT.EPS)) THEN        40.13
!           points IBNC1 and IBNC2 are neighbours                         40.13
            IF (KSPHER.EQ.0) THEN                                         33.09
*             transform to local Cartesian coordinates
              XP1 = XPC + DEQMET*COS(PI*XLAT0/180.)*(XPWAM(IBNC1)-XLON0)  40.13
              YP1 = YPC + DEQMET*(YPWAM(IBNC1)-XLAT0)                     40.13
              XP2 = XPC + DEQMET*COS(PI*XLAT0/180.)*(XPWAM(IBNC2)-XLON0)  40.13
              YP2 = YPC + DEQMET*(YPWAM(IBNC2)-XLAT0)                     40.13
            ELSE
              XP1 = XPWAM(IBNC1) - XOFFS                                  40.13
              YP1 = YPWAM(IBNC1) - YOFFS                                  40.13
              XP2 = XPWAM(IBNC2) - XOFFS                                  40.13
              YP2 = YPWAM(IBNC2) - YOFFS                                  40.13
            ENDIF
*           Determine interpolation coefficients
            IBSP1 = NBSPEC+IBNC1                                          40.13
            IBSP2 = NBSPEC+IBNC2                                          40.13
            IIPT1 = 0                                                     40.03
            RX  = XP2 - XP1
            RY  = YP2 - YP1
            RL2 = RX**2 + RY**2
            IF (RL2.GT.0.) THEN
              RX  = RX/RL2
              RY  = RY/RL2
*             check whether direction of (RX,RY) corresponds to ALPC + k * 90 degr
              PHI = ATAN2(RY,RX)
              DPHI = MOD(PHI-ALPC+1.25*PI,0.5*PI)-0.25*PI
              IF (ABS(DPHI) .LT. 0.1) THEN
*               loop over boundary of comp. grid, select points between
*               (XP1,YP1) and (XP2,YP2)
                DO ISIDE = 1, 4
                  IF (ISIDE.EQ.1) THEN
                    IX1 = 1
                    IY1 = 1
                    IX2 = MXC
                    IY2 = 1
                    MIP = MXC
                  ELSE IF (ISIDE.EQ.2) THEN
                    IX1 = MXC
                    IY1 = 1
                    IX2 = MXC
                    IY2 = MYC
                    MIP = MYC
                  ELSE IF (ISIDE.EQ.3) THEN
                    IX1 = MXC
                    IY1 = MYC
                    IX2 = 1
                    IY2 = MYC
                    MIP = MXC
                  ELSE IF (ISIDE.EQ.4) THEN
                    IX1 = 1
                    IY1 = MYC
                    IX2 = 1
                    IY2 = 1
                    MIP = MYC
                  ENDIF
                  DO IP = 1, MIP-1
                    RR  = REAL(IP-1) / REAL(MIP-1)
                    IXP = IX1 + NINT(RR*REAL(IX2-IX1))
                    IYP = IY1 + NINT(RR*REAL(IY2-IY1))
                    INDXGR = KGRPNT(IXP,IYP)
                    IF (INDXGR.GT.1) THEN
                      XP = XCGRID(IXP,IYP)
                      YP = YCGRID(IXP,IYP)
*                     DISXY is relative distance from (XP,YP) to line
*                     (XP1,YP1) to (XP2,YP2)
                      DISXY = ABS(RX*(YP-YP1)-RY*(XP-XP1))
                      IF (DISXY.LT.0.1) THEN
*                       W2 is relative length of projection on line
*                       (XP1,YP1) to (XP2,YP2)
                        W2 = RX*(XP-XP1)+RY*(YP-YP1)
                        IF (W2.GT.-0.001 .AND. W2.LT.1.001) THEN
                          IF (W2.LT.0.01) W2 = 0.
                          IF (W2.GT.0.99) W2 = 1.
                          IF (ITEST.GE.80) WRITE (PRTEST, 223) IXP, IYP,
     &                          XP+XOFFS, YP+YOFFS, W2, IBNC1, IBNC2        40.13
 223                      FORMAT (' B.pnt', 2I5, 2F14.4, F6.3,
     &                            ' from ', 2I3)                            40.13
                          NBGRPT = NBGRPT + 1
                          IIPT1 = IIPT1 + 1                                 40.03
                          IIPT2 = IIPT2 + 1                                 40.03
                          BGRIDP(6*NBGRPT-5) = INDXGR
*                         next item indicates type of boundary condition
                          BGRIDP(6*NBGRPT-4) = 1
                          BGRIDP(6*NBGRPT-3) = NINT(1000. * W2)
                          BGRIDP(6*NBGRPT-2) = IBSP2
                          BGRIDP(6*NBGRPT-1) = NINT(1000. * (1.-W2))
                          BGRIDP(6*NBGRPT)   = IBSP1
*                         test output if point is a test point
                          IF (NPTST.GT.0) THEN
                            DO IPTST = 1, NPTST
                              IF (IXP.EQ.XYTST(2*IPTST-1) .AND.
     &                            IYP.EQ.XYTST(2*IPTST))
     &                        WRITE (PRTEST, 223) IXP, IYP,
     &                        XP+XOFFS, YP+YOFFS, W2, IBSP2, IBSP1
                            ENDDO
                          ENDIF
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDDO
                ENDDO
              ENDIF
            ENDIF
            IF (IIPT1.EQ.0) THEN
              WRITE (PRINTF, 218) XP1+XOFFS, YP1+YOFFS,
     &                            XP2+XOFFS, YP2+YOFFS
 218          FORMAT (' Warning: no grid points on interval from ',         40.03
     &              2F14.4, ' to ', 2F14.4)
            ENDIF
          ENDIF
        ENDDO                                                             40.13
!       first nesting point may have two valid neighbours                 40.13
        IF (IBNC1.EQ.1 .AND. IBNC2.EQ.2) GOTO 160                         40.13
      ENDDO
      IF (IIPT2.EQ.0) CALL MSGERR (2,
     &  'no grid points on nested boundary')                              40.03
      IF (ITEST.GE.60) WRITE (PRTEST,16) NBOUNC
  16  FORMAT (I6, ' boundary locations')
 
!     deallocate arrays XPWAM and YPWAM
 
      DEALLOCATE (XPWAM, YPWAM)                                           40.13
 
*     enlarge the pool to contain aux. array for spectral interpolation
*
      IERR = 0
      PNAME = '    '
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               NANG*NFRE, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = '    '
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MDC*NFRE, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = '    '
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      PNAME = '    '
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), PNAME, IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
*     enlarge the pool to contain boundary value arrays
*
      IERR = 0
      CALL DPEXPR (BSPLOC, NBFILS, NBOUNC, IBSPLC, IERR)
      IF (STPNOW()) RETURN                                                34.01
      DO IBC = 1, NBOUNC
        BSPLOC(IBSPLC+IBC) = NBSPEC + IBC
      ENDDO
      NBSPEC = NBSPEC + NBOUNC
*
*     store file reading parameters in array BFILED
*
      BFILED(1)  = ISTATF
      BFILED(2)  = -999999999
      BFILED(3)  = -999999999
      BFILED(4)  = NDSL
      BFILED(5)  = NDSD
      BFILED(6)  = IOPTT
      CALL COPYCH (BTYPE, 'T', BFILED(7), 1, IERR)
      BFILED(8)  = NBOUNC
      BFILED(9)  = DORDER
      BFILED(10) = NANG
      BFILED(11) = 0
      BFILED(12) = NFRE
*     ordering of data on file
      BFILED(13) = 0
*     number of heading lines: per file, per time, per spectrum
      BFILED(14) = NHEDF
      BFILED(15) = NHEDT
      BFILED(16) = NHEDS
*     quantity on file is variance density
      BFILED(17) = 2
*
      CALL DPMINR (BSPAUX, NBFILS, LL, IAUXW, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
      IF (ITEST.GE.80) WRITE(PRINTF,81) NBFILS, NBSPEC,
     &      (BFILED(II), II=1,16)
  81  FORMAT (' array BFILED: ', 2I4, 2(/,8I10))
*
*     Rewind input file for proper start
      REWIND (NDSD)
*     read heading line
      IF (BTYPE.EQ.'WAMF') THEN
        DO IHD = 1, BFILED(14)
          READ (NDSD, '(A)') HEDLIN
          IF (ITEST.GE.80) WRITE (PRINTF, 212) HEDLIN
 212      FORMAT (' heading line: ', A)
        ENDDO
      ELSE
        DO IHD = 1, BFILED(14)
          READ (NDSD)
        ENDDO
      ENDIF
 
      RETURN
      END subroutine BCWAMN
 
**********************************************************************
*                                                                    *
      SUBROUTINE BCWW3N (FBCNAM, BCTYPE, BFILED, BSPLOC, BSPDIR,RBSDIR,
     &                   BSPFRQ, RBSFRQ, BGRIDP, BSPAUX, XCGRID,YCGRID,
     &                   KGRPNT, XYTST,  KGRBND, DONALL)
*                                                                    *
**********************************************************************
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm2.inc'
      INCLUDE 'ocpcomm4.inc'
      INCLUDE 'swcomm2.inc'
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
C
C
C  0. Authors
C
C     40.05 : Ekaterini E. Kriezi
C     40.13 : Nico Booij
C
C  1. Updates
C
C     40.05, Aug. 00: new subroutine
C     40.13, Jan. 01: remove declarations of unused variables
C
C  2. Purpose
C
C      reads file data for wavewacthIII  boundary condition
C
C  3. Methode
C
C      open boundaries files
C      read from ASSCII files the points where the energy desity is given and
C      interpolate them to the grid pionts of the swan-computational  grid using
C      subroutine BC_POINTS
C
C  4. Argument variables
C
C     RBSAUX: Real EQUIVALENCE of BSPAUX
C     RBSDIR: Real EQUIVALENCE of BSPDIR
C     RBSFRQ: Real EQUIVALENCE of BSPFRQ
C
C
      REAL,    INTENT(INOUT)  :: RBSDIR(*)
      REAL,    INTENT(INOUT)  :: RBSFRQ(*)
C
C     BSPAUX: Auxiliary array used for interpolation
C     BSPDIR: Spectral directions of input spectrum
C     BSPFRQ: Spectral frequencies of input spectrum
C
      INTEGER, INTENT(INOUT)  :: BSPAUX(*)
      INTEGER, INTENT(INOUT)  :: BSPDIR(*)
      INTEGER, INTENT(INOUT)  :: BSPFRQ(*)
C
C     BFILED  data concerning boundary condition files
C     BSPLOC  place in array BSPECS where to store interpolated spectra
C     BGRIDP  data concerning boundary grid points
C
      INTEGER, INTENT(INOUT)  ::  BFILED(*)
      INTEGER, INTENT(INOUT)  ::  BGRIDP(*)
      INTEGER, INTENT(INOUT)  ::  BSPLOC(*)
C
      INTEGER, INTENT(IN)     ::  KGRPNT(MXC,MYC)
C                                 indirect addresses of computational grid points
      INTEGER, INTENT(IN)     ::  KGRBND(*)
C                                 array of boundary grid points
      INTEGER, INTENT(IN)     ::  XYTST(*)
C                                 array of (ix,iy) of test points
      REAL, INTENT(IN)        ::  XCGRID(MXC,MYC), YCGRID(MXC,MYC)
C                                 coordinates of computational grid points
C     FBCNAM  char  inp    filename of boundary data file
C     BCTYPE  char  inp    boundary condition type, is 'WW3N' in this case
C
      CHARACTER FBCNAM *(*), BCTYPE *(*)
C
C     DONALL : logic arguments declare if the boundary is open or close
C
      LOGICAL   :: DONALL
C
C  5. Parameter variables
C
C     --
C
C  6. Local variables
C
C     IENT         number of entries into this subroutine
C     IBC          spectrum counter
C     IBSPLC       array location
C     IBSPFR       array location
C     IBSPDR       array location
C     IAUXW        array location
C
      INTEGER   :: IENT, IBC, IBSPLC, IBSPFR, IBSPDR, IAUXW
C
      REAL,    ALLOCATABLE :: FRQ_ARRAY(:), DIR_ARRAY(:)
C
C     IHD          counter of heading lines
C     WWDATE       date in boundary file
C     WWTIME       time in boundary file
C
      INTEGER   :: WWDATE, WWTIME
C
C     ISTATF    if >0 file contains nonstationary data
C     NDSL      unit ref num of namelist file
C     NDSD      unit ref num of data file
C     IOSTAT    io status
C     IERR      error status
C     NBOUNC    number of boundary locations
C     NANG      number of directions on file
C     NFRE      number of frequencies on file
C     NBPT      number of WW3 boundary points
C     DORDER    if <0 order of reading directions is reversed
C     IOPTT     time reading option
C     IPINDX
C     IBOUNC    counter of boundary points
C     IGRBND    counter of boundary grid(swan grid)  points
C     II        counter
C     LL        aux. integer
C     NHEDF     number of heading lines per file
C     NHEDT     number of heading lines per time step
C     NHEDS     number of heading lines per spectrum
C
      INTEGER            :: ISTATF, NDSL, NDSD, IOSTAT, IERR
      INTEGER            :: NBOUNC, NANG, NFRE
      INTEGER            :: IBOUNC
      INTEGER            :: DORDER, IOPTT, IPINDX
      INTEGER            :: NHEDF, NHEDT, NHEDS, NBGRPT_PREV
      INTEGER            :: IFRE, IANG,II,LL,IADRS, IIPT2
C
C     DUM_A     real number used for reading a file but not used in any calculation
C     XLON      longitude
C     XLAT      latitude
C     XP2       problem coordinate of a boundary location
C     YP2       problem coordinate of a boundary location
C     DIRRD1
C     NBGRPT_PREV is the prevous number of NBGRPT
C     IIPT2 counter use for the chekinf if there are grid points on nested boundary
C
      REAL               :: DUM_A, XLON, XLAT,XP2,YP2,DIRRD1
C
      CHARACTER (LEN=4)  :: BTYPE
C                           type of boundary cond.
C                           pointer name (used for dynamic data pool)
      CHARACTER (LEN=24) :: HEDLINT
C                           WW3 version
      CHARACTER (LEN=30) :: GNAME
C                           name of test case readed from b. file
      CHARACTER (LEN=12) :: PTNME
C                           name of b. point
C     XLON0     longitude of origin of computational grid
C     XLAT0     latitude of origin of computational grid
C
      DOUBLE PRECISION   :: XLON0, XLAT0
C
C       FBCNAM  char  inp    filename of boundary data file
C       BCTYPE  char  inp    if value is "NEST": nesting b.c.
C       BFILED  int   i/o    data concerning boundary condition files
C       BSPLOC  int   i/o    place in array BSPECS where to store
C                            interpolated spectra
C       BGRIDP  int   i/o    data concerning boundary grid points
C       BSPAUX  real  i/o    auxiliary array used for interpolation
C       XCGRID  real  inp    x-coordinate of computational grid points
C       YCGRID  real  inp    y-coordinate of computational grid points
C       KGRPNT  int   inp    indirect addresses of grid points
C       XYTST   int   inp    ix, iy of test points
C
C  7. Common blocks and Modules used
C
C
C  8. Subroutines used
C
C     Ocean Pack command reading and data pool management routines
C     BOUNPT
C     BC_POINTS,STPNOW
C
      LOGICAL   :: STPNOW
C
C  9. Subroutines calling
C
C     SWREAD
C
C 10. Error messageS
C
C     ---
C
C  11. Remarks
C
C       data concerning boundary files are stored in array BFILED
C       there is a subarray for each file; it contains:
C       1.  status; 0: stationary, 1: nonstat, -1: exhausted
C       2.  time of boundary values read one before last
C       3.  time of boundary values read last
C       4.  NDSL: unit ref. num. of file containing filenames
C       5.  NDSD: unit ref. num. of file containing data
C       6.  time coding option for reading time from data file
C       8.  number of locations for which spectra are in the file
C       9.  order of reading directional information
C       10. number of spectral directions of spectra on file
C       12. number of spectral frequencies
C       14. number of heading lines per file
C       15. number of heading lines per time step
C       16. number of heading lines per spectrum
C       17. =1: energy dens., =2: variance density, =3 variance energy density (k)
C       18. =1: Cartesian direction, =2: Nautical dir.
C       19. =1: direction spread in degr, =2: Power of Cos.
C       20.  depth of boundary points
C
C  12. Structure
C
C       -----------------------------------------------------------------
C       Open boundary condition data file
C       Read type of file from first line of file
C       If the headline is WAVEWATCH III SPECTRA
C
C       then  b.c. type is WW3N
C       -----------------------------------------------------------
C          Read spectral directions from file and write them into
C          array BSPDIR
C          Read spectral frequencies from fileand write them into
C          array BSPFRQ
C          For all boubdaries points do
C            read location from data file
C            transform into local cartesian coordinates (if nesesery)
C            Then calculate data on grid points, calling BC_POINTS subroutine
C
C       -----------------------------------------------------------------
C       Put file characteristics into array BFILED
C       -----------------------------------------------------------------
C
C 13. Source text
C
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT, 'BCWW3N')
C
C     NDSL unit ref number for namelist files
      NDSL = 0
      ISTATF = 1
C     number of heading lines: per file, per time, per spectrum
      NHEDF = 0
      NHEDT = 0
      NHEDS = 0
      DORDER  = -1
      IOPTT = 1
      IIPT2 = 0
C
C
C     open data file NDSD unit ref number for data files
      NDSD = 0
      IOSTAT = 0
C
      CALL FOR (NDSD, FILENM , 'OF', IOSTAT)
      IF (STPNOW()) RETURN
C
C     generate pointers for data subarrays
C     NBFILS number of boundary condition files
C     IPINDX sequence number of dynamics array
C
      IERR = 0
      CALL DPADDP (BSPLOC, ' ', IPINDX, 'S', IBSPLC, IERR)
      IF (STPNOW()) RETURN
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPLOC')
      IERR = 0
      CALL DPADDP (BSPFRQ, ' ', IPINDX, 'S', IBSPFR, IERR)
      IF (STPNOW()) RETURN
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPFRQ')
      IERR = 0
      CALL DPADDP (BSPDIR, ' ', IPINDX, 'S', IBSPDR, IERR)
      IF (STPNOW()) RETURN
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPDIR')
      IERR = 0
      CALL DPADDP (BSPAUX, ' ', IPINDX, 'P', IAUXW, IERR)
      IF (STPNOW()) RETURN
      IF (IPINDX.NE.NBFILS) CALL MSGERR (2, 'err BSPAUX')
C
C     DPEXPR subroutnime increase the size of the array to 'newsiz'
C     MSC max counter for relative freq. and MDC maximum counter of directional
C     distribution
      CALL DPEXPR (BSPAUX, NBFILS, 10*MSC*MDC, IAUXW, IERR)
      IF (STPNOW()) RETURN
C
C     start reading from the boundary data file
C     HEDLINT = 'WAVEWATCH III SPECTRA' = header of the file
C     read from boundary file the header , number of frequencies NFR,
C     number of direction NANG,  number of boundaries  pionts NBOUNC,
C     Name of the points  GNAME
C
C
      READ (NDSD, 1944) HEDLINT,NFRE, NANG, NBOUNC, GNAME
C
      IF (HEDLINT(2:22) .NE. 'WAVEWATCH III SPECTRA')
     &  CALL MSGERR (3, 'file is not a WW3 spectral file')
      IF (NBOUNC.LT.2)  CALL MSGERR
     &  (3, 'SWAN need at least 2 boundary points for nesting')
C
C     ISTATF related with stationary  and non stationary mode
C
      BTYPE = 'WW3N'
C
C     read frequencies from WW3 boundary file
C
      ALLOCATE (FRQ_ARRAY(1:NFRE), DIR_ARRAY(1:NANG) )
C
      IERR = 0
      CALL DPEXPR (BSPFRQ, NBFILS, NFRE, IBSPFR, IERR)
      IF (STPNOW()) RETURN
C
C     read frequency
C     FRQ_ARRAY(IFRE) =   SIG(IK)/(2*PI)
C
      READ (NDSD,1945) (FRQ_ARRAY(IFRE) ,IFRE=1,NFRE)
C
      DO IFRE = 1, NFRE
        RBSFRQ(IBSPFR+IFRE) =  FRQ_ARRAY(IFRE)*2*PI
      ENDDO
C
      IF (ITEST.GE.60) THEN
        WRITE(PRTEST,*) ' HEDLINT ',' NFRE ',' NANG ',' NBOUNC ',
     &                  ' GNAME'
        WRITE(PRTEST,1944) HEDLINT,NFRE, NANG, NBOUNC, GNAME
        WRITE (PRTEST,*) 'Frequencies read from boundary file ', FILENM
        WRITE (PRTEST,*) (FRQ_ARRAY(IFRE),IFRE = 1,NFRE)
      ENDIF
C
C     read direction from WW3 boundary file
C     DIR_ARRAY(IANG) = MOD(2.5*PI-TH(ITH),TPI)
C     there are in radians but is not in right order related to Swan
C
      IERR = 0
      CALL DPEXPR (BSPDIR, NBFILS, NANG, IBSPDR, IERR)
      IF (STPNOW()) RETURN
C
      READ (NDSD,1946) ( DIR_ARRAY(IANG),IANG=1,NANG)
C
C     put values in right order. The value of the DIR_ARRAY(i) should be
C     smaller that the DIR_ARRAY(i-1)
C     in the opposite situation make DIR_ARRAY(i) = DIR_ARRAY(i) - 2*PI
C
      DIR_ARRAY(:) = PI*DNORTH/180 - DIR_ARRAY(:)                         40.15
 
      DO IANG = 1, NANG
        IF (IANG.EQ.1) THEN
          RBSDIR(IBSPDR+1) = DIR_ARRAY(IANG)
          DIRRD1 =  RBSDIR(IBSPDR+1)
        ELSE
          IF (DIR_ARRAY(IANG).LT.DIRRD1) THEN
            RBSDIR(IBSPDR+IANG) = 2*PI+DIR_ARRAY(IANG)
            DIRRD1 = RBSDIR(IBSPDR+IANG)
          ELSE
            RBSDIR(IBSPDR+IANG) = DIR_ARRAY(IANG)
            DIRRD1 =  RBSDIR(IBSPDR+IANG)
          ENDIF
        ENDIF
      ENDDO
 
      IF(ITEST.GE.60) THEN
        WRITE (PRTEST,*) 'Directions read from boundary file ',
     &                    FILENM
        WRITE (PRTEST,1946) (DIR_ARRAY(IANG),IANG = 1,NANG)
      ENDIF
C
C     Time
      READ (NDSD, 900) WWDATE,WWTIME
C
C     Read from boundary file info about the boundary points(b.p): name of b. p.,
C     geographical location of b.p., depth, wind uelosity  and direction at the b.p.
C     current velosity and direction at the b.p.
C
C     If  DONALL = .TRUE. boundary data correspond to an open boundary otherwise
C     it is continue the interpolation of the grid point between the last and the
C     first point
C
      DO IBOUNC = 1, NBOUNC
        IERR = 0
C
C       latitude =  XLAT
C       longitude = XLON
C       A real which is not used in the computation
C
        READ (NDSD,901) PTNME, XLAT, XLON, DUM_A, DUM_A,
     &                   DUM_A, DUM_A, DUM_A
C       Pass over the lines where the energy spectra is writen in the boundary file.
C       The energy spectra is going to be read later, in the subroutine RESPEC
C
        READ (NDSD,902) ((DUM_A, IFRE = 1,NFRE),IANG = 1,NANG)
C
        IF (ITEST.GE.80) THEN
          WRITE (PRTEST, *) ' B. spectrum WW3 ', IBOUNC, XLON,
     &    XLAT, IERR
        ENDIF
C
C       in case of nesting coordinates on file are used to determine interpolation
C       coefficients
C
        IF (KSPHER.EQ.0) THEN
C
C       if SWAN uses Cartesian coordinates, then transform the shperical coordinates
C       of the boundary piont to local Cartesian coordinates
C
          IF (IBOUNC.EQ.1) THEN
            CALL INDBLE('XGC',XLON0,'REQ',-999.D0)
            CALL INDBLE('YGC',XLAT0,'REQ',-999.D0)
            IF (XLON0.LT.-900.) THEN
              XLON0 = (XOFFS -XPC)/LENDEG
              XLAT0 = (YOFFS-YPC)/LENDEG
            ENDIF
          ENDIF
C
          XP2 = XPC + LENDEG*COS(PI*XLAT0/180.)*(XLON-XLON0)
          YP2 = YPC + LENDEG*(XLAT-XLAT0)
C
        ELSE
          XP2 = XLON-XOFFS
          YP2 = XLAT-YOFFS
        ENDIF
C
C  call subroutine BC_POINTS to interpolate the boundaries points to the grid
C  points of the swan-computational grid
C
        NBGRPT_PREV = NBGRPT
        CALL BC_POINTS ( BSPLOC, BGRIDP, BSPAUX, XCGRID, YCGRID,
     &                    KGRPNT, XYTST,  KGRBND,XP2,YP2,IBOUNC,
     &                    NBOUNC, DONALL )
C       check if the grid points are on nested boundary.
C       if not, stop the calculation and give an error message
        IF (NBGRPT.NE.NBGRPT_PREV) THEN
          IIPT2 = IIPT2+1
        ENDIF
      ENDDO
C
      IF (IIPT2.EQ.0) CALL MSGERR (2,
     &  'no grid points on nested boundary')
C
      IF (ITEST.GE.60) WRITE (PRTEST,16) NBOUNC
  16  FORMAT (I6, ' boundary locations')
C
C     quantity on file is energy density
      BFILED(17) = 1
C
      NHEDF = NHEDF + CEILING(NFRE/8.) + CEILING(NANG/7.)+1
      NHEDS = 2
C     NHEDT: calculated in the RBFILE subroutine for each time step
C
C     enlarge the pool to contain aux. array for spectral interpolation
C
      IERR = 0
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), ' ', IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               NANG*NFRE, IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), ' ', IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MDC*MAX(MSC,NFRE), IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), ' ', IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPADDP (BSPAUX(IADRS(BSPAUX,NBFILS)), ' ', IPINDX, 'S',
     &               IAUXW, IERR)
      IF (STPNOW()) RETURN
      CALL DPEXPR (BSPAUX(IADRS(BSPAUX,NBFILS)), IPINDX,
     &               MAX(NFRE,NANG,MSC), IAUXW, IERR)
      IF (STPNOW()) RETURN
C
C     enlarge the pool to contain boundary value arrays
C
      IERR = 0
      CALL DPEXPR (BSPLOC, NBFILS, NBOUNC, IBSPLC, IERR)
      IF (STPNOW()) RETURN
      DO IBC = 1, NBOUNC
        BSPLOC(IBSPLC+IBC) = NBSPEC + IBC
      ENDDO
C
      NBSPEC = NBSPEC + NBOUNC
C
C     store file reading parameters in array BFILED
C
      BFILED(1)  = ISTATF
      BFILED(2)  = -999999999
      BFILED(3)  = -999999999
      BFILED(4)  = NDSL
      BFILED(5)  = NDSD
      BFILED(6)  = IOPTT
      CALL COPYCH (BTYPE, 'T', BFILED(7), 1, IERR)
      BFILED(8)  = NBOUNC
      BFILED(9)  = DORDER
      BFILED(10) = NANG
      BFILED(11) = 0
      BFILED(12) = NFRE
C     ordering of data on file
      BFILED(13) = 0
C     number of heading lines: per file, per time, per spectrum
      BFILED(14) = NHEDF
      BFILED(15) = NHEDT
      BFILED(16) = NHEDS
C     quantity on file is energy density (k)
      BFILED(17) = 3
C
C
      CALL DPMINR (BSPAUX, NBFILS, LL, IAUXW, IERR)
      IF (STPNOW()) RETURN
C
      IF (ITEST.GE.80) WRITE(PRINTF,81) NBFILS, NBSPEC,
     &      (BFILED(II), II=1,16)
C
C      Rewind input file for proper start
      REWIND (NDSD)
 
  81  FORMAT (' array BFILED: ', 2I4, 2(/,8I10))
  900 FORMAT (I8.8,I7.6)
  901 FORMAT (A12,2F7.2,F10.1,2(F7.2,F6.1))
  902 FORMAT (7E11.3)
 1944 FORMAT (A23,1X,3I6,1X,A33)
 1945 FORMAT (8E10.3)
 1946 FORMAT (7E11.3)
 
      DEALLOCATE (FRQ_ARRAY,DIR_ARRAY)
 
      RETURN
 
      END SUBROUTINE BCWW3N
 
************************************************************************
*
      SUBROUTINE BC_POINTS ( BSPLOC, BGRIDP, BSPAUX, XCGRID, YCGRID,
     &                    KGRPNT, XYTST,  KGRBND,XP2,YP2,BOUN_COUN,
     &                    NBOUNC,DONALL )
*
*************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C  0. Authors
C
C     30.73, 40.13: Nico Booij
C     40.05: Ekaterini E. Kriezi
C
C  1. Updates
C
C     40.05, Aug 00 :  remove the code to a separate subroutine
C     40.13, Jan.01: remove declarations of unused variables
C
C  2. Purpose
C
C     interpolation of points grid  to the swan-computational  grid
C
C  3. Method
C
C     calculate interpolation coefficients betweens the  nesting  boundary grid and
C     the swan-computational  grid
C
C  4. Argument variables
C
C     BSPAUX: Auxiliary array used for interpolation
C     BSPLOC  place in array BSPECS where to store interpolated spectra
C     BGRIDP  data concerning boundary grid points
C     NBOUNC:     max number of boundaries points
C     BOUND_COUN: counter show  of the existing  boundary point
C
      INTEGER, INTENT(INOUT)  ::  BSPAUX(*)
      INTEGER, INTENT(INOUT)  ::  BGRIDP(*)
      INTEGER, INTENT(INOUT)  ::  BSPLOC(*)
C
      INTEGER, INTENT(IN)     ::  KGRPNT(MXC,MYC)  ! indirect addresses of computational grid points
      INTEGER, INTENT(IN)     ::  KGRBND(*)        ! array of boundary grid points
      INTEGER, INTENT(IN)     ::  XYTST(*)         ! array of (ix,iy) of test points
C
      INTEGER, INTENT(IN)     ::  BOUN_COUN,NBOUNC
C
      REAL, INTENT(IN)        ::  XCGRID(MXC,MYC), YCGRID(MXC,MYC)  ! coordinates of computational grid points
C
C     DONALL : logic arguments declare if the nesting  boundary is open or close
C     it is defined by the users
C
      LOGICAL, INTENT(INOUT)  ::  DONALL
C
C  5. Parameter variables
C
C     --
C
C  6. Local variables
C
C     XP1       problem coordinate of a boundary location
C     YP1       problem coordinate of a boundary location
C     XP2       problem coordinate of a boundary location
C     YP2       problem coordinate of a boundary location
C     DISXY     distance in (x,y)-space
C     DISMAX    largest distance
C     SUMWGT    sum of interpolation weights
C     W2        is relative length of projection on line
C     IIPT1     counter cheking the grid points related to the nesting boundary
C
      INTEGER, SAVE      :: IBSP0 = 1, IBSP1 = 1, IENT = 0
      INTEGER            :: IBSP2,IGRBND,INDXGR
      INTEGER            :: IXP,IYP,IIPT1
C
      REAL, SAVE         :: XP0=0., XP1=0., YP0=0., YP1=0.                NRL
      REAL               :: XP2, YP2, XP, YP, RX, RY, RL2
      REAL               :: DISXY, W2
C
C  7. Common Blocks and Modules used
C
C
C  8. Subroutines Used
C
C
C  9. Subroutines calling
C
C      BCFILE : open and read Swan nesting files
C      BCWW3N : open and read WW3 nesting files
C
C  10. Error messages
C
C       ---
C
C  11. Remarks
C
C  12. Structure
C
C           For all computational grid points on boundary do
C               if point is located between nest file grid points
C               calculate interpolation coefficients
C               if DONALL is TRUE
C                  the nesting boundary remain open
C               else(defaule case)  DONALL is FALSE
C                   boundary is close, it do interpolation betwen the last
C                   and the first point
C               put interpolation coefficients  into array BGRIDP
C
C  13. Source text
C
      CALL STRACE (IENT, 'BC_POINTS')
C
      IBSP2 = NBSPEC+BOUN_COUN
      IIPT1 = 0
C
201     IF (BOUN_COUN.EQ.1) THEN
          XP0 = XP2
          YP0 = YP2
          IBSP0 = IBSP2
        ELSE
          RX  = XP2 - XP1
          RY  = YP2 - YP1
          RL2 = RX**2 + RY**2
          IF (RL2.GT.0.) THEN
            RX  = RX/RL2
            RY  = RY/RL2
C
C           loop over boundary of comp. grid, select points between
C           (XP1,YP1) and (XP2,YP2)
C           KGRBND grid addresses on boundary pionts, NGRBND number of grid points
C           on computational grid boundary
C
            DO IGRBND = 1, NGRBND
              IXP = KGRBND(2*IGRBND-1)
              IYP = KGRBND(2*IGRBND)
C
              IF (IXP.GT.0 .AND.IYP.GT.0) THEN
C
C               (IXP,IYP) is a valid boundary point
C
                INDXGR = KGRPNT(IXP,IYP)
                XP = XCGRID(IXP,IYP)
                YP = YCGRID(IXP,IYP)
C
C               DISXY is relative distance from (XP,YP) to line
C               (XP1,YP1) to (XP2,YP2)
C
                DISXY = ABS(RX*(YP-YP1)-RY*(XP-XP1))
C
                IF (DISXY.LT.0.1) THEN
C                 W2 is relative length of projection on line
C                 (XP1,YP1) to (XP2,YP2)
                  W2 = RX*(XP-XP1)+RY*(YP-YP1)
                  IF (W2.GT.-0.001 .AND. W2.LT.1.001) THEN
                    IF (W2.LT.0.01) W2 = 0.
                    IF (W2.GT.0.99) W2 = 1.
                    IF (ITEST.GE.80) WRITE (PRTEST, *) ' B.pnt',
     &                         IXP, IYP, XP, YP, W2, IBSP2, IBSP1
                    NBGRPT = NBGRPT + 1
                    IIPT1 = IIPT1 + 1
C
C                   BGRIGP pool array, data for interpolating to computational
C                   grid points
C
                    BGRIDP(6*NBGRPT-5) = INDXGR
C                   next item indicates type of boundary condition
                    BGRIDP(6*NBGRPT-4) = 1
                    BGRIDP(6*NBGRPT-3) = NINT(1000. * W2)
                    BGRIDP(6*NBGRPT-2) = IBSP2
                    BGRIDP(6*NBGRPT-1) = NINT(1000. * (1.-W2))
                    BGRIDP(6*NBGRPT)   = IBSP1
C
C                   test output if point is a test point
C
                    IF (NPTST.GT.0) THEN
                      DO IPTST = 1, NPTST
                        IF (IXP.EQ.XYTST(2*IPTST-1) .AND.
     &                     IYP.EQ.XYTST(2*IPTST)) WRITE (PRTEST, 223)
     &                     IXP-1,IYP-1, XP+XOFFS, YP+YOFFS, W2, IBSP2,
     &                     IBSP1
 223                       FORMAT (' B.pnt', 2I5, 2F9.0, F6.3, 2I3)
                      ENDDO
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF
C
       IF (IIPT1.EQ.0) THEN
          WRITE (PRINTF, 218) XP1+XOFFS, YP1+YOFFS,
     &    XP2+XOFFS, YP2+YOFFS
 218      FORMAT (' Warning: no grid points on interval from ', 2F12.4,
     &    ' to ', 2F12.4)
        ENDIF
C
        XP1 = XP2
        YP1 = YP2
        IBSP1 = IBSP2
C
        IF (BOUN_COUN.EQ.NBOUNC) THEN
          IF ( .NOT. DONALL) THEN
C
C           process grid points between last and first boundary point
C
            DONALL = .TRUE.
            XP2 = XP0
            YP2 = YP0
            IBSP2 = IBSP0
            GOTO 201
          ENDIF
        ENDIF
C
C
      RETURN
C
      END SUBROUTINE BC_POINTS
C
**********************************************************************
*                                                                    *
      LOGICAL FUNCTION BOUNPT (IX,IY,KGRPNT)
*                                                                    *
**********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. Authors
*
*     40.00, 40.03: Nico Booij
*
*  1. UPDATE
*
*       Feb. 1998, ver. 40.00: new subroutine
*       40.03, Sep. 00: inconsistency with manual corrected
*
*  2. PURPOSE
*
*       determine whether a grid point is a point where a boundary condition
*       can be applied
*
*  3. METHOD
*
*
*  4. PARAMETERLIST
*
*       IX, IY  int   inp    grid point indices
*       KGRPNT  int   inp    indirect addresses of grid points
*
*  5. SUBROUTINES CALLING
*
*       BCFILE
*
*  6. SUBROUTINES USED
*
*       ---
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*     KGRPNT(IX,IY)=1 means that (IX,IY) is not an active grid point
*
*  9. STRUCTURE
*
C     -----------------------------------------------------------------
C     Make BOUNPT = False
C     If the grid point is not active
C     Then return
C     -----------------------------------------------------------------
C     If grid point is on the outer boundary
C     Then make BOUNPT = True
C          return
C     -----------------------------------------------------------------
C     If a neighbouring grid point is inactive
C     Then make BOUNPT = True
C          return
C     -----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER IX,IY,KGRPNT(MXC,MYC)
      SAVE IENT
      DATA IENT/0/
      CALL STRACE (IENT, 'BOUNPT')
C
      BOUNPT = .FALSE.
C
      IF (IX.LE.0)   RETURN
      IF (IY.LE.0)   RETURN
      IF (IX.GT.MXC) RETURN
      IF (IY.GT.MYC) RETURN
C
C     If the grid point is not active
C     Then return
C
      IF (KGRPNT(IX,IY).LE.1) RETURN
C
C     If grid point is on the outer boundary
C     Then make BOUNPT = True
C          return
C
      IF (IX.EQ.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (IX.EQ.MXC) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (IY.EQ.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (IY.EQ.MYC) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
C
C     If a neighbouring grid point is inactive
C     Then make BOUNPT = True
C          return
C
      IF (KGRPNT(IX-1,IY).LE.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (KGRPNT(IX+1,IY).LE.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (KGRPNT(IX,IY-1).LE.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      IF (KGRPNT(IX,IY+1).LE.1) THEN
        BOUNPT = .TRUE.
        RETURN
      ENDIF
      RETURN
      END
**********************************************************************
*                                                                    *
      SUBROUTINE RETSTP (MPTST, XYTST, KGRPNT, KGRBND, XCGRID, YCGRID,
     &                   SPCSIG, SPCDIR, IOUTD, ROUTD)
*                                                                    *
**********************************************************************
C
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
C  0. Authors
C
C     30.82: IJsbrand Haagsma
C     40.00, 40.13: Nico Booij
C     34.01: Jeroen Adema
C     40.04: Annette Kieftenburg
C
*  1. Updates
C
C     40.00, Apr. 98: New subroutine
C     30.82, Oct. 98: Updated description of several variables
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Dec. 99: XOFFS and YOFFS introduced in write statements
C            May  00: ITMOPT written to heading of file instead of 1
C     40.04, Aug. 00: Added error message if testpoints are defined
C                     before bottom grid is read
C     40.13, Jan. 01: two output strings corrected
C            May  01: two incorrect units changed from m2/2 to m2/s
*
*  2. PURPOSE
*
*       read test points, generate output point set 'TESTPNTS',
*       read source term filenames
*
*  3. METHOD
*
*
*  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C i   XCGRID: Coordinates of computational grid in x-direction            30.82
C i   YCGRID: Coordinates of computational grid in y-direction            30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.82
C
C i   MPTST : Maximum number of test points                               30.82
C i   XYTST : Grid point indices of test points                           30.82
C
      INTEGER MPTST                                                       30.82
      INTEGER XYTST(2*MPTST)                                              30.82
C
*  5. SUBROUTINES CALLING
*
*       SWREAD
*
*  6. SUBROUTINES USED
*
      LOGICAL STPNOW                                                      34.01
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*
*  9. STRUCTURE
*
C     -----------------------------------------------------------------
C     Repeat
C         read (i,j) identifying a test point
C         store values in array XYTST
C     -----------------------------------------------------------------
C     Generate output point set 'TESTPNTS'
C     write coordinates of test points into array OUTDA
C     -----------------------------------------------------------------
C     If 1D output of source terms is requested
C     Then open file
C          write general data into the file
C     -----------------------------------------------------------------
C     If 2D output of source terms is requested
C     Then open file
C          write general data into the file
C     -----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER   KGRPNT(MXC,MYC), IOUTD(*), KGRBND(*)
      REAL      ROUTD(*)
      LOGICAL   KEYWIS, LOCGRI                                            40.00
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT, 'RETSTP')
C
      CALL INKEYW ('STA','IJ')                                            40.00
      IF (LEDS(1).GE.2) THEN                                              40.04
        IF (KEYWIS('XY')) THEN
          LOCGRI = .TRUE.
        ELSE IF (KEYWIS('IJ')) THEN
          LOCGRI = .FALSE.
        ELSE
          CALL WRNKEY
        ENDIF
      ELSE                                                                40.04
        CALL MSGERR(3,'Testpoints must be defined after bottom is read')  40.04
      ENDIF                                                               40.04
C
  10  IF (LOCGRI) THEN
        CALL READXY ('X','Y',XP,YP, 'REP', -1.E10, -1.E10)                40.03
        IF (XP.LT.-.9E10) THEN
          LXDMP = 0
          GOTO 60
        ELSE
          CALL CVMESH (XP, YP, XC, YC, KGRPNT, XCGRID, YCGRID, KGRBND)    40.00
          IF (XC.LT.0.) GOTO 40
          LXDMP = NINT(XC)
          LYDMP = NINT(YC)
          IF (ITEST.GE.30) WRITE (PRTEST, 14) XP+XOFFS, YP+YOFFS,         40.03
     &    LXDMP, LYDMP
  14      FORMAT (' test point ', 2F12.2, ' to grid point ', 2I4)
        ENDIF
      ELSE
        CALL ININTG ('I' , LXDMP, 'REP', -1)                              40.03
        IF (LXDMP .LT. 0) GOTO 60
        CALL ININTG ('J' , LYDMP, 'REQ',  0)                              40.03
      ENDIF
      IF (LXDMP.GE.0 .AND. LXDMP.LE.MXC-1 .AND.
     &    LYDMP.GE.0 .AND. LYDMP.LE.MYC-1) THEN
        IF (KGRPNT(LXDMP+1,LYDMP+1) .GT. 1) THEN
          NPTST = NPTST + 1
          XYTST(2*NPTST-1) = LXDMP+1
          XYTST(2*NPTST)   = LYDMP+1
          GOTO 50
        ENDIF
      ENDIF
  40  CALL MSGERR (2, 'test point outside comp. grid')
      IF (LOCGRI) THEN
        WRITE (PRINTF, *) XP+XOFFS, YP+YOFFS                              40.03
      ELSE
        WRITE (PRINTF, *) LXDMP, LYDMP
      ENDIF
  50  IF (NPTST.LE.MPTST) GOTO 10
      CALL MSGERR (2, 'Too many test points')
C
C     generate output point set 'TESTPNTS'
C
  60  IOUTD(1) = ICHAR('P')
      IOUTD(2) = NPTST
      DO 140 IPTST = 1, NPTST
        LXDMP = XYTST(2*IPTST-1)                                          40.00
        LYDMP = XYTST(2*IPTST)                                            40.00
        ROUTD(2*IPTST+1) = XCGRID(LXDMP,LYDMP)                            40.00
        ROUTD(2*IPTST+2) = YCGRID(LXDMP,LYDMP)                            40.00
 140  CONTINUE
C
C     open output file for test output of wave parameters                 40.00
C
      CALL INKEYW ('STA', ' ')                                            40.00
      IF (KEYWIS('PAR')) THEN                                             40.00
        CALL INCSTR ('FNAME', FILENM, 'STA', 'SWSRCPA')                   40.00
        IERR = 0                                                          40.00
        CALL FOR (IFPAR, FILENM, 'UF', IERR)                              40.00
        IF (STPNOW()) RETURN                                              34.01
        WRITE (IFPAR, 101) 1                                              40.00
 101    FORMAT ('SWAN', I4, T41,
     &    'Swan standard spectral file, version')                         40.00
        WRITE (IFPAR, 111) VERTXT                                         40.03
 111    FORMAT ('$   Data produced by SWAN version ', A)                  40.03
        WRITE (IFPAR, 113) PROJID, PROJNR                                 40.03
 113    FORMAT ('$   Project: ', A, ';  run number: ', A)
        IF (NSTATM.EQ.1) THEN
          WRITE (IFPAR, 102) 'TIME', 'time-dependent data'
 102      FORMAT (A, T41, A)                                              40.00
          WRITE (IFPAR, 103) ITMOPT, 'time coding option'                 40.03
 103      FORMAT (I6, T41, A)                                             40.00
        ELSE
          WRITE (IFPAR, 102) 'ITER', 'iteration-dependent data'
          WRITE (IFPAR, 103) 0
        ENDIF
        IF (KSPHER.EQ.0) THEN
          WRITE (IFPAR, 102) 'LOCATIONS', 'locations in x-y-space'
        ELSE
          WRITE (IFPAR, 102) 'LONLAT',
     &                       'locations in longitude, latitude'
        ENDIF
        WRITE (IFPAR, 103) NPTST, 'number of locations'
        DO 110 IPTST = 1, NPTST
          LXDMP = XYTST(2*IPTST-1)                                        40.00
          LYDMP = XYTST(2*IPTST)                                          40.00
          WRITE (IFPAR, 106) XCGRID(LXDMP,LYDMP)+XOFFS,
     &                       YCGRID(LXDMP,LYDMP)+YOFFS                    40.00
 106      FORMAT (2(1X,F12.2))
 110    CONTINUE
        WRITE (IFPAR, 132) 8                                              40.00
 132    FORMAT ('QUANT', /, I6, T41, 'number of quantities in table')     40.00
        WRITE (IFPAR, 102) OVSNAM(10), OVLNAM(10)                         40.00
        WRITE (IFPAR, 102) OVUNIT(10), 'unit'                             40.00
        WRITE (IFPAR, 104) OVEXCV(10), 'exception value'                  40.00
 104    FORMAT (F14.6, T41, A)                                            40.00
        WRITE (IFPAR, 102) OVSNAM(11), OVLNAM(11)                         40.00
        WRITE (IFPAR, 102) OVUNIT(11), 'unit'                             40.00
        WRITE (IFPAR, 104) OVEXCV(11), 'exception value'                  40.00
        WRITE (IFPAR, 102) 'Swind',  'wind source term (of var. dens.)'   40.00
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.00
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFPAR, 102) 'Swcap',  'whitecapping dissipation'           40.00
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.00
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFPAR, 102) 'Sfric',  'bottom friction dissipation'        40.00
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.00
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFPAR, 102) 'Ssurf',  'surf breaking dissipation'          40.00
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.00
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFPAR, 102) 'Snl3',   'total absolute 3-wave interaction'  40.13
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.13
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFPAR, 102) 'Snl4',   'total absolute 4-wave interaction'  40.13
        WRITE (IFPAR, 102) 'm2/s',   'unit'                               40.13
        WRITE (IFPAR, 104) OVEXCV(7),'exception value'                    40.00
      ENDIF
C
C     open output file for source terms if requested
C
      CALL INKEYW ('STA', ' ')                                            40.00
      IF (KEYWIS('S1D')) THEN                                             40.00
        CALL INCSTR ('FNAME', FILENM, 'STA', 'SWSRC1D')                   40.00
        IERR = 0                                                          40.00
        CALL FOR (IFS1D, FILENM, 'UF', IERR)                              40.00
        IF (STPNOW()) RETURN                                              34.01
        WRITE (IFS1D, 101) 1
        WRITE (IFS1D, 111) VERTXT                                         40.03
        WRITE (IFS1D, 113) PROJID, PROJNR                                 40.03
        IF (NSTATM.EQ.1) THEN
          WRITE (IFS1D, 102) 'TIME', 'time-dependent data'
          WRITE (IFS1D, 103) ITMOPT, 'time coding option'                 40.03
        ELSE
          WRITE (IFS1D, 102) 'ITER', 'iteration-dependent data'
          WRITE (IFS1D, 103) 0
        ENDIF
        IF (KSPHER.EQ.0) THEN
          WRITE (IFS1D, 102) 'LOCATIONS', 'locations in x-y-space'
        ELSE
          WRITE (IFS1D, 102) 'LONLAT',
     &                       'locations in longitude, latitude'
        ENDIF
        WRITE (IFS1D, 103) NPTST, 'number of locations'
        DO 210 IPTST = 1, NPTST                                           40.00
          LXDMP = XYTST(2*IPTST-1)                                        40.00
          LYDMP = XYTST(2*IPTST)                                          40.00
          WRITE (IFS1D, 106) XCGRID(LXDMP,LYDMP)+XOFFS,                   40.00
     &                       YCGRID(LXDMP,LYDMP)+YOFFS                    40.00
 210    CONTINUE                                                          40.00
        IF (ICUR.GT.0) THEN
          WRITE (IFS1D, 102) 'RFREQ', 'relative frequencies in Hz'        40.00
        ELSE
          WRITE (IFS1D, 102) 'AFREQ', 'absolute frequencies in Hz'        40.00
        ENDIF
        WRITE (IFS1D, 103) MSC, 'number of frequencies'                   40.00
        DO 220 IS = 1, MSC                                                40.00
          WRITE (IFS1D, 214) SPCSIG(IS)/PI2                               40.00
 214      FORMAT (F10.4)                                                  40.00
 220    CONTINUE                                                          40.00
        WRITE (IFS1D, 132) 7
        WRITE (IFS1D, 102) 'VaDens', 'variance densities'                 40.00
        WRITE (IFS1D, 102) 'm2/Hz',  'unit'                               40.00
        WRITE (IFS1D, 104) 0.,       'exception value'                    40.00
        WRITE (IFS1D, 102) 'Swind',  'wind source term'                   40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS1D, 102) 'Swcap',  'whitecapping dissipation'           40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS1D, 102) 'Sfric',  'bottom friction dissipation'        40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS1D, 102) 'Ssurf',  'surf breaking dissipation'          40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS1D, 102) 'Snl3',   'triad interactions'                 40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS1D, 102) 'Snl4',   'quadruplet interactions'            40.00
        WRITE (IFS1D, 102) 'm2',     'unit'                               40.00
        WRITE (IFS1D, 104) OVEXCV(7),'exception value'                    40.00
      ENDIF
*     2D source terms
      CALL INKEYW ('STA', ' ')                                            40.00
      IF (KEYWIS('S2D')) THEN                                             40.00
        CALL INCSTR ('FNAME', FILENM, 'STA', 'SWSRC2D')                   40.00
        IERR = 0                                                          40.00
        CALL FOR (IFS2D, FILENM, 'UF', IERR)                              40.00
        IF (STPNOW()) RETURN                                              34.01
        WRITE (IFS2D, 101) 1
        WRITE (IFS2D, 111) VERTXT                                         40.03
        WRITE (IFS2D, 113) PROJID, PROJNR                                 40.03
        IF (NSTATM.EQ.1) THEN
          WRITE (IFS2D, 102) 'TIME', 'time-dependent data'
          WRITE (IFS2D, 103) ITMOPT, 'time coding option'                 40.03
        ELSE
          WRITE (IFS2D, 102) 'ITER', 'iteration-dependent data'
          WRITE (IFS2D, 103) 0
        ENDIF
        IF (KSPHER.EQ.0) THEN
          WRITE (IFS2D, 102) 'LOCATIONS', 'locations in x-y-space'
        ELSE
          WRITE (IFS2D, 102) 'LONLAT',
     &                       'locations in longitude, latitude'
        ENDIF
        WRITE (IFS2D, 103) NPTST, 'number of locations'
        DO 310 IPTST = 1, NPTST                                           40.00
          LXDMP = XYTST(2*IPTST-1)                                        40.00
          LYDMP = XYTST(2*IPTST)                                          40.00
          WRITE (IFS2D, 106) XCGRID(LXDMP,LYDMP)+XOFFS,                   40.00
     &                       YCGRID(LXDMP,LYDMP)+YOFFS                    40.00
 310    CONTINUE                                                          40.00
        IF (ICUR.GT.0) THEN
          WRITE (IFS2D, 102) 'RFREQ', 'relative frequencies in Hz'        40.00
        ELSE
          WRITE (IFS2D, 102) 'AFREQ', 'absolute frequencies in Hz'        40.00
        ENDIF
        WRITE (IFS2D, 103) MSC, 'number of frequencies'                   40.00
        DO 320 IS = 1, MSC                                                40.00
          WRITE (IFS2D, 214) SPCSIG(IS)/PI2                               40.00
 320    CONTINUE                                                          40.00
*       full 2-D spectrum
        WRITE (IFS2D, 102) 'CDIR',
     &                      'spectral Cartesian directions in degr'       40.00
        WRITE (IFS2D, 103) MDC, 'number of directions'
        DO 330 ID = 1, MDC                                                40.00
          WRITE (IFS2D, 324) SPCDIR(ID,1)*180./PI                         30.82
 324      FORMAT (F10.4)                                                  40.00
 330    CONTINUE                                                          40.00
        WRITE (IFS2D, 132) 7
        WRITE (IFS2D, 102) 'VaDens', 'variance densities'                 40.00
        WRITE (IFS2D, 102) 'm2/Hz/degr', 'unit'                           40.00
        WRITE (IFS2D, 104) 0.,       'exception value'                    40.00
        WRITE (IFS2D, 102) 'Swind',  'wind source term'                   40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS2D, 102) 'Swcap',  'whitecapping dissipation'           40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS2D, 102) 'Sfric',  'bottom friction dissipation'        40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS2D, 102) 'Ssurf',  'surf breaking dissipation'          40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS2D, 102) 'Snl3',   'triad interactions'                 40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
        WRITE (IFS2D, 102) 'Snl4',   'quadruplet interactions'            40.00
        WRITE (IFS2D, 102) 'm2/degr','unit'                               40.00
        WRITE (IFS2D, 104) OVEXCV(7),'exception value'                    40.00
      ENDIF
      RETURN
*     end of subroutine RETSTP
      END
