!NRL: $Id: swmod1.F,v 1.2 2003/03/28 15:36:46 dykes Stab $
!NRL: $Name:  $
C     Last change:  YGH  13 Oct 2000    4:43 pm
      MODULE M_WCAP
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     Sep. 00: New Module
C
C  2. Purpose
C
C     Create global variables used in whitecapping and integral parameter
C     subroutines
C
C  3. Method
C
C     MODULE construct
C
C  4. Modules used
C
C     ---
C
      IMPLICIT NONE
C
C  5. Argument variables
C
C     ---
C
C  6. Parameter variables
C
C     ---
C
C  7. Local variables
C
CWCAPC     IS_SPLIT:Counter is frequency array, used for split in swell- and sea-part
CWCAPC
CWCAP      INTEGER :: IS_SPLIT
CWCAP      INTEGER :: KWCAP           ! Initial setting of the whitecapping formulation
CWCAPC
C     ACTOT  : Total action density per gridpoint
C     EDRKTOT: Zeroth moment of energy / SQRT(wavenumber)
C     EKTOT  : Zeroth moment of energy * wavenumber
CWCAPC     ETOT_SWELL: Swell part of the total wave energy density
C     ETOT1  : First moment of the energy density
C     ETOT2  : Second moment of the energy density
C     ETOT4  : Fourth moment of the energy density
CWCAPC     HS_SWELL:Significant wave height corresponding to the swell-part of the spectrum
CWCAPC     K_SWELL:Mean average wavenumber corresponding to the swell-part of the spectrum
C     KM_WAM : Mean average wavenumber according to the WAM-formulation
C     KM01   : Mean average wavenumber according to first order moment
C     SIGM_10: Mean frequency according to zeroth order moment
C     SIGM01 : Mean frequency according to first order moment
C
CWCAP      REAL    :: ETOT_SWELL
CWCAP      REAL    :: HS_SWELL
CWCAP      REAL    :: K_SWELL
!    Removed these variables from this module and placed them in a         40.22
!    common block to make them thread private.  All saved variables        40.22
!    are shared.                                                           40.22
C
C     SPCSIG_f90: Contains discretisec values for sigma. Second dimension indicates
C                 power of sigma.
C
      REAL, SAVE, ALLOCATABLE :: SPCSIG_f90(:,:)
C
C  8. Subroutines and functions used
C
C     ---
C
C  9. Subroutines and functions calling
C
C     SSFILL :
C     SINTGRL: Calculating integral paramters
C     WCAP   : Calculating whitecapping source term
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ---
C
C 13. Source text
C
      END MODULE M_WCAP
 
C
      MODULE OUTP_DATA
 
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.13: Nico Booij
C
C  1. Updates
C
C     40.13, July 01: New Module
!     40.13, Oct. 01: Longer filenames for output requests
C
C  2. Purpose
C
C     Contains data needed during generation of output
C
C  3. Method
C
C     MODULE construct
C
C  4. Modules used
C
C     ---
C
      IMPLICIT NONE
 
      INCLUDE 'ocpcomm2.inc'
C
C  5. Argument variables
C
C     ---
C
C  6. Parameter variables
C
C     ---
C
C  7. Local variables
 
      INTEGER, PARAMETER :: MAX_OUTP_REQ = 50 ! max. number of output requests
 
      CHARACTER (LEN=1),  SAVE :: OUT_COMMENT = '!'   ! comment sign for heading lines
 
      ! formats for output:
      CHARACTER (LEN=40), SAVE :: FLT_BLOCK = '(6E12.4)'       ! floating point block
      CHARACTER (LEN=40), SAVE :: FLT_TABLE = '(100(1X,E11.4))' ! floating point table
      CHARACTER (LEN=40), SAVE :: FIX_SPEC  = '(200(1X,I4))'   ! spectral output
 
      INTEGER :: FLD_TABLE = 12       ! field length for fixed-point table  NRL
      INTEGER, SAVE :: DEC_BLOCK =  4       ! number of decimals for fixed-point block
      INTEGER, SAVE :: DEC_SPEC  =  4       ! number of decimals for spectral output
 
!     longer filenames for output requests
      CHARACTER (LEN=LENFNM), SAVE :: OUTP_FILES(1:MAX_OUTP_REQ)
      ! filenames for output; index is output request sequence number
 
C
C  8. Subroutines and functions used
C
C     ---
C
C  9. Subroutines and functions calling
C
C     SWREAD : reads data (command OUTPut OPTions)
C     SWBLOK : produces block output
C     SWTABP : produces table output
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ---
C
C 13. Source text
C
      END MODULE OUTP_DATA
 
