!NRL: $Id: mcel_filt.F,v 1.1.2.2 2003/06/27 22:22:25 dykes Exp $
!NRL: $Name:  $
************************************************************************
      subroutine mcel_filt (var, mcelio)
************************************************************************

      include 'MCEL.inc'
      include 'mcel_swan.inc'

#ifdef API
      character*256 fn  !dummy
      INTEGER FileStatus, Status
      INTEGER idum
      include 'coupling_api.inc'
      include 'wrf_io_flags.h'
#endif

      character*(*) var
      character*80 var_name
      if (var .eq. 'uwind' ) var_name = 'U10'
      if (var .eq. 'vwind' ) var_name = 'V10'

#ifdef API
! training read
      CALL ext_mcel_read_field ( api_grids(mcelio),
     &                           '1999-11-09_12:00:00',   ! dummy date
     &                           trim(var_name),                   ! VarName
     &                           array,                    ! DUMMY Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )
#else
      ! Set the source for density to the main server
      nvar = 1
      call AddSources (id_interp(mcelio), MCEL_SERVER, var_name, 
     $   nvar,MCEL_DATATYPE_REAL, ierr)
      if (ierr.eq.0) then
         print *, 'mcel_filt: adding source for ', var, mcelio
      else
         print *, 'mcel_filt: failed adding source for ', var
      endif

      ! Set the name of the output var density
      call AddOutputs (id_interp(mcelio), var_name, nvar, 
     &   MCEL_DATATYPE_REAL,ierr)
      if (ierr == 0) then
         print*, 'mcel_filt: adding outputs: ', var
      else
         print*, 'mcel_filt: failed adding outputs: ', var
      end if

      ! Finish up adding the filters
      call FinalizeFilters (id_interp(mcelio), ierr)
      if (ierr.eq.0) then
         print *, 'mcel_filt: finalizing filter'
      else
         print *, 'mcel_filt: failed finalizing filter'
      end if
#endif

      return
      end
