!NRL: $Id: mcel_get.F,v 1.1.2.4 2003/07/02 22:05:05 dykes Exp $
!NRL: $Name:  $
************************************************************************
      subroutine mcel_get (array, nx, ny, time_slot, var, mcelio)
************************************************************************

      include 'MCEL.inc'
      include 'mcel_swan.inc'

#ifdef API
      character*256 fn  !dummy
      INTEGER FileStatus, Status
      INTEGER idum
      include 'coupling_api.inc'
      include 'wrf_io_flags.h'
#endif

      real array(nx, ny)
      real*8 DTIMCO
      character*8 var 
      character*80 var_name

      DTIMCO = time_slot
!      if (TIMCO < 0.0) DTIMCO = 0.0

      if (var .eq. 'uwind' ) var_name = 'U10'
      if (var .eq. 'vwind' ) var_name = 'V10'

#ifdef API
      write(*,*)'mcel_get DTIMCO ', DTIMCO
      CALL ext_mcel_inquire_opened (api_grids(mcelio),fn,
     $                              FileStatus,Status)
      IF ( Status .NE. 0 ) write(0,*)
     $     'mcel_put: ext_mcel_inquire_opened returns error: ', Status
      IF ( FileStatus .EQ. WRF_FILE_OPENED_NOT_COMMITTED ) THEN
         CALL ext_mcel_open_for_read_commit (api_grids(mcelio),Status)
      ENDIF

      CALL ext_mcel_read_field ( api_grids(mcelio),
     &                           '1999-11-09_12:00:00',   ! dummy date
     &                           trim(var_name),                   ! VarName
     &                           array,                    ! DUMMY Field
     &                                   WRF_REAL,                ! TYPE
     &                                   idum, idum, idum,        ! dummy comms and desc
     &                                   'XY',                    ! Mem order (unstructured)
     &                                   ' ',                     ! Stagger (not)
     &                                   DimNames ,
     &                                   DomainStart , DomainEnd ,
     &                                   MemoryStart , MemoryEnd ,
     &                                   PatchStart , PatchEnd ,
     &                                   ierr )

#else

      call GetData (id_interp(mcelio), var_name, array,
     &   DTIMCO, DTIMCO, MCEL_TIMECENT_POINT,
     &   MCEL_MASK_ALLVALID,
     &   MCEL_FETCHPOLICY_BLOCK, ierr)
      print*, 'mcel_get: ', id_interp(mcelio), var, mcelio
      if (ierr == 0) then
         write (*,'(a42, a7, 2x, e15.10)') 
     &      'mcel_get: getting from MCEL at this time: ', var, DTIMCO
      else
         print*, 'mcel_get: failed getting from MCEL: ', var
      end if
#endif
      print*, 'sample value(10, 1) =', array(10, 1)
      return
      end
