!NRL: $Id: ocpcomm3.inc,v 1.1.1.1 2003/03/28 15:34:04 dykes Stab $
!NRL: $Name:  $
C              OCEAN PACK COMMON BLOCKS, file 3 of 4
C
C     Contents of this file
C
C     COMMON / OUTPDA / *** data for output, mainly plotting
C     COMMON / PLDATA / *** Plotting related variables
C     COMMON / BINARY / *** bits and hexadecimals
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72 IJsbrand G. Haagsma
C
C  1. Updates
C
C     30.72, Sept 97: Created from the old ocpcomm.ftn file
C
C  2. Purpose
C
C     Common variables used by the Ocean Pack Service Routines and in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C        [???] default value
C
C SUBLMX [  5] Array size of ????
C
      INTEGER             SUBLMX
      PARAMETER           (SUBLMX = 5)
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C  COMMON / OUTPDA / *** data for output, mainly plotting ***
C
C     Common variables
C
C        [??????] default value
C
C MXQ    [CALCUL] number of grid points of the output frame in X-direction
C                 =OUTPS(7);
C MYQ    [CALCUL] number of grid points of the output frame in Y-direction
C                 =OUTPS(8);
C PFROPT [     2] frame option in plot, read from SWANINIT
C SUBLNS [CALCUL] number of lines available in the plot legend
C                 =3; if FROPT=1
C                 =4; if FROPT=2
c
      INTEGER             MXQ,         MYQ
      INTEGER             PFROPT,      SUBLNS
C
C LEFT   [.TRUE.] the coordinate system is left/right-oriented
C                 i.e. counterclockwise from X to Y/clockwise from Y to X
C PENUP  [      ] not used
C
      LOGICAL             LEFT,        PENUP
C
C DXQ    [      ] mesh size of the output frame in X-direction
C                 =0.01; if MXQ=1 ????
C                 =XQLEN/(MXQ-1); if MXQ>1
C DYQ    [      ] mesh size of the output frame in Y-direction
C                 =0.01; if MYQ=1 ????
C                 =YQLEN/(MYQ-1); if MYQ>1
C HORSC  [      ] horizontal scale
C                 =OCREAL(OUTPS(9)) / OCREAL(OUTPS(2)); if PSTYPE='F' ????
C                 =OCREAL(OUTPS(9)) / (XPMAX - XPMIN); if PSTYPE='H' ????
C                 =(XPHI-XPLO) / (XFHI-XFLO) in swanout3.ftn ????
C LSC    [      ] not used
C SYMSIZ [  0.25] size of the symbols in the plot
C                 =0.2; if size of paper is not given
C                 =XASM/60.; if size of paper is given
C VERNUM [ 30.72] version number of SWAN
C VRTSC  [      ] vertical scale
C                 =OCREAL(OUTPS(10))/ OCREAL(OUTPS(3)); if PSTYPE='F' ????
C                 =OCREAL(OUTPS(10))/ (YPMAX - YPMIN); if PSTYPE='H' ????
C                 =(YPHI-YPLO) / (YFHI-YFLO) in swanout3.ftn ????
C VSC    [      ] not used
C XASL   [      ] size on paper of geographic area in x-direction
C                 =HORSC*XQLEN + PMARG in swanout2.ftn ????
C                 =XASM in swanout3.ftn ????
C XASM   [      ] max. size of area available for plotting isolines and vector
C                 fields in x-direction
C                 =PLPARM(1) ????
C XFHI   [      ] upper limit of X in the physical plane
C                 =FRMAX ????
C                 =1.5 * FRMAX ????
C                 =3. * PI2 / PPER ????
C XFLO   [      ] lower limit of X in the physical plane
C                 =-FRMAX ????
C                 =0. ????
C XPHI   [      ] highest x on paper of geographic area
C                 =0.5 * (XASM+XASL), if FROPT=1,2 ????
C                 =XASL, in swanout2 ????
C                 =XPLO + PLSIZE, in swanout3????
C XPLO   [      ] lowest x on paper of geographic area
C                 =0.5 * (XASM-XASL), if FROPT=1,2 ????
C                 =0., in swanout2 ????
C                 =XMAR + 6.*CHSIZE, in swanout3 ????
C XPSUB(SUBLMX)   place (X-coord.) of the legends in the frame
C  (I)            =(SUBLNS-I) * XASM / 3., if FROPT=1 ????
C                 =XPLO + 41. * SYMSIZ, if FROPT=2 ????
C YASL   [      ] size on paper of geographic area in y-direction
C                 =VRTSC*YQLEN + PMARG in swanout2.ftn ????
C                 =YASM in swanout3.ftn ????
C YASM   [      ] max. size of area available for plotting isolines and vector
C                 fields in y-direction
C                 =PLPARM(2) - 0.1*XASM; if PFROPT=1 ????
C                 =PLPARM(2) - 0.12*XASM; if PFROPT<>1 ????
C YFHI   [      ] upper limit of Y in the physical plane
C                 =FRMAX ????
C                 =1.0 * EMAX ????
C YFLO   [      ] lower limit of Y in the physical plane
C                 =-FRMAX ????
C                 =0. ????
C YPHI   [      ] highest y on paper of geographic area
C                 =YPLO + YASL, if FROPT=1,2 ????
C                 =YASL, in swanout2 ????
C                 =YPHI - PLSIZE, in swanout3 ????
C YPLO   [      ] lowest y on paper of geographic area
C                 =0.1 * XASM, if FROPT=1 ????
C                 =0.15 * XASL, if FROPT=2 ????
C                 =0., in swanout2 ????
C                 =YMAR + YASL - 9.*CHSIZE, in swanout3 ????
C YPSUB(SUBLMX)   place (Y-coord.) of the legends in the frame
C                 =0. if FROPT=1 ????
C  (I)            =(2.*I-1.) * SYMSIZ, if FROPT=2 ????
C
      REAL                DXQ,         DYQ,         HORSC,       LSC
      REAL                SYMSIZ,      VERNUM,      VRTSC,       VSC
      REAL                XASL,        XASM,        XFHI,        XFLO
      REAL                XPHI,        XPLO,        XPSUB(SUBLMX)
      REAL                YASL,        YASM,        YFHI,        YFLO
      REAL                YPHI,        YPLO,        YPSUB(SUBLMX)
C
      COMMON / OUTPDA /   LEFT,        PFROPT,      VERNUM,      XASM
      COMMON / OUTPDA /   YASM,        MXQ,         MYQ,         DXQ
      COMMON / OUTPDA /   DYQ,         XASL,        YASL,        SYMSIZ
      COMMON / OUTPDA /   LSC,         VSC,         PENUP,       XPLO
      COMMON / OUTPDA /   XPHI,        YPLO,        YPHI,        HORSC
      COMMON / OUTPDA /   VRTSC,       XFLO,        XFHI,        YFLO
      COMMON / OUTPDA /   YFHI,        SUBLNS,      XPSUB,       YPSUB
 
C-------------------------------------------------------------------------------
C
C     COMMON / PLDATA /  *** Plotting related variables
C
C     Common variables
C
C           [????] default value
C
C IPLOPT    [   2] Plotting option (set in file SWANINIT)
C                  =1; OPPL
C                  =2; HPGL
C IUPLF     [    ] Unit reference number of the PLOT file
C
      INTEGER             IPLOPT,      IUPLF
C
C           [????] default value
C
C PLFACT    [  1.] Not used ???
C PLPARM(10)       Plotting parameters (set in file SWANINIT)
C ( 1)      [ 18.] Maximum size available for plotting in hor. direction (cm)
C ( 2)      [ 26.] Maximum size available for plotting in vert. direciton (cm)
C ( 3)      [402.] Number of plotting units per cm
C ( 4)      [  0.] Margins in horizontal direction
C ( 5)      [  0.] Margins in vertical direction
C ( 6)      [  0.] Orientation
C                  =0.; Portrait
C                  =1.; Landscape
C
      REAL                PLFACT,      PLPARM(10)
C
      COMMON / PLDATA /   IPLOPT,      IUPLF,       PLFACT,     PLPARM
C
C-------------------------------------------------------------------------------
C
C     COMMON / BINARY /  *** ????
C
C     Common variables
C
C           [????] default value
C
C BIT(80)   [    ] Not used????
C
      INTEGER             BIT(80)
C
      COMMON / BINARY /   BIT
C
