!NRL: $Id: swancom1.F,v 1.6.2.2 2003/07/02 14:19:00 dykes Exp $
!NRL: $Name:  $
C     Last change:  YGH  27 Oct 2000   11:56 am
C
C     SWAN/COMPU    file 1 of 6
C
C
C     PROGRAM SWANCOM1.FOR
C
C     This subroutine SWANCOM1 of the main program SWAN
C     includes the next subroutines :
C
C     SWCOMP  main subroutine for the computational module                31.02
C     SWOMPU  carries out ocmputation for one grid point                  31.02
C     ACTION  (fill the arrays with the derivatives of the action eq.)
C     SACCUR  (calculate the accuracy and check if the iteration process
C              can be terminated)
C     SINTGRL (calculate some general wave (integral) parameters)         40.02
C     INSAC   (initialize the values for the calculation of accuracy)     40.00
C     SOLMAT  (solve tri-diagonal matrix in absence of a current)
C     SOLBAND (solve band matrix (implicit scheme in freq. space) with    40.00
C              iterative ILU-CGSTAB solver)
C     SOLMT1  (solve tri-diagonal matrix in presence of a current: almost
C              identical as SOLMAT, however, space in theta can be
C              periodic (coeeficients arise in the matrix corners)
C     SOURCE   (fill the array with the source terms)
C
C----------------------------------------------------------------------
C     The following subroutines can be found in the file : SWANCOM2.FTN
C
C     SBOT    (Bottom friction )
C     FRABRE  (Fraction of breaking waves)
C     FRABRE2 (Fraction of breaking waves, smoother version of FRABRE)    30.77
C     SSURF   (Wave breaking: Battjes and Janssen (1978) )
C     SWCAP   (Whitecapping; five formulations)                           40.02
C     BLOCKE  (remove action from spectrum for explicit calculation)
C     BRKPAR  (determine slope depended breaking parameter according
C              to Nelson (199?)
C     CNTAIL  (contributions to the spectrum of the high frequency
C              tail)
C     PLTSRC  (store the values for plot of the source terms and spec.)
C
C----------------------------------------------------------------------
C     The following subroutines can be found in the file : SWANCOM3.FTN
C
C     WINDP1 (computation of variables derived from the wind such as
C             mean wind velocity, mean wind direction, minimum counter
C             for the wind, maximum counter for the wind, wind friction
C             velocity and the Pierson Moskowitz frequency )
C     WINDP2 (computation of wind sea energy spectrum necessary for
C             the second generation wind growth model)
C     WINDP3 (limit the energy spectrum in the case of a first or
C             second generation wind growth model)
C     SWIND0 (linear input term Cavaleri and Malanotte Rizolli )
C     SWIND1 (first generation wind growth model (Dolphin formulation)
C     SWIND2 (second generation wind growth model (Dolphin formulation)
C     SWIND3 (third generation wind growth model (Snyder et al. 1981;
C             Komen et al., 1984)
C     SWIND4 (third generation wind growth model (Janssen, 1989,1991)
C     NEWTON (determine the new friction velocity for the Janssen
C             growth fromulation with an iterative Newton-Raphson method
C
C----------------------------------------------------------------------
C     The following subroutines can be found in the file : SWANCOM4.FTN
C
C     BND4WW (Array boundaries for 4WW interactions)
C     SWFAC  (compute the nonlinear wave-interactions variables for
C             the subroutines in SWANCOM4.FTN)
C     SWSNL1 (Nonlinear four wave-wave interactions semi explicit for
C             the wave components that fall withi a sweep)
C     SWSNL2 (Nonlinear four wave-wave interactions fully explicit
C             scheme )
C     SWSNL3 (Nonlinear four wave-wave interactions fully explicit
C             scheme per iteration )
C     FILNL3 (get values from array for interactions for full circle)
C     STRIAD (Non linear three wave wave interactions )
C
C---------------------------------------------------------------------
C     The following subroutines can be found in the file : SWANCOM5.FTN
C
C     SWPSEL   ( determine spectral counters in presence
C               or absence of a current)
C     SPROXY  ( compute propagation module CAX, CAY )
C     SPROSD  ( compute propagation module CAS, CAD )
C     STRSX   ( compute derivative in x-space explicit )
C     STRSY   ( compute derivative in y-space explicit )
C     STRSSI  ( compute derivative in s-space implicit scheme )
C     STRSS1  ( compute derivative in s-space according to TOLMAN )
C     STRSD   ( compute derivative in d-space implicit )
C     SWAPAR  ( compute wave parameters k, cgo, cg )
C     SPREDT  ( calcultae action density in central point:first guess)
C     SOLDIF  (solve the matrix in frequency space for each direction
C              --> adding diffusion to the frequency spectrum in case
C                  of wave blocking
C     ADDDIS  (adds leak and dissipation to arrays in COMPDA, after
C              action densities have been computed)
C
C----------------------------------------------------------------------
C     The following subroutines can be found in the file : SWANCOMI.FTN
C
C     CGSTAB   Solve an unsymmetric system of linear equations
C              by the Bi-CGSTAB method. The subroutine contains
C              a number of preconditioners.
C     DAXPY    ?
C     DCOPY    ?
C     DIAG     Makes a diagonal scaling of the matrix in case of
C              a momentum equations, a transport equation, or a
C              pressure equation.
C     DIAGMU   Multiplication of x with the diagonal matrix given in
C              prec. The array prec sould be filled by subroutine
C              diag.f
C     DINVL3   Multiplication of x by L, the preconditioning matrix
C              given in prec.
C     DINVU3   Multiplication of x by U, the preconditioning matrix
C              given in prec.
C     DMLU3    Calculates an upper triangular matrix U and a lower
C              triangular matrix L, which form an incomplete
C              decomposition of A.
C     DRUMA1   determine the right Hand vector b
C     ISSOLV   The subroutine issolv is used to solve an unsymmetric
C              system of equations of the shape A x = f.
C     MKPREC   The subroutine mkprec is used to build a preconditioner.
C     PREVC    Prevc multiplies the vector x with a preconditioner.
C     PRIRES   This is an output subroutine. It prints the norm of
C              the residual
C     VULMAT   Academic test for solver
C     VULMT1   Fills matrix with coefficents of SWAN
C----------------------------------------------------------------------
C
C     ****************************************************************
C
C     The main program structure of SWAN with its subroutines
C     is as follows :
C
C     +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     +                                                               +
C     +  SWANMAIN                                                     +
C     +  =============                                                +
C     +              |                                                +
C     +              |---- SOPCRE, SOPIDS, SOPLOT                     +
C     +              |                                                +
C     +              |---- SWANPRE1, SWANPRE2                         +
C     +              |                                                +
C     +              |---- SWANCOM1, SWANCOM2, SWANCOM3, SWANCOM4,    +
C     +              |     SWANCOM5                                   +
C     +              |                                                +
C     +              |---- SWANOUT1, SWANOUT2, SWANOUT3               +
C     +                                                               +
C     +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C
C******************************************************************
C
!     Pooled arrays WAREA, RWAREA, and LWAREA were removed to facilitate  40.22
!     parallelization with OpenMP.                                        40.22
      SUBROUTINE SWCOMP (AC1        ,AC2        ,                         40.22
     &                   COMPDA     ,                                     40.22
     &                   SPCDIR     ,SPCSIG     ,                         30.72
     &                   SWTSDA     ,XYTST      ,
     &                   IT         ,KGRPNT     ,
     &                   XCGRID     ,YCGRID     ,                         30.72
     &                   OBSTA      ,CROSS      )
C
C******************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.75: IJsbrand Haagsma (Bug fix)
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     31.03: Annette Kieftenburg
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     33.08: W. Erick Rogers (some S&L scheme-related changes)
C     33.10: Nico Booij and Erick Rogers
C     34.01: Jeroen Adema
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     30.72, Nov. 97: Declaration of MSC4MI, MSC4MA, MDC4MI, MDC4MA and
C                     ISTAT removed because they are common and already
C                     declared in the INCLUDE file
C     30.72, Nov. 97: ITERMX can be chosen freely with NUM ACCUR also in dynamic
C                     mode. Default ITERMX=6. Needs extensive testing
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.02, Jan. 98: Introduced 1D-version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: call WINDP0 removed, function taken over by WINDP1
C     30.72, Mar. 98: Current switched off for the first iteration, when
C                     preconditining is required
C     30.72, Mar. 98: Writes the result of the iteration step to the PRINT
C                     file
C     30.75, Mar. 98: Renamed SLOW to SIGLOW, because SLOW was used only locally
C     31.03, Feb. 98: Call SETUPP added, initialisation of array SETPDA
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     33.08, July 98: some S&L scheme-related changes
C     30.82, July 99: Corrected argumentlist SETUPP
C     40.00, July 99: argument KQUAD removed from call PLTSRC
C     30.82, Sep. 99: Modified messages in case of non-convergence
C     33.10, Jan. 00: minor changes re: the SORDUP scheme
C     40.03, Mar. 00: Ursell number is now array (value for each grid point)
C     40.02, Oct. 00: Avoided real/int conflict by introducing replacing
C                     RWAREA for WAREA in FAC4WW and SETUPP
C     40.13, Mar. 01: comments changed;
C                     order of calling SWAPAR and SPROXY changed
C                     message concerning lack of convergence only to print file
C                     in nonstationary cases
!     40.22, Sep. 01: WAREA, LWAREA, and RWAREA structures removed        40.22
!                     and replaced with allocated arrays to ease          40.22
!                     OpenMP implementation.                              40.22
!     40.22, Sep. 01: OpenMP directives were added to parallelize the     40.22
!                     outer Y loop for the call to SWOMPU in the sweep    40.22
!                     across the computational grid.                      40.22
!     40.22, Sep. 01: Added logical array LLOCK for thread management     40.22
!                     during parallel operation.  It will not affect      40.22
!                     serial execution.                                   40.22
!     40.22, Sep. 01: Changed array definitions to use the parameter      40.22
!                     MICMAX instead of ICMAX.                            40.22
C
C  2. Purpose
C
C     The aim of this model is to simulate the wave energy in
C     shallow water areas. In the subroutine SCOMPU the main processes
C     taking place in the shallow water zone are determined in
C     several subroutines.
C     The input for this subroutine comes from SWANPRE1, SWANPRE2,
C     and SWANPRE3. The output is send to the subroutines SWANOUT1,
C     SWANOUT2 and SWANOUT3. The output consist of some characteristic
C     wave parameters and the wave action density. The equations are
C     all based on the action density N which is a function of the
C     spatial position (x,y) the relative frequency (s) and the
C     spectral direction (d).
C
C  3. Method
C
C     Keywords:
C     Action density, propagation terms, refraction, reflection,
C     white capping, wave breaking, bottom friction, nonlinear
C     and nonhomegeneous wind- and current-fields, wave blocking
C     fully spectral description, non linear wave-wave interaction,
C     CGSTAB solver
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C
C     INTEGERS:
C     --------------------------------------------------------------
C     IC                Dummy variable: ICode gridpoint:
C                       IC = 1  Top or Bottom gridpoint
C                       IC = 2  Left or Right gridpoint
C                       IC = 3  Central gridpoint
C                       Whether which value IC has, depends of the sweep
C                       If necessary ic can be enlarged by increasing
C                       the array size of ICMAX
C     ITER              Counter of iterations per 4 sweeps for accuracy
C     ITERMX            MAximum number of iterations in model
C     IX                Counter of gridpoints in x-direction
C     IY                Counter of gridpoints in y-direction
C     IS                Counter of relative frequency band
C     IT                Counter in time space
C     ID                Counter of directional distribution
C     IBOT              Indicator for bottom friction
C                       IBOT = 0  no bottom friction dissipation
C                       IBOT = 1  Jonswap bottom dissipation model
C                       IBOT = 2  Dingemans bottom dissipation model
C                       IBOT = 3  Madsen bottom dissipation model
C     ICUR              Indicator for current
C     ISURF             Indicator for wave breaking
C     ITRIAD            Indicator for nonlinear triad interactions
C     IQUAD             Indicator for nonlinear quadruplet interactions
C     IWCAP             Indicator for wave capping
C     IWIND             Indicator for which wind generation model is used
C                       IWIND = 1 first generation wind growth model
C                       IWIND = 2 second generation wind growth model
C                       IWIND = 3 third generation wind growth model
C     IREFR             indicator for refraction (can be truned off)
C     ITFRE             indicator for transport of action in frequency
C                       space
C     ICMAX             Maximum array size for the points of the molecul
C     KSX      input    Dummy variable to get the right sign in the
C                       numerical difference scheme in X-direction
C                       depending of the sweep direction, KSX = -1 or +1
C     KSY      input    Dummy variable to get the right sign in the
C                       numerical difference scheme in Y-direction
C                       depending of the sweep direction, KSY = -1 or +1
C     MXC               Maximum counter of gridppoints in x-direction in
C                       computational model: (XLEN/DX + 1 )
C     MYC               Maximum counter of gridppoints in y-direction in
C                       computational model: (YLEN/DY + 1 )
C     MSC               Maximum counter of relative frequency in
C                       computational model
C     MDC               Maximum counter of directional distribution in
C                       computational model (2PI / DDIR + 1)
C     MTC               Maximum counter of the time, i.e.:
C                       (total time in proto type) / (time step)
C     MBOT              Maximum array size for PBOT
C     MSURF             Maximum array size for PSSURF
C     MTRIAD            Maximum array size for PTRIAD
C     MWCAP             Maximum array size for PWCAP
C     MWIND             Maximum array size for PWIND
C
C     REALS:
C     --------------------------------------------------------------
C
C     ALEN              Part of side length of an angle side
C     BETA              Angle between DX end DY
C     BLEN              Part of side length of an angle side
C     DIR               Spectral direction (i.e., ID*DDIR)
C     DX       input    Length of spatial cell in X-direction
C     DY       input    Length of spatial cell in Y-direction
C     DS       input    Width of frequency band (is not constant because
C                       of the logharitmic distribution of the frequency
C     DDIR     input    Width of directional band
C     DT       input    Time step
C     DDX      input    Same as DX but with correct sign depending of the
C                       direction of the sweep (+1. OR -1. ) no input
C     DDY      input    Same as DY but with correct sign depending of the
C                       direction of the sweep (+1. OR -1. ) no input
C     FAC_A             Factor representing the influence of the action-
C                       density depening of the propagation velocity
C     FAC_B             Factor representing the influence of the action-
C                       density depending of the propagation velocity
C     GAMMA             PI - alpha - beta
C     HM                Maximum waveheight (breaking source term)
C     GRAV     input    Gravitational acceleration
C     PI                3.141592654
C
C     one and more dimensional arrays:
C     ---------------------------------
C
C     AC1       4D    Action density as function of D,S,X,Y at time T
C     AC2       4D    (Nonstationary case) action density as function
C                     of D,S,X,Y at time T+DT
C     CGO       2D    Group velocity as function of IC and IS in the
C                     direction of wave propagation in absence of currents
C     CG        3D    Group velocity as function of IC and IS and D in the
C                     direction of wave propagation in presence of currents
C     CAX       3D    Wave transport velocity in x-direction, function of
C                     (ID,IS,IC)
C     CAY       3D    Wave transport velocity in y-direction, function of
C                     (ID,IS,IC)
C     CAS       3D    Wave transport velocity in S-direction, function of
C                     (ID,IS,IC)
C     CAD       3D    Wave transport velocity in D-dirction, function of
C                     (ID,IS,IC)
C     COMPDA    3D    array containing depth and other arrays of (IX,IY)  20.39
C                     JDP1    Depth as function of X and Y at time T
C                     JDP2    (Nonstationary case) depth as function of X and Y
C                             at time T+DT
C                     JVX1    X-component of current velocity of X and Y
C                             at time T
C                     JVX2    (Nonstationary case) X-component of current
C                             velocity in (X,Y) at time T+DT
C                     JVY1    Y-component of current velocity in (X,Y)
C                             at time T
C                     JVY2    (Nonstationary case) Y-component of current
C                             velocity in (X,Y) at time T+DT
*                     JWX2    X-component of wind velocity in (X,Y)       40.00
*                             at time T+DT (nonstationary case)           40.00
*                     JWY2    Y-component of wind velocity in (X,Y)       40.00
*                             at time T+DT (nonstationary case)           40.00
C                     JUBOT   Absolute orbital velocity in a gridpoint (IX,IY)
C     SWTSDA    4D    intermediate data computed for the test points;
C                     there are MTSVAR subarrays:
C                     JPWNDA   wind source term part A
C                     JPWNDB   wind source term part B
C                     JPWCAP   whitecapping source term
C                     JPBTFR   bottom friction
C                     JPWBRK   surf breaking
C                     JP4S     quadruplet interactions
C                     JP4D     quadruplet interactions
C                     JPTRI    triad interactions
C     ALIMW     1D    Maximum energy by wind growth. This dummy array is
C                     used because the maximum value has to be checked
C                     direct after the solver of the tridiagonal matrix
C                     see the subroutine SOLMAT
C     GROWW     1D    Check for a certain frequency if the waves are
C                     growing or not in a spectral direction (LOGICAL)
C     HSACC1    2D    Represent the significant wave height at time T
C     HSACC2    2D    Represent the significant wave height at time T+1
C     IMATDA    2D    Coefficients of diagonal of matrix
C     IMATLA    2D    Coefficients of lower diagonal of matrix
C     IMATUA    2D    Coefficients of upper diagonal of matrix
C     IMATLL    2D    Coefficients of lower diagonal of matrix
C     IMATUU    2D    Coefficients of upper diagonal of matrix
C     IMATRA    2D    Coefficients of right hand side of matrix
C     KWAVE     2D    wavenumber as function of the relative frequency S
C                     and position IC(ix,iy)
C     PBOT      1D    Coefficient for the bottom friction models
C     PSURF     1D    Coefficient for the wave breaking model
C     PTRIAD    1D    Coefficient for the triad interaction model
C     PWCAP     1D    Coefficient for the white capping model
C     PWIND     1D    Coefficient for the wind growth model
C     SACC1     2D    Represents the mean wave period at time T
C     SACC2     2D    Represents the mean wave period at time T+1
C     PWTAIL    1D    coefficients for tail of spectrum
C     IDCMIN    1D    frequency dependent counter in directional space
C                     no current <---> current
C     IDCMAX    1D    frequency dependent counter in directional space
C                     no current <---> current
C     ISCMIN    1D    frequency dependent counter in frequency space
C                      no current <---> current
C     ISCMAX    1D    frequency dependent counter in frequency space
C                     no current <---> current
C     SECTOR    1D    Indicates which configuration is present (see
C                     subroutine SWPSEL )
C     ANYBIN    2D    Set a particular bin TRUE or FALSE depending on
C                     SECTOR
C     WWINT     1D    Counters for 4 wave-wave interactions
C     WWAWG     1D    Weight coefficients for the 4 wave-wave interactions
C     WWSWG     1D    Weights coefficients for the 4 wave-wave interactions
C                     for the semi-implicit computation
C     COLU2     1D    In presence of a current the spectral direction can
C                     be circular and closed. Matrixcoefficients appear in
C                     the top right and bottom left corner of the matrix
C                     After pivoting --> coefficients are stored in COLU2
C                     space
C     DIFLOW    2D    Lower diagonal in solver for diffsion
C     DIFDIG    2D    Diagonal in solver for diffusion
C     DIGUPP    2D    Upper diagonal in solver for diffusion
C     DIFRHV    2D    Right hand vector
C
C     Coefficients for the arrays:
C     -----------------------------
C                         default
C                         value:
C
C     PBOT(1)   = CFC      0.005    (Collins equation)
C     PBOT(2)   = CFW      0.01     (Collins equation)
C     PBOT(3)   = GAMJNS   0.0038   (Jonswap equation)
C     PBOT(4)   = MF      -0.08     (Madsen equation)
C     PBOT(5)   = KN       0.05     (bottom roughness)
C
C     ISURF                1        (Constant breaking coefficient)
C                          2        (variable breaking coefficient
C                                    according to Nelson (1994))
C     PSURF(1)  = ALFA     1.0      (Battjes Jansen)
C     PSURF(2)  = GAMMA    0.8      (Breaking criterium)
C
C     PWCAP(1)  = ALFAWC   2.36e-5  (Emperical coefficient)
C     PWCAP(2)  = ALFAPM   3.02E-3  (Alpha of Pierson Moskowitz frequency)
C
C     PWIND(1)  = CF10     188.0    (second generation wind growth model)
C     PWIND(2)  = CF20     0.59     (second generation wind growth model)
C     PWIND(3)  = CF30     0.12     (second generation wind growth model)
C     PWIND(4)  = CF40     250.0    (second generation wind growth model)
C     PWIND(5)  = CF50     0.0023   (second generation wind growth model)
C     PWIND(6)  = CF60    -0.2233   (second generation wind growth model)
C     PWIND(7)  = CF70     0.       (second generation wind growth model)
C     PWIND(8)  = CF80    -0.56     (second generation wind growth model)
C     PWIND(9)  = RHOAW    0.00125  (density air / density water)
C     PWIND(10) = EDMLPM   0.0036   (limit energy Pierson Moskowitz)
C     PWIND(11) = CDRAG    0.0012   (drag coefficient)
C     PWIND(12) = UMIN     1.0      (minimum wind velocity)
C     PWIND(13) = PMLM     0.13     (  )
C
C     PNUMS(1)  = DREL     relative error in Hs and Tm
C     PNUMS(2)  = DHABS    absolute error in Hs
C     PNUMS(3)  = DTABS    absolute error in Tm
C     PNUMS(4)  = NPNTS    number of points were accuracy is reached
C
C     PNUMS(4)  = NOT USED
C     PNUMS(5)  = NOT USED
C     PNUMS(6)  = CDD      numerical diffusion in theta space
C     PNUMS(7)  = CSS      numerical diffusion in sigma space
C     PNUMS(8)  = NUMFRE   numerical schem in frequency space :
C                          1) implicit scheme
C                          2) explciti scheme CFL limited
C                          3) explciit scheme filter after iteration
C     PNUMS(9)  = DIFFC    if explicit scheme is used, then numerical
C                          diffusion coefficient can be chosen
C     PNUMS(10)  = PREC    type of preconditioner
C     PNUMS(11)  = EPS1    epsilon 1 in equation to terminate iteration
C     PNUMS(12)  = EPS2    epsilon 2 in equation to terminate iteration
C     PNUMS(13)  = OUTP    request for output for solver
C     PNUMS(14)  = NITER   maximum number of iterations for solver
C     PNUMS(15)  = NOT USED
C     PNUMS(16)  = NOT USED
C     PNUMS(17)  = NOT USED
C     PNUMS(18)  = NOT USED
C     PNUMS(19)  = CFL      CFL criterion for option explicit scheme
C                           in frequency space (see PNUMS(8)
C     PNUMS(20)  = GRWMX    maximum growth inspectral bin
C
C     arrays for the 4-wave interactions:
C
C     WWINT ( 1 = IPD    WWAWG ( = AGW1    WWSWG ( = SWG1
C             2 = IDP1           = AWG2            = SWG2
C             3 = IDM            = AWG3            = SWG3
C             4 = IDM1           = AWG4            = SWG4
C             5 = ISP            = AWG5            = SWG5
C             6 = ISP1           = AWG6            = SWG6
C             7 = ISM            = AWG7            = SWG7
C             8 = ISM1           = AWG8 )          = SWG8  )
C             9 = ISLOW
C             10= ISHGH
C             11= ISCLW
C             12= ISCHG
C             14= IDLOW
C             15= IDHGH
C             16= MSC4MI
C             17= MSC4MA
C             18= MDC4MI
C             19= MDC4MA
C             20= MSCMAX
C             21= MDCMAX )
C
C
C  6. Local variables
C
C     SIGLOW: recommende lowest frequency when TRIADS are activated
C
      REAL    SIGLOW
C
C  8. Subroutines used
C
C     INSAC
C     SWOMPU
C     SACCUR
C     PLTSRC
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWANPREn, SWANOUTn
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     SCOMPU is the main subroutine is and called of the main program SWAN.
C     The main program SWAN is build of three main subroutines:
C
C     1. SPRE      (preparation of the computation (reading parameters))
C     2. SCOMPU    (computation of the action densities (discussed below))
C     3. SOUT      (output of the program)
C
C     In this part the subroutine SCOMPU is discussed:
C
C     SCOMPU                                 Sweeps: loop over spatial points
C     ======
C      |
C      |------+  INSAC                       determine initial values for
C      |                                     accuracy check
C      |
C      |-------+ SINSTR                      read incoming waves (this
C      |                                     subroutine should be implemeted
C      |                                     in the SWANMAIN instead of in
C      |                                     SWANCOM1
C      |
!      |
!      Begin parallel region over threads                                 40.22
!      |
C      |-------+ SWOMPU
C      |       |
C      |       |--------+ SWAPAR             determ. of waveparameters
C      |       |
C      |       |--------+ SPROXY             comp. of propagation
C      |       |                             velocities of energy:
C      |       |                             CAX, CAY
C      |       |
C      |       |--------+ SPROSD             comp. of propagation
C      |       |                             velocities of energy:
C      |       |                             CAS, CAD
C      |       |
C      |       |--------+ WINDP1             compute absolute wind, FPM
C      |       |                             mean wind direction, min. and
C      |       |                             max. counters for the wind,
C      |       |                             wind friction velocity
C      |       |
C      |       |--------+ CNTAIL             Compute contributions to
C      |       |                             spectrum due to high frequency
C      |       |                             tail
C      |       |
C      |       |--------+ SPREDT             predict energy density in
C      |       |                             gridpoints for first
C      |       |                             iteration
C      |       |
C      |       |--------+ STABIL             check stability of comp.
C      |       |
C      |       |--------+ SINTGRL            comp. Ub, Etot, Hmax, Qb,    40.02
C      |       |        |                    SME, SMA, SMESPC , SMASPC
C      |       |        |
C      |       |        +-------+ FRABRE2    comp. of fraction of         30.77
C      |       |                             breaking waves
C      |       |                             (This subroutine replaces
C      |       |                             FRABRE)
C      |       |
C      |       |--------+ SOURCE             comp. of source terms
C      |       |        |
C      |       |        +-------+ SBOT       bottom friction
C      |       |        |
C      |       |        +-------+ SWCAP      white capping
C      |       |        |
C      |       |        +-------+ SSURF      wave breaking
C      |       |        |
C      |       |        +-------+ STRIAD     nonlinear wave interactions
C      |       |        |
C      |       |        +-------+ SWIND1     first generation wind model
C      |       |                |
C      |       |                + -- WINDP2  compute total wind sea energy o
C      |       |                |    SWIND2  second generation wind model
C      |       |                |
C      |       |                + SWIND3     third generation wind model
C      |       |
C      |       |--------+ ACTION             comp. of ACTION balance eq.
C      |       |        |                    (  @ CAn/@n )
C      |       |        |
C      |       |        +-------+ STIME      comp. of (@AC2/@t)
C      |       |        |
C      |       |        +-------+ STRSX      @[CAX AC2]/@X
C      |       |        |
C      |       |        +-------+ STRSY      @[CAY AC2]/@Y
C      |       |        |
C      |       |        +-------+ STRSS      @[CAS AC2]/@S
C      |       |        |
C      |       |        +-------+ STRSD      @[CAD AC2]/@D
C      |       |
C      |       |--------+ SOLMAT             solve the matrix which is
C      |       |                             filled in SOURCE and ACTION
C      |       |
C      |       |--------+ FILIMP             filter the frequency spectrum
C      |       |   |                         in presence of a current using
C      |       |   |                         a diffusion model (important for
C      |       |   |                         wave blocking) -->IMPLICIT SCHEME
C      |       |   |
C      |       |   |----+ DIFSOL             The matrix filled in FILIMP is
C      |       |                             solved for each direction seperately
C      |       |
C      |       |--------+ WINDP3             Limit the energy spectrum
C      |                                     for first and second
C      |                                     genartion wind model
C      |
!      |
!      End parallel region over threads                                   40.22
!      |
C      |-------+ PLTSRC                      write sourceterm after an
C      |                                     iteration to a file SOURCE
C      |
C      |-------+ SACCUR                      check accuracy of the comp.
C      |
C     END SCOMPU
C
C
C 12. Structure
C
C     The general numerical procedure in SWAN is based on the next
C     principle of sweeps (see Holthuijsen et al 1993) where
C
C
C       {**************************************************************}
C       {           definition of the sweep directions                 }
C       {                                                              }
C       {                   \         N         /                      }
C       {     swp_NW = 4     _\|      |      |/_   swp_EN = 3          }
C       {                             |                                }
C       {                             |                                }
C       {             W --------------------------- E  (0 degrees,id=1)}
C       {                             |                                }
C       {                   __.       |      .__                       }
C       {     swp-WS = 1     /|       |      |\    swp_SE = 2          }
C       {                  /          S         \                      }
C       {                                                              }
C       {**************************************************************}
C       {                                                              }
C       { swp_nw:         *  ksy=+1   swp_en:        *  ksy=+1         }
C       {                 |                          |                 }
C       {                 |  -dy                -dy  |                 }
C       {            dx   |                          |  -dx            }
C       {       *---------o  IX,IY            IX,IY  o--------*        }
C       {     ksx=-1                                    ksx=+1         }
C       {                                                              }
C       {                                                              }
C       { swp_ws:    dx               swp_se:           -dx            }
C       {       *---------o  IX,IY            IX,IY  o--------*        }
C       {       ksx=-1    |                          |     ksx=+1      }
C       {                 |  dy                  dy  |                 }
C       {                 |                          |                 }
C       {                 *  ksy=-1                  *  ksy=-1         }
C       {**************************************************************}
C
C     ----------------------------------------------------------
C     Call INSAC to give values to HSASCC en SASCC to check the accuracy
C     ----------------------------------------------------------
C     For IT = 1 to end of computation time (MTC), do,
C
C       Call SINSTR to read incoming waves at the boundaries (N,E,S,W) in
C                   stationary and nonstationary case  SINSTR changes
C
C
C       If accuracy <= given accuracy, then do iteration,
C
C         -----------------------------------------------------
C         give argument for sweep : swpdir = 1
C         KSX = -1         DDX = +DX.
C         KSY = -1         DDY = +DY.
C         give number of direction a start and an end value:
C         For IY=2 to MYC and IX=2 to MXC, do,
C            Call SWOMPU to compute the wave field
C         -----------------------------------------------------
C         give argument for sweep : swpdir = 2
C         KSX = +1         DDX = -DX.
C         KSY = -1         DDY = +DY.
C         give number of direction a start and an end value:
C         For IX=MXC-1 to 1 and IY=2 to MYC, do,
C            Call SWOMPU to compute the wave field
C         -----------------------------------------------------
C         give argument for sweep : swpdir = 3
C         KSX = +1.         DDX = -DX.
C         KSY = +1.         DDY = -DY.
C         give number of direction a start and an end value:
C         For IY=MYC-1 to 1 and IX=MXC-1 to 1, do,
C            Call SWOMPU to compute the wave field
C         -----------------------------------------------------
C         give argument for sweep : swpdir = 4
C         KSX = -1         DDX = +DX.
C         KSY = +1         DDY = -DY.
C         give number of direction a start and an end value:
C         For IX=2 to MXC and IY=MYC-1 to 1, do,
C            Call SWOMPU to compute the wave field
C         ----------------------------------------------------
C     CALL PLTSRC to write the source term to a file
C     ----------------------------------------------------
C     CALL SACCUR to check the accuracy of the computation
C     --------------------------------------------------------
C     End of SCOMPU
C     --------------------------------------------------------
C
C 13. Source text
C
C     ************************************************************************
C     *                                                                      *
C     *                  MAIN SUBROUTINE OF COMPUTATIONAL PART               *
C     *                                                                      *
C     *                               -- SCOMPU --                           *
C     *                                                                      *
C     *                Definition of variables in main program               *
C     *                                                                      *
C     ************************************************************************
C
      INTEGER :: ITER  ,IX    ,IY    ,IS    ,IT                           30.72
      INTEGER :: IP, IDC, ISC                                             NRL
      INTEGER :: KSX   ,KSY   ,MSCMAX,MDCMAX,SWPDIR
      INTEGER :: INOCNV                                                   30.72
      INTEGER :: INOCNT                                                   NRL
C
      REAL ::  DDX   ,DDY   ,ACCUR ,XIS   ,SNLC1 ,DAL1  ,DAL2  ,DAL3      30.74
C
      LOGICAL :: PRECOR
C
      INTEGER :: XYTST(2*NPTST)                                           30.21
      INTEGER :: KGRPNT(MXC,MYC)                                          30.21
      INTEGER :: OBSTA(*)
      INTEGER :: CROSS(2,MCGRD)
C
      REAL     AC2(MDC,MSC,MCGRD)     ,                                   30.21
     &         AC1(MDC,MSC,MCGRD)     ,                                   30.21
     &         COMPDA(MCGRD,MCMVAR),
     &         SWTSDA(MDC,MSC,NPTSTA,MTSVAR)                              40.00
 
!----------------------------------------------------------------------   40.22
!     Begin declaration for variables that formerly were part of          40.22
!     WAREA, RWAREA, or LWAREA.                                           40.22
!----------------------------------------------------------------------   40.22
      REAL WWAWG(8), WWSWG(8)                                             40.22
 
      REAL RINSOL(7)                                                      40.22
 
      INTEGER, DIMENSION(:), ALLOCATABLE :: IDCMIN, IDCMAX,               40.22
     &                                      SECTOR,                       40.22
     &                                      ISCMIN,ISCMAX                 40.22
      INTEGER WWINT(20), INFMAT(10), IINSOL(14)                           40.22
 
      REAL, DIMENSION(:,:,:), ALLOCATABLE :: CG,CAX,CAY,CAX1,CAY1,        40.22
     &                                       CAS,CAD                      40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: CGO,KWAVE                      40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: ALIMW                          40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: DIFLOW,DIFDIG,                 40.22
     &                                     DIFUPP,DIFRHV                  40.22
 
      REAL, DIMENSION(:), ALLOCATABLE :: COLU2                            40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: BAND,WORK,PRECON               40.22
 
      REAL, DIMENSION(:), ALLOCATABLE :: EXACT,RHV,SOLUT                  40.22
 
      REAL UPPERI(MSC), LOPERI(MSC)                                       40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: UE,SA1,SA2,SFNL                40.22
 
      REAL, DIMENSION(:,:), ALLOCATABLE :: DA1C,DA1P,DA1M,                40.22
     &                                     DA2C,DA2P,DA2M,DSNL            40.22
 
      REAL, DIMENSION(:), ALLOCATABLE :: AF11                             40.22
 
      REAL, DIMENSION(:,:,:), ALLOCATABLE :: MEMNL4                       40.22
 
      REAL, DIMENSION(:,:,:), ALLOCATABLE :: OBREDF                       40.22
 
      REAL, DIMENSION(:), ALLOCATABLE :: HSAC1,HSAC2,SACC1,SACC2          40.22
 
      REAL, DIMENSION(:,:,:), ALLOCATABLE :: SETPDA                       40.22
 
      LOGICAL, DIMENSION(:), ALLOCATABLE :: GROWW                         40.22
 
      LOGICAL, DIMENSION(:), ALLOCATABLE :: ANYWND                        40.22
 
!     SWMATR and LSWMAT replace the single array SWMATR                   40.22
!     that is equivalenced to the logical array LSWMATR                   40.22
!     in the subroutine SWOMPU.                                           40.22
      REAL, DIMENSION(:,:,:), ALLOCATABLE :: SWMATR                       40.22
 
      LOGICAL, DIMENSION(:,:,:), ALLOCATABLE :: LSWMAT                    40.22
 
      LOGICAL, ALLOCATABLE :: LLOCK(:,:)                                  40.22
!-----------------------------------------------------------------------  40.22
!     End declaration for variables that formerly were part of            40.22
!     WAREA, RWAREA, or LWAREA.                                           40.22
!-----------------------------------------------------------------------  40.22
 
!     Add variables for OMP thread parameters.                            NRL
!$    INTEGER,EXTERNAL :: OMP_GET_NUM_THREADS, OMP_GET_THREAD_NUM         NRL
      INTEGER I1GRD,I2GRD,I1MYC,I2MYC                                     NRL

C
C-----------------------------------------------------------------------
C                      End of variable definition
C-----------------------------------------------------------------------
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWCOMP')
C
      IF (IT .EQ. 1 .AND. ITEST.GE.1) THEN                                40.00
        WRITE(PRINTF,333) 'SWAN'                                          40.00
 333    FORMAT(/,
     &'----------------------------------------------------------------'
     &,/,
     &'                  COMPUTATIONAL PART OF ', A
     &,/,
     &'----------------------------------------------------------------'
     &,/)
C
        IF ( ONED ) THEN                                                  32.02
          WRITE(PRINTF,*) 'One-dimensional mode of SWAN is activated'     32.02
        ENDIF                                                             32.02
C
        IF (PROPSC.EQ.3) THEN                                             33.09
          WRITE(PRINTF,*) 'Stelling and Leendertse scheme will be used',  33.08
     &                     ' for spatial propagation.'                    33.08
          ICMAX  = 10                                                     33.08
        ELSE IF (PROPSC.EQ.2) THEN                                        33.10
          WRITE(PRINTF,*) 'The two-upwind-point scheme will be used ',    33.10
     &                    'for geographic propagation.'                   33.10
          ICMAX  = 5                                                      33.10
        ELSE
          WRITE(PRINTF,*) 'BSBT scheme will be used for spatial ',        33.08
     &                    'propagation.'                                  33.08
          ICMAX  = 3                                                      33.10
        ENDIF                                                             33.08
        WRITE(PRINTF,7001) MXC,MYC
 7001   FORMAT(' Gridresolution       : MXC    ',I12  ,' MYC   ',I12)
        WRITE(PRINTF,7101) MSC,MDC
 7101   FORMAT('                      : MSC    ',I12  ,' MDC   ',I12)
        WRITE(PRINTF,7201) MTC,ICMAX
 7201   FORMAT('                      : MTC    ',I12  ,' ICMAX ',I12)
        WRITE(PRINTF,7301) NSTATC, ITERMX
 7301   FORMAT('                      : NSTATC ',I12  ,' ITERMX',I12)
        WRITE(PRINTF,7013) ITFRE,IREFR
 7013   FORMAT(' Propagation flags    : ITFRE  ',I12  ,' IREFR ',I12)
        WRITE(PRINTF,7014) IBOT,ISURF
 7014   FORMAT(' Source term flags    : IBOT   ',I12  ,' ISURF ',I12)
        WRITE(PRINTF,7114) IWCAP,IWIND
 7114   FORMAT('                      : IWCAP  ',I12  ,' IWIND ',I12)
        WRITE(PRINTF,7015) ITRIAD,IQUAD
 7015   FORMAT('                      : ITRIAD ',I12  ,' IQUAD ',I12)
        IF (ICUR.GT.0) THEN
          WRITE (PRINTF,7115) 'ON'
        ELSE
          WRITE (PRINTF,7115) 'OFF'
        ENDIF
 7115   FORMAT(' Current is ', A3)
        WRITE(PRINTF,7004) DX,DY
 7004   FORMAT(' Spatial step         : DX     ',E12.4,' DY    ',E12.4)
        WRITE(PRINTF,7104) DDIR*180./PI
 7104   FORMAT('                      : DDIR   ',E12.4)
        WRITE(PRINTF,7003) GRAV, PI
 7003   FORMAT(' Physical constants   : GRAV   ',E12.4,' PI    ',E12.4)
        WRITE(PRINTF,7027) U10 , WDIC*180./PI
 7027   FORMAT(' Wind input           : WSPEED ',E12.4,' DIR   ',E12.4)
        WRITE(PRINTF,7123) PWTAIL(1),PWTAIL(2)
 7123   FORMAT(' Tail parameters      : E(f)   ',E12.4,' E(k)  ',E12.4)
        WRITE(PRINTF,7133) PWTAIL(3),PWTAIL(4)
 7133   FORMAT('                      : A(f)   ',E12.4,' A(k)  ',E12.4)
        WRITE(PRINTF,8013) PNUMS(1), PNUMS(2)
 8013   FORMAT(' Accuracy command     : DREL   ',E12.4,' DHABS ',E12.4)
        WRITE(PRINTF,8213) PNUMS(3),PNUMS(4)
 8213   FORMAT('                      : DTABS  ',E12.4,' NPNTS ',E12.4)
        WRITE(PRINTF,3613) PNUMS(20)
 3613   FORMAT('                      : GRWMX  ',E12.4)
        WRITE(PRINTF,8513) PNUMS(6)
 8513   FORMAT(' DIR command          : CDD    ',E12.4)
*
        WRITE(PRINTF,8613) INT(PNUMS(8))
 8613   FORMAT(' Scheme freq. space   : NUMFRE ',I12)
        WRITE(PRINTF,4113) PNUMS(7)
 4113   FORMAT(' 1) Implicit (CGSTAB) : CSS    ',E12.4)
        WRITE(PRINTF,8113) INT(PNUMS(10)), PNUMS(11)
 8113   FORMAT('                      : PREC   ',I12  ,' EPS1  ',E12.4)
        WRITE(PRINTF,2213) PNUMS(12), INT(PNUMS(13))
 2213   FORMAT('                      : EPS2   ',E12.4,' OUTPUT',I12)
        WRITE(PRINTF,8223) INT(PNUMS(14))
 8223   FORMAT('                      : NITER  ',I12)
        WRITE(PRINTF,4213) PNUMS(19)
 4213   FORMAT(' 2) Explicit with CFL : CFL    ',E12.4)
C
        WRITE(PRINTF,8413) IQUAD, PNUMS(20)
 8413   FORMAT(' Quadruplets          : IQUAD  ',I12  ,' GRWMX ',E12.4)
        WRITE(PRINTF,9413) ITRIAD, PTRIAD(1)
 9413   FORMAT(' Triads               : ITRIAD ',I12  ,' PAR   ',E12.4)
        IF (IBOT.EQ.2) THEN
          WRITE(PRINTF,7005) PBOT(2),PBOT(1)
 7005   FORMAT(' Collins (`72)        : CFW    ',E12.4,' CFC   ',E12.4)
        ELSE IF (IBOT.EQ.3) THEN
          WRITE(PRINTF,7335) PBOT(4),PBOT(5)
 7335   FORMAT(' Madsen et al. (`84)  : MF     ',E12.4,' KN    ',E12.4)
        ELSE IF (IBOT.EQ.1) THEN
          WRITE(PRINTF,7325) PBOT(3)
 7325     FORMAT(' JONSWAP (`73)        : GAMMA  ',E12.4)
        ELSE
          WRITE (PRINTF, *) ' Bottom friction is off'
        ENDIF
        IF (IWCAP.EQ.1) THEN
          WRITE(PRINTF,6005) PWCAP(1),PWCAP(2)
 6005     FORMAT(' W-cap Komen (`84)    : EMPCOF ',E12.4,
     &           ' APM   ',E12.4)
        ELSE IF (IWCAP.EQ.2) THEN
          WRITE(PRINTF,6335) PWCAP(3),PWCAP(4)
 6335     FORMAT(' W-cap Janssen (`90)  : CFJANS ',E12.4,
     &           ' DELTA ',E12.4)
        ELSE IF (IWCAP.EQ.3) THEN
          WRITE(PRINTF,6135) PWCAP(5)
 6135     FORMAT(' W-cap Longuet-Higgins: CFLHIG ',E12.4)
        ELSE IF (IWCAP.EQ.4) THEN
          WRITE(PRINTF,6136) PWCAP(6), PWCAP(7)
 6136     FORMAT(' W-cap Battjes/Janssen: BJSTP  ',E12.4,
     &           ' BJALF ',E12.4)
        ELSE IF (IWCAP.EQ.5) THEN
          WRITE(PRINTF,6136) PWCAP(6), PWCAP(7)
          WRITE(PRINTF,6137) PWCAP(8)
 6137     FORMAT('                      : KCONV  ',E12.4)
        ELSE
          WRITE (PRINTF, *) ' Whitecapping is off'
        ENDIF
*
        IF (ISURF.EQ.1) THEN
          WRITE(PRINTF,7012) PSURF(1),PSURF(2)
 7012     FORMAT(' Battjes&Janssen (`78): ALPHA  ',E12.4,
     &           ' GAMMA ',E12.4)
        ELSE IF (ISURF.EQ.2) THEN                                        970219
          WRITE(PRINTF,7212) PSURF(1), PSURF(4), PSURF(5)
 7212     FORMAT(' Nelson (`94): ALPHA  ',E12.4,
     &           ' GAMmin ',E12.4, ' GAMmax ',E12.4)
        ELSE
          WRITE (PRINTF, *) ' Surf breaking is off'
        ENDIF
C
          WRITE(PRINTF,7126) PWIND(14), PWIND(15)
 7126     FORMAT(' Janssen (`89,`90)    : ALPHA  ',E12.4,
     &           ' KAPPA ',E12.4)
          WRITE(PRINTF,7136) PWIND(16), PWIND(17)
 7136     FORMAT(' Janssen (`89,`90)    : RHOA   ',E12.4,
     &           ' RHOW  ',E12.4)
          WRITE(PRINTF,*)
          WRITE(PRINTF,1012) PWIND(1), PWIND(2)
 1012     FORMAT(' 1st and 2nd gen. wind: CF10   ',E12.4,
     &           ' CF20  ',E12.4)
          WRITE(PRINTF,1013) PWIND(3), PWIND(4)
 1013     FORMAT('                      : CF30   ',E12.4,
     &           ' CF40  ',E12.4)
          WRITE(PRINTF,1014) PWIND(5), PWIND(6)
 1014     FORMAT('                      : CF50   ',E12.4,
     &           ' CF60  ',E12.4)
          WRITE(PRINTF,1015) PWIND(7), PWIND(8)
 1015     FORMAT('                      : CF70   ',E12.4,
     &           ' CF80  ',E12.4)
          WRITE(PRINTF,1016) PWIND(9), PWIND(10)
 1016     FORMAT('                      : RHOAW  ',E12.4,
     &           ' EDMLPM',E12.4)
          WRITE(PRINTF,1017) PWIND(11), PWIND(12)
 1017     FORMAT('                      : CDRAG  ',E12.4,
     &           ' UMIN  ',E12.4)
          WRITE(PRINTF,1018) PWIND(13)
 1018     FORMAT('                      : LIM_PM ',E12.4)
C
        IF ( ITEST .GT. 2
     &                   )  THEN
          DO IS = 1, MSC
            WRITE(PRINTF,*)' IS and SPCSIG(IS)    :',IS,SPCSIG(IS)        30.72
          ENDDO
        ENDIF
      END IF
C
C     *** check resonance condition for triads ***
C
      IF ( ITRIAD .GE. 1 .AND. ITEST .GE. 1 ) THEN
        IJ2    = INT (FLOAT(MSC) / 2.)
        IJ1    = IJ2 - 1
        FAC1   = SPCSIG(IJ2) / SPCSIG(IJ1)                                30.72
        IRES   = INT ( LOG10( 2.) / LOG10( FAC1 ) )
        FACRES = 10.**( LOG10(2.) / FLOAT(IRES) )
        SIGLOW   = SPCSIG(MSC) / ( FACRES**(FLOAT(MSC-1) ) )              30.75
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) '-----------------------------------------------
     &-----------------'
        WRITE(PRINTF,*) 'Triad wave-wave interactions are activated: '
        WRITE(PRINTF,*)
        WRITE(PRINTF,51) SPCSIG(MSC-IRES), SPCSIG(MSC)                    30.72
 51     FORMAT(' Higher harmonic of f1= ',F10.4,' Hz is equal f2= ',
     &  F10.4,' Hz')
        WRITE(PRINTF,52) SPCSIG(MSC)/SPCSIG(MSC-IRES), IRES               30.72
 52     FORMAT(' resulting in a f2/f1 of',F10.4,' [resonance condition =
     & ',I2,']')
        WRITE(PRINTF,53) SIGLOW / (2.*PI)                                 30.75
 53     FORMAT(' For good scaling behaviour triads set [FLOW] equal:'     20.77
     & ,F8.2,' s')
        WRITE(PRINTF,*) '-----------------------------------------------
     &-----------------'
        WRITE(PRINTF,*)
      ENDIF
C
C     *** print test points ***
C
      IF (NPTST.GT.0) THEN
        DO 121 II = 1, NPTST
          WRITE(PRINTF,1001) II, XYTST(2*II-1)-1, XYTST(2*II)-1
 1001       FORMAT(' Test points :',3I5)
 121    CONTINUE
      ENDIF
C
C     *** calculate auxiliary variables MSCMAX and MDCMAX   ***
C     *** for the 4-WAVE interactions to allocate required  ***
C     *** memory in the WAREA (The size of the arrays for   ***
C     *** the quadrupltes are on the forehand not known     ***
C
      IF ( IQUAD .GE. 1 )
     &   CALL BND4WW (MSCMAX,MDCMAX,SPCSIG                      )         34.00
!
!     Delete code operating on dynamic data pool                          40.22
!                                                                         40.22
! *** Indexing and bounds for SWMAT arrays                                40.22
!                                                                         40.22
      JMATD = 1                                                           40.22
      JMATR = 2                                                           40.22
      JMATL = 3                                                           40.22
      JMATU = 4                                                           40.22
      JMAT5 = 5                                                           40.22
      JMAT6 = 6                                                           40.22
      JDIS0 = 7                                                           40.22
      JDIS1 = 8                                                           40.22
      JLEK1 = 9                                                           40.22
      JAOLD = 10                                                          40.22
      MSWMATR = 10                                                        40.22
      JABIN = 1                                                           40.22
      JABLK = 2                                                           40.22
      MLSWMAT = 2                                                         40.22
 
! *** Stencil size                                                        40.22
 
      IF (PROPSC.EQ.3) THEN                                               33.09
        ICMAX  = 10                                                       33.08
      ELSE IF (PROPSC.EQ.2) THEN                                          33.10
        ICMAX  = 5                                                        33.10
      ELSE
        ICMAX  = 3                                                        33.10
      ENDIF                                                               33.08
 
!----------------------------------------------------------------------   40.22
!     Begin allocate shared arrays.                                       40.22
!----------------------------------------------------------------------   40.22
 
C     *** In case of SETUP expand array for setup data ***                32.02
C
C     in case of SETUP expand array for setup data                        31.02
      IF (LSETUP.GT.0) THEN                                               31.04
        MSTPDA = 40                                                       31.04
        ALLOCATE(SETPDA(MXC,MYC,MSTPDA))                                  40.22
      ELSE                                                                40.22
        ALLOCATE(SETPDA(0,0,0))                                           40.22
      ENDIF
C
      ALLOCATE(HSAC1(MCGRD))                                              40.22
      ALLOCATE(HSAC2(MCGRD))                                              40.22
      ALLOCATE(SACC1(MCGRD))                                              40.22
      ALLOCATE(SACC2(MCGRD))                                              40.22
C
      IF ( IQUAD .GE. 1) THEN
C       *** quadruplets ***
        ALLOCATE(AF11(MSC4MI:MSC4MA))                                     40.22
        IF ( IQUAD .GE. 3 ) THEN                                          40.10
C         *** prior to every iteration full directional domain ***
          ALLOCATE(MEMNL4(MDC,MSC,MCGRD))                                 40.22
        ELSE                                                              40.22
C       *** iquad < 3 ***                                                 40.22
          ALLOCATE(MEMNL4(0,0,0))                                         40.22
        END IF
      ELSE
C       *** no quadruplets ***
        ALLOCATE(AF11(0))                                                 40.22
        ALLOCATE(MEMNL4(0,0,0))                                           40.22
      ENDIF
C
C     *** Lock array for thread management                                40.22
      ALLOCATE(LLOCK(MXC,MYC))                                            40.22
 
!----------------------------------------------------------------------   40.22
!     End allocate shared arrays.                                         40.22
!----------------------------------------------------------------------   40.22
 
!----------------------------------------------------------------------   NRL
!     Begin initialization of private real arrays.                        NRL
!----------------------------------------------------------------------   NRL

      IF (LSETUP.GT.0) SETPDA=0.                                          NRL
      HSAC1=0.                                                            NRL
      HSAC2=0.                                                            NRL
      SACC1=0.                                                            NRL
      SACC2=0.                                                            NRL
      IF ( IQUAD .GE. 1) THEN                                             NRL
        AF11=0.                                                           NRL
        IF ( IQUAD .GE. 3 ) THEN                                          NRL
          MEMNL4=0.                                                       NRL
        ENDIF                                                             NRL
      ENDIF                                                               NRL

!----------------------------------------------------------------------   NRL
!     End initialization private real arrays.                             NRL
!----------------------------------------------------------------------   NRL

!----------------------------------------------------------------------   40.22
!     Begin parallel region.                                              40.22
!----------------------------------------------------------------------   40.22
 
!$OMP PARALLEL DEFAULT(SHARED)                                            40.22
!$OMP+PRIVATE(ITER, SWPDIR, IX, IY, II, IJ, IK, CG)                       40.22
!$OMP+PRIVATE(CAX, CAY, CAX1, CAY1, CAS, CAD, CGO, KWAVE)                 40.22
!$OMP+PRIVATE(SWMATR, LSWMAT, ALIMW, GROWW, IDCMIN, IDCMAX)               40.22
!$OMP+PRIVATE(SECTOR, ISCMIN, ISCMAX, UE, SA1, SA2, SFNL)                 40.22
!$OMP+PRIVATE(DA1C, DA1P, DA1M, DA2C, DA2P, DA2M, DSNL)                   40.22
!$OMP+PRIVATE(COLU2, DIFLOW, DIFDIG, DIFUPP, DIFRHV)                      40.22
!$OMP+PRIVATE(BAND, EXACT, RHV, SOLUT, WORK, PRECON, ANYWND, OBREDF)      40.22
!$OMP+PRIVATE(UPPERI, LOPERI, INOCNT)                                     NRL
!$OMP+PRIVATE(RINSOL, INFMAT, IINSOL)                                     NRL
!$OMP+PRIVATE(IP,IDC,ISC)                                                 NRL
!$OMP+PRIVATE(I1GRD,I2GRD,I1MYC,I2MYC)                                    NRL
!$OMP+COPYIN(/TP_SWNUMS/,/TP_SWPROP/,/TP_SWTEST/)                         40.22
C
!$OMP MASTER                                                              40.22
!  Print number of threads set by environment                             40.22
!$    WRITE(6,*)"Number of OpenMP threads=",OMP_GET_NUM_THREADS()         NRL
!$OMP END MASTER                                                          40.22
 
!----------------------------------------------------------------------   40.22
!     Begin allocate private arrays.                                      40.22
!----------------------------------------------------------------------   40.22
 
!     Use MICMAX instead of ICMAX to avoid OpenMP error, since ICMAX      40.22
!     is part of a threadprivate common block                             40.22
      ALLOCATE(CG(MDC,MSC,MICMAX))                                        40.22
      ALLOCATE(CAX(MDC,MSC,MICMAX))                                       40.22
      ALLOCATE(CAY(MDC,MSC,MICMAX))                                       40.22
      ALLOCATE(CAX1(MDC,MSC,MICMAX))                                      40.22
      ALLOCATE(CAY1(MDC,MSC,MICMAX))                                      40.22
      ALLOCATE(CAS(MDC,MSC,MICMAX))                                       40.22
      ALLOCATE(CAD(MDC,MSC,MICMAX))                                       40.22
      ALLOCATE(CGO(MSC,MICMAX))                                           40.22
      ALLOCATE(KWAVE(MSC,MICMAX))                                         40.22
!     Since swmatr has been broken up into a real array(SWMATR) and a     40.22
!     logical array(LSWMAT), the size of each array has been adjusted     40.22
!     to MSWMATR(10) and MLSWMAT(2) instead of the original equivalenced  40.22
!     array with a size of MSWMAT(12).                                    40.22
      ALLOCATE(SWMATR(MDC,MSC,MSWMATR))                                   40.22
      ALLOCATE(LSWMAT(MDC,MSC,MLSWMAT))                                   40.22
      ALLOCATE(ALIMW(MDC,MSC))                                            40.22
      ALLOCATE(GROWW(MDC*MSC))                                            40.22
      ALLOCATE(IDCMIN(MSC))                                               40.22
      ALLOCATE(IDCMAX(MSC))                                               40.22
      ALLOCATE(SECTOR(MSC))                                               40.22
      ALLOCATE(ISCMIN(MDC))                                               40.22
      ALLOCATE(ISCMAX(MDC))                                               40.22
C     *** quadruplets ***
      IF ( IQUAD .GE. 1) THEN
        ALLOCATE(UE(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                         40.22
        ALLOCATE(SA1(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                        40.22
        ALLOCATE(SA2(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                        40.22
        ALLOCATE(SFNL(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                       40.22
        IF ( IQUAD .EQ. 1 ) THEN
C         *** semi-implicit calculation ***
          ALLOCATE(DA1C(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DA1P(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DA1M(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DA2C(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DA2P(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DA2M(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
          ALLOCATE(DSNL(MSC4MI:MSC4MA,MDC4MI:MDC4MA))                     40.22
        ELSE                                                              40.22
C       *** iquad > 1 ***                                                 40.22
          ALLOCATE(DA1C(0,0))                                             40.22
          ALLOCATE(DA1P(0,0))                                             40.22
          ALLOCATE(DA1M(0,0))                                             40.22
          ALLOCATE(DA2C(0,0))                                             40.22
          ALLOCATE(DA2P(0,0))                                             40.22
          ALLOCATE(DA2M(0,0))                                             40.22
          ALLOCATE(DSNL(0,0))                                             40.22
        END IF                                                            40.22
      ELSE
C       *** no quadruplets ***
        ALLOCATE(UE(0,0))                                                 40.22
        ALLOCATE(SA1(0,0))                                                40.22
        ALLOCATE(SA2(0,0))                                                40.22
        ALLOCATE(SFNL(0,0))                                               40.22
        ALLOCATE(DA1C(0,0))                                               40.22
        ALLOCATE(DA1P(0,0))                                               40.22
        ALLOCATE(DA1M(0,0))                                               40.22
        ALLOCATE(DA2C(0,0))                                               40.22
        ALLOCATE(DA2P(0,0))                                               40.22
        ALLOCATE(DA2M(0,0))                                               40.22
        ALLOCATE(DSNL(0,0))                                               40.22
      END IF
C     *** explicit scheme in frequency space and diffusion model ***
      ALLOCATE(COLU2(MDC))                                                40.22
      ALLOCATE(DIFLOW(MDC,MSC))                                           40.22
      ALLOCATE(DIFDIG(MDC,MSC))                                           40.22
      ALLOCATE(DIFUPP(MDC,MSC))                                           40.22
      ALLOCATE(DIFRHV(MDC,MSC))                                           40.22
C
      IF ( DYNDEP .OR. ICUR .EQ. 1 ) THEN                                 40.00
C       *** ILU-CGSTAB solver ***
        ALLOCATE(BAND(MDC*MSC,9))                                         40.22
        ALLOCATE(EXACT(MDC*MSC))                                          40.22
        ALLOCATE(RHV(MDC*MSC))                                            40.22
        ALLOCATE(SOLUT(MDC*MSC))                                          40.22
        ALLOCATE(WORK(MDC*MSC,10))                                        40.22
        ALLOCATE(PRECON(MDC*MSC,9))                                       40.22
      ELSE
        ALLOCATE(BAND(0,0))                                               40.22
        ALLOCATE(EXACT(0))                                                40.22
        ALLOCATE(RHV(0))                                                  40.22
        ALLOCATE(SOLUT(0))                                                40.22
        ALLOCATE(WORK(0,0))                                               40.22
        ALLOCATE(PRECON(0,0))                                             40.22
      END IF
C
C     *** wind input term Janssen (1989, 1990) ***
C
      ALLOCATE(ANYWND(MDC))                                               40.22
C
C     *** For obstacles                                   ***
*     *** The new array have dimensions (MDC,MSC,ICMAX-1) ***
!     Use MICMAX instead of ICMAX to avoid OpenMP error, since ICMAX      40.22
!     is part of a threadprivate common block                             40.22
      ALLOCATE(OBREDF(MDC,MSC,(MICMAX-1)))                                40.22
 
!----------------------------------------------------------------------   40.22
!     End allocate private arrays.                                        40.22
!----------------------------------------------------------------------   40.22

!----------------------------------------------------------------------   NRL
!     Begin initialization of private real arrays.                        NRL
!----------------------------------------------------------------------   NRL

      CG=0.                                                               NRL
      CAX=0.                                                              NRL
      CAY=0.                                                              NRL
      CAX1=0.                                                             NRL
      CAY1=0.                                                             NRL
      CAS=0.                                                              NRL
      CAD=0.                                                              NRL
      CGO=0.                                                              NRL
      KWAVE=0.                                                            NRL
      SWMATR=0.                                                           NRL
      ALIMW=0.                                                            NRL
      IF ( IQUAD .GE. 1) THEN                                             NRL
        UE=0.                                                             NRL
        SA1=0.                                                            NRL
        SA2=0.                                                            NRL
        SFNL=0.                                                           NRL
        IF ( IQUAD .EQ. 1 ) THEN                                          NRL
          DA1C=0.                                                         NRL
          DA1P=0.                                                         NRL
          DA1M=0.                                                         NRL
          DA2C=0.                                                         NRL
          DA2P=0.                                                         NRL
          DA2M=0.                                                         NRL
          DSNL=0.                                                         NRL
        END IF                                                            NRL
      END IF                                                              NRL
      COLU2=0.                                                            NRL
      DIFLOW=0.                                                           NRL
      DIFDIG=0.                                                           NRL
      DIFUPP=0.                                                           NRL
      DIFRHV=0.                                                           NRL
      IF ( DYNDEP .OR. ICUR .EQ. 1 ) THEN                                 NRL
        BAND=0.                                                           NRL
        EXACT=0.                                                          NRL
        RHV=0.                                                            NRL
        SOLUT=0.                                                          NRL
        WORK=0.                                                           NRL
        PRECON=0.                                                         NRL
      END IF                                                              NRL

!----------------------------------------------------------------------   NRL
!     End initialization private real arrays.                             NRL
!----------------------------------------------------------------------   NRL
!$OMP BARRIER                                                             NRL

! Each thread compute its own spatial grid loop bounds for MCGRD          NRL
      CALL GET_MT_LOOP_BOUNDS(1,MCGRD,I1GRD,I2GRD)                        NRL
! Each thread compute its own spatial grid loop bounds for MYC            NRL
      CALL GET_MT_LOOP_BOUNDS(1,MYC,I1MYC,I2MYC)                          NRL
 
 
 
!          INSAC must be called with every call to swcomp since the       40.22
!          HSAC2 and SACC2 arrays are no longer retained between calls.   40.22
!          The WAREA constructs acted as common blocks.  If needed,       40.22
!          this can be changed by putting HSAC2 and SACC2 in a common     40.22
!          block.
!
C
C     *** initialise values for determining the accuracy that ***
C     *** has been reached                                    ***
C           *** This is now done in parallel ***                          NRL
C
      CALL INSAC (AC2               ,SPCSIG          ,COMPDA(1,JDP2)  ,   40.22
     &            HSAC2             ,SACC2           ,                    NRL
     &            I1GRD             ,I2GRD   )                            NRL
C
C
C     *** store original wind model counter (IWIND) in auxiliary ***
C     *** variable IWORG (required for first guess)              ***
C
!$OMP MASTER                                                              NRL
      IWORG = IWIND
!$OMP END MASTER                                                          NRL
C
      DO 450 ITER = 1, ITERMX                                             30.00
 
C       initialise local (thread private) counter for ILU-CGSTAB solver   NRL
        INOCNT = 0                                                        NRL
C
C       initialise Dissipation and Leak at 0 at begin of iteration
C       *** this is now done in parallel ***                              NRL
C
        DO IP = I1GRD,I2GRD                                               NRL
          COMPDA(IP,JDISS) = 0.
          COMPDA(IP,JLEAK) = 0.
        ENDDO
C
C       initialise Ursell number as -1 (indicating that it has no value)  40.03
C       *** this is now done in parallel ***                              NRL
C
        IF (ITRIAD.GT.0) THEN
          DO IP = I1GRD,I2GRD                                             NRL
            COMPDA(IP,JURSEL) = 0.
          ENDDO
        ENDIF
C                                                                         NRL
C           *** IQUAD = 3: the nonlinear wave interactions are ***        NRL
C           *** calculated just once for an iteration. First,  ***        NRL
C           *** set the auxiliary array equal zero before a    ***        NRL
C           *** new iteration                                  ***        NRL
C       *** This is now done in parallel ***                              NRL
C                                                                         NRL
        IF ( IQUAD .GE. 3 ) THEN                                          NRL
          DO IP = I1GRD,I2GRD                                             NRL
            DO ISC = 1,MSC                                                NRL
              DO IDC = 1,MDC                                              NRL
                MEMNL4(IDC,ISC,IP)=0.                                     NRL
              END DO                                                      NRL
            END DO                                                        NRL
          END DO                                                          NRL
        END IF                                                            NRL
C                                                                         NRL
!----------------------------------------------------------------------   NRL
!     Begin master thread region.                                         NRL
!----------------------------------------------------------------------   NRL
!$OMP MASTER                                                              NRL
C                                                                         NRL
C       *** When a current is present and the ILU-CGSTAB solver ***       NRL
C       *** is used it can be that the solver does not converge ***       NRL
C       *** the counter INOCNV contains the number of geograp.  ***       NRL
C       *** gridpoints in which the solver did not converge     ***       NRL
C                                                                         NRL
        INOCNV = 0                                                        NRL
C
C       *** prepare constants and weight factors for nonlinear   ***
C       *** 4 wave interactions and initialize array MEMNL4 = 0. ***
C       *** and set the array for the frequencies > SPCSIG(msc)  ***      30.72
C
        IF ( IQUAD .GE. 1 ) THEN
C
C       *** For the first iteration compute range for spectral     ***
C       *** space and some other variables for 4 wave interactions ***
C
          IF ( ITER .EQ. 1 ) THEN
              CALL FAC4WW (ITER  ,XIS   ,SNLC1 ,                          34.00
     &                    DAL1  ,DAL2  ,DAL3                ,SPCSIG,      34.00
     &                    AF11                , WWINT              ,      40.02 40.22
     &                    WWAWG               ,WWSWG                )     40.02 40.22
          END IF
        END IF
C
C         *** to obtain a first estimate of energy density in a    ***
C         *** gridpoint considered we run the SWAN model (in case  ***
C         *** of active wind ) in a second generation mode first.  ***    40.00
C         *** After 1 iteration, the options as defined by the     ***
C         *** user are activated.                                  ***
C         *** This first guess is not used in nonstationary        ***    40.00
C         *** computations (NSTATC>0), or if a restart file was    ***
C         *** used (ICOND=4)                                       ***
C
          IF (NSTATC.GT.0 .OR. ICOND.EQ.4) THEN                           40.00
!           NSTATC > 0 : nonstationary computation                        40.13
!           ICOND = 4  : first guess is read from hotfile                 40.13
            PRECOR = .FALSE.
          ELSE
!           first guess will be used                                      40.13
            PRECOR = .TRUE.
          ENDIF
C
          IF ( PRECOR .AND. IWORG .GE. 3 ) THEN
C           *** third generation wave input ***
            IF ( ITER .EQ. 1 )THEN
C             *** save settings of 3d generation model              ***   40.13
C             *** bottom friction and surf breaking are not changed ***
              KSTATC = NSTATC
              KCUR   = ICUR
C             *** deep water model ***
              KWIND  = IWIND
              KWCAP  = IWCAP
              KQUAD  = IQUAD
C             *** shallow water model ***
              KTRIAD = ITRIAD
C             ***  maximum change per bin is PNUMS(20)  ***               40.13
              GRWOLD = PNUMS(20)
 
!             first guess settings                                        40.13
 
 
!             if 1st generation is to be used as first guess, replace     40.13
!             the next statement by IWIND = 1                             40.13
              IWIND  = 2
              IWCAP  = 0
              IQUAD  = 0
C              ITRIAD = 0
              PNUMS(20) = 1.E22
            ELSE IF ( ITER .EQ. 2 ) THEN
              NSTATC = KSTATC
              ICUR   = KCUR
              IWIND  = KWIND
              IWCAP  = KWCAP
              IQUAD  = KQUAD
              ITRIAD = KTRIAD
              PNUMS(20) = GRWOLD
            ENDIF
C
          ENDIF
C         *** test output ***
          IF (NSTATC.EQ.0 .AND. ITER .LE. 2 .AND. IWORG .GE. 3) THEN     24/MAR
            WRITE(PRINTF,*)' -----------------------------------------',
     &                     '----------------------'
            IF ( ITER .EQ. 1 .AND. ITEST .GE. 10) THEN
              WRITE(PRINTF,*) ' First guess by second generation model',
     &                        ' flags for first iteration:'
            ELSE IF ( ITER .EQ. 2 .AND. ITEST .GE. 10) THEN
              WRITE(PRINTF,*) ' Options given by user are activated',
     &                        ' for proceeding calculation:'
            ENDIF
            WRITE(PRINTF,2001) ITER, PNUMS(20)
 2001       FORMAT(' ITER    ',I4,' GRWMX    ',E12.4)
            WRITE(PRINTF,2002) NSTATC, ICUR ,IWIND, IWCAP
 2002       FORMAT(' NSTATC  ',I4,' ICUR    ',I4,' IWIND   ',I4,
     &             ' IWCAP   ',I4)
            WRITE(PRINTF,2003) IQUAD, ITRIAD, IBOT , ISURF
 2003       FORMAT(' IQUAD   ',I4,' ITRIAD  ',I4,' IBOT    ',I4,
     &             ' ISURF   ',I4)
            WRITE(PRINTF,*)' -----------------------------------------',
     &                     '----------------------'
          ENDIF
 
 
!----------------------------------------------------------------------   40.22
!     End master thread region.                                           40.22
!----------------------------------------------------------------------   40.22
!$OMP END MASTER                                                          40.22
 
!----------------------------------------------------------------------   40.22
!     Synchronize threads before loop over sweep directions.              40.22
!----------------------------------------------------------------------   40.22
!$OMP BARRIER                                                             40.22
C
C         *** START ITERATION PROCESS WITH 4 SWEEPS ***
C
C         *** loop over sweep directions ***
C
          DO 410 SWPDIR = 1, 4
 
 

!           Initialize LLOCK in parallel                                  NRL
!           Make .FALSE. at grid points where depth is negative           NRL
            DO IY = I1MYC,I2MYC                                           NRL
              DO IX = 1, MXC                                              NRL
                IF (COMPDA(KGRPNT(IX,IY),JDP2).GE.DEPMIN) THEN            NRL
                   LLOCK(IX,IY) = .TRUE.                                  NRL
                ELSE                                                      NRL
                   LLOCK(IX,IY) = .FALSE.                                 NRL
                ENDIF                                                     NRL
              ENDDO                                                       NRL
            ENDDO                                                         NRL

!----------------------------------------------------------------------   NRL
!     Synchronize threads before setting LLOCK for boundary.              NRL
!----------------------------------------------------------------------   NRL
!$OMP BARRIER                                                             NRL
 
!----------------------------------------------------------------------   NRL
!     Begin master thread region.                                         NRL
!----------------------------------------------------------------------   NRL
!$OMP MASTER                                                              NRL
 
!           make LLOCK False for points on boundary                       40.22
            IF (SWPDIR.EQ.1) THEN
              KSX = -1
              KSY = -1
              DDX = +DX
              DDY = +DY
              IF (KREPTX.EQ.0) THEN
                IX1 = 2
                LLOCK(1,:) = .FALSE.                                      40.22
              ELSE
                IX1 = 1
              ENDIF
              IX2 = MXC
              IY1 = 2
              IY2 = MYC
              LLOCK(:,1) = .FALSE.                                        40.22
            ELSE IF (SWPDIR.EQ.2) THEN
              KSX = +1
              KSY = -1
              DDX = -DX
              DDY = +DY
              IF (KREPTX.EQ.0) THEN
                IX1 = MXC-1
                LLOCK(MXC,:) = .FALSE.                                    40.22
              ELSE
                IX1 = MXC
              ENDIF
              IX2 = 1
              IY1 = 2
              IY2 = MYC
              LLOCK(:,1) = .FALSE.                                        40.22
            ELSE IF (SWPDIR.EQ.3) THEN
              KSX = +1
              KSY = +1
              DDX = -DX
              DDY = -DY
              IF (KREPTX.EQ.0) THEN
                IX1 = MXC-1
                LLOCK(MXC,:) = .FALSE.                                    40.22
              ELSE
                IX1 = MXC
              ENDIF
              IX2 = 1
              IY1 = MYC-1
              IY2 = 1
              LLOCK(:,MYC) = .FALSE.                                      40.22
            ELSE IF (SWPDIR.EQ.4) THEN
              KSX = -1
              KSY = +1
              DDX = +DX
              DDY = -DY
              IF (KREPTX.EQ.0) THEN
                IX1 = 2
                LLOCK(1,:) = .FALSE.                                      40.22
              ELSE
                IX1 = 1
              ENDIF
              IX2 = MXC
              IY1 = MYC-1
              IY2 = 1
              LLOCK(:,MYC) = .FALSE.                                      40.22
            ENDIF
C
C           *** change values of variables for one-dimensional run ***    32.02
C
            IF ( ONED ) THEN                                              32.02
              IY1 = 1                                                     32.02
              IY2 = 1                                                     32.02
              KSY = 0                                                     32.02
            ENDIF                                                         32.02
C
            IF (SCREEN.NE.PRINTF) THEN
              IF (NSTATC.EQ.1) THEN                                       40.00
                WRITE(SCREEN,313) CHTIME, IT, ITER, SWPDIR
 313            FORMAT ('+time ', A18, ', step ',I4, '; iteration '
     &                  ,I2, '; sweep ',I1)                               40.00
              ELSE
                WRITE(PRINTF,314) ITER, SWPDIR
                IF (SWPDIR .EQ. 1) WRITE(SCREEN,314) ITER, SWPDIR
                IF (SWPDIR .NE. 1) WRITE(SCREEN,315) ITER, SWPDIR
 314            FORMAT (' iteration ', I2, '; sweep ', I1)                30.50
 315            FORMAT ('+iteration ', I2, '; sweep ', I1)                30.50
              ENDIF
            ENDIF
C
            IF ( ONED ) THEN                                              32.02
              IYSTEP = 1                                                  32.02
            ELSE                                                          32.02
              IYSTEP = KSY                                                32.02
            ENDIF                                                         32.02
C
C           FLUSH THE MEMORY SO THAT THE PRINT FILE IS UP TO DATE         33.08
C           this doesn't work with f90, so it should not be included in   33.08
C                the ftp version of the code.                             33.08
C           IFL=FLUSH(PRINTF)   !warning! this causes a FPE in f90!       33.08
C           with Lahey this should be Call Flush(..)                      33.09
C
 
!----------------------------------------------------------------------   40.22
!     End master thread region.                                           40.22
!----------------------------------------------------------------------   40.22
!$OMP END MASTER                                                          40.22
 
!----------------------------------------------------------------------   40.22
!     Synchronize threads before loop over spatial grid.                  40.22
!----------------------------------------------------------------------   40.22
!$OMP BARRIER                                                             40.22
 
!----------------------------------------------------------------------   40.22
!     Execute loop over rows of spatial grid in a                         40.22
!     pipelined parallel manner.                                          40.22
!----------------------------------------------------------------------   40.22
!$OMP DO SCHEDULE(STATIC,1)                                               40.22
!$OMP+FIRSTPRIVATE(WWINT)                                                 NRL
!$OMP+LASTPRIVATE(WWINT)                                                  NRL
 
            DO 400 IY = IY1, IY2, -IYSTEP                                 32.02
              DO 390 IX = IX1, IX2, -KSX
 
!----------------------------------------------------------------------   40.22
!               This while loop will guarantee execution will not         40.22
!               proceed until the data dependencies for grid point        40.22
!               (IX,IY) are satisfied.                                    40.22
!               Since we parallelize only in the y-direction, we only     NRL
!               need to check data dependencies in the y-direction.       NRL
!               The flush is required to ensure each thread has a         40.22
!               consistent view of LLOCK.                                 40.22
!----------------------------------------------------------------------   40.22
                IF (.NOT. ONED) THEN                                      NRL
                    DO WHILE(LLOCK(IX,IY+IYSTEP))                         NRL
!$OMP FLUSH                                                               NRL
                    END DO                                                NRL
                ENDIF                                                     NRL
 
!               The original call to SWOMPU was replaced with the         40.22
!               allocated arrays instead of the WAREA constructs.         40.22
 
                CALL SWOMPU (SWPDIR,KSX              ,KSY              ,
     &            IX               ,IY               ,DDX              ,
     &            DDY              ,DT               ,SNLC1            ,
     &            DAL1             ,DAL2             ,DAL3             ,
     &            XIS              ,SWTSDA           ,INOCNT           ,  NRL
     &            AC2              ,COMPDA           ,SPCDIR           ,
     &            SPCSIG           ,XYTST            ,ITER             ,  30.72
     &                              CGO              ,CG               ,  40.22
     &            CAX              ,CAY              ,CAS              ,  40.22
     &            CAD              ,SWMATR           ,LSWMAT           ,  40.22
     &            KWAVE            ,                                      40.22
     &            ALIMW            ,GROWW            ,AF11             ,  40.22
     &            UE               ,SA1              ,SA2              ,  40.22
     &            DA1C             ,DA1P             ,DA1M             ,  40.22
     &            DA2C             ,DA2P             ,DA2M             ,  40.22
     &            SFNL             ,DSNL             ,MEMNL4           ,  40.22
     &            IDCMIN           ,IDCMAX           ,SECTOR           ,  40.22
     &            WWINT            ,WWAWG            ,WWSWG            ,  40.22
     &            COLU2            ,DIFLOW           ,                    40.22
     &            DIFDIG           ,DIFUPP           ,DIFRHV           ,  40.22
     &            BAND             ,EXACT            ,RHV              ,  40.22
     &            RINSOL           ,SOLUT            ,WORK             ,  40.22
     &            PRECON           ,UPPERI           ,LOPERI           ,  40.22
     &            INFMAT           ,IINSOL           ,ISCMIN           ,  40.22
     &            ISCMAX           ,                                      40.22
     &            ANYWND           ,AC1              ,IT               ,  40.22
     &            PRECOR           ,XCGRID           ,YCGRID           ,  30.72
     &            KGRPNT           ,CROSS            ,OBSTA            ,  300597
     &            OBREDF                                               ,  40.22
     &            CAX1             ,CAY1                                  40.22
     &                                                                 )
 
!               This step is disallowed within a parallel region in       40.22
!               OpenMP.                                                   40.22
#ifndef _OPENMP                                                         /*NRL*/
                IF (STPNOW()) RETURN                                      NRL
#endif                                                                  /*NRL*/
 
!----------------------------------------------------------------------   40.22
!               Once the computation is done for grid point (IX,IY) the   40.22
!               thread signals that the data is available by changing     40.22
!               LLOCK(IX,IY).                                             40.22
!----------------------------------------------------------------------   40.22
                LLOCK(IX,IY) = .FALSE.                                    40.22
 
 390          CONTINUE
 
 400        CONTINUE
!$OMP ENDDO NOWAIT                                                        40.22
 
!----------------------------------------------------------------------   40.22
!     Synchronize threads before checking stop condition and              40.22
!     before starting next sweep direction.                               40.22
!----------------------------------------------------------------------   40.22
!$OMP BARRIER                                                             40.22
 410      CONTINUE

!----------------------------------------------------------------------   NRL
!     Each thread sum contributions to the global INOCNV counter          NRL
!     which counts the number of grid points over the four sweeps         NRL
!     in which the ILU-CGSTAB solver did not converge.                    NRL
!----------------------------------------------------------------------   NRL
!$OMP ATOMIC                                                              NRL
      INOCNV = INOCNV + INOCNT                                            NRL
 
!----------------------------------------------------------------------   NRL
!     Synchronize threads before master thread stores source terms        NRL
!     and computes wave induced setup.                                    NRL
!----------------------------------------------------------------------   NRL
!$OMP BARRIER                                                             NRL

!----------------------------------------------------------------------   40.22
!     Begin master thread region.                                         40.22
!----------------------------------------------------------------------   40.22
!$OMP MASTER                                                              40.22
C
C         *** store the source terms for test gridpoints  ***
C         *** in the file SOURCE                          ***
C
          IF (NPTST.GT.0 .AND. NSTATM.EQ.0                                40.00
     &                    ) THEN
            IF (IFPAR.GT.0) WRITE (IFPAR, 12) ITER                        40.00
            IF (IFS1D.GT.0) WRITE (IFS1D, 12) ITER                        40.00
            IF (IFS2D.GT.0) WRITE (IFS2D, 12) ITER                        40.00
  12        FORMAT (I4, T41, 'iteration')
            CALL PLTSRC (SWTSDA(1,1,1,JPWNDA)  ,SWTSDA(1,1,1,JPWNDB)  ,
     &                   SWTSDA(1,1,1,JPWCAP)  ,SWTSDA(1,1,1,JPBTFR)  ,
     &                   SWTSDA(1,1,1,JPWBRK)  ,SWTSDA(1,1,1,JP4S)    ,
     &                   SWTSDA(1,1,1,JP4D)    ,SWTSDA(1,1,1,JPTRI)   ,
     &                   AC2                   ,SPCSIG                ,   40.00
     &                   COMPDA(1,JDP2)        ,XYTST                 ,
     &                                          KGRPNT                )   40.00
          END IF
C
C         *** compute wave-induced setup ***                              32.02
C
          IF (LSETUP.GT.0) THEN                                           31.03
!NRL+  J Dykes 1 July 2003 SWCOMP: last chance to check spherical coords
            if (KSPHER > 0) then
              call MSGERR (4,
     &          'calculating setup in spherical coords. not allowed')
            end if
!NRL-
!         Replace orignal call to SETUPP with call using allocated        40.22
!         arrays.                                                         40.22
            CALL SETUPP (KGRPNT, MSTPDA, SETPDA                     ,     40.22
     &                   AC2, COMPDA(1,JDP2), COMPDA(1,JDPSAV),           31.03
     &                   COMPDA(1,JSETUP), COMPDA(1,JWFRCX),              31.03
     &                   COMPDA(1,JWFRCY), XCGRID, YCGRID, SPCSIG,        31.04
     &                   SPCDIR, IT, ITER,                                31.04
     &                   UPPERI           , LOPERI           )            40.22
 
!           This step is disallowed within a parallel region in OpenMP.   40.22
#ifndef _OPENMP                                                         /*NRL*/
            IF (STPNOW()) RETURN                                          NRL
#endif                                                                  /*NRL*/
          ENDIF                                                           31.03
C
!----------------------------------------------------------------------   NRL
!     End master thread region.                                           NRL
!----------------------------------------------------------------------   NRL
!$OMP END MASTER                                                          NRL
C
C
C         *** check if numerical accuracy has been reached ***
C
!         Replace orignal call to SACCUR with call using allocated        40.22
!         arrays and no longer using WAREA.                               40.22
!         *** this is now done in parallel ***                            NRL
          CALL SACCUR (COMPDA(1,JDP2)  ,
     &               AC2             ,SPCSIG          ,ACCUR           ,  30.72
     &               HSAC1           ,HSAC2           ,SACC1           ,  30.90 40.22
     &               SACC2           ,COMPDA(1,JDHS)  ,COMPDA(1,JDTM)  ,  NRL
     &               I1GRD           ,I2GRD                            )  NRL
C
!----------------------------------------------------------------------   NRL
!     Begin master thread region.                                         NRL
!----------------------------------------------------------------------   NRL
!$OMP MASTER                                                              NRL
C
C         *** info regarding the iteration proces and the accuracy ***
C
          WRITE(PRINTF,112) ACCUR,PNUMS(4)                                30.72
          IF (NSTATC.EQ.0) WRITE(SCREEN,112) ACCUR,PNUMS(4)               40.00
 112      FORMAT(' accuracy OK in ',F6.2,
     &           ' % of wet grid points (',F6.2,' % required)',/ )
C
C         *** number of points for which the ILU solver did ***
C         *** not converge                                  ***
C
          IF (ITEST.GT.30) THEN
            IF ((DYNDEP .OR. ICUR.EQ.1) .AND. INOCNV .NE. 0) THEN         NRL
              WRITE(PRINTF,122) INOCNV                                    NRL
            ENDIF
          END IF
C
!----------------------------------------------------------------------   40.22
!     End master thread region.                                           40.22
!----------------------------------------------------------------------   40.22
!$OMP END MASTER                                                          40.22
C
 
!----------------------------------------------------------------------   40.22
!     Synchronize threads before checking accuracy and before             40.22
!     starting next iteration.                                            40.22
!----------------------------------------------------------------------   40.22
!$OMP BARRIER                                                             40.22
C
C         *** if accuracy has been reached then the iteration ***
C         *** can be termibated ---> goto 470                 ***
C
          IF ( ACCUR.GE.PNUMS(4) ) GOTO 470
C
C         *** write value 1 to array with source term ***
C         *** (another iteration)                     ***
C
 450    CONTINUE                                                          30.00
 470    CONTINUE
 
!----------------------------------------------------------------------   40.22
!     Begin deallocate private arrays.                                    40.22
!----------------------------------------------------------------------   40.22
      DEALLOCATE(IDCMIN)                                                  40.22
      DEALLOCATE(IDCMAX)                                                  40.22
      DEALLOCATE(SECTOR)                                                  40.22
      DEALLOCATE(ISCMIN)                                                  40.22
      DEALLOCATE(ISCMAX)                                                  40.22
      DEALLOCATE(CG)                                                      40.22
      DEALLOCATE(CGO)                                                     40.22
      DEALLOCATE(KWAVE)                                                   40.22
      DEALLOCATE(CAX)                                                     40.22
      DEALLOCATE(CAY)                                                     40.22
      DEALLOCATE(CAS)                                                     40.22
      DEALLOCATE(CAD)                                                     40.22
      DEALLOCATE(CAX1)                                                    40.22
      DEALLOCATE(CAY1)                                                    40.22
      DEALLOCATE(ALIMW)                                                   40.22
      DEALLOCATE(COLU2)                                                   40.22
      DEALLOCATE(DIFLOW)                                                  40.22
      DEALLOCATE(DIFDIG)                                                  40.22
      DEALLOCATE(DIFUPP)                                                  40.22
      DEALLOCATE(DIFRHV)                                                  40.22
      DEALLOCATE(BAND)                                                    40.22
      DEALLOCATE(WORK)                                                    40.22
      DEALLOCATE(PRECON)                                                  40.22
      DEALLOCATE(EXACT)                                                   40.22
      DEALLOCATE(RHV)                                                     40.22
      DEALLOCATE(SOLUT)                                                   40.22
      DEALLOCATE(UE)                                                      40.22
      DEALLOCATE(SA1)                                                     40.22
      DEALLOCATE(SA2)                                                     40.22
      DEALLOCATE(SFNL)                                                    40.22
      DEALLOCATE(DA1C)                                                    40.22
      DEALLOCATE(DA1P)                                                    40.22
      DEALLOCATE(DA1M)                                                    40.22
      DEALLOCATE(DA2C)                                                    40.22
      DEALLOCATE(DA2P)                                                    40.22
      DEALLOCATE(DA2M)                                                    40.22
      DEALLOCATE(DSNL)                                                    40.22
      DEALLOCATE(OBREDF)                                                  40.22
      DEALLOCATE(GROWW)                                                   40.22
      DEALLOCATE(ANYWND)                                                  40.22
      DEALLOCATE(SWMATR)                                                  40.22
      DEALLOCATE(LSWMAT)                                                  40.22
!----------------------------------------------------------------------   40.22
!     End deallocate private arrays.                                      40.22
!----------------------------------------------------------------------   40.22
 
!----------------------------------------------------------------------   40.22
!     End parallel region.                                                40.22
!----------------------------------------------------------------------   40.22
!$OMP END PARALLEL                                                        40.22
C
C       Generate message when ILU-CGSTAB solver did not converge          30.82
C       at last iteration                                                 30.82
C
        IF ((DYNDEP .OR. ICUR.EQ.1) .AND. INOCNV .NE. 0) THEN             NRL
          WRITE(PRINTF,122) INOCNV                                        NRL
          WRITE(SCREEN,122) INOCNV                                        NRL
 122      FORMAT(2X,'ILU-CGSTAB solver: no convergence in ',I4,
     &              ' gridpoints')
        ENDIF
        IF (.NOT.CSETUP) THEN                                             30.82
          WRITE(PRINTF,123)                                               30.82
          IF (SCREEN.NE.PRINTF .AND. NSTATC.EQ.0)                         40.13
     &    WRITE(SCREEN,123)                                               30.82
 123      FORMAT(1X,'ILU-CGSTAB solver: no convergence for setup')        30.82
        ENDIF                                                             30.82
C
          IF (NPTST.GT.0 .AND. NSTATM.EQ.1                                40.00
     &                    ) THEN
            IF (IFPAR.GT.0) WRITE (IFPAR, 11) CHTIME                      40.00
            IF (IFS1D.GT.0) WRITE (IFS1D, 11) CHTIME                      40.00
            IF (IFS2D.GT.0) WRITE (IFS2D, 11) CHTIME                      40.00
  11        FORMAT (A, T41, 'date-time')
 
            CALL PLTSRC (SWTSDA(1,1,1,JPWNDA)  ,SWTSDA(1,1,1,JPWNDB)  ,
     &                   SWTSDA(1,1,1,JPWCAP)  ,SWTSDA(1,1,1,JPBTFR)  ,
     &                   SWTSDA(1,1,1,JPWBRK)  ,SWTSDA(1,1,1,JP4S)    ,
     &                   SWTSDA(1,1,1,JP4D)    ,SWTSDA(1,1,1,JPTRI)   ,
     &                   AC2                   ,SPCSIG                ,   40.00
     &                   COMPDA(1,JDP2)        ,XYTST                 ,
     &                                          KGRPNT                )   40.00
          END IF
C
C       *** if calculation is steady: NSTATC = 0 GOTO 550 ***
C
 500  CONTINUE
C
 550  CONTINUE
 
!----------------------------------------------------------------------   40.22
!     Begin deallocate shared arrays.                                     40.22
!----------------------------------------------------------------------   40.22
      DEALLOCATE(SETPDA)                                                  40.22
      DEALLOCATE(HSAC1)                                                   40.22
      DEALLOCATE(HSAC2)                                                   40.22
      DEALLOCATE(SACC1)                                                   40.22
      DEALLOCATE(SACC2)                                                   40.22
      DEALLOCATE(AF11)                                                    40.22
      DEALLOCATE(MEMNL4)                                                  40.22
      DEALLOCATE(LLOCK)                                                   40.22
!----------------------------------------------------------------------   40.22
!     End deallocate shared arrays.                                       40.22
!----------------------------------------------------------------------   40.22
C
      RETURN
      END subroutine SWCOMP
C
C************************************************************************
C
      SUBROUTINE SWOMPU (SWPDIR   ,KSX      ,KSY      ,
     &                   IX       ,IY       ,DDX      ,
     &                   DDY      ,DT       ,SNLC1    ,
     &                   DAL1     ,DAL2     ,DAL3     ,
     &                   XIS      ,SWTSDA   ,INOCNV   ,
     &                   AC2      ,COMPDA   ,SPCDIR   ,
     &                   SPCSIG   ,XYTST    ,ITER     ,                   30.72
     &                             CGO      ,CG       ,                   40.22
     &                   CAX      ,CAY      ,CAS      ,
     &                   CAD      ,SWMATR   ,LSWMAT   ,                   30.90
     &                   KWAVE    ,
     &                   ALIMW    ,GROWW    ,AF11     ,
     &                   UE       ,SA1      ,SA2      ,
     &                   DA1C     ,DA1P     ,DA1M     ,
     &                   DA2C     ,DA2P     ,DA2M     ,
     &                   SFNL     ,DSNL     ,MEMNL4   ,
     &                   IDCMIN   ,IDCMAX   ,SECTOR   ,
     &                   WWINT    ,WWAWG    ,WWSWG    ,
     &                   ICOLU2   ,DIFLOW   ,
     &                   DIFDIG   ,DIFUPP   ,DIFRHV   ,
     &                   BAND     ,EXACT    ,RHV      ,
     &                   RINSOL   ,SOLUT    ,WORK     ,
     &                   PRECON   ,UPPERI   ,LOPERI   ,
     &                   INFMAT   ,IINSOL   ,ISCMIN   ,
     &                   ISCMAX   ,
     &                   ANYWND   ,AC1      ,IT       ,
     &                   PRECOR   ,XCGRID   ,YCGRID   ,                   30.72
     &                   KGRPNT   ,CROSS    ,OBSTA    ,                   16/MAY
     &                   OBREDF                                           040697
     &                   ,CAX1,CAY1                                       33.08
     &                                                 )
C
C************************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.80: Nico Booij
C     30,81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     33.08: W. Erick Rogers (some S&L scheme-related changes)
C     33.09: Nico Booij (spherical coord.)
C     33.10: Nico Booij and Erick Rogers (2nd order upwind)
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
C     40.09: Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     30.72, Nov. 97: Declaration of ISTAT, ITFRE, DDIR, DX, DY, GRAV,
C                     PI, U10 and WDIC removed because they are
C                     common and already declared in the INCLUDE file
C     32.02, Jan. 98: Introduced 1D-version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.72, Feb. 98: Modified argument list for update CGSTAB solver
C     30.70, Feb. 98: argument list of WINDP1 changed, current vel. added
C     40.00, July 98: KCGRD removed from Call WINDP1
C     40.00, Aug. 98: argument OBREDF added in call SPREDT
C                     subr SWTRCF called to calculate obstacle reduction factors
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.82, Oct. 98: Updated description several variables
C     30.80, Nov. 98: Provision for limitation on Ctheta (refraction)
C     30.81, Jan. 99: Replaced variable STATUS by IERR (because STATUS is a
C                     reserved word)
C     34.01, Feb. 99: Introducing STPNOW
C     33.08  July 98: some S&L scheme-related changes
C     30.80, Aug. 99: Argument list SPROSD modified
C     40.10, Nov. 99: two arguments in call SWTRCF changed;
C                     CHS -> COMPDA(1,JHS) and WLEV2 -> COMPDA(1,JWLV2)
C     33.09, Nov. 99: call DSPHER added (ray curvature due to spherical coord.)
C     33.10, Jan. 00: changes re: the SORDUP scheme
C     40.09, May  00: Argument list SWTRCF modified
C     40.03, Jun. 00: new version of SPROSD has new argument list
C                     Ursell array added to argument list of SDISPA and SOURCE
C                     readability of test output improved
C     40.10, Sep. 00: Replaced SDISPA with SINTGRL
C     40.02, Sep. 00: Replaced SWMATR(1,1,JABIN) with LSWMAT (logical equivalence)
C     40.13, Mar. 01: if point was dry at previous time level, fall back to BSBT scheme
C                     order of calling SWAPAR and SPROXY changed, in order
C                     to get correct values of CGO as input to SPROXY
!     40.22, Sep. 01: Removed WAREA constructs and split SWMATR into      40.22
!                     SWMATR(real) and LSWMAT(logical).                   40.22
!     40.22, Sep. 01: Changed array definitions to use the parameter      40.22
!                     MICMAX instead of ICMAX.                            40.22
!     40.13, Oct. 01: loop over IC moved to subroutines SWAPAR and SPROXY
C
C  2. Purpose
C
C     This subroutine computes the wave spectrum for one sweep
C     direction, and is called four times per iteration.
C
C  3. Method
C
C
C    THIS IS THE STENCIL USED WITH THE S&L SCHEME:                  33.08
C                                                                   33.08
C      IY+1                      o 4                                33.08
C                                |                                  33.08
C                 8    6    2    | 1   5                            33.08
C      IY         O----O----O----*----O                             33.08
C                                |                                  33.08
C                           10   |                                  33.08
C      IY-1                 O----O 3                                33.08
C                                |                                  33.08
C                                |                                  33.08
C      IY-2                      O 7                                33.08
C                                |                                  33.08
C                                |                                  33.08
C      IY-3                      O 9                                33.08
C
C                 ^    ^    ^    ^    ^
C                 |    |    |    |    |                             33.08
C               IX-3 IX-2 IX-1  IX  IX+1
C
C     1: IX  , IY                                                   33.10
C     2: IX-1, IY                                                   33.10
C     3: IX  , IY-1                                                 33.10
C     4: IX  , IY+1                                                 33.10
C     5: IX+1, IY                                                   33.10
C     6: IX-2, IY                                                   33.10
C     7: IX  , IY-2                                                 33.10
C     8: IX-3, IY                                                   33.10
C     9: IX  , IY-3                                                 33.10
C    10: IX-1, IY-1                                                 33.10
C
C    THIS IS THE STENCIL USED WITH THE SORDUP SCHEME:               33.10
C                                                                   33.10
C                      4    2                                       33.10
C      IY              O----O----* 1                                33.10
C                                |                                  33.10
C                                |                                  33.10
C      IY-1                      O 3                                33.10
C                                |                                  33.10
C                                |                                  33.10
C      IY-2                      O 5                                33.10
C                                                                   33.10
C                      ^    ^    ^                                  33.10
C                      |    |    |                                  33.10
C                    IX-2 IX-1  IX                                  33.10
C     1: IX  , IY                                                   33.10
C     2: IX-1, IY                                                   33.10
C     3: IX  , IY-1                                                 33.10
C     4: IX-2, IY                                                   33.10
C     5: IX  , IY-2                                                 33.10
C
C  4. Argument variables
C
C     ITER  : input Iteration counter for SWAN
C     IT    : input Time step counter for SWAN
C
      INTEGER ITER,   IT
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL :: SPCDIR(MDC,6)                                               30.82
      REAL :: SPCSIG(MSC)                                                 30.72
      REAL :: XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
!     Since the real piece of LSWMAT was removed, the dimensions of       40.22
!     LSWMAT are now MLSWMAT not MSWMAT.                                  40.22
      LOGICAL :: LSWMAT(MDC,MSC,MLSWMAT)                                  30.90 40.22
C
C  8. Subroutines used
C
C     SPREDT
C     SWAPAR
C     SPROXY
C     STABIL
C     SINTGRL
C     SOURCE
C     ACTION
C     SOLMAT
C     SOLMT1
C     SOLBAND
C     SPROSD
C     SWPSEL
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SCOMPU
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ---------------------------------------------------------
C     Call WINDP2 to compute some wave parameters necessarry for
C                 the wind subroutines. The wind sea energy spectrum
C                 is computed before every iteration
C     Compute for the two nearby points:
C       {to reduce the size of the arrays K, CG, CPX, CPY, CAX, CAY, CAS, CAD
C       and CGO, CP use a FUNCTION ICODE(_,_) in were the information
C       of the nearby gridpoints is stored.
C       The size of the arrays of the wave parameters are reduced significantly,
C       par example: CAX(ID,IS,IX,IY) --> CAX(ID,IS,ICMAX)  with ICMAX = 3
C       If a higher order scheme is used ICMAX can be increased so that points
C       at locations ksx = -2,+2 and ksy = -2,+2 can be used:
C
C                                 o ksy=+2
C                                 |
C                                 |
C                                 o ksy=+1     with:  * = (0,0)
C                                 |
C                                 |
C                   o------o------*------o------o
C                ksx=-2   ksx=-1  |   ksx=+1   ksx=+2
C                                 |
C                                 o ksy=-1
C                                 |
C                                 |
C                                 o ksy=-2
C
C          Molecule:
C
C          (4)     2
C            o------o------* 1           Central grid point     : IC = 1              30.70(?), 33.10
C                          |             Point in X-direction   : IC = 2              30.70(?), 33.10
C                          |             Point in Y-direction   : IC = 3              30.70(?), 33.10
C                        3 o             Point in X-direction   : IC = (4)            30.70(?), 33.10
C                          |             Point in Y-diretion    : IC = (5)            30.70(?), 33.10
C                          |             5 gridpoints --> ICC = 5                     30.70(?), 33.10
C                      (5) o             ( ) = is not used by default (BSBT) scheme   30.70(?), 33.10
C
C          Notice that IX and IY are still in the argument list because of
C          the counter of DEP2(IX,IY) and UX2(IX,IY) and UY2(IX,IY) !
C
C     For every ICC = 1 to ICMAX do
C       If (ICC = 1) then
C         IC  = ICODE(0,0)                {central gridpoint}
C         ICX = IX
C         ICY = IY
C         --------------------------------------------------
C       Else if (ICC = 2) then
C         IC = ICODE(KSX,0)               {left or right gridpoint}
C         ICX = IX+KSX
C         ICY = IY
C         --------------------------------------------------
C       Else if (ICC = 3 ) then
C         IC = ICODE(0,KSY)               {top or bottom gridpoint)
C         ICX = IX
C         ICY = IY+KSY
C         --------------------------------------------------
C     End if
C
C     -----------------------------------------------------------------
C     For each gridpoint (IC=1,2,3)  do:
C       Call SWAPAR  to compute the wavenumber K and the group velocity
C                    Cgo and Cg in wave direction (currents included)
C       Call SPROXY  to compute propagation velocities CAX, CAY of
C                    energy propagates
C       If central gridpoint (IC=1) do
C         Call SWPSEL  to compute the bins that fall within a sweep
C                      and which are propagated within a sweep
C         Call SPROSD  to calculate the propagation velocities in
C                      spectral space (CAS and CAD)
C     -------------------------------------------------------
C     If depth > 1.e-4 then do
C       If wind is present :
C         Call WINDP1 to compute the wind speed, PM frequency, mean
C                     wind direction, wind friction velocity and counters
C       -----------------------------------------------------------------
C       Call CNTAIL to compute the contribution of high frequency
C                   tail to the spectrum
C       -----------------------------------------------------------------
C       For the first iteration (ITER = 1), do:
C         Call SPREDT to predict the action density taking into account
C                     the propagation direction of the waves and the two
C                     adjecent points
C       -----------------------------------------------------------------
C       Call SINTGRL to compute some wave parameters (mean frequency
C                    mean wave number, near bottom velocity and signi-
C                    ficant wave height, fraction of breaking waves
C       -----------------------------------------------------------------
C       Call SOURCE  to compute the source terms for each bin which fall
C                    within a sweep:
C                   1. Dissipation by wave-bottom effects
C                   2. Dissipation due to white caping
C                   3. Generation of wave energy by wind effects
C                   4. Nonline awave wave interactions (quadruplets)
C                   5. Nonlinear wave-wave interactions (triads)
C       -----------------------------------------------------------------
C       Call ACTION  calculate the derivatives in x,y,s,d space and store
C                    the results in the corresponding arrays
C       -----------------------------------------------------------------
C       If a current is present :
C         If implicit solver (ILU-CGSTAB) do
C         -----
C           Call SOLBAND  fill matrix (transferred matrices) and
C                         calculate the action density
C         -----
C         endif
C       else if nu current is present do:
C         Call SOLMAT   to solve the tri-diagonal matrix
C       end if
C     ------------------------------------------------------------------
C     CALL WINDP3   for a first or second generation model: limit the
C                   computed action density in a gridpoint according to
C                   the saturation spectra.
C     ---------------------------------------------------------
C     End of SWOMPU
C     ---------------------------------------------------------
C
C 13. Source text
C
      INTEGER  IC    ,IX    ,IY    ,IS    ,SWPDIR,                        40.00
     &         KSX   ,KSY   ,                                             40.00
     &         IDWMIN,IDWMAX,IDTOT ,ISTOT ,IDDLOW,IDDTOP,
     &         ISSTOP,INOCNV                                              40.00
      INTEGER  LINK(MICMAX)                                               33.09
C
      REAL     DDX   ,DDY   ,DT    ,                                      40.00
     &         ETOT  ,AC2TOT,ABRBOT,HM    ,HS    ,QBLOC ,                 40.00
     &         SMESPC,KMESPC,ETOTW ,WIND10,FPM   ,
     &         THETAW,SNLC1 ,DAL1  ,DAL2  ,DAL3  ,XIS   ,
     &         FACHFR,UFRIC ,SMEBRK,SZEROC,EPS2WC,                        40.00
     &         DISWCP,WCPSME,WCPKME,WCPQB ,WCPHM
C
      LOGICAL  INSIDE                                                     33.09
C
      INTEGER :: XYTST(2*NPTST) ,IDCMIN(MSC)                              40.22
      INTEGER :: IDCMAX(MSC)    ,ISCMIN(MDC)    ,ISCMAX(MDC)
      INTEGER :: SECTOR(MSC)    ,WWINT(*)       ,INFMAT(10)
      INTEGER :: IINSOL(14)     ,KGRPNT(MXC,MYC)                          40.00
      INTEGER :: OBSTA(*)       ,CROSS(2,MCGRD)
C
C     *** number of arrays for SWAN ***
C
      REAL  :: AC2(MDC,MSC,MCGRD)                                         30.21
      REAL  :: AC1(MDC,MSC,MCGRD)                                         30.00
      REAL  :: COMPDA(MCGRD,MCMVAR)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CGO(MSC,MICMAX)          ,                                 40.22
     &         CG(MDC,MSC,MICMAX)       ,                                 40.22
     &         CAX(MDC,MSC,MICMAX)      ,                                 40.22
     &         CAY(MDC,MSC,MICMAX)      ,                                 40.22
     &         CAX1(MDC,MSC,MICMAX)     ,                                 33.08 40.22
     &         CAY1(MDC,MSC,MICMAX)     ,                                 33.08 40.22
     &         CAS(MDC,MSC,MICMAX)      ,                                 40.22
     &         CAD(MDC,MSC,MICMAX)                                        40.22
      REAL  :: ALIMW(MDC,MSC)
!              Since the logical piece of SWMATR was removed, the         40.22
!              dimensions of SWMATR are now MSWMATR not MSWMAT            40.22
      REAL  :: SWMATR(MDC,MSC,MSWMATR)                                    40.22
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: KWAVE(MSC,MICMAX)                                          40.22
      REAL  :: AF11(MSC4MI:MSC4MA )                  ,
     &         UE(MSC4MI:MSC4MA , MDC4MI:MDC4MA )    ,
     &         SA1(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &         SA2(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &         DA1C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DA1P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DA1M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DA2C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DA2P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DA2M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         SFNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         DSNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &         MEMNL4(MDC,MSC,MCGRD)               ,                      30.21
     &         SWTSDA(MDC,MSC,NPTSTA,MTSVAR)         ,                    40.00
     &         WWAWG(*)                              ,
     &         WWSWG(*)                              ,
     &         ICOLU2(MDC)                           ,
     &         DIFLOW(MDC,MSC)                       ,
     &         DIFDIG(MDC,MSC)                       ,
     &         DIFUPP(MDC,MSC)                       ,
     &         DIFRHV(MDC,MSC)                       ,
     &         BAND(MDC*MSC,9)                       ,
     &         EXACT(MDC*MSC)                        ,
     &         RHV(MDC*MSC)                          ,
     &         RINSOL(7)                             ,
     &         SOLUT(MDC*MSC)                        ,
     &         WORK(MDC*MSC,10)                      ,
     &         PRECON(MDC*MSC,9)                     ,
     &         UPPERI(MSC)                           ,
     &         LOPERI(MSC)                           ,
     &         RDX(2)        ,RDY(2)                ,                     15/MAY
     &         OBREDF(MDC,MSC,2)                                          040697
C
*
      LOGICAL  GROWW(MDC,MSC)    ,
     &         ANYWND(MDC),
     &         PRECOR                                                     30.00
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWOMPU')
C     ***   Get grid point numbers for points in comput stencil   ***
      IXCGRD(1) = IX                                                      40.00
      IYCGRD(1) = IY                                                      40.00
      KCGRD(1)  = KGRPNT(IX,IY)                                           30.21
      IF (KCGRD(1).GT.1) THEN                                             40.00
        IXCGRD(2) = IX+KSX                                                40.00
        IYCGRD(2) = IY                                                    40.00
        IXCGRD(3) = IX                                                    40.00
        IYCGRD(3) = IY+KSY                                                40.00
        PROPSL = PROPSC                                                   33.09
        IF (PROPSC.EQ.1) THEN                                             33.09
          ICMAX = 3
        ELSE IF (PROPSC.EQ.2) THEN          ! SORDUP scheme               33.10
C         add more points for higher order scheme                         33.10
          ICMAX = 5                                                       33.10
          IXCGRD(4) = IX+2*KSX                                            33.10
          IYCGRD(4) = IY                                                  33.10
          IXCGRD(5) = IX                                                  33.10
          IYCGRD(5) = IY+2*KSY                                            33.10
        ELSE IF (PROPSC.EQ.3) THEN          ! S&L scheme                  33.09
C         add more points for higher order schemes here
          ICMAX = 10                                                      33.09
          IXCGRD(4) = IX                                                  33.09
          IYCGRD(4) = IY-KSY                                              33.09
          IXCGRD(5) = IX-KSX                                              33.09
          IYCGRD(5) = IY                                                  33.09
          IXCGRD(6) = IX+2*KSX                                            33.09
          IYCGRD(6) = IY                                                  33.09
          IXCGRD(7) = IX                                                  33.09
          IYCGRD(7) = IY+2*KSY                                            33.09
          IXCGRD(8) = IX+3*KSX                                            33.09
          IYCGRD(8) = IY                                                  33.09
          IXCGRD(9) = IX                                                  33.09
          IYCGRD(9) = IY+3*KSY                                            33.09
          IXCGRD(10) = IX+KSX                                             33.09
          IYCGRD(10) = IY+KSY                                             33.09
        ENDIF
        DO IC = 2, ICMAX                                                  40.00
C         if one of the points of a stencil is outside the computational  33.09
C         domain, fall back to first order scheme                         33.09
          INSIDE = .TRUE.                                                 33.09
          IF (IXCGRD(IC).LT.1) THEN                                       33.09
            IF (KREPTX.GT.0) THEN                                         33.09
C             domain is repeating in x-direction                          33.09
              IXCGRD(IC) = IXCGRD(IC) + MXC                               33.09
            ELSE                                                          33.09
              IF (IC.LE.3) THEN                                           33.09
                PROPSL = 0                                                33.09
              ELSE                                                        33.09
                IF (PROPSC.GT.1) PROPSL = 1                               33.09
              ENDIF                                                       33.09
              INSIDE = .FALSE.                                            33.09
            ENDIF                                                         33.09
          ENDIF                                                           33.09
          IF (IXCGRD(IC).GT.MXC) THEN                                     33.09
            IF (KREPTX.GT.0) THEN                                         33.09
              IXCGRD(IC) = IXCGRD(IC) - MXC                               33.09
            ELSE                                                          33.09
              IF (IC.LE.3) THEN                                           33.09
                PROPSL = 0                                                33.09
              ELSE                                                        33.09
                IF (PROPSC.GT.1) PROPSL = 1                               33.09
              ENDIF                                                       33.09
              INSIDE = .FALSE.                                            33.09
            ENDIF                                                         33.09
          ENDIF                                                           33.09
          IF (IYCGRD(IC).LT.1 .OR. IYCGRD(IC).GT.MYC) THEN                33.09
            IF (.NOT.ONED) THEN                                           33.09
              IF (IC.LE.3) THEN                                           33.09
                PROPSL = 0                                                33.09
              ELSE                                                        33.09
                IF (PROPSC.GT.1) PROPSL = 1                               33.09
              ENDIF                                                       33.09
            ENDIF                                                         33.09
            INSIDE = .FALSE.                                              33.09
          ENDIF                                                           33.09
          IF (INSIDE) THEN                                                33.09
            KCGRD(IC) = KGRPNT(IXCGRD(IC),IYCGRD(IC))                     40.00
          ELSE                                                            33.09
            KCGRD(IC) = 1                                                 33.09
          ENDIF                                                           33.09
C         if point in stencil is dry, fall back to BSBT scheme.           33.10
          IF (PROPSC.GT.1) THEN                                           33.10
            IF (COMPDA(KCGRD(IC),JDP2).LE.DEPMIN) PROPSL = 1              33.10
            IF (NSTATC.GT.0) THEN                                         40.13
!             if nonstationary, check also previous time level            40.13
              IF (COMPDA(KCGRD(IC),JDP1).LE.DEPMIN) PROPSL = 1            40.13
            ENDIF                                                         40.13
          END IF                                                          33.10
        ENDDO
        IF (PROPSL.EQ.0) THEN                                             33.09
          ICMAX = 1                                                       33.09
        ELSEIF (PROPSL.EQ.1) THEN                                         33.09
          ICMAX = 3                                                       33.09
        ENDIF                                                             33.09
      ELSE
        PROPSL = 0                                                        40.13
        ICMAX = 1                                                         40.13
      ENDIF
 
      IF (ITEST .GE. 180 ) THEN
        WRITE(PRINTF,188) SWPDIR
 188    FORMAT(' Points in stencil in subr SWOMPU, sweep : ',I1,
     &  /,'POINT( IX, IY),  INDEX,    COORDX,       COORDY')
C
        DO IC = 1, ICMAX                                                  40.00
          WRITE(PRINTF,187) IXCGRD(IC), IYCGRD(IC), KCGRD(IC),            40.00
     &    XCGRID(IXCGRD(IC),IYCGRD(IC)), YCGRID(IXCGRD(IC),IYCGRD(IC))    40.00
 187      FORMAT(4X,I4,1X,I4,3X,I5,5X,F10.2,4X,F10.2)
        ENDDO                                                             40.00
      ENDIF
*
C     *** determine whether the point is a test point ***
C
      IPTST  = 0
      TESTFL = .FALSE.
      IF (NPTST.GT.0) THEN
        DO 20 II = 1, NPTST
          IF (IX.NE.XYTST(2*II-1)) GOTO 20
          IF (IY.NE.XYTST(2*II)  ) GOTO 20
C
          IPTST = II
          TESTFL = .TRUE.
          IF (ITEST .GE. 10)
     &    WRITE(PRINTF, 18) IPTST, IX-1, IY-1, KCGRD(1), ITER, SWPDIR     40.00
  18      FORMAT(' Test point ', I2, ', (ix,iy)', 2I5,
     &           ', point index ',I5,                                     30.21
     &           ', iter ', I2, ', sweep ', I1)
  20    CONTINUE
      ENDIF
C
*.................................................................
*
      IF (TESTFL .AND. ITEST .GE. 220) THEN                               40.00
        INDEX = KGRPNT(IX,IY)
        WRITE(PRINTF,322) IX,IY,INDEX
 322    FORMAT(' Action densities for IX  IY IDNX: ', 2I4, I7)            40.00
        DO IS = 1, MSC
          WRITE(PRINTF, 323) IS
 323      FORMAT(' frequency ', I4)
          WRITE(PRINTF, 324) (AC2(ID,IS,INDEX), ID=1, MDC)                40.00
 324      FORMAT (100E12.4)
        ENDDO
      ENDIF
C
C
        IF(TESTFL.AND.ITEST.GE.10) WRITE(PRINTF,2321) SWPDIR,IX,IY
 2321   FORMAT(//,' sweep direction and node IX, IY ',3I4)
C
C     ***  if (kcgrd(ic) <= 1)  return (point is NOT A sea point)  ***
      IF (KCGRD(1) .LE. 1 .OR. COMPDA(KCGRD(1),JDP2) .LE. DEPMIN)RETURN   25/MAR
C
C     Bugfix dated July 13, 1998; prevents transport from a permanent land
C     point (having address 1), only effective if Exception values are used
C     in reading depth and/or coordinates
C
      IF (KCGRD(2) .LE. 1) RETURN                                         30.70
      IF (.NOT.ONED .AND. (KCGRD(3).LE.1)) RETURN                         30.70
C      can be replaced later by: IF(PROPSL.EQ.0)RETURN                    33.09
C
C
 
 
        IF (PROPSL.EQ.3 .AND. NSTATC.GT.0) THEN                           33.08
 
!         calculate propagation velocities for old time level             40.13
!         (needed for S&L scheme nonstationary)                           40.13
 
C         calculate CAX1 and CAY1, in case of S&L scheme                  33.08
C         COMPDA(1,JDP2) is dep2 ;change to..dep1 which is compda(1,jdp1) 33.08
C         COMPDA(1,JVX2) is ux2  ;change to..ux1 which is compda(1,jvx1)  33.08
C         COMPDA(1,JVY2) is uy2  ;change to..uy1 which is compda(1,jvy1)  33.08
C
C         we could save cpu time by calculating the cax values only once  33.08
C           when cax is constant, but this would require swan to          33.08
C           save cax over the entire grid (more memory).                  33.08
C
C         if nonstationary, then cax1 is not necessarily = cax.           33.08
C         also, if we are using the bsbt scheme only,                     33.08
C         ...then cax1,cay1 are not needed.                               33.08
C
          CALL SWAPAR (                  MSC,                             40.13
     &                 MDC              ,ICMAX            ,               33.08
     &                 CG               ,ICUR             ,               33.08
     &                 GRAV             ,COMPDA(1,JDP1)   ,               33.08
     &                 KWAVE            ,CGO              ,               33.08
     &                 SPCDIR(1,2)      ,SPCDIR(1,3)      ,               33.08
     &                 COMPDA(1,JVX1)   ,COMPDA(1,JVY1)   ,               33.08
     &                 SPCSIG           ,KCGRD            ,               33.08
     &                 MCGRD            ,DEPMIN                           33.08
     &                                                           )        33.08
C     ..........JDP1 used rather than JDP2.                               33.08
C     ..........JVX1 used rather than JVX2, JVY1 used rather than JVY2    33.08
C     ..........this modified code has not been validated with            33.08
C     ..............nonstationary currents, but i don't expect any        33.08
C     ..............problems with it.                                     33.08
C
C         *** compute the propagation velocities CAX1 and CAY1       ***
C         *** for all directions for the gridpoints IC = 1 to ICMAX  ***
 
          CALL SPROXY (                ICMAX          ,MSC,               40.13
     &               MDC            ,ICUR           ,CAX1            ,    33.08
     &               CAY1           ,CGO            ,SPCDIR(1,2)    ,     33.08
     &               SPCDIR(1,3)    ,COMPDA(1,JVX1) ,COMPDA(1,JVY1) ,     33.08
     &               SWPDIR         ,KCGRD          ,MCGRD                33.08
     &                                                              )     33.08
C     ................JVX1,JVY1 are used rather than JVX2,JVY2.           33.08
C
        END IF                                                            33.08
 
!       calculate propagation velocities for new time level               40.13
 
C       *** Compute wavenumber and group velocity CGO and the ***
C       *** groupvelocity CG = CGO + U for all directions in  ***
C       *** the gridpoints of the stencil                     ***
 
        CALL SWAPAR (                  MSC              ,                 40.13
     &                 MDC              ,ICMAX            ,
     &                 CG               ,ICUR             ,
     &                 GRAV             ,COMPDA(1,JDP2)   ,
     &                 KWAVE            ,CGO              ,
     &                 SPCDIR(1,2)      ,SPCDIR(1,3)      ,               20.43
     &                 COMPDA(1,JVX2)   ,COMPDA(1,JVY2)   ,
     &                 SPCSIG           ,KCGRD            ,               30.72
     &                 MCGRD            ,DEPMIN
     &                                                    )
C
C       *** compute the propagation velocities CAX and CAY        ***
C       *** for all directions for the gridpoints IC = 1 to ICMAX ***
C
        CALL SPROXY (                ICMAX          ,MSC            ,     40.13
     &               MDC            ,ICUR           ,CAX            ,
     &               CAY            ,CGO            ,SPCDIR(1,2)    ,
     &               SPCDIR(1,3)    ,COMPDA(1,JVX2) ,COMPDA(1,JVY2) ,
     &               SWPDIR         ,KCGRD          ,MCGRD                30.21
     &                                                              )
C
C       *** compute the propagation velocities CAS and CAD ***
C       *** in the central gridpoint only ( IC = 1 ) for   ***
C       *** those directions which lie within a sweep      ***
C
!          due to transfer of loop over IC IF statement is not needed     40.13
C
C       *** compute minimum and maximum counter (IDCMIN and ***
C       *** IDCMAX) and determine the type of SECTOR and    ***
C       *** fill the array ANYBIN to determine if a bin     ***
C       *** lies within the sweep considered                ***
C
        CALL SWPSEL (SWPDIR                          ,IDCMIN        ,
     &               IDCMAX          ,SECTOR           ,CAX           ,
     &               CAY             ,LSWMAT(1,1,JABIN),                  40.02
     &                                ISCMIN           ,                  40.00
     &               ISCMAX          ,IDTOT            ,ISTOT         ,
     &               IDDLOW          ,IDDTOP           ,ISSTOP        ,
     &               COMPDA(1,JDP2)  ,COMPDA(1,JVX2)   ,COMPDA(1,JVY2),
     &               SPCDIR          ,                  XCGRID        ,   30.72
     &               YCGRID          ,RDX              ,RDY           ,   30.72
     &               KSX             ,KSY              ,                  30.21
     &               KGRPNT                                               40.13
     &                                                                )
!       argument KGRPNT added to improve debugging                        40.13
 
C       *** compute the propagation velocities CAS and CAD   ***
C       *** for the central gridpoint only and only for the  ***
C       *** directional domain : IDCMIN-1 until IDCMAX+1     ***
 
        CALL SPROSD (SPCSIG         ,KWAVE          ,CAS            ,   40.03
     &                 CAD            ,CGO            ,                   30.80
     &                 COMPDA(1,JDP2) ,COMPDA(1,JDP1) ,SPCDIR(1,2)    ,
     &                 SPCDIR(1,3)    ,COMPDA(1,JVX2) ,COMPDA(1,JVY2) ,
     &                 SWPDIR         ,IDCMIN         ,IDCMAX         ,
     &                 SPCDIR(1,4)    ,SPCDIR(1,6)    ,SPCDIR(1,5)    ,   30.80
     &                 RDX            ,RDY            ,                   30.80
     &                 CAX          ,CAY          ,LSWMAT(1,1,JABIN),     40.02
     &                 KGRPNT       ,XCGRID       ,YCGRID                 40.03
     &                                                               )
        IF (KSPHER.GT.0) THEN
C
C           *** compute the change of propagation velocity CAD   ***
C           *** due to the use of spheerical coordinates         ***
C
          CALL DSPHER (CAD              ,CG             ,               33.09
     &                   LSWMAT(1,1,JABIN),YCGRID         ,               40.02
     &                   SPCDIR(1,2)                      )
        ENDIF
C
!         statement removed due to transfer of corresponding DO statement
C
*     do if depth is positive:
      IF (COMPDA(KCGRD(1),JDP2) .GT. DEPMIN .AND. IDTOT.GT.0 ) THEN      25/MAR
C
C       *** initialize friction velocity and Fpm frequency even ***
C       *** when there is no wind input                         ***
C
        UFRIC = 1.E-15
        FPM   = 1.E-15
        IF ( IWIND .GE. 1 ) THEN
C
C         *** compute the wind speed, mean wind direction, the    ***
C         *** PM frequency, wind friction velocity U*  and the    ***
C         *** minimum and maximum counters for active wind input  ***
C
          CALL WINDP1 (WIND10     ,THETAW     ,
     &                 IDWMIN     ,IDWMAX     ,
     &                 FPM        ,UFRIC      ,
     &                 COMPDA(1,JWX2) ,COMPDA(1,JWY2) ,
     &                 ANYWND     ,SPCDIR     ,                           40.00
     &                 COMPDA(1,JVX2) ,COMPDA(1,JVY2) ,SPCSIG     )       30.70
        END IF
C
C
C         *** predict action density for first iteration using the ***
C         *** two adjacent gridpoints                              ***
*
*         *** TRCF1 and TRCF2 are the transmission coeff for the two links ***
*         *** in the stencil (between the three point on the stencil)    ***
*
          DO ISC = 1, MSC
            DO IDC = 1, MDC
              OBREDF(IDC,ISC,1) = 1.                                      40.00
              OBREDF(IDC,ISC,2) = 1.                                      40.00
            ENDDO
          ENDDO
*
          IF (NUMOBS.NE.0 .AND. PROPSL.NE.1) THEN
C
C           *** If there are obstacles crossing the points in the stencil ***
C           *** then fall back to first order scheme                      ***
C
            IF (PROPSL.EQ.3) THEN
              NLINK  = 10
              IF (SWPDIR .EQ. 1 ) THEN
                LINK(1)  = CROSS(1,KCGRD(1))                              33.08
                LINK(2)  = CROSS(2,KCGRD(1))
                LINK(3)  = CROSS(1,KCGRD(2))
                LINK(4)  = CROSS(2,KCGRD(2))
                LINK(5)  = CROSS(1,KCGRD(3))
                LINK(6)  = CROSS(2,KCGRD(3))
                LINK(7)  = CROSS(2,KCGRD(4))
                LINK(8)  = CROSS(1,KCGRD(5))
                LINK(9)  = CROSS(1,KCGRD(6))
                LINK(10) = CROSS(2,KCGRD(7))
              ELSE IF (SWPDIR .EQ. 2) THEN
                LINK(1)  = CROSS(1,KCGRD(2))                              33.08
                LINK(2)  = CROSS(2,KCGRD(1))
                LINK(3)  = CROSS(1,KCGRD(6))
                LINK(4)  = CROSS(2,KCGRD(2))
                LINK(5)  = CROSS(1,KCGRD(10))
                LINK(6)  = CROSS(2,KCGRD(3))
                LINK(7)  = CROSS(2,KCGRD(4))
                LINK(8)  = CROSS(1,KCGRD(1))
                LINK(9)  = CROSS(1,KCGRD(8))
                LINK(10) = CROSS(2,KCGRD(7))
              ELSE IF (SWPDIR .EQ. 3) THEN
                LINK(1)  = CROSS(1,KCGRD(2))                              33.08
                LINK(2)  = CROSS(2,KCGRD(3))
                LINK(3)  = CROSS(1,KCGRD(6))
                LINK(4)  = CROSS(2,KCGRD(10))
                LINK(5)  = CROSS(1,KCGRD(10))
                LINK(6)  = CROSS(2,KCGRD(7))
                LINK(7)  = CROSS(2,KCGRD(1))
                LINK(8)  = CROSS(1,KCGRD(1))
                LINK(9)  = CROSS(1,KCGRD(8))
                LINK(10) = CROSS(2,KCGRD(9))
              ELSE IF (SWPDIR .EQ. 4) THEN
                LINK(1)  = CROSS(1,KCGRD(1))                              33.08
                LINK(2)  = CROSS(2,KCGRD(3))
                LINK(3)  = CROSS(1,KCGRD(2))
                LINK(4)  = CROSS(2,KCGRD(10))
                LINK(5)  = CROSS(1,KCGRD(3))
                LINK(6)  = CROSS(2,KCGRD(7))
                LINK(7)  = CROSS(2,KCGRD(1))
                LINK(8)  = CROSS(1,KCGRD(5))
                LINK(9)  = CROSS(1,KCGRD(6))
                LINK(10) = CROSS(2,KCGRD(9))
              ENDIF
            ELSE IF (PROPSL.EQ.2) THEN                                    33.10
              NLINK  = 4                                                  33.10
              IF (SWPDIR .EQ. 1 ) THEN                                    33.10
                LINK(1)  = CROSS(1,KCGRD(1))                              33.10
                LINK(2)  = CROSS(2,KCGRD(1))                              33.10
                LINK(3)  = CROSS(1,KCGRD(2))                              33.10
                LINK(4)  = CROSS(2,KCGRD(3))                              33.10
              ELSE IF (SWPDIR .EQ. 2) THEN                                33.10
                LINK(1)  = CROSS(1,KCGRD(2))                              33.10
                LINK(2)  = CROSS(2,KCGRD(1))                              33.10
                LINK(3)  = CROSS(1,KCGRD(4))                              33.10
                LINK(4)  = CROSS(2,KCGRD(3))                              33.10
              ELSE IF (SWPDIR .EQ. 3) THEN                                33.10
                LINK(1)  = CROSS(1,KCGRD(2))                              33.10
                LINK(2)  = CROSS(2,KCGRD(3))                              33.10
                LINK(3)  = CROSS(1,KCGRD(4))                              33.10
                LINK(4)  = CROSS(2,KCGRD(5))                              33.10
              ELSE IF (SWPDIR .EQ. 4) THEN                                33.10
                LINK(1)  = CROSS(1,KCGRD(1))                              33.10
                LINK(2)  = CROSS(2,KCGRD(3))                              33.10
                LINK(3)  = CROSS(1,KCGRD(2))                              33.10
                LINK(4)  = CROSS(2,KCGRD(5))                              33.10
              ENDIF         ! IF (SWPDIR .EQ. 1 ) THEN                    33.10
            ENDIF           ! IF (PROPSL.EQ.3) THEN                       33.10
            IF (PROPSL.GT.1) THEN                                         33.10
C             if there is an obstacle crossing, fall back to 1st order    33.10
              DO ILINK = 1, NLINK                                         33.08
                IF (LINK(ILINK).GT.0) PROPSL = 1                          33.08
              ENDDO
            ENDIF
          ENDIF
 
        IF (PRECOR .AND. ITER.EQ.1 .AND. NSTATC.EQ.0) THEN                40.00
          IF (NUMOBS .NE. 0) THEN
C
C           *** If there are obstacles crossing the points in the stencil ***
C           *** then the transmission and reflection coeff. are computed  ***
C
 
            IF (SWPDIR .EQ. 1 ) THEN
              LINK(1) = CROSS(1,KCGRD(1))
              LINK(2) = CROSS(2,KCGRD(1))
            ELSE IF (SWPDIR .EQ. 2) THEN
              LINK(1) = CROSS(1,KCGRD(2))
              LINK(2) = CROSS(2,KCGRD(1))
            ELSE IF (SWPDIR .EQ. 3) THEN
              LINK(1) = CROSS(1,KCGRD(2))
              LINK(2) = CROSS(2,KCGRD(3))
            ELSE IF (SWPDIR .EQ. 4) THEN
              LINK(1) = CROSS(1,KCGRD(1))
              LINK(2) = CROSS(2,KCGRD(3))
            ENDIF
 
            IF (LINK(1) .NE. 0 .OR. LINK(2) .NE. 0) THEN                      40.00
              IF (ITEST .GE. 120) WRITE(PRINTF,10)
     &          SWPDIR,KCGRD(1),LINK(1),LINK(2)
 10           FORMAT(' ACTION:  SWPDIR POINT LINK1  LINK2 = ',4(1X,I5))
*
              CALL SWTRCF (OBSTA, CROSS, COMPDA(1,JWLV2),                 40.09
     &                     COMPDA(1,JHS), LINK, OBREDF                    40.09
     &                    ,AC2, SWMATR(1,1,JMATR), KGRPNT, XCGRID,        40.09
     &                     YCGRID, CAX, CAY, RDX, RDY, LSWMAT(1,1,JABIN)  40.02
     &                    )                                               40.09
 
            ENDIF
*
          ENDIF
          CALL SPREDT (SWPDIR           ,AC2               ,CAX       ,
     &                CAY               ,IDCMIN            ,IDCMAX    ,
     &                ISSTOP            ,LSWMAT(1,1,JABIN) ,              40.02
     &                RDX               ,RDY               ,OBREDF    )   40.00
C
        END IF
C
C       *** compute contribution of the high frequency tail  ***
C       *** to the energy spectrum only for "real" cases     ***
C       *** for academic tests with only 2 bins in frequency ***
C       *** space (MSC = 3) the contributions are all set 0. ***
C
*
*        High frequency factor:
*
         IF (IQUAD.GE.1) THEN
           FACHFR = 1. / XIS ** PWTAIL(1)                                 20.72
         ELSE
           FACHFR = 0.
         ENDIF
C
C        *** compute the total action density in a point  ***
C        *** depth dependency is in the subroutine itself ***
C
C
C       Calculate various integral parameters for use in the source terms
C
        CALL SINTGRL  (SPCDIR  ,KWAVE   ,AC2     ,                        40.02
     &                 COMPDA(1,JDP2)   ,QBLOC   ,COMPDA(1,JURSEL),       40.02
     &                 RDX     ,RDY     ,                                 40.02
     &                 AC2TOT  ,ETOT    ,                                 40.02
     &                 ABRBOT  ,COMPDA(1,JUBOT)  ,HS      ,               40.02
     &                 COMPDA(1,JQB)    ,                                 40.02
     &                 HM      ,KMESPC  ,SMEBRK)                          40.02
C
        COMPDA(KCGRD(1),JHS) = HS                                         30.70
C
C       *** start computation of action density for every frequency ***
C
C       *** compute source terms and fill the matrix ***
C
C
        CALL SOURCE (ITER   ,IX                  ,IY                  ,
     &  SWPDIR              ,KWAVE               ,SPCSIG              ,   30.72
     &  SPCDIR(1,2)         ,SPCDIR(1,3)         ,AC2                 ,
     &  COMPDA(1,JDP2)      ,SWMATR(1,1,JMATD)   ,SWMATR(1,1,JMATR)   ,
     &  ABRBOT              ,KMESPC              ,SMESPC              ,
     &  COMPDA(1,JUBOT)     ,UFRIC               ,COMPDA(1,JVX2)      ,
     &  COMPDA(1,JVY2)      ,IDCMIN              ,IDCMAX              ,
     &  IDDLOW              ,IDDTOP              ,IDWMIN              ,
     &  IDWMAX              ,ISSTOP              ,SWTSDA(1,1,1,JPWNDA),
     &  SWTSDA(1,1,1,JPWNDB),SWTSDA(1,1,1,JPWCAP),SWTSDA(1,1,1,JPBTFR),
     &  SWTSDA(1,1,1,JPWBRK),SWTSDA(1,1,1,JP4S)  ,SWTSDA(1,1,1,JP4D)  ,
     &  SWTSDA(1,1,1,JPTRI) ,                     HS                  ,   40.22
     &  ETOT                ,QBLOC               ,THETAW              ,
     &  HM                  ,FPM                 ,WIND10              ,
     &  ETOTW               ,GROWW               ,ALIMW               ,
     &  SMEBRK              ,SNLC1               ,FACHFR              ,
     &  DAL1                ,DAL2                ,DAL3                ,
     &  AF11                ,UE                  ,SA1                 ,
     &  SA2                 ,DA1C                ,DA1P                ,
     &  DA1M                ,DA2C                ,DA2P                ,
     &  DA2M                ,SFNL                ,DSNL                ,
     &  MEMNL4              ,WWINT               ,WWAWG               ,
     &  WWSWG               ,CGO                 ,COMPDA(1,JUSTAR)    ,
     &  COMPDA(1,JZEL)      ,SPCDIR              ,ANYWND              ,
     &  SWMATR(1,1,JDIS0)   ,SWMATR(1,1,JDIS1)   ,SZEROC              ,
     &  EPS2WC              ,DISWCP              ,WCPSME              ,
     &  WCPKME              ,WCPQB               ,WCPHM               ,
     &  XIS                 ,COMPDA(1,JFRC2)     ,IT                  ,   40.00
     &  PRECOR              ,COMPDA(1,JURSEL)                             40.03
     &                                                                 )   30.21
C
C       *** compute transport of action and fill the matrix ***
C
C
        CALL ACTION (IDCMIN      ,IDCMAX            ,SPCSIG            ,  33.09
     &         AC2               ,CAX               ,CAY               ,
     &         CAS               ,CAD               ,SWMATR(1,1,JMATL) ,
     &         SWMATR(1,1,JMATD) ,SWMATR(1,1,JMATU) ,SWMATR(1,1,JMATR) ,
     &                            SECTOR            ,SWMATR(1,1,JMAT5) ,  40.22
     &         SWMATR(1,1,JMAT6) ,ISCMIN            ,ISCMAX            ,
     &         IDDLOW            ,IDDTOP            ,ISSTOP            ,
     &                            LSWMAT(1,1,JABLK) ,LSWMAT(1,1,JABIN) ,  30.90
     &         SWMATR(1,1,JLEK1) ,AC1               ,                     40.00
     &         DYNDEP            ,RDX               ,RDY               ,  30.51
     &         SWPDIR            ,IX                ,IY                ,
     &         KSX               ,KSY               ,OBSTA             ,
     &         XCGRID            ,YCGRID            ,CROSS             ,  30.72
     &         ITER              ,KGRPNT            ,COMPDA(1,JDP2)    ,  23/MAY
     &         COMPDA(1,JHS)     ,OBREDF            ,COMPDA(1,JWLV2)      30.70
     &         ,CAX1             ,CAY1               ,SPCDIR              33.08
     &         ,CGO                                                       33.08
     &                                                                 )
C
C       matrix now is computed; updating action densities starts
C       provided ACUPDA is true
C
        IF (.NOT.ACUPDA) THEN                                             40.07
          IF (TESTFL .AND. ITEST.GE.30) WRITE (PRINTF, *) ' No update'    40.07
          GOTO 700                                                        40.07
        ENDIF                                                             40.07
C
C       preparatory steps before solution of linear system
C
        CALL SOLPRE(AC2                ,SWMATR(1,1,JAOLD)  ,              40.00
     &              SWMATR(1,1,JMATR)  ,SWMATR(1,1,JMATL)  ,
     &              SWMATR(1,1,JMATD)  ,SWMATR(1,1,JMATU)  ,
     &              SWMATR(1,1,JMAT5)  ,SWMATR(1,1,JMAT6)  ,
     &              IDCMIN             ,IDCMAX             ,
     &              SECTOR             ,LSWMAT(1,1,JABIN)  ,
     &                   IDTOT       ,ISTOT       ,
     &                   IDDLOW      ,IDDTOP      ,
     &                   ISSTOP      ,INOCNV      )
C
        IF ( DYNDEP .OR. ICUR .EQ. 1                                      40.00
     &                                       ) THEN                       30.00
C
C         *** implicit scheme in frequency and directional space ***
C
          IF ( INT(PNUMS(8)) .EQ. 1 ) THEN
C
C           *** Implicit scheme in frequency space: solve band   ***
C           *** matrix in case of a current with ILU-CGSTAB      ***
C
            CALL SOLBAND(BAND               ,EXACT              ,         40.00
     &                   RHV                ,RINSOL             ,
     &                   SOLUT              ,WORK               ,
     &                   PRECON             ,UPPERI             ,
     &                   LOPERI             ,LSWMAT(1,1,JABIN)  ,         30.90
     &                   INFMAT             ,IINSOL             ,
     &                   SWMATR(1,1,JMATR)  ,SWMATR(1,1,JMATL)  ,
     &                   SWMATR(1,1,JMATD)  ,SWMATR(1,1,JMATU)  ,
     &                   SWMATR(1,1,JMAT5)  ,SWMATR(1,1,JMAT6)  ,
     &                   SWMATR(1,1,JAOLD)  ,CGO                ,
     &                   KWAVE              ,
     &                   SPCSIG             ,IDCMIN             ,
     &                   IDCMAX             ,AC2                ,
     &                   SECTOR             ,ITER               ,
     &                   IDTOT              ,ISTOT              ,
     &                   IDDLOW             ,IDDTOP             ,
     &                   ISSTOP             ,INOCNV             ,
     &                   QBLOC              ,
     &                   ERRPTS             ,IX                 ,
     &                   IY                 ,                             30.50
     &                   IT                                               30.72
     &                                                          )
            IF (STPNOW()) RETURN                                          34.01
C
          ELSE IF (INT(PNUMS(8)).EQ.2 .OR. INT(PNUMS(8)).EQ.3) THEN       40.00
C
C           *** explicit scheme in frequency space. Energy near the ***
C           *** blocking point is removed from the spectrum based   ***
C           *** on CFL criterion                                    ***
C
            CALL SOLMT1  (IDCMIN             ,IDCMAX             ,        40.00
     &                    AC2                ,SWMATR(1,1,JMATR)  ,
     &                    SWMATR(1,1,JMATD)  ,SWMATR(1,1,JMATU)  ,
     &                    SWMATR(1,1,JMATL)  ,SWMATR(1,1,JAOLD)  ,
     &                    KWAVE              ,CGO                ,
     &                                        SPCSIG             ,        30.72
     &                    SECTOR             ,ICOLU2             ,
     &                    LSWMAT(1,1,JABIN)  ,QBLOC              ,        30.90
     &                                        ISSTOP             ,
     &                    LSWMAT(1,1,JABLK)  ,IDDLOW             ,        30.90
     &                    IDDTOP                                 )        5/mar
C
C
          END IF
C
        ELSE                                                              40.00
C
C         *** no currents, Only implicit scheme in directional space ***
C         *** solve the tri-diagonal matrix with Thomas algoritm     ***
C
          CALL SOLMAT (IDCMIN            ,IDCMAX             ,            40.00
     &                AC2                ,SWMATR(1,1,JMATR)  ,
     &                SWMATR(1,1,JMATD)  ,SWMATR(1,1,JMATU)  ,
     &                SWMATR(1,1,JMATL)  ,SWMATR(1,1,JAOLD)  ,
     &                KWAVE              ,CGO                ,
     &                SPCSIG             ,QBLOC
     &                                                       )
C
        END IF
C
C       *** test output ***
C
        IF ( TESTFL .AND. ITEST .GE. 90 ) THEN
          WRITE (PRTEST, *) ' solution vector'                            40.00
          WRITE (PRTEST, *) ' IS ID1 ID2     action densities'            40.00
          DO IS = 1, MSC
            ID_MIN = IDCMIN(IS)
            ID_MAX = IDCMAX(IS)
            WRITE(PRINTF,6621) IS, ID_MIN, ID_MAX,
     &        (AC2(MOD(IDDUM-1+MDC,MDC)+1, IS, KCGRD(1)),                 40.00
     &        IDDUM = ID_MIN, ID_MAX)
 6621       FORMAT(3I4,600(1X,E12.4))                                     40.03
          ENDDO
        END IF
C
C       *** if negative action density occur rescale with a factor ***
C       *** only the sector computed is rescaled !!                ***
C
        IF (BRESCL) CALL RESCALE(AC2, ISSTOP, IDCMIN, IDCMAX)             40.00
C
C       limit the change of the spectrum
C
        IF (PNUMS(20).LT.100.) CALL PHILIM (AC2, SWMATR(1,1,JAOLD),
     &                  CGO, KWAVE,                                       40.00
     &                  SPCSIG, LSWMAT(1,1,JABIN),
     &                  QBLOC)                                            30.82
C
C       *** reduce the computed energy density if the value is  ***
C       *** larger then the limit value as computed in SWIND    ***
C
        IF ( IWIND .EQ. 1 .OR. IWIND .EQ. 2 )
     &    CALL WINDP3 (MDC     ,MSC     ,ISSTOP  ,ALIMW   ,AC2     ,
     &                 GROWW   ,IDCMIN  ,IDCMAX  ,KCGRD   ,MCGRD   ,      30.21
     &                 ICMAX                                       )      30.21
C
C       *** test output ***
C
        IF ( TESTFL .AND. ITEST .GE. 70 ) THEN
          WRITE (PRINTF, *) ' action densities after adaptations'         40.00
          WRITE (PRTEST, *) ' IS ID1 ID2     action densities'            40.00
          DO IS = 1, MSC
            ID_MIN = IDCMIN(IS)
            ID_MAX = IDCMAX(IS)
            WRITE(PRINTF,6621) IS, ID_MIN, ID_MAX,
     &        (AC2(MOD(IDDUM-1+MDC,MDC)+1, IS, KCGRD(1)),                 40.00
     &        IDDUM = ID_MIN, ID_MAX)
          ENDDO
        END IF
*
*       calculate Dissipation and Leak in all points
*
 700    CONTINUE                                                          40.07
        CALL ADDDIS (MSC                ,MDC                ,
     &               DDIR               ,FRINTF             ,
     &               COMPDA(1,JDISS)    ,COMPDA(1,JLEAK)    ,
     &               AC2                ,LSWMAT(1,1,JABIN)  ,             40.02
     &               SWMATR(1,1,JDIS0)  ,SWMATR(1,1,JDIS1)  ,
     &               SWMATR(1,1,JLEK1)  ,SPCSIG             ,             30.72
     &               KCGRD              ,MCGRD              ,
     &               ICMAX                                                30.21
     &                                                      )
C
      ELSE IF ( COMPDA(KCGRD(1),JDP2) .LE. DEPMIN) THEN
C
C       *** set action density in land points equal to zero ***
C
        DO IS = 1, MSC
          DO ID = 1, MDC
            AC2(ID,IS,KCGRD(1)) = 0.                                      30.21
          ENDDO
        ENDDO
        HS = 0.                                                           20.72
      END IF
C
C     End of the subroutine SWOMPU
      RETURN
      END
C****************************************************************
C
      SUBROUTINE SACCUR (DEP2       ,
     &                   AC2        ,SPCSIG     ,ACCUR      ,             30.72
     &                   HSACC1     ,HSACC2     ,SACC1      ,
     &                   SACC2      ,DELHS      ,DELTM      ,             NRL
     &                   I1GRD      ,I2GRD                   )            NRL
C
C****************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C   --|-----------------------------------------------------------|--
C     | Delft University of Technology                            |
C     | Department of Hydraulic and Geotechnical Engineering      |
C     | Fluid Mechanics Group                                     |
C     | P.O. Box 5048                                             |
C     | 2600 GA Delft                                             |
C     |                                                           |
C     | Programmer(s) :  R.C. RIS                                 |
C     |                  Modified by R. PADILLA and N. BOOIJ      |
C   --|-----------------------------------------------------------|--
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     40.03: Nico Booij
!     40.22: John Cazes and Tim Campbell
C
C  1. Update
C
C     30.72, Nov. 97: Declaration of DDIR, PI and PI2 removed because
C                     they are common and already declared in the
C                     INCLUDE file
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Aug. 99: Introduced a new overall measure for checking accuracy
C     30.82, Aug. 99: Changed all varibles INDEX to INDX, since INDEX is reserved
C     40.03, Feb. 00: test level of message changed
!     40.22, Sep. 01: Added initialization of SACC1 and HSACC1 elements   40.22
!                     that are not wet points.                            40.22
C
C  2. Purpose
C
C     to check the accuracy of the final computation. If a certain
C     accuracy has been reached then terminate the iteration process
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        INTEGERS :
C        ----------
C
C        WETGRD      Counter for the gridpoints which have a depth > 0.
C                    ( wet gridpoints )
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of the spectral direction
C        ICMAX       Maximum counter for the points of the molecul
C        ITER        Number of iteration i.e. number of full sweeps
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C        I1GRD       Lower index for thread loop over spatial grid        NRL
C        I2GRD       Upper index for thread loop over spatial grid        NRL
C
C        REALS:
C        ---------
C
C        DDIR        Spectral direction band width
C        DS          Width of the frequency band
C        PERCNT      Dummy counter for the gridpoints where the
C                    accuracy has not been reached
C        HSRELF      Computed relative error in the significant wave height
C                    according to the value at the old time level
C        RFAULT      Maximum acceptable relative error in the significant
C                    waveheight and the mean frequency in a gridpoint
C        SRELF       Computed relative error in the mean frequency
C                    according to the value at the old time level
C        SMA_T       Dummy variable
C        SMA_B       Dummy variable
C        HMA_T       Dummy variable
C        HMA_B       Dummy variable
C
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        AC2       4D    Action density as function of D,S,X,Y at time T
C        DEP2      2D    Depth
C        HSACC1    2D    Dummy array for the significant wave height
C                        (new value)
C        HSACC2    2D    Dummy array for the significant wave height
C                        (old value)
C        SACC1     2D    Dummy array for the mean frequency (new value)
C        SACC2     2D    Dummy array for the mean frequency (old value)
C        DELHS     2D    difference in Hs between last 2 iterations
C        DELTM     2D    difference in Tm between last 2 iterations
C
C        PNUMS(1)  = DREL     relative error in Hs and Tm
C        PNUMS(2)  = DHABS    absolute error in Hs
C        PNUMS(3)  = DTABS    absolute error in Tm
C        PNUMS(4)  = NPNTS    number of points where accuracy is reached
C
C  6. Local variables
C
C     INDX  : counter                                                     30.82
C     NINDX : number of gridpoints to average over                        30.82
C
      INTEGER INDX, NINDX                                                 30.82
      INTEGER NINDXt                                                      NRL
C
C     HSMN2 : mean Hs over space at current iteration level               30.82
C     HSOVAL: Overall accuracy measure for Hs                             30.82
C     SMN2  : mean Tm over space at current iteration level               30.82
C     TMOVAL: Overall accuracy measure for Tm                             30.82
C
      REAL    HSMN2, HSOVAL, SMN2, TMOVAL                                 30.82
      REAL    HSMN2t, SMN2t                                               NRL
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   ---------------------------------------------------------------
C   If not the first iteration, the do
C     Set old values in dummy array
C   ---------------------------------------------------------------
C   Do for every x and y
C     Compute the mean action density frequency SACC1 and the
C     and the significant waveheight HSACC1
C   ---------------------------------------------------------------
C   If relative fault for mean frequency or significant wave height
C      > certain given value then increase variale with one and
C      compute the relative number of gridpoints in where the accuracy
C      has not been reached
C   ---------------------------------------------------------------
C   End of the subroutine SACCUR
C   ----------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS    ,ID    ,WETGRD,IACCUR
      INTEGER  WETGRDt, IACCURt                                           NRL
C
      REAL     SME_T ,SME_B ,                                             30.72
     &         TMREL ,HSREL ,TMABS ,HSABS,ACCUR                           30.72
C
      REAL     AC2(MDC,MSC,MCGRD)   ,
     &         DEP2(MCGRD)          ,
     &         HSACC1(MCGRD)        ,
     &         HSACC2(MCGRD)        ,
     &         SACC1(MCGRD)         ,
     &         SACC2(MCGRD)         ,
     &         DELHS(MCGRD)         ,
     &         DELTM(MCGRD)
C
C     Place local summed variables in common block so they will           NRL
C     be scoped as shared                                                 NRL
      COMMON/SACCUR_MT_COM/HSMN2,SMN2,NINDX,WETGRD,IACCUR                 NRL
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SACCUR')
!$OMP MASTER                                                              NRL
C     Master thread must adjust lower thread index since loops in         NRL
C     this routine start at 2 instead of 1                                NRL
      I1GRD=2                                                             NRL
C     Master thread initialize the shared variables                       NRL
      HSMN2  = 0.                                                         NRL
       SMN2  = 0.                                                         NRL
      NINDX  = 0                                                          NRL
      WETGRD = 0                                                          NRL
      IACCUR = 0                                                          NRL
!$OMP END MASTER                                                          40.22
!$OMP BARRIER                                                             NRL
C
C     *** If the computation is non steady : check the gridpoints ***
C     *** at the different "timesteps" if they are still the same ***
C     *** then WETGRD is the same. If not: change this subroutine ***
C     ***                                                         ***
C     ***   +++++++++++++++++++     +++++++++++++++++++++         ***
C     ***   +++++++++++++++++++     +++++++++++++++++++++         ***
C     ***   ++++++++     ++++++     +++++++++      ++++++         ***
C     ***   +                 +     ++++                +         ***
C     ***   +                 +     +++                 +         ***
C     ***   +                 +     ++                  +         ***
C     ***   +                 +     +                   +         ***
C     ***   +       t=0       +     +      t=t+1        +         ***
C     ***   +                 +     +                   +         ***
C     ***   +++++++++++++++++++     +++++++++++++++++++++         ***
C     ***                                                         ***
C
      WETGRDt = 0                                                         NRL
      DO 100 INDX = I1GRD,I2GRD                                           NRL
        IF (DEP2(INDX) .GT. DEPMIN) THEN                                  25/MAR
          HSACC1(INDX) = MAX( 1.E-20 , HSACC2(INDX) )                     30.21
          SACC1(INDX)  = MAX( 1.E-20 , SACC2(INDX)  )                     30.21
          WETGRDt = WETGRDt + 1                                           NRL
!       Added to initialize HSACC1 and SACC1 values.                      40.22
        ELSE                                                              40.22
          HSACC1(INDX) = 0.                                               40.22
          SACC1(INDX)  = 0.                                               40.22
        END IF                                                            40.22
 100  CONTINUE
C
C     *** first criterion to terminate the iteration process ***
C     ***                                                    ***
C     *** RELATIVE error :                                   ***
C     ***               Hs2  - Hs1      Tm2 - Tm1            ***
C     ***      DREL  =  ----------  and ----------           ***
C     ***                   Hs1            Tm1               ***
C     ***                                                    ***
C     *** ABSOLUTE error :                                   ***
C     ***                                                    ***
C     ***      DHABS  =  Hs2  - Hs1 < PNUMS(2)               ***
C     ***      DTABS  =  Tm2  - Tm1 < PNUMS(3)               ***
C     ***                                                    ***
C
      DO 200 INDX = I1GRD,I2GRD                                           NRL
C
C       *** Compute the mean ENERGY DENSITY frequency and    ***
C       *** significant waveheight over the full spectrum    ***
C       *** per gridpoint                                    ***
C
        IF (DEP2(INDX) .GT. DEPMIN) THEN                                  25/MAR
          SME_T  = 0.
          SME_B  = 0.
          DO 180 IS = 1, MSC
            DO 170 ID = 1, MDC
              ACS2  = SPCSIG(IS)**2 * AC2(ID,IS,INDX)                     30.72
              ACS3  = SPCSIG(IS) * ACS2                                   30.72
              SME_B = SME_B + ACS2
              SME_T = SME_T + ACS3
 170        CONTINUE
 180      CONTINUE
          SME_B = SME_B * FRINTF * DDIR                                   30.50
          SME_T = SME_T * FRINTF * DDIR                                   30.50
C
C         *** mean frequency and significant wave height per gridpoint ***
C
          IF ( SME_B .LE. 0. ) THEN
            SME_B = 1.E-20
            SACC2(INDX) = 1.E-20                                          30.21
            HSACC2(INDX) = 1.E-20                                         30.21
          ELSE
            SACC2(INDX) = MAX ( 1.E-20 , (SME_T / SME_B) )                30.21
            HSACC2(INDX) = MAX ( 1.E-20 , (4. * SQRT(SME_B)) )            30.21
          END IF
        END IF
 200  CONTINUE
C
C     *** the mean significant waveheight and the mean  ***
C     *** relative frequency over the gridpoints which  ***
C     *** depth is larger than 0 m.                     ***
C     *** The amount of gridpoints is denoted with the  ***
C     *** variable : WETGRD                             ***
C     *** These values are used to compute the SRELF    ***
C     *** and the HSRELF instead of SACC2 and HSACC2    ***
C
C     Note that initialization of ACCUR is not needed since it is         NRL
C     not being summed upon                                               NRL
      IACCURt = 0                                                         NRL
      PI2 = 2. * PI
C
C     Calculate the mean Hs and Tm over all wet gridpoints. These means
C     are then used as an overall accuracy measure.
C
      HSMN2t= 0.                                                          NRL
       SMN2t= 0.                                                          NRL
      NINDXt= 0                                                           NRL
C
      DO 300 INDX = I1GRD,I2GRD                                           NRL
        IF (DEP2(INDX).GT.DEPMIN) THEN                                    30.82
          HSMN2t = HSMN2t + HSACC2(INDX)                                  NRL
          SMN2t  =  SMN2t +  SACC2(INDX)                                  NRL
          NINDXt = NINDXt + 1                                             NRL
        END IF                                                            30.82
 300  CONTINUE                                                            30.82
C
C     Global sum of NINDX                                                 NRL
!$OMP ATOMIC                                                              NRL
      NINDX = NINDX + NINDXt                                              NRL
!$OMP ATOMIC                                                              NRL
      HSMN2 = HSMN2 + HSMN2t                                              NRL
!$OMP ATOMIC                                                              NRL
      SMN2 = SMN2 + SMN2t                                                 NRL
C
!$OMP BARRIER                                                             NRL
!$OMP MASTER                                                              NRL
      HSMN2 = HSMN2 / REAL(NINDX)
       SMN2 =  SMN2 / REAL(NINDX)
!$OMP END MASTER                                                          NRL
!$OMP BARRIER                                                             NRL
C
C     Calculate a set of accuracy parameters based on relative, absolute
C     and overall accuracy measures for Hs and Tm
C
      DO 400 INDX = I1GRD,I2GRD                                           NRL
        IF ( DEP2(INDX) .GT. DEPMIN ) THEN                                25/MAR
          TMREL  = ABS ( SACC2(INDX) - SACC1(INDX) ) /
     &                   SACC1(INDX)                                      30.21
          TMABS  = ABS ( ( PI2/SACC2(INDX)) - (PI2/SACC1(INDX)) )         30.21
          TMOVAL = ABS ( SACC2(INDX) - SACC1(INDX) ) / SMN2               30.82
C
          HSREL  = ABS ( HSACC2(INDX) - HSACC1(INDX) ) /
     &                   HSACC1(INDX)                                     30.21
          HSABS  = ABS ( HSACC2(INDX) - HSACC1(INDX) )                    30.21
          HSOVAL = ABS ( HSACC2(INDX) - HSACC1(INDX) ) / HSMN2            30.82
C
          DELTM(INDX) = TMABS
          DELHS(INDX) = HSABS
C
C         *** gridpoint in which mean period and wave height ***
C         *** have reached required accuracy                 ***
C
          IF ( ITEST .GE. 30 .AND. TESTFL) THEN
            WRITE(PRINTF,3002) SACC2(INDX), SACC1(INDX),
     &                         HSACC2(INDX), HSACC1(INDX)                 30.21
 3002       FORMAT(' SACCUR: SA2 SA1 HSA2 HSA1       :',4E12.4)
            WRITE(PRINTF,2002) TMREL, HSREL, TMABS, HSABS
 2002       FORMAT(' SACCUR: TMREL HSREL TMABS HSABS :',4E12.4)
          ENDIF
C
          IF ( (TMREL .LE. PNUMS(1) .OR. TMOVAL .LE. PNUMS(16)) .AND.     30.82
     &         (HSREL .LE. PNUMS(1) .OR. HSOVAL .LE. PNUMS(15)) ) THEN    30.82
            IACCURt = IACCURt + 1                                         NRL
          END IF
        ELSE
C         *** otherwise set arrays equal 0 ***
          DELTM(INDX) = 0.0
          DELHS(INDX) = 0.0
        END IF
C
C     Test output at test points
C
      IF ( ITEST .GE. 30 .AND. TESTFL) THEN                               30.82
        WRITE(PRINTF,1003) TMREL, TMABS, TMOVAL                           30.82
 1003   FORMAT(' SACCUR: TMREL, TMABS, TMOVAL  :',3E12.4)                 30.82
        WRITE(PRINTF,1004) HSREL, HSABS, HSOVAL                           30.82
 1004   FORMAT(' SACCUR: HSREL, HSABS, HSOVAL  :',3E12.4)                 30.82
      END IF                                                              30.82
C
 400  CONTINUE
C
C     Global sum of IACCUR and WETGRD                                     NRL
!$OMP ATOMIC                                                              NRL
      IACCUR = IACCUR + IACCURt                                           NRL
!$OMP ATOMIC                                                              NRL
      WETGRD = WETGRD + WETGRDt                                           NRL
C
!$OMP BARRIER                                                             NRL
!$OMP MASTER                                                              NRL
      ACCUR  = FLOAT(IACCUR) * 100. / FLOAT(WETGRD)
C     Master thread adjust lower index back to original value             NRL
      I1GRD = 1                                                           NRL
!$OMP END MASTER                                                          NRL
!$OMP BARRIER                                                             NRL
C
C     *** test ouput ***
C
!$OMP MASTER                                                              NRL
      IF ( ITEST .GE. 30 ) THEN                                           40.03
        WRITE(PRINTF,1002) PNUMS(1), PNUMS(2), PNUMS(3)
 1002   FORMAT(' SACCUR: PNUMS(1) DHABS DTABS  :',3E12.4)
        WRITE(PRINTF,1008) WETGRD,IACCUR,ACCUR
 1008   FORMAT(' SACCUR: WETGRD IACCUR ACCUR   :',2I5,E12.4)
      END IF
!$OMP END MASTER                                                          NRL
C
C     End of the subroutine SACCUR
      RETURN
      END
C
C
C****************************************************************
C
      SUBROUTINE INSAC (AC2      ,SPCSIG   ,DEP2     ,                    30.72
     &                  HSACC2   ,SACC2    ,                              NRL
     &                  I1GRD    ,I2GRD     )                             NRL
C
C****************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C   --|-----------------------------------------------------------|--
C     | Delft University of Technology                            |
C     | Department of Hydraulic and Geotechnical Engineering      |
C     | Fluid Mechanics Group                                     |
C     | P.O. Box 5048                                             |
C     | 2600 GA Delft                                             |
C     |                                                           |
C     | Programmer(s) :  R.C. RIS                                 |
C     |                  Modified by R. PADILLA and N. BOOIJ      |
C   --|-----------------------------------------------------------|--
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Update
C
C     30.72, Nov. 97: Declartion of DDIR removed because it is a common
C                     and already declared in the INCLUDE file
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     to check the accuracy of the final computation. If a certain
C     accuracy has been reached then quit the iteration
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of the spectral direction
C        ICMAX       Maximum counter for the points of the molecul
C        ITER        Number of iteration i.e. number of full sweeps
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        I1GRD       Lower index for thread loop over spatial grid        NRL
C        I2GRD       Upper index for thread loop over spatial grid        NRL
C
C        REALS:
C        ---------
C
C        DDIR        Spectral direction band width
C        DS          Width of the frequency band
C
C        one and more dimensional arrays:
C        ---------------------------------
C
C        AC2       4D    Action density as function of D,S,X,Y at time T
C        DEP2      2D    Depth
C        HSACC2    2D    Dummy array for the significant wave height
C                        (old value)
C        SACC2     2D    Dummy array for the mean frequency (old value)
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        ---
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C     9. STRUCTURE
C
C   ---------------------------------------------------------------
C   If the first iteration, the do
C     Set old values in dummy array
C   ---------------------------------------------------------------
C   End of the subroutine INSAC
C   ----------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS    ,ID
      INTEGER  I1GRD ,I2GRD                                               NRL
C
      REAL     SME_T ,SME_B                                               30.72
C
      REAL     AC2(MDC,MSC,MCGRD)   ,                                     30.21
     &         DEP2(MCGRD)          ,                                     30.21
     &         HSACC2(MCGRD)        ,                                     30.21
     &         SACC2(MCGRD)                                               30.21
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'INSAC')
C
C
C     Each thread computes in its own part of spatial domain              NRL
      DO 20 IND = I1GRD,I2GRD                                             NRL
C
C       *** Compute the mean ENERGY DENSITY frequency SACC2  ***
C       *** and the wavenumber HSACC2 average over the full  ***
C       *** spectrum per gridpoint                           ***
C
        IF (DEP2(IND) .GT. DEPMIN ) THEN                                  25/MAR
          SME_T  = 0.
          SME_B  = 0.
          DO 18 IS = 1, MSC
            DO 17 ID = 1, MDC
              ACS2 = SPCSIG(IS)**2 * AC2(ID,IS,IND)                       30.72
              ACS3 = SPCSIG(IS) * ACS2                                    30.72
              SME_B = SME_B + ACS2
              SME_T = SME_T + ACS3
 17         CONTINUE
 18       CONTINUE
          SME_B = SME_B * FRINTF * DDIR                                   30.50
          SME_T = SME_T * FRINTF * DDIR                                   30.50
C
C         *** mean frequency and significant wave height ***
c         *** per gridpoint                               ***
C
          IF ( SME_B .LE. 0. ) THEN
            SACC2(IND)  = 1.E-20
            HSACC2(IND) = 1.E-20
          ELSE
            SACC2(IND)  = MAX ( 1.E-20 , (SME_T / SME_B) )
            HSACC2(IND) = MAX ( 1.E-20 , (4. * SQRT(SME_B)) )
          END IF
        ELSE
          SACC2(IND)  = 0.
          HSACC2(IND) = 0.
        END IF
 20   CONTINUE
C
C     End of the subroutine INSAC
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE ACTION (IDCMIN     ,IDCMAX     ,SPCSIG     ,             33.09
     &                   AC2        ,CAX        ,CAY        ,
     &                   CAS        ,CAD        ,IMATLA     ,
     &                   IMATDA     ,IMATUA     ,IMATRA     ,
     &                               SECTOR     ,IMAT5L     ,             40.22
     &                   IMAT6U     ,ISCMIN     ,ISCMAX     ,
     &                   IDDLOW     ,IDDTOP     ,ISSTOP     ,
     &                   ANYBLK     ,ANYBIN     ,
     &                   LEAKC1     ,AC1        ,                         40.00
     &                   DYNDEP     ,RDX        ,RDY        ,             30.51
     &                   SWPDIR     ,IX         ,IY         ,
     &                   KSX        ,KSY        ,OBSTA      ,
     &                   XCGRID     ,YCGRID     ,CROSS      ,             30.72
     &                   ITER       ,KGRPNT     ,DEP2       ,
     &                   CHS        ,OBREDF     ,WLEV2                    30.70
     &                   ,CAX1      ,CAY1       ,SPCDIR                   33.08
     &                   ,CGO                                             33.08
     &                                                      )
C
C****************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               33.09
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     33.08: W. Erick Rogers (some S&L scheme-related changes)
C     33.09: Nico Booij and Erick Rogers
C     33.10: Nico Booij and Erick Rogers
C     40.03: Nico Booij
C     40.09: Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Mar. 98: water level (WLEV2) and wave height (CHS) in comp. grid
C                     added as arguments (needed for SWTRCF)
C                     Call SWTRCF modified
C     33.08, July 98: some S&L scheme-related changes
C     33.09, Sept 99: changes re: the spherical coordinates
C     33.10, Jan. 00: changes re: the SORDUP scheme
C     40.09, May  00: Argument list SWTRCF modified
C     40.03, Apr. 00: integers LINK1 and LINK2 replaced by array LINK(1:MICMAX)
!     40.22, Sep. 01: Removed WAREA array.                                40.22
!     40.22, Sep. 01: Changed array definitions to use the parameter      40.22
!                     MICMAX instead of ICMAX.                            40.22
C
C  2. Purpose
C
C     to determine the transportation, refraction and the source terms
C     of the ACTION balance equation
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C     XCGRID: Coordinates of computational grid in x-direction            30.72
C     YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C     IX          Counter of gridpoints in x-direction
C     IY          Counter of gridpoints in y-direction
C     ICMAX       Maximum counter for the points of the molecul
C     MXC         Maximum counter of gridppoints in x-direction
C     MYC         Maximum counter of gridppoints in y-direction
C     MSC         Maximum counter of relative frequency
C     MDC         Maximum counter of directional distribution
C     KSX         Dummy variable to get the right sign in the
C                 numerical difference scheme in X-direction
C                 depending of the sweep direction, KSX = -1 or +1
C     KSY         Dummy variable to get the right sign in the
C                 numerical difference scheme in Y-direction
C                 depending of the sweep direction, KSY = -1 or +1
C     IDTOT,ISTOT Maximum range between the counters in directional
C                 space and frequency space respectively
C     IDDLOW      Minimum counter per sweep taken over all
C                 frequencies
C     IDDTOP      Maximum counter per sweep taken over all
C                 frequencies
C     ISSTOP      Maximum counter per sweep taken over all
C                 frequencies
C
C
C     REALS:
C     ---------
C
C     DX,DY       Step size in x-direction and y-direction
C     DDX         Same as DX but with correct sign depending of the
C                 direction of the sweep
C     DDY         Same as DY but with correct sign depending of the
C                 direction of the sweep
C     PI          (3,14)
C
C     one and more dimensional arrays:
C     ---------------------------------
C
C     AC2       4D    Action density as function of D,S,X,Y at time T
C     CAD       3D    Wave transport velocity in spectral direction as
C                     function of (ID,IS,IC)
C     CAS       3D    Wave transport velocity in frequency-direction as
C                     as function of (ID,IS,IC)
C     CAX       3D    Wave transport velocity in X-dirction as function of
C                     (ID,IS,IC)
C     CAY       3D    Wave transport velocity in Y-dirction as function of
C                     (ID,IS,IC)
C     IMATDA    2D    Coefficients of diagonal of matrix
C     IMATLA    2D    Coefficients of lower diagonal of matrix
C     IMATUA    2D    Coefficients of upper diagonal of matrix
C     IMATRA    2D    Coefficients of right hand side of matrix
C     IMAT5L    2D    coefficient of lower diagonal in presence of
C                     a current (see subr. SOLBAND
C     IMAT6U    2D    coefficient of upper diagonal in presence of
C                     a current (see subr. SOLBAND
C
C  8. Subroutines used
C
C     STIME
C     STRSX
C     STRSY
C     STRSS
C     STRSD
C
C  9. Subroutines calling
C
C     SWOMPU
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ---------------------------------------------------------
C     Call STIME to compute the time derivative (@AC2/@t) using the values
c                of the action density of the last time step
C     -------------------------------------------------------------------
C     *** transport in geographical space ***
C     Call STRSX to compute the propagation terms in X-direction
C     Call STRSY to compute the propagation terms in Y-direction
C     -------------------------------------------------------------------
C     *** transport in frequency space ***
C     If implicit scheme in frequency space then
C     ---
C       Call STRSSI  to compute the propagation terms in S-direction
C     ---
C     else if explicit scheme in frequency space and the energy near
C          the blocking point is removed from the spectrum then
C     ---
C       Call STRSSB to compute the propagation terms in S-direction
C     ---
C     endif
C     -------------------------------------------------------------------
C     Call STRSS1 to compute the propagation terms in frequency
C                 space (this method is based on the numerical procedure
C                 as described in Tolman 1991 and should not be used in
C                 SWAN since it is based on a non stationairy situation
C                 (limiting with time step )
C     -------------------------------------------------------------------
C     Call STRSD to compute the propagation terms in directional domain
C     ---------------------------------------------------------
C     End of subroutine ACTION
C     ---------------------------------------------------------
C
C  13. Source text
C
      INTEGER  IDDLOW  ,IDDTOP  ,ISSTOP  ,                                33.09 NB!
     &                  SWPDIR  ,ITER                                     33.09 NB!
C
      LOGICAL           DYNDEP                                            33.09
C
C
C
      INTEGER :: IDCMIN(MSC), IDCMAX(MSC)
      INTEGER :: ISCMIN(MDC), ISCMAX(MDC)
      INTEGER :: SECTOR(MSC)
      INTEGER :: OBSTA(*)
      INTEGER :: LINK(MICMAX)                                             40.03
      INTEGER :: KGRPNT(MXC,MYC)
      INTEGER :: CROSS(2,MCGRD)
C
      REAL  :: AC2(MDC,MSC,MCGRD)  ,AC1(MDC,MSC,MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: CAX(MDC,MSC,MICMAX)  ,CAY(MDC,MSC,MICMAX)                  40.22
      REAL  :: CAX1(MDC,MSC,MICMAX) ,CAY1(MDC,MSC,MICMAX)                 33.08 40.22
      REAL  :: CGO(MSC,MICMAX)                                            33.08 40.22
      REAL  :: CAS(MDC,MSC,MICMAX)  ,CAD(MDC,MSC,MICMAX)                  40.22
      REAL  :: IMATLA(MDC,MSC)     ,IMATDA(MDC,MSC)     ,
     &         IMATUA(MDC,MSC)     ,IMATRA(MDC,MSC)     ,
     &         IMAT5L(MDC,MSC)     ,IMAT6U(MDC,MSC)     ,
     &         LEAKC1(MDC,MSC)
      REAL  :: RDX(2)              ,RDY(2)              ,                 33.09
     &         DEP2(MCGRD)         ,OBREDF(MDC,MSC,2)   ,
     &         WLEV2(MCGRD)        ,CHS(MCGRD)                            30.70
     &         ,SPCDIR(MDC,6)                                             33.08
C
      LOGICAL  ANYBLK(MDC,MSC)     ,ANYBIN(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'ACTION')
C
C     *** set the coefficients in the arrays 0 ***
C
      DO IS = 1, MSC                                                      17/JAN
        DO ID = 1, MDC
          IMATLA(ID,IS) = 0.
          IMATUA(ID,IS) = 0.
        ENDDO
      ENDDO
C
 
*
*     set leak coefficient at 0
*
      DO ISC = 1, MSC
        DO IDC = 1, MDC
          LEAKC1(IDC,ISC) = 0.
        ENDDO
      ENDDO
!     check of dynamic data pool removed                                 40.22
*
*     *** TRCF1 and TRCF2 are the transmission coeff for the two links ***
*     *** in the stencil (between the three point on the stencil)      ***
*
      DO ISC = 1, MSC                                                    040697
        DO IDC = 1, MDC
          OBREDF(IDC,ISC,1) = 1.
          OBREDF(IDC,ISC,2) = 1.
        ENDDO
      ENDDO
*
      IF (NUMOBS .NE. 0) THEN                                            030697
C
C       *** If there are obstacles crossing the points in the stencil ***
C       *** then the transmission and reflection coeff. are computed  *** 30.70
C
        IF (SWPDIR .EQ. 1 ) THEN
          LINK(1) = CROSS(1,KCGRD(1))
          LINK(2) = CROSS(2,KCGRD(1))
        ELSE IF (SWPDIR .EQ. 2) THEN
          LINK(1) = CROSS(1,KCGRD(2))
          LINK(2) = CROSS(2,KCGRD(1))
        ELSE IF (SWPDIR .EQ. 3) THEN
          LINK(1) = CROSS(1,KCGRD(2))
          LINK(2) = CROSS(2,KCGRD(3))
        ELSE IF (SWPDIR .EQ. 4) THEN
          LINK(1) = CROSS(1,KCGRD(1))
          LINK(2) = CROSS(2,KCGRD(3))
        ENDIF
 
        IF (LINK(1) .NE. 0 .OR. LINK(2) .NE. 0) THEN                         060697
          IF (ITEST .GE. 120) WRITE(PRINTF,10)
     &    SWPDIR,KCGRD(1),LINK(1),LINK(2)
 10       FORMAT(' ACTION:  SWPDIR POINT LINK1  LINK2 = ',4(1X,I5))
*
          CALL SWTRCF (OBSTA, CROSS, WLEV2, CHS, LINK, OBREDF             40.09
     &                ,AC2, IMATRA, KGRPNT, XCGRID, YCGRID,               40.09
     &                 CAX,CAY, RDX,RDY, ANYBIN)                          40.09
        ENDIF
*
      ENDIF
C
C     *** Call propagation module in X-Y space  ***
 
C       depending on PROPSL, call STRSXY or other scheme                  33.10
        IF (PROPSL.EQ.3) THEN    ! use S&L scheme
          CALL SANDL(ISSTOP   ,IDCMIN   ,IDCMAX   ,CGO     ,CAX    ,      33.09
     &               CAY      ,AC2      ,AC1      ,IMATRA  ,IMATDA ,      33.09
     &               RDX      ,RDY      ,CAX1     ,CAY1    ,SPCDIR)       33.09
      ELSE IF (PROPSL.EQ.2) THEN ! use SORDUP scheme                      33.10
         CALL SORDUP(ISSTOP   ,IDCMIN   ,IDCMAX   ,CAX      ,             33.10
     &               CAY      ,AC2      ,IMATRA   ,IMATDA   ,             33.10
     &               RDX      ,RDY  )                                     33.10
      ELSE                     ! use BSBT scheme
      CALL STRSXY(ISSTOP   ,IDCMIN   ,IDCMAX   ,CAX      ,                40.00
     &            CAY      ,AC2      ,AC1      ,IMATRA   ,IMATDA   ,
     &                      RDX      ,RDY      ,                          40.00
     &            OBREDF          )                                       40.00
C
        END IF                                                                          33.08
C
*!!.....................................................................
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 120 ) THEN
        WRITE(PRINTF,111) KCGRD(1)
 111    FORMAT(' ACTION POINT  :',I5)
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) ' matrix coefficients in action after strs(x-y)'
        WRITE(PRINTF,*)
        WRITE(PRINTF,*)
     & '   IS   ID    IMAT5L       IMATDA       IMAT6U    IMATRA    CAS'
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF (ISCMIN(ID).GT.0) THEN
            DO IS = ISCMIN(ID), ISCMAX(ID)
              WRITE(PRINTF,2101) IS, ID, IMAT5L(ID,IS),IMATDA(ID,IS),
     &                         IMAT6U(ID,IS),IMATRA(ID,IS),CAS(ID,IS,1)
2101          FORMAT(1X,2I4,4X,4E12.4,E10.2)
            ENDDO
          ENDIF
        ENDDO
      END IF
C
      IF ( DYNDEP .OR. ICUR .EQ. 1                                        40.00
     &                                    ) THEN
C
C       *** call propagation module in S-direction ***
C
        IF ( INT(PNUMS(8)) .EQ. 1 ) THEN
C
C         *** use implicit scheme for the integration in frequency ***
C         *** space (no apriori assumtions)                        ***
C
          CALL STRSSI (MSC     ,MDC     ,ICMAX   ,PNUMS   ,SPCSIG  ,      30.72
     &                 CAS     ,IMAT5L  ,IMATDA  ,IMAT6U  ,ANYBIN  ,
     &                 IMATRA  ,AC2     ,ISCMIN  ,ISCMAX  ,IDDLOW  ,
     &                 IDDTOP  ,KCGRD   ,MCGRD                     )      30.21
C
        ELSE IF ( INT(PNUMS(8)) .EQ. 2 ) THEN
C
C         *** Explicit numerical scheme in frequency space    ***
C         *** based on flux transport of action across        ***
C         *** boundaries. Energy is removed from the spectrum ***
C         *** based on a CFL criterion                        ***
C
          CALL STRSSB (MDC     ,MSC     ,ICMAX   ,IDDLOW  ,IDDTOP  ,
     &                 IDCMIN  ,IDCMAX  ,ISSTOP  ,CAX     ,CAY     ,
     &                 CAS     ,AC2     ,SPCSIG  ,IMATRA  ,PNUMS   ,      30.72
     &                 ANYBLK  ,KCGRD   ,MCGRD   ,RDX     ,RDY     )      30.21
C
        END IF
      END IF
C
C     *** call propagation module in D-direction ***
C
      CALL STRSD (MSC     ,MDC     ,ICMAX   ,DDIR    ,IDCMIN  ,
     &            IDCMAX  ,CAD     ,IMATLA  ,IMATDA  ,IMATUA  ,
     &            IMATRA  ,AC2     ,PNUMS   ,ISSTOP  ,FULCIR  ,
     &            ANYBIN  ,LEAKC1  ,KCGRD   ,MCGRD            )           30.21
C
C     *** test; remove on vector computer ***
C
      IF ( TESTFL .AND. ITEST .GE. 70 ) THEN
        WRITE(PRINTF,*) ' *** Values at end of subroutine action ***'
        WRITE (PRINTF,6120) KCGRD(1), MCGRD, MSC, MDC
 6120   FORMAT (' ACTION: POINT MCGRD MSC MDC   : ',4I5)
        WRITE (PRINTF,6220) IDDLOW,IDDTOP,ISSTOP, ICMAX
 6220   FORMAT (' ACTION: IDLW IDTP ISTOP ICMAX   : ',4I4)
        WRITE (PRINTF,6020) KCGRD(1), KCGRD(2), KCGRD(3)
 6020   FORMAT (' ACTION: KCGRD(1), KCGRD(2), KCGRD(3)     : ',3I4)
        WRITE (PRINTF,6022) RDX(1), RDX(2), RDY(1), RDY(2)
 6022   FORMAT (' ACTION:RDX(1) RDX(2) RDY(1) RDY(2) : ',4E12.4)
        IF (ITEST.GE.210) THEN                                            40.00
          DO IS = 1, MSC
            WRITE(PRINTF,6420) SPCSIG(IS),IDCMIN(IS),IDCMAX(IS),          30.72
     &                       SECTOR(IS)
 6420       FORMAT (' ACTION: SPCSIG IDCMIN IDCMAX SECT: ',F8.4,3I6)      30.72
          ENDDO
          DO IS = 1, MSC
            WRITE(PRINTF,*) 'IS ',IS
            DO ID = 1, MDC
              WRITE(PRINTF,6320) ID, CAX(ID,IS,1), CAY(ID,IS,1),
     &                   CAS(ID,IS,1), CAD(ID,IS,1), AC2(ID,IS,KCGRD(1))
 6320         FORMAT(' ACTION: ID CAX CAY CAS CAD AC2:',I3,5E12.4)
            ENDDO
          ENDDO
        ENDIF                                                             40.00
        WRITE(PRINTF,*) ' *** end of subr ACTION *** '                    40.00
      END IF
C     End of subroutine ACTION
      RETURN
      END
C****************************************************************
C
      SUBROUTINE SINTGRL(SPCDIR  ,KWAVE   ,AC2     ,                      40.02
     &                   DEP2    ,QB_LOC  ,URSELL  ,                      40.02
     &                   RDX     ,RDY     ,                               40.02
     &                   AC2TOT  ,ETOT    ,                               40.02
     &                   ABRBOT  ,UBOT    ,HS      ,QB      ,             40.02
     &                   HM      ,KMESPC  ,SMEBRK  )                      40.02
C
C****************************************************************
C
      USE M_WCAP
C
      IMPLICIT NONE
C
      INCLUDE 'ocpcomm4.inc'
      INCLUDE 'swcomm1.inc'
      INCLUDE 'swcomm3.inc'
      INCLUDE 'swcomm4.inc'
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.02: IJsbrand Haagsma
!     40.13: Nico Booij
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     40.02, Jan. 00: New, based on the old SDISPA subroutine
C     40.02, Oct. 00: KWAVE removed in call BRKPAR
!     40.13, Aug. 01: reduction of spectrum not for Mode Noupdate
!     40.22, Sep. 01: Changed array definitions to use the parameter      40.22
!                     MICMAX instead of ICMAX.                            40.22
!     40.22, Sep. 01: Changed allocated arrays to static arrays to fix    40.22
!                     OpenMP problems with arrays allocated in parallel   40.22
!                     regions.                                            40.22
!     40.22, Oct. 01: PSURF(2) is no longer used as a variable
C
C  2. Purpose
C
C     To compute several integrals used in SWAN and some general parameters
C
C  3. Method
C
C     The total energy ETOT is calculate as the following integral
C
C     ETOT = Integrate [ AC2(theta,sigma) sigma dsigma dtheta ]
C
C     To avoid too high dissipation by breaking, ETOT is maximised by a maximum
C     total energy EMAX based on the maximum wave heigth HM:
C
C     HM    = PSURF(2) depth
C
C                      2
C     EMAX  = 0.25 * HM
C
C     When EMAX > ETOT, then the action density AC2 is reduced by EMAX/ETOT
C
C     In the physicaly unrealistic case that ETOT <= 0, the integrals and other parameters
C     get values that represent a steady sea-state with wind close to zero.
C
C     The following integrals are calculated:
C
C                                                       2
C     AB2   = Integrate [ (AC2(theta,sigma) sigma / Sinh [ K(sigma) depth ]) dsigma dtheta ]
C
C     ACTOT = Integrate [ AC2(theta,sigma) dsigma dtheta ]
C
C     EDRKTOT=Integrate [ (AC2(theta,sigma) sigma / Sqrt [ K(sigma) ]) dsigma dtheta ]
C
C     EKTOT = Integrate [ AC2(theta,sigma) K(sigma) sigma dsigma dtheta ]
C
C                                               2
C     ETOT1 = Integrate [ AC2(theta,sigma) sigma dsigma dtheta ]
C
C                                               3
C     ETOT2 = Integrate [ AC2(theta,sigma) sigma dsigma dtheta ]
C
C                                               5
C     ETOT4 = Integrate [ AC2(theta,sigma) sigma dsigma dtheta ]
C
C                                                3      2
C     UB2   = Integrate [ (AC2(theta,sigma) sigma / Sinh [ K(sigma) depth ]) dsigma dtheta ]
C
C     For reasons of ??, in the calculation of UB2, AB2, ETOTM2, ETOTM4, the high frequency
C     tail is ignored.
C
C     Based on these integrals the following parameters are calculated:
C
C     ABRBOT  = Sqrt [ 2 AB2 ]
C     HS      = 4 Sqrt [ ETOT ]
C                               2
C     KM_WAM  = (ETOT / EDRKTOT)
C     QB      : Using the subroutine FRABRE
C     SIGM01  = ETOT1 / ETOT
C     SIGM_10 = ETOT  / ACTOT
C     UBOT    = Sqrt [ UB2 ]
C
C  4. Argument variables
C
C     ABRBOT: Near bottom excursion
C     AC2   : Action density as function of ID, IS, IX and IY
C     AC2TOT : Total action density per gridpoint
C     DEP2  : Water depth
C     ETOT  : Total wave energy density
C     HM    : Maximum wave height
C     HS    : Significant wave height
C     KMESPC: Mean average wavenumber according to the WAM-formulation
C     KWAVE : Wavenumber function of frequency and IC??
C     QB    : Fraction of breaking waves
C     QB_LOC: Fraction of breaking waves at current grid-point
C     SMEBRK: Mean frequency according to first order moment
C     UBOT  : Near bottom velocity as function of IX and IY
C     URSELL: Ursell number as function of IX and IY
C
      REAL, INTENT(IN)     :: DEP2(MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL, INTENT(IN)     :: KWAVE(MSC,MICMAX)                           40.22
      REAL, INTENT(IN)     :: RDX(2), RDY(2)
      REAL, INTENT(IN)     :: SPCDIR(MDC,6)
C
      REAL, INTENT(IN OUT) :: AC2(MDC,MSC,MCGRD)
      REAL, INTENT(IN OUT) :: QB(MCGRD)
      REAL, INTENT(IN OUT) :: UBOT(MCGRD)
      REAL, INTENT(IN OUT) :: URSELL(MCGRD)
C
      REAL, INTENT(OUT)    :: ABRBOT, ETOT, HM, HS, QB_LOC
      REAL, INTENT(OUT)    :: AC2TOT, KMESPC, SMEBRK
C
C  6. Local variables
C
C     IENT  : Number of entries in this subroutine
C     IS    : Counter for the relative frequency band
C
      INTEGER, SAVE :: IENT = 0
C
C     AB2                : Sum of E_DSHKD2_DS_DD
C     ACTOT_DSIG         : Integration term for calculating ACTOT
C     EDRKTOT_SWELL      : Swell-part of EDRKTOT
C     EMAX               : Maximum energy according calculated HM
C     ETOT_DRK_DSIG      : Integration term for calculating EDRKTOT
C     ETOT_K_DSIG        : Integration term for calculating EKTOT
C     ETOT_DSHKD2_DSIG   : Integration term for calculating AB2
C     ETOT_DSIG          : Integration term for calculating ETOT
C     ETOT_SIG_DSIG      : Integration term for calculating ETOT1
C     ETOT_SIG2_DSIG     : Integration term for calculating ETOT2
C     ETOT_SIG2_DSHKD2_DSIG: Integration term for calculating UB2
C     ETOT_SIG4_DSIG     : Integration term for calculating ETOT4
C     FRINT_X_DDIR       : FRINTF * DDIR
CWCAPC     SIG_SPLIT          : The frequency at which sea and swell are distinguished
C     SINH_K_X_DEP_2     : SINH(KWAVE*DEP2)**2
C     UB2                : Sum of ETOT_SIG2_DSHKD2_DSIG
C
      REAL              :: AB2, EMAX, UB2
      REAL              :: FRINTF_X_DDIR
      REAL              :: BRCOEF   ! variable breaking coefficient (calc. in BRKPAR)  40.22
CWCAP      REAL              :: EDRKTOT_SWELL, SIG_SPLIT
C
!     With the current implementation of OpenMP, allocated arrays are     40.22
!     forced to be shared.                                                40.22
      REAL              :: ETOT_DSIG(MSC)                                 NRL
      REAL              :: ACTOT_DSIG(MSC), ETOT_DSHKD2_DSIG(MSC)         NRL
      REAL              :: ETOT_DRK_DSIG(MSC), ETOT_SIG2_DSIG(MSC)        NRL
      REAL              :: ETOT_K_DSIG(MSC), ETOT_SIG_DSIG(MSC)           NRL
      REAL              :: ETOT_SIG2_DSHKD2_DSIG(MSC)                     NRL
      REAL              :: ETOT_SIG4_DSIG(MSC)                            NRL
      REAL              :: SINH_K_X_DEP_2(MSC)                            NRL
!
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        FRABRE2
C        BRKPAR
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   ----------------------------------------------------------
C   Determine ETOT
C   If energy level is too large compared with depth
C   Then reduce action densities
C   ------------------------------------------------------
C   For all spectral frequencies do
*       determine wavenumber K and K*depth
*       For every spectral direction do
*           add AC2 to sum of action densities
*       --------------------------------------------------
*       add contributions to various moments of energy density
*   ---------------------------------------------------------
*   add tail contributions
*   determine average frequency and wavenumber
*   If B&J whitecapping is used
*   Then call FRABRE2 to compute fraction of breaking waves
*   ----------------------------------------------------------
*   If B&J surf breaking is used
*   Then call FRABRE2 to compute fraction of breaking waves
*   ----------------------------------------------------------
*   determine orbital motion near the bottom
*   ----------------------------------------------------------
C
C 13. Source text:
C
      IF (LTRACE) CALL STRACE (IENT,'SINTGRL')
C
C     Initialisation
C
CWCAP      IWCAP   = IWCAP-10
CWCAPC
      KM_WAM  = 10.
      KM01    = 10.
CWCAP      K_SWELL = 10.
C
      SIGM01  = 10.
      SIGM_10 = 10.
C
      HS      = 0.
      HM      = 0.1
CWCAP      HS_SWELL= 0.
C
      QB(KCGRD(1))   = 0.
      ABRBOT         = 0.001
      UBOT(KCGRD(1)) = 0.
CWCAPC
CWCAPC     Calculate split between swell and sea
CWCAPC
CWCAP      IS_SPLIT  = 1
CWCAP      SIG_SPLIT = 2. * PI * OUTPAR(5)
CWCAP      DO IS = 1, MSC
CWCAP        IF (SPCSIG_f90(IS,1).LT.SIG_SPLIT) IS_SPLIT = IS
CWCAP      ENDDO
C
C     Calulate total spectral energy:
C
C
      FRINTF_X_DDIR = FRINTF * DDIR
      ETOT_DSIG(:)  = SUM(AC2(:,:,KCGRD(1)),DIM=1) * SPCSIG_f90(:,2) *
     &                FRINTF_X_DDIR
      ETOT          = SUM(ETOT_DSIG)
C
C     *** add high frequency tail ***
C
      ETOT = ETOT + ETOT_DSIG(MSC) * PWTAIL(6) / FRINTF
C
      IF (ISURF .EQ. 1) THEN
        HM   = PSURF(2) * DEP2(KCGRD(1))                                  40.22
      ELSEIF (ISURF .GE. 2) THEN
C        Calulate the correct breaking coefficient BRCOEF
         CALL BRKPAR (BRCOEF  ,SPCDIR(1,2), SPCDIR(1,3), AC2     ,
     &                SPCSIG_f90(:,1), DEP2, RDX, RDY            )        40.22
        HM   = BRCOEF * DEP2(KCGRD(1))                                    40.22
      ELSE
!       breaking disabled, assign very high value to HM
        HM   = 100.                                                       40.22
      ENDIF
C
      EMAX = 0.25 * HM**2
C
C     Reduce Action density if necessary
C
      IF (ACUPDA .AND. ETOT .GT. EMAX .AND. ISURF .GE. 1) THEN            40.13
         AC2(:,:,KCGRD(1)) = MAX(0.,(EMAX/ETOT)*AC2(:,:,KCGRD(1)))
C
         if (testfl.and.itest.ge.80)
     &        write (prtest,7) dep2(KCGRD(1)), emax, etot
   7     format (' energy is reduced in SINTGRL', 4(1x, e12.4))
C
C        Correct value for ETOT
C
         ETOT = EMAX
C
      ENDIF
C
      IF ( ETOT .GT. 0. ) THEN
C
C     Calculate all other integrals
C
C
        SINH_K_X_DEP_2(:)   = SINH(MIN(30.,
     &                             KWAVE(:,1)*DEP2(KCGRD(1)))
     &                            )**2
        ACTOT_DSIG(:)       = SUM(AC2(:,:,KCGRD(1)),DIM=1) *
     &                        SPCSIG_f90(:,1) * FRINTF_X_DDIR
        ETOT_DSIG(:)        = ACTOT_DSIG(:) * SPCSIG_f90(:,1)
        ETOT_SIG_DSIG(:)    = ACTOT_DSIG(:) * SPCSIG_f90(:,2)
        ETOT_SIG2_DSIG(:)   = ACTOT_DSIG(:) * SPCSIG_f90(:,3)
        ETOT_SIG4_DSIG(:)   = ACTOT_DSIG(:) * SPCSIG_f90(:,5)
        ETOT_DRK_DSIG(:)    = ETOT_DSIG(:) / SQRT(KWAVE(:,1))
        ETOT_K_DSIG(:)      = ETOT_DSIG(:) * KWAVE(:,1)
        ETOT_DSHKD2_DSIG(:) = ETOT_DSIG(:) / SINH_K_X_DEP_2(:)
        ETOT_SIG2_DSHKD2_DSIG(:) = ETOT_DSHKD2_DSIG(:) *
     &                             SPCSIG_f90(:,2)
C
        ACTOT         = SUM(ACTOT_DSIG)
CWCAP        ETOT_SWELL    = SUM(ETOT_DSIG(1:IS_SPLIT))
        ETOT1         = SUM(ETOT_SIG_DSIG)
        ETOT2         = SUM(ETOT_SIG2_DSIG)
        ETOT4         = SUM(ETOT_SIG4_DSIG)
        EDRKTOT       = SUM(ETOT_DRK_DSIG)
CWCAP        EDRKTOT_SWELL = SUM(ETOT_DRK_DSIG(1:IS_SPLIT))
        EKTOT         = SUM(ETOT_K_DSIG)
        UB2           = SUM(ETOT_SIG2_DSHKD2_DSIG)
        AB2           = SUM(ETOT_DSHKD2_DSIG)
C
C     Add high frequency tails
C
        ACTOT       = ACTOT + PWTAIL(5) * ACTOT_DSIG(MSC) / FRINTF
        ETOT1       = ETOT1 + PWTAIL(7) * ETOT_DSIG(MSC) *
     &                SPCSIG_f90(MSC,1) / FRINTF
        EDRKTOT     = EDRKTOT + PWTAIL(5) * ETOT_DSIG(MSC) /
     &                (SQRT(KWAVE(MSC,1)) * FRINTF)
        EKTOT       = EKTOT + PWTAIL(8) * ETOT_DSIG(MSC) *
     &                KWAVE(MSC,1) / FRINTF
C
C
C     Calculate the mean frequencies SIGM01 and SIGM_10,
C     mean wavenumbers KM_WAM, KM01 and significant waveheight HS
C
        IF (ETOT1 .GT. 0.) SIGM01  = ETOT1 / ETOT
        IF (EKTOT .GT. 0.) KM01    = EKTOT / ETOT
        IF (ACTOT .GT. 0.) SIGM_10 = ETOT / ACTOT
        IF (EDRKTOT .GT. 0. ) THEN
          KM_WAM  = ( ETOT / EDRKTOT )**2.
CWCAP          K_SWELL = ( ETOT_SWELL / EDRKTOT_SWELL )**2.
        ENDIF
        IF ( ETOT .GT. 1.E-20 ) THEN
          HS       = 4. * SQRT (ETOT)
CWCAP          HS_SWELL = 4. * SQRT (ETOT_SWELL)
        END IF
C
C     Calculate QB, when breaking is activated
C
        IF ((ISURF.GT.0).OR.(IWCAP.EQ.4).OR.(IWCAP.EQ.5))
     &    CALL FRABRE2 (HM, ETOT, QB(KCGRD(1)))
C
C     Calculate the orbital velocity UBOT and orbital excursion ABRBOT
C
        IF ( UB2 .GT. 0.) UBOT(KCGRD(1)) = SQRT ( UB2 )
        IF ( AB2 .GT. 0.) ABRBOT = SQRT (2. *  AB2)
C
      ENDIF
C
C     *** calculate Ursell number ***
C
      URSELL(KCGRD(1)) = ( GRAV * HS ) /
     &          ( 2. * SQRT(2.) * SIGM01**2 * DEP2(KCGRD(1))**2 )
C
C     *** test output ***
C
      IF (TESTFL .AND. ITEST.GE.60) THEN
         WRITE(PRTEST, 901) ETOT, HS, SIGM_10, KM_WAM, ABRBOT
 901     FORMAT (' SINTGRL: ETOT Hs Sigma K Aorb', 5(1X, E11.4))
      END IF
C
C
C     Set variables used outside the whitecapping scope
C
      AC2TOT = ACTOT
      KMESPC = KM_WAM
      SMEBRK = SIGM01
      QB_LOC = QB(KCGRD(1))
CWCAP      IWCAP  = IWCAP + 10
C
      RETURN
C
      END SUBROUTINE SINTGRL
C****************************************************************
C
      SUBROUTINE SOLPRE (AC2         ,AC2OLD      ,                        40.00
     &                   IMATRA      ,IMATLA      ,
     &                   IMATDA      ,IMATUA      ,
     &                   IMAT5L      ,IMAT6U      ,
     &                   IDCMIN      ,IDCMAX      ,
     &                   SECTOR      ,ANYBIN      ,
     &                   IDTOT       ,ISTOT       ,
     &                   IDDLOW      ,IDDTOP      ,
     &                   ISSTOP      ,INOCNV      )
C
C****************************************************************
C
      INCLUDE 'swcomm2.inc'                                               40.00
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     40.00: Nico Booij
C
C  1. Updates
C
C     40.00, Feb. 99: New subroutine common tasks before solution of linear
C                     system (software moved from SOLBAND, SOLMAT and SOLMT1)
C
C  2. Purpose
C
C     Copy local spectrum to array AC2OLD, write test output
C     fill array for non-active bins
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C        AC2OLD    2D    Values of action density stored for limiter
C        IMATDA    2D    Coefficients of diagonal of matrix
C        IMATLA    2D    Coefficients of lower diagonal of matrix
C        IMATUA    2D    Coefficients of upper diagonal of matrix
C        IMATRA    2D    Coefficients of right hand side of matrix
C        IMAT5L    2D    Coefficients for implicit calculation in
C                        frequency sapce (lower diagonal)
C        IMAT6U    2D    Coefficients for implicit calculation in
C                        frequency sapce (upper diagonal)
C
      REAL     AC2(MDC,MSC,MCGRD)           ,
     &         IMATRA(MDC,MSC)              ,
     &         IMATLA(MDC,MSC)              ,
     &         IMATDA(MDC,MSC)              ,
     &         IMATUA(MDC,MSC)              ,
     &         IMAT5L(MDC,MSC)              ,
     &         IMAT6U(MDC,MSC)              ,
     &         AC2OLD(MDC,MSC)
C
C        IDCMIN    1D    Integer array containing minimum counter
C        IDCMAX    1D    Integer array containing maximum counter
C
      INTEGER  IDCMIN(MSC)                  ,
     &         IDCMAX(MSC)                  ,
     &         SECTOR(MSC)
C
C        ANYBIN    2D    Logical array. if a certain bin is enclosed
C                        in a sweep then ANYBIN is TRUE . array is
C                        used to determine whether some coefficients
C                        in the array have to be changed
C
      LOGICAL  ANYBIN(MDC,MSC)
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS      ,ID      ,IDDUM   ,
     &         IDDLOW  ,INOCNV  ,
     &         IDDTOP  ,IDTOT   ,ISTOT   ,ISSTOP
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SOLPRE')
C
      DO IS = 1, ISSTOP
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF ( .NOT. ANYBIN(ID,IS) ) THEN
            IMATLA(ID,IS) = 0.
            IMATDA(ID,IS) = 1.
            IMATUA(ID,IS) = 0.
            IMATRA(ID,IS) = AC2(ID,IS,KCGRD(1))                           30.21
            IMAT5L(ID,IS) = 0.
            IMAT6U(ID,IS) = 0.
          END IF
        ENDDO
      ENDDO
C
C     *** to limit the rate of change in a bin the action density ***
C     *** is stored in a auxiliary array AC2OLD                   ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          AC2OLD(ID,IS) = AC2(ID,IS,KCGRD(1))
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 70 ) THEN
        WRITE (PRINTF,6120) IXCGRD(1)-1, IYCGRD(1)-1
 6120   FORMAT (' SOLPRE: Matrix values for point:', 2I5)
        WRITE (PRINTF,6121)
 6121   FORMAT ('  bin     diagonal     r.h.s.        ID-1        ID+1',
     &          '         IS-1         IS+1')
*
        DO IS = 1, MSC
          ID_MIN = IDCMIN(IS)
          ID_MAX = IDCMAX(IS)
          DO IDDUM = ID_MIN, ID_MAX
            ID = MOD(IDDUM-1 + MDC, MDC) + 1
            IF ( DYNDEP .OR. ICUR .EQ. 1 ) THEN                           40.00
              WRITE(PRINTF,6620) ID, IS, IMATDA(ID,IS), IMATRA(ID,IS),
     &        IMATLA(ID,IS), IMATUA(ID,IS), IMAT5L(ID,IS), IMAT6U(ID,IS)
 6620         FORMAT(2I3,6(1X,E12.4))
            ELSE
              WRITE(PRINTF,6620) ID, IS, IMATDA(ID,IS), IMATRA(ID,IS),
     &        IMATLA(ID,IS), IMATUA(ID,IS)
            ENDIF
          ENDDO
        ENDDO
      END IF
C
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SOLBAND (BAND        ,EXACT       ,                      40.00
     &                    RHV         ,RINSOL      ,
     &                    SOLUT       ,WORK        ,
     &                    PRECON      ,UPPERI      ,
     &                    LOPERI      ,ANYBIN      ,
     &                    INFMAT      ,IINSOL      ,
     &                    IMATRA      ,IMATLA      ,
     &                    IMATDA      ,IMATUA      ,
     &                    IMAT5L      ,IMAT6U      ,
     &                    AC2OLD      ,CGO         ,
     &                    KWAVE       ,
     &                    SPCSIG      ,IDCMIN      ,
     &                    IDCMAX      ,AC2         ,
     &                    SECTOR      ,ITER        ,
     &                    IDTOT       ,ISTOT       ,
     &                    IDDLOW      ,IDDTOP      ,
     &                    ISSTOP      ,INOCNV      ,
     &                    QBLOC       ,ERRPTS      ,
     &                    IX          ,IY          ,
     &                    ITSW                                            30.72
     &                                             )
C
C****************************************************************
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     30.80: Nico Booij
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.72, Feb. 98: Modified argument list for update CGSTAB solver
C     34.01, Feb. 99: Introducing STPNOW
C     40.00, Feb. 99: swcomm3 introduced
C     30.80, July 99: call ISSOLV modified
C
C  2. Purpose
C
C     Solve the array in case of a current. A fully implicit scheme
C     in frequency and disrectional space is used.
C
C     The subroutines that solve this matrix have been provided
C     by Dr. C. Vuik from Delft University of Technology, the
C     Netherlands.
C
C        /                                         \
C       | 1  6        7  8  9        U             |
C       | 5  1  6        7  8  9        U          |
C       |    5  1  6        7  8  9        U       |
C       |       5  1  6        7  8  9        U    |
C       |          5  1  6        7  8  9        U |
C       | 4           5  1  6        7  8  9       |
C       | 3  4           5  1  6        7  8  9    |
C       | 2  3  4           5  1  6        7  8  9 |  * b = c
C       |    2  3  4           5  1  6        7  8 |
C       |       2  3  4           5  1  6        7 |
C       | L        2  3  4           5  1  6       |
C       |    L        2  3  4           5  1  6    |
C       |       L        2  3  4           5  1  6 |
C       |          L        2  3  4           5  1 |
C       \                                          /
C
C     In this model the diagonals: 1 , 3 , 5 , 6 , 8 , L and U
C     are used.
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     ITER  : input  Iteration counter for SWAN
C     ITSW  : input  Time step counter for SWAN
C
      INTEGER ITER,   ITSW                                                40.00
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C                    one sweep
C        IDTOT,ISTOT maximum range between the minimum and maximum
C                    counter in directional and frequency space
C                    respectively
C
C        REALS:
C        ---------
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C        CGO       2D    Group velocity
C        IDCMIN    1D    Integer array containing minimum counter
C        IDCMAX    1D    Integer array containing maximum counter
C        ANYBIN    2D    Logical array. if a certain bin is enclosed
C                        in a sweep then ANYBIN is TRUE . array is
C                        used to determine whether some coefficients
C                        in the array have to be changed
C        IMATDA    2D    Coefficients of diagonal of matrix
C        IMATLA    2D    Coefficients of lower diagonal of matrix
C        IMATUA    2D    Coefficients of upper diagonal of matrix
C        IMATRA    2D    Coefficients of right hand side of matrix
C        IMAT5L    2D    Coefficients for implicit calculation in
C                        frequency sapce (lower diagonal)
C        IMAT6U    2D    Coefficients for implicit calculation in
C                        frequency sapce (upper diagonal)
C        ANYBIN    2D    Logical array. if a certain bin is enclosed
C                        in a sweep then ANYBIN is TRUE . array is
C                        used to determine whether some coefficients
C                        in the array have to be changed
C        ARRAY           MATRIX
C        RHV             RIGHT-HAND SIDE
C        PRECON          PRECONDITIONER
C        SOLUT           ITERATIVE SOLUTION
C        WORK            WORK SPACE
C        EXACT           EXACT SOLUTION
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
      LOGICAL STPNOW                                                      34.01
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        The first dimension of array , WORK, PRECON should be > N
C        The dimension of EXACT, RHV, SOLUT should be > N
C        The dimension of UPPERI, LOPERI should be > MSC
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   End of SOLBAND
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
C     NX replaced by NSC (NX is a common variable)                        40.00
      INTEGER  IS      ,ID      ,NSC     ,I       ,                       40.00
     &         NTOT    ,NCONCT  ,NWORK   ,NPREC   ,IDDLOW  ,INOCNV  ,
     &         IDDTOP  ,IDTOT   ,ISTOT   ,ISSTOP  ,IDDUM   ,MSCMDC  ,
     &         ERRPTS                                                     30.50
C
      REAL     QBLOC                                                      40.00
C
      INTEGER  INFMAT(10)                   ,
     &         IINSOL(14)                   ,
     &         IDCMIN(MSC)                  ,
     &         IDCMAX(MSC)                  ,
     &         SECTOR(MSC)
C
      REAL     AC2(MDC,MSC,MCGRD)           ,
     &         IMATRA(MDC,MSC)              ,
     &         IMATLA(MDC,MSC)              ,
     &         IMATDA(MDC,MSC)              ,
     &         IMATUA(MDC,MSC)              ,
     &         IMAT5L(MDC,MSC)              ,
     &         IMAT6U(MDC,MSC)              ,
     &         BAND(MDC*MSC,9)              ,
     &         EXACT(MDC*MSC)               ,
     &         RHV(MDC*MSC)                 ,
     &         RINSOL(7)                    ,
     &         SOLUT(MDC*MSC)               ,
     &         WORK(MDC*MSC,10)             ,
     &         PRECON(MDC*MSC,9)            ,
     &         UPPERI(MSC)                  ,
     &         LOPERI(MSC)                  ,
     &         AC2OLD(MDC,MSC)              ,
     &         CGO(MSC,ICMAX)               ,
     &         KWAVE(MSC,ICMAX)
C
      LOGICAL  ANYBIN(MDC,MSC)   ,
     &         FILL
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SOLBAND')
C
C     *** ERROR on minimum values of SITOT and IDTOT ***
C
      IF (  ( ISTOT .LT. 4 .AND. IDTOT .LT. 3 ) .OR.
     &      ( ISTOT .LT. 3 .AND. IDTOT .LT. 4 ) ) THEN
        CALL MSGERR(3,'vector length too small for CGSTAB solver')        40.13
        WRITE(PRINTF,*) ' ISTOT=', ISTOT,'  IDTOT=', IDTOT,
     &  '  IX=', IXCGRD(1)-1, '  IY=', IYCGRD(1)-1                        40.13
      END IF
C
      DO IS = 1, ISSTOP
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF ( .NOT. ANYBIN(ID,IS) ) THEN
            IMATLA(ID,IS) = 0.
            IMATDA(ID,IS) = 1.
            IMATUA(ID,IS) = 0.
            IMATRA(ID,IS) = AC2(ID,IS,KCGRD(1))                           30.21
            IMAT5L(ID,IS) = 0.
            IMAT6U(ID,IS) = 0.
          END IF
        ENDDO
      ENDDO
C
C     *** to limit the growth rate in a bin the action density ***
C     *** is stored in a auxiliary array AC2OLD                ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          AC2OLD(ID,IS) = AC2(ID,IS,KCGRD(1))
        ENDDO
      ENDDO
C
C     *** Initialization ***
C
      DO I = 1, 14
         IINSOL(I) = 0
      ENDDO
      DO I = 1, 7
         RINSOL(I) = 0.
      ENDDO
C
      MSCMDC = MSC*MDC
      NTOT   = IDTOT * ISTOT
      NCONCT = 9
      NPREC  = 9
      NWORK  = 10*NTOT
C
C     *** Number of finite volumes in x-direction in NSC = (MSC-1) ***
C
      NSC = ISTOT - 1
C
C     *** set all values in arrays equal 0. ***
C
      DO I = 1, MSCMDC
        DO J = 1, 9
          BAND(I,J)   = 0.
          PRECON(I,J) = 0.
          WORK(I,J)   = 0.
        ENDDO
        WORK(I,10) = 0.
        EXACT(I)   = 0.
        RHV(I)     = 0.
        SOLUT(I)   = 0.
      ENDDO
C
      DO I = 1, MSC
        UPPERI(I) = 0.
        LOPERI(I) = 0.
      ENDDO
C
C     *** do not change the values below ***
C
C     infmat(1) = 4 represents the original equation (spectral plane)     30.80
C     infmat(1) = 5 represents the Poisson equation (setup)               30.80
      INFMAT(1) = 4
      INFMAT(2) = NSC
      INFMAT(4) = 0
C
      FILL = .TRUE.
      IF ( FILL ) THEN
C
C       *** fill solution array with value of previous iteration ***
C       *** in area from 1 to ISSTOP and IDDLOW to IDDTOP        ***
C
        DO IDDUM = IDDLOW, IDDTOP
          IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IDBAND = MOD ( IDDUM - IDDLOW , MDC ) + 1
          DO IS = 1, ISSTOP
            NPP = (IDBAND - 1) * ISSTOP + IS
            SOLUT(NPP)    = AC2(IDSWAN,IS,KCGRD(1))
          ENDDO
        ENDDO
C
C       *** fill arrays ***
C
        CALL VULMT1  (NTOT    ,BAND    ,UPPERI  ,LOPERI  ,RHV     ,
     &                IMATRA  ,IMATLA  ,IMATDA  ,IMATUA  ,IMAT5L  ,
     &                IMAT6U  ,SECTOR  ,MDC     ,MSC     ,IDDLOW  ,
     &                IDDTOP  ,ISSTOP  ,IDCMIN  ,IDCMAX  ,ANYBIN  ,
     &                IDTOT   ,KCGRD   ,ICMAX                     )       30.21
C
      ELSE
C
C       *** fill matrix with predefined coefficients to test     ***
C       *** the CGSTAB solver                                    ***
C
C       *** fill solution array with value of previous iteration ***
C
        DO IDDUM = IDDLOW, IDDTOP
          IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IDBAND = MOD ( IDDUM - IDDLOW , MDC ) + 1
          DO IS = 1, ISSTOP
            NPP = (IDBAND - 1) * ISSTOP + IS
            SOLUT(NPP)    = AC2(IDSWAN,IS,KCGRD(1))
            EXACT(IS)     = 1.                                            NRL
          ENDDO
        ENDDO
C
        CALL VULMAT (NTOT, NCONCT, BAND  , INFMAT , UPPERI, LOPERI )
C
C       *** calculate the right hand vector ***
C
        CALL DRUMA1 (EXACT ,RHV   ,BAND  ,NTOT   ,NCONCT,INFMAT,
     &               UPPERI,LOPERI                              )
C
      ENDIF
C
C     *** input for the solver which should not be changed ***
C
      IINSOL(1) = 1
      IINSOL(4) = 0
      IINSOL(5) = 0
      IINSOL(7) = 4
      IINSOL(8) = 6
C
C     *** input for the solver whoch may be changed            ***
C     *** IINSOL(2) determines the preconditioner              ***
C     *** Possible values                                      ***
C     ***   0   no preconditioner                              ***
C     ***  -1   diagonal preconditioner                        ***
C     ***  -3   ILU preconditioner (in general the best choice ***
C
C      IINSOL(2) = -3
      IINSOL(2) = INT( PNUMS(10) )
C
C     *** IINSOL(3) control parameter for the amount of output ***
C     *** possible values:                                     ***
C     ***     <0  : no output                                  ***
C     ***      0  : only fatal errors will be printed          ***
C     ***      1  : additional information about the iteration ***
C     ***           is printed                                 ***
C     ***      2  : gives a maximal amount of output           ***
C     ***           concerning the iteration process           ***
C
C      IINSOL(3) = 2
      IINSOL(3) = INT( PNUMS(13) )
C
C     *** IINSOL(6) maximal number of iteration to be performed ***
C     ***           in each of the solution methods             ***
C
C      IINSOL(6) = 20
       IINSOL(6) = INT( PNUMS(14) )
C
C     *** RINSOL(2) required accuracy, the iterative method stops ***
C     ***          IF ||R ||  < RINSOL(2) * ||R ||                ***
C     ***                K  2                  0  2               ***
C
C      RINSOL(2) = 1E-4
      RINSOL(1) = PNUMS(11)
      RINSOL(2) = PNUMS(12)
C
      CALL ISSOLV      (IINSOL  ,RINSOL  ,BAND    ,RHV     ,SOLUT   ,
     &                  NTOT    ,NCONCT  ,INFMAT  ,WORK    ,NWORK   ,
     &                  PRECON  ,NPREC   ,UPPERI  ,LOPERI  ,INOCNV  ,
     &                  ITSW    ,ITER    )                                30.72
      IF (STPNOW()) RETURN                                                34.01
C
C     *** fill action density array with solution obtained from ***
C     *** iterative Bi-CGSTAB solver                            ***
C
      DO IDDUM = IDDLOW, IDDTOP
        IDSWAN = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        IDBAND = MOD ( IDDUM - IDDLOW  , MDC ) + 1
        DO IS = 1, ISSTOP
          IF ( ANYBIN(IDSWAN,IS) ) THEN
            NPP = (IDBAND - 1) * ISSTOP + IS
            AC2(IDSWAN,IS,KCGRD(1)) = SOLUT(NPP)
          END IF
        ENDDO
      ENDDO
C
C      *** set all the coefficients in the arrays 0 ***
C
      DO 220 IS = 1, MSC
        DO 210 ID = 1, MDC
          IMATRA(ID,IS) = 0.
          IMATLA(ID,IS) = 0.
          IMATDA(ID,IS) = 0.
          IMATUA(ID,IS) = 0.
          IMAT5L(ID,IS) = 0.
          IMAT6U(ID,IS) = 0.
 210    CONTINUE
 220  CONTINUE
C
C     Test output
C
      IF ( TESTFL .AND. ITEST.GE. 80 ) THEN
        WRITE (PRINTF,6020) KCGRD(1), ITER, PNUMS(20)                     40.00
 6020   FORMAT(' SOLBAND: POINT ITER GRWM:',2I5,E12.4)                    40.00
        WRITE (PRINTF,7022) QBLOC,IQUAD
 7022   FORMAT(' SOLBAND: QBLOC IQUAD         :',E12.4,I4)
        WRITE(PRINTF,*)
      END IF
C
C     End of the subroutine SOLBAND
C
      RETURN
      END
C****************************************************************
C
      SUBROUTINE SOLMAT (IDCMIN     ,IDCMAX     ,                         40.00
     &                   AC2        ,IMATRA     ,
     &                   IMATDA     ,IMATUA     ,
     &                   IMATLA     ,AC2OLD     ,
     &                   KWAVE      ,CGO        ,
     &                   SPCSIG     ,QBLOC
     &                                           )
C
C****************************************************************
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, Feb. 99: swcomm3 introduced
C
C  2. Purpose
C
C     SUBROUTINE to solve the matrix which is filled in the
C     subroutine ACTION. The solutions give the values for the
C     wave action for every frequency and every direction.
C     The matrices are solved by using the Thomas sweep algorithm
C     in the spectral direction only
C
C  3. Method
C
C     Solver for tridiagonal matrix:  A x = b
C
C                         /   \
C       / 2  3          \ |   |
C       | 1  2  3       | |   |
C       |    1  2  3    | | x | = b = RHV
C       |       1  2  3 | |   |
C       \          1  2 / |   |
C                         \   /
C
C     The maximum change of energy density per bin is
C     related to the PM equilibrium level. For shallow water this
C     level is estimated as :
C
C       DEmax(s) = factor * 0.0081 * grav**2 / (sigma**5)
C
C     In SWAM factor = 0.1  This, however, is a
C     measure for a 1-D spectrum. For a 2-D spectrum with a
C     cos**2(theta) directional distribution, the max. change becomes :
C
C       DEmax(s) = 2. * factor * 0.0081 * grav**2 / (sigma**5 * PI)
C
C     is terms of action density :  A(s) = E(s) / sigma
C
C       DAmax(s) = 2. * factor * 0.0081 * grav**2 / (sigma**6 * PI)
C
C     rewritten :
C
C       DAmax(s) = 0.496253 * factor / sigma**6
C
C     in terms of wave number this becomes, with a deep water
C     approach:   s**4 = g**2 * k**2
C
C       DEmax(s) = 2. * factor * 0.0081 * / ( s * k**2 * pi )  -->
C
C       with : s =  CGO* K / N   -->  deep water N = 1/2    -->
C
C       DEmax(s) =  factor * 0.0081 * / ( CG * k**3 * pi )  -->
C
C       DAmax(s) =  factor * 0.0081 * / ( CG * k**3 * pi * sigma)
C
C     This last equation has been implemented
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     IX          Counter of gridpoints in x-direction
C     IY          Counter of gridpoints in y-direction
C     IS          Counter of relative frequency band
C     ID          Counter of directional distribution
C     J           Dummy counter
C     MXC         Maximum counter of gridppoints in x-direction
C     MYC         Maximum counter of gridppoints in y-direction
C     MSC         Maximum counter of relative frequency
C     MDC         Maximum counter of directional distribution
C
C     REALS:
C     ---------
C
C     SP          Dummy variable
C     TEMP        Dummy variable
C
C     one and more dimensional arrays:
C     ---------------------------------
C     AC2       4D    Action density as function of D,S,X,Y and T
C     IMATDA    2D    Coefficients of diagonal of matrix
C     IMATLA    2D    Coefficients of lower diagonal of matrix
C     IMATUA    2D    Coefficients of upper diagonal of matrix
C     IMATRA    2D    Coefficients of right hand side of matrix
C     CGO       2D    Group velocity
C     IDCMIN    1D    Integer array containing minimum counter
C     IDCMAX    1D    Integer array containing maximum counter
C
C  8. Subroutines used
C
C     ---
C
C  9. Subroutines calling
C
C     SWOMPU
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     -------------------------------------------------------------
C     Set all the values in the arrays 0
C     IMATRA(MDC,MSC), IMATLA(MDC,MSC),IMATDA(MDC,MSC),IMATUA(MDC,MSC)
C     -------------------------------------------------------------
C     For every D-direction within the sector do,
C       Eliminate the lower diagonal
C     -------------------------------------------------------------
C     For every D-direction within the sector do,
C       Eliminate the upper diagonal
C     -------------------------------------------------------------
C     For every D-direction within the sector do,
C       Solve the linear equation to get the wave action for every
C       direction (ID)
C       ------------------------------------------------------------
C       Compute the dissipation in the last iteration
C     ------------------------------------------------------------
C
C 13. Source text
C
C
      INTEGER  IS      ,ID      ,J       ,ID_MIN  ,ID_MAX                 40.00
C
      REAL     SP      ,TEMP    ,QBLOC                                    40.00
C
      REAL     AC2(MDC,MSC,MCGRD)           ,
     &         AC2OLD(MDC,MSC)              ,
     &         CGO(MSC,ICMAX)               ,
     &         KWAVE(MSC,ICMAX)             ,
     &         IMATRA(MDC,MSC)              ,
     &         IMATLA(MDC,MSC)              ,
     &         IMATDA(MDC,MSC)              ,
     &         IMATUA(MDC,MSC)
C
      INTEGER  IDCMIN(MSC)        ,
     &         IDCMAX(MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SOLMAT')
C
C     **** 17/JAN   IN MOD (  , ) ;   + MDC WAS ADDED ****
C
      DO 180 IS = 1, MSC
        ID_MIN = IDCMIN(IS)                                               3/MAR
        ID_MAX = IDCMAX(IS)                                               3/MAR
C
C       *** elimination of the lower diagonal of the first matrix ***
C
        DO 100 IDDUM = (ID_MIN+1), ID_MAX                                 20.43
          ID   = MOD(IDDUM-1+MDC, MDC) + 1                                17/JAN
          IDM1 = MOD(IDDUM-2+MDC, MDC) + 1                                17/JAN
          SP   = IMATDA(IDM1,IS)                                          20.43
          IF ( ABS(SP) .LE. 1.E-20 ) THEN
            TEMP = IMATLA(ID,IS) / SIGN( 1.E-20 , SP)
          ELSE
            TEMP = IMATLA(ID,IS) / SP
          END IF
          IMATDA(ID,IS) = IMATDA(ID,IS) - TEMP * IMATUA(IDM1,IS)          20.43
          IMATRA(ID,IS) = IMATRA(ID,IS) - TEMP * IMATRA(IDM1,IS)          20.43
 100    CONTINUE
C
C       *** solving of the linear equations for the wave action ***
C
C       *** first for ID_MAX, then for the others ***
C
        ID   = MOD(ID_MAX-1+MDC, MDC) + 1                                 17/JAN
        SP = IMATDA(ID,IS)
        IF ( ABS(SP) .LE. 1.E-20 ) THEN
          TEMP = SIGN (1.E-20 , SP)
        ELSE
          TEMP = SP
        END IF
C
C       *** wave action for ID_MAX ***
C
        AC2(ID,IS,KCGRD(1)) = IMATRA(ID,IS) / TEMP
C
        DO 150 J = 1, (ID_MAX-ID_MIN)
          ID   = MOD(ID_MAX-J-1+MDC, MDC) +1                              17/JAN
          IDP1 = MOD(ID_MAX-J+MDC, MDC) +1                                17/JAN
          SP = IMATDA(ID,IS)
          IF ( ABS(SP) .LE. 1.E-20 ) THEN
            TEMP = SIGN (1.E-20 , SP)
          ELSE
            TEMP = SP
          END IF
          AC2(ID,IS,KCGRD(1)) = ( IMATRA(ID,IS) - IMATUA(ID,IS) *
     &                        AC2(IDP1,IS,KCGRD(1)) ) / TEMP                 20.
C
 150    CONTINUE
C
        IF ( ITEST .GE. 120 .AND. TESTFL ) THEN
          WRITE(PRINTF,6009) KCGRD(1),ID_MIN,ID_MAX
 6009     FORMAT(' SOLMAT: POINT ID_MIN ID_MAX :',3I5)
          DO 169 IDDUM = ID_MIN, ID_MAX
            ID = MOD(IDDUM-1+MDC, MDC) + 1                                17/
            WRITE (PRINTF,6010) IS,ID,AC2(ID,IS,KCGRD(1))
 6010       FORMAT(' IS ID AC2()         :',2I5,2X,E12.4)
 169      CONTINUE
        END IF
C
 180  CONTINUE
C
C
C     *** set all the coefficients in the arrays 0 ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          IMATRA(ID,IS) = 0.
          IMATLA(ID,IS) = 0.
          IMATDA(ID,IS) = 0.
          IMATUA(ID,IS) = 0.
        ENDDO
      ENDDO
C
C     *** Compute the total energy dissipation      ***
C     *** note : this part has still to be computed ***
C
      IF ( TESTFL .AND. ITEST.GE. 40 ) THEN
        WRITE (PRINTF,6020) IXCGRD(1)-1, IYCGRD(1)-1
 6020   FORMAT(' SOLMAT: point :',2I5)
        WRITE(PRINTF,*)
      END IF
C
C     End of the subroutine SOLMAT
C
      RETURN
      END
C
C****************************************************************
C
      SUBROUTINE SOLMT1 (IDCMIN     ,IDCMAX     ,                         40.00
     &                   AC2        ,IMATRA     ,
     &                   IMATDA     ,IMATUA     ,
     &                   IMATLA     ,AC2OLD     ,
     &                   KWAVE      ,CGO        ,
     &                               SPCSIG     ,                         30.72
     &                   SECTOR     ,ICOLU2     ,
     &                   ANYBIN     ,QBLOC      ,
     &                               ISSTOP     ,
     &                   ANYBLK     ,IDDLOW     ,
     &                   IDDTOP              )
C
C****************************************************************
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.00, Feb. 99: swcomm3 introduced
C
C  2. Purpose
C
C     SUBROUTINE to solve the matrix which is filled in the
C     subroutine ACTION. The solutions give the values for the
C     wave action for every frequency and every direction.
C     The matrices are solved by using the Thomas sweep algorithm
C     in the spectral direction only
C
C  3. Method
C
C     solver for tridiagonal matrix with a possible coefficient
C     at the bottom left position and top right position
C
C                          /   \
C        / 2  3        1 \ |   |
C        | 1  2  3       | |   |
C        |    1  2  3    | | b | =  RHV
C        |       1  2  3 | |   |
C        \ 3        1  2 / |   |
C                          \   /
C
C     The maximum change of energy density per bin is
C     related to the PM equilibrium level. For shallow water this
C     level is estimated as :
C
C       DEmax(s) = factor * 0.0081 * grav**2 / (sigma**5)
C
C     In SWAM factor = 0.1  This, however, is a
C     measure for a 1-D spectrum. For a 2-D spectrum with a
C     cos**2(theta) directional distribution, the max. change becomes :
C
C       DEmax(s) = 2. * factor * 0.0081 * grav**2 / (sigma**5 * PI)
C
C     is terms of action density :  A(s) = E(s) / sigma
C
C       DAmax(s) = 2. * factor * 0.0081 * grav**2 / (sigma**6 * PI)
C
C     rewritten :
C
C       DAmax(s) = 0.496253 * factor / sigma**6
C
C     in terms of wave number this becomes, with a deep water
C     approach:   s**4 = g**2 * k**2
C
C       DEmax(s) = 2. * factor * 0.0081 * / ( s * k**2 * pi )  -->
C
C       with : s =  CG * K / N   -->  deep water N = 1/2    -->
C
C       DEmax(s) =  factor * 0.0081 * / ( CG * k**3 * pi )  -->
C
C       DAmax(s) =  factor * 0.0081 * / ( CG * k**3 * pi * sigma)
C
C     This last equation has been implemented
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C        IX          Counter of gridpoints in x-direction
C        IY          Counter of gridpoints in y-direction
C        IS          Counter of relative frequency band
C        ID          Counter of directional distribution
C        J           Dummy counter
C        MXC         Maximum counter of gridppoints in x-direction
C        MYC         Maximum counter of gridppoints in y-direction
C        MSC         Maximum counter of relative frequency
C        MDC         Maximum counter of directional distribution
C
C        REALS:
C        ---------
C
C        SP          Dummy variable
C        TEMP        Dummy variable
C
C        one and more dimensional arrays:
C        ---------------------------------
C        AC2       4D    Action density as function of D,S,X,Y and T
C        IMATDA    2D    Coefficients of diagonal of matrix
C        IMATLA    2D    Coefficients of lower diagonal of matrix
C        IMATUA    2D    Coefficients of upper diagonal of matrix
C        IMATRA    2D    Coefficients of right hand side of matrix
C        CGO       2D    Group velocity
C        IDCMIN    1D    Integer array containing minimum counter
C        IDCMAX    1D    Integer array containing maximum counter
C        SECTOR    1D    sectors inclosed in a sweep.
C        ANYBIN    2D    Logical array. if a certain bin is enclosed
C                        in a sweep then ANYBIN is TRUE . array is
C                        used to determine whether some coefficients
C                        in the array have to be changed
C        ICOLU2    1D    auxiliary array for storing the coefficients
C                        in the last column
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   Set all the values in the arrays 0
C   IMATRA(MDC,MSC), IMATLA(MDC,MSC),IMATDA(MDC,MSC),IMATUA(MDC,MSC)
C   -------------------------------------------------------------
C   For every D-direction within the sector do,
C     Eliminate the lower diagonal
C   -------------------------------------------------------------
C   For every D-direction within the sector do,
C     Eliminate the upper diagonal
C   -------------------------------------------------------------
C   For every D-direction within the sector do,
C     Solve the linear equation to get the wave action for every
C     direction (ID)
C     ------------------------------------------------------------
C     Compute the dissipation in the last iteration
C   ------------------------------------------------------------
C   End of SOLMT1
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  IS     ,ID     ,J      ,IDDUM  ,IIDM   ,
     &         IIDP   ,ISSTOP ,IDDTOP ,IDDLOW                             40.00
C
      REAL     SP     ,TEMP   ,CORMAT ,TEMP1  ,QBLOC                      40.00
C
      REAL     AC2(MDC,MSC,MCGRD)           ,                             30.21
     &         AC2OLD(MDC,MSC)              ,
     &         CGO(MSC,ICMAX)               ,
     &         KWAVE(MSC,ICMAX)             ,
     &         IMATRA(MDC,MSC)              ,
     &         IMATLA(MDC,MSC)              ,
     &         IMATDA(MDC,MSC)              ,
     &         IMATUA(MDC,MSC)              ,
     &         ICOLU2(MDC)
C
      INTEGER  IDCMIN(MSC)                  ,
     &         IDCMAX(MSC)                  ,
     &         SECTOR(MSC)
C
      LOGICAL  ANYBIN(MDC,MSC)    ,
     &         ANYBLK(MDC,MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SOLMT1')
C
C     *** if explcit scheme is used and CFL exeeds CFL max ***
C     *** then bin should not be propagated within a sweep ***
C
      DO IS = 1, ISSTOP
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF ( ANYBLK(ID,IS) ) THEN
            IMATLA(ID,IS) = 0.
            IMATDA(ID,IS) = 1.
            IMATUA(ID,IS) = 0.
            IMATRA(ID,IS) = 0.
          END IF
        ENDDO
      ENDDO
C
C     *** start proces of elimination ***
C
      DO 180 IS = 1, MSC
C
        IF ( SECTOR(IS) .GT. 0 ) THEN
C
C         *** set values in auxiliary array for last ***
C         ***column equal zero                       ***
C
          DO ID = 1, MDC
           ICOLU2(ID) = 0.
          ENDDO
C
C         *** if SECTOR(IS) = 4 then four sectors are enclosed.     ***
C         *** change the coefficients in the matrix for those       ***
C         *** rows for which the array if ANYBIN(IS,ID)             ***
C         *** is FALSE                                              ***
C
          IF ( SECTOR(IS) .EQ. 4 ) THEN
            DO 650 ID = 1, MDC
              IF ( .NOT. ANYBIN(ID,IS) ) THEN
                IMATLA(ID,IS) = 0.
                IMATDA(ID,IS) = 1.
                IMATUA(ID,IS) = 0.
                IMATRA(ID,IS) = AC2(ID,IS,KCGRD(1))
              END IF
 650        CONTINUE
          END IF
C
          IDLOW     = IDCMIN(IS)
          IDTOP     = IDCMAX(IS)
C
C         *** set values in coefficients in left bottom element ***
C         *** and right top element. Situation only occurs if   ***
C         *** the matrix is solved for all directions           ***
C
          IF ( IDLOW .EQ. 1  .AND.  IDTOP .EQ. MDC ) THEN
            CORMAT    = IMATUA(MDC,IS)
            ICOLU2(1) = IMATLA(1,IS)
          ELSE
            CORMAT    = 0.
            ICOLU2(1) = 0.
          END IF
C
C         *** elimination of the lower diagonal of the first matrix ***
C
          DO 100 IDDUM = (IDLOW+1 ), IDTOP
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IIDM = MOD ( IDDUM - 2 + MDC , MDC ) + 1
            SP = IMATDA(IIDM,IS)
            IF ( ABS(SP) .LE. 1.E-20 ) THEN
              TEMP = IMATLA(ID,IS) / SIGN( 1.E-20 , SP)
              TEMP1 = CORMAT / SIGN(1.E-20 , SP)
            ELSE
              TEMP = IMATLA(ID,IS) / SP
              TEMP1 = CORMAT / SP
            END IF
            IMATDA(ID,IS)  = IMATDA(ID,IS)  - TEMP * IMATUA(IIDM,IS)
            IMATRA(ID,IS)  = IMATRA(ID,IS)  - TEMP * IMATRA(IIDM,IS)
            IMATRA(IDTOP,IS) = IMATRA(IDTOP,IS) - TEMP1 *
     &                          IMATRA(IIDM,IS)
            CORMAT = 0. - TEMP1 * IMATUA(IIDM,IS)
C
            IF ( IDDUM .LT. (IDTOP-1) ) THEN
              ICOLU2(ID) =  - TEMP * ICOLU2(IIDM)
            ELSE
              IMATUA(ID,IS) = IMATUA(ID,IS) - TEMP * ICOLU2(IIDM)
            END IF
            IF ( IDDUM .LT. IDTOP ) THEN
              IMATDA(IDTOP,IS) = IMATDA(IDTOP,IS) - TEMP1 *
     &                            ICOLU2(IIDM)
            ELSE
              IMATDA(IDTOP,IS) = IMATDA(IDTOP,IS) - TEMP1 *
     &                            IMATUA(IIDM,IS)
            END IF
C
 100      CONTINUE
C
C         *** solving of the linear equations for the wave action ***
C
C         *** first for IDTOP, then for the others ***
C
          SP = IMATDA(IDTOP,IS)
          IF ( ABS(SP) .LE. 1.E-20 ) THEN
            TEMP = SIGN (1.E-20 , SP)
          ELSE
            TEMP = SP
          END IF
C
C         *** wave action for IDCMAX ***
C
          AC2(IDTOP,IS,KCGRD(1)) = IMATRA(IDTOP,IS) / TEMP
C
          DO 150 J = 1, (IDTOP-IDLOW)
            IDDUM = IDTOP - J
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IIDP = MOD ( IDDUM + MDC , MDC ) + 1
            SP = IMATDA(ID,IS)
            IF ( ABS(SP) .LE. 1.E-20 ) THEN
              TEMP = SIGN (1.E-20 , SP)
            ELSE
              TEMP = SP
            END IF
            AC2(ID,IS,KCGRD(1)) = ( IMATRA(ID,IS) - IMATUA(ID,IS) *       30.21
     &                        AC2(IIDP,IS,KCGRD(1)) - ICOLU2(ID)  *
     &                        AC2(IDTOP,IS,KCGRD(1)) ) / TEMP
 150      CONTINUE
C
C         *** extended info for SOLMT1 ***
 
          IF ( ITEST .GE. 13 .AND. TESTFL ) THEN
            WRITE(PRINTF,*) 'SOLMT1'
            WRITE(PRINTF,*) ' matrix coefficients after pivoting '
            WRITE(PRINTF,*)
            WRITE(PRINTF,*)
     &   'ID IDDUM IMATLA      IMATDA      IMATUA     ICOLU2    IMATRA'
            DO 2100 IDDUM = IDLOW, IDTOP
              ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
              WRITE(PRINTF,2101) ID, IDDUM,IMATLA(ID,IS),IMATDA(ID,IS),
     &                         IMATUA(ID,IS),ICOLU2(ID),IMATRA(ID,IS)
2101          FORMAT(2I3,5E12.4)
2100        CONTINUE
            WRITE(PRINTF,*)
            DO 2010 IDDUM = IDLOW, IDTOP
              ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
              WRITE (PRINTF,6010) IS,ID,AC2(ID,IS,KCGRD(1))
 6010         FORMAT(' IS ID and resolved vector  :',2I5,2X,E12.4)
 2010       CONTINUE
            WRITE(PRINTF,*)
          END IF
        END IF
 180  CONTINUE
C
C     *** set all the coefficients in the arrays 0 ***
C
      DO IS = 1, MSC
        DO ID = 1, MDC
          IMATRA(ID,IS) = 0.
          IMATLA(ID,IS) = 0.
          IMATDA(ID,IS) = 0.
          IMATUA(ID,IS) = 0.
          ICOLU2(ID)    = 0.
        ENDDO
      ENDDO
C
C     End of the subroutine SOLMT1
C
      RETURN
      END
C
C****************************************************************
C
        SUBROUTINE SOURCE (ITER       ,IX         ,IY         ,
     &                     SWPDIR     ,KWAVE      ,SPCSIG     ,           30.72
     &                     ECOS       ,ESIN       ,AC2        ,
     &                     DEP2       ,IMATDA     ,IMATRA     ,
     &                     ABRBOT     ,KMESPC     ,SMESPC     ,
     &                     UBOT       ,UFRIC      ,UX2        ,
     &                     UY2        ,IDCMIN     ,IDCMAX     ,
     &                     IDDLOW     ,IDDTOP     ,IDWMIN     ,
     &                     IDWMAX     ,ISSTOP     ,PLWNDA     ,
     &                     PLWNDB     ,PLWCAP     ,PLBTFR     ,
     &                     PLWBRK     ,PLNL4S     ,PLNL4D     ,
     &                     PLTRI      ,            HS         ,           40.22
     &                     ETOT       ,QBLOC      ,THETAW     ,
     &                     HM         ,FPM        ,WIND10     ,
     &                     ETOTW      ,GROWW      ,ALIMW      ,
     &                     SMEBRK     ,SNLC1      ,FACHFR     ,
     &                     DAL1       ,DAL2       ,DAL3       ,
     &                     AF11       ,UE         ,SA1        ,
     &                     SA2        ,DA1C       ,DA1P       ,
     &                     DA1M       ,DA2C       ,DA2P       ,
     &                     DA2M       ,SFNL       ,DSNL       ,
     &                     MEMNL4     ,WWINT      ,WWAWG      ,
     &                     WWSWG      ,CGO        ,USTAR      ,
     &                     ZELEN      ,SPCDIR     ,ANYWND     ,
     &                     DISSC0     ,DISSC1     ,SZEROC     ,
     &                     EPS2WC     ,DISWCP     ,WCPSME     ,
     &                     WCPKME     ,WCPQB      ,WCPHM      ,
     &                     XIS        ,FRCOEF     ,IT         ,           30.00
     &                     PRECOR     ,URSELL                             40.03
     &                                                        )           30.21
C
C****************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     32.06: Roeland Ris
C     40.02: IJsbrand Haagsma
C     40.03: Nico Booij
CQUADC     40.10: IJsbrand Haagsma (Quadruplet interface)
C     40.12: IJsbrand Haagsma
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     20.72, Jan. 96: Common introduced
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description several variables
C     32.06, June 99: Updated argument list of WNDPAR
C     30.81, Sep. 99: Updated argument list of SSURF
CQUADC     40.10, Oct. 99: Introduced Quadruplet interface
C     40.03, Apr. 00: array Ursell added in argument list
C     40.02, Sep. 00: Replaced SWCAP1-5 by SWCAP
C     40.02, Oct. 00: References to CDRAGP and TAUWP removed
C     40.12, Nov. 00: Added WCAP to dissipation output (bug fix 40.11 A)
!     40.22, Sep. 01: Removed WAREA array.                                40.22
!     40.22, Sep. 01: Changed array definitions to use the parameter      40.22
!                     MICMAX instead of ICMAX.                            40.22
C
C  2. Purpose
C
C     to compute the source terms, i.e., bottom firction,
C     wave breaking, wind input, white capping and non linear
C     wave wave interactions
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C i   ECOS  : =SPCDIR(*,2); cosine of spectral directions
C i   ESIN  : =SPCDIR(*,3); sine of spectral directions
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    ECOS(MDC)
      REAL    ESIN(MDC)
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C     INTEGERS:
C     --------------------------------------------------------------
C     IS       Counter of relative frequency band
C     IBOT     Indicator for bottom friction
C     ICUR     Indicator for current
C     ISURF    Indicator for wave breaking
C     ITRIAD   Indicator for nonlinear triad interactions
C     IQUAD    Indicator for nonlinear quadruplet interactions
C     IWCAP    Indicator for wave capping
C     IWIND    Indicator for which wind generation model is used
C     ICMAX    Maximum array size for the points of the molecul
C     MSC      Maximum counter of relative frequency in
C              computational model
C     MDC      Maximum counter of directional distribution in
C              computational model (2PI / DDIR + 1)
C     MTC      Maximum counter of the time, i.e.:
C              (total time in proto type) / (time step)
C     MBOT     Maximum array size for PBOT
C     MSURF    Maximum array size for PSSURF
C     MTRIAD   Maximum array size for PTRIAD
C     MWCAP    Maximum array size for PWCAP
C     MWIND    Maximum array size for PWIND
C     ISSTOP   Max frequency that is propagated within a sweep
C
C     REALS:
C     --------
C
C     DS          Width of frequency band (is not constant because
C                 of the logharitmic distribution of the frequency
C                 direction of the sweep (+1. OR -1. ) no input
C     GRAV        Gravitational acceleration
C     PI          3.141592654
C     ABRBOT      Near bottom excursion amplitude
C     EMAX        Maximum energy according to the depth and the
C                 breaker parameter
C     ETOT        Total energy density per gridpoint
C     ETOTW       Total energy of the wind sea spectrum
C     GRAV        Gravetational acceleration
C     HM          Maximum wave height
C     KMESPC      Mean average wavenumber over full spectrum
C     SMESPC      Mean average frequency over full spectrum
C     QBLOC       Fraction of breaking waves
C
C     one and more dimensional arrays:
C     ---------------------------------
C
C     AC2       4D    (Nonstationary case) action density as function
C                     of D,S,X,Y at time T+DT
C     DEP2      2D    (Nonstationary case) depth as function of X and Y
C                     at time T+DIT
C     ECOS      1D    Represent the values of cos(d) of each spectral
C                     direction
C     ESIN      1D    Represent the values of sin(d) of each spectral
C                     direction
C     ALIMW     1D    Maximum energy by wind growth.
C     IMATDA    2D    Coefficients of diagonal of matrix
C     IMATLA    2D    Coefficients of lower diagonal of matrix
C     IMATUA    2D    Coefficients of upper diagonal of matrix
C     IMATRA    2D    Coefficients of right hand side of matrix
C     KWAVE     2D    wavenumber as function of the relative frequency S
C                     and position IC(ix,iy)
C     PBOT      1D    Coefficient for the bottom friction models
C     PSURF     1D    Coefficient for the wave breaking model
C     PTRIAD     1D    Coefficient for the triad interaction model
C     PWCAP     1D    Coefficient for the white capping model
C     PWIND     1D    Coefficient for the wind growth model
C     UBOT      2D    Absolute orbital velocity in a gridpoint (IX,IY)
C     UX2       2D    (Nonstationary case) X-component of current velocity
C                     in (X,Y) at time T+DIT
C     UY2       2D    (Nonstationary case) Y-component of current velocity
C                     in (X,Y) at time T+DIT
C     USTAR     2D    Friction velocity at previous iteration for
C                     Janssen (1989,1990) wind input formulation
C     ZELEN     2D    Roughness length at previous iteration for
C                     Janssen (1989,1990) wind input formulation
C
C     Coefficients for the arrays:
C     -----------------------------
C                         default
C                         value:
C
C     PBOT(1)   = CFC      0.005    (Putnam and Collins equation)
C     PBOT(2)   = CFW      0.01     (Putnam and Collins equation)
C     PBOT(3)   = GAMJNS   0.0038   (Jonswap equation)
C     PBOT(4)   = MF      -0.08     (Madsen et al. equation)
C     PBOT(5)   = KN       0.05     (Madsen et al. bottom roughness)
C
C     PNUMS(*)  =
C
C     PSURF(1)  = ALFA     1.0      (Battjes & Janssen, 1978)
C     PSURF(2)  = GAMMA    0.8      (Breaking criterium)
C
C     PWCAP(1)  = ALFAWC   2.36e-5  (Emperical coefficient)
C     PWCAP(2)  = ALFAPM   3.02E-3  (Alpha of Pierson Moskowitz frequency)
C     PWCAP(3)  = CFJANS   4.5
C     PWCAP(4)  = DELTA    0.5
C     PWCAP(5)  = CFLHIG   1.
C     PWCAP(6)  = GAMBTJ   0.88     (Steepness limited wave breaking )
C
C     PWIND(1)  = CF10     188.0    (second generation wind growth model)
C     PWIND(2)  = CF20     0.59     (second generation wind growth model)
C     PWIND(3)  = CF30     0.12     (second generation wind growth model)
C     PWIND(4)  = CF40     250.0    (second generation wind growth model)
C     PWIND(5)  = CF50     0.0023   (second generation wind growth model)
C     PWIND(6)  = CF60    -0.2233   (second generation wind growth model)
C     PWIND(7)  = CF70     0.       (second generation wind growth model)
C     PWIND(8)  = CF80    -0.56     (second generation wind growth model)
C     PWIND(9)  = RHOAW    0.00125  (density air / density water)
C     PWIND(10) = EDMLPM   0.0036   (limit energy Pierson Moskowitz)
C     PWIND(11) = CDRAG    0.0012   (drag coefficient)
C     PWIND(12) = UMIN     1.0      (minimum wind velocity)
C     PWIND(13) = PMLM     0.13     (  )
C
C     arrays for Janssen (`89)
C     -----------
C     PWIND(14) 1D    alfa (which is tuned at 0.01)
C     PWIND(15) 1D    Kappa ( 0.41)
C     PWIND(16) 1D    Rho air (1.32)
C     PWIND(17) 1D    Rho water (1025)
C
C  6. Local variables
C
CQUADC     IQERR : Error indicator for SWANQUAD interface                      40.10
CQUADC
CQUAD      INTEGER IQERR                                                       40.10
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        SBOT    ,SSURF   ,SWIND1 ,SWIND2 ,SWIND3 ,SWIND4,
C        SWCAP   ,                                                        40.02
C        SWSNL1  ,SWSNL2  ,SWSNL3 ,
C        STRIAD
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C
C     9. STRUCTURE
C
C   ------------------------------------------------------------
C   If SBOT is on (IBOT > 1 ) then,
C     Call SBOT  to compute the source terms due to bottom friction
C      according to Hasselmann et al. (1974), Putnam and Jonsson (1949)
C      or Madsen et al. (1991)
C   ------------------------------------------------------------
C   If SSURF is on (ISURF > 1 ) then,
C     Call SSURF to compute the source terms due to wave breaking
C       according to Battjes and Janssen (1978)
C   ------------------------------------------------------------
C   IF IWIND =1 OR IWIND =2 THEN
C     Call WNDPAR (first or second generation first guess of the spectrum  RR
C                  using the DOLPHIN-B formulations)                       RR
C
C   else if IWIND = 3 then
C     input source term according to Snyder (1981)
C     Call SWIND3
C   else if IWIND = 4 then
C     input source term according to Janssen (1989,1991)
C     Call SWIND4
C   else if IWIND = 5 then
C     input source term according to Yan (1989) [reduces to snyder form
C     for low frequencies and to Plant's (19??) form for high freq.
C     Call SWIND5
C   ------------------------------------------------------------
C   If IWCAP > 1 then
C     Call SWCAP to compute the source term for white capping             40.02
C   ---------------------------------------------------------------------
C   If STRIAD is on (ITRIAD = 1 ) then,                                   30.80
C   Then Call STRIAN to compute the nonlinear 3 wave-wave interactions
C        according to Eldeberky and Battjes (1995)
C   ---------------------------------------------------------------------
C   If triads are not active                                              30.80
C   Then If Squad is on (IQUAD = 1 )
C        Then Call SWSNL1  to compute the nonlinear 4-wave interactions
C             semi implicit per sweep direction
C        Else if IQUAD = 2
C        Then Call SWSNL2   to compute the nonlinear 4-wave interactions
C             fully explicit per sweep direction
C        Else if IQUAD = 3
C        Then Call SWSNL3   to compute the nonlinear 4-wave interactions
C             fully explicit per iteration
C             Call FILNL3   Get values for interactions from array
C             for full circle
C   ---------------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
      INTEGER  ITER    ,IDWMIN  ,IDWMAX  ,SWPDIR  ,ISSTOP  ,
     &         IDDTOP  ,IDDLOW  ,IX      ,IY
C
      REAL     ABRBOT  ,ETOT    ,HM      ,QBLOC   ,ETOTW   ,
     &         FPM     ,WIND10  ,THETAW  ,SMESPC  ,KMESPC  ,
     &         SNLC1   ,FACHFR  ,DAL1    ,DAL2    ,DAL3    ,
     &         UFRIC   ,SMEBRK  ,HS      ,SZEROC  ,EPS2WC  ,
     &         DISWCP  ,WCPQB   ,WCPHM   ,WCPSME  ,WCPKME  ,
     &         XIS
C
      LOGICAL  PRECOR                                                     30.01
C
      REAL  :: AC2(MDC,MSC,MCGRD)                                         30.21
      REAL  :: DEP2(MCGRD)
      REAL  :: ALIMW(MDC,MSC)
      REAL  :: IMATDA(MDC,MSC)
      REAL  :: IMATRA(MDC,MSC)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  :: KWAVE(MSC,MICMAX)                                          40.22
      REAL  :: UBOT(MCGRD)
      REAL  :: UX2(MCGRD)
      REAL  :: UY2(MCGRD)
      REAL  :: AF11(MSC4MI:MSC4MA )
      REAL  :: UE(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: SA1(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: SA2(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA1C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA1P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA1M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA2C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA2P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DA2M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: SFNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: DSNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )
      REAL  :: MEMNL4(MDC,MSC,MCGRD)
      REAL  :: PLWNDA(MDC,MSC,NPTST)
      REAL  :: PLWNDB(MDC,MSC,NPTST)
      REAL  :: PLWCAP(MDC,MSC,NPTST)
      REAL  :: PLBTFR(MDC,MSC,NPTST)
      REAL  :: PLWBRK(MDC,MSC,NPTST)
      REAL  :: PLNL4S(MDC,MSC,NPTST)
      REAL  :: PLNL4D(MDC,MSC,NPTST)
      REAL  :: PLTRI(MDC,MSC,NPTST)
      REAL  :: WWAWG(*)
      REAL  :: WWSWG(*)
      REAL  :: CGO(MSC,MICMAX)                                            40.22
      REAL  :: USTAR(MCGRD)
      REAL  :: ZELEN(MCGRD)
      REAL  :: DISSC0(MDC,MSC)
      REAL  :: DISSC1(MDC,MSC)
      REAL  :: URSELL(MCGRD)                                              40.03
      REAL  :: FRCOEF(MCGRD)                                              20.68
C
 
      INTEGER  IDCMIN(MSC)    ,
     &         IDCMAX(MSC)    ,
     &         WWINT(*)
C
      LOGICAL  GROWW(MDC,MSC) ,
     &         ANYWND(MDC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SOURCE')
C
C     *** set coefficients in the arrays 0 ***
C
      DO IS = 1, MSC                                                      17/JAN
        DO ID = 1, MDC
          IMATRA(ID,IS) = 0.
          IMATDA(ID,IS) = 0.
        ENDDO
      ENDDO
C
C
C     *** set all dissipation coeff at 0 ***
C
      DO ISC = 1, MSC
        DO IDC = 1, MDC
          DISSC0(IDC,ISC) = 0.
          DISSC1(IDC,ISC) = 0.
        ENDDO
      ENDDO
C
C
      IF (IBOT .GE. 1) THEN
C
C       *** wave-bottom interactions ***
C
        CALL SBOT (MDC      ,MSC      ,ICMAX    ,ICUR     ,IBOT     ,
     &             GRAV     ,ABRBOT   ,DEP2     ,ECOS     ,ESIN     ,
     &             IMATDA   ,KWAVE    ,SPCSIG   ,UBOT     ,UX2      ,     30.72
     &             UY2      ,PBOT     ,MBOT     ,IDCMIN   ,IDCMAX   ,
     &             PLBTFR   ,ISSTOP   ,DISSC1   ,VARFR    ,FRCOEF   ,
     &             KCGRD    ,MCGRD
     &                             )
      END IF
C
      IF (ISURF .GE. 1) THEN
C
C       *** wave breaking with Kirby type formulation (f/fm)^2 ***
C
C
C         *** wave breaking according to Battjes and Janssen (1978) ***
C
          CALL SSURF (ETOT    ,HM      ,
     &                QBLOC   ,SMEBRK  ,AC2     ,IMATRA  ,                30.81
     &                IMATDA  ,IDCMIN  ,IDCMAX  ,PLWBRK  ,
     &                ISSTOP  ,DISSC0  ,DISSC1                            30.21
     &                                                              )
C
      END IF
C
      IF ( IWIND .GE. 3
     &                 ) THEN
C
C       *** linear wind input according to Cavaleri and Melanotte ***
C       *** Razolli (1981) for a third generation mode of SWAN    ***
C
        IF (PWIND(31) .GT. 1.E-20)                                        7/MAR
     &  CALL SWIND0 (MDC     ,MSC     ,IDCMIN  ,IDCMAX  ,ISSTOP  ,
     &               SPCSIG  ,THETAW  ,GRAV    ,PI      ,ANYWND  ,        30.72
     &               UFRIC   ,FPM     ,PLWNDA  ,IMATRA  ,SPCDIR  ,
     &               KCGRD   ,ICMAX   ,PWIND                     )        7/MAR
      ENDIF
C
C
C      *** modifications ***
C
       IF ( IWIND .EQ. 1 .OR. IWIND .EQ. 2 ) THEN                         970220
C
         CALL WNDPAR (ISSTOP,IDWMIN,IDWMAX,IDCMIN,IDCMAX,                 32.06
     &                   DEP2  ,WIND10,                                   32.06
     &                   THETAW,AC2   ,KWAVE ,IMATRA,IMATDA,              32.06
     &                   SPCSIG,CGO   ,ALIMW ,GROWW ,ETOTW ,              32.06
     &                   PLWNDA,PLWNDB,SPCDIR,ITER            )           32.06
C
C
      ELSE IF ( IWIND .EQ. 3 ) THEN
C
C       *** Wind input according to Snyder et al (1981) ***
C
        CALL SWIND3 (MDC     ,MSC     ,SPCSIG  ,THETAW  ,IMATDA  ,        30.72
     &               PWIND   ,MWIND   ,KWAVE   ,IMATRA  ,PI      ,
     &               IDCMIN  ,IDCMAX  ,AC2     ,ICMAX   ,UFRIC   ,
     &               FPM     ,PLWNDB  ,ISSTOP  ,SPCDIR  ,ANYWND  ,
     &               KCGRD   ,MCGRD                              )        30.21
C
      ELSE IF ( IWIND .EQ. 4 ) THEN
C
C       *** Wind input according to Janssen (1989,1991) ***
C
        CALL SWIND4  (MDC     ,MSC     ,ICMAX   ,IDWMIN  ,IDWMAX  ,
     &                SPCSIG  ,WIND10  ,THETAW  ,PWIND   ,XIS     ,       30.72
     &                MWIND   ,DDIR    ,KWAVE   ,GRAV    ,IMATRA  ,
     &                PI      ,IDCMIN  ,IDCMAX  ,AC2     ,UFRIC   ,
     &                PLWNDB  ,ISSTOP  ,ITER    ,USTAR   ,ZELEN   ,
     &                SPCDIR  ,ANYWND  ,NSTATC  ,IT      ,PRECOR  ,       40.00
     &                KCGRD   ,MCGRD                              )       40.02
C
      ELSE IF ( IWIND .EQ. 5 ) THEN
C
C       *** Wind input according to Yan (1989) ***
C
        CALL SWIND5 (MDC     ,MSC     ,SPCSIG  ,THETAW  ,ISSTOP  ,        30.72
     &               UFRIC   ,KWAVE   ,IMATRA  ,PI      ,IDCMIN  ,
     &               IDCMAX  ,AC2     ,ICMAX   ,ANYWND  ,PLWNDB  ,
     &               SPCDIR  ,KCGRD   ,MCGRD                     )        30.21
C
 
      END IF
C
C
C     Calculate whitecapping source term (five formulations)              40.02
C
      IF (IWCAP.GE.1) CALL SWCAP (SPCDIR  ,SPCSIG  ,KWAVE   ,AC2     ,    40.02
     &                            IDCMIN  ,IDCMAX  ,ISSTOP  ,             40.02
     &                            ETOT    ,IMATDA  ,IMATRA  ,PLWCAP  ,    40.02
     &                            DEP2    ,DISSC1  ,DISSC0           )    40.12
C
C     compute nonlinear interactions, starting with triads                 NB!
C
      IF (ITRIAD .GT. 0) THEN
C
C       *** compute the 3 wave-wave interactions if in each ***            NB!
C       *** geographical gridpoint a continues spectrum     ***
C       *** present is, i.e., after one iteration           ***
C
        IF ( ICUR .EQ. 0 .AND. ITER .GE. 1 ) THEN
C
          IF (ITRIAD.LT.3) THEN
            CALL STRIAD (AC2     ,DEP2    ,CGO     ,IMATRA  ,KWAVE   ,
     &                   HS      ,IDDLOW  ,IDDTOP  ,
     &                   SPCSIG  ,SMEBRK  ,IMATDA  ,PLTRI   ,URSELL  )    40.03
          ELSE
            CALL STRIAN (AC2     ,DEP2    ,CGO     ,IMATRA  ,KWAVE   ,
     &                   HS      ,IDDLOW  ,IDDTOP  ,
     &                   SPCSIG  ,SMEBRK  ,IMATDA  ,PLTRI   ,URSELL  )    40.03
          ENDIF
C
        ELSE IF ( ICUR .EQ. 1 .AND. ITER .GT. 1 ) THEN
C
          IF (ITRIAD.LT.3) THEN
            CALL STRIAD (AC2     ,DEP2    ,CGO     ,IMATRA  ,KWAVE   ,
     &                   HS      ,IDDLOW  ,IDDTOP  ,
     &                   SPCSIG  ,SMEBRK  ,IMATDA  ,PLTRI   ,URSELL  )    40.03
          ELSE
            CALL STRIAN (AC2     ,DEP2    ,CGO     ,IMATRA  ,KWAVE   ,
     &                   HS      ,IDDLOW  ,IDDTOP  ,
     &                   SPCSIG  ,SMEBRK  ,IMATDA  ,PLTRI   ,URSELL  )    40.03
          ENDIF
        ENDIF
C
      ELSE
        URSELL(KCGRD(1)) = 0.                                             40.03
      ENDIF
C
C     compute quadruplet interactions if triads are not active:           30.80
C
      IF (URSELL(KCGRD(1)).LT.PTRIAD(3)) THEN                             40.03
C
C       *** compute the counters for the nonlinear 4ww- ***
C       *** interactions in spectral space              ***
C
        IF ( IQUAD .GE. 1 )
     &     CALL RANGE4 (WWINT ,IDDLOW,IDDTOP )                            40.00
C
        IF (IQUAD .EQ. 1) THEN
C
C       *** semi-implicit calculation for al the bins that fall ***
C       *** within a sweep. No additional array is required     ***
C
          CALL SWSNL1 (                  WWINT   ,WWAWG   ,WWSWG   ,      34.00
     &                 IDCMIN  ,IDCMAX  ,AF11    ,UE      ,SA1     ,
     &                 SA2     ,DA1C    ,DA1P    ,DA1M    ,DA2C    ,
     &                 DA2P    ,DA2M    ,SPCSIG  ,SNLC1   ,KMESPC  ,      30.72
     &                 FACHFR  ,ISSTOP  ,DAL1    ,DAL2    ,DAL3    ,
     &                 SFNL    ,DSNL    ,DEP2    ,AC2     ,IMATDA  ,
     &                 IMATRA  ,PLNL4S  ,PLNL4D                    ,      34.00
     &                                            IDDLOW  ,IDDTOP  )      34.00
C
        ELSE IF ( IQUAD .EQ. 2) THEN
C
C         *** fully explicit calculation for al the bins that fall ***
C         *** within a sweep. No additional array is required      ***
C
          CALL SWSNL2 (                  IDDLOW  ,IDDTOP  ,WWINT   ,      34.00
     &                 WWAWG   ,AF11    ,UE      ,SA1     ,ISSTOP  ,
     &                 SA2     ,SPCSIG  ,SNLC1   ,DAL1    ,DAL2    ,      30.72
     &                 DAL3    ,SFNL    ,DEP2    ,AC2     ,KMESPC  ,
     &                                                     IMATRA  ,      34.00
     &                 FACHFR  ,PLNL4S           ,IDCMIN  ,IDCMAX  )      34.00
C
        ELSE IF ( IQUAD .EQ. 3) THEN
C
C         *** fully explicit calculation of the 4 wave-wave inter-  ***
C         *** actions for the full circle (1 -> MDC). An additional ***
C         *** array is required in which the values are stored prior***
C         *** to every iteration                                    ***
C
          IF ( ITER .EQ. 1 ) THEN
C
C           *** calculate the interactions every sweep in each grid ***
C           *** point for the first iterations to ensure stable     ***
C           *** behaviour of the model                              ***
C
            CALL SWSNL3 (MDC     ,MSC     ,WWINT   ,WWAWG   ,AF11    ,
     &                   UE      ,SA1     ,SA2     ,SPCSIG  ,SNLC1   ,    30.72
     &                   DAL1    ,DAL2    ,DAL3    ,SFNL    ,DEP2    ,
     &                   AC2     ,KMESPC  ,MEMNL4  ,FACHFR  ,PI      ,
     &                   MSC4MI  ,MSC4MA  ,MDC4MI  ,MDC4MA  ,KCGRD   ,
     &                   MCGRD   ,ICMAX                              )    30.21
C
          ELSE IF ( ITER .GT. 1 .AND. ( SWPDIR .EQ. 1 .OR.
     &        ( SWPDIR .EQ. 2 .AND. IX .EQ. 1) .OR.
     &        ( SWPDIR .EQ. 3 .AND. IY .EQ. 1) .OR.
     &        ( SWPDIR .EQ. 4 .AND. (IX.EQ.MXC .AND. IY.EQ.1)) )) THEN
C
            CALL SWSNL3 (MDC     ,MSC     ,WWINT   ,WWAWG   ,AF11    ,
     &                   UE      ,SA1     ,SA2     ,SPCSIG  ,SNLC1   ,    30.72
     &                   DAL1    ,DAL2    ,DAL3    ,SFNL    ,DEP2    ,
     &                   AC2     ,KMESPC  ,MEMNL4  ,FACHFR  ,PI      ,
     &                   MSC4MI  ,MSC4MA  ,MDC4MI  ,MDC4MA  ,KCGRD   ,
     &                   MCGRD   ,ICMAX                              )    30.21
C
          ENDIF
C
C         *** Get source term value of additional array for the bin   ***
C         *** that fall within a sweep and store in right hand vector ***
C
          CALL FILNL3 (MDC     ,MSC     ,IDCMIN  ,IDCMAX  ,IMATRA  ,
     &                 MEMNL4  ,PLNL4S  ,ISSTOP  ,KCGRD   ,MCGRD   ,
     &                 ICMAX                                       )      30.21
C
CQUAD        ELSE IF (IQUAD .GE. 5) THEN                                       40.10
CQUADC
CQUADC         Calculate the quadruplets using the interface with Gerbrant     40.10
CQUADC         van Vledder                                                     40.10
CQUADC
CQUADC         Avoid calculation of the quadruplets in more than one sweep     40.10
CQUADC
CQUAD          IF ((ITER .GE. 1) .AND.                                         40.10
CQUAD     &         ( (SWPDIR.EQ.1)                                 .OR.       40.10
CQUAD     &          ((SWPDIR.EQ.2).AND.(IX.EQ.1)                  ).OR.       40.10
CQUAD     &          ((SWPDIR.EQ.3).AND.(IY.EQ.1)  .AND.(.NOT.ONED)).OR.       40.10
CQUAD     &          ((SWPDIR.EQ.4).AND.(IX.EQ.MXC).AND.(IY.EQ.1)              40.10
CQUAD     &                                        .AND.(.NOT.ONED)) )         40.10
CQUAD     &       ) THEN                                                       40.10
CQUADC
CQUAD            IQERR = 0                                                     40.10
CQUAD            CALL SWANQUAD(AC2,SPCSIG,SPCDIR,MDC,MSC,MCGRD,DEP2,           40.10
CQUAD     &                    IQUAD,MEMNL4,KCGRD,ICMAX,GRAV,RHO,              40.10
CQUAD     &                    -PWTAIL(1),IQERR)                               40.10
CQUADC
CQUAD          ENDIF                                                           40.10
CQUADC
CQUAD            IF (ITEST.GE.30) THEN                                         40.10
CQUAD              WRITE (PRTEST,*) '+SOURCEQX: IX, IY, SWPDIR: ',             40.10
CQUAD     &                         IX, IY, SWPDIR                             40.10
CQUAD            ENDIF                                                         40.10
CQUAD            IF (TESTFL.AND.ITEST.GE.100) THEN                             40.10
CQUAD              DO IS=1, MSC                                                40.10
CQUAD                DO ID = 1, MDC                                            40.10
CQUAD                  WRITE(PRINTF,9100) IS,ID,MEMNL4(ID,IS,KCGRD(1))         40.10
CQUAD 9100             FORMAT(' SOURCEQX: IS ID MEMNL(): ',2I6,E12.4)          40.10
CQUAD                ENDDO                                                     40.10
CQUAD              ENDDO                                                       40.10
CQUAD            ENDIF                                                         40.10
CQUADC
CQUAD          CALL FILNL3 (MDC     ,MSC     ,IDCMIN  ,IDCMAX  ,IMATRA  ,      40.10
CQUAD     &                 MEMNL4  ,PLNL4S  ,ISSTOP  ,KCGRD   ,MCGRD   ,      40.10
CQUAD     &                 ICMAX                                       )      40.10
CQUADC
CQUAD          IF (ITEST.GE.30) THEN                                           40.10
CQUAD            WRITE (PRTEST,*) '+SOURCE: ITER, IQUAD, SWPDIR, IQERR: ',     40.10
CQUAD     &                       ITER, IQUAD, SWPDIR, IQERR                   40.10
CQUAD          ENDIF                                                           40.10
CQUADC
        ENDIF
      ENDIF
C     End of the subroutine SOURCE
      RETURN
      END
C
C************************************************************************
C                                                                       *
      SUBROUTINE PHILIM(AC2,AC2OLD,CGO,KWAVE,SPCSIG,ANYBIN,QB_LOC)
C                                                                       *
C************************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
C
C  0. Authors
C
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.82, Feb. 99: New subroutine
C
C  2. Purpose
C
C     Limits the change in action density between two iterations to a
C     certain percentage of the Phillips equilibrium level
C
C  3. Method
C
C     The Phillips spectrum is defined as follows (Ris, 1997, p. 36):
C
C
C                            alpha_PM
C     N_Ph(sigma,theta) = ---------------
C                         2 sigma k^3 c_g
C
C     in which the Phillips' constant for a Pierson-Moskowitz spectrum
C     (alpha_PM) is taken to be 0.0081
C
C     The change of the spectrum AC2 is limited such that
C
C     | D(AC2(sigma,theta)) | <= PNUMS(20) N_Ph(sigma,theta) = DAC2MX
C
C     In cases where waves are breaking the dissipation of energy is not
C     limited. This is assumed to be the case when the fraction of breaking
C     waves Qb is more than 1.e-5
C
C  4. Argument variables
C
      LOGICAL ANYBIN(MDC,MSC)
C
C     QB_LOC: Local value of Qb (fraction of breaking waves)
C
      REAL    QB_LOC
      REAL    AC2(MDC,MSC,MCGRD)
      REAL    AC2OLD(MDC,MSC)
      REAL    CGO(MSC,ICMAX)
      REAL    KWAVE(MSC,ICMAX)
      REAL    SPCSIG(MSC)
C
C  6. Local variables
C
C     ID    : Counter for directional (theta) space
C     IS    : Counter for frequency (sigma) space
C
      INTEGER ID,IS
C
C     DAC2MX: Maximum deviation of action density AC2 between iterations
C
      REAL    DAC2MX
C
C 13. Source text
C
      IF (MSC.GT.3) THEN
        DO IS=1,MSC
          DAC2MX=ABS((PNUMS(20)*0.0081)/
     &             (2.*SPCSIG(IS)*(KWAVE(IS,1)**3)*CGO(IS,1)))
            DO ID=1,MDC
              IF (ANYBIN(ID,IS)) AC2(ID,IS,KCGRD(1))=
     &                 MIN(AC2(ID,IS,KCGRD(1)), AC2OLD(ID,IS)+DAC2MX)
            END DO
          IF (QB_LOC.LT.0.00001) THEN
            DO ID=1,MDC
              IF (ANYBIN(ID,IS)) AC2(ID,IS,KCGRD(1))=
     &                 MAX(AC2(ID,IS,KCGRD(1)), AC2OLD(ID,IS)-DAC2MX)
            END DO
          END IF
        END DO
      END IF
      RETURN
      END
C****************************************************************
C
      SUBROUTINE RESCALE (AC2, ISSTOP, IDCMIN, IDCMAX)
C
C****************************************************************
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     40.00: Nico Booij
C
C  1. Updates
C
C     40.00, Feb. 99: New subroutine (software moved from subroutines
C                     SOLBAND, SOLMT1 and SOLMAT
C
C  2. Purpose
C
C     Remove negative values from a computed action density spectrum
C
C  3. Method
C
C     Make negative action densities 0 at the expense of other action densities
C     for the frequency
C
C  4. Argument variables
C
C     AC2         action densities
C
      REAL        AC2(MDC,MSC,MCGRD)
C
C     ISSTOP      maximum frequency counter in this sweep
C
      INTEGER     ISSTOP
C
C     IDCMIN      Integer array containing minimum counter of directions
C     IDCMAX      Integer array containing maximum counter
C
      INTEGER     IDCMIN(MSC), IDCMAX(MSC)
C
C     5. SUBROUTINES CALLING
C
C        SWOMPU
C
C     6. SUBROUTINES USED
C
C        NONE
C
C     7. ERROR MESSAGES
C
C        ---
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C   -------------------------------------------------------------
C   For all frequencies do
C       Make ATOT equal to integral of action density over direction
C       Make ATOTP equal to integral of positive action density
C       Determine FACTOR
C       If negative values do occur
C       Then for all directions do
C            If action density is negative
C            Then make action density =0
C            Else multiply action density by FACTOR
C   ------------------------------------------------------------
C
C     10. SOURCE
C
C************************************************************************
C
C         local variables
C
C         IS         counter of frequency
C         ID         counter of direction
C         IDDUM      uncorrected counter of direction
C
      INTEGER  IS      ,ID      ,IDDUM,   IENT
C
C         ATOT       integral of action density for one frequency
C         ATOTP      integral of positive action density for one frequency
C         FACTOR
C
      REAL     ATOT    ,ATOTP   ,FACTOR
C
C         NEGVAL      if True, there are negative values in the spectrum
C
      LOGICAL  NEGVAL
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'RESCALE')
C
C     *** if negative action density occur rescale with a factor ***
C     *** only the sector computed is rescaled !!                ***
C
      DO 180 IS = 1 , ISSTOP
        ATOT   = 0.
        ATOTP  = 0.
        FACTOR = 0.
        NEGVAL = .FALSE.
        DO 160 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          ATOT = ATOT + AC2(ID,IS,KCGRD(1))
          IF ( AC2(ID,IS,KCGRD(1)) .LT. 0. ) THEN
            NEGVAL = .TRUE.
          ELSE
            ATOTP = ATOTP + AC2(ID,IS,KCGRD(1))
          END IF
 160    CONTINUE
        IF (NEGVAL) THEN
          IF ( ATOTP .LT. 1.E-15 ) ATOTP = 1.E-15
          FACTOR = ATOT / ATOTP
C
C         *** rescale ***
C
          DO 170 IDDUM = IDCMIN(IS), IDCMAX(IS)
            ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
            IF ( AC2(ID,IS,KCGRD(1)) .LT. 0.) THEN
              AC2(ID,IS,KCGRD(1)) = 0.
            END IF
            IF ( FACTOR .GE. 0. ) THEN
              AC2(ID,IS,KCGRD(1)) = FACTOR * AC2(ID,IS,KCGRD(1))
            ENDIF
 170      CONTINUE
C
          IF ( ITEST .GE. 120 .AND. TESTFL )
     &    WRITE (PRINTF, 171) IXCGRD(1)-1, IYCGRD(1)-1, IS,
     &    FACTOR , ATOT, ATOTP
 171      FORMAT(' Rescale in Point, Isig, Factor, ATOT, ATOTP:',
     &    3I4, 3(1X,E11.4))
        ENDIF
 180  CONTINUE
      RETURN
      END
C***********************************************************************  NRL
C***********************************************************************  NRL
C***********************************************************************  NRL
      SUBROUTINE GET_MT_LOOP_BOUNDS(N1,N2,M1,M2)                          NRL
C-----------------------------------------------------------------------  NRL
C     SUBROUTINE GET_MT_LOOP_BOUNDS                                       NRL
C                                                                         NRL
C Objective: Given global loop bounds N1 and N2, compute loop bounds      NRL
C            M1 and M2 for calling thread                                 NRL
C                                                                         NRL
C Note: The !$ sentinals are used to allow conditional compilation        NRL
C       for serial (non-OpenMP) compatability.                            NRL
C-----------------------------------------------------------------------  NRL
      IMPLICIT NONE                                                       NRL
      INTEGER ID,NTH,NCH,N1,N2,M1,M2                                      NRL
!$    INTEGER OMP_GET_NUM_THREADS,OMP_GET_THREAD_NUM                      NRL
!$    EXTERNAL OMP_GET_NUM_THREADS,OMP_GET_THREAD_NUM                     NRL
      NTH=1                                                               NRL
      ID=0                                                                NRL
!$    NTH=OMP_GET_NUM_THREADS()                                           NRL
!$    ID=OMP_GET_THREAD_NUM()                                             NRL
      NCH=(N2-N1+1)/NTH                                                   NRL
      M1=ID*NCH+N1                                                        NRL
      M2=(ID+1)*NCH+N1-1                                                  NRL
      IF(ID.EQ.NTH-1) M2=N2                                               NRL
      RETURN                                                              NRL
      END                                                                 NRL
C***********************************************************************  NRL
C***********************************************************************  NRL
C***********************************************************************  NRL
