!NRL: $Id: swancom4.F,v 1.3 2003/03/28 15:43:15 dykes Stab $
!NRL: $Name:  $
C
C     SWAN/COMPU   file 4 of 6
C
C
C     PROGRAM SWANCOM4.FOR
C
C
C     This file SWANCOM4 of the main program SWAN
C     include the next subroutines
C
C     *** nonlinear 4 wave-wave interactions ***
C
C     BND4WW (determine boundary for arrays fof 4-ww interactions
C             to allocate some memory in WAREA)
C     FAC4WW (compute the constants for the nonlinear wave wave
C             interactions)
C     RANGE4 (compute the counters for the different types of
C             computations for the nonlinear wave interactions )
C     SWSNL1 (Nonlinear four wave interactions semi implicit computed
C             for all bins that fall within a sweep. Interaction are
C             calculated per sweep)
C     SWSNL2 (Nonlinear four wave interactions fully explicit computed
C             for all bins that fall within a sweep. Interaction are
C             calculated per sweep)
C     SWSNL3 (calculete nonlinear four wave interactions fully explicit
C             for the full circel per iteration and store results in
C             auxiliary array).
C     FILNL3 (nonlinear four wave-wave interactions fully explicit)
C
C     *** nonlinear 3 wave-wave interactions ***
C
C     STRIAN (Triad-wave interactions calculated with the Lumped Triad      rr
C             Approximation of Eldeberky 1996).                             rr
C
C     STRIAD (Non linear three wave interactions using an semi-
C             implicit scheme)
C     STIEXP (Non linear three wave interactions according to explicit
C             method). This method, however, is considering the
C             magnitude of the interactions not stable
C
C----------------------------------------------------------------------
C
C******************************************************************
C
      SUBROUTINE BND4WW (MSCMAX,MDCMAX,SPCSIG              )              34.00
C
C******************************************************************
C
      INCLUDE 'swcomm3.inc'                                               34.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  H.L. Tolman, R.C. Ris                          |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     compute the array size for the nonlinear 4 wave
C     interactions in order to allocate some memory in
C     the WAREA
C
C  3. Method
C
C     For the method see comment at subroutine SWSNL1
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     5. SUBROUTINES CALLING
C
C        ----
C
C     6. SUBROUTINES USED
C
C        none
C
C     7. ERROR MESSAGES
C
C        none
C
C     8. REMARKS
C
C        ---
C
C     9. STRUCTURE
C
C        ---
C
C     10. SOURCE TEXT
C
C***********************************************************************
C
      INTEGER      IDP   ,IDP1  ,IDM   ,IDM1  ,MSC2  ,                    34.00
     &             MSC1  ,ISP   ,ISP1  ,ISM   ,ISM1  ,ISLOW ,ISHGH ,
     &             MSCMAX,MDCMAX,                                         34.00
     &             IDLOW ,IDHGH
C
      REAL         LAMBDA,LAMM2 ,LAMP2 ,DELTH3,AUX1  ,DELTH4,CIDP  ,
     &             CIDM  ,XIS   ,XISLN ,RATE                              34.00
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'BND4WW')                             34.00
C
C     *** compute the auxiliary array boundaries for the 4 wave ***
C     *** interactions                                          ***
C
      LAMBDA = PQUAD(1)                                                   34.00
      LAMM2  = (1.-LAMBDA)**2
      LAMP2  = (1.+LAMBDA)**2
      DELTH3 = ACOS( (LAMM2**2+4.-LAMP2**2) / (4.*LAMM2) )
      AUX1   = SIN(DELTH3)
      DELTH4 = ASIN(-AUX1*LAMM2/LAMP2)
C
      CIDP  = ABS(DELTH4/DDIR)                                            34.00
      IDP   = INT(CIDP)
      IDP1  = IDP + 1
C
      CIDM  = ABS(DELTH3/DDIR)                                            34.00
      IDM   = INT(CIDM)
      IDM1  = IDM + 1
C
      MSC2   = INT ( FLOAT(MSC) / 2.0 )
      MSC1   = MSC2 - 1
C
      XIS    = SPCSIG(MSC2) / SPCSIG(MSC1)
      XISLN  = LOG( XIS )
      ISP    = INT( LOG(1.+LAMBDA) / XISLN )
      ISP1   = ISP + 1
      ISM    = INT( LOG(1.-LAMBDA) / XISLN )
      ISM1   = ISM - 1
C
C     *** Range of array size and calculations ***
C
      ISLOW =  1  + ISM1
      ISHGH = MSC + ISP1 - ISM1
CC      IDLOW = 1 - MAX(IDM1,IDP1)
CC      IDHGH = MDC + MAX(IDM1,IDP1)
      IDLOW = 1   - MDC - MAX (IDM1, IDP1)
      IDHGH = MDC + MDC + MAX (IDM1, IDP1)
      MSC4MI = ISLOW
      MSC4MA = ISHGH
      MDC4MI = IDLOW
      MDC4MA = IDHGH
      MSCMAX = MSC4MA - MSC4MI + 1
      MDCMAX = MDC4MA - MDC4MI + 1
C
C     *** Test output ***
C
      IF ( TESTFL .AND. ITEST .GE. 50 ) THEN
        WRITE(PRINTF,*) ' subroutine BND4WW:'
        RATE = 180. / PI
        WRITE(PRINTF,*) ' DELTH3 DELTH4 DDIR     :',DELTH3*RATE,          34.00
     &  DELTH4*RATE,DDIR*RATE                                             34.00
        WRITE(PRINTF,*) ' ISM ISM1 ISP ISP1      :',ISM,ISM1,ISP,ISP1
        WRITE(PRINTF,*) ' IDM IDM1 IDP IDP1      :',IDM,IDM1,IDP,IDP1
        WRITE(PRINTF,*) ' MDC MSC  XIS XISLN     :',MDC,MSC,XIS,XISLN
        WRITE(PRINTF,*) ' ISLOW,ISHGH,IDLOW,IDHGH:',ISLOW,ISHGH,IDLOW
     &                 ,IDHGH
        WRITE(PRINTF,*) ' S4MI S4MA D4MI D4MA    :',MSC4MI,MSC4MA,
     &                    MDC4MI,MDC4MA
        WRITE(PRINTF,*) ' MSCMAX MDCMAX          :',MSCMAX, MDCMAX
      END IF
C
C     End of the subroutine BND4WW
      RETURN
      END
C
C******************************************************************
C
      SUBROUTINE FAC4WW (ITER ,XIS   ,SNLC1 ,                             34.00
     &                  DAL1  ,DAL2  ,DAL3         ,SPCSIG,               34.00
     &                  AF11  ,WWINT ,WWAWG ,WWSWG                )       34.00
C
C******************************************************************
C
      INCLUDE 'swcomm3.inc'                                               34.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  H.L. Tolman, R.C. Ris                          |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose :
C
C     Calculate interpolation constants for Snl.
C
C  3. Method :
C
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     INTEGERS:
C     ---------
C     ITER              Iteration number
C     MSC2,MSC1         Auxiliary variables
C     MSC,MDC           Maximum counters in spectral space
C     IDP,IDP1          Positive range for ID
C     IDM,IDM1          Negative range for ID
C     ISP,ISP1          idem for IS
C     ISM,ISM1          idme for IS
C     ISCLW,ISCHG       Minimum and maximum counter for discrete
C                       computations in frequency space
C     ISLOW,ISHGH       Minimum and maximum range in frequency space
C     IDLOW,IDHGH       idem in directional space
C     IS                Frequency counter
C     MSC4MI,MSC4MA     Array dimensions in frequency space
C     MDC4MI,MDC4MA     Array dimensions in direction space
C
C     REALS:
C     ------
C     LAMBDA            Coefficient set 0.25
C     GRAV              Gravitational acceleration
C     SNLC1             Coefficient for the subroutines SWSNLn
C     LAMM2,LAMP2
C     DELTH3,DELTH4     Angles between the interacting wavenumbers
C     DAL1,DAL2,DAL3    Coefficients for the non linear interactions
C     CIDP,CIDM
C     WIDP,WIDP1,WIDM,WIDM1  Weight factors
C     WISP,WISP1,WISM,WISM1  idem
C     AWGn              Interpolation weight factors
c     SWGn              Quadratic interpolation weight factors
C     XIS,XISLN         Difference between succeeding frequencies
C     PI                3.14
C     FREQ              Auxiliary frequency to fill scaling array
C     DDIR,RADE         band width in directional space and factor        34.00
C
C     ARRAYS
C     ------
C     AF11    1D   Sacling frequency
C     WWINT   1D   counters for 4WAVE interactions
C     WWAWG   1D   values for the interpolation
C     WWSWG   1D   vaules for the interpolation
C
C     WWINT ( 1 = IDP    WWAWG ( = AGW1    WWSWG ( = SWG1
C             2 = IDP1           = AWG2            = SWG2
C             3 = IDM            = AWG3            = SWG3
C             4 = IDM1           = AWG4            = SWG4
C             5 = ISP            = AWG5            = SWG5
C             6 = ISP1           = AWG6            = SWG6
C             7 = ISM            = AWG7            = SWG7
C             8 = ISM1           = AWG8 )          = SWG8  )
C             9 = ISLOW
C             10= ISHGH
C             11= ISCLW
C             12= ISCHG
C             14= IDLOW
C             15= IDHGH
C             16= MSC4MI
C             17= MSC4MA
C             18= MDC4MI
C             19= MDC4MA
C             20= MSCMAX
C             21= MDCMAX )
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     ---
C
C  6. Error messages :
C
C     ---
C
C  9. Source code :
C
C     -----------------------------------------------------------------
C     Calculate :
C       1. counters for frequency and direction for NL-interaction
C       2. weight factors
C       3. the minimum and maximum counter in IS and ID space
C       4. the interpolation weights
C       5. the quadratic interpolation rates
C       6. fill the array for the frequency**11
C     ----------------------------------------------------------
C
C****************************************************************
C
      INTEGER     ITER  ,MSC2  ,MSC1  ,IS    ,IDP   ,IDP1  ,              34.00
     &            IDM   ,IDM1  ,ISP   ,ISP1  ,ISM   ,ISM1  ,              34.00
     &            ISLOW ,ISHGH ,ISCLW ,ISCHG ,IDLOW ,IDHGH ,
     &            MSCMAX,MDCMAX                                           34.00
C
      REAL        LAMBDA,SNLC1 ,LAMM2 ,LAMP2 ,DELTH3,                     34.00
     &            AUX1  ,DELTH4,DAL1  ,DAL2  ,DAL3  ,CIDP  ,WIDP  ,
     &            WIDP1 ,CIDM  ,WIDM  ,WIDM1 ,XIS   ,XISLN ,WISP  ,
     &            WISP1 ,WISM  ,WISM1 ,AWG1  ,AWG2  ,AWG3  ,AWG4  ,
     &            AWG5  ,AWG6  ,AWG7  ,AWG8  ,SWG1  ,SWG2  ,SWG3  ,
     &            SWG4  ,SWG5  ,SWG6  ,SWG7  ,SWG8  ,FREQ  ,              34.00
     &            RADE                                                    34.00
C
      REAL       AF11( MSC4MI:MSC4MA )  ,
     &           WWAWG(*)               ,
     &           WWSWG(*)
C
      INTEGER    WWINT(*)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'FAC4WW')
C
C     *** Compute frequency indices                               ***
C     *** XIS is the relative increment of the relative frequency ***
C
      MSC2   = INT ( FLOAT(MSC) / 2.0 )
      MSC1   = MSC2 - 1
      XIS    = SPCSIG(MSC2) / SPCSIG(MSC1)                                30.72
C
C     *** set values for the nonlinear four-wave interactions ***
C
      LAMBDA = PQUAD(1)                                                   34.00
      SNLC1  = PQUAD(2) / GRAV**4                                         34.00
C
      LAMM2  = (1.-LAMBDA)**2
      LAMP2  = (1.+LAMBDA)**2
      DELTH3 = ACOS( (LAMM2**2+4.-LAMP2**2) / (4.*LAMM2) )
      AUX1   = SIN(DELTH3)
      DELTH4 = ASIN(-AUX1*LAMM2/LAMP2)
C
      DAL1   = 1. / (1.+LAMBDA)**4
      DAL2   = 1. / (1.-LAMBDA)**4
      DAL3   = 2. * DAL1 * DAL2
C
C     *** Compute directional indices in sigma and theta space ***
C
      CIDP   = ABS(DELTH4/DDIR)                                           40.00
      IDP   = INT(CIDP)
      IDP1  = IDP + 1
      WIDP   = CIDP - REAL(IDP)
      WIDP1  = 1.- WIDP
C
      CIDM   = ABS(DELTH3/DDIR)                                           40.00
      IDM   = INT(CIDM)
      IDM1  = IDM + 1
      WIDM   = CIDM - REAL(IDM)
      WIDM1  = 1.- WIDM
      XISLN  = LOG( XIS )
C
      ISP    = INT( LOG(1.+LAMBDA) / XISLN )
      ISP1   = ISP + 1
      WISP   = (1.+LAMBDA - XIS**ISP) / (XIS**ISP1 - XIS**ISP)
      WISP1  = 1. - WISP
C
      ISM    = INT( LOG(1.-LAMBDA) / XISLN )
      ISM1   = ISM - 1
      WISM   = (XIS**ISM -(1.-LAMBDA)) / (XIS**ISM - XIS**ISM1)
      WISM1  = 1. - WISM
C
C     *** Range of calculations ***
C
      ISLOW =  1  + ISM1
      ISHGH = MSC + ISP1 - ISM1
      ISCLW =  1
      ISCHG = MSC - ISM1
CC      IDLOW = 1 - MAX(IDM1,IDP1)
CC      IDHGH = MDC + MAX(IDM1,IDP1)
      IDLOW = 1 - MDC - MAX(IDM1,IDP1)
      IDHGH = MDC + MDC + MAX(IDM1,IDP1)
C
      MSC4MI = ISLOW
      MSC4MA = ISHGH
      MDC4MI = IDLOW
      MDC4MA = IDHGH
      MSCMAX = MSC4MA - MSC4MI + 1
      MDCMAX = MDC4MA - MDC4MI + 1
C
C     *** Interpolation weights ***
C
      AWG1   = WIDP  * WISP
      AWG2   = WIDP1 * WISP
      AWG3   = WIDP  * WISP1
      AWG4   = WIDP1 * WISP1
C
      AWG5   = WIDM  * WISM
      AWG6   = WIDM1 * WISM
      AWG7   = WIDM  * WISM1
      AWG8   = WIDM1 * WISM1
C
C     *** quadratic interpolation ***
C
      SWG1   = AWG1**2
      SWG2   = AWG2**2
      SWG3   = AWG3**2
      SWG4   = AWG4**2
C
      SWG5   = AWG5**2
      SWG6   = AWG6**2
      SWG7   = AWG7**2
      SWG8   = AWG8**2
C
C     *** fill the arrays *
C
      WWINT(1) = IDP
      WWINT(2) = IDP1
      WWINT(3) = IDM
      WWINT(4) = IDM1
      WWINT(5) = ISP
      WWINT(6) = ISP1
      WWINT(7) = ISM
      WWINT(8) = ISM1
      WWINT(9) = ISLOW
      WWINT(10)= ISHGH
      WWINT(11)= ISCLW
      WWINT(12)= ISCHG
      WWINT(13)= IDLOW
      WWINT(14)= IDHGH
      WWINT(15)= MSC4MI
      WWINT(16)= MSC4MA
      WWINT(17)= MDC4MI
      WWINT(18)= MDC4MA
      WWINT(19)= MSCMAX
      WWINT(20)= MDCMAX
C
      WWAWG(1) = AWG1
      WWAWG(2) = AWG2
      WWAWG(3) = AWG3
      WWAWG(4) = AWG4
      WWAWG(5) = AWG5
      WWAWG(6) = AWG6
      WWAWG(7) = AWG7
      WWAWG(8) = AWG8
C
      WWSWG(1) = SWG1
      WWSWG(2) = SWG2
      WWSWG(3) = SWG3
      WWSWG(4) = SWG4
      WWSWG(5) = SWG5
      WWSWG(6) = SWG6
      WWSWG(7) = SWG7
      WWSWG(8) = SWG8
C
C     *** Fill scaling array (f**11)                     ***
C     *** compute the radian frequency**11 for IS=1, MSC ***
C
      DO 100 IS=1, MSC
        AF11(IS) = ( SPCSIG(IS) / ( 2. * PI ) )**11                       30.72
 100  CONTINUE
C
C     *** compute the radian frequency for the IS = MSC+1, ISHGH ***
C
      FREQ   = SPCSIG(MSC) / ( 2. * PI )                                  30.72
      DO 110 IS = MSC+1, ISHGH
        FREQ   = FREQ * XIS
        AF11(IS) = FREQ**11
 110  CONTINUE
C
C     *** compute the radian frequency for IS = 0, ISLOW ***
C
      FREQ   = SPCSIG(1) / ( 2. * PI )                                    30.72
      DO 120 IS = 0, ISLOW, -1
        FREQ   = FREQ / XIS
        AF11(IS) = FREQ**11
 120  CONTINUE
C
C     *** test output ***
C
      IF (ISLOW .LT. MSC4MI .OR. ISHGH .GT. MSC4MA .OR.
     &    IDLOW .LT. MDC4MI .OR. IDHGH .GT. MDC4MA) THEN
        WRITE (PRINTF,900) IXCGRD(1), IYCGRD(1),
     &                     ISLOW, ISHGH, IDLOW, IDHGH,
     &                     MSC4MI,MSC4MA, MDC4MI, MDC4MA
 900    FORMAT ( ' ** Error : array bounds and maxima in subr FAC4WW, ',
     &           ' point ', 2I5,
     &         /,'            ISL,ISH : ',2I4, '   IDL,IDH : ',2I4,
     &         /,'            SMI,SMA : ',2I4, '   DMI,DMA : ',2I4)
      ENDIF
C
      IF (ITEST .GE. 40) THEN
        RADE = 360.0 / ( 2. * PI )
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) ' FAC4WW subroutine '
        WRITE(PRINTF,9000) DELTH4*RADE, DELTH3*RADE, DDIR*RADE, XIS
 9000   FORMAT (' THET3 THET4 DDIR XIS  :',4E12.4)
        WRITE(PRINTF,9011) IDP, IDP1, IDM, IDM1
 9011   FORMAT (' IDP IDP1 IDM IDM1     :',4I5)
        WRITE(PRINTF,9012) WIDP, WIDP1, WIDM, WIDM1
 9012   FORMAT (' WIDP WIDP1 WIDM WIDM1 :',4E12.4)
        WRITE (PRINTF,9013) ISP, ISP1, ISM, ISM1
 9013   FORMAT (' ISP ISP1 ISM ISM1     :',4I5)
        WRITE (PRINTF,9014) WISP, WISP1, WISM, WISM1
 9014   FORMAT (' WISP WISP1 WISM WISM1 :',4E12.4)
        WRITE(PRINTF,9016) ITER, ISCLW, ISCHG
 9016   FORMAT (' ITER ICLW ICHG        :',3I5)
        WRITE (PRINTF,9017) AWG1, AWG2, AWG3, AWG4
 9017   FORMAT (' AWG1 AWG2 AWG3 AWG4   :',4E12.4)
        WRITE (PRINTF,9018) AWG5, AWG6, AWG7, AWG8
 9018   FORMAT (' AWG5 AWG6 AWG7 AWG8   :',4E12.4)
        WRITE (PRINTF,9019) MSC4MI, MSC4MA, MDC4MI, MDC4MA
 9019   FORMAT (' S4MI S4MA D4MI D4MA   :',4I6)
        WRITE (PRINTF,9015) ISLOW, ISHGH, IDLOW,IDHGH
 9015   FORMAT (' ISLOW ISHG IDLOW IDHG :',4I5)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     End of FAC4WW
      END
C
C******************************************************************
C
      SUBROUTINE RANGE4 (WWINT ,IDDLOW,IDDTOP)                            40.00
C
C******************************************************************
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     40.00: Nico Booij
C     40.10: IJsbrand Haagsma
C
C  1. Updates
C
C     40.10, Mar 00: Made modification for exact quadruplets
C
C  2. Purpose :
C
C     calculate the minimum and maximum counters in frequency and
C     diercional space which fall with the calculation for the
C     nonlinear wave-wave interactions.
C
C  3. Method :  review for the counters :
C
C                            Frequencies -->
C                 +---+---------------------+---------+- IDHGH
C              d  | 3 :          2          :    2    |
C              i  + - + - - - - - - - - - - + - - - - +- MDC
C              r  |   :                     :         |
C              e  | 3 :  original spectrum  :    1    |
C              c  |   :                     :         |
C              t. + - + - - - - - - - - - - + - - - - +- 1
C                 | 3 :          2          :    2    |
C                 +---+---------------------+---------+- IDLOW
C                 |   |                     |    ^    |
C             ISLOW   1                     MSC      |  ISHGH
C                     ^                              |
C                     |                              |
C                    ISCLW                          ISCHG
C              lowest discrete               highest discrete
C                central bin                    central bin
C
C
C       The directional counters depend on the numerical method that
C       is used.
C
C  4. Parameters :
C
C     INTEGER
C     -------
C     IQUAD         Counter for 4 wave interactions
C     ISLOW,ISHGH   Minimum and maximum counter in frequency space
C     ISCLW,ISCHG   idem for discrete computations
C     IDLOW,IDHGH   Minimum and maximum counters in directional space
C     MSC,MDC       Range of the original arrays
C     ISM1,ISP1,
C     IDM1,IDP1     see subroutine FAC4WW
C     IDDLOW        minimum counter of the bin that is propagated
C                   within a sweep
C     IDDTOP        minimum counter of the bin that is propagated
C                   within a sweep
C
C     array:
C     ------
C     WWINT         counters for the nonlinear interactions
C
C     WWINT ( 1  = IDP      2  = IDP1     3  = IDM     4  = IDM1
C             5  = ISP      6  = ISP1     7  = ISM     8  = ISM1
C             9  = ISLOW    10 = ISHGH    11 = ISCLW   12 = ISCHG
C             13 = IDLOW    14 = IDHGH    15 = MSC4MI  16 = MSC4MA
C             17 = MDC4MI   18 = MDC4MA
C             19 = MSCMAX   20 = MDCMAX )
C
C  5. Subroutines used :
C
C     ---
C
C  6. Called by :
C
C     SOURCE
C
C  7. Error messages :
C
C     ---
C
C  9. Source code :
C
C     -----------------------------------------------------------------
C     Calculate :
C       In absence of a current there are always four sectors
C         equal 90 degrees within a sweep thgat are propagated
C         Extend the boundaries to calculate the source term
C       In presence of a current and if IDTOT .eq. MDC then calculate
C         bounadries for calculation of interaction using the
C         unfolded area.
C     ----------------------------------------------------------
C
C****************************************************************
C
      INTEGER     IDDLOW,IDDTOP                                           40.00
C
      INTEGER     WWINT(*)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'RANGE4')
C
C     *** Range in frequency domain ***
C
      WWINT(9)  =  1  + WWINT(8)
      WWINT(10) = MSC + WWINT(6) - WWINT(8)
      WWINT(11) =  1
      WWINT(12) = MSC - WWINT(8)
C
C     *** Range in directional domain ***
C
      IF ( IQUAD .LT. 3 .AND. IQUAD .GT. 0 ) THEN                         40.10
C       *** counters based on bins which fall within a sweep ***
        WWINT(13) = IDDLOW - MAX( WWINT(4), WWINT(2) )
        WWINT(14) = IDDTOP + MAX( WWINT(4), WWINT(2) )
      ELSE
C       *** counters initially based on full circle ***
        WWINT(13) = 1   - MAX( WWINT(4), WWINT(2) )
        WWINT(14) = MDC + MAX( WWINT(4), WWINT(2) )
      END IF
C
C     *** error message ***
C
      IF (WWINT(9)  .LT. WWINT(15) .OR. WWINT(10) .GT. WWINT(16) .OR.
     &    WWINT(13) .LT. WWINT(17) .OR. WWINT(14) .GT. WWINT(18) ) THEN
        WRITE (PRINTF,900) IXCGRD(1), IYCGRD(1),
     &                     WWINT(9) ,WWINT(10) ,WWINT(13) ,WWINT(14),
     &                     WWINT(15),WWINT(16) ,WWINT(17) ,WWINT(18)
 900    FORMAT ( ' ** Error : array bounds and maxima in subr RANGE4, ',
     &           ' point ', 2I5,
     &         /,'            ISL,ISH : ',2I4, '   IDL,IDH : ',2I4,
     &         /,'            SMI,SMA : ',2I4, '   DMI,DMA : ',2I4)
        IF (ITEST.GE.50) WRITE (PRTEST, 901) MSC, MDC, IDDLOW, IDDTOP
 901    FORMAT (' MSC, MDC, IDDLOW, IDDTOP: ', 4I5)
      ENDIF
C
C     test output
C
      IF (TESTFL .AND. ITEST .GE. 60) THEN
        WRITE(PRTEST,911) WWINT(4), WWINT(2), WWINT(8), WWINT(6)
 911    FORMAT (' RANGE4: IDM1 IDP1 ISM1 ISP1    :',4I5)
        WRITE(PRTEST,916) WWINT(11), WWINT(12), IQUAD
 916    FORMAT (' RANGE4: ISCLW ISCHG IQUAD      :',3I5)
        WRITE (PRTEST,917) WWINT(9), WWINT(10), WWINT(13), WWINT(14)
 917    FORMAT (' RANGE4: ISLOW ISHGH IDLOW IDHGH:',4I5)
        WRITE (PRTEST,919) WWINT(15), WWINT(16), WWINT(17), WWINT(18)
 919    FORMAT (' RANGE4: MS4MI MS4MA MD4MI MD4MA:',4I5)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     End of RANGE4
      END
C
C********************************************************************
C
      SUBROUTINE SWSNL1 (WWINT   ,WWAWG   ,WWSWG   ,                      34.00
     &                   IDCMIN  ,IDCMAX  ,AF11    ,UE      ,SA1     ,
     &                   SA2     ,DA1C    ,DA1P    ,DA1M    ,DA2C    ,
     &                   DA2P    ,DA2M    ,SPCSIG  ,SNLC1   ,KMESPC  ,    30.72
     &                   FACHFR  ,ISSTOP  ,DAL1    ,DAL2    ,DAL3    ,
     &                   SFNL    ,DSNL    ,DEP2    ,AC2     ,IMATDA  ,
     &                   IMATRA  ,PLNL4S  ,PLNL4D  ,                      34.00
     &                   IDDLOW  ,IDDTOP  )                               34.00
C
C********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               34.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  H.L. Tolman, R.C. Ris                          |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
!     40.13: Nico Booij
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
!tst!     40.13, Mar. 01: temporary test in case of array subscript error
C
C  2. Purpose
C
C     Calculate non-linear interaction using the discrete interaction
C     approximation (Hasselmann and Hasselmann 1985; WAMDI group 1988),
C     including the diagonal term for the implicit integration.
C
C     The interactions are calculated for all bin's that fall
C     within a sweep. No additional auxiliary array is required (see
C     SWSNL3)
C
C  3. Method
C
C     Discrete interaction approximation.
C
C     Since the domain in directional domain is per definition not
C     periodic, the spectral space can not on the forhand be
C     folded to the side angles. This can only be done if the
C     full circle has to be calculated
C
C
C                            Frequencies -->
C                 +---+---------------------+---------+- IDHGH
C              d  | 3 :          2          :    2    |
C              i  + - + - - - - - - - - - - + - - - - +- MDC
C              r  |   :                     :         |
C              e  | 3 :  original spectrum  :    1    |
C              c  |   :                     :         |
C              t. + - + - - - - - - - - - - + - - - - +- 1
C                 | 3 :          2          :    2    |
C                 +---+---------------------+---------+- IDLOW
C                 |   |                     |    ^    |
C             ISLOW   1                     MSC      |  ISHGH
C                     ^                              |
C                     |                              |
C                    ISCLW                          ISCHG
C              lowest discrete               highest discrete
C                central bin                    central bin
C
C                            1 : Extra tail added beyond MSC
C                            2 : Spectrum copied outside ID range
C                            3 : Empty bins at low frequencies
C
C     ISLOW =  1  + ISM1
C     ISHGH = MSC + ISP1 - ISM1
C     ISCLW =  1
C     ISCHG = MSC - ISM1
C     IDLOW =  IDDLOW - MAX(IDM1,IDP1)
C     IDHGH =  IDDTOP + MAX(IDM1,IDP1)
C
C     For the meaning of the counterns on the right hand side of the
C     above equations see section 4.
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     Data in PARAMETER statements :
C     ----------------------------------------------------------------
C       DAL1    Real  LAMBDA dependend weight factors (see FAC4WW)
C       DAL2    Real
C       DAL3    Real
C       ITHP, ITHP1, ITHM, ITHM1, IFRP, IFRP1, IFRM, IFRM1
C               Int.  Counters of interpolation point relative to
C                     central bin, see figure below (set in FAC4WW).
C       NFRLOW, NFRHGH, NFRCHG, NTHLOW, NTHHGH
C               Int.  Range of calculations, see section 2.
C       AF11    R.A.  Scaling array (Freq**11).
C       AWGn    Real  Interpolation weights, see numbers in fig.
C       SWGn    Real  Id. squared.
C       UE      R.A.  "Unfolded" spectrum.
C       SA1     R.A.  Interaction constribution of first and second
C       SA2     R.A.    quadr. respectively (unfolded space).
C       DA1C, DA1P, DA1M, DA2C, DA2P, DA2M
C               R.A.  Idem for diagonal matrix.
C       PERCIR        full circle or sector
C     ----------------------------------------------------------------
C
C       Realtive offsets of interpolation points around central bin
C       "#" and corresponding numbers of AWGn :
C
C               ISM1  ISM
C                5        7    T |
C          IDM1   +------+     H +
C                 |      |     E |      ISP      ISP1
C                 |   \  |     T |       3           1
C           IDM   +------+     A +        +---------+  IDP1
C                6       \8      |        |         |
C                                |        |  /      |
C                           \    +        +---------+  IDP
C                                |      /4           2
C                              \ |  /
C          -+-----+------+-------#--------+---------+----------+
C                                |           FREQ.
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     SOURCE
C
C  8. Structure :
C
C     -------------------------------------------
C       Initialisations.
C       Calculate proportionality constant.
C       Prepare auxiliary spectrum.
C       Calculate interactions :
C       -----------------------------------------
C         Energy at interacting bins
C         Contribution to interactions
C         Fold interactions to side angles
C       -----------------------------------------
C       Put source term together
C     -------------------------------------------
C
C  9. Source code :
C
C*************************************************************
C
      INTEGER   IS     ,ID     ,I      ,J      ,                          34.00
     &          ISHGH  ,IDLOW  ,ISP    ,ISP1   ,IDP    ,IDP1   ,
     &          ISM    ,ISM1   ,IDHGH  ,IDM    ,IDM1   ,ISCLW  ,
     &          ISCHG  ,IDDLOW ,IDDTOP                                    34.00
C
      REAL      X      ,X2     ,CONS   ,FACTOR ,SNLCS1 ,SNLCS2 ,SNLCS3,
     &          E00    ,EP1    ,EM1    ,EP2    ,EM2    ,SA1A   ,SA1B  ,
     &          SA2A   ,SA2B   ,KMESPC ,FACHFR ,AWG1   ,AWG2   ,AWG3  ,
     &          AWG4   ,AWG5   ,AWG6   ,AWG7   ,AWG8   ,DAL1   ,DAL2  ,
     &          DAL3   ,SNLC1  ,SWG1   ,SWG2   ,SWG3   ,SWG4   ,SWG5  ,
     &          SWG6   ,SWG7   ,SWG8           ,JACOBI ,SIGPI             34.00
C
      REAL      AC2(MDC,MSC,MCGRD)                    ,
     &          DEP2(MCGRD)                           ,
     &          AF11(MSC4MI:MSC4MA )                  ,
     &          UE(MSC4MI:MSC4MA , MDC4MI:MDC4MA )    ,
     &          SA1(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &          SA2(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &          DA1C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DA1P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DA1M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DA2C(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DA2P(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DA2M(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          SFNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          DSNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA )  ,
     &          IMATDA(MDC,MSC)                       ,
     &          IMATRA(MDC,MSC)                       ,
     &          PLNL4S(MDC,MSC,NPTST)                 ,                   40.00
     &          PLNL4D(MDC,MSC,NPTST)                 ,
     &          WWAWG(*)                              ,
     &          WWSWG(*)
C
      INTEGER   IDCMIN(MSC)        ,
     &          IDCMAX(MSC)        ,
     &          WWINT(*)
C
      LOGICAL   PERCIR
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWSNL1')
C
      IDP    = WWINT(1)
      IDP1   = WWINT(2)
      IDM    = WWINT(3)
      IDM1   = WWINT(4)
      ISP    = WWINT(5)
      ISP1   = WWINT(6)
      ISM    = WWINT(7)
      ISM1   = WWINT(8)
      ISLOW  = WWINT(9)
      ISHGH  = WWINT(10)
      ISCLW  = WWINT(11)
      ISCHG  = WWINT(12)
      IDLOW  = WWINT(13)
      IDHGH  = WWINT(14)
C
      AWG1 = WWAWG(1)
      AWG2 = WWAWG(2)
      AWG3 = WWAWG(3)
      AWG4 = WWAWG(4)
      AWG5 = WWAWG(5)
      AWG6 = WWAWG(6)
      AWG7 = WWAWG(7)
      AWG8 = WWAWG(8)
C
      SWG1 = WWSWG(1)
      SWG2 = WWSWG(2)
      SWG3 = WWSWG(3)
      SWG4 = WWSWG(4)
      SWG5 = WWSWG(5)
      SWG6 = WWSWG(6)
      SWG7 = WWSWG(7)
      SWG8 = WWSWG(8)
C
C     *** Initialize auxiliary arrays per gridpoint ***
C
      DO ID = MDC4MI, MDC4MA
        DO IS = MSC4MI, MSC4MA
          UE(IS,ID)   = 0.
          SA1(IS,ID)  = 0.
          SA2(IS,ID)  = 0.
          SFNL(IS,ID) = 0.
          DA1C(IS,ID) = 0.
          DA1P(IS,ID) = 0.
          DA1M(IS,ID) = 0.
          DA2C(IS,ID) = 0.
          DA2P(IS,ID) = 0.
          DA2M(IS,ID) = 0.
          DSNL(IS,ID) = 0.
        ENDDO
      ENDDO
C
C     *** Calculate factor R(X) to calculate the NL wave-wave ***
C     *** interaction for shallow water                       ***
C     *** SNLC1 = CONSTANT * GRAV**-4  (CONSTANT = 3.E7)      ***
C
      SNLCS1 = PQUAD(3)                                                   34.00
      SNLCS2 = PQUAD(4)                                                   34.00
      SNLCS3 = PQUAD(5)                                                   34.00
      X      = MAX ( 0.75 * DEP2(KCGRD(1)) * KMESPC , 0.5 )
      X2     = MAX ( -1.E15, SNLCS3*X)
      CONS   = SNLC1 * ( 1. + SNLCS1/X * (1.-SNLCS2*X) * EXP(X2))
      JACOBI = 2. * PI
C
C     *** check wheter the spectral domain is periodic in   ***
C     *** directional space and if so, modify boundaries    ***
C
      PERCIR = .FALSE.
      IF ( IDDLOW .EQ. 1 .AND. IDDTOP .EQ. MDC ) THEN
C       *** periodic in theta -> spectrum can be volded    ***
C       *** (can only be present in presence of a current) ***
        IDCLOW = 1
        IDCHGH = MDC
        IIID   = 0
        PERCIR = .TRUE.
      ELSE
C       *** dfferent sectors per sweep -> extend range with IIID ***
        IIID   = MAX ( IDM1 , IDP1 )
        IDCLOW = IDLOW
        IDCHGH = IDHGH
      ENDIF
C
C     *** Prepare auxiliary spectrum               ***
C     *** set action original spectrum in array UE ***
C
      DO IDDUM = IDLOW - IIID, IDHGH + IIID
        ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        DO IS = 1, MSC
          UE(IS,IDDUM) = AC2(ID,IS,KCGRD(1)) * SPCSIG(IS) * JACOBI        30.72
        ENDDO
      ENDDO
C
C     *** set values in area 2 for IS > MSC+1  ***
C
      DO IS = MSC+1, ISHGH
        DO ID = IDLOW - IIID , IDHGH + IIID
          UE (IS,ID) = UE(IS-1,ID) * FACHFR
        ENDDO
      ENDDO
C
C     *** Calculate interactions      ***
C     *** Energy at interacting bins  ***
C
      DO IS = ISCLW, ISCHG
        DO ID = IDCLOW, IDCHGH
          E00    =        UE(IS      ,ID      )
          EP1    = AWG1 * UE(IS+ISP1,ID+IDP1) +
     &             AWG2 * UE(IS+ISP1,ID+IDP ) +
     &             AWG3 * UE(IS+ISP ,ID+IDP1) +
     &             AWG4 * UE(IS+ISP ,ID+IDP )
          EM1    = AWG5 * UE(IS+ISM1,ID-IDM1) +
     &             AWG6 * UE(IS+ISM1,ID-IDM ) +
     &             AWG7 * UE(IS+ISM ,ID-IDM1) +
     &             AWG8 * UE(IS+ISM ,ID-IDM )
C
          EP2    = AWG1 * UE(IS+ISP1,ID-IDP1) +
     &             AWG2 * UE(IS+ISP1,ID-IDP ) +
     &             AWG3 * UE(IS+ISP ,ID-IDP1) +
     &             AWG4 * UE(IS+ISP ,ID-IDP )
          EM2    = AWG5 * UE(IS+ISM1,ID+IDM1) +
     &             AWG6 * UE(IS+ISM1,ID+IDM ) +
     &             AWG7 * UE(IS+ISM ,ID+IDM1) +
     &             AWG8 * UE(IS+ISM ,ID+IDM )
C
C         *** Contribution to interactions                          ***
C         *** CONS is the shallow water factor for the NL interact. ***
C
          FACTOR = CONS * AF11(IS) * E00
C
          SA1A   = E00 * ( EP1*DAL1 + EM1*DAL2 )
          SA1B   = SA1A - EP1*EM1*DAL3
          SA2A   = E00 * ( EP2*DAL1 + EM2*DAL2 )
          SA2B   = SA2A - EP2*EM2*DAL3
C
          SA1 (IS,ID) = FACTOR * SA1B
          SA2 (IS,ID) = FACTOR * SA2B
C
          IF(ITEST.GE.100 .AND. TESTFL) THEN
            WRITE(PRINTF,9002) E00,EP1,EM1,EP2,EM2
 9002       FORMAT (' E00 EP1 EM1 EP2 EM2  :',5E11.4)
            WRITE(PRINTF,9003) SA1A,SA1B,SA2A,SA2B
 9003       FORMAT (' SA1A SA1B SA2A SA2B  :',4E11.4)
            WRITE(PRINTF,9004) IS,ID,SA1(IS,ID),SA2(IS,ID)
 9004       FORMAT (' IS ID SA1() SA2()    :',2I4,2E12.4)
            WRITE(PRINTF,9005) FACTOR
 9005       FORMAT (' FACTOR               : ',E12.4)
          END IF
C
          DA1C(IS,ID) = CONS * AF11(IS) * ( SA1A + SA1B )
          DA1P(IS,ID) = FACTOR * ( DAL1*E00 - DAL3*EM1 )
          DA1M(IS,ID) = FACTOR * ( DAL2*E00 - DAL3*EP1 )
C
          DA2C(IS,ID) = CONS * AF11(IS) * ( SA2A + SA2B )
          DA2P(IS,ID) = FACTOR * ( DAL1*E00 - DAL3*EM2 )
          DA2M(IS,ID) = FACTOR * ( DAL2*E00 - DAL3*EP2 )
        ENDDO
      ENDDO
C
C     *** Fold interactions to side angles if spectral domain ***
C     *** is periodic in directional space                    ***
C
      IF ( PERCIR ) THEN
        DO ID = 1, IDHGH - MDC
          ID0   = 1 - ID
          DO IS = ISCLW, ISCHG
            SA1 (IS,MDC+ID) = SA1 (IS,  ID   )
            SA2 (IS,MDC+ID) = SA2 (IS,  ID   )
            DA1C(IS,MDC+ID) = DA1C(IS,  ID   )
            DA1P(IS,MDC+ID) = DA1P(IS,  ID   )
            DA1M(IS,MDC+ID) = DA1M(IS,  ID   )
            DA2C(IS,MDC+ID) = DA2C(IS,  ID   )
            DA2P(IS,MDC+ID) = DA2P(IS,  ID   )
            DA2M(IS,MDC+ID) = DA2M(IS,  ID   )
C
            SA1 (IS,  ID0 ) = SA1 (IS, MDC+ID0)
            SA2 (IS,  ID0 ) = SA2 (IS, MDC+ID0)
            DA1C(IS,  ID0 ) = DA1C(IS, MDC+ID0)
            DA1P(IS,  ID0 ) = DA1P(IS, MDC+ID0)
            DA1M(IS,  ID0 ) = DA1M(IS, MDC+ID0)
            DA2C(IS,  ID0 ) = DA2C(IS, MDC+ID0)
            DA2P(IS,  ID0 ) = DA2P(IS, MDC+ID0)
            DA2M(IS,  ID0 ) = DA2M(IS, MDC+ID0)
          ENDDO
        ENDDO
      ENDIF
C
C     *** Put source term together (To save space I=IS and J=ID ***
C     *** is used)                                              ***
C
      PI3   = (2. * PI)**3
      DO I = 1, ISSTOP
        SIGPI = SPCSIG(I) * JACOBI                                        30.72
        DO J = IDCMIN(I), IDCMAX(I)
          ID = MOD ( J - 1 + MDC , MDC ) + 1
!tst!         temporary test in case of array subscript problem               40.13
!tst          IF (I     .LT.MSC4MI .OR. I     .GT.MSC4MA .OR.                 40.13
!tst     &        I-ISP .LT.MSC4MI .OR. I-ISP .GT.MSC4MA .OR.
!tst     &        I-ISP1.LT.MSC4MI .OR. I-ISP1.GT.MSC4MA .OR.
!tst     &        I-ISM .LT.MSC4MI .OR. I-ISM .GT.MSC4MA .OR.
!tst     &        I-ISM1.LT.MSC4MI .OR. I-ISM1.GT.MSC4MA .OR.
!tst     &        ID    .LT.MDC4MI .OR. ID    .GT.MDC4MA .OR.
!tst     &        J     .LT.MDC4MI .OR. J     .GT.MDC4MA .OR.
!tst     &        J+IDP .LT.MDC4MI .OR. J+IDP .GT.MDC4MA .OR.
!tst     &        J-IDP .LT.MDC4MI .OR. J-IDP .GT.MDC4MA .OR.
!tst     &        J+IDP1.LT.MDC4MI .OR. J+IDP1.GT.MDC4MA .OR.
!tst     &        J-IDP1.LT.MDC4MI .OR. J-IDP1.GT.MDC4MA .OR.
!tst     &        J+IDM .LT.MDC4MI .OR. J+IDM .GT.MDC4MA .OR.
!tst     &        J-IDM .LT.MDC4MI .OR. J-IDM .GT.MDC4MA .OR.
!tst     &        J+IDM1.LT.MDC4MI .OR. J+IDM1.GT.MDC4MA .OR.
!tst     &        J-IDM1.LT.MDC4MI .OR. J-IDM1.GT.MDC4MA) THEN
!tst            WRITE (PRTEST, 136) I, ISSTOP, ISP, ISP1, ISM1,
!tst     &        MSC4MI, MSC4MA,
!tst     &        J, ID, IDCMIN(I), IDCMAX(I), IDP, IDP1, IDM, IDM1,
!tst     &        MDC4MI, MDC4MA
!tst 136        FORMAT (' err SWSNL1, is:', 7I5, ', id:', 11I5)
!tst          ENDIF
          SFNL(I,ID) =   - 2. * ( SA1(I,J) + SA2(I,J) )
     &        + AWG1 * ( SA1(I-ISP1,J-IDP1) + SA2(I-ISP1,J+IDP1) )
     &        + AWG2 * ( SA1(I-ISP1,J-IDP ) + SA2(I-ISP1,J+IDP ) )
     &        + AWG3 * ( SA1(I-ISP ,J-IDP1) + SA2(I-ISP ,J+IDP1) )
     &        + AWG4 * ( SA1(I-ISP ,J-IDP ) + SA2(I-ISP ,J+IDP ) )
     &        + AWG5 * ( SA1(I-ISM1,J+IDM1) + SA2(I-ISM1,J-IDM1) )
     &        + AWG6 * ( SA1(I-ISM1,J+IDM ) + SA2(I-ISM1,J-IDM ) )
     &        + AWG7 * ( SA1(I-ISM ,J+IDM1) + SA2(I-ISM ,J-IDM1) )
     &        + AWG8 * ( SA1(I-ISM ,J+IDM ) + SA2(I-ISM ,J-IDM ) )
C
          DSNL(I,ID) =   - 2. * ( DA1C(I,J) + DA2C(I,J) )
     &        + SWG1 * ( DA1P(I-ISP1,J-IDP1) + DA2P(I-ISP1,J+IDP1) )
     &        + SWG2 * ( DA1P(I-ISP1,J-IDP ) + DA2P(I-ISP1,J+IDP ) )
     &        + SWG3 * ( DA1P(I-ISP ,J-IDP1) + DA2P(I-ISP ,J+IDP1) )
     &        + SWG4 * ( DA1P(I-ISP ,J-IDP ) + DA2P(I-ISP ,J+IDP ) )
     &        + SWG5 * ( DA1M(I-ISM1,J+IDM1) + DA2M(I-ISM1,J-IDM1) )
     &        + SWG6 * ( DA1M(I-ISM1,J+IDM ) + DA2M(I-ISM1,J-IDM ) )
     &        + SWG7 * ( DA1M(I-ISM ,J+IDM1) + DA2M(I-ISM ,J-IDM1) )
     &        + SWG8 * ( DA1M(I-ISM ,J+IDM ) + DA2M(I-ISM ,J-IDM ) )
C
C         *** store results in IMATDA and IMATRA ***
C
          IF(TESTFL) THEN
            PLNL4S(ID,I,IPTST) = SFNL(I,ID) / SIGPI                       40.00
            PLNL4D(ID,I,IPTST) = -1. * DSNL(I,ID) / PI3                   40.00
          END IF
C
          IMATRA(ID,I) = IMATRA(ID,I) + SFNL(I,ID) / SIGPI
          IMATDA(ID,I) = IMATDA(ID,I) - DSNL(I,ID) / PI3
C
          IF(ITEST.GE.90 .AND. TESTFL) THEN
            WRITE(PRINTF,9006) I,J,SFNL(I,ID),DSNL(I,ID),
     &       SPCSIG(I)                                                    30.72
 9006       FORMAT (' IS ID SFNL DSNL SPCSIG:',2I4,3E12.4)                30.72
          END IF
C
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST .GE. 50 .AND. TESTFL) THEN
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) ' SWSNL1 subroutine '
        WRITE(PRINTF,9011) IDP, IDP1, IDM, IDM1
 9011   FORMAT (' IDP IDP1 IDM IDM1     :',4I5)
        WRITE (PRINTF,9013) ISP, ISP1, ISM, ISM1
 9013   FORMAT (' ISP ISP1 ISM ISM1     :',4I5)
        WRITE (PRINTF,9015) ISLOW, ISHGH, IDLOW,IDHGH
 9015   FORMAT (' ISLOW ISHGH IDLOW IDHG:',4I5)
        WRITE(PRINTF,9016) ISCLW, ISCHG, IDDLOW, IDDTOP
 9016   FORMAT (' ICLW ICHG IDDLOW IDDTO:',2I5)
        WRITE (PRINTF,9017) AWG1, AWG2, AWG3, AWG4
 9017   FORMAT (' AWG1 AWG2 AWG3 AWG4   :',4E12.4)
        WRITE (PRINTF,9018) AWG5, AWG6, AWG7, AWG8
 9018   FORMAT (' AWG5 AWG6 AWG7 AWG8   :',4E12.4)
        WRITE (PRINTF,9019) MSC4MI, MSC4MA, MDC4MI, MDC4MA
 9019   FORMAT (' S4MI S4MA D4MI D4MA   :',4I6)
        WRITE(PRINTF,9020) SNLC1,X,X2,CONS
 9020   FORMAT (' SNLC1  X  X2  CONS    :',4E12.4)
        WRITE(PRINTF,9021) DEP2(KCGRD(1)),KMESPC, FACHFR, PI
 9021   FORMAT (' DEPTH KMESPC FACHFR PI:',4E12.4)
        WRITE(PRINTF,9023) JACOBI
 9023   FORMAT (' JACOBI                :',E12.4)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     End of the subroutine SWSNL1
      END
C
C*******************************************************************
C
      SUBROUTINE SWSNL2 (IDDLOW  ,IDDTOP  ,WWINT   ,                      34.00
     &                   WWAWG   ,AF11    ,UE      ,SA1     ,ISSTOP  ,
     &                   SA2     ,SPCSIG  ,SNLC1   ,DAL1    ,DAL2    ,    30.72
     &                   DAL3    ,SFNL    ,DEP2    ,AC2     ,KMESPC  ,
     &                                                       IMATRA  ,    34.00
     &                   FACHFR  ,PLNL4S           ,IDCMIN  ,IDCMAX  )    34.00
C
C*******************************************************************
C
      INCLUDE 'swcomm3.inc'                                               34.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  H.L. Tolman, R.C. Ris                          |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
!     40.13: Nico Booij
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
!tst!     40.13, Mar. 01: temporary test in case of array subscript error
C
C  2. Purpose :
C
C     Calculate non-linear interaction using the discrete interaction
C     approximation (Hasselmann and Hasselmann 1985; WAMDI group 1988),
C
C  3. Method :
C
C     Discrete interaction approximation.
C
C                            Frequencies -->
C                 +---+---------------------+---------+- IDHGH
C              d  | 3 :          2          :    2    |
C              i  + - + - - - - - - - - - - + - - - - +- MDC
C              r  |   :                     :         |
C              e  | 3 :  original spectrum  :    1    |
C              c  |   :                     :         |
C              t. + - + - - - - - - - - - - + - - - - +- 1
C                 | 3 :          2          :    2    |
C                 +---+---------------------+---------+- IDLOW
C                 |   |                     |     ^   |
C              ISLOW  1                    MSC    |   ISHGH
C                     |                           |
C                   ISCLW                        ISCHG
C              lowest discrete               highest discrete
C                central bin                    central bin
C
C                            1 : Extra tail added beyond MSC
C                            2 : Spectrum copied outside ID range
C                            3 : Empty bins at low frequencies
C
C     ISLOW =  1  + ISM1
C     ISHGH = MSC + ISP1 - ISM1
C     ISCLW =  1
C     ISCHG = MSC - ISM1
C     IDLOW = IDDLOW - MAX(IDM1,IDP1)
C     IDHGH = IDDTOP + MAX(IDM1,IDP1)
C
C       Realtive offsets of interpolation points around central bin
C       "#" and corresponding numbers of AWGn :
C
C               ISM1  ISM
C                5        7    T |
C          IDM1   +------+     H +
C                 |      |     E |      ISP      ISP1
C                 |   \  |     T |       3           1
C           IDM   +------+     A +        +---------+  IDP1
C                6       \8      |        |         |
C                                |        |  /      |
C                           \    +        +---------+  IDP
C                                |      /4           2
C                              \ |  /
C          -+-----+------+-------#--------+---------+----------+
C                                |           FREQ.
C
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     ---
C
C  8. Structure :
C
C     -------------------------------------------
C       Initialisations.
C       Calculate proportionality constant.
C       Prepare auxiliary spectrum.
C       Calculate (unfolded) interactions :
C       -----------------------------------------
C         Energy at interacting bins
C         Contribution to interactions
C         Fold interactions to side angles
C       -----------------------------------------
C       Put source term together
C     -------------------------------------------
C
C  9. Source code :
C
C*******************************************************************
C
      INTEGER   IS     ,ID     ,I      ,J                      ,ISHGH  ,  34.00
     &          ISSTOP ,ISP    ,ISP1   ,IDP    ,IDP1   ,ISM    ,ISM1   ,
     &          IDM    ,IDM1   ,ISCLW  ,ISCHG  ,                          34.00
     &                  IDLOW  ,IDHGH  ,IDDLOW ,IDDTOP ,IDCLOW ,IDCHGH    34.00
C
      REAL      X      ,X2     ,CONS   ,FACTOR ,SNLCS1 ,SNLCS2 ,SNLCS3 ,
     &          E00    ,EP1    ,EM1    ,EP2    ,EM2    ,SA1A   ,SA1B   ,
     &          SA2A   ,SA2B   ,KMESPC ,FACHFR ,AWG1   ,AWG2   ,AWG3   ,
     &          AWG4   ,AWG5   ,AWG6   ,AWG7   ,AWG8   ,DAL1   ,DAL2   ,
     &          DAL3           ,JACOBI ,SIGPI                             34.00
C
      REAL      AC2(MDC,MSC,MCGRD)                    ,                   30.21
     &          DEP2(MCGRD)                           ,                   30.21
     &          AF11(MSC4MI:MSC4MA )                  ,
     &          UE(MSC4MI:MSC4MA , MDC4MI:MDC4MA )    ,
     &          SA1(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &          SA2(MSC4MI:MSC4MA , MDC4MI:MDC4MA )   ,
     &          SFNL(MSC4MI:MSC4MA , MDC4MI:MDC4MA)   ,
     &          IMATRA(MDC,MSC)                       ,
     &          PLNL4S(MDC,MSC,NPTST)                 ,                   40.00
     &          WWAWG(*)
C
      INTEGER   WWINT(*)         ,
     &          IDCMIN(MSC)      ,
     &          IDCMAX(MSC)
C
      LOGICAL   PERCIR
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWSNL2')
C
      IDP    = WWINT(1)
      IDP1   = WWINT(2)
      IDM    = WWINT(3)
      IDM1   = WWINT(4)
      ISP    = WWINT(5)
      ISP1   = WWINT(6)
      ISM    = WWINT(7)
      ISM1   = WWINT(8)
      ISLOW  = WWINT(9)
      ISHGH  = WWINT(10)
      ISCLW  = WWINT(11)
      ISCHG  = WWINT(12)
      IDLOW  = WWINT(13)
      IDHGH  = WWINT(14)
C
      AWG1 = WWAWG(1)
      AWG2 = WWAWG(2)
      AWG3 = WWAWG(3)
      AWG4 = WWAWG(4)
      AWG5 = WWAWG(5)
      AWG6 = WWAWG(6)
      AWG7 = WWAWG(7)
      AWG8 = WWAWG(8)
C
C     *** Initialize auxiliary arrays per gridpoint ***
C
      DO ID = MDC4MI, MDC4MA
        DO IS = MSC4MI, MSC4MA
          UE(IS,ID)   = 0.
          SA1(IS,ID)  = 0.
          SA2(IS,ID)  = 0.
          SFNL(IS,ID) = 0.
        ENDDO
      ENDDO
C
C     *** Calculate prop. constant.                           ***
C     *** Calculate factor R(X) to calculate the NL wave-wave ***
C     *** interaction for shallow water                       ***
C     *** SNLC1 = CONSTANT * GRAV**-4                         ***
C
      SNLCS1 = PQUAD(3)                                                   34.00
      SNLCS2 = PQUAD(4)                                                   34.00
      SNLCS3 = PQUAD(5)                                                   34.00
      X      = MAX ( 0.75 * DEP2(KCGRD(1)) * KMESPC , 0.5 )
      X2     = MAX ( -1.E15, SNLCS3*X)
      CONS   = SNLC1 * ( 1. + SNLCS1/X * (1.-SNLCS2*X) * EXP(X2))
      JACOBI = 2. * PI
C
C     *** check wheter the spectral domain is periodic in ***
C     *** direction space and if so modify boundaries     ***
C
      PERCIR = .FALSE.
      IF ( IDDLOW .EQ. 1 .AND. IDDTOP .EQ. MDC ) THEN
C       *** periodic in theta -> spectrum can be volded  ***
C       *** (can only occur in presence of a current)    ***
        IDCLOW = 1
        IDCHGH = MDC
        IIID   = 0
        PERCIR = .TRUE.
      ELSE
C       *** dfferent sectors per sweep -> extend range with IIID ***
        IIID   = MAX ( IDM1 , IDP1 )
        IDCLOW = IDLOW
        IDCHGH = IDHGH
      ENDIF
C
C     *** Prepare auxiliary spectrum               ***
C     *** set action original spectrum in array UE ***
C
      DO IDDUM = IDLOW - IIID , IDHGH + IIID
        ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        DO IS = 1, MSC
          UE(IS,IDDUM) = AC2(ID,IS,KCGRD(1)) * SPCSIG(IS) * JACOBI        30.72
        ENDDO
      ENDDO
C
C     *** set values in the areas 2 for IS > MSC+1 ***
C
      DO IS = MSC+1, ISHGH
        DO ID = IDLOW - IIID , IDHGH + IIID
          UE (IS,ID) = UE(IS-1,ID) * FACHFR
        ENDDO
      ENDDO
C
C     *** Calculate interactions      ***
C     *** Energy at interacting bins  ***
C
      DO IS = ISCLW, ISCHG
        DO ID = IDCLOW , IDCHGH
          E00    =        UE(IS      ,ID      )
          EP1    = AWG1 * UE(IS+ISP1,ID+IDP1) +
     &             AWG2 * UE(IS+ISP1,ID+IDP ) +
     &             AWG3 * UE(IS+ISP ,ID+IDP1) +
     &             AWG4 * UE(IS+ISP ,ID+IDP )
          EM1    = AWG5 * UE(IS+ISM1,ID-IDM1) +
     &             AWG6 * UE(IS+ISM1,ID-IDM ) +
     &             AWG7 * UE(IS+ISM ,ID-IDM1) +
     &             AWG8 * UE(IS+ISM ,ID-IDM )
C
          EP2    = AWG1 * UE(IS+ISP1,ID-IDP1) +
     &             AWG2 * UE(IS+ISP1,ID-IDP ) +
     &             AWG3 * UE(IS+ISP ,ID-IDP1) +
     &             AWG4 * UE(IS+ISP ,ID-IDP )
          EM2    = AWG5 * UE(IS+ISM1,ID+IDM1) +
     &             AWG6 * UE(IS+ISM1,ID+IDM ) +
     &             AWG7 * UE(IS+ISM ,ID+IDM1) +
     &             AWG8 * UE(IS+ISM ,ID+IDM )
C
C         *** Contribution to interactions                          ***
C         *** CONS is the shallow water factor for the NL interact. ***
C
          FACTOR = CONS * AF11(IS) * E00
C
          SA1A   = E00 * ( EP1*DAL1 + EM1*DAL2 )
          SA1B   = SA1A - EP1*EM1*DAL3
          SA2A   = E00 * ( EP2*DAL1 + EM2*DAL2 )
          SA2B   = SA2A - EP2*EM2*DAL3
C
          SA1 (IS,ID) = FACTOR * SA1B
          SA2 (IS,ID) = FACTOR * SA2B
C
          IF(ITEST.GE.100 .AND. TESTFL) THEN
            WRITE(PRINTF,9002) E00,EP1,EM1,EP2,EM2
 9002       FORMAT (' E00 EP1 EM1 EP2 EM2  :',5E11.4)
            WRITE(PRINTF,9003) SA1A,SA1B,SA2A,SA2B
 9003       FORMAT (' SA1A SA1B SA2A SA2B  :',4E11.4)
            WRITE(PRINTF,9004) IS,ID,SA1(IS,ID),SA2(IS,ID)
 9004       FORMAT (' IS ID SA1() SA2()    :',2I4,2E12.4)
            WRITE(PRINTF,9005) FACTOR ,ISLOW
 9005       FORMAT (' FACTOR ISLOW         : ',E12.4,I4)
          END IF
C
        ENDDO
      ENDDO
C
C     *** Fold interactions to side angles if spectral domain ***
C     *** is periodic in directional space                    ***
C
      IF ( PERCIR ) THEN
        DO ID = 1, IDHGH - MDC
          ID0   = 1 - ID
          DO IS = ISCLW, ISCHG
            SA1 (IS,MDC+ID) = SA1 (IS ,  ID    )
            SA2 (IS,MDC+ID) = SA2 (IS ,  ID    )
            SA1 (IS,  ID0 ) = SA1 (IS , MDC+ID0)
            SA2 (IS,  ID0 ) = SA2 (IS , MDC+ID0)
          ENDDO
        ENDDO
      ENDIF
C
C     ***  Put source term together (To save space I=IS and J=ID ***
C     ***  is used)                                              ***
C
      DO I = 1, ISSTOP
        SIGPI = SPCSIG(I) * JACOBI                                        30.72
        DO J = IDCMIN(I), IDCMAX(I)
          ID = MOD ( J - 1 + MDC , MDC ) + 1
!tst!         temporary test in case of array subscript problem               40.13
!tst          IF (I     .LT.MSC4MI .OR. I     .GT.MSC4MA .OR.                 40.13
!tst     &        I-ISP .LT.MSC4MI .OR. I-ISP .GT.MSC4MA .OR.
!tst     &        I-ISP1.LT.MSC4MI .OR. I-ISP1.GT.MSC4MA .OR.
!tst     &        I-ISM .LT.MSC4MI .OR. I-ISM .GT.MSC4MA .OR.
!tst     &        I-ISM1.LT.MSC4MI .OR. I-ISM1.GT.MSC4MA .OR.
!tst     &        ID    .LT.MDC4MI .OR. ID    .GT.MDC4MA .OR.
!tst     &        J     .LT.MDC4MI .OR. J     .GT.MDC4MA .OR.
!tst     &        J+IDP .LT.MDC4MI .OR. J+IDP .GT.MDC4MA .OR.
!tst     &        J-IDP .LT.MDC4MI .OR. J-IDP .GT.MDC4MA .OR.
!tst     &        J+IDP1.LT.MDC4MI .OR. J+IDP1.GT.MDC4MA .OR.
!tst     &        J-IDP1.LT.MDC4MI .OR. J-IDP1.GT.MDC4MA .OR.
!tst     &        J+IDM .LT.MDC4MI .OR. J+IDM .GT.MDC4MA .OR.
!tst     &        J-IDM .LT.MDC4MI .OR. J-IDM .GT.MDC4MA .OR.
!tst     &        J+IDM1.LT.MDC4MI .OR. J+IDM1.GT.MDC4MA .OR.
!tst     &        J-IDM1.LT.MDC4MI .OR. J-IDM1.GT.MDC4MA) THEN
!tst            WRITE (PRTEST, 136) I, ISSTOP, ISP, ISP1, ISM1,
!tst     &        MSC4MI, MSC4MA,
!tst     &        J, ID, IDCMIN(I), IDCMAX(I), IDP, IDP1, IDM, IDM1,
!tst     &        MDC4MI, MDC4MA
!tst 136        FORMAT (' err SWSNL2, is:', 7I5, ', id:', 11I5)
!tst          ENDIF
          SFNL(I,ID) =   - 2. * ( SA1(I,J) + SA2(I,J) )
     &        + AWG1 * ( SA1(I-ISP1,J-IDP1) + SA2(I-ISP1,J+IDP1) )
     &        + AWG2 * ( SA1(I-ISP1,J-IDP ) + SA2(I-ISP1,J+IDP ) )
     &        + AWG3 * ( SA1(I-ISP ,J-IDP1) + SA2(I-ISP ,J+IDP1) )
     &        + AWG4 * ( SA1(I-ISP ,J-IDP ) + SA2(I-ISP ,J+IDP ) )
     &        + AWG5 * ( SA1(I-ISM1,J+IDM1) + SA2(I-ISM1,J-IDM1) )
     &        + AWG6 * ( SA1(I-ISM1,J+IDM ) + SA2(I-ISM1,J-IDM ) )
     &        + AWG7 * ( SA1(I-ISM ,J+IDM1) + SA2(I-ISM ,J-IDM1) )
     &        + AWG8 * ( SA1(I-ISM ,J+IDM ) + SA2(I-ISM ,J-IDM ) )
C
C         *** store results in rhv ***
C
          IF(TESTFL) PLNL4S(ID,I,IPTST) =  SFNL(I,ID) / SIGPI             40.00
          IMATRA(ID,I) = IMATRA(ID,I) + SFNL(I,ID) / SIGPI
C
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST .GE. 40 .AND. TESTFL) THEN
        WRITE(PRINTF,*) ' SWSNL2 subroutine '
        WRITE(PRINTF,9011) IDP, IDP1, IDM, IDM1
 9011   FORMAT (' IDP IDP1 IDM IDM1     :',4I5)
        WRITE (PRINTF,9013) ISP, ISP1, ISM, ISM1
 9013   FORMAT (' ISP ISP1 ISM ISM1     :',4I5)
        WRITE (PRINTF,9015) ISHGH, IDDLOW, IDDTOP
 9015   FORMAT (' ISHG IDDLOW IDDTOP    :',3I5)
        WRITE(PRINTF,9016) ISCLW, ISCHG, IDLOW, IDHGH
 9016   FORMAT (' ICLW ICHG IDLOW IDHGH :',4I5)
        WRITE (PRINTF,9017) AWG1, AWG2, AWG3, AWG4
 9017   FORMAT (' AWG1 AWG2 AWG3 AWG4   :',4E12.4)
        WRITE (PRINTF,9018) AWG5, AWG6, AWG7, AWG8
 9018   FORMAT (' AWG5 AWG6 AWG7 AWG8   :',4E12.4)
        WRITE (PRINTF,9019) MSC4MI, MSC4MA, MDC4MI, MDC4MA
 9019   FORMAT (' S4MI S4MA D4MI D4MA   :',4I6)
        WRITE(PRINTF,9020) SNLC1,X,X2,CONS
 9020   FORMAT (' SNLC1  X  X2  CONS    :',4E12.4)
        WRITE(PRINTF,9021) DEP2(KCGRD(1)),KMESPC, FACHFR,PI
 9021   FORMAT (' DEPTH KMESPC FACHFR PI:',4E12.4)
        WRITE(PRINTF,9023) JACOBI,ISLOW
 9023   FORMAT (' JACOBI  ISLOW         :',E12.4,I4)
        WRITE(PRINTF,*)
      END IF
C
      RETURN
C     End of SWSNL2
      END
C
C************************************************************
C
      SUBROUTINE SWSNL3 (MDC     ,MSC     ,WWINT   ,WWAWG   ,AF11    ,
     &                   UE      ,SA1     ,SA2     ,SPCSIG  ,SNLC1   ,    30.72
     &                   DAL1    ,DAL2    ,DAL3    ,SFNL    ,DEP2    ,
     &                   AC2     ,KMESPC  ,MEMNL4  ,FACHFR  ,PI      ,
     &                   MSC4MI  ,MSC4MA  ,MDC4MI  ,MDC4MA  ,KCGRD   ,
     &                   MCGRD   ,ICMAX                              )    30.21
 
C
C*******************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
*
*   --|-----------------------------------------------------------|--
*     |            Delft University of Technology                 |
*     | Faculty of Civil Engineering, Fluid Mechanics Group       |
*     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
*     |                                                           |
*     | Authors :  H.L. Tolman, R.C. Ris                          |
*   --|-----------------------------------------------------------|--
*
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C
C  2. Purpose
C
C     Calculate non-linear interaction using the discrete interaction
C     approximation (Hasselmann and Hasselmann 1985; WAMDI group 1988)
C     for the full circle (option if a current is present). Note: using
C     this subroutine requires an additional array with size
C     (MXC*MYC*MDC*MSC). This requires more internal memory but can
C     speed up the computations sigificantly if a current is present.
C
C  3. Method
C
C     Discrete interaction approximation. To make interpolation simple,
C     the interactions are calculated an a "volded" space.
C
C                            Frequencies -->
C                 +---+---------------------+---------+- IDHGH
C              d  | 3 :          2          :    2    |
C              i  + - + - - - - - - - - - - + - - - - +- MDC
C              r  |   :                     :         |
C              e  | 3 :  original spectrum  :    1    |
C              c  |   :                     :         |
C              t. + - + - - - - - - - - - - + - - - - +- 1
C                 | 3 :          2          :    2    |
C                 +---+---------------------+---------+- IDLOW
C                 |   |                     |     ^   |
C              ISLOW  1                    MSC    |   ISHGH
C                     |                           |
C                   ISCLW                        ISCHG
C              lowest discrete               highest discrete
C                central bin                    central bin
C
C                            1 : Extra tail added beyond MSC
C                            2 : Spectrum copied outside ID range
C                            3 : Empty bins at low frequencies
C
C     ISLOW =  1  + ISM1
C     ISHGH = MSC + ISP1 - ISM1
C     ISCLW =  1
C     ISCHG = MSC - ISM1
C     IDLOW =  1  - MAX(IDM1,IDP1)
C     IDHGH = MDC + MAX(IDM1,IDP1)
C
C       Realtive offsets of interpolation points around central bin
C       "#" and corresponding numbers of AWGn :
C
C               ISM1  ISM
C                5        7    T |
C          IDM1   +------+     H +
C                 |      |     E |      ISP      ISP1
C                 |   \  |     T |       3           1
C           IDM   +------+     A +        +---------+  IDP1
C                6       \8      |        |         |
C                                |        |  /      |
C                           \    +        +---------+  IDP
C                                |      /4           2
C                              \ |  /
C          -+-----+------+-------#--------+---------+----------+
C                                |           FREQ.
C
C
C  4. Argument variables
C
C     ICMAX : number of points in computational stencil
C     KCGRD : grid address of points of computational stencil
C     MCGRD : number of wet grid points of the computational grid
C     MDC   : grid points in theta-direction of computational grid
C     MDC4MA: highest array counter in directional space (Snl4)
C     MDC4MI: lowest array counter in directional space (Snl4)
C     MSC   : grid points in sigma-direction of computational grid
C     MSC4MA: highest array counter in frequency space (Snl4)
C     MSC4MI: lowest array counter in frequency space (Snl4)
C     WWINT : counters for quadruplet interactions
C       ( 1):
C
      INTEGER ICMAX, MCGRD, MDC, MDC4MA, MDC4MI, MSC ,MSC4MA ,MSC4MI
      INTEGER KCGRD(ICMAX)
      INTEGER WWINT(*)
C
C     AC2   : action density
C     AF11  : scaling frequency
C     DAL1  : coefficient for the quadruplet interactions
C     DAL2  : coefficient for the quadruplet interactions
C     DAL3  : coefficient for the quadruplet interactions
C     DEP2  : depth
C     FACHFR
C     KMESPC: mean average wavenumber over full spectrum
C     MEMNL4
C     PI    : circular constant
C     SA1   : interaction contribution of first quadruplet (unfolded space)
C     SA2   : interaction contribution of second quadruplet (unfolded space)
C     SFNL
C     SNLC1
C     SPCSIG: relative frequencies in computational domain in sigma-space
C     UE    : "unfolded" spectrum
C     WWAWG : weight coefficients for the quadruplet interactions
C
      REAL    DAL1, DAL2, DAL3, FACHFR, KMESPC, PI, SNLC1
      REAL    AC2(MDC,MSC,MCGRD)
      REAL    AF11(MSC4MI:MSC4MA)
      REAL    DEP2(MCGRD)
      REAL    MEMNL4(MDC,MSC,MCGRD)
      REAL    SA1(MSC4MI:MSC4MA,MDC4MI:MDC4MA)
      REAL    SA2(MSC4MI:MSC4MA,MDC4MI:MDC4MA)
      REAL    SFNL(MSC4MI:MSC4MA,MDC4MI:MDC4MA)
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    UE(MSC4MI:MSC4MA,MDC4MI:MDC4MA)
      REAL    WWAWG(*)
C
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     ---
C
C  8. Structure :
C
C     -------------------------------------------
C       Initialisations.
C       Calculate proportionality constant.
C       Prepare auxiliary spectrum.
C       Calculate (unfolded) interactions :
C       -----------------------------------------
C         Energy at interacting bins
C         Contribution to interactions
C         Fold interactions to side angles
C       -----------------------------------------
C       Put source term together
C     -------------------------------------------
C
C  9. Source code :
C
C*******************************************************************
C
      INTEGER   IS      ,ID      ,ID0     ,I       ,J       ,
     &          ISHGH   ,IDLOW   ,IDHGH   ,ISP     ,ISP1    ,
     &          IDP     ,IDP1    ,ISM     ,ISM1    ,IDM     ,IDM1    ,
     &          ISCLW   ,ISCHG
C
      REAL      X       ,X2      ,CONS    ,FACTOR  ,SNLCS2  ,
     &          SNLCS3  ,E00     ,EP1     ,EM1     ,EP2     ,EM2     ,
     &          SA1A    ,SA1B    ,SA2A    ,SA2B    ,
     &          AWG1    ,AWG2    ,AWG3    ,AWG4    ,AWG5    ,AWG6    ,
     &          AWG7    ,AWG8    ,
     &          JACOBI  ,SIGPI
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'SWSNL3')
C
      IDP    = WWINT(1)
      IDP1   = WWINT(2)
      IDM    = WWINT(3)
      IDM1   = WWINT(4)
      ISP    = WWINT(5)
      ISP1   = WWINT(6)
      ISM    = WWINT(7)
      ISM1   = WWINT(8)
      ISLOW  = WWINT(9)
      ISHGH  = WWINT(10)
      ISCLW  = WWINT(11)
      ISCHG  = WWINT(12)
      IDLOW  = WWINT(13)
      IDHGH  = WWINT(14)
C
      AWG1 = WWAWG(1)
      AWG2 = WWAWG(2)
      AWG3 = WWAWG(3)
      AWG4 = WWAWG(4)
      AWG5 = WWAWG(5)
      AWG6 = WWAWG(6)
      AWG7 = WWAWG(7)
      AWG8 = WWAWG(8)
C
C     *** Initialize auxiliary arrays per gridpoint ***
C
      DO ID = MDC4MI, MDC4MA
        DO IS = MSC4MI, MSC4MA
          UE(IS,ID)   = 0.
          SA1(IS,ID)  = 0.
          SA2(IS,ID)  = 0.
          SFNL(IS,ID) = 0.
        ENDDO
      ENDDO
C
C     *** Calculate prop. constant.                           ***
C     *** Calculate factor R(X) to calculate the NL wave-wave ***
C     *** interaction for shallow water                       ***
C     *** SNLC1 = CONSTANT * GRAV**-4                         ***
C
      SNLCS1 =  5.5
      SNLCS2 =  0.833
      SNLCS3 = -1.25
      X      = MAX ( 0.75 * DEP2(KCGRD(1)) * KMESPC , 0.5 )               30.21
      X2     = MAX ( -1.E15, SNLCS3*X)
      CONS   = SNLC1 * ( 1. + SNLCS1/X * (1.-SNLCS2*X) * EXP(X2))
      JACOBI = 2. * PI
C
C     *** extend the area with action density at periodic boundaries***
C
      DO IDDUM = IDLOW, IDHGH
        ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
        DO IS=1, MSC
          UE (IS,IDDUM) = AC2(ID,IS,KCGRD(1)) * SPCSIG(IS) * JACOBI       30.72
        ENDDO
      ENDDO
C
      DO IS = MSC+1, ISHGH
        DO ID = IDLOW, IDHGH
          UE(IS,ID) = UE(IS-1,ID) * FACHFR
        ENDDO
      ENDDO
C
C     *** Calculate (unfolded) interactions ***
C     *** Energy at interacting bins        ***
C
      DO IS = ISCLW, ISCHG
        DO ID = 1, MDC
          E00    =        UE(IS      ,ID      )
          EP1    = AWG1 * UE(IS+ISP1,ID+IDP1) +
     &             AWG2 * UE(IS+ISP1,ID+IDP ) +
     &             AWG3 * UE(IS+ISP ,ID+IDP1) +
     &             AWG4 * UE(IS+ISP ,ID+IDP )
          EM1    = AWG5 * UE(IS+ISM1,ID-IDM1) +
     &             AWG6 * UE(IS+ISM1,ID-IDM ) +
     &             AWG7 * UE(IS+ISM ,ID-IDM1) +
     &             AWG8 * UE(IS+ISM ,ID-IDM )
          EP2    = AWG1 * UE(IS+ISP1,ID-IDP1) +
     &             AWG2 * UE(IS+ISP1,ID-IDP ) +
     &             AWG3 * UE(IS+ISP ,ID-IDP1) +
     &             AWG4 * UE(IS+ISP ,ID-IDP )
          EM2    = AWG5 * UE(IS+ISM1,ID+IDM1) +
     &             AWG6 * UE(IS+ISM1,ID+IDM ) +
     &             AWG7 * UE(IS+ISM ,ID+IDM1) +
     &             AWG8 * UE(IS+ISM ,ID+IDM )
C
C         Contribution to interactions
C
          FACTOR = CONS * AF11(IS) * E00
C
          SA1A   = E00 * ( EP1*DAL1 + EM1*DAL2 )
          SA1B   = SA1A - EP1*EM1*DAL3
          SA2A   = E00 * ( EP2*DAL1 + EM2*DAL2 )
          SA2B   = SA2A - EP2*EM2*DAL3
C
          SA1 (IS,ID) = FACTOR * SA1B
          SA2 (IS,ID) = FACTOR * SA2B
C
          IF(ITEST.GE.100 .AND. TESTFL) THEN
            WRITE(PRINTF,9002) E00,EP1,EM1,EP2,EM2
 9002       FORMAT (' E00 EP1 EM1 EP2 EM2  :',5E11.4)
            WRITE(PRINTF,9003) SA1A,SA1B,SA2A,SA2B
 9003       FORMAT (' SA1A SA1B SA2A SA2B  :',4E11.4)
            WRITE(PRINTF,9004) IS,ID,SA1(IS,ID),SA2(IS,ID)
 9004       FORMAT (' IS ID SA1() SA2()    :',2I4,2E12.4)
            WRITE(PRINTF,9005) FACTOR,JACOBI
 9005       FORMAT (' FACTOR JACOBI        : ',2E12.4)
          END IF
C
        ENDDO
      ENDDO
C
C     *** Fold interactions to side angles -> domain in theta is ***
C     *** periodic                                               ***
C
      DO ID = 1, IDHGH - MDC
        ID0   = 1 - ID
        DO IS = ISCLW, ISCHG
          SA1 (IS,MDC+ID) = SA1 (IS,  ID   )
          SA2 (IS,MDC+ID) = SA2 (IS,  ID   )
          SA1 (IS,  ID0 ) = SA1 (IS,MDC+ID0)
          SA2 (IS,  ID0 ) = SA2 (IS,MDC+ID0)
        ENDDO
      ENDDO
C
C     *** Put source term together (To save space I=IS and ***
C     *** J=MDC is used)  ----                             ***
C
      DO I = 1, MSC
        SIGPI = SPCSIG(I) * JACOBI                                        30.72
        DO J = 1, MDC
          SFNL(I,J) =   - 2. * ( SA1(I,J) + SA2(I,J) )
     &        + AWG1 * ( SA1(I-ISP1,J-IDP1) + SA2(I-ISP1,J+IDP1) )
     &        + AWG2 * ( SA1(I-ISP1,J-IDP ) + SA2(I-ISP1,J+IDP ) )
     &        + AWG3 * ( SA1(I-ISP ,J-IDP1) + SA2(I-ISP ,J+IDP1) )
     &        + AWG4 * ( SA1(I-ISP ,J-IDP ) + SA2(I-ISP ,J+IDP ) )
     &        + AWG5 * ( SA1(I-ISM1,J+IDM1) + SA2(I-ISM1,J-IDM1) )
     &        + AWG6 * ( SA1(I-ISM1,J+IDM ) + SA2(I-ISM1,J-IDM ) )
     &        + AWG7 * ( SA1(I-ISM ,J+IDM1) + SA2(I-ISM ,J-IDM1) )
     &        + AWG8 * ( SA1(I-ISM ,J+IDM ) + SA2(I-ISM ,J-IDM ) )
C
C         *** store value in auxiliary array and use values in ***
C         *** next fout sweeps (see subroutine FILSNL3)        ***
C
          MEMNL4(J,I,KCGRD(1)) = SFNL(I,J) / SIGPI                        30.21
        ENDDO
      ENDDO
C
C     *** test output ***
C
      IF (ITEST .GE. 50 .AND. TESTFL) THEN
        WRITE(PRINTF,*)
        WRITE(PRINTF,*) ' SWSNL3 subroutine '
        WRITE(PRINTF,9011) IDP, IDP1, IDM, IDM1
 9011   FORMAT (' IDP IDP1 IDM IDM1     :',4I5)
        WRITE (PRINTF,9013) ISP, ISP1, ISM, ISM1
 9013   FORMAT (' ISP ISP1 ISM ISM1     :',4I5)
        WRITE (PRINTF,9015) ISLOW, ISHGH, IDLOW, IDHGH
 9015   FORMAT (' ISLOW ISHG IDLOW IDHG :',4I5)
        WRITE(PRINTF,9016) ISCLW, ISCHG, JACOBI
 9016   FORMAT (' ICLW ICHG JACOBI      :',2I5,E12.4)
        WRITE (PRINTF,9017) AWG1, AWG2, AWG3, AWG4
 9017   FORMAT (' AWG1 AWG2 AWG3 AWG4   :',4E12.4)
        WRITE (PRINTF,9018) AWG5, AWG6, AWG7, AWG8
 9018   FORMAT (' AWG5 AWG6 AWG7 AWG8   :',4E12.4)
        WRITE (PRINTF,9019) MSC4MI, MSC4MA, MDC4MI, MDC4MA
 9019   FORMAT (' S4MI S4MA D4MI D4MA   :',4I6)
        WRITE(PRINTF,9020) SNLC1,X,X2,CONS
 9020   FORMAT (' SNLC1  X  X2  CONS    :',4E12.4)
        WRITE(PRINTF,9021) DEP2(KCGRD(1)),KMESPC,FACHFR,PI
 9021   FORMAT (' DEPTH KMESPC FACHFR PI:',4E12.4)
        WRITE(PRINTF,*)
C
C       *** value source term in every bin ***
C
        IF(ITEST.GE. 150 ) THEN
          DO I=1, MSC
            DO J=1, MDC
              WRITE(PRINTF,2006) I,J,MEMNL4(J,I,KCGRD(1)),SFNL(I,J),      30.21
     &                           SPCSIG(I)                                30.72
 2006         FORMAT (' I J MEMNL() SFNL() SPCSIG:',2I4,3E12.4)           30.72
            ENDDO
          ENDDO
        END IF
      END IF
C
      RETURN
C
C     End of subroutine SWSNL3
C
      END
C
C*******************************************************************
C
      SUBROUTINE FILNL3 (MDC     ,MSC     ,IDCMIN  ,IDCMAX  ,IMATRA  ,
     &                   MEMNL4  ,PLNL4S  ,ISSTOP  ,KCGRD   ,MCGRD   ,
     &                   ICMAX                                       )    30.21
C
C*******************************************************************
C
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  1. Purpose :
C
C
C     Fill the IMATRA array with the nonlinear wave wave interaction
C     source term for a gridpoint ix,iy per sweep direction
C
C  2. Method :
C
C
C  3. Parameters used :
C
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     ---
C
C  8. Structure :
C
C     -------------------------------------------
C     Do for every frequency and spectral direction within a sweep
C         fill IMATRA
C     -------------------------------------------
C     End of FILNL3
C     -------------------------------------------
C
C  9. Source code :
C
C*******************************************************************
C
      INTEGER   IS      ,ID      ,MSC     ,MDC     ,ISSTOP   ,MCGRD   ,
     &          ICMAX                                                     30.21
C
      INTEGER   KCGRD(ICMAX)                                              30.21
C
      REAL      IMATRA(MDC,MSC)           ,
     &          PLNL4S(MDC,MSC,NPTST)     ,                               40.00
     &          MEMNL4(MDC,MSC,MCGRD)                                     30.21
C
      INTEGER   IDCMIN(MSC)         ,
     &          IDCMAX(MSC)
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'FILNL3')
C
      DO 990 IS=1, ISSTOP
        DO 980 IDDUM = IDCMIN(IS), IDCMAX(IS)
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
          IF(TESTFL) PLNL4S(ID,IS,IPTST) = MEMNL4(ID,IS,KCGRD(1))         40.00
          IMATRA(ID,IS) = IMATRA(ID,IS) + MEMNL4(ID,IS,KCGRD(1))          30.21
  980   CONTINUE
  990 CONTINUE
C
      IF ( TESTFL .AND. ITEST.GE.50 ) THEN
        WRITE(PRINTF,9000) IDCMIN(1),IDCMAX(1),MSC,ISSTOP
 9000   FORMAT(' FILNL3: ID_MIN ID_MAX MSC ISTOP :',4I6)
        IF ( ITEST .GE. 100 ) THEN
          DO IS=1, ISSTOP
            DO IDDUM = IDCMIN(IS), IDCMAX(IS)
              ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
              WRITE(PRINTF,6001) IS,ID,MEMNL4(ID,IS,KCGRD(1))             30.21
 6001         FORMAT(' FILNL3: IS ID MEMNL()          :',2I6,E12.4)
            ENDDO
          ENDDO
        ENDIF
      ENDIF
C
      RETURN
C     End of FILNL3
      END
C
C********************************************************************
C    !!!!  old version, replaced by subroutine STRIAN  !!!!!!!!!!!!
C********************************************************************
C
      SUBROUTINE STRIAD (AC2     ,DEP2    ,CGO     ,IMATRA  ,KWAVE   ,
     &                   HS      ,IDDLOW  ,IDDTOP  ,
     &                   SPCSIG  ,SMEBRK  ,IMATDA  ,PLTRI   ,URSELL  )    40.03
C
C********************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.80
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C
C  1. Updates
C
C     30.50         : EXP is renamed TRIEXP to avoid confusion with
C                     standard function EXP; EXP is made FALSE
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.80, Aug. 99: include file swcomm3.inc added
C     40.03, Apr. 00: computation of Ursell moved to subr SDISPA
C
C  2. Purpose :
C
C     This is a program to model the triad self-interaction based on
C     Boussinesq equation.
C
C     author : Y. ELDEBERKY
C     update : 17 March 1995
C
C     Subroutine has been recoded and optimized (12-09-1995) by
C     R.C. Ris.
C     The procedure has been modified such that an explicit or an
C     implicit scheme for the triad interaction source trem can be used.
C
C  3. Method :  review for the counters :
C
C
C  4. Argument variables
C
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCSIG(MSC)                                                 30.72
C
C     INTEGER
C     -------
C     i             Frequency counter at central bin
C     j             Frequency counter at (higher and lower) harmonic bin
C     MSC,MDC       Range of the original arrays
C     IDDLOW/IDDTOP minimum, maximum counter in directional space
C     IRES          counter that represents the resonance condition in
C                   discrete freq. grid. Is a constant for logaritmic
C                   distribution
C     ISMAX         maximum counter for which the triad formulation
C                   is valid and should be applied
C
C     REALS:
C     ------
C     DPI           two times PI
C     Wi, Wj        radian frequency at central and interacting freq.
C                   bin, respectively
C     WNi,WNj       wavenumber at central and interacting freq.
C                   bin, respectively
C     CGi,CGj       Group velocity at central and interacting freq.
C                   bin, respectively
C     SMEBRK        mean frequency according to first oder moment
C                   (see subroutine SDISPA)
C     XISTRI        Rate between two succeding freq. counters
C
C     ARRAY:
C     ------
C     DEP2          depth at ix,iy
C     KWAVE         wave number
C     CGO           group velocity
C     AC2           action density as function of d,s,x,y at time t
C     E             energy density as functiion of d,f,x,y
C     IMATRA        right hand vector
C     IMATDA        diagonal
C
C  4. Subroutines used :
C
C     ---
C
C  5. Called by :
C
C     SOURCE
C
C  6. Error messages :
C
C     ---
C
C  7. Source code :
C
C     -----------------------------------------------------------------
C     Calculate :
C
C     -----------------------------------------------------------
C     End of the subroutine STRIAD
C     ----------------------------------------------------------
C
C*************************************************************
C
      INTEGER   IS      ,ID      ,                           IDDLOW  ,
     &          IDDTOP  ,         IDDUM   ,IRES    ,I       ,J       ,
     &          ISMAX   ,I1      ,I2                                      30.21
C
      REAL               DEP     ,DEP_2   ,DEP_3   ,         DPI     ,
     &          FT      ,RHV_i   ,RHV_j   ,DIA_i   ,DIA_j   ,B       ,
     &          ALPHA   ,BETA    ,XISTRI  ,SMEBRK  ,         BIPH    ,
     &          SINBPH  ,JACi    ,JACj    ,Wi      ,Wj      ,WNi     ,
     &          WNj     ,CGi     ,CGj     ,HS      ,TMN
C
      REAL  ::  AC2(MDC,MSC,MCGRD)
      REAL  ::  DEP2(MCGRD)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  ::  KWAVE(MSC,MICMAX)                                         40.22
      REAL  ::  IMATRA(MDC,MSC)
      REAL  ::  IMATDA(MDC,MSC)
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL  ::  CGO(MSC,MICMAX)                                           40.22
      REAL  ::  PLTRI(MDC,MSC,NPTST)
      REAL  ::  URSELL(MCGRD)                                             40.03
      REAL              :: E(1:MSC)                                       NRL
C
      LOGICAL   TRIEXP
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRIAD')
C
C     *** initialization of variables ***
C
      DPI   = 2. * PI
      DEP   = DEP2(KCGRD(1))                                              30.21
      DEP_2 = DEP**2
      DEP_3 = DEP**3
      B     = 1. / 15.
      IF (ITRIAD.EQ.1) THEN
*       implicit computation
        TRIEXP = .FALSE.
      ELSE
*       explicit computation
        TRIEXP = .TRUE.
      ENDIF
C
C     *** determine resonance condition and determine maximum  ***
C     *** discrete counter for 3. "peak" frequency in Hz       ***
C
      I2     = INT (FLOAT(MSC) / 2.)
      I1     = I2 - 1
      XISTRI = SPCSIG(I2) / SPCSIG(I1)                                    30.72
      IRES   = NINT ( LOG( 2.) / LOG ( XISTRI ) )
C
      ISMAX = 1                                                           20.88
      DO IS = 1, MSC
        IF ( SPCSIG(IS) .LT. ( PTRIAD(2) * SMEBRK) ) THEN                 30.72
          ISMAX = IS
        ENDIF
      ENDDO
      ISMAX = MAX ( ISMAX , IRES + 1 )
C
C     *** calculate Ursell number (TMN is average period in sec) ***
C
      TMN = DPI / SMEBRK
      URSELL = (GRAV * HS * TMN**2) / (SQRT(2.) * 2. * DPI**2 * DEP_2)
      URSELL(KCGRD(1)) = MIN ( URSELL(KCGRD(1)) , 10. )
      IF (URSELL(KCGRD(1)) .LT. 0.1) THEN
        BIPH = 0.0
      ELSE
        BIPH = - DPI / 8. * ( LOG10(URSELL(KCGRD(1))) + 1.)
      ENDIF
      SINBPH = ABS( SIN(BIPH) )
C
      IF ( URSELL(KCGRD(1)) .GE. 0.1 ) THEN
        DO IDDUM = IDDLOW, IDDTOP
          ID = MOD ( IDDUM - 1 + MDC , MDC ) + 1
C
          IF ( ITEST .GE. 10 .AND. TESTFL) THEN
            WRITE(PRINTF,1001) ID
 1001       FORMAT (' directional counter for interacting triad: ',2I4)
          ENDIF
C
C         *** initialize array with E(f) for a direction considered ***
C
          DO IS = 1, MSC
            E(IS)  = AC2(ID,IS,KCGRD(1)) * DPI * SPCSIG(IS)               30.72
          ENDDO
C
C         *** (j) corresponds to central grid point           ***
C         *** (i) corresponds to grid point lower harmonic    ***
C         ***                                                 ***
C         *** for log. distr.:                                ***
C         ***                                                 ***
C         ***       j =  i + ires                             ***
C         ***      <------------>                             ***
C         ***                                                 ***
C         ***     i             j                             ***
C         ***  ---+-------------+------------+--------        ***
C         ***    fp/2           fp                            ***
C         ***                                                 ***
C         ***                                                 ***
C         ***  start at i=1   ------> ISMAX-IRES              ***
C         ***                                                 ***
C         ***  at central point (j) :                         ***
C         ***  ----------------------                         ***
C         ***  Wj    radian frequency                         ***
C         ***  WNj   wave number                              ***
C         ***  CGj   group velocity                           ***
C         ***  JACj  jacebean function A(s) = E(f) / 2.pi.s   ***
C         ***                                                 ***
C
          DO I = 1, ISMAX-IRES
C           *** j = central , i = harmonic ***
            J   = I + IRES
            Wi  = SPCSIG(I)                                               30.72
            Wj  = SPCSIG(J)                                               30.72
            WNi = KWAVE(i,1)
            WNj = KWAVE(j,1)
            CGi = CGO(i,1)
            CGj = CGO(j,1)
            JACi = DPI * Wi
            JACj = DPI * Wj
C
            ALPHA = 4. * WNi**2 *
     &              ( 0.5 + ( Wi**2 / ( WNi**2 * GRAV * DEP ) ) )
C
            BETA  = -2. * WNj * ( GRAV * DEP +
     &                            2. * B * GRAV * DEP_3 * WNj**2 -
     &                          ( B + 1./3. ) * Wj**2 * DEP_2   )
C
C           *** constant FT, PTRIAD(1) controls the intensity ***
C
            FT = PTRIAD(1) * CGj * SINBPH * ( GRAV * ALPHA / BETA )**2
C
C           *** explicit or implicit calculation of source term ***
C
            RHV_i = 0.
            RHV_j = 0.
            DIA_i = 0.
            DIA_j = 0.
C
            IF ( TRIEXP ) THEN
C
C             *** explicit calculation ***
C
              RHV_j = FT * (     (Wj/WNj) * E(i) * E(i)  -
     &                      2. * (Wi/WNi) * E(j) * E(i)    )
              RHV_i = RHV_j
C
              IF ( RHV_j .LE. 0. ) THEN
                RHV_j = 0.
                RHV_i = 0.
              ENDIF
C
C             *** multiply source term Se(f) with jacobean ***
C
              IMATRA(ID,i) = IMATRA(ID,i) - RHV_i / JACi
              IMATRA(ID,j) = IMATRA(ID,j) + 0.5 * RHV_j / JACj
C
            ELSE
C
C             *** semi impllcit calculation ***
C
C             *** use explicit scheme for point J since there is ***
C             *** grow at the higher frequencies                 ***
C
              RHV_j = FT * (     (Wj/WNj) * E(i) * E(i)  -
     &                      2. * (Wi/WNi) * E(j) * E(i)    )
C
C             *** source term at point i : E(i) is unknown           ***
C             *** at this point there is dissipation -> use implicit ***
C             *** scheme                                             ***
C
              DIA_i = FT * (     (Wj/WNj) * E(i)         -
     &                      2. * (Wi/WNi) * E(j)           )
C
              IF ( RHV_j .LE. 0. ) THEN
                RHV_j = 0.
                RHV_i = 0.
                DIA_j = 0.
                DIA_i = 0.
              ENDIF
C
C             *** source term at point j : E(j) is unknown ***   deleted
C
C              RHV_j = FT * (       (Wj/WNj) * E(i) * E(i)  )     deleted
C              DIA_j = FT * ( -2. * (Wi/WNi) *      * E(i)  )     deleted
C              IMATRA(ID,j) = IMATRA(ID,j) + 0.5 * RHV_j / JACj   deleted
C              IMATDA(ID,j) = IMATDA(ID,j) - 0.5 * DIA_j          deleted
C
              IMATRA(ID,j) = IMATRA(ID,j) + 0.5 * RHV_j / JACj
              IMATDA(ID,i) = IMATDA(ID,i) + DIA_i
C
            ENDIF
C
C           *** store results in array for plot of triad term ***
C
            IF( TESTFL ) THEN
              PLTRI(ID,I,IPTST) = PLTRI(ID,I,IPTST)                       40.00
     &           - RHV_i / JACi - DIA_i * AC2(ID, i ,KCGRD(1))
C
              PLTRI(ID,J,IPTST) = PLTRI(ID,J,IPTST)                       40.00
     &        + 0.5 * RHV_j / JACj + 0.5 * DIA_j * AC2(ID,j,KCGRD(1))     30.21
            END IF
          ENDDO
C
C         *** test output for a particular direction ***
C
          IF ( ITEST .GE. 10 .AND. TESTFL) THEN
            WRITE(PRINTF,1002) ALPHA, BETA, FT, i, j
 1002       FORMAT (' STRIAD: ALPH BETA FT i j :',3E12.4,2X,2I3)
            WRITE(PRINTF,1003) Wi, WNi, CGi, JACi
 1003       FORMAT (' STRIAD: Wi WNi CGi JACi  :',4E12.4)
            WRITE(PRINTF,1004) Wj, WNj, CGj, JACj
 1004       FORMAT (' STRIAD: Wj WNj CGj JACj  :',4E12.4)
            WRITE(PRINTF,1005) RHV_i, RHV_j, DIA_i, DIA_j
 1005       FORMAT (' STRIAD: RHV_i,j DIA_i,j  :',4E12.4)
          ENDIF
C
        ENDDO
      ENDIF
C
C     *** test output ***
C
      IF ( ITEST .GE. 10 .AND. TESTFL) THEN
         WRITE(PRINTF,2000) KCGRD(1), IRES, ISMAX
 2000    FORMAT (' STRIAD: POINT IRES ISMAX :',3I5)
         WRITE(PRINTF,2001) GRAV, DEP, DEP_2, DEP_3
 2001    FORMAT (' STRIAD: G DEP DEP2 DEP3  :',4E12.4)
         WRITE(PRINTF,2002) DPI, PTRIAD(1), B, URSELL(KCGRD(1))
 2002    FORMAT (' STRIAD: DPI PAR B URSELL :',4E12.4)
         WRITE(PRINTF,2003) SMEBRK, TMN, HS, BIPH
 2003    FORMAT (' STRIAD: SMEBRK TMN HS BIPH:',4E12.4)
      ENDIF
C
C     *** end of subroutine STRIAD ***
C
      RETURN
      END
C
C********************************************************************
C
      SUBROUTINE STRIAN (AC2   ,DEP2  ,CGO   ,IMATRA,KWAVE ,
     &                   HS    ,IDDLOW,IDDTOP,
     &                   SPCSIG,SMEBRK,IMATDA,PLTRI ,URSELL        )      40.03
C
C********************************************************************
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'                                               40.00
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     40.00, 40.13: Nico Booij
C
C  1. Updates
C
C            Jan. 97: New subroutine (Roeland Ris)
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.81, Aug. 98: Modified calculation of the Ursell number
C     30.82, Sep. 98: Declaration of argument variable reorganised
C     40.03, Apr. 00: computation of Ursell moved to subr SDISPA
!     40.13, July 01: var. coeff. PTRIAD(3) [urslim] introduced
!                     var. coeff. PTRIAD(4) [urcrit] introduced
!                     array E(:) is made allocatable
C
C  2. Purpose
C
C     In this subroutine the triad-wave interactions are calculated
C     with the Lumped Triad Approximation of Eldeberky (1996). His
C     expression is based on a parameterization of the biphase (in
C     terms of the Ursell number), is directionally uncoupled and
C     takes into account for the self-self interactions only.
C
C     For a full description of the equations reference is made
C     to Eldeberky (1996). Here only the main equations are given.
C
C  3. Method
C
C     Determine first the Ursell number given by:
C
C                  g         Hs Tm         g          Hs
C     UR =  --------------- ------- = ---------- -------------
C           8 sqrt(2) pi**2   d**2    2 sqrt (2) sig_m**2 d**2
C
C     in which:
C
C     d      depth (m)
C     g      gravitational acceleration (m/s^2)
C     Hs     significant wave height (m)
C     sig_m  mean wave frequency (in rad/s) according to m1/m0
C            (personnel communication, Y. Eldeberky, 1997)
C     Tm     mean wave period (s)
C
C     The biphase BIPH is given by (see eq. 3.19, Eldeberky, 1996 ):
C
C                                  0.2
C     BIPH = - pi/2 + pi/2 tanh ( ----- )
C                                   Ur
C
C     The source term is (see eq. 7.25):
C
C             +      -
C     S(p) = S(p) + S(p)
C
C     in which
C      +
C     S(p) = a Cp Cg,p (R(p/2,p/2))**2 sin (|BIPH|) ( E(p/2)**2 -
C
C                          2 E(p) E(p/2)  )
C      -          +
C     S(p) = - 2 S(2p)
C
C     in which:
C     a    tunable coefficient
C     p    frequency
C
C     The value for the interaction coefficient R(p/2,p/2) is
C     not given here (see eq 7.26 in Eldeberky, 1996)
C
C     Note that a slightly adapted formulation of the LTA is used in
C     in the SWAN model:
C
C     - only positive contributions to higher harmonics are considered
C       here (no energy is transferred to lower harmonics).
C
C     - the mean frequency in the expression of the Ursell number
C       is calculated according to the first order moment over the
C       zeroth order moment (personnal communucation, Y.Eldeberky, 1997)
C
C     - the interactions are calculated upto 2.5 times the mean
C       frequency only.
C
C     - to avoid expensive interpolations between discrete bins the
C       interactions are taken at discrete gridpoints only. Since the
C       grid is logarimically distributed in frequency space the
C       number of bins between the central bin and lower harmonic bin
C       is constant (equal to IRES)
C
C     Moreover:
C
C     - the interactions are calculated in terms of energy density
C       instead of action density. So the action density spectrum
C       is firstly converted to the energy density grid, then the
C       interactions are calculated and then the spectrum is converted
C       to the action density spectrum again.
C
C     - To ensure numerical stability the positive contributions
C       of S(p) are calculated with an explicit scheme and the
C       negative contributions with an implicit scheme. Optionally
C       a fully explicit scheme is available.
C
C  4. Argument variables
C
C     ICMAX                                                               30.82
C     IDDLOW: Minimum counter in directional space (see subr. COUNT)??    30.82
C     IDDTOP: Maximum counter in dierctional space (see subr. COUNT)??    30.82
C     ITRIAD                                                              30.82
C     KCGRD                                                               30.82
C     MCGRD                                                               30.82
C     MDC   : Size of array in t-direction??                              30.82
C     MSC   : Size of array in s-direction??                              30.82
C     MTRIAD: Size of array containing triad-coefficients                 30.82
C
      INTEGER        IDDLOW, IDDTOP                                       30.82
C
C     AC2   : Action density as function of d,s,x,y at time t             30.82
C     CGO   : Group velocity                                              30.82
C     DEP2  : Depth at gridpoint ix,iy (obtained from SWANCOM1??)         30.82
C     GRAV                                                                30.82
C     HS                                                                  30.82
C     IMATRA: Right hand vector of matrix??                               30.82
C     IMATDA: Diagonal of matrix??                                        30.82
C     KWAVE : Wave number                                                 30.82
C     PI    : Constant Pi                                                 30.82
C     PLTRI : Values of the triad source terms in TEST-points             30.82
C     PTRIAD: Tunable coefficients for nonlinear sourceterms              30.82
C     SMEBRK: Mean frequency (see subroutine SDISPA)                      30.82
C     SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL :: HS      ! significant wave height                           30.82
      REAL :: SMEBRK  ! average (angular) frequency                       30.82
      REAL :: AC2(MDC,MSC,MCGRD)                                          30.82
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL :: CGO(MSC,MICMAX)                                             30.82 40.22
      REAL :: DEP2(MCGRD)                                                 30.82
      REAL :: IMATDA(MDC,MSC), IMATRA(MDC,MSC)                            30.82
!     Changed ICMAX to MICMAX, since MICMAX doesn't vary over gridpoint   40.22
      REAL :: KWAVE(MSC,MICMAX)                                           30.82 40.22
      REAL :: PLTRI(MDC,MSC,NPTST),                 SPCSIG(MSC)           30.82
      REAL :: URSELL(MCGRD)                                               40.03
C
C  6. Local variables
C
C     I     : Frequency counter at bin of lower harmonic (f/2)            30.82
C             and subscript for variable??                                30.82
C     I1    : Temporary variable to determine the resonance conditions??  30.82
C     I2    : Temporary variable to determine the resonance conditions??  30.82
C     ID    : Grid counter in spectral space (direction)                  30.82
C     IENT  : Number of entries into this subroutine                      30.82
C     II    : Counter                                                     30.82
C     IRES  : Number of bins between central and lower harm. freq.        30.82
C             (is constant for a logaritmic frequency distribution)       30.82
C     IS    : Grid counter in spectral space (frequency)                  30.82
C     ISMAX : Maximum of the counter in spectral space (frequency) for    30.82
C             which the triad interactions are calculated (cut-of)        30.82
C     IX    : Grid counter in geographical space (x-direction)            30.82
C     IY    : Grid counter in geographical space (y-direction)            30.82
C     J     : Frequency counter at central gridpoint (f)                  30.82
C             and subscript for variable??                                30.82
C
      INTEGER I, I1, I2, ID, IENT, II, IRES, IS, ISMAX, J                 30.82
C
C     AUX1  : Temporary variables                                         30.82
C     AUX2  : Temporary variables                                         30.82
C     BIPH  : Parameterized bi-phase of the spectrum                      30.82
C     CGI   : Group velocity at interacting bin                           30.82
C     CGJ   : Group velocity at central frequency bin                     30.82
C     CI    : Phase velocity at interacting bin                           30.82
C     CJ    : Phase velocity at central frequency bin                     30.82
C     DEP   : =DEP2(IX,IY); Depth at gridpoint (IX,IY)                    30.82
C     DEP_2 : =DEP**2;                                                    30.82
C     DEP_3 : =DEP**3;                                                    30.82
C     DPI   : =2*PI;                                                      30.82
C     E     : Energy density as function of location, freq. and direction 30.82
C     FT    : Coefficient??                                               30.82
C     JACI       jacobean function at bin i and j respectively   ??       30.82
C     JACJ       equal to :  A(s) = E(s) / 2.pi.s                ??       30.82
C     URSELL: Ursell number                                               30.82
C     WI    : Radian frequency at interacting bin                         30.82
C     WJ    : Radian frequency at central frequency bin                   30.82
C     WNI   : Wavenumber at interacting bin                               30.82
C     WNJ   : Wavenumber at central freqency bin                          30.82
C     RINT  : Interaction coefficient                                     30.82
C     XISTRI: Rate between two succeding freq. counters??                 30.82
C
      REAL    AUX1, AUX2, BIPH, CGI, CGJ, CI, CJ, DEP, DEP_2, DEP_3, DPI  30.82
      REAL              :: E(1:MSC)                                       NRL
      REAL    FT, JACI, JACJ, WI, WJ, WNI, WNJ, RINT, XISTRI              30.82
C
C     TRIEXP: Explicit integration scheme is used for calculating triads  30.82
C             (semi-implicit when false)                                  30.82
C
      LOGICAL TRIEXP                                                      30.82
C
C  7. SUBROUTINES USED
C
C     ---
C
C  8. SUBROUTINES CALLING
C
C     SOURCE
C
C  9. ERROR MESSAGES
C
C     ---
C
C 10. REMARKS
C
C     ---
C
C 11. STRUCTURE
C
C     -----------------------------------------------------------------
C     - Initialize variables
C     - Determine resonance condition and the maximum discrete freq.
C       for which the interactions are calculated.
C     - Calculate the Ursell number
C     -----------------------------------------------------------------
C     If Ursell number larger than 0.1 compute interactions
C       Calculate Biphase
C       Do for each direction
C         Convert action density to energy density
C         Do for all frequencies
C           Calculate interaction coefficient and interaction factor
C           Compute interactions and store results in matrix
C         Enddo
C         -------------------------------------------------------------
C         If testfl store results in test array
C       Enddo
C       ---------------------------------------------------------------
C
C 13. Source text
C
      REAL      RHV_i ,RHV_j ,DIA_i ,DIA_j , SINBPH
C
      SAVE IENT
      DATA IENT/0/
      IF (LTRACE) CALL STRACE (IENT,'STRIAN')
C
C     *** initialization of variables ***
C
      DPI   = 2. * PI
      DEP   = DEP2(KCGRD(1))
      DEP_2 = DEP**2
      DEP_3 = DEP**3
      IF (ITRIAD.EQ.3) THEN
*       implicit computation
        TRIEXP = .FALSE.
      ELSE
*       explicit computation
        TRIEXP = .TRUE.
      ENDIF
C
      E(:) = 0.                                                           40.22
C
C     *** determine "resonance condition" and determine maximum    ***
C     *** discrete counter (ISMAX) at 2.5 times the mean frequency ***
C     *** value of 2.5 can be varied using PTRIAD(2)               ***
C
      I2     = INT (FLOAT(MSC) / 2.)
      I1     = I2 - 1
      XISTRI = SPCSIG(I2) / SPCSIG(I1)                                    30.72
      IRES   = NINT ( LOG( 2.) / LOG ( XISTRI ) )
C
      ISMAX = 1
      DO IS = 1, MSC
       IF ( SPCSIG(IS) .LT. ( PTRIAD(2) * SMEBRK) ) THEN                  30.72
          ISMAX = IS
        ENDIF
      ENDDO
      ISMAX = MAX ( ISMAX , IRES + 1 )
 
!     Ursell number is computed in swancom1.for                           40.13
!
      IF ( URSELL(KCGRD(1)) .GE. PTRIAD(3) ) THEN                         40.13
C
C       *** calculate Biphase ***
C
        BIPH   = (0.5*PI)*(TANH(PTRIAD(4)/URSELL(KCGRD(1)))-1)            40.13
        SINBPH = ABS( SIN(BIPH) )
C
        DO II = IDDLOW, IDDTOP
          ID = MOD ( II - 1 + MDC , MDC ) + 1
C
C         *** initialize array with E(f) for the direction considered ***
C
          DO IS = 1, MSC
            E(IS)  = AC2(ID,IS,KCGRD(1)) * DPI * SPCSIG(IS)               30.72
          ENDDO
C
C         *** (i) corresponds to grid point lower harmonic    ***
C         *** (j) corresponds to central grid point           ***
C         ***                                                 ***
C         *** for log. distribution:                          ***
C         ***                                                 ***
C         ***       j =  i + ires                             ***
C         ***      <------------>                             ***
C         ***                                                 ***
C         ***     i             j                             ***
C         ***  ---+-------------+------------+--------        ***
C         ***    fp/2           fp                            ***
C         ***                                                 ***
C         ***  start at i=1   ------> ISMAX-IRES              ***
C         ***                                                 ***
C
          DO I = 1, ISMAX-IRES
C           *** j = central bin, i = bin at lower harmonic ***
            J   = I + IRES
            Wi  = SPCSIG(I)                                               30.72
            Wj  = SPCSIG(J)                                               30.72
            WNi = KWAVE(i,1)
            WNj = KWAVE(j,1)
            Ci  = Wi / WNi
            Cj  = Wj / WNj
            CGi = CGO(i,1)
            CGj = CGO(j,1)
            JACi = DPI * Wi
            JACj = DPI * Wj
C
            AUX1 = WNi**2 * ( GRAV * DEP + 2. * Ci**2 )
            AUX2 = WNj * DEP * ( GRAV * DEP +
     &                          (2./15.) * GRAV * DEP_3 * WNj**2 -        30.82
     &                          (2./ 5.) * Wj**2 * DEP_2 )                30.82
            RINT = AUX1 / AUX2
C
C           *** constant FT, PTRIAD(1) controls the intensity ***
C
            FT = PTRIAD(1) * Cj * CGj * RINT**2 * SINBPH
C
C           *** explicit or implicit calculation of source term ***
C
            RHV_i = 0.
            RHV_j = 0.
            DIA_i = 0.
            DIA_j = 0.
C
            IF ( TRIEXP ) THEN
C
C             *** explicit calculation ***
C
              RHV_j = FT * (  E(i) * E(i)  - 2. * E(j) * E(i) )
              RHV_i = RHV_j
C
C             *** consider only transfer from lower to higher harm ***
C
              IF ( RHV_j .LE. 0. ) THEN
                RHV_j = 0.
                RHV_i = 0.
              ENDIF
C
C             *** multiple source term Se(f) with jacobean ***
C
              IMATRA(ID,i) = IMATRA(ID,i) - 2. * RHV_i / JACi
              IMATRA(ID,j) = IMATRA(ID,j) + RHV_j / JACj
C
            ELSE
C
C             *** semi impllcit calculation ***
C
C             *** use explicit scheme for point J since there is ***
C             *** grow at the higher frequencies                 ***
C
              RHV_j = FT * ( E(i) * E(i) - 2. * E(j) * E(i) )
C
C             *** source term at point i : E(i) is unknown           ***
C             *** at this point there is dissipation -> use implicit ***
C             *** scheme                                             ***
C
              DIA_i = FT * ( E(i) - 2. * E(j) )
C
              IF ( RHV_j .LE. 0. ) THEN
                RHV_j = 0.
                RHV_i = 0.
                DIA_j = 0.
                DIA_i = 0.
              ENDIF
C
              IMATRA(ID,j) = IMATRA(ID,j) + RHV_j / JACj
              IMATDA(ID,i) = IMATDA(ID,i) + 2. * DIA_i
C
            ENDIF
C
C           *** store results in array for plot of triad term ***
C
            IF( TESTFL ) THEN
              PLTRI(ID,I,IPTST) = PLTRI(ID,I,IPTST)                       40.00
     &           - 2. * RHV_i / JACi - 2. * DIA_i * AC2(ID, i ,KCGRD(1))
C
              PLTRI(ID,J,IPTST) = PLTRI(ID,J,IPTST)                       40.00
     &          + RHV_j / JACj  + DIA_j * AC2(ID, j ,KCGRD(1))
            END IF
          ENDDO
C
C         *** test output for a particular direction ***
C
          IF ( ITEST .GE. 5 .AND. TESTFL) THEN
            WRITE(PRINTF,1002) AUX1, AUX2, FT, i, j
 1002       FORMAT (' STRIAN: ALPH BETA FT i j  :',3E12.4,2X,2I3)
            WRITE(PRINTF,1003) Wi, WNi, Ci, CGi, JACi
 1003       FORMAT (' STRIAN: i, W WN C CG JAC:',5E12.4)
            WRITE(PRINTF,1004) Wj, WNj, Cj, CGj, JACj
 1004       FORMAT (' STRIAN: j, W WN C CG JAC:',5E12.4)
            WRITE(PRINTF,1005) RINT, RHV_i, RHV_j, DIA_i, DIA_j
 1005       FORMAT (' STRIAN: R RHVi,j DIAi,j :',5E12.4)
          ENDIF
C
        ENDDO
      ENDIF
C
C     *** test output ***
C
      IF ( ITEST .GE. 5 .AND. TESTFL) THEN
         WRITE(PRINTF,2000) KCGRD(1), IRES, ISMAX
 2000    FORMAT (' STRIAN: KCGRD IRES ISMAX  :',4I4)
         WRITE(PRINTF,2001) GRAV, DEP, DEP_2, DEP_3
 2001    FORMAT (' STRIAN: G DEP DEP2 DEP3   :',4E12.4)
         WRITE(PRINTF,2002) DPI, PTRIAD(1), PTRIAD(2), URSELL(KCGRD(1))
 2002    FORMAT (' STRIAN: DPI P(1) P(2) URSELL  :',4E12.4)
         WRITE(PRINTF,2003) SMEBRK, HS, BIPH, ABS(SIN(BIPH))
 2003    FORMAT (' STRIAN: SMEBRK HS B SIN(B):',4E12.4)
      ENDIF
 
      RETURN
      END subroutine STRIAN                                               40.13
 
