!NRL: $Id: swanout3.F,v 1.1.1.2 2003/03/28 15:35:33 dykes Stab $
!NRL: $Name:  $
C     Last change:  IJ.   4 Mar 99    2:43 pm
C     SWAN/OUTPUT    file 3 of 3
C
C     Contents of this file :
C
C       SWPLSP    main subroutine for polar plots
C       PLSPEC    subroutine making actual plots
C       PTHETA    Draw theta
C       PSIGMA    Draw sigma
C       PLTAR1    Plots arrow.
C       PLTAR2    Plots arrow.
C       PLTCIR    Plots (dashed) circle.
C       PLTLN1    Plots (dashed) line.
C       PLTSEG    Calculate coordinates for PLTLN1 in PLT2DS.
C       PLT2DS    Plots 2-d spectrum
C       PLTISO    Isoline routine
C       TRAFO     Grid transformation routine.
C
*******************************************************************
*                                                                 *
      SUBROUTINE  SWPLSP (RTYPE     ,OREQ      ,
     &                    ORER      ,MIP       ,AC2       ,               30.90
     &                    ACLOC     ,AUX       ,LAUX      ,               30.90
     &                    VOQ       ,VOQR      ,SPCSIG    ,               30.72
     &                    SPCDIR    ,KGRPNT    ,DEP2      )               30.21
*                                                                 *
*******************************************************************
C
      USE OUTP_DATA                                                       40.13
 
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma (Equivalence version)
C     34.01: Jeroen Adema
!     40.13: Nico Booij
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.81, Jan. 99: ReplaceD variable FROM by FROM_ and TO by TO_ (because
C                     FROM and TO are reserved words)
C     30.82, Oct. 98: Updated description of several variables
C     34.01, Feb. 99: Introducing STPNOW
!     40.13, Oct. 01: filename now obtained from array OUTP_FILES
C
C  4. Argument variables
C
C i   ORER  : Real EQUIVALENCE of OREQ                                    30.90
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
C
      REAL    ORER(*)                                                     30.90
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C     LAUX  : Logical Equivalence of AUX                                  30.90
C
      LOGICAL LAUX(MDC,MSC)                                               30.90
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
*  9. procedure
*
*     ------------------------------------------------------------
*     For each output location do
*         Interpolate action density to the output point
*         Start picture
*         Call PLTISO to plot isolines
*     ------------------------------------------------------------
*
      INTEGER   OREQ(*)            ,VOQR(*)         ,FROPT         ,
     &          OTYPE              ,KGRPNT(MXC,MYC)                       30.21
      REAL      AC2(MDC,MSC,MCGRD) ,ACLOC(MSC,MDC+1) ,AUX(MDC,MSC) ,      20.41
     &          VOQ(MIP,*)         ,DEP2(MCGRD)                           40.00
      CHARACTER RTYPE *4, PTI *36, FROM_, PSNAME *8                       30.81
      SAVE IENT, FROM_                                                    30.81
      DATA IENT /0/, FROM_ /'F'/                                          30.81
      CALL STRACE (IENT, 'SWPLSP')
*
      IF (MIP.EQ.0) RETURN
*
*     ***** obtain name of plotfile *****
      IERR = 0
      FILENM = OUTP_FILES(OREQ(7))                                        40.13
*     ***** obtain plot title from array IOUTR *****
      CALL COPYCH (PTI, FROM_, OREQ(18), 10, IERR)                        30.81 30.00
      CALL COPYCH (PSNAME, FROM_, OREQ(4), 2, IERR)                       30.81 30.00
      IF (RTYPE.EQ.'PLSP') THEN
        OTYPE = -2
      ELSE
        OTYPE = 2
      ENDIF
      IF (ITEST.GE.50) WRITE (PRINTF, 16) 'Filename:  ', FILENM
      IF (ITEST.GE.80) WRITE (PRINTF, 16) 'Plot title:', PTI
  16  FORMAT (1X, A, A36)
  17  FORMAT (1X, A, 2(1X,E12.4))
      DO 200 IP = 1,MIP
        XC   = VOQ(IP,VOQR(24))
        YC   = VOQ(IP,VOQR(25))
        HSIG = VOQ(IP,VOQR(10))
        APER = VOQ(IP,VOQR(28))
        PPER = VOQ(IP,VOQR(12))
        ADIR = VOQ(IP,VOQR(13))
        DSPR = VOQ(IP,VOQR(16))
        WVX  = VOQ(IP,VOQR(26))
        WVY  = VOQ(IP,VOQR(26)+1)
        DEP  = VOQ(IP,VOQR(4))                                            20.41
        IF (ICUR.GT.0) THEN                                               30.50
          UX   = VOQ(IP,VOQR(5))                                          20.41
          UY   = VOQ(IP,VOQR(5)+1)
        ELSE
          UX   = 0.
          UY   = 0.
        ENDIF
        IF (ITEST.GE.30) WRITE (PRTEST, 33) XC, YC, DEP, HSIG, WVX, WVY
  33    FORMAT (' param plot spec ', 6(1X, E12.4))
        IF (DEP.GT.DEPMIN) THEN                                           40.00
*
*         the action density spectrum is interpolated and
*         transformed to energy density                                   10.33
*
*         call subr. to calculate 2-D spectrum (relative or abs. frequency)
*
          CALL SWCMSP (OTYPE       ,XC          ,YC          ,            40.00
     &                 AC2         ,AUX         ,SPCSIG      ,            40.00
     &                 DEP         ,DEP2        ,UX          ,
     &                 UY          ,SPCDIR(1,2) ,SPCDIR(1,3) ,
     &                 1.          ,KGRPNT      ,IERR        )            40.00
          IF (IERR.NE.0) GOTO 190
*         switch order of indices in view of usage in subroutine PLTISO
          DO ID = 1, MDC
            DO ISIG = 1, MSC
              ACLOC(ISIG,ID) = AUX(ID,ISIG)                               40.00
            ENDDO
          ENDDO
          IF (FULCIR) THEN                                                40.00
            DO ISIG = 1, MSC
              ACLOC(ISIG,MDC+1) = ACLOC(ISIG,1)                           20.41
            ENDDO
          ENDIF                                                           40.00
*
*         call subroutines OPFRAM and PLSPEC to do actual plotting
*
          XASL = XASM
          YASL = YASM
          FROPT = PFROPT
          CALL OPFRAM (FROPT, PTI)
          IF (STPNOW()) RETURN                                            34.01
          CALL PLSPEC (OREQ, ORER, SPCSIG, LAUX, ACLOC, IP,               30.90
     &                 XC, YC, HSIG, APER, PPER, ADIR, DSPR,
     &                 WVX, WVY, SPCDIR)
          GOTO 200
        ELSE
          GOTO 190
        ENDIF
*
 190    WRITE (PRTEST, 192) PSNAME, IP, XC, YC
 192    FORMAT (' No polar plot for point: ', A8, I3, 2(1X,F7.2),         40.00
     &    ' due to negative depth')                                       40.00
 200  CONTINUE
      RETURN
*     end of subroutine SWPLSP
      END
*****************************************************************
*                                                               *
      SUBROUTINE  PLSPEC (OREQ, ORER, SPCSIG, LOGPL, ACLOC, IP,           30.72
     &                    XC, YC, HSIG, APER, PPER, ADIR, DSPR,
     &                    WVX, WVY, SPCDIR)
*                                                               *
*****************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     10.11, Aug. 94: Fpeak in 2-D plot corrected
C     10.12, Aug. 94: Absolute freq. also in 1-D plot
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of several variables
C     30.81, Dec. 98: ATAN2(0,0) prevented
C     30.81, Jan. 99: Replaced variable FROM by FROM_ and TO by TO_ (because
C                     FROM and TO are reserved words)
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C  8. Subroutines called
C
C     SWPLSP
C
C  9. Subroutines used
C
C     PLAX1
C     PLTKAD
C     OPTEXT
C     PLBRDR
C     OPPLOT
C     OPENDF
C
C 10. Error messages
C
C     This routine can only be left if plottable spectrum is found
C     or program is ended.
C
C 11. Remarks
C
C     ---
C
C 12. Structure
C
C     ----------------------------------------------------------
C     Assign unit numbers
C     Initialize test parameters
C     Initialize plot parameters                        (INIPLT)
C     ----------------------------------------------------------
C
C 13. Source text
C
      CHARACTER  STRNG *80, CHSTR*80, PSNAME *16, FROM_                   30.81 40.00
      REAL       ACLOC(MSC,MDC+1), ORER(*)                                20.41
      REAL       ACMAX
      LOGICAL    LOGPL(MSC,MDC+1)
      INTEGER    OREQ(*)
      SAVE IENT
      DATA IENT /0/, FROM_ /'F'/                                          30.81
      CALL STRACE (IENT, 'PLSPEC')
*
*     Initialize picture on plotter : ---------------------------------
*
      IERR = -1
      CALL COPYCH (PSNAME, FROM_, OREQ(4), 2, IERR)                       30.81 30.00
      IF (ITEST.GE.80) WRITE (PRINTF, 17) PSNAME, IP, XC, YC
  17  FORMAT (' point ', A8, I3, ' position:  ', 2E12.4)
*
*     Plot spectrum , 2-D spectrum :
*
      NORMS2 = OREQ(28)                                                   30.00
      IF (NORMS2.EQ.0 .OR. NORMS2.EQ.2) THEN
        FRMAX = ORER(31)                                                  30.00
      ELSE
        FRMAX = 4.*PI/PPER
        ORER(31) = FRMAX                                                  30.00
      ENDIF
*
      PLSIZE = 0.55 * XASM
      CHSIZE = PLSIZE / 40.
      XMAR   = XPLO
      YMAR   = YPLO
      LOMAR  = 1.5*CHSIZE
*     XPLO etc. become boundaries of spectral plane
      XPLO = XMAR + 6.*CHSIZE
      YPHI = YMAR + YASL - 9.*CHSIZE
      YPLO = YPHI - PLSIZE
      XPHI = XPLO + PLSIZE
      XFLO = -FRMAX
      XFHI = FRMAX
      YFLO = -FRMAX
      YFHI = FRMAX
      HORSC = (XPHI-XPLO) / (XFHI-XFLO)
      VRTSC = (YPHI-YPLO) / (YFHI-YFLO)
      IF (ITEST.GE.120) THEN
        ACMAX = -1.
        DO 34 ID = 1,MDC
          DO 33 IS = 1,MSC
            ACMAX = MAX (ACMAX,ACLOC(IS,ID))
  33      CONTINUE
  34    CONTINUE
        WRITE (PRTEST, 35) 1.1 * ACMAX
  35    FORMAT (' PLSPEC, interpolated spectrum, factor ', F14.7)
        ACMAX = 1000. / (1.1 * ACMAX)
        WRITE (PRTEST, 36) (ID, ID=1,MDC)
  36    FORMAT (200 I4)
        DO 37 IS = 1,MSC
          WRITE (PRTEST,36) (NINT(ACMAX*ACLOC(IS,ID)), ID=1,MDC)
  37    CONTINUE
      ENDIF
*
*     Plot text around figure
*
      XT = XPLO
      YT = YPHI + 5.5 * CHSIZE
      CALL OPTEXT (XT, YT, CHSIZE, 'Location:', 0., 9)
      XT = XT + 10.*CHSIZE
      CALL OPTEXT (XT, YT, CHSIZE, PSNAME, 0., 8)
      XT = XT + 10.*CHSIZE
      WRITE (CHSTR(1:3), 88) IP
  88  FORMAT (I3)
      CALL OPTEXT (XT, YT, CHSIZE, CHSTR(1:3), 0., 3)
*
      LENS = 19
      CALL OPTEXT (XPLO, YPHI+CHSIZE, CHSIZE,
     &  '2-D SPECTRUM E(f, )', 0., LENS)
      CALL PTHETA  (XPLO+17.*CHSIZE, YPHI+CHSIZE, 0.95*CHSIZE,
     &  0.95*CHSIZE)
*
*     Plot scale of contour levels : ----------------------------------
*
      XT  = XPHI + 3.*CHSIZE
      YT  = YPHI + CHSIZE
*
      CALL OPTEXT (XT, YT, CHSIZE, 'Contour levels :', 0., 16)
      DYT = 2.3*CHSIZE
      YT  = YT - 1.4*DYT
      NHTS   = OREQ(32)                                                   30.00
      IF (ITEST.GE.60) WRITE (PRTEST, 610) NORMS2, NHTS, FRMAX
 610  FORMAT (' test PLSPEC, norm,nhts,frmax', 2I4, 1X, E12.4)
      IF (NORMS2.LE.1) THEN
          DO I = NHTS, 1, -1
            WRITE (STRNG, '(1X,F11.4)') ORER(32+I)                        30.00
            DO JJ = 12, 10, -1
               IF (STRNG(JJ:JJ).EQ.'0') THEN
                  STRNG(JJ:JJ) = ' '
               ELSE
                  GOTO 699
               ENDIF
            ENDDO
 699        CALL OPTEXT (XT, YT, CHSIZE, STRNG, 0., 12)
            YT = YT - DYT
          ENDDO
      ELSE
          STRNG = '        E'
          DO I = NHTS, 1, -1
            WRITE (STRNG(1:7), '(F7.3)') ORER(32+I)                       30.00
            CALL OPTEXT (XT, YT, CHSIZE, STRNG, 0., 11)
            CALL OPTEXT (XT+9.*CHSIZE, YT-0.5*CHSIZE, CHSIZE,
     &      'max', 0., 3)
            YT = YT - DYT
          ENDDO
      ENDIF
      DYT = 2.3 * CHSIZE
      ILN = 3
      NCIR = 3
      IF (ILN.GE.2) THEN
         YT = YT - DYT
         CALL OPTEXT (XT, YT, CHSIZE, 'Freq. scales :', 0., 14)
         YT  = YT - 3.0*CHSIZE
         DO I=1, NCIR
           RCIR = ORER(28+I)                                              30.00
           IF (RCIR.GT.0.) THEN
             IF (RCIR.LT.1.1*FRMAX) THEN
                WRITE (STRNG(1:9), '(F9.3)') RCIR / PI2
                STRNG(10:12) = ' Hz'
                CALL OPTEXT (XT, YT, CHSIZE, STRNG, 0., 12)
                YT = YT - DYT
             ENDIF
           ENDIF
         ENDDO
      ENDIF
*
*     Plot wind and North arrow:
*
      PLS2 = 0.25 * PLSIZE
      ARL    = 0.8 * PLS2
      ARLMIN = 0.1
      YT  = YT - DYT
      CALL OPTEXT (XT, YT, CHSIZE, 'Wind :', 0., 6)
      X0  = XT + 0.5*PLS2
      Y0  = YT - 0.5*PLS2 - CHSIZE
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 + 0.5*PLS2 ,'UP')
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 - 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 + 0.5*PLS2 , Y0 - 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 + 0.5*PLS2 , Y0 + 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 + 0.5*PLS2 ,'DOWN')
      IF (IWIND.GT.0) THEN
        IF (.NOT.(WVY.EQ.0 .AND. WVX.EQ.0)) THEN                          30.81
          CALL PLTAR1 (X0, Y0, ARL, ATAN2(WVY,WVX),                       20.29
     &                 20., 0.35, ARLMIN)
        ENDIF                                                             30.81
        YT2 = YT - 1.2*DYT - PLS2
        WRITE (STRNG(1:6),'(F6.1)') SQRT(WVX*WVX+WVY*WVY)
        STRNG(7:10) = ' m/s'
        CALL OPTEXT (XT+0.4*CHSIZE, YT2, CHSIZE, STRNG, 0., 10)
      ENDIF
*
*     plot North arrow
*
      XT  = XT + PLS2 + 2.0*CHSIZE
      CALL OPTEXT (XT, YT, CHSIZE, 'North :', 0., 7)
      X0  = X0 + PLS2 + 2.0*CHSIZE
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 + 0.5*PLS2 ,'UP')
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 - 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 + 0.5*PLS2 , Y0 - 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 + 0.5*PLS2 , Y0 + 0.5*PLS2 ,'DOWN')
      CALL OPPLOT (X0 - 0.5*PLS2 , Y0 + 0.5*PLS2 ,'DOWN')
      CALL PLTAR2 (X0, Y0, ARL, DEGRAD*DNORTH, 20., 0.35,                 20.29
     &             ARLMIN)
*
      CALL PLT2DS (NORMS2, SPCSIG, ORER(29), LOGPL, ACLOC,                30.90
     &             NHTS, ORER(33), ILN, SPCDIR)                           30.90
*
*     Plot spectrum , 1-D spectrum :
*
      EMAX  = 0.
      DO IS = 1, MSC
        EEF = 0.
        DO ID = 1, MDC
          EEF = EEF + ACLOC(IS,ID) * DDIR                                 10.3x
        ENDDO
        IF (EEF .GT. EMAX) THEN
          EMAX = EEF
        ENDIF
        IF (ITEST.GE.80) WRITE(PRINTF,6005) IS, SPCSIG(IS), EEF           30.72
 6005   FORMAT(' ISig',I6,' Freq ',E12.4,' Energy ',E12.4)
      ENDDO
*
      IF (ITEST.GE.60) WRITE (PRTEST,6003) SPCSIG(1),                     30.72
     &  SPCSIG(MSC), PI2/PPER, EMAX                                       30.72
 6003 FORMAT(' Slow ',F7.4,' Shigh ',F7.4,' Speak ', F7.4,
     &   ' Emax', E12.4)
*
      YPLO = YMAR + LOMAR + 0.12 * YASL
      YPHI = YPLO + 0.2 * YASL
*
      YFLO = 0.
      YFHI = 1.0*EMAX
      XFLO = 0.
      IF (NORMS2.EQ.0 .OR. NORMS2.EQ.2) THEN                              10.11
        XFHI = 1.5 * FRMAX
      ELSE
        XFHI = 3. * PI2 / PPER
      ENDIF
*
*     plot the axes
*
      CALL OPPLOT (XPLO-0.8*CHSIZE, YPLO, 'UP')
      CALL OPPLOT (XPLO,YPLO,'DOWN')
      CALL OPPLOT (XPLO,YPHI,'DOWN')
      CALL OPPLOT (XPLO-0.8*CHSIZE, YPHI, 'DOWN')
      CALL OPPLOT (XPHI,YPHI,'DOWN')
      CALL OPPLOT (XPHI,YPLO,'DOWN')
      DPX = (XPHI-XPLO) / 3
      DO IX = 3, 0, -1
        XP  = XPLO + REAL(IX) * DPX
        CALL OPPLOT (XP, YPLO, 'DOWN')
        CALL OPPLOT (XP, YPLO-0.8*CHSIZE , 'DOWN')
        CALL OPPLOT (XP, YPLO, 'DOWN')
      ENDDO
*
      DO IY = 0, 1
        YP  = YPLO + REAL(IY) * (YPHI-YPLO)
        CALL OPNUMB (XPLO-2.5*CHSIZE, YP-0.5*CHSIZE, CHSIZE,
     &               REAL(IY), 0., 0)
      ENDDO
*
      DPX = (XPHI-XPLO) / 3
      IF (NORMS2.EQ.0 .OR. NORMS2.EQ.2) THEN                              10.12
        DO IX = 0, 2, 2
          XP  = XPLO + REAL(IX) * DPX
          IF (IX.EQ.0) THEN
            FF = 0.
          ELSE
            FF = FRMAX / PI2
          ENDIF
          CALL OPNUMB (XP-0.3*CHSIZE, YPLO-2.5*CHSIZE, CHSIZE,
     &                 FF, 0., 2)
        ENDDO
        CALL OPTEXT (XPHI-6.*CHSIZE, YPLO-5.0*CHSIZE,
     &               CHSIZE, 'f (Hz) ', 0., 6)
      ELSE
        DO IX = 0, 3
          XP  = XPLO + REAL(IX) * DPX
          CALL OPNUMB (XP-0.3*CHSIZE, YPLO-2.5*CHSIZE, CHSIZE,
     &                 REAL(IX), 0., 0)
        ENDDO
        CALL OPTEXT (XPHI-8.*CHSIZE, YPLO-5.0*CHSIZE,
     &               CHSIZE, 'f/f ', 0., 4)
        CALL OPTEXT (XPHI-8.*CHSIZE, YPLO-5.5*CHSIZE,
     &               CHSIZE, '   p', 0., 4)
      ENDIF                                                               10.12
*
      IF (ITEST.GE.60) WRITE(PRTEST,*)
     & ' YPLO,YPHI,XFLO,XFHI,YFLO,YFHI ',
     &   YPLO,YPHI,XFLO,XFHI,YFLO,YFHI
*
      LENS = 17
      CALL OPTEXT (XPLO, YPHI+CHSIZE, CHSIZE,
     &  '1-D SPECTRUM E(f)', 0., LENS)
C
      CALL OPTEXT (XPLO-3.5*CHSIZE, 0.5*YPLO+0.5*YPHI,
     &  CHSIZE, 'E/E   ', 90., 6)
      CALL OPTEXT (XPLO-3.0*CHSIZE, 0.5*YPLO+0.5*YPHI,
     &  CHSIZE, '   max' , 90., 6)
C
      IF (EMAX.GT.0.) THEN
        HORSC = (XPHI-XPLO) / (XFHI-XFLO)
        VRTSC = (YPHI-YPLO) / (YFHI-YFLO)
        CALL PLOTF (SPCSIG(1), 0., 'UP')                                  30.72
        DO IS = 1, MSC
          EEF = 0.
          DO ID = 1, MDC
            EEF = EEF + ACLOC(IS,ID) * DDIR                               20.4x
          ENDDO
          CALL PLOTF (SPCSIG(IS), EEF, 'DOWN')                            30.72
        ENDDO
      ENDIF
*
*     Additional text :
*
      XT  = XPHI + 3.*CHSIZE
      DYT = 3.*CHSIZE
      YT  = YPHI - 1.*DYT
 
      CALL OPTEXT (XT, YT, CHSIZE, 'parameters :', 0., 12)
      XT  = XT + 2.5 * CHSIZE
      YT  = YT - 1.5*DYT
*
      CHSTR = 'H  =          m '
      WRITE (CHSTR(5:12),'(F8.2)') HSIG
      CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 16)
      CALL OPTEXT (XT+1.*CHSIZE, YT-0.5*CHSIZE, CHSIZE, 's', 0., 1)
      YT = YT - DYT
*
      CHSTR = 'f  =     .    Hz'
      WRITE (CHSTR(5:13),'(F9.3)') 1./ PPER
      CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 16)
      CALL OPTEXT (XT+1.*CHSIZE, YT-0.5*CHSIZE, CHSIZE, 'p', 0., 1)
      YT = YT - DYT
*
      CALL OPPLOT  (XT-0.1*CHSIZE, YT+1.3*CHSIZE, 'UP')
      CALL OPPLOT  (XT+0.8*CHSIZE, YT+1.3*CHSIZE, 'DOWN')
      CHSTR = 'f  =     .    Hz'
      WRITE (CHSTR(5:13),'(F9.3)') 1./ APER
      CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 16)
      YT = YT - DYT
C
      CALL OPPLOT (XT-0.1*CHSIZE, YT+1.3*CHSIZE,  'UP')
      CALL OPPLOT (XT+0.8*CHSIZE, YT+1.3*CHSIZE,  'DOWN')
      CALL PTHETA (XT, YT, 0.95*CHSIZE, 0.95*CHSIZE)
C
C Introduced nautical convention                                          32.01
C
      IF (BNAUT) THEN                                                     32.01
        CHSTR = '   =     .   (naut.)'                                    32.01
        WRITE (CHSTR(5:11),'(F7.1)') ADIR                                 32.01
        CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 20)                       32.01
      ELSE                                                                32.01
        CHSTR = '   =     .   '                                           32.01
        WRITE (CHSTR(5:11),'(F7.1)') ADIR                                 32.01
        CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 11)                       32.01
      ENDIF                                                               32.01
C
      CALL OPTEXT (XT, YT, CHSIZE, CHSTR, 0., 11)
      CALL OPTEXT (XT+12.*CHSIZE, YT+CHSIZE, 0.5*CHSIZE,
     &  'o',  0.,  1)
      YT = YT - DYT
*
      CALL OPPLOT  (XT-0.1*CHSIZE, YT+1.3*CHSIZE, 'UP')
      CALL OPPLOT  (XT+0.8*CHSIZE, YT+1.3*CHSIZE, 'DOWN')
      CALL PSIGMA (XT       , YT       , 0.95*CHSIZE, 0.95*CHSIZE)
      CALL PTHETA (XT+1.0*CHSIZE, YT-0.7*CHSIZE, 0.75*CHSIZE,
     &  0.75*CHSIZE)
      CHSTR = '   =     .      '
      WRITE (CHSTR(5:11),'(F7.1)') DSPR
      CALL OPTEXT (XT       , YT       , CHSIZE, CHSTR, 0., 11)
      CALL OPTEXT (XT+12.*CHSIZE, YT+CHSIZE, 0.5*CHSIZE, 'o', 0., 1)
*
      IF (NSTATM.EQ.1) THEN                                                    30.00
        YT = YT - 2.*DYT
        CALL OPTEXT (XT       , YT       , CHSIZE, 'DATE :', 0., 6)
        YT = YT - DYT
        CALL OPTEXT (XT       , YT       , CHSIZE, CHTIME, 0., 18)        40.00
      ENDIF                                                               30.00
*
      CALL OPENDF
*
      RETURN
*     end of subroutine PLSPEC
      END
**************************************************************
*                                                            *
      SUBROUTINE  PTHETA  (X, Y, DXOUT3, DYOUT3)
*                                                            *
**************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  1. Purpose :
C
C     Draw a sigma.
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       X        R    I  -      X-coordinate of lower left corner
C       X        R    I  -      Y-coordinate of lower left corner
C       DXOUT3       R    I  -      Size in X-direction
C       DYOUT3       R    I  -      Size in Y-direction
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
*
*  9. Source text : ---------------------------------------------------
*
      REAL X, Y, DXOUT3, DYOUT3
*
      X0 = X
      X1 = X + 0.10*DXOUT3
      X2 = X + 0.25*DXOUT3
      X3 = X + 0.45*DXOUT3
      X4 = X + 0.60*DXOUT3
      X5 = X + 0.70*DXOUT3
*
      Y0 = Y
      Y1 = Y + 0.10*DYOUT3
      Y2 = Y + 0.30*DYOUT3
      Y3 = Y + 0.50*DYOUT3
      Y4 = Y + 0.70*DYOUT3
      Y5 = Y + 0.90*DYOUT3
      Y6 = Y + 1.00*DYOUT3
*
      CALL OPPLOT (X0, Y3, 'UP')
      CALL OPPLOT (X0, Y2, 'DOWN')
      CALL OPPLOT (X1, Y1, 'DOWN')
      CALL OPPLOT (X2, Y0, 'DOWN')
      CALL OPPLOT (X3, Y0, 'DOWN')
      CALL OPPLOT (X4, Y1, 'DOWN')
      CALL OPPLOT (X5, Y2, 'DOWN')
      CALL OPPLOT (X5, Y4, 'DOWN')
      CALL OPPLOT (X4, Y5, 'DOWN')
      CALL OPPLOT (X3, Y6, 'DOWN')
      CALL OPPLOT (X2, Y6, 'DOWN')
      CALL OPPLOT (X1, Y5, 'DOWN')
      CALL OPPLOT (X0, Y4, 'DOWN')
      CALL OPPLOT (X0, Y3, 'DOWN')
      CALL OPPLOT (X5, Y3, 'DOWN')
*
      RETURN
      END
**************************************************************
*                                                            *
      SUBROUTINE  PSIGMA  (X, Y, DXOUT3, DYOUT3)
*                                                            *
**************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  1. Purpose :
C
C     Draw a sigma.
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       X        R    I  -      X-coordinate of lower left corner
C       X        R    I  -      Y-coordinate of lower left corner
C       DXOUT3       R    I  -      Size in X-direction
C       DYOUT3       R    I  -      Size in Y-direction
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
*
*  9. Source text : ---------------------------------------------------
*
      REAL X, Y, DXOUT3, DYOUT3
*
      X0 = X + 0.00*DXOUT3
      X1 = X + 0.10*DXOUT3
      X2 = X + 0.25*DXOUT3
      X3 = X + 0.45*DXOUT3
      X4 = X + 0.60*DXOUT3
      X5 = X + 0.70*DXOUT3
      X6 = X + 0.85*DXOUT3
*
      Y0 = Y + 0.00*DYOUT3
      Y1 = Y + 0.10*DYOUT3
      Y2 = Y + 0.25*DYOUT3
      Y3 = Y + 0.45*DYOUT3
      Y4 = Y + 0.60*DYOUT3
      Y5 = Y + 0.70*DYOUT3
*
      CALL OPPLOT (X6, Y5, 'UP')
      CALL OPPLOT (X4, Y4, 'DOWN')
      CALL OPPLOT (X3, Y5, 'DOWN')
      CALL OPPLOT (X2, Y5, 'DOWN')
      CALL OPPLOT (X1, Y4, 'DOWN')
      CALL OPPLOT (X0, Y3, 'DOWN')
      CALL OPPLOT (X0, Y2, 'DOWN')
      CALL OPPLOT (X1, Y1, 'DOWN')
      CALL OPPLOT (X2, Y0, 'DOWN')
      CALL OPPLOT (X3, Y0, 'DOWN')
      CALL OPPLOT (X4, Y1, 'DOWN')
      CALL OPPLOT (X5, Y2, 'DOWN')
      CALL OPPLOT (X5, Y3, 'DOWN')
      CALL OPPLOT (X4, Y4, 'DOWN')
*
      RETURN
*     end of subroutine PSIGMA
      END
******************************************************************
*                                                                *
      SUBROUTINE PLTAR1 (X0, Y0, ARL, THA, TH2, FAC2, ARLMIN)
*                                                                *
******************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors :
C
C  1. Purpose :
C
C     Plot arrow (centered).
C
C  2. Method :
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       X0, T0   R    I  -      Centre coordinates of array
C       ARL      R    I  -      Arrow length
C       THA      R    I  -      Direction of arrow         (rad.)
C       TH2      R    I  -      Angle in head of arrow     (deg.)
C       FAC2     R    I  -      Length factor head arrow
C       ARLMIN   R    I  -      Minimum arrow length
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - STRACE, PLOT
C
C  5. Called by :
C
C     - Any main program in which INIPLT is called.
C
C  6. Error messages :
C
C  7. Remarks :
C
C  8. Structure :
*
*  9. Source text : ---------------------------------------------------
*
      REAL X0, Y0, ARL, THA, TH2, FAC2, ARLMIN
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLTAR1')
*
      IF (ARL.LT.ARLMIN) RETURN
*
C     PHW  = THA
      PHA1 = THA + TH2 * DEGRAD
      PHA2 = THA - TH2 * DEGRAD
      HARL = 0.5 * ARL
      QARL = FAC2 * HARL
*
      DX1  = HARL * COS(THA)
      DY1  = HARL * SIN(THA)
      DX3  = QARL * COS(PHA1)
      DY3  = QARL * SIN(PHA1)
      DX4  = QARL * COS(PHA2)
      DY4  = QARL * SIN(PHA2)
*
      X1   = X0 - DX1
      Y1   = Y0 - DY1
      X2   = X0 + DX1
      Y2   = Y0 + DY1
      X3   = X2 - DX3
      Y3   = Y2 - DY3
      X4   = X2 - DX4
      Y4   = Y2 - DY4
*
      CALL OPPLOT (X1,Y1,'UP')
      CALL OPPLOT (X2,Y2,'DOWN')
      CALL OPPLOT (X3,Y3,'DOWN')
      CALL OPPLOT (X4,Y4,'DOWN')
      CALL OPPLOT (X2,Y2,'DOWN')
*
      RETURN
      END
**************************************************************
*                                                            *
      SUBROUTINE PLTAR2 (X0,Y0,ARL,THA,TH2,FAC2,ARLMIN)
*                                                            *
**************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. Purpose :
C
C     Plot arrow (centered).
C
C  2. Method :
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       X0, T0   R    I  -      Centre coordinates of array
C       ARL      R    I  -      Arrow length
C       THA      R    I  -      Direction of arrow         (deg.)
C       TH2      R    I  -      Angle in head of arrow     (deg.)
C       FAC2     R    I  -      Length factor head arrow
C       ARLMIN   R    I  -      Minimum arrow length
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - STRACE, PLOT
C
C  5. Called by :
C
C     - Any main program in which INIPLT is called.
C
C  6. Error messages :
C
C  7. Remarks :
C
C  8. Structure :
*
*  9. Source text : ---------------------------------------------------
*
      REAL X0,Y0,ARL,THA,TH2,FAC2,ARLMIN
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT, 'PLTAR2')
*
      IF (ARL.LT.ARLMIN) RETURN
*
      PHA1 = THA + TH2 * DEGRAD
      PHA2 = THA - TH2 * DEGRAD
      PHA3 = THA + 90. * DEGRAD
      HARL = 0.5 * ARL
      QARL = FAC2 * HARL
*
      DX1  = HARL * COS(THA)
      DY1  = HARL * SIN(THA)
      DX3  = QARL * COS(PHA1)
      DY3  = QARL * SIN(PHA1)
      DX4  = QARL * COS(PHA2)
      DY4  = QARL * SIN(PHA2)
      DX5  = QARL * COS(PHA3)
      DY5  = QARL * SIN(PHA3)
*
      X1   = X0 - DX1
      Y1   = Y0 - DY1
      X2   = X0 + DX1
      Y2   = Y0 + DY1
      X3   = X2 - DX3
      Y3   = Y2 - DY3
      X4   = X2 - DX4
      Y4   = Y2 - DY4
      X5   = X0 - DX5
      Y5   = Y0 - DY5
      X6   = X0 + DX5
      Y6   = Y0 + DY5
*
      CALL OPPLOT (X1,Y1,'UP')
      CALL OPPLOT (X2,Y2,'DOWN')
      CALL OPPLOT (X3,Y3,'DOWN')
      CALL OPPLOT (X4,Y4,'DOWN')
      CALL OPPLOT (X2,Y2,'DOWN')
      CALL OPPLOT (X5,Y5,'UP')
      CALL OPPLOT (X6,Y6,'DOWN')
*
      RETURN
      END
**************************************************************
*                                                            *
      SUBROUTINE PLTCIR (R, DASHLN)
*                                                            *
**************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. Purpose :
C
C     Plot a circle with radius R around the origin.
C
C  2. Method :
C
C     The circle is plotted with dashed line pieces.
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       R        R    I  -      Radius of circle in plot units
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - PLOTF
C
C  5. Called by :
C
C     - Any main program in which the routine INIPLT is called.
C
C  6. Error messages :
C
C  7. Remarks :
C
C  8. Structure :
C
*
*  9. Source text : ---------------------------------------------------
*
      PARAMETER (NSMAX = 500)
      REAL    R, DASHLN
      INTEGER KL
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLTCIR')
*
      KL = 1
      IF (ITEST.GE.100) WRITE (PRINTF, 5) PI, R, DASHLN
   5  FORMAT (' PLTCIR.  PI, R, DASHLN: ', 3E12.4)
      NS = NINT(2.*PI*R/DASHLN)
      IF (NS.LT.4) RETURN
      IF (NS.GT.NSMAX) NS = NSMAX
      IF (ITEST.GE.100) WRITE (PRINTF,*) 'NS: ', NS
*
      DPHI = 2.*PI/REAL(NS)
      DPHI1 = DPHI/(1.+REAL(KL))
      DPHI2 = DPHI1 * REAL(KL)
*
      XS1 = SIN(DPHI1)
      XC1 = COS(DPHI1)
      XS2 = SIN(DPHI2)
      XC2 = COS(DPHI2)
      X1 = R
      Y1 = 0.
*
      CALL PLOTF  (X1,Y1,'UP')
      DO 100 IST = 1,NS
        X2 = XC1 * X1 - XS1 * Y1
        Y2 = XS1 * X1 + XC1 * Y1
        CALL PLOTF  (X2,Y2,'DOWN')
        IF (KL.EQ.0) THEN
            X1 = X2
            Y1 = Y2
          ELSE
            X1 = XC2 * X2 - XS2 * Y2
            Y1 = XS2 * X2 + XC2 * Y2
            CALL PLOTF  (X1,Y1,'UP')
          ENDIF
 100  CONTINUE
      RETURN
* end of subroutine PLTCIR
      END
**************************************************************
*                                                            *
      SUBROUTINE PLTLN1 (X1, X2, Y1, Y2, DASHLN)
*                                                            *
**************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. Purpose :
C
C     Plot a (dashed) line.
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       X1       R    I  -      X-coordinate of starting point
C       X2       R    I  -      X-coordinate of end point
C       Y1       R    I  -      Y-coordinate of starting point
C       Y2       R    I  -      Y-coordinate of end point
C       DASHLN   R    I  -      length of dashes
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - PLOTF
*
*  9. Source text : ---------------------------------------------------
*
      INTEGER KL
      REAL    A, DASHLN
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLTLN1')
*
      KL = 1
      A   = SQRT( (X2-X1)**2 + (Y2-Y1)**2 )
      IF ( ABS(A) .GE. 50.) A = 50.
      NS  = MAX(3,NINT(A/DASHLN))
      IF (ITEST.GE.100) WRITE (PRTEST,*)
     &      ' PLTLN1, Length ',A,' Dash ',DASHLN, ' number ', NS
      DX1 = (X2-X1) / REAL(NS*(1+KL))
      DX2 = REAL(KL) * DX1
      DY1 = (Y2-Y1) / REAL(NS*(1+KL))
      DY2 = REAL(KL) * DY1
      X = X1
      Y = Y1
*
      CALL PLOTF (X,Y,'UP')
      DO 100 IS = 1, NS
        X = X + DX1
        Y = Y + DY1
        CALL  PLOTF (X,Y,'DOWN')
        X = X + DX2
        Y = Y + DY2
        IF (KL.NE.0) CALL  PLOTF (X,Y,'UP')
 100  CONTINUE
      RETURN
*  end of subroutine PLTLN1
      END
**************************************************************
*                                                            *
      SUBROUTINE PLTSEG(RADC, PSMAX, PSI, X1, X2, Y1, Y2)
*                                                            *
**************************************************************
C
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C  1. Purpose :
C
C     Compute coordinates of the begin and end points of a line
C     starting on a circle with radius RADC and end point on the
C     side of a square box with size PSMAX. Direction of line
C     PSI degrees.
C
C  3. Parameters used :
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       RADC     R    I  -      Radius of inner circle
C       PSMAX    R    I  -      Size of outer box
C       PSI      R    I  -      Direction in degrees
C       X1       R    O  -      X-coordinate of starting point
C       X2       R    O  -      X-coordinate of end point
C       Y1       R    O  -      Y-coordinate of starting point
C       Y2       R    O  -      Y-coordinate of end point
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
*
*  9. Source text : ---------------------------------------------------
*
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLTSEG')
*
      T90  = 0.5 * PI
      T270 = 1.5 * PI
      PHI  = PSI * DEGRAD
      X1   = RADC * COS(PHI)
      Y1   = RADC * SIN(PHI)
      ISEG = NINT (PHI/T90) + 1
*
      IF(ISEG.EQ.5) ISEG = 1
*
      IF(ISEG.EQ.1) THEN
          X2 = PSMAX
          Y2 = PSMAX * TAN(PHI)
      END IF
*
      IF(ISEG.EQ.2) THEN
          X2 = -PSMAX * TAN(PHI-T90)
          Y2 = PSMAX
      END IF
*
      IF(ISEG.EQ.3) THEN
          X2 = -PSMAX
          Y2 = -PSMAX*TAN(PHI)
      END IF
*
      IF(ISEG.EQ.4) THEN
          X2 = PSMAX * TAN(PHI-T270)
          Y2 = -PSMAX
      END IF
*
      RETURN
*  end of subroutine PLTSEG
      END
***********************************************************************
*                                                                     *
      SUBROUTINE PLT2DS (NORMS2, SPCSIG, RCIR, LOGPL, ACLOC,              30.72
     *                   NHTS, CHTS, ILN, SPCDIR)
*                                                                     *
***********************************************************************
C
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description for several variables
C
C
C  2. Purpose :
C
C     Polar contour plot of 2-D spectrum
C
C  3. Method :
C
C     See documentation of routine PLTISO
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       ANGLS    RA   I  -      Y-coordinates (direction in radians)
C       NFREQ,NANGL  I    I  -      Number of grid points in x- and y-dir.
C       NHTS     I    I  -      Number of contour heights
C       DASHLN   R    O  CPLT2  Step in drawing auxilary lines and
C                               circles
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C     (See also section 5.)
C
C  4. Subroutines used :
C
C     - STRACE      (service)
C
C     - PLTCIR      *
C     - PLTISO      | "Second level" plot routines
C     - PLTLN1      | not machine dependent
C     - PLTSEG      *
C
C     - LNTYPE      *  "First level plot routines
C     - OPPLOT      |  i.e. basic plot routine
C     - OPTEXT      *  (may be) machine dependent
C
C  5. Called by :
C
C     Any main program in which the following parameters have been
C     assigned before this routine is called (Common CPLTS)
C
C
C      NN        Number of segments of an elementary line in
C                       PLTISO
C      IC1       Number of steps after which a number is plotted
C      IC2       Number of steps between succeeding numbers
C      NLS       Number of line segments of an axis
C      KL        Factor for dashed line
C      ILN       Parameter specifying whether the lines and
C                circles must be plotted
C                ILN = 0, no lines and circles
C                ILN = 1, lines  are plotted
C                ILN = 2, circles are plotted
C                ILN = 3, lines and circles are plotted
C      LTEST     Level of testing for subroutine PLTISO
C      NCIR      Number of circles in plot, radii in array RCIR
C      FRMAX      size of grid
C      XNORM     normalization parameter for x-axis
C      XNMAX     maximum x-value after normalization
C      NZERO     if.eq.1 outer ring equal to zero
C      SIZE      radius of plot in mm (now dummy)
C      DINIT     first angle at ...  degrees
C      DSTEP     directional step in degrees for lines
C      NBOTH     .EQ.0, plot and normalize only positive part
C                .EQ.1, plot and normalize pos. and neg. parts
C      NORMS2     Parameter specifying normalization
C                     NORMS2.EQ.0 ,no normalization
C                     NORMS2.EQ.1 , norm. of x-axis
C                     NORMS2.EQ.2 , norm. of h-values
C                     NORMS2.EQ.3 , norm. of h- and x-values
C
C      RCIR       Radii of cicles
C      HTS        Contour heights
C
C  6. Error messages :
C
C     - This routine stops program execution if dimensions of arrays are
C       incorrect
C
C  7. Remarks :
C
C     - PLOTS and OPENDF not called
C     - Maximum number of grid points      NSMAX
C     - Maximum number of contour heights  NVMAX
C     - Two dimensional plot array for routine PLTISO transferred as
C       one-dimensional array.
C
C  8. Structure :
C
C     -----------------------------------------------
C       initialisations :
C         - set variables in common's CPLT1, CPLT2
C         - "unpack" array IPAR
C         - convert SIGMA to X
C       Adjust X-axis
C         - if asked, normalize X-axis
C         - set maximum if H normalized
C       Set sizes (world coordinates)
C       Test output
C       Check dimensions
C       Set outer ring to zero if requested
C       Initiate plot
C         - plot border
C         - set size of numbers
C         - title above figure
C         - plot dashed circles
C         - plot dashed lines
C         - plot wind arrow
C       Filling of array SF                        DELETED
C         - minimum, maximum and initial filling
C         - normalisation
C       Prepare contour levels
C       Plot isolines
C       Plot contour level scale
C       Terminate plot
C     -----------------------------------------------
*
*  9. Source text :
*
      REAL    ACLOC(MSC,MDC+1), RCIR(*), CHTS(*)                          20.41
      LOGICAL LOGPL(MSC,MDC+1)
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLT2DS')
*
*     initialisations : -----------------------------------------------
*
*      DO 100 ID = 1,MDC+1
*        ANGLS (ID) = FLOAT(ID-1)*2.*PI/FLOAT(MDC)
*        IF (ITEST.GE.100) WRITE (PRINTF,6000) ID,ANGLS(ID)
* 6000   FORMAT ('ID,ANGLS(ID):',I6,E12.4)
* 100  CONTINUE
*
*     Set sizes (world coordinates) : ---------------------------------
*
      DASHLN  = (XFHI-XFLO) / 20.
*
*     Initiate plot : -------------------------------------------------
*
*     Plot border :
*
      CALL OPPLOT (XPLO,YPLO,'UP')
      CALL OPPLOT (XPLO,YPHI,'DOWN')
      CALL OPPLOT (XPHI,YPHI,'DOWN')
      CALL OPPLOT (XPHI,YPLO,'DOWN')
      CALL OPPLOT (XPLO,YPLO,'DOWN')
*
*     Plot dashed circles :
*
      R1  = 0.
      IF (ITEST.GE.100) WRITE (PRINTF,910) ILN
  910 FORMAT ('ILN: ',I6)
      NCIR = 3
      IF (ILN.GE.2) THEN
          DO 400 ICIR = 1,NCIR
            RR = RCIR(ICIR)
*            IF (NORMS2.EQ.1 .OR. NORMS2.EQ.3) RR = RR * FPEAK
            IF (ICIR.EQ.1) R1 = RR
            IF (RR.GT.0.) CALL PLTCIR (RR, DASHLN)
            IF (ITEST.GE.100) WRITE(PRINTF,920) ICIR, RR
  920       FORMAT ('ICIR: ',I6,' RR: ',E12.4)
  400     CONTINUE
      ENDIF
*
*     Plot dashed lines :
*
      IF (ILN.EQ.1.OR.ILN.EQ.3) THEN
          II = NINT(360./45.)
          DO 410 I = 1,II
            PHI = (FLOAT(I)-1.)*45.
            CALL PLTSEG (R1, RCIR(3), PHI, X1, X2, Y1, Y2)
            CALL PLTLN1 (X1, X2, Y1, Y2, DASHLN)
  410     CONTINUE
      ENDIF
*
*     Determine minimum and maximum and initial filling
*
      HMIN = 0.
      HMAX = 0.
*     LL = 0                    not used
      DO 510 ID = 1, MDC+1
        DO 500 IS = 1, MSC
          IF (ITEST.GE.250) WRITE (PRINTF,6010) ID, IS, ACLOC (IS,ID)
 6010     FORMAT ('PLT2DS,DETH: ID,IS,ACLOC',2I6,E12.4)
          IF(ACLOC(IS,ID).GT.HMAX) HMAX = ACLOC(IS,ID)
          IF(ACLOC(IS,ID).LT.HMIN) HMIN = ACLOC(IS,ID)
  500   CONTINUE
  510 CONTINUE
*
*     Normalization of H-values :
*
      IF (NORMS2.GE.2) THEN
         HHM = HMAX
*         IF (ITEST.GE.100) WRITE(PRTEST,922) HMAX, HMIN
      ELSE
         HHM = 1.
      ENDIF
*
*     Prepare contour levels : ----------------------------------------
*
      DO 600 IV = 1,NHTS
*
*       Plot of contour lines or color bands: -------------------------
*
        CALL PLTISO (SPCSIG, HHM*CHTS(IV), LOGPL, ACLOC, SPCDIR)          30.72
 600  CONTINUE
*
*     Termination of plot : -------------------------------------------
*
      RETURN
*
      END
************************************************************************
*                                                                      *
      SUBROUTINE PLTISO (SPCSIG, CHTS, LOGPL, ACLOC, SPCDIR)              30.72
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description for several variables
C
C  2. Purpose :
C
C     Contour plot with isolines on a rectangular grid
C
C  3. Method :
C
C     A description of the contouring algorithm can be found in:
C     Sutcliffe, D.C., 1980: Contouring over rectangular and
C     skewed grids - an introduction,
C     In 'Mathematical Method in Computer Graphics and Design',
C     K.W. Brodlie, ed., Academic Press.
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       HH       RA   I  -   Work array with dimension (NFREQ,NANGL),
C                            containing function of which contour
C                            lines are to be plotted
C       X        RA   I  -   X-Coordinates of gridpoints
C       ANGLS    RA   I  -   Y-Coordinates of gridpoints
C       NFREQ, NANGL   I    I  -   Number of grid points in X- and Y-direction
C       NHTS     I    I      Number of contour heights (maximum = 14)
C       CHTS     RA  I/O     Real array with dimension of
C                            at least NHTS, containing contour heights
C       LOGPL    LA   I      Logical array used as working space with
C                            dimension (NFREQ,NANGL)
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - STRACE, TRAFO, PLOT
C
C  5. Called by :
C
C     - Any main plogram which has called INIPLT.
C
C  7. Remarks :
C
C     Variables in COMMON /CPLT1/
C
C     Name    Type  Description
C     -------------------------
C     IPLOT    I    Parameter specifying plot option
C                   IPLOT = 0, no plotting of lines
C                         = 1, plotting option on
C     NN       I    Number of segments in which a basic line has
C                   to be divided
C     LTEST    I    Parameter specifying quantity of test output
C                   of intermediate results
C     IC1      I    Number of steps after which the first number
C                   is plotted on a contour line
C     IC2      I    Number of steps between succeeding plot actions
C                   of a number on a contour line
C
C  8. Structure :
*
C 13. Source text:
*
      REAL CHTS, ACLOC(MSC,MDC+1), NN                                     20.41
      LOGICAL LOGPL(MSC,MDC+1)
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'PLTISO')
*------------------------------------------------------------*
*     100: INITIALISATIONS
*
      NN = 2.
      IC1 = 1
      IC2 = 1
      IPLOT = 1
      IF (FULCIR) THEN                                                    20.57
        MDCLOC = MDC + 1
      ELSE
        MDCLOC = MDC
      ENDIF                                                               20.57
      DO 111 ID = 1,MDCLOC                                                30.72
        DO 110 IS = 1,MSC
          LOGPL(IS,ID) = .FALSE.
  110   CONTINUE                                                          30.72
  111 CONTINUE                                                            30.72
      NSTOT = MSC * MDCLOC                                                20.57
*------------------------------------------------------------*
*     START OF LOOP FOR ALL CONTOUR HEIGHTS
*
      ILINE = 0
      NOPEN = 0
      NCLOSE = 0
      IF (ITEST.GE.80) WRITE (PRTEST,390) CHTS
 390  FORMAT (' PLTISO, contouring value:', F14.4)
*------------------------------------------------------------*
*       400: COMPUTE CROSSINGS WITH HORIZONTAL LINES
*
      DO 411 ID = 1, MDCLOC                                               20.57
*        loop changed from 1 to MSC into 1 to MSC-1
         DO 410 IS = 1, MSC-1
            IF (ACLOC(IS,ID).LT.CHTS.AND.
     &          CHTS.LE.ACLOC(IS+1,ID)) LOGPL(IS,ID) = .TRUE.
*           LOGPL is True means: contour must cross lower side of this mesh
*           LOGPL is made False after crossing with contour has been found
  410   CONTINUE
  411 CONTINUE
*
*------------------------------------------------------------*
*       450: compute boundary intersections
*
      IOPEN = 1
      IS    = 1
      IBACK = 5
*------------------------------------------------------------*
*       LOWER BOUNDARY  IDIR = 1
*
  500 CONTINUE
      IF(ACLOC(IS,1).LT.CHTS.AND.
     &     CHTS.LE.ACLOC(IS+1,1)) THEN
          NOPEN = NOPEN + 1
          LOGPL(IS,1) = .FALSE.
          IAX  = IS
          IAY  = 1
          IDIR = 1
          IRX  = 0
          IRY  = 1
          XZ   = SPCSIG(IS) + (CHTS -ACLOC(IS,1)) /                       30.72
     &           (ACLOC(IS+1,1) -ACLOC(IS,1)) *
     &           (SPCSIG(IS+1) - SPCSIG(IS))                              30.72
          YZ   = FLOAT(1)
          GOTO 2000
      END IF
  550 CONTINUE
      IS = IS + 1
      IF (IS .LT. MSC) GOTO 500
*
      ID    = 1
      IBACK = 6
*------------------------------------------------------------*
*       RIGHT BOUNDARY   IDIR = 2
*
  600 CONTINUE
      IF (ACLOC(MSC,ID).LT.CHTS.AND.
     &     CHTS.LE.ACLOC(MSC,ID+1)) THEN
          NOPEN = NOPEN + 1
          IAX  = MSC
          IAY  = ID
          IDIR = 2
          IRX  = -1
          IRY  = 0
          XZ   = SPCSIG(MSC)                                              30.72
          YZ   = FLOAT(ID) + (CHTS-ACLOC(MSC,ID)) /
     &          (ACLOC(MSC,ID+1) - ACLOC(MSC,ID)) *
     &          (FLOAT(ID+1) - FLOAT(ID))
          GOTO 2000
      END IF
  650 CONTINUE
      ID = ID + 1
      IF(ID.LT.MDCLOC) GOTO 600                                           20.57
*
      IS    = MSC
      IBACK = 7
*------------------------------------------------------------*
*       UPPER BOUNDARY   IDIR = 3
*
  700 CONTINUE
      IF (ACLOC(IS,MDCLOC).LT.CHTS .AND.                                  20.57
     &      CHTS.LE.ACLOC(IS-1,MDCLOC)) THEN                              20.57
          NOPEN = NOPEN + 1
          IAX  = IS
          IAY  = MDCLOC
          IDIR = 3
          IRX  = 0
          IRY  = -1
          XZ   = SPCSIG(IS) + (CHTS-ACLOC(IS,MDCLOC)) /                   30.72
     &          (ACLOC(IS-1,MDCLOC) - ACLOC(IS,MDCLOC)) *                 20.57
     &          (SPCSIG(IS-1) - SPCSIG(IS))                               30.72
          YZ   = FLOAT(MDCLOC)                                            20.57
          GOTO 2000
        END IF
  750 CONTINUE
      IS = IS - 1
      IF (IS .GT. 1) GOTO 700
*
      ID    = MDCLOC                                                      20.57
      IBACK = 8
*------------------------------------------------------------*
*       LEFT BOUNDARY  IDIR = 0
*
  800 CONTINUE
      IF(ACLOC(1,ID).LT.CHTS.AND.CHTS.LE.ACLOC(1,ID-1)) THEN
          NOPEN = NOPEN + 1
          IAX  = 1
          IAY  = ID
          IDIR = 0
          IRX  = 1
          IRY  = 0
          XZ   = SPCSIG(1)                                                30.72
          YZ   = FLOAT(ID) + (CHTS-ACLOC(1,ID)) /
     &          (ACLOC(1,ID-1) - ACLOC(1,ID)) *
     &          (FLOAT(ID-1) - FLOAT(ID))
          GOTO 2000
      END IF
  850 CONTINUE
      ID = ID - 1
      IF(ID.GT.1) GOTO 800
*
      IS = 2
      ID = 1
      IOPEN = 0
      IBACK = 9
*------------------------------------------------------------*
*        interior starting point of contour
*
  900 CONTINUE
      IF(LOGPL(IS,ID)) THEN
          NCLOSE = NCLOSE + 1
          LOGPL(IS,ID) = .FALSE.
          IAX = IS
          IAY = ID
          IFRS = IS
          IANGS = ID
          IDIR = 1
          IRX = 0
          IRY = 1
          XZ = SPCSIG(IS) + (CHTS-ACLOC(IS,ID)) /                         30.72
     &        (ACLOC(IS+1,ID) - ACLOC(IS,ID)) *
     &        (SPCSIG(IS+1)-SPCSIG(IS))                                   30.72
          YZ = FLOAT(IAY)
          GOTO 2000
      END IF
  950 CONTINUE
      IS = IS + 1
      IF(IS.GE.MSC) THEN
         IS = 1
         ID = ID + 1
      END IF
      IF (ID.LT.MDCLOC) GOTO 900                                          20.57
*----------------------------------------------------------------------*
*       no more lines with height CHTS
*
      GOTO 8000
*----------------------------------------------------------------------*
*      initialisations and start of next contour line
*
 2000 CONTINUE
*
      ILINE = ILINE + 1
      XA  = SPCSIG(IAX)                                                   30.72
      YA  = FLOAT(IAY)
      XOLD = XZ
      YOLD = YZ
*----------------------------------------------------------------------*
*     move pen to beginning of a contour line
*
      CALL TRAFO (XOLD, YOLD, XPLOT, YPLOT, SPCDIR)
      IF(IPLOT.GE.1) CALL PLOTF (XPLOT,YPLOT,'UP')
*----------------------------------------------------------------------*
*     check for plotting of number on a contour line
*
      ISTEP = 0
      ICC   = 0
      ICPF3   = IC1
      LCNR  = 0
*----------------------------------------------------------------------*
*            repetitive part of determination of contour
*----------------------------------------------------------------------*
 3000 CONTINUE
      ISTEP = ISTEP + 1
      ICC = ICC + 1
      IF(ICC.EQ.ICPF3) THEN
        LCNR = 1
        ICC = 0
        ICPF3 = IC2
*        IF(ITEST.GE.140) WRITE(PRTEST,9401) ISTEP,ICPF3,IAX,IAY
      END IF
      IF(LCNR.EQ.1.AND.IPLOT.GE.1) THEN
        LCNR = 0
      END IF
*----------------------------------------------------------------------*
*     check for maximum number of steps for one contourline
*
      XA  = SPCSIG(IAX)                                                   30.72
      YA  = FLOAT(IAY)
      IF(ISTEP.GT.NSTOT) THEN
*        WRITE(PRTEST,9902) ISTEP
        GOTO 8000
      END IF
*      IF(ITEST.GE.190) WRITE(PRTEST,9203) ISTEP,IBACK,IDIR,IRX,IRY
*----------------------------------------------------------------------*
*     compute indices and height at corners of cell
*
*                       A - - - B                     IDIR=1
*                       |       |                       |
*      (IDIR =0)      --->      |             IDIR=2 <--O--> IDIR=0
*                       |       |                       |
*                       D - - - C                     IDIR=3
*
*     high ground remains at the right side of the contour:
*
*              F(i,j) < CHTS
*           ---->              (case IDIR=0)
*              F(i,j) > CHTS
*
      IBX = IAX + IRY
      IBY = IAY - IRX
      ICX = IAX + IRX + IRY
      ICY = IAY - IRX + IRY
      IDX = IAX + IRX
      IDY = IAY + IRY
*     function values on the 4 corners of the mesh
      HA  = ACLOC(IAX,IAY)
      HB  = ACLOC(IBX,IBY)
      HC  = ACLOC(ICX,ICY)
      HD  = ACLOC(IDX,IDY)
      IF (ITEST.GE.100) WRITE (PRINTF,145) IAX,IAY,HA,IRX,IRY,IDIR
 145  FORMAT (' point A, shift, dir:', 2I7, F9.4, 6I7)
      IF (ITEST.GE.100) WRITE (PRINTF,147) IBX,IBY,HB,ICX,ICY,HC,
     &      IDX,IDY,HD
 147  FORMAT (' points B,C,D  IX&IY:', 3(2I7, 1X, F9.4))
*
*     remove marker
*
      IF(IDIR.EQ.1) LOGPL(IAX,IAY) = .FALSE.
*----------------------------------------------------------------------*
*     compute size of cell
*
      IF(IDIR.EQ.1.OR.IDIR.EQ.3) THEN
        DXOUT3  = ABS(SPCSIG(IAX) - SPCSIG(IBX))                          30.72
        DYOUT3  = ABS(FLOAT(IAY) - FLOAT(IDY))
      END IF
      IF(IDIR.EQ.0.OR.IDIR.EQ.2) THEN
        DXOUT3  = ABS(FLOAT(IAY) - FLOAT(IBY))
        DYOUT3  = ABS(SPCSIG(IAX) - SPCSIG(IDX))                          30.72
      END IF
*----------------------------------------------------------------------*
*     compute new direction; IREL is change in IDIR
*
      ISR = 0
      ISS = 0
      ISL = 0
*     ISR=1: contour line passes between B and C
      IF(HC.LT.CHTS.AND.CHTS.LE.HB) ISR = 1
*     ISS=1: contour line passes between C and D
      IF(HD.LT.CHTS.AND.CHTS.LE.HC) ISS = 1
*     ISL=1: contour line passes between D and A
      IF(HA.LT.CHTS.AND.CHTS.LE.HD) ISL = 1
*      IDEG = 0
*----------------------------------------------------------------------*
*     compute XRS and YRS: relative position with respect to A (XA,YA)
*                          where line leaves cell
*
      IF(ISR.EQ.1.AND.ISL.EQ.1) THEN
*
*       special case: two contours go through one mesh
*
*       IDEG = 1
        HM = 0.25 *(HA + HB + HC + HD)
        IF(HM.LE.CHTS) THEN
*----------------------------------------------------------------------*
*         use the rule for high ground on the right
*
          IREL = -1
          XRS = DXOUT3
          YRS = (CHTS-HB)/(HC-HB) * DYOUT3
        ELSE
          IREL = 1
          XRS = 0.
          YRS = (CHTS-HA)/(HD-HA) * DYOUT3
        END IF
      ELSE
*       only one contour through the mesh
        IF(ISR.EQ.1) THEN
          IREL = -1
          XRS = DXOUT3
          YRS = (CHTS-HB)/(HC-HB) * DYOUT3
        END IF
        IF(ISS.EQ.1) THEN
          IREL = 0
          XRS = (CHTS-HD)/(HC-HD) * DXOUT3
          YRS = DYOUT3
        END IF
        IF(ISL.EQ.1) THEN
          IREL = 1
          XRS = 0.
          YRS = (CHTS-HA)/(HD-HA) * DYOUT3
        END IF
      END IF
*
*     positive direction is clockwise
*     IREL = 0   no rotation
*     IREL = -1, rotation over -90 degrees, clockwise
*     IREL =  1, rotation over +90 degrees, anti clockwise
*
      IRXN = IRX
      IRYN = IRY
      IF(IREL.EQ.-1) THEN
        IRXN =  IRY
        IRYN = -IRX
      END IF
      IF(IREL.EQ.1) THEN
        IRXN = -IRY
        IRYN =  IRX
      END IF
      IRX = IRXN
      IRY = IRYN
*
      IF(IDIR.EQ.0) THEN
        XS = XA + YRS
        YS = YA - XRS
      END IF
      IF(IDIR.EQ.1) THEN
        XS = XA + XRS
        YS = YA + YRS
      END IF
      IF(IDIR.EQ.2) THEN
        XS = XA - YRS
        YS = YA + XRS
      END IF
      IF(IDIR.EQ.3) THEN
        XS = XA - XRS
        YS = YA - YRS
      END IF
      XNEW = XS
      YNEW = YS
*----------------------------------------------------------------------*
*      divide line between old and new position in NN segments and
*      compute transformed coordinates of every segment,
*      plot line in NN segments
*
      SX = (XNEW - XOLD)/NN
      SY = (YNEW - YOLD)/NN
      DO  II = 1, NINT(NN)
        XX = XOLD + II * SX
        YY = YOLD + II * SY
        CALL TRAFO (XX, YY, XPLOT, YPLOT, SPCDIR)
        IF (IPLOT.GE.1) CALL PLOTF (XPLOT,YPLOT,'DOWN')
      ENDDO
      XOLD = XNEW
      YOLD = YNEW
*
      INEW = IDIR + IREL
      IF(INEW.LT.0) INEW = INEW + 4
      IF(INEW.GT.3) INEW = INEW - 4
      IDIR = INEW
*
*     determine corner A of new mesh
*
      IF(IREL.EQ.-1) THEN
*       C becomes new A
        IAX = ICX
        IAY = ICY
      END IF
      IF(IREL.EQ.0) THEN
*       D becomes new A
        IAX = IDX
        IAY = IDY
      END IF
*
*     check for end of contour
*
      IF (ITEST.GE.100) WRITE (PRINTF,8010) IOPEN,IDIR,IAX,IAY,MSC,MDC
 8010 FORMAT ('IOPEN,IDIR,IAX,IAY,MSC,MDC:',6I6)
      IF(IOPEN.EQ.1) THEN
        IF(IDIR.EQ.0.AND.IAX.EQ.MSC) GOTO 7000
        IF(IDIR.EQ.1.AND.IAY.EQ.MDCLOC) GOTO 7000                         20.57
        IF(IDIR.EQ.2.AND.IAX.EQ.1)  GOTO 7000
        IF(IDIR.EQ.3.AND.IAY.EQ.1)  GOTO 7000
      ELSE
        IF(IAX.EQ.IFRS.AND.IAY.EQ.IANGS.AND.IDIR.EQ.1) GOTO 7000
      END IF
      GOTO 3000
*----------------------------------------------------------------------*
*     END OF CONTOUR LINE ENCOUNTERED
*
 7000 CONTINUE
      IF(ITEST.GE.100) WRITE(PRINTF,9301)
     &                ISTEP,IAX,IAY,XA,YA,XNEW,YNEW,XPLOT,YPLOT
 9301 FORMAT(' Contour closed, NSTEP IAX/Y X/YA XX/YY X/YPLOT : ',
     &       1X,3I5,6F10.3)
*
*----------------------------------------------------------------------*
*     branch back to specified statement to search beginning of
*     a new contour line
*
      GOTO (550,650,750,850,950) (IBACK-4)
 8000 CONTINUE
*      IF(ITEST.GE.160) WRITE(PRTEST,9801) NOPEN,NCLOSE
 9000 CONTINUE
*
**
      RETURN
      END
**************************************************************
*                                                            *
      SUBROUTINE TRAFO (XIN, YIN, XOUT, YOUT, SPCDIR)                     20.43
*                                                            *
**************************************************************
C
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm3.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.62: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C
C  1. Updates
C
C     30.62, Aug. 97: Placed a missing comma in FORMAT statement
C     30.82, Oct. 98: Updated description of several variables
C
C  2. Purpose :
C
C     Transform polar coordinates to rectangular coordinates.
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
C
C       param.  type  1) 2)
C     -----------------------------------------------------------------
C       XIN      R    I  -      (Normalized) frequency
C       YIN      R    I  -      Direction (number of dir. steps)          40.00
C       XOUT     R    O  -      output X
C       YOUT     R    O  -      output Y
C     -----------------------------------------------------------------
C            1) Input/Output     2) Common area (- : parameter list
C
C  4. Subroutines used :
C
C     - STRACE
C
C  5. Called by :
C
C     - PLTISO, .....
*
C 13. Source text:
C
      REAL XIN, YIN, XOUT, YOUT
      SAVE IENT
      DATA IENT /0/
      CALL STRACE (IENT,'TRAFO')
*
      ID   = NINT(YIN)
      IF (FULCIR) THEN
        MDC2 = MDC+1
      ELSE
        MDC2 = MDC
      ENDIF
      IF (ID.LT.1 .OR. ID.GT.MDC2) THEN
        WRITE (PRINTF, 10) YIN, ID
  10    FORMAT (' error TRAFO, dir ', F6.3, 3I5)                          40.00
      ELSE
        IF (ID.EQ.MDC2) ID = ID-1
        R2 = YIN - REAL(ID)
        R1 = 1. - R2
        ID2 = ID+1
        IF (ID2.EQ.MDC+1) ID2 = 1
        COSDIR = R1 * SPCDIR(ID,2) + R2 * SPCDIR(ID2,2)                   20.43
        SINDIR = R1 * SPCDIR(ID,3) + R2 * SPCDIR(ID2,3)                   20.43
        XOUT = XIN * COSDIR                                               15/JAN
        YOUT = XIN * SINDIR                                               15/JAN
        IF (ITEST.GE.120) WRITE (PRINTF, 90) XIN,YIN,ID,XOUT,YOUT
  90    FORMAT ('XIN,YIN,ID,XOUT,YOUT: ',
     &             2(1X,E12.4),I4, 2X, 2(1X,E12.4))                       30.62
      ENDIF
      RETURN
      END
