!NRL: $Id: swanpre1.F,v 1.3.2.6 2003/07/02 22:05:05 dykes Exp $
!NRL: $Name:  $
C     SWAN/READ file 1 of 2
C
C Contents of this file:
C
C     SWREAD:  Reading and processing of the user commands describing the model
C     SINPGR:  Read parameters of an input grid
C     SREDEP
C     SSFILL
C     CGINIT
C     SWDIM
C     CGBOUN   determines boundary of true computational region
C     INITVA:  Processing command INIT and compute initial state of       30.70
C              the wave field                                             30.70
C     BACKUP                                                              40.00
C
************************************************************************
*                                                                      *
      SUBROUTINE SWREAD (COMPUT, POOL, RPOOL)                             30.90
*                                                                      *
************************************************************************
 
C     Modules
 
      USE OUTP_DATA                                                       40.13
C     Include common storage for action densities                         NRL
      USE M_ACDEN                                                         NRL
 
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm1.inc'                                              30.74
!     ocpcomm2.inc is now accessible via USE OUTP_DATA                    40.13
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
!MCEL+ J Dykes 15 Oct 2002 SWREAD: includes
      include 'MCEL.inc'
      include 'mcel_swan.inc'
!MCEL-
#ifdef API
      include 'coupling_api.inc'
#endif
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C
C  0. Authors
C
C     30.60: Nico Booij
C     30.61: Roberto Padilla
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     30.75: Nico Booij
C     30.80: Nico Booij
C     30.81: Annette Kieftenburg
C     30.82: IJsbrand Haagsma
C     30.90: IJsbrand Haagsma
C     32.01: Roeland Ris & Cor van der Schelde
C     32.02: Roeland Ris & Cor van der Schelde (1D-version)
C     32.06: Roeland Ris
C     33.08: W. Erick Rogers
C     33.09: Nico Booij
C     33.10: W. Erick Rogers and Nico Booij
C     34.01: Jeroen Adema
C     40.00, 40.13: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.03, 40.13: Nico Booij
C     40.09: Annette Kieftenburg
C     40.10: IJsbrand Haagsma
C     40.12: IJsbrand Haagsma
!     40.18: Annette Kieftenburg
C
C  1. Updates
C
C     30.60, July 97: command CGRID, exception values added
C     30.60, Aug. 97: JCOOX and JCOOY used when addingco ordinate arrays change in
C                     command BOUND option SEGM
C     30.60, Aug. 97: PNUMS(20) is set to 0.1 in command WIND if third generation
C                     is used
C     30.60, Aug. 97: argument XYTST added in call of SWDIM
C     30.60, Aug. 97: activate initial condition in commands WIND and GEN3
C     30.60, Aug. 97: command CGRID, default keyword is REG keyword EXC is not
C                     required
C     30.60, Aug. 97: command OBST, names changed into ALPHA and BETA; control
C                     strings changed from UNC into STA
C     30.60, Aug. 97: uncommented statement CALL WRNKEY
C     30.70, Sep. 97: value of PWTAIL(1) is set to 5 in command GEN3 JANS,
C                     GROWTH JANS and WCAP JANS
C     30.72, Oct. 97: logical function EQREAL introduced for floating point
C                     comparisons
C     30.72, Nov. 97: Added the command syntax for all the commands as comments
C                     from the user manual
C     30.72, Nov. 97: Header renewed, updated method and argument variable
C                     description
C     30.72, Nov. 97: Did set the correct pointers for command GEN3 JANS, as
C                     was already done correctly for command WCAP JANS
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     30.72, Jan. 98: Removed reference to quadruplets in WIND command
C     32.01, Jan. 98: Introduced SET NAUT command (project h3268)
C     32.01, Jan. 98: Introduced keyword CON/VAR in command
C                     BOU STAT ... SPEC1D/SPEC2D
C     30.72, Jan. 98: Moved BOU NONSTAT non operational warning to end of
C                     command BOU
C     30.72, Jan. 98: Changed size of JAUX(7) array to MCGRD
C     32.01, Jan. 98: Modifications for nautical convention, interpolation of
C                     spectra at the boundary and warning (project h3268)
C     32.02, Feb. 98: Introduced 1D-version
C     30.70, Feb. 98: MODE DYN modified into MODE NONSTationary
C                     option WINDGrowth added in command OFF
C                     Nautical convention introduced into command CGRID (sector)
C                     in command SET name 'negmes' changed into 'maxmes'
C     30.72, Mar. 98: Leave limiter on when ITRIAD > 0 in command OFF QUAD
C     30.70, Mar. 98: option CON/VAR after options SPEC1D/SPEC2D
C                     keyword STAT made optional
C                     name GRWMX changed into LIMITER
C                     assignment of limiter in command OFF QUAD corrected
C     30.75, Mar. 98: set ICOND=1 (default init.cond.) for nonstationary mode
C     30.82, Apr. 98: removed reference to commons KAART and KAR
C     40.00, Sep. 98: in command OBST square of TRCOEF is stored (this is used
C                     as transmission coefficient for action density)
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.81, Nov. 98: Adjustment for 1-D case of new boundary conditions
C     30.80, Nov. 98: Provision for limitation on Ctheta (refraction)
C     40.00, Jan. 99: new command OUTPUT QUANTITY: allows user to change
C                     properties of output quantities.
C     34.01, Feb. 99: Introducing STPNOW
C     30.82, Mar. 99: Deactivate limiter for GEN1 and GEN2
C     40.00, Apr. 99: restructure command MODE: Nonstat Oned is now possible
C     33.08, July 98: input for model with higher order "S&L" scheme.
C     33.09, Aug. 98: input for spherical coordinates
C     32.06, June 99: Set correct values for IGEN
C     30.82, Aug. 99: Modified default values for PTRIAD, after deactivating
C                     limiter for only the triads.
C     30.82, Aug. 99: Modified command NUM to include settings for the SETUP
C                     and the global stop criterion
C     40.01, Sep. 99: XASM and YASM replace fixed numbers
C     40.03, Dec. 99: command QUANTITY corrected
C     40.10, Mar. 00: prepared for exact quadruplets
C     33.10, Jan. 00: input for model with higher order "SORDUP" scheme
C     40.03, May  00: command INCLude added, array INCNUM added
C     40.09, May  00: TRCOEF**2 replaced by TRCOEF (to make command options
C                     TRANSM and DAM consistent with one another in subroutine
C                     SWTRCOEF in swanser)
C     40.09, May. 00: Reflection command option added
C     40.03, Aug. 00: error message if start time is before current time (command COMP)
C            Sep. 00: inconsistency with manual corrected
C     40.02, Sep. 00: Changed SCHEME command to PROP and handling [cdlim] modified
C     40.02, Oct. 00: In case of Nautical directions then output in not w.r.t. frame
C     40.02, Oct. 00: Recalculate whitecapping coefficients for new SWCAP routine
C     40.02, Oct. 00: Avoided real/int conflict by introducing RPOOL in SREDEP
C     40.02, Oct. 00: Avoided real/int conflict by introducing replacing
C                     RPOOL for POOL in various calls
C     40.02, Oct. 00: Initialisation of IERR
C     40.12, Feb. 01: Avoided type conflict for OUTPS
!     40.18, Apr. 01: Reflection option extended
!     40.13, July 01: reading of PTRIAD(4) added in command TRIad
!                     command OUTPut OPTions added; module OUTP_DATA added
!                     command OUTPUT QUANTITY is made obsolete
!     40.13, Aug. 01: [xpc] and [ypc] are required in case of spherical coordinates
!                     [ylenc] and [myc] not required in 1-D mode
!     40.13, Oct. 01: USE OUTP_DATA added in view of longer filenames
C
C  2. Purpose
C
C     Reading and processing of the user commands describing the model
C
C  3. Method (updated 30.72)
C
C     A new line is read, in which the first keyword determines what the
C     command is. The command is read and processed. Common variable are
C     given proper values, and the POOL array is filled. After processing
C     the command the program returns to label 100, to process a new command.
C     This is repeated until the command STOP is found or the end of file is
C     reached.
C
C     Depending on the commands, the argument variable COMPUT is given a value,
C     depending on which the program will make a computation is some form or not.
C
C  4. Argument variables (updated 30.72)
C
C     COMPUT   Output variable that determine the sort of computation to be
C              performed by SWAN
C              ='COMP'; computation requested
C              ='NOCO'; no computation but output requested
C              ='RETR'; retrieve data previous computation
C              ='STOP'; make computation, output and stop
C     POOL(*)  Output variable that is filled with computational data needed
C              for the simulation by SWAN
C
C  5. Parameter variables
C
      INTEGER, PARAMETER :: MXINCL = 10                                   40.03
C
C  6. Local variables
C
C     INCLEV    include level, increases at INCL command,                 40.03
C               decreases at end-of-file                                  40.03
C     INCNUM    unit reference numbers of included files                  40.03
C     LREF      indicates whether reflection is active (#0.) or not (=0.) 40.09
!
      INTEGER, SAVE  :: INCNUM(1:MXINCL) = 0                              40.03
      INTEGER, SAVE  :: INCLEV = 1                                        40.03
 
      INTEGER        :: IERR = 0                                          40.02
 
      REAL           :: LREF                                              40.09
      REAL           :: POWN, DUM, LREFDIFF                               40.18
 
C
C  7. Common Blocks used (updated 30.72)
C
C     COMMON / CBOUP  / *** ???
C     COMMON / COMPDA / *** pointers for data arrays on computational grid
C     COMMON / LEESDA / *** char. data used by the command reading system
C     COMMON / LEESDN / *** num. data used by the command reading system
C     COMMON / NAMES /  *** names and other character strings
C     COMMON / OUTPDA / *** data for output, mainly plotting
C     COMMON / REFNRS / *** file unit reference numbers
C     COMMON / SWANWL / *** variables for project h3268                   32.01
C     COMMON / SWCOMG / *** location and dimensions of computational grid
C     COMMON / SWFYSP / *** physical parameters
C     COMMON / SWGRID / *** location and dimensions of input grids
C     COMMON / SWNAME / *** names and other character data
C     COMMON / SWNUMS / *** information related to the numerical scheme
C     COMMON / SWUITV / *** information for output
C     COMMON / SWTEST / *** information for test output
C     COMMON / TESTDA / *** test parameters
C     COMMON / TIMCOM / *** ???
C     COMMON / TIMRED / *** ???
C     COMMON / WAMBOU / *** ???
C     COMMON / WFILNM / *** ???
C
C  8. Subroutines used
C
C     SPCVAR: Reading the variable spectral boundary conditions from file 32.01
C     DEGCNV: Transforms dir. from nautical to cartesian or vice versa    32.01
C     INITVA: Processing comm. INIT and comp. initial state of wave field 30.70
C     SINPGR: Read parameters of an input grid
C     SWINIT
C     REINC
C     SWRBC
C     SREDEP
C     SPRCON
C     SPROUT
C     RETSTP  read test points                                            40.00
C     SWNDPR (SWAN/SWREAD)
C     OCPINI
C     NWLINE
C     INKEYW
C     INCSTR
C     ININTG
C     INREAL
C     FOR
C     KEYWIS
      LOGICAL :: KEYWIS                                                   40.03
C     COPYCH
C     WRPOOL
      INTEGER :: IADRS                                                    40.00
      LOGICAL :: EQREAL                                                   40.00
C     (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWMAIN
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     The description of the structure of this subroutine is very
C     short as most of the source code can easily be understood with
C     the aid of the command descriptions in the user manual and the
C     purpose of the subroutines from the system documentation.
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Call NWLINE for reading new line of user input
C     Call INKEYW to read a new command from user input
C     If the command is equal to one of the SWAN commands, then
C         Read and process the rest of the command
C     ----------------------------------------------------------------
C
C 13. Source text
C
      LOGICAL :: FOUND                                                    40.03
      LOGICAL, SAVE :: RUNMADE = .FALSE.                                  40.03
C
C     *** The logical variable LOGCOM has a record about which    ***
C     *** commands have been given to know if all the information ***
C     *** for certain command is available, e.g. for BOUND        ***
C     *** LOGCOM : MODE(1)      ,CGRID(2)  ,READ BOTTOM(3),       ***
C     ***          READ COO(4)  ,BOUND(5)  ,AC2 ALLOCATED         ***     NRL
C
      LOGICAL, SAVE :: LOGCOM(1:6) = .FALSE.                              40.03
      INTEGER   POOL(*), TIMARR(6)                                        30.00
      INTEGER   MAUX                                                      30.81
      REAL      RPOOL(*)                                                  30.90
      CHARACTER PSNAME *8, PNAME *8, COMPUT *(*), PTYPE *1, DTTIWR *18    40.00
      CHARACTER BEGBOC *18                                                30.00
      INTEGER, SAVE :: IENT = 0
      INTEGER, SAVE :: LWINDR = 0
      INTEGER, SAVE :: LWINDM = 3
#ifdef API
      CHARACTER*256  tstr, sysdepinfo
#endif
 
      CALL STRACE (IENT, 'SWREAD')
C
C     ***** read command *****
C
 100  CALL NWLINE
      IF (ELTYPE.EQ.'EOF') THEN
*       end-of-file encountered in (included) input file                  40.03
*       return to previous input file
        CLOSE (INCNUM(INCLEV))                                            40.03
        INCLEV = INCLEV - 1
        IF (INCLEV.EQ.0) THEN
          CALL MSGERR (4, ' unexpected end of command input')             40.03
          RETURN
        ENDIF
        ELTYPE = 'USED'
        INPUTF = INCNUM(INCLEV)                                           40.03
      ENDIF
C
      IF ( ITEST .GE. 200) THEN                                           30.70
        WRITE (PRTEST,*) ' BNAUT NA LABEL 100 IN SWREAD =', BNAUT         32.01
      ENDIF                                                               32.01
C
      CALL INKEYW ('REQ',' ')
C
C     ------------------------------------------------------------------
C                 PROCESSING OF COMMANDS
C     ------------------------------------------------------------------
C
C     STOP                                                                30.21
C
C ============================================================
C
C STOP
C
C ============================================================
C
      IF (KEYWIS ('STOP')) THEN
        IF (RUNMADE) THEN
          COMPUT = 'STOP'
        ELSE
          WRITE (PRINTF,*)' ** No computation requested **'
          COMPUT = 'NOCO'
        ENDIF
        RETURN
      ENDIF
C
C     ------------------------------------------------------------------
C
C     PROJECT      reading of project title and description
C
C ===============================================================
C
C PROJect  'NAME'  'NR'
C
C          'title1'
C
C          'title2'
C
C          'title3'
C
C ===============================================================
C
      IF (KEYWIS ('PROJ')) THEN
        CALL INCSTR ('NAME', PROJID, 'UNC', BLANK)
        CALL INCSTR ('NR', PROJNR, 'REQ', BLANK)
        CALL NWLINE
        IF (STPNOW()) RETURN                                              34.01
        CALL INCSTR ('TITLE1',PROJT1,'UNC',' ')
        CALL NWLINE
        IF (STPNOW()) RETURN                                              34.01
        CALL INCSTR ('TITLE2',PROJT2,'UNC',' ')
        CALL NWLINE
        IF (STPNOW()) RETURN                                              34.01
        CALL INCSTR ('TITLE3',PROJT3,'UNC',' ')
        GOTO 100
      ENDIF
*
*     INCLUDE     include another file in command file
*     ------------------------------------------------------------------
*     INCLude  'FILE'
*     ------------------------------------------------------------------
*
      IF (KEYWIS ('INCL')) THEN
        IF (INCLEV.EQ.1) INCNUM(INCLEV) = INPUTF                          40.03
        CALL INCSTR ('FILE' , FILENM , 'REQ', ' ')
        INCLEV = INCLEV + 1
        IF (INCLEV.GT.MXINCL) THEN
          CALL MSGERR (4, 'too many INCLUDE levels')                      40.03
          RETURN
        ENDIF
        IERR   = 0
        CALL FOR (INCNUM(INCLEV), FILENM, 'OF', IERR)                     40.03
        INPUTF = INCNUM(INCLEV)
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C     POOL        request dynamic data pool information
C
C ===========================================================
C
C    POOL
C
C ===========================================================
C
      IF (KEYWIS ('POOL')) THEN
        CALL DPINQA (POOL, LENARR, LENOCP, NUMPNS, LENPNM, LENADT,
     &               IERR)
        WRITE (PRINTF, 87) LENARR, LENOCP
  87    FORMAT (
     &' Data pool size defined at installation:'                          40.00
     &, T68, I12, /,
     &' Occupied memory after last command before this instance of POOL'  40.00
     &, T68, I12)
*
*       estimate additional data size needed
*
        MADATA = MXOUTAR
        IF (LENREC.EQ.0) MADATA = MADATA + MCGRD * MSC * MDC
C       for the S&L scheme, AC1 is used irrespective of num. of iterations
        IF (NSTATM.GT.0.AND.MXITNS.GT.1                                   40.03
     &                   .OR. PROPSC.EQ.3                                 33.08
     &                                       ) THEN
          IF (LENREC.EQ.0) MADATA = MADATA + MCGRD * MSC * MDC
        ENDIF
!       code deleted after removal of WAREA from dynamic data pool        40.22
*
        WRITE (PRINTF, 88) MADATA, LENOCP+MADATA
  88    FORMAT (
     &' Estimated additional memory needed after this instance of POOL'   40.00
     &, T68, I12, /,
     &' TOTAL estimated memory for this run:'                             40.00
     &, T68, I12,/)
        IF (ITEST.GE.60) WRITE (PRTEST, 89) MXOUTAR, MCGRD*MSC*MDC
  89    FORMAT (' outp , action array , work area ', 3I12)
*
        IF (ITEST.GE.10) THEN
          IERR = -2
          CALL DPCHEK (POOL, IERR)
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C     TEST       parameters for required test output
C
C     =============================================================
C
C     TEST  [itest]  [itrace]  POInts < [ix1] [iy1] >
C
C     ============================================================
C
      IF (KEYWIS ('TEST')) THEN
        CALL ININTG ('ITEST' , ITEST , 'STA', 30)
!       statements restructured:
        IF (ITEST.GE.30) THEN
          IF (ERRPTS.EQ.0) THEN                                           40.13
            ERRPTS = 16
            OPEN (ERRPTS, FILE='ERRPTS',
     &            STATUS='UNKNOWN', FORM='FORMATTED')
          ENDIF                                                           40.13
        ENDIF
        CALL ININTG ('ITRACE', ITRACE, 'UNC',  0)
        IF (ITRACE.GT.0) THEN
          LTRACE =.TRUE.
        ELSE
          LTRACE =.FALSE.
        ENDIF
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('POI')) THEN
          NPTST  = 0
          MPTST  = 50
          IERR   = 0                                                      40.00
          PNAME  = 'XYTST'
          CALL DPINQP (POOL, PNAME, JXYTST, PTYPE, IXYTST,
     &                 LENREC, IERR)
          CALL DPEXPR (POOL, JXYTST, 2*MPTST, IXYTST, IERR)               40.00
          IF (STPNOW()) RETURN                                            34.01
*         Add output point set 'TESTPNTS'
          PSNAME = 'TESTPNTS'
          IERR = 0                                                        40.00
          PNAME  = 'OUTDA'
          CALL DPINQP (POOL, PNAME, JOUTD, PTYPE, IOUTD,
     &                 LENREC, IERR)                                      40.00
          PNAME  = 'PSET'
          CALL DPINQP (POOL(IOUTD), PNAME, JPSET, PTYPE, IOUTPS,
     &                 LENREC, IERR)                                      40.00
          CALL DPEXPR (POOL(IOUTD), JPSET, LENREC+16+2*MPTST, IOUTPS,     40.00
     &                 IERR)                                              40.00
          IF (STPNOW()) RETURN                                            34.01
          IREC = 0
          CALL DPADDP (POOL(IOUTD+IOUTPS-1), PSNAME, IREC, 'S',
     &                 JADR, IERR)                                        40.00
          IF (STPNOW()) RETURN                                            34.01
          IERR = -1                                                       40.00
          CALL DPEXPR (POOL(IOUTD+IOUTPS-1), IREC, 2+2*MPTST, INX,        40.00
     &                 IERR)                                              40.00
          IF (STPNOW()) RETURN                                            34.01
C
          CALL RETSTP (MPTST, POOL(IADRS(POOL,JXYTST)),                   40.00
     &            POOL(IADRS(POOL,JADDRS)), POOL(IADRS(POOL,JGRBND)),     40.02
     &           RPOOL(IADRS(POOL,JCOOX)) ,RPOOL(IADRS(POOL,JCOOY)),      40.02
     &           RPOOL(IADRS(POOL,JSIGMA)),RPOOL(IADRS(POOL,JSPDIR)),     40.02
     &            POOL(IOUTD+IOUTPS-1+INX),RPOOL(IOUTD+IOUTPS-1+INX))     40.02
          IF (STPNOW()) RETURN                                            34.01
          CALL DPEXPR (POOL(IOUTD+IOUTPS-1), IREC, 2+2*NPTST, INX,        40.00
     &                 IERR)                                              40.00
          IF (STPNOW()) RETURN                                            34.01
          CALL DPEXPR (POOL, JXYTST, 2*NPTST, IXYTST, IERR)               40.00
          IF (STPNOW()) RETURN                                            34.01
          NPTSTA = MAX(1,NPTST)                                           40.00
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     INTEst       parameters for required test output during input
C
C     ============================================================
C
C     INTE [intes]         (NOT documented)
C
C     ============================================================
C
      IF (KEYWIS ('INTE')) THEN
        CALL ININTG ('INTES' , INTES , 'STA', 30)
        GO TO 100
      ENDIF
C     ------------------------------------------------------------------
C     COTEst       parameters for required test output during computation
C
C     ============================================================
C
C     COTE [cotes]         (NOT documented)
C
C     ============================================================
      IF (KEYWIS ('COTE')) THEN
        CALL ININTG ('COTES' , ICOTES , 'STA', 30)
        GO TO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     OUTEst       parameters for required test output during output
C
C     ============================================================
C
C     OUTE [itest]         (NOT documented)
C
C     ============================================================
C
      IF (KEYWIS ('OUTE')) THEN
        CALL ININTG ('ITEST' , IOUTES , 'STA', 30)
        GO TO 100
      ENDIF
 
C     ============================================================
 
!      OUTPut OPTIons  'comment'  (TABle [field])  (BLOck  [ndec]  [len])   &
 
!      (SPEC  [ndec])
 
C     ============================================================
 
      IF (KEYWIS('OUTP')) THEN
        CALL IGNORE ('OPT')
        CALL INCSTR ('COMMENT', OUT_COMMENT, 'UNC', ' ')
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('TAB')) THEN
          CALL ININTG ('FIELD', FLD_TABLE, 'STA', 11)
          IF (FLD_TABLE.GT.16) CALL MSGERR (2, '[field] is too large')
          IF (FLD_TABLE.LT.8)  CALL MSGERR (2, '[field] is too small')
          WRITE (FLT_TABLE, 232) FLD_TABLE, FLD_TABLE-7
 232      FORMAT ('(100(1X,E', I2, '.', I1, '))')
          IF (ITEST.GE.30) WRITE (PRINTF, 234) FLT_TABLE
 234      FORMAT (' Format floating point table: ', A)
        ENDIF
        IF (KEYWIS('BLO')) THEN
          CALL ININTG ('NDEC', DEC_BLOCK, 'STA', 4)
          IF (DEC_BLOCK.GT.9) CALL MSGERR (2, '[ndec] is too large')
          CALL ININTG ('LEN', NLEN, 'STA', 200)
          IF (NLEN.GT.9999) CALL MSGERR (2, '[len] is too large')
          WRITE (FLT_BLOCK, 242) NLEN, DEC_BLOCK+7, DEC_BLOCK
 242      FORMAT ('(', I4, '(1X,E', I2, '.', I1, '))')
          IF (ITEST.GE.30) WRITE (PRINTF, 244) FLT_BLOCK
 244      FORMAT (' Format floating point block: ', A)
        ENDIF
        IF (KEYWIS('SPEC')) THEN
          CALL ININTG ('NDEC', DEC_SPEC, 'STA', 5)
          IF (DEC_SPEC.GT.9) CALL MSGERR (2, '[ndec] is too large')
          CALL ININTG ('LEN', NLEN, 'STA', 200)
          IF (NLEN.GT.9999) CALL MSGERR (2, '[len] is too large')
          WRITE (FIX_SPEC, 252) NLEN, DEC_SPEC
 252      FORMAT ('(', I4, '(1X,I', I1, '))')
          IF (ITEST.GE.30) WRITE (PRINTF, 254) FIX_SPEC
 254      FORMAT (' Format spectral output: ', A)
        ENDIF
        IF (KEYWIS('QUA')) THEN
          CALL MSGERR (3,
     &    'command OUTP QUANT is obsolete, use QUANTITY')
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     BOTTOM    definition of bottom grid
C
C ============================================================
C
C BOTtom ...         (OBSOLETE command)
C
C ============================================================
C
      IF (KEYWIS ('BOT')) THEN
        CALL MSGERR (2, 'command BOTTOM is replaced by INPUT GRID BOT')
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     MODE  : Set STATionary, DYNamic (NONSTAtionary) or 1D SWAN model    32.02
C
C ========================================
C
C        | -> STAtionary    |     | -> TWODimensional |                   40.00
C MODE  <                    >   <                     >  (NOUPDATe)      40.07
C        |    NONSTationary |     |    ONEDimensional |                   40.00
C
C ========================================
C
      IF (KEYWIS ('MODE')) THEN                                           30.21
        LOGCOM(1) = .TRUE.                                                30.21
        CALL INKEYW ('STA',' ')
        IF (KEYWIS('NONST') .OR. KEYWIS ('DYN')) THEN                     30.70
          IF (NSTATM.EQ.0) CALL MSGERR (2, 'Mode Nonst incorrect here')   40.00
          NSTATM = 1                                                      40.00
          NSTATC = 1                                                      40.00
C
C         switch on flag for computation of default initial condition     30.75
          ICOND = 1                                                       30.75
        ELSEIF (KEYWIS ('STA')) THEN                                      40.00
          IF (NSTATM.EQ.1) CALL MSGERR (2, 'Mode STAT incorrect here')    40.00
          NSTATM = 0                                                      40.00
          CALL INKEYW ('STA',' ')                                         32.02
        ENDIF                                                             32.02
C
C       *** Logical ONED added for 1d-computations                        32.02
C
        CALL INKEYW ('STA', ' ')                                          40.00
        IF (KEYWIS ('ONED')) THEN                                         40.00
          ONED = .TRUE.                                                   32.02
        ELSEIF (KEYWIS ('TWOD')) THEN
          ONED = .FALSE.                                                  32.02
        ENDIF
C
C       *** Logical ACUPDA added to avoid updating action densities       40.07
C
        CALL INKEYW ('STA', ' ')                                          40.07
        IF (KEYWIS ('NOUPDAT')) THEN                                      40.07
          ACUPDA = .FALSE.                                                40.07
        ENDIF
C
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C =======================================================================
C
C            |    BSBT                      |
C   PROP    <                     | SEC |   |
C            |    GSE  [waveage] <  MIN  >  |
C            |                    |  HR |   |
C            |                    | DAY |   |
C
C =======================================================================
C
      IF (KEYWIS ('PROP')) THEN                                           40.02
        CALL INKEYW ('STA','    ')                                        40.02
        IF (KEYWIS ('BSBT')) THEN                                         40.02
          PROPSN = 1                                                      40.02
          PROPSS = 1                                                      40.02
        ELSE IF (KEYWIS ('GSE')) THEN                                     40.02
          IF (PROPSN.NE.3) THEN                                           40.02
            CALL MSGERR(2,                                                40.02
     &      'Anti-GSE only allowed for Stelling Scheme.')                 40.02
          ENDIF                                                           40.02
          CALL ININTV('WAVEAGE', WAVAGE, 'STA', 0.)                       40.02
        ENDIF                                                             40.02
        GOTO 100                                                          40.02
      ENDIF                                                               40.02
C
C     ------------------------------------------------------------------
C
C     COORD : spherical or cartesian coordinates
C
C =================================================
C
C              | -> CARTesian                   |
C COORDinates <                      | -> UM |   >  REPeating             33.09
C              | SPHErical [rearth] <         > |
C                                    |  QC   |
C
C =================================================
C
      IF (KEYWIS ('COORD')) THEN                                          33.09
        CALL INKEYW ('STA',' ')                                           33.09
        IF (KEYWIS ('CART')) THEN                                         33.09
          KSPHER = 0                                                      33.09
        ELSE IF (KEYWIS ('SPHE')) THEN                                    33.09
          KSPHER = 1                                                      33.09
          CALL INREAL ('REARTH', REARTH, 'UNC', 0.)                       33.09
          LENDEG = REARTH * PI / 180.                                     33.09
C         change properties of output quantities Xp and Yp
          OVUNIT(1) = 'degr'
          OVLLIM(1) = -200.
          OVULIM(1) =  400.
          OVLEXP(1) = -180.
          OVHEXP(1) =  360.
          OVEXCV(1) = -999.
          OVUNIT(2) = 'degr'
          OVLLIM(2) = -100.
          OVULIM(2) =  100.
          OVLEXP(2) = -90.
          OVHEXP(2) =  90.
          OVEXCV(2) = -999.
          CALL INKEYW ('STA','CCM')                                       33.09
          IF (KEYWIS ('QC')) THEN                                         33.09
C           quasi-cartesian projection method
            PROJ_METHOD = 0                                               33.09
          ELSE IF (KEYWIS ('CCM')) THEN                                   33.09
C           uniform Mercator projection (default for spherical coordinates)
            PROJ_METHOD = 1                                               33.09
          ENDIF                                                           33.09
        ELSE                                                              33.09
          CALL WRNKEY
        ENDIF                                                             33.09
        CALL INKEYW ('STA',' ')                                           33.09
        IF (KEYWIS ('REP')) THEN                                          33.09
          KREPTX = 1                                                      33.09
        ENDIF                                                             33.09
        GO TO 100                                                         33.09
      ENDIF                                                               33.09
C
C     ------------------------------------------------------------------
C
C     **  Command COMPUTE   **                                            30.00
C
C       ==============================================================
C
C                  |  STATionary  [time]                      |
C       COMPute ( <                                            > )        40.00
C                  |                    | -> Sec  |           |
C                  |  ([tbegc] [deltc] <     MIn   > [tendc]) |
C                                       |    HR   |
C                                       |    DAy  |
C
C       ==============================================================
C
      IF (KEYWIS ('COMP')) THEN
        COMPUT = 'COMP'                                                   30.00
        RUNMADE = .TRUE.                                                  30.00
        CALL INKEYW ('STA','  ')
        IF (NSTATM.LE.0 .OR. KEYWIS('STAT')) THEN                         40.00
          IF (NSTATM.EQ.-1) NSTATM = 0                                    40.00
          IF (NSTATM.GT.0) CALL INCTIM (ITMOPT,'TIME',TINIC,'REQ',0.)     40.00
          IF (TINIC .LT. TIMCO) THEN                                      40.03
            CALL MSGERR (2, '[time] before current time')                 40.03
            TINIC = TIMCO                                                 40.03
          ENDIF                                                           40.03
          TFINC = TINIC                                                   40.00
          TIMCO = TINIC                                                   40.00
          DT = 1.E10                                                      40.00
          RDTIM = 0.                                                      40.00
          NSTATC = 0                                                      40.00
        ELSE
          CALL IGNORE ('NONST')
          IF (TIMCO .LT. -0.9E10) THEN                                    40.00
            CALL INCTIM (ITMOPT,'TBEGC',TINIC,'REQ',0.)                   40.03
          ELSE
            CALL INCTIM (ITMOPT,'TBEGC',TINIC,'STA',TIMCO)                40.03
          ENDIF
          IF (TINIC .LT. TIMCO) THEN                                      40.03
            CALL MSGERR (2, 'start time [tbegc] before current time')     40.03
            TINIC = TIMCO                                                 40.03
          ENDIF                                                           40.03
          CALL ININTV ('DELTC', DT, 'REQ', 0.)                            40.03
          CALL INCTIM (ITMOPT,'TENDC',TFINC,'REQ',0.)                     40.03
          NSTATC = 1                                                      40.00
C
C           *** tfinc must be greater than tinic **
          DIFF = TFINC - TINIC
          IF (DIFF .LE. 0.) CALL MSGERR (3,
     &        'start time [tbegc] greater or equal end time [tendc]')
C
C           **The number of computational steps is calculated
          RDTIM = 1./DT
          MTC = NINT ((TFINC - TINIC)/DT)                                 30.50
          IF (MOD(TINIC-TFINC,DT).GT.0.01*DT .AND.
     &            MOD(TINIC-TFINC,DT).LT.0.99*DT)
     &           CALL MSGERR (1,
     &           'DT is not a fraction of the computational period')
          TIMCO = TINIC
        ENDIF
        IF (NSTATM.GT.0) CHTIME = DTTIWR(ITMOPT, TIMCO)                   40.00
*     ** Next lines to process the begining and interval times to read
*       the boundary spectra from coarse grid if this is a nested grid.
        IF (NSTATM.EQ.1 .AND. NESRUN .EQ. 1) THEN                              30.00
          CALL DTSTTI(ITMOPT, BEGBOC, TIMARR)
          BEGBOU = DTTIME(TIMARR)
          TIMERB = BEGBOU
        ENDIF
*       set ITERMX equal to MXITST in case of stationary computations
*       and to MXITNS otherwise
        IF (NSTATC.EQ.0) THEN
          ITERMX = MXITST                                                 40.03
        ELSE
          ITERMX = MXITNS                                                 40.03
        ENDIF
        RETURN                                                            30.00
      ENDIF
C
C     ------------------------------------------------------------------
C
C     *** OBSTACLE   Definition of obstacles in comp grid. ***            30.61
C
C ============================================================
C
C             |  TRANSm [trcoef]              |
C OBSTacle   <                                 >             &
C             |  DAM    [hgt] [alpha] [beta]  |
!                                                                         40.18
!                        | -> RSPEC        |                              40.18
!      ( REFLec [reflc] <                   > ) LINe < [xp] [yp] >        40.18 40.09
!                        |    RDIFF [pown] |                              40.18
C ============================================================
C
      IF (KEYWIS ('OBST')) THEN
        IERR = 0
        PNAME = 'OBSTACLE'
        IERR = -2
        CALL DPINQP (POOL, PNAME, JOBST, PTYPE, IOBST,
     &               LENREC, IERR)
        IERR = 0
        CALL DPMAXR (POOL, JOBST, LLR, IOBST, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IREC = 0
        IERR = 0
        PNAME = '    '
        CALL DPADDP (POOL(IOBST), PNAME, IREC, 'S', INX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IERR = 0
        CALL DPMAXR (POOL(IOBST), IREC, LLR, INX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        ILOCR = IOBST + INX - 1
*       *** Adding the obstacles  to output data  ***
        PNAME = 'OUTDA'
        CALL DPINQP (POOL, PNAME, INDX, PTYPE, IOUTD, LENREC,
     &               IERR)
        PNAME = 'LIN'
        CALL DPINQP (POOL(IOUTD), PNAME, JSLIN, PTYPE, ISLIN,
     &               LENREC, IERR)
        CALL DPMAXR (POOL(IOUTD), JSLIN, LLR, ISLIN, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IREC = 0
        IERR = 0
        PNAME = '    '
        CALL DPADDP (POOL(IOUTD+ISLIN-1), PNAME, IREC,
     &               'S', INLX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMAXR (POOL(IOUTD+ISLIN-1), IREC, LLR, INLX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        ILOLI = IOUTD+ISLIN+INLX-2
        NUMCOR = 0
*       *** type of line : 10 = continuous; 1. = pattern length(cm)  ***  30.80
*       *** line color:    1  = black                                ***  30.80
        LINTYP = 10
        PATLEN = 1.
        LINCOL = 1
        POOL(ILOLI+1) = NUMCOR
        POOL(ILOLI+2) = LINTYP
        CALL DPPUTR (RPOOL, ILOLI+3, PATLEN)                              40.02
        POOL(ILOLI+4) = LINCOL
C       *** NUMCOR : Number of corners ***
        NUMCOR = 0
        POOL(ILOCR+1) = NUMCOR
C
C       data concerning transmission of energy over/through the obstacle
C
        CALL INKEYW ('STA', '  ')
        IF (KEYWIS ('TRANS')) THEN
          ITRAS = 0
          CALL INREAL ('TRCOEF', TRCOEF, 'REQ', 0.)
          POOL(ILOCR+2) = ITRAS
          CALL DPPUTR(RPOOL,ILOCR+3, TRCOEF)                              40.02
          CALL DPPUTR(RPOOL,ILOCR+4, 0.)                                  40.02
          CALL DPPUTR(RPOOL,ILOCR+5, 0.)                                  40.02
        ELSE IF (KEYWIS ('DAM')) THEN
          ITRAS = 1
          CALL INREAL ('HGT'  , HGT , 'REQ', 0.  )                        30.80
          CALL INREAL ('ALPHA', OGAM, 'STA', 2.6 )                        30.60
          CALL INREAL ('BETA' , OBET, 'STA', 0.15)                        30.60
          POOL(ILOCR+2) = ITRAS
          CALL DPPUTR(RPOOL,ILOCR+3, HGT)                                 40.02
          CALL DPPUTR(RPOOL,ILOCR+4, OGAM)                                40.02
          CALL DPPUTR(RPOOL,ILOCR+5, OBET)                                40.02
        ELSE
C         if no transmission options are activated, there will be 0 transmission
          ITRAS = 0
          CALL DPPUTR(RPOOL,ILOCR+3, 0.)                                  40.02
        ENDIF
        POOL(ILOCR+2) = ITRAS                                             40.09
C                                                                         40.09
C       data on reflection by the obstacle, activated by keyword REFL     40.09
C
        CALL INKEYW ('REQ', '  ')                                         40.09
        IF (KEYWIS ('REFL')) THEN                                         40.09
          LREF = 1.                                                       40.09
          IF (.NOT.FULCIR) THEN                                           40.09
            CALL MSGERR(3,'Reflections will only be calculated if     ')  40.09
            CALL MSGERR(3,'the spectral directions cover the full     ')  40.09
            CALL MSGERR(3,'circle.                                    ')  40.09
          ENDIF                                                           40.09
          CALL INREAL ('REFLC', REF0, 'STA', 1.)                          40.09
          CALL DPPUTR(RPOOL,ILOCR+7, REF0)                                40.02
!                                                                         40.18
          CALL INKEYW ('REQ', '  ')                                       40.18
          CALL INKEYW ('STA', 'RDIFF')                                    40.18
          IF (KEYWIS('RDIFF')) THEN                                       40.18
            LREFDIFF = 1.                                                 40.18
            CALL INREAL ('POWN', POWN, 'STA', 1000.)                      40.18
            DUM = MOD(POWN,1.)                                            40.18
            IF (DUM .NE. 0.) THEN                                         40.18
              CALL MSGERR(3,'Power  is not an integer number! ')          40.18
            ENDIF                                                         40.18
            CALL DPPUTR(RPOOL,ILOCR+8, LREFDIFF)                          40.18
            CALL DPPUTR(RPOOL,ILOCR+9, POWN)                              40.18
          ELSE                                                            40.18
            CALL IGNORE ('RSPEC')                                         40.18
            LREFDIFF = 0.                                                 40.18
            CALL DPPUTR(RPOOL,ILOCR+8, LREFDIFF)                          40.18
            CALL DPPUTR(RPOOL,ILOCR+9, 0.)                                40.18
          ENDIF                                                           40.18
          CALL INKEYW ('REQ', '  ')                                       40.09
C                                                                         40.09
          IF ((REF0.LT.0.) .OR. (REF0.GT.1.)) THEN                        40.09
            CALL MSGERR(3,'Reflection coeff. [reflc] is not allowed ')    40.09
            CALL MSGERR(3,'to be greater than 1 or smaller than 0!  ')    40.09
          ENDIF                                                           40.09
        ELSE
C         if there is no keyword REFL, there will be no reflection        40.09
          LREF = 0.
        ENDIF                                                             40.09
        CALL DPPUTR(RPOOL,ILOCR+6, LREF)                                  40.02
C
C       location of obstacle
C
        IF (KEYWIS ('LIN')) THEN
          DO LOOP = 1, 9999
C           read coordinates of one corner point of the obstacle
            CALL READXY ('XP', 'YP', XP, YP, 'REP', -1.E10, -1.E10)
            IF (XP.LT.-.9E10) GOTO 101
            NUMCOR = NUMCOR + 1
C           store coordinates for a corner point in array of obstacle data
            CALL DPPUTR(RPOOL,ILOCR+11+NUMCOR*2, XP)                      40.02
            CALL DPPUTR(RPOOL,ILOCR+12+NUMCOR*2, YP)                      40.02
C           store coordinates for a corner point in array of line data
            CALL DPPUTR(RPOOL, ILOLI+2*NUMCOR+3, XP)                      40.02
            CALL DPPUTR(RPOOL, ILOLI+2*NUMCOR+4, YP)                      40.02
          ENDDO
        ENDIF
 101    IF (NUMCOR .LE. 1) THEN
          CALL MSGERR(1,'No corner points for obstacle were found')
        ELSE
*         *** NUMOBS : Number of obstacles ***
          NUMOBS = NUMOBS + 1
C         store number of corner points in array of obstacle data
          POOL(ILOCR+1) = NUMCOR
          IERR = 0
          CALL DPEXPR (POOL(IOBST), IREC,2*NUMCOR+12,INX,IERR)
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0
          CALL DPMINR (POOL,JOBST,LLR,IOBST,IERR)
          IF (STPNOW()) RETURN                                            34.01
C         store number of corner points in array of line data
          POOL(ILOLI+1) = NUMCOR
          IERR = 0
          CALL DPEXPR (POOL(IOUTD+ISLIN-1),IREC,2*NUMCOR+4,INLX,IERR)
          IF (STPNOW()) RETURN                                            34.01
          IERR = 0
          CALL DPMINR (POOL(IOUTD), JSLIN, LIR, ISLIN, IERR)
          IF (STPNOW()) RETURN                                            34.01
        ENDIF
        IERR = 0
        CALL DPCHEK (POOL, IERR)
C
        GO TO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     ***'INITial conditions'  Definition of initial conditions  ***
C     *** for MODE DYNAMIC
C
      IF (KEYWIS ('INIT')) THEN                                           30.61
        IERR = 0
        CALL DPEXPR(POOL, JAUX(1), MDC, IAUX1, IERR)
        IF (STPNOW()) RETURN                                              34.01
C
C       RPOOL(IADRS(POOL,JSIGMA)) ----> SPCSIG
C       RPOOL(IADRS(POOL,JAUX(1))) ---> EDIRS
C       RPOOL(IADRS(POOL,JSPDIR)) ----> SPCDIR
C        POOL(IADRS(POOL,JADDRS)) ----> KGRPNT
C       RPOOL(IADRS(POOL,JCOOX)) -----> XCGRID
C       RPOOL(IADRS(POOL,JCOOY)) -----> YCGRID
C        POOL(IADRS(POOL,JXYTST)) ----> XYTST
C
        CALL INITVA(                  AC2  , RPOOL(IADRS(POOL,JSIGMA)),   30.90 NRL
     &           RPOOL(IADRS(POOL,JAUX(1))), RPOOL(IADRS(POOL,JSPDIR)),   30.90
     &           POOL(IADRS(POOL,JADDRS)),                                30.90
     &           RPOOL(IADRS(POOL,JCOOX)), RPOOL(IADRS(POOL,JCOOY)),      30.90
     &           LOGCOM, POOL(IADRS(POOL,JXYTST)))                        30.90
        IF (STPNOW()) RETURN                                              34.01
        GO TO 100
      ENDIF
C
C     ------------------------------------------------------------------
C     HOTFile    write current wave field to file for future use as
C     initial cond.
      IF (KEYWIS('REST') .OR. KEYWIS ('BACK') .OR. KEYWIS('HOTF')         40.00
     &    .OR. KEYWIS('SAVE')) THEN                                       40.00
        IF (MXC.LE.0) THEN
          CALL MSGERR (2, 'command CGRID must precede this command')
        ELSE
C
C       RPOOL(IADRS(POOL,JSIGMA)) ----> SPCSIG
C       RPOOL(IADRS(POOL,JSPDIR)) ----> SPCDIR
C        POOL(IADRS(POOL,JADDRS)) ----> KGRPNT
C       RPOOL(IADRS(POOL,JCOOX)) -----> XCGRID
C       RPOOL(IADRS(POOL,JCOOY)) -----> YCGRID
C
          CALL BACKUP(                  AC2  ,RPOOL(IADRS(POOL,JSIGMA)),  30.90 NRL
     &           RPOOL(IADRS(POOL,JSPDIR)), POOL(IADRS(POOL,JADDRS)),     30.90
     &           RPOOL(IADRS(POOL,JCOOX)), RPOOL(IADRS(POOL,JCOOY)))      30.90
          IF (STPNOW()) RETURN                                            34.01
        ENDIF
        GO TO 100
      ENDIF
C     ------------------------------------------------------------------
C
C     INPUT    definition of input grids
C
C ========================================================================
C
C            | BOTtom   |
C            |          |
C            | WLEVel   |
C            |          |
C            | CURrent  |
C            |          |
C            | VX       |
C            |          |
C            | VY       |
C INPgrid  (<            >) &
C            | FRiction |
C            |          |
C            | WInd     |
C            |          |
C            | WX       |
C            |          |
C            | WY       |
C
C
C    | REGular [xpinp] [ypinp] [alpinp] [mxinp] [myinp] [dxinp] [dyinp] |
C   <                                                                    > &
C    | CURVilinear [stagrx] [stagry] [mxinp] [myinp]                    |
C
C
C    (EXCeption  [excval])   &
C
C
C                                        | -> SEC  |
C    (NONSTATionary [tbeginp] [deltinp] <     MIN   >  [tendinp])
C                                        |    HR   |
C                                        |    DAY  |
C
C =========================================================================
C
      IF (KEYWIS ('INP')) THEN
        CALL IGNORE ('GRID')
        IERR = 0
        PNAME  = 'OUTDA'
        CALL DPINQP (POOL, PNAME, JOUTD, PTYPE, IOUTD,
     &               LENREC, IERR)
        PNAME = 'PSET'
        CALL DPINQP (POOL(IOUTD), PNAME, JPSET, PTYPE, IOUTPS,
     &               LENREC, IERR)
        CALL DPEXPR (POOL(IOUTD), JPSET, LENREC+20, IOUTPS, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL INKEYW ('STA', ' ')
        IGR2 = 0                                                          10.26
        IF (KEYWIS ('BOT')) THEN
          IGRD = 1
          PSNAME = 'BOTTGRID'
        ELSE IF (KEYWIS ('CUR')) THEN
          IGRD = 2
          IGR2 = 3                                                        10.26
!MCEL+ J Dykes 19 Feb 2003 SWREAD: PSNAME changed for several fields
          !PSNAME = 'VXGRID  '
          PSNAME = 'uavg'
        ELSE IF (KEYWIS ('VX')) THEN
          IGRD = 2
          !PSNAME = 'VXGRID  '
          PSNAME = 'uavg'
        ELSE IF (KEYWIS ('VY')) THEN
          IGRD = 3
          !PSNAME = 'VYGRID  '
          PSNAME = 'vavg'
        ELSE IF (KEYWIS ('FR')) THEN
          IGRD = 4
          !PSNAME = 'FRICGRID'
          PSNAME = 'botdrag'
        ELSE IF (KEYWIS ('WI')) THEN
          IGRD = 5
          IGR2 = 6                                                        10.26
          !PSNAME = 'WXGRID  '
          PSNAME = 'uwind'
        ELSE IF (KEYWIS ('WX')) THEN
          IGRD = 5
          !PSNAME = 'WXGRID  '
          PSNAME = 'uwind'
        ELSE IF (KEYWIS ('WY')) THEN
          IGRD = 6
          !PSNAME = 'WYGRID  '
          PSNAME = 'vwind'
        ELSE IF (KEYWIS ('WLEV')) THEN                                    20.38
          IGRD = 7
          !PSNAME = 'WLEVGRID'
          PSNAME = 'wlev'
*       note: 8 and 9 are for coordinates                                 40.03
        ELSE IF (KEYWIS ('ASTD')) THEN                                    40.03
*         air-sea temperature difference                                  40.03
          IGRD = 10
          PSNAME = 'ASTDGRID'
        ELSE
          IGRD = 1
          PSNAME = 'BOTTGRID'
        ENDIF
C
C        POOL(IOUTD+IOUTPS-1) ------> OUTPS
C       RPOOL(IADRS(POOL,JCOOX)) ---> XCGRID
C       RPOOL(IADRS(POOL,JCOOY)) ---> YCGRID
C
!       arguments removed (not used in subroutine)                        40.13
        CALL SINPGR (IGRD, IGR2, PSNAME, POOL(IOUTD+IOUTPS-1),
     &               RPOOL(IOUTD+IOUTPS-1))                               40.12 40.13
        IF (STPNOW()) RETURN                                              34.01
      GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C     READ   reading depths, coordinates and/or currents
C
      IF (KEYWIS ('READ')) THEN
        CALL SREDEP (POOL, LWINDR, LWINDM, LOGCOM, RPOOL)                 40.02
        IF (STPNOW()) RETURN                                              34.01
*       *** If the bottom was read and we do not need coord for  ***
*       *** comput points and the pool was NOT expanded for AC2  ***
*       *** array call CGINIT to compute grid addresses          ***      40.00
        IF (OPTG .EQ. 1) THEN
*         regular grid
          IF (LOGCOM(3) .AND. .NOT. LOGCOM(6)) THEN                       30.90
            CALL CGINIT(POOL, RPOOL, LOGCOM)                              30.90
            IF (STPNOW()) RETURN                                          34.01
          ENDIF                                                           30.90
        ELSE
*         cuvilinear grid
          IF (LOGCOM(3) .AND. .NOT. LOGCOM(4)) THEN
            CALL MSGERR (3, '** Give CGRID command                   *')  40.00
            CALL MSGERR (3, '** and computational point coordinates  *')
            CALL MSGERR (3, '**       before the bottom grid         *')
          ELSE IF (LOGCOM(4) .AND. .NOT. LOGCOM(2)) THEN
            CALL MSGERR (3, '* define computational grid before      *')  40.00
            CALL MSGERR (3, '* reading computational point coord.    *')
          ELSE IF (LOGCOM(2) .AND. LOGCOM(3) .AND.
     &             LOGCOM(4) .AND. .NOT. LOGCOM(6)) THEN
            CALL CGINIT(POOL, RPOOL, LOGCOM)                              30.90
            IF (STPNOW()) RETURN                                          34.01
          ENDIF
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     CGRID     definition of computational grid
C
C ===========================================================================
C           |  -> REGular [xpc] [ypc] [alpc] [xlenc] [ylenc] [mxc] [myc]     |
C CGRID     |                                                                 >  &
C           |     CURVilinear                                [mxc] [myc]     |
C
C
C           | -> CIRcle               |
C          <                           > [mdc]              &
C           |    SECtor [dir1] [dir2] |
C
C
C           |     [flow]  [fhigh]  [msc]
C
C ===========================================================================
C
      IF (KEYWIS('CGRID') .OR. KEYWIS('GRID')) THEN                       30.20
*       ver 20.67: command reorganised in view of cycle 2 (parametric &
*                  curvilinear)
*       ver 30.20: order of data changed
*       [xpc], [ypc], [alpc] moved                                        30.20
*
*
*       ver 30.21: CURVILINEAR                                            30.21
*
*
        LOGCOM(2) = .TRUE.                                                30.21
        CALL INKEYW ('STA', 'REG')                                        30.60
        IF (KEYWIS('CURV')) THEN                                          30.21
          OPTG   = 3                                                      30.21
          XPC    = 0.
          YPC    = 0.
          ALPC   = 0.                                                     30.21
          XCLEN  = 0.
          YCLEN  = 0.
        ELSE
          CALL IGNORE ('REG')                                             20.67
          OPTG = 1
          IF (KSPHER.EQ.0) THEN                                           40.13
            CALL READXY ('XPC', 'YPC', XPC, YPC, 'UNC', 0., 0.)
            CALL INREAL ('ALPC',ALPC,'UNC',0.)
          ELSE                                                            40.13
!           spherical coordinates; [xpc] and [ypc] are required           40.13
            CALL READXY ('XPC', 'YPC', XPC, YPC, 'REQ', 0., 0.)           40.13
            CALL INREAL ('ALPC',ALPC,'STA',0.)                            40.13
          ENDIF                                                           40.13
          MYS = MYC-1
          CALL INREAL('XLENC',XCLEN,'RQI',0.)                             30.20
          IF (ONED) THEN                                                  32.02
            CALL INREAL('YLENC',YCLEN,'STA',0.)                           40.13
            IF (YCLEN .NE. 0) THEN                                        32.02
              CALL MSGERR (1, '1D-simulation: [ylenc] set to zero !')     32.02
            ENDIF                                                         32.02
            YCLEN = 0.                                                    40.00
          ELSE
            CALL INREAL('YLENC',YCLEN,'RQI',0.)                           30.20
          ENDIF
C
C
C         ALPC is made to be between -PI and PI
C
          ALTMP = ALPC / 360.
          ALPC = PI2 * (ALTMP - NINT(ALTMP))
          CVLEFT = .TRUE.                                                 40.00
        ENDIF                                                             30.21
        CALL ININTG('MXC',MXS,'RQI',0)
C
        IF (ONED) THEN                                                    32.02
          CALL ININTG('MYC',MYS,'STA',0)                                  40.13
          IF (MYS .NE. 0) THEN                                            32.02
            CALL MSGERR (1, '1D-simulation: [myc] set to zero !')         32.02
          ENDIF                                                           32.02
          MYS = 0                                                         32.02
        ELSE                                                              40.13
          CALL ININTG('MYC',MYS,'RQI',-1)
        ENDIF                                                             32.02
C
        IF (KREPTX.EQ.1) THEN                                             33.09
          MXC = MXS                                                       33.09
        ELSE
          MXC = MXS+1
        ENDIF
        MYC = MYS+1
        MMCGR = MXC*MYC
        DX  = XCLEN/MXS
         write(*,*)'swanpre1 1359 : MXC, MYC',MXC, MYC
C                                                                         32.02
        IF (ONED) THEN                                                    32.02
          DY  = DX                                                        32.02
        ELSE                                                              32.02
          DY  = YCLEN/MYS
        ENDIF                                                             32.02
C
C       for curvilinear grid, read exception values for grid point coordinates
C
        IF (OPTG.EQ.3) THEN                                               30.60
          CALL INKEYW ('STA', ' ')                                        30.60
          IF (KEYWIS ('EXC')) THEN                                        30.60
            CALL INREAL ('EXCVAL', EXCFLD(8), 'REQ', 0.)                  30.60
            CALL INREAL ('EXCVAL', EXCFLD(9), 'STA', EXCFLD(8))           30.60
          ENDIF                                                           30.60
        ENDIF                                                             30.60
*
        CALL INKEYW ('STA', 'CIR')                                        20.67
        IF (KEYWIS('SEC')) THEN
          FULCIR = .FALSE.
          CALL INREAL ('DIR1', SPDIR1, 'REQ', 0.)                         20.43
          CALL INREAL ('DIR2', SPDIR2, 'REQ', 0.)                         20.56
          CALL ININTG('MDC',MDC,'RQI',0)
        ELSE                                                              20.43
          CALL IGNORE ('CIR')                                             20.67
          FULCIR = .TRUE.
          CALL ININTG('MDC',MDC,'RQI',0)
        ENDIF
*
          CALL INREAL('FLOW',FRLOW,'RQI',0.)                              20.6x
          CALL INREAL('FHIGH',FRHIG,'RQI',0.)                             20.6x
          CALL ININTG('MSC',MSS,'RQI',0)
          SLOW = 2.*PI*FRLOW                                              20.6x
          SHIG = 2.*PI*FRHIG                                              20.6x
          MSC   = MSS+1
*
*       ***** MXC is the number of steps in X direction *****
*       ***** MYC is the number of steps in Y direction *****
*       ***** MDC is the number of steps in Theta direction
*                 as parts of a circle
*       ***** MSC is the number of steps between FLOW and FHIGH (logaritmic)
        IF (FULCIR) THEN
          DDIR  = PI2 / MDC                                               20.43
C
          SPDIR1 = 0.5 * DDIR                                             20.46
        ELSE
          IF (BNAUT) THEN                                                 30.70
C           swap values of SPDIR1 and SPDIR2, and transform               30.70
            TMPDIR = SPDIR1                                               30.70
            SPDIR1 = 180. + DNORTH - SPDIR2                               30.70
            SPDIR2 = 180. + DNORTH - TMPDIR                               30.70
          ENDIF                                                           30.70
          SPDIR1 = SPDIR1 * PI / 180.                                     30.50
          SPDIR2 = SPDIR2 * PI / 180.                                     30.50
          IF (SPDIR2.LT.SPDIR1) SPDIR2 = SPDIR2 + PI2                     20.56
          DDIR = (SPDIR2-SPDIR1) / REAL(MDC)                              20.56
          MDC = MDC + 1                                                   20.56
        ENDIF
*
        IERR = 0
        CALL DPEXPR (POOL, JSIGMA, MSC, ISIG, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IERR = 0
        CALL DPEXPR (POOL, JSPDIR, 6*MDC, ISPDIR, IERR)                   20.43
        IF (STPNOW()) RETURN                                              34.01
C
C       RPOOL(IADRS(POOL,JSIGMA)) ---> SPCSIG                             30.90
C       RPOOL(IADRS(POOL,JSPDIR)) ---> SPCDIR                             30.90
C
        CALL SSFILL(RPOOL(IADRS(POOL,JSIGMA)),RPOOL(IADRS(POOL,JSPDIR)))  30.90
*
        IF (ITEST.GE. 20) THEN
          IF(OPTG .EQ. 1)WRITE (PRINTF,6048)                              30.21
          IF(OPTG .EQ. 3)WRITE (PRINTF,6049)                              30.21
          WRITE (PRINTF,6045) SLOW, SHIG, FRINTF
          WRITE (PRINTF,6046) MXC,MYC,MDC,MSC
          WRITE (PRINTF,6047) DX,DY,DDIR
 6048     FORMAT ('GRID: REGULAR RECTANGULAR')                            30.21
 6049     FORMAT ('GRID: CURVILINEAR')                                    30.21
 6045     FORMAT (' S-low: ', F6.3,' S-hig: ', F6.3, ' frintf: ', F6.3)
 6046     FORMAT (' MXC: ',I6,' MYC: ',I6,' MDC: ',I6,' MSC: ',I6)
 6047     FORMAT (' DX: ',E12.4,' DY: ',E12.4, ' DDIR: ', F6.3)
        ENDIF
*
*       *** enlarge the pool to contain the indirect address array***
        IERR = 0
        CALL DPEXPR (POOL, JADDRS, MXC*MYC, IADDRS, IERR)
        IF (STPNOW()) RETURN                                              34.01
*
*       *** enlarge the pool to contain coordinates of   ***  VERSION 30.21
*       *** grid points                                  ***
        IERR = 0
        CALL DPEXPR (POOL, JCOOX, MXC*MYC, ICOOX, IERR)                   30.60
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JCOOY, MXC*MYC, ICOOY, IERR)                   30.60
        IF (STPNOW()) RETURN                                              34.01
*
        IF (OPTG .EQ. 1) THEN                                             30.60
*         *** The coordinates of computational points in ***
*         *** regular grid are computed                  ***
          COSPC = COS(ALPC)                                               7/JAN
          SINPC = SIN(ALPC)                                               7/JAN
          ICONT = 0
          DO 200 J = 1,MYC
            DO 205 I = 1, MXC
              ICONT = ICONT+1
              VALX = XPC + COSPC*(I-1)*DX - SINPC*(J-1)*DY                7/JAN
              VALY = YPC + SINPC*(I-1)*DX + COSPC*(J-1)*DY                7/JAN
              CALL DPPUTR(RPOOL, ICOOX+ICONT, VALX)                       40.02
              CALL DPPUTR(RPOOL, ICOOY+ICONT, VALY)                       40.02
 205        CONTINUE
 200      CONTINUE
        ENDIF
!MCEL+ J Dykes 15 Oct 2002 SWREAD: checking MCEL keyword for putting
        call INKEYW ('STA', ' ')
        if (KEYWIS ('MCE')) then 
          IREG_MC = -1
        end if
!MCEL-
        GOTO 100
      ENDIF
 
!MCEL+ J Dykes 15 Oct 2002 SWREAD: call mcel_grid for putting
      !RPOOL(IADRS(POOL,JDEB)) -----> DEPTH
      !RPOOL(IADRS(POOL,JCOOX)) ---> XCGRID
      !RPOOL(IADRS(POOL,JCOOY)) ---> YCGRID
      if (IREG_MC .EQ. -1) THEN
        IERR = 0
        call DPINQP (POOL, 'DEB', JDEB, PTYPE, IDEB, LENR, IERR)
        write(*,*)'calling mcel_grid from SWREAD'
        write(0,*)'calling mcel_grid from SWREAD'

       write(0,*)' swanpre1: calling mcel_grid from 1494 IGRID=0'

        call mcel_grid (0, MXC, MYC, XOFFS, YOFFS, DX, DY, 
     &    RPOOL(IADRS(POOL,JDEB)), 
     &    RPOOL(IADRS(POOL,JCOOX)), RPOOL(IADRS(POOL,JCOOY)),
     &    PROJT1)
        write(*,*)'back from mcel_grid from SWREAD'
        write(0,*)'back from mcel_grid from SWREAD'
        final_flag = .FALSE.
        IREG_MC = 1
      end if
!MCEL-

C     -----------------------------------------------------------------------
C
C     BOUNDARY:    defining boundary conditions                           20.63
C
      IF (KEYWIS ('BOU')) THEN
        IF (ONED) THEN
          MXSPEC = NBSPEC + 2                                             40.00
        ELSE
          MXSPEC = NBSPEC + MIN(40,2*(MXC+MYC))                           40.00
        ENDIF
        IERR = 0
        CALL DPEXPR (POOL, JBFILS, 20*MXSPEC, IBFILS, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSPEC, 2*MXSPEC*MDC*MSC, IBSPEC, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSLOC, 20*MXSPEC, IBSLOC, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSDIR, 40*MXSPEC + 10*MDC, IBSDIR, IERR)      30.80
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSFRQ, 40*MXSPEC + 10*MSC, IBSFRQ, IERR)      30.80
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBGRID, 6*(NBGRPT+10*(MXC+MYC)),
     &               IBGRID, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSAUX, 10*MDC*MSC*MXSPEC, IBSAUX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        MAUX = MAX(1000, 4*(MXC+MYC))                                     30.81
        CALL DPEXPR (POOL, JAUX(1), MAUX, IAUX1, IERR)                    30.81
        IF (STPNOW()) RETURN                                              34.01
*
        CALL SWBOUN (POOL(IADRS(POOL,JBFILS)),                            40.00
     &       POOL(IADRS(POOL,JBSLOC)),RPOOL(IADRS(POOL,JBSLOC)),          30.90
     &       POOL(IADRS(POOL,JBSDIR)),RPOOL(IADRS(POOL,JBSDIR)),          30.90
     &       POOL(IADRS(POOL,JBSFRQ)),RPOOL(IADRS(POOL,JBSFRQ)),          30.90
     &      RPOOL(IADRS(POOL,JBSPEC)),                                    40.02
     &       MXSPEC                  , POOL(IADRS(POOL,JBGRID)),
     &       POOL(IADRS(POOL,JBSAUX)),RPOOL(IADRS(POOL,JBSAUX)),          30.90
     &      RPOOL(IADRS(POOL,JCOOX)) ,                                    40.02
     &      RPOOL(IADRS(POOL,JCOOY)) , POOL(IADRS(POOL,JADDRS)),          40.02
     &      RPOOL(IADRS(POOL,JSIGMA)),RPOOL(IADRS(POOL,JSPDIR)),          40.02
     &       POOL(IADRS(POOL,JAUX(1))),POOL(IADRS(POOL,JXYTST)),
     &       POOL(IADRS(POOL,JGRBND))                          )          40.00
        IF (STPNOW()) RETURN                                              34.01
*
        IERR = -1
        CALL DPCHEK (POOL, IERR)
        CALL DPMINR (POOL, JBFILS, LBFILE, IBFILS, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBSPEC, 2*NBSPEC*MDC*MSC, IBFILE, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMINR (POOL, JBSLOC, LBSLOC, IBSLOC, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMINR (POOL, JBSDIR, LBSDIR, IBSDIR, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMINR (POOL, JBSFRQ, LBSFRQ, IBSFRQ, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JBGRID, 6*NBGRPT, IBGRID, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPMINR (POOL, JBSAUX, LBSAUX, IBSAUX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JAUX(1), 0, IAUX1, IERR)
        IF (STPNOW()) RETURN                                              34.01
        GOTO 100
      ENDIF
C
C
C     ------------------------------------------------------------------
C
C     NUM     data numerical scheme
C
C ============================================================
C
C NUMeric ACCUR  (  [drel] [dhoval] [dtoval] [npnts]                  &   40.03
C
C                    | -> STAT  [mxitst]  |
C                   <                      >  [limiter]   )           &   40.03
C                    | NONSTat  [mxitns]  |
C
C           ( DIRimpl [cdd] [cdlim]                                 )  &
C
C
C           | -> SIGIMpl [css] [prec] [eps1] [eps2] [outp] [niter] |
C          (<                                                      >) &
C           |    SIGEXpl [cfl]                 (NOT documented)    |
C           |                                                      |
C           |    FIL     [diffc]               (NOT documented)    |
C
C
C           ( SETUP [prec] [eps2] [outp] [niter]                   )      30.82
C
C
C ============================================================
C
      IF (KEYWIS ('NUM')) THEN
        CALL INKEYW ('REQ','  ')
C       *** accuracy and criterion to terminate the iteration ***
        IF (KEYWIS ('ACCUR')) THEN
          CALL INREAL ('DREL'   , PNUMS(1) , 'UNC', 0.)
          CALL INREAL ('DHOVAL' , PNUMS(15), 'UNC', 0.)                   30.82
          CALL INREAL ('DTOVAL' , PNUMS(16), 'UNC', 0.)                   30.82
          CALL INREAL ('NPNTS'  , PNUMS(4) , 'UNC', 0.)
          CALL INKEYW ('STA', 'STAT')                                     40.03
          IF (KEYWIS ('STAT')) THEN                                       40.03
            CALL ININTG ('MXITST' , MXITST   , 'REQ', 0 )                 40.03
          ELSE IF (KEYWIS ('ITERMX')) THEN                                40.03
            CALL ININTG ('MXITST' , MXITST   , 'REQ', 0 )                 40.03
            MXITNS = MXITST                                               40.03
            CALL MSGERR (1, '[itermx] is replaced; see user manual')      40.03
          ELSE IF (KEYWIS ('NONST')) THEN                                 40.03
            CALL ININTG ('MXITNS' , MXITNS   , 'REQ', 0 )                 40.03
          ENDIF
          CALL INREAL ('LIMITER', PNUMS(20), 'UNC', 0.)                   30.70
        END IF
C       *** numerical scheme in directional space (standard  ***
C       *** option implicit scheme)                          ***
        CALL INKEYW ('STA','  ')
        IF (KEYWIS ('DIR')) THEN
          CALL INREAL ('CDD'    , PNUMS(6) , 'UNC', 0.)
          CALL INREAL ('CDLIM'  , PNUMS(17), 'UNC', 0.)                   30.80
          IF (PNUMS(17).LT.0.) IREFR = 1                                  30.80
          IF (PNUMS(17).GT.0.) IREFR = -1                                 40.02
          IF (EQREAL(PNUMS(17),0.)) THEN                                  30.80
            IREFR = 0                                                     30.80
            CALL MSGERR(0, 'Refraction deactivated')                      40.02
          ENDIF
        ENDIF
C       *** numerical scheme in frequency space :                  ***
C       *** 1) Fully implicit scheme in frequency space (iterative ***
C       ***    ILU-CGSTAB solver                                   ***
C       *** 2) Explicit scheme in frequency space:                 ***
C       ***    Energy is removed from the spectrum based on a CFL  ***
C       ***    criterion                                           ***
C       *** 3) Explicit scheme in frequency space:                 ***
C       ***    No CFL limitation near blocking point --> unstable  ***
C       ***    integration. Therefore a filter is applied with a   ***
C       ***    diffusion coeff.                                    ***
C
        CALL INKEYW ('STA','  ')
        IF (KEYWIS('SIGIM') .OR. KEYWIS ('IMP')) THEN                     30.20
C         *** implicit solver ***
*         ***  This is the default option   PNUMS(8) = 1.  ***
*         ***  gived in subr. swinit in swanmain.ftn       ***
          PNUMS(8) = 1.
          CALL INREAL ('CSS'   , PNUMS(7), 'UNC', 0.)
          CALL INREAL ('PREC'  , PNUMS(10) , 'UNC', 0.)
          CALL INREAL ('EPS1'  , PNUMS(11) , 'UNC', 0.)
          CALL INREAL ('EPS2'  , PNUMS(12) , 'UNC', 0.)
          CALL INREAL ('OUTP'  , PNUMS(13) , 'UNC', 0.)
          CALL INREAL ('NITER' , PNUMS(14), 'UNC', 0.)
        ELSE IF (KEYWIS('SIGEX') .OR. KEYWIS('EXP')) THEN                 30.20
C
C         *** 2) explicit scheme ***
          PNUMS(8) = 2.
          CALL INREAL ('CFL'  , PNUMS(19), 'UNC', 0.)
C
        ELSE IF (KEYWIS ('FIL')) THEN
C         *** 3) explicit scheme -> filter the spectrum  ***
          PNUMS(8) = 3.
          CALL INREAL ('DIFFC'  , PNUMS(9), 'UNC', 0.)
C
        END IF
        CALL INKEYW ('STA','  ')                                          30.82
        IF (KEYWIS('SETUP')) THEN                                         30.82
C         *** implicit solver ***                                         30.82
C         *** Settings for the setup  ***                                 30.82
          CALL INREAL ('PREC' , PNUMS(22), 'UNC', 0.)                     30.82
          CALL INREAL ('EPS2' , PNUMS(23), 'UNC', 0.)                     30.82
          CALL INREAL ('OUTP' , PNUMS(24), 'UNC', 0.)                     30.82
          CALL INREAL ('NITER', PNUMS(25), 'UNC', 0.)                     30.82
        ENDIF                                                             30.82
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C     SETUP    setup due to waves is computed and taken into account
C
C     SETUP   [supcor]                                                    30.82
C
      IF (KEYWIS ('SETUP')) THEN                                          32.02
        LSETUP = 1                                                        32.02
        CALL INREAL ('SUPCOR', PSETUP(2), 'UNC', 0.)                      30.82
C       *** set pointers for setup and saved depth in array COMPDA ***    32.02
        JSETUP = MCMVAR + 1                                               32.02
        JDPSAV = MCMVAR + 2                                               32.02
        JWFRCX = MCMVAR + 3                                               31.04
        JWFRCY = MCMVAR + 4                                               31.04
        MCMVAR = MCMVAR + 4                                               32.02
!NRL+  J Dykes 1 July 2003 SWREAD: no setup for large domains
        if (KSPHER > 0) then
          call MSGERR (1, 'using spherical coord., SETUP ignored ')
          LSETUP = 0
        end if
!NRL-
        GOTO 100                                                          32.02
      ENDIF                                                               32.02
C
C ------------------------------------------------------------------
C
C SET: Set value of physical parameters and error counters
C
C =============================================================
C
C SET  [level]  [nor]    [depmin]   [maxmes]           &                  30.70
C
C      [maxerr] [grav]   [rho]      [inrhog]           &
C
C                | NAUTical  |                                            30.70
C      [hsrerr] <             >                        &                  30.70
C                | CARTesian |                                            30.70
C
C                                                     \
C      [pwtail] [froudmax]                          &  |
C                                                       >(NOT documented)
C      [printf] [prtest]                               |
C                                                     /
C =============================================================
C
      IF (KEYWIS ('SET')) THEN
         CALL INREAL ('LEVEL',  WLEV,   'UNC', 0.)
         CALL INREAL ('NOR',    DNORTH, 'UNC', 0.)
         CALL INREAL ('DEPMIN', DEPMIN, 'UNC', 0.)
         CALL ININTG ('MAXMES', MAXMES, 'UNC', 0)                         30.70
         CALL ININTG ('MAXERR', MAXERR, 'UNC', 0)
         CALL INREAL ('GRAV',   GRAV,   'UNC', 0.)
         CALL INREAL ('RHO',    RHO,    'UNC', 0.)
         CALL ININTG ('INRHOG', INRHOG, 'UNC', 0)
         IF (INRHOG.EQ.0) THEN                                            30.20
           OVUNIT(7) = 'm2/s'
           OVUNIT(9) = 'm2/s'
           OVUNIT(19) = 'm3/s'
           OVUNIT(21) = 'm2s'
           OVUNIT(22) = 'm2'
           OVUNIT(29) = 'm2'
         ELSE
           OVUNIT(7) = 'W/m2'
           OVUNIT(9) = 'W/m2'
           OVUNIT(19) = 'W/m'
           OVUNIT(21) = 'Js/m2'
           OVUNIT(22) = 'J/m2'
           OVUNIT(29) = 'J/m2'
         ENDIF                                                            10.17
C
         CALL INREAL ('HSRERR', HSRERR, 'UNC', 0.)                        32.01
C
         CALL INKEYW ('STA',' ')                                          32.01
         IF (KEYWIS ('NAUT')) THEN                                        40.02
           BNAUT = .TRUE.                                                 32.01
           OUTPAR(4) = 0.                                                 40.02
         ENDIF                                                            40.02
         IF (KEYWIS ('CART')) BNAUT = .FALSE.                             30.70
         IF ( ITEST .GE. 20 ) THEN                                        32.01
           WRITE (PRTEST,*) ' Set NAUT command: BNAUT=', BNAUT            32.01
         ENDIF                                                            32.01
C
         CALL INREAL ('PWTAIL', PWTAIL(1), 'UNC', 0.)
         IF (CHGVAL) THEN
           IF (PWTAIL(1).LE.1.) CALL MSGERR (3, 'Incorrect PWTAIL')
           PWTAIL(3) = PWTAIL(1) + 1.
         ENDIF
         CALL INREAL ('FROUDMAX', PNUMS(18), 'UNC', 0.)                   30.50
         CALL ININTG ('PRINTF', PRINTF, 'UNC', 0)
         CALL ININTG ('PRTEST', PRTEST, 'UNC', 0)
         GOTO 100
      ENDIF
C     ------------------------------------------------------------------
C     QUANTITY    set parameters for output quantities                    40.03
C
C     QUANTity  ????  'short'  'long'  [lexp]  [hexp]  [exc]   &          40.03
C
C         [ref]                    {for output quantity TSEC}
C         [power]                  {for output quantity WLEN, PER or RPER}
C         [freq]                   {for output quantity HSWELL}           40.03
C         PROBLEM/FRAME            {for directions and vectors)           40.03
C
      IF (KEYWIS('QUANT')) THEN                                           40.13
         CALL SVARTP (IVTYPE)
         IF (IVTYPE.GE.1 .AND. IVTYPE.LE.NMOVAR) THEN                     40.00
           CALL INCSTR ('SHORT', OVSNAM(IVTYPE), 'UNC', ' ')
           CALL INCSTR ('LONG', OVLNAM(IVTYPE), 'UNC', ' ')
           CALL INREAL ('LEXP', OVLEXP(IVTYPE), 'UNC', 0.)
           CALL INREAL ('HEXP', OVHEXP(IVTYPE), 'UNC', 0.)
           CALL INREAL ('EXCV', OVEXCV(IVTYPE), 'UNC', 0.)                40.03

           IF (IVTYPE.EQ.40 .OR. IVTYPE.EQ.41) THEN
             IF (NSTATM.EQ.0) CALL MSGERR (2,
     &       'Time output asked in stationary mode')
           ENDIF
           IF (IVTYPE.EQ.41) THEN
             CALL INCTIM (ITMOPT, 'REF', OUTPAR(1), 'UNC', 0.)
           ELSE IF (IVTYPE.EQ.42 .OR. IVTYPE.EQ.43) THEN
             CALL INREAL ('POWER', OUTPAR(2), 'UNC', 0.)
           ELSE IF (IVTYPE.EQ.17) THEN
             CALL INREAL ('POWER', OUTPAR(3), 'UNC', 0.)
           ELSE IF (IVTYPE.EQ.44) THEN
             CALL INREAL ('FSWELL', OUTPAR(5), 'UNC', 0.)                 40.03
           ENDIF
           IF (OVSVTY(IVTYPE).EQ.2 .OR. OVSVTY(IVTYPE).EQ.3) THEN
C            direction or vector
             CALL INKEYW ('STA', ' ')
             IF (KEYWIS('PROBLEM') .OR. KEYWIS('USER')) THEN              40.03
               OUTPAR(4) = 0.
               IF (BNAUT .AND. OVSVTY(IVTYPE).EQ.2) CALL MSGERR (1,       40.00
     &             'option not allowed with Nautical convention')
             ELSE IF (KEYWIS('FRAME')) THEN
               OUTPAR(4) = 1.
               IF (BNAUT .AND. OVSVTY(IVTYPE).EQ.2) CALL MSGERR (1,       40.00
     &             'option not allowed with Nautical convention')
             ENDIF
           ENDIF
         ELSE
           CALL MSGERR (2, 'unknown quantity ')                           40.03
         ENDIF
         GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     BREAK     parameters surf breaking
C
C ============================================================
C
C           | -> CONstant [alpha] [gamma]                                      |
C BREaking <                                                                    >
C           |    VARiable [alpha] [gammin] [gammax] [gamneg] [coeff1] [coeff2] |
C
C ============================================================
C
      IF (KEYWIS ('BRE')) THEN
        CALL INKEYW ('STA', 'CON')
        IF (KEYWIS('CON')) THEN
          ISURF = 1
          CALL INREAL ('ALPHA', PSURF(1), 'STA', 1.0)
          CALL INREAL ('GAMMA', PSURF(2), 'STA', 0.73)
        ELSE IF (KEYWIS('VAR')) THEN                                      28/FEB
          ISURF = 2
          CALL INREAL ('ALPHA',  PSURF(1), 'STA', 1.5)
          CALL INREAL ('GAMMIN', PSURF(4), 'STA', 0.55)
          CALL INREAL ('GAMMAX', PSURF(5), 'STA', 0.81)
          CALL INREAL ('GAMNEG', PSURF(6), 'STA', 0.73)
          CALL INREAL ('COEFF1', PSURF(7), 'STA', 0.88)
          CALL INREAL ('COEFF2', PSURF(8), 'STA', 0.012)
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     WCAP        parameters whitecapping
C
C ======================================================================================
C
C        | ->KOMen    [cds2] [stpm] [powst] [delta] [powk]  |             34.00
C        |                                                  |
C        |   JANSsen  [cds1]  [delta] [pwtail]              |
C WCAP  <                                                    >    (NOT documented)
C        |   LHIG     [cflhig]                              |
C        |                                                  |
C        |   BJ       [bjstp] [bjalf]                       |
C        |                                                  |
C        |   KBJ      [bjstp] [bjalf] [kconv]               |
C
C ======================================================================================
C
      IF (KEYWIS ('WCAP')) THEN
        CALL INKEYW ('STA','KOM')                                         970220
        IF (KEYWIS ('KOM')) THEN
C         *** whitecapping according to Komen et al. (1984) ***
          IWCAP = 1
          CALL INREAL ('CDS2', PWCAP(1), 'UNC', 0.)                       20.73
          CALL INREAL ('STPM',  PWCAP(2), 'UNC', 0.)                      20.73
          CALL INREAL ('POWST', PWCAP(9), 'UNC', 0.)                      34.00
          CALL INREAL ('DELTA', PWCAP(10), 'UNC', 0.)                     34.00
          CALL INREAL ('POWK', PWCAP(11), 'UNC', 0.)                      34.00
        ELSE IF ( KEYWIS ('JANS')) THEN
C         *** whitecapping according to Janssen (1989, 1991) ***
          IWCAP = 2
          CALL INREAL ('CDS1', PWCAP(3), 'UNC', 0.)                       20.73
          CALL INREAL ('DELTA', PWCAP(4), 'UNC', 0.)
!
!         Recalculate coefficientes that are actually used in the         40.02
!         whitecapping routines                                           40.02
          PWCAP(1)  = PWCAP(3) * (PWCAP(2) ** PWCAP(9))                   40.02
          PWCAP(10) = PWCAP(4)                                            40.02
          JUSTAR = MCMVAR+1                                               30.22
          JZEL   = MCMVAR+2                                               30.22
          JCDRAG = MCMVAR+3                                               30.22
          JTAUW  = MCMVAR+4                                               30.22
          MCMVAR = MCMVAR+4                                               30.22
          CALL INREAL ('PWTAIL', PWTAIL(1), 'STA', 5.)                    30.70
          IF (PWTAIL(1).LE.1.) CALL MSGERR (3, 'Incorrect PWTAIL')        30.70
          PWTAIL(3) = PWTAIL(1) + 1.                                      30.70
        ELSE IF ( KEYWIS ('LHIG')) THEN
C         *** whitecapping according to Longuett Higgins ***
          IWCAP = 3
          CALL INREAL ('CFLHIG', PWCAP(5), 'UNC', 0.)
        ELSE IF ( KEYWIS ('BJ')) THEN
C         *** whitecapping according to Battjes/Janssen formulation ***
          IWCAP = 4
          CALL INREAL ('BJSTP' , PWCAP(6), 'UNC', 0.)
          CALL INREAL ('BJALF' , PWCAP(7), 'UNC', 0.)
        ELSE IF ( KEYWIS ('KBJ')) THEN
C         *** whitecapping according to a combination of Komen et al ***
C         *** and Battjes/Janssen                                    ***
          IWCAP = 5
          CALL INREAL ('BJSTP' , PWCAP(6), 'UNC', 0.)
          CALL INREAL ('BJALF' , PWCAP(7), 'UNC', 0.)
          CALL INREAL ('KCONV' , PWCAP(8), 'UNC', 0.)
        ELSE
          CALL WRNKEY
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     *** PARAMETERS FOR BOTTOM FRICTION ***
C
C ===============================================
C
C                   | -> JONSWAP       [cfjon]
C                   |
C     FRICTION     <     COLLINS       [cfw]    &
C                   |
C                   |                  [cfc]    (NOT documented)
C                   |
C                   |    MADSEN        [kn]
C
C ===============================================
C
      IF (KEYWIS ('FRIC')) THEN
        IBOT = 1
        CALL INKEYW ('STA','JON')
        IF (KEYWIS('JON')) THEN
          IBOT = 1
          CALL INREAL('CFJON',PBOT(3),'UNC',0.)
        ELSE IF (KEYWIS('COLL')) THEN                                     20.68
          IBOT = 2
          CALL INREAL('CFW',PBOT(2),'UNC',0.)
          CALL INREAL('CFC',PBOT(1),'UNC',0.)
        ELSE IF (KEYWIS('MAD')) THEN
          IBOT = 3
          CALL INREAL('KN',PBOT(5),'UNC',0.)
        ELSE
          CALL WRNKEY
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     WIND       parameters uniform wind field
C
C ==========================================
C
C WIND  [vel]  [dir]  [astd]                                              40.03
C
C ==========================================
C
      IF (KEYWIS ('WIND')) THEN
*       *** initialize first generation model ***
        LWINDR = 1                                                        30.10
        IWIND  = LWINDM                                                   30.10
        VARWI = .FALSE.
        CALL INREAL('VEL',U10,'REQ',0.)
        CALL INREAL('DIR',WDIP,'REQ',0.)
        CALL INREAL('ASTD',CASTD,'STA',0.)                                40.03
C
C       *** Convert (if necessary) WDIP from nautical degrees ***         32.01
C       *** to cartesian degrees                              ***         32.01
C
        WDIP = DEGCNV (WDIP)                                              32.01
C
        IF (IWIND.EQ.0) IWIND = 4                                         20.74
        ALTMP = WDIP / 360.
        WDIP = PI2 * (ALTMP - NINT(ALTMP))
        IF (JWX2.LE.1) THEN                                               40.00
          MCMVAR = MCMVAR + 2                                             20.39
          JWX2   = MCMVAR - 1
          JWY2   = MCMVAR
        ENDIF
C
        GOTO 100
      ENDIF
C     ------------------------------------------------------------------
C
C     GEN1        deep water with 1st generation                          20.86
C
C ==========================================
C
C GEN1     [cf10]  [cf20]  [cf30]  [cf40]  [edmlpm]  [cdrag]  [umin]  [cfpm]
C
C ==========================================
C
      IF (KEYWIS('GEN1')) THEN
*       *** initialize first generation model ***
        IGEN = 1                                                          32.06
        LWINDM = 1                                                        30.10
        IF (LWINDR .GT. 0) IWIND = LWINDM                                 30.10
        IQUAD = 0
        IWCAP = 0
        PNUMS(20)=1.E23                                                   30.82
C       *** set value for the windparameters ***
C       *** first generation wind model ***
        CALL INREAL ('CF10', PWIND(1), 'UNC', 0.)
        CALL INREAL ('CF20', PWIND(2), 'UNC', 0.)
        CALL INREAL ('CF30', PWIND(3),'UNC',0.)
        CALL INREAL ('CF40', PWIND(4),'UNC',0.)
        CALL INREAL ('EDMLPM', PWIND(10), 'UNC', 0.)
        CALL INREAL ('CDRAG',  PWIND(11), 'UNC', 0.)
        CALL INREAL ('UMIN', PWIND(12), 'UNC', 0.)
        CALL INREAL ('CFPM',  PWIND(13), 'UNC', 0.)
C       if [pwtail] is not changed, make it 5
        IF (EQREAL(PWTAIL(1),4.)) THEN                                    40.00
          PWTAIL(1) = 5.                                                  40.00
          PWTAIL(3) = PWTAIL(1) + 1.                                      30.70
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     GEN2        deep water with 2nd generation                          20.86
C
C ==========================================
C
C GEN2 [cf10] [cf20] [cf30] [cf40] [cf50] [cf60] [edmlpm] [cdrag] [umin] [cfpm]
C
C ==========================================
C
      IF (KEYWIS('GEN2')) THEN
*       *** initialize second generation model ***
        IGEN = 2                                                          32.06
        LWINDM = 2                                                        30.10
        IF (LWINDR .GT. 0) IWIND = LWINDM                                 30.10
        IQUAD = 0
        IWCAP = 0
        PNUMS(20)=1.E23                                                   30.82
*       *** set value for the windparameters ***
        CALL INREAL ('CF10', PWIND(1), 'UNC', 0.)
        CALL INREAL ('CF20', PWIND(2), 'UNC', 0.)
        CALL INREAL ('CF30', PWIND(3),'UNC',0.)
        CALL INREAL ('CF40', PWIND(4),'UNC',0.)
        CALL INREAL ('CF50', PWIND(5),'UNC',0.)
        CALL INREAL ('CF60', PWIND(6), 'UNC', 0.)
        CALL INREAL ('EDMLPM', PWIND(10), 'UNC', 0.)
        CALL INREAL ('CDRAG',  PWIND(11), 'UNC', 0.)
        CALL INREAL ('UMIN', PWIND(12), 'UNC', 0.)
        CALL INREAL ('CFPM',  PWIND(13), 'UNC', 0.)
C       if [pwtail] is not changed, make it 5
        IF (EQREAL(PWTAIL(1),4.)) THEN                                    40.00
          PWTAIL(1) = 5.                                                  40.00
          PWTAIL(3) = PWTAIL(1) + 1.                                      30.70
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     GEN3        deep water with 3d generation                           20.86
C
C ======================================================================================
C
C       |   JANSsen [cds1] [delta]                         |              40.02
C GEN3 <                                                    >     &
C       | ->KOMen   [cds2] [stpm] [powst] [delta] [powk]   |              34.00
C       |                                                  |
C       |   YAN     (NOT documented)                       |
C
C  (QUADrupl [iquad] [limiter] [lambda] [cnl4] [csh1] [csh2] [csh3]) (AGROW [a])
C
C ======================================================================================
C
      IF (KEYWIS('GEN3')) THEN
*       *** initialize third generation model ***
        IGEN = 3                                                          32.06
        CALL INKEYW ('STA', 'KOM')                                        970220
        IF (KEYWIS('JANS')) THEN                                          970220
          LWINDM = 4                                                      30.1x
          IF (LWINDR .GT. 0) IWIND = LWINDM                               30.1x
C         *** whitecapping according to Janssen (1989, 1991) ***
          IWCAP = 2
          CALL INREAL ('CDS1', PWCAP(3), 'UNC', 0.)                       20.73
          CALL INREAL ('DELTA', PWCAP(4), 'UNC', 0.)
!
!         Recalculate coefficientes that are actually used in the         40.02
!         whitecapping routines                                           40.02
          PWCAP(1)  = PWCAP(3) * (PWCAP(2) ** PWCAP(9))                   40.02
          PWCAP(10) = PWCAP(4)                                            40.02
          JUSTAR = MCMVAR+1                                               30.72
          JZEL   = MCMVAR+2                                               30.72
          JCDRAG = MCMVAR+3                                               30.72
          JTAUW  = MCMVAR+4                                               30.72
          MCMVAR = MCMVAR+4                                               30.72
C         if [pwtail] is not changed, make it 5
          IF (EQREAL(PWTAIL(1),4.)) THEN                                  40.00
            PWTAIL(1) = 5.                                                40.00
            PWTAIL(3) = PWTAIL(1) + 1.                                    30.70
          ENDIF
        ELSE IF (KEYWIS('YAN')) THEN
*         option not documented in user manual
          LWINDM = 5                                                      30.1x
          IF (LWINDR .GT. 0) IWIND = LWINDM                               30.1x
        ELSE
          CALL IGNORE ('KOM')                                             970220
          LWINDM = 3                                                      30.1x
          IF (LWINDR .GT. 0) IWIND = LWINDM                               30.1x
C         *** whitecapping according to Komen et al. (1984) ***
          IWCAP = 1
          CALL INREAL ('CDS2', PWCAP(1), 'UNC', 0.)                       20.73
          CALL INREAL ('STPM', PWCAP(2), 'UNC', 0.)                       20.73
        ENDIF
*       ***  parameters nonlinear 4 wave interactions ***
        CALL INKEYW ('STA', ' ')
        IQUAD = 2
        PNUMS(20) = 0.1
        IF (KEYWIS ('QUAD')) THEN
          CALL ININTG ('IQUAD', IQUAD, 'UNC', 0)
C         *** if quadruplets are activated then LIMITER = 0.1 ***
C         *** the standard value, however, is 1.e20           ***
          CALL INREAL ('LAMBDA', PQUAD(1), 'UNC', 0.0)                    34.00
          CALL INREAL ('CNL4', PQUAD(2), 'UNC', 0.0)                      34.00
          CALL INREAL ('CSH1', PQUAD(3), 'UNC', 0.0)                      34.00
          CALL INREAL ('CSH2', PQUAD(4), 'UNC', 0.0)                      34.00
          CALL INREAL ('CSH3', PQUAD(5), 'UNC', 0.0)                      34.00
        ENDIF
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('AGROW')) THEN                                         7/MAR
          CALL INREAL ('A',PWIND(31),'STA',0.0015)
        ELSE                                                              30.60
          IF (NSTATM.EQ.1 .AND. ICOND.EQ.0) ICOND = 1                          30.70
        ENDIF
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     GROWTH       parameters wind input source term                      20.67
C     Note: command does not appear in user manual for SWAN               20.86
C
C ==========================================
C
C         |   G1 [cf10] [cf20] [cf30] [cf40]               & |
C         |                                                  |
C         |      [edmlpm] [cdrag] [umin] [cfpm]              |
C         |                                                  |
C         |   G2 [cf10] [cf20] [cf30] [cf40] [cf50] [cf60] & |
C         |                                                  |
C GROWTH <       [edmlpm] [cdrag] [umin] [cfpm]              | (NOT documented)
C         |                                                  |
C         |       |   JANSsen [pwtail] |                     |
C         | ->G3 <                      > (AGROW [a])        |
C         |       | ->KOMen            |                     |
C         |       |                    |                     |
C         |       |   YAN              |                     |
C
C
      IF (KEYWIS('GROWTH') .OR. KEYWIS ('PARW')) THEN                     20.67
*         *** initialize first generation model ***
          CALL INKEYW ('STA', 'G3')                                       20.6x
          IF (KEYWIS('G1') .OR. KEYWIS ('SNY1')) THEN                     20.6x
            IGEN = 1                                                      32.06
            IWIND = 1
            IQUAD = 0                                                     20.RR
            PNUMS(20)=1.E23                                               30.82
C           *** set value for the windparameters ***
C           *** first generation wind model ***
            CALL INREAL ('CF10', PWIND(1), 'UNC', 0.)
            CALL INREAL ('CF20', PWIND(2), 'UNC', 0.)
            CALL INREAL ('CF30', PWIND(3),'UNC',0.)
            CALL INREAL ('CF40', PWIND(4),'UNC',0.)
            CALL INREAL ('CF50', PWIND(5),'UNC',0.)
            CALL INREAL ('CF60', PWIND(6), 'UNC', 0.)
            CALL INREAL ('CF70', PWIND(7), 'UNC', 0.)
            CALL INREAL ('CF80', PWIND(8), 'UNC', 0.)
            CALL INREAL ('RHOAW', PWIND(9), 'UNC', 0.)
            CALL INREAL ('EDMLPM', PWIND(10), 'UNC', 0.)
            CALL INREAL ('CDRAG',  PWIND(11), 'UNC', 0.)
            CALL INREAL ('UMIN', PWIND(12), 'UNC', 0.)
            CALL INREAL ('CFPM',  PWIND(13), 'UNC', 0.)
          ELSE IF (KEYWIS('G2') .OR. KEYWIS('SNY2')) THEN                 20.6x
            IGEN = 2                                                      32.06
            IWIND = 2
            IQUAD = 0                                                     20.RR
            PNUMS(20)=1.E23                                               30.82
C           *** second generation wind model ***
            CALL INREAL ('CF10', PWIND(1), 'UNC', 0.)
            CALL INREAL ('CF20', PWIND(2), 'UNC', 0.)
            CALL INREAL ('CF30', PWIND(3),'UNC',0.)
            CALL INREAL ('CF40', PWIND(4),'UNC',0.)
            CALL INREAL ('CF50', PWIND(5),'UNC',0.)
            CALL INREAL ('CF60', PWIND(6), 'UNC', 0.)
            CALL INREAL ('CF70', PWIND(7), 'UNC', 0.)
            CALL INREAL ('CF80', PWIND(8), 'UNC', 0.)
            CALL INREAL ('RHOAW', PWIND(9), 'UNC', 0.)
            CALL INREAL ('EDMLPM', PWIND(10), 'UNC', 0.)
            CALL INREAL ('CDRAG',  PWIND(11), 'UNC', 0.)
            CALL INREAL ('UMIN', PWIND(12), 'UNC', 0.)
            CALL INREAL ('CFPM',  PWIND(13), 'UNC', 0.)
          ELSE IF (KEYWIS('G3')) THEN                                     20.6x
            IGEN = 3                                                      32.06
            CALL INKEYW ('STA', 'KOM')
            IF (KEYWIS('JANS')) THEN                                      20.6x
              IWIND = 4
              CALL INREAL ('PWTAIL', PWTAIL(1), 'STA', 5.)                30.70
              IF (PWTAIL(1).LE.1.) CALL MSGERR (3, 'Incorrect PWTAIL')    30.70
              PWTAIL(3) = PWTAIL(1) + 1.                                  30.70
            ELSE IF (KEYWIS('YAN')) THEN
              IWIND = 5
            ELSE
              CALL IGNORE ('KOM')
              IWIND = 3
            ENDIF
            CALL INKEYW ('STA', ' ')
            IF (KEYWIS('AGROW')) THEN                                     7/MAR
              CALL INREAL ('A',PWIND(31),'STA',0.0015)
            ELSE                                                          30.60
              IF (NSTATM.EQ.1 .AND. ICOND.EQ.0) ICOND = 1                      30.70
            ENDIF
          ELSE
            CALL WRNKEY
          END IF
          GOTO 100
      ENDIF
*     ------------------------------------------------------------------
*     ***  parameters nonlinear 4 wave interactions ***
      IF (KEYWIS ('QUAD')) THEN
C
C ===================================================================
C
C  QUADrupl [iquad] [limiter] [lambda] [cnl4] [csh1] [csh2] [csh3]        34.00
C
C ===================================================================
C
        CALL ININTG ('IQUAD', IQUAD, 'UNC',  0)
C       *** if quadruplets are activated then LIMITER = 0.1 ***
C       *** the standard value, however, is 1.e20           ***
        CALL INREAL ('LIMITER', PNUMS(20), 'STA', 0.1)                    30.70
        CALL INREAL ('LAMBDA', PQUAD(1), 'UNC', 0.0)                      34.00
        CALL INREAL ('CNL4', PQUAD(2), 'UNC', 0.0)                        34.00
        CALL INREAL ('CSH1', PQUAD(3), 'UNC', 0.0)                        34.00
        CALL INREAL ('CSH2', PQUAD(4), 'UNC', 0.0)                        34.00
        CALL INREAL ('CSH3', PQUAD(5), 'UNC', 0.0)                        34.00
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     ***  parameters nonlinear 3 wave interactions
C
C ============================================================
C
C             (NOT documented)
C         ___________/\___________
C        /                        \
C          |   DTA |    |   EXP |
C TRIad  (<         >  <         >)   ( [trfac] [cutfr] )    &
C          | ->LTA |    | ->IMP |
C
C          [urcrit]   [urslim]                                            40.13
C
C ============================================================
C
      IF (KEYWIS ('TRI')) THEN
        ITRIAD = 3                                                        20.81
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('DTA')) THEN
          ITRIAD   = 1
          PTRIAD(1) = 0.5
        ELSE
          CALL IGNORE ('LTA')
          ITRIAD = 3
          PTRIAD(1) = 0.1                                                 30.82
        ENDIF
        CALL INKEYW ('STA', ' ')
        IF (KEYWIS('EXP')) THEN
          ITRIAD = ITRIAD + 1
C         limiter activated only for explicit triads
          PNUMS(20) = 0.1                                                 40.00
        ELSE
          CALL IGNORE ('IMP')
        ENDIF
        CALL INREAL ('TRFAC', PTRIAD(1), 'UNC', 0.0)
        CALL INREAL ('CUTFR', PTRIAD(2), 'STA', 2.2)                      30.82
        CALL INREAL ('URCRIT', PTRIAD(4), 'UNC', 0.0)                     40.13
        CALL INREAL ('URSLIM', PTRIAD(3), 'STA', 0.5*PTRIAD(4))           40.13
C       reserve space in array Compda for Ursell number                   40.03
        IF (JURSEL.LE.1) THEN
          MCMVAR = MCMVAR + 1
          JURSEL = MCMVAR                                                 40.03
        ENDIF
C
        GOTO 100
      ENDIF
C
C     ------------------------------------------------------------------
C
C     OFF      switching standard options off
C
C ============================================================
C
C        |  BREaking
C        |
C        |  WCAPping
C        |
C        |  REFrac
C OFF   <
C        |  FSHift
C        |
C        |  QUADrupl
C        |
C        |  WINDGrowth                                                    30.70
C        |
C        |  BNDCHK                                                        40.00
C
C ============================================================
C
      IF (KEYWIS ('OFF')) THEN
        CALL INKEYW ('REQ', ' ')
        IF (KEYWIS ('REF')) THEN
          IREFR = 0
        ELSE IF (KEYWIS ('FSH')) THEN                                     30.20
          ITFRE = 0
        ELSE IF (KEYWIS ('BRE')) THEN
          ISURF = 0
        ELSE IF (KEYWIS ('WCAP')) THEN
          IWCAP = 0
        ELSE IF (KEYWIS ('QUAD')) THEN                                    20.86
          IQUAD = 0                                                       20.86
          IF (ITRIAD.LE.1 .OR. ITRIAD.EQ.3) THEN                          40.00
            PNUMS(20) = 1.E+20                                            30.70
            CALL MSGERR (0, 'limiter is deactivated')
          ENDIF                                                           40.00
        ELSE IF (KEYWIS ('WINDG')) THEN                                   30.70
          IWIND = 0                                                       30.70
        ELSE IF (KEYWIS ('BNDCHK')) THEN
C         switch off checking of Hs on boundary                           40.00
          BNDCHK = .FALSE.                                                40.00
        ELSE IF (KEYWIS ('RESCALE')) THEN                                 40.00
C         switch off rescaling solution                                   40.00
          BRESCL = .FALSE.                                                40.00
        ELSE
          CALL WRNKEY                                                     30.60
        ENDIF
        GOTO 100
      ENDIF
C     ------------------------------------------------------------------
C
C     In case of an empty line in the command file proceed to next line
C
      IF (KEYWRD .EQ. '    ') GOTO 100                                    40.00
C
C     process output requests                                             40.00
C
      IERR = 0
      PNAME = 'OUTDA'
      CALL DPINQP (POOL, PNAME, JOUTDA, PTYPE, IOUTD,
     &             LENREC, IERR)
      CALL DPEXPR (POOL, JOUTDA, LENREC+25600, IOUTD, IERR)               40.00
      IF (STPNOW()) RETURN                                                34.01
      PNAME = 'SIG'
      CALL DPINQP (POOL, PNAME, INDX, PTYPE, ISIG, LENREC, IERR)
      PNAME = 'ADDRS'                                                     30.21
      CALL DPINQP (POOL, PNAME, JADDRS, PTYPE, IADDRS,LENREC,IERR)        30.21
      IERR = 0
      CALL DPINQP (POOL, 'DEB', JDEB, PTYPE, IDEB, LENR, IERR)            30.70
      IF (LEDS(7).GE.2) THEN                                              30.70
        CALL DPINQP (POOL, 'WLEV', JWLVI, PTYPE, IWLVI, LENR, IERR)       30.70
      ELSE
        JWLVI = 1                                                         30.70
      ENDIF
      CALL SPROUT(FOUND, POOL(IOUTD), RPOOL(IOUTD), RPOOL(ISIG+1)  ,      40.02
     &           RPOOL(IADRS(POOL,JCOOX)) ,RPOOL(IADRS(POOL,JCOOY)),      40.02
     &            POOL(IADRS(POOL,JADDRS)),RPOOL(IADRS(POOL,JDEB)) ,      40.02
     &           RPOOL(IADRS(POOL,JWLVI)))                                40.02
      IF (STPNOW()) RETURN                                                34.01
      IF (.NOT.FOUND) THEN
        LEVERR = MAX(LEVERR,3)
        CALL WRNKEY
      ENDIF
      GOTO 100
C
C   * end of subroutine SWREAD *
      END
************************************************************************
*                                                                      *
      SUBROUTINE SINPGR (IGRID1, IGRID2, SNAMEG, OUTPS , ROUTPS)          40.12 40.13
*                                                                      *
************************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
!MCEL+ J Dykes 15 Oct 2002 SINPGR: includes
      include 'MCEL.inc'
      include 'mcel_swan.inc'
!MCEL-
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.60, 30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     32.02: Roeland Ris & Cor van der Schelde
C     30.75, 31.04, 40.13: Nico Booij
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.12: IJsbrand Haagsma
C
C  1. Updates
C
C     00.00, Jan. 92
C     30.60, July 97: exception value introduced
C     30.60, July 97: default values for STAGRX, STAGRY, MXINP, MYINP
C     30.60, Aug. 97: format 6021 changed
C     30.60, Aug. 97: keyword EXC not required
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.72, Nov. 97: Header renewed, Common Blocks updated
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     32.02, Feb. 98: Introduced 1D-version
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.70, Feb. 98: warning concerning DYINP removed; default MYINP changed
C     30.75, Mar. 98: correction nonstationary wind and current field
C     30.80, Apr. 98: default value for MYINP (curvil. grid) was lost
C     34.01, Feb. 99: Introducing STPNOW
C     40.02, Oct. 00: Avoided real/int conflict by introducing replacing
C                     RPOOL for POOL in DPPUTR
C     40.12, Feb. 01: Avoided type conflict for OUTPS
!     40.13, Aug. 01: [xpinp] and [ypinp] are now required in case of
!                     spherical coordinates
!                     Arguments XCGRID and YCGRID removed (not used)
C
C  2. Purpose
C
C     Read parameters of an input grid
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
!     ROUTPS: Output frame data                                           40.12
C
      REAL             :: ROUTPS(*)                                       40.12
 
!         Arguments XCGRID and YCGRID are not used                            40.13
 
C     IGRID1:   input  int grid number for which parameters are read
C     IGRID2:   input  int input grid number for which parameters are read
C                          only relevant if >0                            10.26
C     SNAMEG:   input char name of output frame corresponding to input grid
C     OUTPS(*): outp  real array storing output frame data
C
C  9. Subroutines calling
C
C     SWREAD:  Reading and processing of the user commands describing the model
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
C  7. Common Blocks used (updated 30.72)
C
C     COMMON / REFNRS / *** file unit reference numbers
C     COMMON / SWCOMG / *** location and dimensions of computational grid
C     COMMON / SWFYSP / *** physical parameters
C     COMMON / SWGRID / *** location and dimensions of input grids
C     COMMON / SWTEST / *** information for test output
C     COMMON / SWUITV / *** information for output
C     COMMON / TESTDA / *** test parameters
C     COMMON / TIMFIL / *** ???
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C       subroutine computes the following common data:
C       XCGMIN, XCGMAX, YCGMIN, YCGMAX                                    40.00
C
C 12. Structure
C
C     ---
C
C 13. SOURCE TEXT
C
      INTEGER   IGRID1, OUTPS(*), IERR
      REAL       :: YSCALE = 1. ! length scale                            33.09
      REAL, SAVE :: COSYPS = 1. ! cos of latitude (1 for Cartesian coordinates)
      CHARACTER SNAMEG *8
      LOGICAL   KEYWIS                                                    30.00
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SINPGR')
*
*
*     *** user gives coord. corner point input grid               ***
*     *** Regular or curvilinear grid option  for version 30.21   ***
*
*     *** Type of grid -Regular(1) or Curvilinear(2)- is indicated***
*     *** by array IGTYPE(NUMGRD) in common SWGRID                ***
C
C     ------------------------------------------------------------------
C
C     INPUT    definition of input grids
C
C ========================================================================
C
C            | BOTtom   |
C            |          |
C            | WLEVel   |
C            |          |
C            | CURrent  |
C            |          |
C            | VX       |
C            |          |
C            | VY       |
C INPgrid  (<            >) &
C            | FRiction |
C            |          |
C            | WInd     |
C            |          |
C            | WX       |
C            |          |
C            | WY       |
C            |          |
C            | ASTD     |                                                 40.03
C
C
C    | REGular [xpinp] [ypinp] [alpinp] [mxinp] [myinp] [dxinp] [dyinp] |
C   <                                                                    > &
C    | CURVilinear [stagrx] [stagry] [mxinp] [myinp]                    |
C
C
C    (EXCeption  [excval])   &
C
C
C                                        | -> SEC  |
C    (NONSTATionary [tbeginp] [deltinp] <     MIN   >  [tendinp])
C                                        |    HR   |
C                                        |    DAY  |
C
C =========================================================================
C
       write(0,*)'entering SINPGR MXC,MYC', MXC,MYC
      CALL INKEYW ('STA', 'REG')                                          30.21
      IF (KEYWIS('CURV')) THEN
C
        IF (ONED) THEN                                                    32.02
          CALL MSGERR (4,                                                 32.02
     &       'Impossible option: 1D-simulation with curvilinear grid')    32.02
        ENDIF                                                             32.02
C
        IGTYPE(IGRID1) = 2                                                30.21
*       default values changed                                            30.60
        CALL INREAL ('STAGRX',STAGRX,'STA', 0.)                           30.60
        CALL INREAL ('STAGRY',STAGRY,'STA', 0.)                           30.60
        STAGX(IGRID1) = STAGRX                                            30.21
        STAGY(IGRID1) = STAGRY                                            30.21
        MXG(IGRID1) = MXG(IGRID1) - 1
        MYG(IGRID1) = MYG(IGRID1) - 1
*       default values changed                                            30.60
        CALL ININTG ('MXINP', MXG(IGRID1),'STA', MXC-1)                   30.60
        MXG(IGRID1) = MXG(IGRID1) + 1
        IF (ONED) THEN                                                    32.02
          CALL ININTG ('MYINP', MYG(IGRID1),'STA',0)                      30.70
          IF (MYG(IGRID1) .NE. 0) THEN                                    30.70
            CALL MSGERR (1, '1D-simulation: [myinp] set to zero !')       32.02
          ENDIF                                                           32.02
          MYG(IGRID1) = 0                                                 30.70
        ELSE
          CALL ININTG ('MYINP', MYG(IGRID1),'STA',MYC-1)                  30.80
        ENDIF                                                             32.02
        MYG(IGRID1) = MYG(IGRID1) + 1
      ELSE
        CALL IGNORE('REG')
        IGTYPE(IGRID1) = 1                                                30.21
        IF (KSPHER .EQ. 0) THEN                                           40.13
          CALL READXY ('XPINP', 'YPINP', XPG(IGRID1), YPG(IGRID1),
     &                 'UNC', 0., 0.)                                     30.20
          CALL INREAL ('ALPINP',ALPG(IGRID1),'UNC',0.)                    30.20
        ELSE                                                              40.13
!         [xpinp] and [ypinp] are required in case of spherical coordinates
          CALL READXY ('XPINP', 'YPINP', XPG(IGRID1), YPG(IGRID1),
     &                 'REQ', 0., 0.)                                     40.13
          CALL INREAL ('ALPINP',ALPG(IGRID1),'STA',0.)                    40.13
        ENDIF                                                             40.13
*       ---------  ALPG(IGRID1) is always between -PI and PI   ---------
        ALTMP = ALPG(IGRID1)/360.
        ALPG(IGRID1)  = PI2 * (ALTMP - NINT(ALTMP))
        COSPG(IGRID1) = COS(ALPG(IGRID1))
        SINPG(IGRID1) = SIN(ALPG(IGRID1))
*       *** the user gives number of meshes in X resp. Y direction ***
*       *** the program uses the number of grid points             ***
        MXG(IGRID1) = MXG(IGRID1) - 1
        MYG(IGRID1) = MYG(IGRID1) - 1
        CALL ININTG ('MXINP', MXG(IGRID1),'RQI',-1)                       30.20
        IF (ONED) THEN                                                    32.02
          CALL ININTG ('MYINP', MYG(IGRID1),'STA',0)                      30.70
          IF (MYG(IGRID1) .NE. 0) THEN                                    32.02
            CALL MSGERR (1, '1D-simulation: [myinp] set to zero !')       32.02
            MYG(IGRID1) = 0                                               32.02
          ENDIF                                                           32.02
        ELSE
          CALL ININTG ('MYINP', MYG(IGRID1),'RQI',-1)                     30.20
        ENDIF                                                             32.02
        MXG(IGRID1) = MXG(IGRID1) + 1
        MYG(IGRID1) = MYG(IGRID1) + 1
C
        CALL INREAL ('DXINP',DXG(IGRID1),'RQI',0.)                        30.20
        CALL INREAL ('DYINP',DYG(IGRID1),'STA',DXG(IGRID1))               30.20
C
      ENDIF
C
C     exception values for input variables                                30.60
C
      CALL INKEYW ('STA', ' ')                                            30.60
      IF (KEYWIS ('EXC')) THEN                                            30.60
        CALL INREAL ('EXCVAL', EXCFLD(IGRID1), 'REQ', 0.)                 30.60
      ENDIF                                                               30.60

      LEDS(IGRID1) = 1
*     next lines to process the option NONSTAT for wind, currents         30.70
*     and waterlevel                                                VER.  30.00
*     SUBR. INCTIM reads a time string  and gives a time from given
*     reference day
      CALL INKEYW ('STA', ' ')
      IF (KEYWIS ('NONSTAT')) THEN
        IF (NSTATM.EQ.0) CALL MSGERR (3,
     &  'keyword NONSTAT not allowed in stationary mode')
        NSTATM = 1
        IF (IGRID1.EQ.1 .OR. IGRID1.EQ.8) CALL MSGERR (2,
     &        'nonstationary input field not allowed in this case')
        CALL INCTIM (ITMOPT,'TBEGINP',IFLBEG(IGRID1),'REQ',0.)            40.00
        CALL ININTV ('DELTINP', IFLINT(IGRID1), 'REQ', 0.)                40.00
        CALL INCTIM (ITMOPT,'TENDINP',IFLEND(IGRID1),'STA',1.E20)         40.00
        IFLDYN(IGRID1) = 1                                                40.00
        IFLTIM(IGRID1) = IFLBEG(IGRID1)                                   40.00
        IF (IGRID2 .GT. 0) THEN
          IFLBEG(IGRID2) = IFLBEG(IGRID1)                                 40.00
          IFLINT(IGRID2) = IFLINT(IGRID1)                                 40.00
          IFLEND(IGRID2) = IFLEND(IGRID1)                                 40.00
          IFLDYN(IGRID2) = IFLDYN(IGRID1)                                 40.00
          IFLTIM(IGRID2) = IFLTIM(IGRID1)                                 40.00
        ENDIF
        IF (IFLEND(IGRID1).LT.0.9E20) THEN
          IF ( MOD(IFIX(IFLEND(IGRID1)-IFLBEG(IGRID1)),
     &             IFIX(IFLINT(IGRID1))) .NE. 0) CALL MSGERR (1,
     &             'Interval is not a fraction of the period')
        ENDIF
      ENDIF
      IF ((MXG(IGRID1).EQ.0).OR.(MYG(IGRID1).EQ.0)) GOTO 100

!MCEL+ J Dykes 15 Dec 2002 SINPGR: call mcel_grid and mcel_filt for getting
      call INKEYW ('STA', ' ')
      if (KEYWIS ('MCE')) then 
      if (mcel_get_tag(IGRID1) == 0) THEN
         mcel_get_name(IGRID1) = SNAMEG
       write(*,*)' swanpre1: calling mcel_grid from SINPGR'
       write(0,*)' swanpre1: calling mcel_grid from SINPGR IGRID1=',
     &            IGRID1,MXC,MYC

         call mcel_grid1 (IGRID1, MXG(IGRID1), MYG(IGRID1),
     &      XPG(IGRID1) + XOFFS, YPG(IGRID1) + YOFFS, 
     &      DXG(IGRID1), DYG(IGRID1))

       write(*,*)' swanpre1: back from mcel_grid '
       write(0,*)' swanpre1: back from mcel_grid '
         call mcel_filt (mcel_get_name(IGRID1), IGRID1)
         mcel_get_tag(IGRID1) = 1
         if ( IGRID2 .gt. 0 ) then
           mcel_get_name(IGRID2) = mcel_get_name(IGRID1)
           mcel_get_name(IGRID2)(1:1) = 'v'
           call mcel_filt (mcel_get_name(IGRID2), IGRID1)
           mcel_get_tag(IGRID2) = 1
         endif
      end if
      end if
!MCEL-

*     ***** input grid is included in output data                 *****
*     ***** reference point coincides with origin of output frame *****
      IREC = 0
      CALL DPADDP (OUTPS, SNAMEG, IREC, 'S', INX, IERR)
      IF (STPNOW()) RETURN                                                34.01
      CALL DPEXPR (OUTPS, IREC, 10, ILOCR, IERR)
      IF (STPNOW()) RETURN                                                34.01
*
      IF (IGTYPE(IGRID1) .EQ. 1) THEN                                     30.21
        OUTPS(ILOCR+1) = ICHAR('F')                                       30.21
        XQLEN          = (MXG(IGRID1)-1)*DXG(IGRID1)
        CALL DPPUTR (ROUTPS,ILOCR+2,XQLEN)                                40.12
C
        IF (ONED) THEN                                                    32.02
          YQLEN          = XQLEN                                          32.02
        ELSE                                                              32.02
          YQLEN          = (MYG(IGRID1)-1)*DYG(IGRID1)
        ENDIF                                                             32.02
C
        CALL DPPUTR (ROUTPS,ILOCR+3,YQLEN)                                40.12
        CALL DPPUTR (ROUTPS,ILOCR+4,XPG(IGRID1))                          40.12
        CALL DPPUTR (ROUTPS,ILOCR+5,YPG(IGRID1))                          40.12
        CALL DPPUTR (ROUTPS,ILOCR+6,ALPG(IGRID1))                         40.12
        OUTPS(ILOCR+7) = MXG(IGRID1)
        OUTPS(ILOCR+8) = MYG(IGRID1)
        IF (PROJ_METHOD.EQ.1) THEN                                        33.09
          COSYPS = COS(DEGRAD*(YOFFS+YPG(IGRID1)+0.5*YQLEN))              33.09
        ENDIF
        YSCALE = MIN (XASM/(XQLEN*COSYPS), YASM/YQLEN)                    33.09
        CALL DPPUTR (ROUTPS,ILOCR+ 9,YSCALE*XQLEN*COSYPS)                 40.12
        CALL DPPUTR (ROUTPS,ILOCR+10,YSCALE*YQLEN)                        40.12
      ELSE
        OUTPS(ILOCR+1) = ICHAR('H')                                       30.21
        CALL DPPUTR (ROUTPS,ILOCR+2,FLOAT(MXG(IGRID1)-1))                 40.12
        CALL DPPUTR (ROUTPS,ILOCR+3,FLOAT(MYG(IGRID1)-1))                 40.12
        CALL DPPUTR (ROUTPS,ILOCR+4,0.)                                   40.12
        CALL DPPUTR (ROUTPS,ILOCR+5,0.)                                   40.12
        CALL DPPUTR (ROUTPS,ILOCR+6,0.)                                   40.12
        OUTPS(ILOCR+7) = MXG(IGRID1)
        OUTPS(ILOCR+8) = MYG(IGRID1)
*       *** Because the input grid is staggered should have    ***
*       *** same length in X and Y than the computati onal grid ***
        IF (MCGRD.GT.1) THEN
          XQLEN = XCGMAX - XCGMIN                                         40.00
          YQLEN = YCGMAX - YCGMIN
          XSCALE = MIN (XASM/XQLEN, YASM/YQLEN)                           40.01
          CALL DPPUTR (ROUTPS,ILOCR+ 9,XSCALE*XQLEN)                      40.12
          CALL DPPUTR (ROUTPS,ILOCR+10,XSCALE*YQLEN)                      40.12
        ENDIF
      ENDIF
      IF (ITEST .GE. 50 .OR. INTES .GE. 5) THEN
        IF (CHAR(OUTPS(ILOCR+1)) .EQ. 'F') THEN
          WRITE(PRINTF,6021)IGRID1,CHAR(OUTPS(ILOCR+1)),XQLEN,YQLEN,
     &    XPG(IGRID1),YPG(IGRID1),ALPG(IGRID1),MXG(IGRID1),MYG(IGRID1),
     &    XSCALE*XQLEN,XSCALE*YQLEN
        ELSE
          WRITE(PRINTF,6022)IGRID1,CHAR(OUTPS(ILOCR+1)),MXG(IGRID1)-1,
     &    MYG(IGRID1)-1,0,0,0.,MXG(IGRID1),MYG(IGRID1),XSCALE*XQLEN,
     &    XSCALE*YQLEN
        ENDIF
 6021   FORMAT (' INP GRID PARAMETERS: ',/,
     &          'IGRID , FRAMTYPE,XLENFR ,YLENFR  XPFR  YPFR    ALPFR',
     &          '    MXFR MYFR XLEN*XSCAL YLEN*XSCAL',/,I2,1X,A,4X,
     &           2(1X,E8.3), 2(1X,E10.3), F7.3, 2(1X,I4), 2(1X,E8.3))     30.60
 6022   FORMAT (' INP GRID PARAMETERS: ',/,
     &          'IGRID, FRAMTYPE ,XMAXFR ,YMAXFR XMINFR YMINFR  ALPFR',
     &          '    MXFR MYFR XLEN*XSCAL YLEN*XSCAL',/,
     &          I3,8X,A,1X,4(3X,I4),5X,E8.3,2(1X,I4),2(2X,E8.3))
      ENDIF                                                               30.21
*
      IF (IGRID2.GT.0) THEN                                               10.26
        XPG(IGRID2)   = XPG(IGRID1)
        YPG(IGRID2)   = YPG(IGRID1)
        ALPG(IGRID2)  = ALPG(IGRID1)
        COSPG(IGRID2) = COSPG(IGRID1)
        SINPG(IGRID2) = SINPG(IGRID1)
        DXG(IGRID2)   = DXG(IGRID1)
        DYG(IGRID2)   = DYG(IGRID1)
        MXG(IGRID2)   = MXG(IGRID1)
        MYG(IGRID2)   = MYG(IGRID1)
        IGTYPE(IGRID2)= IGTYPE(IGRID1)                                    30.51
        LEDS(IGRID2)  = 1
      ENDIF                                                               10.26
*
      DO 80 IGRID = IGRID1+1, NUMGRD
        IF (LEDS(IGRID).EQ.0) THEN
          XPG(IGRID)   = XPG(IGRID1)
          YPG(IGRID)   = YPG(IGRID1)
          ALPG(IGRID)  = ALPG(IGRID1)
          COSPG(IGRID) = COSPG(IGRID1)
          SINPG(IGRID) = SINPG(IGRID1)
          DXG(IGRID)   = DXG(IGRID1)
          DYG(IGRID)   = DYG(IGRID1)
          MXG(IGRID)   = MXG(IGRID1)
          MYG(IGRID)   = MYG(IGRID1)
          IGTYPE(IGRID)= IGTYPE(IGRID1)                                   30.52
          LEDS(IGRID)  = 1
        ENDIF
  80  CONTINUE
*
 100  RETURN
*     end of subroutine SINPGR
      END
************************************************************************
*                                                                      *
      SUBROUTINE SREDEP (POOL, LWINDR, LWINDM ,LOGCOM, RPOOL)             40.02
*                                                                      *
************************************************************************
C
      INCLUDE 'timecomm.inc'                                              30.74
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
!MCEL+ J Dykes 30 Dec 2002 SREDEP: includes
      include 'MCEL.inc'
      include 'mcel_swan.inc'
!MCEL-
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.74: IJsbrand Haagsma (Include version)
C     34.01: Jeroen Adema
C     40.02: IJsbrand Haagsma
C     40.04: Annette Kieftenburg
C
C  1. Updates
C
C     20.05, Jan. 94: new pool
C     20.67, Dec. 95: call of REPARM is modified, VFAC is read in SREDEP itself
C     30.72, Nov. 97: Changed position of label 18 in block IF, as suggested by
C                     Richard Gorman
C     30.74, Nov. 97: Prepared for version with INCLUDE statements
C     40.00, Jan. 98: calls of REPARM and INAR2D changed
C     34.01, Feb. 99: Introducing STPNOW
C     40.02, Oct. 00: Avoided real/int conflict by introducing RPOOL
C
C  2. Purpose
C
C     Reading of depths and/or currents
C
C  3. Method
C
C     ---
C
C  4. Argument variables
C
C     POOL
C     LWINDR
C     LWINDM
C     LOGCOM
C     RPOOL : Real equivalence of POOL-array
C
      REAL, INTENT(INOUT) :: RPOOL(*)
C
C  8. Subroutines used
C
C     INAR2D
C     INKEYW
C     KEYWIS
C     MSGERR
C     OTAR2D
C     REPARM (all Ocean Pack)
C
      LOGICAL STPNOW                                                      34.01
C
C  9. Subroutines calling
C
C     SWREAD
C
C 10. Error messages
C
C     ---
C
C 11. Remarks
C
C     NDS   = unit reference number
C     DFORM = format string
C     VFAC  = multiplication factor for data to be read
C     DESCR = string used in heading of datafile
C
C 12. Structure
C
C     ----------------------------------------------------------------
C     Call INKEYW to read keyword from user input
C     If bottom must be read (command BOT), then
C         If no current is read (LEDS < 2), then
C             LEDS = 1 (indicating INP BOT command has been given)        40.04
C             LEDS = 2 (indicating bottom is read)                        40.04
C         Else
C             LEDS = 3 (indicating bottom and current are read)
C         ------------------------------------------------------------
C         Call REPARM to process the rest of the command
C         If depthfile is standard Ocean Pack file (IDLA > 100), then
C             Call OTAR2D to read bottom levels into array IDEB
C         Else
C             Call INAR2D to read bottom levels inyo array IDEB
C         ------------------------------------------------------------
C     Elseif current must be read (command CUR), then
C         Switch for current is on (ICUR = 1)
C         If no current is read (LEDS < 2), then
C             LEDS = LEDS + 2 (indicating current is read)
C         ------------------------------------------------------------
C         Call REPARM to read filename and file organisation
C         If depthfile is standard Ocean Pack file (IDLA > 100), then
C             Call OTAR2D to read current components into arrays IUXB
C               and IUYB
C         Else
C             Call INAR2D to read current components into arrays IUXB
C               and IUYB
C         ------------------------------------------------------------
C     Else
C         Call MSGERR to generate an error message
C     ----------------------------------------------------------------
C
C 13. Source text
C
      INTEGER    POOL(*)
      CHARACTER  VNAM1 *4, VNAM2 *4
      LOGICAL    KEYWIS, VECTOR, LOGT                                     30.00
      LOGICAL    LOGCOM(6)                                                30.21
      SAVE  IENT
      DATA  IENT/0/
      CALL STRACE (IENT,'SREDEP')
*
*     ***** read instructions of the user *****
      CALL INKEYW ('REQ',' ')
      IGR2 = 0
      IF (KEYWIS ('BOT')) THEN
        IGR1   = 1
        VNAM1  = 'DEB'
        LOGCOM(3) =.TRUE.                                                 30.21
        IF (JDP2.EQ.0) THEN
          MCMVAR = MCMVAR + 1                                             20.39
          JDP2   = MCMVAR
        ENDIF
      ELSE IF (KEYWIS ('CUR')) THEN
        IGR1  = 2
        IGR2  = 3
        VNAM1  = 'UXB'
        VNAM2  = 'UYB'
        ICUR   = 1
        IF (JVX2.EQ.0) THEN
          MCMVAR = MCMVAR + 2                                             20.39
          JVX2   = MCMVAR - 1
          JVY2   = MCMVAR
        ENDIF
*       Blocking is switched on too   (not yet activated)
*        IBLK   = 1
      ELSE IF (KEYWIS ('FR')) THEN
        IGR1   = 4
        VNAM1  = 'FRI'
        VARFR  = .TRUE.
        MCMVAR = MCMVAR + 2                                               40.00
        JFRC2  = MCMVAR - 1                                               40.00
        JFRC3  = MCMVAR                                                   40.00
      ELSE IF (KEYWIS ('WI')) THEN
        LWINDR = 2                                                        30.10
        IWIND  = LWINDM                                                   30.10
        IGR1   = 5
        IGR2   = 6
        VNAM1  = 'WXI'
        VNAM2  = 'WYI'
        VARWI  = .TRUE.
        IF (JWX2.LE.1) THEN                                               40.00
          MCMVAR = MCMVAR + 2                                             20.39
          JWX2   = MCMVAR - 1
          JWY2   = MCMVAR
        ENDIF
        IF (JWX3.LE.1) THEN                                               40.00
          MCMVAR = MCMVAR + 2                                             40.00
          JWX3   = MCMVAR - 1                                             40.00
          JWY3   = MCMVAR                                                 40.00
        ENDIF                                                             40.00
      ELSE IF (KEYWIS ('WL')) THEN                                        20.38
        IGR1   = 7
        VNAM1  = 'WLEV'
        VARWLV = .TRUE.                                                   20.38
        IF (JWLV2.LE.1) THEN                                              40.00
          MCMVAR = MCMVAR + 2                                             40.00
          JWLV2  = MCMVAR - 1                                             40.00
          JWLV3  = MCMVAR                                                 40.00
        ENDIF                                                             40.00
      ELSE IF (KEYWIS ('COOR')) THEN                                      30.21
        IGR1   = 8                                                        30.21
        IGR2   = 9                                                        30.21
        VNAM1  = 'COOX'                                                   30.21
        VNAM2  = 'COOY'                                                   30.21
        LOGCOM(4) = .TRUE.                                                30.21
        IF (JCOOX.EQ.0) THEN
          MCMVAR = MCMVAR + 2                                             20.39
          JCOOX  = MCMVAR - 1
          JCOOY  = MCMVAR
        ENDIF
*       *** Next lines because there is no information for READ COORD  ***
*       *** command INPGRID was not used to read coordinates           ***
        MXG(IGR1) = MXC
        MYG(IGR1) = MYC
        MXG(IGR2) = MXC
        MYG(IGR2) = MYC
      ELSE IF (KEYWIS ('ASTD')) THEN                                      40.03
*       air-sea temperature difference
        IGR1   = 10
        VNAM1  = 'ASTD'
        VARAST = .TRUE.                                                   40.03
        IF (JASTD2.LE.1) THEN                                             40.03
          MCMVAR = MCMVAR + 2                                             40.03
          JASTD2 = MCMVAR - 1                                             40.03
          JASTD3 = MCMVAR                                                 40.03
        ENDIF                                                             40.03
      ELSE
        CALL  WRNKEY
      ENDIF
*
*     read multiplication factor
*
      CALL INREAL ('FAC', IFLFAC(IGR1), 'STA', 1.)
C
      IF (IFLDYN(IGR1).GT.0) LOGT = .TRUE.
      IF (IGR2.GT.0) THEN
        VECTOR = .TRUE.
        IFLFAC(IGR2) = IFLFAC(IGR1)
      ELSE
        VECTOR = .FALSE.
      ENDIF
C
      CALL REPARM (IFLNDF(IGR1), IFLNDS(IGR1), IFLIDL(IGR1),              40.00
     &             IFLIFM(IGR1), IFLFRM(IGR1), IFLNHF(IGR1), LOGT,        40.00
     &             IFLNHD(IGR1), VECTOR, NHEDC)                           40.00
      IF (STPNOW()) RETURN                                                34.01
C
      IF (ITEST.GE.60) WRITE (PRTEST, 35) IGR1, IFLNDF(IGR1),
     &    IFLNDS(IGR1), IFLIDL(IGR1), IFLIFM(IGR1), IFLFRM(IGR1),         40.00
     &    IFLNHF(IGR1), LOGT, IFLNHD(IGR1), VECTOR, NHEDC
  35  FORMAT (' Reading parameters: ', 5I4, A, /, 12X,I5,L2,I5,L2,I5)     40.00
C
      IFLNHD(IGR1) = IFLNHD(IGR1) + NHEDC
      IF (IGR2.GT.0) THEN
        IFLNDF(IGR2) = IFLNDF(IGR1)
        IFLNDS(IGR2) = IFLNDS(IGR1)
        IFLIDL(IGR2) = IFLIDL(IGR1)
        IFLIFM(IGR2) = IFLIFM(IGR1)
        IFLFRM(IGR2) = IFLFRM(IGR1)
        IFLNHF(IGR2) = IFLNHF(IGR1)
        IFLNHD(IGR2) = NHEDC
      ENDIF
C
      IF (LEDS(IGR1).EQ.0 .AND. IGR1 .NE. 8) THEN                         30.21
         CALL MSGERR (2, 'Input grid not given')
         RETURN
      ENDIF
      IERR = 0
      CALL DPADDP (POOL, VNAM1, INDX, 'S', IAR1, IERR)
      IF (STPNOW()) RETURN                                                34.01
      IERR = 0
      CALL DPEXPR (POOL, INDX, MXG(IGR1)*MYG(IGR1), IAR1, IERR)
      IF (STPNOW()) RETURN                                                34.01
!MCEL+ J Dykes 30 Dec 2002 SREDEP: call mcel_get
      if (mcel_get_tag(IGR1) == 1) then
         call mcel_get (RPOOL(IAR1+1), MXG(IGR1), MYG(IGR1), 
     &      IFLTIM(IGR1), mcel_get_name(IGR1), IGR1)
      else
!MCEL-
         CALL INAR2D(RPOOL(IAR1+1), MXG(IGR1), MYG(IGR1), IFLNDF(IGR1),      40.02
     &                IFLNDS(IGR1), IFLIFM(IGR1), IFLFRM(IGR1),
     &                IFLIDL(IGR1), IFLFAC(IGR1),
     &                IFLNHD(IGR1), IFLNHF(IGR1))
!MCEL
      end if
!MCEL-
      IF (STPNOW()) RETURN                                                34.01
      IF (IGR2.GT.0) THEN
        IERR = 0
        CALL DPADDP (POOL, VNAM2, INDX, 'S', IAR2, IERR)                  20.04
        IF (STPNOW()) RETURN                                              34.01
        IERR = 0
        CALL DPEXPR (POOL, INDX, MXG(IGR2)*MYG(IGR2), IAR2, IERR)         20.79
        IF (STPNOW()) RETURN                                              34.01
!MCEL+ J Dykes 30 Dec 2002 SREDEP: call mcel_get
        if (mcel_get_tag(IGR2) == 1) then
          call mcel_get (RPOOL(IAR2+1), MXG(IGR2), MYG(IGR2), 
     &         IFLTIM(IGR2), mcel_get_name(IGR2), IGR1)
        else
!MCEL-
          CALL INAR2D(RPOOL(IAR2+1), MXG(IGR2), MYG(IGR2), IFLNDF(IGR2),    40.02
     &         IFLNDS(IGR2), IFLIFM(IGR2), IFLFRM(IGR2),
     &         IFLIDL(IGR2), IFLFAC(IGR2),
     &         IFLNHD(IGR2), 0)
        endif
        IF (STPNOW()) RETURN                                              34.01
      ENDIF
C     set time of reading
      IF (IFLDYN(IGR1) .EQ. 1) THEN
        IF (NSTATM.EQ.0) CALL MSGERR (2,                                  40.00
     &        'nonstationary input field requires MODE NONSTAT')          40.00
        IFLTIM(IGR1) = IFLBEG(IGR1)
        IF (IGR2.GT.0) IFLTIM(IGR2) = IFLTIM(IGR1)
      ENDIF
C
      LEDS(IGR1) = 2
      IF (VECTOR) LEDS(IGR2) = 2
C
      RETURN
C * end of subroutine SREDEP *
      END
C***********************************************************************
C                                                                      *
      SUBROUTINE SSFILL (SPCSIG, SPCDIR)                                  30.72
C                                                                      *
C***********************************************************************
C
      USE M_WCAP                                                          40.02
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     40.02: IJsbrand Haagsma
C
C  1. Updates
C
C     20.43         : Calculation of spectral directions added
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of SPCDIR
C     40.02, Sep. 00: Calculate powers of Sigma for later use
C
C  2. Purpose
C
C     Discretisation in frequency (sigma) and direction (theta)
C
C  3. Method
C
C     Create a logharitmic distribution in frequency between lowest and highest
C     frequencies and store them in the array SPCSIG.
C
C     Create a distribution in direction that does not coincide with the orientation
C     of the computaitional grid, calculate some geometric derivatives and store
C     it in the array SPCDIR
C
C  4. Argument variables
C
C   o SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C   o SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
*
*
*  5. SUBROUTINES CALLING
*
*       none
*
*  6. SUBROUTINES USED
*
*       none
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       ---
*
* 10. SOURCE TEXT
C
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SSFILL')
C
C     Allocate arrays in module M_WCAP                                    40.02
C
      IF (.NOT.ALLOCATED(SPCSIG_f90)) ALLOCATE (SPCSIG_f90(MSC,6))        40.02
C
*
*     distribution of spectral frequencies
*
*     FRINTF is the frequency integration factor (=df/f)                  20.35
      FRINTF = ALOG(SHIG/SLOW) / FLOAT(MSC-1)                             20.35
      SFAC   = EXP(FRINTF)                                                20.35
      FRINTH = SQRT(SFAC)
*     determine spectral frequencies (logarithmic distribution)
      SPCSIG(1) = SLOW                                                    30.72
      DO 10 IS = 2, MSC
         SPCSIG(IS) = SPCSIG(IS-1) * SFAC                                 30.72
  10  CONTINUE
C
C     Calculate powers of sigma and store in global array
C
      SPCSIG_f90(:,1) = SPCSIG                                            40.02
      SPCSIG_f90(:,2) = SPCSIG**2                                         40.02
      SPCSIG_f90(:,3) = SPCSIG * SPCSIG_f90(:,2)                          40.02
      SPCSIG_f90(:,4) = SPCSIG * SPCSIG_f90(:,3)                          40.02
      SPCSIG_f90(:,5) = SPCSIG * SPCSIG_f90(:,4)                          40.02
      SPCSIG_f90(:,6) = SPCSIG * SPCSIG_f90(:,5)                          40.02
*
*     distribution of spectral directions
*
      DO 20 ID = 1, MDC
         SPCDIR(ID,1) = SPDIR1 + FLOAT(ID-1)*DDIR                         20.43
*        if a direction coincides with a direction of the (regular)       40.00
*        computational grid it is slightly changed
         IF (OPTG.EQ.1) THEN                                              40.00
           IF (ABS(MODULO(SPCDIR(ID,1)-ALPC+0.25*PI ,0.5*PI)-0.25*PI)     40.03
     &         .LT. 1.E-6) THEN
             OLDDIR = SPCDIR(ID,1)
             SPCDIR(ID,1) = OLDDIR + 2.E-6                                40.03
             IF (ITEST.GE.50) WRITE (PRINTF, 24) ID,
     &                      OLDDIR*180./PI, SPCDIR(ID,1)*180./PI          40.03
  24         FORMAT (' Modified spectral direction', I4, 2(2X,F10.5))     40.03
           ENDIF
         ENDIF                                                            40.00
         SPCDIR(ID,2) = COS(SPCDIR(ID,1))                                 20.43
         SPCDIR(ID,3) = SIN(SPCDIR(ID,1))                                 20.43
         SPCDIR(ID,4) = SPCDIR(ID,2) **2                                  20.43
         SPCDIR(ID,5) = SPCDIR(ID,2) * SPCDIR(ID,3)                       20.43
         SPCDIR(ID,6) = SPCDIR(ID,3) **2                                  20.43
  20  CONTINUE
*
      RETURN
* * end of function SSFILL *
      END
************************************************************************
*                                                                      *
      SUBROUTINE CGINIT (POOL, RPOOL, LOGCOM)                             30.90
*                                                                      *
************************************************************************
C
C     Include common storage for action densities                         NRL
      USE M_ACDEN                                                         NRL
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.81: Annette Kieftenburg
C     30.90: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     40.00: Nico Booij
C     40.02: IJsbrand Haagsma
C     40.04: Annette Kieftenburg
C
*  1. Updates
*
C     40.00, June 98: new subroutine replacing code inside SWREAD
C     30.90, Oct. 98: Introduced EQUIVALENCE POOL-arrays
C     30.81, Nov. 98: Adjustment for 1-D case of new boundary conditions
C     34.01, Feb. 99: Introducing STPNOW
C     40.04, Aug. 00: adjusted argumentlist of CGBOUN
C     40.02, Oct. 00: Avoided real/int conflict by introducing replacing
C                     RPOOL for POOL in DPPUTR
C
*  2. PURPOSE
*
*     Initialise arrays for descritpion of computational grid
*
*  3. METHOD
*
*
*  4. Argument variables
*
*     POOL  : i/o    dynamic data pool
C
      INTEGER POOL(*)
C
C     RPOOL : i/o    dynamic data pool
C
      REAL    RPOOL(*)
C                                                                         30.90
C     LOGCOM:
C
      LOGICAL LOGCOM(6)
*
*  5. SUBROUTINES CALLING
*
*       SWREAD
*
*  6. SUBROUTINES USED
*
*       dynamic pool management routine from Ocean Pack
*
      LOGICAL STPNOW                                                      34.01
C
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       -----------------------------------------------------------------
*
* 10. SOURCE TEXT
*
      INTEGER     IERR
      REAL       :: YSCALE = 1. ! length scale                            33.09
      REAL, SAVE :: COSYPS = 1. ! cos of latitude (1 for Cartesian coord.)33.09
      CHARACTER   PNAME *8, PTYPE
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'CGINIT')
*
*     __________________________________________________________________
*     *** Calculation of computational grid dimension ***
*     *** 'COOX' AND 'COOY' ARE POINTERS TO ARRAYS THAT CONTAINS ***
*     *** THE X AND Y COORDINATES OF COMPUTATIONAL GRID POINTS   ***
      IERR = 0
      CALL DPINQP (POOL, 'COOX', JCOOX, PTYPE, ICOOX,LENREC,IERR)
      CALL DPINQP (POOL, 'COOY', JCOOY, PTYPE, ICOOY,LENREC,IERR)
*
*     *** 'ADDRS' is a pointer to array that contains the    ***
*     *** indirect adressing for computational grid points   ***
      PNAME = 'ADDRS'
      CALL DPINQP (POOL, PNAME, JADDRS, PTYPE, IADDRS,LENREC,IERR)
*
      IERR = 0
      CALL DPINQP (POOL, 'DEB', JDEB, PTYPE, IDEB, LENR, IERR)
*
C
C      POOL(IADRS(POOL,JADDRS)) ---> KGRPNT
C     RPOOL(IADRS(POOL,JDEB)) -----> DEPTH
C     RPOOL(IADRS(POOL,JCOOX)) ----> XCGRID
C     RPOOL(IADRS(POOL,JCOOY)) ----> YCGRID
C      POOL(IADRS(POOL,JXYTST) ----> XYTST
C
      CALL SWDIM ( POOL(IADRS(POOL,JADDRS)),RPOOL(IADRS(POOL,JDEB)) ,     30.90
     &            RPOOL(IADRS(POOL,JCOOX)) ,RPOOL(IADRS(POOL,JCOOY)),     30.90
     &             POOL(IADRS(POOL,JXYTST))                         )     30.60
*
*     call CGBOUN to determine computational grid outline
*
      IF (ONED) THEN                                                      30.81
        CALL DPEXPR (POOL, JGRBND, 4, IAUX, IERR)                         30.81
        IF (STPNOW()) RETURN                                              34.01
        CALL CGBOUN (POOL(IADRS(POOL,JADDRS)), POOL(IADRS(POOL,JGRBND)))  40.04
      ELSE                                                                30.81
        CALL DPEXPR (POOL, JAUX(1), MCGRD, IAUX, IERR)                    40.00
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JGRBND, 2*MCGRD, IAUX, IERR)                   40.00
        IF (STPNOW()) RETURN                                              34.01
        CALL CGBOUN (POOL(IADRS(POOL,JADDRS)), POOL(IADRS(POOL,JGRBND)))  40.04
        CALL DPEXPR (POOL, JAUX(1), 0, IAUX, IERR)                        40.00
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL, JGRBND, 2*NGRBND, IAUX, IERR)                  40.00
        IF (STPNOW()) RETURN                                              34.01
      END IF                                                              30.81
 
*
*     *** enlarge the pool to contain action densities ***
      IF (ALLOCATED(AC2)) DEALLOCATE(AC2)                                 NRL
      ALLOCATE(AC2(MDC,MSC,MCGRD))                                        NRL
      AC2=0.                                                              NRL
      LOGCOM(6) = .TRUE.
*
*     *** the computational grid is included in output data  ***
      IF ((MXC.GT.0) .AND. (MYC.GT.0) ) THEN                              30.21
        COSPC = COS(ALPC)
        SINPC = SIN(ALPC)
        IERR = 0
        PNAME = 'OUTDA'
        CALL DPINQP (POOL, PNAME, INDX, PTYPE, IOUTD, LENREC,
     &               IERR)
        PNAME = 'PSET'
        CALL DPINQP (POOL(IOUTD), PNAME, INDX, PTYPE, IOUTPS,
     &               LENREC, IERR)
        CALL DPEXPR (POOL(IOUTD), INDX, LENREC+20, IOUTPS, IERR)
        IF (STPNOW()) RETURN                                              34.01
        IREC = 0
        CALL DPADDP (POOL(IOUTD+IOUTPS-1), 'COMPGRID', IREC,
     &               'S', INX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        CALL DPEXPR (POOL(IOUTD+IOUTPS-1), IREC, 10, INX, IERR)
        IF (STPNOW()) RETURN                                              34.01
        ILOCR = IOUTD+IOUTPS+INX-2
*
        IF (OPTG .EQ. 1) THEN
          POOL(ILOCR+1) = ICHAR('F')
          CALL DPPUTR (RPOOL, ILOCR+2, XCLEN)
          CALL DPPUTR (RPOOL, ILOCR+3, YCLEN)
          CALL DPPUTR (RPOOL, ILOCR+4, XPC)
          CALL DPPUTR (RPOOL, ILOCR+5, YPC)
          CALL DPPUTR (RPOOL, ILOCR+6, ALPC)
        ELSE
          POOL(ILOCR+1) = ICHAR('H')
          CALL DPPUTR (RPOOL, ILOCR+2, FLOAT(MXC-1))
          CALL DPPUTR (RPOOL, ILOCR+3, FLOAT(MYC-1))
          XMIN = 0.
          YMIN = 0.
          CALL DPPUTR (RPOOL, ILOCR+4, XMIN)
          CALL DPPUTR (RPOOL, ILOCR+5, YMIN)
          CALL DPPUTR (RPOOL, ILOCR+6, ALPC)
        ENDIF
        POOL(ILOCR+7) = MXC
        POOL(ILOCR+8) = MYC
        IF (PROJ_METHOD.EQ.1) THEN                                        33.09
          COSYPS = COS(DEGRAD*(YOFFS+YPC+0.5*YCLEN))                      33.09
        ENDIF
        IF (ONED) THEN
          YSCALE = XASM/XCLEN                                             40.00
        ELSE
          YSCALE = MIN (XASM/(XCLEN*COSYPS), YASM/YCLEN)                  33.09
        ENDIF
        CALL DPPUTR (RPOOL, ILOCR+ 9, COSYPS*YSCALE*XCLEN)                40.02
        CALL DPPUTR (RPOOL, ILOCR+10, YSCALE*YCLEN)                       40.02
      ENDIF
      RETURN
*     end of subroutine CGINIT
      END
************************************************************************
*                                                                      *
      SUBROUTINE SWDIM (KGRPNT   ,DEPTH       ,                           40.00
     &                  XCGRID   ,YCGRID   ,XYTST    )                    30.72
*                                                                      *
************************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
*
*  0. Authors
*
*     30.60: Nico Booij
*     30.72: IJsbrand Haagsma
*
*  1. Updates
*
*     30.60, July 97: exception values for coordinates are introduced
*                     subroutine restructured
*     30.60, Aug. 97: correction KGRPNT
*     30.60, Aug. 97: test point introduced
*     30.72, Sept 97: INTEGER*4 replaced by INTEGER
C     30.72, Sept 97: Changed DO-block with one CONTINUE to DO-block with
C                     two CONTINUE's
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     40.03, Dec. 99: computation of XCGMIN, XCGMAX, YCGMIN, YCGMAX is now done
C                     for curvilinear and regular grids.
*
*  2. Purpose
C
C     ---
*
*  3. Method
*
*     The depths and currents are computed by bilinear interpolation
*     and usually written to file INSTR.
*
C  4. Argument variables
C
C     XCGRID: input  Coordinates of computational grid in x-direction     30.72
C     YCGRID: input  Coordinates of computational grid in y-direction     30.72
C
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
*
*  5. SUBROUTINES CALLING
*
*       SWREAD
*
*  6. SUBROUTINES USED
*
*       ADPOOL (Ocean Pack), SVALQI (SWAN/SER)
*
*  7. ERROR MESSAGES
*
*       ---
*
*  8. REMARKS
*
*       ---
*
*  9. STRUCTURE
*
*       -----------------------------------------------------------------
*       For all potential grid points do
*           Make grid address =1 (means invalid grid address)
*           Determine whether this point is a test point                  30.60
*           If coordinates are valid
*           Then If grid offset is not yet defined (LXOFFS = False)
*                Then make grid offset equal to coordinates of this point
*                     Make LXOFFS = True
*                Else Subtract offset from coordinates
*                --------------------------------------------------------
*                If bottom level is not an exception value
*                Then assign a valid grid adress to this grid point
*                     increase MCGRD by 1
*       -----------------------------------------------------------------
*
* 10. SOURCE TEXT
C
      INTEGER     XYTST(*)                                                40.00
      INTEGER     KGRPNT(MXC,MYC)
      REAL        DEPTH(*)                                                40.00
      LOGICAL     EQREAL                                                  40.00
      SAVE IENT
      DATA IENT/0/
      CALL STRACE(IENT,'SWDIM')
*
*
      DO 62 IX = 1, MXC                                                   30.72
        DO 61 IY = 1, MYC
*         at start make each grid point invalid
          KGRPNT(IX,IY) = 1
*         determine whether a test point is treated                       30.60
          TESTFL = .FALSE.
          IF (NPTST.GT.0) THEN
            DO II = 1, NPTST
              IF (IX.EQ.XYTST(2*II-1) .AND.
     &            IY.EQ.XYTST(2*II)  ) TESTFL = .TRUE.                    30.60
            ENDDO
          ENDIF
C
C         If coordinates are valid (excluding exception values)           30.60
C         Then If grid offset is not yet defined (LXOFFS = False)
C              Then make grid offset equal to coordinates of this point
C                   Make LXOFFS = True
C              Else Subtract offset from coordinates
C
          IF (EQREAL(XCGRID(IX,IY), EXCFLD(8))) THEN                      40.00
            IF (.NOT. EQREAL(YCGRID(IX,IY), EXCFLD(9))) THEN              40.00
              CALL MSGERR (2, 'incorrect grid coordinates')
              WRITE (PRINTF, 811) XCGRID(IX,IY), YCGRID(IX,IY)            30.72
 811          FORMAT (' X= ', E12.4, '  Y= ', E12.4)
            ENDIF
          ELSE
            IF (EQREAL(YCGRID(IX,IY), EXCFLD(9))) THEN                    40.00
              CALL MSGERR (2, 'incorrect grid coordinates')
              WRITE (PRINTF, 811) XCGRID(IX,IY), YCGRID(IX,IY)            30.72
            ELSE
              IF (OPTG.EQ.3) THEN                                         30.60
                IF (.NOT. LXOFFS) THEN
                  XOFFS  = XCGRID(IX,IY)                                  30.72
                  YOFFS  = YCGRID(IX,IY)                                  30.72
                  LXOFFS = .TRUE.
                  XCGRID(IX,IY) = 0.
                  YCGRID(IX,IY) = 0.
                ELSE
                  XCGRID(IX,IY) = REAL(XCGRID(IX,IY) - DBLE(XOFFS))       30.72
                  YCGRID(IX,IY) = REAL(YCGRID(IX,IY) - DBLE(YOFFS))       30.72
                ENDIF
              ENDIF
              XP = XCGRID(IX,IY)                                          30.72
              YP = YCGRID(IX,IY)                                          30.72
C               ***** compute bottom level *****
C
              DEP = SVALQI (XP, YP, 1, DEPTH, 1 ,IX ,IY)                  40.00
C
C             If bottom level is not an exception value
C             Then assign a valid grid adress to this grid point
C                  increase MCGRD by 1
              IF (.NOT. EQREAL(DEP, EXCFLD(1))) THEN                      40.00
                MCGRD = MCGRD + 1                                         30.60
                KGRPNT(IX,IY) = MCGRD                                     30.60
              ENDIF
              IF (TESTFL .OR. ITEST .GE. 250 .OR. INTES .GE. 30)          30.60
     &          WRITE (PRINTF,30) IX, IY, XP, YP,
     &                    DEP, KGRPNT(IX,IY)                              30.60
  30          FORMAT(2(I3,1X),1X,3(F10.1,1X),5X,I5)
            ENDIF
          ENDIF                                                           30.60
  61    CONTINUE                                                          30.72
  62  CONTINUE                                                            30.72
C
      IF (MCGRD.LE.1) CALL MSGERR (3, 'No valid grid points found')       30.60
      IF (ITEST.GE.60) WRITE(PRINTF,*)
     &    ' Offset values in SWDIM:', XOFFS, YOFFS,                       30.60
     &    ' ; ', MCGRD-1, ' grid points'                                  30.60
C
*     check geometric validity of the grid (all meshes must have same
*     orientation when going around the mesh)
      CALL CVCHEK (KGRPNT, XCGRID, YCGRID)                                30.72
C
*     *** Computation of XCGMIN, XCGMAX, YCGMIN, YCGMAX ***               40.03
      XCGMIN =  1.E09                                                     40.00
      YCGMIN =  1.E09
      XCGMAX = -1.E09
      YCGMAX = -1.E09
      DO 60 IX = 1, MXC
        DO 59 IY = 1, MYC                                                 30.72
          IF (KGRPNT(IX,IY) .GT. 1) THEN
            IF (XCGRID(IX,IY) .LT. XCGMIN) XCGMIN = XCGRID(IX,IY)         40.00
            IF (YCGRID(IX,IY) .LT. YCGMIN) YCGMIN = YCGRID(IX,IY)
            IF (XCGRID(IX,IY) .GT. XCGMAX) XCGMAX = XCGRID(IX,IY)
            IF (YCGRID(IX,IY) .GT. YCGMAX) YCGMAX = YCGRID(IX,IY)
          ENDIF
 59     CONTINUE                                                          30.72
 60   CONTINUE                                                            30.72
*     *** Computation of xclen and yclen in a curvilinear grid case ***
      IF (OPTG .NE. 1) THEN                                               40.03
        XCLEN = XCGMAX - XCGMIN
        YCLEN = YCGMAX - YCGMIN
      ENDIF
      IF (ITEST .GE. 100) THEN
        WRITE (PRINTF,*)' Min and Max X and Y from subr SWDIM',
     &         XCGMIN+XOFFS, XCGMAX+XOFFS, YCGMIN+YOFFS, YCGMAX+YOFFS     40.00
        WRITE (PRINTF,*)' Size in X and Y from subr SWDIM',
     &         XCLEN, YCLEN
      ENDIF
*
      RETURN
* * end of subroutine SWDIM *
      END
************************************************************************
*                                                                      *
      SUBROUTINE CGBOUN (KGRPNT, KGRBND)                                  40.04
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
      INCLUDE 'ocpcomm4.inc'
C
C  0. Authors
C
C     40.00, 40.03, 40.13  Nico Booij
C     30.81  Annette Kieftenburg
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C     New function for curvilinear version (ver. 40.00). May '98
C     30.81, Nov. 98: Adjustment for 1-D case of new boundary conditions
C     40.03, Dec. 99: 2d procedure modified; boundary can now consist also
C                     of diagonals
C     40.04, Aug. 00: prevented that boundary is not closed: several checks
C                     added
C                     argument list adjusted
C     40.13, July 01: 1-D procedure corrected
C
C  2. Purpose
C
C     Determine array containing all points of (a) (closed) boundary/boundaries
C     within the computational grid
C
C  3. Method (updated...)
C
C     1D: go through all gridpoints (ascending and descening) to check
C         for validity
C         save first and last point in boundary array
C     2D: For all grid points:
C         0) find first point which is possibly on the boundary
C         1) check whether neighbour is a valid point and valid boundary point
C            save information that point is scanned
C         2) If so store point in boundary array and repeat from 1
C            Else go to next neighbour (if not scanned allready
C                                       Else remove isolated point from
C                                            computational grid and start from 0)
C
C  4. Argument variables
C
C     KGRPNT    in-& output   indirect addresses for grid points
C     KGRBND    output        array containing all boundary points
C                             (+ 2 extra zeros as area seperator
C                             for all seperated areas)
C
      INTEGER KGRPNT(MXC,MYC), KGRBND(*)
C
C  5. Parameter variables
C
C  6. Local variables
C
C     ICGRD         Counter for computational gridcells
C     IDIR          Direction number 1 = to the right
C                                    2 = upwards
C                                    3 = to the left
C                                    4 = downwards
C     IENT          Number of entries of this subroutine
C     IXC, IYC      X- and Y-index of point under consideration
C     IXNEW, IYNEW  X- and Y-index of point under consideration
C     IXOLD, IYOLD  X- and Y-index of point under consideration
C     KGRPNTNEW     Indirect addresses for grid points
C     MCGRDNEW      Number of points in computational grid after elimination
C                   of isolated and points that are part of 1D configurations
C                   or connections
C     MCGRDOLD      Number of points in computational grid before elimination
C                   of isolated and points that are part of 1D configurations
C                   or connections
C     WNP           Number of Wet Neighbouring Points
C     LOOP          Counter
C     SCANND        Array containing information whether point is scanned
C
C
      INTEGER  ICGRD, IDIR, IENT, IXC, IXNEW, IXOLD
      INTEGER  IYC, IYNEW, IYOLD
      INTEGER  KGRPNTNEW(MXC,MYC), MCGRDNEW, MCGRDOLD, WNP                 40.04
     &         , LOOP, SCANND(MCGRD)
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     Function PVALID
C     Function VALIDBP
C     STRACE
C     SEPARAREA
C     MSGERR
C
      LOGICAL   PVALID, VALIDBP
C
C  9. Subroutines calling
C
C     CGINIT
C
C 10. Error messages
C
C 11. Remarks
C
C     In case of 2D:
C     A boundary is scanned only once: 1D areas or connections between
C     areas are excluded
C
C 12. Structure
C
C     -----------------------------------------------------------------
C     If 1D: For all gridpoints (ascending)
C            If gridpoint is valid store it's value in KGRBND(1)
C            Else give error message
C            For all gridpoints (descending)
C            If gridpoint is valid store it's value in KGRBND(3)
C            Else give error message
C     Number of boundary outline points is 2
C     -----------------------------------------------------------------
C     Else:
C     Make number of boundary outline points = 0
C     For all computational grid points do
C         make SCANNED(ix,iy) = False
C     Save MCGRD
C     -----------------------------------------------------------------
C     For all computational grid points do
C         If (ix,iy) is a valid grid point
C         Then If point (ix,iy) is no valid boundary point or
C                 point (ix,iy) has neighbouring points that are all
C                               invalid boundary points
C              Then remove this point from computational grid
C                   SCANND(ix,iy) = True
C         If (ix,iy) is not scanned
C              If point (ix-1,iy) is not a valid grid point and
C                 (ix,iy) is a valid boundary point
C              Then Make ixold=ix; iyold=iy
C                   Increase number of boundary outline points by 1
C                   Store (ixold,iyold)
C                   Make SCANNED(ixold,iyold) = True
C                   Make idir=4
C                   If number of Wet Neighbouring points = 3
C                   possibly two areas should be seperated
C                   Repeat
C                       Case idir=
C                       =1: Make ixnew=ixold+1; iynew=iyold
C                       =2: Make ixnew=ixold  ; iynew=iyold+1
C                       =3: Make ixnew=ixold-1; iynew=iyold
C                       =4: Make ixnew=ixold  ; iynew=iyold-1
C                       -----------------------------------------------
C                       If (ixnew,iynew) is a valid grid point and
C                          valid boundary point
C                       Then If SCANNED(ixnew,iynew)
C                            Then exit from repeat
C                            Else
C                              Increase number of boundary outline points by 1
C                              Store (ixnew,iynew) in KGRBND array
C                              Make SCANNED(ixnew,iynew) = True
C                              Make ixold=ixnew; iyold=iynew
C                              Make idir = idir-1
C                              If number of Wet Neighbouring points = 3
C                              possibly two areas should be seperated
C                              If idir=0
C                              Then Make idir=4
C                        Else Make idir = idir+1
C                          If (ixnew,iynew) is an invalid boundary point
C                             (ixnew,iynew) is a valid grid point
C                             remove point from computational grid
C                             SCANND(ixnew,iynew) = True
C                          If idir=5
C                          Then Make idir=1
C                   ---------------------------------------------------
C                   Increase number of boundary outline points by 1
C                   Store (0,0)      {separation between outlines}
C     -----------------------------------------------------------------
C     If MCGRD has changed
C     Then count number of valid gridpoints
C          store  indirect adressing number in new array
C       give MCGRD new value
C       write new information to old array
C     -----------------------------------------------------------------
C
C 13. Source text
C
      SAVE      IENT
      DATA      IENT /0/
      CALL STRACE (IENT,'CGBOUN')
C
      IF (ONED) THEN                                                      30.81
        KGRBND(1) = -1                                                    40.13 30.81
        KGRBND(2) = 1                                                     40.13 30.81
        DO IXC = 1, MXC                                                   30.81
          IF (KGRPNT(IXC,1).GT.1) THEN                                    30.81
            KGRBND(1) = IXC                                               30.81
            GOTO 81                                                       30.81
          END IF                                                          30.81
  81    ENDDO                                                             30.81
        IF (KGRBND(1) .LT. 0) THEN                                        40.13 30.81
          CALL MSGERR(3,'No valid gridpoint defined')                     40.13 30.81
        END IF                                                            40.13 30.81
        KGRBND(3) = -1                                                    40.13 30.81
        KGRBND(4) = 1                                                     40.13 30.81
        DO IXC = MXC, 1, -1                                               30.81
          IF (KGRPNT(IXC,1).GT.1) THEN                                    30.81
            KGRBND(3) = IXC                                               30.81
            GOTO 91                                                       30.81
          END IF                                                          30.81
  91    ENDDO                                                             30.81
        NGRBND = 2                                                        30.81
      ELSE                                                                30.81
        NGRBND = 0
        DO ICGRD = 1, MCGRD
          SCANND(ICGRD) = 0
        ENDDO
        MCGRDOLD = MCGRD                                                  40.04
        DO 90 IXC = 1, MXC
          DO 80 IYC = 1, MYC
            ICGRD = KGRPNT(IXC,IYC)
            IF (ICGRD.GT.1) THEN
C               point with four wet neighbouring points which are all     40.04
C               no valid boundary points is eliminated.                   40.04
                IF ((.NOT. VALIDBP(IXC,IYC,KGRPNT,WNP)).OR.               40.04
     &             ((.NOT. VALIDBP(IXC-1,IYC,KGRPNT,WNP)).AND.            40.04
     &              (.NOT. VALIDBP(IXC+1,IYC,KGRPNT,WNP)).AND.            40.04
     &              (.NOT. VALIDBP(IXC,IYC-1,KGRPNT,WNP)).AND.            40.04
     &              (.NOT. VALIDBP(IXC,IYC+1,KGRPNT,WNP)))) THEN          40.04
                   KGRPNT(IXC,IYC) = 1                                    40.04
                   MCGRD = MCGRD - 1                                      40.04
                   SCANND(ICGRD) = 1                                      40.04
                   CALL MSGERR (1,                                        40.04
     &                          'Point removed from computational grid')  40.04
                   WRITE(PRINTF,17)  IXC, IYC                             40.04
  17               FORMAT ('Point with index (', I6, ',', I6,') was ',    40.04
     &                     'removed from computational grid, because ',   40.04
     &                     'it is part of a 1D configuration or 1D ',     40.04
     &                     'connection.')                                 40.04
                 ENDIF                                                    40.04
              IF (SCANND(ICGRD).EQ.0) THEN
                IF (.NOT. PVALID(IXC-1,IYC,KGRPNT).AND.                   40.04
     &               VALIDBP(IXC,IYC,KGRPNT,WNP)) THEN                    40.04
                  IXOLD = IXC
                  IYOLD = IYC
                  NGRBND = NGRBND + 1
                  KGRBND(2*NGRBND-1) = IXOLD
                  KGRBND(2*NGRBND)   = IYOLD
                  SCANND(KGRPNT(IXOLD,IYOLD)) = 1
                  IDIR = 4                                                40.04
                  IF (WNP.EQ.3) THEN                                      40.04
                    CALL SEPARAREA(IXNEW, IYNEW, KGRPNT,IDIR)             40.04
                  ENDIF                                                   40.04
                  DO LOOP = 1, 9999
                    IF (IDIR.EQ.1) THEN                                   40.04
                      IXNEW = IXOLD + 1                                   40.04
                      IYNEW = IYOLD                                       40.04
                    ELSE IF (IDIR.EQ.2) THEN                              40.04
                      IXNEW = IXOLD                                       40.04
                      IYNEW = IYOLD + 1                                   40.04
                    ELSE IF (IDIR.EQ.3) THEN                              40.04
                      IXNEW = IXOLD - 1                                   40.04
                      IYNEW = IYOLD                                       40.04
                    ELSE IF (IDIR.EQ.4) THEN                              40.04
                      IXNEW = IXOLD                                       40.04
                      IYNEW = IYOLD - 1                                   40.04
                    ENDIF                                                 40.04
                    IF (PVALID(IXNEW,IYNEW,KGRPNT) .AND.                  40.04
     &                  VALIDBP(IXNEW,IYNEW,KGRPNT,WNP) ) THEN            40.04
                      IF (SCANND(KGRPNT(IXNEW,IYNEW)) .GE. 1) GOTO 70
                      NGRBND = NGRBND + 1                                 40.04
                      KGRBND(2*NGRBND-1) = IXNEW                          40.04
                      KGRBND(2*NGRBND)   = IYNEW                          40.04
                      SCANND(KGRPNT(IXNEW,IYNEW)) = 1
                      IXOLD = IXNEW
                      IYOLD = IYNEW
                      IDIR  = IDIR - 1
                      IF (WNP.EQ.3) THEN                                  40.04
                        CALL SEPARAREA(IXNEW, IYNEW, KGRPNT,IDIR)         40.04
                      ENDIF                                               40.04
                      IF (IDIR.EQ.0) IDIR = 4                             40.04
                    ELSE
                      IDIR  = IDIR + 1
                      IF (.NOT. VALIDBP(IXNEW,IYNEW,KGRPNT,WNP).AND.      40.04
     &                    PVALID(IXNEW,IYNEW,KGRPNT)) THEN                40.04
                        KGRPNT(IXNEW,IYNEW) = 1                           40.04
                        MCGRD = MCGRD - 1                                 40.04
                        CALL MSGERR (1,                                   40.04
     &                          'Point removed from computational grid')  40.04
                        WRITE(PRINTF,18) IXNEW, IYNEW                     40.04
  18                    FORMAT ('Point with index (', I6 ,',',  I6,') ',  40.04
     &                          'was removed from computational grid ',   40.04
     &                          'because it is an isolated wet point ',   40.04
     &                          'or is part of a 1D configuration or ',   40.04
     &                          '1D connection.')                         40.04
                        SCANND(KGRPNT(IXNEW,IYNEW)) = 1                   40.04
                      END IF                                              40.04
                      IF (IDIR.EQ.5) IDIR = 1                             40.04
                    ENDIF
                  ENDDO
C                 the following indicates that curve is closed            40.04
  70              NGRBND = NGRBND + 1
                  KGRBND(2*NGRBND-1) = 0
                  KGRBND(2*NGRBND)   = 0
                ENDIF
              ENDIF
            ENDIF
  80      ENDDO
  90    ENDDO
        IF (MCGRD.NE. MCGRDOLD) THEN                                      40.04
          MCGRDNEW = 1                                                    40.04
          DO IXC = 1, MXC                                                 40.04
            DO IYC = 1, MYC                                               40.04
              IF (KGRPNT(IXC,IYC).NE.1) THEN                              40.04
                MCGRDNEW = MCGRDNEW + 1                                   40.04
                KGRPNTNEW(IXC,IYC) = MCGRDNEW                             40.04
              ELSE                                                        40.04
                KGRPNTNEW(IXC,IYC) = 1                                    40.04
              END IF                                                      40.04
            END DO                                                        40.04
          END DO                                                          40.04
          MCGRD = MCGRDNEW                                                40.04
          DO IXC = 1, MXC                                                 40.04
            DO IYC = 1, MYC                                               40.04
              KGRPNT(IXC,IYC) = KGRPNTNEW(IXC,IYC)                        40.04
            END DO                                                        40.04
          END DO                                                          40.04
        ENDIF                                                             40.04
      END IF                                                              30.81
      RETURN
      END
************************************************************************
*                                                                      *
      LOGICAL FUNCTION PVALID (IX, IY, KGRPNT)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
C
C  0. Authors
C
C  1. Updates
C
C     New function for curvilinear version (ver. 40.00). May '98
C
C  2. Purpose
C
C     procedure to find whether a couple (ix,iy) represents
C     a valid grid point
C
C  3. Method
C
C     If one of the gridcounter (IX,IY) is less then 1 or greater than
C     maximum or point is an exception point the point is not valid.
C
C  4. Argument variables
C
C     IX, IY    input    x- and y-index of point under consideration
C     KGRPNT    input    indirect addresses for grid points
C
      INTEGER IX, IY, KGRPNT(MXC,MYC)
C
C  5. Parameter variables
C
C  6. Local variables
C
C     IENT    number of entries of this subroutine
C
      INTEGER ICGRD, IENT
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C  9. Subroutines calling
C
C     CGBOUN
C     SEPARAREA
C     function VALIDBP
C
C 10. Error messages
C
C 11. Remarks
C
C 12. Structure
C
C     PVALID = .TRUE.
C     If gridcounter in x-direction is less then 1 or greater than mxc or
C     If gridcounter in y-direction is less then 1 or greater than myc or
C     If gridpoint is exception point PVALID = .FALSE.
C
C 13. Source text
C************************************************************************
C
      SAVE       IENT
      DATA       IENT /0/
      CALL STRACE (IENT, 'PVALID')
C
      PVALID = .TRUE.
      IF (IX.LT.1)   PVALID = .FALSE.
      IF (IY.LT.1)   PVALID = .FALSE.
      IF (IX.GT.MXC) PVALID = .FALSE.
      IF (IY.GT.MYC) PVALID = .FALSE.
      IF (PVALID) THEN
        ICGRD = KGRPNT(IX,IY)
        IF (ICGRD.LE.1) PVALID = .FALSE.
      ENDIF
      RETURN
      END
C
************************************************************************
*                                                                      *
      LOGICAL FUNCTION VALIDBP (IX, IY, KGRPNT,WNP)
*                                                                      *
************************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
      INCLUDE 'ocpcomm4.inc'
C
C  0. Authors
C
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C     August 2000 new function
C
C  2. Purpose
C
C     Check whether point with index (IX,IY) can be a valid boundary point
C
C  3. Method
C
C     The number of wet neighbouring points WNP is determined
C     Depending on this number certain configurations with wet and dry
C     points surrounding (IX,IY) are excluded
C
C  4. Argument variables
C
C     IX, IY    input    x- and y-index of point under consideration
C     KGRPNT    input    indirect addresses for grid points
C     WNP       output   number of wet neighbouring points
C
      INTEGER IX, IY, KGRPNT(MXC,MYC), WNP
C
C  5. Parameter variables
C
C  6. Local variables
C
C     IENT    number of entries of this subroutine
C
      INTEGER IENT
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     Function PVALID
C
      LOGICAL PVALID
C
C  9. Subroutines calling
C
C     CGBOUN
C
C 10. Error messages
C
C 11. Remarks
C
C     This function prevends all projections of one cell width to
C     be a boundary point
C
C 12. Structure
C
C     Determine amount of Wet Neighbouring Points WNP
C     IF WNP =0  (isolated cell)     VALIDBP = .FALSE.
C     IF WNP =1  (one wet neighbour) VALIDBP = .FALSE.
C     IF WNP =2  (neighbouring points on straight line)
C                                    VALIDBP = .FALSE.
C
C      . W-d     (neighbouring points make angle with no wet point
C        | |      'between' them)    VALIDBP = .FALSE.
C      D-X-W
C        |
C      . D .     (X: point under consideration (assumed to be wet)
C                 W: wet neighbour
C                 D: dry neighbour  d: dry non-neighbour)
C                 .: either wet or dry point
C
C     IF WNP =3
C      . W-d     (point is 1D connection between areas or centre point
C        | |      of isolated 'half plus')
C      D-X-W                         VALIDBP = .FALSE.
C        | |
C      . W-d
C
C
C 13. Source text
C
C***********************************************************************
C
      SAVE       IENT
      DATA       IENT /0/
      CALL STRACE (IENT, 'VALIDBP')
C
      VALIDBP = .TRUE.
C      IF (PVALID(IX,IY,KGRPNT)) THEN
        WNP = 0
        IF (PVALID(IX-1,IY,KGRPNT)) WNP = WNP +1
        IF (PVALID(IX,IY-1,KGRPNT)) WNP = WNP +1
        IF (PVALID(IX+1,IY,KGRPNT)) WNP = WNP +1
        IF (PVALID(IX,IY+1,KGRPNT)) WNP = WNP +1
C         isolated point
        IF (WNP.EQ.0) VALIDBP = .FALSE.
C         point with one valid (wet) neighbouring grid point
        IF (WNP.EQ.1) VALIDBP = .FALSE.
C
C         neighbouring points on straight line (i.e. infact 1D)
        IF ((WNP.EQ.2) .AND.(
     &      (PVALID(IX,IY-1,KGRPNT).AND.PVALID(IX,IY+1,KGRPNT)) .OR.
     &      (PVALID(IX-1,IY,KGRPNT).AND.PVALID(IX+1,IY,KGRPNT)) .OR.
C         neighbouring points make angle but no wet point 'between' them
     &      (PVALID(IX-1,IY,KGRPNT).AND.PVALID(IX,IY+1,KGRPNT) .AND.
     &       .NOT. PVALID(IX-1,IY+1,KGRPNT)) .OR.
     &      (PVALID(IX-1,IY,KGRPNT).AND.PVALID(IX,IY-1,KGRPNT) .AND.
     &       .NOT. PVALID(IX-1,IY-1,KGRPNT)) .OR.
     &      (PVALID(IX+1,IY,KGRPNT).AND.PVALID(IX,IY-1,KGRPNT) .AND.
     &       .NOT. PVALID(IX+1,IY-1,KGRPNT)) .OR.
     &      (PVALID(IX+1,IY,KGRPNT).AND.PVALID(IX,IY+1,KGRPNT) .AND.
     &       .NOT. PVALID(IX+1,IY+1,KGRPNT)) )  )  VALIDBP = .FALSE.
C
C        point (IX,IY) is 1D connection between areas or isolated
C        centre point of 'half plus'
        IF ((WNP.EQ.3) .AND.(
     &       (.NOT.PVALID(IX-1,IY,KGRPNT) .AND.
     &        .NOT.PVALID(IX+1,IY-1,KGRPNT).AND.
     &        .NOT.PVALID(IX+1,IY+1,KGRPNT)).OR.
     &       (.NOT.PVALID(IX+1,IY,KGRPNT) .AND.
     &        .NOT.PVALID(IX-1,IY-1,KGRPNT).AND.
     &        .NOT.PVALID(IX-1,IY+1,KGRPNT)).OR.
     &       (.NOT.PVALID(IX,IY-1,KGRPNT) .AND.
     &        .NOT.PVALID(IX-1,IY+1,KGRPNT).AND.
     &        .NOT.PVALID(IX+1,IY+1,KGRPNT)).OR.
     &       (.NOT.PVALID(IX,IY+1,KGRPNT) .AND.
     &        .NOT.PVALID(IX-1,IY-1,KGRPNT).AND.
     &        .NOT.PVALID(IX+1,IY-1,KGRPNT)) )  )  VALIDBP = .FALSE.
C
      RETURN
      END
C
********************************************************************
*                                                                  *
      SUBROUTINE SEPARAREA(IX, IY, KGRPNT,IDIR)
*                                                                  *
********************************************************************
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
      IMPLICIT NONE
C
      INCLUDE 'swcomm3.inc'
      INCLUDE 'ocpcomm4.inc'
C
C  0. Authors
C
C     40.04  Annette Kieftenburg
C
C  1. Updates
C
C     August 2000 new subroutine
C
C  2. Purpose
C
C     Seperate areas that could be connected with a one cell connection
C
C  3. Method
C
C     Redirect original IDIR ( '<#' in plot below) to new direction('=>')
C
C     .    D    W -- W         X: point under consideration (wet)
C               |    |         W: wet point
C     W -- W <# X => W         D: dry point
C     |    |    |              .: either wet or dry point
C     W -- W    D    .
C
C     for all 8 different situations (4 rotation variations and their
C                                     mirrored situations)
C
C  4. Argument variables
C
C     IX, IY    input          x- and y-index of point under consideration
C     KGRPNT    input          indirect addresses for grid points
C     IDIR      input/output   index for direction (see subroutine CGBOUN)
C
      INTEGER IX, IY, KGRPNT(MXC,MYC), IDIR
C
C  5. Parameter variables
C
C  6. Local variables
C
C     IENT    number of entries of this subroutine
C
      INTEGER IENT
C
C  7. Common Blocks used
C
C  8. Subroutines used
C
C     Function PVALID
C
      LOGICAL PVALID
C
C  9. Subroutines calling
C
C     CGBOUN
C
C 10. Error messages
C
C 11. Remarks
C
C     This subroutine is only used if number of Wet Neighbouring
C     Points WNP = 3
C
C 12. Structure
C
C     In this plot the first situation is illustrated
C
C     .    d    W -- W         X  : point under consideration (wet)
C               |    |         W  : wet point
C     W -- W <# X => W         D,d: dry point
C     |    |    |              .  : either wet or dry point
C     W -- W    D    .
C
C
C     IF dry neighbour point D is below X and upper left point is dry
C     redirect IDIR to 1
C     IF dry neighbour point D is right of X and lower left point is dry
C     redirect IDIR to 2
C     IF dry neighbour point D is above X and lower right point is dry
C     redirect IDIR to 3
C     IF dry neighbour point D is left of X and upper right point is dry
C     redirect IDIR to 4
C
C     mirrored siuation
C
C     IF dry neighbour point D is above X and lower left point is dry
C     redirect IDIR to 4
C     IF dry neighbour point D is left of X and lower right point is dry
C     redirect IDIR to 1
C     IF dry neighbour point D is below X and upper right point is dry
C     redirect IDIR to 2
C     IF dry neighbour point D is right of X and upper left point is dry
C     redirect IDIR to 3
C
C 13. Source text
C
C***********************************************************************
C
      DATA      IENT /0/
      CALL STRACE (IENT,'SEPARAREA')
c      IF (MOD(IENT,2).EQ.0) THEN
C     In case there are 3 wet neighbouring points and validbp(ix,iy,.)
C
      IF(.NOT.PVALID(IX-1,IY+1,KGRPNT) .AND.
     &    .NOT.PVALID(IX,IY-1,KGRPNT)) IDIR = 1
      IF(.NOT.PVALID(IX-1,IY-1,KGRPNT) .AND.
     &    .NOT.PVALID(IX+1,IY,KGRPNT)) IDIR = 2
      IF(.NOT.PVALID(IX+1,IY-1,KGRPNT) .AND.
     &    .NOT.PVALID(IX,IY+1,KGRPNT)) IDIR = 3
      IF(.NOT.PVALID(IX+1,IY+1,KGRPNT) .AND.
     &    .NOT.PVALID(IX-1,IY,KGRPNT)) IDIR = 4
C
C     mirrored siuation
      IF(.NOT.PVALID(IX-1,IY-1,KGRPNT) .AND.
     &    .NOT.PVALID(IX,IY+1,KGRPNT)) IDIR = 4
      IF(.NOT.PVALID(IX+1,IY-1,KGRPNT) .AND.
     &    .NOT.PVALID(IX-1,IY,KGRPNT)) IDIR = 1
      IF(.NOT.PVALID(IX+1,IY+1,KGRPNT) .AND.
     &    .NOT.PVALID(IX,IY-1,KGRPNT)) IDIR = 2
      IF(.NOT.PVALID(IX-1,IY+1,KGRPNT) .AND.
     &    .NOT.PVALID(IX+1,IY,KGRPNT)) IDIR = 3
C
      RETURN
      END
C
********************************************************************
*                                                                  *
      SUBROUTINE INITVA(AC2, SPCSIG, EDIRS, SPCDIR,
     &                  KGRPNT, XCGRID, YCGRID, LOGCOM, XYTST)            40.00
*                                                                  *
********************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
      INCLUDE 'timecomm.inc'                                              40.00
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.70: Nico Booij
C     30.72: IJsbrand Haagsma
C     30.82: IJsbrand Haagsma
C     34.01: Jeroen Adema
C     40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     30.70, Oct. 97: New subroutine
C     30.72, Feb. 98: Introduced generic names XCGRID, YCGRID and SPCSIG for SWAN
C     30.82, Oct. 98: Updated description of SPCDIR
C     30.82, Dec. 98: Corrected the arguments in CALL SINTRP(..)
C     34.01, Feb. 99: Introducing STPNOW
C     40.00, Aug. 99: modification for 1D mode; new option INIT PAR
C                     init restart added
C     40.03, Nov. 99: after reading comment line, jump to 110 (not 100)
C                     additional test output added
C                     possibility added to initialize in limited region (PAR case)
C                     function EQCSTR used to compare strings
C     40.13, Jan. 01: option Spherical was not yet taken care of
C                     ! is now allowed as comment sign in a restart file
C
C  2. Purpose
C
C     process command INIT and compute initial state of the wave field
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.72
C i   XCGRID: Coordinates of computational grid in x-direction            30.72
C i   YCGRID: Coordinates of computational grid in y-direction            30.72
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.72
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.72
C
C  8. Subroutines used
C
      LOGICAL :: STPNOW, EQCSTR                                           40.03
C
C 13. Source text
C
C
      INTEGER    XYTST(*), KGRPNT(MXC,MYC)                                40.00
      REAL       AC2(MDC,MSC,MCGRD),
     &           EDIRS(MDC)
      LOGICAL    KEYWIS, LOGCOM(*), LERR                                  40.00
      CHARACTER  RLINE *80                                                40.00
      SAVE       IENT
      DATA       IENT /0/
      CALL STRACE (IENT, 'INITVA')                                        40.00
C
C     ------------------------------------------------------------------
C
C     ***'initial conditions'  Definition of initial conditions  ***
C     *** for MODE DYNAMIC
C
C ============================================================
C
C               | -> DEFault                   |
C               |                              |
C     INITial  <   ZERO                         >                         40.00
C               |                              |
C               |  PAR  [hs] [per] [dir] [dd]  |
C               |                              |
C               |  HOTStart 'fname'            |                          40.00
C
C ============================================================
C
      CALL IGNORE ('COND')
      LERR =  .FALSE.                                                     40.00
      IF (.NOT. LOGCOM(1)) THEN
        CALL MSGERR (2, 'Define MODE NONSTAT before initial conditions')  40.00
      ENDIF
      CALL INKEYW ('STA', 'DEF')
      IF (KEYWIS('PAR')) THEN
*       initial state defined by wave parameters
        IF (MCGRD .LE. 1) THEN
          CALL MSGERR (2,
     &        'command INIT should follow CGRID and READ BOTTOM')         40.00
          LERR = .TRUE.
        ENDIF
        ICOND = 2
        CALL INREAL ('HSIG', SPPARM(1), 'REQ', 0.)
        CALL INKEYW ('STA', '    ')                                       40.00
        IF (KEYWIS('MEAN')) THEN
          IF (FSHAPE.GT.0) FSHAPE=-FSHAPE
        ELSE IF (KEYWIS('PEAK')) THEN                                     40.00
          IF (FSHAPE.LT.0) FSHAPE=-FSHAPE                                 40.00
        ENDIF
        CALL INREAL('PER', SPPARM(2), 'REQ', 0.)
        IF (SPPARM(2).LE.0.) CALL MSGERR (2, 'Period must be >0')
        IF (SPPARM(2).GT. (2.*PI)/SPCSIG(1)) THEN
          CALL MSGERR (2,
     &          'Inc. freq. lower than lowest spectral freq.')
          WRITE(PRINTF,11) 1./SPPARM(2),SPCSIG(1)
        ENDIF
 11     FORMAT(' Inc. freq. = ',F9.5,' < ', F9.5, '= lowest freq')
        IF (SPPARM(2).LT.1./SPCSIG(MSC))
     &    CALL MSGERR (2,
     &    'Inc. freq. higher than highest spectral freq.')
        CALL INREAL('DIR',  SPPARM(3), 'REQ', 0.)
        IF (DSHAPE.EQ.1) THEN
          CALL INREAL('DD', SPPARM(4), 'STA', 30.)
        ELSE
          CALL INREAL('DD', SPPARM(4), 'STA', 2.)
        ENDIF
C       give boundaries of region where the initial condition applies     40.03
        CALL ININTG ('IX1', IX1, 'STA', 0)                                40.03
        CALL ININTG ('IX2', IX2, 'STA', MXC-1)                            40.03
        CALL ININTG ('IY1', IY1, 'STA', 0)                                40.03
        CALL ININTG ('IY2', IY2, 'STA', MYC-1)                            40.03
        IF (.NOT.LERR) THEN
          CALL SSHAPE (AC2(1,1,1), SPCSIG, SPCDIR, FSHAPE, DSHAPE)
*         copy computed spectrum to all internal grid points
          DO IX = IX1+1, IX2+1                                            40.03
            DO IY = IY1+1, IY2+1                                          40.03
              INDX = KGRPNT(IX,IY)
              IF (INDX.GT.1)
     &        CALL SINTRP (1., 0., AC2(1,1,1), AC2(1,1,1),
     &                       AC2(1,1,INDX),SPCDIR,SPCSIG)                 30.82
            ENDDO                                                         40.03
          ENDDO                                                           40.00
C         reset action density AC2(*,*,1) to 0
          DO ID = 1, MDC
            DO IS = 1, MSC
              AC2(ID,IS,1) = 0.
            ENDDO
          ENDDO
        ENDIF
      ELSE IF (KEYWIS('ZERO')) THEN
*       zero initial state
        DO INDX = 1, MCGRD                                                40.00
          DO ID = 1, MDC
            DO IS = 1, MSC
              AC2(ID,IS,INDX) = 0.
            ENDDO
          ENDDO
        ENDDO
        ICOND = 3
      ELSE IF (KEYWIS('HOTS') .OR. KEYWIS('REST')) THEN                   40.00
*       initialize using spectra from a HOTFILE                           40.00
        IF (MCGRD.LE.1) CALL MSGERR (2,
     &        'command INIT should follow CGRID and READ BOTTOM')         40.00
        ICOND = 4
        CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
        NREF = 0
        IERR = 0
        CALL FOR (NREF, FILENM, 'OF', IERR)
        IF (STPNOW()) RETURN                                              34.01
 100    READ (NREF, 102) RLINE
 102    FORMAT (A)                                                        40.00
        IF (RLINE(1:4).NE.'SWAN') CALL MSGERR (3, FILENM//
     &        ' is not a correct restart file')
 110    READ (NREF, 102) RLINE
        IF (RLINE(1:1).EQ.COMID .OR. RLINE(1:1).EQ.'!') GOTO 110          40.13
        IF (EQCSTR(RLINE,'TIME')) THEN
          READ (NREF, *) IIOPT
          IF (ITEST.GE.50) WRITE (PRTEST, 122) IIOPT                      40.03
 122      FORMAT (' time coding option:', I2)
          READ (NREF, 102) RLINE
*         in stationary mode, warning
          IF (NSTATM.EQ.0) CALL MSGERR (1,
     &                  'Time info in hotfile ignored')                   40.03
        ELSE
          IIOPT = -1
          IF (NSTATM.EQ.1) CALL MSGERR (1,
     &                  'No time info in hotfile')                        40.03
        ENDIF
        IF (EQCSTR(RLINE,'LOCA') .OR. EQCSTR(RLINE,'LONLAT')) THEN        40.13
          READ (NREF, *) NUMPTS
          IF (NUMPTS.NE.MXC*MYC) THEN
            CALL MSGERR (2,
     &      'grid on restart file differs from one in CGRID command')     40.00
            WRITE (PRINTF, 123) MXC*MYC, NUMPTS
 123        FORMAT (1X, I6, ' points in comp.grid; on file:', I6)         40.03
          ENDIF
          IF (ITEST.GE.50) WRITE (PRTEST, 124) NUMPTS                     40.03
 124      FORMAT (1X, I6, '  output locations')
          DO IP = 1, NUMPTS
            READ (NREF, *)
          ENDDO
          READ (NREF, 102) RLINE
        ENDIF
        IF (EQCSTR(RLINE(2:5),'FREQ')) THEN                               40.03
          READ (NREF, *) NUMFRE
          IF (NUMFRE.NE.MSC) CALL MSGERR (2,
     &    'grid on restart file differs from one in CGRID command')       40.00
          IF (ITEST.GE.50) WRITE (PRTEST, 126) NUMFRE                     40.03
 126      FORMAT (1X, I6, '  frequencies')
          DO IP = 1, NUMFRE
            READ (NREF, *)
          ENDDO
          READ (NREF, 102) RLINE
        ENDIF
        IF (EQCSTR(RLINE(2:4),'DIR')) THEN                                40.03
          READ (NREF, *) NUMDIR
          IF (NUMDIR.NE.MDC) CALL MSGERR (2,
     &    'grid on restart file differs from one in CGRID command')       40.00
          IF (ITEST.GE.50) WRITE (PRTEST, 128) NUMDIR                     40.03
 128      FORMAT (1X, I6, '  directions')
          DO IP = 1, NUMDIR
            READ (NREF, *)
          ENDDO
          READ (NREF, 102) RLINE
        ENDIF
        READ (NREF, *) NQUA
        IF (NQUA.NE.1) CALL MSGERR (2, 'NQUA>1: incorrect restart file')  40.00
        READ (NREF, 102) RLINE
        IF (ITEST.GE.50) WRITE (PRTEST, 130) RLINE                        40.03
 130    FORMAT (1X, 'quantity: ', A)
        READ (NREF, 102) RLINE                                            40.00
        READ (NREF, 102) RLINE                                            40.00
*
*       reading of heading is completed, read time if nonstationary
*
        IF (IIOPT.GE.0) THEN
          READ (NREF, 102) RLINE                                          40.00
          CALL DTRETI (RLINE(1:18), IIOPT, TIMCO)                         40.00
          WRITE (PRINTF, 210) RLINE(1:18)
 210      FORMAT (' initial condition read for time: ', A)
        ENDIF
*
        DO 290 IX = 1, MXC
          DO 280 IY = 1, MYC
            READ (NREF, 102) RLINE
            INDX = KGRPNT(IX,IY)
            IF (INDX.EQ.1) THEN
              IF (RLINE(1:6).NE.'NODATA') CALL MSGERR (2,
     &              'valid spectrum for non-existing grid point')
              WRITE (PRINTF, *) IX-1, IY-1
            ELSE
              IF (EQCSTR(RLINE,'NODATA') .OR. EQCSTR(RLINE,'ZERO')) THEN
                DO IS = 1, MSC
                  DO ID = 1, MDC
                    AC2(ID,IS,INDX) = 0.
                  ENDDO
                ENDDO
                IF (ITEST.GE.150) WRITE (PRTEST, 222) IX-1, IY-1          40.03
 222            FORMAT (' zero spectrum or no data for point:', 2I4)      40.03
              ELSE
*               first determine factor
                READ (NREF, *) AFAC
C               multiply with factor to account for transition from       40.00
C               energy/Hz/degr to energy/(rad/s)/rad
                AFAC = AFAC * 90. / (PI**2)
                DO IS = 1, MSC
*                 Read spectral energy densities from file
                  READ (NREF, *) (AC2(ID,IS,INDX), ID=1,MDC)
                  DO ID = 1, MDC
                    AC2(ID,IS,INDX) = AFAC * AC2(ID,IS,INDX)
                  ENDDO
                ENDDO
                IF (ITEST.GE.150) WRITE (PRTEST, 224) IX-1, IY-1, AFAC    40.03
 224            FORMAT (' spectrum in point:', 2I4, '  factor=', E12.4)   40.03
              ENDIF
            ENDIF
 280      CONTINUE
 290    CONTINUE
        CLOSE (NREF)
      ELSE
*       default initial wave state, will be computed later by subr SWINCO
        CALL IGNORE ('DEF')
        ICOND = 1
      ENDIF
      RETURN
*     end of subr INITVA
      END
********************************************************************
*                                                                  *
      SUBROUTINE BACKUP (AC2, SPCSIG, SPCDIR, KGRPNT,
     &                   XCGRID, YCGRID)
*                                                                  *
********************************************************************
C
      INCLUDE 'ocpcomm1.inc'                                              30.74
      INCLUDE 'ocpcomm2.inc'                                              30.74
      INCLUDE 'ocpcomm3.inc'                                              30.74
      INCLUDE 'ocpcomm4.inc'                                              30.74
      INCLUDE 'swcomm1.inc'                                               30.74
      INCLUDE 'swcomm2.inc'                                               30.74
      INCLUDE 'swcomm3.inc'                                               30.74
      INCLUDE 'swcomm4.inc'                                               30.74
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C     ver 40.00, Apr 1998 by N.Booij: new subroutine
C
C   Purpose
C
C  0. Authors
C
C     30.82: IJsbrand Haagsma
C     40.00, 40.13: Nico Booij
C     34.01: Jeroen Adema
C
C  1. Updates
C
C     40.00, Apr. 98: New subroutine
C     30.82, Oct. 98: Updated description of SPCDIR
C     34.01, Feb. 99: Introducing STPNOW
C     40.03, Nov. 99: ITMOPT is written as time coding option
C     40.13, Jan. 01: option Spherical was not yet taken care of
C
C  2. Purpose
C
C     backup current state of the wave field to a file
C
C  4. Argument variables
C
C i   SPCDIR: (*,1); spectral directions (radians)                        30.82
C             (*,2); cosine of spectral directions                        30.82
C             (*,3); sine of spectral directions                          30.82
C             (*,4); cosine^2 of spectral directions                      30.82
C             (*,5); cosine*sine of spectral directions                   30.82
C             (*,6); sine^2 of spectral directions                        30.82
C i   SPCSIG: Relative frequencies in computational domain in sigma-space 30.82
C i   XCGRID: Coordinates of computational grid in x-direction            30.82
C i   YCGRID: Coordinates of computational grid in y-direction            30.82
C
      REAL    SPCDIR(MDC,6)                                               30.82
      REAL    SPCSIG(MSC)                                                 30.82
      REAL    XCGRID(MXC,MYC),    YCGRID(MXC,MYC)                         30.82
C
C  8. Subroutines used
C
      LOGICAL STPNOW                                                      34.01
C
C 13. Source text
C
      REAL     AC2(MDC,MSC,MCGRD)
      INTEGER  KGRPNT(MXC,MYC)
      SAVE     IENT
      DATA     IENT /0/
      CALL STRACE (IENT, 'BACKUP')
C
C     ==================================================================
C
C     HOTFile  'FNAME'                                                    40.00
C
C     ==================================================================
C
      CALL INCSTR ('FNAME', FILENM, 'REQ', ' ')
      NREF = 0
      IERR = 0
      CALL FOR (NREF, FILENM, 'UF', IERR)
      IF (STPNOW()) RETURN                                                34.01
      WRITE (NREF, 102) 'SWAN   1', 'SWAN standard file, with version'
      IF (NSTATM.EQ.1) THEN
        WRITE (NREF, 102) 'TIME', 'time-dependent data'
 102    FORMAT (A, T41, A)                                                40.00
        WRITE (NREF, 103) ITMOPT, 'time coding option'                    40.03
 103    FORMAT (I6, T41, A)                                               40.00
      ENDIF
      IF (KSPHER.EQ.0) THEN                                               40.13
        WRITE (NREF, 102) 'LOCATIONS', 'locations in x-y-space'
      ELSE                                                                40.13
        WRITE (NREF, 102) 'LONLAT', 'locations on the globe'              40.13
      ENDIF                                                               40.13
      WRITE (NREF, 103) MXC*MYC, 'number of locations'
      DO IX = 1, MXC
        DO IY = 1, MYC
          IF (KGRPNT(IX,IY) .EQ. 1) THEN
            WRITE (NREF, 106) OVEXCV(1), OVEXCV(2)
          ELSE
            WRITE (NREF, 106) DBLE(XCGRID(IX,IY)) + DBLE(XOFFS),
     &                        DBLE(YCGRID(IX,IY)) + DBLE(YOFFS)           40.00
 106        FORMAT (2F14.4)                                               40.13
          ENDIF
        ENDDO
      ENDDO
      WRITE (NREF, 102) 'RFREQ', 'relative frequencies in Hz'             40.00
      WRITE (NREF, 103) MSC, 'number of frequencies'                      40.00
      DO 120 IS = 1, MSC
        WRITE (NREF, 114) SPCSIG(IS)/PI2
 114    FORMAT (F10.4)
 120  CONTINUE
      WRITE (NREF, 102) 'CDIR', 'spectral Cartesian directions in degr'   40.00
      WRITE (NREF, 103) MDC, 'number of directions'
      DO 130 ID = 1, MDC
        WRITE (NREF, 124) SPCDIR(ID,1)*180./PI                            30.82
 124    FORMAT (F10.4)
 130  CONTINUE
      WRITE (NREF, 132) 1
 132  FORMAT ('QUANT', /, I6, T41, 'number of quantities in table')       40.00
      WRITE (NREF, 102) 'AcDens', 'action densities'
      WRITE (NREF, 102) 'm2s/Hz', 'unit'                                  40.00
      WRITE (NREF, 102) '0.',     'exception value'                       40.00
C
C     writing of heading is completed, write time if nonstationary
C
      IF (NSTATM.EQ.1) THEN
        WRITE (NREF, 202) CHTIME                                          40.00
 202    FORMAT (A18, T41, 'date and time')
      ENDIF
C
      DO 290 IX = 1, MXC
        DO 280 IY = 1, MYC
          INDX = KGRPNT(IX,IY)
          IF (INDX.EQ.1) THEN
            WRITE (NREF, *) 'NODATA'
          ELSE
            CALL WRSPEC (NREF, AC2(1,1,INDX))                             40.00
          ENDIF
 280    CONTINUE
 290  CONTINUE
      CLOSE (NREF)
      RETURN
C     end of subr BACKUP
      END

#ifdef API
      SUBROUTINE wrf_sizeof_integer( ret )
        INTEGER ret
        ret = 4
      END
      SUBROUTINE wrf_sizeof_real( ret )
        INTEGER ret
        ret = 4
      END
      SUBROUTINE wrf_error_fatal( str )
        CHARACTER*(*) str
        WRITE(0,*)str
        WRITE(*,*)str
        STOP
      END
#endif


