!NRL: $Id: swcomm2.inc,v 1.1.1.2 2003/03/28 15:35:32 dykes Stab $
!NRL: $Name:  $
C                 SWAN COMMON BLOCKS, file 2 of 4
C
C     Contents of this file
C
C     COMMON / SWGRID / *** location and dimensions of input grids
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72 IJsbrand G. Haagsma
C     40.03, 40.13: Nico Booij
C
C  1. Updates
C
C     30.72, Sept 97: Created from the old swancomm.ftn file
C     40.00, Jan. 98: NBFILS, NBSPEC, NBGRPT added
C                     common areas TIMFIL, INPGRS, INPFRM added
C                     NSTATM replaces NONSTA (moved to swcomm3.inc)
C            Feb. 99: IDYNCU, IDYNFR, IDYNWI, IDYNWL removed;
C                     DYNDEP added
C     40.03, May  00: air-sea temperature difference added
C     40.13, Jan. 01: COSPG is initialised at 1 (corresponding to ALPG)
C                     two comments corrected
C
C  2. Purpose
C
C     Common variables used by the subroutines in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C        [???] default value
C
C NUMGRD [ 10] maximum number of grids                                    40.03
C
      INTEGER             NUMGRD
      PARAMETER           (NUMGRD = 10)                                   40.03
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWGRID /  *** location and dimensions of input grids ***
C
C     Common variables
C
C The following input grids are known in SWAN:
C grid(1): depth
C grid(2): current velocity x-component
C grid(3): current velocity y-component
C grid(4): friction coefficient
C grid(5): wind velocity x-component
C grid(6): wind velocity y-component
C grid(7): water level
C grid(8): vegetation density (not used yet)
C grid(9): air-sea temperature difference                                 40.03
C
C                [??] default value
C
C ICOND          [ 0] initial conditions
C                     =0 when mode stationary, or no initial conditions needed
C                     =1 when mode non-stationary and initial conditions should
C                        be calculated
C IGTYPE(NUMGRD) [  ] =0 when grid has constant values
C                     =1 when grid is regular
C                     =2 when grid is curvilinear
C LEDS(NUMGRD)   [ 0] =0 when values have not been read
C                     =1 if values were read
C MXG(NUMGRD)    [ 0] number of meshes in x-direction
C MYG(NUMGRD)    [ 0] number of meshes in y-direction
C NESRUN         [ 0] indicator (=1) for a nested run
C NWAMN          [ 0] indicator (=1) for a WAM-nested run
C OPTG           [ 1] type of the computational grid
C                     =1 when regular
C                     =2 when irregular, but rectangular (not used)
C                     =3 when curvilinear
C NBFILS         [ 0] number of boundary condition files                  40.00
C NBSPEC         [ 0] number of boundary spectra                          40.00
C NBGRPT         [ 0] number of comp. grid points for which boundary      40.00
C                     condition holds
C
      INTEGER             ICOND
      INTEGER             IGTYPE(NUMGRD),           LEDS(NUMGRD)
      INTEGER             MXG(NUMGRD), MYG(NUMGRD), NESRUN,      NWAMN
      INTEGER             OPTG,        NBFILS,      NBSPEC,      NBGRPT   40.00
C
C               [???] default value
C
C CVLEFT        [   ] the (curv.lin.) comput. grid is left/right-oriented
C DYNDEP        [FAL] is True if depth varies with time                   40.00
C LXOFFS        [FAL] offset values were/were not initialized already
C VARAST        [FAL] air-sea temp. diff. is/is not variable over space   40.03
C VARFR         [FAL] friction coefficient is/is not variable over space
C VARWI         [FAL] wind velocity is/is not variable over space
C VARWLV        [FAL] water level is/is not variable over space
C
      LOGICAL             CVLEFT,      LXOFFS,      VARFR                 40.00
      LOGICAL             VARWI,       VARWLV,      DYNDEP                40.00
      LOGICAL             VARAST                                          40.03
C
C               [??????] default value
C
C               [CALCUL] calculated value
C
C ALPG(NUMGRD)  [    0.] direction of the x-axis w.r.t. user coordinates
C COSPG(NUMGRD) [    1.] cos of ALPG                                      40.13
C COSVC         [CALCUL] =COS(-ALPG(2)),
C                        cos of angle of current input grid w.r.t. user coordinates 40.13
C COSWC         [CALCUL] =COS(-ALPG(5)),
C                        cos of angle of wind input grid w.r.t. user coordinates 40.13
C DXG(NUMGRD)   [    0.] mesh size of input grid in x-direction
C DYG(NUMGRD)   [    0.] mesh size of input grid in y-direction
C EXCFLD(NUMGRD)[-1.E20] exception values for input grids
C RDTIM         [      ] =0 when in stationary mode
C                        =1/DT when in non-stationary mode
C SINPG(NUMGRD) [    0.] sin of ALPG
C SINVC         [CALCUL] =SIN(-ALPG(2)),
C                        sin of angle of current input grid w.r.t. comp. grid
C SINWC         [CALCUL] =SIN(-ALPG(5)),
C                        sin of angle of wind input grid w.r.t. comp. grid
C STAGX(NUMGRD) [    0.] staggering of curv.lin. inp. grid w.r.t. comp. grid in X
C STAGY(NUMGRD) [    0.] staggering of curv.lin. inp. grid w.r.t. comp. grid in Y
C XPG(NUMGRD)   [    0.] x of origin
C XOFFS         [    0.] offset value in x
C                        (from user coord. system to internal coord. system)
C YPG(NUMGRD)   [    0.] y of origin
C YOFFS         [    0.] offset value in y
C                        (from user coord. system to internal coord. system)
C
      REAL                ALPG(NUMGRD),             COSPG(NUMGRD)
      REAL                COSVC,       COSWC,       DXG(NUMGRD)
      REAL                DYG(NUMGRD), EXCFLD(NUMGRD)
      REAL                RDTIM,       SINPG(NUMGRD)
      REAL                SINVC,       SINWC,       STAGX(NUMGRD)
      REAL                STAGY(NUMGRD),            XOFFS
      REAL                XPG(NUMGRD), YOFFS,       YPG(NUMGRD)
C
C
      COMMON / SWGRID /   XPG,         YPG,         ALPG,        COSPG
      COMMON / SWGRID /   SINPG,       DXG,         DYG,         MXG
      COMMON / SWGRID /   MYG,         LEDS,        IGTYPE,      VARFR
      COMMON / SWGRID /   VARWI,       COSVC,       SINVC,       COSWC
      COMMON / SWGRID /   SINWC,       XOFFS,       YOFFS,       LXOFFS
      COMMON / SWGRID /   VARWLV,      DYNDEP,      NESRUN,      NWAMN    40.00
      COMMON / SWGRID /   OPTG,        STAGX,       STAGY,       CVLEFT
      COMMON / SWGRID /   RDTIM,       ICOND,       EXCFLD,      NBFILS
      COMMON / SWGRID /   NBSPEC,      NBGRPT,      VARAST                40.03
C
C     commons added version 40.00
C
C     IFLDYN     if =0: data is stationary, if =1: nonstationary
C     IFLIDL     lay-out in input file
C     IFLIFM     format identifier
C     IFLNHF     number of heading lines per file
C     IFLNHD     number of heading lines per input field
C     IFLNDS     unit ref number of data file
C     IFLNDF     unit ref number of namelist file
C
      INTEGER    IFLDYN
      INTEGER    IFLIDL, IFLIFM, IFLNHF, IFLNHD, IFLNDS, IFLNDF
C
C     IFLBEG     begin time of data on file
C     IFLINT     time interval of data on file
C     IFLEND     end time of data on file
C     IFLTIM     time of last reading
C     IFLFAC     multiplication factor
C
      REAL       IFLBEG, IFLINT, IFLEND, IFLTIM
      REAL       IFLFAC
C
C
      COMMON /INPGRS/ IFLIDL(NUMGRD), IFLIFM(NUMGRD), IFLNHF(NUMGRD)
      COMMON /INPGRS/ IFLNHD(NUMGRD), IFLFAC(NUMGRD), IFLNDS(NUMGRD)
      COMMON /INPGRS/ IFLNDF(NUMGRD), IFLDYN(NUMGRD), IFLTIM(NUMGRD)
      COMMON /INPGRS/ IFLBEG(NUMGRD), IFLINT(NUMGRD), IFLEND(NUMGRD)
C
C     IFLFRM     format string
C
      CHARACTER IFLFRM *40
      COMMON /INPFRM/ IFLFRM(NUMGRD)
C
