!NRL: $Id: swcomm3.inc,v 1.1.1.2 2003/03/28 15:35:32 dykes Stab $
!NRL: $Name:  $
C                 SWAN COMMON BLOCKS, file 3 of 4
C
C     Contents of this file
C
C     COMMON / COMPDA / *** pointers for data arrays on computational grid
C     COMMON / SWCOMG / *** location and dimensions of computational grid
!     COMMON / TP_SWCOMG /  *** thread private components of SWCOMG       40.22
C     COMMON / SWFYSP / *** physical parameters
C     COMMON / SWNUMS / *** information related to the numerical scheme
!     COMMON / TP_SWNUMS /  *** thread private components of SWNUMS       40.22
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72: IJsbrand Haagsma
C     30.75: Nico Booij
C     30.82: IJsbrand Haagsma
C     32.01: Roeland Ris & Cor van der Schelde
C     32.06: Roeland Ris
C     34.00: Nico Booij
C     40.00: Nico Booij
C     40.03: Nico Booij
C     40.14: Annette Kieftenburg
!     40.22: John Cazes and Tim Campbell
C
C  1. Updates
C
C     30.72, Sept 97: Created from the old swancomm.ftn file
C     32.01, Jan. 98: MXAUX increased by 3 for the h3268 project
C     32.01, Jan. 98: Introduced JSETUP & JDPSAV in / COMPDA /
C     32.01, Jan. 98: Introduced LSETUP in / SWNUMS /
C     30.75, Mar. 98: SPDIR2 added to / SWCOMG /
C     31.04, Apr. 98: JWFRCX and JWFRCY added to / COMPDA /
C     34.00, May  98: array PQUAD added for Alkyon
C                     MWCAP increased to 15
C     40.00, Jan. 98: JBFILS, JBSPEC, JBTIME, JBGRID, JBSLOC, JBSDIR,
C                     JBSFRQ, JBSAUX added to common COMPDA
C                     spectral shape parameters added: FSHAPE, DSHAPE, PSHAPE
C                     array SPPARM added: holds integral parameters of
C                     incident spectrum
C            Mar. 98: JHSIBC added (stores Hs from boundary condition)
C            May  98: IXCGRD, IYCGRD, KCGRD added
C            June 98: NGRBND, XCGMIN etc. added to /SWCOMG/
C                     JGRBND added to /COMPDA/
C                     BNDCHK added to /SWNUMS/
C                     NSTATC replaces ISTAT, NSTATM replaces NONSTA
C            Febr 99: BRESCL added (rescaling on/off)
C     32.06, June 99: IGEN added
C     30.80, Aug. 99: URSELL added
C     30.82, Aug. 99: MNUMS increased by 5 (accuracy for SETUP)
C     30.82, Aug. 99: Array PSETUP added
C     30.82, Sep. 99: Flag CSETUP added
C     40.07, Nov. 99: ACUPDA added
C     33.10, Apr. 00: MNUMS increased by 5 (num. diffusion SORDUP scheme)
C     40.03, Apr. 00: Ursell number array added to Compda
C     40.03, May  00: air-sea temperature difference added
!     40.22, Sep. 01: Split MSWMAT into two arrays MSWMATR(real)          40.22
!                     and MLSWMAT(logical                                 40.22
!     40.22, Sep. 01: Moved IXCGRD, IYCGRD, and KCGRD into thread         40.22
!                     private common block TP_SWCOMG for OpenMP           40.22
!     40.22, Sep. 01: Moved ICMAX and CSETUP into thread                  40.22
!                     private common block TP_SWNUMS for OpenMP           40.22
C
C  2. Purpose
C
C     Common variables used by the subroutines in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C        [???] value
C
C MBOT   [ 10] dimension of array PBOT
C MICMAX [ 10] max. number of points in comput. stencil                   40.00
C MNUMS  [ 30] dimension of array PNUMS                                   33.10
C MQUAD  [ 10] dimension of array PQUAD                                   40.07
C MSHAPE [  2] dimension of array MSETUP                                  30.82
C MSHAPE [  5] dimension of array PSHAPE                                  40.00
C MSPPAR [  5] dimension of array SPPARM                                  40.00
C MSURF  [ 10] dimension of array PSURF
C MTRIAD [ 10] dimension of array PTRIAD
C MWCAP  [ 15] dimension of array PWCAP                                   34.00
C MWIND  [ 40] dimension of array PWIND
C MXAUX  [  8] dimension of array JAUX (number of auxiliary arrays)
C
C
      INTEGER             MBOT,        MICMAX,      MNUMS,       MQUAD
      INTEGER             MSETUP,      MSHAPE,      MSPPAR,      MSURF    30.82
      INTEGER             MTRIAD,      MWCAP,       MWIND,       MXAUX    30.82
C
      PARAMETER           (MBOT   = 10)
      PARAMETER           (MICMAX = 10)                                   40.00
      PARAMETER           (MNUMS  = 30)                                   33.10
      PARAMETER           (MQUAD  = 10)                                   40.07
      PARAMETER           (MSETUP =  2)                                   30.82
      PARAMETER           (MSHAPE =  5)                                   40.00
      PARAMETER           (MSPPAR =  5)                                   40.00
      PARAMETER           (MSURF  = 10)
      PARAMETER           (MTRIAD = 10)
      PARAMETER           (MWCAP  = 15)                                   34.00
      PARAMETER           (MWIND  = 40)
      PARAMETER           (MXAUX  =  8)                                   32.01
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C  COMMON / COMPDA / *** pointers for data arrays on computational grid ***
C
C     Common variables
C
C J?????  sequence number of variable ????? within array *;
C         i.e. variable ????? in COMPDA is found in COMPDA(IX,IY,J?????)
C         or variable ????? in ARRAY is found in ARRAY(J?????)
C
C M?????  number of subarrays within an array
C
C        [???] default value, [CAL]:calculated
C
C JABIN  [  7] within array SWMATR
C JABLK  [  8] within array SWMATR
C JAC1   [   ] array AC1 within POOL array
C JAC2   [   ] array AC2 within POOL array
C JADDRS [   ] indirect adresses of computational grid within POOL array
C JANGSW [   ] computed spectral directions WAM within POOL array
C JAOLD  [ 12] within array SWMATR
C JASTD2 [   ] new air-sea temp. diff. within array COMPDA                40.03
C JASTD3 [   ] last read air-sea temp. diff. within array COMPDA          40.03
C JAUX(MXAUX)  auxiliary array within POOL array
C JAUXW  [   ] auxiliary array within POOL array, used for WAM
C JAUXW2 [   ] auxiliary array within POOL array, used for WAM
C JAUXW3 [   ] auxiliary array within POOL array, used for WAM
C JAUXW4 [   ] auxiliary array within POOL array, used for WAM            30.70
C JBFILS [   ] sequence number for pool array BFILES                      40.00
C JBGRID [   ] sequence number for pool array BGRIDP                      40.00
C JBOT   [   ] bottom level within array COMPDA, not used
C JBSAUX [   ] sequence number for pool array BSPAUX                      40.00
C JBSDIR [   ] sequence number for pool array BSPDIR                      40.00
C JBSFRQ [   ] sequence number for pool array BSPFRQ                      40.00
C JBSLOC [   ] sequence number for pool array BSPLOC                      40.00
C JBSPEC [   ] sequence number for pool array BSPECS                      40.00
C JBTIME [   ] ??                                                         40.00
C JCMPDA [   ] array COMPDA within POOL array
C JCDRAG [  1] drag coefficient within array COMPDA,
C              set by command WCAP JANS ...
C JCOOX  [   ] x coordinates computational grid within array COMPDA
C              set by command READ COOR ...
C JCOOY  [   ] y coordinates computational grid within array COMPDA
C              set by command READ COOR ...
C JDHS   [  6] wave height correction within array COMPDA
C              (difference in Hs between last two iterations)
C JDIS0  [  9] within array SWMATR
C JDIS1  [ 10] within array SWMATR
C JDISS  [  2] dissipation within array COMPDA
C JDPSAV [  1] saved depth (for setup) within array COMPDA                32.01
C JDP1   [  7] old depth within array COMPDA
C JDP2   [  8] new depth within array COMPDA
C JDP3   [ 15] last read depth within array COMPDA
C JDTM   [ 20] wave period correction within array COMPDA                 40.00
C              (difference in average wave period between last two iterations)
C JFL1   [   ] boundary spectra at time=T within POOL array
C JFL2   [   ] boundary spectra at time=T+dT within POOL array
C JFRC2  [  1] friction coefficcient within array COMPDA                  40.00
C              set by command READ FR ...
C JFRC3  [  1] friction coefficcient within array COMPDA                  40.00
C              set by command READ FR ...
C JFRW   [   ] computed spectral frequencies WAM within POOL array
C JGRBND [   ] pointer to pool array holding boundary grid                40.00
C JHS    [  1] significant wave height Hs within array COMPDA
C JHSIBC [ 25] significant wave height from boundary condition in array COMPDA 40.00
C JLEAK  [ 21] "leak" within array COMPDA                                 40.00
C              (refractive energy tranport over sector boundaries)
C JLEK1  [ 11] within array SWMATR
C JMAT5  [  5] within array SWMATR
C JMAT6  [  6] within array SWMATR
C JMATD  [  1] within array SWMATR
C JMATL  [  3] within array SWMATR
C JMATR  [  2] within array SWMATR
C JMATU  [  4] within array SWMATR
C JOUTD  [   ] array OUTDA within POOL array
C JP4D   [  7] within array SWTSDA, quadruplet interactions
C JP4S   [  6] within array SWTSDA, quadruplet interactions
C JPBTFR [  4] within array SWTSDA, bottom friction
C JPTRI  [  8] within array SWTSDA, triad interactions
C JPWBRK [  5] within array SWTSDA, surf breaking
C JPWCAP [  3] within array SWTSDA, white capping
C JPWNDA [  1] within array SWTSDA, wind source term part A
C JPWNDB [  2] within array SWTSDA, wind source term part B
C JQB    [  4] fraction of breaking waves within array COMPDA
C JSETUP [  1] setup values within array COMPDA                           32.01
C JSTP   [  5] steepness within array COMPDA
C JTAUW  [  1] TauW within array COMPDA,
C              set by command WCAP JANS ...
C JTSTDA [   ] array TESTDA within POOL array
C JUBOT  [  3] bottom orbital velocity within array COMPDA
C JURSEL [  1] Ursell number as used in Triad computation                 40.03
C JUSTAR [  1] friction velocity within array COMPDA,
C              set by command WCAP JANS ...
C JVX1   [  9] x of old current velocity within array COMPDA
C JVX2   [ 11] x of new current velocity within array COMPDA
C JVX3   [ 13] x of last read current velocity within array COMPDA
C JVY1   [ 10] y of old current velocity within array COMPDA
C JVY2   [ 12] y of new current velocity within array COMPDA
C JVY3   [ 14] y of last read current velocity within array COMPDA
C JWAREA [   ] workarea within POOL array
C JWFRCX [  0] within array COMPDA: x-comp. wave induced force            31.04
C JWFRCY [  0] within array COMPDA: y-comp. wave induced force            31.04
C JWLV1  [ 22] old water level within array COMPDA                        40.00
C JWLV2  [ 24] new water level within array COMPDA                        40.00
C JWLV3  [ 23] last read water level within array COMPDA                  40.00
C JWX2   [ 16] x of new wind velocity within array COMPDA                 40.00
C JWX3   [ 18] x of last read wind velocity within array COMPDA           40.00
C JWY2   [ 17] y of new wind velocity within array COMPDA                 40.00
C JWY3   [ 19] y of last read wind velocity within array COMPDA           40.00
C JXYTST [   ] test points within POOL array
C JZEL   [  1] roughness within array COMPDA,
C              set by command WCAP JANS ...
C
C MCMVAR [ 25] within array COMPDA,                                       40.00
C              =MCMVAR+1, for command READ BOT ... (add JDP2) (obsolete)
C              =MCMVAR+2, for command READ FR ... (add JFRC2, JFRC3)      40.00
C              =MCMVAR+1, for command READ WL ... (add JWLV2) (obsolete)
C              =MCMVAR+2, for command WIND ... (add JWX2, JWY2) (obsolete)
C              =MCMVAR+2, for command READ WI ... (add JWX2, JWY2) (obsolete)
C              =MCMVAR+2, for command READ CUR ... (add JVX2, JVY2) (obsolete)
C              =MCMVAR+2, for command READ COOR ... (add JCOOX, JCOOY)
C              =MCMVAR+4, for command WCAP JANS ... (add JCDRAG, JTAUW,
C               JUSTAR, JZEL)
C              =MCMVAR+1, for command TRIAD .......(add Ursell)           40.03
C MSWMAT [ 12] within array SWMATR
C MTSVAR [  8] within array TESTDA
C
      INTEGER             JABIN,       JABLK,       JAC1,        JAC2
      INTEGER             JADDRS,      JANGSW,      JAOLD
      INTEGER             JASTD2,      JASTD3                             40.14 40.03
      INTEGER             JAUX(MXAUX), JAUXW,       JAUXW2,      JAUXW3
      INTEGER             JBFILS,      JBGRID,      JBOT,        JBSAUX   40.00
      INTEGER             JBSDIR,      JBSFRQ,      JBSLOC,      JBSPEC   40.00
      INTEGER             JBTIME,      JCDRAG,                   JCMPDA   40.00
      INTEGER             JCOOX,       JCOOY,       JDHS,        JDIS0
      INTEGER             JDIS1,       JDISS,       JDPSAV,      JDP1     32.01
      INTEGER             JDP2                                            32.01
      INTEGER             JDP3,        JDTM,        JFL1,        JFL2
      INTEGER             JFRC2,       JFRC3,       JFRW                  40.00
      INTEGER             JGRBND,      JHS,         JHSIBC,      JLEAK    40.00
      INTEGER             JLEK1,       JMAT5,       JMAT6,       JMATD
      INTEGER             JMATL,       JMATR,       JMATU,       JOUTD
      INTEGER             JP4D,        JP4S,        JPBTFR,      JPTRI
      INTEGER             JPWBRK,      JPWCAP,      JPWNDA,      JPWNDB
      INTEGER             JQB,         JSETUP,      JSTP,        JTAUW    32.01
      INTEGER             JTSTDA                                          32.01
      INTEGER             JUBOT,       JUSTAR,      JVX1,        JVX2
      INTEGER             JVX3,        JVY1,        JVY2,        JVY3
      INTEGER             JWAREA,      JWFRCX,      JWFRCY                31.04
      INTEGER             JWLV1,       JWLV2,       JWLV3
      INTEGER             JWX2,        JWX3                               40.00
      INTEGER             JWY2,        JWY3,        JXYTST,      JZEL
      INTEGER             MCMVAR,                   MTSVAR,      JURSEL   40.03 40.22
      INTEGER             MSWMATR,     MLSWMAT                            40.22
C
      COMMON / COMPDA /   JCMPDA,      MCMVAR,      JHS,         JDISS
      COMMON / COMPDA /   JUBOT,       JQB,         JSTP,        JDHS
      COMMON / COMPDA /   JDP1,        JVX1,        JVY1,        JDP2
      COMMON / COMPDA /   JVX2,        JVY2,        JFRC2,       JFRC3    40.00
      COMMON / COMPDA /   JWX2,        JWY2,        JBOT                  40.00
      COMMON / COMPDA /   JWLV1,       JWLV2,       JWAREA,      JAC1
      COMMON / COMPDA /   JAC2,        JOUTD,       JXYTST,      JTSTDA
      COMMON / COMPDA /   MTSVAR,      JPWNDA,      JPWNDB,      JPWCAP
      COMMON / COMPDA /   JPBTFR,      JPWBRK,      JP4S,        JP4D
      COMMON / COMPDA /   JPTRI,       JAUX,        JDTM                  40.22
      COMMON / COMPDA /   JMATD,       JMATR,       JMATL,       JMATU
      COMMON / COMPDA /   JMAT5,       JMAT6,       JABIN,       JABLK
      COMMON / COMPDA /   JDIS0,       JDIS1,       JLEK1,       JAOLD
      COMMON / COMPDA /   JLEAK,       JWLV3,       JVX3,        JVY3
      COMMON / COMPDA /   JWX3,        JWY3,        JDP3,        JFL1
      COMMON / COMPDA /   JFL2,        JAUXW,       JAUXW2,      JAUXW3
      COMMON / COMPDA /   JFRW,        JANGSW,      JCOOX,       JCOOY
      COMMON / COMPDA /   JADDRS,      JSETUP,      JDPSAV                40.00
      COMMON / COMPDA /   JWFRCX,      JWFRCY,      JUSTAR,      JZEL     40.00
      COMMON / COMPDA /   JTAUW,       JCDRAG,      JBFILS,      JBSPEC   40.00
      COMMON / COMPDA /   JBTIME,      JBGRID,      JBSLOC,      JBSDIR   40.00
      COMMON / COMPDA /   JBSFRQ,      JBSAUX,      JHSIBC,      JGRBND   40.00
      COMMON / COMPDA /   JURSEL,      JASTD2,      JASTD3                40.14 40.03
      COMMON / COMPDA /   MSWMATR,     MLSWMAT                            40.22
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWCOMG /  *** location and dimensions of computational grid ***
C
C     Common variables
C
C J?????  sequence number of variable ????? within array *;
C         or variable ????? in ARRAY is found in ARRAY(J?????)
C
C M?????  number of ?????
C
C        [???] default value, [CAL]:calculated
C
C ICOMP  [  1] unused
C IXCGRD [   ] IX of points of computational stencil                      40.00
C IYCGRD [   ] IY of points of computational stencil                      40.00
C
C JSIGMA [   ] array SPCSIG within POOL array
C JSPDIR [   ] array SPCDIR within POOL array
C
C KCGRD  [   ] grid address of points of computational stencil            40.00
C MCGRD  [  1] number of wet grid points of the computational grid
C MDC    [  0] grid points in theta-direction of computational grid
C MDC4MA [CAL] =IDHGH; some counter for quadruplet interactions. Stored in WWINT(18)
C MDC4MI [CAL] =IDLOW; some counter for quadruplet interactions. Stored in WWINT(17)
C MMCGR  [CAL] =MXC*MYC; grid points in computational grid
C MSC    [  0] grid points in sigma-direction of computational grid
C MSC4MA [CAL] =ISHGH; some counter for quadruplet interactions. Stored in WWINT(16)
C MSC4MI [CAL] =ISLOW; some counter for quadruplet interactions. Stored in WWINT(15)
C MTC    [  1] computational time steps
C MXC    [  0] grid points in x-direction of computational grid
C MYC    [  0] grid points in y-direction of computational grid
C
C NGRBND [cal] number of grid points on computational grid boundary       40.00
C NX     [CAL] =MXC-1; only used locally. Equal to MXS
C NY     [CAL] =MYC-1; only used locally. Equal to MYS
C
      INTEGER             IXCGRD(MICMAX), IYCGRD(MICMAX), KCGRD(MICMAX)   40.00
      INTEGER             ICOMP,       JSIGMA,      JSPDIR,      MCGRD
      INTEGER             MDC,         MDC4MA,      MDC4MI,      MMCGR
      INTEGER             MSC,         MSC4MA,      MSC4MI,      MTC
      INTEGER             MXC,         MYC,         NX,          NY
      INTEGER             NGRBND                                          40.00
C
C        [???] default value, [CAL]:calculated
C
C FULCIR [TRU] spectral directions cover the full/part of circle
C
      LOGICAL             FULCIR
C
C *CP and *PC  to transform between computational- and user-coordinates
C
C        [???] default value, [CAL]:calculated
C
C ALCP   [CAL] =-ALPC;
C              direction of user coordinates w.r.t. computational coordinates
C ALPC   [ 0.] direction of x-axis of computational grid w.r.t. user coordinates
C COSPC  [CAL] =COS(ALPC)
C DX     [CAL] =XCLEN/MXS; mesh size in x-direction of computational grid
C DY     [CAL] =YCLEN/MYS; mesh size in y-direction of computational grid
C DDIR   [CAL] =(SPDIR2-SPDIR1)/MDC;
C              mesh size in theta-direction of computational grid
C DXRP   [   ] unused
C DYRP   [   ] unused
C FRINTF [CAL] =ALOG(SHIG/SLOW)/(MSC-1); frequency integration factor (df/f)
C              (integral over frequency of G(f) = SUM_j (sigma_j*Gj*FRINTF) )
C FRINTH [CAL] =SQRT(SFAC); frequency mesh boundary factor
C              (mesh in frequency space runs from sigma/FRINTH to sigma*FRINTH)
C SHIG   [CAL] =2*PI*FRHIG; highest spectral value of sigma
C SINPC  [CAL] =SIN(ALPC)
C SLOW   [CAL] =2*PI*FRLOW; lowest spectral value of sigma
C SPDIR1 [ 0.] represents first spectral direction (if FULCIR=.FALSE.)
C SPDIR2 [   ] represents second spectral direction (if FULCIR=.FALSE.)   30.75
C XCGMAX [cal] maximum x-coordinate of computational grid points          40.00
C XCGMIN [cal] minimum x-coordinate of computational grid points          40.00
C XCLEN  [   ] length of computational grid in x-direction
C XCP    [CAL] =-XPC*COSPC-YPC*SINPC;
C              origin of user coordinates w.r.t. computational coordinates
C XPC    [ 0.] x coordinate of origin of computational grid
C YCGMAX [cal] maximum y-coordinate of computational grid points          40.00
C YCGMIN [cal] minimum y-coordinate of computational grid points          40.00
C YCLEN  [   ] length of computational grid in y-direction
C YCP    [CAL] =XPC*SINPC-YPC*COSPC;
C              origin of user coordinates w.r.t. computational coordinates
C YPC    [ 0.] y coordinate of origin of computational grid
C
      REAL                ALCP,        ALPC,        COSPC,       DDIR
      REAL                DX,          DXRP,        DY,          DYRP
      REAL                FRINTF,      FRINTH,      SHIG,        SINPC
      REAL                SLOW,        SPDIR1,      SPDIR2,      XCLEN    30.75
      REAL                XCP,         XPC,         YCLEN,       YCP
      REAL                YPC
      REAL                XCGMIN,      XCGMAX,      YCGMIN,      YCGMAX   40.00
C
      COMMON / SWCOMG /   ICOMP,       XPC,         YPC,         ALPC
      COMMON / SWCOMG /   COSPC,       SINPC,       XCLEN,       YCLEN
      COMMON / SWCOMG /   MTC,         MXC,         MYC,         MDC
      COMMON / SWCOMG /   MSC,         SLOW,        SHIG,        DX
      COMMON / SWCOMG /   DY,          DDIR,        NX,          NY
      COMMON / SWCOMG /   XCP,         YCP,         ALCP,        DXRP
      COMMON / SWCOMG /   DYRP,        MSC4MI,      MSC4MA,      MDC4MI
      COMMON / SWCOMG /   MDC4MA,      FRINTF,      FRINTH,      MMCGR
      COMMON / SWCOMG /   FULCIR,      SPDIR1,      JSPDIR,      JSIGMA
      COMMON / SWCOMG /   MCGRD,       SPDIR2                             30.75
      COMMON / SWCOMG /   XCGMIN,      XCGMAX,      YCGMIN,      YCGMAX   40.00
      COMMON / SWCOMG /   NGRBND                                          40.00
 
      COMMON / TP_SWCOMG /  IXCGRD,  IYCGRD,  KCGRD                       40.22
!$OMP THREADPRIVATE(/TP_SWCOMG/)                                          40.22
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWFYSP /  *** physical parameters ***
C
C     Common variables
C
C        [????????????] default value
C
C CASTD  [          0.] (constant) air-sea temperature difference         40.03
C DEGRAD [  CALCULATED] =PI/180; constant to transform degrees to radians
C DNORTH [         90.] direction of the North w.r.t. x-axis of user coordinates
C                       =nor; set by command SET ... [nor] ...
C GRAV   [        9.81] acceleration due to gravity
C                       =grav; set by command SET ... [grav] ...
C PI     [3.1415926536] circular constant
C PI2    [  CALCULATED] =2*PI;
C PWTAIL(10)            coefficients to calculate tail of the spectrum
C    (1) [          4.] tail power of energy density spectrum as function of freq.
C                       =5.; for command GEN3 JANS ...
C                       =5.; for command WCAP JANS ...,
C                       not documented in manual
C                       =5.; for command GROWTH G3 JANS ...,
C                       not documented in manual
C                       =pwtail; set by command SET ... [pwtail]
C    (2) [         2.5] energy spectrum w.r.t. wave number, not used
C    (3) [  CALCULATED] =PWTAIL(1)+1; action density spectrum w.r.t. frequency
C    (4) [          3.] action density spectrum w.r.t. wave number, not used
C    (5) [  CALCULATED] =1./(PWTAIL(1)*(1.+PWTAIL(1)*(FRINTH-1.)));
C                       tail factor for the action integral
C    (6) [  CALCULATED] =1./((PWTAIL(1)-1.)*(1.+(PWTAIL(1)-1.)*(FRINTH-1.)));
C                       tail factor for the energy integral
C    (7) [  CALCULATED] =1./((PWTAIL(1)-2.)*(1.+(PWTAIL(1)-2.)*(FRINTH-1.)));
C                       tail factor for the first moment of energy
C    (8) [  CALCULATED] =1./((PWTAIL(1)-3.)*(1.+(PWTAIL(1)-3.)*(FRINTH-1.)));
C                       tail factor for the second moment of energy
C RHO    [       1025.] density of the water
C                       =rho; set by command SET ... [rho] ...
C WLEV   [          0.] water level
C                       =level; set by command SET [level] ...
C
      REAL                CASTD                                             40.03
      REAL                DEGRAD,      DNORTH,      GRAV,        PI
      REAL                PI2,         PWTAIL(10),  RHO,         WLEV
C
      COMMON / SWFYSP /   GRAV,        WLEV,        PI,          PI2
      COMMON / SWFYSP /   RHO,         DEGRAD,      DNORTH,      PWTAIL
      COMMON / SWFYSP /   CASTD                                             40.03
C
C-------------------------------------------------------------------------------
C
C     COMMON / SWNUMS /  *** information related to the numerical scheme ***
C
C     Common variables
C
C        [???] default value
C
C DSHAPE [  2] indicates option for computation of directional distribution
C              in the spectrum (boundary spectra etc.)
C              =1: directional spread in degrees is given
C              =2: power of COS is given
C
C FSHAPE [  2] indicates option for computation of frequency distribution
C              in the spectrum (boundary spectra etc.)
C              =2: Jonswap(default set by subr SWINIT),
C              =1: Pierson-Moskowitz, =3: bin, =4: Gaussian (set by command
C              BOUNshape ..)
C IBOT   [  0] indicator bottom friction:
C              =0; no bottom friction dissipation
C              =1; set by command FRIC JON  ..., Jonswap bottom friction model
C              =2; for command FRIC COLL ..., Collins bottom friction model
C              =3; for command FRIC MAD  ..., Madsen bottom friction model
C ICMAX  [  3] number of points in computational stencil
C ICOR   [   ] not used
C ICUR   [  0] indicates presence of currents:
C              =0; no currents
C              =1; for command READ CUR ..., currents are present
C IDBR   [  1] not used
C IDIF   [  0] not used
C IGEN   [  3] indicates the generation mode                              32.06
C              =1; for command GEN1 ...,
C              =2; for command GEN2 ...,
C              =3; for command GEN3 ...,
C IINC   [  0] not used
C IPRE   [   ] not used
C IQUAD  [  2] indicates quadruplet interaction term:
C              =0; for command OFF QUAD
C              =0; for command GEN1 ...,
C              =0; for command GEN2 ...,
C              =0; for command GROWTH G1 ... (not documented in manual),
C              =0; for command GROWTH G2 ... (not documented in manual),
C              quadruplets are inactive
C              =1; quadruplets are calculated semi implicit per sweep direction
C              =2; for command GEN3 ...,
C              =2; for command QUAD, not documented in the manual
C              =2; set when IWIND=3 or 4 and ICUR=0 in SUBR ERRCHK,
C              quadruplets are calculated fully explicit per sweep direction
C              =3; set when IWIND=3 or 4 and ICUR=1 in SUBR ERRCHK,
C              quadruplets are calculated fully explicit per iteration
C              =iquad; set by command GEN3 ... QUAD [iquad] ...,
C IREFR  [  1] indicates refraction effect:
C              =0; for command OFF REF, refraction is inactive
C              =1; refraction is active
C ISURF  [  1] indicates surf breaking (shallow water) term:
C              =0; for command OFF BRE, surf breaking is inactive
C              =1; for command BRE CON ..., surf breaking with constant parameter
C              =2; for command BRE VAR ..., surf breaking according to Nelson
C ITERMX [   ] maximum number of iterations:
C              is set equal to MXITST in case of stationary computations     40.03
C              is set equal to MXITNS in case of nonstationary computations  40.03
C ITFRE  [  1] indicator for transport of action in frequency space
C              =0; for command OFF FSH, frequency shifting inactive
C              =1; frequency shifting active
C ITRIAD [  0] indicates triad interaction term:
C              =0; triads are inactive
C              =1; for command TRI DTA IMP ..., not documented in manual
C              =2; for command TRI DTA EXP ..., not documented in manual
C              =3; for command TRI [trfac] [cutfr], as in manual
C              =3; for command TRI LTA IMP ..., not documented in manual
C              =4; for command TRI LTA EXP ..., not documented in manual
C ITRSY  [  1] not used
C IWCAP  [  1] indicates whitecapping:
C              =0; for command GEN1 ...,
C              =0; for command GEN2 ...,
C              =0; for command OFF WCAP, no whitecapping
C              =1; for command GEN3 KOM ...,
C              =1; for command WCAP KOM ..., not documented in manual,
C              standard WAM formulation (Komen et al.; 1984)
C              =2; for command GEN3 JANS ...,
C              =2; for command WCAP JANS ..., not documented in manual,
C              according to Janssen (1989, 1991)
C              =3; for command WCAP LHIG ..., not documented in manual,
C              according to Longuet-Higgins (1967), Yuan et al. (1986)
C              =4; for command WCAP BJ ..., not documented in manual,
C              according to Battjes & Janssen (1978)
C              =5; for command WCAP KBJ ..., not documented in manual,
C              combined formulation of Komen (1) and Battjes & Janssen (4)
C IWIND  [  0] indicates presence of wind, and type of source term used:
C              =0; no wind
C              =1; for command GEN1 ..., if wind is made active,
C              =1; for command GROWTH G1 ..., not documented in manual,
C              1st generation source term
C              =2; for command GEN2 ..., if wind is made active,
C              =2; for command GROWTH G2 ..., not documented in manual,
C              2nd generation source term (as in Dolphin)
C              =3; for command WIND ..., if IWIND still was 0, else unchanged,
C              =3; for command GEN3 KOM ..., if wind is made active,
C              =3; for command GROWTH G3 KOM ..., not documented in manual,
C              3rd generation source term (Snyder)
C              =4; for command GEN3 JANS ..., if wind is made active,
C              =4; for command GROWTH G3 JANS ..., not documented in manual,
C              source term by P. Janssen (1989, 1991)
C              =5; for command GEN3 YAN ..., if wind is made active,
C              =5; for command GROWTH G3 YAN ..., not documented in manual,
C              not documented in manual
C LSETUP [  0] =0; setup is not calculated                                32.01
C              =1; setup is calculated                                    32.01
C              =2; setup is calculated with the boundary conditions from  32.01
C              a nest file                                                32.01
C MXITST [ 15] max. number of iterations in stationary computations       40.03
C MXITNS [  1] max. number of iterations in nonstationary computations    40.03
C NCOR   [  1] not used
C NSTATC [  1] indicates stationarity of computation:
C              =0; stationary computation
C              =1; nonstationary computation
C NSTATM  [-1] 0: stationary mode, 1: nonstationary mode, -1: unknown
C NUMOBS [   ] number of obstacles
C
      INTEGER             DSHAPE,      FSHAPE                             40.00
      INTEGER             IBOT,        ICMAX,       ICOR,        ICUR
      INTEGER             IDBR,        IDIF,        IGEN,        IINC     32.06
      INTEGER             IPRE,        IQUAD,       IREFR,       ISURF    32.06
      INTEGER             ITERMX,      ITFRE,       ITRIAD,      ITRSY
      INTEGER             IWCAP,       IWIND,       LSETUP                32.01
      INTEGER             MXITST,      MXITNS,                   NCOR     40.03
      INTEGER             NSTATC,      NSTATM,      NUMOBS                40.00
C
C ACUPDA [true] indicates whether or not action densities are to be updated
C               during computation                                        40.07
C
      LOGICAL             ACUPDA                                          40.07
C
C        [???????] default value, [CALCULAT] is calculated
C
C DEPMIN [   0.05] threshold depth (to prevent zero divisions)
C                  =depmin; set by command SET ... [depmin] ...
C HSRERR [    0.1] The error margin allowed between pre-scribed and calculated Hs
C                  at the up-wave boundary. If exceeded a warning is produced
C PBOT(MBOT)       coefficients for the bottom friction models
C  ( 1)  [     0.] =cfc; set by command FRIC COL [cfw] [cfc], (Collins equation),
C                  not documented in the manual
C  ( 2)  [  0.015] =cfw; set by command FRIC COL [cfw], (Collins equation),
C                  also used as CFW in the source code
C  ( 3)  [  0.067] =cfjon; set by command FRIC JON [cfjon], (Jonswap equation)
C  ( 4)  [  -0.08] =mf; value cannot be changed, (Madsen equation)
C  ( 5)  [   0.05] bottom roughness length scale, (Madsen equation),
C                  =kn; set by command FRIC JON [kn],
C                  also used as AKN in the source code
C PNUMS(MNUMS)     numerical coefficients
C                  accuracy criterion:
C  ( 1)  [   0.03] relative error in Hs and Tm01
C                  =drel; set by command NUM ACCUR [drel] ...
C  ( 2)  [   0.03] absolute error in Hs (m)
C                  =dhabs; set by command NUM ACCUR ... [dhabs] ...
C  ( 3)  [    0.3] absolute error in Tm01 (s)
C                  =dtabs; set by command NUM ACCUR ... [dtabs] ...
C  ( 4)  [  97.00] percentage of wet grid points were absolute and relative
C                  accuracy has been reached
C                  =npnts; set by command NUM ACCUR ... [npnts] ...
C  ( 5)  [     0.] not used
C                  diffusion schemes:
C  ( 6)  [    0.5] numerical diffusion over theta,
C                  =cdd; set by command NUM DIR [cdd]
C  ( 7)  [    0.5] numerical diffusion over sigma,
C                  =css; set by command NUM SIGIM [css] ...
C  ( 8)  [     1.] numerical scheme in frequency space
C                  =1.; for command NUM SIGIM, implicit scheme
C                  =2.; for command NUM SIGEX, explicit scheme,
C                  with CFL criterion
C                  =3.; for command NUM FIL, explicit scheme,
C                  without CFL criterion, not documented in the manual
C  ( 9)  [   0.01] diffusion coefficient for explicit scheme,
C                  =diffc; set by command NUM FIL [diffc],
C                  not documented in the manual
C                  linear CGSTAB solver schemes:
C  (10)  [    -3.] value for the pre-conditioner (=IINSOL(2)),
C                  = 0.; no pre-conditioner
C                  =-1.; diagonal pre-conditioner
C                  =-3.; ILU pre-conditioner
C                  =prec; set by command NUM SIGIM ... [prec] ...
C  (11)  [  1.E-6] termination criterion for iterative solver (=RINSOL(1)),
C                  =eps1; set by command NUM SIGIM ... [eps1] ...
C  (12)  [  1.E-4] termination criterion for iterative solver (=RINSOL(2)),
C                  =eps2; set by command NUM SIGIM ... [eps2] ...
C                  (||Ax-b|| < eps1 + eps2 * ||Ax-b|| + eps2 * ||b||)
C  (13)  [     0.] output for CGSTAB solver (=IISOL(3))
C                  =outp; set by command NUM SIGIM ... [outp] ...
C                  <0. no output
C                  =0. only fatal errors are printed
C                  =1. additional information about the iteration is printed
C                  =2. maximal output regarding the iteration process
C  (14)  [    20.] maximum number of iterations in each of the solution methods
C                  =niter; set by command NUM SIGIM ... [niter], (=IINSOL(6))
C  (15)  [   0.01] global error in Hs
C  (16)  [   0.01] global error in Tm01
C  (17)  [     0.] coefficient for limitation of Ctheta (not used currently)
C  (18)  [    0.8] limitation on Froude number (current velocity is reduced if
C                  larger than CGMAX=PNUMS(18)*SQRT(GRAV*DEPW)),
C                  =froudmax; set by command SET ... [froudmax] ...,
C                  not documented in the manual
C  (19)  [CALCULA] =0.5*SQRT(2.); CFL criterion for explicit scheme in
C                  frequency space, manual mentions default = 0.7,
C                  =cfl; set by command NUM SIGEX [cfl]
C  (20)  [  1.E20] maximum growth in spectral bin,
C                  =0.1; for command WIND ..., if IWIND=3 or 4
C                  =0.1; for command GEN3
C                  =0.1; for command TRI
C                  =0.1; for command QUAD,
C                  not documented in the manual
C                  =1.E20; for command OFF QUAD
C                  =limiter; set by command GEN3 ... QUAD ... [limiter]
C                  =limiter; set by command NUM ACCUR ... [itermax] [limiter],
C                  not documented in the manual
C                  =limiter; set by command QUAD [iquad] [limiter],
C                  not documented in the manual
C  (21)            not used
C  (22)            =prec for SETUP; value for the pre-conditioner (=IINSOL(2)),
C                  = 0.; no pre-conditioner
C                  =-1.; diagonal pre-conditioner
C                  =-3.; ILU pre-conditioner
C  (23)            =eps2 for SETUP; termination criterion for iterative solver
C                  (=RINSOL(2)), set by command NUM SETUP ... [eps2] ...
C                  (||Ax-b|| < eps2 * ||Ax-b|| + eps2 * ||b||)
C  (24)            =outp for SETUP; output for CGSTAB solver (=IISOL(3))
C                  <0. no output
C                  =0. only fatal errors are printed
C                  =1. additional information about the iteration is printed
C                  =2. maximal output regarding the iteration process
C  (25)            =niter for SETUP
C                  maximum number of iterations in each of the solution methods
C PQUAD(MQUAD)     coefficients for quadruplet interaction                34.00
C  ( 1)  [   0.25] lambda in eq. B29 of user manual                       34.00
C  ( 2)  [   3.E7] coefficient of interactions                            34.00
C  ( 3)  [    5.5] coefficient for shallow water interactions             34.00
C  ( 4)  [  0.833] coefficient for shallow water interactions             34.00
C  ( 5)  [  -1.25] coefficient for shallow water interactions             34.00
C PSETUP(MSETUP)                                                          30.82
C  ( 1)  [    0.0] not used
C  ( 2)  [    0.0] user defined level for correction of the setup         30.82
C PSHAPE(MSHAPE)   coefficients for calculation of spectrum from integral
C                  parameters                                             40.00
C  ( 1)  [    3.3] peak enhancement factor of Jonswap spectrum
C                  =gamma; set by command BOUN SHAPE .. JON [gamma]
C  ( 2)  [    0.1] width of Gaussian spectrum (in Hz)
C                  =sigfr; set by command BOUN SHAPE .. GAU [sigfr]
C                  after reading the value is converted to radians/second
C                  by a 2 pi multiplication
C
C PSURF(MSURF)     surf breaking coefficients
C  ( 1)  [    1.0] coef. for determining rate of dissipation, (Battjes Jansen),
C                  =1.5; for command BRE VAR
C                  =alpha, set by command BRE CON [alpha] ...
C                  =alpha, set by command BRE VAR [alpha] ...
C  ( 2)  [   0.73] breaker parameter
C                  =gamma, set by command BRE CON ... [gamma]
C  ( 4)  [       ] the min. value of the breaker parameter of Nelson
C                  =0.55; set by command BRE VAR
C                  =gammin; set by command BRE VAR ... [gammin] ...
C  ( 5)  [       ] the max. value of the breaker parameter of Nelson
C                  =0.81; set by command BRE VAR
C                  =gammax; set by command BRE VAR ... [gammax] ...
C  ( 6)  [       ] breaker parameter for negative bottom slopes
C                  =0.73; set by command BRE VAR
C                  =gamneg; set by command BRE VAR ... [gamneg] ...
C  ( 7)  [       ] proportionality coefficient in expression of Nelson
C                  =0.88; set by command BRE VAR
C                  =coeff1; set by command BRE VAR ... [coeff1] ...
C  ( 8)  [       ] coefficient in the exp in the expression of Nelson
C                  =0.012; set by command BRE VAR
C                  =coeff2; set by command BRE VAR ... [coeff2]
C PTRIAD(MTRIAD)
C  ( 1)  [    0.5] controls the proportionality coefficient,
C                  =0.25; for command TRIAD LTA
C                  =0.5; for command TRIAD DTA
C                  =trfac; set by command TRIAD ... [trfac] ...
C  ( 2)  [       ] controls the maximum frequency considered in the comp.,
C                  =2.5; for command TRIAD ...
C                  =cutfr; set by command TRIAD ... [cutfr]
C PWCAP(MWCAP)     whitecapping coefficients
C  ( 1)  [2.36E-5] coefficient for Komen et al. (1984),
C                  ALFAWC (Emperical coefficient)
C                  =cds2; set by command GEN3 KOM [cds2] ...,
C                  =cds2; set by command WCAP KOM [cds2] ...,
C                  not documented in the user manual
C  ( 2)  [3.02E-3] coefficient for Komen et al. (1984),
C                  ALFAPM (Alpha of Pierson Moskowitz frequency)
C                  =stpm; set by command GEN3 KOM ... [stpm],
C                  =stpm; set by command WCAP KOM ... [stpm],
C                  not documented in the user manual
C  ( 3)  [    4.5] coeff. for Janssen (1989,1991), acc. to Komen et al. (1994),
C                  CFJANS (cds coefficient)
C                  =cds1; set by command GEN3 JANS [cds1] ...,
C                  =cds1; set by command WCAP JANS [cds1] ...,
C                  not documented in the user manual
C  ( 4)  [    0.5] (=DELTA)
C                  =delta; set by command GEN3 JANS ... [delta],
C                  =delta; set by command WCAP JANS ... [delta],
C                  not documented in the user manual
C  ( 5)  [     1.] coefficient of Longuet Higgins,
C                  =cflhig; set by command WCAP LHIG [cflhig],
C                  not documented in the user manual
C  ( 6)  [   0.88] GAMBTJ (Steepness limited wave breaking)
C                  =bjstp; set by command WCAP BJ [bjstp] ...
C                  =bjstp; set by command WCAP KBJ [bjstp] ...
C  ( 7)  [     1.] Alpha in Battjes/Janssen,
C                  =bjalf; set by command WCAP BJ ... [bjalf]
C                  =bjalf; set by command WCAP KBJ ... [bjalf] ...
C  ( 8)  [   0.75] numerical diffusion over sigma
C                  =kconv; set by command WCAP KBJ ... [kconv]
C PWIND(MWIND)     wind growth term coefficients
C  ( 1)  [   188.] controls linear wave growth,
C                  =cf10; set by command GEN1 [cf10] ...
C                  =cf10; set by command GEN2 [cf10] ...
C                  =cf10; set by command GROWTH G1 [cf10] ...,
C                  not documented in the user manual
C                  =cf10; set by command GROWTH G2 [cf10] ...,
C                  not documented in the user manual
C  ( 2)  [   0.59] controls the exponential wave growth,
C                  =cf20; set by command GEN1 ... [cf20] ...
C                  =cf20; set by command GEN2 ... [cf20] ...
C                  =cf20; set by command GROWTH G1 ... [cf20] ...,
C                  not documented in the user manual
C                  =cf20; set by command GROWTH G2 ... [cf20] ...,
C                  not documented in the user manual
C  ( 3)  [   0.12] controls the exponential wave growth,
C                  =cf30; set by command GEN1 ... [cf30] ...
C                  =cf30; set by command GEN2 ... [cf30] ...
C                  =cf30; set by command GROWTH G1 ... [cf30] ...,
C                  not documented in the user manual
C                  =cf30; set by command GROWTH G2 ... [cf30] ...,
C                  not documented in the user manual
C  ( 4)  [   250.] controls the dissipation rate,
C                  =cf40; set by command GEN1 ... [cf40] ...
C                  =cf40; set by command GEN2 ... [cf40] ...
C                  =cf40; set by command GROWTH G1 ... [cf40] ...,
C                  not documented in the user manual
C                  =cf40; set by command GROWTH G2 ... [cf40] ...,
C                  not documented in the user manual
C  ( 5)  [ 0.0023] controls the spectral energy of the limit spectrum
C                  =cf50; set by command GEN2 ... [cf50] ...
C                  =cf50; set by command GROWTH G2 ... [cf50] ...,
C                  not documented in the user manual
C  ( 6)  [ -0.223] controls the spectral energy of the limit spectrum
C                  =cf60; set by command GEN2 ... [cf60] ...
C                  =cf60; set by command GROWTH G2 ... [cf60] ...,
C                  not documented in the user manual
C  ( 7)  [     0.] cf70, not used
C  ( 8)  [  -0.56] cf80, not used
C  ( 9)  [CALCULA] density air / density water (=RHOAW),
C                  =PWIND(16)/RHO
C                  =rhoaw; set by command GROWTH G1 ... [rhoaw] ...,
C                  not documented in the user manual
C                  =rhoaw; set by command GROWTH G2 ... [rhoaw] ...,
C                  not documented in the user manual
C     PWIND(13) = PMLM     0.13     (  )
C  (10)  [ 0.0036] limit energy Pierson Moskowitz spectrum
C                  =edmlpm; set by command GEN1 ... [edmlpm] ...
C                  =edmlpm; set by command GEN2 ... [edmlpm] ...
C                  =edmlpm; set by command GROWTH G1 ... [edmlpm] ...,
C                  not documented in the user manual
C                  =edmlpm; set by command GROWTH G2 ... [edmlpm] ...,
C                  not documented in the user manual
C  (11)  [0.00123] drag coefficient
C                  =cdrag; set by command GEN1 ... [cdrag] ...
C                  =cdrag; set by command GEN2 ... [cdrag] ...
C                  =cdrag; set by command GROWTH G1 ... [cdrag] ...,
C                  not documented in the user manual
C                  =cdrag; set by command GROWTH G2 ... [cdrag] ...,
C                  not documented in the user manual
C  (12)  [    1.0] minimum wind velocity, relative to current at 10 m above msl
C                  =umin; set by command GEN1 ... [umin] ...
C                  =umin; set by command GEN2 ... [umin] ...
C                  =umin; set by command GROWTH G1 ... [umin] ...,
C                  not documented in the user manual
C                  =umin; set by command GROWTH G2 ... [umin] ...,
C                  not documented in the user manual
C  (13)  [   0.13] coefficient that determines the Pierson Moskowitz spectrum
C                  =cfpm; set by command GEN1 ... [cfpm]
C                  =cfpm; set by command GEN2 ... [cfpm]
C                  =cfpm; set by command GROWTH G1 ... [cfpm],
C                  not documented in the user manual
C                  =cfpm; set by command GROWTH G2 ... [cfpm],
C                  not documented in the user manual
C  (14)  [   0.01] (=ALPHA) Alpha, according to Janssen (1991) wave growth model
C  (15)  [   0.41] (=XKAPPA)carnock: Kappa
C  (16)  [   1.28] density of the air (=RHOA)
C  (17)  [CALCULA] =RHO, density of the water (=RHOW)
C  (31)  [     0.] proportionality coefficient in the wave growth term of
C                  Caveleri and Malanotte,
C                  =0.0015; for command GEN3 ... AGROW
C                  =a; set by command GEN3 ... AGROW [a]
C BRESCL  [True]   rescaling on/off                                       40.00
C SIGMAG [    0.1] width of the Gaussian frequency spectrum in Hz
C                  =0.01; for command BOU STAT ... GAU
C                  =sigfr; set by command BOU STAT ... GAU [sigfr]
C                  after reading the value is converted to radians/second
C                  by a 2 pi multiplication
C
C SPPARM           integral parameters used for computation of incident spectrum
C  ( 1)  [    ---] significant wave height
C  ( 2)  [    ---] wave period (peak or mean)
C  ( 3)  [    ---] average wave direction
C  ( 4)  [    ---] directional distribution coefficient
C
C SY0    [    3.3] peak enhancement parameter of the JONSWAP spectrum,
C                  =gamma; set by command BOU STAT ... JON [gamma]
C U10    [     0.] wind velocity
C                  =vel; set by command WIND [vel] ...
C WDIC   [CALCULA] =PI2*((WDIP/PI2-NINT(WDIP/PI2)),
C WDIP   [     0.] wind direction with respect to problem coordinates
C                  =dir; set by command WIND ... [dir]
C
      REAL                DEPMIN,      PBOT(MBOT),  PNUMS(MNUMS)
      REAL                PSETUP(MSETUP),           PSHAPE(MSHAPE)        30.82
      REAL                PSURF(MSURF),             PTRIAD(MTRIAD)
      REAL                PWCAP(MWCAP),             PWIND(MWIND)
      REAL                SIGMAG
      REAL                SPPARM(MSPPAR),SY0,         U10,         U10C   40.00
      REAL                WDIC,          WDIP,        HSRERR
      REAL                PQUAD(MQUAD)                                    30.80
C
C BNAUT  [.FALSE.] Indicates whether nautical or cartesian directions are used
C BNDCHK [.TRUE.]  indicates whether computed Hs on boundary must be compared
C                  with value entered as boundary condition               40.00
C ONED   [.FALSE.] Indicates whether the calculation should be performed in 1D-mode
C CSETUP [.TRUE. ] Incicates whether solver for setup has converged       30.82
C
      LOGICAL             BNDCHK,      BNAUT,       ONED,        BRESCL   40.00
      LOGICAL             CSETUP                                          30.82
C
      COMMON / SWNUMS /   NCOR,        IWCAP,       IPRE,        ICOR
      COMMON / SWNUMS /   IBOT,        ICUR,        IDBR
      COMMON / SWNUMS /   IDIF,        IINC,        ITRIAD,      IREFR
      COMMON / SWNUMS /   ISURF,       ITRSY,       IWIND,       IQUAD
      COMMON / SWNUMS /                ITERMX,      NSTATC,      NSTATM   40.00 40.22
      COMMON / SWNUMS /   U10,         U10C
      COMMON / SWNUMS /   WDIP,        WDIC,        DEPMIN,      PWCAP
      COMMON / SWNUMS /   PBOT,        PTRIAD,      PNUMS,       PSURF
      COMMON / SWNUMS /   PWIND,       SY0,         SIGMAG,      ITFRE
      COMMON / SWNUMS /   NUMOBS,      LSETUP,      BNDCHK,      HSRERR   40.00
      COMMON / SWNUMS /   FSHAPE,      DSHAPE,      PSHAPE,      SPPARM   40.00
      COMMON / SWNUMS /   BNAUT,       ONED,        PQUAD,       BRESCL   40.00
      COMMON / SWNUMS /   IGEN,                     PSETUP                40.03 40.22
      COMMON / SWNUMS /   ACUPDA,      MXITST,      MXITNS                40.07
C
      COMMON / TP_SWNUMS /   ICMAX, CSETUP                                 40.22
!$OMP THREADPRIVATE(/TP_SWNUMS/)                                           40.22
