!NRL: $Id: timecomm.inc,v 1.1.1.1 2003/03/28 15:34:04 dykes Stab $
!NRL: $Name:  $
C                     TIME RELATED COMMON BLOCKS
C
C     Contents of this file
C
C     COMMON / TIMCOM /  *** Time related variables for the computation
C     COMMON / TIMRED /  *** Time related variables for nested runs
C
C     Last change:  YGH   1 Sep 2000    4:48 pm
C
C   --|-----------------------------------------------------------|--
C     |            Delft University of Technology                 |
C     | Faculty of Civil Engineering, Fluid Mechanics Group       |
C     | P.O. Box 5048,  2600 GA  Delft, the Netherlands           |
C     |                                                           |
C     | Authors :  R.C. Ris, N. Booij, IJ.G. Haagsma,             |
C     |            A.T.M.M. Kieftenburg, E.E. Kriezi,             |
C     |            R. Padilla-Hernandez, L.H. Holthuijsen         |
C   --|-----------------------------------------------------------|--
C
C
C     BY USING THE SWAN SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY
C     THIS AGREEMENT.
C
C     Delft University of Technology grants you a non-exclusive license
C     to use the SWAN Software free of charge.
C
C     DISCLAIMER OF WARRANTY.
C
C     The Swan Software is provided on an "AS IS" basis, without
C     warranty of any kind, including without limitation the warranties
C     of merchantability, fitness for a particular purpose and
C     non-infringement. The entire risk as to the quality and
C     performance of the Software is borne by you. You must determine
C     that the Software sufficiently meets your requirements.
C
C     LIMITATION OF LIABILITY.
C
C     UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY, TORT, CONTRACT,
C     OR OTHERWISE, SHALL DELFT UNIVERSITY OF TECHNOLOGY BE LIABLE TO
C     YOU OR ANY OTHER PERSON FOR ANY INDIRECT, SPECIAL, INCIDENTAL,
C     OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING, WITHOUT
C     LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER
C     FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES
C     OR LOSSES. IN NO EVENT WILL DELFT UNIVERSITY OF TECHNOLOGY BE
C     LIABLE FOR ANY DAMAGES, EVEN IF DELFT UNIVERSITY OF TECHNOLOGY
C     SHALL HAVE BEEN INFORMED OF THE POSSIBILITY OF SUCH DAMAGES, OR
C     FOR ANY CLAIM BY ANY OTHER PARTY. YOU AGREE TO INDEMNIFY AND HOLD
C     DELFT UNIVERSITY OF TECHNOLOGY HARMLESS WITH RESPECT TO ALL
C     CLAIMS BY THIRD PARTIES ARISING OUT OF YOUR USE OF THE RESULTS
C     OR OPERATION OF THE SOFTWARE.
C
C     TITLE.
C     Title, ownership rights, and intellectual property rights in the
C     Software shall remain with the authors of the Software. The
C     Software is protected by the copyright laws and treaties.  Title
C     and related rights in the content accessed through the Software
C     is the property of the applicable content owner and may be
C     protected by applicable law. This License gives you no rights to
C     such content.
C
C     MISCELLANEOUS.
C     You may not remove any proprietary notices or labels on the
C     Software, nor remove this disclaimer. If any provision of this
C     Agreement is held to be unenforceable, such provision shall be
C     reformed only to the extent necessary to make it enforceable.
C
C     This Agreement shall be governed by the law of the Netherlands.
C     ----------------------------------------------------------------
C
C
C  0. Authors
C
C     30.72 IJsbrand G. Haagsma
C
C  1. Updates
C
C     30.72, Nov. 97: Created to make INCLUDE file from the various
C                     appearances of these COMMONS in SWAN
C     40.00, July 98: common area TIMFIL moved to swcomm2
C                     reason: it is related to input grids
C                     REFTIM mover to Ocean Pack common OCPCOMM1.INC
C
C  2. Purpose
C
C     Common variables used by the subroutines in SWAN.
C     This file needs to be included at the proper places with the
C     INCLUDE 'file.inc' compiler directive
C
C  3. Method
C
C     Defines common blocks, with the needed parameter variables.
C     All variables should be declared explicitely
C
C  4. Argument variables
C
C     --
C
C  5. Parameter variables
C
C     --
C
C  6. Local variables
C
C     --
C
C  7. Common Blocks used
C
C     --
C
C  8. Subroutines used
C
C     --
C
C  9. Subroutines calling
C
C     --
C
C 10. Error messages
C
C     --
C
C-------------------------------------------------------------------------------
C
C     COMMON / TIMCOM /  *** Time related variables for the computation
C
C     Common variables
C
C           [????] default value
C
C TINIC     [    ] Start time and date of the computation (in seconds since
C                  the reference day (REFDAY))
C                  =tbegc; set by command COMP [tbegc] ...
C DT        [    ] Time step of the computation (in seconds)
C                  =deltc; set by command COMP ... [deltc] ...
C                  =deltc*60; set by command COMP ... [deltc] MI ...
C                  =deltc*60*60; set by command COMP ... [deltc] HR ...
C                  =deltc*60*60*24; set by command COMP ... [deltc] DA ...
C TFINC     [    ] End time and date of the computation (in seconds since
C                  the reference day (REFDAY))
C TIMCO     [    ] Time and date of the computation during the simulation (in
C                  seconds since the reference day (REFDAY))
C
      REAL                TINIC,       DT,          TFINC,       TIMCO
C
      COMMON / TIMCOM /   TINIC,       DT,          TFINC,       TIMCO
C
C-------------------------------------------------------------------------------
C
C     COMMON / TIMFIL /  *** Time related variables for the grids
C
C     Common variables
C
C           [????] default value
C
C INTECU    [    ] Time step between non-stationary input conditions
C                  for currents (in seconds)
C                  =deltinp; set by command INP CUR ... [deltinp] S/MI/HR/DA ...
C INTEFR    [    ] Time step between non-stationary input conditions
C                  for bottom friction (in seconds)
C                  =deltinp; set by command INP FR ... [deltinp] S/MI/HR/DA ...
C INTEWI    [    ] Time step between non-stationary input conditions
C                  for wind (in seconds)
C                  =deltinp; set by command INP WI ... [deltinp] S/MI/HR/DA ...
C INTEWL    [    ] Time step between non-stationary input conditions
C                  for water levels (in seconds)
C                  =deltinp; set by command INP WLEV ... [deltinp] S/MI/HR/DA ...
C
C
C           [????] default value
C
C TBEGCU    [    ] Start time for the non-stationary input conditions
C                  for currents (in seconds since the reference day (REFDAY))
C                  =tbeginp; set by command INP CUR ... [tbeginp] ...
C TBEGFR    [    ] Start time for the non-stationary input conditions
C                  for bottom friction (in seconds since the reference day (REFDAY))
C                  =tbeginp; set by command INP FR ... [tbeginp] ...
C TBEGWI    [    ] Start time for the non-stationary input conditions
C                  for wind (in seconds since the reference day (REFDAY))
C                  =tbeginp; set by command INP WI ... [tbeginp] ...
C TBEGWL    [    ] Start time for the non-stationary input conditions
C                  for water levels (in seconds since the reference day (REFDAY))
C                  =tbeginp; set by command INP WLEV ... [tbeginp] ...
C TENDCU    [    ] End time for the non-stationary input conditions
C                  for currents (in seconds since the reference day (REFDAY))
C                  =tendinp; set by command INP CUR ... [tendinp] ...
C TENDFR    [    ] End time for the non-stationary input conditions
C                  for bottom friction (in seconds since the reference day (REFDAY))
C                  =tendinp; set by command INP FR ... [tendinp] ...
C TENDWI    [    ] End time for the non-stationary input conditions
C                  for wind (in seconds since the reference day (REFDAY))
C                  =tendinp; set by command INP WI ... [tendinp] ...
C TENDWL    [    ] End time for the non-stationary input conditions
C                  for water levels (in seconds since the reference day (REFDAY))
C                  =tendinp; set by command INP WLEV ... [tendinp] ...
C TIMCU     [    ] Last time that non-stationary input conditions has been read
C                  for currents (in seconds since the reference day (REFDAY))
C TIMFR     [    ] Last time that non-stationary input conditions has been read
C                  for bottom friction (in seconds since the reference day (REFDAY))
C TIMWI     [    ] Last time that non-stationary input conditions has been read
C                  for wind (in seconds since the reference day (REFDAY))
C TIMWL     [    ] Last time that non-stationary input conditions has been read
C                  for water levels (in seconds since the reference day (REFDAY))
C
C
C
C-------------------------------------------------------------------------------
C
C     COMMON / TIMRED /  *** Time related variables for nested runs
C
C     Common variables
C
C           [????] default value
C
C IFACMX    [   1] ????
C                  =ifacmx; set by command BOU (STAT) NE ... [ifacmx] ...
C                  (NOT documented)
C IFACMY    [   1] ????
C                  =ifacmy; set by command BOU (STAT) NE ... [ifacmy]
C                  (NOT documented)
C
      INTEGER             IFACMX,      IFACMY
C
C           [????] default value
C
C BEGBOU    [    ] Start time for the non-stationary boundary conditions
C                  (in seconds since the reference day (REFDAY)) in the case
C                  of nested runs. Read from the nest file
C TIMERB    [    ] Last time that non-stationary boundary conditions has been read
C                  (in seconds since the reference day (REFDAY))) in the case
C                  of nested runs. Read from the nest file
C TINTBO    [    ] Time step between non-stationary boundary conditions (in seconds)
C                  in the case of nested runs. Read from the nest file
C
      REAL                BEGBOU,      TIMERB,      TINTBO
C
      COMMON / TIMRED /   BEGBOU,      TINTBO,      TIMERB,      IFACMX
      COMMON / TIMRED /   IFACMY
C
