c Program A
c Example 3: A sends density and temperature to Server
c            B receives density and temperature from Server
c           Time loop

      program main
      implicit none
      integer m,n,ntime
      parameter(n=2,m=2,ntime=16)
      include 'MCEL.inc'
      integer id_program,id_square_grid
      real*8 start_time, end_time, dt
      integer itime

C     Used for regular grid
      real*8 dens(m,n), temper(m,n)
      integer ierr
      integer i,j

C     define the grid for this program
      call definegrid(m,n,id_square_grid)

C     Register the send side of this program
      call registerprogram(id_program,id_square_grid)

      dt = 3600.*24.

      do itime = 1,ntime
c     define the start and end time  
      start_time = 942192000 + (itime-1)*dt
      end_time = start_time + dt
      
C     Create and store data
      do i=1,n
        do j=1,m
          temper(i,j) = 0
        enddo
      enddo




c     Stores temperature
      call storedata(id_program,"SSH_NCOM",temper,start_time,
     $   end_time,MCEL_TIMECENT_POINT,ierr)
      if (ierr.eq.0) then
        print *, 'Storing temperature at time = ', start_time
      else
        print *, 'error storing temperature'
      endif
      print *, 'temperature', temper


      enddo

      stop 
      end

C     *******************************************************************
C     *******************************************************************
C     Define the main grid for this program
C     *******************************************************************
C     *******************************************************************

      subroutine definegrid(m,n,id)
      implicit none
      include 'MCEL.inc'
      integer m,n,id,dims
      integer sizes(2), ierr
      real*8 origin(2),delta(2)
      

      dims = 2
      call newgrid(id,dims,MCEL_GRIDTYPE_REGULAR,
     $     MCEL_GRIDCENT_NODAL,MCEL_GRIDCOORD_LATLONG,ierr)


C     This sets the size of the grid in the x and y dir
      sizes(1) = m
      sizes(2) = n
      call setsize(id,sizes,ierr)
      if (ierr.eq.0) then
        print *, 'The grid size has been set'
      else
        print *, 'error while setting grid size'
      endif
      origin(1) =  90
      origin(2) = -50
      delta(1) = 180
      delta(2) = 100
      call setOrigin(id,origin,ierr)
      call setDX(id,delta,ierr)
      return 

      end


C     *******************************************************************
C     *******************************************************************
C     Set up the send parameters for this example
C     *******************************************************************
C     *******************************************************************
      subroutine registerprogram(id_program,id_grid)
      implicit none
      include 'MCEL.inc'

      integer   id_grid, id_program

      integer ierr

C     Create a new program
      call newprogram(id_program,"send side",ierr)
      if (ierr.eq.0) then
        print *, 'Program has been created'
      else
        print *, 'error while creating new program'
      endif

C     Add density to be sent
      call addvar(id_program,"SSH_NCOM",MCEL_DATATYPE_DOUBLE,ierr)
      if (ierr.eq.0) then
        print *, 'New variable added'
      else
        print *, 'error while adding new variable'
      endif
      
      call setgrid(id_program,id_grid,ierr)
      if (ierr.eq.0) then
        print *, 'The grid has been set'
      else
        print *, 'error while setting new grid'
      endif

      call finalize(id_program,ierr)
      if (ierr.eq.0) then
        print *, 'The program has been finalized'
      else
        print *, 'error while finalizing new program'
      endif


      return
      end

