C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001 
C    last changes in this file VERSION 41.11
C
C  mod history
C  v41.11 - 09/14/01 - RL - eliminated MNWLAT, MNWLON
C  v41.06 - 04/02/01 - RL - eliminated MNWP
C  v41.06mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx
C**************************************************************************
C
      MODULE SIZES
      IMPLICIT NONE
C
C...SET NUMBER OF BYTES "SZ" IN REAL(SZ) DECLARATIONS       
C...SET "NBYTE" FOR PROCESSING INPUT DATA RECORD LENGTH


      INTEGER, PARAMETER :: SZ = 4
      INTEGER, PARAMETER :: NBYTE=4


C...SET MAX OF DIGITS OF PRECISION "NPREC" THE GRID CAN BE EXPECTED TO HAVE
C...NOTE: IF THE GRID WAS BUILT ON A 32 BIT COMPUTER, IT SHOULD BE
C   ACCURATE TO ABOUT 7 DIGITS.  THUS, IF THE NODAL SPACING REQUIRES MORE
C   THAN 5 DIGITS OF PRECISION, THE MODEL RESULTS MAY NOT BE TRUSTWORTHY.
 
      INTEGER, PARAMETER ::  NPREC=7
C
      INTEGER ::  MNPROC,MNE,MNP,MNEI,MNOPE,MNETA,MNBOU,MNVEL,
     *  MNTIF,MNBFR,MNFFR,MNSTAE,MNSTAV,MNSTAC,MNSTAM,MNHARF
C
C     Dimension of vertical FE mesh (To interface 2D & 3D)
      INTEGER :: MNODES

      LOGICAL C2DDI,C3D,C3DDSS,C3DVS,CLUMP,CTIP,CHARMV
C
C For Definition of Working Directory
C
      INTEGER,SAVE :: MYPROC


      INTEGER,SAVE :: LNAME = 1
      CHARACTER*1,SAVE :: DIRNAME = '.'

      
C---------------------end of data declarations--------------------------------C


      CONTAINS


      SUBROUTINE MAKE_DIRNAME()

      MYPROC=0

      RETURN
      END SUBROUTINE

      END MODULE SIZES
C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001 
C    last changes in this file VERSION 41.10
C
C  mod history
C  v41.06mxxx  - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx
C  v41.10      - 07/25/01 - rl - from 41.09 - bug fix in GWCE lateral viscosity term
C  v41.09      - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C  v41.06      - 04/02/01 - rl - changed MNWP to MNP in wind forcing 
C                                ALLOCATION statements
C  v41.02      - 09/04 - rl
C  v40.02m004b - 05/17 - vjp - corrected dimensioning problem cvjpm004b
C  v40.02m001  - 12/21 - jjw - add cross barrier pipes cjjwm001
C**************************************************************************
C 
      MODULE GLOBAL
      USE SIZES

C...
C...SET GLOBAL PARAMETER CONSTANTS
C...

C.....nominal density of water RHOWAT0
      REAL(SZ), PARAMETER ::  RHOWAT0=1000.D0

C.....Sigma T value of reference density
      REAL(SZ), PARAMETER ::  SIGT0=RHOWAT0-1000.D0

C.....PI and degrees to radians conversions
      REAL(8), PARAMETER  ::  PI=3.141592653589793D0
      REAL(8), PARAMETER  ::  DEG2RAD = PI/180.D0
      REAL(8), PARAMETER  ::  RAD2DEG = 180.D0/PI

C.....parameters used in barrier overflow 
      REAL(SZ), PARAMETER ::  BARMIN=0.04D0
      REAL(SZ) DEPAVG,DEPMAX,DEPMIN

C...
C...DECLARE ALL ARRAYS
C...


      REAL(SZ),ALLOCATABLE ::   ETAS(:),ETA1(:),ETA2(:)
      REAL(SZ),ALLOCATABLE ::   UBAR1(:),UBAR2(:),VBAR1(:),VBAR2(:)
      REAL(SZ),ALLOCATABLE ::   DP(:),SFAC(:),STARTDRY(:)
      REAL(SZ),ALLOCATABLE ::   QU(:),QV(:),QW(:)
      REAL(SZ),ALLOCATABLE ::   FRIC(:),CORIF(:),EVM(:)
      REAL(SZ),ALLOCATABLE ::   TPK(:),FFT(:)
      REAL(SZ),ALLOCATABLE ::   FACET(:),ETRF(:)
      REAL(SZ),ALLOCATABLE ::   ESBIN1(:),ESBIN2(:)
      REAL(SZ),ALLOCATABLE ::   QTEMA(:,:),QTEMB(:,:)
      REAL(SZ),ALLOCATABLE ::   QN0(:),QN1(:),QN2(:)
      REAL(SZ),ALLOCATABLE ::   BNDLEN2O3(:)
      REAL(SZ),ALLOCATABLE ::   CSII(:),SIII(:)
      REAL(SZ),ALLOCATABLE ::   QNAM(:,:),QNPH(:,:)
      REAL(SZ),ALLOCATABLE ::   QNIN1(:),QNIN2(:)
      REAL(SZ),ALLOCATABLE ::   CSI(:),SII(:)
      REAL(SZ),ALLOCATABLE ::   TAU0VAR(:)
      REAL(SZ),ALLOCATABLE ::   ET00(:)
      REAL(SZ),ALLOCATABLE ::   STAIE1(:),STAIE2(:),STAIE3(:)
      REAL(8),ALLOCATABLE ::    XEV(:),YEV(:),SLEV(:),SFEV(:)
      REAL(SZ),ALLOCATABLE ::   UU00(:),VV00(:)
      REAL(SZ),ALLOCATABLE ::   STAIV1(:),STAIV2(:),STAIV3(:)
      REAL(8),ALLOCATABLE ::    XEC(:),YEC(:),SLEC(:),SFEC(:)
      REAL(SZ),ALLOCATABLE ::   CC00(:)
      REAL(SZ),ALLOCATABLE ::   STAIC1(:),STAIC2(:),STAIC3(:)
      REAL(8),ALLOCATABLE ::    XEM(:),YEM(:),SLEM(:),SFEM(:)
      REAL(SZ),ALLOCATABLE ::   RMU00(:),RMV00(:),RMP00(:)
      REAL(SZ),ALLOCATABLE ::   STAIM1(:),STAIM2(:),STAIM3(:)
      REAL(SZ),ALLOCATABLE ::   CH1(:),QB(:),QA(:),SOURSIN(:),EVC(:)
      REAL(SZ),ALLOCATABLE ::   TAUSX1(:),TAUSY1(:),PR1(:)
      REAL(SZ),ALLOCATABLE ::   TAUSX2(:),TAUSY2(:),PR2(:)
      REAL(SZ),ALLOCATABLE ::   WVNX1(:),WVNY1(:),PRN1(:)
      REAL(SZ),ALLOCATABLE ::   WVNX2(:),WVNY2(:),PRN2(:)
      REAL(SZ),ALLOCATABLE ::   RSNX1(:),RSNY1(:),RSNX2(:),RSNY2(:)
      REAL(SZ),ALLOCATABLE ::   WVNXOUT(:),WVNYOUT(:)
      REAL(SZ),ALLOCATABLE ::   TK(:)
      REAL(8),ALLOCATABLE ::    EMO(:,:),EFA(:,:)
      REAL(8),ALLOCATABLE ::    XEL(:),YEL(:),SLEL(:),SFEL(:)
      REAL(8) ,ALLOCATABLE ::   AREAS(:)
      REAL(SZ),ALLOCATABLE ::   XVELAV(:),YVELAV(:),XVELVA(:),YVELVA(:)
      REAL(SZ),ALLOCATABLE ::   ELAV(:),ELVA(:)
      REAL(SZ),ALLOCATABLE ::   AUV11(:),AUV12(:),AUV13(:),AUV14(:)
      REAL(SZ),ALLOCATABLE ::   DUU1(:),DUV1(:),DVV1(:)
      REAL(SZ),ALLOCATABLE ::   TAUBX1(:),TAUBY1(:)
      REAL(SZ),ALLOCATABLE ::   TIP1(:),TIP2(:)
      REAL(SZ),ALLOCATABLE ::   SALTAMP(:,:),SALTPHA(:,:)
      REAL(SZ),ALLOCATABLE ::   OBCCOEF(:,:),COEF(:,:)
      REAL(SZ),ALLOCATABLE ::   WKSP(:),RPARM(:)
      REAL(SZ),ALLOCATABLE ::   ABD(:,:),ZX(:)

      INTEGER,ALLOCATABLE ::    ME2GW(:)
      INTEGER,ALLOCATABLE ::    NBV(:),LBCODEI(:)
      INTEGER,ALLOCATABLE ::    NNODECODE(:),NODECODE(:),NODEREP(:)
      INTEGER,ALLOCATABLE ::    NIBCNT(:)
      INTEGER,ALLOCATABLE ::    NM(:,:)
      INTEGER,ALLOCATABLE ::    NNEIGH(:),MJU(:),NODELE(:)
      INTEGER,ALLOCATABLE ::    NEITAB(:,:),NEITABELE(:,:)
      INTEGER,ALLOCATABLE ::    NIBNODECODE(:)
      INTEGER,ALLOCATABLE ::    LBArray_Pointer(:)
      INTEGER,ALLOCATABLE ::    NNC(:)
      INTEGER,ALLOCATABLE ::    NNE(:)
      INTEGER,ALLOCATABLE ::    NNV(:)
      INTEGER,ALLOCATABLE ::    NNM(:)
      INTEGER,ALLOCATABLE ::    IWKSP(:),IPARM(:),IPV(:)
      INTEGER,ALLOCATABLE ::    NVDLL(:),NBD(:)
      INTEGER,ALLOCATABLE ::    NBDV(:,:)
      INTEGER,ALLOCATABLE ::    NVELL(:)
      INTEGER,ALLOCATABLE ::    NBVV(:,:)

C.....for buoyancy forcing in 2D
      REAL(SZ),ALLOCATABLE ::   VIDBCPDX1(:),VIDBCPDY1(:)

C.....for internal barrier boundaries with flowthrough pipes
      REAL(SZ),ALLOCATABLE ::   BARLANHTR(:),BARLANCFSPR(:)
      REAL(SZ),ALLOCATABLE ::   BARINHTR(:),BARINCFSBR(:),BARINCFSPR(:)
      REAL(SZ),ALLOCATABLE ::   PIPEHTR(:),PIPECOEFR(:),PIPEDIAMR(:)
      REAL(SZ),ALLOCATABLE ::   BARLANHT(:),BARLANCFSP(:)
      REAL(SZ),ALLOCATABLE ::   FFF(:),FFACE(:)
      REAL(SZ),ALLOCATABLE ::   BTRAN3(:),BTRAN4(:),BTRAN5(:)
      REAL(SZ),ALLOCATABLE ::   BTRAN6(:),BTRAN7(:),BTRAN8(:)
      REAL(SZ),ALLOCATABLE ::   BARINHT(:),BARINCFSB(:),BARINCFSP(:)
      REAL(SZ),ALLOCATABLE ::   PIPEHT(:),PIPECOEF(:),PIPEDIAM(:)
      REAL(SZ),ALLOCATABLE ::   RBARWL1AVG(:),RBARWL2AVG(:)
      REAL(SZ),ALLOCATABLE ::   RPIPEWL1AVG(:),RPIPEWL2AVG(:)
      INTEGER, ALLOCATABLE ::   IBCONN(:),IBCONNR(:),NTRAN1(:),NTRAN2(:)

C.....for bridge pilings
      REAL(SZ)                  POAN,Fr,FRICBP
      INTEGER                   NBPNODES
      REAL(SZ),ALLOCATABLE ::   BK(:),BALPHA(:),BDELX(:)
      INTEGER, ALLOCATABLE ::   NBNNUM(:)

C...
C...DECLARE COMMON BLOCKS
C...
      INTEGER NTSTEPS,ITMV
      REAL(SZ) DT,FMV
      REAL(8) TIMEBEG
      COMMON /MEANSQ/ TIMEBEG,DT,FMV,NTSTEPS,ITMV
C
      INTEGER NHARFR
      COMMON /LSQFREQS/ NHARFR

C...
C...DECLARE REAL(8) AND CHAR VARIABLES, EQUIVALENCES
C...
      REAL(8) STATIM,REFTIM,TIME,DTDP,TIMEH
      REAL(8) AVGXY,DIF1R,DIF2R,DIF3R
      REAL(8) AEMIN,AE,AA,A1,A2,A3,X1,X2,X3,X4,Y1,Y2,Y3,Y4
      REAL(8) FDX1,FDX2,FDX3,FDY1,FDY2,FDY3
      REAL(8) FDX1OA,FDX2OA,FDX3OA,FDY1OA,FDY2OA,FDY3OA,AREAIE
      REAL(8) DDX1,DDX2,DDX3,DDY1,DDY2,DDY3
      REAL(8) DXX11,DXX12,DXX13,DXX21,DXX22,DXX23,DXX31,DXX32,DXX33
      REAL(8) DYY11,DYY12,DYY13,DYY21,DYY22,DYY23,DYY31,DYY32,DYY33
      REAL(8) DXY11,DXY12,DXY13,DXY21,DXY22,DXY23,DXY31,DXY32,DXY33
      REAL(8) XL0,XL1,XL2,YL0,YL1,YL2,SLAM0,SFEA0
      REAL(8) WREFTIM,WTIMED,WTIME2,WTIME1,WTIMINC,QTIME1,QTIME2
      REAL(8) FTIMINC,ETIMINC,RSTIME1,RSTIME2,RSTIMINC
      REAL(8) DELX,DELY,DIST,DELDIST,DELETA
      REAL(8),ALLOCATABLE :: AMIG(:),AMIGT(:),FAMIG(:)
      REAL(8),ALLOCATABLE :: PER(:),PERT(:),FPER(:)
      REAL(8),ALLOCATABLE :: FREQ(:),FF(:),FACE(:)
      REAL(8),ALLOCATABLE :: SLAM(:),SFEA(:),X(:),Y(:)

      CHARACTER*32 RUNDES
      CHARACTER*24 RUNID,AGRID,AGRID2,AFRIC
      CHARACTER*4  RDES4(8),RID4(6),AID4(6)
      CHARACTER*8  RDES8(4),RID8(3),AID8(3)
      CHARACTER*10 ALPHA
      CHARACTER*5,ALLOCATABLE :: TIPOTAG(:),BOUNTAG(:),FBOUNTAG(:)
      EQUIVALENCE (RDES4(1),RDES8(1),RUNDES), (RID4(1),RID8(1),RUNID),
     *            (AID4(1),AID8(1),AGRID)

C...
C...EXPLICITLY DECLARE ADDITIONAL VARIABLES
C...
      INTEGER  NP,NOLICA,NOLIFA,NSCREEN,IHOT,ICS
      INTEGER  NODEDRYMIN,NODEWETMIN,I,IBTYPE,ICK
      INTEGER  IDR,IM,IPRBI,J,JGW,JKI,JME
      INTEGER  JNMM,K,KMIN,N1,N2,N3,NABOUT
      INTEGER  NBFR,NBOU,NBVI,NBVJ,NCOR,NE,NE2,NP2
      INTEGER  NEIMIN,NEIMAX,NETA,NFFR,NFLUXB,NFLUXF,NFLUXIB,NFLUXRBC
      INTEGER  NFLUXIBP,NPIPE
      INTEGER  NFOVER,NHG,NHY,NOLIBF,NOLICAT,NOPE,NOUTC
      INTEGER  NOUTE,NSPOOLE,NOUTV,NSPOOLV,NPRBI
      INTEGER  NRAMP,NRS,NSTAE,NSTARTDRY,NSTAV,NT,NTCYFE
      INTEGER  NTCYFV,NTCYSE,NTCYSV,NTIF,NTIP,NTRSPE,NTRSPV
      INTEGER  NVEL,NVELEXT,NVELME,NWLAT,NWLON,NWP,NWS
      INTEGER  IBSTART, ICHA, ICSTP, IDSETFLG, IE, IER
      INTEGER  IESTP, IFHYBF, IFLINBF, IFNLBF
      INTEGER  IFNLCAT, IFNLCT, IFNLFA
      INTEGER  IFWIND, IGCP, IGEP, IGPP, IGVP, IGWP, IHABEG
      INTEGER  IHARIND, IHOTSTP, IHSFIL, IJ, ILUMP, IMHS, IPSTP
      INTEGER  IREFYR,IREFMO,IREFDAY,IREFHR,IREFMIN, ISLDIA
      INTEGER  ITIME, ITEMPSTP, ITEST, ITHAF, ITHAS
      INTEGER  ITHS, ITITER, ITMAX, IVSTP, IWSTP, IWTIME, IWTIMEP
      INTEGER  IWYR, J12, J13, J21, J23, J31, J32
      INTEGER  JJ, JN, KEMAX, KVMAX, LRC, LUMPT, MAX
      INTEGER  MBW, MDF, MIN, NA, NBDI, NBDJ, NBNCTOT
      INTEGER  NBW, NC1, NC2, NC3, NCBND
      INTEGER  NCELE, NCI, NCJ, NCTOT, NCYC, NDRY, NDSETSC
      INTEGER  NDSETSE, NDSETSV, NDSETSW, NHAGE, NHAGV
      INTEGER  NHAINC, NHASE
      INTEGER  NHASV, NHSINC, NHSTAR, NM1, NM123, NM2, NM3
      INTEGER  NMI1, NMI2, NMI3, NMJ1, NMJ2, NMJ3, NNBB
      INTEGER  NNBB1, NNBB2, NOUTGC, NOUTGE, NOUTGV, NOUTGW, NOUTM
      INTEGER  NSCOUC, NSCOUE, NSCOUGC, NSCOUGE, NSCOUGV
      INTEGER  NSCOUGW, NSCOUM
      INTEGER  NSCOUV, NSPOOLC, NSPOOLGC, NSPOOLGE
      INTEGER  NSPOOLGV, NSPOOLGW, NSPOOLM
      INTEGER  NSTAC, NSTAM, NTCYFC, NTCYFGC, NTCYFGE
      INTEGER  NTCYFGV, NTCYFGW
      INTEGER  NTCYFM, NTCYSC, NTCYSGC, NTCYSGE
      INTEGER  NTCYSGV, NTCYSGW, NTCYSM
      INTEGER  NTRSPC, NTRSPM, NUMITR, NW, NWET, NWSEGWI, NWSGGWI
      INTEGER  NCCHANGE
C
      REAL(SZ) ADVECX, ADVECY, AGIRD, AH, AO12, AO6, ARG
      REAL(SZ) ARG1, ARG2, ARGJ, ARGJ1, ARGJ2, ARGSALT, ARGT
      REAL(SZ) ARGTP, AUV21, AUV22, BARAVGWT
      REAL(SZ) BEDSTR, BNDLEN2O3NC
      REAL(SZ) TAUBXN1, TAUBXN2, TAUBXN3
      REAL(SZ) TAUBYN1, TAUBYN2, TAUBYN3
      REAL(SZ) TAUBXPP3, TAUBYPP3
      REAL(SZ) C1, C2, C3, CBEDSTRD, CBEDSTRE, CCRITD, CCSFEA
      REAL(SZ) CELERITY, CH1N1, CH1N2, CH1N3, CHSUM, COND, CONVCR
      REAL(SZ) CORIFPP, DDU, DHDX, DHDY
      REAL(SZ) DISPERX, DISPERY, DT2, DTO2, DTOHPP, DUU1N1, DUU1N2
      REAL(SZ) DUU1N3, DUV1N1, DUV1N2, DUV1N3, DVV1N1, DVV1N2, DVV1N3
      REAL(SZ) DXXYY11, DXXYY12, DXXYY13, DXXYY21
      REAL(SZ) DXXYY22, DXXYY23, DXXYY31
      REAL(SZ) DXXYY32, DXXYY33, DXYH11, DXYH12
      REAL(SZ) DXYH13, DXYH21, DXYH22
      REAL(SZ) DXYH23, DXYH31, DXYH32, DXYH33, E0N1, E0N2, E0N3
      REAL(SZ) E1N1, E1N1SQ, E1N2, E1N2SQ, E1N3, E1N3SQ, ECONST
      REAL(SZ) EE1, EE2, EE3, ELMAX, EP, ESN1, ESN2
      REAL(SZ) ESN3, ETIME1, ETIME2, ETRATIO, EVC1, EVC2, EVC3
      REAL(SZ) EVCEA, EVMPPODT, EVMPPDT, FDDD, FDDDODT, FDDOD, FDDODODT
      REAL(SZ) FIIN, G, GA00, GB00A00, GC00, GDTO2, GFAO2
      REAL(SZ) GHPP, GO3, HABSMIN, HEA, HH1, HH1N1, HH1N2
      REAL(SZ) HH1N3, HH2, HH2N1, HH2N2, HH2N3, HHU1N1, HHU1N2
      REAL(SZ) HHU1N3, HHV1N1, HHV1N2, HHV1N3, HPP, HSD, HSE
      REAL(SZ) HTOT

      REAL(SZ) P11, P22, P33, PR1N1, PR1N2, PR1N3, QFORCEI
      REAL(SZ) QFORCEJ, QTEMA1, QTEMA2, QTEMA3, QTEMB1, QTEMB2, QTEMB3
      REAL(SZ) QTRATIO, QUNORM, QVNORM, RAMP1, RAMP2, RBARWL, RBARWL1
      REAL(SZ) RBARWL1F, RBARWL2, RBARWL2F, RFF, RFF1, RFF2, RHO0
      REAL(SZ) RSTRATIO, RSX, RSY, S2SFEA, SADVDTO3, SALTMUL, SFACPP
      REAL(SZ) SS1N1, SS1N2, SS1N3, T0N1, T0N2, T0N3, T0XN1
      REAL(SZ) T0XN2, T0XN3, T0XPP3, T0YN1, T0YN2, T0YN3, T0YPP3
      REAL(SZ) TADVODT, TAU0AVG, THAF, THAS, THENALLDSSSTUP
      REAL(SZ) TIMEIT, TIPN1,TOUTFC
      REAL(SZ) TIPN2, TIPN3, TKWET, TOUTFGC, TOUTFGE, TOUTFGV, TOUTFGW
      REAL(SZ) TOUTFM, TOUTSGC, TOUTSGE, TOUTSGV, TOUTSGW, TOUTSM, TPMUL
      REAL(SZ) TT0L, TT0R, U11, U1N1, U1N2, U1N3, U22
      REAL(SZ) U33, UEA, UHPP, UHPP3, UN1, UPEA, UPP
      REAL(SZ) UPPDT, UPPDTDDX1, UPPDTDDX2, UPPDTDDX3, UV1, V11, V1N1
      REAL(SZ) V1N2, V1N3, V22, V33, VCOEF1, VCOEF2, VCOEF3N1
      REAL(SZ) VCOEF3N2, VCOEF3N3, VCOEF3X, VCOEF3Y, VEA, VEL, VELABS
      REAL(SZ) VELMAX, VELNORM, VELTAN, VHPP, VHPP3, VPEA, VPP
      REAL(SZ) VPPDT, VPPDTDDY1, VPPDTDDY2, VPPDTDDY3
      REAL(SZ) WDRAGCO, WINDMAG, WINDX
      REAL(SZ) WINDY, WS, WSMOD
      REAL(SZ) TAUSX, TAUSXN1, TAUSXN2, TAUSXN3
      REAL(SZ) TAUSY, TAUSYN1, TAUSYN2, TAUSYN3
      REAL(SZ) WTRATIO,A00,B00,C00,ANGINN
      REAL(SZ) CF,CORI,COSTHETA,COSTHETA1,COSTSET,CROSS,CROSS1
      REAL(SZ) DAY,DOTVEC,DRAMP,DUM1,DUM2,ESLM,ESLC
      REAL(SZ) HBREAK,FGAMMA,FTHETA,H0
      REAL(SZ) RNDAY,TAU,TAU0,THETA,THETA1,TOUTSC,RAMP
      REAL(SZ) TOUTSE,TOUTFE
      REAL(SZ) TOUTSV,TOUTFV,XL
      REAL(SZ) VECNORM,VL1X,VL1Y,VL2X,VL2Y,WLATMAX
      REAL(SZ) WLONMIN,WLATINC,WLONINC
      REAL(SZ) VELMIN

      REAL(8)  RNP_GLOBAL
      REAL(8)  REFSEC   ! required to run in either 32-bit or 64-bit



C-------------------end of data declarations----------------------------------C


      CONTAINS

      SUBROUTINE ALLOC_MAIN1()
C
C     Allocate space for Arrays dimensioned by MNE and MNP
C
      ALLOCATE ( SLAM(MNP),SFEA(MNP),X(MNP),Y(MNP))
      ALLOCATE ( DP(MNP),SFAC(MNP),STARTDRY(MNP))
      ALLOCATE ( NM(MNE,3)) 
      ALLOCATE ( ETAS(MNP))
      ALLOCATE ( QW(MNP))
      ALLOCATE ( FRIC(MNP),EVM(MNP))
      ALLOCATE ( UBAR1(MNP),VBAR1(MNP))
      ALLOCATE ( NNODECODE(MNP),NODEREP(MNP))
      ALLOCATE ( NNEIGH(MNP),MJU(MNP),NODELE(MNP))
      ALLOCATE ( NIBNODECODE(MNP))
      ALLOCATE ( TAU0VAR(MNP))
      ALLOCATE ( CH1(MNP),QB(MNP),QA(MNP),SOURSIN(MNP),EVC(MNP))
      ALLOCATE ( TK(MNP))
      ALLOCATE ( AREAS(MNE))
      ALLOCATE ( UBAR2(MNP))
      ALLOCATE ( VBAR2(MNP))
      ALLOCATE ( ETA1(MNP),ETA2(MNP))
      ALLOCATE ( CORIF(MNP))
      ALLOCATE ( QU(MNP),QV(MNP))
      ALLOCATE ( LBArray_Pointer(MNP))
      ALLOCATE ( CSI(MNP),SII(MNP))
      ALLOCATE ( NODECODE(MNP))
      ALLOCATE ( NIBCNT(MNP) )  !  added 7/31/2000 to fix wetdry bug
      ALLOCATE ( VIDBCPDX1(MNP),VIDBCPDY1(MNP))





      IF ( C3DDSS) THEN
         ALLOCATE( AUV11(MNP),AUV12(MNP),AUV13(MNP),AUV14(MNP))
      ELSEIF (C2DDI) THEN
         ALLOCATE( AUV11(MNP),AUV12(MNP))
      ENDIF

      IF ( C3D) THEN
         ALLOCATE(DUU1(MNP),DUV1(MNP),DVV1(MNP),
     *        TAUBX1(MNP),TAUBY1(MNP))
      endif
C     
      RETURN
      END SUBROUTINE


      SUBROUTINE ALLOC_MAIN2()
C
C     Allocate space for Arrays dimensioned by MNOPE and MNETA
C     
      ALLOCATE ( ESBIN1(MNETA),ESBIN2(MNETA))
      ALLOCATE ( NBDV(MNOPE,MNETA))
      ALLOCATE ( NVDLL(MNOPE),NBD(MNETA))
      ALLOCATE ( EMO(MNBFR,MNETA),EFA(MNBFR,MNETA))
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for nonperiodic zero and nonzero normal flow
C     boundary arrays including barriers
C
      SUBROUTINE ALLOC_MAIN3()
      ALLOCATE ( QN0(MNVEL),QN1(MNVEL),QN2(MNVEL))
      ALLOCATE ( NBV(MNVEL),LBCODEI(MNVEL))
      ALLOCATE ( BNDLEN2O3(MNVEL))
      ALLOCATE ( ME2GW(MNVEL))
      ALLOCATE ( CSII(MNVEL),SIII(MNVEL))
      ALLOCATE ( BARLANHT(MNVEL),BARLANCFSP(MNVEL))
      ALLOCATE ( BARLANHTR(MNVEL),BARLANCFSPR(MNVEL))
      ALLOCATE ( BARINHT(MNVEL),BARINCFSB(MNVEL),BARINCFSP(MNVEL))
      ALLOCATE ( PIPEHT(MNVEL),PIPECOEF(MNVEL),PIPEDIAM(MNVEL))
      ALLOCATE ( IBCONN(MNVEL))
      ALLOCATE ( BARINHTR(MNVEL),BARINCFSBR(MNVEL),BARINCFSPR(MNVEL))
      ALLOCATE ( PIPEHTR(MNVEL),PIPECOEFR(MNVEL),PIPEDIAMR(MNVEL))
      ALLOCATE ( IBCONNR(MNVEL),NTRAN1(MNVEL),NTRAN2(MNVEL))
      ALLOCATE ( BTRAN3(MNVEL),BTRAN4(MNVEL),BTRAN5(MNVEL))
      ALLOCATE ( BTRAN6(MNVEL),BTRAN7(MNVEL),BTRAN8(MNVEL))
      ALLOCATE ( RBARWL1AVG(MNVEL),RBARWL2AVG(MNVEL))
      ALLOCATE ( RPIPEWL1AVG(MNVEL),RPIPEWL2AVG(MNVEL))
      ALLOCATE ( QNIN1(MNVEL),QNIN2(MNVEL))
      ALLOCATE ( NBVV(MNBOU,0:MNVEL))
      ALLOCATE ( NVELL(MNBOU))
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for tidal potential terms 
C
      SUBROUTINE ALLOC_MAIN4a()
      ALLOCATE ( TPK(MNTIF),AMIGT(MNTIF),FFT(MNTIF) )
      ALLOCATE ( FACET(MNTIF),PERT(MNTIF),ETRF(MNTIF) )
      ALLOCATE ( TIPOTAG(MNTIF) )
      
      IF ( CTIP ) THEN
         ALLOCATE( TIP1(MNP),TIP2(MNP))
      ENDIF  
      
      RETURN
      END SUBROUTINE
C     
C     Allocate space for Earth load/self-attraction tide 
C     
      SUBROUTINE ALLOC_MAIN4b()
      ALLOCATE ( SALTAMP(MNTIF,MNP),SALTPHA(MNTIF,MNP) )
      RETURN
      END SUBROUTINE
C     
C     Allocate space for Arrays dimensioned by MNBFR      
C     
      SUBROUTINE ALLOC_MAIN5()
      ALLOCATE ( AMIG(MNBFR),PER(MNBFR))
      ALLOCATE ( FF(MNBFR),FACE(MNBFR))
      ALLOCATE ( BOUNTAG(MNBFR) )
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for periodic normal flow boundary conditions
C
      SUBROUTINE ALLOC_MAIN6()
      ALLOCATE ( QNAM(MNFFR,MNVEL),QNPH(MNFFR,MNVEL))
      ALLOCATE ( FBOUNTAG(MNFFR))
      ALLOCATE ( FAMIG(MNFFR), FFF(MNFFR), FFACE(MNFFR), FPER(MNFFR) )
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for arrays used for station elevation output
C
      SUBROUTINE ALLOC_MAIN7()
      ALLOCATE ( NNE(MNSTAE),ET00(MNSTAE))
      ALLOCATE ( STAIE1(MNSTAE),STAIE2(MNSTAE),STAIE3(MNSTAE))
      ALLOCATE ( XEL(MNSTAE),YEL(MNSTAE),SLEL(MNSTAE),SFEL(MNSTAE))
      RETURN
      END SUBROUTINE
C     
C     Allocate space for arrays used for station velocity output
C
      SUBROUTINE ALLOC_MAIN8()
      ALLOCATE ( XEV(MNSTAV),YEV(MNSTAV),SLEV(MNSTAV),SFEV(MNSTAV))
      ALLOCATE ( NNV(MNSTAV))
      ALLOCATE ( UU00(MNSTAV),VV00(MNSTAV))
      ALLOCATE ( STAIV1(MNSTAV),STAIV2(MNSTAV),STAIV3(MNSTAV))
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for arrays used for station concentration output
C
      SUBROUTINE ALLOC_MAIN9()
      ALLOCATE ( XEC(MNSTAC),YEC(MNSTAC),SLEC(MNSTAC),SFEC(MNSTAC))
      ALLOCATE ( NNC(MNSTAC))
      ALLOCATE ( CC00(MNSTAC))
      ALLOCATE ( STAIC1(MNSTAC),STAIC2(MNSTAC),STAIC3(MNSTAC))
      
      RETURN
      END SUBROUTINE
C
C     Allocate space for arrays used for station meteorological output
C
      SUBROUTINE ALLOC_MAIN10()
      ALLOCATE ( XEM(MNSTAM),YEM(MNSTAM),SLEM(MNSTAM),SFEM(MNSTAM))
      ALLOCATE ( NNM(MNSTAM))
      ALLOCATE ( RMU00(MNSTAM),RMV00(MNSTAM),RMP00(MNSTAM))
      ALLOCATE ( STAIM1(MNSTAM),STAIM2(MNSTAM),STAIM3(MNSTAM))

      RETURN
      END SUBROUTINE
C
C     Allocate space for Arrays dimensioned by MNEI   
C
      SUBROUTINE ALLOC_MAIN11()

C  Arrays used by JCG iterative solver
      
      ALLOCATE( OBCCOEF(MNETA,MNEI-1),COEF(MNP,MNEI))
      ALLOCATE( IWKSP(3*MNP),WKSP(4*MNP+400) )
      ALLOCATE( IPARM(12),RPARM(12) )
      
C  Neighbor Table

      ALLOCATE ( NEITAB(MNP,MNEI))
      ALLOCATE ( NEITABELE(MNP,MNEI))

      RETURN
      END SUBROUTINE
C
C     Allocate space for wind forcing   
C
      SUBROUTINE ALLOC_MAIN12()
      ALLOCATE ( TAUSX1(MNP),TAUSY1(MNP),PR1(MNP) )
      ALLOCATE ( TAUSX2(MNP),TAUSY2(MNP),PR2(MNP) )
      ALLOCATE ( WVNX1(MNP),WVNY1(MNP),PRN1(MNP) )
      ALLOCATE ( WVNX2(MNP),WVNY2(MNP),PRN2(MNP) )
      ALLOCATE ( RSNX1(MNP),RSNY1(MNP),RSNX2(MNP),RSNY2(MNP) )
      ALLOCATE ( WVNXOUT(MNP),WVNYOUT(MNP) )

      RETURN
      END SUBROUTINE
C
C     Allocate space for bridge piling friction arrays   
C
      SUBROUTINE ALLOC_MAIN13()
      ALLOCATE ( NBNNUM(MNP),BK(MNP),BALPHA(MNP),BDELX(MNP) )
      RETURN
      END SUBROUTINE
C
C     Allocate space for harmonic analysis means and variance
C     calculations, this is in global data because the variables are
C     used in main source, outside of HA analysis subroutines.  This
C     should probably be changed.
C
      SUBROUTINE ALLOC_MAIN14()
      ALLOCATE ( XVELAV(MNP),YVELAV(MNP),XVELVA(MNP),YVELVA(MNP) )
      ALLOCATE ( ELAV(MNP),ELVA(MNP) )
      RETURN
      END SUBROUTINE

      END MODULE GLOBAL
C**************************************************************************
C  GLOBAL DATA FOR 3D VS ROUTINES
C**************************************************************************
C 
      MODULE GLOBAL_3DVS

C...
C...BRING IN NECESSARY EXTERNAL MODE (2 DDI) DATA
C...
      USE GLOBAL,
     *ONLY : SZ, NBYTE, MNP, MNE, MNEI, MNVEL, MNODES,
     *       CLUMP,MYPROC,LNAME,DIRNAME,
     *       X, Y, DP, NNEIGH, NEITAB, NEITABELE, AREAS,
     *       TAUSX1, TAUSY1, TAUSX2, TAUSY2,
     *       TAUBX => TAUBX1, TAUBY => TAUBY1,
     *       UBAR => UBAR2, VBAR => VBAR2,
     *       DUU => DUU1, DUV => DUV1, DVV => DVV1,
     *       VIDBCPDX => VIDBCPDX1, VIDBCPDY => VIDBCPDY1,
     *       ETA1, ETA2, CORIF, BTP => QU, EVM,
     *       LBARRAY_POINTER, LBCODEI, CSII, SIII, QNORMSP1 => QN2,
     *       NP, NOLICA, NOLIFA, NSCREEN, IHOT, IHSFIL, IHOTSTP, NWS,
     *       RHOWAT0, SIGT0, G,
     *       RUNDES, RDES4, RDES8, RUNID, RID4, RID8, AGRID, AID4, AID8

C...
C...DESCRIPTION OF EXTERNAL MODE DATA
C...
C   INTEGER  NSCREEN              : flag to suppress or allow screen output
C   INTEGER  NEITAB(MNP,MNEI)     : table of neighbor nodes for each node
C   INTEGER  NNEIGH(MNP)          : number of neighboring nodes for each node
C   INTEGER  NEITABELE(MNP,MNei)  : table of neighboring elements for each node 
C   INTEGER  NOLIFA               : nonlinear finite amplitude flag (1=yes,0=no)
C   INTEGER  NOLICA               : nonlinear advection flag (1=yes, 0=no)
C   INTEGER  NP                   : number of horizontal nodes
C   INTEGER  LBARRAY_POINTER(MNP) : pointer into array of land or flux boundary
C   INTEGER  LBCODEI(MNVel)       : array of land or flux boundary codes
C   REAL TAUSX1(MNP),TAUSY1(MNP)     : Wind stress components at time level s
C   REAL TAUSX2(MNP),TAUSY2(MNP)     : Wind stress components at time level s+1
C   REAL CORIF(MNP)                  : nodal values of Coriolis parameter
C   REAL EVM(MNP)                    : lateral eddy viscosity for momentum
C   REAL VIDBCPDX(MNP),VIDBCPDY(MNP) : (X,Y) derivatives of vertically integrated pressure grad
C   REAL UBAR(MNP),VBAR(MNP)         : vertically averaged velocity components 
C   REAL DUU(MNP),DVV(MNP),DUV(MNP)  : velocity dispersion terms
C   REAL TAUBX(MNP),TAUBY(MNP)       : bottom stress computed after velocity solution
C   REAL QNORMSP1(MNVel)             : specified normal flux boundary condition at time level s+1
C   REAL CSII(MNVel),SIII(MNVel)     : cosine and sine of normal flux boundary node
C   REAL ETA1(MNP),ETA2(MNP)         : water surf elev at time levels s, s+1
C   REAL DP(MNP)                     : still water depth
C   REAL BTP(MNP)                    : barotropic pressure (incl TP & wl) at time levels s+1/2
C   REAL*8  X(MNP),Y(MNP)            : nodal coordinates
C   REAL*8  AREAS(MNE)               : 2*Element Area

C...
C...DECLARE INTERNAL MODE GLOBAL ARRAYS
C...
      COMPLEX,ALLOCATABLE :: GAMMA(:), Q(:,:)

      REAL(SZ),ALLOCATABLE :: SIGMA(:), EVTOT(:)
      REAL(SZ),ALLOCATABLE :: INM(:,:), LVN(:)
      REAL(SZ),ALLOCATABLE :: WZ(:,:)
      REAL(SZ),ALLOCATABLE :: SIGT(:,:), TEMP(:,:), SAL(:,:), BCP(:,:)
      REAL(SZ),ALLOCATABLE :: Q20(:,:), L(:,:)

      INTEGER,ALLOCATABLE :: ISDHOUT(:), ISVHOUT(:), ISTHOUT(:)

C...
C...  DECLARE INTERNAL MODE GLOBAL SCALARS
C...
      COMPLEX :: I, IDTALP1, IDT1MALP1

      REAL(SZ) :: A, B, AMB, GORHO, GORHOOAMB
      REAL(SZ) :: KP, EVMIN, EVCON, Z0S
      REAL(SZ) :: Z0B, DTALP3, DT1MALP3, DTALP2, DT1MALP2
      REAL(SZ) :: THETA1, THETA2

      INTEGER :: NFEN, IDIAG, ISLIP, IEVC
      INTEGER :: ISTART, IDEN
      INTEGER :: I3DSD, NTSSSD, NTSFSD, NSPO3DSD, NSSD, NHN3DSD, ISDREC
      INTEGER :: I3DSV, NTSSSV, NTSFSV, NSPO3DSV, NSSV, NHN3DSV, ISVREC
      INTEGER :: I3DST, NTSSST, NTSFST, NSPO3DST, NSST, NHN3DST, ISTREC
      INTEGER :: I3DGD, NTSSGD, NTSFGD, NSPO3DGD, NSGD, IGDREC
      INTEGER :: I3DGV, NTSSGV, NTSFGV, NSPO3DGV, NSGV, IGVREC
      INTEGER :: I3DGT, NTSSGT, NTSFGT, NSPO3DGT, NSGT, IGTREC

      logical :: turb_allocated = .false.

C...
C...DESCRIPTION OF INTERNAL MODE GLOBAL DATA
C...
C   ISTART                            : counter of # of timesteps VSSOL has been called
C   IDIAG                             : flag to specify amount of diagnostic output
C   NFEN                              : number of vertical nodes
C   ISLIP                             : slip coefficient flag (0=no slip, 1=linear, 2=quadratic)
C   IDEN                              : flag, IDEN=0: barotropic run, IDEN=1: baroclinic run
C   NTSSSD,NTSFSD,NSPO3DSD,NSSD       : parameters controlling station density output
C   I3DSD,NHN3DSD,ISDHOUT(MNP),ISDREC : parameters controlling station density output
C   NTSSSV,NTSFSV,NSPO3DSV,NSSV       : parameters controlling station velocity output
C   I3DSV,NHN3DSV,ISVHOUT(MNP),ISVREC : parameters controlling station velocity output
C   NTSSST,NTSFST,NSPO3DST,NSST       : parameters controlling station velocity output
C   I3DST,NHN3DST,ISTHOUT(MNP),ISTREC : parameters controlling station turbulence output
C   NTSSGD,NTSFGD,NSPO3DGD,NSGD       : parameters controlling global density output
C   I3DGD,IGDREC                      : parameters controlling global density output
C   NTSSGV,NTSFGV,NSPO3DGV,NSGV       : parameters controlling global velocity output     
C   I3DGV,IGVREC                      : parameters controlling global velocity output
C   NTSSGT,NTSFGT,NSPO3DGT,NSGT       : parameters controlling global turbulence output   
C   I3DGT,IGTREC                      : parameters controlling global turbulence output
C   KP                                : input bottom friction coefficient
C   DTALP2,DT1MALP2                   : DelT*alpha2, DelT*(1-alpha2)
C   DTALP3,DT1MALP3                   : DelT*alpha3, DelT*(1-alpha3)
C   WZ(MNP,NFEN)                    : "z" vertical velocity
C   A,B                             : top and bottom sigma values
C   AMB                             : (a-b) difference between top and bottom sigma values
C   SIGMA(NFEN)                     : Sigma levels of vertical nodes
C   Q20(MNP,NFEN)                   : turbulent kinetic energy computed by MY closure
C   L(MNP,NFEN)                     : turbulent length scale computed by MY closure
C   EVTOT(NFEN)                     : vertical eddy viscosity     
C   BCP(MNP,NFEN)                   : baroclinic pressure (integrated down from surface)
C   GORhoOAMB                       :       gravity/(reference density)/(a-b)
C   SIGT(MNP,NFEN)                  : sigma T values
C   TEMP(MNP,NFEN)                  : temperature values
C   SAL(MNP,NFEN)                   : salinity values
C   Inm(NFEN,3)                     : Integral used in vertical assembly
C   LVn(NFEN)                       : Integral used in vertical assembly
C   Q(MNP,NFEN)                     : horizontal velocity in the complex form u + iv
C   GAMMA(NFEN)                     : horizontal velocity soln in the complex form u + iv
C   IDTALP1,IDT1MALP1                 : i*DelT*alpha1, i*DelT*(1-alpha1)
C   I                                 : square root of (-1)


C-------------------end of data declarations----------------------------------C


      CONTAINS

      SUBROUTINE ALLOC_3DVS()
C
C     Allocate space for arrays used in 3D VS routines
C
      ALLOCATE( SIGMA(NFEN), EVTOT(NFEN) )
      ALLOCATE( GAMMA(NFEN), INM(NFEN,3), LVN(NFEN) )
      ALLOCATE( Q(MNP,NFEN), WZ(MNP,NFEN) )
      ALLOCATE( SIGT(MNP,NFEN), TEMP(MNP,NFEN) )
      ALLOCATE( SAL(MNP,NFEN), BCP(MNP,NFEN) )
      ALLOCATE( Q20(MNP,NFEN), L(MNP,NFEN) )
      ALLOCATE( ISDHOUT(MNP), ISVHOUT(MNP), ISTHOUT(MNP) )

      RETURN
      END SUBROUTINE ALLOC_3DVS

      END MODULE GLOBAL_3DVS
C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001  
C    last changes in this file VERSION 41.09
C
C  mod history
C  v40.02mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx 
C  v40.02m002 - 12/22 - jjw/vjp - Vic suggested this change to avoid compiler problems
C************************************************************************** 
C 
      MODULE ITPACKV
C
C  vjp  9/19/99
c
c-----------------------------------------------------------------------------
c     version -  itpackv 2d (january 1990)
c
c     code written by - david kincaid, roger grimes, john respess
c                       center for numerical analysis
c                       university of texas
c                       austin, tx  78712
c                       (512) 471-1242
c-----------------------------------------------------------------------------
c


      USE SIZES



c--------------------data declarations end here-------------------------------c


      CONTAINS

      subroutine jcg (n,ndim,maxnz,jcoef,coef,rhs,u,iwksp,nw,wksp,
     *                iparm,rparm,ier)
      implicit none
      integer n,ndim,maxnz,nw,ier,ib1,ib2,ib3,ib4,ib5,nb,n3,i,nbo,
     *  itmax1,loop,idgts
      integer jcoef(ndim,maxnz),iwksp(3*n),iparm(12)
      real(sz) timi1,timj1,temp,time1,time2,timi2,timj2,digit1,
     *   digit2,tol
      real(sz) coef(ndim,maxnz),rhs(n),u(n),wksp(nw),rparm(12)
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c     itpackv 2d main routine  jcg  (jacobi conjugate gradient)
c     each of the main routines --
c           jcg, jsi, sor, ssorcg, ssorsi, rscg, rssi
c     can be used independently of the others
c
c ... function --
c
c          jcg drives the jacobi conjugate gradient algorithm.
c
c ... parameter list --
c
c          n      input integer.  dimension of the matrix.
c          ndim   row dimension of jcoef and coef arrays in calling
c                   routine
c          maxnz  maximum number of nonzeros per row
c          jcoef  integer array for sparse matrix representation.
c          coef   array for sparse matrix representation.
c                 jcoef and coef use the ellpack data structure.
c          rhs    input vector.  contains the right hand side
c                 of the matrix problem.
c          u      input/output vector.  on input, u contains the
c                 initial guess to the solution. on output, it contains
c                 the latest estimate to the solution.
c          iwksp  integer vector workspace of length 3*n
c          nw     input integer.  length of available wksp.  on output,
c                 iparm(8) is amount used.
c          wksp   vector used for working space.  jacobi conjugate
c                 gradient needs this to be in length at least
c                 4*n + 4*itmax.  here itmax = iparm(1) is the
c                 maximum allowable number of iterations.
c          iparm  integer vector of length 12.  allows user to specify
c                 some integer parameters which affect the method.
c          rparm  vector of length 12. allows user to specify some
c                 parameters which affect the method.
c          ier    output integer.  error flag.
c
c ... jcg module references --
c
c         from itpackv    chgcon, determ, dfault, echall,
c                         eigvns, eigvss, eqrt1s, iterm ,
c                         itjcg , parcon, permat, peror,
c                         pervec, pjac  , pmult , prbndx, pstop ,
c                         sbelm , scal  , unscal,
c                         vout  , zbrent
c          system         abs, log10, amax0, amax1, mod, sqrt
c
c ... local itpackv references --
c
c          echall, itjcg , permat,
c          peror, pervec, pjac  , prbndx, sbelm , scal  , unscal
c
c     version -  itpackv 2d (january 1990)
c
c     code written by - david kincaid, roger grimes, john respess
c                       center for numerical analysis
c                       university of texas
c                       austin, tx  78712
c                       (512) 471-1242
c
c     for additional details on the
c          (a) routine    see toms article 1982
c          (b) algorithm  see cna report 150
c
c     based on theory by - david young, david kincaid, lou hageman
c
c     reference the book - applied iterative methods
c                          l. hageman, d. young
c                          academic press, 1981
c
c     **************************************************
c     *               important note                   *
c     *                                                *
c     *      when installing itpackv routines on a     *
c     *  different computer, reset some of the values  *
c     *  in  subroutne dfault.   most important are    *
c     *                                                *
c     *   srelpr      machine relative precision       *
c     *   rparm(1)    stopping criterion               *
c     *                                                *
c     *   also change system-dependent routine         *
c     *                                                *
c     **************************************************
c
c ... variables in common block - itcom1
c
c     in     - iteration number
c     is     - iteration number when parameters last changed
c     isym   - symmetric/nonsymmetric case switch
c     itmax  - maximum number of iterations allowed
c     level  - level of output control switch
c     nout   - output unit number
c
c ... variables in common block - itcom2
c
c     adapt  - fully adaptive procedure switch
c     betadt - switch for adaptive determination of beta
c     caseii - adaptive procedure case switch
c     halt   - stopping test switch
c     partad - partially adaptive procedure switch
c
c ... variables in common block - itcom3
c
c     bdelnm - two norm of b times delta-super-n
c     betab  - estimate for the spectral radius of lu matrix
c     cme    - estimate of largest eigenvalue
c     delnnm - inner product of pseudo-residual at iteration n
c     delsnm - inner product of pseudo-residual at iteration s
c     ff     - adaptive procedure damping factor
c     gamma  - acceleration parameter
c     omega  - overrelaxation parameter for sor and ssor
c     qa     - pseudo-residual ratio
c     qt     - virtual spectral radius
c     rho    - acceleration parameter
c     rrr    - adaptive parameter
c     sige   - parameter sigma-sub-e
c     sme    - estimate of smallest eigenvalue
c     specr  - spectral radius estimate for ssor
c     srelpr - machine relative precision
c     stptst - stopping parameter
c     udnm   - two norm of u
c     zeta   - stopping criterion
c
c ... initialize common blocks
c
      ier = 0
      level = iparm(2)
      nout = iparm(4)
      if (level.ge.1) write (nout,10)
   10 format (///1x,'i t p a c k      j c g      ')
      if (iparm(1).le.0) go to 370
c     if (iparm(11).eq.0) timj1 = timer(0.0)
      call echall (n,ndim,maxnz,jcoef,coef,rhs,iparm,rparm,1)
      temp = 500.0*srelpr
      if (zeta.ge.temp) go to 30
      if (level.ge.1) write (nout,20) zeta,srelpr,temp
   20 format (/1x,'*** w a r n i n g ************'//1x,
     *      '    in itpackv routine jcg'/1x,
     *      '    rparm(1) =',e10.3,' (zeta)'/1x,
     *      '    a value this small may hinder convergence '/1x,
     *      '    since machine precision srelpr =',e10.3/1x,
     *      '    zeta reset to ',e10.3)
      zeta = temp
   30 continue
      time1 = rparm(9)
      time2 = rparm(10)
      digit1 = rparm(11)
      digit2 = rparm(12)
c
c ... verify n
c
      if (n.gt.0) go to 50
      ier = 11
      if (level.ge.0) write (nout,40) n
   40 format (/1x,'*** f a t a l     e r r o r ************'//1x,
     *        '    called from itpackv routine jcg '/1x,
     *        '    invalid matrix dimension, n =',i8)
      go to 370
c
c ... scale linear system, u, and rhs by the square root of the
c ... diagonal elements.
c
   50 continue
      call scal (n,ndim,maxnz,jcoef,coef,rhs,u,wksp,ier)
      if (ier.eq.0) go to 70
      if (level.ge.0) write (nout,60) ier
   60 format (/1x,'*** f a t a l     e r r o r ************'//1x,
     *   '    called from itpackv routine jcg '/1x,
     *   '    error detected in routine  scal  '/1x,
     *   '    which scales the system   '/1x,
     *   '    ier = ',i5)
      go to 370
c
c ... remove rows and columns if requested
c
   70 continue
      if (iparm(10).eq.0) go to 80
      tol = rparm(8)
      call sbelm (n,ndim,maxnz,jcoef,coef,rhs,wksp,tol)
c
c ... initialize wksp base addresses.
c
   80 ib1 = 1
      ib2 = ib1+n
      ib3 = ib2+n
      ib4 = ib3+n
      ib5 = ib4+n
c
c ... permute to  red-black system if requested
c
      nb = iparm(9)
      if (nb.ge.0) go to 110
      if (nb.le.-2) go to 170
      n3 = n*3
      do 90 i = 1,n3
         iwksp(i) = 0
   90 continue
      call prbndx (n,ndim,maxnz,jcoef,iwksp,iwksp(ib2),nb,level,nout,
     *   ier)
      if (ier.eq.0) go to 110
      if (level.ge.0) write (nout,100) ier,nb
  100 format (/1x,'*** f a t a l     e r r o r ************'//1x,
     *   '    called from itpackv routine jcg  '/1x,
     *   '    error detected in routine  prbndx'/1x,
     *   '    which computes the red-black indexing'/1x,
     *   '    ier = ',i5,' iparm(9) = ',i5,' (nb)')
      go to 350
  110 if (nb.ge.0.and.nb.le.n) go to 130
      ier = 14
      if (level.ge.0) write (nout,120) ier,nb
  120 format (/1x,'*** f a t a l     e r r o r ************'//1x,
     *   '    called from itpackv routine jcg      '/1x,
     *   '    error detected in red-black suTAUBYstem index'/1x,
     *   '    ier = ',i5,' iparm(9) =',i5,' (nb)')
      go to 350
  130 if (nb.ne.0.and.nb.ne.n) go to 150
      nbo = nb
      nb = n/2
      if (level.ge.2) write (nout,140) nbo,nb
  140 format (/10x,' nb = ',i5,' implies matrix is diagonal'/10x,
     *   ' nb reset to ',i5)
c
c ... permute matrix and rhs
c
  150 if (level.ge.2) write (nout,160) nb
  160 format (/10x,'order of black suTAUBYstem = ',i5,' (nb)')
      if (iparm(9).ge.0) go to 170
      call permat (n,ndim,maxnz,jcoef,coef,iwksp,wksp,iwksp(ib3))
      call pervec (n,iwksp,rhs,wksp)
      call pervec (n,iwksp,u,wksp)
c
c ... check for sufficient workspace.
c
  170 iparm(8) = 4*n+4*itmax
      if (nw.ge.iparm(8)) go to 190
      ier = 12
      if (level.ge.0) write (nout,180) nw,iparm(8)
  180 format (/1x,'*** f a t a l     e r r o r ************'//1x,
     *   '    called from itpackv routine jcg '/1x,
     *   '    not enough workspace at ',i10/1x,
     *   '    set iparm(8) =',i10,' (nw)')
      go to 330
c
  190 continue
      if (level.le.2) go to 220
      write (nout,200)
  200 format (///1x,'in the following, rho and gamma are',
     *   ' acceleration parameters')
      if (adapt) write (nout,210)
  210 format (1x,'cme is the estimate of the largest eigenvalue of',
     *   ' the jacobi matrix')
  220 continue
c     if (iparm(11).eq.0) timi1 = timer(0.0)
c
c ... compute initial pseudo-residual
c
      do 230 i = 1,nw
         wksp(i) = 0.0
  230 continue
      call scopy (n,rhs,1,wksp(ib2),1)
      call pjac (n,ndim,maxnz,jcoef,coef,u,wksp(ib2))
      do 240 i = 1,n
         wksp(n+i) = wksp(n+i)-u(i)
  240 continue
c
c ... iteration sequence
c
      itmax1 = itmax+1
      do 260 loop = 1,itmax1
         in = loop-1
         if (mod(in,2).eq.1) go to 250
c
c ... code for the even iterations.
c
c     u           = u(in)             wksp(ib2) = del(in)
c     wksp(ib1)   = u(in-1)           wksp(ib3) = del(in-1)
c
         call itjcg (n,ndim,maxnz,jcoef,coef,u,wksp(ib1),wksp(ib2),
     *      wksp(ib3),wksp(ib4),wksp(ib5))
c
         if (halt) go to 290
         go to 260
c
c ... code for the odd iterations.
c
c     u           = u(in-1)           wksp(ib2) = del(in-1)
c     wksp(ib1)   = u(in)             wksp(ib3) = del(in)
c
  250    call itjcg (n,ndim,maxnz,jcoef,coef,wksp(ib1),u,wksp(ib3),
     *      wksp(ib2),wksp(ib4),wksp(ib5))
c
         if (halt) go to 290
  260 continue
c
c..... itmax has been reached
c
      if (iparm(11).ne.0) go to 270
c     timi2 = timer(0.0)
c     time1 = timi2-timi1
  270 ier = 13
      if (level.ge.1) write (nout,280) itmax
  280 format (/1x,'*** w a r n i n g ************'//1x,
     *   '    in itpackv routine jcg'/1x,
     *   '    failure to converge in',i5,' iterations')
      if (iparm(3).eq.0) rparm(1) = stptst
      go to 320
c
c ... method has converged
c
  290 if (iparm(11).ne.0) go to 300
c     timi2 = timer(0.0)
c     time1 = timi2-timi1
  300 if (level.ge.1) write (nout,310) in
  310 format (/1x,'jcg  has converged in ',i5,' iterations')
c
c ... put solution into u if not already there.
c
  320 continue
      if (mod(in,2).eq.1) call scopy (n,wksp,1,u,1)
c
c ... un-permute matrix,rhs, and solution
c
  330 if (iparm(9).ne.-1) go to 340
      call permat (n,ndim,maxnz,jcoef,coef,iwksp(ib2),wksp(ib4),
     *   iwksp(ib3))
      call pervec (n,iwksp(ib2),rhs,wksp(ib4))
      call pervec (n,iwksp(ib2),u,wksp(ib4))
      if (ier.eq.12) go to 350
c
c ... optional error analysis
c
  340 idgts = iparm(12)
      if (idgts.lt.0) go to 350
      if (iparm(2).le.0) idgts = 0
      call peror (n,ndim,maxnz,jcoef,coef,rhs,u,wksp,digit1,digit2,
     *   idgts)
c
c ... unscale the matrix, solution, and rhs vectors.
c
  350 continue
      call unscal (n,ndim,maxnz,jcoef,coef,rhs,u,wksp)
c
c ... set return parameters in iparm and rparm
c
      iparm(8) = iparm(8)-4*(itmax-in)
      if (iparm(11).ne.0) go to 360
c     timj2 = timer(0.0)
c     time2 = timj2-timj1
      time2 = 0.0
  360 if (iparm(3).ne.0) go to 370
      iparm(1) = in
      iparm(9) = nb
      rparm(2) = cme
      rparm(3) = sme
      rparm(9) = time1
      rparm(10) = time2
      rparm(11) = digit1
      rparm(12) = digit2
c
  370 continue
      if (level.ge.3) call echall (n,ndim,maxnz,jcoef,coef,rhs,iparm,
     *   rparm,2)
      if (ier.eq.0.and.level.ge.1) write (nout,380)
  380 format (/1x,'execution successful')
c
      return
      end subroutine


      subroutine itjcg (n,ndim,maxnz,jcoef,coef,u,u1,d,d1,dtwd,tri)
      implicit none
C
      integer n,ndim,maxnz,i,j
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz)
      real(sz) u(n),u1(n),d(n),d1(n),dtwd(n),tri(*)
      real(sz) gamold,rhoold,rhotmp,dnrm,con,dtnrm,c1,c2,c3,c4
      real(sz) dumy1(1),dumy2(1),del3nrms(3),unorm
      logical q1
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... itjcg performs one iteration of the jacobi conjugate gradient
c     algorithm.  it is called by jcg.
c
c ... parameter list --
c
c          n      input integer.  dimension of the matrix.
c          ndim   row dimension of jcoef and coef arrays in calling
c                   routine
c          maxnz  maximum number of nonzeros per row
c          jcoef  integer sparse matrix representation
c          coef   sparse matrix representation
c          u      input vector.  contains the value of the
c                 solution vector at the end of in iterations.
c          u1     input/output vector.  on input, it contains
c                 the value of the solution at the end of the in-1
c                 iteration.  on output, it will contain the newest
c                 estimate for the solution vector.
c          d      input vector.  contains the pseudo-residual
c                 vector after in iterations.
c          d1     input/output vector.  on input, d1 contains
c                 the pseudo-residual vector after in-1 iterations.  on
c                 output, it will contain the newest pseudo-residual
c                 vector.
c          dtwd   array.  used in the computations of the
c                 acceleration parameter gamma and the new pseudo-
c                 residual.
c          tri    array.  stores the tridiagonal matrix associated
c                 with the eigenvalues of the conjugate gradient
c                 polynomial.
c
c ... local itpackv references --
c          chgcon, iterm , parcon, pjac  , pstop 
c
c     description of variables in common blocks in routine jcg
c
c ... compute new estimate for cme if adapt = .true.
c
      save

      if (adapt) call chgcon (itmax,tri,gamold,rhoold,1)
c
C   ...UPDATE PSEUDO-RESIDUAL VECTOR "d" OF SIZE "n"
C   ...BEFORE PERFORMING ONE JACOBI ITERATION
C


 
      do 10 i = 1,n
         dtwd(i) = 0.0d0
   10 continue
      call pjac (n,ndim,maxnz,jcoef,coef,d,dtwd)

C       
c ... test for stopping
c
       if (q1 .OR.  ((in .gt.5) .AND. 
     *        (mod(in,5).ne. 0))) then


      delnnm = sdot(n,d,1,d,1)
      dtnrm = sdot(n,d,1,dtwd,1)


        else


      delnnm = sdot(n,d,1,d,1)
      dtnrm = sdot(n,d,1,dtwd,1)
      unorm = sdot(n,u,1,u,1)

       end if

      dnrm = delnnm
      con = cme
      call pstop_nrms (n,unorm,dnrm,con,1,q1)
      if (halt) go to 50
 


       ! ... compute rho and gamma - acceleration parameters
 

   20 call parcon (dtnrm,c1,c2,c3,c4,gamold,rhoold,1)
c
c ... compute u(in+1) and d(in+1)
c
   30 do 40 i = 1,n
         u1(i) = c1*d(i)+c2*u(i)+c3*u1(i)
         d1(i) = c1*dtwd(i)+c4*d(i)+c3*d1(i)
   40 continue

c
c ... output intermediate information
c
   50 call iterm (n,coef,u,dtwd,1)
c
      return
      end subroutine


      subroutine peror (n,ndim,maxnz,jcoef,coef,rhs,u,work,
     *                   digit1,digit2,idgts)
      implicit none
      integer i,n,ndim,maxnz,idgts
      integer jcoef(ndim,maxnz)
      real(sz)  digit1,digit2,bnrm,rnrm,temp
      real(sz) coef(ndim,maxnz),rhs(n),u(n),work(n)
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c     peror computes the residual, r = rhs - a*u.  the user
c     also has the option of printing the residual and/or the
c     unknown vector depending on idgts.
c
c ... parameter list --
c
c          n      dimension of matrix
c          ndim   row dimension of jcoef and coef in calling routine
c          maxnz  maximum number of nonzeros per row
c          jcoef  integer array of sparse matrix representation
c          coef   array of sparse matrix representation
c          rhs    right hand side of matrix problem
c          u      latest estimate of solution
c          work   workspace vector of length 2*n
c          digit1 output - measure of accuracy of stopping test
c          digit2 output - measure of accuracy of solution
c          idgts   parameter controlling level of output
c                    if idgts < 1 or idgts > 4, then no output.
c                            = 1, then number of digits is printed, pro-
c                                 vided level .ge. 1
c                            = 2, then solution vector is printed, pro-
c                                 vided level .ge. 1
c                            = 3, then residual vector is printed, pro-
c                                 vided level .ge. 1
c                            = 4, then both vectors are printed, pro-
c                                 vided level .ge. 1
c
c ... local itpackv references --
c
c          pmult , vout
c
c ... specifications for arguments
c
c
c     description of variables in common block in main routine
c
      digit1 = 0.0
      digit2 = 0.0
      if (n.le.0) go to 70
c
      digit1 = -log10(abs(srelpr))
      if (stptst.gt.0.0) digit1 = -log10(abs(stptst))
      do 10 i = 1,n
         work(i) = rhs(i)/coef(i,1)
   10 continue


      bnrm = sdot(n,work,1,work,1)


      if (bnrm.eq.0.0) go to 30
      call pmult (n,ndim,maxnz,jcoef,coef,u,work)
      do 20 i = 1,n
         work(i) = (rhs(i)-work(i))/coef(i,1)
   20 continue


      rnrm = sdot(n,work,1,work,1)



      temp = rnrm/bnrm
      if (temp.eq.0.0) go to 30
      digit2 = -log10(abs(temp))/2.0d0
      go to 40
c
   30 digit2 = -log10(abs(srelpr))
c
   40 if ((idgts.lt.1).or.(level.le.0)) go to 70
      write (nout,50) digit1,digit2
   50 format (/10x,'approx. no. of digits in stopping test =',
     *                f5.1,'  (digit1)'
     *        /10x,'approx. no. of digits in ratio test    =',
     *                f5.1,'  (digit2)')
c
      if (idgts.le.1.or.idgts.gt.4) go to 70
      if (idgts.ge.3) call vout (n,work,1,nout)
      do 60 i = 1,n
         work(i) = u(i)*coef(i,1)
   60 continue
      if (idgts.ne.3) call vout (n,work,2,nout)
c
   70 continue
      return
      end subroutine

      subroutine pstop (n,u,dnrm,ccon,iflag,q1)
      implicit none
      integer n,iflag
      logical q1
      real(sz) u(n),dnrm,con,ccon,uold,tr,tl
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c     pstop performs a test to see if the iterative
c     method has converged to a solution inside the error
c     tolerance, zeta.
c
c ... parameter list --
c
c          n      order of system
c          u      present solution estimate
c          dnrm   inner product of pseudo-residuals at preceding
c                    iteration
c          con    stopping test parameter (= ccon)
c          iflag  stopping test integer flag
c                    iflag = 0,  sor iteration zero
c                    iflag = 1,  non-rs method
c                    iflag = 2,  rs method
c          q1     stopping test logical flag
c
c
c     description of variables in common block in main routine
c
      con = ccon
      halt = .false.
c
c     special procedure for zeroth iteration
c
      if (in.ge.1) go to 10
      q1 = .false.
      udnm = 1.0d0
      stptst = 1000.0d0
      if (iflag.le.0) return
c
c ... test if udnm needs to be recomputed
c
   10 continue
      if (q1) go to 20
      if ((in.gt.5).and.(mod(in,5).ne.0)) go to 20
      uold = udnm


      udnm = sdot(n,u,1,u,1)


      if (udnm.eq.0.0) udnm = 1.0d0
      if ((in.gt.5).and.(abs(udnm-uold).le.udnm*zeta)) q1 = .true.
c
c ... compute stopping test
c
   20 tr = sqrt(udnm)
      tl = 1.0d0
      if (con.eq.1.0d0) go to 40
      if (iflag.eq.2) go to 30
      tl = sqrt(dnrm)
      tr = tr*(1.0d0-con)
      go to 40
   30 tl = sqrt(2.0d0*dnrm)
      tr = tr*(1.0d0-con*con)
   40 stptst = tl/tr
      if (tl.ge.tr*zeta) return
      halt = .true.
c
      return
      end subroutine


      subroutine pstop_nrms (n,unrm,dnrm,ccon,iflag,q1)
      implicit none
      integer n,iflag
      logical q1
      real(sz) unrm,dnrm,con,ccon,uold,tr,tl
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c     pstop performs a test to see if the iterative
c     method has converged to a solution inside the error
c     tolerance, zeta.
c
c ... parameter list --
c
c          n      order of system
c          u      present solution estimate
c          dnrm   inner product of pseudo-residuals at preceding
c                    iteration
c          con    stopping test parameter (= ccon)
c          iflag  stopping test integer flag
c                    iflag = 0,  sor iteration zero
c                    iflag = 1,  non-rs method
c                    iflag = 2,  rs method
c          q1     stopping test logical flag
c
c
c     description of variables in common block in main routine
c
      con = ccon
      halt = .false.
c
c     special procedure for zeroth iteration
c
      if (in.ge.1) go to 10
      q1 = .false.
      udnm = 1.0d0
      stptst = 1000.0d0
      if (iflag.le.0) return
c
c ... test if udnm needs to be recomputed
c
   10 continue
      if (q1) go to 20
      if ((in.gt.5).and.(mod(in,5).ne.0)) go to 20
      uold = udnm

      udnm = unrm

      if (udnm.eq.0.0) udnm = 1.0d0
      if ((in.gt.5).and.(abs(udnm-uold).le.udnm*zeta)) q1 = .true.
c
c ... compute stopping test
c
   20 tr = sqrt(udnm)
      tl = 1.0d0
      if (con.eq.1.0d0) go to 40
      if (iflag.eq.2) go to 30
      tl = sqrt(dnrm)
      tr = tr*(1.0d0-con)
      go to 40
   30 tl = sqrt(2.0d0*dnrm)
      tr = tr*(1.0d0-con*con)
   40 stptst = tl/tr
      if (tl.ge.tr*zeta) return
      halt = .true.
c
      return
      end subroutine


      subroutine chgcon (ldt,tri,gamold,rhoold,ibmth)
      implicit none
      integer ldt,ibmth,ip,ier
      real(sz) tri(ldt,4)
      real(sz) gamold,rhoold,cmold,start,end1
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... chgcon computes the new estimate for the largest eigenvalue
c     for conjugate gradient acceleration.
c
c ... parameter list --
c
c          ldt    leading dimension of tri
c          tri    tridiagonal matrix associated with the eigenvalues
c                    of the conjugate gradient polynomial
c          gamold
c            and
c          rhoold previous values of acceleration parameters
c          ibmth  indicator of basic method being accelerated by cg
c                      ibmth = 1,  jacobi
c                            = 2,  reduced system
c                            = 3,  ssor
c
c ... local itpackv references --
c
c          eigvns, eigvss
      save
      go to (10,20,30), ibmth
c
c ... jacobi conjugate gradient
c
   10 start = cme
      ip = in
      go to 40
c
c ... reduced system cg
c
   20 start = cme**2
      ip = in
      go to 40
c
c ... ssor cg
c
   30 if (adapt) start = spr
      if (.not.adapt) start = specr
      ip = in-is
c
c ... define the matrix
c
   40 if (ip.ge.2) go to 60
      if (ip.eq.1) go to 50
c
c ... ip = 0
c
      end1 = 0.0
      cmold = 0.0
      go to 110
c
c ... ip = 1
c
   50 end1 = 1.0D0-1.0D0/gamma
      tri(1,1) = end1
      tri(1,2) = 0.0D0
      go to 110
c
c ... ip > 1
c
   60 if (abs(start-cmold).le.zeta*start) go to 120
      cmold = start
c
c ... compute the largest eigenvalue
c
      tri(ip,1) = 1.0d0-1.0d0/gamma
      tri(ip,2) = (1.0d0-rho)/(rho*rhoold*gamma*gamold)
      if (isym.ne.0) go to 80
      end1 = eigvss(ip,tri,start,zeta,itmax,ier)
      if (ier.eq.0) go to 100
      if (level.ge.2) write (nout,70) ier
   70 format (/10x,'difficulty in computation of maximum eigenvalue'/
     *         15x,'of iteration matrix'/
     *         10x,'routine zbrent returned ier =',i5)
      go to 100
   80 continue
      end1 = eigvns(ldt,ip,tri,tri(1,3),tri(1,4),ier)
      if (ier.eq.0) go to 100
      if (level.ge.2) write (nout,90) ier
   90 format (/10x,'difficulty in computation of maximum eigenvalue'/
     *         15x,'of iteration matrix'/
     *         10x,'routine eqrt1s returned ier =',i5)
  100 continue
      if (ier.ne.0) go to 130
c
c ... set spectral radius for the various methods
c
  110 if (ibmth.eq.1) cme = end1
      if (ibmth.eq.2) cme = sqrt(abs(end1))
      if (ibmth.eq.3.and.adapt) spr = end1
      if (ibmth.eq.3.and..not.adapt) specr = end1
      return
c
c ... relative change in cme is less than zeta.  therefore stop
c     changing.
c
  120 adapt = .false.
      partad = .false.
      return
c
c ... estimate for cme > one.  therefore need to stop adaptive
c     procedure and keep old value of cme.
c
  130 adapt = .false.
      partad = .false.
      if (level.ge.2) write (nout,140) in,start
  140 format (/10x,'estimate of maximum eigenvalue of jacobi   '/15x,
     *   'matrix (cme) not accurate'/10x,
     *   'adaptive procedure turned off at iteration ',i5/10x,
     *   'final estimate of maximum eigenvalue =',e15.7/)
c
      return
      end  subroutine

      real(sz) function determ (ldt,n,tri,wk1,wk2,xlmda)
      implicit none
      integer ldt,n,i,l
      real(sz) xlmda
      real(sz) tri(ldt,2),wk1(n),wk2(n)
c
c     determ computes the determinant of a symmetric
c     tridiagonal matrix given by tri. det(tri - xlmda*i) = 0
c
c ... parameter list --
c
c          ldt    leading dimension of array tri
c          n      order of tridiagonal system
c          tri    symmetric tridiagonal matrix of order n
c          wk1,   workspace vectors of length n
c           wk2
c          xlmda  argument for characteristic equation
c
c
      do 10 i = 1,n
         wk1(i) = tri(i,1)-xlmda
   10 continue
      wk2(n) = wk1(n)
      wk2(n-1) = wk1(n-1)*wk2(n)+tri(n,2)
      if (n.eq.2) go to 30
c
c ... beginning of loop
c
      do 20 l = n-2,1,-1
         wk2(l) = wk1(l)*wk2(l+1)+tri(l+1,2)*wk2(l+2)
   20 continue
c
c     wk2(1) = solrn (n,wk1(-1),-1,tri(0,2),-1,wk2,-1)
c
c ... determinant computed
c
   30 determ = wk2(1)
c
      return
      end  function


      subroutine dfault (iparm,rparm)
      implicit none
      integer iparm(12)
      real(sz) rparm(12), temp
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... dfault sets the default values of iparm and rparm.
c
c ... parameter list --
c
c          iparm
c           and
c          rparm  arrays specifying options and tolerances
c
c ... specifications for arguments
c
c
c     description of variables in common blocks in main routine
c
c     srelpr  - computer precision (approx.)
c     if installer of package does not know srelpr value,
c     an approximate value can be determined from a simple
c     fortran program such as
c
c     srelpr = 1.0d0
c   2 srelpr = 0.5d0*srelpr
c     temp = srelpr + 1.0d0
c     if (temp .gt. 1.0d0)  go to 2
c     srelpr = 2.0d0*srelpr
c     write (6,3) srelpr
c   3 format (5x,e15.8)
c     stop
c     end
c
c     some values are-
c
c     srelpr = 7.1e-15   for cray x-mp, y-mp  (approx.) 2**-47
c          = 1.49e-8   for dec 10  (approx.) 2**-26
c          = 1.192e-7  for vax 11/780 (approx) 2**-23
c          = 1.192e-7  for Sun Spark Station 2 (approx) 2**-23
c          = 1.192e-7  for IBM RISC 6000 2 (approx) 2**-23
c          = 4.768e-7  for ibm 370/158
C          = 0.5960E-7 for Lahey fortran on ALR (486 PC) rl 12/92
c          = 0.5960E-7 for Vax 6000
c             *** should be changed for other machines ***
c
c     to facilitate convergence, rparm(1) should be set to
c          500.*srelpr or larger
c
cvjp--Determine macheps 
c
      srelpr = 1.0d0
    2 srelpr = 0.5d0*srelpr
      temp = srelpr + 1.0D0
      if (temp .gt. 1.0d0)  go to 2
      srelpr = 2.0d0*srelpr
c
      iparm(1) = 100
      iparm(2) = 0
      iparm(3) = 0
      iparm(4) = 6
      iparm(5) = 0
      iparm(6) = 1
      iparm(7) = 1
      iparm(8) = 0
      iparm(9) = -2
      iparm(10) = 0
      iparm(11) = 0
      iparm(12) = 0
c
      rparm(1) = 512.d0*srelpr
      rparm(2) = 0.0d0
      rparm(3) = 0.0d0
      rparm(4) = .75d0
      rparm(5) = 1.0d0
      rparm(6) = 0.0d0
      rparm(7) = .25d0
      rparm(8) = 100.0d0*srelpr
      rparm(9) = 0.0d0
      rparm(10) = 0.0d0
      rparm(11) = 0.0d0
      rparm(12) = 0.0d0
c
      return
      end  subroutine

      subroutine echall (n,ndim,maxnz,jcoef,coef,rhs,iparm,rparm,icall)
      implicit none
      integer n,i,j,ndim,maxnz,icall
      integer jcoef(ndim,maxnz),iparm(12)
      real(sz) coef(ndim,maxnz),rhs(n),rparm(12)
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... echall initializes the itpackv common blocks from the
c ... information contained in iparm and rparm. echall also prints the
c ... values of all the parameters in iparm and rparm.
c
c ... parameter list --
c
c          iparm
c           and
c          rparm  arrays of parameters specifying options and
c                    tolerances
c          icall  indicator of which parameters are being printed
c                    icall = 1,  initial parameters
c                    icall = 2,  final parameters
c
c ... specifications for arguments
c
c     description of variables in common blocks in main routine
c
      if (icall.ne.1) go to 120
c
c ... initialize itpackv common
c
      zeta = rparm(1)
      cme = rparm(2)
      sme = rparm(3)
      ff = rparm(4)
      omega = rparm(5)
      specr = rparm(6)
      betab = rparm(7)
      itmax = iparm(1)
      level = iparm(2)
      isym = iparm(5)
c
      adapt = .false.
      partad = .false.
      betadt = .false.
      if (iparm(6).eq.1.or.iparm(6).eq.3) adapt = .true.
      if (iparm(6).eq.1) betadt = .true.
      if (iparm(6).eq.2) partad = .true.
c
      caseii = .false.
      if (iparm(7).eq.2) caseii = .true.
      if (caseii) sme = -cme
      if (.not.caseii.and.sme.eq.0.0) sme = -1.0
      spr = sme
c
c ... set rest of common variables to zero
c
      in = 0
      is = 0
      halt = .false.
      bdelnm = 0.0
      delnnm = 0.0
      delsnm = 0.0
      gamma = 0.0
      qa = 0.0
      qt = 0.0
      rho = 0.0
      rrr = 0.0
      sige = 0.0
      stptst = 0.0
      udnm = 0.0
c
      if (level.le.4) go to 100
c
c     this section of echall causes printing of the linear system and
c     the iterative parameters
c
      write (nout,10)
   10 format (///5x,'the linear system is as follows')
      write (nout,20)
   20 format (/2x,'jcoef array')
      do 30 i = 1,n
         write (nout,40) (jcoef(i,j),j=1,maxnz)
   30 continue
   40 format (1x,8(1x,i8))
      write (nout,50)
   50 format (/2x,'coef array')
      do 60 i = 1,n
         write (nout,70) (coef(i,j),j=1,maxnz)
   60 continue
   70 format (1x,5(2x,g14.6))
      write (nout,80)
   80 format (/2x,'rhs array')
      write (nout,90) (rhs(i),i=1,n)
   90 format (1x,5g16.6)
  100 if (level.le.2) return
      write (nout,110)
  110 format (///5x,'initial iterative parameters'/)
      go to 140
  120 write (nout,130)
  130 format (///5x,'final iterative parameters'/)
  140 write (nout,150) iparm(1),level,iparm(3),nout,isym,iparm(6)
  150 format (10x,'iparm(1)  =',i15,4x,'(itmax)'/
     *        10x,'iparm(2)  =',i15,4x,'(level)'/
     *        10x,'iparm(3)  =',i15,4x,'(ireset)'/
     *        10x,'iparm(4)  =',i15,4x,'(nout)'/
     *        10x,'iparm(5)  =',i15,4x,'(isym)'/
     *        10x,'iparm(6)  =',i15,4x,'(iadapt)')
      write (nout,160) iparm(7),iparm(8),iparm(9),iparm(10),iparm(11),
     *   iparm(12)
  160 format (10x,'iparm(7)  =',i15,4x,'(icase)'/
     *        10x,'iparm(8)  =',i15,4x,'(nwksp)'/
     *        10x,'iparm(9)  =',i15,4x,'(nb)'/
     *        10x,'iparm(10) =',i15,4x,'(iremove)'/
     *        10x,'iparm(11) =',i15,4x,'(itime)'/
     *        10x,'iparm(12) =',i15,4x,'(idgts)')
      write (nout,170) zeta,cme,sme,ff,omega,specr
  170 format (10x,'rparm(1)  =',e15.8,4x,'(zeta)'/
     *        10x,'rparm(2)  =',e15.8,4x,'(cme)'/
     *        10x,'rparm(3)  =',e15.8,4x,'(sme)'/
     *        10x,'rparm(4)  =',e15.8,4x,'(ff)'/
     *        10x,'rparm(5)  =',e15.8,4x,'(omega)'/
     *        10x,'rparm(6)  =',e15.8,4x,'(specr)')
      write (nout,180) betab,rparm(8),rparm(9),rparm(10),rparm(11),
     *   rparm(12)
  180 format (10x,'rparm(7)  =',e15.8,4x,'(betab)'/
     *        10x,'rparm(8)  =',e15.8,4x,'(tol)'/
     *        10x,'rparm(9)  =',e15.8,4x,'(time1)'/
     *        10x,'rparm(10) =',e15.8,4x,'(time2)'/
     *        10x,'rparm(11) =',e15.8,4x,'(digit1)'/
     *        10x,'rparm(12) =',e15.8,4x,'(digit2)')
c
      return
      end  subroutine


      real(sz) function eigvns (ldt,n,tri,d,e2,ier)
      implicit none
      integer ldt,n,i,ier
      real(sz) tri(ldt,*),d(n),e2(n)
c
c ... eigvns computes the largest eigenvalue of a symmetric
c     tridiagonal matrix for conjugate gradient acceleration.
c
c ... parameter list --
c
c          ldt    leading dimension of tri
c          n      order of tridiagonal system
c          tri    symmetric tridiagonal matrix of order n
c          d      array for eqrt1s (negative diagonal elements)
c          e2     array for eqrt1s (super diagonal elements)
c          ier    error flag -- on return, ier=0 indicates that
c                    the largest eigenvalue of tri was found.
c
c ... local itpackv references --
c
c          eqrt1s
c
c ... specifications for arguments
c
c
      eigvns = 0.0
c
      d(1) = -tri(1,1)
      do 10 i = 2,n
         d(i) = -tri(i,1)
         e2(i) = abs(tri(i,2))
   10 continue
c
      call eqrt1s (d,e2,n,1,0,ier)
      eigvns = -d(1)
c
      return
      end function 


      real(sz) function eigvss (n,tri,start,zeta,itmax,ier)
      implicit none
      integer n,itmax,itmp,ier,maxfn,nsig
      real(sz) tri(*),start,eps,a,b,zeta
c
c ... eigvss computes the largest eigenvalue of a symmetric
c     tridiagonal matrix for conjugate gradient acceleration.
c     modified imsl routine zbrent used.
c
c ... parameter list --
c
c          n      order of tridiagonal system
c          tri    symmetric tridiagonal matrix of order n
c          start  initial lower bound of interval containing root
c          zeta   stopping criteria
c          ier    error flag -- on return, ier = 0 indicates that
c                    the largest eigenvalue of tri was found.
c
c ... local itpackv references --
c
c          zbrent
c
c ... specifications for arguments
c
c
      eigvss = 0.0d0
      itmp = int(-log10(abs(zeta)))
      nsig = max0(itmp,4)
      maxfn = max0(itmax,50)
      eps = 0.0d0
      a = start
      b = 1.0d0
      call zbrent (n,tri,eps,nsig,a,b,maxfn,ier)
      eigvss = b
c
      return
      end  function


      subroutine eqrt1s (d,e2,n,m,isw,ier)
      implicit none
      integer n,m,i,j,k,isw,ier,ii,k1
      real(sz) d(n),e2(n),err,s,tot,p,q,qp,r,delta,f,ep,dlam
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c   modified imsl routine name   - eqrt1s
c
c-----------------------------------------------------------------------
c
c   computer            - cdc/single
c
c   latest revision     - june 1, 1980
c
c   purpose             - smallest or largest m eigenvalues of a
c                           symmetric tridiagonal matrix
c
c   usage               - call eqrt1s (d,e2,n,m,isw,ier)
c
c   arguments    d      - input vector of length n containing
c                           the diagonal elements of the matrix.  the
c                           computed eigenvalues replace the first m
c                           components of the vector d in non-
c                           decreasing sequence, while the remaining
c                           components are lost.
c                e2     - input vector of length n containing
c                           the squares of the off-diagonal elements
c                           of the matrix.  input e2 is destroyed.
c                n      - input scalar containing the order of the
c                           matrix.
c                m      - input scalar containing the number of
c                           smallest eigenvalues desired (m is
c                           less than or equal to n).
c                isw    - input scalar meaning as follows -
c                           isw=1 means that the matrix is known to be
c                             positive definite.
c                           isw=0 means that the matrix is not known
c                             to be positive definite.
c                ier    - error parameter. (output)
c                           warning error
c                             ier = 601 indicates that successive
c                               iterates to the k-th eigenvalue were not
c                               monotone increasing. the value k is
c                               stored in e2(1).
c                           terminal error
c                             ier = 602 indicates that isw=1 but matrix
c                               is not positive definite
c
c   precision/hardware  - single and double/h32
c                       - single/h36,h48,h60
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   remarks      as written, the routine computes the m smallest
c                eigenvalues. to compute the m largest eigenvalues,
c                reverse the sign of each element of d before and
c                after calling the routine. in this case, isw must
c                equal zero.
c
c   copyright           - 1980 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
c
c                                  srelpr = machine precision
c                                  first executable statement
c
      ier = 0
      dlam = 0.0
      err = 0.0
      s = 0.0
c
c                                  look for small sub-diagonal entries
c                                  define initial shift from lower
c                                  gerschgorin bound.
c
      tot = d(1)
      q = 0.0d0
      j = 0
      do 30 i = 1,n
         p = q
         if (i.eq.1) go to 10
         if (p.gt.srelpr*(abs(d(i))+abs(d(i-1)))) go to 20
   10    e2(i) = 0.0d0
c
c                                  count if e2(i) has underflowed
c
   20    if (e2(i).eq.0.0d0) j = j+1
         q = 0.0d0
         if (i.ne.n) q = sqrt(abs(e2(i+1)))
         tot = min(d(i)-p-q,tot)
   30 continue
      if (isw.eq.1.and.tot.lt.0.0) go to 50
      do 40 i = 1,n
         d(i) = d(i)-tot
   40 continue
      go to 60
   50 tot = 0.0d0
   60 do 190 k = 1,m
c
c                                  next qr transformation
c
   70    tot = tot+s
         delta = d(n)-s
         i = n
         f = abs(srelpr*tot)
         if (dlam.lt.f) dlam = f
         if (delta.gt.dlam) go to 90
         if (delta.ge.(-dlam)) go to 160
         ier = 602
         if (level.ge.1) write (nout,80)
   80    format (/1x,'*** w a r n i n g ************'/1x,
     *      '    in itpackv routine eqrt1s'/1x,
     *      '    parameter isw = 1 but matrix'/1x,
     *      '    not positive definite')
         go to 200
c
c                                  replace small sub-diagonal squares
c                                  by zero to reduce the incidence of
c                                  underflows
c
   90    if (k.eq.n) go to 110
         k1 = k+1
         do 100 j = k1,n
            if (e2(j).le.(srelpr*(d(j)+d(j-1)))**2) e2(j) = 0.0
  100    continue
  110    f = e2(n)/delta
         qp = delta+f
         p = 1.0
         if (k.eq.n) go to 140
         k1 = n-k
         do 130 ii = 1,k1
            i = n-ii
            q = d(i)-s-f
            r = q/qp
            p = p*r+1.0d0
            ep = f*r
            d(i+1) = qp+ep
            delta = q-ep
            if (delta.gt.dlam) go to 120
            if (delta.ge.(-dlam)) go to 160
            ier = 602
            if (level.ge.1) write (nout,80)
            go to 200
  120       f = e2(i)/q
            qp = delta+f
            e2(i+1) = qp*ep
  130    continue
  140    d(k) = qp
         s = qp/p
         if (tot+s.gt.tot) go to 70
         ier = 601
         e2(1) = k
         if (level.ge.1) write (nout,150) k
  150    format (/1x,'*** w a r n i n g ************'//1x,
     *      '    in itpackv routine eqrt1s'/1x,
     *      '    successive iterates to the',i10/1x,
     *      '    eigenvalue were not monotone increasing')
c
c                                  set error -- irregular end
c                                  deflate minimum diagonal element
c
         s = 0.0
         i = ismin(n-k+1,d(k),1)
         delta = min(qp,d(i))
c
c                                  convergence
c
  160    if (i.lt.n) e2(i+1) = e2(i)*f/qp
         if (i.eq.k) go to 180
         do 170 j = i-1,k,-1
            d(j+1) = d(j)-s
            e2(j+1) = e2(j)
  170    continue
  180    d(k) = tot
         err = err+abs(delta)
         e2(k) = err
  190 continue
      if (ier.eq.0) go to 210
  200 continue
  210 return
      end  subroutine

      subroutine iterm (n,coef,u,wk,imthd)
      implicit none
      integer n,i,ip,imthd
      real(sz) coef(n,*),u(n),wk(n),qtff
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c     iterm produces the iteration summary line at the end
c     of each iteration. if level .ge. 4, the latest approximation
c     to the solution will be printed.
c
c ... parameter list --
c
c          n      order of system or, for reduced system
c                    routines, order of black suTAUBYstem
c          coef   iteration matrix
c          u      solution estimate
c          wk     work array of length n
c          imthd  indicator of method
c                    imthd = 1,  jcg
c                    imthd = 2,  jsi
c                    imthd = 3,  sor
c                    imthd = 4,  ssorcg
c                    imthd = 5,  ssorsi
c                    imthd = 6,  rscg
c                    imthd = 7,  rssi
c
c ... specifications for arguments
c
c
c ... print various parameters after each iteration
c
      if (level.lt.2) return
      go to (10,100,140,170,50,10,100), imthd
   10 if (in.gt.0) go to 30
c
c ... print header for jcg and rscg
c
      write (nout,20)
   20 format (////5x,'intermediate output after each iteration'//
     *   ' number of',3x,'convergence',5x,'cme ',10x,'rho',8x,'gamma'/
     *   ' iterations',5x,'test '//)
c
c ... print summary line
c
   30 write (nout,40) in,stptst,cme,rho,gamma
   40 format (3x,i5,3x,5e13.5)
      if (level.ge.4) go to 200
c
      return
c
   50 if (in.gt.0) go to 70
c
c ... print header for ssor-si
c
      write (nout,60)
   60 format (////5x,'intermediate output after each iteration'//
     *   ' number of',3x,'convergence',3x,'parameter change test',8x,
     *   'rho',8x,'gamma'/' iterations',5x,'test ',6x,'lhs(qa)',4x,
     *   'rhs(qt**ff)'//)
c
c ... print summary line
c
   70 ip = in-is
      if (imthd.eq.7) ip = 2*ip
      if (ip.lt.3) go to 80
      qtff = qt**ff
      write (nout,40) in,stptst,qa,qtff,rho,gamma
      if (level.ge.4) go to 200
      return
c
   80 write (nout,90) in,stptst,rho,gamma
   90 format (3x,i5,3x,e13.5,26x,2e13.5)
      if (level.ge.4) go to 200
      return
c
  100 if (in.gt.0) go to 120
c
c ... print header for j-si and rs-si
c
      write (nout,110)
  110 format (////5x,'intermediate output after each iteration'//
     *   ' number of',3x,'convergence',3x,'parameter change test',8x,
     *   'rho'/' iterations',5x,'test ',6x,'lhs(qa)',4x,'rhs(qt**ff)'//)
c
c ... print summary line
c
  120 ip = in-is
      if (imthd.eq.7) ip = 2*ip
      if (ip.lt.3) go to 130
      qtff = qt**ff
      write (nout,40) in,stptst,qa,qtff,rho
      if (level.ge.4) go to 200
      return
c
  130 write (nout,90) in,stptst,rho
      if (level.ge.4) go to 200
      return
c
c ... print various parameters after each iteration for sor.
c
  140 if (in.gt.0) go to 160
c
c ... print header for sor
c
      write (nout,150)
  150 format (////5x,'intermediate output after each iteration'//
     *   ' number of',3x,'convergence',5x,'cme ',8x,'omega',7x,
     *   'spectral'/' iterations',5x,'test',34x,'radius'//)
c
c ... print summary line for sor
c
  160 continue
      write (nout,40) in,stptst,cme,omega,specr
      if (level.ge.4) go to 200
c
      return
c
c ... print various parameters after each iteration for ssor-cg.
c
  170 if (in.gt.0) go to 190
c
c ... print header for ssor-cg
c
      write (nout,180)
  180 format (////5x,'intermediate output after each iteration'//
     *   ' number of',3x,'convergence',2x,' spectral',5x,'s-prime',9x,
     *   'rho',8x,'gamma'/' iterations',5x,'test ',7x,'radius'//)
c
c ... print summary line for ssor-cg
c
  190 continue
      write (nout,40) in,stptst,specr,spr,rho,gamma
      if (level.ge.4) go to 200
      return
c
  200 if (imthd.gt.5) go to 220
      write (nout,210) in
  210 format (/1x,2x,'estimate of solution at iteration ',i5)
      go to 240
  220 write (nout,230) in
  230 format (/1x,2x,'estimate of solution at black points ',
     *   'at iteration ',i5)
  240 do 250 i = 1,n
         wk(i) = u(i)*coef(i,1)
  250 continue
      write (nout,260) (wk(i),i=1,n)
  260 format (1x,5g16.7)
      write (nout,270)
  270 format (//)
c
      return
      end  subroutine

      subroutine parcon (dtnrm,c1,c2,c3,c4,gamold,rhotmp,ibmth)
      implicit none
      integer ip,ibmth
      real(sz) dtnrm,c1,c2,c3,c4,gamold,rhotmp,rhoold
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... parcon computes acceleration parameters for conjugate gradient
c     acceleration methods.
c
c ... parameter list --
c
c          dtnrm  inner product of residuals
c          c1     output -- rho*gamma
c          c2     output -- rho
c          c3     output -- 1-rho
c          c4     output -- rho*(1-gamma)
c          gamold output -- value of gamma at preceding iteration
c          rhotmp last estimate for value of rho
c          ibmth  indicator of basic method being accelerated by cg
c                      ibmth = 1,   jacobi
c                            = 2,   reduced system
c                            = 3,   ssor
c
c     description of variables in common blocks in main routine
c
      ip = in-is
c
c ... set rhoold and gamold
c
      rhoold = rho
      gamold = gamma
c
c ... compute gamma (in+1)
c
c ... for jacobi or reduced system cg
c
      if (ibmth.le.2) gamma = 1.0d0/(1.0d0-dtnrm/delnnm)
c
c ... for ssor cg
c
      if (ibmth.eq.3) gamma = delnnm/dtnrm
c
c ... compute rho (in+1)
c
      rho = 1.0d0
      if (ip.eq.0) go to 20
      if (isym.eq.0) go to 10
      rho = 1.0d0/(1.0d0-gamma*rhotmp/delsnm)
      go to 20
   10 rho = 1.0d0/(1.0d0-gamma*delnnm/(gamold*delsnm*rhoold))
c
c ... compute constants c1, c2, c3, and c4
c
   20 delsnm = delnnm
      rhotmp = rhoold
      c1 = rho*gamma
      c2 = rho
      c3 = 1.0d0-rho
      c4 = rho*(1.0d0-gamma)
c
      return
      end  subroutine



      subroutine permat (n,ndim,maxnz,jcoef,coef,p,work,iwork)
c
c ... permat takes the sparse matrix representation
c     of the matrix stored in the arrays jcoef and coef and
c     permutes both rows and columns, overwriting the previous
c     structure.
c
c ... parameter list --
c
c          n         order of system
c          ndim      row dimension of arrays jcoef and coef in
c                       the calling routine
c          maxnz     maximum number of nonzero entries per row
c          jcoef     integer array for data
c          coef      array for data structure coefficients
c          p         permutation vector
c          work      workspace of length n
c          iwork     integer workspace of length n
c
c ... it is assumed that the i-th entry of the permutation vector
c     p indicates the row the i-th row gets mapped into.  (i.e.
c     if ( p(i) = j ) row i gets mapped into row j)
c
c     *** note ***  this routine is to be called after routine scal.
c
c ... specifications for arguments
c
      integer jcoef(ndim,maxnz),p(*),iwork(n)
      real(sz) coef(ndim,maxnz),work(n)
c
      if (n.le.0) return
      do 50 j = 1,maxnz
         call scopy (n,coef(1,j),1,work,1)
         do 10 i = 1,n
            iwork(i) = jcoef(i,j)
   10    continue
         do 20 i = 1,n
            coef(p(i),j) = work(i)
   20    continue
         do 30 i = 1,n
            jcoef(p(i),j) = iwork(i)
   30    continue
         do 40 i = 1,n
            jcoef(i,j) = p(jcoef(i,j))
   40    continue
   50 continue
      return
      end  subroutine


      subroutine pervec (n,p,v,work)
      implicit none
      integer i,n
      integer p(n)
      real(sz) v(n),work(n)
c
c ... pervec permutes a vector as dictated by the permutation
c ... vector p.  if p(i) = j, then v(j) gets v(i).
c
c ... parameter list --
c
c          n       length of vectors p, v, and work
c          p       integer permutation vector
c          v       vector to be permuted
c          work    workspace vector of length n
c
c
      call scopy (n,v,1,work,1)
      do 10 i = 1,n
         v(p(i)) = work(i)
   10 continue
      return
      end  subroutine

      subroutine pjac (n,ndim,maxnz,jcoef,coef,u,rhs)
      implicit none
      integer n,ndim,maxnz,maxm1
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz),u(n),rhs(n)
c
c ... pjac performs one jacobi iteration.
c
c ... parameter list --
c
c         n       dimension of matrix
c         ndim    row dimension of jcoef and coef arrays in calling
c                   routine
c         maxnz   maximum number of nonzeros per row
c         jcoef   integer data structure for coefficient columns
c         coef    data structure for array coefficients
c         u       estimate of solution of a matrix problem
c         rhs     on input -- contains the right hand side of the
c                             matrix problem
c                 on output -- contains b*u + rhs  where b = i - a
c                              and a has been scaled to have a unit
c                              diagonal
c
c
      maxm1 = maxnz-1
      call ymasx2 (ndim,n,maxm1,coef(1,2),jcoef(1,2),rhs,u)
      return
      end  subroutine

      subroutine pmult (n,ndim,maxnz,jcoef,coef,b,c)
      implicit none
      integer n,ndim,maxnz,maxm1
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz),b(n),c(n)
c
c ... pmult computes c = a*b, a matrix-vector product.  matrix
c     a is assumed to be stored in the coef, jcoef ellpack
c     data structure and all entries in the column array jcoef
c     are assumed to be between 1 and n, inclusive.
c     a is assumed to have a unit diagonal.
c
c ... parameter list --
c
c          n        dimension of matrix
c          ndim     row dimension of coef and jcoef in calling routine
c          maxnz    maximum number of nonzeros per row
c          jcoef    integer array for coefficient columns
c          coef     array for coefficients
c          b        multiplying vector of length n
c          c        product vector of length n
c
c
      call scopy (n,b,1,c,1)
      maxm1 = maxnz-1
      call ypasx2 (ndim,n,maxm1,coef(1,2),jcoef(1,2),c,b)
      return
      end  subroutine

      subroutine prbndx (n,ndim,maxnz,jcoef,p,ip,nblack,level,nout,ier)
      implicit none
      integer i,n,ndim,maxnz,nblack,level,nout,ier,ibgn,next,last,
     *  j,k,nxttyp,jcol,l,nred
      integer jcoef(ndim,maxnz),p(n),ip(n)
      integer first,old,young,curtyp,type
c
c**************************************************************
c
c     prbndx computes the red-black permutation
c     vectors p ( and its inverse ip ) if possible.
c
c     the algorithm is to mark the first node as red (arbitrary).
c     all of its adjacent nodes are marked black and placed in
c     a stack.  the remainder of the code pulls the first node
c     off the top of the stack and tries to type its adjacent nodes.
c     the typing of the adjacent point is a five way case statement
c     which is well commented below (see do loop 100).
c
c     the array p is used both to keep track of the color of a node
c     (red node is positive, black is negative) but also the father
c     node that caused the color marking of that point.  since
c     complete information on the adjacency structure is hard to come
c     by this forms a link to enable the color change of a partial
c     tree when a recoverable color conflict occurs.
c
c     the array ip is used as a stack to point to the set of nodes
c     left to be typed that are known to be adjacent to the current
c     father node.
c
c     *** note ***  this routine is to be called after routine scal.
c
c*********************************************************************
c
c     input parameters --
c
c        n      number of nodes.  (integer, scalar)
c
c        ndim   row dimension of jcoef in calling routine.
c
c        maxnz  maximum number of nonzeros per row
c
c        jcoef  array of column indices.  it is assumed
c               that for every row where only one element is
c               stored that element corresponds to the diagonal
c               entry.  the diagonal must be the first entry stored.
c                 (integer, arrays)
c
c        level  switch for printing
c
c        nout   output tape number
c
c     output parameters --
c
c        nblack number of black nodes.  number of red nodes is
c               n - nblack.  (integer, scalar)
c
c        p, ip  permutation and inverse permutation vectors.
c               (integer, arrays each of length n)
c
c        ier    error flag. (integer, scalar)
c
c               ier = 0, normal return.  indexing performed
c                        successfully
c               ier = 201, red-black indexing not possible.
c
c********************************************************************
c
c
      ier = 0
      if (n.le.0) return
      do 10 i = 1,n
         p(i) = 0
         ip(i) = 0
   10 continue
c
c ... handle the first set of points until some adjacent points
c ... are found
c
      first = 1
c
   20 p(first) = first
      if (maxnz.gt.1) go to 40
c
c ... search for next entry that has not been marked
c
      if (first.eq.n) go to 120
      ibgn = first+1
      do 30 i = ibgn,n
         if (p(i).ne.0) go to 30
         first = i
         go to 20
   30 continue
      go to 120
c
c ... first set of adjacent points found
c
   40 next = 1
      last = 1
      ip(1) = first
c
c ... loop over labeled points indicated in the stack stored in
c ... the array ip
c
   50 k = ip(next)
      curtyp = p(k)
      nxttyp = -curtyp
      do 100 j = 2,maxnz
         jcol = jcoef(k,j)
         if (jcol.eq.k) go to 100
         type = p(jcol)
c
c==================================================================
c
c     the following is a five way case statement dealing with the
c     labeling of the adjacent node.
c
c ... case i.  if the adjacent node has already been labeled with
c              label equal to nxttyp, then skip to the next adjacent
c              node.
c
         if (type.eq.nxttyp) go to 100
c
c ... case ii.  if the adjacent node has not been labeled yet label
c               it with nxttyp and enter it in the stack
c
         if (type.ne.0) go to 60
         last = last+1
         ip(last) = jcol
         p(jcol) = nxttyp
         go to 100
c
c ... case iii.  if the adjacent node has already been labeled with
c                opposite color and the same father seed, then there
c                is an irrecoverable color conflict.
c
   60    if (type.eq.curtyp) go to 140
c
c ... case iv.  if the adjacent node has the right color and a different
c               father node, then change all nodes of the youngest fathe
c               node to point to the oldest father seed and retain the
c               same colors.
c
         if (type*nxttyp.lt.1) go to 80
         old = min0(iabs(type),iabs(nxttyp))
         young = max0(iabs(type),iabs(nxttyp))
         do 70 l = young,n
            if (iabs(p(l)).eq.young) p(l) = isign(old,p(l))
   70    continue
         curtyp = p(k)
         nxttyp = -curtyp
         go to 100
c
c ... case v.  if the adjacent node has the wrong color and a different
c              father node, then change all nodes of the youngest father
c              node to point to the oldest father node along with
c              changing their colors.  since until this time the
c              youngest father node tree has been independent no other
c              color conflicts will arise from this change.
c
   80    old = min0(iabs(type),iabs(nxttyp))
         young = max0(iabs(type),iabs(nxttyp))
         do 90 l = young,n
            if (iabs(p(l)).eq.young) p(l) = isign(old,-p(l))
   90    continue
         curtyp = p(k)
         nxttyp = -curtyp
c
c ... end of case statement
c
c==================================================================
c
  100 continue
c
c ... advance to next node in the stack
c
      next = next+1
      if (next.le.last) go to 50
c
c ... all nodes in the stack have been removed
c
c ... check for nodes not labeled.  if any are found
c ... start the labeling process again at the first
c ... node found that is not labeled.
c
      ibgn = first+1
      do 110 i = ibgn,n
         if (p(i).ne.0) go to 110
         first = i
         go to 20
  110 continue
c
c===================================================================
c
c ... all nodes are now typed either red or black
c
c ... generate permutation vectors
c
  120 call whenige (n,p,1,0,ip,nred)
      call whenilt (n,p,1,0,ip(nred+1),nblack)
      do 130 i = 1,n
         p(ip(i)) = i
  130 continue
c
c ... successful red-black ordering completed
c
      return
c
c ...... type conflict
c
  140 ier = 201
      if (level.ge.0) write (nout,150)
  150 format (//1x,'*** f a t a l     e r r o r ************'//1x,
     *   '    in itpackv routine prbndx  '/1x,
     *   '    red-black indexing not possible')
      return
      end  subroutine

      subroutine sbelm (n,ndim,maxnz,jcoef,coef,rhs,work,tol)
      implicit none
      integer i,j,jcol,n,ndim,maxnz
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz),rhs(n),work(n),tol
c
c ... sbelm is designed to remove rows of the matrix for which
c ... all off-diagonal elements are very small (less than tol).
c ... this is to take care of matrices arising from finite
c ... element discretizations of partial differential equations
c ... with dirichlet boundary conditions.  any such rows and
c ... corresponding columns are then eliminated (set to the
c ... identity after correcting the rhs).
c ... *** note ***  this routine is to be called after routine scal.
c
c ... parameter list --
c
c         n       dimension of matrix
c         ndim    row dimension of arrays jcoef and coef in the
c                    calling program
c         maxnz   maximum number of nonzero entries per row
c         jcoef   integer array of matrix representation
c         coef    array of sparse matrix representation
c         rhs     right hand side of matrix problem
c         work    work array of length n
c         tol     tolerance factor
c
c
      if (n.le.0.or.maxnz.lt.2) return
c
c ... find maximum off-diagonal elements in absolute value.
c
      do 10 i = 1,n
         work(i) = 0.0
   10 continue
      do 30 j = 2,maxnz
         do 20 i = 1,n
            work(i) = max(work(i),abs(coef(i,j)))
   20    continue
   30 continue
c
c ... eliminate desired rows and columns.
c
      do 60 j = 2,maxnz
         do 50 i = 1,n
            if (work(i).lt.tol) go to 40
            jcol = jcoef(i,j)
            if (work(jcol).ge.tol) go to 50
            rhs(i) = rhs(i)-coef(i,j)*rhs(jcol)
   40       coef(i,j) = 0.0
            jcoef(i,j) = i
   50    continue
   60 continue
      return
      end  subroutine

      subroutine scal (n,ndim,maxnz,jcoef,coef,rhs,u,work,ier)
      implicit none
      integer i,j,n,ndim,maxnz,nsgncg,ier
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz),rhs(n),u(n),work(n),save
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c ... scal scales original matrix to a unit diagonal matrix.  rhs
c ... and u vectors are scaled accordingly.  the data
c ... structure is adjusted to have diagonal entries in
c ... column 1.  zero entries in jcoef array are changed to
c ... positive integers between 1 and n.
c
c ... parameter list --
c
c         n       dimension of matrix
c         ndim    row dimension of arrays jcoef and coef in the
c                    calling program
c         maxnz   maximum number of nonzero entries per row
c         jcoef   integer array of matrix representation
c         coef    array of sparse matrix representation
c         rhs     right hand side of matrix problem
c         u       latest estimate of solution
c         work    work array of length n
c         ier     error flag -- on return, nonzero values mean
c                    401 -- zero diagonal element
c                    402 -- nonexistent diagonal element
c
c
c     description of variables in common block in main routine
c
c ... check for positive diagonal entries for each row.
c ... put diagonal entries in column 1.  replace zeros in
c ... row i of jcoef with i.
c
      ier = 0
      nsgncg = 0
      if (n.le.0) return
      do 110 i = 1,n
         if (jcoef(i,1).eq.i) go to 50
         if (maxnz.lt.2) go to 20
         do 10 j = 2,maxnz
            if (jcoef(i,j).eq.i) go to 40
   10    continue
c
c ... fatal error -- no diagonal entry for row i.
c
   20    ier = 402
         if (level.ge.0) write (nout,30) i
   30    format (//1x,'*** f a t a l     e r r o r ************'//1x,
     *      '    in itpackv routine scal    '/1x,
     *      '    no diagonal entry in row',i10)
         return
c
c ... shift row i so that diagonal element is in column 1.
c
   40    save = coef(i,j)
         coef(i,j) = coef(i,1)
         jcoef(i,j) = jcoef(i,1)
         coef(i,1) = save
         jcoef(i,1) = i
c
c ... check sign of diagonal entry.  if negative, change signs of
c ... all row coefficients and corresponding rhs element.
c
   50    if (coef(i,1)) 60 , 90 , 110
   60    do 70 j = 1,maxnz
            coef(i,j) = -coef(i,j)
   70    continue
         rhs(i) = -rhs(i)
         nsgncg = nsgncg+1
         if (level.ge.5) write (nout,80) i
   80    format (//1x,'*** n o t e ***'//1x,
     *      '    in itpackv routine scal'/1x,
     *      '    equation ',i10,' has been negated')
         go to 110
c
c ... fatal error -- zero diagonal element for row i.
c
   90    ier = 401
         if (level.ge.0) write (nout,100) i
  100    format (//1x,'*** f a t a l     e r r o r ************'//1x,
     *      '    in itpackv routine scal    '/1x,
     *      '    diagonal entry in row ',i10,' is zero')
         return
  110 continue
c
c ... change zero elements of jcoef array.
c
      if (maxnz.lt.2) go to 140
      do 130 j = 2,maxnz
         do 120 i = 1,n
            if (jcoef(i,j).le.0) jcoef(i,j) = i
  120    continue
  130 continue
c
c ... scale rhs and u arrays.  store reciprocal square roots
c ... of diagonal entries in column 1 of coef.
c
  140 do 150 i = 1,n
         work(i) = sqrt(coef(i,1))
  150 continue
      do 160 i = 1,n
         u(i) = u(i)*work(i)
  160 continue
      do 170 i = 1,n
         work(i) = 1.0/work(i)
  170 continue
      call scopy (n,work,1,coef,1)
      do 180 i = 1,n
         rhs(i) = rhs(i)*work(i)
  180 continue
c
c ... scale matrix.
c
      if (maxnz.lt.2) return
      do 200 j = 2,maxnz
         do 190 i = 1,n
            coef(i,j) = coef(i,j)*work(i)*work(jcoef(i,j))
  190    continue
  200 continue
c
c ... adjust isym if the  0 .lt. nsgncg .lt. n
c
      if (nsgncg.gt.0.and.nsgncg.lt.n) isym = 1
c
      return
      end  subroutine


      subroutine unscal (n,ndim,maxnz,jcoef,coef,rhs,u,work)
      implicit none
      integer i,j,n,ndim,maxnz
      integer jcoef(ndim,maxnz)
      real(sz) coef(ndim,maxnz),rhs(n),u(n),work(n)
c
c ... unscal reverses the scaling done in routine scal.
c
c ... parameter list --
c
c         n       dimension of matrix
c         ndim    row dimension of arrays jcoef and coef in the
c                    calling program
c         maxnz   maximum number of nonzero entries per row
c         jcoef   integer array of matrix representation
c         coef    array of sparse matrix representation
c         rhs     right hand side of matrix problem
c         u       latest estimate of solution
c         work    work array of length n
c
c
c ... unscale u and rhs arrays.
c
      call scopy (n,coef,1,work,1)
      do 10 i = 1,n
         u(i) = u(i)*work(i)
   10 continue
      do 20 i = 1,n
         work(i) = 1.0/work(i)
   20 continue
      do 30 i = 1,n
         rhs(i) = rhs(i)*work(i)
   30 continue
c
c ... unscale matrix.
c
      if (maxnz.lt.2) go to 80
      do 50 j = 2,maxnz
         do 40 i = 1,n
            coef(i,j) = coef(i,j)*work(i)*work(jcoef(i,j))
   40    continue
   50 continue
c
c ... put original zeros back in icoef array and restore unscaled
c ... diagonal entries to column one.
c
      do 70 j = 2,maxnz
         do 60 i = 1,n
            if (jcoef(i,j).eq.i) jcoef(i,j) = 0
   60    continue
   70 continue
   80 do 90 i = 1,n
         coef(i,1) = work(i)**2
   90 continue
      return
      end  subroutine


      subroutine vout (n,v,iswt,nout)
c
c     vout effects printing of residual and solution
c     vectors - called from peror
c
c ... parameter list --
c
c          v      vector of length n
c          iswt   labelling information
c          nout   output device number
c
c ... specifications for arguments
c
      real(sz)  v(n)
c
c        if (n .le. 0) return
c
      kupper = min0(n,4)
      if (iswt.eq.1) write (nout,10)
   10 format (//5x,'residual vector')
      if (iswt.eq.2) write (nout,20)
   20 format (//5x,'solution vector')
      write (nout,30) (i,i=1,kupper)
   30 format (10x,4i15)
      write (nout,40)
   40 format (10x,65('-')/)
c
      do 60 j = 1,n,4
         kupper = min0(j+3,n)
         jm1 = j-1
         write (nout,50) jm1,(v(k),k=j,kupper)
   50    format (4x,i5,'+  ',4e15.5)
   60 continue
c
      return
      end  subroutine

      subroutine zbrent (n,tri,eps,nsig,a,b,maxfn,ier)
      USE SIZES
      implicit none
      integer n,ier,nsig,maxfn,ib3,ib4,ic
      real(sz) a,b,c,d,e,eps,p,q,r,s,t,fa,fb,fc,tol,rm,rone,temp
      real(sz) tri(*)
c
c *** begin -- itpackv common
c
      integer in,is,isym,itmax,level,nout,numwav
      common /itcom1/ in,is,isym,itmax,level,nout,numwav
c
      logical adapt,betadt,caseii,halt,partad
      common /itcom2/ adapt,betadt,caseii,halt,partad
c
      real(sz) bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
      common /itcom3/ bdelnm,betab,cme,delnnm,delsnm,ff,gamma,omega,qa,
     *   qt,rho,rrr,sige,sme,specr,spr,srelpr,stptst,udnm,zeta
c
c *** end   -- itpackv common
c
c   modified imsl routine name   - zbrent
c
c-----------------------------------------------------------------------
c
c   computer            - cdc/single
c
c   latest revision     - january 1, 1978
c
c   purpose             - zero of a function which changes sign in a
c                           given interval (brent algorithm)
c
c   usage               - call zbrent (f,eps,nsig,a,b,maxfn,ier)
c
c   arguments    tri    - a tridiagonal matrix of order n
c                eps    - first convergence criterion (input).  a root,
c                           b, is accepted if abs(f(b)) is less than or
c                           equal to eps.  eps may be set to zero.
c                nsig   - second convergence criterion (input).  a root,
c                           b, is accepted if the current approximation
c                           agrees with the true solution to nsig
c                           significant digits.
c                a,b    - on input, the user must supply two points, a
c                           and b, such that f(a) and f(b) are opposite
c                           in sign.
c                           on output, both a and b are altered.  b
c                           will contain the best approximation to the
c                           root of f. see remark 1.
c                maxfn  - on input, maxfn should contain an upper bound
c                           on the number of function evaluations
c                           required for convergence.  on output, maxfn
c                           will contain the actual number of function
c                           evaluations used.
c                ier    - error parameter. (output)
c                         terminal error
c                           ier = 501 indicates the algorithm failed to
c                             converge in maxfn evaluations.
c                           ier = 502 indicates f(a) and f(b) have the
c                             same sign.
c
c   precision/hardware  - single and double/h32
c                       - single/h36,h48,h60
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   remarks  1.  let f(x) be the characteristic function of the matrix
c                tri evaluated at x. function determ evaluates f(x).
c                on exit from zbrent, when ier=0, a and b satisfy the
c                following,
c                f(a)*f(b) .le. 0,
c                abs(f(b)) .le. abs(f(a)), and
c                either abs(f(b)) .le. eps or
c                abs(a-b) .le. max(abs(b),0.1)*10.0**(-nsig).
c                the presence of 0.1 in this error criterion causes
c                leading zeroes to the right of the decimal point to be
c                counted as significant digits. scaling may be required
c                in order to accurately determine a zero of small
c                magnitude.
c            2.  zbrent is guaranteed to reach convergence within
c                k = (log((b-a)/d)+1.0)**2 function evaluations where
c                  d=min(over x in (a,b) of
c                    max(abs(x),0.1)*10.0**(-nsig)).
c                this is an upper bound on the number of evaluations.
c                rarely does the actual number of evaluations used by
c                zbrent exceed sqrt(k). d can be computed as follows,
c                  p = amin1(abs(a),abs(b))
c                  p = amax1 (0.1,p)
c                  if ((a-0.1)*(b-0.1).lt.0.0) p = 0.1
c                  d = p*10.0**(-nsig)
c
c   copyright           - 1977 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
c
c     description of variables in common block in main routine
c
c ... local itpackv references --
c
c          determ
c
c                                  first executable statement
c
      ier = 0
      ib3 = 2*itmax+1
      ib4 = 3*itmax+1
      t = 10.0**(-nsig)
      ic = 2
      fa = determ(itmax,n,tri,tri(ib3),tri(ib4),a)
      fb = determ(itmax,n,tri,tri(ib3),tri(ib4),b)
      s = b
c
c                                  test for same sign
c
      if (fa*fb.gt.0.0) go to 110
   10 c = a
      fc = fa
      d = b-c
      e = d
   20 if (abs(fc).ge.abs(fb)) go to 30
      a = b
      b = c
      c = a
      fa = fb
      fb = fc
      fc = fa
   30 continue


      tol = t*max(abs(b),0.1e0)


      rm = (c-b)*0.5d0
c
c                                  test for first convergence criteria
c
      if (abs(fb).le.eps) go to 80
c
c                                  test for second convergence criteria
c
      if (abs(c-b).le.tol) go to 80
c
c                                  check evaluation counter
c
      if (ic.ge.maxfn) go to 90
c
c                                  is bisection forced
c
      if (abs(e).lt.tol) go to 60
      if (abs(fa).le.abs(fb)) go to 60
      s = fb/fa
      if (a.ne.c) go to 40
c
c                                  linear interpolation
c
      p = (c-b)*s
      q = 1.0d0-s
      go to 50
c
c                                  inverse quadratic interpolation
c
   40 q = fa/fc
      r = fb/fc
      rone = r-1.0d0
      p = s*((c-b)*q*(q-r)-(b-a)*rone)
      q = (q-1.0d0)*rone*(s-1.0d0)
   50 if (p.gt.0.0d0) q = -q
      if (p.lt.0.0d0) p = -p
      s = e
      e = d
c
c                                  if abs(p/q).ge.75*abs(c-b) then
c                                     force bisection
c
      if (p+p.ge.3.0d0*rm*q) go to 60
c
c                                  if abs(p/q).ge..5*abs(s) then force
c                                     bisection. s = the value of p/q
c                                     on the step before the last one
c
      if (p+p.ge.abs(s*q)) go to 60
      d = p/q
      go to 70
c
c                                  bisection
c
   60 e = rm
      d = e
c
c                                  increment b
c
   70 a = b
      fa = fb
      temp = d
cjjw/vjpm002 - modified/added the following 5 lines

      if (abs(temp).le.0.5e0*tol) temp = sign(0.5e0*tol,rm)

      b = b+temp
      s = b
      fb = determ(itmax,n,tri,tri(ib3),tri(ib4),s)
      ic = ic+1
      if (fb*fc.le.0.0) go to 20
      go to 10
c
c                                  convergence of b
c
   80 a = c
      maxfn = ic
      go to 130
c
c                                  maxfn evaluations
c
   90 ier = 501
      a = c
      maxfn = ic
      if (level.ge.1) write (nout,100) maxfn
  100 format (/1x,'*** w a r n i n g ************'//1x,
     *   '    in itpackv routine zbrent'/1x,
     *   '    algorithm failed to converge'/1x,
     *   '    in',i6,' iterations ')
      go to 130
c
c                                  terminal error - f(a) and f(b) have
c                                  the same sign
c
  110 ier = 502
      maxfn = ic
      if (level.ge.1) write (nout,120)
  120 format (/1x,'*** w a r n i n g ************'//1x,
     *   '    in itpackv routine zbrent  '/1x,
     *   '    f(a) and f(b) have same sign   ')
  130 continue
      return
      end  subroutine


      subroutine ypasx2 (ndim,n,m,a,ja,y,x)
      implicit none
      integer ndim,n,i,j,l,m,lp1
      integer ja(ndim,*)
      real(sz) a(ndim,*),x(*),y(*)
c
c ... ypasx2 does the loop
c
c           do 20 j = 1,m
c              do 10 i = 1,n
c                 y(i) = y(i) + a(i,j)*x(ja(i,j))
c       10     continue
c       20  continue
c
c ... parameters --
c
c       ndim      row dimension of a and ja arrays
c       n         order of system
c       m         number of columns in a and ja arrays
c       a         real array of active size n by m
c       ja        integer array of active size n by m
c       y         accumulation vector
c       x         right-hand-side vector
c
c
      if (n.le.0 .or. m.le.0) return
      l = mod(m,4)
      if (l.eq.0) go to 80
c
c ... initial short computations
c
      go to (10,30,50), l
   10 do 20 i = 1,n
         y(i) = y(i)+a(i,1)*x(ja(i,1))
   20 continue
      go to 70
   30 do 40 i = 1,n
         y(i) = y(i)+a(i,1)*x(ja(i,1))+a(i,2)*x(ja(i,2))
   40 continue
      go to 70
   50 do 60 i = 1,n
         y(i) = y(i)+a(i,1)*x(ja(i,1))+a(i,2)*x(ja(i,2))+a(i,3)*x(ja(i,
     *      3))
   60 continue
   70 if (m.le.4) return
c
c ... loop unrolling to a level of 4.
c
   80 lp1 = l+1
      do 100 j = lp1,m,4
         do 90 i = 1,n
            y(i) = y(i)+a(i,j)*x(ja(i,j))+a(i,j+1)*x(ja(i,j+1))+a(i,j+2)
     *         *x(ja(i,j+2))+a(i,j+3)*x(ja(i,j+3))
   90    continue
  100 continue
      return
      end subroutine


      subroutine ymasx2 (ndim,n,m,a,ja,y,x)
      implicit none
      integer ndim,n,i,j,l,m,lp1
      integer ja(ndim,m)
      real(sz) a(ndim,m),x(n),y(n)
c
c ... ymasx2 does the loop
c
c           do 20 j = 1,m
c              do 10 i = 1,n
c                 y(i) = y(i) - a(i,j)*x(ja(i,j))
c       10     continue
c       20  continue
c
c ... parameters --
c
c       ndim      row dimension of a and ja arrays
c       n         order of system
c       m         number of columns in a and ja arrays
c       a         real array of active size n by m
c       ja        integer array of active size n by m
c       y         accumulation vector
c       x         right-hand-side vector
c
      if (n.le.0 .or. m.le.0) return
      l = mod(m,4)
      if (l.eq.0) go to 80
c
c ... initial short computations
c
      go to (10,30,50), l
   10 do 20 i = 1,n
         y(i) = y(i)-a(i,1)*x(ja(i,1))
   20 continue
      go to 70
   30 do 40 i = 1,n
         y(i) = y(i)-a(i,1)*x(ja(i,1))-a(i,2)*x(ja(i,2))
   40 continue
      go to 70
   50 do 60 i = 1,n
         y(i) = y(i)-a(i,1)*x(ja(i,1))-a(i,2)*x(ja(i,2))
     *         -a(i,3)*x(ja(i,3))
   60 continue
   70 if (m.le.4) return
c
c ... loop unrolling to a level of 4.
c
   80 lp1 = l+1
      do 100 j = lp1,m,4
         do 90 i = 1,n
            y(i) = y(i)-a(i,j)*x(ja(i,j))-a(i,j+1)*x(ja(i,j+1))
     *            -a(i,j+2)*x(ja(i,j+2))-a(i,j+3)*x(ja(i,j+3))
   90    continue
  100 continue
      return
      end subroutine


      subroutine whenige (n,p,inc,itarg,ip,npt)
      implicit none
      integer n,inc,itarg,npt,i
      integer p(n), ip(n)
c
      npt = 0
      do 10 i = 1,n
         if (p(i) .lt. itarg) go to 10
         npt = npt + 1
         ip(npt) = i
 10   continue
      return
      end subroutine


      subroutine whenilt (n,p,inc,itarg,ip,npt)
      implicit none
      integer n,inc,itarg,npt,i
      integer p(n), ip(n)
c
      npt = 0
      do 10 i = 1,n
         if (p(i) .ge. itarg) go to 10
         npt = npt + 1
         ip(npt) = i
 10   continue
      return
      end subroutine


C
C*****************************************************************
C
C  Modified BLAS for ITPACK2D
C
C*****************************************************************
C

      real(sz) function sdot(n,sx,incx,sy,incy)
      implicit none
      integer i,n,incx,incy
      real(sz) sx(*),sy(*)
      REAL*8 ddot
c
      ddot = 0.0D0
      sdot = ddot
c
      if (n.gt.0) then  
        do i = 1,n
           ddot = ddot + sx(i)*sy(i)
        enddo 
        sdot = ddot
      endif
c
      return
      end function

      integer function ismin (n,sx,incx)
      implicit none
      integer n,incx,ns,i,ii
      real(sz) sx(*),smin,xval
c
c     find smallest index of minimum value of single precision sx.
c
      ismin = 0
      if (n.le.0) return
      ismin = 1
      if (n.le.1) return
      if (incx.eq.1) go to 30
c
c        code for increments not equal to 1.
c
      smin = sx(1)
      ns = n*incx
      ii = 1
      do 20 i = 1,ns,incx
         xval = sx(i)
         if (xval.ge.smin) go to 10
         ismin = ii
         smin = xval
   10    ii = ii+1
   20 continue
      return
c
c        code for increments equal to 1.
c
   30 smin = sx(1)
      do 40 i = 2,n
         xval = sx(i)
         if (xval.ge.smin) go to 40
         ismin = i
         smin = xval
   40 continue
      return
      end function



      subroutine  scopy(n,sx,incx,sy,incy)
      implicit none
      integer n,incx,incy,ix,iy,i,m,mp1,ns
      real(sz) sx(*),sy(*)
c
c     copy single precision sx to single precision sy.
c
      if(n.le.0)return
      if(incx.eq.incy) if(incx-1) 5,20,60
    5 continue
c
c        code for unequal or nonpositive increments.
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        sy(iy) = sx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop so remaining vector length is a multiple of 7.
c
   20 m = n - (n/7)*7
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sy(i) = sx(i)
   30 continue
      if( n .lt. 7 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,7
        sy(i) = sx(i)
        sy(i + 1) = sx(i + 1)
        sy(i + 2) = sx(i + 2)
        sy(i + 3) = sx(i + 3)
        sy(i + 4) = sx(i + 4)
        sy(i + 5) = sx(i + 5)
        sy(i + 6) = sx(i + 6)
   50 continue
      return
c
c        code for equal, positive, nonunit increments.
c
   60 continue
      ns = n*incx
          do 70 i=1,ns,incx
          sy(i) = sx(i)
   70     continue
      return
      end subroutine


      END MODULE ITPACKV
C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001 
C    last changes in this file VERSION 41.11
C
C  mod history
C  v41.11 - 09/14/01 - rl - from 41.09 - eliminated MNWLON,MNWLAT from NWS11GET
C  v41.09 - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C  v41.06 - 04/02/01 - rl - corrected dimensioning on most of wind reading
C                          subroutines.  Eliminated MNWP.  Note MNWLON and
C                          MNWLAT still need to be eliminated from NWS11GET
C                          subroutine.
C**************************************************************************
C
       MODULE WIND
       USE SIZES
C
C
C***********************************************************************
C                                                                      *
C   THE FOLLOWING SUBROUTINES READ IN AND IN SOME CASES INTERPOLATE    *
C   ONTO THE ADCIRC GRID WIND AND PRESSURE FIELDS IN VARIOUS INPUT     *
C   FORMATS.                                                           *
C                                                                      *
C   ALL WIND SPEEDS ARE CONVERTED TO M/S AND ALL PRESSURES TO M OF H20 *
C   BEFORE THEY ARE RETURNED.                                          *
C                                                                      *
C***********************************************************************
C
      REAL(8),PRIVATE,PARAMETER :: PI=3.141592653589793D0, 
     *                             TWOPI=PI*2.D0,
     *                             HFPI=PI/2.D0,
     *                             RAD2DEG = 180.D0/PI,
     *                             DEG2RAD = PI/180.D0

C------------------------end of data declarations______________________________C


       CONTAINS


C***********************************************************************
C                                                                      *
C   Convert time from year,month,day,hour,min,sec into seconds since   *
C   the beginning of the year.                                         *
C                                                                      *
C***********************************************************************

      SUBROUTINE TIMECONV(IYR,IMO,IDAY,IHR,IMIN,SEC,TIMESEC)
      IMPLICIT NONE
      INTEGER IYR,IMO,IDAY,IHR,IMIN,ILEAP
      REAL*8 TIMESEC,SEC
C
      TIMESEC = (IDAY-1)*86400 + IHR*3600 + IMIN*60 + SEC
      IF(IMO.GE.2)  TIMESEC = TIMESEC + 31*86400
      ILEAP = (IYR/4)*4
      IF((ILEAP.EQ.IYR).AND.(IMO.GE.3)) TIMESEC = TIMESEC + 29*86400
      IF((ILEAP.NE.IYR).AND.(IMO.GE.3)) TIMESEC = TIMESEC + 28*86400
      IF(IMO.GE.4)  TIMESEC = TIMESEC + 31*86400
      IF(IMO.GE.5)  TIMESEC = TIMESEC + 30*86400
      IF(IMO.GE.6)  TIMESEC = TIMESEC + 31*86400
      IF(IMO.GE.7)  TIMESEC = TIMESEC + 30*86400
      IF(IMO.GE.8)  TIMESEC = TIMESEC + 31*86400
      IF(IMO.GE.9)  TIMESEC = TIMESEC + 31*86400
      IF(IMO.GE.10) TIMESEC = TIMESEC + 30*86400
      IF(IMO.GE.11) TIMESEC = TIMESEC + 31*86400
      IF(IMO.EQ.12) TIMESEC = TIMESEC + 30*86400
      IF(IMO.GT.12) THEN
        WRITE(6,*) 'FATAL ERROR IN SUBROUTINE TIMECONV - MONTH > 12 '
        WRITE(16,*) 'FATAL ERROR IN SUBROUTINE TIMECONV - MONTH > 12 '
        STOP
        ENDIF
      RETURN
      END SUBROUTINE

C***********************************************************************
C                                                                      *
C   READ IN AND INTERPOLATE ONTO THE ADCIRC GRID WIND FIELDS FROM U.S. *
C   NAVY FLEET NUMERIC WIND FILES.                                     *
C                                                                      *
C   NOTE: The ADCIRC grid information consists only of the Lon and Lat *
C   of the nodes.  THE LONS AND LATS MUST BE IN RADIANS!               *
C                                                                      *
C                                                                      *
C   NWLAT = MAXIMUM NUMBER OF LATITUDES IN FLEET NUMERIC WIND FILE     *
C            SET = 1 IF FLEET NUMERIC WIND FILE NOT IN USE             *
C   NWLON = MAXIMUM NUMBER OF LONGITUDES IN FLEET NUMERIC WIND FILE    *
C            SET = 1 IF FLEET NUMERIC WIND FILE NOT IN USE             *
C                                                                      *
C                        R.L. 4/17/96                                  *
C                                                                      *
C   R.L. 4/2/01  changed MNWLAT,MNWLON in ALLOCATE statement to        *
C                NWLAT,NWLON                                           *
C***********************************************************************

      SUBROUTINE NWS3GET(X,Y,SLAM,SFEA,WVNX,WVNY,IWTIME,IWYR,WTIMED,NP,
     *                  NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
      USE SIZES
      IMPLICIT NONE
      INTEGER, SAVE :: FIRSTCALL = 0
      INTEGER IWTIME,IWYR,IWMO,IWDAY,IWHR,NP,NWLON,NWLAT,ICS,I,J
      REAL*8 WTIMED
      REAL*8 X(*),Y(*),SLAM(*),SFEA(*),XCOOR,YCOOR
      INTEGER  LATIND1,LATIND2,LONIND1,LONIND2
      REAL(SZ) WLATMAX,WLONMIN,WLATINC,WLONINC,WSPEED,WDIR
      REAL(SZ) WLATM,WLONM,XWRATIO,YWRATIO
      REAL(SZ),ALLOCATABLE,SAVE :: WVXFN(:,:),WVYFN(:,:),PRN(:,:)
      REAL(SZ) WVNX(*),WVNY(*)
C
      IF (FIRSTCALL.EQ.0) THEN
         FIRSTCALL = 1
         ALLOCATE ( WVXFN(NWLAT,NWLON),WVYFN(NWLAT,NWLON),
     *             PRN(NWLAT,NWLON) )
      ENDIF
C
      READ(22,*) IWTIME
      IWYR = IWTIME/1000000
      IWMO = IWTIME/10000 - IWYR*100
      IWDAY = IWTIME/100 - IWYR*10000 - IWMO*100
      IWHR = IWTIME - IWYR*1000000 - IWMO*10000 - IWDAY*100
      CALL TIMECONV(IWYR,IWMO,IWDAY,IWHR,0,0.0D0,WTIMED)
C
      DO I=1,NWLAT
         READ(22,*) (WVXFN(I,J),J=1,NWLON)
      END DO
      DO I=1,NWLAT
         READ(22,*) (WVYFN(I,J),J=1,NWLON)
      END DO
C
      DO I=1,NWLAT              !CONVERT TO X AND Y COMPONENTS
         DO J=1,NWLON
            WSPEED=WVXFN(I,J)
            WDIR=WVYFN(I,J)*DEG2RAD
            WVXFN(I,J)=-WSPEED*SIN(WDIR)
            WVYFN(I,J)=-WSPEED*COS(WDIR)
         END DO
      END DO
      
      DO I=1,NP                 !INTERPOLATE TO ADCIRC GRID
         IF(ICS.EQ.2) THEN
            YCOOR=SFEA(I)*RAD2DEG
            XCOOR=SLAM(I)*RAD2DEG
         ENDIF
         IF(ICS.EQ.1) THEN
            YCOOR=Y(I)
            XCOOR=X(I)
         ENDIF
         LATIND2=(WLATMAX-YCOOR)/WLATINC + 1
         IF(LATIND2.EQ.NWLAT) LATIND2=LATIND2-1
         LATIND1=LATIND2 + 1
         LONIND1=(XCOOR-WLONMIN)/WLONINC + 1
         IF(LONIND1.EQ.NWLON) LONIND1=LONIND1-1
         LONIND2=LONIND1+1
         WLONM = WLONMIN + (LONIND1-1)*WLONINC
         WLATM = WLATMAX - (LATIND1-1)*WLATINC
         XWRATIO=(XCOOR-WLONM)/WLONINC
         YWRATIO=(YCOOR-WLATM)/WLATINC
C     
         WVNX(I) = WVXFN(LATIND2,LONIND2)*XWRATIO*YWRATIO
     *        + WVXFN(LATIND2,LONIND1)*(1.d0-XWRATIO)*YWRATIO
     *        + WVXFN(LATIND1,LONIND2)*XWRATIO*(1.d0-YWRATIO)
     *        + WVXFN(LATIND1,LONIND1)*(1.d0-XWRATIO)*(1.d0-YWRATIO)
         WVNY(I) = WVYFN(LATIND2,LONIND2)*XWRATIO*YWRATIO
     *        + WVYFN(LATIND2,LONIND1)*(1.d0-XWRATIO)*YWRATIO
     *        + WVYFN(LATIND1,LONIND2)*XWRATIO*(1.d0-YWRATIO)
     *        + WVYFN(LATIND1,LONIND1)*(1.d0-XWRATIO)*(1.d0-YWRATIO)
      END DO
C     
      RETURN
      END SUBROUTINE



C***********************************************************************
C                                                                      *
C   Read onto the ADCIRC grid wind fields from the PBL-JAG model       *
C                                                                      *
C   Output from this subroutine is U,V (M/S) and P (M H20) on the      *
C   ADCIRC grid.                                                       *
C                                                                      *
C   The background pressure is assumed to be 1013 Mbars                *
C                                                                      *
C                           R.L.11/06/96                               *
C   R.L.09/04/00 added RHOWAT0 to call                                 *
C   R.L. 4/2/01  changed MNP dimensions to *                           *
C***********************************************************************

      SUBROUTINE NWS4GET(WVNX,WVNY,PRN,NP,RHOWAT0,G)
      USE SIZES
      IMPLICIT NONE
      INTEGER   NP,I,NHG
      REAL(SZ)  WVNX(*),WVNY(*),PRN(*)
      REAL(SZ)  RHOWAT0,RHOWATG,G
      CHARACTER*80 PBLJAGF
C
      RHOWATG=RHOWAT0*G
      DO I=1,NP
        WVNX(I)=0.d0
        WVNY(I)=0.d0
        PRN(I)=101300.d0/RHOWATG
      END DO
 170  READ(22,'(A80)') PBLJAGF
      IF(PBLJAGF(2:2).EQ.'#') GOTO 170
 171  READ(PBLJAGF,'(I8,5E13.5)') NHG,WVNX(NHG),WVNY(NHG),
     *                            PRN(NHG)
      WVNX(NHG)=WVNX(NHG)*1.04d0*0.5144d0 !CONVERT 30-MIN WINDS IN
      WVNY(NHG)=WVNY(NHG)*1.04d0*0.5144d0 !KNOTS TO 10-MIN WIND IN M/S
      PRN(NHG)=100.d0*PRN(NHG)/RHOWATG !CONVERT MILLIBARS TO M OF WATER
      READ(22,'(A80)') PBLJAGF
      IF(PBLJAGF(2:2).NE.'#') GOTO 171
      RETURN
      END SUBROUTINE


C***********************************************************************
C                                                                      *
C   READ IN AND INTERPOLATE ONTO THE ADCIRC GRID WIND AND PRESSURE     *
C   FIELDS FROM A MET FILE ON A RECTILINEAR GRID.                      *
C                                                                      *
C   NOTE: The ADCIRC grid information consists only of the Lon and Lat *
C   of the nodes.  THE LONS AND LATS MUST BE IN RADIANS!               *
C                                                                      *
C   NOTE:  It is assumed that the met file data is oriented so that    *
C          the outer loop is on latitude and the inner loop is on      *
C          longitude.  For example:                                    *
C          line 1             lat 1,     lon 1                         *
C          line 2             lat 1,     lon 2                         *
C            .                                                         *
C          line nwlon         lat 1,     lon nwlon                     *
C          line nwlon+1       lat 2,     lon 1                         *
C          line nwlon+2       lat 2,     lon 2                         *
C            .                                                         *
C          line 2*nwlon       lat 2,     lon nwlon                     *
C          line 2*nwlon+1     lat 3,     lon 1                         *
C          line 2*nwlon+2     lat 3,     lon 2                         *
C            .                                                         *
C          line nwlon*nwlat   lat nwlat, lon nwlon                     *
C                                                                      *
C   NOTE:  It is assumed that he met file data is oriented so that     *
C          latitude varies from the northern most value (lat 1) to the *
C          southern most value (lat nwlat) and longitude varies in an  *
C          easterly direction (e.g. from 0 to 360 where positive       *
C          longitudes are angles measured easterly of the GM.          *
C                                                                      *
C   NOTE:  For the global AVN grid running from 0.5 - 359.5 deg lon    *
C          and 90 - -90 deg lat in 1 degree increments, NWLAT=181 and  *
C          NWLON=360 yielding a total number of entries in the file    *
C          of 65160.                                                   *    
C                                                                      *
C   NOTE:  It is assumed that wind velocity is in EAST,NORTH components*
C          in M/2 and pressure is in N/M^2                             *
C                                                                      *
C   NOTE:  WLATMAX,WLONMIN,WLATINC,WLONINC should be in deg.           *
C                                                                      *
C   NOTE:  This should wrap if XCOORD > WLONMIN+NWLON*WLONINC  or      *
C          XCOORD < WLONMIN                                            *
C                                                                      *
C                                                                      *
C   MNWLAT = MAXIMUM NUMBER OF LATITUDES IN WIND FILE                  *
C            SET = 1 IF FLEET NUMERIC WIND FILE NOT IN USE             *
C   MNWLON = MAXIMUM NUMBER OF LONGITUDES IN WIND FILE                 *
C            SET = 1 IF FLEET NUMERIC WIND FILE NOT IN USE             *
C                                                                      *
C                           R.L. 4/13/99                               *
C                           R.L.09/04/00 added RHOWAT0 to call         *
C   R.L.09/04/00 added RHOWAT0 to call                                 *
C   R.L. 4/2/01  changed MNWLAT,MNWLON in ALLOCATE statement to        *
C                NWLAT,NWLON                                           *
C***********************************************************************

      SUBROUTINE NWS6GET(X,Y,SLAM,SFEA,WVNX,WVNY,PRESS,NP,NWLON,NWLAT,
     *     WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
      USE SIZES

      IMPLICIT NONE
      INTEGER, SAVE :: FIRSTCALL = 0
      INTEGER NP,NWLON,NWLAT,I,J,ICS 
      REAL(SZ) RHOWAT0,RHOWATG,G
      INTEGER  LATIND1,LATIND2,LONIND1,LONIND2
      REAL(SZ) WLATMAX,WLONMIN,WLATINC,WLONINC,XWRATIO,YWRATIO
      REAL(SZ) WLATM,WLONM
      REAL*8 X(*),Y(*),SLAM(*),SFEA(*),XCOOR,YCOOR
      REAL(SZ) WVNX(*),WVNY(*),PRESS(*)
      REAL(SZ),SAVE,ALLOCATABLE :: WVXFN(:,:),WVYFN(:,:),PRN(:,:)
C     
      IF (FIRSTCALL.EQ.0) THEN
         FIRSTCALL = 1
         ALLOCATE ( WVXFN(NWLAT,NWLON),WVYFN(NWLAT,NWLON),
     *        PRN(NWLAT,NWLON) )
      ENDIF
C     
      RHOWATG=RHOWAT0*G
      DO I=1,NWLAT
         DO J=1,NWLON
            READ(22,*) PRN(I,J),WVXFN(I,J),WVYFN(I,J)
         END DO
      END DO

      DO I=1,NP                 !INTERPOLATE TO ADCIRC GRID
         IF(ICS.EQ.2) THEN
            YCOOR=SFEA(I)*RAD2DEG
            XCOOR=SLAM(I)*RAD2DEG
            IF(XCOOR.LT.0.) XCOOR=XCOOR+360.d0
         ENDIF
         IF(ICS.EQ.1) THEN
            YCOOR=Y(I)
            XCOOR=X(I)
         ENDIF
         LATIND2=(WLATMAX-YCOOR)/WLATINC + 1
         IF(LATIND2.EQ.NWLAT) LATIND2=LATIND2-1
         LATIND1=LATIND2 + 1
         LONIND1=(XCOOR-WLONMIN)/WLONINC + 1
         LONIND2=LONIND1 + 1
C     
         WLONM = WLONMIN + (LONIND1-1)*WLONINC 
         WLATM = WLATMAX - (LATIND1-1)*WLATINC
         XWRATIO=(XCOOR-WLONM)/WLONINC
         YWRATIO=(YCOOR-WLATM)/WLATINC
C     
         IF(LONIND1.EQ.0) LONIND1=NWLON
         IF(LONIND1.EQ.NWLON) LONIND2=1
C     
         WVNX(I) = WVXFN(LATIND2,LONIND2)*XWRATIO*YWRATIO
     *        + WVXFN(LATIND2,LONIND1)*(1.d0-XWRATIO)*YWRATIO
     *        + WVXFN(LATIND1,LONIND2)*XWRATIO*(1.d0-YWRATIO)
     *        + WVXFN(LATIND1,LONIND1)*(1.d0-XWRATIO)*(1.d0-YWRATIO)
         WVNY(I) = WVYFN(LATIND2,LONIND2)*XWRATIO*YWRATIO
     *        + WVYFN(LATIND2,LONIND1)*(1.d0-XWRATIO)*YWRATIO
     *        + WVYFN(LATIND1,LONIND2)*XWRATIO*(1.d0-YWRATIO)
     *        + WVYFN(LATIND1,LONIND1)*(1.d0-XWRATIO)*(1.d0-YWRATIO)
         PRESS(I) = PRN(LATIND2,LONIND2)*XWRATIO*YWRATIO
     *        + PRN(LATIND2,LONIND1)*(1.d0-XWRATIO)*YWRATIO
     *        + PRN(LATIND1,LONIND2)*XWRATIO*(1.d0-YWRATIO)
     *        + PRN(LATIND1,LONIND1)*(1.d0-XWRATIO)*(1.d0-YWRATIO)
         PRESS(I) = PRESS(I)/RHOWATG

      END DO
C     
      RETURN
      END SUBROUTINE


C***********************************************************************
C                                                                      *
C   Read in and interpolate onto the ADCIRC grid wind fields from U.S. *
C   National Weather Service AVN model SFLUX meteorological files.     *
C                                                                      *
C   The input files are in binary and have been created by the GRIB    *
C   unpacking program unpkgrb1.f to extract only the U 10M, V 10M, and *
C   surface P fields.    THE BINARY INPUT HAS BEEN ELIMINATED!!!!      *
C   The input files are in ASCII and contain surface P, U 10M and V 10M*
C   fields.                                                            *
C                                                                      *
C   The SFLUX files utilize a global Gaussian Lon/Lat grid which is    *
C   constructed in these subroutines.                                  *
C                                                                      *
C   NOTE: The ADCIRC grid information consists only of the Lon and Lat *
C   of the nodes.  THE LONS AND LATS MUST BE IN RADIANS!               *
C                                                                      *
C   Output from this subroutine is U,V (M/S) and P (M H20) on the      *
C   ADCIRC grid.                                                       *
C                                                                      *
C   MNWLAT = LATB = 190    FOR GAUSSIAN GRID                           *
C   MNWLON = LONB = 384    FOR GAUSSIAN GRID                           *
C                                                                      *
C                           R.L. 4/14/99                               *
C                           R.L.09/04/00 added RHOWAT0 to call         *
C   R.L. 4/2/01  changed MNWLAT,MNWLON in ALLOCATE statement to        *
C                LATB,LONB; elminiated MNWP as a dimension             *
C***********************************************************************

      SUBROUTINE NWS10GET(NWSGGWI,FLON,FLAT,ULL,VLL,PLL,NP,RHOWAT0,G,
     *     LONB,LATB,WTIMINC)
      USE SIZES
      IMPLICIT NONE
      INTEGER, SAVE :: FIRSTCALL = 0
      INTEGER N,NP,NWSGGWI,LONB,LATB,I,J,JJ,IEXT,IDIG1,IDIG2,
     *     IDIG3,KERR
      REAL*8 WTIMINC
      REAL*8 FLAT(*),FLON(*)
      REAL(SZ)  ULL(*),VLL(*),PLL(*)
      REAL(SZ) RHOWAT0,RHOWATG,G,GDLON,P1,P2,P3,P4,U1,U2,U3,U4,
     *     V1,V2,V3,V4
      INTEGER KGDS(200)
      INTEGER,SAVE,ALLOCATABLE ::  N00(:),N10(:),N11(:),N01(:)
      REAL(SZ),SAVE,ALLOCATABLE :: D00(:),D10(:),D11(:),D01(:)
      REAL(SZ),SAVE,ALLOCATABLE :: COLRAB(:),DUMMY(:),
     *     GCLAT(:),GCLON(:)
      REAL(SZ),SAVE,ALLOCATABLE ::  UG(:),VG(:),PG(:)
      CHARACTER*1 PDS(50),FNAME2(8)
      CHARACTER*8 FNAME1
      EQUIVALENCE (FNAME1,FNAME2)
      LOGICAL FOUND
C     
      IF (FIRSTCALL.EQ.0) THEN
         FIRSTCALL = 1
         ALLOCATE ( UG(LATB*LONB),VG(LATB*LONB),
     *        PG(LATB*LONB) )
         ALLOCATE ( N00(MNP),N10(MNP),N11(MNP),N01(MNP) )
         ALLOCATE ( D00(MNP),D10(MNP),D11(MNP),D01(MNP) )
         ALLOCATE ( COLRAB(LATB),DUMMY(LATB),GCLAT(LATB),
     *        GCLON(LONB) )
      ENDIF
C     
      RHOWATG=RHOWAT0*G
C     
C...  The first time the subroutine is called, setup the Gaussian grid and
C...  determine the interpolating factors for the ADCIRC grid.
C     
      IF (NWSGGWI.EQ.-1) THEN
         CALL GLATS(LATB/2,COLRAB,DUMMY,DUMMY,DUMMY)
         DO J=1,LATB/2
            GCLAT(J)=COLRAB(J)
            JJ=LATB-J+1
            GCLAT(JJ)=PI-COLRAB(J)
         ENDDO
         GDLON=TWOPI/LONB
         DO J=1,LONB
            GCLON(J)=GDLON*(J-1)
         END DO
         CALL G2RINI(GCLON,GCLAT,FLON,FLAT,N00,N10,N11,N01,D00,D10,D11,
     *        D01,NP,LONB,LATB)
         RETURN
      ENDIF

C...  Figure out the data file name

      FNAME1='fort.   '
      IEXT=200 + NWSGGWI*(WTIMINC/3600)
      IDIG1=IEXT/100
      IDIG2=(IEXT-100*IDIG1)/10
      IDIG3=(IEXT-100*IDIG1-10*IDIG2)
      FNAME2(6)=CHAR(IDIG1+48)
      FNAME2(7)=CHAR(IDIG2+48)
      FNAME2(8)=CHAR(IDIG3+48)


C...  Enter, locate and open the data file

 1010 FORMAT(' File ',A8,' WAS NOT FOUND!  FATAL ERROR',/)
 1011 FORMAT(' File ',A8,' WAS FOUND!  Opening & Processing file',/)

      WRITE(*,*) '  '
      INQUIRE(FILE=FNAME1,EXIST=FOUND)
      IF(FOUND) GOTO 32
      WRITE(*,1010) FNAME1
      WRITE(16,1010) FNAME1
      STOP
 32   WRITE(*,1011) FNAME1

C...Open and read the GRIB BINARY data file
c     OPEN(IEXT,FILE=FNAME1,status='old',access='sequential',
c    &     form='unformatted',iostat=kerr)
c     READ(IEXT,END=1100) LENPDS,LENKGDS,NWORDS
c     IF(LENPDS.GT.0) READ(IEXT,END=1100) (pds(j),j=1,lenpds)
c     IF(LENKGDS.GT.0) READ(IEXT,END=1100) (kgds(j),j=1,lenkgds)
c     IF(NWORDS.GT.0) READ(IEXT,END=1100) (UG(J),J=1,NWORDS)
c
c     READ(IEXT,END=1100) LENPDS,LENKGDS,NWORDS
c     IF(LENPDS.GT.0) READ(IEXT,END=1100) (pds(j),j=1,lenpds)
c     IF(LENKGDS.GT.0) READ(IEXT,END=1100) (kgds(j),j=1,lenkgds)
c     IF(NWORDS.GT.0) READ(IEXT,END=1100) (VG(J),J=1,NWORDS)
c
c     READ(IEXT,END=1100) LENPDS,LENKGDS,NWORDS
c     IF(LENPDS.GT.0) READ(IEXT,END=1100) (pds(j),j=1,lenpds)
c     IF(LENKGDS.GT.0) READ(IEXT,END=1100) (kgds(j),j=1,lenkgds)
c     IF(NWORDS.GT.0) READ(IEXT,END=1100) (PG(J),J=1,NWORDS)

C...Open and read the ASCII data file

      OPEN(IEXT,FILE=FNAME1,status='old',iostat=kerr)
      DO I=1,LONB*LATB
         READ(IEXT,*) PG(I),UG(I),VG(I)
      ENDDO

 1100 CLOSE(IEXT)


C.....Go from the Gaussian grid to the ADCIRC grid
C.....Convert pressure from N/M^2 to M of H20

      DO N=1,NP
         P1=PG(N00(N))
         P2=PG(N10(N))
         P3=PG(N11(N))
         P4=PG(N01(N))
         U1=UG(N00(N))
         U2=UG(N10(N))
         U3=UG(N11(N))
         U4=UG(N01(N))
         V1=VG(N00(N))
         V2=VG(N10(N))
         V3=VG(N11(N))
         V4=VG(N01(N))
         PLL(N)=P1*D00(N)+P2*D10(N)+P3*D11(N)+P4*D01(N)
         ULL(N)=U1*D00(N)+U2*D10(N)+U3*D11(N)+U4*D01(N)
         VLL(N)=V1*D00(N)+V2*D10(N)+V3*D11(N)+V4*D01(N)
         PLL(N)=PLL(N)/RHOWATG
      END DO
C     
      RETURN
      END SUBROUTINE


C***********************************************************************
C  Subroutine to compute the latutudes in a Global Gaussian Lat/Lon    *
C  grid with T126 resolution (GRIB Grid type 126).                     *
C                                                                      *
C       modified from the original GLATS by R.L. 4/24/96               *
C***********************************************************************

      SUBROUTINE GLATS(LGGHAF,COLRAD,WGT,WGTCS,RCS2)
      USE SIZES
      IMPLICIT NONE
      REAL(SZ) COLRAD(*),WGT(*),WGTCS(*),RCS2(*)
      INTEGER LGGHAF,L2,K,K1,ITER
      REAL(SZ) SI,SCALE,RL2,DRAD,DRADZ,RAD,P1,P2,EPS,PHI,X,W,SN,RC
C     
      EPS=1.d-6
C     EPS=1.d-12
C     PRINT 101
C     101  FORMAT ('0 I   COLAT   COLRAD     WGT', 12X, 'WGTCS',
CCCC  1 10X, 'ITER  RES')
C     
      SI = 1.0d0
      L2=2*LGGHAF
      RL2=L2
      SCALE = 2.0d0/(RL2*RL2)
      K1=L2-1
      DRADZ = PI / 360.d0
      RAD = 0.0
      DO 1000 K=1,LGGHAF
         ITER=0
         DRAD=DRADZ
 1       CALL POLY(L2,RAD,P2)
 2       P1 =P2
         ITER=ITER+1
         RAD=RAD+DRAD
         CALL POLY(L2,RAD,P2)
         IF(SIGN(SI,P1).EQ.SIGN(SI,P2)) GO TO 2
         IF(DRAD.LT.EPS)GO TO 3
         RAD=RAD-DRAD
         DRAD = DRAD * 0.25d0
         GO TO 1
 3       CONTINUE
         COLRAD(K)=RAD
         PHI = RAD * 180.d0 / PI
         CALL POLY(K1,RAD,P1)
         X = COS(RAD)
         W = SCALE * (1.0d0 - X*X)/ (P1*P1)
         WGT(K) = W
         SN = SIN(RAD)
         W=W/(SN*SN)
         WGTCS(K) = W
         RC=1.d0/(SN*SN)
         RCS2(K) = RC
         CALL POLY(L2,RAD,P1)
C     PRINT 102,K,PHI,COLRAD(K),WGT(K),WGTCS(K),ITER,P1
C     102  FORMAT(1H ,I2,2X,F6.2,2X,F10.7,2X,E13.7,2X,E13.7,2X,I4,2X,D13.7)
 1000 CONTINUE
c     PRINT 100,LGGHAF
c     100  FORMAT(1H ,'SHALOM FROM 0.0 GLATS FOR ',I3)
      RETURN
      END SUBROUTINE


C***********************************************************************
C  Subroutine used by GLATS.                                           *
C***********************************************************************

      SUBROUTINE POLY(N,RAD,P)
      USE SIZES
      IMPLICIT NONE
      INTEGER N,I
      REAL(SZ) RAD,P,X,Y1,Y2,Y3,G
C     
      X = COS(RAD)
      Y1 = 1.0d0
      Y2=X
      DO 1 I=2,N
         G=X*Y2
         Y3=G-Y1+G-(G-Y1)/FLOAT(I)
         Y1=Y2
         Y2=Y3
 1    CONTINUE
      P=Y3
      RETURN
      END SUBROUTINE

C***********************************************************************
C  Subroutine to compute the factors to interpolate from a global      *
C  Gaussian Lat/Lon grid with T126 resolution (GRIB Grid type 126)     *
C  onto another grid.                                                  *
C                                                                      *
C  The new grid is a series of longitude and latitude points contained *
C  in the FLON and FLAT arrays with a total number of points NP        *
C                                                                      *
C       modified from the original G2RINI by R.L. 4/17/96              *
C***********************************************************************

      SUBROUTINE G2RINI(GCLON,GCLAT,FLON,FLAT,N00,N10,N11,N01,D00,D10,
     *     D11,D01,NP,LONB,LATB)
      USE SIZES
      IMPLICIT NONE
      INTEGER,SAVE :: ICALL = 0
      INTEGER NP,N,I,LONB,LATB,NLAT,NLON,LON,LONP1,LAT,LATP1
      REAL*8 DLAT,DLON,FLONWORK,COLAT,DDLAT,XLAT,DFLAT,DFLAT1,
     *     DDLON,XLON,DFLON,DFLON1
      REAL*8 FLAT(*),FLON(*)
      REAL(SZ) GCLAT(*),GCLON(*)
      INTEGER  N00(*),N10(*),N11(*),N01(*)
      REAL(SZ) D00(*),D10(*),D11(*),D01(*)
C     
      IF( ICALL .EQ. 0 ) THEN
         ICALL = 1
c       PRINT 1234
c1234   FORMAT(' = IN ROUTINE G2RINI FOR HORIZONTAL INTERPOLATION = ')

C...Compute estimated DLAT, true DLON for Gaussian grid

         NLAT=LATB
         NLON=LONB
         DLAT=PI/FLOAT(NLAT-1)
         DLON=TWOPI/FLOAT(NLON)
         N=0

C...Loop through all the nodes in the grid to be interpolated onto and
C.....compute the interpolating factors.

         DO I=1,NP
           
C.....Compute initial guess of which lon value FLON(I) is in the Gaussian file
C.......Check that this value is reasonable.

            FLONWORK=FLON(I)
            IF(FLONWORK.LT.0.) FLONWORK=FLONWORK+TWOPI
            LON=FLONWORK/DLON + 1
            LONP1=LON+1
            IF(LON.EQ.NLON) LONP1=1 !Circle condition
            IF((LON.LT.1).OR.(LON.GT.NLON)) THEN
               PRINT *,' ***** ERROR IN LON ****'
               PRINT *,' I ',I
               PRINT *,' LON ',LON
               PRINT *,' DLON ',DLON
               PRINT *,' FLON ',FLON(I)
               STOP
            ENDIF  
            
C.....Compute initial guess of which lat value FLAT(I) is in the Gaussian file
C.......Check that this value is reasonable.

            COLAT=HFPI-FLAT(I)
            LAT=COLAT/DLAT + 1
            IF(LAT.EQ.NLAT) LAT=LAT-1
            LATP1=LAT+1
            IF((LAT.LT.1).OR.(LAT.GT.NLAT)) THEN
               PRINT *,' ***** ERROR IN LAT ****'
               PRINT *,' I ',I
               PRINT *,' LAT ',LAT
               PRINT *,' DLAT ',DLAT
               PRINT *,' FLAT ',FLAT(I)
               STOP
            ENDIF

 5          CONTINUE
            IF((COLAT.GE.GCLAT(LAT)).AND.(COLAT.LE.GCLAT(LATP1))) GO TO 9
            IF(COLAT.LT.GCLAT(LAT)) THEN
               LATP1=LAT
               LAT=LAT-1
               IF(LAT.LE.0) THEN
                  LAT=1
                  LATP1=2
                  GOTO 9
               ENDIF
               GOTO 5
            ENDIF
            IF(COLAT.GT.GCLAT(LATP1)) THEN
               LAT=LAT+1
               LATP1=LAT+1
               IF(LAT.GE.NLAT ) THEN
                  LAT=NLAT-1
                  LATP1=NLAT
                  GOTO 9
               ENDIF
               GOTO 5
            ENDIF
            
 9          CONTINUE
            DDLAT=GCLAT(LATP1)-GCLAT(LAT)
            XLAT=GCLAT(LAT)
            DFLAT1=(COLAT-XLAT)/DDLAT
            IF(LAT.EQ.1) DFLAT1=MAX(0.d0,DFLAT1) !MODIFY THIS FOR POLAR POINTS
            IF(LATP1.EQ.NLAT) DFLAT1=MIN(1.d0,DFLAT1) !MODIFY THIS FOR POLAR POINTS
            DFLAT=1.d0-DFLAT1
            DDLON=DLON
            XLON=GCLON(LON)
            DFLON1=(FLONWORK-XLON)/DDLON
            DFLON=1.d0-DFLON1
            N=N+1
            D00(N)=DFLON*DFLAT
            D10(N)=DFLON1*DFLAT
            D11(N)=DFLON1*DFLAT1
            D01(N)=DFLON*DFLAT1
            N00(N)=LON+(LAT-1)*NLON
            N10(N)=LONP1+(LAT-1)*NLON
            N11(N)=LONP1+(LATP1-1)*NLON
            N01(N)=LON+(LATP1-1)*NLON
            
         END DO
         
c     WRITE(*,*) ' D00 TO D11 SHOULD BE ALL POSITIVE.'
         
      ELSE
c     WRITE(*,*) ' G2RINI ALREADY CALLED '
      ENDIF
      
      RETURN
      END SUBROUTINE


C***********************************************************************
C                                                                      *
C   Read in and interpolate onto the ADCIRC grid wind fields from U.S. *
C   National Weather Service ETA-29 model that have been stripped down *
C   and given to us by NOAA.                                           *
C                                                                      *
C   The input files are in binary and have been created by NOAA and    *
C   contain only the U 10M, V 10M, (M/S) and surface P fields (mbars). *
C                                                                      *
C   The ETA-29 model uses an E grid and therefore the U and V          *
C   components are not oriented along lines of constant latitute and   *
C   longitude. These must be converted to be useful in ADCIRC.         *
C                                                                      *
C   NOTE: The ADCIRC grid information consists only of the Lon and Lat *
C   of the nodes.  THE LONS AND LATS MUST BE IN RADIANS!               *
C                                                                      *
C   Output from this subroutine is U,V (M/S) and P (M H20) on the      *
C   ADCIRC grid.                                                       *
C                                                                      *
C   MNWLAT = LATB = 271    FOR ETA-29 GRID                             *
C   MNWLON = LONB = 181    FOR ETA-29 GRID                             *
C                                                                      *
C                           R.L. 1/11/97                               *
C   R.L.09/04/00 added RHOWAT0 to call                                 *
C   R.L. 4/02/01  elminiated MNWP as a dimension                       *
C   R.L. 9/14/01  changed MNWLAT,MNWLON in ALLOCATE statement to       *
C                271,181                                               *
C***********************************************************************

      SUBROUTINE NWS11GET(NWSEGWI,IDSETFLG,FLON,FLAT,ULL,VLL,PLL,NP,
     *     RHOWAT0,G)
      USE SIZES
      IMPLICIT NONE
      INTEGER,SAVE  ::  ICALL = 0
      INTEGER NWSEGWI,IDSETFLG,NP,I,IEXT,IDIG1,IDIG2,IDIG3,KERR,N
      INTEGER IYEAR,IMONTH,IDAY,IHOUR
      REAL*8 RHOWATG100,FLONDEG,FLATDEG
      REAL(SZ) P1,P2,P3,U1,U2,U3,V1,V2,V3,UE29,VE29,CBETAU,SBETAU,G
      REAL(SZ) RHOWAT0
      REAL(SZ) ULL(*),VLL(*),PLL(*)
      REAL*8 FLAT(*),FLON(*)
C     
      INTEGER,SAVE,ALLOCATABLE ::  N1(:),N2(:),N3(:)
      REAL(SZ),SAVE,ALLOCATABLE :: D1(:),D2(:),D3(:),BETAU(:)
      REAL(SZ),SAVE,ALLOCATABLE :: UE(:),VE(:),PE(:)
C     
      CHARACTER*1 FNAME2(8)
      CHARACTER*8 FNAME1
      EQUIVALENCE (FNAME1,FNAME2)
      LOGICAL FOUND
C     
      IF (ICALL.EQ.0) THEN
         ICALL = 1
         ALLOCATE ( N1(MNP),N2(MNP),N3(MNP) )
         ALLOCATE ( D1(MNP),D2(MNP),D3(MNP),BETAU(MNP) )
         ALLOCATE ( UE(181*271),VE(181*271),PE(181*271) )
      ENDIF
C     
      RHOWATG100=RHOWAT0*G*100.d0

C...  The first time the subroutine is called, setup the interpolating factors
C...  between the Eta-29 grid and the ADCIRC grid.

      IF((NWSEGWI.EQ.0).AND.(IDSETFLG.EQ.0)) THEN
         WRITE(*,*) 'Computing ETA29 met field interpolating factors'
         DO I=1,NP
            flondeg=rad2deg*flon(i)
            flatdeg=rad2deg*flat(i)
            CALL E29SEARCH(I,FLONDEG,FLATDEG,N1(I),N2(I),N3(I),
     *           D1(I),D2(I),D3(I),betau(i))
         END DO
         RETURN
      ENDIF

C...  Figure out the met data file name

      FNAME1='fort.   '
      IEXT=200 + NWSEGWI
      IDIG1=IEXT/100
      IDIG2=(IEXT-100*IDIG1)/10
      IDIG3=(IEXT-100*IDIG1-10*IDIG2)
      FNAME2(6)=CHAR(IDIG1+48)
      FNAME2(7)=CHAR(IDIG2+48)
      FNAME2(8)=CHAR(IDIG3+48)

C...  If appropriate, enter, locate and open the met data file

 1010 FORMAT(' File ',A8,' WAS NOT FOUND!  FATAL ERROR',/)
 1011 FORMAT(' File ',A8,' WAS FOUND!  Opening & Processing file',/)

      WRITE(*,*) '  '
      INQUIRE(FILE=FNAME1,EXIST=FOUND)
      IF(FOUND) GOTO 32
      WRITE(*,1010) FNAME1
      WRITE(16,1010) FNAME1
      STOP
 32   WRITE(*,1011) FNAME1
      IF((NWSEGWI.EQ.0).OR.(IDSETFLG.EQ.1)) OPEN(IEXT,FILE=FNAME1,
     *     status='old',access='sequential',form='unformatted',iostat=kerr)

C...  Read the met data file

      READ(IEXT,END=1100) IYEAR,IMONTH,IDAY,IHOUR
      READ(IEXT,END=1100) UE,VE,PE

      IF(NWSEGWI.EQ.0) THEN     !If the first file, read until the end
         DO I=2,IDSETFLG
            READ(IEXT,END=1100) IYEAR,IMONTH,IDAY,IHOUR
            READ(IEXT,END=1100) UE,VE,PE
         ENDDO
      ENDIF

 1100 IF(IDSETFLG.EQ.8) CLOSE(IEXT)

C.....Interpolate onto ADCIRC grid
C.....Convert velocity from the E grid reference to a lat/lon reference
C.....Convert pressure from millibars to N/M^2 to M of H20

      DO N=1,NP
         P1=PE(N1(N))
         P2=PE(N2(N))
         P3=PE(N3(N))
         U1=UE(N1(N))
         U2=UE(N2(N))
         U3=UE(N3(N))
         V1=VE(N1(N))
         V2=VE(N2(N))
         V3=VE(N3(N))
         UE29=U1*D1(N)+U2*D2(N)+U3*D3(N)
         VE29=V1*D1(N)+V2*D2(N)+V3*D3(N)
         CBETAU=COS(BETAU(N))
         SBETAU=SIN(BETAU(N))
         ULL(N)=UE29*CBETAU - VE29*SBETAU
         VLL(N)=UE29*SBETAU + VE29*CBETAU
         PLL(N)=P1*D1(N)+P2*D2(N)+P3*D3(N)
         PLL(N)=PLL(N)/RHOWATG100
      END DO

      RETURN
      END SUBROUTINE



C***********************************************************************
C  Subroutine to find where a given lon,lat falls in the Eta29 grid,   *
C     determine the interpolating factors to interpolate Eta29 fields  *
C     to that position, and finally to compute the angle to rotate the *
C     Eta29 velocity field to get to a lon, lat coordinated system.    *
C                                                                      *
C                    Written by R.L.       1/12/98                     *
C***********************************************************************

      subroutine e29search(node,FLON,FLAT,NN1,NN2,NN3,DD1,DD2,DD3,betau)
      implicit none
      integer nn1,nn2,nn3,node,icode,nwlon,nwlat,ifflag
      integer i,j,im2,jm2,n,ia,ja,na,ib,jb,nb,ic,jc,nc,id,jd,nd,
     *  ie,je,ne,ig,jg,ng,if
      real(sz) dd1,dd2,dd3,betau,ri,x1,x2,x3,x4,y1,y2,y3,y4
      real(sz) aemin,areas,a1,a2,a3,aa,ae,lambda
      real(8) lamda0,phi0,rphi0,cphi0,sphi0,tphi0,dlamda,dphi,rdlamda,
     *       rdphi,rflat,tflat,sflat,cflat,a,rlamar,cphiicrlamda,phiarg,
     *       rphii,rlamda,ri1,ri2,rj,dgtora,flon,flat
      real(sz) lamda,lamdaa,lamdab,lamdac,lamdad,lamdae,lamdag
      real(sz) phi,phia,phib,phic,phid,phie,phig
c
      icode=0
      nwlon=181
      nwlat=271
      dgtora=deg2rad
      lamda0=-97.0d0
      phi0=41.0d0
      rphi0=dgtora*phi0
      cphi0=cos(rphi0)
      sphi0=sin(rphi0)
      tphi0=tan(rphi0)
      dlamda=7.d0/36.d0
      dphi=5.d0/27.d0
      rdlamda=dgtora*dlamda
      rdphi=dgtora*dphi
c
      rflat=flat*dgtora
        tflat=tan(rflat)
      sflat=sin(rflat)
      cflat=cos(rflat)

c     compute the position of the closest node in the E29 grid

      a=flon-lamda0
      rlamar=cos(a*dgtora)
      cphiicrlamda=(rlamar+tflat*tphi0)*cflat*cphi0
      phiarg=sflat
      rphii=asin((phiarg-sphi0*cphiicrlamda)/cphi0)
      rlamda=acos(cphiicrlamda/cos(rphii))
      if(flon.lt.lamda0) rlamda=-rlamda
c
      ri2=(rlamda/rdlamda+nwlon+1)/2.
      ri1=(rlamda/rdlamda+nwlon)/2.
      rj=rphii/rdphi+(nwlat+1)/2
      j=(rj+0.5d0)
      ri=ri1
      if(mod(j,2).eq.0) ri=ri2
      i=(ri+0.5d0)

c     write(*,*) "lamda, phi = ",flon,flat
c     write(*,*) "ri1, ri2, ri, rj = ",ri1,ri2,ri,rj
c     write(*,*) "i, j = ",i,j

      if ((rj.lt.1).or.(rj.gt.nwlat)) then
c        write(333,*) 'ADCIRC grid node ',node,
c     &             ' falls outside of the ETA 29 grid'
        icode=1
        NN1=1
        NN2=1
        NN3=1
        DD1=0
        DD2=0
        DD3=0
        return
      endif

      if (mod(j,2).eq.0) then
         if ((ri.lt.1).or.(ri.gt.(nwlon+0.5d0))) then
c          write(333,*) 'ADCIRC grid node ',node,
c     &                 ' falls outside of the ETA 29 grid'
            icode=1
            NN1=1
            NN2=1
            NN3=1
            DD1=0
            DD2=0
            DD3=0
            return
         endif
      endif
      
      if (mod(j,2).ne.0) then
         if ((ri.lt.0.5).or.(ri.gt.nwlon)) then
c           write(333,*) 'ADCIRC grid node ',node,
c     &                 ' falls outside of the ETA 29 grid'
            icode=1
            NN1=1
            NN2=1
            NN3=1
            DD1=0
            DD2=0
            DD3=0
            return
         endif
      endif
      
c     compute the coordinates of the closest Eta29 grid node

      jm2=(nwlat+1)/2
      im2=nwlon*2
      call e29calc(i,j,lamda,phi,n)

c     compute the coordinates of neighbor node "a" (located SW of closest node)

      if ((i.eq.1).and.(mod(j,2).eq.0)) then
         ia=i
         ja=j-2
      else
         ia=i
         if(mod(j,2).eq.0) ia=i-1
         ja=j-1
      endif
c                                 this neighbor lies outside of Eta29 grid
      if ((ia.lt.1).or.(ja.lt.1)) then
         na=0
      else
         call e29calc(ia,ja,lamdaa,phia,na)
      endif

c     compute the coordinates of neighbor node "b" (located W of closest node)

      ib=i-1
      jb=j
      if (ib.lt.1) then         !this neighbor lies outside of Eta29 grid
         nb=0
      else
         call e29calc(ib,jb,lamdab,phib,nb)
      endif

c     compute the coordinates of neighbor node "c" (located NW of closest node)

      if ((i.eq.1).and.(mod(j,2).eq.0)) then
         ic=i
         jc=j+2
      else
         ic=ia
         jc=j+1
      endif
c                                    this neighbor lies outside of Eta29 grid
      if ((ic.lt.1).or.(jc.gt.nwlat)) then  
         nc=0
      else
         call e29calc(ic,jc,lamdac,phic,nc)
      endif

c     compute the coordinates of neighbor node "d" (located NE of closest node)

      if ((i.eq.181).and.(mod(j,2).ne.0)) then
         id=i
         jd=j+2
      else
         id=ic+1
         jd=j+1
      endif
c                                    this neighbor lies outside of Eta29 grid
      if ((id.gt.nwlon).or.(jd.gt.nwlat)) then  
         nd=0
      else
         call e29calc(id,jd,lamdad,phid,nd)
      endif

c     compute the coordinates of neighbor node "e" (located E of closest node)

      ie=i+1
      je=j
      if (ie.gt.nwlon) then     !this neighbor lies outside of Eta29 grid
         ne=0
      else
         call e29calc(ie,je,lamdae,phie,ne)
      endif
      
c     compute the coordinates of neighbor node "g" (located SE of closest node)

      if ((i.eq.181).and.(mod(j,2).ne.0)) then
         ig=i
         jg=j-2
      else
         ig=id
         jg=j-1
      endif
c                                    this neighbor lies outside of Eta29 grid
      if ((ig.gt.nwlon).or.(jg.lt.1)) then  
         ng=0
      else
         call e29calc(ig,jg,lamdag,phig,ng)
      endif

c      write(*,*) 'closest E29 node i,j = ',n,i,j,lamda,phi
c      if(na.eq.0) write(*,*) 'point a falls outside of Eta29 grid'
c      if(na.ne.0) write(*,*) 'point a   = ',na,ia,ja,lamdaa,phia
c      if(nb.eq.0) write(*,*) 'point b falls outside of Eta29 grid'
c      if(nb.ne.0) write(*,*) 'point b   = ',nb,ib,jb,lamdab,phib
c      if(nc.eq.0) write(*,*) 'point c falls outside of Eta29 grid'
c      if(nc.ne.0) write(*,*) "point c   = ",nc,ic,jc,lamdac,phic
c      if(nd.eq.0) write(*,*) 'point d falls outside of Eta29 grid'
c      if(nd.ne.0) write(*,*) "point d   = ",nd,id,jd,lamdad,phid
c      if(ne.eq.0) write(*,*) 'point e falls outside of Eta29 grid'
c      if(ne.ne.0) write(*,*) "point e   = ",ne,ie,je,lamdae,phie
c      if(ng.eq.0) write(*,*) 'point g falls outside of Eta29 grid'
c      if(ng.ne.0) write(*,*) "point g   = ",ng,ig,jg,lamdag,phig

      NN1=1
      NN2=1
      NN3=1
      DD1=0
      DD2=0
      DD3=0
      X1=lamda
      X4=flon
      Y1=phi
      Y4=flat
      ifflag=0
      AEMIN=99999.d0

c     test if the point is in triangle ij - b - a

      if ((na.ne.0).and.(nb.ne.0)) then
         X2=lamdab
         X3=lamdaa
         Y2=phib
         Y3=phia
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            AEMIN=AE
            NN1=n
            NN2=nb
            NN3=na
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,ib,jb,DD2,ia,ja,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - b - a'
         ENDIF
      endif

c     if along the west boundary, test if the point is in triangle ij - c - a

      if((i.eq.1).and.(mod(j,2).ne.0)) then
         if((na.ne.0).and.(nc.ne.0)) then
            X2=lamdac
            X3=lamdaa
            Y2=phic
            Y3=phia
            AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
            A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
            A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
            A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
            AA=ABS(A1)+ABS(A2)+ABS(A3)
            AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
            IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
               NN1=n
               NN2=nc
               NN3=na
               DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
               DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
               DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
               call betaucalc(i,j,DD1,ic,jc,DD2,ia,ja,DD3,betau)
               ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - c - a'
            ENDIF
         endif
      endif

c     test if the point is in triangle ij - c - b

      if((nb.ne.0).and.(nc.ne.0)) then
         X2=lamdac
         X3=lamdab
         Y2=phic
         Y3=phib
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            NN1=n
            NN2=nc
            NN3=nb
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,ic,jc,DD2,ib,jb,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - c - b'
         ENDIF
      endif

c     test if the point is in triangle ij - d - c

      if((nc.ne.0).and.(nd.ne.0)) then
         X2=lamdad
         X3=lamdac
         Y2=phid
         Y3=phic
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            NN1=n
            NN2=nd
            NN3=nc
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,id,jd,DD2,ic,jc,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - d - c'
         ENDIF
      endif

c     if along the east boundary, test if the point is in triangle ij - g - d

      if((i.eq.181).and.(mod(j,2).eq.0)) then
         if((nd.ne.0).and.(ng.ne.0)) then
            X2=lamdag
            X3=lamdad
            Y2=phig
            Y3=phid
            AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
            A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
            A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
            A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
            AA=ABS(A1)+ABS(A2)+ABS(A3)
            AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
            IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
               NN1=n
               NN2=ng
               NN3=nd
               DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
               DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
               DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
               call betaucalc(i,j,DD1,ig,jg,DD2,id,jd,DD3,betau)
               ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - g - d'
            ENDIF
         endif
      endif

c     test if the point is in triangle ij - e - d

      if((nd.ne.0).and.(ne.ne.0)) then
         X2=lamdae
         X3=lamdad
         Y2=phie
         Y3=phid
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            NN1=n
            NN2=ne
            NN3=nd
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,ie,je,DD2,id,jd,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - e - d'
         ENDIF
      endif

c     test if the point is in triangle ij - g - e

      if((ne.ne.0).and.(ng.ne.0)) then
         X2=lamdag
         X3=lamdae
         Y2=phig
         Y3=phie
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            NN1=n
            NN2=ng
            NN3=ne
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,ig,jg,DD2,ie,je,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - g - e'
         ENDIF
      endif

c     test if the point is in triangle ij - a - g

      if((na.ne.0).and.(ng.ne.0)) then
         X2=lamdaa
         X3=lamdag
         Y2=phia
         Y3=phig
         AREAS=ABS((X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3))
         A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
         A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
         A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
         AA=ABS(A1)+ABS(A2)+ABS(A3)
         AE=ABS(AA-AREAS)/AREAS
c     write(333,*) "AE = ",AE
         IF((AE.LT.1.0d-5).AND.(AE.LT.AEMIN)) THEN
            NN1=n
            NN2=na
            NN3=ng
            DD1=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS
            DD2=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS
            DD3=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS
            call betaucalc(i,j,DD1,ia,ja,DD2,ig,jg,DD3,betau)
            ifflag=ifflag+1
c     write(333,*) 'position found in triangle ij - a - g'
         ENDIF
      endif

c      if(ifflag.eq.0) then
c        write(333,*) 'position not found'
c        write(*,*) 'position not found in subroutine E29SEARCH'
c        icode=3
c        else
c       write(*,*) 'i,j,NN1,NN2,NN3,DD1,DD2,DD3'
c        write(333,999) i,j,NN1,NN2,NN3,DD1,DD2,DD3,betau/dgtora
c 999    format(5I8,1x,3E13.6)
c        endif

      return
      end subroutine



C***********************************************************************
C  Subroutine to compute the longititude and latitude of a given i,j   *
C       position in the Eta29 grid.                                    *
C                                                                      *
C                    Written by R.L.       1/11/98                     *
C***********************************************************************

      subroutine e29calc(i,j,lamda,phi,n)
      implicit none
      integer i,j,n,nwlon,nwlat,im2,jm2,i1,i2,i1p1,i1m1,i2p1,i2m1,
     *     i3p1,i3m1
      real(sz) lamda,phi,phii,dlon,dlat,dlnt,arg,betau1,betau2,betau3
      real(8) lamda0,phi0,rphi0,cphi0,sphi0,tphi0,dlamda,dphi,rdlamda,
     *     rdphi,a,rlamar,phiarg,rlamda,dgtora
c     
      nwlon=181
      nwlat=271
      dgtora=deg2rad
      lamda0=-97.0d0
      phi0=41.0d0
      rphi0=dgtora*phi0
      cphi0=cos(rphi0)
      sphi0=sin(rphi0)
      tphi0=tan(rphi0)
      dlamda=7.d0/36.d0
      dphi=5.d0/27.d0
      rdlamda=dgtora*dlamda
      rdphi=dgtora*dphi
c     
      jm2=(nwlat+1)/2
      im2=nwlon*2
c     
      phii=rdphi*float(j-jm2)
      i1=2*i-1
      i2=2*i
      if(mod(j,2).ne.0) then
         rlamda=rdlamda*float(i2-nwlon)
      else
         rlamda=rdlamda*float(i1-nwlon)
      endif
      phiarg= sin(phii)*cphi0+cos(phii)*sphi0*cos(rlamda)
      if(phiarg.gt.1.0d0) phiarg=1.0d0
      if(phiarg.lt.-1.0d0) phiarg=-1.0d0
      phi=asin(phiarg)
      rlamar= cos(phii)*cos(rlamda)/(cos(phi)*cphi0)-tan(phi)*tphi0
      if(rlamar.gt.1.0d0) rlamar=1.0d0
      if(rlamar.lt.-1.d0) rlamar=-1.d0
      a=acos(rlamar)/dgtora
      if(rlamda.le.0.) then
         lamda=lamda0-a
      else
         lamda=lamda0+a
      endif
      phi=phi/dgtora
      n=nwlon*(j-1)+i
C     
      return
      end subroutine


C***********************************************************************
C  Subroutine to compute the conversion angle between the E29 velocity *
C       field and a lon,lat coordinate system.                         *
C                                                                      *
C                    Written by R.L.       1/12/98                     *
C***********************************************************************

      subroutine betaucalc(i1,j1,dd1,i2,j2,dd2,i3,j3,dd3,betau)
      implicit none
      integer i1,j1,i2,j2,i3,j3,n,i1p1,i1m1,i2p1,i2m1,i3p1,i3m1
      real(sz) dd1,dd2,dd3,betau
      real(sz) lamda,lamdap1,lamdam1,phi,phip1,phim1,dlon,dlat,
     *     dlnt,arg,betau1,betau2,betau3,dgtora
c     
      dgtora=deg2rad
c     
      if(i1.ne.181) then
         i1p1=i1+1
      else
         i1p1=i1
      endif
      if(i1.ne.1) then
         i1m1=i1-1
      else
         i1m1=i1
      endif
      call e29calc(i1,j1,lamda,phi,n)
      call e29calc(i1p1,j1,lamdap1,phip1,n)
      call e29calc(i1m1,j1,lamdam1,phim1,n)
      dlon=(lamdap1-lamdam1)*cos(phi*dgtora)
      dlat=phip1-phim1
      dlnt=sqrt(dlon*dlon+dlat*dlat)
      arg=dlat/dlnt
      if(arg.gt.1.d0) arg=1.d0
      if(arg.lt.-1.d0) arg=-1.d0
      betau1=asin(arg)
c     
      if(i2.ne.181) then
         i2p1=i2+1
      else
         i2p1=i2
      endif
c     
      if(i2.ne.1) then
         i2m1=i2-1
      else
         i2m1=i2
      endif
c     
      call e29calc(i2,j2,lamda,phi,n)
      call e29calc(i2p1,j2,lamdap1,phip1,n)
      call e29calc(i2m1,j2,lamdam1,phim1,n)
      dlon=(lamdap1-lamdam1)*cos(phi*dgtora)
      dlat=phip1-phim1
      dlnt=sqrt(dlon*dlon+dlat*dlat)
      arg=dlat/dlnt
      if(arg.gt.1.d0) arg=1.d0
      if(arg.lt.-1.d0) arg=-1.d0
      betau2=asin(arg)
c     
      if(i3.ne.181) then
         i3p1=i3+1
      else
         i3p1=i3
      endif
c     
      if(i3.ne.1) then
         i3m1=i3-1
      else
         i3m1=i3
      endif
c     
      call e29calc(i3,j3,lamda,phi,n)
      call e29calc(i3p1,j3,lamdap1,phip1,n)
      call e29calc(i3m1,j3,lamdam1,phim1,n)
      dlon=(lamdap1-lamdam1)*cos(phi*dgtora)
      dlat=phip1-phim1
      dlnt=sqrt(dlon*dlon+dlat*dlat)
      arg=dlat/dlnt
      if(arg.gt.1.d0) arg=1.d0
      if(arg.lt.-1.d0) arg=-1.d0
      betau3=asin(arg)
      betau=dd1*betau1+dd2*betau2+dd3*betau3
C     
      return
      end subroutine

C***********************************************************************
C                                                                      *
C   End of subroutines to read wind and pressure fields                * 
C                                                                      *
C***********************************************************************


C***********************************************************************
C                                                                      *
C   Read onto the ADCIRC grid radiation stress fields in the PBL-JAG   *
C   (hurricane) model format.                                          *
C                                                                      *
C                                                                      *
C                           R.L.05/12/99                               *
C***********************************************************************

      SUBROUTINE RSGET(RSNX,RSNY,NP)
      USE SIZES
      IMPLICIT NONE
      INTEGER NP,I,NHG
      REAL(SZ) RSNX(*),RSNY(*)
      CHARACTER*80 PBLJAGF
C     
      DO I=1,NP
         RSNX(I)=0.d0
         RSNY(I)=0.d0
      END DO
 170  READ(23,'(A80)') PBLJAGF
      IF(PBLJAGF(2:2).EQ.'#') GOTO 170
 171  READ(PBLJAGF,'(I8,5E13.5)') NHG,RSNX(NHG),RSNY(NHG)
      READ(23,'(A80)') PBLJAGF
      IF(PBLJAGF(2:2).NE.'#') GOTO 171
C     
      RETURN
      END SUBROUTINE


      END MODULE
C***********************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001  
C    last changes in this file prior to VERSION 41.01
C
C  mod history
C  v40.02mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx 
c***********************************************************************
c                                                                      *
c   PADCIRC MODULE  ( HARM )                                           *
c                                                                      *
c   HA_SUBS.FOR     V3.01        11/9/95                               *
c                                                                      *
c   Least Square harmonic analysis of timeseries from ADCIRC2DDI_v27   *
c                                                                      *
c    Notes:                                                            *
c    1.)  Both the left hand side matrix and the right hand side       *
c         forcing vectors are continuously updated in time.  This      *
c         eliminates the need to store time series outputs for later   *
c         harmonic analysis.                                           *
c    2.)  The left hand side matrix and the right hand side forcing    *
c         vectors are output in the hotstart file and can be used to   *
c         perform harmonic analysis on an incomplete run.              *
c    3.)  Frequencies should be in rad/sec,times should be in sec.     *
c                                                                      *
c***********************************************************************
c                                                                      *
c    Program Written by:                                               *
c          R.A. Luettich, IMS UNC                                      *
c          J.J. Westerink, CE ND                                       *
c                                                                      *
c    Program Development History:                                      *
c    1.) lsq_stations_v004 by JJW                                      *
c    2.) LSQEX by RL used in 2D binary extr program                    *
c    3.) LSQRL by RL used in 1D test codes                             *
c    4.) LSQ2D v1.00-v2.26 by RL real time Harmonic Analysis for ADCIRC*
c    5.) HA_SUBS v3.01 by RL real time HA for ADCIRC separate          *
c        subroutines for elevation station, velocity station,          *
c        global elevation and global velocity harmonic analysis        *
c                                                                      *
c***********************************************************************
c                                                                      *
c SUBROUTINE LSQUPDLHS updates the LHS matrix                          *
c SUBROUTINE LSQUPDES updates the RHS load vector for elev stations    *
c SUBROUTINE LSQUPDVS updates the RHS load vector for velocity stations*
c SUBROUTINE LSQUPDEG updates the RHS load vector for elevation global *
c SUBROUTINE LSQUPDVG updates the RHS load vector for velocity global  *
c SUBROUTINE FULSOL fills out, decomposes and solves the matricies     *
c SUBROUTINE LSQSOLES solves & writes output for elevation stations    *
c SUBROUTINE LSQSOLVS solves & writes output for velocity stations     *
c SUBROUTINE LSQSOLEG solves & writes output for elevation global      *
c SUBROUTINE LSQSOLVG solves & writes output for velocity global       *
c SUBROUTINE HAHOUT writes HA parameters & LHS matrix to hotstart file *
c SUBROUTINE HAHOUTES writes elev sta RHS load vector to hotstart file *
c SUBROUTINE HAHOUTVS writes vel sta RHS load vector to hotstart file  *
c SUBROUTINE HAHOUTEG writes glob elev RHS load vector to hotstart file*
c SUBROUTINE HAHOUTVG writes glob vel RHS load vector to hotstart file *
c SUBROUTINE HACOLDS initializes HA param & LHS matrix for cold start  *
c SUBROUTINE HACOLDSES initializes elev sta RHS load vec for cold start*
c SUBROUTINE HACOLDSVS initializes vel sta RHS load vec for cold start *
c SUBROUTINE HACOLDSEG initializes glob ele RHS load vec for cold start*
c SUBROUTINE HACOLDSVG initializes glob vel RHS load vec for cold start*
c SUBROUTINE HAHOTS initializes HA params & LHS matrix for a hot start *
c SUBROUTINE HAHOTSES initializes elev sta RHS load vec for hot start  *
c SUBROUTINE HAHOTSVS initializes vel sta RHS load vec for hot start   *
c SUBROUTINE HAHOTSEG initializes glob elev RHS load vec for hot start *
c SUBROUTINE HAHOTSVG initializes glob vel RHS load vec for hot start  *
c                                                                      *
c***********************************************************************
c                                                                      *
c    INPUT FILES:                                                      *
c      - Frequency information is read in by ADCIRC from unit 15.      *
c        This information is passed in common block LSQFREQS.          *
c                                                                      *
c      - If the model is hot start, input is read from UNIT 67 or 68   *
c                                                                      *
c    OUTPUT FILES:                                                     *
C      UNIT 51 : HARMONIC CONSTITUENT ELEVATION VALUES AT SPECIFIED    *
C                  ELEVATION RECORDING STATION COORDINATES (ASCII)     *
C      UNIT 52 : HARMONIC CONSTITUENT VELOCITY VALUES AT SPECIFIED     *
C                  VELOCITY RECORDING STATION COORDINATES  (ASCII)     *
C      UNIT 53 : HARMONIC CONSTITUENT ELEVATIONS AT ALL NODES (ASCII)  *
C      UNIT 54 : HARMONIC CONSTITUENT VELOCITIES AT ALL NODES (ASCII)  *
C      UNIT 55 : COMPARISON BETWEEN THE MEAN AND VARIANCE OF THE TIME  *
C                  SERIES GENERATED BY THE MODEL AND THE MEAN AND      *
C                  VARIANCE OF A TIME SERIES RESYNTHESIZED FROM THE    *
C                  COMPUTED HARMONIC CONSTITUENTS.  THIS GIVES AN      *
C                  INDICATION OF HOW COMPLETE THE HARMONIC ANALYSIS    *
C                  WAS. (ASCII)                                        *
C      UNIT 67 or 68 : HOT START FILES (BINARY)                        *
c                                                                      *
c***********************************************************************
C
      MODULE HARM
C
      USE SIZES
C
      REAL(8),PRIVATE,PARAMETER :: PI=3.141592653589793D0
      INTEGER NFREQ
      CHARACTER*10,ALLOCATABLE ::  NAMEFR(:)
      REAL(SZ),    ALLOCATABLE ::  HAFREQ(:),HAFF(:),HAFACE(:)
C
      INTEGER, PRIVATE,SAVE :: NZ, NF, MM, ITUD, ICALL
      REAL(8), PRIVATE,SAVE :: TIMEUD
      REAL(SZ),PRIVATE,ALLOCATABLE ::  HA(:,:)
      REAL(SZ),PRIVATE,ALLOCATABLE ::  HAP(:),HAX(:)
      REAL(SZ),PRIVATE,ALLOCATABLE ::  GLOELV(:,:)
      REAL(SZ),PRIVATE,ALLOCATABLE ::  GLOULV(:,:),GLOVLV(:,:)
      REAL(SZ),PRIVATE,ALLOCATABLE ::  STAELV(:,:)
      REAL(SZ),PRIVATE,ALLOCATABLE ::  STAULV(:,:),STAVLV(:,:)


C-----------------END OF DECLARATIONS---------------------------------------

      CONTAINS


C
C***********************************************************************
C  Allocate arays used by LSQ_HARM.
C
C  vjp 8/99
C***********************************************************************
C
      SUBROUTINE ALLOC_HA()
      ALLOCATE ( HAFREQ(MNHARF),HAFF(MNHARF),HAFACE(MNHARF) )
      ALLOCATE ( NAMEFR(MNHARF) )
C     
      ALLOCATE ( HA(2*MNHARF,2*MNHARF) )
      ALLOCATE ( HAP(2*MNHARF),HAX(2*MNHARF) )
      ALLOCATE ( GLOELV(2*MNHARF,MNP) )
      ALLOCATE ( GLOULV(2*MNHARF,MNP),GLOVLV(2*MNHARF,MNP) )
      ALLOCATE ( STAELV(2*MNHARF,MNSTAE) )
      ALLOCATE ( STAULV(2*MNHARF,MNSTAV),STAVLV(2*MNHARF,MNSTAV) )
      
      RETURN
      END SUBROUTINE
      

c***********************************************************************
c   Subroutine to update the Left Hand Side Matrix                     *
c                                                                      *
c  TIME  - ABSOLUTE MODEL TIME (SEC)                                   *
c  IT    - MODEL TIME STEP                                             *
c  icall - number of times the subroutine has been called              *
c  a     - Left Hand Side Matrix                                       *
c                                                                      *
c                        RL 11/7/95                                    *
c***********************************************************************
c
      SUBROUTINE LSQUPDLHS(TIME,IT)
      IMPLICIT NONE
      INTEGER IT,I,J,I1,I2,J1,J2
      REAL(SZ) TF1,TF2
      REAL(8) TIME
c
      icall = icall + 1
c     
c***** Update the Left Hand Side Matrix
c     Note: this is a symmetric matrix and therefore only store the
c     upper triangular part.  The lower part will be filled out in
c     SUBROUTINE FULSOL prior to the matrix's decomposition

c     Take care of the steady constituent if included in the analysis

      if(nf.eq.1) then
         ha(1,1)=icall
         do j=1,nfreq
            tf1=hafreq(j+nf)*time
            ha(1,2*j)   = ha(1,2*j) + cos(tf1)
            ha(1,2*j+1) = ha(1,2*j+1) + sin(tf1)
         end do
      endif

c   Take care of the other constituents

      do i=1,nfreq
         do j=i,nfreq
            i1=2*i-(1-nf)
            i2=i1+1
            j1=2*j-(1-nf)
            j2=j1+1
            tf1=hafreq(i+nf)*time
            tf2=hafreq(j+nf)*time
            ha(i1,j1) = ha(i1,j1) + cos(tf1)*cos(tf2)
            ha(i1,j2) = ha(i1,j2) + cos(tf1)*sin(tf2)
            ha(i2,j2) = ha(i2,j2) + sin(tf1)*sin(tf2)
            if(i2.le.j1) ha(i2,j1) = ha(i2,j1) + sin(tf1)*cos(tf2)
         end do
      end do

c   Record update time and time step

      TIMEUD = TIME
      ITUD = IT
      
      return
      end subroutine

c***********************************************************************
c   Subroutine to update the Right Hand Side Load Vectors for the      *
c   elevation station harmonic analysis.                               *
c                                                                      *
c  STAE  - STATION ELEVATION VALUES USED TO UPDATE LOAD VECTORS        *
c  NSTAE - NUMBER OF TIDAL ELEVATION RECORDING STATIONS                *
c                                                                      *
c  STAELV - station elevation load vector                              *
c                                                                      *
c                        RL 11/8/95                                    *
c***********************************************************************
c
      SUBROUTINE LSQUPDES(STAE,NSTAE)
      IMPLICIT NONE
      INTEGER NSTAE,N,I,I1,I2
      REAL(SZ) TF1,CTF1,STF1
      REAL(SZ) STAE(MNSTAE)
c
c***** Update the Right Hand Side Load Vectors
c
c   Take care of the steady constituent if included in the analysis

      if(nz.eq.0) then
         do n=1,NSTAE
            STAELV(1,N) = STAELV(1,N) + STAE(N)
         end do
      endif

c   Take care of the other constituents

      do i=1,nfreq
         i1=2*i-nz
         i2=i1+1
         tf1=hafreq(i+nf)*TIMEUD
         ctf1 = cos(tf1)
         stf1 = sin(tf1)
         do n=1,NSTAE
            STAELV(I1,N) = STAELV(I1,N) + STAE(N)*CTF1
            STAELV(I2,N) = STAELV(I2,N) + STAE(N)*STF1
         end do
      end do
C     
      return
      end subroutine
      
c***********************************************************************
c   Subroutine to update the Right Hand Side Load Vectors for the      *
c   velocity station harmonic analysis.                                *
c                                                                      *
c  STAU  - STATION U VELOCITY VALUES USED TO UPDATE LOAD VECTORS       *
c  STAV  - STATION V VELOCITY VALUES USED TO UPDATE LOAD VECTORS       *
c  NSTAV - NUMBER OF TIDAL CURRENT RECORDING STATIONS                  *
c                                                                      *
c  STAULV - station u velocity load vector                             *
c  STAVLV - station v velocity load vector                             *
c                                                                      *
c                        RL 11/8/95                                    *
c***********************************************************************
c
      SUBROUTINE LSQUPDVS(STAU,STAV,NSTAV)
      IMPLICIT NONE
      INTEGER NSTAV,N,I,I1,I2
      REAL(SZ) TF1,CTF1,STF1
      REAL(SZ) STAU(MNSTAV),STAV(MNSTAV)
c
c***** Update the Right Hand Side Load Vectors
c
c     Take care of the steady constituent if included in the analysis

      if(nz.eq.0) then
         do n=1,NSTAV
            STAULV(1,N) = STAULV(1,N) + STAU(N)
            STAVLV(1,N) = STAVLV(1,N) + STAV(N)
         end do
      endif

c     Take care of the other constituents

      do i=1,nfreq
         i1=2*i-nz
         i2=i1+1
         tf1=hafreq(i+nf)*TIMEUD
         ctf1 = cos(tf1)
         stf1 = sin(tf1)
         do n=1,NSTAV
            STAULV(I1,N) = STAULV(I1,N) + STAU(N)*CTF1
            STAVLV(I1,N) = STAVLV(I1,N) + STAV(N)*CTF1
            STAULV(I2,N) = STAULV(I2,N) + STAU(N)*STF1
            STAVLV(I2,N) = STAVLV(I2,N) + STAV(N)*STF1
         end do
      end do
C     
      return
      end subroutine


c***********************************************************************
c   Subroutine to update the Right Hand Side Load Vectors for the      *
c   global elevation harmonic analysis.                                *
c                                                                      *
c  GLOE  - GLOBAL ELEVATION VALUES USED TO UPDATE LOAD VECTORS         *
c  NP    - NUMBER OF POINTS IN GLOBAL GRID                             *
c                                                                      *
c  GLOELV - global elevation load vector                               *
c                                                                      *
c                        RL 11/8/95                                    *
c***********************************************************************
c
      SUBROUTINE LSQUPDEG(GLOE,NP)
      IMPLICIT NONE
      INTEGER I,J,NP,N,I1,I2,IR,IRE,K,JR
      REAL(SZ) TF1,CTF1,STF1
      REAL(SZ) GLOE(MNP)
c     
c*****Update the Right Hand Side Load Vectors
c     
c     Take care of the steady constituent if included in the analysis

      if(nz.eq.0) then
         do n=1,np
            GLOELV(1,N)=GLOELV(1,N)+GLOE(N)
         end do
      endif

c     Take care of the other constituents

      do i=1,nfreq
         i1=2*i-nz
         i2=i1+1
         tf1=hafreq(i+nf)*TIMEUD
         ctf1 = cos(tf1)
         stf1 = sin(tf1)
         do n=1,np
            GLOELV(I1,N)=GLOELV(I1,N)+GLOE(N)*CTF1
            GLOELV(I2,N)=GLOELV(I2,N)+GLOE(N)*STF1
         end do
      end do
C     
      return
      end subroutine


c***********************************************************************
c   Subroutine to update the Right Hand Side Load Vectors for the      *
c   global velocity harmonic analysis.                                 *
c                                                                      *
c  GLOU  - GLOBAL U VELOCITY VALUES USED TO UPDATE LOAD VECTORS        *
c  GLOV  - GLOBAL V VELOCITY VALUES USED TO UPDATE LOAD VECTORS        *
c  NP    - NUMBER OF POINTS IN GLOBAL GRID                             *
c                                                                      *
c  GLOULV - global u velocity load vector                              *
c  GLOVLV - global v velocity load vector                              *
c                                                                      *
c                        RL 11/8/95                                    *
c***********************************************************************
c
      SUBROUTINE LSQUPDVG(GLOU,GLOV,NP)
      IMPLICIT NONE
      INTEGER NP,NPI1,I1,I2,N,I,J,IR,IRE,K,JR
      REAL(SZ) TF1,CTF1,STF1
      REAL(SZ) GLOU(MNP),GLOV(MNP)
c     
c*****Update the Right Hand Side Load Vectors
c     
c     Take care of the steady constituent if included in the analysis

      if(nz.eq.0) then
         do n=1,np
            GLOULV(1,N) = GLOULV(1,N) + GLOU(N)
            GLOVLV(1,N) = GLOVLV(1,N) + GLOV(N)
         end do
      endif

c     Take care of the other constituents

      do i=1,nfreq
         i1=2*i-nz
         i2=i1+1
         tf1=hafreq(i+nf)*TIMEUD
         ctf1 = cos(tf1)
         stf1 = sin(tf1)
         do n=1,np
            GLOULV(I1,N) = GLOULV(I1,N) + GLOU(N)*CTF1
            GLOVLV(I1,N) = GLOVLV(I1,N) + GLOV(N)*CTF1
            GLOULV(I2,N) = GLOULV(I2,N) + GLOU(N)*STF1
            GLOVLV(I2,N) = GLOVLV(I2,N) + GLOV(N)*STF1
         end do
      end do
C     
      return
      end subroutine

c***********************************************************************
c   Subroutine to fill out, decompose and solve the lsq system         *
c   Solves system a*x=b by l*d*l(tr) decomp in full storage mode       *
c                                                                      *
c   NOTE: This routine has been modified so that the filling out and   *
c         decomposition (and only those operations) are done if        *
c         idecom=0.                                                    *
c                                                                      *
c   mm  -  actual dimension of a matrix                                *
c                                                                      *
c                        rl 11/7/95                                    *
c***********************************************************************
c
      subroutine fulsol(idecom)
      implicit none
      integer idecom,i,j,ir,ire,k,jr
      real(sz),allocatable ::  c(:),y(:)

c     
c**** If only want to fill out matrix and decomponse
c     
      if(idecom.eq.0) then
         
c     Set up the lower triangular part of the LHS a matrix
         
         do j=1,mm
            do i=j,mm
               ha(i,j)=ha(j,i)
            end do
         end do
         
c     Decomposition of matrix a

         do 100 ir=1,mm
            ire=ir+1
            do 20 j=ire,mm
 20         ha(ir,j)=ha(ir,j)/ha(ir,ir)
            if(ire.gt.mm) goto 100
            do 40 j=ire,mm
              do 40 k=ire,mm
 40           ha(k,j)=ha(k,j)-ha(k,ir)*ha(ir,j)
            do 50 j=ire,mm
 50           ha(j,ir)=0.0
 100     continue
         return
      endif

c...  solve for y by forward substitution for l*y=p

      allocate ( c(2*MNHARF),y(2*MNHARF) )
c     
      do 120 ir=1,mm
         y(ir)=hap(ir)
         do 110 jr=1,ir-1
 110        y(ir)=y(ir)-ha(jr,ir)*y(jr)
 120     continue

c...  calculate c=d**(-1)*y

         do 130 ir=1,mm
 130        c(ir)=y(ir)/ha(ir,ir)

c...  solve for x by back-substituting for l(tr)*x=c

            ir=mm
 140        continue
            hax(ir)=c(ir)
            do 150 jr=ir+1,mm
 150          hax(ir)=hax(ir)-ha(ir,jr)*hax(jr)
            ir=ir-1
            if(ir.ge.1) goto 140
            return
            end subroutine


c***********************************************************************
c   Subroutine to solve the system and write output for elevation      *
c   stations.                                                          *
c                                                                      *
c   nf=0  if no steady constituent                                     *
c   nf=1 if steady constituent                                         *
c                                                                      *
c                        R.L. 11/8/95                                  *
c***********************************************************************
c
      SUBROUTINE LSQSOLES(NSTAE,DIRNAME,LNAME)
      IMPLICIT NONE
      INTEGER NSTAE,LNAME,N,I,J,K,I1,I2
      REAL(8) CONVRD
      REAL(SZ) EMAG,PHASEE,PHASEDE

      CHARACTER*1 DIRNAME

C
      convrd=180.d0/pi
c
c**** Open elevation station harmonic output file and write header information
c
      open(51,file=DIRNAME(1:LNAME)//'/'//'fort.51')
      write(51,*) nfreq+nf
      do j=1,nfreq+nf
         write(51,3679) hafreq(j),HAFF(j),HAFACE(j),namefr(j)
      end do
 3679 format(1x,e20.10,1x,f10.7,1x,f12.8,1x,a10)
      write(51,*) NSTAE

c
c**** AT each STATION TRANSFER each load vector to p and solve the system
c
      DO N=1,NSTAE
         do k=1,mm
            hap(k)=STAELV(k,n)
         end do
         call fulsol(n)

c        Compute amplitude and phase for each frequency making sure that the
c        phase is between 0 and 360 deg.  Then write output.

         write(51,*) N
         do i=1,nfreq+nf
            if((nf.eq.1).and.(i.eq.1)) then
               emag=hax(i)/haff(i)
               phasee=0.
               else
                  i1=2*i-1-nf
                  i2=i1+1
                  emag=sqrt(hax(i1)*hax(i1)+hax(i2)*hax(i2))/haff(i)
                  if((hax(i1).eq.0.).and.(hax(i2).eq.0.)) then
                     phasee=0.
                  else
                     phasee = atan2(hax(i2),hax(i1))
                  endif
               endif
               phasede=convrd*phasee+haface(i)
               if(phasede.lt.0.) phasede=phasede+360.d0
               if(phasede.ge.360.d0) phasede=phasede-360.d0
               
               write(51,6635) emag,phasede
 6635          format(2x,e16.8,1x,f11.4)
            end do
            
         end do
C     
         return
         end subroutine
      

c***********************************************************************
c   Subroutine to solve the system and write output for velocity       *
c   stations.                                                          *
c                                                                      *
c   nf=0  if no steady constituent                                     *
c   nf=1  if steady constituent                                        *
c                                                                      *
c                        R.L. 11/8/95                                  *
c***********************************************************************
c
      SUBROUTINE LSQSOLVS(NSTAV,DIRNAME,LNAME)
      IMPLICIT NONE
      INTEGER NSTAV,LNAME,I,J,N,K,I1,I2
      REAL(8) CONVRD
      REAL(SZ) UMAG,VMAG,PHASEU,PHASEV,PHASEDU,PHASEDV
      REAL(SZ),ALLOCATABLE :: Y(:)

      CHARACTER*1 DIRNAME

c
      convrd=180.d0/pi
c
      ALLOCATE ( Y(2*MNHARF) )
c
c**** Open velocity station harmonic output file and write header information
c
      open(52,file=DIRNAME(1:LNAME)//'/'//'fort.52')
      write(52,*) nfreq+nf
      do j=1,nfreq+nf
         write(52,3679) hafreq(j),HAFF(j),HAFACE(j),namefr(j)
      end do
 3679 format(1x,e20.10,1x,f10.7,1x,f12.8,1x,a10)
      write(52,*) NSTAV
c
c**** AT each STATION, transfer each load vector to p, solve system, 
c**** then write results
c     
      DO N=1,NSTAV
         do k=1,mm
            hap(k) = STAVLV(k,n)
         end do
         call fulsol(n)
         do k=1,mm
            y(k)=hax(k)
         end do
         do k=1,mm
            hap(k) = STAULV(k,n)
         end do
         call fulsol(n)
         
c        Compute amplitude and phase for each frequency making sure that the
c        phase is between 0 and 360 deg.  Then write output.

         write(52,*) N
         do i=1,nfreq+nf
            if((nf.eq.1).and.(i.eq.1)) then
               umag=hax(i)/haff(i)
               vmag=y(i)/haff(i)
               phaseu=0.
               phasev=0.
            else
               i1=2*i-1-nf
               i2=i1+1
               umag=sqrt(hax(i1)*hax(i1)+hax(i2)*hax(i2))/haff(i)
               vmag=sqrt(y(i1)*y(i1)+y(i2)*y(i2))/haff(i)
               if((hax(i1).eq.0.).and.(hax(i2).eq.0.)) then
                  phaseu=0.
               else
                  phaseu = atan2(hax(i2),hax(i1))
               endif
               if((y(i1).eq.0.).and.(y(i2).eq.0.)) then
                  phasev=0.
               else
                  phasev = atan2(y(i2),y(i1))
               endif
            endif
            phasedu=convrd*phaseu+haface(i)
            if(phasedu.lt.0.) phasedu=phasedu+360.d0
            if(phasedu.ge.360.d0) phasedu=phasedu-360.d0
            phasedv=convrd*phasev+haface(i)
            if(phasedv.lt.0.) phasedv=phasedv+360.d0
            if(phasedv.ge.360.d0) phasedv=phasedv-360.d0
            
            write(52,6636) umag,phasedu,vmag,phasedv
 6636       format(2x,e16.8,1x,f11.4,2x,e16.8,1x,f11.4)
         end do
         
      end do
      
      return
      end subroutine

c***********************************************************************
c   Subroutine to solve the system and write output for elevation      *
c   globally.                                                          *
c                                                                      *
c   nf=0  if no steady constituent                                     *
c   nf=1  if steady constituent                                        *
c                                                                      *
c                        R.L. 11/8/95                                  *
c***********************************************************************
c
      SUBROUTINE LSQSOLEG(NP,DIRNAME,LNAME,ELAV,ELVA)
      IMPLICIT NONE
      integer LNAME,J,NP,N,K,I,I1,I2,IT,IFR,NEAVMAX,NEAVMIN,
     *  NEVAMAX,NEVAMIN
      REAL(8)  CONVRD 
      REAL(SZ) EAVMAX,EVAMAX,EAVMIN,EVAMIN,EMAGT
      REAL(SZ) PHASEDE,EAV,ESQ,TIME,RSE,FTIME,EAVDIF,EVADIF
      REAL(SZ) ELAV(MNP),ELVA(MNP)
      REAL(SZ),ALLOCATABLE  ::  PHASEE(:),EMAG(:)
C
      INTEGER NTSTEPS,ITMV
      REAL(8) TIMEBEG
      REAL(SZ) DT,FMV
      COMMON /MEANSQ/ TIMEBEG,DT,FMV,NTSTEPS,ITMV

      CHARACTER*1 DIRNAME

c
      convrd=180.d0/pi
c
      ALLOCATE ( PHASEE(MNHARF),EMAG(MNHARF) )
c
c**** Open velocity station harmonic output file and write header information
c
      open(53,file=DIRNAME(1:LNAME)//'/'//'fort.53')
      write(53,*) nfreq+nf
      do j=1,nfreq+nf
         write(53,3679) hafreq(j),HAFF(j),HAFACE(j),namefr(j)
      end do
 3679 format(1x,e20.10,1x,f10.7,1x,f12.8,1x,a10)
      write(53,*) NP
C
      if (CHARMV) then
         EAVMAX=-999.
         EVAMAX=-999.
         EAVMIN= 999.
         EVAMIN= 999.
      end if
c
c***** AT each node transfer each load vector to p, solve and write output
c
      DO N=1,NP
         do k=1,mm
            hap(k) = GLOELV(k,n)
         end do
         call fulsol(n)
c
c        Compute amplitude and phase for each frequency making sure that the
c        phase is between 0 and 360 deg.  Then write output.
c
         write(53,*) N
         do i=1,nfreq+nf
            if((nf.eq.1).and.(i.eq.1)) then
               emag(i)=hax(i)
               emagt=emag(i)/haff(i)
               phasee(i)=0.
            else
               i1=2*i-1-nf
               i2=i1+1
               emag(i)=sqrt(hax(i1)*hax(i1)+hax(i2)*hax(i2))
               emagt=emag(i)/haff(i)
               if((hax(i1).eq.0.).and.(hax(i2).eq.0.)) then
                  phasee(i)=0.
               else
                  phasee(i) = atan2(hax(i2),hax(i1))
               endif
            endif
            phasede=convrd*phasee(i)+haface(i)
            if(phasede.lt.0.) phasede=phasede+360.d0
            if(phasede.ge.360.d0) phasede=phasede-360.d0
            write(53,6635) emagt,phasede
 6635       format(2x,e16.8,1x,f11.4)
         end do
         
         if (CHARMV) then
            eav = 0.
            esq = 0.
            do it=1,ntsteps
               TIME=TIMEBEG+DT*IT
               rse=0.
               do ifr=1,nfreq+nf
                  ftime=hafreq(ifr)*time
                  rse=rse+emag(ifr)*cos(ftime-phasee(ifr))
               end do
               eav=eav+rse
               esq=esq+rse*rse
            end do
            
         eav=eav/ntsteps
         esq=esq/ntsteps-eav*eav
         if(elav(n).eq.0.) then
            if(eav.eq.0.) eavdif=1.0d0
            if(eav.ne.0.) eavdif=99d19
         else
            eavdif=eav/elav(n)
         endif
         if(elva(n).eq.0.) then
            if(esq.eq.0.) evadif=1.0d0
            if(esq.ne.0.) evadif=99e19
         else
            evadif=esq/elva(n)
         endif
         write(55,*) n
         write(55,7637) elav(n),eav,eavdif,elva(n),esq,evadif
 7637    format(2x,3(e16.8,1x),2x,3(e16.8,1x))
         
         IF(EAVDIF.GT.EAVMAX) THEN
            EAVMAX=EAVDIF
            NEAVMAX=n
         ENDIF
         IF(EAVDIF.LT.EAVMIN) THEN
            EAVMIN=EAVDIF
            NEAVMIN=n
         ENDIF
         IF(EVADIF.GT.EVAMAX) THEN
            EVAMAX=EVADIF
            NEVAMAX=n
         ENDIF
         IF(EVADIF.LT.EVAMIN) THEN
            EVAMIN=EVADIF
            NEVAMIN=n
         ENDIF
      endif                     ! charmv
      
      end do
      
      if (charmv) then
c
      WRITE(16,7740)
 7740 FORMAT(///,5X,'THE LARGEST VALUES OF THE RATIO ',
     *              'RESYNTHESIZED ELEV TIME SERIES/RAW TIME SERIES:',/)
      WRITE(16,7741) EAVMAX,NEAVMAX
      WRITE(16,7742) EVAMAX,NEVAMAX
      WRITE(16,7747)
 7747 FORMAT(/,5X,'THE LOWEST VALUES OF THE RATIO ',
     *            'RESYNTHESIZED ELEV TIME SERIES/RAW TIME SERIES:',/)
      WRITE(16,7741) EAVMIN,NEAVMIN
      WRITE(16,7742) EVAMIN,NEVAMIN
 7741 FORMAT(9X,'  AVERAGE ELEVATION RATIO = ',E15.7,' AT NODE ',I8)
 7742 FORMAT(9X,' VARIANCE ELEVATION RATIO = ',E15.7,' AT NODE ',I8)
c     
      endif                     ! charmv
c
      return
      end subroutine

c***********************************************************************
c   Subroutine to solve the system and write output for velocity       *
c   globally.                                                          *
c                                                                      *
c   nf=0  if no steady constituent                                     *
c   nf=1  if steady constituent                                        *
c                                                                      *
c                        R.L. 11/10/95                                 *
c***********************************************************************
c
      SUBROUTINE LSQSOLVG(NP,DIRNAME,LNAME,
     *                    XVELAV,YVELAV,XVELVA,YVELVA)
      IMPLICIT NONE
      INTEGER NP,LNAME,I,J,N,K,I1,I2,IT,IFR
      INTEGER NUAVMAX,NUAVMIN,NVAVMAX,NVAVMIN,NUVAMAX,NUVAMIN,
     *  NVVAMAX,NVVAMIN
      REAL(SZ) UAV,VAV,USQ,VSQ,TIME,FTIME,RSU,RSV
      REAL(SZ) UAVMAX,VAVMAX,UVAMAX,VVAMAX,UAVMIN,VAVMIN,
     * UVAMIN,VVAMIN,PHASEDU,PHASEDV,UAVDIF,VAVDIF,UMAGT,VMAGT,
     * UVADIF,VVADIF
      REAL(8) CONVRD
      REAL(SZ) XVELAV(MNP),YVELAV(MNP),XVELVA(MNP),YVELVA(MNP)
      REAL(SZ),ALLOCATABLE :: UMAG(:),VMAG(:),PHASEU(:),PHASEV(:)
      REAL(SZ),ALLOCATABLE :: Y(:)
      INTEGER NTSTEPS,ITMV
      REAL(8) TIMEBEG
      REAL(SZ) DT,FMV
      COMMON /MEANSQ/ TIMEBEG,DT,FMV,NTSTEPS,ITMV

      CHARACTER*1 DIRNAME

c
      convrd=180.d0/pi
c
      ALLOCATE ( Y(2*MNHARF) )
      ALLOCATE ( UMAG(MNHARF),VMAG(MNHARF) )
      ALLOCATE ( PHASEU(MNHARF),PHASEV(MNHARF) )
c
c**** Open velocity station harmonic output file and write header information
c
      open(54,file=DIRNAME(1:LNAME)//'/'//'fort.54')
      write(54,*) nfreq+nf
      do j=1,nfreq+nf
         write(54,3679) hafreq(j),HAFF(j),HAFACE(j),namefr(j)
      end do
 3679 format(1x,e20.10,1x,f10.7,1x,f12.8,1x,a10)
      write(54,*) NP
      
      if ( charmv ) then
         UAVMAX=-999.
         VAVMAX=-999.
         UVAMAX=-999.
         VVAMAX=-999.
         UAVMIN= 999.
         VAVMIN= 999.
         UVAMIN= 999.
         VVAMIN= 999.
      endif                     ! charmv
c
c***** AT each node transfer each load vector to p, solve and write output
c
      DO N=1,NP
         do k=1,mm
            hap(k) = GLOVLV(k,n)
         end do
         call fulsol(n)
         do k=1,mm
            y(k)=hax(k)
         end do
         do k=1,mm
            hap(k) = GLOULV(k,n)
         end do
         call fulsol(n)
         write(54,*) n
         do i=1,nfreq+nf
            if((nf.eq.1).and.(i.eq.1)) then
               umag(i)=hax(i)
               umagt=umag(i)/haff(i)
               vmag(i)=y(i)
               vmagt=vmag(i)/haff(i)
               phaseu(i)=0.
               phasev(i)=0.
            else
               i1=2*i-1-nf
               i2=i1+1
               umag(i)=sqrt(hax(i1)*hax(i1)+hax(i2)*hax(i2))
               umagt=umag(i)/haff(i)
               vmag(i)=sqrt(y(i1)*y(i1)+y(i2)*y(i2))
               vmagt=vmag(i)/haff(i)
               if((hax(i1).eq.0.).and.(hax(i2).eq.0.)) then
                  phaseu(i)=0.
               else
                  phaseu(i)=atan2(hax(i2),hax(i1))
               endif
               if((y(i1).eq.0.).and.(y(i2).eq.0.)) then
                  phasev(i)=0.
               else
                  phasev(i)=atan2(y(i2),y(i1))
               endif
            endif
            phasedu=convrd*phaseu(i)+haface(i)
            if(phasedu.lt.0.) phasedu=phasedu+360.d0
            if(phasedu.ge.360.d0) phasedu=phasedu-360.d0
            phasedv=convrd*phasev(i)+haface(i)
            if(phasedv.lt.0.) phasedv=phasedv+360.d0
            if(phasedv.ge.360.d0) phasedv=phasedv-360.d0

            write(54,6636) umagt,phasedu,vmagt,phasedv
 6636       format(2x,e16.8,1x,f11.4,2x,e16.8,1x,f11.4)
         end do

CHARMV...UNCOMMENT THE FOLLOWING LINES TO COMPUTE MEANS AND VARIANCES
CHARMV...FOR CHECKING THE HARMONIC ANALYSIS RESULTS.
CHARMV...Resynthesize the time series to compute the average and variances.
CHARMV...Compare resynthesized values with those computed during time stepping.
         if ( charmv ) then
            uav = 0.
            vav = 0.
            usq = 0.
            vsq = 0.
            do it=1,ntsteps
               TIME=TIMEBEG+DT*IT
               rsu=0.
               rsv=0.
               do ifr=1,nfreq+nf
                  ftime=hafreq(ifr)*time
                  rsu=rsu+umag(ifr)*cos(ftime-phaseu(ifr))
                  rsv=rsv+vmag(ifr)*cos(ftime-phasev(ifr))
               end do
               uav=uav+rsu
               vav=vav+rsv
               usq=usq+rsu*rsu
               vsq=vsq+rsv*rsv
            end do

            uav=uav/ntsteps
            vav=vav/ntsteps
            usq=usq/ntsteps-uav*uav
            vsq=vsq/ntsteps-vav*vav
            if(xvelav(n).eq.0.) then
               if(uav.eq.0.) uavdif=1.0d0
               if(uav.ne.0.) uavdif=99e19
            else
               uavdif=uav/xvelav(n)
            endif
            if(yvelav(n).eq.0.) then
               if(vav.eq.0.) vavdif=1.0d0
               if(vav.ne.0.) vavdif=99e19
            else
               vavdif=vav/yvelav(n)
            endif
            if(xvelva(n).eq.0.) then
               if(usq.eq.0.) uvadif=1.0d0
               if(usq.ne.0.) uvadif=99e19
            else
               uvadif=usq/xvelva(n)
            endif
            if(yvelva(n).eq.0.) then
               if(vsq.eq.0.) vvadif=1.0d0
               if(vsq.ne.0.) vvadif=99e19
            else
               vvadif=vsq/yvelva(n)
            endif
            write(55,*) n
            write(55,7637) xvelav(n),uav,uavdif,xvelva(n),usq,uvadif
            write(55,7637) yvelav(n),vav,vavdif,yvelva(n),vsq,vvadif
 7637       format(2x,3(e16.8,1x),2x,3(e16.8,1x))

            IF(UAVDIF.GT.UAVMAX) THEN
               UAVMAX=UAVDIF
               NUAVMAX=n
            ENDIF
            IF(UAVDIF.LT.UAVMIN) THEN
               UAVMIN=UAVDIF
               NUAVMIN=n
            ENDIF
            IF(VAVDIF.GT.VAVMAX) THEN
               VAVMAX=VAVDIF
               NVAVMAX=n
            ENDIF
            IF(VAVDIF.LT.VAVMIN) THEN
               VAVMIN=VAVDIF
               NVAVMIN=n
            ENDIF
            IF(UVADIF.GT.UVAMAX) THEN
               UVAMAX=UVADIF
               NUVAMAX=n
            ENDIF
            IF(UVADIF.LT.UVAMIN) THEN
               UVAMIN=UVADIF
               NUVAMIN=n
            ENDIF
            IF(VVADIF.GT.VVAMAX) THEN
               VVAMAX=VVADIF
               NVVAMAX=n
            ENDIF
            IF(VVADIF.LT.VVAMIN) THEN
               VVAMIN=VVADIF
               NVVAMIN=n
            ENDIF

         endif                  !  charmv

      end do

      if ( charmv ) then 
c
         WRITE(16,7740)
 7740    FORMAT(///,5X,'THE LARGEST VALUES OF THE RATIO ',
     *              'RESYNTHESIZED VEL TIME SERIES/RAW TIME SERIES:',/)
         WRITE(16,7743) UAVMAX,NUAVMAX
         WRITE(16,7744) UVAMAX,NUVAMAX
         WRITE(16,7745) VAVMAX,NVAVMAX
         WRITE(16,7746) VVAMAX,NVVAMAX
         WRITE(16,7747)
 7747    FORMAT(//,5X,'THE LOWEST VALUES OF THE RATIO ',
     *             'RESYNTHESIZED VEL TIME SERIES/RAW TIME SERIES:',/)
         WRITE(16,7743) UAVMIN,NUAVMIN
         WRITE(16,7744) UVAMIN,NUVAMIN
         WRITE(16,7745) VAVMIN,NVAVMIN
         WRITE(16,7746) VVAMIN,NVVAMIN
 7743    FORMAT(9X,' AVERAGE U VELOCITY RATIO = ',E15.7,' AT NODE ',I8)
 7744    FORMAT(9X,'VARIANCE U VELOCITY RATIO = ',E15.7,' AT NODE ',I8)
 7745    FORMAT(9X,' AVERAGE V VELOCITY RATIO = ',E15.7,' AT NODE ',I8)
 7746    FORMAT(9X,'VARIANCE V VELOCITY RATIO = ',E15.7,' AT NODE ',I8)
c     
      endif                     ! charmv
c
      return
      end subroutine

C
c***********************************************************************
c   Subroutine to initialize parameters for harmonic analysis with a   *
c   cold start.                                                        *
c                                                                      *
c                        R.L.  11/9/95                                 *
c***********************************************************************
c
      SUBROUTINE HACOLDS(HAFREQ)
      implicit none
      INTEGER I,J
      REAL(SZ) HAFREQ(MNHARF)
C
      if (hafreq(1).eq.0.0) then
         nz=0
         nf=1
      else
         nz=1
         nf=0
      endif
c
      nfreq=nfreq-nf
      mm=2*nfreq+nf
c
      do i=1,mm
         do j=1,mm
            ha(i,j)=0.
         end do
      end do
      icall=0
C     
      return
      end subroutine

c***********************************************************************
c   Subroutine to initialize global elevation load vectors for         *
c   harmonic analysis with a cold start.                               *
c                                                                      *
c                        R.L.  11/9/95                                 *
c***********************************************************************
c
      SUBROUTINE HACOLDSEG(NP)
      implicit none
      INTEGER NP,I,N
c
      do i=1,mm
         do N=1,NP
            GLOELV(I,N)=0.
         end do
      end do
C
      return
      end subroutine

c***********************************************************************
c   Subroutine to initialize elevation station load vectors for        *
c   harmonic analysis with a cold start.                               *
c                                                                      *
c                        R.L.  11/9/95                                 *
c***********************************************************************
c
      SUBROUTINE HACOLDSES(NSTAE)
      implicit none
      INTEGER  NSTAE
      INTEGER I,N
C
      do i=1,mm
         do N=1,NSTAE
            STAELV(I,N)=0.
         end do
      end do
C     
      return
      end subroutine

c***********************************************************************
c   Subroutine to initialize global velocity load vectors for          *
c   harmonic analysis with a cold start.                               *
c                                                                      *
c                        R.L.  11/9/95                                 *
c***********************************************************************
c
      SUBROUTINE HACOLDSVG(NP)
      implicit none
      INTEGER NP,I,N
C
      do i=1,mm
         do N=1,NP
            GLOULV(I,N)=0.
            GLOVLV(I,N)=0.
         end do
      end do
C
      return
      end subroutine

c***********************************************************************
c   Subroutine to initialize elevation station load vectors for        *
c   harmonic analysis with a cold start.                               *
c                                                                      *
c                        R.L.  11/9/95                                 *
c***********************************************************************
c
      SUBROUTINE HACOLDSVS(NSTAV)
      implicit none
      INTEGER NSTAV,I,N
c
      do i=1,mm
         do N=1,NSTAV
            STAULV(I,N)=0.
            STAVLV(I,N)=0.
         enddo
      enddo
C
      return
      end subroutine

c***********************************************************************
c   Subroutine to read in and initialize harmonic analysis for a hot   *
c   start.                                                             *
c                                                                      *
c   Checks are made to ensure agreement between values read in from    *
c   the hotstart file and values read in from the UNIT 15 file.        *
c                                                                      *
c                        R.L. 11/9/95                                  *
c***********************************************************************
c
      SUBROUTINE HAHOTS(NSTAE,NSTAV,NP,ISTAE,ISTAV,IGLOE,IGLOV,
     *   NSCREEN,IHOTSTP,IHOT,MYPROC)
      IMPLICIT NONE
      INTEGER NSTAE,NSTAV,NP, MYPROC
      INTEGER ISTAE, ISTAV, IGLOE, IGLOV, IFLAG, I, J
C     
      INTEGER INFREQ, INSTAE, INSTAV, INP, INZ, INF
      INTEGER IISTAE, IISTAV, IIGLOE, IIGLOV,NSCREEN 
      INTEGER IHOTSTP, IHOT, IMM, IICALL
      REAL(SZ) FDIFF
C     
      REAL(SZ),ALLOCATABLE ::  IFREQ(:),IFF(:),IFACE(:)
      CHARACTER*10,ALLOCATABLE :: INAMEFR(:)
C     
      CHARACTER*16 FNAME
      CHARACTER*8 FNAM8(2)
      EQUIVALENCE (FNAM8(1),FNAME)
c     
c***** Compute parameter values for checking
c
      if (hafreq(1).eq.0.0) then
         nz=0
         nf=1
      else
         nz=1
         nf=0
      endif
      nfreq=nfreq-nf
      mm=2*nfreq+nf

      ALLOCATE ( IFREQ(MNHARF),IFF(MNHARF),IFACE(MNHARF) )
      ALLOCATE ( INAMEFR(MNHARF) )
c
c***** Read in and check various parameter values
c
      READ(IHOT,REC=IHOTSTP+1) inz
      READ(IHOT,REC=IHOTSTP+2) inf
      READ(IHOT,REC=IHOTSTP+3) imm
      READ(IHOT,REC=IHOTSTP+4) inp
      READ(IHOT,REC=IHOTSTP+5) instae
      READ(IHOT,REC=IHOTSTP+6) instav
      READ(IHOT,REC=IHOTSTP+7) iistae
      READ(IHOT,REC=IHOTSTP+8) iistav
      READ(IHOT,REC=IHOTSTP+9) iigloe
      READ(IHOT,REC=IHOTSTP+10) iiglov
      READ(IHOT,REC=IHOTSTP+11) iicall
      READ(IHOT,REC=IHOTSTP+12) infreq
      IHOTSTP = IHOTSTP+12
c
      iflag=0
      if(nz.ne.inz) iflag=1
      if(nf.ne.inf) iflag=1
      if(mm.ne.imm) iflag=1
      if(np.ne.inp) iflag=1
      if(nstae.ne.instae) iflag=1
      if(nstav.ne.instav) iflag=1
      if(istae.ne.iistae) iflag=1
      if(istav.ne.iistav) iflag=1
      if(igloe.ne.iigloe) iflag=1
      if(iglov.ne.iiglov) iflag=1
      if(nfreq.ne.infreq) iflag=1
c
      do i=1,nfreq+nf
         READ(IHOT,REC=IHOTSTP+1) FNAM8(1)
         READ(IHOT,REC=IHOTSTP+2) FNAM8(2)
         IHOTSTP = IHOTSTP + 2
         INAMEFR(I) = FNAME
         read(IHOT,REC=IHOTSTP+1) ifreq(i)
         read(IHOT,REC=IHOTSTP+2) iff(i)
         read(IHOT,REC=IHOTSTP+3) iface(i)
         IHOTSTP = IHOTSTP + 3

         if(namefr(i).ne.inamefr(i)) iflag=1
         if(abs(hafreq(i)+ifreq(i)).lt.1.0d-30) then
            fdiff=0.
         else
            fdiff=abs(hafreq(i)-ifreq(i))/abs(hafreq(i)+ifreq(i))
         endif
         if(fdiff.ge.1.d-6) iflag=1
         if(abs(HAFF(i)+iFF(i)).lt.1d-30) then
            fdiff=0.
         else
            fdiff=abs(HAFF(i)-iFF(i))/abs(HAFF(i)+iFF(i))
         endif
         if(fdiff.ge.1.d-6) iflag=1
         if(abs(HAFACE(i)+iFACE(i)).lt.1d-30) then
            fdiff=0.
         else
            fdiff=abs(HAFACE(i)-iFACE(i))/abs(HAFACE(i)+iFACE(i))
         endif
         if(fdiff.ge.1.d-6) iflag=1
      end do
      if(iflag.eq.1) goto 999
c
c***** Read in time of most recent H.A. update
c
      READ(IHOT,REC=IHOTSTP+1) TIMEUD
      READ(IHOT,REC=IHOTSTP+2) ITUD
      IHOTSTP = IHOTSTP + 2
c
c***** Read in RHS Matrix
c
      do i=1,mm
         do j=1,mm
            IHOTSTP = IHOTSTP + 1
            READ(IHOT,REC=IHOTSTP) HA(I,J)
         end do
      end do

c
c***** FATAL Error Messages
c
 999  continue
      if(iflag.ne.0) then
         if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,1000)
         write(16,1000)
 1000    FORMAT(////,5x,'***** DISCREPANCY IN HARMONIC ANALYSIS HOT ',
     *        'START FILE *****',/)
      endif

      if(iflag.eq.1) then
         if(nz.ne.inz) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2010) inz,nz
            write(16,2010) inz,nz
 2010       format(5x,'NZ COMPUTED FROM UNIT 14 INPUT = ',I2,
     *           ', NZ READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(nf.ne.inf) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2020) inf,nf
            write(16,2020) inf,nf
 2020       format(5x,'NF COMPUTED FROM UNIT 14 INPUT = ',I2,
     *           ', NF READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(mm.ne.imm) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2030) imm,mm
            write(16,2030) imm,mm
 2030       format(5x,'MM COMPUTED FROM UNIT 14 INPUT = ',I2,
     *           ', MM READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(np.ne.inp) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2040) inp,np
            write(16,2040) inp,np
 2040       format(5x,'NP READ IN FROM UNIT 15 = ',I2,
     *           ', NP READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(nstae.ne.instae) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2050) instae,nstae
            write(16,2050) instae,nstae
 2050       format(5x,'NSTAE READ IN FROM UNIT 15 = ',I2,
     *           ', NSTAE READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(nstav.ne.instav) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2060) instav,nstav
            write(16,2060) instav,nstav
 2060       format(5x,'NSTAV READ IN FROM UNIT 15 = ',I2,
     *           ', NSTAV READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(istae.ne.iistae) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2070) iistae,istae
            write(16,2070) iistae,istae
 2070       format(5x,'ISTAE READ IN FROM UNIT 15 = ',I2,
     *           ', ISTAE READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(istav.ne.iistav) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2080) iistav,istav
            write(16,2080) iistav,istav
 2080       format(5x,'ISTAV READ IN FROM UNIT 15 = ',I2,
     *           ', ISTAV READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(igloe.ne.iigloe) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2090) iigloe,igloe
            write(16,2090) iigloe,igloe
 2090       format(5x,'IGLOE READ IN FROM UNIT 15 = ',I2,
     *           ', IGLOE READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(iglov.ne.iiglov) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2100) iiglov,iglov
            write(16,2100) iiglov,iglov
 2100       format(5x,'IGLOV READ IN FROM UNIT 15 = ',I2,
     *           ', IGLOV READ IN FROM HOT START FILE = ',I2,/)
         endif
         if(nfreq.ne.infreq) then
            if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,2110) infreq,nfreq
            write(16,2110) infreq,nfreq
 2110       format(5x,'NFREQ COMPUTED FROM UNIT 15 INPUT = ',I2,
     *           ', NFREQ READ IN FROM HOT START FILE = ',I2,/)
         endif
         do i=1,nfreq+nf
            if(namefr(i).ne.inamefr(i)) then
               if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *              write(6,2120) i,inamefr(i),namefr(i)
               write(16,2120) i,namefr(i),namefr(i)
 2120          format(5x,'FOR CONSTITUENT # ',I3,
     *              ', NAMEFR READ IN FROM UNIT 15 = ',A10,
     *              ', NAMEFR READ IN FROM HOT START FILE = ',A10,/)
            endif
            if(hafreq(i).ne.ifreq(i)) then
               if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *              write(6,2130) i,ifreq(i),hafreq(i)
               write(16,2130) i,ifreq(i),hafreq(i)
 2130          format(5x,'FOR CONSTITUENT # ',I3,
     *              ', FREQ READ IN FROM UNIT 15 = ',D20.10,
     *              ', FREQ READ IN FROM HOT START FILE = ',D20.10,/)
            endif
            if(HAFF(i).ne.iFF(i)) then
               if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *              write(6,2140) i,iff(i),haff(i)
               write(16,2140) i,iff(i),haff(i)
 2140          format(5x,'FOR CONSTITUENT # ',I3,
     *              ', FF READ IN FROM UNIT 15 = ',F10.5,
     *              ', FF READ IN FROM HOT START FILE = ',F10.5,/)
            endif
            if(HAFACE(i).ne.iFACE(i)) then
               if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *              write(6,2150) i,iface(i),haface(i)
               write(16,2150) i,iface(i),haface(i)
 2150          format(5x,'FOR CONSTITUENT # ',I3,
     *              ', FACE READ IN FROM UNIT 15 = ',F10.5,
     *              ', FACE READ IN FROM HOT START FILE = ',F10.5,/)
            endif
         end do
         if(NSCREEN.EQ.1.AND.MYPROC.EQ.0) write(6,1010)
         write(16,1010)
 1010    FORMAT(//,5x,'********** RUN TERMINATED **********',/)
         stop
      endif

      return
      end subroutine


c***********************************************************************
c   Subroutine to read in and initialize the global elevation load     *
c   vector for harmonic analysis with a hot start.                     *
c                                                                      *
c                        R.L. 11/9/95                                  *
c***********************************************************************
c
      SUBROUTINE HAHOTSEG(NP,IHOTSTP,IHOT)
      implicit none
      integer np, ihotstp, ihot, n,i
c
c***** Read in Global Elevation LHS load vector
c
      do n=1,np
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) GLOELV(I,N)
         end do
      end do
C
      return
      end subroutine


c***********************************************************************
c   Subroutine to read in and initialize the elevation station load    *
c   vector for harmonic analysis with a hot start.                     *
c                                                                      *
c                        R.L. 11/9/95                                  *
c***********************************************************************
c
      SUBROUTINE HAHOTSES(NSTAE,IHOTSTP,IHOT)
      implicit none
      INTEGER NSTAE,IHOTSTP,IHOT,I,N
c
c***** Read in Station Elevation LHS load vector
c
      do n=1,NSTAE
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) STAELV(I,N)
         end do
      end do
C
      return
      end subroutine


c***********************************************************************
c   Subroutine to read in and initialize the global velocity load      *
c   vector for harmonic analysis with a hot start.                     *
c                                                                      *
c                        R.L. 11/9/95                                  *
c***********************************************************************
c
      SUBROUTINE HAHOTSVG(NP,IHOTSTP,IHOT)
      implicit none
      integer np, ihotstp, ihot, n, i
c
c***** Read in Global Velocity LHS load vector
c
      do n=1,np
         do i=1,mm
            READ(IHOT,REC=IHOTSTP+1) GLOULV(I,N)
            READ(IHOT,REC=IHOTSTP+2) GLOVLV(I,N)
            IHOTSTP = IHOTSTP + 2
         end do
      end do
C
      return
      end subroutine


c***********************************************************************
c   Subroutine to read in and initialize the velocity station load     *
c   vector for harmonic analysis with a hot start.                     *
c                                                                      *
c                        R.L. 11/9/95                                  *
c***********************************************************************
c
      SUBROUTINE HAHOTSVS(NSTAV,IHOTSTP,IHOT)
      implicit none
      INTEGER NSTAV,IHOTSTP,IHOT,N,I
c
c***** Read in Station Velocity LHS load vector
c
      do n=1,NSTAV
         do i=1,mm
            READ(IHOT,REC=IHOTSTP+1) STAULV(I,N)
            READ(IHOT,REC=IHOTSTP+2) STAVLV(I,N)
            IHOTSTP = IHOTSTP + 2
         enddo
      enddo
C
      return
      end subroutine


c***********************************************************************
c   Subroutine to write out to the hotstart file (UNITS 67 and 68)     *
c   header information and the LHS matrix for the harmonic analysis    *
c                                                                      *
c                        R.L.  11/8/95                                 *
c***********************************************************************
c
      SUBROUTINE HAHOUT(NP,NSTAE,NSTAV,ISTAE,ISTAV,IGLOE,IGLOV,
     *  IOUNIT,IHOTSTP)
      implicit none
      INTEGER NP,NSTAE,NSTAV,ISTAE,AE,ISTAV
      INTEGER IGLOE,IGLOV,IOUNIT,IHOTSTP,I,J
      CHARACTER*16 FNAME
      CHARACTER*8 FNAM8(2)
      EQUIVALENCE (FNAM8(1),FNAME)

c
c***** Write Out various parameter values
c
      WRITE(IOUNIT,REC=IHOTSTP+1) NZ
      WRITE(IOUNIT,REC=IHOTSTP+2) NF
      WRITE(IOUNIT,REC=IHOTSTP+3) MM
      WRITE(IOUNIT,REC=IHOTSTP+4) NP
      WRITE(IOUNIT,REC=IHOTSTP+5) NSTAE
      WRITE(IOUNIT,REC=IHOTSTP+6) NSTAV
      WRITE(IOUNIT,REC=IHOTSTP+7) ISTAE
      WRITE(IOUNIT,REC=IHOTSTP+8) ISTAV
      WRITE(IOUNIT,REC=IHOTSTP+9) IGLOE
      WRITE(IOUNIT,REC=IHOTSTP+10) IGLOV
      WRITE(IOUNIT,REC=IHOTSTP+11) ICALL
      WRITE(IOUNIT,REC=IHOTSTP+12) NFREQ
      IHOTSTP = IHOTSTP+12

      do i=1,nfreq+nf
         FNAME=NAMEFR(I)
         WRITE(IOUNIT,REC=IHOTSTP+1) FNAM8(1)
         WRITE(IOUNIT,REC=IHOTSTP+2) FNAM8(2)
         IHOTSTP=IHOTSTP+2
         WRITE(IOUNIT,REC=IHOTSTP+1) hafreq(i)
         WRITE(IOUNIT,REC=IHOTSTP+2) HAFF(i)
         WRITE(IOUNIT,REC=IHOTSTP+3) HAFACE(i)
         IHOTSTP=IHOTSTP+3
      end do

c
c***** Write Out time of most recent H.A. update
c
      WRITE(IOUNIT,REC=IHOTSTP+1) TIMEUD
      WRITE(IOUNIT,REC=IHOTSTP+2) ITUD
      IHOTSTP=IHOTSTP+2
c
c***** Write Out LHS Matrix
c
      do i=1,mm
         do j=1,mm
            IHOTSTP = IHOTSTP + 1
            WRITE(IOUNIT,REC=IHOTSTP) HA(I,J)
         END DO
      END DO

      return
      end subroutine

c***********************************************************************
c   Subroutine to write global elevation harmonic analysis RHS load    *
c   vector to a hot start file (UNITS 67 and 68)                       *
c                                                                      *
c                        R.L.  11/8/95                                 *
c***********************************************************************
c
      SUBROUTINE HAHOUTEG(NP,IOUNIT,IHOTSTP)
      implicit none
      INTEGER IOUNIT
      INTEGER NP,IHOTSTP,N,I 
c
c***** Write Out Global Elevation RHS load vector
c
      do n=1,np
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) GLOELV(I,N)
         end do
      end do
      
      return
      end subroutine

c***********************************************************************
c   Subroutine to write elevation station harmonic analysis RHS load   *
c   vector to a hot start file (UNITS 67 and 68)                       *
c                                                                      *
c                        R.L.  11/8/95                                 *
c***********************************************************************
c
      SUBROUTINE HAHOUTES(NSTAE,IOUNIT,IHOTSTP)
      implicit none
      INTEGER NSTAE,IOUNIT,IHOTSTP,N,I
c
c***** Write Out Station Elevation RHS load vector
c
      do n=1,NSTAE
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) STAELV(I,N)
         end do
      end do

      return
      end subroutine

c***********************************************************************
c   Subroutine to write global velocity harmonic analysis RHS load     *
c   vector to a hot start file (UNITS 67 and 68)                       *
c                                                                      *
c                        R.L.  11/8/95                                 *
c***********************************************************************
c
      SUBROUTINE HAHOUTVG(NP,IOUNIT,IHOTSTP)
      implicit none
      INTEGER NP,IOUNIT,IHOTSTP,N,I
c
c***** Write Out Global Velocity RHS load vector
c
      do n=1,np
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) GLOULV(I,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) GLOVLV(I,N)
         end do
      end do
      
      return
      end subroutine

c***********************************************************************
c   Subroutine to write velocity station harmonic analysis RHS load    *
c   vector to a hot start file (UNITS 67 and 68)                       *
c                                                                      *
c                        R.L.  11/8/95                                 *
c***********************************************************************
c
      SUBROUTINE HAHOUTVS(NSTAV,IOUNIT,IHOTSTP)
      implicit none
      INTEGER NSTAV,IOUNIT,IHOTSTP,N,I
c
c***** Write Out Station Velocity LHS load vector
c
      do N=1,NSTAV
         do i=1,mm
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) STAULV(I,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IOUNIT,REC=IHOTSTP) STAVLV(I,N)
         end do
      end do

      return
      end subroutine


      END MODULE HARM
C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001 
C    last changes in this file VERSION 41.11
C
C  mod history
C  v41.11     - 09/14/01 - rl- from 41.09 - made allowences for NWS=-2
C  v41.09     - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C  v41.06     - 04/02/2001 - RL eliminated MNWP
C  v41.03     - 09/15/2000 - rl
C  v41.01m001 - 08/16/2000 - jjw - added fort.12 method of setting tau0
C  v40.02m001 - 12/21 - jjw - add cross barrier pipes cjjwm001
C  v41.06mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx 
C**************************************************************************
C
      SUBROUTINE READ_INPUT()
C
C**************************************************************************
C
C  READS INPUT FILES
C
C**************************************************************************
C
      USE GLOBAL
      USE HARM
      USE WIND
      USE ITPACKV
      IMPLICIT NONE
      INTEGER NIBP,IBN1,IK,NDISC,NBBN,NVEL2
C
C  Initialize all runtime option logicals to false
C
      C2DDI  = .FALSE.
      C3D    = .FALSE.
      C3DDSS = .FALSE.
      C3DVS  = .FALSE.
      CLUMP  = .FALSE.
      CTIP   = .FALSE.
      CHARMV = .FALSE.
C
C  Initialize MNODES for compatibility
C
      MNODES = 1
C...
C...OPEN STATEMENT FOR UNIT 14 AND 15 INPUT FILES
C...  
      OPEN(14,FILE=DIRNAME//'/'//'fort.14')
      OPEN(15,FILE=DIRNAME//'/'//'fort.15')
C...
C...OPEN STATEMENT FOR UNIT 16 OUTPUT FILE
C...
      OPEN(16,FILE=DIRNAME//'/'//'fort.16')
C
C...GENERAL PURPOSE FORMAT STATEMENTS
C...  
 1112 FORMAT(/,1X,79('_'))
 9972 FORMAT(////,1X,'!!!!!!!!!! INPUT ERROR !!!!!!!!!',/)
 9973 FORMAT(/,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
 9974 FORMAT(/,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!!!',//)

C...
C...PRINT OUT HEADER FOR OUTPUT INCLUDING VERSION NUMBER AND COPYRIGHT
C...
      WRITE(16,1112)
      WRITE(16,1112)
      WRITE(16,1114)
      WRITE(16,1112)
      IF (MYPROC.EQ.0) THEN
         WRITE(6,1112)
         WRITE(6,1114)
         WRITE(6,1112)
      ENDIF

 1114 FORMAT(//,19X,'PROGRAM ADCIRC   VERSION 41.10 ',
     *     //,5X,'AN ADVANCED CIRCULATION MODEL FOR SHELVES, COASTAL ',
     *     'SEAS AND ESTUARIES',
     *     ///,7X,'-  DEVELOPED BY',
     *     //,10X,'R.A. LUETTICH, JR',
     *     /,12X,'UNIVERSITY OF NORTH CAROLINA AT CHAPEL HILL',
     *     /,12X,'INSTITUTE OF MARINE SCIENCES',
     *     //,10X,'J.J. WESTERINK ',
     *     /,12X,
     *     'DEPARTMENT OF CIVIL ENGINEERING AND GEOLOGICAL SCIENCES',
     *     /,12X,'UNIVERSITY OF NOTRE DAME',
     *     ///,7X,'-  THE ADCIRC SOURCE CODE IS COPYRIGHTED BY',
     *     //,10X,'R.A. LUETTICH, JR. AND J.J. WESTERINK, 1994-2001',
     *     //,7X,
     *     'NO PART OF THIS CODE MAY BE REPRODUCED OR REDISTRIBUTED',
     *     /,10X,'WITHOUT THE WRITTEN PERMISSION OF THE AUTHORS',//)
      
C...  
C...  WRITE OUT HEADER INFORMATION DESCRIBING HOW THE CODE HAS BE SET UP
C...  
      WRITE(16,1210)
 1210 FORMAT(//,1X,'THE ADCIRC SOURCE CODE HAS BEEN CONFIGURED ',
     *             'BY THE PREPROCESSOR AS FOLLOWS:',/)
      



      WRITE(16,*) '      - CODE SETUP TO RUN WITH 4 byte REALS'





      WRITE(16,*) '      - CODE OPTIMIZED FOR A SCALAR COMPUTER'


      WRITE(16,*) '      - NONVECTORIZABLE PARTS OF CODE OPTIMIZED FOR',
     *                   ' MEMORY'
      WRITE(16,*) '      - CODE WILL USE JCG ITERATIVE GWCE SOLVER'
      WRITE(16,1112)

C...  
C...  INPUT FROM UNIT 15 AND OUTPUT TO UNIT 16 RUN DESCRIPTION AND RUN
C...  IDENTIFICATION
C...  
      READ(15,'(A32)') RUNDES
      READ(15,'(A24)') RUNID
      WRITE(16,1) RUNDES
  1   FORMAT(//,1X,'RUN DESCRIPTION : ',A32)
      WRITE(16,209) RUNID
209   FORMAT(/,1X,'RUN IDENTIFICATION : ',A24)
C...
C... READ AND PROCESS NFOVER - NONFATAL ERROR OVERRIDE OPTION
C...
      READ(15,*) NFOVER
      WRITE(16,1112)
      WRITE(16,1250)
 1250 FORMAT(//,1X,'GENERAL RUN INFORMATION',/)
      IF(NFOVER.EQ.1) THEN
         WRITE(16,1951) NFOVER
 1951    FORMAT(5X,'NFOVER = ',I2,
     *        /,9X,'IF NON-FATAL ERRORS ARE DETECTED, THEY WILL BE ',
     *        'CORRECTED AND EXECUTION CONTINUED')
      ELSE
         WRITE(16,1952) NFOVER
 1952    FORMAT(/,5X,'NFOVER = ',I3,
     *        /,9X,'NON-FATAL ERRORS WILL STOP EXECUTION ',/)
      ENDIF

C...
C...  READ AND PROCESS NABOUT - ABBREVIATED UNIT 16 OUTPUT OPTION
C...
      READ(15,*) NABOUT
      IF(NABOUT.EQ.1) THEN
         WRITE(16,3501) NABOUT
 3501    FORMAT(5X,'NABOUT = ',I2,
     *        /,9X,'ABREVIATED OUTPUT WILL BE PROVIDED TO UNIT 16',/,9X,
     *        'UNIT 14, 21, 22 INPUT DATA WILL NOT BE ECHO PRINTED',/)
      ELSE
         WRITE(16,3502) NABOUT
 3502    FORMAT(/,5X,'NABOUT = ',I3,
     *        /,9X,'DETAILED OUTPUT WILL BE PROVIDED TO UNIT 16',/,9X,
     *        'UNIT 14, 15, 21, 22 INPUT DATA WILL BE ECHO PRINTED',/)
      ENDIF

C...
C...  READ AND PROCESS NSCREEN - SCREEN OUTPUT OPTION
C...
      READ(15,*) NSCREEN
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
         WRITE(16,3561) NSCREEN
 3561    FORMAT(5X,'NSCREEN = ',I2,
     *        /,9X,'SCREEN OUTPUT WILL BE PROVIDED TO UNIT 6',/)
      ELSE
         WRITE(16,3562) NSCREEN
 3562    FORMAT(/,5X,'NSCREEN = ',I3,
     *        /,9X,'SCREEN OUTPUT WILL NOT BE PROVIDED TO UNIT 6',/)
      ENDIF
        
C...
C...  READ AND PROCESS IHOT - HOT START OPTION
C...
      READ(15,*) IHOT
      IF((IHOT.NE.0).AND.(IHOT.NE.67).AND.(IHOT.NE.68)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'IHOT =',IHOT
            WRITE(6,9732)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'IHOT =',IHOT
         WRITE(16,9732)
         WRITE(16,9973)       
 9732    FORMAT(/,1X,'Your selection of IHOT (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF(IHOT.NE.0) THEN
         WRITE(16,9733) IHOT
 9733    FORMAT(/,5X,'ADCIRC will be hot started using information ',
     *        'on UNIT ',I2)
      ELSE
         WRITE(16,9734)
 9734    FORMAT(/,5X,'ADCIRC will be cold started')
      ENDIF

C...
C...  READ AND PROCESS ICS - CARTESIAN/SPHERICAL COORDINATE OPTION
C...
      READ(15,*) ICS
      IF((ICS.NE.1).AND.(ICS.NE.2)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'ICS =',ICS
            WRITE(6,9735)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'ICS =',ICS
         WRITE(16,9735)
         WRITE(16,9973)
 9735    FORMAT(/,1X,'Your selection of ICS (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF(ICS.EQ.1) THEN
         WRITE(16,9736) ICS
 9736    FORMAT(/,5X,'ICS = ',I2,
     *        /,9X,'Governing equations are in Cartesian coordinates')
      ELSE
         WRITE(16,9737) ICS
 9737    FORMAT(/,5X,'ICS = ',I2,
     *        /,9X,'Governing equations are in Spherical coordinates',
     *        /,9X,'mapped using a CPP projection')
      ENDIF

C...
C...  READ AND PROCESS IM - 2D/3D MODEL OPTION
C...
      READ(15,*) IM

      IF (IM.EQ.0) THEN
         C2DDI = .TRUE.
      ELSEIF (IM.EQ.1) THEN
         C3D  = .TRUE.
         C3DVS  = .TRUE.
      ELSEIF (IM.EQ.2) THEN
         C3D  = .TRUE.
         C3DDSS = .TRUE.
      ELSEIF (IM.EQ.10) THEN
         C2DDI = .TRUE.
      ELSE
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'IM =',IM
            WRITE(6,9721)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'IM =',IM
         WRITE(16,9721)
         WRITE(16,9973)
 9721    FORMAT(/,1X,'Your selection of IM (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      
C...
C...  READ AND PROCESS NOLIBF - NONLINEAR BOTTOM FRICTION OPTION
C...
      READ(15,*) NOLIBF
      IF((NOLIBF.LT.0).OR.(NOLIBF.GT.2)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLIBF =',NOLIBF
            WRITE(6,9722)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLIBF =',NOLIBF
         WRITE(16,9722)
         WRITE(16,9973)
 9722    FORMAT(/,1X,'Your selection of NOLIBF (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      WRITE(16,9845) NOLIBF
 9845 FORMAT(/,5X,'NOLIBF = ',I3)
      IF(NOLIBF.EQ.0) WRITE(16,2050)
 2050 FORMAT(9X,'THE MODEL WILL USE LINEAR BOTTOM FRICTION')
      IF(NOLIBF.EQ.1) WRITE(16,2051)
 2051 FORMAT(9X,'THE MODEL WILL USE STANDARD QUADRATIC BOTTOM FRICTION')
      IF(NOLIBF.EQ.2) WRITE(16,2052)
 2052 FORMAT(9X,'THE MODEL WILL USE STANDARD QUADRATIC BOTTOM FRICTION',
     *     'IN DEEP WATER ',
     *     /,9X,'AND A FRICTION FACTOR THAT INCREASES AS THE DEPTH ',
     *     'DECREASES IN SHALLOW WATER')

C...
C... READ AND PROCESS NOLIFA - NONLINEAR FINITE AMPLITUDE OPTION
C...
      READ(15,*) NOLIFA
      IF((NOLIFA.LT.0).OR.(NOLIFA.GT.3)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLIFA =',NOLIFA
            WRITE(6,9723)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLIFA =',NOLIFA
         WRITE(16,9723)
         WRITE(16,9973)
 9723    FORMAT(/,1X,'Your selection of NOLIFA (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      WRITE(16,9846) NOLIFA
 9846 FORMAT(/,5X,'NOLIFA = ',I3)
      IF(NOLIFA.EQ.0) WRITE(16,2053)
 2053 FORMAT(9X,'THE MODEL WILL NOT USE FINITE AMPLITUDE TERMS OR ',
     *     'WETTING AND DRYING')
      IF(NOLIFA.EQ.1) WRITE(16,2054)
 2054 FORMAT(9X,'THE MODEL WILL USE FINITE AMPLITUDE TERMS BUT NO ',
     *     'WETTING AND DRYING')
      IF(NOLIFA.EQ.2) WRITE(16,2049)
 2049 FORMAT(9X,'THE MODEL WILL USE FINITE AMPLITUDE TERMS AND ',
     *     'WETTING AND DRYING')
      IF(NOLIFA.EQ.3) WRITE(16,2048)
 2048 FORMAT(9X,'THE MODEL WILL USE FINITE AMPLITUDE TERMS AND ',
     *     'WETTING AND DRYING',/,10X,
     *     'AND INCLUDES THE ABILITY TO INITIALIZE ',
     *     'NODES WITH DEPTHS GREATER THAN H0 AS DRY')         
      NSTARTDRY=0
      IF(NOLIFA.EQ.3) THEN             
         NOLIFA=2
         NSTARTDRY=1
      ENDIF

C...
C...  READ AND PROCESS NOLICA - ADVECTIVE TERM SPATIAL GRADIENT
C...
      READ(15,*) NOLICA
      IF((NOLICA.LT.0).OR.(NOLICA.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLICA =',NOLICA
            WRITE(6,9724)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLICA =',NOLICA
         WRITE(16,9724)
         WRITE(16,9973)
 9724    FORMAT(/,1X,'Your selection of NOLICA (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      WRITE(16,9847) NOLICA
 9847 FORMAT(/,5X,'NOLICA = ',I3)
      IF(NOLICA.EQ.0) WRITE(16,2055)
 2055 FORMAT(9X,'THE MODEL WILL NOT USE SPATIAL DERIVATIVE ',
     *     'COMPONENTS OF THE ADVECTIVE TERMS')
      IF(NOLICA.EQ.1) WRITE(16,2056)
 2056 FORMAT(9X,'THE MODEL WILL USE SPATIAL DERIVATIVE ',
     *     'COMPONENTS OF THE ADVECTIVE TERMS')

C...
C...  READ AND PROCESS NOLICAT - GWCE ADVECTIVE TERM TIME DERIVATIVE
C...
      READ(15,*) NOLICAT
      IF((NOLICAT.LT.0).OR.(NOLICAT.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLICAT =',NOLICAT
            WRITE(6,9725)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLICAT =',NOLICAT
         WRITE(16,9725)
         WRITE(16,9973)
 9725    FORMAT(/,1X,'Your selection of NOLICAT (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF

      IF((NOLIFA.GE.1).AND.(NOLICAT.EQ.0)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLICAT =',NOLICAT
            WRITE(6,9726)
            IF(NFOVER.EQ.1) THEN
               WRITE(6,9974)
            ELSE
               WRITE(6,9973)
            ENDIF
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLICAT =',NOLICAT
         WRITE(16,9726)
         WRITE(16,9974)
 9726    FORMAT(/,1X,'Your selection of NOLICAT (a UNIT 15 input ',
     *        'parameter) is inconsistent with your ',
     *        /,1X,'selection of NOLIFA and may lead to mass ',
     *        'balance problems')
         IF(NFOVER.EQ.1) THEN
            WRITE(6,9974)
         ELSE
            WRITE(6,9973)
            STOP
         ENDIF
      ENDIF

      IF((NOLIFA.EQ.0).AND.(NOLICAT.EQ.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLICAT =',NOLICAT
            WRITE(6,9726)
            IF(NFOVER.EQ.1) THEN
               WRITE(6,9974)
            ELSE
               WRITE(6,9973)
            ENDIF
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLICAT =',NOLICAT
         WRITE(16,9726)
         WRITE(16,9974)
         IF(NFOVER.EQ.1) THEN
            WRITE(6,9974)
         ELSE
            WRITE(6,9973)
            STOP
         ENDIF
      ENDIF

      IF(NOLICA.NE.NOLICAT) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NOLICAT =',NOLICAT
            WRITE(6,9727)
            IF(NFOVER.EQ.1) THEN
               WRITE(6,9974)
            ELSE
               WRITE(6,9973)
            ENDIF
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NOLICAT =',NOLICAT
         WRITE(16,9727)
         WRITE(16,9974)
 9727    FORMAT(/,1X,'Your selection of NOLICAT (a UNIT 15 input ',
     *        'parameter) is inconsistent with your ',
     *        /,1X,'selection of NOLICA and may lead to mass ',
     *        'balance problems')
         IF(NFOVER.EQ.1) THEN
            WRITE(6,9974)
         ELSE
            WRITE(6,9973)
            STOP
         ENDIF
      ENDIF

      WRITE(16,9848) NOLICAT
 9848 FORMAT(/,5X,'NOLICAT = ',I3)
      IF(NOLICAT.EQ.0) WRITE(16,2057)
 2057 FORMAT(9X,'THE MODEL WILL NOT USE TIME DERIVATIVE COMPONENTS ',
     *     /,9X,'OF THE ADVECTIVE TERMS IN THE GWCE')
      IF(NOLICAT.EQ.1) WRITE(16,2058)
 2058 FORMAT(9X,'THE MODEL WILL USE TIME DERIVATIVE COMPONENTS ',
     *     /,9X,'OF THE ADVECTIVE TERMS IN THE GWCE')
      
C...
C... READ AND PROCESS NWP - SPATIALLY VARYING BOTTOM FRICTION
C...
      READ(15,*) NWP
      IF((NWP.LT.0).OR.(NWP.GT.2)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NWP =',NWP
            WRITE(6,9728)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NWP =',NWP
         WRITE(16,9728)
         WRITE(16,9973)
 9728    FORMAT(/,1X,'Your selection of NWP (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF(NWP.EQ.0) THEN
         WRITE(16,231) NWP
 231     FORMAT(/,5X,'NWP = ',I2,
     *        /,9X,'SPATIALLY CONSTANT BOTTOM FRICTION RELATIONS ',
     *        /,9X,'WILL BE USED THROUGHOUT THE DOMAIN')
      ENDIF
      IF(NWP.EQ.1) THEN
         WRITE(16,232) NWP
 232     FORMAT(//,5X,'NWP = ',I2,
     *        /,9X,'SPATIALLY VARYING BOTTOM FRICTION VALUES WILL BE ',
     *        /,9X,'USED; INPUT IS REQUIRED FROM UNIT 21')
      ENDIF
      IF(NWP.EQ.2) THEN
         WRITE(16,2321) NWP
 2321    FORMAT(//,5X,'NWP = ',I2,
     *        /,9X,'SPATIALLY CONSTANT BOTTOM FRICTION VALUES WILL BE ',
     *        /,9X,'USED ALONG WITH ADDITIONAL FRICTION DUE TO BRIDGE ',
     *        /,9X,'PILINGS; INPUT IS REQUIRED FROM UNIT 21')
      ENDIF

C...
C...  READ AND PROCESS NCOR - SPATIALLY VARYING CORIOLIS PARAMETER
C...
      READ(15,*) NCOR
      IF((NCOR.NE.0).AND.(NCOR.NE.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NCOR =',NCOR
            WRITE(6,9729)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NCOR =',NCOR
         WRITE(16,9729)
         WRITE(16,9973)
 9729    FORMAT(/,1X,'Your selection of NCOR (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF((ICS.EQ.1).AND.(NCOR.EQ.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NCOR =',NCOR
            WRITE(6,9730)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NCOR =',NCOR
         WRITE(16,9730)
         WRITE(16,9973)
 9730    FORMAT(/,1X,'Your selection of NCOR (a UNIT 15 input ',
     *        'parameter) is inconsistent with your ',
     *        /,1X,'selection of coordinate systems.  Spatially ',
     *        'variable Coriolis should be used only with ',
     *        /,1X,'Spherical coordinates')
         STOP
      ENDIF
      IF(NCOR.EQ.0) THEN
         WRITE(16,233) NCOR
 233     FORMAT(/,5X,'NCOR = ',I2,
     *        /,9X,'A CONSTANT VALUE OF THE CORIOLIS PARAMETER WILL BE ',
     *        /,9X,'USED THROUGHOUT THE DOMAIN')
      ELSE
         WRITE(16,234) NCOR
 234     FORMAT(/,5X,'NCOR = ',I2,
     *        /,9X,'SPATIALLY VARYING CORIOLIS VALUES WILL BE COMPUTED ',
     *        'FROM INPUT LATITUDES')
      ENDIF

C...
C...  READ AND PROCESS NTIP - TIDAL POTENTIAL FORCING
C...
      READ(15,*) NTIP
      IF((NTIP.LT.0).OR.(NTIP.GT.2)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NTIP =',NTIP
            WRITE(6,9710)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NTIP =',NTIP
         WRITE(16,9710)
         WRITE(16,9973)
 9710    FORMAT(/,1X,'Your selection of NTIP (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF((ICS.EQ.1).AND.(NTIP.GE.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NTIP =',NTIP
            WRITE(6,9711)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NTIP =',NTIP
         WRITE(16,9711)
         WRITE(16,9973)
 9711    FORMAT(/,1X,'Your selection of NTIP (a UNIT 15 input ',
     *        'parameter) is inconsistent with your ',
     *        /,1X,'selection of coordinate systems.  Tidal',
     *        'potential forcing should be used only with ',
     *        /,1X,'Spherical coordinates')
         STOP
      ENDIF
      IF (NTIP.NE.0) CTIP = .TRUE.
      IF(NTIP.EQ.0) THEN
         WRITE(16,235) NTIP
 235     FORMAT(/,5X,'NTIP = ',I2,/,9X,
     *        'TIDAL POTENTIAL FORCING IS NOT USED IN THE COMPUTATION')
      ENDIF
      IF(NTIP.GE.1) THEN
         WRITE(16,236) NTIP
 236     FORMAT(/,5X,'NTIP = ',I2,
     *        /,9X,'TIDAL POTENTIAL FORCING IS USED IN THE COMPUTATION ',
     *        'BASED ON INPUT LONGITUDES/LATITUDES')
      ENDIF
      IF(NTIP.EQ.2) THEN
         WRITE(16,239)
 239     FORMAT(9X,'SELF ATTRACTION/LOAD TIDE FORCING IS ALSO USED ',
     *        'IN THE COMPUTATION')
      ENDIF
C...  
C...  READ AND PROCESS NWS - WIND AND PRESSURE FORCING & WAVE RADIATION
C...  STRESS FORCING
C...  
      READ(15,*) NWS
      IF((NWS.NE.0)    .AND.(NWS.NE.1)       .AND.(ABS(NWS).NE.2)  .AND.
     *     (NWS.NE.3)    .AND.(ABS(NWS).NE.4)  .AND.(ABS(NWS).NE.5)  .AND.
     *     (NWS.NE.6)    .AND.(NWS.NE.10)      .AND.(NWS.NE.11)      .AND.
     *     (NWS.NE.100)  .AND.(NWS.NE.101)     .AND.(NWS.NE.102)     .AND.
     *     (NWS.NE.103)  .AND.(ABS(NWS).NE.104).AND.(ABS(NWS).NE.105).AND.
     *     (NWS.NE.106)  .AND.(NWS.NE.110)     .AND.(NWS.NE.111)   ) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NWS =',NWS
            WRITE(6,9712)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NWS =',NWS
         WRITE(16,9712)
         WRITE(16,9973)
 9712    FORMAT(/,1X,'Your selection of NWS (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF

C.... SET WAVE RADIATION STRESS FLAG AND ADJUST NWS ACCORDINGLY

      NRS=0
      IF(ABS(NWS).GE.100) THEN
         NRS=1
         NWS=(ABS(NWS)-100)*(NWS/ABS(NWS))
      ENDIF
      IF(NWS.EQ.0) THEN
         WRITE(16,237) NWS
 237     FORMAT(/,5X,'NWS = ',I2,/,9X,
     *        'WIND STRESS OR SURFACE PRESSURE ARE NOT USED TO FORCE',
     *        'THE COMPUTATION')
      ENDIF
      IF(NWS.EQ.1) THEN
         WRITE(16,238) NWS
 238     FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'VALUES ARE READ AT ADCIRC GRID NODES FROM UNIT 22',
     *        /,9X,' EVERY MODEL TIME STEP')
      ENDIF
      IF(NWS.EQ.2) THEN
         WRITE(16,2381) NWS
 2381    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'VALUES ARE READ AT ADCIRC GRID NODES FROM UNIT 22',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT TIME=STATIM.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.')
      ENDIF
      IF(NWS.EQ.-2) THEN
         WRITE(16,2380) NWS
 2380    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'VALUES ARE READ AT ADCIRC GRID NODES FROM UNIT 22',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT THE TIME OF THE HOT START.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.')
      ENDIF
      IF(NWS.EQ.3) THEN
         WRITE(16,2382) NWS
 2382    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS ONLY IS USED TO FORCE THE COMPUTATION.',
     *        /,9X,'WIND SPEEDS AND DIRECTIONS ARE READ FROM A FLEET ',
     *        /,9X,'NUMERIC FORMAT FILE AT UNIT 22 AND INTERPOLATED TO',
     *        /,9X,'THE ADCIRC GRID. ',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.4) THEN
         WRITE(16,2383) NWS
 2383    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ AT SELECTED',
     *        /,9X,'ADCIRC GRID NODES FROM A PBL FILE AT UNIT 22.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT TIME=STATIM.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.-4) THEN
         WRITE(16,2388) NWS
 2388    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ AT SELECTED',
     *        /,9X,'ADCIRC GRID NODES FROM A PBL FILE AT UNIT 22.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT THE TIME OF THE HOT START.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.5) THEN
         WRITE(16,2384) NWS
 2384    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ AT ADCIRC ',
     *        /,9X,'GRID NODES FROM UNIT 22',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT TIME=STATIM.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.-5) THEN
         WRITE(16,2389) NWS
 2389    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ AT ADCIRC ',
     *        /,9X,'GRID NODES FROM UNIT 22',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP.',
     *        /,9X,'THE UNIT 22 FILE BEGINS AT THE TIME OF THE HOT START.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.6) THEN
         WRITE(16,2385) NWS
 2385    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ FROM A ',
     *        /,9X,'REGULARLY SPACED GRID FROM UNIT 22',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP AND IN SPACE TO BRING THE ',
     *        /,9X,'MET DATA FROM A REGULAR GRID TO THE ADCIRC GRID.'
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.10) THEN
         WRITE(16,2386) NWS
 2386    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ EVERY N',
     *        /,9X,' HOURS FROM A DIFFERENT FILE AT UNITS 200, 200+N,',
     *        ' 200+2N, ETC.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP AND IN SPACE TO BRING THE ',
     *        /,9X,'MET DATA FROM A GAUSSIAN GRID TO THE ADCRIC GRID.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NWS.EQ.11) THEN
         WRITE(16,2387) NWS
 2387    FORMAT(/,5X,'NWS = ',I2,
     *        /,9X,'WIND STRESS AND SURFACE PRESSURE ARE USED TO FORCE',
     *        /,9X,' THE COMPUTATION',
     *        /,9X,'WIND VELOCITY AND PRESSURE VALUES ARE READ EVERY 3 ',
     *        /,9X,'HOURS FROM ETA-29 FILES AT UNITS 200, 201, 202, ETC.',
     *        /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE WIND DATA ',
     *        /,9X,'WITH THE MODEL TIME STEP AND IN SPACE TO BRING THE ',
     *        /,9X,'WIND DATA FROM THE 29 KM E GRID TO THE ADCRIC GRID.',
     *        /,9X,'WIND SPEEDS ARE CONVERTED TO STRESS USING THE GARRET ',
     *        'DRAG LAW.')
      ENDIF
      IF(NRS.EQ.0) THEN
         WRITE(16,2390) NRS
 2390    FORMAT(/,5X,'NRS = ',I2,
     *        /,9X,'WAVE RADIATION STRESS IS NOT USED TO FORCE THE ',
     *        'COMPUTATION')
      ENDIF
      IF(NRS.EQ.1) THEN
         WRITE(16,2391) NRS
 2391    FORMAT(/,5X,'NRS = ',I2,
     *        /,9X,'WAVE RADIATION STRESS IS USED TO FORCE THE COMPUTATION',
     *        /,9X,'STRESSES ARE READ AT SELECTED ADCIRC GRID NODES FROM A',
     *        /,9X,'PBL TYPE FILE AT UNIT 23.  INTERPOLATION IN TIME IS ',
     *        /,9X,'DONE TO SYNC THE STRESS DATA WITH THE MODEL TIME STEP.',
     *        /,9X,'FOR A COLD START, THE UNIT 23 FILE BEGINS AT THE TIME ',
     *        /,9X,'OF THE COLD START.  FOR A HOT START, THE UNIT 23 FILE ',
     *        /,9X,'BEGINS AT THE TIME OF THE HOT START.')
      ENDIF
      
C...  
C...  READ AND PROCESS NRAMP - WHETHER A RAMP FUNCTION WILL BE USED
C...  
      READ(15,*) NRAMP
      IF((NRAMP.NE.0).AND.(NRAMP.NE.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'NRAMP =',NRAMP
            WRITE(6,9713)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'NRAMP =',NRAMP
         WRITE(16,9713)
         WRITE(16,9973)
 9713    FORMAT(/,1X,'Your selection of NRAMP (a UNIT 15 input ',
     *        'parameter) is not an allowable value')
         STOP
      ENDIF
      IF(NRAMP.EQ.0) THEN
         WRITE(16,240) NRAMP
 240     FORMAT(/,5X,'NRAMP = ',I2,
     *        /,9X,'NO RAMP FUNCTION IS USED IN THE COMPUTATION')
      ELSE
         WRITE(16,241) NRAMP
 241     FORMAT(/,5X,'NRAMP = ',I2,
     *        /,9X,'A HYPERBOLIC TANGENT RAMP IS APPLIED TO THE FORCING ',
     *        'FUNCTIONS')
      ENDIF

C...
C...  PROCESS G - GRAVITY
C...
      READ(15,*) G
      IF((ICS.EQ.2).AND.(abs(G-9.81).gt.0.01)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
            WRITE(6,9972)
            WRITE(6,*) 'G =',G
            WRITE(6,9714)
            WRITE(6,9973)
         ENDIF
         WRITE(16,9972)
         WRITE(16,*) 'G =',G
         WRITE(16,9714)
         WRITE(16,9973)
 9714    FORMAT(/,1X,'Your specification of the gravitational ',
     *        'constant, G, (a UNIT 15 input) is not ',
     *        /,1X,'consistant with the use of spherical coordinates.',
     *        '  G must be in units of m/s^2')
         STOP
      ENDIF
      WRITE(16,5) G
    5 FORMAT(///,5X,'GRAVITATIONAL CONSTANT G =',F10.5,/)

C...
C...  READ AND PROCESS TAU0 - WEIGHTING COEFFICIENT IN THE GWCE
C...
      READ(15,*) TAU0
cjj   w - added version m10/m12/m14/m16/m001
      if(tau0.lt.0) then
         write(16,6) 
 6       FORMAT(/,5X,'WEIGHTING COEFFICIENT FOR THE GENERALIZED',
     *        ' WAVE CONTINUITY EQUATION :',
     *        /,5x,'THIS VALUE WILL BE  SELECTED BASED ON NODAL DEPTH',
     *        ' ONCE DEPTHS HAVE BEEN PROCESSED',    
     *        /,5X,' DEPTH > 10       -> TAU0 = 0.005  ',    
     *        /,5X,' 10 >/ DEPTH        -> TAU0 = 0.020 ',  
     *        /,5X,' STARTDRY VALUE = -77777  -> TAU0 = 0.020 ',  
     *        /,5X,' STARTDRY VALUE = -88888  -> TAU0 = 0.020 ',/)  
      else
         WRITE(16,7) TAU0
 7       FORMAT(/,5X,'WEIGHTING COEFFICIENT FOR THE GENERALIZED',
     *        ' WAVE CONTINUITY EQUATION :',
     *        /,5X, 'TAU0 = ',E14.8,2X,'1/sec',/)
      endif 
C...  
C...  INPUT FROM UNIT 15 AND OUTPUT TO UNIT 16 TIME INTEGRATION
C...  INFORMATION INCLUDING DT,STATIM,REFTIM,AND RNDAY
C...  
      WRITE(16,1112)
      WRITE(16,245)
  245 FORMAT(//,1X,'TIME INTEGRATION INFORMATION',//)

C...
C...  READ AND PROCESS DT - MODEL TIME STEP
C...
      READ(15,*) DTDP
      DT=DTDP
      WRITE(16,9) DTDP
    9 FORMAT(5X,'TIME STEP =',F12.6,5X,'SECONDS',/)

C...
C...  READ AND PROCESS STATIM - SIMULATION STARTING TIME
C...  
      READ(15,*) STATIM
      WRITE(16,1113) STATIM
 1113 FORMAT(5X,'STARTING TIME FOR SIMULATION = ',F14.6,' DAYS',/)

C...
C...  READ AND PROCESS REFTIM - Harmonic REFERNCE TIME
C...
      READ(15,*) REFTIM
      WRITE(16,1115) REFTIM
 1115 FORMAT(5X,'Harmonic REFERENCE TIME = ',F14.6,' DAYS',/)

C...
C...  Read in and process additional timing information for wind.
C...
      IF((NWS.EQ.0).AND.(NRS.EQ.1)) READ(15,*) RSTIMINC
      IF((NWS.EQ.1).AND.(NRS.EQ.1)) READ(15,*) RSTIMINC
      IF(ABS(NWS).EQ.2) THEN
         IF(NRS.EQ.0) READ(15,*) WTIMINC
         IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
      ENDIF
      IF(NWS.EQ.3) THEN
         READ(15,*) IREFYR,IREFMO,IREFDAY,IREFHR,IREFMIN,REFSEC
         WRITE(16,1116) IREFMO,IREFDAY,IREFYR,IREFHR,IREFMIN,REFSEC
 1116    FORMAT(5X,'WIND REFERENCE TIME FOR SIMULATION = ',
     *        I2,'/',I2,'/',I2,'  ',I2,':',I2,':',f7.4,/)
         CALL TIMECONV(IREFYR,IREFMO,IREFDAY,IREFHR,IREFMIN,REFSEC,
     *        WREFTIM)
         IF(NRS.EQ.0) READ(15,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     *        WLONINC,WTIMINC
         IF(NRS.EQ.1) READ(15,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     *        WLONINC,WTIMINC,RSTIMINC
      ENDIF
      IF(ABS(NWS).EQ.4) THEN
         IF(NRS.EQ.0) READ(15,*) WTIMINC
         IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
      ENDIF
      IF(ABS(NWS).EQ.5) THEN
         IF(NRS.EQ.0) READ(15,*) WTIMINC
         IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
      ENDIF
      IF(NWS.EQ.6) THEN
         IF(NRS.EQ.0) READ(15,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     *        WLONINC,WTIMINC
         IF(NRS.EQ.1) READ(15,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     *        WLONINC,WTIMINC,RSTIMINC
      ENDIF
      IF(NWS.EQ.10) THEN
         NWLAT=190
         NWLON=384
         IF(NRS.EQ.0) READ(15,*) WTIMINC
         IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
      ENDIF
      IF(NWS.EQ.11) THEN
         NWLAT=271
         NWLON=181
         WTIMINC=10800.
         IF(NRS.EQ.1) READ(15,*) RSTIMINC
         !READ(15,*) NWLAT,NWLON,WTIMINC
      ENDIF

      IF(NWS.NE.0) WRITE(16,1117) WTIMINC
 1117 FORMAT(5X,'WIND TIME INCREMENT (SEC) = ',F10.2,/)
      IF(NRS.NE.0) WRITE(16,1118) RSTIMINC
 1118 FORMAT(5X,'RADIATION STRESS TIME INCREMENT (SEC) = ',F10.2,/)

C...
C...  READ AND PROCESS RNDAY - SIMULATION DURATION IN DAYS
C...
      READ(15,*) RNDAY
      WRITE(16,10) RNDAY
 10   FORMAT(5X,'TOTAL LENGTH OF NUMERICAL SIMULATION =',F12.4,
     *       5X,'DAYS',/)

C...
C...  COMPUTE TOTAL NUMBER OF TIME STEPS NT
C...
      NT=INT(RNDAY*(86400.D0/DTDP)+0.5d0)
      WRITE(16,1920) NT
 1920 FORMAT(5X,'NUMBER OF TIME STEPS  =',I8,/)
C...  
C...  READ AND PROCESS EFFECTIVE LENGTH OF THE HYPERBOLIC TANGENT RAMP
C...  IN DAYS
C...  
      READ(15,*) DRAMP
      IF(NRAMP.NE.0) THEN
         WRITE(16,8763) DRAMP
 8763    FORMAT(/,5X,'VALUE FOR DRAMP USED IN RAMP EVALUATION =',F12.4,
     *        5X,'DAYS',/)
         DAY=0.0
         WRITE(16,5841)
 5841    FORMAT(11X,' DAYS OF SIMULATION',2X,' TIME  ',6X,'  RAMP',/)
         DO IDR=1,24
            RAMP=TANH(DAY*2./DRAMP)
            WRITE(16,5845) DAY,DAY+STATIM,RAMP
 5845       FORMAT(15X,F8.2,6X,F8.2,2X,F15.7)
            IF(DAY.LT.3.0) THEN
               DAY=DAY+0.5d0
            ELSE
               DAY=DAY+1.0d0
            ENDIF
         END DO
      ENDIF

C...
C...  READ GWCE TIME WEIGHTING FACTORS
C...
      READ(15,*) A00,B00,C00
      WRITE(16,14)
14    FORMAT(//,5X,'TIME WEIGHTING FACTORS IN THE WAVE EQUATION :'/)
      WRITE(16,15) A00,B00,C00
15    FORMAT(9X,'AT TIME LEVEL K+1 : ',F8.5,
     *  /,9X,'AT TIME LEVEL K   : ',F8.5,
     *  /,9X,'AT TIME LEVEL K-1 : ',F8.5,/)

C...
C...  READ MINIMUM DEPTH OR WET/DRY PARAMETERS FROM UNIT 15
C...
      IF(NOLIFA.NE.2) THEN
         READ(15,*) H0
         WRITE(16,16) H0
 16      FORMAT(//,5X,'THE BATHYMETRIC DEPTH AT ALL NODES WILL BE ',
     *               'INCREASED TO H0= ',F12.4,' IF NECESSARY'/)
      ENDIF
      IF(NOLIFA.EQ.2) THEN
         READ(15,*) H0,NODEDRYMIN,NODEWETMIN,VELMIN
         WRITE(16,17) H0,NODEWETMIN,VELMIN,NODEDRYMIN
 17      FORMAT(//,5X,'DRYING WILL OCCUR WHEN THE WATER DEPTH < H0',
     *          /,5X,'H0 = ',F10.6,
     *          /,5X,'AND NODEREP > NODEWETMIN = ',I6,' TIME STEPS',
     *          /,5X,'NODEREP = NUMBER OF TIME STEPS SINCE A NODE ',
     *               'CHANGED STATE (EITHER WETTED OR DRIED)',
     *         //,5X,'WETTING WILL OCCUR WHEN THERE IS A FAVORABLE ',
     *               'PRESSURE GRADIENT THAT',
     *          /,5X,'WOULD DRIVE A STEADY VELOCITY TOWARDS A DRY NODE',
     *          /,5X,'THAT IS GREATER THAN VELMIN = ',F10.5,
     *          /,5X,'AND NODEREP > NODEDRYMIN = ',I6,' TIME STEPS',/)
      ENDIF

C...
C...  READ GRID INFORMATION FROM UNITS 14 & 15
C...
      READ(14,'(A24)') AGRID
      READ(14,*) NE,NP
      MNP = NP
      MNE = NE
      READ(15,*) SLAM0,SFEA0
      SLAM0=SLAM0*DEG2RAD
      SFEA0=SFEA0*DEG2RAD
      WRITE(16,1112)
      WRITE(16,246)
 246  FORMAT(//,1X,'GRID INFORMATION',//)

C ALLOCATE ARRAYS Dimensioned by MNP and MNE
      call alloc_main1()

C...
C...  IF ICS=1 INPUT NODAL COORDINATES AND BATHYMETRY FROM UNIT 14
C.... IF EITHER NTIP=1 OR NCOR=1, COMPUTE THE INVERSE CPP PROJECTION
C...  IF ICS=2 INPUT NODAL COORDINATES AND BATHYMETRY FROM UNIT 14
C.... AND COMPUTE CPP PROJECTED COORDINATES
C...
      IF(ICS.EQ.1) THEN
         DO I=1,NP
            READ(14,*) JKI,X(JKI),Y(JKI),DP(JKI)
            IF(JKI.NE.I) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99801)
               WRITE(16,99801)
99801          FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *              'INPUT ERROR  !!!!!!!!!',
     *              //,1X,'YOUR NODE NUMBERING IS NOT SEQUENTIAL ',
     *              'CHECK YOUR UNIT 14 INPUT FILE CAREFULLY',//)
            ENDIF
            IF((NTIP.GE.1).OR.(NCOR.EQ.1)) THEN
               CALL INVCP(X(JKI),Y(JKI),SLAM(JKI),SFEA(JKI),SLAM0,SFEA0)
            ENDIF
         END DO
      ENDIF
      IF(ICS.EQ.2) THEN
         DO I=1,NP
            READ(14,*) JKI,SLAM(JKI),SFEA(JKI),DP(JKI)
            IF(JKI.NE.I) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99801)
               WRITE(16,99801)
            ENDIF
            SLAM(JKI)=DEG2RAD*SLAM(JKI)
            SFEA(JKI)=DEG2RAD*SFEA(JKI)
            CALL CPP(X(JKI),Y(JKI),SLAM(JKI),SFEA(JKI),SLAM0,SFEA0)
         END DO
      ENDIF
      
C...
C...  IF ICS=1 SET THE SFAC VECTOR EQUAL TO UNITY
C...  IF ICS=2 COMPUTE THE SFAC VECTOR IN ORDER TO ADJUST EQUATIONS TO CPP
C...  COORDINATES
C...
      IF(ICS.EQ.1) THEN
         DO I=1,NP
            SFAC(I)=1.0d0
         END DO
      ENDIF
      IF(ICS.EQ.2) THEN
         DO I=1,NP
            SFAC(I)=COS(SFEA0)/COS(SFEA(I))
         END DO
      ENDIF
C...  
C...  IF WETTING AND DRYING WILL NOT BE USED, MAKE SURE ALL BATHYMETRIC
C...  DEPTHS ARE > OR = TO H0.
C...  
      IF((NOLIFA.EQ.0).OR.(NOLIFA.EQ.1)) THEN
         DO I=1,NP
            IF(DP(I).LT.H0) DP(I)=H0
         END DO
      ENDIF

C...
C...  READ THE GLOBAL CONNECTIVITY TABLE FROM UNIT 14
C...  COMPUTE ELEMENT AREAS
C...  CHECK THAT SUFFICIENT ACCURACY IS PROVIDED BY THE CODE TO HANDLE
C.... THE INPUT GRID
C...  CHECK TO INSURE THAT CORRECT CONVENTION HAS BEEN USED FOR INPUTING
C.... THE CONNECTIVITY TABLE
C...
      DO I=1, NP
         NNEIGH(I) = 0
      ENDDO
      
      DO I=1,NE
         READ(14,*) JKI,NHY,NM(JKI,1),NM(JKI,2),NM(JKI,3)
         NNEIGH(NM(JKI,1))=NNEIGH(NM(JKI,1))+1 !UPDATE THE NEIGHBOR TABLE
         NNEIGH(NM(JKI,2))=NNEIGH(NM(JKI,2))+1
         NNEIGH(NM(JKI,3))=NNEIGH(NM(JKI,3))+1

         IF(JKI.NE.I) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99802)
            WRITE(16,99802)
99802       FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *           'INPUT ERROR  !!!!!!!!!',
     *           //,1X,'YOUR ELEMENT NUMBERING IS NOT SEQUENTIAL ',
     *           /,1X,'CHECK YOUR UNIT 14 INPUT FILE CAREFULLY',//)
         ENDIF
         X1=X(NM(JKI,1))
         X2=X(NM(JKI,2))
         X3=X(NM(JKI,3))
         Y1=Y(NM(JKI,1))
         Y2=Y(NM(JKI,2))
         Y3=Y(NM(JKI,3))
         AVGXY=(ABS(X1)+ABS(X2)+ABS(X3)+ABS(Y1)+ABS(Y2)+ABS(Y3))/6.d0
         DIF1R=AVGXY/(((X2-X1)**2+(Y2-Y1)**2)**0.5d0)
         DIF2R=AVGXY/(((X3-X2)**2+(Y3-Y2)**2)**0.5d0)
         DIF3R=AVGXY/(((X3-X1)**2+(Y3-Y1)**2)**0.5d0)
         DIF1R=LOG10(DIF1R)
         DIF2R=LOG10(DIF2R)
         DIF3R=LOG10(DIF3R)
         IF((DIF1R.GT.NPREC).OR.(DIF2R.GT.NPREC).OR.(DIF3R.GT.NPREC))THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9898) JKI
            WRITE(16,9898) JKI
 9898       FORMAT(////,1X,'!!!!!!!!!!  WARNING  !!!!!!!!!',
     *           //,1X,'IF THE GRID COORDINATES HAVE 32 BITS ',
     *           '(APPROX 7 DIGITS) OF PRECISION',
     *           /,1X,'A ROBUST MODEL SOLUTION CAN NOT BE GUARANTEED',
     *           'AT ELEMENT NO. ',I10,
     *           //,1X,'MORE PRECISION MUST BE USED IN THE GRID',//)
         ENDIF
         AREAS(JKI)=(X1-X3)*(Y2-Y3)+(X3-X2)*(Y1-Y3) !2 X ACTUAL ELEMENT ARE
         IF(AREAS(JKI).LT.0.0) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9899) JKI
            WRITE(16,9899) JKI
 9899       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'THE CONNECTIVITY FOR ELEMENT ',I6,
     *           '  HAS BEEN INCORRECTLY SPECIFIED ',
     *           /,1X,'CHECK INPUT AND ENSURE THAT COUNTERCLOCKWISE',
     *           ' CONVENTION HAS BEEN USED ',
     *           //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
            STOP
         ENDIF
      END DO

C...
C...IF A BAROCLINIC 2D RUN, READ IN INITIAL DENSITY FIELD
C...
c      IF(IM.EQ.100) THEN
c        OPEN(11,FILE=DIRNAME//'/'//'fort.11')
c        READ(11,*)
c        READ(11,*)
c        READ(11,*) NP2
c        IF(NP2.NE.NP) THEN
c          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9943)
c          WRITE(16,9943)
c9943       FORMAT(////,' !!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
c    &              //,' THE NUMBER OF NODES (NP2) IN THE BAROCLINIC',
c    &                 ' INITIAL CONDITION FILE (UNIT 11) ',
c    &               /,' MUST EQUAL THE NUMBER OF NODES (NP) IN ',
c    &                 'THE ADCIRC GRID FILE (UNIT 14)'
c    &              //,' !!!!! EXECUTION WILL NOW BE TERMINATED !!!!!')
c          STOP
c          ENDIF
c
c        DO I=1,NP
c          READ(11,*) JKI,DASIGT(JKI),DATEMP(JKI),DASAL(JKI)
c          END DO
c        CLOSE(11)
c        ENDIF
C... c_p
C...
C...  PROCESS STARTDRY INFORMATION FROM UNIT 12 (IF NOLIFA=3 -> NSTARTDRY=1)
C...
      IF(NSTARTDRY.EQ.1) THEN

C...  OPEN UNIT 12 FILE        

         OPEN(12,FILE=DIRNAME//'/'//'fort.12')
         
C...  READ STARTDRY INFORMATION FROM UNIT 12 

         READ(12,'(A24)') AGRID2
         READ(12,*) NE2,NP2

C...  CHECK THAT NE2 AND NP2 MATCH WITH GRID FILE 

         IF((NE2.NE.NE).OR.(NP2.NE.NP)) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9900)
            WRITE(16,9900)
 9900       FORMAT(////,1X,'!!!!!!!!!!  FATAL ERROR  !!!!!!!!!',
     *           //,1X,'THE PARAMETER NE2 AND NP2 MUST MATCH NE AND NP ',
     *           /,1X,'USER MUST CHECK FORT.12 INPUT FILE ',
     *           //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
            STOP
         ENDIF

C...  READ IN STARTDRY CODE VALUES

         DO I=1,NP
            READ(12,*) JKI,DUM1,DUM2,STARTDRY(JKI)
            IF(JKI.NE.I) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99805)
               WRITE(16,99805)
99805          FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *              'INPUT ERROR  !!!!!!!!!',
     *              //,1X,'YOUR NODE NUMBERING IS NOT SEQUENTIAL ',
     *              'CHECK YOUR UNIT 12 INPUT FILE CAREFULLY',//)
            ENDIF
         END DO
         
C...  CLOSE UNIT 12 FILE       

         CLOSE(12)     

C...  IF NOT USING STARTUP ELEVATION FILE

      ELSE    
         DO I=1, NP
            STARTDRY(I) = 0.0D0
         ENDDO
      ENDIF

C...
Cjjw 08/16/2000 m001 reset tau0var values based on input values of startdry
Cjjw - automatic selection of tau0 on a processor
C...
      do i=1,np
         if(tau0.lt.0) then
            if(dp(i).le.10.0) tau0var(i)=0.02d0
            if(dp(i).gt.10.0) tau0var(i)=0.005d0
            if(startdry(i).eq.-77777) tau0var(i)=0.02d0
            if(startdry(i).eq.-88888) tau0var(i)=0.02d0
            write(16,248) myproc,i,tau0var(i)
 248        FORMAT(/,' myproc = ',i6,' node = ',i8, 
     *           ' tau0 set to ',f12.6,/) 
         else
            tau0var(i)=tau0
         endif 
      enddo

C...
C...OUTPUT TO UNIT 16 GRID INFORMATION INCLUDING AGRID,NE,NP
C....H0 AND NODAL COORDINATES AND BATHYMETRY
C...
      WRITE(16,2039) AGRID
2039  FORMAT(/,5X,'GRID IDENTIFICATION : ',A24,/)
      IF(NSTARTDRY.EQ.1) WRITE(16,2038) AGRID2
2038  FORMAT(5X,'STARTDRY FILE IDENTIFICATION : ',A24,/)
      WRITE(16,3) NP
    3 FORMAT(5X,'TOTAL NUMBER OF NODES =',I6,/)
      WRITE(16,4) NE
    4 FORMAT(5X,'TOTAL NUMBER OF ELEMENTS =',I6,/)
      IF(ICS.EQ.2) WRITE(16,13) SLAM0*RAD2DEG,SFEA0*RAD2DEG
   13 FORMAT(5X,'LONGITUDE ABOUT WHICH CPP PROJECTION IS CENTERED',
     *        '  SLAM0 = ',F9.4,' DEGREES',
     *     /,5X,'LATITUDE  ABOUT WHICH CPP PROJECTION IS CENTERED',
     *        '  SFEA0 = ',F9.4,' DEGREES',/)
      IF(NSTARTDRY.EQ.0) THEN 
        IF(NABOUT.NE.1) THEN
          WRITE(16,24)
   24     FORMAT(/,1X,'NODAL COORDINATES AND BATHYMETRY :')
          IF(ICS.EQ.1) THEN
            IF((NTIP.EQ.0).AND.(NCOR.EQ.0)) THEN
              WRITE(16,25)
   25         FORMAT(/,10X,'NODE NO.',10X,'X',20X,'Y',15X,'DP',/)
              DO I=1,NP
                WRITE (16,2008) I,X(I),Y(I),DP(I)
 2008           FORMAT(5X,I6,2(2X,F20.2),2X,F12.2)
                END DO
              ELSE
              WRITE(16,9195)
 9195         FORMAT(/,1X,'   NODE ',7X,'X',14X,'Y',9X,
     *                    'LAMBDA(DEG)',6X,'FEA(DEG)',9X,'DP',/)
              DO I=1,NP
                WRITE (16,9197) I,X(I),Y(I),SLAM(I)*RAD2DEG,
     *                          SFEA(I)*RAD2DEG,DP(I)
9197            FORMAT(1X,I6,2(1X,F14.1),1X,2(1X,E15.7),1X,F8.2)
                END DO
              ENDIF
            ELSE
            WRITE(16,9225)
9225        FORMAT(/,1X,'   NODE ',2X,'LAMBDA(DEG)',5X,'FEA(DEG)',11X,
     *                  'XCP',14X,'YCP',11X,'DP',/)
            DO I=1,NP
              WRITE (16,9228) I,SLAM(I)*RAD2DEG,SFEA(I)*RAD2DEG,
     *                        X(I),Y(I),DP(I)
9228          FORMAT(1X,I6,2(1X,F14.8),2(1X,F15.1),1X,F10.2)
              END DO
            ENDIF
          ELSE
          WRITE(16,3511)
3511      FORMAT(/,5X,'NODAL COORDINATES AND BATHYMETRY',
     *                ' INFORMATION IS AVAILABLE IN THE',
     *           /,6X,'UNIT 14 INPUT FILE')
          ENDIF
        ELSE
        IF(NABOUT.NE.1) THEN
          WRITE(16,24)
          IF(ICS.EQ.1) THEN
            IF((NTIP.EQ.0).AND.(NCOR.EQ.0)) THEN
              WRITE(16,3527)
 3527         FORMAT(/,10X,'NODE NO.',10X,'X',20X,'Y',15X,'DP',
     *         5X,'STARTDRY',/)
              DO I=1,NP
                IF(STARTDRY(I).EQ.-88888.d0)THEN
                  WRITE (16,3529) I,X(I),Y(I),DP(I),STARTDRY(I)
 3529             FORMAT(5X,I6,2(2X,F20.2),2X,F12.2,2X,F12.0)
                ELSE
                  WRITE (16,2008) I,X(I),Y(I),DP(I)
                ENDIF
              END DO
            ELSE
              WRITE(16,3530)
 3530         FORMAT(/,1X,'   NODE ',7X,'X',14X,'Y',9X,
     *                    'LAMBDA(DEG)',6X,'FEA(DEG)',9X,'DP',
     *                    5X,'STARTDRY',/)
              DO I=1,NP
                IF(STARTDRY(I).EQ.-88888.d0)THEN
                  WRITE (16,3531) I,X(I),Y(I),SLAM(I)*RAD2DEG,
     *                          SFEA(I)*RAD2DEG,DP(I),STARTDRY(I)
3531              FORMAT(1X,I6,2(1X,F14.1),1X,2(1X,E15.7),1X,F8.2,
     *             1X,F10.0)
                ELSE
                  WRITE (16,9197) I,X(I),Y(I),SLAM(I)*RAD2DEG,
     *                          SFEA(I)*RAD2DEG,DP(I)
                ENDIF
              END DO
            ENDIF
          ELSE
            WRITE(16,3535)
3535        FORMAT(/,1X,'   NODE ',2X,'LAMBDA(DEG)',5X,'FEA(DEG)',11X,
     *                  'XCP',14X,'YCP',11X,'DP',
     *                    5X,'STARTDRY',/)
            DO I=1,NP
              IF(STARTDRY(I).EQ.-88888.d0)THEN
                WRITE (16,3537) I,SLAM(I)*RAD2DEG,SFEA(I)*RAD2DEG,
     *                        X(I),Y(I),DP(I),STARTDRY(I)
3537            FORMAT(1X,I6,2(1X,F14.8),2(1X,F15.1),1X,F10.2,2X,F10.0)
              ELSE
                WRITE (16,9228) I,SLAM(I)*RAD2DEG,SFEA(I)*RAD2DEG,
     *                        X(I),Y(I),DP(I)
              ENDIF
            END DO
          ENDIF
        ELSE
          WRITE(16,3540)
3540      FORMAT(/,5X,'NODAL COORDINATES AND BATHYMETRY',
     *                ' INFORMATION IS AVAILABLE IN THE',
     *      /,6X,'UNIT 14 AND 12 INPUT FILES')
        ENDIF
      ENDIF

C...
C...OUTPUT TO UNIT 16 THE GLOBAL CONNECTIVITY TABLE (NODE NUMBERS FOR ELEMENTS)
C...
      IF(NABOUT.NE.1) THEN
         WRITE(16,26)
 26      FORMAT(//,5X,'GLOBAL NODE NUMBERS FOR EACH ELEMENT :')
         WRITE(16,27)
 27      FORMAT(/,9X,'ELEMENT',8X,'N1',9X,'N2',10X,'N3',/)
         DO I=1,NE
            WRITE(16,2009) I,NM(I,1),NM(I,2),NM(I,3)
 2009       FORMAT(8X,4(I7,4X))
         END DO
      ELSE
         WRITE(16,3512)
 3512    FORMAT(/,5X,'THE GLOBAL CONNECTIVITY TABLE',
     *        ' INFORMATION IS AVAILABLE IN THE',
     *        /,6X,'UNIT 14 INPUT FILE')
      ENDIF

C...
C...READ INFORMATION CONCERNING BOTTOM FRICTION COEFFICIENT
C...IF NWP=1, INPUT NODAL FRICTION COEFFICIENTS FROM UNIT 21
C...IF NWP=0, SET NODAL FRICTION COEFFICIENTS EQUAL TO CF
C...IF NWP=2, READ ADDITIONAL FRICTIONAL PARAMETERS FOR BRIDGE PILINGS
C...
      WRITE(16,1112)
      WRITE(16,2045)
2045  FORMAT(//,' BOTTOM FRICTION INFORMATION',//)

      HBREAK=1.
      FTHETA=1.
      FGAMMA=1.
      IF(NOLIBF.EQ.0) READ(15,*) TAU
      CF=TAU
      IF(NOLIBF.EQ.1) READ(15,*) CF
      IF(NOLIBF.EQ.2) READ(15,*) CF,HBREAK,FTHETA,FGAMMA

      IF((NWP.EQ.0).OR.(NWP.EQ.2)) THEN
         DO I=1,NP
            FRIC(I)=CF
         END DO
         IF(NOLIBF.EQ.2) THEN
            WRITE(16,101) CF,HBREAK,FTHETA,FGAMMA
 101        FORMAT(5X,'HYBRID FRICTION RELATIONSHIP PARAMTERS, CFMIN =',
     *           F12.8,'  HBREAK = ',F8.2,
     *           /,5X,'FTHETA = ',F8.2,'  FGAMMA = ',F10.4,//)
         ENDIF
         IF(NOLIBF.EQ.1) THEN
            WRITE(16,8) CF
 8          FORMAT(5X,'NONLINEAR FRICTION COEFFICIENT CF =',F12.8,/)
         ENDIF
         IF(NOLIBF.EQ.0) THEN
            WRITE(16,106) TAU
 106        FORMAT(5X,'LINEAR BOTTOM FRICTION TAU =',F12.8,5X,'1/sec'/)
            IF(TAU.NE.TAU0) THEN !CHECK TAU VALUE AGAINST TAU0
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9951)
               WRITE(16,9951)
 9951          FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *              'INPUT ERROR  !!!!!!!!!',
     *              //,1X,'TYPICALLY YOUR INPUT VALUE FOR ',
     *              'TAU0 SHOULD BE SET EQUAL TO TAU')
            ENDIF
         ENDIF
      ENDIF

      IF(NWP.EQ.1) THEN
        OPEN(21,FILE=DIRNAME//'/'//'fort.21')
        READ(21,'(A20)') AFRIC
        DO I=1,NP
          READ(21,*) NHG,FRIC(NHG)
          IF(NHG.NE.I) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99803)
            WRITE(16,99803)
99803       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ',
     *                     'INPUT ERROR  !!!!!!!!!',
     *        //,1X,'YOUR NODAL FRICTION NUMBERING IS NOT SEQUENTIAL ',
     *        /,1X,'CHECK YOUR UNIT 21 INPUT FILE CAREFULLY',
     *        //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
            STOP
            ENDIF
          END DO
        WRITE(16,3601) AFRIC
 3601   FORMAT(/,5X,'FRICTION FILE IDENTIFICATN : ',A20,/)
        IF(NABOUT.NE.1) THEN
          WRITE(16,2080)
 2080     FORMAT(/,10X,'NODE',5X,'BOTTOM FRICTION FRIC',5X,/)
          DO I=1,NP
            WRITE(16,2087) I,FRIC(I)
 2087       FORMAT(7X,I6,6X,E15.10)
            END DO
          ELSE
          WRITE(16,3504)
 3504     FORMAT(/,5X,'NODAL BOTTOM FRICTION VALUES ARE AVAILABLE',
     *           /,6X,' IN UNIT 21 INPUT FILE')
          ENDIF
        ENDIF

      IF(NWP.EQ.2) THEN
        CALL ALLOC_MAIN13()   !allocate bridge piling arrays
        DO I=1,NP
          NBNNUM(I)=0
          BK(I)=0.d0
          BALPHA(I)=0.d0
          BDELX(I)=1.d0
          ENDDO
        OPEN(21,FILE=DIRNAME//'/'//'fort.21')
        READ(21,'(A20)') AFRIC
        READ(21,*) NBPNODES
        DO I=1,NBPNODES                         
           READ(21,*) NBNNUM(I),BK(I),BALPHA(I),BDELX(I),POAN
           BDELX(I)=4.d0*BDELX(I)/POAN
           ENDDO            
        WRITE(16,3602) AFRIC
 3602   FORMAT(/,5X,'BRIDGE PIER FRICTION FILE IDENTIFICATN : ',A20,/)
        IF(NABOUT.NE.1) THEN
          WRITE(16,2081)
 2081     FORMAT(/,10X,'NODE',3X,'PIER SHAPE FACTOR',3X,
     *                 'CONSTRICTION FRACTION',3X,'EFFECTIVE DELX'/)
          DO I=1,NBPNODES
            WRITE(16,2082) NBNNUM(I),BK(I),BALPHA(I),BDELX(I)
 2082       FORMAT(5X,I8,10X,F7.3,12X,F7.3,13X,F9.3)
            END DO
          ELSE
          WRITE(16,2083)
 2083     FORMAT(/,5X,'BRIDGE PILING FRICTION VALUES ARE AVAILABLE',
     *           /,6X,' IN UNIT 21 INPUT FILE')
          ENDIF
        ENDIF

C...
C...READ IN AND WRITE OUT EDDY VISCOSITY/DIFFUSIVITY COEFFICIENTS
C...
      IF (IM.EQ.10) THEN
        READ(15,*) ESLM,ESLC
        DO I=1,NP
          EVM(I)=ESLM
          EVC(I)=ESLC
        END DO
        WRITE(16,111) ESLM,ESLC
 111    FORMAT(5X,'EVM, EDDY VISCOSITY COEFFICIENT =',E15.8,/,
     *         5X,'EVC, EDDY DIFFUSIVITY COEFFICIENT =',E15.8,//)
      ELSE
        READ(15,*) ESLM
        DO I=1,NP
          EVM(I)=ESLM
          END DO
        WRITE(16,11) ESLM
 11     FORMAT(5X,'EVM, EDDY VISCOSITY COEFFICIENT =',E15.8,//)
      ENDIF

C...
C...  READ CORIOLIS INFORMATION AND COMPUTE THE CORIOLIS VECTOR
C...  OUTPUT RESULTING CORIOLIS INFORMATION
C...
      WRITE(16,1112)
      WRITE(16,2090)
 2090 FORMAT(//,1X,'CORIOLIS INFORMATION ',//)

      READ(15,*) CORI
      IF(NCOR.EQ.0) THEN
         DO I=1,NP
            CORIF(I)=CORI
         END DO
      ENDIF
      IF(NCOR.EQ.1) THEN
         DO I=1,NP
            CORIF(I)=2.0d0*7.29212d-5*SIN(SFEA(I))
         END DO
      ENDIF

      IF(NCOR.EQ.0) THEN
         WRITE(16,12) CORI
 12      FORMAT(5X,'CONSTANT CORIOLIS COEFFICIENT =',E15.8,5X,'1/SEC',/)
      ENDIF
      IF(NCOR.EQ.1) THEN
         WRITE(16,3604)
 3604    FORMAT(/,5X,'LATITUDES ARE USED TO COMPUTE VARIABLE CORIOLIS',
     *        /,7X,'AND ARE BASED ON INPUT NODAL COORDINATES',/)
         IF(NABOUT.NE.1) THEN
            WRITE(16,2092)
 2092       FORMAT(/,10X,' NODE ',5X,'NODAL CORIOLIS CORIF',/)
            DO I=1,NP
               WRITE(16,2096) I,CORIF(I)
 2096          FORMAT(7X,I6,10X,E15.9)
            END DO
         ENDIF
      ENDIF

C...
C...  READ AND PROCESS INFORMATION ABOUT THE TIDAL POTENTIAL CONSTITUENTS
C...
      READ(15,*) NTIF
      mntif = ntif
      if (ntif .eq. 0) mntif = 1

C...  allocate tidal potential arrays
      
      call alloc_main4a()

C...  READ TIDAL POTENTIAL AMPLITUDE, FREQUENCIES, NODAL FACTORS,
C...  EQUILIBRIUM ARGUMENTS AND ALPHANUMERIC LABEL
C....
      DO I=1,NTIF
         READ(15,'(A5)')  TIPOTAG(I)
         READ(15,*)  TPK(I),AMIGT(I),ETRF(I),FFT(I),FACET(I)
         IF(AMIGT(I).EQ.0.) THEN
            PERT(I)=0.
         ELSE
            PERT(I)=2.D0*PI/AMIGT(I)
         ENDIF
      END DO

C...  LINES TO USE EARTH LOAD/SELF-ATTRACTION PART OF TIDAL POTENTIAL FORCING

      CALL ALLOC_MAIN4b()
      IF(NTIP.EQ.2) THEN
         OPEN(24,FILE='fort.24')
         DO I=1,NTIF
            READ(24,9930)
 9930       FORMAT(///)
            DO J=1,NP
               READ(24,*) JJ,SALTAMP(I,JJ),SALTPHA(I,JJ)
               SALTPHA(I,JJ)=SALTPHA(I,JJ)*DEG2RAD
            END DO
         END DO
      ELSE
         DO I=1,NTIF
            DO J=1,NP
               SALTAMP(I,J)=0.d0
               SALTPHA(I,J)=0.d0
            END DO
         END DO
         CLOSE(24)
      ENDIF

C...
C...  OUTPUT TO UNIT 16 INFORMATION ABOUT TIDAL POTENTIAL FORCING
C...  OUTPUT WILL VARY DEPENDING ON VALUES OF NTIP,NTIF AND NCOR
C...
      WRITE(16,1112)
      WRITE(16,2102)
 2102 FORMAT(//,1X,'TIDAL POTENTIAL FORCING INFORMATION ',//)
      WRITE(16,22) NTIF
 22   FORMAT(/,1X,'TIDAL POTENTIAL IS FORCED FOR ',I5,
     *     ' CONSTITUENT(S) ')
      IF(NTIF.GT.0) WRITE(16,23)
 23   FORMAT(/,1X,'AMPLITUDE',4X,'FREQUENCY',5X,
     *     '    ETRF      ','NODAL FACTOR',2X,
     *     'EQU.ARG(DEG)',1X,'CONSTITUENT',/)
      DO I=1,NTIF
         WRITE(16,2107) TPK(I),AMIGT(I),ETRF(I),FFT(I),FACET(I),
     *        TIPOTAG(I)
 2107    FORMAT(1X,F9.7,1X,F15.12,2X,F10.7,5X,F10.7,1X,F10.3,7X,A5)
      END DO
C...
C...  CONVERT FACET(I) VALUES FROM DEGREES TO RADIANS
C...
      DO I=1,NTIF
         FACET(I)=FACET(I)*DEG2RAD
      END DO
C...
C...  CHECK CONSISTENCY OF INPUT PARAMETERS NTIF AND NTIP
C...

      IF(((NTIP.EQ.0).AND.(NTIF.NE.0)).OR.((NTIP.NE.0).AND.
     *     (NTIF.EQ.0))) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9961)
         WRITE(16,9961)
 9961    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',
     *        //,1X,'YOUR SELECTION OF NTIF AND NTIP (UNIT 15 INPUT ',
     *        'PARAMETERS) IS INCONSISTENT',
     *        /,1X,'PLEASE CHECK THESE VALUES')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9987)
            WRITE(16,9987)
 9987       FORMAT(/,1X,'PROGRAM WILL OVERRIDE THE SPECIFIED ',
     *           'INPUT AND NEGLECT TIDAL POTENTIAL TERMS',
     *           /,1X,' AND/OR RESET NTIP = 0',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NTIP=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
         GOTO 1893
      ENDIF
C...  
C...  PRINT OUT LAT/LON VALUES TO BE USED IN COMPUTING TIDAL POTENTIAL
C...  IF NOT ALREADY DONE SO IN CORIOLIS SECTION AND TIDAL POTENTIAL IS
C...  ACTIVATED WITH NTIP=1
C...  
        IF(NTIP.GE.1) THEN
           IF(ICS.EQ.1) THEN
              WRITE(16,3605)
 3605         FORMAT(/,5X,'LONGITUDES AND LATITUDES ARE USED TO',
     *             ' COMPUTE THE TIDAL POTENTIAL FUNCTION',
     *             /,7X,'AND ARE BASED ON AN INVERSE CPP PROJECTION ',
     *             'OF THE INPUT COORDINATES',/)
           ELSE
              WRITE(16,2109)
 2109         FORMAT(/,5X,'LONGITUDES AND LATITUDES ARE USED TO',
     *             ' COMPUTE THE TIDAL POTENTIAL FUNCTION',
     *             /,7X,'AND ARE BASED ON INPUT NODAL COORDINATES ',/)
           ENDIF
        ENDIF
C...  
C...  INPUT FROM UNIT 15 THE TIDAL FORCING FREQUENCIES ON THE ELEVATION
C...  SPECIFIED BOUNDARIES: INCLUDING NBFR, FREQUENCIES, NODAL FACTORS,
C...  EQUILIBRIUM ARGUMENTS AND AN ELEVATION BOUNDARY CONDITION
C...  ALPHANUMERIC DESCRIPTOR
C...  
 1893   READ(15,*) NBFR
        MNBFR = NBFR
        IF (NBFR.EQ.0) MNBFR = 1

C     - Allocate arrays dimensioned by MNBFR
        call alloc_main5()

        WRITE(16,1112)
        WRITE(16,2106)
 2106   FORMAT(//,1X,'ELEVATION SPECIFIED BOUNDARY FORCING INFORMATION '
     *       ,//)
        WRITE(16,20) NBFR
 20     FORMAT(/,5X,'NUMBER OF PERIODIC, ELEVATION SPECIFIED ',
     *       'CONSTITUENTS =',I5)
        IF(NBFR.GE.1) WRITE(16,21)
 21     FORMAT(/,7X,'CONSTITUENT #',4X,'FREQUENCY',4X,'NODAL FACTOR',
     *       3X,'EQU.ARG (DEG)',2X,'CONSTITUENT',/)
        DO I=1,NBFR
           READ(15,'(A5)') BOUNTAG(I)
           READ(15,*) AMIG(I),FF(I),FACE(I)
           WRITE(16,1850) I,AMIG(I),FF(I),FACE(I),BOUNTAG(I)
 1850      FORMAT(12X,I2,6X,F16.12,2X,F10.7,2X,F10.3,10X,A5)
           FACE(I)=FACE(I)*DEG2RAD
           IF(AMIG(I).EQ.0.) THEN
              PER(I)=0.
           ELSE
              PER(I)=2.D0*PI/AMIG(I)
           ENDIF
        END DO
C...  
C...  INPUT ELEVATION BOUNDARY FORCING NODE NUMBER INFORMATION FROM
C...  UNIT 14 AND OUTPUT TO UNIT 16
C...  
C...  INPUT THE TOTAL NUMBER OF ELEVATION BOUNDARY SEGMENTS
C...  
      READ(14,*) NOPE

      WRITE(16,1852) NOPE
1852  FORMAT(///,5X,'TOTAL NUMBER OF ELEVATION BOUNDARY FORCING',
     *         ' SEGMENTS ',' = ',I5)
C...
C...INPUT THE TOTAL NUMBER OF ELEVATION BOUNDARY NODES
C...
      READ(14,*) NETA
      WRITE(16,1854) NETA
 1854 FORMAT(/,5X,'TOTAL NUMBER OF ELEVATION SPECIFIED BOUNDARY NODES ='
     *        ,I6)

C allocate arrays dimensioned by NOPE and NETA
      MNOPE = NOPE
      IF (NOPE.EQ.0) MNOPE = 1
      MNETA = NETA
      IF (NETA.EQ.0) MNETA = 1
      call alloc_main2()     
C...
C...  INPUT THE NODE NUMBERS ON EACH ELEVATION BOUNDARY FORCING SEGMENT
C...
      MNEI=0
      JNMM=0
      DO K=1,NOPE
         READ(14,*) NVDLL(K)
         WRITE(16,281) K,NVDLL(K)
 281     FORMAT(//,5X,'TOTAL NUMBER OF NODES ON ELEVATION SPECIFIED ',
     *        'BOUNDARY SEGMENT ',2X,I2,2X,'=',1X,I5,/)
         DO I=1,NVDLL(K)
            READ(14,*) NBDV(K,I)
            WRITE(16,1855) NBDV(K,I)
 1855       FORMAT(7X,I7)
            IF (NNEIGH(NBDV(K,I)).NE.0) THEN
               NNEIGH(NBDV(K,I))=NNEIGH(NBDV(K,I))+1
               IF (NNEIGH(NBDV(K,I)).GT.MNEI) MNEI=NNEIGH(NBDV(K,I))
               NNEIGH(NBDV(K,I)) = 0
            ENDIF

            NBD(JNMM+I)=NBDV(K,I)
         ENDDO
         JNMM=JNMM+NVDLL(K)
      ENDDO
C...
C...  CHECK TO MAKE SURE THAT JNMM EQUALS NETA
C...
       IF(NETA.NE.JNMM) THEN
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9945)
          WRITE(16,9945)
 9945     FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL INPUT ERROR ',
     *         '!!!!!!!!!',
     *         //,1X,'THE INPUT PARAMETER NETA FROM UNIT 14 DOES NOT MATCH ',
     *         'THE TOTAL NUMBER OF BOUNDARY NODES',
     *         /,1X,' FROM ALL THE SPECIFIED SEGMENTS COMBINED')
          IF(NFOVER.EQ.1) THEN
             IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9989)
             WRITE(16,9989)
 9989        FORMAT(/,1X,'THE PROGRAM WILL NOW CORRECT THIS ERROR',
     *            /,1X,'PLEASE CHECK YOUR INPUT CAREFULLY !!!',
     *            //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
             NETA=JNMM
          ELSE
             IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
             WRITE(16,9973)
             STOP
          ENDIF
       ENDIF
C...
C...  SET UP TO READ IN TIME SERIES ELEVATION SPECIFIED BOUNDARY
C...  CONDITIONS IF APPROPRIATE
C...
        IF((NBFR.EQ.0).AND.(NOPE.GT.0)) THEN
           WRITE(16,1871)
 1871      FORMAT(/,5X,'TIME SERIES ELEVATION SPECIFIED VALUES WILL BE ',
     *          'READ FROM UNIT 19',
     *          /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE ',
     *          /,9X,'ELEVATION DATA WITH THE MODEL TIME STEP.')
        ENDIF

C...  INPUT FORCING CONDITIONS ON PERIODIC ELEVATION SPECIFIED
C...  BOUNDARIES FOR EACH OF THE ELEVATION FORCING FREQUENCIES FROM UNIT
C...  15 AND OUTPUT TO UNIT 16
C...  
        DO I=1,NBFR
           WRITE(16,29) I,BOUNTAG(I)
 29        FORMAT(////,5X,'ELEVATION BOUNDARY TIDAL FORCING FOR',
     *          ' CONSTITUENT NUMBER',I4,1X,'DESIGNATED : ',A5)
           READ(15,'(A10)') ALPHA
           WRITE(16,31) ALPHA
 31        FORMAT(9X,'VERIFICATION OF CONSTITUENT : ',A10,/)
           WRITE(16,30)
 30        FORMAT(14X,'NODE',11X,'AMPL.',9X,'PHASE(DEG)',/)
           DO J=1,NETA
              READ(15,*) EMO(I,J),EFA(I,J)
              WRITE(16,1870) NBD(J),EMO(I,J),EFA(I,J)
 1870         FORMAT(10X,I8,4X,F14.5,4X,F12.3)
              EFA(I,J)=EFA(I,J)*DEG2RAD
           END DO
        END DO

C.....READ THE MINIMUM INNER ANGLE FOR WHICH VELOCITY AT FLOW BOUNDARY NODES
C.....WILL BE ZEROED IN THE TANGENTIAL DIRECTIONS WHEN NORMAL FLOW IS AN
C.....ESSENTIAL B.C.

      READ(15,*) ANGINN
      WRITE(16,1112)
      WRITE(16,7654) ANGINN
7654  FORMAT(//,5X,'ANGINN = ',F8.2,' DEGREES',
     *  /,5X,'ALL FLOW BOUNDARY NODES WITH NORMAL FLOW AS AN ',
     *       'ESSENTIAL B.C. AND ',
     *  /,9X,'INNER ANGLES LESS THAN ANGINN WILL HAVE BOTH NORMAL ',
     *  /,9X,'AND TANGENTIAL VELOCITY COMPONENTS ZEROED',/)
      COSTSET=COS(ANGINN*DEG2RAD)

C... 
C... INPUT FLOW BOUNDARY INFORMATION FROM UNIT 14 AND OUTPUT TO UNIT 16
C...  

C...  INTERIOR NODES, LBCODE=-1, COS=0, SIN=1
C...  BOUNDARY NODES, LBCODE=LBCODEI=IBTYPE,
C...  COS & SIN DETERMINED FROM NORMAL DIRECTION IN ALL CASES, ALTHOUGH THIS
C...  INFORMATION IS ONLY USED WHEN NORMAL FLOW IS AN ESSENTIAL B.C. AND
C...  FREE TANGENTIAL SLIP IS ALLOWED.

C...  INPUT THE TOTAL NUMBER OF FLOW BOUNDARY SEGMENTS

      WRITE(16,1112)
      WRITE(16,1878)
1878  FORMAT(//,1X,'FLOW BOUNDARY INFORMATION ',/)
      READ(14,*) NBOU

      WRITE(16,1879) NBOU
 1879 FORMAT(//,5X,'THE TOTAL NUMBER OF FLOW BOUNDARY SEGMENTS = ',I5)

C.....INPUT THE TOTAL NUMBER OF FLOW BOUNDARY NODES

      READ(14,*) NVEL
      WRITE(16,1881) NVEL
1881  FORMAT(/,5X,'THE TOTAL NUMBER OF FLOW BOUNDARY NODES = ',I5)

      MNBOU = NBOU
      IF (NBOU.EQ.0) MNBOU = 1
      MNVEL = NVEL*2    !Cvjp  -  11/28/99 -  upper bound guess for MNVEL

C...  Allocate space for nonperiodic zero and nonzero normal flow
C...  boundary arrays including barriers

      call alloc_main3()

C.....INPUT THE NUMBER OF NODES IN THE NEXT FLOW BOUNDARY SEGMENT
C.....AND THE BOUNDARY TYPE

      JGW=0
      JME=0
      NFLUXF=0
      NFLUXB=0
      NFLUXIB=0
      NFLUXIBP=0
      NVELEXT=0

      DO K=1,NBOU
         READ(14,*) NVELL(K),IBTYPE
C...  CHECK THAT IBTYPE PARAMETER HAS BEEN SET PROPERLY
         IF((IBTYPE.NE.0).AND.(IBTYPE.NE.10).AND.(IBTYPE.NE.20)
     *        .AND.(IBTYPE.NE.1).AND.(IBTYPE.NE.11).AND.(IBTYPE.NE.21)
     *        .AND.(IBTYPE.NE.2).AND.(IBTYPE.NE.12).AND.(IBTYPE.NE.22)
     *        .AND.(IBTYPE.NE.3).AND.(IBTYPE.NE.13).AND.(IBTYPE.NE.23)
     *        .AND.(IBTYPE.NE.4).AND.(IBTYPE.NE.24)
     *        .AND.(IBTYPE.NE.5).AND.(IBTYPE.NE.25)
     *        .AND.(IBTYPE.NE.30)) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9985) K
            WRITE(16,9985) K
 9985       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *        //,1X,'THE FLOW BOUNDARY TYPE PARAMETER IBTYPE ',
     *            'HAS NOT BEEN CORRECTLY SET FOR ',
     *      /,1X,'FLOW BOUNDARY SEGMENT NO. ',I8,
     *      /,1X,'USER MUST CORRECT UNIT 14 INPUT FILE',
     *      //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
            STOP
         ENDIF
C...  WRITE OUT INFORMATION TO UNIT 16
         IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
            WRITE(16,28) K,NVELL(K),K,2*NVELL(K)
 28         FORMAT(///,5X,'TOTAL NUMBER OF PAIRS FOR FLOW BOUNDARY',
     *                ' SEGMENT',2X,I2,2X,'=',2X,I5,/,
     *               5X,'TOTAL NUMBER OF NODES FOR FLOW BOUNDARY',
     *                ' SEGMENT',2X,I2,2X,'=',2X,I5)
         ELSE
            WRITE(16,128) K,NVELL(K)
 128        FORMAT(///,5X,'TOTAL NUMBER OF NODES FOR FLOW BOUNDARY',
     *                ' SEGMENT',2X,I2,2X,'=',2X,I5)
         ENDIF
C...  CONTINUE PROCESSING FLOW BOUNDARY INFORMATION
         IF(IBTYPE.EQ.0) THEN
            WRITE(16,2340)
 2340       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.1) THEN
            WRITE(16,2341)
 2341       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.2) THEN
            NFLUXF=1
            WRITE(16,2342)
 2342       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'SPECIFIED NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.3) THEN
            NFLUXB=1
            WRITE(16,2344)
 2344       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'A BARRIER WHICH ALLOWS FREE SURFACE',
     *           ' SUPERCRITICAL OUTFLOW',/,
     *           7X,'FROM THE DOMAIN ONCE THE BARRIER HAS BEEN',
     *           ' OVERTOPPED',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.4) THEN
            NFLUXIB=1
            WRITE(16,2345)
 2345       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BARRIER BOUNDARY:',/,
     *           7X,'WITH CROSS BARRIER FLOW TREATED AS AN ESSENTIAL ',
     *           ' NORMAL FLOW BOUNDARY CONDITION',/,
     *           7X,'WHICH LEAVES/ENTERS THE DOMAIN ON ONE SIDE OF ',
     *           ' THE BARRIER AND ENTERS/LEAVES THE DOMAIN ON THE ',/,
     *           7X,'CORRESPONDING OPPOSITE SIDE OF THE BARRIER ',/,
     *           7X,'FLOW RATE AND DIRECTION ARE BASED ON BARRIER ',
     *           ' HEIGHT, SURFACE WATER ELEVATION',/,
     *           7X,'ON BOTH SIDES OF THE BARRIER, BARRIER COEFFICIENT',
     *           ' AND THE APPROPRIATE BARRIER FLOW FORMULA',/,
     *           7X,'FREE TANGENTIAL SLIP IS ALLOWED',/)
         ENDIF
         IF(IBTYPE.EQ.5) THEN
            NFLUXIB=1
            NFLUXIBP=1
            WRITE(16,2347)
 2347       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BARRIER BOUNDARY:',/,
     *           7X,'WITH ADDITIONAL CROSS BARRIER PIPES ',
     *            'LOCATED UNDER THE CROWN ',/,
     *           7X,'CROSS BARRIER FLOW IS TREATED AS AN ESSENTIAL',
     *           ' NORMAL FLOW BOUNDARY CONDITION',/,
     *           7X,'WHICH LEAVES/ENTERS THE DOMAIN ON ONE SIDE OF ',
     *           ' THE BARRIER AND ENTERS/LEAVES THE DOMAIN ON THE ',/,
     *           7X,'CORRESPONDING OPPOSITE SIDE OF THE BARRIER ',/,
     *           7X,'FLOW RATE AND DIRECTION ARE BASED ON BARRIER ',
     *           ' HEIGHT, SURFACE WATER ELEVATION',/,
     *           7X,'ON BOTH SIDES OF THE BARRIER, BARRIER COEFFICIENT',
     *           ' AND THE APPROPRIATE BARRIER FLOW FORMULA',/,
     *           7X,'IN ADDITION CROSS BARRIER PIPE FLOW RATE AND ',
     *           ' DIRECTION ARE BASED ON PIPE CROWN HEIGHT, ',/,
     *           7X,'SURFACE WATER ELEVATION ON BOTH SIDES OF THE ',
     *           'BARRIER, PIPE FRICTION COEFFICIENT, PIPE DIAMETER',/,
     *           7X,' AND THE APPROPRIATE PIPE FLOW FORMULA',/,
     *           7X,'FREE TANGENTIAL SLIP IS ALLOWED',/)
         ENDIF
         IF(IBTYPE.EQ.10) THEN
            WRITE(16,2350)
 2350       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND NO TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.11) THEN
            WRITE(16,2351)
 2351       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND NO TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.12) THEN
            NFLUXF=1
            WRITE(16,2352)
 2352       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'SPECIFIED NORMAL FLOW AS AN ESSENTIAL B.C.',/,
     *           7X,'AND NO TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.13) THEN
            NFLUXB=1
            WRITE(16,2354)
 2354       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'A BARRIER WHICH ALLOWS FREE SURFACE',
     *           ' SUPERCRITICAL OUTFLOW',/,
     *           7X,'FROM THE DOMAIN ONCE THE BARRIER HAS BEEN',
     *           ' OVERTOPPED',/,
     *           7X,'AND NO TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.20) THEN
            WRITE(16,2360)
 2360       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS A NATURAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.21) THEN
            WRITE(16,2361)
 2361       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BOUNDARY WITH:',/,
     *           7X,'NO NORMAL FLOW AS A NATURAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.22) THEN
            NFLUXF=1
            WRITE(16,2362)
 2362       FORMAT(5X,'THIS SEGMENT IS A EXTERNAL BOUNDARY WITH:',/,
     *           7X,'SPECIFIED NORMAL FLOW AS A NATURAL B.C.',/,
     *           7X,'AND FREE TANGENTIAL SLIP',/)
         ENDIF
         IF(IBTYPE.EQ.23) THEN
            NFLUXB=1
            WRITE(16,2356)
 2356       FORMAT(5X,'THIS SEGMENT IS AN EXTERNAL BOUNDARY WITH:',/,
     *           7X,'A BARRIER WHICH ALLOWS FREE SURFACE',
     *           ' SUPERCRITICAL OUTFLOW',/,
     *           7X,'FROM THE DOMAIN ONCE THE BARRIER HAS BEEN',
     *           ' OVERTOPPED',/,
     *           7X,' IMPLEMENTED AS A NATURAL BOUNDARY CONDITION'
     *           ,7X,'FREE TANGENTIAL SLIP IS ALSO ALLOWED',/)
         ENDIF
         IF(IBTYPE.EQ.24) THEN
            NFLUXIB=1
            WRITE(16,2357)
 2357       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BARRIER BOUNDARY:',/,
     *           7X,'WITH CROSS BARRIER FLOW TREATED AS A NATURAL ',
     *           ' NORMAL FLOW BOUNDARY CONDITION',/,
     *           7X,'WHICH LEAVES/ENTERS THE DOMAIN ON ONE SIDE OF ',
     *           ' THE BARRIER AND ENTERS/LEAVES THE DOMAIN ON THE ',/,
     *           7X,'CORRESPONDING OPPOSITE SIDE OF THE BARRIER ',/,
     *           7X,'FLOW RATE AND DIRECTION ARE BASED ON BARRIER ',
     *           ' HEIGHT, SURFACE WATER ELEVATION',/,
     *           7X,'ON BOTH SIDES OF THE BARRIER, BARRIER COEFFICIENT',
     *           ' AND THE APPROPRIATE BARRIER FLOW FORMULA',/,
     *           7X,'FREE TANGENTIAL SLIP IS ALLOWED',/)
         ENDIF
         IF(IBTYPE.EQ.25) THEN
            NFLUXIB=1
            NFLUXIBP=1
            WRITE(16,2359)
 2359       FORMAT(5X,'THIS SEGMENT IS AN INTERNAL BARRIER BOUNDARY:',/,
     *           7X,'WITH ADDITIONAL CROSS BARRIER PIPES ',
     *            'LOCATED UNDER THE CROWN ',/,
     *           7X,'CROSS BARRIER FLOW IS TREATED AS A NATURAL',
     *           ' NORMAL FLOW BOUNDARY CONDITION',/,
     *           7X,'WHICH LEAVES/ENTERS THE DOMAIN ON ONE SIDE OF ',
     *           ' THE BARRIER AND ENTERS/LEAVES THE DOMAIN ON THE ',/,
     *           7X,'CORRESPONDING OPPOSITE SIDE OF THE BARRIER ',/,
     *           7X,'FLOW RATE AND DIRECTION ARE BASED ON BARRIER ',
     *           ' HEIGHT, SURFACE WATER ELEVATION',/,
     *           7X,'ON BOTH SIDES OF THE BARRIER, BARRIER COEFFICIENT',
     *           ' AND THE APPROPRIATE BARRIER FLOW FORMULA',/,
     *           7X,'IN ADDITION CROSS BARRIER PIPE FLOW RATE AND ',
     *           ' DIRECTION ARE BASED ON PIPE CROWN HEIGHT, ',/,
     *           7X,'SURFACE WATER ELEVATION ON BOTH SIDES OF THE ',
     *           'BARRIER, PIPE FRICTION COEFFICIENT, PIPE DIAMETER',/,
     *           7X,' AND THE APPROPRIATE PIPE FLOW FORMULA',/,
     *           7X,'FREE TANGENTIAL SLIP IS ALLOWED',/)
         ENDIF
         IF(IBTYPE.EQ.30) THEN
            NFLUXRBC=1
            WRITE(16,2355)
 2355       FORMAT(5X,'THIS SEGMENT IS AN OUTWARD RADIATING BOUNDARY:',/,
     *            7X,'NORMAL FLUX IS A NATURAL B.C. IN GWCE',/,
     *            7X,'NORMAL AND TANGENTIAL VELOCITY ARE COMPUTED FROM ',
     *            'THE MOMENTUM EQNS.',/)
         ENDIF
          

C...  INPUT INFORMATION FOR VARIOUS TYPES OF FLOW BOUNDARY SEGMENTS
C...  INPUT THE STANDARD NODE NUMBERS FOR THE Kth FLOW BOUNDARY SEGMENT
         IF((IBTYPE.NE.3).AND.(IBTYPE.NE.13).AND.(IBTYPE.NE.23).AND.
     *        (IBTYPE.NE.4).AND.(IBTYPE.NE.24).AND.
     *        (IBTYPE.NE.5).AND.(IBTYPE.NE.25)) THEN
            DO I=1,NVELL(K)
               READ(14,*) NBVV(K,I)
            END DO
            NPRBI=1
            NPIPE=0
         ENDIF
C...  INPUT THE NODE NUMBERS FOR THE Kth EXTERNAL BARRIER BOUNDARY SEGMENT
C...  ALSO INPUT THE ELEVATION OF THE EXTERNAL BARRIER NODES ABOVE
C...  THE GEOID AND THE COEFFICIENT OF FREE SURFACE SUPERCRITICAL
C...  FLOW ALONG WITH EACH EXTERNAL BARRIER BOUNDARY NODE FROM UNIT 14
         IF((IBTYPE.EQ.3).OR.(IBTYPE.EQ.13).OR.(IBTYPE.EQ.23)) THEN
            DO I=1,NVELL(K)
               READ(14,*) NBVV(K,I),BARLANHTR(I),BARLANCFSPR(I)
            END DO
            NPRBI=1
            NPIPE=0
         ENDIF
C...  INPUT THE NODE NUMBERS FOR THE Kth INTERNAL BARRIER BOUNDARY SEGMENT
C...  ALSO INPUT CONNECTION NODE NUMBER AND ELEVATION OF THE INTERNAL BARRIER
C...  NODES ABOVE THE GEOID AND THE COEFFICIENTS OF FREE SURFACE SUPERCRITICAL
C...  AND SUBCRITICAL FLOW ALONG WITH EACH INTERNAL BARRIER BOUNDARY NODE FROM
C...  UNIT 14
         IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
            DO I=1,NVELL(K)
               READ(14,*) NBVV(K,I),IBCONNR(I),BARINHTR(I),BARINCFSBR(I)
     *              ,BARINCFSPR(I)
            END DO
            NPRBI=2
            NPIPE=0
         ENDIF

C...  INPUT THE NODE NUMBERS FOR THE Kth INTERNAL BARRIER BOUNDARY
C...  SEGMENT WITH CROSS BARRIER PIPES; ALSO INPUT CONNECTION NODE
C...  NUMBER AND ELEVATION OF THE INTERNAL BARRIER NODES ABOVE THE GEOID
C...  AND THE COEFFICIENTS OF FREE SURFACE SUPERCRITICAL AND SUBCRITICAL
C...  FLOW ALONG WITH EACH INTERNAL BARRIER BOUNDARY NODE FROM UNIT 14;
C...  IN ADDITION INPUT THE CROSS BARRIER PIPE HEIGHT, CROSS BARRIER
C...  PIPE COEFFICIENT AND CROSS BARRIER PIPE DIAMETER

         IF((IBTYPE.EQ.5).OR.(IBTYPE.EQ.25)) THEN
            DO I=1,NVELL(K)
               READ(14,*) NBVV(K,I),IBCONNR(I),BARINHTR(I),BARINCFSBR(I),
     *              BARINCFSPR(I),PIPEHTR(I),PIPECOEFR(I),
     *              PIPEDIAMR(I)
            END DO
            NPRBI=2
            NPIPE=1
         ENDIF
         
C...  PROCESS INFORMATION FOR VARIOUS TYPES OF FLOW BOUNDARY SEGMENTS

         DO IPRBI=1,NPRBI
            
C...  LOAD PAIRED NODES INTO PRIMARY PROCESSING VECTORS AND RESET
C...  CONNECTING NODES FOR BACK FACE THUS BACK/CONNECTING NODES ARE
C...  BEING LOADED AS PRIMARY NODES AND FRONT NODES ARE RELOADED AS
C...  CONNECTING NODES NOTE THAT THE CLOCKWISE ORIENTATION OF ISLAND
C...  TYPE BOUNDARIES IS BEING MAINTAINED WHEN BACK NODES ARE RELOADED
C...  AS PRIMARY NODES ADDITIONAL INTERNAL BARRIER BOUNDARY INFORMATION
C...  IS ALSO RESET

            IF(IPRBI.EQ.2) THEN
               DO I=1,NVELL(K)
                  NTRAN1(I)=NBVV(K,I)
                  NTRAN2(I)=IBCONNR(I)
                  BTRAN3(I)=BARINHTR(I)
                  BTRAN4(I)=BARINCFSBR(I)
                  BTRAN5(I)=BARINCFSPR(I)
                  IF(NPIPE.EQ.1) THEN
                     BTRAN6(I)=PIPEHTR(I)
                     BTRAN7(I)=PIPECOEFR(I)
                     BTRAN8(I)=PIPEDIAMR(I)
                  ENDIF
               END DO
               DO I=1,NVELL(K)
                  NBVV(K,I)=NTRAN2(NVELL(K)+1-I)
                  IBCONNR(I)=NTRAN1(NVELL(K)+1-I)
                  BARINHTR(I)=BTRAN3(NVELL(K)+1-I)
                  BARINCFSBR(I)=BTRAN4(NVELL(K)+1-I)
                  BARINCFSPR(I)=BTRAN5(NVELL(K)+1-I)
                  IF(NPIPE.EQ.1) THEN
                     PIPEHTR(I)=BTRAN6(NVELL(K)+1-I)
                     PIPECOEFR(I)=BTRAN7(NVELL(K)+1-I)
                     PIPEDIAMR(I)=BTRAN8(NVELL(K)+1-I)
                  ENDIF
               END DO
            ENDIF

C...  WRITE OUT ADDITIONAL HEADER FOR INTERNAL BARRIER BOUNDARIES

            IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
               IF(IPRBI.EQ.1) THEN
                  WRITE(16,1842)
 1842             FORMAT(/,5X,'FRONT FACE OF INTERNAL BARRIER BOUNDARY',/)
               ELSE
                  WRITE(16,1843)
 1843             FORMAT(/,5X,'BACK FACE OF INTERNAL BARRIER BOUNDARY',/)
               ENDIF
            ENDIF

C...  WRITE OUT ADDITIONAL HEADER FOR INTERNAL BARRIER BOUNDARIES WITH
C...  CROSS BARRIER PIPES

            IF((IBTYPE.EQ.5).OR.(IBTYPE.EQ.25)) THEN
               IF(IPRBI.EQ.1) THEN
                  WRITE(16,1844)
 1844             FORMAT(/,5X,'FRONT FACE OF INTERNAL BARRIER BOUNDARY',
     *                 ' WITH CROSS BARRIER PIPES',/)
               ELSE
                  WRITE(16,1845)
 1845             FORMAT(/,5X,'BACK FACE OF INTERNAL BARRIER BOUNDARY',
     *                 ' WITH CROSS BARRIER PIPES',/)
               ENDIF
            ENDIF

C...  WRITE OUT GENERAL HEADER FOR BOUNDARY INFORMATION

            WRITE(16,1841)
 1841       FORMAT('    JGW    JME    ME2GW   NODE #  BNDRY CODE   INNER',
     *           ' ANGLE',7X,'COS',13X,'SIN',9X,'0.667*BNDRY LEN',/)

C...  COMPLETE THE BOUNDARY ARRAY FOR THE Kth FLOW BOUNDARY SEGMENT

            NBVV(K,0)=NBVV(K,1) !UNCLOSED EXTERNAL
            IF((IBTYPE.EQ.1).OR.(IBTYPE.EQ.11).OR.(IBTYPE.EQ.21)) THEN
               IF(NBVV(K,NVELL(K)).NE.NBVV(K,1)) THEN !CLOSE AN UNCLOSED INTERNAL
                  NVELL(K)=NVELL(K)+1
                  NBVV(K,NVELL(K))=NBVV(K,1)
               ENDIF
            ENDIF
            IF(NBVV(K,NVELL(K)).EQ.NBVV(K,1)) THEN !CLOSED EXTERNAL OR INTERNAL
               NBVV(K,0)=NBVV(K,NVELL(K)-1)
            ENDIF
            NBVV(K,NVELL(K)+1)=NBVV(K,NVELL(K))

C...  PUT BOUNDARY INFORMATION INTO 2 TYPES OF ARRAYS, ONE FOR THE GWCE
C...  B.C. AND ONE FOR THE MOMENTUM EQUATION B.C.
c
C...  THE GWCE ARRAYS INCLUDE EVERY NODE IN THE UNIT 14 FILE, I.E.,
C...  NODES ARE REPEATED WHERE SPECIFIED NORMAL FLOW AND NO NORMAL FLOW
C...  BOUNDARIES MEET AND AT THE BEGINNING AND END OF CLOSED EXTERNAL
C...  BOUNDARIES AND ISLANDS.
c
C...  THE MOMENTUM EQUATION ARRAYS ARE KEYED TO THE GWCE ARRAYS VIA THE
C...  ARRAY ME2GW WHICH INDICATES THE LOCATION IN THE GWCE ARRAYS THAT
C...  THE APPROPRIATE M.E. VALUE LIES.
c
C...  THE M.E. ARRAYS DO NOT REPEAT NODES THAT ARE DUPLICATED IN THE
C...  UNIT 14 FILE, I.E., WHEN SPECIFIED NORMAL FLOW AND NO NORMAL FLOW
C...  BOUNDARIES MEET, THE SPECIFIED NORMAL FLOW BOUNDARY CONDITION
C...  TAKES PRECEDENT.  ALSO THE BEGINNING AND ENDING NODES OF CLOSED
C...  EXTERNAL AND ISLAND BOUNDARIES ARE NOT REPEATED.

            DO I=1,NVELL(K)

C...  SET UP THE GWCE BOUNDARY ARRAYS WHICH CONSIST OF
C...  BOUNDARY NODE NUMBERS
C...  BOUNDARY CODES
C...  0.66667*LENGTH OF EACH BOUNDARY SEGMENT.  NOTE, THE LENGTH OF THE
C...  LAST BOUNDARY SEGMENT ON EACH BOUNDARY SHOULD BE ZERO

               JGW=JGW+1
               IF((IBTYPE.EQ.0).OR.(IBTYPE.EQ.10).OR.(IBTYPE.EQ.20).OR.
     *              (IBTYPE.EQ.2).OR.(IBTYPE.EQ.12).OR.(IBTYPE.EQ.22).OR.
     *              (IBTYPE.EQ.3).OR.(IBTYPE.EQ.13).OR.(IBTYPE.EQ.23).OR.
     *              (IBTYPE.EQ.30)) THEN
                  NVELEXT=NVELEXT+1
               ENDIF
               NBV(JGW)=NBVV(K,I)
               NBVI=NBVV(K,I)
               NBVJ=NBVV(K,I+1)
               DELX=X(NBVJ)-X(NBVI)
               DELY=Y(NBVJ)-Y(NBVI)
               BNDLEN2O3(JGW)=2.D0*(SQRT(DELX*DELX+DELY*DELY))/3.D0

C...  COMPUTE THE INCLUDED ANGLE AND TEST TO DETERMINE WHETHER TO ZERO
C...  TANGENTIAL VELOCITIES

C...  NOTE:.IMPLEMENTATION FOR ICS=2 REQUIRES COMPUTING ALL COORDINATES
C...  IN A LOCALIZED SYSTEM (I.E. THE TRANSFORMATION IS CENTERED AT
C...  X0,Y0)

               IF(ICS.EQ.1) THEN
                  XL0=X(NBVV(K,I))
                  XL1=X(NBVV(K,I-1))
                  XL2=X(NBVV(K,I+1))
                  YL0=Y(NBVV(K,I))
                  YL1=Y(NBVV(K,I-1))
                  YL2=Y(NBVV(K,I+1))
               ELSE
                  CALL CPP(XL0,YL0,SLAM(NBVV(K,I)),SFEA(NBVV(K,I)),
     *                 SLAM(NBVV(K,I)),SFEA(NBVV(K,I)))
                  CALL CPP(XL1,YL1,SLAM(NBVV(K,I-1)),SFEA(NBVV(K,I-1)),
     *                 SLAM(NBVV(K,I)),SFEA(NBVV(K,I)))
                  CALL CPP(XL2,YL2,SLAM(NBVV(K,I+1)),SFEA(NBVV(K,I+1)),
     *                 SLAM(NBVV(K,I)),SFEA(NBVV(K,I)))
               ENDIF

C...  NOTE: INTERIOR ANGLE AT ENDS OF BOUNDARIES MUST BE EQUAL, EITHER:
C...  A FICTICIOUSLY LARGE VALUE IF THE BOUNDARY IS NOT CLOSED OR A TRUE
C...  VALUE IF THE BOUNDARY IS CLOSED

               THETA=0.
               IF((I.EQ.1).AND.(NBVV(K,I).EQ.NBVV(K,I-1))) THEN
                  THETA1=-9999999.d0
                  THETA=THETA1
                  COSTHETA1=COSTSET
                  COSTHETA=COSTHETA1
                  CROSS1=0.d0
                  CROSS=CROSS1
               ENDIF
               IF(I.EQ.NVELL(K)) THEN
                  THETA=THETA1
                  COSTHETA=COSTHETA1
                  CROSS=CROSS1
               ENDIF
               IF(THETA.EQ.0.) THEN
                  VL1X=XL1-XL0
                  VL1Y=YL1-YL0
                  VL2X=XL2-XL0
                  VL2Y=YL2-YL0
                  DOTVEC=VL1X*VL2X+VL1Y*VL2Y
                  VECNORM=(SQRT(VL1X**2+VL1Y**2))*(SQRT(VL2X**2+VL2Y**2))
                  COSTHETA=DOTVEC/VECNORM
                  IF(COSTHETA.GT.1.0d0) COSTHETA=1.0d0
                  IF(COSTHETA.LT.-1.0d0) COSTHETA=-1.0d0
                  THETA=RAD2DEG*ACOS(COSTHETA)
                  CROSS=-VL1X*VL2Y+VL2X*VL1Y
                  IF(CROSS.LT.0) THETA=360.d0-THETA
                  IF(I.EQ.1) THEN
                     THETA1=THETA
                     COSTHETA1=COSTHETA
                     CROSS1=CROSS
                  ENDIF
               ENDIF

C...  CHECK WHETHER ANGLE IS LESS THAN MINIMUM ANGLE, IF SO CHANGE THE
C...  BOUNDARY CODE TO ZERO TANGENTIAL VELOCITIES

               LBCODEI(JGW)=IBTYPE
C     
C     Boundary condition diagnostics
C     
c               write(*,*) 'lbcodei(',jgw,')=',lbcodei(jgw)
               
               IF((COSTHETA.GT.COSTSET).AND.(CROSS.GT.0.0)) THEN
                  IF(IBTYPE.EQ.0) LBCODEI(JGW)=10
                  IF(IBTYPE.EQ.1) LBCODEI(JGW)=11
                  IF(IBTYPE.EQ.2) LBCODEI(JGW)=12
                  IF(IBTYPE.EQ.3) LBCODEI(JGW)=13
                  IF((IBTYPE.GE.0).AND.(IBTYPE.LE.3)) THEN
                     WRITE(16,1856) NBVV(K,I),THETA
 1856                FORMAT(2X,I7,4X,'THE INNER ANGLE = ',F8.2,1X,
     *                    'TANGENTIAL SLIP WILL BE ZEROED')
                  ENDIF
               ENDIF

C...  COMPUTE COS AND SIN OF OUTWARD NORMAL REGARDLESS OF BOUNDARY TYPE

               X1=X(NBVV(K,I-1))
               X2=X(NBVV(K,I+1))
               Y1=Y(NBVV(K,I-1))
               Y2=Y(NBVV(K,I+1))
               XL=SQRT((X1-X2)**2+(Y1-Y2)**2)
               CSII(JGW)=SFAC(NBVV(K,I))*(Y2-Y1)/XL
               SIII(JGW)=(X1-X2)/XL

C...  SET UP THE MOMENTUM EQUATION BOUNDARY ARRAY WHICH CONSISTS OF A
C...  KEY TO THE GWCE BOUNDARY CONDITION ARRAY

               IF(I.EQ.1) THEN  !DEAL WITH FIRST NODE IN L.B. SEG
                  IF(JGW.EQ.1) THEN !VERY FIRST L.B. SEG
                     JME=JME+1  !M.E. USES IT
                     ME2GW(JME)=JGW
                  ENDIF
                  IF(JGW.NE.1) THEN
                     IF(NBV(JGW).NE.NBV(JGW-1)) THEN !L.B. SEGS DON'T OVERLAP
                        JME=JME+1 !M.E. USES IT
                        ME2GW(JME)=JGW
                     ENDIF
                     IF(NBV(JGW).EQ.NBV(JGW-1)) THEN !L.B. SEGS OVERLAP
                        IF((LBCODEI(JGW).EQ.2) .OR. ! M.E. USES IT ONLY
     *                       (LBCODEI(JGW).EQ.12).OR. ! IF IT IS
     *                       (LBCODEI(JGW).EQ.22).OR. ! SPECIFIED FLOW,
     *                       (LBCODEI(JGW).EQ.3) .OR. ! AN OVERFLOW BARRIER
     *                       (LBCODEI(JGW).EQ.13).OR. ! OR A RADIATION
     *                       (LBCODEI(JGW).EQ.23).OR. ! BOUNDARY
     *                       (LBCODEI(JGW).EQ.30)) ME2GW(JME)=JGW
                     ENDIF
                  ENDIF
               ENDIF
               IF((I.GT.1).AND.(I.LT.NVELL(K))) THEN !IF NOT FIRST OR
                  JME=JME+1     !LAST NODE
                  ME2GW(JME)=JGW !M.E. USES IT
               ENDIF
               IF(I.EQ.NVELL(K)) THEN !DEAL WITH LAST NODE ON BOUNDARY
                  IF((NBV(JGW).NE.NBVV(K,1)).AND. !IF UNCLOSED BOUNDARY
     *                 (NBV(JGW).NE.NBV(1))) THEN !M.E. USES IT
                     JME=JME+1
                     ME2GW(JME)=JGW
                  ENDIF
                  IF(NBVV(K,I).EQ.NBV(1)) THEN !IF OVERLAPS WITH VERY FIRST
                     IF((LBCODEI(JGW).EQ.2) .OR. ! L.B. NODE
     *                    (LBCODEI(JGW).EQ.12).OR. ! M.E. USES IT ONLY IF IT IS
     *                    (LBCODEI(JGW).EQ.22).OR. ! SPECIFIED FLOW,
     *                    (LBCODEI(JGW).EQ.3) .OR. ! AN OVERFLOW BARRIER OR
     *                    (LBCODEI(JGW).EQ.13).OR. ! A RADIATION
     *                    (LBCODEI(JGW).EQ.23).OR. ! BOUNDARY
     *                    (LBCODEI(JGW).EQ.30)) ME2GW(1)=JGW
                  ENDIF
               ENDIF

C...........LOAD EXTERNAL BARRIER BOUNDARY INFORMATION INTO THE CORRECT VECTORS
               IF((IBTYPE.EQ.3).OR.(IBTYPE.EQ.13).OR.(IBTYPE.EQ.23)) THEN
                  BARLANHT(JGW)=BARLANHTR(I)
                  BARLANCFSP(JGW)=BARLANCFSPR(I)
               ENDIF

C...........LOAD INTERNAL BARRIER BOUNDARY INFORMATION INTO THE CORRECT VECTORS
               IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
                  IBCONN(JGW)=IBCONNR(I)
                  BARINHT(JGW)=BARINHTR(I)
                  BARINCFSB(JGW)=BARINCFSBR(I)
                  BARINCFSP(JGW)=BARINCFSPR(I)
               ENDIF
               
C...........LOAD INTERNAL BARRIER WITH PIPES BOUNDARY INFORMATION INTO 
C............THE CORRECT VECTORS
               IF((IBTYPE.EQ.5).OR.(IBTYPE.EQ.25)) THEN
                  IBCONN(JGW)=IBCONNR(I)
                  BARINHT(JGW)=BARINHTR(I)
                  BARINCFSB(JGW)=BARINCFSBR(I)
                  BARINCFSP(JGW)=BARINCFSPR(I)
                  PIPEHT(JGW)=PIPEHTR(I)
                  PIPECOEF(JGW)=PIPECOEFR(I)
                  PIPEDIAM(JGW)=PIPEDIAMR(I)
               ENDIF

C...........WRITE OUT BOUNDARY CONDITION ARRAY INFORMATION

               WRITE(16,1857) JGW,JME,ME2GW(JME),NBV(JGW),LBCODEI(JGW),
     *              THETA,CSII(JGW),SIII(JGW),BNDLEN2O3(JGW)
 1857          FORMAT(1X,I6,1X,I6,1X,I6,3X,I6,3X,I4,9X,F8.2,2X,E16.8,1X,
     *              E16.8,2X,E16.8)

C...........CHECK EXTERNAL BARRIER HEIGHTS AGAINST DEPTHS
               IF((IBTYPE.EQ.3).OR.(IBTYPE.EQ.13).OR.(IBTYPE.EQ.23)) THEN
                  IF(BARLANHT(JGW).LT.-DP(NBV(JGW))) THEN
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,8367) 
     *                    JGW,NBV(JGW),BARLANHT(JGW),DP(NBV(JGW))
                     WRITE(16,8367) JGW,NBV(JGW),BARLANHT(JGW),DP(NBV(JGW))
 8367                FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!'
     *           ,'!!!!!!!!!',//,
     *           1X,'AT BOUNDARY NODE NO.',I6,' (GLOBAL NODE NO.',
     *           I6, ' AND OF EXTERNAL BARRIER TYPE) ',/,
     *           2X,'THE EXTERNAL BARRIER HEIGHT = ',E12.5,
     *           2X,'IS EXCEEDED BY THE DEPTH SPECIFIED AT ',/,2X
     *           ,'THE ASSOCIATED GLOBAL NODE = ',E12.5,/,2X,
     *           'USER MUST SPECIFY CONSISTENT BARRIER HEIGHTS',
     *           ' AND DEPTHS')
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
                     WRITE(16,9973)
                     STOP
                  ENDIF
               ENDIF
C...........CHECK INTERNAL BARRIER HEIGHTS AGAINST DEPTHS
               IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
                  IF(BARINHT(JGW).LT.-DP(NBV(JGW))) THEN
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,8368) 
     *                    JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
                     WRITE(16,8368) JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
 8368                FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!'
     *           ,'!!!!!!!!!',//,
     *           1X,'AT BOUNDARY NODE NO.',I6,' (GLOBAL NODE NO. ',
     *           I6,' AND OF INTERNAL BARRIER TYPE) ',/,
     *           2X,'THE INTERNAL BARRIER HEIGHT = ',E12.5,
     *           2X,'IS EXCEEDED BY THE DEPTH SPECIFIED AT ',/,2X
     *           ,'THE ASSOCIATED GLOBAL NODE = ',E12.5,/,2X,
     *           'USER MUST SPECIFY CONSISTENT BARRIER HEIGHTS',
     *           ' AND DEPTHS')
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
                     WRITE(16,9973)
                     STOP
                  ENDIF
               ENDIF
                        
C...........CHECK INTERNAL BARRIER WITH PIPES BARRIER HEIGHTS AGAINST DEPTHS
               IF((IBTYPE.EQ.5).OR.(IBTYPE.EQ.25)) THEN
                  IF(BARINHT(JGW).LT.-DP(NBV(JGW))) THEN
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,8370) 
     *                    JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
                     WRITE(16,8370) JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
 8370                FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!'
     *           ,'!!!!!!!!!',//,
     *           1X,'AT BOUNDARY NODE NO.',I6,' (GLOBAL NODE NO. ',
     *           I6,' AND OF INTERNAL BARRIER TYPE) ',/,
     *           2X,'THE INTERNAL BARRIER HEIGHT = ',E12.5,
     *           2X,'IS EXCEEDED BY THE DEPTH SPECIFIED AT ',/,2X
     *           ,'THE ASSOCIATED GLOBAL NODE = ',E12.5,/,2X,
     *           'USER MUST SPECIFY CONSISTENT BARRIER HEIGHTS',
     *           ' AND DEPTHS')
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
                     WRITE(16,9973)
                     STOP
                  ENDIF
               ENDIF
C...  CHECK INTERNAL BARRIER WITH PIPES PIPE HEIGHTS AGAINST DEPTHS
               IF((IBTYPE.EQ.5).OR.(IBTYPE.EQ.25)) THEN
                  IF(PIPEHT(JGW).LT.-DP(NBV(JGW))) THEN
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,8372) 
     *                    JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
                     WRITE(16,8372) JGW,NBV(JGW),BARINHT(JGW),DP(NBV(JGW))
 8372                FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!'
     *           ,'!!!!!!!!!',//,
     *           1X,'AT BOUNDARY NODE NO.',I6,' (GLOBAL NODE NO. ',
     *           I6,' AND OF INTERNAL BARRIER TYPE) ',/,
     *           2X,'THE BARRIER PIPE HEIGHT = ',E12.5,
     *           2X,'IS EXCEEDED BY THE DEPTH SPECIFIED AT ',/,2X
     *           ,'THE ASSOCIATED GLOBAL NODE = ',E12.5,/,2X,
     *           'USER MUST SPECIFY CONSISTENT PIPE HEIGHTS',
     *           ' AND DEPTHS')
                     IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
                     WRITE(16,9973)
                     STOP
                  ENDIF
               ENDIF

C...  CHECK FOR OVERLAPPING OF AN INTERNAL BARRIER BOUNDARY WITH
C...  ANY EXTERNAL BARRIER BOUNDARY. IF THIS DOES OCCUR, TAKE
C...  APPROPRIATE ACTION
               IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24).OR.(IBTYPE.EQ.5)
     *              .OR.(IBTYPE.EQ.25)) THEN
                  DO ICK=1,NVELEXT
C...  CHECK IF OVERLAP EXISTS
                     IF(NBV(ICK).EQ.NBV(JGW)) THEN
C...  CHECK FOR ILLEGAL OVERLAPS
                        IF((LBCODEI(ICK).EQ.2).OR.(LBCODEI(ICK).EQ.3).OR.
     *                       (LBCODEI(ICK).EQ.12).OR.(LBCODEI(ICK).EQ.13)) THEN 
                           IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,8567) 
     *                          JGW,NBV(JGW),ICK,NBV(ICK)
                           WRITE(16,8567) JGW,NBV(JGW),ICK,NBV(ICK)
 8567                      FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!'
     *               ,'!!!!!!!!!',//,
     *               1X,'BOUNDARY NODE NO. ',I6,' (GLOBAL NODE NO. ',
     *               I9, 'AND OF INTERNAL BARRIER TYPE) ',/,
     *               2X,'OVERLAPS BOUNDARY NODE NO.',I6,' (GLOBAL NODE'
     *               ,' NO.',I6,' )',/,
     *               2X,'THIS IS AN ILLEGAL TYPE OVERLAP !! - INTERNAL '
     *               ,'BARRIER BOUNDARIES CAN ONLY OVERLAP WITH ',
     *               'NO NORMAL FLOW EXTERNAL BOUNDARIES',/
     *               2X,'(I.E. IBTYPE=0,10,20)')
                           IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
                           WRITE(16,9973)
                           STOP
                        ENDIF
C...  CHECK FOR OVERLAPS WHICH REQUIRE ADJUSTMENTS OF BOUNDARY
C...  CODE ON THE EXTERNAL BOUNDARY
                        IF(((IBTYPE.EQ.4).AND.(LBCODEI(ICK).EQ.0))
     *                       .OR.((IBTYPE.EQ.5).AND.(LBCODEI(ICK).EQ.0))) THEN
                           WRITE(16,8568) JGW,ICK,ICK
 8568                      FORMAT(1X,'DUE TO LEGAL OVERLAPPING OF ',
     *               'BOUNDARY NODE',I7,' (WHICH IS AN ESSENTIAL INTER'
     *               ,'NAL BARRIER BOUNDARY NODE)', /,2X,
     *               'AND BOUNDARY NODE',I7,' (WHICH IS AN ESSENTIAL ',
     *               'EXTERNAL NO NORMAL FLOW WITH SLIP BOUNDARY',
     *               ' NODE),',/,2X,
     *               'THE BOUNDARY TYPE FOR BOUNDARY NODE ',I7,
     *               ' IS BEING RESET TO IBTYPE=20',/,2X,
     *               '(NATURAL NO NORMAL FLOW WITH SLIP BOUNDARY) ')
                           LBCODEI(ICK)=20
                        ENDIF
                        IF(((IBTYPE.EQ.4).AND.(LBCODEI(ICK).EQ.10)) 
     *                       .OR.((IBTYPE.EQ.5).AND.(LBCODEI(ICK).EQ.10))) THEN
                           WRITE(16,8569) JGW,ICK,ICK
 8569                      FORMAT(1X,'DUE TO LEGAL OVERLAPPING OF ',
     *               'BOUNDARY NODE ',I7,' (WHICH IS AN ESSENTIAL INTER'
     *               ,'NAL BARRIER BOUNDARY NODE)', /,2X,
     *               'AND BOUNDARY NODE',I7,' (WHICH IS AN ESSENTIAL ',
     *               'EXTERNAL NO NORMAL FLOW WITH NO SLIP BOUNDARY',
     *               ' NODE),',/,2X,
     *               'THE BOUNDARY TYPE FOR BOUNDARY NODE ',I7,
     *               ' IS BEING RESET TO IBTYPE=20',/,2X,
     *               '(NATURAL NO NORMAL FLOW WITH SLIP BOUNDARY) ')
                           LBCODEI(ICK)=20
                        ENDIF
                        IF(((IBTYPE.EQ.24).AND.(LBCODEI(ICK).EQ.10))  
     *                       .OR.((IBTYPE.EQ.25).AND.(LBCODEI(ICK).EQ.10))) THEN
                           WRITE(16,8570) JGW,ICK,ICK
 8570                      FORMAT(1X,'DUE TO LEGAL OVERLAPPING OF ',
     *               'BOUNDARY NODE',I7,' (WHICH IS A NATURAL INTERNAL'
     *               ,' BARRIER BOUNDARY NODE)', /,2X,
     *                   'AND BOUNDARY NODE',I7,' (WHICH IS AN ESSENTIAL ',
     *                   'EXTERNAL NO NORMAL FLOW WITH NO SLIP BOUNDARY',
     *                   ' NODE),',/,2X,
     *                   'THE BOUNDARY TYPE FOR BOUNDARY NODE',I7,
     *                   ' IS BEING RESET TO IBTYPE=0',/,2X,
     *                   '(ESSENTIAL NO NORMAL FLOW WITH SLIP BOUNDARY) ')
                           LBCODEI(ICK)=0
                        ENDIF
                     ENDIF
                  END DO
               ENDIF
               
            END DO
         END DO
      END DO

C...  ONCE ALL FLOW BOUNDARY NODES HAVE BEEN PROCESSED, CHECK TO MAKE
C...  SURE THAT JGW LE MNVEL.  NOTE, JME MUST BE < JGW.

      IF(MNVEL.LT.JGW) THEN
        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9947)
        WRITE(16,9947)
 9947   FORMAT(////,1X,'!!!!!!!!!!  FATAL INPUT ERROR   !!!!!!!!!!!!',
     *    //,1X,'THE DIMENSION PARAMETER MNVEL IS LESS THAN ',
     *          'THE TOTAL NUMBER OF FLOW BOUNDARY NODES',
     *    /,1X,'FROM ALL THE SPECIFIED FLOW SEGMENTS COMBINED',/)
        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
          WRITE(16,9973)
          STOP
        ENDIF

      NVEL=JGW
      NVELME=JME

C
      DO IK=1,MNP   ! FINISH DET. MAX # NEIGHBORS
        IF(NNEIGH(IK).GT.MNEI) MNEI=NNEIGH(IK)
        ENDDO
      MNEI = MNEI+1

C.....TRANSFER FLOW BOUNDARY INFORMATION INTO NODAL ARRAYS
 
C     jgf this is how it is done in v36.02
C      DO I=1,NP
C         LBArray_Pointer(I)=0
C         CSI(I)=0.
C         SII(I)=1.
C      END DO
C
C#ifdef 1
C      DO I=1,NVELME
C         J=ME2GW(I)
C         LBArray_Pointer(NBV(J))=J
C         CSI(NBV(J))=CSII(J)
C         SII(NBV(J))=SIII(J)
C      END DO
C#else 
C      DO I=1,NVELME
C         J=ME2GW(I)
C         LBArray_Pointer(NBV(J))=LBCODEI(J)
C         CSI(NBV(J))=CSII(J)
C         SII(NBV(J))=SIII(J)
C      END DO
C#endif

      DO I=1,NP
         LBArray_Pointer(I)=-1
         CSI(I)=0.
         SII(I)=1.
      END DO


      DO I=1,NVELME
         J=ME2GW(I)
         LBArray_Pointer(NBV(J))=J
         CSI(NBV(J))=CSII(J)
         SII(NBV(J))=SIII(J)
      END DO


C...IF ANY NON ZERO NORMAL FLOW BOUNDARIES WERE SPECIFIED, (NFLUXF=1)
C.....READ FORCING INFORMATION FROM UNIT 15 FILE

      NFFR = 0
      IF(NFLUXF.EQ.1) THEN

C.....INPUT FROM THE NUMBER OF FREQUENCIES PRESENT IN NORMAL FLOW FORCING
C......DATA.  IF THIS = 0, NORMAL FLOW DATA IS READ IN FROM THE FORT.20 FILE.

        READ(15,*) NFFR
        MNFFR = NFFR
        IF (NFFR.EQ.0) MNFFR = 1

C.....Allocate space for periodic normal flow boundary conditions
        call alloc_main6()
C
        DO I=1,NVELME
          J=ME2GW(I)
          QNAM(1,J)=0.
          QNPH(1,J)=0.
          END DO

C.....READ IN AND WRITE OUT INFO ON SPECIFIED NORMAL FLOW BOUNDARIES

        WRITE(16,1112)
        WRITE(16,2200)
 2200   FORMAT(//,1X,'NORMAL FLOW BOUNDARY FORCING INFORMATION ',//)
        IF(NFFR.EQ.0) THEN
          WRITE(16,2201)
 2201     FORMAT(/,5X,'NORMAL FLOW VALUES WILL BE READ FROM UNIT 20 ',
     *    /,9X,'INTERPOLATION IN TIME IS DONE TO SYNC THE FLOW DATA ',
     *    /,9X,'WITH THE MODEL TIME STEP.')
          ENDIF
        IF(NFFR.NE.0) THEN
          WRITE(16,2202) NFFR
 2202     FORMAT(/,5X,'NUMBER OF PERIODIC NORMAL FLOW CONSTITUENTS =',
     *                                                               I5)
          WRITE(16,2203)
 2203     FORMAT(/,7X,'CONSTITUENT #',4X,'FREQUENCY',4X,'NODAL FACTOR',
     *         3X,'EQU.ARG (DEG)',2X,'CONSTITUENT',/)
          DO I=1,NFFR
            READ(15,'(A5)') FBOUNTAG(I)
            READ(15,*) FAMIG(I),FFF(I),FFACE(I)
            WRITE(16,2204) I,FAMIG(I),FFF(I),FFACE(I),FBOUNTAG(I)
 2204       FORMAT(12X,I2,6X,F16.12,2X,F10.7,2X,F10.3,10X,A5)
            FFACE(I)=FFACE(I)*DEG2RAD
            IF(FAMIG(I).EQ.0.) THEN
              FPER(I)=0.
              ELSE
              FPER(I)=2.D0*PI/FAMIG(I)
              ENDIF
            END DO

C.......INPUT PERIODIC NORMAL FLOW FORCING CONDITIONS ON DESIGNATED FLOW BOUNDARIES
C........FOR EACH OF THE FORCING FREQUENCIES FROM UNIT 15 AND OUTPUT TO UNIT 16

          DO I=1,NFFR
            WRITE(16,2206) I,FBOUNTAG(I)
 2206       FORMAT(////,5X,'PERIODIC NORMAL FLOW CONSTITUENT ',
     *                     'NUMBER',I4,1X,'DESIGNATED : ',A5)
            READ(15,'(A10)') ALPHA
            WRITE(16,31) ALPHA
            WRITE(16,30)
            DO J=1,NVEL
              IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                             .OR.(LBCODEI(J).EQ.22)) THEN
                READ(15,*) QNAM(I,J),QNPH(I,J)
                WRITE(16,2205) NBV(J),QNAM(I,J),QNPH(I,J)
 2205           FORMAT(10X,I8,4X,F14.5,4X,F12.3)
                QNPH(I,J)=QNPH(I,J)*DEG2RAD
                ENDIF
              END DO
            END DO
          ENDIF
        ENDIF

C...IF ANY EXTERNAL BARRIER BOUNDARIES WERE SPECIFIED, (NFLUXB=1)
C.....WRITE OUT EXTERNAL BARRIER BOUNDARY INFORMATION TO UNIT 16 FILE
C.....NOTE THAT THIS INFORMATION WAS READ IN FROM THE UNIT 14 FILE

      IF(NFLUXB.EQ.1) THEN

C.....WRITE OUT INFO ON SPECIFIED EXTERNAL BARRIER BOUNDARIES

        WRITE(16,1112)
        WRITE(16,2220)
 2220   FORMAT(//,1X,'EXTERNAL BARRIER BOUNDARY INFORMATION ',/)

C.......OUTPUT ELEVATION OF EXTERNAL BARRIER NODES ABOVE THE GEOID AND
C........THE COEFFICIENT OF FREE SURFACE SUPERCRITICAL FLOW AT
C........DESIGNATED EXTERNAL BARRIER BOUNDARY NODES TO UNIT 16
        WRITE(16,2224)
 2224   FORMAT(//,9X,'NODE',10X,'BARRIER HEIGHT',
     *                     6X,'SUPER-CRIT. EXTERNAL BAR. COEF.',/)
        DO J=1,NVEL
          IF((LBCODEI(J).EQ.3).OR.(LBCODEI(J).EQ.13)
     *       .OR.(LBCODEI(J).EQ.23)) THEN
            WRITE(16,2225) NBV(J),BARLANHT(J),BARLANCFSP(J)
 2225       FORMAT(5X,I8,6X,F14.5,15X,F12.3)
          ENDIF
        END DO
      ENDIF

C...IF ANY INTERNAL BARRIER BOUNDARIES WERE SPECIFIED, (NFLUXIB=1)
C.....WRITE INTERNAL BARRIER BOUNDARY INFORMATION TO UNIT 16 FILE

      IF(NFLUXIB.EQ.1) THEN

C.....WRITE OUT INFO ON SPECIFIED INTERNAL BARRIER BOUNDARIES

        WRITE(16,1112)
        WRITE(16,2320)
 2320   FORMAT(//,1X,'INTERNAL BARRIER BOUNDARY INFORMATION ',/)

C.......WRITE CONNECTION NODE NUMBER AND ELEVATION OF THE INTERNAL BARRIER
C........NODES ABOVE THE GEOID AND THE COEFFICIENTS OF FREE SURFACE SUPERCRITICAL
C........AND SUBCRITICAL FLOW AT DESIGNATED INTERNAL BARRIER BOUNDARY NODES
C........TO UNIT 16 (NOTE THAT THIS INFORMATION WAS INPUT FROM THE UNIT 14
C........FILE WITH BOUNDARY NODE INFORMATION)
        WRITE(16,2324)
 2324   FORMAT(//,9X,'NODE',6X,'CONNECTED NODE',6X,'BARRIER HEIGHT',
     *                4X,'SUB-CRIT. INT. BAR. COEF.',
     *                4X,'SUPER-CRIT. INT. BAR. COEF.',/)
        DO J=1,NVEL
          IF((LBCODEI(J).EQ.4).OR.(LBCODEI(J).EQ.24)) THEN
            WRITE(16,2325) NBV(J),IBCONN(J),BARINHT(J),
     *                     BARINCFSB(J),BARINCFSP(J)
 2325       FORMAT(5X,I8,7X,I8,6X,F14.5,12X,F12.3,17X,F12.3)
          ENDIF
       END DO
      ENDIF

cjjwm001 - begin add                        
C...IF ANY INTERNAL BARRIER BOUNDARIES WITH CROSS BARRIER PIPES
C.....WERE SPECIFIED, (NFLUXIBP=1)
C.....WRITE INTERNAL BARRIER BOUNDARY INFORMATION WITH CROSS 
C.....BARRIER PIPE INFORMATION TO UNIT 16 FILE

      IF(NFLUXIBP.EQ.1) THEN

C.....WRITE OUT INFO ON SPECIFIED INTERNAL BARRIER BOUNDARIES

        WRITE(16,1112)
        WRITE(16,2326)
 2326   FORMAT(//,1X,'INTERNAL BARRIER BOUNDARY WITH CROSS BARRIER',
     *   ' PIPE INFORMATION ',/)

C.......WRITE CONNECTION NODE NUMBER AND ELEVATION OF THE INTERNAL BARRIER
C........NODES ABOVE THE GEOID AND THE COEFFICIENTS OF FREE SURFACE SUPERCRITICAL
C........AND SUBCRITICAL FLOW AT DESIGNATED INTERNAL BARRIER BOUNDARY NODES
C........IN ADDITION TO CROSS BARRIER PIPE CROWN HEIGHT, CROSS BARRIER PIPE
C........COEFFICIENT AND CROSS BARRIER PIPE DIAMETER TO UNIT 16
C........(NOTE THAT THIS INFORMATION WAS INPUT FROM THE UNIT 14 FILE WITH 
C........BOUNDARY NODE INFORMATION)
        WRITE(16,2327)
 2327   FORMAT(//,7X,'NODE',4X,'CONNECTED NODE',4X,'BARRIER HEIGHT',
     *                4X,'SUB-CRIT INT BAR COEF',
     *                4X,'SUPER-CRIT INT BAR COEF',
     *                4X,'PIPEHT  ',
     *                4X,'PIPECOEF',
     *                4X,'PIPEDIAM',/)
        DO J=1,NVEL
          IF((LBCODEI(J).EQ.5).OR.(LBCODEI(J).EQ.25)) THEN
            WRITE(16,2328) NBV(J),IBCONN(J),BARINHT(J),
     *                     BARINCFSB(J),BARINCFSP(J),
     *                     PIPEHT(J),PIPECOEF(J),PIPEDIAM(J)
 2328       FORMAT(3X,I8,5X,I8,4X,F14.5,8X,F12.3,12X,F12.3,
     *              2X,F10.5,2X,F10.5,2X,F10.5)
          ENDIF
       END DO
      ENDIF
cjjwm001 - end add                        

C...
C...READ IN INFORMATION CONCERNING OUTPUT REQUIREMENTS FROM UNIT 15 AND
C...OUTPUT THIS TO UNIT 16
C...
      WRITE(16,1112)
      WRITE(16,3000)
3000  FORMAT(//,1X,'OUTPUT INFORMATION WILL BE PROVIDED AS'
     *  ,' FOLLOWS :')

C...
C...INPUT INFORMATION FOR ELEVATION RECORDING STATIONS
C...

C....READ IN NOUTE,TOUTSE,TOUTFE,NSPOOLE : IF ABS(NOUTE)>0, INTERPOLATED
C....ELEVATIONS AT ELEVATION STATIONS ARE SPOOLED TO UNIT 61 EVERY NSPOOLE
C....TIME STEPS BETWEEN TIMES TOUTSE AND TOUTFE

      READ(15,*) NOUTE,TOUTSE,TOUTFE,NSPOOLE
      WRITE(16,3001) NOUTE
 3001 FORMAT(///,1X,'ELEVATION RECORDING STATION OUTPUT : ',
     *        //,5X,'NOUTE = ',I2)

C....CHECK INPUT PARAMETER NOUTE

      IF(ABS(NOUTE).GT.2) THEN
        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3002)
        WRITE(16,3002)
 3002   FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *                 ' NOUTE',
     *            /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
        WRITE(16,9973)
        STOP
        ENDIF

C....IF STATION ELEVATION OUTPUT WILL NOT BE GENERATED

      IF(NOUTE.EQ.0) THEN
        WRITE(16,3003)
 3003   FORMAT(/,5X,'NO OUTPUT WILL BE SPOOLED AT ELEVATION ',
     *              'RECORDING STATIONS')
        ENDIF

C....IF STATION ELEVATION OUTPUT WILL BE GENERATED

      IF(NOUTE.NE.0) THEN

C......COMPUTE NTCYSE, NTCYFE, WHICH = TOUTSE AND TOUTFE IN TIMESTEPS

        NTCYSE=INT((TOUTSE-STATIM)*(86400.D0/DTDP)+0.5d0)
        NTCYFE=INT((TOUTFE-STATIM)*(86400.D0/DTDP)+0.5d0)
        IF(NTCYFE.GT.NT) NTCYFE=NT

C......COMPUTE NTRSPE = THE NO. OF DATA SETS TO BE SPOOLED TO UNIT 61

        IF(NSPOOLE.EQ.0) NTRSPE=0
        IF(NSPOOLE.NE.0) NTRSPE=INT((NTCYFE-NTCYSE)/NSPOOLE)

C......WRITE TOUTSE,TOUTFE,NTCYSE,NTCYFE,NSPOOLE TO UNIT 16

        WRITE(16,3004) TOUTSE,NTCYSE,TOUTFE,NTCYFE,NSPOOLE
 3004   FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSE =',F8.3,
     *              ' DAY(S) RELATIVE',
     *         /,9X,'TO THE STARTING TIME OR',I9,
     *              ' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'DATA RECORDS WILL STOP AFTER TOUTFE =',F8.3,
     *              ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 61 EVERY',
     *              ' NSPOOLE =',I8,' TIME STEPS')
        IF(ABS(NOUTE).EQ.1) WRITE(16,3005)
 3005   FORMAT(/,5X,'UNIT 61 FORMAT WILL BE ASCII')
        IF(ABS(NOUTE).EQ.2) WRITE(16,3006)
 3006   FORMAT(/,5X,'UNIT 61 FORMAT WILL BE BINARY')
        ENDIF

C....REGARDLESS OF WHETHER NOUTE=0, READ IN THE NUMBER OF ELEVATION
C....RECORDING STATIONS

      READ(15,*) NSTAE
      WRITE(16,3007) NSTAE
 3007 FORMAT(///,5X,'NUMBER OF INPUT ELEVATION RECORDING STATIONS = ',
     *              I5)

      IF(NSTAE.GT.0) THEN
        IF(ICS.EQ.1) WRITE(16,3008)
 3008   FORMAT(/,7X,'STATION #   ELEMENT',9X,'X',13X,'Y',/)
        IF(ICS.EQ.2) WRITE(16,3009)
 3009   FORMAT(/,5X,'STATION   ELEMENT',3X,'LAMBDA(DEG)',
     *           4X,'FEA(DEG)',10X,'XCP',12X,'YCP',/)
        MNSTAE = NSTAE
      ENDIF
      IF (NSTAE.EQ.0) MNSTAE = 1

C  Allocate arrays dimensioned by MNSTAE
       call alloc_main7()


C....INPUT COORDINATES OF ELEVATION RECORDING STATIONS THEN COMPUTE
C....THE ELEMENT NO. THE STATION LIES IN

      DO I=1,NSTAE
        NNE(I)=0
        IF(ICS.EQ.1) THEN
          READ(15,*) XEL(I),YEL(I)
          ELSE
          READ(15,*) SLEL(I),SFEL(I)
          SLEL(I)=SLEL(I)*DEG2RAD
          SFEL(I)=SFEL(I)*DEG2RAD
          CALL CPP(XEL(I),YEL(I),SLEL(I),SFEL(I),SLAM0,SFEA0)
        ENDIF
        AEMIN=1.0E+25
        KMIN=0
        DO K=1,NE
          N1=NM(K,1)
          N2=NM(K,2)
          N3=NM(K,3)
          X1=X(N1)
          X2=X(N2)
          X3=X(N3)
          X4=XEL(I)
          Y1=Y(N1)
          Y2=Y(N2)
          Y3=Y(N3)
          Y4=YEL(I)
          A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
          A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
          A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
          AA=ABS(A1)+ABS(A2)+ABS(A3)
          AE=ABS(AA-AREAS(K))/AREAS(K)
          IF(AE.LT.AEMIN) THEN
            AEMIN=AE
            KMIN=K
            ENDIF
          IF(AE.LT.1.0E-5) NNE(I)=K
          END DO

        IF(NNE(I).EQ.0) THEN
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9784) I
          WRITE(16,9784) I
9784      FORMAT(///,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *                  'INPUT ERROR  !!!!!!!!!',//
     *            ,1X,'ELEVATION RECORDING STATION ',I6,' DOES NOT LIE',
     *                ' WITHIN ANY ELEMENT IN THE DEFINED',
     *           /,1X,'COMPUTATIONAL DOMAIN,   PLEASE CHECK THE INPUT',
     *                ' COORDINATES FOR THIS STATION')
          IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9790) AEMIN
            WRITE(16,9790) AEMIN
9790        FORMAT(/,1X,'PROGRAM WILL ESTIMATE NEAREST ELEMENT',
     *            /,1X,'PROXIMITY INDEX FOR THIS STATION EQUALS ',E15.6,
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NNE(I)=KMIN
            ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9791) AEMIN
            WRITE(16,9791) AEMIN
9791        FORMAT(/,1X,'PROGRAM WILL NOT CORRECT ERROR ',
     *                  'SINCE NON-FATAL ERROR OVERIDE OPTION, NFOVER,',
     *            /,1X,'HAS BEEN SELECTED EQUAL TO 0',
     *            /,1X,'PROXIMITY INDEX FOR THIS STATION EQUALS ',E15.6,
     *           //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',
     *           //)
            STOP
            ENDIF
          ENDIF

        IF(ICS.EQ.1) THEN
          WRITE(16,1880) I,NNE(I),XEL(I),YEL(I)
1880      FORMAT(8X,I3,6X,I7,2(2X,F14.2))
          ELSE
          WRITE(16,1883) I,NNE(I),SLEL(I)*RAD2DEG,
     *                   SFEL(I)*RAD2DEG,XEL(I),YEL(I)
1883      FORMAT(6X,I3,4X,I7,2(2X,F13.8),2X,2(1X,F13.2))
          ENDIF

C....PRE-COMPUTE INFORMATION REQUIRED TO INTERPOLATE AT ELEV. RECORDING STATIONS

        N1=NM(NNE(I),1)
        N2=NM(NNE(I),2)
        N3=NM(NNE(I),3)
        X1=X(N1)
        X2=X(N2)
        X3=X(N3)
        X4=XEL(I)
        Y1=Y(N1)
        Y2=Y(N2)
        Y3=Y(N3)
        Y4=YEL(I)
        STAIE1(I)=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS(NNE(I))
        STAIE2(I)=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS(NNE(I))
        STAIE3(I)=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS(NNE(I))

        END DO

C...
C...INPUT INFORMATION FOR VELOCITY RECORDING STATIONS
C...

C....READ IN NOUTV,TOUTSV,TOUTFV,NSPOOLV : IF NOUTV<>0,INTERPOLATED VELOCITIES AT
C....VELOCITY STATIONS ARE SPOOLED TO UNIT 62 EVERY NSPOOLV TIME STEPS BETWEEN
C....TIMES TOUTSV AND TOUTFV; IF ABS(NOUTV)=2, OUTPUT WILL BE BINARY

      READ(15,*) NOUTV,TOUTSV,TOUTFV,NSPOOLV
      WRITE(16,3101) NOUTV
 3101 FORMAT(////,1X,'VELOCITY RECORDING STATION OUTPUT : ',
     *         //,5X,'NOUTV = ',I2)

C....CHECK INPUT PARAMETER NOUTV

      IF(ABS(NOUTV).GT.2) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3102)
        WRITE(16,3102)
 3102   FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *                 ' NOUTV',
     *            /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
        WRITE(16,9973)
        STOP
        ENDIF

C....IF STATION VELOCITY OUTPUT WILL NOT BE GENERATED

      IF(NOUTV.EQ.0) THEN
        WRITE(16,3103)
 3103   FORMAT(///,5X,'NO OUTPUT WILL BE SPOOLED AT VELOCITY',
     *                ' RECORDING STATIONS')
        ENDIF

C....IF STATION VELOCITY OUTPUT WILL BE GENERATED

      IF(NOUTV.NE.0) THEN

C......COMPUTE NTCYSV, NTCYFV, WHICH = TOUTSV AND TOUTFV IN TIME STEPS

        NTCYSV=INT((TOUTSV-STATIM)*(86400.D0/DTDP) + 0.5d0)
        NTCYFV=INT((TOUTFV-STATIM)*(86400.D0/DTDP) + 0.5d0)
        IF(NTCYFV.GT.NT) NTCYFV=NT

C......CALCULATE NTRSPV = THE NO. OF DATA SETS TO BE SPOOLED TO UNIT 62

        IF(NSPOOLV.EQ.0) NTRSPV=0
        IF(NSPOOLV.NE.0) NTRSPV=INT((NTCYFV-NTCYSV)/NSPOOLV)

C......WRITE NOUTV,TOUTSV,TOUTFV,NTCYSV,NTCYFV,NSPOOLV TO UNIT 16

        WRITE(16,3104) TOUTSV,NTCYSV,TOUTFV,NTCYFV,NSPOOLV
 3104   FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSV =',F8.3,
     *              ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'DATA RECORDS WILL STOP AFTER TOUTFV =',F8.3,
     *              ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 62 EVERY ',
     *              ' NSPOOLV =',I8,' TIME STEPS')
        IF(ABS(NOUTV).EQ.1) WRITE(16,3105)
 3105   FORMAT(/,5X,'UNIT 62 FORMAT WILL BE ASCII')
        IF(ABS(NOUTV).EQ.2) WRITE(16,3106)
 3106   FORMAT(/,5X,'UNIT 62 FORMAT WILL BE BINARY')
        ENDIF

C....REGARDLESS OF WHETHER NOUTV=0, READ IN THE NUMBER OF VELOCITY
C....RECORDING STATIONS

      READ(15,*) NSTAV
      WRITE(16,3107) NSTAV
 3107 FORMAT(////,5X,'NUMBER OF INPUT VELOCITY RECORDING STATIONS = ',
     *            I5)

      IF(NSTAV.GT.0) THEN
        IF(ICS.EQ.1) WRITE(16,3108)
 3108   FORMAT(/,7X,'STATION #   ELEMENT',9X,'X',13X,'Y',/)
        IF(ICS.EQ.2) WRITE(16,3109)
 3109   FORMAT(/,5X,'STATION   ELEMENT',3X,'LAMBDA(DEG)',
     *             4X,'FEA(DEG)',10X,'XCP',12X,'YCP',/)
        MNSTAV = NSTAV
      ENDIF
      IF (NSTAV.EQ.0) MNSTAV = 1

C  Allocate arrays dimensioned by MNSTAV
       call alloc_main8()

C....INPUT COORDINATES OF VELOCITY RECORDING STATIONS
C....THEN COMPUTE ELEMENT NO. WITHIN WHICH STATION LIES

      DO I=1,NSTAV
        NNV(I)=0
        IF(ICS.EQ.1) THEN
          READ(15,*) XEV(I),YEV(I)
          ELSE
          READ(15,*) SLEV(I),SFEV(I)
          SLEV(I)=SLEV(I)*DEG2RAD
          SFEV(I)=SFEV(I)*DEG2RAD
          CALL CPP(XEV(I),YEV(I),SLEV(I),SFEV(I),SLAM0,SFEA0)
          ENDIF
        AEMIN=1.0E+25
        KMIN=0
        DO K=1,NE
          N1=NM(K,1)
          N2=NM(K,2)
          N3=NM(K,3)
          X1=X(N1)
          X2=X(N2)
          X3=X(N3)
          X4=XEV(I)
          Y1=Y(N1)
          Y2=Y(N2)
          Y3=Y(N3)
          Y4=YEV(I)
          A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
          A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
          A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
          AA=ABS(A1)+ABS(A2)+ABS(A3)
          AE=ABS(AA-AREAS(K))/AREAS(K)
          IF(AE.LT.AEMIN) THEN
            AEMIN=AE
            KMIN=K
            ENDIF
          IF(AE.LT.1.0E-5) NNV(I)=K
          END DO

        IF(NNV(I).EQ.0) THEN
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9786) I
          WRITE(16,9786) I
9786      FORMAT(///,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *                  'INPUT ERROR  !!!!!!!!!',//
     *              ,1X,'VELOCITY RECORDING STATION ',I6,' DOES NOT LIE'
     *                 ,' WITHIN ANY ELEMENT IN THE DEFINED',
     *             /,1X,'COMPUTATIONAL DOMAIN,   PLEASE CHECK THE INPUT'
     *                 ,' COORDINATES FOR THIS STATION')
          IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9790) AEMIN
            WRITE(16,9790) AEMIN
            NNV(I)=KMIN
            ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9791) AEMIN
            WRITE(16,9791) AEMIN
            STOP
            ENDIF
          ENDIF

        IF(ICS.EQ.1) THEN
          WRITE(16,1880) I,NNV(I),XEV(I),YEV(I)
          ELSE
          WRITE(16,1883) I,NNV(I),SLEV(I)*RAD2DEG,SFEV(I)*RAD2DEG,
     *                   XEV(I),YEV(I)
          ENDIF

C....PRE-COMPUTE INFORMATION REQUIRED TO INTERPOLATE AT VEL. RECORDING STATIONS

        N1=NM(NNV(I),1)
        N2=NM(NNV(I),2)
        N3=NM(NNV(I),3)
        X1=X(N1)
        X2=X(N2)
        X3=X(N3)
        X4=XEV(I)
        Y1=Y(N1)
        Y2=Y(N2)
        Y3=Y(N3)
        Y4=YEV(I)
        STAIV1(I)=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS(NNV(I))
        STAIV2(I)=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS(NNV(I))
        STAIV3(I)=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS(NNV(I))

      END DO

C...
C...  IF TRANSPORT IS INCLUDED IN THE RUN, INPUT INFORMATION FOR CONCENTRATION
C...  RECORDING STATIONS
C...
      NOUTC=0
      IF(IM.EQ.10) THEN

C...  READ IN NOUTC,TOUTSC,TOUTFC,NSPOOLC : IF NOUTC<>0,INTERPOLATED
C...  CONCENTRATIONS ARE SPOOLED TO UNIT 81 EVERY NSPOOLC TIME STEPS
C...  BETWEEN TIMES TOUTSC AND TOUTFC; IF ABS(NOUTC)=2, OUTPUT WILL BE BINARY

         READ(15,*) NOUTC,TOUTSC,TOUTFC,NSPOOLC
         WRITE(16,3201) NOUTC
 3201    FORMAT(///,1X,'CONCENTRATION RECORDING STATION OUTPUT : ',
     *          //,5X,'NOUTC = ',I2)
         
C...  CHECK INPUT PARAMETER NOUTC

         IF(ABS(NOUTC).GT.2) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3202)
            WRITE(16,3202)
 3202       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *           ' NOUTC',
     *           /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF

C...  IF STATION CONCENTRATION OUTPUT WILL NOT BE GENERATED

         IF(NOUTC.EQ.0) THEN
            WRITE(16,3203)
 3203       FORMAT(/,5X,'NO OUTPUT WILL BE SPOOLED AT CONCENTRATION',
     *           ' RECORDING STATIONS')
         ENDIF
         
C...  IF STATION CONCENTRATION OUTPUT WILL BE GENERATED

         NSTAC = 0
         IF(NOUTC.NE.0) THEN
            
C...  COMPUTE NTCYSC, NTCYFC, WHICH = TOUTSC AND TOUTFC IN TIMESTEPS

            NTCYSC=INT((TOUTSC-STATIM)*(86400.D0/DTDP) + 0.5d0)
            NTCYFC=INT((TOUTFC-STATIM)*(86400.D0/DTDP) + 0.5d0)
            IF(NTCYFC.GT.NT) NTCYFC=NT

C...  COMPUTE NTRSPC = THE NO. OF DATA SETS TO BE SPOOLED TO UNIT 81
            
            IF(NSPOOLC.EQ.0) NTRSPC=0
            IF(NSPOOLC.NE.0) NTRSPC=INT((NTCYFC-NTCYSC)/NSPOOLC)

C...  WRITE TOUTSC,TOUTFC,NTCYSC,NTCYFC,NSPOOLC TO UNIT 16

            WRITE(16,3204) TOUTSC,NTCYSC,TOUTFC,NTCYFC,NSPOOLC
 3204       FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSC =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'DATA RECORDS WILL STOP AFTER TOUTFC =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 81 EVERY',
     *                ' NSPOOLC =',I8,' TIME STEPS')
            IF(ABS(NOUTC).EQ.1) WRITE(16,3205)
 3205       FORMAT(/,5X,'UNIT 81 FORMAT WILL BE ASCII')
            IF(ABS(NOUTC).EQ.2) WRITE(16,3206)
 3206       FORMAT(/,5X,'UNIT 81 FORMAT WILL BE BINARY')
         ENDIF

C...  REGARDLESS OF WHETHER NOUTC=0, READ IN THE NUMBER OF CONCENTRATION
C...  RECORDING STATIONS

         READ(15,*) NSTAC
         WRITE(16,3207) NSTAC
 3207    FORMAT(///,5X,'NUMBER OF INPUT CONCENTRATION RECORDING ',
     *        'STATIONS = ',I5)

         IF(NSTAC.GT.0) THEN
            IF(ICS.EQ.1) WRITE(16,3208)
 3208       FORMAT(/,7X,'STATION #   ELEMENT',9X,'X',13X,'Y',/)
            IF(ICS.EQ.2) WRITE(16,3209)
 3209       FORMAT(/,5X,'STATION   ELEMENT',3X,'LAMBDA(DEG)',
     *           4X,'FEA(DEG)',10X,'XCP',12X,'YCP',/)
            MNSTAC = NSTAC
         ENDIF
        
C  Allocate arrays dimensioned by MNSTAC
         call alloc_main9()

C...  INPUT COORDINATES OF CONCENTRATION RECORDING STATIONS
C...  THEN COMPUTE ELEMENT NO. WITHIN WHICH STATION LIES

         DO I=1,NSTAC
            NNC(I)=0
            IF(ICS.EQ.1) THEN
               READ(15,*) XEC(I),YEC(I)
            ELSE
               READ(15,*) SLEC(I),SFEC(I)
               SLEC(I)=SLEC(I)*DEG2RAD
               SFEC(I)=SFEC(I)*DEG2RAD
               CALL CPP(XEC(I),YEC(I),SLEC(I),SFEC(I),SLAM0,SFEA0)
            ENDIF
            AEMIN=1.0E+25
            KMIN=0
            DO K=1,NE
               N1=NM(K,1)
               N2=NM(K,2)
               N3=NM(K,3)
               X1=X(N1)
               X2=X(N2)
               X3=X(N3)
               X4=XEC(I)
               Y1=Y(N1)
               Y2=Y(N2)
               Y3=Y(N3)
               Y4=YEC(I)
               A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
               A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
               A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
               AA=ABS(A1)+ABS(A2)+ABS(A3)
               AE=ABS(AA-AREAS(K))/AREAS(K)
               IF(AE.LT.AEMIN) THEN
                  AEMIN=AE
                  KMIN=K
               ENDIF
               IF(AE.LT.1.0E-5) NNC(I)=K
            END DO

            IF(NNC(I).EQ.0) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9785) I
               WRITE(16,9785) I
 9785          FORMAT(///,1X,'!!!!!!!!!!  WARNING - NONFATAL INPUT ERROR ',
     *              '!!!!!!!!!',//,
     *              ' CONCENTRATION RECORDING STATION ',I6,' DOES NOT LIE'
     *              ,' WITHIN ANY ELEMENT IN THE DEFINED',/,
     *              ' COMPUTATIONAL DOMAIN,   PLEASE CHECK THE INPUT',
     *              ' COORDINATES FOR THIS STATION')
               IF(NFOVER.EQ.1) THEN
                  IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9790) AEMIN
                  WRITE(16,9790) AEMIN
                  NNC(I)=KMIN
               ELSE
                  IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9791) AEMIN
                  WRITE(16,9791) AEMIN
                  STOP
               ENDIF
            ENDIF

            IF(ICS.EQ.1) THEN
               WRITE(16,1880) I,NNC(I),XEC(I),YEC(I)
            ELSE
               WRITE(16,1883) I,NNC(I),SLEC(I)*RAD2DEG,
     *              SFEC(I)*RAD2DEG,XEC(I),YEC(I)
            ENDIF

C...  PRE-COMPUTE INFORMATION REQUIRED TO INTERPOLATE AT CONCENTRATION
C...  RECORDING STATIONS

            N1=NM(NNC(I),1)
            N2=NM(NNC(I),2)
            N3=NM(NNC(I),3)
            X1=X(N1)
            X2=X(N2)
            X3=X(N3)
            X4=XEL(I)
            Y1=Y(N1)
            Y2=Y(N2)
            Y3=Y(N3)
            Y4=YEL(I)
            STAIC1(I)=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS(NNC(I))
            STAIC2(I)=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS(NNC(I))
            STAIC3(I)=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS(NNC(I))
            
         END DO
      ENDIF
      IF (NSTAC.EQ.0) MNSTAC = 1
C...  
C...  IF METEOROLOICAL FORCING IS INCLUDED IN THE RUN, INPUT
C...  INFORMATION FOR MET RECORDING STATIONS - OUTPUT
C...  
      NOUTM=0
      NSTAM = 0
C
      IF(NWS.NE.0) THEN

C...  READ IN NOUTM,TOUTSM,TOUTFM,NSPOOLM : IF NOUTM<>0,INTERPOLATED
C...  MET DATA ARE SPOOLED TO UNITS 71&72 EVERY NSPOOLM TIME STEPS
C...  BETWEEN TIMES TOUTSM AND TOUTFM; IF ABS(NOUTM)=2, OUTPUT WILL BE BINARY

         READ(15,*) NOUTM,TOUTSM,TOUTFM,NSPOOLM
         WRITE(16,3211) NOUTM
 3211    FORMAT(///,1X,'METEOROLOGICAL RECORDING STATION OUTPUT : ',
     *        //,5X,'NOUTM = ',I2)

C...  CHECK INPUT PARAMETER NOUTM

         IF(ABS(NOUTM).GT.2) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3212)
            WRITE(16,3202)
 3212       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *           ' NOUTC',
     *           /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF

C...  IF STATION METEOROLOGICAL OUTPUT WILL NOT BE GENERATED
         
         IF(NOUTM.EQ.0) THEN
            WRITE(16,3213)
 3213       FORMAT(/,5X,'NO OUTPUT WILL BE SPOOLED AT METEOROLOGICAL',
     *           ' RECORDING STATIONS')
         ENDIF
         
C...  IF STATION MET OUTPUT WILL BE GENERATED

         IF(NOUTM.NE.0) THEN

C...  COMPUTE NTCYSM, NTCYFM, WHICH = TOUTSM AND TOUTFM IN TIMESTEPS

            NTCYSM=INT((TOUTSM-STATIM)*(86400.D0/DTDP) + 0.5d0)
            NTCYFM=INT((TOUTFM-STATIM)*(86400.D0/DTDP) + 0.5d0)
            IF(NTCYFM.GT.NT) NTCYFM=NT

C...  COMPUTE NTRSPM = THE NO. OF DATA SETS TO BE SPOOLED TO UNITS 71&72
            
            IF(NSPOOLM.EQ.0) NTRSPM=0
            IF(NSPOOLM.NE.0) NTRSPM=INT((NTCYFM-NTCYSM)/NSPOOLM)

C...  WRITE TOUTSM,TOUTFM,NTCYSM,NTCYFM,NSPOOLM TO UNIT 16
            
            WRITE(16,3214) TOUTSM,NTCYSM,TOUTFM,NTCYFM,NSPOOLM
 3214       FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSM =',F8.3,
     *           ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *           //,5X,'DATA RECORDS WILL STOP AFTER TOUTFM =',F8.3,
     *           ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *           //,5X,'INFORMATION WILL BE SPOOLED TO UNITS 71&72',
     *           ' EVERY NSPOOLM =',I8,' TIME STEPS')
            IF(ABS(NOUTM).EQ.1) WRITE(16,3215)
 3215       FORMAT(/,5X,'UNITS 71&72 FORMAT WILL BE ASCII')
            IF(ABS(NOUTM).EQ.2) WRITE(16,3216)
 3216       FORMAT(/,5X,'UNITS 71&72 FORMAT WILL BE BINARY')
         ENDIF

C...  REGARDLESS OF WHETHER NOUTM=0, READ IN THE NUMBER OF METEOROLOGICAL
C...  RECORDING STATIONS

         READ(15,*) NSTAM
         WRITE(16,3217) NSTAM
 3217    FORMAT(///,5X,'NUMBER OF INPUT METEOROLOGICAL RECORDING ',
     *        'STATIONS = ',I5)
         
         IF(NSTAM.GT.0) THEN
            IF(ICS.EQ.1) WRITE(16,3218)
 3218       FORMAT(/,7X,'STATION #   ELEMENT',9X,'X',13X,'Y',/)
            IF(ICS.EQ.2) WRITE(16,3219)
 3219       FORMAT(/,5X,'STATION   ELEMENT',3X,'LAMBDA(DEG)',
     *           4X,'FEA(DEG)',10X,'XCP',12X,'YCP',/)
            MNSTAM = NSTAM
         ENDIF
         
C  Allocate arrays dimensioned by MNSTAM
         call alloc_main10()

C...  INPUT COORDINATES OF METEOROLOGICAL RECORDING STATIONS
C...  THEN COMPUTE ELEMENT NO. WITHIN WHICH STATION LIES

         DO I=1,NSTAM
            NNM(I)=0
            IF(ICS.EQ.1) THEN
               READ(15,*) XEM(I),YEM(I)
            ELSE
               READ(15,*) SLEM(I),SFEM(I)
               SLEM(I)=SLEM(I)*DEG2RAD
               SFEM(I)=SFEM(I)*DEG2RAD
               CALL CPP(XEM(I),YEM(I),SLEM(I),SFEM(I),SLAM0,SFEA0)
            ENDIF
            AEMIN=1.0E+25
            KMIN=0
            DO K=1,NE
               N1=NM(K,1)
               N2=NM(K,2)
               N3=NM(K,3)
               X1=X(N1)
               X2=X(N2)
               X3=X(N3)
               X4=XEM(I)
               Y1=Y(N1)
               Y2=Y(N2)
               Y3=Y(N3)
               Y4=YEM(I)
               A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
               A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
               A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
               AA=ABS(A1)+ABS(A2)+ABS(A3)
               AE=ABS(AA-AREAS(K))/AREAS(K)
               IF(AE.LT.AEMIN) THEN
                  AEMIN=AE
                  KMIN=K
               ENDIF
               IF(AE.LT.1.0E-5) NNM(I)=K
            END DO

            IF(NNM(I).EQ.0) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9942) I
               WRITE(16,9942) I
 9942          FORMAT(///,1X,'!!!!!!!!!!  WARNING - NONFATAL INPUT ERROR ',
     *              '!!!!!!!!!',//,
     *              ' METEOROLOGICAL RECORDING STATION ',I6,' DOES NOT LIE'
     *              ,' WITHIN ANY ELEMENT IN THE DEFINED',/,
     *              ' COMPUTATIONAL DOMAIN,   PLEASE CHECK THE INPUT',
     *              ' COORDINATES FOR THIS STATION')
               IF(NFOVER.EQ.1) THEN
                  IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9790) AEMIN
                  WRITE(16,9790) AEMIN
                  NNM(I)=KMIN
               ELSE
                  IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9791) AEMIN
                  WRITE(16,9791) AEMIN
                  STOP
               ENDIF
            ENDIF
            
            IF(ICS.EQ.1) THEN
               WRITE(16,1880) I,NNM(I),XEM(I),YEM(I)
            ELSE
               WRITE(16,1883) I,NNM(I),SLEM(I)*RAD2DEG,
     *              SFEM(I)*RAD2DEG,XEM(I),YEM(I)
            ENDIF

C...  PRE-COMPUTE INFORMATION REQUIRED TO INTERPOLATE AT METEOROLOGICAL
C...  RECORDING STATIONS

            N1=NM(NNM(I),1)
            N2=NM(NNM(I),2)
            N3=NM(NNM(I),3)
            X1=X(N1)
            X2=X(N2)
            X3=X(N3)
            X4=XEM(I)
            Y1=Y(N1)
            Y2=Y(N2)
            Y3=Y(N3)
            Y4=YEM(I)
            STAIM1(I)=((X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4))/AREAS(NNM(I))
            STAIM2(I)=((X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1))/AREAS(NNM(I))
            STAIM3(I)=(-(X4-X1)*(Y2-Y1)+(Y4-Y1)*(X2-X1))/AREAS(NNM(I))

         END DO
      ENDIF
      IF (NSTAM.EQ.0) MNSTAM = 1

C...
C...  INPUT INFORMATION ABOUT GLOBAL ELEVATION DATA OUTPUT
C...

C...  READ IN NOUTGE,TOUTSGE,TOUTFGE,NSPOOLGE : IF NOUTGE<>0, GLOBAL ELEV.
C...  OUTPUT IS SPOOLED TO UNIT 63 EVERY NSPOOLGE TIME STEPS BETWEEN
C...  TIMES TOUTSGE AND TOUTFGE; IF ABS(NOUTGE)=2, OUTPUT WILL BE BINARY

      READ(15,*) NOUTGE,TOUTSGE,TOUTFGE,NSPOOLGE
      WRITE(16,3301) NOUTGE
 3301 FORMAT(////,1X,'GLOBAL NODAL ELEVATION INFORMATION OUTPUT: ',
     *     //,5X,'NOUTGE = ',I2)

C...  CHECK INPUT PARAMETER NOUTGE

      IF(ABS(NOUTGE).GT.2) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3302)
         WRITE(16,3302)
 3302    FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *        //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *        ' NOUTGE',
     *        /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
         WRITE(16,9973)
         STOP
      ENDIF

C...  IF GLOBAL ELEVATION OUTPUT WILL NOT BE GENERATED

      IF(NOUTGE.EQ.0) THEN
         WRITE(16,3303)
 3303    FORMAT(///,5X,'NO GLOBAL ELEVATION OUTPUT WILL BE SPOOLED')
      ENDIF

C...  IF GLOBAL ELEVATION OUTPUT WILL BE GENERATED

      IF(NOUTGE.NE.0) THEN

C...  COMPUTE NTCYSGE, NTCYFGE, WHICH = TOUTSGE AND TOUTFGE IN TIMESTEPS

         NTCYSGE=INT((TOUTSGE-STATIM)*(86400.D0/DTDP) + 0.5d0)
         NTCYFGE=INT((TOUTFGE-STATIM)*(86400.D0/DTDP) + 0.5d0)
         IF(NTCYFGE.GT.NT) NTCYFGE=NT

C...  CALCULATE NDSETSE = THE # OF DATA SETS TO BE SPOOLED TO UNIT 63

         IF(NSPOOLGE.EQ.0) NDSETSE=0
         IF(NSPOOLGE.NE.0) NDSETSE=INT((NTCYFGE-NTCYSGE)/NSPOOLGE)

C...  WRITE NOUTGE,TOUTSGE,TOUTFGE,NTCYSGE,NTCYFGE,NSPOOLGE TO UNIT 16

         WRITE(16,3304) TOUTSGE,NTCYSGE,TOUTFGE,NTCYFGE,NSPOOLGE
 3304    FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSGE =',F8.3,
     *              ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'DATA RECORDS WILL STOP AFTER TOUTFGE =',F8.3,
     *              ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *           I9,' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 63 EVERY ',
     *              'NSPOOLGE =',I8,' TIME STEPS')
         IF(ABS(NOUTGE).EQ.1) WRITE(16,3305)
 3305    FORMAT(/,5X,'UNIT 63 FORMAT WILL BE ASCII')
         IF(ABS(NOUTGE).EQ.2) WRITE(16,3306)
 3306    FORMAT(/,5X,'UNIT 63 FORMAT WILL BE BINARY')
      ENDIF

C...
C...  INPUT INFORMATION ABOUT GLOBAL VELOCITY DATA OUTPUT
C...

C...  READ IN NOUTGV,TOUTSGV,TOUTFGV,NSPOOLGV : IF NOUTGV<>0, GLOBAL VEL.
C...  OUTPUT IS SPOOLED TO UNIT 64 EVERY NSPOOLGV TIME STEPS BETWEEN
C...  TIMES TOUTSGV AND TOUTFGV; IF ABS(NOUTGV)=2, OUTPUT WILL BE BINARY

      READ(15,*) NOUTGV,TOUTSGV,TOUTFGV,NSPOOLGV
      WRITE(16,3351) NOUTGV
 3351 FORMAT(////,1X,'GLOBAL NODAL VELOCITY INFORMATION OUTPUT : ',
     *     //,5X,'NOUTGV = ',I2)

C...  CHECK INPUT PARAMETER NOUTGV

      IF(ABS(NOUTGV).GT.2) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3352)
         WRITE(16,3352)
 3352    FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *        //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *        ' NOUTGV',
     *        /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
         WRITE(16,9973)
         STOP
      ENDIF

C...  IF GLOBAL VELOCITY OUTPUT WILL NOT BE GENERATED

      IF(NOUTGV.EQ.0) THEN
         WRITE(16,3353)
 3353    FORMAT(///,5X,'NO GLOBAL VELOCITY OUTPUT WILL BE SPOOLED')
      ENDIF

C...  IF GLOBAL VELOCITY OUTPUT WILL BE GENERATED

      IF(NOUTGV.NE.0) THEN

C...  COMPUTE NTCYSGV, NTCYFGV, WHICH = TOUTSGV AND TOUTFGV IN TIMESTEPS

          NTCYSGV=INT((TOUTSGV-STATIM)*(86400.D0/DTDP) + 0.5d0)
          NTCYFGV=INT((TOUTFGV-STATIM)*(86400.D0/DTDP) + 0.5d0)
          IF(NTCYFGV.GT.NT) NTCYFGV=NT

C...  CALCULATE NDSETSV = THE # OF DATA SETS TO BE SPOOLED TO UNIT 64

          IF(NSPOOLGV.EQ.0) NDSETSV=0
          IF(NSPOOLGV.NE.0) NDSETSV=INT((NTCYFGV-NTCYSGV)/NSPOOLGV)
          
C...  WRITE NOUTGV,TOUTSGV,TOUTFGV,NTCYSGV,NTCYFGV,NSPOOLGV TO UNIT 16

          WRITE(16,3354) TOUTSGV,NTCYSGV,TOUTFGV,NTCYFGV,NSPOOLGV
 3354     FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSGV =',F8.3,
     *         ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *         I9,' TIME STEPS INTO THE SIMULATION',
     *         //,5X,'DATA RECORDS WILL STOP AFTER TOUTFGV =',F8.3,
     *         ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *         I9,' TIME STEPS INTO THE SIMULATION',
     *         //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 64 EVERY ',
     *         'NSPOOLGV =',I8,' TIME STEPS')
          IF(ABS(NOUTGV).EQ.1) WRITE(16,3355)
 3355     FORMAT(/,5X,'UNIT 64 FORMAT WILL BE ASCII')
          IF(ABS(NOUTGV).EQ.2) WRITE(16,3356)
 3356     FORMAT(/,5X,'UNIT 64 FORMAT WILL BE BINARY')
       ENDIF
       
C...
C...  IF TRANSPORT IS INCLUDED IN THE RUN, INPUT INFORMATION ABOUT GLOBAL
C...  CONCENTRATION DATA OUTPUT
C...
       NOUTGC=0
       IF(IM.EQ.10) THEN

C...  READ IN NOUTGC,TOUTSGC,TOUTFGC,NSPOOLGC : IF NOUTGC<>0, GLOBAL
C...  CONCENTRATION OUTPUT IS SPOOLED TO UNIT 73 EVERY NSPOOLGC TIME
C...  STEPS BETWEEN TIMES TOUTSGC AND TOUTFGC; IF ABS(NOUTGC)=2, OUTPUT
C...  WILL BE BINARY

          READ(15,*) NOUTGC,TOUTSGC,TOUTFGC,NSPOOLGC
          WRITE(16,3401) NOUTGC
 3401     FORMAT(////,1X,'GLOBAL NODAL CONCENTRATION INFORMATION OUTPUT:',
     *         //,5X,'NOUTGC = ',I2)

C...  CHECK INPUT PARAMETER NOUTGC

          IF(ABS(NOUTGC).GT.2) THEN
             IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3402)
             WRITE(16,3402)
 3402        FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *                 ' NOUTGC',
     *            /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
             IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
             WRITE(16,9973)
             STOP
          ENDIF

C...  IF GLOBAL CONCENTRATION OUTPUT WILL NOT BE GENERATED

        IF(NOUTGC.EQ.0) THEN
           WRITE(16,3403)
 3403      FORMAT(///,5X,'NO GLOBAL CONCENTRATION OUTPUT WILL BE ',
     *          'SPOOLED')
        ENDIF

C...  IF GLOBAL CONCENTRATION OUTPUT WILL BE GENERATED

        IF(NOUTGC.NE.0) THEN

C...  COMPUTE NTCYSGC, NTCYFGC, WHICH = TOUTSGC AND TOUTFGC IN TIMESTEPS

           NTCYSGC=INT((TOUTSGC-STATIM)*(86400.D0/DTDP) + 0.5d0)
           NTCYFGC=INT((TOUTFGC-STATIM)*(86400.D0/DTDP) + 0.5d0)
           IF(NTCYFGC.GT.NT) NTCYFGC=NT

C...  CALCULATE NDSETSC = THE # OF DATA SETS TO BE SPOOLED TO UNIT 73

           IF(NSPOOLGC.EQ.0) NDSETSC=0
           IF(NSPOOLGC.NE.0) NDSETSC=INT((NTCYFGC-NTCYSGC)/NSPOOLGC)

C...  WRITE NOUTGC,TOUTSGC,TOUTFGC,NTCYSGC,NTCYFGC,NSPOOLGC TO UNIT 16

           WRITE(16,3404) TOUTSGC,NTCYSGC,TOUTFGC,NTCYFGC,NSPOOLGC
 3404      FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSGC =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'DATA RECORDS WILL STOP AFTER TOUTFGC =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 73 EVERY ',
     *                'NSPOOLGC =',I8,' TIME STEPS')
           IF(ABS(NOUTGC).EQ.1) WRITE(16,3405)
 3405      FORMAT(/,5X,'UNIT 73 FORMAT WILL BE ASCII')
           IF(ABS(NOUTGC).EQ.2) WRITE(16,3406)
 3406      FORMAT(/,5X,'UNIT 73 FORMAT WILL BE BINARY')
        ENDIF

      ENDIF

C...
C...  IF NWS<>0   INPUT INFORMATION ABOUT GLOBAL WIND DATA OUTPUT
C...
      IF(NWS.NE.0) THEN

C...  READ IN NOUTGW,TOUTSGW,TOUTFGW,NSPOOLGW : IF NOUTGW<>0, GLOBAL
C...  WIND OUTPUT IS SPOOLED TO UNIT 74 EVERY NSPOOLGW TIME STEPS
C...  BETWEEN TIMES TOUTSGW AND TOUTFGW; IF ABS(NOUTGW)=2, OUTPUT WILL
C...  BE BINARY

         READ(15,*) NOUTGW,TOUTSGW,TOUTFGW,NSPOOLGW
         WRITE(16,3451) NOUTGW
 3451    FORMAT(////,1X,'GLOBAL WIND STRESS INFORMATION OUTPUT : ',
     *           //,5X,'NOUTGW = ',I2)

C...  CHECK INPUT PARAMETER NOUTGW

         IF(ABS(NOUTGW).GT.2) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3452)
            WRITE(16,3452)
 3452       FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *           //,1X,'YOUR SELECTION OF THE UNIT 15 INPUT PARAMETER',
     *                 ' NOUTGW',
     *            /,1X,'IS NOT AN ALLOWABLE VALUE.  CHECK YOUR INPUT!!')
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3453)
            WRITE(16,3453)
            STOP
         ENDIF
          
C...  IF GLOBAL WIND STRESS OUTPUT WILL NOT BE GENERATED

         IF(NOUTGW.EQ.0) THEN
            WRITE(16,3453)
 3453       FORMAT(///,5X,'NO GLOBAL WIND STRESS OUTPUT WILL BE SPOOLED')
         ENDIF

C...  IF GLOBAL WIND STRESS OUTPUT WILL BE GENERATED

        IF(NOUTGW.NE.0) THEN

C...  COMPUTE NTCYSGW, NTCYFGW, WHICH = TOUTSGW AND TOUTFGW IN TIMESTEPS

           NTCYSGW=INT((TOUTSGW-STATIM)*(86400.D0/DTDP) + 0.5d0)
           NTCYFGW=INT((TOUTFGW-STATIM)*(86400.D0/DTDP) + 0.5d0)
           IF(NTCYFGW.GT.NT) NTCYFGW=NT

C...  CALCULATE NDSETSW = THE # OF DATA SETS TO BE SPOOLED TO UNIT 74
           
           IF(NSPOOLGW.EQ.0) NDSETSW=0
           IF(NSPOOLGW.NE.0) NDSETSW=INT((NTCYFGW-NTCYSGW)/NSPOOLGW)

C...  WRITE NOUTGW,TOUTSGW,TOUTFGW,NTCYSGW,NTCYFGW,NSPOOLGW TO UNIT 16

           WRITE(16,3454) TOUTSGW,NTCYSGW,TOUTFGW,NTCYFGW,NSPOOLGW
 3454      FORMAT(/,5X,'DATA RECORDS WILL START AFTER TOUTSGW =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'DATA RECORDS WILL STOP AFTER TOUTFGW =',F8.3,
     *                ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',
     *             I9,' TIME STEPS INTO THE SIMULATION',
     *          //,5X,'INFORMATION WILL BE SPOOLED TO UNIT 74 EVERY ',
     *                'NSPOOLGW =',I8,' TIME STEPS')
           IF(ABS(NOUTGW).EQ.1) WRITE(16,3455)
 3455      FORMAT(/,5X,'UNIT 74 FORMAT WILL BE ASCII')
           IF(ABS(NOUTGW).EQ.2) WRITE(16,3456)
 3456      FORMAT(/,5X,'UNIT 74 FORMAT WILL BE BINARY')
        ENDIF

      ENDIF

C...
C...  READ AND CHECK INFORMATION ABOUT HARMONIC ANALYSIS OF MODEL RESULTS
C...  
      READ(15,*) NFREQ 
      WRITE(16,99392) NFREQ  
99392 FORMAT(////,1X,'HARMONIC ANALYSIS INFORMATION OUTPUT : ',
     *     //,5X,'HARMONIC ANALYSIS PERFORMED FOR ',I4,' CONSTITUENTS',/)
      MNHARF = NFREQ

      IF (NFREQ.EQ.0) MNHARF = 1

C  Allocate harmonic analysis arrays

      IF (NFREQ.GT.0) THEN
         CALL ALLOC_HA()
         CALL ALLOC_MAIN14()
      ENDIF
      
      IF(NFREQ.LT.0) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99391)
         WRITE(16,99391)
99391    FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *        //,1X,'YOUR SELECTION OF NHARFR (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT',
     *        //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
         STOP
      ENDIF
      IF(NFREQ.GT.0) WRITE(16,2330)
 2330 FORMAT(/,7X,'FREQUENCY',4X,'NODAL FACTOR',6X,'EQU.ARG(DEG)',
     *     1X,'CONSTITUENT',/)
      DO 1201 I=1,NFREQ  
         READ(15,'(A10)') NAMEFR(I)
         READ(15,*) HAFREQ(I),HAFF(I),HAFACE(I)
         WRITE(16,2331) HAFREQ(I),HAFF(I),HAFACE(I),NAMEFR(I)
 2331    FORMAT(4X,F15.12,2X,F10.7,5X,F10.3,7X,A10)
 1201 CONTINUE
      
C...  read in interval information for harmonic analysis
c...  compute thas and thaf in terms of the number of time steps

      READ(15,*) THAS,THAF,NHAINC,FMV
      ITHAS=INT((THAS-STATIM)*(86400.D0/DTDP) + 0.5d0)
      THAS=ITHAS*DTDP/86400.D0 + STATIM
      ITHAF=INT((THAF-STATIM)*(86400.D0/DTDP) + 0.5d0)
      THAF=ITHAF*DTDP/86400.D0 + STATIM
      ITMV = ITHAF - (ITHAF-ITHAS)*FMV
      IF(NFREQ.GT.0) THEN
         WRITE(16,34634) THAS,ITHAS,THAF,ITHAF,NHAINC
34634    FORMAT(/,5X,'HARMONIC ANALYSIS WILL START AFTER THAS =',F8.3,
     *        ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',I9,
     *        ' TIME STEPS INTO THE SIMULATION',
     *        //,5X,'HARMONIC ANALYSIS WILL STOP AFTER THAF =',F8.3,
     *        ' DAY(S) RELATIVE',/,9X,'TO THE STARTING TIME OR',I9,
     *        ' TIME STEPS INTO THE SIMULATION'
     *        ,//,5X,'INFORMATION WILL BE ANALYZED EVERY ',
     *        'NHAINC =',I8,' TIME STEPS.')
         WRITE(16,34639) FMV*100.,ITMV
34639    FORMAT(/,5X,'MEANS AND VARIANCES WILL BE COMPUTED FOR THE ',
     *        'FINAL ',F10.5,' %',/9X,'OF THE HARMONIC ANALYSIS ',
     *        'PERIOD OR AFTER ',I9,' TIME STEPS INTO THE ',
     *        'SIMULATION.',/9X,' RESULTS ARE WRITTEN TO UNIT 55.')
         
      ELSE
         WRITE(16,34645)
34645    FORMAT(///,5X,'NO HARMONIC ANALYSIS WILL BE DONE')
      ENDIF
      
      IF ((FMV.GT.0.).AND.(NFREQ.GT.0).AND.(C2DDI)) CHARMV = .TRUE.
      
C...  read in and write out information on where harmonic analysis will
C...  be done
      
      READ(15,*) NHASE,NHASV,NHAGE,NHAGV
      IF((NHASE.LT.0).OR.(NHASE.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99661)
         WRITE(16,99661)
99661    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',//
     *        ,1X,'YOUR SELECTION OF NHASE (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99671)
            WRITE(16,99671)
99671       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET NHASE EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NHASE=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF
      IF(NHASE.EQ.1) THEN
         WRITE(16,34641)
34641    FORMAT(///,5X,'STATION ELEVATION HARMONIC ANAL WILL BE ',
     *        'WRITTEN TO UNIT 51')
      ENDIF
      IF((NHASV.LT.0).OR.(NHASV.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99662)
         WRITE(16,99662)
99662    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',//
     *        ,1X,'YOUR SELECTION OF NHASV (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99672)
            WRITE(16,99672)
99672       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET NHASV EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NHASV=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF
      IF(NHASV.EQ.1) THEN
         WRITE(16,34642)
34642    FORMAT(///,5X,'STATION VELOCITY HARMONIC ANAL WILL BE ',
     *        'WRITTEN TO UNIT 52')
      ENDIF
      IF((NHAGE.LT.0).OR.(NHAGE.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99663)
         WRITE(16,99663)
99663    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',//
     *        ,1X,'YOUR SELECTION OF NHAGE (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99673)
            WRITE(16,99673)
99673       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET NHAGE EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NHAGE=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF
      IF(NHAGE.EQ.1) THEN
         WRITE(16,34643)
34643    FORMAT(///,5X,'GLOBAL ELEVATION HARMONIC ANAL WILL BE ',
     *        'WRITTEN TO UNIT 53')
      ENDIF
      IF((NHAGV.LT.0).OR.(NHAGV.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99664)
         WRITE(16,99664)
99664    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',//
     *        ,1X,'YOUR SELECTION OF NHAGV (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99674)
            WRITE(16,99674)
99674       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET NHAGV EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NHAGV=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF
      IF(NHAGV.EQ.1) THEN
         WRITE(16,34644)
34644    FORMAT(///,5X,'GLOBAL VELOCITY HARMONIC ANAL WILL BE ',
     *        'WRITTEN TO UNIT 54')
      ENDIF
        
C...  ESTABLISH INDICATOR OF WHETHER ANY HARMONIC ANALYSIS WILL BE DONE

      IHARIND=NFREQ*(NHASE+NHASV+NHAGE+NHAGV)
      IF(IHARIND.GT.0) IHARIND=1
C...
C...  input information about hot start output
C...
      READ(15,*) NHSTAR,NHSINC
      WRITE(16,99655)
99655 FORMAT(////,1X,'HOT START OUTPUT INFORMATION OUTPUT : ')
      IF((NHSTAR.LT.0).OR.(NHSTAR.GT.1)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99665)
         WRITE(16,99665)
99665    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL ',
     *        'INPUT ERROR  !!!!!!!!!',//
     *        ,1X,'YOUR SELECTION OF NHSTAR (A UNIT 15 '
     *        ,'INPUT PARAMETER) IS NOT AN ALLOWABLE VALUE',/,1X,
     *        'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99675)
            WRITE(16,99675)
99675       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET NHSTAR EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            NHSTAR=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF
      IF(NHSTAR.EQ.1) THEN
         WRITE(16,34636) NHSINC
34636    FORMAT(/,5X,'HOT START OUTPUT WILL BE WRITTEN TO UNIT',
     *        ' 67 OR 68 EVERY ',I5,' TIME STEPS')
      ELSE
         WRITE(16,34646)
34646    FORMAT(///,5X,'NO HOT START OUTPUT WILL BE GENERATED')
      ENDIF
      IF ((IHOT.EQ.0).OR.(IHOT.EQ.68)) IHSFIL=67
      IF (IHOT.EQ.67) IHSFIL=68
C...
C...  input information about solver
C...

C...THIS SECTION TO LUMP THE GWCE MATRIX
Cvjp 11/30/99 made lumping a compile time option


      CLUMP = .FALSE.
      ILUMP=0

        
      READ(15,*) ITITER,ISLDIA,CONVCR,ITMAX
        
      WRITE(16,99656)
99656 FORMAT(//,1X,'SOLVER INFORMATION OUTPUT : ')

C     - allocate arrays dimensioned by MNEI
      call alloc_main11()

C...  lines to use the iterative matrix solver

      IF((ISLDIA.LT.0).OR.(ISLDIA.GT.5)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9920)
         WRITE(16,9920)
 9920    FORMAT(////,1X,'!!!!!!!!!!  WARNING - NONFATAL INPUT ERROR',
     *        ' !!!!!!!!!',//,1X,'ISLDIA (A UNIT 15 INPUT PARAMETER) ',
     *        'MUST BE 0-5',/,1X,'PLEASE CHECK YOUR INPUT')
         IF(NFOVER.EQ.1) THEN
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9921)
            WRITE(16,9921)
 9921       FORMAT(/,1X,'PROGRAM WILL OVERRIDE SPECIFIED INPUT',
     *           ' AND SET ISLDIA EQUAL TO 0 ',
     *           //,1X,'!!!!!! EXECUTION WILL CONTINUE !!!!!!',//)
            ISLDIA=0
         ELSE
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,9973)
            WRITE(16,9973)
            STOP
         ENDIF
      ENDIF

      CALL DFAULT(IPARM,RPARM)
      IPARM(1)=ITMAX
      IPARM(2)=ISLDIA
      OPEN(33,FILE=DIRNAME//'/'//'fort.33')
      IPARM(4)=33
      RPARM(1)=CONVCR
      NW = 4*NP + 4*ITMAX

C...
C...  Read input for 3D run
C...
      IF(C3DVS) THEN
         CALL READ_INPUT_3DVS(DT,STATIM,NT)
c     ELSEIF(C3DDSS) THEN
c     CALL READ_INPUT_3DDSS(DT,STATIM,NT)
      ENDIF

C...  INITIALIZE AVERAGING FOR INTERNAL BARRIER WATER LEVELS
C...  BARAVGWT=0.000 -> NO AVERAGING PERFORMED
cjjwm001 changed one line                
      BARAVGWT=0.000D0
      IBSTART=0
      DO I=1,NVEL
         RBARWL1AVG(I)=0.D0
         RBARWL2AVG(I)=0.D0
      END DO
C...  INITIALIZE NIBNODECODE(I)
      DO I=1,NP
         NIBNODECODE(I)=0
      END DO
C...
C...  COMPUTE THE NEIGHBOR TABLE
C...
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1196)
      WRITE(16,1196)
 1196 FORMAT(/,1X,'THE NEIGHBOR TABLE IS BEING COMPUTED ',/)
C
      CALL NEIGHB(NE,NP,NM,NNEIGH,NEITAB,NEITABELE,NEIMIN,NEIMAX,
     *     X,Y,NSCREEN)
C
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *     WRITE(6,1195) NEIMIN,NEIMAX,NEIMAX
      WRITE(16,1195) NEIMIN,NEIMAX,NEIMAX
 1195 FORMAT(1X,'THE NEIGHBOR TABLE IS COMPLETED ',
     *   /,5X,'THE MINIMUM NUMBER OF NEIGHBORS FOR ANY NODE = ',I3,
     *   /,5X,'1+THE MAXIMUM NUMBER OF NEIGHBORS FOR ANY NODE = ',I3,
     *   /,5X,'THE PARAMETER MNEI CAN BE SET AS SMALL AS ',I3,/)

C - allocate arrays dealing with wind forcing
      call alloc_main12()
     
Cvjp 11/28/99  write table of ADCIRC parameter sizes
      WRITE(16,4010) MNE,MNP,MNEI,MNOPE,MNETA,MNBOU,MNVEL,
     *     MNTIF,MNBFR,MNSTAE,MNSTAV,MNSTAC,MNSTAM,NWLAT,NWLON,MNHARF,MNFFR
      IF(NWS.EQ.0) WRITE(16,4011)
      IF(NWS.EQ.1) WRITE(16,4012)
      IF(ABS(NWS).EQ.2) WRITE(16,4013)
      IF(NWS.EQ.3) WRITE(16,4014)
      IF(ABS(NWS).EQ.4) WRITE(16,4015)
      IF(ABS(NWS).EQ.5) WRITE(16,4115)
      IF(NWS.EQ.10) WRITE(16,4016)
      IF(NWS.EQ.11) WRITE(16,4017)
      IF((NFREQ.EQ.0).OR.(FMV.EQ.0.)) WRITE(16,4021)
      IF((NFREQ.GE.1).AND.(FMV.NE.0.)) WRITE(16,4022)
      IF(ILUMP.EQ.0) WRITE(16,4031)
      IF(ILUMP.EQ.1) WRITE(16,4032)
      IF(IM.EQ.0) WRITE(16,4101)
      IF(IM.EQ.10) WRITE(16,4109)
      IF(IM.EQ.1) WRITE(16,4102)
      IF(IM.EQ.2) WRITE(16,4103)
      WRITE(16,4105)
      WRITE(16,4108)
C
 4010 FORMAT(' *****************************************************',/,
     *       ' *   Based on information extracted from the ADCIRC  *',/,
     *       ' *   UNIT 14 and 15 (grid and horiz run info) files  *',/,
     *       ' *   the following paramter values will be set:      *',/,
     *       ' *                                                   *',/,
     *       ' *       MNE = ',I8,1X,'     MNP  = ',I8,1X,'        *',/,
     *       ' *       MNEI = ',I7,2X,'                            *',/,
     *       ' *       MNOPE = ',I6,3X,'   MNETA = ',I6,3X,'       *',/,
     *       ' *       MNBOU = ',I6,3X,'   MNVEL = ',I6,3X,'       *',/,
     *       ' *       MNTIF = ',I6,3X,'   MNBFR = ',I6,3X,'       *',/,
     *       ' *       MNSTAE = ',I5,4X,'  MNSTAV = ',I5,4X,'      *',/,
     *       ' *       MNSTAC = ',I5,4X,'  MNSTAM = ',I5,4X,'      *',/,
     *       ' *       MNWLAT = ',I5,4X,'  MNWLON = ',I5,4X,'      *',/,
     *       ' *       MNHARF = ',I5,4X,'  MNFFR = ',I6,3X,'       *',/,
     *       ' *                                                   *')
 4011 FORMAT(' *   Also, NO wind forcing will be used,             *')
 4012 FORMAT(' *   Also, Standard wind stress and pres will be used,*')
 4013 FORMAT(' *   Also, Semi-standard wind forcing will be used,  *')
 4014 FORMAT(' *   Also, Fleet numeric wind forcing will be used,  *')
 4015 FORMAT(' *   Also, PBL/JAG wind forcing will be used,        *')
 4115 FORMAT(' *   Also, Standard wind vel and pres will be used,  *')
 4016 FORMAT(' *   Also, AVN wind & pressure forcing will be used, *')
 4017 FORMAT(' *   Also, ETA wind & pressure forcing will be used, *')
 4021 FORMAT(' *   means and variance calculation will NOT be made,*')
 4022 FORMAT(' *   means and variance calculation will be made,    *')
 4031 FORMAT(' *   the GWCE matrix will be left in consistent form *')
 4032 FORMAT(' *   the GWCE matrix will be LUMPED                  *')
 4101 FORMAT(' *   the model will be set up for a 2DDI run,        *')
 4109 FORMAT(' *   the model will be set up for a 2DDI run + transp*')
 4102 FORMAT(' *   the model will be set up for a 3D-VS run,       *')
 4103 FORMAT(' *   the model will be set up for a 3D-DSS run,      *')
 4105 FORMAT(' *   and an iterative solver will be used            *')
 4108 FORMAT(' *****************************************************',/)
C

C...
C...  CLOSE FILES FORT.14 and FORT.15                 
C...
      CLOSE(14)
      CLOSE(15)
C...  
      RETURN 
      END

C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001  
C    last changes in this file VERSION 41.11
C
C  mod history
C  v40.02mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx 
C
C  v41.11 - 09/14/01 - rl - from 41.10 - added NWS = -2 capability
C  v41.09 - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C  v40.02m002 - 12/22 - jjw/vjp - Vic suggested this change to avoid compiler conflicts
C  v40.02m001 - 12/21 - jjw - add cross barrier pipes cjjwm001
C************************************************************************** 
C 
        SUBROUTINE HOTSTART()
C
C**************************************************************************
C
C  HOT START PROGRAM SETUP ROUTINE 
C
C**************************************************************************
C
      USE GLOBAL
      USE HARM
      USE WIND
      IMPLICIT NONE
      INTEGER IT
C...
C......READ IN 2 DDI HOT START INITIAL CONDITION OVER WHOLE DOMAIN
C......THIS FILE ALWAYS HAS A RECL=8 BECAUSE IT IS ASSUMED THAT THE HARMONIC
C......ANALYSIS IS ALWAYS DONE IN 64 BITS, EVEN ON A WORKSTATION
C...
        IF(IHOT.EQ.67) OPEN(67,FILE=DIRNAME//'/'//'fort.67',
     *        ACCESS='DIRECT',RECL=8)
        IF(IHOT.EQ.68) OPEN(68,FILE=DIRNAME//'/'//'fort.68',
     *       ACCESS='DIRECT',RECL=8)
        IHOTSTP=1
        READ(IHOT,REC=IHOTSTP) IMHS
        IHOTSTP=2
        READ(IHOT,REC=IHOTSTP) TIME
        IHOTSTP=3
        READ(IHOT,REC=IHOTSTP) ITHS
        DO I=1,NP
          READ(IHOT,REC=IHOTSTP+1) ETA1(I)
          READ(IHOT,REC=IHOTSTP+2) ETA2(I)
          READ(IHOT,REC=IHOTSTP+3) UBAR2(I)
          READ(IHOT,REC=IHOTSTP+4) VBAR2(I)
          IHOTSTP=IHOTSTP+4
          IF(IMHS.EQ.10) THEN
            READ(IHOT,REC=IHOTSTP+1) CH1(I)
            IHOTSTP=IHOTSTP+1
            ENDIF
          READ(IHOT,REC=IHOTSTP+1) NNODECODE(I)
          IHOTSTP=IHOTSTP+1
          ETAS(I)=ETA2(I)-ETA1(I)
          NODEREP(I)=MAX0(NODEWETMIN,NODEDRYMIN)
          END DO

        RAMP2=1.0D0
        RAMP1=1.0D0
        IF(NRAMP.EQ.1) THEN
          RAMP1=TANH((2.D0*(ITHS-1)*DTDP/86400.D0)/DRAMP)
          RAMP2=TANH((2.D0*ITHS*DTDP/86400.D0)/DRAMP)
          ENDIF

C
C....SET POSITIONS IN BOUNDARY CONDITION, WIND AND OUTPUT FILES
C
        WRITE(16,1112)
        WRITE(16,1794)
1794    FORMAT(//,' INFORMATION ABOUT RE-STARTING THE TIME SERIES',
     *            ' OUTPUT FILES (UNITS 61-64,71,74),',
     *    /,' WIND/PRESSURE FILE (UNIT 22) AND FLOW BOUNDARY CONDITION',
     *      ' FILE (UNIT 20)',//)

C......INITIALLY, ZERO OUT THE NORMAL FLOW ON ALL BOUNDARIES

        DO I=1,NVEL
          QN2(I)=0.D0
          QN1(I)=0.D0
          QN0(I)=0.D0
          END DO

C....FIND THE PROPER PLACE IN THE APERIODIC ELEVATION SPECIFIED BOUNDARY CONDITION
C....FILE IF IT IS REQURIED.

        IF((NOPE.GT.0).AND.(NBFR.EQ.0)) THEN
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
          WRITE(16,1112)
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1976)
          WRITE(16,1976)
 1976     FORMAT(/,1X,'LOCATING ELEVATION SPECIFIED INFORMATION IN ',
     *                'UNIT 19',/)
          OPEN(19,FILE=DIRNAME//'/'//'fort.19')
          READ(19,*) ETIMINC
          ETIME1=STATIM*86400.D0
          ETIME2=ETIME1+ETIMINC
          DO J=1,NETA
            READ(19,*) ESBIN1(J)
            END DO
          DO J=1,NETA
            READ(19,*) ESBIN2(J)
            END DO
          DO IT=1,ITHS-1
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.ETIME2) THEN
              ETIME1=ETIME2
              ETIME2=ETIME1+ETIMINC
              DO J=1,NETA
                ESBIN1(J)=ESBIN2(J)
                READ(19,*) ESBIN2(J)
                END DO
              ENDIF
            END DO
          IF(TIME.GT.ETIME2) THEN
            ETIME1=ETIME2
            ETIME2=ETIME1+ETIMINC
            DO J=1,NETA
              ESBIN1(J)=ESBIN2(J)
              READ(19,*) ESBIN2(J)
              END DO
            ENDIF
          ETRATIO=(TIMEIT-ETIME1)/ETIMINC
          ENDIF

C......FIND PROPER PLACE IN THE APERIODIC NORMAL FLOW BOUNDARY CONDITION FILE IF IT
C......IS REQUIRED

        IF((NFLUXF.EQ.1).AND.(NFFR.EQ.0)) THEN
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
          WRITE(16,1112)
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1978)
          WRITE(16,1978)
 1978     FORMAT(/,1X,'LOCATING NORMAL FLOW INFORMATION IN UNIT 20',/)
          OPEN(20,FILE=DIRNAME//'/'//'fort.20')
          READ(20,*) FTIMINC
          QTIME1=STATIM*86400.D0
          QTIME2=QTIME1+FTIMINC
          DO J=1,NVEL
            QNIN1(J)=0.D0
            IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                          .OR.(LBCODEI(J).EQ.22))
     *                                              READ(20,*) QNIN1(J)
            END DO
          DO J=1,NVEL
            QNIN2(J)=0.D0
            IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                          .OR.(LBCODEI(J).EQ.22))
     *                                              READ(20,*) QNIN2(J)
            END DO
          DO IT=1,ITHS-1
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.QTIME2) THEN
              QTIME1=QTIME2
              QTIME2=QTIME2+FTIMINC
              DO J=1,NVEL
                IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                              .OR.(LBCODEI(J).EQ.22)) THEN
                  QNIN1(J)=QNIN2(J)
                  READ(20,*) QNIN2(J)
                  ENDIF
                END DO
              ENDIF
            END DO
          QTRATIO=(TIMEIT-QTIME1)/FTIMINC
          DO I=1,NVEL
            QN1(I)=RAMP1*(QNIN1(I)+QTRATIO*(QNIN2(I)-QNIN1(I)))
            END DO
          IF(TIME.GT.QTIME2) THEN
            QTIME1=QTIME2
            QTIME2=QTIME1+FTIMINC
            DO J=1,NVEL
              IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                            .OR.(LBCODEI(J).EQ.22)) THEN
                QNIN1(J)=QNIN2(J)
                READ(20,*) QNIN2(J)
                ENDIF
              END DO
            ENDIF
          QTRATIO=(TIME-QTIME1)/FTIMINC
          DO I=1,NVEL
            QN2(I)=RAMP2*(QNIN1(I)+QTRATIO*(QNIN2(I)-QNIN1(I)))
            END DO
          ENDIF

C......RESTART THE PERIODIC NORMAL FLOW BOUNDARY CONDITION

        IF((NFLUXF.EQ.1).AND.(NFFR.GT.0)) THEN
          DO J=1,NFFR
            IF(FPER(J).EQ.0.) THEN
              NCYC=0.
              ELSE
              NCYC=INT(TIME/FPER(J))
              ENDIF
            ARGJ1=FAMIG(J)*(TIME-DTDP-NCYC*FPER(J))+FFACE(J)
            ARGJ2=FAMIG(J)*(TIME-NCYC*FPER(J))+FFACE(J)
            RFF1=FFF(J)*RAMP1
            RFF2=FFF(J)*RAMP2
            DO I=1,NVEL
              ARG1=ARGJ1-QNPH(J,I)
              ARG2=ARGJ2-QNPH(J,I)
              QN1(I)=QN1(I)+QNAM(J,I)*RFF1*COS(ARG1)
              QN2(I)=QN2(I)+QNAM(J,I)*RFF2*COS(ARG2)
              END DO
            END DO
          ENDIF

C...
C...RESTART SUPERCRITICAL OUTWARD NORMAL FLOW OVER SPECIFIED
C....EXTERNAL BARRIER BOUNDARY NODES
C...
        IF(NFLUXB.EQ.1) THEN
          DO I=1,NVEL
            IF((LBCODEI(I).EQ.3).OR.(LBCODEI(I).EQ.13)
     *        .OR.(LBCODEI(I).EQ.23)) THEN
              NNBB=NBV(I)
              RBARWL=2.D0*(ETA1(NNBB)-BARLANHT(I))/3.D0
              IF(RBARWL.GT.0.0D0) THEN
                QN1(I)=-RAMP1*BARLANCFSP(I)*RBARWL*(RBARWL*G)**0.5D0
              ENDIF
              RBARWL=2.D0*(ETA2(NNBB)-BARLANHT(I))/3.D0
              IF(RBARWL.GT.0.0D0) THEN
                QN2(I)=-RAMP2*BARLANCFSP(I)*RBARWL*(RBARWL*G)**0.5D0
              ENDIF
            ENDIF
          END DO
        ENDIF

C...
C...RESTART INWARD/OUTWARD NORMAL FLOW OVER SPECIFIED
cjjwm001 - modified/added the following 3 lines
C....INTERNAL BARRIERS AND FOR INTERNAL BARRIER BOUNDARIES
C....WITH CROSS BARRIER PIPES
C....THIS SECTION ONLY RESTARTS THE OVER BARRIER FLOW COMPONENT
C...
cjjwm001 - modified following line
        IF(NFLUXIB.EQ.1) THEN
          DO I=1,NVEL
cjjwm001 - modified following 2 lines
            IF((LBCODEI(I).EQ.4).OR.(LBCODEI(I).EQ.24) 
     *        .OR.(LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
              NNBB1=NBV(I)      ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
              NNBB2=IBCONN(I)   ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
C.............RESET INFORMATION FOR K-1 TIME LEVEL
              RBARWL1=ETA1(NNBB1)-BARINHT(I)
              RBARWL2=ETA1(NNBB2)-BARINHT(I)
              RBARWL1F=2.0D0*RBARWL1/3.0D0
              RBARWL2F=2.0D0*RBARWL2/3.0D0
              IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN ! WATER LEVEL BELOW BARRIER
                QN1(I)=0.0D0                                   ! NO FLOW
                GOTO 1998
              ENDIF
              IF(RBARWL1.EQ.RBARWL2) THEN ! WATER LEVEL EQUAL ON BOTH SIDES OF BARRIER
                QN1(I)=0.0D0                ! NO FLOW
                GOTO 1998
              ENDIF
              IF(RBARWL1.GT.RBARWL2) THEN ! WATER LEVEL GREATER ON THIS SIDE OF BARRIER
                IF(RBARWL2.GT.RBARWL1F) THEN ! OUTWARD SUBCRITICAL FLOW
                  QN1(I)=-RAMP1*BARINCFSB(I)*RBARWL2*
     *                    (2.d0*G*(RBARWL1-RBARWL2))**0.5D0
                  GOTO 1998
                ELSE                        ! OUTWARD SUPERCRITICAL FLOW
                  QN1(I)=-RAMP1*BARINCFSP(I)*RBARWL1F*
     *                    (RBARWL1F*G)**0.5D0
                  GOTO 1998
                ENDIF
              ENDIF
              IF(RBARWL2.GT.RBARWL1) THEN  ! WATER LEVEL LOWER ON THIS SIDE OF BARRIER
                IF(RBARWL1.GT.RBARWL2F) THEN ! INWARD SUBCRITICAL FLOW
                  QN1(I)=RAMP1*BARINCFSB(I)*RBARWL1*
     *                   (2.d0*G*(RBARWL2-RBARWL1))**0.5D0
                  GOTO 1998
                ELSE                         ! INWARD SUPERCRITICAL FLOW
                  QN1(I)=RAMP1*BARINCFSP(I)*RBARWL2F*(RBARWL2F*G)**0.5D0
                  GOTO 1998
                ENDIF
              ENDIF
1998          CONTINUE
C.............RESET INFORMATION FOR K TIME LEVEL
              RBARWL1=ETA2(NNBB1)-BARINHT(I)
              RBARWL2=ETA2(NNBB2)-BARINHT(I)
              RBARWL1F=2.0D0*RBARWL1/3.0D0
              RBARWL2F=2.0D0*RBARWL2/3.0D0
              IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN ! WATER LEVEL BELOW BARRIER
                QN2(I)=0.0D0                                   ! NO FLOW
                GOTO 1999
              ENDIF
              IF(RBARWL1.EQ.RBARWL2) THEN ! WATER LEVEL EQUAL ON BOTH SIDES OF BARRIER
                QN2(I)=0.0D0                ! NO FLOW
                GOTO 1999
              ENDIF
              IF(RBARWL1.GT.RBARWL2) THEN ! WATER LEVEL GREATER ON THIS SIDE OF BARRIER
                IF(RBARWL2.GT.RBARWL1F) THEN ! OUTWARD SUBCRITICAL FLOW
                  QN2(I)=-RAMP2*BARINCFSB(I)*RBARWL2*
     *                    (2.d0*G*(RBARWL1-RBARWL2))**0.5D0
                  GOTO 1999
                ELSE                         ! OUTWARD SUPERCRITICAL FLOW
                  QN2(I)=-RAMP2*BARINCFSP(I)*RBARWL1F*
     *                    (RBARWL1F*G)**0.5D0
                  GOTO 1999
                ENDIF
              ENDIF
              IF(RBARWL2.GT.RBARWL1) THEN !WATER LEVEL LOWER ON THIS SIDE OF BARRIER
                IF(RBARWL1.GT.RBARWL2F) THEN ! INWARD SUBCRITICAL FLOW
                  QN2(I)=RAMP2*BARINCFSB(I)*RBARWL1*
     *                   (2.d0*G*(RBARWL2-RBARWL1))**0.5D0
                  GOTO 1999
                ELSE                         ! INWARD SUPERCRITICAL FLOW
                  QN2(I)=RAMP2*BARINCFSP(I)*RBARWL2F*(RBARWL2F*G)**0.5D0
                  GOTO 1999
                ENDIF
              ENDIF
1999          CONTINUE
            ENDIF
          END DO
        ENDIF

cjjwm001 - start add
C...
C...RESTART INWARD/OUTWARD NORMAL FLOW OVER SPECIFIED
C....INTERNAL BARRIERS WITH CROSS BARRIER PIPES
C....THIS SECTION RESTARTS THE PIPE FLOW COMPONENT
C....NOTE THAT PIPE FLOW COMPONENT IS ADDED INTO BARRIER FLOW COMPONENT
C....THAT WAS PREVIOUSLY SET
C...
        IF(NFLUXIBP.EQ.1) THEN
          DO I=1,NVEL
            IF((LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
              NNBB1=NBV(I)      ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
              NNBB2=IBCONN(I)   ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
C.............RESET INFORMATION FOR K-1 TIME LEVEL
              RBARWL1=ETA1(NNBB1)-PIPEHT(I)
              RBARWL2=ETA1(NNBB2)-PIPEHT(I)
              IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN ! WATER LEVEL BELOW PIPE
                QN1(I)=QN1(I)+0.0D0                                 ! NO FLOW
                GOTO 2002
              ENDIF
              IF(RBARWL1.EQ.RBARWL2) THEN ! WATER LEVEL EQUAL ON BOTH SIDES OF PIPE
                QN1(I)=QN1(I)+0.0D0                ! NO FLOW
                GOTO 2002
              ENDIF
              IF(RBARWL1.GT.RBARWL2) THEN ! WATER LEVEL GREATER ON THIS SIDE OF PIPE
                IF(RBARWL2.LE.0) THEN ! OUTWARD FREE DISCHARGE 
                  QN1(I)=QN1(I)-RAMP1*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL1/(1+PIPECOEF(I)))**0.5D0
                  GOTO 2002
                ELSE                        ! OUTWARD SUBMERGED DISCHARGE
                  QN1(I)=QN1(I)-RAMP1*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL1-RBARWL2)/PIPECOEF(I))**0.5D0
                  GOTO 2002
                ENDIF
              ENDIF
              IF(RBARWL2.GT.RBARWL1) THEN  ! WATER LEVEL LOWER ON THIS SIDE OF PIPE
                IF(RBARWL1.LE.0) THEN ! INWARD FREE DISCHARGE 
                  QN1(I)=QN1(I)+RAMP1*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL2/(1+PIPECOEF(I)))**0.5D0
                  GOTO 2002
                ELSE                         ! INWARD SUBMERGED DISCHARGE
                  QN1(I)=QN1(I)+RAMP1*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL2-RBARWL1)/PIPECOEF(I))**0.5D0
                  GOTO 2002
                ENDIF
              ENDIF
2002          CONTINUE
C.............RESET INFORMATION FOR K TIME LEVEL
              RBARWL1=ETA2(NNBB1)-PIPEHT(I)
              RBARWL2=ETA2(NNBB2)-PIPEHT(I)
              IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN ! WATER LEVEL BELOW PIPE
                QN2(I)=QN2(I)+0.0D0                                   ! NO FLOW
                GOTO 2003
              ENDIF
              IF(RBARWL1.EQ.RBARWL2) THEN ! WATER LEVEL EQUAL ON BOTH SIDES OF PIPE
                QN2(I)=QN2(I)+0.0D0                ! NO FLOW
                GOTO 2003
              ENDIF
              IF(RBARWL1.GT.RBARWL2) THEN ! WATER LEVEL GREATER ON THIS SIDE OF PIPE
                IF(RBARWL2.LE.0) THEN ! OUTWARD FREE DISCHARGE
                  QN2(I)=QN2(I)-RAMP2*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL1/(1+PIPECOEF(I)))**0.5D0
                  GOTO 2003
                ELSE                         ! OUTWARD SUBMERGED DISCHARGE
                  QN2(I)=QN2(I)-RAMP2*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL1-RBARWL2)/PIPECOEF(I))**0.5D0
                  GOTO 2003
                ENDIF
              ENDIF
              IF(RBARWL2.GT.RBARWL1) THEN !WATER LEVEL LOWER ON THIS SIDE OF PIPE
                IF(RBARWL1.LE.0) THEN ! INWARD FREE DISCHARGE
                  QN2(I)=QN2(I)+RAMP2*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL2/(1+PIPECOEF(I)))**0.5D0
                  GOTO 2003
                ELSE                         ! INWARD SUBMERGED DISCHARGE
                  QN2(I)=QN2(I)+RAMP2*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL2-RBARWL1)/PIPECOEF(I))**0.5D0
                  GOTO 2003
                ENDIF
              ENDIF
2003          CONTINUE
            ENDIF
          END DO
        ENDIF
cjjwm001 - end add    

C......RESTART WIND AND PRESSURE INFORMATION

        IF(NWS.EQ.1) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          DO J=1,ITHS
            DO I=1,NP
              READ(22,*) NHG,TAUSX2(I),TAUSY2(I),PR2(I)
              END DO
            END DO
          DO I=1,NP
            TAUSX2(I)=RAMP2*TAUSX2(I)
            TAUSY2(I)=RAMP2*TAUSY2(I)
            PR2(I)=RAMP2*PR2(I)
            END DO
          ENDIF

        IF(NWS.EQ.2) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = STATIM*86400.D0
          WTIME2 = WTIME1 + WTIMINC
          READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
          DO IT=1,ITHS
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.WTIME2) THEN
              WTIME1=WTIME2
              WTIME2=WTIME2+WTIMINC
              DO I=1,NP
                WVNX1(I)=WVNX2(I)
                WVNY1(I)=WVNY2(I)
                PRN1(I)=PRN2(I)
                READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
              END DO
            ENDIF
          END DO
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            TAUSX2(I) = RAMP2*WINDX
            TAUSY2(I) = RAMP2*WINDY
            PR2(I)=RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            END DO
          ENDIF

        IF(NWS.EQ.-2) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = TIME
          WTIME2 = WTIME1 + WTIMINC
          READ(22,*) (NHG,WVNX1(I),WVNY1(I),PRN1(I),I=1,NP)
          READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
          DO I=1,NP
            TAUSX2(I) = RAMP2*WVNX1(I)
            TAUSY2(I) = RAMP2*WVNY1(I)
            PR2(I)=RAMP2*PRN1(I)
            END DO
          ENDIF

        IF(NWS.EQ.3) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
 2223     CALL NWS3GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,IWTIME,IWYR,WTIMED,NP,
     *                 NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
          IF(IWYR.NE.IREFYR) THEN
            IWTIMEP=IWTIME
            DO I=1,NP
              WVNX1(I)=WVNX2(I)
              WVNY1(I)=WVNY2(I)
              END DO
            GOTO 2223
            ENDIF
          IF(WTIMED.LE.WREFTIM) THEN
            IWTIMEP=IWTIME
            DO I=1,NP
              WVNX1(I)=WVNX2(I)
              WVNY1(I)=WVNY2(I)
              END DO
            GOTO 2223
            ENDIF
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *         WRITE(6,*)'FOUND WIND DATA AT TIME= ',IWTIMEP
          WRITE(16,*) 'FOUND WIND DATA AT TIME =',IWTIMEP
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *         WRITE(6,*)'FOUND WIND DATA AT TIME= ',IWTIME
          WRITE(16,*) 'FOUND WIND DATA AT TIME =',IWTIME
          WTIME2=WTIMED-WREFTIM                    !CAST INTO MODEL TIME REFERENCE
          WTIME1=WTIME2-WTIMINC
          DO IT=1,ITHS
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.WTIME2) THEN
              WTIME1=WTIME2
              WTIME2=WTIME2+WTIMINC
              DO I=1,NP
                WVNX1(I)=WVNX2(I)
                WVNY1(I)=WVNY2(I)
                END DO
              CALL NWS3GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,IWTIME,IWYR,WTIMED,
     *              NP,NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *         WRITE(6,*)'WIND FILE ADVANCED TO TIME',' = ', IWTIME
              WRITE(16,*) 'WIND FILE ADVANCED TO TIME = ',IWTIME
              ENDIF
            END DO
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP                                !INTERPOLATE IN TIME
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG=SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I)=RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I)=RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            END DO
          ENDIF

        IF(NWS.EQ.4) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = STATIM*86400.D0
          WTIME2 = WTIME1 + WTIMINC
          CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
          DO IT=1,ITHS
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.WTIME2) THEN
              WTIME1=WTIME2
              WTIME2=WTIME2+WTIMINC
              DO I=1,NP
                WVNX1(I)=WVNX2(I)
                WVNY1(I)=WVNY2(I)
                PRN1(I)=PRN2(I)
                END DO
              CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
              ENDIF
            END DO
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            END DO
          ENDIF

        IF(NWS.EQ.-4) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = TIME
          WTIME2 = WTIME1 + WTIMINC
          CALL NWS4GET(WVNX1,WVNY1,PRN1,NP,RHOWAT0,G)
          CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
          DO I=1,NP
            WINDX = WVNX1(I)
            WINDY = WVNY1(I)
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*PRN1(I)
            END DO
          ENDIF

        IF(NWS.EQ.5) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = STATIM*86400.D0
          WTIME2 = WTIME1 + WTIMINC
          READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
          DO IT=1,ITHS
            TIMEIT=IT*DTDP + STATIM*86400.D0
            IF(TIMEIT.GT.WTIME2) THEN
              WTIME1=WTIME2
              WTIME2=WTIME2+WTIMINC
              DO I=1,NP
                WVNX1(I)=WVNX2(I)
                WVNY1(I)=WVNY2(I)
                PRN1(I)=PRN2(I)
                READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
              END DO
            ENDIF
          END DO
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I))) 
            END DO
          ENDIF

        IF(NWS.EQ.-5) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
          WTIME1 = TIME
          WTIME2 = WTIME1 + WTIMINC
          READ(22,*) (NHG,WVNX1(I),WVNY1(I),PRN1(I),I=1,NP)
          READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
          DO I=1,NP
            WINDX = WVNX1(I)
            WINDY = WVNY1(I)
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*PRN1(I) 
            END DO
          ENDIF

        IF(NWS.EQ.6) THEN
          OPEN(22,FILE=DIRNAME//'/'//'fort.22')
C   The following 3 lines are a hardwire to allow a non standard met file to be read in at 
C   time zero in a hot start.  They should be eliminated or commented out for normal operation
c         OPEN(199,FILE=DIRNAME//'/'//'fort.199')
c         READ(199,*) (NHG,PRN1(I),WVNX1(I),WVNY1(I),I=1,NP)
c         CLOSE(199)
C   The following CALL statement should be uncommented for normal operation
          CALL NWS6GET(X,Y,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,NWLON,NWLAT,
     *                 WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
          CALL NWS6GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,NWLON,NWLAT,
     *                 WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
          WTIME1=TIME
          WTIME2=WTIME1+WTIMINC
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            END DO
          ENDIF

        IF(NWS.EQ.10) THEN
          WTIME1=TIME
          WTIME2=WTIME1+WTIMINC
          NWSGGWI=-1
          CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,RHOWAT0,G,
     *                  NWLON,NWLAT,WTIMINC)
          NWSGGWI=0
          CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,RHOWAT0,G,
     *                  NWLON,NWLAT,WTIMINC)
          NWSGGWI=1
          CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,RHOWAT0,G,
     *                  NWLON,NWLAT,WTIMINC)
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            END DO
          ENDIF

        IF(NWS.EQ.11) THEN
          WTIME1=TIME
          WTIME2=WTIME1+WTIMINC
          NWSEGWI=0
          IDSETFLG=0
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1197)
          WRITE(16,1197)
          CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,
     *                  RHOWAT0,G)  !JUST COMPUTE INTERPOLATING FACTORS
          IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1198)
          WRITE(16,1198)
          NWSEGWI=0
          IDSETFLG=8
          CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,
     *                  RHOWAT0,G)  !NOW COMPUTE HOTSTART WIND FILED
          NWSEGWI=1
          IDSETFLG=1
          CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,
     *                  RHOWAT0,G)  !NOW COMPUTE NEXT WIND FIELD
          WTRATIO=(TIME-WTIME1)/WTIMINC
          DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TAUSX2(I) = RAMP2*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TAUSY2(I) = RAMP2*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP2*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            END DO
          ENDIF

C......RESTART THE WAVE RADIATION STRESS

        IF(NRS.EQ.1) THEN
          OPEN(23,FILE=DIRNAME//'/'//'fort.23')
          RSTIME1 = TIME
          RSTIME2 = RSTIME1 + RSTIMINC
          CALL RSGET(RSNX1,RSNY1,NP)
          CALL RSGET(RSNX2,RSNY2,NP)
          DO I=1,NP
            TAUSX2(I) = TAUSX2(I)+RAMP2*RSNX1(I)
            TAUSY2(I) = TAUSY2(I)+RAMP2*RSNY1(I)
            END DO
          ENDIF

       if (CTIP) then
Cjromo 11-01-00  Initialize TIP2 for HOTSTART
          DO I=1,NP
             TIP2(I)=0.0
          END DO
CTIP  LINES TO USE TIDAL POTENTIAL FORCING
       IF(NTIP.GE.1) THEN
         DO J=1,NTIF
           IF(PERT(J).EQ.0.) THEN
             NCYC=0
             ELSE
             NCYC=INT(TIME/PERT(J))
             ENDIF
           ARGT=AMIGT(J)*(TIME-NCYC*PERT(J))+FACET(J)
           TPMUL=RAMP2*ETRF(J)*TPK(J)*FFT(J)
           SALTMUL=RAMP2*FFT(J)
           NA=NINT(0.00014/AMIGT(J))
           IF(NA.EQ.1) THEN                        !SEMI-DIURNAL SPECIES
             DO I=1,NP
               ARGTP=ARGT+2.*SLAM(I)
               ARGSALT=ARGT-SALTPHA(J,I)
               CCSFEA=COS(SFEA(I))
               CCSFEA=CCSFEA*CCSFEA
               TIP2(I)=TIP2(I)+TPMUL*CCSFEA*COS(ARGTP)
     *                 +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
             ENDIF
           IF(NA.EQ.2) THEN
             DO I=1,NP
               ARGTP=ARGT+SLAM(I)
               ARGSALT=ARGT-SALTPHA(J,I)
cjjw/vjpm002 - modified/added the following 5 lines

               S2SFEA=SIN(2.e0*SFEA(I))

               TIP2(I)=TIP2(I)+TPMUL*S2SFEA*COS(ARGTP)
     *                +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
             ENDIF
           END DO
         ENDIF
      endif     !   CTIP


C...
C....SET UP TO RESTART TIMESERIES OUTPUT FILES
C....
C...
        IF(NBYTE.EQ.4) ITEMPSTP=20
        IF(NBYTE.EQ.8) ITEMPSTP=10

C...
C....IF RESTARTING THE ELEVATION STATION OUTPUT FILE, GO TO THE PROPER PLACE
C....IN THE FILE.  OTHERWISE ZERO OUT NSCOUE.
C...
        READ(IHOT,REC=IHOTSTP+1) IESTP
        READ(IHOT,REC=IHOTSTP+2) NSCOUE
        IHOTSTP=IHOTSTP+2
        WRITE(16,1040) IESTP,NSCOUE
 1040   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN ELEVATION ',
     *                  'STATION FILE BY THE TIME OF THE HOT START',
     *             /,8X,'SPOOL COUNTER = ',I6)
        IF(NOUTE.LT.0) THEN
          IESTP=0
          NSCOUE=0
          IF((NTCYSE.LT.ITHS).AND.(NSPOOLE.GT.0)) THEN
            NTCYSE=NTCYSE+((ITHS-NTCYSE)/NSPOOLE)*NSPOOLE
            IF(NTCYSE.LT.ITHS) NTCYSE=NTCYSE+NSPOOLE
            IF(NSPOOLE.NE.0) NTRSPE=(NTCYFE-NTCYSE)/NSPOOLE
            ENDIF
          WRITE(16,1041)
 1041     FORMAT(//,' A NEW ELEVATION STATION FILE WILL BE STARTED')
          ENDIF

        IF(NOUTE.EQ.-2) THEN
          OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(61,REC=IESTP+I) RDES4(I)
              ENDDO
            IESTP=IESTP+8
            DO I=1,6
              WRITE(61,REC=IESTP+I) RID4(I)
              ENDDO
            IESTP=IESTP+6
            DO I=1,6
              WRITE(61,REC=IESTP+I) AID4(I)
              ENDDO
            IESTP=IESTP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(61,REC=IESTP+I) RDES8(I)
              ENDDO
            IESTP=IESTP+4
            DO I=1,3
              WRITE(61,REC=IESTP+I) RID8(I)
              ENDDO
            IESTP=IESTP+3
            DO I=1,3
              WRITE(61,REC=IESTP+I) AID8(I)
              ENDDO
            IESTP=IESTP+3
            ENDIF
          WRITE(61,REC=IESTP+1) NTRSPE
          WRITE(61,REC=IESTP+2) NSTAE
          WRITE(61,REC=IESTP+3) DT*NSPOOLE
          WRITE(61,REC=IESTP+4) NSPOOLE
          WRITE(61,REC=IESTP+5) 1
          IESTP=IESTP+5
          CLOSE(61)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTE.EQ.-1) THEN
          OPEN(61,FILE=DIRNAME//'/'//'fort.61')
          WRITE(61,3220) RUNDES,RUNID,AGRID
          WRITE(61,3645) NTRSPE,NSTAE,DTDP*NSPOOLE,NSPOOLE,1
          IESTP=2
          ENDIF
        IF(NOUTE.EQ.1) THEN
          OPEN(61,FILE=DIRNAME//'/'//'fort.61')
          DO I=1,IESTP          !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NTRSPE
 1050       FORMAT(1X)
            READ(61,1050)
            ENDDO
          ENDIF
        IF(NOUTE.EQ.2) THEN
          OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(61,REC=ITEMPSTP+1) NTRSPE   ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(61)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE VELOCITY STATION OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) IVSTP
        READ(IHOT,REC=IHOTSTP+2) NSCOUV
        IHOTSTP=IHOTSTP+2
        WRITE(16,1042) IVSTP,NSCOUV
 1042   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN VELOCITY ',
     *                  'STATION FILE BY THE TIME OF THE HOT START',
     *          /,8X,'SPOOL COUNTER =',I6)
        IF(NOUTV.LT.0) THEN
          IVSTP=0
          NSCOUV=0
          IF((NTCYSV.LT.ITHS).AND.(NSPOOLV.GT.0)) THEN
            NTCYSV=NTCYSV+((ITHS-NTCYSV)/NSPOOLV)*NSPOOLV
            IF(NTCYSV.LT.ITHS) NTCYSV=NTCYSV+NSPOOLV
            NTRSPV=(NTCYFV-NTCYSV)/NSPOOLV
            ENDIF
          WRITE(16,1043)
 1043     FORMAT(//,' A NEW VELOCITY STATION FILE WILL BE STARTED')
          ENDIF

        IF(NOUTV.EQ.-2) THEN
          OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(62,REC=IVSTP+I) RDES4(I)
              ENDDO
            IVSTP=IVSTP+8
            DO I=1,6
              WRITE(62,REC=IVSTP+I) RID4(I)
              ENDDO
            IVSTP=IVSTP+6
            DO I=1,6
              WRITE(62,REC=IVSTP+I) AID4(I)
              ENDDO
            IVSTP=IVSTP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(62,REC=IVSTP+I) RDES8(I)
              ENDDO
            IVSTP=IVSTP+4
            DO I=1,3
              WRITE(62,REC=IVSTP+I) RID8(I)
              ENDDO
            IVSTP=IVSTP+3
            DO I=1,3
              WRITE(62,REC=IVSTP+I) AID8(I)
              ENDDO
            IVSTP=IVSTP+3
            ENDIF
          WRITE(62,REC=IVSTP+1) NTRSPV
          WRITE(62,REC=IVSTP+2) NSTAV
          WRITE(62,REC=IVSTP+3) DT*NSPOOLV
          WRITE(62,REC=IVSTP+4) NSPOOLV
          WRITE(62,REC=IVSTP+5) 2
          IVSTP=IVSTP+5
          CLOSE(62)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTV.EQ.-1) THEN
          OPEN(62,FILE=DIRNAME//'/'//'fort.62')
          WRITE(62,3220) RUNDES,RUNID,AGRID
          WRITE(62,3645) NTRSPV,NSTAV,DTDP*NSPOOLV,NSPOOLV,2
          IVSTP=2
          ENDIF
        IF(NOUTV.EQ.1) THEN
          OPEN(62,FILE=DIRNAME//'/'//'fort.62')
          DO I=1,IVSTP          !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NTRSPV
            READ(62,1050)
            ENDDO
          ENDIF
        IF(NOUTV.EQ.2) THEN
          OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(62,REC=ITEMPSTP+1) NTRSPV   ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(62)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE CONCENTRATION STATION OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) ICSTP
        READ(IHOT,REC=IHOTSTP+2) NSCOUC
        IHOTSTP=IHOTSTP+2
        WRITE(16,1044) ICSTP,NSCOUC
 1044   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN CONCENTRATION ',
     *                  'STATION FILE BY THE TIME OF THE HOT START',
     *          /,8X,'SPOOL COUNTER = ',I6)
        IF(NOUTC.LT.0) THEN
          ICSTP=0
          NSCOUC=0
          IF((NTCYSC.LT.ITHS).AND.(NSPOOLC.GT.0)) THEN
            NTCYSC=NTCYSC+((ITHS-NTCYSC)/NSPOOLC)*NSPOOLC
            IF(NTCYSC.LT.ITHS) NTCYSC=NTCYSC+NSPOOLC
            NTRSPC=(NTCYFC-NTCYSC)/NSPOOLC
            ENDIF
          WRITE(16,1045)
 1045     FORMAT(//,' A NEW CONCENTRATION STATION FILE WILL BE STARTED')
          ENDIF

        IF(NOUTC.EQ.-2) THEN
          OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(81,REC=ICSTP+I) RDES4(I)
              ENDDO
            ICSTP=ICSTP+8
            DO I=1,6
              WRITE(81,REC=ICSTP+I) RID4(I)
              ENDDO
            ICSTP=ICSTP+6
            DO I=1,6
              WRITE(81,REC=ICSTP+I) AID4(I)
              ENDDO
            ICSTP=ICSTP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(81,REC=ICSTP+I) RDES8(I)
              ENDDO
            ICSTP=ICSTP+4
            DO I=1,3
              WRITE(81,REC=ICSTP+I) RID8(I)
              ENDDO
            ICSTP=ICSTP+3
            DO I=1,3
              WRITE(81,REC=ICSTP+I) AID8(I)
              ENDDO
            ICSTP=ICSTP+3
            ENDIF
          WRITE(81,REC=ICSTP+1) NTRSPC
          WRITE(81,REC=ICSTP+2) NSTAC
          WRITE(81,REC=ICSTP+3) DT*NSPOOLC
          WRITE(81,REC=ICSTP+4) NSPOOLC
          WRITE(81,REC=ICSTP+5) 1
          ICSTP=ICSTP+5
          CLOSE(81)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTC.EQ.-1) THEN
          OPEN(81,FILE='fort.81')
          WRITE(81,3220) RUNDES,RUNID,AGRID
          WRITE(81,3645) NTRSPC,NSTAC,DTDP*NSPOOLC,NSPOOLC,1
          ICSTP=2
          ENDIF
        IF(NOUTC.EQ.1) THEN
          OPEN(81,FILE=DIRNAME//'/'//'fort.81')
          DO I=1,ICSTP          !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NTRSPC
            READ(81,1050)
            ENDDO
          ENDIF
        IF(NOUTC.EQ.2) THEN
          OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *          ACCESS='DIRECT',RECL=NBYTE)
crevisit          WRITE(81,REC=ITEMPSTP+1) NTRSPC   ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(81)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE METEOROLOGICAL STATION OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) IPSTP
        READ(IHOT,REC=IHOTSTP+2) IWSTP
        READ(IHOT,REC=IHOTSTP+3) NSCOUM
        IHOTSTP=IHOTSTP+3
        WRITE(16,1038) IWSTP,IPSTP,NSCOUM
 1038   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN THE WIND STATION',
     *                  ' FILE BY THE TIME OF THE HOT START',
     *          /,1X,I6,' LINES OR RECORDS WRITTIN IN THE PRES STATION',
     *                  ' FILE BY THE TMIE OF THE HOT START',
     *          /,8X,'SPOOL COUNTER = ',I6)
        IF(NOUTM.LT.0) THEN
          IPSTP=0
          IWSTP=0
          NSCOUM=0
          IF((NTCYSM.LT.ITHS).AND.(NSPOOLM.GT.0)) THEN
            NTCYSM=NTCYSM+((ITHS-NTCYSM)/NSPOOLM)*NSPOOLM
            IF(NTCYSM.LT.ITHS) NTCYSM=NTCYSM+NSPOOLM
            NTRSPM=(NTCYFM-NTCYSM)/NSPOOLM
            ENDIF
          WRITE(16,1039)
 1039    FORMAT(//,' A NEW METEOROLOGICAL STATION FILE WILL BE STARTED')
          ENDIF

        IF(NOUTM.EQ.-2) THEN
          OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *          ACCESS='DIRECT',RECL=NBYTE)
          OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(71,REC=IPSTP+I) RDES4(I)
              WRITE(72,REC=IWSTP+I) RDES4(I)
              ENDDO
            IPSTP=IPSTP+8
            IWSTP=IWSTP+8
            DO I=1,6
              WRITE(71,REC=IPSTP+I) RID4(I)
              WRITE(72,REC=IWSTP+I) RID4(I)
              ENDDO
            IPSTP=IPSTP+6
            IWSTP=IWSTP+6
            DO I=1,6
              WRITE(71,REC=IPSTP+I) AID4(I)
              WRITE(72,REC=IWSTP+I) AID4(I)
              ENDDO
            IPSTP=IPSTP+6
            IWSTP=IWSTP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(71,REC=IPSTP+I) RDES8(I)
              WRITE(72,REC=IWSTP+I) RDES8(I)
              ENDDO
            IPSTP=IPSTP+4
            IWSTP=IWSTP+4
            DO I=1,3
              WRITE(71,REC=IPSTP+I) RID8(I)
              WRITE(72,REC=IWSTP+I) RID8(I) 
              ENDDO
            IPSTP=IPSTP+3
            IWSTP=IWSTP+3
            DO I=1,3
              WRITE(71,REC=IPSTP+I) AID8(I)
              WRITE(72,REC=IWSTP+I) AID8(I)
              ENDDO
            IPSTP=IPSTP+3
            IWSTP=IWSTP+3
            ENDIF
          WRITE(71,REC=IPSTP+1) NTRSPM
          WRITE(71,REC=IPSTP+2) NSTAM
          WRITE(71,REC=IPSTP+3) DT*NSPOOLM
          WRITE(71,REC=IPSTP+4) NSPOOLM
          WRITE(71,REC=IPSTP+5) 1
          WRITE(72,REC=IWSTP+1) NTRSPM
          WRITE(72,REC=IWSTP+2) NSTAM
          WRITE(72,REC=IWSTP+3) DT*NSPOOLM
          WRITE(72,REC=IWSTP+4) NSPOOLM
          WRITE(72,REC=IWSTP+5) 2
          IPSTP=IPSTP+5
          IWSTP=IWSTP+5
          CLOSE(71)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          CLOSE(72)
          OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *         ACCESS='DIRECT',RECL=NBYTE)
          OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTM.EQ.-1) THEN
          OPEN(71,FILE='fort.71')
          OPEN(72,FILE='fort.72')
          WRITE(71,3220) RUNDES,RUNID,AGRID
          WRITE(71,3645) NTRSPM,NSTAM,DTDP*NSPOOLM,NSPOOLM,1
          WRITE(72,3220) RUNDES,RUNID,AGRID
          WRITE(72,3645) NTRSPM,NSTAM,DTDP*NSPOOLM,NSPOOLM,1
          IPSTP=2
          IWSTP=2
          ENDIF
        IF(NOUTM.EQ.1) THEN
          OPEN(71,FILE=DIRNAME//'/'//'fort.71')
          OPEN(72,FILE=DIRNAME//'/'//'fort.72')
          DO I=1,IPSTP          !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NTRSPM
            READ(71,1050)
            ENDDO
          DO I=1,IWSTP          !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NTRSPM
            READ(72,1050)
            ENDDO
          ENDIF
        IF(NOUTM.EQ.2) THEN
          OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *          ACCESS='DIRECT',RECL=NBYTE)
          OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *          ACCESS='DIRECT',RECL=NBYTE)
crevisit          WRITE(71,REC=ITEMPSTP+1) NTRSPM   ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
crevisit          WRITE(72,REC=ITMEPSTP+1) NTRSPM
          CLOSE(71)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          CLOSE(72)
          OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *         ACCESS='DIRECT',RECL=NBYTE)
          OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE GLOBAL ELEVATION OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) IGEP
        READ(IHOT,REC=IHOTSTP+2) NSCOUGE
        IHOTSTP=IHOTSTP+2
        WRITE(16,1046) IGEP,NSCOUGE
 1046   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN THE GLOBAL ',
     *                  'ELEVATION FILE BY THE TIME OF THE HOT START',
     *          /,8X,'SPOOL COUNTER =',I6)
        IF(NOUTGE.LT.0) THEN
          IGEP=0
          NSCOUGE=0
          IF((NTCYSGE.LT.ITHS).AND.(NSPOOLGE.GT.0)) THEN
            NTCYSGE=NTCYSGE+((ITHS-NTCYSGE)/NSPOOLGE)*NSPOOLGE
            IF(NTCYSGE.LT.ITHS) NTCYSGE=NTCYSGE+NSPOOLGE
            NDSETSE=(NTCYFGE-NTCYSGE)/NSPOOLGE
            ENDIF
          WRITE(16,1047)
 1047     FORMAT(//,' A NEW GLOBAL ELEVATION FILE WILL BE STARTED')
          ENDIF

        IF(NOUTGE.EQ.-2) THEN
          OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(63,REC=IGEP+I) RDES4(I)
              ENDDO
            IGEP=IGEP+8
            DO I=1,6
              WRITE(63,REC=IGEP+I) RID4(I)
              ENDDO
            IGEP=IGEP+6
            DO I=1,6
              WRITE(63,REC=IGEP+I) AID4(I)
              ENDDO
            IGEP=IGEP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(63,REC=IGEP+I) RDES8(I)
              ENDDO
            IGEP=IGEP+4
            DO I=1,3
              WRITE(63,REC=IGEP+I) RID8(I)
              ENDDO
            IGEP=IGEP+3
            DO I=1,3
              WRITE(63,REC=IGEP+I) AID8(I)
              ENDDO
            IGEP=IGEP+3
            ENDIF
          WRITE(63,REC=IGEP+1) NDSETSE
          WRITE(63,REC=IGEP+2) NP
          WRITE(63,REC=IGEP+3) DT*NSPOOLGE
          WRITE(63,REC=IGEP+4) NSPOOLGE
          WRITE(63,REC=IGEP+5) 1
          IGEP=IGEP+5
          CLOSE(63)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTGE.EQ.-1) THEN
          OPEN(63,FILE=DIRNAME//'/'//'fort.63')
          WRITE(63,3220) RUNDES,RUNID,AGRID
          WRITE(63,3645) NDSETSE,NP,DTDP*NSPOOLGE,NSPOOLGE,1
          IGEP=2
          ENDIF
        IF(NOUTGE.EQ.1) THEN
          OPEN(63,FILE=DIRNAME//'/'//'fort.63')
          DO I=1,IGEP           !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NDSETSE
            READ(63,1050)
            ENDDO
          ENDIF
        IF(NOUTGE.EQ.2) THEN
          OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(63,REC=ITEMPSTP+1) NDSETSE  ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(63)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE GLOBAL VELOCITY OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) IGVP
        READ(IHOT,REC=IHOTSTP+2) NSCOUGV
        IHOTSTP=IHOTSTP+2
        WRITE(16,1048) IGVP,NSCOUGV
 1048   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN THE GLOBAL ',
     *                  'VELOCITY FILE BY THE TIME OF THE HOT START',
     *          /,8X,'SPOOL COUNTER =',I6)
        IF(NOUTGV.LT.0) THEN
          IGVP=0
          NSCOUGV=0
          IF((NTCYSGV.LT.ITHS).AND.(NSPOOLGV.GT.0)) THEN
            NTCYSGV=NTCYSGV+((ITHS-NTCYSGV)/NSPOOLGV)*NSPOOLGV
            IF(NTCYSGV.LT.ITHS) NTCYSGV=NTCYSGV+NSPOOLGV
            NDSETSV=(NTCYFGV-NTCYSGV)/NSPOOLGV
            ENDIF
          WRITE(16,1049)
 1049     FORMAT(//,' A NEW GLOBAL VELOCITY FILE WILL BE STARTED')
          ENDIF

        IF(NOUTGV.EQ.-2) THEN
          OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(64,REC=IGVP+I) RDES4(I)
              ENDDO
            IGVP=IGVP+8
            DO I=1,6
              WRITE(64,REC=IGVP+I) RID4(I)
              ENDDO
            IGVP=IGVP+6
            DO I=1,6
              WRITE(64,REC=IGVP+I) AID4(I)
              ENDDO
            IGVP=IGVP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(64,REC=IGVP+I) RDES8(I)
              ENDDO
            IGVP=IGVP+4
            DO I=1,3
              WRITE(64,REC=IGVP+I) RID8(I)
              ENDDO
            IGVP=IGVP+3
            DO I=1,3
              WRITE(64,REC=IGVP+I) AID8(I)
              ENDDO
            IGVP=IGVP+3
            ENDIF
          WRITE(64,REC=IGVP+1) NDSETSV
          WRITE(64,REC=IGVP+2) NP
          WRITE(64,REC=IGVP+3) DT*NSPOOLGV
          WRITE(64,REC=IGVP+4) NSPOOLGV
          WRITE(64,REC=IGVP+5) 2
          IGVP=IGVP+5
          CLOSE(64)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
       IF(NOUTGV.EQ.-1) THEN
          OPEN(64,FILE=DIRNAME//'/'//'fort.64')
          WRITE(64,3220) RUNDES,RUNID,AGRID
          WRITE(64,3645) NDSETSV,NP,DTDP*NSPOOLGV,NSPOOLGV,2
          IGVP=2
          ENDIF
        IF(NOUTGV.EQ.1) THEN
          OPEN(64,FILE=DIRNAME//'/'//'fort.64')
          DO I=1,IGVP           !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NDSETSV
            READ(64,1050)
            ENDDO
          ENDIF
        IF(NOUTGV.EQ.2) THEN
          OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(64,REC=ITEMPSTP+1) NDSETSV  ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(64)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE GLOBAL CONCENTRATION OUTPUT FILE
C...
        READ(IHOT,REC=IHOTSTP+1) IGCP
        READ(IHOT,REC=IHOTSTP+2) NSCOUGC
        IHOTSTP=IHOTSTP+2
        WRITE(16,1053) IGCP,NSCOUGC
 1053   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN THE GLOBAL ',
     *                'CONCENTRATION FILE BY THE TIME OF THE HOT START',
     *          /,8X,'SPOOL COUNTER =',I6)
        IF(NOUTGC.LT.0) THEN
          IGCP=0
          NSCOUGC=0
          IF((NTCYSGC.LT.ITHS).AND.(NSPOOLGC.GT.0)) THEN
            NTCYSGC=NTCYSGC+((ITHS-NTCYSGC)/NSPOOLGC)*NSPOOLGC
            IF(NTCYSGC.LT.ITHS) NTCYSGC=NTCYSGC+NSPOOLGC
            NDSETSC=(NTCYFGC-NTCYSGC)/NSPOOLGC
            ENDIF
          WRITE(16,1054)
 1054     FORMAT(//,' A NEW GLOBAL CONCENTRATION FILE WILL BE STARTED')
          ENDIF

         IF(NOUTGC.EQ.-2) THEN
          OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *           ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              WRITE(83,REC=IGCP+I) RDES4(I)
              ENDDO
            IGCP=IGCP+8
            DO I=1,6
              WRITE(83,REC=IGCP+I) RID4(I)
              ENDDO
            IGCP=IGCP+6
            DO I=1,6
              WRITE(83,REC=IGCP+I) AID4(I)
              ENDDO
            IGCP=IGCP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              WRITE(83,REC=IGCP+I) RDES8(I)
              ENDDO
            IGCP=IGCP+4
            DO I=1,3
              WRITE(83,REC=IGCP+I) RID8(I)
              ENDDO
            IGCP=IGCP+3
            DO I=1,3
              WRITE(83,REC=IGCP+I) AID8(I)
              ENDDO
            IGCP=IGCP+3
            ENDIF
          WRITE(83,REC=IGCP+1) NDSETSC
          WRITE(83,REC=IGCP+2) NP
          WRITE(83,REC=IGCP+3) DT*NSPOOLGC
          WRITE(83,REC=IGCP+4) NSPOOLGC
          WRITE(83,REC=IGCP+5) 1
          IGCP=IGCP+5
          CLOSE(83)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTGC.EQ.-1) THEN
          OPEN(83,FILE=DIRNAME//'/'//'fort.83')
          WRITE(83,3220) RUNDES,RUNID,AGRID
          WRITE(83,3645) NDSETSC,NP,DTDP*NSPOOLGC,NSPOOLGC,1
          IGCP=2
          ENDIF
        IF(NOUTGC.EQ.1) THEN
          OPEN(83,FILE=DIRNAME//'/'//'fort.83')
          DO I=1,IGCP           !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NDSETSC
            READ(83,1050)
            ENDDO
          ENDIF
        IF(NOUTGC.EQ.2) THEN
          OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(83,REC=ITEMPSTP+1) NDSETSC  ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(83)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF

C...
C....GO TO THE PROPER PLACE IN THE GLOBAL METEOROLOGICAL OUTPUT FILES
C...
        READ(IHOT,REC=IHOTSTP+1) IGPP
        READ(IHOT,REC=IHOTSTP+2) IGWP
        READ(IHOT,REC=IHOTSTP+3) NSCOUGW
        IHOTSTP=IHOTSTP+3
        WRITE(16,1055) IGWP,IGPP,NSCOUGW
 1055   FORMAT(//,1X,I6,' LINES OR RECORDS WRITTEN IN THE GLOBAL ',
     *                  'WIND FILE BY THE TIME OF THE HOT START',
     *          /,1X,I6,'LINES OR RECORDS WRITTEN IN THE GLOBAL ',
     *                  'PRESSURE FILE BY THE TIME OF THE HOT START',   
     *          /,8X,'SPOOL COUNTER =',I6)
        IF(NOUTGW.LT.0) THEN
          igpp=0
          IGWP=0
          NSCOUGW=0
          IF((NTCYSGW.LT.ITHS).AND.(NSPOOLGW.GT.0)) THEN
            NTCYSGW=NTCYSGW+((ITHS-NTCYSGW)/NSPOOLGW)*NSPOOLGW
            IF(NTCYSGW.LT.ITHS) NTCYSGW=NTCYSGW+NSPOOLGW
            NDSETSW=(NTCYFGW-NTCYSGW)/NSPOOLGW
            ENDIF
          WRITE(16,1056)
 1056     FORMAT(//,' NEW GLOBAL WIND & pressure FILEs WILL BE STARTED')
          ENDIF

        IF(NOUTGW.EQ.-2) THEN
          open(73,file=dirname//'/'//'fort.73',
     *          access='direct',recl=nbyte)
          OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *          ACCESS='DIRECT',RECL=NBYTE)
          IF(NBYTE.EQ.4) THEN
            DO I=1,8
              write(73,rec=igpp+i) rdes4(i)
              WRITE(74,REC=IGWP+I) RDES4(I)
              ENDDO
            igpp=igpp+8
            IGWP=IGWP+8
            DO I=1,6
              write(73,rec=igpp+i) rid4(i)
              WRITE(74,REC=IGWP+I) RID4(I)
              ENDDO
            igpp=igpp+6
            IGWP=IGWP+6
            DO I=1,6
              write(73,rec=igpp+i) aid4(i)
              WRITE(74,REC=IGWP+I) AID4(I)
              ENDDO
            igpp=igpp+6
            IGWP=IGWP+6
            ENDIF
          IF(NBYTE.EQ.8) THEN
            DO I=1,4
              write(73,rec=igpp+i) rdes8(i)
              WRITE(74,REC=IGWP+I) RDES8(I)
              ENDDO
            igpp=igpp+4
            IGWP=IGWP+4
            DO I=1,3
              write(73,rec=igpp+i) rid8(i)
              WRITE(74,REC=IGWP+I) RID8(I)
              ENDDO
            igpp=igpp+3
            IGWP=IGWP+3
            DO I=1,3
              write(73,rec=igpp+i) aid8(i)
              WRITE(74,REC=IGWP+I) AID8(I)
              ENDDO
            igpp=igpp+3
            IGWP=IGWP+3
            ENDIF
          write(73,rec=igpp+1) ndsetsw
          write(73,rec=igpp+2) np
          write(73,rec=igpp+3) dt*nspoolgw
          write(73,rec=igpp+4) nspoolgw
          write(73,rec=igpp+5) 2
          igpp=igpp+5
          close(73)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          open(73,file=dirname//'/'//'fort.73',
     *         access='direct',recl=nbyte)
          WRITE(74,REC=IGWP+1) NDSETSW
          WRITE(74,REC=IGWP+2) NP
          WRITE(74,REC=IGWP+3) DT*NSPOOLGW
          WRITE(74,REC=IGWP+4) NSPOOLGW
          WRITE(74,REC=IGWP+5) 2
          IGWP=IGWP+5
          CLOSE(74)                    ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF
        IF(NOUTGW.EQ.-1) THEN
          open(73,file=dirname//'/'//'fort.73')
          write(73,3220) rundes,runid,agird
          write(73,3645) ndsetsw,np,dtdp*nspoolgw,nspoolgw,1
          igpp=2
          OPEN(74,FILE=DIRNAME//'/'//'fort.74')
          WRITE(74,3220) RUNDES,RUNID,AGRID
          WRITE(74,3645) NDSETSW,NP,DTDP*NSPOOLGW,NSPOOLGW,2
          IGWP=2
          ENDIF
        IF(NOUTGW.EQ.1) THEN
          OPEN(73,FILE=DIRNAME//'/'//'fort.73')
          do i=1,igpp           !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NDSETSW
            read(73,1050)
            enddo          
          OPEN(74,FILE=DIRNAME//'/'//'fort.74')
          DO I=1,IGWP           !I DON'T KNOW OF A PRACTICAL WAY TO CHANGE NDSETSW
            READ(74,1050)
            ENDDO
          ENDIF
        IF(NOUTGW.EQ.2) THEN
          open(73,file=dirname//'/'//'fort.73',
     *          access='direct',recl=nbyte)
          write(73,REC=itempstp+1) ndsetsw  ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          close(73)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          open(73,file=dirname//'/'//'fort.73',
     *         access='direct',recl=nbyte)
          OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *          ACCESS='DIRECT',RECL=NBYTE)
          WRITE(74,REC=ITEMPSTP+1) NDSETSW  ! ALLOW ADDITIONAL OUTPUT DATA TO BE WRITTEN
          CLOSE(74)                         ! DO THIS TO FLUSH THE WRITE BUFFER
          OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *         ACCESS='DIRECT',RECL=NBYTE)
          ENDIF


C...
C......HOT START INFORMATION FOR HARMONIC ANALYSIS
C...
        IF(IHARIND.EQ.1) THEN
          IHABEG=ITHAS+NHAINC
C...
C........IF HARMONIC ANALYSIS HAS NOT BEGUN, COLD START THE HARMONIC ANALYSIS
C...
          IF(ITHS.LT.IHABEG) THEN
            ICHA=0
            CALL HACOLDS(HAFREQ)
            IF(NHASE.EQ.1) CALL HACOLDSES(NSTAE)
            IF(NHASV.EQ.1) CALL HACOLDSVS(NSTAV)
            IF(NHAGE.EQ.1) CALL HACOLDSEG(NP)
            IF(NHAGV.EQ.1) CALL HACOLDSVG(NP)
            IF ( CHARMV) THEN
              DO I=1,NP
                 ELAV(I)=0.D0
                 XVELAV(I)=0.D0
                 YVELAV(I)=0.D0
                 ELVA(I)=0.D0
                 XVELVA(I)=0.D0
                 YVELVA(I)=0.D0
              END DO
             ENDIF   !   charmv

           ENDIF

C...
C........IF HARMONIC ANALYSIS HAS ALREADY BEGUN, READ IN HOT START
C........HARMONIC ANALYSIS, MEAN AND SQUARE INFO
C...
          IF(ITHS.GT.ITHAS) THEN
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) ICHA
            ENDIF
          IF(ITHS.GE.IHABEG) THEN
            CALL HAHOTS(NSTAE,NSTAV,NP,NHASE,NHASV,NHAGE,NHAGV,
     *                  NSCREEN,IHOTSTP,IHOT,MYPROC)
            IF(NHASE.EQ.1) CALL HAHOTSES(NSTAE,IHOTSTP,IHOT)
            IF(NHASV.EQ.1) CALL HAHOTSVS(NSTAV,IHOTSTP,IHOT)
            IF(NHAGE.EQ.1) CALL HAHOTSEG(NP,IHOTSTP,IHOT)
            IF(NHAGV.EQ.1) CALL HAHOTSVG(NP,IHOTSTP,IHOT)
          ENDIF

C..Read in Means and Squares

        if( CHARMV) then
          IF((FMV.NE.0.).AND.(ITHS.GT.ITMV)) THEN
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) NTSTEPS
            IF(NHAGE.EQ.1) THEN
              DO I=1,NP
                READ(IHOT,REC=IHOTSTP+1) ELAV(I)
                READ(IHOT,REC=IHOTSTP+2) ELVA(I)
                IHOTSTP=IHOTSTP+2
                ENDDO
              ENDIF
            IF(NHAGV.EQ.1) THEN
              DO I=1,NP
                READ(IHOT,REC=IHOTSTP+1) XVELAV(I)
                READ(IHOT,REC=IHOTSTP+2) YVELAV(I)
                READ(IHOT,REC=IHOTSTP+3) XVELVA(I)
                READ(IHOT,REC=IHOTSTP+4) YVELVA(I)
                IHOTSTP=IHOTSTP+4
                ENDDO
              ENDIF
            ENDIF
       endif   !  charmv


          ENDIF


       IF(C3DVS) THEN
         CALL VSSTUP(DT,NT)
       ELSEIF(C3DDSS) THEN
c         CALL DSSSTUP(DT,NT)
       ENDIF

      CLOSE(IHOT)
C
 1112 FORMAT(/,1X,79('_'))
 1197 FORMAT(/,1X,'THE E29 MET GRID INTERPOLATING FACTORS ARE ',
     *                'BEING COMPUTED ')
 1198     FORMAT(1X,'FINISHED COMPUTING E29 INTERPOLATING FACTORS',/)
 3220 FORMAT(1X,A32,2X,A24,2X,A24)
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END
C**************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001 
C    last changes in this file VERSION 41.11
C
C  mod history
C  v41.06mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx
C
C  v41.11 - 09/14/01 - rl - from 41.09 - modified for NWS=-2
C  v41.09 - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05 
C  v41.08 - 06/22/01 - rl - from 41.07 - added 41.05m009 changes to HABSMIN
C                                        and ETA2
C  v41.07 - 04/09/01 - rl - from 41.06 - initialized PRN1(), PRN2() for NRS<>0
C**************************************************************************
C
      SUBROUTINE COLDSTART()
C
C**************************************************************************
C
C  COLD START PROGRAM SETUP ROUTINE 
C
C**************************************************************************
C
      USE GLOBAL
      USE HARM
      USE WIND
      IMPLICIT NONE
C
      ITHS = 0
C...
C...  SET AT REST INITIAL CONDITION OVER WHOLE DOMAIN
C...  IF BOTTOM IS ABOVE THE GEIOD -> DRY NODE
C...
C...  IF BOTTOM IS INITIALLY BELOW THE GEIOD AND STARTDRY=-88888 -> DRY
C...  NODE
C...
      HABSMIN=0.8d0*H0
      DO I=1,NP
         UBAR1(I) =0.D0
         VBAR1(I) =0.D0
         UBAR2(I) =0.D0
         VBAR2(I) =0.D0
         ETA2(I)=0.D0
         NODEREP(I)=MAX0(NODEWETMIN,NODEDRYMIN)
         NNODECODE(I)=1
         IF(NOLIFA.EQ.2) THEN
            HTOT=DP(I)+ETA2(I)
            IF(HTOT.LE.H0) THEN
               NNODECODE(I)=0
               ETA2(I)=H0-DP(I)
            ELSE
               IF(STARTDRY(I).EQ.-88888) THEN
                  NNODECODE(I)=0
                  ETA2(I)=H0-DP(I) 
               ENDIF
            ENDIF
         ENDIF
         ETA1(I)=ETA2(I)
         ETAS(I)=0.D0
         CH1(I)=0.d0
      END DO
C...  
C...  INITIALIZE THE ELEVATION SPECIFIED BOUNDARY CONDITION IF IT
C...  REQUIRES THE USE OF THE UNIT 19 FILE.
C...  
      IF((NOPE.GT.0).AND.(NBFR.EQ.0)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
         WRITE(16,1112)
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1977)
         WRITE(16,1977)
 1977    FORMAT(/,1X,'ELEVATION SPECIFIED INFORMATION READ FROM UNIT ',
     *        '19',/)
         OPEN(19,FILE=DIRNAME//'/'//'fort.19')
         READ(19,*) ETIMINC
         DO J=1,NETA
            READ(19,*) ESBIN1(J)
         END DO
         DO J=1,NETA
            READ(19,*) ESBIN2(J)
         END DO
         ETIME1 = STATIM*86400.D0
         ETIME2 = ETIME1 + ETIMINC
      ENDIF
C
C....INITIALIZE THE NORMAL FLOW BOUNDARY CONDITION
C
      DO I=1,NVEL
         QN2(I)=0.D0
         QN1(I)=0.D0
         QN0(I)=0.D0
      END DO

      IF((NFLUXF.EQ.1).AND.(NFFR.EQ.0)) THEN
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
         WRITE(16,1112)
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1979)
         WRITE(16,1979)
 1979    FORMAT(/,1X,'NORMAL FLOW INFORMATION READ FROM UNIT 20',/)
         OPEN(20,FILE=DIRNAME//'/'//'fort.20')
         READ(20,*) FTIMINC
         DO J=1,NVEL
            QNIN1(J)=0.D0
            IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *           .OR.(LBCODEI(J).EQ.22))
     *           READ(20,*) QNIN1(J)
         END DO
         DO J=1,NVEL
            QNIN2(J)=0.D0
            IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *           .OR.(LBCODEI(J).EQ.22))
     *           READ(20,*) QNIN2(J)
         END DO
         QTIME1 = STATIM*86400.D0
         QTIME2 = QTIME1 + FTIMINC
      ENDIF

C...INPUT METEOROLOGICAL INFORMATION FROM UNIT 22 OR UNIT 200 SERIES
C....IF FLEET NUMERIC WIND DATA IS USED, FIND BEGINNING TIME IN FILE,
C....NOTE: CAN'T DEAL WITH WIND THAT STARTS AFTER WREFTIM!!!!!!!!!!!!
C....READ IN AND INTERPOLATE IN SPACE ONTO THE ADCIRC GRID THE
C....TIME LEVEL 1 AND LEVEL 2 WIND FIELDS

      DO I=1,NP
         TAUSX1(I)=0.D0
         TAUSY1(I)=0.D0
         PR1(I) =0.D0
         TAUSX2(I)=0.D0
         TAUSY2(I)=0.D0
         PR2(I) =0.D0
      ENDDO

      IF(NWS.NE.0) THEN

         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
         WRITE(16,1112)
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1980)
         WRITE(16,1980)
 1980    FORMAT(/,1X,'WIND (AND PRESSURE) INFORMATION READ.',/)
      ENDIF

      IF(NWS.EQ.1) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
      ENDIF

      IF(ABS(NWS).EQ.2) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
         READ(22,*) (NHG,WVNX1(I),WVNY1(I),PRN1(I),I=1,NP)
         READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
         WTIME1 = STATIM*86400.D0
         WTIME2 = WTIME1 + WTIMINC
      ENDIF

      IF(NWS.EQ.3) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
 2222    CALL NWS3GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,IWTIME,IWYR,WTIMED,NP,
     *        NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
         IF(IWYR.NE.IREFYR) THEN
            IWTIMEP=IWTIME
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
            END DO
            GOTO 2222
         ENDIF
         IF(WTIMED.LE.WREFTIM) THEN
            IWTIMEP=IWTIME
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
            END DO
            GOTO 2222
         ENDIF
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *        WRITE(6,*)'FOUND WIND DATA AT TIME= ',IWTIMEP
         WRITE(16,*) 'FOUND WIND DATA AT TIME= ',IWTIMEP
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) 
     *        WRITE(6,*)'FOUND WIND DATA AT TIME= ',IWTIME
         WRITE(16,*) 'FOUND WIND DATA AT TIME= ',IWTIME
         WTIME2=WTIMED-WREFTIM  !CAST INTO MODEL TIME REFRENCE
         WTIME1=WTIME2-WTIMINC
      ENDIF

      IF(ABS(NWS).EQ.4) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
         WTIME1 = STATIM*86400.D0
         WTIME2=WTIME1+WTIMINC
         CALL NWS4GET(WVNX1,WVNY1,PRN1,NP,RHOWAT0,G)
         CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
      ENDIF

      IF(ABS(NWS).EQ.5) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
         READ(22,*) (NHG,WVNX1(I),WVNY1(I),PRN1(I),I=1,NP)
         READ(22,*) (NHG,WVNX2(I),WVNY2(I),PRN2(I),I=1,NP)
         WTIME1 = STATIM*86400.D0
         WTIME2 = WTIME1 + WTIMINC
      ENDIF

      IF(NWS.EQ.6) THEN
         OPEN(22,FILE=DIRNAME//'/'//'fort.22')
         CALL NWS6GET(X,Y,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,NWLON,NWLAT,
     *        WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
         CALL NWS6GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,NWLON,NWLAT,
     *        WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
         WTIME1 = STATIM*86400.D0
         WTIME2 = WTIME1 + WTIMINC
      ENDIF

      IF(NWS.EQ.10) THEN
         WTIME1=STATIM*86400.D0
         WTIME2=WTIME1+WTIMINC
         NWSGGWI=-1
         CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,RHOWAT0,G,
     *        NWLON,NWLAT,WTIMINC) !JUST COMPUTE INTERPOLATING FACTORS
         NWSGGWI=1
         CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,RHOWAT0,G,
     *        NWLON,NWLAT,WTIMINC) !NOW INTERPOLATE 1st WIND FIELD
      ENDIF

      IF(NWS.EQ.11) THEN
         WTIME1=STATIM*86400.D0
         WTIME2=WTIME1+WTIMINC
         NWSEGWI=0
         IDSETFLG=0
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1197)
         WRITE(16,1197)
 1197    FORMAT(/,1X,'THE E29 MET GRID INTERPOLATING FACTORS ARE ',
     *        'BEING COMPUTED ')
         CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX1,WVNY1,PRN1,NP,
     *        RHOWAT0,G)        !JUST COMPUTE INTERPOLATING FACTORS
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1198)
         WRITE(16,1198)
 1198    FORMAT(1X,'FINISHED COMPUTING E29 INTERPOLATING FACTORS',/)
         NWSEGWI=1
         IDSETFLG=1
         CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,
     *        RHOWAT0,G)        !NOW INTERPOLATE 1st WIND FIELD
      ENDIF

C...INPUT RADIATION STRESS INFORMATION FROM UNIT 23
C....READ IN THE TIME LEVEL 1 AND LEVEL 2 FIELDS

      IF(NRS.EQ.1) THEN
         IF(NWS.EQ.0) THEN
            DO I=1,NP
               TAUSX1(I)=0.D0
               TAUSY1(I)=0.D0
               TAUSX2(I)=0.D0
               TAUSY2(I)=0.D0
               PRN1(I)=0.D0     !need to be initialized
               PRN2(I)=0.D0     !even if not used
            ENDDO
         ENDIF
         OPEN(23,FILE=DIRNAME//'/'//'fort.23')
         RSTIME1 = STATIM*86400.D0
         RSTIME2 = RSTIME1+RSTIMINC
         CALL RSGET(RSNX1,RSNY1,NP)
         CALL RSGET(RSNX2,RSNY2,NP)
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
         WRITE(16,1112)
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1981)
         WRITE(16,1981)
 1981    FORMAT(/,1X,'RADIATION STRESS INFORMATION READ.',/)
      ENDIF
C...
C...LINES TO USE TIDAL POTENTIAL FORCING
C...
      if (CTIP) then
         DO I=1,NP
            TIP2(I)=0.0
         END DO
      endif
CWET...
CWET...THE FOLLOWING LINES ARE FOR WETTING AND DRYING
CWET...Dry any landlocked nodes by checking that they are connected to at
CWET...least 1 functioning element.
CWET...
      IF(NOLIFA.EQ.2) THEN
         DO I=1,NP
            MJU(I)=0
         ENDDO
         DO I=1,NE
            NM1=NM(I,1)
            NM2=NM(I,2)
            NM3=NM(I,3)
            NC1=NNODECODE(NM1)
            NC2=NNODECODE(NM2)
            NC3=NNODECODE(NM3)
            NCELE=NC1*NC2*NC3
            MJU(NM1)=MJU(NM1)+NCELE
            MJU(NM2)=MJU(NM2)+NCELE
            MJU(NM3)=MJU(NM3)+NCELE
         ENDDO
         DO I=1,NP
            IF((NNODECODE(I).EQ.1).AND.(MJU(I).EQ.0)) THEN
               NNODECODE(I)=0
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9883) I
               WRITE(16,9883) I
            ENDIF
         ENDDO
      ENDIF
C...  
C......INITIALIZE 3D SOLUTION
C...  
      
C...  LINES TO RUN THE CODE IN 3D VS MODE.
      
      if (C3DVS) then
         CALL VSSTUP(DT,NT)
      endif
      
C...LINES TO RUN THE CODE IN 3D DSS MODE

      if (C3DDSS) then
c       CALL DSSSTUP(DT,NT)
      endif
C...
C....INITILIZE ELEVATION STATION SPOOL COUNTER
C....OPEN ELEVATION STATION OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NTRSPE (NO. OF DATA PTS. AT EACH
C....ELEVATION STATION), NSTAE, DT*NSPOOLE, NSPOOLE, IRTYPE
C...
      NSCOUE=0
      IESTP=0

 3220 FORMAT(1X,A32,2X,A24,2X,A24)
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)

      IF(ABS(NOUTE).EQ.1) THEN
         OPEN(61,FILE=DIRNAME//'/'//'fort.61')
         WRITE(61,3220) RUNDES,RUNID,AGRID
         WRITE(61,3645) NTRSPE,NSTAE,DTDP*NSPOOLE,NSPOOLE,1
         IESTP=2
      ENDIF
      
      IF(ABS(NOUTE).EQ.2) THEN
         OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(61,REC=IESTP+I) RDES4(I)
            ENDDO
            IESTP=IESTP+8
            DO I=1,6
               WRITE(61,REC=IESTP+I) RID4(I)
            ENDDO
            IESTP=IESTP+6
            DO I=1,6
               WRITE(61,REC=IESTP+I) AID4(I)
            ENDDO
            IESTP=IESTP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(61,REC=IESTP+I) RDES8(I)
            ENDDO
            IESTP=IESTP+4
            DO I=1,3
               WRITE(61,REC=IESTP+I) RID8(I)
            ENDDO
            IESTP=IESTP+3
            DO I=1,3
               WRITE(61,REC=IESTP+I) AID8(I)
            ENDDO
            IESTP=IESTP+3
         ENDIF
         WRITE(61,REC=IESTP+1) NTRSPE
         WRITE(61,REC=IESTP+2) NSTAE
         WRITE(61,REC=IESTP+3) DT*NSPOOLE
         WRITE(61,REC=IESTP+4) NSPOOLE
         WRITE(61,REC=IESTP+5) 1
         IESTP=IESTP+5
         CLOSE(61)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF

C...
C....INITILIZE VELOCITY STATION SPOOL COUNTER
C....OPEN VELOCITY STATION OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NTRSPV (NO. OF DATA PTS. AT EACH
C....VELOCITY STATION), NSTAV, DT*NSPOOLV, NSPOOLV, IRTYPE
C...
      NSCOUV=0
      IVSTP=0

      IF(ABS(NOUTV).EQ.1) THEN
         OPEN(62,FILE=DIRNAME//'/'//'fort.62')
         WRITE(62,3220) RUNDES,RUNID,AGRID
         WRITE(62,3645) NTRSPV,NSTAV,DTDP*NSPOOLV,NSPOOLV,2
         IVSTP=2
      ENDIF

      IF(ABS(NOUTV).EQ.2) THEN
         OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(62,REC=IVSTP+I) RDES4(I)
            ENDDO
            IVSTP=IVSTP+8
            DO I=1,6
               WRITE(62,REC=IVSTP+I) RID4(I)
            ENDDO
            IVSTP=IVSTP+6
            DO I=1,6
               WRITE(62,REC=IVSTP+I) AID4(I)
            ENDDO
            IVSTP=IVSTP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(62,REC=IVSTP+I) RDES8(I)
            ENDDO
            IVSTP=IVSTP+4
            DO I=1,3
               WRITE(62,REC=IVSTP+I) RID8(I)
            ENDDO
            IVSTP=IVSTP+3
            DO I=1,3
               WRITE(62,REC=IVSTP+I) AID8(I)
            ENDDO
            IVSTP=IVSTP+3
         ENDIF
         WRITE(62,REC=IVSTP+1) NTRSPV
         WRITE(62,REC=IVSTP+2) NSTAV
         WRITE(62,REC=IVSTP+3) DT*NSPOOLV
         WRITE(62,REC=IVSTP+4) NSPOOLV
         WRITE(62,REC=IVSTP+5) 2
         IVSTP=IVSTP+5
         CLOSE(62)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF

C...
C....INITILIZE CONCENTRATION STATION SPOOL COUNTER
C....OPEN ELEVATION STATION OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NTRSPC (NO. OF DATA PTS. AT EACH
C....CONCENTRATION STATION), NSTAC, DT*NSPOOLC, NSPOOLC, IRTYPE
C...
      NSCOUC=0
      ICSTP=0

      IF(ABS(NOUTC).EQ.1) THEN
         OPEN(81,FILE=DIRNAME//'/'//'fort.81')
         WRITE(81,3220) RUNDES,RUNID,AGRID
         WRITE(81,3645) NTRSPC,NSTAC,DTDP*NSPOOLC,NSPOOLC,1
         ICSTP=2
      ENDIF

      IF(ABS(NOUTC).EQ.2) THEN
         OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(81,REC=ICSTP+I) RDES4(I)
            ENDDO
            ICSTP=ICSTP+8
            DO I=1,6
               WRITE(81,REC=ICSTP+I) RID4(I)
            ENDDO
            ICSTP=ICSTP+6
            DO I=1,6
               WRITE(81,REC=ICSTP+I) AID4(I)
            ENDDO
            ICSTP=ICSTP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(81,REC=ICSTP+I) RDES8(I)
            ENDDO
            ICSTP=ICSTP+4
            DO I=1,3
               WRITE(81,REC=ICSTP+I) RID8(I)
            ENDDO
            ICSTP=ICSTP+3
            DO I=1,3
               WRITE(81,REC=ICSTP+I) AID8(I)
            ENDDO
            ICSTP=ICSTP+3
         ENDIF
         WRITE(81,REC=ICSTP+1) NTRSPC
         WRITE(81,REC=ICSTP+2) NSTAC
         WRITE(81,REC=ICSTP+3) DT*NSPOOLC
         WRITE(81,REC=ICSTP+4) NSPOOLC
         WRITE(81,REC=ICSTP+5) 1
         ICSTP=ICSTP+5
         CLOSE(81)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF

C...
C....INITILIZE METEOROLOGICAL STATION SPOOL COUNTERS
C....OPEN METEOROLOGICAL STATION OUTPUT FILES
C....WRITE OUT HEADER INFORMATION INCLUDING NTRSPM (NO. OF DATA PTS. AT EACH
C....METEOROLOGICAL STATION), NSTAM, DT*NSPOOLM, NSPOOLM, IRTYPE
C...
      NSCOUM=0
      IPSTP=0
      IWSTP=0

      IF(ABS(NOUTM).EQ.1) THEN
         OPEN(71,FILE=DIRNAME//'/'//'fort.71')
         WRITE(71,3220) RUNDES,RUNID,AGRID
         WRITE(71,3645) NTRSPM,NSTAM,DTDP*NSPOOLM,NSPOOLM,1
         IPSTP=2
         OPEN(72,FILE=DIRNAME//'/'//'fort.72')
         WRITE(72,3220) RUNDES,RUNID,AGRID
         WRITE(72,3645) NTRSPM,NSTAM,DTDP*NSPOOLM,NSPOOLM,2
         IWSTP=2
      ENDIF

      IF(ABS(NOUTM).EQ.2) THEN
         OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *        ACCESS='DIRECT',RECL=NBYTE)
         OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(71,REC=IPSTP+I) RDES4(I)
               WRITE(72,REC=IWSTP+I) RDES4(I)
            ENDDO
            IPSTP=IPSTP+8
            IWSTP=IWSTP+8
            DO I=1,6
               WRITE(71,REC=IPSTP+I) RID4(I)
               WRITE(72,REC=IWSTP+I) RID4(I)
            ENDDO
            IPSTP=IPSTP+6
            IWSTP=IWSTP+6
            DO I=1,6
               WRITE(71,REC=IPSTP+I) AID4(I)
               WRITE(72,REC=IWSTP+I) AID4(I)
            ENDDO
            IPSTP=IPSTP+6
            IWSTP=IWSTP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(71,REC=IPSTP+I) RDES8(I)
               WRITE(72,REC=IWSTP+I) RDES8(I)
            ENDDO
            IPSTP=IPSTP+4
            IWSTP=IWSTP+4
            DO I=1,3
               WRITE(71,REC=IPSTP+I) RID8(I)
               WRITE(72,REC=IWSTP+I) RID8(I)
            ENDDO
            IPSTP=IPSTP+3
            IWSTP=IWSTP+3
            DO I=1,3
               WRITE(71,REC=IPSTP+I) AID8(I)
               WRITE(72,REC=IWSTP+I) AID8(I)
            ENDDO
            IPSTP=IPSTP+3
            IWSTP=IWSTP+3
         ENDIF
         WRITE(71,REC=IPSTP+1) NTRSPM
         WRITE(71,REC=IPSTP+2) NSTAM
         WRITE(71,REC=IPSTP+3) DT*NSPOOLM
         WRITE(71,REC=IPSTP+4) NSPOOLM
         WRITE(71,REC=IPSTP+5) 1
         WRITE(72,REC=IWSTP+1) NTRSPM
         WRITE(72,REC=IWSTP+2) NSTAM
         WRITE(72,REC=IWSTP+3) DT*NSPOOLM
         WRITE(72,REC=IWSTP+4) NSPOOLM
         WRITE(72,REC=IWSTP+5) 2
         IPSTP=IPSTP+5
         IWSTP=IWSTP+5
         CLOSE(71)              ! DO THIS TO FLUSH THE WRITE BUFFER
         CLOSE(72)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     *        ACCESS='DIRECT',RECL=NBYTE)
         OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF
C...
C....INITILIZE GLOBAL ELEVATION SPOOL COUNTER
C....OPEN GLOBAL ELEVATION OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NDSETSE
C....(NO. OF GLOBAL ELEVATION DATA SETS TO BE SPOOLED),
C....NP, DT*NSPOOLGE, NSPOOLGE, IRTYPE
C...
      NSCOUGE=0
      IGEP=0

      IF(ABS(NOUTGE).EQ.1) THEN
         OPEN(63,FILE=DIRNAME//'/'//'fort.63')
         WRITE(63,3220) RUNDES,RUNID,AGRID
         WRITE(63,3645) NDSETSE,NP,DTDP*NSPOOLGE,NSPOOLGE,1
         IGEP=2
      ENDIF

      IF(ABS(NOUTGE).EQ.2) THEN
         OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(63,REC=IGEP+I) RDES4(I)
            ENDDO
            IGEP=IGEP+8
            DO I=1,6
               WRITE(63,REC=IGEP+I) RID4(I)
            ENDDO
            IGEP=IGEP+6
            DO I=1,6
               WRITE(63,REC=IGEP+I) AID4(I)
            ENDDO
            IGEP=IGEP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(63,REC=IGEP+I) RDES8(I)
            ENDDO
            IGEP=IGEP+4
            DO I=1,3
               WRITE(63,REC=IGEP+I) RID8(I)
            ENDDO
            IGEP=IGEP+3
            DO I=1,3
               WRITE(63,REC=IGEP+I) AID8(I)
            ENDDO
            IGEP=IGEP+3
         ENDIF
         WRITE(63,REC=IGEP+1) NDSETSE
         WRITE(63,REC=IGEP+2) NP
         WRITE(63,REC=IGEP+3) DT*NSPOOLGE
         WRITE(63,REC=IGEP+4) NSPOOLGE
         WRITE(63,REC=IGEP+5) 1
         IGEP=IGEP+5
         CLOSE(63)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF
C...
C....INITILIZE GLOBAL VELOCITY SPOOL COUNTER
C....OPEN GLOBAL VELOCITY OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NDSETSV
C....(NO. OF GLOBAL VELOCITY DATA SETS TO BE SPOOLED),
C....NP, DT*NSPOOLGV, NSPOOLGV, IRTYPE
C...
      NSCOUGV=0
      IGVP=0

      IF(ABS(NOUTGV).EQ.1) THEN
         OPEN(64,FILE=DIRNAME//'/'//'fort.64')
         WRITE(64,3220) RUNDES,RUNID,AGRID
         WRITE(64,3645) NDSETSV,NP,DTDP*NSPOOLGV,NSPOOLGV,2
         IGVP=2
      ENDIF

      IF(ABS(NOUTGV).EQ.2) THEN
         OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(64,REC=IGVP+I) RDES4(I)
            ENDDO
            IGVP=IGVP+8
            DO I=1,6
               WRITE(64,REC=IGVP+I) RID4(I)
            ENDDO
            IGVP=IGVP+6
            DO I=1,6
               WRITE(64,REC=IGVP+I) AID4(I)
            ENDDO
            IGVP=IGVP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(64,REC=IGVP+I) RDES8(I)
            ENDDO
            IGVP=IGVP+4
            DO I=1,3
               WRITE(64,REC=IGVP+I) RID8(I)
            ENDDO
            IGVP=IGVP+3
            DO I=1,3
               WRITE(64,REC=IGVP+I) AID8(I)
            ENDDO
            IGVP=IGVP+3
         ENDIF
         WRITE(64,REC=IGVP+1) NDSETSV
         WRITE(64,REC=IGVP+2) NP
         WRITE(64,REC=IGVP+3) DT*NSPOOLGV
         WRITE(64,REC=IGVP+4) NSPOOLGV
         WRITE(64,REC=IGVP+5) 2
         IGVP=IGVP+5
         CLOSE(64)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF
C...
C....INITILIZE GLOBAL WIND and pressure SPOOL COUNTER
C....OPEN GLOBAL WIND and pressure OUTPUT FILEs
C....WRITE OUT HEADER INFORMATION INCLUDING NDSETSW
C....(NO. OF GLOBAL WIND DATA SETS TO BE SPOOLED),
C....NP, DT*NSPOOLGW, NSPOOLGW, IRTYPE
C...
      NSCOUGW=0
      IGWP=0
      igpp=0

      IF(ABS(NOUTGW).EQ.1) THEN
         open(73,file=dirname//'/'//'fort.73')
         write(73,3220) rundes,runid,agrid
         write(73,3645) ndsetsw,np,dtdp*nspoolgw,nspoolgw,1
         igpp=2
         OPEN(74,FILE=DIRNAME//'/'//'fort.74')
         WRITE(74,3220) RUNDES,RUNID,AGRID
         WRITE(74,3645) NDSETSW,NP,DTDP*NSPOOLGW,NSPOOLGW,2
         IGWP=2
      ENDIF

      IF(ABS(NOUTGW).EQ.2) THEN
         open(73,file=dirname//'/'//'fort.73',
     *        access='direct',recl=nbyte)
         OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               write(73,rec=igpp+i) rdes4(i)
               WRITE(74,REC=IGWP+I) RDES4(I)
            ENDDO
            igpp=igpp+8
            IGWP=IGWP+8
            DO I=1,6
               write(73,rec=igpp+i) rid4(i)
               WRITE(74,REC=IGWP+I) RID4(I)
            ENDDO
            igpp=igpp+6
            IGWP=IGWP+6
            DO I=1,6
               write(73,rec=igpp+i) aid4(i)
               WRITE(74,REC=IGWP+I) AID4(I)
            ENDDO
            igpp=igpp+6
            IGWP=IGWP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               write(73,rec=igpp+i) rdes8(i)
               WRITE(74,REC=IGWP+I) RDES8(I)
            ENDDO
            igpp=igpp+4
            IGWP=IGWP+4
            DO I=1,3
               write(73,rec=igpp+i) rid8(i)
               WRITE(74,REC=IGWP+I) RID8(I)
            ENDDO
            igpp=igpp+3
            IGWP=IGWP+3
            DO I=1,3
               write(73,rec=igpp+i) aid8(i)
               WRITE(74,REC=IGWP+I) AID8(I)
            ENDDO
            igpp=igpp+3
            IGWP=IGWP+3
         ENDIF
         write(73,rec=igpp+1) ndsetsw
         write(73,rec=igpp+2) np
         write(73,rec=igpp+3) dt*nspoolgw
         write(73,rec=igpp+4) nspoolgw
         write(73,rec=igpp+5) 2
         igpp=igpp+5
         close(73)              ! DO THIS TO FLUSH THE WRITE BUFFER
         open(73,file=dirname//'/'//'fort.73',
     *        access='direct',recl=nbyte)
         WRITE(74,REC=IGWP+1) NDSETSW
         WRITE(74,REC=IGWP+2) NP
         WRITE(74,REC=IGWP+3) DT*NSPOOLGW
         WRITE(74,REC=IGWP+4) NSPOOLGW
         WRITE(74,REC=IGWP+5) 2
         IGWP=IGWP+5
         CLOSE(74)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF
C...
C....INITILIZE GLOBAL CONCENTRATION SPOOL COUNTER
C....OPEN GLOBAL CONCENTRATION OUTPUT FILE
C....WRITE OUT HEADER INFORMATION INCLUDING NDSETSC
C....(NO. OF GLOBAL CONCENTRATION DATA SETS TO BE SPOOLED),
C....NP, DT*NSPOOLGC, NSPOOLGC, IRTYPE
C...
      NSCOUGC=0
      IGCP=0

      IF(ABS(NOUTGC).EQ.1) THEN
         OPEN(83,FILE=DIRNAME//'/'//'fort.83')
         WRITE(83,3220) RUNDES,RUNID,AGRID
         WRITE(83,3645) NDSETSC,NP,DTDP*NSPOOLGC,NSPOOLGC,1
         IGCP=2
      ENDIF

      IF(ABS(NOUTGC).EQ.2) THEN
         OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *        ACCESS='DIRECT',RECL=NBYTE)
         IF(NBYTE.EQ.4) THEN
            DO I=1,8
               WRITE(83,REC=IGCP+I) RDES4(I)
            ENDDO
            IGCP=IGCP+8
            DO I=1,6
               WRITE(83,REC=IGCP+I) RID4(I)
            ENDDO
            IGCP=IGCP+6
            DO I=1,6
               WRITE(83,REC=IGCP+I) AID4(I)
            ENDDO
            IGCP=IGCP+6
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO I=1,4
               WRITE(83,REC=IGCP+I) RDES8(I)
            ENDDO
            IGCP=IGCP+4
            DO I=1,3
               WRITE(83,REC=IGCP+I) RID8(I)
            ENDDO
            IGCP=IGCP+3
            DO I=1,3
               WRITE(83,REC=IGCP+I) AID8(I)
            ENDDO
            IGCP=IGCP+3
         ENDIF
         WRITE(83,REC=IGCP+1) NDSETSC
         WRITE(83,REC=IGCP+2) NP
         WRITE(83,REC=IGCP+3) DT*NSPOOLGC
         WRITE(83,REC=IGCP+4) NSPOOLGC
         WRITE(83,REC=IGCP+5) 1
         IGCP=IGCP+5
         CLOSE(83)              ! DO THIS TO FLUSH THE WRITE BUFFER
         OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     *        ACCESS='DIRECT',RECL=NBYTE)
      ENDIF
C...
C....INITIALIZE HARMONIC ANALYSIS MATRICES, MEAN AND SQUARE VECTORS
C...
      IF (IHARIND.EQ.1) THEN
         ICHA=0
         CALL HACOLDS(HAFREQ)
         IF(NHASE.EQ.1) CALL HACOLDSES(NSTAE)
         IF(NHASV.EQ.1) CALL HACOLDSVS(NSTAV)
         IF(NHAGE.EQ.1) CALL HACOLDSEG(NP)
         IF(NHAGV.EQ.1) CALL HACOLDSVG(NP)
         IF ( CHARMV) THEN
            DO I=1,NP
               ELAV(I)=0.D0
               XVELAV(I)=0.D0
               YVELAV(I)=0.D0
               ELVA(I)=0.D0
               XVELVA(I)=0.D0
               YVELVA(I)=0.D0
            ENDDO
         ENDIF                  !  charmv
      ENDIF
C
 1112 FORMAT(/,1X,79('_'))
 9883 FORMAT(' !!! NODE ',I6,' DRIED (LANDLOCKING)')
C
      RETURN
      END
C**************************************************************************
C PADCIRC RELEASE VERSION 43.01 12/20/2002 
C    last changes in this file VERSION 43.01
C
C  mod history
C  v43.01     - 12/20/02 - rl&jf - from F90 version from Tim Campbell - reconciled 1 sections,
C                               bottom friction bug fix, spatially varying Tau0 extended to 3D
C  v41.11     - 09/14/01 - rl - from 41.10 - added NWS = -2
C  v41.10     - 07/25/01 - rl - from 41.09 - bug fix in GWCE lateral viscosity term
C  v41.09     - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C  v41.08     - 06/22/01 - rl  - reconciled v41.07 and v41.05m009
C  v41.05m009 - 06/12/01 - rl&jjw - updated NODECODE after initial drying section
C  v41.05m008 - 06/01/01 - jjw - changed code by adding output in wet/dry section
C  v41.05m007 - 05/28/01 - jjw - changed HABSMIN=0.8D0*H0                      
C  v41.05m006 - 05/22/01 - jjw - add writes to track wetting/drying bug         
C  v41.05m005 - 05/21/01 - jjw - modified wet/dry to allow barrier overtopping 
C                                modified from version 41.05.original
C  v41.05m004 - 02/15/01 - jjw - from 41.05.m003 - added logic to reset min depth behind
C                                overtopping barriers from wetting
C  v41.05m003 - 02/14/01 - jjw - from 41.05.original - skipped over version 41.05m001/m002
C                                Fixed bug in wet/dry algorithm which prevented
C                                overtopping internal barriers from wetting
C  v41.03       09/15/00 - rl - added bridge piling friction, fixed several F90 bugs
C  v41.02       09/07/00 - rl - fixed F90 hot start bug and consolidated with version 35.xx
C  v40_02m004 - 05/02/00 - rl - changed so that contribution to RHS forcing is 
C                               zeroed out for any element that contains a dry node.
C                               Note: LHS is taken care of automatically.
C  v40.02m003 - 04/28/00 - jjw - Changed wet/dry interface from essential no normal &
C                                tangential to natural no normal
C  v40.02m002 - 12/22/99 - jjw/vjp - Vic suggested this change to avoid compiler problems
C  v40.02m001 - 12/21/99 - jjw - add cross barrier pipes cjjwm001   
C************************************************************************** 
C 
      SUBROUTINE TIMESTEP(IT)
C     
      USE GLOBAL
      USE HARM
      USE WIND
      USE ITPACKV



      IMPLICIT NONE
      INTEGER IT

      REAL(SZ) DPPP,Tau0PP
      REAL(SZ) VIDBCPDX, VIDBCPDY
      REAL(SZ) VIDBCPDX1N1,VIDBCPDX1N2,VIDBCPDX1N3
      REAL(SZ) VIDBCPDY1N1,VIDBCPDY1N2,VIDBCPDY1N3
      REAL(SZ) VIDBCPDXPP3,VIDBCPDYPP3
      REAL(SZ) SpaVarTau0

C...  COMPUTE MASTER TIME WHICH IS REFERENCED TO THE BEGINNING TIME OF
C...  THE MODEL RUN
C...  
      TIME=IT*DTDP + STATIM*86400.D0
      
C...  HARMONIC CALCULATIONS ARE MADE FOR TIME WHICH INCLUDES THE REFTIM
C...  TO ALLOW FOR THE POSSIBILITY THAT THE EQUILIBRIUM ARGUEMENTS MAY
C...  BE FOR A TIME OTHER THAN THE MODEL STARTING TIME.
C...  
      TIMEH=IT*DTDP + (STATIM - REFTIM)*86400.D0

C...  SHIFT THE DEPTH AVERAGED VELOCITIES, BOTTOM STRESS, WIND STRESS,
C...  SURFACE PRESSURE AND TIDAL POTENTIALS TO PREVIOUS TIME STEP.  ZERO
C...  OUT THE NEW FORCING TERMS, LOAD VECTORS (QW - GWCE, QU,QV - MOM)
C...  AND RESPONSES
C...  
      DO I=1,NP
         UBAR1(I)=UBAR2(I)
         VBAR1(I)=VBAR2(I)
         QW(I)=0.D0
         QU(I)=0.D0
         QV(I)=0.D0

C...  Transport
         IF(IM.EQ.10) THEN
            QB(I)=0.D0
            QA(I)=0.D0
         ENDIF

C...  Wind (& wave radiation stress if used)
         IF((NWS.NE.0).OR.(NRS.NE.0)) THEN
            TauSX1(I)=TauSX2(I)
            TauSX2(I)=0.D0
            TauSY1(I)=TauSY2(I)
            TauSY2(I)=0.D0
            PR1(I)=PR2(I)
            PR2(I)=0.D0
         ENDIF

C     TIP..Tidal potential forcing
         if(CTIP) then
            TIP1(I)=TIP2(I)
            TIP2(I)=0.D0
         endif

C     2 DDI.For the 2 DDI version of the code
C     2 DDI.Set up the 2D friction coefficient
         if(C2DDI) then
            UV1=SQRT(UBAR1(I)*UBAR1(I)+VBAR1(I)*VBAR1(I))
            HH1=DP(I)+IFNLFA*ETA2(I)
            TK(I)=FRIC(I)*(IFLINBF + (UV1/HH1)*(IFNLBF + IFHYBF*
     *           (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
         endif 

      END DO

C...  
C     2 DDI.For the 2 DDI version of the code
C     2 DDI.Include additional friction if bridge pilings are present
C...  
      if(C2DDI) THEN
         IF(NWP.EQ.2) THEN
            DO J=1,NBPNODES
               I=NBNNUM(J) 
               UV1=SQRT(UBAR1(I)*UBAR1(I)+VBAR1(I)*VBAR1(I))
               HH1=DP(I)+IFNLFA*ETA2(I)
               Fr=UV1*UV1/(G*HH1)
               FRICBP=(HH1/BDELX(J))*BK(J)*(BK(J)+5.d0*Fr*Fr-0.6d0)
     *              *(BALPHA(J)+15.d0*BALPHA(J)**4)
               TK(I)=TK(I)+FRICBP*UV1/HH1
            ENDDO
         ENDIF
      endif

C...  SHIFT THE SPECIFIED NORMAL FLOW BOUNDARY CONDITION TO PREVIOUS
C...  TIME STEPS.  ZERO OUT THE NEW SPECIFIED NORMAL FLOW BOUNDARY
C...  CONDITION
C...  
      DO I=1,NVEL
         QN0(I)=QN1(I)
         QN1(I)=QN2(I)
         QN2(I)=0.D0
      END DO

C...  RECOMPUTE THE GWCE SYSTEM MATRIX AT THE FIRST TIME STEP OR IF ANY
C...  WETTING OR DRYING OCCURRED IN THE PREVIOUS TIME STEP.
C...  
      IF(NCCHANGE.EQ.1) THEN
         NCCHANGE=0
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3806)
c     WRITE(16,3806)
 3806    FORMAT(/,1X,'RE-SETTING GWCE SYSTEM MATRIX',/)

C.....Set up the LHS matrix (for the iterative matrix solver)
         DO I=1,NP
            DO J=1,NEIMAX
               COEF(I,J)=0.0d0
            END DO
         END DO

         DO IE=1,NE
            NMI1=NM(IE,1)
            NMI2=NM(IE,2)
            NMI3=NM(IE,3)
            NMJ1=NMI1
            NMJ2=NMI2
            NMJ3=NMI3
            NC1=NODECODE(NMI1)
            NC2=NODECODE(NMI2)
            NC3=NODECODE(NMI3)
            NCELE=NC1*NC2*NC3

            SFACPP=(SFAC(NMI1)+SFAC(NMI2)+SFAC(NMI3))/3.d0
            Tau0PP=(Tau0VAR(NMI1)+Tau0VAR(NMI2)+Tau0VAR(NMI3))/3.d0
            TT0L=((1.0d0+0.5d0*DT*Tau0PP)/DT)/DT

            AREAIE=AREAS(IE)
            FDX1 = (Y(NMI2)-Y(NMI3))*SFACPP
            FDX2 = (Y(NMI3)-Y(NMI1))*SFACPP
            FDX3 = (Y(NMI1)-Y(NMI2))*SFACPP
            FDY1 = X(NMI3)-X(NMI2)
            FDY2 = X(NMI1)-X(NMI3)
            FDY3 = X(NMI2)-X(NMI1)
            FDX1OA=FDX1/AREAIE  !dphi1/dx
            FDY1OA=FDY1/AREAIE  !dphi1/dy
            FDX2OA=FDX2/AREAIE  !dphi2/dx
            FDY2OA=FDY2/AREAIE  !dphi2/dy
            FDX3OA=FDX3/AREAIE  !dphi3/dx
            FDY3OA=FDY3/AREAIE  !dphi3/dy
            DPPP=(DP(NMI1)+DP(NMI2)+DP(NMI3))/3.
            DXX11=FDX1OA*FDX1   !<2*(dphi1/dx)*(dphi1/dx)>
            DYY11=FDY1OA*FDY1   !<2*(dphi1/dy)*(dphi1/dy)>
            DXXYY11=DXX11+DYY11
            DXYH11=DPPP*DXXYY11
            DXX12=FDX1OA*FDX2   !<2*(dphi1/dx)*(dphi2/dx)>
            DYY12=FDY1OA*FDY2   !<2*(dphi1/dy)*(dphi2/dy)>
            DXXYY12=DXX12+DYY12
            DXYH12=DPPP*DXXYY12
            DXX13=FDX1OA*FDX3   !<2*(dphi1/dx)*(dphi3/dx)>
            DYY13=FDY1OA*FDY3   !<2*(dphi1/dy)*(dphi3/dy)>
            DXXYY13=DXX13+DYY13
            DXYH13=DPPP*DXXYY13
            DXYH21=DXYH12
            DXX22=FDX2OA*FDX2   !<2*(dphi2/dx)*(dphi2/dx)>
            DYY22=FDY2OA*FDY2   !<2*(dphi2/dy)*(dphi2/dy)>
            DXXYY22=DXX22+DYY22
            DXYH22=DPPP*DXXYY22
            DXX23=FDX2OA*FDX3   !<2*(dphi2/dx)*(dphi3/dx)>
            DYY23=FDY2OA*FDY3   !<2*(dphi2/dy)*(dphi3/dy)>
            DXXYY23=DXX23+DYY23
            DXYH23=DPPP*DXXYY23
            DXYH31=DXYH13
            DXYH32=DXYH23
            DXX33=FDX3OA*FDX3   !<2*(dphi3/dx)*(dphi3/dx)>
            DYY33=FDY3OA*FDY3   !<2*(dphi3/dy)*(dphi3/dy)>
            DXXYY33=DXX33+DYY33
            DXYH33=DPPP*DXXYY33
            AO6=AREAIE/6.
            AO12=AREAIE/12.
            FDDD=(1+ILUMP)*AO6  !2*<phi*phj> diagonal terms
            FDDOD=(1-ILUMP)*AO12 !2*<phi*phj> off diagonal terms

            DO JN=2,NEIMAX
               IF(NEITAB(NMI1,JN).EQ.NMJ2) J12=JN
               IF(NEITAB(NMI1,JN).EQ.NMJ3) J13=JN
               IF(NEITAB(NMI2,JN).EQ.NMJ1) J21=JN
               IF(NEITAB(NMI2,JN).EQ.NMJ3) J23=JN
               IF(NEITAB(NMI3,JN).EQ.NMJ1) J31=JN
               IF(NEITAB(NMI3,JN).EQ.NMJ2) J32=JN
            END DO

            COEF(NMI1,1)  =COEF(NMI1,1)  +(TT0L*FDDD +GA00*DXYH11)*NCELE
            COEF(NMI1,J12)=COEF(NMI1,J12)+(TT0L*FDDOD+GA00*DXYH12)*NCELE
            COEF(NMI1,J13)=COEF(NMI1,J13)+(TT0L*FDDOD+GA00*DXYH13)*NCELE
            COEF(NMI2,J21)=COEF(NMI2,J21)+(TT0L*FDDOD+GA00*DXYH21)*NCELE
            COEF(NMI2,1)  =COEF(NMI2,1)  +(TT0L*FDDD +GA00*DXYH22)*NCELE
            COEF(NMI2,J23)=COEF(NMI2,J23)+(TT0L*FDDOD+GA00*DXYH23)*NCELE
            COEF(NMI3,J31)=COEF(NMI3,J31)+(TT0L*FDDOD+GA00*DXYH31)*NCELE
            COEF(NMI3,J32)=COEF(NMI3,J32)+(TT0L*FDDOD+GA00*DXYH32)*NCELE
            COEF(NMI3,1)  =COEF(NMI3,1)  +(TT0L*FDDD +GA00*DXYH33)*NCELE

         END DO

C.....Modify the matrix "COEF" by imposing the elevation specified boundary 
C.....conditions while maintaining the symmetry of the system
         IF ((IT.EQ.1).OR.(IT.EQ.ITHS+1)) THEN

            EP=0.0D0
            DO I=1,NP
               EP=EP+COEF(I,1)*COEF(I,1)
            END DO
            EP=SQRT(EP/NP)

         ENDIF

         DO I=1,NETA
            COEF(NBD(I),1)=EP
            DO J=2,NNEIGH(NBD(I))
               COEF(NBD(I),J)=0.0d0
            END DO
         END DO
         DO I=1,NETA
            DO J=2,NNEIGH(NBD(I))
               DO IJ=2,NNEIGH(NEITAB(NBD(I),J))
                  IF(NBD(I).EQ.NEITAB(NEITAB(NBD(I),J),IJ)) THEN
                     OBCCOEF(I,J-1)=COEF(NEITAB(NBD(I),J),IJ)
                     COEF(NEITAB(NBD(I),J),IJ)=0.0d0
                  ENDIF
               END DO
            END DO
         END DO

C.....Check that all the diagonal elements in "COEF" are > 0.
         DO I=1,NP
            IF(COEF(I,1).EQ.0.) COEF(I,1)=EP
            IF(COEF(I,1).LT.0.) THEN
               IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1019) I,COEF(I,1)
               WRITE(16,1019) I,COEF(I,1)
 1019          FORMAT(/,1X,'!!!!!!!!  WARNING !!!!!!!',
     *              /,1X,'THE DIAGONAL TERM IN THE EQUATION FOR NODE ',I10,
     *              '= ',E15.6,' AND IS < 0',/)
            END IF
         END DO
         
      ENDIF                     !END OF GWCE MATRIX SETUP

C...  
C...  DEFINE RAMP FUNCTION FOR BOUNDARY ELEVATION FORCING, WIND AND PRESSURE
C.... FORCING AND TIDAL POTENTIAL FORCING
C...  
      RAMP=1.0D0
      IF(NRAMP.EQ.1) RAMP=TANH((2.D0*IT*DTDP/86400.D0)/DRAMP)

C...  UPDATE THE WIND STRESS AND SURFACE PRESSURE AND READ IN NEW VALUES
C...  FROM
C.... UNIT 22.  APPLY RAMP FUNCTION.
C...  
      IF(NWS.EQ.1) THEN
         DO I=1,NP
            READ(22,*) NHG,TauSX2(I),TauSY2(I),PR2(I)
            TauSX2(I)=RAMP*TauSX2(I)
            TauSY2(I)=RAMP*TauSY2(I)
            PR2(I)=RAMP*PR2(I)
            wvnxout(i)=TauSX2(i)
            wvnyout(i)=TauSY2(i)
         END DO
      ENDIF

      IF(ABS(NWS).EQ.2) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
               READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
            END DO
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            TauSX2(I) = RAMP*WINDX
            TauSY2(I) = RAMP*WINDY
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            wvnxout(i)=TauSX2(i)
            wvnyout(i)=TauSY2(i)             
         END DO
      ENDIF

      IF(NWS.EQ.3) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
            END DO
            CALL NWS3GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,IWTIME,IWYR,WTIMED,
     *           NP,NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(ABS(NWS).EQ.4) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(ABS(NWS).EQ.5) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
               READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
            END DO
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.6) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            NWSGGWI=NWSGGWI+1
            CALL NWS6GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,NWLON,NWLAT,
     *           WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.10) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            NWSGGWI=NWSGGWI+1
            CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,RHOWAT0,
     *           G,NWLON,NWLAT,WTIMINC)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.11) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            IDSETFLG=IDSETFLG+1
            IF(IDSETFLG.GT.8) THEN
               NWSEGWI=NWSEGWI+1
               IDSETFLG=1
            ENDIF
            CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX2,WVNY2,PRN2,
     *           NP,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            TauSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            TauSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

C...  UPDATE THE WAVE RADIATION STRESS AND READ IN NEW VALUES FROM
C.... UNIT 23.  APPLY RAMP FUNCTION.  ADD RADIATION STRESS TO WIND
C...  STRESS
C...  
      IF(NRS.EQ.1) THEN
         IF(TIME.GT.RSTIME2) THEN
            RSTIME1=RSTIME2
            RSTIME2=RSTIME2+RSTIMINC
            DO I=1,NP
               RSNX1(I)=RSNX2(I)
               RSNY1(I)=RSNY2(I)
            END DO
            CALL RSGET(RSNX2,RSNY2,NP)
         ENDIF
         RSTRATIO=(TIME-RSTIME1)/RSTIMINC
         DO I=1,NP
            RSX = RAMP*(RSNX1(I) + RSTRATIO*(RSNX2(I)-RSNX1(I)))
            RSY = RAMP*(RSNY1(I) + RSTRATIO*(RSNY2(I)-RSNY1(I)))
            TauSX2(I) = TauSX2(I) + RSX
            TauSY2(I) = TauSY2(I) + RSY
         END DO
      ENDIF

C...  
C...  Tidal Potential Forcing
C...  Note, the Earth tide potential reduction factor, ETRF(J) has been
C...        incorporated into this calculation.
C... 
      IF(CTIP) THEN
         DO J=1,NTIF
            IF(PERT(J).EQ.0.) THEN
               NCYC=0
            ELSE
               NCYC=INT(timeh/PERT(J))
            ENDIF
            ARGT=AMIGT(J)*(timeh-NCYC*PERT(J))+FACET(J)
            TPMUL=RAMP*ETRF(J)*TPK(J)*FFT(J)
            SALTMUL=RAMP*FFT(J)
            NA=NINT(0.00014/AMIGT(J))
            IF(NA.EQ.1) THEN    !SEMI-DIURNAL SPECIES
               DO I=1,NP
                  ARGTP=ARGT+2.d0*SLAM(I)
                  ARGSALT=ARGT-SALTPHA(J,I)
                  CCSFEA=COS(SFEA(I))
                  CCSFEA=CCSFEA*CCSFEA
                  TIP2(I)=TIP2(I)+TPMUL*CCSFEA*COS(ARGTP)
     *                 +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
            ENDIF
            IF(NA.EQ.2) THEN    !DIURNAL SPECIES
               DO I=1,NP
                  ARGTP=ARGT+SLAM(I)
                  ARGSALT=ARGT-SALTPHA(J,I)

                  S2SFEA=SIN(2.e0*SFEA(I))

                  TIP2(I)=TIP2(I)+TPMUL*S2SFEA*COS(ARGTP)
     *                 +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
            ENDIF
         END DO
      ENDIF

C...  
C...  COMPUTE SPECIFIED NORMAL FLOW BOUNDARY CONDITION
C...  
      IF(NFLUXF.EQ.1) THEN
         DO J=1,NFFR
            IF(FPER(J).EQ.0.) THEN
               NCYC=0.
            ELSE
               NCYC=INT(timeh/FPER(J))
            ENDIF
            ARGJ=FAMIG(J)*(timeh-NCYC*FPER(J))+FFACE(J)
            RFF=FFF(J)*RAMP
            DO I=1,NVEL
               ARG=ARGJ-QNPH(J,I)
               QN2(I)=QN2(I)+QNAM(J,I)*RFF*COS(ARG)
            END DO
         END DO
         IF(NFFR.EQ.0) THEN
            IF(TIME.GT.QTIME2) THEN
               QTIME1=QTIME2
               QTIME2=QTIME2+FTIMINC
               DO J=1,NVEL
                  IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     *                 .OR.(LBCODEI(J).EQ.22)) THEN
                     QNIN1(J)=QNIN2(J)
                     READ(20,*) QNIN2(J)
                  ENDIF
               END DO
            ENDIF
            QTRATIO=(TIME-QTIME1)/FTIMINC
            DO I=1,NVEL
               QN2(I)=RAMP*(QNIN1(I)+QTRATIO*(QNIN2(I)-QNIN1(I)))
            END DO
         ENDIF
      ENDIF

C...  
C...  COMPUTE DISCHARGE CONTRIBUTION FROM RADIATION BOUNDARY CONDITION
C...  
      IF(NFLUXRBC.EQ.1) THEN
         DO J=1,NVEL
            IF(LBCODEI(J).EQ.30) THEN
               NNBB=NBV(J)
               HH1=DP(NNBB)+IFNLFA*ETA2(NNBB)
               UN1=UBAR1(NNBB)*CSII(J)+VBAR1(NNBB)*SIII(J)
               QN1(J)=HH1*UN1
            ENDIF
         END DO
      ENDIF

C...  
C...  COMPUTE SUPERCRITICAL OUTWARD NORMAL FLOW OVER SPECIFIED
C.... EXTERNAL BARRIER BOUNDARY NODES
C...  
      IF(NFLUXB.EQ.1) THEN
         DO I=1,NVEL
            IF((LBCODEI(I).EQ.3).OR.(LBCODEI(I).EQ.13).OR.
     *           (LBCODEI(I).EQ.23)) THEN
               NNBB=NBV(I)
               RBARWL=2.D0*(ETA2(NNBB)-BARLANHT(I))/3.D0
               IF(RBARWL.GT.0.0D0) THEN
                  QN2(I)=-RAMP*BARLANCFSP(I)*RBARWL*(RBARWL*G)**0.5D0
               ELSE
                  QN2(I)=0.0D0
               ENDIF
            ENDIF
         END DO
      ENDIF

C...   COMPUTE INWARD/OUTWARD NORMAL FLOW OVER SPECIFIED INTERNAL
C...  BARRIER
C.... BOUNDARY (PERMEABLE OR NOT) NODES
C...  
      IF(NFLUXIB.EQ.1) THEN
         DO I=1,NP
            NIBNODECODE(I)=0
         END DO
         DO I=1,NVEL
            IF((LBCODEI(I).EQ.4).OR.(LBCODEI(I).EQ.24).OR.
     *           (LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
               NNBB1=NBV(I)     ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
               NNBB2=IBCONN(I)  ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
               IF(IBSTART.EQ.0)THEN
                  RBARWL1AVG(I)=ETA2(NNBB1)-BARINHT(I)
                  RBARWL2AVG(I)=ETA2(NNBB2)-BARINHT(I)
                  IBSTART=1
               ELSE
                  RBARWL1AVG(I)=(ETA2(NNBB1)-BARINHT(I)+BARAVGWT
     *                 *RBARWL1AVG(I))/(1+BARAVGWT)
                  RBARWL2AVG(I)=(ETA2(NNBB2)-BARINHT(I)+BARAVGWT
     *                 *RBARWL2AVG(I))/(1+BARAVGWT)
               ENDIF
               RBARWL1=RBARWL1AVG(I)
               RBARWL2=RBARWL2AVG(I)
               RBARWL1F=2.0D0*RBARWL1/3.0D0
               RBARWL2F=2.0D0*RBARWL2/3.0D0
               QN2(I)=0.0D0
               IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN
C...............WATER LEVEL ON BOTH SIDES OF BARRIER BELOW BARRIER -> CASE 1
                  QN2(I)=0.0D0
                  GOTO 1034
               ENDIF
               IF(RBARWL1.EQ.RBARWL2) THEN
C...............WATER LEVEL EQUAL ON BOTH SIDES OF BARRIER -> CASE 2
                  QN2(I)=0.0D0
                  GOTO 1034
               ENDIF
               IF((RBARWL1.GT.RBARWL2).AND.(RBARWL1.GT.BARMIN)) THEN
C...............WATER LEVEL GREATER ON THIS SIDE OF THE BARRIER AND IS SUCH
C................THAT OVERTOPPING IS OCCURING
                  IF(RBARWL2.GT.RBARWL1F) THEN
C.................OUTWARD SUBCRITICAL FLOW -> CASE 3
                     QN2(I)=-RAMP*RBARWL2*BARINCFSB(I)*
     *                    (2.D0*G*(RBARWL1-RBARWL2))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................OUTWARD SUPERCRITICAL FLOW -> CASE 4
                     QN2(I)=-RAMP*BARINCFSP(I)*RBARWL1F*
     *                    (RBARWL1F*G)**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1034
               ENDIF
               IF((RBARWL2.GT.RBARWL1).AND.(RBARWL2.GT.BARMIN)) THEN
C...............WATER LEVEL LOWER ON THIS SIDE OF BARRIER AND IS SUCH
C................THAT OVERTOPPING IS OCCURING
                  IF(RBARWL1.GT.RBARWL2F) THEN
C.................INWARD SUBCRITICAL FLOW -> CASE 5
                     QN2(I)=RAMP*RBARWL1*BARINCFSB(I)*
     *                    (2.0D0*G*(RBARWL2-RBARWL1))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................INWARD SUPERCRITICAL FLOW -> CASE 6
                     QN2(I)=RAMP*BARINCFSP(I)*RBARWL2F*
     *                    (RBARWL2F*G)**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1034
               ENDIF
 1034          CONTINUE
            ENDIF
         END DO
      ENDIF
      
C...  
C...  COMPUTE INWARD/OUTWARD NORMAL FLOW FOR INTERNAL BARRIER 
C.... BOUNDARY NODES THROUGH CROSS BARRIER PIPES
C.... NOTE THAT THIS ADDS AN ADDITIONAL FLOW COMPONENT INTO QN2
C...  
      IF(NFLUXIBP.EQ.1) THEN
         DO I=1,NVEL
            IF((LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
               NNBB1=NBV(I)     ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
               NNBB2=IBCONN(I)  ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
               IF(IBSTART.EQ.0)THEN
                  RPIPEWL1AVG(I)=ETA2(NNBB1)-PIPEHT(I)
                  RPIPEWL2AVG(I)=ETA2(NNBB2)-PIPEHT(I)
                  IBSTART=1
               ELSE
                  RPIPEWL1AVG(I)=(ETA2(NNBB1)-PIPEHT(I)+BARAVGWT
     *                 *RPIPEWL1AVG(I))/(1+BARAVGWT)
                  RPIPEWL2AVG(I)=(ETA2(NNBB2)-PIPEHT(I)+BARAVGWT
     *                 *RPIPEWL2AVG(I))/(1+BARAVGWT)
               ENDIF
               RBARWL1=RPIPEWL1AVG(I)
               RBARWL2=RPIPEWL2AVG(I)
               IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN
C...............WATER LEVEL ON BOTH SIDES OF BARRIER BELOW PIPE -> CASE 1
                  QN2(I)=QN2(I)+0.0D0
                  GOTO 1036
               ENDIF
               IF(RBARWL1.EQ.RBARWL2) THEN
C...............WATER LEVEL EQUAL ON BOTH SIDES OF PIPE -> CASE 2
                  QN2(I)=QN2(I)+0.0D0
                  GOTO 1036
               ENDIF
               IF((RBARWL1.GT.RBARWL2).AND.(RBARWL1.GT.BARMIN)) THEN
C...............WATER LEVEL GREATER ON THIS SIDE OF THE PIPE AND IS SUCH
C................THAT OUTWARD DISCHARGE IS OCCURING
                  IF(RBARWL2.LE.0) THEN
C.................OUTWARD FREE DISCHARGE -> CASE 3
                     QN2(I)=QN2(I)-RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL1/(1+PIPECOEF(I)))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................OUTWARD SUBMERGED DISCHARGE -> CASE 4
                     QN2(I)=QN2(I)-RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL1-RBARWL2)/PIPECOEF(I))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1036
               ENDIF
               IF((RBARWL2.GT.RBARWL1).AND.(RBARWL2.GT.BARMIN)) THEN
C...............WATER LEVEL LOWER ON THIS SIDE OF PIPE AND IS SUCH
C................THAT INWARD DISCHARGE IS OCCURING
                  IF(RBARWL1.LE.0) THEN
C.................INWARD FREE DISCHARGE -> CASE 5
                     QN2(I)=QN2(I)+RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*RBARWL2/(1+PIPECOEF(I)))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................INWARD SUBMERGED DISCHARGE -> CASE 6
                     QN2(I)=QN2(I)+RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     *                    *(2.D0*G*(RBARWL2-RBARWL1)/PIPECOEF(I))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1036
               ENDIF
 1036          CONTINUE
            ENDIF
         END DO
      ENDIF

C     2 DDI...
C     2 DDI....COMPUTE THE BUOYANCY FORCING FOR 2D
C     2 DDI...
c     IF (2 DDI) THEN
c     DO I=1,NP
c     VIDBCPDX1(I)=0.D0
c     VIDBCPDY1(I)=0.D0
c     END DO 
c     
c     IF(IDEN.EQ.1) THEN 
c     DO IE=1,NE     !Assemble elementally, not worrying about vectorization
c     NM1=NM(IE,1)
c     NM2=NM(IE,2)
c     NM3=NM(IE,3)
c     NC1=NODECODE(NM1)
c     NC2=NODECODE(NM2)
c     NC3=NODECODE(NM3)
c     NCELE=NC1*NC2*NC3
c     E1N1=IFNLFA*ETA2(NM1)
c     E1N2=IFNLFA*ETA2(NM2)
c     E1N3=IFNLFA*ETA2(NM3)
c     DIMDARHON1=DASIGT(NM1)-SIGT0
c     DIMDARHON2=DASIGT(NM2)-SIGT0
c     DIMDARHON3=DASIGT(NM3)-SIGT0
c     DIMDARHOPP=(DIMDARHON1+DIMDARHON2+DIMDARHON3)/3.D0
c     HH1N1=DP(NM1)+E1N1
c     HH1N2=DP(NM2)+E1N2
c     HH1N3=DP(NM3)+E1N3
c     HPPO2=(HH1N1+HH1N2+HH1N3)/6.D0
c     
c     AREAIE=AREAS(IE)               !2A
c     FDX1 = (Y(NM2)-Y(NM3))*SFACPP  !b1
c     FDX2 = (Y(NM3)-Y(NM1))*SFACPP  !b2
c     FDX3 = (Y(NM1)-Y(NM2))*SFACPP  !b3
c     FDY1 = X(NM3)-X(NM2)           !a1
c     FDY2 = X(NM1)-X(NM3)           !a2
c     FDY3 = X(NM2)-X(NM1)           !a3
c     FDX1OA=FDX1/AREAIE             !dphi1/dx
c     FDY1OA=FDY1/AREAIE             !dphi1/dy
c     FDX2OA=FDX2/AREAIE             !dphi2/dx
c     FDY2OA=FDY2/AREAIE             !dphi2/dy
c     FDX3OA=FDX3/AREAIE             !dphi3/dx
c     FDY3OA=FDY3/AREAIE             !dphi3/dy
c     
c     VIDBCPDXELE=DIMDARHOPP*(E1N1*FDX1OA+E1N2*FDX2OA+E1N3*FDX3OA)
c     &                 +HPPO2*(DIMDARHON1*FDX1OA+DIMDARHON2*FDX2OA
c     &                                               +DIMDARHON3*FDX3OA)
c     VIDBCPDYELE=DIMDARHOPP*(E1N1*FDY1OA+E1N2*FDY2OA+E1N3*FDY3OA)
c     &                 +HPPO2*(DIMDARHON1*FDY1OA+DIMDARHON2*FDY2OA
c     &                                               +DIMDARHON3*FDY3OA)                           
c     VIDBCPDX1(NM1)=VIDBCPDX1(NM1)+VIDBCPDXELE*NCELE
c     VIDBCPDX1(NM2)=VIDBCPDX1(NM2)+VIDBCPDXELE*NCELE
c     VIDBCPDX1(NM3)=VIDBCPDX1(NM3)+VIDBCPDXELE*NCELE
c     VIDBCPDY1(NM1)=VIDBCPDY1(NM1)+VIDBCPDYELE*NCELE
c     VIDBCPDY1(NM2)=VIDBCPDY1(NM2)+VIDBCPDYELE*NCELE
c     VIDBCPDY1(NM3)=VIDBCPDY1(NM3)+VIDBCPDYELE*NCELE
c     END DO
c     
c     DO I=1,NP
c     GHH1FAC=G*RAMP*(DP(I)+IFNLFA*ETA2(I))/RHOWAT0/MJU(I)
c     VIDBCPDX1(I)=GHH1FAC*VIDBCPDX1(I)
c     VIDBCPDY1(I)=GHH1FAC*VIDBCPDY1(I)
c     END DO
c     
c     ENDIF
c     ENDIF

C...  
C...  COMPLETE THE THE LOAD VECTOR QW FOR THE GWCE ELEMENT BY ELEMENT
C...  BY FORMING TEMPORARY VECTORS AND THEN ASSEMBLING AT THE END.
C...  THE FOLLOWING ASSEMBLY LOOPS HAVE ALL BEEN UNROLLED TO OPTIMIZE
C...  VECORIZATION
C...  

C...  Initialize variables to zero if forcing is not used
C...  
      if((NWS.NE.0).OR.(NRS.NE.0)) then
      else
         TauSXN1=0.d0
         TauSXN2=0.d0
         TauSXN3=0.d0
         TauSYN1=0.d0
         TauSYN2=0.d0
         TauSYN3=0.d0
         PR1N1=0.d0
         PR1N2=0.d0
         PR1N3=0.d0
      endif

      if (CTIP) then
      else
         TIPN1=0.d0
         TIPN2=0.d0
         TIPN3=0.d0
      endif

      DO 1037 IE=1,NE
C...  
C...  SET NODAL VALUES FOR EACH ELEMENT
C...  
         NM1=NM(IE,1)
         NM2=NM(IE,2)
         NM3=NM(IE,3)
         NC1=NODECODE(NM1)
         NC2=NODECODE(NM2)
         NC3=NODECODE(NM3)
         NCELE=NC1*NC2*NC3
         E0N1=ETA1(NM1)
         E0N2=ETA1(NM2)
         E0N3=ETA1(NM3)
         E1N1=ETA2(NM1)
         E1N2=ETA2(NM2)
         E1N3=ETA2(NM3)
         E1N1SQ=E1N1*E1N1
         E1N2SQ=E1N2*E1N2
         E1N3SQ=E1N3*E1N3
         ESN1=ETAS(NM1)
         ESN2=ETAS(NM2)
         ESN3=ETAS(NM3)
         U1N1=UBAR1(NM1)
         U1N2=UBAR1(NM2)
         U1N3=UBAR1(NM3)
         V1N1=VBAR1(NM1)
         V1N2=VBAR1(NM2)
         V1N3=VBAR1(NM3)
         HH1N1=DP(NM1)+IFNLFA*E1N1
         HH1N2=DP(NM2)+IFNLFA*E1N2
         HH1N3=DP(NM3)+IFNLFA*E1N3
         HHU1N1=HH1N1*U1N1
         HHU1N2=HH1N2*U1N2
         HHU1N3=HH1N3*U1N3
         HHV1N1=HH1N1*V1N1
         HHV1N2=HH1N2*V1N2
         HHV1N3=HH1N3*V1N3
         SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0
         T0N1=Tau0VAR(NM1) 
         T0N2=Tau0VAR(NM2) 
         T0N3=Tau0VAR(NM3) 
         T0XN1=T0N1*HHU1N1
         T0YN1=T0N1*HHV1N1
         T0XN2=T0N2*HHU1N2
         T0YN2=T0N2*HHV1N2
         T0XN3=T0N3*HHU1N3
         T0YN3=T0N3*HHV1N3

         IF((NWS.NE.0).OR.(NRS.NE.0)) THEN     !wind or radiation stress
            TauSXN1=TauSX1(NM1)
            TauSXN2=TauSX1(NM2)
            TauSXN3=TauSX1(NM3)
            TauSYN1=TauSY1(NM1)
            TauSYN2=TauSY1(NM2)
            TauSYN3=TauSY1(NM3)
            PR1N1=PR1(NM1)
            PR1N2=PR1(NM2)
            PR1N3=PR1(NM3)
         ENDIF

         VIDBCPDX1N1=VIDBCPDX1(NM1)   !buoyancy 
         VIDBCPDX1N2=VIDBCPDX1(NM2)
         VIDBCPDX1N3=VIDBCPDX1(NM3)
         VIDBCPDY1N1=VIDBCPDY1(NM1)
         VIDBCPDY1N2=VIDBCPDY1(NM2)
         VIDBCPDY1N3=VIDBCPDY1(NM3)

         if (CTIP) then               !tidal potential
            TIPN1=TIP1(NM1)
            TIPN2=TIP1(NM2)
            TIPN3=TIP1(NM3)
            endif

         if (C2DDI) then              !2D bottom friction
            TauBXN1=TK(NM1)*HHU1N1
            TauBYN1=TK(NM1)*HHV1N1
            TauBXN2=TK(NM2)*HHU1N2
            TauBYN2=TK(NM2)*HHV1N2
            TauBXN3=TK(NM3)*HHU1N3
            TauBYN3=TK(NM3)*HHV1N3
            endif      

         if (C3D) then                !3D bottom friction & dispersion
            TauBXN1=TauBX1(NM1)
            TauBXN2=TauBX1(NM2)
            TauBXN3=TauBX1(NM3)
            TauBYN1=TauBY1(NM1)
            TauBYN2=TauBY1(NM2)
            TauBYN3=TauBY1(NM3)
            DVV1N1=DVV1(NM1)
            DVV1N2=DVV1(NM2)
            DVV1N3=DVV1(NM3)
            DUV1N1=DUV1(NM1)
            DUV1N2=DUV1(NM2)
            DUV1N3=DUV1(NM3)
            DUU1N1=DUU1(NM1)
            DUU1N2=DUU1(NM2)
            DUU1N3=DUU1(NM3)
            endif

C...  
C...  COMPUTE ELEMENT AVERAGED QUANTITIES
C...  
         DPPP=(DP(NM1)+DP(NM2)+DP(NM3))/3.d0
         GHPP=GO3*(HH1N1+HH1N2+HH1N3)
         UPP=(U1N1+U1N2+U1N3)/3.d0
         VPP=(V1N1+V1N2+V1N3)/3.d0
         UHPP3=HHU1N1+HHU1N2+HHU1N3
         VHPP3=HHV1N1+HHV1N2+HHV1N3
         UHPP=UHPP3/3.d0
         VHPP=VHPP3/3.d0
         EVMPPODT=((EVM(NM1)+EVM(NM2)+EVM(NM3))/3.d0)/DT
         CORIFPP=(CORIF(NM1)+CORIF(NM2)+CORIF(NM3))/3.d0
         TauBXpp3=TauBXn1+TauBXn2+TauBXn3
         TauBYpp3=TauBYn1+TauBYn2+TauBYn3
         T0XPP3=T0XN1+T0XN2+T0XN3
         T0YPP3=T0YN1+T0YN2+T0YN3
         Tau0PP=(T0N1+T0N2+T0N3)/3.d0
         TT0R=((0.5d0*Tau0PP*DT-1.0d0)/DT)/DT
         VIDBCPDXPP3=VIDBCPDX1N1+VIDBCPDX1N2+VIDBCPDX1N3
         VIDBCPDYPP3=VIDBCPDY1N1+VIDBCPDY1N2+VIDBCPDY1N3

C...  
C...  COMPUTE ELEMENTAL COEFFICIENTS
C...  
         AREAIE=AREAS(IE)       !2A
         FDX1 = (Y(NM2)-Y(NM3))*SFACPP !b1
         FDX2 = (Y(NM3)-Y(NM1))*SFACPP !b2
         FDX3 = (Y(NM1)-Y(NM2))*SFACPP !b3
         FDY1 = X(NM3)-X(NM2)   !a1
         FDY2 = X(NM1)-X(NM3)   !a2
         FDY3 = X(NM2)-X(NM1)   !a3
         FDX1OA=FDX1/AREAIE     !dphi1/dx
         FDY1OA=FDY1/AREAIE     !dphi1/dy
         FDX2OA=FDX2/AREAIE     !dphi2/dx
         FDY2OA=FDY2/AREAIE     !dphi2/dy
         FDX3OA=FDX3/AREAIE     !dphi3/dx
         FDY3OA=FDY3/AREAIE     !dphi3/dy

         DDX1=FDX1/3.d0         !<2*(dphi1/dx)*phij> j=1,2,3
         DDY1=FDY1/3.d0         !<2*(dphi1/dy)*phij> j=1,2,3
         DXX11=FDX1OA*FDX1      !<2*(dphi1/dx)*(dphi1/dx)>
         DYY11=FDY1OA*FDY1      !<2*(dphi1/dy)*(dphi1/dy)>
         DXY11=FDX1OA*FDY1      !<2*(dphi1/dx)*(dphi1/dy)>
         DXXYY11=DXX11+DYY11
         DXYH11=DPPP*DXXYY11
         DXX12=FDX1OA*FDX2      !<2*(dphi1/dx)*(dphi2/dx)>
         DYY12=FDY1OA*FDY2      !<2*(dphi1/dy)*(dphi2/dy)>
         DXY12=FDX1OA*FDY2      !<2*(dphi1/dx)*(dphi2/dy)>
         DXXYY12=DXX12+DYY12
         DXYH12=DPPP*DXXYY12
         DXX13=FDX1OA*FDX3      !<2*(dphi1/dx)*(dphi3/dx)>
         DYY13=FDY1OA*FDY3      !<2*(dphi1/dy)*(dphi3/dy)>
         DXY13=FDX1OA*FDY3      !<2*(dphi1/dx)*(dphi3/dy)>
         DXXYY13=DXX13+DYY13
         DXYH13=DPPP*DXXYY13

         DDX2=FDX2/3.d0         !<2*(dphi2/dx)*phij> j=1,2,3
         DDY2=FDY2/3.d0         !<2*(dphi2/dy)*phij> j=1,2,3
         DXX21=DXX12            !<2*(dphi2/dx)*(dphi1/dx)>
         DYY21=DYY12            !<2*(dphi2/dy)*(dphi1/dy)>
         DXY21=FDX2OA*FDY1      !<2*(dphi2/dx)*(dphi1/dy)>
         DXXYY21=DXXYY12
         DXYH21=DXYH12
         DXX22=FDX2OA*FDX2      !<2*(dphi2/dx)*(dphi2/dx)>
         DYY22=FDY2OA*FDY2      !<2*(dphi2/dy)*(dphi2/dy)>
         DXY22=FDX2OA*FDY2      !<2*(dphi2/dx)*(dphi2/dy)>
         DXXYY22=DXX22+DYY22
         DXYH22=DPPP*DXXYY22
         DXX23=FDX2OA*FDX3      !<2*(dphi2/dx)*(dphi3/dx)>
         DYY23=FDY2OA*FDY3      !<2*(dphi2/dy)*(dphi3/dy)>
         DXY23=FDX2OA*FDY3      !<2*(dphi2/dx)*(dphi3/dy)>
         DXXYY23=DXX23+DYY23
         DXYH23=DPPP*DXXYY23

         DDX3=FDX3/3.d0         !<2*(dphi3/dx)*phij> j=1,2,3
         DDY3=FDY3/3.d0         !<2*(dphi3/dy)*phij> j=1,2,3
         DXX31=DXX13            !<2*(dphi3/dx)*(dphi1/dx)>
         DYY31=DYY13            !<2*(dphi3/dy)*(dphi1/dy)>
         DXY31=FDX3OA*FDY1      !<2*(dphi3/dx)*(dphi1/dy)>
         DXXYY31=DXXYY13
         DXYH31=DXYH13
         DXX32=DXX23            !<2*(dphi3/dx)*(dphi2/dx)>
         DYY32=DYY23            !<2*(dphi3/dy)*(dphi2/dy)>
         DXY32=FDX3OA*FDY2      !<2*(dphi3/dx)*(dphi2/dy)>
         DXXYY32=DXXYY23
         DXYH32=DXYH23
         DXX33=FDX3OA*FDX3      !<2*(dphi3/dx)*(dphi3/dx)>
         DYY33=FDY3OA*FDY3      !<2*(dphi3/dy)*(dphi3/dy)>
         DXY33=FDX3OA*FDY3      !<2*(dphi3/dx)*(dphi3/dy)>
         DXXYY33=DXX33+DYY33
         DXYH33=DPPP*DXXYY33

         AO6=AREAIE/6.d0
         AO12=AREAIE/12.d0
         FDDD=(1+ILUMP)*AO6     !2*<phi*phj> diagonal terms
         FDDOD=(1-ILUMP)*AO12   !2*<phi*phj> off diagonal terms

C
C...  COMPUTE THE CONTRIBUTION OF A SPATIALLY VARIABLE Tau0
C 
        SpaVarTau0=(T0N1*DDX1+T0N2*DDX2+T0N3*DDX3)*UHPP
     *            +(T0N1*DDY1+T0N2*DDY2+T0N3*DDY3)*VHPP

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM1
C...  
         QTEMA1=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     *        -(FDDD*ESN1+FDDOD*ESN2+FDDOD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     *        -(DXYH11*E0N1+DXYH12*E0N2+DXYH13*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     *        -(DXYH11*E1N1+DXYH12*E1N2+DXYH13*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     *        +(T0XPP3-TauBXpp3)*DDX1
     *        +(T0YPP3-TauBYpp3)*DDY1
     *        +SpaVarTau0

C...  CORIOLIS FORCE
     *        +CORIFPP*(VHPP3*DDX1-UHPP3*DDY1)

C...  WIND STRESS & ATMONPHERIC PRESSURE GRADIENTS
     *        +(TauSXN1+TauSXN2+TauSXN3)*DDX1
     *        +(TauSYN1+TauSYN2+TauSYN3)*DDY1
     *        -GHPP*(PR1N1*DXXYY11+PR1N2*DXXYY12+PR1N3*DXXYY13)

C...  TIDAL POTENTIAL FORCING
     *        +GHPP*(TIPN1*DXXYY11+TIPN2*DXXYY12+TIPN3*DXXYY13)

C...  LATERAL VISCOSITY TERM  
     *        -EVMPPODT*(DXXYY11*ESN1+DXXYY12*ESN2+DXXYY13*ESN3)

C...  FINITE AMPLITUDE
     *        -GFAO2*(E1N1SQ*DXXYY11+E1N2SQ*DXXYY12+E1N3SQ*DXXYY13)

C...  ADVECTIVE TERMS
     *        -IFNLCT*(UHPP*(U1N1*DXX11+U1N2*DXX21+U1N3*DXX31
     *        +V1N1*DXY11+V1N2*DXY21+V1N3*DXY31)
     *        +VHPP*(U1N1*DXY11+U1N2*DXY12+U1N3*DXY13
     *        +V1N1*DYY11+V1N2*DYY21+V1N3*DYY31))

C...  advective terms (time derivative portion in gwce) which must be
c...  bundled in with the finite amplitude terms in order to get good
c...  mass conservation when the advective terms are shut down

     *        +TADVODT*(UPP*DDX1+VPP*DDY1)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS 
     *        -VIDBCPDXPP3*DDX1-VIDBCPDYPP3*DDY1

C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA1=QTEMA1-IFNLCT*(DUU1N1*DXX11+DUU1N2*DXX12+DUU1N3*DXX13
     *           +DUV1N1*DXY11+DUV1N2*DXY12+DUV1N3*DXY13
     *           +DUV1N1*DXY11+DUV1N2*DXY21+DUV1N3*DXY31
     *           +DVV1N1*DYY11+DVV1N2*DYY12+DVV1N3*DYY13)
           endif

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM2
C...  
         QTEMA2=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     *        -(FDDOD*ESN1+FDDD*ESN2+FDDOD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     *        -(DXYH12*E0N1+DXYH22*E0N2+DXYH23*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     *        -(DXYH12*E1N1+DXYH22*E1N2+DXYH23*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     *        +(T0XPP3-TauBXpp3)*DDX2
     *        +(T0YPP3-TauBYpp3)*DDY2
     *        +SpaVarTau0

C...  CORIOLIS FORCE
     *        +CORIFPP*(VHPP3*DDX2-UHPP3*DDY2)

C...  WIND AND ATMOSPHERIC PRESSURE FORCING
     *        +(TauSXN1+TauSXN2+TauSXN3)*DDX2
     *        +(TauSYN1+TauSYN2+TauSYN3)*DDY2
     *        -GHPP*(PR1N1*DXXYY21+PR1N2*DXXYY22+PR1N3*DXXYY23)

C...  TIDAL POTENTIAL FORCING
     *        +GHPP*(TIPN1*DXXYY21+TIPN2*DXXYY22+TIPN3*DXXYY23)

C...  LATERAL VISCOSITY TERM
     *        -EVMPPODT*(DXXYY12*ESN1+DXXYY22*ESN2+DXXYY23*ESN3)

C...  FINITE AMPLITUDE
     *        -GFAO2*(E1N1SQ*DXXYY21+E1N2SQ*DXXYY22+E1N3SQ*DXXYY23)

C...  ADVECTIVE TERMS
     *        -IFNLCT*(UHPP*(U1N1*DXX12+U1N2*DXX22+U1N3*DXX32
     *        +V1N1*DXY12+V1N2*DXY22+V1N3*DXY32)
     *        +VHPP*(U1N1*DXY21+U1N2*DXY22+U1N3*DXY23
     *        +V1N1*DYY12+V1N2*DYY22+V1N3*DYY32))

C...  advective terms (time derivative portion in gwce) which must be
c...  bundled in with the finite amplitude terms in order to get good
c...  mass conservation when the advective terms are shut down

     *        +TADVODT*(UPP*DDX2+VPP*DDY2)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS
     *        -VIDBCPDXPP3*DDX2-VIDBCPDYPP3*DDY2


C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA2=QTEMA2-IFNLCT*(DUU1N1*DXX12+DUU1N2*DXX22+DUU1N3*DXX23
     *           +DUV1N1*DXY21+DUV1N2*DXY22+DUV1N3*DXY23
     *           +DUV1N1*DXY12+DUV1N2*DXY22+DUV1N3*DXY32
     *           +DVV1N1*DYY12+DVV1N2*DYY22+DVV1N3*DYY23)
           endif

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM1
C...  
         QTEMA3=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     *        -(FDDOD*ESN1+FDDOD*ESN2+FDDD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     *        -(DXYH13*E0N1+DXYH23*E0N2+DXYH33*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     *        -(DXYH13*E1N1+DXYH23*E1N2+DXYH33*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     *        +(T0XPP3-TauBXpp3)*DDX3
     *        +(T0YPP3-TauBYpp3)*DDY3
     *        +SpaVarTau0

C...  CORIOLIS FORCE
     *        +CORIFPP*(VHPP3*DDX3-UHPP3*DDY3)

C...  WIND AND ATMOSPHERIC PRESSURE FORCING
     *        +(TauSXN1+TauSXN2+TauSXN3)*DDX3
     *        +(TauSYN1+TauSYN2+TauSYN3)*DDY3
     *        -GHPP*(PR1N1*DXXYY31+PR1N2*DXXYY32+PR1N3*DXXYY33)

C...  TIDAL POTENTIAL FORCING
     *        +GHPP*(TIPN1*DXXYY31+TIPN2*DXXYY32+TIPN3*DXXYY33)

C...  LATERAL VISCOSITY TERM
     *        -EVMPPODT*(DXXYY13*ESN1+DXXYY23*ESN2+DXXYY33*ESN3)

C...  FINITE AMPLITUDE
     *        -GFAO2*(E1N1SQ*DXXYY31+E1N2SQ*DXXYY32+E1N3SQ*DXXYY33)

C...  ADVECTIVE TERMS
     *        -IFNLCT*(UHPP*(U1N1*DXX13+U1N2*DXX23+U1N3*DXX33
     *        +V1N1*DXY13+V1N2*DXY23+V1N3*DXY33)
     *        +VHPP*(U1N1*DXY31+U1N2*DXY32+U1N3*DXY33
     *        +V1N1*DYY13+V1N2*DYY23+V1N3*DYY33))

C...  ADVECTIVE TERMS (TIME DERIVATIVE PORTION IN GWCE) WHICH MUST
C.... BE BUNDLED IN WITH THE FINITE AMPLITUDE TERMS IN ORDER TO GET GOOD
C...  MASS
C.... CONSERVATION WHEN THE ADVECTIVE TERMS ARE SHUT DOWN
     *        +TADVODT*(UPP*DDX3+VPP*DDY3)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS
     *        -VIDBCPDXPP3*DDX3-VIDBCPDYPP3*DDY3

C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA3=QTEMA3-IFNLCT*(DUU1N1*DXX13+DUU1N2*DXX23+DUU1N3*DXX33
     *           +DUV1N1*DXY31+DUV1N2*DXY32+DUV1N3*DXY33
     *           +DUV1N1*DXY13+DUV1N2*DXY23+DUV1N3*DXY33
     *           +DVV1N1*DYY13+DVV1N2*DYY23+DVV1N3*DYY33)
           endif

C     LINES TO RUN ON A VECTOR COMPUTER


C     LINES TO RUN ON A SCALAR COMPUTER.
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QW
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS

         QW(NM1)=QW(NM1)+QTEMA1*NCELE
         QW(NM2)=QW(NM2)+QTEMA2*NCELE
         QW(NM3)=QW(NM3)+QTEMA3*NCELE


 1037 CONTINUE

C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QW
C     ON A VECTOR COMPUTER USING THE TEMPORARY VECTORS


C...  
C...  SAVE THE ELEVATION AT THE PAST TIME STEP INTO ETA1 AND ZERO ETA2
C...  
      DO I=1,NP
         ETA1(I)=ETA2(I)
         ETA2(I)=0.0d0
      END DO

C...  AT ELEVATION BOUNDARY CONDITION NODES DETERMINE ELEVATION AT NEXT
C...  TIME STEP
C...  
C...  FOR PERIODIC ELEVATION BOUNDARY CONDITION

      DO J=1,NBFR
         IF(PER(J).EQ.0.) THEN
            NCYC=0.
         ELSE
            NCYC=INT(timeh/PER(J))
         ENDIF
         ARGJ=AMIG(J)*(timeh-NCYC*PER(J))+FACE(J)
         RFF=FF(J)*RAMP
         DO I=1,NETA
            ARG=ARGJ-EFA(J,I)
            NBDI=NBD(I)
            ETA2(NBDI)=ETA2(NBDI)+EMO(J,I)*RFF*COS(ARG)
         END DO
      END DO

C...  FOR APERIODIC ELEVATION BOUNDARY CONDITION

      IF((NBFR.EQ.0).AND.(NOPE.GT.0)) THEN
         IF(TIME.GT.ETIME2) THEN
            ETIME1=ETIME2
            ETIME2=ETIME1+ETIMINC
            DO J=1,NETA
               ESBIN1(J)=ESBIN2(J)
               READ(19,*) ESBIN2(J)
            END DO
         ENDIF
         ETRATIO=(TIME-ETIME1)/ETIMINC
         DO I=1,NETA
            NBDI=NBD(I)
            ETA2(NBDI)=RAMP*(ESBIN1(I)+ETRATIO*(ESBIN2(I)-ESBIN1(I)))
         END DO
      ENDIF


C...  IMPOSE NORMAL FLOW OR RADIATION BOUNDARY CONDITIONS ALONG FLOW
C...  BOUNDARY TO LOAD VECTOR QW(I) NOTE, THESE VALUES ALL MUST BE
C...  MULTIPLIED BY 2 SINCE ALL ELEMENTAL COEFFICIENTS HAVE BEEN.
C...  
      IF((NFLUXF.EQ.1).OR.(NFLUXB.EQ.1).OR.(NFLUXIB.EQ.1)
     *     .OR.(NFLUXRBC.EQ.1)) THEN
         NBDJ=NBV(1)
         IF(LBCODEI(1).LE.29) QFORCEJ=(QN2(1)-QN0(1))/DT2 + 
     *        Tau0VAR(NBDJ)*QN1(1)
         IF(LBCODEI(1).EQ.30) THEN
            HH1=DP(NBDJ)+IFNLFA*ETA2(NBDJ)
            CELERITY=SQRT(G*HH1)
            QFORCEJ=-CELERITY*ETAS(NBDJ)/DT - Tau0VAR(NBDJ)*QN1(1)
         ENDIF
         DO J=2,NVEL
            NBDI=NBDJ
            NBDJ=NBV(J)
            QFORCEI=QFORCEJ
            IF(LBCODEI(J).LE.29) QFORCEJ=(QN2(J)-QN0(J))/DT2+
     *           Tau0VAR(NBDJ)*QN1(J)
            IF(LBCODEI(J).EQ.30) THEN
               HH1=DP(NBDJ)+IFNLFA*ETA2(NBDJ)
               CELERITY=SQRT(G*HH1)
               QFORCEJ=-CELERITY*ETAS(NBDJ)/DT - Tau0VAR(NBDJ)*QN1(J)
            ENDIF
            NCI=NODECODE(NBDI)
            NCJ=NODECODE(NBDJ)
            NCBND=NCI*NCJ
            BNDLEN2O3NC=NCBND*BNDLEN2O3(J-1)
            QW(NBDI)=QW(NBDI) + BNDLEN2O3NC*(QFORCEI+QFORCEJ/2.D0)
            QW(NBDJ)=QW(NBDJ) + BNDLEN2O3NC*(QFORCEJ+QFORCEI/2.D0)
         END DO
      ENDIF

C...
C...  IMPOSE ELEVATION BOUNDARY CONDITIONS TO LOAD VECTOR QW(I) NOTE; EP
C...  IS THE RMS OF ALL THE DIAGONAL MEMBERS IN THE GWCE.  IT IS USED TO
C...  SCALE THE DIAGONAL ELEMENT FOR THE ELEVATION SPECIFIED BOUNDARY
C...  NODES AND THEREFORE MUST ALSO BE USED TO SCALE THE RHS OF THE
C...  EQUATIONS
C...  
      DO I=1,NETA
         NBDI=NBD(I)
         ETAS(NBDI)=ETA2(NBDI)-ETA1(NBDI)
         QW(NBDI)=ETAS(NBDI)*NODECODE(NBDI)*EP
         DO J=2,NNEIGH(NBDI)
            QW(NEITAB(NBDI,J))=QW(NEITAB(NBDI,J))
     *           -ETAS(NBDI)*OBCCOEF(I,J-1)
         END DO
      END DO

C...  
C...  SOLVE GWCE FOR ELEVATION AT NEW TIME LEVEL
C...  

C...  UPDATE LOAD VECTOR INITIAL GUESS and DIAGONAL FOR GWCE SOLVE




C...  JCG ITERATIVE MATRIX SOLVER
      IPARM(1)=ITMAX
      CALL JCG(NP,MNP,MNEI,NEITAB,COEF,QW,ETAS,
     *     IWKSP,NW,WKSP,IPARM,RPARM,IER)

      NUMITR=IPARM(1)
      DO I=1,NP
         ETA2(I)=NODECODE(I)*ETAS(I)+ETA1(I) !COMPUTE NEW ELEVATIONS
      END DO
     
C     UPDATE ELEVATIONS




C     WET...
C     WET...THE FOLLOWING LINES ARE FOR WETTING AND DRYING
C     WET...
C     WET...NOTE:NODEREP is the number of time steps since a node last changed its
C     WET...              wet/dry state
C     WET...NOTE:NNODECODE is a working variable that can change more than once
C     WET...               during a time step 
C     WET...     NNODECODE = 0 for a dry node
C     WET...     NNODECODE = 1 for a wet node
C     WET...     NODECODE  - is a more static version of NNODECODE that is reconciled
C     WET...                 once and for all at the end time step
C     WET...
C     WET...
C     WET...        (   DRYING CRITERIA   )
C     WET...
C     WET...A node should be dry under two conditions.
C     WET...D1.) If the total water depth falls below H0. This is overridden and a
C     WET........node is not allowed to dry if it has changed state within the previous
C     WET........NODEWETMIN timesteps.
C     WET .......Note: if the total water depth falls below H0/10, the surface elevation
C     WET........is lifted up so that the total water depth = H0/10.
C     WET......
C     WET...D2.) If the node is connected to only nonfunctioning (dry) elements.  In
C     WET........this case the node is dried due to becoming landlocked.
C     WET........Note: this criteria is applied after all other wetting and drying criteria
C     WET...
C     WET...
C     WET...        (   WETTING CRITERIA   )
C     WET...
C     WET...A node should be wet under two conditions.
C     WET...W1.) If 2 nodes on an element are wet and one is dry, wet the dry node 
C     WET........if the water level at one of the wet nodes is greater than the 
C     WET........water level at the dry node and the steady state velocity that 
C     WET........would result from a balance between the water level gradient and 
C     WET........bottom friction would yield a velocity > VELMIN.   This is 
C     WET........overridden and a node is not allowed to wet if it has changed state
C     WET........within the previous NODEDRYMIN timesteps.
C     WET...
C     WET...W2.) If an element has a node lying on an internal barrier boundary or 
C     WET......specified discharge boundary that is actively discharging flow into the
C     WET......domain at that node, all nodes in this element must stay wet. 
C     WET...
C     WET...
C     WET...        (  VELOCITY BOUNDARY CONDITION  )
C     WET...
C     WET...Either a natural or essential boundary condition can be used as a velocity 
C     WET...boundary condition in the momentum equation solution along a wet/dry boudary
C     WET...To use a natural boundary condition, do nothing along the wet/dry interface.
C     WET...To use an essential, no velocity boundary condition, identify the nodes along
C     WET...the wet/dry interface and zero out the velocity at the nodes.  Interface nodes
C     WET...can easily be identified by comparing the number of active elements a node is
C     WET...connected to (MJU) to the total number of elements a node is connected to (NODELE).
C     WET...If MJU < NODELE for any node, it must lie along the wet/dry interface.  See
C     WET...further comments at the end of the momentum equation solution section.
C     WET...
C     WET...WET/DRY - PART 1 - DRYING CRITERIA D1
C     WET...

      IF(NOLIFA.EQ.2) THEN      !  this goes on until end of part 4
C     
         DO I=1,NP
            NODEREP(I)=NODEREP(I)+1
            NIBCNT(I) = 0   
         ENDDO

                                ! Drying Criteria D1: this depends on NODECODE and updates NODECODE
         HABSMIN=0.8D0*H0
         DO I=1,NP
            IF(NODECODE(I).EQ.1) THEN
               HTOT=DP(I)+ETA2(I)
               IF(HTOT.LE.H0) THEN
                  IF(HTOT.LT.HABSMIN) ETA2(I)=HABSMIN-DP(I)
                  IF(NODEREP(I).GT.NODEWETMIN) THEN
                     NNODECODE(I)=0
                     NODECODE(I)=0
                     NODEREP(I)=0
                     NCCHANGE=1 !NCCHARGE=0 set near the beginning of the time loop
c     vjp            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9881) I
 9881                FORMAT(' !!! NODE ',I6,' DRIED (HTOT<H0)')
                  ELSE
c     vjp            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9882) I
 9882                FORMAT(
     *                    ' !!! NODE ',I6,' WAS PREVENTED FROM DRYING ',
     *                    '(HTOT<H0) BECAUSE NODEREP<NODEWETMIN') 
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
  
CWET...
CWET...END WET/DRY SECTION - PART 1
CWET...

CWET...
CWET...WET/DRY SECTION PART 2 - WETTING LOOPS W1 AND W2
CWET...
         DO I=1,NE
            NM1=NM(I,1)
            NM2=NM(I,2)
            NM3=NM(I,3)
            
C     WET...Wetting Criteria W1: This depends on changes that occurred in D1

            NCTOT=NODECODE(NM1)+NODECODE(NM2)+NODECODE(NM3)
            IF(NCTOT.EQ.2) THEN
               IF((NODECODE(NM1).EQ.1).AND.(NODECODE(NM2).EQ.1)) THEN
                  NM123=NM1
                  if(eta2(NM2).gt.eta2(NM1)) NM123=NM2
                  deldist=sqrt((y(NM3)-y(NM123))**2+(x(NM3)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM3)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
                  tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     *                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM3).GT.NODEDRYMIN) THEN
                        NNODECODE(NM3)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     *                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     *                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM3
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM3
                     ENDIF
                  endif  
               ELSEIF((NODECODE(NM2).EQ.1).AND.(NODECODE(NM3).EQ.1)) THEN
                  NM123=NM2
                  if(eta2(NM3).gt.eta2(NM2)) NM123=NM3
                  deldist=sqrt((y(NM1)-y(NM123))**2+(x(NM1)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM1)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
                  tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     *                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0          
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM1).GT.NODEDRYMIN) THEN
                        NNODECODE(NM1)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     *                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     *                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM1
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM1
                     ENDIF
                  endif 
               ELSEIF((NODECODE(NM3).EQ.1).AND.(NODECODE(NM1).EQ.1)) THEN
                  NM123=NM3
                  if(eta2(NM1).gt.eta2(NM3)) NM123=NM1
                  deldist=sqrt((y(NM2)-y(NM123))**2+(x(NM2)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM2)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
                  tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     *                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM2).GT.NODEDRYMIN) THEN
                        NNODECODE(NM2)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     *                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     *                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM2
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM2
                     ENDIF
                  endif  
               ENDIF
 9884          FORMAT(' !!! NODE ',I6,' WETTED (VEL>VELMIN)')
 9885          FORMAT(' !!! NODE ',I6,' WAS PREVENTED FROM WETTING ',
     *              '(VEL>VELMIN) BECAUSE NODEREP<NODEDRYMIN') 
            ENDIF

C     WET...Wetting Criteria W2a

            NBNCTOT=NIBNODECODE(NM1)+NIBNODECODE(NM2)+NIBNODECODE(NM3)
            NIBCNT(NM1) = NIBCNT(NM1) + nbnctot
            NIBCNT(NM2) = NIBCNT(NM2) + nbnctot
            NIBCNT(NM3) = NIBCNT(NM3) + nbnctot

         ENDDO

C     WET...Wetting Criteria W2b

         DO I=1,NP
            IF(NIBCNT(I).GT.0) THEN
               IF(NNODECODE(I).EQ.0) THEN
                  NNODECODE(I)=1
c     vjp          IF((NSCREEN.EQ.1).AND.(MYPROC.EQ.0)) WRITE(*,9886) I
 9886             FORMAT(' !!! NODE ',I6,' WAS FORCED TO BE WET BECAUSE',
     *                 ' OF OVERFLOW BARRIER DISCHARGE') 
               ENDIF
            ENDIF
         ENDDO

C     Use Message-Passing to update nnodecode at ghost nodes


CWET...
CWET...END WET/DRY SECTION - PART 2
CWET...


CWET...  
CWET...WET/DRY SECTION PART 3 - DRYING LOOP D2 
CWET...Update number of active elements (MJU) connected to a node.  
CWET...If this is zero, it indicates a landlocked node that should be dried.
CWET...This depends on NNODECODE which varies during the time step
CWET...
         DO I=1,NP
            MJU(I)=0
         ENDDO
         DO I=1,NE
            NM1=NM(I,1)
            NM2=NM(I,2)
            NM3=NM(I,3)
            NC1=NNODECODE(NM1)
            NC2=NNODECODE(NM2)
            NC3=NNODECODE(NM3)
            NCELE=NC1*NC2*NC3
            MJU(NM1)=MJU(NM1)+NCELE
            MJU(NM2)=MJU(NM2)+NCELE
            MJU(NM3)=MJU(NM3)+NCELE
         ENDDO
         DO I=1,NP
            IF((NNODECODE(I).EQ.1).AND.(MJU(I).EQ.0)) THEN
               NNODECODE(I)=0
c     vjp        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9883) I
 9883          FORMAT(' !!! NODE ',I6,' DRIED (LANDLOCKING)')
            ENDIF
            IF(MJU(I).EQ.0) MJU(I)=1 !Because MJU is also used to solve Mom Eq.
         ENDDO
C     WET...
C     WET...END WET/DRY SECTION - PART 3
C     WET...

C     Use Message-Passing to update nnodecode at ghost nodes



CWET...  
CWET...WET/DRY SECTION - PART 4 - RESET NODECODE USING NNODECODE 
CWET...Check to see if any wetting occurred & update NODEREP & NODECODE 
CWET...Note, NCCHANGE=0 set near the beginning of the time step loop 
CWET...
         DO I=1,NP
            IF(NNODECODE(I).NE.NODECODE(I)) THEN
               NODECODE(I)=NNODECODE(I)
               NODEREP(I)=0
               NCCHANGE=1             
            ENDIF
         ENDDO

CWET...
CWET...END WET/DRY SECTION - PART 4
CWET...

      ENDIF                     !  This is started in Part 1 of CWET


C...  
C...  2 DDI MOMENTUM EQUATION SOLUTION
C...  
      IF (C2DDI) THEN    
C
C...  UPDATE LOAD VECTOR QU(I) AND QV(I) NOTE: QU, QV AND AUV ARE ZEROED
C...  OUT AT THE TOP OF THE TIME STEPPING LOOP.

C.....FIRST TREAT THE NON-LUMPED PART OF THE EQUATIONS.

         DO 9999 IE=1,NE

C...  SET NODAL VALUES FOR EACH ELEMENT

            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            NC1=NODECODE(NM1)
            NC2=NODECODE(NM2)
            NC3=NODECODE(NM3)
            NCELE=NC1*NC2*NC3
            U1N1=UBAR1(NM1)
            U1N2=UBAR1(NM2)
            U1N3=UBAR1(NM3)
            V1N1=VBAR1(NM1)
            V1N2=VBAR1(NM2)
            V1N3=VBAR1(NM3)
            ESN1=ETAS(NM1)
            ESN2=ETAS(NM2)
            ESN3=ETAS(NM3)
            HH1N1=DP(NM1)+IFNLFA*ETA1(NM1)
            HH1N2=DP(NM2)+IFNLFA*ETA1(NM2)
            HH1N3=DP(NM3)+IFNLFA*ETA1(NM3)
            SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0

            AREAIE=AREAS(IE)
            FDX1=(Y(NM2)-Y(NM3))*SFACPP !b1
            FDX2=(Y(NM3)-Y(NM1))*SFACPP !b2
            FDX3=(Y(NM1)-Y(NM2))*SFACPP !b3
            FDY1=X(NM3)-X(NM2)  !a1
            FDY2=X(NM1)-X(NM3)  !a2
            FDY3=X(NM2)-X(NM1)  !a3
            FDX1OA=FDX1/AREAIE  !dphi1/dx
            FDY1OA=FDY1/AREAIE  !dphi1/dy
            FDX2OA=FDX2/AREAIE  !dphi2/dx
            FDY2OA=FDY2/AREAIE  !dphi2/dy
            FDX3OA=FDX3/AREAIE  !dphi3/dx
            FDY3OA=FDY3/AREAIE  !dphi3/dy
            
            DDX1=FDX1/3.d0      !<2*(dphi1/dx)*phij> j=1,2,3
            DDY1=FDY1/3.d0      !<2*(dphi1/dy)*phij> j=1,2,3
            DXX11=FDX1OA*FDX1   !<2*(dphi1/dx)*(dphi1/dx)>
            DYY11=FDY1OA*FDY1   !<2*(dphi1/dy)*(dphi1/dy)>
            DXXYY11=DXX11+DYY11
            DXX12=FDX1OA*FDX2   !<2*(dphi1/dx)*(dphi2/dx)>
            DYY12=FDY1OA*FDY2   !<2*(dphi1/dy)*(dphi2/dy)>
            DXXYY12=DXX12+DYY12
            DXX13=FDX1OA*FDX3   !<2*(dphi1/dx)*(dphi3/dx)>
            DYY13=FDY1OA*FDY3   !<2*(dphi1/dy)*(dphi3/dy)>
            DXXYY13=DXX13+DYY13

            DDX2=FDX2/3.d0      !<2*(dphi2/dx)*phij> j=1,2,3
            DDY2=FDY2/3.d0      !<2*(dphi2/dy)*phij> j=1,2,3
            DXXYY21=DXXYY12
            DXX22=FDX2OA*FDX2   !<2*(dphi2/dx)*(dphi2/dx)>
            DYY22=FDY2OA*FDY2   !<2*(dphi2/dy)*(dphi2/dy)>
            DXXYY22=DXX22+DYY22
            DXX23=FDX2OA*FDX3   !<2*(dphi2/dx)*(dphi3/dx)>
            DYY23=FDY2OA*FDY3   !<2*(dphi2/dy)*(dphi3/dy)>
            DXXYY23=DXX23+DYY23

            DDX3=FDX3/3.d0      !<2*(dphi3/dx)*phij> j=1,2,3
            DDY3=FDY3/3.d0      !<2*(dphi3/dy)*phij> j=1,2,3
            DXXYY31=DXXYY13
            DXXYY32=DXXYY23
            DXX33=FDX3OA*FDX3   !<2*(dphi3/dx)*(dphi3/dx)>
            DYY33=FDY3OA*FDY3   !<2*(dphi3/dy)*(dphi3/dy)>
            DXXYY33=DXX33+DYY33

            FIIN=AREAIE/3.D0    !2*<phi*phj> lumped

C...  ACCUMULATE NODAL VALUES FOR CERTAIN ELEMENTAL COEFFICIENTS

            VCOEF3N1=ETA1(NM1)+ETA2(NM1)
            VCOEF3N2=ETA1(NM2)+ETA2(NM2)
            VCOEF3N3=ETA1(NM3)+ETA2(NM3)

C......If using wind

            IF(NWS.NE.0) THEN
               VCOEF3N1=VCOEF3N1+PR1(NM1)+PR2(NM1)
               VCOEF3N2=VCOEF3N2+PR1(NM2)+PR2(NM2)
               VCOEF3N3=VCOEF3N3+PR1(NM3)+PR2(NM3)
            ENDIF

C     TIP...If using tidal potential terms

            if (CTIP) then
               VCOEF3N1=VCOEF3N1-TIP1(NM1)-TIP2(NM1)
               VCOEF3N2=VCOEF3N2-TIP1(NM2)-TIP2(NM2)
               VCOEF3N3=VCOEF3N3-TIP1(NM3)-TIP2(NM3)
            endif

            VCOEF3N1=VCOEF3N1*GDTO2
            VCOEF3N2=VCOEF3N2*GDTO2
            VCOEF3N3=VCOEF3N3*GDTO2

C...  COMPUTE ELEMENT AVERAGES QUANTITIES

            UPPDT=SADVDTO3*(U1N1+U1N2+U1N3)
            VPPDT=SADVDTO3*(V1N1+V1N2+V1N3)
            UPPDTDDX1=UPPDT*DDX1
            UPPDTDDX2=UPPDT*DDX2
            UPPDTDDX3=UPPDT*DDX3
            VPPDTDDY1=VPPDT*DDY1
            VPPDTDDY2=VPPDT*DDY2
            VPPDTDDY3=VPPDT*DDY3
            EVMPPDT=((EVM(NM1)+EVM(NM2)+EVM(NM3))/3.d0)*DT

C...  ASSEMBLE PARTIAL PRODUCTS

            VCOEF3X=VCOEF3N1*DDX1+VCOEF3N2*DDX2+VCOEF3N3*DDX3
            VCOEF3Y=VCOEF3N1*DDY1+VCOEF3N2*DDY2+VCOEF3N3*DDY3
            ADVECX=(UPPDTDDX1+VPPDTDDY1)*U1N1
     *           +(UPPDTDDX2+VPPDTDDY2)*U1N2
     *           +(UPPDTDDX3+VPPDTDDY3)*U1N3
            ADVECY=(UPPDTDDX1+VPPDTDDY1)*V1N1
     *           +(UPPDTDDX2+VPPDTDDY2)*V1N2
     *           +(UPPDTDDX3+VPPDTDDY3)*V1N3
C
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO
C...  QTEMA
C.... VECTOR FOR NODE NM1

            QTEMA1=NCELE*(               
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3X
C...  LATERAL VISCOUS TERMS
     *           -EVMPPDT*(DXXYY11*U1N1+DXXYY12*U1N2+DXXYY13*U1N3)
C...  ADVECTIVE TERMS
     *           -ADVECX
C...  COMMON DIVISION OPERATION
     *           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO QTEMA
C.... VECTOR FOR NODE NM2
C...  
            QTEMA2=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3X
C...  LATERAL VISCOUS TERMS]
     *           -EVMPPDT*(DXXYY21*U1N1+DXXYY22*U1N2+DXXYY23*U1N3)
C...  ADVECTIVE TERMS
     *           -ADVECX
C...  COMMON DIVISION OPERATION
     *           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO QTEMA
C.... VECTOR FOR NODE NM3
C...  
            QTEMA3=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3X
C...  LATERAL VISCOUS TERMS
     *           -EVMPPDT*(DXXYY31*U1N1+DXXYY32*U1N2+DXXYY33*U1N3)
C...  ADVECTIVE TERMS
     *           -ADVECX
C...  COMMON DIVISION OPERATION
     *           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM1
C...  
            QTEMB1=NCELE*( 
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     *           -EVMPPDT*(DXXYY11*V1N1+DXXYY12*V1N2+DXXYY13*V1N3)
C...  ADVECTIVE TERMS
     *           -ADVECY
C...  COMMON DIVISION OPERATION
     *           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM2
C...  
            QTEMB2=NCELE*(  
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     *           -EVMPPDT*(DXXYY21*V1N1+DXXYY22*V1N2+DXXYY23*V1N3)
C...  ADVECTIVE TERMS
     *           -ADVECY
C...  COMMON DIVISION OPERATION
     *           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM3
C...  
            QTEMB3=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     *           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     *           -EVMPPDT*(DXXYY31*V1N1+DXXYY32*V1N2+DXXYY33*V1N3)
C...  ADVECTIVE TERMS
     *           -ADVECY
C...  COMMON DIVISION OPERATION
     *           )/FIIN

C     LINES TO RUN ON A VECTOR COMPUTER


C     LINES TO RUN ON A SCALAR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QU, QV AND QUV
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS

            QU(NM1)=QU(NM1)+QTEMA1
            QU(NM2)=QU(NM2)+QTEMA2
            QU(NM3)=QU(NM3)+QTEMA3
            QV(NM1)=QV(NM1)+QTEMB1
            QV(NM2)=QV(NM2)+QTEMB2
            QV(NM3)=QV(NM3)+QTEMB3


 9999 CONTINUE
         
C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QU, QV AND AUV


C...  UPDATE MOMENTUM EQUATION LHS COEFFICIENTS AND LOAD VECTORS AT EACH
C...  NODE BY DIVIDING BY NUMBER OF ELEMENTS THE NODE IS ASSOCIATED WITH
C...  AND ADDING IN LUMPED TERMS AND BOTTOM FRICTION AND TAKING ACCOUNT
C...  OF THE BOUNDARY CONDITION

         TauSX=0.D0
         TauSY=0.D0
         DO I=1,NP
            NCI=NNODECODE(I)
            QU(I)=QU(I)/MJU(I)
            QV(I)=QV(I)/MJU(I)
            HH1=DP(I)+IFNLFA*ETA1(I)
            HH2=DP(I)+IFNLFA*ETA2(I)
            IF((NWS.NE.0).OR.(NRS.NE.0)) THEN
               TauSX=DTO2*IFWIND*(TauSX1(I)/HH1+TauSX2(I)/HH2)
               TauSY=DTO2*IFWIND*(TauSY1(I)/HH1+TauSY2(I)/HH2)
            ENDIF
            VCOEF1=DTO2*TK(I)
            VCOEF2=DTO2*CORIF(I)
            VIDBCPDX=DT*VIDBCPDX1(I)/HH1
            VIDBCPDY=DT*VIDBCPDY1(I)/HH1
            QU(I)=NCI*(QU(I)+TauSX+(1.D0-VCOEF1)*UBAR1(I)+VCOEF2*VBAR1(I)
     *           -VIDBCPDX)
            QV(I)=NCI*(QV(I)+TauSY+(1.D0-VCOEF1)*VBAR1(I)-VCOEF2*UBAR1(I)
     *           -VIDBCPDY)
            AUV11(I)=1.D0+VCOEF1*NCI
            AUV12(I)=-VCOEF2*NCI
         END DO

C...  IF A SPECIFIED NORMAL FLOW ESSENTIAL BOUNDARY CONDITION IS USED,
C.... IMPOSE NORMAL FLOW BOUNDARY CONDITIONS TO MOMENTUM MATRIX AND LOAD
C.... VECTOR NOTE:THIS HAS BEEN SPECIALLY FORMULATED TO MAINTAIN THE
C.... BASIC STRUCTURE OF THE LHS MATRIX (I.E., AUV11=AUV22;
C.... AUV12=-AUV21)

         DO J=1,NVELME
            I=ME2GW(J)
            NBDI=NBV(I)
            HH2=DP(NBDI)+IFNLFA*ETA2(NBDI)
            NCI=NODECODE(NBDI)
            IF((LBCODEI(I).GE.0).AND.(LBCODEI(I).LE.9)) THEN !ESSENTIAL NORMAL FLOW
               VELNORM=-QN2(I)/HH2 !AND FREE TANGENTIAL SLIP
               QU(NBDI)=(SIII(I)*QU(NBDI)-CSII(I)*QV(NBDI)
     *              -VELNORM*AUV12(NBDI))*NCI !TANGENTIAL EQN
               QV(NBDI)=VELNORM*AUV11(NBDI)*NCI !NORMAL EQN
               AUV12(NBDI)=-CSII(I)*AUV11(NBDI)
               AUV11(NBDI)=SIII(I)*AUV11(NBDI)
            ENDIF
            IF((LBCODEI(I).GE.10).AND.(LBCODEI(I).LE.19)) THEN !ESSENTIAL NORMAL FLOW
               VELNORM=-QN2(I)/HH2 !AND NO TANGENTIAL SLIP
               VELTAN=0.D0
               QU(NBDI)=VELTAN*NCI !TANGENTIAL EQN
               QV(NBDI)=VELNORM*NCI !NORMAL EQN
               AUV11(NBDI)=SIII(I)
               AUV12(NBDI)=-CSII(I)
            ENDIF
         END DO

C...  SOLVE FOR VELOCITY AT NEW LEVEL  (K+1)

C.....Note: This includes the comparison between MJU and NODELE to
C.....determine if the node is an interface node.  If MJU < NODELE the
C.....velocity can be zeroed out to obtain an essential zero velocity at
C.....interface nodes.

         DO I=1,NP
            AUV22=AUV11(I)
            AUV21=-AUV12(I)
            DDU=AUV11(I)*AUV22-AUV12(I)*AUV21
            UBAR2(I)=(QU(I)*AUV22-QV(I)*AUV12(I))/DDU
            VBAR2(I)=(QV(I)*AUV11(I)-QU(I)*AUV21)/DDU

c           IF(MJU(I).NE.NODELE(I)) THEN !uncomment for essential
c              UBAR2(I)=0.D0    !no slip and normal flux
c              VBAR2(I)=0.D0    !on wet/dry interface nodes
c           ENDIF                               

         END DO

C...  UPDATE VELOCITIES

     
      ENDIF 
C...  
C     C2DDI....END OF 2 DDI MOMENTUM EQUATION SOLUTION
C...  


C...  
C...  3 DVS Momentum Equation Solution
C...
      IF (C3DVS) THEN

C... Load the vector QU(I) with barotropic pressure terms 
C...     including atmospheric pressure, water level and tidal potential
C...     averaged between time levels s and s+1, (time levels 1 and 2).

        DO I=1,NP
          QU(I)=ETA1(I)+ETA2(I)
          IF(NWS.NE.0) QU(I)=QU(I)+PR1(I)+PR2(I)   !atmospheric pressure
          IF (CTIP) QU(I)=QU(I)-TIP1(I)-TIP2(I)    !tidal potential
          QU(I)=G*QU(I)/2.d0
          ENDDO

C...  Solve for velocity at the new time level (K+1)

        CALL VSSOL(IT,TIME,DT)

        ENDIF
C...  
C...  End of 3 DVS Momentum Equation Solution
C...  



C...  
C...  IF TRANSPORT IS INCLUDED SOLVE FOR THE CONCENTRATION
C...  NOTE: THE VARIABLE CH1(I) IS ACTUALLY C*H
C...  
      IF(IM.EQ.10) THEN

C.... COMPUTE SOURCE/SINK TERM AT THE NODES USING CLASSICAL COHESIVE
C.... SEDIMENT TRANSPORT RELATIONS

         rho0  = RHOWAT0        ! reference density of seawater [kg/m^3]
         WS = 0.0001d0          ! particle fall velocity [m/s]
         CBEDSTRD = 0.15d0      ! critical shear stress for deposition [N/m^2]
         CCRITD = 0.30d0        ! critical concentration for hindered settling [kg/m^3]
         ECONST = 0.00001d0     ! erosion rate constant [kg/m^2/sec]
         CBEDSTRE = 0.4d0       ! critical shear stress for erosion [N/m^2]

         DO I=1,NP
            UV1=SQRT(UBAR1(I)*UBAR1(I)+VBAR1(I)*VBAR1(I))
            HH1=DP(I)+IFNLFA*ETA1(I)
            BEDSTR=HH1*UV1*TK(I)*rho0 !in N/m^2
            C1=CH1(I)/HH1

C.....Calculate the deposition rate using Krone's (1962) formulation:
C.....dC/dt = -P*WSMOD*C/D     where
C.....WSMOD=WS          when C < Ccrit  and
C.....WSMOD=K*C**1.33   when C > Ccrit
C.....D is the average depth through which particles settle D = H/2,
C.....H is the water depth
C.....C is the depth-averaged sediment concentration,
C.....P is the sticking probability  P = (1-BEDSTR/CBEDSTRD),
C.....CBEDSTRD is the critical bottom stress above which no deposition occurs.
C.....It was assumed that the constant K could be backed out by setting
C.....WSMOD = WS when C = Ccrit.

            WSMOD=WS
            IF(C1.GT.CCRITD) WSMOD=WS*(C1/CCRITD)**1.33d0
            HSD=0.d0
            IF(BEDSTR.LT.CBEDSTRD) HSD=-(2.d0*WSMOD*C1)*
     *           (1.0d0-BEDSTR/CBEDSTRD)
            IF(HSD.GT.0.d0) HSD=0.d0

C.....Calculate the surface erosion rate for cohesive sediment using
C.....the Ariathurai et at. (1977) adaption of Partheniades' (1962) findings

            HSE=0.
            IF(BEDSTR.GT.CBEDSTRE) HSE=ECONST*(BEDSTR/CBEDSTRE-1.0)

C.....Determine the total source sink term

            SOURSIN(I)=HSD+HSE
         END DO

C.... UPDATE THE TRANSPORT EQUATION ELEMENT BY ELEMENT BY FORMING
C.... TEMPORARY VECTORS AND THEN ASSEMBLING.  NOTE: QB(I), QA(I) ARE
C.... ZEROED OUT AT THE TOP OF THE TIME STEPPING LOOP.  AGAIN THESE
C.... LOOPS HAVE BEEN UNROLLED TO OPTIMIZE VECTORIZATION

         DO 1057 IE=1,NE

C.....SET NODAL VALUES FOR EACH ELEMENT

            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            NC1=NODECODE(NM1)
            NC2=NODECODE(NM2)
            NC3=NODECODE(NM3)
            NCELE=NC1*NC2*NC3
            U1N1=UBAR1(NM1)
            U1N2=UBAR1(NM2)
            U1N3=UBAR1(NM3)
            V1N1=VBAR1(NM1)
            V1N2=VBAR1(NM2)
            V1N3=VBAR1(NM3)
            CH1N1=CH1(NM1)
            CH1N2=CH1(NM2)
            CH1N3=CH1(NM3)
            EVC1=EVC(NM1)
            EVC2=EVC(NM2)
            EVC3=EVC(NM3)
            SS1N1=SOURSIN(NM1)
            SS1N2=SOURSIN(NM2)
            SS1N3=SOURSIN(NM3)
            HH1N1=DP(NM1)+IFNLFA*ETA1(NM1)
            HH1N2=DP(NM2)+IFNLFA*ETA1(NM2)
            HH1N3=DP(NM3)+IFNLFA*ETA1(NM3)
            SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.

C.....COMPUTE ELEMENTAL MATRICIES

            AREAIE=AREAS(IE)    !2*element area
            FDX1=(Y(NM2)-Y(NM3))*SFACPP !b1
            FDX2=(Y(NM3)-Y(NM1))*SFACPP !b2
            FDX3=(Y(NM1)-Y(NM2))*SFACPP !b3
            FDY1=X(NM3)-X(NM2)  !a1
            FDY2=X(NM1)-X(NM3)  !a2
            FDY3=X(NM2)-X(NM1)  !a3
            FDX1OA=FDX1/AREAIE  !dphi1/dx
            FDY1OA=FDY1/AREAIE  !dphi1/dy
            FDX2OA=FDX2/AREAIE  !dphi2/dx
            FDY2OA=FDY2/AREAIE  !dphi2/dy
            FDX3OA=FDX3/AREAIE  !dphi3/dx
            FDY3OA=FDY3/AREAIE  !dphi3/dy

            DDX1=FDX1/3.        !<2*(dphi1/dx)*phij> j=1,2,3
            DDY1=FDY1/3.        !<2*(dphi1/dy)*phij> j=1,2,3
            DXX11=FDX1OA*FDX1   !<2*(dphi1/dx)*(dphi1/dx)>
            DYY11=FDY1OA*FDY1   !<2*(dphi1/dy)*(dphi1/dy)>
            DXXYY11=DXX11+DYY11
            DXX12=FDX1OA*FDX2   !<2*(dphi1/dx)*(dphi2/dx)>
            DYY12=FDY1OA*FDY2   !<2*(dphi1/dy)*(dphi2/dy)>
            DXXYY12=DXX12+DYY12
            DXX13=FDX1OA*FDX3   !<2*(dphi1/dx)*(dphi3/dx)>
            DYY13=FDY1OA*FDY3   !<2*(dphi1/dy)*(dphi3/dy)>
            DXXYY13=DXX13+DYY13

            DDX2=FDX2/3.        !<2*(dphi2/dx)*phij> j=1,2,3
            DDY2=FDY2/3.        !<2*(dphi2/dy)*phij> j=1,2,3
            DXX22=FDX2OA*FDX2   !<2*(dphi2/dx)*(dphi2/dx)>
            DYY22=FDY2OA*FDY2   !<2*(dphi2/dy)*(dphi2/dy)>
            DXXYY22=DXX22+DYY22
            DXX23=FDX2OA*FDX3   !<2*(dphi2/dx)*(dphi3/dx)>
            DYY23=FDY2OA*FDY3   !<2*(dphi2/dy)*(dphi3/dy)>
            DXXYY23=DXX23+DYY23

            DDX3=FDX3/3.        !<2*(dphi3/dx)*phij> j=1,2,3
            DDY3=FDY3/3.        !<2*(dphi3/dy)*phij> j=1,2,3
            DXX33=FDX3OA*FDX3   !<2*(dphi3/dx)*(dphi3/dx)>
            DYY33=FDY3OA*FDY3   !<2*(dphi3/dy)*(dphi3/dy)>
            DXXYY33=DXX33+DYY33

            LUMPT=1             !=1/0; LUMP/DO NOT LUMP THE TRANSPORT EQN
            FDDD=(1+LUMPT)*AREAIE/6.D0 !<2*(phii*phij) i=j>
            FDDOD=(1-LUMPT)*AREAIE/12.D0 !<2*(phii*phij) i<>j>
            FDDDODT=FDDD/DTDP
            FDDODODT=FDDOD/DTDP

C.....COMPUTE ELEMENT AVERAGES QUANTITIES

            UEA=(U1N1+U1N2+U1N3)/3.
            VEA=(V1N1+V1N2+V1N3)/3.
            HEA=(HH1N1+HH1N2+HH1N3)/3.
            EVCEA=(EVC1+EVC2+EVC3)/3.
            DHDX=HH1N1*FDX1OA+HH1N2*FDX2OA+HH1N3*FDX3OA
            DHDY=HH1N1*FDY1OA+HH1N2*FDY2OA+HH1N3*FDY3OA
            UPEA=UEA+DHDX*EVCEA/HEA
            VPEA=VEA+DHDY*EVCEA/HEA

C.....ASSEMBLE PARTIAL PRODUCT

            CHSUM=CH1N1+CH1N2+CH1N3

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA1 AND
C.....QTEMB1 VECTORS FOR NODE NM1

            QTEMB1=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     *           FDDDODT*CH1N1+FDDODODT*(CH1N2+CH1N3)
C......LATERAL SGS TERMS
     *           -EVCEA*(DXXYY11*CH1N1+DXXYY12*CH1N2+DXXYY13*CH1N3)
C......ADVECTIVE TERMS
     *           +(UPEA*DDX1+VPEA*DDY1)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     *           +FDDD*SS1N1+FDDOD*(SS1N2+SS1N3)
            QTEMA1=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     *           FDDDODT+2.*FDDODODT

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA2 AND
C.....QTEMB2 VECTOR FOR NODE NM2

            QTEMB2=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     *           FDDDODT*CH1N2+FDDODODT*(CH1N1+CH1N3)
C......LATERAL SGS TERMS
     *           -EVCEA*(DXXYY12*CH1N1+DXXYY22*CH1N2+DXXYY23*CH1N3)
C......ADVECTIVE TERMS
     *           +(UPEA*DDX2+VPEA*DDY2)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     *           +FDDD*SS1N2+FDDOD*(SS1N1+SS1N3)
            QTEMA2=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     *           FDDDODT+2.*FDDODODT

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA3 AND
C.....QTEMB3 VECTOR FOR NODE NM3

            QTEMB3=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     *           FDDDODT*CH1N3+FDDODODT*(CH1N1+CH1N2)
C......LATERAL SGS TERMS
     *           -EVCEA*(DXXYY13*CH1N1+DXXYY23*CH1N2+DXXYY33*CH1N3)
C......ADVECTIVE TERMS
     *           +(UPEA*DDX3+VPEA*DDY3)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     *           +FDDD*SS1N3+FDDOD*(SS1N1+SS1N2)
            QTEMA3=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     *           FDDDODT+2.*FDDODODT

C     VEC...LINES TO RUN ON A VECTOR COMPUTER


C     LINES TO RUN ON A SCALAR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QC AND QA
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS

            QB(NM1)=QB(NM1)+QTEMB1*NCELE !LOAD VECTOR
            QB(NM2)=QB(NM2)+QTEMB2*NCELE !LOAD VECTOR
            QB(NM3)=QB(NM3)+QTEMB3*NCELE !LOAD VECTOR
            QA(NM1)=QA(NM1)+QTEMA1*NCELE !LUMPED LHS MATRIX
            QA(NM2)=QA(NM2)+QTEMA2*NCELE !LUMPED LHS MATRIX
            QA(NM3)=QA(NM3)+QTEMA3*NCELE !LUMPED LHS MATRIX



 1057    CONTINUE

C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QC, QA


C.... SOLVE FOR C*H NODE BY NODE

         DO I=1,NP
            NCI=NODECODE(I)
            IF(NCI.NE.0) CH1(I)=QB(I)/QA(I)
C     IF(LBArray_Pointer(I).NE.0) CH1(I)=0.d0  !ESSENTIAL C=0 BOUNDARY CONDITION
         END DO
      ENDIF

c...  find and print to unit 6, the maximum elevation, the maximum
c...  velocity and the node numbers at which they occur on myproc=0 if
c...  elmax exceeds threshold, print information on all processors where
c...  this occurs

      IF(NSCREEN.EQ.1) THEN
         ELMAX=0.0d0
         VELMAX=0.0d0
         KEMAX = 0
         KVMAX = 0
         DO I=1,NP
            IF((NODECODE(I).EQ.1).AND.(ABS(ETA2(I)).GT.ELMAX))THEN
               ELMAX=ABS(ETA2(I))
               KEMAX=I
            ENDIF
            VELABS=UBAR2(I)*UBAR2(I)+VBAR2(I)*VBAR2(I)
            IF (VELABS.GT.VELMAX) THEN
               VELMAX=VELABS
               KVMAX=I
            ENDIF
         END DO
         VELMAX=VELMAX**0.5d0
         

         IF(ELMAX.LT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1992) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
 1992       FORMAT(1X,'TIME STEP =',I8,5X,'ITERATIONS =',I5,
     *           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     *           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7)
         ENDIF
         IF(ELMAX.GT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1994) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
            WRITE(16,1994) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
 1994       FORMAT(1X,'TIME STEP =',I8,6X,'ITERATIONS =',I5,
     *           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     *           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7,
     *           2X,' !!! WARNING - HIGH ELEVATION !!!')
         ENDIF

      ENDIF

c...  output elevation recording station information if noute<>0 and the
c...  time step falls within the specified window calculate elevation
c...  solutions at stations using interpolation

      IF(NOUTE.NE.0) THEN
         IF((IT.GT.NTCYSE).AND.(IT.LE.NTCYFE)) THEN
            NSCOUE=NSCOUE+1
            IF(NSCOUE.EQ.NSPOOLE) THEN
               DO I=1,NSTAE
                  EE1=ETA2(NM(NNE(I),1))
                  EE2=ETA2(NM(NNE(I),2))
                  EE3=ETA2(NM(NNE(I),3))
                  NC1=NODECODE(NM(NNE(I),1))
                  NC2=NODECODE(NM(NNE(I),2))
                  NC3=NODECODE(NM(NNE(I),3))
                  NCELE=NC1*NC2*NC3
                  IF(NCELE.EQ.1) ET00(I)=EE1*STAIE1(I)+EE2*STAIE2(I)
     *                 +EE3*STAIE3(I)
                  IF(NCELE.EQ.0) ET00(I)=-99999.
               END DO
               IF(ABS(NOUTE).EQ.1) THEN
                  WRITE(61,2120) time,IT
                  DO I=1,NSTAE
                     WRITE(61,2453) I,ET00(I)
                  END DO
                  IESTP = IESTP+1+NSTAE
               ENDIF
               IF(ABS(NOUTE).EQ.2) THEN
                  WRITE(61,REC=IESTP+1) time
                  WRITE(61,REC=IESTP+2) IT
                  IESTP = IESTP + 2
                  DO I=1,NSTAE
                     WRITE(61,REC=IESTP+I) ET00(I)
                  END DO
                  IESTP = IESTP + NSTAE
               ENDIF
               NSCOUE=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFE) CLOSE(61)
      ENDIF

C...   OUTPUT VELOCITY RECORDING STATION TIME SERIES INFORMATION IF
C...  NOUTV<>0
C.... AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW CALCULATE
C...  VELOCITY SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF(NOUTV.NE.0) THEN
         IF((IT.GT.NTCYSV).AND.(IT.LE.NTCYFV)) THEN
            NSCOUV=NSCOUV+1
            IF(NSCOUV.EQ.NSPOOLV) THEN
               DO I=1,NSTAV
                  U11=UBAR2(NM(NNV(I),1))
                  U22=UBAR2(NM(NNV(I),2))
                  U33=UBAR2(NM(NNV(I),3))
                  V11=VBAR2(NM(NNV(I),1))
                  V22=VBAR2(NM(NNV(I),2))
                  V33=VBAR2(NM(NNV(I),3))
                  UU00(I)=U11*STAIV1(I)+U22*STAIV2(I)+U33*STAIV3(I)
                  VV00(I)=V11*STAIV1(I)+V22*STAIV2(I)+V33*STAIV3(I)
               END DO
               IF(ABS(NOUTV).EQ.1) THEN
                  WRITE(62,2120) time,IT
                  DO I=1,NSTAV
                     WRITE(62,2454) I,UU00(I),VV00(I)
                  END DO
                  IVSTP = IVSTP+1+NSTAV
               ENDIF
               IF(ABS(NOUTV).EQ.2) THEN
                  WRITE(62,REC=IVSTP+1) time
                  WRITE(62,REC=IVSTP+2) IT
                  IVSTP = IVSTP + 2
                  DO I=1,NSTAV
                     WRITE(62,REC=IVSTP+2*I-1) UU00(I)
                     WRITE(62,REC=IVSTP+2*I) VV00(I)
                  END DO
                  IVSTP = IVSTP + 2*NSTAV
               ENDIF
               NSCOUV=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFV) CLOSE(62)
      ENDIF

C...   OUTPUT CONCENTRATION RECORDING STATION INFORMATION IF NOUTC<>0
C...  AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW CALCULATE
C...  CONCENTRATION SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF(NOUTC.NE.0) THEN
         IF((IT.GT.NTCYSC).AND.(IT.LE.NTCYFC)) THEN
            NSCOUC=NSCOUC+1
            IF(NSCOUC.EQ.NSPOOLC) THEN
               DO I=1,NSTAC
                  NM1=NM(NNC(I),1)
                  NM2=NM(NNC(I),2)
                  NM3=NM(NNC(I),3)
                  HH2N1=DP(NM1)+IFNLFA*ETA2(NM1)
                  HH2N2=DP(NM2)+IFNLFA*ETA2(NM2)
                  HH2N3=DP(NM3)+IFNLFA*ETA2(NM3)
                  C1=CH1(NM1)/HH2N1
                  C2=CH1(NM2)/HH2N2
                  C3=CH1(NM3)/HH2N3
                  NC1=NODECODE(NM1)
                  NC2=NODECODE(NM2)
                  NC3=NODECODE(NM3)
                  NCELE=NC1*NC2*NC3
                  IF(NCELE.EQ.1) CC00(I)=C1*STAIC1(I)+C2*STAIC2(I)
     *                 +C3*STAIC3(I)
                  IF(NCELE.EQ.0) CC00(I)=-99999.
               END DO
               IF(ABS(NOUTC).EQ.1) THEN
                  WRITE(81,2120) time,IT
                  DO I=1,NSTAC
                     WRITE(81,2453) I,CC00(I)
                  END DO
                  ICSTP = ICSTP+1+NSTAC
               ENDIF
               IF(ABS(NOUTC).EQ.2) THEN
                  WRITE(81,REC=ICSTP+1) time
                  WRITE(81,REC=ICSTP+2) IT
                  ICSTP = ICSTP + 2
                  DO I=1,NSTAC
                     WRITE(81,REC=ICSTP+I) CC00(I)
                  END DO
                  ICSTP = ICSTP + NSTAC
               ENDIF
               NSCOUC=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFC) CLOSE(81)
      ENDIF

C...   OUTPUT METEOROLOGICAL RECORDING STATION INFORMATION IF NWS>0 AND
C...  THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW CALCULATE
C...  METEOROLOGICAL SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF((NWS.NE.0).AND.(NOUTM.NE.0)) THEN
         IF((IT.GT.NTCYSM).AND.(IT.LE.NTCYFM)) THEN
            NSCOUM=NSCOUM+1
            IF(NSCOUM.EQ.NSPOOLM) THEN
               DO I=1,NSTAM
                  NM1=NM(NNM(I),1)
                  NM2=NM(NNM(I),2)
                  NM3=NM(NNM(I),3)
                  U11=wvnxout(NM1)
                  U22=wvnxout(NM2)
                  U33=wvnxout(NM3)
                  V11=wvnyout(NM1)
                  V22=wvnyout(NM2)
                  V33=wvnyout(NM3)
                  P11=PR2(NM1)
                  P22=PR2(NM2)
                  P33=PR2(NM3)
                  RMU00(I)=U11*STAIM1(I)+U22*STAIM2(I)+U33*STAIM3(I)
                  RMV00(I)=V11*STAIM1(I)+V22*STAIM2(I)+V33*STAIM3(I)
                  RMP00(I)=P11*STAIM1(I)+P22*STAIM2(I)+P33*STAIM3(I)
               END DO
               IF(ABS(NOUTM).EQ.1) THEN
                  WRITE(71,2120) time,IT
                  WRITE(72,2120) time,IT
                  DO I=1,NSTAM
                     WRITE(71,2453) I,RMP00(I)
                     WRITE(72,2454) I,RMU00(I),RMV00(I)
                  END DO
                  IPSTP=IPSTP+1+NSTAM
                  IWSTP=IWSTP+1+NSTAM
               ENDIF
               IF(ABS(NOUTM).EQ.2) THEN
                  WRITE(71,REC=IPSTP+1) time
                  WRITE(71,REC=IPSTP+2) IT
                  WRITE(72,REC=IWSTP+1) time
                  WRITE(72,REC=IWSTP+2) IT
                  IPSTP=IPSTP+2
                  IWSTP=IWSTP+2
                  DO I=1,NSTAM
                     WRITE(71,REC=IPSTP+I) RMP00(I)
                     WRITE(72,REC=IWSTP+2*I-1) RMU00(I)
                     WRITE(72,REC=IWSTP+2*I) RMV00(I)
                  END DO
                  IPSTP=IPSTP+NSTAM
                  IWSTP=IWSTP+2*NSTAM
               ENDIF
               NSCOUM=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFM) THEN
            CLOSE(71)
            CLOSE(72)
         ENDIF
      ENDIF

C...   OUTPUT GLOBAL ELEVATION DATA IF NOUTGE<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  
      IF(NOUTGE.NE.0) THEN
         IF((IT.GT.NTCYSGE).AND.(IT.LE.NTCYFGE)) THEN
            NSCOUGE=NSCOUGE+1
            IF(NSCOUGE.EQ.NSPOOLGE) THEN
               IF(ABS(NOUTGE).EQ.1) THEN
                  WRITE(63,2120) time,IT
 2120             FORMAT(2X,E20.10,5X,I10)
                  DO I=1,NP
                     IF(NODECODE(I).EQ.1) WRITE(63,2453) I,ETA2(I)
                     IF(NODECODE(I).EQ.0) WRITE(63,2453) I,-99999.
 2453                FORMAT(2X,I8,2X,E15.8)
                  ENDDO
                  IGEP=IGEP+1+NP
               ENDIF
               IF(ABS(NOUTGE).EQ.2) THEN
                  WRITE(63,REC=IGEP+1) time
                  WRITE(63,REC=IGEP+2) IT
                  IGEP = IGEP + 2
                  DO I=1,NP
                     IF(NODECODE(I).EQ.1) WRITE(63,REC=IGEP+I)ETA2(I)
                     IF(NODECODE(I).EQ.0) WRITE(63,REC=IGEP+I) -99999.
                  ENDDO
                  IGEP = IGEP + NP
               ENDIF
               NSCOUGE=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFGE) CLOSE(63)
      ENDIF

C...   OUTPUT GLOBAL VELOCITY DATA IF NOUTGV<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  
      IF(NOUTGV.NE.0) THEN
         IF((IT.GT.NTCYSGV).AND.(IT.LE.NTCYFGV)) THEN
            NSCOUGV=NSCOUGV+1
            IF(NSCOUGV.EQ.NSPOOLGV) THEN
               IF(ABS(NOUTGV).EQ.1) THEN
                  WRITE(64,2120) time,IT
                  DO I=1,NP
                     WRITE(64,2454) I,UBAR2(I),VBAR2(I)
 2454                FORMAT(2X,I8,2(2X,E15.8))
                  ENDDO
                  IGVP = IGVP+1+NP
               ENDIF
               IF(ABS(NOUTGV).EQ.2) THEN
                  WRITE(64,REC=IGVP+1) time
                  WRITE(64,REC=IGVP+2) IT
                  IGVP = IGVP + 2
                  DO I=1,NP
                     WRITE(64,REC=IGVP+2*I-1) UBAR2(I)
                     WRITE(64,REC=IGVP+2*I) VBAR2(I)
                  END DO
                  IGVP = IGVP + 2*NP
               ENDIF
               NSCOUGV=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFGV) CLOSE(64)
      ENDIF

C...
C...  OUTPUT GLOBAL WIND STRESS and atmospheric pressure data IF
C.... NOUTGW<>0 AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...
      IF((NWS.NE.0).AND.(NOUTGW.NE.0)) THEN
         IF((IT.GT.NTCYSGW).AND.(IT.LE.NTCYFGW)) THEN
            NSCOUGW=NSCOUGW+1
            IF(NSCOUGW.EQ.NSPOOLGW) THEN
               IF(ABS(NOUTGW).EQ.1) THEN
                  write(73,2120) time,it
                  WRITE(74,2120) time,IT
                  DO I=1,NP
                     write(73,2453) i,pr2(i)
                     WRITE(74,2454) i,wvnxout(i),wvnyout(i)
                  ENDDO
                  igpp = igpp+1+np
                  IGWP = IGWP+1+NP
               ENDIF
               IF(ABS(NOUTGW).EQ.2) THEN
                  WRITE(73,REC=igpp+1) time
                  WRITE(73,REC=igpp+2) IT
                  WRITE(74,REC=IGWP+1) time
                  WRITE(74,REC=IGWP+2) IT
                  igpp = igpp + 2
                  IGWP = IGWP + 2
                  DO I=1,NP
                     write(73,rec=igpp+i) pr2(i)
                     WRITE(74,REC=IGWP+2*I-1) wvnxout(i)
                     WRITE(74,REC=IGWP+2*I) wvnyout(i)
                  END DO
                  igpp = igpp + np
                  IGWP = IGWP + 2*NP
               ENDIF
               NSCOUGW=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFGW) then
            close(73)
            close(74)
         ENDIF
      endif

C...   OUTPUT GLOBAL CONCENTRATION DATA IF NOUTGC<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  
      IF(NOUTGC.NE.0) THEN
         IF((IT.GT.NTCYSGC).AND.(IT.LE.NTCYFGC)) THEN
            NSCOUGC=NSCOUGC+1
            IF(NSCOUGC.EQ.NSPOOLGC) THEN
               IF(ABS(NOUTGC).EQ.1) THEN
                  WRITE(83,2120) time,IT
                  DO I=1,NP
                     HH2=DP(I)+IFNLFA*ETA2(I)
                     C1=CH1(I)/HH2
                     IF(NODECODE(I).EQ.1) WRITE(83,2453) I,C1
                     IF(NODECODE(I).EQ.0) WRITE(83,2453) I,-99999.
                  ENDDO
                  IGCP=IGCP+1+NP
               ENDIF
               IF(ABS(NOUTGC).EQ.2) THEN
                  WRITE(83,REC=IGEP+1) time
                  WRITE(83,REC=IGEP+2) IT
                  IGCP = IGCP + 2
                  DO I=1,NP
                     HH2=DP(I)+IFNLFA*ETA2(I)
                     C1=CH1(I)/HH2
                     IF(NODECODE(I).EQ.1) WRITE(83,REC=IGCP+I) C1
                     IF(NODECODE(I).EQ.0) WRITE(83,REC=IGCP+I) -99999.
                  ENDDO
                  IGCP=IGCP+NP
               ENDIF
               NSCOUGC=0
            ENDIF
         ENDIF
         IF(IT.EQ.NTCYFGC) CLOSE(83)
      ENDIF

C...   IF IHARIND=1 AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  AND ON THE SPECIFIED INCREMENT, USE MODEL RESULTS TO UPDATE
C...  HARMONIC ANALYSIS MATRIX AND LOAD VECTORS.  NOTE: AN 8 BYTE RECORD
C...  SHOULD BE USED THROUGHOUT THE HARMONIC ANALYSIS SUBROUTINES, EVEN
C...  ON 32 BIT WORKSTATIONS, SINCE IN THAT CASE THE HARMONIC ANALYSIS
C...  IS DONE IN DOUBLE PRECISION.
C...  
      IF(IHARIND.EQ.1) THEN
         IF((IT.GT.ITHAS).AND.(IT.LE.ITHAF)) THEN
            IF(ICHA.EQ.NHAINC) ICHA=0
            ICHA=ICHA+1
            IF(ICHA.EQ.NHAINC) THEN
C...  
C.....UPDATE THE LHS MATRIX
C...  
               CALL LSQUPDLHS(timeh,IT)
C...  IF DESIRED COMPUTE ELEVATION STATION INFORMATION AND UPDATE LOAD
C.....VECTOR
C...
               IF(NHASE.EQ.1) THEN
                  DO I=1,NSTAE
                     EE1=ETA2(NM(NNE(I),1))
                     EE2=ETA2(NM(NNE(I),2))
                     EE3=ETA2(NM(NNE(I),3))
                     ET00(I)=EE1*STAIE1(I)+EE2*STAIE2(I)+EE3*STAIE3(I)
                  END DO
                  CALL LSQUPDES(ET00,NSTAE)
               ENDIF
C...  IF DESIRED COMPUTE VELOCITY STATION INFORMATION AND UPDATE LOAD
C.....VECTOR
C...
               IF(NHASV.EQ.1) THEN
                  DO I=1,NSTAV
                     U11=UBAR2(NM(NNV(I),1))
                     U22=UBAR2(NM(NNV(I),2))
                     U33=UBAR2(NM(NNV(I),3))
                     V11=VBAR2(NM(NNV(I),1))
                     V22=VBAR2(NM(NNV(I),2))
                     V33=VBAR2(NM(NNV(I),3))
                     UU00(I)=U11*STAIV1(I)+U22*STAIV2(I)+U33*STAIV3(I)
                     VV00(I)=V11*STAIV1(I)+V22*STAIV2(I)+V33*STAIV3(I)
                  END DO
                  CALL LSQUPDVS(UU00,VV00,NSTAV)
               ENDIF
C...  
C.....IF DESIRED UPDATE GLOBAL ELEVATION LOAD VECTOR
C...  
               IF(NHAGE.EQ.1) CALL LSQUPDEG(ETA2,NP)
C...  
C.....IF DESIRED UPDATE GLOBAL VELOCITY LOAD VECTOR
C...  
               IF(NHAGV.EQ.1) CALL LSQUPDVG(UBAR2,VBAR2,NP)

            ENDIF
         ENDIF

C...  LINES TO COMPUTE MEANS AND VARIANCES

         if (CHARMV) then
            IF(IT.GT.ITMV) THEN
               NTSTEPS=NTSTEPS+1
               DO I=1,NP
                  ELAV(I)=ELAV(I)+ETA2(I)
                  XVELAV(I)=XVELAV(I)+UBAR2(I)
                  YVELAV(I)=YVELAV(I)+VBAR2(I)
                  ELVA(I)=ELVA(I)+ETA2(I)*ETA2(I)
                  XVELVA(I)=XVELVA(I)+UBAR2(I)*UBAR2(I)
                  YVELVA(I)=YVELVA(I)+VBAR2(I)*VBAR2(I)
               END DO
            ENDIF
         endif                  !   charmv


      ENDIF

C...
C...  WRITE OUT HOT START INFORMATION IF NHSTAR=1 AND AT CORRECT TIME
C.... STEP
C...  NOTE: THE HOT START FILES USE A RECORD LENGTH OF 8 ON BOTH 32 BIT
C.... WORKSTATIONS AND THE 64 BIT CRAY.  THIS IS BECAUSE THE HARMONIC
C.... ANALYSIS IS DONE IN DOUBLE PRECISION (64 BITS) ON WORKSTATIONS.
C...
      IF(NHSTAR.EQ.1) THEN
         ITEST=(IT/NHSINC)*NHSINC  
         IF(ITEST.EQ.IT) THEN
            IF(IHSFIL.EQ.67) OPEN(67,FILE=DIRNAME//'/'//'fort.67',
     *           ACCESS='DIRECT',RECL=8)
            IF(IHSFIL.EQ.68) OPEN(68,FILE=DIRNAME//'/'//'fort.68',
     *           ACCESS='DIRECT',RECL=8)
            IHOTSTP=1
            WRITE(IHSFIL,REC=IHOTSTP) IM
            IHOTSTP=2
            WRITE(IHSFIL,REC=IHOTSTP) TIME
            IHOTSTP=3
            WRITE(IHSFIL,REC=IHOTSTP) IT
            DO I=1,NP
               WRITE(IHSFIL,REC=IHOTSTP+1) ETA1(I)
               WRITE(IHSFIL,REC=IHOTSTP+2) ETA2(I)
               WRITE(IHSFIL,REC=IHOTSTP+3) UBAR2(I)
               WRITE(IHSFIL,REC=IHOTSTP+4) VBAR2(I)
               IHOTSTP = IHOTSTP + 4
               IF(IM.EQ.10) THEN
                  WRITE(IHSFIL,REC=IHOTSTP+1) CH1(I)
                  IHOTSTP=IHOTSTP+1
               ENDIF
               WRITE(IHSFIL,REC=IHOTSTP+1) NODECODE(I)
               IHOTSTP=IHOTSTP+1
            END DO
            WRITE(IHSFIL,REC=IHOTSTP+1) IESTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUE
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IVSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUV
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) ICSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUC
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IPSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) IWSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUM
            IHOTSTP=IHOTSTP+3
            WRITE(IHSFIL,REC=IHOTSTP+1) IGEP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGE
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGVP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGV
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGCP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGC
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGPP
            WRITE(IHSFIL,REC=IHOTSTP+2) IGWP
            WRITE(IHSFIL,REC=IHOTSTP+3) NSCOUGW
            IHOTSTP=IHOTSTP+3
C...  
C...  IF APPROPRIATE ADD HARMONIC ANALYSIS INFORMATION TO HOT START FILE
C...  
            IF((IHARIND.EQ.1).AND.(IT.GT.ITHAS)) THEN
               WRITE(IHSFIL,REC=IHOTSTP+1) ICHA
               IHOTSTP = IHOTSTP + 1
               CALL HAHOUT(NP,NSTAE,NSTAV,NHASE,NHASV,NHAGE,NHAGV,
     *              IHSFIL,IHOTSTP)
C     
               IF(NHASE.EQ.1) CALL HAHOUTES(NSTAE,IHSFIL,IHOTSTP)
               IF(NHASV.EQ.1) CALL HAHOUTVS(NSTAV,IHSFIL,IHOTSTP)
               IF(NHAGE.EQ.1) CALL HAHOUTEG(NP,IHSFIL,IHOTSTP)
               IF(NHAGV.EQ.1) CALL HAHOUTVG(NP,IHSFIL,IHOTSTP)
            ENDIF

            if( CHARMV) then
               IF((IHARIND.EQ.1).AND.(IT.GT.ITMV)) THEN
                  IHOTSTP=IHOTSTP+1
                  WRITE(IHSFIL,REC=IHOTSTP) NTSTEPS
                  IF(NHAGE.EQ.1) THEN
                     DO I=1,NP
                        WRITE(IHSFIL,REC=IHOTSTP+1) ELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+2) ELVA(I)
                        IHOTSTP=IHOTSTP+2
                     END DO
                  ENDIF
                  IF(NHAGV.EQ.1) THEN
                     DO I=1,NP
                        WRITE(IHSFIL,REC=IHOTSTP+1) XVELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+2) YVELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+3) XVELVA(I)
                        WRITE(IHSFIL,REC=IHOTSTP+4) YVELVA(I)
                        IHOTSTP=IHOTSTP+4
                     END DO
                  ENDIF
               ENDIF
            endif               !  charmv

            
            IF (C3D) THEN
               CALL HSTART3D_OUT()
            ENDIF

C...  
C...  CLOSE THE HOT START OUTPUT FILE
C...  
            CLOSE(IHSFIL)
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
               WRITE(6,24541) IHSFIL,IT,TIME
            ENDIF
            WRITE(16,24541) IHSFIL,IT,TIME
24541       FORMAT(1X,'HOT START OUTPUT WRITTEN TO UNIT ',I2,
     *           ' AT TIME STEP = ',I9,' TIME = ',E15.8)
            IF(IHSFIL.EQ.67) THEN
               IHSFIL=68
            ELSE
               IHSFIL=67
            ENDIF
         ENDIF
      ENDIF
C...  
C...  ****************** TIME STEPPING LOOP ENDS HERE ********************
C...  
      RETURN
      END
C******************************************************************************
c                                                                             *
c            VS VERTICAL SOLUTION SUBROUTINES - VERSION 10.01                 *
c                                                                             *
c                            R.L.  12/ 5/94                                   *
c                            R.G.  4/30/97                                    *
c                            R.L.  2/05/99                                    *
C                            R.L.  8/24/99                                    *
C                            R.L.  9/07/99                                    *
C                            R.L. 12/17/99                                    *
C                            R.L. 01/07/00                                    *
C                            R.L. 01/20/00                                    *
C                            R.L. 02/01/00                                    *
C                            R.L. 02/21/00                                    *
C                            R.L. 05/25/00                                    *
C                            R.L. 01/25/01                                    *
C                            R.L. 02/01/01                                    *
C                            R.L. 11/28/01                                    *
C                            R.L. 01/29/02                                    *
C                                                                             *
C                                                                             *
C                                                                             *
c                                                                             *
c           UPDATED TO INTERFACE WITH ADC36_01                                *
c                                                                             *
c   Includes rewritten level 2.5 turbulence closure                           *
C                                                                             *
c   This is a major change over version 5.00 and below because the            *
c   the velocity profile is obtained directly from the 3-D momentum           *
c   equations.                                                                *
c                                                                             *
c******************************************************************************
C                                                                             *
C     -  PARAMETERS WHICH MUST BE SET WITHIN THE MAIN CODE AND THE            *
C          SUBROUTINES TO CONTROL THE DIMENSIONING OF ARRAYS ARE AS FOLLOWS   *
C          (TO FIND THE LINES WHICH MUST BE SET, FIND "CUSER" COMMENT LINES): *
C                                                                             *
C    MNP     = THE MAXIMUM NUMBER OF NODES IN THE HORIZONTAL F.E. GRID AS     *
C              SPECIFIED IN THE EXTERNAL MODE CODE                            *
C    MNE     = THE MAXIMUM NUMBER OF ELEMENTS IN THE HORIZONTAL F.E. GRID AS  *
C              SPECIFIED IN THE EXTERNAL MODE CODE                            *
C    MNEI    = 1+MAXIMUM NUMBER OF NODES CONNECTED TO ANY ONE NODE IN THE     *
C              FINITE ELEMENT GRID                                            *
C    MNWP    = 1 IF NO METEOROLOGIC OR RADIATION STRESS FORCING,              *
C            = MNP IF METEOROLOGIC OR RADIATION STRESS FORCING                *
C    MNVEL   = MAXIMUM TOTAL NUMBER OF FLOW BOUNDARY NODES +1                 *
C    MNODES  = 1 + THE MAXIMUM NUMBER OF NODES OVER THE VERTICAL IN THE       *
C              COMBINED E.V. & F.E. GRID                                      *
C                                                                             *
C                                                                             *
C      NOTE: A MINIMUM VALUE OF 1 SHOULD BE USED FOR EACH PARAMETER           *
C******************************************************************************
C                                                                             *
C     -  STANDARD INPUT FILES ARE AS FOLLOWS:                                 *
C                                                                             *
C          UNIT 15 : INPUT FILE WHICH DEFINES THE MAJORITY OF INPUT           *
C                    PARAMETERS NECESARY FOR SPECIFYING THE SOLUTION OVER THE *
C                    THE VERTICAL.  THESE VALUES FOLLOW THE INPUT INFORMATION *
C                    USED FOR THE EXTERNAL MODE SOLUTION.                     *
C                                                                             *
C                                                                             *
C     -  SUPPLEMENTAL INPUT FILES (ACTIVATED BY INPUT PARAMETERS              *
C          SPECIFIED IN UNIT 15 INPUT) ARE AS FOLLOWS:                        *
C                                                                             *
C          UNIT 10 : VERTICAL FINITE ELEMENT GRID                             *
C          UNIT 11 : SAL,TEMP, DENSITY FIELD AT EVERY NODE IN DOMAIN          *
C          UNIT 12 : VERTICAL DISTRIBUTION OF EDDY VISCOSITY                  *
C                                                                             *
C                                                                             *
C                                                                             *
C******************************************************************************
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES READ IN FROM UNIT 15   (FORT.15)      *
C                                                                             *
C  IDIAG - DIAGNOSTIC AND WARNING MESSAGES TYPES                              *
C       IDIAG   =0 NO NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNITS 2 OR 16     *
C               =1 SERIOUS, NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNIT 16     *
C               =2 SERIOUS, NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNIT 16     *
C                  ROUTINE DIAGNOSTIC OUTPUT PRINTED TO UNIT 2                *
c                                                                             *
C  IDEN         =0 barotropic model run                                       *
C               =1 diagnostic baroclinic model run                            *
C               =2 prognostic baroclinic model run, salinity only             *
C               =3 prognostic baroclinic model run, temperature only          *
C               =4 prognostic baroclinic model run, salinity and temperature  *
C                                                                             *
C    (For all baroclinic model runs, the initial density field is read in     *
C                       from UNIT 11                                          *
c                                                                             *
C  ISLIP, KP - slip code & slip coefficient                                   *
c                  islip = 0, no slip bottom b.c.                             *
c                  islip = 1, linear slip bottom b.c.                         *
c                  islip = 2, quadratic slip bottom b.c.                      *
c                                                                             *
c  Z0S,Z0B   - free surface & bottom roughnesses (const over horiz)           *
c              if the turbulent length scale is determined by q2l eqn and a   *
c              slip coefficient is used, this should be the thickness of the  *
c              constrant stress layer (e.g., 1 m) below the bottom boundary   *
c              node.                                                          *
c                                                                             *
c  ALP1,ALP2,ALP3 - time weighting coefficients for the velocity solution.    *
c                   0.= fully explicit, 0.5=time centered, 1.= fully implicit *
c               ALP1 weights the Coriolis term                                *
c               ALP2 weights the bottom friction terms                        *
c               ALP3 weights the vertical diffusion term                      *
c                                                                             *
c  IGC,NFEN  - f.e. grid code, # nodes in f.e. grid                           *
c                  igc = 0, f.e. grid read from UNIT 10                       *
c                  igc = 1, uniform f.e. grid generated                       *
c                  igc = 2, log f.e. grid generated                           *
c                  igc = 3, log linear f.e. grid generated                    *
c                  igc = 4, double log f.e. grid generated                    *
c                  igc = 5, P-grid generated                                  *
c                  igc = 6, sine grid generated                               *
c                                                                             *
c  IEVC, EVMIN, EVCON - E.V. code, E.V. minimum value and E.V. constant       *
c                                                                             *
c        NOTE: EVCON is only used for some of the E.V. formulations as        *
c                  discussed below.                                           *
c        NOTE: In cases where EV is specified to vary linearly over the       *
c              lower 20% of the water column, it actually varies linearly     *
c              with a constant slope up to the vertical FE grid node that is  *
c              less than or equal to the 20% location.  The value is constant *
c              as specified at all FE grid nodes above the 20% location.      *
c              The E.V. above and below the 20% level is joined by one        *
c              additional linearly varying segment.                           *
c        NOTE: The E.V. is constrained to always be greater than or equal to  *
c              EVMIN as specified in the UNIT 15 file.                        *
c                                                                             *
c        ievc=0-9, EV constant in time & horizontal space                     *
c             0 - EV read in from UNIT 12 (may vary vertically) - EVCON is    *
c                    not used                                                 *
c             1 - EV = EVCON                                                  *
c                                                                             *
c        ievc=10-19 EV proportional to omega*h*h  (Lynch and Officer (1986)   *
c                                              Lynch and Werner (1987, 1991)) *
c             10 - EV = omega*h*h/10 over the entire water column             *
c             11 - EV = omega*h*h/1000 at bottom                              *
c                       varies linear over lower 20% of wc                    *
c                     = omega*h*h/10 in upper 80% of w.c.                     *
c            NOTE:For this EV formulation, evcon is not used and omega is     *
c                  hardwired for a 12.42 hour tide.                           *
c                                                                             *
c        ievc=20-29 EV proportional to kappa U* z                             *
c             20 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z over entire water column                      *
c             21 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z in lower 20% of water col                     *
c                     = 0.082U*h in upper 80% of water col                    *
c            WHERE: U* is the friction velocity                               *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             *
c        ievc=30-39, EV proportional to Uh (Davies 1990)                      *
c             30 - EV = 0.025|U|h/9.001 over entire water column              *
c             31 - EV = evcon|U|h over entire water column                    *
c             32 - EV = 0.025|U|h/9.001 in upper 80% of wc                    *
c                     = 0.000025h|U|/9.001 at bottom                          *
c                       varies linear over lower 20% of wc                    *
c             33 - EV = evcon|U|h in upper 80% of wc                          *
c                     = evcon|U|h/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=31,33 *
c                                                                             *
c        ievc=40-49, EV proportional to U*U (Davies 1990)                     *
c             40 - EV = 2|UU|/9.001 over entire water column                  *
c             41 - EV = evcon|UU| over entire water column                    *
c             42 - EV = 2|UU|/9.001 in upper 80% of wc                        *
c                     = 0.002|UU|/9.001 at bottom                             *
c                       varies linear over lower 20% of wc                    *
c             43 - EV = evcon|UU| in upper 80% of wc                          *
c                     = evcon|UU|/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=41,43 *
c                                                                             *
c        ievc=50, EV computed from Mellor-Yamada L2.5 closure                 *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             *
c  if ievc = 50                                                               *   
c  THETA1, THETA2 - time weighting coefficients for the MY2.5 turbulence soln.*
c                   0.= fully explicit, 0.5=time centered, 1.= fully implicit *
c            THETA1 weights the dissipation term                              *
c            THETA2 weights the vertical diffusion term                       *
c                                                                             *  
c                                                                             *
C  I3DSD,TO3DSSD,TO3DFSD,NSPO3DSD,NHN3DSD                                     *
C            I3DSD  = 0  NO STATION 3D T,S,D INFO IS OUTPUT TO UNIT 41        *
C                   = 1  STATION 3D T,S,D INFO IS OUTPUT IN ASCII FORMAT      *
C            TO3DSSD =   THE NUMBER OF DAYS AFTER WHICH STATION 3D T,S,D      *
C                        ARE WRITTEN TO UNIT 41.                              *
C            TO3DFSD =   THE NUMBER OF DAYS AFTER WHICH STATION 3D T,S,D      *
C                        CEASE TO BE WRITTEN TO UNIT 41.                      *
C            NSPO3DSD =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 41.  (I.E., DATA IS OUTPUT TO UNIT 41 EVERY     *
C                        NSPO3DSD TIME STEPS AFTER TO3DSSD.)                  *
C            NHN3DSD  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D T,S,D                                     *
C  ISDHOUT(I), I=1,NHN3DSD - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D T,S,D OUTPUT STATIONS               *
C                           (ONLY INCLUDE THIS LINE IF I3DSD IS NOT = 0)      *
C  I3DSV,TO3DSSV,TO3DFSV,NSPO3DSV,NHN3DSV                                     *
C            I3DSV  = 0  NO STATION 3D VELOCITIES ARE OUTPUT TO UNIT 42       *
C                   = 1  STATION 3D VELOCITIES ARE OUTPUT IN ASCII FORMAT     *
C                   = 2  STATION 3D VELOCITIES ARE OUTPUT IN BINARY FORMAT    *
C            TO3DSSV =   THE NUMBER OF DAYS AFTER WHICH STATION 3D VELOCITIES *
C                        ARE WRITTEN TO UNIT 42.                              *
C            TO3DFSV =   THE NUMBER OF DAYS AFTER WHICH STATION 3D VELOCITIES *
C                        CEASE TO BE WRITTEN TO UNIT 42.                      *
C            NSPO3DSV =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 42.  (I.E., DATA IS OUTPUT TO UNIT 42 EVERY     *
C                        NSPO3DSV TIME STEPS AFTER TO3DSSV.)                  *
C            NHN3DSV  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D VELOCITIES.                               *
C  ISVHOUT(I), I=1,NHN3DSV - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D VELOCITY OUTPUT STATIONS            *
C                           (ONLY INCLUDE THIS LINE IF I3DSV IS NOT = 0)      *
C  I3DST,TO3DSST,TO3DFST,NSPO3DST,NHN3DST                                     *
C            I3DST  = 0  NO STATION 3D TURBULENCE VARIABLES OUTPUT TO UNIT 43 *
C                   = 1  STATION 3D TURBULENCE VARIABLES OUTPUT IN ASCII FORMAT
C            TO3DSST =   THE NUMBER OF DAYS AFTER WHICH STATION 3D TURBULENCE *
C                        VARIABLES ARE WRITTEN TO UNIT 43.                    *
C            TO3DFST =   THE NUMBER OF DAYS AFTER WHICH STATION 3D TURBULENCE *
C                        VARIABLES CEASE TO BE WRITTEN TO UNIT 43.            *
C            NSPO3DST =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 43.  (I.E., DATA IS OUTPUT TO UNIT 43 EVERY     *
C                        NSPO3DSV TIME STEPS AFTER TO3DSSV.)                  *
C            NHN3DST  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D VELOCITIES.                               *
C  ISTHOUT(I), I=1,NHN3DST - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D VELOCITY OUTPUT STATIONS            *
C                           (ONLY INCLUDE THIS LINE IF I3DST IS NOT = 0)      *
C  I3DGD,TO3DSGD,TO3DFGD,NSPO3DGD                                             *
C            I3DGD  = 0  NO GLOBAL 3D T,S,D INFO IS OUTPUT TO UNIT 44         *
C                   = 1  GLOBAL 3D T,S,D INFO IS OUTPUT IN ASCII FORMAT       *
C            TO3DSGD =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D T,S,D       *
C                        ARE WRITTEN TO UNIT 44.                              *
C            TO3DFGD =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D T,S,D       *
C                        CEASE TO BE WRITTEN TO UNIT 44.                      *
C            NSPO3DGD =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 44.  (I.E., DATA IS OUTPUT TO UNIT 44 EVERY     *
C                        NSPO3DGD TIME STEPS AFTER TO3DSGD.)                  *
C  I3DGV,TO3DSGV,TO3DFGV,NSPO3DGV                                             *
C            I3DGV  = 0  NO GLOBAL 3D VELOCITIES ARE OUTPUT TO UNIT 45        *
C                   = 1  GLOBAL 3D VELOCITIES ARE OUTPUT IN ASCII FORMAT      *
C                   = 2  GLOBAL 3D VELOCITIES ARE OUTPUT IN BINARY FORMAT     *
C            TO3DSGV =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D VELOCITY    *
C                        DATA IS WRITTEN TO UNIT 45.                          *
C            TO3DFGV =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D VELOCITY    *
C                        DATA CEASES TO BE WRITTEN TO UNIT 45.                *
C            NSPO3DGV =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 45.  (I.E., DATA IS OUTPUT TO UNIT 45 EVERY     *
C                        NSPO3DGV TIME STEPS AFTER TO3DSGV.)                  *
C  I3DGT,TO3DSGT,TO3DFGT,NSPO3DGT                                             *
C            I3DGT  = 0  NO GLOBAL 3D TURBULENCE VARIABLES OUTPUT TO UNIT 46  *
C                   = 1  GLOBAL 3D TURBULENCE VARIABLES OUTPUT IN ASCII FORMAT*
C            TO3DSGT =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D TURBULENCE  *
C                        VARIABLES ARE WRITTEN TO UNIT 46.                    *
C            TO3DFGT =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D TURBULENCE  *
C                        VARIABLES CEASE TO BE WRITTEN TO UNIT 46.            *
C            NSPO3DGT =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 46.  (I.E., DATA IS OUTPUT TO UNIT 46 EVERY     *
C                        NSPO3DGT TIME STEPS AFTER TO3DSGT.)                  *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 11  (FORT.11)               *
C             (NOTE, THIS IS USED ONLY IF IDEN=1)                             *
C                                                                             *
C           HEADER LINE 1                                                     *
C           HEADER LINE 2                                                     *
C           NVN - number of nodes in vertical, must match NFEN                *
C           DO I=1,NP                                                         *
C             DO J=1,NFEN                                                     *
C               NHNN,NVNN,SIGT(NHNN,NVNN),TEMP(NHNN,NVNN),SAL(NHNN,NVNN)      *
C               END DO                                                        *
C             END DO                                                          *
C                                                                             *
C           NHNN = HORIZONTAL NODE NUMBER                                     *
C           NVNN = VERTICAL NODE NUMBER                                       *
C           SIGT(NHNN,NVNN) = SIGMA T VALUE (KG/M^3) (=DENSITY-1000)          *
C           TEMP(NHNN,NVNN) = TEMPERATURE (DEG C)                             *
C           SAL(NHNN,NVNN) = SALINITY (PSU)                                   *
C                                                                             *
C        NOTE: J=1 AT BOTTOM, J=NFEN AT SURFACE                               *
C                                                                             *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 10  (FORT.10)               *
C             (NOTE, THIS IS USED ONLY IF IGC=0)                              *
C                                                                             *
C  SIGMA(I), I=1,NFEN                                                         *
C           SIGMA(I) = ELEVATION OF F.E. GRID NODE I (FROM b TO a)            *
C                                                                             *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 12 (FORT.12)                *
C             (NOTE, THIS IS USED ONLY IF IEVC=0)                             *
C                                                                             *
C  NIEVN              =  NUMBER OF NODES IN THE EDDY VISCOSITY GRID - THIS    *
C                        MUST MATCH THE NUMBER OF NODES IN THE SIGMA GRID!!   *
C  SIGEVI(I),EVTOT(I), I=1,NIEVN                                              *
C           SIGEVI(I) =  ELEVATION OF EDDY VISCOSITY NODE I  (FROM b TO a)    *
C                        This must match the sigma levels used in the grid    *
c                        in order from bottom to top.                         *
C           EVTOT(I) =  EDDY VISCOSITY ASSOCIATED WITH NODE I                 *
C                                                                             *
C******************************************************************************
C                                                                             *
C  3D Model output is generated in the following files:                       *
C                                                                             *
C   Serious/Fatal err msgs (ascii)           - UNIT 16    (fort.16)           *
C   Station Density output                   - UNIT 41    (fort.41)           *
C   Station Velocity output                  - UNIT 42    (fort.42)           *
C   Station Turbulence output                - UNIT 43    (fort.43)           *
C   Global Density output                    - UNIT 44    (fort.44)           *
C   Global Velocity output                   - UNIT 45    (fort.45)           *
C   Global Turbulence output                 - UNIT 46    (fort.46)           *
C   Detailed diagnostics (ascii)             - UNIT  2    (fort.2)            *
C                                                                             *
c******************************************************************************
C                                                                             *
C  OUTPUT FILE FORMAT                                                         *
C                                                                             *
C  Station D,T,S  (Density, Temp, Salinity) (fort.41)                         *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NDSDSET,DELT*NSPO3DSD,NSPO3DSD,NHN3DSD,NFEN                            *
C      FOR K = 1,NDSDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DSD                                                      *
c      ISDHOUT(J),(SIGT(M),TEMP(M),SAL(M),M=1,NFEN)                           *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Station Velocity (fort.42)                                                 *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NSVDSET,DELT*NSPO3DSV,NSPO3DSV,NHN3DSV,NFEN                            *
C      FOR K = 1,NSVDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DSV                                                      *
c      ISVHOUT(J),(U(M),V(M),W(M),M=1,NFEN)                                   *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Station Turbulence (fort.43)                                               *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NSTDSET,DELT*NSPO3DST,NSPO3DST,NHN3DST,NFEN                            *
C      FOR K = 1,NSTDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DST                                                      *
c      ISTHOUT(J),(q2(M),l(M),Evm(M),M=1,NFEN)                                *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global D,T,S (Density, Temperature, Salinity) (fort.44)                    *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGDDSET,DELT*NSPO3DGD,NSPO3DGD,NP,NFEN                                 *
C      FOR K = 1,NGDDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(SIGT(M),TEMP(M),SAL(M),M=1,NFEN)                                    *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global Velocity (fort.45)                                                  *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGVDSET,DELT*NSPO3DGV,NSPO3DGV,NP,NFEN                                 *
C      FOR K = 1,NGVDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(U(M),V(M),W(M),M=1,NFEN)                                            *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global Turbulence (fort.46)                                                *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGTDSET,DELT*NSPO3DGT,NSPO3DGT,NP,NFEN                                 *
C      FOR K = 1,NGTDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(q2(M),l(M),Evm(M),M=1,NFEN)                                         *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
c******************************************************************************
c                                                                             *
c   THIS  PROGRAM MAPS THE TRUE Z-COORDINATE SYSTEM INTO A DIMENSIONLESS      *
C   VERTICAL COORDINATE FROM [b,a] (BOTTOM TO TOP).  VALUES OF a=1 AND b=-1   *
C   ARE SET IN THE CODE.                                                      *
c                                                                             *
c******************************************************************************

      SUBROUTINE READ_INPUT_3DVS(DELT,STATIME,NT)

      USE GLOBAL_3DVS

      REAL(SZ) :: DELT
      REAL(8) :: STATIME
      REAL(8), PARAMETER :: day2sec=24.d0*3600.d0
      REAL :: HH1

C...  
C...  INITIALIZE A FEW PARAMETERS
C...  
      istart=0
      A=1.d0
      B=-1.d0
      I=(0.0d0,1.0d0)
      AMB = A-B
      GORho=G/RhoWat0
      GORhoOAMB=GORho/AMB

C...  
C...  BEGIN READING VERTICAL PARAMETER INFORMATION
C...  
      WRITE(16,300)
 300  FORMAT(//,1X,'VERTICAL SOLUTION INFORMATION',/)

C     
C...  READ AND CHECK INPUT FROM UNIT 15
C     
 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     *     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')

C...  SPECIFY THE DETAIL OF THE DIAGNOSTIC AND WARNING MESSAGES

      READ(15,*) IDIAG
      WRITE(16,420) IDIAG
 420  FORMAT(/,5X,'IDIAG = ',I3)
      IF((IDIAG.GT.2).OR.(IDIAG.LT.0)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,422)
         ENDIF
         WRITE(16,350)
         WRITE(16,422)
 422     FORMAT(/,2X,'    IDIAG MUST = 0,1 OR 2')
         STOP
      ENDIF

      IF(IDIAG.EQ.2) THEN
         OPEN(2,FILE=DIRNAME//'/'//'fort.2') !GENERAL DIAGNOSTIC OUTPUT FILE
         WRITE(2,*) '********** 3DVS V7.07 **********'
         WRITE(2,*) 'TIME = ',STATIME
      ENDIF

C...  SPECIFY WHETHER A BAROTROPIC OR BAROCLINIC RUN

      READ(15,*) IDEN
      WRITE(16,421) IDEN
 421  FORMAT(/,5X,'IDEN = ',I3)
      IF((IDEN.GT.1).OR.(IDEN.LT.0)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,423)
         ENDIF
         WRITE(16,350)
         WRITE(16,423)
 423     FORMAT(/,2X,'    IDEN MUST = 0 OR 1')
         STOP
      ENDIF

C...  READ IN THE TYPE OF BOTTOM BOUNDARY CONDITION AND THE SLIP COEFFICIENTS

      READ(15,*) ISLIP,KP
      WRITE(16,355) ISLIP,KP
 355  FORMAT(/,5X,'ISLIP = ',I3,' KP = ',E10.5)
      IF((ISLIP.LT.0).OR.(ISLIP.GT.2)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,360)
         ENDIF
         WRITE(16,350)
         WRITE(16,360)
 360     FORMAT(/,2X,'    THE SLIP CODE MUST = 0,1,OR 2.')
         STOP
      ENDIF

C...  READ IN THE SURFACE AND BOTTOM ROUGHNESSES

      READ(15,*) Z0S, Z0B
      WRITE(16,380) Z0S,Z0B
 380  FORMAT(/,5X,'Z0S = ',E10.5,' Z0B = ',E10.5)

C...  READ IN THE TIME STEPPING COEFFICIENTS

      READ(15,*) ALP1,ALP2,ALP3
      WRITE(16,390) ALP1,ALP2,ALP3
 390  FORMAT(/,5X,'3D TIME STEPPING COEFFS ALP1 = ',E8.2,' ALP2 = ',
     *     E8.2,' ALP3 = ',E8.2)

C...  READ IN IGC & NFEN: F.E. GRID CODE & # NODES IN F.E. GRID

      READ(15,*) IGC,NFEN
      WRITE(16,400) IGC,NFEN
 400  FORMAT(/,5X,'IGC = ',I3,' NUMBER OF NODES (NFEN) = ',I5)

C...  SET MNODES EQUAL TO NFEN

      MNODES = NFEN

C...  ALLOCATE 3D ARRAYS

      CALL ALLOC_3DVS()

C...  READ IN OR SET UP F.E. GRID  (IGC & NFEN ARE CHECKED IN SUB. FEGRIDS)

      hhtotal=0.
      do nh=1,np
         hhtotal=hhtotal+DP(nh)
      end do
      HH1=hhtotal/np
      CALL FEGRIDS(IGC,HH1)

      IF(IDIAG.EQ.2) THEN       !WRITE GENERAL DIAGNOSTIC OUTPUT
         WRITE(2,*) '********** READ_INPUT_3DVS **********'
         WRITE(2,*) '***** N, SIGMA(N) *****'
         DO N=1,NFEN
            WRITE(2,402) N,SIGMA(N)
 402        FORMAT(I5,2X,F13.9)
         END DO
      END IF

C...  SPECIFY TYPE OF EDDY VISCOSITY PROFILE

      READ(15,*) IEVC,EVMIN,EVCON
      WRITE(16,410) IEVC,EVMIN,EVCON
 410  FORMAT(/,5X,'IEVC = ',I3,2X,'EVMIN = ',E15.8,2X,'EVCON = ',E15.8)
      IF((IEVC.NE.0 ).and.(IEVC.NE.1 ).and.
     *     (IEVC.NE.10).and.(IEVC.NE.11).and.
     *     (IEVC.NE.20).and.(IEVC.NE.21).and.
     *     (IEVC.NE.30).and.(IEVC.NE.31).and.(IEVC.NE.32).and.
     *     (IEVC.NE.33).and.
     *     (IEVC.NE.40).and.(IEVC.NE.41).and.(IEVC.NE.42).and.
     *     (IEVC.NE.43).and.
     *     (IEVC.NE.50)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,411)
         ENDIF
         WRITE(16,350)
         WRITE(16,411)
 411     FORMAT(/,2X,'    IEVC MUST BE 0,1,10,11,20,21,30,31,32,33,40,',
     *        '41,42,43,50')
         STOP
      ENDIF
      IF(IEVC.EQ.50) READ(15,*) THETA1,THETA2

C...  READ IN OUTPUT CONTROLS & INITIALIZE OUTPUT FILES

 499  FORMAT(1X,A32,2X,A24,2X,A24)
 498  FORMAT(1X,I10,1X,E15.7,I10,1X,I10,1X,I10/)
 497  FORMAT(5X,'UNIT ',I2,' FORMAT WILL BE ASCII')
 496  FORMAT(5X,'UNIT ',I2,' FORMAT WILL BE BINARY')

C.... STATION 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,*) I3DSD,TO3DS,TO3DF,NSPO3DSD,NHN3DSD
      WRITE(16,501) I3DSD
 501  FORMAT(/,5X,'I3DSD = ',I3)

      IF((I3DSD.LT.0).OR.(I3DSD.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,511)
         WRITE(16,511)
 511     FORMAT(/,2X,'    I3DSD MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DSD.EQ.0) WRITE(16,521)
 521  FORMAT(5X,'NO STATION 3D D,T,S WILL BE OUTPUT')

      IF(I3DSD.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSSD=NINT(TSS)
         IF((TSS-NTSSSD).GE.0.5) NTSSSD=NTSSSD+1 !START AFTER T.S.
         IF(NTSSSD.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,531) TO3DS
            WRITE(16,531) TO3DS
 531        FORMAT(5X,'NOTE: TO3DSSD = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSSD=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFSD=NINT(TSF)
         IF((TSF-NTSFSD).GE.0.5) NTSFSD=NTSFSD+1 !END T.S.
         IF(NTSFSD.LT.NTSSSD) THEN
            IF(NSCREEN.NE.0) WRITE(6,541) TO3DF
            WRITE(16,541) TO3DF
 541        FORMAT(5X,'NOTE: TO3DFSD = ',E14.6,' < TO3DSSD. ',
     *           'IT HAS BEEN RESET = TO3DSSD.')
            TO3DF=TO3DS
            NTSFSD=NTSSSD
         ENDIF
         IF(NTSFSD.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,551) TO3DF
            WRITE(16,551) TO3DF
 551        FORMAT(5X,'NOTE: TO3DFSD = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFSD=NT
         ENDIF
         IF(NSPO3DSD.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,561) NSPO3DSD
            ENDIF
            WRITE(16,350)
            WRITE(16,561) NSPO3DSD
 561        FORMAT(2X,'    NSPO3DSD = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISDHOUT(N),N=1,NHN3DSD)

         NDSETSD = (NTSFSD-NTSSSD)/NSPO3DSD !NUMBER OF DATA SETS
         NSSD=-1                !COUNTER

         WRITE(16,571) NSPO3DSD,TO3DS,NTSSSD,TO3DF,NTSFSD,
     *        NSPO3DSD,NHN3DSD
 571     FORMAT(5X,'STATION 3D D,T,S WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSSD.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     *        'SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFSD =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 41 EVERY',
     *        ' NSPO3DSD = ',I7,' TIME STEPS',
     *        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DSD.EQ.1) THEN
         WRITE(16,497) 41
         OPEN(41,FILE=DIRNAME//'/'//'fort.41')
         WRITE(41,499) RUNDES,RUNID,AGRID
         WRITE(41,498) NDSETSD,DELT*NSPO3DSD,NSPO3DSD,NHN3DSD,NFEN
         WRITE(41,*) ' '
      ENDIF

      IF(I3DSD.EQ.2) THEN
         WRITE(16,496) 41
         OPEN(41,FILE=DIRNAME//'/'//'fort.41',ACCESS='DIRECT',RECL=NBYTE)
         ISDREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RID4(N)
            ENDDO
            DO N=1,6
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RID8(N)
            ENDDO
            DO N=1,3
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(41,REC=ISDREC+1) NDSETSD
         WRITE(41,REC=ISDREC+2) DELT*NSPO3DSD
         WRITE(41,REC=ISDREC+3) NSPO3DSD
         WRITE(41,REC=ISDREC+4) NHN3DSD
         WRITE(41,REC=ISDREC+5) NFEN
         ISDREC=ISDREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DSD, NTSSSD, NSPO3DSD = ',I3DSD,NTSSSD,NSPO3DSD
         WRITE(2,*) 'NHN3DSD = ',NHN3DSD
         DO NN=1,NHN3DSD
            WRITE(2,*) 'ISDHOUT(',NN,') = ',ISDHOUT(NN)
         END DO
      ENDIF

C.... STATION 3D VELOCITY OUTPUT

      READ(15,*) I3DSV,TO3DS,TO3DF,NSPO3DSV,NHN3DSV
      WRITE(16,502) I3DSV
 502  FORMAT(/,5X,'I3DSV = ',I3)

      IF((I3DSV.LT.0).OR.(I3DSV.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,512)
         WRITE(16,512)
 512     FORMAT(/,2X,'    I3DSV MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DSV.EQ.0) WRITE(16,522)
 522  FORMAT(5X,'NO STATION 3D VELOCITY WILL BE OUTPUT')

      IF(I3DSV.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSSV=NINT(TSS)
         IF((TSS-NTSSSV).GE.0.5) NTSSSV=NTSSSV+1 !START AFTER T.S.
         IF(NTSSSV.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,532) TO3DS
            WRITE(16,532) TO3DS
 532        FORMAT(5X,'NOTE: TO3DSSV = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSSV=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFSV=NINT(TSF)
         IF((TSF-NTSFSV).GE.0.5) NTSFSV=NTSFSV+1 !END T.S.
         IF(NTSFSV.LT.NTSSSV) THEN
            IF(NSCREEN.NE.0) WRITE(6,542) TO3DF
            WRITE(16,542) TO3DF
 542        FORMAT(5X,'NOTE: TO3DFSV = ',E14.6,' < TO3DSSV. ',
     *           'IT HAS BEEN RESET = TO3DSSV.')
            TO3DF=TO3DS
            NTSFSV=NTSSSV
         ENDIF
         IF(NTSFSV.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,552) TO3DF
            WRITE(16,552) TO3DF
 552        FORMAT(5X,'NOTE: TO3DFSV = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFSV=NT
         ENDIF
         IF(NSPO3DSV.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,562) NSPO3DSV
            ENDIF
            WRITE(16,350)
            WRITE(16,562) NSPO3DSV
 562        FORMAT(2X,'    NSPO3DSV = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISVHOUT(N),N=1,NHN3DSV)

         NDSETSV = (NTSFSV-NTSSSV)/NSPO3DSV !NUMBER OF DATA SETS
         NSSV=-1                !COUNTER

         WRITE(16,572) NSPO3DSV,TO3DS,NTSSSV,TO3DF,NTSFSV,
     *        NSPO3DSV,NHN3DSV
 572     FORMAT(5X,'STATION 3D VELOCITY WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSSV.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     *        'SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFSV =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 42 EVERY',
     *        ' NSPO3DSV = ',I7,' TIME STEPS',
     *        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DSV.EQ.1) THEN
         WRITE(16,497) 42
         OPEN(42,FILE=DIRNAME//'/'//'fort.42')
         WRITE(42,499) RUNDES,RUNID,AGRID
         WRITE(42,498) NDSETSV,DELT*NSPO3DSV,NSPO3DSV,NHN3DSV,NFEN
         WRITE(42,*) ' '
      ENDIF

      IF(I3DSV.EQ.2) THEN
         WRITE(16,496) 42
         OPEN(42,FILE=DIRNAME//'/'//'fort.42',ACCESS='DIRECT',RECL=NBYTE)
         ISVREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RID4(N)
            ENDDO
            DO N=1,6
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RID8(N)
            ENDDO
            DO N=1,3
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(42,REC=ISVREC+1) NDSETSV
         WRITE(42,REC=ISVREC+2) DELT*NSPO3DSV
         WRITE(42,REC=ISVREC+3) NSPO3DSV
         WRITE(42,REC=ISVREC+4) NHN3DSV
         WRITE(42,REC=ISVREC+5) NFEN
         ISVREC=ISVREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DSV, NTSSSV, NSPO3DSV = ',I3DSV,NTSSSV,NSPO3DSV
         WRITE(2,*) 'NHN3DSV = ',NHN3DSV
         DO NN=1,NHN3DSV
            WRITE(2,*) 'ISVHOUT(',NN,') = ',ISVHOUT(NN)
         END DO
      ENDIF

C.... STATION 3D TURBULENCE OUTPUT

      READ(15,*) I3DST,TO3DS,TO3DF,NSPO3DST,NHN3DST
      WRITE(16,503) I3DST
 503  FORMAT(/,5X,'I3DST = ',I3)

      IF((I3DST.LT.0).OR.(I3DST.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,513)
         WRITE(16,513)
 513     FORMAT(/,2X,'    I3DST MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DST.EQ.0) WRITE(16,523)
 523  FORMAT(5X,'NO STATION 3D TURBULENCE WILL BE OUTPUT')

      IF(I3DST.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSST=NINT(TSS)
         IF((TSS-NTSSSV).GE.0.5) NTSSST=NTSSST+1 !START AFTER T.S.
         IF(NTSSST.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,533) TO3DS
            WRITE(16,533) TO3DS
 533        FORMAT(5X,'NOTE: TO3DSST = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSST=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFST=NINT(TSF)
         IF((TSF-NTSFST).GE.0.5) NTSFST=NTSFST+1 !END T.S.
         IF(NTSFST.LT.NTSSST) THEN
            IF(NSCREEN.NE.0) WRITE(6,543) TO3DF
            WRITE(16,543) TO3DF
 543        FORMAT(5X,'NOTE: TO3DFST = ',E14.6,' < TO3DSST. ',
     *           'IT HAS BEEN RESET = TO3DSST.')
            TO3DF=TO3DS
            NTSFST=NTSSST
         ENDIF
         IF(NTSFST.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,553) TO3DF
            WRITE(16,553) TO3DF
 553        FORMAT(5X,'NOTE: TO3DFST = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFST=NT
         ENDIF
         IF(NSPO3DST.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,563) NSPO3DST
            ENDIF
            WRITE(16,350)
            WRITE(16,563) NSPO3DST
 563        FORMAT(2X,'    NSPO3DST = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISTHOUT(N),N=1,NHN3DST)

         NDSETST = (NTSFST-NTSSST)/NSPO3DST !NUMBER OF DATA SETS
         NSST=-1                !COUNTER

         WRITE(16,573) NSPO3DST,TO3DS,NTSSST,TO3DF,NTSFST,
     *        NSPO3DST,NHN3DST
 573     FORMAT(5X,'STATION 3D TURBULENCE WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSST.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     *        'SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFST =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 43 EVERY',
     *        ' NSPO3DST = ',I7,' TIME STEPS',
     *        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DST.EQ.1) THEN
         WRITE(16,497) 43
         OPEN(43,FILE=DIRNAME//'/'//'fort.43')
         WRITE(43,499) RUNDES,RUNID,AGRID
         WRITE(43,498) NDSETST,DELT*NSPO3DST,NSPO3DST,NHN3DST,NFEN
         WRITE(43,*) ' '
      ENDIF

      IF(I3DST.EQ.2) THEN
         WRITE(16,496) 43
         OPEN(43,FILE=DIRNAME//'/'//'fort.43',ACCESS='DIRECT',RECL=NBYTE)
         ISTREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RID4(N)
            ENDDO
            DO N=1,6
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RID8(N)
            ENDDO
            DO N=1,3
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(43,REC=ISTREC+1) NDSETST
         WRITE(43,REC=ISTREC+2) DELT*NSPO3DST
         WRITE(43,REC=ISTREC+3) NSPO3DST
         WRITE(43,REC=ISTREC+4) NHN3DST
         WRITE(43,REC=ISTREC+5) NFEN
         ISTREC=ISTREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DST, NTSSST, NSPO3DST = ',I3DST,NTSSST,NSPO3DST
         WRITE(2,*) 'NHN3DST = ',NHN3DST
         DO NN=1,NHN3DST
            WRITE(2,*) 'ISTHOUT(',NN,') = ',ISTHOUT(NN)
         END DO
      ENDIF

C.... GLOBAL 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,*) I3DGD,TO3DS,TO3DF,NSPO3DGD
      WRITE(16,504) I3DGD
 504  FORMAT(/,5X,'I3DGD = ',I3)

      IF((I3DGD.LT.0).OR.(I3DGD.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,514)
         WRITE(16,514)
 514     FORMAT(/,2X,'    I3DGD MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGD.EQ.0) WRITE(16,524)
 524  FORMAT(5X,'NO GLOBAL 3D D,T,S WILL BE OUTPUT')

      IF(I3DGD.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGD=NINT(TSS)
         IF((TSS-NTSSGD).GE.0.5) NTSSGD=NTSSGD+1 !START AFTER T.S.
         IF(NTSSGD.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,534) TO3DS
            WRITE(16,534) TO3DS
 534        FORMAT(5X,'NOTE: TO3DSGD = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGD=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGD=NINT(TSF)
         IF((TSF-NTSFGD).GE.0.5) NTSFGD=NTSFGD+1 !END T.S.
         IF(NTSFGD.LT.NTSSGD) THEN
            IF(NSCREEN.NE.0) WRITE(6,544) TO3DF
            WRITE(16,544) TO3DF
 544        FORMAT(5X,'NOTE: TO3DFGD = ',E14.6,' < TO3DSGD. ',
     *           'IT HAS BEEN RESET = TO3DSGD.')
            TO3DF=TO3DS
            NTSFGD=NTSSGD
         ENDIF
         IF(NTSFGD.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,554) TO3DF
            WRITE(16,554) TO3DF
 554        FORMAT(5X,'NOTE: TO3DFGD = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFGD=NT
         ENDIF
         IF(NSPO3DGD.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,564) NSPO3DGD
            ENDIF
            WRITE(16,350)
            WRITE(16,564) NSPO3DGD
 564        FORMAT(2X,'    NSPO3DGD = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGD = (NTSFGD-NTSSGD)/NSPO3DGD !NUMBER OF DATA SETS
         NSGD = -1              !COUNTER

         WRITE(16,574) NSPO3DGD,TO3DS,NTSSGD,TO3DF,NTSFGD,
     *        NSPO3DGD
 574     FORMAT(5X,'GLOBAL 3D D,S,T WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSGD.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFGD =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 44 EVERY',
     *        ' NSPO3DGD = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGD.EQ.1) THEN
         WRITE(16,497) 44
         OPEN(44,FILE=DIRNAME//'/'//'fort.44')
         WRITE(44,499) RUNDES,RUNID,AGRID
         WRITE(44,498) NDSETGD,DELT*NSPO3DGD,NSPO3DGD,NP,NFEN
         WRITE(44,*) ' '
      ENDIF

      IF(I3DGD.EQ.2) THEN
         WRITE(16,496) 44
         OPEN(44,FILE=DIRNAME//'/'//'fort.44',ACCESS='DIRECT',RECL=NBYTE)
         IGDREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RID4(N)
            ENDDO
            DO N=1,6
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RID8(N)
            ENDDO
            DO N=1,3
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(44,REC=IGDREC+1) NDSETGD
         WRITE(44,REC=IGDREC+2) DELT*NSPO3DGD
         WRITE(44,REC=IGDREC+3) NSPO3DGD
         WRITE(44,REC=IGDREC+4) NP
         WRITE(44,REC=IGDREC+5) NFEN
         IGDREC=IGDREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGD, NTSSGD, NSPO3DGD = ',I3DGD,NTSSGD,NSPO3DGD
      ENDIF

C.... GLOBAL 3D VELOCITY OUTPUT

      READ(15,*) I3DGV,TO3DS,TO3DF,NSPO3DGV
      WRITE(16,505) I3DGV
 505  FORMAT(/,5X,'I3DGV = ',I3)

      IF((I3DGV.LT.0).OR.(I3DGV.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,515)
         WRITE(16,515)
 515     FORMAT(/,2X,'    I3DGV MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGV.EQ.0) WRITE(16,525)
 525  FORMAT(5X,'NO GLOBAL 3D VELOCITY WILL BE OUTPUT')

      IF(I3DGV.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGV=NINT(TSS)
         IF((TSS-NTSSGV).GE.0.5) NTSSGV=NTSSGV+1 !START AFTER T.S.
         IF(NTSSGV.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,535) TO3DS
            WRITE(16,535) TO3DS
 535        FORMAT(5X,'NOTE: TO3DSGV = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGV=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGV=NINT(TSF)
         IF((TSF-NTSFGV).GE.0.5) NTSFGV=NTSFGV+1 !END T.S.
         IF(NTSFGV.LT.NTSSGV) THEN
            IF(NSCREEN.NE.0) WRITE(6,545) TO3DF
            WRITE(16,545) TO3DF
 545        FORMAT(5X,'NOTE: TO3DFGV = ',E14.6,' < TO3DSGV. ',
     *           'IT HAS BEEN RESET = TO3DSGV.')
            TO3DF=TO3DS
            NTSFGV=NTSSGV
         ENDIF
         IF(NTSFGV.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,555) TO3DF
            WRITE(16,555) TO3DF
 555        FORMAT(5X,'NOTE: TO3DFGV = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFGV=NT
         ENDIF
         IF(NSPO3DGV.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,565) NSPO3DGV
            ENDIF
            WRITE(16,350)
            WRITE(16,565) NSPO3DGV
 565        FORMAT(2X,'    NSPO3DGV = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGV = (NTSFGV-NTSSGV)/NSPO3DGV !NUMBER OF DATA SETS
         NSGV = -1              !COUNTER

         WRITE(16,575) NSPO3DGV,TO3DS,NTSSGV,TO3DF,NTSFGV,
     *        NSPO3DGV
 575     FORMAT(5X,'GLOBAL 3D VELOCITY WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSGV.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFGV =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 45 EVERY',
     *        ' NSPO3DGV = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGV.EQ.1) THEN
         WRITE(16,497) 45
         OPEN(45,FILE=DIRNAME//'/'//'fort.45')
         WRITE(45,499) RUNDES,RUNID,AGRID
         WRITE(45,498) NDSETGV,DELT*NSPO3DGV,NSPO3DGV,NP,NFEN
         WRITE(45,*) ' '
      ENDIF

      IF(I3DGV.EQ.2) THEN
         WRITE(16,496) 45
         OPEN(45,FILE=DIRNAME//'/'//'fort.45',ACCESS='DIRECT',RECL=NBYTE)
         IGVREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RID4(N)
            ENDDO
            DO N=1,6
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RID8(N)
            ENDDO
            DO N=1,3
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(45,REC=IGVREC+1) NDSETGV
         WRITE(45,REC=IGVREC+2) DELT*NSPO3DGV
         WRITE(45,REC=IGVREC+3) NSPO3DGV
         WRITE(45,REC=IGVREC+4) NP
         WRITE(45,REC=IGVREC+5) NFEN
         IGVREC=IGVREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGV, NTSSGV, NSPO3DGV = ',I3DGV,NTSSGV,NSPO3DGV
      ENDIF

C.... GLOBAL 3D TURBULENCE OUTPUT

      READ(15,*) I3DGT,TO3DS,TO3DF,NSPO3DGT
      WRITE(16,506) I3DGT
 506  FORMAT(/,5X,'I3DGT = ',I3)

      IF((I3DGT.LT.0).OR.(I3DGT.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,516)
         WRITE(16,516)
 516     FORMAT(/,2X,'    I3DGT MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGT.EQ.0) WRITE(16,526)
 526  FORMAT(5X,'NO GLOBAL 3D TURBULENCE INFORMATION WILL BE OUTPUT')

      IF(I3DGT.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGT=NINT(TSS)
         IF((TSS-NTSSGT).GE.0.5) NTSSGT=NTSSGT+1 !START AFTER T.S.
         IF(NTSSGT.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,536) TO3DS
            WRITE(16,536) TO3DS
 536        FORMAT(5X,'NOTE: TO3DSGT = ',E14.6,' < START TIME. ',
     *           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGT=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGT=NINT(TSF)
         IF((TSF-NTSFGT).GE.0.5) NTSFGT=NTSFGT+1 !END T.S.
         IF(NTSFGT.LT.NTSSGT) THEN
            IF(NSCREEN.NE.0) WRITE(6,546) TO3DF
            WRITE(16,546) TO3DF
 546        FORMAT(5X,'NOTE: TO3DFGT = ',E14.6,' < TO3DSGT. ',
     *           'IT HAS BEEN RESET = TO3DSGT.')
            TO3DF=TO3DS
            NTSFGT=NTSSGT
         ENDIF
         IF(NTSFGT.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,556) TO3DF
            WRITE(16,556) TO3DF
 556        FORMAT(5X,'NOTE: TO3DFGT = ',E14.6,' > RNDAY. ',
     *           'IT HAS BEEN RESET = RNDAY.')
            NTSFGT=NT
         ENDIF
         IF(NSPO3DGT.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,566) NSPO3DGT
            ENDIF
            WRITE(16,350)
            WRITE(16,566) NSPO3DGT
 566        FORMAT(2X,'    NSPO3DGT = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGT = (NTSFGT-NTSSGT)/NSPO3DGT !NUMBER OF DATA SETS
         NSGT = -1              !COUNTER

         WRITE(16,576) NSPO3DGT,TO3DS,NTSSGT,TO3DF,NTSFGT,
     *        NSPO3DGT
 576     FORMAT(5X,'GLOBAL 3D TURBULENCE WILL BE OUTPUT STARTING',I9,
     *        /,9X,'TIMESTEPS AFTER TO3DSGT.  THIS =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'OUTPUT WILL STOP AFTER TO3DFGT =',F8.3,
     *        ' DAY(S) RELATIVE TO',
     *        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     *        ' SIMULATION',
     *        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 46 EVERY',
     *        ' NSPO3DGT = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGT.EQ.1) THEN
         WRITE(16,497) 46
         OPEN(46,FILE=DIRNAME//'/'//'fort.46')
         WRITE(46,499) RUNDES,RUNID,AGRID
         WRITE(46,498) NDSETGT,DELT*NSPO3DGT,NSPO3DGT,NP,NFEN
         WRITE(46,*) ' '
      ENDIF

      IF(I3DGT.EQ.2) THEN
         WRITE(16,496) 46
         OPEN(46,FILE=DIRNAME//'/'//'fort.46',ACCESS='DIRECT',RECL=NBYTE)
         IGTREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RID4(N)
            ENDDO
            DO N=1,6
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RID8(N)
            ENDDO
            DO N=1,3
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(46,REC=IGTREC+1) NDSETGT
         WRITE(46,REC=IGTREC+2) DELT*NSPO3DGT
         WRITE(46,REC=IGTREC+3) NSPO3DGT
         WRITE(46,REC=IGTREC+4) NP
         WRITE(46,REC=IGTREC+5) NFEN
         IGTREC=IGTREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGT, NTSSGT, NSPO3DGT = ',I3DGT,NTSSGT,NSPO3DGT
      ENDIF

C.....COMPUTE SOME PARAMETERS

      IDTAlp1 = I*DELT*ALP1
      IDT1MAlp1 = I*DELT*(1.-ALP1)
      DTAlp3 = DELT*ALP3
      DT1MAlp3 = DELT*(1-ALP3)
      DTAlp2 = DELT*ALP2
      DT1MAlp2 = DELT*(1.-ALP2)

      RETURN
      END SUBROUTINE READ_INPUT_3DVS

c******************************************************************************
c******************************************************************************

      SUBROUTINE VSSTUP(DELT,NT)

      USE GLOBAL_3DVS
      REAL(SZ) :: DELT
      INTEGER :: NT

      ! elevation data input for debugging
      OPEN(99,FILE='fort.99',ACCESS='DIRECT',RECL=NBYTE)

C...  
C...  COLD START PROBLEM SETUP
C...  
      IF(IHOT.EQ.0) THEN

C...  IF A BAROCLINIC RUN, READ IN INITIAL DENSITY FIELD

         IF(IDEN.GT.0) THEN
            WRITE(16,424)
 424        FORMAT(/,5X,'INITIAL DENSITY FIELD READ IN FROM UNIT 11',/)
            OPEN(11,FILE=DIRNAME//'/'//'fort.11')
            READ(11,*)          !skip over header line
            READ(11,*)          !skip over header line
            READ(11,*) NVN
            IF(NVN.NE.NFEN) THEN
               WRITE(16,351) NVN,NFEN
               WRITE(*,351) NVN,NFEN
 351           FORMAT(/,2X,'***** INVALID INPUT IN THE DENSITY INITIAL ',
     *              'CONDITION FILE (UNIT 11) *****',
     *              /,2X,'***** NVN = ',I4,' MUST MATCH NFEN = ',I4,
     *              ' *****',
     *              /,10X,'****** RUN TERMINATED ******')
               STOP
            ENDIF
            DO IHN=1,NP
               DO IVN=1,NFEN
                  READ(11,*) NHNN,NVNN,SIGT(NHNN,NVNN),TEMP(NHNN,NVNN),
     *                 SAL(NHNN,NVNN)
               END DO
            END DO
            CLOSE(11)
         ENDIF

C...  ZERO OUT STUFF PASSED FROM 3D SOLUTION TO EXTERNAL MODE

         DO NH=1,NP
            DUU(NH)=0.d0
            DUV(NH)=0.d0
            DVV(NH)=0.d0
            UBAR(NH)=0.d0
            VBAR(NH)=0.d0
            TAUBX(NH)=0.d0
            TAUBY(NH)=0.d0
            VIDBCPDX(NH)=0.d0
            VIDBCPDY(NH)=0.d0
         ENDDO

C...  INITIALIZE 3D VELOCITY AND TURBULENCE SOLUTION
         
         DO NH=1,NP
            DO N=1,NFEN
               Q(NH,N)=(0.d0,0.d0)
               q20(NH,N)=0.d0
               l(NH,N)=0.d0
               wz(NH,N)=0.d0
            ENDDO
         ENDDO
C...  
C...  END COLD START PROBLEM SETUP
C...  
      ENDIF


C...  
C...  HOT START PROBLEM SETUP
C...  
      IF(IHOT.NE.0) THEN

         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSSD
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISDREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSSV
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISVREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSST
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISTREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGD
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGDREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGV
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGVREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGT
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGTREC

         DO NH=1,NP
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DUU(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DUV(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DVV(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) UBAR(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VBAR(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) TAUBX(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) TAUBY(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VIDBCPDX(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VIDBCPDY(NH)
         ENDDO

         DO NH=1,NP
            DO N=1,NFEN
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) Q(NH,N)
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) WZ(NH,N)
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) q20(NH,N)
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) l(NH,N)
               IF(IDEN.EQ.1) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SIGT(NH,N)
               ENDIF
               IF(IDEN.EQ.2) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SAL(NH,N)
                  TEMP(NH,N)=0.d0
                  SIGT(NH,N)=0.d0 !Need to fix this
               ENDIF
               IF(IDEN.EQ.3) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) TEMP(NH,N)
                  SAL(NH,N)=0.d0
                  SIGT(NH,N)=0.d0 !Need to fix this
               ENDIF
               IF(IDEN.EQ.4) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SAL(NH,N)
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) TEMP(NH,N)
               ENDIF
            ENDDO
         ENDDO
C...  
C...  END HOT START PROBLEM SETUP
C...  
      ENDIF


C...  
C...  ADDITIONAL RUN SETUP
C...  

C...  COMPUTE THE INTEGRALS Inm and LVn (INDEPENDENT OF HORIZONTAL NODE)
      
      IF(IDIAG.EQ.2) WRITE(2,*) '********** VSSETUP **********'
c     CALL InmInt(Inm)
      CALL InmInt()
      IF(IDIAG.EQ.2) WRITE(2,*) '********** VSSETUP **********'
      CALL LVnInt(LVn)


      RETURN
      END SUBROUTINE VSSTUP

 

c******************************************************************************
c  SUBROUTINE VSSOL                                                           *
c                                                                             *
c  Note, the following time stepping coefficients are computed in             *
C     VSSTUP and passed in a common block.                                    *
c                                                                             *
c  IDTAlp1      = I*DelT*Alp1        - weights coriolis term in LHS matrix    *
c  IDT1MAlp1    = I*DelT*(1.-Alp1)   - weights coriolis term in RHS forcing   *
c  DTAlp3       = DelT*Alp3          - weights vert diff term in LHS matrix   *
c  DT1MAlp3     = DelT*(1-Alp3)      - weights vert diff term in RHS forcing  *
c  DTAlp2       = DelT*Alp2          - weights bot stress term in LHS matrix  *
c  DT1MAlp2     = DelT*(1.-Alp2)     - weights bot stress term in RHS forcing *
c                                                                             *
c  q(MNP,MNodes) - 3D Complex Velocity field (GAMMA) from past time step.     *
c                                                                             *
c                                                                             *
c  NH - horizontal node counter                                               *
c  NP - number of nodes in horizontal grid                                    *
c  NFEN - number of nodes in the vertical grid                                *
c  BTP - total barotropic pressure (atmos press, water level, tidal potential)*
c                 at time levels s+1/2                                        *
c******************************************************************************

      SUBROUTINE VSSOL(IT,Time,DelT)

      USE GLOBAL_3DVS


      INTEGER :: IT
      INTEGER :: NEle           !local value of NetTabEle
      INTEGER :: k              !vertical node loop counter (1-bottom, NFEN-surf)
      INTEGER :: NH             !horizontal node loop counter
      INTEGER :: N              !neighbor node loop counter
      INTEGER :: N1,N2,N3,NNFirst !local node numbers used to compute gradients
      INTEGER :: LBP            !value of LBArray_Pointer at present horizontal node
      INTEGER :: NN             !output loop counter

      REAL(SZ) :: DelT          !time step in sec
      REAL(SZ) :: KSlip         !equavalent linear slip coeff
      REAL(SZ) :: TauSXsNH,TauSYsNH !Wind stress components at time level s at node NH

      REAL(SZ) :: WSigma(MNodes) !"sigma" vertical velocity
      REAL(SZ) :: Wf            !weighting coefficient in adjoint correction to w
      REAL(SZ) :: WfOHH         !Wf/(H time level s+1)^2
      REAL(SZ) :: WZSurfBC      !surface boundary condition value of w
      REAL(SZ) :: WZSurf        !computed value of w at surface
      REAL(SZ) :: WZCorrection  !adjoint correction compute for w

      REAL(SZ) :: SigmaNN       !Sigma value of a neighbor node
      REAL(SZ) :: Zk            !z depth of any node k in the vertical
      REAL(SZ) :: DelSig        ! sigma(k+1)-sigma(k)
      REAL(SZ) :: DelSigO2      !(sigma(k)-sigma(k-1))/2
      REAL(SZ) :: SigmaMAOAMB   !(sigma(k)-A)/(a-b)
      REAL(SZ) :: SigmaMBOAMB   !(sigma(k)-B)/(a-b)
      REAL(SZ) :: SigAvgMAOAMB  !((sigma(k)+sigma(k-1))/2.d0 - A)/AMB

      REAL(SZ) :: EV(MNP,MNodes) !archive of all EVTot values at previous time step

      REAL(SZ) :: VelNorm,VelTan !-QNormsp1(NH)/Hsp1 at flux boundary node
      REAL(SZ) :: CLBP,SLBP     !local values of CSII, SIII at boundary node LBP
      REAL(SZ) :: Auv1km1,Auv2km1 !initial real,imaginary parts of Mkm1 at flux boundary node
      REAL(SZ) :: Auv1km1star,Auv2km1star !rotated real,imaginary parts of Mkm1 at flux boundary node
      REAL(SZ) :: Auv1k1,Auv2k1 !initial real,imaginary parts of Mk at flux boundary node
      REAL(SZ) :: Auv1k1star,Auv2k1star !rotated real,imaginary parts of Mk at flux boundary node
      REAL(SZ) :: Auv1kp1,Auv2kp1 !initial real,imaginary parts of Mkp1 at flux boundary node
      REAL(SZ) :: Auv1kp1star,Auv2kp1star !rotated real,imaginary parts of Mkp1 at flux boundary node

      REAL(SZ) :: EtaN1,EtaN2,EtaN3,EtaNFirst !nodal values of NolIFA(Eta1+Eta2)/2
      REAL(SZ) :: hN1,hN2,hN3,hNFirst !nodal values of DP
      REAL(SZ) :: DUDX(MNodes),DVDY(MNodes) !horizontal derivatives of velocity used to compute w
      REAL(SZ) :: Un,Vn         !real,imaginary components of qn
      REAL(SZ) :: DelU,DelV     !real, imaginary parts of q(k)-q(k-1)

      REAL(SZ) :: BTPN1,BTPN2,BTPN3,BTPNFirst !nodal values of BTP
      REAL(SZ) :: BTPDX2A,BTPDY2A !(Horiz. grads of BTP)*2*Element Area

      REAL(SZ) :: BCPN1,BCPN2,BCPN3,BCPNFirst !nodal values of BCP
      REAL(SZ) :: BCPDX2A,BCPDY2A !(Horiz. grads of BCP)*2*Element Area
      REAL(SZ) :: SigTAvg       !avg SigT between 2 vertical nodes
      REAL(SZ) :: HGORhoOAMB    !depth*gravity/(reference density)/(a-b)

      REAL(8) :: KVnm(MNodes,3) !integral used in vertical stress term
      REAL(8) :: Time           !model time at time level s+1
      REAL(8) :: DEtaDT         !time derivative of water surface elev
      REAL(8) :: DEtaDX,DEtaDY  !horizontal derivatives of water surface elev at time level s
      REAL(8) :: DEtaDX2A,DEtaDY2A !(DEtaDX,DEtaDY)*2*Element Area 
      REAL(8) :: DhDX,DhDY      !horizontal derivatives of DP
      REAL(8) :: DhDX2A,DhDY2A  !(DhDX,DhDY)*2*Element Area
      REAL(8) :: TotalArea2     !2*Area of all elements around a node
      REAL(8) :: TotalBCPGArea2 !2*Area of all elements around a node used to compute the BCPG
      REAL(8) :: a1,a2,a3,b1,b2,b3 !elemental coefficients used in horizontal FE method

      REAL(8) :: Hs             !Total water depth at time level s
      REAL(8) :: HsN2           !Total water depth at time level s at local node N2
      REAL(8) :: HsOAMB         !Hs/(a-b)
      REAL(8) :: HsHsOAMBAMB    !(Hs/(a-b))^2
      REAL(8) :: Hsp1           !Total water depth at time level s+1
      REAL(8) :: Hsp1OAMB       !Hsp1/(a-b)
      REAL(8) :: Hsp1Hsp1OAMBAMB !(Hsp1/(a-b))^2

      COMPLEX :: Fr(MNodes)     !right side forcing vector
      COMPLEX :: Frstar         !rotated right side forcing vector at flux boundary node 
      COMPLEX :: Mkm1(MNodes)   !1st column (k-1) in left side compact storage matrix
      COMPLEX :: Mk(MNodes)     !2nd column (k) in left side compact storage matrix
      COMPLEX :: Mkp1(MNodes)   !3rd column (k+1) in left side cpmpact storage matrix
      COMPLEX :: LAdvec(MNodes) !lateral advection term in momentum eqn
      COMPLEX :: LStress(MNodes) !lateral stress term in momentum eqn
      COMPLEX :: VAdvec(MNodes) !vertical advection term in momentum eqn
      COMPLEX :: VStress(MNodes) !vertical stress term in momentum eqn
      COMPLEX :: BCPG(MNodes)   !baroclinic pressure gradient
      COMPLEX :: BTPG           !total barotropic pressure gradient (incl TP & water level)
      COMPLEX :: CCR,CCL        !coeffs used on right,left side of momentum eqn
      COMPLEX :: VIBCPG         !vertically integrated baroclinic pressure gradient at a node
      COMPLEX :: VIVel          !vertically integrated velocity
      COMPLEX :: DUDS           !complex vertical velocity gradient between bottom two nodes
      COMPLEX :: qn,qN1,qN2,qN3,qNFirst !nodal values of q
      COMPLEX :: UnDqDX,VnDqDY  !derivatives used in lateral advection
      COMPLEX :: UnDqDX2A,VnDqDY2A !UnDqDX,UnDqDY)*2*Element Area
      COMPLEX :: DqDXDPhiDX2A,DqDYDPhiDY2A !derivatives used in lateral stress calc.
      COMPLEX :: DqDSigmakm1,DqDSigmakp1 !vertical deriv. of q from k-1,k and k,k+1
      COMPLEX :: DqDX2A(MNodes) !horizontal derivatives of complex
      COMPLEX :: DqDY2A(MNodes) !          velocity used in w calc

C     
C     INCREMENT THE TIMESTEP SINCE START COUNTER
C     
      istart=istart+1

C*************************************************************************************
C     Check whether it is time to print various 3D outputs      


 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION DENSITY,
C     TEMPERATURE, SALINITY OUTPUT IF SO, WRITE TIME AND TIME STEP INTO
C     FILE
C     
      IF(I3DSD.GT.0) THEN
         IF((IT.GT.NTSSSD).AND.(NSSD.LT.0)) NSSD=0
         IF((IT.GT.NTSSSD).AND.(IT.LE.NTSFSD)) NSSD=NSSD+1
         IF(NSSD.EQ.NSPO3DSD) THEN
            NSSD=0
            IF(I3DSD.EQ.1) WRITE(41,1100) TIME,IT,
     *           (SIGMA(k),SIGMA(k),SIGMA(k),k=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DSD.EQ.2) THEN
               WRITE(41,REC=ISDREC+1) TIME
               WRITE(41,REC=ISDREC+2) IT
               ISDREC = ISDREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION VELOCITY OUTPUT
C     IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DSV.GT.0) THEN
         IF((IT.GT.NTSSSV).AND.(NSSV.LT.0)) NSSV=0
         IF((IT.GT.NTSSSV).AND.(IT.LE.NTSFSV)) NSSV=NSSV+1
         IF(NSSV.EQ.NSPO3DSV) THEN
            NSSV=0
            IF(I3DSV.EQ.1) WRITE(42,1100) TIME,IT,
     *           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DSV.EQ.2) THEN
               WRITE(42,REC=ISVREC+1) TIME
               WRITE(42,REC=ISVREC+2) IT
               ISVREC = ISVREC + 2
            ENDIF
         ENDIF
      ENDIF


C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION TURBULENCE
C     PARAMETER OUTPUT IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DST.GT.0) THEN
         IF((IT.GT.NTSSST).AND.(NSST.LT.0)) NSST=0
         IF((IT.GT.NTSSST).AND.(IT.LE.NTSFST)) NSST=NSST+1
         IF(NSST.EQ.NSPO3DST) THEN
            NSST=0
            IF(I3DST.EQ.1) WRITE(43,1100) TIME,IT,
     *           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DST.EQ.2) THEN
               WRITE(43,REC=ISTREC+1) TIME
               WRITE(43,REC=ISTREC+2) IT
               ISTREC = ISTREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL DENSITY, TEMPERATURE
C     AND SALINITY IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGD.GT.0) THEN
         IF((IT.GT.NTSSGD).AND.(NSGD.LT.0)) NSGD=0
         IF((IT.GT.NTSSGD).AND.(IT.LE.NTSFGD)) NSGD=NSGD+1
         IF(NSGD.EQ.NSPO3DGD) THEN
            NSGD=0
            IF(I3DGD.EQ.1) WRITE(44,1100) TIME,IT,
     *           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGD.EQ.2) THEN
               WRITE(44,REC=IGDREC+1) TIME
               WRITE(44,REC=IGDREC+2) IT
               IGDREC = IGDREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL VELOCITY OUTPUT
C     IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGV.GT.0) THEN
         IF((IT.GT.NTSSGV).AND.(NSGV.LT.0)) NSGV=0
         IF((IT.GT.NTSSGV).AND.(IT.LE.NTSFGV)) NSGV=NSGV+1
         IF(NSGV.EQ.NSPO3DGV) THEN
            NSGV=0
            IF(I3DGV.EQ.1) WRITE(45,1100) TIME,IT,
     *           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGV.EQ.2) THEN
               WRITE(45,REC=IGVREC+1) TIME
               WRITE(45,REC=IGVREC+2) IT
               IGVREC = IGVREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL TURBULENCE PARAMETER
C     OUTPUT IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGT.GT.0) THEN
         IF((IT.GT.NTSSGT).AND.(NSGT.LT.0)) NSGT=0
         IF((IT.GT.NTSSGT).AND.(IT.LE.NTSFGT)) NSGT=NSGT+1
         IF(NSGT.EQ.NSPO3DGT) THEN
            NSGT=0
            IF(I3DGT.EQ.1) WRITE(46,1100) TIME,IT,
     *           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     *           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGT.EQ.2) THEN
               WRITE(46,REC=IGTREC+1) TIME
               WRITE(46,REC=IGTREC+2) IT
               IGTREC = IGTREC + 2
            ENDIF
         ENDIF
      ENDIF


C*************************************************************************************
C     Set up several variables that are needed for 3D run     

C     
C     Zero out surface stress and stress forcing at top for case of no wind
C     
      TauSXsNH=0.d0
      TauSYsNH=0.d0

C     
C     If a baroclinic run, compute the 3D baroclinic pressure field
C     The buoyancy field is defined as
C     BCP(z)    =(gravity/rho ref)*          integral (SigT) from surface down to z
C     BCP(sigma)=(gravity/rho ref)*(H/(a-b))*integral (SigT) from a down to sigma
C     where 
C     SigT = Sigma T = Rho - 1000 = density - 1000
C     SigT0 = Sigma t value of reference density (typically = 0)
C     Sigma = dimensionless vertical coordinate
C     
      IF(IDEN.EQ.1) THEN
         DO NH=1,NP             !loop over horizontal nodes
            Hs=DP(NH)+NolIFA*Eta1(NH) !total depth at previous (s) timestep
            HGORhoOAMB=GORhoOAMB*Hs !(gravity/rho ref)*(H/(a-b))
            BCP(NH,NFEN)=0.d0
            DO k=NFEN-1,1,-1    !loop over vertical nodes, starting at top and working down
               SigTAvg=(SigT(NH,k+1)+SigT(NH,k))/2.d0
               DelSig=Sigma(k+1)-Sigma(k)
               BCP(NH,k)=BCP(NH,k+1)+HGORhoOAMB*(SigTAvg-SigT0)*DelSig
            ENDDO
         ENDDO

      ENDIF


C*************************************************************************************
C     Compute 3D horizontal velocities     

C     
C     Loop over each horizontal node to compute the horizontal velocity
C     
      DO NH=1,NP                !loop over horizontal nodes

c     Set up some values at the node being worked on

         Hs  = DP(NH)+NolIFA*Eta1(NH) !Total depth at previous (s) timestep
         HsOAMB=Hs/AMB
         HsHsOAMBAMB=HsOAMB*HsOAMB
         Hsp1= DP(NH)+NolIFA*Eta2(NH) !Total depth at present (s+1) timestep
         Hsp1OAMB=Hsp1/AMB
         Hsp1Hsp1OAMBAMB=Hsp1OAMB*Hsp1OAMB

         IF(NWS.NE.0) THEN      !wind stress
            TauSXsNH=TauSX1(NH)
            TauSYsNH=TauSY1(NH)
         ENDIF

c     If specified normal flow boundary node with no tangential slip is
c     lateral boundary condition, set up the matrix immediately and skip
c     to the solution

         LBP=LBArray_Pointer(NH)
         IF(LBP.GT.0) THEN
                                !essential normal flow
            IF((LBCodeI(LBP).GE.10).AND.(LBCodeI(LBP).LE.19)) THEN 
               VelNorm=-QNormsp1(LBP)/Hsp1 !with essential no tan.
               VelTan=0.D0
               SLBP=SIII(LBP)
               CLBP=CSII(LBP)
               DO k=1,NFEN
                  Mkm1(k)=(0.D0,0.D0)
                  Mk(k)=SLBP+I*CLBP
                  Mkp1(k)=(0.D0,0.D0)
                  Fr(k)=VelTan+I*VelNorm
C                  EVTot(k)=0.D0 !f77diff??
               END DO
               GOTO 999
            ENDIF
         ENDIF

c     Compute the vertical eddy viscosity

         CALL EDDYVIS(Hs,UBar(NH),VBar(NH),
     *        TauSXsNH,TauSYsNH,TauBX(NH),TauBY(NH),
     *        istart,NH,DelT,IT)

c     Compute the integral KVnm

         KVnm(1,1)=0.d0
         KVnm(1,3)=-0.5d0*(EVTot(2)+EVTot(1))/(Sigma(2)-Sigma(1))
         KVnm(1,2)=-(KVnm(1,1)+KVnm(1,3))
         DO k=2,NFEN-1
            KVnm(k,1)=KVnm(k-1,3)
            KVnm(k,3)=-0.5d0*(EVTot(k+1)+EVTot(k))/(Sigma(k+1)-Sigma(k))
            KVnm(k,2)=-(KVnm(k,1)+KVnm(k,3))
         ENDDO
         KVnm(NFEN,1)=KVnm(NFEN-1,3)
         KVnm(NFEN,3)=0.d0      
         KVnm(NFEN,2)=-(KVnm(NFEN,1)+KVnm(NFEN,3))

c     Compute time derivative of water surface position

         DEtaDT=(Eta2(NH)-Eta1(NH))/DelT

c     Start computing horizontal derivatives of water level, bathymetric
c     depth and total barotropic pressure (atmos pres, water level,
c     tidal potential) Note: TotalArea2 = 2X total elemental area
c     surrounding a node

         DEtaDX=0.d0
         DEtaDY=0.d0
         DhDX=0.d0
         DhDY=0.d0
         BTPG=(0.d0,0.d0)
         DEtaDX2A=0.d0
         DhDX2A=0.d0
         DEtaDY2A=0.d0
         DhDY2A=0.d0
         BTPDX2A=0.d0
         BTPDY2A=0.d0
         TotalArea2=0.d0

         N1=NH
         EtaN1=NolIFA*(Eta1(N1)+Eta2(N1))/2.d0
         hN1=DP(N1)
         BTPN1=BTP(N1)

         N2=NeiTab(NH,2)        !operate on 1st neighbor
         EtaN2=NolIFA*(Eta1(N2)+Eta2(N2))/2.d0
         hN2=DP(N2)
         BTPN2=BTP(N2)

         NNFirst=N2             !save these values until end
         EtaNFirst=EtaN2
         hNFirst=hN2
         BTPNFirst=BTPN2

         DO N=3,NNeigh(NH)      !operate on rest of neighbors
            N3=N2               !shift previously computed values
            hN3=hN2             !shift previously computed values
            EtaN3=EtaN2
            BTPN3=BTPN2
            N2=NeiTab(NH,N)     !select new neighbor to work on
            EtaN2=NolIFA*(Eta1(N2)+Eta2(N2))/2.d0
            hN2=DP(N2)
            BTPN2=BTP(N2)
            NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
            IF(NEle.NE.0) THEN  !if element is active, compute velocity grads
               TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
               DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
               DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
               DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
               BTPDX2A=BTPDX2A+(BTPN1*b1+BTPN2*b2+BTPN3*b3)
               BTPDY2A=BTPDY2A+(BTPN1*a1+BTPN2*a2+BTPN3*a3)
            ENDIF
         END DO

         N3=N2                  !wrap back to beginning to get final contribution
         hN3=hN2
         EtaN3=EtaN2
         BTPN3=BTPN2
         N2=NNFirst
         hN2=hNFirst
         EtaN2=EtaNFirst
         BTPN2=BTPNFirst
         NEle=NeiTabEle(NH,NNeigh(NH)-1)
         IF(NEle.NE.0) THEN
            TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
            a1=X(N3)-X(N2)
            a2=X(N1)-X(N3)
            a3=X(N2)-X(N1)
            b1=Y(N2)-Y(N3)
            b2=Y(N3)-Y(N1)
            b3=Y(N1)-Y(N2)
            DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
            DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
            DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
            DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
            BTPDX2A=BTPDX2A+(BTPN1*b1+BTPN2*b2+BTPN3*b3)
            BTPDY2A=BTPDY2A+(BTPN1*a1+BTPN2*a2+BTPN3*a3)
         ENDIF

         IF(TotalArea2.NE.0.) THEN
            DhDX=DhDX2A/TotalArea2
            DhDY=DhDY2A/TotalArea2
            DEtaDX=DEtaDX2A/TotalArea2
            DEtaDY=DEtaDY2A/TotalArea2
            BTPG=(BTPDX2A+I*BTPDY2A)/TotalArea2
         ENDIF

c     Finished computing horizontal derivatives of water level,
c     bathymetric depth and total barotropic pressure (atmos pres, water
c     level, tidal potential)

c     Compute the "sigma" vertical velocity from the "z" vertical velocity 

         DO k=1,NFEN
            SigmaMAOAMB=(Sigma(k)-A)/AMB
            SigmaMBOAMB=(Sigma(k)-B)/AMB
            WSigma(k) = WZ(NH,k) - SigmaMBOAMB*DEtaDT
     *           - REAL(q(NH,k))*(SigmaMBOAMB*DEtaDX+SigmaMAOAMB*DhDX)
     *           - AIMAG(q(NH,k))*(SigmaMBOAMB*DEtaDY+SigmaMAOAMB*DhDY)
         ENDDO


c     Start computing advection and stress terms in the momentum
c     equation at each level in the vertical

         DO k=1,NFEN

c     Compute the vertical advection and vertical stress terms

            IF(k.EQ.1) THEN
               DqDSigmakp1=(q(NH,k+1)-q(NH,k))/(Sigma(k+1)-Sigma(k))
               VAdvec(k)=DqDsigmakp1*(2.d0*WSigma(k)+WSigma(k+1))*Inm(k,3)
     *              /HsOAMB
               VStress(k)=(q(NH,k)*KVnm(k,2)+q(NH,k+1)*KVnm(k,3))
     *              /HsHsOAMBAMB
            ENDIF
            IF((k.GT.1).AND.(k.LT.NFEN)) THEN
               DqDSigmakm1=DqDSigmakp1
               DqDSigmakp1=(q(NH,k+1)-q(NH,k))/(Sigma(k+1)-Sigma(k))
               VAdvec(k)=(DqDSigmakm1*(WSigma(k-1)+2.d0*WSigma(k))*Inm(k,1)
     *              +DqDSigmakp1*(2.d0*WSigma(k)+WSigma(k+1))*Inm(k,3))
     *              /HsOAMB
               VStress(k)=(q(NH,k-1)*KVnm(k,1)+q(NH,k)*KVnm(k,2)
     *              +q(NH,k+1)*KVnm(k,3))/HsHsOAMBAMB
            ENDIF
            IF(k.EQ.NFEN) THEN
               DqDSigmakm1=DqDSigmakp1
               VAdvec(k)=DqDSigmakm1*(WSigma(k-1)+2.d0*WSigma(k))*Inm(k,1)
     *              /HsOAMB
               VStress(k)=(q(NH,k-1)*KVnm(k,1)+q(NH,k)*KVnm(k,2))
     *              /HsHsOAMBAMB
            ENDIF
            VAdvec(k)=NolICA*VAdvec(k)

c     Compute lateral advection and lateral stress terms

            UnDqDX2A=0.d0
            VnDqDY2A=0.d0
            DqDXDPhiDX2A=0.d0
            DqDYDPhiDY2A=0.d0

            N1=NH               !node 1 is always the central node
            qN1=q(N1,k)       

            N2=NEITAB(NH,2)     !operate on 1st neighbor
            qN2=q(N2,k)

            NNFirst=N2          !save these values until end
            qNFirst=qN2

            DO N=3,NNEIGH(NH)   !operate on rest of neighbors
               N3=N2            !shift previously computed values
               qN3=qN2
               N2=NEITAB(NH,N)  !select new neighbor to work on
               qN2=q(N2,k)
               NEle=NeiTabEle(NH,N-2) !element # defined by nodes N1,N2,N3
               IF(NEle.NE.0) THEN !if element exists, compute terms
                  qn=(qN1+qN2+qN3)/3.d0
                  Un=REAL(qn)
                  Vn=AIMAG(qn)
                  a1=X(N3)-X(N2)
                  a2=X(N1)-X(N3)
                  a3=X(N2)-X(N1)
                  b1=Y(N2)-Y(N3)
                  b2=Y(N3)-Y(N1)
                  b3=Y(N1)-Y(N2)
                  UnDqDX2A=UnDqDX2A+Un*(qN1*b1+qN2*b2+qN3*b3)
                  VnDqDY2A=VnDqDY2A+Vn*(qN1*a1+qN2*a2+qN3*a3)
                  DqDXDPhiDX2A=DqDXDPhiDX2A
     *                 +(qN1*b1+qN2*b2+qN3*b3)*b1/Areas(NEle)
                  DqDYDPhiDY2A=DqDYDPhiDY2A
     *                 +(qN1*a1+qN2*a2+qN3*a3)*a1/Areas(NEle)
               ENDIF
            END DO

            N3=N2               !wrap back to beginning to get final contribution
            qN3=qN2
            N2=NNFIRST
            qN2=qNFirst
            NEle=NeiTabEle(NH,NNeigh(NH)-1)
            IF(NEle.NE.0) THEN
               qn=(qN1+qN2+qN3)/3.d0
               Un=real(qn)
               Vn=aimag(qn)
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               UnDqDX2A=UnDqDX2A+Un*(qN1*b1+qN2*b2+qN3*b3)
               VnDqDY2A=VnDqDY2A+Vn*(qN1*a1+qN2*a2+qN3*a3)
               DqDXDPhiDX2A=DqDXDPhiDX2A
     *              +(qN1*b1+qN2*b2+qN3*b3)*b1/Areas(NEle)
               DqDYDPhiDY2A=DqDYDPhiDY2A
     *              +(qN1*a1+qN2*a2+qN3*a3)*a1/Areas(NEle)
            ENDIF

            IF(TotalArea2.EQ.0.) THEN
               LAdvec(k)=(0.d0,0.d0)
               LStress(k)=(0.d0,0.d0)
            ELSE
               LAdvec(k)=NolICA*(UnDqDX2A+VnDqDY2A)/TotalArea2   
               LStress(k)=3.d0*EVM(NH)*(DqDXDPhiDX2A+DqDYDPhiDY2A)
     *              /TotalArea2
            ENDIF

         ENDDO

c     Finished computing advection and stress terms in the momentum
c     equation at each level in the vertical


c     Zero out baroclinic pressure gradient and vertically integrated
c     baroclinic pressure gradient for a barotropic run

         IF(IDEN.EQ.0) THEN
            DO k=1,NFEN
               BCPG(k)=(0.d0,0.d0)
            END DO
            VIDBCPDX(NH)=0.d0
            VIDBCPDY(NH)=0.d0
         ENDIF

c     Start computing baroclinic terms

         IF(IDEN.EQ.1) THEN

c     Start computing baroclinic pressure gradient (computed in level
c     coordinates) at each node in the vertical

            DO k=1,NFEN

               DBCPDX2A=0.d0
               DBCPDY2A=0.d0
               TotalBCPGArea2=0.d0
               N1=NH
               BCPN1=BCP(NH,k)

               Zk=HsOAMB*(Sigma(k)-B)-DP(NH) !determine z corresponding to sigma level k
               N2=NEITAB(NH,2)  !operate on 1st neighbor
               HsN2=DP(N2)+NolIFA*Eta1(N2)
               SigmaNN=B+AMB*(Zk+DP(N2))/HsN2 !equivalent sigma value at neighbor
               CALL ZSURFBUOY(SigmaNN,BCPN2,N2,k) !interp BCP at neighbor
               NNFirst=N2       !save these values until end
               BCPNFirst=BCPN2  !save these values until end

               DO N=3,NNeigh(NH) !operate on rest of neighbors
                  N3=N2         !shift previously computed values
                  BCPN3=BCPN2   !shift previously computed values
                  N2=NeiTab(NH,N) !select new neighbor to work on
                  HsN2=DP(N2)+NolIFA*Eta1(N2)
                  SigmaNN=B+AMB*(Zk+DP(N2))/HsN2 !equivalent sigma value at neighbor
                  CALL ZSURFBUOY(SigmaNN,BCPN2,N2,k) !interp BCP at neighbor
                  NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
                  IF((BCPN2.NE.-999.).AND.(BCPN3.NE.-999.)
     *                 .AND.(NEle.NE.0)) THEN !if all 3 nodes are active, compute bu
                     TotalBCPGArea2=TotalBCPGArea2+Areas(NEle)
                     a1=X(N3)-X(N2)
                     a2=X(N1)-X(N3)
                     a3=X(N2)-X(N1)
                     b1=Y(N2)-Y(N3)
                     b2=Y(N3)-Y(N1)
                     b3=Y(N1)-Y(N2)
                     DBCPDX2A=DBCPDX2A+(BCPN1*b1+BCPN2*b2+BCPN3*b3)
                     DBCPDY2A=DBCPDY2A+(BCPN1*a1+BCPN2*a2+BCPN3*a3)
                  ENDIF
               END DO

               N3=N2            !wrap back to beginning to get final contributio
               N2=NNFirst
               BCPN3=BCPN2
               BCPN2=BCPNFirst
               NEle=NeiTabEle(NH,NNeigh(NH)-1)
               IF((BCPN2.NE.-999.).AND.(BCPN3.NE.-999.)
     *              .AND.(NEle.NE.0)) THEN
                  TotalBCPGArea2=TotalBCPGArea2+Areas(NEle)
                  a1=X(N3)-X(N2)
                  a2=X(N1)-X(N3)
                  a3=X(N2)-X(N1)
                  b1=Y(N2)-Y(N3)
                  b2=Y(N3)-Y(N1)
                  b3=Y(N1)-Y(N2)
                  DBCPDX2A=DBCPDX2A+(BCPN1*b1+BCPN2*b2+BCPN3*b3)
                  DBCPDY2A=DBCPDY2A+(BCPN1*a1+BCPN2*a2+BCPN3*a3)
               ENDIF

               IF(TotalBCPGArea2.EQ.0.) THEN 
                  BCPG(k)=(0.d0,0.d0)
               ELSE
                  BCPG(k)=(DBCPDX2A+I*DBCPDY2A)/TotalBCPGArea2
               ENDIF

            ENDDO

c     Finished computing baroclinic pressure gradient (computed in level
c     coordinates) at each node in the vertical


c     Compute vertically integrated baroclinic pressure gradient for use
c     in the wave equation.  NOTE: For a prognostic model in which the
c     density field evolves in time, this calculation should be done
c     after the new density field is computed.  In this case one would
c     integrate over the vertical first and differentiate second.

            VIBCPG=(0.d0,0.d0)
            DO k=NFEN-1,1,-1
               VIBCPG=VIBCPG+0.5d0*(BCPG(k+1)+BCPG(k))
     *              *(Sigma(k+1)-Sigma(k))
            ENDDO
            VIDBCPDX(NH)=REAL(VIBCPG)*Hsp1OAMB
            VIDBCPDY(NH)=AIMAG(VIBCPG)*Hsp1OAMB

         ENDIF

c     Finished computing baroclinic terms

c     Compute the equivalent linear slip coefficient

         IF(ISlip.EQ.1) KSlip=KP
         IF(ISlip.EQ.2) THEN
            KSlip=KP*ABS(q(NH,1))
            IF(KSlip.LT.1.E-8) KSlip=1.d-8
         ENDIF

c     Set up the RHS forcing vector Fr and LHS matrix in compact storage
c     (Mkm1,Mk,Mkp1)

         CCL = 1.d0+Corif(NH)*IDTAlp1
c         write(*,*) 'CCL=',CCL
         CCR = 1.d0-Corif(NH)*IDT1MAlp1  
         RCL = DTAlp3/Hsp1Hsp1OAMBAMB

         IF(ISlip.EQ.0) THEN    !no slip bottom boundary condition
            Fr(1)   = (0.d0,0.d0)
            Mkm1(1) = (0.d0,0.d0)
            Mk(1)   = (1.d0,-1.d0) !note: -I*IV=V
            Mkp1(1) = (0.d0,0.d0)
         ELSE                   ! slip bottom boundary condition
            Fr(1) = (CCR*q(NH,1)
     *           -DelT*(LAdvec(1)  +LStress(1)  +BCPG(1)))*Inm(1,2)
     *           + (CCR*q(NH,2)
     *           -DelT*(LAdvec(2)  +LStress(2)  +BCPG(2)))*Inm(1,3)
     *           - DelT*(VAdvec(1)+BTPG*LVn(1))-DT1MAlp3*VStress(1)     
     *           - q(NH,1)*DT1MAlp2*KSlip/HsOAMB     
            Mkm1(1) = (0.d0,0.d0)
            Mk(1)   = CCL*Inm(1,2) + RCL*KVnm(1,2) + DTAlp2*KSlip/Hsp1OAMB
            Mkp1(1) = CCL*Inm(1,3) + RCL*KVnm(1,3)
         ENDIF

         DO k=2,NFEN-1
            Fr(k) = (CCR*q(NH,k-1)
     *           -DelT*(LAdvec(k-1)+LStress(k-1)+BCPG(k-1)))*Inm(k,1)
     *           + (CCR*q(NH,k)
     *           -DelT*(LAdvec(k)  +LStress(k)  +BCPG(k)  ))*Inm(k,2)
     *           + (CCR*q(NH,k+1)
     *           -DelT*(LAdvec(k+1)+LStress(k+1)+BCPG(k+1)))*Inm(k,3)
     *           - DelT*(VAdvec(k)+BTPG*LVn(k))-DT1MAlp3*VStress(k)
            Mkm1(k) = CCL*Inm(k,1) + RCL*KVnm(k,1)
            Mk(k)   = CCL*Inm(k,2) + RCL*KVnm(k,2)
            Mkp1(k) = CCL*Inm(k,3) + RCL*KVnm(k,3)
         END DO

         Fr(NFEN) = (CCR*q(NH,k-1)
     *        -DelT*(LAdvec(k-1)+LStress(k-1)+BCPG(k-1)))*Inm(k,1)
     *        + (CCR*q(NH,k)
     *        -DelT*(LAdvec(k)  +LStress(k)  +BCPG(k)  ))*Inm(k,2)
     *        - DelT*(VAdvec(k)+BTPG*LVn(k))-DT1MAlp3*VStress(k)
     *        + DelT*0.5d0*((TauSX2(NH)+I*TauSY2(NH))/Hsp1OAMB
     *        +(TauSX1(NH)+I*TauSY1(NH))/HsOAMB)
         Mkm1(NFEN) = CCL*Inm(NFEN,1) + RCL*KVnm(NFEN,1)
         Mk(NFEN)   = CCL*Inm(NFEN,2) + RCL*KVnm(NFEN,2)
         Mkp1(NFEN) = (0.d0,0.d0)

c     Start section to modify equations depending on normal flux
c     boundary condition
c     0 <= LBcodeI <= 10, essential normal flux and free tangential slip
c     this b.c. is taken care of in the code section below
c     10 <= LBcodeI <= 19, essential normal flux and zero tangential slip
c     this b.c. is taken care of above
c     20 <= LBcodeI <= 29, natural normal flux and free tangential slip
c     this b.c. requires on manipulation of momentum eqns.  Do nothing!

         LBP=LBArray_Pointer(NH)
         IF(LBP.GT.0) THEN      !flux boundary
            IF((LBCODEI(LBP).GE. 0).AND.(LBCODEI(LBP).LE. 9)) THEN
               SLBP=SIII(LBP)
               CLBP=CSII(LBP)
               VelNorm=-QNormsp1(LBP)/Hsp1                              

               Mkm1(1)    =(0.d0,0.d0)
               Auv1k      =Real(Mk(1))
               Auv2k      =AImag(Mk(1))
               Auv1kstar  =Auv1k*SLBP
               Auv2kstar  =Auv1k*CLBP
               Mk(1)      =Auv1kstar+I*Auv2kstar
               Auv1kp1    =Real(Mkp1(1))
               Auv2kp1    =AImag(Mkp1(1))
               Auv1kp1star=Auv1kp1*SLBP
               Auv2kp1star=Auv1kp1*CLBP
               Mkp1(1)    =Auv1kp1star+I*Auv2kp1star
               Frstar     =Real(Fr(1))*SLBP-AImag(Fr(1))*CLBP
     *              +  (Auv2k+Auv2kp1)*VelNorm 
     *              +I*(Auv1k+Auv1kp1)*VelNorm
               Fr(1)      =Frstar
               DO k=2,NFEN-1
                  Auv1km1    =Real(Mkm1(k))
                  Auv2km1    =AImag(Mkm1(k))
                  Auv1km1star=Auv1km1*SLBP
                  Auv2km1star=Auv1km1*CLBP
                  Mkm1(k)    =Auv1km1star+I*Auv2km1star
                  Auv1k      =Real(Mk(k))
                  Auv2k      =AImag(Mk(k))
                  Auv1kstar  =Auv1k*SLBP
                  Auv2kstar  =Auv1k*CLBP
                  Mk(k)      =Auv1kstar+I*Auv2kstar
                  Auv1kp1    =Real(Mkp1(k))
                  Auv2kp1    =AImag(Mkp1(k))
                  Auv1kp1star=Auv1kp1*SLBP
                  Auv2kp1star=Auv1kp1*CLBP
                  Mkp1(k)    =Auv1kp1star+I*Auv2kp1star
                  Frstar     =Real(Fr(k))*SLBP-AImag(Fr(k))*CLBP
     *                 +  (Auv2km1+Auv2k+Auv2kp1)*VelNorm 
     *                 +I*(Auv1km1+Auv1k+Auv1kp1)*VelNorm
                  Fr(k)      =Frstar
               END DO
               Auv1km1    =Real(Mkm1(NFEN))
               Auv2km1    =AImag(Mkm1(NFEN))
               Auv1km1star=Auv1km1*SLBP
               Auv2km1star=Auv1km1*CLBP
               Mkm1(NFEN) =Auv1km1star+I*Auv2km1star
               Auv1k      =Real(Mk(NFEN))
               Auv2k      =AImag(Mk(NFEN))
               Auv1kstar  =Auv1k*SLBP
               Auv2kstar  =Auv1k*CLBP
               Mk(NFEN)   =Auv1kstar+I*Auv2kstar
               Mkp1(NFEN) =(0.d0,0.d0)
               Frstar     =Real(Fr(NFEN))*SLBP-AImag(Fr(NFEN))*CLBP
     *              +  (Auv2km1+Auv2k)*VelNorm 
     *              +I*(Auv1km1+Auv1k)*VelNorm
               Fr(NFEN)   =Frstar
            ENDIF
         ENDIF

c     Finished section to modify equations depending on normal flux
c     boundary condition
         
c     Decompose and solve the system

 999     CALL TRIDIAG(Mkm1,Mk,Mkp1,Fr,Gamma,NFEN)

c     Compute the depth averaged velocity and bottom stress

         VIVel = (0.d0,0.d0)
         DO k=1,NFEN
            VIVel = VIVel + Gamma(k)*LVn(k)
         END DO
         VIVel = VIVel/amb
         UBar(NH) = REAL(VIVel)
         VBar(NH) = AIMAG(VIVel)

         IF(ISlip.EQ.0) THEN
            DUDS = (Gamma(2)-Gamma(1))/(Sigma(2)-Sigma(1))
            TauBX(NH) = EVTot(1)*REAL(DUDS)
            TauBY(NH) = EVTot(1)*AIMAG(DUDS)
         ENDIF
         IF(ISlip.NE.0) THEN
            TauBX(NH) = KSlip*REAL(GAMMA(1))
            TauBY(NH) = KSlip*AIMAG(GAMMA(1))
         ENDIF

c     Compute the dispersion terms
         
         DUU(NH) = 0.d0
         DUV(NH) = 0.d0
         DVV(NH) = 0.d0
         IF(NolICA.EQ.1) THEN
            CALL VSDISP (IT,NH,Hsp1,UBar(NH),VBar(NH),
     *           DUU(NH),DUV(NH),DVV(NH))
         ENDIF

c     Save the horizontal velocity and Eddy Viscosity solutions

         DO k=1,NFEN
            q(NH,k) = Gamma(k)
            EV(NH,k)=EVTot(k)
         END DO
         
      ENDDO

C     Finish loop over horizontal nodes to compute the horizontal velocity

C*************************************************************************************
C     Update recently computed quantities on ghost nodes
C     



C*************************************************************************************
C     Compute "z" vertical velocity     

C     
C     Loop over each horizontal node to compute the "z" version of the
C     vertical velocity
C     
      DO NH=1,NP

c     Compute time derivative of water surface position

         DEtaDT=(Eta2(NH)-Eta1(NH))/DelT

c     Compute horizontal derivatives of water surface position,
c     bathymetric depth and horizontal velocity Note: TotalArea2 = 2X
c     total elemental area surrounding a node

         DO k=1,NFEN
            DqDX2A(k)=(0.d0,0.d0)
            DqDY2A(k)=(0.d0,0.d0)
            DUDX(k)=0.d0
            DVDY(k)=0.d0
         ENDDO
         DEtaDX=0.d0
         DEtaDY=0.d0
         DhDX=0.d0
         DhDY=0.d0
         DEtaDX2A=0.d0
         DhDX2A=0.d0
         DEtaDY2A=0.d0
         DhDY2A=0.d0
         TotalArea2=0.d0

         N1=NH
         EtaN1=NolIFA*Eta2(N1)
         hN1=DP(N1)

         N2=NeiTab(NH,2)        !operate on 1st neighbor
         EtaN2=NolIFA*Eta2(N2)
         hN2=DP(N2)

         NNFirst=N2             !save these values until end
         EtaNFirst=EtaN2
         hNFirst=hN2

         DO N=3,NNeigh(NH)      !operate on rest of neighbors
            N3=N2               !shift previously computed values
            hN3=hN2             !shift previously computed values
            EtaN3=EtaN2
            N2=NeiTab(NH,N)     !select new neighbor to work on
            EtaN2=NolIFA*Eta2(N2)
            hN2=DP(N2)
            NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
            IF(NEle.NE.0) THEN  !if element is active, compute velocity grads
               TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
               DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
               DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
               DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
               DO k=1,NFEN
                  qN1=q(N1,k)
                  qN2=q(N2,k)
                  qN3=q(N3,k)
                  DqDX2A(k)=DqDX2A(k)+(qN1*b1+qN2*b2+qN3*b3)
                  DqDY2A(k)=DqDY2A(k)+(qN1*a1+qN2*a2+qN3*a3)
               ENDDO
            ENDIF
         ENDDO

         N3=N2                  !wrap back to beginning to get final contribution
         hN3=hN2
         EtaN3=EtaN2
         N2=NNFirst
         hN2=hNFirst
         EtaN2=EtaNFirst
         NEle=NeiTabEle(NH,NNeigh(NH)-1)
         IF(NEle.NE.0) THEN
            TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
            a1=X(N3)-X(N2)
            a2=X(N1)-X(N3)
            a3=X(N2)-X(N1)
            b1=Y(N2)-Y(N3)
            b2=Y(N3)-Y(N1)
            b3=Y(N1)-Y(N2)
            DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
            DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
            DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
            DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
            DO k=1,NFEN
               qN1=q(N1,k)
               qN2=q(N2,k)
               qN3=q(N3,k)
               DqDX2A(k)=DqDX2A(k)+(qN1*b1+qN2*b2+qN3*b3)
               DqDY2A(k)=DqDY2A(k)+(qN1*a1+qN2*a2+qN3*a3)
            ENDDO
         ENDIF

         IF(TotalArea2.NE.0.) THEN
            DhDX=DhDX2A/TotalArea2
            DhDY=DhDY2A/TotalArea2
            DEtaDX=DEtaDX2A/TotalArea2
            DEtaDY=DEtaDY2A/TotalArea2
            DO k=1,NFEN
               DUDX(k)=REAL(DqDX2A(k))/TotalArea2
               DVDY(k)=AIMAG(DqDY2A(k))/TotalArea2
            ENDDO
         ENDIF

c     Evaluate the "z" vertical velocity

         WZ(NH,1)=-REAL(q(NH,1))*DhDX-AIMAG(q(NH,1))*DhDY

         DO k=2,NFEN
            DelSigO2=(Sigma(k)-Sigma(k-1))/2.d0
            SigAvgMAOAMB=((Sigma(k)+Sigma(k-1))/2.d0 - A)/AMB
            DelU=REAL(q(NH,k)-q(NH,k-1))
            DelV=AIMAG(q(NH,k)-q(NH,k-1))
            WZ(NH,k)=WZ(NH,k-1)
     *           - DelSigO2*Hsp1OAMB*(DUDX(k)+DVDY(k)+DUDX(k-1)+DVDY(k-1))
     *           + (DEtaDX+SigAvgMAOAMB*(DhDX+DEtaDX))*DelU
     *           + (DEtaDY+SigAvgMAOAMB*(DhDY+DEtaDY))*DelV
         ENDDO

c     Correct this using Adjoint method        

         Wf=0.d0                !This value should match surface B.C. exactly
         Hsp1= DP(NH)+NolIFA*Eta2(NH) !Total depth at present (s+1) timestep
         WfOHH=Wf/(Hsp1*Hsp1)
         WZSurfBC=DEtaDT+REAL(q(NH,NFEN))*DEtaDX+AIMAG(q(NH,NFEN))*DEtaDY
         WZSurf=WZ(NH,NFEN)

         DO k=1,NFEN
            WZCorrection=(WZSurfBC-WZSurf)*(WfOHH+(Sigma(k)-b)/AMB)
     *           /(2.d0*WfOHH+1)
            WZ(NH,k)=WZ(NH,k)+WZCorrection
         ENDDO

C     
C     End loop over horizontal nodes to compute vertical velocity
C     
      ENDDO

C*************************************************************************************
C     Update vertical velocity on ghost nodes



C*************************************************************************************
C     Compute new density, temperature, salinity fields
c     Compute vertically integrated baroclinic pressure gradient



C*************************************************************************************
C     Write Output

C     
C     Loop over horizontal nodes to write output
C     
      DO NH=1,NP

 1104    FORMAT(9X,I6,4X,32000(E12.6,2X))

c     Station density, temperature, salinity output (Unit 41)

         IF((I3DSD.GT.0).AND.(NSSD.EQ.0)) THEN
            DO NN=1,NHN3DSD
               IF(NH.EQ.ISDHOUT(NN)) THEN
                  IF(I3DSD.EQ.1) WRITE(41,1104) NH,(SIGT(NH,k),TEMP(NH,k),
     *                 SAL(NH,k),k=1,NFEN) !ASCII
                  IF(I3DSD.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(41,REC=ISDREC+1) SIGT(NH,k)
                        WRITE(41,REC=ISDREC+2) TEMP(NH,k)
                        WRITE(41,REC=ISDREC+3) SAL(NH,k)
                        ISDREC=ISDREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Station velocity output (Unit 42)

         IF((I3DSV.GT.0).AND.(NSSV.EQ.0)) THEN
            DO NN=1,NHN3DSV
               IF(NH.EQ.ISVHOUT(NN)) THEN
                  IF(I3DSV.EQ.1) WRITE(42,1104) NH,(REAL(q(NH,k)),
     *                 AIMAG(q(NH,k)),
     *                 WZ(NH,k),k=1,NFEN) !ASCII
                  IF(I3DSV.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(42,REC=ISVREC+1) REAL(q(NH,k))
                        WRITE(42,REC=ISVREC+2) AIMAG(q(NH,k))
                        WRITE(42,REC=ISVREC+3) WZ(NH,k)
                        ISVREC=ISVREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Station turbulence output (Unit 43)

         IF((I3DST.GT.0).AND.(NSST.EQ.0)) THEN
            DO NN=1,NHN3DST
               IF(NH.EQ.ISTHOUT(NN)) THEN
                  IF(I3DST.EQ.1) WRITE(43,1104) NH,(q20(NH,k),l(NH,k),
     *                 EV(NH,k),k=1,NFEN) !ASCII
                  IF(I3DST.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(43,REC=ISTREC+1) q20(NH,k)
                        WRITE(43,REC=ISTREC+2) l(NH,k)
                        WRITE(43,REC=ISTREC+3) EV(NH,k)
                        ISTREC=ISTREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Global density, temperature, salinity output (Unit 44)

         IF((I3DGD.GT.0).AND.(NSGD.EQ.0)) THEN !ASCII
            IF(I3DGD.EQ.1) WRITE(44,1104) NH,(SIGT(NH,k),TEMP(NH,k),
     *           SAL(NH,k),k=1,NFEN)
            IF(I3DGD.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(44,REC=IGDREC+1) SIGT(NH,k)
                  WRITE(44,REC=IGDREC+2) TEMP(NH,k)
                  WRITE(44,REC=IGDREC+3) SAL(NH,k)
                  IGDREC=IGDREC+3
               END DO
            ENDIF
         ENDIF

c     Global velocity output (Unit 45)

         IF((I3DGV.GT.0).AND.(NSGV.EQ.0)) THEN !ASCII
            IF(I3DGV.EQ.1) WRITE(45,1104) NH,(REAL(q(NH,k)),AIMAG(q(NH,k)),
     *           WZ(NH,k),k=1,NFEN)
            IF(I3DGV.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(45,REC=IGVREC+1) REAL(q(NH,k))
                  WRITE(45,REC=IGVREC+2) AIMAG(q(NH,k))
                  WRITE(45,REC=IGVREC+3) WZ(NH,k)
                  IGVREC=IGVREC+3
               END DO
            ENDIF
         ENDIF

c     Global turbulence output (Unit 46)

         IF((I3DGT.GT.0).AND.(NSGT.EQ.0)) THEN !ASCII
            IF(I3DGT.EQ.1) WRITE(46,1104) NH,(q20(NH,k),l(NH,k),
     *           EV(NH,k),k=1,NFEN)
            IF(I3DGT.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(46,REC=IGTREC+1) q20(NH,k)
                  WRITE(46,REC=IGTREC+2) l(NH,k)
                  WRITE(46,REC=IGTREC+3) EV(NH,k)
                  IGTREC=IGTREC+3
               END DO
            ENDIF
         ENDIF

C     
C     End loop over horizontal nodes to write output
C     
      ENDDO

C     RETURN TO THE 2-D MODEL TO COMPUTE H AT NEXT TIME STEP

      RETURN
      END


c***********************************************************************
c     *
C     SUBROUTINE TO SET UP THE VERTICAL FINITE ELEMENT GRID             *
c     *
c     2/22/93                                     *
c***********************************************************************
c     
      SUBROUTINE FEGRIDS(IGC,H)
      USE GLOBAL_3DVS, ONLY : SZ,DIRNAME,NFEN,SIGMA,A,B,Z0B,Z0S,NSCREEN
      IMPLICIT NONE
      INTEGER :: IGC,N,NODE,NFEN2,IANS,NUM,I
      REAL :: H,DETA,SSTAR,DENOM,SIG0,SS,SB,RP,AVAL,EPS

 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     *     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')
      
      IF((IGC.LT.0).OR.(IGC.GT.6)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,410)
         ENDIF
         WRITE(16,350)
         WRITE(16,410)
 410     FORMAT(/,2X,'    IGC MUST BE 0,1,2,3 OR 4')
         STOP
      ENDIF
      IF(NFEN.LT.0) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,412)
         ENDIF
         WRITE(16,350)
         WRITE(16,412)
 412     FORMAT(/,2X,'    NFEN MUST BE > 0')
         STOP
      ENDIF

c     
c     igc = 0 - Read in grid from UNIT 12
c     
      if(igc.eq.0) then
         OPEN(10,FILE=DIRNAME//'/'//'fort.10')
         do n=1,nfen
            write(*,901) n
 901        format(1x,'input node#',i3,' and sigma(node#)')
            READ(10,*) node,sigma(node)
         end do
         close(10)
         if(sigma(1).ne.b) then
            write(*,1011)
            write(*,1012)
            write(16,1011)
            write(16,1012)
 1011       format(' Error reading in the vertical finite element grid')
 1012       format(' The first point in the finite element grid ',
     *           'must = b - run terminated'/)
            stop
         endif
         if(sigma(nfen).ne.a) then
            write(*,1011)
            write(*,1013)
            write(16,1011)
            write(16,1013)
 1013       format(' The last point in the finite element grid ',
     *           'must = a - run terminated'/)
            stop
         endif
      endif

c     
c     igc = 1 - Evenly spaced grid
c     
      if(igc.eq.1) then
         if(nfen.le.1) nfen = 2
         deta = (a-b)/(nfen-1)
         sigma(1) = b
         do n=2,nfen-1
            sigma(n) = b + deta*(n-1)
         end do
         nfen2 = nfen/2
         if(2*nfen2.ne.nfen) sigma(nfen2+1) = 0.
         sigma(nfen) = a
      endif

c     
c     igc = 2 - logarithmically grid  (after Davies 1991)
c     
      if(igc.eq.2) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So = ',Z0B,' ***********'
         Sb = Z0B
c     write(*,*) '********** Enter So from the keyboard ***********'
c     write(*,*) '   '
c     read(*,*) Sb
         if(nfen.le.1) nfen = 2
         deta = 1./(nfen-1)
         sigma(1) = b
         do n=2,nfen-1
            sigma(n) = b + (a-b)*Sb/H*(((H+Sb)/Sb)**(deta*(n-1))-1.)
         enddo
         sigma(nfen) = a
      endif

c     
c     igc = 3 - log-linear grid  (after Davies 1991)
c     
      if(igc.eq.3) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So = ',Z0B,' ***********'
         write(*,*) '********** S* = ',-H-Sb,' ***********'
         Sb = Z0B
         Sstar = -H-Sb
         write(*,*) '******** Enter So from the keyboard *******'
         write(*,*) '   '
         read(*,*) Sb
         write(*,*) '******** Enter S* from the keyboard *******'
         write(*,*) '   '
         read(*,*) Sstar
         if(nfen.le.1) nfen = 2
         deta = 1./(nfen-1)
         denom = log((H+Sb)/Sb) + H/Sstar
         sigma(1) = b
         do n=2,nfen-1
            sig0 = b + (a-b)*deta*(n-1)
 10         sigma(n)= b - (a-b)*Sstar/H*(log(1.+H/Sb*(sig0-b)/(a-b))
     *           -denom*deta*(n-1))
            if(abs(sigma(n)-sig0).ge.1d-8)then
               sig0 = sigma(n)
               goto 10
            endif
         enddo
         sigma(nfen) = a
      endif
c     
c     igc = 4 - Double logarithmic grid
c     
      if(igc.eq.4) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So bottom = ',Z0B,' ***********'
         Sb = Z0B
         write(*,*) '********** So surface = ',Z0S,' ***********'
         Ss = Z0S
c     
c     write(*,*) '******* Enter So bottom from the keyboard ********'
c     write(*,*) '   '
c     read(*,*) Sb
c     write(*,*) '******* Enter So surface from the keyboard *******'
c     write(*,*) '   '
c     read(*,*) Ss
c     
         write(*,*) '   '
         if(mod(nfen,2).eq.0) then
            write(*,*) '**********************************WARNING*****',
     *           '******************************'
            write(*,*) '**** You have specified a double log grid with',
     *           ' an even number of nodes. ****'
            write(*,*) '**** Much better results are obtained using an',
     *           ' an odd number of nodes.  ****'
            write(*,*) '**** Do you want to terminate now or continue?',
     *           '  0=Terminate/1=continue. ****'
            write(*,*) '  '
            read(*,*) ians
            if(ians.ne.1) stop
            num = nfen/2
         else
            num=(nfen-1)/2
            sigma(num+1)=(a+b)/2.
         endif
         deta = 2./(nfen-1)
         sigma(1) = b
         sigma(nfen) = a
         do n=2,num
            sigma(n) = b + 0.5*(a-b)*Sb/H*(((H+Sb)/Sb)**(deta*(n-1))-1.)
            sigma(nfen+1-n) = a - 0.5*(a-b)*Ss/H*(((H+Ss)/Ss)**
     *           (deta*(n-1))-1.)
         enddo
      endif
c     
c     igc = 5 - "P-grid" after Fortunato and Baptista (IJNMF submitted 12/1994)
c     optimal p value of 0.25 may be used as default for tidal flow problems
c     note: p = 1 - uniform, p<1 makes fine grid near bottom,p>1 makes
c     fine grid near sfc
c     sigma converted to range from -1 to 1 in ADCIRC        
c     
      if(igc.eq.5) then
         if(nfen.le.1) nfen = 2
         write(*,*)
         write(*,*)' Enter P value for P - grid'
         write(*,*)
         read(*,*)rp
         do i = 1,nfen
            sigma(i) = -1. + 2.*(1.+((1.-i)/(1.-nfen))**(1./rp) - 1.0)
         end do             
      endif
c     
c     igc = 6 - "sine grid" after Naimie,Lynch
c     Value of A determines stretching at ends, check in unit 18
c     sigma converted to range from -1 to 1 in ADCIRC        
c     
      if(igc.eq.6) then
         if(nfen.le.1) nfen = 2
         write(*,*)
         write(*,*)' Enter A value for sine grid'
         write(*,*)
         read(*,*)aval
         do i = 1,nfen
            eps = float(i-1)/float(nfen-1)
            sigma(i) = -1. + (2./H)*(eps*H-aval*sin(2.*3.14159*eps))
         end do             
      endif

C...  
C...  Write out vertical grid in fort.16 file
C...  
      write(16,1000)
 1000 format(//,5X,'Vertical Coordinate Information')
      write(16,1001) 
 1001 format(/,5X,'V. Node #',5X,'V. Position',/)
      do n = 1, nfen
         write(16,*) n,sigma(n)
      end do


      RETURN
      END

c******************************************************************************
c     Subroutine to compute the eddy viscosity profile.                       *
c                                                                             *
c  ievc, evmin, evcon - E.V. code, E.V. minimum value and E.V. constant       *
c                                                                             *
c        NOTE: evcon only used for some of the E.V. formulations as           *
c                  discussed below.                                           *
c        NOTE: In cases where EV is specified to vary linearly over the       *
c              lower 20% of the water column, it actually varies linearly     *
c              with a constant slope up to the vertical FE grid node that is  *
c              less than or equal to the 20% location.  The value is constant *
c              as specified at all FE grid nodes above the 20% location.      *
c              The E.V. above and below the 20% level is joined by one        *
c              additional linearly varying segment.                           *
c        NOTE: The E.V. is constrained to always be greater than or equal to  *
c              EVMIN as specified in the UNIT 15 file.                        *
c                                                                             *               
c        ievc=0-9, EV constant in time & horizontal space                     *
c             0 - EV read in from UNIT 12 (may vary vertically) - EVCON is    *
c                    not used                                                 *
c             1 - EV = EVCON                                                  *
c                                                                             *
c        ievc=10-19 EV proportional to omega*h*h  (Lynch and Officer (1986)   *
c                                              Lynch and Werner (1987, 1991)) *
c             10 - EV = omega*h*h/10 over the entire water column             *
c             11 - EV = omega*h*h/1000 at bottom                              *
c                       varies linear over lower 20% of wc                    *
c                     = omega*h*h/10 in upper 80% of w.c.                     *
c            NOTE:For this EV formulation, evcon is not used and omega is     *
c                  hardwired for a 12.42 hour tide.                           *
c                                                                             *
c        ievc=20-29 EV proportional to kappa U* z                             *
c             20 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z over entire water column                      *
c             21 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z in lower 20% of water col                     *
c                     = 0.082U*h in upper 80% of water col                    *
c            WHERE: U* is the friction velocity                               *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             * 
c        ievc=30-39, EV proportional to Uh (Davies 1990)                      *
c             30 - EV = 0.025|U|h/9.001 over entire water column              *
c             31 - EV = evcon|U|h over entire water column                    *
c             32 - EV = 0.025|U|h/9.001 in upper 80% of wc                    *
c                     = 0.000025h|U|/9.001 at bottom                          *
c                       varies linear over lower 20% of wc                    *
c             33 - EV = evcon|U|h in upper 80% of wc                          *
c                     = evcon|U|h/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=31,33 *
c                                                                             *
c        ievc=40-49, EV proportional to U*U (Davies 1990)                     *
c             40 - EV = 2|UU|/9.001 over entire water column                  *
c             41 - EV = evcon|UU| over entire water column                    *
c             42 - EV = 2|UU|/9.001 in upper 80% of wc                        *
c                     = 0.002|UU|/9.001 at bottom                             *
c                       varies linear over lower 20% of wc                    *
c             43 - EV = evcon|UU| in upper 80% of wc                          *
c                     = evcon|UU|/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=41,43 *
c                                                                             *
c        ievc=50, EV computed from Mellor-Yamada L2.5 closure                 *
c            NOTE: For this EV formulation, evcon is not used.                *
C                                                                             *
C                               8/24/99                                       *
C******************************************************************************
C
      SUBROUTINE EDDYVIS(H,UBAR,VBAR,TAUSX,TAUSY,TAUBX,TAUBY,
     *     istart,NODE,DELT,IT)

      USE GLOBAL_3DVS, ONLY : SZ,DIRNAME,IEVC,EVMIN,EVCON,EVTOT,SIGMA,
     *     NFEN,Z0B,Z0S,A,B,AMB,NSCREEN,IDIAG,NWS
      REAL(8) :: H
      REAL(SZ) :: UBAR,VBAR,TAUSX,TAUSY,TAUBX,TAUBY,DELT

 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     *     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')

      RKAPPA = 0.41

C...  
C...  IEVC=0 READ IN FROM UNIT 12 ON THE FIRST TIME STEP
C...  
      IF((IEVC.EQ.0).and.(istart.eq.1)) THEN
         OPEN(12,FILE=DIRNAME//'/'//'fort.12')
         READ(12,*) NIEVN
         IF(NIEVN.NE.NFEN) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(*,350)
               WRITE(*,412)
            ENDIF
            WRITE(16,350)
            WRITE(16,412)
 412        FORMAT(/,2X,'    THE NUMBER OF VALUES IN THE UNIT 12 E.V. ',
     *           'FILE MUST = NUMBER OF NODES IN VERTICAL GRID')
            STOP
         ENDIF
         READ(12,*) SIGEVI,EVTOT(1)
         IF(SIGEVI.NE.b) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,413) SIGEVI,b
            ENDIF
            WRITE(16,350)
            WRITE(16,413) SIGEVI,b
 413        FORMAT(/,2X,'THE BOTTOM ELEVATION IN THE EV= ',E14.8,
     *           '.  THIS MUST = b = ',E14.8)
            STOP
         ENDIF
         DO N=2,NIEVN-1
            READ(12,*) SIGEVI,EVTOT(N)
         ENDDO
         READ(12,*) SIGEVI,EVTOT(NIEVN)
         IF(SIGEVI.NE.a) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,414) SIGEVI,a
            ENDIF
            WRITE(16,350)
            WRITE(16,414) SIGEVI,a
 414        FORMAT(/,2X,'THE TOP ELEVATION IN THE EV= ',E14.8,
     *           '.  THIS MUST = a = ',E14.8)
            STOP
         ENDIF
         CLOSE (12)
         WRITE(16,*) ' Vertical E.V. read in from UNIT 12'
      ENDIF

      IF((IEVC.eq.0).and.(istart.gt.1)) GOTO 100

C...  
C...  IEVC=1 SET EV = EVCON ON THE FIRST TIME STEP
C     .

      IF((IEVC.eq.1).and.(istart.eq.1)) THEN
         DO J=1,NFEN
            EVTOT(J)=EVCON
         ENDDO
      ENDIF

      IF((IEVC.eq.1).and.(istart.gt.1)) GOTO 100
      
C...  
C...  OMEGA*H*H formulation FOLLOWING
C...  LYNCH AND OFFICER (1986), LYNCH AND WERNER (1987, 1991)
C...  
      IF(IEVC.EQ.10) THEN
         OMEGA=0.0000141D0
         EVBASE=OMEGA*H*H
         IF(EVBASE.LT.EVMIN) EVBASE=EVMIN          
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.11) THEN
         OMEGA=0.0000141D0
         EVBASE=OMEGA*H*H
         EVTOT(1)=EVBASE/100.D0
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-b*SLOPE
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  KAPPA USTAR Z FORMULATION
C...  
      IF(IEVC.EQ.20) THEN
         USTARB=SQRT(SQRT(TAUBX*TAUBX+TAUBY*TAUBY))
         EVTOT(1)=RKAPPA*USTARB*Z0B
         EVBASE=RKAPPA*USTARB*H
         IF(EVBASE.LT.EVTOT(1)) EVBASE=EVTOT(1)
         SLOPE=(EVBASE-EVTOT(1))/amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J) !=EVTOT(1)+SLOPE*(SIGMA(J)-b)
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.21) THEN
         USTARB=SQRT(SQRT(TAUBX*TAUBX+TAUBY*TAUBY))
         EVTOT(1)=RKAPPA*USTARB*Z0B
         EVBASE=RKAPPA*USTARB*H*0.2D0
         IF(EVBASE.LT.EVTOT(1)) EVBASE=EVTOT(1)
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  H UAVG FORMULATION FOLLOWING DAVIES (1990) + [EQ. (33)]
C...  
      IF(IEVC.EQ.30) THEN
         UAVMAG=SQRT(UBAR*UBAR+VBAR*VBAR)
         EVBASE=0.025*H*UAVMAG/9.001D0
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.31) THEN
         UAVMAG=SQRT(UBAR*UBAR+VBAR*VBAR)
         EVBASE = EVCON*H*UAVMAG
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.32) THEN
         UAVMAG=SQRT(UBAR*UBAR+VBAR*VBAR)
         EVBASE = 0.025*H*UAVMAG/9.001D0
         EVTOT(1) = EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.33) THEN
         UAVMAG=SQRT(UBAR*UBAR+VBAR*VBAR)
         EVBASE=EVCON*H*UAVMAG
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  UAVG SQUARED FORMULATION FOLLOWING DAVIES (1990) + [EQ. (34)]
C...  
      IF(IEVC.EQ.40) THEN
         UAVMAGS=UBAR*UBAR+VBAR*VBAR
         EVBASE=2.D0*UAVMAGS/9.001D0
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.41) THEN
         UAVMAGS=UBAR*UBAR+VBAR*VBAR
         EVBASE=EVCON*UAVMAGS
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.42) THEN
         UAVMAGS=UBAR*UBAR+VBAR*VBAR
         EVBASE=2.D0*H*UAVMAGS/9.001D0
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.43) THEN
         UAVMAGS=UBAR*UBAR+VBAR*VBAR
         EVBASE=EVCON*UAVMAGS
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  MELLOR-YAMADA LEVEL 2.5 CLOSURE
C...  
      IF(IEVC.EQ.50) THEN
         CALL TURB(NODE,H,DELT,TAUBX,TAUBY,TAUSX,TAUSY)
         GOTO 100
      ENDIF
      
C...  
C...  ONCE EDDY VISCOSITY IS COMPUTED
C...  


 100  CONTINUE

C...  
C...  CHECK SO THAT EDDY VISCOSITY NEVER GETS BELOW MINIMUM VALUE
C...  
      DO J=1,NFEN
         IF(EVTOT(J).LT.EVMIN) THEN
            EVTOT(J)=EVMIN
            IF(IDIAG.NE.0) THEN
               IF(NSCREEN.NE.0) WRITE(6,410) IT,NODE,J
               WRITE(16,410) IT,NODE,J
 410           FORMAT(' ****** WARNING FROM SUBROUTINE EDDYVISC ******',
     *              ' E.V. RESET TO MIN E.V. @ TIME STEP',I8,
     *              ' HORIZ NODE = ',I8,' VERT NODE = ',I3)
            ENDIF
         ENDIF
      ENDDO

C...  
C...  PRINT DETAILED DIAGNOSTICS IF DESIRED
C...  
      IF(IDIAG.EQ.2) THEN       !WRITE GENERAL DIAGNOSTIC OUTPUT
         WRITE(2,*) 'SUBROUTINE EDDYVIS, vert eddy visc node', node
         DO J=1,NFEN
            WRITE(2,420) J, EVTOT(J)
 420        FORMAT(2X,'EVTOT(',I4,')=',E15.8)
         ENDDO
      ENDIF

C...  
C...  RETURN
C...  
      RETURN
      END


C***********************************************************************
C                                                                      *
C   Solver for a vector U of length nfen for a tridiagonal system of   *
C          equations with the form                                     *
C                                                                      *
C    **                               **   **    **   **    **         *
C    * Bn   An                         *   *  Un  *   *  Rn  *         *
C    *                                 *   *      *   *      *         *
C    * Cn-1 Bn-1 An-1                  *   * Un-1 *   * Rn-1 *         *
C    *                                 *   *      *   *      *         *
C    *      Cn-2 Bn-2 An-2             *   * Un-2 *   * Rn-2 *         *
C    *                                 *   *      *   *      *         *
C    *             .......             *   * .... *   * .... *         *
C    *                                 *   *      *   *      *         *
C    *                  C3 B3 A3       *   *  U3  * = *  R3  *         *
C    *                                 *   *      *   *      *         *
C    *                     C2 B2 A2    *   *  U2  *   *  R2  *         *
C    *                                 *   *      *   *      *         *
C    *                        C1 B1    *   *  U1  *   *  R1  *         *
C    **                               **   **    **   **    **         *
C                                                                      *
C      A, B, C, U, R are adjustable size arrays                        *
C                                                                      *
C      U(1 - nfen) are the complex velocities from bottom to top       *
C                                                                      *
C                                                                      *
C                         R.L.  11/18/94                               *
C***********************************************************************
C
      SUBROUTINE TRIDIAG(A,B,C,R,U,nfen)
      IMPLICIT COMPLEX (A-H,O-Z)
      DIMENSION A(*),B(*),C(*),R(*),U(*)
C     
      DO 11 J=nfen-1,1,-1
         IF(ABS(B(J+1)).EQ.0.) then
            write(*,*) 'Diagonal term in the VS matrix is zero'
            write(*,*) '*********** Fatal error *************'
            write(1,*) 'Diagonal term in the VS matrix is zero'
            write(1,*) '*********** Fatal error *************'
            stop
         endif
         P1=C(J)/B(J+1)
         B(J)=B(J)-A(J+1)*P1
         R(J)=R(J)-R(J+1)*P1
 11   CONTINUE

      IF(ABS(B(1)).EQ.0.) then
         write(*,*) 'B1 term in the VS matrix is zero'
         write(*,*) '*********** Fatal error *************'
         write(1,*) 'B1 term in the VS matrix is zero'
         write(1,*) '*********** Fatal error *************'
         stop
      endif

      U(1)=R(1)/B(1)

      DO 12 J=2,nfen
 12      U(J)=(R(J)-A(J)*U(J-1))/B(J)
   
      RETURN
      END

C***********************************************************************
C                                                                      *
C                    VSDISP.FOR - VERSION                              *
C                                                                      *
C  This subroutine computes the dispersion terms: Duu, Duv, Dvv        *
C  for the FE VS method as derived in "Dispersion Terms 1/27/92"       *
C                                                                      *
C                                                                      *
C                          R.L. 05/25/00                               *
C***********************************************************************

      Subroutine VSDISP(it,node,H,Ubar,Vbar,Duu,Duv,Dvv)

      USE GLOBAL_3DVS, ONLY : SZ,NFEN,SIGMA,GAMMA,AMB,I,NSCREEN,IDIAG


      REAL(SZ) :: Ubar,Vbar,Duu,Duv,Dvv
      REAL(8) :: delst,D1P1,Txx,Txy,Tyy,Ump,Vmp,Um,Vm,H

c     
c     parameters
c     
      ierr = 0
c     
c     don't waste time if entire profile is zero
c     
      do j=1,nfen
         if(gamma(j).ne.(0.d0,0.d0)) goto 1
      end do
      Duu = 0.d0
      Duv = 0.d0
      Dvv = 0.d0
      return

c     
c     Domain is split up into intervals according to sigma grid and
c     contribution to total integral is computed on each interval.
c     

 1    Txx = 0.d0
      Txy = 0.d0
      Tyy = 0.d0
      Ump = Real(gamma(1))
      Vmp = -Real(i*gamma(1))
      Do 100 m=1,nfen-1
         mp = m+1
         Um = Ump
         Vm = Vmp
         Ump = Real(gamma(mp))
         Vmp = -Real(i*gamma(mp))
         delst = sigma(mp) - sigma(m)
         D1P1 = delst/3.d0
         Txx = Txx + (Um*Um + Ump*Ump + Um*Ump)*D1P1
         Txy = Txy + ((Um*Vm + Ump*Vmp) + (Um*Vmp + Vm*Ump)/2.d0)*D1P1
         Tyy = Tyy + (Vm*Vm + Vmp*Vmp + Vm*Vmp)*D1P1
 100  continue

      if(Txx.lt.0.) then
         write(*,1001)
 1001    format(/'**** Serious Error Detected in SUBROUTINE VSDISP ***'/
     *        '          the partial uu dispersion term < 0        '/
     *        '        Diagnostic information written to unit 1    ')
         write(*,1101) node,it
         write(1,1002)
 1002    format(/'**** Serious Error Detected in SUBROUTINE VSDISP ***'/
     *        '          the partial uu dispersion term < 0        ')
         write(1,1101) node,it
         write(1,1021)
         do m=1,NFEN            !ntotn -> NFEN
            write(1,1022) sigMA(m), gamma(m) !sigtot -> sigMA
         enddo
         write(1,2101) Txx
 2101    format('  Par uu = ',e14.6,' It will be set to 0.')
         Txx = 0.d0
      endif

      if(Tyy.lt.0.) then
         write(*,1003)
 1003    format(/'**** Serious Error Detected in SUBROUTINE VSSOL ****'/
     *        '          the partial vv dispersion term < 0        '/
     *        '       Diagnostic information written to unit 1    ')
         write(*,1101) node,it
         write(1,1004)
 1004    format(/'**** Serious Error Detected in SUBROUTINE VSSOL ****'/
     *        '          the partial vv dispersion term < 0        ')
         write(1,1101) node,it
         write(1,1021)
         do m=1,NFEN            !ntotn -> NFEN
            write(1,1022) sigMA(m),gamma(m) !sigtot -> sigMA
         enddo
         write(1,2102) Tyy
 2102    format('  Par vv = ',e14.6,' It will be set to 0.')
         Tyy = 0.d0
      endif

 1101 format(/' Error occurred at node ',I6,' time step ',I8/)
 1021 format(8x,'sigMA',11x,'  u ',12x,'  v ')
 1022 format(1x,3e16.8)

      Duu = Txx*H/amb - H*Ubar*Ubar
      Duv = Txy*H/amb - H*Ubar*Vbar
      Dvv = Tyy*H/amb - H*Vbar*Vbar

      if(Duu.lt.0.) Duu = 0.d0
      if(Dvv.lt.0.) Dvv = 0.d0
c     
c     Diagnostic Printouts
c     
      if(idiag.eq.2) then
         write(2,*)'SUBROUTINE VSDISP, node', node
         write(2,1103) Txx,Txy,Tyy
 1103    format('  Par uu = ',e14.6,'  Par uv = ',e14.6,' Par vv = ',
     *        e14.6)
         write(2,1023) Duu,Duv,Dvv
 1023    format('  Duu = ',e14.6,'  Duv = ',e14.6,' Dvv = ',e14.6)
      endif

      return
      end


c***********************************************************************
c     Subroutine to compute the Inm integral                           *
c                                                                      *
c     Note, Inm is based only on the f.e. grid and therefore is the    *
c     same for all horizontal nodes.                                   *
c                                                                      *
c     11/24/01                                                         *
c                                                                      *
c***********************************************************************

      subroutine InmINT()
c      subroutine InmINT(Inm)

c      USE GLOBAL_3DVS, ONLY : SZ, SIGMA, NFEN
       USE GLOBAL_3DVS, ONLY : SZ, SIGMA, NFEN, Inm

c      REAL(SZ) :: Inm(NFEN,3)

C     integral over lower element of psi(k-1)*psi(k)
      Inm(1,1) = 0.d0
C     integral over upper element of psi(k+1)*psi(k)
      Inm(1,3) = (Sigma(2)-Sigma(1))/6.d0
C     integral over both elements of psi(k)*psi(k)
      Inm(1,2) = 2.d0*Inm(1,3) 

      do k=2,NFEN-1
C     integral over lower element of psi(k-1)*psi(k)
         Inm(k,1) = Inm(k-1,3) 
C     integral over upper element of psi(k+1)*psi(k)
         Inm(k,3) = (Sigma(k+1)-Sigma(k))/6.d0
C     integral over both elements of psi(k)*psi(k)
         Inm(k,2) = 2.d0*(Inm(k,1)+Inm(k,3))
      enddo

C     integral over lower element of psi(k-1)*psi(k)
      Inm(NFEN,1) = Inm(NFEN-1,3)
C     integral over both elements of psi(k)*psi(k)  
      Inm(NFEN,2) = 2.d0*Inm(NFEN,1)
C     integral over upper element of psi(k+1)*psi(k)
      Inm(NFEN,3) = 0.d0        
         
      return
      end

c***********************************************************************
c      Subroutine to compute the LVn integral (used only in VS)        *
c                                                                      *
c                            11/14/94                                  *
c***********************************************************************

      subroutine LVnInt(LVn)

      USE GLOBAL_3DVS, ONLY : SZ,IDIAG,SIGMA,EVTOT,NFEN

      REAL(SZ) :: LVn(NFEN)

      LVn(1) = (sigma(2) - sigma(1))/2.d0

      DO n=2,nfen-1
         LVn(n) = (sigma(n+1) - sigma(n-1))/2.d0
      enddo

      LVn(nfen) = (sigma(nfen) - sigma(nfen-1))/2.d0

      if(idiag.eq.2) then       !write diagnostic output
         write(2,*) '********** LVnInt **********'
         write(2,*) '***** LVn *****'
         do n=1,nfen
            write(2,950) LVn(n)
 950        format(2x,e16.8)
         end do
         write(2,*) ' '
      endif

      RETURN
      END


c***********************************************************************
c      Subroutine to compute the KQnm integral                         *
c                                                                      *
c                            01/26/00                                  *
c***********************************************************************

      subroutine KQnmInt(KQnm,Kq)

      USE GLOBAL_3DVS, ONLY : SZ,SIGMA,NFEN,IDIAG

      REAL(SZ) :: KQnm(NFEN,3),Kq(NFEN)
      REAL(8) :: EM,EP

c     do 1st element by hand

      EP=(Kq(2)+Kq(1))/(sigma(2)-sigma(1))/2.d0
      KQnm(1,1)=0.D0
      KQnm(1,2)=EP
      KQnm(1,3)=-EP

c     loop through interior elements
c     NOTE: the integrals from sigma(n-1) to sigma(n) are simply integrals
c     the integrals from sigma(n) to sigma(n+1) from previous element

      DO n=2,nfen-1
         EM=EP
         EP=(Kq(n+1)+Kq(n))/(sigma(n+1)-sigma(n))/2.d0
         KQnm(n,1)=-EM
         KQnm(n,2)=EM+EP
         KQnm(n,3)=-EP
      ENDDO

c     do last element by hand

      EM=EP
      KQnm(nfen,1)=-EM
      KQnm(nfen,2)=EM
      KQnm(nfen,3)=0.D0

c     if desired, write diagnostics

      if(idiag.gt.0) then           
         write(2,*) '********** KQmInt **********'
         write(2,*) '***** KQnm *****'
         do n=1,nfen
            write(2,951) (KQnm(n,i),i=1,3)
 951        format(3f16.9)
         end do
         write(2,*) ' '
      endif

      return
      end


c************************************************************************
c MY2.5 TURBULENCE MODEL PROGRAM
c VELOCITY SOLUTION VERSION
c
c written by R. Luettich based on earlier subroutines by R. Grenier
c
c OVERVIEW
c
c     This code uses the quasi-equilibrium version of the Mellor-Yamada
c     turbulence scheme (Mellor and Yamada, 1982, Blumberg and Mellor,
c     1987 and Galperin et al., 1988) to solve transport equations for
c     q**2 and q**2l.  The parameters q and l are used to compute the
c     eddy viscosity according to the relation:
c
c             Km = Smql
c
c     where Km is the eddy viscosity and Sm is a stability parameter.
c
c     This routine is called from the EDDYVIS subroutine during the
c     internal mode solution for ievc = 50.  There are separate DSS and
c     VS versions of the code.
c
c    *** SEE SECTION TITLED "USERS GUIDE" BELOW ***
c
c     This routine should be linked with the 3D Code subroutines (ADCIRC
c     + VS) after running the setup program
c
c PARAMETER DEFINITIONS:
c
c argument list:
c
c nh          : horizontal node counter
c H           : total depth (includes finite amplitude)
c it          : current time step value
c delt        : simulation incremental time step (uses same step as
c               internal and external modes)
c nws         : switch for wind stress (nws=1 for wind on,
c               nws=0 for wind off). This affects the surface
c               boundary condition. Set in the external mode and passed in.
c taubx,tauby : x,y bottom stresses
c tausx,tausy : x,y surface stresses
c Z0B         : bottom roughness/mixing length (see USER's notes
c               below)
c Z0S         : surface roughness/mixing length (see USER's notes
c               below)
c
c Coeff block:
c
c Sq          : stability function used in definition of the eddy
c               diffusivity of the turbulence parameters (Sq = 0.2)
c Sm          : stability function used in definition of the eddy
c               viscosity (see Galperin, et al. for exact form)
c Sh          : stability function used in definition of the eddy
c               diffusivity of the density (see Galperin, et al.
c               for exact form)
c B1,E1,E2,E3 : empirical constants (values given below; see Mellor and
c               Yamada, 1982 & Blumberg et al, 1992 for discussion)
c
c Turbmod block:
c
c Q (real, imag): x,y direction dependent variables from the vertical
c               solution
c
c Vgrid block, Setup Block
c
c parameters as defined in the internal mode subroutines
c
c Other calculation parameters:
c
c q2l         : 2xTKE times the master length scale
c q20         : previous time step value of q2
c l           : master length scale
c Km          : momentum eddy viscosity
c Kq          : turbulence eddy viscosity
c Kh          :
c Mqa,Mqb,Mqc : LHS matrix diagonals for the q2 and q2l solutions
c LVq         : RHS load vector for the q2 and q2l solutions
c q2          : solution vector returned from the tridiagonal solver
c w           : wall function (see Blumberg at al., 1992)
c BVflux2     : Brunt Vaislai frequency squared
c Gh          : dimensionless density function
c SIGT        : profile of density (sigma T)
c
c Flags, run control and miscellaneous parameters
c
c iden        : density flag (iden > 0 density included,iden = 0 no density)
c im          : run type flag - vs (im = 1) or dss (im = 2)
c il          : length scale flag - il = 2 or 3 for algebraic length scale (see below),
c               il = 1 for length scale computed from the q2l equation (see user notes below)
c ibc         : boundary condition flag for q2 (0=constant/zero,1=no-flux)
c               User should set ibc = 0 for nws = 1
c
c
c SUBROUTINES
c
c turb        : main module - handles input, run control and output.
c TRIDAG      : tridiagonal matrix solver
c
c
c USER'S GUIDE
c
c     The user must set a number of parameter statements and flags prior
c     to operation:
c
c parameter statements **Check all subroutines**
c  mnodes = maximum number of vertical nodes
c  mnp = maximum number of horizontal nodes
c
c flags (SEE DISCUSSION ABOVE UNDER flags, run control and miscellaneous parameters)
c
c     The value of Z0B should be set consistent with the bottom boundary
c     condition used in the internal mode solution.  For a no-slip BBC,
c     choose Z0B as a physical roughness height, e.g. 0.005m.  For a
c     slip case, set Z0B to a value consistent with the slip coefficient
c     used via the log profile, (e.g., 1 m).  Tests suggest that when a
c     no-slip condition is used with the VS model (for which the bottom
c     nodes are very tightly spaced) it is best to set the time
c     weighting parameter for the momentum diffusion term (alpha3 in
c     input unit 15) to 1.0 to avoid instability problems. When a slip
c     condition is used (or whenever the bottom grid spacing is about
c     1m) a Crank-Nicholson approach (alpha3 = 0.5) is acceptable.
c
c     The number of vertical nodes used in the solution of the
c     turbulence equations is the same as the number of nodes used in
c     the solution of the dependent variable (velocity or stress) in the
c     internal mode.  This is unlike the other forms of eddy viscosity,
c     for which the two grids are different and the number of nodes used
c     to define the eddy viscosity is generally less.
c
c     This code assumes that any density field is passed into the
c     routine via a common block called "DENSITY3D", which includes a
c     density profile on the internal mode solution grid at each point
c     in the horizontal.  Any updating of this profile must be done
c     externally and passed into this routine.  The density be passed as
c     sigma t units, and the background density is RHOWAT0.
c
c     Model output is limited to printing results for a single
c     horizontal node.  Additional coding would be required to create
c     full output files.
c
c
c REFERENCES
c
c     Blumberg, A.F. and G.L. Mellor, A Description of a
c     Three-Dimensional Coastal Ocean Circulation Model, In:
c     Three-Dimensional Coastal Ocean Models, edited by N.S. Heaps,
c     pp. 1-16, American Geophysical Union, Washington, D.C., 1987.
c
c     Blumberg, A.F., B. Galperin and D.J. O'Connor, Modeling vertical
c     structure of open channel flows, Journal of Hydraulic Engineering,
c     118, 1119-1134., 1992.
c
c     Galperin, B., L.H. Kantha, S. Hassid and A. Rosati, A
c     quasi-equilibrium turbulent energy model for geophysical flows,
c     Journal of the Atmospheric Sciences, 45, 55-62, 1988.
c
c     Mellor, G.L. and T. Yamada, Development of a turbulence closure
c     model for geophysical fluid problems, Reviews of Geophysics and
c     Space Physics, 20, 851-875, 1982.
c
c************************************************************************
      subroutine turb(nh,H,delt,taubx,tauby,tausx,tausy)

      USE GLOBAL_3DVS, EXCEPT_TAUBX => TAUBX ,EXCEPT_TAUBY => TAUBY
C      implicit none
      
      COMPLEX :: dQdz,dQdz1,dQdz2
      REAL(8) :: H

      REAL(SZ) :: DELT,TAUBX,TAUBY,TAUSX,TAUSY
      REAL(SZ),SAVE :: Sh,H2
      REAL(SZ),SAVE,ALLOCATABLE :: KQnm(:,:)
      REAL(SZ),SAVE,ALLOCATABLE :: Mqa(:),Mqb(:),Mqc(:)
      REAL(SZ),SAVE,ALLOCATABLE :: LVq(:),Sm(:)
      REAL(SZ),SAVE,ALLOCATABLE :: q2(:),q2prev(:)
      REAL(SZ),SAVE,ALLOCATABLE :: q2l(:),q2lprev(:)
      REAL(SZ),SAVE,ALLOCATABLE :: wall(:),rmlen(:),rmlen2(:)
      REAL(SZ),SAVE,ALLOCATABLE :: BVfreq2(:),spgrad2(:)
      REAL(SZ),SAVE,ALLOCATABLE :: Kq(:),Km(:),Kh(:)
      REAL(SZ),SAVE,ALLOCATABLE :: prod(:),diss(:)

      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '********** TURB MODEL **********'
         WRITE(2,*) '      **** node **** ',NH
      ENDIF

c     allocate local arrays
      if(.not. turb_allocated) then
         allocate(KQnm(mnodes,3))
         allocate(Mqa(mnodes),Mqb(mnodes),Mqc(mnodes))
         allocate(LVq(mnodes),Sm(mnodes))
         allocate(q2(mnodes),q2prev(mnodes))
         allocate(q2l(mnodes),q2lprev(mnodes))
         allocate(wall(mnodes),rmlen(mnodes),rmlen2(mnodes))
         allocate(BVfreq2(mnodes),spgrad2(mnodes))
         allocate(Kq(mnodes),Km(mnodes),Kh(mnodes))
         allocate(prod(mnodes),diss(mnodes))
         turb_allocated = .true.
      endif
c     
c     At time step 1, set flags and initialize variables
c     
      if(istart.eq.1) then
         il = 1                 ! length scale flag, =1 for length scale from q2l eqn.
         ibc = 0                ! surface b.c. flag, =0 for specified stress, =1 for no flux
         if((nws.eq.0).or.(nws.eq.100)) ibc=1
c     set constants and other parameters
         rkap = 0.41d0
         B1 = 16.6d0
         B123 = B1**(2.d0/3.d0)
         g2 = 0.39327d0
         g3 = 3.0858d0
         g4 = 34.676d0
         g5 = 6.1272d0
         g6 = 0.49393d0
         E1 = 1.8d0
         E2 = 1.33d0
         E3 = 0.25d0
         q2min=1.d-8
c    
         Sq = 0.2d0 ! initialize the stability constant stability function

c     initialize the Brunt-Vaisala freq squared = 0 if density not considered
         if(iden.eq.0) then
            do n=1,nfen
               BVfreq2(n)=0.d0            
            end do
         endif
c     initialization for a cold start only
         if(ihot.eq.0) then
            do n = 1,nfen
               q20(nh,n) = q2min ! initialize q2 to a minimal value
c     initilize l to a minimal value if computed from q2l equation
               if(il.eq.1) then
c     l(nh,n)=rkap*Z0B                        !rog way
                  l(nh,n)=rkap*(Z0B*(a-sigma(n))-Z0S*(b-sigma(n)))/amb
               endif
c     set l to an exponential type length scale (davies and xing)
               if(il.eq.2)then
                  sig = (sigma(n)+1.d0)/amb
                  rl1 = 1.d0/(rkap*(sig*H+Z0B)*exp(-amb*sig))
                  rl2 = 1.d0/(rkap*(H-sig*H+Z0S))
                  l(nh,n) = 1.d0/(rl1+rl2)
               endif
c     set l to a linear variation with kz over lower 15% with constant above
               if(il.eq.3)then
                  HOamb=H/amb
                  zval = (sigma(n)+1.d0)*HOamb-H
                  if(sigma(n).le.-0.7d0) l(nh,n)=rkap*(H+zval+Z0B)
                  if(sigma(n).gt.-0.7d0) l(nh,n)=rkap*(0.15d0*H+Z0B)
               endif
            end do
         endif
c     end cold start initialization
         if(idiag.gt.0) then
            write(2,*) '***** BVfreq2, l, q20  *****'
            do n=1,nfen
               write(2,*) BVfreq2(n),l(nh,n),q20(nh,n)
            end do
         endif
      endif                     !end of 1st time step section
c     
c     Begin calculations for each time step
c     
      H2 = H*H
      HOamb=H/amb
      HOamb2=(H/amb)*(H/amb)

c     Compute the speed gradient squared, density gradient, BV freq
c     and split out the mixing length

      rmlen(1)=l(nh,1)
      rmlen2(1)=rmlen(1)*rmlen(1)
      dsig=sigma(2)-sigma(1)
      if(iden.gt.0) then
         drhodz=((SIGT(nh,2)-SIGT(nh,1))/dsig)/HOamb
         BVfreq2(1)=-GORHO*drhodz
      endif
      dQdz=((Q(nh,2)-Q(nh,1))/dsig)/HOamb
      dudz=real(dQdz)
      dvdz=aimag(dQdz)
      spgrad2(1)=dudz*dudz+dvdz*dvdz
      
      do n=2,nfen-1
         rmlen(n)=l(nh,n)
         rmlen2(n)=rmlen(n)*rmlen(n)
         dsig1=sigma(n+1)-sigma(n)
         dsig2=sigma(n)-sigma(n-1)
         if(iden.gt.0) then
            drhodz1=((SIGT(nh,n+1)-SIGT(nh,n))/dsig1)/HOamb
            drhodz2=((SIGT(nh,n)-SIGT(nh,n-1))/dsig2)/HOamb
            BVfreq2(n)=-GORHO*(drhodz1+drhodz2)/2.d0
         endif
         dQdz1=((Q(nh,n+1)-Q(nh,n))/dsig1)/HOamb
         dQdz2=((Q(nh,n)-Q(nh,n-1))/dsig2)/HOamb
         dQdz=(dQdz1+dQdz2)/2.d0
         dudz=real(dQdz)
         dvdz=aimag(dQdz)
         spgrad2(n)=dudz*dudz+dvdz*dvdz
      enddo

      rmlen(nfen)=l(nh,nfen)
      rmlen2(nfen)=rmlen(nfen)*rmlen(nfen)
      dsig=sigma(nfen)-sigma(nfen-1)
      if(iden.gt.0) then
         drhodz=((SIGT(nh,nfen)-SIGT(nh,nfen-1))/dsig)/HOamb
         BVfreq2(nfen)=-GORHO*drhodz
      endif
      dQdz=((Q(nh,nfen)-Q(nh,nfen-1))/dsig)/HOamb
      dudz=real(dQdz)
      dvdz=aimag(dQdz)
      spgrad2(nfen)=dudz*dudz+dvdz*dvdz
      
c     Compute the wall function if the mixing length is determined from
c     q2l eqn

      if(il.eq.1)then
         BSlay=Z0B
         SSlay=Z0S
         do n = 1,nfen
            db=(HOamb*(sigma(n)-b)+BSlay)*rkap
            db2=db*db
            ds=(HOamb*(a-sigma(n))+SSlay)*rkap
            ds2=ds*ds
            wall(n) = 1.d0 + E2*rmlen2(n)/db2 + E3*rmlen2(n)/ds2
         enddo
      endif

      if(idiag.gt.0) then
         write(2,*) '*****   spgrad2,  rmlen,   wall  *****'
         do n=1,nfen
            write(2,*) spgrad2(n),rmlen(n),wall(n)
         end do
      endif

c     Compute the stability functions, eddy viscosity and partial
c     turbulence production & dissipation terms using information from
c     the previous time step

      do n = 1,nfen
         q2prev(n)=q20(nh,n)
         q2lprev(n)=q2prev(n)*rmlen(n)
         qprev=sqrt(q2prev(n))
         qlprev=qprev*rmlen(n)
         Gh=-BVfreq2(n)*rmlen2(n)/q2prev(n)
         if(Gh.gt.0.0233) Gh=0.0233
         Sm(n)=(g2-g3*Gh)/((1.d0-g4*Gh)*(1.d0-g5*Gh))
         Sh=g6/(1.d0-g4*Gh)
         Km(n)=Sm(n)*qlprev
         if(Km(n).lt.EVMIN) Km(n)=EVMIN
c     if(istart.eq.1) Km(n)=EVMIN                        !rog way
         Kq(n)=Sq*qlprev                                   
         if(Kq(n).lt.EVMIN) Kq(n)=EVMIN
c     Kq(n)=Km(n)*Sq/Sm(n)                           !rog way
         Kh(n)=Sh*qlprev
         if(Kh(n).lt.EVMIN) Kh(n)=EVMIN
         prod(n)=Km(n)*spgrad2(n)-Kh(n)*BVfreq2(n)
         diss(n)=qprev/(B1*rmlen(n))
c     diss(n)=q2prev(n)*Sm(n)/(Km(n)*B1)             !rog way
      enddo

      if(idiag.gt.0) then
         write(2,*) '*****  Gh,    Sm,     Sh,      Km,      Kq  *****'
         do n=1,nfen
            write(2,*) Gh,Sm(n),Sh,Km(n),Kq(n)
         end do
      endif

c     Compute the q2 LHS Matrix and RHS Load Vector

      call KQnmInt(KQnm,Kq)

      Mqa(1) = 0.d0
      Mqb(1) = 1.d0
      Mqc(1) = 0.d0
      LVq(1) = B123*sqrt(taubx*taubx+tauby*tauby)
      
      coef2 = delt*theta1/HOamb2
c     coef2 = theta1/HOamb2                !rog way
      coef4 = 2.d0*delt
c     coef4 = 2.d0                         !rog way
      coef5 = delt*(1.d0-theta1)/HOamb2
c     coef5 = (1.d0-theta1)/HOamb2         !rog way
      do n=2,nfen-1
         tdiss = 2.d0*diss(n)
         coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss       !rog way
         Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2               !lumping
         Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2)+Inm(n,3))*coef1+KQnm(n,2)*coef2  !lumping
         Mqc(n) = Inm(n,3)*coef1+KQnm(n,3)*coef2
c     Mqc(n) = KQnm(n,3)*coef2                                     !lumping
         
         coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss                      !rog way
         LVq(n) = Inm(n,1)*(coef3*q2prev(n-1)+coef4*prod(n-1))
     *        -KQnm(n,1)*coef5*q2prev(n-1)
     *        + Inm(n,2)*(coef3*q2prev(n  )+coef4*prod(n  ))
     *        -KQnm(n,2)*coef5*q2prev(n)
     *        + Inm(n,3)*(coef3*q2prev(n+1)+coef4*prod(n+1))
     *        -KQnm(n,3)*coef5*q2prev(n+1)
c     LVq(n) =                 -KQnm(n,1)*coef5*q2prev(n-1)     !lumping
c     &         + (Inm(n,1)+Inm(n,2)+Inm(n,3))                  !lumping
c     &         *(coef3*q2prev(n)+coef4*prod(n))     !lumping
c     &         -KQnm(n,2)*coef5*q2prev(n)       !lumping
c     &         -KQnm(n,3)*coef5*q2prev(n+1)     !lumping

      enddo

      if(ibc.eq.0) then
         Mqa(nfen) = 0.d0
         Mqb(nfen) = 1.d0
         Mqc(nfen) = 0.d0
         LVq(nfen) = B123*sqrt(tausx*tausx+tausy*tausy)
      endif

      if(ibc.eq.1)then
         n=nfen
         tdiss = 2.d0*diss(n)
         coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss                   !rog way    
         Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2                           !lumping
         Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2))*coef1+KQnm(n,2)*coef2 !lumping
         Mqc(n) = 0.d0

         coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss            !rog way
         LVq(n) = Inm(n,1)*(coef3*q2prev(n-1)+coef4*prod(n-1))
     *        -KQnm(n,1)*coef5*q2prev(n-1)
     *        + Inm(n,2)*(coef3*q2prev(n  )+coef4*prod(n  ))
     *        -KQnm(n,2)*coef5*q2prev(n)
c     LVq(n) =    -KQnm(n,1)*coef5*q2prev(n-1)   !lumping
c     &    + (Inm(n,1)+Inm(n,2))*(coef3*q2prev(n)+coef4*prod(n))       !lumping
c     &         -KQnm(n,2)*coef5*q2prev(n)     !lumping
      endif

c     Solve the system for q2

      CALL TRIDAG(Mqa,Mqb,Mqc,LVq,q2,nfen)

c     Transfer to global array and check for zero or negative values
c     (generally for startup)

      do n = 1,nfen
         if(q2(n).le.0.)then
            q2(n) = q2min
         endif
         q20(nh,n) = q2(n)
      enddo

c     
c     write q2 diagnostics if idiag = 1,2
c     
      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '***** Q2:prod, diss, Q2L prev *****'
         DO N=1,NFEN
            WRITE(2,998) prod(N),diss(N),q2lprev(n)
 998        FORMAT(2X,E14.6,2X,E14.6,2X,E14.6)
         END DO
         WRITE(2,*) '***** Q2:RHS LOAD VECTOR *****'
         DO N=1,NFEN
            WRITE(2,1000) LVq(N)
 1000       FORMAT(2X,e12.4)
         END DO
         WRITE(2,*) '***** Q2:LHS MATRIX *****'
         DO N=1,NFEN
            WRITE(2,1001) Mqa(N),Mqb(n),Mqc(n)
 1001       FORMAT(3(2X,e12.4))
         END DO
         WRITE(2,*) '***** Q2 *****'
         DO N=1,NFEN
            WRITE(2,1001) q2(N)
         END DO
      END IF

c     Compute length scale

      if(il.eq.2)then
         do n=1,nfen
            sig = (sigma(n)+1.d0)/amb
            rl1 = 1.d0/(rkap*(sig*H+Z0B)*exp(-amb*sig))
            rl2 = 1.d0/(rkap*(H-sig*H+Z0S))
            l(nh,n) = 1.d0/(rl1+rl2)
         enddo
      endif
      
      if(il.eq.3)then
         do n=1,nfen
            HOamb=H/amb
            zval = (sigma(n)+1.d0)*HOamb-H
            if(sigma(n).le.-0.7d0) l(nh,n)=rkap*(H+zval+Z0B)
            if(sigma(n).gt.-0.7d0) l(nh,n)=rkap*(0.15d0*H+Z0B)
         enddo
      endif
      
      if(il.eq.1)then
         
c     Compute the q2l LHS Matrix and RHS Load Vector

         Mqa(1) = 0.d0
         Mqb(1) = 1.d0
         Mqc(1) = 0.d0
         LVq(1) = rkap*BSlay*q2(1)

         coef2 = delt*theta1/HOamb2
c     coef2 = theta1/HOamb2                                     !rog way
         coef5 = delt*(1.d0-theta1)/HOamb2
c     coef5 = (1.d0-theta1)/HOamb2                              !rog way
         do n=2,nfen-1
            tdiss = wall(n)*diss(n)
            coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss                        !rog way
            Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2                                !lumping
            Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2)+Inm(n,3))*coef1+KQnm(n,2)*coef2   !lumping
            Mqc(n) = Inm(n,3)*coef1+KQnm(n,3)*coef2
c     Mqc(n) = KQnm(n,3)*coef2                                !lumping

            coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss                 !rog way
            coef4 = E1*rmlen(n)*delt
c     coef4 = E1*rmlen(n)                                     !rog way
            LVq(n) = Inm(n,1)*(coef3*q2lprev(n-1)+coef4*prod(n-1))
     *           -KQnm(n,1)*coef5*q2lprev(n-1)
     *           + Inm(n,2)*(coef3*q2lprev(n  )+coef4*prod(n  ))
     *           -KQnm(n,2)*coef5*q2lprev(n)
     *           + Inm(n,3)*(coef3*q2lprev(n+1)+coef4*prod(n+1))
     *           -KQnm(n,3)*coef5*q2lprev(n+1)
c     LVq(n) =      -KQnm(n,1)*coef5*q2lprev(n-1)  !lumping
c     &    + (Inm(n,1)+Inm(n,2)+Inm(n,3))                           !lumping
c     &     *(coef3*q2lprev(n)+coef4*prod(n))                       !lumping
c     &       -KQnm(n,2)*coef5*q2lprev(n)    !lumping
c     &     -KQnm(n,3)*coef5*q2lprev(n+1)  !lumping
c     
         enddo

         Mqa(nfen) = 0.d0
         Mqb(nfen) = 1.d0
         Mqc(nfen) = 0.d0
         LVq(nfen) = SSlay*rkap*q2(nfen)
         
c     Solve the system for q2l

         CALL TRIDAG(Mqa,Mqb,Mqc,LVq,q2l,nfen)

c     Transfer to global array and check for stability limit

         l(nh,1) = q2l(1)/q2(1)
         do n = 2,nfen-1
            l(nh,n) = q2l(n)/q2(n)
            if(l(nh,n).lt.0.) 
     *           l(nh,n)=rkap*(Z0B*(a-sigma(n))-Z0S*(b-sigma(n)))/amb
            if(l(nh,n).gt.H) l(nh,n)=H
            if((iden.gt.0).and.(BVfreq2(n).gt.0.0)) then
               elmax = 0.53D0*sqrt(q2(n))/sqrt(BVfreq2(n))
               if(l(nh,n).gt.elmax) l(nh,n)=elmax
            endif
         end do
         l(nh,nfen) = q2l(nfen)/q2(nfen)
      endif

c     
c     compute eddy viscosity and store variables for output and next step
c     
      do n = 1,nfen
         EVTOT(n) = Sm(n)*sqrt(q2(n))*l(nh,n)
         if(EVTOT(n).lt.EVMIN) EVTOT(n)=EVMIN
      end do

c     
c     write q2l diagnostics if idiag = 2
c     
      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '***** Q2L:RHS LOAD VECTOR *****'
         DO N=1,NFEN
            WRITE(2,1000) LVq(N)
         END DO
         WRITE(2,*) '***** Q2L:LHS MATRIX *****'
         DO N=1,NFEN
            WRITE(2,1001) Mqa(N),Mqb(n),Mqc(n)
         END DO
         WRITE(2,*) '***** Q2,L,EVTOT *****'
         DO N=1,NFEN
            WRITE(2,1001) q2(N),L(nh,n),EVTOT(n)
         END DO
      END IF

      return
      END


C***********************************************************************
C Subroutine tridag                                                    *
C                                                                      *
C     -----------------------------------------------------------------*
C     |SOLVER FOR A VECTOR U OF LENGTH N FROM A SET OF LINEAR          *
C     |EQUATIONS THAT CONTAINS A TRIDIAGONAL MATRIX                    *
C     |THE FORM IS                                                     *
C     |                                                                *
C     |   * B1 C1  0 ...               *     * U1 *     * R1 *         *
C     |  *                              *   *      *   *      *        *
C     |  *  A2 B2 C2 ...                *   *  U2  *   *  R2  *        *
C     |  *  ...                         * * * ...  * = * ...  *        *
C     |  *           ... An-1 Bn-1 Cn-1 *   * Un-1 *   * Rn-1 *        *
C     |  *                              *   *      *   *      *        *
C     |   *                0   An  Bn  *     * Un *     * Rn *         *
C     |                                                                *
C     |A, B, C, U ARE ARRAYS.                                          *
C     -----------------------------------------------------------------*
C                                                                      *
C    Adapted from Numerical Recipes chapter 2                          *
C***********************************************************************
c
      SUBROUTINE TRIDAG(A,B,C,R,U,N)
      
      USE GLOBAL_3DVS, ONLY : SZ
      
      INTEGER :: J

      REAL(SZ) :: A(N),B(N),C(N),R(N),U(N)
      REAL(SZ) :: BET,GAM(N)

c     
c     check for zero elements on diagonal
c     
      DO J=1,N
         if(B(j).EQ.0.) then
            write(*,*) 'Problem in Tridag Solver.  ',
     *           'B array value in row ',j,' = 0'
            stop
         endif
      end do
      BET = B(1)
      U(1) = R(1)/BET
      DO J = 2,N
         GAM(J) = C(J-1)/BET
         BET=B(J)-A(J)*GAM(J)
         if (BET.EQ.0) then
            write(*,*) ' Problem in Tridag Solver.  ',
     *           ' BET  = 0.  Solver failed.'
            stop
         endif
         U(J)=(R(J)-A(J)*U(J-1))/BET
      END DO
      DO J = N-1,1,-1
         U(J) = U(J) - GAM(J+1)*U(J+1)
      END DO
      RETURN
      END


C****************************************************************************************
C   Subroutine to interpolate baroclinic pressure (BCP) to a specified sigma value      *
C   (SIGMANN) given an initial guess of which sigma level is closest to the specified   *
C   value.                                                                              *
C                                                                                       *
C                                    R.L.  5/04/01                                      *
C****************************************************************************************
C
      SUBROUTINE ZSURFBUOY(SIGMANN,BPRESSNN,NN,J)

      USE GLOBAL_3DVS

      IF(SIGMANN.LT.1.0001*b) THEN !if into ground then skip
         SIGBELO=-999
         SIGABOV=-999
         BPRESSNN=-999.
         GOTO 100
      ENDIF
      IF((SIGMANN.GT.1.0001*b).AND.(SIGMANN.LE.b)) THEN !at bottom then use bottom
         LBELO=1
         BPRESSNN=BCP(NN,LBELO)
         SIGBELO=b
         SIGABOV=b
         GOTO 100
      ENDIF
      IF(SIGMANN.GE.a) THEN     !into air use surface
         LABOV=NFEN
         BPRESSNN=BCP(NN,LABOV)
         SIGBELO=a
         SIGABOV=a
         GOTO 100
      ENDIF

      LTRY=J                    !start search for SIGABOV and SIGBELO
      SIGTRY=SIGMA(LTRY)                    
      IF(SIGMANN.GT.SIGTRY) THEN !too low
         SIGBELO=SIGTRY         !SIGBELO may = SIGTRY
         LBELO=LTRY
         LTRY=LTRY+1            !look at next level higher
 90      SIGTRY=SIGMA(LTRY)
         IF(SIGMANN.GT.SIGTRY) THEN !still too low
            SIGBELO=SIGTRY
            LBELO=LTRY
            LTRY=LTRY+1
            GOTO 90 
         ENDIF
         SIGABOV=SIGTRY         !found upper bracketing sigma
         LABOV=LTRY
         GOTO 99                !go interpolate
      ENDIF
      IF(SIGMANN.LE.SIGTRY) THEN !to high
         SIGABOV=SIGTRY         !SIGABOV may = SIGTRY
         LABOV=LTRY                          
         LTRY=LTRY-1            !look at next level lower
 91      SIGTRY=SIGMA(LTRY)
         IF(SIGMANN.LE.SIGTRY) THEN !still too high
            SIGABOV=SIGTRY
            LABOV=LTRY
            LTRY=LTRY-1
            GOTO 91
         ENDIF
         SIGBELO=SIGTRY         !found lower bracketing sigma
         LBELO=LTRY
      ENDIF

 99   BPRESSNN=(BCP(NN,LABOV)-BCP(NN,LBELO)) !interpolation
     *     *(SIGMANN-SIGBELO)/(SIGABOV-SIGBELO) + BCP(NN,LBELO)

 100  CONTINUE

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) '******** ZSURFBUOY **********'
         WRITE(2,*) '     NH  NV  SIGMANN   SIGBELO   SIGABOV',
     *        '      BPRESSNN'
         WRITE(2,777) NN,J,SIGMANN,SIGBELO,SIGABOV,BPRESSNN
 777     FORMAT(I7,I5,3(F10.3),E14.5)
      ENDIF

      RETURN
      END


C****************************************************************************************
C   Subroutine to write out 3D Hot Start info                                           *
C                                                                                       *
C                                    R.L.  2/22/00                                      *
C****************************************************************************************
C
      SUBROUTINE HSTART3D_OUT()

      USE GLOBAL_3DVS

C...  
C...  WRITE HOT START OUTPUT
C...  
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSSD
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISDREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSSV
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISVREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSST
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISTREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGD
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGDREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGV
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGVREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGT
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGTREC

      DO NH=1,NP
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DUU(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DUV(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DVV(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) UBAR(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VBAR(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) TAUBX(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) TAUBY(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VIDBCPDX(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VIDBCPDY(NH)
      ENDDO

      DO NH=1,NP
         DO N=1,NFEN
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) REAL(Q(NH,N))
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) AIMAG(Q(NH,N))
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) WZ(NH,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) q20(NH,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) l(NH,N)
            IF(IDEN.EQ.1) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SIGT(NH,N)
            ENDIF
            IF(IDEN.EQ.2) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SAL(NH,N)
            ENDIF
            IF(IDEN.EQ.3) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) TEMP(NH,N)
            ENDIF
            IF(IDEN.EQ.4) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SAL(NH,N)
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) TEMP(NH,N)
            ENDIF
         ENDDO
      ENDDO

      RETURN
      END
C******************************************************************************
C PADCIRC RELEASE VERSION 41.11 09/14/2001   
C    last changes in this file VERSION 41.09
C
C  mod history
C  v40.02mxxx - date - programmer - describe change 
C                    - mark change in code with  cinitials-mxxx
C
C  v41.09 - 06/30/01 - jw - from 41.08 - made minor mods as per vp version 41.05
C
C  9/3/2000 fixed bug in hot start, consolidated with v35.xx 
C  8/7/2000 modfied jcg_with_blas -- fixed bug in itjcg for single cpu case
C  8/7/2000 modfied wetting and drying section to fix bug and optimize
C  11/1/2000 added init of TIP2 in hstart and fixed Sun makefile for Jesse
C******************************************************************************
C                                                                             *
C                           (P)ADCIRC                                         *
C                                                                             *
C    A (PARALLEL) ADVANCED CIRCULATION MODEL FOR SHELVES, COASTAL SEAS        *
C                         AND ESTUARIES                                       *
C                                                                             *
C                                                                             *
C                          DEVELOPED BY:                                      *
C                                                                             *
C                      DR. R.A. LUETTICH, JR                                  *
C                                                                             *
C             UNIVERSITY OF NORTH CAROLINA AT CHAPEL HILL                     *
C                   INSTITUTE OF MARINE SCIENCES                              *
C                       3431 ARENDELL ST.                                     *
C                   MOREHEAD CITY, NC, 28557                                  *
C                         252-726-6841 EXT. 137                               *
C                   EMAIL  RICK_LUETTICH@UNC.EDU                              *
C                                                                             *
C                        DR. J.J. WESTERINK                                   *
C                                                                             *
C          DEPARTMENT OF CIVIL ENGINEERING AND GEOLOGICAL SCIENCES            *
C                     UNIVERSITY OF NOTRE DAME                                *
C                       NOTRE DAME, IN 46556                                  *
C                         219-631-6475                                        *
C                    EMAIL JJW@PHOTIUS.CE.ND.EDU                              *
C                                                                             *
C                                                                             *
C        MAJOR FUNDING FOR THE DEVELOPMENT OF ADCIRC WAS PROVIDED BY          *
C                                                                             *
C                       DEPARTMENT OF THE ARMY                                *
C                    WATERWAYS EXPERIMENT STATION                             *
C                 COASTAL ENGINEERING RESEARCH CENTER                         *
C                        3909 HALLS FERRY RD                                  *
C                      VICKSBURG, MI 39180-6199                               *
C                                                                             *
C******************************************************************************
C                                                                             *
C                  PARALLELIZATION OF ADCIRC WAS DONE BY                      *
C                    THE CENTER FOR SUBSURFACE MODELING                       *
C                         THE UNIVERSITY OF TEXAS                             *
C                             AUSTIN, TX 78712                                *
C                       email: mfw@ticam.utexas.edu                           *
C                          03/06/98 - 5/19/99                                 *
C                                                                             *
C                         Translation to Fortran90                            *
C                             Victor J. Parr                                  *
C                             John B. Romo                                    *
C                               8/31/99                                       *
C                                                                             *
C******************************************************************************
C                                                                             *
C          THE ADCIRC SOURCE CODE IS COPYRIGHTED, 1994-2001 BY:               *
C                                                                             *
C                 R.A. LUETTICH, JR AND J.J. WESTERINK                        *
C                                                                             *
C         NO PART OF THIS CODE MAY BE REPRODUCED OR REDISTRIBUTED             *
C               WITHOUT THE WRITTEN PERMISSION OF THE AUTHORS                 *
C                                                                             *
C******************************************************************************
C
      PROGRAM PADCIRC
C
      USE GLOBAL
      USE HARM

      IMPLICIT NONE
      MNPROC = 1             ! Init number of procs for serial
      MYPROC = 0             ! Init task id for serial
      CALL MAKE_DIRNAME()    ! Establish Working Directory Name
      CALL READ_INPUT()      ! Establish sizes by reading fort.14 and fort.15

 



C...Compute the reciprocal of the Number of Nodes in the entire domain 


C...
C...******************* START PROGRAM SETUP SECTION ****************************
C...
C
      IF (IHOT.EQ.0) THEN
         CALL COLDSTART()
      ELSE
         CALL HOTSTART()
      ENDIF
C...
C...DETERMINE THE NUMBER OF ACTIVE ELEMENTS (MJU) and total number of 
C...elements (NODELE) ATTACHED TO EACH NODE
C...
      DO I=1,NP
         MJU(I)=0
         NODELE(I)=0
         NODECODE(I)=NNODECODE(I)
      END DO

      DO IE=1,NE
         NM1=NM(IE,1)
         NM2=NM(IE,2)
         NM3=NM(IE,3)
         NCELE=NODECODE(NM1)*NODECODE(NM2)*NODECODE(NM3)
         MJU(NM1)=MJU(NM1)+NCELE
         MJU(NM2)=MJU(NM2)+NCELE
         MJU(NM3)=MJU(NM3)+NCELE
         NODELE(NM1)=NODELE(NM1)+1
         NODELE(NM2)=NODELE(NM2)+1
         NODELE(NM3)=NODELE(NM3)+1
      END DO

      DO I=1,NP
         IF(MJU(I).EQ.0) MJU(I)=1
      END DO

C...
C...************* SET FLAGS AND COEFFICIENTS USED IN TIME STEPPING ***********
C...

C...NONLINEAR FLAGS

      IF(NOLIBF.EQ.0) THEN
         IFNLBF=0
         IFLINBF=1
         IFHYBF=0
      ENDIF
      IF(NOLIBF.EQ.1) THEN
         IFNLBF=1
         IFLINBF=0
         IFHYBF=0
      ENDIF
      IF(NOLIBF.EQ.2) THEN
         IFNLBF=0
         IFLINBF=0
         IFHYBF=1
      ENDIF
      IF(NOLIFA.EQ.0) THEN
         IFNLFA=0
      ELSE
         IFNLFA=1
      ENDIF
      IF(NOLICA.EQ.0) THEN
         IFNLCT=0
      ELSE
         IFNLCT=1
      ENDIF
      IF(NOLICAT.EQ.0) THEN
         IFNLCAT=0
      ELSE
         IFNLCAT=1
      ENDIF

      IFWIND=1
      IF(IM.EQ.1) IFWIND=0

C...CONSTANT COEFFICIENTS
cjjw - version m10
cjjw      TT0L=((1.0+0.5*DT*TAU0)/DT)/DT
      GA00=G*A00
cjjw - version m10
cjjw      TT0R=((0.5*TAU0*DT-1.0)/DT)/DT
      GC00=G*C00
      TADVODT=IFNLCAT/DT
      GB00A00=G*(B00+A00)
      GFAO2=G*IFNLFA/2.D0
      GO3=G/3.D0
      DTO2=DT/2.D0
      DT2=DT*2.D0
      GDTO2=G*DT/2.D0
      SADVDTO3=IFNLCT*DT/3.D0

C...
C...************************* BEGIN TIME STEPPING *************************
C...  
      WRITE(16,1112)
      WRITE(16,17931)
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1112)
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,17931)
 1112 FORMAT(/,1X,79('_'))
17931 FORMAT(//,1X,'LIMITED RUNTIME INFORMATION SECTION ',//)
      
      NCCHANGE=1

      DO 100 ITIME=ITHS+1,NT
C
         CALL TIMESTEP(ITIME)
C
 100  CONTINUE
C...
C...****************** TIME STEPPING LOOP ENDS HERE ********************
C...
C...
C...IF IHARIND=1 SOLVE THE HARMONIC ANALYSIS PROBLEM AND WRITE OUTPUT
C...
      IF ((IHARIND.EQ.1).AND.(ITIME.GT.ITHAS)) THEN

C...LINES COMPUTE MEANS AND VARIANCES
C...FOR CHECKING THE HARMONIC ANALYSIS RESULTS.
C...ACCUMULATE VARIANCE AND MEAN OF RECORD AT NODES.
C
         if (CHARMV) then
            IF (FMV.NE.0.) THEN
               DO I=1,NP
                  ELAV(I)   = ELAV(I)/NTSTEPS
                  XVELAV(I) = XVELAV(I)/NTSTEPS
                  YVELAV(I) = YVELAV(I)/NTSTEPS
                  ELVA(I)   = ELVA(I)/NTSTEPS   - ELAV(I)*ELAV(I)
                  XVELVA(I) = XVELVA(I)/NTSTEPS - XVELAV(I)*XVELAV(I)
                  YVELVA(I) = YVELVA(I)/NTSTEPS - YVELAV(I)*YVELAV(I)
               END DO
               TIMEBEG=ITMV*DTDP + (STATIM-REFTIM)*86400.D0
               OPEN(55,FILE=DIRNAME//'/'//'fort.55')
               WRITE(55,*) NP
            ENDIF
         endif                  !  charmv
C...
C......Fill out and decompose the LHS harmonic analaysis matrix
C...
         CALL FULSOL(0)
C...
C......Solve the harmonic analysis problem and write the output
C...
         IF(NHAGE.EQ.1) CALL LSQSOLEG(NP,DIRNAME,LNAME,ELAV,ELVA)
C     
         IF(NHAGV.EQ.1) CALL LSQSOLVG(NP,DIRNAME,LNAME,
     *                          XVELAV,YVELAV,XVELVA,YVELVA)
C
         IF(NHASE.EQ.1) CALL LSQSOLES(NSTAE,DIRNAME,LNAME)
C     
         IF(NHASV.EQ.1) CALL LSQSOLVS(NSTAV,DIRNAME,LNAME)
C
      ENDIF


C
C
      STOP
      END


C******************************************************************************
C                                                                             *
C      Subroutine to generate a neighbor table from a connectivity table.     *
c                                                                             *
c      NOTES                                                                  *
c      the node itself is listed as neighbor #1                               *
c      all other neighbors are sorted and placed in cw order from east        *
c      a neighbor element table is also generated with:                       *
c         entry 1 = element # defined by neighbors 1,2,3                      *
c         entry 2 = element # defined by neighbors 1,3,4                      *
c         entry 3 = element # defined by neighbors 1,4,5                      *
c          .......                                                            *
c         entry last = element # defined by neighbors 1,nneigh,2              *
c         a zero area means that the defined triangle lies outside the domain *
c                                                                             *
c                       R.L.       6/29/99                                    *
C******************************************************************************
C                                                                             *
C     -  PARAMETERS WHICH MUST BE SET TO CONTROL THE DIMENSIONING OF ARRAYS   *
C           ARE AS FOLLOWS:                                                   *
C                                                                             *
C          MNP = MAXIMUM NUMBER OF NODAL POINTS                               *
C          MNE = MAXIMUM NUMBER OF ELEMENTS                                   *
C          MNEI= 1+MAXIMUM NUMBER OF NODES CONNECTED TO ANY ONE NODE IN THE   *
C                   FINITE ELEMENT GRID                                       *
C                                                                             *
C******************************************************************************
C                                                                             *
C    VARIABLE DEFINITIONS:                                                    *
C       NE - NUMBER OF ELEMENTS                                               *
C       NP - NUMBER OF NODES                                                  *
C       NM(MNE,3) - NODE NUMBERS ASSOCIATED WITH EACH ELEMENT                 *
C       NNEIGH(MNP) NUMBER OF NEIGHBORS FOR EACH NODE                         *
C       NEIGH(MNP,NEIMAX) 2D ARRAY OF NEIGHBORS FOR EACH NODE                 *
C       NEIMIN - 1+MINIMUM NUMBER OF NEIGHBORS FOR ANY NODE                   *
C       NEIMAX - 1+MAXIMUM NUMBER OF NEIGHBORS FOR ANY NODE                   *
C                                                                             *
C******************************************************************************
C
      SUBROUTINE NEIGHB(NE,NP,NM,NNEIGH,NEIGH,NEIGHELE,NEIMIN,NEIMAX,
     *                  X,Y,NSCREEN)
      USE SIZES
C
      INTEGER NP,NE,NEIMIN,NEIMAX,NSCREEN,N,NN,EN1,EN2,EN3,I,J
      INTEGER :: NEIGH(MNP,MNEI),NNEIGH(MNP),NEIGHELE(MNP,MNEI)
      INTEGER NM(MNE,3)
      REAL(8) X(MNP),Y(MNP),DELX,DELY,DIST
      REAL(8) ANGLELOW,ANGLEMORE,RAD2DEG
      REAL(8), ALLOCATABLE :: ANGLE(:)
      INTEGER,ALLOCATABLE :: NEITEM(:)
      INTEGER,ALLOCATABLE :: NNEIGHELE(:)
C
C  Allocate local work arrays
C
      ALLOCATE ( ANGLE(MNEI) )
      ALLOCATE ( NEITEM(MNP) )
      ALLOCATE ( NNEIGHELE(MNP) )
C     
      RAD2DEG=45.0d0/ATAN(1.0d0)
C     
      DO N=1,NP
         NNEIGH(N)=0
         NNEIGHELE(N)=0
         DO NN=1,MNEI
            NEIGH(N,NN)=0
            NEIGHELE(N,NN)=0
         END DO
      END DO

      DO 10 N=1,NE
         NN1 = NM(N,1)
         NN2 = NM(N,2)
         NN3 = NM(N,3)

         NNEIGHELE(NN1)=NNEIGHELE(NN1)+1
         NNEIGHELE(NN2)=NNEIGHELE(NN2)+1
         NNEIGHELE(NN3)=NNEIGHELE(NN3)+1
         NEIGHELE(NN1,NNEIGHELE(NN1))=N
         NEIGHELE(NN2,NNEIGHELE(NN2))=N
         NEIGHELE(NN3,NNEIGHELE(NN3))=N

         DO J=1,NNEIGH(NN1)
            IF(NN2.EQ.NEIGH(NN1,J)) GOTO 25
         END DO
         NNEIGH(NN1)=NNEIGH(NN1)+1
         NNEIGH(NN2)=NNEIGH(NN2)+1
         IF((NNEIGH(NN1).GT.MNEI-1).OR.(NNEIGH(NN2).GT.MNEI-1)) GOTO 999
         NEIGH(NN1,NNEIGH(NN1))=NN2
         NEIGH(NN2,NNEIGH(NN2))=NN1


 25      CONTINUE
         DO J=1,NNEIGH(NN1)
            IF(NN3.EQ.NEIGH(NN1,J)) GOTO 35
         END DO
         NNEIGH(NN1)=NNEIGH(NN1)+1
         NNEIGH(NN3)=NNEIGH(NN3)+1
         IF((NNEIGH(NN1).GT.MNEI-1).OR.(NNEIGH(NN3).GT.MNEI-1)) GOTO 999
         NEIGH(NN1,NNEIGH(NN1))=NN3
         NEIGH(NN3,NNEIGH(NN3))=NN1

 35      CONTINUE
         DO J=1,NNEIGH(NN2)
            IF(NN3.EQ.NEIGH(NN2,J)) GOTO 10
         END DO
         NNEIGH(NN2)=NNEIGH(NN2)+1
         NNEIGH(NN3)=NNEIGH(NN3)+1
         IF((NNEIGH(NN2).GT.MNEI-1).OR.(NNEIGH(NN3).GT.MNEI-1)) GOTO 999
         NEIGH(NN2,NNEIGH(NN2))=NN3
         NEIGH(NN3,NNEIGH(NN3))=NN2

 10   CONTINUE
C
C  INSERT NODE ITSELF IN PLACE #1 and SORT other NEIGHBORS by increasing cw angle from East
C
      DO I=1,NP
         DO J=1,NNEIGH(I)
            NEITEM(J)=NEIGH(I,J)
            DELX=X(NEITEM(J))-X(I)
            DELY=Y(NEITEM(J))-Y(I)
            DIST=SQRT(DELX*DELX+DELY*DELY)
            IF(DIST.EQ.0.0d0) GOTO 998
            IF(DELY.NE.0.0d0) THEN
               ANGLE(J)=RAD2DEG*ACOS(DELX/DIST)
               IF(DELY.GT.0.0) ANGLE(J)=360.0d0-ANGLE(J)
            ENDIF
            IF(DELY.EQ.0.0d0) THEN
               IF(DELX.GT.0.0d0) ANGLE(J)=0.0d0
               IF(DELX.LT.0.d0) ANGLE(J)=180.0d0
            ENDIF
         END DO
         ANGLEMORE=-1.d0
         DO JJ=1,NNEIGH(I)
            ANGLELOW=400.d0
            DO J=1,NNEIGH(I)
               IF((ANGLE(J).LT.ANGLELOW).AND.
     *              (ANGLE(J).GT.ANGLEMORE)) THEN
                  ANGLELOW=ANGLE(J)
                  JLOW=J
               ENDIF
            END DO
            NEIGH(I,JJ+1)=NEITEM(JLOW)
            ANGLEMORE=ANGLELOW
         END DO
         NEIGH(I,1)=I
         NNEIGH(I)=NNEIGH(I)+1
      ENDDO
C
C     MATCH EACH SET OF 3 NODES WITH CORRESPONDING ELEMENT AND REORDER
C     ELEMENTS ACCORDINGLY
C
      DO I=1,NP
         DO K=1,NNEIGHELE(I)
            NEITEM(K)=NEIGHELE(I,K)
            NEIGHELE(I,K)=0
         END DO
         DO J=2,NNEIGH(I)
            NN1=NEIGH(I,1)
            NN3=NEIGH(I,J)
            IF(J.NE.NNEIGH(I)) NN2=NEIGH(I,J+1)
            IF(J.EQ.NNEIGH(I)) NN2=NEIGH(I,2)
            DO K=1,NNEIGHELE(I)
               IF(NEITEM(K).NE.0) THEN
                  IF(NM(NEITEM(K),1).EQ.NN1) THEN
                     NE1=NM(NEITEM(K),1)
                     NE2=NM(NEITEM(K),2)
                     NE3=NM(NEITEM(K),3)
                  ENDIF
                  IF(NM(NEITEM(K),2).EQ.NN1) THEN
                     NE1=NM(NEITEM(K),2)
                     NE2=NM(NEITEM(K),3)
                     NE3=NM(NEITEM(K),1)
                  ENDIF
                  IF(NM(NEITEM(K),3).EQ.NN1) THEN
                     NE1=NM(NEITEM(K),3)
                     NE2=NM(NEITEM(K),1)
                     NE3=NM(NEITEM(K),2)
                  ENDIF
                  IF((NE2.EQ.NN2).AND.(NE3.EQ.NN3)) THEN
                     NEIGHELE(I,J-1)=NEITEM(K)
                     NEITEM(K)=0
                  ENDIF
               ENDIF
            END DO
         END DO
      END DO

C
C  DETERMINE THE MAXIMUM AND MINIMUM NUMBER OF NEIGHBORS
C
      NEIMAX = 0
      NEIMIN = 1000
      DO 60 N=1,NP
         IF(NNEIGH(N).LT.NEIMIN) NEIMIN=NNEIGH(N)
         IF(NNEIGH(N).GT.NEIMAX) NEIMAX=NNEIGH(N)
 60   CONTINUE
C
C  WRITE OUT DIAGNOSTIC OUTPUT  
C
c     OPEN(333,file='fort.333')
c     DO N=1,NP
c       WRITE(333,331) (NEIGH(N,J),J=1,NNEIGH(N))
c       WRITE(333,331) N,(NEIGHELE(N,J),J=1,NNEIGH(N)-1)
c       WRITE(333,*) ' '
c331    FORMAT(15(1X,I7))
c       END DO
c     CLOSE (333)
C
C  Deallocate local work arrays
C
      DEALLOCATE ( ANGLE )
      DEALLOCATE ( NEITEM )
      DEALLOCATE ( NNEIGHELE )
C
C  DONE
C
      RETURN
C
C  TERMINATE PROGRAM IF MAXIMUM NUMBER OF NEIGHBORS SET TOO SMALL
C
 999  CONTINUE
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99311)
      WRITE(16,99311)
99311 FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *      //,1X,'THE DIMENSIONING PARAMETER MNEI IS TOO SMALL'
     *     /,1X,'USER MUST RE-DIMENSION PROGRAM',
     *     //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
      STOP

 998  CONTINUE
      IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,99312) I,NEITEM(J)
      WRITE(16,99312) I,NEITEM(J)
99312 FORMAT(////,1X,'!!!!!!!!!!  WARNING - FATAL ERROR !!!!!!!!!',
     *      //,1X,'NODES ',I7,' AND ',I7,' HAVE THE SAME COORDINATES'
     *     //,1X,'!!!!!! EXECUTION WILL NOW BE TERMINATED !!!!!!',//)
      STOP
      END


C******************************************************************************
C                                                                             *
C    Transform from lon,lat (lamda,phi) coordinates into CPP coordinates.     *
C    Lon,Lat must be in radians.                                              *
C                                                                             *
C******************************************************************************

      SUBROUTINE CPP(X,Y,RLAMBDA,PHI,RLAMBDA0,PHI0)
      REAL*8 X,Y,RLAMBDA,PHI,RLAMBDA0,PHI0,R
      R=6378206.4d0
      X=R*(RLAMBDA-RLAMBDA0)*COS(PHI0)
      Y=PHI*R
      RETURN
      END


C******************************************************************************
C                                                                             *
C    Transform from CPP coordinates to lon,lat (lamda,phi) coordinates        *
C    Lon,Lat is in radians.                                                   *
C                                                                             *
C******************************************************************************

      SUBROUTINE INVCP(XXCP,YYCP,RLAMBDA,PHI,RLAMBDA0,PHI0)
      REAL*8 XXCP,YYCP,RLAMBDA,PHI,RLAMBDA0,PHI0,R
      R=6378206.4d0
      RLAMBDA=RLAMBDA0+XXCP/(R*COS(PHI0))
      PHI=YYCP/R
      RETURN
      END
