c``````````````````````````````````````````````````````````````````````````````c
c  Brett D. Estrade							       c
c  Naval Research Laboratory, SSC					       c
c  ADCIRC's MCEL library file for MCEL Beta Review 			       c
c  July 2003								       c
c									       c
c``````````````````````````````````````````````````````````````````````````````c

      module COUPLING
         use GLOBAL
         use HARM
         use ITPACKV
#ifdef CMPI
         use MESSENGER
#endif
         use SIZES

	 integer,private :: PROGRAM_ID, ADC_GRID_ID, INTERP_ID
	 integer,private :: STRS_INTERP_ID, SSH_INTERP_ID
	 integer,private :: FFACTORS_INTERP_ID,TOT_BND_NODES
	 real*8,private  :: MCEL_GLOBAL_REF_TIME
         real*8,private  :: STRS_STARTING_TIME 

	 ! Used to retain NWS value if set to 1000 indicating
	 ! mcel as the radiation stress data source
	 ! Also, NWP_MCEL is used to retain the MCEL setting
	 ! that indicates using external bottom drag coefficients (fort.21)
	 integer :: NWS_MCEL,NWP_MCEL

         ! Mask constants         
	 integer,private ::  ADCIRC_MASK_INTERIOR, ADCIRC_MASK_BOUNDRY
	 integer,private ::  ADCIRC_MASK_ALL
	 integer,private ::  SSH_GET_COUNT, STRS_GET_COUNT	 
		 
 	 contains

	 subroutine ADDVARS_AND_REGGRID()
	   IMPLICIT NONE
	   include 'mpif.h'
	   include 'MCEL.inc'
	   integer,allocatable,dimension(:):: npvec
	   integer,allocatable,dimension(:):: mask
	   integer ierr,npglobal,mystart
	   character*300 :: ior
	   character*14 :: DATE_STR

	   !! Mask constants
	   
	   ADCIRC_MASK_INTERIOR = 1
	   ADCIRC_MASK_BOUNDRY = 2
	   ADCIRC_MASK_ALL = 3 
	   
	   !! Global reference TIME offest from 
	   !! ./mcel_global_ref_time.dat
	   
   	   open(unit=10,file='mcel_global_ref_time.dat')
             read(10,*) DATE_STR
           close(10)
	   
	   CALL YYYYMMDDHHMMSS2SECS(DATE_STR,MCEL_GLOBAL_REF_TIME)
	   
           !! Registering new program with MCELServer 
	   
	   call newProgram(PROGRAM_ID,"ADCIRC",ierr)
	   if ( ierr.gt.0 ) then
             print*,"Error obtaining PROGRAM_ID"
	   else
	     print*,"MCEL Info..."
	     print*,"PROGRAM ID =",PROGRAM_ID	     
	   endif

           !! Forming new grid

           call newGrid(ADC_GRID_ID,2,MCEL_GRIDTYPE_UNSTRUCTURED,
     &       MCEL_GRIDCENT_NODAL,MCEL_GRIDCOORD_LATLONG,
     &       ierr)
      
	   if ( ierr.gt.0 ) then
             print*,"Error obtaining ADC_GRID_ID"
	   else
	     print*,"GRID ID =",ADC_GRID_ID	     
	   endif

	   !! Set grid size -- "np" is the number of nodes

	   call setsize(ADC_GRID_ID,np,ierr)
	   if ( ierr.gt.0 ) then
             print*,"Error setting size of grid (",np," nodes)"
	   endif

           !! Set locations, ie set all the lat and long values from fort.14
	   !!   NOTE: SFEA = lat,SFEA = lon; also this is hardcoded
	   !!   for use with lat/lon grid retrieval, and doesn't
	   !!   check for x/y.......
       
       	   call setLocationsXY(ADC_GRID_ID,SLAM*RAD2DEG,
     &       SFEA*RAD2DEG,ierr)
     
	   if ( ierr.gt.0 ) then
             print*,"Error setting locations(lat/lon)"
	   endif

	   !! Alocate mask; maps all mask values for each node to 
	   !! 1 for interior and 2 for boundary

	   allocate(mask(np))
	   TOT_BND_NODES = 0
           mask = 1
	   DO K=1,NOPE
             DO I=1,NVDLL(K)
               mask(NBDV(K,I)) = 2
	     ENDDO	   	
	     TOT_BND_NODES = TOT_BND_NODES + NVDLL(K)
	   ENDDO
	   print*,TOT_BND_NODES, " total boundary nodes found."  
		  
	   call setMask(ADC_GRID_ID,mask,ierr)
	   if ( ierr.gt.0 ) then
             print*,"Error setting mask."
	   endif
	   deallocate(mask)

	   !! Set the grid

	   call setGrid(PROGRAM_ID,ADC_GRID_ID,ierr)
	   if ( ierr.gt.0 ) then
             print*,"Error setting grid."
	   else
	     print*,"Grid set..."
	   endif

	   !! Add Elevation Vars (fort.63)
	   IF (ABS(NOUTGE).EQ.20) THEN 
             call addVar(PROGRAM_ID,"wlev",MCEL_DATATYPE_DOUBLE,ierr)
	     if ( ierr.gt.0 ) then
               print*,"Error adding variable, wlev"
	     endif
	   ENDIF

           !! Add Velocity Vars (fort.64)
	   IF (ABS(NOUTGV).EQ.20) THEN 
             call addVar(PROGRAM_ID,"uavg",MCEL_DATATYPE_DOUBLE,ierr)
	     if ( ierr.gt.0 ) then
               print*,"Error adding variable, uavg"
	     endif
             call addVar(PROGRAM_ID,"vavg",MCEL_DATATYPE_DOUBLE,ierr)
	     if ( ierr.gt.0 ) then
               print*,"Error adding variable, vavg"
	     endif
	   ENDIF
	   
	   !! ~Parallel stuff~
#ifdef CMPI
           !!Set variable npvec's size to the index of the last proc
           allocate(npvec(0:mnproc-1))
	   !!Gather the value for np for each processor out there
	   !!and put them into the npvec array
           call MPI_Allgather(np,1,MPI_INTEGER,npvec,1,
     &       MPI_INTEGER,MPI_COMM_WORLD,ierr)
           !!Initialize npglobal to 0, and use a do loop
	   !!to get the total number of nodes by adding
	   !!up all the np's from all the procs
           npglobal = 0
	   do i = 0, mnproc - 1
	     npglobal = npglobal + npvec(i)
	   enddo	          
	   !!Initialize mystart to 0, then use a do loop
	   !!to figure out the starting poing of this particular
	   !!processor's nodal index in relation to the global list
	   mystart = 0
	   do i = 0, myproc - 1
	     mystart = mystart + npvec(i)
	   enddo
	   !!Make mcel calls with the above information gathered
	   call setglobalsize(ADC_GRID_ID,npglobal,ierr)
	   call setglobalstart(ADC_GRID_ID,mystart,ierr)
	   call setprocinfo(PROGRAM_ID,MNPROC,
     &       MYPROC,ierr)	   
#endif

           !! Finalize program registration
	   call finalize(PROGRAM_ID,ierr)
	   if ( ierr.gt.0 ) then
             print*,"Could not finalize program ?"
             print*,ierr
	     stop
	   endif	   
	 end subroutine ADDVARS_AND_REGGRID

!!
!!       WRITE ELEVATION (fort.63) DATA TO MCEL!!!!!!!!!!
!!

	 subroutine WRITE_MCEL_WLEV(TIME)
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr
	   real*8 TIME,reltime
	   	   	  
           reltime = TIME + MCEL_GLOBAL_REF_TIME
	   
	   call storeData(PROGRAM_ID,"wlev",ETA2,reltime,1.d0,
     &     MCEL_TIMECENT_POINT,ierr)

	   if ( ierr.ne.0 ) then
             print*,"Something odd!"
             stop
	   endif
	   
	 end subroutine WRITE_MCEL_WLEV

!!
!!       WRITE VELOCITY (fort.64) DATE TO MCEL!!!!!!!!!!
!!

	 subroutine WRITE_MCEL_UV(TIME)
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr
	   real*8 TIME,reltime
	   	   
	   reltime = TIME + MCEL_GLOBAL_REF_TIME

	write(990+myproc,*) uu2
	stop
	   call storeData(PROGRAM_ID,"uavg",UU2,reltime,1.d0,
     &     MCEL_TIMECENT_POINT,ierr)
	   
	   if ( ierr.ne.0 ) then
             print*,"Something odd!"
             stop
	   endif
	   
	   call storeData(PROGRAM_ID,"vavg",VV2,reltime,1.d0,
     &     MCEL_TIMECENT_POINT,ierr)
     
	   if ( ierr.ne.0 ) then
             print*,"Something odd!"
             stop
	   endif           
	
         end subroutine WRITE_MCEL_UV

!!
!!     GET WIND/WAVE STRESS (fort.23) DATA FROM SWAN via MCEL!!!!!!!!!!!
!! 

         subroutine ADD_STRS_OUTPUTS()
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,nvar
	   character*512 ior
     
	   !ior address for interpolation filter
	   open(unit=10,file='strs_interp.ior')
             read(10,*) ior
           close(10)
           
           !read in STRS_STARTING_TIMESTEP
           open(unit=10,file='strs_starting_time.dat')
             read(10,*) STRS_STARTING_TIME
           close(10)
	   
	   !initialized to 0
	   STRS_GET_COUNT = 0

!!     1. Create a new filter object from a factory with newFilter
	   
           !Setup interpolation filter as well	   
           call newfilter(STRS_INTERP_ID,ior,
     &     "Recv wave stress interpolation",ierr)
	   if (ierr.eq.0) then
             print *, 'Created the interpolation filter'
	     print *, "Wave Stress Filter ID: ",STRS_INTERP_ID
	   else
             print *, 'error while creating interpolation filter'
	   endif

	   nvar = 1

!!     2. Assign the inputs to this filter object with addSources

           !Set the source for UWForce to the main server
           call addsources(STRS_INTERP_ID,MCEL_SERVER,
     &       'U10',nvar,MCEL_DATATYPE_DOUBLE,ierr)
           if (ierr.eq.0) then
             print *, 'Added a U10 source'
           else
             print *, 'error while adding a source'
           endif      

           !Set the source for VWForce to the main server
           call addsources(STRS_INTERP_ID,MCEL_SERVER,
     &       'V10',nvar,MCEL_DATATYPE_DOUBLE,ierr)
           if (ierr.eq.0) then
             print *, 'Added a V10 source'
           else
             print *, 'error while adding a source'
           endif      
	    
!!     3. Assign the outputs to this filter objest with addOutputs

	   !Add outputs
	   call addoutputs(STRS_INTERP_ID,'U10',nvar,
     &      MCEL_DATATYPE_DOUBLE,ierr)
	   if (ierr.eq.0) then
	     print *, 'Added an MCEL output U10 (wave stress)'
	   else
	     print *, 'Error while adding an MCEL output, UWForce'
	   endif	  

           !Add outputs 
	   call addoutputs(STRS_INTERP_ID,'V10',nvar,
     &      MCEL_DATATYPE_DOUBLE,ierr)
	   if (ierr.eq.0) then
	     print *, 'Added an MCEL output V10 (wave stress)'
	   else
	     print *, 'Error while adding an MCEL output, V10'
	   endif	  

!!     4. If required assign the output grid to the filter with setOutputGrid

           !Define the output grid to be the main program grid 
           call setoutputgrid(STRS_INTERP_ID,ADC_GRID_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Set the output grid'
           else
             print *, 'error while creating the output grid'
           endif

!!     5. Request data from the filter with getData

           !Finish up adding the filters
           call finalizefilters(STRS_INTERP_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Finalize the filter'
           else
             print *, 'error while finalizing the filter'
           endif	  
	 end subroutine ADD_STRS_OUTPUTS
	 
         subroutine READ_MCEL_STRS(TIME,uWForceRet,vWForceRet)
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,I
           real*8 TIME,reltime
           real*8 uWForceRet(NP),vWForceRet(NP)
	   real*8 umag(NP)

        print*,time,strs_starting_time,"hhhh"

	   ! Initialize data to 0.0
	   uWForceRet = 0.0d0
           vWForceRet = 0.0d0
	      
           if(TIME.GE.STRS_STARTING_TIME) then	                     		  
	     ! Subtract RSTIMINC from reltime because
             ! ADCIRC needs to get the data the time RSTIMINC seconds
             ! prior to the actual time 
	     reltime = TIME + MCEL_GLOBAL_REF_TIME - 2*RSTIMINC

             print*,time,MCEL_GLOBAL_REF_TIME,reltime,RSTIMINC
	     
	     ! The first 2 gets should be returned with
	     ! 0.0s if not in MCEL
	     if(STRS_GET_COUNT.GT.2)then
               print*,"Attempting to fetch Wave Stress..."

	       call getData(STRS_INTERP_ID,"U10",uWForceRet,      
     &          reltime,reltime,MCEL_TIMECENT_POINT,ADCIRC_MASK_ALL,  
     &          MCEL_FETCHPOLICY_BLOCK,ierr)  		      
	       if (ierr.eq.0) then				      
	          print *, 'Got UWForce from MCEL for (abs)TIME', reltime 
	       else						      
	          print *, 'Data not present UWForce set to 0.0'      
	       endif						      
 
	       call getData(STRS_INTERP_ID,"V10",vWForceRet,      
     &           reltime,reltime,MCEL_TIMECENT_POINT,ADCIRC_MASK_ALL, 
     &           MCEL_FETCHPOLICY_BLOCK,ierr) 	      
	       if (ierr.eq.0) then				      
	          print *, 'Got VWForce from MCEL for (abs)TIME', reltime 
	       else						      
	          print *, 'Data not present VWForce set to 0.0'  
		  ! Explicitly data to 0.0
                  uWForceRet = 0.0d0
                  vWForceRet = 0.0d0
	       endif
	     else  
	       print *, 'UWForce set to 0.0' 
	       print *, 'VWForce set to 0.0'	       	  
	     endif		
	     
	     STRS_GET_COUNT = STRS_GET_COUNT + 1
	   else
	     print *, 'UWForce set to 0.0' 
	     print *, 'VWForce set to 0.0'
	   endif
           umag = sqrt(uWForceRet*uWForceRet+vWForceRet*vWForceRet)
           uWForceRet=1.3d-3*(.44+.063*umag)*umag*uWForceRet
           vWForceRet=1.3d-3*(.44+.063*umag)*umag*vWForceRet

	   ! Divide stress by reference density of water
           uWForceRet = uWForceRet/RHOWAT0
           vWForceRet = vWForceRet/RHOWAT0

	   ! Dump out to file
	   if(NWS_MCEL.EQ.-1000) then
	     open(123,FILE=DIRNAME//'/'//'fort.123',
     &	      ACCESS='SEQUENTIAL',POSITION='APPEND')
	       write(123,*)' '
	       write(123,*) TIME, reltime
	       write(123,*) uWForceRet
	     close(123)
	     open(223,FILE=DIRNAME//'/'//'fort.223',
     &	      ACCESS='SEQUENTIAL',POSITION='APPEND')
	       write(223,*)' '
	       write(223,*) TIME, reltime
	       write(223,*) vWForceRet
	     close(223)
	   endif	      
         end subroutine READ_MCEL_STRS	
	
!!
!!     GET Sea Surface Heights (fort.19) DATA FROM NCOM via MCEL!!!!!!!!!!!
!!

         subroutine ADD_SSH_OUTPUTS()
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,nvar
	   character*512 ior

	   !ior address for interpolation filter
	   open(unit=10,file='ssh_interp.ior')
             read(10,*) ior
           close(10)

           !initialize to 0
           SSH_GET_COUNT = 0

!!     1. Create a new filter object from a factory with newFilter
	   
           !Setup interpolation filter as well	   
           call newfilter(SSH_INTERP_ID,ior,
     &     "Recv sea surface height interpolation",ierr)
	   if (ierr.eq.0) then
             print *, 'Created the interpolation filter'
	     print *, "Sea Surface Height Filter ID: ",SSH_INTERP_ID
	   else
             print *, 'Error while creating interpolation filter'
	   endif

	   nvar = 1

!!     2. Assign the inputs to this filter object with addSources

           !Set the source for botdrag to the main server
           call addsources(SSH_INTERP_ID,MCEL_SERVER,
     &       'SSH_NCOM',nvar,MCEL_DATATYPE_DOUBLE,ierr)
           if (ierr.eq.0) then
             print *, 'Added a SSH_NCOM source'
           else
             print *, 'Error while adding a SSH_NCOM source'
           endif      
	    
!!     3. Assign the outputs to this filter objest with addOutputs

           !Add outputs 
	   call addoutputs(SSH_INTERP_ID,
     &       'SSH_NCOM',nvar,MCEL_DATATYPE_DOUBLE,ierr)
	   if (ierr.eq.0) then
	     print *, 'Added an MCEL output SSH_NCOM (sea surface height)'
	   else
	     print *, 'Error while adding an MCEL output, ssh'
	   endif	  

!!     4. If required assign the output grid to the filter with setOutputGrid

           !Define the output grid to be the main program grid 
           call setoutputgrid(SSH_INTERP_ID,ADC_GRID_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Set the output grid'
           else
             print *, 'Error while creating the output grid'
           endif

!!     5. Request data from the filter with getData

           !Finish up adding the filters
           call finalizefilters(SSH_INTERP_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Finalize the filter'
           else
             print *, 'Error while finalizing the filter'
           endif	   
	 end subroutine ADD_SSH_OUTPUTS

         subroutine READ_MCEL_SSH(TIME,ESBIN,GET)
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,GET
	   real*8 TIME, reltime
	   real*8 ESBIN(TOT_BND_NODES), ESBINTMP(NP)

           !initialize ESBIN
           ESBIN = 0.0d0

           SSH_GET_COUNT = SSH_GET_COUNT + 1				        
           								        
           ! Relative TIME offset					        
           reltime = TIME + MCEL_GLOBAL_REF_TIME			        

           if (GET.eq.1) then
             call getData(SSH_INTERP_ID,"SSH_NCOM",ESBINTMP,	      	        
     &       reltime,reltime,MCEL_TIMECENT_POINT,ADCIRC_MASK_BOUNDRY,	        
     &       MCEL_FETCHPOLICY_BLOCK,ierr)				        
             if (ierr.eq.0) then  				      	        
                print *, 'Got SSH_NCOM from MCEL for (abs)TIME',reltime          
             else 						      	        
                print *, 'HALT: Data not present in SSH_NCOM ..',reltime 				        
                stop		
             endif      		
           else
	     print *, "Skipping MCEL request...."					        
	   endif					        

           ! Pass on only boundary node info using same technique as mask set   
           DO K=1,NOPE							        
             DO I=1,NVDLL(K)						        
               ESBIN(I) = ESBINTMP(NBDV(K,I))				        
             ENDDO	      						        
           ENDDO							        

           open(119,FILE=DIRNAME//'/'//'fort.119',			        
     &       ACCESS='SEQUENTIAL',POSITION='APPEND')			        
             ! If this is the first write, list global nodes		        
             ! designated as boundary nodes	 			        
             if(SSH_GET_COUNT.EQ.1)then 				        
               open(120,FILE=DIRNAME//'/'//'MY.BND.NODES.dat',		        
     &  	 ACCESS='SEQUENTIAL')					        
               write(120,*) TOT_BND_NODES				        
               DO K=1,NOPE						        
        	 DO I=1,NVDLL(K)					        
        	   write(120,*) NBDV(K,I)				        
        	 ENDDO  	      					        
               ENDDO							        
               close(120)	     					        
               write(119,*) ETIMINC					        				        
             endif							        
             !Output in standard fort.19 format 			        
             !An easy way to get viable fort.19 is			        
             !to run in serial mode					        
             DO K=1,NOPE						        
               DO I=1,NVDLL(K)						        
        	 write(119,*) ESBIN(I)					        
               ENDDO							        
             ENDDO							        
           close(119)							        	   
         end subroutine READ_MCEL_SSH


!!
!!     GET Bottom Friction (fort.21) DATA FROM LSOM via MCEL!!!!!!!!!!!
!!

         subroutine ADD_FFACTORS_OUTPUTS()
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,nvar
	   character*512 ior

	   !ior address for interpolation filter
	   open(unit=10,file='ffactors_interp.ior')
             read(10,*) ior
           close(10)

!!     1. Create a new filter object from a factory with newFilter
	   
           !Setup interpolation filter as well	   
           call newfilter(FFACTORS_INTERP_ID,ior,
     &     "Recv bottom friction interpolation",ierr)
	   if (ierr.eq.0) then
             print *, 'Created the interpolation filter'
	     print *, "Bottom Drag Filter ID: ",FFACTORS_INTERP_ID
	   else
             print *, 'error while creating interpolation filter'
	   endif

	   nvar = 1

!!     2. Assign the inputs to this filter object with addSources

           !Set the source for botdrag to the main server
           call addsources(FFACTORS_INTERP_ID,MCEL_SERVER,
     &       'botdrag',nvar,MCEL_DATATYPE_DOUBLE,ierr)
           if (ierr.eq.0) then
             print *, 'Added a botdrag (FRIC(NP)) source'
           else
             print *, 'error while adding a source'
           endif      
	    
!!     3. Assign the outputs to this filter objest with addOutputs

           !Add outputs 
	   call addoutputs(FFACTORS_INTERP_ID,
     &       'botdrag',nvar,MCEL_DATATYPE_DOUBLE,ierr)
	   if (ierr.eq.0) then
	     print *, 'Added an MCEL output botgrag (bottom friction)'
	   else
	     print *, 'Error while adding an MCEL output, botgrag'
	   endif	  

!!     4. If required assign the output grid to the filter with setOutputGrid

           !Define the output grid to be the main program grid 
           call setoutputgrid(FFACTORS_INTERP_ID,ADC_GRID_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Set the output grid'
           else
             print *, 'error while creating the output grid'
           endif

!!     5. Request data from the filter with getData

           !Finish up adding the filters
           call finalizefilters(FFACTORS_INTERP_ID,ierr)
           if (ierr.eq.0) then
             print *, 'Finalize the filter'
           else
             print *, 'error while finalizing the filter'
           endif
	   
	 end subroutine ADD_FFACTORS_OUTPUTS

         subroutine READ_MCEL_FFACTORS(FRIC)
	   IMPLICIT NONE
	   include 'MCEL.inc'
	   integer ierr,I
	   real*8 FRIC(NP)
	   
           print*,"Getting spatially variable bottom drag"   
	      
	   call getData(FFACTORS_INTERP_ID,"botdrag",FRIC,
     &      0,0,MCEL_TIMECENT_POINT,ADCIRC_MASK_ALL,
     &      MCEL_FETCHPOLICY_BLOCKING,ierr)
	   if (ierr.eq.0) then
	      print *, 'Got botdrag from MCEL...'
	   else
	      print *, 'Error while getting botdrag', ierr
	   endif
	      
	   ! Dump out to file
	   if(NWP_MCEL.EQ.-1000) then
	     open(121,FILE=DIRNAME//'/'//'fort.121',
     &	      ACCESS='SEQUENTIAL',POSITION='APPEND')
	       write(121,*)' '
	       write(121,*) FRIC
	     close(121)
	   endif
         end subroutine READ_MCEL_FFACTORS

	end module coupling

