C******************************************************************************
C PADCIRC RELEASE VERSION 43.03 05/20/2003                                    *
C  last changes in this file VERSION 43.03                                    *
C                                                                             *
C  mod history                                                                *
C  v43.03     - 05/20/03 - rl - from 43.02 - parallel wind stuff (m.brown)    *
C                                          output buffer flush (m.cobb)       *
C                                          3D fixes (k.dresback)              *
C                                          drop MNPROC in fort.15 (t.campbell)*
C                                          various bug fixes in RBCs          *
c                                          ZSURFBUOY/BCPG calc                *
C  v43.02     - 02/06/03 - rl - from 43.01 - code clean up & documentation    *
C  v43.01     - 01/31/03 - jf - from 43.00 - reconcile with v42.07 2D code    *
C                                            changed var. names: UBAR1->UU1,  *
C                                            VBAR1->VV1, UBAR2->UU2, VBAR2->  *
C                                            VV2, TAUSX1->WSX1, TAUSY1->WSY1, *
C                                            TAUSX2->WSX2, TAUSY2->WSY2,      *
C                                            TAUBX1->BSX1, TAUBY1->BSY1,      *
C                                            TAUBXN1->BSXN1, TAUBXN2->BSXN2,  *
C                                            TAUBXN3->BSXN3, TAUBYN1->BSYN1,  *
C                                            TAUBYN2->BSYN2, TAUBYN3->BSYN3,  *
C                                            TAUBXPP3->BSXPP3,TAUBYPP3->BSYPP3*
C  v43.00b    - 12/11/02 - jf - from 43.00a - bug fixes                       *
C  v43.00a    - sum  /02 - tc - from 36.01 (3D) & 41.12? (2D), create F90/    *
C                                               parallel unified 2D/3D source *
C  v41.10     - 07/25/01 - rl - from 41.09 - bug fix in GWCE lateral visc term*
C  v41.09     - 06/30/01 - jw - from 41.08 - minor mods per vp version 41.05  *
C  v41.08     - 06/22/01 - rl - from 41.07 - reconciled with v41.05m009       *
C                                            changes to HABSMIN and ETA2      *
C  v41.07     - 04/09/01 - rl - from 41.06 - initialized PRN1(),PRN2() for    *
C                                                                      NRS<>0 *
C  v41.06      - 04/02/01 - rl - changed MNWP to MNP in wind forcing          *
C                                ALLOCATION statements                        *
C  v41.02      - 09/04 - rl                                                   *
C  v40.02m004b - 05/17 - vjp - corrected dimensioning problem cvjpm004b       *
C  v40.02m001  - 12/21 - jjw - add cross barrier pipes cjjwm001               *
C                                                                             *
C******************************************************************************

C 
      MODULE GLOBAL
      USE SIZES

C...
C...SET GLOBAL PARAMETER CONSTANTS
C...

C.....nominal density of water RHOWAT0
      REAL(SZ), PARAMETER ::  RHOWAT0=1000.D0

C.....Sigma T value of reference density
      REAL(SZ), PARAMETER ::  SIGT0=RHOWAT0-1000.D0 

C.....PI and degrees to radians conversions
      REAL(8), PARAMETER  ::  PI=3.141592653589793D0
      REAL(8), PARAMETER  ::  DEG2RAD = PI/180.D0
      REAL(8), PARAMETER  ::  RAD2DEG = 180.D0/PI

C.....parameters used in barrier overflow 
      REAL(SZ), PARAMETER ::  BARMIN=0.04D0
      REAL(SZ) DEPAVG,DEPMAX,DEPMIN

C...
C...DECLARE ALL ARRAYS
C...
#ifdef CMPI
      INTEGER, ALLOCATABLE ::   IDUMY(:)
      REAL(SZ),ALLOCATABLE ::   DUMY1(:),DUMY2(:)
#endif

      REAL(SZ),ALLOCATABLE ::   ETAS(:),ETA1(:),ETA2(:)
      REAL(SZ),ALLOCATABLE ::   UU1(:),UU2(:),VV1(:),VV2(:)
      REAL(SZ),ALLOCATABLE ::   DP(:),SFAC(:),STARTDRY(:)
      REAL(SZ),ALLOCATABLE ::   QU(:),QV(:),QW(:)
      REAL(SZ),ALLOCATABLE ::   FRIC(:),CORIF(:),EVM(:)
      REAL(SZ),ALLOCATABLE ::   TPK(:),FFT(:)
      REAL(SZ),ALLOCATABLE ::   FACET(:),ETRF(:)
      REAL(SZ),ALLOCATABLE ::   ESBIN1(:),ESBIN2(:)
      REAL(SZ),ALLOCATABLE ::   QTEMA(:,:),QTEMB(:,:)
      REAL(SZ),ALLOCATABLE ::   QN0(:),QN1(:),QN2(:)
      REAL(SZ),ALLOCATABLE ::   EN0(:),EN1(:),EN2(:)
      REAL(SZ),ALLOCATABLE ::   BNDLEN2O3(:)
      REAL(SZ),ALLOCATABLE ::   CSII(:),SIII(:)
      REAL(SZ),ALLOCATABLE ::   ZNGIF1(:),ZNGIF2(:),ZNGIF3(:)
      REAL(SZ),ALLOCATABLE ::   QNAM(:,:),QNPH(:,:)
      REAL(SZ),ALLOCATABLE ::   ENAM(:,:),ENPH(:,:)
      REAL(SZ),ALLOCATABLE ::   QNIN1(:),QNIN2(:)
      REAL(SZ),ALLOCATABLE ::   ENIN1(:),ENIN2(:)
      REAL(SZ),ALLOCATABLE ::   CSI(:),SII(:)
      REAL(SZ),ALLOCATABLE ::   TAU0VAR(:)
      REAL(SZ),ALLOCATABLE ::   ET00(:)
      REAL(SZ),ALLOCATABLE ::   STAIE1(:),STAIE2(:),STAIE3(:)
      REAL(8), ALLOCATABLE ::   XEV(:),YEV(:),SLEV(:),SFEV(:)
      REAL(SZ),ALLOCATABLE ::   UU00(:),VV00(:)
      REAL(SZ),ALLOCATABLE ::   STAIV1(:),STAIV2(:),STAIV3(:)
      REAL(8), ALLOCATABLE ::   XEC(:),YEC(:),SLEC(:),SFEC(:)
      REAL(SZ),ALLOCATABLE ::   CC00(:)
      REAL(SZ),ALLOCATABLE ::   STAIC1(:),STAIC2(:),STAIC3(:)
      REAL(8), ALLOCATABLE ::   XEM(:),YEM(:),SLEM(:),SFEM(:)
      REAL(SZ),ALLOCATABLE ::   RMU00(:),RMV00(:),RMP00(:)
      REAL(SZ),ALLOCATABLE ::   STAIM1(:),STAIM2(:),STAIM3(:)
      REAL(SZ),ALLOCATABLE ::   CH1(:),QB(:),QA(:),SOURSIN(:),EVC(:)
      REAL(SZ),ALLOCATABLE ::   WSX1(:),WSY1(:),PR1(:)
      REAL(SZ),ALLOCATABLE ::   WSX2(:),WSY2(:),PR2(:)
      REAL(SZ),ALLOCATABLE ::   WVNX1(:),WVNY1(:),PRN1(:)
      REAL(SZ),ALLOCATABLE ::   WVNX2(:),WVNY2(:),PRN2(:)
      REAL(SZ),ALLOCATABLE ::   RSNX1(:),RSNY1(:),RSNX2(:),RSNY2(:)
      REAL(SZ),ALLOCATABLE ::   WVNXOUT(:),WVNYOUT(:)
      REAL(SZ),ALLOCATABLE ::   TK(:)
      REAL(8), ALLOCATABLE ::   EMO(:,:),EFA(:,:)
      REAL(8), ALLOCATABLE ::   XEL(:),YEL(:),SLEL(:),SFEL(:)
      REAL(8) ,ALLOCATABLE ::   AREAS(:)
      REAL(SZ),ALLOCATABLE ::   XVELAV(:),YVELAV(:),XVELVA(:),YVELVA(:)
      REAL(SZ),ALLOCATABLE ::   ELAV(:),ELVA(:)
      REAL(SZ),ALLOCATABLE ::   AUV11(:),AUV12(:),AUV13(:),AUV14(:)
      REAL(SZ),ALLOCATABLE ::   DUU1(:),DUV1(:),DVV1(:),BSX1(:),BSY1(:)
      REAL(SZ),ALLOCATABLE ::   TIP1(:),TIP2(:)
      REAL(SZ),ALLOCATABLE ::   SALTAMP(:,:),SALTPHA(:,:)
      REAL(SZ),ALLOCATABLE ::   OBCCOEF(:,:),COEF(:,:)
      REAL(SZ),ALLOCATABLE ::   WKSP(:),RPARM(:)
      REAL(SZ),ALLOCATABLE ::   ABD(:,:),ZX(:)

      INTEGER,ALLOCATABLE ::    ME2GW(:)
      INTEGER,ALLOCATABLE ::    NBV(:),LBCODEI(:)
      INTEGER,ALLOCATABLE ::    NEleZNG(:)
      INTEGER,ALLOCATABLE ::    NNODECODE(:),NODECODE(:),NODEREP(:)
      INTEGER,ALLOCATABLE ::    NIBCNT(:)
      INTEGER,ALLOCATABLE ::    NM(:,:)
      INTEGER,ALLOCATABLE ::    NNEIGH(:),MJU(:),NODELE(:)
      INTEGER,ALLOCATABLE ::    NEITAB(:,:),NEITABELE(:,:)
      INTEGER,ALLOCATABLE ::    NIBNODECODE(:)
      INTEGER,ALLOCATABLE ::    LBArray_Pointer(:)
      INTEGER,ALLOCATABLE ::    NNC(:)
      INTEGER,ALLOCATABLE ::    NNE(:)
      INTEGER,ALLOCATABLE ::    NNV(:)
      INTEGER,ALLOCATABLE ::    NNM(:)
      INTEGER,ALLOCATABLE ::    IWKSP(:),IPARM(:),IPV(:)
      INTEGER,ALLOCATABLE ::    NVDLL(:),NBD(:)
      INTEGER,ALLOCATABLE ::    NBDV(:,:)
      INTEGER,ALLOCATABLE ::    NVELL(:)
      INTEGER,ALLOCATABLE ::    NBVV(:,:)

C.....for buoyancy forcing in 2D
      REAL(SZ),ALLOCATABLE ::   VIDBCPDX1(:),VIDBCPDY1(:)

C.....for internal barrier boundaries with flowthrough pipes
      REAL(SZ),ALLOCATABLE ::   BARLANHTR(:),BARLANCFSPR(:)
      REAL(SZ),ALLOCATABLE ::   BARINHTR(:),BARINCFSBR(:),BARINCFSPR(:)
      REAL(SZ),ALLOCATABLE ::   PIPEHTR(:),PIPECOEFR(:),PIPEDIAMR(:)
      REAL(SZ),ALLOCATABLE ::   BARLANHT(:),BARLANCFSP(:)
      REAL(SZ),ALLOCATABLE ::   FFF(:),FFACE(:)
      REAL(SZ),ALLOCATABLE ::   BTRAN3(:),BTRAN4(:),BTRAN5(:)
      REAL(SZ),ALLOCATABLE ::   BTRAN6(:),BTRAN7(:),BTRAN8(:)
      REAL(SZ),ALLOCATABLE ::   BARINHT(:),BARINCFSB(:),BARINCFSP(:)
      REAL(SZ),ALLOCATABLE ::   PIPEHT(:),PIPECOEF(:),PIPEDIAM(:)
      REAL(SZ),ALLOCATABLE ::   RBARWL1AVG(:),RBARWL2AVG(:)
      REAL(SZ),ALLOCATABLE ::   RPIPEWL1AVG(:),RPIPEWL2AVG(:)
      INTEGER, ALLOCATABLE ::   IBCONN(:),IBCONNR(:),NTRAN1(:),NTRAN2(:)

C.....for bridge pilings
      REAL(SZ)                  POAN,Fr,FRICBP
      INTEGER                   NBPNODES
      REAL(SZ),ALLOCATABLE ::   BK(:),BALPHA(:),BDELX(:)
      INTEGER, ALLOCATABLE ::   NBNNUM(:)

C...
C...DECLARE COMMON BLOCKS
C...
      INTEGER NTSTEPS,ITMV
      REAL(SZ) DT,FMV
      REAL(8) TIMEBEG
      COMMON /MEANSQ/ TIMEBEG,DT,FMV,NTSTEPS,ITMV
C
      INTEGER NHARFR
      COMMON /LSQFREQS/ NHARFR
C     
      INTEGER NP,NOLICA,NOLIFA,NSCREEN,IHOT,ICS

C...
C...DECLARE REAL(8) AND CHAR VARIABLES, EQUIVALENCES
C...
      REAL(8) STATIM,REFTIM,TIME,DTDP,TIMEH
      REAL(8) AVGXY,DIF1R,DIF2R,DIF3R
      REAL(8) AEMIN,AE,AA,A1,A2,A3,X1,X2,X3,X4,Y1,Y2,Y3,Y4
      REAL(8) FDX1,FDX2,FDX3,FDY1,FDY2,FDY3
      REAL(8) FDX1OA,FDX2OA,FDX3OA,FDY1OA,FDY2OA,FDY3OA,AREAIE
      REAL(8) DDX1,DDX2,DDX3,DDY1,DDY2,DDY3
      REAL(8) DXX11,DXX12,DXX13,DXX21,DXX22,DXX23,DXX31,DXX32,DXX33
      REAL(8) DYY11,DYY12,DYY13,DYY21,DYY22,DYY23,DYY31,DYY32,DYY33
      REAL(8) DXY11,DXY12,DXY13,DXY21,DXY22,DXY23,DXY31,DXY32,DXY33
      REAL(8) XL0,XL1,XL2,YL0,YL1,YL2,SLAM0,SFEA0
      REAL(8) WREFTIM,WTIMED,WTIME2,WTIME1,WTIMINC,QTIME1,QTIME2
      REAL(8) FTIMINC,ETIMINC,RSTIME1,RSTIME2,RSTIMINC
      REAL(8) DELX,DELY,DIST,DELDIST,DELETA
      REAL(8),ALLOCATABLE :: AMIG(:),AMIGT(:),FAMIG(:)
      REAL(8),ALLOCATABLE :: PER(:),PERT(:),FPER(:)
      REAL(8),ALLOCATABLE :: FREQ(:),FF(:),FACE(:)
      REAL(8),ALLOCATABLE :: SLAM(:),SFEA(:),X(:),Y(:)

      CHARACTER*32 RUNDES
      CHARACTER*24 RUNID,AGRID,AGRID2,AFRIC
      CHARACTER*4  RDES4(8),RID4(6),AID4(6)
      CHARACTER*8  RDES8(4),RID8(3),AID8(3)
      CHARACTER*10 ALPHA
      CHARACTER*5,ALLOCATABLE :: TIPOTAG(:),BOUNTAG(:),FBOUNTAG(:)
      EQUIVALENCE (RDES4(1),RDES8(1),RUNDES), (RID4(1),RID8(1),RUNID),
     &            (AID4(1),AID8(1),AGRID)

C...
C...EXPLICITLY DECLARE ADDITIONAL VARIABLES
C...
      INTEGER  NODEDRYMIN,NODEWETMIN,I,IBTYPE,ICK
      INTEGER  IDR,IM,IPRBI,J,JGW,JKI,JME
      INTEGER  JNMM,K,KMIN,N,N1,N2,N3,NABOUT
      INTEGER  NBFR,NBOU,NBVI,NBVJ,NCOR,NE,NE2,NP2
      INTEGER  NEIMIN,NEIMAX,NETA,NFFR
      INTEGER  NFLUXB,NFLUXF,NFLUXIB,NFLUXRBC
      INTEGER  NFLUXGBC
      INTEGER  NFLUXIBP,NPIPE
      INTEGER  NFOVER,NHG,NHY,NOLIBF,NOLICAT,NOPE,NOUTC
      INTEGER  NOUTE,NSPOOLE,NOUTV,NSPOOLV,NPRBI
      INTEGER  NRAMP,NRS,NSTAE,NSTARTDRY,NSTAV,NT,NTCYFE
      INTEGER  NTCYFV,NTCYSE,NTCYSV,NTIF,NTIP,NTRSPE,NTRSPV
      INTEGER  NVEL,NVELEXT,NVELME,NWLAT,NWLON,NWP,NWS
      INTEGER  IBSTART, ICHA, ICSTP, IDSETFLG, IE, IER
      INTEGER  IESTP, IFHYBF, IFLINBF, IFNLBF
      INTEGER  IFNLCAT, IFNLCT, IFNLFA
      INTEGER  IFWIND, IGCP, IGEP, IGPP, IGVP, IGWP, IHABEG
      INTEGER  IHARIND, IHOTSTP, IHSFIL, IJ, ILUMP, IMHS, IPSTP
      INTEGER  IREFYR,IREFMO,IREFDAY,IREFHR,IREFMIN, ISLDIA
      INTEGER  ITIME, ITEMPSTP, ITEST, ITHAF, ITHAS
      INTEGER  ITHS, ITITER, ITMAX, IVSTP, IWSTP, IWTIME, IWTIMEP
      INTEGER  IWYR, J12, J13, J21, J23, J31, J32
      INTEGER  JJ, JN, KEMAX, KVMAX, LRC, LUMPT, MAX
      INTEGER  MBW, MDF, MIN, NA, NBDI, NBDJ, NBNCTOT
      INTEGER  NBW, NC1, NC2, NC3, NCBND
      INTEGER  NCELE, NCI, NCJ, NCTOT, NCYC, NDRY, NDSETSC
      INTEGER  NDSETSE, NDSETSV, NDSETSW, NEle, NHAGE, NHAGV
      INTEGER  NHAINC, NHASE, NHASV, NHSINC, NHSTAR, NM1, NM123, NM2
      INTEGER  NM3, NMI1, NMI2, NMI3, NMJ1, NMJ2, NMJ3, NNBB, NNBB1
      INTEGER  NNBB2, NNFirst, NOUTGC, NOUTGE, NOUTGV, NOUTGW, NOUTM
      INTEGER  NSCOUC, NSCOUE, NSCOUGC, NSCOUGE, NSCOUGV
      INTEGER  NSCOUGW, NSCOUM, NSCOUV, NSPOOLC, NSPOOLGC, NSPOOLGE
      INTEGER  NSPOOLGV, NSPOOLGW, NSPOOLM
      INTEGER  NSTAC, NSTAM, NTCYFC, NTCYFGC, NTCYFGE
      INTEGER  NTCYFGV, NTCYFGW
      INTEGER  NTCYFM, NTCYSC, NTCYSGC, NTCYSGE
      INTEGER  NTCYSGV, NTCYSGW, NTCYSM
      INTEGER  NTRSPC, NTRSPM, NUMITR, NW, NWET, NWSEGWI, NWSGGWI
      INTEGER  NCCHANGE
C
      REAL(SZ) ADVECX, ADVECY, AGIRD, AH, AO12, AO6, ARG
      REAL(SZ) ARG1, ARG2, ARGJ, ARGJ1, ARGJ2, ARGSALT, ARGT
      REAL(SZ) ARGTP, AUV21, AUV22
      REAL(SZ) BARAVGWT, BEDSTR, BNDLEN2O3NC, BSXN1
      REAL(SZ) BSXN2, BSXN3, BSXPP3, BSYN1, BSYN2, BSYN3, BSYPP3
      REAL(SZ) C1, C2, C3, CBEDSTRD, CBEDSTRE, CCRITD, CCSFEA
      REAL(SZ) CELERITY, CH1N1, CH1N2, CH1N3, CHSUM, COND, CONVCR
      REAL(SZ) CORIFPP, DDU, DHDX, DHDY
      REAL(SZ) DISPERX, DISPERY, DT2, DTO2, DTOHPP, DUU1N1, DUU1N2
      REAL(SZ) DUU1N3, DUV1N1, DUV1N2, DUV1N3, DVV1N1, DVV1N2, DVV1N3
      REAL(SZ) DXXYY11, DXXYY12, DXXYY13, DXXYY21
      REAL(SZ) DXXYY22, DXXYY23, DXXYY31
      REAL(SZ) DXXYY32, DXXYY33, DXYH11, DXYH12
      REAL(SZ) DXYH13, DXYH21, DXYH22
      REAL(SZ) DXYH23, DXYH31, DXYH32, DXYH33, E0N1, E0N2, E0N3
      REAL(SZ) E1N1, E1N1SQ, E1N2, E1N2SQ, E1N3, E1N3SQ, ECONST
      REAL(SZ) EE1, EE2, EE3, ELMAX, EP, ESN1, ESN2
      REAL(SZ) ESN3, ETIME1, ETIME2, ETRATIO, EVC1, EVC2, EVC3
      REAL(SZ) EVCEA, EVMPPODT, EVMPPDT, FDDD, FDDDODT, FDDOD, FDDODODT
      REAL(SZ) FIIN, G, GA00, GB00A00, GC00, GDTO2, GFAO2, GFac
      REAL(SZ) GHPP, GO3, HABSMIN, HEA, HH1, HH1N1, HH1N2
      REAL(SZ) HH1N3, HH2, HH2N1, HH2N2, HH2N3, HHU1N1, HHU1N2
      REAL(SZ) HHU1N3, HHV1N1, HHV1N2, HHV1N3, HPP, HSD, HSE
      REAL(SZ) HTOT, hAvg

      REAL(SZ) P11, P22, P33, PR1N1, PR1N2, PR1N3, QFORCEI
      REAL(SZ) QFORCEJ, QTEMA1, QTEMA2, QTEMA3, QTEMB1, QTEMB2, QTEMB3
      REAL(SZ) QTRATIO, QUNORM, QUTemp, QVNORM, RAMP1, RAMP2, RBARWL
      REAL(SZ) RBARWL1,RBARWL1F, RBARWL2, RBARWL2F, RFF, RFF1, RFF2
      REAL(SZ) RHO0, RSTRATIO, RSX, RSY
      REAL(SZ) S2SFEA, SADVDTO3, SALTMUL, SFACPP, SS1N1, SS1N2, SS1N3
      REAL(SZ) T0N1, T0N2, T0N3, T0XN1, T0XN2, T0XN3, T0XPP3
      REAL(SZ) T0YN1, T0YN2, T0YN3, T0YPP3, TADVODT, TAU0AVG
      REAL(SZ) THAF, THAS, THENALLDSSSTUP, TIMEIT, TIPN1,TOUTFC
      REAL(SZ) TIPN2, TIPN3, TKWET, TOUTFGC, TOUTFGE, TOUTFGV, TOUTFGW
      REAL(SZ) TOUTFM, TOUTSGC, TOUTSGE, TOUTSGV, TOUTSGW, TOUTSM, TPMUL
      REAL(SZ) TT0L, TT0R, U11, U1N1, U1N2, U1N3, U22
      REAL(SZ) U33, UEA, UHPP, UHPP3, UN1, UPEA, UPP
      REAL(SZ) UPPDT, UPPDTDDX1, UPPDTDDX2, UPPDTDDX3, UV1, V11, V1N1
      REAL(SZ) V1N2, V1N3, V22, V33, VCOEF1, VCOEF2, VCOEF3N1
      REAL(SZ) VCOEF3N2, VCOEF3N3, VCOEF3X, VCOEF3Y, VEA, VEL, VELABS
      REAL(SZ) VELMAX, VELNORM, VELTAN, VHPP, VHPP3, VPEA, VPP
      REAL(SZ) VPPDT, VPPDTDDY1, VPPDTDDY2, VPPDTDDY3
      REAL(SZ) WDRAGCO, WINDMAG, WINDX
      REAL(SZ) WINDY, WS, WSMOD, WSX, WSXN1, WSXN2, WSXN3
      REAL(SZ) WSY, WSYN1, WSYN2, WSYN3, WTRATIO,A00,B00,C00,ANGINN
      REAL(SZ) CF,CORI,COSTHETA,COSTHETA1,COSTSET,CROSS,CROSS1
      REAL(SZ) DAY,DOTVEC,DRAMP,DUM1,DUM2,ESLM,ESLC
      REAL(SZ) HBREAK,FGAMMA,FTHETA,H0
      REAL(SZ) RNDAY,TAU,TAU0,THETA,THETA1,TOUTSC,RAMP
      REAL(SZ) TOUTSE,TOUTFE
      REAL(SZ) TOUTSV,TOUTFV,XL
      REAL(SZ) VECNORM,VL1X,VL1Y,VL2X,VL2Y,WLATMAX
      REAL(SZ) WLONMIN,WLATINC,WLONINC, VELMIN
      REAL(SZ) ZNGLHS,ZNGRHS1,ZNGRHS2
      REAL(SZ) ZNGFicNodeDist,ZNGFicNodeDistTemp

      REAL(8)  RNP_GLOBAL
      REAL(8)  REFSEC   ! required to run in either 32-bit or 64-bit



C-------------------end of data declarations----------------------------------C


      CONTAINS


C...
C...Allocate space for Arrays dimensioned by MNE and MNP
C...
      SUBROUTINE ALLOC_MAIN1a()
C
      ALLOCATE ( SLAM(MNP),SFEA(MNP),X(MNP),Y(MNP))
      ALLOCATE ( DP(MNP),SFAC(MNP),STARTDRY(MNP))
      ALLOCATE ( NM(MNE,3)) 
      ALLOCATE ( ETAS(MNP))
      ALLOCATE ( QW(MNP))
      ALLOCATE ( FRIC(MNP),EVM(MNP))
      ALLOCATE ( UU1(MNP),VV1(MNP))
      ALLOCATE ( NNODECODE(MNP),NODEREP(MNP))
      ALLOCATE ( NNEIGH(MNP),MJU(MNP),NODELE(MNP))
      ALLOCATE ( NIBNODECODE(MNP))
      ALLOCATE ( TAU0VAR(MNP))
      ALLOCATE ( CH1(MNP),QB(MNP),QA(MNP),SOURSIN(MNP),EVC(MNP))
      ALLOCATE ( TK(MNP))
      ALLOCATE ( AREAS(MNE))
      ALLOCATE ( UU2(MNP))
      ALLOCATE ( VV2(MNP))
      ALLOCATE ( ETA1(MNP),ETA2(MNP))
      ALLOCATE ( CORIF(MNP))
      ALLOCATE ( QU(MNP),QV(MNP))
      ALLOCATE ( LBArray_Pointer(MNP))
      ALLOCATE ( CSI(MNP),SII(MNP))
      ALLOCATE ( NODECODE(MNP))
      ALLOCATE ( NIBCNT(MNP) )  !  added 7/31/2000 to fix wetdry bug
      ALLOCATE ( VIDBCPDX1(MNP),VIDBCPDY1(MNP))

#ifdef CMPI
      ALLOCATE ( IDUMY(1), DUMY1(1), DUMY2(1) )
#endif

#ifdef CVEC
      ALLOCATE ( QTEMA(MNE,3),QTEMB(MNE,3))
#endif

c     IF (C3DDSS) THEN
c        ALLOCATE(AUV13(MNP),AUV14(MNP))
c     ENDIF

C     jgf These were inside the C3D if-block below, but since they are
C     used in the 2DDI section of timestep.F, they must be allocated in
C     the non-C3D case.

      ALLOCATE(AUV11(MNP),AUV12(MNP))

      IF (C3D) THEN
         ALLOCATE(DUU1(MNP),DUV1(MNP),DVV1(MNP),
     &        BSX1(MNP),BSY1(MNP))
      ENDIF
C     
      RETURN
      END SUBROUTINE


C...
C...Allocate space for Arrays needed to determine neighbor tables   
C...
      SUBROUTINE ALLOC_MAIN1b()

C  Neighbor Table

      ALLOCATE ( NEITAB(MNP,MNEI))
      ALLOCATE ( NEITABELE(MNP,MNEI))
C
      RETURN
      END SUBROUTINE


C...
C...Allocate space for Arrays dimensioned by MNOPE and MNETA
C...     
      SUBROUTINE ALLOC_MAIN2()
C    
      ALLOCATE ( ESBIN1(MNETA),ESBIN2(MNETA))
      ALLOCATE ( NBDV(MNOPE,MNETA))
      ALLOCATE ( NVDLL(MNOPE),NBD(MNETA))
      ALLOCATE ( EMO(MNBFR,MNETA),EFA(MNBFR,MNETA))
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for nonperiodic zero and nonzero normal flow
C...boundary arrays including barriers
C...
      SUBROUTINE ALLOC_MAIN3()
C
      ALLOCATE ( QN0(MNVEL),QN1(MNVEL),QN2(MNVEL))
      ALLOCATE ( EN0(MNVEL),EN1(MNVEL),EN2(MNVEL))
      ALLOCATE ( ENIN1(MNVEL),ENIN2(MNVEL))
      ALLOCATE ( NBV(MNVEL),LBCODEI(MNVEL))
      ALLOCATE ( BNDLEN2O3(MNVEL))
      ALLOCATE ( ME2GW(MNVEL))
      ALLOCATE ( CSII(MNVEL),SIII(MNVEL))
      ALLOCATE ( ZNGIF1(MNVEL),ZNGIF2(MNVEL),ZNGIF3(MNVEL))
      ALLOCATE ( NEleZNG(MNVEL))
      ALLOCATE ( BARLANHT(MNVEL),BARLANCFSP(MNVEL))
      ALLOCATE ( BARLANHTR(MNVEL),BARLANCFSPR(MNVEL))
      ALLOCATE ( BARINHT(MNVEL),BARINCFSB(MNVEL),BARINCFSP(MNVEL))
      ALLOCATE ( PIPEHT(MNVEL),PIPECOEF(MNVEL),PIPEDIAM(MNVEL))
      ALLOCATE ( IBCONN(MNVEL))
      ALLOCATE ( BARINHTR(MNVEL),BARINCFSBR(MNVEL),BARINCFSPR(MNVEL))
      ALLOCATE ( PIPEHTR(MNVEL),PIPECOEFR(MNVEL),PIPEDIAMR(MNVEL))
      ALLOCATE ( IBCONNR(MNVEL),NTRAN1(MNVEL),NTRAN2(MNVEL))
      ALLOCATE ( BTRAN3(MNVEL),BTRAN4(MNVEL),BTRAN5(MNVEL))
      ALLOCATE ( BTRAN6(MNVEL),BTRAN7(MNVEL),BTRAN8(MNVEL))
      ALLOCATE ( RBARWL1AVG(MNVEL),RBARWL2AVG(MNVEL))
      ALLOCATE ( RPIPEWL1AVG(MNVEL),RPIPEWL2AVG(MNVEL))
      ALLOCATE ( QNIN1(MNVEL),QNIN2(MNVEL))
      ALLOCATE ( NBVV(MNBOU,0:MNVEL))
      ALLOCATE ( NVELL(MNBOU))
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for tidal potential terms 
C...
      SUBROUTINE ALLOC_MAIN4a()
C
      ALLOCATE ( TPK(MNTIF),AMIGT(MNTIF),FFT(MNTIF) )
      ALLOCATE ( FACET(MNTIF),PERT(MNTIF),ETRF(MNTIF) )
      ALLOCATE ( TIPOTAG(MNTIF) )
      
      IF ( CTIP ) THEN
         ALLOCATE( TIP1(MNP),TIP2(MNP))
      ENDIF  
C      
      RETURN
      END SUBROUTINE


C...     
C...Allocate space for Earth load/self-attraction tide 
C...     
      SUBROUTINE ALLOC_MAIN4b()
C
      ALLOCATE ( SALTAMP(MNTIF,MNP),SALTPHA(MNTIF,MNP) )
C
      RETURN
      END SUBROUTINE


C...     
C...Allocate space for Arrays dimensioned by MNBFR      
C...     
      SUBROUTINE ALLOC_MAIN5()
C
      ALLOCATE ( AMIG(MNBFR),PER(MNBFR))
      ALLOCATE ( FF(MNBFR),FACE(MNBFR))
      ALLOCATE ( BOUNTAG(MNBFR) )
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for periodic normal flow boundary conditions
C...
      SUBROUTINE ALLOC_MAIN6()
C
      ALLOCATE ( QNAM(MNFFR,MNVEL),QNPH(MNFFR,MNVEL))
      ALLOCATE ( ENAM(MNFFR,MNVEL),ENPH(MNFFR,MNVEL))
      ALLOCATE ( FBOUNTAG(MNFFR))
      ALLOCATE ( FAMIG(MNFFR), FFF(MNFFR), FFACE(MNFFR), FPER(MNFFR) )
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for arrays used for station elevation output
C...
      SUBROUTINE ALLOC_MAIN7()
C
      ALLOCATE ( NNE(MNSTAE),ET00(MNSTAE))
      ALLOCATE ( STAIE1(MNSTAE),STAIE2(MNSTAE),STAIE3(MNSTAE))
      ALLOCATE ( XEL(MNSTAE),YEL(MNSTAE),SLEL(MNSTAE),SFEL(MNSTAE))
C
      RETURN
      END SUBROUTINE


C...     
C...Allocate space for arrays used for station velocity output
C...
      SUBROUTINE ALLOC_MAIN8()
C
      ALLOCATE ( XEV(MNSTAV),YEV(MNSTAV),SLEV(MNSTAV),SFEV(MNSTAV))
      ALLOCATE ( NNV(MNSTAV))
      ALLOCATE ( UU00(MNSTAV),VV00(MNSTAV))
      ALLOCATE ( STAIV1(MNSTAV),STAIV2(MNSTAV),STAIV3(MNSTAV))
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for arrays used for station concentration output
C...
      SUBROUTINE ALLOC_MAIN9()
C
      ALLOCATE ( XEC(MNSTAC),YEC(MNSTAC),SLEC(MNSTAC),SFEC(MNSTAC))
      ALLOCATE ( NNC(MNSTAC))
      ALLOCATE ( CC00(MNSTAC))
      ALLOCATE ( STAIC1(MNSTAC),STAIC2(MNSTAC),STAIC3(MNSTAC))
C      
      RETURN
      END SUBROUTINE


C...
C...Allocate space for arrays used for station meteorological output
C...
      SUBROUTINE ALLOC_MAIN10()
C
      ALLOCATE ( XEM(MNSTAM),YEM(MNSTAM),SLEM(MNSTAM),SFEM(MNSTAM))
      ALLOCATE ( NNM(MNSTAM))
      ALLOCATE ( RMU00(MNSTAM),RMV00(MNSTAM),RMP00(MNSTAM))
      ALLOCATE ( STAIM1(MNSTAM),STAIM2(MNSTAM),STAIM3(MNSTAM))
C
      RETURN
      END SUBROUTINE


C...
C...Allocate space for arrays needed by GWCE matrix and iterative solver   
C...
      SUBROUTINE ALLOC_MAIN11()

C  Arrays used by JCG iterative solver
      
      ALLOCATE( OBCCOEF(MNETA,MNEI-1),COEF(MNP,MNEI))
      ALLOCATE( IWKSP(3*MNP),WKSP(4*MNP+400) )
      ALLOCATE( IPARM(12),RPARM(12) )
C
      RETURN
      END SUBROUTINE


C...
C...Allocate space for wind forcing   
C...
      SUBROUTINE ALLOC_MAIN12()
C
      ALLOCATE ( WSX1(MNP),WSY1(MNP),PR1(MNP) )
      ALLOCATE ( WSX2(MNP),WSY2(MNP),PR2(MNP) )
      ALLOCATE ( WVNX1(MNP),WVNY1(MNP),PRN1(MNP) )
      ALLOCATE ( WVNX2(MNP),WVNY2(MNP),PRN2(MNP) )
      ALLOCATE ( RSNX1(MNP),RSNY1(MNP),RSNX2(MNP),RSNY2(MNP) )
      ALLOCATE ( WVNXOUT(MNP),WVNYOUT(MNP) )
C
      RETURN
      END SUBROUTINE


C...
C...Allocate space for bridge piling friction arrays   
C...
      SUBROUTINE ALLOC_MAIN13()
C
      ALLOCATE ( NBNNUM(MNP),BK(MNP),BALPHA(MNP),BDELX(MNP) )
C
      RETURN
      END SUBROUTINE


C...
C...Allocate space for harmonic analysis means and variance
C...calculations, this is in global data because the variables are
C...used in main source, outside of HA analysis subroutines.  This
C...should probably be changed.
C...
      SUBROUTINE ALLOC_MAIN14()
C
      ALLOCATE ( XVELAV(MNP),YVELAV(MNP),XVELVA(MNP),YVELVA(MNP) )
      ALLOCATE ( ELAV(MNP),ELVA(MNP) )
C
      RETURN
      END SUBROUTINE




      END MODULE GLOBAL
