########################################################################
# Intel-Linux computers using Portland group compilers

ifeq ($(MACHINE)-$(OS),i686-linux-gnu)
  FC	        :=  pgf90
  PFC	        :=  mpif90
  FFLAGS1	:= -g -w -Mextend -r8 
  FFLAGS2	:=  $(FFLAGS1) 
  FFLAGS3	:=  $(FFLAGS1) 
  FFLAGS4	:=  $(FFLAGS1) 
  DA  	        :=  -DREAL8 -DCSCA -DC2D3D
  DP  	        :=  -DREAL8 -DCSCA -DCMPI -DC2D3D
  DPRE	        :=  -DREAL4 -DLINUX
  DPRE2	        :=  -DREAL4 -DLINUX -DCMPI
  IMODS 	:=  -I
  CC            :=  gcc
  CFLAGS        :=  -I. -DLINUX -O2
  CLIBS         := 
  LIBS  	:=  -L ../metis  -lmetis
  MSGLIBS	:= 
endif

########################################################################
# T3E- Crays using standard compilers

ifneq (,$(findstring t3e-unicosmk,$(MACHINE)-$(OS)))
  FC	        :=  f90
  PFC	        :=  f90
  FFLAGS1	:=  -N 132 -dp -i32 -O2 
# FFLAGS1	:=  -N 132 -dp -i32 -g 
  FFLAGS2	:=  -N 132 -dp -i32 -O2 -Xm 
  FFLAGS3	:=  -N 132 -dp -O2 
  FFLAGS4	:=  -N 132 -dp -O2 
  DA  	        :=  -DREAL8 -DCRAY -DCSCA -DC2D3D
  DP  	        :=  -DREAL8 -DCMPI   -DCRAY -DCSCA -DC2D3D
  DPRE	        :=  -DREAL4 -DCRAY 
  DPRE2	        :=  -DREAL4 -DCRAY -DCMPI
  IMODS		:=  -p 
  CC	        :=  cc
  CFLAGS	:=  -I. -I ../Lib -O2 -DCRAY
# CFLAGS	:=  -I. -I ../Lib -g -DCRAY
  LIBS  	:=  -L ../metis  -lmetis
  MSGLIBS	:=  -lmpi 
endif

########################################################################
# SGI Origin - SGI using standard compilers

ifneq (,$(findstring mips-irix,$(MACHINE)-$(OS)))
  FC              := f90 
  PFC             := f90 
  FFLAGS1	  := -extend_source -O2 -OPT:Olimit=4257 -OPT:reorg_common=ON
  FFLAGS2	  := -extend_source -O2 -OPT:Olimit=4257 -OPT:reorg_common=ON
  FFLAGS3	  := -extend_source -O2 -OPT:Olimit=4257 -OPT:reorg_common=ON
  FFLAGS4	  := -extend_source -O2 -OPT:Olimit=4257 -OPT:reorg_common=ON
  DA	          :=  -DREAL8 -DCSCA -DC2D3D
  DP	          :=  -DREAL8 -DCMPI  -DSGI -DCSCA -DC2D3D
  DPRE	          :=  -DREAL4 -DSGI
  DPRE2	          :=  -DREAL4 -DCMPI -DSGI
  IMODS   	  :=  -I
  CC              :=  cc   
  CFLAGS          :=  -I. -O2
  LIBS		  :=  -L ../metis  -lmetis
  MSGLIBS	  := -lmpi
endif

########################################################################
# IBM SP - IBM using standard compilers

ifneq (,$(findstring rs6000-aix,$(MACHINE)-$(OS)))
  FC	        := xlf90
  PFC	        := mpxlf90
  FFLAGS1	:=  -w -bmaxdata:0x30000000 -O2 -qfixed=132 -qarch=auto -qhot -qcache=auto
  FFLAGS2	:=  -w -bmaxdata:0x30000000 -O2 -qfixed=132 -qarch=auto -qhot -qcache=auto
  FFLAGS3	:=  -w -O2 -qfixed=132 -qarch=auto -qhot -qcache=auto
  FFLAGS4	:=  -w -O2 -qfixed=132 -qarch=auto -qhot -qcache=auto
  DA  	   	:=  -WF,"-DREAL8,-DCSCA,-DIBM,-DC2D3D"
  DP  	   	:=  -tF -WF,"-DREAL8,-DCMPI,-DCSCA,-DIBM,-DC2D3D"
  DPRE	   	:=  -tF -WF,"-DREAL4,-DIBM"
  DPRE2	   	:=  -tF -WF,"-DREAL4,-DCMPI,-DIBM"
  IMODS  	:=  -I 
  CC            :=  mpcc
  CFLAGS	:=  -I. -O2 -bmaxdata:0x30000000
  LDFLAGS	:=  -bmaxdata:0x30000000
  LIBS	        :=  -L ../metis  -lmetis
  MSGLIBS	:=  -lm
endif

########################################################################
# Sun Solaris Using standard compilers

ifneq (,$(findstring sparc-solaris,$(MACHINE)-$(OS)))
  FC	        := f90
  PFC	        := mpf90
  ARCH	        := v8plusa
  LD	        := $(FC)
  FFLAGS1	:= -e -fast -xO4 -xdepend -fsimple=1 -f -dalign -xtarget=ultra -xarch=$(ARCH)
  FFLAGS2	:= -e -fast -xO4 -xdepend -fsimple=1 -f -dalign -xtarget=ultra -xarch=$(ARCH)
  FFLAGS3	:= -e -fast -xO4 -xdepend -fsimple=1 -f -dalign -xtarget=ultra -xarch=$(ARCH)
  FFLAGS4	:= -e -fast -xO4 -xdepend -fsimple=1 -f -dalign -xtarget=ultra -xarch=$(ARCH)
  DA	        := -DREAL8 -DMACHSUN -DCSCA -DC2D3D
  DP	        := -DREAL8 -DCMPI -DMACHSUN -DCSCA -DC2D3D
  DPRE          := -DREAL4 -DMACHSUN
  DPRE2         := -DREAL4 -DCMPI -DMACHSUN
  IMODS		:= -M
  CC       	:= cc 
  CFLAGS   	:= -I. 
  LIBS     	:= -L../metis  -lmetis
  MSGLIBS  	:= -lmpi
endif
########################################################################
# Alpha-Linux computers using Portland group compilers

ifneq (,$(findstring alphaev6-linux,$(MACHINE)-$(OS)))
  FC	        :=  fort
  PFC	        :=  mpif90
  FFLAGS1	:= -extend_source -fast -fixed 
  FFLAGS2	:= -extend_source -fast -fixed
  FFLAGS3	:= -extend_source -fast -fixed 
  FFLAGS4	:= -extend_source -fast -fixed 
  DA  	        :=  -DREAL8 -DCSCA -DC2D3D
  DP  	        :=  -DREAL8 -DCMPI  -DCSCA -DC2D3D
  DPRE	        :=  -DREAL4 -DLINUX 
  DPRE2	        :=  -DREAL4 -DCMPI -DLINUX
  IMODS 	:=  -I
  CC            := gcc
  CFLAGS        := -I. -DLINUX -O2
  CLIBS         := 
  LIBS  	:=  -L ../metis  -lmetis
  MSGLIBS	:=  
endif
 
########################################################################
# Compaq True64 computers using Compaq compilers

ifneq (,$(findstring alphaev6-osf,$(MACHINE)-$(OS)))
  FC		:=  f90
  PFC		:=  f90
  FFLAGS1	:= -extend_source -fast -fixed
  FFLAGS2	:= -extend_source -fast -fixed
  FFLAGS3	:= -extend_source -fast -fixed
  FFLAGS4	:= -extend_source -fast -fixed
  DA		:=  -DREAL8 -DCSCA -DC2D3D
  DP		:=  -DREAL8 -DCMPI  -DCSCA -DC2D3D
  DPRE		:=  -DREAL4 -DLINUX
  DPRE2		:=  -DREAL4 -DCMPI -DLINUX
  IMODS		:=  -I
  CC		:= cc
  CFLAGS	:= -I. -DLINUX -O2
  CLIBS		:=
  LIBS		:=  -L../metis	-lmetis
  MSGLIBS	:= -lfmpi -lmpi -lelan
endif

######################################################
# for Intel itanium
#

ifneq (,$(findstring ia64-linux,$(MACHINE)-$(OS)))
  FC            := /opt/intel/compiler60/ia64/bin/efc 
  PFC           :=  mpif90
  FFLAGS1       := -132 -IPF_fp_speculationfast -r8
  FFLAGS2       := $(FFLAGS1)
  FFLAGS3       := $(FFLAGS1)
  FFLAGS4       := $(FFLAGS1)
  DA            :=  -DREAL8 -DCSCA -DC2D3D
  DP            :=  -DREAL8 -DCSCA -DCMPI -DC2D3D
  DPRE          :=  -DREAL4 -DLINUX
  DPRE2         :=  -DREAL4 -DLINUX -DCMPI
  IMODS         :=  -I
  CC            :=  gcc
  CFLAGS        :=  -I. -DLINUX -O2
  CLIBS         :=
  LIBS          :=  -L ../metis  -lmetis
  MSGLIBS       :=
endif
