C
C  version 1.1 vjp 5/04/99
C  updated by vjp 5/11/99 to handle incomplete files
C  version 1.2 vjp 12/12/99
C  updated by vjp  12/12/99 to allocate variables dynamically
C

      SUBROUTINE POST_INIT()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  This routine reads the domain decomposition information from file,       C
C  "fort.80", which was written by the ADCIRC pre-processor ADCPREP.        C
C                                                                           C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K
      CHARACTER DUMMY*80
C
C--Read the domain-decomposition information file created
C  by the Pre-processor
C
      OPEN(UNIT=80,FILE='fort.80')        
C
      READ(80,80) RUNDES
      READ(80,80) RUNID
      READ(80,80) AGRID
      READ(80,*)  NELG,NNODG
      READ(80,*)  NPROC
      READ(80,*)  MNPP
      READ(80,*) NSTAE
      READ(80,*) NSTAV
      READ(80,*) MNHARF   
      READ(80,*) MNWLAT,MNWLON
      MNSTAE = NSTAE
      MNSTAV = NSTAV
      MNP = NNODG
      MNE = NELG
      MNPROC = NPROC
C
C  Allocate all global variables
      CALL ALLOC_MAIN1()
      DO I = 1,NPROC
         READ(80,*) J, NNODP(I), NOD_RES_TOT(I) 
         READ(80,1130) (IMAP_NOD_LG(K,I),K=1,NNODP(I))
      ENDDO
C
      READ(80,80) DUMMY
      DO I = 1,NNODG
         READ(80,1140) J, IMAP_NOD_GL(1,I), IMAP_NOD_GL(2,I)
         IMAP_NOD_GL(1,I) = IMAP_NOD_GL(1,I)+1
      ENDDO
C
      READ(80,*) NOUTE,TOUTSE,TOUTFE,NSPOOLE 
C
      DO I = 1,NPROC
         READ(80,*) J,NSTAEP(I)
         DO K = 1,NSTAEP(I)
            READ(80,*) IMAP_STAE_LG(K,I)
         ENDDO
      ENDDO
C
      READ(80,*) NOUTV,TOUTSV,TOUTFV,NSPOOLV
C
      DO I = 1,NPROC
         READ(80,*) J,NSTAVP(I)
         DO K = 1,NSTAVP(I)
            READ(80,*) IMAP_STAV_LG(K,I)
         ENDDO
      ENDDO
C
      READ(80,*) NOUTGE, TOUTSGE,TOUTFGE,NSPOOLGE
      READ(80,*) NOUTGV, TOUTSGV,TOUTFGV,NSPOOLGV
      READ(80,*) NOUTGC, TOUTSGC,TOUTFGC,NSPOOLGC
      READ(80,*) NOUTGW, TOUTSGW,TOUTFGW,NSPOOLGW
C
      READ(80,*) NHASE,NHASV,NHAGE,NHAGV
C
C--Start 3D data
      READ(80,*) I3DSD, TO3DSSD, TO3DFSD, NSPO3DSD, NHN3DSD
      IF(NHN3DSD.GT.0)
     &  ALLOCATE ( N3DSDP(MNPROC), IMAP_3DSD_LG(NHN3DSD,MNPROC) )
      IF(I3DSD.GT.0) THEN
        DO I = 1,NPROC
           READ(80,*) J,N3DSDP(I)
           DO K = 1,N3DSDP(I)
              READ(80,*) IMAP_3DSD_LG(K,I)
           ENDDO
        ENDDO
      ENDIF
      READ(80,*) I3DSV, TO3DSSV, TO3DFSV, NSPO3DSV, NHN3DSV
      IF(NHN3DSV.GT.0)
     &  ALLOCATE ( N3DSVP(MNPROC), IMAP_3DSV_LG(NHN3DSV,MNPROC) )
      IF(I3DSV.GT.0) THEN
        DO I = 1,NPROC
           READ(80,*) J,N3DSVP(I)
           DO K = 1,N3DSVP(I)
              READ(80,*) IMAP_3DSV_LG(K,I)
           ENDDO
        ENDDO
      ENDIF
      READ(80,*) I3DST, TO3DSST, TO3DFST, NSPO3DST, NHN3DST
      IF(NHN3DST.GT.0)
     &  ALLOCATE ( N3DSTP(MNPROC), IMAP_3DST_LG(NHN3DST,MNPROC) )
      IF(I3DST.GT.0) THEN
        DO I = 1,NPROC
           READ(80,*) J,N3DSTP(I)
           DO K = 1,N3DSTP(I)
              READ(80,*) IMAP_3DST_LG(K,I)
           ENDDO
        ENDDO
      ENDIF
      READ(80,*) I3DGD,TO3DSGD,TO3DFGD,NSPO3DGD
      READ(80,*) I3DGV,TO3DSGV,TO3DFGV,NSPO3DGV
      READ(80,*) I3DGT,TO3DSGT,TO3DFGT,NSPO3DGT
C--End 3D data
C
      READ(80,*) NBYTE
C
      CLOSE(80)
C
  80  FORMAT(A80)
1130  FORMAT(8X,9I8)
1140  FORMAT(8X,3I8)
C
      RETURN
      END


      SUBROUTINE POST61()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the elevation data at the elevation stations from the local    C
C  fort.61 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NTRSPE,NSTEMP,ITSE,ITEMPE,NUMSTNS
      INTEGER OREC
      REAL DTE,TIMEOUTSE
      CHARACTER*80  OUTMSG
      CHARACTER*85  INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE :: LOC(:),IREC(:)
      REAL,ALLOCATABLE ::   ETBIN(:),ETBINP(:)
      CHARACTER*80,ALLOCATABLE ::  ETASC(:),ETASCP(:)
      CHARACTER*14,ALLOCATABLE ::  LOCNAME(:)

      ALLOCATE ( LOC(MNPROC),IREC(MNPROC) )
      ALLOCATE ( ETBIN(MNSTAE),ETBINP(MNSTAE))
      ALLOCATE ( ETASC(MNSTAE),ETASCP(MNSTAE))
      ALLOCATE ( LOCNAME(MNPROC))

C
C--Determine whether Unit 61 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(NOUTE).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open All Local Sequential Formatted fort.61 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.61'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.61 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NTRSPE,NUMSTNS,DTE,NSTEMP,ITEMPE
         IF (NUMSTNS.NE.NSTAEP(IPROC)) THEN
            STOP 'Inconsistency in Number of Elevation Stations'
         ENDIF
      ENDDO
C
C--Open Global Sequential Formatted fort.61 file
C
      OPEN(UNIT=61,FILE='fort.61')
C
      WRITE(61,'(A85)') INLINE
      WRITE(61,3645) NTRSPE,NSTAE,DTE,NSPOOLE,ITEMPE
C
      DO J=1,NTRSPE
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),2120,END=9999) TIMEOUTSE,ITSE
            IF (NSTAEP(IPROC).GT.0) THEN
              READ(LOC(IPROC),80,END=9999) (ETASCP(K),K=1,NSTAEP(IPROC))
              DO K=1,NSTAEP(IPROC)
                 ETASC(IMAP_STAE_LG(K,IPROC)) = ETASCP(K)
              ENDDO
            ENDIF
         ENDDO            
C
         WRITE(61,2120) TIMEOUTSE,ITSE
         DO I=1, NSTAE
            CALL NEWINDEX(ETASC(I),OUTMSG,I)
            WRITE(61,80) OUTMSG
         ENDDO
C
      ENDDO                 
      GO TO 9999
C 
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.61 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.61'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',
     &       RECL=NBYTE)
         ELSE
           print *, "No Local fort.61 files found"
           RETURN
         ENDIF
      ENDDO
      OPEN(61,FILE='fort.61',ACCESS='DIRECT',RECL=NBYTE)
C
C
C--Read RUNDES RUNID and AGRID from each Local file
C
      DO IPROC = 1,NPROC
         IREC(IPROC) = 0
         IF (NBYTE.EQ.4) THEN
           DO I=1,8
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+8
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
         ENDIF
         IF (NBYTE.EQ.8) THEN
           DO I=1,4
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+4
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
         ENDIF
      ENDDO
C
C--Write RUNDES RUNID and AGRID to Global File
C
      OREC = 0
      IF (NBYTE.EQ.4) THEN
        DO I=1,8
           WRITE(61,REC=OREC+I) RDES4(I)
        ENDDO
        OREC=OREC+8
        DO I=1,6
           WRITE(61,REC=OREC+I) RID4(I)
        ENDDO
        OREC=OREC+6
        DO I=1,6
           WRITE(61,REC=OREC+I) AID4(I)
        ENDDO
        OREC=OREC+6
      ENDIF
      IF (NBYTE.EQ.8) THEN
        DO I=1,4
           WRITE(61,REC=OREC+I) RDES8(I)
        ENDDO
        OREC=OREC+4
        DO I=1,3
           WRITE(61,REC=OREC+I) RID8(I)
        ENDDO
        OREC=OREC+3
        DO I=1,3
           WRITE(61,REC=OREC+I) AID8(I)
        ENDDO
        OREC=OREC+3
      ENDIF
C
C--Read NTRSPE, NSTAE, DT*NSPOOLE from each Local file
C  and then close files to flush file buffers
C
      DO IPROC = 1,NPROC
         READ(LOC(IPROC),REC=IREC(IPROC)+1) NTRSPE
         READ(LOC(IPROC),REC=IREC(IPROC)+2) NUMSTNS        
         READ(LOC(IPROC),REC=IREC(IPROC)+3) DTE
         READ(LOC(IPROC),REC=IREC(IPROC)+4) NSTEMP 
         READ(LOC(IPROC),REC=IREC(IPROC)+5) ITEMPE
         IREC(IPROC) = IREC(IPROC)+5
         CLOSE(LOC(IPROC))    ! Flush the Write Buffer
         IF (NUMSTNS.NE.NSTAEP(IPROC)) THEN
            STOP 'Inconsistency in Number of Elevation Stations'
         ENDIF
         OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',RECL=NBYTE)
      ENDDO
C
C--Write same info to Global file and close it to flush buffer also
C
      WRITE(61,REC=OREC+1) NTRSPE
      WRITE(61,REC=OREC+2) NSTAE
      WRITE(61,REC=OREC+3) DTE
      WRITE(61,REC=OREC+4) NSPOOLE
      WRITE(61,REC=OREC+5) ITEMPE
      OREC = OREC+5
      CLOSE(61)         ! Flush the Write Buffer
      OPEN(61,FILE='fort.61',ACCESS='DIRECT',RECL=NBYTE)
C
      DO J=1,NTRSPE
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),REC=IREC(IPROC)+1) TIMEOUTSE
            READ(LOC(IPROC),REC=IREC(IPROC)+2) ITSE
            IREC(IPROC) = IREC(IPROC) + 2
            IF (NSTAEP(IPROC).GT.0) THEN
              DO K=1, NSTAEP(IPROC)
                 READ(LOC(IPROC),REC=IREC(IPROC)+K) ETBINP(K)
              ENDDO
              DO K=1,NSTAEP(IPROC)
                 ETBIN(IMAP_STAE_LG(K,IPROC)) = ETBINP(K)
              ENDDO
              IREC(IPROC) = IREC(IPROC) + NSTAEP(IPROC)
            ENDIF
         ENDDO            
C
         WRITE(61,REC=OREC+1) TIMEOUTSE
         WRITE(61,REC=OREC+2) ITSE
         OREC = OREC + 2
         DO K=1, NSTAE
            WRITE(61,REC=OREC+K) ETBIN(K)
         ENDDO
         OREC = OREC + NSTAE
C
      ENDDO                 
C
C--Close the Global and Local fort.61 Files
C
9999  CONTINUE
      CLOSE(61)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A40)
 2120 FORMAT(2X,E20.10,5X,I10)
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END


      SUBROUTINE POST62()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the elevation data at the velocity stations from the local     C
C  fort.62 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NTRSPV,NSTEMP,ITSV,ITEMPV,NUMSTNS
      INTEGER OREC
      REAL DTV,TIMEOUTSV
      CHARACTER*80 OUTMSG
      CHARACTER*85  INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE :: LOC(:),IREC(:)
      REAL,ALLOCATABLE ::  UUBIN(:),VVBIN(:)
      REAL,ALLOCATABLE ::  UUBINP(:),VVBINP(:)
      CHARACTER*80,ALLOCATABLE :: UUASC(:),UUASCP(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)


      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (UUBIN(MNSTAV),VVBIN(MNSTAV))
      ALLOCATE (UUBINP(MNSTAV),VVBINP(MNSTAV))
      ALLOCATE (UUASC(MNSTAV),UUASCP(MNSTAV))
      ALLOCATE (LOCNAME(MNPROC))
C
C--Determine whether Unit 62 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(NOUTV).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.62'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.62 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NTRSPV,NUMSTNS,DTV,NSTEMP,ITEMPV
         IF (NUMSTNS.NE.NSTAVP(IPROC)) THEN
            STOP 'Inconsistency in Number of Velocity Stations'
         ENDIF
      ENDDO
C
C--Open Global fort.62 file
C
      OPEN(UNIT=62,FILE='fort.62')
C
      WRITE(62,'(A85)') INLINE
      WRITE(62,3645) NTRSPV,NSTAV,DTV,NSPOOLV,ITEMPV
C
      DO J=1,NTRSPV
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),2120,END=9999) TIMEOUTSV,ITSV
            IF (NSTAVP(IPROC).GT.0) THEN
              READ(LOC(IPROC),80,END=9999) (UUASCP(K),K=1,
     &                                     NSTAVP(IPROC))
              DO K=1,NSTAVP(IPROC)
                 UUASC(IMAP_STAV_LG(K,IPROC)) = UUASCP(K)
              ENDDO
            ENDIF
         ENDDO            
C
         WRITE(62,2120) TIMEOUTSV,ITSV
         DO I=1, NSTAV
            CALL NEWINDEX(UUASC(I),OUTMSG,I)
            WRITE(62,80) OUTMSG
         ENDDO
C
      ENDDO                 
      GO TO 9999
C 
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.62 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.62'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',
     &       RECL=NBYTE)
         ELSE
           print *, "No Local fort.61 files found"
           RETURN
         ENDIF
      ENDDO
      OPEN(62,FILE='fort.62',ACCESS='DIRECT',RECL=NBYTE)
C
C--Read RUNDES RUNID and AGRID from each Local file
C
      DO IPROC = 1,NPROC
         IREC(IPROC) = 0
         IF (NBYTE.EQ.4) THEN
           DO I=1,8
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+8
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
         ENDIF
         IF (NBYTE.EQ.8) THEN
           DO I=1,4
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+4
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
         ENDIF
      ENDDO
C
C--Write RUNDES RUNID and AGRID to Global File
C
      OREC = 0
      IF (NBYTE.EQ.4) THEN
        DO I=1,8
           WRITE(62,REC=OREC+I) RDES4(I)
        ENDDO
        OREC=OREC+8
        DO I=1,6
           WRITE(62,REC=OREC+I) RID4(I)
        ENDDO
        OREC=OREC+6
        DO I=1,6
           WRITE(62,REC=OREC+I) AID4(I)
        ENDDO
        OREC=OREC+6
      ENDIF
      IF (NBYTE.EQ.8) THEN
        DO I=1,4
           WRITE(62,REC=OREC+I) RDES8(I)
        ENDDO
        OREC=OREC+4
        DO I=1,3
           WRITE(62,REC=OREC+I) RID8(I)
        ENDDO
        OREC=OREC+3
        DO I=1,3
           WRITE(62,REC=OREC+I) AID8(I)
        ENDDO
        OREC=OREC+3
      ENDIF
C
C--Read NTRSPV, NSTAV, DT*NSPOOLV from each Local file
C  and then close files to flush file buffers
C
      DO IPROC = 1,NPROC
         READ(LOC(IPROC),REC=IREC(IPROC)+1) NTRSPV
         READ(LOC(IPROC),REC=IREC(IPROC)+2) NUMSTNS
         READ(LOC(IPROC),REC=IREC(IPROC)+3) DTV
         READ(LOC(IPROC),REC=IREC(IPROC)+4) NSTEMP
         READ(LOC(IPROC),REC=IREC(IPROC)+5) ITEMPV
         IREC(IPROC) = IREC(IPROC)+5
         CLOSE(LOC(IPROC))    ! Flush the Write Buffer
         IF (NUMSTNS.NE.NSTAVP(IPROC)) THEN
            STOP 'Inconsistency in Number of Velocity Stations'
         ENDIF
         OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',RECL=NBYTE)
      ENDDO
C
C--Write same info to Global file and close it to flush buffer also
C
      WRITE(62,REC=OREC+1) NTRSPV
      WRITE(62,REC=OREC+2) NSTAV
      WRITE(62,REC=OREC+3) DTV
      WRITE(62,REC=OREC+4) NSPOOLV
      WRITE(62,REC=OREC+5) ITEMPV
      OREC = OREC+5
      CLOSE(62)         ! Flush the Write Buffer
      OPEN(62,FILE='fort.62',ACCESS='DIRECT',RECL=NBYTE)
C
      DO J=1,NTRSPV
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),REC=IREC(IPROC)+1) TIMEOUTSV
            READ(LOC(IPROC),REC=IREC(IPROC)+2) ITSV
            IREC(IPROC) = IREC(IPROC) + 2
            IF (NSTAVP(IPROC).GT.0) THEN
              DO K=1, NSTAVP(IPROC)
                 READ(LOC(IPROC),REC=IREC(IPROC)+2*K-1) UUBINP(K)
                 READ(LOC(IPROC),REC=IREC(IPROC)+2*K) VVBINP(K)
              ENDDO
              DO K=1,NSTAVP(IPROC)
                 UUBIN(IMAP_STAV_LG(K,IPROC)) = UUBINP(K)
                 VVBIN(IMAP_STAV_LG(K,IPROC)) = VVBINP(K)
              ENDDO
             IREC(IPROC) = IREC(IPROC) + 2*NSTAVP(IPROC)
            ENDIF
         ENDDO
C
         WRITE(62,REC=OREC+1) TIMEOUTSV
         WRITE(62,REC=OREC+2) ITSV
         OREC = OREC + 2
         DO K=1, NSTAV
            WRITE(62,REC=OREC+2*K-1) UUBIN(K)
            WRITE(62,REC=OREC+2*K) VVBIN(K)
         ENDDO
         OREC = OREC + 2*NSTAV
C
      ENDDO
C
 9999 CONTINUE
C
C--Close the Global and Local fort.62 Files
C
      CLOSE(62)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
 2120 FORMAT(2X,E20.10,5X,I10)
   80 FORMAT(A80)
c2454 FORMAT(2X,I8,2X,E15.8,2X,E15.8)
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END


      SUBROUTINE POST63()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the elevation data at all nodes from the local fort.63 files.  C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSETGE,NSTEMP,NP,ITE,ITEMPE,INDEX
      INTEGER OREC
      REAL DTE,TIMEOUTE
      REAL ETA
      CHARACTER*80 OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER, ALLOCATABLE  ::  LOC(:),IREC(:)
      REAL, ALLOCATABLE  ::  ETBIN(:),ETBINP(:)
      CHARACTER*80, ALLOCATABLE  ::  ETASC(:),ETASCP(:)
      CHARACTER*14, ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (ETBIN(MNP),ETBINP(MNPP))
      ALLOCATE (ETASC(MNP),ETASCP(MNPP))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 63 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(NOUTGE).EQ.1.OR.NOUTGE.EQ.-20) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global Sequential Formatted fort.63 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.63'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.63 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645)  NDSETGE,NP,DTE,NSTEMP,ITEMPE
         IF (NP.NE.NNODP(IPROC)) THEN
           print *, "NP = ",NP," NNODP = ",NNODP(IPROC)
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=63,FILE='fort.63')
C
      WRITE(63,'(A85)') INLINE
      WRITE(63,3645) NDSETGE,NNODG,DTE,NSPOOLGE,ITEMPE
C
      DO J=1,NDSETGE
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=2120,END=9999) TIMEOUTE,ITE
            IF (IPROC.EQ.1) WRITE(63,2120) TIMEOUTE,ITE
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),80,END=9999) ETASCP(K)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                 ETASC(INDEX) = ETASCP(K)
                ENDIF
            ENDDO  
         ENDDO 
         DO I = 1,NNODG
            READ(ETASC(I),*) IDUM, ETA
            WRITE(63,2453) I, ETA
         ENDDO 
C              
      ENDDO
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.63 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.63'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',
     &       RECL=NBYTE)
         ELSE
           print *, "No Local fort.63 files found"
           RETURN
         ENDIF
      ENDDO
      OPEN(63,FILE='fort.63',ACCESS='DIRECT',RECL=NBYTE)
C
C--Read RUNDES RUNID and AGRID from each Local file
C
      DO IPROC = 1,NPROC
         IREC(IPROC) = 0
         IF (NBYTE.EQ.4) THEN
           DO I=1,8
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+8
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
         ENDIF
         IF (NBYTE.EQ.8) THEN
           DO I=1,4
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+4
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
         ENDIF
      ENDDO
C
C--Write RUNDES RUNID and AGRID to Global File
C
      OREC = 0
      IF (NBYTE.EQ.4) THEN
        DO I=1,8
           WRITE(63,REC=OREC+I) RDES4(I)
        ENDDO
        OREC=OREC+8
        DO I=1,6
           WRITE(63,REC=OREC+I) RID4(I)
        ENDDO
        OREC=OREC+6
        DO I=1,6
           WRITE(63,REC=OREC+I) AID4(I)
        ENDDO
        OREC=OREC+6
      ENDIF
      IF (NBYTE.EQ.8) THEN
        DO I=1,4
           WRITE(63,REC=OREC+I) RDES8(I)
        ENDDO
        OREC=OREC+4
        DO I=1,3
           WRITE(63,REC=OREC+I) RID8(I)
        ENDDO
        OREC=OREC+3
        DO I=1,3
           WRITE(63,REC=OREC+I) AID8(I)
        ENDDO
        OREC=OREC+3
      ENDIF
C
C--Read NDSETGE, NNODP, DTE, NSPOOLGE, ITEMPE from each Local file
C  and then close files to flush file buffers
C
      DO IPROC = 1,NPROC
         READ(LOC(IPROC),REC=IREC(IPROC)+1) NDSETGE
         READ(LOC(IPROC),REC=IREC(IPROC)+2) IDUM   
         READ(LOC(IPROC),REC=IREC(IPROC)+3) DTE
         READ(LOC(IPROC),REC=IREC(IPROC)+4) NSTEMP
         READ(LOC(IPROC),REC=IREC(IPROC)+5) ITEMPE
         IREC(IPROC) = IREC(IPROC)+5
         CLOSE(LOC(IPROC))    ! Flush the Write Buffer
         OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',RECL=NBYTE)
      ENDDO
C
C--Write same info to Global file and close it to flush buffer also
C
      WRITE(63,REC=OREC+1) NDSETGE
      WRITE(63,REC=OREC+2) NNODG
      WRITE(63,REC=OREC+3) DTE
      WRITE(63,REC=OREC+4) NSPOOLGE
      WRITE(63,REC=OREC+5) ITEMPE
      OREC = OREC+5
      CLOSE(63)         ! Flush the Write Buffer
      OPEN(63,FILE='fort.63',ACCESS='DIRECT',RECL=NBYTE)
C
      DO J=1,NDSETGE
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),REC=IREC(IPROC)+1) TIMEOUTE
            READ(LOC(IPROC),REC=IREC(IPROC)+2) ITE
            IREC(IPROC) = IREC(IPROC) + 2
            DO K=1, NNODP(IPROC)
               READ(LOC(IPROC),REC=IREC(IPROC)+K) ETBINP(K)
            ENDDO
            DO K=1,NNODP(IPROC)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                 ETBIN(INDEX) = ETBINP(K)
               ENDIF
            ENDDO
            IREC(IPROC) = IREC(IPROC) + NNODP(IPROC)
         ENDDO
C
         WRITE(63,REC=OREC+1) TIMEOUTE
         WRITE(63,REC=OREC+2) ITE
         OREC = OREC + 2
         DO K=1, NNODG
            WRITE(63,REC=OREC+K) ETBIN(K)
         ENDDO
         OREC = OREC + NNODG
C
      ENDDO
C 
 9999 CONTINUE
C
C--Close the Global and Local fort.63 Files
C
      CLOSE(63)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A80)
 2120 FORMAT(2X,E20.10,5X,I10)
 2453 FORMAT(2X,I8,2X,E15.8)
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END

      SUBROUTINE POST64()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the Velocity Data at all nodes from the local fort.64 files.   C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSETGV,NSTEMP,NP,ITV,ITEMPV,INDEX
      INTEGER OREC
      REAL DTV,TIMEOUTV,U1,V1
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  UUBIN(:),VVBIN(:)
      REAL,ALLOCATABLE  ::  UUBINP(:),VVBINP(:)
      CHARACTER*80,ALLOCATABLE  ::  UU(:),UUP(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (UUBIN(MNP),VVBIN(MNP))
      ALLOCATE (UUBINP(MNPP),VVBINP(MNPP))
      ALLOCATE (UU(MNP),UUP(MNPP))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 64 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(NOUTGV).EQ.1.OR.NOUTGV.EQ.-20) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global fort.64 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.64'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.64 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSETGV,NP,DTV,NSTEMP,ITEMPV
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=64,FILE='fort.64')
C
      WRITE(64,'(A85)') INLINE
      WRITE(64,3645) NDSETGV,NNODG,DTV,NSPOOLGV,ITEMPV
C
      DO J=1,NDSETGV
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=2120,END=9999) TIMEOUTV,ITV
            IF (IPROC.EQ.1) WRITE(64,2120) TIMEOUTV,ITV
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),80,END=9999) UUP(K)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF(IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                UU(INDEX) = UUP(K)
               ENDIF
            ENDDO
         ENDDO 
         DO I = 1,NNODG
            CALL NEWINDEX(UU(I),OUTMSG,I)
            READ(UU(I),*)  IDUM, U1,V1
            WRITE(64,2454) I, U1, V1
         ENDDO
      ENDDO               
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.64 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.64'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',
     &       RECL=NBYTE)
         ELSE
           print *, "No Local fort.64 files found"
           RETURN
         ENDIF
      ENDDO
      OPEN(64,FILE='fort.64',ACCESS='DIRECT',RECL=NBYTE)
C
C--Read RUNDES RUNID and AGRID from each Local file
C
      DO IPROC = 1,NPROC
         IREC(IPROC) = 0
         IF (NBYTE.EQ.4) THEN
           DO I=1,8
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+8
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
         ENDIF
         IF (NBYTE.EQ.8) THEN
           DO I=1,4
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+4
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
         ENDIF
      ENDDO
C
C--Write RUNDES RUNID and AGRID to Global File
C
      OREC = 0
      IF (NBYTE.EQ.4) THEN
        DO I=1,8
           WRITE(64,REC=OREC+I) RDES4(I)
        ENDDO
        OREC=OREC+8
        DO I=1,6
           WRITE(64,REC=OREC+I) RID4(I)
        ENDDO
        OREC=OREC+6
        DO I=1,6
           WRITE(64,REC=OREC+I) AID4(I)
        ENDDO
        OREC=OREC+6
      ENDIF
      IF (NBYTE.EQ.8) THEN
        DO I=1,4
           WRITE(64,REC=OREC+I) RDES8(I)
        ENDDO
        OREC=OREC+4
        DO I=1,3
           WRITE(64,REC=OREC+I) RID8(I)
        ENDDO
        OREC=OREC+3
        DO I=1,3
           WRITE(64,REC=OREC+I) AID8(I)
        ENDDO
        OREC=OREC+3
      ENDIF
C
C--Read NTRSPV, NSTAV, DT*NSPOOLV from each Local file
C  and then close files to flush file buffers
C
      DO IPROC = 1,NPROC
         READ(LOC(IPROC),REC=IREC(IPROC)+1) NDSETGV
         READ(LOC(IPROC),REC=IREC(IPROC)+2) NP
         READ(LOC(IPROC),REC=IREC(IPROC)+3) DTV
         READ(LOC(IPROC),REC=IREC(IPROC)+4) NSTEMP
         READ(LOC(IPROC),REC=IREC(IPROC)+5) ITEMPV
         IREC(IPROC) = IREC(IPROC)+5
         CLOSE(LOC(IPROC))    ! Flush the Write Buffer
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
         OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',RECL=NBYTE)
      ENDDO
C
C--Write same info to Global file and close it to flush buffer also
C
      WRITE(64,REC=OREC+1) NDSETGV
      WRITE(64,REC=OREC+2) NNODG
      WRITE(64,REC=OREC+3) DTV
      WRITE(64,REC=OREC+4) NSPOOLV
      WRITE(64,REC=OREC+5) ITEMPV
      OREC = OREC+5
      CLOSE(64)         ! Flush the Write Buffer
      OPEN(64,FILE='fort.64',ACCESS='DIRECT',RECL=NBYTE)
C
      DO J=1,NDSETGV
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),REC=IREC(IPROC)+1) TIMEOUTV
            READ(LOC(IPROC),REC=IREC(IPROC)+2) ITV
            IREC(IPROC) = IREC(IPROC) + 2
            DO K=1, NNODP(IPROC)
               READ(LOC(IPROC),REC=IREC(IPROC)+2*K-1) UUBINP(K)
               READ(LOC(IPROC),REC=IREC(IPROC)+2*K) VVBINP(K)
            ENDDO
            DO K=1,NNODP(IPROC)
               UUBIN(IMAP_NOD_LG(K,IPROC)) = UUBINP(K)
               VVBIN(IMAP_NOD_LG(K,IPROC)) = VVBINP(K)
            ENDDO
           IREC(IPROC) = IREC(IPROC) + 2*NNODP(IPROC)
         ENDDO
C
         WRITE(64,REC=OREC+1) TIMEOUTV
         WRITE(64,REC=OREC+2) ITV
         OREC = OREC + 2
         DO K=1, NNODG
            WRITE(64,REC=OREC+2*K-1) UUBIN(K)
            WRITE(64,REC=OREC+2*K)   VVBIN(K)
         ENDDO
         OREC = OREC + 2*NNODG
C
      ENDDO
C
9999  CONTINUE
C
C--Close the Global and Local fort.64 Files
C
      CLOSE(64)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A80)
 2120 FORMAT(2X,E20.10,5X,I10)
 2454 FORMAT(2X,I8,2(2X,E15.8))
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END

      SUBROUTINE POST51()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the harmonic data at the elevation stations from the local     C
C  fort.51 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C  Fixed routine to handled multiple frequencies up to 32--9/18/98vjp       C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,IPROC,IDUM,IFREQ,INDEX,IREC
      INTEGER NFREQ,NUMSTNS
      CHARACTER*80  NFREQMSG,INLINE
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)
      CHARACTER*80,ALLOCATABLE  ::  HEADER(:),HARDAT(:)

      ALLOCATE ( LOC(MNPROC))
      ALLOCATE ( LOCNAME(MNPROC))
      ALLOCATE ( HEADER(MNHARF),HARDAT(MNHARF))

C
C--If they exist open all Local & Global Sequential Formatted fort.51 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.51'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105+ (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local unit 51 files found"
           RETURN
         ENDIF
      ENDDO
C
C   This is the global output file
C
      OPEN(UNIT=51,FILE='fort.51')
C
C   This is a DASD scratch file to save on memory.
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80) 
C
      DO IPROC = 1,NPROC
         IF (IPROC.EQ.1) THEN
           READ(LOC(IPROC),'(A80)')  NFREQMSG
           READ(NFREQMSG,*) NFREQ
           WRITE(51,'(A80)') NFREQMSG
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') HEADER(I)
             WRITE(51,'(A80)') HEADER(I)
           ENDDO
           READ(LOC(IPROC),*) NUMSTNS
           WRITE(51,*) NSTAE
         ELSE
           READ(LOC(IPROC),'(A80)')  INLINE
           READ(INLINE,*) IDUM
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') INLINE
           ENDDO
           READ(LOC(IPROC),*) IDUM
         ENDIF
      ENDDO
C
      DO IPROC = 1,NPROC
         DO J=1,NSTAEP(IPROC)
            READ(LOC(IPROC),*) IDUM
            INDEX = IMAP_STAE_LG(J,IPROC)
            IF (INDEX.NE.0) THEN
              DO IFREQ=1, NFREQ
                 READ(LOC(IPROC),'(A80)') HARDAT(IFREQ)
                 IREC = IFREQ + (INDEX-1)*NFREQ
                 WRITE(8,REC=IREC) HARDAT(IFREQ)
              ENDDO
             ENDIF
          ENDDO
      ENDDO
C
C   Close the DASD file to flush the write buffer and re-open.
C
      CLOSE(8,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80) 
C
      DO J=1, NSTAE
          WRITE(51,*) J
          DO IFREQ=1, NFREQ
             IREC = IFREQ + (J-1)*NFREQ
             READ(8,REC=IREC) HARDAT(IFREQ)
             WRITE(51,'(A80)') HARDAT(IFREQ)
          ENDDO
      ENDDO        
C
C--Close the Global and Local fort.51 Files
C
9999  CONTINUE
      CLOSE(51)
      CLOSE(8,STATUS='DELETE')
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
c3679 FORMAT(1X,E20.10,1X,F10.7,1X,F12.8,1X,A10)
C
      RETURN
      END

      SUBROUTINE POST52()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the harmonic data at the velocity stations from the local      C
C  fort.52 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C  Fixed routine to handled multiple frequencies up to 32--9/18/98vjp       C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,IPROC,IDUM,IFREQ,INDEX,IREC
      INTEGER NFREQ,NUMSTNS
      CHARACTER*80  NFREQMSG,INLINE
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)
      CHARACTER*80,ALLOCATABLE  ::  HEADER(:),HARDAT(:)

      ALLOCATE ( LOC(MNPROC))
      ALLOCATE ( LOCNAME(MNPROC))
      ALLOCATE ( HEADER(MNHARF),HARDAT(MNHARF))


C
C--If they exist open all Local & Global Sequential Formatted fort.52 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.52'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local unit 52 files found"
           RETURN
         ENDIF
      ENDDO
C
C   This is the global output file
C
      OPEN(UNIT=52,FILE='fort.52')
C
C   This is a DASD scratch file to save on memory.
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80)
C
      DO IPROC = 1,NPROC
         IF (IPROC.EQ.1) THEN
           READ(LOC(IPROC),'(A80)')  NFREQMSG
           READ(NFREQMSG,*) NFREQ
           WRITE(52,'(A80)') NFREQMSG
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') HEADER(I)
             WRITE(52,'(A80)') HEADER(I)
           ENDDO
           READ(LOC(IPROC),*) NUMSTNS
           WRITE(52,*) NSTAE
         ELSE
           READ(LOC(IPROC),'(A80)')  INLINE
           READ(INLINE,*) IDUM
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') INLINE
           ENDDO
           READ(LOC(IPROC),*) IDUM
         ENDIF
      ENDDO
C
      DO IPROC = 1,NPROC
         DO J=1,NSTAVP(IPROC)
            READ(LOC(IPROC),*) IDUM
            INDEX = IMAP_STAV_LG(J,IPROC)
            IF (INDEX.NE.0) THEN
              DO IFREQ=1, NFREQ
                 READ(LOC(IPROC),'(A80)') HARDAT(IFREQ)
                 IREC = IFREQ + (INDEX-1)*NFREQ
                 WRITE(8,REC=IREC) HARDAT(IFREQ)
              ENDDO
            ENDIF
           ENDDO
      ENDDO
C
C   Close the DASD file to flush the write buffer and re-open.
C
      CLOSE(8,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80) 
C
      DO J=1, NSTAV
          WRITE(52,*) J
          DO IFREQ=1, NFREQ
             IREC = IFREQ + (J-1)*NFREQ
             READ(8,REC=IREC) HARDAT(IFREQ)
             WRITE(52,'(A80)') HARDAT(IFREQ)
          ENDDO
      ENDDO              
C
C--Close the Global and Local fort.52 Files
C
9999  CONTINUE
      CLOSE(52)
      CLOSE(8,STATUS='DELETE')
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
c3679 FORMAT(1X,E20.10,1X,F10.7,1X,F12.8,1X,A10)
C
      RETURN
      END

      SUBROUTINE POST53()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the harmonic constituent elevations at all nodes from the      C
C  local fort.53 files.                                                     C
C  This version is compatible with ADCIRC version 34.03                     C
C  Fixed routine to handled arbitrary number of frequencies  1/30/99vjp     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,IPROC,IDUM,INDEX,NP1,IFREQ,IREC
      INTEGER NFREQ
      CHARACTER*80  NFREQMSG,INLINE
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)
      CHARACTER*80,ALLOCATABLE  ::  HEADER(:),HARDAT(:)

      ALLOCATE ( LOC(MNPROC))
      ALLOCATE ( LOCNAME(MNPROC))
      ALLOCATE (  HEADER(MNHARF),HARDAT(MNHARF))

C
C--If they exist open all Local & Global Sequential Formatted fort.53 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.53'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local unit 53 files found"
           RETURN
         ENDIF
      ENDDO
C
C   This is the global output file
C
      OPEN(UNIT=53,FILE='fort.53')
C
C   This is a DASD scratch file to reduce the memory requirement.
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80)
C
      DO IPROC = 1,NPROC
         IF (IPROC.EQ.1) THEN
           READ(LOC(IPROC),'(A80)')  NFREQMSG
           READ(NFREQMSG,*) NFREQ 
           WRITE(53,'(A80)') NFREQMSG
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') HEADER(I)
             WRITE(53,'(A80)') HEADER(I)
           ENDDO
           READ(LOC(IPROC),*) NP1
           WRITE(53,*) NNODG
         ELSE
           READ(LOC(IPROC),'(A80)')  INLINE
           READ(INLINE,*) IDUM 
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') INLINE
           ENDDO
           READ(LOC(IPROC),*) NP1
         ENDIF
      ENDDO
C
      DO IPROC = 1,NPROC
         DO J=1,NNODP(IPROC)
            READ(LOC(IPROC),*) IDUM
            INDEX = IMAP_NOD_LG(J,IPROC)
            IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
              DO IFREQ=1, NFREQ 
                 READ(LOC(IPROC),'(A80)') HARDAT(IFREQ)
                 IREC = IFREQ + (INDEX-1)*NFREQ
                 WRITE(8,REC=IREC) HARDAT(IFREQ) 
              ENDDO
            ELSE
              DO I=1, NFREQ 
                 READ(LOC(IPROC),'(A80)') INLINE
              ENDDO
            ENDIF
         ENDDO
      ENDDO
C
C   Close the DASD file to flush the write buffer and re-open.
C
      CLOSE(8,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80) 
C
      DO J=1, NNODG
         WRITE(53,*) J
         DO IFREQ=1, NFREQ 
            IREC = IFREQ + (J-1)*NFREQ
            READ(8,REC=IREC) HARDAT(IFREQ)    
            WRITE(53,'(A80)') HARDAT(IFREQ)
         ENDDO
      ENDDO        
C
C--Close the Global and Local fort.53 Files
C
9999  CONTINUE
      CLOSE(53)
      CLOSE(8,STATUS='DELETE')
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
c3679 FORMAT(1X,E20.10,1X,F10.7,1X,F12.8,1X,A10)
C
      RETURN
      END

      SUBROUTINE POST54()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the harmonic constituent velocities at all nodes from the      C
C  local fort.54 files.                                                     C
C  This version is compatible with ADCIRC version 34.03                     C
C  Fixed routine to handled multiple frequencies up to 32--9/18/98vjp       C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,IPROC,IDUM,INDEX,NP1,IFREQ,IREC
      INTEGER NFREQ
      CHARACTER*80  NFREQMSG,INLINE
      LOGICAL FOUND

      INTEGER,ALLOCATABLE  :: LOC(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)
      CHARACTER*80,ALLOCATABLE  ::  HEADER(:),HARDAT(:)

      ALLOCATE (LOC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))
      ALLOCATE ( HEADER(MNHARF),HARDAT(MNHARF))

C
C--If they exist open all Local & Global Sequential Formatted fort.54 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.54'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local unit 54 files found"
           RETURN
         ENDIF
      ENDDO
C
C   This is the global output file
C
      OPEN(UNIT=54,FILE='fort.54')
C
C   This is a DASD scratch file to save on memory.
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80)
C
      DO IPROC = 1,NPROC
         IF (IPROC.EQ.1) THEN
           READ(LOC(IPROC),'(A80)')  NFREQMSG
           READ(NFREQMSG,*) NFREQ 
           WRITE(54,'(A80)') NFREQMSG
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') HEADER(I)
             WRITE(54,'(A80)') HEADER(I)
           ENDDO
           READ(LOC(IPROC),*) NP1
           WRITE(54,*) NNODG
         ELSE
           READ(LOC(IPROC),'(A80)')  INLINE
           READ(INLINE,*) IDUM 
           DO I=1, NFREQ  
             READ(LOC(IPROC),'(A80)') INLINE
           ENDDO
           READ(LOC(IPROC),*) NP1
         ENDIF
      ENDDO
C
      DO IPROC = 1,NPROC
         DO J=1,NNODP(IPROC)
            READ(LOC(IPROC),*) IDUM
            INDEX = IMAP_NOD_LG(J,IPROC)
            IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
              DO IFREQ=1, NFREQ 
                 READ(LOC(IPROC),'(A80)') HARDAT(IFREQ)
                 IREC = IFREQ + (INDEX-1)*NFREQ
                 WRITE(8,REC=IREC) HARDAT(IFREQ) 
              ENDDO
            ELSE
              DO I=1, NFREQ 
                 READ(LOC(IPROC),'(A80)') INLINE
              ENDDO
            ENDIF
         ENDDO
      ENDDO
C
C   Close the DASD file to flush the write buffer and re-open.
C
      CLOSE(8,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=80) 
C
      DO J=1, NNODG
         WRITE(54,*) J
         DO IFREQ=1, NFREQ 
            IREC = IFREQ + (J-1)*NFREQ
            READ(8,REC=IREC) HARDAT(IFREQ)    
            WRITE(54,'(A80)') HARDAT(IFREQ)
         ENDDO
      ENDDO        
C
C--Close the Global and Local fort.54 Files
C
9999  CONTINUE
      CLOSE(54)
      CLOSE(8,STATUS='DELETE')
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
c3679 FORMAT(1X,E20.10,1X,F10.7,1X,F12.8,1X,A10)
C
      RETURN
      END

      SUBROUTINE POST55()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  4/13/98  )                         C
C  Globalize the harmonic constituent comparison file from the local        C
C  fort.55 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,IPROC,IDUM,INDEX,NP1
      INTEGER NFREQ
      CHARACTER*114 INLINE1,INLINE2
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE ( LOC(MNPROC))
      ALLOCATE (  LOCNAME(MNPROC))

C
C--If they exist open all Local & Global Sequential Formatted fort.55 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.55'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local unit 55 files found"
           RETURN
         ENDIF
      ENDDO
C
C   This is the global output file
C
      OPEN(UNIT=55,FILE='fort.55')
C
C   This is a DASD scratch file to save on memory.
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)       
C
C
      DO IPROC = 1,NPROC
         IF (IPROC.EQ.1) THEN
           READ(LOC(IPROC),*) NP1
           WRITE(55,*) NNODG
         ELSE
           READ(LOC(IPROC),*) NP1
         ENDIF
      ENDDO
C
      DO IPROC = 1,NPROC
         DO J=1,NNODP(IPROC)
            READ(LOC(IPROC),*) IDUM
            READ(LOC(IPROC),'(A114)') INLINE1
            INDEX = IMAP_NOD_LG(J,IPROC)
            IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
              WRITE(8,REC=INDEX)  INLINE1
            ENDIF
         ENDDO
      ENDDO
C
C   Close the DASD scratch file to flush the write buffer and re-open.
C
      CLOSE(8,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)       
C
      DO J=1, NNODG
          WRITE(55,*) J
          READ(8,REC=J) INLINE1
          WRITE(55,'(A114)') INLINE1
      ENDDO
      CLOSE(8,STATUS='DELETE')
C
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)    
      OPEN(UNIT=9,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)    
C
      DO IPROC = 1,NPROC
         DO J=1,NNODP(IPROC)
            READ(LOC(IPROC),*) IDUM
            READ(LOC(IPROC),'(A114)') INLINE1
            READ(LOC(IPROC),'(A114)') INLINE2
            INDEX = IMAP_NOD_LG(J,IPROC)
            IF (IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
              WRITE(8,REC=INDEX) INLINE1
              WRITE(9,REC=INDEX) INLINE2
            ENDIF
         ENDDO
      ENDDO
C
C   Close both DASD scratch files to flush the write buffers and re-open.
C
      CLOSE(8,STATUS='KEEP')
      CLOSE(9,STATUS='KEEP')
      OPEN(UNIT=8,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)    
      OPEN(UNIT=9,ACCESS='DIRECT',FORM='UNFORMATTED',RECL=114)    
C
      DO J=1, NNODG
          WRITE(55,*) J
          READ(8,REC=J) INLINE1
          READ(9,REC=J) INLINE2
          WRITE(55,'(A114)') INLINE1
          WRITE(55,'(A114)') INLINE2
      ENDDO
C
C--Close the Global and Local fort.55 Files
C
9999  CONTINUE
      CLOSE(55)
      CLOSE(8,STATUS='DELETE')
      CLOSE(9,STATUS='DELETE')
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
      RETURN
      END



      SUBROUTINE POST74()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the Wind Stress Data at all nodes from the local fort.74 files.C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC
      INTEGER NDSETGV,NSTEMP,NP,ITV,ITEMPV,INDEX
      INTEGER OREC
      REAL DTV,TIMEOUTV
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND

      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  UUBIN(:),VVBIN(:)
      REAL,ALLOCATABLE  ::  UUBINP(:),VVBINP(:)
      CHARACTER*80,ALLOCATABLE  ::  UU(:),UUP(:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE ( LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (  UUBIN(MNP),VVBIN(MNP))
      ALLOCATE (  UUBINP(MNPP),VVBINP(MNPP))
      ALLOCATE ( UU(MNP),UUP(MNPP))
      ALLOCATE ( LOCNAME(MNPROC))

C
C--Determine whether Unit 74 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(NOUTGW).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global fort.74 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.74'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.74 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSETGV,NP,DTV,NSTEMP,ITEMPV
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=74,FILE='fort.74')
C
      WRITE(74,'(A85)') INLINE
      WRITE(74,3645) NDSETGV,NNODG,DTV,NSPOOLGW,ITEMPV
C
      DO J=1,NDSETGV
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=2120,END=9999) TIMEOUTV,ITV
            IF (IPROC.EQ.1) WRITE(74,2120) TIMEOUTV,ITV
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),80) UUP(K)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF(IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                UU(INDEX) = UUP(K)
               ENDIF
            ENDDO
         ENDDO 
         DO I = 1,NNODG
            CALL NEWINDEX(UU(I),OUTMSG,I)
            WRITE(74,80) OUTMSG
         ENDDO
      ENDDO               
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.74 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.74'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',
     &       RECL=NBYTE)
         ELSE
           print *, "No Local fort.74 files found"
           RETURN
         ENDIF
      ENDDO
      OPEN(74,FILE='fort.74',ACCESS='DIRECT',RECL=NBYTE)
C
C--Read RUNDES RUNID and AGRID from each Local file
C
      DO IPROC = 1,NPROC
         IREC(IPROC) = 0
         IF (NBYTE.EQ.4) THEN
           DO I=1,8
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+8
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
           DO I=1,6
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID4(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+6
         ENDIF
         IF (NBYTE.EQ.8) THEN
           DO I=1,4
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RDES8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+4
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) RID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
           DO I=1,3
              READ(LOC(IPROC),REC=IREC(IPROC)+I) AID8(I)
           ENDDO
           IREC(IPROC)=IREC(IPROC)+3
         ENDIF
      ENDDO
C
C--Write RUNDES RUNID and AGRID to Global File
C
      OREC = 0
      IF (NBYTE.EQ.4) THEN
        DO I=1,8
           WRITE(74,REC=OREC+I) RDES4(I)
        ENDDO
        OREC=OREC+8
        DO I=1,6
           WRITE(74,REC=OREC+I) RID4(I)
        ENDDO
        OREC=OREC+6
        DO I=1,6
           WRITE(74,REC=OREC+I) AID4(I)
        ENDDO
        OREC=OREC+6
      ENDIF
      IF (NBYTE.EQ.8) THEN
        DO I=1,4
           WRITE(74,REC=OREC+I) RDES8(I)
        ENDDO
        OREC=OREC+4
        DO I=1,3
           WRITE(74,REC=OREC+I) RID8(I)
        ENDDO
        OREC=OREC+3
        DO I=1,3
           WRITE(74,REC=OREC+I) AID8(I)
        ENDDO
        OREC=OREC+3
      ENDIF
C
C--Read NTRSPV, NSTAV, DT*NSPOOLV from each Local file
C  and then close files to flush file buffers
C
      DO IPROC = 1,NPROC
         READ(LOC(IPROC),REC=IREC(IPROC)+1) NDSETGV
         READ(LOC(IPROC),REC=IREC(IPROC)+2) NP
         READ(LOC(IPROC),REC=IREC(IPROC)+3) DTV
         READ(LOC(IPROC),REC=IREC(IPROC)+4) NSTEMP
         READ(LOC(IPROC),REC=IREC(IPROC)+5) ITEMPV
         IREC(IPROC) = IREC(IPROC)+5
         CLOSE(LOC(IPROC))    ! Flush the Write Buffer
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
         OPEN(LOC(IPROC),FILE=LOCNAME(IPROC),ACCESS='DIRECT',RECL=NBYTE)
      ENDDO
C
C--Write same info to Global file and close it to flush buffer also
C
      WRITE(74,REC=OREC+1) NDSETGV
      WRITE(74,REC=OREC+2) NNODG
      WRITE(74,REC=OREC+3) DTV
      WRITE(74,REC=OREC+4) NSPOOLV
      WRITE(74,REC=OREC+5) ITEMPV
      OREC = OREC+5
      CLOSE(74)         ! Flush the Write Buffer
      OPEN(74,FILE='fort.74',ACCESS='DIRECT',RECL=NBYTE)
C
      DO J=1,NDSETGV
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),REC=IREC(IPROC)+1) TIMEOUTV
            READ(LOC(IPROC),REC=IREC(IPROC)+2) ITV
            IREC(IPROC) = IREC(IPROC) + 2
            DO K=1, NNODP(IPROC)
               READ(LOC(IPROC),REC=IREC(IPROC)+2*K-1) UUBINP(K)
               READ(LOC(IPROC),REC=IREC(IPROC)+2*K) VVBINP(K)
            ENDDO
            DO K=1,NNODP(IPROC)
               UUBIN(IMAP_NOD_LG(K,IPROC)) = UUBINP(K)
               VVBIN(IMAP_NOD_LG(K,IPROC)) = VVBINP(K)
            ENDDO
           IREC(IPROC) = IREC(IPROC) + 2*NNODP(IPROC)
         ENDDO
C
         WRITE(74,REC=OREC+1) TIMEOUTV
         WRITE(74,REC=OREC+2) ITV
         OREC = OREC + 2
         DO K=1, NNODG
            WRITE(74,REC=OREC+2*K-1) UUBIN(K)
            WRITE(74,REC=OREC+2*K)   VVBIN(K)
         ENDDO
         OREC = OREC + 2*NNODG
C
      ENDDO
C
9999  CONTINUE
C
C--Close the Global and Local fort.74 Files
C
      CLOSE(74)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A80)
 2120 FORMAT(2X,E20.10,5X,I10)
c2454 FORMAT(2X,I8,2(2X,E15.8))
 3645 FORMAT(1X,I10,1X,I10,1X,E15.7,1X,I5,1X,I5)
C
      RETURN
      END



      SUBROUTINE POST67_68()
      USE POST_GLOBAL 
C
C---------------------------------------------------------------------------C
C                     written 10/11/01 by RL                                C 
C                                                                           C  
C  This routine gathers the local hot start files (fort.67 and fort.68) and C
C  writes a global hotstart file                                            C
C                                                                           C
C---------------------------------------------------------------------------C
C
      IMPLICIT NONE
      LOGICAL FOUND
C     LOGICAL CHARMV

      INTEGER I,J,IPROC,LOCHSF,INDEX,IHOTSTP
      INTEGER IMHSF,ITHSF,IHOT,NHSFILES
      INTEGER IESTP,NSCOUE,IVSTP,NSCOUV,ICSTP,NSCOUC,IPSTP,IWSTP,NSCOUM,
     &        IGEP,NSCOUGE,IGVP,NSCOUGV,IGCP,NSCOUGC,IGPP,IGWP,NSCOUGW
      CHARACTER FNAME*60,LOCFN*14
      INTEGER,ALLOCATABLE  :: LOC(:),NODECODE(:)
      REAL(8),ALLOCATABLE :: ETA1(:),ETA2(:),UU2(:),VV2(:),CH1(:)
      REAL(8) TIMEHSF

C
C Allocate local work arrays
C
      ALLOCATE ( LOC(MNPROC) )
      ALLOCATE ( ETA1(MNP),ETA2(MNP),UU2(MNP),
     &                               VV2(MNP),NODECODE(MNP),CH1(MNP) )

C--Determine which hotstart files to process

      WRITE(*,*) 'Globalize hotstart file 67,68 or both ( 67, 68, 135 )'
      READ(*,*) IHOT
      NHSFILES=1
      IF(IHOT.EQ.135) THEN
        NHSFILES=2
        IHOT=67
        ENDIF

      DO J=1,NHSFILES
        IHOT=IHOT+J-1  

C--Set up unit numbers for all Local Hot Start files 

        DO IPROC = 1,NPROC
          LOC(IPROC) = 105 + (IPROC-1)
          ENDDO

C--Read common info from highest processor hotstart file

        IF(IHOT.EQ.67) LOCFN(1:14) = 'PE0000/fort.67'
        IF(IHOT.EQ.68) LOCFN(1:14) = 'PE0000/fort.68' 
        LOCHSF=LOC(NPROC)
        WRITE(LOCFN(3:6),'(I4.4)') (NPROC-1)
        OPEN (LOCHSF,FILE=LOCFN,ACCESS='DIRECT',RECL=8)
        IHOTSTP=1
        READ(LOCHSF,REC=IHOTSTP) IMHSF
        IHOTSTP=2
        READ(LOCHSF,REC=IHOTSTP) TIMEHSF
        IHOTSTP=3
        READ(LOCHSF,REC=IHOTSTP) ITHSF
        CLOSE(LOCHSF)                              !close to flush the buffer

C--Read stuff from each local file  

        DO IPROC=1,NPROC
          IF(IHOT.EQ.67) LOCFN(1:14) = 'PE0000/fort.67'
          IF(IHOT.EQ.68) LOCFN(1:14) = 'PE0000/fort.68' 
          LOCHSF=LOC(IPROC)
          WRITE(LOCFN(3:6),'(I4.4)') (IPROC-1)
          OPEN (LOCHSF,FILE=LOCFN,ACCESS='DIRECT',RECL=8)
          IHOTSTP=3
          DO I=1,NNODP(IPROC)
            INDEX=IMAP_NOD_LG(I,IPROC)
            READ(LOCHSF,REC=IHOTSTP+1) ETA1(INDEX)
            READ(LOCHSF,REC=IHOTSTP+2) ETA2(INDEX)
            READ(LOCHSF,REC=IHOTSTP+3) UU2(INDEX)
            READ(LOCHSF,REC=IHOTSTP+4) VV2(INDEX)
            IHOTSTP=IHOTSTP+4
c           IF(IM.EQ.10) THEN
c             READ(LOCHSF,REC=IHOTSTP+1) CH1(INDEX)
c             IHOTSTP=IHOTSTP+1
c             ENDIF
            READ(LOCHSF,REC=IHOTSTP+1) NODECODE(INDEX)
            IHOTSTP=IHOTSTP+1
            ENDDO
          CLOSE(LOCHSF)
          ENDDO

C--Read in more common info from higest processor hotstart file

        IF(IHOT.EQ.67) LOCFN(1:14) = 'PE0000/fort.67'
        IF(IHOT.EQ.68) LOCFN(1:14) = 'PE0000/fort.68' 
        LOCHSF=LOC(NPROC)
        WRITE(LOCFN(3:6),'(I4.4)') (NPROC-1)
        OPEN (LOCHSF,FILE=LOCFN,ACCESS='DIRECT',RECL=8)
        READ(LOCHSF,REC=IHOTSTP+1 ) IESTP
        READ(LOCHSF,REC=IHOTSTP+2 ) NSCOUE
        READ(LOCHSF,REC=IHOTSTP+3 ) IVSTP
        READ(LOCHSF,REC=IHOTSTP+4 ) NSCOUV
        READ(LOCHSF,REC=IHOTSTP+5 ) ICSTP
        READ(LOCHSF,REC=IHOTSTP+6 ) NSCOUC
        READ(LOCHSF,REC=IHOTSTP+7 ) IPSTP
        READ(LOCHSF,REC=IHOTSTP+8 ) IWSTP
        READ(LOCHSF,REC=IHOTSTP+9 ) NSCOUM
        READ(LOCHSF,REC=IHOTSTP+10) IGEP
        READ(LOCHSF,REC=IHOTSTP+11) NSCOUGE
        READ(LOCHSF,REC=IHOTSTP+12) IGVP
        READ(LOCHSF,REC=IHOTSTP+13) NSCOUGV
        READ(LOCHSF,REC=IHOTSTP+14) IGCP
        READ(LOCHSF,REC=IHOTSTP+15) NSCOUGC
        READ(LOCHSF,REC=IHOTSTP+16) IGPP
        READ(LOCHSF,REC=IHOTSTP+17) IGWP
        READ(LOCHSF,REC=IHOTSTP+18) NSCOUGW
        CLOSE(LOCHSF)

C--Open Appropriate Hot Start File based on the value of IHOT from the fort.15 file 

        IF(IHOT.EQ.67) FNAME='fort.67'
        IF(IHOT.EQ.68) FNAME='fort.68'
        OPEN(IHOT,FILE=FNAME,ACCESS='DIRECT',RECL=8)

C--Write out info to global file

        IHOTSTP=1
        WRITE(IHOT,REC=IHOTSTP) IMHSF
        IHOTSTP=2
        WRITE(IHOT,REC=IHOTSTP) TIMEHSF
        IHOTSTP=3
        WRITE(IHOT,REC=IHOTSTP) ITHSF
        DO I=1,MNP
          WRITE(IHOT,REC=IHOTSTP+1) ETA1(I)
          WRITE(IHOT,REC=IHOTSTP+2) ETA2(I)
          WRITE(IHOT,REC=IHOTSTP+3) UU2(I)
          WRITE(IHOT,REC=IHOTSTP+4) VV2(I)
          IHOTSTP = IHOTSTP + 4
c         IF(IM.EQ.10) THEN
c           WRITE(IHOT,REC=IHOTSTP+1) CH1(I)
c           IHOTSTP=IHOTSTP+1
c           ENDIF
          WRITE(IHOT,REC=IHOTSTP+1) NODECODE(I)
          IHOTSTP=IHOTSTP+1
          END DO
        WRITE(IHOT,REC=IHOTSTP+1 ) IESTP
        WRITE(IHOT,REC=IHOTSTP+2 ) NSCOUE
        WRITE(IHOT,REC=IHOTSTP+3 ) IVSTP
        WRITE(IHOT,REC=IHOTSTP+4 ) NSCOUV
        WRITE(IHOT,REC=IHOTSTP+5 ) ICSTP
        WRITE(IHOT,REC=IHOTSTP+6 ) NSCOUC
        WRITE(IHOT,REC=IHOTSTP+7 ) IPSTP
        WRITE(IHOT,REC=IHOTSTP+8 ) IWSTP
        WRITE(IHOT,REC=IHOTSTP+9 ) NSCOUM
        WRITE(IHOT,REC=IHOTSTP+10) IGEP
        WRITE(IHOT,REC=IHOTSTP+11) NSCOUGE
        WRITE(IHOT,REC=IHOTSTP+12) IGVP
        WRITE(IHOT,REC=IHOTSTP+13) NSCOUGV
        WRITE(IHOT,REC=IHOTSTP+14) IGCP
        WRITE(IHOT,REC=IHOTSTP+15) NSCOUGC
        WRITE(IHOT,REC=IHOTSTP+16) IGPP
        WRITE(IHOT,REC=IHOTSTP+17) IGWP
        WRITE(IHOT,REC=IHOTSTP+18) NSCOUGW
 
        CLOSE(IHOT)           

        ENDDO
C
      RETURN
      END


      SUBROUTINE POST41()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the 3D density data at the density stations from the local     C
C  fort.41 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,IG
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 41 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DSD).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open All Local Sequential Formatted fort.41 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.41'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.41 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.N3DSDP(IPROC)) THEN
            STOP 'Inconsistency in Number of 3D density Stations'
         ENDIF
      ENDDO
C
C--Open Global Sequential Formatted fort.41 file
C
      OPEN(UNIT=41,FILE='fort.41')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(41,'(A85)') INLINE
      WRITE(41,3645) NDSET,DT,NSPO3DSD,NHN3DSD,NFEN
C
      DO J=1,NDSET
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(41,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (N3DSDP(IPROC).GT.0) THEN
               DO K = 1,N3DSDP(IPROC)
                  READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                             VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
                  IG = IMAP_3DSD_LG(K,IPROC)
                  WRITE(41,1104) IG,(VAR1P(K,L),VAR2P(K,L),VAR3P(K,L),
     &                                                       L=1,NFEN)
               ENDDO
            ENDIF
         ENDDO            
C
      ENDDO                 
      GO TO 9999
C 
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.41 file
C
C !!! THIS NEEDS TO BE WRITTEN !!!

C
C--Close the Global and Local fort.61 Files
C
9999  CONTINUE
      CLOSE(41)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A40)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3645 FORMAT(1X,I10,1X,E15.7,1X,I10,1X,I10,1X,I10//)
C
      RETURN
      END


      SUBROUTINE POST42()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the 3D velocity data at the velocity stations from the local   C
C  fort.42 files.                                                           C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,IG
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 42 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DSV).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open All Local Sequential Formatted fort.42 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.42'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.42 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.N3DSVP(IPROC)) THEN
            STOP 'Inconsistency in Number of 3D velocity Stations'
         ENDIF
      ENDDO
C
C--Open Global Sequential Formatted fort.42 file
C
      OPEN(UNIT=42,FILE='fort.42')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(42,'(A85)') INLINE
      WRITE(42,3645) NDSET,DT,NSPO3DSV,NHN3DSV,NFEN
C
      DO J=1,NDSET
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(42,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (N3DSVP(IPROC).GT.0) THEN
               DO K = 1,N3DSVP(IPROC)
                  READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                             VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
                  IG = IMAP_3DSV_LG(K,IPROC)
                  WRITE(42,1104) IG,(VAR1P(K,L),VAR2P(K,L),VAR3P(K,L),
     &                                                       L=1,NFEN)
               ENDDO
            ENDIF
         ENDDO            
C
      ENDDO                 
      GO TO 9999
C 
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.42 file
C
C !!! THIS NEEDS TO BE WRITTEN !!!

C
C--Close the Global and Local fort.42 Files
C
9999  CONTINUE
      CLOSE(42)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A40)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3645 FORMAT(1X,I10,1X,E15.7,1X,I10,1X,I10,1X,I10//)
C
      RETURN
      END


      SUBROUTINE POST43()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the 3D turbulence data at the turbulence stations from the     C
C  local fort.43 files.                                                     C
C  This version is compatible with ADCIRC version 34.03                     C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,IG
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 43 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DST).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open All Local Sequential Formatted fort.43 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.43'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.43 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.N3DSTP(IPROC)) THEN
            STOP 'Inconsistency in Number of 3D turbulence Stations'
         ENDIF
      ENDDO
C
C--Open Global Sequential Formatted fort.43 file
C
      OPEN(UNIT=43,FILE='fort.43')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(43,'(A85)') INLINE
      WRITE(43,3645) NDSET,DT,NSPO3DST,NHN3DST,NFEN
C
      DO J=1,NDSET
C
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(43,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (N3DSTP(IPROC).GT.0) THEN
               DO K = 1,N3DSTP(IPROC)
                  READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                             VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
                  IG = IMAP_3DST_LG(K,IPROC)
                  WRITE(43,1104) IG,(VAR1P(K,L),VAR2P(K,L),VAR3P(K,L),
     &                                                       L=1,NFEN)
               ENDDO
            ENDIF
         ENDDO            
C
      ENDDO                 
      GO TO 9999
C 
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.43 file
C
C !!! THIS NEEDS TO BE WRITTEN !!!

C
C--Close the Global and Local fort.43 Files
C
9999  CONTINUE
      CLOSE(43)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
   80 FORMAT(A40)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3645 FORMAT(1X,I10,1X,E15.7,1X,I10,1X,I10,1X,I10//)
C
      RETURN
      END


      SUBROUTINE POST44()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the Density Data at all nodes from the local fort.44 files.    C
C  This version is compatible with ADCIRC version 41.11a                    C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,INDEX
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:),VAR1(:,:),VAR2(:,:),VAR3(:,:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 44 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DGD).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global fort.44 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.44'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.44 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=44,FILE='fort.44')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1(MNP,NFEN),VAR2(MNP,NFEN),VAR3(MNP,NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(44,'(A85)') INLINE
      WRITE(44,3645) NDSET,DT,NSPO3DGD,NNODG,NFEN
C
      DO J=1,NDSET
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(44,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                                   VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF(IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                 DO L=1,NFEN
                   VAR1(INDEX,L) = VAR1P(K,L)
                   VAR2(INDEX,L) = VAR2P(K,L)
                   VAR3(INDEX,L) = VAR3P(K,L)
                 ENDDO
               ENDIF
            ENDDO
         ENDDO 
         DO I = 1,NNODG
            WRITE(44,1104) I,(VAR1(I,L),VAR2(I,L),VAR3(I,L),L=1,NFEN)
         ENDDO
      ENDDO               
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.44 file
C
C !!!THIS NEEDS TO BE WRITTEN!!!
C
9999  CONTINUE
C
C--Close the Global and Local fort.44 Files
C
      CLOSE(44)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
      DEALLOCATE(SIGMA)
      DEALLOCATE(VAR1,VAR2,VAR3)
      DEALLOCATE(VAR1P,VAR2P,VAR3P)
C
   80 FORMAT(A80)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3645 FORMAT(1X,I10,1X,E15.7,I10,1X,I10,1X,I10//)
C
      RETURN
      END


      SUBROUTINE POST45()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the Velocity Data at all nodes from the local fort.45 files.   C
C  This version is compatible with ADCIRC version 41.11a                    C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,INDEX
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:),VAR1(:,:),VAR2(:,:),VAR3(:,:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 45 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DGV).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global fort.45 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.45'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.45 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3645) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=45,FILE='fort.45')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1(MNP,NFEN),VAR2(MNP,NFEN),VAR3(MNP,NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(45,'(A85)') INLINE
      WRITE(45,3645) NDSET,DT,NSPO3DGV,NNODG,NFEN
C
      DO J=1,NDSET
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(45,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                                   VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF(IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                 DO L=1,NFEN
                   VAR1(INDEX,L) = VAR1P(K,L)
                   VAR2(INDEX,L) = VAR2P(K,L)
                   VAR3(INDEX,L) = VAR3P(K,L)
                 ENDDO
               ENDIF
            ENDDO
         ENDDO 
         DO I = 1,NNODG
            WRITE(45,1104) I,(VAR1(I,L),VAR2(I,L),VAR3(I,L),L=1,NFEN)
         ENDDO
      ENDDO               
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.45 file
C
C !!!THIS NEEDS TO BE WRITTEN!!!
C
9999  CONTINUE
C
C--Close the Global and Local fort.45 Files
C
      CLOSE(45)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
      DEALLOCATE(SIGMA)
      DEALLOCATE(VAR1,VAR2,VAR3)
      DEALLOCATE(VAR1P,VAR2P,VAR3P)
C
   80 FORMAT(A80)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3645 FORMAT(1X,I10,1X,E15.7,I10,1X,I10,1X,I10//)
C
      RETURN
      END


      SUBROUTINE POST46()
C
C---------------------------------------------------------------------------C
C                     (  Serial Version  3/28/98  )                         C 
C  Globalize the Turbulence Data at all nodes from the local fort.46 files. C
C  This version is compatible with ADCIRC version 41.11a                    C
C---------------------------------------------------------------------------C
C
      USE POST_GLOBAL
      INTEGER I,J,K,L,IPROC,IDUM
      INTEGER NDSET,NSTEMP,NP,IT,ITEMP,INDEX
      INTEGER OREC
      REAL DT,TIMEOUT
      CHARACTER*80  OUTMSG
      CHARACTER*85 INLINE
      CHARACTER*4 RDES4(8),RID4(6),AID4(6)
      CHARACTER*8 RDES8(8),RID8(6),AID8(6)
      LOGICAL FOUND


      INTEGER,ALLOCATABLE  :: LOC(:),IREC(:)
      REAL,ALLOCATABLE  ::  SIGMA(:),VAR1(:,:),VAR2(:,:),VAR3(:,:)
      REAL,ALLOCATABLE  ::  VAR1P(:,:),VAR2P(:,:),VAR3P(:,:)
      CHARACTER*14,ALLOCATABLE  ::  LOCNAME(:)

      ALLOCATE (LOC(MNPROC),IREC(MNPROC))
      ALLOCATE (LOCNAME(MNPROC))

C
C--Determine whether Unit 46 is Sequential Formatted or Direct Access Binary
C
      IF (ABS(I3DGT).EQ.1) THEN
        GO TO 1000
      ELSE
        GO TO 2000
      ENDIF
C
1000  CONTINUE
C
C--Open Global fort.46 file
C
      DO IPROC = 1,NPROC
         LOCNAME(IPROC) = 'PE0000/fort.46'
         WRITE(LOCNAME(IPROC)(3:6),'(I4.4)') (IPROC-1)
         LOC(IPROC) = 105 + (IPROC-1)
         INQUIRE(FILE=LOCNAME(IPROC),EXIST=FOUND)
         IF (FOUND) THEN
           OPEN(LOC(IPROC),FILE=LOCNAME(IPROC))
         ELSE
           print *, "No Local fort.46 files found"
           RETURN
         ENDIF
         READ(LOC(IPROC),'(A85)')  INLINE
         READ(LOC(IPROC),3646) NDSET,DT,NSTEMP,NP,NFEN
         IF (NP.NE.NNODP(IPROC)) THEN
           STOP 'Inconsistency in number of local nodes'
         ENDIF
      ENDDO
      OPEN(UNIT=46,FILE='fort.46')
C
      ALLOCATE(SIGMA(NFEN))
      ALLOCATE(VAR1(MNP,NFEN),VAR2(MNP,NFEN),VAR3(MNP,NFEN))
      ALLOCATE(VAR1P(MNPP,NFEN),VAR2P(MNPP,NFEN),VAR3P(MNPP,NFEN))
C
      WRITE(46,'(A85)') INLINE
      WRITE(46,3646) NDSET,DT,NSPO3DGT,NNODG,NFEN
C
      DO J=1,NDSET
         DO IPROC=1,NPROC
            READ(LOC(IPROC),FMT=1100,END=9999) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            IF (IPROC.EQ.1) WRITE(46,1100) TIMEOUT,IT,
     &                    (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &                     SIGMA(NFEN),SIGMA(NFEN)
            DO K = 1,NNODP(IPROC)
               READ(LOC(IPROC),1104,END=9999) IDUM,(VAR1P(K,L),
     &                                   VAR2P(K,L),VAR3P(K,L),L=1,NFEN)
               INDEX = IMAP_NOD_LG(K,IPROC)
               IF(IMAP_NOD_GL(1,INDEX).EQ.IPROC) THEN
                 DO L=1,NFEN
                   VAR1(INDEX,L) = VAR1P(K,L)
                   VAR2(INDEX,L) = VAR2P(K,L)
                   VAR3(INDEX,L) = VAR3P(K,L)
                 ENDDO
               ENDIF
            ENDDO
         ENDDO 
         DO I = 1,NNODG
            WRITE(46,1104) I,(VAR1(I,L),VAR2(I,L),VAR3(I,L),L=1,NFEN)
         ENDDO
      ENDDO               
      GO TO 9999
C
2000  CONTINUE
C
C--Open All Local and the Global Direct Access Binary fort.46 file
C
C !!!THIS NEEDS TO BE WRITTEN!!!
C
9999  CONTINUE
C
C--Close the Global and Local fort.46 Files
C
      CLOSE(46)
      DO IPROC = 1,NPROC
         CLOSE(LOC(IPROC))
      ENDDO
C
      DEALLOCATE(SIGMA)
      DEALLOCATE(VAR1,VAR2,VAR3)
      DEALLOCATE(VAR1P,VAR2P,VAR3P)
C
   80 FORMAT(A80)
 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))
 1104 FORMAT(9X,I6,4X,32000(E12.6,2X))
 3646 FORMAT(1X,I10,1X,E15.7,I10,1X,I10,1X,I10//)
C
      RETURN
      END

