c----------------------------------------------------------------------------
c
c                           MODULE PRESIZES
c
c----------------------------------------------------------------------------
c
c                  For use with ADCPREP Version 1.6 (  5/21/03 )
c
c                     current for ADCIRC v43.03   5/20/2003
c----------------------------------------------------------------------------

      MODULE PRESIZES
c
      IMPLICIT NONE
     
c
c...SET NUMBER OF BYTES "SZ" IN REAL(SZ) DECLARATIONS       
c...SET "NBYTE" FOR PROCESSING INPUT DATA RECORD LENGTH

#ifdef  REAL4
      INTEGER, PARAMETER :: SZ = 4
      INTEGER, PARAMETER :: NBYTE=4
#else
      INTEGER, PARAMETER :: SZ = 8
      INTEGER, PARAMETER :: NBYTE=8
#endif

c...SET MAX OF DIGITS OF PRECISION "NPREC" THE GRID CAN BE EXPECTED TO HAVE
c...NOTE: IF THE GRID WAS BUILT ON A 32 BIT COMPUTER, IT SHOULD BE
c   ACCURATE TO ABOUT 7 DIGITS.  THUS, IF THE NODAL SPACING REQUIRES MORE
c   THAN 5 DIGITS OF PRECISION, THE MODEL RESULTS MAY NOT BE TRUSTWORTHY.
 
      INTEGER, PARAMETER ::  NPREC=7
c
      INTEGER ::  MNPROC,MNE,MNP,MNEI,MNOPE,MNETA,MNBOU,MNVEL,
     &  MNTIF,MNBFR,MNFFR,MNSTAE,MNSTAV,MNSTAC,MNSTAM,MNWP,MNWLAT,
     &  MNWLON,MNHARF

      INTEGER :: NHN3DSD,NHN3DSV,NHN3DST

c......BDE
c  Added NWS_MCEL incase it is needed
c......BDE

      INTEGER ::  MNPP, MNEP, NWS_MCEL

      LOGICAL C2DDI,C3D,C3DDSS,C3DVS,CLUMP,CTIP,CSOLIT,CSOLDIR,
     &  CSOLDIA,CHARMV
c
c For Definition of Working Directory
c
      INTEGER,SAVE :: MYPROC

      INTEGER,SAVE :: LNAME = 6
      CHARACTER*6,SAVE :: DIRNAME = 'PE0000'
      
c---------------------end of data declarations--------------------------------C


      CONTAINS


      SUBROUTINE MAKE_DIRNAME()
      WRITE(DIRNAME(3:6),'(I4.4)') MYPROC
      RETURN
      END SUBROUTINE


      SUBROUTINE SIZEUP()
c
c-----------------------------------------------------------------------------C
c  Determine sizes of Arrays for ADCIRC. The variables determined are:        C
c                                                                             C
c   MNE     =   Number of Elements                                            C
c   MNP     =   Number of Nodes                                               C
c   MNEI    =   1 + Maxnodes Connected to any Node                            C
c   MNOPE   =   Number of Elevation Boundary Segments                         C
c   MNETA   =   Number of Elevation Boundary Nodes                            C
c   MNBOU   =   Number of Land Boundary Segments                              C
c   MNVEL   =   Number of Land Boundary Nodes                                 C
c   MNTIF   =   Number of Tidal Potential Constituents                        C
c   MNBFR   =   Number of Periodic Elevation Boundary Forcing Constituents    C
c   MNFFR   =   Number of Periodic Normal Flow Boundary Forcing Constituents  C
c   MNSTAE  =   Number of Elevation Recording Stations                        C
c   MNSTAV  =   Number of Velocity Recording Stations                         C
c   MNSTAC  =   Number of Concentration Recording Stations                    C
c   MNSTAM  =   Number of meteorological Recording Stations                   C
c   MNWP    =   1 If No Meteorlogical Forcing else = MNP                      C
c   MNWLAT  =   Number of Latitudes                                           C
c   MNWLON  =   Number of Longitudes                                          C
c   MNHARF  =   Number of Constituents in Harmonic Analysis                   C
c   MNPP    =   Number of Max nodes of any subdomain                          C
c   MNEP    =   Number of Max elements of any subdomain                       C
c   NHN3DSD =   Number of 3D density recording stations                       C
c   NHN3DSV =   Number of 3D velocity recording stations                      C
c   NHN3DST =   Number of 3D turbulence recording stations                    C
c  Determine runtime option logicals defined below:                           C
c                                                                             C
c Model Type:                                                                 C
c   C2DDI   = .TRUE.  only if  IM = 0, 10                                     C
c   C3D     = .TRUE.  only if  IM = 1, 2                                      C
c   C3DDSS  = .TRUE.  only if  IM = 2                                         C
c   C3DVS   = .TRUE.  only if  IM = 1                                         C
c                                                                             C
c Tidal Forcing:                                                              C
c   CTIP    = .TRUE.  only if  NTIP <> 0                                      C
c                                                                             C
c Solver Type:                                                                C
c   CSOLDIA = .TRUE.  only if  ITITER < 0                                     C
c   CSOLDIR = .TRUE.  only if  ITITER = 0                                     C
c   CSOLIT  = .TRUE.  only if  ITITER > 0                                     C
c                                                                             C
c GWCE Lumping:                                                               C
c   CLUMP   = .TRUE.  only if  ILUMP > 0                                      C
c                                                                             C
c Harmonic Analysis:                                                          C
c   CHARMV  = .TRUE.  only if  NHARF > 0 .AND. C2DDI = .TRUE.                 C
c                                                                             C
c vjp 12/08/99                                                                C
c rl  10/10/01
c-----------------------------------------------------------------------------C
c
      IMPLICIT NONE
      INTEGER, ALLOCATABLE :: NNEIGH(:)
      INTEGER  I,IL,IDUM,N,N1,N2,N3,NDIF1,NDIF2,NDIF3,NETA,NBN,NVEL,
     &  IK,IBN,NDISC,NBBN,NFLUXB,NFLUXI,NFLUXF,NIBP,IBTYPE,IBN1,IM,NWP,
     &  NCOR,NTIP,NWS,NRAMP,IREFYR,NTIF,IL1,Il2,NHARF,NHAINC,IDUM2,
     &  ITITER,ILUMP
      INTEGER NRS
      REAL RSTIMINC
      REAL GRAVITY,TAU0,DT,STATIM,REFTIM,WTIMINC,RDUM,A00,B00,C00,
     &  THAS,THAF,FMV
      INTEGER IEVC,I3DSD,I3DSV,I3DST
      CHARACTER*95 LINEI
      CHARACTER*1 CHARI(95)
      EQUIVALENCE (LINEI,CHARI(1))
      LOGICAL FOUND
      CHARACTER*60 GRID,RUNINFO
c
c...OPEN AND PROCESS THE UNIT 14 ADCIRC GRID FILE TO DETERMINE SIZES
c
      FOUND = .FALSE.
31    WRITE(*,*) 'Enter the name of the ADCIRC UNIT 14 (Grid) file:'
      READ(*,60) GRID
      INQUIRE(FILE=GRID,EXIST=FOUND)
      IF(FOUND) GOTO 32
      WRITE(*,1010) GRID
      GOTO 31
32    WRITE(*,1011) GRID
      OPEN(14,FILE=GRID)

33    READ(14,80) LINEI                             !SKIP OVER AGRID
      DO I=1,95
         IF(CHARI(I).NE.' ') GOTO 34
         END DO
      GOTO 33
34    READ(14,*) MNE,MNP                            !PROCESS MNE,MNP
c
      ALLOCATE (NNEIGH(MNP))                        !Allocate Neighbor Table
c
      DO IL=1,MNP                                   !SKIP OVER NODES
         READ(14,*) IDUM                            
         NNEIGH(IL)=0                            
      END DO
c
      DO IL=1,MNE                                   !READ IN THE ELEMENT
         READ(14,*) N,IDUM,N1,N2,N3                 !CONNECTIVITY TABLE
         NNEIGH(N1)=NNEIGH(N1)+1                    !DETERMINE THE # OF NEIGHBORS
         NNEIGH(N2)=NNEIGH(N2)+1                              
         NNEIGH(N3)=NNEIGH(N3)+1                           
      ENDDO
c
      NETA=0                                        !PROCESS OPEN BOUNDARIES
      READ(14,*) MNOPE                             
      READ(14,*) MNETA                           
c
      MNEI=0                                        !PROCESS MAX # NEIGHBORS
      DO IL=1,MNOPE
         READ(14,*) NBN
         NETA=NETA+NBN
         DO IK=1,NBN
            READ(14,*) IBN
            IF (NNEIGH(IBN).NE.0) THEN
              NNEIGH(IBN)=NNEIGH(IBN)+1
              IF (NNEIGH(IBN).GT.MNEI) MNEI=NNEIGH(IBN)
                NNEIGH(IBN) = 0
              ENDIF
         ENDDO
      ENDDO
      NETA = MNETA
      IF(MNOPE.EQ.0) MNOPE=1
      IF(MNETA.EQ.0) MNETA=1
c
      NVEL=0                            !PROCESS LAND BOUNDARIES
      NDISC=0                           !non-zero normal discharge
      NBBN=0                            !NO. OF MAINLAND BARRIER BOUNDARY NODES
      NFLUXB=0                          !SPECIFIED MAINLAND BARRIER BC
      NIBP=0                            !NO. OF INTERNAL BARRIER BOUNDARY PAIRS
      NFLUXI=0                          !SPECIFIED INTERNAL BARRIER BC
      NFLUXF=0                          !SPECIFIED FLUX BC
c
      READ(14,*) MNBOU                  !Land Boundary Segments    
      READ(14,*) MNVEL                  !Land Boundary Nodes
c
      DO IL=1,MNBOU
         READ(14,*) NBN,IBTYPE
         IF((IBTYPE.EQ.2).OR.(IBTYPE.EQ.12).OR.(IBTYPE.EQ.22)) THEN
           NFLUXF=1
           NDISC=NDISC+NBN
         ENDIF
         IF((IBTYPE.EQ.3).OR.(IBTYPE.EQ.13).OR.(IBTYPE.EQ.23)) THEN
           NFLUXB=1
           NBBN=NBBN+NBN
         ENDIF
         IF((IBTYPE.EQ.4).OR.(IBTYPE.EQ.24)) THEN
           NFLUXI=1
           NIBP=NIBP+NBN
         ENDIF
         IF((IBTYPE.NE.2).AND.(IBTYPE.NE.12).AND.(IBTYPE.NE.22).AND.
     &     (IBTYPE.NE.3).AND.(IBTYPE.NE.13).AND.(IBTYPE.NE.23).AND.   
     &     (IBTYPE.NE.4).AND.(IBTYPE.NE.24)) THEN
           NVEL=NVEL+NBN
         ENDIF
         IBN1=0
         DO IK=1,NBN
            READ(14,*) IBN
            IF (NNEIGH(IBN).NE.0) THEN
              NNEIGH(IBN)=NNEIGH(IBN)+1
              IF (NNEIGH(IBN).GT.MNEI) MNEI=NNEIGH(IBN)
              NNEIGH(IBN) = 0
            ENDIF
            IF ((IBTYPE.EQ.1).OR.(IBTYPE.EQ.11).OR.(IBTYPE.EQ.21)) THEN 
              IF ((IK.EQ.NBN).AND.(IBN.NE.IBN1)) NVEL=NVEL+1
            ENDIF
            IF (IK.EQ.1) IBN1=IBN
         ENDDO
      ENDDO
c
      MNVEL=NVEL+NDISC+NBBN+2*NIBP
      IF(MNBOU.EQ.0) MNBOU=1
      MNVEL=MNVEL+1
c
      DO IL=1,MNP   ! FINISH DET. MAX # NEIGHBORS
         IF(NNEIGH(IL).GT.MNEI) MNEI=NNEIGH(IL)
      END DO
      MNEI=MNEI+1
c
      REWIND(14)
c
c...OPEN AND PROCESS THE UNIT 15 ADCIRC EXTERNAL MODE (2DDI)
c...HORIZONTAL RUN INFORMATION FILE
c
c--Enter, Locate, Open, and Read the ADCIRC UNIT 15 (Run Info) File
c
      FOUND = .FALSE.
131   WRITE(*,*) 'Enter the name of the ADCIRC UNIT 15 (Run Info) file:'
      READ(*,60) RUNINFO
      INQUIRE(FILE=RUNINFO,EXIST=FOUND)
      IF(FOUND) GOTO 132
      WRITE(*,1010) RUNINFO
      GOTO 131
132   WRITE(*,1011) RUNINFO
      OPEN(15,FILE=RUNINFO)
c
c  Initialize all runtime option logicals to false
c
      C2DDI  = .FALSE.
      C3D    = .FALSE.
      C3DDSS = .FALSE.
      C3DVS  = .FALSE.
      CLUMP  = .FALSE.
      CTIP   = .FALSE.
      CSOLIT = .FALSE.
      CHARMV = .FALSE.
c
23    READ(15,80) LINEI                             !SKIP OVER RUNDES
      DO I=1,95
         IF(CHARI(I).NE.' ') GOTO 24
         END DO
      GOTO 23
24    READ(15,80) LINEI                             !SKIP OVER RUNID
      DO I=1,95
         IF(CHARI(I).NE.' ') GOTO 25
      ENDDO
      GOTO 24
c
25    DO IL=1,5                                     !SKIP OVER NFOVER-ICS
         READ(15,*) IDUM
      ENDDO
      READ(15,*) IM                                 !READ IM (model type)
      IF (IM.EQ.0) THEN
        C2DDI = .TRUE.
      ELSEIF (IM.EQ.1) THEN
        C3D  = .TRUE.
        C3DVS  = .TRUE.
      ELSEIF (IM.EQ.2) THEN
c       C3D  = .TRUE.
c       C3DDSS = .TRUE.
        print *, "DSS model type not presently supported"
        stop
      ELSEIF (IM.EQ.10) THEN
        C2DDI = .TRUE.
      ELSE
        print *, "model type not supported"
        stop
      ENDIF
      DO IL=1,4                                     !SKIP OVER NOLIBF-NOLICAT
         READ(15,*) IDUM
      ENDDO
      READ(15,*) NWP                                !SKIP OVER NWP
      READ(15,*) NCOR                               !SKIP OVER NCOR
      READ(15,*) NTIP                               !READ NTIP
      IF (NTIP.NE.0) CTIP = .TRUE.
      READ(15,*) NWS                                !READ NWS
      READ(15,*) NRAMP                              !SKIP OVER NRAMP
      READ(15,*) GRAVITY                            !SKIP OVER GRAVITY
      READ(15,*) TAU0                               !SKIP OVER TAU0
      READ(15,*) DT                                 !SKIP OVER DT
      READ(15,*) STATIM                             !SKIP OVER STATIM
      READ(15,*) REFTIM                             !SKIP OVER REFTIM
      MNWLAT = 1
      MNWLON = 1
      MNWP=1
c
      NRS=0

c......BDE
c  Adjusts for NWS=1000 now
c......BDE
      !Retain original NWS setting for MCEL
      NWS_MCEL = NWS
      IF(ABS(NWS).GE.1000) THEN
         NRS=1
	 !Adjust NWS as normal
         NWS=(ABS(NWS)-1000)*(NWS/ABS(NWS))
      ENDIF

      IF(ABS(NWS).GE.100)THEN
        NRS=1
        NWS=(ABS(NWS)-100)*(NWS/ABS(NWS))
        ENDIF
      IF((NWS.EQ.0).AND.(NRS.EQ.1)) READ(15,*) RSTIMINC
      IF((NWS.EQ.1).AND.(NRS.EQ.1)) READ(15,*) RSTIMINC

      IF((ABS(NWS).EQ.2).OR.(ABS(NWS).EQ.4).OR.(ABS(NWS).eq.5)) THEN
        IF(NRS.EQ.0) READ(15,*) WTIMINC
        IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
        MNWP=MNP
        ENDIF

      IF(NWS.EQ.3) THEN
        READ(15,*) IREFYR                          !SKIP THE REST OF THIS LINE
        READ(15,*) MNWLAT,MNWLON                   !SKIP THE REST OF THIS LINE
        MNWP=MNP
        ENDIF

      IF(ABS(NWS).EQ.6) THEN
        IF(NRS.EQ.0) READ(15,*) WTIMINC            !SKIP OVER WTIMINC
        IF(NRS.EQ.1) READ(15,*) WTIMINC,RSTIMINC
        MNWP=MNP
        ENDIF

      DO IL=1,2                                    !SKIP OVER RNDAY,DRAMP
        READ(15,*) RDUM
        ENDDO
      READ(15,*) A00,B00,C00                       !READ IN GWCE TIME WEIGHTING COEFFS
      DO IL=1,5                                    !SKIP OVER H0 - CORI
        READ(15,*) RDUM
        ENDDO
      READ(15,*) NTIF                              !PROCESS NTIF
      DO IL=1,NTIF                                 !SKIP OVER TIPOTAG & TPK, AMIGT,etc.
26     READ(15,80) LINEI
        DO I=1,95
          IF(CHARI(I).NE.' ') GOTO 27
          ENDDO
        GOTO 26
27     READ(15,*) RDUM
        ENDDO
      MNTIF=NTIF
      IF(NTIF.EQ.0) MNTIF=1
      READ(15,*) MNBFR                             !PROCESS MNBFR
      DO IL=1,MNBFR                                !SKIP OVER BOUNTAG, & AMIG, FF,etc.
28     READ(15,80) LINEI
        DO I=1,95
          IF(CHARI(I).NE.' ') GOTO 29
          ENDDO
        GOTO 28
29     READ(15,*) RDUM
        ENDDO
      DO IL1=1,MNBFR
40     READ(15,80) LINEI                          !SKIP OVER ALPHA
        DO I=1,95
          IF(CHARI(I).NE.' ') GOTO 41
          END DO
        GOTO 40
41     DO IL2=1,NETA
          READ(15,*) RDUM                          !SKIP OVER BOUNDARY FORCINGS
          ENDDO
        ENDDO
      IF(MNBFR.EQ.0) MNBFR=1
      READ(15,*)  RDUM                             !SKIP OVER ANGIN
      MNFFR=0
      IF(NFLUXF.EQ.1) READ(15,*) MNFFR             !# FREQ IN NORMAL FLUX B.C.
      DO IL=1,MNFFR                                !SKIP OVER BOUNTAG, & AMIG, FF,etc.
42     READ(15,80) LINEI
        DO I=1,95
          IF(CHARI(I).NE.' ') GOTO 43
          ENDDO
        GOTO 42
43     READ(15,*) RDUM
        ENDDO
      DO IL1=1,MNFFR
44     READ(15,80) LINEI                          !SKIP OVER ALPHA
        DO I=1,95
          IF(CHARI(I).NE.' ') GOTO 45
          ENDDO
        GOTO 44
45     DO IL2=1,NDISC
          READ(15,*) RDUM                          !SKIP OVER BOUNDARY FORCINGS
          ENDDO
        ENDDO
      IF(MNFFR.EQ.0) MNFFR=1
      MNSTAE=0
      READ(15,*)  IDUM                              !SKIP OVER NOUTE, TOUTSE...
      READ(15,*) MNSTAE                             !PROCESS MNSTAE
      DO IL=1,MNSTAE
         READ(15,*) RDUM                            !SKIP OVER STA COORDS
      ENDDO
      IF(MNSTAE.EQ.0) MNSTAE=1
      MNSTAV=0
      READ(15,*) IDUM                               !SKIP OVER NOUTV, TOUTSV...
      READ(15,*) MNSTAV                             !PROCESS MNSTAV
      DO IL=1,MNSTAV
         READ(15,*) RDUM                            !SKIP OVER STA COORDS
      ENDDO
      IF(MNSTAV.EQ.0) MNSTAV=1
      MNSTAC=0
      IF(IM.EQ.10) THEN
         READ(15,*) IDUM                            !SKIP OVER NOUTC, TOUTSC...
         READ(15,*) MNSTAC                          !PROCESS MNSTAC
         DO IL=1,MNSTAC
            READ(15,*) RDUM                         !SKIP OVER STA COORDS
         ENDDO
      ENDIF
      IF(MNSTAC.EQ.0) MNSTAC=1
      MNSTAM=0
      IF(NWS.NE.0) THEN
        READ(15,*) IDUM                           !SKIP OVER NOUTM, TOUTSM...
        READ(15,*) MNSTAM                         !PROCESS MNSTAM
        DO IL=1,MNSTAM
           READ(15,*) RDUM                        !SKIP OVER STA COORDS
        END DO
      ENDIF
      IF(MNSTAM.EQ.0) MNSTAM=1
c
      READ(15,*) IDUM                            !SKIP OVER NOUTGE, TOUTSGE...
      READ(15,*) IDUM                            !SKIP OVER NOUTGV, TOUTSGV...
      IF(IM.EQ.10) READ(15,*) IDUM               !SKIP OVER NOUTGC, TOUTSGC...
      IF(NWS.NE.0) READ(15,*) IDUM               !SKIP OVER NOUTGW, TOUTSGW...
      MNHARF = 0
      READ(15,*) NHARF                           !PROCESS MNHARF
      DO IL1=1,NHARF
47      READ(15,80) LINEI                       !SKIP OVER HAFNAM
         DO I=1,95
            IF(CHARI(I).NE.' ') GOTO 48
         ENDDO
         GOTO 47
48      READ(15,*) RDUM,RDUM,RDUM             !SKIP OVER HAFREQ,HAFF,HAFACE
      ENDDO
      MNHARF=NHARF
      IF(NHARF.EQ.0) MNHARF=1
c
      IF (NHARF.GT.0.AND.C2DDI) CHARMV = .TRUE.
c
      READ(15,*) THAS,THAF,NHAINC,FMV               !READ THAS,...FMV
      READ(15,*) IDUM,IDUM,IDUM,IDUM                !SKIP OVER NHASE,NHASV,...
      READ(15,*) IDUM,IDUM                          !SKIP OVER NHSTAR,NHSINC
c
c...THIS SECTION TO LUMP THE GWCE MATRIX
cvjp 11/30/99 made lumping a compile time option

#ifdef LUMP
       CLUMP = .TRUE.
       ILUMP=1
#else
       CLUMP = .FALSE.
       ILUMP=0
#endif

      READ(15,*) ITITER,IDUM,RDUM,IDUM2             !READ SOLVER TYPE
      CSOLIT = .TRUE.

c
c--Read in 3D info
c
      IF(C3DVS) THEN  !3DVS

         READ(15,*) IDUM                               !Skip IDIAG
         READ(15,*) IDUM                               !Skip IDEN
         READ(15,*) IDUM,RDUM                          !Skip ISLIP,KP
         READ(15,*) RDUM,RDUM                          !Skip Z0S,Z0B
         READ(15,*) RDUM,RDUM,RDUM                     !Skip ALP1,ALP2,ALP3
         READ(15,*) IDUM,IDUM                          !Skip ICG,NFEN
         READ(15,*) IEVC,RDUM,RDUM                     !Process IEVC
         IF(IEVC.EQ.50) READ(15,*) RDUM,RDUM           !Skip THETA1,THETA2
         READ(15,*) I3DSD,RDUM,RDUM,IDUM,NHN3DSD       !Process I3DSD,NHN3DSD
         IF(I3DSD.GT.0) READ(15,*) (IDUM,N=1,NHN3DSD)  !Skip density stations
         READ(15,*) I3DSV,RDUM,RDUM,IDUM,NHN3DSV       !Process I3DSV,NHN3DSV
         IF(I3DSV.GT.0) READ(15,*) (IDUM,N=1,NHN3DSV)  !Skip velocity stations
         READ(15,*) I3DST,RDUM,RDUM,IDUM,NHN3DST       !Process I3DST,NHN3DST
         IF(I3DST.GT.0) READ(15,*) (IDUM,N=1,NHN3DST)  !Skip turbulence stations
         READ(15,*) IDUM,RDUM,RDUM,IDUM                !Skip 3D global density output
         READ(15,*) IDUM,RDUM,RDUM,IDUM                !Skip 3D global velocity output
         READ(15,*) IDUM,RDUM,RDUM,IDUM                !Skip 3D global turbulence output

c     ELSEIF(C3DDSS) THEN  !3DDSS
c
      ENDIF
c
      REWIND(15)                                    !FINISHED WITH UNIT 15 FILE


c...
      WRITE(*,3000) MNPROC,MNE,MNP,MNEI,MNOPE,MNETA,
     &  MNBOU,MNVEL,MNTIF,MNBFR,MNSTAE,MNSTAV,MNSTAC,MNSTAM,MNWP,
     &  MNWLAT,MNWLON,MNHARF,MNFFR
c
      IF(NWS.EQ.0) WRITE(*,3011)
      IF(NWS.EQ.1) WRITE(*,3012)
      IF(ABS(NWS).EQ.2) WRITE(*,3013)
      IF(NWS.EQ.3) WRITE(*,3014)
      IF(ABS(NWS).EQ.4) WRITE(*,3015)
      IF(ABS(NWS).EQ.5) WRITE(*,3016)
      IF(ABS(NWS).EQ.6) WRITE(*,3017)
      IF(NRS.EQ.1) WRITE(*,3018)
      IF(NWS.EQ.10) WRITE(*,3019)
      IF(NWS.EQ.11) WRITE(*,3020)
      IF((NHARF.EQ.0).OR.(FMV.EQ.0.)) WRITE(*,3021)
      IF((NHARF.GE.1).AND.(FMV.NE.0.)) WRITE(*,3022)
      IF(ILUMP.EQ.0) WRITE(*,3031)
      IF(ILUMP.EQ.1) WRITE(*,3032)
      IF(IM.EQ.0) WRITE(*,3101)
      IF(IM.EQ.10) WRITE(*,3109)
      IF(IM.EQ.1) WRITE(*,3102)
      IF(IM.EQ.2) WRITE(*,3103)
      IF(ITITER.EQ.0) WRITE(*,3104)
      IF(ITITER.GT.0) WRITE(*,3105)
      IF(ITITER.LT.0) WRITE(*,3106)
      WRITE(*,3108)
c
3000  FORMAT(' *****************************************************',
     &       ' *   Based on input and information extracted from   *',
     &       ' *   the ADCIRC UNIT 14 and 15 (grid and horiz run   *',
     &       ' *   info) files the following paramter values will  *',
     &       ' *   be set:                                         *',
     &       ' *                                                   *',
     &       ' *       MNPROC = ',I5,'                             *',
     &       ' *       MNE = ',I8,1X,'     MNP = ',I8,1X,'         *',
     &       ' *       MNEI = ',I7,'                               *',
     &       ' *       MNOPE = ',I6,3X,'   MNETA = ',I6,3X,'       *',
     &       ' *       MNBOU = ',I6,3X,'   MNVEL = ',I6,3X,'       *',
     &       ' *       MNTIF = ',I6,3X,'   MNBFR = ',I6,3X,'       *',
     &       ' *       MNSTAE = ',I5,4X,'  MNSTAV = ',I5,4X,'      *',
     &       ' *       MNSTAC = ',I5,4X,'  MNSTAM = ',I5,4X,'      *',
     &       ' *       MNWP = ',I7,'                               *',
     &       ' *       MNWLAT = ',I5,4X,'  MNWLON = ',I5,4X,'      *',
     &       ' *       MNHARF = ',I5,4X,'  MNFFR = ',I6,3X,'       *',
     &       ' *                                                   *')
3011  FORMAT(' *   Also, NO wind forcing will be used,		  *')
3012  FORMAT(' *   Also, NWS=1 meteorological forcing is used,	  *')
3013  FORMAT(' *   Also, NWS=+-2 meteorological forcing is used,   *')
3014  FORMAT(' *   Also, NWS=3 meteorological forcing is used,	  *')
3015  FORMAT(' *   Also, NWS=+-4 meteorological forcing is used,   *')
3016  FORMAT(' *   Also, NWS=+-5 meteorological forcing is used,   *')
3017  FORMAT(' *   Also, NWS=+-6 meteorological forcing is used,   *') 
3018  FORMAT(' *   Also, ABS(NWS)>=100 wave stress forcing is used,*')
3019  FORMAT(' *   Also, AVN wind & pressure forcing will be used, *')
3020  FORMAT(' *   Also, ETA wind & pressure forcing will be used, *')
3021  FORMAT(' *   means and variance calculation will NOT be made,*')
3022  FORMAT(' *   means and variance calculation will be made,    *')
3031  FORMAT(' *   the GWCE matrix will be left in consistent form *')
3032  FORMAT(' *   the GWCE matrix will be LUMPED		  *')
3101  FORMAT(' *   the model will be set up for a 2DDI run,	  *')
3109  FORMAT(' *   the model will be set up for a 2DDI run + transp*')
3102  FORMAT(' *   the model will be set up for a 3D-VS run,	  *')
3103  FORMAT(' *   the model will be set up for a 3D-DSS run,	  *')
3104  FORMAT(' *   and the direct band solver will be used.	  *')
3105  FORMAT(' *   and an iterative solver will be used  	  *')
3106  FORMAT(' *   and no external solver will be used		  *')
3108  FORMAT(' *****************************************************',/)
c
60    FORMAT(A60)
80    FORMAT(A95)
180   FORMAT(95A1)
1010  FORMAT(' File ',A60,/,' WAS NOT FOUND!  Try again',/)
1011  FORMAT(' File ',A60,/,' WAS FOUND!  Opening & Processing file',/)
c
c
      RETURN
      END SUBROUTINE SIZEUP

      END MODULE PRESIZES
