C----------------------------------------------------------------------------
C
C                           MODULE READ_GLOBAL
C
C----------------------------------------------------------------------------
C
C                  For use with ADCPREP Version 1.6 (  5/21/03 )
C
C                     current for ADCIRC v43.03   5/20/2003
C----------------------------------------------------------------------------


C
C  version 1.2 vjp 12/7/99
c  version 1.3 ral 10/10/01 revisions
C  version 1.6 meb 3/03 & ral 5/21/03
C

      SUBROUTINE READ14()
      USE PRE_GLOBAL 
C
C----------------------------------------------------------------------
C     Reads the global ADCIRC grid data file for data decomposition 
C     program ADCPP.  This version compatible with ADCIRC_v34.03
C     vjp  2/28/98
C---------------------------------------------------------------------
C
      INTEGER I,J,JW,K,ITEMP,ITYPE
      INTEGER DISC,BBN,IBP,I1
      INTEGER MAXNEIGH
C
C--The Grid file was opened in SIZEUP performed a rewind, and is ready here
C
C--Read Grid Title
C
      READ(14,80) AGRID
C
C--Read Total Number of Elements and Nodes
C
      READ(14,*) NELG,NNODG
c     READ(14,80) NSIZES
c     READ(NSIZES,*) NELG,NNODG
c     CALL GETMSG(NSIZES,SIZEMSG)
C
C--Read Nodal Coordinates and Bathymetry 
C  If ICS=2 Will Convert later in read15 
C
      DO I = 1,NNODG
         READ(14,*) J,X(J),Y(J),DP(J)
         IF (J.NE.I) THEN
            print *, I,J
            STOP 'Node Numbering not in Sequential Order'
         ENDIF
      ENDDO
C      
C--Read Element Connectivity Table
C
       DO I = 1,NELG
          READ(14,*) J,ITEMP,NNEG(1,J),NNEG(2,J),NNEG(3,J)
          IF (J.NE.I) THEN
            print *, I,J
            STOP 'Element Numbering not Sequential'
          ENDIF
       ENDDO
C...
C...Read Total Number of Open Boundary Segments
C...
      READ(14,80) NOPEMSG
      READ(NOPEMSG,*) NOPE
C...
C...Read Total Number of Open Boundary Forcing Nodes
C...
      READ(14,80) NETAMSG
      READ(NETAMSG,*) NETA
C...
C...Read Number of Nodes on Open Boundary Segment 
C...and Segment Nodes Numbers
C...
      J=0
      DO K=1,NOPE
        READ(14,80) NVDLLMSG(K)
        READ(NVDLLMSG(K),*) NVDLL(K)
        DO I=1,NVDLL(K)
          READ(14,*) NBDV(K,I)
        ENDDO
        J=J+NVDLL(K)
      ENDDO
C     
      IF (NETA.NE.J) THEN
        print *, "Total Number of Boundary Nodes = ",J
        print *, "This exceeds NETA = ",NETA
        IF (NFOVER.EQ.1) THEN
           NETA = J
           print *, "ADCPP corrected this error"
        ELSE
           stop
        ENDIF
      ENDIF
C
C--Read Total Number of Land Boundary Segments
C     
      READ(14,80) NBOUMSG
      READ(NBOUMSG,*) NBOU
C
C--Read Total of Land Boundary Nodes
C
      READ(14,80) NVELMSG
      READ(NVELMSG,*) NVEL
C
C--Read Number of Nodes in the Land Boundary Segment and Boundary Type
C  and construct LBCODE array for read15 routine
C
      J=0
      NWEIR = 0
      DO K = 1,NBOU
C
         READ(14,80) NVELLMSG(K)
         READ(NVELLMSG(K),*) NVELL(K),IBTYPE(K)
         ITYPE = IBTYPE(K)
C
         DO I=1, NVELL(K)
            J = J+1
            LBCODE(J) = ITYPE
         ENDDO
C
         IF   ((ITYPE.NE.0).AND.(ITYPE.NE.10).AND.(ITYPE.NE.20)
     &    .AND.(ITYPE.NE.1).AND.(ITYPE.NE.11).AND.(ITYPE.NE.21)      
     &    .AND.(ITYPE.NE.2).AND.(ITYPE.NE.12).AND.(ITYPE.NE.22)      
     &    .AND.(ITYPE.NE.3).AND.(ITYPE.NE.13).AND.(ITYPE.NE.23)      
     &    .AND.(ITYPE.NE.4).AND.                  (ITYPE.NE.24)
     &    .AND.(ITYPE.NE.5).AND.                  (ITYPE.NE.25)
     &    .AND.                 (ITYPE.NE.30).AND.(ITYPE.NE.32)
     &    .AND.                 (ITYPE.NE.40).AND.(ITYPE.NE.41)) THEN
          print *, "IBTYPE not set correctly for segment ",K
          stop
         ENDIF
C
         IF ((ITYPE.NE.3).AND.(ITYPE.NE.13).AND.(ITYPE.NE.23).AND.
     &     (ITYPE.NE.4).AND.(ITYPE.NE.24)) THEN
           DO I=1,NVELL(K)
              READ(14,*) NBVV(K,I)
              IBCONNR(K,I) = 0
           ENDDO
         ENDIF
C
         IF ((ITYPE.EQ.3).OR.(ITYPE.EQ.13).OR.(ITYPE.EQ.23)) THEN
           DO I=1,NVELL(K)
              READ(14,*) NBVV(K,I),BAR1(K,I),BAR2(K,I)
              IBCONNR(K,I) = 0
           ENDDO
         ENDIF
C
         IF ((ITYPE.EQ.4).OR.(ITYPE.EQ.24)) THEN
           DO I=1,NVELL(K)
              READ(14,*) NBVV(K,I),IBCONNR(K,I),
     &                   BAR1(K,I),BAR2(K,I),BAR3(K,I)
C
C--Construct List of WEIR nodes and their duals
C
              NWEIR = NWEIR+1
              WEIR(NWEIR) = NBVV(K,I)
              WEIRD(NWEIR) = IBCONNR(K,I)
           ENDDO
         ENDIF
C
      ENDDO
C
C--Close Global Grid file
C
      CLOSE(14)
C
 80   FORMAT(A80)
C
      RETURN
      END


      SUBROUTINE READ15() 
      USE PRE_GLOBAL 
C
C----------------------------------------------------------------------
C     Reads the global ADCIRC Input Data File for data decomposition 
C     program ADCPP.  This version compatible with ADCIRC_v34.03
C     vjp  3/28/98
C---------------------------------------------------------------------
C
      INTEGER N1, N2, N3, KMIN, JG, INDEX
      INTEGER I,J,K,L
      INTEGER IG1,IG2,IG3,IL1,IL2,IL3
      REAL*8 X1, X2, X3, X4, Y1, Y2, Y3, Y4, A1, A2, A3
      REAL*8 AE, AEMIN, AREASK, AA
      REAL*8 SL0,SL1,SF0,SF1
      INTEGER NBV(MNVEL)
C
C--The Run Info file was opened in SIZEUP, performed a rewind, and is ready here
C
C--Run Description and Run Identification
C
      READ(15,80) RUNDES
C
      READ(15,80) RUNID
C
      READ(15,80) OVERMSG
      READ(OVERMSG,*) NFOVER
      IF (NFOVER.EQ.1) THEN
c       print *, "Non-fatal errors will be corrected"
      ELSE
c      print *, "Non-fatal errors will stop execution"
      ENDIF
C
      READ(15,80) ABOUTMSG
      READ(ABOUTMSG,*) NABOUT
C
      READ(15,80) SCREENMSG
      READ(SCREENMSG,*) NSCREEN
C
      READ(15,80) HOTMSG
      READ(HOTMSG,*) IHOT
      IF((IHOT.NE.0).AND.(IHOT.NE.67).AND.(IHOT.NE.68)) THEN
        print *, "IHOT set incorrectly"
        stop
      ENDIF
C
      READ(15,80) ICSMSG
      READ(ICSMSG,*) ICS
      IF ((ICS.NE.1).AND.(ICS.NE.2)) THEN
        print *, "ICS set incorrectly"
        STOP
        ENDIF
C
      READ(15,80) IMMSG
      READ(IMMSG,*) IM
      IF(IM.EQ.2) THEN
        PRINT *, "DSS Model type not presently supported"
        STOP
      ENDIF
C
      READ(15,80) IBFMSG
      READ(IBFMSG,*) NOLIBF
      IF((NOLIBF.LT.0).OR.(NOLIBF.GT.2)) THEN
         print *, "Value for NOLIBF not allowed"
         stop
      ENDIF
C
      READ(15,80) IFAMSG
      READ(IFAMSG,*) NOLIFA
      IF ((NOLIFA.LT.0).OR.(NOLIFA.GT.3)) THEN
         print *, "Value for NOLIFA not allowed"
         stop
      ENDIF
C
      READ(15,80) ICAMSG
      READ(ICAMSG,*) NOLICA
      IF ((NOLICA.LT.0).OR.(NOLICA.GT.1)) THEN
         print *, "Value for NOLICA not allowed"
         stop
      ENDIF
C
      READ(15,80) ICATMSG
      READ(ICATMSG,*) NOLICAT
      IF ((NOLICAT.LT.0).OR.(NOLICAT.GT.1)) THEN
         print *, "Value for NOLICAT not allowed"
         stop
      ENDIF
      IF ((NOLIFA.GE.1).AND.(NOLICAT.EQ.0)) THEN
         print *, "NOLIFA and NOLICAT are inconsistent"
         print *, "May lead to mass balance problems"
         IF(NFOVER.EQ.1) THEN
           print *, "Since NFOVER=1, Program will continue"
         ELSE
           stop
         ENDIF
      ENDIF
C
      READ(15,80) NWPMSG
      READ(NWPMSG,*) NWP
      
c......BDE
c Modified for inclusiong of NWP = (-1)1000
c......BDE      
      IF ((NWP.LT.0.OR.NWP.GT.2).AND.
     &  ABS(NWP).NE.1000) THEN
         print *, "Value for NWP not supported in parellel code"
         stop
      ENDIF
c......BDE
c Modified for inclusiong of NWP = (-1)1000
c......BDE      

c......BDE
c Modified for inclusiong of NWP = (-1)1000
c......BDE      
      IF (NWP.EQ.1.AND.NOLIBF.EQ.2) THEN
         print *, "Value for NWP and NOLIBF are incompatable"
         stop
      ENDIF
c......BDE
c Modified for inclusiong of NWP = (-1)1000
c......BDE      
      
C
      READ(15,80) NCORMSG
      READ(NCORMSG,*) NCOR
      IF ((NCOR.NE.0).AND.(NCOR.NE.1)) THEN
         print *, "Value for NCOR not allowed"
         IF (NFOVER.EQ.1) THEN
           NCOR = 0
           print *, "NCOR has been reset to 0"
         ELSE
           stop
         ENDIF
      ENDIF
C
      IF ((ICS.EQ.1).AND.(NCOR.EQ.1)) THEN
        print *, "ICS=1 and NCOR=1 may lead to geometric distortions"
         IF(NFOVER.EQ.1) THEN
           print *, "Program will continue with these input values"
           print *, "for large domains it is recommended to use ICS=2"
         ELSE
           stop
         ENDIF
      ENDIF
C
      READ(15,80) NTIPMSG
      READ(NTIPMSG,*) NTIP
      IF ((NTIP.LT.0).OR.(NTIP.GT.2)) THEN
         print *, "Value for NTIP not allowed"
         IF(NFOVER.EQ.1) THEN
           NTIP = 0
           print *, "NTIP has been reset to 0"
         ELSE
           stop
         ENDIF
      ENDIF
C
      IF ((ICS.EQ.1).AND.(NTIP.GE.1)) THEN
        print *, "ICS=1 & NTIP >= 1 may lead to geometric distortions"
        print *, "for large domains it is recommended to use ICS=2"
        IF (NFOVER.EQ.1) THEN
          print *, "Program will continue with these input values"
        ELSE
          stop
        ENDIF
      ENDIF
C
      NRS=0
      READ(15,80) NWSMSG
      READ(NWSMSG,*) NWS
      
c......BDE
c  Adjusts for NWS=1000 now
c......BDE
      !Retain original NWS setting for MCEL
      NWS_MCEL = NWS
      IF(ABS(NWS).GE.1000) THEN
         NRS=1
	 !Adjust NWS as normal
         NWS=(ABS(NWS)-1000)*(NWS/ABS(NWS))
      ENDIF
      
      
      IF (ABS(NWS).GE.100) THEN
        NRS=1
        NWS=(ABS(NWS)-100)*(NWS/ABS(NWS))
        ENDIF

      IF((NWS.NE.0).AND.    (NWS.NE.1 ) .AND.(ABS(NWS).NE.2).AND.                                               
     &   (NWS.NE.3).AND.(ABS(NWS).NE.4) .AND.(ABS(NWS).NE.5).AND.
     &                  (ABS(NWS).NE.6)                     )  THEN
        print *, "Value for NWS not supported by parallel code"
        stop
        ENDIF
C
      READ(15,80) RAMPMSG
      READ(RAMPMSG,*) NRAMP
      IF ((NRAMP.NE.0).AND.(NRAMP.NE.1)) THEN
         print *, "Value for NRAMP not allowed"
         IF (NFOVER.EQ.1) THEN
           print *, "Program will override and use NRAMP = 0"
           NRAMP = 0
         ELSE
           stop
         ENDIF
      ENDIF
C
      READ(15,80) GMSG
      READ(GMSG,*) G
      IF ((ICS.EQ.1).AND.(G.NE.9.81d0)) THEN
        IF ((NCOR.EQ.1).OR.(NTIP.EQ.1)) THEN
          print *, "G not consistent with ICS=1"
          print *, "in conjunction with NTIP=1 and/or NCOR=1"
          IF(NFOVER.EQ.1) THEN
            print *, "Program will override and set G=9.81"
            print *, "check to see that all input has SI units"
            G = 9.81d0
          ELSE
            stop
          ENDIF
        ENDIF
      ENDIF
C
      IF ((ICS.EQ.2).AND.(G.NE.9.81d0)) THEN
          print *, "G not consistent with ICS=2"
          IF(NFOVER.EQ.1) THEN
            print *, "Program will override and set G = 9.81 m/sec*sec"
            print *, "check to see that all input has SI units"
            print *, "execution will continue"
            G = 9.81d0
          ELSE
            stop
          ENDIF
      ENDIF
C
      READ(15,80) TAU0MSG
      READ(TAU0MSG,*) TAU0
C
      READ(15,80) DTMSG
      READ(DTMSG,*) DT
C
      READ(15,80) STATMSG
      READ(STATMSG,*) STATIM
C
      READ(15,80) REFTMSG
      READ(REFTMSG,*) REFTIM
C
C--If wind stress and surface pressures are applied process this.
C
      IF((NWS.EQ.0).AND.(NRS.EQ.1)) READ(15,*) RSTIMMSG
      IF((NWS.EQ.1).AND.(NRS.EQ.1)) READ(15,*) RSTIMMSG
C
      IF(NWS.EQ.3) THEN
        READ(15,80) WSMSG1
        READ(15,80) WSMSG2
        IF(NRS.EQ.0) THEN
          READ(WSMSG2,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     &                   WLONINC,WTIMINC
          ELSE
          READ(WSMSG2,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     &                   WLONINC,WTIMINC,RSTIMINC
          ENDIF
        ENDIF
C
      IF((ABS(NWS).EQ.2).OR.(ABS(NWS).EQ.4).OR.(ABS(NWS).EQ.5)) THEN
        READ(15,80) WSMSG1
        IF(NRS.EQ.0) READ(WSMSG1,*) WTIMINC
        IF(NRS.EQ.1) READ(WSMSG1,*) WTIMINC,RSTIMINC
        ENDIF
C
      IF(ABS(NWS).EQ.6) THEN
        READ(15,80) WSMSG1
        IF(NRS.EQ.0) THEN
          READ(WSMSG1,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     &                   WLONINC,WTIMINC
          ELSE
          READ(WSMSG1,*) NWLAT,NWLON,WLATMAX,WLONMIN,WLATINC,
     &                   WLONINC,WTIMINC,RSTIMINC
          ENDIF
        ENDIF
C
      READ(15,80) RNDAYMSG
      READ(RNDAYMSG,*) RNDAY
C
      READ(15,80) DRAMPMSG
      READ(DRAMPMSG,*) DRAMP
      print *, DRAMPMSG
C
      READ(15,80) COEFMSG
      print *, COEFMSG
      READ(COEFMSG,*) A00,B00,C00
C
      READ(15,80) H0MSG
      IF (NOLIFA.NE.2) THEN
        READ(H0MSG,*) H0
      ELSE
        READ(H0MSG,*) H0,NODEDRYMIN,NODEWETRMP,VELMIN
      ENDIF
C
      READ(15,80) SLMSG
      READ(SLMSG,*) SLAM0,SFEA0
C
      SL0=DEG2RAD*SLAM0
      SF0=DEG2RAD*SFEA0

      DO I = 1,NNODG
         SLAM(I) = X(I)
         SFEA(I) = Y(I)
      ENDDO
C
C--If ICS = 2 then apply CPP projection
C
      IF (ICS.EQ.2) THEN
         DO I = 1,NNODG
            SL1 = DEG2RAD*SLAM(I)
            SF1 = DEG2RAD*SFEA(I)
            SLAM(I) = R*(SL1-SL0)*COS(SF0)
            SFEA(I) = R*SF1
         ENDDO
       ENDIF
C
      READ(15,80) TAUMSG
      IF (NOLIBF.EQ.0) THEN
        READ(TAUMSG,*) TAU
      ELSEIF (NOLIBF.EQ.1) THEN
        READ(TAUMSG,*) CF
      ELSEIF (NOLIBF.EQ.2) THEN
        READ(TAUMSG,*) CF,HBREAK,FTHETA,FGAMMA
      ENDIF
C
      READ(15,80) ESLMSG
      IF (IM.EQ.10) THEN
        READ(ESLMSG,*) ESLM,ESLC
      ELSE 
        READ(ESLMSG,*) ESLM
      ENDIF
C
      READ(15,80) CORIMSG
      READ(CORIMSG,*) CORI
C
      READ(15,80) NTIFMSG
      READ(NTIFMSG,*) NTIF
      IF (NTIF.GT.MNTIF) THEN
         print *, "NTIF = ",NTIF, " exceeds parameter MNTIF = ",MNTIF
         stop 
      ENDIF
C
      DO I=1,NTIF
        READ(15,80)  TIPOTAG(I)
        READ(15,80)  TPKMSG(I)
        READ(TPKMSG(I),*)  TPK(I),AMIGT(I),ETRF(I),FFT(I),FACET(I)
      ENDDO
C
      IF (((NTIP.EQ.0).AND.(NTIF.NE.0)).OR.((NTIP.NE.0).AND.
     &    (NTIF.EQ.0))) THEN
        print *, "NTIF and NTIP are not consistent"
        IF(NFOVER.EQ.1) THEN
          print *, "Program will reset NTIP = 0 and continue"
          NTIP = 0
        ELSE
          stop
        ENDIF
      ENDIF
C
      READ(15,80) NBFRMSG
      READ(NBFRMSG,*) NBFR
      IF (NBFR.GT.MNBFR) THEN
        print *, "NBFR = ",NBFR, " exceeds parameter MNBFR = ",MNBFR
        stop 
      ENDIF
C

c......BDE
c Accounting for NBFR modification

      IF(NBFR.GE.0)THEN
	DO I=1,NBFR
          READ(15,80) BOUNTAG(I)
          READ(15,80) AMIGMSG(I)
          READ(AMIGMSG(I),*) AMIG(I),FF(I),FACE(I)
	ENDDO
C
	DO I=1,NBFR
          READ(15,80) ALPHA1(I)
          DO J=1,NETA
            READ(15,80) EMOMSG(I,J)
            READ(EMOMSG(I,J),*) EMO(I,J),EFA(I,J)
          ENDDO
	ENDDO
      ENDIF	

C
      READ(15,80) ANGMSG
      READ(ANGMSG,*) ANGINN
C
C--Determine whether there are any normal flow boundaries.
C
      NFLUXF = 0
      DO K=1, NBOU
         IF ((IBTYPE(K).EQ.2).OR.(IBTYPE(K).EQ.12)
     &        .OR.(IBTYPE(K).EQ.22)) THEN
           NFLUXF = 1
         ENDIF
      ENDDO
C
C--If so, read the number of frequencies present and other info.
C  Use LBCODE array constructed in read14.
C
      IF (NFLUXF.EQ.1) THEN
C
        READ(15,80) NFFRMSG
        READ(NFFRMSG,*) NFFR
        IF (NFFR.GT.MNFFR) THEN
          print *, "NFFR = ",NFFR, " exceeds parameter MNFFR = ",MNFFR
          stop
        ENDIF         
C
        IF (NFFR.NE.0) THEN
           DO I=1,NFFR
              READ(15,80) FBOUNTAG(I)
              READ(15,80) FREQMSG(I)
              READ(FREQMSG(I),*) FAMIG(I),FFF(I),FFACE(I)
           ENDDO
           DO I=1,NFFR
              READ(15,80) ALPHA2(I)
              DO J=1,NVEL
                IF ((LBCODE(J).EQ.2).OR.(LBCODE(J).EQ.12)
     &             .OR.(LBCODE(J).EQ.22)) THEN
                  READ(15,80) QNMSG(I,J)         
                  READ(QNMSG(I,J),*) QNAM(I,J),QNPH(I,J)
cdbug             print *, "disc lbnode index = ",J
                ENDIF
             ENDDO
          ENDDO        

Cvjp 5/1/99  added to help localize the flow boundary nodes
C  NBV    =  global node number of all boundary nodes
C  NFLBN  =  number of flow boundary nodes
C  FLBN   =  global node number of flow boundary nodes
C  FLBNX  =  index of flow boundary nodes as per NBV
C
          JG = 1
          DO K = 1,NBOU
          DO I=1, NVELL(K)
             INDEX = NBVV(K,I)
              NBV(JG) = INDEX
              JG = JG + 1
          ENDDO
          ENDDO
C
          NFLBN = 0
          DO J=1,NVEL
             IF ((LBCODE(J).EQ.2).OR.(LBCODE(J).EQ.12)
     &          .OR.(LBCODE(J).EQ.22)) THEN
               NFLBN = NFLBN+1
               FLBN(NFLBN) = NBV(J)
               FLBNX(NFLBN) = J
             ENDIF
          ENDDO
        ENDIF
C
      ENDIF
C
C--Read Elevation Recording Stations
C...
      READ(15,80) STAEMSG
      READ(STAEMSG,*) NOUTE,TOUTSE,TOUTFE,NSPOOLE
      IF (ABS(NOUTE).GT.2) THEN
        print *, "The value of NTOUTE is not allowed"
        stop
      ENDIF
C
      READ(15,80) NSTAEMSG
      READ(NSTAEMSG,*) NSTAE
      IF (NSTAE.GT.MNSTAE) THEN
         print *, "NSTAE = ",NSTAE, " exceeds parameter MNSTAE = ",
     &              MNSTAE
          stop   
      ENDIF
C
      DO I=1,NSTAE
         READ(15,80) STAELOC(I)
         IF(ICS.EQ.1) THEN
            READ(STAELOC(I),*) XEL(I),YEL(I)
         ELSE
            READ(STAELOC(I),*) SLEL(I),SFEL(I)
            SL1=DEG2RAD*SLEL(I)
            SF1=DEG2RAD*SFEL(I)
c           CALL CPP(XEL(I),YEL(I),SL1,SF1,SL0,SF0)
            XEL(I) = R*(SL1-SL0)*COS(SF0)
            YEL(I) = R*SF1
         ENDIF
      ENDDO
C
C--For Each Elevation Station: 
C  Find the Global Index of the element it lies in.
C
      DO I=1,NSTAE
        NNSEG(I)=0
        AEMIN=1.0E+25
        KMIN=0
        DO K=1,NELG
          N1=NNEG(1,K)
          N2=NNEG(2,K)
          N3=NNEG(3,K)
          X1=SLAM(N1)
          X2=SLAM(N2)
          X3=SLAM(N3)
          X4=XEL(I)
          Y1=SFEA(N1)
          Y2=SFEA(N2)
          Y3=SFEA(N3)
          Y4=YEL(I)
          A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
          A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
          A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
          AA=ABS(A1)+ABS(A2)+ABS(A3)
          AREASK=X2*Y3+X1*Y2+X3*Y1-Y1*X2-Y2*X3-Y3*X1
          AE=ABS(AA-AREASK)/AREASK
          IF(AE.LT.AEMIN) THEN
            AEMIN=AE
            KMIN=K
          ENDIF
          IF(AE.LT.1.0E-5) NNSEG(I)=K
        ENDDO
        IF (NNSEG(I).EQ.0) THEN
          print *, "Elevation Station ",I, " does not lie in grid"
          print *, "Please check coordinates for this station"
          IF (NFOVER.EQ.1) THEN
             print *, "Program will estimate nearest element"
             print *, "Proximity Index for this Station is ",AEMIN
cdebug       print *, I, XEL(I),YEL(I)
c            N1=NNEG(1,KMIN)
c            N2=NNEG(2,KMIN)
c            N3=NNEG(3,KMIN)
c            print *, SLAM(N1),SFEA(N1)  
c            print *, SLAM(N2),SFEA(N2)  
c            print *, SLAM(N3),SFEA(N3)  
c            print *, " "
cdebug       stop 
             NNSEG(I) = KMIN
          ELSE
             print *, "Proximity Index for this Station is ",AEMIN
             stop
          ENDIF
        ENDIF
      ENDDO
C
C--Read Velocity Recording Stations
C
      READ(15,80) STAVMSG
      READ(STAVMSG,*) NOUTV,TOUTSV,TOUTFV,NSPOOLV
      IF (ABS(NOUTV).GT.2) THEN
        print *, "Value for NOUTV is not allowable"
        stop
      ENDIF
C
      READ(15,80) NSTAVMSG
      READ(NSTAVMSG,*) NSTAV
      IF (NSTAV.GT.MNSTAV) THEN
        print *, "NSTAV = ",NSTAV, " exceeds parameter MNSTAV = ",
     &             MNSTAV
        stop 
      ENDIF
C
      IF (ICS.EQ.1) THEN
        DO I=1,NSTAV
           READ(15,80) STAVLOC(I)
           READ(STAVLOC(I),*) XEV(I),YEV(I)
        ENDDO
      ELSE
        DO I=1,NSTAV
           READ(15,80) STAVLOC(I)
           READ(STAVLOC(I),*) SLEV(I),SFEV(I)
           SL1=DEG2RAD*SLEV(I)
           SF1=DEG2RAD*SFEV(I)
C          CALL CPP(XEV(I),YEV(I),SL1,SF1,SL0,SF0)
           XEV(I) = R*(SL1-SL0)*COS(SF0)
           YEV(I) = R*SF1
        ENDDO
      ENDIF
C
C--For Each Velocity Station: 
C  Find the Global Index of the element it lies in.
C
      DO I=1,NSTAV
         NNSVG(I)=0
         AEMIN=1.0E+25
         KMIN=0
         DO K=1,NELG
            N1=NNEG(1,K)
            N2=NNEG(2,K)
            N3=NNEG(3,K)
            X1=SLAM(N1)
            X2=SLAM(N2)
            X3=SLAM(N3)
            X4=XEV(I)
            Y1=SFEA(N1)
            Y2=SFEA(N2)
            Y3=SFEA(N3)
            Y4=YEV(I)
            A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
            A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
            A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
            AA=ABS(A1)+ABS(A2)+ABS(A3)
            AREASK=X2*Y3+X1*Y2+X3*Y1-Y1*X2-Y2*X3-Y3*X1
            AE=ABS(AA-AREASK)/AREASK
            IF (AE.LT.AEMIN) THEN
              AEMIN=AE
              KMIN=K
            ENDIF
            IF (AE.LT.1.0E-5) NNSVG(I)=K
         ENDDO
         IF (NNSVG(I).EQ.0) THEN
           print *, "Velocity Station ",I, " does not lie in grid"
           print *, "Please check coordinates for this station"
           IF (NFOVER.EQ.1) THEN
             print *, "Program will estimate nearest element"
             print *, "Proximity Index for this Station is ",AEMIN
             print *, " "
             NNSVG(I) = KMIN
           ELSE
             print *, "Proximity Index for this Station is ",AEMIN
             stop
           ENDIF
         ENDIF
       ENDDO
C
C--If IM=10, then read Concentration Station Info 
C
      IF (IM.EQ.10) THEN
C
        READ(15,80) STACMSG
        READ(STACMSG,*) NOUTC,TOUTSC,TOUTFC,NSPOOLC
        IF (ABS(NOUTC).GT.2) THEN
          print *, "Value of NOUTC is not allowable"
          stop
        ENDIF
C
        READ(15,80) NSTACMSG
        READ(NSTACMSG,*) NSTAC
        IF (NSTAC.GT.MNSTAC) THEN
          print *, "NSTAC = ",NSTAC, " exceeds parameter MNSTAC = ",
     &              MNSTAC
          stop 
        ENDIF
C
        DO I=1,NSTAC
           IF (ICS.EQ.1) THEN
             READ(15,80) STACLOC(I)
             READ(STACLOC(I),*) XEC(I),YEC(I)
           ELSE
             READ(15,80) STACLOC(I)
             READ(STACLOC(I),*) SLEC(I),SFEC(I)
             SL1=DEG2RAD*SLEC(I)
             SF1=DEG2RAD*SFEC(I)
c            CALL CPP(XEC(I),YEC(I),SL1,SF1,SL0,SF0)
             XEC(I) = R*(SL1-SL0)*COS(SF0)
             YEC(I) = R*SF1
           ENDIF
        ENDDO
C
C--For Each Concentration Recording Station: 
C  Find the Global Index of the element it lies in.
C
       DO I=1,NSTAC
          NNSCG(I)=0
          AEMIN=1.0E+25
          KMIN=0
          DO K=1,NELG
            N1=NNEG(1,K)
            N2=NNEG(2,K)
            N3=NNEG(3,K)
            X1=SLAM(N1)
            X2=SLAM(N2)
            X3=SLAM(N3)
            X4=XEC(I)
            Y1=SFEA(N1)
            Y2=SFEA(N2)
            Y3=SFEA(N3)
            Y4=YEC(I)
            A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
            A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
            A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
            AA=ABS(A1)+ABS(A2)+ABS(A3)
            AREASK=X2*Y3+X1*Y2+X3*Y1-Y1*X2-Y2*X3-Y3*X1
            AE=ABS(AA-AREASK)/AREASK
            IF (AE.LT.AEMIN) THEN
              AEMIN=AE
              KMIN=K
            ENDIF
            IF (AE.LT.1.0E-5) NNSCG(I) = K
         ENDDO
         IF (NNSCG(I).EQ.0) THEN
           print *, "Concentration Station ",I, " does not lie in grid"
           print *, "Please check coordinates for this station"
           IF (NFOVER.EQ.1) THEN
             print *, "Program will estimate nearest element"
             print *, "Proximity Index for this Station is ",AEMIN
             print *, " "
             NNSCG(I) = KMIN
           ELSE
             print *, "Proximity Index for this Station is ",AEMIN
             stop
           ENDIF
         ENDIF
       ENDDO
C
      ENDIF
C
C--If NWS <> 0 , then read Meteorlogical Station Info 
C
      NOUTM = 0
      IF (NWS.NE.0) THEN
C
        READ(15,80) STAMMSG
        READ(STAMMSG,*) NOUTM,TOUTSM,TOUTFM,NSPOOLM
        IF (ABS(NOUTM).GT.2) THEN
          print *, "Value of NOUTM is not allowable"
          stop
        ENDIF
C
        READ(15,80) NSTAMMSG
	print*, NSTAMMSG
	stop
        READ(NSTAMMSG,*) NSTAM
        IF (NSTAM.GT.MNSTAM) THEN
          print *, "NSTAM = ",NSTAM, " exceeds parameter MNSTAM = ",
     &              MNSTAM
          stop 
        ENDIF
C
        DO I=1,NSTAM
           IF (ICS.EQ.1) THEN
             READ(15,80) STAMLOC(I)
             READ(STAMLOC(I),*) XEM(I),YEM(I)
           ELSE
             READ(15,80) STAMLOC(I)
             READ(STAMLOC(I),*) SLEM(I),SFEM(I)
             SL1=DEG2RAD*SLEM(I)
             SF1=DEG2RAD*SFEM(I)
c            CALL CPP(XEM(I),YEM(I),SL1,SF1,SL0,SF0)
             XEM(I) = R*(SL1-SL0)*COS(SF0)
             YEM(I) = R*SF1
           ENDIF
        ENDDO
C
C--For Each Meterological Recording Station: 
C  Find the Global Index of the element it lies in.
C
       DO I=1,NSTAM
          NNSMG(I)=0
          AEMIN=1.0E+25
          KMIN=0
          DO K=1,NELG
            N1=NNEG(1,K)
            N2=NNEG(2,K)
            N3=NNEG(3,K)
            X1=SLAM(N1)
            X2=SLAM(N2)
            X3=SLAM(N3)
            X4=XEM(I)
            Y1=SFEA(N1)
            Y2=SFEA(N2)
            Y3=SFEA(N3)
            Y4=YEM(I)
            A1=(X4-X3)*(Y2-Y3)+(X2-X3)*(Y3-Y4)
            A2=(X4-X1)*(Y3-Y1)-(Y4-Y1)*(X3-X1)
            A3=(Y4-Y1)*(X2-X1)-(X4-X1)*(Y2-Y1)
            AA=ABS(A1)+ABS(A2)+ABS(A3)
            AREASK=X2*Y3+X1*Y2+X3*Y1-Y1*X2-Y2*X3-Y3*X1
            AE=ABS(AA-AREASK)/AREASK
            IF (AE.LT.AEMIN) THEN
              AEMIN=AE
              KMIN=K
            ENDIF
            IF (AE.LT.1.0E-5) NNSMG(I) = K
         ENDDO
         IF (NNSMG(I).EQ.0) THEN
           print *, "Meterological Station ",I, " does not lie in grid"
           print *, "Please check coordinates for this station"
           IF (NFOVER.EQ.1) THEN
             print *, "Program will estimate nearest element"
             print *, "Proximity Index for this Station is ",AEMIN
             print *, " "
             NNSCG(I) = KMIN
           ELSE
             print *, "Proximity Index for this Station is ",AEMIN
             stop
           ENDIF
         ENDIF
       ENDDO
C
      ENDIF
C
C
C--Read Global Elevation Data Output
C
      READ(15,80) OUTGEMSG
      READ(OUTGEMSG,*) NOUTGE,TOUTSGE,TOUTFGE,NSPOOLGE
      IF (ABS(NOUTGE).GT.2.AND.ABS(NOUTGE).NE.20) THEN
         print *, "NOUTGE does not have an allowable value"
         stop
      ENDIF
C
C--Read Global Velocity Data Output
C
      READ(15,80) OUTGVMSG
      print *, OUTGVMSG
      
      READ(OUTGVMSG,*) NOUTGV,TOUTSGV,TOUTFGV,NSPOOLGV
      IF (ABS(NOUTGV).GT.2.AND.ABS(NOUTGV).NE.20) THEN
        print *, "NOUTGV does not have an allowable value"
        stop
      ENDIF
C
C--If IM=10, read Global Concentration Data Output  
C
      IF (IM.EQ.10) THEN
        READ(15,80) OUTGCMSG
        READ(OUTGCMSG,*) NOUTGC,TOUTSGC,TOUTFGC,NSPOOLGC
        IF (ABS(NOUTGC).GT.2) THEN
          print *, "NOUTGC does not have an allowable value"
          stop
        ENDIF
      ENDIF
C
      IF (NWS.NE.0) THEN
        READ(15,80) OUTGWMSG
        READ(OUTGWMSG,*) NOUTGW,TOUTSGW,TOUTFGW,NSPOOLGW
        IF (ABS(NOUTGW).GT.2) THEN
          print *, "NOUTGW does not have an allowable value"
          stop
        ENDIF
      ENDIF
C
C--Read Harmonic Analysis Data
C
      READ(15,80) HARFRMSG
      READ(HARFRMSG,*) NHARFR
      IF (NHARFR.GT.MNHARF) THEN
        print *, "NHARFR exceeds parameter MNHARF"
        print *, "NHARFR = ",NHARFR, " exceeds parameter MNHARF = ",
     &            MNHARF
        stop 
      ENDIF
C
      DO I=1,NHARFR
          READ(15,80) HAFNAM(I)
          READ(15,80) HAFREMSG(I)
          READ(HAFREMSG(I),*) HAFREQ(I),HAFF(I),HAFACE(I)
      ENDDO
C
      READ(15,80) HARPARMSG
      READ(HARPARMSG,*) THAS,THAF,NHAINC,FMV
      READ(15,80) OUTHARMSG
      READ(OUTHARMSG,*) NHASE,NHASV,NHAGE,NHAGV
      IF ((NHASE.LT.0).OR.(NHASE.GT.1)) THEN
        print *, "NHASE dos not have an allowable value"
        IF (NFOVER.EQ.1) THEN
          print *, "Program will override an reset NHASE=0 "
          NHASE = 0
        ELSE
          stop
        ENDIF
      ENDIF
C
      IF ((NHASV.LT.0).OR.(NHASV.GT.1)) THEN
         print *, "NHASV dos not have an allowable value"
         IF (NFOVER.EQ.1) THEN
           print *, "Program will override an reset NHASV=0 "
           NHASV = 0
         ELSE
           stop
         ENDIF
      ENDIF
C
      IF ((NHAGE.LT.0).OR.(NHAGE.GT.1)) THEN
        print *, "NHAGE dos not have an allowable value"
        IF (NFOVER.EQ.1) THEN
          print *, "Program will override an reset NHAGE=0 "
          NHAGE = 0
        ELSE
          stop
        ENDIF
      ENDIF
C
      IF ((NHAGV.LT.0).OR.(NHAGV.GT.1)) THEN
        print *, "NHAGV dos not have an allowable value"
        IF (NFOVER.EQ.1) THEN
          print *, "Program will override an reset NHAGV=0 "
          NHAGV = 0
        ELSE
          stop
        ENDIF
      ENDIF
C
C--Read Hot Start Data
C
      READ(15,80) HSTARMSG
      READ(HSTARMSG,*) NHSTAR,NHSINC
      IF ((NHSTAR.LT.0).OR.(NHSTAR.GT.1)) THEN
        print *, "NHSTAR dos not have an allowable value"
        IF (NFOVER.EQ.1) THEN
          print *, "Program will override an reset NHSTAR=0 "
          NHSTAR = 0
        ELSE
          stop
        ENDIF
      ENDIF
C
C--Read Solver Data
C
      READ(15,80) SOLVMSG
      READ(SOLVMSG,*) ITITER,ISLDIA,CONVCR,ITMAX
      IF (ITITER.NE.1) THEN
         print *, "Invalid Solver was selected"
         print *, "JCG is the only solver supported for a parallel run"
         IF (NFOVER.EQ.1) THEN
           print *, "Program will continue and use JCG"
           ITITER = 1
         ELSE
           print *, "ITITER must be set to 1"
           stop
         ENDIF
      ENDIF
C
C--Read in 3D data
C
      IF(C3DVS) THEN
        CALL READ15_3DVS()
c     ELSEIF(C3DDSS) THEN
c       CALL READ15_3DDSS()
      ENDIF
C
C--Close Global Run Info file 
C
      CLOSE(15)
C
      RETURN
C
 80   FORMAT(A80)
      END


      SUBROUTINE READ15_3DVS() 
      USE PRE_GLOBAL 
C
C----------------------------------------------------------------------
C     Reads the 3DVS portion of the global ADCIRC Input Data File for
C     data decomposition program ADCPP.  This version compatible with
C     ADCIRC_v41.11a
C     tjc  6/24/02
C---------------------------------------------------------------------
C
      REAL(8) :: STATIME
      REAL(8), PARAMETER :: day2sec=24.d0*3600.d0

C
 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     &          ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')
C
C... SPECIFY THE DETAIL OF THE DIAGNOSTIC AND WARNING MESSAGES

      READ(15,80) IDIAGMSG
      READ(IDIAGMSG,*) IDIAG
      IF((IDIAG.GT.2).OR.(IDIAG.LT.0)) THEN
         WRITE(*,350)
         WRITE(*,422)
 422     FORMAT(/,2X,'    IDIAG MUST = 0,1 OR 2')
         STOP
         ENDIF

C... SPECIFY WHETHER A BAROTROPIC OR BAROCLINIC RUN

      READ(15,80) IDENMSG
      READ(IDENMSG,*) IDEN
      IF((IDEN.GT.1).OR.(IDEN.LT.0)) THEN
         WRITE(*,350)
         WRITE(*,423)
 423     FORMAT(/,2X,'    IDEN MUST = 0 OR 1')
         STOP
         ENDIF

C... READ IN THE TYPE OF BOTTOM BOUNDARY CONDITION AND THE SLIP COEFFICIENTS

      READ(15,80) SLIPMSG
      READ(SLIPMSG,*) ISLIP,KP
      IF((ISLIP.LT.0).OR.(ISLIP.GT.2)) THEN
         WRITE(6,350)
         WRITE(6,360)
 360     FORMAT(/,2X,'    THE SLIP CODE MUST = 0,1,OR 2.')
         STOP
         ENDIF

C... READ IN THE SURFACE AND BOTTOM ROUGHNESSES

      READ(15,80) Z0MSG
      READ(Z0MSG,*) Z0S, Z0B

C... READ IN THE TIME STEPPING COEFFICIENTS

      READ(15,80) ALPMSG
      READ(ALPMSG,*) ALP1,ALP2,ALP3

C... READ IN IGC & NFEN: F.E. GRID CODE & # NODES IN F.E. GRID

      READ(15,80) FEMSG
      READ(FEMSG,*) IGC,NFEN

C... SPECIFY TYPE OF EDDY VISCOSITY PROFILE

      READ(15,80) EVCMSG
      READ(EVCMSG,*) IEVC,EVMIN,EVCON
      IF((IEVC.NE.0 ).and.(IEVC.NE.1 ).and.
     &   (IEVC.NE.10).and.(IEVC.NE.11).and.
     &   (IEVC.NE.20).and.(IEVC.NE.21).and.
     &   (IEVC.NE.30).and.(IEVC.NE.31).and.(IEVC.NE.32).and.
     &   (IEVC.NE.33).and.
     &   (IEVC.NE.40).and.(IEVC.NE.41).and.(IEVC.NE.42).and.
     &   (IEVC.NE.43).and.
     &   (IEVC.NE.50)) THEN
         WRITE(*,350)
         WRITE(*,411)
 411     FORMAT(/,2X,'    IEVC MUST BE 0,1,10,11,20,21,30,31,32,33,40,',
     &               '41,42,43,50')
         STOP
         ENDIF
      IF(IEVC.EQ.50) THEN
         READ(15,80) THETAMSG
         READ(THETAMSG,*) THETA1,THETA2
         ENDIF

C....  STATION 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,80) DSDMSG
      READ(DSDMSG,*) I3DSD,TO3DSSD,TO3DFSD,NSPO3DSD,NHN3DSD
      IF((I3DSD.LT.0).OR.(I3DSD.GT.2)) THEN
        WRITE(*,350)
        WRITE(*,511)
 511    FORMAT(/,2X,'    I3DSD MUST BE 0,1 OR 2')
        STOP
        ENDIF
      IF(I3DSD.GT.0) THEN
        ALLOCATE(ISDHOUT(NHN3DSD))
        READ(15,*) (ISDHOUT(N),N=1,NHN3DSD)
        ENDIF

C....  STATION 3D VELOCITY OUTPUT

      READ(15,80) DSVMSG
      READ(DSVMSG,*) I3DSV,TO3DSSV,TO3DFSV,NSPO3DSV,NHN3DSV
      IF((I3DSV.LT.0).OR.(I3DSV.GT.2)) THEN
        WRITE(*,350)
        WRITE(*,512)
 512    FORMAT(/,2X,'    I3DSV MUST BE 0,1 OR 2')
        STOP
        ENDIF
      IF(I3DSV.GT.0) THEN
        ALLOCATE(ISVHOUT(NHN3DSV))
        READ(15,*) (ISVHOUT(N),N=1,NHN3DSV)
        ENDIF

C....  STATION 3D TURBULENCE OUTPUT

      READ(15,80) DSTMSG
      READ(DSTMSG,*) I3DST,TO3DSST,TO3DFST,NSPO3DST,NHN3DST
      IF((I3DST.LT.0).OR.(I3DST.GT.2)) THEN
        WRITE(*,350)
        WRITE(*,513)
 513    FORMAT(/,2X,'    I3DST MUST BE 0,1 OR 2')
        STOP
        ENDIF
      IF(I3DST.GT.0) THEN
        ALLOCATE(ISTHOUT(NHN3DST))
        READ(15,*) (ISTHOUT(N),N=1,NHN3DST)
        ENDIF

C....  GLOBAL 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,80) DGDMSG
      READ(DGDMSG,*) I3DGD,TO3DSGD,TO3DFGD,NSPO3DGD
      IF((I3DGD.LT.0).OR.(I3DGD.GT.2)) THEN
        WRITE(*,350)
        WRITE(*,514)
 514    FORMAT(/,2X,'    I3DGD MUST BE 0,1 OR 2')
        STOP
        ENDIF

C....  GLOBAL 3D VELOCITY OUTPUT

      READ(15,80) DGVMSG
      READ(DGVMSG,*) I3DGV,TO3DSGV,TO3DFGV,NSPO3DGV
      IF((I3DGV.LT.0).OR.(I3DGV.GT.2)) THEN
        WRITE(*,350)
        WRITE(*,515)
 515    FORMAT(/,2X,'    I3DGV MUST BE 0,1 OR 2')
        STOP
        ENDIF

C....  GLOBAL 3D TURBULENCE OUTPUT

      READ(15,80) DGTMSG
      READ(DGTMSG,*) I3DGT,TO3DSGT,TO3DFGT,NSPO3DGT
      IF((I3DGT.LT.0).OR.(I3DGT.GT.2)) THEN
        WRITE(*,350)
        WRITE(16,516)
 516    FORMAT(/,2X,'    I3DGT MUST BE 0,1 OR 2')
        STOP
        ENDIF
C
      RETURN
C
 80   FORMAT(A80)
      END

*******************************************************************************
C                                                                             *
C    Transform from lon,lat (lamda,phi) coordinates into CPP coordinates.     *
C    Lon,Lat must be in radians.                                              *
C                                                                             *
C******************************************************************************

      SUBROUTINE CPP(X,Y,RLAMBDA,PHI,RLAMBDA0,PHI0)
      IMPLICIT NONE
      REAL X, Y, PHI, RLAMBDA
      REAL RLAMBDA0, PHI0, R
C
      R=6378206.4
      X=R*(RLAMBDA-RLAMBDA0)*COS(PHI0)
      Y=PHI*R
      RETURN
      END


C******************************************************************************
C                                                                             *
C    Transform from CPP coordinates to lon,lat (lamda,phi) coordinates        *
C    Lon,Lat is in radians.                                                   *
C                                                                             *
C******************************************************************************

      SUBROUTINE INVCP(XXCP,YYCP,RLAMBDA,PHI,RLAMBDA0,PHI0)
      IMPLICIT NONE
      REAL XXCP, YYCP, PHI, RLAMBDA
      REAL RLAMBDA0, PHI0, R
C
      R=6378206.4
      RLAMBDA=RLAMBDA0+XXCP/(R*COS(PHI0))
      PHI=YYCP/R
      RETURN
      END
