C******************************************************************************
C PADCIRC RELEASE VERSION 43.03 05/20/2003                                    *
C  last changes in this file VERSION 43.03                                    *
C                                                                             *
C  mod history                                                                *
C  v43.03     - 05/20/03 - rl - from 43.02 - parallel wind stuff (m.brown)    *
C                                          output buffer flush (m.cobb)       *
C                                          3D fixes (k.dresback)              *
C                                          drop MNPROC in fort.15 (t.campbell)*
C                                          various bug fixes in RBCs          *
c                                          ZSURFBUOY/BCPG calc                *
C  v43.02     - 02/06/03 - rl - from 43.01 - code clean up & documentation    *
C  v43.01     - 01/31/03 - jf - from 43.00 - reconcile with v42.07 2D code    *
C                                            changed var. names: NNEIGH->     *
C                                            NNeigh, NEIGH->NeiTab,           *
C                                            NEIGHELE->NeiTabEle,             *
C  v43.00b    - 12/11/02 - jf - from 43.00a - bug fixes                       *
C  v43.00a    - sum  /02 - tc - from 36.01 (3D) & 41.12? (2D), create F90/    *
C  v42.07     - 08/12/02 - rl - from 42.06 - combined discharge & wave rad bc *
C  v42.06     - 06/24/02 - rl - from 42.05 - redid no normal vel grad bc v1   *
C  v42.05     - 06/18/02 - rl - from 42.04 - combined v1 & v2 no normal vel   *
C                                                                   grad bcs  *
C  v42.04     - 06/08/02 - rl - from 42.02 - fixed bug in no normal vel grad  *
C                                                                   bc v1     *
C  v42.03     - 06/06/02 - rl - from 42.01 - no normal velocity grad bc v2    *
C  v42.02     - 06/05/02 - rl - from 42.01 - no normal velocity grad bc v1    *
C  v42.01     - 04/12/02 - rl - from 41.11 - redid GWCE formulation           *
C  v41.11     - 09/14/01 - rl - from 41.10 - added NWS = -2                   *
C  v41.10     - 07/25/01 - rl - from 41.09 - bug fix in GWCE lateral viscosity*
C  v41.09     - 06/30/01 - jw - from 41.08 - minor mods per vp version 41.05  *
C  v41.08     - 06/22/01 - rl  - reconciled v41.07 and v41.05m009             *
C  v41.05m009 - 06/12/01 - rl&jjw - updated NODECODE after initial drying sect*
C  v41.05m008 - 06/01/01 - jjw - changed code by adding output in wet/dry sect*
C  v41.05m007 - 05/28/01 - jjw - changed HABSMIN=0.8D0*H0                     *
C  v41.05m006 - 05/22/01 - jjw - add writes to track wetting/drying bug       *
C  v41.05m005 - 05/21/01 - jjw - modified wet/dry to allow barrier overtopping*
C                                modified from version 41.05.original         *
C  v41.05m004 - 02/15/01 - jjw - from 41.05.m003 - added logic to reset min   *
C                               depth behind overtopping barriers from wetting*
C  v41.05m003 - 02/14/01 - jjw - from 41.05.original - skipped over version   *
C                                41.05m001/m002. Fixed bug in wet/dry         *
C                                algorithm which prevented overtopping        *
C                                internal barriers from wetting               *
C  v41.03       09/15/00 - rl - added bridge piling friction, fixed several   *
C                               F90 bugs                                      *
C  v41.02       09/07/00 - rl - fixed F90 hot start bug and consolidated with *
C                               version 35.xx                                 *
C  v40_02m004 - 05/02/00 - rl - changed so that contribution to RHS forcing is*
C                               zeroed out for any element that contains a dry*
C                               node. Note: LHS is taken care of automatically*
C  v40.02m003 - 04/28/00 - jjw - Changed wet/dry interface from essential no  *
C                                normal & tangential to natural no normal     *
C  v40.02m002 - 12/22/99 - jjw/vjp - Vic change to avoid compiler problems    *
C  v40.02m001 - 12/21/99 - jjw - add cross barrier pipes cjjwm001             *
C                                                                             *
C******************************************************************************
C 
      SUBROUTINE TIMESTEP(IT)
C     
      USE GLOBAL
      USE HARM
      USE WIND
      USE ITPACKV

#ifdef CMPI
      USE MESSENGER
#endif

C...BDE Added coupling module 7/10/2003
      USE COUPLING

      IMPLICIT NONE 
 
      INTEGER IT

      REAL(SZ) VIDBCPDX, VIDBCPDY                          
      REAL(SZ) VIDBCPDX1N1,VIDBCPDX1N2,VIDBCPDX1N3                      
      REAL(SZ) VIDBCPDY1N1,VIDBCPDY1N2,VIDBCPDY1N3                      
      REAL(SZ) VIDBCPDXPP3,VIDBCPDYPP3
      REAL(SZ) SpaVarTau0

C...  COMPUTE MASTER TIME WHICH IS REFERENCED TO THE BEGINNING TIME OF
C...  THE MODEL RUN
C...  
      TIME=IT*DTDP + STATIM*86400.D0
      
C...  HARMONIC CALCULATIONS ARE MADE FOR TIME WHICH INCLUDES THE REFTIM
C...  TO ALLOW FOR THE POSSIBILITY THAT THE EQUILIBRIUM ARGUEMENTS MAY
C...  BE FOR A TIME OTHER THAN THE MODEL STARTING TIME.
C...  
      TIMEH=IT*DTDP + (STATIM - REFTIM)*86400.D0

C...  SHIFT THE DEPTH AVERAGED VELOCITIES, BOTTOM STRESS, WIND STRESS,
C...  SURFACE PRESSURE AND TIDAL POTENTIALS TO PREVIOUS TIME STEP.  ZERO
C...  OUT THE NEW FORCING TERMS, LOAD VECTORS (QW - GWCE, QU,QV - MOM)
C...  AND RESPONSES
C...  
      DO I=1,NP
         UU1(I)=UU2(I)
         VV1(I)=VV2(I)
         QW(I)=0.D0
         QU(I)=0.D0
         QV(I)=0.D0

C...  Transport
         IF(IM.EQ.10) THEN
            QB(I)=0.D0
            QA(I)=0.D0
         ENDIF

C...  Wind (& wave radiation stress if used)
         IF((NWS.NE.0).OR.(NRS.NE.0)) THEN
            WSX1(I)=WSX2(I)
            WSX2(I)=0.D0
            WSY1(I)=WSY2(I)
            WSY2(I)=0.D0
            PR1(I)=PR2(I)
            PR2(I)=0.D0
         ENDIF

C     TIP..Tidal potential forcing
         if(CTIP) then
            TIP1(I)=TIP2(I)
            TIP2(I)=0.D0
         endif

C     2DDI.For the 2DDI version of the code
C     2DDI.Set up the 2D friction coefficient
         if(C2DDI) then
            UV1=SQRT(UU1(I)*UU1(I)+VV1(I)*VV1(I))
            HH1=DP(I)+IFNLFA*ETA2(I)
            TK(I)=FRIC(I)*(IFLINBF + (UV1/HH1)*(IFNLBF + IFHYBF*
     &           (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
         endif 

      END DO

C...  
C     2DDI.For the 2DDI version of the code
C     2DDI.Include additional friction if bridge pilings are present
C...  
      if(C2DDI) THEN
         IF(NWP.EQ.2) THEN
            DO J=1,NBPNODES
               I=NBNNUM(J) 
               UV1=SQRT(UU1(I)*UU1(I)+VV1(I)*VV1(I))
               HH1=DP(I)+IFNLFA*ETA2(I)
               Fr=UV1*UV1/(G*HH1)
               FRICBP=(HH1/BDELX(J))*BK(J)*(BK(J)+5.d0*Fr*Fr-0.6d0)
     &              *(BALPHA(J)+15.d0*BALPHA(J)**4)
               TK(I)=TK(I)+FRICBP*UV1/HH1
            ENDDO
         ENDIF
      endif

C...  SHIFT THE SPECIFIED NORMAL FLOW BOUNDARY CONDITION TO PREVIOUS
C...  TIME STEPS.  ZERO OUT THE NEW SPECIFIED NORMAL FLOW BOUNDARY
C...  CONDITION
C...  
      DO I=1,NVEL
         QN0(I)=QN1(I)
         QN1(I)=QN2(I)
         QN2(I)=0.D0
         EN0(I)=EN1(I)
         EN1(I)=EN2(I)
         EN2(I)=0.D0 
      END DO

C...  RECOMPUTE THE GWCE SYSTEM MATRIX AT THE FIRST TIME STEP OR IF ANY
C...  WETTING OR DRYING OCCURRED IN THE PREVIOUS TIME STEP.
C...  
      IF(NCCHANGE.EQ.1) THEN
         NCCHANGE=0
         IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,3806)
c     WRITE(16,3806)
 3806    FORMAT(/,1X,'RE-SETTING GWCE SYSTEM MATRIX',/)

C.....Set up the LHS matrix (for the iterative matrix solver)
         DO I=1,NP
            DO J=1,NEIMAX
               COEF(I,J)=0.0d0
            END DO
         END DO

         DO IE=1,NE
            NMI1=NM(IE,1)
            NMI2=NM(IE,2)
            NMI3=NM(IE,3)
            NMJ1=NMI1
            NMJ2=NMI2
            NMJ3=NMI3
            NC1=NODECODE(NMI1)
            NC2=NODECODE(NMI2)
            NC3=NODECODE(NMI3)
            NCELE=NC1*NC2*NC3

            SFACPP=(SFAC(NMI1)+SFAC(NMI2)+SFAC(NMI3))/3.d0
            TAU0AVG=(TAU0VAR(NMI1)+TAU0VAR(NMI2)+TAU0VAR(NMI3))/3.d0
            TT0L=((1.0d0+0.5d0*DT*TAU0AVG)/DT)/DT

            FDX1 = (Y(NMI2)-Y(NMI3))*SFACPP
            FDX2 = (Y(NMI3)-Y(NMI1))*SFACPP
            FDX3 = (Y(NMI1)-Y(NMI2))*SFACPP
            FDY1 = X(NMI3)-X(NMI2)
            FDY2 = X(NMI1)-X(NMI3)
            FDY3 = X(NMI2)-X(NMI1)

            hAvg=(DP(NMI1)+DP(NMI2)+DP(NMI3))/3.d0

            AREAIE=AREAS(IE)/2.0d0
            AO6=AREAIE/6.d0
            AO12=AREAIE/12.d0
            FDDD=(1+ILUMP)*AO6             !2*<phi*phj> diagonal terms
            FDDOD=(1-ILUMP)*AO12           !2*<phi*phj> off diagonal terms

            DO JN=2,NEIMAX
               IF(NeiTab(NMI1,JN).EQ.NMJ2) J12=JN
               IF(NeiTab(NMI1,JN).EQ.NMJ3) J13=JN
               IF(NeiTab(NMI2,JN).EQ.NMJ1) J21=JN
               IF(NeiTab(NMI2,JN).EQ.NMJ3) J23=JN
               IF(NeiTab(NMI3,JN).EQ.NMJ1) J31=JN
               IF(NeiTab(NMI3,JN).EQ.NMJ2) J32=JN
            END DO

            GFac=GA00*hAvg/(4.d0*AREAIE)
            COEF(NMI1,1)  =COEF(NMI1,1)
     &               +2.d0*(TT0L*FDDD +GFac*(FDY1*FDY1+FDX1*FDX1))*NCELE
            COEF(NMI1,J12)=COEF(NMI1,J12)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY1*FDY2+FDX1*FDX2))*NCELE
            COEF(NMI1,J13)=COEF(NMI1,J13)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY1*FDY3+FDX1*FDX3))*NCELE
            COEF(NMI2,J21)=COEF(NMI2,J21)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY2*FDY1+FDX2*FDX1))*NCELE
            COEF(NMI2,1)  =COEF(NMI2,1)
     &               +2.d0*(TT0L*FDDD +GFac*(FDY2*FDY2+FDX2*FDX2))*NCELE
            COEF(NMI2,J23)=COEF(NMI2,J23)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY2*FDY3+FDX2*FDX3))*NCELE
            COEF(NMI3,J31)=COEF(NMI3,J31)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY3*FDY1+FDX3*FDX1))*NCELE
            COEF(NMI3,J32)=COEF(NMI3,J32)
     &               +2.d0*(TT0L*FDDOD+GFac*(FDY3*FDY2+FDX3*FDX2))*NCELE
            COEF(NMI3,1)  =COEF(NMI3,1)
     &               +2.d0*(TT0L*FDDD +GFac*(FDY3*FDY3+FDX3*FDX3))*NCELE

c...  NOTE: the factor of 2 that multiplies each of the lines above was
c...  only only added for backward compatability with the RHS
c...  formluation in earlier versions of the code.  It should be removed
c...  as soon as possible.  RL 4/12/02

         END DO

C...  Modify the matrix "COEF" by imposing the elevation specified
C...  boundary conditions while maintaining the symmetry of the system
         IF ((IT.EQ.1).OR.(IT.EQ.ITHS+1)) THEN
#ifdef CMPI
            EP = PSDOT(NP,COEF(1,1),COEF(1,1))
            EP = SQRT(RNP_GLOBAL*EP)
#else 
            EP=0.0D0
            DO I=1,NP
               EP=EP+COEF(I,1)*COEF(I,1)
            END DO
            EP=SQRT(EP/NP)
#endif
         ENDIF

c...  for each elevation specified boundary node, zero all off diagnoal
c...  terms on the row and set diagnoal term to EP

         DO I=1,NETA
            COEF(NBD(I),1)=EP
            DO J=2,NNEIGH(NBD(I))
               COEF(NBD(I),J)=0.0d0
            END DO
         END DO

c...  for each elevation specified boundary node, zero all off diagnoal
c...  terms on the column but save these to be multiplied by the
c...  boundary value and subtracted from the RHS

         DO I=1,NETA
            DO J=2,NNeigh(NBD(I))
               DO IJ=2,NNeigh(NeiTab(NBD(I),J))
                  IF(NBD(I).EQ.NeiTab(NeiTab(NBD(I),J),IJ)) THEN
                     OBCCOEF(I,J-1)=COEF(NeiTab(NBD(I),J),IJ)
                     COEF(NeiTab(NBD(I),J),IJ)=0.0d0
                  ENDIF
               END DO
            END DO
         END DO

C.....Check that all the diagonal elements in "COEF" are > 0.
         DO I=1,NP
            IF(COEF(I,1).EQ.0.) COEF(I,1)=EP
            IF(COEF(I,1).LT.0.) THEN
             IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(6,1019) I,COEF(I,1)
               WRITE(16,1019) I,COEF(I,1)
 1019          FORMAT(/,1X,'!!!!!!!!  WARNING !!!!!!!',
     &          /,1X,'THE DIAGONAL TERM IN THE EQUATION FOR NODE ',I10,
     &          '= ',E15.6,' AND IS < 0',/)
            END IF
         END DO
         
      ENDIF                     !END OF GWCE MATRIX SETUP

C...  
C...  DEFINE RAMP FUNCTION FOR BOUNDARY ELEVATION FORCING, WIND AND PRESSURE
C.... FORCING AND TIDAL POTENTIAL FORCING
C...  
      RAMP=1.0D0
      IF(NRAMP.EQ.1) RAMP=TANH((2.D0*IT*DTDP/86400.D0)/DRAMP)

C...  UPDATE THE WIND STRESS AND SURFACE PRESSURE AND READ IN NEW VALUES
C...  FROM UNIT 22.  APPLY RAMP FUNCTION.

      IF(NWS.EQ.1) THEN
         DO I=1,NP
            READ(22,*) NHG,WSX2(I),WSY2(I),PR2(I)
            WSX2(I)=RAMP*WSX2(I)
            WSY2(I)=RAMP*WSY2(I)
            PR2(I)=RAMP*PR2(I)
            wvnxout(i)=WSX2(i)
            wvnyout(i)=WSY2(i)
         END DO
      ENDIF

      IF(ABS(NWS).EQ.2) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
               READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
            END DO
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WSX2(I) = RAMP*WINDX
            WSY2(I) = RAMP*WINDY
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            wvnxout(i)=WSX2(i)
            wvnyout(i)=WSY2(i)             
         END DO
      ENDIF

      IF(NWS.EQ.3) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
            END DO
            CALL NWS3GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,IWTIME,IWYR,WTIMED,
     &           NP,NWLON,NWLAT,WLATMAX,WLONMIN,WLATINC,WLONINC,ICS)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(ABS(NWS).EQ.4) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            CALL NWS4GET(WVNX2,WVNY2,PRN2,NP,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(ABS(NWS).EQ.5) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
               READ(22,*) NHG,WVNX2(I),WVNY2(I),PRN2(I)
            END DO
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.6) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            NWSGGWI=NWSGGWI+1
            CALL NWS6GET(X,Y,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,NWLON,NWLAT,
     &           WLATMAX,WLONMIN,WLATINC,WLONINC,ICS,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.10) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            NWSGGWI=NWSGGWI+1
            CALL NWS10GET(NWSGGWI,SLAM,SFEA,WVNX2,WVNY2,PRN2,NP,RHOWAT0,
     &           G,NWLON,NWLAT,WTIMINC)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I)=RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

      IF(NWS.EQ.11) THEN
         IF(TIME.GT.WTIME2) THEN
            WTIME1=WTIME2
            WTIME2=WTIME2+WTIMINC
            DO I=1,NP
               WVNX1(I)=WVNX2(I)
               WVNY1(I)=WVNY2(I)
               PRN1(I)=PRN2(I)
            END DO
            IDSETFLG=IDSETFLG+1
            IF(IDSETFLG.GT.8) THEN
               NWSEGWI=NWSEGWI+1
               IDSETFLG=1
            ENDIF
            CALL NWS11GET(NWSEGWI,IDSETFLG,SLAM,SFEA,WVNX2,WVNY2,PRN2,
     &           NP,RHOWAT0,G)
         ENDIF
         WTRATIO=(TIME-WTIME1)/WTIMINC
         DO I=1,NP
            WINDX = WVNX1(I) + WTRATIO*(WVNX2(I)-WVNX1(I))
            WINDY = WVNY1(I) + WTRATIO*(WVNY2(I)-WVNY1(I))
            WINDMAG = SQRT(WINDX*WINDX+WINDY*WINDY)
            WDRAGCO = 0.001d0*(0.75d0+0.067d0*WINDMAG)
            IF(WDRAGCO.GT.0.003d0) WDRAGCO=0.003d0
            WSX2(I) = RAMP*0.001293d0*WDRAGCO*WINDX*WINDMAG
            WSY2(I) = RAMP*0.001293d0*WDRAGCO*WINDY*WINDMAG
            PR2(I) = RAMP*(PRN1(I)+WTRATIO*(PRN2(I)-PRN1(I)))
            WVNXOUT(I)=RAMP*WINDX
            WVNYOUT(I)=RAMP*WINDY
         END DO
      ENDIF

C...  UPDATE THE WAVE RADIATION STRESS AND READ IN NEW VALUES FROM
C.... UNIT 23.  APPLY RAMP FUNCTION.  ADD RADIATION STRESS TO WIND
C...  STRESS
C...  

c......BDE	 
c  Updating radiation stress from MCELServer via coupling.mcel.F
c......BDE

      IF(NRS.EQ.1) THEN
         IF(TIME.GT.RSTIME2) THEN
            RSTIME1=RSTIME2
            RSTIME2=RSTIME2+RSTIMINC
            DO I=1,NP
               RSNX1(I)=RSNX2(I)
               RSNY1(I)=RSNY2(I)
            END DO
	    IF(ABS(NWS_MCEL).EQ.1000) THEN
	      CALL READ_MCEL_STRS(RSTIME2,RSNX2,RSNY2)
	    ELSE
              CALL RSGET(RSNX2,RSNY2,NP)
            ENDIF
	 ENDIF
         RSTRATIO=(TIME-RSTIME1)/RSTIMINC
         DO I=1,NP
            RSX = RAMP*(RSNX1(I) + RSTRATIO*(RSNX2(I)-RSNX1(I)))
            RSY = RAMP*(RSNY1(I) + RSTRATIO*(RSNY2(I)-RSNY1(I)))
            WSX2(I) = WSX2(I) + RSX
            WSY2(I) = WSY2(I) + RSY
         END DO
      ENDIF

C...  
C...  Tidal Potential Forcing
C...  Note, the Earth tide potential reduction factor, ETRF(J) has been
C...        incorporated into this calculation.
C... 
      IF(CTIP) THEN
         DO J=1,NTIF
            IF(PERT(J).EQ.0.) THEN
               NCYC=0
            ELSE
               NCYC=INT(timeh/PERT(J))
            ENDIF
            ARGT=AMIGT(J)*(timeh-NCYC*PERT(J))+FACET(J)
            TPMUL=RAMP*ETRF(J)*TPK(J)*FFT(J)
            SALTMUL=RAMP*FFT(J)
            NA=NINT(0.00014/AMIGT(J))
            IF(NA.EQ.1) THEN    !SEMI-DIURNAL SPECIES
               DO I=1,NP
                  ARGTP=ARGT+2.d0*SLAM(I)
                  ARGSALT=ARGT-SALTPHA(J,I)
                  CCSFEA=COS(SFEA(I))
                  CCSFEA=CCSFEA*CCSFEA
                  TIP2(I)=TIP2(I)+TPMUL*CCSFEA*COS(ARGTP)
     &                 +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
            ENDIF
            IF(NA.EQ.2) THEN    !DIURNAL SPECIES
               DO I=1,NP
                  ARGTP=ARGT+SLAM(I)
                  ARGSALT=ARGT-SALTPHA(J,I)
#ifdef REAL4
                  S2SFEA=SIN(2.e0*SFEA(I))
#else 
                  S2SFEA=SIN(2.d0*SFEA(I))
#endif
                  TIP2(I)=TIP2(I)+TPMUL*S2SFEA*COS(ARGTP)
     &                 +SALTMUL*SALTAMP(J,I)*COS(ARGSALT)
               END DO
            ENDIF
         END DO
      ENDIF

C...  
C...  COMPUTE SPECIFIED NORMAL FLOW BOUNDARY CONDITION
C...  
      IF(NFLUXF.EQ.1) THEN
         DO J=1,NFFR
            IF(FPER(J).EQ.0.) THEN
               NCYC=0.
            ELSE
               NCYC=INT(timeh/FPER(J))
            ENDIF
            ARGJ=FAMIG(J)*(timeh-NCYC*FPER(J))+FFACE(J)
            RFF=FFF(J)*RAMP
            DO I=1,NVEL
               ARG=ARGJ-QNPH(J,I)
               QN2(I)=QN2(I)+QNAM(J,I)*RFF*COS(ARG)
               IF(LBCODEI(J).EQ.32) THEN
                  ARG=ARGJ-ENPH(J,I)
                  EN2(I)=EN2(I)+ENAM(J,I)*RFF*COS(ARG)
               ENDIF
            END DO
         END DO
         IF(NFFR.EQ.0) THEN
            IF(TIME.GT.QTIME2) THEN
               QTIME1=QTIME2
               QTIME2=QTIME2+FTIMINC
               DO J=1,NVEL
                  IF((LBCODEI(J).EQ.2).OR.(LBCODEI(J).EQ.12)
     &                 .OR.(LBCODEI(J).EQ.22)) THEN
                     QNIN1(J)=QNIN2(J)
                     READ(20,*) QNIN2(J)
                  ENDIF
                  IF(LBCODEI(J).EQ.32) THEN
                     QNIN1(J)=QNIN2(J)
                     ENIN1(J)=ENIN2(J)
                     READ(20,*) QNIN2(J),ENIN2(J)
                  ENDIF
               END DO
            ENDIF
            QTRATIO=(TIME-QTIME1)/FTIMINC
            DO I=1,NVEL
               QN2(I)=RAMP*(QNIN1(I)+QTRATIO*(QNIN2(I)-QNIN1(I)))
               EN2(I)=RAMP*(ENIN1(I)+QTRATIO*(ENIN2(I)-ENIN1(I)))
            END DO
         ENDIF
      ENDIF

C...  
C...  COMPUTE DISCHARGE CONTRIBUTION FROM RADIATION BOUNDARY CONDITION
C...  
      IF(NFLUXRBC.EQ.1) THEN
         DO J=1,NVEL
            IF(LBCODEI(J).EQ.30) THEN
               NNBB=NBV(J)
               HH1=DP(NNBB)+IFNLFA*ETA2(NNBB)
               UN1=UU1(NNBB)*CSII(J)+VV1(NNBB)*SIII(J)
               QN1(J)=HH1*UN1
            ENDIF
         END DO
      ENDIF

C...  COMPUTE DISCHARGE CONTRIBUTION FROM ZERO NORMAL VELOCITY GRADIENT
C...  BOUNDARY CONDITION
C...  
        IF(NFLUXGBC.EQ.1) THEN
          DO J=1,NVEL
            IF((LBCODEI(J).EQ.40).OR.(LBCODEI(J).EQ.41)) THEN
              NNBB=NBV(J)
              HH1=DP(NNBB)+IFNLFA*ETA2(NNBB)
              UN1=UU1(NNBB)*CSII(J)+VV1(NNBB)*SIII(J)
              QN1(J)=HH1*UN1
              ENDIF
            END DO
          ENDIF
C...  
C...  COMPUTE SUPERCRITICAL OUTWARD NORMAL FLOW OVER SPECIFIED
C.... EXTERNAL BARRIER BOUNDARY NODES
C...  
        IF(NFLUXB.EQ.1) THEN
          DO I=1,NVEL
            IF((LBCODEI(I).EQ.3).OR.(LBCODEI(I).EQ.13).OR.
     &        (LBCODEI(I).EQ.23)) THEN
              NNBB=NBV(I)
              RBARWL=2.D0*(ETA2(NNBB)-BARLANHT(I))/3.D0
              IF(RBARWL.GT.0.0D0) THEN
                QN2(I)=-RAMP*BARLANCFSP(I)*RBARWL*(RBARWL*G)**0.5D0
              ELSE
                QN2(I)=0.0D0
              ENDIF
            ENDIF
          END DO
        ENDIF

C...  COMPUTE INWARD/OUTWARD NORMAL FLOW OVER SPECIFIED INTERNAL BARRIER
C...  BOUNDARY (PERMEABLE OR NOT) NODES
C...  
      IF(NFLUXIB.EQ.1) THEN
         DO I=1,NP
            NIBNODECODE(I)=0
         END DO
         DO I=1,NVEL
            IF((LBCODEI(I).EQ.4).OR.(LBCODEI(I).EQ.24).OR.
     &           (LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
               NNBB1=NBV(I)     ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
               NNBB2=IBCONN(I)  ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
               IF(IBSTART.EQ.0)THEN
                  RBARWL1AVG(I)=ETA2(NNBB1)-BARINHT(I)
                  RBARWL2AVG(I)=ETA2(NNBB2)-BARINHT(I)
                  IBSTART=1
               ELSE
                  RBARWL1AVG(I)=(ETA2(NNBB1)-BARINHT(I)+BARAVGWT
     &                 *RBARWL1AVG(I))/(1+BARAVGWT)
                  RBARWL2AVG(I)=(ETA2(NNBB2)-BARINHT(I)+BARAVGWT
     &                 *RBARWL2AVG(I))/(1+BARAVGWT)
               ENDIF
               RBARWL1=RBARWL1AVG(I)
               RBARWL2=RBARWL2AVG(I)
               RBARWL1F=2.0D0*RBARWL1/3.0D0
               RBARWL2F=2.0D0*RBARWL2/3.0D0
               QN2(I)=0.0D0
               IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN
C...............WATER LEVEL ON BOTH SIDES OF BARRIER BELOW BARRIER -> CASE 1
                  QN2(I)=0.0D0
                  GOTO 1034
               ENDIF
               IF(RBARWL1.EQ.RBARWL2) THEN
C...............WATER LEVEL EQUAL ON BOTH SIDES OF BARRIER -> CASE 2
                  QN2(I)=0.0D0
                  GOTO 1034
               ENDIF
               IF((RBARWL1.GT.RBARWL2).AND.(RBARWL1.GT.BARMIN)) THEN
C...............WATER LEVEL GREATER ON THIS SIDE OF THE BARRIER AND IS SUCH
C................THAT OVERTOPPING IS OCCURING
                  IF(RBARWL2.GT.RBARWL1F) THEN
C.................OUTWARD SUBCRITICAL FLOW -> CASE 3
                     QN2(I)=-RAMP*RBARWL2*BARINCFSB(I)*
     &                    (2.D0*G*(RBARWL1-RBARWL2))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................OUTWARD SUPERCRITICAL FLOW -> CASE 4
                     QN2(I)=-RAMP*BARINCFSP(I)*RBARWL1F*
     &                    (RBARWL1F*G)**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1034
               ENDIF
               IF((RBARWL2.GT.RBARWL1).AND.(RBARWL2.GT.BARMIN)) THEN
C...............WATER LEVEL LOWER ON THIS SIDE OF BARRIER AND IS SUCH
C................THAT OVERTOPPING IS OCCURING
                  IF(RBARWL1.GT.RBARWL2F) THEN
C.................INWARD SUBCRITICAL FLOW -> CASE 5
                     QN2(I)=RAMP*RBARWL1*BARINCFSB(I)*
     &                    (2.0D0*G*(RBARWL2-RBARWL1))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................INWARD SUPERCRITICAL FLOW -> CASE 6
                     QN2(I)=RAMP*BARINCFSP(I)*RBARWL2F*
     &                    (RBARWL2F*G)**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1034
               ENDIF
 1034          CONTINUE
            ENDIF
         END DO
      ENDIF
      
C...  
C...  COMPUTE INWARD/OUTWARD NORMAL FLOW FOR INTERNAL BARRIER 
C.... BOUNDARY NODES THROUGH CROSS BARRIER PIPES
C.... NOTE THAT THIS ADDS AN ADDITIONAL FLOW COMPONENT INTO QN2
C...  
      IF(NFLUXIBP.EQ.1) THEN
         DO I=1,NVEL
            IF((LBCODEI(I).EQ.5).OR.(LBCODEI(I).EQ.25)) THEN
               NNBB1=NBV(I)     ! GLOBAL NODE NUMBER ON THIS SIDE OF BARRIER
               NNBB2=IBCONN(I)  ! GLOBAL NODE NUMBER ON OPPOSITE SIDE OF BARRIER
               IF(IBSTART.EQ.0)THEN
                  RPIPEWL1AVG(I)=ETA2(NNBB1)-PIPEHT(I)
                  RPIPEWL2AVG(I)=ETA2(NNBB2)-PIPEHT(I)
                  IBSTART=1
               ELSE
                  RPIPEWL1AVG(I)=(ETA2(NNBB1)-PIPEHT(I)+BARAVGWT
     &                 *RPIPEWL1AVG(I))/(1+BARAVGWT)
                  RPIPEWL2AVG(I)=(ETA2(NNBB2)-PIPEHT(I)+BARAVGWT
     &                 *RPIPEWL2AVG(I))/(1+BARAVGWT)
               ENDIF
               RBARWL1=RPIPEWL1AVG(I)
               RBARWL2=RPIPEWL2AVG(I)
               IF((RBARWL1.LT.0.0).AND.(RBARWL2.LT.0.0)) THEN
C...............WATER LEVEL ON BOTH SIDES OF BARRIER BELOW PIPE -> CASE 1
                  QN2(I)=QN2(I)+0.0D0
                  GOTO 1036
               ENDIF
               IF(RBARWL1.EQ.RBARWL2) THEN
C...............WATER LEVEL EQUAL ON BOTH SIDES OF PIPE -> CASE 2
                  QN2(I)=QN2(I)+0.0D0
                  GOTO 1036
               ENDIF
               IF((RBARWL1.GT.RBARWL2).AND.(RBARWL1.GT.BARMIN)) THEN
C...............WATER LEVEL GREATER ON THIS SIDE OF THE PIPE AND IS SUCH
C................THAT OUTWARD DISCHARGE IS OCCURING
                  IF(RBARWL2.LE.0) THEN
C.................OUTWARD FREE DISCHARGE -> CASE 3
                     QN2(I)=QN2(I)-RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     &                    *(2.D0*G*RBARWL1/(1+PIPECOEF(I)))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................OUTWARD SUBMERGED DISCHARGE -> CASE 4
                     QN2(I)=QN2(I)-RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     &                    *(2.D0*G*(RBARWL1-RBARWL2)/PIPECOEF(I))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1036
               ENDIF
               IF((RBARWL2.GT.RBARWL1).AND.(RBARWL2.GT.BARMIN)) THEN
C...............WATER LEVEL LOWER ON THIS SIDE OF PIPE AND IS SUCH
C................THAT INWARD DISCHARGE IS OCCURING
                  IF(RBARWL1.LE.0) THEN
C.................INWARD FREE DISCHARGE -> CASE 5
                     QN2(I)=QN2(I)+RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     &                    *(2.D0*G*RBARWL2/(1+PIPECOEF(I)))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ELSE
C.................INWARD SUBMERGED DISCHARGE -> CASE 6
                     QN2(I)=QN2(I)+RAMP*0.25D0*PI*(PIPEDIAM(I))**2
     &                    *(2.D0*G*(RBARWL2-RBARWL1)/PIPECOEF(I))**0.5D0
                     NIBNODECODE(NNBB1)=1
                  ENDIF
                  GOTO 1036
               ENDIF
 1036          CONTINUE
            ENDIF
         END DO
      ENDIF

C     2DDI...
C     2DDI....COMPUTE THE BUOYANCY FORCING FOR 2D
C     2DDI...
c     IF (2DDI) THEN
c     DO I=1,NP
c     VIDBCPDX1(I)=0.D0
c     VIDBCPDY1(I)=0.D0
c     END DO 
c     
c     IF(IDEN.EQ.1) THEN 
c     DO IE=1,NE     !Assemble elementally, not worrying about vectorization
c     NM1=NM(IE,1)
c     NM2=NM(IE,2)
c     NM3=NM(IE,3)
c     NC1=NODECODE(NM1)
c     NC2=NODECODE(NM2)
c     NC3=NODECODE(NM3)
c     NCELE=NC1*NC2*NC3
c     E1N1=IFNLFA*ETA2(NM1)
c     E1N2=IFNLFA*ETA2(NM2)
c     E1N3=IFNLFA*ETA2(NM3)
c     DIMDARHON1=DASIGT(NM1)-SIGT0
c     DIMDARHON2=DASIGT(NM2)-SIGT0
c     DIMDARHON3=DASIGT(NM3)-SIGT0
c     DIMDARHOPP=(DIMDARHON1+DIMDARHON2+DIMDARHON3)/3.D0
c     HH1N1=DP(NM1)+E1N1
c     HH1N2=DP(NM2)+E1N2
c     HH1N3=DP(NM3)+E1N3
c     HPPO2=(HH1N1+HH1N2+HH1N3)/6.D0
c     
c     AREAIE=AREAS(IE)               !2A
c     FDX1 = (Y(NM2)-Y(NM3))*SFACPP  !b1
c     FDX2 = (Y(NM3)-Y(NM1))*SFACPP  !b2
c     FDX3 = (Y(NM1)-Y(NM2))*SFACPP  !b3
c     FDY1 = X(NM3)-X(NM2)           !a1
c     FDY2 = X(NM1)-X(NM3)           !a2
c     FDY3 = X(NM2)-X(NM1)           !a3
c     FDX1OA=FDX1/AREAIE             !dphi1/dx
c     FDY1OA=FDY1/AREAIE             !dphi1/dy
c     FDX2OA=FDX2/AREAIE             !dphi2/dx
c     FDY2OA=FDY2/AREAIE             !dphi2/dy
c     FDX3OA=FDX3/AREAIE             !dphi3/dx
c     FDY3OA=FDY3/AREAIE             !dphi3/dy
c     
c     VIDBCPDXELE=DIMDARHOPP*(E1N1*FDX1OA+E1N2*FDX2OA+E1N3*FDX3OA)
c     &                 +HPPO2*(DIMDARHON1*FDX1OA+DIMDARHON2*FDX2OA
c     &                                               +DIMDARHON3*FDX3OA)
c     VIDBCPDYELE=DIMDARHOPP*(E1N1*FDY1OA+E1N2*FDY2OA+E1N3*FDY3OA)
c     &                 +HPPO2*(DIMDARHON1*FDY1OA+DIMDARHON2*FDY2OA
c     &                                               +DIMDARHON3*FDY3OA)                           
c     VIDBCPDX1(NM1)=VIDBCPDX1(NM1)+VIDBCPDXELE*NCELE
c     VIDBCPDX1(NM2)=VIDBCPDX1(NM2)+VIDBCPDXELE*NCELE
c     VIDBCPDX1(NM3)=VIDBCPDX1(NM3)+VIDBCPDXELE*NCELE
c     VIDBCPDY1(NM1)=VIDBCPDY1(NM1)+VIDBCPDYELE*NCELE
c     VIDBCPDY1(NM2)=VIDBCPDY1(NM2)+VIDBCPDYELE*NCELE
c     VIDBCPDY1(NM3)=VIDBCPDY1(NM3)+VIDBCPDYELE*NCELE
c     END DO
c     
c     DO I=1,NP
c     GHH1FAC=G*RAMP*(DP(I)+IFNLFA*ETA2(I))/RHOWAT0/MJU(I)
c     VIDBCPDX1(I)=GHH1FAC*VIDBCPDX1(I)
c     VIDBCPDY1(I)=GHH1FAC*VIDBCPDY1(I)
c     END DO
c     
c     ENDIF
c     ENDIF

C...  
C...  COMPLETE THE THE LOAD VECTOR QW FOR THE GWCE ELEMENT BY ELEMENT
C...  BY FORMING TEMPORARY VECTORS AND THEN ASSEMBLING AT THE END.
C...  THE FOLLOWING ASSEMBLY LOOPS HAVE ALL BEEN UNROLLED TO OPTIMIZE
C...  VECORIZATION
C...  

C...  Initialize variables to zero if forcing is not used
C...  
      if((NWS.NE.0).OR.(NRS.NE.0)) then
      else
         WSXN1=0.d0
         WSXN2=0.d0
         WSXN3=0.d0
         WSYN1=0.d0
         WSYN2=0.d0
         WSYN3=0.d0
         PR1N1=0.d0
         PR1N2=0.d0
         PR1N3=0.d0
      endif

      if (CTIP) then
      else
         TIPN1=0.d0
         TIPN2=0.d0
         TIPN3=0.d0
      endif

      DO 1037 IE=1,NE
C...  
C...  SET NODAL VALUES FOR EACH ELEMENT
C...  
         NM1=NM(IE,1)
         NM2=NM(IE,2)
         NM3=NM(IE,3)
         NC1=NODECODE(NM1)
         NC2=NODECODE(NM2)
         NC3=NODECODE(NM3)
         NCELE=NC1*NC2*NC3
         E0N1=ETA1(NM1)
         E0N2=ETA1(NM2)
         E0N3=ETA1(NM3)
         E1N1=ETA2(NM1)
         E1N2=ETA2(NM2)
         E1N3=ETA2(NM3)
         E1N1SQ=E1N1*E1N1
         E1N2SQ=E1N2*E1N2
         E1N3SQ=E1N3*E1N3
         ESN1=ETAS(NM1)
         ESN2=ETAS(NM2)
         ESN3=ETAS(NM3)
         U1N1=UU1(NM1)
         U1N2=UU1(NM2)
         U1N3=UU1(NM3)
         V1N1=VV1(NM1)
         V1N2=VV1(NM2)
         V1N3=VV1(NM3)
         HH1N1=DP(NM1)+IFNLFA*E1N1
         HH1N2=DP(NM2)+IFNLFA*E1N2
         HH1N3=DP(NM3)+IFNLFA*E1N3
         HHU1N1=HH1N1*U1N1
         HHU1N2=HH1N2*U1N2
         HHU1N3=HH1N3*U1N3
         HHV1N1=HH1N1*V1N1
         HHV1N2=HH1N2*V1N2
         HHV1N3=HH1N3*V1N3
         SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0

C     jjw - m10 - define various tau0 values                   
         T0N1=Tau0VAR(NM1) 
         T0N2=Tau0VAR(NM2) 
         T0N3=Tau0VAR(NM3) 
         TAU0AVG=(T0N1+T0N2+T0N3)/3.d0
         TT0R=((0.5d0*TAU0AVG*DT-1.0d0)/DT)/DT
         T0XN1=T0N1*HHU1N1
         T0YN1=T0N1*HHV1N1
         T0XN2=T0N2*HHU1N2
         T0YN2=T0N2*HHV1N2
         T0XN3=T0N3*HHU1N3
         T0YN3=T0N3*HHV1N3

         IF((NWS.NE.0).OR.(NRS.NE.0)) THEN     !wind or radiation stress
            WSXN1=WSX1(NM1)
            WSXN2=WSX1(NM2)
            WSXN3=WSX1(NM3)
            WSYN1=WSY1(NM1)
            WSYN2=WSY1(NM2)
            WSYN3=WSY1(NM3)
            PR1N1=PR1(NM1)
            PR1N2=PR1(NM2)
            PR1N3=PR1(NM3)
         ENDIF

C         VIDBCPDX1N1=VIDBCPDX1(NM1)   !buoyancy 
C         VIDBCPDX1N2=VIDBCPDX1(NM2)
C         VIDBCPDX1N3=VIDBCPDX1(NM3)
C         VIDBCPDY1N1=VIDBCPDY1(NM1)
C         VIDBCPDY1N2=VIDBCPDY1(NM2)
C         VIDBCPDY1N3=VIDBCPDY1(NM3)

CTIP..If using tidal potential terms
         if (CTIP) then         !tidal potential
            TIPN1=TIP1(NM1)
            TIPN2=TIP1(NM2)
            TIPN3=TIP1(NM3)
         endif

C2DDI.For the 2DDI version of the code
C2DDI.Compute bottom friction
         if (C2DDI) then        !2D bottom friction
            BSXN1=TK(NM1)*HHU1N1
            BSYN1=TK(NM1)*HHV1N1
            BSXN2=TK(NM2)*HHU1N2
            BSYN2=TK(NM2)*HHV1N2
            BSXN3=TK(NM3)*HHU1N3
            BSYN3=TK(NM3)*HHV1N3
         endif      

C3D...For the 3D version of the code
C3D...Setup bottom friction and velocity dispersion
         if (C3D) then          !3D bottom friction & dispersion
            BSXN1=BSX1(NM1)
            BSXN2=BSX1(NM2)
            BSXN3=BSX1(NM3)
            BSYN1=BSY1(NM1)
            BSYN2=BSY1(NM2)
            BSYN3=BSY1(NM3)
            DVV1N1=DVV1(NM1)
            DVV1N2=DVV1(NM2)
            DVV1N3=DVV1(NM3)
            DUV1N1=DUV1(NM1)
            DUV1N2=DUV1(NM2)
            DUV1N3=DUV1(NM3)
            DUU1N1=DUU1(NM1)
            DUU1N2=DUU1(NM2)
            DUU1N3=DUU1(NM3)
         endif

C...  
C...  COMPUTE ELEMENT AVERAGED QUANTITIES
C... 
         AH=(DP(NM1)+DP(NM2)+DP(NM3))/3.d0
         GHPP=GO3*(HH1N1+HH1N2+HH1N3)
         UPP=(U1N1+U1N2+U1N3)/3.d0
         VPP=(V1N1+V1N2+V1N3)/3.d0
         UHPP3=HHU1N1+HHU1N2+HHU1N3
         VHPP3=HHV1N1+HHV1N2+HHV1N3
         UHPP=UHPP3/3.d0
         VHPP=VHPP3/3.d0
         EVMPPODT=((EVM(NM1)+EVM(NM2)+EVM(NM3))/3.d0)/DT
         CORIFPP=(CORIF(NM1)+CORIF(NM2)+CORIF(NM3))/3.d0
         BSXpp3=BSXn1+BSXn2+BSXn3
         BSYpp3=BSYn1+BSYn2+BSYn3
         T0XPP3=T0XN1+T0XN2+T0XN3
         T0YPP3=T0YN1+T0YN2+T0YN3
C         VIDBCPDXPP3=VIDBCPDX1N1+VIDBCPDX1N2+VIDBCPDX1N3
C         VIDBCPDYPP3=VIDBCPDY1N1+VIDBCPDY1N2+VIDBCPDY1N3

C...  
C...  COMPUTE ELEMENTAL COEFFICIENTS
C...  
         AREAIE=AREAS(IE)       !2A
         FDX1 = (Y(NM2)-Y(NM3))*SFACPP !b1
         FDX2 = (Y(NM3)-Y(NM1))*SFACPP !b2
         FDX3 = (Y(NM1)-Y(NM2))*SFACPP !b3
         FDY1 = X(NM3)-X(NM2)   !a1
         FDY2 = X(NM1)-X(NM3)   !a2
         FDY3 = X(NM2)-X(NM1)   !a3
         FDX1OA=FDX1/AREAIE     !dphi1/dx
         FDY1OA=FDY1/AREAIE     !dphi1/dy
         FDX2OA=FDX2/AREAIE     !dphi2/dx
         FDY2OA=FDY2/AREAIE     !dphi2/dy
         FDX3OA=FDX3/AREAIE     !dphi3/dx
         FDY3OA=FDY3/AREAIE     !dphi3/dy

         DDX1=FDX1/3.d0         !<2*(dphi1/dx)*phij> j=1,2,3
         DDY1=FDY1/3.d0         !<2*(dphi1/dy)*phij> j=1,2,3
         DXX11=FDX1OA*FDX1      !<2*(dphi1/dx)*(dphi1/dx)>
         DYY11=FDY1OA*FDY1      !<2*(dphi1/dy)*(dphi1/dy)>
         DXY11=FDX1OA*FDY1      !<2*(dphi1/dx)*(dphi1/dy)>
         DXXYY11=DXX11+DYY11
         DXYH11=AH*DXXYY11      !jgf42.07 AH was DPPP
         DXX12=FDX1OA*FDX2      !<2*(dphi1/dx)*(dphi2/dx)>
         DYY12=FDY1OA*FDY2      !<2*(dphi1/dy)*(dphi2/dy)>
         DXY12=FDX1OA*FDY2      !<2*(dphi1/dx)*(dphi2/dy)>
         DXXYY12=DXX12+DYY12
         DXYH12=AH*DXXYY12      !jgf42.07 AH was DPPP
         DXX13=FDX1OA*FDX3      !<2*(dphi1/dx)*(dphi3/dx)>
         DYY13=FDY1OA*FDY3      !<2*(dphi1/dy)*(dphi3/dy)>
         DXY13=FDX1OA*FDY3      !<2*(dphi1/dx)*(dphi3/dy)>
         DXXYY13=DXX13+DYY13
         DXYH13=AH*DXXYY13      !jgf42.07 AH was DPPP

         DDX2=FDX2/3.d0         !<2*(dphi2/dx)*phij> j=1,2,3
         DDY2=FDY2/3.d0         !<2*(dphi2/dy)*phij> j=1,2,3
         DXX21=DXX12            !<2*(dphi2/dx)*(dphi1/dx)>
         DYY21=DYY12            !<2*(dphi2/dy)*(dphi1/dy)>
         DXY21=FDX2OA*FDY1      !<2*(dphi2/dx)*(dphi1/dy)>
         DXXYY21=DXXYY12
         DXYH21=DXYH12
         DXX22=FDX2OA*FDX2      !<2*(dphi2/dx)*(dphi2/dx)>
         DYY22=FDY2OA*FDY2      !<2*(dphi2/dy)*(dphi2/dy)>
         DXY22=FDX2OA*FDY2      !<2*(dphi2/dx)*(dphi2/dy)>
         DXXYY22=DXX22+DYY22
         DXYH22=AH*DXXYY22      !jgf42.07 AH was DPPP
         DXX23=FDX2OA*FDX3      !<2*(dphi2/dx)*(dphi3/dx)>
         DYY23=FDY2OA*FDY3      !<2*(dphi2/dy)*(dphi3/dy)>
         DXY23=FDX2OA*FDY3      !<2*(dphi2/dx)*(dphi3/dy)>
         DXXYY23=DXX23+DYY23
         DXYH23=AH*DXXYY23      !jgf42.07 AH was DPPP

         DDX3=FDX3/3.d0         !<2*(dphi3/dx)*phij> j=1,2,3
         DDY3=FDY3/3.d0         !<2*(dphi3/dy)*phij> j=1,2,3
         DXX31=DXX13            !<2*(dphi3/dx)*(dphi1/dx)>
         DYY31=DYY13            !<2*(dphi3/dy)*(dphi1/dy)>
         DXY31=FDX3OA*FDY1      !<2*(dphi3/dx)*(dphi1/dy)>
         DXXYY31=DXXYY13
         DXYH31=DXYH13
         DXX32=DXX23            !<2*(dphi3/dx)*(dphi2/dx)>
         DYY32=DYY23            !<2*(dphi3/dy)*(dphi2/dy)>
         DXY32=FDX3OA*FDY2      !<2*(dphi3/dx)*(dphi2/dy)>
         DXXYY32=DXXYY23
         DXYH32=DXYH23
         DXX33=FDX3OA*FDX3      !<2*(dphi3/dx)*(dphi3/dx)>
         DYY33=FDY3OA*FDY3      !<2*(dphi3/dy)*(dphi3/dy)>
         DXY33=FDX3OA*FDY3      !<2*(dphi3/dx)*(dphi3/dy)>
         DXXYY33=DXX33+DYY33
         DXYH33=AH*DXXYY33      !jgf42.07 AH was DPPP

         AO6=AREAIE/6.d0
         AO12=AREAIE/12.d0
         FDDD=(1+ILUMP)*AO6     !2*<phi*phj> diagonal terms
         FDDOD=(1-ILUMP)*AO12   !2*<phi*phj> off diagonal terms

C
C...  COMPUTE THE CONTRIBUTION OF A SPATIALLY VARIABLE Tau0
C 
        SpaVarTau0=(T0N1*DDX1+T0N2*DDX2+T0N3*DDX3)*UHPP
     &            +(T0N1*DDY1+T0N2*DDY2+T0N3*DDY3)*VHPP

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM1
C...  
         QTEMA1=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     &        -(FDDD*ESN1+FDDOD*ESN2+FDDOD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     &        -(DXYH11*E0N1+DXYH12*E0N2+DXYH13*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     &        -(DXYH11*E1N1+DXYH12*E1N2+DXYH13*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     &        +(T0XPP3-BSXpp3)*DDX1
     &        +(T0YPP3-BSYpp3)*DDY1
     &        +SpaVarTau0

C...  CORIOLIS FORCE
     &        +CORIFPP*(VHPP3*DDX1-UHPP3*DDY1)

C...  WIND STRESS & ATMONPHERIC PRESSURE GRADIENTS
     &        +(WSXN1+WSXN2+WSXN3)*DDX1
     &        +(WSYN1+WSYN2+WSYN3)*DDY1
     &        -GHPP*(PR1N1*DXXYY11+PR1N2*DXXYY12+PR1N3*DXXYY13)

C...  TIDAL POTENTIAL FORCING
     &        +GHPP*(TIPN1*DXXYY11+TIPN2*DXXYY12+TIPN3*DXXYY13)

C...  LATERAL VISCOSITY TERM  
     &        -EVMPPODT*(DXXYY11*ESN1+DXXYY12*ESN2+DXXYY13*ESN3)

C...  FINITE AMPLITUDE
     &        -GFAO2*(E1N1SQ*DXXYY11+E1N2SQ*DXXYY12+E1N3SQ*DXXYY13)

C...  ADVECTIVE TERMS
     &        -IFNLCT*(UHPP*(U1N1*DXX11+U1N2*DXX21+U1N3*DXX31
     &        +V1N1*DXY11+V1N2*DXY21+V1N3*DXY31)
     &        +VHPP*(U1N1*DXY11+U1N2*DXY12+U1N3*DXY13
     &        +V1N1*DYY11+V1N2*DYY21+V1N3*DYY31))

C...  advective terms (time derivative portion in gwce) which must be
c...  bundled in with the finite amplitude terms in order to get good
c...  mass conservation when the advective terms are shut down

     &        +TADVODT*(UPP*DDX1+VPP*DDY1)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS 
c      &        -VIDBCPDXPP3*DDX1-VIDBCPDYPP3*DDY1

C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA1=QTEMA1-IFNLCT*(DUU1N1*DXX11+DUU1N2*DXX12+DUU1N3*DXX13
     &           +DUV1N1*DXY11+DUV1N2*DXY12+DUV1N3*DXY13
     &           +DUV1N1*DXY11+DUV1N2*DXY21+DUV1N3*DXY31
     &           +DVV1N1*DYY11+DVV1N2*DYY12+DVV1N3*DYY13)
           endif

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM2
C...  
         QTEMA2=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     &        -(FDDOD*ESN1+FDDD*ESN2+FDDOD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     &        -(DXYH12*E0N1+DXYH22*E0N2+DXYH23*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     &        -(DXYH12*E1N1+DXYH22*E1N2+DXYH23*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     &        +(T0XPP3-BSXpp3)*DDX2
     &        +(T0YPP3-BSYpp3)*DDY2
     &        +SpaVarTau0

C...  CORIOLIS FORCE
     &        +CORIFPP*(VHPP3*DDX2-UHPP3*DDY2)

C...  WIND AND ATMOSPHERIC PRESSURE FORCING
     &        +(WSXN1+WSXN2+WSXN3)*DDX2
     &        +(WSYN1+WSYN2+WSYN3)*DDY2
     &        -GHPP*(PR1N1*DXXYY21+PR1N2*DXXYY22+PR1N3*DXXYY23)

C...  TIDAL POTENTIAL FORCING
     &        +GHPP*(TIPN1*DXXYY21+TIPN2*DXXYY22+TIPN3*DXXYY23)

C...  LATERAL VISCOSITY TERM
     &        -EVMPPODT*(DXXYY12*ESN1+DXXYY22*ESN2+DXXYY23*ESN3)

C...  FINITE AMPLITUDE
     &        -GFAO2*(E1N1SQ*DXXYY21+E1N2SQ*DXXYY22+E1N3SQ*DXXYY23)

C...  ADVECTIVE TERMS
     &        -IFNLCT*(UHPP*(U1N1*DXX12+U1N2*DXX22+U1N3*DXX32
     &        +V1N1*DXY12+V1N2*DXY22+V1N3*DXY32)
     &        +VHPP*(U1N1*DXY21+U1N2*DXY22+U1N3*DXY23
     &        +V1N1*DYY12+V1N2*DYY22+V1N3*DYY32))

C...  advective terms (time derivative portion in gwce) which must be
c...  bundled in with the finite amplitude terms in order to get good
c...  mass conservation when the advective terms are shut down

     &        +TADVODT*(UPP*DDX2+VPP*DDY2)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS
C     &        -VIDBCPDXPP3*DDX2-VIDBCPDYPP3*DDY2 


C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA2=QTEMA2-IFNLCT*(DUU1N1*DXX12+DUU1N2*DXX22+DUU1N3*DXX23
     &           +DUV1N1*DXY21+DUV1N2*DXY22+DUV1N3*DXY23
     &           +DUV1N1*DXY12+DUV1N2*DXY22+DUV1N3*DXY32
     &           +DVV1N1*DYY12+DVV1N2*DYY22+DVV1N3*DYY23)
           endif

C...  
C...  COMPUTE THE RHS GWCE FORCING AND PUT INTO QTEMA VECTOR FOR NODE NM1
C...  
         QTEMA3=
C...  TRANSIENT AND Tau0 TERMS FROM LHS
     &        -(FDDOD*ESN1+FDDOD*ESN2+FDDD*ESN3)*TT0R

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K-1)
     &        -(DXYH13*E0N1+DXYH23*E0N2+DXYH33*E0N3)*GC00

C...  FREE SURFACE TERMS FROM LHS (TIME LEVEL K)
     &        -(DXYH13*E1N1+DXYH23*E1N2+DXYH33*E1N3)*GB00A00

C...  BOTTOM FRICTION & Tau0
     &        +(T0XPP3-BSXpp3)*DDX3
     &        +(T0YPP3-BSYpp3)*DDY3
     &        +SpaVarTau0

C...  CORIOLIS FORCE
     &        +CORIFPP*(VHPP3*DDX3-UHPP3*DDY3)

C...  WIND AND ATMOSPHERIC PRESSURE FORCING
     &        +(WSXN1+WSXN2+WSXN3)*DDX3
     &        +(WSYN1+WSYN2+WSYN3)*DDY3
     &        -GHPP*(PR1N1*DXXYY31+PR1N2*DXXYY32+PR1N3*DXXYY33)

C...  TIDAL POTENTIAL FORCING
     &        +GHPP*(TIPN1*DXXYY31+TIPN2*DXXYY32+TIPN3*DXXYY33)

C...  LATERAL VISCOSITY TERM
     &        -EVMPPODT*(DXXYY13*ESN1+DXXYY23*ESN2+DXXYY33*ESN3)

C...  FINITE AMPLITUDE
     &        -GFAO2*(E1N1SQ*DXXYY31+E1N2SQ*DXXYY32+E1N3SQ*DXXYY33)

C...  ADVECTIVE TERMS
     &        -IFNLCT*(UHPP*(U1N1*DXX13+U1N2*DXX23+U1N3*DXX33
     &        +V1N1*DXY13+V1N2*DXY23+V1N3*DXY33)
     &        +VHPP*(U1N1*DXY31+U1N2*DXY32+U1N3*DXY33
     &        +V1N1*DYY13+V1N2*DYY23+V1N3*DYY33))

C...  ADVECTIVE TERMS (TIME DERIVATIVE PORTION IN GWCE) WHICH MUST
C.... BE BUNDLED IN WITH THE FINITE AMPLITUDE TERMS IN ORDER TO GET GOOD
C...  MASS
C.... CONSERVATION WHEN THE ADVECTIVE TERMS ARE SHUT DOWN
     &        +TADVODT*(UPP*DDX3+VPP*DDY3)*(ESN1+ESN2+ESN3)

C...  DENSITY TERMS
c     &        -VIDBCPDXPP3*DDX3-VIDBCPDYPP3*DDY3

C     3D.3D Velocity dispersion
         if (C3D) then
           QTEMA3=QTEMA3-IFNLCT*(DUU1N1*DXX13+DUU1N2*DXX23+DUU1N3*DXX33
     &           +DUV1N1*DXY31+DUV1N2*DXY32+DUV1N3*DXY33
     &           +DUV1N1*DXY13+DUV1N2*DXY23+DUV1N3*DXY33
     &           +DVV1N1*DYY13+DVV1N2*DYY23+DVV1N3*DYY33)
           endif

C     LINES TO RUN ON A VECTOR COMPUTER
#ifdef CVEC
         QTEMA(IE,1)=QTEMA1*NCELE
         QTEMA(IE,2)=QTEMA2*NCELE
         QTEMA(IE,3)=QTEMA3*NCELE
#endif

C     LINES TO RUN ON A SCALAR COMPUTER.
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QW
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS
#ifdef CSCA
         QW(NM1)=QW(NM1)+QTEMA1*NCELE
         QW(NM2)=QW(NM2)+QTEMA2*NCELE
         QW(NM3)=QW(NM3)+QTEMA3*NCELE
#endif

 1037 CONTINUE

C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QW
C     ON A VECTOR COMPUTER USING THE TEMPORARY VECTORS
#ifdef CVEC
      DO IE=1,NE
         NM1=NM(IE,1)
         NM2=NM(IE,2)
         NM3=NM(IE,3)
         QW(NM1)=QW(NM1)+QTEMA(IE,1)
         QW(NM2)=QW(NM2)+QTEMA(IE,2)
         QW(NM3)=QW(NM3)+QTEMA(IE,3)
      END DO
#endif

C...  
C...  SAVE THE ELEVATION AT THE PAST TIME STEP INTO ETA1 AND ZERO ETA2
C...  
      DO I=1,NP
         ETA1(I)=ETA2(I)
         ETA2(I)=0.0d0
      END DO

C...  AT ELEVATION BOUNDARY CONDITION NODES DETERMINE ELEVATION AT NEXT
C...  TIME STEP
C...  
C...  FOR PERIODIC ELEVATION BOUNDARY CONDITION

      DO J=1,NBFR
         IF(PER(J).EQ.0.) THEN
            NCYC=0.
         ELSE
            NCYC=INT(timeh/PER(J))
         ENDIF
         ARGJ=AMIG(J)*(timeh-NCYC*PER(J))+FACE(J)
         RFF=FF(J)*RAMP
         DO I=1,NETA
            ARG=ARGJ-EFA(J,I)
            NBDI=NBD(I)
            ETA2(NBDI)=ETA2(NBDI)+EMO(J,I)*RFF*COS(ARG)
         END DO
      END DO

C...  FOR APERIODIC ELEVATION BOUNDARY CONDITION

c......BDE
c  Set to accept -NBFR as -ETIMINC, indicating MCELServer as SSH source
c......BDE
      IF((NBFR.LE.0).AND.(NOPE.GT.0)) THEN
         IF(TIME.GT.ETIME2) THEN
            ETIME1=ETIME2
            ETIME2=ETIME1+ETIMINC
            IF(NBFR.LT.0) THEN
              ESBIN1=ESBIN2
	      CALL READ_MCEL_SSH(ETIME2,ESBIN2,1)
	    ELSE
              DO J=1,NETA
        	 ESBIN1(J)=ESBIN2(J)
        	 READ(19,*) ESBIN2(J)
              END DO
            ENDIF
         ENDIF
         ETRATIO=(TIME-ETIME1)/ETIMINC
         DO I=1,NETA
            NBDI=NBD(I)
            ETA2(NBDI)=RAMP*(ESBIN1(I)+ETRATIO*(ESBIN2(I)-ESBIN1(I)))
         END DO
      ENDIF


C...  IMPOSE NORMAL FLOW, RADIATION OR GRADIENT BOUNDARY CONDITIONS
C...  ALONG FLOW BOUNDARY TO LOAD VECTOR QW(I)

C...  Note 1, these values all must be multiplied by 2 since all
C...  elemental coefficients have been

C...  Note 2, Boundary conditions using specified fluxes (LBCODEI < 29)
C...  assume that QN is positive into the domain.  QFORCEJ has a -1
C...  built in and the terms are not explicitly negated. Boundary
C...  conditions using computed fluxes (LBCODEI 30, 40) compute a normal
C...  flux that  is positive out of the domain.  Therefore, to match
C...  the formulation these terms must be explicitly multiplied by -1.

C...Note 3, Eta1 is the latest computed elevation (it was updated above).

      IF((NFLUXF.EQ.1).OR.(NFLUXB.EQ.1).OR.(NFLUXIB.EQ.1)
     &     .OR.(NFLUXGBC.EQ.1).OR.(NFLUXRBC.EQ.1)) THEN 
         NBDJ=NBV(1)
         IF(LBCODEI(1).LE.29) QFORCEJ=(QN2(1)-QN0(1))/DT2 + 
     &        Tau0VAR(NBDJ)*QN1(1)

         IF(LBCODEI(1).EQ.30) THEN
            HH1=DP(NBDJ)+IFNLFA*ETA1(NBDJ)
            CELERITY=SQRT(G*HH1)
            QFORCEJ=-CELERITY*ETAS(NBDJ)/DT - Tau0VAR(NBDJ)*QN1(1)
            ENDIF

         IF(LBCODEI(1).EQ.32) THEN 
            HH1=DP(NBDJ)+IFNLFA*ETA1(NBDJ)
            CELERITY=SQRT(G*HH1)
            QFORCEJ=(QN1(1)-QN0(1))/DT
     &           -CELERITY*(ETAS(NBDJ)-(EN1(1)-EN0(1)))/DT
     &           +TAU0VAR(NBDJ)*(QN1(1)-CELERITY*(ETA1(NBDJ)-EN1(1)))
            ENDIF

         IF((LBCODEI(1).EQ.40).OR.(LBCODEI(1).EQ.41)) QFORCEJ=
     &        -(QN1(1)-QN0(1))/DT - TAU0VAR(NBDJ)*(QN1(1)+QN0(1))/2.d0

         DO J=2,NVEL
            NBDI=NBDJ
            NBDJ=NBV(J)
            QFORCEI=QFORCEJ

            IF(LBCODEI(J).LE.29) QFORCEJ=(QN2(J)-QN0(J))/DT2+
     &           Tau0VAR(NBDJ)*QN1(J)

            IF(LBCODEI(J).EQ.30) THEN
               HH1=DP(NBDJ)+IFNLFA*ETA1(NBDJ)
               CELERITY=SQRT(G*HH1)
               QFORCEJ=-CELERITY*ETAS(NBDJ)/DT - Tau0VAR(NBDJ)*QN1(J)
               ENDIF

            IF(LBCODEI(J).EQ.32) THEN 
               HH1=DP(NBDJ)+IFNLFA*ETA1(NBDJ)
               CELERITY=SQRT(G*HH1)
               QFORCEJ=(QN1(J)-QN0(J))/DT
     &              -CELERITY*(ETAS(NBDJ)-(EN1(J)-EN0(J)))/DT
     &              +TAU0VAR(NBDJ)*(QN1(J)-CELERITY*(ETA1(NBDJ)-EN1(J)))
               ENDIF

            IF((LBCODEI(J).EQ.40).OR.(LBCODEI(J).EQ.41)) QFORCEJ=
     &        -(QN1(J)-QN0(J))/DT - TAU0VAR(NBDJ)*(QN1(J)+QN0(J))/2.d0

            NCI=NODECODE(NBDI)
            NCJ=NODECODE(NBDJ)
            NCBND=NCI*NCJ
            BNDLEN2O3NC=NCBND*BNDLEN2O3(J-1)
            QW(NBDI)=QW(NBDI) + BNDLEN2O3NC*(QFORCEI+QFORCEJ/2.D0)
            QW(NBDJ)=QW(NBDJ) + BNDLEN2O3NC*(QFORCEJ+QFORCEI/2.D0)
            END DO
        ENDIF

C...
C...  IMPOSE ELEVATION BOUNDARY CONDITIONS TO LOAD VECTOR QW(I) NOTE; EP
C...  IS THE RMS OF ALL THE DIAGONAL MEMBERS IN THE GWCE.  IT IS USED TO
C...  SCALE THE DIAGONAL ELEMENT FOR THE ELEVATION SPECIFIED BOUNDARY
C...  NODES AND THEREFORE MUST ALSO BE USED TO SCALE THE RHS OF THE
C...  EQUATIONS
C...  
      DO I=1,NETA
         NBDI=NBD(I)
         ETAS(NBDI)=ETA2(NBDI)-ETA1(NBDI)
         QW(NBDI)=ETAS(NBDI)*NODECODE(NBDI)*EP
         DO J=2,NNEIGH(NBDI)
            QW(NEITAB(NBDI,J))=QW(NEITAB(NBDI,J))
     &           -ETAS(NBDI)*OBCCOEF(I,J-1)
         END DO
      END DO

C...  
C...  SOLVE GWCE FOR ELEVATION AT NEW TIME LEVEL
C...  

C...  UPDATE LOAD VECTOR INITIAL GUESS and DIAGONAL FOR GWCE SOLVE

#ifdef CMPI
C...UPDATE LOAD VECTOR INITIAL GUESS and DIAGONAL FOR GWCE SOLVE
      CALL UPDATER(QW,COEF(1,1),DUMY1,2)
#endif

C...  JCG ITERATIVE MATRIX SOLVER
      IPARM(1)=ITMAX
      CALL JCG(NP,MNP,MNEI,NEITAB,COEF,QW,ETAS,
     &     IWKSP,NW,WKSP,IPARM,RPARM,IER)

      NUMITR=IPARM(1)
      DO I=1,NP
         ETA2(I)=NODECODE(I)*ETAS(I)+ETA1(I) !COMPUTE NEW ELEVATIONS
      END DO
     
C     UPDATE ELEVATIONS

#ifdef CMPI
      CALL UPDATER(ETA2,DUMY1,DUMY2,1)
#endif


CWET...
CWET...THE FOLLOWING LINES ARE FOR WETTING AND DRYING
CWET...
CWET...NOTE:NODEREP is the number of time steps since a node last changed its
CWET...              wet/dry state
CWET...NOTE:NNODECODE is a working variable that can change more than once
CWET...               during a time step 
CWET...     NNODECODE = 0 for a dry node
CWET...     NNODECODE = 1 for a wet node
CWET...     NODECODE  - is a more static version of NNODECODE that is reconciled
CWET...                 once and for all at the end time step
CWET...
CWET...
CWET...        (   DRYING CRITERIA   )
CWET...
CWET...A node should be dry under two conditions.
CWET...D1.) If the total water depth falls below H0. This is overridden and a
CWET........node is not allowed to dry if it has changed state within the previous
CWET........NODEWETMIN timesteps.
CWET .......Note: if the total water depth falls below H0/10, the surface elevation
CWET........is lifted up so that the total water depth = H0/10.
CWET......
CWET...D2.) If the node is connected to only nonfunctioning (dry) elements.  In
CWET........this case the node is dried due to becoming landlocked.
CWET........Note: this criteria is applied after all other wetting and drying criteria
CWET...
CWET...
CWET...        (   WETTING CRITERIA   )
CWET...
CWET...A node should be wet under two conditions.
CWET...W1.) If 2 nodes on an element are wet and one is dry, wet the dry node 
CWET........if the water level at one of the wet nodes is greater than the 
CWET........water level at the dry node and the steady state velocity that 
CWET........would result from a balance between the water level gradient and 
CWET........bottom friction would yield a velocity > VELMIN.   This is 
CWET........overridden and a node is not allowed to wet if it has changed state
CWET........within the previous NODEDRYMIN timesteps.
CWET...
CWET...W2.) If an element has a node lying on an internal barrier boundary or 
CWET......specified discharge boundary that is actively discharging flow into the
CWET......domain at that node, all nodes in this element must stay wet. 
CWET...
CWET...
CWET...        (  VELOCITY BOUNDARY CONDITION  )
CWET...
CWET...Either a natural or essential boundary condition can be used as a velocity 
CWET...boundary condition in the momentum equation solution along a wet/dry boudary
CWET...To use a natural boundary condition, do nothing along the wet/dry interface.
CWET...To use an essential, no velocity boundary condition, identify the nodes along
CWET...the wet/dry interface and zero out the velocity at the nodes.  Interface nodes
CWET...can easily be identified by comparing the number of active elements a node is
CWET...connected to (MJU) to the total number of elements a node is connected to (NODELE).
CWET...If MJU < NODELE for any node, it must lie along the wet/dry interface.  See
CWET...further comments at the end of the momentum equation solution section.
CWET...
CWET...WET/DRY - PART 1 - DRYING CRITERIA D1
CWET...

      IF(NOLIFA.EQ.2) THEN      !  this goes on until end of part 4
C     
         DO I=1,NP
            NODEREP(I)=NODEREP(I)+1
            NIBCNT(I) = 0   
         ENDDO

         ! Drying Criteria D1: this depends on NODECODE and updates NODECODE
         HABSMIN=0.8D0*H0
         DO I=1,NP
            IF(NODECODE(I).EQ.1) THEN
               HTOT=DP(I)+ETA2(I)
               IF(HTOT.LE.H0) THEN
                  IF(HTOT.LT.HABSMIN) ETA2(I)=HABSMIN-DP(I)
                  IF(NODEREP(I).GT.NODEWETMIN) THEN
                     NNODECODE(I)=0
                     NODECODE(I)=0
                     NODEREP(I)=0
                     NCCHANGE=1 !NCCHARGE=0 set near the beginning of the time loop
c     vjp            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9881) I
 9881                FORMAT(' !!! NODE ',I6,' DRIED (HTOT<H0)')
                  ELSE
c     vjp            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9882) I
 9882                FORMAT(
     &                    ' !!! NODE ',I6,' WAS PREVENTED FROM DRYING ',
     &                    '(HTOT<H0) BECAUSE NODEREP<NODEWETMIN') 
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
  
CWET...
CWET...END WET/DRY SECTION - PART 1
CWET...

CWET...
CWET...WET/DRY SECTION PART 2 - WETTING LOOPS W1 AND W2
CWET...
         DO I=1,NE
            NM1=NM(I,1)
            NM2=NM(I,2)
            NM3=NM(I,3)
            
C     WET...Wetting Criteria W1: This depends on changes that occurred in D1

            NCTOT=NODECODE(NM1)+NODECODE(NM2)+NODECODE(NM3)
            IF(NCTOT.EQ.2) THEN
               IF((NODECODE(NM1).EQ.1).AND.(NODECODE(NM2).EQ.1)) THEN
                  NM123=NM1
                  if(eta2(NM2).gt.eta2(NM1)) NM123=NM2
              deldist=sqrt((y(NM3)-y(NM123))**2+(x(NM3)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM3)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
              tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     &                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM3).GT.NODEDRYMIN) THEN
                        NNODECODE(NM3)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     &                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     &                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM3
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM3
                     ENDIF
                  endif  
              ELSEIF((NODECODE(NM2).EQ.1).AND.(NODECODE(NM3).EQ.1)) THEN
                  NM123=NM2
                  if(eta2(NM3).gt.eta2(NM2)) NM123=NM3
                 deldist=sqrt((y(NM1)-y(NM123))**2+(x(NM1)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM1)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
                 tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     &                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0          
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM1).GT.NODEDRYMIN) THEN
                        NNODECODE(NM1)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     &                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     &                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM1
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM1
                     ENDIF
                  endif 
              ELSEIF((NODECODE(NM3).EQ.1).AND.(NODECODE(NM1).EQ.1)) THEN
                  NM123=NM3
                  if(eta2(NM1).gt.eta2(NM3)) NM123=NM1
                 deldist=sqrt((y(NM2)-y(NM123))**2+(x(NM2)-x(NM123))**2)
                  deleta=eta2(NM123)-eta2(NM2)
                  hh1=ifnlfa*eta2(NM123)+dp(NM123)
                 tkwet=fric(NM123)*(iflinbf+(velmin/hh1)*(ifnlbf+ifhybf*
     &                 (1+(HBREAK/HH1)**FTHETA)**(FGAMMA/FTHETA)))
                  if(tkwet.lt.0.0001d0) tkwet=0.0001d0
                  vel=g*(deleta/deldist)/tkwet
                  if(vel.gt.velmin) then
                     IF(NODEREP(NM2).GT.NODEDRYMIN) THEN
                        NNODECODE(NM2)=1
                        TK(NM123)=fric(NM123)*(iflinbf+(vel/hh1)*
     &                       (ifnlbf+ifhybf*(1+(HBREAK/HH1)**FTHETA)**
     &                       (FGAMMA/FTHETA)))
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9884) NM2
                     ELSE
c     vjp              IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9885) NM2
                     ENDIF
                  endif  
               ENDIF
 9884          FORMAT(' !!! NODE ',I6,' WETTED (VEL>VELMIN)')
 9885          FORMAT(' !!! NODE ',I6,' WAS PREVENTED FROM WETTING ',
     &              '(VEL>VELMIN) BECAUSE NODEREP<NODEDRYMIN') 
            ENDIF

C     WET...Wetting Criteria W2a

            NBNCTOT=NIBNODECODE(NM1)+NIBNODECODE(NM2)+NIBNODECODE(NM3)
            NIBCNT(NM1) = NIBCNT(NM1) + nbnctot
            NIBCNT(NM2) = NIBCNT(NM2) + nbnctot
            NIBCNT(NM3) = NIBCNT(NM3) + nbnctot

         ENDDO

C     WET...Wetting Criteria W2b

         DO I=1,NP
            IF(NIBCNT(I).GT.0) THEN
               IF(NNODECODE(I).EQ.0) THEN
                  NNODECODE(I)=1
c     vjp          IF((NSCREEN.EQ.1).AND.(MYPROC.EQ.0)) WRITE(*,9886) I
 9886            FORMAT(' !!! NODE ',I6,' WAS FORCED TO BE WET BECAUSE',
     &                 ' OF OVERFLOW BARRIER DISCHARGE') 
               ENDIF
            ENDIF
         ENDDO

C     Use Message-Passing to update nnodecode at ghost nodes
#ifdef CMPI
         CALL UPDATEI(NNODECODE,IDUMY,1)
#endif

CWET...
CWET...END WET/DRY SECTION - PART 2
CWET...


CWET...  
CWET...WET/DRY SECTION PART 3 - DRYING LOOP D2 
CWET...Update number of active elements (MJU) connected to a node.  
CWET...If this is zero, it indicates a landlocked node that should be dried.
CWET...This depends on NNODECODE which varies during the time step
CWET...
         DO I=1,NP
            MJU(I)=0
         ENDDO
         DO I=1,NE
            NM1=NM(I,1)
            NM2=NM(I,2)
            NM3=NM(I,3)
            NC1=NNODECODE(NM1)
            NC2=NNODECODE(NM2)
            NC3=NNODECODE(NM3)
            NCELE=NC1*NC2*NC3
            MJU(NM1)=MJU(NM1)+NCELE
            MJU(NM2)=MJU(NM2)+NCELE
            MJU(NM3)=MJU(NM3)+NCELE
         ENDDO
         DO I=1,NP
            IF((NNODECODE(I).EQ.1).AND.(MJU(I).EQ.0)) THEN
               NNODECODE(I)=0
c     vjp        IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) WRITE(*,9883) I
 9883          FORMAT(' !!! NODE ',I6,' DRIED (LANDLOCKING)')
            ENDIF
            IF(MJU(I).EQ.0) MJU(I)=1 !Because MJU is also used to solve Mom Eq.
         ENDDO
C     WET...
C     WET...END WET/DRY SECTION - PART 3
C     WET...

C     Use Message-Passing to update nnodecode at ghost nodes
#ifdef CMPI
         CALL UPDATEI(NNODECODE,IDUMY,1)
#endif


CWET...  
CWET...WET/DRY SECTION - PART 4 - RESET NODECODE USING NNODECODE 
CWET...Check to see if any wetting occurred & update NODEREP & NODECODE 
CWET...Note, NCCHANGE=0 set near the beginning of the time step loop 
CWET...
         DO I=1,NP
            IF(NNODECODE(I).NE.NODECODE(I)) THEN
               NODECODE(I)=NNODECODE(I)
               NODEREP(I)=0
               NCCHANGE=1             
            ENDIF
         ENDDO

CWET...
CWET...END WET/DRY SECTION - PART 4
CWET...

      ENDIF                     !  This is started in Part 1 of CWET


C...  
C...  2DDI MOMENTUM EQUATION SOLUTION
C...  
      IF (C2DDI) THEN    
C
C...  UPDATE LOAD VECTOR QU(I) AND QV(I) NOTE: QU, QV AND AUV ARE ZEROED
C...  OUT AT THE TOP OF THE TIME STEPPING LOOP.

C.....FIRST TREAT THE NON-LUMPED PART OF THE EQUATIONS.

         DO 9999 IE=1,NE

C...  SET NODAL VALUES FOR EACH ELEMENT

            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            NC1=NODECODE(NM1)
            NC2=NODECODE(NM2)
            NC3=NODECODE(NM3)
            NCELE=NC1*NC2*NC3
            U1N1=UU1(NM1)
            U1N2=UU1(NM2)
            U1N3=UU1(NM3)
            V1N1=VV1(NM1)
            V1N2=VV1(NM2)
            V1N3=VV1(NM3)
            ESN1=ETAS(NM1)
            ESN2=ETAS(NM2)
            ESN3=ETAS(NM3)
            HH1N1=DP(NM1)+IFNLFA*ETA1(NM1)
            HH1N2=DP(NM2)+IFNLFA*ETA1(NM2)
            HH1N3=DP(NM3)+IFNLFA*ETA1(NM3)
            SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0

            AREAIE=AREAS(IE)
            FDX1=(Y(NM2)-Y(NM3))*SFACPP !b1
            FDX2=(Y(NM3)-Y(NM1))*SFACPP !b2
            FDX3=(Y(NM1)-Y(NM2))*SFACPP !b3
            FDY1=X(NM3)-X(NM2)  !a1
            FDY2=X(NM1)-X(NM3)  !a2
            FDY3=X(NM2)-X(NM1)  !a3
            FDX1OA=FDX1/AREAIE  !dphi1/dx
            FDY1OA=FDY1/AREAIE  !dphi1/dy
            FDX2OA=FDX2/AREAIE  !dphi2/dx
            FDY2OA=FDY2/AREAIE  !dphi2/dy
            FDX3OA=FDX3/AREAIE  !dphi3/dx
            FDY3OA=FDY3/AREAIE  !dphi3/dy
            
            DDX1=FDX1/3.d0      !<2*(dphi1/dx)*phij> j=1,2,3
            DDY1=FDY1/3.d0      !<2*(dphi1/dy)*phij> j=1,2,3
            DXX11=FDX1OA*FDX1   !<2*(dphi1/dx)*(dphi1/dx)>
            DYY11=FDY1OA*FDY1   !<2*(dphi1/dy)*(dphi1/dy)>
            DXXYY11=DXX11+DYY11
            DXX12=FDX1OA*FDX2   !<2*(dphi1/dx)*(dphi2/dx)>
            DYY12=FDY1OA*FDY2   !<2*(dphi1/dy)*(dphi2/dy)>
            DXXYY12=DXX12+DYY12
            DXX13=FDX1OA*FDX3   !<2*(dphi1/dx)*(dphi3/dx)>
            DYY13=FDY1OA*FDY3   !<2*(dphi1/dy)*(dphi3/dy)>
            DXXYY13=DXX13+DYY13

            DDX2=FDX2/3.d0      !<2*(dphi2/dx)*phij> j=1,2,3
            DDY2=FDY2/3.d0      !<2*(dphi2/dy)*phij> j=1,2,3
            DXXYY21=DXXYY12
            DXX22=FDX2OA*FDX2   !<2*(dphi2/dx)*(dphi2/dx)>
            DYY22=FDY2OA*FDY2   !<2*(dphi2/dy)*(dphi2/dy)>
            DXXYY22=DXX22+DYY22
            DXX23=FDX2OA*FDX3   !<2*(dphi2/dx)*(dphi3/dx)>
            DYY23=FDY2OA*FDY3   !<2*(dphi2/dy)*(dphi3/dy)>
            DXXYY23=DXX23+DYY23

            DDX3=FDX3/3.d0      !<2*(dphi3/dx)*phij> j=1,2,3
            DDY3=FDY3/3.d0      !<2*(dphi3/dy)*phij> j=1,2,3
            DXXYY31=DXXYY13
            DXXYY32=DXXYY23
            DXX33=FDX3OA*FDX3   !<2*(dphi3/dx)*(dphi3/dx)>
            DYY33=FDY3OA*FDY3   !<2*(dphi3/dy)*(dphi3/dy)>
            DXXYY33=DXX33+DYY33

            FIIN=AREAIE/3.D0    !2*<phi*phj> lumped

C...  ACCUMULATE NODAL VALUES FOR CERTAIN ELEMENTAL COEFFICIENTS

            VCOEF3N1=ETA1(NM1)+ETA2(NM1)
            VCOEF3N2=ETA1(NM2)+ETA2(NM2)
            VCOEF3N3=ETA1(NM3)+ETA2(NM3)

C......If using wind

            IF(NWS.NE.0) THEN
               VCOEF3N1=VCOEF3N1+PR1(NM1)+PR2(NM1)
               VCOEF3N2=VCOEF3N2+PR1(NM2)+PR2(NM2)
               VCOEF3N3=VCOEF3N3+PR1(NM3)+PR2(NM3)
            ENDIF

C     TIP...If using tidal potential terms

            if (CTIP) then
               VCOEF3N1=VCOEF3N1-TIP1(NM1)-TIP2(NM1)
               VCOEF3N2=VCOEF3N2-TIP1(NM2)-TIP2(NM2)
               VCOEF3N3=VCOEF3N3-TIP1(NM3)-TIP2(NM3)
            endif

            VCOEF3N1=VCOEF3N1*GDTO2
            VCOEF3N2=VCOEF3N2*GDTO2
            VCOEF3N3=VCOEF3N3*GDTO2

C...  COMPUTE ELEMENT AVERAGES QUANTITIES

            UPPDT=SADVDTO3*(U1N1+U1N2+U1N3)
            VPPDT=SADVDTO3*(V1N1+V1N2+V1N3)
            UPPDTDDX1=UPPDT*DDX1
            UPPDTDDX2=UPPDT*DDX2
            UPPDTDDX3=UPPDT*DDX3
            VPPDTDDY1=VPPDT*DDY1
            VPPDTDDY2=VPPDT*DDY2
            VPPDTDDY3=VPPDT*DDY3
            EVMPPDT=((EVM(NM1)+EVM(NM2)+EVM(NM3))/3.d0)*DT

C...  ASSEMBLE PARTIAL PRODUCTS

            VCOEF3X=VCOEF3N1*DDX1+VCOEF3N2*DDX2+VCOEF3N3*DDX3
            VCOEF3Y=VCOEF3N1*DDY1+VCOEF3N2*DDY2+VCOEF3N3*DDY3
            ADVECX=(UPPDTDDX1+VPPDTDDY1)*U1N1
     &           +(UPPDTDDX2+VPPDTDDY2)*U1N2
     &           +(UPPDTDDX3+VPPDTDDY3)*U1N3
            ADVECY=(UPPDTDDX1+VPPDTDDY1)*V1N1
     &           +(UPPDTDDX2+VPPDTDDY2)*V1N2
     &           +(UPPDTDDX3+VPPDTDDY3)*V1N3
C
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO
C...  QTEMA
C.... VECTOR FOR NODE NM1

            QTEMA1=NCELE*(               
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3X
C...  LATERAL VISCOUS TERMS
     &           -EVMPPDT*(DXXYY11*U1N1+DXXYY12*U1N2+DXXYY13*U1N3)
C...  ADVECTIVE TERMS
     &           -ADVECX
C...  COMMON DIVISION OPERATION
     &           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO QTEMA
C.... VECTOR FOR NODE NM2
C...  
            QTEMA2=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3X
C...  LATERAL VISCOUS TERMS]
     &           -EVMPPDT*(DXXYY21*U1N1+DXXYY22*U1N2+DXXYY23*U1N3)
C...  ADVECTIVE TERMS
     &           -ADVECX
C...  COMMON DIVISION OPERATION
     &           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR X-MOMENTUM EQUATION INTO QTEMA
C.... VECTOR FOR NODE NM3
C...  
            QTEMA3=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3X
C...  LATERAL VISCOUS TERMS
     &           -EVMPPDT*(DXXYY31*U1N1+DXXYY32*U1N2+DXXYY33*U1N3)
C...  ADVECTIVE TERMS
     &           -ADVECX
C...  COMMON DIVISION OPERATION
     &           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM1
C...  
            QTEMB1=NCELE*( 
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     &           -EVMPPDT*(DXXYY11*V1N1+DXXYY12*V1N2+DXXYY13*V1N3)
C...  ADVECTIVE TERMS
     &           -ADVECY
C...  COMMON DIVISION OPERATION
     &           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM2
C...  
            QTEMB2=NCELE*(  
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     &           -EVMPPDT*(DXXYY21*V1N1+DXXYY22*V1N2+DXXYY23*V1N3)
C...  ADVECTIVE TERMS
     &           -ADVECY
C...  COMMON DIVISION OPERATION
     &           )/FIIN
C...  
C...  LOAD NON-LUMPED ELEMENTAL COMPONENTS FOR Y-MOMENTUM EQUATION INTO QTEMB
C.... VECTOR FOR NODE NM3
C...  
            QTEMB3=NCELE*(   
C...  SURFACE GRADIENT, ATMOSPHERIC PRESSURE AND TIDAL POTENTIAL TERMS
     &           -VCOEF3Y
C...  LATERAL VISCOUS TERMS
     &           -EVMPPDT*(DXXYY31*V1N1+DXXYY32*V1N2+DXXYY33*V1N3)
C...  ADVECTIVE TERMS
     &           -ADVECY
C...  COMMON DIVISION OPERATION
     &           )/FIIN

C     LINES TO RUN ON A VECTOR COMPUTER
#ifdef CVEC
            QTEMA(IE,1)=QTEMA1
            QTEMA(IE,2)=QTEMA2
            QTEMA(IE,3)=QTEMA3
            QTEMB(IE,1)=QTEMB1
            QTEMB(IE,2)=QTEMB2
            QTEMB(IE,3)=QTEMB3
#endif

C     LINES TO RUN ON A SCALAR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QU, QV AND QUV
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS
#ifdef CSCA
            QU(NM1)=QU(NM1)+QTEMA1
            QU(NM2)=QU(NM2)+QTEMA2
            QU(NM3)=QU(NM3)+QTEMA3
            QV(NM1)=QV(NM1)+QTEMB1
            QV(NM2)=QV(NM2)+QTEMB2
            QV(NM3)=QV(NM3)+QTEMB3
#endif

 9999    CONTINUE
         
C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QU, QV AND AUV
#ifdef CVEC
         DO IE=1,NE
            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            QU(NM1)=QU(NM1)+QTEMA(IE,1)
            QU(NM2)=QU(NM2)+QTEMA(IE,2)
            QU(NM3)=QU(NM3)+QTEMA(IE,3)
            QV(NM1)=QV(NM1)+QTEMB(IE,1)
            QV(NM2)=QV(NM2)+QTEMB(IE,2)
            QV(NM3)=QV(NM3)+QTEMB(IE,3)
         END DO
#endif

C...  UPDATE MOMENTUM EQUATION LHS COEFFICIENTS AND LOAD VECTORS AT EACH
C...  NODE BY DIVIDING BY NUMBER OF ELEMENTS THE NODE IS ASSOCIATED WITH
C...  AND ADDING IN LUMPED TERMS AND BOTTOM FRICTION AND TAKING ACCOUNT
C...  OF THE BOUNDARY CONDITION

         WSX=0.D0
         WSY=0.D0
         DO I=1,NP
            NCI=NNODECODE(I)
            QU(I)=QU(I)/MJU(I)
            QV(I)=QV(I)/MJU(I)
            HH1=DP(I)+IFNLFA*ETA1(I)
            HH2=DP(I)+IFNLFA*ETA2(I)
            IF((NWS.NE.0).OR.(NRS.NE.0)) THEN
               WSX=DTO2*IFWIND*(WSX1(I)/HH1+WSX2(I)/HH2)
               WSY=DTO2*IFWIND*(WSY1(I)/HH1+WSY2(I)/HH2)
            ENDIF
            VCOEF1=DTO2*TK(I)
            VCOEF2=DTO2*CORIF(I)
C           VIDBCPDX=DT*VIDBCPDX1(I)/HH1
C           VIDBCPDY=DT*VIDBCPDY1(I)/HH1
               
            QU(I)=NCI*(QU(I)+WSX+(1.D0-VCOEF1)*UU1(I)+VCOEF2*VV1(I))           
            QV(I)=NCI*(QV(I)+WSY+(1.D0-VCOEF1)*VV1(I)-VCOEF2*UU1(I))            
C           QU(I)=NCI*(QU(I)+WSX+(1.D0-VCOEF1)*UU1(I)+VCOEF2*VV1(I)
C     &           -VIDBCPDX)
C           QV(I)=NCI*(QV(I)+WSY+(1.D0-VCOEF1)*VV1(I)-VCOEF2*UU1(I)
C     &           -VIDBCPDY)

            AUV11(I)=1.D0+VCOEF1*NCI
            AUV12(I)=-VCOEF2*NCI
         END DO

C...  Modify the momentum equations to impose velocity boundary
C...  conditions In each case the equations are manipulated to
C...  maintain the LHS matrix structure of AUV11=AUV22;
C...  AUV12=-AUV21)

         DO J=1,NVELME
            I=ME2GW(J)
            NBDI=NBV(I)
            HH2=DP(NBDI)+IFNLFA*ETA2(NBDI)
            NCI=NODECODE(NBDI)

C      Specified essential normal flow and free tangential slip

            IF((LBCODEI(I).GE.0).AND.(LBCODEI(I).LE.9)) THEN 
               VELNORM=-QN2(I)/HH2 
               QU(NBDI)=(SIII(I)*QU(NBDI)-CSII(I)*QV(NBDI)
     &              -VELNORM*AUV12(NBDI))*NCI !Tangential Eqn RHS
               QV(NBDI)=VELNORM*AUV11(NBDI)*NCI !Normal Eqn RHS
               AUV12(NBDI)=-CSII(I)*AUV11(NBDI)
               AUV11(NBDI)=SIII(I)*AUV11(NBDI)
            ENDIF

C     Specified essential normal flow and no tangential slip

            IF((LBCODEI(I).GE.10).AND.(LBCODEI(I).LE.19)) THEN
               VELNORM=-QN2(I)/HH2
               VELTAN=0.D0
               QU(NBDI)=VELTAN*NCI !Tangential Eqn RHS
               QV(NBDI)=VELNORM*NCI !Normal Eqn RHS
               AUV11(NBDI)=SIII(I)
               AUV12(NBDI)=-CSII(I)
            ENDIF

C     Zero normal velocity gradient using a Galerkin approximation to
C     the normal derivatives. Note: this is fully explicit and therefore
C     the velocity at the boundary is computed entirely from surrounding
C     velocities at the previous time step.

            IF(LBCODEI(I).EQ.41) THEN 
               NM1=NBDI
               ZNGRHS1=0.d0     !Zero Norm Grad of U Eqn
               ZNGRHS2=0.d0     !Zero Norm Grad of V Eqn
               ZNGLHS=0.d0
               NM2=NeiTab(NBDI,2) !operate on 1st neighbor
               NNFirst=NM2      !save these values until end
               DO N=3,NNeigh(NBDI) !operate on rest of neighbors
                  NM3=NM2       !shift previously computed values
                  NM2=NEITAB(NBDI,N) !select new neighbor to work on
                  SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0
                  NEle=NeiTabEle(NBDI,N-2) !element # defined by nodes NM1,NM2,NM3
                  NCEle=NCI*NodeCode(NM2)*NodeCode(NM3)
                  IF((NEle.NE.0).AND.(NCEle.NE.0)) THEN !if element is active, compute contribution
                     FDX1 = (Y(NM2)-Y(NM3))*SFACPP !b1
                     FDX2 = (Y(NM3)-Y(NM1))*SFACPP !b2
                     FDX3 = (Y(NM1)-Y(NM2))*SFACPP !b3
                     FDY1 = X(NM3)-X(NM2) !a1
                     FDY2 = X(NM1)-X(NM3) !a2
                     FDY3 = X(NM2)-X(NM1) !a3
               ZNGRHS1 = ZNGRHS1 - (CSII(I)*FDX2+SIII(I)*FDY2)*UU1(NM2)
     &                    - (CSII(I)*FDX3+SIII(I)*FDY3)*UU1(NM3)
               ZNGRHS2 = ZNGRHS2 - (CSII(I)*FDX2+SIII(I)*FDY2)*VV1(NM2)
     &                    - (CSII(I)*FDX3+SIII(I)*FDY3)*VV1(NM3)
                     ZNGLHS  = ZNGLHS  +  CSII(I)*FDX1+SIII(I)*FDY1
                  ENDIF
               END DO
               NM3=NM2          !wrap back to beginning to get final contribution
               NM2=NNFirst
               SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.d0
               NEle=NeiTabEle(NBDI,NNeigh(NBDI)-1)
               NCEle=NCI*NodeCode(NM2)*NodeCode(NM3)
               IF((NEle.NE.0).AND.(NCEle.NE.0)) THEN
                  FDX1 = (Y(NM2)-Y(NM3))*SFACPP !b1
                  FDX2 = (Y(NM3)-Y(NM1))*SFACPP !b2
                  FDX3 = (Y(NM1)-Y(NM2))*SFACPP !b3
                  FDY1 = X(NM3)-X(NM2) !a1
                  FDY2 = X(NM1)-X(NM3) !a2
                  FDY3 = X(NM2)-X(NM1) !a3
              ZNGRHS1 = ZNGRHS1 - (CSII(I)*FDX2+SIII(I)*FDY2)*UU1(NM2)
     &                 - (CSII(I)*FDX3+SIII(I)*FDY3)*UU1(NM3)
              ZNGRHS2 = ZNGRHS2 - (CSII(I)*FDX2+SIII(I)*FDY2)*VV1(NM2)
     &                 - (CSII(I)*FDX3+SIII(I)*FDY3)*VV1(NM3)
                  ZNGLHS  = ZNGLHS  +  CSII(I)*FDX1+SIII(I)*FDY1
               ENDIF
               IF(NCI.EQ.0) THEN
                  AUV11(NBDI)=1.d0
                  AUV12(NBDI)=0.d0
                  QU(NBDI)=0.d0
                  QV(NBDI)=0.d0
               ELSE
                  AUV11(NBDI)=1.d0
                  AUV12(NBDI)=0.d0
                  QU(NBDI)=ZNGRHS1/ZNGLHS
                  QV(NBDI)=ZNGRHS2/ZNGLHS
               ENDIF
            ENDIF
         ENDDO

C...
C...  SOLVE FOR VELOCITY AT NEW LEVEL  (K+1)
C...

C.....Note: This includes the comparison between MJU and NODELE to
C.....determine if the node is an interface node.  If MJU < NODELE the
C.....velocity can be zeroed out to obtain an essential zero velocity at
C.....interface nodes.

         DO I=1,NP
            AUV22=AUV11(I)
            AUV21=-AUV12(I)
            DDU=AUV11(I)*AUV22-AUV12(I)*AUV21
            UU2(I)=(QU(I)*AUV22-QV(I)*AUV12(I))/DDU
            VV2(I)=(QV(I)*AUV11(I)-QU(I)*AUV21)/DDU

c           IF(MJU(I).NE.NODELE(I)) THEN !uncomment for essential
c              UBAR2(I)=0.D0    !no slip and normal flux
c              VBAR2(I)=0.D0    !on wet/dry interface nodes
c           ENDIF                               
         END DO

C...
C...  Impose a zero normal velocity gradient based on interpolating the
C...  velocity at a fictitious point in the interior of the domain,
C...  normal to a specified boundary node and setting the boundary
C...  velocity equal to the interpolated value at the fictitious point.
C...  Provided the fictitious point does not lie in an element that
C...  contains a boundary point, this is an entirely implicit
C...  calculation.
C...
         IF(NFLUXGBC.EQ.1) THEN
            DO J=1,NVELME
               I=ME2GW(J)
               NBDI=NBV(I)
               IF(LBCODEI(I).EQ.40) THEN
                  NM1=NM(NEleZNG(I),1)
                  NM2=NM(NEleZNG(I),2)
                  NM3=NM(NEleZNG(I),3)
                  NC1=NODECODE(NM1)
                  NC2=NODECODE(NM2)
                  NC3=NODECODE(NM3)
                  NCEle=NC1*NC2*NC3
                  UU2(NBDI)=NCEle*(UU2(NM1)*ZNGIF1(I)+UU2(NM2)*ZNGIF2(I)
     &                 +UU2(NM3)*ZNGIF3(I))
                  VV2(NBDI)=NCEle*(VV2(NM1)*ZNGIF1(I)+VV2(NM2)*ZNGIF2(I)
     &                 +VV2(NM3)*ZNGIF3(I))
               ENDIF
            END DO
         ENDIF
         

C...  UPDATE VELOCITIES
#ifdef CMPI
         CALL UPDATER(UU2,VV2,DUMY1,2)
#endif
     
      ENDIF 
C...  
C     C2DDI....END OF 2DDI MOMENTUM EQUATION SOLUTION
C...  

C...  
C...  3DVS Momentum Equation Solution
C...
      IF (C3DVS) THEN

C... Load the vector QU(I) with barotropic pressure terms 
C...     including atmospheric pressure, water level and tidal potential
C...     averaged between time levels s and s+1, (time levels 1 and 2).

        DO I=1,NP
           QU(I)=ETA1(I)+ETA2(I)
           IF(NWS.NE.0) QU(I)=QU(I)+PR1(I)+PR2(I) !atmospheric pressure
           IF (CTIP) QU(I)=QU(I)-TIP1(I)-TIP2(I) !tidal potential
           QU(I)=G*QU(I)/2.d0
        ENDDO

C...  Solve for velocity at the new time level (K+1)

        CALL VSSOL(IT,TIME,DT)

      ENDIF
C...  
C...  End of 3DVS Momentum Equation Solution
C...  

C...  
C...  IF TRANSPORT IS INCLUDED SOLVE FOR THE CONCENTRATION
C...  NOTE: THE VARIABLE CH1(I) IS ACTUALLY C*H
C...  
      IF(IM.EQ.10) THEN

C.... COMPUTE SOURCE/SINK TERM AT THE NODES USING CLASSICAL COHESIVE
C.... SEDIMENT TRANSPORT RELATIONS

         rho0  = RHOWAT0        ! reference density of seawater [kg/m^3]
         WS = 0.0001d0          ! particle fall velocity [m/s]
         CBEDSTRD = 0.15d0      ! critical shear stress for deposition [N/m^2]
         CCRITD = 0.30d0        ! critical concentration for hindered settling [kg/m^3]
         ECONST = 0.00001d0     ! erosion rate constant [kg/m^2/sec]
         CBEDSTRE = 0.4d0       ! critical shear stress for erosion [N/m^2]

         DO I=1,NP
            UV1=SQRT(UU1(I)*UU1(I)+VV1(I)*VV1(I))
            HH1=DP(I)+IFNLFA*ETA1(I)
            BEDSTR=HH1*UV1*TK(I)*rho0 !in N/m^2
            C1=CH1(I)/HH1

C.....Calculate the deposition rate using Krone's (1962) formulation:
C.....dC/dt = -P*WSMOD*C/D     where
C.....WSMOD=WS          when C < Ccrit  and
C.....WSMOD=K*C**1.33   when C > Ccrit
C.....D is the average depth through which particles settle D = H/2,
C.....H is the water depth
C.....C is the depth-averaged sediment concentration,
C.....P is the sticking probability  P = (1-BEDSTR/CBEDSTRD),
C.....CBEDSTRD is the critical bottom stress above which no deposition occurs.
C.....It was assumed that the constant K could be backed out by setting
C.....WSMOD = WS when C = Ccrit.

            WSMOD=WS
            IF(C1.GT.CCRITD) WSMOD=WS*(C1/CCRITD)**1.33d0
            HSD=0.d0
            IF(BEDSTR.LT.CBEDSTRD) HSD=-(2.d0*WSMOD*C1)*
     &           (1.0d0-BEDSTR/CBEDSTRD)
            IF(HSD.GT.0.d0) HSD=0.d0

C.....Calculate the surface erosion rate for cohesive sediment using
C.....the Ariathurai et at. (1977) adaption of Partheniades' (1962) findings

            HSE=0.
            IF(BEDSTR.GT.CBEDSTRE) HSE=ECONST*(BEDSTR/CBEDSTRE-1.0)

C.....Determine the total source sink term

            SOURSIN(I)=HSD+HSE
         END DO

C.... UPDATE THE TRANSPORT EQUATION ELEMENT BY ELEMENT BY FORMING
C.... TEMPORARY VECTORS AND THEN ASSEMBLING.  NOTE: QB(I), QA(I) ARE
C.... ZEROED OUT AT THE TOP OF THE TIME STEPPING LOOP.  AGAIN THESE
C.... LOOPS HAVE BEEN UNROLLED TO OPTIMIZE VECTORIZATION

         DO 1057 IE=1,NE

C.....SET NODAL VALUES FOR EACH ELEMENT

            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            NC1=NODECODE(NM1)
            NC2=NODECODE(NM2)
            NC3=NODECODE(NM3)
            NCELE=NC1*NC2*NC3
            U1N1=UU1(NM1)
            U1N2=UU1(NM2)
            U1N3=UU1(NM3)
            V1N1=VV1(NM1)
            V1N2=VV1(NM2)
            V1N3=VV1(NM3)
            CH1N1=CH1(NM1)
            CH1N2=CH1(NM2)
            CH1N3=CH1(NM3)
            EVC1=EVC(NM1)
            EVC2=EVC(NM2)
            EVC3=EVC(NM3)
            SS1N1=SOURSIN(NM1)
            SS1N2=SOURSIN(NM2)
            SS1N3=SOURSIN(NM3)
            HH1N1=DP(NM1)+IFNLFA*ETA1(NM1)
            HH1N2=DP(NM2)+IFNLFA*ETA1(NM2)
            HH1N3=DP(NM3)+IFNLFA*ETA1(NM3)
            SFACPP=(SFAC(NM1)+SFAC(NM2)+SFAC(NM3))/3.

C.....COMPUTE ELEMENTAL MATRICIES

            AREAIE=AREAS(IE)    !2*element area
            FDX1=(Y(NM2)-Y(NM3))*SFACPP !b1
            FDX2=(Y(NM3)-Y(NM1))*SFACPP !b2
            FDX3=(Y(NM1)-Y(NM2))*SFACPP !b3
            FDY1=X(NM3)-X(NM2)  !a1
            FDY2=X(NM1)-X(NM3)  !a2
            FDY3=X(NM2)-X(NM1)  !a3
            FDX1OA=FDX1/AREAIE  !dphi1/dx
            FDY1OA=FDY1/AREAIE  !dphi1/dy
            FDX2OA=FDX2/AREAIE  !dphi2/dx
            FDY2OA=FDY2/AREAIE  !dphi2/dy
            FDX3OA=FDX3/AREAIE  !dphi3/dx
            FDY3OA=FDY3/AREAIE  !dphi3/dy

            DDX1=FDX1/3.        !<2*(dphi1/dx)*phij> j=1,2,3
            DDY1=FDY1/3.        !<2*(dphi1/dy)*phij> j=1,2,3
            DXX11=FDX1OA*FDX1   !<2*(dphi1/dx)*(dphi1/dx)>
            DYY11=FDY1OA*FDY1   !<2*(dphi1/dy)*(dphi1/dy)>
            DXXYY11=DXX11+DYY11
            DXX12=FDX1OA*FDX2   !<2*(dphi1/dx)*(dphi2/dx)>
            DYY12=FDY1OA*FDY2   !<2*(dphi1/dy)*(dphi2/dy)>
            DXXYY12=DXX12+DYY12
            DXX13=FDX1OA*FDX3   !<2*(dphi1/dx)*(dphi3/dx)>
            DYY13=FDY1OA*FDY3   !<2*(dphi1/dy)*(dphi3/dy)>
            DXXYY13=DXX13+DYY13

            DDX2=FDX2/3.        !<2*(dphi2/dx)*phij> j=1,2,3
            DDY2=FDY2/3.        !<2*(dphi2/dy)*phij> j=1,2,3
            DXX22=FDX2OA*FDX2   !<2*(dphi2/dx)*(dphi2/dx)>
            DYY22=FDY2OA*FDY2   !<2*(dphi2/dy)*(dphi2/dy)>
            DXXYY22=DXX22+DYY22
            DXX23=FDX2OA*FDX3   !<2*(dphi2/dx)*(dphi3/dx)>
            DYY23=FDY2OA*FDY3   !<2*(dphi2/dy)*(dphi3/dy)>
            DXXYY23=DXX23+DYY23

            DDX3=FDX3/3.        !<2*(dphi3/dx)*phij> j=1,2,3
            DDY3=FDY3/3.        !<2*(dphi3/dy)*phij> j=1,2,3
            DXX33=FDX3OA*FDX3   !<2*(dphi3/dx)*(dphi3/dx)>
            DYY33=FDY3OA*FDY3   !<2*(dphi3/dy)*(dphi3/dy)>
            DXXYY33=DXX33+DYY33

            LUMPT=1             !=1/0; LUMP/DO NOT LUMP THE TRANSPORT EQN
            FDDD=(1+LUMPT)*AREAIE/6.D0 !<2*(phii*phij) i=j>
            FDDOD=(1-LUMPT)*AREAIE/12.D0 !<2*(phii*phij) i<>j>
            FDDDODT=FDDD/DTDP
            FDDODODT=FDDOD/DTDP

C.....COMPUTE ELEMENT AVERAGES QUANTITIES

            UEA=(U1N1+U1N2+U1N3)/3.
            VEA=(V1N1+V1N2+V1N3)/3.
            HEA=(HH1N1+HH1N2+HH1N3)/3.
            EVCEA=(EVC1+EVC2+EVC3)/3.
            DHDX=HH1N1*FDX1OA+HH1N2*FDX2OA+HH1N3*FDX3OA
            DHDY=HH1N1*FDY1OA+HH1N2*FDY2OA+HH1N3*FDY3OA
            UPEA=UEA+DHDX*EVCEA/HEA
            VPEA=VEA+DHDY*EVCEA/HEA

C.....ASSEMBLE PARTIAL PRODUCT

            CHSUM=CH1N1+CH1N2+CH1N3

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA1 AND
C.....QTEMB1 VECTORS FOR NODE NM1

            QTEMB1=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     &           FDDDODT*CH1N1+FDDODODT*(CH1N2+CH1N3)
C......LATERAL SGS TERMS
     &           -EVCEA*(DXXYY11*CH1N1+DXXYY12*CH1N2+DXXYY13*CH1N3)
C......ADVECTIVE TERMS
     &           +(UPEA*DDX1+VPEA*DDY1)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     &           +FDDD*SS1N1+FDDOD*(SS1N2+SS1N3)
            QTEMA1=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     &           FDDDODT+2.*FDDODODT

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA2 AND
C.....QTEMB2 VECTOR FOR NODE NM2

            QTEMB2=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     &           FDDDODT*CH1N2+FDDODODT*(CH1N1+CH1N3)
C......LATERAL SGS TERMS
     &           -EVCEA*(DXXYY12*CH1N1+DXXYY22*CH1N2+DXXYY23*CH1N3)
C......ADVECTIVE TERMS
     &           +(UPEA*DDX2+VPEA*DDY2)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     &           +FDDD*SS1N2+FDDOD*(SS1N1+SS1N3)
            QTEMA2=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     &           FDDDODT+2.*FDDODODT

C.....LOAD ELEMENTAL COMPONENTS FOR TRANSPORT EQUATION INTO QTEMA3 AND
C.....QTEMB3 VECTOR FOR NODE NM3

            QTEMB3=             !LOAD VECTOR
C......TRANSIENT TERM (EITHER LUMPED OR CONSISTENT)
     &           FDDDODT*CH1N3+FDDODODT*(CH1N1+CH1N2)
C......LATERAL SGS TERMS
     &           -EVCEA*(DXXYY13*CH1N1+DXXYY23*CH1N2+DXXYY33*CH1N3)
C......ADVECTIVE TERMS
     &           +(UPEA*DDX3+VPEA*DDY3)*CHSUM
C......SOURCE SINK TERMS (EITHER LUMPED OR CONSISTENT)
     &           +FDDD*SS1N3+FDDOD*(SS1N1+SS1N2)
            QTEMA3=             !LHS VECTOR
C......TRANSIENT TERM (LUMPED)
     &           FDDDODT+2.*FDDODODT

C     VEC...LINES TO RUN ON A VECTOR COMPUTER
#ifdef CVEC
            QTEMB(IE,1)=QTEMB1*NCELE !LOAD VECTOR
            QTEMB(IE,2)=QTEMB2*NCELE !LOAD VECTOR
            QTEMB(IE,3)=QTEMB3*NCELE !LOAD VECTOR
            QTEMA(IE,1)=QTEMA1*NCELE !LUMPED LHS MATRIX
            QTEMA(IE,2)=QTEMA2*NCELE !LUMPED LHS MATRIX
            QTEMA(IE,3)=QTEMA3*NCELE !LUMPED LHS MATRIX
#endif

C     LINES TO RUN ON A SCALAR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QC AND QA
C     ON A SCALAR COMPUTER USING THE TEMPORARY VECTORS
#ifdef CSCA
            QB(NM1)=QB(NM1)+QTEMB1*NCELE !LOAD VECTOR
            QB(NM2)=QB(NM2)+QTEMB2*NCELE !LOAD VECTOR
            QB(NM3)=QB(NM3)+QTEMB3*NCELE !LOAD VECTOR
            QA(NM1)=QA(NM1)+QTEMA1*NCELE !LUMPED LHS MATRIX
            QA(NM2)=QA(NM2)+QTEMA2*NCELE !LUMPED LHS MATRIX
            QA(NM3)=QA(NM3)+QTEMA3*NCELE !LUMPED LHS MATRIX
#endif


 1057    CONTINUE

C     LINES TO RUN ON A VECTOR COMPUTER
C     NOTE: THESE LINES FINALIZE THE ASSEMBLY PROCESS FOR QC, QA
#ifdef CVEC
         DO IE=1,NE
            NM1=NM(IE,1)
            NM2=NM(IE,2)
            NM3=NM(IE,3)
            QA(NM1)=QA(NM1)+QTEMA(IE,1) !LUMPED LHS MATRIX
            QA(NM2)=QA(NM2)+QTEMA(IE,2) !LUMPED LHS MATRIX
            QA(NM3)=QA(NM3)+QTEMA(IE,3) !LUMPED LHS MATRIX
            QB(NM1)=QB(NM1)+QTEMB(IE,1) !LOAD VECTOR
            QB(NM2)=QB(NM2)+QTEMB(IE,2) !LOAD VECTOR
            QB(NM3)=QB(NM3)+QTEMB(IE,3) !LOAD VECTOR
         END DO
#endif

C.... SOLVE FOR C*H NODE BY NODE

         DO I=1,NP
            NCI=NODECODE(I)
            IF(NCI.NE.0) CH1(I)=QB(I)/QA(I)
C     IF(LBArray_Pointer(I).NE.0) CH1(I)=0.d0  !ESSENTIAL C=0 BOUNDARY CONDITION
         END DO
      ENDIF

c...  find and print to unit 6, the maximum elevation, the maximum
c...  velocity and the node numbers at which they occur on myproc=0 if
c...  elmax exceeds threshold, print information on all processors where
c...  this occurs

      IF(NSCREEN.EQ.1) THEN
         ELMAX=0.0d0
         VELMAX=0.0d0
         KEMAX = 0
         KVMAX = 0
         DO I=1,NP
            IF((NODECODE(I).EQ.1).AND.(ABS(ETA2(I)).GT.ELMAX))THEN
               ELMAX=ABS(ETA2(I))
               KEMAX=I
            ENDIF
            VELABS=UU2(I)*UU2(I)+VV2(I)*VV2(I)
            IF (VELABS.GT.VELMAX) THEN
               VELMAX=VELABS
               KVMAX=I
            ENDIF
         END DO
         VELMAX=VELMAX**0.5d0
         
#ifdef CMPI
         IF(MYPROC.EQ.0.AND.ELMAX.LT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1991) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX,
     &           MYPROC
 1991       FORMAT(1X,'TIME STEP =',I8,5X,'ITERATIONS =',I5,
     &           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     &           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7,
     &           2X,'ON MYPROC = ',I4)
         ENDIF
         IF(ELMAX.GT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1993) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX,
     &           MYPROC
            WRITE(16,1993) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX,
     &           MYPROC
 1993       FORMAT(1X,'TIME STEP =',I8,6X,'ITERATIONS =',I5,
     &           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     &           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7,
     &           2X,'ON MYPROC = ',I4,'!!!WARNING-HIGH ELEVATION!!!')
         ENDIF
#else 
         IF(ELMAX.LT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1992) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
 1992       FORMAT(1X,'TIME STEP =',I8,5X,'ITERATIONS =',I5,
     &           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     &           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7)
         ENDIF
         IF(ELMAX.GT.20.0.AND.KEMAX.GT.0) THEN
            WRITE(6,1994) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
            WRITE(16,1994) IT,NUMITR,ETA2(KEMAX),KEMAX,VELMAX,KVMAX
 1994       FORMAT(1X,'TIME STEP =',I8,6X,'ITERATIONS =',I5,
     &           /,2X,'ELMAX = ', E10.4,' AT NODE',I7,
     &           2X,'SPEEDMAX = ',E10.4,' AT NODE',I7,
     &           2X,' !!! WARNING - HIGH ELEVATION !!!')
         ENDIF
#endif
      ENDIF

C...  Output elevation recording station information if noute<>0 and the
C...  time step falls within the specified window calculate elevation
C...  solutions at stations using interpolation

      IF(NOUTE.NE.0) THEN
         IF((IT.GT.NTCYSE).AND.(IT.LE.NTCYFE)) THEN
            NSCOUE=NSCOUE+1
            IF(NSCOUE.EQ.NSPOOLE) THEN
               DO I=1,NSTAE
                  EE1=ETA2(NM(NNE(I),1))
                  EE2=ETA2(NM(NNE(I),2))
                  EE3=ETA2(NM(NNE(I),3))
                  NC1=NODECODE(NM(NNE(I),1))
                  NC2=NODECODE(NM(NNE(I),2))
                  NC3=NODECODE(NM(NNE(I),3))
                  NCELE=NC1*NC2*NC3
                  IF(NCELE.EQ.1) ET00(I)=EE1*STAIE1(I)+EE2*STAIE2(I)
     &                 +EE3*STAIE3(I)
                  IF(NCELE.EQ.0) ET00(I)=-99999.
                  END DO
               IF(ABS(NOUTE).EQ.1) THEN
                  WRITE(61,2120) time,IT
                  DO I=1,NSTAE
                     WRITE(61,2453) I,ET00(I)
                     END DO
                  CLOSE(61)
                  OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IESTP = IESTP+1+NSTAE
                  ENDIF
               IF(ABS(NOUTE).EQ.2) THEN
                  WRITE(61,REC=IESTP+1) time
                  WRITE(61,REC=IESTP+2) IT
                  IESTP = IESTP + 2
                  DO I=1,NSTAE
                     WRITE(61,REC=IESTP+I) ET00(I)
                     END DO
                  CLOSE(61)
                  OPEN(61,FILE=DIRNAME//'/'//'fort.61',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IESTP = IESTP + NSTAE
                  ENDIF
               NSCOUE=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFE) CLOSE(61)
         ENDIF

C...  OUTPUT VELOCITY RECORDING STATION TIME SERIES INFORMATION IF
C...  NOUTV<>0 AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  CALCULATE VELOCITY SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF(NOUTV.NE.0) THEN
         IF((IT.GT.NTCYSV).AND.(IT.LE.NTCYFV)) THEN
            NSCOUV=NSCOUV+1
            IF(NSCOUV.EQ.NSPOOLV) THEN
               DO I=1,NSTAV
                  U11=UU2(NM(NNV(I),1))
                  U22=UU2(NM(NNV(I),2))
                  U33=UU2(NM(NNV(I),3))
                  V11=VV2(NM(NNV(I),1))
                  V22=VV2(NM(NNV(I),2))
                  V33=VV2(NM(NNV(I),3))
                  UU00(I)=U11*STAIV1(I)+U22*STAIV2(I)+U33*STAIV3(I)
                  VV00(I)=V11*STAIV1(I)+V22*STAIV2(I)+V33*STAIV3(I)
                  END DO
               IF(ABS(NOUTV).EQ.1) THEN
                  WRITE(62,2120) time,IT
                  DO I=1,NSTAV
                     WRITE(62,2454) I,UU00(I),VV00(I)
                     END DO
                  CLOSE(62)
                  OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IVSTP = IVSTP+1+NSTAV
                  ENDIF
               IF(ABS(NOUTV).EQ.2) THEN
                  WRITE(62,REC=IVSTP+1) time
                  WRITE(62,REC=IVSTP+2) IT
                  IVSTP = IVSTP + 2
                  DO I=1,NSTAV
                     WRITE(62,REC=IVSTP+2*I-1) UU00(I)
                     WRITE(62,REC=IVSTP+2*I) VV00(I)
                     END DO
                  CLOSE(62)
                  OPEN(62,FILE=DIRNAME//'/'//'fort.62',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IVSTP = IVSTP + 2*NSTAV
                  ENDIF
               NSCOUV=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFV) CLOSE(62)
         ENDIF

C...  OUTPUT CONCENTRATION RECORDING STATION INFORMATION IF NOUTC<>0
C...  AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW CALCULATE
C...  CONCENTRATION SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF(NOUTC.NE.0) THEN
         IF((IT.GT.NTCYSC).AND.(IT.LE.NTCYFC)) THEN
            NSCOUC=NSCOUC+1
            IF(NSCOUC.EQ.NSPOOLC) THEN
               DO I=1,NSTAC
                  NM1=NM(NNC(I),1)
                  NM2=NM(NNC(I),2)
                  NM3=NM(NNC(I),3)
                  HH2N1=DP(NM1)+IFNLFA*ETA2(NM1)
                  HH2N2=DP(NM2)+IFNLFA*ETA2(NM2)
                  HH2N3=DP(NM3)+IFNLFA*ETA2(NM3)
                  C1=CH1(NM1)/HH2N1
                  C2=CH1(NM2)/HH2N2
                  C3=CH1(NM3)/HH2N3
                  NC1=NODECODE(NM1)
                  NC2=NODECODE(NM2)
                  NC3=NODECODE(NM3)
                  NCELE=NC1*NC2*NC3
                  IF(NCELE.EQ.1) CC00(I)=C1*STAIC1(I)+C2*STAIC2(I)
     &                 +C3*STAIC3(I)
                  IF(NCELE.EQ.0) CC00(I)=-99999.
                  END DO
               IF(ABS(NOUTC).EQ.1) THEN
                  WRITE(81,2120) time,IT
                  DO I=1,NSTAC
                     WRITE(81,2453) I,CC00(I)
                     END DO
                  CLOSE(81)
                  OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  ICSTP = ICSTP+1+NSTAC
                  ENDIF
               IF(ABS(NOUTC).EQ.2) THEN
                  WRITE(81,REC=ICSTP+1) time
                  WRITE(81,REC=ICSTP+2) IT
                  ICSTP = ICSTP + 2
                  DO I=1,NSTAC
                     WRITE(81,REC=ICSTP+I) CC00(I)
                     END DO
                  CLOSE(81)
                  OPEN(81,FILE=DIRNAME//'/'//'fort.81',
     &                   ACCESS='DIRECT',RECL=NBYTE)
                  ICSTP = ICSTP + NSTAC
                  ENDIF
               NSCOUC=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFC) CLOSE(81)
         ENDIF

C...  OUTPUT METEOROLOGICAL RECORDING STATION INFORMATION IF NWS>0 AND
C...  THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW CALCULATE
C...  METEOROLOGICAL SOLUTIONS AT STATIONS USING INTERPOLATION
C...  
      IF((NWS.NE.0).AND.(NOUTM.NE.0)) THEN
         IF((IT.GT.NTCYSM).AND.(IT.LE.NTCYFM)) THEN
            NSCOUM=NSCOUM+1
            IF(NSCOUM.EQ.NSPOOLM) THEN
               DO I=1,NSTAM
                  NM1=NM(NNM(I),1)
                  NM2=NM(NNM(I),2)
                  NM3=NM(NNM(I),3)
                  U11=wvnxout(NM1)
                  U22=wvnxout(NM2)
                  U33=wvnxout(NM3)
                  V11=wvnyout(NM1)
                  V22=wvnyout(NM2)
                  V33=wvnyout(NM3)
                  P11=PR2(NM1)
                  P22=PR2(NM2)
                  P33=PR2(NM3)
                  RMU00(I)=U11*STAIM1(I)+U22*STAIM2(I)+U33*STAIM3(I)
                  RMV00(I)=V11*STAIM1(I)+V22*STAIM2(I)+V33*STAIM3(I)
                  RMP00(I)=P11*STAIM1(I)+P22*STAIM2(I)+P33*STAIM3(I)
                  END DO
               IF(ABS(NOUTM).EQ.1) THEN
                  WRITE(71,2120) time,IT
                  WRITE(72,2120) time,IT
                  DO I=1,NSTAM
                     WRITE(71,2453) I,RMP00(I)
                     WRITE(72,2454) I,RMU00(I),RMV00(I)
                     END DO
                  CLOSE(71)
                  OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  CLOSE(72)
                  OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IPSTP=IPSTP+1+NSTAM
                  IWSTP=IWSTP+1+NSTAM
                  ENDIF
               IF(ABS(NOUTM).EQ.2) THEN
                  WRITE(71,REC=IPSTP+1) time
                  WRITE(71,REC=IPSTP+2) IT
                  WRITE(72,REC=IWSTP+1) time
                  WRITE(72,REC=IWSTP+2) IT
                  IPSTP=IPSTP+2
                  IWSTP=IWSTP+2
                  DO I=1,NSTAM
                     WRITE(71,REC=IPSTP+I) RMP00(I)
                     WRITE(72,REC=IWSTP+2*I-1) RMU00(I)
                     WRITE(72,REC=IWSTP+2*I) RMV00(I)
                     END DO
                  CLOSE(71)
                  OPEN(71,FILE=DIRNAME//'/'//'fort.71',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  CLOSE(72)
                  OPEN(72,FILE=DIRNAME//'/'//'fort.72',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IPSTP=IPSTP+NSTAM
                  IWSTP=IWSTP+2*NSTAM
                  ENDIF
               NSCOUM=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFM) THEN
            CLOSE(71)
            CLOSE(72)
            ENDIF
         ENDIF

C...   OUTPUT GLOBAL ELEVATION DATA IF NOUTGE<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  

2120  FORMAT(2X,E20.10,5X,I10)
2453  FORMAT(2X,I8,2X,E15.8)

      IF(NOUTGE.NE.0) THEN
         IF((IT.GT.NTCYSGE).AND.(IT.LE.NTCYFGE)) THEN
            NSCOUGE=NSCOUGE+1
            IF(NSCOUGE.EQ.NSPOOLGE) THEN
               IF(ABS(NOUTGE).EQ.1) THEN
                  WRITE(63,2120) time,IT
                  DO I=1,NP
                     IF(NODECODE(I).EQ.1) WRITE(63,2453) I,ETA2(I)
                     IF(NODECODE(I).EQ.0) WRITE(63,2453) I,-99999.
                     ENDDO
                  CLOSE(63)
                  OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IGEP=IGEP+1+NP
                  ENDIF
               IF(ABS(NOUTGE).EQ.2) THEN
                  WRITE(63,REC=IGEP+1) time
                  WRITE(63,REC=IGEP+2) IT
                  IGEP = IGEP + 2
                  DO I=1,NP
                     IF(NODECODE(I).EQ.1) WRITE(63,REC=IGEP+I)ETA2(I)
                     IF(NODECODE(I).EQ.0) WRITE(63,REC=IGEP+I) -99999.
                     ENDDO
                  CLOSE(63)
                  OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IGEP = IGEP + NP
                  ENDIF

c......BDE
c  MCELServer Elevation Output
c......BDE
               IF(ABS(NOUTGE).EQ.20) THEN
                  CALL WRITE_MCEL_WLEV(time)
		  ! Output to MCEL and to fort.63 if -20
		  IF(NOUTGE.EQ.-20) THEN
                    WRITE(63,2120) time,IT
                    DO I=1,NP
                       IF(NODECODE(I).EQ.1) WRITE(63,2453) I,ETA2(I)
                       IF(NODECODE(I).EQ.0) WRITE(63,2453) I,-99999.
                    ENDDO
                    CLOSE(63)
                    OPEN(63,FILE=DIRNAME//'/'//'fort.63',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')		  
		  ENDIF
           	  IGEP=IGEP+1+NP
               ENDIF
c......BDE
c  MCELServer Elevation Output
c......BDE
	       NSCOUGE=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFGE) CLOSE(63)
         ENDIF

C...  OUTPUT GLOBAL VELOCITY DATA IF NOUTGV<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  

2454  FORMAT(2X,I8,2(2X,E15.8))

      IF(NOUTGV.NE.0) THEN
         IF((IT.GT.NTCYSGV).AND.(IT.LE.NTCYFGV)) THEN
            NSCOUGV=NSCOUGV+1
            IF(NSCOUGV.EQ.NSPOOLGV) THEN
               IF(ABS(NOUTGV).EQ.1) THEN
                  WRITE(64,2120) time,IT
                  DO I=1,NP
                     WRITE(64,2454) I,UU2(I),VV2(I)
                     ENDDO
                  CLOSE(64)
                  OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IGVP = IGVP+1+NP
                  ENDIF
               IF(ABS(NOUTGV).EQ.2) THEN
                  WRITE(64,REC=IGVP+1) time
                  WRITE(64,REC=IGVP+2) IT
                  IGVP = IGVP + 2
                  DO I=1,NP
                     WRITE(64,REC=IGVP+2*I-1) UU2(I)
                     WRITE(64,REC=IGVP+2*I) VV2(I)
                     END DO
                  CLOSE(64)
                  OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IGVP = IGVP + 2*NP
                  ENDIF

c......BDE
c  MCELServer Current Velocity Output
c......BDE
               IF(ABS(NOUTGV).EQ.20) THEN
                  CALL WRITE_MCEL_UV(time)
		  ! Output to MCEL and to fort.64 if -20
                  IF(NOUTGV.EQ.-20) THEN
                      WRITE(64,2120) time,IT
                      DO I=1,NP
                	 WRITE(64,2454) I,UU2(I),VV2(I)
                	 ENDDO
                      CLOSE(64)
                      OPEN(64,FILE=DIRNAME//'/'//'fort.64',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  ENDIF
                  IGVP = IGVP+1+NP
               ENDIF
c......BDE
c  MCELServer Current Velocity Output
c......BDE

               NSCOUGV=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFGV) CLOSE(64)
         ENDIF

C...
C...  OUTPUT GLOBAL WIND STRESS and atmospheric pressure data IF
C.... NOUTGW<>0 AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...
      IF((NWS.NE.0).AND.(NOUTGW.NE.0)) THEN
         IF((IT.GT.NTCYSGW).AND.(IT.LE.NTCYFGW)) THEN
            NSCOUGW=NSCOUGW+1
            IF(NSCOUGW.EQ.NSPOOLGW) THEN
               IF(ABS(NOUTGW).EQ.1) THEN
                  write(73,2120) time,it
                  WRITE(74,2120) time,IT
                  DO I=1,NP
                     write(73,2453) i,pr2(i)
                     WRITE(74,2454) i,wvnxout(i),wvnyout(i)
                  ENDDO
                  CLOSE(73)
                  OPEN(73,FILE=DIRNAME//'/'//'fort.73',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  CLOSE(74)
                  OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  igpp = igpp+1+np
                  IGWP = IGWP+1+NP
                  ENDIF
               IF(ABS(NOUTGW).EQ.2) THEN
                  WRITE(73,REC=igpp+1) time
                  WRITE(73,REC=igpp+2) IT
                  WRITE(74,REC=IGWP+1) time
                  WRITE(74,REC=IGWP+2) IT
                  igpp = igpp + 2
                  IGWP = IGWP + 2
                  DO I=1,NP
                     write(73,rec=igpp+i) pr2(i)
                     WRITE(74,REC=IGWP+2*I-1) wvnxout(i)
                     WRITE(74,REC=IGWP+2*I) wvnyout(i)
                     END DO
                  CLOSE(73)
                  OPEN(73,FILE=DIRNAME//'/'//'fort.73',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  CLOSE(74)
                  OPEN(74,FILE=DIRNAME//'/'//'fort.74',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  igpp = igpp + np
                  IGWP = IGWP + 2*NP
                  ENDIF
               NSCOUGW=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFGW) then
            close(73)
            close(74)
            ENDIF
         endif

C...  OUTPUT GLOBAL CONCENTRATION DATA IF NOUTGC<>0 AND THE
C.... TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  
      IF(NOUTGC.NE.0) THEN
         IF((IT.GT.NTCYSGC).AND.(IT.LE.NTCYFGC)) THEN
            NSCOUGC=NSCOUGC+1
            IF(NSCOUGC.EQ.NSPOOLGC) THEN
               IF(ABS(NOUTGC).EQ.1) THEN
                  WRITE(83,2120) time,IT
                  DO I=1,NP
                     HH2=DP(I)+IFNLFA*ETA2(I)
                     C1=CH1(I)/HH2
                     IF(NODECODE(I).EQ.1) WRITE(83,2453) I,C1
                     IF(NODECODE(I).EQ.0) WRITE(83,2453) I,-99999.
                     ENDDO
                  CLOSE(83)
                  OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     &                    ACCESS='SEQUENTIAL',POSITION='APPEND')
                  IGCP=IGCP+1+NP
                  ENDIF
               IF(ABS(NOUTGC).EQ.2) THEN
                  WRITE(83,REC=IGEP+1) time
                  WRITE(83,REC=IGEP+2) IT
                  IGCP = IGCP + 2
                  DO I=1,NP
                     HH2=DP(I)+IFNLFA*ETA2(I)
                     C1=CH1(I)/HH2
                     IF(NODECODE(I).EQ.1) WRITE(83,REC=IGCP+I) C1
                     IF(NODECODE(I).EQ.0) WRITE(83,REC=IGCP+I) -99999.
                     ENDDO
                  CLOSE(83)
                  OPEN(83,FILE=DIRNAME//'/'//'fort.83',
     &                    ACCESS='DIRECT',RECL=NBYTE)
                  IGCP=IGCP+NP
                  ENDIF
               NSCOUGC=0
               ENDIF
            ENDIF
         IF(IT.EQ.NTCYFGC) CLOSE(83)
         ENDIF

C...  IF IHARIND=1 AND THE TIME STEP FALLS WITHIN THE SPECIFIED WINDOW
C...  AND ON THE SPECIFIED INCREMENT, USE MODEL RESULTS TO UPDATE
C...  HARMONIC ANALYSIS MATRIX AND LOAD VECTORS.  NOTE: AN 8 BYTE RECORD
C...  SHOULD BE USED THROUGHOUT THE HARMONIC ANALYSIS SUBROUTINES, EVEN
C...  ON 32 BIT WORKSTATIONS, SINCE IN THAT CASE THE HARMONIC ANALYSIS
C...  IS DONE IN DOUBLE PRECISION.
C...  
      IF(IHARIND.EQ.1) THEN
         IF((IT.GT.ITHAS).AND.(IT.LE.ITHAF)) THEN
            IF(ICHA.EQ.NHAINC) ICHA=0
            ICHA=ICHA+1
            IF(ICHA.EQ.NHAINC) THEN
C...  
C.....UPDATE THE LHS MATRIX
C...  
               CALL LSQUPDLHS(timeh,IT)
C...  IF DESIRED COMPUTE ELEVATION STATION INFORMATION AND UPDATE LOAD
C.....VECTOR
C...
               IF(NHASE.EQ.1) THEN
                  DO I=1,NSTAE
                     EE1=ETA2(NM(NNE(I),1))
                     EE2=ETA2(NM(NNE(I),2))
                     EE3=ETA2(NM(NNE(I),3))
                     ET00(I)=EE1*STAIE1(I)+EE2*STAIE2(I)+EE3*STAIE3(I)
                  END DO
                  CALL LSQUPDES(ET00,NSTAE)
               ENDIF
C...  IF DESIRED COMPUTE VELOCITY STATION INFORMATION AND UPDATE LOAD
C.....VECTOR
C...
               IF(NHASV.EQ.1) THEN
                  DO I=1,NSTAV
                     U11=UU2(NM(NNV(I),1))
                     U22=UU2(NM(NNV(I),2))
                     U33=UU2(NM(NNV(I),3))
                     V11=VV2(NM(NNV(I),1))
                     V22=VV2(NM(NNV(I),2))
                     V33=VV2(NM(NNV(I),3))
                     UU00(I)=U11*STAIV1(I)+U22*STAIV2(I)+U33*STAIV3(I)
                     VV00(I)=V11*STAIV1(I)+V22*STAIV2(I)+V33*STAIV3(I)
                  END DO
                  CALL LSQUPDVS(UU00,VV00,NSTAV)
               ENDIF
C...  
C.....IF DESIRED UPDATE GLOBAL ELEVATION LOAD VECTOR
C...  
               IF(NHAGE.EQ.1) CALL LSQUPDEG(ETA2,NP)
C...  
C.....IF DESIRED UPDATE GLOBAL VELOCITY LOAD VECTOR
C...  
               IF(NHAGV.EQ.1) CALL LSQUPDVG(UU2,VV2,NP)

            ENDIF
         ENDIF

C...  LINES TO COMPUTE MEANS AND VARIANCES

         if (CHARMV) then
            IF(IT.GT.ITMV) THEN
               NTSTEPS=NTSTEPS+1
               DO I=1,NP
                  ELAV(I)=ELAV(I)+ETA2(I)
                  XVELAV(I)=XVELAV(I)+UU2(I)
                  YVELAV(I)=YVELAV(I)+VV2(I)
                  ELVA(I)=ELVA(I)+ETA2(I)*ETA2(I)
                  XVELVA(I)=XVELVA(I)+UU2(I)*UU2(I)
                  YVELVA(I)=YVELVA(I)+VV2(I)*VV2(I)
               END DO
            ENDIF
         endif                  !   charmv


      ENDIF

C...
C...  WRITE OUT HOT START INFORMATION IF NHSTAR=1 AND AT CORRECT TIME
C.... STEP
C...  NOTE: THE HOT START FILES USE A RECORD LENGTH OF 8 ON BOTH 32 BIT
C.... WORKSTATIONS AND THE 64 BIT CRAY.  THIS IS BECAUSE THE HARMONIC
C.... ANALYSIS IS DONE IN DOUBLE PRECISION (64 BITS) ON WORKSTATIONS.
C...
      IF(NHSTAR.EQ.1) THEN
         ITEST=(IT/NHSINC)*NHSINC  
         IF(ITEST.EQ.IT) THEN
            IF(IHSFIL.EQ.67) OPEN(67,FILE=DIRNAME//'/'//'fort.67',
     &           ACCESS='DIRECT',RECL=8)
            IF(IHSFIL.EQ.68) OPEN(68,FILE=DIRNAME//'/'//'fort.68',
     &           ACCESS='DIRECT',RECL=8)
            IHOTSTP=1
            WRITE(IHSFIL,REC=IHOTSTP) IM
            IHOTSTP=2
            WRITE(IHSFIL,REC=IHOTSTP) TIME
            IHOTSTP=3
            WRITE(IHSFIL,REC=IHOTSTP) IT
            DO I=1,NP
               WRITE(IHSFIL,REC=IHOTSTP+1) ETA1(I)
               WRITE(IHSFIL,REC=IHOTSTP+2) ETA2(I)
               WRITE(IHSFIL,REC=IHOTSTP+3) UU2(I)
               WRITE(IHSFIL,REC=IHOTSTP+4) VV2(I)
               IHOTSTP = IHOTSTP + 4
               IF(IM.EQ.10) THEN
                  WRITE(IHSFIL,REC=IHOTSTP+1) CH1(I)
                  IHOTSTP=IHOTSTP+1
               ENDIF
               WRITE(IHSFIL,REC=IHOTSTP+1) NODECODE(I)
               IHOTSTP=IHOTSTP+1
            END DO
            WRITE(IHSFIL,REC=IHOTSTP+1) IESTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUE
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IVSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUV
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) ICSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUC
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IPSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) IWSTP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUM
            IHOTSTP=IHOTSTP+3
            WRITE(IHSFIL,REC=IHOTSTP+1) IGEP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGE
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGVP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGV
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGCP
            WRITE(IHSFIL,REC=IHOTSTP+2) NSCOUGC
            IHOTSTP=IHOTSTP+2
            WRITE(IHSFIL,REC=IHOTSTP+1) IGPP
            WRITE(IHSFIL,REC=IHOTSTP+2) IGWP
            WRITE(IHSFIL,REC=IHOTSTP+3) NSCOUGW
            IHOTSTP=IHOTSTP+3
C...  
C...  IF APPROPRIATE ADD HARMONIC ANALYSIS INFORMATION TO HOT START FILE
C...  
            IF((IHARIND.EQ.1).AND.(IT.GT.ITHAS)) THEN
               WRITE(IHSFIL,REC=IHOTSTP+1) ICHA
               IHOTSTP = IHOTSTP + 1
               CALL HAHOUT(NP,NSTAE,NSTAV,NHASE,NHASV,NHAGE,NHAGV,
     &              IHSFIL,IHOTSTP)
C     
               IF(NHASE.EQ.1) CALL HAHOUTES(NSTAE,IHSFIL,IHOTSTP)
               IF(NHASV.EQ.1) CALL HAHOUTVS(NSTAV,IHSFIL,IHOTSTP)
               IF(NHAGE.EQ.1) CALL HAHOUTEG(NP,IHSFIL,IHOTSTP)
               IF(NHAGV.EQ.1) CALL HAHOUTVG(NP,IHSFIL,IHOTSTP)
            ENDIF

            if( CHARMV) then
               IF((IHARIND.EQ.1).AND.(IT.GT.ITMV)) THEN
                  IHOTSTP=IHOTSTP+1
                  WRITE(IHSFIL,REC=IHOTSTP) NTSTEPS
                  IF(NHAGE.EQ.1) THEN
                     DO I=1,NP
                        WRITE(IHSFIL,REC=IHOTSTP+1) ELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+2) ELVA(I)
                        IHOTSTP=IHOTSTP+2
                     END DO
                  ENDIF
                  IF(NHAGV.EQ.1) THEN
                     DO I=1,NP
                        WRITE(IHSFIL,REC=IHOTSTP+1) XVELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+2) YVELAV(I)
                        WRITE(IHSFIL,REC=IHOTSTP+3) XVELVA(I)
                        WRITE(IHSFIL,REC=IHOTSTP+4) YVELVA(I)
                        IHOTSTP=IHOTSTP+4
                     END DO
                  ENDIF
               ENDIF
            endif               !  charmv

            
            IF (C3D) THEN
               CALL HSTART3D_OUT()
            ENDIF

C...  
C...  CLOSE THE HOT START OUTPUT FILE
C...  
            CLOSE(IHSFIL)
            IF(NSCREEN.EQ.1.AND.MYPROC.EQ.0) THEN
               WRITE(6,24541) IHSFIL,IT,TIME
            ENDIF
            WRITE(16,24541) IHSFIL,IT,TIME
24541       FORMAT(1X,'HOT START OUTPUT WRITTEN TO UNIT ',I2,
     &           ' AT TIME STEP = ',I9,' TIME = ',E15.8)
            IF(IHSFIL.EQ.67) THEN
               IHSFIL=68
            ELSE
               IHSFIL=67
            ENDIF
         ENDIF
      ENDIF
C...  
C...  ****************** TIME STEPPING LOOP ENDS HERE ********************
C...  
      RETURN
      END
