c******************************************************************************
c PADCIRC RELEASE VERSION 43.03 05/20/2003                                    *
C  last changes in this file VERSION 43.03                                    *
C                                                                             *
C  mod history                                                                *
c  v43.03     - 05/20/03 - rl - from 43.02 - parallel wind stuff (m.brown)    *
c                                          output buffer flush (m.cobb)       *
c                                          3D fixes (k.dresback)              *
c                                          drop MNPROC in fort.15 (t.campbell)*
c                                          various bug fixes in RBCs          *        
c                                          ZSURFBUOY/BCPG calc                *
c                                                                             *
c                                                                             *
c            VS VERTICAL SOLUTION SUBROUTINES - VERSION 43.03                 *
c                                                                             *
c                            R.L. 12/ 5/94                                    *
c                            R.G.  4/30/97                                    *
c                            R.L.  2/05/99                                    *
C                            R.L.  8/24/99                                    *
C                            R.L.  9/07/99                                    *
C                            R.L. 12/17/99                                    *
C                            R.L. 01/07/00                                    *
C                            R.L. 01/20/00                                    *
C                            R.L. 02/01/00                                    *
C                            R.L. 02/21/00                                    *
C                            R.L. 05/25/00                                    *
C                            R.L. 01/25/01                                    *
C                            R.L. 02/01/01                                    *
C                            R.L. 11/28/01                                    *
C                            R.L. 01/29/02                                    *
C                            T.C. summer 02 converted to F90 & parallel       *
C                                                                             *
C                                                                             *
C                                                                             *
c                                                                             *
c           UPDATED TO INTERFACE WITH ADC43_XX                                *
c                                                                             *
c   Includes rewritten level 2.5 turbulence closure                           *
C                                                                             *
c   This is a major change over version 5.00 and below because the            *
c   the velocity profile is obtained directly from the 3-D momentum           *
c   equations.                                                                *
c                                                                             *
c******************************************************************************
C                                                                             *
C     -  PARAMETERS WHICH MUST BE SET WITHIN THE MAIN CODE AND THE            *
C          SUBROUTINES TO CONTROL THE DIMENSIONING OF ARRAYS ARE AS FOLLOWS   *
C          (TO FIND THE LINES WHICH MUST BE SET, FIND "CUSER" COMMENT LINES): *
C                                                                             *
C    MNP     = THE MAXIMUM NUMBER OF NODES IN THE HORIZONTAL F.E. GRID AS     *
C              SPECIFIED IN THE EXTERNAL MODE CODE                            *
C    MNE     = THE MAXIMUM NUMBER OF ELEMENTS IN THE HORIZONTAL F.E. GRID AS  *
C              SPECIFIED IN THE EXTERNAL MODE CODE                            *
C    MNEI    = 1+MAXIMUM NUMBER OF NODES CONNECTED TO ANY ONE NODE IN THE     *
C              FINITE ELEMENT GRID                                            *
C    MNWP    = 1 IF NO METEOROLOGIC OR RADIATION STRESS FORCING,              *
C            = MNP IF METEOROLOGIC OR RADIATION STRESS FORCING                *
C    MNVEL   = MAXIMUM TOTAL NUMBER OF FLOW BOUNDARY NODES +1                 *
C    MNODES  = 1 + THE MAXIMUM NUMBER OF NODES OVER THE VERTICAL IN THE       *
C              COMBINED E.V. & F.E. GRID                                      *
C                                                                             *
C                                                                             *
C      NOTE: A MINIMUM VALUE OF 1 SHOULD BE USED FOR EACH PARAMETER           *
C******************************************************************************
C                                                                             *
C     -  STANDARD INPUT FILES ARE AS FOLLOWS:                                 *
C                                                                             *
C          UNIT 15 : INPUT FILE WHICH DEFINES THE MAJORITY OF INPUT           *
C                    PARAMETERS NECESARY FOR SPECIFYING THE SOLUTION OVER THE *
C                    THE VERTICAL.  THESE VALUES FOLLOW THE INPUT INFORMATION *
C                    USED FOR THE EXTERNAL MODE SOLUTION.                     *
C                                                                             *
C                                                                             *
C     -  SUPPLEMENTAL INPUT FILES (ACTIVATED BY INPUT PARAMETERS              *
C          SPECIFIED IN UNIT 15 INPUT) ARE AS FOLLOWS:                        *
C                                                                             *
C          UNIT 10 : VERTICAL FINITE ELEMENT GRID                             *
C          UNIT 11 : SAL,TEMP, DENSITY FIELD AT EVERY NODE IN DOMAIN          *
C          UNIT 12 : VERTICAL DISTRIBUTION OF EDDY VISCOSITY                  *
C                                                                             *
C                                                                             *
C                                                                             *
C******************************************************************************
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES READ IN FROM UNIT 15   (FORT.15)      *
C                                                                             *
C  IDIAG - DIAGNOSTIC AND WARNING MESSAGES TYPES                              *
C       IDIAG   =0 NO NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNITS 2 OR 16     *
C               =1 SERIOUS, NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNIT 16     *
C               =2 SERIOUS, NONFATAL DIAGNOSTIC OUTPUT PRINTED TO UNIT 16     *
C                  ROUTINE DIAGNOSTIC OUTPUT PRINTED TO UNIT 2                *
c                                                                             *
C  IDEN         =0 barotropic model run                                       *
C               =1 diagnostic baroclinic model run                            *
C               =2 prognostic baroclinic model run, salinity only             *
C               =3 prognostic baroclinic model run, temperature only          *
C               =4 prognostic baroclinic model run, salinity and temperature  *
C                                                                             *
C    (For all baroclinic model runs, the initial density field is read in     *
C                       from UNIT 11                                          *
c                                                                             *
C  ISLIP, KP - slip code & slip coefficient                                   *
c                  islip = 0, no slip bottom b.c.                             *
c                  islip = 1, linear slip bottom b.c.                         *
c                  islip = 2, quadratic slip bottom b.c.                      *
c                                                                             *
c  Z0S,Z0B   - free surface & bottom roughnesses (const over horiz)           *
c              if the turbulent length scale is determined by q2l eqn and a   *
c              slip coefficient is used, this should be the thickness of the  *
c              constrant stress layer (e.g., 1 m) below the bottom boundary   *
c              node.                                                          *
c                                                                             *
c  ALP1,ALP2,ALP3 - time weighting coefficients for the velocity solution.    *
c                   0.= fully explicit, 0.5=time centered, 1.= fully implicit *
c               ALP1 weights the Coriolis term                                *
c               ALP2 weights the bottom friction terms                        *
c               ALP3 weights the vertical diffusion term                      *
c                                                                             *
c  IGC,NFEN  - f.e. grid code, # nodes in f.e. grid                           *
c                  igc = 0, f.e. grid read from UNIT 10                       *
c                  igc = 1, uniform f.e. grid generated                       *
c                  igc = 2, log f.e. grid generated                           *
c                  igc = 3, log linear f.e. grid generated                    *
c                  igc = 4, double log f.e. grid generated                    *
c                  igc = 5, P-grid generated                                  *
c                  igc = 6, sine grid generated                               *
c                                                                             *
c  IEVC, EVMIN, EVCON - E.V. code, E.V. minimum value and E.V. constant       *
c                                                                             *
c        NOTE: EVCON is only used for some of the E.V. formulations as        *
c                  discussed below.                                           *
c        NOTE: In cases where EV is specified to vary linearly over the       *
c              lower 20% of the water column, it actually varies linearly     *
c              with a constant slope up to the vertical FE grid node that is  *
c              less than or equal to the 20% location.  The value is constant *
c              as specified at all FE grid nodes above the 20% location.      *
c              The E.V. above and below the 20% level is joined by one        *
c              additional linearly varying segment.                           *
c        NOTE: The E.V. is constrained to always be greater than or equal to  *
c              EVMIN as specified in the UNIT 15 file.                        *
c                                                                             *
c        ievc=0-9, EV constant in time & horizontal space                     *
c             0 - EV read in from UNIT 12 (may vary vertically) - EVCON is    *
c                    not used                                                 *
c             1 - EV = EVCON                                                  *
c                                                                             *
c        ievc=10-19 EV proportional to omega*h*h  (Lynch and Officer (1986)   *
c                                              Lynch and Werner (1987, 1991)) *
c             10 - EV = omega*h*h/10 over the entire water column             *
c             11 - EV = omega*h*h/1000 at bottom                              *
c                       varies linear over lower 20% of wc                    *
c                     = omega*h*h/10 in upper 80% of w.c.                     *
c            NOTE:For this EV formulation, evcon is not used and omega is     *
c                  hardwired for a 12.42 hour tide.                           *
c                                                                             *
c        ievc=20-29 EV proportional to kappa U* z                             *
c             20 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z over entire water column                      *
c             21 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z in lower 20% of water col                     *
c                     = 0.082U*h in upper 80% of water col                    *
c            WHERE: U* is the friction velocity                               *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             *
c        ievc=30-39, EV proportional to Uh (Davies 1990)                      *
c             30 - EV = 0.025|U|h/9.001 over entire water column              *
c             31 - EV = evcon|U|h over entire water column                    *
c             32 - EV = 0.025|U|h/9.001 in upper 80% of wc                    *
c                     = 0.000025h|U|/9.001 at bottom                          *
c                       varies linear over lower 20% of wc                    *
c             33 - EV = evcon|U|h in upper 80% of wc                          *
c                     = evcon|U|h/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=31,33 *
c                                                                             *
c        ievc=40-49, EV proportional to U*U (Davies 1990)                     *
c             40 - EV = 2|UU|/9.001 over entire water column                  *
c             41 - EV = evcon|UU| over entire water column                    *
c             42 - EV = 2|UU|/9.001 in upper 80% of wc                        *
c                     = 0.002|UU|/9.001 at bottom                             *
c                       varies linear over lower 20% of wc                    *
c             43 - EV = evcon|UU| in upper 80% of wc                          *
c                     = evcon|UU|/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=41,43 *
c                                                                             *
c        ievc=50, EV computed from Mellor-Yamada L2.5 closure                 *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             *
c  if ievc = 50                                                               *   
c  THETA1, THETA2 - time weighting coefficients for the MY2.5 turbulence soln.*
c                   0.= fully explicit, 0.5=time centered, 1.= fully implicit *
c            THETA1 weights the dissipation term                              *
c            THETA2 weights the vertical diffusion term                       *
c                                                                             *  
c                                                                             *
C  I3DSD,TO3DSSD,TO3DFSD,NSPO3DSD,NHN3DSD                                     *
C            I3DSD  = 0  NO STATION 3D T,S,D INFO IS OUTPUT TO UNIT 41        *
C                   = 1  STATION 3D T,S,D INFO IS OUTPUT IN ASCII FORMAT      *
C            TO3DSSD =   THE NUMBER OF DAYS AFTER WHICH STATION 3D T,S,D      *
C                        ARE WRITTEN TO UNIT 41.                              *
C            TO3DFSD =   THE NUMBER OF DAYS AFTER WHICH STATION 3D T,S,D      *
C                        CEASE TO BE WRITTEN TO UNIT 41.                      *
C            NSPO3DSD =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 41.  (I.E., DATA IS OUTPUT TO UNIT 41 EVERY     *
C                        NSPO3DSD TIME STEPS AFTER TO3DSSD.)                  *
C            NHN3DSD  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D T,S,D                                     *
C  ISDHOUT(I), I=1,NHN3DSD - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D T,S,D OUTPUT STATIONS               *
C                           (ONLY INCLUDE THIS LINE IF I3DSD IS NOT = 0)      *
C  I3DSV,TO3DSSV,TO3DFSV,NSPO3DSV,NHN3DSV                                     *
C            I3DSV  = 0  NO STATION 3D VELOCITIES ARE OUTPUT TO UNIT 42       *
C                   = 1  STATION 3D VELOCITIES ARE OUTPUT IN ASCII FORMAT     *
C                   = 2  STATION 3D VELOCITIES ARE OUTPUT IN BINARY FORMAT    *
C            TO3DSSV =   THE NUMBER OF DAYS AFTER WHICH STATION 3D VELOCITIES *
C                        ARE WRITTEN TO UNIT 42.                              *
C            TO3DFSV =   THE NUMBER OF DAYS AFTER WHICH STATION 3D VELOCITIES *
C                        CEASE TO BE WRITTEN TO UNIT 42.                      *
C            NSPO3DSV =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 42.  (I.E., DATA IS OUTPUT TO UNIT 42 EVERY     *
C                        NSPO3DSV TIME STEPS AFTER TO3DSSV.)                  *
C            NHN3DSV  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D VELOCITIES.                               *
C  ISVHOUT(I), I=1,NHN3DSV - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D VELOCITY OUTPUT STATIONS            *
C                           (ONLY INCLUDE THIS LINE IF I3DSV IS NOT = 0)      *
C  I3DST,TO3DSST,TO3DFST,NSPO3DST,NHN3DST                                     *
C            I3DST  = 0  NO STATION 3D TURBULENCE VARIABLES OUTPUT TO UNIT 43 *
C                   = 1  STATION 3D TURBULENCE VARIABLES OUTPUT IN ASCII FORMAT
C            TO3DSST =   THE NUMBER OF DAYS AFTER WHICH STATION 3D TURBULENCE *
C                        VARIABLES ARE WRITTEN TO UNIT 43.                    *
C            TO3DFST =   THE NUMBER OF DAYS AFTER WHICH STATION 3D TURBULENCE *
C                        VARIABLES CEASE TO BE WRITTEN TO UNIT 43.            *
C            NSPO3DST =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 43.  (I.E., DATA IS OUTPUT TO UNIT 43 EVERY     *
C                        NSPO3DSV TIME STEPS AFTER TO3DSSV.)                  *
C            NHN3DST  =  THE NUMBER OF STATIONS IN THE HORIZONTAL TO OUTPUT   *
C                        STATION 3D VELOCITIES.                               *
C  ISTHOUT(I), I=1,NHN3DST - HORIZONTAL NODE NUMBERS (FROM EXTENAL MODE GRID) *
C                        TO BE USED AS 3D VELOCITY OUTPUT STATIONS            *
C                           (ONLY INCLUDE THIS LINE IF I3DST IS NOT = 0)      *
C  I3DGD,TO3DSGD,TO3DFGD,NSPO3DGD                                             *
C            I3DGD  = 0  NO GLOBAL 3D T,S,D INFO IS OUTPUT TO UNIT 44         *
C                   = 1  GLOBAL 3D T,S,D INFO IS OUTPUT IN ASCII FORMAT       *
C            TO3DSGD =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D T,S,D       *
C                        ARE WRITTEN TO UNIT 44.                              *
C            TO3DFGD =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D T,S,D       *
C                        CEASE TO BE WRITTEN TO UNIT 44.                      *
C            NSPO3DGD =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 44.  (I.E., DATA IS OUTPUT TO UNIT 44 EVERY     *
C                        NSPO3DGD TIME STEPS AFTER TO3DSGD.)                  *
C  I3DGV,TO3DSGV,TO3DFGV,NSPO3DGV                                             *
C            I3DGV  = 0  NO GLOBAL 3D VELOCITIES ARE OUTPUT TO UNIT 45        *
C                   = 1  GLOBAL 3D VELOCITIES ARE OUTPUT IN ASCII FORMAT      *
C                   = 2  GLOBAL 3D VELOCITIES ARE OUTPUT IN BINARY FORMAT     *
C            TO3DSGV =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D VELOCITY    *
C                        DATA IS WRITTEN TO UNIT 45.                          *
C            TO3DFGV =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D VELOCITY    *
C                        DATA CEASES TO BE WRITTEN TO UNIT 45.                *
C            NSPO3DGV =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 45.  (I.E., DATA IS OUTPUT TO UNIT 45 EVERY     *
C                        NSPO3DGV TIME STEPS AFTER TO3DSGV.)                  *
C  I3DGT,TO3DSGT,TO3DFGT,NSPO3DGT                                             *
C            I3DGT  = 0  NO GLOBAL 3D TURBULENCE VARIABLES OUTPUT TO UNIT 46  *
C                   = 1  GLOBAL 3D TURBULENCE VARIABLES OUTPUT IN ASCII FORMAT*
C            TO3DSGT =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D TURBULENCE  *
C                        VARIABLES ARE WRITTEN TO UNIT 46.                    *
C            TO3DFGT =   THE NUMBER OF DAYS AFTER WHICH GLOBAL 3D TURBULENCE  *
C                        VARIABLES CEASE TO BE WRITTEN TO UNIT 46.            *
C            NSPO3DGT =  THE NUMBER OF TIME STEPS AT WHICH DATA IS WRITTEN TO *
C                        UNIT 46.  (I.E., DATA IS OUTPUT TO UNIT 46 EVERY     *
C                        NSPO3DGT TIME STEPS AFTER TO3DSGT.)                  *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 11  (FORT.11)               *
C             (NOTE, THIS IS USED ONLY IF IDEN=1)                             *
C                                                                             *
C           HEADER LINE 1                                                     *
C           HEADER LINE 2                                                     *
C           NVN - number of nodes in vertical, must match NFEN                *
C           DO I=1,NP                                                         *
C             DO J=1,NFEN                                                     *
C               NHNN,NVNN,SIGT(NHNN,NVNN),TEMP(NHNN,NVNN),SAL(NHNN,NVNN)      *
C               END DO                                                        *
C             END DO                                                          *
C                                                                             *
C           NHNN = HORIZONTAL NODE NUMBER                                     *
C           NVNN = VERTICAL NODE NUMBER                                       *
C           SIGT(NHNN,NVNN) = SIGMA T VALUE (KG/M^3) (=DENSITY-1000)          *
C           TEMP(NHNN,NVNN) = TEMPERATURE (DEG C)                             *
C           SAL(NHNN,NVNN) = SALINITY (PSU)                                   *
C                                                                             *
C        NOTE: J=1 AT BOTTOM, J=NFEN AT SURFACE                               *
C                                                                             *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 10  (FORT.10)               *
C             (NOTE, THIS IS USED ONLY IF IGC=0)                              *
C                                                                             *
C  SIGMA(I), I=1,NFEN                                                         *
C           SIGMA(I) = ELEVATION OF F.E. GRID NODE I (FROM b TO a)            *
C                                                                             *
C                                                                             *
C                                                                             *
C                                                                             *
C     -  DESCRIPTION OF INPUT VARIABLES FROM UNIT 12 (FORT.12)                *
C             (NOTE, THIS IS USED ONLY IF IEVC=0)                             *
C                                                                             *
C  NIEVN              =  NUMBER OF NODES IN THE EDDY VISCOSITY GRID - THIS    *
C                        MUST MATCH THE NUMBER OF NODES IN THE SIGMA GRID!!   *
C  SIGEVI(I),EVTOT(I), I=1,NIEVN                                              *
C           SIGEVI(I) =  ELEVATION OF EDDY VISCOSITY NODE I  (FROM b TO a)    *
C                        This must match the sigma levels used in the grid    *
c                        in order from bottom to top.                         *
C           EVTOT(I) =  EDDY VISCOSITY ASSOCIATED WITH NODE I                 *
C                                                                             *
C******************************************************************************
C                                                                             *
C  3D Model output is generated in the following files:                       *
C                                                                             *
C   Serious/Fatal err msgs (ascii)           - UNIT 16    (fort.16)           *
C   Station Density output                   - UNIT 41    (fort.41)           *
C   Station Velocity output                  - UNIT 42    (fort.42)           *
C   Station Turbulence output                - UNIT 43    (fort.43)           *
C   Global Density output                    - UNIT 44    (fort.44)           *
C   Global Velocity output                   - UNIT 45    (fort.45)           *
C   Global Turbulence output                 - UNIT 46    (fort.46)           *
C   Detailed diagnostics (ascii)             - UNIT  2    (fort.2)            *
C                                                                             *
c******************************************************************************
C                                                                             *
C  OUTPUT FILE FORMAT                                                         *
C                                                                             *
C  Station D,T,S  (Density, Temp, Salinity) (fort.41)                         *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NDSDSET,DELT*NSPO3DSD,NSPO3DSD,NHN3DSD,NFEN                            *
C      FOR K = 1,NDSDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DSD                                                      *
c      ISDHOUT(J),(SIGT(M),TEMP(M),SAL(M),M=1,NFEN)                           *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Station Velocity (fort.42)                                                 *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NSVDSET,DELT*NSPO3DSV,NSPO3DSV,NHN3DSV,NFEN                            *
C      FOR K = 1,NSVDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DSV                                                      *
c      ISVHOUT(J),(U(M),V(M),W(M),M=1,NFEN)                                   *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Station Turbulence (fort.43)                                               *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NSTDSET,DELT*NSPO3DST,NSPO3DST,NHN3DST,NFEN                            *
C      FOR K = 1,NSTDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NHN3DST                                                      *
c      ISTHOUT(J),(q2(M),l(M),Evm(M),M=1,NFEN)                                *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global D,T,S (Density, Temperature, Salinity) (fort.44)                    *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGDDSET,DELT*NSPO3DGD,NSPO3DGD,NP,NFEN                                 *
C      FOR K = 1,NGDDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(SIGT(M),TEMP(M),SAL(M),M=1,NFEN)                                    *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global Velocity (fort.45)                                                  *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGVDSET,DELT*NSPO3DGV,NSPO3DGV,NP,NFEN                                 *
C      FOR K = 1,NGVDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(U(M),V(M),W(M),M=1,NFEN)                                            *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
C  Global Turbulence (fort.46)                                                *
C                                                                             *
C      RUNDES,RUNID,AGRID                                                     *
C      NGTDSET,DELT*NSPO3DGT,NSPO3DGT,NP,NFEN                                 *
C      FOR K = 1,NGTDSET                                                      *
C      TIME,IT,(SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),SIGMA(NFEN),SIGMA(NFEN)*
C      FOR J = 1,NP                                                           *
c      J,(q2(M),l(M),Evm(M),M=1,NFEN)                                         *
c      END J LOOP                                                             *
C      END K LOOP                                                             *
C                                                                             *
C                                                                             *
c******************************************************************************
c                                                                             *
c   THIS  PROGRAM MAPS THE TRUE Z-COORDINATE SYSTEM INTO A DIMENSIONLESS      *
C   VERTICAL COORDINATE FROM [b,a] (BOTTOM TO TOP).  VALUES OF a=1 AND b=-1   *
C   ARE SET IN THE CODE.                                                      *
c                                                                             *
c******************************************************************************

      SUBROUTINE READ_INPUT_3DVS(DELT,STATIME,NT)

      USE GLOBAL_3DVS

      REAL(SZ) :: DELT
      REAL(8) :: STATIME
      REAL(8), PARAMETER :: day2sec=24.d0*3600.d0
      REAL :: HH1

C...  
C...  INITIALIZE A FEW PARAMETERS
C...  
      istart=0
      A=1.d0
      B=-1.d0
      I=(0.0d0,1.0d0)
      AMB = A-B
      GORho=G/RhoWat0
      GORhoOAMB=GORho/AMB

C...  
C...  BEGIN READING VERTICAL PARAMETER INFORMATION
C...  
      WRITE(16,300)
 300  FORMAT(//,1X,'VERTICAL SOLUTION INFORMATION',/)

C     
C...  READ AND CHECK INPUT FROM UNIT 15
C     
 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     &     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')

C...  SPECIFY THE DETAIL OF THE DIAGNOSTIC AND WARNING MESSAGES

      READ(15,*) IDIAG
      WRITE(16,420) IDIAG
 420  FORMAT(/,5X,'IDIAG = ',I3)
      IF((IDIAG.GT.2).OR.(IDIAG.LT.0)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,422)
         ENDIF
         WRITE(16,350)
         WRITE(16,422)
 422     FORMAT(/,2X,'    IDIAG MUST = 0,1 OR 2')
         STOP
      ENDIF

      IF(IDIAG.EQ.2) THEN
         OPEN(2,FILE=DIRNAME//'/'//'fort.2') !GENERAL DIAGNOSTIC OUTPUT FILE
         WRITE(2,*) '********** 3DVS V7.07 **********'
         WRITE(2,*) 'TIME = ',STATIME
      ENDIF

C...  SPECIFY WHETHER A BAROTROPIC OR BAROCLINIC RUN

      READ(15,*) IDEN
      WRITE(16,421) IDEN
 421  FORMAT(/,5X,'IDEN = ',I3)
      IF((IDEN.GT.1).OR.(IDEN.LT.0)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,423)
         ENDIF
         WRITE(16,350)
         WRITE(16,423)
 423     FORMAT(/,2X,'    IDEN MUST = 0 OR 1')
         STOP
      ENDIF

C...  READ IN THE TYPE OF BOTTOM BOUNDARY CONDITION AND THE SLIP COEFFICIENTS

      READ(15,*) ISLIP,KP
      WRITE(16,355) ISLIP,KP
 355  FORMAT(/,5X,'ISLIP = ',I3,' KP = ',E10.5)
      IF((ISLIP.LT.0).OR.(ISLIP.GT.2)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,360)
         ENDIF
         WRITE(16,350)
         WRITE(16,360)
 360     FORMAT(/,2X,'    THE SLIP CODE MUST = 0,1,OR 2.')
         STOP
      ENDIF

C...  READ IN THE SURFACE AND BOTTOM ROUGHNESSES

      READ(15,*) Z0S, Z0B
      WRITE(16,380) Z0S,Z0B
 380  FORMAT(/,5X,'Z0S = ',E10.5,' Z0B = ',E10.5)

C...  READ IN THE TIME STEPPING COEFFICIENTS

      READ(15,*) ALP1,ALP2,ALP3
      WRITE(16,390) ALP1,ALP2,ALP3
 390  FORMAT(/,5X,'3D TIME STEPPING COEFFS ALP1 = ',E8.2,' ALP2 = ',
     &     E8.2,' ALP3 = ',E8.2)

C...  READ IN IGC & NFEN: F.E. GRID CODE & # NODES IN F.E. GRID

      READ(15,*) IGC,NFEN
      WRITE(16,400) IGC,NFEN
 400  FORMAT(/,5X,'IGC = ',I3,' NUMBER OF NODES (NFEN) = ',I5)

C...  SET MNODES EQUAL TO NFEN

      MNODES = NFEN

C...  ALLOCATE 3D ARRAYS

      CALL ALLOC_3DVS()

C...  READ IN OR SET UP F.E. GRID  (IGC & NFEN ARE CHECKED IN SUB. FEGRIDS)

      hhtotal=0.
      do nh=1,np
         hhtotal=hhtotal+DP(nh)
      end do
      HH1=hhtotal/np
      CALL FEGRIDS(IGC,HH1)

      IF(IDIAG.EQ.2) THEN       !WRITE GENERAL DIAGNOSTIC OUTPUT
         WRITE(2,*) '********** READ_INPUT_3DVS **********'
         WRITE(2,*) '***** N, SIGMA(N) *****'
         DO N=1,NFEN
            WRITE(2,402) N,SIGMA(N)
 402        FORMAT(I5,2X,F13.9)
         END DO
      END IF

C...  SPECIFY TYPE OF EDDY VISCOSITY PROFILE

      READ(15,*) IEVC,EVMIN,EVCON
      WRITE(16,410) IEVC,EVMIN,EVCON
 410  FORMAT(/,5X,'IEVC = ',I3,2X,'EVMIN = ',E15.8,2X,'EVCON = ',E15.8)
      IF((IEVC.NE.0 ).and.(IEVC.NE.1 ).and.
     &     (IEVC.NE.10).and.(IEVC.NE.11).and.
     &     (IEVC.NE.20).and.(IEVC.NE.21).and.
     &     (IEVC.NE.30).and.(IEVC.NE.31).and.(IEVC.NE.32).and.
     &     (IEVC.NE.33).and.
     &     (IEVC.NE.40).and.(IEVC.NE.41).and.(IEVC.NE.42).and.
     &     (IEVC.NE.43).and.
     &     (IEVC.NE.50)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(*,350)
            WRITE(*,411)
         ENDIF
         WRITE(16,350)
         WRITE(16,411)
 411     FORMAT(/,2X,'    IEVC MUST BE 0,1,10,11,20,21,30,31,32,33,40,',
     &        '41,42,43,50')
         STOP
      ENDIF
      IF(IEVC.EQ.50) READ(15,*) THETA1,THETA2

C...  READ IN OUTPUT CONTROLS & INITIALIZE OUTPUT FILES

 499  FORMAT(1X,A32,2X,A24,2X,A24)
 498  FORMAT(1X,I10,1X,E15.7,I10,1X,I10,1X,I10/)
 497  FORMAT(5X,'UNIT ',I2,' FORMAT WILL BE ASCII')
 496  FORMAT(5X,'UNIT ',I2,' FORMAT WILL BE BINARY')

C.... STATION 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,*) I3DSD,TO3DS,TO3DF,NSPO3DSD,NHN3DSD
      WRITE(16,501) I3DSD
 501  FORMAT(/,5X,'I3DSD = ',I3)

      IF((I3DSD.LT.0).OR.(I3DSD.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,511)
         WRITE(16,511)
 511     FORMAT(/,2X,'    I3DSD MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DSD.EQ.0) WRITE(16,521)
 521  FORMAT(5X,'NO STATION 3D D,T,S WILL BE OUTPUT')

      IF(I3DSD.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSSD=NINT(TSS)
         IF((TSS-NTSSSD).GE.0.5) NTSSSD=NTSSSD+1 !START AFTER T.S.
         IF(NTSSSD.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,531) TO3DS
            WRITE(16,531) TO3DS
 531        FORMAT(5X,'NOTE: TO3DSSD = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSSD=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFSD=NINT(TSF)
         IF((TSF-NTSFSD).GE.0.5) NTSFSD=NTSFSD+1 !END T.S.
         IF(NTSFSD.LT.NTSSSD) THEN
            IF(NSCREEN.NE.0) WRITE(6,541) TO3DF
            WRITE(16,541) TO3DF
 541        FORMAT(5X,'NOTE: TO3DFSD = ',E14.6,' < TO3DSSD. ',
     &           'IT HAS BEEN RESET = TO3DSSD.')
            TO3DF=TO3DS
            NTSFSD=NTSSSD
         ENDIF
         IF(NTSFSD.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,551) TO3DF
            WRITE(16,551) TO3DF
 551        FORMAT(5X,'NOTE: TO3DFSD = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFSD=NT
         ENDIF
         IF(NSPO3DSD.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,561) NSPO3DSD
            ENDIF
            WRITE(16,350)
            WRITE(16,561) NSPO3DSD
 561        FORMAT(2X,'    NSPO3DSD = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISDHOUT(N),N=1,NHN3DSD)

         NDSETSD = (NTSFSD-NTSSSD)/NSPO3DSD !NUMBER OF DATA SETS
         NSSD=-1                !COUNTER

         WRITE(16,571) NSPO3DSD,TO3DS,NTSSSD,TO3DF,NTSFSD,
     &        NSPO3DSD,NHN3DSD
 571     FORMAT(5X,'STATION 3D D,T,S WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSSD.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     &        'SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFSD =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 41 EVERY',
     &        ' NSPO3DSD = ',I7,' TIME STEPS',
     &        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DSD.EQ.1) THEN
         WRITE(16,497) 41
         OPEN(41,FILE=DIRNAME//'/'//'fort.41')
         WRITE(41,499) RUNDES,RUNID,AGRID
         WRITE(41,498) NDSETSD,DELT*NSPO3DSD,NSPO3DSD,NHN3DSD,NFEN
         WRITE(41,*) ' '
      ENDIF

      IF(I3DSD.EQ.2) THEN
         WRITE(16,496) 41
      OPEN(41,FILE=DIRNAME//'/'//'fort.41',ACCESS='DIRECT',RECL=NBYTE)
         ISDREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RID4(N)
            ENDDO
            DO N=1,6
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) RID8(N)
            ENDDO
            DO N=1,3
               ISDREC=ISDREC+1
               WRITE(41,REC=ISDREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(41,REC=ISDREC+1) NDSETSD
         WRITE(41,REC=ISDREC+2) DELT*NSPO3DSD
         WRITE(41,REC=ISDREC+3) NSPO3DSD
         WRITE(41,REC=ISDREC+4) NHN3DSD
         WRITE(41,REC=ISDREC+5) NFEN
         ISDREC=ISDREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DSD, NTSSSD, NSPO3DSD = ',I3DSD,NTSSSD,NSPO3DSD
         WRITE(2,*) 'NHN3DSD = ',NHN3DSD
         DO NN=1,NHN3DSD
            WRITE(2,*) 'ISDHOUT(',NN,') = ',ISDHOUT(NN)
         END DO
      ENDIF

C.... STATION 3D VELOCITY OUTPUT

      READ(15,*) I3DSV,TO3DS,TO3DF,NSPO3DSV,NHN3DSV
      WRITE(16,502) I3DSV
 502  FORMAT(/,5X,'I3DSV = ',I3)

      IF((I3DSV.LT.0).OR.(I3DSV.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,512)
         WRITE(16,512)
 512     FORMAT(/,2X,'    I3DSV MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DSV.EQ.0) WRITE(16,522)
 522  FORMAT(5X,'NO STATION 3D VELOCITY WILL BE OUTPUT')

      IF(I3DSV.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSSV=NINT(TSS)
         IF((TSS-NTSSSV).GE.0.5) NTSSSV=NTSSSV+1 !START AFTER T.S.
         IF(NTSSSV.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,532) TO3DS
            WRITE(16,532) TO3DS
 532        FORMAT(5X,'NOTE: TO3DSSV = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSSV=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFSV=NINT(TSF)
         IF((TSF-NTSFSV).GE.0.5) NTSFSV=NTSFSV+1 !END T.S.
         IF(NTSFSV.LT.NTSSSV) THEN
            IF(NSCREEN.NE.0) WRITE(6,542) TO3DF
            WRITE(16,542) TO3DF
 542        FORMAT(5X,'NOTE: TO3DFSV = ',E14.6,' < TO3DSSV. ',
     &           'IT HAS BEEN RESET = TO3DSSV.')
            TO3DF=TO3DS
            NTSFSV=NTSSSV
         ENDIF
         IF(NTSFSV.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,552) TO3DF
            WRITE(16,552) TO3DF
 552        FORMAT(5X,'NOTE: TO3DFSV = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFSV=NT
         ENDIF
         IF(NSPO3DSV.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,562) NSPO3DSV
            ENDIF
            WRITE(16,350)
            WRITE(16,562) NSPO3DSV
 562        FORMAT(2X,'    NSPO3DSV = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISVHOUT(N),N=1,NHN3DSV)

         NDSETSV = (NTSFSV-NTSSSV)/NSPO3DSV !NUMBER OF DATA SETS
         NSSV=-1                !COUNTER

         WRITE(16,572) NSPO3DSV,TO3DS,NTSSSV,TO3DF,NTSFSV,
     &        NSPO3DSV,NHN3DSV
 572     FORMAT(5X,'STATION 3D VELOCITY WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSSV.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     &        'SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFSV =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 42 EVERY',
     &        ' NSPO3DSV = ',I7,' TIME STEPS',
     &        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DSV.EQ.1) THEN
         WRITE(16,497) 42
         OPEN(42,FILE=DIRNAME//'/'//'fort.42')
         WRITE(42,499) RUNDES,RUNID,AGRID
         WRITE(42,498) NDSETSV,DELT*NSPO3DSV,NSPO3DSV,NHN3DSV,NFEN
         WRITE(42,*) ' '
      ENDIF

      IF(I3DSV.EQ.2) THEN
         WRITE(16,496) 42
      OPEN(42,FILE=DIRNAME//'/'//'fort.42',ACCESS='DIRECT',RECL=NBYTE)
         ISVREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RID4(N)
            ENDDO
            DO N=1,6
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) RID8(N)
            ENDDO
            DO N=1,3
               ISVREC=ISVREC+1
               WRITE(42,REC=ISVREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(42,REC=ISVREC+1) NDSETSV
         WRITE(42,REC=ISVREC+2) DELT*NSPO3DSV
         WRITE(42,REC=ISVREC+3) NSPO3DSV
         WRITE(42,REC=ISVREC+4) NHN3DSV
         WRITE(42,REC=ISVREC+5) NFEN
         ISVREC=ISVREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DSV, NTSSSV, NSPO3DSV = ',I3DSV,NTSSSV,NSPO3DSV
         WRITE(2,*) 'NHN3DSV = ',NHN3DSV
         DO NN=1,NHN3DSV
            WRITE(2,*) 'ISVHOUT(',NN,') = ',ISVHOUT(NN)
         END DO
      ENDIF

C.... STATION 3D TURBULENCE OUTPUT

      READ(15,*) I3DST,TO3DS,TO3DF,NSPO3DST,NHN3DST
      WRITE(16,503) I3DST
 503  FORMAT(/,5X,'I3DST = ',I3)

      IF((I3DST.LT.0).OR.(I3DST.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,513)
         WRITE(16,513)
 513     FORMAT(/,2X,'    I3DST MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DST.EQ.0) WRITE(16,523)
 523  FORMAT(5X,'NO STATION 3D TURBULENCE WILL BE OUTPUT')

      IF(I3DST.GT.0) THEN
        TSS=(TO3DS-STATIME)*day2sec/DELT
        NTSSST=NINT(TSS)
        IF((TSS-NTSSST).GE.0.5) NTSSST=NTSSST+1      !START AFTER T.S.
        IF(NTSSST.LT.0) THEN
          IF(NSCREEN.NE.0) WRITE(6,533) TO3DS
            WRITE(16,533) TO3DS
 533        FORMAT(5X,'NOTE: TO3DSST = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSST=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFST=NINT(TSF)
         IF((TSF-NTSFST).GE.0.5) NTSFST=NTSFST+1 !END T.S.
         IF(NTSFST.LT.NTSSST) THEN
            IF(NSCREEN.NE.0) WRITE(6,543) TO3DF
            WRITE(16,543) TO3DF
 543        FORMAT(5X,'NOTE: TO3DFST = ',E14.6,' < TO3DSST. ',
     &           'IT HAS BEEN RESET = TO3DSST.')
            TO3DF=TO3DS
            NTSFST=NTSSST
         ENDIF
         IF(NTSFST.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,553) TO3DF
            WRITE(16,553) TO3DF
 553        FORMAT(5X,'NOTE: TO3DFST = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFST=NT
         ENDIF
         IF(NSPO3DST.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,563) NSPO3DST
            ENDIF
            WRITE(16,350)
            WRITE(16,563) NSPO3DST
 563        FORMAT(2X,'    NSPO3DST = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         READ(15,*) (ISTHOUT(N),N=1,NHN3DST)

         NDSETST = (NTSFST-NTSSST)/NSPO3DST !NUMBER OF DATA SETS
         NSST=-1                !COUNTER

         WRITE(16,573) NSPO3DST,TO3DS,NTSSST,TO3DF,NTSFST,
     &        NSPO3DST,NHN3DST
 573     FORMAT(5X,'STATION 3D TURBULENCE WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSST.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE ',
     &        'SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFST =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 43 EVERY',
     &        ' NSPO3DST = ',I7,' TIME STEPS',
     &        /,5X,' OUTPUT WILL BE AT ',I6,' STATIONS')
      ENDIF

      IF(I3DST.EQ.1) THEN
         WRITE(16,497) 43
         OPEN(43,FILE=DIRNAME//'/'//'fort.43')
         WRITE(43,499) RUNDES,RUNID,AGRID
         WRITE(43,498) NDSETST,DELT*NSPO3DST,NSPO3DST,NHN3DST,NFEN
         WRITE(43,*) ' '
      ENDIF

      IF(I3DST.EQ.2) THEN
         WRITE(16,496) 43
      OPEN(43,FILE=DIRNAME//'/'//'fort.43',ACCESS='DIRECT',RECL=NBYTE)
         ISTREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RDES4(N)
            ENDDO
            DO N=1,6
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RID4(N)
            ENDDO
            DO N=1,6
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RDES8(N)
            ENDDO
            DO N=1,3
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) RID8(N)
            ENDDO
            DO N=1,3
               ISTREC=ISTREC+1
               WRITE(43,REC=ISTREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(43,REC=ISTREC+1) NDSETST
         WRITE(43,REC=ISTREC+2) DELT*NSPO3DST
         WRITE(43,REC=ISTREC+3) NSPO3DST
         WRITE(43,REC=ISTREC+4) NHN3DST
         WRITE(43,REC=ISTREC+5) NFEN
         ISTREC=ISTREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DST, NTSSST, NSPO3DST = ',I3DST,NTSSST,NSPO3DST
         WRITE(2,*) 'NHN3DST = ',NHN3DST
         DO NN=1,NHN3DST
            WRITE(2,*) 'ISTHOUT(',NN,') = ',ISTHOUT(NN)
         END DO
      ENDIF

C.... GLOBAL 3D DENSITY, TEMPERATURE, SALINITY OUTPUT

      READ(15,*) I3DGD,TO3DS,TO3DF,NSPO3DGD
      WRITE(16,504) I3DGD
 504  FORMAT(/,5X,'I3DGD = ',I3)

      IF((I3DGD.LT.0).OR.(I3DGD.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,514)
         WRITE(16,514)
 514     FORMAT(/,2X,'    I3DGD MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGD.EQ.0) WRITE(16,524)
 524  FORMAT(5X,'NO GLOBAL 3D D,T,S WILL BE OUTPUT')

      IF(I3DGD.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGD=NINT(TSS)
         IF((TSS-NTSSGD).GE.0.5) NTSSGD=NTSSGD+1 !START AFTER T.S.
         IF(NTSSGD.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,534) TO3DS
            WRITE(16,534) TO3DS
 534        FORMAT(5X,'NOTE: TO3DSGD = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGD=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGD=NINT(TSF)
         IF((TSF-NTSFGD).GE.0.5) NTSFGD=NTSFGD+1 !END T.S.
         IF(NTSFGD.LT.NTSSGD) THEN
            IF(NSCREEN.NE.0) WRITE(6,544) TO3DF
            WRITE(16,544) TO3DF
 544        FORMAT(5X,'NOTE: TO3DFGD = ',E14.6,' < TO3DSGD. ',
     &           'IT HAS BEEN RESET = TO3DSGD.')
            TO3DF=TO3DS
            NTSFGD=NTSSGD
         ENDIF
         IF(NTSFGD.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,554) TO3DF
            WRITE(16,554) TO3DF
 554        FORMAT(5X,'NOTE: TO3DFGD = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFGD=NT
         ENDIF
         IF(NSPO3DGD.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,564) NSPO3DGD
            ENDIF
            WRITE(16,350)
            WRITE(16,564) NSPO3DGD
 564        FORMAT(2X,'    NSPO3DGD = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGD = (NTSFGD-NTSSGD)/NSPO3DGD !NUMBER OF DATA SETS
         NSGD = -1              !COUNTER

         WRITE(16,574) NSPO3DGD,TO3DS,NTSSGD,TO3DF,NTSFGD,
     &        NSPO3DGD
 574     FORMAT(5X,'GLOBAL 3D D,S,T WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSGD.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFGD =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 44 EVERY',
     &        ' NSPO3DGD = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGD.EQ.1) THEN
         WRITE(16,497) 44
         OPEN(44,FILE=DIRNAME//'/'//'fort.44')
         WRITE(44,499) RUNDES,RUNID,AGRID
         WRITE(44,498) NDSETGD,DELT*NSPO3DGD,NSPO3DGD,NP,NFEN
         WRITE(44,*) ' '
      ENDIF

      IF(I3DGD.EQ.2) THEN
         WRITE(16,496) 44
      OPEN(44,FILE=DIRNAME//'/'//'fort.44',ACCESS='DIRECT',RECL=NBYTE)
         IGDREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RID4(N)
            ENDDO
            DO N=1,6
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) RID8(N)
            ENDDO
            DO N=1,3
               IGDREC=IGDREC+1
               WRITE(44,REC=IGDREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(44,REC=IGDREC+1) NDSETGD
         WRITE(44,REC=IGDREC+2) DELT*NSPO3DGD
         WRITE(44,REC=IGDREC+3) NSPO3DGD
         WRITE(44,REC=IGDREC+4) NP
         WRITE(44,REC=IGDREC+5) NFEN
         IGDREC=IGDREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGD, NTSSGD, NSPO3DGD = ',I3DGD,NTSSGD,NSPO3DGD
      ENDIF

C.... GLOBAL 3D VELOCITY OUTPUT

      READ(15,*) I3DGV,TO3DS,TO3DF,NSPO3DGV
      WRITE(16,505) I3DGV
 505  FORMAT(/,5X,'I3DGV = ',I3)

      IF((I3DGV.LT.0).OR.(I3DGV.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,515)
         WRITE(16,515)
 515     FORMAT(/,2X,'    I3DGV MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGV.EQ.0) WRITE(16,525)
 525  FORMAT(5X,'NO GLOBAL 3D VELOCITY WILL BE OUTPUT')

      IF(I3DGV.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGV=NINT(TSS)
         IF((TSS-NTSSGV).GE.0.5) NTSSGV=NTSSGV+1 !START AFTER T.S.
         IF(NTSSGV.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,535) TO3DS
            WRITE(16,535) TO3DS
 535        FORMAT(5X,'NOTE: TO3DSGV = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGV=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGV=NINT(TSF)
         IF((TSF-NTSFGV).GE.0.5) NTSFGV=NTSFGV+1 !END T.S.
         IF(NTSFGV.LT.NTSSGV) THEN
            IF(NSCREEN.NE.0) WRITE(6,545) TO3DF
            WRITE(16,545) TO3DF
 545        FORMAT(5X,'NOTE: TO3DFGV = ',E14.6,' < TO3DSGV. ',
     &           'IT HAS BEEN RESET = TO3DSGV.')
            TO3DF=TO3DS
            NTSFGV=NTSSGV
         ENDIF
         IF(NTSFGV.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,555) TO3DF
            WRITE(16,555) TO3DF
 555        FORMAT(5X,'NOTE: TO3DFGV = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFGV=NT
         ENDIF
         IF(NSPO3DGV.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,565) NSPO3DGV
            ENDIF
            WRITE(16,350)
            WRITE(16,565) NSPO3DGV
 565        FORMAT(2X,'    NSPO3DGV = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGV = (NTSFGV-NTSSGV)/NSPO3DGV !NUMBER OF DATA SETS
         NSGV = -1              !COUNTER

         WRITE(16,575) NSPO3DGV,TO3DS,NTSSGV,TO3DF,NTSFGV,
     &        NSPO3DGV
 575     FORMAT(5X,'GLOBAL 3D VELOCITY WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSGV.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFGV =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 45 EVERY',
     &        ' NSPO3DGV = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGV.EQ.1) THEN
         WRITE(16,497) 45
         OPEN(45,FILE=DIRNAME//'/'//'fort.45')
         WRITE(45,499) RUNDES,RUNID,AGRID
         WRITE(45,498) NDSETGV,DELT*NSPO3DGV,NSPO3DGV,NP,NFEN
         WRITE(45,*) ' '
      ENDIF

      IF(I3DGV.EQ.2) THEN
         WRITE(16,496) 45
      OPEN(45,FILE=DIRNAME//'/'//'fort.45',ACCESS='DIRECT',RECL=NBYTE)
         IGVREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RID4(N)
            ENDDO
            DO N=1,6
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) RID8(N)
            ENDDO
            DO N=1,3
               IGVREC=IGVREC+1
               WRITE(45,REC=IGVREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(45,REC=IGVREC+1) NDSETGV
         WRITE(45,REC=IGVREC+2) DELT*NSPO3DGV
         WRITE(45,REC=IGVREC+3) NSPO3DGV
         WRITE(45,REC=IGVREC+4) NP
         WRITE(45,REC=IGVREC+5) NFEN
         IGVREC=IGVREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGV, NTSSGV, NSPO3DGV = ',I3DGV,NTSSGV,NSPO3DGV
      ENDIF

C.... GLOBAL 3D TURBULENCE OUTPUT

      READ(15,*) I3DGT,TO3DS,TO3DF,NSPO3DGT
      WRITE(16,506) I3DGT
 506  FORMAT(/,5X,'I3DGT = ',I3)

      IF((I3DGT.LT.0).OR.(I3DGT.GT.2)) THEN
         IF(NSCREEN.NE.0) WRITE(6,516)
         WRITE(16,516)
 516     FORMAT(/,2X,'    I3DGT MUST BE 0,1 OR 2')
         STOP
      ENDIF

      IF(I3DGT.EQ.0) WRITE(16,526)
 526  FORMAT(5X,'NO GLOBAL 3D TURBULENCE INFORMATION WILL BE OUTPUT')

      IF(I3DGT.GT.0) THEN
         TSS=(TO3DS-STATIME)*day2sec/DELT
         NTSSGT=NINT(TSS)
         IF((TSS-NTSSGT).GE.0.5) NTSSGT=NTSSGT+1 !START AFTER T.S.
         IF(NTSSGT.LT.0) THEN
            IF(NSCREEN.NE.0) WRITE(6,536) TO3DS
            WRITE(16,536) TO3DS
 536        FORMAT(5X,'NOTE: TO3DSGT = ',E14.6,' < START TIME. ',
     &           'IT HAS BEEN RESET = START TIME.')
            TO3DS=STATIME
            NTSSGT=0
         ENDIF
         TSF=(TO3DF-STATIME)*day2sec/DELT
         NTSFGT=NINT(TSF)
         IF((TSF-NTSFGT).GE.0.5) NTSFGT=NTSFGT+1 !END T.S.
         IF(NTSFGT.LT.NTSSGT) THEN
            IF(NSCREEN.NE.0) WRITE(6,546) TO3DF
            WRITE(16,546) TO3DF
 546        FORMAT(5X,'NOTE: TO3DFGT = ',E14.6,' < TO3DSGT. ',
     &           'IT HAS BEEN RESET = TO3DSGT.')
            TO3DF=TO3DS
            NTSFGT=NTSSGT
         ENDIF
         IF(NTSFGT.GT.NT) THEN
            IF(NSCREEN.NE.0) WRITE(6,556) TO3DF
            WRITE(16,556) TO3DF
 556        FORMAT(5X,'NOTE: TO3DFGT = ',E14.6,' > RNDAY. ',
     &           'IT HAS BEEN RESET = RNDAY.')
            NTSFGT=NT
         ENDIF
         IF(NSPO3DGT.EQ.0) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,566) NSPO3DGT
            ENDIF
            WRITE(16,350)
            WRITE(16,566) NSPO3DGT
 566        FORMAT(2X,'    NSPO3DGT = ',I3,' IT MUST BE > 0')
            STOP
         ENDIF

         NDSETGT = (NTSFGT-NTSSGT)/NSPO3DGT !NUMBER OF DATA SETS
         NSGT = -1              !COUNTER

         WRITE(16,576) NSPO3DGT,TO3DS,NTSSGT,TO3DF,NTSFGT,
     &        NSPO3DGT
 576     FORMAT(5X,'GLOBAL 3D TURBULENCE WILL BE OUTPUT STARTING',I9,
     &        /,9X,'TIMESTEPS AFTER TO3DSGT.  THIS =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'OUTPUT WILL STOP AFTER TO3DFGT =',F8.3,
     &        ' DAY(S) RELATIVE TO',
     &        /,9X,'THE STARTING TIME OR ',I9,' TIME STEPS INTO THE',
     &        ' SIMULATION',
     &        /,5X,'INFORMATION WILL BE SPOOLED TO UNIT 46 EVERY',
     &        ' NSPO3DGT = ',I7,' TIME STEPS')
      ENDIF

      IF(I3DGT.EQ.1) THEN
         WRITE(16,497) 46
         OPEN(46,FILE=DIRNAME//'/'//'fort.46')
         WRITE(46,499) RUNDES,RUNID,AGRID
         WRITE(46,498) NDSETGT,DELT*NSPO3DGT,NSPO3DGT,NP,NFEN
         WRITE(46,*) ' '
      ENDIF

      IF(I3DGT.EQ.2) THEN
         WRITE(16,496) 46
      OPEN(46,FILE=DIRNAME//'/'//'fort.46',ACCESS='DIRECT',RECL=NBYTE)
         IGTREC=0
         IF(NBYTE.EQ.4) THEN
            DO N=1,8
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RDES4(N)
            ENDDO
            DO N=1,6
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RID4(N)
            ENDDO
            DO N=1,6
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) AID4(N)
            ENDDO
         ENDIF
         IF(NBYTE.EQ.8) THEN
            DO N=1,4
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RDES8(N)
            ENDDO
            DO N=1,3
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) RID8(N)
            ENDDO
            DO N=1,3
               IGTREC=IGTREC+1
               WRITE(46,REC=IGTREC) AID8(N)
            ENDDO
         ENDIF
         WRITE(46,REC=IGTREC+1) NDSETGT
         WRITE(46,REC=IGTREC+2) DELT*NSPO3DGT
         WRITE(46,REC=IGTREC+3) NSPO3DGT
         WRITE(46,REC=IGTREC+4) NP
         WRITE(46,REC=IGTREC+5) NFEN
         IGTREC=IGTREC+5
      ENDIF
      
      WRITE(16,*) ' '

      IF(IDIAG.EQ.2) THEN
         WRITE(2,*) 'I3DGT, NTSSGT, NSPO3DGT = ',I3DGT,NTSSGT,NSPO3DGT
      ENDIF

C.....COMPUTE SOME PARAMETERS

      IDTAlp1 = I*DELT*ALP1
      IDT1MAlp1 = I*DELT*(1.-ALP1)
      DTAlp3 = DELT*ALP3
      DT1MAlp3 = DELT*(1-ALP3)
      DTAlp2 = DELT*ALP2
      DT1MAlp2 = DELT*(1.-ALP2)

      RETURN
      END SUBROUTINE READ_INPUT_3DVS

c******************************************************************************
c******************************************************************************

      SUBROUTINE VSSTUP(DELT,NT)

      USE GLOBAL_3DVS
      REAL(SZ) :: DELT
      INTEGER :: NT

      REAL :: RealPartOfQ     
      REAL :: ImaginaryPartOfQ

      I=(0.0d0,1.0d0)                !r.l. initialize in global_3dv?

C...  
C...  COLD START PROBLEM SETUP
C...  
      IF(IHOT.EQ.0) THEN

C...  IF A BAROCLINIC RUN, READ IN INITIAL DENSITY FIELD

         IF(IDEN.GT.0) THEN
            WRITE(16,424)
 424        FORMAT(/,5X,'INITIAL DENSITY FIELD READ IN FROM UNIT 11',/)
            OPEN(11,FILE=DIRNAME//'/'//'fort.11')
            READ(11,*)          !skip over header line
            READ(11,*)          !skip over header line
            READ(11,*) NVN
            IF(NVN.NE.NFEN) THEN
               WRITE(16,351) NVN,NFEN
               WRITE(*,351) NVN,NFEN
 351        FORMAT(/,2X,'***** INVALID INPUT IN THE DENSITY INITIAL ',
     &              'CONDITION FILE (UNIT 11) *****',
     &              /,2X,'***** NVN = ',I4,' MUST MATCH NFEN = ',I4,
     &              ' *****',
     &              /,10X,'****** RUN TERMINATED ******')
               STOP
            ENDIF
            DO IHN=1,NP
               DO IVN=1,NFEN
                  READ(11,*) NHNN,NVNN,SIGT(NHNN,NVNN),TEMP(NHNN,NVNN),
     &                 SAL(NHNN,NVNN)
               END DO
            END DO
            CLOSE(11)
         ENDIF

C...  ZERO OUT STUFF PASSED FROM 3D SOLUTION TO EXTERNAL MODE

         DO NH=1,NP
            DUU(NH)=0.d0
            DUV(NH)=0.d0
            DVV(NH)=0.d0
            UU(NH)=0.d0
            VV(NH)=0.d0
            BSX(NH)=0.d0
            BSY(NH)=0.d0
            VIDBCPDX(NH)=0.d0
            VIDBCPDY(NH)=0.d0
         ENDDO

C...  INITIALIZE 3D VELOCITY AND TURBULENCE SOLUTION
         
         DO NH=1,NP
            DO N=1,NFEN
               Q(NH,N)=(0.d0,0.d0)
               q20(NH,N)=0.d0
               l(NH,N)=0.d0
               wz(NH,N)=0.d0
            ENDDO
         ENDDO
C...  
C...  END COLD START PROBLEM SETUP
C...  
      ENDIF


C...  
C...  HOT START PROBLEM SETUP
C...  
      IF(IHOT.NE.0) THEN

         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSSD
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISDREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSSV
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISVREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSST
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) ISTREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGD
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGDREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGV
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGVREC
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) NSGT
         IHOTSTP=IHOTSTP+1
         READ(IHOT,REC=IHOTSTP) IGTREC

         DO NH=1,NP
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DUU(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DUV(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) DVV(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) UU(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VV(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) BSX(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) BSY(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VIDBCPDX(NH)
            IHOTSTP=IHOTSTP+1
            READ(IHOT,REC=IHOTSTP) VIDBCPDY(NH)
         ENDDO

         DO NH=1,NP
            DO N=1,NFEN
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) RealPartOfQ
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) ImaginaryPartOfQ
               Q(NH,N) = RealPartOfQ + I*ImaginaryPartOfQ
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) WZ(NH,N)
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) q20(NH,N)
               IHOTSTP=IHOTSTP+1
               READ(IHOT,REC=IHOTSTP) l(NH,N)
               IF(IDEN.EQ.1) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SIGT(NH,N)
               ENDIF
               IF(IDEN.EQ.2) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SAL(NH,N)
                  TEMP(NH,N)=0.d0
                  SIGT(NH,N)=0.d0 !Need to fix this
               ENDIF
               IF(IDEN.EQ.3) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) TEMP(NH,N)
                  SAL(NH,N)=0.d0
                  SIGT(NH,N)=0.d0 !Need to fix this
               ENDIF
               IF(IDEN.EQ.4) THEN
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) SAL(NH,N)
                  IHOTSTP=IHOTSTP+1
                  READ(IHOT,REC=IHOTSTP) TEMP(NH,N)
               ENDIF
            ENDDO
         ENDDO
C...  
C...  END HOT START PROBLEM SETUP
C...  
      ENDIF


C...  
C...  ADDITIONAL RUN SETUP
C...  

C...  COMPUTE THE INTEGRALS Inm and LVn (INDEPENDENT OF HORIZONTAL NODE)
      
      IF(IDIAG.EQ.2) WRITE(2,*) '********** VSSETUP **********'
c     CALL InmInt(Inm)
      CALL InmInt()
      IF(IDIAG.EQ.2) WRITE(2,*) '********** VSSETUP **********'
      CALL LVnInt(LVn)


      RETURN
      END SUBROUTINE VSSTUP

 

c******************************************************************************
c  SUBROUTINE VSSOL                                                           *
c                                                                             *
c  Note, the following time stepping coefficients are computed in             *
C     VSSTUP and passed in a common block.                                    *
c                                                                             *
c  IDTAlp1      = I*DelT*Alp1        - weights coriolis term in LHS matrix    *
c  IDT1MAlp1    = I*DelT*(1.-Alp1)   - weights coriolis term in RHS forcing   *
c  DTAlp3       = DelT*Alp3          - weights vert diff term in LHS matrix   *
c  DT1MAlp3     = DelT*(1-Alp3)      - weights vert diff term in RHS forcing  *
c  DTAlp2       = DelT*Alp2          - weights bot stress term in LHS matrix  *
c  DT1MAlp2     = DelT*(1.-Alp2)     - weights bot stress term in RHS forcing *
c                                                                             *
c  q(MNP,MNodes) - 3D Complex Velocity field (GAMMA) from past time step.     *
c                                                                             *
c                                                                             *
c  NH - horizontal node counter                                               *
c  NP - number of nodes in horizontal grid                                    *
c  NFEN - number of nodes in the vertical grid                                *
c  BTP - total barotropic pressure (atmos press, water level, tidal potential)*
c                 at time levels s+1/2                                        *
c******************************************************************************

      SUBROUTINE VSSOL(IT,Time,DelT)

      USE GLOBAL_3DVS
#ifdef CMPI
      USE MESSENGER
      IMPLICIT NONE
      REAL(SZ) :: DUMV1(1),DUMV2(1)
#endif

      INTEGER :: IT
      INTEGER :: NEle           !local value of NetTabEle
      INTEGER :: k              !vertical node loop counter (1-bottom, NFEN-surf)
      INTEGER :: NH             !horizontal node loop counter
      INTEGER :: N              !neighbor node loop counter
      INTEGER :: N1,N2,N3,NNFirst !local node numbers used to compute gradients
      INTEGER :: LBP            !value of LBArray_Pointer at present horizontal node
      INTEGER :: NN             !output loop counter

      REAL(SZ) :: DelT          !time step in sec
      REAL(SZ) :: KSlip         !equavalent linear slip coeff
      REAL(SZ) :: WSXsNH,WSYsNH !Wind stress components at time level s at node NH

      REAL(SZ) :: WSigma(MNodes) !"sigma" vertical velocity
      REAL(SZ) :: Wf            !weighting coefficient in adjoint correction to w
      REAL(SZ) :: WfOHH         !Wf/(H time level s+1)^2
      REAL(SZ) :: WZSurfBC      !surface boundary condition value of w
      REAL(SZ) :: WZSurf        !computed value of w at surface
      REAL(SZ) :: WZCorrection  !adjoint correction compute for w

      REAL(SZ) :: Zk            !z depth of any node k in the vertical
      REAL(SZ) :: DelSig        ! sigma(k+1)-sigma(k)
      REAL(SZ) :: DelSigO2      !(sigma(k)-sigma(k-1))/2
      REAL(SZ) :: SigmaMAOAMB   !(sigma(k)-A)/(a-b)
      REAL(SZ) :: SigmaMBOAMB   !(sigma(k)-B)/(a-b)
      REAL(SZ) :: SigAvgMAOAMB  !((sigma(k)+sigma(k-1))/2.d0 - A)/AMB
      REAL(SZ) :: SigmaNN       !Sigma value of a neighbor node

      REAL(SZ) :: EV(MNP,MNodes) !archive of all EVTot values at previous time step

      REAL(SZ) :: VelNorm,VelTan !-QNormsp1(NH)/Hsp1 at flux boundary node
      REAL(SZ) :: CLBP,SLBP     !local values of CSII, SIII at boundary node LBP
      REAL(SZ) :: Auv1km1,Auv2km1 !initial real,imaginary parts of Mkm1 at flux boundary node
      REAL(SZ) :: Auv1km1star,Auv2km1star !rotated real,imaginary parts of Mkm1 at flux boundary node
      REAL(SZ) :: Auv1k1,Auv2k1 !initial real,imaginary parts of Mk at flux boundary node
      REAL(SZ) :: Auv1k1star,Auv2k1star !rotated real,imaginary parts of Mk at flux boundary node
      REAL(SZ) :: Auv1kp1,Auv2kp1 !initial real,imaginary parts of Mkp1 at flux boundary node
      REAL(SZ) :: Auv1kp1star,Auv2kp1star !rotated real,imaginary parts of Mkp1 at flux boundary node

      REAL(SZ) :: EtaN1,EtaN2,EtaN3,EtaNFirst !nodal values of NolIFA(Eta1+Eta2)/2
      REAL(SZ) :: hN1,hN2,hN3,hNFirst !nodal values of DP
      REAL(SZ) :: DUDX(MNodes),DVDY(MNodes) !horizontal derivatives of velocity used to compute w
      REAL(SZ) :: Un,Vn         !real,imaginary components of qn
      REAL(SZ) :: DelU,DelV     !real, imaginary parts of q(k)-q(k-1)

      REAL(SZ) :: BTPN1,BTPN2,BTPN3,BTPNFirst !nodal values of BTP
      REAL(SZ) :: BTPDX2A,BTPDY2A !(Horiz. grads of BTP)*2*Element Area

      REAL(SZ) :: BCPN1,BCPN2,BCPN3,BCPNFirst !nodal values of BCP
      REAL(SZ) :: BCPDX2A,BCPDY2A !(Horiz. grads of BCP)*2*Element Area
      REAL(SZ) :: SigTAvg       !avg SigT between 2 vertical nodes
      REAL(SZ) :: HGORhoOAMB    !depth*gravity/(reference density)/(a-b)

      REAL(SZ) :: DBCPDX2A  
      REAL(SZ) :: DBCPDY2A  
      REAL(SZ) :: RCL       
      REAL(SZ) :: Auv1k
      REAL(SZ) :: Auv2k
      REAL(SZ) :: Auv1kstar
      REAL(SZ) :: Auv2kstar

      REAL(8) :: KVnm(MNodes,3) !integral used in vertical stress term
      REAL(8) :: Time           !model time at time level s+1
      REAL(8) :: DEtaDT         !time derivative of water surface elev
      REAL(8) :: DEtaDX,DEtaDY  !horizontal derivatives of water surface elev at time level s
      REAL(8) :: DEtaDX2A,DEtaDY2A !(DEtaDX,DEtaDY)*2*Element Area 
      REAL(8) :: DhDX,DhDY      !horizontal derivatives of DP
      REAL(8) :: DhDX2A,DhDY2A  !(DhDX,DhDY)*2*Element Area
      REAL(8) :: TotalArea2     !2*Area of all elements around a node
      REAL(8) :: TotalBCPGArea2 !2*Area of all elements around a node used to compute the BCPG
      REAL(8) :: a1,a2,a3,b1,b2,b3 !elemental coefficients used in horizontal FE method

      REAL(8) :: Hs             !Total water depth at time level s
      REAL(8) :: HsN2           !Total water depth at time level s at local node N2
      REAL(8) :: HsOAMB         !Hs/(a-b)
      REAL(8) :: HsHsOAMBAMB    !(Hs/(a-b))^2
      REAL(8) :: Hsp1           !Total water depth at time level s+1
      REAL(8) :: Hsp1OAMB       !Hsp1/(a-b)
      REAL(8) :: Hsp1Hsp1OAMBAMB !(Hsp1/(a-b))^2

      COMPLEX :: Fr(MNodes)     !right side forcing vector
      COMPLEX :: Frstar         !rotated right side forcing vector at flux boundary node 
      COMPLEX :: Mkm1(MNodes)   !1st column (k-1) in left side compact storage matrix
      COMPLEX :: Mk(MNodes)     !2nd column (k) in left side compact storage matrix
      COMPLEX :: Mkp1(MNodes)   !3rd column (k+1) in left side cpmpact storage matrix
      COMPLEX :: LAdvec(MNodes) !lateral advection term in momentum eqn
      COMPLEX :: LStress(MNodes) !lateral stress term in momentum eqn
      COMPLEX :: VAdvec(MNodes) !vertical advection term in momentum eqn
      COMPLEX :: VStress(MNodes) !vertical stress term in momentum eqn
      COMPLEX :: BCPG(MNodes)   !baroclinic pressure gradient
      COMPLEX :: BTPG           !total barotropic pressure gradient (incl TP & water level)
      COMPLEX :: CCR,CCL        !coeffs used on right,left side of momentum eqn
      COMPLEX :: VIBCPG         !vertically integrated baroclinic pressure gradient at a node
      COMPLEX :: VIVel          !vertically integrated velocity
      COMPLEX :: DUDS           !complex vertical velocity gradient between bottom two nodes
      COMPLEX :: qn,qN1,qN2,qN3,qNFirst !nodal values of q
      COMPLEX :: UnDqDX,VnDqDY  !derivatives used in lateral advection
      COMPLEX :: UnDqDX2A,VnDqDY2A !UnDqDX,UnDqDY)*2*Element Area
      COMPLEX :: DqDXDPhiDX2A,DqDYDPhiDY2A !derivatives used in lateral stress calc.
      COMPLEX :: DqDSigmakm1,DqDSigmakp1 !vertical deriv. of q from k-1,k and k,k+1
      COMPLEX :: DqDX2A(MNodes) !horizontal derivatives of complex
      COMPLEX :: DqDY2A(MNodes) !          velocity used in w calc

C     
C     INCREMENT THE TIMESTEP SINCE START COUNTER
C     
      istart=istart+1

C*************************************************************************************
C     Check whether it is time to print various 3D outputs      


 1100 FORMAT(1X,E16.10,1X,I10,32000(2X,E12.6))

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION DENSITY,
C     TEMPERATURE, SALINITY OUTPUT IF SO, WRITE TIME AND TIME STEP INTO
C     FILE
C     
      IF(I3DSD.GT.0) THEN
         IF((IT.GT.NTSSSD).AND.(NSSD.LT.0)) NSSD=0
         IF((IT.GT.NTSSSD).AND.(IT.LE.NTSFSD)) NSSD=NSSD+1
         IF(NSSD.EQ.NSPO3DSD) THEN
            NSSD=0
            IF(I3DSD.EQ.1) WRITE(41,1100) TIME,IT,
     &           (SIGMA(k),SIGMA(k),SIGMA(k),k=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DSD.EQ.2) THEN
               WRITE(41,REC=ISDREC+1) TIME
               WRITE(41,REC=ISDREC+2) IT
               ISDREC = ISDREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION VELOCITY OUTPUT
C     IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DSV.GT.0) THEN
         IF((IT.GT.NTSSSV).AND.(NSSV.LT.0)) NSSV=0
         IF((IT.GT.NTSSSV).AND.(IT.LE.NTSFSV)) NSSV=NSSV+1
         IF(NSSV.EQ.NSPO3DSV) THEN
            NSSV=0
            IF(I3DSV.EQ.1) WRITE(42,1100) TIME,IT,
     &           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DSV.EQ.2) THEN
               WRITE(42,REC=ISVREC+1) TIME
               WRITE(42,REC=ISVREC+2) IT
               ISVREC = ISVREC + 2
            ENDIF
         ENDIF
      ENDIF


C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D STATION TURBULENCE
C     PARAMETER OUTPUT IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DST.GT.0) THEN
         IF((IT.GT.NTSSST).AND.(NSST.LT.0)) NSST=0
         IF((IT.GT.NTSSST).AND.(IT.LE.NTSFST)) NSST=NSST+1
         IF(NSST.EQ.NSPO3DST) THEN
            NSST=0
            IF(I3DST.EQ.1) WRITE(43,1100) TIME,IT,
     &           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DST.EQ.2) THEN
               WRITE(43,REC=ISTREC+1) TIME
               WRITE(43,REC=ISTREC+2) IT
               ISTREC = ISTREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL DENSITY, TEMPERATURE
C     AND SALINITY IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGD.GT.0) THEN
         IF((IT.GT.NTSSGD).AND.(NSGD.LT.0)) NSGD=0
         IF((IT.GT.NTSSGD).AND.(IT.LE.NTSFGD)) NSGD=NSGD+1
         IF(NSGD.EQ.NSPO3DGD) THEN
            NSGD=0
            IF(I3DGD.EQ.1) WRITE(44,1100) TIME,IT,
     &           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGD.EQ.2) THEN
               WRITE(44,REC=IGDREC+1) TIME
               WRITE(44,REC=IGDREC+2) IT
               IGDREC = IGDREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL VELOCITY OUTPUT
C     IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGV.GT.0) THEN
         IF((IT.GT.NTSSGV).AND.(NSGV.LT.0)) NSGV=0
         IF((IT.GT.NTSSGV).AND.(IT.LE.NTSFGV)) NSGV=NSGV+1
         IF(NSGV.EQ.NSPO3DGV) THEN
            NSGV=0
            IF(I3DGV.EQ.1) WRITE(45,1100) TIME,IT,
     &           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGV.EQ.2) THEN
               WRITE(45,REC=IGVREC+1) TIME
               WRITE(45,REC=IGVREC+2) IT
               IGVREC = IGVREC + 2
            ENDIF
         ENDIF
      ENDIF

C     
C     CHECK TO SEE IF IT IS TIME TO PRINT 3D GLOBAL TURBULENCE PARAMETER
C     OUTPUT IF SO, WRITE TIME AND TIME STEP INTO FILE
C     
      IF(I3DGT.GT.0) THEN
         IF((IT.GT.NTSSGT).AND.(NSGT.LT.0)) NSGT=0
         IF((IT.GT.NTSSGT).AND.(IT.LE.NTSFGT)) NSGT=NSGT+1
         IF(NSGT.EQ.NSPO3DGT) THEN
            NSGT=0
            IF(I3DGT.EQ.1) WRITE(46,1100) TIME,IT,
     &           (SIGMA(N),SIGMA(N),SIGMA(N),N=1,NFEN-1),
     &           SIGMA(NFEN),SIGMA(NFEN)
            IF(I3DGT.EQ.2) THEN
               WRITE(46,REC=IGTREC+1) TIME
               WRITE(46,REC=IGTREC+2) IT
               IGTREC = IGTREC + 2
            ENDIF
         ENDIF
      ENDIF


C*************************************************************************************
C     Set up several variables that are needed for 3D run     

C     
C     Zero out surface stress and stress forcing at top for case of no wind
C     
      WSXsNH=0.d0
      WSYsNH=0.d0

C     
C     If a baroclinic run, compute the 3D baroclinic pressure field
C     The buoyancy field is defined as
C     BCP(z)    =(gravity/rho ref)*          integral (SigT) from surface down to z
C     BCP(sigma)=(gravity/rho ref)*(H/(a-b))*integral (SigT) from a down to sigma
C     where 
C     SigT = Sigma T = Rho - 1000 = density - 1000
C     SigT0 = Sigma t value of reference density (typically = 0)
C     Sigma = dimensionless vertical coordinate
C     
      IF(IDEN.EQ.1) THEN
         DO NH=1,NP             !loop over horizontal nodes
            Hs=DP(NH)+NolIFA*Eta1(NH) !total depth at previous (s) timestep
            HGORhoOAMB=GORhoOAMB*Hs !(gravity/rho ref)*(H/(a-b))
            BCP(NH,NFEN)=0.d0
            DO k=NFEN-1,1,-1    !loop over vertical nodes, starting at top and working down
               SigTAvg=(SigT(NH,k+1)+SigT(NH,k))/2.d0
               DelSig=Sigma(k+1)-Sigma(k)
               BCP(NH,k)=BCP(NH,k+1)+HGORhoOAMB*(SigTAvg-SigT0)*DelSig
            ENDDO
         ENDDO
#ifdef CMPI
C     Update BCP on ghost nodes
c     CALL UPDATER3D(BCP)  !!!!Don't know if this is needed at this time
#endif
      ENDIF


C*************************************************************************************
C     Compute 3D horizontal velocities     

C     
C     Loop over each horizontal node to compute the horizontal velocity
C     
      DO NH=1,NP                !loop over horizontal nodes

c     Set up some values at the node being worked on

         Hs  = DP(NH)+NolIFA*Eta1(NH) !Total depth at previous (s) timestep
         HsOAMB=Hs/AMB
         HsHsOAMBAMB=HsOAMB*HsOAMB
         Hsp1= DP(NH)+NolIFA*Eta2(NH) !Total depth at present (s+1) timestep
         Hsp1OAMB=Hsp1/AMB
         Hsp1Hsp1OAMBAMB=Hsp1OAMB*Hsp1OAMB

         IF(NWS.NE.0) THEN      !wind stress
            WSXsNH=WSX1(NH)
            WSYsNH=WSY1(NH)
         ENDIF

c     If specified normal flow boundary node with no tangential slip is
c     lateral boundary condition, set up the matrix immediately and skip
c     to the solution

         LBP=LBArray_Pointer(NH)
         IF(LBP.GT.0) THEN
                                !essential normal flow
            IF((LBCodeI(LBP).GE.10).AND.(LBCodeI(LBP).LE.19)) THEN 
               VelNorm=-QNormsp1(LBP)/Hsp1 !with essential no tan.
               VelTan=0.D0
               SLBP=SIII(LBP)
               CLBP=CSII(LBP)
               DO k=1,NFEN
                  Mkm1(k)=(0.D0,0.D0)
                  Mk(k)=SLBP+I*CLBP
                  Mkp1(k)=(0.D0,0.D0)
                  Fr(k)=VelTan+I*VelNorm
C                  EVTot(k)=0.D0 !f77diff??
               END DO
               GOTO 999
            ENDIF
         ENDIF

c     Compute the vertical eddy viscosity

         CALL EDDYVIS(Hs,UU(NH),VV(NH),
     &        WSXsNH,WSYsNH,BSX(NH),BSY(NH),
     &        istart,NH,DelT,IT)

c     Compute the integral KVnm

         KVnm(1,1)=0.d0
         KVnm(1,3)=-0.5d0*(EVTot(2)+EVTot(1))/(Sigma(2)-Sigma(1))
         KVnm(1,2)=-(KVnm(1,1)+KVnm(1,3))
         DO k=2,NFEN-1
            KVnm(k,1)=KVnm(k-1,3)
         KVnm(k,3)=-0.5d0*(EVTot(k+1)+EVTot(k))/(Sigma(k+1)-Sigma(k))
            KVnm(k,2)=-(KVnm(k,1)+KVnm(k,3))
         ENDDO
         KVnm(NFEN,1)=KVnm(NFEN-1,3)
         KVnm(NFEN,3)=0.d0      
         KVnm(NFEN,2)=-(KVnm(NFEN,1)+KVnm(NFEN,3))

c     Compute time derivative of water surface position

         DEtaDT=(Eta2(NH)-Eta1(NH))/DelT

c     Start computing horizontal derivatives of water level, bathymetric
c     depth and total barotropic pressure (atmos pres, water level,
c     tidal potential) Note: TotalArea2 = 2X total elemental area
c     surrounding a node

         DEtaDX=0.d0
         DEtaDY=0.d0
         DhDX=0.d0
         DhDY=0.d0
         BTPG=(0.d0,0.d0)
         DEtaDX2A=0.d0
         DhDX2A=0.d0
         DEtaDY2A=0.d0
         DhDY2A=0.d0
         BTPDX2A=0.d0
         BTPDY2A=0.d0
         TotalArea2=0.d0

         N1=NH
         EtaN1=NolIFA*(Eta1(N1)+Eta2(N1))/2.d0
         hN1=DP(N1)
         BTPN1=BTP(N1)

         N2=NeiTab(NH,2)        !operate on 1st neighbor
         EtaN2=NolIFA*(Eta1(N2)+Eta2(N2))/2.d0
         hN2=DP(N2)
         BTPN2=BTP(N2)

         NNFirst=N2             !save these values until end
         EtaNFirst=EtaN2
         hNFirst=hN2
         BTPNFirst=BTPN2

         DO N=3,NNeigh(NH)      !operate on rest of neighbors
            N3=N2               !shift previously computed values
            hN3=hN2             !shift previously computed values
            EtaN3=EtaN2
            BTPN3=BTPN2
            N2=NeiTab(NH,N)     !select new neighbor to work on
            EtaN2=NolIFA*(Eta1(N2)+Eta2(N2))/2.d0
            hN2=DP(N2)
            BTPN2=BTP(N2)
            NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
            IF(NEle.NE.0) THEN  !if element is active, compute velocity grads
               TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
               DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
               DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
               DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
               BTPDX2A=BTPDX2A+(BTPN1*b1+BTPN2*b2+BTPN3*b3)
               BTPDY2A=BTPDY2A+(BTPN1*a1+BTPN2*a2+BTPN3*a3)
            ENDIF
         END DO

         N3=N2                  !wrap back to beginning to get final contribution
         hN3=hN2
         EtaN3=EtaN2
         BTPN3=BTPN2
         N2=NNFirst
         hN2=hNFirst
         EtaN2=EtaNFirst
         BTPN2=BTPNFirst
         NEle=NeiTabEle(NH,NNeigh(NH)-1)
         IF(NEle.NE.0) THEN
            TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
            a1=X(N3)-X(N2)
            a2=X(N1)-X(N3)
            a3=X(N2)-X(N1)
            b1=Y(N2)-Y(N3)
            b2=Y(N3)-Y(N1)
            b3=Y(N1)-Y(N2)
            DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
            DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
            DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
            DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
            BTPDX2A=BTPDX2A+(BTPN1*b1+BTPN2*b2+BTPN3*b3)
            BTPDY2A=BTPDY2A+(BTPN1*a1+BTPN2*a2+BTPN3*a3)
         ENDIF

         IF(TotalArea2.NE.0.) THEN
            DhDX=DhDX2A/TotalArea2
            DhDY=DhDY2A/TotalArea2
            DEtaDX=DEtaDX2A/TotalArea2
            DEtaDY=DEtaDY2A/TotalArea2
            BTPG=(BTPDX2A+I*BTPDY2A)/TotalArea2
         ENDIF

c     Finished computing horizontal derivatives of water level,
c     bathymetric depth and total barotropic pressure (atmos pres, water
c     level, tidal potential)

c     Compute the "sigma" vertical velocity from the "z" vertical velocity 

         DO k=1,NFEN
            SigmaMAOAMB=(Sigma(k)-A)/AMB
            SigmaMBOAMB=(Sigma(k)-B)/AMB
            WSigma(k) = WZ(NH,k) - SigmaMBOAMB*DEtaDT
     &           - REAL(q(NH,k))*(SigmaMBOAMB*DEtaDX+SigmaMAOAMB*DhDX)
     &           - AIMAG(q(NH,k))*(SigmaMBOAMB*DEtaDY+SigmaMAOAMB*DhDY)
         ENDDO


c     Start computing advection and stress terms in the momentum
c     equation at each level in the vertical

         DO k=1,NFEN

c     Compute the vertical advection and vertical stress terms

            IF(k.EQ.1) THEN
               DqDSigmakp1=(q(NH,k+1)-q(NH,k))/(Sigma(k+1)-Sigma(k))
            VAdvec(k)=DqDsigmakp1*(2.d0*WSigma(k)+WSigma(k+1))*Inm(k,3)
     &              /HsOAMB
               VStress(k)=(q(NH,k)*KVnm(k,2)+q(NH,k+1)*KVnm(k,3))
     &              /HsHsOAMBAMB
            ENDIF
            IF((k.GT.1).AND.(k.LT.NFEN)) THEN
               DqDSigmakm1=DqDSigmakp1
               DqDSigmakp1=(q(NH,k+1)-q(NH,k))/(Sigma(k+1)-Sigma(k))
           VAdvec(k)=(DqDSigmakm1*(WSigma(k-1)+2.d0*WSigma(k))*Inm(k,1)
     &              +DqDSigmakp1*(2.d0*WSigma(k)+WSigma(k+1))*Inm(k,3))
     &              /HsOAMB
               VStress(k)=(q(NH,k-1)*KVnm(k,1)+q(NH,k)*KVnm(k,2)
     &              +q(NH,k+1)*KVnm(k,3))/HsHsOAMBAMB
            ENDIF
            IF(k.EQ.NFEN) THEN
               DqDSigmakm1=DqDSigmakp1
            VAdvec(k)=DqDSigmakm1*(WSigma(k-1)+2.d0*WSigma(k))*Inm(k,1)
     &              /HsOAMB
               VStress(k)=(q(NH,k-1)*KVnm(k,1)+q(NH,k)*KVnm(k,2))
     &              /HsHsOAMBAMB
            ENDIF
            VAdvec(k)=NolICA*VAdvec(k)

c     Compute lateral advection and lateral stress terms

            UnDqDX2A=0.d0
            VnDqDY2A=0.d0
            DqDXDPhiDX2A=0.d0
            DqDYDPhiDY2A=0.d0

            N1=NH               !node 1 is always the central node
            qN1=q(N1,k)       

            N2=NEITAB(NH,2)     !operate on 1st neighbor
            qN2=q(N2,k)

            NNFirst=N2          !save these values until end
            qNFirst=qN2

            DO N=3,NNEIGH(NH)   !operate on rest of neighbors
               N3=N2            !shift previously computed values
               qN3=qN2
               N2=NEITAB(NH,N)  !select new neighbor to work on
               qN2=q(N2,k)
               NEle=NeiTabEle(NH,N-2) !element # defined by nodes N1,N2,N3
               IF(NEle.NE.0) THEN !if element exists, compute terms
                  qn=(qN1+qN2+qN3)/3.d0
                  Un=REAL(qn)
                  Vn=AIMAG(qn)
                  a1=X(N3)-X(N2)
                  a2=X(N1)-X(N3)
                  a3=X(N2)-X(N1)
                  b1=Y(N2)-Y(N3)
                  b2=Y(N3)-Y(N1)
                  b3=Y(N1)-Y(N2)
                  UnDqDX2A=UnDqDX2A+Un*(qN1*b1+qN2*b2+qN3*b3)
                  VnDqDY2A=VnDqDY2A+Vn*(qN1*a1+qN2*a2+qN3*a3)
                  DqDXDPhiDX2A=DqDXDPhiDX2A
     &                 +(qN1*b1+qN2*b2+qN3*b3)*b1/Areas(NEle)
                  DqDYDPhiDY2A=DqDYDPhiDY2A
     &                 +(qN1*a1+qN2*a2+qN3*a3)*a1/Areas(NEle)
               ENDIF
            END DO

            N3=N2               !wrap back to beginning to get final contribution
            qN3=qN2
            N2=NNFIRST
            qN2=qNFirst
            NEle=NeiTabEle(NH,NNeigh(NH)-1)
            IF(NEle.NE.0) THEN
               qn=(qN1+qN2+qN3)/3.d0
               Un=real(qn)
               Vn=aimag(qn)
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               UnDqDX2A=UnDqDX2A+Un*(qN1*b1+qN2*b2+qN3*b3)
               VnDqDY2A=VnDqDY2A+Vn*(qN1*a1+qN2*a2+qN3*a3)
               DqDXDPhiDX2A=DqDXDPhiDX2A
     &              +(qN1*b1+qN2*b2+qN3*b3)*b1/Areas(NEle)
               DqDYDPhiDY2A=DqDYDPhiDY2A
     &              +(qN1*a1+qN2*a2+qN3*a3)*a1/Areas(NEle)
            ENDIF

            IF(TotalArea2.EQ.0.) THEN
               LAdvec(k)=(0.d0,0.d0)
               LStress(k)=(0.d0,0.d0)
            ELSE
               LAdvec(k)=NolICA*(UnDqDX2A+VnDqDY2A)/TotalArea2   
               LStress(k)=3.d0*EVM(NH)*(DqDXDPhiDX2A+DqDYDPhiDY2A)
     &              /TotalArea2
            ENDIF

         ENDDO

c     Finished computing advection and stress terms in the momentum
c     equation at each level in the vertical


c     Zero out baroclinic pressure gradient and vertically integrated
c     baroclinic pressure gradient for a barotropic run

         IF(IDEN.EQ.0) THEN
            DO k=1,NFEN
               BCPG(k)=(0.d0,0.d0)
            END DO
            VIDBCPDX(NH)=0.d0
            VIDBCPDY(NH)=0.d0
         ENDIF

c     Start computing baroclinic terms

         IF(IDEN.EQ.1) THEN

c     Start computing baroclinic pressure gradient (computed in level
c     coordinates) at each node in the vertical

            DO k=1,NFEN

               DBCPDX2A=0.d0
               DBCPDY2A=0.d0
               TotalBCPGArea2=0.d0
               N1=NH
               BCPN1=BCP(NH,k)

               Zk=HsOAMB*(Sigma(k)-B)-DP(NH) !determine z corresponding to sigma level k
               N2=NEITAB(NH,2)  !operate on 1st neighbor
               HsN2=DP(N2)+NolIFA*Eta1(N2)
               SigmaNN=B+AMB*(Zk+DP(N2))/HsN2 !equivalent sigma value at neighbor
               CALL ZSURFBUOY(SigmaNN,BCPN2,N2,k) !interp BCP at neighbor
               NNFirst=N2       !save these values until end
               BCPNFirst=BCPN2  !save these values until end

               DO N=3,NNeigh(NH) !operate on rest of neighbors
                  N3=N2         !shift previously computed values
                  BCPN3=BCPN2   !shift previously computed values
                  N2=NeiTab(NH,N) !select new neighbor to work on
                  HsN2=DP(N2)+NolIFA*Eta1(N2)
                  SigmaNN=B+AMB*(Zk+DP(N2))/HsN2 !equivalent sigma value at neighbor
                  CALL ZSURFBUOY(SigmaNN,BCPN2,N2,k) !interp BCP at neighbor
                  NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
                  IF((BCPN2.NE.-999.).AND.(BCPN3.NE.-999.)
     &                 .AND.(NEle.NE.0)) THEN !if all 3 nodes are active, compute bu
                     TotalBCPGArea2=TotalBCPGArea2+Areas(NEle)
                     a1=X(N3)-X(N2)
                     a2=X(N1)-X(N3)
                     a3=X(N2)-X(N1)
                     b1=Y(N2)-Y(N3)
                     b2=Y(N3)-Y(N1)
                     b3=Y(N1)-Y(N2)
                     DBCPDX2A=DBCPDX2A+(BCPN1*b1+BCPN2*b2+BCPN3*b3)
                     DBCPDY2A=DBCPDY2A+(BCPN1*a1+BCPN2*a2+BCPN3*a3)
                  ENDIF
               END DO

               N3=N2            !wrap back to beginning to get final contributio
               N2=NNFirst
               BCPN3=BCPN2
               BCPN2=BCPNFirst
               NEle=NeiTabEle(NH,NNeigh(NH)-1)
               IF((BCPN2.NE.-999.).AND.(BCPN3.NE.-999.)
     &              .AND.(NEle.NE.0)) THEN
                  TotalBCPGArea2=TotalBCPGArea2+Areas(NEle)
                  a1=X(N3)-X(N2)
                  a2=X(N1)-X(N3)
                  a3=X(N2)-X(N1)
                  b1=Y(N2)-Y(N3)
                  b2=Y(N3)-Y(N1)
                  b3=Y(N1)-Y(N2)
                  DBCPDX2A=DBCPDX2A+(BCPN1*b1+BCPN2*b2+BCPN3*b3)
                  DBCPDY2A=DBCPDY2A+(BCPN1*a1+BCPN2*a2+BCPN3*a3)
               ENDIF

               IF(TotalBCPGArea2.EQ.0.) THEN 
                  BCPG(k)=(0.d0,0.d0)
               ELSE
                  BCPG(k)=(DBCPDX2A+I*DBCPDY2A)/TotalBCPGArea2
               ENDIF

            ENDDO

c     Finished computing baroclinic pressure gradient (computed in level
c     coordinates) at each node in the vertical


c     Compute vertically integrated baroclinic pressure gradient for use
c     in the wave equation.  NOTE: For a prognostic model in which the
c     density field evolves in time, this calculation should be done
c     after the new density field is computed.  In this case one would
c     integrate over the vertical first and differentiate second.

            VIBCPG=(0.d0,0.d0)
            DO k=NFEN-1,1,-1
               VIBCPG=VIBCPG+0.5d0*(BCPG(k+1)+BCPG(k))
     &              *(Sigma(k+1)-Sigma(k))
            ENDDO
            VIDBCPDX(NH)=REAL(VIBCPG)*Hsp1OAMB
            VIDBCPDY(NH)=AIMAG(VIBCPG)*Hsp1OAMB

         ENDIF

c     Finished computing baroclinic terms

c     Compute the equivalent linear slip coefficient

         IF(ISlip.EQ.1) KSlip=KP
         IF(ISlip.EQ.2) THEN
            KSlip=KP*ABS(q(NH,1))
            IF(KSlip.LT.1.E-8) KSlip=1.d-8
         ENDIF

c     Set up the RHS forcing vector Fr and LHS matrix in compact storage
c     (Mkm1,Mk,Mkp1)

         CCL = 1.d0+Corif(NH)*IDTAlp1
         CCR = 1.d0-Corif(NH)*IDT1MAlp1  
         RCL = DTAlp3/Hsp1Hsp1OAMBAMB

         IF(ISlip.EQ.0) THEN    !no slip bottom boundary condition
            Fr(1)   = (0.d0,0.d0)
            Mkm1(1) = (0.d0,0.d0)
            Mk(1)   = (1.d0,-1.d0) !note: -I*IV=V
            Mkp1(1) = (0.d0,0.d0)
         ELSE                   ! slip bottom boundary condition
            Fr(1) = (CCR*q(NH,1)
     &           -DelT*(LAdvec(1)  +LStress(1)  +BCPG(1)))*Inm(1,2)
     &           + (CCR*q(NH,2)
     &           -DelT*(LAdvec(2)  +LStress(2)  +BCPG(2)))*Inm(1,3)
     &           - DelT*(VAdvec(1)+BTPG*LVn(1))-DT1MAlp3*VStress(1)     
     &           - q(NH,1)*DT1MAlp2*KSlip/HsOAMB     
            Mkm1(1) = (0.d0,0.d0)
       Mk(1)   = CCL*Inm(1,2) + RCL*KVnm(1,2) + DTAlp2*KSlip/Hsp1OAMB
            Mkp1(1) = CCL*Inm(1,3) + RCL*KVnm(1,3)
         ENDIF

         DO k=2,NFEN-1
            Fr(k) = (CCR*q(NH,k-1)
     &           -DelT*(LAdvec(k-1)+LStress(k-1)+BCPG(k-1)))*Inm(k,1)
     &           + (CCR*q(NH,k)
     &           -DelT*(LAdvec(k)  +LStress(k)  +BCPG(k)  ))*Inm(k,2)
     &           + (CCR*q(NH,k+1)
     &           -DelT*(LAdvec(k+1)+LStress(k+1)+BCPG(k+1)))*Inm(k,3)
     &           - DelT*(VAdvec(k)+BTPG*LVn(k))-DT1MAlp3*VStress(k)
            Mkm1(k) = CCL*Inm(k,1) + RCL*KVnm(k,1)
            Mk(k)   = CCL*Inm(k,2) + RCL*KVnm(k,2)
            Mkp1(k) = CCL*Inm(k,3) + RCL*KVnm(k,3)
         END DO

         Fr(NFEN) = (CCR*q(NH,k-1)
     &        -DelT*(LAdvec(k-1)+LStress(k-1)+BCPG(k-1)))*Inm(k,1)
     &        + (CCR*q(NH,k)
     &        -DelT*(LAdvec(k)  +LStress(k)  +BCPG(k)  ))*Inm(k,2)
     &        - DelT*(VAdvec(k)+BTPG*LVn(k))-DT1MAlp3*VStress(k)
     &        + DelT*0.5d0*((WSX2(NH)+I*WSY2(NH))/Hsp1OAMB
     &        +(WSX1(NH)+I*WSY1(NH))/HsOAMB)
         Mkm1(NFEN) = CCL*Inm(NFEN,1) + RCL*KVnm(NFEN,1)
         Mk(NFEN)   = CCL*Inm(NFEN,2) + RCL*KVnm(NFEN,2)
         Mkp1(NFEN) = (0.d0,0.d0)

c     Start section to modify equations depending on normal flux
c     boundary condition
c     0 <= LBcodeI <= 10, essential normal flux and free tangential slip
c     this b.c. is taken care of in the code section below
c     10 <= LBcodeI <= 19, essential normal flux and zero tangential slip
c     this b.c. is taken care of above
c     20 <= LBcodeI <= 29, natural normal flux and free tangential slip
c     this b.c. requires on manipulation of momentum eqns.  Do nothing!

         LBP=LBArray_Pointer(NH)
         IF(LBP.GT.0) THEN      !flux boundary
            IF((LBCODEI(LBP).GE. 0).AND.(LBCODEI(LBP).LE. 9)) THEN
               SLBP=SIII(LBP)
               CLBP=CSII(LBP)
               VelNorm=-QNormsp1(LBP)/Hsp1                              

               Mkm1(1)    =(0.d0,0.d0)
               Auv1k      =Real(Mk(1))
               Auv2k      =AImag(Mk(1))
               Auv1kstar  =Auv1k*SLBP
               Auv2kstar  =Auv1k*CLBP
               Mk(1)      =Auv1kstar+I*Auv2kstar
               Auv1kp1    =Real(Mkp1(1))
               Auv2kp1    =AImag(Mkp1(1))
               Auv1kp1star=Auv1kp1*SLBP
               Auv2kp1star=Auv1kp1*CLBP
               Mkp1(1)    =Auv1kp1star+I*Auv2kp1star
               Frstar     =Real(Fr(1))*SLBP-AImag(Fr(1))*CLBP
     &              +  (Auv2k+Auv2kp1)*VelNorm 
     &              +I*(Auv1k+Auv1kp1)*VelNorm
               Fr(1)      =Frstar
               DO k=2,NFEN-1
                  Auv1km1    =Real(Mkm1(k))
                  Auv2km1    =AImag(Mkm1(k))
                  Auv1km1star=Auv1km1*SLBP
                  Auv2km1star=Auv1km1*CLBP
                  Mkm1(k)    =Auv1km1star+I*Auv2km1star
                  Auv1k      =Real(Mk(k))
                  Auv2k      =AImag(Mk(k))
                  Auv1kstar  =Auv1k*SLBP
                  Auv2kstar  =Auv1k*CLBP
                  Mk(k)      =Auv1kstar+I*Auv2kstar
                  Auv1kp1    =Real(Mkp1(k))
                  Auv2kp1    =AImag(Mkp1(k))
                  Auv1kp1star=Auv1kp1*SLBP
                  Auv2kp1star=Auv1kp1*CLBP
                  Mkp1(k)    =Auv1kp1star+I*Auv2kp1star
                  Frstar     =Real(Fr(k))*SLBP-AImag(Fr(k))*CLBP
     &                 +  (Auv2km1+Auv2k+Auv2kp1)*VelNorm 
     &                 +I*(Auv1km1+Auv1k+Auv1kp1)*VelNorm
                  Fr(k)      =Frstar
               END DO
               Auv1km1    =Real(Mkm1(NFEN))
               Auv2km1    =AImag(Mkm1(NFEN))
               Auv1km1star=Auv1km1*SLBP
               Auv2km1star=Auv1km1*CLBP
               Mkm1(NFEN) =Auv1km1star+I*Auv2km1star
               Auv1k      =Real(Mk(NFEN))
               Auv2k      =AImag(Mk(NFEN))
               Auv1kstar  =Auv1k*SLBP
               Auv2kstar  =Auv1k*CLBP
               Mk(NFEN)   =Auv1kstar+I*Auv2kstar
               Mkp1(NFEN) =(0.d0,0.d0)
               Frstar     =Real(Fr(NFEN))*SLBP-AImag(Fr(NFEN))*CLBP
     &              +  (Auv2km1+Auv2k)*VelNorm 
     &              +I*(Auv1km1+Auv1k)*VelNorm
               Fr(NFEN)   =Frstar
            ENDIF
         ENDIF

c     Finished section to modify equations depending on normal flux
c     boundary condition
         
c     Decompose and solve the system

 999     CALL TRIDIAG(Mkm1,Mk,Mkp1,Fr,Gamma,NFEN)

c     Compute the depth averaged velocity and bottom stress

         VIVel = (0.d0,0.d0)
         DO k=1,NFEN
            VIVel = VIVel + Gamma(k)*LVn(k)
         END DO
         VIVel = VIVel/amb
         UU(NH) = REAL(VIVel)
         VV(NH) = AIMAG(VIVel)

         IF(ISlip.EQ.0) THEN
            DUDS = (Gamma(2)-Gamma(1))/(Sigma(2)-Sigma(1))
            BSX(NH) = EVTot(1)*REAL(DUDS)
            BSY(NH) = EVTot(1)*AIMAG(DUDS)
         ENDIF
         IF(ISlip.NE.0) THEN
            BSX(NH) = KSlip*REAL(GAMMA(1))
            BSY(NH) = KSlip*AIMAG(GAMMA(1))
         ENDIF

c     Compute the dispersion terms
         
         DUU(NH) = 0.d0
         DUV(NH) = 0.d0
         DVV(NH) = 0.d0
         IF(NolICA.EQ.1) THEN
            CALL VSDISP (IT,NH,Hsp1,UU(NH),VV(NH),
     &           DUU(NH),DUV(NH),DVV(NH))
         ENDIF

c     Save the horizontal velocity and Eddy Viscosity solutions

         DO k=1,NFEN
            q(NH,k) = Gamma(k)
            EV(NH,k)=EVTot(k)
         END DO
         
      ENDDO

C     Finish loop over horizontal nodes to compute the horizontal velocity

C*************************************************************************************
C     Update recently computed quantities on ghost nodes
C     

#ifdef CMPI
      CALL UPDATER(UU,VV,DUMV1,2) ! Update depth averaged velocities
      CALL UPDATER(BSX,BSY,DUMV1,2) ! Update bottom stresses
      CALL UPDATER(DUU,DUV,DVV,3) ! Update dispersion terms
      CALL UPDATEC3D(Q)         !  Update horizontal velocity solution
c     CALL UPDATER3D(EV) ! Update eddy viscosity solution
                         ! Don't think this is needed at this time
#endif

C*************************************************************************************
C     Compute "z" vertical velocity     

C     
C     Loop over each horizontal node to compute the "z" version of the
C     vertical velocity
C     
      DO NH=1,NP

c     Set up some values at the node being worked on

         Hsp1=DP(NH)+NOLIFA*Eta2(NH)
         Hsp1OAMB=Hsp1/AMB

c     Compute time derivative of water surface position

         DEtaDT=(Eta2(NH)-Eta1(NH))/DelT

c     Compute horizontal derivatives of water surface position,
c     bathymetric depth and horizontal velocity Note: TotalArea2 = 2X
c     total elemental area surrounding a node

         DO k=1,NFEN
            DqDX2A(k)=(0.d0,0.d0)
            DqDY2A(k)=(0.d0,0.d0)
            DUDX(k)=0.d0
            DVDY(k)=0.d0
         ENDDO
         DEtaDX=0.d0
         DEtaDY=0.d0
         DhDX=0.d0
         DhDY=0.d0
         DEtaDX2A=0.d0
         DhDX2A=0.d0
         DEtaDY2A=0.d0
         DhDY2A=0.d0
         TotalArea2=0.d0

         N1=NH
         EtaN1=NolIFA*Eta2(N1)
         hN1=DP(N1)

         N2=NeiTab(NH,2)        !operate on 1st neighbor
         EtaN2=NolIFA*Eta2(N2)
         hN2=DP(N2)

         NNFirst=N2             !save these values until end
         EtaNFirst=EtaN2
         hNFirst=hN2

         DO N=3,NNeigh(NH)      !operate on rest of neighbors
            N3=N2               !shift previously computed values
            hN3=hN2             !shift previously computed values
            EtaN3=EtaN2
            N2=NeiTab(NH,N)     !select new neighbor to work on
            EtaN2=NolIFA*Eta2(N2)
            hN2=DP(N2)
            NEle=NeiTabEle(NH,N-2) !element # defined by nodes NH,NN2,NN1
            IF(NEle.NE.0) THEN  !if element is active, compute velocity grads
               TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
               a1=X(N3)-X(N2)
               a2=X(N1)-X(N3)
               a3=X(N2)-X(N1)
               b1=Y(N2)-Y(N3)
               b2=Y(N3)-Y(N1)
               b3=Y(N1)-Y(N2)
               DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
               DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
               DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
               DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
               DO k=1,NFEN
                  qN1=q(N1,k)
                  qN2=q(N2,k)
                  qN3=q(N3,k)
                  DqDX2A(k)=DqDX2A(k)+(qN1*b1+qN2*b2+qN3*b3)
                  DqDY2A(k)=DqDY2A(k)+(qN1*a1+qN2*a2+qN3*a3)
               ENDDO
            ENDIF
         ENDDO

         N3=N2                  !wrap back to beginning to get final contribution
         hN3=hN2
         EtaN3=EtaN2
         N2=NNFirst
         hN2=hNFirst
         EtaN2=EtaNFirst
         NEle=NeiTabEle(NH,NNeigh(NH)-1)
         IF(NEle.NE.0) THEN
            TotalArea2=TotalArea2+Areas(NEle) !accumulate 2X total areas to complete calc.
            a1=X(N3)-X(N2)
            a2=X(N1)-X(N3)
            a3=X(N2)-X(N1)
            b1=Y(N2)-Y(N3)
            b2=Y(N3)-Y(N1)
            b3=Y(N1)-Y(N2)
            DhDX2A=DhDX2A+(hN1*b1+hN2*b2+hN3*b3)
            DhDY2A=DhDY2A+(hN1*a1+hN2*a2+hN3*a3)
            DEtaDX2A=DEtaDX2A+(EtaN1*b1+EtaN2*b2+EtaN3*b3)
            DEtaDY2A=DEtaDY2A+(EtaN1*a1+EtaN2*a2+EtaN3*a3)
            DO k=1,NFEN
               qN1=q(N1,k)
               qN2=q(N2,k)
               qN3=q(N3,k)
               DqDX2A(k)=DqDX2A(k)+(qN1*b1+qN2*b2+qN3*b3)
               DqDY2A(k)=DqDY2A(k)+(qN1*a1+qN2*a2+qN3*a3)
            ENDDO
         ENDIF

         IF(TotalArea2.NE.0.) THEN
            DhDX=DhDX2A/TotalArea2
            DhDY=DhDY2A/TotalArea2
            DEtaDX=DEtaDX2A/TotalArea2
            DEtaDY=DEtaDY2A/TotalArea2
            DO k=1,NFEN
               DUDX(k)=REAL(DqDX2A(k))/TotalArea2
               DVDY(k)=AIMAG(DqDY2A(k))/TotalArea2
            ENDDO
         ENDIF

c     Evaluate the "z" vertical velocity

         WZ(NH,1)=-REAL(q(NH,1))*DhDX-AIMAG(q(NH,1))*DhDY

         DO k=2,NFEN
            DelSigO2=(Sigma(k)-Sigma(k-1))/2.d0
            SigAvgMAOAMB=((Sigma(k)+Sigma(k-1))/2.d0 - A)/AMB
            DelU=REAL(q(NH,k)-q(NH,k-1))
            DelV=AIMAG(q(NH,k)-q(NH,k-1))
            WZ(NH,k)=WZ(NH,k-1)
     &      - DelSigO2*Hsp1OAMB*(DUDX(k)+DVDY(k)+DUDX(k-1)+DVDY(k-1))
     &           + (DEtaDX+SigAvgMAOAMB*(DhDX+DEtaDX))*DelU
     &           + (DEtaDY+SigAvgMAOAMB*(DhDY+DEtaDY))*DelV
         ENDDO

c     Correct this using Adjoint method        

         Wf=0.d0                !This value should match surface B.C. exactly
         Hsp1= DP(NH)+NolIFA*Eta2(NH) !Total depth at present (s+1) timestep
         WfOHH=Wf/(Hsp1*Hsp1)
        WZSurfBC=DEtaDT+REAL(q(NH,NFEN))*DEtaDX+AIMAG(q(NH,NFEN))*DEtaDY
         WZSurf=WZ(NH,NFEN)

         DO k=1,NFEN
            WZCorrection=(WZSurfBC-WZSurf)*(WfOHH+(Sigma(k)-b)/AMB)
     &           /(2.d0*WfOHH+1)
            WZ(NH,k)=WZ(NH,k)+WZCorrection
         ENDDO

C     
C     End loop over horizontal nodes to compute vertical velocity
C     
      ENDDO

C*************************************************************************************
C     Update vertical velocity on ghost nodes

#ifdef CMPI
      CALL UPDATER3D(WZ)
#endif

C*************************************************************************************
C     Compute new density, temperature, salinity fields
c     Compute vertically integrated baroclinic pressure gradient

#ifdef CMPI

C*************************************************************************************
C     Update new density, temperature, and salinity fields on ghost nodes
C     
c     CALL UPDATER3D(SIGT)   !!!!!Does not appear to be needed at this time
c     CALL UPDATER3D(TEMP)   !!!!!Does not appear to be needed at this time
c     CALL UPDATER3D(SAL)    !!!!!Does not appear to be needed at this time


C*************************************************************************************
C     Update new vertically integrated baroclinic pressure gradient on ghost nodes
C     
c     CALL UPDATER3D(BCP)    !!!!!Does not appear to be needed at this time

#endif

C*************************************************************************************
C     Write Output

C     
C     Loop over horizontal nodes to write output
C     
      DO NH=1,NP

 1104    FORMAT(9X,I6,4X,32000(E12.6,2X))

c     Station density, temperature, salinity output (Unit 41)

         IF((I3DSD.GT.0).AND.(NSSD.EQ.0)) THEN
            DO NN=1,NHN3DSD
               IF(NH.EQ.ISDHOUT(NN)) THEN
            IF(I3DSD.EQ.1) WRITE(41,1104) NH,(SIGT(NH,k),TEMP(NH,k),
     &                 SAL(NH,k),k=1,NFEN) !ASCII
                  IF(I3DSD.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(41,REC=ISDREC+1) SIGT(NH,k)
                        WRITE(41,REC=ISDREC+2) TEMP(NH,k)
                        WRITE(41,REC=ISDREC+3) SAL(NH,k)
                        ISDREC=ISDREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Station velocity output (Unit 42)

         IF((I3DSV.GT.0).AND.(NSSV.EQ.0)) THEN
            DO NN=1,NHN3DSV
               IF(NH.EQ.ISVHOUT(NN)) THEN
                  IF(I3DSV.EQ.1) WRITE(42,1104) NH,(REAL(q(NH,k)),
     &                 AIMAG(q(NH,k)),
     &                 WZ(NH,k),k=1,NFEN) !ASCII
                  IF(I3DSV.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(42,REC=ISVREC+1) REAL(q(NH,k))
                        WRITE(42,REC=ISVREC+2) AIMAG(q(NH,k))
                        WRITE(42,REC=ISVREC+3) WZ(NH,k)
                        ISVREC=ISVREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Station turbulence output (Unit 43)

         IF((I3DST.GT.0).AND.(NSST.EQ.0)) THEN
            DO NN=1,NHN3DST
               IF(NH.EQ.ISTHOUT(NN)) THEN
                  IF(I3DST.EQ.1) WRITE(43,1104) NH,(q20(NH,k),l(NH,k),
     &                 EV(NH,k),k=1,NFEN) !ASCII
                  IF(I3DST.EQ.2) THEN !BINARY
                     DO k=1,NFEN
                        WRITE(43,REC=ISTREC+1) q20(NH,k)
                        WRITE(43,REC=ISTREC+2) l(NH,k)
                        WRITE(43,REC=ISTREC+3) EV(NH,k)
                        ISTREC=ISTREC+3
                     END DO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

c     Global density, temperature, salinity output (Unit 44)

         IF((I3DGD.GT.0).AND.(NSGD.EQ.0)) THEN !ASCII
            IF(I3DGD.EQ.1) WRITE(44,1104) NH,(SIGT(NH,k),TEMP(NH,k),
     &           SAL(NH,k),k=1,NFEN)
            IF(I3DGD.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(44,REC=IGDREC+1) SIGT(NH,k)
                  WRITE(44,REC=IGDREC+2) TEMP(NH,k)
                  WRITE(44,REC=IGDREC+3) SAL(NH,k)
                  IGDREC=IGDREC+3
               END DO
            ENDIF
         ENDIF

c     Global velocity output (Unit 45)

         IF((I3DGV.GT.0).AND.(NSGV.EQ.0)) THEN !ASCII
      IF(I3DGV.EQ.1) WRITE(45,1104) NH,(REAL(q(NH,k)),AIMAG(q(NH,k)),
     &           WZ(NH,k),k=1,NFEN)
            IF(I3DGV.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(45,REC=IGVREC+1) REAL(q(NH,k))
                  WRITE(45,REC=IGVREC+2) AIMAG(q(NH,k))
                  WRITE(45,REC=IGVREC+3) WZ(NH,k)
                  IGVREC=IGVREC+3
               END DO
            ENDIF
         ENDIF

c     Global turbulence output (Unit 46)

         IF((I3DGT.GT.0).AND.(NSGT.EQ.0)) THEN !ASCII
            IF(I3DGT.EQ.1) WRITE(46,1104) NH,(q20(NH,k),l(NH,k),
     &           EV(NH,k),k=1,NFEN)
            IF(I3DGT.EQ.2) THEN !BINARY
               DO k=1,NFEN
                  WRITE(46,REC=IGTREC+1) q20(NH,k)
                  WRITE(46,REC=IGTREC+2) l(NH,k)
                  WRITE(46,REC=IGTREC+3) EV(NH,k)
                  IGTREC=IGTREC+3
               END DO
            ENDIF
         ENDIF

C     
C     End loop over horizontal nodes to write output
C     
      ENDDO

C     RETURN TO THE 2-D MODEL TO COMPUTE H AT NEXT TIME STEP

      RETURN
      END


c***********************************************************************
c                                                                      *
C     SUBROUTINE TO SET UP THE VERTICAL FINITE ELEMENT GRID            *
c                                                                      *
c                           2/22/93                                    *
c***********************************************************************
c     
      SUBROUTINE FEGRIDS(IGC,H)
      USE GLOBAL_3DVS, ONLY : SZ,DIRNAME,NFEN,SIGMA,A,B,Z0B,Z0S,NSCREEN
      IMPLICIT NONE
      INTEGER :: IGC,N,NODE,NFEN2,IANS,NUM,I
      REAL :: H,DETA,SSTAR,DENOM,SIG0,SS,SB,RP,AVAL,EPS

 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     &     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')
      
      IF((IGC.LT.0).OR.(IGC.GT.6)) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,410)
         ENDIF
         WRITE(16,350)
         WRITE(16,410)
 410     FORMAT(/,2X,'    IGC MUST BE 0,1,2,3 OR 4')
         STOP
      ENDIF
      IF(NFEN.LT.0) THEN
         IF(NSCREEN.NE.0) THEN
            WRITE(6,350)
            WRITE(6,412)
         ENDIF
         WRITE(16,350)
         WRITE(16,412)
 412     FORMAT(/,2X,'    NFEN MUST BE > 0')
         STOP
      ENDIF

c     
c     igc = 0 - Read in grid from UNIT 12
c     
      if(igc.eq.0) then
         OPEN(10,FILE=DIRNAME//'/'//'fort.10')
         do n=1,nfen
            write(*,901) n
 901        format(1x,'input node#',i3,' and sigma(node#)')
            READ(10,*) node,sigma(node)
         end do
         close(10)
         if(sigma(1).ne.b) then
            write(*,1011)
            write(*,1012)
            write(16,1011)
            write(16,1012)
 1011       format(' Error reading in the vertical finite element grid')
 1012       format(' The first point in the finite element grid ',
     +           'must = b - run terminated'/)
            stop
         endif
         if(sigma(nfen).ne.a) then
            write(*,1011)
            write(*,1013)
            write(16,1011)
            write(16,1013)
 1013       format(' The last point in the finite element grid ',
     +           'must = a - run terminated'/)
            stop
         endif
      endif

c     
c     igc = 1 - Evenly spaced grid
c     
      if(igc.eq.1) then
         if(nfen.le.1) nfen = 2
         deta = (a-b)/(nfen-1)
         sigma(1) = b
         do n=2,nfen-1
            sigma(n) = b + deta*(n-1)
         end do
         nfen2 = nfen/2
         if(2*nfen2.ne.nfen) sigma(nfen2+1) = 0.
         sigma(nfen) = a
      endif

c     
c     igc = 2 - logarithmically grid  (after Davies 1991)
c     
      if(igc.eq.2) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So = ',Z0B,' ***********'
         Sb = Z0B
c     write(*,*) '********** Enter So from the keyboard ***********'
c     write(*,*) '   '
c     read(*,*) Sb
         if(nfen.le.1) nfen = 2
         deta = 1./(nfen-1)
         sigma(1) = b
         do n=2,nfen-1
            sigma(n) = b + (a-b)*Sb/H*(((H+Sb)/Sb)**(deta*(n-1))-1.)
         enddo
         sigma(nfen) = a
      endif

c     
c     igc = 3 - log-linear grid  (after Davies 1991)
c     
      if(igc.eq.3) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So = ',Z0B,' ***********'
         write(*,*) '********** S* = ',-H-Sb,' ***********'
         Sb = Z0B
         Sstar = -H-Sb
         write(*,*) '******** Enter So from the keyboard *******'
         write(*,*) '   '
         read(*,*) Sb
         write(*,*) '******** Enter S* from the keyboard *******'
         write(*,*) '   '
         read(*,*) Sstar
         if(nfen.le.1) nfen = 2
         deta = 1./(nfen-1)
         denom = log((H+Sb)/Sb) + H/Sstar
         sigma(1) = b
         do n=2,nfen-1
            sig0 = b + (a-b)*deta*(n-1)
 10         sigma(n)= b - (a-b)*Sstar/H*(log(1.+H/Sb*(sig0-b)/(a-b))
     +           -denom*deta*(n-1))
            if(abs(sigma(n)-sig0).ge.1d-8)then
               sig0 = sigma(n)
               goto 10
            endif
         enddo
         sigma(nfen) = a
      endif
c     
c     igc = 4 - Double logarithmic grid
c     
      if(igc.eq.4) then
         write(*,*) '   '
         write(*,*) '********** Depth = ',H,' ***********'
         write(*,*) '********** So bottom = ',Z0B,' ***********'
         Sb = Z0B
         write(*,*) '********** So surface = ',Z0S,' ***********'
         Ss = Z0S
c     
c     write(*,*) '******* Enter So bottom from the keyboard ********'
c     write(*,*) '   '
c     read(*,*) Sb
c     write(*,*) '******* Enter So surface from the keyboard *******'
c     write(*,*) '   '
c     read(*,*) Ss
c     
         write(*,*) '   '
         if(mod(nfen,2).eq.0) then
            write(*,*) '**********************************WARNING*****',
     +           '******************************'
            write(*,*) '**** You have specified a double log grid with',
     +           ' an even number of nodes. ****'
            write(*,*) '**** Much better results are obtained using an',
     +           ' an odd number of nodes.  ****'
            write(*,*) '**** Do you want to terminate now or continue?',
     +           '  0=Terminate/1=continue. ****'
            write(*,*) '  '
            read(*,*) ians
            if(ians.ne.1) stop
            num = nfen/2
         else
            num=(nfen-1)/2
            sigma(num+1)=(a+b)/2.
         endif
         deta = 2./(nfen-1)
         sigma(1) = b
         sigma(nfen) = a
         do n=2,num
            sigma(n) = b + 0.5*(a-b)*Sb/H*(((H+Sb)/Sb)**(deta*(n-1))-1.)
            sigma(nfen+1-n) = a - 0.5*(a-b)*Ss/H*(((H+Ss)/Ss)**
     +           (deta*(n-1))-1.)
         enddo
      endif
c     
c     igc = 5 - "P-grid" after Fortunato and Baptista (IJNMF submitted 12/1994)
c     optimal p value of 0.25 may be used as default for tidal flow problems
c     note: p = 1 - uniform, p<1 makes fine grid near bottom,p>1 makes
c     fine grid near sfc
c     sigma converted to range from -1 to 1 in ADCIRC        
c     
      if(igc.eq.5) then
         if(nfen.le.1) nfen = 2
         write(*,*)
         write(*,*)' Enter P value for P - grid'
         write(*,*)
         read(*,*)rp
         do i = 1,nfen
            sigma(i) = -1. + 2.*(1.+((1.-i)/(1.-nfen))**(1./rp) - 1.0)
         end do             
      endif
c     
c     igc = 6 - "sine grid" after Naimie,Lynch
c     Value of A determines stretching at ends, check in unit 18
c     sigma converted to range from -1 to 1 in ADCIRC        
c     
      if(igc.eq.6) then
         if(nfen.le.1) nfen = 2
         write(*,*)
         write(*,*)' Enter A value for sine grid'
         write(*,*)
         read(*,*)aval
         do i = 1,nfen
            eps = float(i-1)/float(nfen-1)
            sigma(i) = -1. + (2./H)*(eps*H-aval*sin(2.*3.14159*eps))
         end do             
      endif

C...  
C...  Write out vertical grid in fort.16 file
C...  
      write(16,1000)
 1000 format(//,5X,'Vertical Coordinate Information')
      write(16,1001) 
 1001 format(/,5X,'V. Node #',5X,'V. Position',/)
      do n = 1, nfen
         write(16,*) n,sigma(n)
      end do


      RETURN
      END

c******************************************************************************
c     Subroutine to compute the eddy viscosity profile.                       *
c                                                                             *
c  ievc, evmin, evcon - E.V. code, E.V. minimum value and E.V. constant       *
c                                                                             *
c        NOTE: evcon only used for some of the E.V. formulations as           *
c                  discussed below.                                           *
c        NOTE: In cases where EV is specified to vary linearly over the       *
c              lower 20% of the water column, it actually varies linearly     *
c              with a constant slope up to the vertical FE grid node that is  *
c              less than or equal to the 20% location.  The value is constant *
c              as specified at all FE grid nodes above the 20% location.      *
c              The E.V. above and below the 20% level is joined by one        *
c              additional linearly varying segment.                           *
c        NOTE: The E.V. is constrained to always be greater than or equal to  *
c              EVMIN as specified in the UNIT 15 file.                        *
c                                                                             *               
c        ievc=0-9, EV constant in time & horizontal space                     *
c             0 - EV read in from UNIT 12 (may vary vertically) - EVCON is    *
c                    not used                                                 *
c             1 - EV = EVCON                                                  *
c                                                                             *
c        ievc=10-19 EV proportional to omega*h*h  (Lynch and Officer (1986)   *
c                                              Lynch and Werner (1987, 1991)) *
c             10 - EV = omega*h*h/10 over the entire water column             *
c             11 - EV = omega*h*h/1000 at bottom                              *
c                       varies linear over lower 20% of wc                    *
c                     = omega*h*h/10 in upper 80% of w.c.                     *
c            NOTE:For this EV formulation, evcon is not used and omega is     *
c                  hardwired for a 12.42 hour tide.                           *
c                                                                             *
c        ievc=20-29 EV proportional to kappa U* z                             *
c             20 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z over entire water column                      *
c             21 - EV = 0.41U*Zo at bottom                                    *
c                     = 0.41U*Z in lower 20% of water col                     *
c                     = 0.082U*h in upper 80% of water col                    *
c            WHERE: U* is the friction velocity                               *
c            NOTE: For this EV formulation, evcon is not used.                *
c                                                                             * 
c        ievc=30-39, EV proportional to Uh (Davies 1990)                      *
c             30 - EV = 0.025|U|h/9.001 over entire water column              *
c             31 - EV = evcon|U|h over entire water column                    *
c             32 - EV = 0.025|U|h/9.001 in upper 80% of wc                    *
c                     = 0.000025h|U|/9.001 at bottom                          *
c                       varies linear over lower 20% of wc                    *
c             33 - EV = evcon|U|h in upper 80% of wc                          *
c                     = evcon|U|h/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=31,33 *
c                                                                             *
c        ievc=40-49, EV proportional to U*U (Davies 1990)                     *
c             40 - EV = 2|UU|/9.001 over entire water column                  *
c             41 - EV = evcon|UU| over entire water column                    *
c             42 - EV = 2|UU|/9.001 in upper 80% of wc                        *
c                     = 0.002|UU|/9.001 at bottom                             *
c                       varies linear over lower 20% of wc                    *
c             43 - EV = evcon|UU| in upper 80% of wc                          *
c                     = evcon|UU|/1000. at bottom                             *
c                       varies linear over lower 20% of wc                    *
c            WHERE: U is depth averaged velocity                              *
c            NOTE: For this EV formluation, evcon is used only for ievc=41,43 *
c                                                                             *
c        ievc=50, EV computed from Mellor-Yamada L2.5 closure                 *
c            NOTE: For this EV formulation, evcon is not used.                *
C                                                                             *
C                               8/24/99                                       *
C******************************************************************************
C
      SUBROUTINE EDDYVIS(H,UU,VV,WSX,WSY,BSX,BSY,
     &     istart,NODE,DELT,IT)

      USE GLOBAL_3DVS, ONLY : SZ,DIRNAME,IEVC,EVMIN,EVCON,EVTOT,SIGMA,
     &     NFEN,Z0B,Z0S,A,B,AMB,NSCREEN,IDIAG,NWS
      REAL(8) :: H
      REAL(SZ) :: UU,VV,WSX,WSY,BSX,BSY,DELT

 350  FORMAT(//,2X,'***** INVALID INPUT IN THE PRIMARY VERTICAL INPUT',
     &     ' FILE (UNIT 15) ****',/,'****** RUN TERMINATED ******')

      RKAPPA = 0.41

C...  
C...  IEVC=0 READ IN FROM UNIT 12 ON THE FIRST TIME STEP
C...  
      IF((IEVC.EQ.0).and.(istart.eq.1)) THEN
         OPEN(12,FILE=DIRNAME//'/'//'fort.12')
         READ(12,*) NIEVN
         IF(NIEVN.NE.NFEN) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(*,350)
               WRITE(*,412)
            ENDIF
            WRITE(16,350)
            WRITE(16,412)
 412        FORMAT(/,2X,'    THE NUMBER OF VALUES IN THE UNIT 12 E.V. ',
     &           'FILE MUST = NUMBER OF NODES IN VERTICAL GRID')
            STOP
         ENDIF
         READ(12,*) SIGEVI,EVTOT(1)
         IF(SIGEVI.NE.b) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,413) SIGEVI,b
            ENDIF
            WRITE(16,350)
            WRITE(16,413) SIGEVI,b
 413        FORMAT(/,2X,'THE BOTTOM ELEVATION IN THE EV= ',E14.8,
     &           '.  THIS MUST = b = ',E14.8)
            STOP
         ENDIF
         DO N=2,NIEVN-1
            READ(12,*) SIGEVI,EVTOT(N)
         ENDDO
         READ(12,*) SIGEVI,EVTOT(NIEVN)
         IF(SIGEVI.NE.a) THEN
            IF(NSCREEN.NE.0) THEN
               WRITE(6,350)
               WRITE(6,414) SIGEVI,a
            ENDIF
            WRITE(16,350)
            WRITE(16,414) SIGEVI,a
 414        FORMAT(/,2X,'THE TOP ELEVATION IN THE EV= ',E14.8,
     &           '.  THIS MUST = a = ',E14.8)
            STOP
         ENDIF
         CLOSE (12)
         WRITE(16,*) ' Vertical E.V. read in from UNIT 12'
      ENDIF

      IF((IEVC.eq.0).and.(istart.gt.1)) GOTO 100

C...  
C...  IEVC=1 SET EV = EVCON ON THE FIRST TIME STEP
C     .

      IF((IEVC.eq.1).and.(istart.eq.1)) THEN
         DO J=1,NFEN
            EVTOT(J)=EVCON
         ENDDO
      ENDIF

      IF((IEVC.eq.1).and.(istart.gt.1)) GOTO 100
      
C...  
C...  OMEGA*H*H formulation FOLLOWING
C...  LYNCH AND OFFICER (1986), LYNCH AND WERNER (1987, 1991)
C...  
      IF(IEVC.EQ.10) THEN
         OMEGA=0.0000141D0
         EVBASE=OMEGA*H*H
         IF(EVBASE.LT.EVMIN) EVBASE=EVMIN          
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.11) THEN
         OMEGA=0.0000141D0
         EVBASE=OMEGA*H*H
         EVTOT(1)=EVBASE/100.D0
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-b*SLOPE
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  KAPPA USTAR Z FORMULATION
C...  
      IF(IEVC.EQ.20) THEN
         USTARB=SQRT(SQRT(BSX*BSX+BSY*BSY))
         EVTOT(1)=RKAPPA*USTARB*Z0B
         EVBASE=RKAPPA*USTARB*H
         IF(EVBASE.LT.EVTOT(1)) EVBASE=EVTOT(1)
         SLOPE=(EVBASE-EVTOT(1))/amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J) !=EVTOT(1)+SLOPE*(SIGMA(J)-b)
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.21) THEN
         USTARB=SQRT(SQRT(BSX*BSX+BSY*BSY))
         EVTOT(1)=RKAPPA*USTARB*Z0B
         EVBASE=RKAPPA*USTARB*H*0.2D0
         IF(EVBASE.LT.EVTOT(1)) EVBASE=EVTOT(1)
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  H UAVG FORMULATION FOLLOWING DAVIES (1990) + [EQ. (33)]
C...  
      IF(IEVC.EQ.30) THEN
         UAVMAG=SQRT(UU*UU+VV*VV)
         EVBASE=0.025*H*UAVMAG/9.001D0
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.31) THEN
         UAVMAG=SQRT(UU*UU+VV*VV)
         EVBASE = EVCON*H*UAVMAG
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.32) THEN
         UAVMAG=SQRT(UU*UU+VV*VV)
         EVBASE = 0.025*H*UAVMAG/9.001D0
         EVTOT(1) = EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.33) THEN
         UAVMAG=SQRT(UU*UU+VV*VV)
         EVBASE=EVCON*H*UAVMAG
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  UAVG SQUARED FORMULATION FOLLOWING DAVIES (1990) + [EQ. (34)]
C...  
      IF(IEVC.EQ.40) THEN
         UAVMAGS=UU*UU+VV*VV
         EVBASE=2.D0*UAVMAGS/9.001D0
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.41) THEN
         UAVMAGS=UU*UU+VV*VV
         EVBASE=EVCON*UAVMAGS
         DO J=1,NFEN
            EVTOT(J) = EVBASE
         END DO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.42) THEN
         UAVMAGS=UU*UU+VV*VV
         EVBASE=2.D0*H*UAVMAGS/9.001D0
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF
      IF(IEVC.EQ.43) THEN
         UAVMAGS=UU*UU+VV*VV
         EVBASE=EVCON*UAVMAGS
         EVTOT(1)=EVBASE/1000.D0  
         SLOPE=(EVBASE-EVTOT(1))/(0.2D0*amb)
         BREAK=b+0.2D0*amb
         EVBEGIN=EVTOT(1)-SLOPE*b
         DO J=2,NFEN
            IF(SIGMA(J).LE.BREAK) THEN
               EVTOT(J)=EVBEGIN+SLOPE*SIGMA(J)
            ELSE
               EVTOT(J)=EVBASE
            ENDIF
         ENDDO
         GOTO 100
      ENDIF

C...  
C...  MELLOR-YAMADA LEVEL 2.5 CLOSURE
C...  
      IF(IEVC.EQ.50) THEN
         CALL TURB(NODE,H,DELT,BSX,BSY,WSX,WSY)
         GOTO 100
      ENDIF
      
C...  
C...  ONCE EDDY VISCOSITY IS COMPUTED
C...  


 100  CONTINUE

C...  
C...  CHECK SO THAT EDDY VISCOSITY NEVER GETS BELOW MINIMUM VALUE
C...  
      DO J=1,NFEN
         IF(EVTOT(J).LT.EVMIN) THEN
            EVTOT(J)=EVMIN
            IF(IDIAG.NE.0) THEN
               IF(NSCREEN.NE.0) WRITE(6,410) IT,NODE,J
               WRITE(16,410) IT,NODE,J
 410           FORMAT(' ****** WARNING FROM SUBROUTINE EDDYVISC ******',
     &              ' E.V. RESET TO MIN E.V. @ TIME STEP',I8,
     &              ' HORIZ NODE = ',I8,' VERT NODE = ',I3)
            ENDIF
         ENDIF
      ENDDO

C...  
C...  PRINT DETAILED DIAGNOSTICS IF DESIRED
C...  
      IF(IDIAG.EQ.2) THEN       !WRITE GENERAL DIAGNOSTIC OUTPUT
         WRITE(2,*) 'SUBROUTINE EDDYVIS, vert eddy visc node', node
         DO J=1,NFEN
            WRITE(2,420) J, EVTOT(J)
 420        FORMAT(2X,'EVTOT(',I4,')=',E15.8)
         ENDDO
      ENDIF

C...  
C...  RETURN
C...  
      RETURN
      END


C***********************************************************************
C                                                                      *
C   Solver for a vector U of length nfen for a tridiagonal system of   *
C          equations with the form                                     *
C                                                                      *
C    **                               **   **    **   **    **         *
C    * Bn   An                         *   *  Un  *   *  Rn  *         *
C    *                                 *   *      *   *      *         *
C    * Cn-1 Bn-1 An-1                  *   * Un-1 *   * Rn-1 *         *
C    *                                 *   *      *   *      *         *
C    *      Cn-2 Bn-2 An-2             *   * Un-2 *   * Rn-2 *         *
C    *                                 *   *      *   *      *         *
C    *             .......             *   * .... *   * .... *         *
C    *                                 *   *      *   *      *         *
C    *                  C3 B3 A3       *   *  U3  * = *  R3  *         *
C    *                                 *   *      *   *      *         *
C    *                     C2 B2 A2    *   *  U2  *   *  R2  *         *
C    *                                 *   *      *   *      *         *
C    *                        C1 B1    *   *  U1  *   *  R1  *         *
C    **                               **   **    **   **    **         *
C                                                                      *
C      A, B, C, U, R are adjustable size arrays                        *
C                                                                      *
C      U(1 - nfen) are the complex velocities from bottom to top       *
C                                                                      *
C                                                                      *
C                         R.L.  11/18/94                               *
C***********************************************************************
C
      SUBROUTINE TRIDIAG(A,B,C,R,U,nfen)
      IMPLICIT COMPLEX (A-H,O-Z)
      DIMENSION A(*),B(*),C(*),R(*),U(*)
C     
      DO 11 J=nfen-1,1,-1
         IF(ABS(B(J+1)).EQ.0.) then
            write(*,*) 'Diagonal term in the VS matrix is zero'
            write(*,*) '*********** Fatal error *************'
            write(1,*) 'Diagonal term in the VS matrix is zero'
            write(1,*) '*********** Fatal error *************'
            stop
         endif
         P1=C(J)/B(J+1)
         B(J)=B(J)-A(J+1)*P1
         R(J)=R(J)-R(J+1)*P1
 11   CONTINUE

      IF(ABS(B(1)).EQ.0.) then
         write(*,*) 'B1 term in the VS matrix is zero'
         write(*,*) '*********** Fatal error *************'
         write(1,*) 'B1 term in the VS matrix is zero'
         write(1,*) '*********** Fatal error *************'
         stop
      endif

      U(1)=R(1)/B(1)

      DO 12 J=2,nfen
 12      U(J)=(R(J)-A(J)*U(J-1))/B(J)
   
      RETURN
      END

C***********************************************************************
C                                                                      *
C                    VSDISP.FOR - VERSION                              *
C                                                                      *
C  This subroutine computes the dispersion terms: Duu, Duv, Dvv        *
C  for the FE VS method as derived in "Dispersion Terms 1/27/92"       *
C                                                                      *
C                                                                      *
C                          R.L. 05/25/00                               *
C***********************************************************************

      Subroutine VSDISP(it,node,H,UU,VV,Duu,Duv,Dvv)

      USE GLOBAL_3DVS, ONLY : SZ,NFEN,SIGMA,GAMMA,AMB,I,NSCREEN,IDIAG


      REAL(SZ) :: UU,VV,Duu,Duv,Dvv
      REAL(8) :: delst,D1P1,Txx,Txy,Tyy,Ump,Vmp,Um,Vm,H

c     
c     parameters
c     
      ierr = 0
c     
c     don't waste time if entire profile is zero
c     
      do j=1,nfen
         if(gamma(j).ne.(0.d0,0.d0)) goto 1
      end do
      Duu = 0.d0
      Duv = 0.d0
      Dvv = 0.d0
      return

c     
c     Domain is split up into intervals according to sigma grid and
c     contribution to total integral is computed on each interval.
c     

 1    Txx = 0.d0
      Txy = 0.d0
      Tyy = 0.d0
      Ump = Real(gamma(1))
      Vmp = -Real(i*gamma(1))
      Do 100 m=1,nfen-1
         mp = m+1
         Um = Ump
         Vm = Vmp
         Ump = Real(gamma(mp))
         Vmp = -Real(i*gamma(mp))
         delst = sigma(mp) - sigma(m)
         D1P1 = delst/3.d0
         Txx = Txx + (Um*Um + Ump*Ump + Um*Ump)*D1P1
         Txy = Txy + ((Um*Vm + Ump*Vmp) + (Um*Vmp + Vm*Ump)/2.d0)*D1P1
         Tyy = Tyy + (Vm*Vm + Vmp*Vmp + Vm*Vmp)*D1P1
 100  continue

      if(Txx.lt.0.) then
         write(*,1001)
 1001    format(/'**** Serious Error Detected in SUBROUTINE VSDISP ***'/
     +        '          the partial uu dispersion term < 0        '/
     +        '        Diagnostic information written to unit 1    ')
         write(*,1101) node,it
         write(1,1002)
 1002    format(/'**** Serious Error Detected in SUBROUTINE VSDISP ***'/
     +        '          the partial uu dispersion term < 0        ')
         write(1,1101) node,it
         write(1,1021)
         do m=1,NFEN            !ntotn -> NFEN
            write(1,1022) sigMA(m), gamma(m) !sigtot -> sigMA
         enddo
         write(1,2101) Txx
 2101    format('  Par uu = ',e14.6,' It will be set to 0.')
         Txx = 0.d0
      endif

      if(Tyy.lt.0.) then
         write(*,1003)
 1003    format(/'**** Serious Error Detected in SUBROUTINE VSSOL ****'/
     +        '          the partial vv dispersion term < 0        '/
     +        '       Diagnostic information written to unit 1    ')
         write(*,1101) node,it
         write(1,1004)
 1004    format(/'**** Serious Error Detected in SUBROUTINE VSSOL ****'/
     +        '          the partial vv dispersion term < 0        ')
         write(1,1101) node,it
         write(1,1021)
         do m=1,NFEN            !ntotn -> NFEN
            write(1,1022) sigMA(m),gamma(m) !sigtot -> sigMA
         enddo
         write(1,2102) Tyy
 2102    format('  Par vv = ',e14.6,' It will be set to 0.')
         Tyy = 0.d0
      endif

 1101 format(/' Error occurred at node ',I6,' time step ',I8/)
 1021 format(8x,'sigMA',11x,'  u ',12x,'  v ')
 1022 format(1x,3e16.8)

      Duu = Txx*H/amb - H*UU*UU
      Duv = Txy*H/amb - H*UU*VV
      Dvv = Tyy*H/amb - H*VV*VV

      if(Duu.lt.0.) Duu = 0.d0
      if(Dvv.lt.0.) Dvv = 0.d0
c     
c     Diagnostic Printouts
c     
      if(idiag.eq.2) then
         write(2,*)'SUBROUTINE VSDISP, node', node
         write(2,1103) Txx,Txy,Tyy
 1103    format('  Par uu = ',e14.6,'  Par uv = ',e14.6,' Par vv = ',
     +        e14.6)
         write(2,1023) Duu,Duv,Dvv
 1023    format('  Duu = ',e14.6,'  Duv = ',e14.6,' Dvv = ',e14.6)
      endif

      return
      end


c***********************************************************************
c     Subroutine to compute the Inm integral                           *
c                                                                      *
c     Note, Inm is based only on the f.e. grid and therefore is the    *
c     same for all horizontal nodes.                                   *
c                                                                      *
c     11/24/01                                                         *
c                                                                      *
c***********************************************************************

      subroutine InmINT()
c      subroutine InmINT(Inm)

c      USE GLOBAL_3DVS, ONLY : SZ, SIGMA, NFEN
       USE GLOBAL_3DVS, ONLY : SZ, SIGMA, NFEN, Inm

c      REAL(SZ) :: Inm(NFEN,3)

C     integral over lower element of psi(k-1)*psi(k)
      Inm(1,1) = 0.d0
C     integral over upper element of psi(k+1)*psi(k)
      Inm(1,3) = (Sigma(2)-Sigma(1))/6.d0
C     integral over both elements of psi(k)*psi(k)
      Inm(1,2) = 2.d0*Inm(1,3) 

      do k=2,NFEN-1
C     integral over lower element of psi(k-1)*psi(k)
         Inm(k,1) = Inm(k-1,3) 
C     integral over upper element of psi(k+1)*psi(k)
         Inm(k,3) = (Sigma(k+1)-Sigma(k))/6.d0
C     integral over both elements of psi(k)*psi(k)
         Inm(k,2) = 2.d0*(Inm(k,1)+Inm(k,3))
      enddo

C     integral over lower element of psi(k-1)*psi(k)
      Inm(NFEN,1) = Inm(NFEN-1,3)
C     integral over both elements of psi(k)*psi(k)  
      Inm(NFEN,2) = 2.d0*Inm(NFEN,1)
C     integral over upper element of psi(k+1)*psi(k)
      Inm(NFEN,3) = 0.d0        
         
      return
      end

c***********************************************************************
c      Subroutine to compute the LVn integral (used only in VS)        *
c                                                                      *
c                            11/14/94                                  *
c***********************************************************************

      subroutine LVnInt(LVn)

      USE GLOBAL_3DVS, ONLY : SZ,IDIAG,SIGMA,EVTOT,NFEN

      REAL(SZ) :: LVn(NFEN)

      LVn(1) = (sigma(2) - sigma(1))/2.d0

      DO n=2,nfen-1
         LVn(n) = (sigma(n+1) - sigma(n-1))/2.d0
      enddo

      LVn(nfen) = (sigma(nfen) - sigma(nfen-1))/2.d0

      if(idiag.eq.2) then       !write diagnostic output
         write(2,*) '********** LVnInt **********'
         write(2,*) '***** LVn *****'
         do n=1,nfen
            write(2,950) LVn(n)
 950        format(2x,e16.8)
         end do
         write(2,*) ' '
      endif

      RETURN
      END


c***********************************************************************
c      Subroutine to compute the KQnm integral                         *
c                                                                      *
c                            01/26/00                                  *
c***********************************************************************

      subroutine KQnmInt(KQnm,Kq)

      USE GLOBAL_3DVS, ONLY : SZ,SIGMA,NFEN,IDIAG

      REAL(SZ) :: KQnm(NFEN,3),Kq(NFEN)
      REAL(8) :: EM,EP

c     do 1st element by hand

      EP=(Kq(2)+Kq(1))/(sigma(2)-sigma(1))/2.d0
      KQnm(1,1)=0.D0
      KQnm(1,2)=EP
      KQnm(1,3)=-EP

c     loop through interior elements
c     NOTE: the integrals from sigma(n-1) to sigma(n) are simply integrals
c     the integrals from sigma(n) to sigma(n+1) from previous element

      DO n=2,nfen-1
         EM=EP
         EP=(Kq(n+1)+Kq(n))/(sigma(n+1)-sigma(n))/2.d0
         KQnm(n,1)=-EM
         KQnm(n,2)=EM+EP
         KQnm(n,3)=-EP
      ENDDO

c     do last element by hand

      EM=EP
      KQnm(nfen,1)=-EM
      KQnm(nfen,2)=EM
      KQnm(nfen,3)=0.D0

c     if desired, write diagnostics

      if(idiag.gt.0) then           
         write(2,*) '********** KQmInt **********'
         write(2,*) '***** KQnm *****'
         do n=1,nfen
            write(2,951) (KQnm(n,i),i=1,3)
 951        format(3f16.9)
         end do
         write(2,*) ' '
      endif

      return
      end


c************************************************************************
c MY2.5 TURBULENCE MODEL PROGRAM
c VELOCITY SOLUTION VERSION
c
c written by R. Luettich based on earlier subroutines by R. Grenier
c
c OVERVIEW
c
c     This code uses the quasi-equilibrium version of the Mellor-Yamada
c     turbulence scheme (Mellor and Yamada, 1982, Blumberg and Mellor,
c     1987 and Galperin et al., 1988) to solve transport equations for
c     q**2 and q**2l.  The parameters q and l are used to compute the
c     eddy viscosity according to the relation:
c
c             Km = Smql
c
c     where Km is the eddy viscosity and Sm is a stability parameter.
c
c     This routine is called from the EDDYVIS subroutine during the
c     internal mode solution for ievc = 50.  There are separate DSS and
c     VS versions of the code.
c
c    *** SEE SECTION TITLED "USERS GUIDE" BELOW ***
c
c     This routine should be linked with the 3D Code subroutines (ADCIRC
c     + VS) after running the setup program
c
c PARAMETER DEFINITIONS:
c
c argument list:
c
c nh          : horizontal node counter
c H           : total depth (includes finite amplitude)
c it          : current time step value
c delt        : simulation incremental time step (uses same step as
c               internal and external modes)
c nws         : switch for wind stress (nws=1 for wind on,
c               nws=0 for wind off). This affects the surface
c               boundary condition. Set in the external mode and passed in.
c bsx,bsy     : x,y bottom stresses
c wsx,wsy     : x,y surface stresses
c Z0B         : bottom roughness/mixing length (see USER's notes
c               below)
c Z0S         : surface roughness/mixing length (see USER's notes
c               below)
c
c Coeff block:
c
c Sq          : stability function used in definition of the eddy
c               diffusivity of the turbulence parameters (Sq = 0.2)
c Sm          : stability function used in definition of the eddy
c               viscosity (see Galperin, et al. for exact form)
c Sh          : stability function used in definition of the eddy
c               diffusivity of the density (see Galperin, et al.
c               for exact form)
c B1,E1,E2,E3 : empirical constants (values given below; see Mellor and
c               Yamada, 1982 & Blumberg et al, 1992 for discussion)
c
c Turbmod block:
c
c Q (real, imag): x,y direction dependent variables from the vertical
c               solution
c
c Vgrid block, Setup Block
c
c parameters as defined in the internal mode subroutines
c
c Other calculation parameters:
c
c q2l         : 2xTKE times the master length scale
c q20         : previous time step value of q2
c l           : master length scale
c Km          : momentum eddy viscosity
c Kq          : turbulence eddy viscosity
c Kh          :
c Mqa,Mqb,Mqc : LHS matrix diagonals for the q2 and q2l solutions
c LVq         : RHS load vector for the q2 and q2l solutions
c q2          : solution vector returned from the tridiagonal solver
c w           : wall function (see Blumberg at al., 1992)
c BVflux2     : Brunt Vaislai frequency squared
c Gh          : dimensionless density function
c SIGT        : profile of density (sigma T)
c
c Flags, run control and miscellaneous parameters
c
c iden        : density flag (iden > 0 density included,iden = 0 no density)
c im          : run type flag - vs (im = 1) or dss (im = 2)
c il          : length scale flag - il = 2 or 3 for algebraic length scale (see below),
c               il = 1 for length scale computed from the q2l equation (see user notes below)
c ibc         : boundary condition flag for q2 (0=constant/zero,1=no-flux)
c               User should set ibc = 0 for nws = 1
c
c
c SUBROUTINES
c
c turb        : main module - handles input, run control and output.
c TRIDAG      : tridiagonal matrix solver
c
c
c USER'S GUIDE
c
c     The user must set a number of parameter statements and flags prior
c     to operation:
c
c parameter statements **Check all subroutines**
c  mnodes = maximum number of vertical nodes
c  mnp = maximum number of horizontal nodes
c
c flags (SEE DISCUSSION ABOVE UNDER flags, run control and miscellaneous parameters)
c
c     The value of Z0B should be set consistent with the bottom boundary
c     condition used in the internal mode solution.  For a no-slip BBC,
c     choose Z0B as a physical roughness height, e.g. 0.005m.  For a
c     slip case, set Z0B to a value consistent with the slip coefficient
c     used via the log profile, (e.g., 1 m).  Tests suggest that when a
c     no-slip condition is used with the VS model (for which the bottom
c     nodes are very tightly spaced) it is best to set the time
c     weighting parameter for the momentum diffusion term (alpha3 in
c     input unit 15) to 1.0 to avoid instability problems. When a slip
c     condition is used (or whenever the bottom grid spacing is about
c     1m) a Crank-Nicholson approach (alpha3 = 0.5) is acceptable.
c
c     The number of vertical nodes used in the solution of the
c     turbulence equations is the same as the number of nodes used in
c     the solution of the dependent variable (velocity or stress) in the
c     internal mode.  This is unlike the other forms of eddy viscosity,
c     for which the two grids are different and the number of nodes used
c     to define the eddy viscosity is generally less.
c
c     This code assumes that any density field is passed into the
c     routine via a common block called "DENSITY3D", which includes a
c     density profile on the internal mode solution grid at each point
c     in the horizontal.  Any updating of this profile must be done
c     externally and passed into this routine.  The density be passed as
c     sigma t units, and the background density is RHOWAT0.
c
c     Model output is limited to printing results for a single
c     horizontal node.  Additional coding would be required to create
c     full output files.
c
c
c REFERENCES
c
c     Blumberg, A.F. and G.L. Mellor, A Description of a
c     Three-Dimensional Coastal Ocean Circulation Model, In:
c     Three-Dimensional Coastal Ocean Models, edited by N.S. Heaps,
c     pp. 1-16, American Geophysical Union, Washington, D.C., 1987.
c
c     Blumberg, A.F., B. Galperin and D.J. O'Connor, Modeling vertical
c     structure of open channel flows, Journal of Hydraulic Engineering,
c     118, 1119-1134., 1992.
c
c     Galperin, B., L.H. Kantha, S. Hassid and A. Rosati, A
c     quasi-equilibrium turbulent energy model for geophysical flows,
c     Journal of the Atmospheric Sciences, 45, 55-62, 1988.
c
c     Mellor, G.L. and T. Yamada, Development of a turbulence closure
c     model for geophysical fluid problems, Reviews of Geophysics and
c     Space Physics, 20, 851-875, 1982.
c
c************************************************************************
      subroutine turb(nh,H,delt,bsx,bsy,wsx,wsy)

      USE GLOBAL_3DVS, EXCEPT_BSX => BSX ,EXCEPT_BSY => BSY
C      implicit none
      
      COMPLEX :: dQdz,dQdz1,dQdz2
      REAL(8) :: H

      REAL(SZ) :: DELT,BSX,BSY,WSX,WSY
      REAL(SZ),SAVE :: Sh,H2
      REAL(SZ),SAVE,ALLOCATABLE :: KQnm(:,:)
      REAL(SZ),SAVE,ALLOCATABLE :: Mqa(:),Mqb(:),Mqc(:)
      REAL(SZ),SAVE,ALLOCATABLE :: LVq(:),Sm(:)
      REAL(SZ),SAVE,ALLOCATABLE :: q2(:),q2prev(:)
      REAL(SZ),SAVE,ALLOCATABLE :: q2l(:),q2lprev(:)
      REAL(SZ),SAVE,ALLOCATABLE :: wall(:),rmlen(:),rmlen2(:)
      REAL(SZ),SAVE,ALLOCATABLE :: BVfreq2(:),spgrad2(:)
      REAL(SZ),SAVE,ALLOCATABLE :: Kq(:),Km(:),Kh(:)
      REAL(SZ),SAVE,ALLOCATABLE :: prod(:),diss(:)

      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '********** TURB MODEL **********'
         WRITE(2,*) '      **** node **** ',NH
      ENDIF

c     allocate local arrays
      if(.not. turb_allocated) then
         allocate(KQnm(mnodes,3))
         allocate(Mqa(mnodes),Mqb(mnodes),Mqc(mnodes))
         allocate(LVq(mnodes),Sm(mnodes))
         allocate(q2(mnodes),q2prev(mnodes))
         allocate(q2l(mnodes),q2lprev(mnodes))
         allocate(wall(mnodes),rmlen(mnodes),rmlen2(mnodes))
         allocate(BVfreq2(mnodes),spgrad2(mnodes))
         allocate(Kq(mnodes),Km(mnodes),Kh(mnodes))
         allocate(prod(mnodes),diss(mnodes))
         turb_allocated = .true.
      endif
c     
c     At time step 1, set flags and initialize variables
c     
      if(istart.eq.1) then
         il = 1                 ! length scale flag, =1 for length scale from q2l eqn.
         ibc = 0                ! surface b.c. flag, =0 for specified stress, =1 for no flux
         if((nws.eq.0).or.(nws.eq.100)) ibc=1
c     set constants and other parameters
         rkap = 0.41d0
         B1 = 16.6d0
         B123 = B1**(2.d0/3.d0)
         g2 = 0.39327d0
         g3 = 3.0858d0
         g4 = 34.676d0
         g5 = 6.1272d0
         g6 = 0.49393d0
         E1 = 1.8d0
         E2 = 1.33d0
         E3 = 0.25d0
         q2min=1.d-8
c    
         Sq = 0.2d0 ! initialize the stability constant stability function

c     initialize the Brunt-Vaisala freq squared = 0 if density not considered
         if(iden.eq.0) then
            do n=1,nfen
               BVfreq2(n)=0.d0            
            end do
         endif
c     initialization for a cold start only
         if(ihot.eq.0) then
            do n = 1,nfen
               q20(nh,n) = q2min ! initialize q2 to a minimal value
c     initilize l to a minimal value if computed from q2l equation
               if(il.eq.1) then
c     l(nh,n)=rkap*Z0B                        !rog way
                  l(nh,n)=rkap*(Z0B*(a-sigma(n))-Z0S*(b-sigma(n)))/amb
               endif
c     set l to an exponential type length scale (davies and xing)
               if(il.eq.2)then
                  sig = (sigma(n)+1.d0)/amb
                  rl1 = 1.d0/(rkap*(sig*H+Z0B)*exp(-amb*sig))
                  rl2 = 1.d0/(rkap*(H-sig*H+Z0S))
                  l(nh,n) = 1.d0/(rl1+rl2)
               endif
c     set l to a linear variation with kz over lower 15% with constant above
               if(il.eq.3)then
                  HOamb=H/amb
                  zval = (sigma(n)+1.d0)*HOamb-H
                  if(sigma(n).le.-0.7d0) l(nh,n)=rkap*(H+zval+Z0B)
                  if(sigma(n).gt.-0.7d0) l(nh,n)=rkap*(0.15d0*H+Z0B)
               endif
            end do
         endif
c     end cold start initialization
         if(idiag.gt.0) then
            write(2,*) '***** BVfreq2, l, q20  *****'
            do n=1,nfen
               write(2,*) BVfreq2(n),l(nh,n),q20(nh,n)
            end do
         endif
      endif                     !end of 1st time step section
c     
c     Begin calculations for each time step
c     
      H2 = H*H
      HOamb=H/amb
      HOamb2=(H/amb)*(H/amb)

c     Compute the speed gradient squared, density gradient, BV freq
c     and split out the mixing length

      rmlen(1)=l(nh,1)
      rmlen2(1)=rmlen(1)*rmlen(1)
      dsig=sigma(2)-sigma(1)
      if(iden.gt.0) then
         drhodz=((SIGT(nh,2)-SIGT(nh,1))/dsig)/HOamb
         BVfreq2(1)=-GORHO*drhodz
      endif
      dQdz=((Q(nh,2)-Q(nh,1))/dsig)/HOamb
      dudz=real(dQdz)
      dvdz=aimag(dQdz)
      spgrad2(1)=dudz*dudz+dvdz*dvdz
      
      do n=2,nfen-1
         rmlen(n)=l(nh,n)
         rmlen2(n)=rmlen(n)*rmlen(n)
         dsig1=sigma(n+1)-sigma(n)
         dsig2=sigma(n)-sigma(n-1)
         if(iden.gt.0) then
            drhodz1=((SIGT(nh,n+1)-SIGT(nh,n))/dsig1)/HOamb
            drhodz2=((SIGT(nh,n)-SIGT(nh,n-1))/dsig2)/HOamb
            BVfreq2(n)=-GORHO*(drhodz1+drhodz2)/2.d0
         endif
         dQdz1=((Q(nh,n+1)-Q(nh,n))/dsig1)/HOamb
         dQdz2=((Q(nh,n)-Q(nh,n-1))/dsig2)/HOamb
         dQdz=(dQdz1+dQdz2)/2.d0
         dudz=real(dQdz)
         dvdz=aimag(dQdz)
         spgrad2(n)=dudz*dudz+dvdz*dvdz
      enddo

      rmlen(nfen)=l(nh,nfen)
      rmlen2(nfen)=rmlen(nfen)*rmlen(nfen)
      dsig=sigma(nfen)-sigma(nfen-1)
      if(iden.gt.0) then
         drhodz=((SIGT(nh,nfen)-SIGT(nh,nfen-1))/dsig)/HOamb
         BVfreq2(nfen)=-GORHO*drhodz
      endif
      dQdz=((Q(nh,nfen)-Q(nh,nfen-1))/dsig)/HOamb
      dudz=real(dQdz)
      dvdz=aimag(dQdz)
      spgrad2(nfen)=dudz*dudz+dvdz*dvdz
      
c     Compute the wall function if the mixing length is determined from
c     q2l eqn

      if(il.eq.1)then
         BSlay=Z0B
         SSlay=Z0S
         do n = 1,nfen
            db=(HOamb*(sigma(n)-b)+BSlay)*rkap
            db2=db*db
            ds=(HOamb*(a-sigma(n))+SSlay)*rkap
            ds2=ds*ds
            wall(n) = 1.d0 + E2*rmlen2(n)/db2 + E3*rmlen2(n)/ds2
         enddo
      endif

      if(idiag.gt.0) then
         write(2,*) '*****   spgrad2,  rmlen,   wall  *****'
         do n=1,nfen
            write(2,*) spgrad2(n),rmlen(n),wall(n)
         end do
      endif

c     Compute the stability functions, eddy viscosity and partial
c     turbulence production & dissipation terms using information from
c     the previous time step

      do n = 1,nfen
         q2prev(n)=q20(nh,n)
         q2lprev(n)=q2prev(n)*rmlen(n)
         qprev=sqrt(q2prev(n))
         qlprev=qprev*rmlen(n)
         Gh=-BVfreq2(n)*rmlen2(n)/q2prev(n)
         if(Gh.gt.0.0233) Gh=0.0233
         Sm(n)=(g2-g3*Gh)/((1.d0-g4*Gh)*(1.d0-g5*Gh))
         Sh=g6/(1.d0-g4*Gh)
         Km(n)=Sm(n)*qlprev
         if(Km(n).lt.EVMIN) Km(n)=EVMIN
c     if(istart.eq.1) Km(n)=EVMIN                        !rog way
         Kq(n)=Sq*qlprev                                   
         if(Kq(n).lt.EVMIN) Kq(n)=EVMIN
c     Kq(n)=Km(n)*Sq/Sm(n)                           !rog way
         Kh(n)=Sh*qlprev
         if(Kh(n).lt.EVMIN) Kh(n)=EVMIN
         prod(n)=Km(n)*spgrad2(n)-Kh(n)*BVfreq2(n)
         diss(n)=qprev/(B1*rmlen(n))
c     diss(n)=q2prev(n)*Sm(n)/(Km(n)*B1)             !rog way
      enddo

      if(idiag.gt.0) then
         write(2,*) '*****  Gh,    Sm,     Sh,      Km,      Kq  *****'
         do n=1,nfen
            write(2,*) Gh,Sm(n),Sh,Km(n),Kq(n)
         end do
      endif

c     Compute the q2 LHS Matrix and RHS Load Vector

      call KQnmInt(KQnm,Kq)

      Mqa(1) = 0.d0
      Mqb(1) = 1.d0
      Mqc(1) = 0.d0
      LVq(1) = B123*sqrt(bsx*bsx+bsy*bsy)
      
      coef2 = delt*theta1/HOamb2
c     coef2 = theta1/HOamb2                !rog way
      coef4 = 2.d0*delt
c     coef4 = 2.d0                         !rog way
      coef5 = delt*(1.d0-theta1)/HOamb2
c     coef5 = (1.d0-theta1)/HOamb2         !rog way
      do n=2,nfen-1
         tdiss = 2.d0*diss(n)
         coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss       !rog way
         Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2               !lumping
         Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2)+Inm(n,3))*coef1+KQnm(n,2)*coef2  !lumping
         Mqc(n) = Inm(n,3)*coef1+KQnm(n,3)*coef2
c     Mqc(n) = KQnm(n,3)*coef2                                     !lumping
         
         coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss                      !rog way
         LVq(n) = Inm(n,1)*(coef3*q2prev(n-1)+coef4*prod(n-1))
     &        -KQnm(n,1)*coef5*q2prev(n-1)
     &        + Inm(n,2)*(coef3*q2prev(n  )+coef4*prod(n  ))
     &        -KQnm(n,2)*coef5*q2prev(n)
     &        + Inm(n,3)*(coef3*q2prev(n+1)+coef4*prod(n+1))
     &        -KQnm(n,3)*coef5*q2prev(n+1)
c     LVq(n) =                 -KQnm(n,1)*coef5*q2prev(n-1)     !lumping
c     &         + (Inm(n,1)+Inm(n,2)+Inm(n,3))                  !lumping
c     &         *(coef3*q2prev(n)+coef4*prod(n))     !lumping
c     &         -KQnm(n,2)*coef5*q2prev(n)       !lumping
c     &         -KQnm(n,3)*coef5*q2prev(n+1)     !lumping

      enddo

      if(ibc.eq.0) then
         Mqa(nfen) = 0.d0
         Mqb(nfen) = 1.d0
         Mqc(nfen) = 0.d0
         LVq(nfen) = B123*sqrt(wsx*wsx+wsy*wsy)
      endif

      if(ibc.eq.1)then
         n=nfen
         tdiss = 2.d0*diss(n)
         coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss                   !rog way    
         Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2                           !lumping
         Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2))*coef1+KQnm(n,2)*coef2 !lumping
         Mqc(n) = 0.d0

         coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss            !rog way
         LVq(n) = Inm(n,1)*(coef3*q2prev(n-1)+coef4*prod(n-1))
     &        -KQnm(n,1)*coef5*q2prev(n-1)
     &        + Inm(n,2)*(coef3*q2prev(n  )+coef4*prod(n  ))
     &        -KQnm(n,2)*coef5*q2prev(n)
c     LVq(n) =    -KQnm(n,1)*coef5*q2prev(n-1)   !lumping
c     &    + (Inm(n,1)+Inm(n,2))*(coef3*q2prev(n)+coef4*prod(n))       !lumping
c     &         -KQnm(n,2)*coef5*q2prev(n)     !lumping
      endif

c     Solve the system for q2

      CALL TRIDAG(Mqa,Mqb,Mqc,LVq,q2,nfen)

c     Transfer to global array and check for zero or negative values
c     (generally for startup)

      do n = 1,nfen
         if(q2(n).le.0.)then
            q2(n) = q2min
         endif
         q20(nh,n) = q2(n)
      enddo

c     
c     write q2 diagnostics if idiag = 1,2
c     
      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '***** Q2:prod, diss, Q2L prev *****'
         DO N=1,NFEN
            WRITE(2,998) prod(N),diss(N),q2lprev(n)
 998        FORMAT(2X,E14.6,2X,E14.6,2X,E14.6)
         END DO
         WRITE(2,*) '***** Q2:RHS LOAD VECTOR *****'
         DO N=1,NFEN
            WRITE(2,1000) LVq(N)
 1000       FORMAT(2X,e12.4)
         END DO
         WRITE(2,*) '***** Q2:LHS MATRIX *****'
         DO N=1,NFEN
            WRITE(2,1001) Mqa(N),Mqb(n),Mqc(n)
 1001       FORMAT(3(2X,e12.4))
         END DO
         WRITE(2,*) '***** Q2 *****'
         DO N=1,NFEN
            WRITE(2,1001) q2(N)
         END DO
      END IF

c     Compute length scale

      if(il.eq.2)then
         do n=1,nfen
            sig = (sigma(n)+1.d0)/amb
            rl1 = 1.d0/(rkap*(sig*H+Z0B)*exp(-amb*sig))
            rl2 = 1.d0/(rkap*(H-sig*H+Z0S))
            l(nh,n) = 1.d0/(rl1+rl2)
         enddo
      endif
      
      if(il.eq.3)then
         do n=1,nfen
            HOamb=H/amb
            zval = (sigma(n)+1.d0)*HOamb-H
            if(sigma(n).le.-0.7d0) l(nh,n)=rkap*(H+zval+Z0B)
            if(sigma(n).gt.-0.7d0) l(nh,n)=rkap*(0.15d0*H+Z0B)
         enddo
      endif
      
      if(il.eq.1)then
         
c     Compute the q2l LHS Matrix and RHS Load Vector

         Mqa(1) = 0.d0
         Mqb(1) = 1.d0
         Mqc(1) = 0.d0
         LVq(1) = rkap*BSlay*q2(1)

         coef2 = delt*theta1/HOamb2
c     coef2 = theta1/HOamb2                                     !rog way
         coef5 = delt*(1.d0-theta1)/HOamb2
c     coef5 = (1.d0-theta1)/HOamb2                              !rog way
         do n=2,nfen-1
            tdiss = wall(n)*diss(n)
            coef1 = 1.d0 + delt*theta2*tdiss
c     coef1 = 1.d0/delt + theta2*tdiss                        !rog way
            Mqa(n) = Inm(n,1)*coef1+KQnm(n,1)*coef2
c     Mqa(n) = KQnm(n,1)*coef2                                !lumping
            Mqb(n) = Inm(n,2)*coef1+KQnm(n,2)*coef2
c     Mqb(n) = (Inm(n,1)+Inm(n,2)+Inm(n,3))*coef1+KQnm(n,2)*coef2   !lumping
            Mqc(n) = Inm(n,3)*coef1+KQnm(n,3)*coef2
c     Mqc(n) = KQnm(n,3)*coef2                                !lumping

            coef3 = 1.d0 - delt*(1.d0-theta2)*tdiss
c     coef3 = 1.d0/delt - (1.d0-theta2)*tdiss                 !rog way
            coef4 = E1*rmlen(n)*delt
c     coef4 = E1*rmlen(n)                                     !rog way
            LVq(n) = Inm(n,1)*(coef3*q2lprev(n-1)+coef4*prod(n-1))
     &           -KQnm(n,1)*coef5*q2lprev(n-1)
     &           + Inm(n,2)*(coef3*q2lprev(n  )+coef4*prod(n  ))
     &           -KQnm(n,2)*coef5*q2lprev(n)
     &           + Inm(n,3)*(coef3*q2lprev(n+1)+coef4*prod(n+1))
     &           -KQnm(n,3)*coef5*q2lprev(n+1)
c     LVq(n) =      -KQnm(n,1)*coef5*q2lprev(n-1)  !lumping
c     &    + (Inm(n,1)+Inm(n,2)+Inm(n,3))                           !lumping
c     &     *(coef3*q2lprev(n)+coef4*prod(n))                       !lumping
c     &       -KQnm(n,2)*coef5*q2lprev(n)    !lumping
c     &     -KQnm(n,3)*coef5*q2lprev(n+1)  !lumping
c     
         enddo

         Mqa(nfen) = 0.d0
         Mqb(nfen) = 1.d0
         Mqc(nfen) = 0.d0
         LVq(nfen) = SSlay*rkap*q2(nfen)
         
c     Solve the system for q2l

         CALL TRIDAG(Mqa,Mqb,Mqc,LVq,q2l,nfen)

c     Transfer to global array and check for stability limit

         l(nh,1) = q2l(1)/q2(1)
         do n = 2,nfen-1
            l(nh,n) = q2l(n)/q2(n)
            if(l(nh,n).lt.0.) 
     &           l(nh,n)=rkap*(Z0B*(a-sigma(n))-Z0S*(b-sigma(n)))/amb
            if(l(nh,n).gt.H) l(nh,n)=H
            if((iden.gt.0).and.(BVfreq2(n).gt.0.0)) then
               elmax = 0.53D0*sqrt(q2(n))/sqrt(BVfreq2(n))
               if(l(nh,n).gt.elmax) l(nh,n)=elmax
            endif
         end do
         l(nh,nfen) = q2l(nfen)/q2(nfen)
      endif

c     
c     compute eddy viscosity and store variables for output and next step
c     
      do n = 1,nfen
         EVTOT(n) = Sm(n)*sqrt(q2(n))*l(nh,n)
         if(EVTOT(n).lt.EVMIN) EVTOT(n)=EVMIN
      end do

c     
c     write q2l diagnostics if idiag = 2
c     
      IF(IDIAG.GT.0) THEN
         WRITE(2,*) '***** Q2L:RHS LOAD VECTOR *****'
         DO N=1,NFEN
            WRITE(2,1000) LVq(N)
         END DO
         WRITE(2,*) '***** Q2L:LHS MATRIX *****'
         DO N=1,NFEN
            WRITE(2,1001) Mqa(N),Mqb(n),Mqc(n)
         END DO
         WRITE(2,*) '***** Q2,L,EVTOT *****'
         DO N=1,NFEN
            WRITE(2,1001) q2(N),L(nh,n),EVTOT(n)
         END DO
      END IF

      return
      END


C***********************************************************************
C Subroutine tridag                                                    *
C                                                                      *
C     -----------------------------------------------------------------*
C     |SOLVER FOR A VECTOR U OF LENGTH N FROM A SET OF LINEAR          *
C     |EQUATIONS THAT CONTAINS A TRIDIAGONAL MATRIX                    *
C     |THE FORM IS                                                     *
C     |                                                                *
C     |   * B1 C1  0 ...               *     * U1 *     * R1 *         *
C     |  *                              *   *      *   *      *        *
C     |  *  A2 B2 C2 ...                *   *  U2  *   *  R2  *        *
C     |  *  ...                         * * * ...  * = * ...  *        *
C     |  *           ... An-1 Bn-1 Cn-1 *   * Un-1 *   * Rn-1 *        *
C     |  *                              *   *      *   *      *        *
C     |   *                0   An  Bn  *     * Un *     * Rn *         *
C     |                                                                *
C     |A, B, C, U ARE ARRAYS.                                          *
C     -----------------------------------------------------------------*
C                                                                      *
C    Adapted from Numerical Recipes chapter 2                          *
C***********************************************************************
c
      SUBROUTINE TRIDAG(A,B,C,R,U,N)
      
      USE GLOBAL_3DVS, ONLY : SZ
      
      INTEGER :: J

      REAL(SZ) :: A(N),B(N),C(N),R(N),U(N)
      REAL(SZ) :: BET,GAM(N)

c     
c     check for zero elements on diagonal
c     
      DO J=1,N
         if(B(j).EQ.0.) then
            write(*,*) 'Problem in Tridag Solver.  ',
     +           'B array value in row ',j,' = 0'
            stop
         endif
      end do
      BET = B(1)
      U(1) = R(1)/BET
      DO J = 2,N
         GAM(J) = C(J-1)/BET
         BET=B(J)-A(J)*GAM(J)
         if (BET.EQ.0) then
            write(*,*) ' Problem in Tridag Solver.  ',
     +           ' BET  = 0.  Solver failed.'
            stop
         endif
         U(J)=(R(J)-A(J)*U(J-1))/BET
      END DO
      DO J = N-1,1,-1
         U(J) = U(J) - GAM(J+1)*U(J+1)
      END DO
      RETURN
      END


C****************************************************************************************
C   Subroutine to interpolate baroclinic pressure (BCP) to a specified sigma value      *
C   (SigmaNN) given an initial guess of which sigma level is closest to the specified   *
C   value.                                                                              *
C                                                                                       *
C                                    R.L.  5/04/01                                      *
C                                    R.L.  5.19/03                                      *
C****************************************************************************************
C
      SUBROUTINE ZSURFBUOY(SigmaNN,BCPressNN,NN,J)

      USE GLOBAL_3DVS
      REAL(SZ) :: BCPressNN
      REAL(SZ) :: SigmaNN     !Sigma value of a neighbor node

      IF(SigmaNN.LE.1.0001*b) THEN !if into ground then skip
         SigBelo=-999
         SigAbov=-999
         BPressNN=-999.
         GOTO 100
      ENDIF
      IF((SigmaNN.GT.1.0001*b).AND.(SigmaNN.LE.b)) THEN !at bottom then use bottom
         LBelo=1
         BPressNN=BCP(NN,LBelo)
         SigBelo=b
         SigAbov=b
         GOTO 100
      ENDIF
      IF(SigmaNN.GE.a) THEN     !into air use surface
         LAbov=NFEN
         BPressNN=BCP(NN,LAbov)
         SigBelo=a
         SigAbov=a
         GOTO 100
      ENDIF

      LTry=J                    !start search for SIGABOV and SIGBELO
      SigTry=Sigma(LTry)                    
      IF(SigmaNN.GT.SigTry) THEN !too low
         SigBelo=SigTry         !SIGBELO may = SIGTRY
         LBelo=LTry
         LTry=LTry+1            !look at next level higher
 90      SigTry=Sigma(LTry)
         IF(SigmaNN.GT.SigTry) THEN !still too low
            SigBelo=SigTry
            LBelo=LTry
            LTry=LTry+1
            GOTO 90 
         ENDIF
         SigAbov=SigTry         !found upper bracketing sigma
         LAbov=LTry
         GOTO 99                !go interpolate
      ENDIF
      IF(SigmaNN.LE.SigTry) THEN !to high
         SigAbov=SigTry         !SIGABOV may = SIGTRY
         LAbov=LTry                          
         LTry=LTry-1            !look at next level lower
 91      SigTry=Sigma(LTry)
         IF(SigmaNN.LE.SigTry) THEN !still too high
            SigAbov=SigTry
            LAbov=LTry
            LTry=LTry-1
            GOTO 91
         ENDIF
         SigBelo=SigTry         !found lower bracketing sigma
         LBelo=LTry
      ENDIF

 99   BPressNN=(BCP(NN,LAbov)-BCP(NN,LBelo)) !interpolation
     &     *(SigmaNN-SigBelo)/(SigAbov-SigBelo) + BCP(NN,LBelo)

 100  CONTINUE

      IF(IDiag.EQ.2) THEN
         WRITE(2,*) '******** ZSURFBUOY **********'
         WRITE(2,*) '     NH  NV  SigmaNN   SigBelo   SigAbov',
     &        '      BPressNN'
         WRITE(2,777) NN,J,SigmaNN,SigBelo,SigAbov,BPressNN
 777     FORMAT(I7,I5,3(F10.3),E14.5)
      ENDIF

      RETURN
      END


C****************************************************************************************
C   Subroutine to write out 3D Hot Start info                                           *
C                                                                                       *
C                                    R.L.  2/22/00                                      *
C****************************************************************************************
C
      SUBROUTINE HSTART3D_OUT()

      USE GLOBAL_3DVS

C...  
C...  WRITE HOT START OUTPUT
C...  
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSSD
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISDREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSSV
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISVREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSST
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) ISTREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGD
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGDREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGV
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGVREC
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) NSGT
      IHOTSTP=IHOTSTP+1
      WRITE(IHSFIL,REC=IHOTSTP) IGTREC

      DO NH=1,NP
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DUU(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DUV(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) DVV(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) UU(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VV(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) BSX(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) BSY(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VIDBCPDX(NH)
         IHOTSTP=IHOTSTP+1
         WRITE(IHSFIL,REC=IHOTSTP) VIDBCPDY(NH)
      ENDDO

      DO NH=1,NP
         DO N=1,NFEN
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) REAL(Q(NH,N))
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) AIMAG(Q(NH,N))
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) WZ(NH,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) q20(NH,N)
            IHOTSTP=IHOTSTP+1
            WRITE(IHSFIL,REC=IHOTSTP) l(NH,N)
            IF(IDEN.EQ.1) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SIGT(NH,N)
            ENDIF
            IF(IDEN.EQ.2) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SAL(NH,N)
            ENDIF
            IF(IDEN.EQ.3) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) TEMP(NH,N)
            ENDIF
            IF(IDEN.EQ.4) THEN
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) SAL(NH,N)
               IHOTSTP=IHOTSTP+1
               WRITE(IHSFIL,REC=IHOTSTP) TEMP(NH,N)
            ENDIF
         ENDDO
      ENDDO

      RETURN
      END
