      SUBROUTINE CLOSBF(LUNIT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    CLOSBF
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE IS CALLED IN ORDER TO TERMINATE BUFR
!   ARCHIVE LIBRARY SOFTWARE ACCESS TO A LOGICAL UNIT LUNIT FOR INPUT
!   OR OUTPUT OPERATIONS (PREVIOUSLY OPENED BY A FORTRAN "OPEN" ON THE
!   LOGICAL UNIT AND BY BUFR ARCHIVE LIBRARY SUBROUTINE OPENBF).
!   CLOSBF MUST BE CALLED WHEN LUNIT IS CONNECTED TO A BUFR FILE OPEN
!   FOR OUTPUT IN ORDER TO PROPERLY CLOSE AND WRITE ANY CURRENT BUFR
!   MESSAGE WHICH MAY STILL EXIST IN INTERNAL MEMORY (AND MOST LIKELY
!   NOT BE FULL).  IT IS NOT MANDATORY THAT CLOSBF BE CALLED WHEN LUNIT
!   IS CONNECTED TO A BUFR FILE OPEN FOR INPUT, BUT IT IS STILL A GOOD
!   IDEA TO DO SO.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 2003-11-04  J. ATOR    -- DON'T CLOSE LUNIT IF OPENED AS A NULL FILE
!                           BY OPENBF {NULL(LUN) = 1 IN NEW COMMON
!                           BLOCK /NULBFR/} (WAS IN DECODER VERSION)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY)
!
! USAGE:    CALL CLOSBF (LUNIT)
!   INPUT ARGUMENT LIST:
!     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
!
!   INPUT FILES:
!     UNIT "LUNIT"  - BUFR FILE
!
!   OUTPUT FILES:
!     UNIT "LUNIT"  - BUFR FILE
!
! REMARKS:
!    THIS ROUTINE CALLS:        CLOSMG   STATUS   WTSTAT
!    THIS ROUTINE IS CALLED BY: UFBINX   UFBMEM   UFBTAB
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /NULBFR/ NULL(NFILES)

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.GT.0 .AND. IM.NE.0) CALL CLOSMG(LUNIT)
      CALL WTSTAT(LUNIT,LUN,0,0)

!  CLOSE LUNIT IF NULL(LUN) = 0
!  ----------------------------

      IF(NULL(LUN).EQ.0) CLOSE(LUNIT)

      RETURN
      END SUBROUTINE CLOSBF
