      SUBROUTINE CMSGINI(LUN,MESG,SUBSET,IDATE,NSUB,NBYT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    CMSGINI
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 2002-05-14
!
! ABSTRACT: THIS SUBROUTINE INITIALIZES A NEW BUFR MESSAGE FOR OUTPUT
!   IN COMPRESSED BUFR.  THE ACTUAL LENGTH OF SECTION 4 (CONTAINING
!   COMPRESSED DATA) IS ALREADY KNOWN.
!
! PROGRAM HISTORY LOG:
! 2002-05-14  J. WOOLLEN -- ORIGINAL AUTHOR
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY; LEN3 INITIALIZED AS
!                           ZERO (BEFORE WAS UNDEFINED WHEN FIRST
!                           REFERENCED)
! 2004-08-18  J. ATOR    -- ADDED COMMON /MSGSTD/ AND OTHER LOGIC TO
!                           ALLOW OPTION OF CREATING A SECTION 3 THAT IS
!                           FULLY WMO-STANDARD; IMPROVED DOCUMENTATION;
!                           MAXIMUM MESSAGE LENGTH INCREASED FROM
!                           20,000 TO 50,000 BYTES
! 2005-11-29  J. ATOR    -- CHANGED DEFAULT MASTER TABLE VERSION TO 12
!
! USAGE:    CALL CMSGINI (LUN, MESG, SUBSET, IDATE, NSUB, NBYT)
!   INPUT ARGUMENT LIST:
!     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
!     SUBSET   - CHARACTER*8: TABLE A MNEMONIC FOR TYPE OF BUFR MESSAGE
!                BEING WRITTEN 
!     IDATE    - INTEGER: DATE-TIME STORED WITHIN SECTION 1 OF BUFR
!                MESSAGE BEING WRITTEN, IN FORMAT OF EITHER YYMMDDHH OR
!                YYYYMMDDHH, DEPENDING ON DATELEN() VALUE
!     NSUB     - INTEGER: NUMBER OF SUBSETS, STORED IN SECTION 3 OF
!                BUFR MESSAGE BEING WRITTEN
!     NBYT     - INTEGER: ACTUAL LENGTH (IN BYTES) OF "COMPRESSED DATA
!                PORTION" OF SECTION 4 (I.E. ALL OF SECTION 4 EXCEPT
!                FOR THE FIRST FOUR BYTES)
!
!   OUTPUT ARGUMENT LIST:
!     MESG     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
!                MESSAGE
!     NBYT     - INTEGER: ACTUAL LENGTH OF BUFR MESSAGE (IN BYTES) UP
!                TO THE POINT IN SECTION 4 WHERE COMPRESSED DATA ARE
!                TO BE WRITTEN 
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     I4DY     ISTDESC  NEMTAB
!                               NEMTBA   PKB      PKC      RESTD
!    THIS ROUTINE IS CALLED BY: WRCMPS
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /MSGSTD/ CSMF

      CHARACTER*128 BORT_STR
      CHARACTER*8   SUBSET
      CHARACTER*4   BUFR0
      CHARACTER*1   TAB
      CHARACTER*1   CSMF
      DIMENSION     MESG(*)
      DIMENSION ICD(MAXNC)

      DATA BUFR0/'BUFR'/

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  GET THE MESSAGE TAG AND TYPE, AND BREAK UP THE DATE
!  ---------------------------------------------------

!  .... Given SUBSET, NEMTBA returns MTYP,MSBT,INOD
      CALL NEMTBA(LUN,SUBSET,MTYP,MSBT,INOD)
      CALL NEMTAB(LUN,SUBSET,ISUB,TAB,IRET)
      IF(IRET.EQ.0) GOTO 900

!  DATE CAN BE YYMMDDHH OR YYYYMMDDHH
!  ----------------------------------

      JDATE = I4DY(IDATE)
      MCEN = MOD(JDATE/10**8,100)+1
      MEAR = MOD(JDATE/10**6,100)
      MMON = MOD(JDATE/10**4,100)
      MDAY = MOD(JDATE/10**2,100)
      MOUR = MOD(JDATE      ,100)
      MMIN = 0

!  .... DK: Don't think this can happen, because IDATE=0 is returned
!           as 2000000000 by I4DY meaning MCEN would be 21
      IF(MCEN.EQ.1) GOTO 901

      IF(MEAR.EQ.0) MCEN = MCEN-1
      IF(MEAR.EQ.0) MEAR = 100

!  INITIALIZE THE MESSAGE
!  ----------------------

      MBIT = 0

!  SECTION 0
!  ---------

      CALL PKC(BUFR0 ,  4 , MESG,MBIT)

!     NOTE THAT THE ACTUAL SECTION 0 LENGTH WILL BE COMPUTED AND
!     STORED BELOW; FOR NOW, WE ARE REALLY ONLY INTERESTED IN
!     ADVANCING MBIT BY THE CORRECT AMOUNT, SO WE'LL JUST STORE
!     A DEFAULT VALUE OF 0.

      CALL PKB(   0 , 24 , MESG,MBIT)
      CALL PKB(   3 ,  8 , MESG,MBIT)

!  SECTION 1
!  ---------

      CALL PKB(  18 , 24 , MESG,MBIT)
      CALL PKB(   0 ,  8 , MESG,MBIT)
      CALL PKB(   3 ,  8 , MESG,MBIT)
      CALL PKB(   7 ,  8 , MESG,MBIT)
      CALL PKB(   0 ,  8 , MESG,MBIT)
      CALL PKB(   0 ,  8 , MESG,MBIT)
      CALL PKB(MTYP ,  8 , MESG,MBIT)
      CALL PKB(MSBT ,  8 , MESG,MBIT)
      CALL PKB(  12 ,  8 , MESG,MBIT)
      CALL PKB(   0 ,  8 , MESG,MBIT)
      CALL PKB(MEAR ,  8 , MESG,MBIT)
      CALL PKB(MMON ,  8 , MESG,MBIT)
      CALL PKB(MDAY ,  8 , MESG,MBIT)
      CALL PKB(MOUR ,  8 , MESG,MBIT)
      CALL PKB(MMIN ,  8 , MESG,MBIT)
      CALL PKB(MCEN ,  8 , MESG,MBIT)

!  SECTION 3
!  ---------

!     NOTE THAT THE ACTUAL SECTION 3 LENGTH WILL BE COMPUTED AND
!     STORED BELOW; FOR NOW, WE ARE REALLY ONLY INTERESTED IN
!     ADVANCING MBIT BY THE CORRECT AMOUNT, SO WE'LL JUST STORE
!     A DEFAULT VALUE OF 0.

      CALL PKB(   0 , 24 , MESG,MBIT)
      CALL PKB(   0 ,  8 , MESG,MBIT)
      CALL PKB(NSUB , 16 , MESG,MBIT)
      CALL PKB( 192 ,  8 , MESG,MBIT)

      IF ( ( CSMF.EQ.'N' ) .OR. ( ISTDESC(ISUB).EQ.1 ) )  THEN

!         EITHER NO WMO STANDARDIZATION OF SECTION 3 WAS REQUESTED,
!         OR ELSE ISUB ALREADY HAPPENS TO BE A WMO-STANDARD DESCRIPTOR.
!         IN EITHER CASE, JUST COPY ISUB "AS IS" INTO SECTION 3.

          CALL PKB(ISUB , 16 , MESG,MBIT)
          LEN3 = 10
      ELSE

!         ISUB IS A NON-STANDARD TABLE A DESCRIPTOR THAT NEEDS TO BE
!         EXPANDED INTO AN EQUIVALENT STANDARD SEQUENCE.

          CALL RESTD(LUN,ISUB,NCD,ICD)
          DO N=1,NCD
              CALL PKB(ICD(N), 16, MESG,MBIT)
          ENDDO
          LEN3 = 8+(NCD*2)
      ENDIF

!     ZERO OUT THE FINAL BYTE OF SECTION 3.

      CALL PKB(   0 ,  8 , MESG,MBIT)

!     STORE THE TOTAL LENGTH OF SECTION 3.

!     ASSUMING THAT THERE IS NO SECTION 2, THEN IAD3 POINTS
!     TO THE BYTE IMMEDIATELY PRECEDING THE START OF SECTION 3.

      IAD3 = 8+18
      MBIT = IAD3*8
      CALL PKB(LEN3 , 24 , MESG,MBIT)

!  SECTION 4
!  ---------

      MBIT = (IAD3+LEN3)*8

!     STORE THE TOTAL LENGTH OF SECTION 4.

!     REMEMBER THAT THE INPUT VALUE OF NBYT ONLY CONTAINS THE
!     LENGTH OF THE "COMPRESSED DATA PORTION" OF SECTION 4, SO
!     WE NEED TO ADD FOUR BYTES TO THIS NUMBER IN ORDER TO
!     ACCOUNT FOR THE TOTAL LENGTH OF SECTION 4.

      CALL PKB((NBYT+4) , 24 , MESG,MBIT)
      CALL PKB(       0 ,  8 , MESG,MBIT)

!     THE ACTUAL "COMPRESSED DATA PORTION" OF SECTION 4 WILL
!     BE FILLED IN LATER BY SUBROUTINE WRCMPS.


!  SECTION 5
!  ---------

!     THIS SECTION WILL BE FILLED IN LATER BY SUBROUTINE WRCMPS.


!  RETURN WITH THE CORRECT NEW MESSAGE BYTE COUNT
!  ----------------------------------------------

!     NOW, NOTING THAT MBIT CURRENTLY POINTS TO THE LAST BIT OF
!     THE FOURTH BYTE OF SECTION 4, THEN WE HAVE:
!     (TOTAL LENGTH OF BUFR MESSAGE (IN SECTION 0)) =
!            (LENGTH OF MESSAGE UP THROUGH FOURTH BYTE OF SECTION 4)
!         +  (LENGTH OF "COMPRESSED DATA PORTION" OF SECTION 4)
!         +  (LENGTH OF SECTION 5)
      MBYT = &
             MBIT/8 &
          +  NBYT &
          +  4

!     NOW, MAKE NBYT POINT TO THE CURRENT LOCATION OF MBIT
!     (I.E. THE BYTE AFTER WHICH TO ACTUALLY BEGIN WRITING THE
!     COMPRESSED DATA INTO SECTION 4).

      NBYT = MBIT/8

!     NOW, STORE THE TOTAL LENGTH OF THE BUFR MESSAGE (IN SECTION 0).

      MBIT = 32
      CALL PKB(MBYT,24,MESG,MBIT)

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: CMSGINI - TABLE A MESSAGE TYPE '// &
       'MNEMONIC ",A," NOT FOUND IN INTERNAL TABLE D ARRAYS")') SUBSET
      CALL BORT(BORT_STR)
901   CALL BORT &
       ('BUFRLIB: CMSGINI - BUFR MESSAGE DATE (IDATE) is 0000000000')
      END SUBROUTINE CMSGINI
