      FUNCTION IREV(N)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    IREV
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS FUNCTION WILL, WHEN THE LOCAL MACHINE IS "LITTLE-
!   ENDIAN" (I.E., USES A RIGHT TO LEFT SCHEME FOR NUMBERING THE BYTES
!   WITHIN A MACHINE WORD), RETURN A COPY OF AN INPUT INTEGER WORD WITH
!   THE BYTES REVERSED.  ALTHOUGH, BY DEFINITION (WITHIN WMO MANUAL
!   306), A BUFR MESSAGE IS A STREAM OF INDIVIDUAL OCTETS (I.E., BYTES)
!   THAT IS INDEPENDENT OF ANY PARTICULAR MACHINE REPRESENTATION, THE
!   BUFR ARCHIVE LIBRARY SOFTWARE OFTEN NEEDS TO INTERPRET ALL OR PARTS
!   OF TWO OR MORE ADJACENT BYTES IN ORDER TO CONSTRUCT AN INTEGER
!   WORD.  BY DEFAULT, THE SOFTWARE USES THE "BIG-ENDIAN" (LEFT TO
!   RIGHT) SCHEME FOR NUMBERING BYTES.  BY REVERSING THE BYTES, IREV
!   ALLOWS THE INTEGER WORD TO BE PROPERLY READ OR WRITTEN (DEPENDING
!   ON WHETHER INPUT OR OUTPUT OPERATIONS, RESPECTIVELY, ARE BEING
!   PERFORMED) ON LITTLE-ENDIAN MACHINES.  IF THE LOCAL MACHINE IS
!   BIG-ENDIAN, IREV SIMPLY RETURNS A COPY OF THE SAME INTEGER THAT WAS
!   INPUT.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION
! 2007-01-19  J. ATOR    -- BIG-ENDIAN VS. LITTLE-ENDIAN IS NOW
!                           DETERMINED AT COMPILE TIME AND CONFIGURED
!                           WITHIN BUFRLIB VIA CONDITIONAL COMPILATION
!                           DIRECTIVES
!
! USAGE:    IREV (N)
!   INPUT ARGUMENT LIST:
!     N        - INTEGER: INTEGER WORD WITH BYTES ORDERED ACCORDING TO
!                THE "BIG-ENDIAN" NUMBERING SCHEME
!
!   OUTPUT ARGUMENT LIST:
!     IREV     - INTEGER: INTEGER WORD WITH BYTES ORDERED ACCORDING TO
!                THE NUMBERING SCHEME OF THE LOCAL MACHINE (EITHER
!                "BIG-ENDIAN" OR "LITTLE-ENDIAN", IF "BIG-ENDIAN THEN
!                THIS IS JUST A DIRECT COPY OF N)
!
! REMARKS:
!    THIS ROUTINE CALLS:        None
!    THIS ROUTINE IS CALLED BY: IPKM     IUPM     PKB      PKC
!                               UPB      UPBB
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      CHARACTER*8 CINT,DINT
      EQUIVALENCE(CINT,INT)
      EQUIVALENCE(DINT,JNT)

!----------------------------------------------------------------------
!----------------------------------------------------------------------

#ifdef BIG_ENDIAN
      IREV = N
#else
      INT = N
      DO I=1,NBYTW
        DINT(I:I) = CINT(IORD(I):IORD(I))
      ENDDO
      IREV = JNT
#endif

      RETURN
      END FUNCTION IREV
