      SUBROUTINE OVRBS1(NVAL,MBAY,NBYT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    OVRBS1
!   PRGMMR: KEYSER           ORG: NP22       DATE: 2003-11-04
!
! ABSTRACT: THIS SUBROUTINE PACKS AND STORES THE VALUE OF THE BINARY
!   INTEGER WORD NVAL INTO BYTE NBYT OF SECTION 1 (OR INTO BYTE 8 OF
!   SECTION 0, IF NBYT = 0) OF A BUFR MESSAGE STORED IN ARRAY MBAY,
!   OVERWRITING THE VALUE PREVIOUSLY STORED THERE.  THE START OF THE
!   BUFR MESSAGE (I.E. THE STRING "BUFR") MUST BE ALIGNED ON THE FIRST
!   FOUR BYTES OF MBAY.  NOTE THAT THIS SUBROUTINE IS CONSIDERED
!   OBSOLETE AND MAY BE REMOVED FROM THE BUFR ARCHIVE LIBRARY IN A
!   FUTURE VERSION; USERS SHOULD INSTEAD MIGRATE TO THE USE OF BUFR
!   ARCHIVE LIBRARY SUBROUTINE PKBS1.
!
! PROGRAM HISTORY LOG:
! 2003-11-04  D. KEYSER  -- ORIGINAL AUTHOR
! 2004-08-18  J. ATOR    -- REMOVED IFIRST CHECK, SINCE WRDLEN NOW
!                           KEEPS TRACK OF WHETHER IT HAS BEEN CALLED;
!                           ADDED NBYT=0 OPTION; ADDED CHECK TO
!                           PREVENT OVERWRITE OF CERTAIN BYTES
! 2005-11-29  J. ATOR    -- MARKED AS OBSOLETE AND ADDED PRINT
!                           NOTIFICATION
!
! USAGE:    CALL OVRBS1 (NVAL, MBAY, NBYT)
!   INPUT ARGUMENT LIST:
!     NVAL     - INTEGER: INTEGER WORD TO BE PACKED
!     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
!                MESSAGE PRIOR TO ANY OVERWRITING OF INFORMATION
!     NBYT     - INTEGER: BYTE WITHIN SECTION 1 OF BUFR TO OVERWRITE:
!                       0 = OVERWRITE BYTE 8 OF SECTION 0
!
!   OUTPUT ARGUMENT LIST:
!     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
!                MESSAGE WITH NVAL NOW PACKED IN REQUESTED LOCATION
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     PKB      WRDLEN
!    THIS ROUTINE IS CALLED BY: MSGWRT
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      DIMENSION MBAY(*)

      CHARACTER*128 BORT_STR

      COMMON /QUIET / IPRT

      DATA IFIRST/0/

      SAVE IFIRST

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      IF(IFIRST.EQ.0) THEN
         IF(IPRT.GE.0) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT 101
101   FORMAT(' BUFRLIB: OVRBS1 - THIS SUBROUTINE IS NOW OBSOLETE; ', &
       'USE SUBROUTINE PKBS1 INSTEAD')
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
         ENDIF
         IFIRST = 1
      ENDIF

!     CALL SUBROUTINE WRDLEN TO INITIALIZE SOME IMPORTANT INFORMATION
!     ABOUT THE LOCAL MACHINE, JUST IN CASE SUBROUTINE OPENBF HASN'T
!     BEEN CALLED YET.

      CALL WRDLEN

!     PREVENT CERTAIN BYTES FROM BEING OVERWRITTEN.
 
      IF( NBYT.LT.0 .OR. NBYT.EQ.8 .OR. NBYT.GT.18 .OR. &
           ( NBYT.GE.1 .AND. NBYT.LE.3 ) ) GOTO 900

!     NOTE THAT THERE ARE ALWAYS 8 BYTES WITHIN SECTION 0.

      NBIT=8*(8+(NBYT-1))
      CALL PKB(NVAL,8,MBAY,NBIT)

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: OVRBS1 - CANNOT OVERWRITE BYTE '// &
       'NUMBER (",I3,")")') NBYT
      CALL BORT(BORT_STR)
      END SUBROUTINE OVRBS1
